#[doc = "🔨"]
pub const HAMMER: crate::Emoji = crate::Emoji {
    glyph: "🔨",
    codepoint: "1F528",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "hammer",
    group: "Objects",
    subgroup: "tool",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("hamer"),
            keywords: &["gereedskap", "hamer", "kap"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መዶሻ"),
            keywords: &["መሣሪያ", "መዶሻ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}مطرقة"),
            keywords: &["عدة", "\u{202b}مطرقة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হ\u{9be}ত\u{9c1}ৰী"),
            keywords: &["স\u{981}জ\u{9c1}লি", "হ\u{9be}ত\u{9c1}ৰী"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("çəkic"),
            keywords: &["alət", "çəkic"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("малаток"),
            keywords: &["малаток", "інструмент"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("чук"),
            keywords: &["инструмент", "чук"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হ\u{9be}ত\u{9c1}ড\u{9bc}ি"),
            keywords: &["সরঞ\u{9cd}জ\u{9be}ম", "হ\u{9be}ত\u{9c1}ড\u{9bc}ি"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("morzhol"),
            keywords: &["benveg", "morzhol"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("čekić"),
            keywords: &["alat", "čekić"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("martell"),
            keywords: &["eina", "martell"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏅᏩᎶᏍᏗ"),
            keywords: &["ᎦᏅᏩᎶᏍᏗ", "ᎬᏔᏂᏓᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kladivo"),
            keywords: &["kladivo", "kladívko", "nářadí"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("morthwyl"),
            keywords: &["morthwyl", "offeryn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("hammer"),
            keywords: &["hammer", "værktøj"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Hammer"),
            keywords: &["Hammer", "Werkzeug"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σφυρί"),
            keywords: &["εργαλείο", "σφυρί"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("hammer"),
            keywords: &["hammer", "tool"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("martillo"),
            keywords: &["herramienta", "martillo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("haamer"),
            keywords: &["haamer", "tööriist"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("mailua"),
            keywords: &["mailua", "tresna"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("چکش"),
            keywords: &["ابزار", "پتک", "چکش"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vasara"),
            keywords: &["työkalu", "vasara"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("martilyo"),
            keywords: &["kagamitan", "martilyo"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hamari"),
            keywords: &["amboð", "hamari", "smíða"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("marteau"),
            keywords: &["marteau", "outil"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("casúr"),
            keywords: &["casúr", "uirlis"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("òrd"),
            keywords: &["acainn", "inneal", "òrd"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("martelo"),
            keywords: &["ferramenta", "martelo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("હથોડી"),
            keywords: &["સાધન", "હથોડી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("guduma"),
            keywords: &["guduma", "kayan aiki"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פטיש"),
            keywords: &["בנייה", "כלי עבודה", "פטיש"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("हथौड\u{93c}ा"),
            keywords: &["औज\u{93c}ार", "हथौड\u{93c}ा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("čekić"),
            keywords: &["alat", "čekić"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kalapács"),
            keywords: &["kalapács", "szerszám"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մուրճ"),
            keywords: &["գործիք", "մուրճ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("palu"),
            keywords: &["alat", "palu"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nkụigwe"),
            keywords: &["ngwaọrụ", "nkụigwe"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hamar"),
            keywords: &["hamar", "verkfæri"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("martello"),
            keywords: &["attrezzo", "martello", "utensile"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ハンマー"),
            keywords: &["かなづち", "とんかち", "ハンマー", "工具"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pukul"),
            keywords: &["bekakas", "pukul"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჩაქუჩი"),
            keywords: &["ინსტრუმენტი", "ჩაქუჩი", "ხელსაწყო"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: None,
            keywords: &["afecku"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("балға"),
            keywords: &["балға", "құрал"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("hammer"),
            keywords: &["hammer", "værktøj"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ញញ\u{17bd}រ"),
            keywords: &["ញញ\u{17bd}រ", "ឧបករណ\u{17cd}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸುತ\u{ccd}ತ\u{cbf}ಗ\u{cc6}"),
            keywords: &[
                "ಕತ\u{ccd}ತರ\u{cbf}ಗಳು",
                "ಟ\u{cc2}ಲ\u{ccd}",
                "ಪರ\u{cbf}ಕರ",
                "ಸುತ\u{ccd}ತ\u{cbf}ಗ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("망치"),
            keywords: &["도구", "망치", "해머"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("घण"),
            keywords: &["घण", "साधन"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("балка"),
            keywords: &["балка", "курал"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Hummer"),
            keywords: &["Handwierksgeschir", "Hummer"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໄມ\u{ec9}ຄ\u{ec9}ອນ"),
            keywords: &["ເຄ\u{eb7}\u{ec8}ອງມ\u{eb7}", "ໄມ\u{ec9}ຄ\u{ec9}ອນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("plaktukas"),
            keywords: &["plaktukas", "įrankis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("āmurs"),
            keywords: &["darbarīks", "āmurs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("hama"),
            keywords: &["hama", "utauta"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("чекан"),
            keywords: &["алатка", "чекан"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ച\u{d41}റ\u{d4d}റിക"),
            keywords: &["ഉപകരണം", "ച\u{d41}റ\u{d4d}റിക"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("алх"),
            keywords: &["алх", "багаж"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("हातोडा"),
            keywords: &["हातोडा"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tukul"),
            keywords: &["alat", "tukul"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("martell"),
            keywords: &["għodda", "martell"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တ\u{1030}"),
            keywords: &["က\u{102d}ရ\u{102d}ယာ", "တ\u{1030}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hammer"),
            keywords: &["hammer", "verktøy"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("घन"),
            keywords: &["उपकरण", "घन"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("hamer"),
            keywords: &["gereedschap", "hamer"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("hammar"),
            keywords: &["hammar", "verktøy"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ହ\u{b3e}ତ\u{b41}ଡ\u{b3c}\u{b3f}"),
            keywords: &[
                "ଉପକରଣ",
                "ହ\u{b3e}ତ\u{b41}ଡ\u{b3c}\u{b3f}",
                "ହ\u{b3e}ମ\u{b3e}ର\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਹਥ\u{a4c}ੜਾ"),
            keywords: &["ਔਜ\u{a3c}ਾਰ", "ਹਥ\u{a4c}ੜਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("تھوڑی"),
            keywords: &["اوزار", "تھوڑی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Háma"),
            keywords: &["Háma", "Tul"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("młotek"),
            keywords: &["młot", "młotek", "narzędzie"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("څټک"),
            keywords: &["اله", "څټک"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("martelo"),
            keywords: &["ferramenta", "martelo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ciocan"),
            keywords: &["ciocan", "instrument"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-740"),
            keywords: &["E10-740"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("молоток"),
            keywords: &["инструмент", "молот", "молоток", "удар"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("inyundo"),
            keywords: &["igikoresho", "inyundo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("هٿوڙو"),
            keywords: &["اوزار", "هٿوڙو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ම\u{dd2}ට\u{dd2}ය"),
            keywords: &["ම\u{dd2}ට\u{dd2}ය", "මෙවලම"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kladivo"),
            keywords: &["kladivo", "nástroj"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kladivo"),
            keywords: &["kladivo", "orodje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dube"),
            keywords: &["dube", "qalab"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("çekiç"),
            keywords: &["vegël", "çekiç"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("чекић"),
            keywords: &["aлaт", "чекић"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("čekić"),
            keywords: &["alat", "čekić"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("hammare"),
            keywords: &["hammare", "verktyg"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nyundo"),
            keywords: &["nyundo", "zana"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சுத\u{bcd}தி"),
            keywords: &["கருவி", "சுத\u{bcd}தி", "சுத\u{bcd}தியல\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("సుత\u{c4d}త\u{c3f}"),
            keywords: &["స\u{c3e}ధనం", "సుత\u{c4d}త\u{c3f}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("болға"),
            keywords: &["асбоб", "болға"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ค\u{e49}อน"),
            keywords: &["ค\u{e49}อน", "เคร\u{e37}\u{e48}องม\u{e37}อ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çekiç"),
            keywords: &["gural", "çekiç"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("hamala"),
            keywords: &["hamala"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("çekiç"),
            keywords: &["araç", "çekiç"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("بولقا"),
            keywords: &["بولقا", "قورال"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("молоток"),
            keywords: &["молоток", "інструмент"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ہتھوڑا"),
            keywords: &["آلہ", "ہتھوڑا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("bolg‘a"),
            keywords: &["asbob", "bolg‘a"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("búa"),
            keywords: &["búa", "dụng cụ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("marto"),
            keywords: &["jumtukaay", "marto"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ihamile"),
            keywords: &["ihamile", "isixhobo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("oòlù"),
            keywords: &["irinsẹ\u{301}", "oòlù"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("錘"),
            keywords: &["工具", "錘"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("锤"),
            keywords: &["工具", "锤"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("锤子"),
            keywords: &["工具", "敲", "施工", "砸", "铁锤", "锤子"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("鎚子"),
            keywords: &["鎚子"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("鎚仔"),
            keywords: &["鎚仔", "鎚仔｜工具"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isando"),
            keywords: &["isando", "ithuluzi"],
        },
    ],
};
#[doc = "🪓"]
pub const AXE: crate::Emoji = crate::Emoji {
    glyph: "🪓",
    codepoint: "1FA93",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "axe",
    group: "Objects",
    subgroup: "tool",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("byl"),
            keywords: &["byl", "handbyl", "hout", "kap", "kloof"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መጥረቢያ"),
            keywords: &["መቁረጥ", "መክፈል", "መጥረቢያ", "እንጨት", "ፋስ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بلطة"),
            keywords: &["بلطة", "تقسيم", "تقطيع", "خشب", "فأس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9c1}ঠ\u{9be}ৰ"),
            keywords: &[
                "ক\u{9be}ঠ",
                "ক\u{9c1}ট\u{9cd}",
                "ক\u{9c1}ঠ\u{9be}ৰ",
                "ফ\u{9be}ল",
                "ব\u{9be}চ\u{9c1}ল\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("balta"),
            keywords: &["balta", "bölmək", "doğramaq", "kəsmək", "taxta"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сякера"),
            keywords: &["дрэва", "рассякаць", "сякера", "сячы"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("брадва"),
            keywords: &["брадва", "дърво", "разцепвам", "секира", "сеч"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9c1}ঠ\u{9be}র"),
            keywords: &[
                "ক\u{9be}ঠ",
                "ক\u{9c1}ঠ\u{9be}র",
                "ক\u{9cd}ষ\u{9c1}দ\u{9cd}র ক\u{9c1}ঠ\u{9be}র",
                "ট\u{9c1}করো কর\u{9be}",
                "ফ\u{9be}লি কর\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("boucʼhal"),
            keywords: &["benveg", "boucʼhal", "boucʼhalig", "koad"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("sjekira"),
            keywords: &["cijepati", "drvo", "sjekira", "sjeći"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("destral"),
            keywords: &["destral", "llenya", "tallar"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᎷᏯᏍᏗ"),
            keywords: &["ᎠᎬᎭᎷᏯᏍᎦ", "ᎠᏓ", "ᎦᎷᏯᏍᏗ", "ᏓᏍᏡᏍᎦ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("sekera"),
            keywords: &[
                "dříví",
                "sekat",
                "sekera",
                "sekerka",
                "sekyra",
                "sekyrka",
                "sekání",
                "štípat",
                "štípání",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bwyell"),
            keywords: &["bwyell", "coed", "hollti", "pren", "torri"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("økse"),
            keywords: &["kløve brænde", "træ", "økse"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Axt"),
            keywords: &["Axt", "Beil", "Holz", "hacken", "spalten"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τσεκούρι"),
            keywords: &["ξύλο", "σχίζω", "τεμαχίζω", "τσεκουράκι", "τσεκούρι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("axe"),
            keywords: &["axe", "chop", "hatchet", "split", "wood"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("hacha"),
            keywords: &["cortar", "dividir", "hacha", "hachuela", "madera", "talar"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kirves"),
            keywords: &["kirves", "lõhkumine", "puud", "raiumine"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("aizkora"),
            keywords: &["aizkora", "aizkorakada", "arrakala", "zur"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تبر"),
            keywords: &["تبر", "تیشه", "جدا کردن", "قطع کردن", "چوب"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kirves"),
            keywords: &["hakata", "halkoa", "kirves", "pilkkoa", "puu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("palakol"),
            keywords: &[
                "biyakin",
                "kahoy",
                "maliit na palakol",
                "palakol",
                "pamputol",
                "pansibak",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("øks"),
            keywords: &["amboð", "hondøks", "høgg", "høgga", "øks"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("hache"),
            keywords: &["bois", "fendre", "hache", "hachette"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("tua"),
            keywords: &["adhmad", "ciorraigh", "gearr", "tua"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("tuagh"),
            keywords: &[
                "bris", "briseadh", "fiodh", "maide", "sgoilt", "sgoltadh", "tuagh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("machado"),
            keywords: &["cortar", "machada", "machado", "madeira", "talar"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ક\u{ac1}હાડી"),
            keywords: &[
                "કાપો",
                "ક\u{ac1}હાડી",
                "ટ\u{ac2}કડા કરો",
                "લાકડ\u{ac1}\u{a82}",
                "હ\u{ac7}શ\u{ac7}ટ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גרזן"),
            keywords: &["גרזן", "לבקע", "לחתוך", "לקצוץ", "עץ"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("क\u{941}ल\u{94d}हाड\u{93c}ी"),
            keywords: &[
                "औज\u{93c}ार",
                "काटना",
                "क\u{941}ल\u{94d}हाड\u{93c}ी",
                "लकड\u{93c}ी",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("sjekira"),
            keywords: &["alat", "drvo", "sjekira", "sjeći"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("balta"),
            keywords: &["balta", "fa", "fejsze", "szekerce", "vágás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կացին"),
            keywords: &["կացին", "կտրել", "փայտ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kapak"),
            keywords: &["belah", "kapak", "kayu", "potong"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("öxi"),
            keywords: &["handöxi", "höggva", "kljúfa", "timbur", "viður", "öxi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("ascia"),
            keywords: &["accetta", "ascia", "boscaiolo", "taglialegna"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("斧"),
            keywords: &["おの", "ハチェット", "工具", "斧", "木", "薪割り"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kampak"),
            keywords: &["belah", "kampak", "kampak cilik", "kayu", "plathok"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ნაჯახი"),
            keywords: &["მოჭრა", "ნაჯახი", "ტყე", "შეშა", "ცული"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("балта"),
            keywords: &["ағаш", "балта", "жару", "шабу"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ព\u{17bc}ថៅ"),
            keywords: &[
                "កាប\u{17cb}",
                "ឈើ",
                "ព\u{17bb}ះ",
                "ព\u{17bc}ថៅ",
                "ព\u{17bc}ថៅដៃ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕೊಡಲ\u{cbf}"),
            keywords: &[
                "ಕಟ\u{ccd}ಟ\u{cbf}ಗ\u{cc6}",
                "ಕತ\u{ccd}ತರ\u{cbf}ಸು",
                "ಕೊಡಲ\u{cbf}",
                "ವ\u{cbf}ಭಾಗ\u{cbf}ಸು",
                "ಹ\u{ccd}ಯಾಚ\u{cc6}ಟ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("도끼"),
            keywords: &["나무", "도끼", "손도끼", "쪼개기"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("क\u{941}-हाड"),
            keywords: &[
                "क\u{941}-हाड",
                "क\u{941}डको",
                "क\u{941}राड\u{947}\u{902}",
                "लाक\u{942}ड",
                "स\u{941}रो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("балта"),
            keywords: &["балта", "бөлүү", "жаруу", "отун"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຂວານ"),
            keywords: &[
                "ຂວານ",
                "ຕ\u{eb1}ດ",
                "ຟ\u{eb1}ນ",
                "ຟ\u{eb1}ນ\u{200b}ໄມ\u{ec9}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kirvis"),
            keywords: &["kapoti", "kirvis", "mediena"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("cirvis"),
            keywords: &["cirvis", "koks", "skaida", "skaldīt"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("секира"),
            keywords: &["дрво", "секира", "секирче", "сечење"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കോട\u{d3e}ലി"),
            keywords: &[
                "കോട\u{d3e}ലി",
                "ചെറ\u{d41}കോട\u{d3e}ലി",
                "തടി",
                "പിളർപ\u{d4d}പ\u{d4d}",
                "മ\u{d41}റിക\u{d4d}ക\u{d41}ക",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("сүх"),
            keywords: &["мод", "сүх", "хагалах", "цавчих"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("क\u{941}ऱ\u{94d}हाड"),
            keywords: &[
                "उभ\u{947} चिरण\u{947}",
                "क\u{941}ऱ\u{94d}हाड",
                "तोडण\u{947}",
                "लाक\u{942}ड",
                "हलकी क\u{941}ऱ\u{94d}हाड",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kapak"),
            keywords: &["belah", "kapak", "kapak kecil", "kayu", "tetak"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပ\u{102f}ဆ\u{102d}န\u{103a}"),
            keywords: &[
                "ခ\u{102f}တ\u{103a}ခြင\u{103a}း",
                "ခ\u{103d}\u{1032}ခြင\u{103a}း",
                "ပ\u{102f}ဆ\u{102d}န\u{103a}",
                "ရ\u{1032}တင\u{103a}း",
                "သစ\u{103a}သား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("øks"),
            keywords: &["dele", "hogge", "hugge", "kløyve", "ved", "øks"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बन\u{94d}चरो"),
            keywords: &[
                "चिर\u{94d}न\u{941}",
                "दाउरा",
                "धार",
                "बन\u{94d}चरो",
                "विभाजित",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bijl"),
            keywords: &["bijl", "hakken", "hout", "splijten"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("øks"),
            keywords: &["dele", "hogge", "kløyve", "ved", "øks"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b41}ର\u{b3e}ଢ\u{b3c}\u{b3f}"),
            keywords: &[
                "କ\u{b3e}ଟ\u{b3f}ବ\u{b3e}",
                "କ\u{b3e}ଠ",
                "କ\u{b41}ର\u{b3e}ଢ\u{b3c}\u{b3f}",
                "ଚ\u{b3f}ର\u{b3f}ବ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a41}ਹਾੜੀ"),
            keywords: &["ਕ\u{a41}ਹਾੜੀ", "ਲ\u{a71}ਕੜ ਕ\u{a71}ਟਣ ਵਾਲਾ ਕ\u{a41}ਹਾੜਾ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Aks"),
            keywords: &["Aks", "Chọp", "Háchẹt", "Kọt", "Split", "Wud"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("siekiera"),
            keywords: &["drewno", "rozłupywać", "rąbać", "siekiera", "topór"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("تبر"),
            keywords: &["تبر", "تبرګى", "جلا کول", "لرګی", "څيرل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("machado"),
            keywords: &["cortar", "machado", "madeira", "partir"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("machado"),
            keywords: &["cortar", "cutelo", "lenha", "machado", "rachar"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("topor"),
            keywords: &["despica", "lemn", "reteza", "secure", "topor", "toporișcă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–072"),
            keywords: &["E12–072"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("топор"),
            keywords: &["дрова", "дровосек", "рубить", "рубка", "топор"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪهاڙو"),
            keywords: &["اسپلٽ", "هيچيٽ", "چاپ", "ڪاٺي", "ڪهاڙو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පොරොව"),
            keywords: &[
                "අත\u{dca} පොරොව",
                "කැප\u{dd4}ම",
                "දැව",
                "පැළ\u{dd4}ම",
                "පොරොව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("sekera"),
            keywords: &["drevo", "rúbať", "sekať", "sekera", "štiepať"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("sekira"),
            keywords: &["cepljenje", "drva", "les", "sekanje", "sekira"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("faas"),
            keywords: &["faas", "faas yar", "jar-jarid", "kala jabin", "qori"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("sëpatë"),
            keywords: &["copëtoj", "dru", "ndaj", "sakicë", "sëpatë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("секира"),
            keywords: &["дрво", "секира", "сећи"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("сјекира"),
            keywords: &["сјекира"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("sekira"),
            keywords: &["drvo", "sekira", "seći"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("sjekira"),
            keywords: &["sjekira"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("yxa"),
            keywords: &["hacka", "hugga", "klyva", "ved", "yxa"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("shoka"),
            keywords: &["kishoka", "kukata", "kukatika", "kuni", "shoka"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கோட\u{bbe}ரி"),
            keywords: &[
                "கோட\u{bbe}ரி",
                "மரக\u{bcd}கட\u{bcd}டை",
                "மரம\u{bcd} வெட\u{bcd}டுதல\u{bcd}",
                "வெட\u{bcd}டுதல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("గ\u{c4a}డ\u{c4d}డల\u{c3f}"),
            keywords: &[
                "గ\u{c4a}డ\u{c4d}డల\u{c3f}",
                "చ\u{c46}క\u{c4d}క",
                "నరకడం",
                "వ\u{c3f}భజ\u{c3f}ంచడం",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ขวาน"),
            keywords: &[
                "ขวาน",
                "ขวานด\u{e49}ามเล\u{e47}ก",
                "ส\u{e31}บ",
                "แยก",
                "ไม\u{e49}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("palta"),
            keywords: &["böl", "kiçi palta", "palta", "tagta", "çap"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("toki"),
            keywords: &["toki"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("balta"),
            keywords: &["ağaç", "balta", "kesme", "kısa balta", "yarma"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("сокира"),
            keywords: &["дрова", "розколювати", "рубати", "сокира", "тесати", "тяти"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کلہاڑا"),
            keywords: &["لکڑی", "ٹکڑے کرنا", "کاٹنا", "کلہاڑا", "کلہاڑی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("bolta"),
            keywords: &["bolta", "boltacha", "chopish", "oʻtin", "yogʻoch", "yorish"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("rìu"),
            keywords: &["bổ", "bổ đôi", "chém", "gỗ", "rìu", "rìu nhỏ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("斧頭"),
            keywords: &["分開", "斧頭", "斬", "木"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("斧头"),
            keywords: &["分开", "斧头", "斩", "木"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("斧头"),
            keywords: &["切", "劈", "斧头", "木头", "砍"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("斧頭"),
            keywords: &["分割", "手斧", "斧頭", "木頭", "砍"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["分割", "斧頭", "木頭", "短柄斧頭", "砍"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("imbazo"),
            keywords: &["i-hatchet", "imbazo", "kapa", "ukhuni", "ukuhlukanisa"],
        },
    ],
};
#[doc = "⛏\u{fe0f}"]
pub const PICK: crate::Emoji = crate::Emoji {
    glyph: "⛏\u{fe0f}",
    codepoint: "26CF FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "pick",
    group: "Objects",
    subgroup: "tool",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "⛏",
        codepoint: "26CF",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "pick",
        group: "Objects",
        subgroup: "tool",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("pik"),
            keywords: &["gereedskap", "kap", "myn", "pik"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አነስተኛ ዶማ"),
            keywords: &["መሣሪያ", "ማዕድን ማውጣት", "አነስተኛ ዶማ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("فأس"),
            keywords: &["أداة", "تنقيب", "فأس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("গ\u{9be}\u{981}তীয\u{9bc}\u{9be}"),
            keywords: &[
                "খনন",
                "গ\u{9be}\u{981}তীয\u{9bc}\u{9be}",
                "স\u{981}জ\u{9c1}লি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("külüng"),
            keywords: &["alət", "külüng", "mədən"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кірка"),
            keywords: &["здабыча", "кірка", "шахта", "інструмент"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("кирка"),
            keywords: &["инструмент", "кирка", "копане"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9c1}ড\u{9bc}\u{9be}ল"),
            keywords: &["ক\u{9c1}ড\u{9bc}\u{9be}ল", "খনন", "সরঞ\u{9cd}জ\u{9be}ম"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pigell"),
            keywords: &["benveg", "pigell"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("krampa"),
            keywords: &["alat", "krampa", "rudarstvo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pic"),
            keywords: &["eina", "mineria", "pic"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎧᎾᏍᏕᏟᏗ"),
            keywords: &["ᎠᏂᏍᎪᏍᎬᎢ", "ᎬᏔᏂᏓᏍᏗ", "ᏗᎧᎾᏍᏕᏟᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("krumpáč"),
            keywords: &["dolování", "krumpáč", "nářadí"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("caib"),
            keywords: &["caib", "cloddio", "offeryn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("hakke"),
            keywords: &["hakke", "mine", "værktøj"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Pickel"),
            keywords: &["Pickel", "Werkzeug"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αξίνα"),
            keywords: &["αξίνα", "εξόρυξη", "εργαλείο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("pick"),
            keywords: &["mining", "pick", "tool"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["mining", "pick", "pickaxe", "tool"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pico"),
            keywords: &["herramienta", "mina", "pico"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["herramienta", "minería", "pico"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kirka"),
            keywords: &["kirka", "tööriist"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("pikotxa"),
            keywords: &["meatzaritza", "pikotxa", "tresna"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کلنگ"),
            keywords: &["ابزار", "کلنگ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hakku"),
            keywords: &["hakku", "kaivaa", "kaivos", "työkalu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("piko"),
            keywords: &["kagamitan", "pagmimina", "piko"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hakkari"),
            keywords: &[
                "amboð",
                "hakkari",
                "nám",
                "námvinna",
                "námvirki",
                "námídnaður",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("pioche"),
            keywords: &["mine", "outil", "pioche"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("pic"),
            keywords: &["mine", "outil", "pic"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("piocóid"),
            keywords: &["grafán", "mianadóireacht", "piocóid", "uirlis"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("piocaid"),
            keywords: &["acainn", "mèinnearachd", "piocaid", "tochladh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("pico"),
            keywords: &["ferramenta", "mina", "pico"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("તીકમ"),
            keywords: &["ખનન", "તીકમ", "સાધન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("diga"),
            keywords: &["diga", "haƙo", "kayan aiki"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מכוש"),
            keywords: &["חופר", "חפירה", "כלי עבודה", "לחפור", "מכוש"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("क\u{941}दाली"),
            keywords: &[
                "क\u{941}दाली",
                "क\u{941}ल\u{94d}हाड\u{93c}ी",
                "खनन ट\u{942}ल",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("pijuk"),
            keywords: &["alat", "pijuk", "rudarstvo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("csákány"),
            keywords: &["bányászat", "csákány", "szerszám"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("քլունգ"),
            keywords: &["գործիք", "հանք", "քլունգ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("beliung"),
            keywords: &["alat", "beliung", "tambang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("họrọ"),
            keywords: &["họrọ", "ngwaọrụ", "ngwupụta"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("haki"),
            keywords: &["haki", "námugröftur", "verkfæri"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("piccone"),
            keywords: &["attrezzo", "miniera", "picconare", "piccone", "scavare"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("つるはし"),
            keywords: &["つるはし", "工具", "採掘"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pipril"),
            keywords: &["bekakas", "nambang", "pipril"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("წერაქვი"),
            keywords: &["ინსტრუმენტი", "სამთო საქმე", "წერაქვი", "ხელსაწყო"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қайла"),
            keywords: &["қайла", "құрал", "өндіру"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("hakke"),
            keywords: &["hakke", "mine", "værktøj"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ត\u{17d2}រសេះ (ចបគាស\u{17cb}ថ\u{17d2}ម)"),
            keywords: &["ត\u{17d2}រសេះ", "ត\u{17d2}រសេះ (ចបគាស\u{17cb}ថ\u{17d2}ម)"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಆಯ\u{ccd}ಕ\u{cc6}"),
            keywords: &["ಆಯ\u{ccd}ಕ\u{cc6}", "ಪರ\u{cbf}ಕರ", "ಮೈನ\u{cbf}ಂಗ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("곡괭이"),
            keywords: &["곡괭이", "광산"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पिकास"),
            keywords: &["खणप", "पिकास", "साधन"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("керки"),
            keywords: &["казуу", "керки", "курал"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Piosch"),
            keywords: &["Grouf", "Handwierksgeschir", "Piosch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຫ\u{ebc}\u{eb1}ກສ\u{eb1}ບຂ\u{eb8}ດ"),
            keywords: &[
                "ເຄ\u{eb7}\u{ec8}ອງມ\u{eb7}",
                "ເຫ\u{ebc}\u{eb1}ກສ\u{eb1}ບຂ\u{eb8}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kirstuvas"),
            keywords: &["kasimas", "kirstuvas", "įrankis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("cirtnis"),
            keywords: &["cirst", "cirtnis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("keriwhenua"),
            keywords: &["keri kōhuke", "keriwhenua", "utauta"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("копач"),
            keywords: &["алатка", "копач", "рударска"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പിക\u{d4d}ക\u{d4d}"),
            keywords: &[
                "ഉപകരണം",
                "ക\u{d41}ഴിക\u{d4d}ക\u{d41}ക",
                "പിക\u{d4d}ക\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зээтүү"),
            keywords: &["багаж", "зээтүү", "уурхай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पिक"),
            keywords: &["खाणकाम", "पिक", "साधन"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("beliung"),
            keywords: &["alat", "beliung", "perlombongan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("agħżel"),
            keywords: &["agħżel", "għodda", "mini"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပေါက\u{103a}ချ\u{103d}န\u{103a}း"),
            keywords: &[
                "တ\u{1030}းဖော\u{103a}ရေး က\u{102d}ရ\u{102d}ယာ",
                "တ\u{1030}းလ\u{103a}",
                "ပေါက\u{103a}ချ\u{103d}န\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hakke"),
            keywords: &["gruvedrift", "hakke", "verktøy"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("उठाउन\u{947}"),
            keywords: &["उठाउन\u{947}", "उत\u{94d}खनन", "उपकरण"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("pikhouweel"),
            keywords: &["gereedschap", "mijnbouw", "pikhouweel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("hakke"),
            keywords: &["gruvedrift", "hakke", "verktøy"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଖଣତ\u{b3f}"),
            keywords: &[
                "ଖଣତ\u{b3f}",
                "ଖଣ\u{b3f} କ\u{b3e}ମ",
                "ଯନ\u{b4d}ତ\u{b4d}ରପ\u{b3e}ତ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਗ\u{a48}\u{a02}ਤੀ"),
            keywords: &[
                "ਔਜ\u{a3c}ਾਰ",
                "ਕਹਾੜੀ",
                "ਖਨਨ ਔਜ\u{a3c}ਾਰ",
                "ਗ\u{a48}\u{a02}ਤੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چ\u{64f}ننا"),
            keywords: &["اوزار", "چ\u{64f}ننا", "کان کنی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pik"),
            keywords: &["Main", "Pik", "Tul"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kilof"),
            keywords: &["górnicze", "kilof", "narzędzie"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("دوه سري کلنګ"),
            keywords: &["اله", "دوه سري کلنګ", "کان کنستل", "کلنګ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("picareta"),
            keywords: &["ferramenta", "mineração", "picareta"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["ferramenta", "mineração", "picareta"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("târnăcop"),
            keywords: &["instrument", "minerit", "pământ", "târnăcop"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-104"),
            keywords: &["E10-104"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("кирка"),
            keywords: &["добыча", "инструмент", "кирка", "шахта"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ipiki"),
            keywords: &["igikoresho", "ipiki", "ubucukuzi bwa mine"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٽيڪم"),
            keywords: &["اوزار", "ٽيڪم", "کڏ کوٽڻ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කට\u{dd4}ව"),
            keywords: &["කට\u{dd4}ව", "මෙවලම", "හෑර\u{dd3}ම"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("krompáč"),
            keywords: &["dolovanie", "krompáč", "nástroj"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kramp"),
            keywords: &["kramp", "orodje", "rudarjenje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("madaraq"),
            keywords: &["madaraq", "qalab", "qodid"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kazmë"),
            keywords: &["kazmë", "minierë", "vegël"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("пијук"),
            keywords: &["aлaт", "пијук", "рудaрствo"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("pijuk"),
            keywords: &["alat", "pijuk", "rudarstvo"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("hacka"),
            keywords: &["hacka", "verktyg"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("sululu"),
            keywords: &["kuchimba mgodi", "sululu", "zana"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கோடரி"),
            keywords: &["கருவி", "கோடரி", "சுரங\u{bcd}க வேலை"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("గడ\u{c4d}డప\u{c3e}ర"),
            keywords: &["గడ\u{c4d}డప\u{c3e}ర", "తవ\u{c4d}వడం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("зоғнӯл"),
            keywords: &["асбоб", "зоғнӯл", "саноати куҳӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("จอบ"),
            keywords: &["จอบ", "เคร\u{e37}\u{e48}องม\u{e37}อ", "เหม\u{e37}อง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çüý goparýan"),
            keywords: &["gazyp alyş", "gural", "çüý goparýan"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("toki tākelekele"),
            keywords: &["toki tākelekele"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kazma"),
            keywords: &["alet", "kazma", "maden"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چوت"),
            keywords: &["قورال", "كان", "چوت"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кирка"),
            keywords: &["кирка", "шахта", "інструмент"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کدال"),
            keywords: &["آلہ", "کدال"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("uchli bolg‘a"),
            keywords: &["asbob", "kon", "uchli bolg‘a"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("búa chim"),
            keywords: &["búa chim", "dụng cụ", "khai mỏ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("pik"),
            keywords: &["jumtukaay", "miin", "pik"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ipeki"),
            keywords: &["ipeki", "isixhobo", "ukugrumba"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("sà"),
            keywords: &["irinṣé\u{329}", "sà", "ìwakusà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("挑"),
            keywords: &["工具", "挑", "採礦"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("挑"),
            keywords: &["工具", "挑", "采矿"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("铁镐"),
            keywords: &["工具", "挖掘", "采矿", "铁镐", "锄头", "鹤嘴锄"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("十字鎬"),
            keywords: &["十字鎬", "鑿"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("十字鋤"),
            keywords: &["十字鋤", "鑿｜工具"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ipiki"),
            keywords: &["imayini", "ipiki", "ithuluzi"],
        },
    ],
};
#[doc = "⚒\u{fe0f}"]
pub const HAMMER_AND_PICK: crate::Emoji = crate::Emoji {
    glyph: "⚒\u{fe0f}",
    codepoint: "2692 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "hammer and pick",
    group: "Objects",
    subgroup: "tool",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "⚒",
        codepoint: "2692",
        status: crate::Status::Unqualified,
        introduction_version: 1f32,
        name: "hammer and pick",
        group: "Objects",
        subgroup: "tool",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("hamer en pik"),
            keywords: &["gereedskap", "hamer", "hamer en pik", "pik"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መዶሻ እና አነስተኛ ዶማ"),
            keywords: &["መሣሪያ", "መዶሻ", "መዶሻ እና አነስተኛ ዶማ", "አነስተኛ ዶማ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مطرقة ومثقاب"),
            keywords: &["أداة", "ثقب", "شاكوش", "مطرقة", "مطرقة ومثقاب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হ\u{9be}ত\u{9c1}ৰী আৰ\u{9c1} গ\u{9be}\u{981}তীয\u{9bc}\u{9be}"),
            keywords: &[
                "গ\u{9be}\u{981}তীয\u{9bc}\u{9be}",
                "স\u{981}জ\u{9c1}লি",
                "হ\u{9be}ত\u{9c1}ৰী",
                "হ\u{9be}ত\u{9c1}ৰী আৰ\u{9c1} গ\u{9be}\u{981}তীয\u{9bc}\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("çəkic və külüng"),
            keywords: &["alət", "külüng", "çəkic", "çəkic və külüng"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("малаток і кірка"),
            keywords: &["кірка", "малаток", "малаток і кірка", "шахта", "інструмент"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Чук и кирка"),
            keywords: &["Чук и кирка", "инструмент", "кирка", "чук"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হ\u{9be}ত\u{9c1}ড\u{9bc}ি এবং ক\u{9c1}ড\u{9bc}\u{9be}ল"),
            keywords: &[
                "গ\u{9be}ইতি",
                "সরঞ\u{9cd}জ\u{9be}ম",
                "হ\u{9be}ত\u{9c1}ড\u{9bc}ি",
                "হ\u{9be}ত\u{9c1}ড\u{9bc}ি এবং ক\u{9c1}ড\u{9bc}\u{9be}ল",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("morzhol ha pig"),
            keywords: &["benveg", "morzhol", "morzhol ha pig", "pig"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("čekić i krampa"),
            keywords: &["alat", "rudarstvo", "čekić", "čekić i krampa"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("martell i pic"),
            keywords: &["eina", "martell", "martell i pic", "pic"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎬᏅᏩᎶᏍᏗ ᎠᎴ ᏗᎧᎾᏍᏕᏟᏗ"),
            keywords: &["ᎬᏅᏩᎶᏍᏗ", "ᎬᏅᏩᎶᏍᏗ ᎠᎴ ᏗᎧᎾᏍᏕᏟᏗ", "ᎬᏔᏂᏓᏍᏗ", "ᏗᎧᎾᏍᏕᏟᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kladivo a špičák"),
            keywords: &["kladivo", "kladivo a špičák", "nářadí", "špičák"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("morthwyl a chaib"),
            keywords: &["caib", "morthwyl", "morthwyl a chaib", "offeryn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("hammer og hakke"),
            keywords: &["hakke", "hammer", "hammer og hakke", "værktøj"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Hammer und Pickel"),
            keywords: &["Hammer", "Hammer und Pickel", "Pickel", "Werkzeug"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σφυρί και αξίνα"),
            keywords: &["αξίνα", "εργαλείο", "σφυρί", "σφυρί και αξίνα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("hammer and pick"),
            keywords: &["hammer", "hammer and pick", "pick", "tool"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &[
                "hammer",
                "hammer and pick",
                "hammer and pickaxe",
                "pick",
                "tool",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("martillo y pico"),
            keywords: &["herramienta", "martillo", "martillo y pico", "pico"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["herramientas", "martillo", "martillo y pico", "pico"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("haamer ja kirka"),
            keywords: &["haamer", "haamer ja kirka", "kirka", "tööriist"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("mailua eta pikotxa"),
            keywords: &["mailu", "mailua eta pikotxa", "pikotx", "tresna"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("چکش و کلنگ"),
            keywords: &["ابزار", "چکش", "چکش و کلنگ", "کلنگ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hakku ja vasara"),
            keywords: &["hakku", "hakku ja vasara", "työkalu", "vasara"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("martilyo at piko"),
            keywords: &["kagamitan", "martilyo", "martilyo at piko", "piko"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hamari og hakkari"),
            keywords: &["amboð", "hakkari", "hamari", "hamari og hakkari"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("marteau et pioche"),
            keywords: &["marteau", "marteau et pioche", "outil", "pioche"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("marteau et pic"),
            keywords: &["marteau", "marteau et pic", "pic"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("casúr agus piocóid"),
            keywords: &[
                "casúr",
                "casúr agus grafán",
                "casúr agus piocóid",
                "grafán",
                "uirlis",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("òrd is piocaid"),
            keywords: &["acainn", "inneal", "piocaid", "òrd", "òrd is piocaid"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("martelo e pico"),
            keywords: &["ferramenta", "martelo", "martelo e pico", "pico"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("હથોડી અન\u{ac7} તિકમ"),
            keywords: &["તિકમ", "સાધન", "હથોડી", "હથોડી અન\u{ac7} તિકમ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("guduma da diga"),
            keywords: &["diga", "guduma", "guduma da diga", "kayan aiki"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פטיש ומכוש"),
            keywords: &[
                "בנייה",
                "חפירה",
                "כלי עבודה",
                "מכוש",
                "עבודה",
                "פטיש",
                "פטיש ומכוש",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("हथौड\u{93c}ा और क\u{941}ल\u{94d}हाड\u{93c}ी"),
            keywords: &["ट\u{942}ल", "हथौड\u{93c}ा और क\u{941}ल\u{94d}हाड\u{93c}ी"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("čekić i pijuk"),
            keywords: &["alat", "pijuk", "čekić", "čekić i pijuk"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kalapács és csákány"),
            keywords: &["csákány", "kalapács", "kalapács és csákány", "szerszám"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մուրճեր"),
            keywords: &["գործիք", "մուրճ", "մուրճեր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("palu dan beliung"),
            keywords: &["alat", "beliung", "palu", "palu dan beliung"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nkụigwe na họrọ"),
            keywords: &["họrọ", "ngwaorụ", "nkụigwe", "nkụigwe na họrọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hamar og haki"),
            keywords: &["haki", "hamar", "hamar og haki", "verkfæri"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("piccone e martello"),
            keywords: &[
                "attrezzi",
                "lavori manuali",
                "manodopera",
                "piccone e martello",
                "utensili",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ハンマーとつるはし"),
            keywords: &[
                "かなづち",
                "つるはし",
                "とんかち",
                "ハンマーとつるはし",
                "工具",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pukul lan pipril"),
            keywords: &["bekakas", "pipril", "pukul", "pukul lan pipril"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჩაქუჩი და წერაქვი"),
            keywords: &[
                "ინსტრუმენტი",
                "ჩაქუჩი",
                "ჩაქუჩი და წერაქვი",
                "წერაქვი",
                "ხელსაწყო",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("балға мен қайла"),
            keywords: &["балға", "балға мен қайла", "қайла", "құрал"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("hammer og hakke"),
            keywords: &["hakke", "hammer", "hammer og hakke", "værktøj"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ញញ\u{17bd}រធម\u{17d2}មតាន\u{17b7}ងញញ\u{17bd}រម\u{17bb}ខម\u{17d2}ខាងស\u{17d2}រ\u{17bd}ច",
            ),
            keywords: &[
                "ញញ\u{17bd}រ",
                "ញញ\u{17bd}រធម\u{17d2}មតាន\u{17b7}ងញញ\u{17bd}រម\u{17bb}ខម\u{17d2}ខាងស\u{17d2}រ\u{17bd}ច",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸುತ\u{ccd}ತ\u{cbf}ಗ\u{cc6} ಮತ\u{ccd}ತು ಆಯ\u{ccd}ಕ\u{cc6}"),
            keywords: &[
                "ಆಯ\u{ccd}ಕ\u{cc6}",
                "ಪರ\u{cbf}ಕರ",
                "ಸುತ\u{ccd}ತ\u{cbf}ಗ\u{cc6}",
                "ಸುತ\u{ccd}ತ\u{cbf}ಗ\u{cc6} ಮತ\u{ccd}ತು ಆಯ\u{ccd}ಕ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("망치와 곡괭이"),
            keywords: &["곡괭이", "망치", "망치와 곡괭이"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("खोर\u{947}\u{902} आनी पिकास"),
            keywords: &[
                "खोर\u{947}\u{902}",
                "खोर\u{947}\u{902} आनी पिकास",
                "पिकास",
                "साधन",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("балка менен керки"),
            keywords: &["балка", "балка менен керки", "керки", "курал"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Hummer a Piosch"),
            keywords: &["Handwierksgeschir", "Hummer", "Hummer a Piosch", "Piosch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໄມ\u{ec9}ຄ\u{ec9}ອນ ແລະ ເຫ\u{ebc}\u{eb1}ກສ\u{eb1}ບຂ\u{eb8}ດ"),
            keywords: &[
                "ຫ\u{ebc}\u{eb1}ກສ\u{eb1}ບຂ\u{eb8}ດ",
                "ເຄ\u{eb7}\u{ec8}ອງມ\u{eb7}",
                "ໄມ\u{ec9}ຄ\u{ec9}ອນ",
                "ໄມ\u{ec9}ຄ\u{ec9}ອນ ແລະ ເຫ\u{ebc}\u{eb1}ກສ\u{eb1}ບຂ\u{eb8}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("plaktuvas ir kirstuvas"),
            keywords: &[
                "kirstuvas",
                "plaktukas",
                "plaktuvas ir kirstuvas",
                "įrankis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("āmurs un cirtnis"),
            keywords: &["cirtnis", "āmurs", "āmurs un cirtnis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("hama me te keriwhenua"),
            keywords: &["hama", "hama me te keriwhenua", "keriwhenua", "utauta"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("чекан и копач"),
            keywords: &["алатки", "копач", "чекан и копач"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ച\u{d41}റ\u{d4d}റികയ\u{d41}ം പിക\u{d4d}ക\u{d41}ം"),
            keywords: &[
                "ഉപകരണം",
                "ച\u{d41}റ\u{d4d}റിക",
                "ച\u{d41}റ\u{d4d}റികയ\u{d41}ം പിക\u{d4d}ക\u{d41}ം",
                "പിക\u{d4d}ക\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("алх, зээтүү"),
            keywords: &["алх", "алх, зээтүү", "зээтүү"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("हातोडा आणि पिक"),
            keywords: &["साधन", "हातोडा", "हातोडा आणि पिक"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tukul dan beliung"),
            keywords: &["alat", "beliung", "tukul", "tukul dan beliung"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("martell u fies"),
            keywords: &["fies", "għodda", "martell", "martell u fies"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တ\u{1030}န\u{103e}င\u{1037}\u{103a} ပေါက\u{103a}ချ\u{103d}န\u{103a}း"),
            keywords: &[
                "က\u{102d}ရ\u{102d}ယာ",
                "တ\u{1030}",
                "တ\u{1030}န\u{103e}င\u{1037}\u{103a} ပေါက\u{103a}ချ\u{103d}န\u{103a}း",
                "ပေါက\u{103a}ချ\u{103d}န\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hammer og hakke"),
            keywords: &["hakke", "hammer", "hammer og hakke", "verktøy"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("घन र उठाउन\u{947}"),
            keywords: &["उठाउन\u{947}", "उपकरण", "घन", "घन र उठाउन\u{947}"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("twee hamers"),
            keywords: &["gereedschap", "hamer", "hamers", "twee hamers"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("hammar og hakke"),
            keywords: &["hakke", "hammar", "hammar og hakke", "verktøy"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ହ\u{b3e}ତ\u{b41}ଡ\u{b3f} ଏବଂ ଖଣତ\u{b3f}"),
            keywords: &[
                "ଖଣତ\u{b3f}",
                "ଯନ\u{b4d}ତ\u{b4d}ରପ\u{b3e}ତ\u{b3f}",
                "ହ\u{b3e}ତ\u{b41}ଡ\u{b3f}",
                "ହ\u{b3e}ତ\u{b41}ଡ\u{b3f} ଏବଂ ଖଣତ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਹਥ\u{a4c}ੜਾ ਅਤ\u{a47} ਕ\u{a41}ਹਾੜੀ"),
            keywords: &[
                "ਔਜ\u{a3c}ਾਰ",
                "ਚ\u{a41}\u{a71}ਕਣਾ",
                "ਹਥ\u{a4c}\u{a4c}ੜਾ ਅਤ\u{a47} ਕਹਾੜੀ",
                "ਹਥ\u{a4c}ੜਾ ਅਤ\u{a47} ਕ\u{a41}ਹਾੜੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہتھوڑی اتے کدالی"),
            keywords: &["اوزار", "تھوڑی", "چ\u{64f}ننا", "ہتھوڑی اتے کدالی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Háma An Pik"),
            keywords: &["Háma", "Háma An Pik", "Pik", "Tul"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("młoty"),
            keywords: &["kilof", "młot", "młoty", "narzędzia"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("څټک او کلنګ"),
            keywords: &["اله", "څټک", "څټک او کلنګ", "کلنګ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("martelo e picareta"),
            keywords: &["ferramenta", "martelo", "martelo e picareta", "picareta"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["ferramenta", "martelo", "martelo e picareta", "picareta"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ciocan și daltă"),
            keywords: &["cheie", "ciocan și daltă", "instrument", "târnăcop"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-083"),
            keywords: &["E10-083"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("кирка и молот"),
            keywords: &[
                "инструмент",
                "кирка",
                "кирка и молот",
                "молот",
                "молоток",
                "шахта",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("inyundo n’ipiki"),
            keywords: &["igikoresho", "inyundo", "inyundo n’ipiki", "ipiki"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("هٿوڙو ۽ ٽيڪم"),
            keywords: &["اوزار", "هٿوڙو", "هٿوڙو ۽ ٽيڪم", "کڻڻ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ම\u{dd2}ට\u{dd2}ය සහ කට\u{dd4}ව"),
            keywords: &[
                "කට\u{dd4}ව",
                "ම\u{dd2}ට\u{dd2}ය",
                "ම\u{dd2}ට\u{dd2}ය සහ කට\u{dd4}ව",
                "මෙවලම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kladivo a krompáč"),
            keywords: &["kladivo", "kladivo a krompáč", "krompáč", "nástroj"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kladivo in kramp"),
            keywords: &["kladivo", "kladivo in kramp", "kramp", "orodje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dube iyo madaraq"),
            keywords: &["dube", "dube iyo madaraq", "madaraq", "qalab"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("çekiç dhe kazmë"),
            keywords: &["kazmë", "vegël", "çekiç", "çekiç dhe kazmë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("чекић и пијук"),
            keywords: &["aлaт", "пиjук", "чeкић", "чекић и пијук"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("čekić i pijuk"),
            keywords: &["alat", "pijuk", "čekić", "čekić i pijuk"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("hammare och hacka"),
            keywords: &["hacka", "hammare", "hammare och hacka", "verktyg"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nyundo na sululu"),
            keywords: &["nyundo", "nyundo na sululu", "sululu", "zana"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சுத\u{bcd}தியும\u{bcd} களைஎடுத\u{bcd}தலும\u{bcd}"),
            keywords: &[
                "கருவி",
                "கோடரி",
                "சுத\u{bcd}தியல\u{bcd}",
                "சுத\u{bcd}தியும\u{bcd} களைஎடுத\u{bcd}தலும\u{bcd}",
                "சுத\u{bcd}தியும\u{bcd} கோடரியும\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("సుత\u{c4d}త\u{c3f} మర\u{c3f}యు గడ\u{c4d}డప\u{c3e}ర"),
            keywords: &[
                "గడ\u{c4d}డప\u{c3e}ర",
                "స\u{c3e}ధనం",
                "సుత\u{c4d}త\u{c3f}",
                "సుత\u{c4d}త\u{c3f} మర\u{c3f}యు గడ\u{c4d}డప\u{c3e}ర",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("болға ва зоғнӯл"),
            keywords: &["асбоб", "болға", "болға ва зоғнӯл", "зоғнӯл"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ค\u{e49}อนและจอบ"),
            keywords: &[
                "ค\u{e49}อน",
                "ค\u{e49}อนและจอบ",
                "จอบ",
                "เคร\u{e37}\u{e48}องม\u{e37}อ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çekiç we çüý goparýan"),
            keywords: &["gural", "çekiç", "çekiç we çüý goparýan", "çüý goparýan"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("hamala moe toki tākelekele"),
            keywords: &["hamala moe toki tākelekele"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("çekiç ve kazma"),
            keywords: &["alet", "kazma", "çekiç", "çekiç ve kazma"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("بولقا ۋە چوت"),
            keywords: &["بولقا", "بولقا ۋە چوت", "قورال", "چوت"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("молоток і кирка"),
            keywords: &["кирка", "молоток", "молоток і кирка", "інструмент"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ہتھوڑا اور کدال"),
            keywords: &["آلہ", "کدال", "ہتھوڑا", "ہتھوڑا اور کدال"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("bolg‘a va uchli bolg‘a"),
            keywords: &["asbob", "bolg‘a", "bolg‘a va uchli bolg‘a"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("búa và búa chim"),
            keywords: &["búa", "búa chim", "búa và búa chim", "dụng cụ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("marto ak pik"),
            keywords: &["jumtukaay", "marto", "marto ak pik", "pik"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ihamile nepeki"),
            keywords: &["ihamile", "ihamile nepeki", "ipeki", "isixhobo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("òòlù àti ìsà"),
            keywords: &["òòlù", "òòlù àti ìsà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("錘同挑"),
            keywords: &["工具", "挑", "錘", "錘同挑"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("锤同挑"),
            keywords: &["工具", "挑", "锤", "锤同挑"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("锤子与镐"),
            keywords: &["工具", "铁锤", "铁镐", "锤子", "锤子与镐", "镐子"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("鎚子和十字鎬"),
            keywords: &["十字鎬", "鎚子", "鎚子和十字鎬"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("鎚仔同十字鋤"),
            keywords: &["鎚仔同十字鋤", "鎚仔同十字鋤｜鎚仔｜十字鋤"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isando ipiki"),
            keywords: &["ipiki", "isando", "ithuluzi"],
        },
    ],
};
#[doc = "🛠\u{fe0f}"]
pub const HAMMER_AND_WRENCH: crate::Emoji = crate::Emoji {
    glyph: "🛠\u{fe0f}",
    codepoint: "1F6E0 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "hammer and wrench",
    group: "Objects",
    subgroup: "tool",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🛠",
        codepoint: "1F6E0",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "hammer and wrench",
        group: "Objects",
        subgroup: "tool",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("hamer en moersleutel"),
            keywords: &["gereedskap", "hamer", "hamer en moersleutel", "moersleutel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መዶሻ እና መፍቻ"),
            keywords: &["መሣሪያ", "መዶሻ", "መዶሻ እና መፍቻ", "መፍቻ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شاكوش ومفتاح"),
            keywords: &["أداة", "شاكوش", "شاكوش ومفتاح", "مفتاح"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হ\u{9be}ত\u{9c1}ৰী আৰ\u{9c1} ৰেঞ\u{9cd}চ"),
            keywords: &[
                "স\u{981}জ\u{9c1}লি",
                "স\u{9cd}পেন\u{9be}ৰ",
                "হ\u{9be}ত\u{9c1}ৰী",
                "হ\u{9be}ত\u{9c1}ৰী আৰ\u{9c1} ৰেঞ\u{9cd}চ",
                "ৰেঞ\u{9cd}চ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("çəkic və açar"),
            keywords: &["alət", "açar", "çəkic", "çəkic və açar"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("малаток і гаечны ключ"),
            keywords: &[
                "гаечны",
                "ключ",
                "малаток",
                "малаток і гаечны ключ",
                "інструмент",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Чук и гаечен ключ"),
            keywords: &["Чук и гаечен ключ", "гаечен ключ", "инструмент", "чук"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হ\u{9be}ত\u{9c1}ড\u{9bc}ি এবং রেঞ\u{9cd}চ"),
            keywords: &[
                "রেঞ\u{9cd}চ",
                "সরঞ\u{9cd}জ\u{9be}ম",
                "হ\u{9be}ত\u{9c1}ড\u{9bc}ি",
                "হ\u{9be}ত\u{9c1}ড\u{9bc}ি এবং রেঞ\u{9cd}চ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("morzhol hag alcʼhwez plat"),
            keywords: &["alcʼhwez", "benveg", "morzhol", "morzhol hag alcʼhwez plat"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("čekić i ključ"),
            keywords: &["alat", "ključ", "čekić", "čekić i ključ"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("martell i clau anglesa"),
            keywords: &["clau anglesa", "eina", "martell", "martell i clau anglesa"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎬᏅᏩᎶᏍᏗ ᎠᎴ ᏗᎦᏚᏩᎸᏕᏍᏙᏗ"),
            keywords: &[
                "ᎬᏅᏩᎶᏍᏗ",
                "ᎬᏅᏩᎶᏍᏗ ᎠᎴ ᏗᎦᏚᏩᎸᏕᏍᏙᏗ",
                "ᎬᏔᏂᏓᏍᏗ",
                "ᏗᎦᏚᏩᎸᏕᏍᏙᏗ",
                "ᏗᎦᏚᏩᎸᏕᏍᏙᏗ ᎢᏳᏍᏗ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kladivo a maticový klíč"),
            keywords: &[
                "kladivo",
                "kladivo a maticový klíč",
                "klíč",
                "montážní",
                "nářadí",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("morthwyl a sbaner"),
            keywords: &["caib", "morthwyl", "morthwyl a sbaner", "sbaner"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("hammer og skruenøgle"),
            keywords: &[
                "hammer",
                "hammer og skruenøgle",
                "skruenøgle",
                "svensknøgle",
                "værktøj",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Hammer und Schraubenschlüssel"),
            keywords: &[
                "Hammer",
                "Hammer und Schraubenschlüssel",
                "Schraubenschlüssel",
                "Werkzeug",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σφυρί και γαλλικό κλειδί"),
            keywords: &["εργαλείο", "κλειδί", "σφυρί", "σφυρί και γαλλικό κλειδί"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("hammer and wrench"),
            keywords: &["hammer", "hammer and wrench", "spanner", "tool", "wrench"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("hammer and spanner"),
            keywords: &["hammer and spanner"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["hammer", "hammer and spanner", "spanner", "tool", "wrench"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("hammer and wrench"),
            keywords: &["hammer", "hammer and wrench", "spanner", "tool", "wrench"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("martillo y llave inglesa"),
            keywords: &[
                "herramienta",
                "llave inglesa",
                "martillo",
                "martillo y llave inglesa",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "herramienta",
                "inglesa",
                "llave",
                "martillo",
                "martillo y llave inglesa",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "herramienta",
                "llave",
                "llave inglesa",
                "martillo",
                "martillo y llave inglesa",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("haamer ja mutrivõti"),
            keywords: &["haamer", "haamer ja mutrivõti", "mutrivõti", "tööriist"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("mailua eta giltza ingelesa"),
            keywords: &[
                "giltza ingeles",
                "mailu",
                "mailua eta giltza ingelesa",
                "tresna",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("چکش و آچار"),
            keywords: &["آچار", "ابزار", "چکش", "چکش و آچار"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("jakoavain ja vasara"),
            keywords: &["jakoavain", "jakoavain ja vasara", "työkalu", "vasara"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("martilyo at liyabe"),
            keywords: &["kagamitan", "lyabe", "martilyo", "martilyo at liyabe"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hamari og skrúvulykil"),
            keywords: &[
                "amboð",
                "hamari",
                "hamari og skrúvulykil",
                "skiftilykil",
                "skrúvulykil",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("marteau et clé à molette"),
            keywords: &[
                "clé",
                "clé à molette",
                "marteau",
                "marteau et clé à molette",
                "outil",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "clé",
                "clé à molette",
                "marteau",
                "marteau et clé à molette",
                "outil",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("casúr agus rinse"),
            keywords: &["casúr", "casúr agus rinse", "rinse", "uirlis"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("òrd is toinnear"),
            keywords: &[
                "inneal",
                "nupair",
                "spanair",
                "toinnear",
                "òrd",
                "òrd is toinnear",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("martelo e chave inglesa"),
            keywords: &[
                "chave inglesa",
                "ferramenta",
                "martelo",
                "martelo e chave inglesa",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("હથોડી અન\u{ac7} પાન\u{ac1}\u{a82}"),
            keywords: &["સાધન", "હથોડી અન\u{ac7} પાન\u{ac1}\u{a82}"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("gudana da sufana"),
            keywords: &["gudana da sufana", "guduma", "kayan aiki", "sufana"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פטיש ומפתח ברגים"),
            keywords: &[
                "כלי עבודה",
                "כלים",
                "מפתח ברגים",
                "עבודה",
                "פטיש",
                "פטיש ומפתח ברגים",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("हथौड\u{93c}ा और पाना"),
            keywords: &["ट\u{942}ल", "र\u{948}\u{902}च", "हथौड\u{93c}ा और पाना"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("čekić i francuski ključ"),
            keywords: &[
                "alat",
                "francuski ključ",
                "čekić",
                "čekić i francuski ključ",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kalapács és csavarkulcs"),
            keywords: &[
                "csavarkulcs",
                "kalapács",
                "kalapács és csavarkulcs",
                "szerszám",
                "villáskulcs",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մուրճ և պտուտակաբանալի"),
            keywords: &[
                "գործիք",
                "մուրճ",
                "մուրճ և պտուտակաբանալի",
                "պտուտակաբանալի",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("palu dan kunci inggris"),
            keywords: &["alat", "kunci inggris", "palu", "palu dan kunci inggris"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nkụigwe na igwe ndọpụta"),
            keywords: &[
                "igwe ndọpụta",
                "ngwankwụpụta",
                "ngwaọrụ",
                "nkụigwe",
                "nkụigwe na igwe ndọpụta",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hamar og skiptilykill"),
            keywords: &["hamar", "hamar og skiptilykill", "skiptilykill", "verkfæri"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("martello e chiave inglese"),
            keywords: &[
                "attrezzi",
                "martello e chiave inglese",
                "simbolo impostazioni",
                "utensili",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ハンマーとレンチ"),
            keywords: &["かなづち", "とんかち", "ハンマーとレンチ", "レンチ", "工具"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pukul lan kunci pas"),
            keywords: &[
                "bekakas",
                "kunci inggris",
                "kunci pas",
                "pukul",
                "pukul lan kunci pas",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჩაქუჩი და ქანჩის გასაღები"),
            keywords: &[
                "ინსტრუმენტი",
                "ქანჩის გასაღები",
                "ჩაქუჩი",
                "ჩაქუჩი და ქანჩის გასაღები",
                "ხელსაწყო",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("балға мен сомын кілт"),
            keywords: &["балға", "балға мен сомын кілт", "сомын кілт", "құрал"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("hammer og skruenøgle"),
            keywords: &[
                "hammer",
                "hammer og skruenøgle",
                "skruenøgle",
                "svensknøgle",
                "værktøj",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ញញ\u{17bd}រដ\u{17c6}ដែកគោលន\u{17b7}ងសោម\u{17bd}លខ\u{17d2}ចៅ"),
            keywords: &[
                "ញញ\u{17bd}រ",
                "ញញ\u{17bd}រដ\u{17c6}ដែកគោលន\u{17b7}ងសោម\u{17bd}លខ\u{17d2}ចៅ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸುತ\u{ccd}ತ\u{cbf}ಗ\u{cc6} ಮತ\u{ccd}ತು ವ\u{ccd}ರ\u{cc6}ಂಚ\u{ccd}"),
            keywords: &[
                "ಪರ\u{cbf}ಕರ",
                "ವ\u{ccd}ರ\u{cc6}ಂಚ\u{ccd}",
                "ಸುತ\u{ccd}ತ\u{cbf}ಗ\u{cc6}",
                "ಸುತ\u{ccd}ತ\u{cbf}ಗ\u{cc6} ಮತ\u{ccd}ತು ವ\u{ccd}ರ\u{cc6}ಂಚ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("망치와 렌치"),
            keywords: &["렌치", "망치", "망치와 렌치", "스패너"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("घण आनी तिरपणी"),
            keywords: &["घण", "घण आनी तिरपणी", "तिरपणी", "पानो", "साधन"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("балка менен гайка ачкычы"),
            keywords: &["балка", "балка менен гайка ачкычы", "гайка ачкычы", "курал"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Hummer a Schrauweschlëssel"),
            keywords: &[
                "Handwierksgeschir",
                "Hummer",
                "Hummer a Schrauweschlëssel",
                "Schrauwenzéier",
                "Schrauweschlëssel",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໄມ\u{ec9}ຄ\u{ec9}ອນ ແລະ ກະແຈ"),
            keywords: &[
                "ກະແຈ",
                "ໄມ\u{ec9}ຄ\u{ec9}ອນ",
                "ໄມ\u{ec9}ຄ\u{ec9}ອນ ແລະ ກະແຈ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("plaktukas ir veržliaraktis"),
            keywords: &[
                "plaktukas",
                "plaktukas ir veržliaraktis",
                "veržliaraktis",
                "įrankis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("āmurs un uzgriežņu atslēga"),
            keywords: &[
                "cirtnis",
                "uzgriežņu atslēga",
                "āmurs",
                "āmurs un uzgriežņu atslēga",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("hama me te wāwāhi"),
            keywords: &["hama", "hama me te wāwāhi", "mauhiri", "utauta", "wāwāhi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("чекан и француски клуч"),
            keywords: &["алатки", "чекан и француски клуч"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ച\u{d41}റ\u{d4d}റികയ\u{d41}ം റെഞ\u{d4d}ച\u{d41}ം"),
            keywords: &[
                "ഉപകരണം",
                "ച\u{d41}റ\u{d4d}റിക",
                "ച\u{d41}റ\u{d4d}റികയ\u{d41}ം റെഞ\u{d4d}ച\u{d41}ം",
                "റെഞ\u{d4d}ച\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("алх, түлхүүр"),
            keywords: &["алх", "алх, түлхүүр", "түлхүүр"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("हातोडा आणि पाना"),
            keywords: &["पाना", "साधन", "हातोडा", "हातोडा आणि पाना"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tukul dan perengkuh"),
            keywords: &["alat", "perengkuh", "tukul", "tukul dan perengkuh"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("martell u spaner"),
            keywords: &["għodda", "martell", "martell u spaner", "spaner"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တ\u{1030}န\u{103e}င\u{1037}\u{103a} ခ\u{103d}"),
            keywords: &[
                "ခ\u{103d}ရ\u{103e}င\u{103a}",
                "စပန\u{103a}နာ",
                "တ\u{1030}",
                "တ\u{1030}န\u{103e}င\u{1037}\u{103a} ခ\u{103d}",
                "တ\u{1030}န\u{103e}င\u{1037}\u{103a} ခ\u{103d}ရ\u{103e}င\u{103a}",
                "တ\u{1030}းလ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hammer og fastnøkkel"),
            keywords: &["hammer", "hammer og fastnøkkel", "skiftenøkkel", "verktøy"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("घन र रिन\u{94d}च"),
            keywords: &["उपकरण", "घन", "घन र रिन\u{94d}च", "रिन\u{94d}च"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("hamer en moersleutel"),
            keywords: &[
                "gereedschap",
                "hamer",
                "hamer en moersleutel",
                "moersleutel",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("hammar og fastnøkkel"),
            keywords: &["hammar", "hammar og fastnøkkel", "skiftenøkkel", "verktøy"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ହ\u{b3e}ତ\u{b41}ଡ\u{b3c}\u{b3f} ଏବଂ ରେଞ\u{b4d}ଚ\u{b3f}"),
            keywords: &[
                "ଯନ\u{b4d}ତ\u{b4d}ରପ\u{b3e}ତ\u{b3f}",
                "ରେଞ\u{b4d}ଚ\u{b3f}",
                "ସ\u{b4d}ପ\u{b3e}ନର\u{b4d}\u{200c}",
                "ହ\u{b3e}ତ\u{b41}ଡ\u{b3c}\u{b3f}",
                "ହ\u{b3e}ତ\u{b41}ଡ\u{b3c}\u{b3f} ଏବଂ ରେଞ\u{b4d}ଚ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਹਥ\u{a4c}ੜਾ ਅਤ\u{a47} ਰ\u{a48}\u{a02}ਚ"),
            keywords: &[
                "ਔਜ\u{a3c}ਾਰ",
                "ਰ\u{a48}\u{a02}ਚ ਔਜ\u{a3c}ਾਰ",
                "ਹਥ\u{a4c}ੜਾ ਅਤ\u{a47} ਰ\u{a48}\u{a02}ਚ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہتھوڑی اتے موچ"),
            keywords: &["اوزار", "تھوڑی", "مروڑنا", "ناپن آلا", "ہتھوڑی اتے موچ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Háma An Spána"),
            keywords: &["Háma", "Háma An Spána", "Rẹnch", "Spána", "Tul"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("młot i klucz"),
            keywords: &["klucz", "młot", "młot i klucz", "narzędzia", "warsztatowy"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("څټک او رنچ"),
            keywords: &["اله", "رنچ", "څټک", "څټک او رنچ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("martelo e chave-inglesa"),
            keywords: &[
                "chave",
                "chave-inglesa",
                "ferramenta",
                "martelo",
                "martelo e chave-inglesa",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("martelo e chave inglesa"),
            keywords: &[
                "chave inglesa",
                "ferramenta",
                "martelo",
                "martelo e chave inglesa",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ciocan și cheie fixă"),
            keywords: &[
                "cheie de piulițe",
                "cheie fixă",
                "ciocan",
                "ciocan și cheie fixă",
                "instrument",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-994"),
            keywords: &["E10-994"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("молот и гаечный ключ"),
            keywords: &[
                "гаечный",
                "инструмент",
                "ключ",
                "молот",
                "молот и гаечный ключ",
                "молоток",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("inyundo na kasuku"),
            keywords: &[
                "igikoresho",
                "inyundo",
                "inyundo na kasuku",
                "isupane",
                "kasuku",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("هٿوڙو ۽ پانو"),
            keywords: &["اوزار", "رينچ", "هٿوڙو", "هٿوڙو ۽ پانو", "پانو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ම\u{dd2}ට\u{dd2}ය සහ රෙංච\u{dd2}ය"),
            keywords: &[
                "ම\u{dd2}ට\u{dd2}ය සහ රෙංච\u{dd2}ය",
                "ම\u{dd2}ට\u{dd2}\u{dd2}ය",
                "මෙවලම",
                "රෙංච\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kladivo a kľúč"),
            keywords: &["francúzsky kľúč", "kladivo", "kladivo a kľúč", "nástroj"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kladivo in ključ"),
            keywords: &["kladivo", "kladivo in ključ", "ključ", "orodje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dube iyo baanad"),
            keywords: &["baanad", "dube", "dube iyo baanad", "qalab", "wareejiso"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("çekiç dhe çelës"),
            keywords: &["vegël", "çekiç", "çekiç dhe çelës", "çelës"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("чекић и француски кључ"),
            keywords: &["aлaт", "фрaнцуски кључ", "чeкић", "чекић и француски кључ"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("čekić i francuski ključ"),
            keywords: &[
                "alat",
                "francuski ključ",
                "čekić",
                "čekić i francuski ključ",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("hammare och skiftnyckel"),
            keywords: &[
                "hammare",
                "hammare och skiftnyckel",
                "skiftnyckel",
                "verktyg",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nyundo na spana malaya"),
            keywords: &["nyundo na spana malaya", "nyungo", "spana malaya", "zana"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சுத\u{bcd}தியும\u{bcd} இடுக\u{bcd}கியும\u{bcd}"),
            keywords: &[
                "இடுக\u{bcd}கி",
                "கருவி",
                "சுத\u{bcd}தியல\u{bcd}",
                "சுத\u{bcd}தியும\u{bcd} இடுக\u{bcd}கியும\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("సుత\u{c4d}త\u{c3f} మర\u{c3f}యు ర\u{c46}ంచ\u{c3f}"),
            keywords: &[
                "ర\u{c46}ంచ\u{c3f}",
                "స\u{c3e}ధనం",
                "సుత\u{c4d}త\u{c3f}",
                "సుత\u{c4d}త\u{c3f} మర\u{c3f}యు ర\u{c46}ంచ\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("болға ва калиди гайкатобӣ"),
            keywords: &[
                "асбоб",
                "болға",
                "болға ва калиди гайкатобӣ",
                "калид",
                "калиди гайкатобӣ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ค\u{e49}อนและประแจ"),
            keywords: &[
                "ค\u{e49}อน",
                "ค\u{e49}อนและประแจ",
                "ประแจ",
                "เคร\u{e37}\u{e48}องม\u{e37}อ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çekiç we nurbat açar"),
            keywords: &[
                "gaýka açary",
                "gural",
                "nurbat açar",
                "çekiç",
                "çekiç we nurbat açar",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("hamala moe sipana"),
            keywords: &["hamala moe sipana"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("çekiç ve somun anahtarı"),
            keywords: &[
                "alet",
                "ingiliz anahtarı",
                "çekiç",
                "çekiç ve ingiliz anahtarı",
                "çekiç ve somun anahtarı",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("بولقا ۋە كۇلۇچ"),
            keywords: &["بولقا", "بولقا ۋە كۇلۇچ", "جابدۇق", "قورال", "كۇلۇچ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("молоток і гайковий ключ"),
            keywords: &[
                "гайковий ключ",
                "молоток",
                "молоток і гайковий ключ",
                "інструмент",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ہتھوڑا اور رینچ"),
            keywords: &["آلہ", "رینچ", "ہتھوڑا", "ہتھوڑا اور رینچ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("bolg‘a va gayka kaliti"),
            keywords: &["asbob", "bolg‘a", "bolg‘a va gayka kaliti", "gayka kaliti"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("búa và cờ lê"),
            keywords: &["búa", "búa và cờ lê", "chìa vặn", "cờ lê", "dụng cụ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("marto ak kle"),
            keywords: &["jumtukaay", "kle", "marto", "marto ak kle"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ihamile nebhobhotyana"),
            keywords: &[
                "ibhobhotyana",
                "ibhobhotyane",
                "ihamile",
                "ihamile nebhobhotyana",
                "isixhobo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("òòlù àti irinṣẹ\u{301} afagbára dè"),
            keywords: &[
                "irinṣẹ\u{301}",
                "irinṣẹ\u{301} afagbára dè",
                "sípánà",
                "òòlù",
                "òòlù àti irinṣẹ\u{301} afagbára dè",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("錘同士巴拿"),
            keywords: &["士巴拿", "工具", "扳手", "錘", "錘同士巴拿"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("锤同士巴拿"),
            keywords: &["士巴拿", "工具", "扳手", "锤", "锤同士巴拿"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("锤子与扳手"),
            keywords: &["工具", "扳手", "铁锤", "锤子", "锤子与扳手"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("鎚子和扳手"),
            keywords: &["扳手", "鎚子", "鎚子和扳手"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("鎚仔同士巴拿"),
            keywords: &["鎚仔同士巴拿", "鎚仔同士巴拿｜鎚仔｜士巴拿"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isando nespanelo"),
            keywords: &["ipiki", "isando", "isando nespanelo", "ispanelo"],
        },
    ],
};
#[doc = "🗡\u{fe0f}"]
pub const DAGGER: crate::Emoji = crate::Emoji {
    glyph: "🗡\u{fe0f}",
    codepoint: "1F5E1 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "dagger",
    group: "Objects",
    subgroup: "tool",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🗡",
        codepoint: "1F5E1",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "dagger",
        group: "Objects",
        subgroup: "tool",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("dolk"),
            keywords: &["dolk", "mes", "wapen"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አነስተኛ ሰይፍ"),
            keywords: &["ቢላዋ", "አነስተኛ ሰይፍ", "ጦር መሣሪያ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("خنجر"),
            keywords: &["خنجر", "سكين", "سلاح"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("খঞ\u{9cd}জৰ"),
            keywords: &["অস\u{9cd}ত\u{9cd}ৰ", "খঞ\u{9cd}জৰ", "ছ\u{9c1}ৰী"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("xəncər"),
            keywords: &["bıçaq", "silah", "xəncər"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кінжал"),
            keywords: &["зброя", "корцік", "кінжал", "нож"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("кинжал"),
            keywords: &["кинжал", "нож", "оръжие"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ছ\u{9c1}রি"),
            keywords: &["অস\u{9cd}ত\u{9cd}র", "ছ\u{9c1}রি"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("badalenn"),
            keywords: &["arm", "badalenn", "kontell"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("bodež"),
            keywords: &["bodež", "nož", "oružje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("daga"),
            keywords: &["arma", "daga", "ganivet"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎦᏘᏍᏗ"),
            keywords: &["ᎠᎵᏍᏕᎸᏙᏗ", "ᎠᏰᎳᏍᏗ", "ᏗᎦᏘᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("dýka"),
            keywords: &["dýka", "nůž", "zbraň"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dagr"),
            keywords: &["arf", "cyllell", "dagr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("dolk"),
            keywords: &["daggert", "dolk", "kniv", "våben"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Dolch"),
            keywords: &["Dolch", "Waffe"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("στιλέτο"),
            keywords: &["μαχαίρι", "στιλέτο", "όπλο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("dagger"),
            keywords: &["dagger", "knife", "weapon"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("puñal"),
            keywords: &["arma", "cuchillo", "daga", "puñal"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("daga"),
            keywords: &["armas", "cuchillo", "daga"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("pistoda"),
            keywords: &["nuga", "pistoda", "relv"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("daga"),
            keywords: &["aizto", "arma", "daga"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("خنجر"),
            keywords: &["اسلحه", "خنجر", "چاقو"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tikari"),
            keywords: &["ase", "teräase", "tikari", "veitsi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("patalim"),
            keywords: &["armas", "patalim", "sandata"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("stutt svørð"),
            keywords: &["dolkur", "knívur", "stutt svørð", "svørð", "vápn"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("dague"),
            keywords: &["arme", "couteau", "dague", "poignard"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("miodóg"),
            keywords: &["arm", "miodóg", "scian"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("biodag"),
            keywords: &["arm", "biodag", "sgian"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("daga"),
            keywords: &["arma", "daga", "puñal"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કટાર"),
            keywords: &["કટાર", "ચાક\u{ac1}", "હથિયાર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("wuƙar ƙugu"),
            keywords: &["makami", "wuƙa", "wuƙar ƙugu"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פגיון"),
            keywords: &["כלי נשק", "סכין", "פגיון"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("कटार"),
            keywords: &["कटार", "छ\u{941}री", "हथियार"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("bodež"),
            keywords: &["bodež", "nož", "oružje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("tőr"),
            keywords: &["fegyver", "szúrás", "tőr"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("դաշույն"),
            keywords: &["դանակ", "դաշույն", "զենք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("belati"),
            keywords: &["belati", "pisau", "senjata"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwa obere mma"),
            keywords: &["mma", "ngwa agha", "nwa obere mma"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("rýtingur"),
            keywords: &["hnífur", "rýtingur", "vopn"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pugnale"),
            keywords: &["affilato", "arma", "pugnalare", "pugnale"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("短刀"),
            keywords: &["ダガー", "ナイフ", "武器", "短刀"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pedhang endhek"),
            keywords: &["gegaman", "pedhang endhek", "peso"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ხანჯალი"),
            keywords: &["დანა", "იარაღი", "ხანჯალი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қанжар"),
            keywords: &["пышақ", "қанжар", "құрал"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("daggert"),
            keywords: &["daggert", "kniv", "våben"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ក\u{17bc}នកា\u{17c6}ប\u{17b7}ទខ\u{17d2}ល\u{17b8}"),
            keywords: &[
                "កា\u{17c6}ប\u{17b7}ទ",
                "ក\u{17bc}នកា\u{17c6}ប\u{17b7}ទ",
                "ក\u{17bc}នកា\u{17c6}ប\u{17b7}ទខ\u{17d2}ល\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬಾಕು"),
            keywords: &[
                "ಕತ\u{ccd}ತರ\u{cbf}",
                "ಬಾಕು",
                "ಶಸ\u{ccd}ತ\u{ccd}ರಾಸ\u{ccd}ತ\u{ccd}ರ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("단검"),
            keywords: &["단검", "단도", "대거"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ख\u{902}जीर"),
            keywords: &["ख\u{902}जीर", "स\u{941}री", "हत\u{94d}यार"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("канжар"),
            keywords: &["бычак", "канжар", "курал"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Dolch"),
            keywords: &["Dolch", "Messer", "Waff"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ດາບສ\u{eb1}\u{ec9}ນ"),
            keywords: &["ດາບ", "ດາບສ\u{eb1}\u{ec9}ນ", "ອາວ\u{eb8}ດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("durklas"),
            keywords: &["durklas", "ginklas", "peilis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("duncis"),
            keywords: &["duncis", "ierocis", "nazis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("oka"),
            keywords: &["naihi", "oka", "rākau-riri"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("кама"),
            keywords: &["кама", "нож", "оружје"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വ\u{d3e}ൾ"),
            keywords: &["ആയ\u{d41}ധം", "കത\u{d4d}തി", "വ\u{d3e}ൾ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("чинжаал хутга"),
            keywords: &["хутга", "чинжаал"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ख\u{902}जीर"),
            keywords: &["ख\u{902}जीर", "चाक\u{942}", "हत\u{94d}यार"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pisau belati"),
            keywords: &["pisau", "pisau belati", "senjata"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("stallet"),
            keywords: &["arma", "sikkina", "stallet"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဓားမြ\u{103e}ောင\u{103a}"),
            keywords: &["ဓား", "ဓားမြ\u{103e}ောင\u{103a}", "လက\u{103a}နက\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("dolk"),
            keywords: &["dolk", "kniv", "våpen"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ड\u{94d}यागर"),
            keywords: &["चक\u{94d}क\u{941}", "ड\u{94d}यागर", "हतियार"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("dolk"),
            keywords: &["dolk", "mes", "wapen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("dolk"),
            keywords: &["dolk", "kniv", "våpen"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଛ\u{b41}ର\u{b3e}"),
            keywords: &[
                "ଛ\u{b41}ର\u{b3e}",
                "ଛ\u{b41}ରୀ । ଅସ\u{b4d}ତ\u{b4d}ରଶସ\u{b4d}ତ\u{b4d}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਟਾਰ"),
            keywords: &["ਕਟਾਰ", "ਚਾਕ\u{a42}", "ਹਥਿਆਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("خنجر"),
            keywords: &["خنجر", "چھری", "ہتھیار"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Dága"),
            keywords: &["Dága", "Naif", "Wẹ\u{301}pọn"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("sztylet"),
            keywords: &["broń", "nóż", "sztylet"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("خنجر"),
            keywords: &["خنجر", "وسله", "چاقو"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("adaga"),
            keywords: &["adaga", "arma", "faca"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("punhal"),
            keywords: &["arma", "punhal"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pumnal"),
            keywords: &["armă", "cuțit", "pumnal"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-825"),
            keywords: &["E10-825"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("кинжал"),
            keywords: &["кинжал", "нож", "оружие", "острый нож", "холодное оружие"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("daga"),
            keywords: &["daga", "icyuma", "intwaro"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("خنجر"),
            keywords: &["خنجر", "هٿيار", "چاقو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dd2}ර\u{dd2}ච\u{dca}ච\u{dd2}ය"),
            keywords: &[
                "ආය\u{dd4}ධය",
                "ක\u{dd2}ර\u{dd2}ච\u{dca}ච\u{dd2}ය",
                "ප\u{dd2}හ\u{dd2}\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("dýka"),
            keywords: &["dýka", "nôž", "zbraň"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("bodalo"),
            keywords: &["bodalo", "nož", "orožje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("toorey"),
            keywords: &["midi", "toorey"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kamë"),
            keywords: &["armë", "kamë", "thikë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("бодеж"),
            keywords: &["oружje", "бодеж", "нoж"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("bodež"),
            keywords: &["bodež", "nož", "oružje"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("dolk"),
            keywords: &["dolk", "kniv", "vapen"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("sime"),
            keywords: &["kisu", "silaha", "sime"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பட\u{bcd}ட\u{bbe}க\u{bcd} கத\u{bcd}தி"),
            keywords: &[
                "ஆயுதம\u{bcd}",
                "கத\u{bcd}தி",
                "கருவி",
                "பட\u{bcd}ட\u{bbe}க\u{bcd} கத\u{bcd}தி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బ\u{c3e}కు"),
            keywords: &["ఆయుధం", "కత\u{c4d}త\u{c3f}", "బ\u{c3e}కు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ханҷар"),
            keywords: &["корд", "силоҳ", "ханҷар"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ดาบส\u{e31}\u{e49}น"),
            keywords: &["ดาบ", "ดาบส\u{e31}\u{e49}น", "อาว\u{e38}ธ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("hanjar"),
            keywords: &["hanjar", "pyçak", "ýarag"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("hele tui"),
            keywords: &["hele tui"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("hançer"),
            keywords: &["bıçak", "hançer", "silah"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("خەنجەر"),
            keywords: &["خەنجەر", "قورال-ياراغ", "پىچاق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кинджал"),
            keywords: &["зброя", "кинджал", "ніж"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("خنجر"),
            keywords: &["آلہ", "خنجر", "ہتھیار"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("xanjar"),
            keywords: &["pichoq", "qurol", "xanjar"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("dao găm"),
            keywords: &["dao", "dao găm", "vũ khí"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("paaka"),
            keywords: &["ngànnaay", "paaka"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isinkempe"),
            keywords: &["imela", "isinkempe", "isixhobo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("dágà"),
            keywords: &["dágà", "irinṣẹ\u{301} ìjagun", "ò\u{329}bẹ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("匕首"),
            keywords: &["刀", "匕首", "武器"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("匕首"),
            keywords: &["刀", "匕首", "武器"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("匕首"),
            keywords: &["匕首", "武器", "短刀"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("匕首"),
            keywords: &["匕首"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ummese"),
            keywords: &["isikhali", "ummese"],
        },
    ],
};
#[doc = "⚔\u{fe0f}"]
pub const CROSSED_SWORDS: crate::Emoji = crate::Emoji {
    glyph: "⚔\u{fe0f}",
    codepoint: "2694 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "crossed swords",
    group: "Objects",
    subgroup: "tool",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "⚔",
        codepoint: "2694",
        status: crate::Status::Unqualified,
        introduction_version: 1f32,
        name: "crossed swords",
        group: "Objects",
        subgroup: "tool",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gekruiste swaarde"),
            keywords: &["gekruiste swaarde", "swaarde", "wapen"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የተጠላለፉ ሰይፎች"),
            keywords: &["ሰይፎች", "የተጠላለፉ ሰይፎች", "የተጣመረ", "ጦር መሣሪያ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سيفان متصالبان"),
            keywords: &["سلاح", "سيفان", "سيفان متصالبان", "معقوق"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কে\u{981}চীয\u{9bc}\u{9be}কে\u{981}চিকৈ ৰখ\u{9be} তৰোৱ\u{9be}ল"),
            keywords: &[
                "অস\u{9cd}ত\u{9cd}ৰ",
                "কে\u{981}চীয\u{9bc}\u{9be}কে\u{981}চি",
                "কে\u{981}চীয\u{9bc}\u{9be}কে\u{981}চিকৈ ৰখ\u{9be} তৰোৱ\u{9be}ল",
                "তৰোৱ\u{9be}ল",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kəsişən qılınclar"),
            keywords: &["kəsişən", "qılınclar", "silah"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("скрыжаваныя мячы"),
            keywords: &["зброя", "мячы", "скрыжаваныя"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Кръстосани мечове"),
            keywords: &["Кръстосани мечове", "кръстосани", "мечове", "оръжие"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("আড\u{9bc}\u{9be}আড\u{9bc}ি র\u{9be}খ\u{9be} তলোয\u{9bc}\u{9be}র"),
            keywords: &[
                "অস\u{9cd}ত\u{9cd}র",
                "আড\u{9bc}\u{9be}আড\u{9bc}ি ভ\u{9be}বে থ\u{9be}ক\u{9be}",
                "আড\u{9bc}\u{9be}আড\u{9bc}ি র\u{9be}খ\u{9be} তলোয\u{9bc}\u{9be}র",
                "তলোয\u{9bc}\u{9be}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("klezeier kroaziet"),
            keywords: &["arm", "kleze", "klezeier", "klezeier kroaziet"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ukršteni mačevi"),
            keywords: &["mačevi", "oružje", "ukršteni"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("espases creuades"),
            keywords: &["arma", "creuades", "espases"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏧᏓᎿᏫᏓ ᏗᏰᎳᏍᏗ ᏗᎦᏅᎯᏓ"),
            keywords: &["ᎠᎵᏍᏕᎸᏙᏗ", "ᏗᏰᎳᏍᏗ", "ᏧᏓᎿᏫᏓ", "ᏧᏓᎿᏫᏓ ᏗᏰᎳᏍᏗ ᏗᎦᏅᎯᏓ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zkřížené meče"),
            keywords: &["meče", "zbraň", "zkřížené"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cleddyfau wedi croesi"),
            keywords: &["arf", "cleddyfau", "cleddyfau wedi croesi", "wedi croesi"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("korslagte sværd"),
            keywords: &["korslagt", "korslagte sværd", "sværd", "våben"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("gekreuzte Schwerter"),
            keywords: &["Schwerter", "gekreuzt", "gekreuzte Schwerter"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σταυρωτά σπαθιά"),
            keywords: &["σπαθιά", "σταυρωτά", "όπλο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("crossed swords"),
            keywords: &["crossed", "swords", "weapon"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("espadas cruzadas"),
            keywords: &["arma", "cruzadas", "espadas"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["armas", "espadas", "espadas cruzadas"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("ristatud mõõgad"),
            keywords: &["mõõgad", "relv", "ristatud mõõgad", "risti"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ezpata gurutzatuak"),
            keywords: &["arma", "ezpata gurutzatuak", "ezpatak", "gurutzatu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("شمشیرهای ضرب\u{200c}دری"),
            keywords: &[
                "اسلحه",
                "شمشیر",
                "شمشیرهای ضرب\u{200c}دری",
                "صلیب",
                "متقاطع",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("miekat ristissä"),
            keywords: &["ase", "miekat ristissä", "miekka"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("magkakrus na espada"),
            keywords: &[
                "armas",
                "espada",
                "magkakrus",
                "magkakrus na espada",
                "sandata",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("krossa svørð"),
            keywords: &["krossa", "svørð", "vápn"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("épées croisées"),
            keywords: &["arme", "croisées", "épées"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("claimhte crosáilte"),
            keywords: &["arm", "claimhte", "crosáilte"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("claidheamhan tarsainn a chèile"),
            keywords: &[
                "arm",
                "claidheamhan",
                "claidheamhan tarsainn a chèile",
                "tarsainn",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("espadas cruzadas"),
            keywords: &["arma", "cruzadas", "espadas"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ક\u{acd}રોસ બનાવતી તલવારો"),
            keywords: &["ક\u{acd}રોસ બનાવતી તલવારો", "હથિયાર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("haɗaɗɗun takuba"),
            keywords: &["haɗaɗɗe", "haɗaɗɗun takuba", "makami", "takuba"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חרבות מוצלבות"),
            keywords: &["חרבות", "כלי נשק", "מוצלבות"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("क\u{94d}रॉस बनाती तलवार\u{947}\u{902}"),
            keywords: &[
                "क\u{94d}रॉस बनाती तलवार\u{947}\u{902}",
                "तलवार\u{947}\u{902}",
                "हथियार",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("prekriženi mačevi"),
            keywords: &["mačevi", "oružje", "prekriženi mačevi", "prekriženo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("keresztezett kardok"),
            keywords: &["fegyver", "kardok", "keresztbe tett", "keresztezett"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("խաչված սրեր"),
            keywords: &["զենք", "խաչված", "սրեր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pedang bersilang"),
            keywords: &["pedang", "pedang bersilang", "senjata", "silang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("mma agha nwere ngabichi"),
            keywords: &[
                "mma agha",
                "mma agha nwere ngabichi",
                "ngabichi",
                "ngwa agha",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("krosslögð sverð"),
            keywords: &["krosslögð", "sverð", "vopn"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("spade incrociate"),
            keywords: &["armi", "combattimento", "duello", "spade incrociate"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("クロスした剣"),
            keywords: &["つるぎ", "クロスした剣", "刀", "剣", "武器"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pedhang loro timpuk"),
            keywords: &["gegaman", "pedhang", "pedhang loro timpuk", "timpuk"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გადაკვეთილი ხმლები"),
            keywords: &["გადაკვეთილი", "იარაღი", "ხმალი", "ხმლები"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("айқас қылыштар"),
            keywords: &["айқас қылыштар", "айқасқан", "қару", "қылыштар"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("korslagte sværd"),
            keywords: &["korslagt", "korslagte sværd", "sværd", "våben"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ដាវព\u{17b8}រខ\u{17d2}វែងគ\u{17d2}នា"),
            keywords: &[
                "ខ\u{17d2}វែង",
                "ដាវ",
                "ដាវព\u{17b8}រខ\u{17d2}វែងគ\u{17d2}នា",
                "អាវ\u{17bb}ធ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{ccd}ರಾಸ\u{ccd} ಮಾಡ\u{cbf}ದ ಕತ\u{ccd}ತ\u{cbf}ಗಳು"),
            keywords: &[
                "ಕತ\u{ccd}ತರ\u{cbf}",
                "ಕತ\u{ccd}ತ\u{cbf}ಗಳು",
                "ಕ\u{ccd}ರಾಸ\u{ccd} ಮಾಡ\u{cbf}ದ ಕತ\u{ccd}ತ\u{cbf}ಗಳು",
                "ಶಸ\u{ccd}ತ\u{ccd}ರಾಸ\u{ccd}ತ\u{ccd}ರ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("쌍검"),
            keywords: &["검", "쌍검"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("छ\u{947}दक तलवारी"),
            keywords: &["छ\u{947}दक", "तलवारी", "हत\u{94d}यार"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кайчылашкан кылычтар"),
            keywords: &["кайчылашкан", "курал", "кылычтар"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("gekräizt Schwäerter"),
            keywords: &["Schwäerter", "Waff", "gekräizt"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ດາບໄຂວ\u{ec8}ກ\u{eb1}ນ"),
            keywords: &["ດາບ", "ດາບໄຂວ\u{ec8}ກ\u{eb1}ນ", "ອາວ\u{eb8}ດ", "ໄຂວ\u{ec8}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("sukryžiuoti kardai"),
            keywords: &["ginklai", "kardai", "sukryžiuoti"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sakrustoti zobeni"),
            keywords: &["ierocis", "sakrustoti zobeni", "sakrustots", "zobens"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("hoari whakawhiri"),
            keywords: &["hoari", "rākau-riri", "whakawhiri"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("вкрстени мечови"),
            keywords: &["вкрстени мечови", "меч", "оружје"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d41}റ\u{d41}കെയ\u{d41}ള\u{d4d}ള വ\u{d3e}ള\u{d41}കൾ"),
            keywords: &[
                "ആയ\u{d41}ധം",
                "ക\u{d41}റ\u{d41}കെയ\u{d41}ള\u{d4d}ള വ\u{d3e}ള\u{d41}കൾ",
                "ക\u{d41}റ\u{d41}കെയ\u{d41}ള\u{d4d}ളത\u{d4d}",
                "വ\u{d3e}ള\u{d41}കൾ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("солбиж тавьсан илбэ"),
            keywords: &["зэвсэг", "солбиж тавьсан илбэ", "солбио", "сэлэм"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some(
                "एकम\u{947}का\u{902}विर\u{942}द\u{94d}ध ठ\u{947}वल\u{94d}या जाणार\u{94d}\u{200d}या तलवारी",
            ),
            keywords: &[
                "एकम\u{947}का\u{902}विर\u{942}द\u{94d}ध ठ\u{947}वल\u{947}ल\u{947}",
                "एकम\u{947}का\u{902}विर\u{942}द\u{94d}ध ठ\u{947}वल\u{947}ल\u{94d}या तलवारी",
                "एकम\u{947}का\u{902}विर\u{942}द\u{94d}ध ठ\u{947}वल\u{94d}या जाणार\u{94d}\u{200d}या तलवारी",
                "तलवारी",
                "हत\u{94d}यार",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pedang bersilang"),
            keywords: &["bersilang", "pedang", "senjata"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("xwabel inkroċjati"),
            keywords: &["arma", "inkroċjati", "xwabel"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဓားန\u{103e}စ\u{103a}လက\u{103a} ကြက\u{103a}ခြေခတ\u{103a}"),
            keywords: &[
                "ကြက\u{103a}ခြေခတ\u{103a}",
                "ဓားန\u{103e}စ\u{103a}လက\u{103a}",
                "လက\u{103a}နက\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sverd i kryss"),
            keywords: &["kryss", "sverd", "sverd i kryss", "våpen"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("क\u{94d}रस तरवार"),
            keywords: &["क\u{94d}रस", "तरवार", "हतियार"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gekruiste zwaarden"),
            keywords: &["gekruist", "gekruiste zwaarden", "wapen", "zwaarden"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("sverd i kryss"),
            keywords: &["kryss", "sverd", "sverd i kryss", "våpen"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଛକ\u{b3f}ଯ\u{b41}କ\u{b4d}ତ ଖଣ\u{b4d}ଡ\u{b3e}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ"),
            keywords: &[
                "ଅସ\u{b4d}ତ\u{b4d}ରଶସ\u{b4d}ତ\u{b4d}ର",
                "ଖଣ\u{b4d}ଡ\u{b3e}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
                "ଛକ\u{b3f}ଯ\u{b41}କ\u{b4d}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a4d}ਰਾਸ ਬਣਾਉ\u{a02}ਦੀਆ\u{a02} ਤਲਵਾਰਾ\u{a02}"),
            keywords: &[
                "ਕ\u{a4d}ਰਾਸ ਕੀਤੀਆ\u{a02}",
                "ਕ\u{a4d}ਰਾਸ ਬਣਾਉ\u{a02}ਦੀਆ\u{a02} ਤਲਵਾਰਾ\u{a02}",
                "ਤਲਵਾਰਾ\u{a02}",
                "ਹਥਿਆਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ٹکراندیاں تلواراں"),
            keywords: &["تلواراں", "ٹکراندیاں تلواراں", "پار کیتا", "ہتھیار"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Sọd-dẹm Wé Dẹm Krọs"),
            keywords: &["Krọs", "Sọd-dẹm", "Sọd-dẹm Wé Dẹm Krọs", "Wẹ\u{301}pọn"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("skrzyżowane miecze"),
            keywords: &["biała broń", "miecze", "skrzyżowane"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("اوړېدلې تورې"),
            keywords: &["اوړېدلې", "تورې", "وسله"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("espadas cruzadas"),
            keywords: &["arma", "cruzadas", "espadas", "guerra"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["arma", "cruzadas", "espadas"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("săbii încrucișate"),
            keywords: &["arme", "spade", "săbii încrucișate", "încrucișare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-085"),
            keywords: &["E10-085"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("скрещенные мечи"),
            keywords: &[
                "два меча",
                "мечи",
                "оружие",
                "скрещенные",
                "холодное оружие",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("inkota zisobekeranye"),
            keywords: &["gisobekeranye", "inkota", "inkota zisobekeranye", "intwaro"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("آمهون سامهون تلوار"),
            keywords: &["آمهون سامهون", "آمهون سامهون تلوار", "تلوارون", "هٿيار"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හරහට තැබ\u{dd6} කඩ\u{dd4}"),
            keywords: &[
                "ආය\u{dd4}ධ",
                "කඩ\u{dd4}",
                "හරස\u{dca}",
                "හරහට තැබ\u{dd6} කඩ\u{dd4}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("prekrížené meče"),
            keywords: &["meče", "prekrížené meče", "skrížené", "zbraň"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("prekrižana meča"),
            keywords: &["meči", "orožje", "prekrižana meča", "prekrižano"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("seefo isweydaarsan"),
            keywords: &["hub", "isweydaarsan", "seefo"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shpata të kryqëzuara"),
            keywords: &[
                "armë",
                "e kryqëzuar",
                "shpata",
                "shpata të kryqëzuara",
                "të kryqëzuara",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("укрштени мачеви"),
            keywords: &["мачеви", "оружје", "укрштени мачеви", "укрштено"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["укрштени мачеви"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ukršteni mačevi"),
            keywords: &["mačevi", "oružje", "ukršteni mačevi", "ukršteno"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["ukršteni mačevi"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("korslagda svärd"),
            keywords: &["korsade", "korslagda svärd", "svärd", "vapen"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("panga zilizopishanishwa"),
            keywords: &["kupishanishwa", "panga zilizopishanishwa", "silaha", "sime"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "குறுக\u{bcd}க\u{bbe}க வைக\u{bcd}கப\u{bcd}பட\u{bcd}ட வ\u{bbe}ள\u{bcd}கள\u{bcd}",
            ),
            keywords: &[
                "ஆயுதம\u{bcd}",
                "குறுக\u{bcd}க\u{bbe}க வைக\u{bcd}கப\u{bcd}பட\u{bcd}ட வ\u{bbe}ள\u{bcd}கள\u{bcd}",
                "குறுக\u{bcd}க\u{bbe}ன வ\u{bbe}ள\u{bcd}கள\u{bcd}",
                "குறுக\u{bcd}க\u{bbe}னது",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "వ\u{c3f}రుద\u{c4d}ధ ద\u{c3f}శల\u{c4d}ల\u{c4b} ఉంచ\u{c3f}న ర\u{c46}ండు కత\u{c4d}తులు",
            ),
            keywords: &[
                "ఆయుధం",
                "కత\u{c4d}తులు",
                "వ\u{c3f}రుద\u{c4d}ధ ద\u{c3f}శల\u{c4d}ల\u{c4b} ఉంచడం",
                "వ\u{c3f}రుద\u{c4d}ధ ద\u{c3f}శల\u{c4d}ల\u{c4b} ఉంచ\u{c3f}న ర\u{c46}ండు కత\u{c4d}తులు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("шамшерҳои ба ҳам гузошташуда"),
            keywords: &[
                "силоҳ",
                "чиллик гузошташуда",
                "шамшер",
                "шамшерҳои ба ҳам гузошташуда",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ดาบไขว\u{e49}"),
            keywords: &["ดาบไขว\u{e49}", "ดาว", "อาว\u{e38}ธ", "ไขว\u{e49}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("atanaklaýyn gylyçlar"),
            keywords: &["atanaklaýyn", "gylyçlar", "ýarag"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("heletā fehauaki"),
            keywords: &["heletā fehauaki"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("çapraz kılıçlar"),
            keywords: &[
                "kılıç",
                "silah",
                "çapraz",
                "çapraz kılıçlar",
                "çarpı",
                "çatma",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قايچىلانما شەمشەرلەر"),
            keywords: &["شەمشەر", "قايچىلانما", "قايچىلانما شەمشەرلەر", "ياراغ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("схрещені мечі"),
            keywords: &["зброя", "мечі", "перехрещений", "схрещені мечі"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کراس کی شکل بناتی تلواریں"),
            keywords: &["تلواریں", "کراس", "کراس کی شکل بناتی تلواریں", "ہتھیار"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kesishgan qilichlar"),
            keywords: &["kesishgan", "qilichlar", "qurol"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("kiếm bắt chéo"),
            keywords: &["bắt chéo", "kiếm", "kiếm bắt chéo", "vũ khí"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bu am kruwaa eppee"),
            keywords: &["bu am kruwaa", "bu am kruwaa eppee", "eppee", "ngànnaay"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("amakrele anqamlezileyo"),
            keywords: &[
                "amakrele",
                "amakrele anqamlezileyo",
                "enqamlezileyo",
                "isixhobo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("idà alágbèélèbú"),
            keywords: &["idà", "idà alágbèélèbú", "irinṣẹ\u{301} ìjagun", "àgbélèbú"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("交叉嘅劍"),
            keywords: &["交叉", "交叉嘅劍", "劍", "武器"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("交叉嘅剑"),
            keywords: &["交叉", "交叉嘅剑", "剑", "武器"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("交叉放置的剑"),
            keywords: &["交叉", "交叉放置的剑", "剑", "双剑"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("劍"),
            keywords: &["劍"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("imikhonto ephambene"),
            keywords: &[
                "imikhonto",
                "imikhonto ephambene",
                "izikhali",
                "okuphambene",
            ],
        },
    ],
};
#[doc = "🔫"]
pub const WATER_PISTOL: crate::Emoji = crate::Emoji {
    glyph: "🔫",
    codepoint: "1F52B",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "water pistol",
    group: "Objects",
    subgroup: "tool",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("rewolwer"),
            keywords: &["rewolwer", "skiet", "vuurwapen", "wapen"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሽጉጥ"),
            keywords: &["መሣሪያ", "ሪቮልቨር", "ሽጉጥ", "ጦር መሣሪያ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مسدس ماء"),
            keywords: &["طبنجة", "مسدس", "مسدس ماء"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ৱ\u{9be}ট\u{9be}ৰ পিষ\u{9cd}টল"),
            keywords: &[
                "অস\u{9cd}ত\u{9cd}ৰ",
                "পিষ\u{9cd}টল",
                "বন\u{9cd}দ\u{9c1}ক",
                "স\u{981}জ\u{9c1}লি",
                "হস\u{9cd}তচ\u{9be}লিত বন\u{9cd}দ\u{9c1}ক",
                "ৰিভলভ\u{9be}ৰ",
                "ৱ\u{9be}ট\u{9be}ৰ পিষ\u{9cd}টল",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("tapança"),
            keywords: &["alət", "revolver", "silah", "tapança"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("вадзяны пісталет"),
            keywords: &[
                "вадзяны пісталет",
                "зброя",
                "пушка",
                "пісталет",
                "рэвальвер",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("воден пистолет"),
            keywords: &["воден пистолет", "оръжие", "пистолет", "револвер"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("পিস\u{9cd}তল"),
            keywords: &[
                "অস\u{9cd}ত\u{9cd}র",
                "পিস\u{9cd}তল",
                "বন\u{9cd}দ\u{9c1}ক",
                "রিভলব\u{9be}র",
                "সরঞ\u{9cd}জ\u{9be}ম",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pistolenn"),
            keywords: &["arm", "pistolenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("pištolj"),
            keywords: &["alat", "oružje", "pištolj", "revolver"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pistola d’aigua"),
            keywords: &[
                "arma",
                "arma de foc",
                "eina",
                "pistola",
                "pistola d’aigua",
                "revòlver",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᎶᏪ ᏍᏆᎳ"),
            keywords: &["ᎠᎵᏍᏕᎸᏙᏗ", "ᎦᎶᏪ", "ᎦᎶᏪ ᏍᏆᎳ", "ᎬᏔᏂᏓᏍᏗ", "ᏗᏓᏁᏟᏴᏍᎩ"],
        },
        #[cfg(feature = "ckb")]
        crate::Annotation {
            lang: "ckb",
            tts: Some("دەمانچەی ئاوی"),
            keywords: &["دەمانچەی ئاوی"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("vodní pistole"),
            keywords: &["nástroj", "pistole", "revolver", "vodní pistole", "zbraň"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("pistol dŵr"),
            keywords: &[
                "arf",
                "dryll",
                "llawddryll",
                "pistol",
                "pistol dŵr",
                "rifolfer",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("vandpistol"),
            keywords: &["pistol", "revolver", "vandpistol", "våben"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Wasserpistole"),
            keywords: &["Pistole", "Revolver", "Waffe", "Wasserpistole"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Wasserpistole"),
            keywords: &["Wasserpistole"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("νεροπίστολο"),
            keywords: &[
                "εργαλείο",
                "νεροπίστολο",
                "περίστροφο",
                "πιστόλι",
                "ρεβόλβερ",
                "όπλο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("water pistol"),
            keywords: &[
                "gun", "handgun", "pistol", "revolver", "tool", "water", "weapon",
            ],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("water pistol"),
            keywords: &["water pistol"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("water pistol"),
            keywords: &["toy", "water pistol"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pistola de agua"),
            keywords: &["agua", "juguete", "pistola", "pistola de agua", "verano"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("veepüstol"),
            keywords: &["püstol", "relv", "revolver", "tööriist", "veepüstol"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("pistola"),
            keywords: &["arma", "errebolber", "pistola", "tresna"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تفنگ آب\u{200c}پاش"),
            keywords: &["ابزار", "اسلحه", "تفنگ", "تفنگ آب\u{200c}پاش", "رولور"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vesipyssy"),
            keywords: &["pistooli", "pyssy", "revolveri", "vesipyssy"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("water gun"),
            keywords: &[
                "armas",
                "baril",
                "kagamitan",
                "revolver",
                "sandata",
                "water gun",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("pistólur"),
            keywords: &["handvápn", "pistólur", "revolvari", "skotvápn", "vápn"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("pistolet à eau"),
            keywords: &[
                "arme",
                "arme à feu",
                "pistolet",
                "pistolet à eau",
                "revolver",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("pistolet à eau"),
            keywords: &[
                "arme",
                "arme à feu",
                "pistolet",
                "pistolet à eau",
                "revolver",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("piostal"),
            keywords: &["arm", "gunna", "piostal"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("daga"),
            keywords: &["acainn", "arm", "daga", "gunna", "gunna-làimhe", "inneal"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("pistola de auga"),
            keywords: &["arma", "auga", "piscina", "pistola", "pistola de auga"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પિસ\u{acd}તોલ"),
            keywords: &["ગન", "પિસ\u{acd}તોલ", "રીવોલ\u{acd}વર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ƙaramar bindiga"),
            keywords: &[
                "bindiga",
                "bindigar hannu",
                "kayan aiki",
                "makami",
                "ƙaramar bindiga",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אקדח מים"),
            keywords: &["אקדח", "אקדח מים", "ירי", "יריות", "ירייה", "כלי נשק"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पानी की पिस\u{94d}तौल"),
            keywords: &[
                "औज\u{93c}ार",
                "पानी की पिस\u{94d}तौल",
                "ब\u{902}द\u{942}क",
                "रिवॉल\u{94d}वर",
                "हथियार",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("pištolj na vodu"),
            keywords: &["alat", "oružje", "pištolj", "pištolj na vodu", "revolver"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("vízipisztoly"),
            keywords: &["fegyver", "pisztoly", "revolver", "vízipisztoly"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ջրային ատրժանակ"),
            keywords: &["ատրճանակ", "գործիք", "զենք", "ջրային ատրժանակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pistol air"),
            keywords: &["alat", "pistol", "pistol air", "revolver", "senjata"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("egbe mmiri"),
            keywords: &[
                "egbe mmiri",
                "egbè",
                "egbè mgbagharị",
                "egbèaka",
                "mma agha",
                "ngwaọrụ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("byssa"),
            keywords: &["byssa", "skammbyssa"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pistola ad acqua"),
            keywords: &["arma", "pistola", "pistola ad acqua", "revolver"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("水鉄砲"),
            keywords: &["ピストル", "リボルバー", "拳銃", "武器", "水鉄砲", "銃"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bedhil"),
            keywords: &[
                "bedhil", "gegaman", "pistul", "pranti", "revolver", "senjata",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("პისტოლეტი"),
            keywords: &[
                "თოფი",
                "იარაღი",
                "ინსტრუმენტი",
                "პისტოლეტი",
                "რევოლვერი",
                "ხელსაწყო",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тапанша"),
            keywords: &["револьвер", "тапанша", "қару", "құрал"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("pistol"),
            keywords: &["pistol", "revolver", "våben"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កា\u{17c6}ភ\u{17d2}លើងបាញ\u{17cb}ទ\u{17b9}ក"),
            keywords: &[
                "កា\u{17c6}ភ\u{17d2}លើង",
                "កា\u{17c6}ភ\u{17d2}លើងខ\u{17d2}ល\u{17b8}",
                "កា\u{17c6}ភ\u{17d2}លើងបាញ\u{17cb}ទ\u{17b9}ក",
                "អាវ\u{17bb}ធ",
                "ឧបករណ\u{17cd}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪ\u{cbf}ಸ\u{ccd}ತ\u{cc2}ಲ\u{ccd}"),
            keywords: &[
                "ಪ\u{cbf}ಸ\u{ccd}ತ\u{cc2}ಲ\u{ccd}",
                "ರ\u{cbf}ವಾಲ\u{ccd}ವರ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("물총"),
            keywords: &["권총", "물총", "총"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पिस\u{94d}त\u{941}ल"),
            keywords: &[
                "गन",
                "पिस\u{94d}त\u{941}ल",
                "रिवोल\u{94d}वर",
                "साधन",
                "ह\u{901}डगन",
                "हत\u{94d}यार",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("пистолет"),
            keywords: &["курал", "пистолет", "револьвер"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Pistoul"),
            keywords: &["Pistoul", "Revolver", "Utensil", "Waff"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{eb7}ນສ\u{eb1}\u{ec9}ນ"),
            keywords: &[
                "ນ\u{ec9}ຳ",
                "ປ\u{eb7}ນ",
                "ປ\u{eb7}ນສ\u{eb1}\u{ec9}ນ",
                "ອາວ\u{eb8}ດ",
                "ເຄ\u{eb7}\u{ec8}ອງມ\u{eb7}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vandens šautuvas"),
            keywords: &[
                "ginklas",
                "pistoletas",
                "revolveris",
                "vandens šautuvas",
                "įrankis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ūdens pistole"),
            keywords: &[
                "ierocis",
                "pistole",
                "revolveris",
                "šaujamierocis",
                "ūdens pistole",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pū"),
            keywords: &["pū", "pū hurihuri", "pū ā-ringa", "rākau-riri", "utauta"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("пиштол на вода"),
            keywords: &["оружје", "пиштол", "пиштол на вода"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വ\u{d3e}ട\u{d4d}ടർ പിസ\u{d4d}റ\u{d4d}റൾ"),
            keywords: &[
                "ഗൺ",
                "തോക\u{d4d}ക\u{d4d}",
                "പിസ\u{d4d}റ\u{d4d}റൾ",
                "റിവോൾവർ",
                "വ\u{d3e}ട\u{d4d}ടർ പിസ\u{d4d}റ\u{d4d}റൾ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гар буу"),
            keywords: &["багаж", "буу", "гар буу", "зэвсэг"],
        },
        #[cfg(feature = "mni")]
        crate::Annotation {
            lang: "mni",
            tts: Some("ঈশিংক\u{9be}প\u{9cd}পী নোংমৈ"),
            keywords: &["ঈশিংক\u{9be}প\u{9cd}পী নোংমৈ"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पाण\u{94d}याची पिस\u{94d}त\u{942}ल"),
            keywords: &[
                "गन",
                "पाण\u{94d}याची पिस\u{94d}त\u{942}ल",
                "पिस\u{94d}त\u{941}ल",
                "रिव\u{94d}हॉल\u{94d}व\u{94d}हर",
                "साधन",
                "ह\u{901}डगन",
                "हत\u{94d}यार",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pistol air"),
            keywords: &["alat", "pistol", "pistol air", "revolver", "senjata"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("pistola"),
            keywords: &["arma", "għodda", "pistola", "revolvers", "xkubetta"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပစ\u{1039}စတ\u{102d}\u{102f}"),
            keywords: &[
                "က\u{102d}ရ\u{102d}ယာ",
                "ခြောက\u{103a}လ\u{102f}\u{1036}းပြ\u{1030}း",
                "ပစ\u{1039}စတ\u{102d}\u{102f}",
                "လက\u{103a}နက\u{103a}",
                "သေနတ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("vannpistol"),
            keywords: &["leketøysvåpen", "pistol", "vannpistol"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पिस\u{94d}तोल"),
            keywords: &[
                "पिस\u{94d}तोल",
                "बन\u{94d}द\u{941}क",
                "रिभल\u{94d}बर",
                "साधन",
                "हतियार",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("waterpistool"),
            keywords: &[
                "blaffer",
                "gereedschap",
                "pistool",
                "revolver",
                "vuurwapen",
                "wapen",
                "waterpistool",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("vasspistol"),
            keywords: &["pistol", "revolver", "vasspistol", "våpen"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b3f}ସ\u{b4d}ତଲ"),
            keywords: &[
                "ଗନ\u{b4d}",
                "ପ\u{b3f}ସ\u{b4d}ତଲ",
                "ପ\u{b3f}ସ\u{b4d}ତଲ\u{b4d}",
                "ର\u{b3f}ଭୋଲ\u{b4d}\u{200c}ଭର\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪਿਸਤ\u{a4c}ਲ"),
            keywords: &["ਪਿਸਤ\u{a4c}ਲ", "ਬ\u{a70}ਦ\u{a42}ਕ", "ਰਿਵਾਲਵਰ", "ਹਥਿਆਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پستول"),
            keywords: &[
                "اوزار",
                "بندوق",
                "ریوالور",
                "پستول",
                "ہتھ نال چلن آلا پستول",
                "ہتھیار",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wọ\u{301}tá Pístul"),
            keywords: &[
                "Gọn",
                "Hándgọn",
                "Pístul",
                "Rívọ\u{301}lva",
                "Tul",
                "Wẹ\u{301}pọn",
                "Wọ\u{301}tá Pístul",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pistolet na wodę"),
            keywords: &[
                "broń",
                "broń palna",
                "pistolet",
                "pistolet na wodę",
                "rewolwer",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("طمانچه"),
            keywords: &["اله", "ريوالور", "طمانچه", "لاسي ټوپک", "وسله", "ټوپک"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pistola d’água"),
            keywords: &[
                "arma",
                "ferramenta",
                "pistola",
                "pistola d’água",
                "revólver",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("pistola de água"),
            keywords: &["arma", "pistola", "pistola de água", "revólver"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pistol cu apă"),
            keywords: &["armă", "armă de foc", "pistol", "pistol cu apă", "revolver"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-743"),
            keywords: &["E10-743"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("водяной пистолет"),
            keywords: &["водяной пистолет", "игрушка", "оружие", "пистолет"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("masotera"),
            keywords: &["igikoresho", "imbunda", "intwaro", "masotera", "revoluveri"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پسٽل"),
            keywords: &["اوزار", "روالور", "هينڊ گن", "هٿيار", "پسٽل", "گن"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd2}ස\u{dca}තෝලය"),
            keywords: &[
                "ආය\u{dd4}ධය",
                "ප\u{dd2}ස\u{dca}තෝලය",
                "මෙවලම",
                "ර\u{dd2}වෝල\u{dca}වරය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("vodná pištoľ"),
            keywords: &["nástroj", "pištoľ", "revolver", "vodná pištoľ", "zbraň"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vodna pištola"),
            keywords: &["orodje", "orožje", "pištola", "revolver", "vodna pištola"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("bastoolad"),
            keywords: &[
                "bastoolad",
                "bastoolada ay dhexdu wareegto",
                "hub",
                "qalab",
                "qori",
                "qori gacmeed",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("pistoletë"),
            keywords: &["armë", "pistoletë", "pushkë", "revolver", "vegël"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("водени пиштољ"),
            keywords: &[
                "aлaт",
                "oружje",
                "водени пиштољ",
                "пиштoљ",
                "пиштољ",
                "рeвoлвeр",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("vodeni pištolj"),
            keywords: &["alat", "oružje", "pištolj", "revolver", "vodeni pištolj"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("vattenpistol"),
            keywords: &["pistol", "revolver", "vapen", "vattenpistol"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("bastola ya maji"),
            keywords: &[
                "bastola",
                "bastola ya maji",
                "bunduki",
                "maji",
                "silaha",
                "zana",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("தண\u{bcd}ண\u{bc0}ர\u{bcd} பிஸ\u{bcd}டல\u{bcd}"),
            keywords: &[
                "தண\u{bcd}ண\u{bc0}ர\u{bcd} பிஸ\u{bcd}டல\u{bcd}",
                "துப\u{bcd}ப\u{bbe}க\u{bcd}கி",
                "பிஸ\u{bcd}டல\u{bcd}",
                "ரிவ\u{bbe}ல\u{bcd}வர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("న\u{c40}ట\u{c3f} ప\u{c3f}స\u{c4d}టల\u{c4d}"),
            keywords: &[
                "చ\u{c3f}న\u{c4d}న తుప\u{c3e}క\u{c40}",
                "న\u{c40}ట\u{c3f} ప\u{c3f}స\u{c4d}టల\u{c4d}",
                "ప\u{c3f}స\u{c4d}త\u{c4b}లు",
                "ర\u{c3f}వ\u{c3e}ల\u{c4d}వర\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("таппонча"),
            keywords: &[
                "асбоб",
                "револвер",
                "силоҳ",
                "таппонча",
                "яроқ",
                "яроқи дастӣ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ป\u{e37}นฉ\u{e35}ดน\u{e49}ำ"),
            keywords: &[
                "ป\u{e37}น",
                "ป\u{e37}นฉ\u{e35}ดน\u{e49}ำ",
                "ป\u{e37}นพก",
                "อาว\u{e38}ธ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("sapança"),
            keywords: &["gural", "nagan", "rewolwer", "sapança", "ýarag"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pekenene vai"),
            keywords: &["pekenene", "pekenene vai"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("su tabancası"),
            keywords: &["revolver", "silah", "su tabancası", "tabanca"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تاپانچا"),
            keywords: &["ئايلانما تاپانچا", "تاپانچا", "قورال", "مىلتىق", "ياراغ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("пістолет"),
            keywords: &[
                "водяний пістолет",
                "зброя",
                "знаряддя",
                "пістолет",
                "револьвер",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پستول"),
            keywords: &["پانی کی پستول", "پستول", "ہتھیار"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("suvli pistolet"),
            keywords: &[
                "pistolet",
                "qurol",
                "revolver",
                "suvli pistolet",
                "toʻpponcha",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("súng nước"),
            keywords: &[
                "dụng cụ",
                "súng",
                "súng gắn",
                "súng lục",
                "súng lục ổ quay",
                "súng nước",
                "vũ khí",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("pistole"),
            keywords: &["fetal", "jumtukaay", "ngànnaay", "pistole"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umpu"),
            keywords: &["isixhobo", "ivolovolo", "umpu", "umpu wesandla"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ibọn ilewọ"),
            keywords: &[
                "ibọn ilewọ",
                "irinṣẹ\u{301}",
                "ìbọn",
                "ìbọn ìléwó\u{329}",
                "ìbọn ṣakabùlà",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("手槍"),
            keywords: &["工具", "左輪手槍", "手槍", "槍", "武器"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("手枪"),
            keywords: &["工具", "左轮手枪", "手枪", "枪", "武器"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("水枪"),
            keywords: &["工具", "左轮", "手枪", "枪", "武器", "水枪"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("水槍"),
            keywords: &["手槍", "槍", "水槍"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["手槍", "槍", "槍｜武器｜工具", "水槍"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ivolovolo"),
            keywords: &[
                "irivolva",
                "isibhamu",
                "isibhamu esincane",
                "isikhali",
                "ithuluzi",
                "ivolovolo",
            ],
        },
    ],
};
#[doc = "🪃"]
pub const BOOMERANG: crate::Emoji = crate::Emoji {
    glyph: "🪃",
    codepoint: "1FA83",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "boomerang",
    group: "Objects",
    subgroup: "tool",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("boemerang"),
            keywords: &["Australië", "boemerang", "terugdraai", "terugkeer"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቡምራንግ"),
            keywords: &["ቡምራንግ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("خذوف مرتد"),
            keywords: &["أستراليا", "ارتداد", "خذوف", "كيد", "مرتد"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9be}ঠৰ অস\u{9cd}ত\u{9cd}ৰ"),
            keywords: &[
                "অষ\u{9cd}ট\u{9cd}ৰেলিয\u{9bc}\u{9be}",
                "ক\u{9be}ঠৰ অস\u{9cd}ত\u{9cd}ৰ",
                "প\u{9cd}ৰতিক\u{9cd}ৰিয\u{9bc}\u{9be}",
                "ৰিব\u{9be}উণ\u{9cd}ড",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("bumeranq"),
            keywords: &["avstraliya", "bumeranq", "rikoşet", "əksetmə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("бумеранг"),
            keywords: &["Аўстралія", "бумеранг", "вяртанне", "зварот"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("бумеранг"),
            keywords: &["Австралия", "бумеранг", "връщане", "откат"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9c1}মের\u{200c}\u{9cd}য\u{9be}ঙ"),
            keywords: &[
                "অস\u{9cd}ট\u{9cd}রেলিয\u{9bc}\u{9be}",
                "প\u{9cd}রতিক\u{9cd}রিয\u{9bc}\u{9be}",
                "প\u{9cd}রতিক\u{9cd}ষিপ\u{9cd}ত",
                "ব\u{9c1}মের\u{200c}\u{9cd}য\u{9be}ঙ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("boumerang"),
            keywords: &["Aostralia", "boumerang"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("bumerang"),
            keywords: &["australija", "bumerang", "reperkusija", "vraćanje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bumerang"),
            keywords: &["Austràlia", "bumerang", "rebot", "repercussió"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏩᏗᏅᏗ ᎠᎴ ᎥᎦᎷᏨ"),
            keywords: &["ᎠᎿᏗᏢ", "ᎡᎳᏗᏜ", "ᎥᎦᎷᏨ", "ᏓᏓᏛᎾᏍᏗᏍᎬ", "ᏩᏗᏅᏗ ᎠᎴ ᎥᎦᎷᏨ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("bumerang"),
            keywords: &["austrálie", "bumerang", "návrat", "odraz"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bwmerang"),
            keywords: &["Awstralia", "adlam", "bwmerang", "ôl-effaith"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("boomerang"),
            keywords: &[
                "Australien",
                "bagslag",
                "boomerang",
                "rikochettere",
                "tilbagekastning",
                "vende tilbage",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Bumerang"),
            keywords: &["Australien", "Boomerang", "Bumerang"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μπούμερανγκ"),
            keywords: &["αυστραλία", "μπούμερανγκ", "συνέπεια"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("boomerang"),
            keywords: &["australia", "boomerang", "rebound", "repercussion"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bumerán"),
            keywords: &["Australia", "boomerang", "bumerán", "rebotar"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("bumerang"),
            keywords: &["austraalia", "bumerang", "tagasilend", "tagasipöördumine"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bumeran"),
            keywords: &[
                "aurkakoa",
                "australia",
                "bumeran",
                "bumerana",
                "errebotea",
                "itzulera",
                "kontrakoa",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بومرنگ"),
            keywords: &["استرالیا", "بومرنگ", "واجهش", "کمانه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("bumerangi"),
            keywords: &["australia", "bumerangi", "kimmota takaisin", "seuraus"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("boomerang"),
            keywords: &["australia", "boomerang", "rebound", "repercussion"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("boomerang"),
            keywords: &["Avstralia", "bomerang", "boomerang", "kastivápn"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("boomerang"),
            keywords: &["australie", "boomerang", "répercussion"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("boomerang"),
            keywords: &["australie", "boomerang", "outil", "retour", "répercussion"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("búmarang"),
            keywords: &["an Astráil", "búmarang", "filleadh"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bùmarang"),
            keywords: &[
                "Astràilia",
                "ath-leum",
                "buaidh",
                "buil",
                "bùmarang",
                "tilleadh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("búmerang"),
            keywords: &["Australia", "búmerang", "rebotar", "repercusión"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બ\u{ac2}મર\u{ac7}\u{a82}ગ"),
            keywords: &[
                "અથડાઈન\u{ac7} પાછ\u{ac1}\u{a82} આવવ\u{ac1}\u{a82}",
                "ઑસ\u{acd}ટ\u{acd}ર\u{ac7}લિયા",
                "પ\u{acd}રતિક\u{acd}રિયા",
                "બ\u{ac2}મર\u{ac7}\u{a82}ગ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("בומרנג"),
            keywords: &["אוסטרליה", "בומרנג", "חרב פיפיות", "לחזור כבומרנג"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ब\u{942}मर\u{948}\u{902}ग"),
            keywords: &[
                "ऑस\u{94d}ट\u{94d}र\u{947}लिया",
                "प\u{94d}रतिध\u{94d}वनि",
                "ब\u{942}मर\u{948}\u{902}ग",
                "ब\u{942}मर\u{948}ग",
                "रीबाउ\u{902}ड",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("bumerang"),
            keywords: &["Australija", "bumerang", "posljedica", "vraćanje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("bumeráng"),
            keywords: &["ausztrália", "bumeráng", "visszajön", "visszarepül"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բումերանգ"),
            keywords: &["ավստրալիա", "բումերանգ", "հետևանքներ", "վերադարձ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bumerang"),
            keywords: &["australia", "berbalik", "bumerang", "melambung"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("búmerang"),
            keywords: &["búmerang", "endurkast", "endurvarp", "Ástralía"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("boomerang"),
            keywords: &["australia", "boomerang", "rimbalzo", "ripercussione"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ブーメラン"),
            keywords: &[
                "オーストラリア",
                "ブーメラン",
                "武器",
                "玩具",
                "跳ね返り",
                "返って来る",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bumerang"),
            keywords: &["bumerang", "kumandang", "mantul", "ostrali"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბუმერანგი"),
            keywords: &["ავსტრალია", "ბუმერანგი", "დაბრუნება", "უკუცემა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бумеранг"),
            keywords: &["Австралия", "айналып келу", "бумеранг", "кері реакция"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17d2}រដាប\u{17cb}គប\u{17cb}លេង"),
            keywords: &[
                "ត\u{17d2}រឡប\u{17cb}មកវ\u{17b7}ញ",
                "ប\u{17d2}រដាប\u{17cb}គប\u{17cb}លេង",
                "អ\u{17bc}ស\u{17d2}ត\u{17d2}រាល\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{cc2}ಮರಾಂಗ\u{ccd}"),
            keywords: &[
                "ಆಸ\u{ccd}ಟ\u{ccd}ರೇಲ\u{cbf}ಯಾ",
                "ಪರ\u{cbf}ಣಾಮ",
                "ಬ\u{cc2}ಮರಾಂಗ\u{ccd}",
                "ಮರುಕಳ\u{cbf}ಸುವ\u{cbf}ಕ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("부메랑"),
            keywords: &["반동", "부메랑", "영향", "호주"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ब\u{941}मर\u{902}ग"),
            keywords: &[
                "ऑस\u{94d}ट\u{94d}र\u{947}लिया",
                "ब\u{941}मर\u{902}ग",
                "रिबाव\u{902}ड",
                "र\u{947}प\u{947}रकशन",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бумеранг"),
            keywords: &["бумеранг"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ບ\u{eb9}ມເມ\u{eb5}ແລງ"),
            keywords: &[
                "ບ\u{eb9}ມເມ\u{eb5}ແລງ",
                "ສະທ\u{ec9}ອນກ\u{eb1}ບ",
                "ອອສເຕເລຍ",
                "ເດ\u{eb1}\u{ec9}ງກ\u{eb1}ບ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("bumerangas"),
            keywords: &["australija", "bumerangas", "grįžimas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("bumerangs"),
            keywords: &["Austrālija", "atlēciens", "atsitiens", "bumerangs"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("бумеранг"),
            keywords: &["австралија", "бумеранг", "враќање", "реперкусии"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ബ\u{d42}മറ\u{d3e}ങ\u{d4d}"),
            keywords: &[
                "ഓസ\u{d4d}ട\u{d4d}രേലിയ",
                "പ\u{d42}വസ\u{d4d}ഥിതി പ\u{d4d}ര\u{d3e}പിക\u{d4d}ക\u{d41}ക",
                "പ\u{d42}ർവസ\u{d4d}ഥിതിയിലേക\u{d4d}ക\u{d4d} തിരിച\u{d4d}ച\u{d41}വരൽ",
                "ബ\u{d42}മറ\u{d3e}ങ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("boomerang"),
            keywords: &["boomerang", "австрали", "дахин ойх", "тийрэлт"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ब\u{942}मर\u{945}\u{902}ग"),
            keywords: &[
                "ऑस\u{94d}ट\u{94d}र\u{947}लिया",
                "परत य\u{947}ण\u{947}",
                "परिणाम",
                "ब\u{942}मर\u{945}\u{902}ग",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bumerang"),
            keywords: &["australia", "bertentangan", "bumerang", "gema", "lantun"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ထ\u{102d}ကပြန\u{103a}"),
            keywords: &[
                "ဂယက\u{103a}ရ\u{102d}\u{102f}က\u{103a}မ\u{103e}\u{102f}",
                "ထ\u{102d}ကပြန\u{103a}",
                "ပြန\u{103a}ကန\u{103a}ခြင\u{103a}း",
                "သြစတြေးလျား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bumerang"),
            keywords: &["australia", "boomerang", "bumerang", "retur", "tilbake"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ब\u{941}मर\u{94d}\u{200d}याङ"),
            keywords: &[
                "अस\u{94d}ट\u{94d}र\u{947}लिया",
                "प\u{942}र\u{94d}व सावधानी",
                "ब\u{941}मर\u{94d}\u{200d}याङ",
                "रिबाउन\u{94d}ड",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("boemerang"),
            keywords: &["Australië", "boemerang", "reactie", "terugslag"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bumerang"),
            keywords: &["australia", "boomerang", "bumerang", "retur", "tilbake"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବକ\u{b4d}ର କ\u{b3e}ଠ କ\u{b4d}ଷେପଣ\u{b3e}ସ\u{b4d}ତ\u{b4d}ର"),
            keywords: &[
                "ଅଷ\u{b4d}ଟ\u{b4d}ରେଲ\u{b3f}ଆ",
                "ପ\u{b4d}ରତ\u{b3f}ଘ\u{b3e}ତ",
                "ଫେର\u{b3f}ଆସ\u{b3f}ବ\u{b3e}",
                "ବକ\u{b4d}ର କ\u{b3e}ଠ କ\u{b4d}ଷେପଣ\u{b3e}ସ\u{b4d}ତ\u{b4d}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a42}ਮਰ\u{a48}\u{a02}ਗ"),
            keywords: &[
                "ਅਸਟਰ\u{a47}ਲੀਆ",
                "ਆਦਿਵਾਸੀਆ\u{a02} ਦਾ ਹਥਿਆਰ",
                "ਪਰਤਵਾ\u{a02}",
                "ਬ\u{a42}ਮਰ\u{a48}\u{a02}ਗ",
                "ਮ\u{a4b}ੜਵਾ\u{a02}",
                "ਲ\u{a71}ਕੜੀ ਦਾ ਹਥਿਆਰ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Búmárang"),
            keywords: &["Baúns Bak", "Bád Rizọlt", "Búmárang", "Ọstrélia"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("bumerang"),
            keywords: &["Aborygeni", "Australia", "bumerang", "wraca"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کږه لکړه"),
            keywords: &["آستراليا", "راتمبېدل", "عکس العمل", "کږه لکړه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bumerangue"),
            keywords: &["austrália", "bumerangue", "rebote", "repercussão"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["bumerangue"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bumerang"),
            keywords: &["Australia", "bumerang", "repercusiune", "revenire"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-062"),
            keywords: &["E13-062"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("бумеранг"),
            keywords: &["австралия", "бумеранг", "возврат", "последствия"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بومرانگ"),
            keywords: &["آسٽريليا", "بومرانگ", "ريبائونڊ", "ريپرڪشن"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බ\u{dd6}මරංගය"),
            keywords: &[
                "ඕස\u{dca}ට\u{dca}\u{200d}රේල\u{dd2}ය\u{dcf}ව",
                "නැවත පැම\u{dd2}ණ\u{dd3}ම",
                "පර\u{dcf}වර\u{dca}තනය",
                "බ\u{dd6}මරංගය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("bumerang"),
            keywords: &["austrálsky", "bumerang", "následky", "návrat"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("bumerang"),
            keywords: &["avstralija", "bumerang", "udarec nazaj", "vračanje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("majo"),
            keywords: &["australia", "dib u eegis", "dib usoo noqosho", "majo"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("bumerang"),
            keywords: &["australi", "bumerang", "pasojë", "rikthim"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("бумеранг"),
            keywords: &["аустралија", "бумеранг", "враћање", "последице"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["бумеранг"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("bumerang"),
            keywords: &["australija", "bumerang", "posledice", "vraćanje"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["bumerang"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("boomerang"),
            keywords: &["australien", "boomerang", "bumerang", "flyga tillbaka"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("bumerangi"),
            keywords: &["australia", "bumerangi", "kurudi", "matokeo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பூமர\u{bbe}ங\u{bcd}க\u{bcd}"),
            keywords: &[
                "ஆஸ\u{bcd}திரேலிய\u{bbe}",
                "திரும\u{bcd}பி வருதல\u{bcd}",
                "பூமர\u{bbe}ங\u{bcd}க\u{bcd}",
                "ர\u{bc0}பவுன\u{bcd}ட\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బూమర\u{c3e}ంగ\u{c4d}"),
            keywords: &[
                "ఆస\u{c4d}ట\u{c4d}ర\u{c47}ల\u{c3f}య\u{c3e}",
                "పర\u{c3f}ణ\u{c3e}మం",
                "బూమర\u{c3e}ంగ\u{c4d}",
                "ర\u{c40}బ\u{c4c}ండ\u{c4d}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("บ\u{e39}มเมอแรง"),
            keywords: &[
                "การเด\u{e49}งกล\u{e31}บ",
                "บ\u{e39}มเมอแรง",
                "สะท\u{e49}อนกล\u{e31}บ",
                "ออสเตรเล\u{e35}ย",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("bumerang"),
            keywords: &[
                "awstraliýa",
                "bumerang",
                "degip gaýtmak",
                "garşy",
                "seslenme",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pūmalengi"),
            keywords: &["pūmalengi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("bumerang"),
            keywords: &["avustralya", "bumerang", "geri tepme", "sekme", "tepki"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("бумеранг"),
            keywords: &["австралія", "бумеранг", "віддача", "рикошет"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بومرینگ"),
            keywords: &["آسٹریلیا", "بازگشت", "بومرینگ", "پلٹاؤ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("bumerang"),
            keywords: &["aks-sado", "avstraliya", "bumerang", "qaytish"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bumơrang"),
            keywords: &["australia", "bumơrang", "bật lại", "dội lại"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("回力鏢"),
            keywords: &["反射", "反彈", "回力鏢", "澳洲"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("回力镖"),
            keywords: &["反射", "反弹", "回力镖", "澳洲"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("回旋镖"),
            keywords: &["反弹", "回弹", "回旋镖", "澳大利亚"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("迴力鏢"),
            keywords: &["回飛棒", "澳洲", "迴力鏢", "迴旋", "迴旋鏢"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-boomerang"),
            keywords: &["e-australia", "i-boomerang", "i-rebound", "i-repercussion"],
        },
    ],
};
#[doc = "🏹"]
pub const BOW_AND_ARROW: crate::Emoji = crate::Emoji {
    glyph: "🏹",
    codepoint: "1F3F9",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "bow and arrow",
    group: "Objects",
    subgroup: "tool",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("pyl en boog"),
            keywords: &[
                "boog",
                "boogskutter",
                "diereriem",
                "pyl",
                "pyl en boog",
                "sagittarius",
                "wapen",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ደጋን እና ቀስት"),
            keywords: &["መልህቅ", "ሳጂታሪየስ", "ቀስት", "ዞዲያክ", "ደጋን እና ቀስት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قوس وسهم"),
            keywords: &["برج الرامي", "رامي", "سهم", "قوس", "قوس وسهم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ধন\u{9c1} আৰ\u{9c1} ক\u{9be}\u{981}ড\u{9bc}"),
            keywords: &[
                "ক\u{9be}\u{981}ড\u{9bc}",
                "ধন\u{9c1}",
                "ধন\u{9c1} আৰ\u{9c1} ক\u{9be}\u{981}ড\u{9bc}",
                "ধন\u{9c1} ৰ\u{9be}শি",
                "ধন\u{9c1}ৰ\u{9cd}বিদ\u{9cd}য\u{9be}",
                "ৰ\u{9be}শিচক\u{9cd}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ox və kaman"),
            keywords: &[
                "alət",
                "ox",
                "ox və kaman",
                "oxatan",
                "silah",
                "tənzim etmək",
                "zodiak",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("лук са стралой"),
            keywords: &["задыяк", "лук са стралой", "стралец"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Лък и стрела"),
            keywords: &["Лък и стрела", "зодия", "лък", "стрела", "стрелец"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("তীর ধন\u{9c1}ক"),
            keywords: &[
                "তীর",
                "তীরন\u{9cd}দ\u{9be}জ",
                "ধন\u{9c1}ক",
                "ধন\u{9c1}র\u{9be}শি",
                "র\u{9be}শিচক\u{9cd}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("gwareg ha saezh"),
            keywords: &["gwareg", "gwareg ha saezh", "gwareger", "saezh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("luk i strijela"),
            keywords: &["luk", "luk i strijela", "strijela", "strijelac", "zodijak"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("arc i fletxa"),
            keywords: &["Sagitari", "arc", "arc i fletxa", "fletxa", "zodíac"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᎵᏣᏗ ᎠᎴ ᎠᏝᏗ"),
            keywords: &[
                "ᎠᏉᏂᏍᎩ",
                "ᎠᏉᏅᏙᏗ",
                "ᎠᏍᎦᏯ ᏐᏈᎵ ᎤᎬᎭᎵ",
                "ᎦᎵᏣᏗ",
                "ᎦᎵᏣᏗ ᎠᎴ ᎠᏝᏗ",
                "ᎦᏝᏗ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("luk a šíp"),
            keywords: &[
                "luk",
                "luk a šíp",
                "střelec",
                "výzbroj",
                "zbraň",
                "zvěrokruh",
                "šíp",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bwa saeth"),
            keywords: &["bwa", "saeth", "saethwr", "sidydd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bue og pil"),
            keywords: &[
                "bue",
                "bue og pil",
                "bueskytte",
                "pil",
                "skytten",
                "stjernetegn",
                "våben",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Pfeil und Bogen"),
            keywords: &["Bogen", "Pfeil", "Pfeil und Bogen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τόξο και βέλος"),
            keywords: &[
                "Τοξότης",
                "βέλος",
                "εργαλείο",
                "ζώδιο",
                "τοξοβόλος",
                "τοξότης",
                "τόξο",
                "τόξο και βέλος",
                "όπλο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("bow and arrow"),
            keywords: &[
                "Sagittarius",
                "archer",
                "arrow",
                "bow",
                "bow and arrow",
                "zodiac",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("arco y flecha"),
            keywords: &[
                "arco",
                "arco y flecha",
                "arquero",
                "flecha",
                "sagitario",
                "zodiaco",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("vibu ja nool"),
            keywords: &["ambur", "nool", "relv", "vibu", "vibu ja nool"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("arkua eta gezia"),
            keywords: &[
                "arkua",
                "arkua eta gezia",
                "arkularia",
                "arma",
                "gezia",
                "sagittarius",
                "zodiakoa",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تیر و کمان"),
            keywords: &[
                "اسلحه",
                "برج فلکی",
                "تیر",
                "تیر و کمان",
                "زودیاک",
                "پیکان",
                "کمان",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("jousi ja nuoli"),
            keywords: &[
                "ase",
                "horoskooppi",
                "horoskooppimerkki",
                "jousi ja nuoli",
                "jousiammunta",
                "jousimies",
                "jousipyssy",
                "työkalu",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pana"),
            keywords: &["arkero", "palaso", "pana", "sagittarius", "zodiac"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("bogi of pílur"),
            keywords: &[
                "Bogamaður",
                "bogaskjótari",
                "bogaskjóting",
                "bogi",
                "bogi of pílur",
                "pílur",
                "stjørnumerki",
                "vápn",
                "ørvargarpur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("arc et flèche"),
            keywords: &["Sagittaire", "arc", "arc et flèche", "archer", "flèche"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["arc", "arc et flèche", "flèche", "sagittaire", "zodiaque"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("saighead is bogha"),
            keywords: &[
                "Sagittarius",
                "bogha",
                "bogha agus saighead",
                "boghdóir",
                "saighead",
                "saighead is bogha",
                "stoidiaca",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bogha agus saighead"),
            keywords: &[
                "acainn",
                "arm",
                "bogha",
                "bogha agus saighead",
                "boghadair",
                "boghadaireachd",
                "grian-chriosach",
                "inneal",
                "sagittarius",
                "saighdear",
                "saighead",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("arco e frecha"),
            keywords: &["Saxitario", "arco", "arco e frecha", "frecha", "zodíaco"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("તીર અન\u{ac7} કમાન"),
            keywords: &[
                "તીર અન\u{ac7} કમાન",
                "તીર\u{a82}દાજ",
                "રાશિ",
                "સાધન",
                "હથિયાર",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("baka da kibiya"),
            keywords: &[
                "Sagittarius",
                "baka",
                "baka da kibiya",
                "kayan aiki",
                "kibiya",
                "mai baka",
                "makami",
                "wasan baka",
                "zodiac",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חץ וקשת"),
            keywords: &["גלגל המזלות", "חץ", "חץ וקשת", "קשת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("तीर और कमान"),
            keywords: &["ट\u{942}ल", "तीर और कमान", "धन\u{941}ष", "बाण", "राशि"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("luk i strijela"),
            keywords: &[
                "alat",
                "luk",
                "luk i strijela",
                "oružje",
                "strijela",
                "strijelac",
                "zodijak",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("íj és nyíl"),
            keywords: &["fegyver", "nyilas", "nyíl", "íj", "íj és nyíl"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("նետ ու աղեղ"),
            keywords: &["աղեղ", "աղեղնավոր", "գործիք", "զենք", "նետ", "նետ ու աղեղ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("busur dan panah"),
            keywords: &[
                "Sagitarius",
                "busur",
                "busur dan panah",
                "panah",
                "pemanah",
                "zodiak",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụta na àkụ"),
            keywords: &[
                "Akara ụta na akụ",
                "akụ",
                "ngwa agha",
                "ngwaọrụ",
                "onye agha",
                "zodịak",
                "òji ụta",
                "ụta na àkụ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("bogi og ör"),
            keywords: &["bogaskytta", "bogi", "bogi og ör", "bogmaður", "ör"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("arco e freccia"),
            keywords: &[
                "arciere",
                "arco e freccia",
                "tiratore d’arco",
                "tiro con l’arco",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("弓矢"),
            keywords: &["射手", "弓矢", "星座", "武器", "矢"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("gendewa lan panah"),
            keywords: &[
                "Sagittarius",
                "gendewa",
                "gendewa lan panah",
                "palintangan",
                "pamanah",
                "panah",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მშვილდ-ისარი"),
            keywords: &[
                "ზოდიაქო",
                "იარაღი",
                "ინსტრუმენტი",
                "ისარი",
                "მოისარი",
                "მშვილდ-ისარი",
                "მშვილდი",
                "მშვილდოსანი",
                "ჰოროსკოპი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жебе мен садақ"),
            keywords: &[
                "жебе",
                "жебе мен садақ",
                "зодиак",
                "көрсеткі",
                "мерген",
                "садақшы",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("bue og pil"),
            keywords: &[
                "bue",
                "bue og pil",
                "bueskytte",
                "pil",
                "skytten",
                "stjernetegn",
                "våben",
                "værktøj",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ធ\u{17d2}ន\u{17bc}ន\u{17b7}ងព\u{17d2}រ\u{17bd}ញ"),
            keywords: &[
                "ធ\u{17d2}ន\u{17bc}",
                "ធ\u{17d2}ន\u{17bc}ន\u{17b7}ងព\u{17d2}រ\u{17bd}ញ",
                "ព\u{17d2}រ\u{17bd}ញ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{cbf}ಲ\u{ccd}ಲು ಮತ\u{ccd}ತು ಬಾಣ"),
            keywords: &[
                "ಕತ\u{ccd}ತರ\u{cbf}",
                "ಕತ\u{ccd}ತ\u{cbf}ಗಳು",
                "ಗುರಾಣ\u{cbf}",
                "ಬ\u{cbf}ಲ\u{ccd}ಲು ಮತ\u{ccd}ತು ಬಾಣ",
                "ಶಸ\u{ccd}ತ\u{ccd}ರಾಸ\u{ccd}ತ\u{ccd}ರ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("활과 화살"),
            keywords: &["궁수", "사수자리", "화살", "활", "활과 화살"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बाण आनी धन\u{941}श\u{94d}य"),
            keywords: &[
                "धन\u{941}र\u{94d}विद\u{94d}या",
                "धन\u{941}श\u{94d}य",
                "बाण",
                "बाण आनी धन\u{941}श\u{94d}य",
                "रास",
                "व\u{943}श\u{94d}चीक",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жаа менен жебе"),
            keywords: &["жаа менен жебе", "жаачы", "жебе", "зодиак", "курал"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Bou mat Feiler"),
            keywords: &[
                "Bou",
                "Bou mat Feiler",
                "Bouschéissen",
                "Bouschéisser",
                "Feil",
                "Schütze",
                "Stärzeechen",
                "Utensil",
                "Waff",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຄ\u{eb1}ນທະນ\u{eb9} ແລະ ລ\u{eb9}ກສອນ"),
            keywords: &[
                "ຄ\u{eb1}ນທະນ\u{eb9}",
                "ຄ\u{eb1}ນທະນ\u{eb9} ແລະ ລ\u{eb9}ກສອນ",
                "ລ\u{eb9}ກສອນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("lankas ir strėlė"),
            keywords: &[
                "ginklas",
                "lankas",
                "lankas ir strėlė",
                "strėlė",
                "zodiako",
                "įrankis",
                "šaulys",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("loks un bulta"),
            keywords: &["bulta", "ierocis", "loks", "loks un bulta", "strēlnieks"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kōpere me ngā pere"),
            keywords: &[
                "Sagittarius",
                "kaikōpere",
                "kōpere",
                "kōpere me ngā pere",
                "kōperetanga",
                "pere",
                "poutiriao",
                "rākau-riri",
                "utauta",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лак и стрела"),
            keywords: &["лак", "лак и стрела", "оружје", "стрела", "стрелец"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("അമ\u{d4d}പ\u{d41}ം വില\u{d4d}ല\u{d41}ം"),
            keywords: &[
                "അമ\u{d4d}പ\u{d41}ം വില\u{d4d}ല\u{d41}ം",
                "അമ\u{d4d}പ\u{d4d}",
                "ആയ\u{d41}ധം",
                "ഉപകരണം",
                "ധന\u{d41}ര\u{d3e}ശി",
                "ര\u{d3e}ശിചക\u{d4d}രം",
                "വില\u{d4d}ല\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нум сум"),
            keywords: &["нум", "нумын орд", "орд", "сум", "харваач"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("धन\u{941}ष\u{94d}यबाण"),
            keywords: &[
                "तीर\u{902}दाजी",
                "धन\u{941} राशी",
                "धन\u{941}र\u{94d}धर",
                "धन\u{941}ष\u{94d}य",
                "धन\u{941}ष\u{94d}यबाण",
                "बाण",
                "साधन",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("panah dan busur"),
            keywords: &[
                "alat",
                "busar",
                "panah",
                "panah dan busur",
                "pemanah",
                "sagittarius",
                "senjata",
                "zodiak",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("qaws u vleġġa"),
            keywords: &[
                "Sagittarius",
                "arma",
                "arċier",
                "għodda",
                "qaws",
                "qaws u vleġġa",
                "sparar bil-qaws",
                "vleġġa",
                "zodjaku",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လေးန\u{103e}င\u{1037}\u{103a} မြား"),
            keywords: &[
                "ဆယ\u{1037}\u{103a}န\u{103e}စ\u{103a}ရာသ\u{102e}ခ\u{103d}င\u{103a}",
                "ဓန\u{102f}ရာသ\u{102e}",
                "လေးန\u{103e}င\u{1037}\u{103a} မြား",
                "လေးသမား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("pil og bue"),
            keywords: &[
                "Skytten",
                "bue",
                "bueskytter",
                "pil",
                "pil og bue",
                "stjernebilde",
                "stjernetegn",
                "våpen",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("धन\u{941}ष बाण"),
            keywords: &["तीर", "धन\u{941}ष बाण", "धन\u{941}ष हान\u{94d}न\u{947}"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("pijl en boog"),
            keywords: &["boog", "boogschutter", "pijl", "pijl en boog", "wapen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("pil og boge"),
            keywords: &[
                "Skyttaren",
                "boge",
                "bogeskyttar",
                "pil",
                "pil og boge",
                "stjernebilete",
                "stjerneteikn",
                "våpen",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଧନ\u{b41} ଏବଂ ତୀର"),
            keywords: &[
                "ଏକ ନକ\u{b4d}ଷତ\u{b4d}ର ପ\u{b41}ଞ\u{b4d}ଜ",
                "ତୀର",
                "ଧନ\u{b41}",
                "ଧନ\u{b41} ଏବଂ ତୀର",
                "ଧନ\u{b41}ର\u{b4d}ଦ\u{b4d}ଧ\u{b3e}ରୀ",
                "ର\u{b3e}ଶ\u{b3f}ଚକ\u{b4d}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਤੀਰ-ਕਮਾਨ"),
            keywords: &[
                "ਔਜ\u{a3c}ਾਰ",
                "ਕਮਾਨ",
                "ਤੀਰ",
                "ਤੀਰ-ਕਮਾਨ",
                "ਤੀਰਅ\u{a70}ਦਾਜ\u{a3c}",
                "ਧਨ\u{a41} ਰਾਸ\u{a3c}ੀ",
                "ਰਾਸ\u{a3c}ੀ ਚ\u{a71}ਕਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("تیر اتے کمان"),
            keywords: &[
                "اوزار",
                "ب\u{64f}رج",
                "ب\u{64f}رج ق\u{64e}وس",
                "تیر",
                "تیر اتے کمان",
                "تیر انداز",
                "ج\u{64f}ھکنا",
                "فن\u{650} تیر اندازی",
                "ہتھیار",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bó An Áro"),
            keywords: &[
                "Bò",
                "Bó An Áro",
                "Pẹ\u{301}sin Wé De Shút Wit Bó An Áro",
                "Sajitériọs",
                "Zódiak",
                "Áro",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("łuk i strzała"),
            keywords: &[
                "broń",
                "narzędzie",
                "strzała",
                "strzelec",
                "zodiak",
                "łucznik",
                "łuk",
                "łuk i strzała",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("غشی او لينده"),
            keywords: &["غشی", "غشی او لينده", "غشی ويشتونکی", "لينده", "مرغومې"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("arco e flecha"),
            keywords: &[
                "arco",
                "arco e flecha",
                "arma",
                "flecha",
                "sagitário",
                "zodíaco",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "arco",
                "arco e flecha",
                "arma",
                "arqueiro",
                "sagitário",
                "seta",
                "zodíaco",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("arc și săgeată"),
            keywords: &[
                "Săgetător",
                "arc",
                "arc și săgeată",
                "arcaș",
                "armă",
                "săgeată",
                "zodiac",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-438"),
            keywords: &["E10-438"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("лук со стрелой"),
            keywords: &[
                "знак зодиака",
                "лук со стрелой",
                "оружие",
                "стрелец",
                "стрелы",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umuheto n’umwambi"),
            keywords: &[
                "igikoresho",
                "ikimenyetso cya zodiyake cy’umwambi",
                "intwaro",
                "kumasha",
                "umuheto n’umwambi",
                "umurashi",
                "umwambi",
                "zodiyake",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪمان ۽ تير"),
            keywords: &[
                "برج قوس",
                "تير",
                "تير انداز",
                "تير اندازي",
                "راس چڪر",
                "هٿيار",
                "ڪمان",
                "ڪمان ۽ تير",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ද\u{dd4}න\u{dca}න සහ ඊතලය"),
            keywords: &[
                "ආය\u{dd4}ධය",
                "ඊතලය",
                "ද\u{dd4}න\u{dca}න",
                "ද\u{dd4}න\u{dca}න සහ ඊතලය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("luk a šíp"),
            keywords: &[
                "luk",
                "luk a šíp",
                "lukostrelec",
                "strelec",
                "zbraň",
                "zverokruh",
                "šíp",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("lok in puščica"),
            keywords: &[
                "lok",
                "lok in puščica",
                "lokostrelec",
                "orodje",
                "orožje",
                "puščica",
                "strelec",
                "zodiak",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("leeb iyo qaanso"),
            keywords: &["leeb", "leeb iyo qaanso", "qaanso", "qaanso iyo leeble"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("hark dhe shigjetë"),
            keywords: &["armë", "hark dhe shigjetë", "harkëtar", "shigjetari zodiak"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лук и стрела"),
            keywords: &["зодијак", "лук", "лук и стрела", "стрела", "стрелац"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("лук и стријела"),
            keywords: &["лук и стријела"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("luk i strela"),
            keywords: &["luk", "luk i strela", "strela", "strelac", "zodijak"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("luk i strijela"),
            keywords: &["luk i strijela"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("pil och båge"),
            keywords: &["båge", "bågskytt", "pil och båge", "pilbåge", "vapen"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("upinde na mshale"),
            keywords: &[
                "mpiga mishale",
                "mshale",
                "silaha",
                "upinde",
                "upinde na mshale",
                "zana",
                "zodiaki",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வில\u{bcd}லும\u{bcd} அம\u{bcd}பும\u{bcd}"),
            keywords: &[
                "ஆயுதம\u{bcd}",
                "தனுசு",
                "தனுசு ர\u{bbe}சி",
                "யுத\u{bcd}தம\u{bcd}",
                "வில\u{bcd}லும\u{bcd} அம\u{bcd}பும\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వ\u{c3f}ల\u{c4d}లు మర\u{c3f}యు బ\u{c3e}ణం"),
            keywords: &[
                "ధనుస\u{c4d}సు",
                "బ\u{c3e}ణం",
                "వ\u{c3f}ల\u{c4d}లు",
                "వ\u{c3f}ల\u{c4d}లు మర\u{c3f}యు బ\u{c3e}ణం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("камон ва тир"),
            keywords: &[
                "асбоб",
                "бурҷи дувоздаҳгона",
                "камон",
                "камон ва тир",
                "камонвар",
                "камонварӣ",
                "силоҳ",
                "тир",
                "Қавс",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ธน\u{e39}และล\u{e39}กศร"),
            keywords: &[
                "ธน\u{e39}",
                "ธน\u{e39}และล\u{e39}กศร",
                "ราศ\u{e35}",
                "ล\u{e39}กศร",
                "อาว\u{e38}ธ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ok-ýaý"),
            keywords: &["Keman", "ok", "ok-ýaý", "okçy", "täleýnama", "ýaý"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kaufana moe ngahau"),
            keywords: &["kaufana moe ngahau"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ok ve yay"),
            keywords: &["araç", "burç", "ok", "ok ve yay", "okçu", "silah", "yay"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يا ۋە ئوق"),
            keywords: &[
                "ئوق",
                "ئوقياچى",
                "ئوقياچىلىق",
                "قورال",
                "مۆچەل",
                "يا",
                "يا ۋە ئوق",
                "ياراغ",
                "ياچاق",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("лук і стріла"),
            keywords: &[
                "Стрілець",
                "зброя",
                "знаряддя",
                "зодіак",
                "лук",
                "лук і стріла",
                "лучник",
                "стріла",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("تیر اور کمان"),
            keywords: &["تیر", "تیر اور کمان", "جنگ", "کمان", "ہتھیار"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kamon va o‘q"),
            keywords: &[
                "Oʻqotar",
                "burj",
                "kamon",
                "kamon va oʻq",
                "kamon va o‘q",
                "oʻq",
                "yoy",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cung tên"),
            keywords: &[
                "Nhân Mã",
                "cung",
                "cung hoàng đạo",
                "cung thủ",
                "cung tên",
                "mũi tên",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("ark bu ànd ak fett"),
            keywords: &[
                "Sagiteer",
                "ark",
                "ark bu ànd ak fett",
                "fett",
                "jumtukaay",
                "ngànnaay",
                "sojak",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isaphetha notolo"),
            keywords: &[
                "-Sagittarius",
                "i-zodiac",
                "isaphetha notolo",
                "isixhobo",
                "ubuchule bokutola",
                "umtoli",
                "utolo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ọkọ ati ọfa"),
            keywords: &[
                "Sagittarius",
                "irinṣé\u{329}",
                "irinṣẹ\u{301} ìjagun",
                "tafàtafà",
                "àmi oṣù ìbí",
                "ọfà",
                "ọfà títa",
                "ọkọ ati ọfa",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("弓箭"),
            keywords: &["射手座", "射箭", "弓箭", "星座", "箭頭"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("弓箭"),
            keywords: &[
                "射手",
                "射手座",
                "射箭",
                "工具",
                "弓",
                "弓箭",
                "星座",
                "武器",
                "箭头",
            ],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("弓和箭"),
            keywords: &["射手", "射箭", "弓", "弓和箭", "箭"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("弓箭"),
            keywords: &["射手", "弓箭"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["射箭｜射手", "弓", "弓箭", "箭"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umcibisholo nesihlangu"),
            keywords: &[
                "inkanyezi",
                "isikhali",
                "ithuluzi",
                "sagittarius",
                "umcibisholo",
                "umcibisholo nesihlangu",
            ],
        },
    ],
};
#[doc = "🛡\u{fe0f}"]
pub const SHIELD: crate::Emoji = crate::Emoji {
    glyph: "🛡\u{fe0f}",
    codepoint: "1F6E1 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "shield",
    group: "Objects",
    subgroup: "tool",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🛡",
        codepoint: "1F6E1",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "shield",
        group: "Objects",
        subgroup: "tool",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("skild"),
            keywords: &["beskerm", "skild", "wapen"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጋሻ"),
            keywords: &["ጋሻ", "ጦር መሣሪያ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("درع"),
            keywords: &["درع", "سلاح"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ঢ\u{9be}ল"),
            keywords: &["অস\u{9cd}ত\u{9cd}ৰ", "ঢ\u{9be}ল"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qalxan"),
            keywords: &["qalxan", "silah"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("шчыт"),
            keywords: &["абарона", "зброя", "рыштунак", "шчыт"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("щит"),
            keywords: &["оръжие", "щит"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ঢ\u{9be}ল"),
            keywords: &["অস\u{9cd}ত\u{9cd}র", "ঢ\u{9be}ল"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("skoed"),
            keywords: &["arm", "skoed"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("štit"),
            keywords: &["oružje", "štit"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("escut"),
            keywords: &["arma", "escut"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏚᏢᏙᏗ"),
            keywords: &["ᎠᎵᏍᏕᎸᏙᏗ", "ᎠᏚᏢᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("štít"),
            keywords: &["zbraň", "štít"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("tarian"),
            keywords: &["arf", "tarian"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("skjold"),
            keywords: &["skjold", "våben"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schutzschild"),
            keywords: &["Schild", "Schutzschild"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ασπίδα"),
            keywords: &["ασπίδα", "όπλο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("shield"),
            keywords: &["shield", "weapon"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("escudo"),
            keywords: &["defensa", "escudo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["escudo", "protección"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["escudo", "protección"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kilp"),
            keywords: &["kilp", "relv"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ezkutua"),
            keywords: &["arma", "ezkutua"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("سپر"),
            keywords: &["اسلحه", "سپر"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kilpi"),
            keywords: &["ase", "kilpi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kalasag"),
            keywords: &["kalasag", "panangga", "sandata"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("skjøldur"),
            keywords: &["skjøldur", "verja", "vernd", "vápn"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bouclier"),
            keywords: &["arme", "bouclier"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("sciath"),
            keywords: &["arm", "sciath"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sgiath"),
            keywords: &["arm", "armachd", "sgiath"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("escudo"),
            keywords: &["arma", "escudo", "protección"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઢાલ"),
            keywords: &["ઢાલ", "હથિયાર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("garkuwa"),
            keywords: &["garkuwa", "makami"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מגן"),
            keywords: &["כלי נשק", "מגן"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ढाल"),
            keywords: &["ढाल", "हथियार"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("štit"),
            keywords: &["oružje", "štit"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("pajzs"),
            keywords: &["fegyver", "pajzs"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("վահան"),
            keywords: &["զենք", "վահան"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("perisai"),
            keywords: &["perisai", "senjata"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("òzenmgbọ"),
            keywords: &["ngwa agha", "òzenmgbọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("skjöldur"),
            keywords: &["skjöldur", "vopn"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("scudo"),
            keywords: &["medioevo", "protezione", "scudo", "simbolo", "torneo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("盾"),
            keywords: &["シールド", "盾", "防具"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tameng"),
            keywords: &["gegaman", "tameng"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ფარი"),
            keywords: &["იარაღი", "ფარი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: None,
            keywords: &["abeckiḍ"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қалқан"),
            keywords: &["қалқан", "қару"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("skjold"),
            keywords: &["skjold", "våben"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ខែល"),
            keywords: &["ការពារ", "ខែល", "អាវ\u{17bb}ធ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಗುರಾಣ\u{cbf}"),
            keywords: &[
                "ಕತ\u{ccd}ತರ\u{cbf}",
                "ಕತ\u{ccd}ತ\u{cbf}ಗಳು",
                "ಗುರಾಣ\u{cbf}",
                "ಶಸ\u{ccd}ತ\u{ccd}ರಾಸ\u{ccd}ತ\u{ccd}ರ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("방패"),
            keywords: &["방패", "보호"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ढाल"),
            keywords: &["ढाल", "हत\u{94d}यार"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("калкан"),
            keywords: &["калкан", "курал"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Schëld"),
            keywords: &["Schëld", "Waff"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໂລ\u{ec8}ປ\u{ec9}ອງກ\u{eb1}ນ"),
            keywords: &["ອາວ\u{eb8}ດ", "ໂລ\u{ec8}ປ\u{ec9}ອງກ\u{eb1}ນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("skydas"),
            keywords: &["ginklas", "skydas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vairogs"),
            keywords: &["ierocis", "vairogs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pākai"),
            keywords: &["pākai", "rākau-riri"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("штит"),
            keywords: &["оружје", "штит"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഷീൽഡ\u{d4d}"),
            keywords: &["ആയ\u{d41}ധം", "ഷീൽഡ\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бамбай"),
            keywords: &["бамбай", "дуулга", "зэвсэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ढाल"),
            keywords: &["ढाल", "हत\u{94d}यार"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("perisai"),
            keywords: &["perisai", "senjata"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("tarka"),
            keywords: &["arma", "tarka"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဒ\u{102d}\u{102f}င\u{103a}း"),
            keywords: &["ဒ\u{102d}\u{102f}င\u{103a}း", "လက\u{103a}နက\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("skjold"),
            keywords: &["skjold", "våpen"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ढाल"),
            keywords: &["ढाल", "हतियार"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("schild"),
            keywords: &["schild", "wapen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("skjold"),
            keywords: &["skjold", "våpen"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଢ\u{b3e}ଲ"),
            keywords: &["ଅସ\u{b4d}ତ\u{b4d}ରଶସ\u{b4d}ତ\u{b4d}ର", "ଢ\u{b3e}ଲ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਢਾਲ"),
            keywords: &["ਢਾਲ", "ਹਥਿਆਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ڈھال"),
            keywords: &["ڈھال", "ہتھیار"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Shild"),
            keywords: &["Shild", "Wẹ\u{301}pọn"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("tarcza"),
            keywords: &["ochrona", "osłona", "tarcza"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ډال"),
            keywords: &["وسله", "ډال"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("escudo"),
            keywords: &["arma", "escudo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("scut"),
            keywords: &["armă", "scut"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-995"),
            keywords: &["E10-995"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("щит"),
            keywords: &["безопасность", "защита", "снаряжение", "щит"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ingabo"),
            keywords: &["ingabo", "intwaro"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڍال"),
            keywords: &["هٿيار", "ڍال"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පල\u{dd2}හ"),
            keywords: &["ආය\u{dd4}ධය", "පල\u{dd2}හ"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("štít"),
            keywords: &["zbraň", "štít"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ščit"),
            keywords: &["orožje", "ščit"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gaashaan"),
            keywords: &["gaashaan", "hub"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("mburojë"),
            keywords: &["armë", "mburojë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("штит"),
            keywords: &["oружje", "штит"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("štit"),
            keywords: &["oružje", "štit"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("sköld"),
            keywords: &["sköld", "vapen"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ngao"),
            keywords: &["ngao", "silaha"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கேடயம\u{bcd}"),
            keywords: &[
                "கேடயம\u{bcd}",
                "ப\u{bbe}துக\u{bbe}ப\u{bcd}பு ஆயுதம\u{bcd}",
                "யுத\u{bcd}தம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కవచం"),
            keywords: &["ఆయుధం", "కవచం", "రక\u{c4d}షణ"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("сипар"),
            keywords: &["силоҳ", "сипар"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("โล\u{e48}"),
            keywords: &["ป\u{e49}องก\u{e31}น", "อาว\u{e38}ธ", "โล\u{e48}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("galkan"),
            keywords: &["galkan", "ýarag"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pā"),
            keywords: &["pā"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kalkan"),
            keywords: &["kalkan", "silah"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قالقان"),
            keywords: &["قالقان", "قورال"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("щит"),
            keywords: &["зброя", "щит"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("شیلڈ"),
            keywords: &["حفاظت", "شیلڈ", "ہتھیار"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qalqon"),
            keywords: &["qalqon", "qurol"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cái khiên"),
            keywords: &["cái khiên", "vũ khí"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kiiraay"),
            keywords: &["kiiraay", "ngànnaay"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ikhaka"),
            keywords: &["ikhaka", "isixhobo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ohun èlò àbò"),
            keywords: &["irinṣẹ\u{301} ìjagun", "ohun èlò àbò"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("盾"),
            keywords: &["武器", "盾"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("盾"),
            keywords: &["武器", "盾"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("盾牌"),
            keywords: &["武器", "盾", "盾牌", "防御"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("盾牌"),
            keywords: &["盾牌"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["盾牌", "盾牌｜武器"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ihawu"),
            keywords: &["ihawu", "isikhali"],
        },
    ],
};
#[doc = "🪚"]
pub const CARPENTRY_SAW: crate::Emoji = crate::Emoji {
    glyph: "🪚",
    codepoint: "1FA9A",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "carpentry saw",
    group: "Objects",
    subgroup: "tool",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("houtsaag"),
            keywords: &[
                "gereedskap",
                "hout",
                "houtsaag",
                "houtwerk",
                "saag",
                "skrynwerker",
                "timmerhout",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የአናጢ መጋዝ"),
            keywords: &["የአናጢ መጋዝ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("منشار يدوي"),
            keywords: &["أداة", "خشب", "منشار", "منشار يدوي", "نجار"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কৰত"),
            keywords: &[
                "ক\u{9be}ঠ",
                "ক\u{9be}ঠ মিস\u{9cd}ক\u{9cd}ৰী",
                "কৰত",
                "স\u{981}জ\u{9c1}লি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("əl mişarı"),
            keywords: &["alət", "bıçqı", "dülgər", "taxta-şalban", "əl mişarı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("піла"),
            keywords: &["драўніна", "нажоўка", "піла", "цясляр", "інструмент"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("трион"),
            keywords: &["дървар", "дървосекач", "инструмент", "трион"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ছ\u{9c1}ত\u{9be}রের ক\u{9be}জের কর\u{9be}ত"),
            keywords: &[
                "কর\u{9be}ত",
                "কর\u{9be}তি",
                "ছ\u{9c1}ত\u{9be}রের ক\u{9be}জের কর\u{9be}ত",
                "ছ\u{9c1}তোর",
                "যন\u{9cd}ত\u{9cd}রপ\u{9be}তি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("heskenn"),
            keywords: &["benveg", "heskenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("stolaraska pila"),
            keywords: &["alat", "drvena građa", "pila", "stolar", "stolaraska pila"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("xerrac"),
            keywords: &["eina", "fuster", "llenyataire", "serra", "xerrac"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᏁᏍᎨᏍᎩ ᎦᎾᏙᎩ"),
            keywords: &["ᎦᎾᏙᎩ", "ᎬᏔᏂᏓᏍᏗ", "ᏗᏁᏍᎨᏍᎩ", "ᏧᏯᏖᎾ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("ruční pila"),
            keywords: &[
                "dřevo",
                "nástroj",
                "ocaska",
                "pila",
                "pilka",
                "ruční pila",
                "truhlář",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("llif gwaith coed"),
            keywords: &["coed cadw", "llif", "llif gwaith coed", "offeryn", "saer"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sav"),
            keywords: &["sav", "save", "snedker", "tømmer", "tømrer", "værktøj"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Handsäge"),
            keywords: &["Handsäge", "Holz", "Säge", "Tischler", "Werkzeug"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πριόνι ξυλουργού"),
            keywords: &[
                "εργαλείο",
                "ξυλεία",
                "ξυλουργός",
                "πριόνι",
                "πριόνι ξυλουργού",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("carpentry saw"),
            keywords: &["carpenter", "carpentry saw", "lumber", "saw", "tool"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["carpenter", "lumber", "saw", "timber", "tool"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("sierra de carpintería"),
            keywords: &[
                "carpintero",
                "carpintería",
                "herramienta",
                "sierra",
                "sierra de carpintería",
                "talar",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("käsisaag"),
            keywords: &["käsisaag", "puit", "puusepp", "saag", "tööriist"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("zerra"),
            keywords: &["arotza", "egurra", "tresna", "zerra"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("اره نجاری"),
            keywords: &["ابزار", "اره", "اره نجاری", "نجار", "چوب\u{200c}ب\u{64f}ر"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("käsisaha"),
            keywords: &["käsisaha", "puuseppä", "saha", "sahatavara", "työkalu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lagari"),
            keywords: &["gamit", "kahoy", "karpintero", "lagari"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sag"),
            keywords: &["amboð", "hondsag", "sag"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("scie"),
            keywords: &["bois", "outil", "scie", "scie égoïne"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("scie à bois"),
            keywords: &["bois", "outil", "scie", "scie à bois", "scie égoïne"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("sábh cearpantóireachta"),
            keywords: &[
                "adhmad",
                "siúnéir",
                "sábh",
                "sábh cearpantóireachta",
                "uirlis",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sàbh saorsainneachd"),
            keywords: &[
                "acainn",
                "fiodh",
                "inneal",
                "saoirsinneachd",
                "saor",
                "saorsainneachd",
                "sàbh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("serra"),
            keywords: &["bricolaxe", "carpintería", "ferramenta", "serra"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{ac1}થારી કામની કરવત"),
            keywords: &[
                "કરવત",
                "લમ\u{acd}બર",
                "સાધન",
                "સ\u{ac1}થાર",
                "સ\u{ac1}થારી કામની કરવત",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מסור"),
            keywords: &["כלי עבודה", "מסור", "מסור ידני", "נגר", "נגרייה", "ניסור"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बढ\u{93c}ई की आरी"),
            keywords: &[
                "आरी",
                "औजार",
                "काठ की लकड\u{93c}ी",
                "बढ\u{93c}ई",
                "बढ\u{93c}ई की आरी",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("ručna pila"),
            keywords: &["alat", "drvo", "pila", "ručna pila", "stolar"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("rókafarkú fűrész"),
            keywords: &["asztalos", "fa", "fűrész", "rókafarkú", "szerszám", "ács"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սղոց"),
            keywords: &["ատաղձագործ", "գործիք", "սղոց", "փայտ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("gergaji kayu"),
            keywords: &["gergaji", "kayu", "perkakas", "tukang kayu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sög"),
            keywords: &["smiður", "sög", "timbur", "verkfæri", "viður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("sega da falegname"),
            keywords: &[
                "falegname",
                "legname",
                "sega",
                "sega da falegname",
                "utensile",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("のこぎり"),
            keywords: &["のこぎり", "ノコ", "刃", "大工", "工具", "木工"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("graji kayu"),
            keywords: &["bekakas", "graji", "kayu", "tukang kayu"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ხერხი"),
            keywords: &["დურგალი", "ტყისმჭრელი", "ხელსაწყო", "ხერხი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ара"),
            keywords: &["ара", "араланған материал", "ағаш ұстасы", "құрал"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រណារអារឈើ"),
            keywords: &["ជាងឈើ", "ឈើ", "រណារ", "រណារអារឈើ", "ឧបករណ\u{17cd}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮರಗ\u{cc6}ಲಸದ ಗರಗಸ"),
            keywords: &[
                "ಗರಗಸ",
                "ಬಡಗ\u{cbf}",
                "ಮರಗ\u{cc6}ಲಸ",
                "ಮರಗ\u{cc6}ಲಸದ ಗರಗಸ",
                "ಸಾಧನ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("목공 톱"),
            keywords: &["도구", "목공 톱", "목수", "목재", "톱"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("खरवत"),
            keywords: &["खरवत", "थवय", "म\u{947}स\u{94d}त", "साधन"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жыгач уста араасы"),
            keywords: &["жыгач уста араасы"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຊ\u{ec8}າງໄມ\u{ec9}"),
            keywords: &[
                "ຊ\u{ec8}າງໄມ\u{ec9}",
                "ເຄ\u{eb7}\u{ec8}ອງມ\u{eb7}",
                "ເລ\u{eb7}\u{ec8}ອຍ",
                "ເລ\u{eb7}\u{ec8}ອຍຊ\u{ec8}າງໄມ\u{ec9}",
                "ໄມ\u{ec9}ທ\u{ec8}ອນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("pjūklas"),
            keywords: &["dailidė", "mediena", "pjūklas", "įrankis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vienrokas zāģis"),
            keywords: &[
                "darbarīks",
                "galdnieks",
                "kokmateriāli",
                "vienrokas zāģis",
                "zāģis",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("столарска пила"),
            keywords: &["алат", "дрво", "пила", "столар", "столарска пила"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മരപ\u{d4d}പണി വ\u{d3e}ൾ"),
            keywords: &[
                "അറക\u{d4d}കവ\u{d3e}ൾ",
                "പണിയ\u{d3e}യ\u{d41}ധം",
                "മര ഉര\u{d41}പ\u{d4d}പടി",
                "മരപ\u{d4d}പണി വ\u{d3e}ൾ",
                "മര\u{d3e}ശ\u{d3e}രി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("мужааны хөрөө"),
            keywords: &["багаж", "гуалин", "мужаан", "мужааны хөрөө", "хөрөө"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{941}तारकामासाठी असल\u{947}ली करवत"),
            keywords: &[
                "करवत",
                "लाक\u{942}डतोड करण\u{947}",
                "साधन",
                "स\u{941}तार",
                "स\u{941}तारकामासाठी असल\u{947}ली करवत",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("gergaji kayu"),
            keywords: &[
                "alat",
                "gergaji",
                "gergaji kayu",
                "kayu gergaji",
                "tukang kayu",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လက\u{103a}သမား လ\u{103d}\u{103e}"),
            keywords: &[
                "တ\u{1030}းလ\u{103a}",
                "ပရ\u{102d}ဘောဂ",
                "လက\u{103a}သမား",
                "လ\u{103d}\u{103e}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("håndsag"),
            keywords: &["håndsag", "sag", "snekker", "tre", "tømrer", "verktøy"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कार\u{94d}प\u{947}न\u{94d}टर स"),
            keywords: &["उपकरण", "कार\u{94d}प\u{947}न\u{94d}टर", "लम\u{94d}बर", "स"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("houtzaag"),
            keywords: &["gereedschap", "hout", "houtzaag", "timmerman", "zaag"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("handsag"),
            keywords: &["handsag", "sag", "snikkar", "tre", "tømrar", "verktøy"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବଢେଇ କ\u{b3e}ମରେ ବ\u{b4d}ୟବହ\u{b43}ତ କରତ"),
            keywords: &[
                "କରତ",
                "ପଟ\u{b3e}",
                "ବଢେଇ",
                "ବଢେଇ କ\u{b3e}ମରେ ବ\u{b4d}ୟବହ\u{b43}ତ କରତ",
                "ଯନ\u{b4d}ତ\u{b4d}ରପ\u{b3e}ତ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਆਰੀ"),
            keywords: &["ਆਰੀ", "ਔਜ\u{a3c}ਾਰ", "ਗ\u{a47}ਲੀ", "ਤਰਖਾਣ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kápínta Sọ"),
            keywords: &["Kápínta", "Kápínta Im Sọ", "Sọ", "Tul", "Tímba"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("piła do drewna"),
            keywords: &["narzędzie", "piła", "piła do drewna", "stolarz", "tarcica"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د نجارۍ اره"),
            keywords: &["اره", "اله", "د نجارۍ اره", "لرګی", "نجار"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("serrote"),
            keywords: &["carpinteiro", "madeira", "serra", "serrote"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("fierăstrău pentru tămplărie"),
            keywords: &[
                "cherestea",
                "fierăstrău",
                "fierăstrău pentru tămplărie",
                "instrument",
                "sculă",
                "tâmplar",
                "unealtă",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-061"),
            keywords: &["E13-061"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("пила по дереву"),
            keywords: &[
                "древесина",
                "инструмент",
                "пила по дереву",
                "плотник",
                "столяр",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("واڍي جي ڪارائي"),
            keywords: &["اوزار", "لمبر", "واڍو", "واڍي جي ڪارائي", "ڪارائي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වඩ\u{dd4} වැඩ ක\u{dd2}යත"),
            keywords: &[
                "ක\u{dd2}යත",
                "මෙවලම",
                "ල\u{dd3}",
                "වඩ\u{dd4} ක\u{dcf}ර\u{dca}ම\u{dd2}කය\u{dcf}",
                "වඩ\u{dd4} වැඩ ක\u{dd2}යත",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("tesárska píla"),
            keywords: &["drevo", "píla", "tesár", "tesárska píla"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("lisičja žaga"),
            keywords: &["lisičja žaga", "mizar", "orodje", "žaga", "žagati"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("miinshaar"),
            keywords: &[
                "alwaax jarid",
                "fuundi",
                "miinshaar",
                "miinshaar ku jarid",
                "miinshaarta fuundiga",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("sharrë marangozi"),
            keywords: &["dru", "marangoz", "sharrë", "sharrë marangozi", "vegël"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("тестера"),
            keywords: &["алат", "дрво", "столар", "тестера"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["тестера"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("testera"),
            keywords: &["alat", "drvo", "stolar", "testera"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["testera"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("fogsvans"),
            keywords: &["fogsvans", "snickare", "såg", "trä", "verktyg"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("msumeno"),
            keywords: &["mbao", "msumeno", "seremala", "zana"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ரம\u{bcd}பம\u{bcd}"),
            keywords: &[
                "கருவி",
                "தச\u{bcd}சர\u{bcd}",
                "ரம\u{bcd}பம\u{bcd}",
                "லம\u{bcd}பர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వడ\u{c4d}రంగ\u{c3f} పన\u{c3f} రంపం"),
            keywords: &[
                "రంపం",
                "వడ\u{c4d}రంగ\u{c3f}",
                "వడ\u{c4d}రంగ\u{c3f} పన\u{c3f} రంపం",
                "స\u{c3e}ధనం",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เล\u{e37}\u{e48}อย"),
            keywords: &[
                "ช\u{e48}างไม\u{e49}",
                "เคร\u{e37}\u{e48}องม\u{e37}อ",
                "เล\u{e37}\u{e48}อย",
                "เล\u{e37}\u{e48}อยไม\u{e49}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("agaç byçgysy"),
            keywords: &["abzal", "agaç byçgysy", "agaç ussasy", "byçgy", "tagta"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kili"),
            keywords: &["kili", "tufunga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("testere"),
            keywords: &["alet", "kereste", "marangoz", "testere"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("теслярська пила"),
            keywords: &["деревина", "пила", "тесля", "теслярська пила", "інструмент"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بڑھئی کا آرا"),
            keywords: &["آرا", "آلہ", "بڑھئی", "بڑھئی کا آرا", "لکڑی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("duradgorlik arrasi"),
            keywords: &[
                "arralash",
                "asbob",
                "duradgor",
                "duradgorlik arrasi",
                "taxta",
                "yogʻoch",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cưa mộc"),
            keywords: &["cưa", "cưa mộc", "dụng cụ", "gỗ xẻ", "thợ mộc"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("木鋸"),
            keywords: &["工具", "木工", "木材", "木鋸", "鋸"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("木锯"),
            keywords: &["工具", "木工", "木材", "木锯", "锯"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("木工锯"),
            keywords: &["工具", "木匠", "木工锯", "木材", "锯"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("木工鉅"),
            keywords: &["工具", "木工", "木工鉅", "木材", "鉅子"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isaha lombazi"),
            keywords: &["i-lumber", "isaha", "isaha lombazi", "ithuluzi", "umbazi"],
        },
    ],
};
#[doc = "🔧"]
pub const WRENCH: crate::Emoji = crate::Emoji {
    glyph: "🔧",
    codepoint: "1F527",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "wrench",
    group: "Objects",
    subgroup: "tool",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("moersleutel"),
            keywords: &["gereedskap", "moersleutel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መፍቻ"),
            keywords: &["መሣሪያ", "መፍቻ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مفتاح ربط"),
            keywords: &["عدة", "مفتاح ربط"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ৰেঞ\u{9cd}চ"),
            keywords: &["স\u{981}জ\u{9c1}লি", "স\u{9cd}পেন\u{9be}ৰ", "ৰেঞ\u{9cd}চ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("təmir açarı"),
            keywords: &["alət", "təmir açarı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("гаечны ключ"),
            keywords: &["гаечны ключ", "інструмент"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Гаечен ключ"),
            keywords: &["Гаечен ключ", "инструмент"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("রেঞ\u{9cd}চ"),
            keywords: &["রেঞ\u{9cd}চ", "সরঞ\u{9cd}জ\u{9be}ম"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("alcʼhwez plat"),
            keywords: &["alcʼhwez plat", "benveg"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ključ viljuškasti"),
            keywords: &["alat", "ključ viljuškasti"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("clau anglesa"),
            keywords: &["anglesa", "clau", "eina"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎦᏚᏩᎸᏕᏍᏙᏗ"),
            keywords: &["ᎬᏔᏂᏓᏍᏗ", "ᏗᎦᏚᏩᎸᏕᏍᏙᏗ", "ᏗᎦᏚᏩᎸᏕᏍᏙᏗ ᎢᏳᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("maticový klíč"),
            keywords: &["klíč", "maticový klíč", "montážní", "nástroj", "nářadí"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sbaner"),
            keywords: &["offeryn", "sbaner"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("skruenøgle"),
            keywords: &["skruenøgle", "svensknøgle", "værktøj"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schraubenschlüssel"),
            keywords: &["Schraubenschlüssel", "Werkzeug"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γαλλικό κλειδί"),
            keywords: &["γαλλικό κλειδί", "εργαλείο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("wrench"),
            keywords: &["spanner", "tool", "wrench"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("spanner"),
            keywords: &["spanner"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("wrench"),
            keywords: &["spanner", "tool", "wrench"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["spanner", "tool", "wrench"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("llave inglesa"),
            keywords: &["herramienta", "llave inglesa"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("mutrivõti"),
            keywords: &["mutrivõti", "tööriist"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("giltza ingelesa"),
            keywords: &["giltza ingelesa", "tresna"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("آچار"),
            keywords: &["آچار", "ابزار"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("jakoavain"),
            keywords: &["jakoavain", "työkalu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("liyabe"),
            keywords: &["kagamitan", "liyabe", "lyabe"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("skrúvulykil"),
            keywords: &["amboð", "skiftilykil", "skrúvulykil"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("clé à molette"),
            keywords: &["clé", "clé à molette", "outil"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["clé", "clé à molette", "outil"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("rinse"),
            keywords: &["castaire", "rinse", "uirlis"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("toinnear"),
            keywords: &["inneal", "nupair", "spanair", "toinnear"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("chave inglesa"),
            keywords: &["chave inglesa", "ferramenta"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પાન\u{ac1}\u{a82}"),
            keywords: &["પાન\u{ac1}\u{a82}", "ર\u{ac7}\u{a82}ચ", "સાધન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("sufana"),
            keywords: &["kayan aiki", "sufana"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מפתח ברגים"),
            keywords: &["כלי עבודה", "מפתח ברגים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पाना"),
            keywords: &[
                "औज\u{93c}ार",
                "पाना",
                "र\u{947}\u{902}च",
                "र\u{948}\u{902}च",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("francuski ključ"),
            keywords: &["alat", "francuski ključ"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("csavarkulcs"),
            keywords: &["csavarkulcs", "szerszám", "villáskulcs"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("պտուտակաբանալի"),
            keywords: &["գործիք", "պտուտակաբանալի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kunci inggris"),
            keywords: &["alat", "kunci inggris"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("igwe ndọpụta"),
            keywords: &["igwe ndọpụta", "ngwankwụpụta", "ngwaọrụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("skiptilykill"),
            keywords: &["skiptilykill", "verkfæri"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("chiave inglese"),
            keywords: &["attrezzo", "chiave", "inglese", "utensile"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("レンチ"),
            keywords: &["スパナ", "レンチ", "工具"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kunci pas"),
            keywords: &["bekakas", "kunci inggris", "kunci pas"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქანჩის გასაღები"),
            keywords: &["ინსტრუმენტი", "ქანჩის გასაღები", "ხელსაწყო"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сомын кілт"),
            keywords: &["сомын кілт", "құрал"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("skruenøgle"),
            keywords: &["skruenøgle", "værktøj"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សោសម\u{17d2}រាប\u{17cb}ម\u{17bd}លខ\u{17d2}ចៅ"),
            keywords: &[
                "សោម\u{17bc}ល",
                "សោសម\u{17d2}រាប\u{17cb}ម\u{17bd}លខ\u{17d2}ចៅ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ವ\u{ccd}ರ\u{cc6}ಂಚ\u{ccd}"),
            keywords: &["ಉಪಕರಣ", "ವ\u{ccd}ರ\u{cc6}ಂಚ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("렌치"),
            keywords: &["도구", "렌치"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("तिरपणी"),
            keywords: &["तिरपणी", "पानो", "साधन"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("гайка ачкычы"),
            keywords: &["гайка ачкычы", "курал"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Schrauweschlëssel"),
            keywords: &["Handwierksgeschir", "Schrauwenzéier", "Schrauweschlëssel"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປະແຈ"),
            keywords: &["ປະແຈ", "ເຄ\u{eb7}\u{ec8}ອງມ\u{eb7}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("veržliaraktis"),
            keywords: &["veržliaraktis", "įrankis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("uzgriežņu atslēga"),
            keywords: &["darbarīks", "uzgriežņu atslēga"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("wāwāhi"),
            keywords: &["mauhiri", "utauta", "wāwāhi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("француски клуч"),
            keywords: &["алатка", "француски клуч"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("റെഞ\u{d4d}ച\u{d4d}"),
            keywords: &["ഉപകരണം", "റെഞ\u{d4d}ച\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эрэг чангалах түлхүүр"),
            keywords: &["түлхүүр", "чангалах", "эрэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पाना"),
            keywords: &["पाना", "साधन"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("perengkuh"),
            keywords: &["alat", "perengkuh"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("spanner"),
            keywords: &["martell", "spaner", "spanner"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ခ\u{103d}"),
            keywords: &[
                "ခ\u{103d}",
                "ခ\u{103d}ရ\u{103e}င\u{103a}",
                "စပန\u{103a}နာ",
                "တ\u{1030}းလ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("fastnøkkel"),
            keywords: &["fastnøkkel", "skrunøkkel", "verktøy"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("रिन\u{94d}च"),
            keywords: &["उपकरण", "रिन\u{94d}च"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("moersleutel"),
            keywords: &["gereedschap", "moersleutel", "schroefsleutel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("fastnøkkel"),
            keywords: &["fastnøkkel", "skrunøkkel", "verktøy"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ରେଞ\u{b4d}ଚ\u{b3f}"),
            keywords: &["ଉପକରଣ", "ରେଞ\u{b4d}ଚ\u{b3f}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਰ\u{a48}\u{a02}ਚ"),
            keywords: &["ਔਜ\u{a3c}ਾਰ", "ਚਾਬੀ", "ਰ\u{a48}\u{a02}ਚ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مروڑنا"),
            keywords: &["اوزار", "مروڑنا", "ناپن آلا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Spána"),
            keywords: &["Rẹnch", "Spána", "Tul"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("klucz warsztatowy"),
            keywords: &["klucz warsztatowy", "mechanik", "narzędzie", "warsztat"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("رنچ"),
            keywords: &["اله", "تاوهونکی", "رنچ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("chave inglesa"),
            keywords: &["chave inglesa", "ferramenta"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cheie fixă"),
            keywords: &["cheie de piulițe", "cheie fixă", "instrument"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-739"),
            keywords: &["E10-739"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("гаечный ключ"),
            keywords: &["гаечный", "инструмент", "ключ"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("gushikuza"),
            keywords: &["gushikuza", "igikoresho", "isupane", "kasuku"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پانو"),
            keywords: &["اوزار", "رينچ", "پانو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("රෙංච\u{dd2}ය"),
            keywords: &["මෙවලම", "රෙංච\u{dd2}ය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("francúzsky kľúč"),
            keywords: &["francúzsky kľúč", "nástroj"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ključ za matice"),
            keywords: &["ključ za matice", "orodje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("baanad"),
            keywords: &["baanad", "qalab", "wareejiso"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("çelës anglez"),
            keywords: &["vegël", "çelës anglez"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("француски кључ"),
            keywords: &["aлaт", "француски кључ"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("francuski ključ"),
            keywords: &["alat", "francuski ključ"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("skiftnyckel"),
            keywords: &["skiftnyckel", "verktyg"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("spana malaya"),
            keywords: &["spana malaya", "zana"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("இடுக\u{bcd}கி"),
            keywords: &["இடுக\u{bcd}கி", "கருவி", "டூல\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ర\u{c46}ంచ\u{c3f}"),
            keywords: &[
                "ర\u{c46}ంచ\u{c3f}",
                "ర\u{c46}ంచ\u{c4d}",
                "స\u{c4d}ప\u{c3e}నర\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("калиди гайкатобӣ"),
            keywords: &["асбоб", "калид", "калиди гайкатобӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ประแจ"),
            keywords: &["ประแจ", "เคร\u{e37}\u{e48}องม\u{e37}อ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gaýka açary"),
            keywords: &["gaýka açary", "gural", "nurbat açar"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sipana"),
            keywords: &["sipana"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("somun anahtarı"),
            keywords: &["araç", "ingiliz anahtarı", "somun anahtarı"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كۇلۇچ"),
            keywords: &["جابدۇق", "قورال", "كۇلۇچ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("гайковий ключ"),
            keywords: &["гайковий ключ", "інструмент"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("رینچ"),
            keywords: &["آلہ", "رینچ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("gayka kaliti"),
            keywords: &["asbob", "gayka kaliti"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cờ lê"),
            keywords: &["chìa vặn", "cờ lê", "dụng cụ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kle"),
            keywords: &["jumtukaay", "kle"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhobhotyane"),
            keywords: &["ibhobhotyana", "ibhobhotyane", "isixhobo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("oolu"),
            keywords: &[
                "irinṣẹ\u{301}",
                "irinṣẹ\u{301} afagbára dè",
                "oolu",
                "sípánà",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("士巴拿"),
            keywords: &["士巴拿", "工具", "板手"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("士巴拿"),
            keywords: &["士巴拿", "工具", "板手"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("扳手"),
            keywords: &["工具", "扳手", "螺丝扳手"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("扳手"),
            keywords: &["扳手"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("士巴拿"),
            keywords: &["士巴拿", "士巴拿｜工具"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isipanelo"),
            keywords: &["isipanelo", "ithuluzi"],
        },
    ],
};
#[doc = "🪛"]
pub const SCREWDRIVER: crate::Emoji = crate::Emoji {
    glyph: "🪛",
    codepoint: "1FA9B",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "screwdriver",
    group: "Objects",
    subgroup: "tool",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("skroewedraaier"),
            keywords: &["gereedskap", "skroef", "skroewedraaier"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መፍቻ መሳሪያ"),
            keywords: &["መፍቻ መሳሪያ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مفك براغي"),
            keywords: &["أداة", "مفك", "مفك براغي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("স\u{9cd}ক\u{9cd}ৰ\u{9c1}ড\u{9cd}ৰ\u{9be}ইভ\u{9be}ৰ"),
            keywords: &[
                "স\u{981}জ\u{9c1}লি",
                "স\u{9cd}ক\u{9cd}ৰ\u{9c1}",
                "স\u{9cd}ক\u{9cd}ৰ\u{9c1}ড\u{9cd}ৰ\u{9be}ইভ\u{9be}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("vintaçan"),
            keywords: &["alət", "vint", "vintaçan"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("адвёртка"),
            keywords: &["адвёртка", "інструмент"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("отвертка"),
            keywords: &["инструмент", "отвертка", "развивам"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9cd}ক\u{9cd}র\u{9c1}ড\u{9cd}র\u{9be}ইভ\u{9be}র"),
            keywords: &[
                "যন\u{9cd}ত\u{9cd}রপ\u{9be}তি",
                "স\u{9cd}ক\u{9cd}র\u{9c1}",
                "স\u{9cd}ক\u{9cd}র\u{9c1}ড\u{9cd}র\u{9be}ইভ\u{9be}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("troer-biñsoù"),
            keywords: &["benveg", "biñs", "troer-biñsoù"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("šrafciger"),
            keywords: &["alat", "šrafciger"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("tornavís"),
            keywords: &["eina", "tornavís", "vis"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏗᏆᎸᏕᏱᏓ ᎬᏔᏂᏓᏍᏗ"),
            keywords: &["ᎤᏗᏆᎸᏕᏱᏓ", "ᎬᏔᏂᏓᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("šroubovák"),
            keywords: &["nástroj", "šroub", "šroubovat", "šroubovák"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sgriwdreifar"),
            keywords: &["offeryn", "sgriw", "sgriwdreifar"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("skruetrækker"),
            keywords: &["skrue", "skruetrækker", "værktøj"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schraubenzieher"),
            keywords: &["Schraube", "Schraubenzieher", "Werkzeug"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κατσαβίδι"),
            keywords: &["βίδωμα", "εργαλείο", "κατσαβίδι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("screwdriver"),
            keywords: &["screw", "screwdriver", "tool"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("destornillador"),
            keywords: &["atornillador", "destornillador", "herramienta", "tornillo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("destornillador"),
            keywords: &["destornillador"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kruvikeeraja"),
            keywords: &["kruvi", "kruvikeeraja", "tööriist"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bihurkin"),
            keywords: &["bihurkin", "torlojua", "tresna"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پیچ\u{200c}گوشتی"),
            keywords: &["ابزار", "پیچ", "پیچ\u{200c}گوشتی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ruuvimeisseli"),
            keywords: &["meisseli", "ruuvi", "ruuvimeisseli", "työkalu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("screwdriver"),
            keywords: &["gamit", "screwdriver", "tornilyo"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("skrúvublað"),
            keywords: &["amboð", "skrúva", "skrúvublað"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("tournevis"),
            keywords: &["outil", "tournevis", "vis"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("tournevis"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("scriúire"),
            keywords: &["scriú", "scriúire", "uirlis"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sgriubhaire"),
            keywords: &["acainn", "inneal", "sgriubha", "sgriubhaire"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("desaparafusador"),
            keywords: &[
                "bricolaxe",
                "desaparafusador",
                "destornillador",
                "ferramenta",
                "parafuso",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}ક\u{acd}ર\u{ac1}ડ\u{acd}રાઇવર"),
            keywords: &[
                "સાધન",
                "સ\u{acd}ક\u{acd}ર\u{ac1}",
                "સ\u{acd}ક\u{acd}ર\u{ac1}ડ\u{acd}રાઇવર",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מברג"),
            keywords: &["הברגה", "כלי עבודה", "מברג"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{94d}क\u{94d}र\u{942}ड\u{94d}राइवर"),
            keywords: &[
                "औजार",
                "स\u{94d}क\u{94d}र\u{942}",
                "स\u{94d}क\u{94d}र\u{942}ड\u{94d}राइवर",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("odvijač"),
            keywords: &["alat", "odvijač", "vijak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("csavarhúzó"),
            keywords: &["csavarhúzó", "szerszám"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("պտուտակիչ"),
            keywords: &["գործիք", "պտուտակ", "պտուտակիչ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("obeng"),
            keywords: &["alat", "obeng"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("skrúfjárn"),
            keywords: &["skrúfa", "skrúfjárn", "verkfæri"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cacciavite"),
            keywords: &["avvitare", "cacciavite", "utensile", "vite"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ねじ回し"),
            keywords: &["ねじ回し", "スクリュードライバー", "ドライバー", "工具"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("obeng"),
            keywords: &["bekakas", "obeng"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სახრახნისი"),
            keywords: &["სახრახნისი", "ხელსაწყო", "ხრახნი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бұрағыш"),
            keywords: &["бұрау", "бұрағыш", "құрал"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ទ\u{17bd}រណ\u{17ba}វ\u{17b7}ស"),
            keywords: &[
                "ទ\u{17bd}រណ\u{17ba}វ\u{17b7}ស",
                "វ\u{17b8}ស",
                "ឧបករណ\u{17cd}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{ccd}ಕ\u{ccd}ರ\u{cc2}ಡ\u{ccd}ರೈವರ\u{ccd}"),
            keywords: &[
                "ಸಾಧನ",
                "ಸ\u{ccd}ಕ\u{ccd}ರ\u{cc2}",
                "ಸ\u{ccd}ಕ\u{ccd}ರ\u{cc2}ಡ\u{ccd}ರೈವರ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("드라이버"),
            keywords: &["나사", "도구", "드라이버"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("स\u{94d}क\u{94d}र\u{941}ड\u{94d}रायवर"),
            keywords: &[
                "साधन",
                "स\u{94d}क\u{94d}र\u{941}",
                "स\u{94d}क\u{94d}र\u{941}ड\u{94d}रायवर",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("отвертка"),
            keywords: &["отвертка"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໄຂຄວງ"),
            keywords: &["ຕະລະບ\u{eb4}ດ", "ເຄ\u{eb7}\u{ec8}ອງມ\u{eb7}", "ໄຂຄວງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("atsuktuvas"),
            keywords: &["atsuktuvas", "varžtas", "įrankis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("skrūvgriezis"),
            keywords: &["darbarīks", "skrūvgriezis", "skrūvēt"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("шрафцигер"),
            keywords: &["алат", "шраф", "шрафцигер"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d4d}ക\u{d4d}ര\u{d42}ഡ\u{d4d}രൈവർ"),
            keywords: &[
                "പണിയ\u{d3e}യ\u{d41}ധം",
                "സ\u{d4d}ക\u{d4d}ര\u{d42}",
                "സ\u{d4d}ക\u{d4d}ര\u{d42}ഡ\u{d4d}രൈവർ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("халив"),
            keywords: &["багаж", "халив", "эрэг шураг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{94d}क\u{94d}र\u{942}ड\u{94d}रायव\u{94d}हर"),
            keywords: &[
                "साधन",
                "स\u{94d}क\u{94d}र\u{942}",
                "स\u{94d}क\u{94d}र\u{942}ड\u{94d}रायव\u{94d}हर",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pemutar skru"),
            keywords: &["alat", "pemutar skru", "skru"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဝက\u{103a}အ\u{1030}လ\u{103e}ည\u{1037}\u{103a}"),
            keywords: &[
                "တ\u{1030}းလ\u{103a}",
                "ဝက\u{103a}အ\u{1030}",
                "ဝက\u{103a}အ\u{1030}လ\u{103e}ည\u{1037}\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("skrutrekker"),
            keywords: &["skrue", "skrujern", "skrutrekker", "verktøy"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("मार\u{94d}तोल"),
            keywords: &["उपकरण", "मार\u{94d}तोल", "स\u{94d}क\u{94d}र\u{941}"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("schroevendraaier"),
            keywords: &["gereedschap", "schroef", "schroevendraaier"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("skrutrekkjar"),
            keywords: &["skrue", "skrujern", "skrutrekkjar", "verktøy"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପେଚକଶ"),
            keywords: &["ପେଚ", "ପେଚକଶ", "ଯନ\u{b4d}ତ\u{b4d}ରପ\u{b3e}ତ\u{b3f}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a47}ਚਕਸ"),
            keywords: &["ਔਜ\u{a3c}ਾਰ", "ਪ\u{a47}ਚ", "ਪ\u{a47}ਚਕਸ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Skrúdraíva"),
            keywords: &["Skru", "Skrúdraíva", "Tul"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("śrubokręt"),
            keywords: &["narzędzie", "wkręt", "wkrętak", "śruba", "śrubokręt"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پيچ کش"),
            keywords: &["اله", "سکورو", "پيچ کش"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("chave de fenda"),
            keywords: &["chave de fenda", "ferramenta"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("chave de fendas"),
            keywords: &["aparafusar", "chave de fendas", "ferramenta"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("șurubelniță"),
            keywords: &["instrument", "sculă", "unealtă", "șurub", "șurubelniță"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-063"),
            keywords: &["E13-063"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("отвертка"),
            keywords: &["винт", "инструмент", "отвертка"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اسڪرو ڊرائيور"),
            keywords: &["اسڪرو", "اسڪرو ڊرائيور", "اوزار"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඉස\u{dca}ක\u{dd4}ර\u{dd4}ප\u{dca}ප\u{dd4} න\u{dd2}යන"),
            keywords: &[
                "ඉස\u{dca}ක\u{dd4}ර\u{dd4}ප\u{dca}ප\u{dd4}",
                "ඉස\u{dca}ක\u{dd4}ර\u{dd4}ප\u{dca}ප\u{dd4} න\u{dd2}යන",
                "මෙවලම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("skrutkovač"),
            keywords: &["nástroj", "skrutka", "skrutkovač"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("izvijač"),
            keywords: &["izvijač", "orodje", "vijak"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kashwiito"),
            keywords: &["dhuujin", "kashwiito", "qalab"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kaçavidë"),
            keywords: &["kaçavidë", "vegël", "vidë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("шрафцигер"),
            keywords: &["алат", "шрафити", "шрафцигер"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("šrafciger"),
            keywords: &["alat", "šrafciger", "šrafiti"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("skruvmejsel"),
            keywords: &["skruvmejsel", "verktyg"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("bisibisi"),
            keywords: &["bisibisi", "parafujo", "zana"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("திருப\u{bcd}புளி"),
            keywords: &["கருவி", "திருப\u{bcd}புளி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c4d}క\u{c4d}రూడ\u{c4d}ర\u{c48}వర\u{c4d}"),
            keywords: &[
                "స\u{c3e}ధనం",
                "స\u{c4d}క\u{c4d}రూ",
                "స\u{c4d}క\u{c4d}రూడ\u{c4d}ర\u{c48}వర\u{c4d}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ไขควง"),
            keywords: &["สกร\u{e39}", "เคร\u{e37}\u{e48}องม\u{e37}อ", "ไขควง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("otwýortka"),
            keywords: &["abzal", "otwýortka"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("vetesikalu"),
            keywords: &["vetesikalu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("tornavida"),
            keywords: &["alet", "sıkma", "tornavida", "vida"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("викрутка"),
            keywords: &["викрутка", "гвинт", "інструмент"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پیچ کس"),
            keywords: &["آلہ", "پیچ", "پیچ کس"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("otvertka"),
            keywords: &["asbob", "burash", "otvertka", "qotirish"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tua vít"),
            keywords: &["bắt vít", "dụng cụ", "tua vít"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("螺絲批"),
            keywords: &["工具", "螺絲", "螺絲批"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("螺丝批"),
            keywords: &["工具", "螺丝", "螺丝批"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("螺丝刀"),
            keywords: &["工具", "螺丝", "螺丝刀"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("螺絲起子"),
            keywords: &["工具", "羅賴把", "螺絲", "螺絲起子"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isikebheli"),
            keywords: &["i-screw", "isikebheli", "ithuluzi"],
        },
    ],
};
#[doc = "🔩"]
pub const NUT_AND_BOLT: crate::Emoji = crate::Emoji {
    glyph: "🔩",
    codepoint: "1F529",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "nut and bolt",
    group: "Objects",
    subgroup: "tool",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("bout en moer"),
            keywords: &["bout", "bout en moer", "gereedskap", "moer"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ዳዶ እና ማፈኛ"),
            keywords: &["መሣሪያ", "ማፈኛ", "ዳዶ", "ዳዶ እና ማፈኛ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("صامولة ومسمار"),
            keywords: &["صامولة", "صامولة ومسمار", "عدة", "مسمار"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("নট আৰ\u{9c1} বল\u{9cd}ট\u{9c1}"),
            keywords: &[
                "নট",
                "নট আৰ\u{9c1} বল\u{9cd}ট\u{9c1}",
                "বল\u{9cd}ট\u{9c1}",
                "স\u{981}জ\u{9c1}লি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("bolt və qayka"),
            keywords: &["alət", "bolt", "bolt və qayka", "qayka"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ніт і гайка"),
            keywords: &["болт", "гайка", "ніт і гайка", "шруба", "інструмент"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Болт и гайка"),
            keywords: &["Болт и гайка", "болт", "гайка", "инструмент"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ন\u{9be}ট এবং বোল\u{9cd}ট"),
            keywords: &[
                "ন\u{9be}ট",
                "ন\u{9be}ট এবং বোল\u{9cd}ট",
                "বোল\u{9cd}ট",
                "সরঞ\u{9cd}জ\u{9be}ম",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("biñs ha kraouenn"),
            keywords: &["biñs", "biñs ha kraouenn", "kraouenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("šaraf i matica"),
            keywords: &["alat", "matica", "vijak", "šaraf", "šaraf i matica"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cargol i femella"),
            keywords: &["cargol", "cargol i femella", "femella"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᏓᏱᏗᏍᏙᏗ ᎠᎴ ᎦᎭᏗ"),
            keywords: &["ᎠᏍᏓᏱᏗᏍᏙᏗ", "ᎠᏍᏓᏱᏗᏍᏙᏗ ᎠᎴ ᎦᎭᏗ", "ᎦᎭᏗ", "ᎬᏔᏂᏓᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("šroub a matice"),
            keywords: &["matice", "nářadí", "šroub", "šroub a matice"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("nyten a bollt"),
            keywords: &["bollt", "nyten", "nyten a bollt", "offeryn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("møtrik og bolt"),
            keywords: &["bolt", "møtrik", "møtrik og bolt", "værktøj"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Mutter und Schraube"),
            keywords: &["Mutter und Schraube", "Schraube"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("βίδα και παξιμάδι"),
            keywords: &["βίδα", "βίδα και παξιμάδι", "εργαλείο", "παξιμάδι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("nut and bolt"),
            keywords: &["bolt", "nut", "nut and bolt", "tool"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("tornillo y tuerca"),
            keywords: &["herramienta", "tornillo", "tornillo y tuerca", "tuerca"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("perno con tuerca"),
            keywords: &["herramienta", "perno", "perno con tuerca", "tuerca"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("polt ja mutter"),
            keywords: &["mutter", "polt", "polt ja mutter", "tööriist"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("torloju eta azkoina"),
            keywords: &["azkoin", "torloju", "torloju eta azkoina", "trsna"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پیچ و مهره"),
            keywords: &["ابزار", "مهره", "پیچ", "پیچ و مهره", "پیچ\u{200c}مهره"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ruuvi ja mutteri"),
            keywords: &["mutteri", "ruuvi", "ruuvi ja mutteri", "työkalu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nut at bolt"),
            keywords: &["bolt", "kagamitan", "nut", "nut at bolt"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("møtrikkur og boltur"),
            keywords: &["amboð", "boltur", "møtrikkur", "møtrikkur og boltur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("vis et écrou"),
            keywords: &["outil", "vis", "vis et écrou", "écrou"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["outil", "vis", "vis et écrou", "écrou"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cnó agus bolta"),
            keywords: &["bolta", "cnó", "cnó agus bolta", "uirlis"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cnò ’s bolta"),
            keywords: &["acainn", "bolta", "cnò", "cnò ’s bolta", "inneal"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("parafuso con porca"),
            keywords: &["parafuso", "parafuso con porca", "porca", "tornillo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("નટ અન\u{ac7} બોલ\u{acd}ટ"),
            keywords: &["નટ", "નટ અન\u{ac7} બોલ\u{acd}ટ", "બોલ\u{acd}ટ", "સાધન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("noti da ƙusa"),
            keywords: &["kayan aiki", "noti", "noti da ƙusa", "ƙusa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("בורג ואום"),
            keywords: &["אום", "בורג", "בורג ואום"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("नट और बोल\u{94d}ट"),
            keywords: &["औज\u{93c}ार", "नट", "नट और बोल\u{94d}ट", "बोल\u{94d}ट"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("vijak i matica"),
            keywords: &["alat", "matica", "vijak", "vijak i matica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("csavar és anya"),
            keywords: &["anya", "csavar", "csavar és anya", "szerszám"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մանեկ ու հեղույս"),
            keywords: &["գործիք", "հեղույս", "մանեկ", "մանեկ ու հեղույս"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("mur dan baut"),
            keywords: &["alat", "baut", "mur", "mur dan baut"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("mkpụrụ igwe na okporo igwe"),
            keywords: &[
                "mkpụrụ igwe",
                "mkpụrụ igwe na okporo igwe",
                "ngwaọrụ",
                "okporo igwe",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("bolti og ró"),
            keywords: &["bolti", "bolti og ró", "ró", "verkfæri"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("vite e bullone"),
            keywords: &["bullonare", "bullone", "fissare", "vite e bullone"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ボルトとナット"),
            keywords: &["ナット", "ボルト", "ボルトとナット", "工具"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("mur lan baut"),
            keywords: &["baut", "bekakas", "mur", "mur lan baut"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქანჩი და ჭანჭიკი"),
            keywords: &[
                "ინსტრუმენტი",
                "ქანჩი",
                "ქანჩი და ჭანჭიკი",
                "ჭანჭიკი",
                "ხელსაწყო",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сомын мен бұранда"),
            keywords: &["бұранда", "сомын", "сомын мен бұранда", "құрал"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("møtrik og bolt"),
            keywords: &["bolt", "møtrik", "møtrik og bolt", "værktøj"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ខ\u{17d2}ចៅន\u{17b7}ងក\u{17d2}បាលឡោស\u{17ca}\u{17b8}"),
            keywords: &[
                "ក\u{17d2}បាលឡោស\u{17ca}\u{17b8}",
                "ខ\u{17d2}ចៅ",
                "ខ\u{17d2}ចៅន\u{17b7}ងក\u{17d2}បាលឡោស\u{17ca}\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ತ\u{cbf}ರುಪು ಮತ\u{ccd}ತು ಬೋಲ\u{ccd}ಟ\u{ccd}"),
            keywords: &[
                "ಉಪಕರಣ",
                "ತ\u{cbf}ರುಪು",
                "ತ\u{cbf}ರುಪು ಮತ\u{ccd}ತು ಬೋಲ\u{ccd}ಟ\u{ccd}",
                "ಬೋಲ\u{ccd}ಟ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("볼트와 너트"),
            keywords: &["나사", "너트", "도구", "볼트", "볼트와 너트"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("नट आनी बोल\u{94d}ट"),
            keywords: &["नट", "नट आनी बोल\u{94d}ट", "बोल\u{94d}ट", "साधन"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("гайка менен болт"),
            keywords: &["болт", "гайка", "гайка менен болт", "курал"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Mudder a Schrauf"),
            keywords: &["Handwierksgeschir", "Mudder", "Mudder a Schrauf", "Schrauf"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ນ\u{eb1}ອດໂຕຜ\u{eb9}\u{ec9} ແລະໂຕແມ\u{ec8}"),
            keywords: &[
                "ນ\u{eb1}ອດໂຕຜ\u{eb9}\u{ec9}",
                "ນ\u{eb1}ອດໂຕຜ\u{eb9}\u{ec9} ແລະໂຕແມ\u{ec8}",
                "ນ\u{eb1}ອດໂຕແມ\u{ec8}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("veržlė ir varžtas"),
            keywords: &["varžtas", "veržlė", "veržlė ir varžtas", "įrankis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("skrūve un uzgrieznis"),
            keywords: &["skrūve", "skrūve un uzgrieznis", "tapa", "uzgrieznis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("nati me te whaowiri"),
            keywords: &["nati", "nati me te whaowiri", "utauta", "whaowiri"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("завртка и навртка"),
            keywords: &["завртка", "завртка и навртка", "навртка", "шраф"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("നട\u{d4d}ട\u{d41}ം ബോൾട\u{d4d}ട\u{d41}ം"),
            keywords: &[
                "ഉപകരണം",
                "നട\u{d4d}ട\u{d41}ം ബോൾട\u{d4d}ട\u{d41}ം",
                "നട\u{d4d}ട\u{d4d}",
                "ബോൾട\u{d4d}ട\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эрэг боолт"),
            keywords: &["боолт", "эрэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("नट आणि बोल\u{94d}ट"),
            keywords: &["नट", "नट आणि बोल\u{94d}ट", "बोल\u{94d}ट", "साधन"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("nat dan bolt"),
            keywords: &["alat", "bolt", "nat", "nat dan bolt"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("vit u skorfina"),
            keywords: &["għodda", "skorfina", "vit", "vit u skorfina"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "မ\u{1030}လ\u{102e}န\u{103e}င\u{1037}\u{103a} မ\u{1030}လ\u{102e}ခေါင\u{103a}း",
            ),
            keywords: &[
                "က\u{102d}ရ\u{102d}ယာ",
                "မ\u{1030}လ\u{102e}",
                "မ\u{1030}လ\u{102e}ခေါင\u{103a}း",
                "မ\u{1030}လ\u{102e}န\u{103e}င\u{1037}\u{103a} မ\u{1030}လ\u{102e}ခေါင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mutter og skrue"),
            keywords: &["mutter", "mutter og skrue", "skrue", "verktøy"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("नट र बोल\u{94d}ट"),
            keywords: &["उपकरण", "नट", "नट र बोल\u{94d}ट", "बोल\u{94d}ट"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bout en moer"),
            keywords: &["bout", "bout en moer", "gereedschap", "moer"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mutter og skrue"),
            keywords: &["mutter", "mutter og skrue", "skrue", "verktøy"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ନଟ\u{b4d}\u{200c} ଏବଂ ବୋଲ\u{b4d}ଟ"),
            keywords: &[
                "ଉପକରଣ",
                "ନଟ\u{b4d}",
                "ନଟ\u{b4d} ଏବଂ ବୋଲ\u{b4d}ଟ\u{b4d}",
                "ନଟ\u{b4d}\u{200c} ଏବଂ ବୋଲ\u{b4d}ଟ",
                "ବୋଲ\u{b4d}ଟ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਨ\u{a71}ਟ ਅਤ\u{a47} ਬ\u{a4b}ਲਟ"),
            keywords: &[
                "ਔਜ\u{a3c}ਾਰ",
                "ਨ\u{a71}ਟ",
                "ਨ\u{a71}ਟ ਅਤ\u{a47} ਬ\u{a4b}ਲਟ",
                "ਬ\u{a4b}ਲਟ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کنڈی اتے میخ"),
            keywords: &["اوزار", "خشک میوہ جات", "کنڈی اتے میخ", "ک\u{64f}نڈی لانا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Nọ\u{301}t An Bolt"),
            keywords: &["Bolt", "Nọt", "Nọ\u{301}t An Bolt", "Tul"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("śruba i nakrętka"),
            keywords: &[
                "gwint",
                "mocowanie",
                "nakrętka",
                "śruba",
                "śruba i nakrętka",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("نټ او بولټ"),
            keywords: &["اله", "بولټ", "نټ", "نټ او بولټ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("porca e parafuso"),
            keywords: &["ferramenta", "parafuso", "porca", "porca e parafuso"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("șurub și piuliță"),
            keywords: &["instrument", "piuliță", "șurub", "șurub și piuliță"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-741"),
            keywords: &["E10-741"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("болт и гайка"),
            keywords: &[
                "болт",
                "болт и гайка",
                "винт",
                "гайка",
                "инструмент",
                "шуруп",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("iburo n’agafungisho"),
            keywords: &[
                "agafata iburo",
                "iburo",
                "iburo n’agafungisho",
                "igikoresho",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("نٽ ۽ بولٽ"),
            keywords: &["اوزار", "بولٽ", "نٽ", "نٽ ۽ بولٽ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("නට\u{dca} ඇන\u{dca}ඩ\u{dca} බෝල\u{dca}ට\u{dca}"),
            keywords: &[
                "නට\u{dca}",
                "නට\u{dca} ඇන\u{dca}ඩ\u{dca} බෝල\u{dca}ට\u{dca}",
                "බෝල\u{dca}ට\u{dca}",
                "මෙවලම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("matica a skrutka"),
            keywords: &["matica a skrutka", "matka", "nástroj", "skrutka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("matica in vijak"),
            keywords: &["matica", "matica in vijak", "orodje", "vijak"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("weesar iyo bool"),
            keywords: &["bool", "qalab", "weesar", "weesar iyo bool"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("bulon dhe dado"),
            keywords: &["bulon", "bulon dhe dado", "dado", "vegël"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("навртка и завртањ"),
            keywords: &["aлaт", "завртањ", "навртка", "навртка и завртањ"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("navrtka i zavrtanj"),
            keywords: &["alat", "navrtka", "navrtka i zavrtanj", "zavrtanj"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("skruv och mutter"),
            keywords: &["mutter", "skruv", "skruv och mutter"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nati na bolti"),
            keywords: &["bolti", "nati", "nati na bolti", "zana"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("நட\u{bcd}டு மற\u{bcd}றும\u{bcd} போல\u{bcd}ட\u{bcd}"),
            keywords: &[
                "கருவி",
                "நட\u{bcd}டு",
                "நட\u{bcd}டு மற\u{bcd}றும\u{bcd} போல\u{bcd}ட\u{bcd}",
                "போல\u{bcd}ட\u{bcd}",
                "போல\u{bcd}ட\u{bcd}டும\u{bcd} நட\u{bcd}டும\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("నట\u{c4d}టు మర\u{c3f}యు బ\u{c4b}ల\u{c4d}టు"),
            keywords: &[
                "నట\u{c4d}టు",
                "నట\u{c4d}టు మర\u{c3f}యు బ\u{c4b}ల\u{c4d}టు",
                "బ\u{c4b}ల\u{c4d}టు",
                "స\u{c3e}ధనం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("гайка ва мурват"),
            keywords: &["асбоб", "гайка", "гайка ва мурват", "мурват"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("สล\u{e31}กและน\u{e47}อต"),
            keywords: &["สล\u{e31}กและน\u{e47}อต", "เคร\u{e37}\u{e48}องม\u{e37}อ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("bolt-nurbat"),
            keywords: &["bolt", "bolt-nurbat", "gaýka", "gural"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("nati moe polota"),
            keywords: &["nati moe polota"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("somun ve vida"),
            keywords: &["araç", "somun", "somun ve vida", "vida"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("گايكا ۋە ۋىنتا"),
            keywords: &["قورال", "گايكا", "گايكا ۋە ۋىنتا", "ۋىنتا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("гайка та болт"),
            keywords: &["болт", "гайка", "гайка та болт", "інструмент"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("نٹ اور بولٹ"),
            keywords: &["آلہ", "بولٹ", "نٹ", "نٹ اور بولٹ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("gayka va murvat"),
            keywords: &["asbob", "gayka", "gayka va murvat", "murvat"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đai ốc và bu lông"),
            keywords: &["bu lông", "dụng cụ", "đai ốc", "đai ốc và bu lông"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("buloŋ ak wiisam"),
            keywords: &["buloŋ", "buloŋ ak wiisam", "jumtukaay", "nut"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("imortyisi nesikhonkwane"),
            keywords: &[
                "imortyisi",
                "imortyisi nesikhonkwane",
                "isikhonkwane",
                "isixhobo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("nọti ati botu"),
            keywords: &[
                "bóòtù",
                "irinṣé\u{329}",
                "nó\u{329}ọ\u{300}tì",
                "nọti ati botu",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("螺母同螺栓"),
            keywords: &["工具", "螺栓", "螺母", "螺母同螺栓"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("螺母同螺栓"),
            keywords: &["工具", "螺栓", "螺母", "螺母同螺栓"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("螺母与螺栓"),
            keywords: &["工具", "螺丝", "螺帽", "螺栓", "螺母", "螺母与螺栓"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("螺絲"),
            keywords: &["螺栓", "螺絲"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["工具", "螺絲", "螺絲帽"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibholidi"),
            keywords: &["ibholidi", "ithuluzi"],
        },
    ],
};
#[doc = "⚙\u{fe0f}"]
pub const GEAR: crate::Emoji = crate::Emoji {
    glyph: "⚙\u{fe0f}",
    codepoint: "2699 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "gear",
    group: "Objects",
    subgroup: "tool",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "⚙",
        codepoint: "2699",
        status: crate::Status::Unqualified,
        introduction_version: 1f32,
        name: "gear",
        group: "Objects",
        subgroup: "tool",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("rat"),
            keywords: &["gereedskap", "rat"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሞተር ጥርስ"),
            keywords: &["መሣሪያ", "ሞተር ጥርስ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ترس"),
            keywords: &["أداة", "ترس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("গীয\u{9bc}েৰ"),
            keywords: &["গীয\u{9bc}েৰ", "স\u{981}জ\u{9c1}লি"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("mexanizm"),
            keywords: &["alət", "mexanizm"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("шасцярня"),
            keywords: &["дэталь", "шасцярня", "шасцярэнька", "інструмент"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Зъбно колело"),
            keywords: &["Зъбно колело", "инструмент"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("গিয\u{9bc}\u{9be}র"),
            keywords: &["গিয\u{9bc}\u{9be}র", "সরঞ\u{9cd}জ\u{9be}ম"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("rod dantek"),
            keywords: &["benveg", "rod dantek"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zupčanik"),
            keywords: &["alat", "zubac", "zupčanik"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("engranatge"),
            keywords: &["eina", "engranatge"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎬᏔᏅᏙᏗ"),
            keywords: &["ᎬᏔᏂᏓᏍᏗ", "ᎬᏔᏅᏙᏗ", "ᎬᏔᏅᏙᏗ ᎦᏆᏙᏗ", "ᎬᏔᏅᏙᏗᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("ozubené kolo"),
            keywords: &["nářadí", "ozubené kolo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("gêr"),
            keywords: &["gêr", "offeryn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("tandhjul"),
            keywords: &["gear", "tandhjul", "værktøj"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Zahnrad"),
            keywords: &["Werkzeug", "Zahnrad"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γρανάζι"),
            keywords: &["γρανάζι", "εργαλείο", "οδοντωτός τροχός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("gear"),
            keywords: &["cog", "cogwheel", "gear", "tool"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("engranaje"),
            keywords: &["engranaje", "herramienta"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["diente", "engranaje", "herramienta", "rueda dentada"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("hammasratas"),
            keywords: &["hammasratas", "tööriist"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("engranajea"),
            keywords: &["engranajea", "tresna"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("چرخ\u{200c}دنده"),
            keywords: &["ابزار", "چرخ\u{200c}دنده"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hammasratas"),
            keywords: &["hammasratas", "työkalu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("gear"),
            keywords: &["gear", "kagamitan", "kogwil", "makinarya"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("tannhjól"),
            keywords: &["amboð", "gir", "tannhjól"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("roue dentée"),
            keywords: &["engrenage", "outil", "roue dentée"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("engrenage"),
            keywords: &["engrenage", "outil"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("giar"),
            keywords: &["giar", "uirlis"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("gèar"),
            keywords: &["acainn", "gèar", "inneal"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("engrenaxe"),
            keywords: &["engrenaxe", "mecanismo", "roda dentada"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ગિયર"),
            keywords: &["ગિયર", "સાધન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("giya"),
            keywords: &["giya", "kayan aiki"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גלגל שיניים"),
            keywords: &["גלגל שיניים", "מנגנון"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("गियर"),
            keywords: &["गियर", "ट\u{942}ल"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zupčanik"),
            keywords: &["alat", "zupčanik"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fogaskerék"),
            keywords: &["fogaskerék", "szerszám"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ատամնանիվ"),
            keywords: &["ատամնանիվ", "գործիք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("roda gigi"),
            keywords: &["alat", "roda gigi"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("giya"),
            keywords: &["giya", "ngwaọrụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("gírhjól"),
            keywords: &["gírhjól", "verkfæri"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("ingranaggio"),
            keywords: &["componente", "ingranaggio", "meccanismo", "ruota dentata"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("歯車"),
            keywords: &["ギア", "工具", "歯車"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("gir"),
            keywords: &["bekakas", "gir", "ring gir"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კბილანა"),
            keywords: &["ინსტრუმენტი", "კბილანა", "ხელსაწყო"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: None,
            keywords: &["afecku"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тегершік"),
            keywords: &["тегершік", "құрал"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("tandhjul"),
            keywords: &["tandhjul", "værktøj"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}ព\u{17ba}"),
            keywords: &["ស\u{17d2}ព\u{17ba}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಗೇರ\u{ccd}"),
            keywords: &[
                "ಕತ\u{ccd}ತರ\u{cbf}ಗಳು",
                "ಗೇರ\u{ccd}",
                "ಟ\u{cc2}ಲ\u{ccd}",
                "ಪರ\u{cbf}ಕರ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("톱니바퀴"),
            keywords: &["기어", "톱니바퀴"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("गियर"),
            keywords: &["कॉग", "कॉगव\u{94d}हील", "गियर", "साधन"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("механизм"),
            keywords: &["курал", "механизм"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Zännrad"),
            keywords: &["Handwierksgeschir", "Zännrad"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຟ\u{eb7}ອງເກຍ"),
            keywords: &["ເກຍ", "ເຄ\u{eb7}\u{ec8}ອງມ\u{eb7}", "ເຟ\u{eb7}ອງເກຍ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("krumpliaratis"),
            keywords: &["krumpliaratis", "įrankis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zobrats"),
            keywords: &["darbarīks", "zobrats"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("taputapu"),
            keywords: &["taputapu", "utauta"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("запченик"),
            keywords: &["алатка", "запченик"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഗിയർ"),
            keywords: &["ഉപകരണം", "ഗിയർ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хөдөлгүүр"),
            keywords: &["араа", "багаж", "тоноглол", "хөдөлгүүр", "шүд"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("गिअर"),
            keywords: &["गिअर", "साधन"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("gear"),
            keywords: &["alat", "gear"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("apparat"),
            keywords: &["apparat", "għodda"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဂ\u{102e}ယာ"),
            keywords: &[
                "ခ\u{103d}ေးသ\u{103d}ားစ\u{102d}တ\u{103a}",
                "ဂ\u{102e}ယာ",
                "တ\u{1030}းလ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("tannhjul"),
            keywords: &["del", "tann", "tannhjul", "verktøy"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("गियर"),
            keywords: &["उपकरण", "गियर"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("tandwiel"),
            keywords: &["gereedschap", "radertje", "tandrad", "tandwiel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("tannhjul"),
            keywords: &["del", "tann", "tannhjul", "verktøy"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଗ\u{b3f}ୟର\u{b4d}\u{200c}"),
            keywords: &[
                "କଗ\u{b4d}\u{200c}",
                "କଗ\u{b4d}\u{200c}ହ\u{b4d}ୱ\u{b3f}ଲ\u{b4d}\u{200d}",
                "ଗ\u{b3f}ୟର",
                "ଗ\u{b3f}ୟର\u{b4d}\u{200c}",
                "ଯନ\u{b4d}ତ\u{b4d}ରପ\u{b3e}ତ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਗਰਾਰੀ"),
            keywords: &["ਔਜ\u{a3c}ਾਰ", "ਗਰਾਰੀ", "ਗਿਆਰ ਔਜ\u{a3c}ਾਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("گئیر"),
            keywords: &["اوزار", "گئیر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Gia"),
            keywords: &["Gia", "Kọg", "Kọ\u{301}gwil", "Tul"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("koło zębate"),
            keywords: &[
                "koło zębate",
                "kółko",
                "skrzynia biegów",
                "zębate",
                "zębatka",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ګيرارۍ"),
            keywords: &["اله", "د کيرارو پايه", "غاښ", "کيرارۍ", "ګيرارۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("engrenagem"),
            keywords: &["engrenagem", "ferramenta"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("roda dentada"),
            keywords: &["ferramenta", "roda dentada"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("rotiță zimțată"),
            keywords: &[
                "instrument",
                "roată dințată",
                "roată zimțată",
                "rotiță dințată",
                "rotiță zimțată",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-089"),
            keywords: &["E10-089"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("шестеренка"),
            keywords: &["деталь", "зубчатое", "колесо", "шестеренка", "шестерня"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ishusho ringi"),
            keywords: &["igikoresho", "ishusho ringi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("گيئر"),
            keywords: &["اوزار", "گيئر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ග\u{dd2}යරය"),
            keywords: &["ග\u{dd2}යරය", "මෙවලම"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ozubené koliesko"),
            keywords: &["nástroj", "ozubené koliesko"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zobnik"),
            keywords: &["orodje", "zobnik"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("geer"),
            keywords: &["geer", "qalab", "wareeg", "wareeg taayir"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("ingranazh"),
            keywords: &["ingranazh", "vegël"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("зупчаник"),
            keywords: &["aлaт", "зупчаник"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("zupčanik"),
            keywords: &["alat", "zupčanik"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kugghjul"),
            keywords: &["kugge", "kugghjul"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("gia"),
            keywords: &["gia", "zana"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கியர\u{bcd}"),
            keywords: &[
                "இயந\u{bcd}திரம\u{bcd}",
                "கருவி",
                "கியர\u{bcd}",
                "பொறியியல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("గ\u{c47}ర\u{c4d}"),
            keywords: &[
                "గ\u{c47}ర\u{c4d}",
                "వ\u{c3f}డ\u{c3f}భ\u{c3e}గం",
                "స\u{c3e}ధనం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("чархи дандонадор"),
            keywords: &["асбоб", "чархи дандонадор"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เฟ\u{e37}อง"),
            keywords: &["เคร\u{e37}\u{e48}องม\u{e37}อ", "เฟ\u{e37}อง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("dişli"),
            keywords: &["dişli", "gural", "çarh", "çarhly teker"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("veʻeteka"),
            keywords: &["veʻeteka"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("dişli"),
            keywords: &["alet", "dişli"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چىشلىق چاق"),
            keywords: &["قورال", "چىشلىق چاق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("шестірня"),
            keywords: &["шестірня", "інструмент"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گیئر"),
            keywords: &["آلہ", "گراری", "گیئر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tishli g‘ildirak"),
            keywords: &[
                "shesternya",
                "tish",
                "tishli gʻildirak",
                "tishli g‘ildirak",
                "uskuna",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bánh răng"),
            keywords: &["bánh răng", "dụng cụ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("piñoŋ"),
            keywords: &["jumtukaay", "piñoŋ"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("igiyeri"),
            keywords: &["igiyeri", "isixhobo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("gíà"),
            keywords: &["gíà", "irinsẹ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("齒輪"),
            keywords: &["工具", "齒輪"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("齿轮"),
            keywords: &["工具", "齿轮"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("齿轮"),
            keywords: &["传动", "工具", "机械", "零件", "齿轮"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("齒輪"),
            keywords: &["齒輪"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["工具", "齒輪"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("igiya"),
            keywords: &["igiya", "ithuluzi"],
        },
    ],
};
#[doc = "🗜\u{fe0f}"]
pub const CLAMP: crate::Emoji = crate::Emoji {
    glyph: "🗜\u{fe0f}",
    codepoint: "1F5DC FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "clamp",
    group: "Objects",
    subgroup: "tool",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🗜",
        codepoint: "1F5DC",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "clamp",
        group: "Objects",
        subgroup: "tool",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("klamp"),
            keywords: &["gereedskap", "klamp", "kompressie", "pers", "samepersing"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መጨፍለቂያ"),
            keywords: &["መሣሪያ", "መጨፍለቂያ", "ክፋት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("آلة ضغط"),
            keywords: &["آلة ضغط", "أداة", "ضغط"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চেপনী"),
            keywords: &["চেপনী", "ভ\u{9be}ইচ", "স\u{981}জ\u{9c1}লি", "সংকোচক"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sıxma"),
            keywords: &["alət", "kəlbətin", "sıxma"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ціскі"),
            keywords: &["сцісканне", "ціскі", "інструмент"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("компресия"),
            keywords: &["инструмент", "компресия", "менгеме"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9cd}ল\u{9cd}য\u{9be}ম\u{9cd}প"),
            keywords: &[
                "ক\u{9cd}ল\u{9cd}য\u{9be}ম\u{9cd}প",
                "ভ\u{9be}ইস",
                "সরঞ\u{9cd}জ\u{9be}ম",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("serjant"),
            keywords: &["benveg", "serjant"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kompresija"),
            keywords: &["alat", "kompresija", "stega"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("serjant"),
            keywords: &["cargol de banc", "compressió", "eina", "serjant"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎬᏙᏗ"),
            keywords: &["ᎬᏂᏱᏙᏗ", "ᎬᏔᏂᏓᏍᏗ", "ᎬᏙᏗ", "ᏍᏓᏱ ᎠᏐᏅᏍᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("svěrka"),
            keywords: &["komprese", "nářadí", "svorka", "svěrka", "tlak"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cywasgedd"),
            keywords: &["cywasgedd", "feis", "offeryn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("skruetvinge"),
            keywords: &["skruestik", "skruetvinge", "værktøj"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schraubzwinge"),
            keywords: &["Schraubzwinge", "Werkzeug"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σφιγκτήρας"),
            keywords: &["εργαλείο", "πρέσα", "σφίγγω", "σφιγκτήρας"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("clamp"),
            keywords: &["clamp", "compress", "tool", "vice"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("tornillo de banco"),
            keywords: &["herramienta", "tornillo", "tornillo de banco"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("abrazadera"),
            keywords: &["abrazadera"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kruustangid"),
            keywords: &["kruustangid", "tööriist"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("konprimatzea"),
            keywords: &["konprimatzea", "tresna"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پرس"),
            keywords: &["ابزار", "صحافی", "پرس"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ruuvipuristin"),
            keywords: &["puristin", "ruuvipenkki", "ruuvipuristin", "työkalu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("compression"),
            keywords: &["compression", "gato", "i-compress", "kagamitan", "salansan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("skrúvutvinga"),
            keywords: &[
                "amboð",
                "skrúvustikka",
                "skrúvutvinga",
                "spenniskrúva",
                "tvinga",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("serre-joint"),
            keywords: &["outil", "serre-joint"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("serre-joint"),
            keywords: &["outil", "serre-joint", "étau"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("clampa"),
            keywords: &["bís", "clampa", "comhbhrú", "uirlis"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("clabhd"),
            keywords: &[
                "clabhd",
                "dùmhladh",
                "dùmhlaich",
                "glamradh",
                "gramaiche",
                "inneal",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("ferramenta de compresión"),
            keywords: &["compresión", "ferramenta", "ferramenta de compresión"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ક\u{acd}લ\u{ac7}મ\u{acd}પ"),
            keywords: &[
                "કમ\u{acd}પ\u{acd}ર\u{ac7}શન",
                "ક\u{acd}લ\u{ac7}મ\u{acd}પ",
                "સાધન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kayan ɗaurewa"),
            keywords: &["datsa", "kayan aiki", "kayan ɗaurewa", "sakata"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מלחציים"),
            keywords: &["כלי עבודה", "מלחציים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("क\u{94d}ल\u{948}\u{902}प"),
            keywords: &[
                "क\u{902}प\u{94d}र\u{947}स",
                "क\u{94d}ल\u{948}\u{902}प",
                "ट\u{942}ल",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("škrip"),
            keywords: &["alat", "stezač", "škrip"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("satu"),
            keywords: &["satu", "szerszám"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մամլակ"),
            keywords: &["մամլակ", "մամլիչ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("klem"),
            keywords: &["alat", "klem", "pengompres"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ngwa mkpabi"),
            keywords: &["chịkpàa", "ngwa mkpabi", "ngwa njigide", "ngwaọrụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("þjöppun"),
            keywords: &["skrúfstykki", "verkfæri", "þjöppun"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("morsetto"),
            keywords: &[
                "fissare",
                "morsa",
                "morsetto",
                "serrare",
                "stringere",
                "utensile",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("万力"),
            keywords: &["クランプ", "バイス", "万力", "工具"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("cathok"),
            keywords: &["bekakas", "cathok", "penet"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კომპრესია"),
            keywords: &["ინსტრუმენტი", "კომპრესია", "ხელსაწყო"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қысу"),
            keywords: &["қысу", "құрал"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("skruetvinge"),
            keywords: &["skruestik", "skruetvinge", "værktøj"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ឃ\u{17d2}នៀប"),
            keywords: &[
                "កៀប",
                "ឃ\u{17d2}នៀប",
                "ដែកក\u{17d2}រចាប\u{17cb}",
                "ប\u{17d2}រដាប\u{17cb}កៀប",
                "ឧបករណ\u{17cd}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸಂಕುಚ\u{cbf}ತ"),
            keywords: &[
                "ಕುಗ\u{ccd}ಗುವ\u{cbf}ಕ\u{cc6}",
                "ಪರ\u{cbf}ಕರ",
                "ಸಂಕುಚ\u{cbf}ತ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("압축기"),
            keywords: &["압축기", "콤프레셔"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("क\u{94d}ल\u{945}म\u{94d}प"),
            keywords: &[
                "कॉम\u{94d}प\u{94d}र\u{947}स",
                "क\u{94d}ल\u{945}म\u{94d}प",
                "वायस",
                "साधन",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кысуу"),
            keywords: &["курал", "кыстыргыч", "кысуу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Schraufstack"),
            keywords: &["Handwierksgeschir", "Kompresser", "Schraufstack"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຄ\u{eb7}\u{ec8}ອງບ\u{eb5}ບອ\u{eb1}ດ"),
            keywords: &[
                "ບ\u{eb5}ບອ\u{eb1}ດ",
                "ເຄ\u{eb7}\u{ec8}ອງບ\u{eb5}ບອ\u{eb1}ດ",
                "ເຄ\u{eb7}\u{ec8}ອງມ\u{eb7}",
                "ໜ\u{eb5}ບ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("suspaudimas"),
            keywords: &["spaustuvai", "suspaudimas", "įrankis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("skrūvspīles"),
            keywords: &["darbarīks", "saspiest", "skrūvspīles"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kuku"),
            keywords: &["kuku", "purimau", "utauta", "whakakōpeke"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("стега"),
            keywords: &["алат", "компресија", "менгеме", "стега"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d4d}ല\u{d3e}മ\u{d4d}പ\u{d4d}"),
            keywords: &["ഉപകരണം", "ക\u{d4d}ല\u{d3e}മ\u{d4d}പ\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("шахагч"),
            keywords: &["багаж", "бахь", "шахагч"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{902}कोचन"),
            keywords: &["उपसाधन", "स\u{902}कलित करण\u{947}", "स\u{902}कोचन", "साधन"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("ragum"),
            keywords: &["alat", "pemampatan", "ragum"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("klamp"),
            keywords: &["għodda", "ikkompressa", "klamp", "morsa"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပြ\u{102f}တ\u{103a}တ\u{1030}"),
            keywords: &[
                "က\u{102d}ရ\u{102d}ယာ",
                "ည\u{103e}ပ\u{103a}",
                "ပြ\u{102f}တ\u{103a}တ\u{1030}",
                "ဖ\u{102d}ည\u{103e}ပ\u{103a}သည\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("skrutvinge"),
            keywords: &[
                "klemme",
                "skruetvinge",
                "skrustikke",
                "skrutvinge",
                "verktøy",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{902}क\u{941}चन"),
            keywords: &["उपकरण", "भाइस", "स\u{902}क\u{941}चन"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("lijmklem"),
            keywords: &["bankschroef", "gereedschap", "lijmklem", "samendrukken"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("skrutvinge"),
            keywords: &[
                "klemme",
                "skruetvinge",
                "skrustikke",
                "skrutvinge",
                "verktøy",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b4d}ଲ\u{b3e}ମ\u{b4d}ପ\u{b4d}"),
            keywords: &[
                "କମ\u{b4d}ପ\u{b4d}ରେସ\u{b4d}\u{200c}",
                "କ\u{b4d}ଲ\u{b3e}ମ\u{b4d}ପ\u{b4d}",
                "ଭ\u{b3e}ଇସ\u{b4d}\u{200c}",
                "ଯନ\u{b4d}ତ\u{b4d}ରପ\u{b3e}ତ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਦਬਾਉਣਾ"),
            keywords: &["ਔਜ\u{a3c}ਾਰ", "ਦਬਾਉਣਾ", "ਵਾਈਸ ਔਜ\u{a3c}ਾਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ڈھیر لانا"),
            keywords: &["اوزار", "قائم مقام", "م\u{64f}ختصر کرنا", "ڈھیر لانا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Klamp"),
            keywords: &["Klamp", "Kọmprẹs", "Tul", "Vais"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("ścisk"),
            keywords: &[
                "kompresja",
                "nacisk",
                "prasowanie",
                "presja",
                "ścisk",
                "ściskanie",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("رکاب"),
            keywords: &["اله", "رکاب", "شکنجه", "شکنجه کول"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("braçadeira"),
            keywords: &["braçadeira", "compressão", "ferramenta", "morsa", "torno"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("grampo"),
            keywords: &["ferramenta", "grampo", "torno"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("menghină"),
            keywords: &["comprimare", "instrument", "menghină"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-822"),
            keywords: &["E10-822"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("компрессор"),
            keywords: &["зажим", "компрессор", "тиски"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ipensi"),
            keywords: &["gukanda", "igikoresho", "ipensi", "ivisi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪلپ"),
            keywords: &["اوزار", "وائيس", "ڪلپ", "گھٽائڻ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සම\u{dca}ප\u{dd3}ඩකය"),
            keywords: &["අඬ\u{dd4}ව", "මෙවලම", "සම\u{dca}ප\u{dd3}ඩකය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zverák"),
            keywords: &["nástroj", "zverák"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("stiskanje"),
            keywords: &["orodje", "primež", "stiskanje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("isku xajiye"),
            keywords: &["cadaadin", "isku xajiye", "isku xijiye", "qalab"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("ngjeshje"),
            keywords: &["morsë", "ngjeshje", "ngjeshëse", "shtrënguese", "vegël"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("стега"),
            keywords: &["aлaт", "стега"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("stega"),
            keywords: &["alat", "stega"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("skruvtving"),
            keywords: &["skruvtving", "tving", "verktyg"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kubana"),
            keywords: &["jiliwa ya seremala", "kubana", "zana"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கம\u{bcd}ப\u{bcd}ரஷன\u{bcd} கருவி"),
            keywords: &["கம\u{bcd}ப\u{bcd}ரஷன\u{bcd}", "கருவி", "டூல\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కుద\u{c3f}ంపు"),
            keywords: &["కుద\u{c3f}ంపు", "వ\u{c48}స\u{c4d}", "స\u{c3e}ధనం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("хамут"),
            keywords: &["асбоб", "исканҷа", "фишурдан", "хамут"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เคร\u{e37}\u{e48}องบ\u{e35}บอ\u{e31}ด"),
            keywords: &[
                "บ\u{e35}บอ\u{e31}ด",
                "หน\u{e35}บ",
                "เคร\u{e37}\u{e48}องบ\u{e35}บอ\u{e31}ด",
                "เคร\u{e37}\u{e48}องม\u{e37}อ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gysgyç"),
            keywords: &["gural", "gysgyç", "gysmak"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakauʻu"),
            keywords: &["fakauʻu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("mengene"),
            keywords: &["alet", "mengene", "sıkıştırma"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قىسقۇچ"),
            keywords: &["باستۇرۇق", "قورال", "قىسقۇچ", "قىسىش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("затискач"),
            keywords: &["затискач", "знаряддя", "кліщі"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کلیمپ"),
            keywords: &["آلہ", "اوزار", "کلیمپ", "کمپریس"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kompressor"),
            keywords: &["asbob", "kompressor"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cái kẹp"),
            keywords: &["cái kẹp", "cặp", "dụng cụ", "nén"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("tënaaj"),
            keywords: &["jumtukaay", "kompres", "tënaaj", "wiis"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isibambi"),
            keywords: &["cinezela", "isibambi", "isixhobo", "ivayisi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("gbámú"),
            keywords: &[
                "gbámú",
                "irinṣẹ\u{301}",
                "ohun èlò irinṣẹ\u{301}",
                "ìfúnpọ\u{300}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("鉗"),
            keywords: &["壓", "工具", "虎頭鉗", "鉗"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("钳"),
            keywords: &["压", "工具", "虎头钳", "钳"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("夹钳"),
            keywords: &["夹具", "夹钳", "工具", "机械", "紧固"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("壓縮機"),
            keywords: &["壓縮", "壓縮機"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("車輪夾鎖"),
            keywords: &["車輪夾鎖", "車輪夾鎖｜夾｜壓縮｜工具"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isicindezeli"),
            keywords: &["isicindezeli", "ithuluzi", "uvaysi"],
        },
    ],
};
#[doc = "⚖\u{fe0f}"]
pub const BALANCE_SCALE: crate::Emoji = crate::Emoji {
    glyph: "⚖\u{fe0f}",
    codepoint: "2696 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "balance scale",
    group: "Objects",
    subgroup: "tool",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "⚖",
        codepoint: "2696",
        status: crate::Status::Unqualified,
        introduction_version: 1f32,
        name: "balance scale",
        group: "Objects",
        subgroup: "tool",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("weegskaal"),
            keywords: &[
                "diereriem",
                "geregtigheid",
                "gewig",
                "libra",
                "skaal",
                "weeg",
                "weegskaal",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሚዛን"),
            keywords: &["ሊብራ", "ሚዛን", "ክብደት", "ዞዲያክ", "የተመጣጠነ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ميزان"),
            keywords: &["أداة", "برج", "توازن", "عدالة", "كفتان", "ميزان", "وزن"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ত\u{9c1}ল\u{9be}চনী"),
            keywords: &[
                "ত\u{9c1}ল\u{9be}চনী",
                "ত\u{9c1}ল\u{9be}ৰ\u{9be}শি",
                "ন\u{9cd}য\u{9be}য\u{9bc}",
                "ভ\u{9be}ৰস\u{9be}ম\u{9cd}য",
                "স\u{9cd}কেল",
                "ৰ\u{9be}শিচক\u{9cd}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("tarazlıq tərəzisi"),
            keywords: &["balans", "libra", "tarazlıq tərəzisi", "çəki", "ədalət"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("шалі"),
            keywords: &["задыяк", "шалі"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("везна"),
            keywords: &["везна", "везни", "зодия", "инструмент", "правосъдие"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ভ\u{9be}রস\u{9be}ম\u{9cd}য স\u{9cd}কেল"),
            keywords: &[
                "ওজন",
                "ত\u{9c1}ল\u{9be}",
                "ত\u{9c1}ল\u{9be} র\u{9be}শি",
                "বিচ\u{9be}র",
                "ভ\u{9be}রস\u{9be}ম\u{9cd}য",
                "ভ\u{9be}রস\u{9be}ম\u{9cd}য স\u{9cd}কেল",
                "র\u{9be}শিচক\u{9cd}র",
                "সরঞ\u{9cd}জ\u{9be}ম",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("balañs"),
            keywords: &["balañs", "mentel", "pouezerez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("vaga"),
            keywords: &["jednakost", "pravda", "uteg", "vaga", "zodijak"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("balança (aparell)"),
            keywords: &[
                "Balança",
                "aparell",
                "balança (aparell)",
                "eina",
                "justícia",
                "pes",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎢᏗᎦᏘᎭ ᏗᎦᏛᏗ"),
            keywords: &[
                "ᎢᎦᏘᎭᎢᏚᏳᎪᏛᎢ",
                "ᎢᏗᎦᏘᎭ",
                "ᎤᏓᎨᏍᏙᏗ",
                "ᎬᏔᏂᏓᏍᏗ",
                "ᏂᏚᏳᎪᏛᎢ",
                "ᏃᏈᏏ ᏓᏟᎶᏍᏗᎲᎢ",
                "ᏗᎦᏛᏗ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("miskové váhy"),
            keywords: &[
                "miskové váhy",
                "nářadí",
                "rovnováha",
                "spravedlnost",
                "váha",
                "zvěrokruh",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("clorian"),
            keywords: &["clorian", "mantol", "offeryn", "pwysau"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("vægt"),
            keywords: &[
                "balance",
                "jura",
                "retfærdighed",
                "stjernetegn",
                "vægt",
                "værktøj",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Waage"),
            keywords: &["Gerechtigkeit", "Gewicht", "Waage", "Werkzeug", "wiegen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ζυγαριά"),
            keywords: &[
                "Ζυγός",
                "δικαιοσύνη",
                "ζυγίζω",
                "ζυγαριά",
                "ζυγός",
                "ζώδιο",
                "ισορροπία",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("balance scale"),
            keywords: &["Libra", "balance", "justice", "scale", "zodiac"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("balanza"),
            keywords: &["balanza", "justicia", "libra", "peso", "zodiaco"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kaalukausid"),
            keywords: &["kaalud", "kaalukausid", "sodiaak", "tööriist"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("balantzak"),
            keywords: &[
                "balantza",
                "balantzak",
                "justizia",
                "libra",
                "oreka",
                "zodiakoa",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ترازو"),
            keywords: &["برج میزان", "ترازو", "زودیاک", "عدالت", "معیار", "وزن"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vaaka"),
            keywords: &[
                "horoskooppi",
                "horoskooppimerkki",
                "oikeus",
                "punnus",
                "työkalu",
                "vaaka",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("timbangan"),
            keywords: &["balanse", "hustisya", "libra", "timbangan", "zodiac"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("vágskál"),
            keywords: &[
                "Vágmerkið",
                "amboð",
                "rættvísi",
                "stjørnumerki",
                "vekt",
                "vágskál",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("balance à poids"),
            keywords: &["balance", "balance à poids", "justice"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["balance", "balance à poids", "zodiaque"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("scála"),
            keywords: &[
                "Libra",
                "ceartas",
                "comthromaíocht",
                "scála",
                "scála cothromaíochta",
                "stoidiaca",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("meidh co-chothromach"),
            keywords: &[
                "acainn",
                "britheamh",
                "cothrom",
                "cuideam",
                "grian-chriosach",
                "inneal",
                "libra",
                "meidh",
                "meidh co-chothromach",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("balanza"),
            keywords: &["Libra", "balanza", "peso", "xustiza", "zodíaco"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("તરાજ\u{ac1}"),
            keywords: &[
                "તરાજ\u{ac1}",
                "ત\u{ac1}લા",
                "ન\u{acd}યાય",
                "માપ",
                "રાશિ",
                "વજન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("sikeli"),
            keywords: &[
                "Libra",
                "adalci",
                "daidaito",
                "kayan aiki",
                "nauyi",
                "sikeli",
                "sikeloli",
                "zodiac",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מאזניים"),
            keywords: &["גלגל המזלות", "מאזניים", "משפט", "משקל", "צדק"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("तराज\u{942}"),
            keywords: &["तराज\u{942}", "त\u{941}ला", "न\u{94d}याय", "राशि"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("vaga"),
            keywords: &["alat", "pravda", "uteg", "vaga", "zodijak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kétkarú mérleg"),
            keywords: &["eszköz", "felszerelés", "kétkarú mérleg", "mérleg", "tömeg"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("նժարավոր կշեռք"),
            keywords: &[
                "արդարություն",
                "գործիք",
                "ծանրություն",
                "կենդանակերպ",
                "կշեռք",
                "հավասարակշռություն",
                "նժարավոր կշեռք",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("timbangan gantung"),
            keywords: &[
                "Libra",
                "imbang",
                "keadilan",
                "timbangan",
                "timbangan gantung",
                "zodiak",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nsialọ nhatanha"),
            keywords: &[
                "arụ",
                "dị ghalii",
                "ikpe nkwụọtọ",
                "ngwaọrụ",
                "nhatanha",
                "nsialọ gasị",
                "nsialọ nhatanha",
                "zodịak",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("vog"),
            keywords: &["jafnréttisvog", "jafnvægi", "vog", "vogarskál"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("bilancia a doppio piatto"),
            keywords: &[
                "bilancia",
                "bilancia a doppio piatto",
                "pesare",
                "piatti della bilancia",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("天秤"),
            keywords: &["はかり", "化学", "天秤", "実験", "星座"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("timbangan"),
            keywords: &["Libra", "adil", "imbang", "palintangan", "timbangan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბერკეტიანი სასწორი"),
            keywords: &[
                "ბერკეტიანი სასწორი",
                "ზოდიაქო",
                "ინსტრუმენტი",
                "სამართლიანობა",
                "სასწორი",
                "წონა",
                "ჰოროსკოპი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("иінтіректі таразы"),
            keywords: &[
                "ауырлық",
                "зодиак",
                "иінтіректі таразы",
                "сот",
                "таразы",
                "тепе-теңдік",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("vægt"),
            keywords: &[
                "balance",
                "jura",
                "retfærdighed",
                "stjernetegn",
                "vægt",
                "værktøj",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ជញ\u{17d2}ជ\u{17b8}ង"),
            keywords: &[
                "ជញ\u{17d2}ជ\u{17b8}ង",
                "ត\u{17bb}ល\u{17d2}យភាព",
                "ថ\u{17d2}ល\u{17b9}ង",
                "យ\u{17bb}ត\u{17d2}ត\u{17b7}ធម\u{17cc}",
                "រាស\u{17b8}ចក\u{17d2}រ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{ccd}ಯಾಲ\u{cc6}ನ\u{ccd}ಸ\u{ccd} ಸ\u{ccd}ಕೇಲ\u{ccd}"),
            keywords: &[
                "ನ\u{ccd}ಯಾಯ",
                "ಪರ\u{cbf}ಕರ",
                "ಬ\u{ccd}ಯಾಲ\u{cc6}ನ\u{ccd}ಸ\u{ccd} ಸ\u{ccd}ಕೇಲ\u{ccd}",
                "ಮಾಪನಗಳು",
                "ಲ\u{cbf}ಂಕ\u{ccd} ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("접시저울"),
            keywords: &["균형", "저울", "접시저울", "정의", "천칭자리"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("तागडी"),
            keywords: &[
                "तागडी",
                "त\u{941}ळरास",
                "न\u{94d}याय",
                "म\u{947}जणी",
                "रास",
                "समतोल",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тараза"),
            keywords: &["адилеттик", "курал", "салмак", "тараза", "тең салмак"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Wo"),
            keywords: &[
                "Apparat",
                "Gewiicht",
                "Gläichgewiicht",
                "Justiz",
                "Riichter",
                "Stärzeechen",
                "Wo",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຕາຊ\u{eb4}ງ"),
            keywords: &[
                "ຊ\u{eb4}ງ",
                "ຕາຊ\u{eb1}\u{ec8}ງ",
                "ຕາຊ\u{eb4}ງ",
                "ສ\u{ebb}ມດ\u{eb8}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("svarstyklės su lėkštėmis"),
            keywords: &[
                "pusiausvyra",
                "svarstyklės",
                "svarstyklės su lėkštėmis",
                "svoris",
                "teisingumas",
                "zodiakas",
                "įrankis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("svari"),
            keywords: &[
                "Svari",
                "līdzsvars",
                "svari",
                "svars",
                "taisnīgums",
                "zodiaks",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ōrite whārite"),
            keywords: &[
                "Libra",
                "poutiriao",
                "taumaha",
                "utauta",
                "whakawā",
                "whārite",
                "ōrite",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("механичка вага"),
            keywords: &["вага", "механичка вага", "рамнотежа", "тежина"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ത\u{d41}ല\u{d3e}സ\u{d4d}"),
            keywords: &[
                "ഉപകരണം",
                "ത\u{d41}ലനം",
                "ത\u{d41}ല\u{d3e}സ\u{d4d}",
                "നീതി",
                "ഭ\u{d3e}രം",
                "ര\u{d3e}ശിചക\u{d4d}രം",
                "ലിബ\u{d4d}ര",
                "സോഡിയ\u{d3e}ക\u{d4d}ക\u{d4d}",
                "സ\u{d4d}\u{200c}കെയിൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("жин"),
            keywords: &["Либра", "жин", "жинлүүр", "зурхай", "тэнцвэр", "шударга ёс"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("तराज\u{942}"),
            keywords: &[
                "तराज\u{942}",
                "त\u{942}ळ राशी",
                "न\u{94d}याय",
                "मापन",
                "राशी",
                "स\u{902}त\u{941}लन",
                "साधन",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("neraca timbang"),
            keywords: &["keadilan", "libra", "neraca timbang", "penimbang", "zodiak"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("miżien"),
            keywords: &[
                "Libra",
                "bilanċ",
                "għodda",
                "miżien",
                "piż",
                "zodjaku",
                "ġustizzja",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ချ\u{102d}န\u{103a}ခ\u{103d}င\u{103a}"),
            keywords: &[
                "ချ\u{102d}န\u{103a}ခ\u{103d}င\u{103a}",
                "ချ\u{102d}န\u{103a}ခ\u{103d}င\u{103a}ည\u{102e}",
                "ဆယ\u{1037}\u{103a}န\u{103e}စ\u{103a}ရာသ\u{102e}ခ\u{103d}င\u{103a}",
                "တ\u{1030}ရာသ\u{102e}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("likearmet skålvekt"),
            keywords: &[
                "Vekten",
                "balanse",
                "likearmet skålvekt",
                "rettferdighet",
                "stjernetegn",
                "vekt",
                "verktøy",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("सन\u{94d}त\u{941}लन स\u{94d}क\u{947}ल"),
            keywords: &[
                "उपकरण",
                "त\u{941}ला",
                "तौल",
                "न\u{94d}याय",
                "राशि",
                "सन\u{94d}त\u{941}लन",
                "स\u{94d}क\u{947}ल",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("weegschaal"),
            keywords: &[
                "Libra",
                "balans",
                "dierenriem",
                "gerechtigheid",
                "weegschaal",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("likearma skålvekt"),
            keywords: &[
                "Vekta",
                "balanse",
                "likearma skålvekt",
                "rettferd",
                "stjerneteiikn",
                "vekt",
                "verktøy",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଭ\u{b3e}ରସ\u{b3e}ମ\u{b4d}ୟ ସ\u{b4d}କେଲ\u{b4d}\u{200c}"),
            keywords: &[
                "ତ\u{b41}ଳ\u{b3e}ର\u{b3e}ଶ\u{b3f}",
                "ନ\u{b3f}କ\u{b3f}ତ\u{b3f}",
                "ନ\u{b4d}ୟ\u{b3e}ୟ",
                "ଭ\u{b3e}ରସ\u{b3e}ମ\u{b4d}ୟ ସ\u{b4d}କେଲ\u{b4d}\u{200c}",
                "ର\u{b3e}ଶ\u{b3f}ଚକ\u{b4d}ର",
                "ସ\u{b4d}କେଲ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਤ\u{a71}ਕੜੀ"),
            keywords: &[
                "ਇਨਸਾਫ",
                "ਔਜ\u{a3c}ਾਰ",
                "ਤ\u{a41}ਲਾ",
                "ਤ\u{a71}ਕੜੀ",
                "ਭਾਰ",
                "ਰਾਸ\u{a3c}ੀ ਚ\u{a71}ਕਰ",
                "ਸਕ\u{a47}ਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("متوازن پیمانہ"),
            keywords: &[
                "انصاف",
                "اوزار",
                "ب\u{64f}رج",
                "ب\u{64f}رج میزان",
                "بھار",
                "تکڑی",
                "متوازن",
                "متوازن پیمانہ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Balans Skel"),
            keywords: &[
                "Balans Skel",
                "Bálans",
                "Jọ\u{301}stis",
                "Líbra",
                "Skel",
                "Zódiak",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("waga szalkowa"),
            keywords: &[
                "ciężar",
                "narzędzie",
                "równowaga",
                "sprawiedliwość",
                "waga",
                "waga szalkowa",
                "ważyć",
                "zodiak",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("متوازن تله"),
            keywords: &["انصاف", "ترازو", "تله", "توازن", "متوازن تله", "مرغومی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("balança"),
            keywords: &[
                "balança",
                "ferramenta",
                "justiça",
                "libra",
                "peso",
                "zodíaco",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("balança (objeto)"),
            keywords: &[
                "balança",
                "balança (objeto)",
                "instrumento",
                "justiça",
                "pesar",
                "zodíaco",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("balanță"),
            keywords: &[
                "balanță",
                "cântar",
                "egalitate",
                "instrument",
                "justiție",
                "zodiac",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-087"),
            keywords: &["E10-087"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("весы"),
            keywords: &[
                "весы",
                "взвешивание",
                "знак зодиака",
                "правосудие",
                "справедливость",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umunzani"),
            keywords: &[
                "Umunzani",
                "igikoresho",
                "iminzani",
                "uburemere",
                "ubutabera",
                "umunzani",
                "zodiyake",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("متوازن ماپو"),
            keywords: &[
                "اوزار",
                "برجر",
                "لبرا",
                "ماپ",
                "متوازن",
                "متوازن ماپو",
                "وزن",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ත\u{dd4}ලන තර\u{dcf}ද\u{dd2}ය"),
            keywords: &[
                "තර\u{dcf}ද\u{dd2}",
                "ත\u{dd4}ලන තර\u{dcf}ද\u{dd2}ය",
                "බර",
                "ර\u{dcf}ශ\u{dd2}ය",
                "ස\u{dcf}ධ\u{dcf}රණත\u{dca}වය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("miskové váhy"),
            keywords: &[
                "hmotnosť",
                "miskové váhy",
                "rovnováha",
                "spravodlivosť",
                "váhy",
                "váženie",
                "zverokruh",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("tehtnica"),
            keywords: &[
                "orodje",
                "pravičnost",
                "ravnovesje",
                "tehtnica",
                "teža",
                "zodiak",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("miisaan"),
            keywords: &["cadaalad", "halbeega Libra", "miisaan", "misaan", "qiyaase"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("peshore"),
            keywords: &["drejtësi", "ekuilibër", "peshore", "peshë", "zodiak"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("теразије"),
            keywords: &["вага", "зодијак", "правда", "равнотежа", "тег", "теразије"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["теразије"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("terazije"),
            keywords: &["pravda", "ravnoteža", "teg", "terazije", "vaga", "zodijak"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["terazije"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("balansvåg"),
            keywords: &["balansvåg", "rättvisa", "våg", "vågen"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mzani"),
            keywords: &[
                "haki", "mizani", "mzani", "pima", "uzito", "zana", "zodiaki",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("தர\u{bbe}சு"),
            keywords: &[
                "அளவிடுதல\u{bcd}",
                "எடை",
                "எடை போடுதல\u{bcd}",
                "தர\u{bbe}சு",
                "துல\u{bbe}ம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("తక\u{c4d}క\u{c46}డ"),
            keywords: &[
                "క\u{c4a}లత",
                "తక\u{c4d}క\u{c46}డ",
                "త\u{c4d}ర\u{c3e}సు",
                "సమ\u{c3e}నం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тарозу"),
            keywords: &[
                "Мизон",
                "адолат",
                "асбоб",
                "бурҷи дувоздаҳгона",
                "вазн",
                "тавозун",
                "тарозу",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ตราช\u{e31}\u{e48}ง"),
            keywords: &[
                "ตราช\u{e31}\u{e48}ง",
                "ต\u{e38}ลย\u{e4c}",
                "น\u{e49}ำหน\u{e31}ก",
                "ย\u{e38}ต\u{e34}ธรรม",
                "ราศ\u{e35}",
                "สมด\u{e38}ล",
                "เคร\u{e37}\u{e48}องม\u{e37}อ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("deňagramlylyk terezisi"),
            keywords: &[
                "Terezi",
                "adalat",
                "deňagramlylyk",
                "deňagramlylyk terezisi",
                "täleýnama",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻa fuamamafa"),
            keywords: &["meʻa fuamamafa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("terazi"),
            keywords: &[
                "adalet",
                "alet",
                "ağırlık",
                "burç",
                "denge",
                "terazi",
                "ölçek",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تەڭپۇڭلۇق ئۆلچىگۈچ"),
            keywords: &[
                "ئۆلچەم",
                "ئېغىرلىق",
                "تەڭلىك",
                "تەڭپۇڭ",
                "تەڭپۇڭلۇق ئۆلچىگۈچ",
                "قورال",
                "مۆچەل",
                "چەل",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("ваги"),
            keywords: &[
                "вага",
                "ваги",
                "знаряддя",
                "зодіак",
                "рівновага",
                "справедливість",
                "терези",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("برابر پلڑوں والا ترازو"),
            keywords: &["آلہ", "برابر", "برابر پلڑوں والا ترازو", "ترازو", "پلڑے"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tarozi"),
            keywords: &["Tarozi", "adolat", "burj", "muvozanat", "oʻlchov", "tarozi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cân thăng bằng"),
            keywords: &[
                "Thiên Bình",
                "cung hoàng đạo",
                "cân",
                "cân thăng bằng",
                "công lý",
                "thăng bằng",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("balaasu peesekaay"),
            keywords: &[
                "balaas",
                "balaasu peesekaay",
                "jumtukaay",
                "peese",
                "sojak",
                "yoon",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iskali sokulinganisa"),
            keywords: &[
                "i-Libra",
                "i-zodiac",
                "ibhalansi",
                "isixhobo",
                "iskali sokulinganisa",
                "izikali",
                "okusesikweni",
                "ubunzima",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ìwọ\u{300}ntúnwọ\u{300}nsí síkélì"),
            keywords: &[
                "líbérà",
                "síkélì",
                "àmi oṣù ìbí",
                "ìdájọ\u{301}",
                "ìwọ\u{300}n",
                "ìwọ\u{300}ntúnwọ\u{300}nsí",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("天秤"),
            keywords: &["天秤", "天秤座", "工具", "星座", "正義", "秤", "重量"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("天秤"),
            keywords: &["天秤", "天秤座", "工具", "星座", "正义", "秤", "重量"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("天平"),
            keywords: &["公平", "公正", "天平", "正义", "法律"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("天平"),
            keywords: &["天平"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("天秤"),
            keywords: &["天秤", "平衡｜公正", "秤"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("okokulinganisa"),
            keywords: &[
                "inkanyezi",
                "isisindo",
                "ithuluzi",
                "iziklali",
                "libra",
                "okokulinganisa",
                "ubulungiswa",
                "ukulingana",
            ],
        },
    ],
};
#[doc = "🦯"]
pub const WHITE_CANE: crate::Emoji = crate::Emoji {
    glyph: "🦯",
    codepoint: "1F9AF",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "white cane",
    group: "Objects",
    subgroup: "tool",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gidsstok"),
            keywords: &["blind", "gidsstok", "toeganklikheid"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ከዘራ"),
            keywords: &["ተደራሽነት", "እውር", "ከዘራ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("عصا سير"),
            keywords: &["أعمى", "إمكانية الوصول", "احتياجات خاصة", "عصا سير", "كفيف"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9cd}ৰ’বিং কেন"),
            keywords: &["অন\u{9cd}ধ", "দিব\u{9cd}য\u{9be}ংগ", "প\u{9cd}ৰ’বিং কেন"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("zond"),
            keywords: &["kor", "zond", "əlverişlilik"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("палка"),
            keywords: &["даступнасць", "палка", "сляпы"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("бял бастун"),
            keywords: &["бял бастун", "достъпна среда", "незрящ"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ল\u{9be}ঠি"),
            keywords: &[
                "অন\u{9cd}ধ",
                "অ\u{9cd}য\u{9be}ক\u{9cd}সেসিবিলিটি",
                "ল\u{9be}ঠি",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("štap za slabovidne i slijepe"),
            keywords: &["pomagalo", "slijepi", "štap za slabovidne i slijepe"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bastó per a invidents"),
            keywords: &["accessibilitat", "bastó per a invidents", "invident"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎨᏫ ᎦᏅᏍᏓ ᎬᏙᏗ"),
            keywords: &["ᎬᏴᏍᏗ ᎨᏒᎢ", "ᏗᎨᏫ", "ᏗᎨᏫ ᎦᏅᏍᏓ ᎬᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("slepecká hůl"),
            keywords: &[
                "handicap",
                "hendikep",
                "pomůcka",
                "postižení",
                "slepec",
                "slepecká hůl",
                "slepý",
                "usnadnění",
                "zpřístupnění",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ffon wen"),
            keywords: &["dall", "ffon wen", "hygyrchedd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("blindestok"),
            keywords: &["blind", "blindestok", "handicap"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Blindenstock"),
            keywords: &["Barrierefreiheit", "Blindenstock", "blind"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μπαστούνι τυφλών"),
            keywords: &["μπαστούνι τυφλών", "προσβασιμότητα", "τυφλός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("white cane"),
            keywords: &["accessibility", "blind", "white cane"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("guide cane"),
            keywords: &["guide cane"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("long mobility cane"),
            keywords: &["accessibility", "long mobility cane", "white cane"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("guide cane"),
            keywords: &["accessibility", "blind", "guide cane"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bastón"),
            keywords: &[
                "accesibilidad",
                "bastón",
                "ceguera",
                "ciega",
                "ciego",
                "invidente",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["accesibilidad", "bastón", "ceguera", "invidente"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("bastón blanco"),
            keywords: &["accesibilidad", "bastón", "blanco", "ciego", "invidente"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("valge kepp"),
            keywords: &["kohalejõudmine", "ligipääs", "pime", "valge kepp"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("makila"),
            keywords: &["irisgarritasun", "itsu", "makila"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("عصای سفید"),
            keywords: &["دسترس\u{200c}پذیری", "عصای سفید", "نابینا"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("valkoinen keppi"),
            keywords: &["esteettömyys", "sokea", "valkoinen keppi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("baston"),
            keywords: &["baston", "bulag", "pagiging naa-access"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("blindastavur"),
            keywords: &[
                "blind",
                "blindastavur",
                "blindur",
                "brek",
                "handikapp",
                "stavur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("canne blanche"),
            keywords: &[
                "accessibilité",
                "aveugle",
                "canne blanche",
                "déficient visuel",
                "malvoyant",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cána bán"),
            keywords: &["cána", "cána bán", "dall", "inrochtaineacht"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("batachan"),
            keywords: &["batachan", "dall", "doille", "so-ruigsinneachd"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("bastón guía"),
            keywords: &["bastón guía", "cegueira", "discapacidade"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("તપાસ માટ\u{ac7}ની લાકડી"),
            keywords: &[
                "ઍક\u{acd}સ\u{ac7}સિબિલિટી",
                "તપાસ માટ\u{ac7}ની લાકડી",
                "દિવ\u{acd}યા\u{a82}ગ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מקל נחייה"),
            keywords: &["מקל נחייה", "נגישות", "עיוור"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("न\u{947}त\u{94d}रहीन की छड\u{93c}ी"),
            keywords: &[
                "अ\u{902}धा",
                "अ\u{902}धी",
                "छड\u{93c}ी",
                "न\u{947}त\u{94d}रहीन",
                "न\u{947}त\u{94d}रहीन की छड\u{93c}ी",
                "लाठी",
                "सहायता",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("bijeli štap"),
            keywords: &["bijeli štap", "pomagalo", "sljepoća"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fehér bot"),
            keywords: &["akadálymentesség", "fehér bot", "vak"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ձեռնափայտ"),
            keywords: &["կույր", "հաշմանդամ", "ձեռնափայտ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tongkat tunanetra"),
            keywords: &["aksesibilitas", "buta", "tongkat tunanetra", "tunanetra"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("blindrastafur"),
            keywords: &["aðgengi", "blindrastafur", "blindur", "sjónlaus"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("bastone per non vedenti"),
            keywords: &[
                "accessibilità",
                "bastone bianco",
                "bastone per ipovedenti",
                "bastone per non vedenti",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("白杖"),
            keywords: &["つえ", "アクセシビリティ", "白杖", "視覚", "障がい"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("teken"),
            keywords: &["kalancaran", "teken", "wuta"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("თეთრი ჯოხი"),
            keywords: &["თეთრი ჯოხი", "უსინათლო", "უსინათლოთა ჯოხი", "შშმ პირი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("таяқ"),
            keywords: &["мүмкіндігі шектеулі", "соқыр", "таяқ"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ឈើច\u{17d2}រត\u{17cb}ជនព\u{17b7}ការ"),
            keywords: &[
                "ខ\u{17d2}វាក\u{17cb}",
                "ឈើច\u{17d2}រត\u{17cb}ជនព\u{17b7}ការ",
                "ភាពងាយស\u{17d2}រ\u{17bd}ល",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಊರುಗೋಲು"),
            keywords: &["ಊರುಗೋಲು", "ಕುರುಡು", "ಪ\u{ccd}ರವೇಶ\u{cbf}ಸುವ\u{cbf}ಕ\u{cc6}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("시각장애인 지팡이"),
            keywords: &["시각장애", "시각장애인 지팡이", "접근성", "지팡이"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("प\u{94d}रोबि\u{902}ग क\u{947}न"),
            keywords: &[
                "ऍक\u{94d}स\u{945}सिबिलिटी",
                "क\u{941}ड\u{94d}ड\u{947}",
                "प\u{94d}रोबि\u{902}ग क\u{947}न",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("зонд таягы"),
            keywords: &["атайын мүмкүндүк", "зонд таягы", "сокур"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໄມ\u{ec9}\u{200b}ຄ\u{eb1}ນ\u{200b}ເທ\u{ebb}\u{ec9}າ\u{200b}ນຳ\u{200b}ທາງ"),
            keywords: &[
                "ຄວາມ\u{200b}ສາ\u{200b}ມາດ\u{200b}ເຂ\u{ebb}\u{ec9}າ\u{200b}ເຖ\u{eb4}ງ",
                "ຕາ\u{200b}ບອດ",
                "ໄມ\u{ec9}\u{200b}ຄ\u{eb1}ນ\u{200b}ເທ\u{ebb}\u{ec9}າ\u{200b}ນຳ\u{200b}ທາງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("neregio lazda"),
            keywords: &["aklas", "neregio lazda", "prieinamumas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("baltais atbalsta spieķis"),
            keywords: &["akls", "baltais atbalsta spieķis", "pieejamība"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("стап за слепи"),
            keywords: &["пристапност", "слеп", "стап за слепи"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d4d}രോബിംഗ\u{d4d} ക\u{d3e}ൻ"),
            keywords: &[
                "അന\u{d4d}ധൻ",
                "ആക\u{d4d}\u{200c}സസബിലിറ\u{d4d}റി",
                "പ\u{d4d}രോബിംഗ\u{d4d} ക\u{d3e}ൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хараагүй хүний таяг"),
            keywords: &[
                "хараагүй хүн",
                "хараагүй хүний таяг",
                "хүртээмжтэй байдал",
                "цагаан таяг",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("अ\u{902}धा\u{902}ची काठी"),
            keywords: &[
                "अ\u{902}धा\u{902}ची काठी",
                "अ\u{945}क\u{94d}स\u{947}सिबिलिटी",
                "दिव\u{94d}या\u{902}ग",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tongkat penduga"),
            keywords: &["buta", "kebolehcapaian", "tongkat penduga"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တ\u{102f}တ\u{103a}ကောက\u{103a}"),
            keywords: &[
                "တ\u{102f}တ\u{103a}ကောက\u{103a}",
                "မျက\u{103a}မမြင\u{103a}",
                "အများသ\u{102f}\u{1036}းစ\u{103d}\u{1032}န\u{102d}\u{102f}င\u{103a}မ\u{103e}\u{102f}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("blindestokk"),
            keywords: &["blind", "blindestokk", "tilgjengelighet"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{94d}रोबिङ क\u{947}न"),
            keywords: &["अन\u{94d}धो", "उपलब\u{94d}धता", "प\u{94d}रोबिङ क\u{947}न"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("taststok"),
            keywords: &["blind", "taststok", "toegankelijkheid"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("blindestokk"),
            keywords: &["blind", "blindestokk", "tilgjenge"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଅନ\u{b4d}ଧ ବ\u{b3e}ଡ\u{b3c}\u{b3f}"),
            keywords: &[
                "ଅନ\u{b4d}ଧ",
                "ଅନ\u{b4d}ଧ ବ\u{b3e}ଡ\u{b3c}\u{b3f}",
                "ଅଭ\u{b3f}ଗମ\u{b4d}ୟତ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਟਟ\u{a4b}ਲਣ ਲਈ ਸ\u{a4b}ਟੀ"),
            keywords: &[
                "ਟਟ\u{a4b}ਲਣ ਲਈ ਸ\u{a4b}ਟੀ",
                "ਨ\u{a47}ਤਰਹੀਣ",
                "ਪਹ\u{a41}\u{a70}ਚਯ\u{a4b}ਗਤਾ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Waít Stik"),
            keywords: &["Blaind", "Waít Stik", "Waít Wọkin Stik", "Ízí To Yuz"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("biała laska"),
            keywords: &["biała laska", "dostępność", "niewidomy"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د معلولينو همسا"),
            keywords: &["د معلولينو همسا", "لاسرسی", "ړوند"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bengala para cegos"),
            keywords: &["acessibilidade", "bengala para cegos", "cegueira"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("bengala para invisuais"),
            keywords: &["acessibilidade", "bengala para invisuais", "invisual"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("baston pentru nevăzători"),
            keywords: &[
                "accesibilitate",
                "baston pentru nevăzători",
                "nevăzător",
                "orb",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–035"),
            keywords: &["E12–035"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("белая трость"),
            keywords: &[
                "белая",
                "белая трость",
                "инвалид",
                "палка",
                "слепой",
                "ходьба",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پروبنگ ڪين"),
            keywords: &["انڌو", "رسائي پذيري", "پروبنگ ڪين"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඒෂණ දණ\u{dca}ඩ"),
            keywords: &[
                "අන\u{dca}ධ",
                "ඒෂණ දණ\u{dca}ඩ",
                "ළඟ\u{dcf}ව\u{dd2}ය හැක\u{dd2} බව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("slepecká palica"),
            keywords: &[
                "handicap",
                "hendikep",
                "nevidiaci",
                "postihnutie",
                "slepec",
                "slepecká palica",
                "slepý",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("palica za slepe"),
            keywords: &["invalid", "palica za slepe", "slepota"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("usha cad indhoolaha"),
            keywords: &["awood u yeelid", "indhoole", "usha cad indhoolaha"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shkop gjurmimi"),
            keywords: &["i verbër", "qasshmëri", "shkop gjurmimi"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("бели штап"),
            keywords: &["бели штап", "доступност", "слеп"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("бијели штап"),
            keywords: &["бијели штап"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("beli štap"),
            keywords: &["beli štap", "dostupnost", "slep"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("bijeli štap"),
            keywords: &["bijeli štap"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("blindkäpp"),
            keywords: &["blind", "blindkäpp", "tillgänglighet"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mkongojo wa vipofu"),
            keywords: &["kipofu", "mkongojo wa vipofu", "ufikivu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கைத\u{bcd}தடி"),
            keywords: &["கைத\u{bcd}தடி", "ப\u{bbe}ர\u{bcd}வையற\u{bcd}றோர\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c4d}ర\u{c4b}బ\u{c3f}ంగ\u{c4d} క\u{c47}న\u{c4d}"),
            keywords: &[
                "అంధత\u{c4d}వం",
                "ప\u{c4d}ర\u{c4b}బ\u{c3f}ంగ\u{c4d} క\u{c47}న\u{c4d}",
                "స\u{c4c}లభ\u{c4d}యం",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ไม\u{e49}เท\u{e49}านำทาง"),
            keywords: &[
                "การเข\u{e49}าถ\u{e36}ง",
                "ตาบอด",
                "ไม\u{e49}เท\u{e49}านำทาง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ak hasa"),
            keywords: &["ak hasa", "elýeterlilik", "kör"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tokotoko fakaʻeke"),
            keywords: &["tokotoko fakaʻeke"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("görme engelli bastonu"),
            keywords: &["erişilebilirlik", "görme engelli", "görme engelli bastonu"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("тактильна тростина"),
            keywords: &[
                "доступність",
                "незрячі",
                "сліпота",
                "спеціальні засоби",
                "тактильна тростина",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("نابینا افراد کیلئے چھڑی"),
            keywords: &["دسترس", "نابینا", "نابینا افراد کیلئے چھڑی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("hassa"),
            keywords: &["hassa", "koʻr", "nogironlik"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("gậy dò đường"),
            keywords: &["gậy dò đường", "hỗ trợ tiếp cận", "khiếm thị", "mù"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("探測拐杖"),
            keywords: &["探測拐杖", "無障礙", "盲"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("探测拐杖"),
            keywords: &["探测拐杖", "无障碍", "盲"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("盲杖"),
            keywords: &["拐杖", "无障碍", "盲", "盲杖"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("導盲手杖"),
            keywords: &["導盲手杖", "盲人", "行動不便"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("導盲拐杖"),
            keywords: &["導盲拐杖", "無障礙｜盲人｜視障"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ikheni yokusiza"),
            keywords: &["ikheni yokusiza", "ukufinyelela", "ukuphophala"],
        },
    ],
};
#[doc = "🔗"]
pub const LINK: crate::Emoji = crate::Emoji {
    glyph: "🔗",
    codepoint: "1F517",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "link",
    group: "Objects",
    subgroup: "tool",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("skakel"),
            keywords: &["skakel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ማገናኛ"),
            keywords: &["ማገናኛ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("علامة رابط"),
            keywords: &["حلقتان", "روابط", "علامة رابط"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("শিকলিৰ আঙ\u{9c1}ঠি"),
            keywords: &["শিকলিৰ আঙ\u{9c1}ঠি"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("zəncir"),
            keywords: &["zəncir"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("злучаныя звёны"),
            keywords: &["злучаныя звёны", "ланцуг", "сувязь"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("връзка"),
            keywords: &["връзка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("লিঙ\u{9cd}ক"),
            keywords: &["লিংক", "লিঙ\u{9cd}ক"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("mailh"),
            keywords: &["ailhedenn", "lagadenn", "mailh", "mailhon", "mell"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("karika"),
            keywords: &["karika"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("enllaç"),
            keywords: &["enllaç", "enllaçar"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎫᏓᎸᏙᏗ"),
            keywords: &["ᎫᏓᎸᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("články řetězu"),
            keywords: &["spojení", "článek", "články řetězu", "řetěz"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dolen"),
            keywords: &["dolen", "linc"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("link"),
            keywords: &["link", "link-tegn"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Verknüpfungssymbol"),
            keywords: &["Kettenglieder", "Verknüpfungssymbol", "zwei Ringe"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κρίκος"),
            keywords: &["κρίκος", "σύνδεσμος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("link"),
            keywords: &["link"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("eslabón"),
            keywords: &["eslabón"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("eslabones de cadena"),
            keywords: &[
                "cadena",
                "enlace",
                "eslabones",
                "eslabones de cadena",
                "vínculo",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("lüli"),
            keywords: &["lüli"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kate-maila"),
            keywords: &["kate-maila"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("حلقه\u{654} زنجیر"),
            keywords: &[
                "اتصال",
                "حلقه",
                "حلقه\u{654} زنجیر",
                "دانه زنجیر",
                "دانه\u{654} زنجیر",
                "پیوند",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("lenkki"),
            keywords: &["ketju", "lenkki"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kawing"),
            keywords: &["kadena", "kawing"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("liður"),
            keywords: &[
                "leinkja",
                "liður",
                "samband",
                "sambinding",
                "sambindingarliður",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("chaînons"),
            keywords: &["chaînons", "maillons"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("chaînons"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("nasc"),
            keywords: &["nasc"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ceangal"),
            keywords: &["bun-dùirn", "ceangal", "ceangal-dùirn", "lùb"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("elo"),
            keywords: &["cadea", "elo", "ligazón"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લિ\u{a82}ક"),
            keywords: &[
                "બ\u{ac7} રિ\u{a82}ગ\u{acd}સ",
                "લિ\u{a82}ક",
                "લિ\u{a82}કન\u{ac1}\u{a82} ચિહ\u{acd}ન",
                "લિ\u{a82}ક\u{acd}સ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mahaɗa"),
            keywords: &["mahaɗa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חוליות משולבות"),
            keywords: &["חוליות", "חוליות משולבות", "קישור", "שילוב"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("कड\u{93c}ी"),
            keywords: &["कड\u{93c}ी", "लि\u{902}क"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("karika"),
            keywords: &["karika", "veza"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kapocs"),
            keywords: &["kapocs", "láncszem"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("օղակ"),
            keywords: &["օղակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tautan"),
            keywords: &["tautan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("njikọ"),
            keywords: &["njikọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("tenglamerki"),
            keywords: &["tenglamerki", "tenglar", "tveir hlekkir"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("collegamento"),
            keywords: &["collegamento", "due anelli", "link", "simbolo link"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("リンクシンボル"),
            keywords: &["リンク", "リンクシンボル"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sambungan rante"),
            keywords: &["sambungan rante"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჯაჭვის რგოლი"),
            keywords: &["რგოლი", "ჯაჭვის რგოლი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("aseɣwen"),
            keywords: &["aseɣwen"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шынжыр"),
            keywords: &["шынжыр"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("link"),
            keywords: &["link", "link-tegn"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ត\u{17c6}ណ"),
            keywords: &["ត\u{17c6}ណ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಲ\u{cbf}ಂಕ\u{ccd}"),
            keywords: &["ಲ\u{cbf}ಂಕ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("링크"),
            keywords: &["링크", "링크 표시"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("लि\u{902}क"),
            keywords: &["लि\u{902}क"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тогоо"),
            keywords: &["илмек", "тогоо"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Glidd"),
            keywords: &["Glidd"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຂ\u{ecd}\u{ec9}ຕ\u{ecd}\u{ec8}"),
            keywords: &["ຂ\u{ecd}\u{ec9}ຕ\u{ecd}\u{ec8}", "ລ\u{eb4}\u{ec9}ງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("jungtis"),
            keywords: &["jungtis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ķēdes posms"),
            keywords: &["ķēde", "ķēdes posms"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("hononga"),
            keywords: &["hononga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("алка"),
            keywords: &["алка", "спојница"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ലിങ\u{d4d}ക\u{d4d}"),
            keywords: &[
                "ലിങ\u{d4d}ക\u{d4d}",
                "ലിങ\u{d4d}ക\u{d4d} ചിഹ\u{d4d}നം",
                "സിംബൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гогцоо"),
            keywords: &["гогцоо"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("साखळी"),
            keywords: &["साखळी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pautan"),
            keywords: &["pautan", "rantai"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("katina"),
            keywords: &["katina"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ချ\u{102d}တ\u{103a}"),
            keywords: &["ချ\u{102d}တ\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("lenke"),
            keywords: &["lenke", "link", "to ringer"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("लि\u{902}क"),
            keywords: &["लि\u{902}क"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("schakels"),
            keywords: &["schakels", "twee ringen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("lenkje"),
            keywords: &["lenkje", "link", "to ringar"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଲ\u{b3f}ଙ\u{b4d}କ\u{b4d}\u{200c}"),
            keywords: &[
                "ଦ\u{b41}ଇଟ\u{b3f} ର\u{b3f}ଂ",
                "ଲ\u{b3f}ଙ\u{b4d}କ\u{b4d} ଚ\u{b3f}ହ\u{b4d}ନ",
                "ଲ\u{b3f}ଙ\u{b4d}କ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲਿ\u{a70}ਕ"),
            keywords: &[
                "ਦ\u{a4b} ਕੜ\u{a47}",
                "ਲਿ\u{a70}ਕ",
                "ਲਿ\u{a70}ਕ ਨਿਸ\u{a3c}ਾਨ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ربط کرو"),
            keywords: &["ربط کرو"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Link"),
            keywords: &["Link"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("ogniwa"),
            keywords: &["hiperłącze", "link", "ogniwa", "ogniwo", "połączenie"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ربط"),
            keywords: &["ربط"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("link"),
            keywords: &["corrente", "link"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("ligação"),
            keywords: &["corrente", "ligação"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("za"),
            keywords: &["conexiune", "legătură", "link", "verigă", "za"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-723"),
            keywords: &["E10-723"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("гиперссылка"),
            keywords: &["гиперссылка", "звенья", "связывание", "связь", "ссылка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ihuza"),
            keywords: &["ihuza"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪڙي"),
            keywords: &["ڪڙي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ග\u{dcf}න\u{dca}ච\u{dd4}ව"),
            keywords: &["ග\u{dcf}න\u{dca}ච\u{dd4}ව"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("spojovací článok"),
            keywords: &["odkaz", "prepojenie", "spojenie", "spojovací článok"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("člen"),
            keywords: &["člen"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("liinki"),
            keywords: &["liinki"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("lidh"),
            keywords: &["lidh", "zinxhir"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("карике"),
            keywords: &["карике"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["карике"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("karike"),
            keywords: &["karike"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["karike"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("länk"),
            keywords: &["länk", "länkar", "länksymbol", "två ringar"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("pete ya mnyororo"),
            keywords: &["pete", "pete ya mnyororo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("இரு வளையங\u{bcd}கள\u{bcd}"),
            keywords: &[
                "இணை",
                "இரு வளையங\u{bcd}கள\u{bcd}",
                "கட\u{bcd}டு",
                "சேர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ల\u{c3f}ంకు"),
            keywords: &["అభ\u{c47}ద\u{c4d}యమ\u{c48}న", "కలయ\u{c3f}క", "ల\u{c3f}ంకు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("пайванд"),
            keywords: &["пайванд"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ส\u{e31}ญล\u{e31}กษณ\u{e4c}การล\u{e34}งก\u{e4c}"),
            keywords: &[
                "ล\u{e34}งก\u{e4c}",
                "ส\u{e31}ญล\u{e31}กษณ\u{e4c}การล\u{e34}งก\u{e4c}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("bag"),
            keywords: &["bag"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kupu"),
            keywords: &["kupu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("bağlantı işareti"),
            keywords: &["bağlantı işareti", "bağlantılar", "iki halka"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئۇلانما"),
            keywords: &["ئۇلانما"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("символ зʼєднання ланок"),
            keywords: &["ланка", "посилання", "символ зʼєднання ланок"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("لنک"),
            keywords: &["تالا", "جوڑ", "رابطہ", "لنک"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("havola"),
            keywords: &["havol", "havola"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mắt xích"),
            keywords: &["mắt xích"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("lëkkalekaay"),
            keywords: &["lëkkalekaay"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ikhonkco"),
            keywords: &["ikhonkco"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ìtọ\u{301}kasí"),
            keywords: &["ìtọ\u{301}kasí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("連結"),
            keywords: &["連結"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("连结"),
            keywords: &["连结"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("链接"),
            keywords: &["网址", "链接", "链条", "锁链"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("連結"),
            keywords: &["連結", "鏈結"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["連結"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukuxhumanisa"),
            keywords: &["ukuxhumanisa"],
        },
    ],
};
#[doc = "⛓\u{fe0f}"]
pub const CHAINS: crate::Emoji = crate::Emoji {
    glyph: "⛓\u{fe0f}",
    codepoint: "26D3 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "chains",
    group: "Objects",
    subgroup: "tool",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "⛓",
        codepoint: "26D3",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "chains",
        group: "Objects",
        subgroup: "tool",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kettings"),
            keywords: &["ketting", "kettings", "skakel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሰንሰለቶች"),
            keywords: &["ሰንሰለት", "ሰንሰለቶች"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سلاسل"),
            keywords: &["سلاسل", "سلسلة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("শিকলি"),
            keywords: &["শিকলি", "শিকলিবিল\u{9be}ক"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("zəncirlər"),
            keywords: &["zəncir", "zəncirlər"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ланцугі"),
            keywords: &["ланцуг", "ланцугі"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("вериги"),
            keywords: &["верига", "вериги"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চেন"),
            keywords: &["চেন", "শ\u{9c3}ঙ\u{9cd}খল"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("chadennoù"),
            keywords: &["chadenn", "chadennoù"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("lanci"),
            keywords: &["lanac", "lanci"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cadenes"),
            keywords: &["cadena", "cadenes"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏧᎾᏓᏕᏒᏗ"),
            keywords: &["ᎤᎾᏓᏕᏒᏗ", "ᏧᎾᏓᏕᏒᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("řetězy"),
            keywords: &["řetěz", "řetězy"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cadwyni"),
            keywords: &["cadwyn", "cadwyni"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kæder"),
            keywords: &["kæde", "kæder"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Ketten"),
            keywords: &["Eisen", "Kette", "Ketten"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αλυσίδες"),
            keywords: &["αλυσίδα", "αλυσίδες"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("chains"),
            keywords: &["chain", "chains"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cadenas"),
            keywords: &["cadena", "cadenas"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("ahelad"),
            keywords: &["ahel", "ahelad", "kett"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kateak"),
            keywords: &["kate", "kateak"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("غل و زنجیر"),
            keywords: &["زنجیر", "زنجیرها", "غل", "غل و زنجیر", "قیدوبند"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ketjut"),
            keywords: &["ketju", "ketjut"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kadena"),
            keywords: &["kadena"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("keta"),
            keywords: &[
                "keta",
                "leinkja",
                "liður",
                "samband",
                "sambinding",
                "sambindingarliður",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("chaînes"),
            keywords: &["chaîne", "chaînes"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("slabhraí"),
            keywords: &["slabhra", "slabhraí"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sèineachan"),
            keywords: &["sèine", "sèineachan"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cadeas"),
            keywords: &["cadea", "cadeas"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સા\u{a82}કળ"),
            keywords: &["સા\u{a82}કળ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("sarƙoƙi"),
            keywords: &["sarƙa", "sarƙoƙi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שרשראות"),
            keywords: &["שרשראות", "שרשרת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ज\u{93c}\u{902}जीर"),
            keywords: &["ज\u{93c}\u{902}जीर", "श\u{943}\u{902}खला"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lanci"),
            keywords: &["lanac", "lanci"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("lánc"),
            keywords: &["lánc", "láncszemek"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("շղթաներ"),
            keywords: &["շղթա", "շղթաներ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("rantai"),
            keywords: &["rantai"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("agbụ igwe gasị"),
            keywords: &["agbụ igwe", "agbụ igwe gasị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("keðja"),
            keywords: &["keðja"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("catene"),
            keywords: &["catene", "imprigionare", "incatenare"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("鎖"),
            keywords: &["くさり", "チェーン", "鎖"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rante"),
            keywords: &["rante"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჯაჭვი"),
            keywords: &["ჯაჭვი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тізбек"),
            keywords: &["бізбек", "тізбек"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kæder"),
            keywords: &["kæde", "kæder"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ច\u{17d2}រវាក\u{17cb}"),
            keywords: &["ច\u{17d2}រវាក\u{17cb}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಚೈನು\u{200c}ಗಳು"),
            keywords: &["ಚೈನು\u{200c}ಗಳು", "ಚೈನ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("쇠사슬"),
            keywords: &["사슬", "쇠사슬", "체인"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("साखळ\u{94d}यो"),
            keywords: &["साखळी", "साखळ\u{94d}यो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чынжыр"),
            keywords: &["чынжыр"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Ketten"),
            keywords: &["Ketten"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໂສ\u{ec9}"),
            keywords: &["ໂສ\u{ec9}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("grandinės"),
            keywords: &["grandinė", "grandinės"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ķēdes"),
            keywords: &["ķēde", "ķēdes"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ngā mekameka"),
            keywords: &["mekameka", "ngā mekameka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("синџири"),
            keywords: &["синџир", "синџири"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ചെയിൻ"),
            keywords: &["ചങ\u{d4d}ങല", "ചെയിൻ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гинж"),
            keywords: &["гинж", "гинжин хэлхээ"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("च\u{947}न"),
            keywords: &["च\u{947}न"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("rantai"),
            keywords: &["rantai", "rantaian"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ktajjen"),
            keywords: &["katina", "ktajjen"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ချ\u{102d}န\u{103a}းကြ\u{102d}\u{102f}း"),
            keywords: &["ချ\u{102d}န\u{103a}းကြ\u{102d}\u{102f}း"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kjetting"),
            keywords: &["kjede", "kjetting"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("च\u{947}न"),
            keywords: &["च\u{947}न"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kettingen"),
            keywords: &["ketting", "kettingen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kjetting"),
            keywords: &["kjede", "kjetting"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଚେନ\u{b4d}\u{200c}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ"),
            keywords: &[
                "ଚେନ\u{b4d}\u{200c}",
                "ଚେନ\u{b4d}\u{200c}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜ\u{a3c}\u{a70}ਜੀਰ"),
            keywords: &["ਚ\u{a47}ਨ", "ਜ\u{a3c}\u{a70}ਜੀਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("زنجیراں"),
            keywords: &["زنجیر", "زنجیراں"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Chen-dẹm"),
            keywords: &["Chen", "Chen-dẹm"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("łańcuchy"),
            keywords: &["ogniwa", "łańcuch", "łańcuchy"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("زنځيرونه"),
            keywords: &["زنځير", "زنځيرونه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("correntes"),
            keywords: &["corrente", "correntes"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("correntes"),
            keywords: &["corrente", "correntes"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("lanț"),
            keywords: &["lanț", "lanțuri", "zale"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-106"),
            keywords: &["E10-106"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("цепь"),
            keywords: &["звенья", "цепочка", "цепь"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umunyururu"),
            keywords: &["umunyururu", "uruhererekane"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("زنجير"),
            keywords: &["زنجير"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("දම\u{dca}වැල\u{dca}"),
            keywords: &["දම\u{dca}වැල", "දම\u{dca}වැල\u{dca}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("reťaz"),
            keywords: &["reťaz", "reťaze"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("verige"),
            keywords: &["veriga", "verige"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("silsilado"),
            keywords: &["silsilad", "silsilado"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("zinxhirë"),
            keywords: &["zinxhir", "zinxhirë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("ланци"),
            keywords: &["лaнaц", "ланци"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lanci"),
            keywords: &["lanac", "lanci"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kedjor"),
            keywords: &["kedja", "kedjor"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("minyororo"),
            keywords: &["minyororo", "mnyororo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சங\u{bcd}கிலிகள\u{bcd}"),
            keywords: &["சங\u{bcd}கிலி", "சங\u{bcd}கிலிகள\u{bcd}", "செயின\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("గ\u{c4a}లుసులు"),
            keywords: &["గ\u{c4a}లుసు", "గ\u{c4a}లుసులు", "చ\u{c46}య\u{c3f}న\u{c4d}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("занҷирҳо"),
            keywords: &["занҷир", "занҷирҳо"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("โซ\u{e48}"),
            keywords: &["โซ\u{e48}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("zynjyrlar"),
            keywords: &["zynjyr", "zynjyrlar"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sēini"),
            keywords: &["sēini"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("zincir"),
            keywords: &["zincir"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("زەنجىرلەر"),
            keywords: &["زەنجىر", "زەنجىرلەر"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("ланцюги"),
            keywords: &["ланцюг", "ланцюги"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("زنجیریں"),
            keywords: &["آلہ", "زنجیر", "زنجیریں"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("zanjirlar"),
            keywords: &["zanjir", "zanjirlar"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("dây xích"),
            keywords: &["dây xích"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("ceen"),
            keywords: &["ceen"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("amatsheyina"),
            keywords: &["amatsheyina", "itsheyina"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àwọn ṣe\u{329}kẹ\u{301}ṣẹkẹ\u{300}"),
            keywords: &[
                "àwọn ṣe\u{329}kẹ\u{301}ṣẹkẹ\u{300}",
                "ṣe\u{329}kẹ\u{301}ṣẹkẹ\u{300}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("鏈"),
            keywords: &["鏈"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("链"),
            keywords: &["链"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("链条"),
            keywords: &["铁链", "链", "链条", "锁链"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("鍊條"),
            keywords: &["鍊子", "鍊條"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("鍊"),
            keywords: &["鍊", "鍊子｜鍊條｜鍊"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("amaketango"),
            keywords: &["amaketango"],
        },
    ],
};
#[doc = "🪝"]
pub const HOOK: crate::Emoji = crate::Emoji {
    glyph: "🪝",
    codepoint: "1FA9D",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "hook",
    group: "Objects",
    subgroup: "tool",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("hoek"),
            keywords: &["hoek", "strik", "vang", "vangs", "verkoopspunt"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መንጠቆ"),
            keywords: &["መንጠቆ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("خطاف"),
            keywords: &[
                "إبزيم",
                "إلتقاط",
                "خطاف",
                "صنارة",
                "كبشة",
                "كلاب",
                "مشبك",
                "نقطة شراء",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হ\u{9c1}ক"),
            keywords: &[
                "এনচ\u{9be}ৰে",
                "ক\u{9be}ৰ\u{9cd}ভ",
                "ক\u{9cd}ৰ\u{9c1}ক",
                "চেলিং পইণ\u{9cd}ট",
                "ধৰ\u{9be}",
                "হ\u{9c1}ক",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qarmaq"),
            keywords: &[
                "cəftə",
                "qarmaq",
                "satış nöqtəsi",
                "tutmaq",
                "tələyə salmaq",
                "əyri",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кручок"),
            keywords: &[
                "абыход",
                "гак",
                "крук",
                "кручок",
                "лавіць",
                "прынада",
                "чапляць",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("кука"),
            keywords: &[
                "гега",
                "извивка",
                "кука",
                "примка",
                "търговско предимство",
                "хващане",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{981}ড\u{9bc}শি"),
            keywords: &[
                "ধর\u{9be}",
                "ফ\u{9be}\u{981}দে ফেল\u{9be}",
                "ব\u{981}ড\u{9bc}শি",
                "ব\u{9be}\u{981}ক",
                "ব\u{9be}\u{981}ক\u{9be}নো",
                "সেলিং পয\u{9bc}েন\u{9cd}ট",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("krog"),
            keywords: &["higennañ", "krog"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("udica"),
            keywords: &[
                "hvatanje",
                "udica",
                "uhvatiti u zamku",
                "ulov",
                "uloviti",
                "upecati",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("ham"),
            keywords: &[
                "atrapar",
                "corba",
                "ganxo",
                "ham",
                "pescar",
                "punt de venda",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏑᏗᎢ"),
            keywords: &["ᎠᏂᎾᏕᎬ", "ᎠᏓᎶᏄᎮᏗ", "ᎠᏕᏲᎲᎢ", "ᎦᏂᏴᏗ", "ᏌᏛᏗ", "ᏑᏗᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("hák"),
            keywords: &["chytit", "hák", "háček", "lovit", "polapit", "zahnutý"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bachyn"),
            keywords: &[
                "bachyn",
                "cromlin",
                "dal",
                "maglu",
                "pwynt gwerthu",
                "troseddwr",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("krog"),
            keywords: &[
                "besnære",
                "fange",
                "fangst",
                "få på krogen",
                "hage",
                "krog",
                "lokkemiddel",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Haken"),
            keywords: &["Angelhaken", "Haken"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Haken"),
            keywords: &[""],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γάντζος"),
            keywords: &[
                "γάντζος",
                "καμπύλη",
                "κύρτωμα",
                "παγιδεύω",
                "πιάνω",
                "σημείο πώλησης",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("hook"),
            keywords: &[
                "catch",
                "crook",
                "curve",
                "ensnare",
                "hook",
                "selling point",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &[
                "catch",
                "crook",
                "curve",
                "ensnare",
                "fishing",
                "hook",
                "selling point",
            ],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("gancho"),
            keywords: &["agarrar", "anzuelo", "atrapar", "gancho", "garfio"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("gancho"),
            keywords: &["gancho"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("konks"),
            keywords: &["kinnitamine", "konks", "kõver", "püük", "tõstmine"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("amu"),
            keywords: &[
                "amu",
                "bihurritu",
                "harrapatu",
                "makurra",
                "okerra",
                "saltokia",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قلاب"),
            keywords: &[
                "انحنا",
                "به\u{200c}دام انداختن",
                "خمیدگی",
                "قلاب",
                "نقطه فروش",
                "گرفتن",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("koukku"),
            keywords: &["haka", "koukku", "koukuttaa"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kawit"),
            keywords: &["huli", "kawit", "selling point"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("krókur"),
            keywords: &["krókur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("crochet"),
            keywords: &[
                "accrocher",
                "appâter",
                "attraper",
                "crochet",
                "ferrer",
                "hameçonner",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("crochet"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("crúca"),
            keywords: &["crúca", "duán"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("dubhan"),
            keywords: &[
                "cromag",
                "cròcag",
                "cròicean",
                "dubhan",
                "huca",
                "reic",
                "rib",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("gancho"),
            keywords: &["anzol", "enganchar", "gancho", "pescar"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("હ\u{ac2}ક"),
            keywords: &[
                "ક\u{ac5}ચ",
                "ક\u{acd}ર\u{ac2}ક",
                "જાળમા\u{a82} ફસાવવ\u{ac1}\u{a82}",
                "વળા\u{a82}ક",
                "વ\u{ac7}ચાણન\u{ac1}\u{a82} ક\u{ac7}\u{a82}દ\u{acd}ર",
                "હ\u{ac2}ક",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קרס"),
            keywords: &["אנקול", "וו", "קרס"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ह\u{941}क"),
            keywords: &[
                "क\u{94d}र\u{941}क",
                "पकड\u{93c}ना",
                "फ\u{901}साना",
                "वक\u{94d}र",
                "स\u{947}लि\u{902}ग पॉइ\u{902}ट",
                "ह\u{941}क",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("udica"),
            keywords: &[
                "kuka",
                "prodajno mjesto",
                "udica",
                "uhvatiti",
                "uloviti",
                "zakrivljeno",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kampó"),
            keywords: &["csapda", "fogás", "horog", "kampó"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կեռ"),
            keywords: &["բռնել", "կարթ", "կեռ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kait"),
            keywords: &["kail", "kait", "kurva", "titik jual"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("krókur"),
            keywords: &["bogi", "gildra", "krækja", "krókur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("gancio"),
            keywords: &[
                "curva",
                "fermaglio",
                "gancio",
                "intrappolare",
                "punto vendita",
                "uncino",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("フック"),
            keywords: &["フック", "引っ掛け", "掛け金", "留め金"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pancing"),
            keywords: &[
                "bengkok",
                "kurpa",
                "nangkap",
                "pancing",
                "panjerat",
                "seng utama",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კაუჭი"),
            keywords: &["დაბმა", "დაჭერა", "კაუჭი", "მოღუნული"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ілгек"),
            keywords: &[
                "имек",
                "коммерциялық аргумент",
                "ілгек",
                "іліп алу",
                "ұстап алу",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ផ\u{17d2}លែសន\u{17d2}ទ\u{17bc}ច"),
            keywords: &[
                "កោង",
                "ចាប\u{17cb}",
                "ច\u{17c6}ណ\u{17bb}ចទាក\u{17cb}ទាញ",
                "ដាក\u{17cb}អន\u{17d2}ទាក\u{17cb}",
                "តម\u{17d2}ពក\u{17cb}",
                "ផ\u{17d2}លែសន\u{17d2}ទ\u{17bc}ច",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕೊಕ\u{ccd}ಕ\u{cc6}"),
            keywords: &[
                "ಕರ\u{ccd}ವ\u{ccd}",
                "ಕೊಕ\u{ccd}ಕ\u{cc6}",
                "ಕ\u{ccd}ಯಾಚ\u{ccd}",
                "ಮಾರಾಟದ ಸ\u{ccd}ಥಳ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("갈고리"),
            keywords: &["갈고리", "걸리게 하다", "고리", "곡선", "팔리는"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ह\u{942}क"),
            keywords: &[
                "आ\u{902}कडो",
                "एनस\u{94d}न\u{947}र",
                "कर\u{94d}व",
                "क\u{945}च",
                "क\u{94d}र\u{941}क",
                "स\u{947}\u{947}लि\u{902}ग पॉय\u{902}ट",
                "ह\u{942}क",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("илгич"),
            keywords: &["илгич"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຕະຂ\u{ecd}"),
            keywords: &[
                "ຂ\u{ecd}\u{ec9}ພ\u{eb1}ບ",
                "ຈ\u{eb1}ບ",
                "ຈ\u{eb8}ດຂາຍ",
                "ດ\u{eb1}ກຟ\u{eb1}ງ",
                "ຕະຂ\u{ecd}",
                "ໂຄ\u{ec9}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kablys"),
            keywords: &["grobis", "kablys", "sugauti"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("āķis"),
            keywords: &["pievilināt", "pārdošanas arguments", "uzķeršanās", "āķis"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("кука"),
            keywords: &["кука", "свиок", "свиткано", "јамка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കൊള\u{d41}ത\u{d4d}ത\u{d4d}"),
            keywords: &[
                "കെണിവെച\u{d4d}ച\u{d4d} പിടിക\u{d4d}ക\u{d41}ക",
                "കൊള\u{d41}ത\u{d4d}ത\u{d4d}",
                "ച\u{d42}ണ\u{d4d}ടക\u{d4d}കൊള\u{d41}ത\u{d4d}ത\u{d4d}",
                "പിട\u{d41}ത\u{d4d}തം",
                "വളവ\u{d4d}",
                "വിൽപ\u{d4d}പന കേന\u{d4d}ദ\u{d4d}രം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дэгээ"),
            keywords: &["барих", "борлуулах цэг", "дэгээ", "муруй", "урхидах"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ह\u{942}क"),
            keywords: &[
                "पकडण\u{947}",
                "फासळ",
                "बाक",
                "वळण",
                "विक\u{94d}री बि\u{902}द\u{942}",
                "ह\u{942}क",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("cangkuk"),
            keywords: &[
                "bengkok",
                "cangkuk",
                "keluk",
                "menjerat",
                "tangkapan",
                "titik jualan",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ချ\u{102d}တ\u{103a}ကောက\u{103a}"),
            keywords: &[
                "ချ\u{102d}တ\u{103a}ကောက\u{103a}",
                "ဖမ\u{103a}းခြင\u{103a}း",
                "မက\u{103a}လ\u{102f}\u{1036}း",
                "မ\u{102d}နေသည\u{103a}",
                "လ\u{1030}လ\u{102d}မ\u{103a}လ\u{1030}ညစ\u{103a}",
                "အက\u{103d}ေးအကောက\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("krok"),
            keywords: &["buet", "fange", "krok", "løfte", "løftekrok", "salgspunkt"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ह\u{941}क"),
            keywords: &[
                "इन\u{94d}सन\u{947}यर",
                "कर\u{94d}भ",
                "ठग",
                "बिक\u{94d}री गर\u{94d}न\u{947} बिन\u{94d}द\u{941}",
                "समात\u{94d}न\u{941}",
                "ह\u{941}क",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("haak"),
            keywords: &[
                "aanbeveling",
                "bocht",
                "haak",
                "haakje",
                "kronkel",
                "vangen",
                "verstrikken",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("krok"),
            keywords: &["boga", "fange", "krok", "løfte", "løftekrok", "salspunkt"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ହ\u{b41}କ/ଟଣ\u{b3e} ହେବ\u{b3e} ପ\u{b3e}ଇ\u{b01} ବ\u{b4d}ୟବହ\u{b43}ତ ଆଙ\u{b4d}କ\u{b41}ଡ\u{b3c}\u{b3f}",
            ),
            keywords: &[
                "ଆଙ\u{b4d}କ\u{b41}ଡ\u{b3c}\u{b3f}",
                "ଧର\u{b3f}ବ\u{b3e}",
                "ବକ\u{b4d}ର",
                "ବ\u{b3f}କ\u{b4d}ର\u{b3f} କର\u{b3f}ବ\u{b3e}",
                "ଯନ\u{b4d}ତ\u{b3e}ରେ ପକ\u{b3e}ଇବ\u{b3e}",
                "ହ\u{b41}କ/ଟଣ\u{b3e} ହେବ\u{b3e} ପ\u{b3e}ଇ\u{b01} ବ\u{b4d}ୟବହ\u{b43}ତ ଆଙ\u{b4d}କ\u{b41}ଡ\u{b3c}\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਘ\u{a41}\u{a70}ਡੀ"),
            keywords: &[
                "ਘ\u{a41}\u{a70}ਡੀ",
                "ਫਸਾਉਣਾ",
                "ਫੜਨਾ",
                "ਮ\u{a4b}ੜ",
                "ਵ\u{a47}ਚਣ ਦੀ ਜਗ\u{a4d}ਹਾ",
                "ਹ\u{a41}\u{a71}ਕ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Huk"),
            keywords: &["Huk", "Kach", "Kruk", "Kọv", "Sẹ\u{301}lín Pọint", "Trap"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("hak"),
            keywords: &["haczyk", "hak", "połknąć", "zakrzywiony", "złapać"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کنډه"),
            keywords: &["تاؤ", "د خرڅلاو ځای", "رانيول", "نيول", "کنډه", "کږه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("gancho"),
            keywords: &[
                "atração para venda",
                "bandido",
                "curva",
                "gancho",
                "pegar",
                "prender",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["gancho"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cârlig"),
            keywords: &[
                "argument de vânzare",
                "captură",
                "cârlig",
                "escroc",
                "momeală",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-065"),
            keywords: &["E13-065"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("крюк"),
            keywords: &["захват", "крюк", "крючок", "подвес", "уловка"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("هوڪ"),
            keywords: &["انسنيئر", "موڙ", "هوڪ", "وڪري جي پوائنٽ", "ڪروڪ", "ڪيچ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කොක\u{dca}ක"),
            keywords: &[
                "ඇල\u{dca}ල\u{dd3}ම",
                "උග\u{dd4}ල\u{dca} අටවනව\u{dcf}",
                "කෙක\u{dca}ක",
                "කොක\u{dca}ක",
                "වක\u{dca}\u{200d}රය",
                "ව\u{dd2}ක\u{dd4}ණ\u{dd4}ම\u{dca} ස\u{dca}ථ\u{dcf}නය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("hák"),
            keywords: &["hák", "háčik", "lákadlo", "nachytať", "skoba"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kljuka"),
            keywords: &[
                "kavelj",
                "kljuka",
                "krivuljnik",
                "prednost",
                "zanka",
                "zaponka",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("jilaab"),
            keywords: &[
                "dabin",
                "jilaab",
                "qaabka wax loo gado",
                "qabo",
                "qallooca",
                "qallooci",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kanxhë"),
            keywords: &[
                "bisht",
                "kanxhë",
                "kapëse",
                "kunj",
                "pikë shitjeje",
                "varëse",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кука"),
            keywords: &[
                "закривљено",
                "кука",
                "продајно место",
                "удица",
                "уловити",
                "ухватити",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["кука"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kuka"),
            keywords: &[
                "kuka",
                "prodajno mesto",
                "udica",
                "uhvatiti",
                "uloviti",
                "zakrivljeno",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["kuka"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("krok"),
            keywords: &["hake", "klo", "krok", "snärja"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ndoano"),
            keywords: &[
                "bakora",
                "kishawishi cha mauzo",
                "ndoano",
                "pinda",
                "shika",
                "tega",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கொக\u{bcd}கி"),
            keywords: &[
                "கொக\u{bcd}கி",
                "பிடித\u{bcd}தல\u{bcd}",
                "ம\u{bbe}ட\u{bcd}டி",
                "வளைவு",
                "விறபனை இடம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c4a}క\u{c4d}క\u{c40}"),
            keywords: &[
                "క\u{c4a}క\u{c4d}క\u{c40}",
                "క\u{c4a}క\u{c4d}క\u{c46}ము",
                "పట\u{c4d}టుక\u{c4b}వడం",
                "వంక\u{c40}",
                "వ\u{c3f}క\u{c4d}రయ క\u{c47}ంద\u{c4d}రం",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ตะขอ"),
            keywords: &["งอ", "จ\u{e31}บ", "ด\u{e31}กปลา", "ตะขอ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ilgençek"),
            keywords: &[
                "egri",
                "ilgençek",
                "mahabat nokady",
                "tora salmak",
                "tutmak",
                "çeňňek",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mātaʻu"),
            keywords: &["mātaʻu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("çengel"),
            keywords: &["askı", "eğri", "kanca", "çengel"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("гачок"),
            keywords: &[
                "гак",
                "гачок",
                "комерційний аргумент",
                "крива",
                "принада",
                "піймати",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ہک"),
            keywords: &["بیچنے کا مقام", "ترشول", "خمیدہ", "پکڑنا", "پھانسنا", "ہک"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ilgak"),
            keywords: &[
                "egri",
                "ilgak",
                "ilib olish",
                "ilintirish",
                "ilmoq",
                "savdo nuqtasi",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("móc"),
            keywords: &[
                "bẫy",
                "bắt",
                "cái móc",
                "móc",
                "điểm bán hàng",
                "đường cong",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("勾"),
            keywords: &["勾", "圈套", "彎", "彎曲", "賣點", "趕上"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("勾"),
            keywords: &["勾", "卖点", "圈套", "弯", "弯曲", "赶上"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("挂钩"),
            keywords: &["卖点", "抓", "挂钩", "曲线", "钩状物"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("鉤子"),
            keywords: &["勾", "彎曲", "鉤", "鉤子", "鉤形"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-hook"),
            keywords: &[
                "catch",
                "crook",
                "curve",
                "ensnare",
                "i-hook",
                "selling point",
            ],
        },
    ],
};
#[doc = "🧰"]
pub const TOOLBOX: crate::Emoji = crate::Emoji {
    glyph: "🧰",
    codepoint: "1F9F0",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "toolbox",
    group: "Objects",
    subgroup: "tool",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gereedskaptrommel"),
            keywords: &[
                "gereedskap",
                "gereedskaptrommel",
                "trommel",
                "werktuigkundige",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የመፍቻ ሳጥን"),
            keywords: &["መሳሪያ", "ሜካኒክ", "ሳጥን", "የመፍቻ ሳጥን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("صندوق أدوات"),
            keywords: &["أداة", "صدر", "صندوق أدوات", "ميكانيكي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ট\u{9c1}লবক\u{9cd}স"),
            keywords: &[
                "চন\u{9cd}দ\u{9c1}ক",
                "ট\u{9c1}লবক\u{9cd}স",
                "মেক\u{9be}নিক",
                "স\u{981}জ\u{9c1}লি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("alətlər qutusu"),
            keywords: &["alət", "alətlər qutusu", "mexanik", "çanta"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("скрыня з інструментамі"),
            keywords: &["механік", "скрыня", "скрыня з інструментамі", "інструменты"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("кутия за инструменти"),
            keywords: &["инструмент", "кутия за инструменти", "ремонт", "сандък"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ট\u{9c1}লবক\u{9cd}স"),
            keywords: &[
                "চেস\u{9cd}ট",
                "ট\u{9c1}ল",
                "ট\u{9c1}লবক\u{9cd}স",
                "মেক\u{9be}নিক",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("boest-ostilhoù"),
            keywords: &["boest", "boest-ostilhoù", "ostilhoù"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kutija za alat"),
            keywords: &["alat", "kofer", "kutija za alat", "mehaničar"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("caixa d’eines"),
            keywords: &["caixa", "caixa d’eines", "eines", "mecànic"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎬᏔᏂᏓᏍᏗ ᎦᎵᏔᏅᏙᏗ ᎧᏁᏌᎢ"),
            keywords: &["ᎣᏍᏓ ᏱᎬᏁᎸᏍᎩ", "ᎧᏁᏌᎢ ᎦᎵᏔᏅᏙᏗ", "ᎬᏔᏂᏓᏍᏗ", "ᎬᏔᏂᏓᏍᏗ ᎦᎵᏔᏅᏙᏗ ᎧᏁᏌᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("box na nářadí"),
            keywords: &["bedna", "box na nářadí", "krabice", "nástroje", "nářadí"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("blwch offer"),
            keywords: &["blwch offer", "cist", "mecanydd", "offer"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("værktøjskasse"),
            keywords: &["håndværker", "mekaniker", "værktøj", "værktøjskasse"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Werkzeugkasten"),
            keywords: &["Mechaniker", "Werkzeug", "Werkzeugkasten"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("εργαλειοθήκη"),
            keywords: &["εργαλείο", "εργαλειοθήκη", "μηχανικός", "μπαούλο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("toolbox"),
            keywords: &["chest", "mechanic", "tool", "toolbox"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("caja de herramientas"),
            keywords: &["armario", "caja de herramientas", "herramienta", "mecánico"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["caja de herramientas", "cofre", "herramienta", "mecánico"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("tööriistakast"),
            keywords: &["kast", "laegas", "tööriistad", "tööriistakast"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("erreminta-kutxa"),
            keywords: &["erreminta", "erreminta-kutxa", "kutxa", "mekaniko"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("جعبه\u{200c}ابزار"),
            keywords: &[
                "ابزار",
                "تعمیرکار",
                "جعبه\u{200c}آچار",
                "جعبه\u{200c}ابزار",
                "صندوق",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("työkalulaatikko"),
            keywords: &[
                "laatikko",
                "mekaaninen",
                "pakki",
                "työkalu",
                "työkalulaatikko",
                "työkalupakki",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kahon ng kagamitan"),
            keywords: &["kaban", "kagamitan", "kahon ng kagamitan", "mekaniko"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("amboðskassi"),
            keywords: &["amboð", "amboðskassi", "kassi"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("boîte à outils"),
            keywords: &["boîte à outils", "coffre", "mécanique", "outil"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bosca uirlisí"),
            keywords: &["bosca uirlisí", "cófra", "meicneoir", "uirlis"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bogsa-innealan"),
            keywords: &["acainn", "bogsa", "bogsa-innealan", "inneal", "meacanaig"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("caixa de ferramentas"),
            keywords: &["caixa de ferramentas", "ferramentas", "mec´ánico"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ટ\u{ac2}લબોક\u{acd}સ"),
            keywords: &["ટ\u{ac2}લબોક\u{acd}સ", "પટારો", "મિક\u{ac7}નિક", "સાધન"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ארגז כלים"),
            keywords: &["ארגז", "כלים", "תיבה", "תיקונים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ट\u{942}लबॉक\u{94d}स"),
            keywords: &["उपकरण", "कारीगर", "ट\u{942}लबॉक\u{94d}स", "डिब\u{94d}बा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kutija za alat"),
            keywords: &["alat", "kutija", "kutija za alat", "mehaničar"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szerszámosláda"),
            keywords: &["barkácsolás", "láda", "szerszám", "szerszámosláda"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("գործիքների արկղ"),
            keywords: &["արկղ", "գործիք", "գործիքների արկղ", "վարպետ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kotak perkakas"),
            keywords: &["kotak perkakas", "mekanik", "perkakas", "peti"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("verkfærakassi"),
            keywords: &["kista", "tól", "verkfærakassi", "verkfæri", "viðgerðir"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cassetta degli attrezzi"),
            keywords: &[
                "attrezzi",
                "cassetta degli attrezzi",
                "meccanico",
                "strumenti",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("工具箱"),
            keywords: &["ツールボックス", "メカニック", "工具箱", "整備士", "機械工"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kothak bekakas"),
            keywords: &["bekakas", "kothak bekakas", "montir", "pethi"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ხელსაწყოები"),
            keywords: &["სკივრი", "ტექნიკოსი", "ხელსაწყო", "ხელსაწყოები"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("құралдар жәшігі"),
            keywords: &["жәшік", "механикалық", "құрал", "құралдар жәшігі"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17d2}រអប\u{17cb}ដាក\u{17cb}ឧបករណ\u{17cd}"),
            keywords: &[
                "ប\u{17d2}រអប\u{17cb}ដាក\u{17cb}ឧបករណ\u{17cd}",
                "មេកាន\u{17b7}ច",
                "ហ\u{17b7}ប",
                "ឧបករណ\u{17cd}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪರ\u{cbf}ಕರಪ\u{cc6}ಟ\u{ccd}ಟ\u{cbf}ಗ\u{cc6}"),
            keywords: &[
                "ಪರ\u{cbf}ಕರ",
                "ಪರ\u{cbf}ಕರಪ\u{cc6}ಟ\u{ccd}ಟ\u{cbf}ಗ\u{cc6}",
                "ಪ\u{cc6}ಟ\u{ccd}ಟ\u{cbf}ಗ\u{cc6}",
                "ಮ\u{cc6}ಕ\u{ccd}ಯಾನ\u{cbf}ಕ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("공구통"),
            keywords: &["공구", "공구통", "공구함", "정비공"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("साधनबॉक\u{94d}स"),
            keywords: &[
                "प\u{947}टी",
                "या\u{902}त\u{94d}रिक",
                "साधन",
                "साधनप\u{947}टी",
                "साधनबॉक\u{94d}स",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("куралдар кутусу"),
            keywords: &["курал", "куралдар кутусу", "куту", "механик"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກ\u{eb1}ບໃສ\u{ec8}ເຄ\u{eb7}\u{ec8}ອງອ\u{eb8}ປະກອນ"),
            keywords: &[
                "ກ\u{eb1}ບໃສ\u{ec8}ເຄ\u{eb7}\u{ec8}ອງອ\u{eb8}ປະກອນ",
                "ເຄ\u{eb7}\u{ec8}ອງມ\u{eb7}ອ\u{eb9}\u{eb8}ປະກອນ",
                "ເອ\u{eb5}ກ",
                "ແມ\u{ec8}ກະນ\u{eb4}ກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("įrankių rinkinys"),
            keywords: &["dėžė", "mechanikas", "įrankis", "įrankių rinkinys"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("darbarīku kaste"),
            keywords: &["darbarīku kaste", "kaste", "mehānisks", "rīks"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("кутија за алат"),
            keywords: &["алат", "кутија", "кутија за алат", "механички"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ട\u{d42}ൾബോക\u{d4d}\u{200c}സ\u{d4d}"),
            keywords: &[
                "ട\u{d42}ൾ",
                "ട\u{d42}ൾബോക\u{d4d}\u{200c}സ\u{d4d}",
                "മെക\u{d4d}ക\u{d3e}നിക\u{d4d}",
                "വലിയ പെട\u{d4d}ടി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("багажны хайрцаг"),
            keywords: &["багаж", "багажны хайрцаг", "механик", "чээж"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ट\u{942}लबॉक\u{94d}स"),
            keywords: &[
                "च\u{947}स\u{94d}ट",
                "ट\u{942}ल",
                "ट\u{942}लबॉक\u{94d}स",
                "म\u{947}क\u{945}निक",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kotak alat"),
            keywords: &["alat", "kotak alat", "mekanik", "peti"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တ\u{1030}းလ\u{103a}ဘောက\u{103a}က\u{103a}စ\u{103a}"),
            keywords: &[
                "တ\u{1030}းလ\u{103a}",
                "တ\u{1030}းလ\u{103a}ဘောက\u{103a}က\u{103a}စ\u{103a}",
                "ဗ\u{102e}ရ\u{102d}\u{102f}",
                "မက\u{1039}ကင\u{103a}းနစ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("verktøykasse"),
            keywords: &["kasse", "skrin", "verktøy", "verktøykasse"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("औ\u{901}जारबाकस"),
            keywords: &["उपकरण", "औ\u{901}जारबाकस", "बाकस", "म\u{947}कानिक"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gereedschapskist"),
            keywords: &["gereedschap", "gereedschapskist", "kist", "monteur"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("verktøykasse"),
            keywords: &["kasse", "skrin", "verktøy", "verktøykasse"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଟ\u{b41}ଲ\u{200c}ବକ\u{b4d}ସ"),
            keywords: &[
                "ଉପକରଣ",
                "ଚେଷ\u{b4d}ଟ",
                "ଟ\u{b41}ଲ\u{200c}ବକ\u{b4d}ସ",
                "ମେକ\u{b3e}ନ\u{b3f}କ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਐਜ\u{a3c}ਾਰਾ\u{a02} ਦਾ ਬਕਸਾ"),
            keywords: &[
                "ਐਜ\u{a3c}ਾਰਾ\u{a02} ਦਾ ਬਕਸਾ",
                "ਔਜ\u{a3c}ਾਰ",
                "ਮਕ\u{a48}ਨਿਕ",
                "ਸ\u{a70}ਦ\u{a42}ਕੜੀ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Túlbọks"),
            keywords: &["Mẹ\u{301}kánik", "Strọ\u{301}ng Bọks", "Tul", "Túlbọks"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("skrzynka na narzędzia"),
            keywords: &["mechanik", "narzędzie", "skrzynka", "skrzynka na narzędzia"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د اوزارو بوکسه"),
            keywords: &["اله", "بوکسه", "د اوزارو بوکسه", "ميخانيک"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("caixa de ferramentas"),
            keywords: &["caixa", "caixa de ferramentas", "ferramenta", "mecânico"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("mala de ferramentas"),
            keywords: &["caixa", "ferramenta", "mala de ferramentas", "mecânico"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("trusă de scule"),
            keywords: &[
                "cutie",
                "instrument",
                "mecanic",
                "trusă de scule",
                "unealtă",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-058"),
            keywords: &["E11-058"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("ящик для инструментов"),
            keywords: &[
                "инструменты",
                "комплект инструментов",
                "механик",
                "ящик для инструментов",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٽول باڪس"),
            keywords: &["مستري", "ٽول", "ٽول باڪس", "ڇاتي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මෙවලම\u{dca} පෙට\u{dca}ට\u{dd2}ය"),
            keywords: &[
                "ක\u{dcf}ර\u{dca}ම\u{dd2}කය\u{dcf}",
                "පප\u{dd4}ව",
                "මෙවලම",
                "මෙවලම\u{dca} පෙට\u{dca}ට\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kufrík na náradie"),
            keywords: &["debna", "kufrík na náradie", "náradie", "nástroje"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zaboj za orodje"),
            keywords: &["mehanik", "orodje", "zaboj", "zaboj za orodje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("tuulbogos"),
            keywords: &["makaanig", "qalab", "shaf", "tuulbogos"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kuti veglash"),
            keywords: &[
                "arkë veglash",
                "kuti veglash",
                "kuti veglash dore",
                "vegla mekanike",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кутија за алат"),
            keywords: &["алат", "кутија за алат", "механичар", "сандук"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kutija za alat"),
            keywords: &["alat", "kutija za alat", "mehaničar", "sanduk"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("verktygslåda"),
            keywords: &["låda", "mekaniker", "verktyg", "verktygslåda"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kisanduku cha vifaa"),
            keywords: &[
                "kisanduku",
                "kisanduku cha vifaa",
                "kisanduku cha zana",
                "makanika",
                "zana",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("டூல\u{bcd}ப\u{bbe}க\u{bcd}ஸ\u{bcd}"),
            keywords: &[
                "டூல\u{bcd}",
                "டூல\u{bcd}ப\u{bbe}க\u{bcd}ஸ\u{bcd}",
                "ம\u{bbe}ர\u{bcd}பு",
                "மெக\u{bcd}க\u{bbe}னிக\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("టూల\u{c4d}\u{200c}బ\u{c3e}క\u{c4d}స\u{c4d}"),
            keywords: &[
                "టూల\u{c4d}\u{200c}బ\u{c3e}క\u{c4d}స\u{c4d}",
                "ప\u{c46}ట\u{c4d}ట\u{c46}",
                "మ\u{c46}క\u{c3e}న\u{c3f}క\u{c4d}",
                "స\u{c3e}ధనం",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("กล\u{e48}องเคร\u{e37}\u{e48}องม\u{e37}อ"),
            keywords: &[
                "กล\u{e48}องเคร\u{e37}\u{e48}องม\u{e37}อ",
                "ช\u{e48}างกล",
                "ห\u{e35}บ",
                "เคร\u{e37}\u{e48}องม\u{e37}อ",
                "เคร\u{e37}\u{e48}องม\u{e37}อช\u{e48}าง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gural gutusy"),
            keywords: &["gural", "gural gutusy", "mehanik", "ýaşik"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("puha meʻangāue"),
            keywords: &["puha meʻangāue"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("alet çantası"),
            keywords: &["alet", "alet çantası", "sandık", "tamirci"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("скриня для інструментів"),
            keywords: &[
                "коробка",
                "механік",
                "скриня",
                "скриня для інструментів",
                "інструмент",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ٹ\u{64f}ول بکس"),
            keywords: &["اوزار", "صندوق", "مکینک", "ٹ\u{64f}ول بکس"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("asbob-uskuna qutisi"),
            keywords: &[
                "asbob",
                "asbob-uskuna",
                "asbob-uskuna qutisi",
                "jamlanma",
                "quti",
                "uskuna",
                "usta",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hộp dụng cụ"),
            keywords: &["dụng cụ", "hòm", "hộp dụng cụ", "thợ máy"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("工具箱"),
            keywords: &["工具", "工具箱", "技工", "箱"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("工具箱"),
            keywords: &["工具", "工具箱", "技工", "箱"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("工具箱"),
            keywords: &["工具", "工具箱", "机修", "箱子"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("工具箱"),
            keywords: &["器具", "工具", "工具箱", "箱子"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhokisi lamathuluzi"),
            keywords: &["chest", "ibhokisi lamathuluzi", "mechanic", "tool"],
        },
    ],
};
#[doc = "🧲"]
pub const MAGNET: crate::Emoji = crate::Emoji {
    glyph: "🧲",
    codepoint: "1F9F2",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "magnet",
    group: "Objects",
    subgroup: "tool",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("magneet"),
            keywords: &["aantrekking", "hoefyster", "magneet", "magneties"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ማግኔት"),
            keywords: &["መሳሳብ", "ማግኔቲክ", "ማግኔት", "የፈረስ ጫማ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مغناطيس"),
            keywords: &["جذب", "حدوة حصان", "مغناطيس", "مغناطيسي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চ\u{9c1}ম\u{9cd}বক"),
            keywords: &[
                "আকৰ\u{9cd}ষণ",
                "ঘোড\u{9bc}\u{9be}ৰ খ\u{9c1}ৰ\u{9be}ৰ তলত লগোৱ\u{9be} লোহ\u{9be}ৰ প\u{9be}তি",
                "চ\u{9c1}ম\u{9cd}বক",
                "চ\u{9c1}ম\u{9cd}বকীয\u{9bc}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("maqnit"),
            keywords: &["cazibə", "maqnit", "nal"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("магніт"),
            keywords: &["магнетызм", "магніт", "падкова", "прыцяжэнне"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("магнит"),
            keywords: &["залепване", "конска подкова", "магнит", "привличане"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চ\u{9c1}ম\u{9cd}বক"),
            keywords: &[
                "অশ\u{9cd}বখ\u{9c1}র",
                "আকর\u{9cd}ষণ",
                "চ\u{9c1}ম\u{9cd}বক",
                "চৌম\u{9cd}বক",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("gwarell"),
            keywords: &["gwarell", "houarn-marcʼh", "magnetek"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("magnet"),
            keywords: &["magnet", "magnetski", "potkovica", "privlačenje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("imant"),
            keywords: &["atracció", "ferradura", "imant", "magnètic"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏔᎷᎩᏍᎩ ᎦᏌᏁᏍᎩ"),
            keywords: &["ᎤᎵᎶᎯ ᎠᎦᏎᏍᏛ", "ᏐᏈᎵ ᎤᎳᏑᎶᎩ", "ᏔᎷᎩᏍᎩ ᎦᏌᏁᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("magnet"),
            keywords: &["magnet", "podkova", "přitažlivost"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("magnet"),
            keywords: &["atyniad", "magnet", "magnetig", "pedol"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("magnet"),
            keywords: &["hestesko", "magnet", "magnetisk", "tiltrækning"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Magnet"),
            keywords: &["Anziehungskraft", "Magnet", "magnetisch"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μαγνήτης"),
            keywords: &["έλξη", "μαγνήτης", "μαγνητικό", "πέταλο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("magnet"),
            keywords: &["attraction", "horseshoe", "magnet", "magnetic"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("imán"),
            keywords: &["atracción", "herradura", "imán", "magnético"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("magnet"),
            keywords: &["atraktsioon", "hobuseraud", "magnet"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("iman"),
            keywords: &["erakarpen", "ferra", "iman", "magnetiko"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("آهن\u{200c}ربا"),
            keywords: &["آهن\u{200c}ربا", "جاذبه", "مغناطیسی", "نعل اسب"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("magneetti"),
            keywords: &[
                "hevosenkenkä",
                "magneetti",
                "magneettinen",
                "puoleensavetävä",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("magneto"),
            keywords: &["atraksyon", "horseshoe", "magnetic", "magneto"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("magnet"),
            keywords: &["magnet", "magnetisk", "magnetiskur", "sigul"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("aimant"),
            keywords: &["aimant", "attraction", "fer à cheval", "magnétique"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("maighnéad"),
            keywords: &["aomadh", "crú capaill", "maighnéad"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("clach-iùil"),
            keywords: &["clach-iùil", "crudha-eich", "magnaiteach", "tarraing"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("imán"),
            keywords: &["atracción", "ferradura", "imán", "magnético"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લોહચ\u{ac1}\u{a82}બક"),
            keywords: &[
                "આકર\u{acd}ષણ",
                "ઘોડાની નાળ",
                "ચ\u{ac1}\u{a82}બકીય",
                "લોહચ\u{ac1}\u{a82}બક",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מגנט"),
            keywords: &["מגנט", "מגנטי", "משיכה", "פרסה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("च\u{941}\u{902}बक"),
            keywords: &[
                "आकर\u{94d}षण",
                "घोड\u{93c}\u{947} की नाल",
                "च\u{941}\u{902}बक",
                "च\u{941}\u{902}बकीय",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("magnet"),
            keywords: &["magnet", "magnetizam", "potkova", "privlačenje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("mágnes"),
            keywords: &["mágnes", "mágneses", "patkó", "vonzódás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մագնիս"),
            keywords: &["ձգողություն", "մագնիս", "մագնիսային", "պայտ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("magnet"),
            keywords: &["ladam", "magnet", "magnetik", "tarikan"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("segull"),
            keywords: &["aðdráttarafl", "segull", "segulmagn", "skeifa"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("calamita"),
            keywords: &[
                "attrazione",
                "calamita",
                "ferro di cavallo",
                "magnete",
                "magnetica",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("U字型磁石"),
            keywords: &["U字型磁石", "マグネット", "蹄鉄"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wesi magnet"),
            keywords: &["magnet", "tapal jaran", "tarik-tinarik", "wesi magnet"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მაგნიტი"),
            keywords: &["მაგნიტი", "მაგნიტური", "მიზიდულობა", "ნალი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("магнит"),
            keywords: &["магнит", "магнитті", "тарту", "таға"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ដែកឆក\u{17cb}"),
            keywords: &[
                "ការឆក\u{17cb}",
                "ក\u{17d2}រចកជើងសេះ",
                "ឆក\u{17cb}",
                "ដែកឆក\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮ\u{ccd}ಯಾಗ\u{ccd}ನ\u{cc6}ಟ\u{ccd}"),
            keywords: &[
                "ಆಕರ\u{ccd}ಷಣ\u{cc6}",
                "ಕುದುರ\u{cc6} ಲಾಳ",
                "ಮ\u{ccd}ಯಾಗ\u{ccd}ನ\u{cc6}ಟ\u{cbf}ಕ\u{ccd}",
                "ಮ\u{ccd}ಯಾಗ\u{ccd}ನ\u{cc6}ಟ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("자석"),
            keywords: &["말굽 자석", "자석", "편자"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("च\u{941}\u{902}बक"),
            keywords: &[
                "आकर\u{94d}शण",
                "घोड\u{94d}यानाळ",
                "च\u{941}\u{902}बक",
                "च\u{941}\u{902}बकीय",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("магнит"),
            keywords: &["аттын такасы", "магнит", "тартуу"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພ\u{ebb}ງກ\u{eb4}ນເຫ\u{ebc}\u{eb1}ກ"),
            keywords: &[
                "ກາບຮອງຕ\u{eb5}ນມ\u{ec9}າ",
                "ຕ\u{eb4}ດແປະ",
                "ພ\u{ebb}ງກ\u{eb4}ນເຫ\u{ebc}\u{eb1}ກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("magnetas"),
            keywords: &["magnetas", "magnetinis", "pasaga", "trauka"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("magnēts"),
            keywords: &["magnētisks", "magnēts", "pakavs", "pievilkšana"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("магнет"),
            keywords: &["магнет", "магнетно", "потковица", "привлекување"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d3e}ന\u{d4d}തം"),
            keywords: &[
                "ആകർഷണം",
                "ക\u{d3e}ന\u{d4d}തം",
                "ക\u{d3e}ന\u{d4d}തികം",
                "ക\u{d41}തിരല\u{d3e}ടം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("соронз"),
            keywords: &["соронз", "татах", "тах"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("म\u{945}ग\u{94d}न\u{947}ट"),
            keywords: &[
                "आकर\u{94d}षण",
                "च\u{941}\u{902}बकीय",
                "म\u{945}ग\u{94d}न\u{947}ट",
                "हॉर\u{94d}सश\u{942}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("magnet"),
            keywords: &["bermagnet", "ladam kuda", "magnet", "tarikan"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("သ\u{1036}လ\u{102d}\u{102f}က\u{103a}"),
            keywords: &[
                "ဆ\u{103d}\u{1032}အင\u{103a}အား",
                "မြင\u{103a}းခ\u{103d}ာ",
                "သ\u{1036}လ\u{102d}\u{102f}က\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("magnet"),
            keywords: &["hestesko", "magnet", "magnetisk", "tiltrekning"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("च\u{941}म\u{94d}बक"),
            keywords: &[
                "आकर\u{94d}षण",
                "घोडाको ख\u{941}ट\u{94d}टामा बा\u{901}ध\u{94d}न\u{947} फलाम",
                "च\u{941}म\u{94d}बक",
                "च\u{941}म\u{94d}बकीय",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("magneet"),
            keywords: &["aantrekkingskracht", "hoefijzer", "magneet", "magnetisch"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("magnet"),
            keywords: &["hestesko", "magnet", "magnetisk", "tiltrekking"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଚ\u{b41}\u{b4d}ମ\u{b4d}ବକ"),
            keywords: &[
                "ଆକର\u{b4d}ଷଣ",
                "ଚ\u{b41}\u{b4d}ମ\u{b4d}ବକ",
                "ହର\u{b4d}ସ\u{b4d}\u{200c}ଶ\u{b41}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚ\u{a41}\u{a70}ਬਕ"),
            keywords: &[
                "ਖਿ\u{a71}ਚ",
                "ਘ\u{a4b}ੜ\u{a47} ਦੀ ਨਾਲ\u{a4d}ਹ",
                "ਚ\u{a41}\u{a70}ਬਕ",
                "ਚ\u{a41}\u{a70}ਬਕੀ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Magnẹ\u{301}tọ"),
            keywords: &["Drọ", "Hold", "Họ\u{301}sshu", "Magnẹt", "Magnẹ\u{301}tọ"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("magnes"),
            keywords: &["magnes", "magnetyzm", "podkowa", "przyciąganie"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مقناطيس"),
            keywords: &["د آس نال", "راکش کول", "مقناطيس", "مقناطيسي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("ímã"),
            keywords: &["atração", "ferradura", "magnético", "ímã"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("íman"),
            keywords: &["atração", "ferradura", "magnético", "íman"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("magnet"),
            keywords: &["atracție", "magnet", "magnetic", "potcoavă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-060"),
            keywords: &["E11-060"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("магнит"),
            keywords: &["магнит", "магнит-подкова", "притяжение"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ميگنيٽ"),
            keywords: &["ميگنيٽ", "ميگنيٽڪ", "ڪشش", "گهوڙي جي نار"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ච\u{dd4}ම\u{dca}බකය"),
            keywords: &[
                "අශ\u{dca}ව කරත\u{dca}තය",
                "ආකර\u{dca}ෂණය",
                "ච\u{dd4}ම\u{dca}බකය",
                "ච\u{dd4}ම\u{dca}භක",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("magnet"),
            keywords: &["magnet", "podkova", "príťažlivosť"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("magnet"),
            keywords: &["magnet", "magnetno", "podkev", "privlačnost"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("birlab"),
            keywords: &["birlab", "birlabaysan", "kab faras", "soo jiidasho"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("magnet"),
            keywords: &["magnet", "magnet patkua", "tërheqje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("магнет"),
            keywords: &["магнет", "магнетни", "потковица", "привлачење"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("magnet"),
            keywords: &["magnet", "magnetni", "potkovica", "privlačenje"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("magnet"),
            keywords: &["hästsko", "magnet", "magnetisk"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("sumaku"),
            keywords: &["kiatu cha farasi", "mvuto", "sumaku"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("க\u{bbe}ந\u{bcd}தம\u{bcd}"),
            keywords: &[
                "ஈர\u{bcd}ப\u{bcd}பு",
                "க\u{bbe}ந\u{bcd}தம\u{bcd}",
                "குதிரைல\u{bbe}டம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("అయస\u{c4d}క\u{c3e}ంతం"),
            keywords: &[
                "అయస\u{c4d}క\u{c3e}ంతం",
                "ఆకర\u{c4d}షణ",
                "హ\u{c3e}ర\u{c4d}స\u{c4d}\u{200c}షూ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แม\u{e48}เหล\u{e47}ก"),
            keywords: &[
                "ก\u{e35}บม\u{e49}า",
                "ด\u{e36}งด\u{e39}ด",
                "ด\u{e39}ด",
                "แม\u{e48}เหล\u{e47}ก",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("magnit"),
            keywords: &["magnit", "nal", "çekiş"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("makinito"),
            keywords: &["makinito"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("mıknatıs"),
            keywords: &["at nalı", "manyetik", "mıknatıs", "çekim"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("магніт"),
            keywords: &["магнетизм", "магніт", "притягувати", "підкова", "тяжіння"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مقناطیس"),
            keywords: &["مقناطیس", "مقناطیسی", "کشش", "گھڑ نعل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("magnit"),
            keywords: &["itarish", "magnit", "taqa", "taqasimon magnit", "tortish"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nam châm"),
            keywords: &["móng ngựa", "nam châm", "sức hút", "từ tính"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("磁石"),
            keywords: &["吸力", "磁性", "磁石", "馬蹄鐵"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("磁石"),
            keywords: &["吸力", "磁性", "磁石", "马蹄铁"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("磁铁"),
            keywords: &["吸引力", "磁性", "磁铁", "马蹄铁"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("磁鐵"),
            keywords: &["五金", "磁力", "磁鐵"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umayibuthe"),
            keywords: &["attraction", "horseshoe", "magnetic", "umayibuthe"],
        },
    ],
};
#[doc = "🪜"]
pub const LADDER: crate::Emoji = crate::Emoji {
    glyph: "🪜",
    codepoint: "1FA9C",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "ladder",
    group: "Objects",
    subgroup: "tool",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("leer"),
            keywords: &["klim", "leer", "trappie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መሰላል"),
            keywords: &["መሰላል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سل\u{651}م"),
            keywords: &["تسلق", "درج", "سل\u{651}م", "صعود", "عارضة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("জখল\u{9be}"),
            keywords: &[
                "জখল\u{9be}",
                "জখল\u{9be}ৰ ক\u{9be}ঠ",
                "পদক\u{9cd}ষেপ",
                "বগোৱ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("nərdivan"),
            keywords: &["addım", "dırmaşma", "nərdivan", "pillə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("драбіны"),
            keywords: &["драбіны", "караскацца", "лесвіца", "прыступка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("стълба"),
            keywords: &["катеря се", "стълба", "стъпало"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মই"),
            keywords: &[
                "চড\u{9bc}\u{9be}ই কর\u{9be}",
                "পদক\u{9cd}ষেপ",
                "মই",
                "মইয\u{9bc}ের ধ\u{9be}প",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("skeul"),
            keywords: &["skabell", "skeul"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ljestve"),
            keywords: &["ljestve", "lotre", "merdevine", "penjanje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("escala de mà"),
            keywords: &["escala", "escala de mà", "esglaó", "graó", "pujar"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏴᏠ"),
            keywords: &["ᎠᎩᎶᏒᏍᏗᎢ", "ᎠᏴᏠ", "ᎦᎴᎦ", "ᎦᎵᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("žebřík"),
            keywords: &["příčka", "schod", "šplhat", "šprušel", "žebřík"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ysgol ddringo"),
            keywords: &["cam", "dringo", "gris", "ysgol", "ysgol ddringo"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("stige"),
            keywords: &["bestige", "klatre", "stige", "trin"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Leiter"),
            keywords: &["Leiter", "Sprosse", "Stufe", "klettern"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σκάλα"),
            keywords: &["σκάλα", "σκαλί", "σκαλοπάτι", "σκαρφαλώνω"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("ladder"),
            keywords: &["climb", "ladder", "rung", "step"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["climb", "ladder", "rung", "stair", "step"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("escalera"),
            keywords: &["escalar", "escalera", "escalerilla", "escalón", "peldaño"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("redel"),
            keywords: &["aste", "redel", "ronima", "trepp"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("esku-eskailera"),
            keywords: &["eskailera", "esku-eskailera", "igo", "maila"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نردبان"),
            keywords: &["بالا رفتن", "نردبان", "پله", "پله\u{654} نردبان"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tikkaat"),
            keywords: &["askelma", "kiivetä", "tikapuut", "tikkaat"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("hagdan"),
            keywords: &["akyat", "hagdan", "hakbang"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("stigi"),
            keywords: &["klatra", "stig", "stigi", "upp"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("échelle"),
            keywords: &["barreau", "escabeau", "monter", "échelle", "échelon"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("échelle"),
            keywords: &["barreau", "escabeau", "monter", "échelle"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("dréimire"),
            keywords: &["dreapadh", "dréimire", "runga"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("fàradh"),
            keywords: &[
                "ceum", "dìreadh", "dìrich", "fàradh", "rang", "reang", "rong", "sreap", "àradh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("escada"),
            keywords: &[
                "chanzo",
                "escada",
                "escaleira",
                "esqueira",
                "subir",
                "travesa",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("નિસરણી"),
            keywords: &[
                "ચઢવ\u{ac1}\u{a82}",
                "નિસરણી",
                "નિસરણીન\u{ac1}\u{a82} પગથિય\u{ac1}\u{a82}",
                "પગથિય\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סולם"),
            keywords: &["טיפוס", "לטפס", "סולם", "עלייה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सीढ\u{93c}ी"),
            keywords: &["चढ\u{93c}ना", "चढ\u{93c}ाव", "सीढ\u{93c}ी"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("ljestve"),
            keywords: &["ljestve", "penjanje", "prečka", "stuba"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("létra"),
            keywords: &["fok", "létra", "létrafok", "mászás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սանդուղք"),
            keywords: &["աստիճան", "բարձրանալ", "սանդուղք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tangga"),
            keywords: &["anak tangga", "panjat", "tangga"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("stigi"),
            keywords: &["klifra", "rim", "stigi", "trappa"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("scala"),
            keywords: &["arrampicarsi", "piolo", "scala", "scalino"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("はしご"),
            keywords: &["はしご", "ステッパー", "登る", "高所作業"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ondo"),
            keywords: &["anak ondo", "menek", "ondo"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კიბე"),
            keywords: &["აცოცება", "კიბე", "საფეხურები"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("саты"),
            keywords: &["баспалдақ", "міну", "саты", "қадам"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ជណ\u{17d2}ដើរ"),
            keywords: &["កា\u{17c6}ជណ\u{17d2}ដើរ", "ជណ\u{17d2}ដើរ", "ឡើង"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಏಣ\u{cbf}"),
            keywords: &[
                "ಏಣ\u{cbf}",
                "ಮ\u{cc6}ಟ\u{ccd}ಟ\u{cbf}ಲು",
                "ರಂಗ\u{ccd}",
                "ಹತ\u{ccd}ತು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("사다리"),
            keywords: &["계단", "단계", "사다리", "상승"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("निसण"),
            keywords: &["चढप", "निसण", "पा\u{902}वड\u{947}", "र\u{902}ग"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тепкич"),
            keywords: &["тепкич"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຂ\u{eb1}ນໃດ"),
            keywords: &[
                "ຂ\u{eb1}ນໃດ",
                "ຂ\u{eb1}\u{ec9}ນໄດ",
                "ປ\u{eb5}ນ",
                "ລ\u{eb9}ກຂ\u{eb1}\u{ec9}ນໄດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kopėčios"),
            keywords: &["kopėčios", "lipti", "žingsnis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kāpnes"),
            keywords: &["kāpnes", "kāpt", "pakāpiens", "šķērskoks"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("скалила"),
            keywords: &["искачување", "скала", "скалила"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കോണി"),
            keywords: &["കയറ\u{d41}ക", "കോണി", "കോണിപ\u{d4d}പടി", "പടി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("шат"),
            keywords: &["алхам", "шат", "шатны гишгүүр", "өгсөх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("शिडी"),
            keywords: &["चढण\u{947}", "पायरी", "वाजल\u{947}", "शिडी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tangga"),
            keywords: &["anak tangga", "daki", "jejak", "tangga"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လ\u{103e}ေကားရ\u{103e}င\u{103a}"),
            keywords: &[
                "ခြေလ\u{103e}မ\u{103a}း",
                "တက\u{103a}",
                "လ\u{103e}ေကားဆန\u{103a}",
                "လ\u{103e}ေကားရ\u{103e}င\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("stige"),
            keywords: &["klatre", "leider", "stige", "trapp", "trinn"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("भर\u{94d}\u{200d}याङ"),
            keywords: &[
                "चड\u{94d}न\u{941}",
                "चरण",
                "झर\u{94d}\u{200d}याङ",
                "भर\u{94d}\u{200d}याङ",
                "रङ",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("ladder"),
            keywords: &["klimmen", "ladder", "sport", "trede"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("stige"),
            keywords: &["klatre", "leider", "stige", "trapp", "trinn"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ନ\u{b3f}ଶ\u{b41}ଣ\u{b3f}"),
            keywords: &[
                "ଚଢ\u{b3f}ବ\u{b3e}",
                "ନ\u{b3f}ଶ\u{b41}ଣ\u{b3f}",
                "ନ\u{b3f}ଶ\u{b41}ଣ\u{b3f}ର ପ\u{b3e}ହ\u{b3e}ଚ",
                "ପ\u{b3e}ହ\u{b3e}ଚ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a4c}ੜੀ"),
            keywords: &[
                "ਕਦਮ",
                "ਚੜ\u{a4d}ਹਨਾ",
                "ਪ\u{a4c}ੜੀ",
                "ਪ\u{a4c}ੜੀ ਦਾ ਡ\u{a70}ਡਾ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Láda"),
            keywords: &["Klaimb", "Láda", "Ládá Stẹp", "Stẹp"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("drabina"),
            keywords: &["drabina", "szczebel", "wspinać się"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("زينه"),
            keywords: &["ختل", "زينه", "قدم", "پړاو"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("escada"),
            keywords: &["degrau", "escada", "subir"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["degrau", "escada", "subir", "trepar"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("scară"),
            keywords: &["scară", "treaptă", "urca"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-064"),
            keywords: &["E13-064"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("лестница"),
            keywords: &["лезть", "лестница", "перекладина", "ступень"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("چاڙهي"),
            keywords: &["رنگ", "چاڙهي", "چڙهو", "ڏاڪڻ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඉණ\u{dd2}මඟ"),
            keywords: &[
                "ඉණ\u{dd2}මං පෙත\u{dca}ත",
                "ඉණ\u{dd2}මඟ",
                "නග\u{dd2}න\u{dca}න",
                "ප\u{dd2}යවර",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("rebrík"),
            keywords: &["priečka", "rebrík", "stúpadlo"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("lestev"),
            keywords: &["klin", "lestev", "plezanje", "prečka"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("jaranjaro"),
            keywords: &["bood", "jaranjaro", "korid", "talaabo"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shkallë"),
            keywords: &["këmbë shkalle", "ngjit", "shkallare", "shkallë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мердевине"),
            keywords: &["мердевине", "пети се", "пречка", "степеник"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["мердевине"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("merdevine"),
            keywords: &["merdevine", "peti se", "prečka", "stepenik"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["merdevine"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("stege"),
            keywords: &["klätterstege", "klättra", "steg", "stege"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ngazi"),
            keywords: &["daraja", "kidato", "ngazi", "panda"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஏணி"),
            keywords: &["ஏணி", "ஏனிப\u{bcd}படி", "ஏறுதல\u{bcd}", "படி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("న\u{c3f}చ\u{c4d}చ\u{c46}న"),
            keywords: &[
                "ఎక\u{c4d}కడం",
                "న\u{c3f}చ\u{c4d}చ\u{c46}న",
                "మ\u{c46}ట\u{c4d}టు",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("บ\u{e31}นไดป\u{e35}น"),
            keywords: &[
                "ก\u{e49}าว",
                "ข\u{e31}\u{e49}นบ\u{e31}นได",
                "บ\u{e31}นไดป\u{e35}น",
                "ป\u{e35}น",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("merdiwan"),
            keywords: &["basgançak", "dyrmaşmak", "merdiwan"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tuʻunga"),
            keywords: &["kakaʻanga", "tuʻunga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("merdiven"),
            keywords: &["adım", "basamak", "merdiven", "tırmanış"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("драбина"),
            keywords: &["вилізти", "драбина", "перекладина", "сходинка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سیڑھی"),
            keywords: &["زینہ", "سیڑھی", "قدم", "چڑھنا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("narvon"),
            keywords: &["chiqish", "narvon", "pogʻona", "qadam", "shoti"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("thang"),
            keywords: &["bậc thang", "leo trèo", "nấc", "thang"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("梯"),
            keywords: &["梯", "梯級", "步", "爬"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("梯"),
            keywords: &["梯", "梯级", "步", "爬"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("梯子"),
            keywords: &["台阶", "梯子", "梯级", "横档", "爬"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("梯子"),
            keywords: &["梯子", "橫木", "爬", "踩"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ilada"),
            keywords: &["climb", "ilada", "ladder", "rung", "step"],
        },
    ],
};
