#[doc = "🔇"]
pub const MUTED_SPEAKER: crate::Emoji = crate::Emoji {
    glyph: "🔇",
    codepoint: "1F507",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "muted speaker",
    group: "Objects",
    subgroup: "sound",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("luidspreker af"),
            keywords: &["demp", "luidspreker", "luidspreker af", "stil", "volume"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ስፒከር ጠፍቷል"),
            keywords: &["ስፒከር", "ስፒከር ጠፍቷል", "ዝም ያለ", "ድምፀ ከል", "ጸጥታ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ممنوع الحديث"),
            keywords: &["سماعة وعلامة إلغاء", "ممنوع الحديث", "هدوء"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বন\u{9cd}ধ স\u{9cd}পীক\u{9be}ৰ"),
            keywords: &["নিঃশব\u{9cd}দ", "নীৰৱ", "বন\u{9cd}ধ", "স\u{9cd}পীক\u{9be}ৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("səsucaldan sönülüdür"),
            keywords: &[
                "sakit",
                "səs",
                "səssiz",
                "səsucaldan",
                "səsucaldan sönülüdür",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("без гуку"),
            keywords: &["без гуку", "бязгучнасць", "гучнасць", "дынамік", "ціха"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Изключен високоговорител"),
            keywords: &[
                "Изключен високоговорител",
                "високоговорител",
                "изключен",
                "сила на звука",
                "тих",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9cd}পিক\u{9be}র নিরব"),
            keywords: &[
                "আওয\u{9bc}\u{9be}জ",
                "নিঃশব\u{9cd}দ",
                "নীরব",
                "শ\u{9be}ন\u{9cd}ত",
                "স\u{9cd}পিক\u{9be}র",
                "স\u{9cd}পিক\u{9be}র নিরব",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("mut"),
            keywords: &["didrouz", "mut", "son"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zvuk isključen"),
            keywords: &["jačina zvuka", "nečujno", "zvuk isključen"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("altaveu desactivat"),
            keywords: &[
                "altaveu",
                "altaveu desactivat",
                "en silenci",
                "silenciar",
                "silenciat",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎡᏝᏪ ᏂᎬᏁᎸ"),
            keywords: &["ᎡᎶᏪᎢ", "ᎡᏝᏪ", "ᏂᎬᏁᎸ", "ᏙᏳ ᎡᏝᏪ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("vypnutý reproduktor"),
            keywords: &[
                "hlasitost",
                "reproduktor",
                "tichý",
                "vypnutý reproduktor",
                "ztlumený",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("seinydd wedi’i ddiffodd"),
            keywords: &["mud", "sain", "seinydd wedi’i ddiffodd", "tawelwch"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("højttaler fra"),
            keywords: &["højttaler", "højttaler fra", "lyd fra", "lydløs", "stille"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("durchgestrichener Lautsprecher"),
            keywords: &["durchgestrichener Lautsprecher", "stummgeschaltet"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ηχείο σε σίγαση"),
            keywords: &["αθόρυβο", "ηχείο", "ηχείο σε σίγαση", "σίγαση", "σιωπή"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("muted speaker"),
            keywords: &["mute", "muted speaker", "quiet", "silent", "speaker"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("altavoz silenciado"),
            keywords: &[
                "altavoz",
                "altavoz con marca de cancelación",
                "altavoz silenciado",
                "mute",
                "silencio",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("bocina silenciada"),
            keywords: &[
                "bocina selenciada",
                "bocina silenciada",
                "silencio",
                "sin volumen",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("altavoz silenciado"),
            keywords: &["altavoz silenciado"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("vaigistatud kõlar"),
            keywords: &["heli", "kõlar", "vaigistatud kõlar", "vaikne"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bozgorailua itzalita"),
            keywords: &[
                "audio",
                "bolumen",
                "borgorailu",
                "bozgorailua itzalita",
                "desaktibatu",
                "isilarazi",
                "isilik",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بلندگوی خاموش"),
            keywords: &[
                "آرام",
                "بلندگو",
                "بلندگوی خاموش",
                "بی\u{200c}صدا",
                "ساکت",
                "میزان صدا",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("mykistetty kaiutin"),
            keywords: &[
                "hiljaa",
                "kaiutin",
                "mykistetty kaiutin",
                "mykistys",
                "äänenvoimakkuus",
                "äänetön",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("naka-off ang speaker"),
            keywords: &[
                "mute",
                "naka-mute",
                "naka-off ang speaker",
                "silent",
                "speaker",
                "tahimik",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("doyvdur hátalari"),
            keywords: &["doyvdur", "doyvt", "einki ljóð", "hátalari", "ljóðleyst"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("muet"),
            keywords: &["muet", "silence", "son"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("son coupé"),
            keywords: &["enceinte", "haut-parleur", "silence", "son", "son coupé"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("callaire maothaithe"),
            keywords: &[
                "balbh",
                "callaire ar ceal",
                "callaire balbhaithe",
                "callaire maothaithe",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("glaodhaire mùchte"),
            keywords: &["glaodhaire", "glaodhaire mùchte", "mùch", "sàmhach", "tost"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("altofalante desactivado"),
            keywords: &[
                "altofalante",
                "altofalante desactivado",
                "silencio",
                "volume",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}પીકર બ\u{a82}ધ"),
            keywords: &[
                "ક\u{ac3}પા કરી શા\u{a82}ત રહો",
                "બોલશો નહી\u{a82}",
                "રદ કર\u{ac7}લા ચિહ\u{acd}ન સાથ\u{ac7}ન\u{ac1}\u{a82} સ\u{acd}પીકર",
                "શા\u{a82}ત",
                "સ\u{acd}પીકર બ\u{a82}ધ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mai magana da aka yiwa shiru"),
            keywords: &[
                "mai magana",
                "mai magana da aka yiwa shiru",
                "mai shiru",
                "shiru",
                "yi shiru",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("רמקול מושתק"),
            keywords: &["ווליום", "מושתק", "רמקול", "שקט"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("म\u{94d}य\u{942}ट किया स\u{94d}पीकर"),
            keywords: &[
                "मौन",
                "म\u{94d}य\u{942}ट",
                "म\u{94d}य\u{942}ट किया स\u{94d}पीकर",
                "शा\u{902}त",
                "स\u{94d}पीकर",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("isključen zvučnik"),
            keywords: &[
                "glasnoća",
                "isključen zvuk",
                "isključen zvučnik",
                "utišano",
                "zvučnik",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("elnémított hangszóró"),
            keywords: &[
                "csendes",
                "elnémított hangszóró",
                "hangerő",
                "hangszóró",
                "néma",
                "némított",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բարձրախոսն անջատված է"),
            keywords: &[
                "անջատել ձայնը",
                "բարձրախոս",
                "բարձրախոսն անջատված է",
                "լուռ",
                "հանգիստ",
                "ձայն",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("speaker mati"),
            keywords: &["bisu", "diam", "senyap", "speaker", "speaker mati"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("òkwù okwu emere-ògbì"),
            keywords: &[
                "ekwughị okwu",
                "nwayọ",
                "ogbì",
                "òkwù okwu",
                "òkwù okwu emere-ògbì",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hljóðlaus hátalari"),
            keywords: &["ekki tala", "hljóðlaus hátalari", "hátalari", "þögn"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("altoparlante disattivato"),
            keywords: &[
                "altoparlante barrato",
                "altoparlante disattivato",
                "silenzio",
                "suono disattivato",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("スピーカー消音"),
            keywords: &["スピーカー", "スピーカー消音", "ミュート", "消音", "音無し"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("speaker bisu"),
            keywords: &["anteng", "bisu", "meneng", "speaker"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დინამიკი გამორთულია"),
            keywords: &[
                "დადუმება",
                "დინამიკი",
                "დინამიკი გამორთულია",
                "სიჩუმე",
                "სიწყნარე",
                "ხმა",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("asusam"),
            keywords: &["asusam"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("динамикті өшіру"),
            keywords: &[
                "динамик",
                "динамикті өшіру",
                "дыбысы өшірілген динамик",
                "дыбысыз",
                "тыныш",
                "үнсіз",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("højttaler fra"),
            keywords: &[
                "højttaler",
                "højttaler fra",
                "lyd fra",
                "lydstyrke",
                "stille",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បាសមានឆ\u{17d2}ន\u{17bc}តក\u{17d2}រហម (ប\u{17b7}ទសម\u{17d2}លេង)"),
            keywords: &[
                "បាសប\u{17b7}ទ",
                "បាសមានឆ\u{17d2}ន\u{17bc}តក\u{17d2}រហម (ប\u{17b7}ទសម\u{17d2}លេង)",
                "ប\u{17b7}ទ",
                "ស\u{17d2}ងាត\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{ccd}ಪೀಕರ\u{ccd} ಆಫ\u{ccd}"),
            keywords: &[
                "ದಯವ\u{cbf}ಟ\u{ccd}ಟು ನ\u{cbf}ಶ\u{ccd}ಯಬ\u{ccd}ದ",
                "ನ\u{cbf}ಶ\u{ccd}ಯಬ\u{ccd}ದ",
                "ರದ\u{ccd}ದುಗೊಳ\u{cbf}ಸುವ\u{cbf}ಕ\u{cc6} ಗುರುತ\u{cbf}ನೊಂದ\u{cbf}ಗ\u{cc6} ಸ\u{ccd}ಪೀಕರ\u{ccd}",
                "ಸ\u{ccd}ಪೀಕರ\u{ccd} ಆಫ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("무음"),
            keywords: &["무음", "소리 끄기", "소리 없음"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मोनो स\u{94d}पिकर"),
            keywords: &["मोनो", "शा\u{902}त", "शा\u{902}तताय", "स\u{94d}पिकर"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("колонка өчүк"),
            keywords: &["акырын", "колонка", "колонка өчүк", "тынч", "үнсүз"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Lautsprecher op lautlos"),
            keywords: &[
                "Lautsprecher",
                "Lautsprecher op lautlos",
                "keen Toun",
                "lautlos",
                "roueg",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{eb4}ດລຳໂພງ"),
            keywords: &["ປ\u{eb4}ດ", "ປ\u{eb4}ດລຳໂພງ", "ລຳໂພງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("garsiakalbis išjungtas"),
            keywords: &[
                "garsiakalbis",
                "garsiakalbis išjungtas",
                "garsumas",
                "nutildytas",
                "tylus",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("izslēgts skaļrunis"),
            keywords: &[
                "bez skaņas",
                "izslēgts",
                "kluss",
                "klusums",
                "skaļrunis",
                "skaļums",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tukuoro whakangū"),
            keywords: &["hū", "ngū", "tukuoro", "tukuoro whakangū"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("исклучен звучник"),
            keywords: &["глас", "звук", "звучник", "исклучен", "тивко"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d4d}പീക\u{d4d}കർ ഓഫ\u{d4d}"),
            keywords: &[
                "സംസ\u{d3e}രം പ\u{d3e}ടില\u{d4d}ല",
                "സംസ\u{d3e}രിക\u{d4d}കര\u{d41}ത\u{d4d}",
                "സ\u{d4d}പീക\u{d4d}കർ ഓഫ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("чанга яригч хаалттай"),
            keywords: &[
                "хаалттай",
                "хаалттай чанга яригч",
                "чанга яригч",
                "чанга яригч хаалттай",
                "чимээгүй",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{94d}पीकर ब\u{902}द"),
            keywords: &[
                "ब\u{902}द",
                "ब\u{902}द क\u{947}ल\u{947}ला स\u{94d}पीकर",
                "बोल\u{942} नय\u{947}",
                "शा\u{902}त रहा",
                "स\u{94d}पीकर",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pembesar suara dimatikan"),
            keywords: &[
                "pembesar suara",
                "pembesar suara dimatikan",
                "redam",
                "senyap",
                "tenang",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("muted ta ’ l-ispiker"),
            keywords: &[
                "kwieta",
                "muted ta ’ l-ispiker",
                "mutes",
                "siekta",
                "spiker",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စပ\u{102e}ကာ ပ\u{102d}တ\u{103a}"),
            keywords: &[
                "စပ\u{102e}ကာ",
                "စပ\u{102e}ကာ ပ\u{102d}တ\u{103a}",
                "ဆ\u{102d}တ\u{103a}ငြ\u{102d}မ\u{103a}ခြင\u{103a}း",
                "တ\u{102d}တ\u{103a}ဆ\u{102d}တ\u{103a}ခြင\u{103a}း",
                "အသ\u{1036}ပ\u{102d}တ\u{103a}",
                "အသ\u{1036}ပ\u{102d}တ\u{103a}ထားသည\u{1037}\u{103a} စပ\u{102e}ကာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("dempet høyttaler"),
            keywords: &[
                "dempet",
                "dempet høyttaler",
                "høyttaler med strek over",
                "ingen prating",
                "stille",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("म\u{94d}य\u{941}ट गरिएको स\u{94d}पिकर"),
            keywords: &[
                "मौन",
                "म\u{94d}य\u{941}ट",
                "म\u{94d}य\u{941}ट गरिएको स\u{94d}पिकर",
                "शान\u{94d}त",
                "स\u{94d}पिकर",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("speaker uit"),
            keywords: &["dempen", "luidspreker", "speaker uit", "stil", "volume"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("dempa høgtalar"),
            keywords: &[
                "dempa",
                "dempa høgtalar",
                "høgtalar med strek over",
                "inga prating",
                "stille",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ମ\u{b4d}ୟ\u{b41}ଟ\u{b4d}\u{200c} ହୋଇଥ\u{b3f}ବ\u{b3e} ସ\u{b4d}ପ\u{b3f}କର\u{b4d}\u{200c}",
            ),
            keywords: &[
                "କଥ\u{b3e} ନକହ\u{b3f}ବ\u{b3e}",
                "ଦୟ\u{b3e}କର\u{b3f} ଶ\u{b3e}ନ\u{b4d}ତ ର\u{b41}ହନ\u{b4d}ତ\u{b41}",
                "ବ\u{b3e}ତ\u{b3f}ଲ\u{b4d} ଚ\u{b3f}ହ\u{b4d}ନ ସହ\u{b3f}ତ ସ\u{b4d}ପ\u{b3f}କର\u{b4d}",
                "ମ\u{b4d}ୟ\u{b41}ଟ\u{b4d}\u{200c} ହୋଇଥ\u{b3f}ବ\u{b3e} ସ\u{b4d}ପ\u{b3f}କର\u{b4d}\u{200c}",
                "ଶ\u{b3e}ନ\u{b4d}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a70}ਦ ਸਪੀਕਰ"),
            keywords: &[
                "ਕਿਰਪਾ ਸ\u{a3c}ਾ\u{a02}ਤ",
                "ਬ\u{a4b}ਲ\u{a4b} ਨਾ",
                "ਬ\u{a70}ਦ ਸਪੀਕਰ",
                "ਰ\u{a71}ਦ ਕਰਨ ਦ\u{a47} ਨਿਸ\u{a3c}ਾਨ ਨਾਲ ਸਪੀਕਰ",
                "ਸ\u{a3c}ਾ\u{a02}ਤ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("خاموش کیتا سپیکر"),
            keywords: &[
                "آواز بند کرنا",
                "خاموش",
                "خاموش کیتا سپیکر",
                "سپیکر",
                "چ\u{64f}پ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Laúdspíka Wé Nọ\u{301} De Tọk"),
            keywords: &[
                "Kwáyẹt",
                "Laúdspíka Wé Nọ\u{301} De Tọk",
                "Miut",
                "Saílẹnt",
                "Spíka",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wyciszony głośnik"),
            keywords: &[
                "cicho",
                "cisza",
                "głośnik",
                "głośność",
                "wyciszony głośnik",
                "wyciszyć",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ګونګ شوی سپیکر"),
            keywords: &["سپيکر", "غلی", "چپ", "ګونګ", "ګونګ شوی سپیکر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("alto-falante silenciado"),
            keywords: &[
                "alto-falante",
                "alto-falante silenciado",
                "mudo",
                "quieto",
                "silenciar",
                "silêncio",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("altifalante desligado"),
            keywords: &[
                "altifalante",
                "altifalante desligado",
                "sem som",
                "silencioso",
                "silêncio",
                "volume",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("chʼin altavoz"),
            keywords: &["chʼin altavoz"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("difuzor fără sunet"),
            keywords: &["difuzor fără sunet", "fără sunet", "liniște", "sonor tăiat"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-707"),
            keywords: &["E10-707"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("без звука"),
            keywords: &[
                "без звука",
                "громкость",
                "звук",
                "молчание",
                "тихо",
                "тишина",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("indangururamajwi yacecekeshejwe"),
            keywords: &[
                "gicecetse",
                "gituje",
                "gucekekesha",
                "indangururamajwi",
                "indangururamajwi yacecekeshejwe",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("آوازبند ڪيل اسپيڪر"),
            keywords: &["آواز بند ڪيل، خاموش، ماٺ، اسپيڪر", "آوازبند ڪيل اسپيڪر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some(
                "ස\u{dca}ප\u{dd3}කරය ක\u{dca}\u{200d}ර\u{dd2}ය\u{dcf}ව\u{dd2}රහ\u{dd2}තය\u{dd2}",
            ),
            keywords: &[
                "න\u{dd2}හඬ",
                "ශබ\u{dca}ද නැත\u{dd2}",
                "ස\u{dca}ප\u{dd3}කරය",
                "ස\u{dca}ප\u{dd3}කරය ක\u{dca}\u{200d}ර\u{dd2}ය\u{dcf}ව\u{dd2}රහ\u{dd2}තය\u{dd2}",
                "හඬ පර\u{dd2}ම\u{dcf}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("vypnutý reproduktor"),
            keywords: &["hlasitosť", "reproduktor", "stlmený", "tichý", "vypnutý"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ugasnjen zvočnik"),
            keywords: &[
                "brez zvoka",
                "glasnost",
                "tiho",
                "ugasnjen zvočnik",
                "zvočnik",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("sameecad la aamusiiyay"),
            keywords: &[
                "aamusan",
                "aamusiin",
                "aan shanqadh lahayn",
                "sameecad",
                "sameecad la aamusiiyay",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("altoparlant joaktiv"),
            keywords: &[
                "altoparlant",
                "altoparlant joaktiv",
                "i heshtur",
                "pa zë",
                "volum",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("искључен звучник"),
            keywords: &["звучник", "искључен звучник", "искључено", "утишано"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["искључен звучник"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("isključen zvučnik"),
            keywords: &["isključen zvučnik", "isključeno", "utišano", "zvučnik"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["isključen zvučnik"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("avstängd högtalare"),
            keywords: &["avstängd högtalare", "tyst"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("spika imezimwa"),
            keywords: &["kimya", "sauti", "spika", "spika imezimwa", "zima"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஸ\u{bcd}ப\u{bc0}க\u{bcd}கர\u{bcd} ஆஃப\u{bcd}"),
            keywords: &[
                "அமைதி",
                "சைலன\u{bcd}ஸ\u{bcd}",
                "நிசப\u{bcd}தம\u{bcd}",
                "ஸ\u{bcd}ப\u{bc0}க\u{bcd}கர\u{bcd} ஆஃப\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c4d}ప\u{c40}కర\u{c4d} ఆఫ\u{c4d}"),
            keywords: &[
                "వ\u{c3e}ల\u{c4d}యూమ\u{c4d} మ\u{c4d}యూట\u{c4d}\u{200c}ల\u{c4b} ఉంద\u{c3f} చ\u{c3f}హ\u{c4d}నం",
                "శబ\u{c4d}దం చ\u{c47}యవద\u{c4d}దు చ\u{c3f}హ\u{c4d}నం",
                "స\u{c4d}ప\u{c40}కర\u{c4d} ఆఫ\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("баландгӯяки хомӯш"),
            keywords: &["баландгӯяк", "баландгӯяки хомӯш", "бесадо кардан", "хомӯш"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ไม\u{e48}ใช\u{e49}เส\u{e35}ยง"),
            keywords: &[
                "ป\u{e34}ดเส\u{e35}ยง",
                "โปรดเง\u{e35}ยบ",
                "ไม\u{e48}ใช\u{e49}เส\u{e35}ยง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("sesi ýapyk dinamik"),
            keywords: &[
                "dinamik",
                "dym-dyrs",
                "sesi ýapyk dinamik",
                "sessiz",
                "ýuwaş",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("leʻo matafa"),
            keywords: &["leʻo matafa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ses kapalı"),
            keywords: &[
                "iptal işaretli hoparlör",
                "lütfen sessiz olun",
                "ses kapalı",
                "sessiz olun",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئۈنسىز ياڭراتقۇ"),
            keywords: &["ئۈنسىز", "تىنچ", "جىم", "ياڭراتقۇ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("заглушений динамік"),
            keywords: &[
                "беззвучно",
                "динамік",
                "заглушений динамік",
                "звук динаміка вимкнено",
                "нечутно",
                "тихо",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اسپیکر بند"),
            keywords: &["آواز", "اسپیکر", "اسپیکر بند", "خاموشی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ovozsiz"),
            keywords: &[
                "karnay",
                "ovoz balandligi",
                "ovozsiz",
                "sassis",
                "shovqinsiz",
                "tinch",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tắt loa"),
            keywords: &["cái loa", "im lặng", "không ồn ào", "tắt loa", "tắt tiếng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("oparlër buñ noppiloo"),
            keywords: &["cellaaral", "noppi", "oparlër buñ noppiloo", "waxkat"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ispikha esicuthiweyo"),
            keywords: &[
                "esithuleyo",
                "ethuleyo",
                "ispikha",
                "ispikha esicuthiweyo",
                "uthuleyo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Gbohungbohun ti ko Sọrọ"),
            keywords: &["Gbohungbohun ti ko Sọrọ", "dákè", "dáké", "gboùngboùn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("靜音喇叭"),
            keywords: &["喇叭", "安靜", "沉默", "靜音", "靜音喇叭"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("静音喇叭"),
            keywords: &["喇叭", "安静", "沉默", "静音", "静音喇叭"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("已静音的扬声器"),
            keywords: &[
                "安静",
                "已静音的扬声器",
                "扬声器",
                "扬声器关闭",
                "无声",
                "静音",
            ],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("關掉喇叭"),
            keywords: &["關掉喇叭", "静音"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["關掉喇叭", "靜音"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukucisha isipikha"),
            keywords: &["isipikha", "ukucisha", "ukuthula", "umsindo"],
        },
    ],
};
#[doc = "🔈"]
pub const SPEAKER_LOW_VOLUME: crate::Emoji = crate::Emoji {
    glyph: "🔈",
    codepoint: "1F508",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "speaker low volume",
    group: "Objects",
    subgroup: "sound",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("luidspreker sag"),
            keywords: &["luidspreker", "sag", "volume"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ስፒከር"),
            keywords: &["ስፒከር", "ድምፅ መጠን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}صوت سماعة منخفض"),
            keywords: &["صوت منخفض", "مكب\u{651}ر صوت", "\u{202b}صوت سماعة منخفض"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("স\u{9cd}পীক\u{9be}ৰৰ স\u{9cd}বৰ কম"),
            keywords: &[
                "ম\u{9c3}দ\u{9c1}",
                "স\u{9cd}পীক\u{9be}ৰৰ স\u{9cd}বৰ কম",
                "স\u{9cd}পীক\u{9be}ৰৰ স\u{9cd}বৰ ম\u{9c3}দ\u{9c1}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("səsucaldan"),
            keywords: &["səs", "səsucaldan"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("дынамік"),
            keywords: &["гучнасць", "дынамік"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("високоговорител със слаб звук"),
            keywords: &[
                "високоговорител",
                "високоговорител със слаб звук",
                "ниска сила на звука",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("কম আওয\u{9bc}\u{9be}জে স\u{9cd}পিক\u{9be}র"),
            keywords: &["কম আওয\u{9bc}\u{9be}জে স\u{9cd}পিক\u{9be}র", "নরম"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zvučnik tiho"),
            keywords: &["blago", "zvučnik tiho"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("altaveu amb el volum baix"),
            keywords: &["altaveu amb el volum baix", "baix", "volum suau"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏬᏂᏍᎩ ᎡᎳᏗᏜ ᎠᏍᏓᏱᏗᏍᏗ"),
            keywords: &["ᎦᏬᏂᏍᎩ ᎡᎳᏗᏜ ᎠᏍᏓᏱᏗᏍᏗ", "ᏩᏂᎨ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("tiše hrající reproduktor"),
            keywords: &["mírný", "tichý", "tiše hrající reproduktor", "tlumený"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("seinydd"),
            keywords: &["seinydd", "sŵn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("højttaler lav lydstyrke"),
            keywords: &["højttaler lav lydstyrke", "lav"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Lautsprecher mit geringer Lautstärke"),
            keywords: &["Lautsprecher mit geringer Lautstärke", "eingeschaltet"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ηχείο σε χαμηλή ένταση"),
            keywords: &["ένταση ήχου", "ηχείο σε χαμηλή ένταση", "χαμηλή ένταση"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("speaker low volume"),
            keywords: &["soft", "speaker low volume"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["low", "quiet", "soft", "speaker", "volume"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("altavoz a volumen bajo"),
            keywords: &["altavoz a volumen bajo", "volumen bajo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("bocina a volumen bajo"),
            keywords: &["bocina a volumen bajo"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("vaikse heliga kõlar"),
            keywords: &["heli", "vaikse heliga kõlar"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bozgorailua bolumen txikian"),
            keywords: &["bolumen", "bozgorailua bolumen txikian"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بلندگو با صدای کم"),
            keywords: &["بلندگو با صدای کم", "صدای کم", "کم"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hiljainen kaiutin"),
            keywords: &["alhainen", "hiljainen kaiutin", "äänenvoimakkuus"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("speaker na mahina ang sound"),
            keywords: &["speaker", "speaker na mahina ang sound", "volume"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("lág ljóðstyrki á hátalara"),
            keywords: &["hátalari", "ljóðstyrki", "lág", "lág ljóðstyrki á hátalara"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("volume des enceintes faible"),
            keywords: &["son", "volume des enceintes faible"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("volume faible"),
            keywords: &["son bas", "volume bas", "volume faible"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("callaire íslithe"),
            keywords: &["callaire", "callaire íslithe"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("glaodhaire ’s fhuaim ìseal"),
            keywords: &[
                "fuaim",
                "glaodhaire a’ cur a-mach fuaim ìseal",
                "glaodhaire ’s fhuaim ìseal",
                "ìseal",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("altofalante"),
            keywords: &["altofalante", "volume"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}પીકર નીચ\u{ac1}\u{a82} વૉલ\u{acd}ય\u{ac2}મ"),
            keywords: &[
                "નરમ",
                "સ\u{acd}પીકર",
                "સ\u{acd}પીકર નીચ\u{ac1}\u{a82} વૉલ\u{acd}ય\u{ac2}મ",
                "સ\u{acd}પીકર લો વોલ\u{acd}ય\u{ac1}મ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("sifika ƙarfin murya na ƙasa"),
            keywords: &["maras ƙarfi", "sifika ƙarfin murya na ƙasa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ווליום נמוך"),
            keywords: &["ווליום נמוך", "ווליום נמוך של הרמקול", "נמוך"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("कम वॉल\u{94d}य\u{942}म स\u{94d}पीकर"),
            keywords: &["कम वॉल\u{94d}य\u{942}म स\u{94d}पीकर", "धीमा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("stišan zvučnik"),
            keywords: &["stišan zvučnik", "tiho"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("hangszóró"),
            keywords: &["hangerő", "hangszóró"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բարձրախոս"),
            keywords: &["բարձրախոս", "ձայն", "ձայնի ուժգնություն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("volume speaker rendah"),
            keywords: &["lembut", "volume speaker rendah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("òkwù okwu ụhàraụdà dị ala"),
            keywords: &["nrò", "òkwù okwu ụhàraụdà dị ala"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("lágvær hátalari"),
            keywords: &["hljóðstyrkur", "hátalari", "lágvær hátalari"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("altoparlante a volume basso"),
            keywords: &[
                "altoparlante a basso volume",
                "altoparlante a volume basso",
                "basso volume",
                "volume basso",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("スピーカー"),
            keywords: &["スピーカー", "ボリューム", "音量"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("volume lirih speaker"),
            keywords: &["alus", "volume lirih speaker"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დინამიკი"),
            keywords: &["დინამიკი", "ხმა"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: None,
            keywords: &["imesli"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("динамик"),
            keywords: &["динамик", "дыбыс деңгейі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("højttaler"),
            keywords: &["højttaler", "lydstyrke"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បាស\u{200b}"),
            keywords: &["បាស\u{200b}", "សម\u{17d2}លេង"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{ccd}ಪೀಕರ\u{ccd}"),
            keywords: &[
                "ಲ\u{ccc}ಡ\u{ccd}\u{200c}ಸ\u{ccd}ಪೀಕರ\u{ccd}",
                "ಸ\u{ccd}ಪೀಕರ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("스피커"),
            keywords: &["소리", "소리 있음", "스피커"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("कमी आवाजाचो स\u{94d}पिकर"),
            keywords: &["कमी आवाजाचो स\u{94d}पिकर", "मोव"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("колонка"),
            keywords: &["колонка", "үн көлөмү"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Lautsprecher op lues agestallt"),
            keywords: &["Lautsprecher op lues agestallt", "lues"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລຳໂພງ"),
            keywords: &["ລະດ\u{eb1}ບສຽງ", "ລຳໂພງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("tylus garsiakalbis"),
            keywords: &["tylus", "tylus garsiakalbis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("skaļrunis"),
            keywords: &["kluss", "mazs skaļruņa skaļums", "skaļrunis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tukuoro kahaoro pāpaku"),
            keywords: &["pāpaku", "tukuoro kahaoro pāpaku"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("звучник"),
            keywords: &["глас", "звук", "звучник"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ക\u{d41}റഞ\u{d4d}ഞ ശബ\u{d4d}\u{200c}ദമ\u{d41}ള\u{d4d}ള സ\u{d4d}\u{200c}പീക\u{d4d}കർ",
            ),
            keywords: &[
                "ക\u{d41}റഞ\u{d4d}ഞ ശബ\u{d4d}\u{200c}ദമ\u{d41}ള\u{d4d}ള സ\u{d4d}\u{200c}പീക\u{d4d}കർ",
                "ല\u{d57}ഡ\u{d4d}സ\u{d4d}പീക\u{d4d}കർ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("чанга яригчийн дууны түвшин нам"),
            keywords: &["зөөлөн", "чанга яригчийн дууны түвшин нам"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{94d}पीकर"),
            keywords: &["कमी", "स\u{94d}पीकर", "स\u{94d}पीकरचा आवाज कमी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kelantangan rendah pembesar suara"),
            keywords: &["kelantangan rendah pembesar suara", "perlahan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("speaker volum baxx"),
            keywords: &["artab", "speaker volum baxx"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စပ\u{102e}ကာ အသ\u{1036}တ\u{102d}\u{102f}း"),
            keywords: &[
                "စပ\u{102e}ကာ",
                "စပ\u{102e}ကာ အသ\u{1036}တ\u{102d}\u{102f}း",
                "အတ\u{102d}\u{102f}းအကျယ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("høyttaler med lavt volum"),
            keywords: &["høyttaler med lavt volum", "lav", "lyd", "ropert"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("सानो भोल\u{94d}य\u{941}मको स\u{94d}पिकर"),
            keywords: &["सफ\u{94d}ट", "सानो भोल\u{94d}य\u{941}मको स\u{94d}पिकर"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("speaker"),
            keywords: &["speaker", "volume"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("høgtalar med lågt volum"),
            keywords: &["høgtalar med lågt volum", "lyd", "låg", "ropert"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "କମ\u{b4d}\u{200c} ଧ\u{b4d}ୱନ\u{b3f} ବ\u{b3f}ଶ\u{b3f}ଷ\u{b4d}ଟ ସ\u{b4d}ପ\u{b3f}କର\u{b4d}\u{200c}",
            ),
            keywords: &[
                "କମ\u{b4d}\u{200c} ଧ\u{b4d}ୱନ\u{b3f} ବ\u{b3f}ଶ\u{b3f}ଷ\u{b4d}ଟ ସ\u{b4d}ପ\u{b3f}କର\u{b4d}\u{200c}",
                "ଲ\u{b3e}ଉଡ\u{b4d}\u{200c}ସ\u{b4d}ପ\u{b3f}କର\u{b4d}",
                "ସ\u{b4d}ପ\u{b3f}କର\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਪੀਕਰ ਘ\u{a71}ਟ ਵ\u{a4c}ਲਿਊਮ"),
            keywords: &[
                "ਸਪੀਕਰ",
                "ਸਪੀਕਰ ਘ\u{a71}ਟ ਵ\u{a4c}ਲਿਅਮ",
                "ਸਪੀਕਰ ਘ\u{a71}ਟ ਵ\u{a4c}ਲਿਊਮ",
                "ਹਲਕੀ ਆਵਾਜ\u{a3c}",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہولی واج آلا اسپیکر"),
            keywords: &["نرم", "ہولی واج آلا اسپیکر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Laúdspíka Ló Vọ\u{301}lium"),
            keywords: &["Laúdspíka Ló Vọ\u{301}lium", "Sọft"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("niska głośność głośnika"),
            keywords: &["głośność", "niska głośność głośnika"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د سپیکر ټیټ غږ"),
            keywords: &["د سپیکر ټیټ غږ", "نرم"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("alto-falante com volume baixo"),
            keywords: &["alto-falante com volume baixo", "volume baixo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("altifalante baixo"),
            keywords: &["altifalante baixo", "volume"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("altavoz pisi chanrawan"),
            keywords: &["altavoz pisi chanrawan"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("volum scăzut al difuzorului"),
            keywords: &["sunet slab", "sunet încet", "volum scăzut al difuzorului"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-708"),
            keywords: &["E10-708"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("низкая громкость"),
            keywords: &["громкость", "динамик", "звук", "низкая", "уровень"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("indangururamajwi ifite ubwirangire buri hasi"),
            keywords: &["cyoroshye", "indangururamajwi ifite ubwirangire buri hasi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اسپيڪر جو آواز گهٽ"),
            keywords: &["اسپيڪر جو آواز گهٽ", "نرم"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dca}ප\u{dd3}කරය"),
            keywords: &["ස\u{dca}ප\u{dd3}කරය", "හඬ පර\u{dd2}ම\u{dcf}ව"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("nízka hlasitosť"),
            keywords: &["nízka hlasitosť", "reproduktor"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zvočnik pri nizki glasnosti"),
            keywords: &["glasnost", "zvočnik pri nizki glasnosti"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("sameecad cod yar"),
            keywords: &["khafiif", "sameecad cod yar"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("altoparlant me zë të ulët"),
            keywords: &[
                "altoparlant",
                "altoparlant me zë të ulët",
                "volum i ulët",
                "zë i butë",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("звучник"),
            keywords: &["звучник", "тихо"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["звучник"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("zvučnik"),
            keywords: &["tiho", "zvučnik"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["zvučnik"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("högtalare"),
            keywords: &["högtalare", "högtalare med låg volym", "låg volym"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("spika"),
            keywords: &["sauti", "spika"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("sauti ya chini ya spika"),
            keywords: &["sauti", "sauti ya chini ya spika", "spika"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஸ\u{bcd}ப\u{bc0}க\u{bcd}கர\u{bcd}"),
            keywords: &[
                "சத\u{bcd}தம\u{bcd}",
                "பேசு",
                "ஸ\u{bcd}ப\u{bc0}க\u{bcd}கர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("తక\u{c4d}కువ శబ\u{c4d}దంత\u{c4b} స\u{c4d}ప\u{c40}కర\u{c4d}"),
            keywords: &[
                "తక\u{c4d}కువ శబ\u{c4d}దంత\u{c4b} స\u{c4d}ప\u{c40}కర\u{c4d}",
                "వ\u{c3e}ల\u{c4d}యూమ\u{c4d} ఉంద\u{c3f}",
                "వ\u{c3e}ల\u{c4d}యూమ\u{c4d} చ\u{c3f}హ\u{c4d}నం",
                "శబ\u{c4d}దం చ\u{c47}య\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("садои пасти баландгӯяк"),
            keywords: &["мулоим", "садои пасти баландгӯяк"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ลำโพงเส\u{e35}ยงเบา"),
            keywords: &["ลำโพง", "ลำโพงเส\u{e35}ยงเบา"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("pes sesli dinamik"),
            keywords: &["pes sesli dinamik", "ýumşak"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("leʻo siʻi"),
            keywords: &["leʻo siʻi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kısık ses"),
            keywords: &["kısık ses", "ses düzeyi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تۆۋەن ئۈنلۈك ياڭراتقۇ"),
            keywords: &["تۆۋەن ئۈنلۈك ياڭراتقۇ", "يۇمشاق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("низька гучність динаміка"),
            keywords: &["негучно", "низька гучність динаміка", "приглушено"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("دھیمی آواز نکالتے اسپیکر"),
            keywords: &["آواز", "اسپیکر", "دھیمی آواز نکالتے اسپیکر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("karnay"),
            keywords: &["karnay", "ovoz balandligi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("âm lượng loa thấp"),
            keywords: &["nhẹ", "âm lượng loa thấp"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("oparlër buy wax ndànk"),
            keywords: &["ndànk", "oparlër buy wax ndànk"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ivolyum esezantsi yespikha"),
            keywords: &["ezezantsi", "ivolyum esezantsi yespikha"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Gbohungbohun ti Ohun rẹ wa Labẹ"),
            keywords: &["Gbohungbohun ti Ohun rẹ wa Labẹ", "fẹ\u{301}lẹ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("低音量喇叭"),
            keywords: &["低音量喇叭", "柔軟"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("低音量喇叭"),
            keywords: &["低音量喇叭", "柔软"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("低音量的扬声器"),
            keywords: &["低音量的扬声器", "小声", "小音量", "扬声器", "轻声"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("喇叭"),
            keywords: &["喇叭"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("細聲喇叭"),
            keywords: &["細聲喇叭", "細聲｜喇叭"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ispikha"),
            keywords: &["ispikha", "umsindo"],
        },
    ],
};
#[doc = "🔉"]
pub const SPEAKER_MEDIUM_VOLUME: crate::Emoji = crate::Emoji {
    glyph: "🔉",
    codepoint: "1F509",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "speaker medium volume",
    group: "Objects",
    subgroup: "sound",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("luidspreker medium volume"),
            keywords: &[
                "klank",
                "klankgolf",
                "luidspreker",
                "luidspreker aan",
                "medium",
                "volume",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ስፒከር በርቷል"),
            keywords: &["ሞገድ", "ስፒከር", "ስፒከር በርቷል", "ዝቅ", "ድምፅ መጠን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("صوت معتدل"),
            keywords: &[
                "سماعة بصوت منخفض",
                "صوت معتدل",
                "صوت منخفض",
                "منخفض",
                "\u{202b}صوت سماعة متوسط",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("স\u{9cd}পীক\u{9be}ৰৰ স\u{9cd}বৰ মধ\u{9cd}যমীয\u{9bc}\u{9be}"),
            keywords: &[
                "মধ\u{9cd}যমীয\u{9bc}\u{9be}",
                "স\u{9cd}পীক\u{9be}ৰৰ স\u{9cd}বৰ মধ\u{9cd}যমীয\u{9bc}\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("səsucaldan aktivdir"),
            keywords: &["aşağı", "dalğa", "səs", "səsucaldan", "səsucaldan aktivdir"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ціха"),
            keywords: &["гучнасць", "дынамік", "нізкая", "ціха"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("високоговорител със средносилен звук"),
            keywords: &[
                "Включен високоговорител",
                "високоговорител",
                "високоговорител със средносилен звук",
                "сила на звука",
                "средносилен",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9cd}পিক\u{9be}র ম\u{9be}ঝ\u{9be}রি আওয\u{9bc}\u{9be}জ"),
            keywords: &[
                "ম\u{9be}ঝ\u{9be}রি",
                "স\u{9cd}পিক\u{9be}র ম\u{9be}ঝ\u{9be}রি আওয\u{9bc}\u{9be}জ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zvučnik srednja glasnoća"),
            keywords: &["srednje", "zvučnik srednja glasnoća"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("altaveu amb el volum mitjà"),
            keywords: &["altaveu amb el volum mitjà", "mitjà", "volum mitjà"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏬᏂᏍᎩ ᎠᏰᏟ ᎠᏍᏓᏱᏗᏍᏗ"),
            keywords: &["ᎠᏲᏟᎨ", "ᎦᏬᏂᏍᎩ ᎠᏰᏟ ᎠᏍᏓᏱᏗᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("středně hlasitý reproduktor"),
            keywords: &["hlasitý", "reproduktor", "středně", "tlampač"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("seinydd ymlaen"),
            keywords: &["isel", "seinydd ymlaen", "siarad", "ton"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("højttaler mellem lydstyrke"),
            keywords: &[
                "højtaler med en lydbølge",
                "højttaler medium volumen",
                "højttaler mellem lydstyrke",
                "lav volumen",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Lautsprecher mit mittlerer Lautstärke"),
            keywords: &["Lautsprecher mit mittlerer Lautstärke", "mittellaut"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ηχείο σε μέτρια ένταση"),
            keywords: &["ένταση ήχου", "ηχείο", "ηχείο σε μέτρια ένταση"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("speaker medium volume"),
            keywords: &["medium", "speaker medium volume"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("altavoz a volumen medio"),
            keywords: &[
                "altavoz a volumen medio",
                "altavoz con volumen medio",
                "medio",
                "volumen medio",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("bocina a volumen medio"),
            keywords: &["bocina a volumen medio"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("poolvalju heliga kõlar"),
            keywords: &["heli", "kõlar", "poolvalju heliga kõlar", "vaikne"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bozgorailua piztuta"),
            keywords: &[
                "baxu",
                "bolumen",
                "bozgorailu",
                "bozgorailua piztuta",
                "uhin",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بلندگو با صدای متعادل"),
            keywords: &[
                "بلندگو",
                "بلندگو با صدای متعادل",
                "صدا",
                "موج",
                "میانه",
                "نه کم نه زیاد",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kaiutin normaalilla äänenvoimakkuudella"),
            keywords: &[
                "kaiutin",
                "kaiutin normaalilla äänenvoimakkuudella",
                "äänenvoimakkuus",
                "äänet",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("speaker na katamtaman ang sound"),
            keywords: &[
                "naka-medium",
                "naka-on ang speaker",
                "speaker",
                "speaker na katamtaman ang sound",
                "volume",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("miðal ljóðstyrki á hátalara"),
            keywords: &[
                "hátalari",
                "ljóðstyrki",
                "miðal",
                "miðal ljóðstyrki á hátalara",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("volume des enceintes moyen"),
            keywords: &["son", "volume des enceintes moyen"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("volume moyen"),
            keywords: &["son moyen", "volume moyen"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("callaire fuaime ísle"),
            keywords: &["callaire fuaime ísle"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("glaodhaire ’s fhuaim mheadhanach"),
            keywords: &[
                "fuaim",
                "glaodhaire a’ cur a-mach fuaim mheadhanach",
                "glaodhaire ’s fhuaim mheadhanach",
                "meadhanach",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("altofalante activado"),
            keywords: &["altofalante", "altofalante activado", "baixo", "volume"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}પીકર મધ\u{acd}યમ વૉલ\u{acd}ય\u{ac2}મ"),
            keywords: &[
                "મધ\u{acd}યમ",
                "સ\u{acd}પીકર ચાલ\u{ac1}",
                "સ\u{acd}પીકર મધ\u{acd}યમ વૉલ\u{acd}ય\u{ac2}મ",
                "સ\u{acd}પીકર માધ\u{acd}યમ વોલ\u{acd}ય\u{ac1}મ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("sifika matsakaicin ƙarfin murya"),
            keywords: &["matsakaici", "sifika matsakaicin ƙarfin murya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ווליום בינוני"),
            keywords: &["בינוני", "ווליום בינוני", "ווליום בינוני של הרמקול"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{94d}पीकर मीडियम वॉल\u{94d}य\u{942}म"),
            keywords: &[
                "मध\u{94d}यम",
                "मीडियम",
                "स\u{94d}पीकर मीडियम वॉल\u{94d}य\u{942}म",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("srednje glasan zvučnik"),
            keywords: &["srednja glasnoća", "srednje glasan zvučnik"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("bekapcsolt hangszóró"),
            keywords: &["alacsony hangerő", "bekapcsolt hangszóró", "hangszóró"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բարձրախոսը միացված է"),
            keywords: &["ալիք", "բարձրախոս", "բարձրախոսը միացված է", "ձայն", "ցածր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("volume speaker medium"),
            keywords: &["medium", "volume speaker medium"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("òkwù okwu ụhàraụdà ndịna etiti"),
            keywords: &["etiti", "òkwù okwu ụhàraụdà ndịna etiti"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hátalari í gangi"),
            keywords: &["hljóðstyrkur", "hátalari", "hátalari í gangi", "lágt"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("altoparlante a volume intermedio"),
            keywords: &[
                "altoparlante a volume intermedio",
                "volume intermedio",
                "volume medio",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("スピーカー音量小"),
            keywords: &[
                "スピーカー",
                "スピーカー音量小",
                "ボリューム",
                "音量",
                "音量小",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("volume medium speaker"),
            keywords: &["medium", "volume medium speaker"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დინამიკი ჩართულია"),
            keywords: &["დინამიკი", "დინამიკი ჩართულია", "ტალღა", "ხმა"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: None,
            keywords: &["imesli"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("динамикті қосу"),
            keywords: &[
                "динамик",
                "динамикті қосу",
                "дыбыс деңгейі",
                "толқын",
                "төмен",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("højttaler til"),
            keywords: &["højtaler med en lydbølge", "højttaler til", "lav volumen"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បាសបើក"),
            keywords: &["បាសបើក", "បើក"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{ccd}ಪೀಕರ\u{ccd} ಆನ\u{ccd}"),
            keywords: &[
                "ಕಡ\u{cbf}ಮ\u{cc6}",
                "ಕಡ\u{cbf}ಮ\u{cc6} ವಾಲ\u{ccd}ಯ\u{cc2}ಮ\u{ccd}",
                "ಕಡ\u{cbf}ಮ\u{cc6} ವಾಲ\u{ccd}ಯ\u{cc2}ಮ\u{ccd}\u{200c}ನೊಂದ\u{cbf}ಗ\u{cc6} ಸ\u{ccd}ಪೀಕರ\u{ccd}",
                "ಸ\u{ccd}ಪೀಕರ\u{ccd} ಆನ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("스피커 소리 작게"),
            keywords: &["소리 작게", "소리 작음", "소리 줄이기", "스피커 소리 작게"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मध\u{94d}यम आवाजाचो स\u{94d}पिकर"),
            keywords: &["मध\u{94d}यम", "मध\u{94d}यम आवाजाचो स\u{94d}पिकर"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("колонка күйүк"),
            keywords: &["колонка", "колонка күйүк", "төмөн", "үн көлөмү"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Lautsprecher op mëttel agestallt"),
            keywords: &["Lautsprecher op mëttel agestallt", "mëttel"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເປ\u{eb5}ດລຳໂພງ"),
            keywords: &["ລຳໂພງ", "ເປ\u{eb5}ດ", "ເປ\u{eb5}ດລຳໂພງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vidutinio garso garsiakalbis"),
            keywords: &["vidutinio garso garsiakalbis", "vidutinis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ieslēgts skaļrunis"),
            keywords: &["ieslēgts skaļrunis", "vidējs", "vidējs skaļruņa skaļums"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tukuoro kahaoro waenga"),
            keywords: &["tukuoro kahaoro waenga", "waenga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("вклучен звучник"),
            keywords: &["вклучен звучник", "глас", "звук", "звучник"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "അധികം ഉച\u{d4d}ചത\u{d4d}തിലല\u{d4d}ല\u{d3e}ത\u{d4d}ത ശബ\u{d4d}\u{200c}ദമ\u{d41}ള\u{d4d}ള സ\u{d4d}\u{200c}പീക\u{d4d}കർ",
            ),
            keywords: &[
                "അധികം ഉച\u{d4d}ചത\u{d4d}തിലല\u{d4d}ല\u{d3e}ത\u{d4d}ത ശബ\u{d4d}\u{200c}ദം",
                "അധികം ഉച\u{d4d}ചത\u{d4d}തിലല\u{d4d}ല\u{d3e}ത\u{d4d}ത ശബ\u{d4d}\u{200c}ദമ\u{d41}ള\u{d4d}ള സ\u{d4d}\u{200c}പീക\u{d4d}കർ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("чанга яригчийн дууны түвшин дунд зэрэг"),
            keywords: &["дунд зэрэг", "чанга яригчийн дууны түвшин дунд зэрэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{94d}पीकर चाल\u{942}"),
            keywords: &[
                "मध\u{94d}यम",
                "स\u{94d}पीकर चाल\u{942}",
                "स\u{94d}पीकरचा आवाज मध\u{94d}यम",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kelantangan sederhana pembesar suara"),
            keywords: &["kelantangan sederhana pembesar suara", "sederhana"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("speaker volum medju"),
            keywords: &["medju", "speaker volum medju"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စပ\u{102e}ကာ ဖ\u{103d}င\u{1037}\u{103a}"),
            keywords: &[
                "စပ\u{102e}ကာ ဖ\u{103d}င\u{1037}\u{103a}",
                "အသ\u{1036} အလယ\u{103a}အလတ\u{103a}",
                "အသ\u{1036} အလယ\u{103a}အလတ\u{103a}ဖ\u{103d}င\u{1037}\u{103a}ထားသော စပ\u{102e}ကာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("høyttaler med middels volum"),
            keywords: &["høyttaler med middels volum", "lyd", "middels", "ropert"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("मध\u{94d}य भोल\u{94d}य\u{941}मको स\u{94d}पिकर"),
            keywords: &[
                "मध\u{94d}य भोल\u{94d}य\u{941}मको स\u{94d}पिकर",
                "मध\u{94d}यम",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("speaker aan"),
            keywords: &["speaker", "speaker aan"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("høgtalar med middels volum"),
            keywords: &["høgtalar med middels volum", "lyd", "middels", "ropert"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମଧ\u{b4d}ୟମ ଧରଣର ଧ\u{b4d}ୱନ\u{b3f} ସ\u{b4d}ପ\u{b3f}କର\u{b4d}\u{200c}"),
            keywords: &[
                "କମ\u{b4d}",
                "କମ\u{b4d} ଭଲ\u{b4d}ୟ\u{b41}ମ\u{b4d}",
                "କମ\u{b4d} ଭଲ\u{b4d}ୟ\u{b41}ମ\u{b4d} ସହ\u{b3f}ତ ସ\u{b4d}ପ\u{b3f}କର\u{b4d}",
                "ମଧ\u{b4d}ୟମ ଧରଣର ଧ\u{b4d}ୱନ\u{b3f} ସ\u{b4d}ପ\u{b3f}କର\u{b4d}\u{200c}",
                "ସ\u{b4d}ପ\u{b3f}କର\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਪੀਕਰ ਔਸਤ ਵ\u{a4c}ਲਿਊਮ"),
            keywords: &[
                "ਘ\u{a71}ਟ",
                "ਘ\u{a71}ਟ ਅਾਵਾਜ\u{a3c} ਨਾਲ ਸਪੀਕਰ",
                "ਘ\u{a71}ਟ ਆਵਾਜ\u{a3c}",
                "ਸਪੀਕਰ",
                "ਸਪੀਕਰ ਔਸਤ ਵ\u{a4c}ਲਿਊਮ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("درمیانی واج آلا اسپیکر"),
            keywords: &["درمیانہ", "درمیانی واج آلا اسپیکر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Laúdspíka Mídiúm Vọ\u{301}lium"),
            keywords: &["Laúdspíka Mídiúm Vọ\u{301}lium", "Mídiọm"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("średnia głośność głośnika"),
            keywords: &["średnia", "średnia głośność głośnika"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د سپیکر منځنی غږ"),
            keywords: &["د سپیکر منځنی غږ", "منځنی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("alto-falante com volume médio"),
            keywords: &["alto-falante com volume médio", "volume médio"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("altifalante médio"),
            keywords: &[
                "altifalante",
                "altifalante médio",
                "baixo",
                "onda sonora",
                "volume",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("altavoz chawpi chanrawan"),
            keywords: &["altavoz chawpi chanrawan"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("volum mediu al difuzorului"),
            keywords: &["sunet mediu", "volum mediu al difuzorului"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-709"),
            keywords: &["E10-709"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("средняя громкость"),
            keywords: &["громкость", "динамик", "звук", "средняя", "уровень"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("indangururamajwi ifite ubwirangire buringaniye"),
            keywords: &[
                "indangururamajwi ifite ubwirangire buringaniye",
                "iringaniye",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اسپيڪر جو وچولو آواز"),
            keywords: &["اسپيڪر جو وچولو آواز", "وچولو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dca}ප\u{dd3}කරය ක\u{dca}\u{200d}ර\u{dd2}ය\u{dcf}ත\u{dca}මකය\u{dd2}"),
            keywords: &[
                "අඩ\u{dd4}",
                "තරංගය",
                "ස\u{dca}ප\u{dd3}කරය",
                "ස\u{dca}ප\u{dd3}කරය ක\u{dca}\u{200d}ර\u{dd2}ය\u{dcf}ත\u{dca}මකය\u{dd2}",
                "හඩ පර\u{dd2}ම\u{dcf}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("stredná hlasitosť"),
            keywords: &["reproduktor", "stredná hlasitosť"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zvočnik pri zmerni glasnosti"),
            keywords: &[
                "glasnost",
                "nizko",
                "val",
                "zvočnik",
                "zvočnik pri zmerni glasnosti",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("sameecad codkeedu dhexdhexaad yahay"),
            keywords: &["dhexdhexaad", "sameecad codkeedu dhexdhexaad yahay"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("altoparlant me zë mesatar"),
            keywords: &[
                "altoparlant",
                "altoparlant me zë mesatar",
                "i ulët",
                "valë",
                "volum",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("укључен звучник"),
            keywords: &["средње", "укључен звучник"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["укључен звучник"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("uključen zvučnik"),
            keywords: &["srednje", "uključen zvučnik"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["uključen zvučnik"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("högtalare med medium volym"),
            keywords: &["högtalare", "högtalare med medium volym", "volym"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("spika imewashwa"),
            keywords: &["chini", "sauti", "spika", "spika imewashwa", "wingu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஸ\u{bcd}ப\u{bc0}க\u{bcd}கர\u{bcd} ஆன\u{bcd}"),
            keywords: &[
                "குறைந\u{bcd}த ஒலி",
                "மெதுவ\u{bbe}க பேசு",
                "ஸ\u{bcd}ப\u{bc0}க\u{bcd}கர\u{bcd}",
                "ஸ\u{bcd}ப\u{bc0}க\u{bcd}கர\u{bcd} ஆன\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మధ\u{c4d}యస\u{c4d}థ శబ\u{c4d}దంత\u{c4b} స\u{c4d}ప\u{c40}కర\u{c4d}"),
            keywords: &[
                "తక\u{c4d}కువ శబ\u{c4d}దం చ\u{c47}య\u{c3f}",
                "మధ\u{c4d}యస\u{c4d}థ శబ\u{c4d}దంత\u{c4b} స\u{c4d}ప\u{c40}కర\u{c4d}",
                "వ\u{c3e}ల\u{c4d}యూమ\u{c4d} తగ\u{c4d}గ\u{c3f}ంచు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("садои миёнаи баландгӯяк"),
            keywords: &["миёна", "садои миёнаи баландгӯяк"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ลำโพงเส\u{e35}ยงปานกลาง"),
            keywords: &["ลำโพง", "ลำโพงเบา", "ลำโพงเส\u{e35}ยงปานกลาง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("orta sesli dinamik"),
            keywords: &["orta sesli dinamik", "ortaça"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("leʻo loto"),
            keywords: &["leʻo loto"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ses açık"),
            keywords: &["düşük", "düşük ses", "düşük sesli hoparlör", "ses açık"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئارا ئۈنلۈك ياڭراتقۇ"),
            keywords: &["ئارا", "ئارا ئۈنلۈك ياڭراتقۇ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("середня гучність динаміка"),
            keywords: &["середньо", "середня гучність динаміка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اوسط آواز نکالتے اسپیکر"),
            keywords: &["آواز", "اسپیکر", "اوسط آواز نکالتے اسپیکر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ovozli"),
            keywords: &["karnay", "ovoz balandligi", "ovozli", "past", "to‘lqin"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("âm lượng loa trung bình"),
            keywords: &["trung bình", "âm lượng loa trung bình"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("oparlër bu xumbul noonu"),
            keywords: &["oparlër bu xumbul noonu", "yam"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ivolyum ephakathi yespikha"),
            keywords: &["ephakathi", "ivolyum ephakathi yespikha"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Gbohungbohun ti Ohun rẹ wa Laarin"),
            keywords: &["Gbohungbohun ti Ohun rẹ wa Laarin", "àárín"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("中音量喇叭"),
            keywords: &["中等", "中音量喇叭"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("中音量喇叭"),
            keywords: &["中等", "中音量喇叭"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("中等音量的扬声器"),
            keywords: &["中等", "中等音量", "中等音量的扬声器", "扬声器"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("低音量"),
            keywords: &["低音量", "喇叭"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("聲量中等嘅喇叭"),
            keywords: &["喇叭", "聲量中等", "聲量中等嘅喇叭"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukuvula ispikha"),
            keywords: &[
                "igagasi",
                "isipikha",
                "phansi",
                "ukuvula ispikha",
                "umsindo",
            ],
        },
    ],
};
#[doc = "🔊"]
pub const SPEAKER_HIGH_VOLUME: crate::Emoji = crate::Emoji {
    glyph: "🔊",
    codepoint: "1F50A",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "speaker high volume",
    group: "Objects",
    subgroup: "sound",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("luidspreker hard"),
            keywords: &["3", "drie", "hard", "luidspreker", "volume"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ስፒከር ድምፁ ከፍ ብሏል"),
            keywords: &["ስፒከር", "ስፒከር ድምፁ ከፍ ብሏል", "ከፍተኛ", "ድምፅ መጠን", "ጮክ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}صوت سماعة مرتفع"),
            keywords: &["سماعة بصوت مرتفع", "مرتفع", "\u{202b}صوت سماعة مرتفع"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("স\u{9cd}পীক\u{9be}ৰৰ স\u{9cd}বৰ তীব\u{9cd}ৰ"),
            keywords: &["তীব\u{9cd}ৰ", "স\u{9cd}পীক\u{9be}ৰৰ স\u{9cd}বৰ তীব\u{9cd}ৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("səsucaldan yüksəkdir"),
            keywords: &[
                "3",
                "səs",
                "səsucaldan",
                "səsucaldan yüksəkdir",
                "uca",
                "yüksək",
                "üç",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("гучна"),
            keywords: &["высокая", "гучна", "гучнасць", "дынамік"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Силно пуснат високоговорител"),
            keywords: &[
                "Силно пуснат високоговорител",
                "високоговорител",
                "сила на звука",
                "силен",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9cd}পিক\u{9be}র জোরে"),
            keywords: &[
                "খ\u{9c1}ব জোরে",
                "খ\u{9c1}ব জোরে স\u{9cd}পিক\u{9be}র",
                "স\u{9cd}পিক\u{9be}র জোরে",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zvučnik glasno"),
            keywords: &["jako", "zvučnik glasno"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("altaveu amb el volum alt"),
            keywords: &["alt", "altaveu amb el volum alt", "volum fort"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏬᏂᏍᎩ ᎦᎸᎳᏗ ᎠᏍᏓᏱᏗᏍᏗ"),
            keywords: &["ᎦᏬᏂᏍᎩ ᎦᎸᎳᏗ ᎠᏍᏓᏱᏗᏍᏗ", "ᏧᎵᏍᏙᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("hlasitý reproduktor"),
            keywords: &["hlasitý", "nahlas", "reproduktor"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("seinydd uchel"),
            keywords: &["3", "seinydd", "uchel"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("højttaler høj lydstyrke"),
            keywords: &[
                "høj volumen",
                "højtaler med høj volumen",
                "højttaler høj lydstyrke",
                "højttaler høj volumen",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Lautsprecher mit hoher Lautstärke"),
            keywords: &["Lautsprecher mit hoher Lautstärke", "laut"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ηχείο σε υψηλή ένταση"),
            keywords: &[
                "ένταση ήχου",
                "δυνατή",
                "ηχείο",
                "ηχείο σε υψηλή ένταση",
                "υψηλή ένταση ήχου",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("speaker high volume"),
            keywords: &["loud", "speaker high volume"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("altavoz a volumen alto"),
            keywords: &["altavoz", "altavoz a volumen alto", "alto", "volumen alto"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("bocina a volumen alto"),
            keywords: &["bocina a volumen alto"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("valju heliga kõlar"),
            keywords: &["heli", "kõlar", "vali", "valju heliga kõlar"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bozgorailua ozen"),
            keywords: &[
                "3",
                "altu",
                "bolumen",
                "bozgorailu",
                "bozgorailua ozen",
                "hiru",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بلندگو با صدای بلند"),
            keywords: &[
                "بالا",
                "بلند",
                "بلندگو",
                "بلندگو با صدای بلند",
                "زیاد",
                "صدا",
                "موج",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("äänekäs kaiutin"),
            keywords: &[
                "kaiutin",
                "kovempaa",
                "lisää",
                "äänekäs kaiutin",
                "äänenvoimakkuus",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("malakas ang speaker"),
            keywords: &[
                "maingay",
                "malakas",
                "malakas ang speaker",
                "speaker",
                "volume",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("høg ljóðstyrki á hátalara"),
            keywords: &["hátalari", "høg", "høg ljóðstyrki á hátalara", "ljóðstyrki"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("volume des enceintes élevé"),
            keywords: &["son", "volume des enceintes élevé"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("volume élevé"),
            keywords: &[
                "son fort",
                "son puissant",
                "son élevé",
                "volume fort",
                "volume élevé",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("callaire fuaime airde"),
            keywords: &["callaire fuaime airde"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("glaodhaire ’s fhuaim àrd"),
            keywords: &[
                "fuaim",
                "glaodhaire a’ cur a-mach fuaim àrd",
                "glaodhaire ’s fhuaim àrd",
                "àrd",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("altofalante con volume alto"),
            keywords: &[
                "alto",
                "altofalante",
                "altofalante con volume alto",
                "volume",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વધ\u{ac1} અવાજમા\u{a82} સ\u{acd}પીકર"),
            keywords: &[
                "ઊ\u{a82}ચો",
                "વધ\u{ac1} અવાજમા\u{a82} સ\u{acd}પીકર",
                "સ\u{acd}પીકર ઊચો અવાજ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("sifika ƙarfin murya na sama"),
            keywords: &["mai ƙarfi", "sifika ƙarfin murya na sama"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ווליום חזק"),
            keywords: &["ווליום", "חזק", "רמקול"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("उच\u{94d}च वॉल\u{94d}य\u{942}म स\u{94d}पीकर"),
            keywords: &[
                "अधिक आवाज\u{93c}",
                "अधिक आवाज\u{93c} म\u{947}\u{902} स\u{94d}पीकर",
                "उच\u{94d}च वॉल\u{94d}य\u{942}म स\u{94d}पीकर",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("glasan zvučnik"),
            keywords: &["glasan zvučnik", "glasno"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("hangos hangszóró"),
            keywords: &["hangos", "hangszóró", "nagy hangerő"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բարձրախոսի ձայնը բարձր է"),
            keywords: &[
                "3",
                "բարձր",
                "բարձրախոս",
                "բարձրախոսի ձայնը բարձր է",
                "բարձրաձայն",
                "երեք",
                "ձայն",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("volume speaker tinggi"),
            keywords: &["keras", "volume speaker tinggi"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("òkwù okwu ụhàraụdà dị elu"),
            keywords: &["òkwù okwu ụhàraụdà dị elu", "ụda"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hávær hátalari"),
            keywords: &["hljóðstyrkur", "hátalari", "hátt", "hávær hátalari"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("altoparlante a volume alto"),
            keywords: &["altoparlante a volume alto", "volume alto"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("スピーカー音量大"),
            keywords: &[
                "スピーカー",
                "スピーカー音量大",
                "ボリューム",
                "大音量",
                "音量",
                "音量大",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("volume banter speaker"),
            keywords: &["sero", "volume banter speaker"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ხმამაღალი დინამიკი"),
            keywords: &["3", "დინამიკი", "სამი", "ხმა", "ხმამაღალი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: None,
            keywords: &["imesli"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("динамиктің дыбысын шығару"),
            keywords: &[
                "динамиктің дыбысын көбейту",
                "динамиктің дыбысын шығару",
                "қатты",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("højttaler høj"),
            keywords: &["høj volumen", "højtaler med høj volumen", "højttaler høj"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បាសបើកខ\u{17d2}លា\u{17c6}ង"),
            keywords: &[
                "បាស",
                "បាសបើកខ\u{17d2}លា\u{17c6}ង",
                "បើកខ\u{17d2}លា\u{17c6}ង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{ccd}ಪೀಕರ\u{ccd} ಜೋರಾಗ\u{cbf}"),
            keywords: &[
                "ಸ\u{ccd}ಪೀಕರ\u{ccd} ಜೋರಾಗ\u{cbf}",
                "ಹ\u{cc6}ಚ\u{ccd}ಚ\u{cbf}ನ ವಾಲ\u{ccd}ಯ\u{cc2}ಮ\u{ccd}",
                "ಹ\u{cc6}ಚ\u{ccd}ಚ\u{cbf}ನ ವಾಲ\u{ccd}ಯ\u{cc2}ಮ\u{ccd}\u{200c}ನೊಂದ\u{cbf}ಗ\u{cc6} ಸ\u{ccd}ಪೀಕರ\u{ccd}",
                "ಹ\u{cc6}ಚ\u{ccd}ಚು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("스피커 소리 크게"),
            keywords: &["소리 크게", "소리 큼", "소리 키우기", "스피커 소리 크게"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उच\u{94d}च आवाजाचो स\u{94d}पिकर"),
            keywords: &["उच\u{94d}च आवाजाचो स\u{94d}पिकर", "व\u{94d}हड"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("колонка катуу"),
            keywords: &["3", "жогору", "катуу", "колонка", "үч"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Lautsprecher op haart agestallt"),
            keywords: &["Lautsprecher op haart agestallt", "haart"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{ecd}າໂພງດ\u{eb1}ງ"),
            keywords: &["ລ\u{ecd}າໂພງ", "ລ\u{ecd}າໂພງດ\u{eb1}ງ", "ສຽງດ\u{eb1}ງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("didelis garsiakalbio garsumas"),
            keywords: &["didelis garsiakalbio garsumas", "garsus"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("skaļš skaļrunis"),
            keywords: &["skaļrunis", "skaļums", "skaļš"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tukuoro kahaoro teitei"),
            keywords: &["nui", "tukuoro kahaoro teitei"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("гласен звучник"),
            keywords: &["глас", "гласен звучник", "звук", "звучник"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ഉച\u{d4d}ചത\u{d4d}തിൽ ശബ\u{d4d}\u{200c}ദമ\u{d41}ള\u{d4d}ള സ\u{d4d}\u{200c}പീക\u{d4d}കർ",
            ),
            keywords: &[
                "ഉച\u{d4d}ചത\u{d4d}തില\u{d41}ള\u{d4d}ള ശബ\u{d4d}\u{200c}ദം",
                "ഉച\u{d4d}ചത\u{d4d}തിൽ ശബ\u{d4d}\u{200c}ദമ\u{d41}ള\u{d4d}ള സ\u{d4d}\u{200c}പീക\u{d4d}കർ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("чанга яригчийн дууны түвшин чанга"),
            keywords: &["чанга", "чанга яригчийн дууны түвшин чанга"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{94d}पीकरचा मोठा आवाज"),
            keywords: &[
                "मोठा",
                "स\u{94d}पीकरचा आवाज मोठा",
                "स\u{94d}पीकरचा मोठा आवाज",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kelantangan tinggi pembesar suara"),
            keywords: &["kelantangan tinggi pembesar suara", "kuat"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("speaker volum għoli"),
            keywords: &["speaker volum għoli", "ħsejjes għolja"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စပ\u{102e}ကာ အသ\u{1036}ကျယ\u{103a}"),
            keywords: &[
                "ကျယ\u{103a}လောင\u{103a}",
                "စပ\u{102e}ကာ အသ\u{1036}ကျယ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("høyttaler med høyt volum"),
            keywords: &["høy", "høyttaler med høyt volum", "lyd", "ropert"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ठ\u{942}लो आवाजको स\u{94d}पिकर"),
            keywords: &[
                "चर\u{94d}को आवाज",
                "ठ\u{942}लो आवाजको स\u{94d}पिकर",
                "ठ\u{942}लो भोल\u{94d}य\u{941}मको स\u{94d}पिकर",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("speaker luid"),
            keywords: &["luid", "speaker luid"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("høgtalar med høgt volum"),
            keywords: &["høg", "høgtalar med høgt volum", "lyd", "ropert"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଉଚ\u{b4d}ଚ ଧ\u{b4d}ୱନ\u{b3f} ବ\u{b3f}ଶ\u{b3f}ଷ\u{b4d}ଟ ସ\u{b4d}ପ\u{b3f}କର\u{b4d}\u{200c}",
            ),
            keywords: &[
                "ଉଚ\u{b4d}ଚ",
                "ଉଚ\u{b4d}ଚ ଧ\u{b4d}ୱନ\u{b3f} ବ\u{b3f}ଶ\u{b3f}ଷ\u{b4d}ଟ ସ\u{b4d}ପ\u{b3f}କର\u{b4d}\u{200c}",
                "ଉଚ\u{b4d}ଚ ଭଲ\u{b4d}ୟ\u{b41}ମ\u{b4d}",
                "ଲ\u{b3e}ଉଡ\u{b4d} ଭଲ\u{b4d}ୟ\u{b41}ମ\u{b4d} ସହ\u{b3f}ତ ସ\u{b4d}ପ\u{b3f}କର\u{b4d}",
                "ସ\u{b4d}ପ\u{b3f}କର\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਪੀਕਰ ਉ\u{a71}ਚ ਵ\u{a4c}ਲਿਊਮ"),
            keywords: &[
                "ਵ\u{a71}ਧ",
                "ਵ\u{a71}ਧ ਆਵਾਜ\u{a3c}",
                "ਵ\u{a71}ਧ ਆਵਾਜ\u{a3c} ਨਾਲ ਸਪੀਕਰ",
                "ਸਪੀਕਰ",
                "ਸਪੀਕਰ ਉ\u{a71}ਚ ਵ\u{a4c}ਲਿਊਮ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ا\u{64f}وچے واج آلا اسپیکر"),
            keywords: &["ا\u{64f}وچا", "ا\u{64f}وچے واج آلا اسپیکر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Laúdspíka Haí Vọ\u{301}lium"),
            keywords: &["Laud", "Laúdspíka Haí Vọ\u{301}lium"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wysoka głośność głośnika"),
            keywords: &[
                "duża głośność",
                "wysoka głośność",
                "wysoka głośność głośnika",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د سپیکر لوړ غږ"),
            keywords: &["د سپیکر لوړ غږ", "لوړ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("alto-falante com volume alto"),
            keywords: &["alto-falante com volume alto", "volume alto"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("altifalante alto"),
            keywords: &["3", "altifalante", "alto", "elevado", "três", "volume"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("altavoz hatun chanrawan"),
            keywords: &["altavoz hatun chanrawan"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("volum ridicat al difuzorului"),
            keywords: &["gălăgie", "sunet puternic", "volum ridicat al difuzorului"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-710"),
            keywords: &["E10-710"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("высокая громкость"),
            keywords: &["высокая", "громкость", "динамик", "звук", "уровень"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("indangururamajwi ifite ubwirangire bwo hejuru"),
            keywords: &[
                "indangururamajwi ifite ubwirangire bwo hejuru",
                "kiranguruye",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اسپيڪر جو وڏو آواز"),
            keywords: &["اسپيڪر جو وڏو آواز", "لائوڊ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dca}ප\u{dd3}කර ශබ\u{dca}දය වැඩ\u{dd2}"),
            keywords: &[
                "ඉහළ ශබ\u{dca}දය",
                "ස\u{dca}ප\u{dd3}කර ශබ\u{dca}දය වැඩ\u{dd2}",
                "ස\u{dca}ප\u{dd3}කරය",
                "හඩ පර\u{dd2}ම\u{dcf}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("vysoká hlasitosť"),
            keywords: &["reproduktor", "vysoká hlasitosť"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zvočnik na glas"),
            keywords: &["glasno", "zvočnik na glas"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("sameecad codkeedu sareeyo"),
            keywords: &["sameecad codkeedu sareeyo", "sare"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("altoparlant me zë të lartë"),
            keywords: &[
                "altoparlant",
                "altoparlant me 3 vija",
                "altoparlant me zë të lartë",
                "volum i lartë",
                "zë i fortë",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("појачан звучник"),
            keywords: &["гласно", "појачан звучник"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["појачан звучник"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("pojačan zvučnik"),
            keywords: &["glasno", "pojačan zvučnik"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["pojačan zvučnik"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("högtalare med hög volym"),
            keywords: &["högtalare", "högtalare med hög volym", "volym"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("spika yenye sauti ya juu"),
            keywords: &["juu", "sauti", "spika", "spika yenye sauti ya juu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அலறும\u{bcd} ஸ\u{bcd}ப\u{bc0}க\u{bcd}கர\u{bcd}"),
            keywords: &[
                "அலறும\u{bcd} ஸ\u{bcd}ப\u{bc0}க\u{bcd}கர\u{bcd}",
                "சத\u{bcd}தம\u{bbe}கப\u{bcd} பேசு",
                "ஸ\u{bcd}ப\u{bc0}க\u{bcd}கர\u{bcd}",
                "ஹைபிட\u{bcd}ச\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c46}ద\u{c4d}ద శబ\u{c4d}దంత\u{c4b} స\u{c4d}ప\u{c40}కర\u{c4d}"),
            keywords: &[
                "గర\u{c3f}ష\u{c4d}ట వ\u{c3e}ల\u{c4d}యూమ\u{c4d}",
                "ప\u{c46}ద\u{c4d}ద శబ\u{c4d}దంత\u{c4b} స\u{c4d}ప\u{c40}కర\u{c4d}",
                "వ\u{c3e}ల\u{c4d}యూమ\u{c4d} ఎక\u{c4d}కువగ\u{c3e} ఉంద\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("садои баланди баландгӯяк"),
            keywords: &["баланд", "садои баланди баландгӯяк"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ลำโพงเส\u{e35}ยงด\u{e31}ง"),
            keywords: &["ลำโพง", "ลำโพงด\u{e31}ง", "ลำโพงเส\u{e35}ยงด\u{e31}ง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gaty sesli dinamik"),
            keywords: &["batly", "gaty sesli dinamik"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("leʻo lahi"),
            keywords: &["leʻo lahi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yüksek ses"),
            keywords: &["yüksek", "yüksek ses", "yüksek sesli hoparlör"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يۇقىرى ئۈنلۈك ياڭراتقۇ"),
            keywords: &["ئۈنلۈك", "يۇقىرى ئۈنلۈك ياڭراتقۇ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("високий рівень гучності динаміка"),
            keywords: &[
                "висока гучність динаміка",
                "високий рівень гучності динаміка",
                "гучно",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بلند آواز نکالتے اسپیکر"),
            keywords: &["آواز", "اسپیکر", "بلند", "بلند آواز نکالتے اسپیکر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("baland ovoz"),
            keywords: &[
                "3",
                "baland",
                "baland ovoz",
                "karnay",
                "ovoz balandligi",
                "uch",
                "yuqori",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("âm lượng loa cao"),
            keywords: &["lớn", "âm lượng loa cao"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("oparlër bu xumbul lool"),
            keywords: &["oparlër bu xumbul lool", "xumb"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ivolyum ephezulu yespikha"),
            keywords: &["ephezulu", "ivolyum ephezulu yespikha"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Gbohungbohun ti Ohun rẹ lọSoke"),
            keywords: &["Gbohungbohun ti Ohun rẹ lọSoke", "pariwo"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("高音量喇叭"),
            keywords: &["大聲", "高音量喇叭"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("高音量喇叭"),
            keywords: &["大声", "高音量喇叭"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("高音量的扬声器"),
            keywords: &["大声", "大音量", "扬声器", "高音量的扬声器"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("高音量"),
            keywords: &["喇叭", "高音量"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("聲量大嘅喇叭"),
            keywords: &["喇叭", "大聲", "聲量大嘅喇叭", "高音量"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ispikha esiphezulu"),
            keywords: &[
                "3",
                "ispikha",
                "ispikha esiphezulu",
                "ivolumu",
                "phezulu",
                "umsindo",
            ],
        },
    ],
};
#[doc = "📢"]
pub const LOUDSPEAKER: crate::Emoji = crate::Emoji {
    glyph: "📢",
    codepoint: "1F4E2",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "loudspeaker",
    group: "Objects",
    subgroup: "sound",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("aankondigingsluidspreker"),
            keywords: &[
                "aankondiging",
                "aankondigingsluidspreker",
                "hard",
                "luidspreker",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ላውድ ስፒከር"),
            keywords: &["ላውድ ስፒከር", "ይፋ አድራሻ", "ጮክ ያለ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مكبر صوت"),
            keywords: &["تواصل", "سماعة محمولة", "مجهار", "مكبر صوت"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ল\u{9be}উডস\u{9cd}পীক\u{9be}ৰ"),
            keywords: &[
                "তীব\u{9cd}ৰ",
                "ল\u{9be}উডস\u{9cd}পীক\u{9be}ৰ",
                "ৰ\u{9be}জহ\u{9c1}ৱ\u{9be} প\u{9cd}ৰচ\u{9be}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("səsucaldıcı"),
            keywords: &["ictimai ünvan", "səsucaldıcı", "uca"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("гучнагаварыцель"),
            keywords: &[
                "вяшчанне",
                "гучнагаварыцель",
                "гучны",
                "публічны зварот",
                "рупар",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Високоговорител за обществени места"),
            keywords: &["Високоговорител за обществени места", "обществен", "силен"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ল\u{9be}উড স\u{9cd}পিক\u{9be}র"),
            keywords: &[
                "জনগণের উদ\u{9cd}দেশ\u{9cd}যে",
                "জোরে",
                "ল\u{9be}উড স\u{9cd}পিক\u{9be}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("uhelgomzer"),
            keywords: &["son", "uhelgomzer"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zvučnik"),
            keywords: &["glasno", "razglas", "zvučnik"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("altaveu de megafonia"),
            keywords: &["altaveu", "altaveu de megafonia", "megafonia"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎭᎳᏓ ᎦᏬᏂᏍᎩ"),
            keywords: &["ᎠᏰᎵ ᎤᏤᎵ ᎪᏪᎵ ᏧᏁᏍᏗ ᏗᏎᏍᏗ", "ᏗᎭᎳᏓ ᎦᏬᏂᏍᎩ", "ᏧᎵᏍᏙᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("tlampač"),
            keywords: &[
                "hlasitý",
                "hlášení",
                "rozhlas",
                "sdělení",
                "tlampač",
                "veřejné",
                "veřejný",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("uchelseinydd"),
            keywords: &["cyhoeddus", "uchel", "uchelseinydd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("elektrisk megafon"),
            keywords: &["elektrisk megafon", "højttaler", "offentlig tale", "tale"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Lautsprecher"),
            keywords: &["Lautsprecher"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: None,
            keywords: &["Lautsprecher"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ντουντούκα"),
            keywords: &[
                "δυνατός ήχος",
                "ντουντούκα",
                "τηλεβόας",
                "υψηλή ένταση ήχου",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("loudspeaker"),
            keywords: &["loud", "loudspeaker", "public address"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("loudhailer"),
            keywords: &["loud", "loudhailer", "public address"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("altavoz de mano"),
            keywords: &["altavoz", "altavoz de mano", "comunicación"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "altavoces",
                "altavoz",
                "altavoz de mano",
                "estadio",
                "parlante",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("altavoz"),
            keywords: &["altavoz"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "altavoz",
                "altavoz de mano",
                "fuerte",
                "parlante",
                "público",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("valjuhääldi"),
            keywords: &["avalik", "kõne", "vali", "valjuhääldi"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bozgorailu"),
            keywords: &["altu", "bozgorailu", "publiko"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بلندگو"),
            keywords: &["بلند", "بلندگو", "خطابه عمومی", "سخنرانی", "عمومی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kovaääninen"),
            keywords: &["huomio", "keskusradio", "kova", "kovaääninen", "ääni"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("loudspeaker"),
            keywords: &["anunsyo", "loudspeaker", "malakas", "pampublikong address"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("rópari"),
            keywords: &["megafon", "rópari"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("haut-parleur"),
            keywords: &["haut-parleur", "son"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["bruyant", "discours", "haut-parleur", "porte-voix"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("callaire"),
            keywords: &["callaire", "callaire láimhe", "fógairt phoiblí"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("glaodhaire"),
            keywords: &["fuaim", "glaodhaire", "pa", "àrd"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("altofalante de megafonía"),
            keywords: &["altofalante", "altofalante de megafonía", "megafonía"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લાઉડસ\u{acd}પીકર"),
            keywords: &["ઊ\u{a82}ચો", "જાહ\u{ac7}ર સ\u{a82}બોધન", "લાઉડસ\u{acd}પીકર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("lasifika"),
            keywords: &["jawabi ga jama’a", "lasifika", "mai ƙarfi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מגפון"),
            keywords: &["הודעה", "חזק", "מגפון"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("लाउडस\u{94d}पीकर"),
            keywords: &[
                "आम सभा",
                "लाउडस\u{94d}पीकर",
                "स\u{902}चार",
                "ह\u{948}\u{902}ड स\u{94d}पीकर",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("razglas"),
            keywords: &["glasno", "obraćanje javnosti", "razglas"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("hangosbeszélő"),
            keywords: &["hangos", "hangosbeszélő", "közlemények"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մեծ բարձրախոս"),
            keywords: &["բարձրաձայն", "հասարակական", "մեծ բարձրախոս"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pengeras suara"),
            keywords: &["keras", "pengeras suara", "pengumuman"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụda egwu"),
            keywords: &["àdreèsì ọha", "ụda egwu", "ụdà"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("Almannavarnahátalari"),
            keywords: &[
                "Almannavarnahátalari",
                "almannavarnir",
                "gjallarhorn",
                "samskipti",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("altoparlante"),
            keywords: &["altoparlante", "altoparlanti", "megafoni", "megafono"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("拡声器"),
            keywords: &["スピーカー", "メガホン", "拡声器"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("speaker sero"),
            keywords: &["sero", "speaker sero", "wara-wara"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("რუპორი"),
            keywords: &["მიმართვა", "რუპორი", "ხმამაღალი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("дауыс зорайтқыш"),
            keywords: &["дауыс зорайтқыш", "жоғары дыбыс", "ортақ мекенжай"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("højttaler med håndtag"),
            keywords: &["højt", "højttaler med håndtag", "offentlig"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17b8}ក\u{17d2}រ\u{17bc}ប\u{17c6}ពងសម\u{17d2}លេង"),
            keywords: &[
                "ប\u{17c6}ពងសម\u{17d2}លេង",
                "ម\u{17b8}ក\u{17d2}រ\u{17bc}",
                "ម\u{17b8}ក\u{17d2}រ\u{17bc}ប\u{17c6}ពងសម\u{17d2}លេង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಲ\u{ccc}ಡ\u{ccd} ಸ\u{ccd}ಪೀಕರ\u{ccd}"),
            keywords: &[
                "ಕೈ ಸ\u{ccd}ಪೀಕರ\u{ccd}",
                "ಲ\u{ccc}ಡ\u{ccd} ಸ\u{ccd}ಪೀಕರ\u{ccd}",
                "ಸಂವಹನ",
                "ಸಾರ\u{ccd}ವಜನ\u{cbf}ಕ ವ\u{cbf}ಳಾಸ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("확성기"),
            keywords: &["메가폰", "확성기"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("लाउडस\u{94d}पिकर"),
            keywords: &["भौशीक नामो", "लाउडस\u{94d}पिकर", "व\u{94d}हड"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("катуу сүйлөткүч"),
            keywords: &["жалпыга багытталган", "катуу", "катуу сүйлөткүч"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Lautsprecher"),
            keywords: &["Lautsprecher", "haart", "ëffentlech Adress"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຄ\u{eb7}\u{ec8}ອງກະຈາຍສຽງ"),
            keywords: &["ປະກາດ", "ສຽງດ\u{eb1}ງ", "ເຄ\u{eb7}\u{ec8}ອງກະຈາຍສຽງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("garsiakalbio simbolis"),
            keywords: &["garsiai", "garsiakalbio simbolis", "viešas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pastiprinātājs"),
            keywords: &["pastiprinātājs", "skaļrunis", "skaļš"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tukuoro"),
            keywords: &["kōrero tūmatanui", "nui", "tukuoro"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("разглас"),
            keywords: &["звук", "звучник", "места", "разглас", "јавни"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ല\u{d57}ഡ\u{d4d} സ\u{d4d}പീക\u{d4d}കർ"),
            keywords: &[
                "ആശയവിനിമയം",
                "ഉച\u{d4d}ചഭ\u{d3e}ഷിണി",
                "പ\u{d4d}രസംഗം",
                "ല\u{d57}ഡ\u{d4d} സ\u{d4d}പീക\u{d4d}കർ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("чанга яригч"),
            keywords: &["олон нийт", "чанга", "яригч"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("लाउडस\u{94d}पकीर"),
            keywords: &[
                "मोठा",
                "लाउडस\u{94d}पकीर",
                "लाउडस\u{94d}पीकर",
                "सार\u{94d}वजनिक अभिभाषण",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("corong pembesar suara"),
            keywords: &["corong pembesar suara", "kuat", "siar raya"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("loudspeaker"),
            keywords: &["indirizz pubbliku", "loudspeaker", "ħsejjes għolja"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အသ\u{1036}ချ\u{1032}\u{1037}စက\u{103a}"),
            keywords: &[
                "ကျယ\u{103a}လောင\u{103a}သော",
                "အသ\u{1036}ချ\u{1032}\u{1037}စက\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("høyttaler"),
            keywords: &["høy", "høyttaler", "kommunikasjon", "megafon", "ropert"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("लाउडस\u{94d}पिकर"),
            keywords: &[
                "चर\u{94d}को आवाज",
                "लाउडस\u{94d}पिकर",
                "सार\u{94d}वजनिक ठ\u{947}गाना",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("luidspreker"),
            keywords: &["luid", "luidspreker", "toespraak"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("høgtalar"),
            keywords: &["høg", "høgtalar", "kommunikasjon", "megafon", "ropert"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଲ\u{b3e}ଉଡସ\u{b4d}ପ\u{b3f}କର\u{b4d}"),
            keywords: &[
                "ଯୋଗ\u{b3e}ଯୋଗ",
                "ଲ\u{b3e}ଉଡସ\u{b4d}ପ\u{b3f}କର\u{b4d}",
                "ଲ\u{b3e}ଉଡ\u{b4d}\u{200c}ସ\u{b4d}ପ\u{b3f}କର\u{b4d}",
                "ସର\u{b4d}ବସ\u{b3e}ଧ\u{b3e}ରଣ ଠ\u{b3f}କଣ\u{b3e}",
                "ହ\u{b4d}ୟ\u{b3e}ଣ\u{b4d}ଡ\u{b4d} ସ\u{b4d}ପ\u{b3f}କର\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲਾਊਡ-ਸਪੀਕਰ"),
            keywords: &[
                "ਜਨਤਕ ਪਤਾ",
                "ਲਾਊਡ-ਸਪੀਕਰ",
                "ਲਾਊਡਸਪੀਕਰ",
                "ਸ\u{a70}ਚਾਰ",
                "ਹ\u{a71}ਥ ਸਪੀਕਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("لاؤڈ سپیکر"),
            keywords: &["ا\u{64f}وچا", "عوامی پت\u{651}ہ", "لاؤڈ سپیکر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Laúdspíka"),
            keywords: &["Laud", "Laúdspíka", "Pọ\u{301}blík Laúdspíka"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("głośnik"),
            keywords: &["głośnik", "głośno", "komunikaty publiczne"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لاوډسپیکر"),
            keywords: &["اولسي خطاب", "لاوډ", "لاوډ سپيکر", "لاوډسپیکر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("buzina"),
            keywords: &[
                "alto",
                "alto-falante",
                "buzina",
                "discurso público",
                "megafone",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("altifalante público"),
            keywords: &["altifalante", "alto", "público"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("altoparlante"),
            keywords: &["altoparlante"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("portavoce"),
            keywords: &["difuzare", "mesaj public", "portavoce"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-671"),
            keywords: &["E10-671"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("громкоговоритель"),
            keywords: &[
                "громкоговоритель",
                "звук",
                "обращение",
                "объявление",
                "рупор",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("indangururamajwi"),
            keywords: &["aderesi rusange", "indangururamajwi", "kiranguruye"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("لائوڊ اسپيڪر"),
            keywords: &["لائوڊ اسپيڪر", "لائوڊ، عوامي خطاب"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ශබ\u{dca}දව\u{dcf}හ\u{dd2}න\u{dd2}ය"),
            keywords: &[
                "පොද\u{dd4} ල\u{dd2}ප\u{dd2}නය",
                "ශබ\u{dca}දය",
                "ශබ\u{dca}දව\u{dcf}හ\u{dd2}න\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("amplión"),
            keywords: &["amplión", "nahlas", "verejný rozhlas"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("javni zvočnik"),
            keywords: &["glasnost", "javna objava", "javni zvočnik"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kor u hadle"),
            keywords: &["jeedin dadweyne", "kor u hadle", "sare"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("altoparlant me zë"),
            keywords: &["altoparlant me zë", "e folur publike", "me zë të lartë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("разглас"),
            keywords: &["oбрaћaњe jaвнoсти", "глaснo", "разглас"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("razglas"),
            keywords: &["glasno", "obraćanje javnosti", "razglas"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("handhögtalare"),
            keywords: &["handhögtalare", "kommunikation"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kipaza sauti"),
            keywords: &["kipaza sauti", "sauti"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பொது அறிவிப\u{bcd}பு"),
            keywords: &[
                "செய\u{bcd}தி",
                "பொது அறிவிப\u{bcd}பு",
                "ஸ\u{bcd}ப\u{bc0}க\u{bcd}கர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ల\u{c4c}డ\u{c4d}\u{200c}స\u{c4d}ప\u{c40}కర\u{c4d}"),
            keywords: &[
                "భ\u{c3e}ర\u{c40} ల\u{c4c}డ\u{c4d} స\u{c4d}ప\u{c40}కర\u{c4d}",
                "ల\u{c4c}డ\u{c4d}\u{200c}స\u{c4d}ప\u{c40}కర\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("баландгӯяк"),
            keywords: &["баланд", "баландгӯяк", "суроғаи ошкор"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เคร\u{e37}\u{e48}องขยายเส\u{e35}ยง"),
            keywords: &[
                "ประกาศ",
                "เคร\u{e37}\u{e48}องขยายเส\u{e35}ยง",
                "เส\u{e35}ยงด\u{e31}ง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("dinamik"),
            keywords: &["batly", "dinamik", "köpçülige ýüzleniş"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sipikā"),
            keywords: &["sipikā"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("hoparlör"),
            keywords: &["halka hitap", "hoparlör", "iletişim", "megafon"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ياڭراتقۇ"),
            keywords: &["ئاممىۋىي ئادرېس", "ئۈنلۈك", "ياڭراتقۇ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("гучномовець"),
            keywords: &["гучний", "гучномовець", "звукове оповіщення"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("لاؤڈ اسپیکر"),
            keywords: &["اجتماع", "بلند آواز", "خطاب", "لاؤڈ اسپیکر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("e’lon qiluvchi karnay"),
            keywords: &["baland", "e’lon qiluvchi karnay", "ommaviy"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("loa phát thanh"),
            keywords: &[
                "loa phát thanh",
                "loa phóng thanh",
                "lớn",
                "địa chỉ công cộng",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("baafal"),
            keywords: &["baafal", "dëkkuwaayu ñépp", "xumb"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isandisi-zwi"),
            keywords: &["ephezulu", "intetho kawonkewonke", "isandisi-zwi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Gbohùngbohùn"),
            keywords: &["Gbohùngbohùn", "pariwo", "ìfitóniléti ìta gbangban"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("大聲公"),
            keywords: &["公共地方", "大聲", "大聲公"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("大声公"),
            keywords: &["公共地方", "大声", "大声公"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("喇叭"),
            keywords: &["公共广播", "喇叭", "大声", "广播", "通知"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("大聲公"),
            keywords: &["喇叭", "大聲公"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["喇叭", "大聲公", "擴音器"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isipikha esimemezayo"),
            keywords: &["isipikha esimemezayo", "ukukhuluma nomphakathi", "umsindo"],
        },
    ],
};
#[doc = "📣"]
pub const MEGAPHONE: crate::Emoji = crate::Emoji {
    glyph: "📣",
    codepoint: "1F4E3",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "megaphone",
    group: "Objects",
    subgroup: "sound",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("megafoon"),
            keywords: &["aankondiging", "luidspreker", "megafoon"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሜጋፎን"),
            keywords: &["ሜጋፎን", "ቺሪንግ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}مضخم الصوت"),
            keywords: &["تواصل", "هتاف", "\u{202b}مضخم الصوت"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মেগ\u{9be}ফোন"),
            keywords: &["মেগ\u{9be}ফোন", "সমৰ\u{9cd}থন প\u{9cd}ৰক\u{9be}শক চিঞৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("meqafon"),
            keywords: &["meqafon", "salamlama"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мегафон"),
            keywords: &["мегафон", "мітынг", "падбадзёрванне"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("мегафон"),
            keywords: &["мегафон", "подкрепа"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মেগ\u{9be}ফোন"),
            keywords: &["মেগ\u{9be}ফোন", "হর\u{9cd}ষধ\u{9cd}বনি"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("korn-mouezh"),
            keywords: &["korn-mouezh", "megafon"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("megafon"),
            keywords: &["megafon", "navijanje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("megàfon"),
            keywords: &["animar", "aplaudiments", "megàfon"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄟\u{11133}𑄠𑄊𑄜\u{1112e}𑄚\u{11134}"),
            keywords: &["𑄟\u{11133}𑄠𑄊𑄜\u{1112e}𑄚\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎭᎳᏙᏗ ᏫᎦᏬᏂᏍᏙᏗ"),
            keywords: &["ᎤᏁᎷᎬᎢ", "ᏗᎭᎳᏙᏗ ᏫᎦᏬᏂᏍᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("megafon"),
            keywords: &[
                "fandění",
                "megafon",
                "povzbuzování",
                "proslov",
                "řečník",
                "řečnění",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("megaffon"),
            keywords: &["megaffon", "sirioli"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("megafon"),
            keywords: &["kommunikation", "megafon"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Megafon"),
            keywords: &["Jubel", "Lautsprecher", "Megafon"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μεγάφωνο"),
            keywords: &["ζητωκραυγές", "μεγάφωνο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("megaphone"),
            keywords: &["cheering", "megaphone"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("megáfono"),
            keywords: &["comunicación", "megáfono"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["altavoz", "megáfono", "parlante"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("megafon"),
            keywords: &["kõne", "megafon"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("megafonoa"),
            keywords: &["animatu", "megafonoa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بلندگوی دستی"),
            keywords: &["بلند", "بلندگو", "بلندگوی دستی", "تشویق", "هلهله"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("megafoni"),
            keywords: &[
                "huomio",
                "kovaääninen",
                "megafoni",
                "suosionosoitus",
                "ääni",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("megaphone"),
            keywords: &["announcement", "megaphone"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("megafon"),
            keywords: &["megafon", "rópari"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("porte-voix"),
            keywords: &["manifestation", "mégaphone", "porte-voix"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("meigeafón"),
            keywords: &["meigeafón"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("meaga-fòn"),
            keywords: &["brosnachadh", "meaga-fòn"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("megáfono"),
            keywords: &["megafonía", "megáfono"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મ\u{ac7}ગાફોન"),
            keywords: &["ચીઅરિ\u{a82}ગ", "મ\u{ac7}ગાફોન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("bututun ƙara magana"),
            keywords: &["bututun ƙara magana", "shewa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מגפון בלי ידית"),
            keywords: &["מגפון", "מגפון בלי ידית", "עידוד"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("म\u{947}गाफ\u{93c}ोन"),
            keywords: &["उत\u{94d}साहवर\u{94d}धन", "म\u{947}गाफ\u{93c}ोन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("megafon"),
            keywords: &["megafon", "navijanje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("megafon"),
            keywords: &["megafon", "szurkolás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մեգաֆոն"),
            keywords: &["մեգաֆոն", "ոգևորում"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("megafon"),
            keywords: &["bersorak", "megafon"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("igweokwu"),
            keywords: &["igweokwu", "na-eti mkpu ọṅụ\u{300}"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("gjallarhorn"),
            keywords: &["fögnuður", "gjallarhorn", "samskipti"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("megafono"),
            keywords: &["altoparlante", "altoparlanti", "megafoni", "megafono"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("メガホン"),
            keywords: &["スピーカー", "メガホン", "拡声器"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("megapon"),
            keywords: &["megapon", "sorak-sorak"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მეგაფონი"),
            keywords: &["გულშემატკივრობა", "მეგაფონი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("amigafun"),
            keywords: &["amigafun"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("мегафон"),
            keywords: &["мегафон", "шапалақтау"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("megafon"),
            keywords: &["kommunikation", "megafon"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ឧបករណ\u{17cd}ជ\u{17bd}យប\u{17c6}ពងសម\u{17d2}លេង"),
            keywords: &[
                "ប\u{17c6}ពងសម\u{17d2}លេង",
                "ល\u{17ba}ខ\u{17d2}លា\u{17c6}ង",
                "ឧបករណ\u{17cd}ជ\u{17bd}យប\u{17c6}ពងសម\u{17d2}លេង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮ\u{cc6}ಗಾಫೋನ\u{ccd}"),
            keywords: &[
                "ಚ\u{cbf}ಯರ\u{cbf}ಂಗ\u{ccd}",
                "ಮ\u{cc6}ಗಾಫೋನ\u{ccd}",
                "ಸಂವಹನ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("메가폰"),
            keywords: &["메가폰", "응원"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("म\u{947}गाफोन"),
            keywords: &["चियरी\u{902}ग", "म\u{947}गाफोन"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("мегафон"),
            keywords: &["мегафон", "сүйүнүч"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Megafon"),
            keywords: &["Megafon", "ufeierend"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ທ\u{ecd}ລະໂຄ\u{ec8}ງ"),
            keywords: &["ການເຊ\u{eb5}ຍ", "ທ\u{ecd}ລະໂຄ\u{ec8}ງ", "ປະກາດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("garsintuvas"),
            keywords: &["džiaugsmingi šūksniai", "garsintuvas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("megafons"),
            keywords: &["megafons", "ovācijas"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pūwhakarahireo"),
            keywords: &["pūwhakarahireo", "umere ana"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("мегафон"),
            keywords: &["мегафон", "навивање"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മെഗ\u{d3e}ഫോൺ"),
            keywords: &["ആശയവിനിമയം", "മെഗ\u{d3e}ഫോൺ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цагаан хоолойн чанга яригч"),
            keywords: &["дэмжих", "цагаан хоолойн чанга яригч"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("म\u{947}गाफोन"),
            keywords: &["आन\u{902}ददायक", "म\u{947}गाफोन"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("megafon"),
            keywords: &["bersorak", "megafon"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("megafonu"),
            keywords: &["cheering", "megafonu"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အော\u{103a}လန\u{103a}"),
            keywords: &[
                "န\u{103e}\u{102f}တ\u{103a}ဆက\u{103a}",
                "အော\u{103a}လန\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("megafon"),
            keywords: &["heiing", "kommunikasjon", "megafon", "ropert"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("म\u{947}गाफोन"),
            keywords: &["उत\u{94d}साहवर\u{94d}धक", "म\u{947}गाफोन"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("megafoon"),
            keywords: &["juichen", "megafoon"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("megafon"),
            keywords: &["heiing", "kommunikasjon", "megafon", "ropert"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମେଗ\u{b3e}ଫୋନ\u{b4d}\u{200c}"),
            keywords: &[
                "ଚ\u{b3f}ୟର\u{b3f}ଂ",
                "ମେଗ\u{b3e}ଫୋନ\u{b4d}\u{200c}",
                "ଯୋଗ\u{b3e}ଯୋଗ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a48}ਗਾਫ\u{a4b}ਨ"),
            keywords: &["ਉਤਸ\u{a3c}ਾਹ ਵਧਾਉਣਾ", "ਮ\u{a48}ਗਾਫ\u{a4b}ਨ", "ਸ\u{a70}ਚਾਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("میگافون"),
            keywords: &["شادمانی", "میگافون"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mẹ\u{301}gafon"),
            keywords: &["Hapí", "Mẹ\u{301}gafon"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("megafon"),
            keywords: &["kibicować", "megafon"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("میګافون"),
            keywords: &["ميګافون", "میګافون", "چغې وهل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("megafone"),
            keywords: &["aplausos", "comunicação", "megafone"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["apoiar", "megafone", "torcer"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("megáfono"),
            keywords: &["megáfono"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("megafon"),
            keywords: &["difuzare", "megafon", "sunet"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-672"),
            keywords: &["E10-672"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мегафон"),
            keywords: &[
                "громкоговоритель",
                "звук",
                "мегафон",
                "обращение",
                "объявление",
                "рупор",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("megafone"),
            keywords: &["gushyiramo akanyabugabo", "megafone"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("وڏو فون"),
            keywords: &["جوشيلو آواز", "وڏو فون"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මෙග\u{dcf}ෆෝනය"),
            keywords: &["ඔල\u{dca}වරසන\u{dca}", "මෙග\u{dcf}ෆෝනය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("megafón"),
            keywords: &["megafón", "povzbudzovanie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("megafon"),
            keywords: &["megafon", "skandiranje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("mikirifoon"),
            keywords: &["mikirifoon", "u jiibin"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("megafon"),
            keywords: &["brohoritje", "megafon"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мегафон"),
            keywords: &["мегафон", "нaвиjaњe"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("megafon"),
            keywords: &["megafon", "navijanje"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("megafon"),
            keywords: &["kommunikation", "megafon"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("megafoni"),
            keywords: &["kushangilia", "megafoni"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மெக\u{bbe}போன\u{bcd}"),
            keywords: &["கூவுதல\u{bcd}", "தொடர\u{bcd}பு", "மெக\u{bbe}போன\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c46}గ\u{c3e}ఫ\u{c4b}న\u{c4d}"),
            keywords: &["నవ\u{c4d}వడం", "మ\u{c46}గ\u{c3e}ఫ\u{c4b}న\u{c4d}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("мегафон"),
            keywords: &["кафкӯбӣ", "мегафон"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("โทรโข\u{e48}ง"),
            keywords: &["ประกาศ", "เช\u{e35}ยร\u{e4c}", "โทรโข\u{e48}ง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("megafon"),
            keywords: &["joşdurýan", "megafon"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻa fakaleʻolahi"),
            keywords: &["meʻa fakaleʻolahi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("megafon"),
            keywords: &["iletişim", "karşılama", "megafon"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئۈنلەتكۈچ"),
            keywords: &["ئۈنلەتكۈچ", "روھلىنىش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("мегафон"),
            keywords: &["мегафон", "підбадьорення"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("میگا فون"),
            keywords: &["آلہ", "تیز آواز", "میگا فون"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("megafon"),
            keywords: &["megafon", "olqish"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("loa phóng thanh"),
            keywords: &["cổ vũ", "loa phóng thanh"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("megafon"),
            keywords: &["brawoo", "megafon"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-megaphone"),
            keywords: &["i-megaphone", "ukukhuthaza"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ẹ\u{300}rọ gbohùngbohùn ńlá"),
            keywords: &["ìbáraniyò\u{329}", "ẹ\u{300}rọ gbohùngbohùn ńlá"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("擴音器"),
            keywords: &["打氣", "擴音器"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("扩音器"),
            keywords: &["打气", "扩音器"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("扩音器"),
            keywords: &["呼喊", "喇叭筒", "大声", "扩音器", "通知"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("擴音器"),
            keywords: &["喇叭", "擴音器"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("傳聲筒"),
            keywords: &["傳聲筒"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umbhobho omkhulu"),
            keywords: &["ukujabula", "umbhobho omkhulu"],
        },
    ],
};
#[doc = "📯"]
pub const POSTAL_HORN: crate::Emoji = crate::Emoji {
    glyph: "📯",
    codepoint: "1F4EF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "postal horn",
    group: "Objects",
    subgroup: "sound",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("poshoring"),
            keywords: &["horing", "pos", "poshoring"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የፖስተኛ ጥሩንባ"),
            keywords: &["የፖስተኛ ጥሩንባ", "ጥሩንባ", "ፖስታ ቤት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("جرس بريد"),
            keywords: &["جرس", "جرس بريد"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প’ষ\u{9cd}টেল হৰ\u{9cd}ণ"),
            keywords: &["প’ষ\u{9cd}ট", "প’ষ\u{9cd}টেল", "হৰ\u{9cd}ণ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("poçt şeypuru"),
            keywords: &["poçt", "poçt şeypuru", "şeypur"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("паштовая труба"),
            keywords: &["паштовая труба", "паштовы", "пошта", "труба"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Пощенски рог"),
            keywords: &["Пощенски рог", "поща", "пощенски", "рог"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("পোস\u{9cd}ট\u{9be}ল হর\u{9cd}ণ"),
            keywords: &[
                "পোস\u{9cd}ট",
                "পোস\u{9cd}ট\u{9be}ল",
                "পোস\u{9cd}ট\u{9be}ল হর\u{9cd}ণ",
                "শিঙ\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("korn ar paotr-marc’h"),
            keywords: &["korn", "korn ar paotr-marc’h", "paotr-marc’h"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("poštanski rog"),
            keywords: &["pošta", "poštanski rog", "sirena"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("corn de posta"),
            keywords: &[
                "corn de posta",
                "corneta de posta",
                "corneta de postilló",
                "correus",
                "símbol",
                "símbol de correus",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎪᏪᎵ ᏧᏂᏍᏚᎢᏍᏗ ᎤᏲᎾ"),
            keywords: &["ᎤᏙᏢᏒ", "ᎤᏲᏂ", "ᎪᏪᎵ ᏧᏂᏍᏚᎢᏍᏗ", "ᎪᏪᎵ ᏧᏂᏍᏚᎢᏍᏗ ᎤᏲᎾ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("poštovní roh"),
            keywords: &[
                "polnice",
                "postiliónský",
                "pošta",
                "poštovní",
                "roh",
                "trubka",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("corn bost"),
            keywords: &["corn", "corn bost", "post"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("posthorn"),
            keywords: &["post", "posthorn"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Posthorn"),
            keywords: &["Brief", "E-Mail", "Post", "Posthorn"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ταχυδρομική κόρνα"),
            keywords: &["κόρνα", "ταχυδρομείο", "ταχυδρομική κόρνα", "ταχυδρομικός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("postal horn"),
            keywords: &["horn", "post", "postal"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("corneta de posta"),
            keywords: &["corneta", "corneta de posta", "posta"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("corneta de correo"),
            keywords: &[
                "clarín",
                "corneta",
                "corneta de correo",
                "correo",
                "instrumento",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("postisarv"),
            keywords: &["post", "postisarv", "sarv"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("adarra"),
            keywords: &["adar", "adarra", "posta"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("شیپور پست"),
            keywords: &["شیپور", "پست", "پستی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("postitorvi"),
            keywords: &["posti", "postitorvi", "torvi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("post horn"),
            keywords: &["horn", "post", "postal"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("posthorn"),
            keywords: &["horn", "post", "posthorn", "postur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cor postal"),
            keywords: &["cor postal", "facteur"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["cor de facteur", "cor postal", "facteur", "poste"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("corn poist"),
            keywords: &["corn", "corn poist"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("còrn a’ phuist"),
            keywords: &["còrn", "còrn a’ phuist", "post"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("corneta postal"),
            keywords: &["Correos", "corneta", "postal"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પોસ\u{acd}ટલ હોર\u{acd}ન"),
            keywords: &["પોસ\u{acd}ટલ", "હોર\u{acd}ન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kakaki na gidan waya"),
            keywords: &["kakaki", "kakaki na gidan waya", "na gidan waya", "saƙo"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קרן דואר"),
            keywords: &["דואר", "חצוצרה", "קרן"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पोस\u{94d}टल हॉर\u{94d}न"),
            keywords: &["पोस\u{94d}टल हॉर\u{94d}न", "हॉर\u{94d}न"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("poštanski rog"),
            keywords: &["pošta", "poštanski rog", "rog"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("postakürt"),
            keywords: &["kürt", "posta", "postai", "postakürt"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("փոստային եղջյուր"),
            keywords: &["եղջյուր", "փոստ", "փոստային"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("trompet pos"),
            keywords: &["pos", "trompet"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("opi mkpọte"),
            keywords: &["mkpọte", "opi", "zipụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("póstlúður"),
            keywords: &["lúður", "póstlúður", "póstur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("corno postale"),
            keywords: &[
                "cornetta da postiglione",
                "cornetto postale",
                "corno postale",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("郵便ラッパ"),
            keywords: &["ラッパ", "郵便", "郵便ラッパ"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("trompet pos"),
            keywords: &["pos", "trompet"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("საფოსტო ბუკი"),
            keywords: &["ბუკი", "საფოსტო", "ფოსტა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("керней"),
            keywords: &["керней", "мүйіз", "пошта", "пошталық"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("posthorn"),
            keywords: &["posthorn"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ត\u{17d2}រែ"),
            keywords: &["ត\u{17d2}រែ", "ផ\u{17d2}ល\u{17bb}\u{17c6}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪೋಸ\u{ccd}ಟಲ\u{ccd} ಹಾರ\u{ccd}ನ\u{ccd}"),
            keywords: &["ಪೋಸ\u{ccd}ಟಲ\u{ccd}", "ಹಾರ\u{ccd}ನ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("호른"),
            keywords: &["악기", "호른"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पोस\u{94d}टल हॉर\u{94d}न"),
            keywords: &["पोस\u{94d}ट", "पोस\u{94d}टल", "हॉर\u{94d}न"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("почта сурнайы"),
            keywords: &["почта", "почта сурнайы", "сурнай"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Posttroter"),
            keywords: &["Post", "Posttroter", "Troter"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແກເຂ\u{ebb}າສ\u{eb1}ດ"),
            keywords: &["ເຂ\u{ebb}າສ\u{eb1}ດ", "ແກ", "ແກເຂ\u{ebb}າສ\u{eb1}ດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("pašto ragas"),
            keywords: &["paštas", "pašto", "ragas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pastnieka taure"),
            keywords: &["pastnieka taure", "pastnieks", "taure"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("haona poutāpeta"),
            keywords: &["haona", "poutāpeta", "pōhi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("поштенски рог"),
            keywords: &["пошта", "поштенски", "рог"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പോസ\u{d4d}റ\u{d4d}റൽ ഹോൺ"),
            keywords: &[
                "പോസ\u{d4d}റ\u{d4d}റ\u{d4d}",
                "പോസ\u{d4d}റ\u{d4d}റൽ ഹോൺ",
                "ഹോൺ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("шуудангийн бүрээ"),
            keywords: &["бүрээ", "шуудан", "шуудангийн"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पोस\u{94d}टल हॉर\u{94d}न"),
            keywords: &["पोस\u{94d}ट", "पोस\u{94d}टल", "हॉर\u{94d}न"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("hon pos"),
            keywords: &["hon", "pos", "wakil pos"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("tromba postali"),
            keywords: &["posta", "postali", "qrun", "tromba postali"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စာတ\u{102d}\u{102f}က\u{103a}ခရာ"),
            keywords: &[
                "ခရာ",
                "စာတ\u{102d}\u{102f}က\u{103a}ခရာ",
                "တ\u{1036}ပ\u{102d}\u{102f}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("posthorn"),
            keywords: &["horn", "post", "posthorn"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पोस\u{94d}टल हर\u{94d}न"),
            keywords: &["पोस\u{94d}ट", "पोस\u{94d}टल", "हर\u{94d}न"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("posthoorn"),
            keywords: &["hoorn", "post", "posthoorn"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("posthorn"),
            keywords: &["horn", "post", "posthorn"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପୋଷ\u{b4d}ଟ\u{b3e}ଲ\u{b4d}\u{200c} ହର\u{b4d}ନ\u{b4d}\u{200c}"),
            keywords: &[
                "ପୋଷ\u{b4d}ଟ\u{b3e}ଲ\u{b4d}",
                "ପୋଷ\u{b4d}ଟ\u{b3e}ଲ\u{b4d}\u{200c} ହର\u{b4d}ନ\u{b4d}\u{200c}",
                "ହର\u{b4d}ଣ\u{b4d}ଣ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a4b}ਸਟਲ ਹਾਰਨ"),
            keywords: &["ਡਾਕ", "ਪ\u{a4b}ਸਟਲ ਹਾਰਨ", "ਹਾਰਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ڈاک دا بگل"),
            keywords: &["سینگ", "فوجی چوکی", "پوسٹل", "ڈاک دا بگل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Póst Ọ\u{301}fís Họn"),
            keywords: &[
                "Họn",
                "Post",
                "Póst Ọ\u{301}fís Họn",
                "Póst Ọ\u{301}fís Máta",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("trąbka pocztowa"),
            keywords: &["poczta", "pocztowa", "róg", "trąbka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پستي هارن"),
            keywords: &["هارن", "پستي هارن", "پوست", "پوسته"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("corneta postal"),
            keywords: &["corneta", "correios", "postal"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("trompa dos correios"),
            keywords: &["correios", "trompa", "trompa dos correios"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("chakipaq waqra"),
            keywords: &["chakipaq waqra", "chaski", "chaski wasi", "waqra"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("corn poștal"),
            keywords: &["corn", "corn poștal", "poștă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-684"),
            keywords: &["E10-684"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("почтовый рожок"),
            keywords: &["почта", "почтовый рожок", "рожок"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikondera"),
            keywords: &["cyerekeye iposita", "ihoni", "ikondera", "iposita"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پوسٽل هارون"),
            keywords: &["هارون، پوسٽ، پوسٽل", "پوسٽل هارون"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("තැපැල\u{dca} නල\u{dcf}ව"),
            keywords: &["තැපැල\u{dca}", "තැපෑල", "නල\u{dcf}ව"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("poštová trúba"),
            keywords: &["pošta", "poštová", "trúba"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("poštni rog"),
            keywords: &["poštni rog", "poštno", "rog"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("hoonka boostada"),
            keywords: &["boosto", "hoon", "hoonka boostada"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("briri i postës"),
            keywords: &["bori", "bri", "briri i postës", "postar", "postë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("поштанска труба"),
            keywords: &["пошта", "поштанска труба", "поштански", "рог"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["поштанска труба"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("poštanska truba"),
            keywords: &["pošta", "poštanska truba", "poštanski", "rog"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["poštanska truba"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("postsymbol"),
            keywords: &["posthorn", "postsymbol"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("honi ya posta"),
            keywords: &["honi", "honi ya posta", "posta"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("போஸ\u{bcd}டல\u{bcd} ஹ\u{bbe}ர\u{bcd}ன\u{bcd}"),
            keywords: &[
                "போஸ\u{bcd}டல\u{bcd}",
                "போஸ\u{bcd}டல\u{bcd} ஹ\u{bbe}ர\u{bcd}ன\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c4b}స\u{c4d}టల\u{c4d} హ\u{c3e}రన\u{c4d}"),
            keywords: &[
                "అత\u{c4d}యవసర మ\u{c46}య\u{c3f}ల\u{c4d} వస\u{c4d}త\u{c4b}ంద\u{c3f}",
                "ప\u{c4b}స\u{c4d}టల\u{c4d} హ\u{c3e}రన\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("сурнаи почта"),
            keywords: &["почта", "почтавӣ", "сурнаи почта", "сурнай"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แตรส\u{e48}งสาร"),
            keywords: &["สาร", "แตร", "แตรส\u{e48}งสาร"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("poçta kerneýi"),
            keywords: &["kerneý", "poçta", "poçta degişli", "poçta kerneýi"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻa fakakōkō"),
            keywords: &["meʻa fakakōkō"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("posta klaksonu"),
            keywords: &["klakson", "posta", "posta klaksonu"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("پوچتا گۈدۈكى"),
            keywords: &["سۇناي", "پوچتا", "پوچتا گۈدۈكى", "پوچتىچىلىق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("поштовий ріжок"),
            keywords: &["пошта", "поштовий", "ріжок"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پوسٹل ہارن"),
            keywords: &["ساز", "پوسٹل", "ہارن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("shoxsimon nay"),
            keywords: &["pochta", "pochtampt", "shox", "shoxsimon nay"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("kèn bưu chính"),
            keywords: &["bưu chính", "bưu điện", "kèn", "kèn bưu chính"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("mbiibu bataaxal"),
            keywords: &["bataaxal", "mbiibu", "post"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("uphondo lweposi"),
            keywords: &["iposi", "uphondo", "uphondo lweposi", "yeposi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("gbohùngbohùn ifiranṣẹ"),
            keywords: &["gbohùngbohùn", "gbohùngbohùn ifiranṣẹ", "ìfiránṣé\u{329}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("號角"),
            keywords: &["號角", "郵政"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("号角"),
            keywords: &["号角", "邮政"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("邮号"),
            keywords: &["号", "号角", "喇叭", "邮号", "邮政"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("郵件通知"),
            keywords: &["號角", "通知", "郵件通知"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("郵政號角"),
            keywords: &["通知", "郵政號角", "郵政通知"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umbhobo weposi"),
            keywords: &["iposi", "umbhobho", "umbhobho weposi", "umbhobo weposi"],
        },
    ],
};
#[doc = "🔔"]
pub const BELL: crate::Emoji = crate::Emoji {
    glyph: "🔔",
    codepoint: "1F514",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "bell",
    group: "Objects",
    subgroup: "sound",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("klokkie"),
            keywords: &["klokkie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ደውል"),
            keywords: &["ደውል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("جرس"),
            keywords: &["جرس", "كنيسة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ঘণ\u{9cd}ট\u{9be}"),
            keywords: &["ঘণ\u{9cd}ট\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("zəng"),
            keywords: &["zəng"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("званочак"),
            keywords: &["званочак"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("звънец"),
            keywords: &["звънец", "камбана"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বেল"),
            keywords: &["ঘণ\u{9cd}ট\u{9be}", "বেল"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kloc’h"),
            keywords: &["kloc’h"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zvono"),
            keywords: &["zvono"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("campana"),
            keywords: &["campana", "timbre"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄝𑄬𑄣\u{11134}"),
            keywords: &["𑄝𑄬𑄣\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏯᎸᏂ"),
            keywords: &["ᎤᏯᎸᏂ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zvonek"),
            keywords: &["zvon", "zvonek"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cloch"),
            keywords: &["cloch"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("klokke"),
            keywords: &["klokke"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Glocke"),
            keywords: &["Glocke", "Ton eingeschaltet"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κουδούνι"),
            keywords: &["καμπάνα", "κουδούνι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("bell"),
            keywords: &["bell"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("campana"),
            keywords: &["campana"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kelluke"),
            keywords: &["kell", "kelluke"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kanpaia"),
            keywords: &["kanpai", "kanpaia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("زنگ"),
            keywords: &["زنگ", "زنگوله", "ناقوس"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kirkonkello"),
            keywords: &["kello", "kirkonkello", "sointi", "ääni"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bell"),
            keywords: &["bell", "kuliling", "timbre"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("klokka"),
            keywords: &["klokka", "ljóð"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cloche"),
            keywords: &["cloche"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cloigín"),
            keywords: &["cloigín"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("clag"),
            keywords: &["clag"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("campá"),
            keywords: &["campá"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઘ\u{a82}ટ"),
            keywords: &["ઘ\u{a82}ટ", "દ\u{ac7}વાલય"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ƙararrawa"),
            keywords: &["ƙararrawa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פעמון"),
            keywords: &["פעמון", "צלצול"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("घ\u{902}टी"),
            keywords: &["घ\u{902}टी"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zvono"),
            keywords: &["zvono"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("harang"),
            keywords: &["harang"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("զանգ"),
            keywords: &["զանգ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("lonceng"),
            keywords: &["lonceng"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("mgbịrịgba"),
            keywords: &["mgbịrịgba"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("bjalla"),
            keywords: &["bjalla", "hringing"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("campana"),
            keywords: &["campana", "campanella"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ベル"),
            keywords: &["ベル", "鈴", "鐘"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("lonceng"),
            keywords: &["lonceng"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ზარი"),
            keywords: &["ზარი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қоңырау"),
            keywords: &["қоңырау"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("klokke"),
            keywords: &["klokke"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កណ\u{17d2}ត\u{17b9}ង"),
            keywords: &["កណ\u{17d2}ត\u{17b9}ង", "ជ\u{17bd}ង"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{cc6}ಲ\u{ccd}\u{200c}"),
            keywords: &["ಚಾಪಲ\u{ccd}", "ಬ\u{cc6}ಲ\u{ccd}\u{200c}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("종"),
            keywords: &["벨", "종"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("घा\u{902}ट"),
            keywords: &["घा\u{902}ट"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жылаажын"),
            keywords: &["жылаажын"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Klack"),
            keywords: &["Klack", "Schell"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກະດ\u{eb4}\u{ec8}ງ"),
            keywords: &["ກະດ\u{eb4}\u{ec8}ງ", "ໂບດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("varpelis"),
            keywords: &["varpelis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zvans"),
            keywords: &["zvans"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pere"),
            keywords: &["pere"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("ѕвоно"),
            keywords: &["ѕвоно", "ѕвонче"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മണി"),
            keywords: &["പള\u{d4d}ളി", "ബെൽ", "മണി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нээлттэй хонх"),
            keywords: &["нээлттэй хонх", "хонх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("घ\u{902}टा"),
            keywords: &["घ\u{902}टा"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("loceng"),
            keywords: &["loceng"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("qanpiena"),
            keywords: &["qanpiena"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ခေါင\u{103a}းလောင\u{103a}း"),
            keywords: &["ခေါင\u{103a}းလောင\u{103a}း"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bjelle"),
            keywords: &["bjelle", "klokke", "ringing"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("घण\u{94d}टी"),
            keywords: &["घण\u{94d}टी"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bel"),
            keywords: &["bel", "klok"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bjølle"),
            keywords: &["bjølle", "klokke", "ringing"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଘଣ\u{b4d}ଟ\u{b3f}"),
            keywords: &["ଘଣ\u{b4d}ଟ\u{b3f}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਘ\u{a70}ਟੀ"),
            keywords: &["ਘ\u{a70}ਟੀ", "ਚ\u{a48}ਪਲ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("گھنٹی"),
            keywords: &["گھنٹی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bẹl"),
            keywords: &["Bẹl"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("dzwonek"),
            keywords: &["dzwon", "dzwonek"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("زنګ"),
            keywords: &["زنګ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("sino"),
            keywords: &["sino"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("kampana"),
            keywords: &["kampana"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("clopoțel"),
            keywords: &["clopoțel", "sonerie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-720"),
            keywords: &["E10-720"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("колокольчик"),
            keywords: &["будильник", "звонок", "колокол", "колокольчик"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("inzogera"),
            keywords: &["inzogera"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("گهنٽي"),
            keywords: &["گهنٽي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dd3}න\u{dd4}ව"),
            keywords: &["ස\u{dd3}න\u{dd4}ව", "ස\u{dd3}න\u{dd4}\u{dd4}ව"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zvon"),
            keywords: &["zvon", "zvonček"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zvonec"),
            keywords: &["zvonec"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("jalas"),
            keywords: &["jalas"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("zile"),
            keywords: &["zile"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("звоно"),
            keywords: &["звоно"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["звоно"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("zvono"),
            keywords: &["zvono"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["zvono"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ringklocka"),
            keywords: &["klocka", "ljud", "ringklocka"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kengele"),
            keywords: &["kengele"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மணி"),
            keywords: &["ஒலி", "மணி", "மணியொலி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("గంట"),
            keywords: &[
                "గంట",
                "ర\u{c3f}ంగర\u{c4d}",
                "శబ\u{c4d}దం చ\u{c47}య\u{c3e}ల\u{c3f} చ\u{c3f}హ\u{c4d}నం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("зангӯлача"),
            keywords: &["зангӯлача"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("กระด\u{e34}\u{e48}ง"),
            keywords: &["กระด\u{e34}\u{e48}ง", "ระฆ\u{e31}ง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("jaň"),
            keywords: &["jaň"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fafangu"),
            keywords: &["fafangu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("zil"),
            keywords: &["kilise", "zil", "çan"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قوڭغۇراق"),
            keywords: &["قوڭغۇراق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("дзвінок"),
            keywords: &["дзвоник", "дзвін", "дзвінок"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گھنٹی"),
            keywords: &["آواز", "گھنٹی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qo‘ng‘iroq"),
            keywords: &["qo‘ng‘iroq", "qo‘ng‘iroqcha"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cái chuông"),
            keywords: &["cái chuông"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("joolooli"),
            keywords: &["joolooli"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intsimbi"),
            keywords: &["intsimbi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("agago"),
            keywords: &["agago"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("吊鐘"),
            keywords: &["吊鐘"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("吊钟"),
            keywords: &["吊钟"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("铃铛"),
            keywords: &["叮当", "响铃", "铃铛"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("鈴鐺"),
            keywords: &["鈴鐺"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("鐘"),
            keywords: &["鐘"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibheli"),
            keywords: &["ibheli", "insimbi"],
        },
    ],
};
#[doc = "🔕"]
pub const BELL_WITH_SLASH: crate::Emoji = crate::Emoji {
    glyph: "🔕",
    codepoint: "1F515",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "bell with slash",
    group: "Objects",
    subgroup: "sound",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("klok verbode"),
            keywords: &["gedemp", "klok", "nee", "stil", "verbied", "verbode"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የተሰረዘ ደወል"),
            keywords: &["ዝም ያለ", "የተሰረዘ ደወል", "ደወል", "ድምጸ ከል", "ጸጥታ ክልክል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ممنوع استخدام الجرس"),
            keywords: &[
                "جرس",
                "جرس عليه علامة إلغاء",
                "ممنوع استخدام الجرس",
                "ممنوع الصوت",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হেলনীয\u{9bc}\u{9be} চ\u{9cd}ছেদয\u{9c1}ক\u{9cd}ত ঘণ\u{9cd}ট\u{9be}ৰ ছবি"),
            keywords: &[
                "ঘণ\u{9cd}ট\u{9be}",
                "নিঃশব\u{9cd}দ",
                "নিম\u{9be}ত",
                "নিষিদ\u{9cd}ধ",
                "নীৰৱ",
                "হেলনীয\u{9bc}\u{9be} চ\u{9cd}ছেদয\u{9c1}ক\u{9cd}ত ঘণ\u{9cd}ট\u{9be}ৰ ছবি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("üstündən xətt çəkilmiş zəng"),
            keywords: &[
                "qadağa",
                "qadağan olunmuş",
                "sakit",
                "səssiz",
                "üstündən xətt çəkilmiş zəng",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("перакрэслены званочак"),
            keywords: &[
                "без гуку",
                "бязгучны",
                "забаронена",
                "званочак",
                "перакрэслены званочак",
                "ціха",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Зачертан звънец"),
            keywords: &["Зачертан звънец", "забранено", "звънец", "не", "тих"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9cd}ল\u{9cd}য\u{9be}শের স\u{9be}থে বেল"),
            keywords: &[
                "ঘণ\u{9cd}ট\u{9be}",
                "নিঃশব\u{9cd}দ",
                "নীরব",
                "শ\u{9be}ন\u{9cd}ত",
                "স\u{9cd}ল\u{9cd}য\u{9be}শের স\u{9be}থে বেল",
                "স\u{9cd}ল\u{9cd}য\u{9be}শের স\u{9be}থে বেল । নিষিদ\u{9cd}ধ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("prekriženo zvono"),
            keywords: &[
                "bez zvuka",
                "nečujno",
                "prekriženo zvono",
                "utišano",
                "zabranjeno",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("campana silenciada"),
            keywords: &[
                "campana",
                "campana ratllada",
                "campana silenciada",
                "prohibit",
                "silenci",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏯᎸᏂ ᎾᏍᎩ ᎬᏗ ᎤᏁᏍᏠᎥ"),
            keywords: &[
                "ᎡᎶᏪᎢ",
                "ᎢᏯᏛᏁᏗ ᏂᎨᏒᎾ",
                "ᎤᏯᎸᏂ",
                "ᎤᏯᎸᏂ ᎾᏍᎩ ᎬᏗ ᎤᏁᏍᏠᎥ",
                "ᎬᏅᏍᏓ",
                "ᏂᎨᏒᎾ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("přeškrtnutý zvonek"),
            keywords: &[
                "ne",
                "přeškrtnutý zvonek",
                "tichý",
                "zakázáno",
                "zltumení",
                "zvon",
                "zákaz",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cloch a slaes"),
            keywords: &["cloch", "cloch a slaes", "gwaharddedig", "mud", "na"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ingen klokke"),
            keywords: &["ingen klokke", "ingen lyd", "klokke med streg over"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("durchgestrichene Glocke"),
            keywords: &["Ton ausgeschaltet", "durchgestrichene Glocke"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κουδούνι με κόκκινη γραμμή"),
            keywords: &[
                "απαγορευμένο",
                "δεν επιτρέπεται",
                "καμπάνα",
                "κουδούνι",
                "κουδούνι με κόκκινη γραμμή",
                "σίγαση",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("bell with slash"),
            keywords: &[
                "bell",
                "bell with slash",
                "forbidden",
                "mute",
                "quiet",
                "silent",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("campana con signo de cancelación"),
            keywords: &[
                "campana",
                "campana con signo de cancelación",
                "cancelación",
                "ruido",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "campana",
                "campana con signo de cancelación",
                "campana tachada",
                "silencio",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("vaigistatud kelluke"),
            keywords: &[
                "keelatud",
                "kelluke",
                "kelluke keelumärgiga",
                "vaigistatud kelluke",
                "vaigistus",
                "vaikne",
                "vaikus",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kanpai marratua"),
            keywords: &[
                "debekatu",
                "galarazi",
                "isilarazi",
                "isilik",
                "isiltasuna",
                "kanpai marratua",
                "kanpaia",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("خط قرمز روی زنگوله"),
            keywords: &[
                "آرام",
                "بی\u{200c}صدا",
                "خط قرمز روی زنگوله",
                "زنگوله",
                "ساکت",
                "ممنوع",
                "نه",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("mykistetty kello"),
            keywords: &[
                "hiljaisuus",
                "kello",
                "kielto",
                "mykistetty kello",
                "mykistys",
                "äänetön",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bell na may slash"),
            keywords: &[
                "bawal",
                "bell na may slash",
                "mute",
                "silent",
                "slash",
                "tahimik",
                "timbre",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("klokka við skrástriku"),
            keywords: &[
                "doyvdur",
                "doyvt",
                "einki ljóð",
                "klokka",
                "klokka við skrástriku",
                "ljóðleyst",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("alarme désactivée"),
            keywords: &["alarme désactivée", "barrée", "cloche", "silence"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("cloche barrée"),
            keywords: &["barrée", "cloche", "silence", "silencieux"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cloigín ar ceal"),
            keywords: &["cloigín ar ceal"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("clag le loidhne troimhe"),
            keywords: &[
                "clag",
                "clag le loidhne troimhe",
                "diùltadh",
                "mùch",
                "sàmhach",
                "toirmisgte",
                "tost",
                "àicheadh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("campá tachada"),
            keywords: &["campá", "prohibido", "silencio", "tachada"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some(
                "અવાજ બ\u{a82}ધ સાથ\u{ac7}ન\u{ac1}\u{a82} ઘ\u{a82}ટન\u{ac1}\u{a82} ચિહ\u{acd}ન",
            ),
            keywords: &[
                "અવાજ નહી\u{a82}",
                "અવાજ બ\u{a82}ધ સાથ\u{ac7}ન\u{ac1}\u{a82} ઘ\u{a82}ટન\u{ac1}\u{a82} ચિહ\u{acd}ન",
                "ઘ\u{a82}ટ",
                "ઘ\u{a82}ટ નહી\u{a82}",
                "રદ કર\u{ac7}લા ચિહ\u{acd}ન સાથ\u{ac7}નો ઘ\u{a82}ટ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ƙararrawa mai maƙalatu"),
            keywords: &[
                "an hana",
                "a’a",
                "babu",
                "haram",
                "mai shiru",
                "shiru",
                "yi shiru",
                "ƙararrawa",
                "ƙararrawa mai maƙalatu",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פעמון מושתק"),
            keywords: &["מושתק", "פעמון", "שקט"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{94d}ल\u{948}श क\u{947} साथ घ\u{902}टी"),
            keywords: &[
                "घ\u{902}टी",
                "मौन",
                "म\u{94d}य\u{942}ट",
                "शा\u{902}त",
                "स\u{94d}ल\u{948}श क\u{947} साथ घ\u{902}टी",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("prekriženo zvono"),
            keywords: &[
                "isključen zvuk",
                "prekriženo zvono",
                "tišina",
                "zabranjeno",
                "zvono",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("áthúzott harang"),
            keywords: &[
                "harang",
                "néma",
                "némított",
                "némítás",
                "tilos",
                "tiltott",
                "áthúzott harang",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("զանգակ շեղ գծիկով"),
            keywords: &[
                "անջատել ձայնը",
                "արգելված",
                "զանգակ",
                "զանգակ շեղ գծիկով",
                "լուռ",
                "հանգիստ",
                "ոչ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("lonceng dicoret"),
            keywords: &[
                "bisu",
                "diam",
                "lonceng",
                "lonceng dicoret",
                "senyap",
                "terlarang",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("mgbịrịgba nwere mgbawa"),
            keywords: &[
                "a",
                "amaghọ",
                "amapụrụ",
                "egbochiri",
                "ekwughị okwu",
                "mgbịrịgba",
                "mgbịrịgba nwere mgbawa",
                "nwayọ",
                "ogbì",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("engin bjalla"),
            keywords: &[
                "bjalla",
                "ekkert hljóð",
                "engin bjalla",
                "yfirstrikuð bjalla",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("campana sbarrata"),
            keywords: &["campana", "campana sbarrata", "silenzio"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ベル消音"),
            keywords: &["ベル消音", "ミュート", "消音", "鈴", "鐘", "音無し"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("lonceng kacorek"),
            keywords: &[
                "anteng",
                "bisu",
                "larangan",
                "lonceng",
                "lonceng kacorek",
                "meneng",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ხაზგადასმული ზარი"),
            keywords: &[
                "აკრძალვა",
                "აკრძალულია",
                "არა",
                "დადუმება",
                "ზარი",
                "სიჩუმე",
                "სიწყნარე",
                "ხაზგადასმული ზარი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қоңырау дыбысы өшірілген"),
            keywords: &[
                "дыбыс өшіру",
                "тыйым салынған",
                "тыйым салынған қоңырау",
                "тыныш",
                "қоңырау",
                "қоңырау дыбысы өшірілген",
                "үнсіз",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ingen klokke"),
            keywords: &["ingen klokke", "ingen lyd", "klokke med streg over"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ជ\u{17bd}ងមានឆ\u{17d2}ន\u{17bc}តក\u{17d2}រហម"),
            keywords: &[
                "កណ\u{17d2}ដ\u{17b9}ង",
                "កណ\u{17d2}ដ\u{17b9}ងមានឆ\u{17d2}ន\u{17bc}តព\u{17b8}លើ",
                "ជ\u{17bd}ង",
                "ជ\u{17bd}ងមានឆ\u{17d2}ន\u{17bc}តក\u{17d2}រហម",
                "ប\u{17b7}ទស\u{17c6}ឡេង",
                "ស\u{17d2}ងាត\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{ccd}ರ\u{ccd}ಯಾಷ\u{ccd} ನೊಂದ\u{cbf}ಗ\u{cc6} ಬ\u{cc6}ಲ\u{ccd}"),
            keywords: &[
                "ಬ\u{cc6}ಲ\u{ccd}",
                "ಮ\u{ccd}ಯ\u{cc2}ಟ\u{ccd}",
                "ರದ\u{ccd}ದುಗೊಳ\u{cbf}ಸುವ\u{cbf}ಕ\u{cc6} ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}ಯೊಂದ\u{cbf}ಗ\u{cc6} ಬ\u{cc6}ಲ\u{ccd}",
                "ಸ\u{ccd}ತಬ\u{ccd}ಧ",
                "ಸ\u{ccd}ರ\u{ccd}ಯಾಷ\u{ccd} ನೊಂದ\u{cbf}ಗ\u{cc6} ಬ\u{cc6}ಲ\u{ccd}",
                "ಸ\u{ccd}ಲ\u{ccd}ಯಾಷ\u{ccd} ನೊಂದ\u{cbf}ಗ\u{cc6} ಬ\u{cc6}ಲ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("음소거"),
            keywords: &["소리 금지", "소리 없음", "음소거"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("स\u{94d}ल\u{945}श मारिल\u{94d}ली घा\u{902}ट"),
            keywords: &[
                "निषिध\u{94d}द",
                "ब\u{947}ल",
                "म\u{94d}य\u{941}ट",
                "शा\u{902}त",
                "शा\u{902}तताय",
                "स\u{94d}ल\u{945}श मारिल\u{94d}ली घा\u{902}ट",
                "स\u{94d}ल\u{945}श सयत ब\u{947}ल",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тыюу салынган жылаажын"),
            keywords: &[
                "жылаажын",
                "тынч",
                "тыюу салынган",
                "тыюу салынган жылаажын",
                "үнсүз",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("duerchgestrache Klack"),
            keywords: &[
                "Klack",
                "duerchgestrach",
                "duerchgestrache Klack",
                "keen Toun",
                "lautlos",
                "neen",
                "net",
                "roueg",
                "verbueden",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ບ\u{ecd}\u{ec8}ມ\u{eb5}ກະດ\u{eb4}\u{ec8}ງ"),
            keywords: &[
                "ກະດ\u{eb4}\u{ec8}ງ",
                "ບ\u{ecd}\u{ec8}ມ\u{eb5}ກະດ\u{eb4}\u{ec8}ງ",
                "ປ\u{eb4}ດສຽງ",
                "ຫ\u{ec9}າມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("perbrauktas varpelis"),
            keywords: &[
                "draudžiama",
                "nutildyti",
                "perbrauktas varpelis",
                "tyliai",
                "varpelis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pārsvītrots zvaniņš"),
            keywords: &[
                "aizliegts",
                "bez skaņas",
                "klusums",
                "pārsvītrots zvaniņš",
                "zvaniņš",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pere whai rītaha"),
            keywords: &[
                "hū",
                "kore",
                "kāo",
                "ngū",
                "pere",
                "pere whai rītaha",
                "rāhuitia",
                "whakakore",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("пречкртано ѕвонче"),
            keywords: &[
                "забрана",
                "исклучено",
                "пречкртано ѕвонче",
                "тивко",
                "ѕвонче",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മണി ശബ\u{d4d}ദം പ\u{d3e}ടില\u{d4d}ല"),
            keywords: &[
                "ബെല\u{d4d}ലിൽ വെട\u{d4d}ട\u{d4d}",
                "ബെൽ പ\u{d3e}ടില\u{d4d}ല",
                "മണി ശബ\u{d4d}ദം പ\u{d3e}ടില\u{d4d}ല",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хориглосон хонх"),
            keywords: &[
                "дууг хаасан",
                "хонх",
                "хонхны зургийг дарсан",
                "хориглосон",
                "чимээгүй",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{94d}ल\u{945}श चिन\u{94d}हासह घ\u{902}टा"),
            keywords: &[
                "आवाज ब\u{902}द",
                "घ\u{902}टा",
                "नाही",
                "निषिद\u{94d}ध",
                "प\u{94d}रतिब\u{902}धित",
                "बोल\u{942} नय\u{947}",
                "शा\u{902}त रहा",
                "स\u{94d}ल\u{945}श चिन\u{94d}हासह घ\u{902}टा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("loceng berpalang"),
            keywords: &["dilarang", "loceng", "loceng berpalang", "redam", "senyap"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("qanpiena bi slash"),
            keywords: &[
                "kwieta",
                "ma",
                "mhux",
                "mute",
                "pprojbiti",
                "qanpiena",
                "qanpiena bi slash",
                "siekta",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အသ\u{1036}ပ\u{102d}တ\u{103a} ခေါင\u{103a}းလောင\u{103a}း"),
            keywords: &[
                "ခေါင\u{103a}းလောင\u{103a}း",
                "တားမြစ\u{103a}ခြင\u{103a}း",
                "တ\u{102d}တ\u{103a}ဆ\u{102d}တ\u{103a}ခြင\u{103a}း",
                "ပ\u{102d}တ\u{103a}ထားခြင\u{103a}း",
                "မျဉ\u{103a}းစောင\u{103a}းဖြတ\u{103a}ထားသည\u{1037}\u{103a} ခေါင\u{103a}းလောင\u{103a}းပ\u{102f}\u{1036}",
                "အသ\u{1036}ပ\u{102d}တ\u{103a} ခေါင\u{103a}းလောင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("overstreket bjelle"),
            keywords: &[
                "bjelle med strek over",
                "ingen lyd",
                "klokke",
                "lydløs",
                "overstreket bjelle",
                "stille",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}ल\u{94d}याससहितको घण\u{94d}टी"),
            keywords: &[
                "घन\u{94d}टी",
                "च\u{941}प",
                "निष\u{947}धित",
                "मौन",
                "म\u{94d}य\u{941}ट",
                "स\u{94d}ल\u{94d}याससहितको घण\u{94d}टी",
                "स\u{94d}ल\u{94d}याससहितको घन\u{94d}टी",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("doorgestreepte bel"),
            keywords: &[
                "bel",
                "doorgestreepte bel",
                "geen",
                "geluid uit",
                "niet toegestaan",
                "stil",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("overstreka bjølle"),
            keywords: &[
                "bjølle med strek over",
                "ingen lyd",
                "klokke",
                "lydlaus",
                "overstreka bjølle",
                "stille",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b4d}ଲ\u{b3e}ଶ\u{b4d}\u{200c} ସହ\u{b3f}ତ ଘଣ\u{b4d}ଟ\u{b3f}"),
            keywords: &[
                "ଘଣ\u{b4d}ଟ\u{b3f}",
                "ନ\u{b3f}ଷ\u{b3f}ଦ\u{b4d}ଧ",
                "ନୀରବ",
                "ମ\u{b4d}ୟ\u{b41}ଟ\u{b4d}\u{200c}",
                "ଶ\u{b3e}ନ\u{b4d}ତ",
                "ସ\u{b4d}ଲ\u{b3e}ଶ ସହ\u{b3f}ତ ଘଣ\u{b4d}ଟ\u{b3f}",
                "ସ\u{b4d}ଲ\u{b3e}ଶ\u{b4d}\u{200c} ସହ\u{b3f}ତ ଘଣ\u{b4d}ଟ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬਿਨਾ\u{a02} ਆਵਾਜ\u{a3c} ਘ\u{a70}ਟੀ ਦਾ ਚਿ\u{a70}ਨ\u{a4d}ਹ"),
            keywords: &[
                "ਅਾਵਾਜ\u{a3c} ਨਹੀ\u{a02}",
                "ਘ\u{a70}ਟੀ",
                "ਘ\u{a70}ਟੀ ਨਹੀ\u{a02}",
                "ਬਿਨਾ\u{a02} ਆਵਾਜ\u{a3c} ਘ\u{a70}ਟੀ ਦਾ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਰ\u{a71}ਦ ਕਰਨ ਦ\u{a47} ਨਿਸ\u{a3c}ਾਨ ਨਾਲ ਘ\u{a70}ਟੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چابک نال گھنٹی"),
            keywords: &[
                "آواز بند کرنا",
                "حرام",
                "خاموش",
                "ممنوع کیتا",
                "نہیں",
                "چابک نال گھنٹی",
                "چ\u{64f}پ",
                "گھنٹی",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bẹl Wé Gẹ\u{301}t Laín Mak"),
            keywords: &[
                "Bẹl",
                "Bẹl Wé Gẹ\u{301}t Laín Mak",
                "Fọbid",
                "Kwáyẹt",
                "Miut",
                "Saílẹnt",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("przekreślony dzwonek"),
            keywords: &[
                "cicho",
                "cisza",
                "dzwonek",
                "nie wolno",
                "przekreślony dzwonek",
                "zabroniony",
                "zakazany",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سلش لرونکی زنګ"),
            keywords: &["خاموش", "زنګ", "سلش لرونکی زنګ", "غلې", "ممنوع"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("sino silenciado"),
            keywords: &[
                "mudo",
                "proibido",
                "quieto",
                "silencioso",
                "sino",
                "sino silenciado",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("sino com barra"),
            keywords: &[
                "não",
                "proibido",
                "silêncio",
                "sino",
                "sino com barra",
                "sino riscado",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("chʼin chhullupi"),
            keywords: &["chʼin chhullupi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("clopoțel tăiat"),
            keywords: &[
                "clopoțel",
                "clopoțel tăiat",
                "interzis",
                "liniște",
                "silențios",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-721"),
            keywords: &["E10-721"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("перечеркнутый колокольчик"),
            keywords: &[
                "будильник отключен",
                "колокол",
                "перечеркнутый колокольчик",
                "тихо",
                "тишина",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("inzogera inyujemo akarongo"),
            keywords: &[
                "gicecetse",
                "gituje",
                "gucekekesha",
                "hoya",
                "inzogera",
                "inzogera inyujemo akarongo",
                "kibujijwe",
                "no",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سليش سان گهنٽي"),
            keywords: &[
                "سليش سان گهنٽي",
                "گهنٽي، ڇڏيل، آواز بند، نه، نه، منع ڪيل، خاموش، ماٺ",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඉරක\u{dd2}න\u{dca} කැප\u{dd6} ස\u{dd3}න\u{dd4}ව"),
            keywords: &[
                "ඉරක\u{dd2}න\u{dca} කැප\u{dd6} ස\u{dd3}න\u{dd4}ව",
                "තහනම\u{dca} කළ",
                "න\u{dd2}ශ\u{dca}ශබ\u{dca}ද",
                "න\u{dd2}හඬ",
                "ස\u{dd3}න\u{dd4}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("prečiarknutý zvon"),
            keywords: &[
                "prečiarknutý zvon",
                "stlmené",
                "stíšené",
                "ticho",
                "zakázané zvonenie",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("prečrtan zvonec"),
            keywords: &[
                "brez zvoka",
                "molčeče",
                "ne",
                "ni dovoljeno",
                "prepovedano",
                "prečrtan zvonec",
                "tiho",
                "zvonec",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("jalas xariiqi saarantay"),
            keywords: &[
                "aamusan",
                "aan hadlayn",
                "jalas",
                "jalas xariiqi saarantay",
                "la mamnuucay",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("zile me vizë të pjerrët"),
            keywords: &["e heshtur", "pa zë", "zile", "zile me vizë të pjerrët"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("прецртано звоно"),
            keywords: &[
                "зaбрaњeнo",
                "звoнo",
                "искључeн звук",
                "прецртано звоно",
                "тишинa",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("precrtano zvono"),
            keywords: &[
                "isključen zvuk",
                "precrtano zvono",
                "tišina",
                "zabranjeno",
                "zvono",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("överstruken ringklocka"),
            keywords: &[
                "inget ljud",
                "ljudlös",
                "ringklocka",
                "överstruken ringklocka",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kengele yenye alama ya mkato"),
            keywords: &[
                "hapana",
                "katazwa",
                "kengele",
                "kengele yenye alama ya mkato",
                "kimya",
                "marufuku",
                "zima",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சத\u{bcd}தம\u{bcd} போடக\u{bcd}கூட\u{bbe}து"),
            keywords: &[
                "அமைதி",
                "சத\u{bcd}தமிட\u{bbe}தே",
                "சத\u{bcd}தம\u{bcd} போடக\u{bcd}கூட\u{bbe}து",
                "மணி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("గంట క\u{c4a}ట\u{c4d}టవద\u{c4d}దు"),
            keywords: &[
                "గంట క\u{c4a}ట\u{c4d}టవద\u{c4d}దు",
                "శబ\u{c4d}దం చ\u{c47}యవద\u{c4d}దు చ\u{c3f}హ\u{c4d}నం",
                "శబ\u{c4d}దం న\u{c3f}ల\u{c3f}ప\u{c3f}వ\u{c47}యబడ\u{c3f}ంద\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("зангӯлача бо хати каср"),
            keywords: &[
                "бесадо",
                "зангула",
                "зангӯлача бо хати каср",
                "мамнуъ",
                "манъшуда",
                "не",
                "хомӯш",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ไม\u{e48}ม\u{e35}กระด\u{e34}\u{e48}ง"),
            keywords: &[
                "ไม\u{e48}ม\u{e35}กระด\u{e34}\u{e48}ง",
                "ไม\u{e48}ม\u{e35}เส\u{e35}ยง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("üsti çyzyk jaň"),
            keywords: &[
                "bolanok",
                "gadagan",
                "jaň",
                "sessiz",
                "üsti çyzyk jaň",
                "ýuwaş",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fafangu matafa"),
            keywords: &["fafangu matafa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("üzeri çizili zil"),
            keywords: &["iptal işaretli çan", "ses yok", "çan", "üzeri çizili zil"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چەكلەنگەن قوڭغۇراق"),
            keywords: &[
                "ئۈنسىز",
                "ئەمەس",
                "تىنچ",
                "جىم",
                "قوڭغۇراق",
                "قىلماڭ",
                "ياق",
                "چەكلەنگەن",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("заглушений дзвінок"),
            keywords: &[
                "беззвучно",
                "глушити",
                "дзвінок",
                "дзвінок зі скісною рискою",
                "заборонено",
                "заглушений дзвінок",
                "тиша",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گھنٹی پر سلیش"),
            keywords: &["خاموشی", "سکوت", "ممانعت", "گھنٹی", "گھنٹی پر سلیش"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("taqiqlovchi chizig‘i bor qo‘ng‘iroq"),
            keywords: &[
                "man etilgan",
                "mumkin emas",
                "ovozsiz",
                "qoʻngʻiroqcha",
                "taqiqlangan",
                "taqiqlovchi chizig‘i bor qo‘ng‘iroq",
                "tinch",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("chuông với dấu gạch chéo"),
            keywords: &[
                "chuông",
                "chuông với dấu gạch chéo",
                "cấm",
                "im lặng",
                "tắt tiếng",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("joolooli ak buum"),
            keywords: &[
                "bul",
                "cellaaral",
                "déet",
                "joolooli",
                "joolooli ak buum",
                "luñ aaye",
                "luñ tere",
                "noppi",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intsimbi ehlatyiweyo"),
            keywords: &[
                "cwaka",
                "ethintelweyo",
                "ethuleyo",
                "hayi",
                "intsimbi",
                "intsimbi ehlatyiweyo",
                "nakanye",
                "thuleyo",
                "yalelwe",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("agogo pẹlu idinku"),
            keywords: &[
                "agogo",
                "agogo pẹlu idinku",
                "bẹ\u{301}ẹ\u{300} kó\u{329}",
                "kò",
                "àìlesọ\u{300}rọ\u{300}",
                "èèwọ\u{300}",
                "ṣèdíwó\u{329}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("有斜線嘅吊鐘"),
            keywords: &["不", "安靜", "有斜線嘅吊鐘", "沉默", "禁止", "鐘", "靜音"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("有斜线嘅吊钟"),
            keywords: &["不", "安静", "有斜线嘅吊钟", "沉默", "禁止", "钟", "静音"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("禁止响铃"),
            keywords: &["响铃关闭", "安静", "无声", "禁止响铃", "静音"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("靜音"),
            keywords: &["無聲", "靜音"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("冇聲嘅鐘"),
            keywords: &["冇聲", "冇聲嘅鐘", "無聲", "鐘", "靜音"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("insimbi enodwi"),
            keywords: &[
                "insimbi",
                "insimbi enodwi",
                "okuvinjiwe",
                "okwenqatshelwe",
                "qha",
                "ukucisha",
                "ukuthula",
            ],
        },
    ],
};
