#[doc = "⚗\u{fe0f}"]
pub const ALEMBIC: crate::Emoji = crate::Emoji {
    glyph: "⚗\u{fe0f}",
    codepoint: "2697 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "alembic",
    group: "Objects",
    subgroup: "science",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "⚗",
        codepoint: "2697",
        status: crate::Status::Unqualified,
        introduction_version: 1f32,
        name: "alembic",
        group: "Objects",
        subgroup: "science",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("alembiek"),
            keywords: &["alembiek", "chemie", "laboratorium"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አለምቢክ"),
            keywords: &["መሣሪያ", "አለምቢክ", "ኬምስትሪ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("أمبيق"),
            keywords: &["أداة", "أمبيق", "كيمياء"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("আলেম\u{9cd}বিক"),
            keywords: &[
                "আলেম\u{9cd}বিক",
                "স\u{981}জ\u{9c1}লি",
                "ৰস\u{9be}য\u{9bc}ন বিজ\u{9cd}ঞ\u{9be}ন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("distillə qazanı"),
            keywords: &["alət", "distillə qazanı", "kimya"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("перагонны куб"),
            keywords: &[
                "алхімія",
                "пасудзіна",
                "перагонны куб",
                "хімія",
                "інструмент",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("аламбик"),
            keywords: &["аламбик", "инструмент", "химия"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("অ\u{9cd}য\u{9be}লেমবিক"),
            keywords: &[
                "অ\u{9cd}য\u{9be}লেমবিক",
                "রস\u{9be}য\u{9bc}ন",
                "সরঞ\u{9cd}জ\u{9be}ম",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("lambig"),
            keywords: &["benveg", "kimiezh", "lambig"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("alembik"),
            keywords: &["alat", "alembik", "hemija"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("alambí"),
            keywords: &["alambí", "eina", "química"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎪᏙᏗ"),
            keywords: &["ᎠᎪᏙᏗ", "ᎬᏔᏂᏓᏍᏗ", "ᏓᏅᏍᏗᏍᎬᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("křivule"),
            keywords: &[
                "alembik",
                "chemie",
                "destilace",
                "destilační",
                "křivule",
                "nádobí",
                "náčiní",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("distyllydd"),
            keywords: &["cemeg", "distyllydd", "offeryn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kolbe"),
            keywords: &["kemi", "kolbe", "værktøj"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Destillierapparat"),
            keywords: &["Destillierapparat", "Werkzeug"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αποστακτήριο"),
            keywords: &["αποστακτήριο", "εργαλείο", "χημεία"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("alembic"),
            keywords: &["alembic", "chemistry", "tool"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("alambique"),
            keywords: &["alambique", "herramienta", "química"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["alambique", "destilar", "herramienta", "química"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("destilleerimisnõu"),
            keywords: &["destilleerimisnõu", "keemia", "tööriist"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("alanbikea"),
            keywords: &["alanbikea", "kimika", "tresna"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("انبیق"),
            keywords: &[
                "ابزار",
                "انبیق",
                "بالن",
                "شیمی",
                "صافی",
                "پاکشگر",
                "کیمیاگری",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tislauskolvi"),
            keywords: &["kemia", "tislauskolvi", "työkalu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("alembic"),
            keywords: &["alembic", "kagamitan", "kimika"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("dropadríva"),
            keywords: &["amboð", "dropadríva", "evnafrøði", "kemi"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("alambic"),
            keywords: &["alambic", "chimie", "outil"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("leamóg"),
            keywords: &["ceimic", "leamóg", "uirlis"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ceimigeachd"),
            keywords: &["acainn", "ceimigeachd", "inneal"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("alambique"),
            keywords: &["alambique", "augardente", "destilar", "química"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("અલ\u{ac7}મ\u{acd}બિક"),
            keywords: &[
                "અલ\u{ac7}મ\u{acd}બિક",
                "વરાળ ઠારીન\u{ac7} પ\u{acd}રવાહી શ\u{ac1}દ\u{acd}ધ કરવાન\u{ac1}\u{a82} સાધન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("alembic"),
            keywords: &["alembic", "kayan aiki", "kimiyya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מבחנת כימיה"),
            keywords: &["כימיה", "מבחנה", "מבחנת כימיה", "ניסוי"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("रासायनिक उपकरण"),
            keywords: &["ट\u{942}ल", "रसायन", "रासायनिक उपकरण"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("retorta"),
            keywords: &["alat", "kemija", "retorta"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("lombik"),
            keywords: &["eszköz", "felszerelés", "kémia", "lombik"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("թորիչ"),
            keywords: &["գործիք", "թորիչ", "քիմիա"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("alembic"),
            keywords: &["alat", "alembic", "kimia"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ngwaọrụ sayensi"),
            keywords: &["chemistri", "ngwaọrụ", "ngwaọrụ sayensi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("eimingarflaska"),
            keywords: &["efnafræði", "eimingarflaska"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("alambicco"),
            keywords: &["alambicco", "chimica", "esperimento", "strumento"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("蒸留器"),
            keywords: &["化学", "実験", "蒸留器"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pranti suling alembik"),
            keywords: &["alembik", "kimia", "pranti", "pranti suling alembik"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გამოსახდელი აპარატი"),
            keywords: &["გამოსახდელი აპარატი", "ინსტრუმენტი", "ქიმია", "ხელსაწყო"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("дистиллятор"),
            keywords: &["дистиллятор", "химия", "құрал"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kolbe"),
            keywords: &["kemi", "kolbe", "værktøj"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កែវសម\u{17d2}រាប\u{17cb}ធ\u{17d2}វើព\u{17b7}សោធន\u{17cd}"),
            keywords: &[
                "កែវ",
                "កែវសម\u{17d2}រាប\u{17cb}ធ\u{17d2}វើព\u{17b7}សោធន\u{17cd}",
                "ព\u{17b7}សោធន\u{17cd}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಭಟ\u{ccd}ಟ\u{cbf}ಪಾತ\u{ccd}ರ\u{cc6}"),
            keywords: &[
                "ಕ\u{cc6}ಮ\u{cbf}ಸ\u{ccd}ಟ\u{ccd}ರೀ",
                "ಟ\u{cc2}ಲ\u{ccd}",
                "ಪರ\u{cbf}ಕರ",
                "ಭಟ\u{ccd}ಟ\u{cbf}ಪಾತ\u{ccd}ರ\u{cc6}",
                "ರಸಾಯನ ಶಾಸ\u{ccd}ತ\u{ccd}ರ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("증류기"),
            keywords: &["정류", "정화", "증류", "증류기"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("अल\u{947}म\u{94d}बिक"),
            keywords: &["अल\u{947}म\u{94d}बिक", "रसायनशास\u{94d}त\u{94d}र", "साधन"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("дистиллятор"),
            keywords: &["дистиллятор", "курал", "химия"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Alembique"),
            keywords: &["Alembique", "Chimie", "Handwierksgeschir"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພາຊະນະກ\u{eb1}\u{ec8}ນ"),
            keywords: &[
                "ພາຊະນະກ\u{eb1}\u{ec8}ນ",
                "ວ\u{eb4}ທະຍາສາດ",
                "ເຄມ\u{eb5}",
                "ເຄ\u{eb7}\u{ec8}ອງມ\u{eb7}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("distiliavimo indas"),
            keywords: &["chemija", "distiliavimo indas", "įrankis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("destilēšanas aparāts"),
            keywords: &["destilēšanas aparāts", "mēģene", "ķīmija"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("taputapu iheunga"),
            keywords: &["mātai matū", "taputapu iheunga", "utauta"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("дестилатор"),
            keywords: &["алатка", "дестилатор", "хемија"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("അലെംബിക\u{d4d}"),
            keywords: &[
                "അലെംബിക\u{d4d}",
                "ഉപകരണം",
                "കെമിസ\u{d4d}\u{200c}ട\u{d4d}രി",
                "രസതന\u{d4d}ത\u{d4d}രം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нэрэх тогоо"),
            keywords: &["багаж", "нэрэх тогоо", "хими"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{94d}रयोगशाळ\u{947}त वापरल\u{947} जाणार\u{947} भा\u{902}ड\u{947}"),
            keywords: &[
                "प\u{94d}रयोगशाळ\u{947}त वापरल\u{947} जाणार\u{947} भा\u{902}ड\u{947}",
                "रसायनशास\u{94d}त\u{94d}र",
                "साधन",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("alembic"),
            keywords: &["alat", "alembic", "kimia"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("lampik"),
            keywords: &["għodda", "kimika", "lampik"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အင\u{103d}ေ\u{1037}ပြန\u{103a}ဘ\u{1030}း"),
            keywords: &[
                "ဓာတ\u{102f}ဗေဒ",
                "အင\u{103d}ေ\u{1037}ပြန\u{103a} ဖန\u{103a}ပြ\u{103d}န\u{103a}",
                "အင\u{103d}ေ\u{1037}ပြန\u{103a}ဘ\u{1030}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("destillerkolbe"),
            keywords: &["destillasjonskolbe", "destillerkolbe", "kjemi", "verktøy"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ऐल\u{947}म\u{94d}बिक"),
            keywords: &[
                "ऐल\u{947}म\u{94d}बिक",
                "क\u{947}म\u{947}स\u{94d}ट\u{94d}री",
                "साधन",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("distilleerkolf"),
            keywords: &["distilleerkolf", "gereedschap", "scheikunde"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("destillerkolbe"),
            keywords: &["destillasjonskolbe", "destillerkolbe", "kjemi", "verktøy"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଏଲେମ\u{b4d}ବ\u{b3f}କ\u{b4d}\u{200c}"),
            keywords: &[
                "ଏଲେମ\u{b4d}ବ\u{b3f}କ\u{b4d}\u{200c}",
                "କେମ\u{b3f}ଷ\u{b4d}ଟ\u{b4d}ର\u{b3f}",
                "ଯନ\u{b4d}ତ\u{b4d}ରପ\u{b3e}ତ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਰਸਾਇਣ ਔਜ\u{a3c}ਾਰ"),
            keywords: &["ਔਜ\u{a3c}ਾਰ", "ਰਸਾਇਣ", "ਰਸਾਇਣ ਵਿਗਿਆਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ق\u{64e}رنبیق"),
            keywords: &["اوزار", "ق\u{64e}رنبیق", "کیمیا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Alẹ\u{301}mbik"),
            keywords: &["Alẹ\u{301}mbik", "Kẹ\u{301}místri", "Tul"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("alembik"),
            keywords: &[
                "alembik",
                "chemia",
                "kolba",
                "menzurka",
                "naczynie",
                "probówka",
                "szklane",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("اليمبک"),
            keywords: &["اله", "اليمبک", "کيميا"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("alambique"),
            keywords: &["alambique", "ferramenta", "química"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("balão de vidro"),
            keywords: &["balão de vidro", "instrumento", "química"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("alambic"),
            keywords: &["alambic", "chimie", "instrument"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-088"),
            keywords: &["E10-088"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("перегонный сосуд"),
            keywords: &["аппарат", "куб", "перегонный", "сосуд", "химия"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("agacupa bayungururisha"),
            keywords: &["agacupa bayungururisha", "igikoresho", "ubutabire"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اليمبڪ"),
            keywords: &["اليمبڪ", "اوزار", "ڪيمسٽري"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ආස\u{dca}\u{200d}රැත ප\u{dcf}ත\u{dca}\u{200d}රය"),
            keywords: &[
                "ආස\u{dca}\u{200d}රැත ප\u{dcf}ත\u{dca}\u{200d}රය",
                "මෙවලම",
                "රස\u{dcf}යන\u{dd2}ක",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("krivuľa"),
            keywords: &["chémia", "krivuľa", "nástroja"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("destilator"),
            keywords: &["destilator", "kemija", "orodje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qalab nadiifin"),
            keywords: &["kimistari", "qalab", "qalab nadiifin"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("lambik"),
            keywords: &["aparat destilues", "kimi", "lambik"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("алембик"),
            keywords: &["aлaт", "алембик", "хeмиja"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("alembik"),
            keywords: &["alat", "alembik", "hemija"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("retort"),
            keywords: &["kemi", "retort"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("alembiki"),
            keywords: &["alembiki", "kemia", "zana"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அலெம\u{bcd}பிக\u{bcd}"),
            keywords: &[
                "அலெம\u{bcd}பிக\u{bcd}",
                "கருவி",
                "வடிகலன\u{bcd}",
                "வேதியியல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బట\u{c4d}ట\u{c3f}"),
            keywords: &[
                "బట\u{c4d}ట\u{c3f}",
                "రస\u{c3e}యనశ\u{c3e}స\u{c4d}త\u{c4d}రం",
                "స\u{c3e}ధనం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("аламбик"),
            keywords: &["аламбик", "асбоб", "кимиё"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("อ\u{e38}ปกรณ\u{e4c}กล\u{e31}\u{e48}น"),
            keywords: &[
                "ว\u{e34}ทยาศาสตร\u{e4c}",
                "สารเคม\u{e35}",
                "อ\u{e38}ปกรณ\u{e4c}กล\u{e31}\u{e48}น",
                "เคร\u{e37}\u{e48}องม\u{e37}อ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("suwuklyk gaby"),
            keywords: &["gural", "himiýa", "suwuklyk gaby"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("hina hakaʻanga"),
            keywords: &["hina hakaʻanga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("imbik"),
            keywords: &["alet", "damıtıcı", "imbik", "kimya"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ھورلاندۇرغۇچ"),
            keywords: &["خىمىيە", "قورال", "ھورلاندۇرغۇچ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("перегінний куб"),
            keywords: &["знаряддя", "перегінний куб", "хімія"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("الیمبک"),
            keywords: &["آلہ", "الیمبک"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("haydash kimyoviy shishasi"),
            keywords: &["asbob", "haydash kimyoviy shishasi", "kimyo"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bình chưng cất"),
            keywords: &["bình chưng cất", "dụng cụ", "hóa học"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("alembik"),
            keywords: &["alembik", "jumtukaay", "simi"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-alembic"),
            keywords: &["i-alembic", "ikhemistri", "isixhobo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àlẹ\u{301}mbìk"),
            keywords: &["irinṣé\u{329}", "kẹ\u{301}mísìrì", "àlẹ\u{301}mbìk"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("蒸餾器"),
            keywords: &["化學", "工具", "蒸餾器"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("蒸馏器"),
            keywords: &["化学", "工具", "蒸馏器"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("蒸馏器"),
            keywords: &["净化", "化学", "实验", "工具", "蒸馏器"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("蒸餾器"),
            keywords: &["化學", "蒸餾", "蒸餾器"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-alambic"),
            keywords: &["i-alambic", "ithuluzi", "khemistri"],
        },
    ],
};
#[doc = "🧪"]
pub const TEST_TUBE: crate::Emoji = crate::Emoji {
    glyph: "🧪",
    codepoint: "1F9EA",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "test tube",
    group: "Objects",
    subgroup: "science",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("proefbuis"),
            keywords: &[
                "chemie",
                "chemikus",
                "eksperiment",
                "laboratorium",
                "proefbuis",
                "wetenskap",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መፈተኛ ቱቦ"),
            keywords: &["መፈተኛ ቱቦ", "ሙከራ", "ሳይንስ", "ቀማሚ", "ኬሚስትሪ", "የሙከራ ክፍል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("أنبوب اختبار"),
            keywords: &["أنبوب اختبار", "تجربة", "علوم", "كيمياء", "كيميائي", "معمل"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("টেষ\u{9cd}ট টিউব"),
            keywords: &[
                "গৱেষণ\u{9be}গ\u{9be}ৰ",
                "টেষ\u{9cd}ট টিউব",
                "পৰীক\u{9cd}ষ\u{9be}",
                "বিজ\u{9cd}ঞ\u{9be}ন",
                "ৰস\u{9be}য\u{9bc}নবিদ",
                "ৰস\u{9be}য\u{9bc}\u{9cd}ন বিজ\u{9cd}ঞ\u{9be}ন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sınaq şüşəsi"),
            keywords: &[
                "eksperiment",
                "elm",
                "kimya",
                "kimyaçı",
                "laboratoriya",
                "sınaq şüşəsi",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("прабірка"),
            keywords: &[
                "лабараторыя",
                "навука",
                "прабірка",
                "хімік",
                "хімія",
                "эксперымент",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("епруветка"),
            keywords: &["експеримент", "епруветка", "лаборатория", "химик", "химия"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("টেস\u{9cd}ট টিউব"),
            keywords: &[
                "গবেষণ\u{9be}গ\u{9be}র",
                "টেস\u{9cd}ট টিউব",
                "পরীক\u{9cd}ষ\u{9be}",
                "বিজ\u{9cd}ঞ\u{9be}ন",
                "রস\u{9be}য\u{9bc}ন",
                "রস\u{9be}য\u{9bc}নবিদ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pibenn amprou"),
            keywords: &["kimiezh", "kimiour", "pibenn amprou"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("epruveta"),
            keywords: &[
                "eksperiment",
                "epruveta",
                "hemija",
                "hemičar",
                "laboratorija",
                "nauka",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("tub d’assaig"),
            keywords: &[
                "ciència",
                "experiment",
                "laboratori",
                "químic",
                "química",
                "tub d’assaig",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎦᏛᏗ ᎤᏒᏙᏂ"),
            keywords: &[
                "ᎠᎦᏙᎲᏍᏗ ᏅᏍᏗᏓᏅᎢ",
                "ᎠᎦᏛᏂᏓᏍᏗ",
                "ᎠᎦᏛᏗ ᎤᏒᏙᏂ",
                "ᎠᎦᏛᏙᏗ ᎧᏅᏑᎸ",
                "ᏧᏓᎴᏅᏓ ᏅᏫᏘ ᎠᏑᏰᏍᎩ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zkumavka"),
            keywords: &["chemie", "chemik", "laboratoř", "pokus", "věda", "zkumavka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("tiwb profi"),
            keywords: &[
                "arbrawf",
                "cemeg",
                "fferyllydd",
                "gwyddoniaeth",
                "lab",
                "tiwb profi",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("reagensglas"),
            keywords: &[
                "eksperiment",
                "forskning",
                "kemi",
                "kemiker",
                "laboratorium",
                "reagensglas",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Reagenzglas"),
            keywords: &["Chemie", "Experiment", "Labor", "Reagenzglas", "Versuche"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("δοκιμαστικός σωλήνας"),
            keywords: &[
                "δοκιμαστικός σωλήνας",
                "επιστήμη",
                "εργαστήριο",
                "πείραμα",
                "χημεία",
                "χημικός",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("test tube"),
            keywords: &[
                "chemist",
                "chemistry",
                "experiment",
                "lab",
                "science",
                "test tube",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("tubo de ensayo"),
            keywords: &[
                "ciencia",
                "experimento",
                "laboratorio",
                "química",
                "químico",
                "tubo de ensayo",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("katseklaas"),
            keywords: &["katse", "katseklaas", "keemia", "keemik", "labor", "teadus"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("saio-hodi"),
            keywords: &[
                "esperimentu",
                "kimika",
                "kimikari",
                "laborategi",
                "saio-hodi",
                "zientzia",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("لوله\u{654} آزمایشگاه"),
            keywords: &[
                "آزمایش",
                "دانش",
                "شمیدان",
                "شیمی",
                "لابراتوار",
                "لوله\u{654} آزمایشگاه",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("koeputki"),
            keywords: &[
                "kemia",
                "kemisti",
                "koe",
                "koeputki",
                "laboratorio",
                "tiede",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("test tube"),
            keywords: &[
                "chemist",
                "chemistry",
                "eksperimento",
                "kemikal",
                "laboratoryo",
                "siyensya",
                "test tube",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("royndarglas"),
            keywords: &["evnafrøði", "náttúruvísind", "roynd", "royndarglas"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("tube à essai"),
            keywords: &[
                "chimie",
                "chimiste",
                "expérience",
                "labo",
                "sciences",
                "tube à essai",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("triaileadán"),
            keywords: &[
                "ceimic",
                "ceimiceoir",
                "eolaíocht",
                "saotharlann",
                "triaileadán",
                "turgnamh",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("tiùb-deuchainne"),
            keywords: &[
                "ceimigeachd",
                "ceimigear",
                "cungaidhear",
                "deuchainn",
                "deuchainn-lann",
                "saidheans",
                "tiùb-deuchainne",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("tubo de ensaio"),
            keywords: &[
                "ciencia",
                "experimento",
                "laboratorio",
                "probeta",
                "química",
                "tubo de ensaio",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ટ\u{ac7}સ\u{acd}ટ ટ\u{acd}ય\u{ac2}બ"),
            keywords: &[
                "ટ\u{ac7}સ\u{acd}ટ ટ\u{acd}ય\u{ac2}બ",
                "પ\u{acd}રયોગ",
                "રસાયણશાસ\u{acd}ત\u{acd}ર",
                "રસાયણશાસ\u{acd}ત\u{acd}રી",
                "લ\u{ac7}બ",
                "વિજ\u{acd}ઞાન",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מבחנה"),
            keywords: &["כימיה", "מבחנה", "מדע", "מעבדה", "ניסויים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ट\u{947}स\u{94d}ट ट\u{94d}य\u{942}ब"),
            keywords: &[
                "ट\u{947}स\u{94d}ट ट\u{94d}य\u{942}ब",
                "प\u{94d}रयोग",
                "प\u{94d}रयोगशाला",
                "रसायनज\u{94d}ञ",
                "रसायनशास\u{94d}त\u{94d}र",
                "विज\u{94d}ञान",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("epruveta"),
            keywords: &[
                "eksperiment",
                "epruveta",
                "kemija",
                "kemičar",
                "laboratorij",
                "znanost",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kémcső"),
            keywords: &[
                "kémcső",
                "kémia",
                "kísérlet",
                "labor",
                "tudomány",
                "vegyészet",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("փորձանոթ"),
            keywords: &[
                "գիտություն",
                "լաբորատորիա",
                "փորձ",
                "փորձանոթ",
                "քիմիա",
                "քիմիկոս",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tabung uji"),
            keywords: &[
                "ahli kimia",
                "kimia",
                "lab",
                "percobaan",
                "sains",
                "tabung uji",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("tilraunaglas"),
            keywords: &[
                "efnafræði",
                "efnafræðingur",
                "tilraun",
                "tilraunaglas",
                "tilraunastofa",
                "vísindi",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("provetta"),
            keywords: &[
                "chimica",
                "chimico",
                "esperimenti",
                "laboratorio",
                "provetta",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("試験管"),
            keywords: &["ラボ", "化学", "実験", "試験管"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tabung reaksi"),
            keywords: &[
                "ahli kimia",
                "eksperimen",
                "kimia",
                "laborat",
                "sains",
                "tabung reaksi",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სინჯარა"),
            keywords: &[
                "ექსპერიმენტი",
                "ლაბორატორია",
                "მეცნიერება",
                "სინჯარა",
                "ქიმია",
                "ქიმიკოსი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шыны түтік"),
            keywords: &[
                "зертхана",
                "тәжірибе",
                "химик",
                "химия",
                "шыны түтік",
                "ғылым",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17c6}ពង\u{17cb}តេស\u{17d2}ត"),
            keywords: &[
                "គ\u{17b8}ម\u{17b8}វ\u{17b7}ទ\u{17bc}",
                "គ\u{17b8}ម\u{17b8}វ\u{17b7}ទ\u{17d2}យា",
                "ប\u{17c6}ពង\u{17cb}តេស\u{17d2}ត",
                "ព\u{17b7}សោធន\u{17cd}",
                "មន\u{17d2}ទ\u{17b8}រព\u{17b7}សោធន\u{17cd}",
                "វ\u{17b7}ទ\u{17d2}យាសាស\u{17d2}ត\u{17d2}រ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಟ\u{cc6}ಸ\u{ccd}ಟ\u{ccd} ಟ\u{ccd}ಯ\u{cc2}ಬ\u{ccd}"),
            keywords: &[
                "ಟ\u{cc6}ಸ\u{ccd}ಟ\u{ccd} ಟ\u{ccd}ಯ\u{cc2}ಬ\u{ccd}",
                "ಪ\u{ccd}ರಯೋಗ",
                "ರಸಾಯನಶಾಸ\u{ccd}ತ\u{ccd}ರ",
                "ರಸಾಯನಶಾಸ\u{ccd}ತ\u{ccd}ರಜ\u{ccd}ಞ",
                "ಲ\u{ccd}ಯಾಬ\u{ccd}",
                "ವ\u{cbf}ಜ\u{ccd}ಞಾನ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("시험관"),
            keywords: &["과학", "시험관", "실험", "연구실", "화학"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ट\u{947}स\u{94d}ट ट\u{94d}य\u{941}ब"),
            keywords: &[
                "ट\u{947}स\u{94d}ट ट\u{94d}य\u{941}ब",
                "प\u{94d}रयोग",
                "रसायन शास\u{94d}त\u{94d}र",
                "रसायनशास\u{94d}त\u{94d}रज\u{94d}ञ",
                "ल\u{945}ब",
                "विज\u{94d}ञान",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("медициналык пробирка"),
            keywords: &[
                "илим",
                "лаборатория",
                "медициналык пробирка",
                "тажрыйба",
                "химик",
                "химия",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{ebc}ອດທ\u{ebb}ດລອງ"),
            keywords: &[
                "ການທ\u{ebb}ດລອງ",
                "ນ\u{eb1}ກເຄມ\u{eb5}ສາດ",
                "ວ\u{eb4}ທະຍາສາດ",
                "ຫ\u{ebc}ອດທ\u{ebb}ດລອງ",
                "ຫ\u{ec9}ອງທ\u{ebb}ດລອງ",
                "ເຄມ\u{eb5}ສາດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mėgintuvėlis"),
            keywords: &[
                "bandymas",
                "chemija",
                "chemikas",
                "laboratorija",
                "mokslas",
                "mėgintuvėlis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("mēģene"),
            keywords: &[
                "eksperiments",
                "laboratorija",
                "mēģene",
                "zinātne",
                "ķīmija",
                "ķīmiķis",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("епрувета"),
            keywords: &[
                "експеримент",
                "епрувета",
                "лабораторија",
                "наука",
                "хемичар",
                "хемија",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ടെസ\u{d4d}റ\u{d4d}റ\u{d4d}\u{200c} ട\u{d4d}യ\u{d42}ബ\u{d4d}"),
            keywords: &[
                "ടെസ\u{d4d}റ\u{d4d}റ\u{d4d}\u{200c} ട\u{d4d}യ\u{d42}ബ\u{d4d}",
                "പരീക\u{d4d}ഷണം",
                "രസതന\u{d4d}ത\u{d4d}രം",
                "രസതന\u{d4d}ത\u{d4d}രശ\u{d3e}സ\u{d4d}ത\u{d4d}രജ\u{d4d}ഞൻ",
                "ല\u{d3e}ബ\u{d4d}",
                "സയൻസ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хуруу шил"),
            keywords: &[
                "лаб",
                "туршилт",
                "хими",
                "химич",
                "хуруу шил",
                "шинжлэх ухаан",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ट\u{947}स\u{94d}ट ट\u{94d}य\u{942}ब"),
            keywords: &[
                "क\u{947}मिस\u{94d}ट",
                "क\u{947}मिस\u{94d}ट\u{94d}री",
                "ट\u{947}स\u{94d}ट ट\u{94d}य\u{942}ब",
                "प\u{94d}रयोग",
                "ल\u{945}ब",
                "विज\u{94d}ञान",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tabung uji"),
            keywords: &[
                "ahli kimia",
                "eksperimen",
                "kimia",
                "makmal",
                "sains",
                "tabung uji",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဖန\u{103a}ပြ\u{103d}န\u{103a}"),
            keywords: &[
                "စမ\u{103a}းသပ\u{103a}ခန\u{103a}း",
                "စမ\u{103a}းသပ\u{103a}ခြင\u{103a}း",
                "ဓာတ\u{102f}ဗေဒ",
                "ဓာတ\u{102f}ဗေဒပညာရ\u{103e}င\u{103a}",
                "ဖန\u{103a}ပြ\u{103d}န\u{103a}",
                "သ\u{102d}ပ\u{1039}ပ\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("prøverør"),
            keywords: &[
                "eksperiment",
                "forskning",
                "kjemi",
                "kjemiker",
                "lab",
                "prøverør",
                "reagensrør",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ट\u{947}स\u{94d}ट ट\u{94d}य\u{941}ब"),
            keywords: &[
                "ट\u{947}स\u{94d}ट ट\u{94d}य\u{941}ब",
                "प\u{94d}रयोग",
                "प\u{94d}रयोगशाला",
                "रसायन शास\u{94d}त\u{94d}र",
                "रसायन शास\u{94d}त\u{94d}री",
                "विज\u{94d}ञान",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("reageerbuis"),
            keywords: &[
                "experiment",
                "laboratorium",
                "reageerbuis",
                "scheikunde",
                "scheikundige",
                "wetenschap",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("prøverøyr"),
            keywords: &[
                "eksperiment",
                "forsking",
                "kjemi",
                "kjemikar",
                "lab",
                "prøverøyr",
                "reagensrøyr",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଟେଷ\u{b4d}ଟ ଟ\u{b4d}ୟ\u{b41}ବ"),
            keywords: &[
                "ଟେଷ\u{b4d}ଟ ଟ\u{b4d}ୟ\u{b41}ବ",
                "ପ\u{b4d}ରୟୋଗ",
                "ପ\u{b4d}ରୟୋଗଶ\u{b3e}ଳ\u{b3e}",
                "ବ\u{b3f}ଜ\u{b4d}ଞ\u{b3e}ନ",
                "ରସ\u{b3e}ୟନ ବ\u{b3f}ଜ\u{b4d}ଞ\u{b3e}ନ",
                "ରସ\u{b3e}ୟନ ବ\u{b3f}ଦ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜਾ\u{a02}ਚ ਨਲੀ"),
            keywords: &[
                "ਕ\u{a48}ਮਿਸਟ",
                "ਜਾ\u{a02}ਚ ਨਲੀ",
                "ਪ\u{a4d}ਰਯ\u{a4b}ਗ",
                "ਰਸਾਇਣ-ਵਿਗਿਆਨ",
                "ਲ\u{a48}ਬ",
                "ਵਿਗਿਆਨ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tẹ\u{301}st Tub"),
            keywords: &[
                "Kẹ\u{301}mist",
                "Kẹ\u{301}místri",
                "Lab",
                "Sáyẹns",
                "Tẹ\u{301}st Tub",
                "Ẹspẹ\u{301}rímẹnt",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("probówka"),
            keywords: &[
                "chemia",
                "chemik",
                "eksperyment",
                "laboratorium",
                "nauka",
                "probówka",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ټسټ تيوب"),
            keywords: &["سائينس", "لابراتور", "ټسټ تيوب", "کيميا", "کيميا ګر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("tubo de ensaio"),
            keywords: &[
                "ciência",
                "experiência",
                "laboratório",
                "química",
                "químico",
                "tubo de ensaio",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("eprubetă"),
            keywords: &["chimie", "chimist", "eprubetă", "experiment", "laborator"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-052"),
            keywords: &["E11-052"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("пробирка"),
            keywords: &["лаборатория", "наука", "пробирка", "химия", "эксперимент"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٽيسٽ ٽيوب"),
            keywords: &["تجربو", "سائنس", "ليب", "ٽيسٽ ٽيوب", "ڪيمسٽري", "ڪيميادان"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පර\u{dd3}ක\u{dca}ෂණ නලය"),
            keywords: &[
                "අත\u{dca}හද\u{dcf} බැල\u{dd3}ම\u{dca}",
                "පර\u{dd3}ක\u{dca}ෂණ නලය",
                "පර\u{dd3}ක\u{dca}ෂණ\u{dcf}ග\u{dcf}රය",
                "රස\u{dcf}යන ව\u{dd2}ද\u{dca}\u{200d}ය\u{dcf}ව",
                "රස\u{dcf}යනඥය\u{dcf}",
                "ව\u{dd2}ද\u{dca}\u{200d}ය\u{dcf}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("skúmavka"),
            keywords: &[
                "chemik",
                "chémia",
                "laboratórium",
                "pokus",
                "skúmavka",
                "veda",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("epruveta"),
            keywords: &[
                "eksperiment",
                "epruveta",
                "kemija",
                "kemik",
                "laboratorij",
                "znanost",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("tuyuubka tijaabinta"),
            keywords: &[
                "kimistari",
                "kimistariyahan",
                "laab",
                "saynis",
                "tijaabin",
                "tuyuubka tijaabinta",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("epruvetë"),
            keywords: &["eksperiment", "epruvetë", "kimi", "kimist", "laborator"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("епрувета"),
            keywords: &[
                "експеримент",
                "епрувета",
                "лабораторија",
                "наука",
                "хемичар",
                "хемија",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("epruveta"),
            keywords: &[
                "eksperiment",
                "epruveta",
                "hemija",
                "hemičar",
                "laboratorija",
                "nauka",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("provrör"),
            keywords: &[
                "experiment",
                "kemi",
                "kemist",
                "labb",
                "provrör",
                "vetenskap",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("neli ya majaribio"),
            keywords: &[
                "kemia",
                "maabara",
                "majaribio",
                "mwanakemia",
                "neli ya majaribio",
                "sayansi",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சோதனைக\u{bcd} குழ\u{bbe}ய\u{bcd}"),
            keywords: &[
                "அறிவியல\u{bcd}",
                "ஆய\u{bcd}வுக\u{bcd}கூடம\u{bcd}",
                "சோதனைக\u{bcd} குழ\u{bbe}ய\u{bcd}",
                "பரிசோதனை",
                "வேதியியலர\u{bcd}",
                "வேதியியல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ట\u{c46}స\u{c4d}ట\u{c4d} ట\u{c4d}యూబ\u{c4d}"),
            keywords: &[
                "ట\u{c46}స\u{c4d}ట\u{c4d} ట\u{c4d}యూబ\u{c4d}",
                "ప\u{c4d}రయ\u{c4b}గం",
                "ప\u{c4d}రయ\u{c4b}గశ\u{c3e}ల",
                "రస\u{c3e}యన శ\u{c3e}స\u{c4d}త\u{c4d}రం",
                "రస\u{c3e}యన\u{c3f}క శ\u{c3e}స\u{c4d}త\u{c4d}రవ\u{c47}త\u{c4d}త",
                "వ\u{c3f}జ\u{c4d}ఞ\u{c3e}నశ\u{c3e}స\u{c4d}త\u{c4d}రం",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หลอดทดลอง"),
            keywords: &[
                "ทดลอง",
                "น\u{e31}กเคม\u{e35}",
                "หลอดทดลอง",
                "ห\u{e49}องแลป",
                "เคม\u{e35}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("probirka"),
            keywords: &[
                "barlaghana",
                "himik",
                "himiýa",
                "probirka",
                "tejribe",
                "ylym",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tiupi kemi"),
            keywords: &["tiupi kemi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("deney tüpü"),
            keywords: &[
                "bilim",
                "deney",
                "deney tüpü",
                "kimya",
                "kimyacı",
                "laboratuvar",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("пробірка"),
            keywords: &[
                "дослід",
                "експеримент",
                "лабораторія",
                "наука",
                "пробірка",
                "хімік",
                "хімія",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ٹیسٹ ٹیوب"),
            keywords: &["تجربہ", "سائنس", "لیب", "ٹیسٹ ٹیوب", "کیمسٹ", "کیمسٹری"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("probirka"),
            keywords: &[
                "fan",
                "kimyo",
                "kimyogar",
                "laboratoriya",
                "probirka",
                "tajriba",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ống nghiệm"),
            keywords: &[
                "hóa học",
                "khoa học",
                "nhà hóa học",
                "phòng thí nghiệm",
                "thí nghiệm",
                "ống nghiệm",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("試管"),
            keywords: &["化學", "化學家", "實驗", "實驗室", "科學", "試管"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("试管"),
            keywords: &["化学", "化学家", "实验", "实验室", "科学", "试管"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("试管"),
            keywords: &["化学", "化学家", "实验", "实验室", "科学", "试管"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("試管"),
            keywords: &["化學", "實驗", "科學", "試管"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["化學", "實驗", "科學｜實驗室", "試管"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ishubhu lokuhlola"),
            keywords: &[
                "chemist",
                "chemistry",
                "experiment",
                "ishubhu lokuhlola",
                "lab",
                "science",
            ],
        },
    ],
};
#[doc = "🧫"]
pub const PETRI_DISH: crate::Emoji = crate::Emoji {
    glyph: "🧫",
    codepoint: "1F9EB",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "petri dish",
    group: "Objects",
    subgroup: "science",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("petribakkie"),
            keywords: &[
                "bakterieë",
                "biologie",
                "bioloog",
                "laboratorium",
                "petribakkie",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የፔትሪ ዲሽ"),
            keywords: &["ባህል", "ባክቴሪያ", "ባዮሎጂ", "ቤተ ሙከራ", "የፔትሪ ዲሽ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("صحفة بتري"),
            keywords: &["أحياء", "أحيائي", "بكتيريا", "ثقافة", "صحفة بتري", "معمل"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("পেট\u{9cd}ৰি ডিশ\u{9cd}ব"),
            keywords: &[
                "গৱেষণ\u{9be}গ\u{9be}ৰ",
                "জীব বিজ\u{9cd}ঞ\u{9be}ন",
                "জীববিজ\u{9cd}ঞ\u{9be}নী",
                "পেট\u{9cd}ৰি ডিশ\u{9cd}ব",
                "বেক\u{9cd}টেৰিয\u{9bc}\u{9be}",
                "সংস\u{9cd}ক\u{9c3}তি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("Petri qabı"),
            keywords: &[
                "Petri qabı",
                "bakteriya",
                "biologiya",
                "bioloq",
                "kultura",
                "laboratoriya",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чашка Петры"),
            keywords: &[
                "бактэрыя",
                "біялогія",
                "біёлаг",
                "культура",
                "лабараторыя",
                "чашка Петры",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("блюдо на Петри"),
            keywords: &[
                "бактериална култура",
                "бактерия",
                "биолог",
                "биология",
                "блюдо на Петри",
                "лаборатория",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("পেট\u{9cd}রি ডিশ"),
            keywords: &[
                "গবেষণ\u{9be}গ\u{9be}র",
                "জীববিজ\u{9cd}ঞ\u{9be}নী",
                "জীববিদ\u{9cd}য\u{9be}",
                "পেট\u{9cd}রি ডিশ",
                "ব\u{9cd}য\u{9be}কটেরিয\u{9bc}\u{9be}",
                "সংস\u{9cd}ক\u{9c3}তি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("boest Petri"),
            keywords: &["bevoniezh", "bevoniour", "boest", "boest Petri"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("petri jelo"),
            keywords: &[
                "bakterija",
                "biolog",
                "biologija",
                "kultura",
                "laboratorija",
                "petri jelo",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("placa de Petri"),
            keywords: &[
                "bacteri",
                "biologia",
                "biòleg",
                "biòloga",
                "cultiu",
                "laboratori",
                "placa de Petri",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏩᎾᏬᏍᏒ ᏒᏙᏂ ᎤᎸᏌᏗ"),
            keywords: &[
                "ᎠᎦᏛᏙᏗ ᎧᏅᏑᎸ",
                "ᎤᏩᎾᏬᏍᏒ ᏒᏙᏂ ᎤᎸᏌᏗ",
                "ᎬᏃᏗ ᎠᎦᏎᏍᏙᏗ",
                "ᎬᏃᏗ ᏄᏍᏛ ᎤᏎᏍᏗᏕᎩ",
                "ᏄᏍᏛᎢᏕᎲ",
                "ᏬᏍᏗᎬ ᎬᏃᏗ ᎥᏳᎩ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("Petriho miska"),
            keywords: &[
                "Petriho miska",
                "bakterie",
                "biolog",
                "biologie",
                "buněčná kultura",
                "laboratoř",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dysgl petri"),
            keywords: &[
                "bacteria",
                "bioleg",
                "biologydd",
                "dysgl petri",
                "lab",
                "meithrin",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("petriskål"),
            keywords: &[
                "bakterie",
                "biolog",
                "biologi",
                "dyrkning",
                "laboratorie",
                "petriskål",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Petrischale"),
            keywords: &["Bakterien", "Bakterienkultur", "Biologie", "Petrischale"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τρυβλίο καλλιέργειας"),
            keywords: &[
                "βακτήρια",
                "βιολογία",
                "βιολόγος",
                "εργαστήριο",
                "καλλιέργεια",
                "τρυβλίο καλλιέργειας",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("petri dish"),
            keywords: &[
                "bacteria",
                "biologist",
                "biology",
                "culture",
                "lab",
                "petri dish",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("placa de petri"),
            keywords: &[
                "bacterias",
                "biología",
                "biólogo",
                "cultivo",
                "laboratorio",
                "placa de petri",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("placa de Petri"),
            keywords: &[
                "bacteria",
                "biología",
                "biólogo",
                "laboratorio",
                "microbio",
                "placa de Petri",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("placa de Petri"),
            keywords: &["placa de Petri"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("Petri tass"),
            keywords: &[
                "Petri tass",
                "bakterid",
                "bioloog",
                "bioloogia",
                "kultuur",
                "labor",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("Petriren kaxa"),
            keywords: &[
                "Petriren kaxa",
                "bakterio",
                "biologia",
                "biologo",
                "kultura",
                "laborategi",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ظرف کشت"),
            keywords: &[
                "آزمایشگاه",
                "باکتری",
                "زیست\u{200c}شناس",
                "زیست\u{200c}شناسی",
                "ظرف کشت",
                "لابراتوار",
                "کشت",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("petrimalja"),
            keywords: &[
                "bakteerikasvusto",
                "bakteerit",
                "biologi",
                "laboratorio",
                "petrimalja",
                "viljely",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("petri dish"),
            keywords: &[
                "bakterya",
                "biologist",
                "biology",
                "culture",
                "laboratoryo",
                "mikrobyo",
                "petri dish",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("petriskál"),
            keywords: &[
                "lívfrøði",
                "náttúruvísind",
                "petriskál",
                "tilbúningarglas",
                "tilbúningsglas",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("boîte de pétri"),
            keywords: &[
                "bactérie",
                "biologie",
                "biologiste",
                "boîte de pétri",
                "culture",
                "labo",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("mias Petri"),
            keywords: &[
                "baictéir",
                "bitheolaí",
                "bitheolaíocht",
                "mias Petri",
                "saotharlann",
                "saothrán",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("soitheach Petri"),
            keywords: &[
                "bacerium",
                "baictear",
                "bith-eòlaiche",
                "bith-eòlas",
                "deuchainn",
                "deuchainn-lann",
                "lobhag",
                "soitheach Petri",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("placa de Petri"),
            keywords: &[
                "Petri",
                "bacteria",
                "bioloxía",
                "cultivo",
                "laboratorio",
                "placa de Petri",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{ac7}ટ\u{acd}રી ડિશ"),
            keywords: &[
                "જીવવિજ\u{acd}ઞાન",
                "જીવવિજ\u{acd}ઞાની",
                "પ\u{ac7}ટ\u{acd}રી ડિશ",
                "બ\u{ac7}ક\u{acd}ટ\u{ac7}રિયા",
                "લ\u{ac7}બ",
                "સ\u{a82}વર\u{acd}ધન",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("צלחת פטרי"),
            keywords: &[
                "ביולוגיה",
                "חיידקים",
                "מעבדה",
                "ניסויים",
                "צלחת פטרי",
                "תרבית",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{947}ट\u{94d}री डिश"),
            keywords: &[
                "कल\u{94d}चर",
                "जीवविज\u{94d}ञान",
                "जीवविज\u{94d}ञानी",
                "प\u{947}ट\u{94d}री डिश",
                "प\u{94d}रयोगशाला",
                "ब\u{948}क\u{94d}टीरिया",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("petrijeva zdjelica"),
            keywords: &[
                "bakterije",
                "biolog",
                "biologija",
                "kultura",
                "laboratorij",
                "petrijeva zdjelica",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("Petri-csésze"),
            keywords: &[
                "Petri-csésze",
                "baktérium",
                "biológia",
                "biológus",
                "labor",
                "tenyészet",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("պետրիի բաժակ"),
            keywords: &[
                "բակտերիա",
                "լաբորատորիա",
                "կենսաբան",
                "կենսաբանություն",
                "կուլտուրա",
                "պետրիի բաժակ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("cawan petri"),
            keywords: &[
                "ahli biologi",
                "bakteri",
                "biologi",
                "cawan petri",
                "kultur",
                "lab",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("petrílskál"),
            keywords: &[
                "baktería",
                "gerlaflóra",
                "líffræði",
                "líffræðingur",
                "petrílskál",
                "tilraunastofa",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("piastra di Petri"),
            keywords: &[
                "batteri",
                "biologia",
                "biologo",
                "cultura",
                "piastra di Petri",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ペトリ皿"),
            keywords: &["バクテリア", "ペトリ皿", "培養", "生物学"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("cawan petri"),
            keywords: &[
                "ahli biologi",
                "bakteri",
                "biologi",
                "cawan petri",
                "kultur",
                "laborat",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("პეტრის თასი"),
            keywords: &[
                "ბაქტერია",
                "ბიოლოგი",
                "ბიოლოგია",
                "ლაბორატორია",
                "პეტრის თასი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("Петри ыдысы"),
            keywords: &[
                "Петри ыдысы",
                "бактерия",
                "биолог",
                "биология",
                "зертхана",
                "мәдениет",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ចានបណ\u{17d2}ដ\u{17bb}ះកោស\u{17b7}កា"),
            keywords: &[
                "ចានបណ\u{17d2}ដ\u{17bb}ះកោស\u{17b7}កា",
                "ជ\u{17b8}វវ\u{17b7}ទ\u{17bc}",
                "ជ\u{17b8}វវ\u{17b7}ទ\u{17d2}យា",
                "បាក\u{17cb}តេរ\u{17b8}",
                "មន\u{17d2}ទ\u{17b8}រព\u{17b7}សោធន\u{17cd}",
                "វប\u{17d2}បធម\u{17cc}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪ\u{cc6}ಟ\u{ccd}ರ\u{cbf} ಡ\u{cbf}ಶ\u{ccd}"),
            keywords: &[
                "ಜೀವಶಾಸ\u{ccd}ತ\u{ccd}ರ",
                "ಜೀವಶಾಸ\u{ccd}ತ\u{ccd}ರಜ\u{ccd}ಞ",
                "ಪ\u{cc6}ಟ\u{ccd}ರ\u{cbf} ಡ\u{cbf}ಶ\u{ccd}",
                "ಬ\u{ccd}ಯಾಕ\u{ccd}ಟೀರ\u{cbf}ಯಾ",
                "ಲ\u{ccd}ಯಾಬ\u{ccd}",
                "ಸಂಸ\u{ccd}ಕೃತ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("페트리 접시"),
            keywords: &["미생물", "박테리아", "생물학", "실험실", "페트리 접시"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("प\u{947}ट\u{94d}री डीश"),
            keywords: &[
                "जीवशास\u{94d}त\u{94d}र",
                "ज\u{948}वशास\u{94d}त\u{94d}रज\u{94d}ञ",
                "प\u{947}ट\u{94d}री डीश",
                "ब\u{945}क\u{94d}ट\u{947}रिया",
                "ल\u{945}ब",
                "स\u{902}स\u{94d}क\u{943}ती",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("Петри идиши"),
            keywords: &[
                "Петри идиши",
                "бактерия",
                "биолог",
                "биология",
                "лаборатория",
                "маданият",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຖ\u{ec9}ວຍບ\u{eb1}ນຈ\u{eb8}ທາດຫ\u{ec9}ອງທ\u{ebb}ດລອງ"),
            keywords: &[
                "ຊ\u{eb5}ວະສາດ",
                "ຖ\u{ec9}ວຍບ\u{eb1}ນຈ\u{eb8}ທາດຫ\u{ec9}ອງທ\u{ebb}ດລອງ",
                "ນ\u{eb1}ກຊ\u{eb5}ວະສາດ",
                "ວ\u{eb1}ດທະນາທ\u{ecd}າ",
                "ຫ\u{ec9}ອງທ\u{ebb}ດລອງ",
                "ແບກເທ\u{eb5}ເລຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("petri lėkštelė"),
            keywords: &[
                "bakterijos",
                "bakterijų auginimas",
                "biologas",
                "biologija",
                "petri lėkštelė",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("Petri trauks"),
            keywords: &[
                "Petri trauks",
                "baktērija",
                "biologs",
                "bioloģija",
                "kultūra",
                "laboratorija",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("петриев сад"),
            keywords: &[
                "бактерија",
                "биолог",
                "биологија",
                "култура",
                "лабораторија",
                "петриев сад",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പെട\u{d4d}രി ഡിഷ\u{d4d}"),
            keywords: &[
                "ജീവശ\u{d3e}സ\u{d4d}ത\u{d4d}രം",
                "ജീവശ\u{d3e}സ\u{d4d}\u{200c}ത\u{d4d}രജ\u{d4d}ഞൻ",
                "പെട\u{d4d}രി ഡിഷ\u{d4d}",
                "ബ\u{d3e}ക\u{d4d}\u{200c}ടീരിയ",
                "ല\u{d3e}ബ\u{d4d}",
                "സംസ\u{d4d}\u{200c}ക\u{d4d}ക\u{d3e}രം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("петрийн аяга"),
            keywords: &[
                "бактер",
                "биологи",
                "биологич",
                "лаб",
                "петрийн аяга",
                "соёл",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{947}ट\u{94d}री डिश"),
            keywords: &[
                "कल\u{94d}चर",
                "प\u{947}ट\u{94d}री डिश",
                "बायोलॉजिस\u{94d}ट",
                "बायोलॉजी",
                "ब\u{945}क\u{94d}ट\u{947}रिया",
                "ल\u{945}ब",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("piring petri"),
            keywords: &[
                "ahli biologi",
                "bakteria",
                "biologi",
                "kultur",
                "makmal",
                "piring petri",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ဓာတ\u{103a}ခ\u{103d}\u{1032}ခန\u{103a}းသ\u{102f}\u{1036}း ဖန\u{103a}ပြားခ\u{103d}က\u{103a}",
            ),
            keywords: &[
                "ဇ\u{102e}ဝပညာရ\u{103e}င\u{103a}",
                "ဇ\u{102e}ဝဗေဒ",
                "ဓာတ\u{103a}ခ\u{103d}\u{1032}ခန\u{103a}း",
                "ဓာတ\u{103a}ခ\u{103d}\u{1032}ခန\u{103a}းသ\u{102f}\u{1036}း ဖန\u{103a}ပြားခ\u{103d}က\u{103a}",
                "ဗက\u{103a}တ\u{102e}းရ\u{102e}းယား",
                "ဗက\u{103a}တ\u{102e}းရ\u{102e}းယား မ\u{103d}ေးမြ\u{1030}ခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("petriskål"),
            keywords: &[
                "bakterie",
                "biolog",
                "biologi",
                "kultur",
                "lab",
                "petriskål",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{947}ट\u{94d}री डिस"),
            keywords: &[
                "कल\u{94d}चर",
                "जीव विज\u{94d}ञान",
                "जीवशास\u{94d}त\u{94d}री",
                "प\u{947}ट\u{94d}री डिस",
                "प\u{94d}रयोगशाला",
                "ब\u{94d}याक\u{94d}ट\u{947}रिया",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("petrischaal"),
            keywords: &[
                "bacterie",
                "biologie",
                "bioloog",
                "cultuur",
                "laboratorium",
                "petrischaal",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("petriskål"),
            keywords: &[
                "bakterie",
                "biolog",
                "biologi",
                "kultur",
                "lab",
                "petriskål",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପେଟ\u{b4d}ର\u{b3f} ଡ\u{b3f}ସ\u{b4d}\u{200c}"),
            keywords: &[
                "କଲଚର",
                "ପେଟ\u{b4d}ର\u{b3f} ଡ\u{b3f}ସ\u{b4d}\u{200c}",
                "ବ\u{b3e}ଓଲୋଜ\u{b3f}",
                "ବ\u{b3e}ଓଲୋଜ\u{b3f}ଷ\u{b4d}ଟ",
                "ବ\u{b4d}ୟ\u{b3e}କ\u{b4d}ଟେର\u{b3f}ଆ",
                "ଲ\u{b4d}ୟ\u{b3e}ବ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a48}ਟਰੀ ਡਿਸ\u{a3c}"),
            keywords: &[
                "ਜੀਵ-ਵਿਗਿਆਨ",
                "ਜੀਵ-ਵਿਗਿਆਨੀ",
                "ਪ\u{a48}ਟਰੀ ਡਿਸ\u{a3c}",
                "ਬ\u{a48}ਕਟੀਰੀਆ",
                "ਲ\u{a48}ਬ",
                "ਸ\u{a71}ਭਿਆਚਾਰ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pẹ\u{301}trí Plet"),
            keywords: &[
                "Bayọ\u{301}lọ\u{301}ji",
                "Bayọ\u{301}lọ\u{301}jí Ẹ\u{301}spat",
                "Báktéria",
                "Lab",
                "Pẹ\u{301}trí Plet",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("płytka Petriego"),
            keywords: &[
                "bakteria",
                "biolog",
                "biologia",
                "kultura",
                "laboratorium",
                "płytka Petriego",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پيټري ډش"),
            keywords: &[
                "بيالوژي",
                "بکتيريا",
                "د بيالوژي پوهاند",
                "لابراتور",
                "پيټري ډش",
                "کلتور",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("placa de Petri"),
            keywords: &[
                "bactéria",
                "biologia",
                "biólogo",
                "cultura",
                "laboratório",
                "placa de Petri",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("vas Petri"),
            keywords: &[
                "bacterii",
                "biolog",
                "biologie",
                "cultură",
                "laborator",
                "vas Petri",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-053"),
            keywords: &["E11-053"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("чашка Петри"),
            keywords: &[
                "бактерии",
                "биология",
                "лаборатория",
                "чашка Петри",
                "эксперимент",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پيٽري ڊش"),
            keywords: &[
                "بايو لاجسٽ",
                "بايو لاجي",
                "بيڪٽيريا",
                "ليب",
                "پيٽري ڊش",
                "ڪلچر",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පෙට\u{dca}\u{200d}ට\u{dca}\u{200d}ර\u{dd2} ද\u{dd3}ස\u{dd2}ය"),
            keywords: &[
                "ජ\u{dd3}වව\u{dd2}ද\u{dca}\u{200d}ය\u{dcf}ඥය\u{dcf}",
                "ජ\u{dd3}වව\u{dd2}ද\u{dca}\u{200d}ය\u{dcf}ව",
                "පර\u{dd3}ක\u{dca}ෂණ\u{dcf}ග\u{dcf}රය",
                "පෙට\u{dca}\u{200d}ට\u{dca}\u{200d}ර\u{dd2} ද\u{dd3}ස\u{dd2}ය",
                "බැක\u{dca}ට\u{dd3}ර\u{dd2}ය\u{dcf}",
                "වග\u{dcf}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("Petriho miska"),
            keywords: &[
                "Petriho miska",
                "baktéria",
                "biológ",
                "biológia",
                "kultúra",
                "laboratórium",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("petrijevka"),
            keywords: &[
                "bakterije",
                "biolog",
                "biologija",
                "kultura",
                "laboratorij",
                "petrijevka",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("saxan wax laga dhex arki karo"),
            keywords: &[
                "bakteeriya",
                "bayoolaji",
                "bayoolajiyahan",
                "dhaqan",
                "laab",
                "saxan wax laga dhex arki karo",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("lamelë"),
            keywords: &["kulturë", "laborator", "lamelë", "lamë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("петријева шоља"),
            keywords: &[
                "бактерија",
                "биолог",
                "биологија",
                "култура",
                "лабораторија",
                "петријева шоља",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("petrijeva šolja"),
            keywords: &[
                "bakterija",
                "biolog",
                "biologija",
                "kultura",
                "laboratorija",
                "petrijeva šolja",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("petriskål"),
            keywords: &["bakterie", "biolog", "biologi", "labb", "petriskål"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("chombo cha kupondea"),
            keywords: &[
                "bakteria",
                "biolojia",
                "chombo cha kupondea",
                "maabara",
                "mwanabiolojia",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பெட\u{bcd}ரி டிஷ\u{bcd}"),
            keywords: &[
                "ஆய\u{bcd}வகம\u{bcd}",
                "உயிரியல\u{bbe}ளர\u{bcd}",
                "உயிரியல\u{bcd}",
                "கல\u{bbe}ச\u{bcd}ச\u{bbe}ரம\u{bcd}",
                "ப\u{bbe}க\u{bcd}ட\u{bc0}ரிய\u{bbe}",
                "பெட\u{bcd}ரி டிஷ\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c46}ట\u{c4d}ర\u{c3f} డ\u{c3f}ష\u{c4d}"),
            keywords: &[
                "ఉత\u{c4d}ప\u{c3e}దన",
                "జ\u{c40}వశ\u{c3e}స\u{c4d}త\u{c4d}ర న\u{c3f}పుణులు",
                "జ\u{c40}వశ\u{c3e}స\u{c4d}త\u{c4d}రం",
                "ప\u{c46}ట\u{c4d}ర\u{c3f} డ\u{c3f}ష\u{c4d}",
                "ప\u{c4d}రయ\u{c4b}గశ\u{c3e}ల",
                "బ\u{c4d}య\u{c3e}క\u{c4d}ట\u{c40}ర\u{c3f}య\u{c3e}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("จานเพาะเช\u{e37}\u{e49}อ"),
            keywords: &[
                "จานเพาะเช\u{e37}\u{e49}อ",
                "ช\u{e35}วว\u{e34}ทยา",
                "น\u{e31}กช\u{e35}วว\u{e34}ทยา",
                "ห\u{e49}องแลป",
                "เพาะเช\u{e37}\u{e49}อ",
                "แบคท\u{e35}เร\u{e35}ย",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("petri çaşkasy"),
            keywords: &[
                "bakteriýa",
                "barlaghana",
                "biolog",
                "biologiýa",
                "kultura",
                "petri çaşkasy",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tisi kemi"),
            keywords: &["tisi kemi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("petri kabı"),
            keywords: &[
                "bakteri",
                "biyolog",
                "biyoloji",
                "kültür",
                "laboratuvar",
                "petri kabı",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("чашка Петрі"),
            keywords: &[
                "бактерія",
                "біолог",
                "біологія",
                "культура",
                "лабораторія",
                "чашка Петрі",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پیٹری ڈش"),
            keywords: &[
                "بائیالوجسٹ",
                "بائیالوجی",
                "بیکٹیریا",
                "ثقافت",
                "لیب",
                "پیٹری ڈش",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("petri idishi"),
            keywords: &[
                "bakteriya",
                "biologiya",
                "laboratoriya",
                "petri idishi",
                "tajriba",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đĩa petri"),
            keywords: &[
                "nhà sinh vật học",
                "nuôi cấy",
                "phòng thí nghiệm",
                "sinh vật học",
                "vi khuẩn",
                "đĩa petri",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("培養皿"),
            keywords: &["培養皿", "實驗室", "文化", "生物學", "生物學家", "細菌"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("培养皿"),
            keywords: &["培养皿", "实验室", "文化", "生物学", "生物学家", "细菌"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("培养皿"),
            keywords: &["培养", "培养皿", "实验室", "生物学", "生物学家", "细菌"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("培養皿"),
            keywords: &["培養皿", "基因", "實驗", "生物學家", "細菌"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["培養皿", "實驗室｜實驗", "生物學家", "細菌｜生物"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("petri dish"),
            keywords: &[
                "bacteria",
                "biologist",
                "biology",
                "culture",
                "lab",
                "petri dish",
            ],
        },
    ],
};
#[doc = "🧬"]
pub const DNA: crate::Emoji = crate::Emoji {
    glyph: "🧬",
    codepoint: "1F9EC",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "dna",
    group: "Objects",
    subgroup: "science",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("dna"),
            keywords: &["bioloog", "dna", "evolusie", "gene", "genetika", "lewe"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ዲኤንኤ"),
            keywords: &["ህይወት", "ለውጥ", "የባዮሎጂ ሰው", "ዲኤንኤ", "ጄኔቲክስ", "ጅን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("الحامض النووي"),
            keywords: &[
                "أحيائي",
                "الحامض النووي",
                "الحياة",
                "تطور",
                "جين",
                "علم الجينات",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ডিএনএ"),
            keywords: &[
                "জিন",
                "জীববিজ\u{9cd}ঞ\u{9be}নী",
                "জীৱন",
                "ডিএনএ",
                "বংশগত",
                "বিবৰ\u{9cd}তন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("dnt"),
            keywords: &["bioloq", "dnt", "gen", "genetika", "təkamül", "yaşam"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ДНК"),
            keywords: &["ДНК", "біёлаг", "ген", "генетыка", "жыццё", "эвалюцыя"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("ДНК"),
            keywords: &["ДНК", "биолог", "генетика", "гени", "еволюция", "живот"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ডিএনএ"),
            keywords: &[
                "জিন",
                "জীবন",
                "জীববিজ\u{9cd}ঞ\u{9be}নী",
                "জেনেটিক\u{9cd}স",
                "ডিএনএ",
                "বিবর\u{9cd}তন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("TDN"),
            keywords: &["TDN", "bevoniour"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("dnk"),
            keywords: &["biolog", "dnk", "evolucija", "gen", "genetika", "život"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("adn"),
            keywords: &[
                "adn",
                "biòleg",
                "biòloga",
                "evolució",
                "gen",
                "genètica",
                "vida",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏧᏚᎪᏔᏅ ᎬᏃᏗ ᏧᏓᎴᏅᎲ"),
            keywords: &[
                "ᎬᏂᏛ",
                "ᎬᏃᏗ ᎤᏓᏁᏟᏴᏒ ᏧᎶᏒᎢ",
                "ᎬᏃᏗ ᏄᏍᏛ ᎤᏎᏍᏗᏕᎩ",
                "ᏧᏚᎪᏔᏅ ᎬᏃᏗ ᏧᏓᎴᏅᎲ",
                "ᏧᏚᎪᏔᏅ ᎬᏃᏗ ᏧᏓᎴᏅᎲ ᎤᏓᏰᎶᏒᎢ",
                "ᏧᏚᎪᏔᏅ ᎬᏃᏗ ᏧᏓᎴᏅᎲ ᎤᏓᏰᎶᏒᎢ ᎤᎾᎦᏎᏍᏗᏕᎩ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("DNA"),
            keywords: &[
                "DNA",
                "biologie",
                "evoluce",
                "gen",
                "genetika",
                "šroubovice",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dna"),
            keywords: &["biolegydd", "bywyd", "dna", "esblygiad", "geneteg", "genyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("dna"),
            keywords: &["biolog", "dna", "evolution", "gen", "genetik", "liv"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("DNA"),
            keywords: &["Biologie", "DNA", "Evolution", "Genetik", "Leben"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("dna"),
            keywords: &["dna", "βιολόγος", "γενετικός", "γονίδια", "εξέλιξη", "ζωή"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("dna"),
            keywords: &["biologist", "dna", "evolution", "gene", "genetics", "life"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("DNA"),
            keywords: &[
                "DNA",
                "biologist",
                "dna",
                "evolution",
                "gene",
                "genetics",
                "life",
            ],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("adn"),
            keywords: &["adn", "biólogo", "evolución", "gen", "genética", "vida"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("ADN"),
            keywords: &["ADN", "biólogo", "evolución", "gen", "genética", "vida"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("ADN"),
            keywords: &["ADN"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("DNA"),
            keywords: &["DNA", "bioloog", "elu", "evolutsioon", "geen", "geneetika"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("DNA"),
            keywords: &["DNA", "biologo", "bizitza", "eboluzio", "gene", "genetika"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دی\u{200c}ان\u{200c}ای"),
            keywords: &[
                "تکامل",
                "دی\u{200c}ان\u{200c}ای",
                "زندگی",
                "زیست\u{200c}شناس",
                "وراثت",
                "ژن",
                "ژنتیک",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("dna"),
            keywords: &[
                "biologi",
                "dna",
                "evoluutio",
                "geeni",
                "genetiikka",
                "perimä",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("dna"),
            keywords: &["biologist", "buhay", "dna", "ebolusyon", "gene", "genetics"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("dna"),
            keywords: &[
                "arvaeind",
                "dna",
                "lív",
                "lívfrøði",
                "lívmenning",
                "náttúruvísind",
                "ílega",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("adn"),
            keywords: &["adn", "biologiste", "gène", "génétique", "vie", "évolution"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ADN"),
            keywords: &["ADN", "bitheolaí", "géin", "géinitic", "saol", "éabhlóid"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("dna"),
            keywords: &[
                "beatha",
                "bith-eòlaiche",
                "bith-eòlas",
                "dna",
                "eòlas-gintinneachd",
                "gine",
                "gintinneachd",
                "gnè-fhàs",
                "mean-fhàs",
                "tarmachadh-gnè",
                "èabhlaid",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("ADN"),
            keywords: &["ADN", "bioloxía", "evolución", "vida", "xene", "xenética"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ડીએનએ"),
            keywords: &[
                "ઉત\u{acd}ક\u{acd}રા\u{a82}તિ",
                "જનીન",
                "જિન\u{ac7}ટિક\u{acd}સ",
                "જીવન",
                "જીવવિજ\u{acd}ઞાની",
                "ડીએનએ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("די אנ איי"),
            keywords: &[
                "אבולוציה",
                "ביולוגיה",
                "גנטיקה",
                "גנים",
                "די אנ איי",
                "חיים",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("डीएनए"),
            keywords: &[
                "आन\u{941}व\u{902}शिक विज\u{94d}ञान",
                "जीवन",
                "जीवविज\u{94d}ञानी",
                "डीएनए",
                "व\u{902}शाण\u{941}",
                "विकास",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("dnk"),
            keywords: &["biologija", "dnk", "evolucija", "genetika", "geni", "život"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("DNS"),
            keywords: &["DNS", "biológia", "fejlődés", "genetika", "gének", "élet"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("դնթ"),
            keywords: &[
                "գենետիկա",
                "դնթ",
                "էվոլյուցիա",
                "կենսաբան",
                "կենսաբանություն",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("dna"),
            keywords: &[
                "ahli biologi",
                "dna",
                "evolusi",
                "gen",
                "genetik",
                "kehidupan",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("dna"),
            keywords: &["dna", "erfðaefni", "gen", "líf", "líffræðingur", "þróun"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("dna"),
            keywords: &["biologo", "dna", "evoluzione", "genetica", "geni", "vita"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("DNA"),
            keywords: &["DNA", "生物学", "進化", "遺伝子"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("adn"),
            keywords: &[
                "adn",
                "ahli biologi",
                "evolusi",
                "gen",
                "genetik",
                "kauripan",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დნმ"),
            keywords: &["ბიოლოგი", "გენეტიკა", "გენი", "დნმ", "ევოლუცია", "სიცოცხლე"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("днк"),
            keywords: &["биолог", "ген", "генетика", "днк", "эволюция", "өмір"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("DNA"),
            keywords: &[
                "DNA",
                "ការវ\u{17b7}វត\u{17d2}ត",
                "ជ\u{17b8}វវ\u{17b7}ទ\u{17bc}",
                "ជ\u{17b8}វ\u{17b7}ត",
                "សេនេទ\u{17b7}ច",
                "សែន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಡ\u{cbf}ಎನ\u{ccd}ಎ"),
            keywords: &[
                "ಜೀನ\u{ccd}",
                "ಜೀವನ",
                "ಜೀವಶಾಸ\u{ccd}ತ\u{ccd}ರಜ\u{ccd}ಞ",
                "ಜ\u{cc6}ನ\u{cc6}ಟ\u{cbf}ಕ\u{ccd}ಸ\u{ccd}",
                "ಡ\u{cbf}ಎನ\u{ccd}ಎ",
                "ವ\u{cbf}ಕಸನ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("DNA"),
            keywords: &["DNA", "생물", "생물학", "유전", "유전학", "진화"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("डीएनए"),
            keywords: &[
                "उत\u{94d}क\u{94d}रा\u{902}ती",
                "जनक",
                "जननशास\u{94d}त\u{94d}र",
                "जीवन",
                "जीवशास\u{94d}त\u{94d}रज\u{94d}ञ",
                "डीएनए",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("днк"),
            keywords: &["биология", "ген", "генетика", "днк", "жашоо", "эволюция"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("DNA"),
            keywords: &[
                "DNA",
                "ກ\u{ec8}ຽວກ\u{eb1}ບຍ\u{eb5}\u{ec9}ນ",
                "ຊ\u{eb5}ວ\u{eb4}ດ",
                "ຍ\u{eb5}\u{ec9}ນ",
                "ນ\u{eb1}ກຊ\u{eb5}ວະວ\u{eb4}ທະຍາ",
                "ວ\u{eb4}ວ\u{eb1}ດທະນາການ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("DNR"),
            keywords: &[
                "DNR",
                "biologas",
                "evoliucija",
                "genas",
                "genetika",
                "gyvybė",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("DNS"),
            keywords: &["DNS", "biologs", "dzīve", "evolūcija", "gēns", "ģenētika"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("днк"),
            keywords: &["биолог", "ген", "генетика", "днк", "еволуција", "живот"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഡിഎൻഎ"),
            keywords: &[
                "ജനിതകശ\u{d3e}സ\u{d4d}\u{200c}ത\u{d4d}രം",
                "ജീവശ\u{d3e}സ\u{d4d}\u{200c}ത\u{d4d}രജ\u{d4d}ഞൻ",
                "ജീവൻ",
                "ജീൻ",
                "ഡിഎൻഎ",
                "പരിണ\u{d3e}മം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ДНА"),
            keywords: &["ДНА", "амьдрал", "биологич", "ген", "генетик", "хувьсал"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("डीएनए"),
            keywords: &[
                "उत\u{94d}क\u{94d}रा\u{902}ती",
                "जिन\u{947}टिक\u{94d}स",
                "जीन",
                "डीएनए",
                "बायोलॉजिस\u{94d}ट",
                "लाईफ",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("dna"),
            keywords: &["ahli biologi", "dna", "evolusi", "gen", "genetik", "hayat"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မျ\u{102d}\u{102f}းရ\u{102d}\u{102f}းဗ\u{102e}ဇ"),
            keywords: &[
                "ဆင\u{1037}\u{103a}က\u{1032}ဖြစ\u{103a}စဥ\u{103a}",
                "ဇ\u{102e}ဝပညာရ\u{103e}င\u{103a}",
                "ဗ\u{102e}ဇ",
                "မျ\u{102d}\u{102f}းရ\u{102d}\u{102f}းဗ\u{102e}ဇ",
                "မျ\u{102d}\u{102f}းရ\u{102d}\u{102f}းဗ\u{102e}ဇပညာ",
                "သက\u{103a}ရ\u{103e}\u{102d}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("dna"),
            keywords: &[
                "biolog",
                "dna",
                "evolusjon",
                "gen",
                "gener",
                "genetikk",
                "liv",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("डिएनए"),
            keywords: &[
                "क\u{94d}रमिक विकास",
                "जिन",
                "जिन विज\u{94d}ञान",
                "जीवन",
                "जीवशास\u{94d}त\u{94d}री",
                "डिएनए",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("DNA"),
            keywords: &["DNA", "bioloog", "evolutie", "gen", "genetica", "leven"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("dna"),
            keywords: &["biolog", "dna", "evolusjon", "gen", "genetikk", "liv"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଡ\u{b3f}ଏନ\u{b4d}\u{200c}ଏ"),
            keywords: &[
                "ଜ\u{b3f}ନ\u{b4d}\u{200c}",
                "ଜୀବନ",
                "ଜେନେଟ\u{b3f}କ\u{b4d}ସ",
                "ଡ\u{b3f}ଏନ\u{b4d}\u{200c}ଏ",
                "ବ\u{b3e}ଓଲୋଜ\u{b3f}ଷ\u{b4d}ଟ",
                "ଶ\u{b3f}କ\u{b4d}ଷ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਡੀਐਨਏ"),
            keywords: &[
                "ਜਣਨ ਵਿ\u{a71}ਦਿਆ",
                "ਜੀਨ",
                "ਜੀਵ-ਵਿਗਿਆਨਕ",
                "ਜੀਵਨ",
                "ਡੀਐਨਏ",
                "ਵਿਕਾਸ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("DNA"),
            keywords: &[
                "Bayọ\u{301}lọ\u{301}jí Ẹ\u{301}spat",
                "DNA",
                "Jiin",
                "Jẹnẹ\u{301}tiks",
                "Laif",
                "Ívolúshọn",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("dna"),
            keywords: &["biolog", "dna", "ewolucja", "gen", "genetyka", "życie"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ډي اين ای"),
            keywords: &["ارتقاء", "جينيايي", "د بيالوژي پوهاند", "ډي اين ای", "ژوند"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("dna"),
            keywords: &["biólogo", "dna", "evolução", "gene", "genética", "vida"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("adn"),
            keywords: &["adn", "biólogo", "evolução", "gene", "genética", "vida"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ADN"),
            keywords: &["ADN", "biolog", "evoluție", "genetică", "genă", "viață"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-054"),
            keywords: &["E11-054"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("ДНК"),
            keywords: &["ДНК", "биология", "генетика", "гены", "эволюция"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڊي اين اي"),
            keywords: &["ارتقا", "بايولاجسٽ", "جين", "جينيٽڪس", "زندگي", "ڊي اين اي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඩ\u{dd3}එන\u{dca}ඒ"),
            keywords: &[
                "ජ\u{dcf}න",
                "ජ\u{dcf}න ව\u{dd2}ද\u{dca}\u{200d}ය\u{dcf}ව",
                "ජ\u{dd3}වව\u{dd2}ද\u{dca}\u{200d}ය\u{dcf}ඥය\u{dcf}",
                "ජ\u{dd3}ව\u{dd2}තය",
                "ඩ\u{dd3}එන\u{dca}ඒ",
                "පර\u{dd2}ණ\u{dcf}මය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("skrutkovica"),
            keywords: &["biológ", "genetika", "gén", "skrutkovica", "život"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("dnk"),
            keywords: &["biolog", "dnk", "evolucija", "gen", "genetika", "življenje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dna"),
            keywords: &["bayoolajiyahan", "dna", "hide", "horumar", "nolol"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("ADN"),
            keywords: &["ADN", "biolog", "evoluim", "gjene", "gjenetikë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("днк"),
            keywords: &["биолог", "ген", "генетика", "днк", "еволуција", "живот"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("dnk"),
            keywords: &["biolog", "dnk", "evolucija", "gen", "genetika", "život"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("DNA"),
            keywords: &["DNA", "biolog", "evolution", "gen", "genetik", "liv"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("dna"),
            keywords: &["biologist", "dna", "jenetiki", "jeni", "mageuko", "maisha"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &[
                "dna",
                "jenetiki",
                "jeni",
                "mageuko",
                "maisha",
                "mwanabiolojia",
            ],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("டிஎன\u{bcd}ஏ"),
            keywords: &[
                "உயிரியல\u{bbe}ளர\u{bcd}",
                "டிஎன\u{bcd}ஏ",
                "பரிண\u{bbe}மம\u{bcd}",
                "மரபணு",
                "மரபியல\u{bcd}",
                "வ\u{bbe}ழ\u{bcd}க\u{bcd}கை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("డ\u{c3f}ఎన\u{c4d}ఎ"),
            keywords: &[
                "ఆవ\u{c3f}ర\u{c4d}భ\u{c3e}వం",
                "జన\u{c4d}యువు",
                "జన\u{c4d}యుశ\u{c3e}స\u{c4d}త\u{c4d}రం",
                "జ\u{c40}వశ\u{c3e}స\u{c4d}త\u{c4d}ర న\u{c3f}పుణులు",
                "జ\u{c40}వ\u{c3f}తం",
                "డ\u{c3f}ఎన\u{c4d}ఎ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ด\u{e35}เอ\u{e47}นเอ"),
            keywords: &[
                "ช\u{e35}ว\u{e34}ต",
                "ด\u{e35}เอ\u{e47}นเอ",
                "น\u{e31}กช\u{e35}วว\u{e34}ทยา",
                "ย\u{e35}น",
                "ว\u{e34}ว\u{e31}ฒนาการ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("dnk"),
            keywords: &["biolog", "dnk", "ewolýusiýa", "gen", "genetika", "ýaşaýyş"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("TNA"),
            keywords: &["TNA"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("dna"),
            keywords: &["biyolog", "dna", "evrim", "gen", "genetik", "yaşam"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("ДНК"),
            keywords: &["ДНК", "біолог", "ген", "генетика", "еволюція", "життя"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ڈی این اے"),
            keywords: &[
                "ارتقاء",
                "بائیالوجسٹ",
                "جین",
                "جینیات",
                "زندگی",
                "ڈی این اے",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("dnk"),
            keywords: &[
                "biologiya",
                "dnk",
                "evolyutsiya",
                "gen",
                "genetika",
                "genlar",
                "hayot",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("adn"),
            keywords: &[
                "adn",
                "di truyền",
                "gien",
                "nhà sinh vật học",
                "sự sống",
                "tiến hóa",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("DNA"),
            keywords: &["DNA", "基因", "生命", "生物學家", "進化", "遺傳學"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("DNA"),
            keywords: &["DNA", "基因", "生命", "生物学家", "进化", "遗传学"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("DNA"),
            keywords: &["DNA", "基因", "生命", "生物学家", "进化", "遗传学"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("DNA"),
            keywords: &["DNA", "基因", "演化", "生命", "生物學家"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ulibofuzo"),
            keywords: &[
                "biologist",
                "evolution",
                "gene",
                "genetics",
                "life",
                "ulibofuzo",
            ],
        },
    ],
};
#[doc = "🔬"]
pub const MICROSCOPE: crate::Emoji = crate::Emoji {
    glyph: "🔬",
    codepoint: "1F52C",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "microscope",
    group: "Objects",
    subgroup: "science",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("mikroskoop"),
            keywords: &["mikroskoop", "ondersoek", "vergroot"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ማይክሮስኮፕ"),
            keywords: &["መሣሪያ", "ማይክሮስኮፕ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ميكروسكوب"),
            keywords: &["أداة", "ميكروسكوب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("অন\u{9c1}বীক\u{9cd}ষণ যন\u{9cd}ত\u{9cd}ৰ"),
            keywords: &[
                "অন\u{9c1}বীক\u{9cd}ষণ যন\u{9cd}ত\u{9cd}ৰ",
                "বিজ\u{9cd}ঞ\u{9be}ন",
                "স\u{981}জ\u{9c1}লি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("mikroskop"),
            keywords: &["alət", "mikroskop"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мікраскоп"),
            keywords: &["мікраскоп", "прыбор", "інструмент"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("микроскоп"),
            keywords: &["инструмент", "микроскоп"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9be}ইক\u{9cd}রোস\u{9cd}কোপ"),
            keywords: &[
                "বিজ\u{9cd}ঞ\u{9be}ন",
                "ম\u{9be}ইক\u{9cd}রোস\u{9cd}কোপ",
                "সরঞ\u{9cd}জ\u{9be}ম",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("mikroskop"),
            keywords: &["benveg", "mikroskop", "skiant"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("mikroskop"),
            keywords: &["alat", "mikroskop"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("microscopi"),
            keywords: &["augment", "ciència", "eina", "microscopi"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏍᏗ ᎪᎱᏍᏗ ᎠᎪᎵᏱᏍᏙᏗ"),
            keywords: &["ᎠᎬᏛᏂᏓᏍᏗ", "ᎤᏍᏗ ᎪᎱᏍᏗ ᎠᎪᎵᏱᏍᏙᏗ", "ᎬᏔᏂᏓᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mikroskop"),
            keywords: &["mikroskop", "nástroj", "věda", "vědecký", "zvětšení"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("microsgop"),
            keywords: &["microsgop", "offeryn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mikroskop"),
            keywords: &["mikroskop", "naturfag", "redskab", "videnskab", "værktøj"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Mikroskop"),
            keywords: &["Labor", "Mikroskop"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μικροσκόπιο"),
            keywords: &["επιστήμη", "εργαλείο", "μικροσκόπιο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("microscope"),
            keywords: &["microscope", "science", "tool"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("microscopio"),
            keywords: &["instrumento", "laboratorio", "microscopio"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("mikroskoop"),
            keywords: &["mikroskoop", "tööriist"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("mikroskopioa"),
            keywords: &["mikroskopioa", "tresna"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("میکروسکوپ"),
            keywords: &["آزمایشگاه", "ابزار", "علم", "میکروسکوپ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("mikroskooppi"),
            keywords: &["mikroskooppi", "työkalu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("microscope"),
            keywords: &["kagamitan", "microscope", "mikroskopyo", "siyensiya"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("mikroskop"),
            keywords: &["mikroskop", "náttúruvísindi", "sjóneyka", "vísind"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("microscope"),
            keywords: &["microscope", "outil", "science"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["microscope", "outi", "science"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("micreascóp"),
            keywords: &["eolaíocht", "micreascóp", "uirlis"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("micreosgop"),
            keywords: &[
                "acainn",
                "glainne",
                "inneal",
                "meudachadh",
                "micreosgop",
                "saidheans",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("microscopio"),
            keywords: &["ciencia", "laboratorio", "microscopio"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("માઇક\u{acd}રોસ\u{acd}કોપ"),
            keywords: &["ટ\u{ac2}લ", "માઇક\u{acd}રોસ\u{acd}કોપ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("madubin kimiyya"),
            keywords: &["kayan aiki", "kimiyya", "madubin kimiyya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מיקרוסקופ"),
            keywords: &["מדע", "מחקר", "מיקרוסקופ"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("माइक\u{94d}रोस\u{94d}कोप"),
            keywords: &["उपकरण", "माइक\u{94d}रोस\u{94d}कोप", "विज\u{94d}ञान"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("mikroskop"),
            keywords: &["alat", "mikroskop"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("mikroszkóp"),
            keywords: &["eszköz", "felszerelés", "mikroszkóp"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մանրադիտակ"),
            keywords: &["գործիք", "մանրադիտակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("mikroskop"),
            keywords: &["alat", "mikroskop", "sains"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ugogbe nnyota nje"),
            keywords: &["ngwaọrụ", "sanyensi", "ugogbe nnyota nje"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("smásjá"),
            keywords: &["smásjá", "verkfæri", "vísindi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("microscopio"),
            keywords: &[
                "analisi",
                "esperimento",
                "microscopio",
                "scienza",
                "strumento",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("顕微鏡"),
            keywords: &["サイエンス", "研究", "科学", "顕微鏡"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("mikroskop"),
            keywords: &["mikroskop", "pranti", "sains"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მიკროსკოპი"),
            keywords: &["ინსტრუმენტი", "მიკროსკოპი", "ხელსაწყო"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("микроскоп"),
            keywords: &["микроскоп", "құрал"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("mikroskop"),
            keywords: &["mikroskop", "redskab", "værktøj"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17b8}ក\u{17d2}រ\u{17bc}ទស\u{17d2}សន\u{17cd}"),
            keywords: &[
                "ឆ\u{17d2}ល\u{17bb}ះ",
                "ម\u{17b8}ក\u{17d2}រ\u{17bc}ទស\u{17d2}សន\u{17cd}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮೈಕ\u{ccd}ರೋಸ\u{ccd}ಕೋಪ\u{ccd}"),
            keywords: &[
                "ಉಪಕರಣ",
                "ಮೈಕ\u{ccd}ರೋಸ\u{ccd}ಕೋಪ\u{ccd}",
                "ವ\u{cbf}ಜ\u{ccd}ಞಾನ",
                "ಸ\u{cc2}ಕ\u{ccd}ಷ\u{ccd}ಮದರ\u{ccd}ಶಕ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("현미경"),
            keywords: &["기구", "도구", "장치", "현미경"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मायक\u{94d}रोस\u{94d}कोप"),
            keywords: &["मायक\u{94d}रोस\u{94d}कोप", "विज\u{94d}ञान", "साधन"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("микроскоп"),
            keywords: &["курал", "микроскоп"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Mikroskop"),
            keywords: &["Apparat", "Mikroskop", "Wëssenschaft"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກ\u{ec9}ອງຈ\u{eb8}ລະທ\u{eb1}ດ"),
            keywords: &[
                "ກ\u{ec9}ອງຈ\u{eb8}ລະທ\u{eb1}ດ",
                "ເຄ\u{eb7}\u{ec8}ອງມ\u{eb7}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mikroskopas"),
            keywords: &["mikroskopas", "įrankis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("mikroskops"),
            keywords: &["mikroskops", "rīks", "zinātne"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pūwhārahi"),
            keywords: &["pūtaiao", "pūwhārahi", "utauta"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("микроскоп"),
            keywords: &["алатка", "микроскоп"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മൈക\u{d4d}രോസ\u{d4d}\u{200c}കോപ\u{d4d}പ\u{d4d}"),
            keywords: &["ഉപകരണം", "മൈക\u{d4d}രോസ\u{d4d}\u{200c}കോപ\u{d4d}പ\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("микроскоп"),
            keywords: &["багаж", "микроскоп"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मायक\u{94d}रोस\u{94d}कोप"),
            keywords: &["मायक\u{94d}रोस\u{94d}कोप", "विज\u{94d}ञान", "साधन"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("mikroskop"),
            keywords: &["alat", "mikroskop", "sains"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("mikroskopju"),
            keywords: &["għodda", "mikroskopju", "xjenza"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အဏ\u{102f}ကြည\u{1037}\u{103a}မ\u{103e}န\u{103a}ပြောင\u{103a}း"),
            keywords: &[
                "က\u{102d}ရ\u{102d}ယာ",
                "အဏ\u{102f}ကြည\u{1037}\u{103a}မ\u{103e}န\u{103a}ပြောင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mikroskop"),
            keywords: &["forskning", "mikroskop", "verktøy", "vitenskap"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{941}क\u{94d}ष\u{94d}मदर\u{94d}शक यन\u{94d}त\u{94d}र"),
            keywords: &[
                "उपकरण",
                "विज\u{94d}ञान",
                "स\u{941}क\u{94d}ष\u{94d}मदर\u{94d}शक यन\u{94d}त\u{94d}र",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("microscoop"),
            keywords: &["gereedschap", "microscoop", "wetenschap"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mikroskop"),
            keywords: &["forsking", "mikroskop", "verktøy", "vitskap"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମ\u{b3e}ଇକ\u{b4d}ରୋସ\u{b4d}କୋପ\u{b4d}\u{200c}"),
            keywords: &["ମ\u{b3e}ଇକ\u{b4d}ରୋସ\u{b4d}କୋପ\u{b4d}\u{200c}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮਾਈਕਰ\u{a4b}\u{a4b}ਸਕ\u{a4b}ਪ"),
            keywords: &[
                "ਔਜ\u{a3c}ਾਰ",
                "ਮਾਈਕਰ\u{a4b}ਸਕ\u{a4b}ਪ",
                "ਮਾਈਕਰ\u{a4b}\u{a4b}ਸਕ\u{a4b}ਪ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("خورد بین"),
            keywords: &["اوزار", "خورد بین", "سائنس"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Maíkroskop"),
            keywords: &["Maíkroskop", "Sáyẹns", "Tul"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mikroskop"),
            keywords: &["mikroskop", "obserwacja", "powiększenie"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مایکروسکوپ"),
            keywords: &["اله", "سائينس", "مايکروسکوپ", "مایکروسکوپ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("microscópio"),
            keywords: &["ciência", "ferramenta", "microscópio"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["ciência", "instrumento", "microscópio"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("microscop"),
            keywords: &["cercetare", "instrument", "microscop", "știință"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-744"),
            keywords: &["E10-744"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("микроскоп"),
            keywords: &[
                "биология",
                "инструмент",
                "клетки",
                "микробы",
                "микроскоп",
                "прибор",
                "увеличение",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("mikorosikope"),
            keywords: &["igikoresho", "mikorosikope", "siyansi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مائڪرو اسڪوپ"),
            keywords: &["سائنس، اوزار", "مائڪرو اسڪوپ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අණ\u{dca}ව\u{dd3}ක\u{dca}ෂය"),
            keywords: &["අණ\u{dca}ව\u{dd3}ක\u{dca}ෂය", "මෙවලම"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("mikroskop"),
            keywords: &["laboratórium", "mikroskop", "veda"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("mikroskop"),
            keywords: &["mikroskop", "orodje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("maykriskoob"),
            keywords: &["maykriskoob", "qalab", "saynis"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("mikroskop"),
            keywords: &["instrument", "mikroskop", "shkencë", "vegël"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("микроскоп"),
            keywords: &["алат", "микроскоп", "наука"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["микроскоп"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("mikroskop"),
            keywords: &["alat", "mikroskop", "nauka"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["mikroskop"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("mikroskop"),
            keywords: &["mikroskop", "vetenskap"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("hadubini"),
            keywords: &["hadubini", "zana"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மைக\u{bcd}ரோஸ\u{bcd}கோப\u{bcd}"),
            keywords: &[
                "ஆர\u{bbe}ய\u{bcd}ச\u{bcd}சி",
                "மைக\u{bcd}ரோஸ\u{bcd}கோப\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c48}క\u{c4d}ర\u{c4b}స\u{c4d}క\u{c4b}ప\u{c4d}"),
            keywords: &[
                "మ\u{c48}క\u{c4d}ర\u{c4b}స\u{c4d}క\u{c4b}ప\u{c4d}",
                "సూక\u{c4d}ష\u{c4d}మదర\u{c4d}శ\u{c3f}న\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("микроскоп"),
            keywords: &["асбоб", "илм", "микроскоп"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("กล\u{e49}องจ\u{e38}ลทรรศน\u{e4c}"),
            keywords: &[
                "กล\u{e49}องจ\u{e38}ลทรรศน\u{e4c}",
                "เคร\u{e37}\u{e48}องม\u{e37}อ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("mikroskop"),
            keywords: &["gural", "mikroskop", "ylym"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻa fakaʻataefu"),
            keywords: &["meʻa fakaʻataefu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("mikroskop"),
            keywords: &["alet", "bilim", "mikroskop"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("مىكروسكوپ"),
            keywords: &["قورال", "مىكروسكوپ", "پەن"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("мікроскоп"),
            keywords: &["мікроскоп", "інструмент"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مائیکروسکوپ"),
            keywords: &["آلہ", "سکوپ", "مائیکرو", "مائیکروسکوپ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("mikroskop"),
            keywords: &["asbob", "mikroskop"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("kính hiển vi"),
            keywords: &["dụng cụ", "khoa học", "kính hiển vi", "kính hiển vị"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("mikroskop"),
            keywords: &["jumtukaay", "mikroskop", "xarala"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-microscope"),
            keywords: &["i-microscope", "inzululwazi", "isixhobo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("maikirosikopu"),
            keywords: &["irinṣẹ\u{301}", "maikirosikopu", "sáyé\u{329}nsì"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("顯微鏡"),
            keywords: &["工具", "科學", "顯微鏡"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("显微镜"),
            keywords: &["工具", "显微镜", "科学"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("显微镜"),
            keywords: &["实验", "工具", "显微镜", "生物", "科学", "细胞"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("顯微鏡"),
            keywords: &["顯微鏡"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-microscope"),
            keywords: &["i-microscope", "ithuluzi"],
        },
    ],
};
#[doc = "🔭"]
pub const TELESCOPE: crate::Emoji = crate::Emoji {
    glyph: "🔭",
    codepoint: "1F52D",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "telescope",
    group: "Objects",
    subgroup: "science",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("teleskoop"),
            keywords: &["hemelruim", "sterre", "teleskoop"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቴሌስኮፕ"),
            keywords: &["መሣሪያ", "ቴሌስኮፕ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("تليسكوب"),
            keywords: &["أداة", "تليسكوب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("দ\u{9c2}ৰবীক\u{9cd}ষণ যন\u{9cd}ত\u{9cd}ৰ"),
            keywords: &[
                "দ\u{9c2}ৰবীক\u{9cd}ষণ যন\u{9cd}ত\u{9cd}ৰ",
                "বিজ\u{9cd}ঞ\u{9be}ন",
                "স\u{981}জ\u{9c1}লি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("teleskop"),
            keywords: &["alət", "teleskop"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("тэлескоп"),
            keywords: &["прыбор", "тэлескоп", "інструмент"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("телескоп"),
            keywords: &["инструмент", "телескоп"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("টেলিস\u{9cd}কোপ"),
            keywords: &["টেলিস\u{9cd}কোপ", "সরঞ\u{9cd}জ\u{9be}ম"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("teleskop"),
            keywords: &["benveg", "skiant", "teleskop"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("teleskop"),
            keywords: &["alat", "teleskop"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("telescopi"),
            keywords: &["augment", "ciència", "eina", "telescopi"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᎸᎳᏗ ᏩᎪᏩᏛᏗ"),
            keywords: &["ᎠᎬᏛᏂᏓᏍᏗ", "ᎦᎸᎳᏗ ᏩᎪᏩᏛᏗ", "ᎬᏔᏂᏓᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("teleskop"),
            keywords: &[
                "dalekohled",
                "hvězdářský",
                "nástroj",
                "teleskop",
                "věda",
                "vědecký",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("telesgop"),
            keywords: &["offeryn", "telesgop"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("teleskop"),
            keywords: &["astronomi", "redskab", "teleskop", "videnskab", "værktøj"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Teleskop"),
            keywords: &["Teleskop"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τηλεσκόπιο"),
            keywords: &["επιστήμη", "εργαλείο", "τηλεσκόπιο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("telescope"),
            keywords: &["science", "telescope", "tool"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("telescopio"),
            keywords: &["astronomía", "instrumento", "telescopio"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["instrumento", "microscopio", "observatorio", "telescopio"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("teleskoop"),
            keywords: &["teleskoop", "tööriist"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("teleskopioa"),
            keywords: &["teleskopioa", "tresna"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تلسکوپ"),
            keywords: &["ابزار", "اخترشناسی", "تلسکوپ", "علم", "نجوم"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kaukoputki"),
            keywords: &["kaukoputki", "teleskooppi", "työkalu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("telescope"),
            keywords: &["kagamitan", "siyensiya", "telescope", "teleskopyo"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("stjørnukikari"),
            keywords: &[
                "kikari",
                "náttúruvísindi",
                "spegilskikari",
                "stjørnukikari",
                "teleskop",
                "vísindfjarvísi",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("télescope"),
            keywords: &["outil", "science", "télescope"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("teileascóp"),
            keywords: &["teileascóp"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("glainne-amhairc"),
            keywords: &[
                "acainn",
                "glainne",
                "glainne-amhairc",
                "inneal",
                "meudachadh",
                "prosbaig",
                "saidheans",
                "teileasgop",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("telescopio"),
            keywords: &[
                "astronomía",
                "constelacións",
                "corpos celestes",
                "telescopio",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ટ\u{ac7}લિસ\u{acd}કોપ"),
            keywords: &["ટ\u{ac2}લ", "ટ\u{ac7}લિસ\u{acd}કોપ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("madubin hangen nesa"),
            keywords: &["kayan aiki", "kimiyya", "madubin hangen nesa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("טלסקופ"),
            keywords: &["טלסקופ", "מדע", "מחקר", "צפייה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("द\u{942}रबीन"),
            keywords: &[
                "उपकरण",
                "ट\u{947}लिस\u{94d}कोप",
                "द\u{942}रबीन",
                "विज\u{94d}ञान",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("teleskop"),
            keywords: &["alat", "teleskop"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("távcső"),
            keywords: &["eszköz", "felszerelés", "távcső"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("հեռադիտակ"),
            keywords: &["գործիք", "հեռադիտակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("teleskop"),
            keywords: &["alat", "sains", "teleskop"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ngwa sọfịa"),
            keywords: &["ngwa sọfịa", "ngwaọrụ", "sanyensi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sjónauki"),
            keywords: &["sjónauki", "verkfæri", "vísindi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("telescopio"),
            keywords: &[
                "astronomia",
                "osservazione delle stelle",
                "telescopi",
                "telescopio",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("望遠鏡"),
            keywords: &["サイエンス", "天体観測", "望遠鏡", "科学", "観測"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("teleskop"),
            keywords: &["pranti", "sains", "teleskop"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ტელესკოპი"),
            keywords: &["ინსტრუმენტი", "ტელესკოპი", "ხელსაწყო"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("телескоп"),
            keywords: &["телескоп", "құрал"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("teleskop"),
            keywords: &["redskab", "teleskop", "værktøj"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កែវយ\u{17b7}តមើលព\u{17d2}រះចន\u{17d2}ទ"),
            keywords: &[
                "កែវយ\u{17b7}ត",
                "កែវយ\u{17b7}តមើលព\u{17d2}រះចន\u{17d2}ទ",
                "\u{200b} មើលព\u{17d2}រះច\u{17d0}ន\u{17d2}ទ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಟ\u{cc6}ಲ\u{cbf}ಸ\u{ccd}ಕೋಪ\u{ccd}"),
            keywords: &[
                "ಉಪಕರಣ",
                "ಟ\u{cc6}ಲ\u{cbf}ಸ\u{ccd}ಕೋಪ\u{ccd}",
                "ದ\u{cc2}ರದರ\u{ccd}ಶಕ",
                "ವ\u{cbf}ಜ\u{ccd}ಞಾನ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("망원경"),
            keywords: &["도구", "망원경", "장비"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("द\u{941}र\u{94d}बिण"),
            keywords: &["द\u{941}र\u{94d}बिण", "विज\u{94d}ञान", "साधन"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("телескоп"),
            keywords: &["курал", "телескоп"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Teleskop"),
            keywords: &["Apparat", "Teleskop", "Wëssenschaft"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກ\u{ec9}ອງຊ\u{ec8}ອງທາງໄກ"),
            keywords: &["ກ\u{ec9}ອງຊ\u{ec8}ອງທາງໄກ", "ເຄ\u{eb7}\u{ec8}ອງມ\u{eb7}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("teleskopas"),
            keywords: &["teleskopas", "įrankis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("teleskops"),
            keywords: &["rīks", "teleskops", "zinātne"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("karu whakatata"),
            keywords: &["karu whakatata", "pūtaiao", "utauta"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("телескоп"),
            keywords: &["алатка", "телескоп"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ടെലസ\u{d4d}\u{200c}കോപ\u{d4d}പ\u{d4d}"),
            keywords: &[
                "ഉപകരണം",
                "ടെലസ\u{d4d}\u{200c}കോപ\u{d4d}പ\u{d4d}",
                "ടെലിസ\u{d4d}കോപ\u{d4d}പ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("телескоп"),
            keywords: &["багаж", "телескоп"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("द\u{941}र\u{94d}बीण"),
            keywords: &["द\u{941}र\u{94d}बीण", "विज\u{94d}ञान", "साधन"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("teleskop"),
            keywords: &["alat", "sains", "teleskop"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("teleskopju"),
            keywords: &["għodda", "teleskopju", "xjenza"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အဝေးကြည\u{1037}\u{103a}မ\u{103e}န\u{103a}ပြောင\u{103a}း"),
            keywords: &[
                "က\u{102d}ရ\u{102d}ယာ",
                "အဝေးကြည\u{1037}\u{103a}မ\u{103e}န\u{103a}ပြောင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("teleskop"),
            keywords: &["astronomi", "forskning", "teleskop", "verktøy", "vitenskap"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ट\u{947}लिस\u{94d}कोप"),
            keywords: &["उपकरण", "ट\u{947}लिस\u{94d}कोप", "विज\u{94d}ञान"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("telescoop"),
            keywords: &["gereedschap", "telescoop", "wetenschap"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("teleskop"),
            keywords: &["astronomi", "forsking", "teleskop", "verktøy", "vitskap"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଟେଲ\u{b3f}ସ\u{b4d}କୋପ\u{b4d}\u{200c}"),
            keywords: &["ଟେଲ\u{b3f}ସ\u{b4d}କୋପ\u{b4d}\u{200c}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਟ\u{a48}ਲੀਸਕ\u{a4b}ਪ"),
            keywords: &["ਔਜ\u{a3c}ਾਰ", "ਟ\u{a48}ਲੀਸਕ\u{a4b}ਪ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("دوربین"),
            keywords: &["اوزار", "دوربین", "سائنس"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tẹlískop"),
            keywords: &["Sáyẹns", "Tul", "Tẹlískop"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("teleskop"),
            keywords: &["luneta", "obserwacja", "powiększenie", "teleskop"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ټیلي سکوپ"),
            keywords: &["اله", "سائينس", "ټيلي سکوپ", "ټیلي سکوپ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("telescópio"),
            keywords: &["ciência", "ferramenta", "telescópio"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["ciência", "instrumento", "telescópio"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("telescop"),
            keywords: &["cercetare", "instrument", "telescop", "știință"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-745"),
            keywords: &["E10-745"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("телескоп"),
            keywords: &[
                "астрономия",
                "звезды",
                "инструмент",
                "планетарий",
                "планеты",
                "прибор",
                "телескоп",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("telesikope"),
            keywords: &["igikoresho", "siyansi", "telesikope"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٽيلي اسڪوپ"),
            keywords: &["سائنس، اوزار", "ٽيلي اسڪوپ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ද\u{dd4}රේක\u{dca}ෂය"),
            keywords: &["ද\u{dd4}රේක\u{dca}ෂය", "මෙවලම"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ďalekohľad"),
            keywords: &["nástroj", "teleskop", "ďalekohľad"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("teleskop"),
            keywords: &["orodje", "teleskop"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("diirad"),
            keywords: &["diirad", "qalab", "saynis"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("teleskop"),
            keywords: &["instrument", "shkencë", "teleskop", "vegël"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("телескоп"),
            keywords: &["алат", "наука", "телескоп"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["телескоп"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("teleskop"),
            keywords: &["alat", "nauka", "teleskop"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["teleskop"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("teleskop"),
            keywords: &["kikare", "stjärnkikare", "teleskop"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("darubini"),
            keywords: &["darubini", "zana"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("டெலஸ\u{bcd}கோப\u{bcd}"),
            keywords: &[
                "டெலஸ\u{bcd}கோப\u{bcd}",
                "வ\u{bbe}னியல\u{bcd} ஆர\u{bbe}ய\u{bcd}ச\u{bcd}சி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ట\u{c46}ల\u{c3f}స\u{c4d}క\u{c4b}ప\u{c4d}"),
            keywords: &[
                "ట\u{c46}ల\u{c3f}స\u{c4d}క\u{c4b}ప\u{c4d}",
                "దూరదర\u{c4d}శ\u{c3f}న\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("телескоп"),
            keywords: &["асбоб", "илм", "телескоп"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("กล\u{e49}องโทรทรรศน\u{e4c}"),
            keywords: &["กล\u{e49}องโทรทรรศน\u{e4c}", "เคร\u{e37}\u{e48}องม\u{e37}อ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("teleskop"),
            keywords: &["gural", "teleskop", "ylym"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻa fakaʻatafetuʻu"),
            keywords: &["meʻa fakaʻatafetuʻu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("teleskop"),
            keywords: &["alet", "teleskop"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تېلېسكوپ"),
            keywords: &["تېلېسكوپ", "قورال", "پەن"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("телескоп"),
            keywords: &["телескоп", "інструмент"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ٹیلی سکوپ"),
            keywords: &["آلہ", "سکوپ", "ٹیلی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("teleskop"),
            keywords: &["asbob", "teleskop"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("kính viễn vọng"),
            keywords: &["dụng cụ", "khoa học", "kính viễn vọng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("teleskop"),
            keywords: &["jumtukaay", "teleskop", "xarala"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-telescope"),
            keywords: &["i-telescope", "inzululwazi", "isixhobo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("tẹlisikopu"),
            keywords: &["irinṣẹ\u{301}", "sáyé\u{329}nsì", "tẹlisikopu"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("望遠鏡"),
            keywords: &["工具", "望遠鏡", "科學"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("望远镜"),
            keywords: &["工具", "望远镜", "科学"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("望远镜"),
            keywords: &["天体", "天文", "天文学", "工具", "望远镜", "观星"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("望遠鏡"),
            keywords: &["望遠鏡", "觀測"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["望遠鏡", "觀測｜工具"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-telescope"),
            keywords: &["i-telescope", "itelescope", "ithuluzi"],
        },
    ],
};
#[doc = "📡"]
pub const SATELLITE_ANTENNA: crate::Emoji = crate::Emoji {
    glyph: "📡",
    codepoint: "1F4E1",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "satellite antenna",
    group: "Objects",
    subgroup: "science",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("satellietantenna"),
            keywords: &["antenna", "satelliet", "satellietantenna", "skottel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሳተላይት አንቴና"),
            keywords: &["ሳተላይት", "አንቴና", "ዲሽ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("طبق قمر صناعي"),
            keywords: &[
                "تواصل",
                "دش",
                "طبق قمر صناعي",
                "قمر صناعي",
                "هوائي",
                "هوائي قمر صناعي",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("উপগ\u{9cd}ৰহ এণ\u{9cd}টেন\u{9be}"),
            keywords: &[
                "উপগ\u{9cd}ৰহ এণ\u{9cd}টেন\u{9be}",
                "এণ\u{9cd}টেন\u{9be}",
                "ছেটেল\u{9be}ইট",
                "ডিশ\u{9cd}ব",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("peyk antenası"),
            keywords: &["antena", "peyk", "peyk antenası", "çanaq antenası"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("спадарожнікавая антэна"),
            keywords: &["антэна", "спадарожнік", "спадарожнікавая антэна", "талерка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Сателитна антена"),
            keywords: &["Сателитна антена", "антена", "сателитна", "чиния"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9cd}য\u{9be}টেল\u{9be}ইট অ\u{9cd}য\u{9be}ন\u{9cd}টেন\u{9be}"),
            keywords: &[
                "অ\u{9cd}য\u{9be}ন\u{9cd}টেন\u{9be}",
                "উপগ\u{9cd}রহ",
                "ডিশ",
                "স\u{9cd}য\u{9be}টেল\u{9be}ইট অ\u{9cd}য\u{9be}ন\u{9cd}টেন\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("stign loarell"),
            keywords: &["loarell", "stign"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("satelitska antena"),
            keywords: &["antena", "satelitska", "tanjir"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("antena de satèl·lit"),
            keywords: &["antena", "antena de satèl·lit", "satèl·lit"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᎸᎶᎯ ᎠᎦᏖᏃᎵᏙ ᎡᏙᎯ ᎾᏏᎳᏛᎾ"),
            keywords: &[
                "ᎤᏅᏪᏓ",
                "ᎦᎸᎳᏗ ᎡᏙᎯ ᎾᏏᎳᏛᎾ ᎦᏂᏱᏍᎩ",
                "ᎦᎸᎶᎯ ᎠᎦᏖᏃᎵᏙ",
                "ᎦᎸᎶᎯ ᎠᎦᏖᏃᎵᏙ ᎡᏙᎯ ᎾᏏᎳᏛᎾ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("satelitní anténa"),
            keywords: &["anténa", "satelit", "satelitní anténa", "talíř"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("antena lloeren"),
            keywords: &["antena", "lloeren"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("parabolantenne"),
            keywords: &["parabol", "parabolantenne", "satellit"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Satellitenschüssel"),
            keywords: &["Antenne", "Satellitenschüssel", "Schüssel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("δορυφορική κεραία"),
            keywords: &["δορυφορική", "κεραία", "πιάτο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("satellite antenna"),
            keywords: &["antenna", "dish", "satellite"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("satellite dish"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("antena de satélite"),
            keywords: &["antena", "antena de satélite", "comunicación", "satélite"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("antena satelital"),
            keywords: &[
                "antena",
                "antena de satélite",
                "antena satelital",
                "comunicación",
                "satélite",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("antena satelital"),
            keywords: &["antena satelital"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("satelliitantenn"),
            keywords: &["antenn", "satelliit", "satelliitantenn", "taldrik"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("satelite bidezko antena"),
            keywords: &["antena", "parabolikoa", "satelite bidezko antena"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("آنتن ماهواره"),
            keywords: &["آنتن", "بشقاب", "دیش", "ماهواره"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("lautasantenni"),
            keywords: &["antenni", "lautanen", "lautasantenni", "satelliittiantenni"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("satellite antenna"),
            keywords: &["antenna", "dish", "satellite"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("parabolur"),
            keywords: &["antenna", "parabolur", "skálkampur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("antenne satellite"),
            keywords: &[
                "antenne",
                "antenne parabolique",
                "antenne satellite",
                "parabole",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("aeróg satailíte"),
            keywords: &[
                "aeróg",
                "aeróg satailíte",
                "aeróg shatailíte",
                "mias",
                "mias satailíte",
                "satailít",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("iadhaire-saideil"),
            keywords: &["iadhaire", "iadhaire-saideil", "saideal", "soitheach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("antena de satélite"),
            keywords: &["antena", "antena de satélite", "satélite"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{ac7}ટ\u{ac7}લાઇટ એન\u{acd}ટ\u{ac7}ના"),
            keywords: &[
                "એન\u{acd}ટ\u{ac7}ના",
                "ડિશ",
                "સ\u{a82}ચાર",
                "સ\u{ac7}ટ\u{ac7}લાઇટ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("eriya na kumbo"),
            keywords: &["dish", "eriya", "eriya na kumbo", "kumbo"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("צלחת לוויין"),
            keywords: &["אנטנה", "לוויין", "צלחת", "תקשורת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{948}ट\u{947}लाइट ए\u{902}ट\u{947}ना"),
            keywords: &[
                "उपग\u{94d}रह",
                "डिश",
                "स\u{948}ट\u{947}लाइट ए\u{902}ट\u{947}ना",
                "स\u{948}ट\u{947}लाइट डिश",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("satelitska antena"),
            keywords: &["antena", "satelit", "satelitska antena", "tanjur"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("parabolaantenna"),
            keywords: &["antenna", "műhold", "parabolaantenna", "tányér"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("արբանյակային ալեհավաք"),
            keywords: &["ալեհավաք", "արբանյակ", "արբանյակային ալեհավաք", "ափսե"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("antena satelit"),
            keywords: &["antena", "piring", "satelit"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akara satịlitị"),
            keywords: &["akara", "dishi", "satịlitị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("gervihnattaloftnet"),
            keywords: &[
                "diskur",
                "gervihnattadiskur",
                "gervihnattaloftnet",
                "loftnet",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("antenna satellitare"),
            keywords: &[
                "antenna parabolica",
                "antenna satellitare",
                "antenne paraboliche",
                "antenne satellitari",
                "satellite",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("パラボラアンテナ"),
            keywords: &[
                "アンテナ",
                "パラボラ",
                "パラボラアンテナ",
                "衛星アンテナ",
                "電波",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("antena satelit"),
            keywords: &["antena", "parabola", "satelit"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("თანამგზავრული ანტენა"),
            keywords: &[
                "ანტენა",
                "თანამგზავრი",
                "თანამგზავრული",
                "თეფში",
                "სატელიტი",
                "სატელიტური",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("серіктік антенна"),
            keywords: &["антенна", "серіктік", "тәрелке"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("parabolantenne"),
            keywords: &["kommunikation", "parabolantenne"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ចានផ\u{17d2}កាយរណប"),
            keywords: &["ចានផ\u{17d2}កាយរណប", "ផ\u{17d2}កាយរណប", "អង\u{17cb}តែន"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಉಪಗ\u{ccd}ರಹ ಆಂಟ\u{cc6}ನಾ"),
            keywords: &["ಆಂಟ\u{cc6}ನಾ", "ಉಪಗ\u{ccd}ರಹ", "ಡ\u{cbf}ಶ\u{ccd}", "ಸಂವಹನ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("위성 안테나"),
            keywords: &["안테나", "위성 방송", "위성 안테나"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उपगिरो एण\u{94d}ट\u{947}ना"),
            keywords: &["उपगिरो", "एण\u{94d}ट\u{947}ना", "डीश"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("спутниктик антенна"),
            keywords: &["антенна", "спутник", "спутниктик антенна", "табак"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Satellittenantenn"),
            keywords: &["Antenn", "Satellitt", "Satellittenantenn", "Teller"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເສ\u{ebb}າອາກາດດາວທຽມ"),
            keywords: &["ດາວທຽມ", "ເສ\u{ebb}າອາກາດ", "ເສ\u{ebb}າອາກາດດາວທຽມ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("palydovinė antena"),
            keywords: &["antena", "indas", "palydovas", "palydovinė antena"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("satelīta šķīvis"),
            keywords: &["antena", "satelīta šķīvis", "satelīts", "šķīvis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pūhihi amiorangi"),
            keywords: &["amiorangi", "pūhihi", "rīhi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("сателитска антена"),
            keywords: &["антена", "сателит", "сателитска антена"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d3e}റ\u{d4d}റലൈറ\u{d4d}റ\u{d4d} ആന\u{d4d}റിന"),
            keywords: &[
                "ആന\u{d4d}റിന",
                "ആശയവിനിമയം",
                "ടിവി ആന\u{d4d}റിന",
                "ഡിഷ\u{d4d}",
                "സ\u{d3e}റ\u{d4d}റലൈറ\u{d4d}റ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хиймэл дагуулын антен"),
            keywords: &["антен", "таваг", "хиймэл дагуул", "хиймэл дагуулын антен"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("उपग\u{94d}रह अ\u{945}\u{902}ट\u{947}ना"),
            keywords: &[
                "अ\u{901}ट\u{947}ना",
                "उपग\u{94d}रह",
                "उपग\u{94d}रह अ\u{945}\u{902}ट\u{947}ना",
                "डिश",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("antena satelit"),
            keywords: &["antena", "piring", "satelit"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("antenna tas-satellita"),
            keywords: &["antenna", "antenna tas-satellita", "dixx", "satellita"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဂြ\u{102d}\u{102f}ဟ\u{103a}တ\u{102f} စလောင\u{103a}း"),
            keywords: &[
                "ဂြ\u{102d}\u{102f}ဟ\u{103a}တ\u{102f} စလောင\u{103a}း",
                "ဆက\u{103a}သယ\u{103a}ရေး ဂြ\u{102d}\u{102f}ဟ\u{103a}တ\u{102f}",
                "ဧရ\u{102e}ယာတ\u{102d}\u{102f}င\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("satellittantenne"),
            keywords: &[
                "antenne",
                "kommunikasjon",
                "parabol",
                "parabolantenne",
                "satellitt",
                "satellittantenne",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}याटलाइट एन\u{94d}ट\u{947}ना"),
            keywords: &["एन\u{94d}ट\u{947}ना", "डिस\u{94d}", "स\u{94d}याटलाइट"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("satellietschotel"),
            keywords: &["antenne", "satelliet", "satellietschotel", "schotel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("satellittantenne"),
            keywords: &[
                "antenne",
                "kommunikasjon",
                "parabol",
                "parabolantenne",
                "satellitt",
                "satellittantenne",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b4d}ୟ\u{b3e}ଟେଲ\u{b3e}ଇଟ\u{b4d}\u{200c} ଆଣ\u{b4d}ଟ\u{b3f}ନ\u{b3e}"),
            keywords: &[
                "ଆଣ\u{b4d}ଟ\u{b3f}ନ\u{b3e}",
                "ଡ\u{b3f}ସ\u{b4d}",
                "ଯୋଗ\u{b3e}ଯୋଗ",
                "ସ\u{b3e}ଟେଲ\u{b3e}ଇଟ\u{b4d}",
                "ସ\u{b4d}ୟ\u{b3e}ଟେଲ\u{b3e}ଇଟ\u{b4d}\u{200c} ଆଣ\u{b4d}ଟ\u{b3f}ନ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a48}ਟ\u{a47}ਲਾਈਟ ਅ\u{a70}ਟੀਨਾ"),
            keywords: &[
                "ਅ\u{a70}ਟੀਨਾ",
                "ਡਿਸ\u{a3c}",
                "ਸ\u{a48}ਟਲਾਈਟ",
                "ਸ\u{a48}ਟ\u{a47}ਲਾਈਟ ਅ\u{a70}ਟੀਨਾ",
                "ਸ\u{a70}ਚਾਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سیٹلائٹ انٹینا"),
            keywords: &["انٹینا", "تھالی", "سیٹلائٹ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Sátálaít Antẹ\u{301}na"),
            keywords: &[
                "Antẹ\u{301}na",
                "Dish",
                "Sátálait",
                "Sátálaít Antẹ\u{301}na",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("antena satelitarna"),
            keywords: &["antena satelitarna", "czasza", "satelita", "talerz"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د سپوږمکۍ انټينا"),
            keywords: &["انټينا", "د سپوږمکۍ انټينا", "سپوږمکۍ", "ډش"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("antena parabólica"),
            keywords: &["antena", "comunicação", "parabólica", "satélite"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["antena", "parabólica", "satélite"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("antenă satelit"),
            keywords: &["antenă", "comunicare", "satelit"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-670"),
            keywords: &["E10-670"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("спутниковая антенна"),
            keywords: &["антенна", "спутник", "спутниковая"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("anteni y’icyogajuru"),
            keywords: &["anteni", "anteni y’icyogajuru", "icyogajuru", "isahani"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سيٽ لائيٽ اينٽينا"),
            keywords: &["اينٽينا", "سيٽ لائيٽ اينٽينا", "سيٽيلائيٽ", "ڊش"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("චන\u{dca}ද\u{dca}\u{200d}ර\u{dd2}ක\u{dcf} අැන\u{dca}ටන\u{dcf}ව"),
            keywords: &[
                "ඇන\u{dca}ටන\u{dcf}ව",
                "චන\u{dca}ද\u{dca}\u{200d}ර\u{dd2}ක\u{dcf} අැන\u{dca}ටන\u{dcf}ව",
                "චන\u{dca}ද\u{dca}\u{200d}ර\u{dd2}ක\u{dcf}ව",
                "ඩ\u{dd2}ෂ\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("satelitná anténa"),
            keywords: &["anténa", "satelit", "satelitná anténa", "tanier"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("satelitska antena"),
            keywords: &["antena", "krožnik", "satelitska antena", "satelitsko"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("aanteenada satalaytka"),
            keywords: &["aanteena", "aanteenada satalaytka", "satalayt", "sixni"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("antenë satelitore"),
            keywords: &["antenë", "satelit", "satelitore"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("сателитска антена"),
            keywords: &["антена", "сателит", "сателитска антена", "тањир"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["сателитска антена"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("satelitska antena"),
            keywords: &["antena", "satelit", "satelitska antena", "tanjir"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["satelitska antena"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tv-satellit"),
            keywords: &["antenn", "kommunikation", "satellit", "tv-satellit"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("antena ya setilaiti"),
            keywords: &["antena", "antena ya setilaiti", "setilaiti", "ungo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ச\u{bbe}ட\u{bcd}டிலைட\u{bcd} ஆன\u{bcd}டன\u{bbe}"),
            keywords: &[
                "ஆன\u{bcd}டன\u{bbe}",
                "ச\u{bbe}ட\u{bcd}டிலைட\u{bcd} ஆன\u{bcd}டன\u{bbe}",
                "டிஷ\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఉపగ\u{c4d}రహ య\u{c3e}ంట\u{c46}న\u{c4d}న\u{c3e}"),
            keywords: &[
                "ఉపగ\u{c4d}రహ య\u{c3e}ంట\u{c46}న\u{c4d}న\u{c3e}",
                "శ\u{c3e}ట\u{c3f}ల\u{c48}ట\u{c4d} య\u{c3e}ంట\u{c46}న\u{c4d}న\u{c3e}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("антеннаи моҳвораӣ"),
            keywords: &["антенна", "антеннаи моҳвораӣ", "моҳвора", "табақ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("จานดาวเท\u{e35}ยม"),
            keywords: &["จาน", "จานดาวเท\u{e35}ยม", "ดาวเท\u{e35}ยม", "เสาอากาศ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("hemra antennasy"),
            keywords: &["anten", "hemra", "hemra antennasy", "tarelka"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tisi satelaite"),
            keywords: &["tisi satelaite"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("uydu anteni"),
            keywords: &["anten", "iletişim", "uydu", "uydu anteni", "çanak"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سۈنئىي ھەمرا ئانتېنناسى"),
            keywords: &[
                "ئانتېننا",
                "تەخسە",
                "سۈنئىي ھەمرا ئانتېنناسى",
                "سۈنئىي ھەمراھ",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("супутникова антена"),
            keywords: &["антена", "супутникова", "тарілка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سیٹلائٹ انٹینا"),
            keywords: &["آلہ", "انٹینا", "سٹلائٹ", "سیٹلائٹ انٹینا", "ڈش"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("sun’iy yo‘ldoshli antenna"),
            keywords: &[
                "antenna",
                "lagan",
                "sunʼiy yoʻldosh",
                "sun’iy yo‘ldoshli antenna",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ăng-ten vệ tinh"),
            keywords: &["vệ tinh", "ăng-ten", "ăng-ten vệ tinh", "đĩa"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("àntenu satelit"),
            keywords: &["satelit", "sukup", "ànten", "àntenu satelit"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intonga yesathelayithi"),
            keywords: &["i-dish", "i-satellite", "intonga", "intonga yesathelayithi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("eria satalaiti"),
            keywords: &["eria satalaiti", "àtagbà", "àwo", "ẹ\u{300}rọ alátagbà nlá"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("衛星天線"),
            keywords: &["天線", "碟", "衛星", "衛星天線"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("卫星天线"),
            keywords: &["卫星", "卫星天线", "天线", "碟"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("卫星天线"),
            keywords: &[
                "信号接收",
                "卫星",
                "卫星天线",
                "卫星接收天线",
                "卫星碟形天线",
                "天线",
            ],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("衛星天線"),
            keywords: &["天線", "衛星天線"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("u-eriyeli wesethelaythi"),
            keywords: &[
                "indishi",
                "isethelaythi",
                "u-eriyeli",
                "u-eriyeli wesethelaythi",
            ],
        },
    ],
};
