#[doc = "📱"]
pub const MOBILE_PHONE: crate::Emoji = crate::Emoji {
    glyph: "📱",
    codepoint: "1F4F1",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "mobile phone",
    group: "Objects",
    subgroup: "phone",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("selfoon"),
            keywords: &["foon", "mobiel", "sel", "selfoon", "telefoon"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሞባይል ስልክ"),
            keywords: &["ሞባይል", "ስልክ", "ተንቀሳቃሽ", "ቴሌፎን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}هاتف جوال"),
            keywords: &["خلوي", "محمول", "نقال", "\u{202b}هاتف جوال"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মোব\u{9be}ইল ফোন"),
            keywords: &["চেল", "টেলিফোন", "ফোন", "মোব\u{9be}ইল"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("mobil telefon"),
            keywords: &["mobil", "telefon"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мабільны тэлефон"),
            keywords: &["мабільны", "мабільнік", "смартфон", "сотавы", "тэлефон"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Мобилен телефон"),
            keywords: &["Мобилен телефон", "клетъчен", "мобилен", "телефон"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মোব\u{9be}ইল ফোন"),
            keywords: &["টেলিফোন", "ফোন", "মোব\u{9be}ইল", "সেল"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pellgomzer hezoug"),
            keywords: &["hezoug", "pellgomz", "pellgomzer"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("mobitel"),
            keywords: &["mobilni", "mobitel", "telefon"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("telèfon mòbil"),
            keywords: &["mòbil", "telèfon"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄟\u{1112e}𑄝\u{1112d}𑄣\u{11134}𑄜\u{1112e}𑄚\u{11134}"),
            keywords: &["𑄟\u{1112e}𑄝\u{1112d}𑄣\u{11134}𑄜\u{1112e}𑄚\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏙᎴᎳᏊ ᏗᎵᏃᎮᏓ"),
            keywords: &["ᎠᏓᏅᏏᏙᎯ", "ᏗᏟᏃᎮᏗ", "ᏗᏟᏃᎵᏗ ᏂᏓᏏᎳᏛᎾ", "ᏙᎴᎳᏊ ᏗᎵᏃᎮᏓ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mobil"),
            keywords: &["mobil", "mobilní", "telefon"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ffôn symudol"),
            keywords: &["ffôn", "symudol"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mobil"),
            keywords: &["mobil", "mobiltelefon"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Mobiltelefon"),
            keywords: &["Handy", "Mobiltelefon", "Smartphone"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κινητό τηλέφωνο"),
            keywords: &["κινητό", "τηλέφωνο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("mobile phone"),
            keywords: &["cell", "mobile", "phone", "telephone"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("teléfono móvil"),
            keywords: &["celular", "móvil", "teléfono"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("mobiiltelefon"),
            keywords: &["mobiil", "mobiiltelefon", "telefon"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("telefono mugikorra"),
            keywords: &["mugikor", "sare", "telefono", "telefono mugikorra"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تلفن همراه"),
            keywords: &["تلفن", "موبایل", "همراه", "گوشی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kännykkä"),
            keywords: &[
                "kännykkä",
                "matkapuhelin",
                "mobiili",
                "mobiililaite",
                "puhelin",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mobile phone"),
            keywords: &["cell", "mobile", "phone", "telepono"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("fartelefon"),
            keywords: &["fartelefon", "telefon"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("téléphone portable"),
            keywords: &["téléphone", "téléphone portable"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("téléphone cellulaire"),
            keywords: &["téléphone", "téléphone cellulaire"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("guthán"),
            keywords: &["fón", "fón póca", "guthán"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("fòn-làimhe"),
            keywords: &["fòn", "fòn-làimhe", "mobile"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("teléfono móbil"),
            keywords: &["móbil", "teléfono"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મોબાઇલ ફોન"),
            keywords: &["ફોન", "મોબાઇલ ફોન", "સ\u{ac7}લ ફોન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("wayar hannu"),
            keywords: &["na hannu", "sel", "tarho", "waya", "wayar hannu"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("טלפון נייד"),
            keywords: &["טלפון", "נייד", "סלולרי"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("मोबाइल फ\u{93c}ोन"),
            keywords: &[
                "चलभाष",
                "ट\u{947}लीफ\u{93c}ोन",
                "द\u{942}रभाष",
                "फ\u{93c}ोन",
                "मोबाइल",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("mobilni telefon"),
            keywords: &["mobilni telefon", "mobitel", "telefon"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("mobiltelefon"),
            keywords: &["mobil", "mobiltelefon", "rádiótelefon", "telefon"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բջջային հեռախոս"),
            keywords: &["բջջային", "հեռախոս", "շարժական"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("ponsel"),
            keywords: &["ponsel", "seluler", "telepon"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ekwentị kengaghari"),
            keywords: &["ekwentị", "kengaghari", "mpanaka"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("farsími"),
            keywords: &["farsími", "sími"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("telefono cellulare"),
            keywords: &["cellulare", "telefono"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("携帯電話"),
            keywords: &["スマホ", "スマートフォン", "携帯", "携帯電話"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("telepon seluler"),
            keywords: &["sel", "seluler", "telepon", "telpon"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მობილური ტელეფონი"),
            keywords: &["მობილური", "ტელეფონი", "ფიჭური"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tiliɣri tazirazt"),
            keywords: &["tiliɣri tazirazt"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ұялы телефон"),
            keywords: &["мобильді", "телефон", "ұялы"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("mobil"),
            keywords: &["mobil", "mobiltelefon"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ទ\u{17bc}រស\u{17d0}ព\u{17d2}ទស\u{17d2}មាតហ\u{17d2}វ\u{17bc}ន"),
            keywords: &[
                "ទ\u{17bc}រសព\u{17d2}ទ",
                "ទ\u{17bc}រសព\u{17d2}ទចល\u{17d0}ត",
                "ទ\u{17bc}រសព\u{17d2}ទដៃ",
                "ទ\u{17bc}រស\u{17d0}ព\u{17d2}ចល\u{17d0}ត",
                "ទ\u{17bc}រស\u{17d0}ព\u{17d2}ទដៃ",
                "ទ\u{17bc}រស\u{17d0}ព\u{17d2}ទទ",
                "ទ\u{17bc}រស\u{17d0}ព\u{17d2}ទស\u{17d2}មាតហ\u{17d2}វ\u{17bc}ន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮೊಬೈಲ\u{ccd} ಫೋನ\u{ccd}"),
            keywords: &[
                "ದ\u{cc2}ರವಾಣ\u{cbf}",
                "ಫೋನ\u{ccd}",
                "ಮೊಬೈಲ\u{ccd}",
                "ಸ\u{cc6}ಲ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("휴대전화"),
            keywords: &["모바일폰", "휴대전화", "휴대폰"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मोबायल फोन"),
            keywords: &["ट\u{947}लिफोन", "फोन", "मोबायल", "स\u{945}ल"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("мобилдик телефон"),
            keywords: &["мобилдик", "телефон", "уюлдук"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Handy"),
            keywords: &["Funk", "Handy", "Mobil", "Telefon"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໂທລະສ\u{eb1}ບມ\u{eb7}ຖ\u{eb7}"),
            keywords: &[
                "ມ\u{eb7}ຖ\u{eb7}",
                "ໂທລະສ\u{eb1}ບ",
                "ໂທລະສ\u{eb1}ບມ\u{eb7}ຖ\u{eb7}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mobilusis telefonas"),
            keywords: &["mobilusis", "telefonas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("mobilais tālrunis"),
            keywords: &["mobilais", "telefons", "tālrunis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("waea pūkoro"),
            keywords: &["pūkoro", "waea", "waeakawe"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("мобилен телефон"),
            keywords: &["мобилен", "телефон"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മൊബൈൽ ഫോൺ"),
            keywords: &["ആശയവിനിമയം", "ഫോൺ", "മൊബൈൽ", "സെൽ ഫോൺ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гар утас"),
            keywords: &["гар утас", "мобайл", "утас"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मोबाईल फोन"),
            keywords: &["फोन", "मोबाइल फोन", "मोबाईल फोन", "स\u{947}ल फोन"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("telefon bimbit"),
            keywords: &["mudah alih", "sel", "telefon", "telefon bimbit"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("mowbajl"),
            keywords: &["mowbajl", "telefown"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မ\u{102d}\u{102f}ဘ\u{102d}\u{102f}င\u{103a}း ဖ\u{102f}န\u{103a}း"),
            keywords: &[
                "ဆ\u{1032}လ\u{103a}",
                "တယ\u{103a}လ\u{102e}ဖ\u{102f}န\u{103a}း",
                "ဖ\u{102f}န\u{103a}း",
                "မ\u{102d}\u{102f}ဘ\u{102d}\u{102f}င\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mobiltelefon"),
            keywords: &["mobil", "mobiltelefon", "telefon"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("मोबाइल फोन"),
            keywords: &["कल", "ट\u{947}लिफोन", "फोन", "मोबाइल"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("mobiele telefoon"),
            keywords: &["mobiel", "mobiele telefoon", "telefoon"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mobiltelefon"),
            keywords: &["mobil", "mobiltelefon", "telefon"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମୋବ\u{b3e}ଇଲ\u{b4d}\u{200c} ଫୋନ\u{b4d}\u{200c}"),
            keywords: &[
                "ଟେଲ\u{b3f}ଫୋନ\u{b4d}\u{200c}",
                "ଫୋନ\u{b4d}\u{200c}",
                "ମୋବ\u{b3e}ଇଲ\u{b4d}\u{200c}",
                "ସେଲ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a4b}ਬਾਇਲ ਫ\u{a3c}\u{a4b}ਨ"),
            keywords: &[
                "ਟ\u{a48}ਲੀਫ\u{a4b}ਨ",
                "ਫ\u{a4b}ਨ",
                "ਮ\u{a4b}ਬਾਇਲ",
                "ਮ\u{a4b}ਬਾਇਲ ਫ\u{a3c}\u{a4b}ਨ",
                "ਸ\u{a48}\u{a71}ਲਫ\u{a4b}ਨ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("موبائل فون"),
            keywords: &["خ\u{64f}لیہ", "فون", "موبائل", "ٹیلی فون"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mọ\u{301}baíl Fon"),
            keywords: &[
                "Fon",
                "Mọ\u{301}bail",
                "Mọ\u{301}baíl Fon",
                "Sẹl",
                "Tẹlífon",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("telefon komórkowy"),
            keywords: &[
                "komóra",
                "komórka",
                "smartfon",
                "telefon",
                "telefon komórkowy",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ګرځنده ټېلیفون"),
            keywords: &["سل", "فون", "موبايل", "ټيليفون", "ګرځنده ټېلیفون"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("telefone celular"),
            keywords: &["celular", "telefone", "telefone móvel"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("telemóvel"),
            keywords: &["telefone", "telemóvel"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("apaykachana telefono"),
            keywords: &["apaykachana telefono"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("telefon mobil"),
            keywords: &["celular", "mobil", "telefon"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-686"),
            keywords: &["E10-686"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мобильный телефон"),
            keywords: &["мобильник", "мобильный", "смартфон", "сотовый", "телефон"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("telefone igendanwa"),
            keywords: &[
                "kigendanwa",
                "telefone igendanwa",
                "telefoni",
                "telefoni igendanwa",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("موبائيل فون"),
            keywords: &["سيل", "فون", "موبائيل", "ٽيليفون"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ජංගම ද\u{dd4}රකථනය"),
            keywords: &["ජංගම", "ද\u{dd4}රකථනය", "සෙල\u{dca}", "ෆෝන\u{dca}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("mobil"),
            keywords: &["mobil", "mobilný", "telefón"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("mobilni telefon"),
            keywords: &["mobilni telefon", "mobilnik", "mobilno", "telefon"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("moobil"),
            keywords: &["foon", "moobil", "telefoon", "telefoonka gacanta"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("celular"),
            keywords: &["celular", "i lëvizshëm", "telefon"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мобилни телефон"),
            keywords: &["мoбилни", "мобилни телефон", "тeлeфoн"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("mobilni telefon"),
            keywords: &["mobilni", "telefon"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("mobiltelefon"),
            keywords: &["mobil", "mobiltelefon", "telefon"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("simu ya mkononi"),
            keywords: &["simu", "simu ya mkononi", "ya mkononi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மொபைல\u{bcd}"),
            keywords: &["செல\u{bcd}பேசி", "செல\u{bcd}போன\u{bcd}", "மொபைல\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c4a}బ\u{c48}ల\u{c4d} ఫ\u{c4b}న\u{c4d}"),
            keywords: &[
                "ట\u{c46}ల\u{c40}ఫ\u{c4b}న\u{c4d}",
                "ఫ\u{c4b}న\u{c4d}",
                "మ\u{c4a}బ\u{c48}ల\u{c4d}",
                "స\u{c46}ల\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("телефони мобилӣ"),
            keywords: &["телефон", "телефони мобилӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("โทรศ\u{e31}พท\u{e4c}ม\u{e37}อถ\u{e37}อ"),
            keywords: &[
                "โทรศ\u{e31}พท\u{e4c}",
                "โทรศ\u{e31}พท\u{e4c}ม\u{e37}อถ\u{e37}อ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("mobil telefon"),
            keywords: &["el telefony", "mobil", "telefon", "öýjükli"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("foni toʻotoʻo"),
            keywords: &["foni toʻotoʻo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("cep telefonu"),
            keywords: &["cep telefonu", "mobil telefon", "telefon"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يانفون"),
            keywords: &["تېلېفون", "فون", "كۆچمە", "يانفون"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("мобільний телефон"),
            keywords: &["мобільний", "стільниковий", "телефон"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("موبائل فون"),
            keywords: &["برقی آلہ", "فون", "موبائل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("mobil telefon"),
            keywords: &["aloqa", "mobil", "telefon", "uyali"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("điện thoại di động"),
            keywords: &["di động", "điện thoại", "điện thoại di động"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("telefon portaabal"),
            keywords: &["portaabal", "telefon"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iselfowuni"),
            keywords: &["ifowuni", "iselfowuni", "iseli"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("fóònù alágbèéká"),
            keywords: &["alágbèéká", "fóònù", "tẹlifóònù"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("手提電話"),
            keywords: &["手提電話", "手機", "流動", "電話"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("手提电话"),
            keywords: &["手提电话", "手机", "流动", "电话"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("手机"),
            keywords: &["手提电话", "手机", "智能手机", "电话", "移动"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("手機"),
            keywords: &["手機", "電話"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("手提電話"),
            keywords: &["手提電話", "手提電話｜電話"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iselula"),
            keywords: &["iselula", "ucingo"],
        },
    ],
};
#[doc = "📲"]
pub const MOBILE_PHONE_WITH_ARROW: crate::Emoji = crate::Emoji {
    glyph: "📲",
    codepoint: "1F4F2",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "mobile phone with arrow",
    group: "Objects",
    subgroup: "phone",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("selfoon met pyl"),
            keywords: &["mobiel", "pyl", "selfoon", "selfoon met pyl"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሞባይል ስልክ ከቀስት ጋር"),
            keywords: &["ሞባይል ስልክ ከቀስት ጋር", "ስልክ", "ቀስት", "ተቀበል ሞባይል", "ጥሪ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}هاتف جوال مع سهم"),
            keywords: &[
                "إجراء مكالمة",
                "هاتف",
                "هاتف جوال",
                "\u{202b}هاتف جوال مع سهم",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9be}\u{981}ড\u{9bc} চিনয\u{9c1}ক\u{9cd}ত মোব\u{9be}ইল ফোন"),
            keywords: &[
                "ক\u{9be}\u{981}ড\u{9bc}",
                "ক\u{9be}\u{981}ড\u{9bc} চিনয\u{9c1}ক\u{9cd}ত মোব\u{9be}ইল ফোন",
                "চেল",
                "ফোন",
                "মোব\u{9be}ইল",
                "ৰিচিভ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("oxlu mobil telefon"),
            keywords: &[
                "mobil",
                "ox",
                "oxlu mobil telefon",
                "qəbul etmək",
                "telefon",
                "zəng",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мабільны тэлефон са стрэлкай"),
            keywords: &[
                "выклік",
                "мабільны",
                "мабільны тэлефон са стрэлкай",
                "мабільнік",
                "прыём",
                "смартфон",
                "сотавы",
                "стрэлка",
                "тэлефон",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Мобилен телефон със стрелка"),
            keywords: &[
                "Мобилен телефон със стрелка",
                "клетъчен",
                "мобилен",
                "стрелка",
                "телефон",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("তীর সহ মোব\u{9be}ইল ফোন"),
            keywords: &[
                "গ\u{9cd}রহণ",
                "টেলিফোন",
                "তীর",
                "তীর সহ মোব\u{9be}ইল ফোন",
                "ফোন",
                "মোব\u{9be}ইল",
                "সেল",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pellgomzer hezoug gant bir"),
            keywords: &[
                "bir",
                "hezoug",
                "pellgomz",
                "pellgomzer",
                "pellgomzer hezoug gant bir",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("strelica pokazuje mobitel"),
            keywords: &[
                "mobilni",
                "poziv",
                "strelica",
                "strelica pokazuje mobitel",
                "telefon",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("telèfon mòbil amb fletxa"),
            keywords: &[
                "fletxa",
                "mòbil",
                "rebre",
                "telèfon mòbil",
                "telèfon mòbil amb fletxa",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏙᎴᎳᏊ ᏗᎵᏃᎮᏓ ᎤᎵᎪᏗ ᎦᏟᏓ"),
            keywords: &[
                "ᎠᎩᏍᎩ",
                "ᎠᏓᏅᏏᏙᎯ",
                "ᎦᏝᏗ",
                "ᏗᏟᏃᎮᏗ",
                "ᏗᏟᏃᎮᏗᎢ",
                "ᏙᎴᎳᏊ ᏗᎵᏃᎮᏓ ᎤᎵᎪᏗ ᎦᏟᏓ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mobil se šipkou"),
            keywords: &[
                "hovor",
                "mobil",
                "mobil se šipkou",
                "mobilní",
                "příjem",
                "telefon",
                "volání",
                "šipka",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ffôn symudol â saeth"),
            keywords: &["ffôn", "ffôn symudol â saeth", "galw", "saeth", "symudol"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mobil med pil"),
            keywords: &[
                "indgående opkald",
                "lav et opkald",
                "mobil med pil",
                "modtag et opkald",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Mobiltelefon mit Pfeil"),
            keywords: &["Anruf", "Mobiltelefon", "Mobiltelefon mit Pfeil", "Pfeil"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κινητό τηλέφωνο με βέλος"),
            keywords: &[
                "βέλος",
                "κινητό",
                "κινητό τηλέφωνο με βέλος",
                "κλήση",
                "λήψη",
                "τηλέφωνο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("mobile phone with arrow"),
            keywords: &[
                "arrow",
                "cell",
                "mobile",
                "mobile phone with arrow",
                "phone",
                "receive",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("móvil con una flecha"),
            keywords: &[
                "flecha",
                "llamada",
                "móvil",
                "móvil con una flecha",
                "recibir",
                "teléfono",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("teléfono móvil con una flecha"),
            keywords: &[
                "celular",
                "flecha",
                "hacer llamada",
                "móvil",
                "teléfono",
                "teléfono móvil con una flecha",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("flecha apuntado a teléfono celular"),
            keywords: &["flecha apuntado a teléfono celular"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "auricular",
                "celular",
                "flecha",
                "móvil",
                "teléfono",
                "teléfono móvil con una flecha",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("noolega mobiiltelefon"),
            keywords: &["kõne", "mobiil", "nool", "noolega mobiiltelefon", "telefon"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("telefono mugikorra gezi batekin"),
            keywords: &[
                "dei",
                "gezi",
                "jaso",
                "mugikor",
                "sare",
                "telefono",
                "telefono mugikorra gezi batekin",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تلفن همراه با پیکان"),
            keywords: &[
                "تلفن همراه",
                "تلفن همراه با پیکان",
                "دریافت",
                "پیکان",
                "گوشی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kännykkä ja nuoli"),
            keywords: &[
                "kännykkä ja nuoli",
                "matkapuhelin",
                "nuoli",
                "puhelin",
                "puhelu",
                "saapuva",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mobile phone na may arrow"),
            keywords: &[
                "arrow",
                "cell",
                "mobile",
                "mobile phone na may arrow",
                "phone",
                "tanggap",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("fartelefon við píli"),
            keywords: &[
                "fartelefon",
                "fartelefon við píli",
                "kall",
                "uppkall",
                "uppringing",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("appel entrant"),
            keywords: &["appel", "appel entrant"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("téléphone cellulaire précédé par une flèche"),
            keywords: &["appel", "téléphone cellulaire précédé par une flèche"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("guthán le saighead"),
            keywords: &[
                "cuir glaoch",
                "fón póca",
                "fón póca le saighead",
                "guthán le saighead",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("fòn-làimhe le saighead"),
            keywords: &[
                "cuir fòn",
                "faigh",
                "faighinn",
                "fòn",
                "fòn-làimhe",
                "fòn-làimhe le saighead",
                "gairm",
                "mobile",
                "saighead",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("teléfono móbil con frecha"),
            keywords: &[
                "frecha",
                "móbil",
                "recibir",
                "teléfono",
                "teléfono móbil con frecha",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("તીર સાથ\u{ac7}નો મોબાઇલ ફોન"),
            keywords: &[
                "એક કૉલ કરો",
                "તીર સાથ\u{ac7}નો મોબાઇલ ફોન",
                "તીર સાથ\u{ac7}નો સ\u{ac7}લ ફોન",
                "ફોન",
                "મોબાઇલ ફોન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("wayar hannu tare da kibiya"),
            keywords: &[
                "karɓa",
                "kibiya",
                "kira",
                "na hannu",
                "sel",
                "tarho",
                "waya",
                "wayar hannu tare da kibiya",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("טלפון נייד עם חץ"),
            keywords: &["חץ", "טלפון", "טלפון נייד עם חץ", "נייד", "שיחה נכנסת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("तीर क\u{947} साथ मोबाइल फ\u{93c}ोन"),
            keywords: &[
                "तीर",
                "तीर क\u{947} साथ फ\u{93c}ोन",
                "तीर क\u{947} साथ मोबाइल फ\u{93c}ोन",
                "मोबाइल",
                "स\u{947}ल",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("mobilni telefon sa strelicom"),
            keywords: &[
                "dolazni poziv",
                "mobilni telefon",
                "mobilni telefon sa strelicom",
                "mobitel",
                "strelica",
                "telefon",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("mobiltelefon nyíllal"),
            keywords: &[
                "hívás",
                "mobil",
                "mobiltelefon",
                "mobiltelefon nyíllal",
                "nyíl",
                "rádiótelefon",
                "telefon",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բջջային հեռախոս սլաքով"),
            keywords: &[
                "բջջային",
                "բջջային հեռախոս սլաքով",
                "զանգել",
                "հեռախոս",
                "շարժական",
                "սլաք",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("telepon masuk"),
            keywords: &[
                "panah",
                "panggilan",
                "ponsel",
                "seluler",
                "telepon",
                "telepon masuk",
                "terima",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ekwentị kengaghari nwere ube"),
            keywords: &[
                "ekwenti",
                "ekwentị kengaghari nwere ube",
                "kengaghari",
                "kpọọ",
                "mpanaka",
                "nnata",
                "ube",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("farsími með ör"),
            keywords: &["farsími", "farsími með ör", "hringja", "sími"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("telefono cellulare con freccia"),
            keywords: &[
                "cellulare",
                "cellulare con freccia",
                "telefonare",
                "telefono",
                "telefono cellulare con freccia",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("着信中"),
            keywords: &[
                "スマホ",
                "スマートフォン",
                "受信",
                "携帯受信",
                "携帯電話",
                "着信中",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("telepon seluler nganggo panah"),
            keywords: &[
                "nampa",
                "panah",
                "sel",
                "seluler",
                "telepon",
                "telepon seluler nganggo panah",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მობილური ტელეფონი ისრით"),
            keywords: &[
                "ზარი",
                "ისარი",
                "მიღება",
                "მობილური",
                "მობილური ტელეფონი ისრით",
                "ტელეფონი",
                "ფიჭური",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ұялы телефонға қабылдау"),
            keywords: &[
                "көрсеткі",
                "көрсеткісі бар мобильді телефон",
                "мобильді",
                "телефон",
                "қабылдау",
                "ұялы",
                "ұялы телефонға қабылдау",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("mobil med pil"),
            keywords: &["lav et opkald", "mobil med pil"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ទ\u{17bc}រស\u{17d0}ព\u{17d2}ទស\u{17d2}មាតហ\u{17d2}វ\u{17bc}នមានសញ\u{17d2}ញាព\u{17d2}រ\u{17bd}ញទៅឆ\u{17d2}វេង",
            ),
            keywords: &[
                "ទ\u{17bc}រសព\u{17d2}ទ",
                "ទ\u{17bc}រសព\u{17d2}ទចល\u{17d0}ត",
                "ទ\u{17bc}រសព\u{17d2}ទដៃ\u{200b}ជាម\u{17bd}យសញ\u{17d2}ញាព\u{17d2}រ\u{17bd}ញ",
                "ទ\u{17bc}រស\u{17d0}ព\u{17d2}ទ",
                "ទ\u{17bc}រស\u{17d0}ព\u{17d2}ទដៃ",
                "ទ\u{17bc}រស\u{17d0}ព\u{17d2}ទស\u{17d2}មាតហ\u{17d2}វ\u{17bc}នមានសញ\u{17d2}ញាព\u{17d2}រ\u{17bd}ញទៅឆ\u{17d2}វេង",
                "សញ\u{17d2}ញាព\u{17d2}រ\u{17bd}ញ",
                "ស\u{17d2}មាតហ\u{17d2}វ\u{17bc}ន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬಾಣದ ಗುರುತ\u{cbf}ನೊಂದ\u{cbf}ಗ\u{cc6} ಮೊಬೈಲ\u{ccd} ಫೋನ\u{ccd}"),
            keywords: &[
                "ಕರ\u{cc6} ಮಾಡ\u{cbf}",
                "ಫೋನ\u{ccd}",
                "ಬಾಣದ ಗುರುತ\u{cbf}ನೊಂದ\u{cbf}ಗ\u{cc6} ಮೊಬೈಲ\u{ccd} ಫೋನ\u{ccd}",
                "ಮೊಬೈಲ\u{ccd} ಫೋನ\u{ccd}",
                "ಸ\u{cc6}ಲ\u{ccd} ಫೋನ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("왼쪽에 화살표가 있는 휴대전화"),
            keywords: &[
                "모바일폰",
                "왼쪽에 화살표가 있는 휴대전화",
                "통화",
                "휴대전화",
                "휴대폰",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बाण आसपी मोबायल फोन"),
            keywords: &[
                "फोन",
                "बाण",
                "बाण आसपी मोबायल फोन",
                "म\u{947}ळोवप",
                "मोबायल",
                "स\u{945}ल",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("мобилдик телефон менен жебе"),
            keywords: &[
                "жебеси бар мобилдик телефон",
                "мобилдик",
                "мобилдик телефон менен жебе",
                "телефон",
                "уюлдук",
                "чалуу",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Handy mat feil"),
            keywords: &[
                "Feil",
                "Funk",
                "Handy",
                "Handy mat feil",
                "Mobil",
                "Telefon",
                "Uruff",
                "empfänken",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໂທລະສ\u{eb1}ບມ\u{eb7}ຖ\u{eb7}ກ\u{eb1}ບລ\u{eb9}ກສອນ"),
            keywords: &[
                "ມ\u{eb7}ຖ\u{eb7}",
                "ລ\u{eb9}ກສອນ",
                "ໂທລະສ\u{eb1}ບ",
                "ໂທລະສ\u{eb1}ບມ\u{eb7}ຖ\u{eb7}ກ\u{eb1}ບລ\u{eb9}ກສອນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mobilusis telefonas su rodykle"),
            keywords: &[
                "mobilusis",
                "mobilusis telefonas su rodykle",
                "rodyklė",
                "skambinti",
                "telefonas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("mobilais tālrunis ar bultiņu"),
            keywords: &[
                "bultiņa",
                "mobilais",
                "mobilais tālrunis ar bultiņu",
                "telefons",
                "tālrunis",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("waea pūkoro me te pere"),
            keywords: &[
                "pere",
                "pūkoro",
                "pūwhiwhi",
                "waea",
                "waea pūkoro me te pere",
                "waeakawe",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("мобилен телефон со стрелка"),
            keywords: &[
                "дојдовен",
                "мобилен",
                "мобилен телефон со стрелка",
                "повик",
                "стрелка",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("അമ\u{d4d}പടയ\u{d3e}ളമ\u{d41}ള\u{d4d}ള മൊബൈൽ"),
            keywords: &[
                "അമ\u{d4d}പടയ\u{d3e}ളമ\u{d41}ള\u{d4d}ള മൊബൈൽ",
                "കോൾ ചെയ\u{d4d}യ\u{d41}ക",
                "ഫോൺ",
                "മൊബൈൽ",
                "വിളിക\u{d4d}ക\u{d41}ക",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гар утсыг заасан нум"),
            keywords: &[
                "гар утсыг заасан нум",
                "мобайл",
                "сум",
                "сумтай гар утас",
                "утас",
                "хүлээн авах",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("बाण असल\u{947}ला मोबाईल फोन"),
            keywords: &[
                "कॉल करा",
                "फोन करा",
                "बाण असल\u{947}ला मोबाईल फोन",
                "बाणासहीत स\u{947}ल फोन",
                "मोबाइल फोन",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("telefon bimbit dengan anak panah"),
            keywords: &[
                "anak panah",
                "mudah alih",
                "sel",
                "telefon",
                "telefon bimbit dengan anak panah",
                "terima",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("mowbajl bi vleġġa"),
            keywords: &[
                "jirċievu",
                "mowbajl",
                "mowbajl bi vleġġa",
                "telefon",
                "telefown",
                "vleġġa",
                "ċempel",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "မြားန\u{103e}င\u{1037}\u{103a} မ\u{102d}\u{102f}ဘ\u{102d}\u{102f}င\u{103a}း ဖ\u{102f}န\u{103a}း",
            ),
            keywords: &[
                "ဆ\u{1032}လ\u{103a}",
                "ဖ\u{102f}န\u{103a}း",
                "ဖ\u{102f}န\u{103a}းအဝင\u{103a}",
                "မ\u{102d}\u{102f}ဘ\u{102d}\u{102f}င\u{103a}း",
                "မြားန\u{103e}င\u{1037}\u{103a} မ\u{102d}\u{102f}ဘ\u{102d}\u{102f}င\u{103a}း ဖ\u{102f}န\u{103a}း",
                "မြားပြထားသည\u{1037}\u{103a} မ\u{102d}\u{102f}ဘ\u{102d}\u{102f}င\u{103a}ဖ\u{102f}န\u{103a}းပ\u{102f}\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mobiltelefon med pil"),
            keywords: &[
                "anrop",
                "mobiltelefon",
                "mobiltelefon med pil",
                "pil",
                "ring",
                "telefon",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("तीरल\u{947} द\u{947}खाइएको मोबाइल"),
            keywords: &[
                "तीर",
                "तीरल\u{947} द\u{947}खाइएको मोबाइल",
                "प\u{94d}राप\u{94d}त गर\u{94d}न\u{941}",
                "फोन",
                "मोबाइल",
                "स\u{947}ल",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("mobiel met pijl"),
            keywords: &[
                "mobiel",
                "mobiel met pijl",
                "mobiele telefoon",
                "ontvangen",
                "pijl",
                "telefoon",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mobiltelefon med pil"),
            keywords: &[
                "mobiltelefon",
                "mobiltelefon med pil",
                "oppkall",
                "oppringing",
                "pil",
                "ring",
                "telefon",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ତୀର ସହ\u{b3f}ତ ମୋବ\u{b3e}ଇଲ\u{b4d}\u{200c} ଫୋନ\u{b4d}\u{200c}"),
            keywords: &[
                "ଗ\u{b4d}ରହଣକର\u{b3f}ବ\u{b3e}",
                "ତୀର",
                "ତୀର ସହ\u{b3f}ତ ମୋବ\u{b3e}ଇଲ\u{b4d}\u{200c} ଫୋନ\u{b4d}\u{200c}",
                "ଫୋନ\u{b4d}\u{200c}",
                "ମୋବ\u{b3e}ଇଲ\u{b4d}\u{200c}",
                "ସେଲ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਤੀਰ ਨਾਲ ਮ\u{a4b}ਬਾਇਲ ਫ\u{a4b}ਨ"),
            keywords: &[
                "ਇ\u{a71}ਕ ਕਾਲ ਕਰ\u{a4b}",
                "ਟ\u{a48}ਲੀਫ\u{a4b}ਨ",
                "ਤੀਰ ਨਾਲ ਮ\u{a4b}ਬਾਇਲ ਫ\u{a4b}ਨ",
                "ਮ\u{a4b}ਬਾਇਲ ਫ\u{a4b}ਨ",
                "ਸ\u{a48}\u{a71}ਲਫ\u{a4b}\u{a4b}ਨ ਤੀਰ ਨਾਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("تیر نال موبائل فون"),
            keywords: &[
                "تیر",
                "تیر نال موبائل فون",
                "خ\u{64f}لیہ",
                "فون",
                "موبائل",
                "وصول کرنا",
                "ٹیلی فون",
                "کال",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mọ\u{301}baíl Fon Wit Áro"),
            keywords: &[
                "Fon",
                "Mọ\u{301}bail",
                "Mọ\u{301}baíl Fon Wit Áro",
                "Risiv",
                "Sẹl",
                "Áro",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("telefon komórkowy ze strzałką"),
            keywords: &[
                "dzwonić",
                "komórka",
                "odebrać",
                "smartfon",
                "strzałka",
                "telefon",
                "telefon komórkowy ze strzałką",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("غشی لرونکی ګرځنده ټېلیفون"),
            keywords: &[
                "ترلاسه کول",
                "غشی",
                "غشی لرونکی ګرځنده ټېلیفون",
                "فون",
                "موبايل",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("telefone celular com seta"),
            keywords: &[
                "celular",
                "receber",
                "seta",
                "telefone",
                "telefone celular com seta",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("telemóvel com seta"),
            keywords: &[
                "chamada",
                "receber",
                "seta",
                "telefone",
                "telemóvel",
                "telemóvel com seta",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("apaykachana telefono wachʼiwan"),
            keywords: &["apaykachana telefono wachʼiwan"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("telefon mobil cu săgeată"),
            keywords: &[
                "celular",
                "mobil",
                "recepție",
                "săgeată",
                "telefon",
                "telefon mobil cu săgeată",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-687"),
            keywords: &["E10-687"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("входящий вызов"),
            keywords: &[
                "входящий вызов",
                "вызов",
                "мобильный телефон",
                "смартфон",
                "сотовый",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("telefoni igendanwa n’akambi"),
            keywords: &[
                "akambi",
                "akazu",
                "guhamagra",
                "kigendanwa",
                "kwakira",
                "telefoni",
                "telefoni igendanwa n’akambi",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("تير سان گڏ موبائل فون"),
            keywords: &[
                "تير",
                "تير سان گڏ موبائل فون",
                "سيل",
                "فون",
                "موبائيل",
                "وٺڻ",
                "ٽيليفون",
                "ڪال",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඊතලයක\u{dca} සහ\u{dd2}ත ජංගම ද\u{dd4}රකථනය"),
            keywords: &[
                "ඇමත\u{dd4}ම",
                "ඊතලයක\u{dca} සහ\u{dd2}ත ජංගම ද\u{dd4}රකථනය",
                "ජංගම",
                "ද\u{dd4}රකථනය",
                "සෙල\u{dca} ෆෝන\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("mobil so šípkou"),
            keywords: &[
                "hovor",
                "mobil",
                "mobil so šípkou",
                "mobilný",
                "prijímať",
                "telefón",
                "šípka",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("mobilni telefon s puščico"),
            keywords: &[
                "klic",
                "mobilni telefon s puščico",
                "mobilnik",
                "mobilno",
                "puščica",
                "sprejeti",
                "telefon",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("moobil leh xariiq"),
            keywords: &[
                "foon",
                "helid",
                "moobil",
                "moobil leh xariiq",
                "telefoonka gacanta",
                "xariiq",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("celular me shigjetë"),
            keywords: &[
                "celular",
                "celular me shigjetë",
                "marr",
                "shigjetë",
                "telefonatë",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мобилни телефон са стрелицом"),
            keywords: &[
                "дoлaзни пoзив",
                "мoбилни",
                "мобилни телефон са стрелицом",
                "стрeлицa",
                "тeлeфoн",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("mobilni telefon sa strelicom"),
            keywords: &[
                "dolazni poziv",
                "mobilni",
                "mobilni telefon sa strelicom",
                "strelica",
                "telefon",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("mobiltelefon med pil"),
            keywords: &["mobil", "mobiltelefon med pil", "ringa", "telefon"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("simu ya mkononi yenye kishale"),
            keywords: &[
                "mshale",
                "piga simu",
                "pokea",
                "simu",
                "simu ya mkononi",
                "simu ya mkononi yenye kishale",
                "ya mkononi",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அம\u{bcd}புக\u{bcd}குறியுடன\u{bcd} செல\u{bcd}போன\u{bcd}"),
            keywords: &[
                "ஃபோன\u{bcd}",
                "அம\u{bcd}புக\u{bcd}குறி",
                "அம\u{bcd}புக\u{bcd}குறியுடன\u{bcd} செல\u{bcd}போன\u{bcd}",
                "செல\u{bcd}ஃபோன\u{bcd}",
                "பெறுதல\u{bcd}",
                "மொபைல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "బ\u{c3e}ణం గుర\u{c4d}తుత\u{c4b} సూచ\u{c3f}స\u{c4d}తున\u{c4d}న మ\u{c4a}బ\u{c48}ల\u{c4d} ఫ\u{c4b}న\u{c4d}",
            ),
            keywords: &[
                "ఇన\u{c4d}\u{200c}కమ\u{c3f}ంగ\u{c4d} ఫ\u{c4b}న\u{c4d} క\u{c3e}ల\u{c4d}",
                "ఫ\u{c4b}న\u{c4d}\u{200c}కు స\u{c47}వ\u{c4d} చ\u{c47}య\u{c3f}",
                "బ\u{c3e}ణం గుర\u{c4d}తుత\u{c4b} సూచ\u{c3f}స\u{c4d}తున\u{c4d}న మ\u{c4a}బ\u{c48}ల\u{c4d} ఫ\u{c4b}న\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("телефони мобилӣ бо тир"),
            keywords: &[
                "занг",
                "телефон",
                "телефони мобилӣ",
                "телефони мобилӣ бо тир",
                "тир",
                "қабул кардан",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some(
                "โทรศ\u{e31}พท\u{e4c}ม\u{e37}อถ\u{e37}อพร\u{e49}อมล\u{e39}กศรช\u{e35}\u{e49}",
            ),
            keywords: &[
                "ม\u{e37}อถ\u{e37}อ",
                "ล\u{e39}กศร",
                "โทร",
                "โทรศ\u{e31}พท\u{e4c}",
                "โทรศ\u{e31}พท\u{e4c}ม\u{e37}อถ\u{e37}อพร\u{e49}อมล\u{e39}กศรช\u{e35}\u{e49}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("okly mobil telefon"),
            keywords: &[
                "almak",
                "el telefony",
                "mobil",
                "ok",
                "okly mobil telefon",
                "telefon",
                "öýjükli",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("foni toʻotoʻo moe ngahau"),
            keywords: &["foni toʻotoʻo moe ngahau"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ok işaretli cep telefonu"),
            keywords: &[
                "mobil telefon",
                "ok işaretli cep telefonu",
                "telefon",
                "çağrı yapmak",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كۆرسەتكۈچلۈك يانفون"),
            keywords: &[
                "ئېلىش",
                "تېلېفون",
                "فون",
                "كۆرسەتكۈچ",
                "كۆرسەتكۈچلۈك يانفون",
                "كۆچمە",
                "يانفون",
                "چاقىرىش",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("мобільний телефон зі стрілкою"),
            keywords: &[
                "мобільний",
                "мобільний телефон зі стрілкою",
                "отримувати",
                "стрілка",
                "стільниковий",
                "телефон",
                "телефонувати",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("تیر کے نشان کے ساتھ موبائل فون"),
            keywords: &[
                "تیر",
                "تیر کے نشان کے ساتھ موبائل فون",
                "فون",
                "موبائل",
                "نشان",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("mobil telefon va strelka"),
            keywords: &[
                "mobil",
                "mobil telefon va strelka",
                "qabul qilish",
                "strelka",
                "strelkali mobil telefon",
                "telefon",
                "uyali aloqa",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("điện thoại di động có mũi tên"),
            keywords: &[
                "di động",
                "gọi",
                "mũi tên",
                "nhận",
                "điện thoại",
                "điện thoại di động có mũi tên",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("telefon portaabal ak fett"),
            keywords: &[
                "fett",
                "jot",
                "portaabal",
                "telefon",
                "telefon portaabal ak fett",
                "woote",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iselfowuni enotolo"),
            keywords: &[
                "fumana",
                "ifowuni",
                "iselfowuni",
                "iselfowuni enotolo",
                "iseli",
                "umnxeba",
                "utolo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("fóònù alágbèéká pẹ\u{300}lú ofà"),
            keywords: &[
                "alágbèéká",
                "fóònù",
                "fóònù alágbèéká pẹ\u{300}lú ofà",
                "gbà",
                "tẹlifóònù",
                "ìpè",
                "ọfà",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("有箭咀嘅手提電話"),
            keywords: &["手提電話", "手機", "收到", "有箭咀嘅手提電話", "箭咀"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("有箭咀嘅手提电话"),
            keywords: &[
                "手提电话",
                "手机",
                "打电话",
                "收到",
                "有箭咀嘅手提电话",
                "流动电话",
                "电话",
                "箭咀",
            ],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("带有箭头的手机"),
            keywords: &["带有箭头的手机", "手机", "接收", "智能手机", "来电"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("接電話"),
            keywords: &["手機", "接電話", "電話"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("個有箭嘴嘅電話"),
            keywords: &["個有箭嘴嘅電話", "手提電話", "接電話", "電話"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iselula enomcibisholo"),
            keywords: &[
                "iselula",
                "iselula enomcibisholo",
                "ucingo",
                "ukufona",
                "ukwamukela",
                "umcibisholo",
            ],
        },
    ],
};
#[doc = "☎\u{fe0f}"]
pub const TELEPHONE: crate::Emoji = crate::Emoji {
    glyph: "☎\u{fe0f}",
    codepoint: "260E FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "telephone",
    group: "Objects",
    subgroup: "phone",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "☎",
        codepoint: "260E",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "telephone",
        group: "Objects",
        subgroup: "phone",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("telefoon"),
            keywords: &["foon", "telefoon"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቴሌፎን"),
            keywords: &["ስልክ", "ቴሌፎን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("هاتف أرضي"),
            keywords: &["هاتف", "هاتف أرضي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("টেলিফোন"),
            keywords: &["টেলিফোন", "ফোন"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("telefon"),
            keywords: &["telefon"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("хатні тэлефон"),
            keywords: &["тэлефон", "хатні тэлефон"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("телефон"),
            keywords: &["телефон"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("টেলিফোন"),
            keywords: &["টেলিফোন", "ফোন"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pellgomzer"),
            keywords: &["pellgomz", "pellgomzer"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("telefon"),
            keywords: &["telefon"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("telèfon"),
            keywords: &["telèfon"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄑𑄬𑄣\u{11128}𑄜\u{1112e}𑄚\u{11134}"),
            keywords: &["𑄑𑄬𑄣\u{11128}𑄜\u{1112e}𑄚\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏴᏫ ᏗᏟᏃᎮᏗ"),
            keywords: &["ᏗᏟᏃᎮᏗ", "ᏴᏫ ᏗᏟᏃᎮᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("telefon"),
            keywords: &["telefon"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ffôn"),
            keywords: &["ffôn", "teleffon"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("telefon"),
            keywords: &["fastnet", "telefon"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Telefon"),
            keywords: &["Festnetz", "Telefon"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τηλέφωνο"),
            keywords: &["τηλέφωνο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("telephone"),
            keywords: &["phone", "telephone"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["landline", "phone", "telephone"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("teléfono"),
            keywords: &["teléfono"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("teléfono de línea"),
            keywords: &["cables", "línea", "teléfono", "teléfono de línea"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("teléfono fijo"),
            keywords: &["teléfono fijo"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("telefon"),
            keywords: &["telefon"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("telefonoa"),
            keywords: &["telefono", "telefonoa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تلفن"),
            keywords: &["تلفن", "تلفن زدن", "تلفن کردن", "دورگو", "گوشی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("puhelin"),
            keywords: &["lankapuhelin", "puhelin"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("telepono"),
            keywords: &["pangtawag", "telepono"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("telefon"),
            keywords: &["telefon"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("téléphone"),
            keywords: &["téléphone"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("teileafón"),
            keywords: &["fón", "teileafón"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("fòn"),
            keywords: &["fòn"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("teléfono"),
            keywords: &["teléfono"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ટ\u{ac7}લિફોન"),
            keywords: &["ટ\u{ac7}લિફોન", "ફોન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("tarho"),
            keywords: &["tarho", "waya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("טלפון רגיל"),
            keywords: &["טלפון", "טלפון רגיל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ट\u{947}लीफ\u{93c}ोन"),
            keywords: &["ट\u{947}लीफ\u{93c}ोन", "द\u{942}रभाष", "फ\u{93c}ोन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("telefon"),
            keywords: &["telefon"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("telefon"),
            keywords: &["telefon"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("հեռախոս"),
            keywords: &["հեռախոս"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("telepon"),
            keywords: &["telepon"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ekwentị"),
            keywords: &["ekwentị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sími"),
            keywords: &["sími"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("telefono fisso"),
            keywords: &["telefono di casa", "telefono fisso"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("固定電話"),
            keywords: &["ボタン式電話", "固定電話", "親機", "電話", "黒電話"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("telepon"),
            keywords: &["telepon", "telpon"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ტელეფონი"),
            keywords: &["ტელეფონი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tiliɣri"),
            keywords: &["tiliɣri"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("телефон"),
            keywords: &["телефон"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("telefon"),
            keywords: &["telefon"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ទ\u{17bc}រស\u{17d0}ព\u{17d2}ទលើត\u{17bb}"),
            keywords: &[
                "ទ\u{17bc}រស\u{17d0}ព\u{17d2}ទ",
                "ទ\u{17bc}រស\u{17d0}ព\u{17d2}ទលើត\u{17bb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಫೋನ\u{ccd}\u{200c}"),
            keywords: &["ದ\u{cc2}ರವಾಣ\u{cbf}", "ಫೋನ\u{ccd}\u{200c}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("전화기"),
            keywords: &["유선전화", "전화기"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ट\u{947}लिफोन"),
            keywords: &["ट\u{947}लिफोन", "फोन"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("телефон"),
            keywords: &["телефон"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Telefon"),
            keywords: &["Telefon"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໂທລະສ\u{eb1}ບ"),
            keywords: &["ໂທລະສ\u{eb1}ບ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("telefonas"),
            keywords: &["telefonas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("tālrunis"),
            keywords: &["telefons", "tālrunis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("waea"),
            keywords: &["waea"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("телефон"),
            keywords: &["телефон", "фиксен"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ടെലിഫോൺ"),
            keywords: &["ടെലിഫോൺ", "ഫോൺ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("суурин утас"),
            keywords: &["суурин", "утас"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ट\u{947}लिफोन"),
            keywords: &["ट\u{947}लिफोन", "फोन"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("telefon"),
            keywords: &["fon", "telefon"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("telefon"),
            keywords: &["telefon", "telefown"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တယ\u{103a}လ\u{102e}ဖ\u{102f}န\u{103a}း"),
            keywords: &[
                "တယ\u{103a}လ\u{102e}ဖ\u{102f}န\u{103a}း",
                "ဖ\u{102f}န\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("telefon"),
            keywords: &["fasttelefon", "ringe", "telefon"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ट\u{947}लिफोन"),
            keywords: &["ट\u{947}लिफोन", "फोन"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("telefoon"),
            keywords: &["telefoon"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("telefon"),
            keywords: &["fasttelefon", "ringje", "telefon"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଟେଲ\u{b3f}ଫୋନ\u{b4d}\u{200c}"),
            keywords: &["ଟେଲ\u{b3f}ଫୋନ\u{b4d}\u{200c}", "ଫୋନ\u{b4d}\u{200c}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਟ\u{a48}ਲੀਫ\u{a3c}\u{a4b}ਨ"),
            keywords: &["ਟ\u{a48}ਲੀਫ\u{a3c}\u{a4b}ਨ", "ਫ\u{a4b}ਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ٹیلی فون"),
            keywords: &["فون", "ٹیلی فون"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tẹlífon"),
            keywords: &["Fon", "Tẹlífon"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("telefon"),
            keywords: &["aparat telefoniczny", "telefon"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ټیلیفون"),
            keywords: &["فون", "ټليفون", "ټیلیفون"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("telefone no gancho"),
            keywords: &["gancho", "telefone", "telefone no gancho"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("telefone"),
            keywords: &["telefone", "telefone fixo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("fono"),
            keywords: &["fono"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("telefon"),
            keywords: &["fix", "telefon"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-046"),
            keywords: &["E10-046"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("телефон"),
            keywords: &["аппарат", "линия", "телефон", "трубка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("telefone"),
            keywords: &["telefone", "telefoni"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٽيليفون"),
            keywords: &["فون", "ٽيليفون"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ටෙල\u{dd2}ෆෝනය"),
            keywords: &["ටෙල\u{dd2}ෆෝනය", "ද\u{dd4}රකථනය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("telefón"),
            keywords: &["telefón"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("telefon"),
            keywords: &["telefon"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("telefoon"),
            keywords: &["foon", "telefoon"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("telefon"),
            keywords: &["telefon"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("телефон"),
            keywords: &["тeлeфoн", "телефон"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("telefon"),
            keywords: &["telefon"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("telefon"),
            keywords: &["telefon"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("simu"),
            keywords: &["simu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("தொலைபேசி"),
            keywords: &["ஃபோன\u{bcd}", "டெலிபோன\u{bcd}", "தொலைபேசி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ట\u{c46}ల\u{c3f}ఫ\u{c4b}న\u{c4d}"),
            keywords: &["క\u{c3e}ల\u{c4d}", "ట\u{c46}ల\u{c3f}ఫ\u{c4b}న\u{c4d}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("телефон"),
            keywords: &["телефон"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("โทรศ\u{e31}พท\u{e4c}"),
            keywords: &["โทรศ\u{e31}พท\u{e4c}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("telefon trubkasy"),
            keywords: &["telefon", "telefon trubkasy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("telefoni"),
            keywords: &["telefoni"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("telefon"),
            keywords: &["telefon"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تېلېفون"),
            keywords: &["تېلېفون"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("телефон"),
            keywords: &["телефон"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ٹیلیفون"),
            keywords: &["برقی آلہ", "فون", "ٹیلیفون"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("telefon"),
            keywords: &["telefon", "uy telefoni"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("điện thoại bàn"),
            keywords: &["điện thoại", "điện thoại bàn"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("telefon"),
            keywords: &["telefon"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ifowuni"),
            keywords: &["ifowuni"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("tẹlifóònù"),
            keywords: &["tẹlifóònù", "ẹ\u{300}rọ ìbánisọ\u{300}rọ\u{300}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("電話"),
            keywords: &["電話"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("电话"),
            keywords: &["电话"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("电话"),
            keywords: &["固定电话", "固话", "座机", "电话"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("電話"),
            keywords: &["市話", "電話"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["室內電話", "電話"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ucingo"),
            keywords: &["ifoni", "ucingo"],
        },
    ],
};
#[doc = "📞"]
pub const TELEPHONE_RECEIVER: crate::Emoji = crate::Emoji {
    glyph: "📞",
    codepoint: "1F4DE",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "telephone receiver",
    group: "Objects",
    subgroup: "phone",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("telefoongehoorstuk"),
            keywords: &["foon", "gehoorstuk", "telefoon", "telefoongehoorstuk"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የቴሌፎን መነጋገሪያ"),
            keywords: &["ሪሲቨር", "ስልክ", "ቴሌፎን", "የቴሌፎን መነጋገሪያ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سماعة هاتف"),
            keywords: &["تليفون", "تواصل", "سماعة هاتف", "هاتف"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("টেলিফোন ৰিচিভ\u{9be}ৰ"),
            keywords: &["টেলিফোন", "ফোন", "ৰিচিভ\u{9be}ৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("telefon dəstəyi"),
            keywords: &["qəbuledən", "telefon", "telefon dəstəyi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("тэлефонная трубка"),
            keywords: &["трубка", "тэлефон", "тэлефонная трубка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Телефонна слушалка"),
            keywords: &["Телефонна слушалка", "слушалка", "телефон"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("টেলিফোন রিসিভ\u{9be}র"),
            keywords: &["টেলিফোন", "ফোন", "রিসিভ\u{9be}র"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("yevenn bellgomz"),
            keywords: &["pellgomz", "pellgomzer", "yevenn", "yevenn bellgomz"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("slušalica"),
            keywords: &["slušalica", "telefon"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("auricular de telèfon"),
            keywords: &["auricular", "auricular de telèfon", "telèfon"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄑𑄬𑄣\u{11128}𑄜\u{1112e}𑄚\u{11134} 𑄢\u{11128}𑄥\u{11128}𑄞𑄢\u{11134}"),
            keywords: &["𑄑𑄬𑄣\u{11128}𑄜\u{1112e}𑄚\u{11134} 𑄢\u{11128}𑄥\u{11128}𑄞𑄢\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎵᏃᎮᏗ ᎦᏬᏂᏍᏙᏗ"),
            keywords: &["ᎠᎩᏏᏍᎩ", "ᏗᎵᏃᎮᏗ ᎦᏬᏂᏍᏙᏗ", "ᏗᏟᏃᎮᏗᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("telefonní sluchátko"),
            keywords: &[
                "mikrotelefon",
                "sluchátko",
                "telefon",
                "telefonní sluchátko",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("derbynnydd ffôn"),
            keywords: &["derbyniwr", "derbynnydd ffôn", "ffôn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("telefonrør"),
            keywords: &["kommunikation", "telefonrør"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Telefonhörer"),
            keywords: &["Hörer", "Telefon", "Telefonhörer", "anrufen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ακουστικό τηλεφώνου"),
            keywords: &["ακουστικό τηλεφώνου", "δέκτης", "τηλέφωνο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("telephone receiver"),
            keywords: &["phone", "receiver", "telephone"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("auricular de teléfono"),
            keywords: &["auricular de teléfono", "comunicación", "teléfono"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("teléfono"),
            keywords: &["comunicación", "teléfono", "tubo"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("auricular"),
            keywords: &["auricular", "teléfono"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("telefonitoru"),
            keywords: &["telefon", "telefonitoru", "toru"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("telefono-hargailua"),
            keywords: &["hargailu", "telefono", "telefono-hargailua"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("گوشی تلفن"),
            keywords: &["تلفن", "گوشی", "گیرنده"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("luuri"),
            keywords: &["kuuloke", "luuri", "puhelin"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("receiver ng telepono"),
            keywords: &["phone", "receiver ng telepono", "tagatanggap", "telepono"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("horn á telefon"),
            keywords: &["horn á telefon", "telefonhorn", "telefonrør"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("combiné téléphonique"),
            keywords: &["combiné téléphonique", "téléphone"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("récepteur téléphonique"),
            keywords: &["récepteur téléphonique", "téléphone"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("glacadán fóin"),
            keywords: &[
                "cumarsáid",
                "fón",
                "glacadán",
                "glacadán fóin",
                "guthán",
                "teileafón",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("glacadair-fòn"),
            keywords: &["fòn", "glacadair-fòn"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("auricular do teléfono"),
            keywords: &["auricular", "auricular do teléfono", "receptor", "teléfono"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ટ\u{ac7}લિફોનન\u{ac1}\u{a82} રીસિવર"),
            keywords: &[
                "ટ\u{ac7}લિફોન",
                "ટ\u{ac7}લિફોનન\u{ac1}\u{a82} રીસિવર",
                "ફોન",
                "ફોનન\u{ac1}\u{a82} રીસિવર",
                "સ\u{a82}ચાર",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kan tarho"),
            keywords: &["kan tarho", "tarho", "waya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שפופרת טלפון"),
            keywords: &["טלפון", "שפופרת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ट\u{947}लीफ\u{93c}ोन रिसीवर"),
            keywords: &[
                "ट\u{947}लीफ\u{93c}ोन",
                "ट\u{947}लीफ\u{93c}ोन रिसीवर",
                "फ\u{93c}ोन",
                "फ\u{93c}ोन रिसीवर",
                "स\u{902}चार",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("telefonska slušalica"),
            keywords: &["slušalica", "telefon", "telefonska slušalica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("telefonkagyló"),
            keywords: &["kagyló", "telefon", "telefonkagyló"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("հեռախոսի լսափող"),
            keywords: &["լսափող", "հեռախոս", "հեռախոսի լսափող"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("gagang telepon"),
            keywords: &["gagang telepon", "penerima", "telepon"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("onye nnataozi ekwenti"),
            keywords: &["ekwenti", "onye nnataozi", "onye nnataozi ekwenti"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("símtól"),
            keywords: &["samskipti", "sími", "símtól"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cornetta"),
            keywords: &[
                "comunicazione",
                "cornetta",
                "cornetta del telefono",
                "telefono",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("受話器"),
            keywords: &["受話器", "子機", "電話"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("gagang telpon"),
            keywords: &["gagang", "telepon", "telpon"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ტელეფონის ყურმილი"),
            keywords: &["მიმღები", "ტელეფონი", "ტელეფონის ყურმილი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("телефон ресивері"),
            keywords: &["ресивер", "телефон", "телефон ресивері"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("telefonrør"),
            keywords: &["kommunikation", "telefonrør"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ដៃទ\u{17bc}រស\u{17d0}ព\u{17d2}ទ"),
            keywords: &[
                "ដៃទ\u{17bc}រស\u{17d0}ព\u{17d2}ទ",
                "ទ\u{17bc}រសព\u{17d2}ទ",
                "ទ\u{17bc}រស\u{17d0}ព\u{17d2}ទ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಫೋನ\u{ccd}\u{200c} ರ\u{cbf}ಸೀವರ\u{ccd}\u{200c}"),
            keywords: &["ದ\u{cc2}ರವಾಣ\u{cbf}", "ಫೋನ\u{ccd}", "ರ\u{cbf}ಸೀವರ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("수화기"),
            keywords: &["수화기", "전화"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ट\u{947}लिफोन रिसिव\u{94d}हर"),
            keywords: &["ट\u{947}लिफोन", "फोन", "रिसिव\u{94d}हर"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("телефон трубкасы"),
            keywords: &["телефон", "телефон трубкасы", "трубка"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Telefonshörer"),
            keywords: &["Hörer", "Telefon", "Telefonshörer"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{eb9}ໂທລະສ\u{eb1}ບ"),
            keywords: &[
                "ຫ\u{eb9}ໂທລະສ\u{eb1}ບ",
                "ເຄ\u{eb7}\u{ec8}ອງຮ\u{eb1}ບ",
                "ໂທລະສ\u{eb1}ບ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("telefono ragelis"),
            keywords: &["ragelis", "telefonas", "telefono ragelis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("tālruņa klausule"),
            keywords: &["klausule", "telefons", "tālrunis", "tālruņa klausule"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pūwhiwhi waea"),
            keywords: &["pūwhiwhi", "waea"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("телефонска слушалка"),
            keywords: &["слушалка", "телефон", "телефонска слушалка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ടെലിഫോൺ റിസീവർ"),
            keywords: &["ടെലിഫോൺ", "ഫോൺ", "മൊബൈൽ", "റിസീവർ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("утасны харилцуур"),
            keywords: &["утас", "утасны харилцуур", "хүлээн авагч"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ट\u{947}लिफोनचा रिसीव\u{94d}हर"),
            keywords: &[
                "ट\u{947}लिफोन",
                "ट\u{947}लिफोनचा रिसीव\u{94d}हर",
                "फोन",
                "रिसीव\u{94d}हर",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("gagang telefon"),
            keywords: &["gagang telefon", "penerima", "telefon"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("riċevitur tat-telefon"),
            keywords: &["riċevitur", "riċevitur tat-telefon", "telefon"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "တယ\u{103a}လ\u{102e}ဖ\u{102f}န\u{103a}း အသ\u{1036}ဖမ\u{103a}းခ\u{103d}က\u{103a}",
            ),
            keywords: &[
                "တယ\u{103a}လ\u{102e}ဖ\u{102f}န\u{103a}း",
                "တယ\u{103a}လ\u{102e}ဖ\u{102f}န\u{103a}း အသ\u{1036}ဖမ\u{103a}းခ\u{103d}က\u{103a}",
                "ဖ\u{102f}န\u{103a}း",
                "ဖ\u{102f}န\u{103a}းစကားပြောခ\u{103d}က\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("telefonrør"),
            keywords: &["kommunikasjon", "telefon", "telefonrør"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ट\u{947}लिफोन रिसिभर"),
            keywords: &["ट\u{947}लिफोन", "फोन", "रिसिभर"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("telefoonhoorn"),
            keywords: &["hoorn", "telefoon", "telefoonhoorn"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("telefonrøyr"),
            keywords: &["kommunikasjon", "telefon", "telefonrøyr"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଟେଲ\u{b3f}ଫୋନ\u{b4d}\u{200c} ର\u{b3f}ସ\u{b3f}ଭର\u{b4d}\u{200c}"),
            keywords: &[
                "ଗ\u{b4d}ରହଣକ\u{b3e}ରୀ",
                "ଟେଲ\u{b3f}ଫୋନ\u{b4d}\u{200c}",
                "ଟେଲ\u{b3f}ଫୋନ\u{b4d}\u{200c} ର\u{b3f}ସ\u{b3f}ଭର\u{b4d}\u{200c}",
                "ଫୋନ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਟ\u{a48}ਲੀਫ\u{a3c}\u{a4b}ਨ ਰਿਸੀਵਰ"),
            keywords: &[
                "ਟ\u{a47}ਲੀਫ\u{a4b}ਨ",
                "ਟ\u{a48}ਲੀਫ\u{a3c}\u{a4b}ਨ ਰਿਸੀਵਰ",
                "ਫ\u{a4b}ਨ",
                "ਫ\u{a4b}ਨ ਰਸੀਵਰ",
                "ਸ\u{a70}ਚਾਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ٹیلی فون دا ریسیور"),
            keywords: &["فون", "وصول کنندہ", "ٹیلی فون", "ٹیلی فون دا ریسیور"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tẹlífón Risíva"),
            keywords: &["Fon", "Risíva", "Tẹlífon", "Tẹlífón Risíva"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("słuchawka telefoniczna"),
            keywords: &["słuchawka", "słuchawka telefoniczna", "telefon"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د ټیلیفون رسیور"),
            keywords: &["د ټیلیفون رسیور", "رسيور", "فون", "ټيليفون"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("telefone"),
            keywords: &["aparelho de telefone", "comunicação", "telefone"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("auscultador de telefone"),
            keywords: &["auscultador", "auscultador de telefone", "telefone"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("auricular telefonomanta"),
            keywords: &["auricular telefonomanta"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("receptor de telefon"),
            keywords: &["receptor", "receptor de telefon", "telefon"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-667"),
            keywords: &["E10-667"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("телефонная трубка"),
            keywords: &["телефон", "телефонная трубка", "трубка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("inyakira ya telefoni"),
            keywords: &["inyakira", "inyakira ya telefoni", "telefoni"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٽيليفون جو رسيور"),
            keywords: &["رسيور", "فون", "ٽيليفون", "ٽيليفون جو رسيور"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ද\u{dd4}රකථන ග\u{dca}\u{200d}ර\u{dcf}හකය"),
            keywords: &[
                "ග\u{dca}\u{200d}ර\u{dcf}හකය",
                "ද\u{dd4}රකථන ග\u{dca}\u{200d}ර\u{dcf}හකය",
                "ද\u{dd4}රකථනය",
                "ෆෝන\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("slúchadlo telefónu"),
            keywords: &["slúchadlo", "slúchadlo telefónu", "telefón"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("telefonska slušalka"),
            keywords: &["sprejemnik", "telefon", "telefonska slušalka"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gacanta telefoonka"),
            keywords: &["foon", "gacan", "gacanta telefoonka", "telefoon"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("receptor telefoni"),
            keywords: &["receptor", "receptor telefoni", "telefon"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("телефонска слушалица"),
            keywords: &["слушалица", "телефон", "телефонска слушалица"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["телефонска слушалица"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("telefonska slušalica"),
            keywords: &["slušalica", "telefon", "telefonska slušalica"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["telefonska slušalica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("telefonlur"),
            keywords: &["kommunikation", "telefon", "telefonlur"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mkono wa simu"),
            keywords: &["mkono wa simu", "simu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("டெலிபோன\u{bcd} ரிச\u{bc0}வர\u{bcd}"),
            keywords: &[
                "டெலிபோன\u{bcd}",
                "தொடர\u{bcd}புகொள\u{bcd}",
                "தொலைபேசி",
                "ரிச\u{bc0}வர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ట\u{c46}ల\u{c3f}ఫ\u{c4b}న\u{c4d} ర\u{c3f}స\u{c40}వర\u{c4d}"),
            keywords: &[
                "ట\u{c46}ల\u{c3f}ఫ\u{c4b}న\u{c4d} ర\u{c3f}స\u{c40}వర\u{c4d}",
                "ట\u{c46}ల\u{c40}ఫ\u{c4b}న\u{c4d}",
                "ఫ\u{c4b}న\u{c4d}",
                "ర\u{c3f}స\u{c40}వర\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("гӯшаки телефон"),
            keywords: &["гӯшаки телефон", "телефон"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ห\u{e39}โทรศ\u{e31}พท\u{e4c}"),
            keywords: &[
                "ห\u{e39}โทรศ\u{e31}พท\u{e4c}",
                "เคร\u{e37}\u{e48}องร\u{e31}บ",
                "โทรศ\u{e31}พท\u{e4c}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("trubka"),
            keywords: &["alyjy", "telefon", "trubka"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻa fakaongo telefoni"),
            keywords: &["meʻa fakaongo telefoni"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ahize"),
            keywords: &["ahize", "alıcı", "telefon"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تېلېفون ئالغۇچ"),
            keywords: &["ئالغۇچ", "تېلېفون", "فون"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("телефонна слухавка"),
            keywords: &["слухавка", "телефон", "телефонна слухавка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ٹیلیفون کا ریسیور"),
            keywords: &["برقی آلہ", "ریسیور", "فون", "ٹیلیفون کا ریسیور"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("telefon go‘shagi"),
            keywords: &[
                "qabul qiluvchi",
                "telefon",
                "telefon go‘shagi",
                "uy telefoni",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ống nghe điện thoại bàn"),
            keywords: &["điện thoại", "ống nghe", "ống nghe điện thoại bàn"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kombine telefon"),
            keywords: &["kombine", "telefon"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umqheba wefowuni"),
            keywords: &["ifowuni", "umqheba", "umqheba wefowuni"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("olùgbà fóònù"),
            keywords: &["fóònù", "olùgbà", "tẹlifóònù"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("接聽電話嘅人"),
            keywords: &["手機", "接聽電話嘅人", "聽電話嘅人", "電話"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("接听电话嘅人"),
            keywords: &["听电话嘅人", "手机", "接听电话嘅人", "电话"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("电话听筒"),
            keywords: &["固定电话", "固话", "座机", "电话", "电话听筒"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("聽筒"),
            keywords: &["聽筒", "電話"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("電話筒"),
            keywords: &["電話筒", "電話筒｜電話"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ithelefoni"),
            keywords: &["ifoni", "ithelefoni", "ukwamukela"],
        },
    ],
};
#[doc = "📟"]
pub const PAGER: crate::Emoji = crate::Emoji {
    glyph: "📟",
    codepoint: "1F4DF",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "pager",
    group: "Objects",
    subgroup: "phone",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("roeper"),
            keywords: &["roeper"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወረቀት"),
            keywords: &["ወረቀት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("جهاز نداء آلي"),
            keywords: &["تواصل", "جهاز نداء آلي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("পে’জ\u{9be}ৰ"),
            keywords: &["পে’জ\u{9be}ৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("peycer"),
            keywords: &["peycer"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("пэйджар"),
            keywords: &["паведамленне", "пэйджар", "радок"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("пейджър"),
            keywords: &["пейджър"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("পেজ\u{9be}র"),
            keywords: &["পেজ\u{9be}র"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("galver"),
            keywords: &["galver"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("pejdžer"),
            keywords: &["pejdžer"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("buscapersones"),
            keywords: &["buscapersones", "cercapersones"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏓᏯᏂ"),
            keywords: &["ᎠᏓᏯᏂ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("pager"),
            keywords: &["pager"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("peiriant galw"),
            keywords: &["galwr", "peiriant galw"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("personsøger"),
            keywords: &["bipper", "kommunikation", "personsøger"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Pager"),
            keywords: &["Pager"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("βομβητής"),
            keywords: &["βομβητής"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("pager"),
            keywords: &["pager"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("busca"),
            keywords: &["busca", "comunicación", "localizador"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("buscapersonas"),
            keywords: &["buscapersonas", "comunicación"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("bíper"),
            keywords: &["bíper"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["buscapersonas", "pager"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("piipar"),
            keywords: &["peiler", "piipar"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bilagailua"),
            keywords: &["bilagailu", "bilagailua"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پیجر"),
            keywords: &["پیج کردن", "پیجر", "پی\u{200c}جو"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hakulaite"),
            keywords: &["hakulaite"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pager"),
            keywords: &["device", "pager"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("persónleitari"),
            keywords: &["persónleitari"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bipeur"),
            keywords: &["bipeur", "pager"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("téléavertisseur"),
            keywords: &["pager", "téléavertisseur"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("glaoire"),
            keywords: &["cumarsáid", "glaoire"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("pèidsear"),
            keywords: &["pèidsear"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("buscapersoas"),
            keywords: &["busca", "buscapersoas", "localizador", "mensáfono"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{ac7}જર"),
            keywords: &["પ\u{ac7}જર", "સ\u{a82}ચાર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("na’urar faɗakarwa"),
            keywords: &["na’urar faɗakarwa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("איתורית"),
            keywords: &["איתורית", "ביפר", "זימונית"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{947}जर"),
            keywords: &["प\u{947}जर", "स\u{902}चार"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("dojavljivač"),
            keywords: &["dojavljivač", "pager"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("személyhívó"),
            keywords: &["személyhívó"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("փեյջեր"),
            keywords: &["փեյջեր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pager"),
            keywords: &["pager"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ozi ekwentị"),
            keywords: &["ozi ekwentị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("símboði"),
            keywords: &["samskipti", "símboði"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cercapersone"),
            keywords: &["cercapersone", "comunicazione"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ポケベル"),
            keywords: &["ページャー", "ポケットベル", "ポケベル"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("penyeranta"),
            keywords: &["penyeranta"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("პეიჯერი"),
            keywords: &["პეიჯერი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("пейджер"),
            keywords: &["пейджер"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("personsøger"),
            keywords: &["bipper", "kommunikation", "personsøger"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ឧបករណ\u{17cd}ប\u{17d2}រាប\u{17cb}ដ\u{17c6}ណ\u{17b9}ង"),
            keywords: &[
                "ប\u{17d2}រាប\u{17cb}ដ\u{17c6}ណ\u{17b9}ង",
                "ឧបករណ\u{17cd}",
                "ឧបករណ\u{17cd}ប\u{17d2}រាប\u{17cb}ដ\u{17c6}ណ\u{17b9}ង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪೇಜರ\u{ccd}"),
            keywords: &["ಪೇಜರ\u{ccd}", "ಫೋನ\u{ccd}", "ಸಂವಹನ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("삐삐"),
            keywords: &["삐삐", "호출기"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("प\u{947}जर"),
            keywords: &["प\u{947}जर"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("пейджер"),
            keywords: &["пейджер", "пейжер"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Pager"),
            keywords: &["Pager"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຄ\u{eb7}\u{ec8}ອງເພກເຈ\u{eb5}"),
            keywords: &["ເຄ\u{eb7}\u{ec8}ອງເພກເຈ\u{eb5}", "ເພກເຈ\u{eb5}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("gaviklis"),
            keywords: &["gaviklis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("peidžers"),
            keywords: &["peidžers"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pūoho"),
            keywords: &["pūoho"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("пејџер"),
            keywords: &["пејџер"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പേജർ"),
            keywords: &["ആശയവിനിമയം", "പേജർ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("пейжер"),
            keywords: &["пейжер"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{947}जर"),
            keywords: &["प\u{947}जर"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("alat kelui"),
            keywords: &["alat kelui"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("pejġer"),
            keywords: &["pejġer"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပေဂျာ"),
            keywords: &["ပေဂျာ"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("personsøker"),
            keywords: &["kommunikasjon", "personsøker", "telefon"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{947}जर"),
            keywords: &["प\u{947}जर"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("pager"),
            keywords: &["pager"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("personsøkjar"),
            keywords: &["kommunikasjon", "personsøkjar", "telefon"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପେଜର\u{b4d}\u{200c}"),
            keywords: &["ପେଜର\u{b4d}\u{200c}", "ଯୋଗ\u{b3e}ଯୋଗ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a47}ਜਰ"),
            keywords: &["ਪ\u{a47}ਜਰ", "ਸ\u{a70}ਚਾਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پيجر"),
            keywords: &["پيجر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bípa"),
            keywords: &["Bípa"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pager"),
            keywords: &["pager"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پیجر"),
            keywords: &["پیجر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pager"),
            keywords: &["comunicação", "pager"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tariq"),
            keywords: &["tariq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pager"),
            keywords: &["comunicare", "dispozitiv", "pager"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-668"),
            keywords: &["E10-668"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("пейджер"),
            keywords: &["пейджер", "сообщение", "строка", "экран"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("pajeri"),
            keywords: &["pajeri"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پيجر"),
            keywords: &["پيجر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පේජරය"),
            keywords: &["පේජරය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("pejdžer"),
            keywords: &["pager", "pejdžer"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("pozivnik"),
            keywords: &["pozivnik"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("ogeysiiye"),
            keywords: &["ogeysiiye"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("biper"),
            keywords: &["biper"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("пејџер"),
            keywords: &["пејџер"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("pejdžer"),
            keywords: &["pejdžer"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("personsökare"),
            keywords: &["kommunikation", "personsökare"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("peja"),
            keywords: &["peja"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பேஜர\u{bcd}"),
            keywords: &["பேஜர\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c47}జర\u{c4d}"),
            keywords: &["ప\u{c47}జర\u{c4d}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("пейҷер"),
            keywords: &["пейҷер"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เพจเจอร\u{e4c}"),
            keywords: &["เพจเจอร\u{e4c}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("peýjer"),
            keywords: &["peýjer"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("foni kikī"),
            keywords: &["foni kikī"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("çağrı cihazı"),
            keywords: &["iletişim", "çağrı cihazı"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چاقىرغۇ"),
            keywords: &["چاقىرغۇ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("пейджер"),
            keywords: &["пейджер"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پیجر"),
            keywords: &["برقی آلہ", "پیجر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("peyjer"),
            keywords: &["peyjer"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("máy nhắn tin"),
            keywords: &["máy nhắn tin"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bipër"),
            keywords: &["bipër"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ipheyija"),
            keywords: &["ipheyija"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ẹ\u{300}rọ atanilólobó"),
            keywords: &["ẹ\u{300}rọ atanilólobó"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("傳呼機"),
            keywords: &["傳呼機"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("传呼机"),
            keywords: &["传呼机"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("寻呼机"),
            keywords: &["BB 机", "传呼机", "呼机", "寻呼机"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("呼叫器"),
            keywords: &["BB call", "呼叫器"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("傳呼機"),
            keywords: &["傳呼機", "傳呼機｜Call機"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ipheja"),
            keywords: &["ipheja"],
        },
    ],
};
#[doc = "📠"]
pub const FAX_MACHINE: crate::Emoji = crate::Emoji {
    glyph: "📠",
    codepoint: "1F4E0",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "fax machine",
    group: "Objects",
    subgroup: "phone",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("faksmasjien"),
            keywords: &["faks", "faksmasjien", "masjien"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ፋክስ ማሽን"),
            keywords: &["ፋክስ", "ፋክስ ማሽን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("فاكس"),
            keywords: &["تواصل", "فاكس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ফেক\u{9cd}স মেচিন"),
            keywords: &["ফেক\u{9cd}স", "ফেক\u{9cd}স মেচিন"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("faks aparatı"),
            keywords: &["faks", "faks aparatı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("факсімільны апарат"),
            keywords: &["факс", "факсімільны апарат"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("факс"),
            keywords: &["факс"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ফ\u{9cd}য\u{9be}ক\u{9cd}স মেশিন"),
            keywords: &[
                "ফ\u{9cd}য\u{9be}ক\u{9cd}স",
                "ফ\u{9cd}য\u{9be}ক\u{9cd}স মেশিন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pelleiler"),
            keywords: &["fax", "pelleiler"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("faks"),
            keywords: &["faks", "faks uređaj"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("fax"),
            keywords: &["fax"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄜\u{11133}𑄠𑄇\u{11134}𑄌\u{11134} 𑄟\u{11128}𑄥\u{11128}𑄚\u{11134}"),
            keywords: &["𑄜\u{11133}𑄠𑄇\u{11134}𑄌\u{11134} 𑄟\u{11128}𑄥\u{11128}𑄚\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᏟᎶᏍᏔᏅ ᎪᏪᎵ ᏫᎦᏅᎥᏍᎩ"),
            keywords: &["ᏗᏟᎶᏍᏔᏅ ᎪᏪᎵ", "ᏗᏟᎶᏍᏔᏅ ᎪᏪᎵ ᏫᎦᏅᎥᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("fax"),
            keywords: &["fax", "telefax"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("peiriant ffacs"),
            keywords: &["ffacs", "peiriant ffacs"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("fax"),
            keywords: &["fax", "faxmaskine", "kommunikation", "telefax"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Faxgerät"),
            keywords: &["Fax", "Faxgerät"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("συσκευή φαξ"),
            keywords: &["συσκευή φαξ", "φαξ"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("fax machine"),
            keywords: &["fax", "fax machine"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["facsimile", "fax", "fax machine"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("máquina de fax"),
            keywords: &["comunicación", "fax", "máquina de fax"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["comunicación", "fax", "máquina de fax"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("faksimasin"),
            keywords: &["faks", "faksimasin", "masin"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("faxa"),
            keywords: &["fax", "faxa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دستگاه نمابر"),
            keywords: &["دستگاه فاکس", "دستگاه نمابر", "دورنگار", "فاکس", "نمابر"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("faksi"),
            keywords: &["faksi", "faksilaite"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("fax machine"),
            keywords: &["fax", "fax machine"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("telefaks"),
            keywords: &["faks", "telefaks"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("fax"),
            keywords: &["fax", "télécopieur"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("télécopieur"),
            keywords: &["fax", "télécopieur"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("meaisín facsála"),
            keywords: &["facs", "meaisín facs", "meaisín facsála"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("inneal facs"),
            keywords: &["facs", "inneal facs"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("fax"),
            keywords: &["fax", "telefax"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ફ\u{ac5}ક\u{acd}સ મશીન"),
            keywords: &["ફ\u{ac5}ક\u{acd}સ", "ફ\u{ac5}ક\u{acd}સ મશીન", "સ\u{a82}ચાર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("injin faks"),
            keywords: &["faks", "injin faks"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מכשיר פקס"),
            keywords: &["מכשיר פקס", "פקס"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("फ\u{93c}\u{948}क\u{94d}स मशीन"),
            keywords: &["फ\u{93c}\u{948}क\u{94d}स", "फ\u{93c}\u{948}क\u{94d}स मशीन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("faks"),
            keywords: &["faks", "telefaks"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("faxkészülék"),
            keywords: &["fax", "faxkészülék"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ֆաքսի մեքենա"),
            keywords: &["ֆաքս", "ֆաքսի մեքենա"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("mesin faks"),
            keywords: &["faksimili", "mesin faks"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("igwe ozi faasị"),
            keywords: &["faasị", "igwe ozi faasị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fax"),
            keywords: &["bréfsími", "fax", "samskipti"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("fax"),
            keywords: &["comunicazione", "fax"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ファックス"),
            keywords: &["FAX", "ファックス", "複合機", "電話"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("mesin faks"),
            keywords: &["faks", "mesin faks"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ფაქსი"),
            keywords: &["ფაქსი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("факс машина"),
            keywords: &["факс", "факс машина"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("fax"),
            keywords: &["fax", "faxmaskine", "kommunikation"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17c9}ាស\u{17ca}\u{17b8}នហ\u{17d2}វាក\u{17cb}"),
            keywords: &[
                "ម\u{17c9}ាស\u{17ca}\u{17b8}ន",
                "ម\u{17c9}ាស\u{17ca}\u{17b8}នហ\u{17d2}វាក\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಫ\u{ccd}ಯಾಕ\u{ccd}ಸ\u{ccd} ಯಂತ\u{ccd}ರ"),
            keywords: &["ಫ\u{ccd}ಯಾಕ\u{ccd}ಸ\u{ccd} ಯಂತ\u{ccd}ರ", "ಸಂವಹನ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("팩스"),
            keywords: &["팩스", "팩스기", "팩시밀리"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("फ\u{945}क\u{94d}स मशीन"),
            keywords: &["फ\u{945}क\u{94d}स", "फ\u{945}क\u{94d}स मशीन"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("факс машинасы"),
            keywords: &["факс", "факс машинасы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Fax"),
            keywords: &["Fax"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຄ\u{eb7}\u{ec8}ອງຮ\u{eb1}ບສ\u{ebb}\u{ec8}ງແຟ\u{eb1}ກ"),
            keywords: &[
                "ເຄ\u{eb7}\u{ec8}ອງຮ\u{eb1}ບສ\u{ebb}\u{ec8}ງແຟ\u{eb1}ກ",
                "ແຟ\u{eb1}ກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("fakso aparatas"),
            keywords: &["faksas", "fakso aparatas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("fakss"),
            keywords: &["faksa aparāts", "fakss"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("mīhini waeatuhi"),
            keywords: &["mīhini waeatuhi", "waeatuhi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("факс"),
            keywords: &["факс"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഫ\u{d3e}ക\u{d4d}\u{200c}സ\u{d4d} മെഷീൻ"),
            keywords: &[
                "ആശയവിനിമയം",
                "ഫ\u{d3e}ക\u{d4d}സ\u{d4d}",
                "ഫ\u{d3e}ക\u{d4d}\u{200c}സ\u{d4d} മെഷീൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("факсын машин"),
            keywords: &["факс", "факсын машин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("फ\u{945}क\u{94d}स मशीन"),
            keywords: &["फ\u{945}क\u{94d}स", "फ\u{945}क\u{94d}स मशीन"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("mesin faksimili"),
            keywords: &["faks", "mesin faksimili"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("magna tal-fax"),
            keywords: &["fax", "magna tal-fax"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဖက\u{103a}စ\u{103a} စာပ\u{102d}\u{102f}\u{1037}စက\u{103a}"),
            keywords: &[
                "ဖက\u{103a}စ\u{103a}",
                "ဖက\u{103a}စ\u{103a} စာပ\u{102d}\u{102f}\u{1037}စက\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("faksmaskin"),
            keywords: &["faksmaskin", "kommunikasjon", "telefon"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("फ\u{94d}याक\u{94d}स म\u{947}सिन"),
            keywords: &["फ\u{94d}याक\u{94d}स", "फ\u{94d}याक\u{94d}स म\u{947}सिन"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("fax"),
            keywords: &["fax", "faxapparaat"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("faksmaskin"),
            keywords: &["faksmaskin", "kommunikasjon", "telefon"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଫ\u{b4d}ୟ\u{b3e}କ\u{b4d}ସ ମେସ\u{b3f}ନ\u{b4d}\u{200c}"),
            keywords: &[
                "ଫ\u{b4d}ୟ\u{b3e}କ\u{b4d}ସ",
                "ଫ\u{b4d}ୟ\u{b3e}କ\u{b4d}ସ ମେସ\u{b3f}ନ\u{b4d}\u{200c}",
                "ଯୋଗ\u{b3e}ଯୋଗ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਫ\u{a48}ਕਸ ਮਸ\u{a3c}ੀਨ"),
            keywords: &["ਫ\u{a48}ਕਸ", "ਫ\u{a48}ਕਸ ਮਸ\u{a3c}ੀਨ", "ਸ\u{a70}\u{a70}ਚਾਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("فیکس مشین"),
            keywords: &["فیکس", "فیکس مشین"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fáks Mashin"),
            keywords: &["Faks", "Fáks Mashin"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("faks"),
            keywords: &["faks"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د فکس ماشین"),
            keywords: &["د فکس ماشين", "د فکس ماشین", "فکس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("fax"),
            keywords: &["comunicação", "fax", "máquina de fax"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("maquina faxpaq"),
            keywords: &["maquina faxpaq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("echipament fax"),
            keywords: &["comunicare", "dispozitiv", "echipament fax", "fax"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-669"),
            keywords: &["E10-669"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("факс"),
            keywords: &["бумага", "сообщение", "факс"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("imashini ya fagisi"),
            keywords: &["fagisi", "imashini ya fagisi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("فيڪس مشين"),
            keywords: &["فيڪس", "فيڪس مشين"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ෆැක\u{dca}ස\u{dca} යන\u{dca}ත\u{dca}\u{200d}රය"),
            keywords: &[
                "ෆැක\u{dca}ස\u{dca}",
                "ෆැක\u{dca}ස\u{dca} යන\u{dca}ත\u{dca}\u{200d}රය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("fax"),
            keywords: &["fax", "telefax"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("telefaks"),
            keywords: &["faks", "telefaks"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("mishiinka fakiska"),
            keywords: &["fakis", "mishiinka fakiska"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("faks"),
            keywords: &["faks"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("факс"),
            keywords: &["факс"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("faks"),
            keywords: &["faks"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("fax"),
            keywords: &["fax", "kommunikation"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mashine ya faksi"),
            keywords: &["faksi", "mashine ya faksi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பேக\u{bcd}ஸ\u{bcd}"),
            keywords: &[
                "தொடர\u{bcd}புகொள\u{bcd}",
                "தொலைநகல\u{bcd}",
                "பேக\u{bcd}ஸ\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఫ\u{c4d}య\u{c3e}క\u{c4d}స\u{c4d} మ\u{c46}ష\u{c40}న\u{c4d}"),
            keywords: &[
                "ఫ\u{c4d}య\u{c3e}క\u{c4d}స\u{c4d}",
                "ఫ\u{c4d}య\u{c3e}క\u{c4d}స\u{c4d} మ\u{c46}ష\u{c40}న\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дастгоҳи факс"),
            keywords: &["дастгоҳи факс", "факс"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แฟกซ\u{e4c}"),
            keywords: &["เคร\u{e37}\u{e48}องแฟกซ\u{e4c}", "แฟกซ\u{e4c}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("faks apparaty"),
            keywords: &["faks", "faks apparaty"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("foni tohi"),
            keywords: &["foni tohi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("faks makinesi"),
            keywords: &["faks makinesi", "iletişim"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("فاكسچى"),
            keywords: &["فاكس", "فاكسچى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("факс"),
            keywords: &["факс"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("فیکس مشین"),
            keywords: &["برقی آلہ", "فیکس", "فیکس مشین"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("faks apparati"),
            keywords: &["faks", "faks apparati"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("máy fax"),
            keywords: &["máy fax"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("faks"),
            keywords: &["faks", "fakse"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umatshani wefeksi"),
            keywords: &["ifeksi", "umatshani wefeksi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ẹ\u{300}rọ fákìsì"),
            keywords: &["fákìsì", "ẹ\u{300}rọ fákìsì"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("傳真機"),
            keywords: &["傳真", "傳真機"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("传真机"),
            keywords: &["传真", "传真机"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("传真机"),
            keywords: &["传真", "传真号", "传真机", "发传真"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("傳真機"),
            keywords: &["FAX", "傳真機"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umshini wefeksi"),
            keywords: &["ifeksi", "umshini wefeksi"],
        },
    ],
};
