#[doc = "💼"]
pub const BRIEFCASE: crate::Emoji = crate::Emoji {
    glyph: "💼",
    codepoint: "1F4BC",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "briefcase",
    group: "Objects",
    subgroup: "office",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("aktetas"),
            keywords: &["aktetas", "dokumente", "tas", "werk"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቦርሳ"),
            keywords: &["ቦርሳ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("حقيبة كتب"),
            keywords: &["حقيبة", "حقيبة كتب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ব\u{9cd}ৰীফকেছ"),
            keywords: &["ব\u{9cd}ৰীফকেছ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("çemodan"),
            keywords: &["çemodan"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("партфель"),
            keywords: &["дакументы", "паперы", "партфель"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("чанта за документи"),
            keywords: &["чанта за документи"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9cd}রিফকেস"),
            keywords: &["ব\u{9cd}রিফকেস"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("sakochenn"),
            keywords: &["sakochenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("aktovka"),
            keywords: &["aktovka"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("maletí"),
            keywords: &["maletí"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏅᏔᏅᏙᏗ"),
            keywords: &["ᎦᏅᏔᏅᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kufřík"),
            keywords: &["aktovka", "kufřík"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cas friff"),
            keywords: &["cas friff"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("attachémappe"),
            keywords: &["attachémappe", "mappe"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Aktentasche"),
            keywords: &["Aktentasche", "Tasche"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("χαρτοφύλακας"),
            keywords: &["χαρτοφύλακας"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("briefcase"),
            keywords: &["briefcase"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("maletín"),
            keywords: &["cartera", "documentos", "maletín"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["bolso de hombre", "maletín", "portafolio"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("portfell"),
            keywords: &["kohver", "portfell"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("maleta"),
            keywords: &["maleta"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کیف اسناد"),
            keywords: &["سامسونت", "کیف اسناد"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("salkku"),
            keywords: &["salkku"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("briefcase"),
            keywords: &["attache case", "briefcase"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("skjalamappa"),
            keywords: &["mappa", "skjalamappa", "taska"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("porte-documents"),
            keywords: &["porte-documents"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("mála cáipéisí"),
            keywords: &["mála cáipéisí"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("màileid-oifise"),
            keywords: &["màileid", "màileid-oifise"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("maletín"),
            keywords: &["documentos", "maletín", "oficina"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બ\u{acd}રીફક\u{ac7}સ"),
            keywords: &["બ\u{acd}રીફક\u{ac7}સ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("jakar hannu"),
            keywords: &["jakar hannu"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("תיק מסמכים"),
            keywords: &["מזוודה", "מסמכים", "תיק"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ब\u{94d}रीफ\u{93c}क\u{947}स"),
            keywords: &["ब\u{94d}रीफ\u{93c}क\u{947}स", "स\u{942}टक\u{947}स"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("aktovka"),
            keywords: &["aktovka"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("aktatáska"),
            keywords: &["aktatáska"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("պորտֆել"),
            keywords: &["պորտֆել"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tas kantor"),
            keywords: &["tas kantor"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("igbe mpanaka"),
            keywords: &["igbe mpanaka"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("skjalataska"),
            keywords: &["skjalataska", "taska"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("valigetta 24 ore"),
            keywords: &[
                "24 ore",
                "documenti",
                "ufficio",
                "valigetta",
                "valigetta 24 ore",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ブリーフケース"),
            keywords: &["かばん", "ブリーフケース"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tas koper"),
            keywords: &["tas koper"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("პორტფელი"),
            keywords: &["ბრიფკეისი", "პორტფელი", "ჩანთა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("портфель"),
            keywords: &["портфель"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("attachémappe"),
            keywords: &["attachémappe", "mappe"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កាប\u{17bc}បយ\u{17bd}សម\u{17d2}រាប\u{17cb}អ\u{17d2}នកធ\u{17d2}វើការ"),
            keywords: &[
                "កាប\u{17bc}បយ\u{17bd}រ",
                "កាប\u{17bc}បយ\u{17bd}សម\u{17d2}រាប\u{17cb}អ\u{17d2}នកធ\u{17d2}វើការ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{ccd}ರೀಫ\u{ccd}\u{200c}ಕೇಸ\u{ccd}"),
            keywords: &[
                "ಬ\u{ccd}ರೀಫ\u{ccd}\u{200c}ಕೇಸ\u{ccd}",
                "ಸ\u{cc2}ಟ\u{ccd}\u{200c}ಕೇಸ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("서류 가방"),
            keywords: &["가방", "서류 가방"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ब\u{94d}रिफक\u{947}स"),
            keywords: &["ब\u{94d}रिफक\u{947}स"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("портфель"),
            keywords: &["портфель"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Aktekoffer"),
            keywords: &["Aktekoffer"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກະເປ\u{ebb}\u{ec8}າເອກະສານ"),
            keywords: &[
                "ກະເປ\u{ebb}\u{ec8}າ",
                "ກະເປ\u{ebb}\u{ec8}າເອກະສານ",
                "ເອກະສານ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("portfelis"),
            keywords: &["portfelis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("portfelis"),
            keywords: &["portfelis", "soma"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kopamārō"),
            keywords: &["kopamārō"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("актовка"),
            keywords: &["актовка", "чанта"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ബ\u{d4d}രീഫ\u{d4d}\u{200c}കേസ\u{d4d}"),
            keywords: &["ബ\u{d4d}രീഫ\u{d4d}\u{200c}കേസ\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ажил хэргийн цүнх"),
            keywords: &["ажил хэргийн цүнх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ब\u{94d}रिफक\u{947}स"),
            keywords: &["ब\u{94d}रिफक\u{947}स", "ब\u{94d}रीफक\u{947}स"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("beg bimbit"),
            keywords: &["beg bimbit"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("briefcase"),
            keywords: &["briefcase"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ရ\u{102f}\u{1036}းသ\u{102f}\u{1036}းလက\u{103a}ဆ\u{103d}\u{1032}အ\u{102d}တ\u{103a}",
            ),
            keywords: &[
                "ရ\u{102f}\u{1036}း",
                "ရ\u{102f}\u{1036}းသ\u{102f}\u{1036}းလက\u{103a}ဆ\u{103d}\u{1032}အ\u{102d}တ\u{103a}",
                "လက\u{103a}ဆ\u{103d}\u{1032}အ\u{102d}တ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("dokumentmappe"),
            keywords: &["dokumentmappe", "stresskoffert"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ब\u{94d}रिफक\u{947}स"),
            keywords: &["ब\u{94d}रिफक\u{947}स"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("aktentas"),
            keywords: &["aktentas"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("dokumentmappe"),
            keywords: &["dokumentmappe", "stresskoffert"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b4d}ର\u{b3f}ଫ\u{b4d}\u{200c}କେସ\u{b4d}"),
            keywords: &[
                "ବ\u{b4d}ର\u{b3f}ଫକେସ\u{b4d}",
                "ବ\u{b4d}ର\u{b3f}ଫ\u{b4d}\u{200c}କେସ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਅਟ\u{a48}ਚੀ"),
            keywords: &["ਅਟ\u{a48}ਚੀ", "ਬਰੀਫਕ\u{a47}ਸ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بریف کیس"),
            keywords: &["بریف کیس"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Brífkes"),
            keywords: &["Brífkes"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("teczka"),
            keywords: &["aktówka", "neseser", "teczka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بسته"),
            keywords: &["بسته"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("maleta"),
            keywords: &["mala", "maleta", "pasta"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("servietă"),
            keywords: &["servietă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-633"),
            keywords: &["E10-633"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("портфель"),
            keywords: &["бумаги", "дипломат", "документы", "портфель"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("mutwaranyandiko"),
            keywords: &["mutwaranyandiko"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بريف ڪيس"),
            keywords: &["بريف ڪيس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ල\u{dd2}ප\u{dd2}පෙට\u{dca}ට\u{dd2}ය"),
            keywords: &["ල\u{dd2}ප\u{dd2}පෙට\u{dca}ට\u{dd2}ය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("aktovka"),
            keywords: &["aktovka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kovček"),
            keywords: &["aktovka", "kovček"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("shandad shaqo"),
            keywords: &["shandad shaqo"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("valixhe"),
            keywords: &["valixhe"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("торба"),
            keywords: &["торба"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("torba"),
            keywords: &["torba"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("portfölj"),
            keywords: &["portfölj", "väska"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mkoba"),
            keywords: &["mkoba"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சூட\u{bcd}கேஸ\u{bcd}"),
            keywords: &["சூட\u{bcd}கேஸ\u{bcd}", "பெட\u{bcd}டி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బ\u{c4d}ర\u{c40}ఫ\u{c4d} క\u{c47}స\u{c4d}"),
            keywords: &[
                "బ\u{c4d}ర\u{c40}ఫ\u{c4d} క\u{c47}స\u{c4d}",
                "సూట\u{c4d} క\u{c47}స\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҷузвгир"),
            keywords: &["ҷузвгир"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("กระเป\u{e4b}าเอกสาร"),
            keywords: &["กระเป\u{e4b}า", "กระเป\u{e4b}าเอกสาร", "เอกสาร"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("portfel"),
            keywords: &["portfel"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kato leta toʻotoʻo"),
            keywords: &["kato leta toʻotoʻo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("evrak çantası"),
            keywords: &["evrak çantası"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سومكا"),
            keywords: &["سومكا", "قول سومكا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кейс"),
            keywords: &["кейс", "портфель"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بریف کیس"),
            keywords: &["اسٹیشنری", "بریف کیس"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("portfel"),
            keywords: &["portfel", "sumka"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cặp tài liệu"),
            keywords: &["cặp tài liệu"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("waliis wu ndaw"),
            keywords: &["waliis wu ndaw"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibrifkheyisi"),
            keywords: &["ibrifkheyisi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àpamọ\u{301}wọ\u{301}"),
            keywords: &["àpamọ\u{301}wọ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("公事包"),
            keywords: &["公事包"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("公事包"),
            keywords: &["公事包"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("公文包"),
            keywords: &["公事包", "公文包", "包", "手提包"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("公事包"),
            keywords: &["公事包"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhrifukhesi"),
            keywords: &["ibhrifukhesi"],
        },
    ],
};
#[doc = "📁"]
pub const FILE_FOLDER: crate::Emoji = crate::Emoji {
    glyph: "📁",
    codepoint: "1F4C1",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "file folder",
    group: "Objects",
    subgroup: "office",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("lêervouer"),
            keywords: &["lêer", "lêervouer", "vouer"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የፋይል አቃፊ"),
            keywords: &["አቃፊ", "የፋይል አቃፊ", "ፋይል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مجلد ملفات"),
            keywords: &["مجلد", "مجلد ملفات", "ملف"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ফ\u{9be}ইল ফ’ল\u{9cd}ড\u{9be}ৰ"),
            keywords: &["ফ\u{9be}ইল", "ফ’ল\u{9cd}ড\u{9be}ৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("fayl qovluğu"),
            keywords: &["fayl", "fayl qovluğu", "qovluq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("папка для файлаў"),
            keywords: &["папка", "папка для файлаў", "файл"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("папка за документи"),
            keywords: &["папка", "папка за документи"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ফ\u{9be}ইল ফোল\u{9cd}ড\u{9be}র"),
            keywords: &["ফ\u{9be}ইল", "ফোল\u{9cd}ড\u{9be}র"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kleurenn"),
            keywords: &["kleurenn", "teuliad"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("fascikla"),
            keywords: &["fajl", "fascikla"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("carpeta de fitxers"),
            keywords: &[
                "arxius",
                "carpeta",
                "carpeta de fitxers",
                "carpeta d’arxius",
                "fitxers",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᏆᏂᎪᏙᏗ ᏗᏴᏈᏛᎥᏍᎩ"),
            keywords: &["ᎠᏍᏆᏂᎪᏙᏗ", "ᏗᏴᏈᏛᎥᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("složka"),
            keywords: &["dokumenty", "složka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ffolder ffeiliau"),
            keywords: &["ffeil", "ffolder", "ffolder ffeiliau"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mappe"),
            keywords: &["dokument", "mappe"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Ordner"),
            keywords: &["Dokument", "Ordner", "geschlossen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("φάκελος αρχείων"),
            keywords: &["αρχείο", "φάκελος", "φάκελος αρχείων"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("file folder"),
            keywords: &["file", "folder"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("carpeta de archivos"),
            keywords: &["archivo", "carpeta", "carpeta de archivos"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kaust"),
            keywords: &["dokument", "fail", "kaust"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("fitxategi-sailkatzailea"),
            keywords: &["fitxategi", "fitxategi-sailkatzailea", "sailkatzaile"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پوشه"),
            keywords: &["فایل", "پرونده", "پوشه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tiedostokansio"),
            keywords: &["kansio", "tiedosto", "tiedostokansio"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("file folder"),
            keywords: &["dokumento", "file", "folder"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("skjalalummi"),
            keywords: &[
                "faldari",
                "fíl",
                "lummi",
                "mappa",
                "skjalalummi",
                "skjalamappa",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("dossier"),
            keywords: &["dossier", "fichier"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("fillteán comhad"),
            keywords: &["comhad", "fillteán"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("pasgan faidhle"),
            keywords: &["faidhle", "pasgan"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cartafol"),
            keywords: &["carpeta", "cartafol", "documentos"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ફાઇલ ફોલ\u{acd}ડર"),
            keywords: &["ફાઇલ", "ફાઇલ ફોલ\u{acd}ડર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("foldar fayil"),
            keywords: &["fayil", "folda", "foldar fayil"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("תיקיית מסמכים"),
            keywords: &["מסמכים", "תיקייה", "תיקיית מסמכים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("फ\u{93c}ाइल फ\u{93c}ोल\u{94d}डर"),
            keywords: &["फ\u{93c}ाइल", "फ\u{93c}ोल\u{94d}डर"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("mapa"),
            keywords: &["mapa"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fájlmappa"),
            keywords: &["fájl", "fájlmappa", "mappa"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("թղթապանակ"),
            keywords: &["թղթապանակ", "ֆայլ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("folder file"),
            keywords: &["file", "folder"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("foldà faịlị\u{300}"),
            keywords: &["faịlụ", "foldà", "foldà faịlị\u{300}"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("skráamappa"),
            keywords: &["mappa", "skrá", "skráamappa"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cartella file"),
            keywords: &["cartella", "file"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("フォルダー"),
            keywords: &["ファイル", "フォルダー", "文具", "文房具"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("map berkas"),
            keywords: &["berkas", "map"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("საქაღალდე"),
            keywords: &["საქაღალდე", "ფაილი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("akaram n ufaylu"),
            keywords: &["akaram n ufaylu"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("файл қалтасы"),
            keywords: &["файл", "файл қалтасы", "қалта"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("mappe"),
            keywords: &["dokument", "mappe"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17ca}\u{17ba}ម\u{17c9}\u{17b8}ដាក\u{17cb}ឯកសារ"),
            keywords: &[
                "ថត",
                "ថតដាក\u{17cb}ឯកសារ",
                "ស\u{17ca}\u{17ba}ម\u{17c9}\u{17b8}ដាក\u{17cb}ឯកសារ",
                "ឯកសារ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಫೈಲ\u{ccd} ಫೋಲ\u{ccd}ಡರ\u{ccd}"),
            keywords: &["ಫೈಲ\u{ccd}", "ಫೋಲ\u{ccd}ಡರ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("폴더"),
            keywords: &["파일", "폴더"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("फायल फोल\u{94d}डर"),
            keywords: &["फायल", "फोल\u{94d}डर"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("файл куржуну"),
            keywords: &["куржун", "файл", "файл куржуну"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Fichiersdossier"),
            keywords: &["Dossier", "Fichier", "Fichiersdossier"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແຟ\u{ec9}ມເອກະສານ"),
            keywords: &["ເອກະສານ", "ແຟ\u{ec9}ມ", "ແຟ\u{ec9}ມເອກະສານ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("failų aplankas"),
            keywords: &["aplankas", "failas", "failų aplankas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("dokumentu mape"),
            keywords: &["dokuments", "dokumentu mape", "mape"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kōpaki kōnae"),
            keywords: &["kōnae", "kōpaki"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("папка"),
            keywords: &["документи", "папка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഫയൽ ഫോൾഡർ"),
            keywords: &["ഫയൽ", "ഫോൾഡർ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("файлын хавтас"),
            keywords: &["файл", "файлын хавтас"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("फाईल फोल\u{94d}डर"),
            keywords: &["फाइल", "फाईल फोल\u{94d}डर", "फोल\u{94d}डर"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("folder fail"),
            keywords: &["fail", "folder"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("fowlder tal-fajls"),
            keywords: &["fajl", "fowlder", "fowlder tal-fajls"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဖ\u{102d}\u{102f}င\u{103a}တ\u{103d}\u{1032}"),
            keywords: &[
                "ဖ\u{102d}\u{102f}င\u{103a}",
                "ဖ\u{102d}\u{102f}င\u{103a}တ\u{103d}\u{1032}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("arkivmappe"),
            keywords: &["arkiv", "arkivmappe", "fil", "mappe"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("फाइल फोल\u{94d}डर"),
            keywords: &["फाइल", "फोल\u{94d}डर"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bestandsmap"),
            keywords: &["bestand", "bestandsmap", "map"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("arkivmappe"),
            keywords: &["arkiv", "arkivmappe", "fil", "mappe"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଫ\u{b3e}ଇଲ\u{b4d}\u{200c} ଫୋଲ\u{b4d}ଡଋ"),
            keywords: &[
                "ଫ\u{b3e}ଇଲ\u{b4d}",
                "ଫ\u{b3e}ଇଲ\u{b4d}\u{200c} ଫୋଲ\u{b4d}ଡଋ",
                "ଫୋଲ\u{b4d}ଡର\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਫ\u{a3c}ਾਈਲ ਫ\u{a4b}ਲਡਰ"),
            keywords: &["ਫ\u{a3c}ਾਈਲ ਫ\u{a4b}ਲਡਰ", "ਫਾਇਲ", "ਫ\u{a4b}ਲਡਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("فائل دا فولڈر"),
            keywords: &["فائل", "فائل دا فولڈر", "فولڈر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Faíl Fólda"),
            keywords: &["Fail", "Faíl Fólda", "Fólda"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("folder"),
            keywords: &["folder", "katalog"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("دوتنې پوښۍ"),
            keywords: &["دوتنې", "پوښۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pasta de arquivos"),
            keywords: &["arquivo", "pasta", "pasta de arquivos"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("pasta de arquivo"),
            keywords: &["arquivo", "pasta", "pasta de arquivo"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("dosar de arhivare"),
            keywords: &["dosar", "dosar de arhivare", "fișier"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-638"),
            keywords: &["E10-638"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("папка"),
            keywords: &["бумаги", "документы", "папка", "файл"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ububiko bwa dosiye"),
            keywords: &["ububiko bwa dosiye"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("فائل فولڊر"),
            keywords: &["فائل فولڊر", "فائيل", "فولڊر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ගොන\u{dd4} ෆෝල\u{dca}ඩරය"),
            keywords: &["ගොන\u{dd4} ෆෝල\u{dca}ඩරය", "ගොන\u{dd4}ව", "ෆෝල\u{dca}ඩරය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("fascikel"),
            keywords: &["fascikel", "priečinok", "súbor"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("mapa za spise"),
            keywords: &["mapa", "mapa za spise", "spis"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("fooldarka faylasha"),
            keywords: &["fayl", "fooldar", "fooldarka faylasha"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("dosje dokumentesh"),
            keywords: &["dokument", "dosje", "dosje dokumentesh", "skedar"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("фасцикла"),
            keywords: &["фасцикла"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("fascikla"),
            keywords: &["fascikla"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("arkivmapp"),
            keywords: &["arkiv", "arkivmapp", "mapp"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("folda ya faili"),
            keywords: &["faili", "folda", "folda ya faili"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பைல\u{bcd} ஃபோல\u{bcd}டர\u{bcd}"),
            keywords: &["ஃபோல\u{bcd}டர\u{bcd}", "கோப\u{bcd}பு", "பைல\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఫ\u{c48}ల\u{c4d} ఫ\u{c4b}ల\u{c4d}డర\u{c4d}"),
            keywords: &["ఫ\u{c48}ల\u{c4d}", "ఫ\u{c4b}ల\u{c4d}డర\u{c4d}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҷузвдони файлҳо"),
            keywords: &["файл", "ҷузвдон", "ҷузвдони файлҳо"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แฟ\u{e49}มเอกสาร"),
            keywords: &["แฟ\u{e49}มเอกสาร", "โฟลเดอร\u{e4c}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("faýl bukjasy"),
            keywords: &["bukja", "faýl", "faýl bukjasy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("takafi faile"),
            keywords: &["takafi faile"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("dosya klasörü"),
            keywords: &["dosya", "dosya klasörü", "klasör"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ھۆججەت قىسقۇچ"),
            keywords: &["قىسقۇچ", "ھۆججەت"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("тека для файлів"),
            keywords: &["закрита папка для файлів", "папка", "тека для файлів"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("فائل فولڈر"),
            keywords: &["اسٹیشنری", "فائل", "فولڈر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("fayl jildi"),
            keywords: &["fayl", "fayl jildi", "jild"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("thư mục tệp"),
            keywords: &["thư mục", "thư mục tệp", "tệp"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("ëmbu taxañ"),
            keywords: &["taxañ", "ëmbu"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ifolda yefayile"),
            keywords: &["ifayile", "ifolda", "ifolda yefayile"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("fódà fáìlì"),
            keywords: &["fáìlì", "fódà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("文件夾"),
            keywords: &["文件夾", "檔案"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("文件夹"),
            keywords: &["文件夹", "档案"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("文件夹"),
            keywords: &["办公", "文件", "文件夹", "文具", "硬纸夹"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("資料夾"),
            keywords: &["資料夾"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("文件夾"),
            keywords: &["文件夾"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ifolda yefayela"),
            keywords: &["ifayela", "ifolda", "ifolda yefayela"],
        },
    ],
};
#[doc = "📂"]
pub const OPEN_FILE_FOLDER: crate::Emoji = crate::Emoji {
    glyph: "📂",
    codepoint: "1F4C2",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "open file folder",
    group: "Objects",
    subgroup: "office",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("oop lêervouer"),
            keywords: &["lêer", "oop", "oop lêervouer", "vouer"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ክፍት የፋይል አቃፊ"),
            keywords: &["አቃፊ", "ክፍት", "ክፍት የፋይል አቃፊ", "ፋይል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مجلد مفتوح"),
            keywords: &["مجلد", "مجلد ملفات مفتوح", "مفتوح", "ملف"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("খোল\u{9be} ফ\u{9be}ইল ফ’ল\u{9cd}ড\u{9be}ৰ"),
            keywords: &["খোল\u{9be}", "ফ\u{9be}ইল", "ফ’ল\u{9cd}ড\u{9be}ৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("açıq fayl qovluğu"),
            keywords: &["açıq", "açıq fayl qovluğu", "fayl", "qovluq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("адкрытая папка для файлаў"),
            keywords: &["адкрытая", "адкрытая папка для файлаў", "папка", "файл"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Отворена папка"),
            keywords: &["Отворена папка", "отворен", "папка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ফ\u{9be}ইল ফোল\u{9cd}ড\u{9be}র খোল\u{9be}"),
            keywords: &["খোল\u{9be}", "ফ\u{9be}ইল", "ফোল\u{9cd}ড\u{9be}র"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kleurenn digor"),
            keywords: &["digor", "kleurenn", "teuliad"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("otvorena fascikla"),
            keywords: &["fajl", "fascikla", "otvorena fascikla", "otvoreno"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("carpeta de fitxers oberta"),
            keywords: &[
                "arxius",
                "carpeta",
                "carpeta de fitxers oberta",
                "carpeta d’arxius oberta",
                "fitxers",
                "oberta",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎯᏍᏚᎢ ᎠᏍᏆᏂᎪᏙᏗ ᎠᏰᏈᏛᏍᎩ"),
            keywords: &["ᎠᏍᏆᏂᎪᏛᎢ", "ᎠᏍᏚᎢᏓ", "ᎯᏍᏚᎢ ᎠᏍᏆᏂᎪᏙᏗ ᎠᏰᏈᏛᏍᎩ", "ᏗᏴᏈᏛᎥᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("otevřená složka"),
            keywords: &["dokumenty", "otevřená složka", "otevřený", "složka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("agor ffolder ffeiliau"),
            keywords: &["agor", "agor ffolder ffeiliau", "ffeil", "ffolder"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("åben mappe"),
            keywords: &["dokument", "åben mappe"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("geöffneter Ordner"),
            keywords: &["Dokument", "Ordner", "geöffneter Ordner", "offen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ανοικτός φάκελος αρχείων"),
            keywords: &["ανοικτός φάκελος αρχείων", "ανοιχτός", "αρχείο", "φάκελος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("open file folder"),
            keywords: &["file", "folder", "open"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("carpeta de archivos abierta"),
            keywords: &[
                "abierta",
                "archivo",
                "carpeta",
                "carpeta de archivos abierta",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("avatud kaust"),
            keywords: &["avatud", "dokument", "fail", "kaust"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("fitxategi-sailkatzaile irekia"),
            keywords: &[
                "fitxategi",
                "fitxategi-sailkatzaile irekia",
                "irekita",
                "karpeta",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پوشه\u{654} باز"),
            keywords: &["باز", "فایل", "پوشه", "پوشه\u{654} باز"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("avoin tiedostokansio"),
            keywords: &["avoin", "avoin tiedostokansio", "kansio", "tiedosto"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nakabukas na file folder"),
            keywords: &["file", "folder", "nakabukas", "nakabukas na file folder"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("opin skjalalummi"),
            keywords: &[
                "faldari",
                "fíl",
                "lummi i skjalalummi",
                "mappa",
                "opin",
                "opin skjalalummi",
                "skjalamappa",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("dossier ouvert"),
            keywords: &["dossier", "dossier ouvert"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("fillteán oscailte"),
            keywords: &["comhad", "fillteán", "oscailte"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("pasgan fhaidhlichean fosgailte"),
            keywords: &[
                "faidhle",
                "fosgailte",
                "pasgan",
                "pasgan fhaidhlichean fosgailte",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cartafol aberto"),
            keywords: &["aberto", "carpeta", "cartafol aberto", "documentos"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ખ\u{ac1}લ\u{acd}લ\u{ac1}\u{a82} ફાઇલ ફોલ\u{acd}ડર"),
            keywords: &["ખ\u{ac1}લ\u{acd}લ\u{ac1}\u{a82}", "ફાઇલ", "ફોલ\u{acd}ડર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("buɗaɗɗiyar foldar fayil"),
            keywords: &["buɗaɗɗe", "buɗaɗɗiyar foldar fayil", "fayil", "folda"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("תיקיית מסמכים פתוחה"),
            keywords: &["מסמכים", "פתוחה", "תיקייה", "תיקיית מסמכים פתוחה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ख\u{941}ला फ\u{93c}ाइल फ\u{93c}ोल\u{94d}डर"),
            keywords: &["ख\u{941}ला", "फ\u{93c}ाइल", "फ\u{93c}ोल\u{94d}डर"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("otvorena mapa"),
            keywords: &["mapa", "otvorena mapa", "otvoreno"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nyitott fájlmappa"),
            keywords: &["fájl", "mappa", "nyitott", "nyitott fájlmappa"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բաց թղթապանակ"),
            keywords: &["բաց", "թղթապանակ", "ֆայլ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("folder file terbuka"),
            keywords: &["file", "folder", "terbuka"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("mepee foldà faịlụ"),
            keywords: &["failụ", "foldà", "mepee", "mepee foldà faịlụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("opin mappa"),
            keywords: &["opin mappa", "opin skráamappa"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cartella aperta"),
            keywords: &["aperta", "cartella", "file"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("開いたフォルダー"),
            keywords: &[
                "ファイル",
                "フォルダー",
                "文具",
                "文房具",
                "開いたフォルダー",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("map berkas mbukak"),
            keywords: &["berkas", "map", "mbukak"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ღია საქაღალდე"),
            keywords: &["საქაღალდე", "ფაილი", "ღია"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("ldi akaram n ufaylu"),
            keywords: &["ldi akaram n ufaylu"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("файл қалтасын ашу"),
            keywords: &["ашық", "файл", "файл қалтасын ашу", "қалта"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("åben mappe"),
            keywords: &["dokument", "åben mappe"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17ca}\u{17ba}ម\u{17c9}\u{17b8}បើក"),
            keywords: &[
                "ថត",
                "បើក",
                "ស\u{17ca}\u{17ba}ម\u{17c9}\u{17b8}បើក",
                "ឯកសារ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ತ\u{cc6}ರ\u{cc6}ದ ಫೈಲ\u{ccd} ಫೋಲ\u{ccd}ಡ\u{ccd}ಡರ\u{ccd}"),
            keywords: &[
                "ತ\u{cc6}ರ\u{cc6}ದ",
                "ತ\u{cc6}ರ\u{cc6}ದ ಫೈಲ\u{ccd} ಫೋಲ\u{ccd}ಡ\u{ccd}ಡರ\u{ccd}",
                "ಫೈಲ\u{ccd}",
                "ಫೋಲ\u{ccd}ಡರ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("폴더 열기"),
            keywords: &["열기", "열린 폴더", "파일", "폴더"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("फायल फोल\u{94d}डर उगडचो"),
            keywords: &["उगडचो", "फायल", "फोल\u{94d}डर"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("файл куржунун ачуу"),
            keywords: &["ачуу", "куржун", "файл", "файл куржунун ачуу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("oppene Fichiersdossier"),
            keywords: &["Dossier", "Fichier", "oppen", "oppene Fichiersdossier"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເປ\u{eb5}ດເອກະສານ"),
            keywords: &["ເປ\u{eb5}ດ", "ເປ\u{eb5}ດເອກະສານ", "ເອກະສານ", "ແຟ\u{ec9}ມ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("atidarytas failų aplankas"),
            keywords: &[
                "aplankas",
                "atidarytas",
                "atidarytas failų aplankas",
                "failas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("atvērta dokumentu mape"),
            keywords: &["atvērta dokumentu mape", "atvērts", "dokuments", "mape"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kōpaki kōnae tuwhera"),
            keywords: &["kōnae", "kōpaki", "tuwhera"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("отворена папка"),
            keywords: &["отворена", "папка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ത\u{d41}റന\u{d4d}ന ഫയൽ ഫോൾഡർ"),
            keywords: &[
                "ത\u{d41}റക\u{d4d}ക\u{d41}ക",
                "ത\u{d41}റന\u{d4d}ന ഫയൽ ഫോൾഡർ",
                "ത\u{d41}റന\u{d4d}ന ഫോൾഡർ",
                "ഫയൽ",
                "ഫോൾഡർ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("онгорхой файлын хавтас"),
            keywords: &["нээх", "онгорхой файлын хавтас", "файл", "хавтас"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ख\u{941}ल\u{947} फाईल फोल\u{94d}डर"),
            keywords: &[
                "उघडा",
                "ख\u{941}ल\u{947} फाइल फोल\u{94d}डर",
                "ख\u{941}ल\u{947} फाईल फोल\u{94d}डर",
                "फाइल",
                "फोल\u{94d}डर",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("folder buka fail"),
            keywords: &["fail", "folder", "folder buka fail", "terbuka"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("fowlder tal-fajls miftuħ"),
            keywords: &["fajl", "fowlder", "fowlder tal-fajls miftuħ", "miftuħ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ဖ\u{103d}င\u{1037}\u{103a}ထားသည\u{1037}\u{103a} ဖ\u{102d}\u{102f}င\u{103a}တ\u{103d}\u{1032}",
            ),
            keywords: &[
                "ဖ\u{102d}\u{102f}င\u{103a}",
                "ဖ\u{102d}\u{102f}င\u{103a}တ\u{103d}\u{1032}",
                "ဖ\u{103d}င\u{1037}\u{103a}ထားသည\u{1037}\u{103a} ဖ\u{102d}\u{102f}င\u{103a}တ\u{103d}\u{1032}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("åpen arkivmappe"),
            keywords: &["arkivmappe", "fil", "filmappe", "mappe", "åpen"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ख\u{941}ला फाइलको फोल\u{94d}डर"),
            keywords: &[
                "ख\u{941}ला फाइलको फोल\u{94d}डर",
                "खोल\u{94d}न",
                "फाइल",
                "फोल\u{94d}डर",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("geopende map"),
            keywords: &["bestand", "geopende map", "map", "open"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("open arkivmappe"),
            keywords: &[
                "arkimappe",
                "fil",
                "filmappe",
                "mappe",
                "open",
                "open arkivmappe",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଖୋଲ\u{b3e} ଫ\u{b3e}ଇଲ\u{b4d}\u{200c} ଫୋଲ\u{b4d}ଡର"),
            keywords: &[
                "ଖୋଲ\u{b3e}",
                "ଖୋଲ\u{b3e} ଫ\u{b3e}ଇଲ\u{b4d}\u{200c} ଫୋଲ\u{b4d}ଡର",
                "ଫ\u{b3e}ଇଲ\u{b4d}",
                "ଫୋଲ\u{b4d}ଡର\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਖ\u{a41}\u{a71}ਲ\u{a4d}ਹਾ ਫ\u{a3c}ਾਈਲ ਫ\u{a4b}ਲਡਰ"),
            keywords: &[
                "ਖ\u{a41}\u{a71}ਲ\u{a4d}ਹਾ ਫ\u{a3c}ਾਈਲ ਫ\u{a4b}ਲਡਰ",
                "ਖ\u{a4b}ਲ\u{a4d}ਹ\u{a4b}",
                "ਫਾਇਲ",
                "ਫ\u{a4b}ਲਡਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("فائل دا فولڈر کھولو"),
            keywords: &["فائل", "فائل دا فولڈر کھولو", "فولڈر", "ک\u{64f}ھلا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ópún Faíl Fólda"),
            keywords: &["Fail", "Fólda", "Ópun", "Ópún Faíl Fólda"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("otwarty folder"),
            keywords: &["folder", "katalog", "otwarty"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("دوتنه پوښۍ خلاص"),
            keywords: &["خلاص", "دوتنه", "پوښۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pasta de arquivos aberta"),
            keywords: &["aberta", "arquivo", "pasta", "pasta de arquivos aberta"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("pasta de arquivo aberta"),
            keywords: &["aberta", "arquivo", "pasta", "pasta de arquivo aberta"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("dosar de arhivare deschis"),
            keywords: &["deschis", "dosar", "dosar de arhivare deschis", "fișier"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-639"),
            keywords: &["E10-639"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("открытая папка"),
            keywords: &["бумаги", "документы", "открытая", "папка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("gufungura ububiko bwa dosiye"),
            keywords: &[
                "bwa dosiye",
                "gufungura",
                "gufungura ububiko bwa dosiye",
                "ububiko",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("کليل فائل فولڊر"),
            keywords: &["فائيل", "فولڊر", "کليل", "کليل فائل فولڊر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ව\u{dd2}වෘත ගොන\u{dd4} ෆෝල\u{dca}ඩරය"),
            keywords: &[
                "ගොන\u{dd4}\u{dd4}ව",
                "ව\u{dd2}වෘත",
                "ව\u{dd2}වෘත ගොන\u{dd4} ෆෝල\u{dca}ඩරය",
                "ෆෝල\u{dca}ඩරය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("otvorený fascikel"),
            keywords: &["otvorený", "otvorený fascikel", "priečinok", "súbor"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("odprta mapa za spise"),
            keywords: &["mapa", "odprta mapa za spise", "odprto", "spis"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("fooldarka faylasha oo furan"),
            keywords: &["fayl", "fooldar", "fooldarka faylasha oo furan", "furan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("dosje dokumentesh e hapur"),
            keywords: &["dokument", "dosje", "dosje dokumentesh e hapur", "skedar"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("отворена фасцикла"),
            keywords: &["отворена фасцикла", "отворено", "фасцикла"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["отворена фасцикла"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("otvorena fascikla"),
            keywords: &["fascikla", "otvorena fascikla", "otvoreno"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["otvorena fascikla"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("öppen mapp"),
            keywords: &["mapp", "öppen mapp", "öppet arkiv"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("folda ya faili iliyofunguliwa"),
            keywords: &[
                "faili",
                "folda",
                "folda ya faili iliyofunguliwa",
                "funguliwa",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("திறந\u{bcd}த பைல\u{bcd} ஃபோல\u{bcd}டர\u{bcd}"),
            keywords: &[
                "திறந\u{bcd}த ஃபோல\u{bcd}டர\u{bcd}",
                "திறந\u{bcd}த பைல\u{bcd}",
                "திறந\u{bcd}த பைல\u{bcd} ஃபோல\u{bcd}டர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("త\u{c46}ర\u{c3f}చ\u{c3f}న ఫ\u{c48}ల\u{c4d} ఫ\u{c4b}ల\u{c4d}డర\u{c4d}"),
            keywords: &[
                "త\u{c46}రవడం",
                "త\u{c46}ర\u{c3f}చ\u{c3f}న ఫ\u{c48}ల\u{c4d} ఫ\u{c4b}ల\u{c4d}డర\u{c4d}",
                "ఫ\u{c48}ల\u{c4d}",
                "ఫ\u{c4b}ల\u{c4d}డర\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("кушодани ҷузвдони фалҳо"),
            keywords: &["кушода", "кушодани ҷузвдони фалҳо", "файл", "ҷузвдон"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เป\u{e34}ดเอกสาร"),
            keywords: &["เป\u{e34}ดเอกสาร", "แฟ\u{e49}มเป\u{e34}ด"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("açyk faýl bukjasy"),
            keywords: &["açyk", "açyk faýl bukjasy", "bukja", "faýl"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("takafi faile ava"),
            keywords: &["takafi faile ava"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("açık dosya klasörü"),
            keywords: &["açık", "açık dosya klasörü", "dosya", "klasör"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئوچۇق قىسقۇچ"),
            keywords: &["ئوچۇق", "قىسقۇچ", "ھۆججەت"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("відкрита папка для файлів"),
            keywords: &["відкрита папка для файлів", "відкритий", "папка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کھلا فائل فولڈر"),
            keywords: &["اسٹیشنری", "فائل", "فولڈر", "کھلا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ochiq fayl jildi"),
            keywords: &["fayl", "jild", "ochiq", "ochiq fayl jildi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("thư mục tệp mở"),
            keywords: &["mở", "thư mục", "thư mục tệp mở", "tệp"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("ubbi ëmbu taxañ"),
            keywords: &["taxañ", "ubbeeku", "ubbi ëmbu taxañ", "ëmb"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ifolda yefayile evulekileyo"),
            keywords: &[
                "ifayile",
                "ifolda",
                "ifolda yefayile evulekileyo",
                "ivulekile",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("fódà fáìlì ti o ṣi"),
            keywords: &["fáìlì", "fódà", "fódà fáìlì ti o ṣi", "ṣí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("打開文件夾"),
            keywords: &["打開", "打開文件夾", "文件夾", "檔案"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("打开文件夹"),
            keywords: &["打开", "打开文件夹", "文件夹", "档案"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("打开的文件夹"),
            keywords: &["办公", "打开", "打开的文件夹", "文件", "文具"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("打開資料夾"),
            keywords: &["打開資料夾"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("打開嘅文件夾"),
            keywords: &["打開嘅文件夾", "打開｜文件夾｜文件"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("vula ifolda yefayela"),
            keywords: &["ifayela", "ifolda", "ukuvula", "vula ifolda yefayela"],
        },
    ],
};
#[doc = "🗂\u{fe0f}"]
pub const CARD_INDEX_DIVIDERS: crate::Emoji = crate::Emoji {
    glyph: "🗂\u{fe0f}",
    codepoint: "1F5C2 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "card index dividers",
    group: "Objects",
    subgroup: "office",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🗂",
        codepoint: "1F5C2",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "card index dividers",
        group: "Objects",
        subgroup: "office",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kaartindeksverdelers"),
            keywords: &["indeks", "kaart", "kaartindeksverdelers", "verdelers"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ካርድ መጥቁም ከፋፋዮች"),
            keywords: &["መጥቁም", "ከፋፋዮች", "ካርታ", "ካርድ መጥቁም ከፋፋዮች"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("حاجز بطاقات"),
            keywords: &["بطاقة", "حاجز بطاقات", "حواجز", "مؤشر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9be}ৰ\u{9cd}ড ইনডেক\u{9cd}স বিভ\u{9be}জক"),
            keywords: &["ইনডেক\u{9cd}স", "ক\u{9be}ৰ\u{9cd}ড", "বিভ\u{9be}জক"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kart indeksi arakəsmələri"),
            keywords: &["arakəsmə", "işarə", "kart", "kart indeksi arakəsmələri"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("раздзяляльнікі для картатэкі"),
            keywords: &[
                "карта",
                "картатэка",
                "раздзяляльнікі",
                "раздзяляльнікі для картатэкі",
                "сартаванне",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Разделители за картотека"),
            keywords: &[
                "Разделители за картотека",
                "карта",
                "показалец",
                "разделители",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9be}র\u{9cd}ডের স\u{9c2}চীর বিভ\u{9be}জক"),
            keywords: &[
                "ক\u{9be}র\u{9cd}ড",
                "ক\u{9be}র\u{9cd}ডের স\u{9c2}চীর বিভ\u{9be}জক",
                "বিভক\u{9cd}ত",
                "স\u{9c2}চক",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("dispartier"),
            keywords: &["dispartier", "renkañ"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("fascikla s odjeljcima"),
            keywords: &["dokumenti", "fascikla s odjeljcima", "odjeljci"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("separadors per a organitzador de targetes"),
            keywords: &[
                "organitzador",
                "separadors",
                "separadors per a organitzador de targetes",
                "targetes",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏆᏂᏲᏍᏗ ᎠᏍᏓᏩᏛᏍᏗ ᏔᎵ ᏱᎦᏗᏍᎩ"),
            keywords: &["ᎠᏍᏓᏩᏛᏍᏗ", "ᏆᏂᏲᏍᏗ", "ᏆᏂᏲᏍᏗ ᎠᏍᏓᏩᏛᏍᏗ ᏔᎵ ᏱᎦᏗᏍᎩ", "ᏔᎵ ᎢᎦᏗᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kartotéka"),
            keywords: &["karta", "kartotéka", "oddíl", "oddělovač", "rejstřík"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("rhanwyr mynegai cardiau"),
            keywords: &["card", "mynegai", "rhanwyr", "rhanwyr mynegai cardiau"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kartotekskort"),
            keywords: &["kartotek", "kartotekskort", "kort"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Karteireiter"),
            keywords: &["Büromaterial", "Karteikarten", "Karteireiter"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("διαχωριστικά ευρετηρίου καρτών"),
            keywords: &[
                "διαχωριστικά",
                "διαχωριστικά ευρετηρίου καρτών",
                "ευρετήριο",
                "κάρτα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("card index dividers"),
            keywords: &["card", "dividers", "index"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("index card dividers"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("separador de fichas"),
            keywords: &["fichas", "fichero", "separador", "separador de fichas"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("separadores para tarjetas"),
            keywords: &["archivos", "separadores para tarjetas", "índice"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("separadores"),
            keywords: &["separadores", "tarjeta", "índice"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("register"),
            keywords: &["kaart", "register"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("artxibo-bereizleak"),
            keywords: &["artxibo", "artxibo-bereizleak", "bereizle", "txartel"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("جداکننده"),
            keywords: &["جداکننده", "راهنما", "کارت"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kortiston välilehdet"),
            keywords: &[
                "arkisto",
                "kortisto",
                "kortiston välilehdet",
                "kortti",
                "välilehti",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mga divider ng card index"),
            keywords: &["card", "divider", "index", "mga divider ng card index"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("seðlaskrábókamerki"),
            keywords: &["bókamerki", "indeks", "seðlaskrá", "seðlaskrábókamerki"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("intercalaires"),
            keywords: &["classement", "index", "intercalaire", "intercalaires"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("roinnteoirí innéacs cárta"),
            keywords: &["cárta", "innéacs", "roinnteoirí"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("roinneadairean clàr-amais chairtean"),
            keywords: &[
                "cairt",
                "clàr-amais",
                "roinneadair",
                "roinneadairean clàr-amais chairtean",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("separadores de fichas"),
            keywords: &[
                "arquivador",
                "documentos",
                "fichas",
                "ficheiro",
                "separadores de fichas",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કાર\u{acd}ડ ઇન\u{acd}ડ\u{ac7}ક\u{acd}સ ડિવાઇડર\u{acd}સ"),
            keywords: &[
                "ઇન\u{acd}ડ\u{ac7}ક\u{acd}સ",
                "કાર\u{acd}ડ",
                "ડિવાઇડર\u{acd}સ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("masu rabawa fihirisan kati"),
            keywords: &[
                "fihirisa",
                "kati",
                "mai rabawa",
                "masu rabawa fihirisan kati",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כרטסת עם חוצצים"),
            keywords: &["חוצצים", "כרטיסיות", "כרטסת", "כרטסת עם חוצצים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("कार\u{94d}ड इ\u{902}ड\u{947}क\u{94d}स डिवाइडर"),
            keywords: &[
                "कार\u{94d}ड",
                "कार\u{94d}ड इ\u{902}ड\u{947}क\u{94d}स डिवाइडर",
                "विभाजक",
                "स\u{942}ची",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("razdjelnici"),
            keywords: &["indeks", "pregradni karton", "razdjelnici", "razdjelnik"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kartotékelválasztók"),
            keywords: &[
                "elválasztók",
                "kartoték",
                "kartotékelválasztók",
                "katalógus",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("քարտադարանի բաժանարարներ"),
            keywords: &["բաժանարար", "ինդեքս", "քարտ", "քարտադարանի բաժանարարներ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pembagi indeks kartu"),
            keywords: &["indeks", "kartu", "pembagi"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("indek ihe nkewa kaadị"),
            keywords: &["ihe nkewa", "indek", "indek ihe nkewa kaadị", "kaadi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("spjaldskráarblöð"),
            keywords: &["blöð", "spjald", "spjaldskrá", "spjaldskráarblöð"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("divisori per schedario"),
            keywords: &[
                "archivio",
                "divisori",
                "divisori per schedario",
                "documenti",
                "ordinare",
                "schedario",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("カードフォルダー"),
            keywords: &[
                "インデックス",
                "カードフォルダー",
                "フォルダー",
                "文具",
                "文房具",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pambagi indeks kertu"),
            keywords: &["indeks", "kertu", "pambagi"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბარათებიანი საძიებელი გამყოფებით"),
            keywords: &["ბარათებიანი საძიებელი გამყოფებით", "საძიებელი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("карта индексін бөлгіштер"),
            keywords: &["бөлгіштер", "индекс", "карта", "карта индексін бөлгіштер"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kartotekskort"),
            keywords: &["kartotek", "kartotekskort", "kort"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17ca}\u{17ba}ម\u{17c9}\u{17b8}ដាក\u{17cb}កាត"),
            keywords: &[
                "កាត",
                "ខណ\u{17d2}ឌ",
                "សន\u{17d2}ទស\u{17d2}សន\u{17cd}",
                "ស\u{17ca}\u{17ba}ម\u{17c9}\u{17b8}ដាក\u{17cb}កាត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಾರ\u{ccd}ಡ\u{ccd} ಸ\u{cc2}ಚಕ ವ\u{cbf}ಭಾಜಕಗಳು"),
            keywords: &[
                "ಇಂಡ\u{cc6}ಕ\u{ccd}ಸ\u{ccd}",
                "ಕಾರ\u{ccd}ಡ\u{ccd} ಸ\u{cc2}ಚಕ ವ\u{cbf}ಭಾಜಕಗಳು",
                "ವ\u{cbf}ಭಾಜಕಗಳು",
                "ಸ\u{cc2}ಚ\u{ccd}ಯಂಕ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("카드 색인 파일"),
            keywords: &["색인", "카드", "파일", "폴더"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("कार\u{94d}ड इ\u{902}ड\u{947}क\u{94d}स डिवायडर"),
            keywords: &["इ\u{902}ड\u{947}क\u{94d}स", "कार\u{94d}ड", "डिवायडर"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("картотека бөлгүч"),
            keywords: &["бөлгүч", "картотека"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Intercalairen"),
            keywords: &["Index", "Intercalairen", "Kaart"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແນວຂ\u{eb1}\u{ec9}ນບ\u{eb1}ດລາຍການ"),
            keywords: &[
                "ບ\u{eb1}ດ",
                "ລາຍການ",
                "ແນວຂ\u{eb1}\u{ec9}ນ",
                "ແນວຂ\u{eb1}\u{ec9}ນບ\u{eb1}ດລາຍການ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kortelių laikiklio skirtukai"),
            keywords: &[
                "indeksas",
                "kortelių laikiklio skirtukai",
                "kortelė",
                "skirtukai",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("dokumentu sadalītājs"),
            keywords: &["dokuments", "dokumentu sadalītājs", "kartīte", "sadalītājs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ngā whakawehe kāri kuputohu"),
            keywords: &[
                "kuputohu",
                "kāri",
                "ngā whakawehe kāri kuputohu",
                "whakawehe",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("прегради на картотека"),
            keywords: &["картотека", "преграда", "прегради на картотека"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d3e}ർഡ\u{d4d} ഇൻഡക\u{d4d}\u{200c}സ\u{d4d} ഡിവൈഡറ\u{d41}കൾ"),
            keywords: &[
                "ഇൻഡ\u{200c}ക\u{d4d}\u{200c}സ\u{d4d}",
                "ക\u{d3e}ർഡ\u{d4d}",
                "ഡിവൈഡറ\u{d41}കൾ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("карт хуваарилагч"),
            keywords: &["карт", "хуваарилагч"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कार\u{94d}ड अन\u{941}क\u{94d}रमणिका विभाजक"),
            keywords: &["अन\u{941}क\u{94d}रमणिका", "कार\u{94d}ड", "विभाजक"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pembahagi indeks kad"),
            keywords: &["indeks", "kad", "pembahagi"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kard dividers tal-indiċi tal-biljett"),
            keywords: &[
                "dividers",
                "indiċi",
                "kard",
                "kard dividers tal-indiċi tal-biljett",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အည\u{103d}\u{103e}န\u{103a}းကဒ\u{103a} ခ\u{103d}\u{1032}သည\u{1037}\u{103a}အရာ",
            ),
            keywords: &[
                "ကတ\u{103a}",
                "ခ\u{103d}\u{1032}ခြားခြင\u{103a}း",
                "အည\u{103d}\u{103e}န\u{103a}း",
                "အည\u{103d}\u{103e}န\u{103a}းကဒ\u{103a} ခ\u{103d}\u{1032}သည\u{1037}\u{103a}အရာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("skillekort"),
            keywords: &["faner", "indeks", "kort", "skillekort", "skillere"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कार\u{94d}ड स\u{942}चक ड\u{94d}राइभरहर\u{942}"),
            keywords: &["कार\u{94d}ड", "ड\u{94d}राइभरहर\u{942}", "स\u{942}चक"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("tabbladen"),
            keywords: &["index", "kaart", "tabbladen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("skiljekort"),
            keywords: &["faner", "indeks", "kort", "skiljarar", "skiljekort"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "କ\u{b3e}ର\u{b4d}ଡ\u{b4d} ଅନ\u{b41}କ\u{b4d}ରମଣ\u{b3f}କ\u{b3e} ବ\u{b3f}ଭ\u{b3e}ଜକଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
            ),
            keywords: &[
                "ଅନ\u{b41}କ\u{b4d}ରମଣ\u{b3f}କ\u{b3e}",
                "ଇଣ\u{b4d}ଡେକ\u{b4d}ସ\u{b4d}",
                "କ\u{b3e}ର\u{b4d}ଡ\u{b4d}",
                "ବ\u{b3f}ଭ\u{b3e}ଜକଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਾਰਡ ਸ\u{a42}ਚੀਆ\u{a02} ਵ\u{a70}ਡਣ ਵਾਲਾ"),
            keywords: &[
                "ਕਾਰਡ",
                "ਕਾਰਡ ਸ\u{a42}ਚੀਆ\u{a02} ਵ\u{a70}ਡਣ ਵਾਲਾ",
                "ਵ\u{a70}ਡਣ ਵਾਲਾ",
                "ਸ\u{a42}ਚੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کارڈ انڈیکس دا تقسیم کنندہ"),
            keywords: &[
                "تقسیم کرن آلا",
                "ضمینہ",
                "کارڈ",
                "کارڈ انڈیکس دا تقسیم کنندہ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kád Índẹ\u{301}ks Divaída-dẹm"),
            keywords: &[
                "Divaída-dẹm",
                "Kad",
                "Kád Índẹ\u{301}ks Divaída-dẹm",
                "Índẹks",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("rozdzielacze kartoteki"),
            keywords: &[
                "kartoteka",
                "karty",
                "podział",
                "rozdzielacze",
                "rozdzielacze kartoteki",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کارت جدول وېشونکي"),
            keywords: &["جدول", "وېشونکي", "کارت"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("divisores de pastas"),
            keywords: &["divisor", "divisores de pastas", "pastas", "índice"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("separadores de fichas"),
            keywords: &["fichas", "separadores", "separadores de fichas"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("separatoare de dosare"),
            keywords: &["index", "separatoare", "separatoare de dosare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-816"),
            keywords: &["E10-816"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("маркированные папки"),
            keywords: &[
                "карточки",
                "маркированные папки",
                "оглавление",
                "разделители",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("urugabano rw’urutonde rw’amakarita"),
            keywords: &[
                "agacaruziga",
                "ifishi",
                "urugabano rw’urutonde rw’amakarita",
                "urutonde",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪارڊ ترتيب سان ورهائيندڙ"),
            keywords: &["ترتيب", "ورهائيندڙ", "ڪارڊ", "ڪارڊ ترتيب سان ورهائيندڙ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some(
                "ක\u{dcf}ඩ\u{dca} ඉන\u{dca}ඩෙක\u{dca}ස\u{dca} ඩ\u{dd2}වය\u{dd2}ඩර\u{dca}ස\u{dca}",
            ),
            keywords: &[
                "ඉන\u{dca}ඩෙක\u{dca}ස\u{dca}",
                "ක\u{dcf}ඩ\u{dca} ඉන\u{dca}ඩෙක\u{dca}ස\u{dca} ඩ\u{dd2}වය\u{dd2}ඩර\u{dca}ස\u{dca}",
                "ක\u{dcf}ඩ\u{dca}පත\u{dca}",
                "බෙද\u{dd4}ම\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("štítky na indexovanie"),
            keywords: &["index", "karta", "rozdeľovače", "štítky na indexovanie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kartoteke z vmesnimi listi"),
            keywords: &[
                "kartica",
                "kartoteka",
                "kartoteke z vmesnimi listi",
                "vmesni listi",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kala qeybiyayaasha kaararka"),
            keywords: &["kaar", "kala qeybiyayaal", "kala qeybiyayaasha kaararka"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("ndarëse skedash"),
            keywords: &["indeks", "letër", "ndarëse", "ndarëse skedash", "skedë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("разделници за каталог картица"),
            keywords: &[
                "индекс",
                "картица",
                "разделници",
                "разделници за каталог картица",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("раздјелници за каталог картица"),
            keywords: &["раздјелници за каталог картица"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("razdelnici za katalog kartica"),
            keywords: &[
                "indeks",
                "kartica",
                "razdelnici",
                "razdelnici za katalog kartica",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("razdjelnici za katalog kartica"),
            keywords: &["razdjelnici za katalog kartica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("indexflikar"),
            keywords: &["flikar", "index", "indexflikar", "kort", "pärmflikar"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("vigawanishi vya kadi"),
            keywords: &["farahasa", "kadi", "vigawanishi", "vigawanishi vya kadi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("க\u{bbe}ர\u{bcd}டு இன\u{bcd}டேக\u{bcd}ஸ\u{bcd} டிவைடர\u{bcd}ஸ\u{bcd}"),
            keywords: &[
                "இன\u{bcd}டேக\u{bcd}ஸ\u{bcd}",
                "க\u{bbe}ர\u{bcd}டு",
                "டிவைடர\u{bcd}ஸ\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "క\u{c3e}ర\u{c4d}డ\u{c4d} ఇండ\u{c46}క\u{c4d}స\u{c4d} డ\u{c3f}వ\u{c48}డర\u{c4d}\u{200c}లు",
            ),
            keywords: &[
                "ఇండ\u{c46}క\u{c4d}స\u{c4d}",
                "క\u{c3e}ర\u{c4d}డ\u{c4d}",
                "డ\u{c3f}వ\u{c48}డర\u{c4d}\u{200c}లు",
                "సూచ\u{c3f}క",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тақсимкунандаҳои индекси кортҳо"),
            keywords: &[
                "корт",
                "нишондиҳанда",
                "тақсимкунандаҳо",
                "тақсимкунандаҳои индекси кортҳо",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ท\u{e35}\u{e48}ค\u{e31}\u{e48}นบ\u{e31}ตรรายการ"),
            keywords: &[
                "ด\u{e31}ชน\u{e35}",
                "ท\u{e35}\u{e48}ค\u{e31}\u{e48}น",
                "ท\u{e35}\u{e48}ค\u{e31}\u{e48}นบ\u{e31}ตรรายการ",
                "บ\u{e31}ตร",
                "รายการ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kart indeksi bölüjileri"),
            keywords: &["bölüjiler", "indeks", "kart", "kart indeksi bölüjileri"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("vahevahe takafi faile"),
            keywords: &["vahevahe takafi faile"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("dosya ayırıcı"),
            keywords: &["ayırıcı", "dizin", "dosya ayırıcı", "kart"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئايرىق ساندۇق"),
            keywords: &["ئايرىق ساندۇق", "ئىندېكس", "بۆلگۈچ", "كارتا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("роздільники в картотеці"),
            keywords: &[
                "картотека",
                "роздільники в картотеці",
                "роздільники нумерації карток",
                "розділювачі",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کارڈ انڈیکس کے تقسیم کار"),
            keywords: &[
                "اسٹیشنری",
                "انڈیکس",
                "تقسیم کار",
                "کارڈ",
                "کارڈ انڈیکس کے تقسیم کار",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("fayllarni ajratuvchi"),
            keywords: &[
                "ajratuvchilar",
                "fayllarni ajratuvchi",
                "indeks",
                "kartochka",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("dụng cụ chia chỉ mục thẻ"),
            keywords: &["chỉ mục", "dụng cụ chia", "dụng cụ chia chỉ mục thẻ", "thẻ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xàjjalekaayu limu kàrt"),
            keywords: &["kàrt", "lim", "xaajalekaay", "xàjjalekaayu limu kàrt"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("izahluli zeindeksi yekhadi"),
            keywords: &[
                "i-indeksi",
                "ikhadi",
                "izahluli",
                "izahluli zeindeksi yekhadi",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ohun èlò ìpínyà àtòjọ atọ\u{301}ka-ọ\u{300}rọ\u{300} káàdì"),
            keywords: &[
                "káàdì",
                "ohun èlò ìpínyà",
                "ohun èlò ìpínyà àtòjọ atọ\u{301}ka-ọ\u{300}rọ\u{300} káàdì",
                "àtòjọ atọ\u{301}ka-ọ\u{300}rọ\u{300}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("卡片索引分類"),
            keywords: &["分類", "卡片", "卡片索引分類", "索引"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("卡片索引分类"),
            keywords: &["分类", "卡片", "卡片索引分类", "索引"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("索引分隔文件夹"),
            keywords: &["分隔", "文件夹", "索引", "索引分隔文件夹"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("索引隔板"),
            keywords: &["索引板", "索引隔板"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("索引分隔卡"),
            keywords: &["索引分隔卡", "索引｜分隔｜卡"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("okwahlukanisa amakhadi"),
            keywords: &["ikhadi", "okwahlukanisa amakhadi", "okwahlukanisayo"],
        },
    ],
};
#[doc = "📅"]
pub const CALENDAR: crate::Emoji = crate::Emoji {
    glyph: "📅",
    codepoint: "1F4C5",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "calendar",
    group: "Objects",
    subgroup: "office",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kalender"),
            keywords: &["almanak", "dag", "datum", "kalender"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቀን መቁጠሪያ"),
            keywords: &["ቀን መቁጠሪያ", "ዕለት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("تقويم"),
            keywords: &["تقويم", "روزنامة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কেলেণ\u{9cd}ড\u{9be}ৰ"),
            keywords: &["কেলেণ\u{9cd}ড\u{9be}ৰ", "ত\u{9be}ৰিখ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("təqvim"),
            keywords: &["tarix", "təqvim"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("каляндар"),
            keywords: &["дата", "каляндар", "чысло"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("календар"),
            keywords: &["дата", "календар"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9cd}য\u{9be}লেন\u{9cd}ড\u{9be}র"),
            keywords: &["ক\u{9cd}য\u{9be}লেন\u{9cd}ড\u{9be}র", "ত\u{9be}রিখ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("deiziadur"),
            keywords: &["deiziad", "deiziadur"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kalendar"),
            keywords: &["datum", "kalendar"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("calendari"),
            keywords: &["calendari", "data"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏅᏓ ᏗᏎᏍᏗ"),
            keywords: &["ᎢᎪᎯ ᎠᏎᎯᎲᎢ", "ᏅᏓ ᏗᏎᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kalendář"),
            keywords: &["datum", "kalendář"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("calendr"),
            keywords: &["calendr", "dyddiad"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kalender"),
            keywords: &["dato", "kalender"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Kalender"),
            keywords: &["Kalender", "Kalenderblatt"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ημερολόγιο"),
            keywords: &["ημερολόγιο", "ημερομηνία"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("calendar"),
            keywords: &["calendar", "date"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("calendario"),
            keywords: &["calendario", "fecha"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["calendario", "cita", "fecha", "reunión"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kalender"),
            keywords: &["kalender", "kuupäev"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("egutegi"),
            keywords: &["data", "egutegi"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تقویم"),
            keywords: &["تاریخ", "تقویم"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kalenteri"),
            keywords: &["kalenteri", "päivämäärä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kalendaryo"),
            keywords: &["kalendaryo", "petsa"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kalendari"),
            keywords: &[
                "dagfesting",
                "dagseting",
                "dato",
                "kalendari",
                "tíðarfesting",
                "tíðarmerking",
                "álmanakki",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("calendrier"),
            keywords: &["calendrier", "date"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("féilire"),
            keywords: &["dáta", "féilire"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("mìosachan"),
            keywords: &["ceann-latha", "ceann-là", "mìosachan"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("calendario"),
            keywords: &["calendario", "data"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ક\u{ac5}લ\u{ac7}ન\u{acd}ડર"),
            keywords: &["ક\u{ac5}લ\u{ac7}ન\u{acd}ડર", "ક\u{ac7}લ\u{ac7}ન\u{acd}ડર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kalanda"),
            keywords: &["kalanda", "kwanan wata"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לוח שנה"),
            keywords: &["יומן", "לוח שנה", "תאריך"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("क\u{948}ल\u{947}\u{902}डर"),
            keywords: &[
                "क\u{948}ल\u{947}\u{902}डर",
                "तारीख\u{93c}",
                "तिथि",
                "दिना\u{902}क",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kalendar"),
            keywords: &["datum", "kalendar"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("naptár"),
            keywords: &["dátum", "naptár"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("օրացույց"),
            keywords: &["ամսաթիվ", "օրացույց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kalender"),
            keywords: &["kalender", "tanggal"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("kalịnda"),
            keywords: &["deètì", "kalịnda"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("dagatal"),
            keywords: &["dagatal", "dagsetning"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("calendario"),
            keywords: &["calendario", "data", "giorno", "ricorrenza"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("カレンダー"),
            keywords: &["カレンダー", "スケジュール", "予定", "日付"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tanggalan"),
            keywords: &["tanggal", "tanggalan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კალენდარი"),
            keywords: &["თარიღი", "კალენდარი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("күнтізбе"),
            keywords: &["күнтізбе", "мерзім"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kalender"),
            keywords: &["dato", "kalender"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17d2}រត\u{17b7}ទ\u{17b7}ន"),
            keywords: &["កាលបរ\u{17b7}ច\u{17d2}ឆេទ", "ប\u{17d2}រត\u{17b7}ទ\u{17b7}ន"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{ccd}ಯಾಲ\u{cc6}ಂಡರ\u{ccd}"),
            keywords: &["ಕ\u{ccd}ಯಾಲ\u{cc6}ಂಡರ\u{ccd}", "ದ\u{cbf}ನಾಂಕ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("달력"),
            keywords: &["달력", "일정", "캘린더"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दिनदर\u{94d}शिका"),
            keywords: &["तारीख", "दिनदर\u{94d}शिका"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жылнаама"),
            keywords: &["жылнаама", "күн"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Kalenner"),
            keywords: &["Datum", "Kalenner"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປະຕ\u{eb4}ທ\u{eb4}ນ"),
            keywords: &["ປະຕ\u{eb4}ທ\u{eb4}ນ", "ວ\u{eb1}ນທ\u{eb5}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kalendorius"),
            keywords: &["data", "kalendorius"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kalendārs"),
            keywords: &["datums", "kalendārs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("maramataka"),
            keywords: &["maramataka", "te rā"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("календар"),
            keywords: &["датум", "календар"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കലണ\u{d4d}ടർ"),
            keywords: &["കലണ\u{d4d}ടർ", "തീയതി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("календарь"),
            keywords: &["календарь", "огноо"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("क\u{945}ल\u{947}\u{902}डर"),
            keywords: &["क\u{945}ल\u{947}\u{902}डर", "तारीख"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kalendar"),
            keywords: &["kalendar", "tarikh"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kalendarju"),
            keywords: &["data", "kalendarju"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပြက\u{1039}ခဒ\u{102d}န\u{103a}"),
            keywords: &[
                "ပြက\u{1039}ခဒ\u{102d}န\u{103a}",
                "ရက\u{103a}စ\u{103d}\u{1032}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kalender"),
            keywords: &["dato", "kalender"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पात\u{94d}रो"),
            keywords: &["पात\u{94d}रो", "मिति"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kalender"),
            keywords: &["datum", "kalender"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kalender"),
            keywords: &["dato", "kalender"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b4d}ୟ\u{b3e}ଲେଣ\u{b4d}ଡର\u{b4d}\u{200c}"),
            keywords: &[
                "କ\u{b4d}ୟ\u{b3e}ଲେଣ\u{b4d}ଡର\u{b4d}\u{200c}",
                "ତ\u{b3e}ର\u{b3f}ଖ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a48}ਲ\u{a70}ਡਰ"),
            keywords: &["ਕ\u{a48}ਲ\u{a70}ਡਰ", "ਮਿਤੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کیلنڈر"),
            keywords: &["تریخ", "کیلنڈر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kalẹ\u{301}nda"),
            keywords: &["Det", "Kalẹ\u{301}nda"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kalendarz"),
            keywords: &["data", "kalendarz"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("جنتري"),
            keywords: &["جنتري", "نېټه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("calendário"),
            keywords: &["calendário", "data", "datas"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["calendário", "data"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("calendar"),
            keywords: &["calendar", "dată", "zi"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-642"),
            keywords: &["E10-642"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("календарь"),
            keywords: &["даты", "календарь", "числа"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("karendari"),
            keywords: &["itariki", "karendari"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪئلينڊر"),
            keywords: &["تاريخ", "ڪئلينڊر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ද\u{dd2}න දර\u{dca}ශනය"),
            keywords: &["ද\u{dd2}න දර\u{dca}ශනය", "ද\u{dd2}නය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kalendár"),
            keywords: &["dátum", "kalendár"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("koledar"),
            keywords: &["datum", "koledar"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kaalandar"),
            keywords: &["kaalandar", "taariikh"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kalendar"),
            keywords: &["datë", "kalendar"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("календар"),
            keywords: &["дaтум", "календар"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kalendar"),
            keywords: &["datum", "kalendar"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kalender"),
            keywords: &["datum", "kalender"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kalenda"),
            keywords: &["kalenda", "tarehe"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ந\u{bbe}ள\u{bcd}க\u{bbe}ட\u{bcd}டி"),
            keywords: &[
                "க\u{bbe}லண\u{bcd}டர\u{bcd}",
                "க\u{bbe}லேண\u{bcd}டர\u{bcd}",
                "ந\u{bbe}ட\u{bcd}க\u{bbe}ட\u{bcd}டி",
                "ந\u{bbe}ள\u{bcd}க\u{bbe}ட\u{bcd}டி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c4d}య\u{c3e}ల\u{c46}ండర\u{c4d}"),
            keywords: &["క\u{c4d}య\u{c3e}ల\u{c46}ండర\u{c4d}", "త\u{c47}ద\u{c40}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тақвим"),
            keywords: &["сана", "тақвим"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ปฏ\u{e34}ท\u{e34}น"),
            keywords: &["ปฏ\u{e34}ท\u{e34}น", "ว\u{e31}นท\u{e35}\u{e48}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("senenama"),
            keywords: &["sene", "senenama"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tohimāhina"),
            keywords: &["tohimāhina"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("takvim"),
            keywords: &["takvim", "tarih"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كالېندار"),
            keywords: &["كالېندار", "چېسلا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("календар"),
            keywords: &["дата", "календар"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کیلنڈر"),
            keywords: &["اسٹیشنری", "تاریخ", "کیلنڈر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("taqvim"),
            keywords: &["sana", "taqvim"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("lịch"),
            keywords: &["lịch", "ngày"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("arminaat"),
            keywords: &["arminaat", "bis"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ikhalenda"),
            keywords: &["ikhalenda", "umhla"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("kàlẹ\u{301}ndà"),
            keywords: &["déètì", "kàlẹ\u{301}ndà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("日曆"),
            keywords: &["日曆", "日期"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("日历"),
            keywords: &["日历", "日期"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("日历"),
            keywords: &["日历", "日期"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("行事曆"),
            keywords: &["行事曆"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("日曆"),
            keywords: &["日曆", "日曆｜日期"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ikhalenda"),
            keywords: &["ikhalenda", "usuku"],
        },
    ],
};
#[doc = "📆"]
pub const TEAR_OFF_CALENDAR: crate::Emoji = crate::Emoji {
    glyph: "📆",
    codepoint: "1F4C6",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "tear-off calendar",
    group: "Objects",
    subgroup: "office",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("afskeurkalender"),
            keywords: &["afskeurkalender", "almanak", "dag", "datum", "kalender"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ተቀዳጅ ቀን መቁጠሪያ"),
            keywords: &["ቀን መቁጠሪያ", "ተቀዳጅ ቀን መቁጠሪያ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("تقويم بأوراق للقطع"),
            keywords: &["تقويم بأوراق للقطع", "روزنامة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ফ\u{9be}লিব পৰ\u{9be} কেলেণ\u{9cd}ড\u{9be}ৰ"),
            keywords: &[
                "কেলেণ\u{9cd}ড\u{9be}ৰ",
                "ফ\u{9be}লিব পৰ\u{9be} কেলেণ\u{9cd}ড\u{9be}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("təqvimi cırmaq"),
            keywords: &["təqvim", "təqvimi cırmaq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("адрыўны каляндар"),
            keywords: &["адрыўны", "каляндар"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Календар с късащи се листове"),
            keywords: &["Календар с късащи се листове", "календар"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("টিয\u{9bc}\u{9be}র-অফ ক\u{9cd}য\u{9be}লেন\u{9cd}ড\u{9be}র"),
            keywords: &[
                "ক\u{9cd}য\u{9be}লেন\u{9cd}ড\u{9be}র",
                "টিয\u{9bc}\u{9be}র-অফ ক\u{9cd}য\u{9be}লেন\u{9cd}ড\u{9be}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("deiziadur efemerid"),
            keywords: &["deiziadur", "deiziadur efemerid"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kalendar na kidanje"),
            keywords: &["kalendar", "kalendar na kidanje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("calendari de bloc"),
            keywords: &["bloc", "calendari", "calendari de bloc"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏯᎴᏍᏗ-ᏅᏓ ᏗᏎᏍᏗ"),
            keywords: &["ᎦᏯᎴᏍᏗ-ᏅᏓ ᏗᏎᏍᏗ", "ᏅᏓ ᏗᏎᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("trhací kalendář"),
            keywords: &["kalendář", "trhací kalendář"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("calendr rwygo"),
            keywords: &["calendr", "calendr rwygo"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kalenderblok"),
            keywords: &["afrivningskalender", "kalender", "kalenderblok"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Abreißkalender"),
            keywords: &["Abreißkalender", "Kalender"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Abreisskalender"),
            keywords: &["Abreisskalender", "Kalender"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ημερολόγιο με αποσπώμενες σελίδες"),
            keywords: &["ημερολόγιο", "ημερολόγιο με αποσπώμενες σελίδες"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("tear-off calendar"),
            keywords: &["calendar", "tear-off calendar"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("calendario recortable"),
            keywords: &["calendario", "calendario recortable", "fecha"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("calendario con hojas"),
            keywords: &["calendario", "calendario con hojas", "hojas"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "calendario",
                "calendario con hojas",
                "hojas",
                "hojas para arrancar",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("rebitav kalender"),
            keywords: &["kalender", "kuupäev", "rebitav kalender"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("orriak kentzeko egutegia"),
            keywords: &["egutegi", "orriak kentzeko egutegia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تقویم رومیزی"),
            keywords: &["تقویم", "تقویم رومیزی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("päiväkalenteri"),
            keywords: &["kalenteri", "päiväkalenteri"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pinipilas na kalendaryo"),
            keywords: &["kalendaryo", "petsa", "pinipilas na kalendaryo", "pinunit"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kalendari sum kann skræðast úr"),
            keywords: &[
                "dagfesting",
                "dagseting",
                "dato",
                "kalendari",
                "kalendari sum kann skræðast úr",
                "skræða",
                "tíðarfesting",
                "tíðarmerking",
                "álmanakki",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("éphéméride"),
            keywords: &["calendrier", "date", "éphéméride"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("calendrier à effeuiller"),
            keywords: &["calendrier", "calendrier à effeuiller", "éphéméride"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("féilire instróicthe"),
            keywords: &["féilire instróicthe", "féilire le stróiceadh"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("mìosachan le duilleagan a thig dheth"),
            keywords: &["mìosachan", "mìosachan le duilleagan a thig dheth"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("calendario de varias follas"),
            keywords: &[
                "arrancar",
                "calendario",
                "calendario de varias follas",
                "data",
                "follas",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("તારીખિય\u{ac1}\u{a82}"),
            keywords: &["ક\u{ac7}લ\u{ac7}ન\u{acd}ડર", "તારીખિય\u{ac1}\u{a82}"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kalanda da aka yage"),
            keywords: &["kalanda", "kalanda da aka yage"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לוח שנה לתלישת דפים"),
            keywords: &["יומן", "לוח שנה", "לוח שנה לתלישת דפים", "תאריך"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("फ\u{93c}ाड\u{93c}न\u{947} वाला क\u{948}ल\u{947}\u{902}डर"),
            keywords: &[
                "क\u{948}ल\u{947}\u{902}डर",
                "फ\u{93c}ाड\u{93c}न\u{947} वाला क\u{948}ल\u{947}\u{902}डर",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kalendar na trganje"),
            keywords: &["kalendar", "kalendar na trganje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fali naptár"),
            keywords: &["fali naptár", "naptár"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("պոկովի օրացույց"),
            keywords: &["պոկովի օրացույց", "օրացույց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kalender sobek"),
            keywords: &["kalender", "kalender sobek"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("dọkapụ kalịnda"),
            keywords: &["dọkapụ kalịnda", "kalịnda"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("dagatal með rifgötum"),
            keywords: &["dagatal", "dagatal með rifgötum"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("calendario a strappo"),
            keywords: &["calendario", "calendario a strappo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("日めくりカレンダー"),
            keywords: &[
                "カレンダー",
                "スケジュール",
                "予定",
                "日めくりカレンダー",
                "日付",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tanggalan suwek"),
            keywords: &["tanggalan", "tanggalan suwek"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მოსახევი კალენდარი"),
            keywords: &["კალენდარი", "მოსახევი კალენდარი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: None,
            keywords: &["awitay"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жыртпалы күнтізбе"),
            keywords: &["жыртпалы күнтізбе", "күнтізбе"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kalenderblok"),
            keywords: &["afrivningskalender", "kalender", "kalenderblok"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "សន\u{17d2}ល\u{17b9}កប\u{17d2}រត\u{17b7}ទ\u{17b7}នដែលត\u{17d2}រ\u{17bc}វហែកចេញ",
            ),
            keywords: &[
                "ប\u{17d2}រត\u{17b7}ទ\u{17b7}ន",
                "សន\u{17d2}ល\u{17b9}កប\u{17d2}រត\u{17b7}ទ\u{17b7}នដែលត\u{17d2}រ\u{17bc}វហែកចេញ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{cbf}ತ\u{ccd}ತುಹಾಕುವ ಕ\u{ccd}ಯಾಲ\u{cc6}ಂಡರ\u{ccd}"),
            keywords: &[
                "ಕ\u{cbf}ತ\u{ccd}ತುಹಾಕುವ ಕ\u{ccd}ಯಾಲ\u{cc6}ಂಡರ\u{ccd}",
                "ಕ\u{ccd}ಯಾಲ\u{cc6}ಂಡರ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("뜯어진 달력"),
            keywords: &["달력", "뜯어진 달력", "일정", "캘린더"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("तारीख दाखोवपी दिनदर\u{94d}शिका"),
            keywords: &["तारीख दाखोवपी दिनदर\u{94d}शिका", "दिनदर\u{94d}शिका"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тытма жылнаама"),
            keywords: &["жылнаама", "тытма жылнаама"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Ofräisskalenner"),
            keywords: &["Kalenner", "Ofräisskalenner"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປະຕ\u{eb4}ທ\u{eb4}ນແບບຈ\u{eb5}ກອອກ"),
            keywords: &[
                "ຈ\u{eb5}ກອອກ",
                "ປະຕ\u{eb4}ທ\u{eb4}ນ",
                "ປະຕ\u{eb4}ທ\u{eb4}ນແບບຈ\u{eb5}ກອອກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("nuplėšiamas kalendorius"),
            keywords: &["kalendorius", "nuplėšiamas kalendorius"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("noplēšamais kalendārs"),
            keywords: &["datums", "kalendārs", "noplēšamais kalendārs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("maramataka tīhae"),
            keywords: &["maramataka", "maramataka tīhae"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("календар на кинење"),
            keywords: &["датум", "календар", "календар на кинење"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കീറിക\u{d4d}കളയ\u{d3e}വ\u{d41}ന\u{d4d}ന കലണ\u{d4d}ടർ"),
            keywords: &[
                "കലണ\u{d4d}ടർ",
                "കീറിക\u{d4d}കളയ\u{d3e}വ\u{d41}ന\u{d4d}ന കലണ\u{d4d}ടർ",
                "കീറിയ കലണ\u{d4d}ടർ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("урдаг календарь"),
            keywords: &["календарь", "урдаг календарь"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("फाडण\u{94d}\u{200d}याच\u{947} क\u{945}ल\u{947}\u{902}डर"),
            keywords: &[
                "क\u{945}ल\u{947}\u{902}डर",
                "फाडण\u{94d}\u{200d}याच\u{947} क\u{945}ल\u{947}\u{902}डर",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kalendar koyak"),
            keywords: &["kalendar", "kalendar koyak"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kalendarju bil-karti jitqaċċtu"),
            keywords: &["kalendarju", "kalendarju bil-karti jitqaċċtu"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ရ\u{103d}က\u{103a}ဆ\u{102f}တ\u{103a} ပြက\u{1039}ခဒ\u{102d}န\u{103a}"),
            keywords: &[
                "ပြက\u{1039}ခဒ\u{102d}န\u{103a}",
                "ရ\u{103d}က\u{103a}ဆ\u{102f}တ\u{103a} ပြက\u{1039}ခဒ\u{102d}န\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("veggkalender"),
            keywords: &["kalender", "riv-av-kalender", "veggkalender"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("टियर-अफ-पात\u{94d}रो"),
            keywords: &["टियर-अफ-पात\u{94d}रो", "पात\u{94d}रो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("scheurkalender"),
            keywords: &["kalender", "scheurkalender"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("veggkalender"),
            keywords: &["kalender", "riv-av-kalender", "veggkalender"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଚ\u{b3f}ର\u{b3e} ଯ\u{b3e}ଇପ\u{b3e}ର\u{b41}ଥ\u{b3f}ବ\u{b3e} କ\u{b4d}ୟ\u{b3e}ଲେଣ\u{b4d}ଡର\u{b4d}\u{200c}",
            ),
            keywords: &[
                "କ\u{b4d}ୟ\u{b3e}ଲେଣ\u{b4d}ଡର\u{b4d}",
                "ଚ\u{b3f}ର\u{b3e} ଯ\u{b3e}ଇପ\u{b3e}ର\u{b41}ଥ\u{b3f}ବ\u{b3e} କ\u{b4d}ୟ\u{b3e}ଲେଣ\u{b4d}ଡର\u{b4d}\u{200c}",
                "ଚ\u{b3f}ର\u{b3f}ବ\u{b3e}ଯୋଗ\u{b4d}ୟ କ\u{b4d}ୟ\u{b3e}ଲେଣ\u{b4d}ଡର\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਫਟਿਆ ਹ\u{a4b}ਇਆ ਕ\u{a48}ਲ\u{a70}ਡਰ"),
            keywords: &["ਕ\u{a48}ਲ\u{a70}ਡਰ", "ਫਟਿਆ ਹ\u{a4b}ਇਆ ਕ\u{a48}ਲ\u{a70}ਡਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کیلنڈر پاڑو"),
            keywords: &["کیلنڈر", "کیلنڈر پاڑو"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kalẹ\u{301}nda Wé Pẹ\u{301}sin Fít Tiá Am Kọmọt"),
            keywords: &[
                "Kalẹ\u{301}nda",
                "Kalẹ\u{301}nda Wé Pẹ\u{301}sin Fít Tiá Am Kọmọt",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kalendarz z wyrywanymi kartkami"),
            keywords: &[
                "data",
                "kalendarz z wyrywanymi kartkami",
                "spirala",
                "zdzierany kalendarz",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د شلولو جنتري"),
            keywords: &["جنتري", "د شلولو جنتري"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("calendário com folhas destacáveis"),
            keywords: &[
                "calendário",
                "calendário com folhas destacáveis",
                "folhas destacáveis",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("calendário destacável"),
            keywords: &["calendário", "calendário destacável"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("calendar cu file detașabile"),
            keywords: &["calendar", "calendar cu file detașabile"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-643"),
            keywords: &["E10-643"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("отрывной календарь"),
            keywords: &["календарь", "листы", "отрывной"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("gukuraho kalendari"),
            keywords: &["gukuraho kalendari", "karendari"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٽوڙڻ وارو ڪئلينڊر"),
            keywords: &["ٽوڙڻ وارو ڪئلينڊر", "ڪئلينڊر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කොළ ඉරන ද\u{dd2}න දර\u{dca}ශනය"),
            keywords: &["කොළ ඉරන ද\u{dd2}න දර\u{dca}ශනය", "ද\u{dd2}න දර\u{dca}ශනය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("trhací kalendár"),
            keywords: &["kalendár", "trhací kalendár"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("koledar z odstranljivimi listi"),
            keywords: &["koledar", "koledar z odstranljivimi listi"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kaalandarka la jaro"),
            keywords: &["kaalandar", "kaalandarka la jaro"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kalendar që griset"),
            keywords: &["kalendar", "kalendar që griset"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("календар са одвојивим листовима"),
            keywords: &["кaлeндaр", "календар са одвојивим листовима"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kalendar sa odvojivim listovima"),
            keywords: &["kalendar", "kalendar sa odvojivim listovima"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("avdragbar kalender"),
            keywords: &["avdragbar kalender", "datum", "kalender"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kalenda unayoweza kuchana kurasa"),
            keywords: &["kalenda", "kalenda unayoweza kuchana kurasa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("தேதியைக\u{bcd} கிழித\u{bcd}தல\u{bcd}"),
            keywords: &[
                "கிழிக\u{bcd}கும\u{bcd} க\u{bbe}லண\u{bcd}டர\u{bcd}",
                "கிழிக\u{bcd}கும\u{bcd} க\u{bbe}லேண\u{bcd}டர\u{bcd}",
                "கிழிக\u{bcd}கும\u{bcd} ந\u{bbe}ட\u{bcd}க\u{bbe}ட\u{bcd}டி",
                "கிழிக\u{bcd}கும\u{bcd} ந\u{bbe}ள\u{bcd}க\u{bbe}ட\u{bcd}டி",
                "தேதியைக\u{bcd} கிழித\u{bcd}தல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "ప\u{c4d}రత\u{c3f} ర\u{c4b}జూ మ\u{c3e}ర\u{c4d}చ\u{c47} క\u{c4d}య\u{c3e}ల\u{c46}ండర\u{c4d}",
            ),
            keywords: &[
                "ప\u{c4d}రత\u{c3f} ర\u{c4b}జూ మ\u{c3e}ర\u{c4d}చ\u{c47} క\u{c4d}య\u{c3e}ల\u{c46}ండర\u{c4d}",
                "ర\u{c4b}జువ\u{c3e}ర\u{c40} క\u{c4d}య\u{c3e}ల\u{c46}ండర\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тақвими дарондашаванда"),
            keywords: &["тақвим", "тақвими дарондашаванда"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ปฏ\u{e34}ท\u{e34}นแบบฉ\u{e35}กออก"),
            keywords: &["ปฏ\u{e34}ท\u{e34}น", "ปฏ\u{e34}ท\u{e34}นแบบฉ\u{e35}กออก"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýyrtylýan senenama"),
            keywords: &["senenama", "ýyrtylýan senenama"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tohimāhina fakaʻaho"),
            keywords: &["tohimāhina fakaʻaho"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("koparmalı takvim"),
            keywords: &["koparmalı takvim", "takvim"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يىرتىق كالېندار"),
            keywords: &["كالېندار", "يىرتىق كالېندار"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("відривний календар"),
            keywords: &["відривний календар", "календар"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ٹیئر آف کیلنڈر"),
            keywords: &["اسٹیشنری", "قسم", "ٹیئر آف کیلنڈر", "کیلنڈر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yirtiladigan taqvim"),
            keywords: &["taqvim", "yirtiladigan taqvim"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("quyển lịch bloc"),
            keywords: &["lịch", "quyển lịch bloc"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("arminaatu xotti-kayit"),
            keywords: &["arminaat", "arminaatu xotti-kayit"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("krazula ikhalenda"),
            keywords: &["ikhalenda", "krazula ikhalenda"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("kàlẹ\u{301}ndà ti a ya"),
            keywords: &["kàlẹ\u{301}ndà", "kàlẹ\u{301}ndà ti a ya"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("可撕式日曆"),
            keywords: &["可撕式日曆", "日曆"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("可撕式日历"),
            keywords: &["可撕式日历", "日历"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("手撕日历"),
            keywords: &["手撕日历", "日历", "日期"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("日曆"),
            keywords: &["撕日曆", "日曆"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("撕開嘅日曆"),
            keywords: &["撕開嘅日曆"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ikhalenda elidabulekayo"),
            keywords: &["ikhalenda", "ikhalenda elidabulekayo"],
        },
    ],
};
#[doc = "🗒\u{fe0f}"]
pub const SPIRAL_NOTEPAD: crate::Emoji = crate::Emoji {
    glyph: "🗒\u{fe0f}",
    codepoint: "1F5D2 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "spiral notepad",
    group: "Objects",
    subgroup: "office",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🗒",
        codepoint: "1F5D2",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "spiral notepad",
        group: "Objects",
        subgroup: "office",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("spiraalnotaboek"),
            keywords: &["aantekening", "boek", "nota", "spiraal", "spiraalnotaboek"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ባለሽቦ ማስታወሻ ደብተር"),
            keywords: &["ማስታወሻ", "ሰሌዳ", "ባለሽቦ", "ባለሽቦ ማስታወሻ ደብተር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ورقة ملاحظات"),
            keywords: &["حلزوني", "ملاحظة", "ورقة", "ورقة ملاحظات"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("স\u{9cd}প\u{9be}ইৰেল টোক\u{9be}বহী"),
            keywords: &[
                "টোক\u{9be}",
                "বহী",
                "স\u{9cd}প\u{9be}ইৰেল",
                "স\u{9cd}প\u{9be}ইৰেল টোক\u{9be}বহী",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("spiral dəftər"),
            keywords: &["bloknot", "qeyd", "spiral", "spiral dəftər"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("перакідны нататнік"),
            keywords: &["блакнот", "лісты", "нататнік", "перакідны"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Бележник със спирала"),
            keywords: &["Бележник със спирала", "бележник", "спирала"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9cd}প\u{9be}ইর\u{9be}ল নোটপ\u{9cd}য\u{9be}ড"),
            keywords: &[
                "নোট",
                "পে\u{981}চ\u{9be}নো",
                "প\u{9cd}য\u{9be}ড",
                "স\u{9cd}প\u{9be}ইর\u{9be}ল নোটপ\u{9cd}য\u{9be}ড",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("blocʼh-notennoù gant troellennoù"),
            keywords: &[
                "blocʼh-notennoù",
                "blocʼh-notennoù gant troellennoù",
                "troellennoù",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("spiralni blokić"),
            keywords: &["blokić", "notes", "spiralni blokić", "spiralni uvez"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bloc de notes d’espiral"),
            keywords: &["bloc", "bloc de notes d’espiral", "espiral", "notes"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏄᏖᏲᎸ ᎪᏪᎶᏗ ᎪᏪᎵ"),
            keywords: &["ᎤᏍᏗ ᎪᏪᎵ", "ᎦᏄᏖᏲᎸ", "ᎦᏄᏖᏲᎸ ᎪᏪᎶᏗ ᎪᏪᎵ", "ᎪᏪᎶᏗ ᎪᏪᎵ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kroužkový zápisník"),
            keywords: &[
                "blok",
                "kroužkový zápisník",
                "kroužky",
                "poznámky",
                "spirálový",
                "zápisky",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("llyfr nodiadau troellog"),
            keywords: &[
                "llyfr nodiadau",
                "llyfr nodiadau troellog",
                "nodyn",
                "troellog",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("notesblok"),
            keywords: &["blok", "note", "noter", "notesblok", "spiral", "spiralryg"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Notizblock"),
            keywords: &["Block", "Notizblock"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σπιράλ σημειωματάριο"),
            keywords: &["σημείωμα", "σημειωματάριο", "σπιράλ"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("spiral notepad"),
            keywords: &["note", "pad", "spiral", "spiral notepad"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bloc de notas de espiral"),
            keywords: &[
                "bloc",
                "bloc de notas de espiral",
                "cuaderno",
                "espiral",
                "notas",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("bloc de notas con espiral"),
            keywords: &["anotador", "bloc de notas con espiral", "escribir", "notas"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("spiraalmärkmik"),
            keywords: &["spiraal", "spiraalmärkmik"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("koaderno kiribilduna"),
            keywords: &["blok", "kiribil", "koaderno kiribilduna", "ohar"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دفترچه\u{654} یادداشت سیمی"),
            keywords: &["دفترچه\u{654} یادداشت سیمی", "سیمی", "صفحه", "یادداشت"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kierrelehtiö"),
            keywords: &["kierre", "kierrelehtiö", "lehtiö", "muistio"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("spiral notepad"),
            keywords: &["notepad", "spiral notepad", "sulatan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("spiralheftur skriviblokkur"),
            keywords: &[
                "blokkur",
                "skriviblokkur",
                "snyril",
                "spiralheftur",
                "spiralur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bloc-notes à spirale"),
            keywords: &["bloc-notes à spirale", "notes"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ceap nótaí bíseach"),
            keywords: &["bíseach", "ceap", "ceap nótaí bíseach", "nóta"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("pada-nòtaichean le cuachag"),
            keywords: &["cuachag", "nòta", "pada", "pada-nòtaichean le cuachag"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("caderno de espiral"),
            keywords: &["caderno", "caderno de espiral", "escribir", "espiral"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}પાઇરલ નોટપ\u{ac7}ડ"),
            keywords: &[
                "નોટ",
                "પ\u{ac7}ડ",
                "સ\u{acd}પાઇરલ",
                "સ\u{acd}પાઇરલ નોટપ\u{ac7}ડ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("littafin rubutu mai lanƙwasawa"),
            keywords: &[
                "abin rubutu",
                "littafin rubutu mai lanƙwasawa",
                "mai lanƙwasawa",
                "rubutu",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פנקס עם ספירלה"),
            keywords: &["ספירלה", "פנקס", "פנקס עם ספירלה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{94d}पाइरल नोटप\u{948}ड"),
            keywords: &[
                "नोट",
                "प\u{948}ड",
                "स\u{94d}पाइरल नोटप\u{948}ड",
                "स\u{94d}पाइरल नोटप\u{948}ड, नोट, प\u{948}ड",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("spiralni notes"),
            keywords: &["bilješka", "blok", "spirala", "spiralni notes"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("spirálfüzet"),
            keywords: &["jegyzettömb", "spirál", "spirálfüzet", "tömb"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("պարուրավոր նոթատետր"),
            keywords: &["գրքույկ", "պարույր", "պարուրավոր նոթատետր", "տետր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("catatan spiral"),
            keywords: &["catatan", "kertas", "spiral"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("noòtùpaadị akpachiri"),
            keywords: &["mkpachi", "noòtù", "noòtùpaadị akpachiri", "paadị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("minnisblokk með gormum"),
            keywords: &["blokk", "glósa", "gormar", "minnisblokk með gormum"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("blocco per appunti con spirale"),
            keywords: &[
                "appuntare",
                "appunti",
                "blocchetto degli appunti",
                "blocco",
                "blocco a spirale",
                "blocco per appunti con spirale",
                "scrivere",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("メモ帳"),
            keywords: &["ノート", "メモ帳", "リングメモ", "文具", "文房具"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("buku cathetan spiral"),
            keywords: &["buku", "cathetan", "lemek", "spiral"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სპირალიანი ბლოკნოტი"),
            keywords: &["ბლოკნოტი", "სპირალიანი ბლოკნოტი", "სპირალური"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("спиралды дәптер"),
            keywords: &["ескертпе", "спирал", "спиралды дәптер", "тақта"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("notesblok"),
            keywords: &["blok", "note", "noter", "notesblok", "spiral", "spiralryg"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ក\u{17bc}នសៀវភៅកត\u{17cb}ត\u{17d2}រា"),
            keywords: &[
                "កត\u{17cb}ត\u{17d2}រា",
                "ក\u{17bc}នសៀវភៅ",
                "ក\u{17bc}នសៀវភៅកត\u{17cb}ត\u{17d2}រា",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{ccd}ಪೈರಲ\u{ccd} ನೋಟ\u{ccd}\u{200c}ಪ\u{ccd}ಯಾಡ\u{ccd}"),
            keywords: &[
                "ಟ\u{cbf}ಪ\u{ccd}ಪಣ\u{cbf}",
                "ಪ\u{ccd}ಯಾಡ\u{ccd}",
                "ಸ\u{ccd}ಪೈರಲ\u{ccd}",
                "ಸ\u{ccd}ಪೈರಲ\u{ccd} ನೋಟ\u{ccd}\u{200c}ಪ\u{ccd}ಯಾಡ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("스프링 노트"),
            keywords: &["노트", "노트 패드", "스프링 노트"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("नो\u{902}दपट\u{94d}टी"),
            keywords: &[
                "नो\u{902}द",
                "नो\u{902}दकरच\u{947}\u{902}",
                "नो\u{902}दपट\u{94d}टी",
                "प\u{945}ड",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("спиралдуу блокнот"),
            keywords: &["блокнот", "спиралдуу блокнот", "спираль"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Réngelchersnotizblock"),
            keywords: &["Block", "Notiz", "Réngelcher", "Réngelchersnotizblock"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some(
                "ແຜ\u{ec8}ນບ\u{eb1}ນທ\u{eb6}ກທ\u{eb5}\u{ec8}ມ\u{eb5}ສ\u{ebb}\u{ec9}ນແບບເປ\u{eb1}ນຫ\u{ec8}ວງ",
            ),
            keywords: &[
                "ບ\u{eb1}ນທ\u{eb6}ກ",
                "ຫ\u{ec8}ວງ",
                "ແຜ\u{ec8}ນ",
                "ແຜ\u{ec8}ນບ\u{eb1}ນທ\u{eb6}ກທ\u{eb5}\u{ec8}ມ\u{eb5}ສ\u{ebb}\u{ec9}ນແບບເປ\u{eb1}ນຫ\u{ec8}ວງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("užrašinė su spirale"),
            keywords: &["spiralė", "užrašas", "užrašinė", "užrašinė su spirale"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("bloknots ar spirāli"),
            keywords: &["bloknots", "bloknots ar spirāli", "piezīmes", "spirāle"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pukatuhi tōrino"),
            keywords: &["pukatuhi", "tuhipoka", "tōrino"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("тетратка со спирала"),
            keywords: &["бележник", "спирала", "тетратка", "тетратка со спирала"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d4d}\u{200c}പൈറൽ നോട\u{d4d}ട\u{d4d}പ\u{d3e}ഡ\u{d4d}"),
            keywords: &[
                "നോട\u{d4d}ട\u{d4d}",
                "പ\u{d3e}ഡ\u{d4d}",
                "സ\u{d4d}പൈറൽ",
                "സ\u{d4d}\u{200c}പൈറൽ നോട\u{d4d}ട\u{d4d}പ\u{d3e}ഡ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эргүүлдэг тэмдэглэлийн хуудас"),
            keywords: &[
                "тэмдэглэл",
                "хуудас",
                "эргүүлдэг тэмдэглэлийн хуудас",
                "эргүүлэх",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चक\u{94d}राकार नोटप\u{945}ड"),
            keywords: &[
                "चक\u{94d}राकार",
                "चक\u{94d}राकार नोटप\u{945}ड",
                "नोट",
                "प\u{945}ड",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pad nota pilin"),
            keywords: &["nota", "pad", "pilin"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("notepad spirali"),
            keywords: &["nota", "notepad spirali", "pad", "spirali"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "လ\u{103e}ည\u{1037}\u{103a}န\u{102d}\u{102f}င\u{103a}သည\u{1037}\u{103a} မ\u{103e}တ\u{103a}စ\u{102f}စာအ\u{102f}ပ\u{103a}",
            ),
            keywords: &[
                "မ\u{103e}တ\u{103a}စ\u{102f}",
                "မ\u{103e}တ\u{103a}စ\u{102f} စာအ\u{102f}တ\u{103a}",
                "လ\u{103e}ည\u{1037}\u{103a}န\u{102d}\u{102f}င\u{103a}သည\u{1037}\u{103a} မ\u{103e}တ\u{103a}စ\u{102f}စာအ\u{102f}တ\u{103a}",
                "လ\u{103e}ည\u{1037}\u{103a}န\u{102d}\u{102f}င\u{103a}သည\u{1037}\u{103a} မ\u{103e}တ\u{103a}စ\u{102f}စာအ\u{102f}ပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("spiralhefte"),
            keywords: &["blokk", "notat", "spiral", "spiralhefte"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}पाइरल नोटप\u{94d}याड"),
            keywords: &[
                "नोट",
                "प\u{94d}याड",
                "स\u{94d}पाइरल",
                "स\u{94d}पाइरल नोटप\u{94d}याड",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("schrijfblok met spiraal"),
            keywords: &[
                "notitie",
                "schrijfblok",
                "schrijfblok met spiraal",
                "spiraal",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("spiralhefte"),
            keywords: &["blokk", "notat", "spiral", "spiralhefte"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ସ\u{b4d}ପ\u{b3e}ଇର\u{b3e}ଲ\u{b4d}\u{200c} ନୋଟ\u{b4d}\u{200c}ପ\u{b4d}ୟ\u{b3e}ଡ\u{b4d}\u{200c}",
            ),
            keywords: &[
                "ନୋଟ\u{b4d}\u{200c}",
                "ପ\u{b4d}ୟ\u{b3e}ଡ\u{b4d}\u{200c}",
                "ସ\u{b4d}ପ\u{b3e}ଇର\u{b3e}ଲ\u{b4d}\u{200c}",
                "ସ\u{b4d}ପ\u{b3e}ଇର\u{b3e}ଲ\u{b4d}\u{200c} ନୋଟ\u{b4d}\u{200c}ପ\u{b4d}ୟ\u{b3e}ଡ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚ\u{a42}ੜੀਦਾਰ ਨ\u{a4b}ਟਪ\u{a48}ਡ"),
            keywords: &[
                "ਚ\u{a42}ੜੀਦਾਰ",
                "ਨ\u{a4b}ਟ",
                "ਨ\u{a4b}ਟਪ\u{a48}ਡ",
                "ਪ\u{a48}ਡ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سپائرل نوٹ پیڈ"),
            keywords: &["ر\u{64f}قعہ", "سپائرل نوٹ پیڈ", "مرغولے دار", "چارجامہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Spaírál Nótpad"),
            keywords: &["Not", "Pad", "Spaíral", "Spaírál Nótpad"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kołonotatnik"),
            keywords: &["kołonotatnik", "na spirali", "notatnik", "notes", "spirala"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("حلزوني يادښت پېډ"),
            keywords: &["حلزوني", "حلزوني يادښت پېډ", "ياددښت", "پېډ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bloco espiral"),
            keywords: &["bloco", "caderno", "espiral"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("bloco de notas com espiral"),
            keywords: &["bloco", "bloco de notas com espiral", "espiral", "notas"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("blocnotes cu spirală"),
            keywords: &["blocnotes cu spirală", "carnet", "spirală"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-820"),
            keywords: &["E10-820"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("перекидной блокнот"),
            keywords: &[
                "блокнот",
                "листы",
                "откидной",
                "перекидной блокнот",
                "пружина",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("Ikayi iteranyije akuma kigondoye"),
            keywords: &[
                "Ikayi iteranyije akuma kigondoye",
                "agakayi",
                "cyigondoye",
                "icyanditse",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اسپائرل نوٽ پيڊ"),
            keywords: &["اسپائرل", "نوٽ", "پيڊ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dca}පය\u{dd2}රල\u{dca} සටහන\u{dca} පෑඩය"),
            keywords: &[
                "පෑඩය",
                "සටහන",
                "ස\u{dca}පය\u{dd2}රල\u{dca}",
                "ස\u{dca}පය\u{dd2}රල\u{dca} සටහන\u{dca} පෑඩය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("špirálový zápisník"),
            keywords: &["poznámka", "zápisník", "špirála", "špirálový zápisník"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("spiralna beležnica"),
            keywords: &["beležka", "beležnica", "spirala", "spiralna beležnica"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("buug xaashiyiihiisa la rogo"),
            keywords: &[
                "buug xaashiyiihiisa la rogo",
                "buug xaashiyiihisa la rogo",
                "qorid",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("bllok shënimesh me spirale"),
            keywords: &[
                "bllok",
                "bllok shënimesh me spirale",
                "shënim",
                "spiral",
                "spirale",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("бележница са спиралом"),
            keywords: &["белeшкa", "бележница са спиралом", "блoк", "спирaлa"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("биљежница са спиралом"),
            keywords: &["биљежница са спиралом"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("beležnica sa spiralom"),
            keywords: &["beleška", "beležnica sa spiralom", "blok", "spirala"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("bilježnica sa spiralom"),
            keywords: &["bilježnica sa spiralom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("anteckningsblock"),
            keywords: &["anteckningar", "anteckningsblock", "block"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("daftari lililobanwa kwa waya wa mzunguko"),
            keywords: &[
                "daftari",
                "daftari lililobanwa kwa waya wa mzunguko",
                "dokezo",
                "mzunguko",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஸ\u{bcd}பைரல\u{bcd} நோட\u{bcd}பேடு"),
            keywords: &["நோட\u{bcd}பேடு", "ஸ\u{bcd}பைரல\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c4d}ప\u{c48}రల\u{c4d} న\u{c4b}ట\u{c4d} ప\u{c4d}య\u{c3e}డ\u{c4d}"),
            keywords: &[
                "న\u{c4b}ట\u{c4d}",
                "ప\u{c4d}య\u{c3e}డ\u{c4d}",
                "స\u{c4d}ప\u{c48}రల\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дафтари ёддошти печдор"),
            keywords: &[
                "дафтари ёддошт",
                "дафтари ёддошти печдор",
                "печдор",
                "тавзеҳ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("สม\u{e38}ดโน\u{e49}ตส\u{e31}นห\u{e48}วง"),
            keywords: &[
                "จด",
                "สม\u{e38}ด",
                "สม\u{e38}ดโน\u{e49}ตส\u{e31}นห\u{e48}วง",
                "ห\u{e48}วง",
                "โน\u{e49}ต",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("spirally depderçe"),
            keywords: &["bellik", "bloknot", "spiral", "spirally depderçe"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pepa fakamaʻu vilovilo"),
            keywords: &["pepa fakamaʻu vilovilo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("spiral not defteri"),
            keywords: &["defter", "not", "spiral", "spiral not defteri"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ھالقىسىمان خاتىرە"),
            keywords: &["تاختا", "خاتىرە", "ھالقا", "ھالقىسىمان خاتىرە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("блокнот на спіралі"),
            keywords: &["блокнот", "блокнот на спіралі", "на спіралі"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سپائرل نوٹ بک"),
            keywords: &["اسٹیشنری", "سپائرل", "سپائرل نوٹ بک", "نوٹ بک"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("spiralli yon daftarcha"),
            keywords: &["spiral", "spiralli yon daftarcha", "yon daftarcha"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("sổ ghi chú gáy xoắn"),
            keywords: &["ghi chú", "gáy xoắn", "sổ", "sổ ghi chú gáy xoắn"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bloknot bu am weñ"),
            keywords: &["am weñ", "blok", "bloknot bu am weñ", "not"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iphedi yamanqaku ejikelezayo"),
            keywords: &[
                "ejikelezayo",
                "inqaku",
                "iphedi",
                "iphedi yamanqaku ejikelezayo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("nóòtì páàdì alákápò\u{329}"),
            keywords: &[
                "nóòtì",
                "nóòtì páàdì alákápò\u{329}",
                "páàdì",
                "àkápọ\u{300}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("可揭式記事簿"),
            keywords: &["可揭式記事簿", "墊", "注釋", "螺旋"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("可揭式记事簿"),
            keywords: &["可揭式记事簿", "垫", "注释", "螺旋"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("线圈本"),
            keywords: &["文具", "笔记本", "线圈本", "记事本"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("線圈筆記本"),
            keywords: &["筆記本", "線圈筆記本"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("線圈筆記簿"),
            keywords: &["線圈筆記簿", "線圈筆記簿｜筆記簿"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("okokubhala okunezipringi"),
            keywords: &["izipringi", "okokubhala", "okokubhala okunezipringi"],
        },
    ],
};
#[doc = "🗓\u{fe0f}"]
pub const SPIRAL_CALENDAR: crate::Emoji = crate::Emoji {
    glyph: "🗓\u{fe0f}",
    codepoint: "1F5D3 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "spiral calendar",
    group: "Objects",
    subgroup: "office",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🗓",
        codepoint: "1F5D3",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "spiral calendar",
        group: "Objects",
        subgroup: "office",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("spiraalkalender"),
            keywords: &["almanak", "datum", "kalender", "spiraal", "spiraalkalender"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ባለሽቦ ቀን መቁጠሪያ"),
            keywords: &["ሰሌዳ", "ቀን መቁጠሪያ", "ባለሽቦ", "ባለሽቦ ቀን መቁጠሪያ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("تقويم حلزوني"),
            keywords: &["تقويم", "حلزوني", "ورقة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("স\u{9cd}প\u{9be}ইৰেল কেলেণ\u{9cd}ড\u{9be}ৰ"),
            keywords: &["কেলেণ\u{9cd}ড\u{9be}ৰ", "বহী", "স\u{9cd}প\u{9be}ইৰেল"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("spiral təqvim"),
            keywords: &["bloknot", "spiral", "təqvim"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("перакідны каляндар"),
            keywords: &["каляндар", "лісты", "перакідны"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Календар със спирала"),
            keywords: &["Календар със спирала", "календар", "спирала"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9cd}প\u{9be}ইর\u{9be}ল ক\u{9cd}য\u{9be}লেন\u{9cd}ড\u{9be}র"),
            keywords: &[
                "ক\u{9cd}য\u{9be}লেন\u{9cd}ড\u{9be}র",
                "পে\u{981}চ\u{9be}নো",
                "প\u{9cd}য\u{9be}ড",
                "স\u{9cd}প\u{9be}ইর\u{9be}ল ক\u{9cd}য\u{9be}লেন\u{9cd}ড\u{9be}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("deiziadur gant troellennoù"),
            keywords: &["deiziadur", "deiziadur gant troellennoù"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("spiralni kalendar"),
            keywords: &["kalendar", "spiralni kalendar"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("calendari d’espiral"),
            keywords: &["calendari", "calendari d’espiral", "espiral"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏄᏖᏲᎸ ᏅᏓ ᏗᏎᏍᏗ"),
            keywords: &["ᎦᏄᏖᏲᎸ", "ᎦᏄᏖᏲᎸ ᏅᏓ ᏗᏎᏍᏗ", "ᎪᏪᎶᏗ ᎪᏪᎵ", "ᏅᏓ ᏗᏎᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kroužkový kalendář"),
            keywords: &["kalendář", "kroužkový kalendář", "kroužky", "spirálový"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("calendr troellog"),
            keywords: &["calendr", "pad", "troellog"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("spiralkalender"),
            keywords: &["blok", "kalender", "spiral", "spiralkalender"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Spiralkalender"),
            keywords: &["Kalender", "Spiralkalender"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σπιράλ ημερολόγιο"),
            keywords: &["ημερολόγιο", "σημειωματάριο", "σπιράλ"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("spiral calendar"),
            keywords: &["calendar", "pad", "spiral"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("calendario de espiral"),
            keywords: &["calendario", "calendario de espiral", "espiral"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("calendario con espiral"),
            keywords: &["calendario", "calendario con espiral", "fechas"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("spiraalkalender"),
            keywords: &["kalender", "spiraal", "spiraalkalender"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("egutegi kiribilduna"),
            keywords: &["egutegi", "egutegi kiribilduna", "kiribil", "koaderno"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تقویم سیمی"),
            keywords: &["تقویم", "سیمی", "صفحه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kierrekalenteri"),
            keywords: &["kalenteri", "kierre", "kierrekalenteri", "lehtiö"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("spiral na kalendaryo"),
            keywords: &["kalendaryo", "spiral na kalendaryo", "sulatan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("spiralheftur kalendari"),
            keywords: &[
                "dagfesting",
                "dagseting",
                "dato",
                "kalendari",
                "spiralheftur",
                "tíðarfesting",
                "tíðarmerking",
                "álmanakki",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("calendrier à spirale"),
            keywords: &["calendrier", "calendrier à spirale"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("féilire bíseach"),
            keywords: &["bíseach", "ceap", "féilire"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("mìosachan le cuachag"),
            keywords: &["cuachag", "mìosachan", "mìosachan le cuachag", "pada"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("calendario de espiral"),
            keywords: &["calendario", "calendario de espiral", "data"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}પાઇરલ ક\u{ac5}લ\u{ac7}ન\u{acd}ડર"),
            keywords: &["ક\u{ac5}લ\u{ac7}ન\u{acd}ડર", "પ\u{ac7}ડ", "સ\u{acd}પાઇરલ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kalanda mai lanƙwasawa"),
            keywords: &[
                "abin rubutu",
                "kalanda",
                "kalanda mai lanƙwasawa",
                "mai lanƙwasawa",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לוח שנה עם ספירלה"),
            keywords: &["לוח שנה", "לוח שנה עם ספירלה", "ספירלה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{94d}पाइरल क\u{948}ल\u{947}\u{902}डर"),
            keywords: &["क\u{948}ल\u{947}\u{902}डर", "प\u{948}ड", "स\u{94d}पाइरल"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("spiralni kalendar"),
            keywords: &["blok", "kalendar", "spirala", "spiralni kalendar"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("spirálos naptár"),
            keywords: &["naptár", "spirál", "spirálos naptár", "tömb"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("պարուրավոր օրացույց"),
            keywords: &["գրքույկ", "պարույր", "պարուրավոր օրացույց", "օրացույց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kalender spiral"),
            keywords: &["kalender", "kertas", "spiral"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("kalịnda paadị akpachiri"),
            keywords: &["kalịnda", "kalịnda paadị akpachiri", "mkpachi", "paadị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("dagatal með gormum"),
            keywords: &["blokk", "dagatal", "dagatal með gormum", "gormar"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("calendario a spirale"),
            keywords: &["calendario a spirale", "giorni"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("月めくりカレンダー"),
            keywords: &[
                "カレンダー",
                "スケジュール",
                "予定",
                "日付",
                "月めくりカレンダー",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tanggalan spiral"),
            keywords: &["lemek", "spiral", "tanggalan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სპირალიანი კალენდარი"),
            keywords: &["კალენდარი", "სპირალიანი კალენდარი", "სპირალური"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("спиралды күнтізбе"),
            keywords: &["күнтізбе", "спирал", "спиралды күнтізбе", "тақта"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("spiralkalender"),
            keywords: &["blok", "kalender", "spiral", "spiralkalender"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17d2}រត\u{17b7}ទ\u{17b7}នតម\u{17d2}រៀបសន\u{17d2}ល\u{17b9}ក"),
            keywords: &[
                "ប\u{17d2}រត\u{17b7}ទ\u{17b7}ន",
                "ប\u{17d2}រត\u{17b7}ទ\u{17b7}នតម\u{17d2}រៀបសន\u{17d2}ល\u{17b9}ក",
                "ប\u{17d2}រត\u{17b7}ទ\u{17b7}នសន\u{17d2}ល\u{17b9}ក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{ccd}ಪೈರಲ\u{ccd} ಕ\u{ccd}ಯಾಲ\u{cc6}ಂಡರ\u{ccd}"),
            keywords: &[
                "ಕ\u{ccd}ಯಾಲ\u{cc6}ಂಡರ\u{ccd}",
                "ಪ\u{ccd}ಯಾಡ\u{ccd}",
                "ಸ\u{ccd}ಪೈರಲ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("스프링 달력"),
            keywords: &["달력", "벽걸이 달력", "스프링 달력"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("नो\u{902}दपट\u{94d}टी दिनदर\u{94d}शिका"),
            keywords: &["दिनदर\u{94d}शिका", "नो\u{902}दपट\u{94d}टी", "प\u{945}ड"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("спиралдуу жылнаама"),
            keywords: &["жылнаама", "спиралдуу жылнаама", "спираль"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Réngelcherskalenner"),
            keywords: &["Block", "Kalenner", "Réngelcher", "Réngelcherskalenner"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some(
                "ປະຕ\u{eb4}ທ\u{eb4}ນທ\u{eb5}\u{ec8}ມ\u{eb5}ສ\u{ebb}\u{ec9}ນແບບເປ\u{eb1}ນຫ\u{ec8}ວງ",
            ),
            keywords: &[
                "ປະຕ\u{eb4}ທ\u{eb4}ນ",
                "ປະຕ\u{eb4}ທ\u{eb4}ນທ\u{eb5}\u{ec8}ມ\u{eb5}ສ\u{ebb}\u{ec9}ນແບບເປ\u{eb1}ນຫ\u{ec8}ວງ",
                "ຫ\u{ec8}ວງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kalendorius su spirale"),
            keywords: &[
                "kalendorius",
                "kalendorius su spirale",
                "spiralė",
                "užrašinė",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kalendārs ar spirāli"),
            keywords: &["kalendārs", "kalendārs ar spirāli", "spirāle"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("maramataka tōrino"),
            keywords: &["maramataka", "pukatuhi", "tōrino"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("календар со спирала"),
            keywords: &["датум", "календар", "календар со спирала"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d4d}\u{200c}പൈറൽ കലണ\u{d4d}ടർ"),
            keywords: &["കലണ\u{d4d}ടർ", "പ\u{d3e}ഡ\u{d4d}", "സ\u{d4d}\u{200c}പൈറൽ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эргүүлдэг календарь"),
            keywords: &[
                "календарь",
                "нуруутай календарь",
                "тэмдэглэлийн дэвтэр",
                "эргүүлдэг календарь",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चक\u{94d}राकार क\u{945}ल\u{947}\u{902}डर"),
            keywords: &[
                "क\u{945}ल\u{947}\u{902}डर",
                "चक\u{94d}राकार",
                "चक\u{94d}राकार नोटप\u{945}ड",
                "प\u{945}ड",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kalendar pilin"),
            keywords: &["kalendar", "pad", "pilin"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kalendarju spirali"),
            keywords: &["kalendarju", "pad", "spirali"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "လ\u{103e}ည\u{1037}\u{103a}န\u{102d}\u{102f}င\u{103a}သည\u{1037}\u{103a} ပြက\u{1039}ခဒ\u{102d}န\u{103a}",
            ),
            keywords: &[
                "ပြက\u{1039}ခဒ\u{102d}န\u{103a}",
                "လ\u{103e}ည\u{1037}\u{103a}န\u{102d}\u{102f}င\u{103a}သည\u{1037}\u{103a} ပြက\u{1039}ခဒ\u{102d}န\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("spiralkalender"),
            keywords: &["blokk", "kalender", "spiral", "spiralkalender"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}पाइरल पात\u{94d}रो"),
            keywords: &["पात\u{94d}रो", "प\u{94d}याड", "स\u{94d}पाइरल"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kalender met spiraal"),
            keywords: &["blok", "kalender", "kalender met spiraal", "spiraal"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("spiralkalender"),
            keywords: &["blokk", "kalender", "spiral", "spiralkalender"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ସ\u{b4d}ପ\u{b3e}ଇର\u{b3e}ଲ\u{b4d}\u{200c} କ\u{b4d}ୟ\u{b3e}ଲେଣ\u{b4d}ଡର\u{b4d}\u{200c}",
            ),
            keywords: &[
                "କ\u{b4d}ୟ\u{b3e}ଲେଣ\u{b4d}ଡର\u{b4d}\u{200c}",
                "ପ\u{b4d}ୟ\u{b3e}ଡ\u{b4d}\u{200c}",
                "ସ\u{b4d}ପ\u{b3e}ଇର\u{b3e}ଲ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚ\u{a42}ੜੀਦਾਰ ਕ\u{a48}ਲ\u{a70}ਡਰ"),
            keywords: &["ਕ\u{a48}ਲ\u{a70}ਡਰ", "ਚ\u{a42}ੜੀਦਾਰ", "ਪ\u{a48}ਡ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سپائرل کیلنڈر"),
            keywords: &["سپائرل کیلنڈر", "مرغولے دار", "چارجامہ", "کیلنڈر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Spaírál Kalẹ\u{301}nda"),
            keywords: &["Kalẹ\u{301}nda", "Pad", "Spaíral", "Spaírál Kalẹ\u{301}nda"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kalendarz na spirali"),
            keywords: &[
                "kalendarz",
                "kalendarz na spirali",
                "na spirali",
                "notatnik",
                "notes",
                "spirala",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("حلزوني جنتري"),
            keywords: &["جنتري", "حلزوني", "پېډ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("calendário espiral"),
            keywords: &["bloco", "calendário", "espiral"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("calendário com espiral"),
            keywords: &["bloco", "calendário", "calendário com espiral", "espiral"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("calendar cu spirală"),
            keywords: &["calendar", "calendar cu spirală", "spirală"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-821"),
            keywords: &["E10-821"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("перекидной календарь"),
            keywords: &["календарь", "листы", "перекидной", "пружина"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("karendari iteranyije akuma kigondoye"),
            keywords: &[
                "agakayi",
                "cyigondoye",
                "karendari",
                "karendari iteranyije akuma kigondoye",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اسپائرل ڪئلينڊر"),
            keywords: &["اسپائرل", "پيڊ", "ڪئلينڊر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dca}පය\u{dd2}රල\u{dca} ද\u{dd2}න දර\u{dca}ශනය"),
            keywords: &[
                "ද\u{dd2}න දර\u{dca}ශනය",
                "පෑඩය",
                "ස\u{dca}පය\u{dd2}රල\u{dca}",
                "ස\u{dca}පය\u{dd2}රල\u{dca} ද\u{dd2}න දර\u{dca}ශනය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("špirálový kalendár"),
            keywords: &["kalendár", "špirála", "špirálový kalendár"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("spiralni koledar"),
            keywords: &["beležka", "koledar", "spirala", "spiralni koledar"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kaalandar la rogo"),
            keywords: &["kaalandar la rogo", "la rogo"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kalendar me spirale"),
            keywords: &["bllok", "kalendar", "kalendar me spirale", "spirale"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("календар са спиралом"),
            keywords: &["блок", "календар", "календар са спиралом", "спирала"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["календар са спиралом"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kalendar sa spiralom"),
            keywords: &["blok", "kalendar", "kalendar sa spiralom", "spirala"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["kalendar sa spiralom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("spiralbunden kalender"),
            keywords: &["kalender", "månadskalender", "spiralbunden kalender"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kalenda iliyofungwa kwa waya wa mzunguko"),
            keywords: &[
                "daftari",
                "kalenda",
                "kalenda iliyofungwa kwa waya wa mzunguko",
                "mzunguko",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஸ\u{bcd}பைரல\u{bcd} கேலெண\u{bcd}டர\u{bcd}"),
            keywords: &["கேலெண\u{bcd}டர\u{bcd}", "ஸ\u{bcd}பைரல\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c4d}ప\u{c48}రల\u{c4d} క\u{c4d}య\u{c3e}ల\u{c46}ండర\u{c4d}"),
            keywords: &[
                "క\u{c4d}య\u{c3e}ల\u{c46}ండర\u{c4d}",
                "స\u{c4d}ప\u{c48}రల\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тақвими печдор"),
            keywords: &["дафтари ёддошт", "печдор", "тақвим", "тақвими печдор"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ปฏ\u{e34}ท\u{e34}นส\u{e31}นห\u{e48}วง"),
            keywords: &[
                "ปฏ\u{e34}ท\u{e34}น",
                "ปฏ\u{e34}ท\u{e34}นส\u{e31}นห\u{e48}วง",
                "ห\u{e48}วง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("spirally senenama"),
            keywords: &["bloknot", "senenama", "spiral", "spirally senenama"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tohimāhina fakamaʻu vilovilo"),
            keywords: &["tohimāhina fakamaʻu vilovilo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("spiral takvim"),
            keywords: &["defter", "spiral", "takvim"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ھالقىسىمان كالېندار"),
            keywords: &["تاختا", "كالېندار", "ھالقا", "ھالقىسىمان كالېندار"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("календар на спіралі"),
            keywords: &["блокнот", "календар", "календар на спіралі", "на спіралі"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سپائرل کیلنڈر"),
            keywords: &["اسٹیشنری", "سپائرل", "کیلنڈر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ilma taqvim"),
            keywords: &["ilma", "spiral", "taqvim"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("lịch gáy xoắn"),
            keywords: &["gáy xoắn", "lịch", "lịch gáy xoắn"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("arminaat bu am weñ"),
            keywords: &["arminaat", "arminaat bu am weñ", "blok", "bu am weñ"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ikhalenda ejikelezayo"),
            keywords: &["ejikelezayo", "ikhalenda", "iphedi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("kàlẹ\u{301}ndà alákápọ\u{300}"),
            keywords: &[
                "kàlẹ\u{301}ndà",
                "kàlẹ\u{301}ndà alákápọ\u{300}",
                "páàdì",
                "àkápọ\u{300}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("可揭式日曆"),
            keywords: &["可揭式日曆", "墊", "日曆", "螺旋"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("可揭式日历"),
            keywords: &["可揭式日历", "垫", "日历", "螺旋"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("线圈日历"),
            keywords: &["日历", "日期", "线圈", "线圈日历"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("線圈日曆"),
            keywords: &["日曆", "線圈日曆"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ikhalenda lezipringi"),
            keywords: &["ikhalenda", "ikhalenda lezipringi", "izipringi"],
        },
    ],
};
#[doc = "📇"]
pub const CARD_INDEX: crate::Emoji = crate::Emoji {
    glyph: "📇",
    codepoint: "1F4C7",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "card index",
    group: "Objects",
    subgroup: "office",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kaartindeks"),
            keywords: &["indeks", "kaart", "kaartindeks", "nommers"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ካርድ መጥቁም"),
            keywords: &["መጥቁም", "ሮሎዴክስ", "ካርታ", "ካርድ መጥቁም"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("فهرس بطاقات"),
            keywords: &["فهرس", "فهرس بطاقات"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9be}ৰ\u{9cd}ড ইনডেক\u{9cd}স"),
            keywords: &["ইনডেক\u{9cd}স", "ক\u{9be}ৰ\u{9cd}ড", "ৰ’ল’ডেক\u{9cd}স"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kart indeksi"),
            keywords: &["işarə", "kart", "kart indeksi", "rolodeks"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("картатэка"),
            keywords: &["картатэка", "картка", "каталог", "паказальнік"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Картотека"),
            keywords: &["Картотека", "карта", "картотека", "показалец"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9be}র\u{9cd}ডের স\u{9c2}চী"),
            keywords: &[
                "ক\u{9be}র\u{9cd}ড",
                "ক\u{9be}র\u{9cd}ডের স\u{9c2}চী",
                "রোলোডেক\u{9cd}স",
                "স\u{9c2}চক",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("karned chomlecʼhioù"),
            keywords: &["chomlecʼhioù", "karned"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("rotirajući stalak za vizit kartice"),
            keywords: &[
                "rotirajući stalak za vizit kartice",
                "vizit kartica",
                "vizitka",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("organitzador de targetes"),
            keywords: &["organitzador", "organitzador de targetes", "targetes"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᏆᏂᏲᏍᏗ ᎠᏍᏓᏩᏛᏍᏗ"),
            keywords: &["ᎠᏍᏓᏩᏛᏍᏗ", "ᏆᏂᏲᏍᏗ", "ᏗᎵᏐᏆᎴᎯᎭ ᏗᎪᏪᎵ", "ᏗᏆᏂᏲᏍᏗ ᎠᏍᏓᏩᏛᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("vizitkovník"),
            keywords: &["karta", "kartotéka", "vizitka", "vizitkovník"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("mynegai cardiau"),
            keywords: &["card", "mynegai", "mynegai cardiau", "rolodex"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kartotek"),
            keywords: &["indekskort", "kartotek", "kontakter"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Rotationskartei"),
            keywords: &["Rotationskartei", "Visitenkarten"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ευρετήριο καρτών"),
            keywords: &["ευρετήριο", "ευρετήριο καρτών", "κάρτα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("card index"),
            keywords: &["card", "index", "rolodex"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("index card"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("organizador de fichas"),
            keywords: &[
                "cartera",
                "ficha",
                "organizador",
                "organizador de fichas",
                "tarjetas",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["Rolodex", "organizador de fichas", "índice"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kataloog"),
            keywords: &["kaart", "kataloog", "register"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("txartel-euskarria"),
            keywords: &["euskarri", "txartel", "txartel-euskarria"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کارت\u{200c}های راهنما"),
            keywords: &["راهنما", "رولودکس", "کارت", "کارت\u{200c}های راهنما"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kortisto"),
            keywords: &["kortisto", "kortti", "rolodex"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("card index"),
            keywords: &["card", "index", "rolodex"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kartotek"),
            keywords: &["kartotek", "kortsavn", "seðlasavn", "seðlaskrá"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("carnet d’adresses"),
            keywords: &["carnet d’adresses", "fiche", "index", "rolodex"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("fiche"),
            keywords: &["carte", "fiche", "index", "rolodex"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("innéacs cártaí"),
            keywords: &["innéacs", "innéacs cártaí"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("clàr-amais chairtean"),
            keywords: &["cairt", "clàr-amais", "clàr-amais chairtean", "rolodex"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("organizador de tarxetas"),
            keywords: &[
                "organizador",
                "organizador de tarxetas",
                "tarxetas",
                "tarxetas de visita",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કાર\u{acd}ડ અન\u{ac1}ક\u{acd}રમ"),
            keywords: &[
                "ઇન\u{acd}ડ\u{ac7}ક\u{acd}સ",
                "કાર\u{acd}ડ અન\u{ac1}ક\u{acd}રમ",
                "રોલોડ\u{ac7}ક\u{acd}સ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("katin fihirisa"),
            keywords: &["fihirisa", "kati", "katin fihirisa", "rolodex"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כרטסת"),
            keywords: &["כרטיסיות", "כרטסת", "רולודקס"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("कार\u{94d}ड इ\u{902}ड\u{947}क\u{94d}स"),
            keywords: &[
                "इ\u{902}ड\u{947}क\u{94d}स",
                "कार\u{94d}ड इ\u{902}ड\u{947}क\u{94d}स",
                "रोलोड\u{947}क\u{94d}स",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kartoteka"),
            keywords: &["indeks", "kartice", "kartoteka", "rolodex"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("forgó névjegykártyatartó"),
            keywords: &[
                "forgó",
                "forgó névjegykártyatartó",
                "kártya",
                "rolodex",
                "tartó",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("քարտադարան"),
            keywords: &["ինդեքս", "քարտ", "քարտադարան"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("indeks kartu"),
            keywords: &["indeks", "kartu", "rolodex"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("kaadị indek"),
            keywords: &["indek", "kaadị", "rolodexi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("spjaldskrá"),
            keywords: &["spjaldskrá", "uppflettiskrá"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("schedario"),
            keywords: &["rolodex", "schedario", "schedario girevole"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("カードインデックス"),
            keywords: &["カードインデックス", "名刺ホルダー", "文具", "文房具"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("indeks kertu"),
            keywords: &["indeks", "kertu", "rolodeks"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბარათებიანი საძიებელი"),
            keywords: &["ბარათებიანი საძიებელი", "საძიებელი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("карта индексі"),
            keywords: &["индекс", "карта", "карта индексі", "картотека"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kartotek"),
            keywords: &["indekskort", "kartotek", "kontakter"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17d2}រដាប\u{17cb}ព\u{17d2}យ\u{17bd}រកាត"),
            keywords: &["កាត", "ប\u{17d2}រដាប\u{17cb}ព\u{17d2}យ\u{17bd}រកាត"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಾರ\u{ccd}ಡ\u{ccd} ಸ\u{cc2}ಚ\u{ccd}ಯಂಕ"),
            keywords: &[
                "ಕಾರ\u{ccd}ಡ\u{ccd} ಸ\u{cc2}ಚ\u{ccd}ಯಂಕ",
                "ರೊಲೊಡ\u{cc6}ಕ\u{ccd}ಸ\u{ccd}",
                "ಸ\u{cc2}ಚ\u{ccd}ಯಂಕ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("카드 인덱스"),
            keywords: &["명함", "인덱스", "카드"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("कार\u{94d}ड इ\u{902}ड\u{947}क\u{94d}स"),
            keywords: &[
                "इ\u{902}ड\u{947}क\u{94d}स",
                "कार\u{94d}ड",
                "रोलोड\u{947}क\u{94d}स",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("картотека"),
            keywords: &["индекс", "карта", "картотека"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Indexkaart"),
            keywords: &["Index", "Indexkaart", "Kaart", "Rolodex"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກ\u{ec8}ອງໃສ\u{ec8}ບ\u{eb1}ດ"),
            keywords: &["ກ\u{ec8}ອງ", "ກ\u{ec8}ອງໃສ\u{ec8}ບ\u{eb1}ດ", "ບ\u{eb1}ດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kortelių dėklas"),
            keywords: &["dėklas", "indeksas", "kortelių dėklas", "kortelė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kartīšu rādītājs"),
            keywords: &["kartīte", "kartīšu rādītājs", "rādītājs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kuputohu ā-kāri"),
            keywords: &["kuputohu", "kuputohu ā-kāri", "kāri", "rolodex"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("држач за картички"),
            keywords: &["визитки", "држач за картички", "картички"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d3e}ർഡ\u{d4d} ഇൻഡക\u{d4d}\u{200c}സ\u{d4d}"),
            keywords: &[
                "ഇൻഡക\u{d4d}സ\u{d4d}",
                "ക\u{d3e}ർഡ\u{d4d} ഇൻഡക\u{d4d}\u{200c}സ\u{d4d}",
                "റോളോഡെക\u{d4d}സ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("картын индекс"),
            keywords: &[
                "карт",
                "картын индекс",
                "тэмдэглэлийн цаас",
                "эргэдэг тэмдэглэлийн цаас",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कार\u{94d}ड अन\u{941}क\u{94d}रमणिका"),
            keywords: &[
                "अन\u{941}क\u{94d}रमणिका",
                "कार\u{94d}ड",
                "रोलोड\u{947}क\u{94d}स",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("indeks kad"),
            keywords: &["indeks", "kad", "rolodex"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("indiċi tal-kards"),
            keywords: &["indiċi", "indiċi tal-kards", "kard", "rolodex"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကဒ\u{103a} အည\u{103d}\u{103e}န\u{103a}း"),
            keywords: &[
                "ကတ\u{103a}",
                "ကဒ\u{103a} အည\u{103d}\u{103e}န\u{103a}း",
                "ရ\u{102d}\u{102f}လ\u{102d}\u{102f}ဒက\u{103a}စ\u{103a}",
                "အည\u{103d}\u{103e}န\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kartotek"),
            keywords: &["indeks", "kartotek", "register"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कार\u{94d}ड स\u{942}चक"),
            keywords: &["कार\u{94d}ड", "रोलोड\u{947}क\u{94d}स", "स\u{942}चक"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kaartindex"),
            keywords: &["index", "kaart", "kaartindex", "rolodex"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kartotek"),
            keywords: &["indeks", "kartotek", "register"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b3e}ର\u{b4d}ଡ\u{b4d} ଅନ\u{b41}କ\u{b4d}ରମଣ\u{b3f}କ\u{b3e}"),
            keywords: &[
                "ଇଣ\u{b4d}ଡେକ\u{b4d}ସ",
                "କ\u{b3e}ର\u{b4d}ଡ ଅନ\u{b41}କ\u{b4d}ରମଣ\u{b3f}କ\u{b3e}",
                "କ\u{b3e}ର\u{b4d}ଡ\u{b4d} ଅନ\u{b41}କ\u{b4d}ରମଣ\u{b3f}କ\u{b3e}",
                "କ\u{b3e}ର\u{b4d}ଡ\u{b4d} ଇଣ\u{b4d}ଡେକ\u{b4d}ସ",
                "ରୋଲୋଡେକ\u{b4d}ସ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਾਰਡ ਸ\u{a42}\u{a42}ਚੀ"),
            keywords: &[
                "ਕਾਰਡ ਇ\u{a70}ਡ\u{a48}ਕਸ",
                "ਕਾਰਡ ਸ\u{a42}\u{a42}ਚੀ",
                "ਰ\u{a4b}ਲ\u{a4b}ਡ\u{a48}ਕਸ ਇ\u{a70}ਡ\u{a48}ਕਸ",
                "ਸ\u{a42}ਚੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("انڈیکس کارڈ"),
            keywords: &["انڈیکس کارڈ", "رولوڈکس", "ضمینہ", "کارڈ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kád Índẹks"),
            keywords: &["Kád", "Rólódẹks", "Índẹks"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wizytownik"),
            keywords: &["wizytownik", "wizytówka", "wizytówki"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کارت جدول"),
            keywords: &["جدول", "رولوډاکس", "کارت"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("índice de cartões"),
            keywords: &["índice", "índice de cartões"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("fichas"),
            keywords: &["ficha", "fichas", "rolodex"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("repertoriu"),
            keywords: &[
                "cărți de vizită",
                "fișier rotativ",
                "index",
                "index de carduri",
                "repertoriu",
                "rolodex",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-644"),
            keywords: &["E10-644"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("органайзер"),
            keywords: &["картотека", "органайзер", "указатели"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ifishi"),
            keywords: &["ifishi", "ikarita", "rolodegisi", "urutonde"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪارڊ انڊيڪس"),
            keywords: &["ترتيب", "رولوڊيڪس", "ڪارڊ", "ڪارڊ انڊيڪس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dcf}ඩ\u{dca}පත\u{dca} දර\u{dca}ශකය"),
            keywords: &[
                "ඉන\u{dca}ඩෙක\u{dca}ස\u{dca}",
                "ක\u{dcf}ඩ\u{dca}",
                "ක\u{dcf}ඩ\u{dca}පත\u{dca} දර\u{dca}ශකය",
                "රෝලොඩෙක\u{dca}ස\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("otáčací stojan na vizitky"),
            keywords: &["index", "karta", "otáčací stojan na vizitky", "vizitka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("organizator vizitk"),
            keywords: &["kartica", "kartoteka", "organizator vizitk"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("nidaaminta kaararka"),
            keywords: &["kaar", "kaar nidaamiye", "nidaamin", "nidaaminta kaararka"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("katalog skedash"),
            keywords: &["indeks", "katalog", "katalog skedash", "letër", "skedë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("каталог картица"),
            keywords: &["картица", "каталог", "ролодекс"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["каталог картица"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("katalog kartica"),
            keywords: &["kartica", "katalog", "rolodeks"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["katalog kartica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kortregister"),
            keywords: &["kortregister", "register"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kadi"),
            keywords: &["farahasa", "kadi", "mwongozo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("க\u{bbe}ர\u{bcd}டு இன\u{bcd}டெக\u{bcd}ஸ\u{bcd}"),
            keywords: &[
                "க\u{bbe}ர\u{bcd}டு இன\u{bcd}டெக\u{bcd}ஸ\u{bcd}",
                "ரோலிங\u{bcd} பேப\u{bcd}பர\u{bcd}",
                "வரிசை",
                "வரிசை எண\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c3e}ర\u{c4d}డ\u{c4d} సూచ\u{c3f}క"),
            keywords: &["క\u{c3e}ర\u{c4d}డ\u{c4d} సూచ\u{c3f}క", "సూచ\u{c3f}క"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("индекси корт"),
            keywords: &["индекси корт", "картотека", "корт", "нишондиҳанда"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ท\u{e35}\u{e48}ใส\u{e48}บ\u{e31}ตร"),
            keywords: &[
                "ด\u{e31}ชน\u{e35}",
                "ท\u{e35}\u{e48}ใส\u{e48}บ\u{e31}ตร",
                "บ\u{e31}ตร",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kart indeksi"),
            keywords: &["indeks", "kart", "kart indeksi", "rolodeks"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tohi fakahinohino fakamaʻu vilovilo"),
            keywords: &["tohi fakahinohino fakamaʻu vilovilo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kart dizini"),
            keywords: &["dizin", "kart dizini", "rolodeks"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كارتا كۆرسەتكۈچ"),
            keywords: &["ئايلانما", "ئىندېكس", "كارتا", "كارتا كۆرسەتكۈچ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("картотека"),
            keywords: &["картотека", "указівник", "індекс"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کارڈ انڈیکس"),
            keywords: &["اسٹیشنری", "انڈیکس", "کارڈ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kartoteka"),
            keywords: &["indeks", "kartochka", "kartoteka"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("chỉ mục thẻ"),
            keywords: &["chỉ mục", "chỉ mục thẻ", "hộp danh thiếp", "thẻ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("limu këyit"),
            keywords: &["kàrt", "limu", "limu këyit", "rolodex"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ikhadi leindeksi"),
            keywords: &["i-indeksi", "i-rolodex", "ikhadi", "ikhadi leindeksi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("káàdì àtòjọ atọ\u{301}kà-ọ\u{300}rọ\u{300}"),
            keywords: &[
                "fáìlì oní káàdì",
                "káàdì",
                "káàdì àtòjọ atọ\u{301}kà-ọ\u{300}rọ\u{300}",
                "àtòjọ atọ\u{301}ka-ọ\u{300}rọ\u{300}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("卡片索引"),
            keywords: &["卡片", "卡片盒", "卡片索引", "索引"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("卡片索引"),
            keywords: &["卡片", "卡片盒", "卡片索引", "索引"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("卡片索引"),
            keywords: &["卡片", "卡片索引", "卡牌索引", "目录", "索引"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("索引卡"),
            keywords: &["索引卡"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["卡片盒", "卡片索引", "名片盒", "索引卡"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("okokuhlela amakhadi"),
            keywords: &["ikhadi", "irolodeksi", "okokuhlela amakhadi", "ukuhlela"],
        },
    ],
};
#[doc = "📈"]
pub const CHART_INCREASING: crate::Emoji = crate::Emoji {
    glyph: "📈",
    codepoint: "1F4C8",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "chart increasing",
    group: "Objects",
    subgroup: "office",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("grafiek wat styg"),
            keywords: &[
                "grafiek",
                "grafiek wat styg",
                "groei",
                "statistiek",
                "styging",
                "tendens",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሚጨምር ገበታ"),
            keywords: &["ሰንጠረዥ", "አዝማሚያ", "ዕድገት", "የሚጨምር ገበታ", "ገበታ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("اتجاه لأعلى"),
            keywords: &["اتجاه لأعلى", "ارتفاع", "مخطط"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ঊৰ\u{9cd}ধগ\u{9be}মী লেখচিত\u{9cd}ৰ"),
            keywords: &[
                "ঊৰ\u{9cd}ধগ\u{9be}মী লেখচিত\u{9cd}ৰ",
                "ঊৰ\u{9cd}ধম\u{9c1}খী",
                "গতিধ\u{9be}ৰ\u{9be}",
                "গ\u{9cd}ৰ\u{9be}ফ\u{9cd}",
                "বৰ\u{9cd}ধন",
                "লেখচিত\u{9cd}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qalxan qrafik"),
            keywords: &[
                "artım",
                "cədvəl",
                "qalxan qrafik",
                "qrafik",
                "trend",
                "yuxarı",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("дыяграма росту"),
            keywords: &["графік", "дыяграма", "дыяграма росту", "рост", "тэндэнцыя"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Диаграма с възходяща тенденция"),
            keywords: &[
                "Диаграма с възходяща тенденция",
                "диаграма",
                "нагоре",
                "ръст",
                "тенденция",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9cd}রমবর\u{9cd}ধম\u{9be}ন চ\u{9be}র\u{9cd}ট"),
            keywords: &[
                "উর\u{9cd}ধ\u{9cd}বম\u{9c1}খী",
                "ক\u{9cd}রমবর\u{9cd}ধম\u{9be}ন চ\u{9be}র\u{9cd}ট",
                "গ\u{9cd}র\u{9be}ফ",
                "চ\u{9be}র\u{9cd}ট",
                "প\u{9cd}রবণত\u{9be}",
                "ব\u{9c3}দ\u{9cd}ধি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("krommenn kreskiñ"),
            keywords: &["diagramm", "grafik", "kreskiñ", "krommenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("dijagram rasta"),
            keywords: &["dijagram", "dijagram rasta", "grafikon", "rast"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("gràfic d’augment"),
            keywords: &[
                "a l’alta",
                "augment",
                "gràfic",
                "gràfic d’augment",
                "tendència",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎧᏃᎮᏓ ᏓᏟᎶᏍᏛ ᎧᏁᏉᎬᎢ"),
            keywords: &[
                "ᎤᏪᏋᏒᎢ",
                "ᎦᎵᎦᎳ",
                "ᎦᎸᎳᏓᎦᏘ",
                "ᎧᏃᎮᏓ ᏓᏟᎶᏍᏛ",
                "ᎧᏃᎮᏓ ᏓᏟᎶᏍᏛ ᎧᏁᏉᎬᎢ",
                "ᏓᏟᎶᏍᏛ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("rostoucí graf"),
            keywords: &["graf", "rostoucí graf", "růst", "trend", "vzestupný"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("siart yn cynyddu"),
            keywords: &["graff", "i fyny", "siart", "siart yn cynyddu", "twf"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("opadgående graf"),
            keywords: &["graf", "opadgående graf", "tendens"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Aufwärtstrend"),
            keywords: &["Aufwärtstrend", "Diagramm", "Kurve", "steigend"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ανοδικό γράφημα"),
            keywords: &["ανοδικό γράφημα", "αύξηση", "γράφημα", "διάγραμμα", "τάση"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("chart increasing"),
            keywords: &[
                "chart",
                "chart increasing",
                "graph",
                "growth",
                "trend",
                "upward",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("graph increasing"),
            keywords: &[
                "chart",
                "chart increasing",
                "graph",
                "graph increasing",
                "growth",
                "trend",
                "upward",
            ],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("gráfica de evolución ascendente"),
            keywords: &[
                "ascendente",
                "gráfica",
                "gráfica de evolución ascendente",
                "gráfico",
                "tendencia ascendente",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("tendencia ascendente"),
            keywords: &[
                "alza",
                "ascendente",
                "aumentar",
                "gráfico",
                "mejor",
                "mejorar",
                "tabla",
                "tendencia ascendente",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "alza",
                "ascendente",
                "gráfico",
                "tabla",
                "tendencia ascendente",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "alza",
                "ascendente",
                "gráfico",
                "tabla",
                "tendencia ascendente",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("tõusev graafik"),
            keywords: &["graafik", "kasv", "tendents", "tõusev graafik", "üles"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("diagrama gorakorra"),
            keywords: &[
                "diagrama",
                "diagrama gorakorra",
                "gora",
                "grafiko",
                "hazkuntza",
                "joera",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نمودار صعودی"),
            keywords: &["رشد", "صعودی", "نمودار", "گراف", "گرایش"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("nouseva käyrä"),
            keywords: &[
                "kaavio",
                "kasvu",
                "käyrä",
                "nouseva käyrä",
                "nousu",
                "suuntaus",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tumataas na chart"),
            keywords: &[
                "graph",
                "paglago",
                "pataas",
                "tsart",
                "tumataas na chart",
                "uso",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("strikumynd við vøkstri"),
            keywords: &[
                "diagramm",
                "rásmynd",
                "strikumynd",
                "strikumynd við vøkstri",
                "upp",
                "veksur",
                "vøkstur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("graphique en hausse"),
            keywords: &["graphique", "graphique en hausse", "hausse", "tendance"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "croissance",
                "graphique",
                "graphique en hausse",
                "hausse",
                "tendance",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cairt mhéadaitheach"),
            keywords: &["cairt mhéadaitheach", "graf", "treocht mhéadaitheach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cairt a’ dol suas"),
            keywords: &[
                "cairt",
                "cairt a’ dol suas",
                "fàs",
                "graf",
                "suas",
                "treand",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("gráfico con tendencia ascendente"),
            keywords: &[
                "alza",
                "gráfica",
                "gráfico",
                "gráfico con tendencia ascendente",
                "tendencia",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઉ\u{a82}ચ\u{ac7} જતો ચાર\u{acd}ટ"),
            keywords: &[
                "આલ\u{ac7}ખ",
                "ઉ\u{a82}ચ\u{ac7} જતો ચાર\u{acd}ટ",
                "ઉ\u{a82}ચ\u{ac7}ના વલણનો ચાર\u{acd}ટ",
                "ઉ\u{a82}ચ\u{ac7}ન\u{ac1}\u{a82} વલણ",
                "ઉપરની તરફ",
                "ચાર\u{acd}ટ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("zanen-lissafi mai ƙarawa"),
            keywords: &[
                "salo",
                "zane",
                "zanen lissafi",
                "zanen-lissafi mai ƙarawa",
                "zuwa sama",
                "ƙarawa",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גרף עולה"),
            keywords: &["גידול", "גרף", "למעלה", "מגמה", "עולה", "תרשים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बढ\u{93c}त\u{947} र\u{941}झान वाला चार\u{94d}ट"),
            keywords: &[
                "ग\u{94d}राफ\u{93c}",
                "चार\u{94d}ट",
                "बढ\u{93c}ता र\u{941}झान",
                "बढ\u{93c}ता ह\u{941}आ",
                "बढ\u{93c}त\u{947} र\u{941}झान वाला चार\u{94d}ट",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("grafikon uzlaznog trenda"),
            keywords: &[
                "grafikon",
                "grafikon uzlaznog trenda",
                "rast",
                "uzlazni trend",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("növekvő diagram"),
            keywords: &[
                "diagram",
                "felfelé",
                "növekedés",
                "növekvő diagram",
                "trend",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("աճող դիագրամ"),
            keywords: &["աճ", "աճող դիագրամ", "գրաֆիկ", "դիագրամ", "միտում", "վեր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bagan meningkat"),
            keywords: &[
                "bagan",
                "bagan meningkat",
                "grafik",
                "naik",
                "pertumbuhan",
                "tren",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("mmụba chaati"),
            keywords: &[
                "chaati",
                "grafụ",
                "mmụba chaati",
                "nla n’elu",
                "otiti",
                "trendi",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("á uppleið"),
            keywords: &["graf á uppleið", "á uppleið"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("grafico con andamento positivo"),
            keywords: &[
                "andamento ascendente",
                "ascendente",
                "grafico",
                "grafico con andamento positivo",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("グラフ上向き"),
            keywords: &["グラフ", "グラフ上向き", "上向き", "上昇", "折れ線グラフ"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("grafik mundhak"),
            keywords: &["grafik", "grafik mundhak", "mendhuwur", "munggah", "tren"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ზრდადი გრაფიკი"),
            keywords: &["გრაფიკი", "დიაგრამა", "ზრდა", "ზრდადი", "ტენდენცია"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("өсім туралы диаграмма"),
            keywords: &[
                "график",
                "диаграмма",
                "жоғарыға",
                "тренд",
                "өсім",
                "өсім туралы диаграмма",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("opadgående graf"),
            keywords: &["graf", "opadgående graf", "tendens"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("តារាងក\u{17c6}ណើន\u{200b}"),
            keywords: &["ក\u{17c6}ណើន\u{200b}", "តារាង", "តារាងក\u{17c6}ណើន\u{200b}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಏರುತ\u{ccd}ತ\u{cbf}ರುವ ಚಾರ\u{ccd}ಟ\u{ccd}"),
            keywords: &[
                "ಏರುತ\u{ccd}ತ\u{cbf}ರುವ ಚಾರ\u{ccd}ಟ\u{ccd}",
                "ಗ\u{ccd}ರಾಫ\u{ccd}",
                "ಚಾರ\u{ccd}ಟ\u{ccd}",
                "ಪ\u{ccd}ರವೃತ\u{ccd}ತ\u{cbf}ಯಲ\u{ccd}ಲ\u{cbf} ಏರ\u{cbf}ಕ\u{cc6} ಚಾರ\u{ccd}ಟ\u{ccd}",
                "ಮೇಲ\u{ccd}ಮುಖವಾಗ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("상승하는 그래프"),
            keywords: &["그래프", "상승하는 그래프", "상향", "호황"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("चार\u{94d}ट वाडटा"),
            keywords: &[
                "ग\u{94d}राफ",
                "चार\u{94d}ट",
                "चार\u{94d}ट वाडटा",
                "ट\u{94d}र\u{947}\u{902}ड",
                "वयल\u{947}वट\u{947}न",
                "वाड",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("көтөрүлүп жаткан диаграмма"),
            keywords: &[
                "диаграмма",
                "жогору",
                "көтөрүлүп жаткан диаграмма",
                "көтөрүлүү",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("steigenden Diagramm"),
            keywords: &[
                "Diagramm",
                "Grafik",
                "Steigerung",
                "Tendenz",
                "steigend",
                "steigenden Diagramm",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເສ\u{eb1}\u{ec9}ນສະແດງທ\u{eb5}\u{ec8}ເພ\u{eb5}\u{ec8}ມຂ\u{eb6}\u{ec9}ນ"),
            keywords: &[
                "ເພ\u{eb5}\u{ec8}ມຂ\u{eb6}\u{ec9}ນ",
                "ເສ\u{eb1}\u{ec9}ນສະແດງ",
                "ເສ\u{eb1}\u{ec9}ນສະແດງທ\u{eb5}\u{ec8}ເພ\u{eb5}\u{ec8}ມຂ\u{eb6}\u{ec9}ນ",
                "ແນວໂນ\u{ec9}ມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("didėjimo tendencijos diagrama"),
            keywords: &[
                "augimas",
                "diagrama",
                "didėjimo tendencijos diagrama",
                "schema",
                "tendencija",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("augšupejoša diagrammas līkne"),
            keywords: &[
                "augšup",
                "augšupejoša diagrammas līkne",
                "diagramma",
                "līkne",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tūtohi aupiki"),
            keywords: &[
                "au",
                "kauwhata",
                "tipunga",
                "tūtohi",
                "tūtohi aupiki",
                "whakarunga",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("растечки графикон"),
            keywords: &[
                "графикон",
                "нагорен",
                "пораст",
                "растечки графикон",
                "тренд",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മ\u{d41}കളിലേക\u{d4d}ക\u{d41}ള\u{d4d}ള ച\u{d3e}ർട\u{d4d}ട\u{d4d}"),
            keywords: &[
                "ഗ\u{d4d}ര\u{d3e}ഫ\u{d4d}",
                "ച\u{d3e}ർട\u{d4d}ട\u{d4d}",
                "മ\u{d41}കളിലേക\u{d4d}ക\u{d41}ള\u{d4d}ള ച\u{d3e}ർട\u{d4d}ട\u{d4d}",
                "മ\u{d41}കളിലേക\u{d4d}ക\u{d41}ള\u{d4d}ള ട\u{d4d}രെൻഡ\u{d4d}",
                "മ\u{d41}കളിലേക\u{d4d}ക\u{d41}ള\u{d4d}ള ട\u{d4d}രെൻഡ\u{d4d} ച\u{d3e}ർട\u{d4d}ട\u{d4d}",
                "മ\u{d41}കളിലേക\u{d4d}ക\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("өсч буй диаграмм"),
            keywords: &[
                "график",
                "диаграмм",
                "дээшээ",
                "чиг хандлага",
                "өсч буй диаграмм",
                "өсөлт",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("वाढता चार\u{94d}ट"),
            keywords: &["आल\u{947}ख", "कल", "चार\u{94d}ट", "वाढ", "वाढता"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("carta menaik"),
            keywords: &["arah aliran", "carta", "graf", "menaik", "pertumbuhan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ċart tiżdied"),
            keywords: &[
                "graff",
                "tendenza",
                "tkabbir",
                "ċart",
                "ċart tiżdied",
                "’il fuq",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မြင\u{1037}\u{103a}တက\u{103a}နေပ\u{102f}\u{1036}ပြ ဇယား"),
            keywords: &[
                "ဂရပ\u{103a}ဖ\u{103a}",
                "ဇယား",
                "တ\u{102d}\u{102f}းပ\u{103d}ားခြင\u{103a}း",
                "မြင\u{1037}\u{103a}တက\u{103a}နေပ\u{102f}\u{1036}ပြ ဇယား",
                "ဦးတည\u{103a}ချက\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("diagram som peker oppover"),
            keywords: &[
                "chart",
                "diagram som peker oppover",
                "graf",
                "opp",
                "positiv",
                "stigende",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बढ\u{94d}दो चार\u{94d}ट"),
            keywords: &[
                "ग\u{94d}राफ",
                "चार\u{94d}ट",
                "ट\u{94d}र\u{947}न\u{94d}ट",
                "बढ\u{94d}दो चार\u{94d}ट",
                "माथि",
                "विकास",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("stijgende trend"),
            keywords: &[
                "diagram",
                "grafiek",
                "grafiek met stijgende trend",
                "stijgend",
                "stijgende trend",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("diagram som peikar oppover"),
            keywords: &[
                "chart",
                "diagram som peikar oppover",
                "graf",
                "opp",
                "positiv",
                "stigande",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ବ\u{b43}ଦ\u{b4d}ଧ\u{b3f} ଦେଖ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} ଚ\u{b3e}ର\u{b4d}ଟ\u{b4d}\u{200c}",
            ),
            keywords: &[
                "ଉପରକ\u{b41}",
                "ଉପରକ\u{b41} ବଢନ\u{b4d}ତ\u{b3e} ପ\u{b4d}ରବ\u{b43}ତ\u{b4d}ତ\u{b3f} ଚ\u{b3e}ର\u{b4d}ଟ\u{b4d}",
                "ଗ\u{b4d}ର\u{b3e}ଫ\u{b4d}",
                "ଚ\u{b3e}ର\u{b4d}ଟ\u{b4d}",
                "ବଢନ\u{b4d}ତ\u{b3e} ପ\u{b4d}ରବ\u{b43}ତ\u{b4d}ତ\u{b3f}",
                "ବ\u{b43}ଦ\u{b4d}ଧ\u{b3f} ଦେଖ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} ଚ\u{b3e}ର\u{b4d}ଟ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਵ\u{a71}ਧਦਾ ਹ\u{a4b}ਇਆ ਚਾਰਟ"),
            keywords: &[
                "ਗਰਾਫ",
                "ਚਾਰਟ",
                "ਵਧਦਾ",
                "ਵਧਦਾ ਰ\u{a41}ਝਾਨ",
                "ਵਧਦਾ ਰ\u{a41}ਝਾਨ ਚਾਰਟ",
                "ਵ\u{a71}ਧਦਾ ਹ\u{a4b}ਇਆ ਚਾਰਟ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چارٹ ودھ رہیا اے"),
            keywords: &[
                "ا\u{64f}وتلے پاس\u{651}ے",
                "رجحان",
                "پرورش پانا",
                "چارٹ",
                "چارٹ ودھ رہیا اے",
                "گراف",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Chat Wit Graf Wé De Gó Ọp"),
            keywords: &[
                "Chat",
                "Chat Wit Graf Wé De Gó Ọp",
                "Dairẹ\u{301}kshọn",
                "De Gó Ọp",
                "Graf",
                "Gro",
                "Lain",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wykres wzrostu"),
            keywords: &[
                "tendencja wzrostowa",
                "trend zwyżkowy",
                "wykres wzrostu",
                "wzrost",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("چارټ زیاتوالی"),
            keywords: &["وده", "پورته", "چارټ", "چارټ زیاتوالی", "ګراف"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("gráfico subindo"),
            keywords: &[
                "crescimento",
                "diagrama",
                "gráfico",
                "gráfico de tendência de crescimento",
                "gráfico subindo",
                "tendência de crescimento",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("gráfico a subir"),
            keywords: &[
                "crescimento",
                "gráfico",
                "gráfico a subir",
                "subida",
                "tendência",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("grafic ascendent"),
            keywords: &["creștere", "diagramă", "grafic ascendent", "tendință"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-645"),
            keywords: &["E10-645"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("диаграмма роста"),
            keywords: &[
                "вверх",
                "диаграмма",
                "диаграмма роста",
                "рост",
                "схема",
                "тенденция",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("imbonerahamwe y’ibizamuka"),
            keywords: &[
                "igishushanyo",
                "imbonerahamwe",
                "imbonerahamwe y’ibizamuka",
                "iterambere",
                "izamuka",
                "ujya hejuru",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("وڌندڙ چارٽ"),
            keywords: &["رخ", "مٿي پاسي", "واڌ", "وڌندڙ چارٽ", "چارٽ", "گراف"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dca}\u{200d}රස\u{dca}ත\u{dcf}රය ඉහළ නැග\u{dd3}ම"),
            keywords: &[
                "ඉහළට",
                "නැඹ\u{dd4}ර\u{dd4}ත\u{dcf}ව",
                "ප\u{dca}\u{200d}රස\u{dca}ත\u{dcf}රය",
                "ප\u{dca}\u{200d}රස\u{dca}ත\u{dcf}රය ඉහළ නැග\u{dd3}ම",
                "වර\u{dca}ධනය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("stúpajúci graf"),
            keywords: &["graf", "nárast", "stúpajúci", "trend"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("grafikon rasti"),
            keywords: &[
                "graf",
                "grafikon",
                "grafikon rasti",
                "navzgor",
                "rast",
                "trend",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("shaxan kordhaya"),
            keywords: &[
                "isbedel",
                "kor",
                "korid",
                "shax",
                "shaxan",
                "shaxan kordhaya",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("grafik rritës"),
            keywords: &["grafik", "grafik rritës", "lart", "rritje", "tendencë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("графикон са узлазним трендом"),
            keywords: &[
                "графикон",
                "графикон са узлазним трендом",
                "нагоре",
                "раст",
                "тренд",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["графикон са узлазним трендом"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("grafikon sa uzlaznim trendom"),
            keywords: &[
                "grafikon",
                "grafikon sa uzlaznim trendom",
                "nagore",
                "rast",
                "trend",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["grafikon sa uzlaznim trendom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("uppåtgående trend"),
            keywords: &["diagram", "graf", "uppåtgående trend"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("chati inayopanda"),
            keywords: &[
                "chati",
                "chati inayopanda",
                "grafu",
                "juu",
                "kukua",
                "uelekeo",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வளர\u{bcd}ச\u{bcd}சி"),
            keywords: &[
                "ஊக\u{bcd}கம\u{bcd}",
                "ச\u{bbe}ர\u{bcd}ட\u{bcd}",
                "மேல\u{bcd} நோக\u{bcd}கி செல\u{bcd}லுதல\u{bcd}",
                "வளர\u{bcd}ச\u{bcd}சி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c46}రుగుదల చ\u{c3e}ర\u{c4d}ట\u{c4d}"),
            keywords: &[
                "గ\u{c4d}ర\u{c3e}ఫ\u{c4d}",
                "చ\u{c3e}ర\u{c4d}ట\u{c4d}",
                "ప\u{c46}రుగుదల",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("диаграммаи афзоишёбанда"),
            keywords: &[
                "афзоиш",
                "боло",
                "график",
                "диаграмма",
                "диаграммаи афзоишёбанда",
                "тамоюл",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แนวโน\u{e49}มข\u{e36}\u{e49}น"),
            keywords: &["ขาข\u{e36}\u{e49}น", "แนวโน\u{e49}มข\u{e36}\u{e49}น"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("köpelýän grafik"),
            keywords: &[
                "grafika",
                "köpelýän grafik",
                "trend",
                "çyzgy",
                "ösüş",
                "ýokary",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("siate tupulaki"),
            keywords: &["siate tupulaki"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("artış grafiği"),
            keywords: &["artış grafiği", "grafik", "yukarı yönlü", "yükselen grafik"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاشما گىرافىك"),
            keywords: &[
                "ئاشما گىرافىك",
                "ئېشىش",
                "جەدۋەل",
                "يۇقىرىغا",
                "يۈزلىنىش",
                "گىرافىك",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("висхідний графік"),
            keywords: &[
                "вгору",
                "висхідний графік",
                "графік",
                "графік підвищення",
                "діаграма",
                "ріст",
                "тенденція",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("صعودی چارٹ"),
            keywords: &["اسٹیشنری", "بڑھوتری", "صعودی چارٹ", "چارٹ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("o‘sish trendi diagrammasi"),
            keywords: &[
                "diagramma",
                "grafa",
                "o‘sish",
                "o‘sish trendi diagrammasi",
                "trend",
                "yuqoriga",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("biểu đồ tăng"),
            keywords: &[
                "biểu đồ",
                "biểu đồ tăng",
                "tăng lên",
                "tăng trưởng",
                "xu hướng",
                "đồ thị",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("grafik buy yéeg"),
            keywords: &["grafik", "grafik buy yéeg", "kurb", "màgg", "xew", "yéeg"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("itshati iyanda"),
            keywords: &[
                "ezithandwayo",
                "igrafu",
                "itshathi",
                "itshati iyanda",
                "ukunyuka",
                "ulwando",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àtẹ n pọsi"),
            keywords: &[
                "ilà ató\u{329}ka àwòrán",
                "àtẹ",
                "àtẹ n pọsi",
                "ìdàgbàsókè",
                "ìlọsókè",
                "ìlọṣíwájú",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("圖表上升"),
            keywords: &["向上", "圖", "圖表", "圖表上升", "增長", "趨勢"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("图表上升"),
            keywords: &["向上", "图", "图表", "图表上升", "增长", "趋势"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("趋势向上的图表"),
            keywords: &["上升", "上涨", "上涨图表", "向上", "图表", "趋势向上的图表"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("漲"),
            keywords: &["上升", "上漲", "圖表", "漲"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("向上折線圖"),
            keywords: &["向上", "向上折線圖", "圖形", "圖表", "正向", "線條", "趨勢"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ishadi elikhuphukayo"),
            keywords: &[
                "igrafu",
                "ishadi",
                "ishadi elikhuphukayo",
                "okuya phezulu",
                "ukukhula",
            ],
        },
    ],
};
#[doc = "📉"]
pub const CHART_DECREASING: crate::Emoji = crate::Emoji {
    glyph: "📉",
    codepoint: "1F4C9",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "chart decreasing",
    group: "Objects",
    subgroup: "office",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("grafiek wat daal"),
            keywords: &[
                "daling",
                "grafiek",
                "grafiek wat daal",
                "statistiek",
                "tendens",
                "val",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሚቀንስ ገበታ"),
            keywords: &["ሰንጠረዥ", "ታች", "አዝማሚያ", "የሚቀንስ ገበታ", "ገበታ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مخطط بياني لأسفل"),
            keywords: &["انخفاض", "مخطط", "مخطط بياني لأسفل"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("অধোগ\u{9be}মী লেখচিত\u{9cd}ৰ"),
            keywords: &[
                "অধোগ\u{9be}মী",
                "অধোগ\u{9be}মী প\u{9cd}ৰৱণত\u{9be}",
                "অধোগ\u{9be}মী প\u{9cd}ৰৱণত\u{9be}ৰ চ\u{9be}ৰ\u{9cd}ট",
                "অধোগ\u{9be}মী লেখচিত\u{9cd}ৰ",
                "গ\u{9cd}ৰ\u{9be}ফ",
                "চ\u{9be}ৰ\u{9cd}ট",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("düşən qrafik"),
            keywords: &["aşağı", "cədvəl", "düşən qrafik", "qrafik", "trend"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("дыяграма зніжэння"),
            keywords: &[
                "графік",
                "дыяграма",
                "дыяграма зніжэння",
                "зніжэнне",
                "тэндэнцыя",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Диаграма с низходяща тенденция"),
            keywords: &[
                "Диаграма с низходяща тенденция",
                "диаграма",
                "надолу",
                "спад",
                "тенденция",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9cd}রমহ\u{9cd}র\u{9be}সম\u{9be}ন চ\u{9be}র\u{9cd}ট"),
            keywords: &[
                "ক\u{9cd}রমহ\u{9cd}র\u{9be}সম\u{9be}ন চ\u{9be}র\u{9cd}ট",
                "গ\u{9cd}র\u{9be}ফ",
                "চ\u{9be}র\u{9cd}ট",
                "নিম\u{9cd}নম\u{9c1}খী",
                "প\u{9cd}রবণত\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("krommenn digreskiñ"),
            keywords: &["diagramm", "digreskiñ", "grafik", "krommenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("dijagram opadanja"),
            keywords: &["dijagram", "dijagram opadanja", "grafikon", "opadanje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("gràfic de disminució"),
            keywords: &[
                "a la baixa",
                "disminució",
                "gràfic",
                "gràfic de disminució",
                "tendència",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎧᏃᎮᏓ ᏓᏟᎶᏍᏛ ᎠᎦᏲᎶᎬᎢ"),
            keywords: &["ᎡᎳᏗ", "ᎦᎵᎦᎳ", "ᎧᏃᎮᏓ ᏓᏟᎶᏍᏛ", "ᎧᏃᎮᏓ ᏓᏟᎶᏍᏛ ᎠᎦᏲᎶᎬᎢ", "ᏓᏟᎶᏍᏛ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("klesající graf"),
            keywords: &["graf", "klesající graf", "pokles", "sestupný", "trend"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("siart yn gostwng"),
            keywords: &["graff", "i lawr", "siart", "siart yn gostwng", "trend"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("nedadgående graf"),
            keywords: &["graf", "nedadgående graf", "tendens"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Abwärtstrend"),
            keywords: &["Abwärtstrend", "Diagramm", "Kurve", "fallend"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καθοδικό γράφημα"),
            keywords: &["γράφημα", "διάγραμμα", "καθοδικό γράφημα", "μείωση", "τάση"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("chart decreasing"),
            keywords: &["chart", "chart decreasing", "down", "graph", "trend"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("graph decreasing"),
            keywords: &[
                "chart",
                "chart decreasing",
                "down",
                "graph",
                "graph decreasing",
                "trend",
            ],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("gráfica de evolución descendente"),
            keywords: &[
                "descendente",
                "gráfica",
                "gráfica de evolución descendente",
                "gráfico",
                "tendencia descendente",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("tendencia descendente"),
            keywords: &[
                "alza",
                "descendente",
                "disminuir",
                "empeorar",
                "gráfico",
                "peor",
                "reducir",
                "tabla",
                "tendencia descendente",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "baja",
                "descendente",
                "gráfico",
                "tabla",
                "tendencia descendente",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "baja",
                "descendente",
                "gráfico",
                "tabla",
                "tendencia descendente",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("langev graafik"),
            keywords: &["alla", "graafik", "langev graafik", "langus", "tendents"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("diagrama beherakorra"),
            keywords: &[
                "behera",
                "diagrama",
                "diagrama beherakorra",
                "grafiko",
                "joera",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نمودار نزولی"),
            keywords: &["نمودار", "نمودار نزولی", "پایین", "گراف", "گرایش"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("laskeva käyrä"),
            keywords: &["kaavio", "käyrä", "laskeva käyrä", "lasku", "suuntaus"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bumababang chart"),
            keywords: &["bumababang chart", "graph", "pababa", "tsart", "uso"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("strikumynd við lækking"),
            keywords: &[
                "diagramm",
                "lækkar",
                "lækking",
                "minkar",
                "minking",
                "niður",
                "rásmynd",
                "strikumynd",
                "strikumynd við lækking",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("graphique en baisse"),
            keywords: &["baisse", "graphique", "graphique en baisse", "tendance"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["baisse", "graphique", "graphique en baisse", "tendance"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cairt íslitheach"),
            keywords: &["cairt síos", "cairt íslitheach", "graf", "treocht síos"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cairt a’ dol sìos"),
            keywords: &[
                "cairt",
                "cairt a’ dol sìos",
                "crìonadh",
                "graf",
                "sìos",
                "treand",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("gráfico con tendencia descendente"),
            keywords: &[
                "baixa",
                "gráfica",
                "gráfico",
                "gráfico con tendencia descendente",
                "tendencia",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("નીચ\u{ac7} જતો ચાર\u{acd}ટ"),
            keywords: &[
                "આલ\u{ac7}ખ",
                "ઉ\u{a82}ચ\u{ac7}ના વલણનો ચાર\u{acd}ટ",
                "ચાર\u{acd}ટ",
                "નીચ\u{ac7} જતો ચાર\u{acd}ટ",
                "નીચ\u{ac7}ની તરફ",
                "નીચ\u{ac7}ન\u{ac1}\u{a82} વલણ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("zanen-lissafi mai ragewa"),
            keywords: &["salo", "zane", "zanen-lissafi", "zanen-lissafi mai ragewa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גרף יורד"),
            keywords: &["גרף", "יורד", "ירידה", "מגמה", "תרשים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("घटत\u{947} र\u{941}झान वाला चार\u{94d}ट"),
            keywords: &[
                "ग\u{94d}राफ\u{93c}",
                "घटता र\u{941}झान",
                "घटता ह\u{941}आ",
                "घटत\u{947} र\u{941}झान वाला चार\u{94d}ट",
                "चार\u{94d}ट",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("grafikon silaznog trenda"),
            keywords: &[
                "grafikon",
                "grafikon silaznog trenda",
                "pad",
                "silazni trend",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("csökkenő diagram"),
            keywords: &[
                "csökkenés",
                "csökkenő diagram",
                "diagram",
                "lefelé",
                "trend",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("նվազող դիագրամ"),
            keywords: &["գրաֆիկ", "դիագրամ", "միտում", "ներքև", "նվազող դիագրամ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bagan menurun"),
            keywords: &["bagan", "bagan menurun", "grafik", "tren", "turun"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("mmèlata chaatị"),
            keywords: &["ala", "chaati", "grafụ", "mmèlata chaatị", "trendi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("á niðurleið"),
            keywords: &["graf á niðurleið", "á niðurleið"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("grafico con andamento negativo"),
            keywords: &[
                "andamento discendente",
                "discendente",
                "grafico",
                "grafico con andamento negativo",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("グラフ下向き"),
            keywords: &["グラフ下向き", "下向き", "下降", "折れ線グラフ"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("grafik mudhun"),
            keywords: &["grafik", "mudhun", "tren"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კლებადი გრაფიკი"),
            keywords: &[
                "გრაფიკი",
                "დიაგრამა",
                "კლებადი გრაფიკი",
                "ტენდენცია",
                "ქვემოთ",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("кему туралы диаграмма"),
            keywords: &[
                "график",
                "диаграмма",
                "кему туралы диаграмма",
                "тренд",
                "төмен",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("nedadgående graf"),
            keywords: &["graf", "nedadgående graf", "tendens"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("តារាងធ\u{17d2}លាក\u{17cb}ច\u{17bb}ះ"),
            keywords: &[
                "តារាង",
                "តារាងធ\u{17d2}លាក\u{17cb}ច\u{17bb}ះ",
                "ធ\u{17d2}លាក\u{17cb}ច\u{17bb}ះ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಇಳ\u{cbf}ಯುತ\u{ccd}ತ\u{cbf}ರುವ ಚಾರ\u{ccd}ಟ\u{ccd}"),
            keywords: &[
                "ಇಳ\u{cbf}ಕ\u{cc6}ಯ ಪ\u{ccd}ರವೃತ\u{ccd}ತ\u{cbf} ಚಾರ\u{ccd}ಟ\u{ccd}",
                "ಇಳ\u{cbf}ಯುತ\u{ccd}ತ\u{cbf}ರುವ ಚಾರ\u{ccd}ಟ\u{ccd}",
                "ಕ\u{cc6}ಳಕ\u{ccd}ಕ\u{cc6} ಚಾರ\u{ccd}ಟ\u{ccd}",
                "ಗ\u{ccd}ರಾಫ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("내려가는 그래프"),
            keywords: &["그래프", "내려가는 그래프", "불황", "하향"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("चार\u{94d}ट द\u{947}\u{902}वता"),
            keywords: &[
                "ग\u{94d}राफ",
                "चार\u{94d}ट",
                "चार\u{94d}ट द\u{947}\u{902}वता",
                "ट\u{94d}र\u{947}\u{902}ड",
                "सकयल",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("түшүп жаткан диаграмма"),
            keywords: &["диаграмма", "түшүп жаткан диаграмма", "түшүү", "төмөн"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("senkenden Diagramm"),
            keywords: &[
                "Diagramm",
                "Grafik",
                "Tendenz",
                "senkend",
                "senkenden Diagramm",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເສ\u{eb1}\u{ec9}ນສະແດງທ\u{eb5}\u{ec8}ຫ\u{ebc}\u{eb8}ດລ\u{ebb}ງ"),
            keywords: &[
                "ຫ\u{ebc}\u{eb8}ດລ\u{ebb}ງ",
                "ເສ\u{eb1}\u{ec9}ນສະແດງ",
                "ເສ\u{eb1}\u{ec9}ນສະແດງທ\u{eb5}\u{ec8}ຫ\u{ebc}\u{eb8}ດລ\u{ebb}ງ",
                "ແນວໂນ\u{ec9}ມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mažėjimo tendencijos diagrama"),
            keywords: &[
                "diagrama",
                "mažėjimo tendencijos diagrama",
                "tendencija",
                "į apačią",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("lejupejoša diagrammas līkne"),
            keywords: &["diagramma", "lejup", "lejupejoša diagrammas līkne", "līkne"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tūtohi auheke"),
            keywords: &["au", "kauwhata", "tūtohi", "tūtohi auheke", "whakaheke"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("опаѓачки графикон"),
            keywords: &["графикон", "надолен", "опаѓачки графикон", "пад", "тренд"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ത\u{d3e}ഴേക\u{d4d}ക\u{d41}ള\u{d4d}ള ച\u{d3e}ർട\u{d4d}ട\u{d4d}"),
            keywords: &[
                "ഗ\u{d4d}ര\u{d3e}ഫ\u{d4d}",
                "ച\u{d3e}ർട\u{d4d}ട\u{d4d}",
                "ത\u{d3e}ഴേക\u{d4d}ക\u{d41}ള\u{d4d}ള ച\u{d3e}ർട\u{d4d}ട\u{d4d}",
                "ത\u{d3e}ഴേക\u{d4d}ക\u{d41}ള\u{d4d}ള ട\u{d4d}രെൻഡ\u{d4d}",
                "ത\u{d3e}ഴേക\u{d4d}ക\u{d41}ള\u{d4d}ള ട\u{d4d}രെൻഡ\u{d4d} ച\u{d3e}ർട\u{d4d}ട\u{d4d}",
                "ത\u{d3e}ഴേക\u{d4d}ക\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("буурч буй диаграмм"),
            keywords: &["буурах", "буурч буй диаграмм", "диаграмм", "чиг хандлага"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कमी होणारा चार\u{94d}ट"),
            keywords: &[
                "आल\u{947}ख",
                "उतरता",
                "कमी होणारा चार\u{94d}ट",
                "कल",
                "चार\u{94d}ट",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("carta menurun"),
            keywords: &["arah aliran", "carta", "graf", "menurun"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ċart tonqos"),
            keywords: &["graff", "tendenza", "ċart", "ċart tonqos", "’l isfel"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("န\u{102d}မ\u{1037}\u{103a}ဆင\u{103a}းနေပ\u{102f}\u{1036}ပြ ဇယား"),
            keywords: &[
                "ကျဆင\u{103a}းခြင\u{103a}း",
                "ကျဆင\u{103a}းနေပ\u{102f}\u{1036}ပြ ဇယား",
                "ဂရပ\u{103a}ဖ\u{103a}",
                "ဇယား",
                "န\u{102d}မ\u{1037}\u{103a}ဆင\u{103a}းနေပ\u{102f}\u{1036}ပြ ဇယား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("diagram som peker nedover"),
            keywords: &[
                "chart",
                "diagram som peker nedover",
                "fallende",
                "graf",
                "ned",
                "negativ",
                "synkende",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("घट\u{94d}दो चार\u{94d}ट"),
            keywords: &["घट\u{94d}दो चार\u{94d}ट", "चार\u{94d}ट घट\u{94d}दो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("dalende trend"),
            keywords: &[
                "dalend",
                "dalende trend",
                "diagram",
                "grafiek",
                "grafiek met dalende trend",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("diagram som peikar nedover"),
            keywords: &[
                "chart",
                "diagram som peikar nedover",
                "fallande",
                "graf",
                "ned",
                "negativ",
                "synkande",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ହ\u{b4d}ର\u{b3e}ସ ଦେଖ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} ଚ\u{b3e}ର\u{b4d}ଟ\u{b4d}"),
            keywords: &[
                "ଗ\u{b4d}ର\u{b3e}ଫ\u{b4d}",
                "ଚ\u{b3e}ର\u{b4d}ଟ\u{b4d}",
                "ତଳକ\u{b41} ଯ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e}",
                "ତଳକ\u{b41} ଯ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} ପ\u{b4d}ରବ\u{b43}ତ\u{b4d}ତ\u{b3f}",
                "ତଳକ\u{b41} ଯ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} ପ\u{b4d}ରବ\u{b43}ତ\u{b4d}ତ\u{b3f} ଚ\u{b3e}ର\u{b4d}ଟ\u{b4d}",
                "ହ\u{b4d}ର\u{b3e}ସ ଦେଖ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} ଚ\u{b3e}ର\u{b4d}ଟ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਘ\u{a71}ਟਦਾ ਹ\u{a4b}ਇਆ ਚਾਰਟ"),
            keywords: &[
                "ਗਰਾਫ",
                "ਘ\u{a71}ਟਦਾ",
                "ਘ\u{a71}ਟਦਾ ਰ\u{a41}ਝਾਨ",
                "ਘ\u{a71}ਟਦਾ ਰ\u{a41}ਝਾਨ ਚਾਰਟ",
                "ਘ\u{a71}ਟਦਾ ਹ\u{a4b}ਇਆ ਚਾਰਟ",
                "ਚਾਰਟ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چارٹ گھٹ رہیا اے"),
            keywords: &["رجحان", "چارٹ", "چارٹ گھٹ رہیا اے", "گراف", "ہیٹھاں"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Chat Wit Graf Wé De Gó Daun"),
            keywords: &[
                "Chat",
                "Chat Wit Graf Wé De Gó Daun",
                "Dairẹ\u{301}kshọn",
                "Daun",
                "Graf",
                "Lain",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wykres spadku"),
            keywords: &[
                "spadek",
                "strata",
                "tendencja spadkowa",
                "trend zniżkowy",
                "wykres spadku",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("چارټ کمېدونکی"),
            keywords: &["ټرينډ", "چارټ", "چارټ کمېدونکی", "ښکته", "ګراف"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("gráfico caindo"),
            keywords: &[
                "diagrama",
                "gráfico",
                "gráfico caindo",
                "gráfico de tendência negativa",
                "negativa",
                "tendência negativa",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("gráfico a descer"),
            keywords: &["descida", "gráfico", "gráfico a descer", "tendência"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("grafic descendent"),
            keywords: &["diagramă", "grafic descendent", "scădere", "tendință"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-646"),
            keywords: &["E10-646"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("диаграмма падения"),
            keywords: &[
                "вниз",
                "диаграмма",
                "диаграмма падения",
                "падение",
                "схема",
                "тенденция",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("imbonerahamwe y’ibimanuka"),
            keywords: &[
                "hasi",
                "igishushanyo",
                "imbonerahamwe",
                "imbonerahamwe y’ibimanuka",
                "izamuka",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("چارٽ گهٽجندي"),
            keywords: &["رخ", "هيٺ", "چارٽ", "چارٽ گهٽجندي", "گراف"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dca}\u{200d}රස\u{dca}ත\u{dcf}රය පහළ බැස\u{dd3}ම"),
            keywords: &[
                "නැඹ\u{dd4}ර\u{dd4}ත\u{dcf}ව",
                "පහළට",
                "ප\u{dca}\u{200d}රස\u{dca}ත\u{dcf}ර සටහන",
                "ප\u{dca}\u{200d}රස\u{dca}ත\u{dcf}රය",
                "ප\u{dca}\u{200d}රස\u{dca}ත\u{dcf}රය පහළ බැස\u{dd3}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("klesajúci graf"),
            keywords: &["graf", "klesajúci", "pokles", "trend"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("grafikon padca"),
            keywords: &["graf", "grafikon", "grafikon padca", "navzdol", "trend"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("shaxan yaraanaya"),
            keywords: &["hoos", "isbedel", "shax", "shaxan", "shaxan yaraanaya"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("grafik zbritës"),
            keywords: &["grafik", "grafik zbritës", "poshtë", "tendencë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("графикон са опадајућим трендом"),
            keywords: &["графикон", "графикон са опадајућим трендом", "пад", "тренд"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["графикон са опадајућим трендом"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("grafikon sa opadajućim trendom"),
            keywords: &["grafikon", "grafikon sa opadajućim trendom", "pad", "trend"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["grafikon sa opadajućim trendom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("nedåtgående trend"),
            keywords: &["diagram", "graf", "nedåtgående trend"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("chati inayoshuka"),
            keywords: &["chati", "chati inayoshuka", "chini", "grafu", "uelekeo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வ\u{bc0}ழ\u{bcd}ச\u{bcd}சி"),
            keywords: &[
                "த\u{bbe}ழ\u{bcd}வு",
                "வ\u{bc0}ழ\u{bcd}ச\u{bcd}சி",
                "வ\u{bc0}ழ\u{bcd}தல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("తగ\u{c4d}గుదల చ\u{c3e}ర\u{c4d}ట\u{c4d}"),
            keywords: &[
                "గ\u{c4d}ర\u{c3e}ఫ\u{c4d}",
                "చ\u{c3e}ర\u{c4d}ట\u{c4d}",
                "తగ\u{c4d}గుదల",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("диаграммаи коҳишёбанда"),
            keywords: &[
                "график",
                "диаграмма",
                "диаграммаи коҳишёбанда",
                "поён",
                "тамоюл",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แนวโน\u{e49}มลง"),
            keywords: &["ขาลง", "แนวโน\u{e49}มลง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("azalýan grafik"),
            keywords: &["azalýan grafik", "aşak", "grafika", "trend", "çyzgy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("siate maholo"),
            keywords: &["siate maholo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("iniş grafiği"),
            keywords: &["alçalan grafik", "aşağı yönlü", "grafik", "iniş grafiği"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چۈشمە گىرافىك"),
            keywords: &["جەدۋەل", "يۈزلىنىش", "چۈشمە گىرافىك", "چۈشۈش", "گىرافىك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("низхідний графік"),
            keywords: &[
                "вниз",
                "графік",
                "графік падіння",
                "діаграма",
                "низхідний графік",
                "тенденція",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("تنزلی چارٹ"),
            keywords: &["اسٹیشنری", "تنزلی", "چارٹ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("pasayish trendi diagrammasi"),
            keywords: &[
                "diagramma",
                "grafa",
                "pasayish trendi diagrammasi",
                "pastga",
                "trend",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("biểu đồ giảm"),
            keywords: &["biểu đồ", "biểu đồ giảm", "xu hướng", "xuống", "đồ thị"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("tablo buy wàcci"),
            keywords: &["grafik", "kurb", "suuf", "tablo buy wàcci", "xew"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("itshati iyehla"),
            keywords: &[
                "ezantsi",
                "ezithandwayo",
                "igrafu",
                "itshathi",
                "itshati iyehla",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àtẹ n dinku"),
            keywords: &[
                "tírẹ\u{301}ndì",
                "àtẹ",
                "àtẹ alátó\u{329}ka",
                "àtẹ n dinku",
                "ìsàlẹ\u{300}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("圖表下跌"),
            keywords: &["下跌", "圖", "圖表", "圖表下跌", "趨勢"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("图表下跌"),
            keywords: &["下跌", "图", "图表", "图表下跌", "趋势"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("趋势向下的图表"),
            keywords: &["下跌", "下跌图表", "下降", "向下", "图表", "趋势向下的图表"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("跌"),
            keywords: &["下跌", "下降", "圖表", "跌"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("向下折線圖"),
            keywords: &[
                "下降",
                "向下",
                "向下折線圖",
                "圖形",
                "圖表",
                "線條",
                "趨勢｜下跌",
            ],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ishadi elehlayo"),
            keywords: &["igrafu", "ishadi", "ishadi elehlayo", "okuya phansi"],
        },
    ],
};
#[doc = "📊"]
pub const BAR_CHART: crate::Emoji = crate::Emoji {
    glyph: "📊",
    codepoint: "1F4CA",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "bar chart",
    group: "Objects",
    subgroup: "office",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("staafgrafiek"),
            keywords: &["grafiek", "staaf", "staafgrafiek"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ባለ አሞሌ ገበታ"),
            keywords: &["ሰንጠረዥ", "ባለ አሞሌ ገበታ", "አሞሌ", "ገበታ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مخطط بياني شريطي"),
            keywords: &["مخطط", "مخطط بياني شريطي", "مخطط شريطي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("দণ\u{9cd}ডচিত\u{9cd}ৰ"),
            keywords: &[
                "গ\u{9cd}ৰ\u{9be}ফ",
                "চ\u{9be}ৰ\u{9cd}ট",
                "দণ\u{9cd}ড",
                "দণ\u{9cd}ডচিত\u{9cd}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("diaqram"),
            keywords: &["bar", "cədvəl", "diaqram", "qrafik"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("лінейчастая дыяграма"),
            keywords: &["графік", "дыяграма", "лінейчастая", "слупок"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Стълбовидна диаграма"),
            keywords: &["Стълбовидна диаграма", "диаграма", "стълб"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9be}র চ\u{9be}র\u{9cd}ট"),
            keywords: &["গ\u{9cd}র\u{9be}ফ", "চ\u{9be}র\u{9cd}ট", "ব\u{9be}র"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("diagramm barrennoù"),
            keywords: &["barrennoù", "diagramm", "grafik"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("stupčasti grafikon"),
            keywords: &["dijagram", "grafikon", "stupčasti grafikon"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("gràfic de barres"),
            keywords: &["barres", "gràfic", "gràfic de barres"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᎾᎸᎢ ᎧᏃᎮᏍᎩ ᏗᏟᎶᏍᏔᏅ"),
            keywords: &["ᎦᎾᎸᎢ", "ᎦᎾᎸᎢ ᎧᏃᎮᏍᎩ ᏗᏟᎶᏍᏔᏅ", "ᎧᏃᎮᏓ ᏓᏟᎶᏍᏛ", "ᏓᏟᎶᏍᏛ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("sloupcový graf"),
            keywords: &["graf", "sloupcový graf", "sloupec"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("siart bar"),
            keywords: &["bar", "graff", "siart"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("søjlediagram"),
            keywords: &["diagram", "søjlediagram"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Balkendiagramm"),
            keywords: &["Balken", "Balkendiagramm", "Diagramm"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γράφημα ράβδων"),
            keywords: &["γράφημα", "γράφημα ράβδων", "γραμμή", "διάγραμμα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("bar chart"),
            keywords: &["bar", "chart", "graph"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("bar graph"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("gráfico de barras"),
            keywords: &["barras", "gráfico", "gráfico de barras"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("tulpdiagramm"),
            keywords: &["diagramm", "graafik", "tulp", "tulpdiagramm"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("barra-diagrama"),
            keywords: &["barra", "barra-diagrama", "diagrama", "grafiko"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نمودار ستونی"),
            keywords: &["ستون", "نمودار", "نمودار ستونی", "گراف"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pylväskaavio"),
            keywords: &["kaavio", "pylväs", "pylväskaavio", "tilasto"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bar chart"),
            keywords: &["bar", "bar chart", "graph", "tsart"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("stabbamynd"),
            keywords: &["diagramm", "rásmynd", "stabbamynd", "strikumynd"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("graphiques à barres"),
            keywords: &["graphique", "graphiques à barres"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["barres", "graphique", "graphiques à barres"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("barrachairt"),
            keywords: &["barrachairt", "barraghraf", "cairt"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cairt-bhàraichean"),
            keywords: &["bàr", "cairt", "cairt-bhàraichean", "graf"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("gráfico de barras"),
            keywords: &["barras", "gráfica", "gráfico", "gráfico de barras"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બાર ચાર\u{acd}ટ"),
            keywords: &[
                "ચાર\u{acd}ટ",
                "બાર ચાર\u{acd}ટ",
                "સ\u{acd}ત\u{a82}ભ આલ\u{ac7}ખ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("allon jadawali"),
            keywords: &["allon jadawali", "sanda", "zane", "zanen lissafi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("תרשים עמודות"),
            keywords: &["גרף", "עמודות", "תרשים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बार चार\u{94d}ट"),
            keywords: &["चार\u{94d}ट", "बार ग\u{94d}राफ\u{93c}", "बार चार\u{94d}ट"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("trakasti grafikon"),
            keywords: &["grafikon", "traka", "trakasti grafikon"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("oszlopdiagram"),
            keywords: &["diagram", "oszlop", "oszlopdiagram", "sáv"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("գոտեձև գծապատկեր"),
            keywords: &["գոտեձև գծապատկեր", "գոտի", "գրաֆիկ", "դիագրամ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("diagram batang"),
            keywords: &["bagan", "batang", "diagram batang", "grafik"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("chaàtị ogwe"),
            keywords: &["chaatị", "chaàtị ogwe", "grafụ", "ogwe"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("súlurit"),
            keywords: &["myndrit", "súlur", "súlurit"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("grafico a barre"),
            keywords: &["barre", "grafico", "grafico a barre"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("棒グラフ"),
            keywords: &["グラフ", "チャート", "棒グラフ"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("grafik balok"),
            keywords: &["balok", "grafik"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სვეტებიანი დიაგრამა"),
            keywords: &["გრაფიკი", "დიაგრამა", "სვეტებიანი დიაგრამა", "სვეტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("гистограмма"),
            keywords: &["гистограмма", "график", "диаграмма"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("søjlediagram"),
            keywords: &["diagram", "søjlediagram"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("តារាងជារបា"),
            keywords: &[
                "ក\u{17d2}រាហ\u{17d2}វ",
                "គ\u{17c6}ន\u{17bc}សតាង",
                "តារាងជារបា",
                "របារ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬಾರ\u{ccd} ಚಾರ\u{ccd}ಟ\u{ccd}"),
            keywords: &["ಚಾರ\u{ccd}ಟ\u{ccd}", "ಬಾರ\u{ccd} ಚಾರ\u{ccd}ಟ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("막대 그래프"),
            keywords: &["그래프", "막대 그래프", "막대그래프"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बार तकटो"),
            keywords: &["ग\u{94d}राफ", "तकटो", "बार"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("гистограмма"),
            keywords: &["гистограмма", "диаграмма", "схема", "таблица"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Balkendiagramm"),
            keywords: &["Balken", "Balkendiagramm", "Diagramm", "Grafik"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{eb1}ງສະແດງແບບເປ\u{eb1}ນທ\u{ec8}ອນ"),
            keywords: &[
                "ທ\u{ec8}ອນ",
                "ຜ\u{eb1}ງສະແດງ",
                "ຜ\u{eb1}ງສະແດງແບບເປ\u{eb1}ນທ\u{ec8}ອນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("juostinė diagrama"),
            keywords: &["diagrama", "juosta", "juostinė diagrama"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("joslu diagramma"),
            keywords: &["diagramma", "josla", "joslu diagramma"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tūtohi pae"),
            keywords: &["kauwhata", "pae", "tūtohi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("столбест дијаграм"),
            keywords: &["графикон", "столб", "столбест дијаграм"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ബ\u{d3e}ർ ച\u{d3e}ർട\u{d4d}ട\u{d4d}"),
            keywords: &[
                "ച\u{d3e}ർട\u{d4d}ട\u{d4d}",
                "ബ\u{d3e}ർ ഗ\u{d4d}ര\u{d3e}ഫ\u{d4d}",
                "ബ\u{d3e}ർ ച\u{d3e}ർട\u{d4d}ട\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("график хүснэгт"),
            keywords: &["график", "хүснэгт", "үзүүлэлт"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("बार चार\u{94d}ट"),
            keywords: &["चार\u{94d}ट", "बार आल\u{947}ख", "बार चार\u{94d}ट"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("carta bar"),
            keywords: &["bar", "carta", "graf"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("barċart"),
            keywords: &["bar", "barċart", "graff", "ċart"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဘားက\u{103d}က\u{103a}ပြ ဇယား"),
            keywords: &[
                "ဂရပ\u{103a}ဖ\u{103a}",
                "ဇယား",
                "ဘားက\u{103d}က\u{103a}ပြ ဇယား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("stolpediagram"),
            keywords: &["diagram", "histogram", "stolpediagram", "søylediagram"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बार चार\u{94d}ट"),
            keywords: &["ग\u{94d}राफ", "चार\u{94d}ट", "बार"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("staafdiagram"),
            keywords: &["diagram", "grafiek", "staaf", "staafdiagram"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("stolpediagram"),
            keywords: &["diagram", "histogram", "stolpediagram", "søylediagram"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3e}ର\u{b4d} ଚ\u{b3e}ର\u{b4d}ଟ\u{b4d}"),
            keywords: &[
                "ଗ\u{b4d}ର\u{b3e}ଫ\u{b4d}\u{200c}",
                "ଚ\u{b3e}ର\u{b4d}ଟ\u{b4d}\u{200c}",
                "ବ\u{b3e}ର\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬਾਰ ਚਾਰਟ"),
            keywords: &["ਚਾਰਟ", "ਬਾਰ ਗਰਾਫ", "ਬਾਰ ਚਾਰਟ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بار چارٹ"),
            keywords: &["بار چارٹ", "سیخ", "چارٹ", "گراف"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Graf Wé Gẹ\u{301}t Waíd Lain-dẹm"),
            keywords: &[
                "Chat",
                "Graf",
                "Graf Wé Gẹ\u{301}t Waíd Lain",
                "Graf Wé Gẹ\u{301}t Waíd Lain-dẹm",
                "Waíd Graf",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wykres słupkowy"),
            keywords: &["słupek", "wykres", "wykres słupkowy"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بار چارټ"),
            keywords: &["بار", "چارټ", "ګراف"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("gráfico de barras"),
            keywords: &["barra", "barras", "gráfico", "gráfico de barras"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["barras", "gráfico", "gráfico de barras"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("diagramă cu bare"),
            keywords: &["coloane", "diagramă", "diagramă cu bare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-647"),
            keywords: &["E10-647"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("гистограмма"),
            keywords: &["гистограмма", "диаграмма", "столбчатая"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("imbonerahamwe y’umurongo"),
            keywords: &[
                "agakoni",
                "igishushanyo",
                "imbonerahamwe",
                "imbonerahamwe y’umurongo",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بار چارٽ"),
            keywords: &["بار", "چارٽ", "گراف"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ත\u{dd3}ර\u{dd4} ප\u{dca}\u{200d}රස\u{dca}ත\u{dcf}රය"),
            keywords: &[
                "ත\u{dd3}ර\u{dd4}",
                "ප\u{dca}\u{200d}රස\u{dca}ත\u{dcf}ර සටහන",
                "ප\u{dca}\u{200d}රස\u{dca}ත\u{dcf}රය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("pruhový graf"),
            keywords: &["graf", "pruh", "pruhový graf"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("črtni grafikon"),
            keywords: &["graf", "grafikon", "črtni grafikon", "črtno"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("shaxanka baar"),
            keywords: &["baar", "shax", "shaxan", "shaxanka baar"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("grafik me shirita"),
            keywords: &["grafik", "grafik me shirita", "shirit"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("тракасти графикон"),
            keywords: &["графикон", "трака", "тракасти графикон"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["тракасти графикон"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("trakasti grafikon"),
            keywords: &["grafikon", "traka", "trakasti grafikon"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["trakasti grafikon"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("stapeldiagram"),
            keywords: &["diagram", "stapeldiagram", "staplar"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("chati ya miraba"),
            keywords: &["chati", "chati ya miraba", "grafu", "mraba"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பட\u{bcd}டை வரைபடம\u{bcd}"),
            keywords: &[
                "பட\u{bcd}டை வரைபடம\u{bcd}",
                "ப\u{bbe}ர\u{bcd} கிர\u{bbe}ப\u{bcd}",
                "ப\u{bbe}ர\u{bcd} ச\u{bbe}ர\u{bcd}ட\u{bcd}",
                "ப\u{bbe}ர\u{bcd} வரைபடம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బ\u{c3e}ర\u{c4d} చ\u{c3e}ర\u{c4d}ట\u{c4d}"),
            keywords: &[
                "బ\u{c3e}ర\u{c4d} గ\u{c4d}ర\u{c3e}ఫ\u{c4d}",
                "బ\u{c3e}ర\u{c4d} చ\u{c3e}ర\u{c4d}ట\u{c4d}",
                "బ\u{c3e}ర\u{c4d} పట\u{c4d}ట\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("диаграммаи хаттӣ"),
            keywords: &["бар", "график", "диаграмма", "диаграммаи хаттӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("กราฟแท\u{e48}ง"),
            keywords: &["กราฟแท\u{e48}ง", "ชาร\u{e4c}ต"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("setir diagramma"),
            keywords: &["grafika", "setir diagramma", "zolak", "çyzyk"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("siate pā"),
            keywords: &["siate pā"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("çubuk grafiği"),
            keywords: &["grafik", "çubuk grafiği"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تۈۋرۈكلۈك گىرافىك"),
            keywords: &["تۈۋرۈك", "تۈۋرۈكلۈك گىرافىك", "جەدۋەل", "گىرافىك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("гістограма"),
            keywords: &["графік", "гістограма"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بار چارٹ"),
            keywords: &["اسٹیشنری", "بار", "چارٹ", "گراف"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ustunli diagramma"),
            keywords: &["diagramma", "grafa", "ustunli"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("biểu đồ thanh"),
            keywords: &["biểu đồ", "biểu đồ thanh", "thanh", "đồ thị"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jagraamu bànd"),
            keywords: &["grafik", "jagraamu bànd", "kurb", "laat"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("itshati yebha"),
            keywords: &["ibha", "igrafu", "itshathi", "itshati yebha"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("pẹpẹ ìwe àwòrán àfihàn"),
            keywords: &[
                "pẹpẹ ìwe àwòrán àfihàn",
                "àtẹ",
                "àtẹ alátọ\u{301}ka",
                "àtẹ onígun",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("棒型圖"),
            keywords: &["圖", "圖表", "棒", "棒型圖"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("棒型图"),
            keywords: &["图", "图表", "棒", "棒型图"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("条形图"),
            keywords: &["图表", "条形图", "柱形图", "直方图"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("圖表"),
            keywords: &["圖表", "直方圖"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("棒形圖"),
            keywords: &["圖表", "棒形圖"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ishadi eliyibha"),
            keywords: &["ibha", "igrafu", "ishadi", "ishadi eliyibha"],
        },
    ],
};
#[doc = "📋"]
pub const CLIPBOARD: crate::Emoji = crate::Emoji {
    glyph: "📋",
    codepoint: "1F4CB",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "clipboard",
    group: "Objects",
    subgroup: "office",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("knypbord"),
            keywords: &["bord", "knip", "knyp", "knypbord"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወረቀት ማስደገፊያ"),
            keywords: &["ወረቀት ማስደገፊያ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("لوح كتابة مشبكي"),
            keywords: &["لوح كتابة مشبكي", "مشبك"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9cd}লিপব’ৰ\u{9cd}ড"),
            keywords: &["ক\u{9cd}লিপব’ৰ\u{9cd}ড"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("lövhə"),
            keywords: &["lövhə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("планшэт з заціскам"),
            keywords: &["заціск", "папера", "планшэт", "планшэт з заціскам"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("клипборд"),
            keywords: &["клипборд"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9cd}লিপবোর\u{9cd}ড"),
            keywords: &["ক\u{9cd}লিপবোর\u{9cd}ড"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("tabla za držanje papira"),
            keywords: &["clipboard", "tabla za držanje papira"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("porta-retalls"),
            keywords: &["agafes", "clip", "petjapapers", "porta-retalls"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎬᎭᎸᏓ ᏗᏍᏆᏂᎪᏙᏗ"),
            keywords: &["ᏗᎬᎭᎸᏓ ᏗᏍᏆᏂᎪᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("psací podložka"),
            keywords: &["deska", "dokumenty", "klip", "podložka", "psací podložka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("clipfwrdd"),
            keywords: &["clipfwrdd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("clipboard"),
            keywords: &["clipboard", "udklipsholder"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Klemmbrett"),
            keywords: &["Clipboard", "Klemmbrett", "Zwischenablage"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πρόχειρο"),
            keywords: &["πρόχειρο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("clipboard"),
            keywords: &["clipboard"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("portapapeles"),
            keywords: &["papeles", "pinza", "portapapeles", "tabla"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["carpeta", "portapapeles", "sujetapapeles"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kirjutamisalus"),
            keywords: &["alus", "kirjutamisalus", "leht", "paber"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ohar-bloka"),
            keywords: &["ohar-blok", "ohar-bloka"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تخته\u{654} گیره\u{200c}دار"),
            keywords: &[
                "تخته رسم",
                "تخته رسم گیره\u{200c}دار",
                "تخته زیردستی",
                "تخته\u{654} گیره\u{200c}دار",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("leikepöytä"),
            keywords: &["leikepöytä", "levy", "paperinpidike"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("clipboard"),
            keywords: &["clipboard"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("klemmuspjald"),
            keywords: &["klemmuspjald", "setiborð"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("porte-bloc"),
            keywords: &["fournitures", "porte-bloc"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("presse-papiers"),
            keywords: &["fournitures", "presse-papiers"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("gearrthaisce"),
            keywords: &["fáisc-chlár", "gearrthaisce"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("stòr-bhòrd"),
            keywords: &["bòrd-chliopaichean", "stòr-bhòrd"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("portapapeis"),
            keywords: &["portapapeis"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ક\u{acd}લિપબૉર\u{acd}ડ"),
            keywords: &["ક\u{acd}લિપબૉર\u{acd}ડ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("allon zane"),
            keywords: &["allon zane"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לוח כתיבה"),
            keywords: &["כתיבה", "לוח"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("क\u{94d}लिपबोर\u{94d}ड"),
            keywords: &["क\u{94d}लिपबोर\u{94d}ड"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("držač spisa"),
            keywords: &["držač spisa"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("írótábla"),
            keywords: &["írótábla"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սեղմակով տախտակ"),
            keywords: &["սեղմակ", "սեղմակով տախտակ", "տախտակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("papan klip"),
            keywords: &["papan klip"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("klipbọọdụ"),
            keywords: &["klipbọọdụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("klippiborð"),
            keywords: &["klemmuspjald", "klippiborð", "muna"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("portablocco"),
            keywords: &["appunti", "portablocco"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("クリップボード"),
            keywords: &["クリップ", "クリップボード", "文具", "文房具"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("papan lemek"),
            keywords: &["papan lemek"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მისამაგრებელი დაფა"),
            keywords: &["დაფა", "მისამაგრებელი დაფა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тақта"),
            keywords: &["тақта"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("clipboard"),
            keywords: &["clipboard"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ក\u{17d2}តារកៀបក\u{17d2}រដាសសម\u{17d2}រាប\u{17cb}សរសេរ"),
            keywords: &[
                "ក\u{17d2}តារកៀប",
                "ក\u{17d2}តារកៀបក\u{17d2}រដាសសម\u{17d2}រាប\u{17cb}សរសេរ",
                "ក\u{17d2}រដាស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{ccd}ಲ\u{cbf}ಪ\u{ccd}\u{200c}ಬೋರ\u{ccd}ಡ\u{ccd}"),
            keywords: &["ಕ\u{ccd}ಲ\u{cbf}ಪ\u{ccd}\u{200c}ಬೋರ\u{ccd}ಡ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("클립보드"),
            keywords: &["클리핑", "클립", "클립보드"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("क\u{94d}लिपबोर\u{94d}ड"),
            keywords: &["क\u{94d}लिपबोर\u{94d}ड"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кыскычтуу пюпитр"),
            keywords: &["кыскычтуу пюпитр", "флипчарт"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Notizbriet"),
            keywords: &["Notizbriet"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຄລ\u{eb4}ບບອດ"),
            keywords: &["ຄລ\u{eb4}ບບອດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("segtuvas"),
            keywords: &["segtuvas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("dokumentu paliktnis"),
            keywords: &["dokuments", "dokumentu paliktnis", "paliktnis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("paparawhi"),
            keywords: &["paparawhi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("табла за хартија"),
            keywords: &["исечок", "табла", "табла за хартија"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d4d}ലിപ\u{d4d}ബോർഡ\u{d4d}"),
            keywords: &[
                "ക\u{d4d}ലിപ\u{d4d} ബോർഡ\u{d4d}",
                "ക\u{d4d}ലിപ\u{d4d}ബോർഡ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("самбар"),
            keywords: &["самбар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("क\u{94d}लिपबोर\u{94d}ड"),
            keywords: &["क\u{94d}लिपबोर\u{94d}ड"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("papan klip"),
            keywords: &["papan klip"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("klibbord"),
            keywords: &["klibbord"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကလစ\u{103a}ဘ\u{102f}တ\u{103a}"),
            keywords: &["ကလစ\u{103a}ဘ\u{102f}တ\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("skriveplate"),
            keywords: &["ordrebrett", "skriveplate", "tavle", "utklippstavle"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("क\u{94d}लिपबोर\u{94d}ड"),
            keywords: &["क\u{94d}लिपबोर\u{94d}ड"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("klembord"),
            keywords: &["klembord"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("skriveplate"),
            keywords: &["ordrebrett", "skriveplate", "tavle", "utklippstavle"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b4d}ଲ\u{b3f}ପ\u{b4d}\u{200c}ବୋର\u{b4d}ଡ"),
            keywords: &[
                "କ\u{b4d}ଲ\u{b3f}ପ\u{b4d}\u{200c}ବୋର\u{b4d}ଡ",
                "କ\u{b4d}ଲ\u{b3f}ପ\u{b4d}\u{200c}ବୋର\u{b4d}ଡ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਲਿ\u{a71}ਪਬ\u{a4b}ਰਡ"),
            keywords: &["ਕਲਿ\u{a71}ਪਬ\u{a4b}ਰਡ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کلپ بورڈ"),
            keywords: &["کلپ بورڈ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Klípbọd"),
            keywords: &["Klípbọd"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("podkładka do pisania"),
            keywords: &[
                "kartka",
                "notes",
                "pisanie",
                "pisać",
                "podkładka",
                "podkładka do pisania",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کلیپ بورډ"),
            keywords: &["کلیپ بورډ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("prancheta"),
            keywords: &["anotações", "prancheta"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("planșetă"),
            keywords: &["planșetă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-648"),
            keywords: &["E10-648"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("планшет с зажимом"),
            keywords: &["бумага", "зажим", "лист", "планшет", "планшет с зажимом"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ububikogateganyo"),
            keywords: &["ububikogateganyo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪلپ بورڊ"),
            keywords: &["ڪلپ بورڊ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කල\u{dd2}ප\u{dca}බෝඩ\u{dca}"),
            keywords: &[
                "කල\u{dd2}ප\u{dca}බෝඩ\u{dca}",
                "ක\u{dca}ල\u{dd2}ප\u{dca}බෝඩ\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("písacia podložka"),
            keywords: &["podložka", "poznámka", "písacia podložka", "písanie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("podložna mapa"),
            keywords: &["podložna mapa"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("faylka qorista"),
            keywords: &["faylka qorista"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("mbajtëse letrash"),
            keywords: &["mbajtëse letrash"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("клипборд"),
            keywords: &["клипборд"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("klipbord"),
            keywords: &["klipbord"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("skrivplatta"),
            keywords: &["clipboard", "skrivplatta", "urklipp"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ubao wa kunakili"),
            keywords: &["ubao wa kunakili"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பர\u{bc0}ட\u{bcd}சை அட\u{bcd}டை"),
            keywords: &[
                "கிளிப\u{bcd}",
                "கிளிப\u{bcd} போர\u{bcd}டு",
                "பர\u{bc0}ட\u{bcd}சை அட\u{bcd}டை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c4d}ల\u{c3f}ప\u{c4d}\u{200c}బ\u{c4b}ర\u{c4d}డ\u{c4d}"),
            keywords: &[
                "క\u{c4d}ల\u{c3f}ప\u{c4d}\u{200c}బ\u{c4b}ర\u{c4d}డ\u{c4d}",
                "బ\u{c4b}ర\u{c4d}డ\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҳофизаи муваққатӣ"),
            keywords: &["ҳофизаи муваққатӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("คล\u{e34}ปบอร\u{e4c}ด"),
            keywords: &["คล\u{e34}ปบอร\u{e4c}ด"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("bildiriş tagtasy"),
            keywords: &["bildiriş tagtasy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("papa fakamaʻu pepa"),
            keywords: &["papa fakamaʻu pepa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("pano"),
            keywords: &["pano"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كېسىش تاختىسى"),
            keywords: &["كېسىش تاختىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("планшет для аркушів"),
            keywords: &["папка", "планшет", "планшет для аркушів"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کلپ بورڈ"),
            keywords: &["اسٹیشنری", "کلپ بورڈ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qisqichli doska"),
            keywords: &["qisqichli doska"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bảng ghi nhớ"),
            keywords: &["bảng ghi nhớ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("klasëru kepp-kayit"),
            keywords: &["klasëru kepp-kayit"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iklipbhodi"),
            keywords: &["iklipbhodi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("aka ọlọ\u{301}pọ\u{300}n"),
            keywords: &["aka ọlọ\u{301}pọ\u{300}n"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("筆記板"),
            keywords: &["筆記板"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("笔记板"),
            keywords: &["笔记板"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("剪贴板"),
            keywords: &["写字板", "剪贴板", "剪贴簿", "夹子", "纸张"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("寫字夾板"),
            keywords: &["寫字夾板"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("剪貼簿"),
            keywords: &["剪貼簿"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhodi lokunamathelisa"),
            keywords: &["ibhodi lokunamathelisa"],
        },
    ],
};
#[doc = "📌"]
pub const PUSHPIN: crate::Emoji = crate::Emoji {
    glyph: "📌",
    codepoint: "1F4CC",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "pushpin",
    group: "Objects",
    subgroup: "office",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("duimspyker"),
            keywords: &["duim", "duimspyker", "speld", "spyker"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ፑሽ እስፒል"),
            keywords: &["እስፒል", "ፑሽ እስፒል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("دبوس ضغط"),
            keywords: &["دبوس", "دبوس ضغط"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9c1}শ\u{9cd}বপিন"),
            keywords: &["পিন", "প\u{9c1}শ\u{9cd}বপিন"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("löhvə düyməsi"),
            keywords: &["löhvə düyməsi", "sancaq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("канцылярская кнопка"),
            keywords: &["канцылярская кнопка", "кнопка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("кабърче"),
            keywords: &["кабърче"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9c1}শপিন"),
            keywords: &["পিন", "প\u{9c1}শপিন"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("tach-meud"),
            keywords: &["dafar", "tach-meud"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("pribadača"),
            keywords: &["pribadača", "špenadla"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("xinxeta"),
            keywords: &["agulla", "xinxeta"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏴᎩ ᎦᎭᏙᏗ"),
            keywords: &["ᎤᏍᏆᏘ", "ᏴᎩ ᎦᎭᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("připínáček"),
            keywords: &["napínáček", "připínáček", "špendlík"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("pin"),
            keywords: &["pin", "pin gwthio"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("tegnestift"),
            keywords: &["stift", "tegnestift"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Reißzwecke"),
            keywords: &["Reißzwecke", "anpinnen"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Reisszwecke"),
            keywords: &["Reisszwecke", "anpinnen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πινέζα"),
            keywords: &["πινέζα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("pushpin"),
            keywords: &["pin", "pushpin"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["map pin", "pin", "pushpin"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("drawing-pin"),
            keywords: &["drawing-pin", "pin"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("chincheta"),
            keywords: &["chincheta", "tachuela"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["chinche", "chincheta", "tachuela"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nööpnõel"),
            keywords: &["nõel", "nööpnõel"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("txintxeta"),
            keywords: &["txintxeta"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("سنجاق"),
            keywords: &["سنجاق", "پونز", "پین"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("nuppineula"),
            keywords: &["nuppineula"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pushpin"),
            keywords: &["aspile", "pin", "pushpin"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("nipsnál"),
            keywords: &["nipsnál", "nál"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("punaise"),
            keywords: &["fournitures", "punaise"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("épingle"),
            keywords: &["fournitures", "épingle"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("tacóid ordóige"),
            keywords: &["biorán", "tacóid", "tacóid ordóige"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("tacaid-bhrùthaidh"),
            keywords: &["prìne", "tacaid", "tacaid-bhrùthaidh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("chincheta"),
            keywords: &["chincheta"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{ac1}શપિન"),
            keywords: &["પિન", "પ\u{ac1}શપિન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mai yin maki wuri"),
            keywords: &["fil", "mai yin maki wuri"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("נעץ"),
            keywords: &["נעץ", "סיכה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{941}शपिन"),
            keywords: &["पिन", "प\u{941}शपिन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("pribadača"),
            keywords: &["pribadača"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("rajzszög"),
            keywords: &["rajzszög"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("քորոց"),
            keywords: &["քորոց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("paku penanda"),
            keywords: &["paku penanda", "pin"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("pushpinụ\u{300}"),
            keywords: &["pin", "pushpinụ\u{300}"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("teiknibóla"),
            keywords: &["pinni", "teiknibóla"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("puntina"),
            keywords: &["puntina", "puntina da disegno"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("押しピン"),
            keywords: &["押しピン", "文具", "文房具", "画鋲"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pines"),
            keywords: &["pines"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჭიკარტი"),
            keywords: &["ქინძისთავი", "ჭიკარტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("кеңселік батырма"),
            keywords: &["кеңселік батырма", "істік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("tegnestift"),
            keywords: &["stift", "tegnestift"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17d2}ជ\u{17bb}លដោតលើក\u{17d2}តារជ\u{17bc}នដ\u{17c6}ណ\u{17b9}ង"),
            keywords: &[
                "ម\u{17d2}ជ\u{17bb}ល",
                "ម\u{17d2}ជ\u{17bb}លដោត",
                "ម\u{17d2}ជ\u{17bb}លដោតលើក\u{17d2}តារជ\u{17bc}នដ\u{17c6}ណ\u{17b9}ង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪುಶ\u{ccd}\u{200c}ಪ\u{cbf}ನ\u{ccd}"),
            keywords: &["ಪ\u{cbf}ನ\u{ccd}", "ಪುಶ\u{ccd}\u{200c}ಪ\u{cbf}ನ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("압정"),
            keywords: &["압정", "핀"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("प\u{941}शपीन"),
            keywords: &["पीन", "प\u{941}शपीन"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("мончоктуу төөнөгүч"),
            keywords: &["мончоктуу төөнөгүч", "төөнөгүч"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Punaise"),
            keywords: &["Punaise"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຂ\u{eb1}ມປ\u{eb1}ກໝ\u{eb8}ດ"),
            keywords: &[
                "ປ\u{eb1}ກໝ\u{eb8}ດ",
                "ເຂ\u{eb1}ມ",
                "ເຂ\u{eb1}ມປ\u{eb1}ກໝ\u{eb8}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("smeigtukas"),
            keywords: &["smeigtukas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("piespraude"),
            keywords: &["piespraude", "spraudīte"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pinepana"),
            keywords: &["pine", "pinepana"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("притискач"),
            keywords: &["игла", "притискач"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d41}ഷ\u{d4d} പിൻ"),
            keywords: &["പിൻ", "പ\u{d41}ഷ\u{d4d} പിൻ", "പ\u{d41}ഷ\u{d4d}പിൻ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хатгуур"),
            keywords: &["хатгуур", "хатгуур кноп"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{941}शपिन"),
            keywords: &["पिन", "प\u{941}शपिन"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("paku tekan"),
            keywords: &["paku tekan", "pin"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("pushpin"),
            keywords: &["pin", "pushpin"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဖ\u{102d}ထ\u{102d}\u{102f}းရသည\u{1037}\u{103a} ပင\u{103a}အပ\u{103a}"),
            keywords: &[
                "ပင\u{103a}အပ\u{103a}",
                "ဖ\u{102d}ထ\u{102d}\u{102f}းရသည\u{1037}\u{103a} ပင\u{103a}အပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("stift"),
            keywords: &["kontorrekvisita", "stift"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{941}सपिन"),
            keywords: &["पिन", "प\u{941}सपिन"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("punaise"),
            keywords: &["punaise", "speld"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("stift"),
            keywords: &["kontorrekvisita", "stift"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b41}ସପ\u{b3f}ନ\u{b4d}"),
            keywords: &[
                "ପ\u{b3f}ନ\u{b4d}",
                "ପ\u{b41}ସପ\u{b3f}ନ\u{b4d}",
                "ପ\u{b41}ସ\u{b4d}\u{200c}ପ\u{b3f}ନ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a41}ਸ\u{a3c} ਪਿ\u{a70}ਨ"),
            keywords: &["ਪਿ\u{a70}ਨ", "ਪ\u{a41}ਸ\u{a3c} ਪਿ\u{a70}ਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پش پن"),
            keywords: &["س\u{64f}وئی", "پش پن"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Púshpin"),
            keywords: &["Pin", "Púshpin"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pinezka"),
            keywords: &["pinezka", "przypiąć"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ګل مېخ"),
            keywords: &["پن", "ګل مېخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("tacha"),
            keywords: &["alfinete", "tacha"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("pionés"),
            keywords: &["alfinete", "pionés", "tacha"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("piuneză"),
            keywords: &["ac", "fixare", "pioneză", "piuneză"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-649"),
            keywords: &["E10-649"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("канцелярская кнопка"),
            keywords: &["бумага", "канцелярская кнопка", "кнопка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("pushipini"),
            keywords: &["gufatisha", "pushipini"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("دٻائڻ واري پن"),
            keywords: &["دٻائڻ واري پن", "پن"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd4}ෂ\u{dca}ප\u{dd2}න\u{dca}"),
            keywords: &["ප\u{dd2}න\u{dca}", "ප\u{dd4}ෂ\u{dca}ප\u{dd2}න\u{dca}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("špendlík"),
            keywords: &["špendlík"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("risalni žebljiček"),
            keywords: &["risalni žebljiček"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("biinka wax lagu dhajiyo"),
            keywords: &["biin", "biinka wax lagu dhajiyo"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gjilpërë kapëse"),
            keywords: &["gjilpërë", "gjilpërë kapëse"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("прибадача"),
            keywords: &["прибадача", "чиода"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["прибадача"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("pribadača"),
            keywords: &["pribadača", "čioda"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["pribadača"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kartnål"),
            keywords: &["kartnål", "stift"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("pini"),
            keywords: &["pini"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பின\u{bcd}"),
            keywords: &["ஊசி", "பின\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("పుష\u{c4d} ప\u{c3f}న\u{c4d}"),
            keywords: &["ప\u{c3f}న\u{c4d}", "పుష\u{c4d}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тугмачаи сӯзандор"),
            keywords: &["сӯзан", "тугмачаи сӯзандор"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หม\u{e38}ดป\u{e31}ก"),
            keywords: &["หม\u{e38}ด", "หม\u{e38}ดป\u{e31}ก"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("düwme"),
            keywords: &["düwme", "iňňe"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pine"),
            keywords: &["pine"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("raptiye"),
            keywords: &["iğne", "raptiye"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كۇنۇپكا"),
            keywords: &["قاداق", "كۇنۇپكا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("канцелярська кнопка"),
            keywords: &["канцелярська кнопка", "кнопка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پ\u{64f}ش پن"),
            keywords: &["اسٹیشنری", "پ\u{64f}ش پن", "پ\u{650}ن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("bosma mix"),
            keywords: &["bosma mix", "bosma mixcha"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đinh ghim"),
            keywords: &["cái ghim", "đinh ghim"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("pasarel"),
            keywords: &["pasarel", "pinees"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-pushpin"),
            keywords: &["i-pushpin", "unotaka"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("abẹ\u{301}rẹ\u{301}ohunyíyà"),
            keywords: &["abẹ\u{301}rẹ\u{301}", "abẹ\u{301}rẹ\u{301}ohunyíyà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("禁釘"),
            keywords: &["大頭針", "禁釘"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("禁钉"),
            keywords: &["大头针", "禁钉"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("图钉"),
            keywords: &["固定", "图钉", "按钉"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("圖釘"),
            keywords: &["圖釘"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("大頭釘"),
            keywords: &["大頭釘"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphini wokuphusha"),
            keywords: &["uphini", "uphini wokuphusha"],
        },
    ],
};
#[doc = "📍"]
pub const ROUND_PUSHPIN: crate::Emoji = crate::Emoji {
    glyph: "📍",
    codepoint: "1F4CD",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "round pushpin",
    group: "Objects",
    subgroup: "office",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("ronde duimspyker"),
            keywords: &["duim", "ronde duimspyker", "speld", "spyker"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ክብ ፑሽ እስፒል"),
            keywords: &["እስፒል", "ክብ ፑሽ እስፒል", "ፑሽ እስፒል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("دبوس مستدير"),
            keywords: &["دبوس", "دبوس مستدير", "مشبك"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ঘ\u{9c2}ৰণীয\u{9bc}\u{9be} প\u{9c1}শ\u{9cd}বপিন"),
            keywords: &[
                "ঘ\u{9c2}ৰণীয\u{9bc}\u{9be} প\u{9c1}শ\u{9cd}বপিন",
                "পিন",
                "প\u{9c1}শ\u{9cd}বপিন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("dairəvi sancaq"),
            keywords: &["basmadüymə", "dairəvi sancaq", "sancaq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("круглая канцылярская кнопка"),
            keywords: &["кнопка", "круглая", "круглая канцылярская кнопка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Кръгло кабърче"),
            keywords: &["Кръгло кабърче", "кабърче", "кръгло"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("গোল\u{9be}ক\u{9be}র প\u{9c1}শপিন"),
            keywords: &["গোল\u{9be}ক\u{9be}র প\u{9c1}শপিন", "পিন", "প\u{9c1}শ পিন"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("tach-meud ront"),
            keywords: &["dafar", "tach-meud ront"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("okrugla pribadača"),
            keywords: &["okrugla pribadača", "pribadača", "špenadla"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("xinxeta rodona"),
            keywords: &["rodona", "xinxeta"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏐᏆᎸ ᏴᎩ ᎦᎭᏙᏗ"),
            keywords: &["ᎦᏐᏆᎸ ᏴᎩ ᎦᎭᏙᏗ", "ᏗᎪᏪᎶᏗ", "ᏴᎩ ᎦᎭᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kulatý připínáček"),
            keywords: &["kulatý připínáček", "napínáček", "špendlík"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("pin crwn"),
            keywords: &["pin", "pin crwn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("rund tegnestift"),
            keywords: &["rund tegnestift", "stift", "tegnestift"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Stecknadel"),
            keywords: &[
                "Reißzwecke",
                "Stecknadel",
                "anpinnen",
                "rund",
                "runde Reißzwecke",
            ],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("runde Reisszwecke"),
            keywords: &["Reisszwecke", "anpinnen", "rund", "runde Reisszwecke"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("στρογγυλοκέφαλη πινέζα"),
            keywords: &["πινέζα", "στρογγυλοκέφαλη πινέζα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("round pushpin"),
            keywords: &["pin", "pushpin", "round pushpin"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("round drawing-pin"),
            keywords: &["pin", "pushpin", "round drawing-pin"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("chincheta redonda"),
            keywords: &["chincheta", "chincheta redonda"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["chinche", "chincheta", "chincheta redonda", "tachuela"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("ümara peaga nööpnõel"),
            keywords: &["nõel", "nööpnõel", "ümara peaga nööpnõel"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("txintxeta biribila"),
            keywords: &["biribil", "txintxeta", "txintxeta biribila"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("سنجاق ته\u{200c}گرد"),
            keywords: &["سنجاق ته\u{200c}گرد", "پین"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pyöreä nasta"),
            keywords: &["karttanaula", "nasta", "pyöreä nasta"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bilog na pushpin"),
            keywords: &["aspile", "bilog", "bilog na pushpin", "pin", "pushpin"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("rund nipsnál"),
            keywords: &["nipsnál", "nál", "rund nipsnál"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("épingle"),
            keywords: &["fournitures", "épingle"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("épingle à tête ronde"),
            keywords: &["fournitures", "épingle à tête ronde"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("tacóid chruinn"),
            keywords: &["tacóid chruinn"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("tacaid-bhrùthaidh chruinn"),
            keywords: &[
                "prìne",
                "tacaid",
                "tacaid-bhrùthaidh",
                "tacaid-bhrùthaidh chruinn",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("chincheta redonda"),
            keywords: &["chincheta", "redonda"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ગોળાકાર પ\u{ac1}શપિન"),
            keywords: &["ગોળાકાર પ\u{ac1}શપિન", "પિન", "પ\u{ac1}શપિન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kewayen mai yin maki wuri"),
            keywords: &["fil", "kewayen mai yin maki wuri", "mai yin maki wuri"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סיכה"),
            keywords: &["נעץ", "סיכה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("गोल प\u{941}शपिन"),
            keywords: &["गोल प\u{941}शपिन", "पिन", "प\u{941}शपिन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zaobljena pribadača"),
            keywords: &["pribadača", "zaobljena pribadača", "čavlić"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kerek rajzszög"),
            keywords: &["kerek rajzszög", "rajzszög"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("գնդասեղ"),
            keywords: &["գնդասեղ", "քորոց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("paku penanda bulat"),
            keywords: &["paku", "paku penanda bulat", "pin"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("pushpinụ\u{300} okirikiri"),
            keywords: &["pin", "pushpinụ\u{300}", "pushpinụ\u{300} okirikiri"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("teiknibóla með kúlu"),
            keywords: &["teiknibóla", "teiknibóla með kúlu"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("puntina arrotondata"),
            keywords: &["puntina", "puntina arrotondata", "puntina da disegno"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("丸い押しピン"),
            keywords: &[
                "プッシュピン",
                "丸い押しピン",
                "押しピン",
                "文具",
                "文房具",
                "画びょう",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pines bendhul"),
            keywords: &["pines bendhul"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მრგვალი ჭიკარტი"),
            keywords: &["მრგვალი ჭიკარტი", "ქინძისთავი", "ჭიკარტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("басы доңғалақ батырма"),
            keywords: &["басы доңғалақ батырма", "батырма", "істік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("rund tegnestift"),
            keywords: &["rund tegnestift", "stift", "tegnestift"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17d2}ជ\u{17bb}លដោតក\u{17d2}បាលម\u{17bc}ល"),
            keywords: &[
                "ម\u{17d2}ជ\u{17bb}ល",
                "ម\u{17d2}ជ\u{17bb}លដោត",
                "ម\u{17d2}ជ\u{17bb}លដោតក\u{17d2}បាលម\u{17bc}ល",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ರ\u{ccc}ಂಡ\u{ccd} ಪುಶ\u{ccd}\u{200c}ಪ\u{cbf}ನ\u{ccd}"),
            keywords: &[
                "ದುಂಡನ\u{cc6}ಯ ಪುಶ\u{ccd}\u{200c}ಪ\u{cbf}ನ\u{ccd}",
                "ಪ\u{cbf}ನ\u{ccd}",
                "ಪುಶ\u{ccd}\u{200c}ಪ\u{cbf}ನ\u{ccd}",
                "ರ\u{ccc}ಂಡ\u{ccd} ಪುಶ\u{ccd}\u{200c}ಪ\u{cbf}ನ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("둥근 머리 핀"),
            keywords: &["둥근 머리 압정", "둥근 머리 핀", "압정", "핀"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("वा\u{902}टक\u{941}ळी प\u{941}शपीन"),
            keywords: &["पीन", "प\u{941}शपीन", "वा\u{902}टक\u{941}ळी प\u{941}शपीन"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тегерек төөнөгүч"),
            keywords: &["кнопка", "тегерек төөнөгүч", "төөнөгүч"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("ronn Punaise"),
            keywords: &["Punaise", "ronn Punaise"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໝ\u{eb8}ດປ\u{eb1}ກຫ\u{ebb}ວມ\u{ebb}ນ"),
            keywords: &[
                "ຫ\u{ebb}ວມ\u{ebb}ນ",
                "ໝ\u{eb8}ດປ\u{eb1}ກ",
                "ໝ\u{eb8}ດປ\u{eb1}ກຫ\u{ebb}ວມ\u{ebb}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("apvalus smeigtukas"),
            keywords: &["apvalus smeigtukas", "smeigtukas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("apaļa spraudīte"),
            keywords: &["apaļa spraudīte", "apaļš", "spraudīte"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pinepana porohita"),
            keywords: &["pine", "pinepana", "pinepana porohita"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("топуска"),
            keywords: &["игла", "топуска"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("റ\u{d57}ണ\u{d4d}ട\u{d4d} പ\u{d41}ഷ\u{d4d} പിൻ"),
            keywords: &[
                "പിൻ",
                "പ\u{d41}ഷ\u{d4d}പിൻ",
                "റ\u{d57}ണ\u{d4d}ട\u{d4d} പ\u{d41}ഷ\u{d4d} പിൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бөөрөнхий тогтоогч"),
            keywords: &["бөөрөнхий", "тогтоогч"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("गोलाकार प\u{941}शपिन"),
            keywords: &["गोलाकार प\u{941}शपिन", "पिन", "प\u{941}शपिन"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("paku tekan bulat"),
            keywords: &["paku tekan bulat", "pin", "pin tekan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("pushpin tond"),
            keywords: &["pin", "pushpin", "pushpin tond"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ထ\u{102d}\u{102f}းအပ\u{103a} အဝ\u{102d}\u{102f}င\u{103a}း"),
            keywords: &[
                "ထ\u{102d}\u{102f}းအပ\u{103a} အဝ\u{102d}\u{102f}င\u{103a}း",
                "ပင\u{103a}",
                "ပင\u{103a}အပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("rund stift"),
            keywords: &["kontorrekvisita", "markørnål", "rund stift"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("गोलो प\u{941}सपिन"),
            keywords: &["गोलो प\u{941}सपिन", "पिन", "प\u{941}सपिन"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("ronde speld"),
            keywords: &["kopspeld", "ronde speld", "speld"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("rund stift"),
            keywords: &["kontorrekvisita", "markørnål", "rund stift"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଗୋଲ\u{b3e}କ\u{b3e}ର ପ\u{b41}ସ\u{b4d}\u{200c}\u{200c}ପ\u{b3f}ନ\u{b4d}\u{200c}",
            ),
            keywords: &[
                "ଗୋଲ ପ\u{b41}ସ\u{b4d}\u{200c}ପ\u{b3f}ନ\u{b4d}",
                "ଗୋଲ\u{b3e}କ\u{b3e}ର ପ\u{b41}ସ\u{b4d}\u{200c}\u{200c}ପ\u{b3f}ନ\u{b4d}\u{200c}",
                "ପ\u{b3f}ନ\u{b4d}",
                "ପ\u{b41}ସ\u{b4d}\u{200c}ପ\u{b3f}ନ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਗ\u{a4b}ਲ ਪ\u{a41}ਸ\u{a3c} ਪਿ\u{a70}ਨ"),
            keywords: &[
                "ਗ\u{a4b}ਲ ਪ\u{a41}ਸ\u{a3c} ਪਿ\u{a70}ਨ",
                "ਪਿ\u{a70}ਨ",
                "ਪ\u{a41}ਸ\u{a3c} ਪਿ\u{a70}ਨ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("گول پش پن"),
            keywords: &["س\u{64f}وئی", "پش پن", "گول پش پن"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Raúnd Púshpin"),
            keywords: &["Pin", "Púshpin", "Raúnd Púshpin"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("okrągła pinezka"),
            keywords: &["okrągła pinezka", "z główką"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ګول ګل مېخ"),
            keywords: &["پن", "ګل مېخ", "ګول ګل مېخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("tacha redonda"),
            keywords: &["alfinete", "tacha", "tacha redonda"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("alfinete de cabeça redonda"),
            keywords: &["alfinete", "alfinete de cabeça redonda", "redondo"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ac cu gămălie"),
            keywords: &["ac cu gămălie", "ac cu gămălie rotundă", "bold", "piuneză"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-650"),
            keywords: &["E10-650"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("канцелярская кнопка с шариком"),
            keywords: &["бумага", "канцелярская кнопка с шариком", "кнопка", "шарик"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("agafashi kazengurutse"),
            keywords: &[
                "agafashi kazengurutse",
                "agashinge",
                "agashinge gafata impapuro",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("گول دٻائڻ واري پن"),
            keywords: &["دٻائڻ واري پن", "پشپن", "پن", "گول دٻائڻ واري پن"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("රව\u{dd4}ම\u{dca} ප\u{dd4}ෂ\u{dca}ප\u{dd2}න\u{dca}"),
            keywords: &[
                "ප\u{dd2}න\u{dca}",
                "ප\u{dd4}ෂ\u{dca}ප\u{dd2}න\u{dca}",
                "රව\u{dd4}ම\u{dca} ප\u{dd4}ෂ\u{dca}ප\u{dd2}න\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("guľatý špendlík"),
            keywords: &["guľatý špendlík", "špendlík"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("okrogli risalni žebljiček"),
            keywords: &["okrogli risalni žebljiček", "risalni žebljiček"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("biinka wax lagu dhajiyo oo goobo ah"),
            keywords: &[
                "biin",
                "biinka wax lagu dhajiyo",
                "biinka wax lagu dhajiyo oo goobo ah",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gjilpërë kapëse e rrumbullakët"),
            keywords: &[
                "gjilpërë",
                "gjilpërë kapëse",
                "gjilpërë kapëse e rrumbullakët",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("чиода"),
            keywords: &["прибaдaчa", "чиода"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("čioda"),
            keywords: &["pribadača", "čioda"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("knappnål"),
            keywords: &["knappnål", "nål", "stift"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("pini yenye kichwa cha mduara"),
            keywords: &["pini", "pini yenye kichwa cha mduara"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("குண\u{bcd}டூசி"),
            keywords: &["குண\u{bcd}டூசி", "பின\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("గుండు సూద\u{c3f}"),
            keywords: &["గుండు ప\u{c3f}న\u{c4d}ను", "గుండు సూద\u{c3f}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тугмачаи сӯзандори даврашакл"),
            keywords: &["сӯзан", "тугмачаи сӯзандор", "тугмачаи сӯзандори даврашакл"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หม\u{e38}ดห\u{e31}วกลม"),
            keywords: &["หม\u{e38}ด", "หม\u{e38}ดห\u{e31}วกลม"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("tokga iňňejik"),
            keywords: &["iňňe", "knopka", "tokga iňňejik"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pine fuopotopoto"),
            keywords: &["pine fuopotopoto"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yuvarlak raptiye"),
            keywords: &["iğne", "raptiye", "yuvarlak raptiye"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يۇمىلاق مىخ"),
            keywords: &["قاداق", "كۇنۇپكا", "يۇمىلاق مىخ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("шпилька з круглою голівкою"),
            keywords: &["канцелярський", "кнопка", "шпилька з круглою голівкою"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گول پ\u{64f}ش پن"),
            keywords: &["اسٹیشنری", "پ\u{650}ن", "گول", "گول پ\u{64f}ش پن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yumaloq bosma mix"),
            keywords: &["bosma mixcha", "yumaloq bosma mix"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đinh ghim hình tròn"),
            keywords: &["ghim", "đinh ghim", "đinh ghim hình tròn"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bitoŋ bu roŋ"),
            keywords: &["bitoŋ bu roŋ", "pinees"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("unotaka otyhalwayo ongqukuva"),
            keywords: &["i-pushpin", "unotaka", "unotaka otyhalwayo ongqukuva"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("abẹ\u{301}rẹ\u{301}ohunyíyà roboto"),
            keywords: &[
                "abẹ\u{301}rẹ\u{301}",
                "abẹ\u{301}rẹ\u{301}ohunyíyà roboto",
                "píìnì àgbáwọlé",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("圓禁釘"),
            keywords: &["圓禁釘", "大頭針", "禁釘"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("圆禁钉"),
            keywords: &["圆禁钉", "大头针", "禁钉"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("圆图钉"),
            keywords: &["固定", "图钉", "圆图钉"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("圓圖釘"),
            keywords: &["圓圖釘", "圖釘"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("圓頭大頭釘"),
            keywords: &["圓頭大頭釘", "圓頭大頭釘｜大頭釘"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphini wokuphusha oyindingilizi"),
            keywords: &[
                "uphini",
                "uphini wokuphusha",
                "uphini wokuphusha oyindingilizi",
            ],
        },
    ],
};
#[doc = "📎"]
pub const PAPERCLIP: crate::Emoji = crate::Emoji {
    glyph: "📎",
    codepoint: "1F4CE",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "paperclip",
    group: "Objects",
    subgroup: "office",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("skuifspeld"),
            keywords: &["papier", "skuifspeld", "speld"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወረቀት ማያያዣ"),
            keywords: &["ወረቀት ማያያዣ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مشبك ورق"),
            keywords: &["مشبك", "مشبك ورق"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("পেপ\u{9be}ৰক\u{9cd}লিপ"),
            keywords: &["পেপ\u{9be}ৰক\u{9cd}লিপ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("skrepka"),
            keywords: &["skrepka"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сашчэпка"),
            keywords: &["канцылярыя", "папера", "сашчэпка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("кламер"),
            keywords: &["кламер"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("পেপ\u{9be}রক\u{9cd}লিপ"),
            keywords: &["পেপ\u{9be}রক\u{9cd}লিপ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("strobell"),
            keywords: &["dafar", "strobell"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("spajalica"),
            keywords: &["spajalica"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("clip"),
            keywords: &["clip"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏔᎷᎩᏍᏗ ᎬᏙᏗ"),
            keywords: &["ᏔᎷᎩᏍᏗ ᎬᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kancelářská sponka"),
            keywords: &["kancelářská sponka", "papír", "svorka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("clip papur"),
            keywords: &["clip papur"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("papirclips"),
            keywords: &["clips", "papirclips"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Büroklammer"),
            keywords: &["Büroklammer"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("συνδετήρας"),
            keywords: &["συνδετήρας"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("paperclip"),
            keywords: &["paperclip"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("clip"),
            keywords: &["clip"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("clip para hojas"),
            keywords: &["clip", "clip para hojas", "hojas", "papel"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kirjaklamber"),
            keywords: &["kirjaklamber", "klamber"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("klipa"),
            keywords: &["klip", "klipa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("گیره\u{654} کاغذ"),
            keywords: &["کلیپ", "گیره", "گیره کاغذ", "گیره\u{654} کاغذ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("paperiliitin"),
            keywords: &["klemmari", "liitin", "paperiliitin"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("paperclip"),
            keywords: &["clip", "pang-ipit", "papel", "paperclip"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("klips"),
            keywords: &["klips", "pappírsklemma"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("trombone"),
            keywords: &["fournitures", "trombone"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("fáiscín páipéir"),
            keywords: &["fáiscín", "fáiscín páipéir"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("clip-phàipeir"),
            keywords: &["clip-phàipeir"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("clip"),
            keywords: &["clip"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{ac7}પરક\u{acd}લિપ"),
            keywords: &["ક\u{acd}લિપ", "પ\u{ac7}પરક\u{acd}લિપ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kilif"),
            keywords: &["kilif"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אטב נייר"),
            keywords: &["אטב נייר", "מהדק"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{947}परक\u{94d}लिप"),
            keywords: &["क\u{94d}लिप", "प\u{947}परक\u{94d}लिप"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("spajalica"),
            keywords: &["spajalica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("gemkapocs"),
            keywords: &["gemkapocs", "papírkapocs"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ամրակ"),
            keywords: &["ամրակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("klip kertas"),
            keywords: &["klip kertas"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("kliipụ-akwụkwọ"),
            keywords: &["kliipụ-akwụkwọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("bréfaklemma"),
            keywords: &["bréfaklemma", "klemma"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("graffetta"),
            keywords: &["fermaglio", "graffetta"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("クリップ"),
            keywords: &[
                "クリップ",
                "ゼムクリップ",
                "ペーパークリップ",
                "文具",
                "文房具",
                "紙クリップ",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("klip kertas"),
            keywords: &["klip kertas"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქაღალდის სამაგრი"),
            keywords: &["სამაგრი", "ქაღალდი", "ქაღალდის სამაგრი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қағаз түйреуіш"),
            keywords: &["қағаз түйреуіш"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("papirclips"),
            keywords: &["clips", "papirclips"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ឃ\u{17d2}នាបក\u{17d2}រដាស"),
            keywords: &["ឃ\u{17d2}នាប", "ឃ\u{17d2}នាបក\u{17d2}រដាស"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪೇಪರ\u{ccd}\u{200c}ಕ\u{ccd}ಲ\u{cbf}ಪ\u{ccd}"),
            keywords: &[
                "ಕ\u{ccd}ಲ\u{cbf}ಪ\u{ccd}",
                "ಪೇಪರ\u{ccd}\u{200c}ಕ\u{ccd}ಲ\u{cbf}ಪ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("클립"),
            keywords: &["종이 클립", "클립"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("प\u{947}परक\u{94d}लिप"),
            keywords: &["प\u{947}परक\u{94d}लिप"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кыпчыгыч"),
            keywords: &["кыпчыгыч", "скрепка"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Bürosklamer"),
            keywords: &["Bürosklamer"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຄລ\u{eb4}ບໜ\u{eb5}ບເຈ\u{ec9}ຍ"),
            keywords: &["ຄລ\u{eb4}ບໜ\u{eb5}ບເຈ\u{ec9}ຍ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("sąvaržėlė"),
            keywords: &["sąvaržėlė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("papīra saspraude"),
            keywords: &["papīra saspraude", "saspraude"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rawhipepa"),
            keywords: &["rawhipepa"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("спојувалка"),
            keywords: &["спојувалка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പേപ\u{d4d}പർ ക\u{d4d}ലിപ\u{d4d}പ\u{d4d}"),
            keywords: &[
                "ക\u{d4d}ലിപ\u{d4d}പ\u{d4d}",
                "പേപ\u{d4d}പർ ക\u{d4d}ലിപ\u{d4d}പ\u{d4d}",
                "പേപ\u{d4d}പർക\u{d4d}ലിപ\u{d4d}പ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цаасны хавчаар"),
            keywords: &["цаасны хавчаар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{947}परक\u{94d}लिप"),
            keywords: &["प\u{947}परक\u{94d}लिप"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("klip kertas"),
            keywords: &["klip kertas"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("paperclip"),
            keywords: &["paperclip"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စက\u{1039}က\u{1030}ည\u{103e}ပ\u{103a}"),
            keywords: &[
                "စက\u{1039}က\u{1030}ည\u{103e}ပ\u{103a}",
                "စက\u{1039}က\u{1030}ည\u{103e}ပ\u{103a}ကလစ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("binders"),
            keywords: &["binders", "kontorrekvisita"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{947}परक\u{94d}लिप"),
            keywords: &["प\u{947}परक\u{94d}लिप"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("paperclip"),
            keywords: &["clip", "paperclip"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("binders"),
            keywords: &["binders", "kontorrekvisita"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପେପର କ\u{b4d}ଲ\u{b3f}ପ\u{b4d}"),
            keywords: &[
                "କ\u{b4d}ଲ\u{b3f}ପ\u{b4d}",
                "ପେପର କ\u{b4d}ଲ\u{b3f}ପ\u{b4d}",
                "ପେପର\u{b4d} କ\u{b4d}ଲ\u{b3f}ପ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a47}ਪਰ ਕਲਿ\u{a71}ਪ"),
            keywords: &["ਕਲਿ\u{a71}ਪ", "ਪ\u{a47}ਪਰ ਕਲਿ\u{a71}ਪ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کاغذ دا کلپ"),
            keywords: &["کاغذ دا کلپ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pépáklip"),
            keywords: &["Pépáklip"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("spinacz"),
            keywords: &["druciany", "spinacz", "spinać"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کاغذ نيوونى"),
            keywords: &["کاغذ نيوونى"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("clipe de papel"),
            keywords: &["clipe", "clipe de papel"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("clipe"),
            keywords: &["clipe"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("agrafă de hârtie"),
            keywords: &["agrafă", "agrafă de hârtie", "hârtie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-651"),
            keywords: &["E10-651"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("скрепка"),
            keywords: &["бумаги", "канцелярия", "скрепка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("atashe y’impapuro"),
            keywords: &["atashe y’impapuro"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪاغذ جهلڻ وارو ڪلپ"),
            keywords: &["ڪاغذ جهلڻ وارو ڪلپ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කඩද\u{dcf}ස\u{dd2} ඇම\u{dd4}ණ\u{dd4}ම\u{dca} ක\u{dca}ල\u{dd2}පය"),
            keywords: &[
                "කඩද\u{dcf}ස\u{dd2} ඇම\u{dd4}ණ\u{dd4}ම\u{dca} ක\u{dca}ල\u{dd2}පය",
                "පේපර\u{dca}ක\u{dca}ල\u{dd2}ප\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("sponka na papier"),
            keywords: &["príloha", "sponka", "sponka na papier"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("sponka za papir"),
            keywords: &["sponka za papir"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("biinka waraaqaha"),
            keywords: &["biinka waraaqaha"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kapëse letrash"),
            keywords: &["kapëse letrash"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("спајалица"),
            keywords: &["спајалица"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["спајалица"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("spajalica"),
            keywords: &["spajalica"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["spajalica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("gem"),
            keywords: &["gem"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kishikizo"),
            keywords: &["kishikizo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பேப\u{bcd}பர\u{bcd} கிளிப\u{bcd}"),
            keywords: &["கிளிப\u{bcd}", "பேப\u{bcd}பர\u{bcd} கிளிப\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c47}పర\u{c4d} క\u{c4d}ల\u{c3f}ప\u{c4d}"),
            keywords: &[
                "క\u{c3e}గ\u{c3f}తం క\u{c4d}ల\u{c3f}ప\u{c4d}",
                "ప\u{c47}పర\u{c4d} క\u{c4d}ల\u{c3f}ప\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("бандак"),
            keywords: &["бандак"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("คล\u{e34}ปหน\u{e35}บกระดาษ"),
            keywords: &["คล\u{e34}ป", "คล\u{e34}ปหน\u{e35}บกระดาษ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("skrepka"),
            keywords: &["skrepka"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakamaʻu pepa"),
            keywords: &["fakamaʻu pepa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ataş"),
            keywords: &["ataş", "klips"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قەغەز قىسقۇچ"),
            keywords: &["قەغەز قىسقۇچ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("скріпка"),
            keywords: &["скріпка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پیپر کلپ"),
            keywords: &["اسٹیشنری", "پیپر", "کلپ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qistirgich"),
            keywords: &["qistirgich", "qog‘oz qistirgich"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("kẹp giấy"),
            keywords: &["kẹp giấy"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("trombon"),
            keywords: &["trombon"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ikliphu yephepha"),
            keywords: &["ikliphu yephepha"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àfimúwèépọ\u{300}"),
            keywords: &["àfimúwèépọ\u{300}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("萬字夾"),
            keywords: &["萬字夾"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("万字夹"),
            keywords: &["万字夹"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("回形针"),
            keywords: &["万字夹", "回形针", "回纹针", "曲别针", "纸夹"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("迴紋針"),
            keywords: &["迴紋針"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("萬字夾"),
            keywords: &["萬字夾"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("okokubamba amaphepha"),
            keywords: &["okokubamba amaphepha"],
        },
    ],
};
#[doc = "🖇\u{fe0f}"]
pub const LINKED_PAPERCLIPS: crate::Emoji = crate::Emoji {
    glyph: "🖇\u{fe0f}",
    codepoint: "1F587 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "linked paperclips",
    group: "Objects",
    subgroup: "office",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🖇",
        codepoint: "1F587",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "linked paperclips",
        group: "Objects",
        subgroup: "office",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("ingehaakte skuifspeld"),
            keywords: &[
                "haak",
                "ingehaakte skuifspeld",
                "koppel",
                "skakel",
                "skuifspeld",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የተያያዙ የወረቀት ክሊፖች"),
            keywords: &["አያይዝ", "የተያያዙ የወረቀት ክሊፖች", "የወረቀት ክሊፕ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مشبك ورق مقترن"),
            keywords: &["أوراق", "مشبك", "مشبك ورق مقترن"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("জোৰ\u{9be} লগ\u{9be} পেপ\u{9be}ৰক\u{9cd}লিপ"),
            keywords: &[
                "জোৰ\u{9be}",
                "জোৰ\u{9be} লগ\u{9be} পেপ\u{9be}ৰক\u{9cd}লিপ",
                "পেপ\u{9be}ৰক\u{9cd}লিপ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("birləşmiş sancaqlar"),
            keywords: &["birləşmiş sancaqlar", "sancaq", "əlaqə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("злучаныя сашчэпкі"),
            keywords: &["злучаныя сашчэпкі", "папера", "сашчэпка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Съединени кламери"),
            keywords: &["Съединени кламери", "кламер", "съединен"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("সংয\u{9c1}ক\u{9cd}ত পেপ\u{9be}র ক\u{9cd}লিপ"),
            keywords: &[
                "পেপ\u{9be}র ক\u{9cd}লিপ",
                "লিংক",
                "সংয\u{9c1}ক\u{9cd}ত পেপ\u{9be}র ক\u{9cd}লিপ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("strobelloù"),
            keywords: &["dafar", "strobelloù"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("spojene spajalice"),
            keywords: &["spajalice", "spojene spajalice", "spojeno"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("clips enganxats"),
            keywords: &["clips", "enganxats"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎫᏓᎸᏅᎢ ᎪᏪᎵ ᏗᎦᏂᏴᏙᏗ"),
            keywords: &["ᎪᏪᎵ ᏗᎦᏂᏴᏙᏗ", "ᎫᏓᎸᏙᏗ", "ᏗᎫᏓᎸᏅᎢ ᎪᏪᎵ ᏗᎦᏂᏴᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("spojené kancelářské sponky"),
            keywords: &[
                "papír",
                "spojené kancelářské sponky",
                "spojení",
                "sponky",
                "svorka",
                "článek",
                "řetěz",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("clipiau papur wedi’u cysylltu"),
            keywords: &["clip papur", "clipiau papur wedi’u cysylltu", "linc"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sammensatte papirclips"),
            keywords: &["papirclip", "sammensat", "sammensatte papirclips"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("verhakte Büroklammern"),
            keywords: &[
                "Büroklammer",
                "Büroklammern",
                "verhakt",
                "verhakte Büroklammern",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ενωμένοι συνδετήρες"),
            keywords: &["ενωμένοι συνδετήρες", "ενωμένος", "συνδετήρας"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("linked paperclips"),
            keywords: &["link", "linked paperclips", "paperclip"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("clips unidos"),
            keywords: &["clips", "unidos", "unión"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["clips", "unidos"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("ühendatud kirjaklambrid"),
            keywords: &["kirjaklamber", "klamber", "ühendatud kirjaklambrid"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("elkarri lotutako klipak"),
            keywords: &["elkarri lotutako klipak", "klip", "lotu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("زنجیره\u{654} گیره"),
            keywords: &["اتصال", "حلقه", "زنجیره\u{654} گیره", "گیره\u{654} کاغذ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("klemmarit yhdessä"),
            keywords: &["klemmarit yhdessä", "liitin", "paperiliitin", "yhdessä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("magkakawing na paperclip"),
            keywords: &[
                "clips",
                "magkakawing na paperclip",
                "naka-link",
                "paperclip",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("klips sum hanga saman"),
            keywords: &["klips", "klips sum hanga saman", "pappírsklemmur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("trombones"),
            keywords: &["fournitures", "trombones"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("trombones accrochés"),
            keywords: &["fournitures", "trombones accrochés"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("fáiscíní páipéir nasctha"),
            keywords: &["fáiscín páipéir", "fáiscíní páipéir nasctha", "nasc"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cliopaichean-pàipeir ceangailte"),
            keywords: &[
                "ceangal",
                "cliopaichean-pàipeir ceangailte",
                "clip-phàipeir",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("clips enganchados"),
            keywords: &["clips", "clips enganchados", "enganchar", "unidos"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લિ\u{a82}ક કર\u{ac7}લ પ\u{ac7}પરક\u{acd}લિપ\u{acd}સ"),
            keywords: &[
                "પ\u{ac7}પરક\u{acd}લિપ",
                "લિ\u{a82}ક કર\u{ac7}લ પ\u{ac7}પરક\u{acd}લિપ\u{acd}સ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("haɗaɗɗen kilif"),
            keywords: &["haɗaɗɗen kilif", "kilif", "mahaɗi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אטבי נייר מחוברים"),
            keywords: &["אטבי נייר", "אטבי נייר מחוברים", "מהדקים", "מחוברים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("लि\u{902}क किए गए प\u{947}परक\u{94d}लिप"),
            keywords: &[
                "प\u{947}परक\u{94d}लिप",
                "लि\u{902}क",
                "लि\u{902}क किए गए प\u{947}परक\u{94d}लिप",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("spojene spajalice"),
            keywords: &["spajalica", "spojene spajalice", "veza"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("összekapcsolt gemkapcsok"),
            keywords: &["gemkapcsok", "kapcsolódás", "összekapcsolt gemkapcsok"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("միացված սկրեպներ"),
            keywords: &["միացնել", "միացված սկրեպներ", "սկրեպ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("klip kertas tertaut"),
            keywords: &["klip kertas", "klip kertas tertaut", "tautan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("njikọ nwere kliipụ-akwụkwọ"),
            keywords: &["kliipụ-akwụkwọ", "njikọ", "njikọ nwere kliipụ-akwụkwọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("samankræktar bréfaklemmur"),
            keywords: &["bréfaklemmur", "samankræktar"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("graffette attaccate"),
            keywords: &["allegare", "cancelleria", "fermagli", "graffette attaccate"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("つながったクリップ"),
            keywords: &[
                "つながったクリップ",
                "ペーパークリップ",
                "文具",
                "文房具",
                "紙クリップ",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("klip kertas karonce"),
            keywords: &["klip kertas", "klip kertas karonce", "ngronce"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მიბმული ქაღალდის სამაგრები"),
            keywords: &[
                "მიბმული ქაღალდის სამაგრები",
                "მიმაგრება",
                "სამაგრი",
                "ქაღალდი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("байланысқан қағаз қысқыштары"),
            keywords: &[
                "байланысу",
                "байланысқан қағаз қысқыштары",
                "қағаз қыстырғыш",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("sammensatte papirclips"),
            keywords: &["papirclip", "sammensat", "sammensatte papirclips"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ឃ\u{17d2}នាបក\u{17d2}រដាសភ\u{17d2}ជាប\u{17cb}គ\u{17d2}នា"),
            keywords: &[
                "ឃ\u{17d2}នាប",
                "ឃ\u{17d2}នាបក\u{17d2}រដាសភ\u{17d2}ជាប\u{17cb}គ\u{17d2}នា",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some(
                "ಲ\u{cbf}ಂಕ\u{ccd} ಮಾಡ\u{cbf}ದ ಪೇಪರ\u{ccd}\u{200c}ಕ\u{ccd}ಲ\u{cbf}ಪ\u{ccd}\u{200c}ಗಳು",
            ),
            keywords: &[
                "ಪೇಪರ\u{ccd}\u{200c}ಕ\u{ccd}ಲ\u{cbf}ಪ\u{ccd}",
                "ಲ\u{cbf}ಂಕ\u{ccd}",
                "ಲ\u{cbf}ಂಕ\u{ccd} ಮಾಡ\u{cbf}ದ ಪೇಪರ\u{ccd}\u{200c}ಕ\u{ccd}ಲ\u{cbf}ಪ\u{ccd}\u{200c}ಗಳು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("이어져 있는 클립"),
            keywords: &["이어져 있는 클립", "클립"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("लि\u{902}क\u{94d}ड प\u{947}परक\u{94d}लिप"),
            keywords: &[
                "प\u{947}परक\u{94d}लिप",
                "लि\u{902}क",
                "लि\u{902}क\u{94d}ड प\u{947}परक\u{94d}लिप",
                "लि\u{902}क\u{94d}ड प\u{947}परक\u{94d}लिप\u{94d}स",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бириккен тиркегичтер"),
            keywords: &["бириккен", "бириккен тиркегичтер", "тиркегич"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("verbonne Bürosklameren"),
            keywords: &["Bürosklamer", "verbonne Bürosklameren", "verbonnen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຫ\u{ebc}\u{eb1}ກໜ\u{eb5}ບເຈ\u{ec9}ຍຄ\u{eb9}\u{ec8}"),
            keywords: &[
                "ຄລ\u{eb4}ບ",
                "ເຫ\u{ebc}\u{eb1}ກໜ\u{eb5}ບເຈ\u{ec9}ຍ",
                "ເຫ\u{ebc}\u{eb1}ກໜ\u{eb5}ບເຈ\u{ec9}ຍຄ\u{eb9}\u{ec8}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("sukabintos sąvaržėlės"),
            keywords: &["sujungimas", "sukabintos sąvaržėlės", "sąvaržėlė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("savienotas saspraudes"),
            keywords: &["saspraude", "savienotas saspraudes"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ngā rawhipepa honohono"),
            keywords: &["hono", "ngā rawhipepa honohono", "rawhipepa"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("поврзани спојувалки"),
            keywords: &["алка", "поврзани спојувалки", "спојница"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "കോർത\u{d4d}തിരിക\u{d4d}ക\u{d41}ന\u{d4d}ന പേപ\u{d4d}പർ ക\u{d4d}ലിപ\u{d4d}പ\u{d41}കൾ",
            ),
            keywords: &[
                "കോർത\u{d4d}തിരിക\u{d4d}ക\u{d41}ന\u{d4d}ന പേപ\u{d4d}പർ ക\u{d4d}ലിപ\u{d4d}പ\u{d41}കൾ",
                "പേപ\u{d4d}പർ ക\u{d4d}ലിപ\u{d4d}പ\u{d4d}",
                "ലിങ\u{d4d}ക\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("холбоотой цаасны хавчаарууд"),
            keywords: &["холбоо", "холбоотой цаасны хавчаарууд", "цаасны хавчаар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("लि\u{902}क क\u{947}ल\u{947}ल\u{94d}या प\u{947}परक\u{94d}लिप\u{94d}स"),
            keywords: &[
                "द\u{941}वा",
                "प\u{947}परक\u{94d}लिप",
                "लि\u{902}क क\u{947}ल\u{947}ल\u{94d}या प\u{947}परक\u{94d}लिप\u{94d}स",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("klip kertas berpaut"),
            keywords: &["bersambung", "klip kertas", "klip kertas berpaut"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("paperclips illinkjati"),
            keywords: &["link", "paperclip", "paperclips illinkjati"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ချ\u{102d}တ\u{103a}ထားသည\u{1037}\u{103a} စက\u{1039}က\u{1030}ည\u{103e}ပ\u{103a}များ",
            ),
            keywords: &[
                "ချ\u{102d}တ\u{103a}ဆက\u{103a}သည\u{103a}",
                "ချ\u{102d}တ\u{103a}ထားသည\u{1037}\u{103a} စက\u{1039}က\u{1030}ည\u{103e}ပ\u{103a}များ",
                "စက\u{1039}က\u{1030}ည\u{103e}ပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sammenlenkede binders"),
            keywords: &["binders", "kjede", "sammenlenkede binders"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("लिङ\u{94d}क गरिएको प\u{947}परक\u{94d}लिपहर\u{942}"),
            keywords: &[
                "प\u{947}परक\u{94d}लिपहर\u{942}",
                "लिङ\u{94d}क",
                "लिङ\u{94d}क गरिएको प\u{947}परक\u{94d}लिपहर\u{942}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("twee paperclips aan elkaar"),
            keywords: &["aan elkaar", "paperclip", "twee paperclips aan elkaar"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("samanlenka binders"),
            keywords: &["binders", "kjede", "samanlenka binders"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଲ\u{b3f}ଙ\u{b4d}କ\u{b4d}\u{200c}ଯ\u{b41}କ\u{b4d}ତ"),
            keywords: &[
                "ପେପର କ\u{b4d}ଲ\u{b3f}ପ\u{b4d}",
                "ପେପର କ\u{b4d}ଲ\u{b3f}ପ\u{b4d}\u{200c}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
                "ଲ\u{b3f}ଙ\u{b4d}କ\u{b4d}\u{200c}",
                "ଲ\u{b3f}ଙ\u{b4d}କ\u{b4d}\u{200c}ଯ\u{b41}କ\u{b4d}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲਿ\u{a70}ਕ ਕੀਤੀਆ\u{a02} ਪ\u{a47}ਪਰਕਲਿ\u{a71}ਪਾ\u{a02}"),
            keywords: &[
                "ਪ\u{a47}ਪਰਕਲਿ\u{a71}ਪਾ\u{a02}",
                "ਲਿ\u{a70}ਕ",
                "ਲਿ\u{a70}ਕ ਕੀਤੀਆ\u{a02} ਪ\u{a47}ਪਰਕਲਿ\u{a71}ਪਾ\u{a02}",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ربط آ\u{612}لے پیپر کلپ"),
            keywords: &["ربط آ\u{612}لے پیپر کلپ", "ربط کرو", "کاغذ دا کلپ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pépáklip-dẹm wé línk togẹ\u{301}da"),
            keywords: &["Pépáklip-dẹm wé línk togẹ\u{301}da", "línk", "pépáklip"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("złączone spinacze"),
            keywords: &["druciane", "spinacze", "spinać", "złączone spinacze"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("تړل شوي کاغذ نيووني"),
            keywords: &[
                "تړل شوي کاغذ نيووني",
                "تړل شوي کاغز نيووني",
                "ربط",
                "کاغذ نيوونى",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("clipes de papel conectados"),
            keywords: &[
                "clipe",
                "clipes",
                "clipes de papel",
                "clipes de papel conectados",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("clipes ligados"),
            keywords: &["clipes", "clipes ligados", "ligação"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("agrafe de hârtie înlănțuite"),
            keywords: &[
                "agrafe",
                "agrafe de hârtie înlănțuite",
                "unire",
                "înlănțuire",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-802"),
            keywords: &["E10-802"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("скрепки"),
            keywords: &["бумаги", "канцелярия", "несколько скрепок", "скрепки"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("udufatampapuro dufatanye"),
            keywords: &["agafatampapuro", "isano", "udufatampapuro dufatanye"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪاغذ جهلڻ وارو ڳنڍيل ڪلپ"),
            keywords: &["پيپر ڪلپ", "ڪاغذ جهلڻ وارو ڳنڍيل ڪلپ", "ڳنڍيل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some(
                "සම\u{dca}බන\u{dca}ධ\u{dd2}ත කඩද\u{dcf}ස\u{dd2} ඇම\u{dd4}ණ\u{dd4}ම\u{dca} ක\u{dca}ල\u{dd2}ප",
            ),
            keywords: &[
                "ත\u{dd3}න\u{dca}ත",
                "පේපර\u{dca} ක\u{dca}ල\u{dd2}ප\u{dca}",
                "සම\u{dca}බන\u{dca}ධ\u{dd2}ත කඩද\u{dcf}ස\u{dd2} ඇම\u{dd4}ණ\u{dd4}ම\u{dca} ක\u{dca}ල\u{dd2}ප",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("spojené sponky na papier"),
            keywords: &["spojené sponky na papier", "sponky"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("povezani sponki"),
            keywords: &["povezani sponki", "povezano", "sponka"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("biinanka waraaqaha oo isku xidhan"),
            keywords: &[
                "biinanka waraaqaha",
                "biinanka waraaqaha oo isku xidhan",
                "isku xidhan",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kapëse teli të lidhura"),
            keywords: &["kapëse teli", "kapëse teli të lidhura", "lidhje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("повезане спајалице"),
            keywords: &["вeзa", "повезане спајалице", "спajaлицa"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("povezane spajalice"),
            keywords: &["povezane spajalice", "spajalica", "veza"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("länkade gem"),
            keywords: &["gem", "ihopsatta gem", "länkade gem"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("klipu za karatasi zilizounganishwa"),
            keywords: &[
                "klipu ya karatasi",
                "klipu za karatasi zilizounganishwa",
                "unganisha",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("இணைக\u{bcd}கப\u{bcd}பட\u{bcd}ட பேப\u{bcd}பர\u{bcd} கிளிப\u{bcd}கள\u{bcd}"),
            keywords: &[
                "இணைக\u{bcd}கப\u{bcd}பட\u{bcd}ட பேப\u{bcd}பர\u{bcd} கிளிப\u{bcd}",
                "இணைக\u{bcd}கப\u{bcd}பட\u{bcd}ட பேப\u{bcd}பர\u{bcd} கிளிப\u{bcd}கள\u{bcd}",
                "பேப\u{bcd}பர\u{bcd} கிளிப\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "ముడ\u{c3f} పడ\u{c3f} ఉన\u{c4d}న ప\u{c47}పర\u{c4d} క\u{c4d}ల\u{c3f}ప\u{c4d}\u{200c}లు",
            ),
            keywords: &[
                "క\u{c4d}ల\u{c3f}ప\u{c4d}\u{200c}లు",
                "ప\u{c47}పర\u{c4d}",
                "ముడ\u{c3f} పడటం",
                "ముడ\u{c3f} పడ\u{c3f} ఉన\u{c4d}న ప\u{c47}పర\u{c4d} క\u{c4d}ల\u{c3f}ప\u{c4d}\u{200c}లు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("бандаки пайвандшуда"),
            keywords: &["бандак", "бандаки пайвандшуда", "пайванд"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("คล\u{e34}ปหน\u{e35}บกระดาษค\u{e39}\u{e48}"),
            keywords: &[
                "กระดาษ",
                "คล\u{e34}ป",
                "คล\u{e34}ปหน\u{e35}บกระดาษค\u{e39}\u{e48}",
                "หน\u{e35}บ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("baglanan skrepkalar"),
            keywords: &["baglamak", "baglanan skrepkalar", "skrepka"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakamaʻu pepa sēini"),
            keywords: &["fakamaʻu pepa sēini"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("iç içe geçmiş ataşlar"),
            keywords: &["ataş", "bağlantı", "iç içe geçmiş ataşlar"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئۇلىنىش"),
            keywords: &["ئۇلانما", "ئۇلىنىش", "قەغەز قىسقۇچ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("зчеплені скріпки"),
            keywords: &["зчеплений", "зчеплені скріпки", "скріпка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جڑے ہوئے پیپر کلپس"),
            keywords: &["اسٹیشنری", "جڑے ہوئے", "جڑے ہوئے پیپر کلپس", "پیپر", "کلپ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ulangan qistirgichlar"),
            keywords: &["bog‘langan", "qog‘oz qistirgich", "ulangan qistirgichlar"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("kẹp giấy được nối"),
            keywords: &["kẹp giấy", "kẹp giấy được nối", "nối"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("trombonu këyit yuñ lëkkale"),
            keywords: &["lëkkale", "trombonu këyit yuñ lëkkale", "trombonu këyitu"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ikliphu yephepha edityanisiweyo"),
            keywords: &[
                "ikhonkco",
                "ikliphu yephepha",
                "ikliphu yephepha edityanisiweyo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àsopọ\u{300} ìfimúwèépọ\u{300}"),
            keywords: &[
                "àfimúwèépò\u{329}",
                "àsopọ\u{300} ìfimúwèépọ\u{300}",
                "ìsopọ\u{300}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("連埋嘅萬字夾"),
            keywords: &["萬字夾", "連住", "連埋嘅萬字夾"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("连埋嘅万字夹"),
            keywords: &["万字夹", "连住", "连埋嘅万字夹"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("连起来的两个回形针"),
            keywords: &[
                "万字夹",
                "回形针",
                "回纹针",
                "曲别针",
                "纸夹",
                "连起来的两个回形针",
            ],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("相連的回紋針"),
            keywords: &["回紋針", "相連的回紋針"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("連住嘅萬字夾"),
            keywords: &["連住嘅萬字夾", "連住嘅萬字夾｜萬字夾"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("okokubamba amaphepha okuhlangene"),
            keywords: &[
                "okokubamba amaphepha okuhlangene",
                "okokuhlanganisa amaphepha okuhlangene",
            ],
        },
    ],
};
#[doc = "📏"]
pub const STRAIGHT_RULER: crate::Emoji = crate::Emoji {
    glyph: "📏",
    codepoint: "1F4CF",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "straight ruler",
    group: "Objects",
    subgroup: "office",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("liniaal"),
            keywords: &["liniaal", "meet", "streep"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቀጥ ያለ ማስመሪያ"),
            keywords: &["ማስመሪያ", "ቀጥ ያለ ማስመሪያ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مسطرة"),
            keywords: &["حافة مستوية", "مسطرة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ঋজ\u{9c1} ম\u{9be}পনী"),
            keywords: &[
                "ঋজ\u{9c1} ম\u{9be}পনী",
                "পোন দ\u{9be}\u{981}তি",
                "ম\u{9be}পনী",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("düz xətkeş"),
            keywords: &["düz kənarlı", "düz xətkeş", "xətkeş"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("лінейка"),
            keywords: &["вымярэнне", "край", "лінейка", "прамы"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("линия"),
            keywords: &["линия"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("সোজ\u{9be} র\u{9c1}ল\u{9be}র"),
            keywords: &[
                "র\u{9c1}ল\u{9be}র",
                "সোজ\u{9be} প\u{9cd}র\u{9be}ন\u{9cd}ত",
                "সোজ\u{9be} র\u{9c1}ল\u{9be}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("reolenn"),
            keywords: &["dafar", "reolenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("linijar"),
            keywords: &["lenjir", "linijar"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("regle"),
            keywords: &["recte", "regle"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏥᏳᎩᏗ ᎠᏟᎶᏍᎩ"),
            keywords: &["ᎠᏍᏛᎢ ᏥᏳᎪᏗ", "ᎠᏟᎶᏍᏗ", "ᏥᏳᎩᏗ ᎠᏟᎶᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("rovné pravítko"),
            keywords: &["dlouhé", "pravítko", "rovné pravítko"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("pren mesur"),
            keywords: &["pren mesur", "ymyl syth"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("lineal"),
            keywords: &["lige kant", "lineal"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Lineal"),
            keywords: &["Lineal"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ίσιος χάρακας"),
            keywords: &["ίσια άκρη", "ίσιος χάρακας", "χάρακας"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("straight ruler"),
            keywords: &["ruler", "straight edge", "straight ruler"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("regla"),
            keywords: &["regla"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("regla recta"),
            keywords: &["regla", "regla recta"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("sirge joonlaud"),
            keywords: &["sirge", "sirge joonlaud"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("erregela zuzena"),
            keywords: &["erregela", "erregela zuzena", "zuzen"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("خط\u{200c}کش"),
            keywords: &["خط\u{200c}کش", "صاف"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("viivoitin"),
            keywords: &["suora", "viivain", "viivoitin"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tuwid na ruler"),
            keywords: &["ruler", "tuwid", "tuwid na ruler"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("lineal"),
            keywords: &["lineal", "strikfjøl"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("règle"),
            keywords: &["fournitures", "règle"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("rialóir díreach"),
            keywords: &["rialóir", "rialóir díreach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("rùilear dìreach"),
            keywords: &["dìreach", "rùilear"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("regra"),
            keywords: &["regra", "triángulo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સીધી આ\u{a82}કણી"),
            keywords: &["આ\u{a82}કણી", "સીધી આ\u{a82}કણી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("miƙaƙƙiyar rula"),
            keywords: &["miƙaƙƙen gefe", "miƙaƙƙiyar rula", "rula"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סרגל"),
            keywords: &["ישר", "סרגל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{94d}ट\u{94d}र\u{947}ट र\u{942}लर"),
            keywords: &[
                "प\u{948}माना",
                "सीधा र\u{942}लर",
                "सीधा र\u{942}लर, प\u{948}माना",
                "स\u{94d}ट\u{94d}र\u{947}ट र\u{942}लर",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("ravnalo"),
            keywords: &["ravnalo", "ravno"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("egyenes vonalzó"),
            keywords: &["egyenes", "vonalzó"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("քանոն"),
            keywords: &["ուղղանկյուն", "քանոն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("penggaris lurus"),
            keywords: &["penggaris", "penggaris lurus", "ujung lurus"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("rulà ogologo"),
            keywords: &["ebe ogologo", "rulà", "rulà ogologo"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("reglustika"),
            keywords: &["bein reglustika", "reglustika"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("righello"),
            keywords: &["geometria", "misurare", "righello", "scuola", "strumento"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("定規"),
            keywords: &["ものさし", "定規", "文具", "文房具"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("garisan jejeg"),
            keywords: &["garisan", "garisan jejeg", "pinggir jejeg"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სწორი სახაზავი"),
            keywords: &["სახაზავი", "სწორი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("түзу сызғыш"),
            keywords: &["сызғыш", "түзу"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("lineal"),
            keywords: &["lige kant", "lineal"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បន\u{17d2}ទាត\u{17cb}ត\u{17d2}រង\u{17cb}"),
            keywords: &[
                "ត\u{17d2}រង\u{17cb}",
                "បន\u{17d2}ទាត\u{17cb}",
                "បន\u{17d2}ទាត\u{17cb}ត\u{17d2}រង\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನೇರ ರ\u{cc2}ಲರ\u{ccd}"),
            keywords: &["ನೇರ ರ\u{cc2}ಲರ\u{ccd}", "ರ\u{cc2}ಲರ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("자"),
            keywords: &["자", "직각"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("सरळ पट\u{94d}टी"),
            keywords: &["पट\u{94d}टी", "सरळ द\u{947}ग", "सरळ पट\u{94d}टी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("түз сызгыч"),
            keywords: &["сызгыч", "түз"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Lineal"),
            keywords: &["Lineal", "riicht"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ບ\u{eb1}ນທ\u{eb1}ດຊ\u{eb7}\u{ec8}"),
            keywords: &[
                "ຊ\u{eb7}\u{ec8}",
                "ບ\u{eb1}ນທ\u{eb1}ດ",
                "ບ\u{eb1}ນທ\u{eb1}ດຊ\u{eb7}\u{ec8}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("tiesi liniuotė"),
            keywords: &["liniuotė", "tiesi"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("taisns lineāls"),
            keywords: &["lineāls", "taisns lineāls"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rūri torotika"),
            keywords: &["rūri", "torotika"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("прав линијар"),
            keywords: &["линијар", "прав"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d4d}കെയിൽ"),
            keywords: &["റ\u{d42}ളർ", "സ\u{d4d}കെയിൽ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("шугам"),
            keywords: &["шугам", "шулуун шугам", "шулуун өнцөг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("फ\u{941}टपट\u{94d}टी"),
            keywords: &["फ\u{941}टपट\u{94d}टी", "र\u{942}लर", "सरळ र\u{942}लर"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pembaris lurus"),
            keywords: &["pembaris", "pembaris lurus", "tepi lurus"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("riga dritta"),
            keywords: &["riga", "riga dritta", "xifer dritt"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပေတ\u{1036}"),
            keywords: &[
                "ပေတ\u{1036}",
                "ပေတ\u{1036} အဖြောင\u{1037}\u{103a}",
                "ဖြောင\u{1037}\u{103a}နေသည\u{1037}\u{103a} အနား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("linjal"),
            keywords: &["linjal", "rett"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("सीधा स\u{94d}क\u{947}ल"),
            keywords: &["सीधा किनारा", "सीधा स\u{94d}क\u{947}ल", "स\u{94d}क\u{947}ल"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("liniaal"),
            keywords: &["liniaal", "rechte lijn"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("linjal"),
            keywords: &["linjal", "rett"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b3f}ଧ\u{b3e} ର\u{b41}ଲର\u{b4d}\u{200c}"),
            keywords: &[
                "ର\u{b41}ଲର\u{b4d}",
                "ସ\u{b3f}ଧ\u{b3e} ର\u{b41}ଲର\u{b4d}\u{200c}",
                "ସ\u{b4d}କେଲ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਿ\u{a71}ਧਾ ਰ\u{a42}ਲਰ"),
            keywords: &["ਰ\u{a42}ਲਰ", "ਸਿ\u{a71}ਧਾ ਰ\u{a42}ਲਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سیدھا پیمانہ"),
            keywords: &["براہ\u{650} راست برتری", "حکمران", "سیدھا پیمانہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Strét Rúla"),
            keywords: &["Rúla", "Strét Rúla"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("linijka"),
            keywords: &["linia", "linijka", "prosta", "prosta krawędź"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سيدها خطکش"),
            keywords: &["خط کش", "سيدها خطکش", "سيدها ګوټونه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("régua reta"),
            keywords: &["régua", "régua reta"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("régua"),
            keywords: &["régua"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("riglă"),
            keywords: &["linie", "margine dreaptă", "măsurare", "riglă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-652"),
            keywords: &["E10-652"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("линейка"),
            keywords: &["измерение", "линейка", "прямая"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("agacamurongo kagororotse"),
            keywords: &[
                "agacamurongo",
                "agacamurongo kagororotse",
                "inguni irambuye",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سڌو ماپيندڙ"),
            keywords: &["سڌو ماپيندڙ", "ماپيندڙ، سڌي ڪنڊ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කෙල\u{dd2}න\u{dca} ර\u{dd6}ල"),
            keywords: &[
                "කෙල\u{dd2}න\u{dca} ර\u{dd6}ල",
                "ර\u{dd6}ලර\u{dca}",
                "සෘජ\u{dd4} ද\u{dcf}රය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("rovné pravítko"),
            keywords: &["pravítko", "rovné"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ravnilo"),
            keywords: &["merilo", "ravnilo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("mastarad toosan"),
            keywords: &["koone siman", "mastarad", "mastarad toosan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("vizore e drejtë"),
            keywords: &["anë e drejtë", "vizore", "vizore e drejtë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лењир"),
            keywords: &["лењир", "рaвнo"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["лењир"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lenjir"),
            keywords: &["lenjir", "ravno"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["lenjir"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("linjal"),
            keywords: &["linjal", "rak"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("rula"),
            keywords: &["rula", "ukingo ulionyooka"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அளவுகோல\u{bcd}"),
            keywords: &[
                "அடிஸ\u{bcd}கேல\u{bcd}",
                "அளவுகோல\u{bcd}",
                "ஸ\u{bcd}கேல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("రూలర\u{c4d} స\u{c4d}క\u{c47}ల\u{c4d}"),
            keywords: &["మూల", "రూలర\u{c4d}", "స\u{c4d}క\u{c47}ల\u{c4d}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҷадвали рост"),
            keywords: &["ҷадвал", "ҷадвали рост"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ไม\u{e49}บรรท\u{e31}ดตรง"),
            keywords: &["ไม\u{e49}บรรท\u{e31}ด", "ไม\u{e49}บรรท\u{e31}ดตรง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("göni çyzgyç"),
            keywords: &["göni gyraly", "göni çyzgyç", "çyzgyç"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("lula hangatonu"),
            keywords: &["lula hangatonu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("düz cetvel"),
            keywords: &["cetvel", "düz cetvel"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تۈز سىزغۇچ"),
            keywords: &["تۈز سىزغۇچ", "تۈز قىر", "سىزغۇچ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("пряма лінійка"),
            keywords: &["лінійка", "пряма лінійка", "прямий кут"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اسٹریٹ رولر"),
            keywords: &["اسٹریٹ رولر", "اسٹیشنری", "رولر", "سیدھا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("chizg‘ich"),
            keywords: &["burchak", "chizg‘ich", "qirra", "to‘g‘ri"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("thước thẳng"),
            keywords: &["cạnh thẳng", "thước kẻ", "thước thẳng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("reegal bu jub"),
            keywords: &["jub pegg", "reegal", "reegal bu jub"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("irula ethe tye"),
            keywords: &["irula", "irula ethe tye", "umphetho othe nkqo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("rula gbọọrọ"),
            keywords: &["etí gbọọrọ", "rula gbọọrọ", "rúlà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("直尺"),
            keywords: &["直尺", "直邊", "間尺"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("直尺"),
            keywords: &["直尺", "直边", "间尺"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("直尺"),
            keywords: &["尺", "尺子", "文具", "测量", "直尺", "长度"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("直尺"),
            keywords: &["尺", "直尺"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("間尺"),
            keywords: &["間尺", "間尺｜尺"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("irula eliqondile"),
            keywords: &["irula", "irula eliqondile", "okuqondile"],
        },
    ],
};
#[doc = "📐"]
pub const TRIANGULAR_RULER: crate::Emoji = crate::Emoji {
    glyph: "📐",
    codepoint: "1F4D0",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "triangular ruler",
    group: "Objects",
    subgroup: "office",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("driekantliniaal"),
            keywords: &[
                "driehoek",
                "driekantliniaal",
                "hoek",
                "liniaal",
                "meet",
                "teken",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ባለ ሦስት ማዕዘን ማስመሪያ"),
            keywords: &["ማስመሪያ", "ሦስት ማዕዘን", "ስብስብ", "ባለ ሦስት ማዕዘን ማስመሪያ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مسطرة مثلثة"),
            keywords: &["مثلث", "مثلث رسم", "مسطرة", "مسطرة مثلثة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ত\u{9cd}ৰিকোণ\u{9be}ক\u{9be}ৰ ম\u{9be}পনী"),
            keywords: &[
                "ছেট",
                "ত\u{9cd}ৰিকোণ\u{9be}ক\u{9be}ৰ ম\u{9be}পনী",
                "ত\u{9cd}ৰিভ\u{9c1}জ",
                "ম\u{9be}পনী",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ücbucaq xətkeş"),
            keywords: &["dəst", "xətkeş", "ücbucaq xətkeş", "üçbucaq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("трохвугольная лінейка"),
            keywords: &[
                "вымярэнне",
                "лінейка",
                "трохвугольная лінейка",
                "трохвугольнік",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("триъгълник"),
            keywords: &["триъгълник"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ত\u{9cd}রিভ\u{9c1}জ\u{9be}ক\u{9c3}তি র\u{9c1}ল\u{9be}র"),
            keywords: &[
                "ত\u{9cd}রিভ\u{9c1}জ",
                "ত\u{9cd}রিভ\u{9c1}জ\u{9be}ক\u{9c3}তি র\u{9c1}ল\u{9be}র",
                "র\u{9c1}ল\u{9be}র",
                "সেট",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("skouer"),
            keywords: &["dafar", "skouer"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("trokutasti linijar"),
            keywords: &[
                "lenjir",
                "linijar",
                "trokut",
                "trokutasti linijar",
                "trougao",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("esquadra"),
            keywords: &["angle", "esquadra", "regle", "triangle"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏦᎢ ᏧᏅᏏᏓ ᎠᏟᎶᏍᏗ"),
            keywords: &["ᎠᏟᎶᏍᏗ", "ᎦᎪᏗ", "ᏦᎢ ᏧᏅᏏᏓ ᎠᏟᎶᏍᏗ", "ᏦᎢ ᏧᏅᏏᏯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("trojúhelníkové pravítko"),
            keywords: &["pravý", "trojúhelník", "trojúhelníkové pravítko", "úhel"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("pren mesur trionglog"),
            keywords: &["pren mesur", "pren mesur trionglog", "set", "triongl"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("tegnetrekant"),
            keywords: &["tegnetrekant", "vinkel", "vinkelmåler"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("dreieckiges Lineal"),
            keywords: &["Geodreieck", "Lineal", "dreieckiges Lineal"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τριγωνικός χάρακας"),
            keywords: &["σετ", "τρίγωνο", "τριγωνικός χάρακας", "χάρακας"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("triangular ruler"),
            keywords: &["ruler", "set", "triangle", "triangular ruler"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("set square"),
            keywords: &["ruler", "set", "set square", "triangle"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("triangular ruler"),
            keywords: &["ruler", "set", "set square", "triangle", "triangular ruler"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("escuadra"),
            keywords: &["escuadra", "regla", "regla triangular", "triángulo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["escuadra", "regla", "triangular"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kolmnurkne joonlaud"),
            keywords: &["joonlaud", "kolmnurk", "kolmnurkne joonlaud"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kartaboia"),
            keywords: &["erregela", "kartaboi", "kartaboia", "triangelu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("گونیا"),
            keywords: &["خط\u{200c}کش", "گونیا"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kolmioviivain"),
            keywords: &["kolmio", "kolmioviivain", "viivain", "viivotin"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tatsulok na ruler"),
            keywords: &["ruler", "tatsulok", "tatsulok na ruler"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("tríkanta lineal"),
            keywords: &["lineal", "strikfjøl", "tríkanta lineal", "tríkantur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("équerre"),
            keywords: &["fournitures", "équerre"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("rialóir triantánach"),
            keywords: &["rialóir triantánach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("rùilear triantanach"),
            keywords: &["rùilear", "seata", "triantanach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("escuadro"),
            keywords: &["escuadro", "regra", "triangular", "triángulo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કાટખ\u{ac2}ણિય\u{ac1}\u{a82}"),
            keywords: &[
                "આ\u{a82}કણી",
                "કાટખ\u{ac2}ણિય\u{ac1}\u{a82}",
                "ત\u{acd}રિકોણ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("rula na alwatika"),
            keywords: &["alwatika", "rula", "rula na alwatika", "tsari"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סרגל משולש"),
            keywords: &["משולש", "סרגל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("त\u{94d}रिकोणीय र\u{942}लर"),
            keywords: &[
                "ग\u{941}निया",
                "तिकोना र\u{942}लर",
                "त\u{94d}रिकोण",
                "त\u{94d}रिकोणीय र\u{942}लर",
                "प\u{948}माना",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("trokut"),
            keywords: &["ravnalo", "trokut"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("háromszögvonalzó"),
            keywords: &["derékszögű", "háromszög", "háromszögvonalzó", "vonalzó"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("եռանկյունի քանոն"),
            keywords: &["եռանկյունի", "քանոն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("penggaris segitiga"),
            keywords: &["penggaris", "rangkaian", "segitiga"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("rulà trayangulụ"),
            keywords: &["rula", "rulà trayangulụ", "trayangulụ", "wube"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("þríhyrnd reglustika"),
            keywords: &["reglustika", "þríhyrnd reglustika", "þríhyrningur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("squadra"),
            keywords: &["angoli", "geometria", "misurare", "scuola", "squadra"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("三角定規"),
            keywords: &["三角定規", "定規", "文具", "文房具"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("garisan pesagi telu"),
            keywords: &[
                "garisan",
                "garisan pesagi telu",
                "pesagi telu",
                "saprangkat",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სამკუთხა სახაზავი"),
            keywords: &["სამკუთხა სახაზავი", "სამკუთხედი", "სახაზავი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("үшбұрышты сызғыш"),
            keywords: &["жинақ", "сызғыш", "үшбұрыш", "үшбұрышты сызғыш"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("trekant"),
            keywords: &["trekant", "vinkel", "vinkelmåler"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បន\u{17d2}ទាត\u{17cb}រាងត\u{17d2}រ\u{17b8}កោន"),
            keywords: &[
                "បន\u{17d2}ទាត\u{17cb}",
                "បន\u{17d2}ទាត\u{17cb}រាងត\u{17d2}រ\u{17b8}កោន",
                "រាងត\u{17d2}រ\u{17b8}កោន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ತ\u{ccd}ರ\u{cbf}ಕೋನ ರ\u{cc2}ಲರ\u{ccd}"),
            keywords: &[
                "ಚ\u{ccc}ಕ ಹೊಂದ\u{cbf}ಸು",
                "ತ\u{ccd}ರ\u{cbf}ಕೋನ",
                "ರ\u{cc2}ಲರ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("삼각자"),
            keywords: &["삼각자", "삼각형", "자"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("त\u{94d}रिकोणी पट\u{94d}टी"),
            keywords: &["त\u{94d}रिकोणी", "पट\u{94d}टी", "स\u{902}च"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("үч бурчтук сызгыч"),
            keywords: &["сызгыч", "үч бурчтук", "үч бурчтук сызгыч"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Zeechendräieck"),
            keywords: &["Dräieck", "Lineal", "Zeechen", "Zeechendräieck"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ບ\u{eb1}ນທ\u{eb1}ດສາມຫ\u{ebc}\u{ec8}ຽມສາກ"),
            keywords: &[
                "ບ\u{eb1}ນທ\u{eb1}ດ",
                "ບ\u{eb1}ນທ\u{eb1}ດສາມຫ\u{ebc}\u{ec8}ຽມສາກ",
                "ສາມຫ\u{ebc}\u{ec8}ຽມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("trikampė liniuotė"),
            keywords: &["liniuotė", "trikampis", "trikampė liniuotė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("trīsstūra lineāls"),
            keywords: &["lineāls", "trīsstūra lineāls"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rūri tapatoru"),
            keywords: &["huinga", "rūri", "tapatoru"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("триаголен линијар"),
            keywords: &["линијар", "триаголен линијар", "триаголник"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ട\u{d4d}രയ\u{d3e}ംഗിൾ റ\u{d42}ളർ"),
            keywords: &["ട\u{d4d}രയ\u{d3e}ംഗിൾ റ\u{d42}ളർ", "സ\u{d4d}കെയിൽ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гурвалжин шугам"),
            keywords: &["багц", "гурвалжин", "шугам"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कोनमापक"),
            keywords: &[
                "कोनमापक",
                "त\u{94d}रिकोण",
                "त\u{94d}रिकोणी र\u{942}लर",
                "र\u{942}लर",
                "स\u{947}ट",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pembaris segi tiga"),
            keywords: &["pembaris", "pembaris segi tiga", "segi tiga", "set"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("riga trijangulari"),
            keywords: &["riga", "riga trijangulari", "set", "trijangolu"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ထောင\u{1037}\u{103a}မ\u{103e}န\u{103a} ပေတ\u{1036}"),
            keywords: &[
                "ထောင\u{1037}\u{103a}မ\u{103e}န\u{103a} တြ\u{102d}ဂ\u{1036}",
                "ထောင\u{1037}\u{103a}မ\u{103e}န\u{103a} ပေတ\u{1036}",
                "ပေတ\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("trekantlinjal"),
            keywords: &["linjal", "trekant", "trekantlinjal", "vinkel"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("त\u{94d}रिकोणीय स\u{94d}क\u{947}ल"),
            keywords: &[
                "त\u{94d}रिकोण",
                "त\u{94d}रिकोणीय स\u{94d}क\u{947}ल",
                "स\u{947}ट",
                "स\u{94d}क\u{947}ल",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("geodriehoek"),
            keywords: &["driehoek", "geo", "geodriehoek", "liniaal"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("trekantlinjal"),
            keywords: &["linjal", "trekant", "trekantlinjal", "vinkel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ତ\u{b4d}ର\u{b3f}ଭ\u{b41}ଜ\u{b3e}କ\u{b3e}ର ର\u{b41}ଲର\u{b4d}\u{200c}"),
            keywords: &[
                "ତ\u{b4d}ର\u{b3f}କୋଣୀୟ",
                "ତ\u{b4d}ର\u{b3f}କୋଣୀୟ ସ\u{b4d}କେଲ\u{b4d}",
                "ତ\u{b4d}ର\u{b3f}ଭ\u{b41}ଜ\u{b3e}କ\u{b3e}ର ର\u{b41}ଲର\u{b4d}\u{200c}",
                "ର\u{b41}ଲର\u{b4d}",
                "ସେଟ\u{b4d} ସ\u{b4d}କୋୟ\u{b3e}ର\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਤਿਕ\u{a4b}ਣਾ ਰ\u{a42}ਲਰ"),
            keywords: &["ਤਿਕ\u{a4b}ਣਾ", "ਰ\u{a42}ਲਰ", "ਸ\u{a48}\u{a71}ਟ ਵਰਗ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("تکونی پیمانہ"),
            keywords: &["تکونی پیمانہ", "حکمران", "سیٹ", "مثلث"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tráyángúl Rúla"),
            keywords: &["Rúla", "Sẹt", "Tráyángul", "Tráyángúl Rúla"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("ekierka"),
            keywords: &["ekierka", "linia prosta", "linijka", "trójkąt"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("درې کنجه خطکش"),
            keywords: &["خطکش", "درې کنجه خطکش", "درې ګوټى", "سيټ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("régua triangular"),
            keywords: &["régua", "régua triangular", "triângulo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("esquadro"),
            keywords: &["esquadro", "triângulo"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("echer"),
            keywords: &["echer", "linie", "măsurare", "triunghi"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-653"),
            keywords: &["E10-653"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("линейка-треугольник"),
            keywords: &[
                "измерение",
                "линейка",
                "линейка-треугольник",
                "треугольная линейка",
                "треугольник",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("agacampandeshatu"),
            keywords: &["agacampandeshatu", "agacamurongo", "itsinda", "mpandeshatu"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٽڪنڊو ماپيندڙ"),
            keywords: &["رولر", "سيٽ", "ٽڪنڊو", "ٽڪنڊو ماپيندڙ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ත\u{dca}\u{200d}ර\u{dd2}කෝණ\u{dcf}ක\u{dcf}ර ර\u{dd6}ල"),
            keywords: &[
                "කට\u{dca}ටලය",
                "ත\u{dca}\u{200d}ර\u{dd2}කෝණය",
                "ත\u{dca}\u{200d}ර\u{dd2}කෝණ\u{dcf}ක\u{dcf}ර ර\u{dd6}ල",
                "ර\u{dd6}ලර\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("trojuholníkové pravítko"),
            keywords: &["pravítko", "trojuholník", "trojuholníkové pravítko"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("trikotno ravnilo"),
            keywords: &["merilo", "nastaviti", "trikotnik", "trikotno ravnilo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("mastarad saddex-gees ah"),
            keywords: &["mastarad", "mastarad saddex-gees ah", "saddex-gees"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("vizore trekëndëshe"),
            keywords: &["komplet", "trekëndësh", "trekëndëshe", "vizore"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("троугаони лењир"),
            keywords: &["лењир", "троугао", "троугаони лењир"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["троугаони лењир"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("trougaoni lenjir"),
            keywords: &["lenjir", "trougao", "trougaoni lenjir"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["trougaoni lenjir"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("rätvinklig linjal"),
            keywords: &["linjal", "rätvinklig linjal", "triangel"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("rula ya pembe"),
            keywords: &["pembe", "rula", "rula ya pembe", "seti"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("முக\u{bcd}கோணம\u{bbe}னி"),
            keywords: &[
                "அளவுகோல\u{bcd}",
                "செட\u{bcd} ஸ\u{bcd}கொயர\u{bcd}",
                "முக\u{bcd}கோணம\u{bbe}னி",
                "முக\u{bcd}கோணம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("త\u{c4d}ర\u{c3f}భుజ\u{c3e}క\u{c3e}ర రూలర\u{c4d}"),
            keywords: &[
                "త\u{c4d}ర\u{c3f}భుజం",
                "త\u{c4d}ర\u{c3f}భుజ\u{c3e}క\u{c3e}ర రూలర\u{c4d}",
                "రూలర\u{c4d}",
                "స\u{c4d}క\u{c47}ల\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҷадвали секунҷа"),
            keywords: &["маҷмӯъ", "секунҷа", "ҷадвал", "ҷадвали секунҷа"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ไม\u{e49}บรรท\u{e31}ดสามเหล\u{e35}\u{e48}ยม"),
            keywords: &[
                "ไม\u{e49}บรรท\u{e31}ด",
                "ไม\u{e49}บรรท\u{e31}ดสามเหล\u{e35}\u{e48}ยม",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("üçburç çyzgyç"),
            keywords: &["toplum", "çyzgyç", "üçburç"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("lula tapatolu"),
            keywords: &["lula tapatolu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("gönye"),
            keywords: &["cetvel", "gönye", "üçgen"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئۈچ بۇلۇڭلۇق سىزغۇچ"),
            keywords: &["ئۈچ بۇلۇڭلۇق سىزغۇچ", "بۇلۇڭ", "سىزغۇچ", "يۈرۈشلۈك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("трикутна лінійка"),
            keywords: &["лінійка", "трикутна лінійка", "трикутник"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("تکونی رولر"),
            keywords: &["اسٹیشنری", "تکونی", "رولر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("uchburchak chizg‘ich"),
            keywords: &["chizg‘ich", "to‘plam", "uchburchak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("thước tam giác"),
            keywords: &["bộ", "tam giác", "thước kẻ", "thước tam giác"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("reegal bu am jëmmu triyàngal"),
            keywords: &["def", "reegal", "reegal bu am jëmmu triyàngal", "triyàngal"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("irula engunxantathu"),
            keywords: &["irula", "irula engunxantathu", "iseti", "unxantathu"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("rula onigun mẹta"),
            keywords: &[
                "onígun-mé\u{329}ta",
                "rula onigun mẹta",
                "rúlà",
                "sẹ\u{301}ẹ\u{301}tì",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("三角尺"),
            keywords: &["三角尺", "三角形", "組合", "間尺"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("三角尺"),
            keywords: &["三角尺", "三角形", "组合", "间尺"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("三角尺"),
            keywords: &["三角", "三角尺", "尺", "文具", "测量", "角度"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("三角尺"),
            keywords: &["三角尺", "尺"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("irula eliwunxantathu"),
            keywords: &["irula", "irula eliwunxantathu", "isethi", "unxantathu"],
        },
    ],
};
#[doc = "✂\u{fe0f}"]
pub const SCISSORS: crate::Emoji = crate::Emoji {
    glyph: "✂\u{fe0f}",
    codepoint: "2702 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "scissors",
    group: "Objects",
    subgroup: "office",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "✂",
        codepoint: "2702",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "scissors",
        group: "Objects",
        subgroup: "office",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("skêr"),
            keywords: &["knip", "skêr", "sny"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መቀስ"),
            keywords: &["መሣሪያ", "መቀስ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مقص"),
            keywords: &["أداة", "مقص"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কে\u{981}চী"),
            keywords: &["কট\u{9be}", "কে\u{981}চী", "স\u{981}জ\u{9c1}লি"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qayçı"),
            keywords: &["alət", "qayçı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("нажніцы"),
            keywords: &["выразанне", "нажніцы", "інструмент"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("ножици"),
            keywords: &["инструмент", "ножици"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9be}\u{981}চি"),
            keywords: &["ক\u{9be}\u{981}চি", "সরঞ\u{9cd}জ\u{9be}ম"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("sizailhoù"),
            keywords: &["dafar", "sizailhoù"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("makaze"),
            keywords: &["makaze", "pribor"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("tisores"),
            keywords: &["eina", "tall", "tisores"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎵᏍᏙᏗ"),
            keywords: &["ᎠᎦᎵᏍᎦ", "ᎬᏔᏂᏓᏍᏗ", "ᏗᎵᏍᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("nůžky"),
            keywords: &["nástroj", "nůžky", "střih", "stříhání"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("siswrn"),
            keywords: &["offeryn", "siswrn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("saks"),
            keywords: &["saks", "værktøj"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schere"),
            keywords: &["Schere"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ψαλίδι"),
            keywords: &["εργαλείο", "κοπή", "ψαλίδι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("scissors"),
            keywords: &["cutting", "scissors", "tool"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("tijeras"),
            keywords: &["cortar", "herramienta", "tijeras"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("käärid"),
            keywords: &["käärid", "tööriist"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("guraizeak"),
            keywords: &["guraizeak", "tresna"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قیچی"),
            keywords: &["ابزار", "ابزار بریدن", "قیچی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("sakset"),
            keywords: &["sakset", "työkalu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("gunting"),
            keywords: &["gunting", "kagamitan", "panggupit"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("saksur"),
            keywords: &["klipp", "saksur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("ciseaux"),
            keywords: &["ciseaux", "fournitures"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("siosúr"),
            keywords: &["siosúr", "uirlis"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("siosar"),
            keywords: &["acainn", "bearradh", "siosar"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("tesoiras"),
            keywords: &["cortar", "tesoira", "tesoiras"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કાતર"),
            keywords: &["કાતર", "સાધન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("almakashi"),
            keywords: &["almakashi", "kayan aiki", "yankewa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מספריים"),
            keywords: &["גזירה", "לגזור", "מספריים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("क\u{948}\u{902}ची"),
            keywords: &["क\u{948}\u{902}ची", "ट\u{942}ल"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("škare"),
            keywords: &["alat", "škare"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("olló"),
            keywords: &["eszköz", "olló"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մկրատ"),
            keywords: &["գործիք", "մկրատ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("gunting"),
            keywords: &["alat", "gunting", "potong"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("mkpà gasị"),
            keywords: &["mbebi", "mkpà gasị", "ngwaọrụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("skæri"),
            keywords: &["skæri", "verkfæri"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("forbici"),
            keywords: &["forbici", "strumento", "tagliare"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("はさみ"),
            keywords: &["はさみ", "カット", "切る", "文具", "文房具"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("gunting"),
            keywords: &["gunting", "ngethok", "pranti"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მაკრატელი"),
            keywords: &["ინსტრუმენტი", "მაკრატელი", "ხელსაწყო"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қайшы"),
            keywords: &["қайшы", "құрал"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("saks"),
            keywords: &["saks", "værktøj"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កន\u{17d2}ត\u{17d2}រៃ"),
            keywords: &["កន\u{17d2}ត\u{17d2}រៃ", "កាត\u{17cb}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕತ\u{ccd}ತರ\u{cbf}ಗಳು"),
            keywords: &["ಕತ\u{ccd}ತರ\u{cbf}ಗಳು", "ಟ\u{cc2}ಲ\u{ccd}", "ಪರ\u{cbf}ಕರ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("가위"),
            keywords: &["가위", "기구", "도구"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("कातरी"),
            keywords: &["कातरप", "कातरी", "साधन"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кайчы"),
            keywords: &["кайчы", "курал"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Schéier"),
            keywords: &["Handwierksgeschir", "Schéier", "schneiden"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ມ\u{eb5}ດຕ\u{eb1}ດ"),
            keywords: &["ມ\u{eb5}ດຕ\u{eb1}ດ", "ເຄ\u{eb7}\u{ec8}ອງມ\u{eb7}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žirklės"),
            keywords: &["įrankis", "žirklės"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("šķēres"),
            keywords: &["griezt", "rīks", "šķēres"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kutikuti"),
            keywords: &["kutikuti", "tapahitanga", "utauta"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("ножици"),
            keywords: &["алатка", "ножици"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കത\u{d4d}രിക"),
            keywords: &["ഉപകരണം", "കത\u{d4d}രിക"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хайч"),
            keywords: &["багаж", "хайч", "хайчлах"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कात\u{94d}री"),
            keywords: &["कटि\u{902}ग", "कात\u{94d}री", "साधन"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("gunting"),
            keywords: &["alat", "gunting"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("imqass"),
            keywords: &["għodda", "imqass", "qtugħ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကတ\u{103a}ကြေး"),
            keywords: &["ကတ\u{103a}ကြေး", "က\u{102d}ရ\u{102d}ယာ"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("saks"),
            keywords: &["klippe", "saks", "verktøy"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("क\u{948}\u{901}ची"),
            keywords: &["उपकरण", "काट\u{94d}न\u{947}", "क\u{948}\u{901}ची"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("schaar"),
            keywords: &["gereedschap", "knippen", "schaar"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("saks"),
            keywords: &["klippe", "saks", "verktøy"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କତ\u{b41}ରୀ"),
            keywords: &[
                "କଇ\u{b01}ଚ\u{b3f}",
                "କତ\u{b41}ରୀ",
                "କ\u{b3e}ଟ\u{b3f}ବ\u{b3e}",
                "ଯନ\u{b4d}ତ\u{b4d}ରପ\u{b3e}ତ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a48}\u{a02}ਚੀ"),
            keywords: &["ਔਜ\u{a3c}ਾਰ", "ਕ\u{a48}\u{a02}ਚੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("قینچی"),
            keywords: &["اوزار", "قینچی", "کٹائی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Sízọs"),
            keywords: &["Kọt", "Sízọs", "Tul"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("nożyczki"),
            keywords: &["narzędzie", "nożyczki", "ostre", "przeciąć"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بياتي"),
            keywords: &["اله", "بياتي", "پريکول"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("tesoura"),
            keywords: &["cortar", "ferramenta", "tesoura"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("tesoura"),
            keywords: &["tesoura", "utensílio"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("foarfece"),
            keywords: &["croitorie", "foarfece", "instrument", "tăiere"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-121"),
            keywords: &["E10-121"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("ножницы"),
            keywords: &["инструмент", "ножницы", "резать"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("Imakasi"),
            keywords: &["Imakasi", "gukata", "igikoresho"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("قينچي"),
            keywords: &["اوزار", "قينچي", "ڪٽيندڙ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කත\u{dd4}ර"),
            keywords: &["කත\u{dd4}ර", "මෙවලම"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("nožnice"),
            keywords: &["nožnice", "nástroj"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("škarje"),
            keywords: &["orodje", "škarje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("maqas"),
            keywords: &["jarid", "maqas", "qalab"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gërshërë"),
            keywords: &["gërshërë", "prerje", "vegël"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("маказе"),
            keywords: &["алат", "маказе", "сечење"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["маказе"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("makaze"),
            keywords: &["alat", "makaze", "sečenje"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["makaze"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("sax"),
            keywords: &["klippa", "sax"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("makasi"),
            keywords: &["makasi", "zana"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கத\u{bcd}திரிக\u{bcd}கோல\u{bcd}"),
            keywords: &[
                "கத\u{bcd}திரி",
                "கத\u{bcd}திரிக\u{bcd}கோல\u{bcd}",
                "தையல\u{bcd}",
                "வெட\u{bcd}டு",
                "வெட\u{bcd}டுதல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కత\u{c4d}త\u{c46}ర"),
            keywords: &["కత\u{c4d}త\u{c46}ర", "స\u{c3e}ధనం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("қайчӣ"),
            keywords: &["абзор", "буридан", "қайчӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("กรรไกร"),
            keywords: &["กรรไกร", "เคร\u{e37}\u{e48}องม\u{e37}อ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gaýçy"),
            keywords: &["gaýçy", "gural", "kesmek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("helekosi"),
            keywords: &["helekosi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("makas"),
            keywords: &["alet", "makas"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قايچا"),
            keywords: &["قايچا", "قورال", "كېسىش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("ножиці"),
            keywords: &["ножиці", "інструмент"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("قینچی"),
            keywords: &["آلہ", "اسٹیشنری", "قینچی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qaychi"),
            keywords: &["asbob", "qaychi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("kéo"),
            keywords: &["cắt", "dụng cụ", "kéo"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("siso"),
            keywords: &["dagg", "jumtukaay", "siso"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("izikere"),
            keywords: &["isixhobo", "izikere", "ukusika"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("sísọ\u{301}ọ\u{300}sì"),
            keywords: &["gígé", "irinṣé\u{329}", "sísọ\u{301}ọ\u{300}sì"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("較剪"),
            keywords: &["剪", "工具", "較剪"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("较剪"),
            keywords: &["剪", "工具", "较剪"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("剪刀"),
            keywords: &["修剪", "剪", "剪刀", "剪子", "剪裁", "工具"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("剪刀"),
            keywords: &["剪", "剪刀", "工具"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("骹剪"),
            keywords: &["剪刀", "工具", "骹剪", "骹剪｜剪"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isikelo"),
            keywords: &["isikelo", "ithuluzi"],
        },
    ],
};
#[doc = "🗃\u{fe0f}"]
pub const CARD_FILE_BOX: crate::Emoji = crate::Emoji {
    glyph: "🗃\u{fe0f}",
    codepoint: "1F5C3 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "card file box",
    group: "Objects",
    subgroup: "office",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🗃",
        codepoint: "1F5C3",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "card file box",
        group: "Objects",
        subgroup: "office",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kaartlêerboks"),
            keywords: &["boks", "kaart", "kaartlêerboks", "lêer"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የካርድ ፋይል ሳጥን"),
            keywords: &["ሣጥን", "ካርታ", "የካርድ ፋይል ሳጥን", "ፋይል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("صندوق بطاقات"),
            keywords: &["بطاقة", "صندوق", "صندوق بطاقات", "ملف"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9be}ৰ\u{9cd}ড ফ\u{9be}ইল ব\u{9be}কচ"),
            keywords: &["ক\u{9be}ৰ\u{9cd}ড", "ফ\u{9be}ইল", "ব\u{9be}কচ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kart faylı qutusu"),
            keywords: &["fayl", "kart", "kart faylı qutusu", "qutu"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("каробка для картатэкі"),
            keywords: &["каробка", "каробка для картатэкі", "карта", "файл"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Картотечна кутия"),
            keywords: &["Картотечна кутия", "карта", "кутия"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9be}র\u{9cd}ডের ফ\u{9be}ইল বক\u{9cd}স"),
            keywords: &[
                "ক\u{9be}র\u{9cd}ড",
                "ক\u{9be}র\u{9cd}ডের ফ\u{9be}ইল বক\u{9cd}স",
                "ফ\u{9be}ইল",
                "ব\u{9be}ক\u{9cd}স",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kartonska kutija za fascikle"),
            keywords: &["fascikle", "kartonska kutija za fascikle"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("arxivador de targetes"),
            keywords: &[
                "arxiu",
                "arxivador de targetes",
                "caixa",
                "dossier",
                "targeta",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏆᏂᏲᏍᏗ ᎠᏥᎳ ᎤᏣᏍᎦᏘ ᎧᏁᏌ"),
            keywords: &["ᎠᏆᏂᏲᏍᏗ", "ᎠᏆᏂᏲᏍᏗ ᎠᏥᎳ ᎤᏣᏍᎦᏘ ᎧᏁᏌ", "ᎠᏥᎳ ᎤᏣᏍᎦᏘ", "ᎧᏁᏌᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("krabice s kartotékou"),
            keywords: &["karta", "krabice", "krabice s kartotékou", "spis"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("blwch ffeilio cardiau"),
            keywords: &["blwch", "blwch ffeilio cardiau", "card", "ffeilio"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("arkivkasse"),
            keywords: &["arkiv", "arkivkasse", "kasse", "pap"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Karteikasten"),
            keywords: &["Büromaterial", "Karteikasten"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καρτελοθήκη"),
            keywords: &["αρχείο", "κάρτα", "καρτελοθήκη", "κουτί"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("card file box"),
            keywords: &["box", "card", "file"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("archivador de tarjetas"),
            keywords: &["archivador", "archivador de tarjetas", "archivo", "caja"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("organizador de tarjetas"),
            keywords: &["archivos", "caja", "organizador de tarjetas"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("organizador de archivos"),
            keywords: &["archivos", "caja", "organizador de archivos"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("dokumendikast"),
            keywords: &["dokumendikast", "dokument", "kast", "register"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("artxibatzeko kaxa"),
            keywords: &["artxibatu", "artxibatzeko kaxa", "fitxategi", "kaxa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("جعبه نگه\u{200c}داری کارت"),
            keywords: &[
                "جعبه",
                "جعبه نگه\u{200c}داری کارت",
                "فایل",
                "پرونده",
                "کارت",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("arkistolaatikko"),
            keywords: &["arkistolaatikko", "kortisto", "laatikko", "mappi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kahon ng cardfile"),
            keywords: &["card", "file", "kahon", "kahon ng cardfile", "paglalagyan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("savnskassi"),
            keywords: &[
                "kartotek",
                "kortsavn",
                "savnskassi",
                "seðlasavn",
                "seðlaskrá",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("boîte à dossiers"),
            keywords: &["boîte à dossiers", "dossier"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bosca comhad cárta"),
            keywords: &["bosca", "bosca comhaid cárta", "comhad", "cárta"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bogsa fhaidhlichean"),
            keywords: &["bogsa", "bogsa fhaidhlichean", "cairt", "faidhle"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("caixa de arquivo"),
            keywords: &[
                "arquivar",
                "caixa",
                "caixa de arquivo",
                "documentos",
                "ficheiro",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કાર\u{acd}ડ ફાઇલ બૉક\u{acd}સ"),
            keywords: &["કાર\u{acd}ડ ફાઇલ બૉક\u{acd}સ", "ફાઇલ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("akwatin fayil na kati"),
            keywords: &["akwati", "akwatin fayil na kati", "fayil", "kati"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קופסת תיוק כרטיסיות"),
            keywords: &["כרטיסיות", "קופסה", "קופסת תיוק כרטיסיות", "תיוק"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("कार\u{94d}ड फ\u{93c}ाइल बॉक\u{94d}स"),
            keywords: &["कार\u{94d}ड", "प\u{947}टी", "फ\u{93c}ाइल", "बॉक\u{94d}स"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kartotečna kutija"),
            keywords: &["datoteka", "kartica", "kartotečna kutija", "kutija"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kartotékdoboz"),
            keywords: &["akták", "doboz", "kartoték", "kartotékdoboz"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("քարտադարանի արկղ"),
            keywords: &["արկղ", "քարտ", "քարտադարանի արկղ", "ֆայլ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kotak file kartu"),
            keywords: &["file", "kartu", "kotak"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("igbe kaadị faịlụ"),
            keywords: &["faịlụ", "igbe", "kaadị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kassi með minnismiðum"),
            keywords: &["kassi", "kassi með minnismiðum", "skjal", "spjöld"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("schedario da tavolo"),
            keywords: &[
                "archiviare",
                "archivio",
                "contenitore",
                "documenti",
                "schedario",
                "schedario da tavolo",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("カードファイルボックス"),
            keywords: &[
                "カードファイルボックス",
                "ファイル",
                "ボックス",
                "文具",
                "文房具",
                "箱",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kothak berkas kertu"),
            keywords: &["berkas", "kertu", "kothak"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბარათების ყუთი"),
            keywords: &["ბარათები", "ბარათების ყუთი", "ფაილი", "ყუთი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("карталық файлдарға арналған жәшік"),
            keywords: &[
                "жәшік",
                "карта",
                "карталық файлдарға арналған жәшік",
                "файл",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("arkivkasse"),
            keywords: &["arkiv", "arkivkasse", "kasse", "pap"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17d2}រអប\u{17cb}ដាក\u{17cb}កាត"),
            keywords: &[
                "កាត",
                "ប\u{17d2}រអប\u{17cb}",
                "ប\u{17d2}រអប\u{17cb}ដាក\u{17cb}កាត",
                "ឯកសារ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಾರ\u{ccd}ಡ\u{ccd} ಫೈಲ\u{ccd} ಬಾಕ\u{ccd}ಸ\u{ccd}"),
            keywords: &["ಕಾರ\u{ccd}ಡ\u{ccd}", "ಫೈಲ\u{ccd}", "ಬಾಕ\u{ccd}ಸ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("카드 파일 상자"),
            keywords: &["카드 상자", "카드 파일 상자"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("कार\u{94d}ड फायल ब\u{93c}ॉक\u{94d}स"),
            keywords: &[
                "कार\u{94d}ड",
                "कार\u{94d}ड फायल ब\u{93c}ॉक\u{94d}स",
                "फायल",
                "बॉक\u{94d}स",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("карта файлынын кутусу"),
            keywords: &["карта", "карта файлынын кутусу", "куту", "файл"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Fichierskëscht"),
            keywords: &["Fichier", "Fichierskëscht", "Kaart", "Këscht"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກ\u{ec8}ອງບ\u{eb1}ນຈ\u{eb8}ບ\u{eb1}ດ"),
            keywords: &[
                "ກ\u{ec8}ອງ",
                "ກ\u{ec8}ອງບ\u{eb1}ນຈ\u{eb8}ບ\u{eb1}ດ",
                "ບ\u{eb1}ດ",
                "ແຟ\u{ec9}ມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kortelių saugojimo dėžė"),
            keywords: &["dėžė", "failas", "kortelių saugojimo dėžė", "kortelė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("dokumentu kaste"),
            keywords: &["dokuments", "dokumentu kaste", "kaste"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pouaka kōnae kāri"),
            keywords: &["kāri", "kōnae", "pouaka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("кутија за картотека"),
            keywords: &["картотека", "кутија", "кутија за картотека"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d3e}ർഡ\u{d4d} ഫയൽ ബോക\u{d4d}\u{200c}സ\u{d4d}"),
            keywords: &["ക\u{d3e}ർഡ\u{d4d}", "ഫയൽ", "ബോക\u{d4d}\u{200c}സ\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("картын хайрцаг"),
            keywords: &["карт", "картын хайрцаг", "файл", "хайрцаг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कार\u{94d}ड फाईल बॉक\u{94d}स"),
            keywords: &[
                "कार\u{94d}ड",
                "कार\u{94d}ड फाईल बॉक\u{94d}स",
                "फाइल",
                "बॉक\u{94d}स",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kotak fail kad"),
            keywords: &["fail", "kad", "kotak"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kaxxa tal-biljetti tal-fajl"),
            keywords: &["fajl", "kard", "kaxxa", "kaxxa tal-biljetti tal-fajl"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကဒ\u{103a}ဖ\u{102d}\u{102f}င\u{103a} သေတ\u{1039}တာ"),
            keywords: &[
                "ကတ\u{103a}",
                "ကဒ\u{103a}ဖ\u{102d}\u{102f}င\u{103a} သေတ\u{1039}တာ",
                "စက\u{1039}က\u{1030}ပ\u{102f}\u{1036}း",
                "ဖ\u{102d}\u{102f}င\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kartotekboks"),
            keywords: &["arkiv", "boks", "fil", "kartotekboks", "kort"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कार\u{94d}ड फाइल बाकस"),
            keywords: &["कार\u{94d}ड", "कार\u{94d}ड फाइल बाकस", "फाइल", "बक\u{94d}स"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kaartenbak"),
            keywords: &["archief", "bak", "kaart", "kaartenbak"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kartotekboks"),
            keywords: &["arkiv", "boks", "fil", "kartotekboks", "kort"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b3e}ର\u{b4d}ଡ\u{b4d} ଫ\u{b3e}ଇଲ\u{b4d}\u{200c} ବ\u{b3e}କ\u{b4d}ସ"),
            keywords: &[
                "କ\u{b3e}ର\u{b4d}ଡ\u{b4d}",
                "ଫ\u{b3e}ଇଲ\u{b4d}\u{200c}",
                "ବ\u{b3e}କ\u{b4d}ସ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਾਰਡ ਫ\u{a3c}ਾਈਲਾ\u{a02} ਦਾ ਬਕਸਾ"),
            keywords: &["ਕਾਰਡ", "ਕਾਰਡ ਫ\u{a3c}ਾਈਲਾ\u{a02} ਦਾ ਬਕਸਾ", "ਫਾਇਲ", "ਬਕਸਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کارڈ دی فائل باکس"),
            keywords: &["فائل", "ڈبہ", "کارڈ", "کارڈ دی فائل باکس"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bọks Fọ Pút Kád Fail"),
            keywords: &["Bọks", "Bọks Fọ Pút Kád Fail", "Fail", "Kad"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pudełko-kartoteka"),
            keywords: &[
                "dokumenty",
                "indeks",
                "kartoteka",
                "karty",
                "pudełko",
                "pudełko-kartoteka",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کارت دوتنې بکس"),
            keywords: &["بکس", "دوتنې", "کارت"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("caixa de arquivos"),
            keywords: &["arquivo", "caixa", "caixa de arquivos", "cartão"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("caixa de arquivo"),
            keywords: &["arquivo", "caixa", "caixa de arquivo", "fichas"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cutie de îndosariere"),
            keywords: &["cutie", "cutie de îndosariere", "îndosariere"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-817"),
            keywords: &["E10-817"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("картотека"),
            keywords: &["картотека", "карточки", "сведения", "учет", "файлы", "ящик"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("agasanduku babikamo amadosiye"),
            keywords: &[
                "agasanduku",
                "agasanduku babikamo amadosiye",
                "dosiye",
                "ifishi",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪارڊ فائيل باڪس"),
            keywords: &["باڪس", "فائيل", "ڪارڊ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dcf}ඩ\u{dca}පත\u{dca} ගොන\u{dd4} පෙට\u{dca}ට\u{dd2}ය"),
            keywords: &[
                "ක\u{dcf}ඩ\u{dca}පත",
                "ක\u{dcf}ඩ\u{dca}පත\u{dca} ගොන\u{dd4} පෙට\u{dca}ට\u{dd2}ය",
                "ගොන\u{dd4}ව",
                "පෙට\u{dca}ට\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("škatuľa s kartotékou"),
            keywords: &["karta", "súbor", "škatuľa", "škatuľa s kartotékou"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("škatla z dokumenti"),
            keywords: &["dokumenti", "spis", "škatla", "škatla z dokumenti"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("faylka kaararka"),
            keywords: &["fayl", "faylka kaararka", "kaar", "kartoon"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kuti skedarësh"),
            keywords: &["kuti", "kuti skedarësh", "letër", "skedar"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кутија са картицама"),
            keywords: &["документ", "картица", "кутија", "кутија са картицама"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["кутија са картицама"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kutija sa karticama"),
            keywords: &["dokument", "kartica", "kutija", "kutija sa karticama"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["kutija sa karticama"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kartotek"),
            keywords: &["kartotek", "låda"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("sanduku la faili"),
            keywords: &["faili", "kadi", "sanduku", "sanduku la faili"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("க\u{bbe}ர\u{bcd}டு பைல\u{bcd} ப\u{bbe}க\u{bcd}ஸ\u{bcd}"),
            keywords: &[
                "க\u{bbe}ர\u{bcd}டு",
                "ப\u{bbe}க\u{bcd}ஸ\u{bcd}",
                "பைல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c3e}ర\u{c4d}డ\u{c4d} ఫ\u{c48}ల\u{c4d} ప\u{c46}ట\u{c4d}ట\u{c46}"),
            keywords: &[
                "క\u{c3e}ర\u{c4d}డ\u{c4d}",
                "ప\u{c46}ట\u{c4d}ట\u{c46}",
                "ఫ\u{c48}ల\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("қуттии файли кортҳо"),
            keywords: &["корт", "файл", "қуттии файли кортҳо", "қуттӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("กล\u{e48}องใส\u{e48}แฟ\u{e49}ม"),
            keywords: &[
                "กระดาษ",
                "กล\u{e48}อง",
                "กล\u{e48}องใส\u{e48}แฟ\u{e49}ม",
                "เอกสาร",
                "แฟ\u{e49}ม",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kart faýl gutusy"),
            keywords: &["faýl", "guty", "kart", "kart faýl gutusy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("puha takafi faile"),
            keywords: &["puha takafi faile"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("dosya kutusu"),
            keywords: &["dosya", "dosya kutusu", "kart", "kutu"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قەغەز ھۆججەت ساندۇقى"),
            keywords: &["ساندۇق", "قەغەز ھۆججەت ساندۇقى", "كارتا", "ھۆججەت"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("скринька для карток"),
            keywords: &["коробка", "скринька для карток", "файли"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کارڈ فائل باکس"),
            keywords: &["اسٹیشنری", "باکس", "فائل", "کارڈ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("fayl qutisi"),
            keywords: &["fayl", "fayl qutisi", "kartochka", "quti"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hộp đựng hồ sơ"),
            keywords: &["hộp", "hộp đựng hồ sơ", "thẻ", "tệp"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("boyetu kàrtu taxañ"),
            keywords: &["boyet", "boyetu kàrtu taxañ", "kàrt", "taxañ"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhokisi yefayile yamakhadi"),
            keywords: &[
                "ibhokisi",
                "ibhokisi yefayile yamakhadi",
                "ifayile",
                "ikhadi",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àpótí káàdì fún fáìlì"),
            keywords: &["fáìlì", "káàdì", "àpótí", "àpótí káàdì fún fáìlì"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("卡片檔案盒"),
            keywords: &["卡片", "卡片檔案盒", "檔案", "盒"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("卡片档案盒"),
            keywords: &["卡片", "卡片档案盒", "档案", "盒"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("卡片盒"),
            keywords: &["卡片盒", "存档", "标签", "档案", "箱", "索引"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("卡片目錄盒"),
            keywords: &["卡片目錄盒", "目錄盒"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("卡片檔案盒"),
            keywords: &["卡片檔案盒", "卡片檔案盒｜卡片｜盒"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhodi lokugcina amakhadi"),
            keywords: &["ibhodi lokugcina amakhadi", "ibhokisi", "ifayela", "ikhadi"],
        },
    ],
};
#[doc = "🗄\u{fe0f}"]
pub const FILE_CABINET: crate::Emoji = crate::Emoji {
    glyph: "🗄\u{fe0f}",
    codepoint: "1F5C4 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "file cabinet",
    group: "Objects",
    subgroup: "office",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🗄",
        codepoint: "1F5C4",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "file cabinet",
        group: "Objects",
        subgroup: "office",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("lêerkabinet"),
            keywords: &["kabinet", "kas", "laai", "lêer", "lêerkabinet"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ፋይል ካቢኔት"),
            keywords: &["ካቢኔት", "ፋይል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("خزانة ملفات"),
            keywords: &["خزانة", "خزانة ملفات", "ملف"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ফ\u{9be}ইল কেবিনেট"),
            keywords: &["কেবিনেট", "ফ\u{9be}ইল", "ফ\u{9be}ইলিং"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("fayl şkafı"),
            keywords: &["fayl", "fayl şkafı", "kabinet"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("архіўная шафа"),
            keywords: &["архіў", "архіўная шафа", "файл", "шафа"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Картотечен шкаф"),
            keywords: &["Картотечен шкаф", "карта", "шкаф"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ফ\u{9be}ইলের ক\u{9cd}য\u{9be}বিনেট"),
            keywords: &[
                "ক\u{9cd}য\u{9be}বিনেট",
                "ফ\u{9be}ইল",
                "ফ\u{9be}ইলের ক\u{9cd}য\u{9be}বিনেট",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kartoteka"),
            keywords: &["fascikle", "kartoteka", "ormar"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("arxivador"),
            keywords: &["arxivador", "dossier", "moble"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᎪᏂᎪᏙᏗ ᎦᏍᎩᎸ"),
            keywords: &["ᎠᏍᎪᏂᎪᏙᏗ ᎦᏍᎩᎸ", "ᎠᏍᏂᎪᏙᏗ", "ᎦᏍᎩᎸ", "ᏛᏍᏆᏂᎪᏗᏍᎬᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("skříň na spisy"),
            keywords: &[
                "archiv",
                "kartotéka",
                "pořadač",
                "skříň",
                "skříň na spisy",
                "spis",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ffeil gabinet"),
            keywords: &["cabinet", "ffeil gabinet", "ffeilio"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("arkivskab"),
            keywords: &["arkiv", "arkivskab", "skab"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Aktenschrank"),
            keywords: &["Ablage", "Aktenschrank", "Archiv"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αρχειοθήκη"),
            keywords: &["αρχείο", "αρχειοθήκη", "συρτάρι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("file cabinet"),
            keywords: &["cabinet", "file", "filing"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("filing cabinet"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("archivador"),
            keywords: &["archivador", "archivos", "oficina", "organizador"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("archivero"),
            keywords: &["archivero", "archivo", "carpetas", "organizador"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("dokumendikapp"),
            keywords: &["dokumendikapp", "dokument", "kapp", "register"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("artxibategia"),
            keywords: &["artxibategi", "artxibategia", "artxibo"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کشوی پرونده"),
            keywords: &["فایل", "پرونده", "کابینت", "کشو", "کشوی پرونده"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("arkistokaappi"),
            keywords: &["arkistokaappi", "kaappi", "kortisto", "mappi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("file cabinet"),
            keywords: &["cabinet", "file"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("savnsskáp"),
            keywords: &[
                "kartotek",
                "kortsavn",
                "savnskassi",
                "savnsskipan",
                "savnsskáp",
                "seðlasavn",
                "seðlaskrá",
                "skáp",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("meuble à dossiers"),
            keywords: &[
                "classement",
                "classer",
                "dossier",
                "meuble",
                "meuble à dossiers",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("classeur"),
            keywords: &["classeur", "dossier"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("caibinéad comhad"),
            keywords: &["caibinéad", "comhad"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("caibineat fhaidhlichean"),
            keywords: &[
                "caibineat",
                "caibineat fhaidhlichean",
                "faidhle",
                "faidhleadh",
                "preas",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("arquivador"),
            keywords: &[
                "arquivador",
                "caixóns",
                "documentos",
                "escritorio",
                "oficina",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ફાઇલ ક\u{ac5}બિન\u{ac7}ટ"),
            keywords: &["ક\u{ac5}બિન\u{ac7}ટ", "ફાઇલ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kabad na fayil"),
            keywords: &["fayil", "kabad", "kabad na fayil", "naɗawa a fayil"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מגירות מסמכים"),
            keywords: &["ארון", "מגירות", "מסמכים", "תיוק"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("फ\u{93c}ाइल क\u{948}बिन\u{947}ट"),
            keywords: &["क\u{948}बिन\u{947}ट", "फ\u{93c}ाइल"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kartotečni ladičar"),
            keywords: &["datoteka", "kartotečni ladičar", "ladičar"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("iratszekrény"),
            keywords: &["akták", "iratok", "iratszekrény", "szekrény"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("պահարան"),
            keywords: &["պահարան", "ֆայլ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("lemari file"),
            keywords: &["file", "lemari", "pemberkasan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("kabineti failụ"),
            keywords: &["faịlụ", "kabineti", "kabineti failụ", "na-edokwa"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("skjalaskápur"),
            keywords: &["skjal", "skjalaskápur", "skápur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("schedario da ufficio"),
            keywords: &[
                "archiviare",
                "armadietto schedario",
                "documenti",
                "file",
                "schedario",
                "schedario da ufficio",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ファイルキャビネット"),
            keywords: &[
                "キャビネット",
                "ファイル",
                "ファイルキャビネット",
                "引き出し",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("slorogan berkas"),
            keywords: &["berkas", "panyimpenan berkas", "slorogan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კარტოთეკა"),
            keywords: &["კარტოთეკა", "ფაილი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("картотекалық сөре"),
            keywords: &["кабинет", "картотекалық сөре", "файл"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("arkivskab"),
            keywords: &["arkiv", "arkivskab", "skab"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ថតទ\u{17bc}ឯកសារ"),
            keywords: &[
                "ថតទ\u{17bc}ឯកសារ",
                "ទ\u{17bc}",
                "ទ\u{17bc}ដាក\u{17cb}ឯកសារ",
                "ឯកសារ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಫೈಲ\u{ccd} ಕ\u{ccd}ಯಾಬ\u{cbf}ನ\u{cc6}ಟ\u{ccd}"),
            keywords: &["ಕ\u{ccd}ಯಾಬ\u{cbf}ನ\u{cc6}ಟ\u{ccd}", "ಫೈಲ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("파일 보관 서랍장"),
            keywords: &["캐비닛", "파일", "파일 보관 서랍장"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("फायल क\u{945}बिन\u{947}ट"),
            keywords: &["क\u{945}बिन\u{947}ट", "फायल", "फायलि\u{902}ग"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("файл суурмасы"),
            keywords: &["суурма", "файл", "файл суурмасы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Fichiersschaf"),
            keywords: &["Fichier", "Fichiersschaf", "Schaf", "klasséieren"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຕ\u{eb9}\u{ec9}ໃສ\u{ec8}ແຟ\u{ec9}ມເອກະສານ"),
            keywords: &[
                "ຕ\u{eb9}\u{ec9}",
                "ຕ\u{eb9}\u{ec9}ໃສ\u{ec8}ແຟ\u{ec9}ມເອກະສານ",
                "ເອກະສານ",
                "ແຟ\u{ec9}ມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("bylų spintelė su stalčiais"),
            keywords: &[
                "bylų spintelė su stalčiais",
                "failas",
                "failų spintelė su stalčiais",
                "spintelė",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("dokumentu skapis"),
            keywords: &["dokuments", "dokumentu skapis", "skapis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kāpata kōnae"),
            keywords: &["kāpata", "kōnae", "whakaraupapa kōnae"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("шкаф за картотека"),
            keywords: &["картотека", "шкаф", "шкаф за картотека"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഫയൽ ക\u{d3e}ബിനെറ\u{d4d}റ\u{d4d}"),
            keywords: &["ക\u{d3e}ബിനെറ\u{d4d}റ\u{d4d}", "ഫയൽ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("файлын шүүгээ"),
            keywords: &["баримт бичиг бүрдүүлэх", "файл", "файлын шүүгээ", "шүүгээ"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("फाईल ठ\u{947}वायच\u{947} कपाट"),
            keywords: &[
                "कपाट",
                "फाइल",
                "फाइल ठ\u{947}वण\u{94d}याच\u{947} कपाट",
                "फाइलि\u{902}ग",
                "फाईल ठ\u{947}वायच\u{947} कपाट",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kabinet fail"),
            keywords: &["fail", "kabinet"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kabinet tal-fajls"),
            keywords: &["fajl", "iffajljar", "kabinet", "kabinet tal-fajls"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဖ\u{102d}\u{102f}င\u{103a} အ\u{1036}ဆ\u{103d}\u{1032}"),
            keywords: &["ဖ\u{102d}\u{102f}င\u{103a}", "အ\u{1036}ဆ\u{103d}\u{1032}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("arkivskap"),
            keywords: &["arkiv", "arkivskap", "fil", "kabinett", "mapper"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("फाइल क\u{94d}याबिन\u{947}ट"),
            keywords: &["क\u{94d}याबिन\u{947}ट", "फाइल"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("archiefkast"),
            keywords: &["archief", "archiefkast", "kast"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("arkivskap"),
            keywords: &["arkiv", "arkivskap", "fil", "kabinett", "mapper"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଫ\u{b3e}ଇଲ\u{b4d}\u{200c} କ\u{b4d}ୟ\u{b3e}ବ\u{b3f}ନେଟ\u{b4d}\u{200c}"),
            keywords: &[
                "କ\u{b4d}ୟ\u{b3e}ବ\u{b3f}ନେଟ\u{b4d}\u{200c}",
                "ଫ\u{b3e}ଇଲ\u{b3f}ଂ",
                "ଫ\u{b3e}ଇଲ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਫਾਇਲ ਕ\u{a48}ਬਿਨ\u{a47}ਟ"),
            keywords: &[
                "ਫ\u{a3c}ਾਇਲਾ\u{a02}",
                "ਫਾਇਲ ਕ\u{a48}ਬਿਨ\u{a47}ਟ",
                "ਫਾਇਲਾ\u{a02} ਵਾਲਾ ਕ\u{a48}ਬਿਨ\u{a48}ਟ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("فائل کیبنٹ"),
            keywords: &["بھرنا", "فائل", "فائل کیبنٹ", "کابینہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Faíl Kábínẹt"),
            keywords: &["Fail", "Faíl Kábínẹt", "Kábínẹt"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("szafka-kartoteka"),
            keywords: &[
                "dokumenty",
                "indeks",
                "kartoteka",
                "karty",
                "szafka",
                "szafka-kartoteka",
                "szuflady",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د دوتنې کابينټ"),
            keywords: &["د دوتنې کابينټ", "دوتنه", "دوتنه کول", "کابينټ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("gavetas de escritório"),
            keywords: &[
                "arquivo",
                "escritório",
                "gabinete",
                "gavetas",
                "gavetas de escritório",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("ficheiro"),
            keywords: &["armário", "arquivo", "ficheiro"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("fișet"),
            keywords: &["birou", "dulap", "fișet"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-818"),
            keywords: &["E10-818"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("архивный шкаф"),
            keywords: &["архив", "архивный шкаф", "данные", "сведения", "шкаф"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("dosiye zo mu biro"),
            keywords: &["akabati", "dosiye", "dosiye zo mu biro", "kubika dosiye"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("فائل رکڻ جو دراز"),
            keywords: &["دراز", "فائل رکڻ جو دراز", "فائيل", "فائيلنگ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ගොන\u{dd4} කැබ\u{dd2}නට\u{dca}ට\u{dd4}ව"),
            keywords: &[
                "කැබ\u{dd2}නට\u{dca}ට\u{dd4}ව",
                "ගොන\u{dd4} කැබ\u{dd2}නට\u{dca}ට\u{dd4}ව",
                "ගොන\u{dd4}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kartotéková skriňa"),
            keywords: &["kabinet", "kartotéková skriňa", "súbor"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("predalnik za dokumente"),
            keywords: &["predalnik", "predalnik za dokumente", "spis"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("khaanadaha faylasha"),
            keywords: &["buuxin", "fayl", "khaanad", "khaanadaha faylasha"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("sirtar dokumentesh"),
            keywords: &["dokument", "sirtar", "sirtar dokumentesh", "skedar"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("ормар за картотеку"),
            keywords: &["картотека", "ормар", "ормар за картотеку"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ormar za kartoteku"),
            keywords: &["kartoteka", "ormar", "ormar za kartoteku"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("dokumentskåp"),
            keywords: &["dokument", "dokumentskåp", "skåp"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kabati la hati"),
            keywords: &["faili", "kabati", "kabati la hati"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பைல\u{bcd} கேபினட\u{bcd}"),
            keywords: &["கேபினட\u{bcd}", "பைல\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఫ\u{c48}ల\u{c4d} క\u{c4d}య\u{c3e}బ\u{c3f}న\u{c46}ట\u{c4d}"),
            keywords: &[
                "క\u{c4d}య\u{c3e}బ\u{c3f}న\u{c46}ట\u{c4d}",
                "ఫ\u{c48}ల\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("кабинети файлҳо"),
            keywords: &["кабинет", "кабинети файлҳо", "файл", "ҳуҷҷатдорӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ต\u{e39}\u{e49}เอกสาร"),
            keywords: &[
                "ต\u{e39}\u{e49}",
                "ต\u{e39}\u{e49}เอกสาร",
                "เอกสาร",
                "แฟ\u{e49}ม",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("faýl çekmesi"),
            keywords: &["faýl", "faýl çekmesi", "faýllamak", "çekme"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("toloa takafi faile"),
            keywords: &["toloa takafi faile"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("dosya dolabı"),
            keywords: &["dolap", "dosya", "dosya dolabı"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ھۆججەت ئىشكاپى"),
            keywords: &["ئارخىپ", "ئىشكاپ", "ھۆججەت", "ھۆججەت ئىشكاپى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("шафа для документів"),
            keywords: &["реєстратор", "шафа", "шафа для документів"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("فائل کیبنٹ"),
            keywords: &["اسٹیشنری", "فائل", "کیبنٹ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("fayllar javoni"),
            keywords: &["fayl", "fayl yaratish", "fayllar javoni", "javon"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tủ hồ sơ"),
            keywords: &["tệp", "tủ", "tủ hồ sơ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("tirwaaru taxañ"),
            keywords: &["def taxañ", "taxañ", "tirwaar", "tirwaaru taxañ"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ikhabhathi yefayile"),
            keywords: &[
                "ifayile",
                "ikhabhathi",
                "ikhabhathi yefayile",
                "ukufaka kwifayile",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àpótí fáàlì"),
            keywords: &["fáàlì", "àpótí", "ìforúkọ fáàlì sílẹ\u{300}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("檔案櫃"),
            keywords: &["檔案", "檔案櫃", "櫃"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("档案柜"),
            keywords: &["柜", "档案", "档案柜"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("文件柜"),
            keywords: &["存档", "归档", "收纳", "文件柜", "柜", "档案"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("檔案櫃"),
            keywords: &["檔案櫃"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["檔案櫃", "檔案櫃｜檔案"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ikhabethei lamafayela"),
            keywords: &["fayela", "ikhabethe", "ikhabethei lamafayela"],
        },
    ],
};
#[doc = "🗑\u{fe0f}"]
pub const WASTEBASKET: crate::Emoji = crate::Emoji {
    glyph: "🗑\u{fe0f}",
    codepoint: "1F5D1 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "wastebasket",
    group: "Objects",
    subgroup: "office",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🗑",
        codepoint: "1F5D1",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "wastebasket",
        group: "Objects",
        subgroup: "office",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("snippermandjie"),
            keywords: &["blik", "drom", "mandjie", "snippermandjie", "vullis"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የቆሻሻ መጣያ"),
            keywords: &["የቆሻሻ መጣያ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سلة نفايات"),
            keywords: &["سلة", "نفايات"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ৱেষ\u{9cd}টব\u{9be}স\u{9cd}কেট"),
            keywords: &["ৱেষ\u{9cd}টব\u{9be}স\u{9cd}কেট"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("zibilqabı"),
            keywords: &["zibilqabı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кошык для смецця"),
            keywords: &["кошык", "кошык для смецця", "сметніца", "смецце"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("кошче"),
            keywords: &["кошче", "кошче за боклук"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("নোংর\u{9be} ফেল\u{9be}র ঝ\u{9c1}ড\u{9bc}ি"),
            keywords: &[
                "নোংর\u{9be} ফেল\u{9be}র ঝ\u{9c1}ড\u{9bc}ি",
                "ব\u{9be}জে ক\u{9be}গজ ফেল\u{9be}র ঝ\u{9c1}\u{981}ড\u{9bc}ি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kest ar paper"),
            keywords: &["kest", "kest ar paper", "paper"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("korpa za otpatke"),
            keywords: &["korpa za otpatke"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("paperera"),
            keywords: &["cubell", "paperera"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏲᏩᏗᏅᏗ ᏔᎷᏣ"),
            keywords: &["ᎤᏲᏩᏗᏅᏗ ᏔᎷᏣ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("odpadkový koš"),
            keywords: &["koš", "odpad", "odpadkový koš", "smetí"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bin sbwriel"),
            keywords: &["bin sbwriel"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("papirkurv"),
            keywords: &["papirkurv", "skraldespand"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Papierkorb"),
            keywords: &["Papierkorb"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καλάθι αχρήστων"),
            keywords: &["κάδος αχρήστων", "καλάθι αχρήστων"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("wastebasket"),
            keywords: &["wastebasket"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("wastepaper basket"),
            keywords: &["paper bin", "wastebasket", "wastepaper basket"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("wastebasket"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("papelera"),
            keywords: &["basura", "cubo", "papelera"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cesto"),
            keywords: &["basura", "cesto", "papeles"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("papelera"),
            keywords: &["papelera"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("prügikorv"),
            keywords: &["prügi", "prügikorv"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("zakarrontzia"),
            keywords: &["zakarrontzi", "zakarrontzia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("سطل کاغذ باطله"),
            keywords: &["سطل زباله", "سطل کاغذ باطله"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("roskakori"),
            keywords: &["roskakori", "roskis"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("basurahan"),
            keywords: &["basura", "basurahan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("pappírskurv"),
            keywords: &["pappírskurv", "pappírsleypur", "skrell"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("corbeille à papiers"),
            keywords: &["corbeille", "corbeille à papiers"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("corbeille"),
            keywords: &["corbeille"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bosca bruscair"),
            keywords: &["bosca bruscair"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bogsa-sgudail"),
            keywords: &["bogsa-sgudail", "sgudal"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("papeleira"),
            keywords: &["papeleira"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કચરાપ\u{ac7}ટી"),
            keywords: &["કચરાપ\u{ac7}ટી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kwandon shara"),
            keywords: &["kwandon shara"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סל ניירות"),
            keywords: &["אשפה", "סל", "סל ניירות", "פח"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("कचरा प\u{947}टी"),
            keywords: &["कचरा प\u{947}टी", "रद\u{94d}दी की टोकरी"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("koš za smeće"),
            keywords: &["koš za smeće"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("papírkosár"),
            keywords: &["papírkosár"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("աղբաման"),
            keywords: &["աղբաման"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("keranjang sampah"),
            keywords: &["keranjang sampah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("èkètedọtị"),
            keywords: &["èkètedọtị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ruslakarfa"),
            keywords: &["rusl", "ruslakarfa"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cestino"),
            keywords: &["buttare", "cartacce", "cestino", "rifiuti"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ごみ箱"),
            keywords: &["くずかご", "ごみかご", "ごみ箱", "ゴミ箱"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kranjang sampah"),
            keywords: &["kranjang sampah"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სანაგვე ურნა"),
            keywords: &["კალათა", "ნაგავი", "სანაგვე ურნა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қоқыс себеті"),
            keywords: &["қоқыс себеті"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("papirkurv"),
            keywords: &["papirkurv", "skraldespand"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កន\u{17d2}ត\u{17d2}រកដាក\u{17cb}ស\u{17c6}រាម"),
            keywords: &["កន\u{17d2}ត\u{17d2}រកដាក\u{17cb}ស\u{17c6}រាម"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಳಪ\u{cc6} ಕಾಗದ ಬುಟ\u{ccd}ಟ\u{cbf}"),
            keywords: &[
                "ಕಳಪ\u{cc6} ಕಾಗದ ಬುಟ\u{ccd}ಟ\u{cbf}",
                "ಬ\u{ccd}ಯಾಸ\u{ccd}ಕ\u{cc6}ಟ\u{ccd}",
                "ವೇಸ\u{ccd}ಟ\u{ccd} ಬ\u{ccd}ಯಾಸ\u{ccd}ಕ\u{cc6}ಟ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("쓰레기통"),
            keywords: &["쓰레기통", "휴지통"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("कोयराबालदी"),
            keywords: &["कोयराबालदी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("таштанды кутусу"),
            keywords: &["таштанды кутусу", "таштанды чака"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Dreckskëscht"),
            keywords: &["Dreckskëscht"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກະຕ\u{ec8}າຂ\u{eb5}\u{ec9}ເຫຍ\u{eb7}\u{ec9}ອ"),
            keywords: &[
                "ກະຕ\u{ec8}າ",
                "ກະຕ\u{ec8}າຂ\u{eb5}\u{ec9}ເຫຍ\u{eb7}\u{ec9}ອ",
                "ຂ\u{eb5}\u{ec9}ເຫຍ\u{eb7}\u{ec9}ອ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("šiukšliadėžė"),
            keywords: &["šiukšliadėžė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("atkritumu grozs"),
            keywords: &["atkritumu grozs", "papīrkurvis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pāhikete para"),
            keywords: &["pāhikete para"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("корпа за отпадоци"),
            keywords: &["корпа", "корпа за отпадоци", "отпадоци"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ചവറ\u{d4d}റ\u{d41}ക\u{d41}ട\u{d4d}ട"),
            keywords: &[
                "ചവറ\u{d4d}",
                "ചവറ\u{d4d}റ\u{d41}ക\u{d41}ട\u{d4d}ട",
                "വെയിസ\u{d4d}\u{200c}റ\u{d4d}റ\u{d4d} ബ\u{d3e}സ\u{d4d}\u{200c}ക\u{d4d}കറ\u{d4d}റ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хогийн сав"),
            keywords: &["хогийн сав"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कचराप\u{947}टी"),
            keywords: &["कचराप\u{947}टी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tong sampah"),
            keywords: &["tong sampah"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("landa tal-iskart"),
            keywords: &["landa tal-iskart"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမ\u{103e}\u{102d}\u{102f}က\u{103a}ခြင\u{103a}း"),
            keywords: &["အမ\u{103e}\u{102d}\u{102f}က\u{103a}ခြင\u{103a}း"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("papirkurv"),
            keywords: &["papirkurv", "søppelkasse", "søppelkurv"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("फोहोर फाल\u{94d}न\u{947} डालो"),
            keywords: &["फोहोर फाल\u{94d}न\u{947} डालो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("prullenmand"),
            keywords: &["prullenmand"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("papirkorg"),
            keywords: &["boskorg", "papirkorg", "søppelkasse", "søppelkorg"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଆବର\u{b4d}ଜନ\u{b3e} ବୋଝ"),
            keywords: &["ଆବର\u{b4d}ଜନ\u{b3e} ବୋଝ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਰ\u{a71}ਦ ਦੀ ਟ\u{a4b}ਕਰੀ"),
            keywords: &["ਰ\u{a71}ਦ ਦੀ ਟ\u{a4b}ਕਰੀ", "ਰ\u{a71}ਦੀ ਵਾਲੀ ਟ\u{a4b}ਕਰੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کوڑی دی ٹوکری"),
            keywords: &["کوڑی دی ٹوکری"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wést Pépá Báskẹt"),
            keywords: &["Wést Pépá Báskẹt"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kosz na śmieci"),
            keywords: &["kosz", "kosz na śmieci", "odpadki", "śmieci"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د ضایع ټوکر"),
            keywords: &["د ضایع ټوکر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("lixeira"),
            keywords: &["cesto de lixo", "lixeira"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cesto do lixo"),
            keywords: &["caixote do lixo", "cesto do lixo"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("coș de gunoi"),
            keywords: &["coș", "coș de gunoi"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-819"),
            keywords: &["E10-819"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("корзина для мусора"),
            keywords: &[
                "бумаги",
                "корзина",
                "корзина для мусора",
                "мусор",
                "мусорка",
                "мусорная",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("agatebo k’imyanda"),
            keywords: &["agatebo k’imyanda"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪچري جي ٽوڪري"),
            keywords: &["ڪچري جي ٽوڪري"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අපද\u{dca}\u{200d}රව\u{dca}\u{200d}ය ක\u{dd6}ඩය"),
            keywords: &["අපද\u{dca}\u{200d}රව\u{dca}\u{200d}ය ක\u{dd6}ඩය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("odpadkový kôš"),
            keywords: &["kôš", "odpadkový kôš"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("koš za smeti"),
            keywords: &["koš za smeti"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("caaga xashiishka"),
            keywords: &["caaga xashiishka"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kosh basketbolli"),
            keywords: &["kosh basketbolli"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("корпа за ђубре"),
            keywords: &["корпа за ђубре"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["корпа за ђубре"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("korpa za đubre"),
            keywords: &["korpa za đubre"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["korpa za đubre"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("papperskorg"),
            keywords: &["papperskorg", "skräp", "sopor", "soptunna"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ndoo la taka"),
            keywords: &["ndoo la taka"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("குப\u{bcd}பைத\u{bcd} தொட\u{bcd}டி"),
            keywords: &[
                "குப\u{bcd}பைக\u{bcd} கூடை",
                "குப\u{bcd}பைத\u{bcd} தொட\u{bcd}டி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c46}త\u{c4d}త బుట\u{c4d}ట"),
            keywords: &[
                "చ\u{c46}త\u{c4d}త బుట\u{c4d}ట",
                "పన\u{c3f}క\u{c3f} ర\u{c3e}దు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("сабади партовҳо"),
            keywords: &["сабади партовҳо"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ตะกร\u{e49}าขยะ"),
            keywords: &["ขยะ", "ตะกร\u{e49}า", "ตะกร\u{e49}าขยะ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("zibil bedresi"),
            keywords: &["zibil bedresi"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kapa veve"),
            keywords: &["kapa veve"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("çöp sepeti"),
            keywords: &["çöp sepeti"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئەخلەت سېۋىتى"),
            keywords: &["ئەخلەت سېۋىتى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("сміттєвий кошик"),
            keywords: &["кошик", "сміття", "сміттєвий кошик"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ردی کی ٹوکری"),
            keywords: &["ردی", "ردی کی ٹوکری", "ٹوکری"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qog‘oz chiqitdoni"),
            keywords: &["qog‘oz chiqitdoni"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("sọt rác"),
            keywords: &["sọt rác"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("pañe mbalit"),
            keywords: &["pañe mbalit"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhaskithi yenkunkuma"),
            keywords: &["ibhaskithi yenkunkuma"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("apẹ\u{300}rẹ\u{300} ìdalè\u{329}sí"),
            keywords: &["apẹ\u{300}rẹ\u{300} ìdalè\u{329}sí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("廢紙簍"),
            keywords: &["廢紙簍"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("废纸篓"),
            keywords: &["废纸篓"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("垃圾桶"),
            keywords: &["垃圾", "垃圾桶", "垃圾篓", "废纸篓"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("廢紙簍"),
            keywords: &["廢紙簍"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("垃圾桶"),
            keywords: &["垃圾桶"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubhasikidi wezibi"),
            keywords: &["ubhasikidi wezibi"],
        },
    ],
};
