#[doc = "🎷"]
pub const SAXOPHONE: crate::Emoji = crate::Emoji {
    glyph: "🎷",
    codepoint: "1F3B7",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "saxophone",
    group: "Objects",
    subgroup: "musical-instrument",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("saxofoon"),
            keywords: &["instrument", "musiek", "saxofoon"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሳክስፎን"),
            keywords: &["መሣሪያ", "ሙዚቃ", "ሳክስ", "ሳክስፎን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ساكسفون"),
            keywords: &["آلة", "آلة موسيقية", "ساكسفون", "موسيقى"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ছেক\u{9cd}স’ফোন"),
            keywords: &[
                "ছেক\u{9cd}স",
                "ছেক\u{9cd}স’ফোন",
                "ব\u{9be}দ\u{9cd}যযন\u{9cd}ত\u{9cd}ৰ",
                "সংগীত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("saksofon"),
            keywords: &["alət", "musiqi", "saks", "saksofon"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("саксафон"),
            keywords: &["духавы", "музыка", "музычны", "саксафон", "інструмент"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("саксофон"),
            keywords: &["инструмент", "музика", "сакс", "саксофон"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9cd}য\u{9be}ক\u{9cd}সোফোন"),
            keywords: &[
                "সঙ\u{9cd}গীত",
                "সঙ\u{9cd}গীত যন\u{9cd}ত\u{9cd}র",
                "স\u{9cd}য\u{9be}ক\u{9cd}সোফোন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("saksofon"),
            keywords: &["benveg", "saksofon", "sonerezh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("saksofon"),
            keywords: &["instrument", "muzika", "saksofon"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("saxofon"),
            keywords: &["instrument", "música", "saxo", "saxofon", "saxòfon"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏌᎦᎪᏁ"),
            keywords: &["ᎦᏤᎷᎩᏍᏗ", "ᏌᎦᎪᏁ", "ᏗᎧᏃᎩᏍᏗ", "ᏗᎧᏃᎩᏍᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("saxofon"),
            keywords: &["hudba", "nástroj", "saxofon"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sacsoffon"),
            keywords: &["cerddoriaeth", "offeryn", "sacs", "sacsoffon"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("saxofon"),
            keywords: &["instrument", "musik", "musikinstrument", "sax", "saxofon"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Saxofon"),
            keywords: &["Instrument", "Musik", "Musikinstrument", "Saxofon"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σαξόφωνο"),
            keywords: &["μουσική", "σαξόφωνο", "όργανο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("saxophone"),
            keywords: &["instrument", "music", "sax", "saxophone"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("saxofón"),
            keywords: &[
                "instrumento",
                "instrumento musical",
                "música",
                "saxo",
                "saxofón",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("saksofon"),
            keywords: &["muusika", "pill", "saksofon"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("saxofoia"),
            keywords: &["musika", "saxofoi", "saxofoia", "tresna"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ساکسیفون"),
            keywords: &["بادی برنجی", "ساز", "ساکسیفون", "موسیقی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("saksofoni"),
            keywords: &["instrumentti", "musiikki", "saksofoni"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("saxophone"),
            keywords: &["instrumento", "musika", "sax", "saxophone"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("saksofon"),
            keywords: &["ljóðføri", "saksofon", "tónleikur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("saxophone"),
            keywords: &["instrument", "musique", "saxophone"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("sacsafón"),
            keywords: &["ceol", "sacsafón", "uirlis"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sacsafon"),
            keywords: &["ceòl", "inneal-ciùil", "ionnsramaid", "sacsafon"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("saxofón"),
            keywords: &["instrumento", "saxo", "saxofón"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{ac7}ક\u{acd}સોફોન"),
            keywords: &[
                "વાદ\u{acd}ય",
                "સ\u{a82}ગીત",
                "સ\u{ac7}ક\u{acd}સ",
                "સ\u{ac7}ક\u{acd}સોફોન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("saxophone"),
            keywords: &["kayan kiɗa", "kiɗa", "sax", "saxophone"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סקסופון"),
            keywords: &["כלי נגינה", "מוזיקה", "סקסופון"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{948}क\u{94d}सोफ\u{93c}ोन"),
            keywords: &[
                "वाद\u{94d}यय\u{902}त\u{94d}र",
                "स\u{902}गीत",
                "स\u{902}गीत वाद\u{94d}य",
                "स\u{948}क\u{94d}स",
                "स\u{948}क\u{94d}सोफ\u{93c}ोन",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("saksofon"),
            keywords: &["glazba", "instrument", "saks", "saksofon"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szaxofon"),
            keywords: &["hangszer", "szaxi", "szaxofon", "zene"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սաքսոֆոն"),
            keywords: &["գործիք", "երաժշտություն", "սաքսոֆոն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("saksofon"),
            keywords: &["instrumen", "musik", "saksofon"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("opi egwu"),
            keywords: &["egwu", "ngwaegwu", "opi egwu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("saxófónn"),
            keywords: &["hljóðfæri", "saxófónn", "tónlist"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("sassofono"),
            keywords: &[
                "musica",
                "sassofono",
                "sax",
                "strumento",
                "strumento musicale",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("サックス"),
            keywords: &["サキソフォン", "サクソフォン", "サックス", "楽器", "音楽"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("saksofon"),
            keywords: &["instrumen", "musik", "saks", "saksofon"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("საქსოფონი"),
            keywords: &["ინსტრუმენტი", "მუსიკა", "საქსოფონი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("asaksufun"),
            keywords: &["asaksufun"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("саксофон"),
            keywords: &["музыка", "сакс", "саксофон", "құрал"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("saxofon"),
            keywords: &["instrument", "musik", "musikinstrument", "saxofon"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ត\u{17d2}រែផ\u{17d2}ល\u{17bb}\u{17c6}"),
            keywords: &[
                "ត\u{17d2}រែ",
                "ត\u{17d2}រែផ\u{17d2}ល\u{17bb}\u{17c6}",
                "ផ\u{17d2}ល\u{17bb}\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{ccd}ಯಾಕ\u{ccd}ಸೋಫೋನ\u{ccd}"),
            keywords: &[
                "ವಾದ\u{ccd}ಯ",
                "ಸಂಗೀತ",
                "ಸ\u{ccd}ಯಾಕ\u{ccd}ಸಾಫೋನ\u{ccd}",
                "ಸ\u{ccd}ಯಾಕ\u{ccd}ಸೋಫೋನ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("색소폰"),
            keywords: &["색소폰", "악기", "연주", "음악"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("स\u{945}क\u{94d}सोफोन"),
            keywords: &[
                "वाद\u{94d}य",
                "स\u{902}गीत",
                "स\u{945}क\u{94d}स",
                "स\u{945}क\u{94d}सोफोन",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("саксофон"),
            keywords: &["аспап", "музыка", "саксофон"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Saxofon"),
            keywords: &["Instrument", "Musek", "Sax", "Saxofon"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແຊ\u{eb1}ກໂຊໂຟນ"),
            keywords: &["ເຄ\u{eb7}\u{ec8}ອງດ\u{ebb}ນຕ\u{eb5}", "ແຊ\u{eb1}ກໂຊໂຟນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("saksofonas"),
            keywords: &["instrumentas", "muzika", "saksofonas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("saksofons"),
            keywords: &["instruments", "mūzika", "saksofons"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pūtohe"),
            keywords: &["puoro", "pūtohe", "whakatangi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("саксофон"),
            keywords: &["инструмент", "музика", "саксофон"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d3e}ക\u{d4d}സഫോൺ"),
            keywords: &["സംഗീതം", "സംഗീതോപകരണം", "സ\u{d3e}ക\u{d4d}സഫോൺ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("саксафон"),
            keywords: &["саксафон", "хөгжим"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{947}क\u{94d}सोफोन"),
            keywords: &[
                "वाद\u{94d}यव\u{943}\u{902}द",
                "स\u{902}गीत",
                "स\u{945}क\u{94d}सोफोन",
                "स\u{947}क\u{94d}सोफोन",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("saksofon"),
            keywords: &["alat", "muzik", "saks", "saksofon"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("sassofonu"),
            keywords: &["mużika", "sassafonu", "sassofonu", "strument"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဆက\u{103a}ဆ\u{102d}\u{102f}ဖ\u{102f}န\u{103a}း"),
            keywords: &[
                "ဆက\u{103a}ဆ\u{102d}\u{102f}ဖ\u{102f}န\u{103a}း",
                "တ\u{1030}ရ\u{102d}ယာ",
                "တေးဂ\u{102e}တ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("saksofon"),
            keywords: &[
                "instrument",
                "musikk",
                "musikkinstrument",
                "saksofon",
                "sax",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}याक\u{94d}सोफोन"),
            keywords: &["उपकरण", "स\u{902}गीत", "स\u{94d}याक\u{94d}सोफोन"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("saxofoon"),
            keywords: &["instrument", "muziek", "sax", "saxofoon"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("saksofon"),
            keywords: &[
                "instrument",
                "musikk",
                "musikkinstrument",
                "saksofon",
                "sax",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b3e}କ\u{b4d}ସୋଫୋନ\u{b4d}\u{200c}"),
            keywords: &[
                "ଉପକରଣ",
                "ସଙ\u{b4d}ଗୀତ",
                "ସଙ\u{b4d}ଗୀତ ଭ\u{b3f}ତ\u{b4d}ତ\u{b3f}କ ଉପକରଣ",
                "ସ\u{b3e}କ\u{b4d}ସୋଫୋନ\u{b4d}\u{200c}",
                "ସ\u{b4d}ୟ\u{b3e}କ\u{b4d}ସ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a48}ਕਸ\u{a4b}ਫ\u{a4b}ਨ"),
            keywords: &[
                "ਸਾਜ\u{a3c}",
                "ਸ\u{a48}ਕਸ",
                "ਸ\u{a48}ਕਸ\u{a4b}ਫ\u{a4b}ਨ",
                "ਸ\u{a48}ਕਸ\u{a4b}\u{a4b}ਫ\u{a4b}ਨ",
                "ਸ\u{a70}ਗੀਤ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سیکسو فون"),
            keywords: &["آلات", "سیکسو فون", "موسیقی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Saksafon"),
            keywords: &["Miúzik", "Saks", "Saksafon", "Ínstrúmẹnt"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("saksofon"),
            keywords: &["instrument", "muzyka", "saksofon"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ساکسفون"),
            keywords: &["اله", "ساکس", "ساکسفون", "موسيقي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("saxofone"),
            keywords: &[
                "instrumento",
                "instrumento musical",
                "música",
                "sax",
                "saxofone",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("saxofone"),
            keywords: &["instrumento", "música", "saxofone"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("saxofono"),
            keywords: &["saxofono"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("saxofon"),
            keywords: &["instrument", "muzică", "saxofon"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-375"),
            keywords: &["E10-375"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("саксофон"),
            keywords: &["инструмент", "музыка", "музыкальный инструмент", "саксофон"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umwirongi"),
            keywords: &["igikoresho", "umuziki", "umwirongi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سيڪسو فون"),
            keywords: &["آلو", "باجو", "سيڪسو فون", "موسيقي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සැක\u{dca}සෆෝනය"),
            keywords: &[
                "උපකරණය",
                "සංග\u{dd3}තය",
                "සැක\u{dca}සෆෝනය",
                "සැක\u{dca}ස\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("saxofón"),
            keywords: &["hudba", "nástroj", "saxofón"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("saksofon"),
            keywords: &["glasba", "instrument", "saksofon"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("buun"),
            keywords: &["buun", "buunka", "muusikada", "qalab"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("saksofon"),
            keywords: &["instrument", "muzikë", "saksofon"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("саксофон"),
            keywords: &["инструмeнт", "музика", "сaксофон", "саксофон"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("saksofon"),
            keywords: &["instrument", "muzika", "saksofon"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("saxofon"),
            keywords: &["musik", "musikinstrument", "saxofon"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("saksafoni"),
            keywords: &["ala", "muziki", "saksafoni"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ச\u{bbe}க\u{bcd}ஸபோன\u{bcd}"),
            keywords: &["இசை", "இசைக\u{bcd}கருவி", "ச\u{bbe}க\u{bcd}ஸபோன\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("శ\u{c3e}క\u{c4d}స\u{c4b}ఫ\u{c4b}న\u{c4d}"),
            keywords: &[
                "బ\u{c4d}య\u{c3e}ండ\u{c4d} మ\u{c47}ళ వ\u{c3e}య\u{c3f}ద\u{c4d}యం",
                "శ\u{c3e}క\u{c4d}స\u{c4b}ఫ\u{c4b}న\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("саксофон"),
            keywords: &["асбоб", "мусиқӣ", "саксофон"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แซ\u{e47}กโซโฟน"),
            keywords: &[
                "เคร\u{e37}\u{e48}องดนตร\u{e35}",
                "แซ\u{e47}ก",
                "แซ\u{e47}กโซโฟน",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("saksofon"),
            keywords: &["aýdym-saz", "instrument", "saksofon"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sakisefoni"),
            keywords: &["sakisefoni"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("saksafon"),
            keywords: &["alet", "müzik", "müzik aleti", "saksafon"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ساكسوفون"),
            keywords: &["ساز", "ساكس", "ساكسوفون", "مۇزىكا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("саксофон"),
            keywords: &["музичний", "саксофон", "інструмент"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سیکسو فون"),
            keywords: &["آلہ", "سیکسو فون", "موسیقی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("saksofon"),
            keywords: &["asbob", "musiqa", "saksafon", "saksofon"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("kèn saxophone"),
            keywords: &["kèn saxophone", "nhạc", "nhạc cụ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("saksofon"),
            keywords: &["jumtukaay", "misik", "saks", "saksofon"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-saxophone"),
            keywords: &["i-sax", "i-saxophone", "isixhobo", "umculo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ipè"),
            keywords: &["ipè", "irinṣẹ\u{301}", "orin", "sáàsì"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("色士風"),
            keywords: &["儀器", "色士風", "音樂"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("色士风"),
            keywords: &["仪器", "色士风", "音乐"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("萨克斯管"),
            keywords: &["乐器", "吹奏", "演奏", "萨克斯管", "音乐"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("薩克斯風"),
            keywords: &["樂器", "薩克斯風"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("色士風"),
            keywords: &["樂器｜色士風", "色士風"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("imfiliji"),
            keywords: &["imfiliji", "insimbi", "umculo"],
        },
    ],
};
#[doc = "🪗"]
pub const ACCORDION: crate::Emoji = crate::Emoji {
    glyph: "🪗",
    codepoint: "1FA97",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "accordion",
    group: "Objects",
    subgroup: "musical-instrument",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("trekklavier"),
            keywords: &["konsertina", "trekklavier"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አኮርዲዮን"),
            keywords: &["አኮርዲዮን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("أكورديون"),
            keywords: &["آلة موسيقية", "أكورديون"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("এক’ৰডিয\u{9bc}\u{9be}ন"),
            keywords: &[
                "এক’ৰডিয\u{9bc}\u{9be}ন",
                "কনচ\u{9be}ৰ\u{9cd}টিন\u{9be}",
                "স\u{9cd}ক\u{9c1}ইজ ব\u{9be}কচ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("akkordeon"),
            keywords: &["akkordeon", "akkordion", "konsertino", "qarmon"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("акардэон"),
            keywords: &["акардэон", "гармонік", "канцэрціна"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("акордеон"),
            keywords: &["акордеон", "баян"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("একর\u{9cd}ডিয\u{9bc}ন"),
            keywords: &[
                "একর\u{9cd}ডিয\u{9bc}ন",
                "একর\u{9cd}ডিয\u{9bc}\u{9be}ন",
                "কনস\u{9be}র\u{9cd}টিন\u{9be}",
                "স\u{9cd}ক\u{9c1}ইজ বক\u{9cd}স",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("akordeoñs"),
            keywords: &["akordeoñs", "benveg", "sonerezh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("harmonika"),
            keywords: &["harmonika", "instrument", "muzika"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("acordió"),
            keywords: &["acordió", "concertina"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎪᏗᎠᏂ"),
            keywords: &["ᎠᎪᏗᎠᏂ", "ᎠᏓᏐᎠᏍᏙᏗ ᎧᏁᏌᎢ", "ᎤᏃᎴ ᎧᏁᏌᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("akordeon"),
            keywords: &[
                "akordeon",
                "dršťky",
                "harmonika",
                "koncertina",
                "tahací",
                "zednické piano",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("acordion"),
            keywords: &["acordion", "blwch gwasgu", "consertina"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("akkordeon"),
            keywords: &[
                "akkordeon",
                "bandoneon",
                "harmonika",
                "koncertina",
                "musette",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Akkordeon"),
            keywords: &[
                "Akkordeon",
                "Akkordeons",
                "Concertina",
                "Quetschkommode",
                "Quetschkommoden",
                "Ziehharmonika",
                "Ziehharmonikas",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ακορντεόν"),
            keywords: &["ακορντεόν", "κοντσερτίνα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("accordion"),
            keywords: &["accordian", "accordion", "concertina", "squeeze box"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("acordeón"),
            keywords: &["acordeón", "concertina"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "acordeón",
                "bandoneón",
                "concertina",
                "instrumento musical",
                "música",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("acordeón"),
            keywords: &["acordeón"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("acordeón"),
            keywords: &["acordeón"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("akordion"),
            keywords: &["akordion", "lõõts", "lõõtspill"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("akordeoi"),
            keywords: &["akordeoi", "akordeoia", "kontzertina"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("آکوردئون"),
            keywords: &["آکاردئون", "آکوردئون", "ارغنون"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("harmonikka"),
            keywords: &["haitari", "hanuri", "harmonikka"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("accordion"),
            keywords: &["accordion"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("harmonika"),
            keywords: &["dans", "dansur", "harmonika", "ljóðføri", "tónleikur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("accordéon"),
            keywords: &["accordéon", "bandonéon", "concertina", "piano à bretelles"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("accordéon"),
            keywords: &["accordéon", "concertina"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bosca ceoil"),
            keywords: &["bosca ceoil"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bogsa-ciùil"),
            keywords: &["bogsa", "bogsa-ciùil", "bucas"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("acordeón"),
            keywords: &["acordeón", "concerto", "instrumento", "música"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("એકોર\u{acd}ડિયન"),
            keywords: &[
                "એકોર\u{acd}ડિયન",
                "ધમણવાળી વાદ\u{acd}યપ\u{ac7}ટી",
                "સ\u{acd}ક\u{acd}વિઝ બૉક\u{acd}સ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אקורדיון"),
            keywords: &["אקורדיאון", "אקורדיון", "קונצרטינה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("अकॉर\u{94d}डियन"),
            keywords: &[
                "अकॉर\u{94d}डियन",
                "कॉन\u{94d}सर\u{94d}टिना",
                "स\u{94d}क\u{94d}वीज\u{93c} बॉक\u{94d}स",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("harmonika"),
            keywords: &[
                "harmonika",
                "instrument",
                "mala harmonika",
                "ručna harmonika",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("harmonika"),
            keywords: &["harmonika", "tangóharmonika"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ակորդեոն"),
            keywords: &["ակորդեոն", "հարմոն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("akordeon"),
            keywords: &["akordeon", "concertina", "kotak remas"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("harmonika"),
            keywords: &["harmonika", "harmonikuleikari", "konsertína", "nikka"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("fisarmonica"),
            keywords: &["concertina", "fisarmonica", "organetto"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("アコーディオン"),
            keywords: &["じゃばら", "アコーディオン", "楽器", "音楽"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("akordion"),
            keywords: &["akordion", "konser", "kotak pamerasan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("აკორდეონი"),
            keywords: &["აკორდეონი", "აკორდიონი", "გარმონი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("аккордеон"),
            keywords: &["аккордеон", "концертино", "сырнай"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("អាក\u{17cb}គ\u{17d0}រដេអ\u{17bb}ង"),
            keywords: &[
                "អគ\u{17d0}រដេអ\u{17bb}ង",
                "អាក\u{17cb}គ\u{17d0}រដេអ\u{17bb}ង",
                "ឧបករណ\u{17cd}ភ\u{17d2}លេងសង\u{17d2}កត\u{17cb}ច\u{17bc}លគ\u{17d2}នា",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಅಕಾರ\u{ccd}ಡ\u{cbf}ಯನ\u{ccd}\u{200c}"),
            keywords: &[
                "ಅಕಾರ\u{ccd}ಡ\u{cbf}ಯನ\u{ccd}\u{200c}",
                "ಕನ\u{ccd}ಸರ\u{ccd}ಟ\u{cbf}ನಾ",
                "ಸ\u{ccd}ಕ\u{ccd}ವೀಜ\u{ccd}\u{200c} ಬಾಕ\u{ccd}ಸ\u{ccd}\u{200c}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("아코디언"),
            keywords: &["아코디언", "콘서티나"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("अकोर\u{94d}डियन"),
            keywords: &[
                "अकोर\u{94d}डियन",
                "कॉन\u{94d}सर\u{94d}टिना",
                "स\u{94d}क\u{94d}विज बॉक\u{94d}स",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("аккордеон"),
            keywords: &["аккордеон"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{eb5}ບເພງ"),
            keywords: &["ກ\u{ec8}ອງ", "ຄອນເສ\u{eb5}ດ", "ຫ\u{eb5}ບເພງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("akordeonas"),
            keywords: &["akordeonas", "armonika"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("akordeons"),
            keywords: &["akordeons", "koncertīna", "rokas armoņikas"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("хармоника"),
            keywords: &["концертина", "хармоника"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("അക\u{d4d}കോർഡിയൻ"),
            keywords: &[
                "അക\u{d4d}കോർഡിയൻ",
                "കൺസർട\u{d4d}ടീന",
                "സ\u{d4d}ക\u{d4d}വീസ\u{d4d} ബോക\u{d4d}സ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("аккордеон"),
            keywords: &["аккордеон", "баян хуур"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("एकॉर\u{94d}डियन"),
            keywords: &[
                "एकॉर\u{94d}डियन",
                "कॉन\u{94d}सर\u{94d}टिना",
                "स\u{94d}क\u{94d}वीझ बॉक\u{94d}स",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("akordion"),
            keywords: &["akordion", "konsertina", "kotak himpit"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အကော\u{103a}ဒ\u{102e}ယ\u{1036}"),
            keywords: &[
                "လက\u{103a}ဆ\u{103d}\u{1032}ဘာဂျာ",
                "အကော\u{103a}ဒ\u{102e}ယ\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("trekkspill"),
            keywords: &["accordeon", "concertina", "trekkspill"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("अक\u{94d}कोर\u{94d}डियन"),
            keywords: &[
                "अक\u{94d}कोर\u{94d}डियन",
                "कन\u{94d}सर\u{94d}टिना",
                "स\u{94d}क\u{94d}विज बाकस",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("accordeon"),
            keywords: &["accordeon", "bandoneon", "concertina", "trekzak"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("trekkspel"),
            keywords: &["accordeon", "concertina", "trekkspel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଏକ\u{b4d}କୋର\u{b4d}ଡ\u{b3c}\u{b3f}ଓନ"),
            keywords: &[
                "ଏକ\u{b4d}କୋର\u{b4d}ଡ\u{b3c}\u{b3f}ଓନ",
                "ଚୋନ\u{b4d}ସେର\u{b4d}ଟ\u{b3f}ନ\u{b3e}",
                "ସ\u{b4d}କ\u{b41}ଇଜ ବକ\u{b4d}ସ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਅਕਾਰਡੀਅਨ"),
            keywords: &[
                "ਅਕਾਰਡੀਅਨ",
                "ਕਨਸਰਟਿਨਾ",
                "ਦਬਾਉਣ ‘ਤ\u{a47} ਵ\u{a71}ਜਣ ਵਾਲਾ ਸਾਜ\u{a3c}",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Akọ\u{301}diọn"),
            keywords: &["Akọ\u{301}diọn", "Kọnsẹtína", "Skwíz Bọks"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("akordeon"),
            keywords: &["akordeon", "harmonia", "koncertyna"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("اکورديون"),
            keywords: &["اکورديون", "د دباوهلو بوکسه", "کسرټينا"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("acordeão"),
            keywords: &["acordeão", "concertina", "sanfona"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["acordeão"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("acordeon"),
            keywords: &["acordeon", "armonică", "burduf", "concertină"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-058"),
            keywords: &["E13-058"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("аккордеон"),
            keywords: &["аккордеон", "баян", "гармонь", "гармошка", "концертина"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اڪورڊيون"),
            keywords: &["اسڪويز باڪس", "اڪورڊيون", "ڪنسرٽينا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("එකෝඩ\u{dd2}න\u{dca}"),
            keywords: &[
                "එකෝඩ\u{dd2}න\u{dca}",
                "කොන\u{dca}සට\u{dd3}න",
                "ම\u{dd2}ර\u{dd2}කන පෙට\u{dca}ට\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("akordeón"),
            keywords: &["akordeón", "harmonika", "ťahacia"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("harmonika"),
            keywords: &["harmonika", "kromatična harmonika", "meh"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("alab muusik"),
            keywords: &[
                "alab muusik",
                "koonsatiina",
                "qalab muusik",
                "qalabeeyste musik",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fizarmonikë"),
            keywords: &["fizarmonikë", "koncertina"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("хармоника"),
            keywords: &["хармоника"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("harmonika"),
            keywords: &["harmonika"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("dragspel"),
            keywords: &["ackordeon", "dragharmonika", "dragspel"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kodiani"),
            keywords: &["harimuni", "kodiani", "konsertina"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அக\u{bcd}க\u{bbe}ர\u{bcd}டியன\u{bcd}"),
            keywords: &[
                "அக\u{bcd}க\u{bbe}ர\u{bcd}டியன\u{bcd}",
                "அழுத\u{bcd}தும\u{bcd} இசைப\u{bcd} பெட\u{bcd}டி",
                "க\u{bbe}ன\u{bcd}செர\u{bcd}டின\u{bbe}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("అక\u{c3e}ర\u{c4d}డ\u{c3f}య\u{c3e}న\u{c4d}"),
            keywords: &[
                "అక\u{c3e}ర\u{c4d}డ\u{c3f}యన\u{c4d}",
                "అక\u{c3e}ర\u{c4d}డ\u{c3f}య\u{c3e}న\u{c4d}",
                "క\u{c3e}న\u{c4d}స\u{c46}ర\u{c4d}ట\u{c3f}న\u{c3e}",
                "స\u{c4d}క\u{c4d}వ\u{c40}జ\u{c4d} బ\u{c3e}క\u{c4d}స\u{c4d}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แอคคอร\u{e4c}เด\u{e35}ยน"),
            keywords: &[
                "สคว\u{e35}ซบ\u{e47}อกซ\u{e4c}",
                "ห\u{e35}บเพลงช\u{e31}ก",
                "แอคคอร\u{e4c}เด\u{e35}ยน",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("akkordeon"),
            keywords: &["akkordeon", "gysyş gutusy", "konsertina"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("puhaleotoho"),
            keywords: &["puhaleotoho", "ʻakōtiane"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("akordiyon"),
            keywords: &["akordeon", "akordiyon"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("акордеон"),
            keywords: &["акордеон", "гармоніка", "концертина"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ارگن باجا"),
            keywords: &["ارگن باجا", "سکویز باکس", "کنسرٹینا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("akkordeon"),
            keywords: &["akkordeon", "garmon", "qisish", "siqish"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("phong cầm"),
            keywords: &["buổi hòa nhạc", "hộp bóp", "phong cầm"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("手風琴"),
            keywords: &["手風琴"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("手风琴"),
            keywords: &["手风琴"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("手风琴"),
            keywords: &["六角形风琴", "手风琴", "风琴"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("手風琴"),
            keywords: &["六角手風琴", "手風琴"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-accordion"),
            keywords: &[
                "cindezela ibhokisi",
                "i-accordian",
                "i-accordion",
                "i-concertina",
            ],
        },
    ],
};
#[doc = "🎸"]
pub const GUITAR: crate::Emoji = crate::Emoji {
    glyph: "🎸",
    codepoint: "1F3B8",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "guitar",
    group: "Objects",
    subgroup: "musical-instrument",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kitaar"),
            keywords: &["ghitaar", "instrument", "kitaar", "musiek"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጊታር"),
            keywords: &["መሣሪያ", "ሙዚቃ", "ጊታር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("غيتار"),
            keywords: &["آلة", "آلة موسيقية", "غيتار", "موسيقى"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("গিট\u{9be}ৰ"),
            keywords: &[
                "গিট\u{9be}ৰ",
                "ব\u{9be}দ\u{9cd}যযন\u{9cd}ত\u{9cd}ৰ",
                "সংগীত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("gitara"),
            keywords: &["alət", "gitara", "musiqi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("гітара"),
            keywords: &["гітара", "музыка", "музычны", "шчыпковы", "інструмент"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("китара"),
            keywords: &["инструмент", "китара", "музика"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("গিট\u{9be}র"),
            keywords: &[
                "গিট\u{9be}র",
                "সঙ\u{9cd}গীত",
                "সঙ\u{9cd}গীত যন\u{9cd}ত\u{9cd}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("gitar"),
            keywords: &["benveg", "gitar", "sonerezh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("gitara"),
            keywords: &["gitara", "instrument", "muzika"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("guitarra"),
            keywords: &["corda", "guitarra", "instrument", "música", "rock"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄉\u{11128}𑄑𑄢\u{11134}"),
            keywords: &["𑄉\u{11128}𑄑𑄢\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᏇᏄᎩᏍᏗ"),
            keywords: &["ᏗᎧᏃᎩᏍᏗ", "ᏗᎧᏃᎩᏍᏙᏗ", "ᏗᏇᏄᎩᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kytara"),
            keywords: &["hudba", "kytara", "nástroj"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("gitâr"),
            keywords: &["cerddoriaeth", "gitâr", "offeyrn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("guitar"),
            keywords: &[
                "guitar",
                "instrument",
                "musik",
                "musikinstrument",
                "strengeinstrument",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Gitarre"),
            keywords: &["Gitarre", "Instrument", "Musik", "Musikinstrument"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κιθάρα"),
            keywords: &["κιθάρα", "μουσική", "όργανο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("guitar"),
            keywords: &["guitar", "instrument", "music"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("guitarra"),
            keywords: &["guitarra", "instrumento", "instrumento musical", "música"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["guitarra", "instrumento", "música"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kitarr"),
            keywords: &["kitarr", "muusika", "pill"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gitarra"),
            keywords: &["gitarra", "musika", "tresna"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("گیتار"),
            keywords: &["الکتریک", "راک", "ساز", "موسیقی", "گیتار"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kitara"),
            keywords: &["instrumentti", "kitara", "musiikki"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("gitara"),
            keywords: &["gitara", "instrumento", "musika", "pangtugtog"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("gittari"),
            keywords: &["gittari", "ljóðføri", "tónleikur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("guitare"),
            keywords: &["guitare", "instrument", "musique"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("giotár"),
            keywords: &["ceol", "giotár", "uirlis"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("giotàr"),
            keywords: &["ceòl", "giotàr", "inneal-ciùil", "ionnsramaid"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("guitarra"),
            keywords: &["guitarra", "instrumento"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ગિટાર"),
            keywords: &["ગિટાર", "વાદ\u{acd}ય", "સ\u{a82}ગીત"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("gitar"),
            keywords: &["gitar", "kayan kiɗa", "kiɗa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גיטרה"),
            keywords: &["גיטרה", "כלי נגינה", "מוזיקה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("गिटार"),
            keywords: &["गिटार", "वाद\u{94d}यय\u{902}त\u{94d}र", "स\u{902}गीत"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("gitara"),
            keywords: &["gitara", "glazba", "instrument"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("gitár"),
            keywords: &["gitár", "hangszer", "zene"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կիթառ"),
            keywords: &["գործիք", "երաժշտություն", "կիթառ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("gitar"),
            keywords: &["gitar", "instrumen", "musik"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụbọ"),
            keywords: &["egwu", "ngwaegwu", "ụbọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("gítar"),
            keywords: &["gítar", "hljóðfæri", "tónlist"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("chitarra"),
            keywords: &["chitarra", "musica", "strumento", "strumento musicale"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ギター"),
            keywords: &["ギター", "楽器", "音楽"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("gitar"),
            keywords: &["gitar", "instrumen", "musik"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გიტარა"),
            keywords: &["გიტარა", "ინსტრუმენტი", "მუსიკა"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("snitra"),
            keywords: &["snitra"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("гитара"),
            keywords: &["гитара", "музыка", "құрал"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("guitar"),
            keywords: &[
                "guitar",
                "instrument",
                "musik",
                "musikinstrument",
                "strengeinstrument",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ហ\u{17d2}គ\u{17b8}តា"),
            keywords: &["សម\u{17d2}លេង", "ហ\u{17d2}គ\u{17b8}តា"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಗ\u{cbf}ಟಾರ\u{ccd}"),
            keywords: &["ಗ\u{cbf}ಟಾರ\u{ccd}", "ವಾದ\u{ccd}ಯ", "ಸಂಗೀತ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("기타"),
            keywords: &["기타", "악기", "연주", "음악", "통기타"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("गिटार"),
            keywords: &["गिटार", "वाद\u{94d}य", "स\u{902}गीत"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("гитара"),
            keywords: &["аспап", "гитара", "музыка"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Gittar"),
            keywords: &["Gittar", "Instrument", "Musek"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກ\u{eb5}ຕາ"),
            keywords: &["ກ\u{eb5}ຕາ", "ເຄ\u{eb7}\u{ec8}ອງດ\u{ebb}ນຕ\u{eb5}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("gitara"),
            keywords: &["gitara", "instrumentas", "muzika"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ģitāra"),
            keywords: &["instruments", "mūzika", "ģitāra"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kitā"),
            keywords: &["kitā", "puoro", "whakatangi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("гитара"),
            keywords: &["гитара", "инструмент", "музика"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഗിറ\u{d4d}റ\u{d3e}ർ"),
            keywords: &["ഗിറ\u{d4d}റ\u{d3e}ർ", "സംഗീതം", "സംഗീതോപകരണം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гитар"),
            keywords: &["гитар", "хөгжим"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("गिटार"),
            keywords: &["गिटार", "वाद\u{94d}यव\u{943}\u{902}द", "स\u{902}गीत"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("gitar"),
            keywords: &["alat", "gitar", "muzik"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kitarra"),
            keywords: &["kitarra", "mużika", "strument"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဂစ\u{103a}တာ"),
            keywords: &["ဂစ\u{103a}တာ", "တ\u{1030}ရ\u{102d}ယာ", "တေးဂ\u{102e}တ"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("gitar"),
            keywords: &["gitar", "instrument", "musikk", "musikkinstrument"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("गितार"),
            keywords: &["उपकरण", "गितार", "स\u{902}गीत"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gitaar"),
            keywords: &["gitaar", "instrument", "muziek"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("gitar"),
            keywords: &["gitar", "instrument", "musikk", "musikkinstrument"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଗ\u{b3f}ଟ\u{b3e}ର\u{b4d}"),
            keywords: &[
                "ଉପକରଣ",
                "ଗ\u{b3f}ଟ\u{b3e}ର\u{b4d}",
                "ସଙ\u{b4d}ଗୀତ ଭ\u{b3f}ତ\u{b4d}ତ\u{b3f}କ ଉପକରଣ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਗਿਟਾਰ"),
            keywords: &["ਗਿਟਾਰ", "ਸਾਜ\u{a3c}", "ਸ\u{a70}ਗੀਤ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("گٹار"),
            keywords: &["آلات", "موسیقی", "گٹار"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Gita"),
            keywords: &["Gita", "Miúzik", "Ínstrúmẹnt"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("gitara"),
            keywords: &["gitara", "instrument", "muzyka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ګیتار"),
            keywords: &["اله", "موسيقي", "ګيتار", "ګیتار"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("guitarra"),
            keywords: &["guitarra", "instrumento", "instrumento musical", "música"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("guitarra elétrica"),
            keywords: &["guitarra elétrica", "instrumento", "música"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("guitarra"),
            keywords: &["guitarra"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("chitară"),
            keywords: &["chitară", "instrument", "muzică"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-376"),
            keywords: &["E10-376"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("гитара"),
            keywords: &["гитара", "инструмент", "музыка", "музыкальный инструмент"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("gitari"),
            keywords: &["gitari", "igikoresho", "umuziki"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("گٽار"),
            keywords: &["آلو", "موسيقي", "گٽار"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ග\u{dd2}ට\u{dcf}රය"),
            keywords: &["උපකරණය", "ග\u{dd2}ට\u{dcf}රය", "සංග\u{dd3}තය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("gitara"),
            keywords: &["gitara", "hudba", "nástroj"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kitara"),
            keywords: &["glasba", "glasbilo", "kitara"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("giitaar"),
            keywords: &["giitaar", "muusik", "qalab"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kitarë"),
            keywords: &["instrument", "kitarë", "muzikë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("гитара"),
            keywords: &["гитара", "инструмeнт", "музика"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("gitara"),
            keywords: &["gitara", "instrument", "muzika"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("gitarr"),
            keywords: &["gitarr", "musik", "musikinstrument"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("gita"),
            keywords: &["ala", "gita", "muziki"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கிட\u{bcd}ட\u{bbe}ர\u{bcd}"),
            keywords: &["இசை", "இசைக\u{bcd}கருவி", "கிட\u{bcd}ட\u{bbe}ர\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("గ\u{c3f}ట\u{c3e}ర\u{c4d}"),
            keywords: &[
                "గ\u{c3f}ట\u{c3e}ర\u{c4d}",
                "సంగ\u{c40}త పర\u{c3f}కరం",
                "సంగ\u{c40}తం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("гитар"),
            keywords: &["асбоб", "гитар", "мусиқӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ก\u{e35}ต\u{e49}าร\u{e4c}"),
            keywords: &[
                "ก\u{e35}ตาร\u{e4c}",
                "ก\u{e35}ตาร\u{e4c}ไฟฟ\u{e49}า",
                "ก\u{e35}ต\u{e49}าร\u{e4c}",
                "เคร\u{e37}\u{e48}องดนตร\u{e35}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gitara"),
            keywords: &["aýdym-saz", "gitara", "instrument"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kitā"),
            keywords: &["kitā"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("gitar"),
            keywords: &["alet", "gitar", "müzik", "müzik aleti"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("گىتار"),
            keywords: &["ساز", "ساكس", "گىتار"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("гітара"),
            keywords: &["гітара", "музичний", "інструмент"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گٹار"),
            keywords: &["آلہ", "موسیقی", "گٹار"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("gitara"),
            keywords: &["asbob", "gitara", "musiqa"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đàn ghi-ta"),
            keywords: &["nhạc", "nhạc cụ", "đàn ghi-ta"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("gitaar"),
            keywords: &["gitaar", "jumtukaay", "misik"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ikatala"),
            keywords: &["ikatala", "isixhobo", "umculo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("jìtá"),
            keywords: &["irinṣẹ\u{301}", "jìtá", "orin"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("結他"),
            keywords: &["儀器", "結他", "音樂"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("结他"),
            keywords: &["仪器", "结他", "音乐"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("吉他"),
            keywords: &["乐器", "吉他", "弹奏", "演奏", "音乐"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("吉他"),
            keywords: &["吉他", "樂器"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("結他"),
            keywords: &["樂器", "結他"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isigingci"),
            keywords: &["insimbi", "isigingci", "umculo"],
        },
    ],
};
#[doc = "🎹"]
pub const MUSICAL_KEYBOARD: crate::Emoji = crate::Emoji {
    glyph: "🎹",
    codepoint: "1F3B9",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "musical keyboard",
    group: "Objects",
    subgroup: "musical-instrument",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("klawerbord"),
            keywords: &["instrument", "klavier", "klawerbord", "musiek", "orrel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሙዚቃ ቁልፍ ሰሌዳ"),
            keywords: &["መሣሪያ", "ሙዚቃ", "ቁልፍ ሰሌዳ", "የሙዚቃ ቁልፍ ሰሌዳ", "ፒያኖ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بيانو"),
            keywords: &[
                "بيانو",
                "عزف",
                "لوحة مفاتيح",
                "لوحة مفاتيح موسيقية",
                "موسيقى",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("স\u{9be}ংগীতিক কীব’ৰ\u{9cd}ড"),
            keywords: &[
                "কীব’ৰ\u{9cd}ড",
                "পিয\u{9bc}\u{9be}নো",
                "ব\u{9be}দ\u{9cd}যযন\u{9cd}ত\u{9cd}ৰ",
                "সংগীত",
                "স\u{9be}ংগীতিক কীব’ৰ\u{9cd}ড",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("musiqi klaviaturası"),
            keywords: &[
                "alət",
                "klaviatura",
                "musiqi",
                "musiqi klaviaturası",
                "piano",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("музычная клавіятура"),
            keywords: &[
                "клавішны",
                "клавіятура",
                "музыка",
                "музычная клавіятура",
                "піяніна",
                "інструмент",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Клавиатура на музикален инструмент"),
            keywords: &[
                "Клавиатура на музикален инструмент",
                "инструмент",
                "клавиатура",
                "музика",
                "пиано",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মিউজিক\u{9cd}য\u{9be}ল কীবোর\u{9cd}ড"),
            keywords: &[
                "কীবোর\u{9cd}ড",
                "পিয\u{9bc}\u{9be}নো",
                "মিউজিক\u{9cd}য\u{9be}ল কীবোর\u{9cd}ড",
                "সঙ\u{9cd}গীত",
                "সঙ\u{9cd}গীত যন\u{9cd}ত\u{9cd}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("klavier sonerezh"),
            keywords: &["benveg", "klavier", "sonerezh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("klavijature"),
            keywords: &["instrument", "klavijature", "klavir", "muzika"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("teclat musical"),
            keywords: &["instrument", "música", "piano", "teclat", "teclat musical"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎧᏃᎩᏍᏙᏗ ᏗᏐᏅᏍᏙᏗ"),
            keywords: &[
                "ᏗᎧᏃᎩᏍᎩᏍᏗ",
                "ᏗᎧᏃᎩᏍᏗ",
                "ᏗᎧᏃᎩᏍᏙᏗ ᏗᏐᏅᏍᏙᏗ",
                "ᏗᏐᏅᏍᏙᏗ",
                "ᏗᏐᏅᏍᏙᏗ ᎧᏃᎩᏍᏗ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("klávesy"),
            keywords: &["hudba", "klaviatura", "klávesy", "nástroj", "piano"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("allweddell"),
            keywords: &["allweddell", "cerddoriaeth", "offeryn", "piano"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("klaver"),
            keywords: &[
                "instrument",
                "keyboard",
                "klaver",
                "musik",
                "musikinstrument",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Klaviatur"),
            keywords: &[
                "Instrument",
                "Klaviatur",
                "Musik",
                "Musikinstrument",
                "Tastatur",
                "Tasten",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μουσικό πληκτρολόγιο"),
            keywords: &[
                "κλαβιέ",
                "μουσική",
                "μουσικό πληκτρολόγιο",
                "πιάνο",
                "πλήκτρα",
                "όργανο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("musical keyboard"),
            keywords: &[
                "instrument",
                "keyboard",
                "music",
                "musical keyboard",
                "piano",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &[
                "instrument",
                "keyboard",
                "music",
                "musical keyboard",
                "organ",
                "piano",
            ],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("teclado musical"),
            keywords: &[
                "instrumento",
                "instrumento musical",
                "música",
                "teclado",
                "teclado musical",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("klahvpill"),
            keywords: &["klahvpill", "klaver", "muusika", "pill"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("musika-teklatua"),
            keywords: &["musika", "musika-teklatua", "piano", "tresna"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کیبورد موسیقی"),
            keywords: &["ساز", "موسیقی", "پیانو", "کیبورد"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("koskettimet"),
            keywords: &[
                "instrumentti",
                "koskettimet",
                "musiikki",
                "piano",
                "syntikka",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("keyboard na pangmusika"),
            keywords: &[
                "instrumento",
                "keyboard",
                "keyboard na pangmusika",
                "musika",
                "piano",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("ljómborð"),
            keywords: &["keyboard", "ljómborð", "ljóðføri", "tónleikur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("piano"),
            keywords: &["clavier", "instrument", "musique", "piano"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("pianó"),
            keywords: &["ceol", "méarchlár", "pianó", "uirlis"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("meur-chlàr ciùil"),
            keywords: &[
                "ceòl",
                "clàrsach mòr",
                "inneal-ciùil",
                "ionnsramaid",
                "keyboard",
                "meur-chlàr",
                "meur-chlàr ciùil",
                "piàna",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("teclado musical"),
            keywords: &[
                "instrumento",
                "piano",
                "teclado",
                "teclado musical",
                "órgano",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મ\u{acd}ય\u{ac1}ઝિકલ કીબોર\u{acd}ડ"),
            keywords: &[
                "કી બોર\u{acd}ડ",
                "પિઆનો",
                "મ\u{acd}ય\u{ac1}ઝિકલ કીબોર\u{acd}ડ",
                "વાદ\u{acd}ય",
                "સ\u{a82}ગીત",
                "સ\u{a82}ગીત કી બોર\u{acd}ડ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kibod na kiɗa"),
            keywords: &["kayan kiɗa", "kibod", "kibod na kiɗa", "kiɗa", "piano"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קלידים"),
            keywords: &["אורגן", "כלי נגינה", "מוזיקה", "פסנתר", "קלידים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{902}गीत कीबोर\u{94d}ड"),
            keywords: &[
                "कीबोर\u{94d}ड",
                "पियानो",
                "वाद\u{94d}यय\u{902}त\u{94d}र",
                "स\u{902}गीत कीबोर\u{94d}ड",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("klavijatura"),
            keywords: &["glazba", "instrument", "klavijatura", "klavir"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("zenei billentyűzet"),
            keywords: &[
                "billentyűzet",
                "hangszer",
                "zene",
                "zenei billentyűzet",
                "zongora",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("երաժշտական ստեղնաշար"),
            keywords: &[
                "գործիք",
                "դաշնամուր",
                "երաժշտական ստեղնաշար",
                "երաժշտություն",
                "ստեղնաշար",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("keyboard musik"),
            keywords: &["instrumen", "keyboard", "musik", "piano"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụgbọọtụgwo ụdà-egwu"),
            keywords: &[
                "egwu",
                "ngwaegwu",
                "ube",
                "ụgbọọtụgwo",
                "ụgbọọtụgwo ụdà-egwu",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("píanó"),
            keywords: &["hljómborð", "hljóðfæri", "píanó", "tónlist"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("piano"),
            keywords: &[
                "musica",
                "piano",
                "pianoforte",
                "strumento musicale",
                "tastiera",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("鍵盤"),
            keywords: &["キーボード", "ピアノ", "楽器", "鍵盤", "音楽"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kibor musik"),
            keywords: &["instrumen", "kibor", "musik", "piano"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მუსიკალური კლავიშები"),
            keywords: &[
                "ინსტრუმენტი",
                "კლავიშები",
                "მუსიკა",
                "მუსიკალური კლავიშები",
                "პიანინო",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("музыкалық пернетақта"),
            keywords: &[
                "музыка",
                "музыкалық пернетақта",
                "пернетақта",
                "пианина",
                "құрал",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("klaver"),
            keywords: &[
                "instrument",
                "keyboard",
                "klaver",
                "musik",
                "musikinstrument",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ខ\u{17d2}ទង\u{17cb}ព\u{17d2}យាណ\u{17bc}"),
            keywords: &[
                "ខ\u{17d2}ទង\u{17cb}",
                "ខ\u{17d2}ទង\u{17cb}ព\u{17d2}យាណ\u{17bc}",
                "ព\u{17d2}យាណ\u{17bc}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸಂಗೀತ ಕೀಬೋರ\u{ccd}ಡ\u{ccd}"),
            keywords: &[
                "ಕೀಬೋರ\u{ccd}ಡ\u{ccd}",
                "ವಾದ\u{ccd}",
                "ಸಂಗೀತ",
                "ಸಂಗೀತ ವಾದ\u{ccd}ಯ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("피아노"),
            keywords: &["건반", "악기", "연주", "음악", "피아노"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("स\u{902}गीताचो किबोर\u{94d}ड"),
            keywords: &[
                "किबोर\u{94d}ड",
                "पियानो",
                "वाद\u{94d}य",
                "स\u{902}गीत",
                "स\u{902}गीताचो किबोर\u{94d}ड",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("музыкалык клавиша"),
            keywords: &["аспап", "клавиша", "музыка", "музыкалык клавиша", "пианино"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Keyboard"),
            keywords: &["Instrument", "Keyboard", "Musek", "Piano"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເປຍໂນ"),
            keywords: &[
                "ຄ\u{eb5}ບອດ",
                "ເຄ\u{eb7}\u{ec8}ອງດ\u{ebb}ນຕ\u{eb5}",
                "ເປຍໂນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("muzikos klaviatūra"),
            keywords: &[
                "instrumentas",
                "klaviatūra",
                "muzika",
                "muzikos klaviatūra",
                "pianinas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("klavieru taustiņi"),
            keywords: &[
                "instruments",
                "klaviatūra",
                "klavieres",
                "klavieru taustiņi",
                "mūzika",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("papapurei puoro"),
            keywords: &["papapurei", "piana", "puoro", "whakatangi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("клавијатура"),
            keywords: &["инструмент", "клавијатура", "музика", "пијано"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മ\u{d4d}യ\u{d42}സിക\u{d4d}കൽ കീബോർഡ\u{d4d}"),
            keywords: &[
                "കീബോർഡ\u{d4d}",
                "പിയ\u{d3e}നോ",
                "മ\u{d4d}യ\u{d42}സിക\u{d4d}കൽ കീബോർഡ\u{d4d}",
                "സംഗീതം",
                "സംഗീതോപകരണം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("төгөлдөр хуурын товчлуур"),
            keywords: &[
                "товчлуур",
                "төгөлдөр хуур",
                "төгөлдөр хуурын товчлуур",
                "хөгжим",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{902}गीताचा कीबोर\u{94d}ड"),
            keywords: &[
                "कीबोर\u{94d}ड",
                "पियानो",
                "वाद\u{94d}य",
                "वाद\u{94d}यव\u{943}\u{902}द",
                "स\u{902}गीत",
                "स\u{902}गीताचा कीबोर\u{94d}ड",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("keyboard muzik"),
            keywords: &["instrumen", "keyboard", "muzik", "piano"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("tastiera mużikali"),
            keywords: &[
                "mużika",
                "pjanu",
                "strument",
                "tastiera",
                "tastiera mużikali",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဂ\u{102e}တ က\u{102e}းဘ\u{102f}တ\u{103a}"),
            keywords: &[
                "က\u{102e}းဘ\u{102f}တ\u{103a}",
                "က\u{102e}းဘ\u{102f}တ\u{103a}တ\u{1030}ရ\u{102d}ယာ",
                "ဂ\u{102e}တ က\u{102e}းဘ\u{102f}တ\u{103a}",
                "စန\u{1039}ဒရား",
                "တ\u{1030}ရ\u{102d}ယာ",
                "တေးဂ\u{102e}တ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("piano"),
            keywords: &[
                "instrument",
                "keyboard",
                "musikk",
                "musikkinstrument",
                "piano",
                "tangenter",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("सा\u{902}गीतिक किबोर\u{94d}ड"),
            keywords: &[
                "उपकरण",
                "किबोर\u{94d}ड",
                "पियानो",
                "स\u{902}गीत",
                "सा\u{902}गीतिक किबोर\u{94d}ड",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("piano"),
            keywords: &[
                "instrument",
                "keyboard",
                "muziek",
                "muziekinstrument",
                "piano",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("piano"),
            keywords: &[
                "instrument",
                "keyboard",
                "musikk",
                "musikkinstrument",
                "piano",
                "tangentar",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସଙ\u{b4d}ଗୀତ ସମ\u{b4d}ବନ\u{b4d}ଧୀୟ କୀବୋର\u{b4d}ଡ\u{b4d}\u{200c}"),
            keywords: &[
                "ଉପକରଣ",
                "କୀବୋର\u{b4d}ଡ\u{b4d}",
                "ପ\u{b3f}ଆନୋ",
                "ସଙ\u{b4d}ଗୀତ",
                "ସଙ\u{b4d}ଗୀତ ଭ\u{b3f}ତ\u{b4d}ତ\u{b3f}କ ଉପକରଣ",
                "ସଙ\u{b4d}ଗୀତ ଭ\u{b3f}ତ\u{b4d}ତ\u{b3f}କ କୀବୋର\u{b4d}ଡ\u{b4d}",
                "ସଙ\u{b4d}ଗୀତ ସମ\u{b4d}ବନ\u{b4d}ଧୀୟ କୀବୋର\u{b4d}ଡ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a70}ਗੀਤਕ ਕੀ-ਬ\u{a4b}ਰਡ"),
            keywords: &[
                "ਕੀਬ\u{a4b}ਰਡ",
                "ਪਿਆਨ\u{a4b}",
                "ਸਾਜ\u{a3c}",
                "ਸ\u{a70}ਗੀਤ",
                "ਸ\u{a70}ਗੀਤਕ ਕੀ-ਬ\u{a4b}ਰਡ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("موسیقی دا کلیدی تختہ"),
            keywords: &[
                "آلات",
                "موسیقی",
                "موسیقی دا کلیدی تختہ",
                "پیانو",
                "کلیدی تختہ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Miúzik Kíbọd"),
            keywords: &["Kíbọd", "Miúzik", "Piáno", "Ínstrúmẹnt"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("klawisze"),
            keywords: &[
                "fortepian",
                "instrument",
                "keyboard",
                "klawiatura",
                "klawisze",
                "muzyka",
                "pianino",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د موسیقي کیبورډ"),
            keywords: &["اله", "د موسیقي کیبورډ", "موسيقي", "پيانو", "کيبورډ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("teclado musical"),
            keywords: &[
                "instrumento",
                "instrumento musical",
                "música",
                "piano",
                "teclado",
                "teclado musical",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("teclado musical"),
            keywords: &[
                "instrumento",
                "música",
                "piano",
                "teclado",
                "teclado musical",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("teclas musicales"),
            keywords: &["teclas musicales"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("claviatură muzicală"),
            keywords: &[
                "clape",
                "claviatură muzicală",
                "instrument",
                "muzică",
                "pian",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-377"),
            keywords: &["E10-377"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("клавишные"),
            keywords: &[
                "инструмент",
                "клавиши",
                "клавишные",
                "пианино",
                "синтезатор",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("sentetizeri"),
            keywords: &[
                "igikoresho",
                "mwandikisho",
                "piyano",
                "sentetizeri",
                "umuziki",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("موسيقي وارو ڪيبورڊ"),
            keywords: &["آلو", "موسيقي", "موسيقي وارو ڪيبورڊ", "پيانو", "ڪي بورڊ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සංග\u{dd3}තමය යත\u{dd4}ර\u{dd4} ප\u{dd4}වර\u{dd4}ව"),
            keywords: &[
                "උපකරණය",
                "ප\u{dd2}ය\u{dcf}නෝව",
                "යත\u{dd4}ර\u{dd4} ප\u{dd4}වර\u{dd4}ව",
                "සංග\u{dd3}තමය යත\u{dd4}ර\u{dd4} ප\u{dd4}වර\u{dd4}ව",
                "සංග\u{dd3}තය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("klávesy"),
            keywords: &["hudba", "klavír", "klávesy", "nástroj"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("klaviatura"),
            keywords: &["glasba", "glasbilo", "klaviatura", "klavir"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kiiboodhka muusika"),
            keywords: &[
                "biyaano",
                "kiiboodh",
                "kiiboodhka muusika",
                "muusik",
                "qalab",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("tastierë muzikore"),
            keywords: &[
                "instrument",
                "muzikë",
                "piano",
                "tastierë",
                "tastierë muzikore",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("клавијатура"),
            keywords: &[
                "инструмeнт",
                "клaвиjaтура",
                "клaвир",
                "клавијатура",
                "музика",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("klavijatura"),
            keywords: &["instrument", "klavijatura", "klavir", "muzika"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("klaviatur"),
            keywords: &["klaviatur", "musik", "musikinstrument", "piano"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kinanda"),
            keywords: &["ala", "kinanda", "muziki", "piano"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மியூசிக\u{bcd} க\u{bc0}போர\u{bcd}ட\u{bcd}"),
            keywords: &[
                "இசைக\u{bcd}கருவி",
                "பிய\u{bbe}னோ",
                "மியூசிக\u{bcd} க\u{bc0}போர\u{bcd}ட\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("సంగ\u{c40}త క\u{c40}బ\u{c4b}ర\u{c4d}డ\u{c4d}"),
            keywords: &[
                "క\u{c40}బ\u{c4b}ర\u{c4d}డ\u{c4d}",
                "ప\u{c3f}య\u{c3e}న\u{c4b}",
                "సంగ\u{c40}త క\u{c40}బ\u{c4b}ర\u{c4d}డ\u{c4d}",
                "సంగ\u{c40}త పర\u{c3f}కరం",
                "సంగ\u{c40}తం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("клавиатураи мусиқӣ"),
            keywords: &[
                "асбоб",
                "клавиатура",
                "клавиатураи мусиқӣ",
                "мусиқӣ",
                "пианино",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เป\u{e35}ยโน"),
            keywords: &[
                "ค\u{e35}ย\u{e4c}บอร\u{e4c}ด",
                "เคร\u{e37}\u{e48}องดนตร\u{e35}",
                "เป\u{e35}ยโน",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("saz klawiaturasy"),
            keywords: &[
                "aýdym-saz",
                "instrument",
                "klawiatura",
                "pianino",
                "saz klawiaturasy",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻū kī"),
            keywords: &["ʻū kī"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("müzik klavyesi"),
            keywords: &["alet", "klavye", "müzik", "müzik aleti", "müzik klavyesi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("مۇزىكا تىل تاختىسى"),
            keywords: &["ساز", "مۇزىكا", "مۇزىكا تىل تاختىسى", "پىيانىنو", "چالغۇ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("музична клавіатура"),
            keywords: &[
                "клавіатура",
                "музична клавіатура",
                "музичний",
                "піаніно",
                "інструмент",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("میوزیکل کی بورڈ"),
            keywords: &["آلہ", "موسیقی", "میوزیکل کی بورڈ", "کی بورڈ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("musiqiy klaviatura"),
            keywords: &[
                "asbob",
                "klaviatura",
                "musiqa",
                "musiqiy klaviatura",
                "pianino",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("phím đàn"),
            keywords: &["bàn phím", "nhạc", "nhạc cụ", "phím đàn", "đàn piano"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("klawiyee misik"),
            keywords: &["jumtukaay", "klaawiyee", "klawiyee misik", "misik", "piano"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ikhibhodi yomculo"),
            keywords: &[
                "i-piano",
                "ikhibhodi",
                "ikhibhodi yomculo",
                "isixhobo",
                "umculo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("duuru orin"),
            keywords: &["duuru orin", "dùrù", "ohun èlò", "orin"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("音樂鍵盤"),
            keywords: &["儀器", "鋼琴", "鍵盤", "音樂", "音樂鍵盤"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("音乐键盘"),
            keywords: &["仪器", "钢琴", "键盘", "音乐", "音乐键盘"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("音乐键盘"),
            keywords: &["乐器", "弹奏", "演奏", "钢琴", "音乐", "音乐键盘"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("鋼琴"),
            keywords: &["樂器", "鋼琴", "電子琴"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ikhibhodi yomculo"),
            keywords: &[
                "ikhibhodi",
                "ikhibhodi yomculo",
                "insimbi",
                "umculo",
                "uphiyano",
            ],
        },
    ],
};
#[doc = "🎺"]
pub const TRUMPET: crate::Emoji = crate::Emoji {
    glyph: "🎺",
    codepoint: "1F3BA",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "trumpet",
    group: "Objects",
    subgroup: "musical-instrument",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("trompet"),
            keywords: &["blaas", "instrument", "musiek", "trompet"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ትራምፔት"),
            keywords: &["መሣሪያ", "ሙዚቃ", "ትራምፔት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("آلة نفخ"),
            keywords: &["آلة موسيقية", "آلة نفخ", "ترومبت", "عزف", "موسيقى"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("শিঙ\u{9be}"),
            keywords: &["ব\u{9be}দ\u{9cd}যযন\u{9cd}ত\u{9cd}ৰ", "শিঙ\u{9be}", "সংগীত"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("şeypur"),
            keywords: &["alət", "musiqi", "şeypur"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("труба"),
            keywords: &["духавы", "музыка", "музычны", "труба", "інструмент"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("тромпет"),
            keywords: &["инструмент", "музика", "тромпет"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ভে\u{981}প\u{9c1}"),
            keywords: &[
                "ভে\u{981}প\u{9c1}",
                "সঙ\u{9cd}গীত",
                "সঙ\u{9cd}গীত যন\u{9cd}ত\u{9cd}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("trompilh"),
            keywords: &["benveg", "sonerezh", "trompilh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("truba"),
            keywords: &["instrument", "muzika", "truba"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("trompeta"),
            keywords: &["instrument", "música", "trompeta", "vent"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏢᏇᏘ"),
            keywords: &["ᏗᎧᏃᎩᏍᏗ", "ᏗᎧᏃᎩᏍᏙᏗ", "ᏢᏇᏘ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("trubka"),
            keywords: &["hudba", "nástroj", "trubka", "trumpeta"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("trwmped"),
            keywords: &["cerddoriaeth", "offeryn", "trwmped"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("trompet"),
            keywords: &["instrument", "musik", "musikinstrument", "trompet"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Trompete"),
            keywords: &["Instrument", "Musik", "Musikinstrument", "Trompete"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τρομπέτα"),
            keywords: &["μουσική", "τρομπέτα", "όργανο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("trumpet"),
            keywords: &["instrument", "music", "trumpet"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("trompeta"),
            keywords: &["instrumento", "instrumento musical", "música", "trompeta"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["instrumento", "música", "trompeta"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("trompet"),
            keywords: &["muusika", "pill", "trompet"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("tronpeta"),
            keywords: &["musika", "tresna", "tronpeta"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ترومپت"),
            keywords: &["بادی برنجی", "ترومپت", "ساز", "ساکسیفون", "موسیقی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("trumpetti"),
            keywords: &["instrumentti", "musiikki", "torvi", "trumpetti"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("trumpeta"),
            keywords: &["instrumento", "musika", "trumpeta"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("trompet"),
            keywords: &["ljóðføri", "trompet", "tónleikur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("trompette"),
            keywords: &["instrument", "musique", "trompette"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("trumpa"),
            keywords: &["ceol", "trumpa", "uirlis"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("trombaid"),
            keywords: &["ceòl", "inneal-ciùil", "ionnsramaid", "trombaid"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("trompeta"),
            keywords: &["instrumento", "trompeta"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ત\u{ac1}રાઈ"),
            keywords: &["ત\u{ac1}રાઈ", "વાદ\u{acd}ય", "સ\u{a82}ગીત"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kakaki"),
            keywords: &["kakaki", "kayan kiɗa", "kiɗa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חצוצרה"),
            keywords: &["חצוצרה", "כלי נגינה", "מוזיקה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("त\u{941}रही"),
            keywords: &["त\u{941}रही", "वाद\u{94d}यय\u{902}त\u{94d}र", "स\u{902}गीत"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("truba"),
            keywords: &["glazba", "instrument", "truba"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("trombita"),
            keywords: &["hangszer", "trombita", "zene"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("շեփոր"),
            keywords: &["գործիք", "երաժշտություն", "շեփոր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("trompet"),
            keywords: &["instrumen", "musik", "trompet"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("òpì ike"),
            keywords: &["egwu", "ngwaegwu", "òpì ike"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("trompet"),
            keywords: &["hljóðfæri", "trompet", "tónlist"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("tromba"),
            keywords: &["musica", "strumento", "strumento musicale", "tromba"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("トランペット"),
            keywords: &["トランペット", "ラッパ", "楽器", "音楽"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("trompet"),
            keywords: &["instrumen", "musik", "trompet"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("საყვირი"),
            keywords: &["ინსტრუმენტი", "მუსიკა", "საყვირი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("труба"),
            keywords: &["музыка", "труба", "құрал"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("trompet"),
            keywords: &["instrument", "musik", "musikinstrument", "trompet"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ត\u{17d2}រ\u{17bb}\u{17c6}ប\u{17c9}ែត"),
            keywords: &["ត\u{17d2}រ\u{17bb}\u{17c6}ប\u{17c9}ែត", "ត\u{17d2}រែ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸಂಗೀತ ವಾದ\u{ccd}ಯ"),
            keywords: &["ವಾದ\u{ccd}ಯ", "ಸಂಗೀತ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("트럼펫"),
            keywords: &["악기", "연주", "음악", "트럼펫"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ट\u{94d}रम\u{94d}प\u{947}ट"),
            keywords: &["ट\u{94d}रम\u{94d}प\u{947}ट", "वाद\u{94d}य", "स\u{902}गीत"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("сурнай"),
            keywords: &["аспап", "музыка", "сурнай"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Trompett"),
            keywords: &["Instrument", "Musek", "Trompett"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແຕ"),
            keywords: &["ເຄ\u{eb7}\u{ec8}ອງດ\u{ebb}ນຕ\u{eb5}", "ແຕ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("trimitas"),
            keywords: &["instrumentas", "muzika", "trimitas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("trompete"),
            keywords: &["instruments", "mūzika", "taure", "trompete"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pūawanui"),
            keywords: &["puoro", "pūawanui", "whakatangi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("труба"),
            keywords: &["инструмент", "музика", "труба"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ട\u{d4d}രംപറ\u{d4d}റ\u{d4d}"),
            keywords: &[
                "ക\u{d3e}ഹളം",
                "കീബോർഡ\u{d4d}",
                "ട\u{d4d}രംപറ\u{d4d}റ\u{d4d}",
                "ട\u{d4d}രമ\u{d4d}പറ\u{d4d}റ\u{d4d}",
                "സംഗീതം",
                "സംഗീതോപകരണം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эвэр бүрээ"),
            keywords: &["хөгжим", "эвэр бүрээ"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ट\u{94d}र\u{945}म\u{94d}फ\u{947}ट"),
            keywords: &[
                "ट\u{94d}र\u{902}प\u{947}ट",
                "ट\u{94d}र\u{945}म\u{94d}फ\u{947}ट",
                "रणशि\u{902}ग",
                "वाद\u{94d}यव\u{943}\u{902}द",
                "स\u{902}गीत",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("trompet"),
            keywords: &["alat", "muzik", "trompet"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("trumbetta"),
            keywords: &["mużika", "strument", "trumbetta"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ခရာ"),
            keywords: &["ခရာ", "တ\u{1030}ရ\u{102d}ယာ", "တေးဂ\u{102e}တ"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("trompet"),
            keywords: &["instrument", "musikk", "musikkinstrument", "trompet"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ट\u{94d}रम\u{94d}प\u{947}ट"),
            keywords: &["उपकरण", "ट\u{94d}रम\u{94d}प\u{947}ट", "स\u{902}गीत"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("trompet"),
            keywords: &["instrument", "muziek", "trompet"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("trompet"),
            keywords: &["instrument", "musikk", "musikkinstrument", "trompet"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ତ\u{b41}ରୀ"),
            keywords: &[
                "ଉପକରଣ",
                "ତ\u{b41}ରୀ",
                "ସଙ\u{b4d}ଗୀତ",
                "ସଙ\u{b4d}ଗୀତ ଭ\u{b3f}ତ\u{b4d}ତ\u{b3f}କ ଉପକରଣ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬਿਗਲ"),
            keywords: &["ਬਿਗਲ", "ਸਾਜ\u{a3c}", "ਸ\u{a70}ਗੀਤ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("شہناہی"),
            keywords: &["آلات", "شہناہی", "موسیقی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Trọ\u{301}mpẹt"),
            keywords: &["Miúzik", "Trọ\u{301}mpẹt", "Ínstrúmẹnt"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("trąbka"),
            keywords: &["instrument", "muzyka", "trąbka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سورنی"),
            keywords: &["اله", "سورنی", "موسيقي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("trompete"),
            keywords: &["instrumento", "instrumento musical", "música", "trompete"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["instrumento", "música", "trompete"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("trompeta"),
            keywords: &["trompeta"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("trompetă"),
            keywords: &["instrument", "muzică", "trompetă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-378"),
            keywords: &["E10-378"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("труба"),
            keywords: &[
                "духовой инструмент",
                "инструмент",
                "музыка",
                "музыкальный инструмент",
                "труба",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umuduri"),
            keywords: &["igikoresho", "umuduri", "umuziki"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ترم"),
            keywords: &["آلو", "ترم", "موسيقي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ට\u{dca}\u{200d}රම\u{dca}පට\u{dca}"),
            keywords: &[
                "උපකරණය",
                "ට\u{dca}\u{200d}රම\u{dca}පට\u{dca}",
                "සංග\u{dd3}තය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("trúbka"),
            keywords: &["hudba", "nástroj", "trúbka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("trobenta"),
            keywords: &["glasba", "glasbilo", "trobenta"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("fuugwo"),
            keywords: &["fuugwo", "muusik", "qalab"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("trombë"),
            keywords: &["instrument", "muzikë", "trombë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("труба"),
            keywords: &["инструмeнт", "музика", "труба"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("truba"),
            keywords: &["instrument", "muzika", "truba"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("trumpet"),
            keywords: &["musik", "musikinstrument", "trumpet"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("tarumbeta"),
            keywords: &["ala", "muziki", "tarumbeta"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("டிரம\u{bcd}பட\u{bcd}"),
            keywords: &[
                "இசைக\u{bcd}கருவி",
                "ஊதுகொம\u{bcd}பு",
                "டிரம\u{bcd}பட\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ట\u{c4d}రంప\u{c46}ట\u{c4d}"),
            keywords: &[
                "క\u{c4a}మ\u{c4d}ము",
                "ట\u{c4d}రంప\u{c46}ట\u{c4d}",
                "బ\u{c3e}క\u{c3e}",
                "బూర",
                "సంగ\u{c40}త పర\u{c3f}కరం",
                "సంగ\u{c40}తం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("карнай"),
            keywords: &["асбоб", "карнай", "мусиқӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ทร\u{e31}มเป\u{e47}ต"),
            keywords: &["ทร\u{e31}มเป\u{e47}ต", "เคร\u{e37}\u{e48}องดนตร\u{e35}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("surnaý"),
            keywords: &["aýdym-saz", "instrument", "surnaý"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻaifi"),
            keywords: &["meʻaifi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("trompet"),
            keywords: &["alet", "müzik", "müzik aleti", "trompet"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سۇناي"),
            keywords: &["ساز", "ساكس", "سۇناي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("труба"),
            keywords: &["музичний", "труба", "інструмент"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ٹرمپٹ"),
            keywords: &["آلہ", "موسیقی", "ٹرمپٹ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("truba"),
            keywords: &["asbob", "musiqa", "truba"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("kèn trumpet"),
            keywords: &["kèn trumpet", "nhạc", "nhạc cụ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("trompet"),
            keywords: &["jumtukaay", "misik", "trompet"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ixolongo"),
            keywords: &["isixhobo", "ixolongo", "umculo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("kakaaki"),
            keywords: &["irinṣẹ\u{301}", "kakaaki", "orin"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("喇叭"),
            keywords: &["儀器", "喇叭", "音樂"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("喇叭"),
            keywords: &["仪器", "喇叭", "音乐"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("小号"),
            keywords: &["乐器", "吹奏", "喇叭", "小号", "音乐"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("小號"),
            keywords: &["小號", "樂器"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("icilongo"),
            keywords: &["icilongo", "insimbi", "umculo"],
        },
    ],
};
#[doc = "🎻"]
pub const VIOLIN: crate::Emoji = crate::Emoji {
    glyph: "🎻",
    codepoint: "1F3BB",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "violin",
    group: "Objects",
    subgroup: "musical-instrument",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("viool"),
            keywords: &["instrument", "musiek", "stryk", "viool"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቫዮሊን"),
            keywords: &["መሣሪያ", "ሙዚቃ", "ቫዮሊን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كمان"),
            keywords: &["آلة موسيقية", "عزف", "كمان", "موسيقى"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বেহেল\u{9be}"),
            keywords: &[
                "ব\u{9be}দ\u{9cd}যযন\u{9cd}ত\u{9cd}ৰ",
                "বেহেল\u{9be}",
                "সংগীত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("skripka"),
            keywords: &["alət", "musiqi", "skripka"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("скрыпка"),
            keywords: &["музыка", "музычны", "скрыпка", "смычковы", "інструмент"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("цигулка"),
            keywords: &["инструмент", "музика", "цигулка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বেহ\u{9be}ল\u{9be}"),
            keywords: &[
                "বেহ\u{9be}ল\u{9be}",
                "সঙ\u{9cd}গীত",
                "সঙ\u{9cd}গীত যন\u{9cd}ত\u{9cd}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("violoñs"),
            keywords: &["benveg", "biolin", "sonerezh", "violoñs"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("violina"),
            keywords: &["instrument", "muzika", "violina"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("violí"),
            keywords: &["corda", "instrument", "música", "violí"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏰᏟᏰᏗ"),
            keywords: &["ᎠᏰᏟᏰᏗ", "ᏗᎧᏃᎩᏍᏗ", "ᏗᎧᏃᎩᏍᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("housle"),
            keywords: &["housle", "hudba", "nástroj"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ffidl"),
            keywords: &["cerddoriaeth", "ffidl", "offeryn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("violin"),
            keywords: &[
                "instrument",
                "musik",
                "musikinstrument",
                "strengeinstrument",
                "violin",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Geige"),
            keywords: &["Geige", "Instrument", "Musik", "Musikinstrument"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("βιολί"),
            keywords: &["βιολί", "μουσική", "όργανο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("violin"),
            keywords: &["instrument", "music", "violin"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("violín"),
            keywords: &["instrumento", "instrumento musical", "música", "violín"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["instrumento", "música", "violín"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("viiul"),
            keywords: &["muusika", "pill", "viiul"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("biolina"),
            keywords: &["biolina", "musika", "tresna"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ویولن"),
            keywords: &["ساز", "موسیقی", "ویولن"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("viulu"),
            keywords: &["instrumentti", "jousi", "musiikki", "viulu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("biyulin"),
            keywords: &["biyulin", "instrumento", "musika"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("violin"),
            keywords: &["ljóðføri", "tónleikur", "violin"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("violon"),
            keywords: &["instrument", "musique", "violon"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("veidhlín"),
            keywords: &["ceol", "fidil", "uirlis", "veidhlín"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("fìdheall"),
            keywords: &["ceòl", "fìdheall", "inneal-ciùil", "ionnsramaid"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("violín"),
            keywords: &["instrumento", "violín"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વાયોલિન"),
            keywords: &["વાદ\u{acd}ય", "વાયોલિન", "સ\u{a82}ગીત"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("goge"),
            keywords: &["goge", "kayan kiɗa", "kiɗa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כינור"),
            keywords: &["כינור", "כלי נגינה", "מוזיקה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("वायलिन"),
            keywords: &["वाद\u{94d}यय\u{902}त\u{94d}र", "वायलिन", "स\u{902}गीत"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("violina"),
            keywords: &["glazba", "instrument", "violina"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("hegedű"),
            keywords: &["hangszer", "hegedű", "zene"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ջութակ"),
            keywords: &["գործիք", "երաժշտություն", "ջութակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("biola"),
            keywords: &["biola", "instrumen", "musik"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụbọ nta"),
            keywords: &["egwu", "ngwaegwu", "ụbọ nta"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fiðla"),
            keywords: &["fiðla", "hljóðfæri", "tónlist"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("violino"),
            keywords: &["musica", "strumento", "strumento musicale", "violino"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("バイオリン"),
            keywords: &["バイオリン", "ヴィオラ", "楽器", "音楽"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("biola"),
            keywords: &["biola", "instrumen", "musik"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ვიოლინო"),
            keywords: &["ვიოლინო", "ინსტრუმენტი", "მუსიკა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("скрипка"),
            keywords: &["музыка", "скрипка", "құрал"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("violin"),
            keywords: &[
                "instrument",
                "musik",
                "musikinstrument",
                "strengeinstrument",
                "violin",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("វ\u{17b8}យ\u{17bc}ឡ\u{17bb}ង"),
            keywords: &["ក\u{17bc}ត", "វ\u{17b8}យ\u{17bc}ឡ\u{17bb}ង"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪ\u{cbf}ಟೀಲು"),
            keywords: &["ಪ\u{cbf}ಟೀಲು", "ವಾದ\u{ccd}ಯ", "ಸಂಗೀತ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("바이올린"),
            keywords: &["바이올린", "악기", "연주", "음악"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("वायोलिन"),
            keywords: &["वाद\u{94d}य", "वायोलिन", "स\u{902}गीत"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("скрипка"),
            keywords: &["аспап", "музыка", "скрипка"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Gei"),
            keywords: &["Gei", "Instrument", "Musek"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໄວໂອລ\u{eb4}ນ"),
            keywords: &["ເຄ\u{eb7}\u{ec8}ອງດ\u{ebb}ນຕ\u{eb5}", "ໄວໂອລ\u{eb4}ນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("smuikas"),
            keywords: &["instrumentas", "muzika", "smuikas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vijole"),
            keywords: &["instruments", "mūzika", "vijole"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tōiri"),
            keywords: &["puoro", "tōiri", "whakatangi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("виолина"),
            keywords: &["виолина", "инструмент", "музика"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വയലിൻ"),
            keywords: &["കീബോർഡ\u{d4d}", "വയലിൻ", "സംഗീതം", "സംഗീതോപകരണം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хийл"),
            keywords: &["хийл", "хөгжим"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("व\u{94d}हायोलिन"),
            keywords: &[
                "वाद\u{94d}यव\u{943}\u{902}द",
                "वॉयोलिन",
                "व\u{94d}हायोलिन",
                "स\u{902}गीत",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("biola"),
            keywords: &["alat", "biola", "muzik"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("vjolin"),
            keywords: &["mużika", "strument", "vjolin"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တယော"),
            keywords: &["တယော", "တ\u{1030}ရ\u{102d}ယာ", "တေးဂ\u{102e}တ"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("fiolin"),
            keywords: &["fele", "fiolin", "instrument", "musikk", "musikkinstrument"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("भायोलिन"),
            keywords: &["उपकरण", "भायोलिन", "स\u{902}गीत"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("viool"),
            keywords: &["instrument", "muziek", "viool"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("fiolin"),
            keywords: &["fele", "fiolin", "instrument", "musikk", "musikkinstrument"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଭ\u{b3e}ଓଲ\u{b3f}ନ\u{b4d}"),
            keywords: &[
                "ଉପକରଣ",
                "ବେହେଲ\u{b3e}",
                "ଭ\u{b3e}ଓଲ\u{b3f}ନ\u{b4d}",
                "ସଙ\u{b4d}ଗୀତ",
                "ସଙ\u{b4d}ଗୀତ ଭ\u{b3f}ତ\u{b4d}ତ\u{b3f}କ ଉପକରଣ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਵਾਇਲਨ"),
            keywords: &["ਵਾਇਲਨ", "ਸਾਜ\u{a3c}", "ਸ\u{a70}ਗੀਤ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("وائلن"),
            keywords: &["آلات", "موسیقی", "وائلن"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Vayọlin"),
            keywords: &["Miúzik", "Vayọlin", "Ínstrúmẹnt"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("skrzypce"),
            keywords: &[
                "altówka",
                "instrument",
                "muzyczny",
                "skrzypce",
                "smyczek",
                "strunowy",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ويلون"),
            keywords: &["اله", "موسيقي", "ويلون"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("violino"),
            keywords: &["instrumento", "instrumento musical", "música", "violino"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["instrumento", "música", "violino"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("violin"),
            keywords: &["violin"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("vioară"),
            keywords: &["instrument", "muzică", "vioară"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-379"),
            keywords: &["E10-379"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("скрипка"),
            keywords: &[
                "инструмент",
                "музыка",
                "скрипка",
                "смычок",
                "струнный инструмент",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("inanga"),
            keywords: &["igikoresho", "inanga", "umuziki"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("وائلن"),
            keywords: &["آلو", "موسيقي", "وائلن"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වයල\u{dd3}නය"),
            keywords: &["උපකරණය", "වයල\u{dd3}නය", "සංග\u{dd3}තය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("husle"),
            keywords: &["hudba", "husle", "nástroj"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("violina"),
            keywords: &["glasba", "glasbilo", "violina"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("seese"),
            keywords: &["muusik", "qalab", "seese"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("violinë"),
            keywords: &["instrument", "muzikë", "violinë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("виолина"),
            keywords: &["виолина", "инструмeнт", "музика"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("violina"),
            keywords: &["instrument", "muzika", "violina"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("fiol"),
            keywords: &["fiol", "musik", "musikinstrument", "violin"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("fidla"),
            keywords: &["ala", "fidla", "muziki"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வயலின\u{bcd}"),
            keywords: &["இசைக\u{bcd}கருவி", "வயலின\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వయ\u{c4b}ల\u{c3f}న\u{c4d}"),
            keywords: &[
                "వయ\u{c4a}ల\u{c3f}న\u{c4d}",
                "వయ\u{c4b}ల\u{c3f}న\u{c4d}",
                "సంగ\u{c40}త పర\u{c3f}కరం",
                "సంగ\u{c40}తం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ғиҷҷак"),
            keywords: &["асбоб", "мусиқӣ", "ғиҷҷак"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ไวโอล\u{e34}น"),
            keywords: &["เคร\u{e37}\u{e48}องดนตร\u{e35}", "ไวโอล\u{e34}น"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("skripka"),
            keywords: &["aýdym-saz", "instrument", "skripka"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("vaiolini"),
            keywords: &["vaiolini"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("keman"),
            keywords: &["alet", "keman", "müzik", "müzik aleti"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئىسكىرىپكا"),
            keywords: &["ئىسكىرىپكا", "ساز", "ساكس"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("скрипка"),
            keywords: &["музичний", "скрипка", "інструмент"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("وائلن"),
            keywords: &["آلہ", "موسیقی", "وائلن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("skripka"),
            keywords: &["asbob", "musiqa", "skripka"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đàn violin"),
            keywords: &["nhạc", "nhạc cụ", "đàn violin"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("violon"),
            keywords: &["jumtukaay", "misik", "violon"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-violin"),
            keywords: &["i-violin", "isixhobo", "umculo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("faolini"),
            keywords: &["faolini", "irinṣẹ\u{301}", "orin"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("小提琴"),
            keywords: &["儀器", "小提琴", "音樂"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("小提琴"),
            keywords: &["仪器", "小提琴", "音乐"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("小提琴"),
            keywords: &["乐器", "小提琴", "提琴", "演奏", "音乐"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("小提琴"),
            keywords: &["小提琴", "樂器"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ivayolini"),
            keywords: &["insimbi", "ivayolini", "umculo"],
        },
    ],
};
#[doc = "🪕"]
pub const BANJO: crate::Emoji = crate::Emoji {
    glyph: "🪕",
    codepoint: "1FA95",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "banjo",
    group: "Objects",
    subgroup: "musical-instrument",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("banjo"),
            keywords: &["banjo", "musiek", "snaarinstrument"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ባንጆ"),
            keywords: &["ሙዚቃ", "ባለ ጭራ", "ባንጆ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("آلة بانجو"),
            keywords: &["آلة بانجو", "موسيقى", "وتريات"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ব\u{9be}ঞ\u{9cd}জো"),
            keywords: &[
                "ত\u{9be}\u{981}ৰ লগোৱ\u{9be} ব\u{9be}দ\u{9cd}যযন\u{9cd}ত\u{9cd}ৰ",
                "ব\u{9be}ঞ\u{9cd}জো",
                "সংগীত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("banco"),
            keywords: &["banco", "musiqi", "simli alət"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("банджа"),
            keywords: &["банджа", "музыка", "струнныя"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("банджо"),
            keywords: &["банджо", "музика", "струни"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9cd}য\u{9be}ঞ\u{9cd}জো"),
            keywords: &[
                "ত\u{9be}রয\u{9c1}ক\u{9cd}ত",
                "ব\u{9cd}য\u{9be}ঞ\u{9cd}জো",
                "সঙ\u{9cd}গীত",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("banjo"),
            keywords: &["banjo", "benveg", "sonerezh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("bendžo"),
            keywords: &["bendžo", "muzika", "žičani instrument"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("banjo"),
            keywords: &["banjo", "corda", "música"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᏍᏗ ᏗᎧᏃᎩᏍᏗ"),
            keywords: &["ᎠᏍᏗ", "ᏗᎧᏃᎩᏍᏗ", "ᏗᏍᏗ ᏗᎧᏃᎩᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("banjo"),
            keywords: &["banjo", "bendžo", "hudba", "nástroj", "strunný"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("banjo"),
            keywords: &["banjo", "cerddoriaeth", "llinynnau"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("banjo"),
            keywords: &["banjo", "musik", "strengeinstrument"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Banjo"),
            keywords: &["Banjo", "Musik", "Streichinstrument"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μπάντζο"),
            keywords: &["έγχορδο", "μουσική", "μπάντζο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("banjo"),
            keywords: &["banjo", "music", "stringed"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("banjo"),
            keywords: &["banjo", "banyo", "cuerda", "instrumento", "música"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("bandžo"),
            keywords: &["bandžo", "keelpill", "muusika"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("banjoa"),
            keywords: &["banjoa", "hari-instrumentu", "musika"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بانجو"),
            keywords: &["بانجو", "ساز زهی", "موسیقی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("banjo"),
            keywords: &["banjo", "kielisoitin", "musiikki"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("banjo"),
            keywords: &["banjo", "musika", "stringed"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("banjo"),
            keywords: &["banjo", "ljóðføri", "tónleikur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("banjo"),
            keywords: &["banjo", "cordes", "instrument à cordes", "musique"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["banjo", "cordes", "instrument", "musique"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bainseó"),
            keywords: &["bainseó", "ceol", "téadach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bainsio"),
            keywords: &["bainsio", "ceòl", "teud", "teudan"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("banxo"),
            keywords: &["banxo", "de corda", "instrumento", "música"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બ\u{ac7}ન\u{acd}જો"),
            keywords: &[
                "બ\u{ac7}ન\u{acd}જો",
                "વાદ\u{acd}યય\u{a82}ત\u{acd}રના તાર",
                "સ\u{a82}ગીત",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("בנג׳ו"),
            keywords: &["בנג׳ו", "כלי מיתרים", "כלי נגינה", "מוזיקה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ब\u{948}\u{902}जो"),
            keywords: &["गिटार", "ब\u{948}\u{902}जो", "वाद\u{94d}य", "स\u{902}गीत"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("bendžo"),
            keywords: &["bendžo", "glazba", "žičani instrument"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("bendzsó"),
            keywords: &["bendzsó", "húros", "zene"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բանջո"),
            keywords: &["բանջո", "երաժշտություն", "լարային"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("banjo"),
            keywords: &["banjo", "musik", "senar"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("banjó"),
            keywords: &["banjó", "strengir", "strengjahljóðfæri", "tónlist"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("banjo"),
            keywords: &["banjo", "musica", "strumento a corde"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("バンジョー"),
            keywords: &["バンジョー", "楽器", "音楽"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("gitar banjo"),
            keywords: &["dawai", "gitar banjo", "musik"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბანჯო"),
            keywords: &["ბანჯო", "მუსიკა", "სიმები"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("банджо"),
            keywords: &["банджо", "музыка", "ішекті"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បានច\u{17bc}"),
            keywords: &[
                "តន\u{17d2}ត\u{17d2}រ\u{17b8}",
                "បានច\u{17bc}",
                "មានខ\u{17d2}សែ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬಂಜೋ"),
            keywords: &["ತಂತ\u{cbf} ಹೊಂದ\u{cbf}ರುವುದು", "ಬಂಜೋ", "ಸಂಗೀತ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("밴조"),
            keywords: &["밴조", "음악", "현악기"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ब\u{901}जो"),
            keywords: &["धाग\u{947}", "ब\u{901}जो", "स\u{902}गीत"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("банжо"),
            keywords: &["банжо", "кылдуу", "музыка"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແບນ\u{200b}ໂຈ"),
            keywords: &[
                "ເຄ\u{eb7}\u{ec8}\u{200b}ອງ\u{200b}ດ\u{ebb}ນ\u{200b}ຕ\u{eb5}",
                "ແບນ\u{200b}ໂຈ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("bandža"),
            keywords: &["bandža", "muzika", "styginis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("bandžo"),
            keywords: &["bandžo", "mūzika", "stīgu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("бенџо"),
            keywords: &["бенџо", "музика"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ബ\u{d3e}ഞ\u{d4d}ചോ"),
            keywords: &[
                "തന\u{d4d}ത\u{d4d}രികൾ ഉള\u{d4d}ളത\u{d4d}",
                "ബ\u{d3e}ഞ\u{d4d}ചോ",
                "മ\u{d4d}യ\u{d42}സിക\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("банжо"),
            keywords: &["банжо", "хөгжим", "чавхдас"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ब\u{901}जो"),
            keywords: &["त\u{902}त\u{942}वाद\u{94d}य", "ब\u{901}जो", "स\u{902}गीत"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("banjo"),
            keywords: &["banjo", "bertali", "muzik"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဘင\u{103a}ဂျ\u{102d}\u{102f}"),
            keywords: &[
                "ကြ\u{102d}\u{102f}းတပ\u{103a}",
                "တေးဂ\u{102e}တ",
                "ဘင\u{103a}ဂျ\u{102d}\u{102f}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("banjo"),
            keywords: &["banjo", "musikk", "strenginstrument"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बान\u{94d}जो"),
            keywords: &["तार भएको", "बान\u{94d}जो", "स\u{902}गीत"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("banjo"),
            keywords: &["banjo", "besnaard", "muziek"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("banjo"),
            keywords: &["banjo", "musikk", "strenginstrument"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବେଞ\u{b4d}ଜୋ"),
            keywords: &[
                "ବେଞ\u{b4d}ଜୋ",
                "ଷ\u{b4d}ଟ\u{b4d}ର\u{b3f}ଙ\u{b4d}ଗଡ\u{b4d}\u{200c}",
                "ସଙ\u{b4d}ଗୀତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a48}\u{a02}ਜ\u{a4b}"),
            keywords: &["ਬ\u{a48}\u{a02}ਜ\u{a4b}", "ਸ\u{a70}ਗੀਤ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Banjó"),
            keywords: &["Banjó", "Miúzik", "String-dẹm"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("banjo"),
            keywords: &["banjo", "instrument", "muzyka", "strunowy"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بينجو"),
            keywords: &["بينجو", "مزي شوې", "موزيک"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("banjo"),
            keywords: &["banjo", "cordas", "música"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["banjo"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("banjo"),
            keywords: &["banjo", "coarde", "muzică"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–074"),
            keywords: &["E12–074"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("банджо"),
            keywords: &[
                "банджо",
                "гитара",
                "играть",
                "инструмент",
                "музыка",
                "струнный",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بانجو"),
            keywords: &["اسٽرنگڊ", "بانجو", "موسيقي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බන\u{dca}ජෝ"),
            keywords: &[
                "තන\u{dca}ත\u{dca}\u{200d}ර\u{dd2}ය",
                "බන\u{dca}ජෝ",
                "සංග\u{dd3}තය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("bendžo"),
            keywords: &["banjo", "bendžo", "hudba", "nástroj", "strunový"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("bendžo"),
            keywords: &["bendžo", "brenkalo", "glasba", "glasbilo", "strune"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gitaar nooc mareykan ah"),
            keywords: &["gitaar ah", "gitaar nooc mareykan ah", "muusik"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("banxho"),
            keywords: &["banxho", "instrument me tela", "muzikë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("бенџо"),
            keywords: &["бенџо", "жице", "музика"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("bendžo"),
            keywords: &["bendžo", "muzika", "žice"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("banjo"),
            keywords: &["banjo", "musik", "sträng"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("gambusi"),
            keywords: &["gambusi", "muziki", "nyuzi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ப\u{bbe}ஞ\u{bcd}சோ"),
            keywords: &[
                "இசை",
                "ஐந\u{bcd}து நரம\u{bcd}புக\u{bcd} கருவி",
                "ப\u{bbe}ஞ\u{bcd}சோ",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బ\u{c3e}ంజ\u{c4b}"),
            keywords: &["త\u{c40}గలు", "బ\u{c3e}ంజ\u{c4b}", "సంగ\u{c40}తం"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แบนโจ"),
            keywords: &["สตร\u{e34}ง", "เพลง", "แบนโจ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("banjo"),
            keywords: &["banjo", "kirişli", "saz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("penisiō"),
            keywords: &["penisiō"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("banjo"),
            keywords: &["banjo", "müzik", "yaylı"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("банджо"),
            keywords: &["банджо", "музичний", "струнний", "щипковий", "інструмент"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بینجو"),
            keywords: &["بینجو", "تاروں والا آلہ", "موسیقی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("banjo"),
            keywords: &["banjo", "musiqa", "tor", "torli musiqa asbobi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đàn banjo"),
            keywords: &["có dây", "âm nhạc", "đàn banjo"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("班卓琴"),
            keywords: &["弦線", "班卓琴", "音樂"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("班卓琴"),
            keywords: &["弦线", "班卓琴", "音乐"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("班卓琴"),
            keywords: &["弦乐器", "弹奏", "班卓琴", "音乐"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("斑鳩琴"),
            keywords: &["弦樂器", "斑鳩琴", "音樂"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("班卓琴"),
            keywords: &["弦樂器", "班卓琴", "音樂"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-banjo"),
            keywords: &["i-banjo", "uchungechunge", "umculo"],
        },
    ],
};
#[doc = "🥁"]
pub const DRUM: crate::Emoji = crate::Emoji {
    glyph: "🥁",
    codepoint: "1F941",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "drum",
    group: "Objects",
    subgroup: "musical-instrument",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("trom"),
            keywords: &["musiek", "trom", "tromme"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ከበሮ"),
            keywords: &["ሙዚቃ", "ከበሮ", "የከበሮ እንጨት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("طبلة"),
            keywords: &["طبلة", "عصا الطبلة", "موسيقى"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ঢোল"),
            keywords: &["ঢোল", "ঢোলৰ ম\u{9be}ৰি", "সংগীত"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("davul"),
            keywords: &["davul", "dəf", "nağara"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("барабан"),
            keywords: &["барабан", "музыка", "палачкі"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("барабан"),
            keywords: &["барабан", "музика", "пръчки"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ড\u{9cd}র\u{9be}ম"),
            keywords: &["ড\u{9cd}র\u{9be}ম", "ড\u{9cd}র\u{9be}মস\u{9cd}টিক", "সংগীত"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("taboulin"),
            keywords: &["benveg", "sonerezh", "taboulin", "toumperezh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("bubanj"),
            keywords: &["bubanj", "muzika", "palice"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("tambor"),
            keywords: &["baquetes", "música", "tambor", "timbal"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄓\u{11133}𑄢𑄟\u{11134}"),
            keywords: &["𑄓\u{11133}𑄢𑄟\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎱᎵ"),
            keywords: &["ᎱᎵ", "ᎱᎵ ᎦᎸᏂᏍᏙᏗ", "ᏗᎧᏃᎩᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("buben"),
            keywords: &["buben", "bubenické", "hudba", "paličky"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("drwm"),
            keywords: &["cerddoriaeth", "drwm", "ffyn curo"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("tromme"),
            keywords: &["musik", "rytme", "tromme", "trommestikker"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Trommel"),
            keywords: &["Trommel", "Trommelstöcke"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τύμπανο"),
            keywords: &["μουσική", "μπαγκέτες", "τύμπανο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("drum"),
            keywords: &["drum", "drumsticks", "music"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["drum", "drumsticks", "music", "percussions"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("tambor"),
            keywords: &["baquetas", "música", "tambor"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["música", "palitos", "tambor"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["baquetas", "música", "palitos", "tambor"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("trumm"),
            keywords: &["muusika", "trumm", "trummipulgad"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("danborra"),
            keywords: &["danbor", "danborra", "makilak", "musika"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("طبل"),
            keywords: &["درام", "ساز", "طبل", "موسیقی", "کوبه\u{200c}ای"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("rumpu"),
            keywords: &["musiikki", "rumpu", "rumpukapula"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("drum"),
            keywords: &["drum", "drumsticks", "musika"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("trumma"),
            keywords: &["ljóðføri", "trumma", "tónleikur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("batterie"),
            keywords: &["baguettes", "batterie", "musique", "tambour"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("tambour"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("druma"),
            keywords: &["ceol", "druma", "drumaí", "rac-cheol"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("druma"),
            keywords: &["bioran", "ceòl", "druma"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("tambor"),
            keywords: &["instrumento", "música", "tambor"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ડ\u{acd}રમ"),
            keywords: &["ડ\u{acd}રમ", "ડ\u{acd}રમસ\u{acd}ટિક", "સ\u{a82}ગીત"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ganga"),
            keywords: &["ganga", "kiɗa", "sandunan ganga"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("תוף"),
            keywords: &["מוזיקה", "מקלות תיפוף", "קצב", "תוף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ड\u{94d}रम"),
            keywords: &["ड\u{94d}रम", "ड\u{94d}रमस\u{94d}टिक", "स\u{902}गीत"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("bubanj"),
            keywords: &["bubanj", "glazba", "palice"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("dob"),
            keywords: &["dob", "dobverő", "zene"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("թմբուկ"),
            keywords: &["երաժշտություն", "թմբուկ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("drum"),
            keywords: &["drum", "musik", "stik drum"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ìgbà"),
            keywords: &["egwu", "osisiìgbà", "ìgbà"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("tromma"),
            keywords: &[
                "hljóðfæri",
                "tromma",
                "trommuleikari",
                "trommusett",
                "tónlist",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("tamburo"),
            keywords: &["bacchette", "musica", "tamburo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ドラム"),
            keywords: &["ドラム", "太鼓", "楽器", "音楽"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("dram"),
            keywords: &["dram", "musik", "stik dram"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბარაბანი"),
            keywords: &["ბარაბანი", "დოლის ჩხირები", "მუსიკა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("барабан"),
            keywords: &["барабан", "музыка"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("tromme"),
            keywords: &["musik", "rytme", "tromme", "trommestikker"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}គរ"),
            keywords: &[
                "ចង\u{17d2}ក\u{17b9}ះវៃស\u{17d2}គរ",
                "តន\u{17d2}រ\u{17d2}ត\u{17b8}",
                "ភ\u{17d2}លេង",
                "ស\u{17d2}គរ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಡ\u{ccd}ರಮ\u{ccd}"),
            keywords: &["ಕೋಲುಗಳು", "ಡ\u{ccd}ರಮ\u{ccd}", "ಸಂಗೀತ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("드럼"),
            keywords: &["드럼", "북", "북채", "음악"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("धोल"),
            keywords: &["धोल", "धोलाची बडी", "स\u{902}गीत"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("барабан"),
            keywords: &["барабан", "музыка", "таякчалар"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Trommel"),
            keywords: &["Bengelen", "Musek", "Trommel"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກອງ"),
            keywords: &["ກອງ", "ເພງ", "ໄມ\u{ec9}ກອງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("būgnas"),
            keywords: &["būgnas", "muzika"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("bungas"),
            keywords: &["bungas", "bungu vālītes", "mūzika"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pahū"),
            keywords: &["pahū", "patupahū", "puoro"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("тапан"),
            keywords: &["музика", "палки", "тапан"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ചെണ\u{d4d}ട"),
            keywords: &["ചെണ\u{d4d}ട", "ചെണ\u{d4d}ടക\u{d4d}കോൽ", "ശബ\u{d4d}ദം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бөмбөр"),
            keywords: &["бөмбөр", "хөгжим", "цохиур"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ड\u{94d}रम"),
            keywords: &["ड\u{94d}रम", "ड\u{94d}रमस\u{94d}टिक", "स\u{902}गीत"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("dram"),
            keywords: &["dram", "kayu dram", "muzik"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("tanbur"),
            keywords: &["drumsticks", "mużika", "tanbur"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဗ\u{102f}\u{1036}"),
            keywords: &[
                "ဂ\u{102e}တ",
                "ဗ\u{102f}\u{1036}",
                "ဗ\u{102f}\u{1036}လက\u{103a}ရ\u{102d}\u{102f}က\u{103a}တန\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("tromme"),
            keywords: &["musikk", "tromme", "trommestikker"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ड\u{94d}रम"),
            keywords: &["ड\u{94d}रम", "ड\u{94d}रमस\u{94d}टिक", "स\u{902}गीत"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("trommel"),
            keywords: &["drummen", "muziek", "trommel", "trommelstokken"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("tromme"),
            keywords: &["musikk", "tromme", "trommestikker"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଡ\u{b4d}ରମ\u{b4d}\u{200c}"),
            keywords: &[
                "ଡ\u{b4d}ରମ\u{b4d}\u{200c}",
                "ଡ\u{b4d}ରମ\u{b4d}\u{200c} ବଜ\u{b3e}ଇବ\u{b3e} କ\u{b3e}ଠ\u{b3f}",
                "ସଙ\u{b4d}ଗୀତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਡਰ\u{a70}ਮ"),
            keywords: &["ਡਰ\u{a70}ਮ", "ਡਰ\u{a70}ਮਸਟਿ\u{a71}ਕ", "ਸ\u{a70}ਗੀਤ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ڈھول"),
            keywords: &["موسیقی", "چوب نقارہ", "ڈھول"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Drọm"),
            keywords: &["Drọm", "Drọ\u{301}mstik-Dẹm", "Miúzik"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("bęben"),
            keywords: &["bęben", "bębenek", "grać", "muzyka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ډول"),
            keywords: &["د ډول لختې", "موسيقي", "ډول"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("tambor"),
            keywords: &["baquetas", "música", "percussão", "tambor"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["baquetas", "música", "tambor"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tambor"),
            keywords: &["tambor"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("tobă"),
            keywords: &["bețe de tobă", "muzică", "tobă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1057"),
            keywords: &["E10-1057"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("барабан"),
            keywords: &[
                "барабан",
                "инструмент",
                "музыка",
                "музыкальный инструмент",
                "палочки",
                "ударные",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ingoma"),
            keywords: &["imirishyo", "ingoma", "umuziki"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڊهول"),
            keywords: &["موسيقي", "ڊرم", "ڊرم اسٽڪس", "ڊهول"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බෙරය"),
            keywords: &["බෙරය", "සංග\u{dd3}තය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("bubon"),
            keywords: &["bubenícke", "bubon", "hudba", "paličky"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("boben"),
            keywords: &["boben", "glasba", "tolkalo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("durbaan"),
            keywords: &["durbaan", "muusik", "ulaha durbaanka"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("daulle"),
            keywords: &["daulle", "muzikë", "shkopinj daulleje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("добош"),
            keywords: &["бубањ", "добош", "музика", "палице"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["добош"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("doboš"),
            keywords: &["bubanj", "doboš", "muzika", "palice"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["doboš"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("trumma"),
            keywords: &["musik", "trumma", "trumpinnar"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ngoma"),
            keywords: &["muziki", "ngoma", "piga ngoma"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மேளம\u{bcd}"),
            keywords: &["இசை", "மேளம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("డ\u{c4d}రమ\u{c4d}"),
            keywords: &[
                "డ\u{c4d}రమ\u{c4d}",
                "డ\u{c4d}రమ\u{c4d} స\u{c4d}ట\u{c3f}క\u{c4d}\u{200c}లు",
                "సంగ\u{c40}తం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("нақора"),
            keywords: &["мусиқӣ", "нақора", "чӯбҳои нақора"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("กลอง"),
            keywords: &[
                "กลอง",
                "ดนตร\u{e35}",
                "ต\u{e35}",
                "ร\u{e31}ว",
                "เพลง",
                "ไม\u{e49}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("deprek"),
            keywords: &["aýdym-saz", "deprek", "deprek çalynýan taýajyklar"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("nafa talamu"),
            keywords: &["nafa talamu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("davul"),
            keywords: &["davul", "müzik", "tokmak"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("دۇمباق"),
            keywords: &["دۇمباق", "مۇزىكا", "چالغۇچ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("барабан"),
            keywords: &["барабан", "музика", "палички"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ڈرم"),
            keywords: &["اسٹکس", "موسیقی", "ڈرم"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("baraban"),
            keywords: &["baraban", "musiqa", "tayoqchalar"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trống"),
            keywords: &["dùi trống", "nhạc", "trống"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("ndënd"),
            keywords: &["galañ", "misik", "ndënd"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("igubu"),
            keywords: &["igubu", "iintonga zegubu", "umculo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ìlù"),
            keywords: &["igi ìlù", "orin", "Ìlù", "ìlù"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("鼓"),
            keywords: &["音樂", "鼓", "鼓棍"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("鼓"),
            keywords: &["音乐", "鼓", "鼓棍"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("鼓"),
            keywords: &["音乐", "鼓", "鼓声", "鼓槌"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("鼓"),
            keywords: &["打擊樂", "音樂", "鼓", "鼓棒", "鼓槌"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("idilamu"),
            keywords: &["idilamu", "izinduku zedilamu", "umculo"],
        },
    ],
};
#[doc = "🪘"]
pub const LONG_DRUM: crate::Emoji = crate::Emoji {
    glyph: "🪘",
    codepoint: "1FA98",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "long drum",
    group: "Objects",
    subgroup: "musical-instrument",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("lang drom"),
            keywords: &["drom", "lang drom", "maatslag", "pols", "ritme"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ረጅም ከበሮ"),
            keywords: &["ረጅም ከበሮ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("طبل طويل"),
            keywords: &["دق", "طبل", "طبل طويل", "كونغا", "لحن"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("দীঘল ড\u{9cd}ৰ\u{9be}ম"),
            keywords: &[
                "কঙ\u{9cd}গো",
                "ড\u{9cd}ৰ\u{9be}ম",
                "ত\u{9be}ল",
                "দীঘল ড\u{9cd}ৰ\u{9be}ম",
                "বীট",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("uzun baraban"),
            keywords: &["konqa", "ritm", "təbil", "uzun baraban", "vurmaq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("выцягнуты барабан"),
            keywords: &["барабан", "біт", "выцягнуты барабан", "конга", "рытм"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("висок барабан"),
            keywords: &["барабан", "висок барабан", "конга", "ритъм"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("লং ড\u{9cd}র\u{9be}ম"),
            keywords: &[
                "কংগ\u{9be}",
                "ছন\u{9cd}দ",
                "ড\u{9cd}র\u{9be}ম",
                "ত\u{9be}ল",
                "লং ড\u{9cd}র\u{9be}ম",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("djembe"),
            keywords: &["benveg", "djembe", "sonerezh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kongo bubnjevo"),
            keywords: &[
                "bubnjevi",
                "kongo bubnjevi",
                "kongo bubnjevo",
                "ritam",
                "udarac",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("conga"),
            keywords: &["conga", "percussió", "ritme", "timbal"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎱᎵ ᎦᏅᎯᏓ"),
            keywords: &["ᎢᏳᏩᎩᏗ", "ᎧᏂᎦ", "ᎧᏃᎩᏍᏗ", "ᎱᎵ", "ᎱᎵ ᎦᏅᎯᏓ", "ᏆᏂᎪ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("protáhlý buben"),
            keywords: &[
                "buben",
                "bubnování",
                "conga",
                "congo",
                "konga",
                "kongo",
                "protáhlý buben",
                "rytmus",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("drwm hir"),
            keywords: &["conga", "curiad", "drwm", "drwm hir", "rhythm"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("høj tromme"),
            keywords: &[
                "beat",
                "conga",
                "høj tromme",
                "rytme",
                "slagtøj",
                "taktslag",
                "tromme",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("afrikanische Trommel"),
            keywords: &["Conga", "Rhythmus", "afrikanische Trommel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κόνγκα"),
            keywords: &["κόνγκα", "ρυθμός", "τύμπανο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("long drum"),
            keywords: &["beat", "conga", "drum", "long drum", "rhythm"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("conga drum"),
            keywords: &["beat", "conga", "drum", "long drum", "rhythm"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("conga drum"),
            keywords: &["beat", "conga", "drum", "long drum", "rhythm"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("tamboril"),
            keywords: &["conga", "ritmo", "tambor", "tamboril"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["tamboril"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("aafrika trumm"),
            keywords: &["aafrika", "djembe", "rütm", "trumm"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("danbor luze"),
            keywords: &["bongoa", "danbor luze", "danborra", "erritmoa", "konga"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("طبل بلند"),
            keywords: &["ریتم", "ضرب", "طبل", "طبل بلند", "کانگا"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("congarumpu"),
            keywords: &["conga", "congarumpu", "rumpu", "rytmi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mahabang drum"),
            keywords: &["conga", "drum", "mahabang drum", "tunog"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("long trumma"),
            keywords: &["ljóðføri", "long trumma", "trumma", "tónleikur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("djembé"),
            keywords: &["battement", "conga", "djembé", "rythme", "tambour"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["conga", "djembé", "rythme", "tambour"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("druma fada"),
            keywords: &["druma fada"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("druma fada"),
            keywords: &["buille", "conga", "druma", "druma fada", "ruitheam"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("tambor alto"),
            keywords: &[
                "conga",
                "instrumento",
                "música",
                "percusión",
                "ritmo",
                "tambor alto",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લા\u{a82}બ\u{ac1}\u{a82} ડ\u{acd}રમ"),
            keywords: &[
                "કો\u{a82}ગા",
                "ટપ\u{acd}પો",
                "ડ\u{acd}રમ",
                "તાલ",
                "લા\u{a82}બ\u{ac1}\u{a82} ડ\u{acd}રમ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("תוף גבוה"),
            keywords: &["קונגה", "קצב", "תוף", "תוף גבוה", "תופים", "תיפוף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बड\u{93c}ा ड\u{94d}रम"),
            keywords: &[
                "को\u{902}गा",
                "ड\u{94d}रम",
                "ताल",
                "बड\u{93c}ा ड\u{94d}रम",
                "बीट",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("visoki bubanj"),
            keywords: &["bubanj", "konga", "ritam", "udarac", "visoki bubanj"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("hosszú dob"),
            keywords: &["dob", "hosszú dob", "konga", "ritmus", "ütem"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կոնգա"),
            keywords: &["թմբուկ", "կոնգա", "ռիթմ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("gendang"),
            keywords: &["conga", "dentum", "gendang", "irama"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("handtromma"),
            keywords: &["handtromma", "hrynjandi", "kónga", "taktur", "tromma"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("tamburo lungo"),
            keywords: &["conga", "percussioni", "ritmo", "tamburo", "tamburo lungo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("コンガ"),
            keywords: &["コンガ", "ビート", "リズム", "太鼓", "楽器", "音楽"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kendhang"),
            keywords: &["dram", "irama", "kendhang", "konga", "nabuh"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გრძელი დოლი"),
            keywords: &["გრძელი დოლი", "დოლი", "კონგა", "რითმი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("цилиндрлік барабан"),
            keywords: &["барабан", "бит", "конга", "цилиндрлік барабан", "ырғақ"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}គរវែង"),
            keywords: &[
                "ចង\u{17d2}វាក\u{17cb}",
                "វាយ",
                "ស\u{17d2}គរ",
                "ស\u{17d2}គរវែង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಲಾಂಗ\u{ccd}\u{200c} ಡ\u{ccd}ರಮ\u{ccd}\u{200c}"),
            keywords: &[
                "ಕಾಂಗಾ",
                "ಡ\u{ccd}ರಮ\u{ccd}\u{200c}",
                "ನುಡ\u{cbf}ಸು",
                "ಲಯ",
                "ಲಾಂಗ\u{ccd}\u{200c} ಡ\u{ccd}ರಮ\u{ccd}\u{200c}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("긴 북"),
            keywords: &["긴 북", "드럼", "리듬", "박자", "콩가"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("म\u{943}द\u{902}ग"),
            keywords: &["का\u{901}गा", "ठोको", "धोल", "नाद", "म\u{943}द\u{902}ग"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("узун добулбас"),
            keywords: &["узун добулбас"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກອງຍາວ"),
            keywords: &["ກອງ", "ກອງຍາວ", "ຄອນກ\u{ec9}າ", "ຈ\u{eb1}ງຫວະ", "ທຳນອງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("ilgas būgnas"),
            keywords: &["Kongas", "būgnas", "ilgas būgnas", "ritmas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("garās bungas"),
            keywords: &["bungas", "garās bungas", "konga", "ritms", "vālīte"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("конга"),
            keywords: &["конга", "ритам", "тапан"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മദ\u{d4d}ദളം"),
            keywords: &[
                "കൊട\u{d4d}ട\u{d4d}",
                "കോംഗ",
                "ത\u{d3e}ളം",
                "പെര\u{d41}മ\u{d4d}പറ",
                "മദ\u{d4d}ദളം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("урт бөмбөр"),
            keywords: &["бөмбөр", "конга бүжиг", "ритм", "урт бөмбөр", "цохилт"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("लॉन\u{94d}ग ड\u{94d}रम"),
            keywords: &[
                "कॉन\u{94d}गा",
                "ड\u{94d}रम",
                "ताल",
                "बीट",
                "लॉन\u{94d}ग ड\u{94d}रम",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("karatung"),
            keywords: &["bongo", "dram", "irama", "karatung", "konga", "rentak"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဗ\u{102f}\u{1036}ရ\u{103e}ည\u{103a}"),
            keywords: &[
                "စည\u{103a}းက\u{102d}\u{102f}က\u{103a}ဝါးက\u{102d}\u{102f}က\u{103a}",
                "စ\u{102e}တန\u{103a}းလ\u{103e}ည\u{1037}\u{103a} မြ\u{1030}းကြ\u{103d}အကတ\u{102e}းလ\u{102f}\u{1036}း",
                "စ\u{102e}းချက\u{103a}",
                "ဗ\u{102f}\u{1036}",
                "ဗ\u{102f}\u{1036}ရ\u{103e}ည\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("langtromme"),
            keywords: &["beat", "conga", "langtromme", "rytme", "tromme"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("लामो ड\u{94d}रम"),
            keywords: &[
                "कोङ\u{94d}गा",
                "ड\u{94d}रम",
                "ताल",
                "ध\u{941}न",
                "लामो ड\u{94d}रम",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("hoge trom"),
            keywords: &["beat", "conga", "drummen", "hoge trom", "ritme", "trom"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("langtromme"),
            keywords: &["beat", "conga", "langtromme", "rytme", "tromme"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଲମ\u{b4d}ବ\u{b3e} ଢୋଲ"),
            keywords: &[
                "କୋଙ\u{b4d}ଗ\u{b3e}",
                "ଢୋଲ",
                "ତ\u{b3e}ଳ",
                "ବ\u{b3f}ଟ\u{b4d}\u{200c}",
                "ଲମ\u{b4d}ବ\u{b3e} ଢୋଲ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲ\u{a70}ਬਾ ਢ\u{a4b}ਲ"),
            keywords: &[
                "ਕ\u{a4b}\u{a02}ਗਾ",
                "ਡਰ\u{a70}ਮ",
                "ਢ\u{a4b}ਲ",
                "ਢ\u{a4b}ਲਕੀ",
                "ਤਾਲ",
                "ਬੀਟ",
                "ਲ\u{a70}ਬਾ ਢ\u{a4b}ਲ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Lọ\u{301}ng Drọm"),
            keywords: &["Bit", "Drọm", "Kónga", "Lọ\u{301}ng Drọm", "Rídim"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("konga"),
            keywords: &["bęben", "konga", "rytm"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("اوږود ډول"),
            keywords: &["اوږود ډول", "موسيقي", "وهل", "ډول", "کونګا"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("tambor comprido"),
            keywords: &["batida", "conga", "ritmo", "tambor", "tambor comprido"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("tambor alto"),
            keywords: &["tambor alto"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("tobă înaltă"),
            keywords: &["bătaie", "conga", "ritm", "tobă", "tobă înaltă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-059"),
            keywords: &["E13-059"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("конга"),
            keywords: &["барабан", "бит", "конга", "ритм"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("وڏو ڊرم"),
            keywords: &["بيٽ", "رڌم", "وڏو ڊرم", "ڊرم", "ڪونگا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ද\u{dd2}ග\u{dd4} බෙර"),
            keywords: &[
                "කොන\u{dca}ග\u{dcf}",
                "ද\u{dd2}ග\u{dd4} බෙර",
                "පහර",
                "බෙර",
                "ර\u{dd2}ද\u{dca}මය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kongo"),
            keywords: &["bubenícke", "bubon", "kongo", "rytmus"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("visok boben"),
            keywords: &["boben", "kongo", "ritem", "visok boben"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("durbaan dheer"),
            keywords: &[
                "ciyaarta konga",
                "durbaan",
                "durbaan dheer",
                "garaac",
                "laxan",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("daulle e gjatë"),
            keywords: &["daulle", "daulle e gjatë", "ritëm"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("тимпан"),
            keywords: &["бубањ", "конга", "ритам", "тимпан"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("timpan"),
            keywords: &["bubanj", "konga", "ritam", "timpan"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("congatrumma"),
            keywords: &["congatrumma", "djembe", "rytm", "takt", "trumma"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ngoma refu"),
            keywords: &["mapigo", "mdundo", "ngoma", "ngoma refu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ந\u{bc0}ண\u{bcd}ட மத\u{bcd}தளம\u{bcd}"),
            keywords: &[
                "கோங\u{bcd}க\u{bbe}",
                "த\u{bbe}ளம\u{bcd}",
                "ந\u{bc0}ண\u{bcd}ட மத\u{bcd}தளம\u{bcd}",
                "மத\u{bcd}தளம\u{bcd}",
                "ரிதம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c4a}డవ\u{c3e}ట\u{c3f} డ\u{c4d}రమ\u{c4d}"),
            keywords: &[
                "క\u{c3e}ంగ\u{c3e}",
                "డ\u{c4d}రమ\u{c4d}",
                "ప\u{c4a}డవ\u{c3e}ట\u{c3f} డ\u{c4d}రమ\u{c4d}",
                "బ\u{c40}ట\u{c4d}",
                "ర\u{c3f}థమ\u{c4d}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("กลองยาว"),
            keywords: &["กลอง", "กลองยาว", "คองกา", "จ\u{e31}งหวะ", "ต\u{e35}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("uzyn deprek"),
            keywords: &["bongo", "deprek", "konga", "ritm", "urgy", "uzyn deprek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("nafa"),
            keywords: &["nafa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("uzun davul"),
            keywords: &["conga", "davul", "ritm", "tempo", "uzun davul", "vuruş"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("циліндричний барабан"),
            keywords: &["барабан", "конґа", "ритм", "ударні", "циліндричний барабан"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("لمبا ڈرم"),
            keywords: &["بجانا", "ردھم", "لمبا ڈرم", "ڈرم", "ڈھول"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("uzun nogʻora"),
            keywords: &["bongo", "konga", "nogʻora", "ritm", "uzun nogʻora", "zarba"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trống dài"),
            keywords: &["conga", "nhịp", "trống", "trống dài", "đập"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("長鼓"),
            keywords: &["康加鼓", "手鼓", "拍子", "節奏", "長鼓", "鼓"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("长鼓"),
            keywords: &["康加鼓", "手鼓", "拍子", "节奏", "长鼓", "鼓"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("长鼓"),
            keywords: &["康加鼓", "敲", "节奏", "长鼓", "鼓"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("長鼓"),
            keywords: &["小鼓", "康加舞", "打擊", "節奏", "長鼓", "鼓"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isigubhu eside"),
            keywords: &["i-conga", "ibhithi", "isigqi", "isigubhu", "isigubhu eside"],
        },
    ],
};
