#[doc = "🎼"]
pub const MUSICAL_SCORE: crate::Emoji = crate::Emoji {
    glyph: "🎼",
    codepoint: "1F3BC",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "musical score",
    group: "Objects",
    subgroup: "music",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("musiekbalk"),
            keywords: &["balk", "musiek", "musiekbalk", "partituur"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሙዚቃዊ ውጤት"),
            keywords: &["ሙዚቃ", "ሙዚቃዊ ውጤት", "ውጤት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("علامة موسيقية"),
            keywords: &["سكور", "علامة موسيقية", "موسيقى"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("সংগীতৰ লিখিত ৰ\u{9c2}প"),
            keywords: &["সংগীত", "সংগীত-ৰচন\u{9be}", "সংগীতৰ লিখিত ৰ\u{9c2}প"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("musiqi partiturası"),
            keywords: &["musiqi", "musiqi partiturası", "partitura"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("партытура"),
            keywords: &["запіс", "музыка", "музычны", "нота", "партытура"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Нотен запис"),
            keywords: &["Нотен запис", "запис", "музика"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("সঙ\u{9cd}গীতের স\u{9cd}কোর"),
            keywords: &["সঙ\u{9cd}গীত", "সঙ\u{9cd}গীতের স\u{9cd}কোর", "স\u{9cd}কোর"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("skrid-sonerezh"),
            keywords: &["kevrollenn", "skrid-sonerezh", "sonerezh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("notni zapis"),
            keywords: &["muzika", "note", "notni zapis", "partitura"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pentagrama"),
            keywords: &["música", "pentagrama"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎧᏃᎩᏓ ᎪᏪᎳᏅ"),
            keywords: &["ᎪᏪᎳᏅ", "ᏗᎧᏃᎩᏍᏗ", "ᏗᎧᏃᎩᏓ ᎪᏪᎳᏅ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("notová osnova"),
            keywords: &["hudba", "notová osnova", "notový", "noty", "zápis"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sgôr cerddorol"),
            keywords: &["cerddoriaeth", "sgôr", "sgôr cerddorol"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("partitur"),
            keywords: &["g-nøgle", "musik", "partitur"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Notenschlüssel"),
            keywords: &[
                "Musik",
                "Noten",
                "Notenschlüssel",
                "Partitur",
                "Violinschlüssel",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("παρτιτούρα"),
            keywords: &["μουσική", "παρτιτούρα", "πεντάγραμμο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("musical score"),
            keywords: &["music", "musical score", "score"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pentagrama"),
            keywords: &["música", "partitura", "pentagrama"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("clave de sol"),
            keywords: &[
                "clave",
                "clave de sol",
                "música",
                "partitura",
                "pentagrama",
                "sol",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("partitura"),
            keywords: &["partitura"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["clave", "clave de sol", "música", "partitura", "pentagrama"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("noodijoonestik"),
            keywords: &["muusika", "noodijoonestik", "noot"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("notazio musikala"),
            keywords: &["musika", "notazio", "notazio musikala"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پارتیتور"),
            keywords: &["خط حامل", "موسیقی", "نت", "پارتیتور", "کلید سل"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("nuottiviivasto"),
            keywords: &["musiikki", "nuotti", "nuottiavain", "nuottiviivasto"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("musical score"),
            keywords: &["iskor", "kanta", "musical score", "musika", "tugtog"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("fjølrøddabók"),
            keywords: &["fjølrøddabók", "partiturur", "tónleikur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("partition"),
            keywords: &["musique", "partition"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("scór ceoil"),
            keywords: &["ceol", "scór", "scór ceoil"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("iuchair-ghleus"),
            keywords: &["ceòl", "iuchair-ghleus", "sgàla", "sgòr"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("clave de sol"),
            keywords: &["clave de sol", "música", "pentagrama", "solfexo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{a82}ગીત માટ\u{ac7}ની લખાણ"),
            keywords: &["લખાણ", "સ\u{a82}ગીત", "સ\u{a82}ગીત માટ\u{ac7}ની લખાણ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("alamar kiɗa"),
            keywords: &["alama", "alamar kiɗa", "kiɗa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מפתח סול"),
            keywords: &["מוזיקה", "מפתח סול", "תווים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{902}गीत स\u{94d}कोर"),
            keywords: &["स\u{902}गीत", "स\u{94d}कोर"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("notno crtovlje"),
            keywords: &["crtovlje", "glazba", "notno crtovlje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("zenei kotta"),
            keywords: &["kotta", "zene", "zenei kotta"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սոլի բանալի"),
            keywords: &["երաժշտություն", "սոլի բանալի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("naskah musik"),
            keywords: &["musik", "naskah musik", "skor"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akara egwu"),
            keywords: &["akara", "egwu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("nótnaskrif"),
            keywords: &["G-lykill", "nótnaskrif", "tónlist"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pentagramma"),
            keywords: &["musica", "partitura", "pentagramma"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("楽譜"),
            keywords: &["スコア", "ト音記号", "五線譜", "楽譜", "音楽"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("notasi musik"),
            keywords: &["musik", "notasi"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მუსიკალური პარტიტურა"),
            keywords: &["მუსიკა", "მუსიკალური პარტიტურა", "პარტიტურა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("партитура"),
            keywords: &["музыка", "партитура"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("partitur"),
            keywords: &["g-nøgle", "musik", "partitur"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ណោតភ\u{17d2}លេងព\u{17b8}ក\u{17d2}រោយឆ\u{17d2}ន\u{17bc}តផ\u{17d2}តេកប\u{17d2}រា\u{17c6}",
            ),
            keywords: &[
                "ណោតភ\u{17d2}លេងព\u{17b8}ក\u{17d2}រោយឆ\u{17d2}ន\u{17bc}តផ\u{17d2}តេកប\u{17d2}រា\u{17c6}",
                "ណោតភ\u{17d2}លេងភ\u{17d2}លេង",
                "តន\u{17d2}ត\u{17d2}រ\u{17b8}",
                "ភ\u{17d2}លេង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸಂಗೀತ ಸ\u{ccd}ಕೋರ\u{ccd}"),
            keywords: &[
                "ಮ\u{ccd}ಯ\u{cc2}ಸ\u{cbf}ಕ\u{ccd}",
                "ಸಂಗೀತ",
                "ಸ\u{ccd}ಕೋರ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("높은음자리표"),
            keywords: &["높은음자리", "높은음자리표", "악보", "음악"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("स\u{902}गाताचो स\u{94d}वर"),
            keywords: &[
                "स\u{902}गाताचो स\u{94d}वर",
                "स\u{902}गीत",
                "स\u{902}गीताचो स\u{94d}वर",
                "स\u{94d}वर",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("музыкалык ачкыч"),
            keywords: &["ачкыч", "музыка", "музыкалык ачкыч"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Partitioun"),
            keywords: &["Musek", "Partitioun"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb1}ນຍາລ\u{eb1}ກເພງ"),
            keywords: &["ສ\u{eb1}ນຍາລ\u{eb1}ກເພງ", "ໂນດເພງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("partitūra"),
            keywords: &["muzika", "partitūra"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("nošu līnijas"),
            keywords: &["mūzika", "notis", "nošu līnijas"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tuhinga puoro"),
            keywords: &["puoro", "tuhinga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("петолиние"),
            keywords: &["виолински", "клуч", "музика", "петолиние"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മ\u{d4d}യ\u{d42}സിക\u{d4d} സ\u{d4d}കോർ"),
            keywords: &[
                "മ\u{d4d}യ\u{d42}സിക\u{d4d} സ\u{d4d}കോർ",
                "സംഗീതം",
                "സ\u{d4d}കോർ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нотны шугам"),
            keywords: &["нот", "нотны шугам", "хөгжим", "шугам"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{902}गीतात वापरल\u{947} जाणारी लिपी"),
            keywords: &[
                "स\u{902}गीत",
                "स\u{902}गीतात वापरल\u{947} जाणारी लिपी",
                "स\u{94d}कोअर",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("skor muzik"),
            keywords: &["muzik", "skor"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("partitura mużikali"),
            keywords: &["mużika", "partitura", "partitura mużikali"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တေးသ\u{103d}ား သင\u{103a}\u{1039}ကေတ"),
            keywords: &[
                "ဂ\u{102e}တ",
                "ဂ\u{102e}တ သင\u{103a}\u{1039}ကေတ",
                "တေးသ\u{103d}ား သင\u{103a}\u{1039}ကေတ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("musikk"),
            keywords: &["g-nøkkel", "musikk", "notetegn"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("सा\u{902}गीतिक स\u{94d}कोर"),
            keywords: &["सा\u{902}गीतिक", "स\u{94d}कोर"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("notenschift"),
            keywords: &["muziek", "notenschift", "partituur"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("musikk"),
            keywords: &["g-nøkkel", "musikk", "noteteikn"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସଙ\u{b4d}ଗୀତ ସମ\u{b4d}ବନ\u{b4d}ଧୀୟ ସ\u{b4d}କୋର\u{b4d}\u{200c}"),
            keywords: &[
                "ସଙ\u{b4d}ଗୀତ",
                "ସଙ\u{b4d}ଗୀତ ସମ\u{b4d}ବନ\u{b4d}ଧୀୟ ସ\u{b4d}କୋର\u{b4d}\u{200c}",
                "ସ\u{b4d}କୋର\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a70}ਗੀਤਕ ਸਕ\u{a4b}ਰ"),
            keywords: &["ਸਕ\u{a4b}ਰ", "ਸ\u{a70}ਗੀਤ", "ਸ\u{a70}ਗੀਤਕ ਸਕ\u{a4b}ਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("موسیقی دا سکور"),
            keywords: &["سکور", "موسیقی", "موسیقی دا سکور"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Miúzíkál Skọ"),
            keywords: &["Miúzik", "Miúzíkál Skọ", "Skọ"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("partytura"),
            keywords: &["klucz", "muzyka", "nuty", "partytura", "pięciolinia"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د موسیقۍ نمرې"),
            keywords: &["د موسیقۍ نمرې", "موسيقي", "نمرې"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("partitura musical"),
            keywords: &["música", "partitura", "partitura musical"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("pauta"),
            keywords: &["música", "partitura", "pauta"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("partitura"),
            keywords: &["partitura"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("partitură"),
            keywords: &["cheia sol", "muzică", "partitură", "portativ"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-380"),
            keywords: &["E10-380"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("нотный стан"),
            keywords: &["ключ", "музыка", "нотный стан", "ноты", "скрипичный"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("akarango k’umuziki"),
            keywords: &["akarango k’umuziki", "inota", "umuziki"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("موسيقي جو دڪان"),
            keywords: &["موسيقي جو دڪان", "موسيقي، اسڪور"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සංග\u{dd3}ත ත\u{dcf}රත\u{dcf}ව"),
            keywords: &[
                "ත\u{dcf}රත\u{dcf}ව",
                "සංග\u{dd3}ත ත\u{dcf}රත\u{dcf}ව",
                "සංග\u{dd3}තය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("notová osnova"),
            keywords: &["hudba", "notová osnova", "osnova"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("partitura"),
            keywords: &["glasba", "partitura"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("xaashida muusika"),
            keywords: &["muusik", "xaashi", "xaashida muusika"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("pentagram"),
            keywords: &["muzikë", "pentagram"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("нотни запис"),
            keywords: &["музика", "ноте", "нотни запис"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("notni zapis"),
            keywords: &["muzika", "note", "notni zapis"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("g-klav"),
            keywords: &["g-klav", "musik", "noter"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("karatasi ya muziki"),
            keywords: &["karatasi ya muziki", "muziki"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("இசைக\u{bcd} கோர\u{bcd}ப\u{bcd}பு"),
            keywords: &[
                "இசை",
                "இசைக\u{bcd} கோர\u{bcd}ப\u{bcd}பு",
                "கோர\u{bcd}ப\u{bcd}பு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("సంగ\u{c40}త రచన"),
            keywords: &["రచన", "సంగ\u{c40}త రచన", "సంగ\u{c40}తం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("партитура"),
            keywords: &["мусиқӣ", "нота", "партитура"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("บรรท\u{e31}ดห\u{e49}าเส\u{e49}น"),
            keywords: &[
                "ก\u{e38}ญแจซอล",
                "บรรท\u{e31}ดห\u{e49}าเส\u{e49}น",
                "โน\u{e49}ตเพลง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("partitura"),
            keywords: &["aýdym-saz", "aýdym-saz nyşany", "partitura"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pepa hiva"),
            keywords: &["pepa hiva"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sol anahtarı"),
            keywords: &["müzik", "partisyon", "sol anahtarı"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("مۇزىكا يازمىسى"),
            keywords: &["مۇزىكا", "مۇزىكا يازمىسى", "يازما"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("партитура"),
            keywords: &["музичний", "партитура"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("میوزیکل اسکور"),
            keywords: &["اسکور", "موسیقی", "میوزیکل اسکور"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("musiqa kaliti"),
            keywords: &["kalit", "musiqa", "musiqa kaliti"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("khuông nhạc"),
            keywords: &["bản nhạc", "khuông nhạc", "nhạc"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kle misik"),
            keywords: &["kle", "misik"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inqaku lomculo"),
            keywords: &["inqaku", "inqaku lomculo", "umculo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("akọsilẹ orin"),
            keywords: &["akọsilẹ orin", "akọsílẹ\u{300}", "orin"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("樂譜"),
            keywords: &["樂譜", "音樂"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("乐谱"),
            keywords: &["乐谱", "音乐"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("乐谱"),
            keywords: &["乐谱", "五线谱", "音乐", "音符"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("樂譜"),
            keywords: &["樂譜", "音樂"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umbhalo womculo"),
            keywords: &["umbhalo", "umbhalo womculo", "umculo"],
        },
    ],
};
#[doc = "🎵"]
pub const MUSICAL_NOTE: crate::Emoji = crate::Emoji {
    glyph: "🎵",
    codepoint: "1F3B5",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "musical note",
    group: "Objects",
    subgroup: "music",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("musieknoot"),
            keywords: &["musiek", "musieknoot", "noot"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሙዚቃዊ ኖታ"),
            keywords: &["ሙዚቃ", "ሙዚቃዊ ኖታ", "ማስታወሻ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("نوتة موسيقية"),
            keywords: &["موسيقى", "نوتة", "نوتة موسيقية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("সংগীতৰ স\u{9c1}ৰ"),
            keywords: &["সংগীত", "সংগীতৰ স\u{9c1}ৰ", "স\u{9c1}ৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("musiqi notu"),
            keywords: &["musiqi", "musiqi notu", "not"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("музычная нота"),
            keywords: &["музыка", "музычная нота", "музычны", "нота"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("нота"),
            keywords: &["музика", "нота"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("গ\u{9be}নের স\u{9cd}বরলিপি"),
            keywords: &[
                "গ\u{9be}নের স\u{9cd}বরলিপি",
                "নোট",
                "সঙ\u{9cd}গীত। গ\u{9be}নের স\u{9cd}বরলিপি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("notenn sonerezh"),
            keywords: &["notenn", "sonerezh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("nota"),
            keywords: &["muzika", "nota"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("nota musical"),
            keywords: &["música", "nota", "nota musical"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎧᏃᎩᏍᏙᏗ ᎠᏍᏓᏫᏛᏂᏗ"),
            keywords: &["ᎤᏍᏗ ᎪᏪᎵ", "ᏗᎧᏃᎩᏍᏗ", "ᏗᎧᏃᎩᏍᏙᏗ ᎠᏍᏓᏫᏛᏂᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("nota"),
            keywords: &["hudba", "nota", "noty"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("nodyn cerddorol"),
            keywords: &["cerddoriaeth", "nodyn", "nodyn cerddorol"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("node"),
            keywords: &["musik", "node"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Musiknote"),
            keywords: &["Musik", "Musiknote", "Note"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("νότα μουσικής"),
            keywords: &["μουσική", "νότα", "νότα μουσικής"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("musical note"),
            keywords: &["music", "musical note", "note"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("nota musical"),
            keywords: &["música", "nota", "nota musical"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["corchea", "música", "nota", "nota musical"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["corchea", "música", "nota", "nota musical"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("noot"),
            keywords: &["muusika", "noot"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("nota musikala"),
            keywords: &["musika", "nota", "nota musikala"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نت موسیقی"),
            keywords: &["موسیقی", "نت", "چنگ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("nuotti"),
            keywords: &["musiikki", "nuotti"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("notang pangmusika"),
            keywords: &["kanta", "musika", "nota", "notang pangmusika", "tunog"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("nóti"),
            keywords: &["nóti", "tónleikur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("note de musique"),
            keywords: &["musique", "note", "note de musique"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("nóta ceoil"),
            keywords: &["ceol", "nóta", "nóta ceoil"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("pong"),
            keywords: &["ceòl", "pong", "puing"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("nota musical"),
            keywords: &["corchea", "música", "nota musical", "notas", "solfexo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{a82}ગીતની નોટ"),
            keywords: &["નોટ", "સ\u{a82}ગીત", "સ\u{a82}ગીતની નોટ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("rubutun kiɗa"),
            keywords: &["kiɗa", "rubutu", "rubutun kiɗa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("תו מוזיקלי"),
            keywords: &["מוזיקה", "תו", "תו מוזיקלי", "תווים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{902}गीत का स\u{94d}वर"),
            keywords: &["स\u{902}गीत", "स\u{902}गीत का स\u{94d}वर", "स\u{94d}वर"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("glazbena nota"),
            keywords: &["glazba", "glazbena nota", "nota"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("hangjegy"),
            keywords: &["hangjegy", "zene"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("նոտա"),
            keywords: &["երաժշտություն", "նոտա"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("not musik"),
            keywords: &["musik", "not"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ederede ụdà-egwu"),
            keywords: &["ederede ụdà-egwu", "egwu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("nóta"),
            keywords: &["nóta", "tónlist"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("nota musicale"),
            keywords: &["musica", "nota", "nota musicale"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("音符"),
            keywords: &["8分音符", "連符", "音楽", "音符"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tangga nada musik"),
            keywords: &["musik", "tangga nada", "tangga nada musik"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მუსიკალური ნოტი"),
            keywords: &["მუსიკა", "მუსიკალური ნოტი", "ნოტი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tazmilt taẓawant"),
            keywords: &["tazmilt taẓawant"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("нота"),
            keywords: &["музыка", "нота"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("node"),
            keywords: &["musik", "node"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ណោតភ\u{17d2}លេងដ\u{17bc}ចអក\u{17d2}សរ ក អត\u{17cb}សក\u{17cb}"),
            keywords: &[
                "ណោតភ\u{17d2}លេង",
                "ណោតភ\u{17d2}លេងដ\u{17bc}ចអក\u{17d2}សរ ក អត\u{17cb}សក\u{17cb}",
                "តន\u{17d2}រ\u{17d2}ត\u{17b8}",
                "ភ\u{17d2}លេង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸಂಗೀತ ಟ\u{cbf}ಪ\u{ccd}ಪಣ\u{cbf}"),
            keywords: &["ಟ\u{cbf}ಪ\u{ccd}ಪಣ\u{cbf}", "ಸಂಗೀತ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("음표"),
            keywords: &["음악", "음표"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("स\u{902}गीताच\u{947} स\u{94d}वर"),
            keywords: &[
                "स\u{902}गीत",
                "स\u{902}गीताच\u{947} स\u{94d}वर",
                "स\u{94d}वर",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("музыкалык нота"),
            keywords: &["музыка", "музыкалык нота", "нота"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Museksnout"),
            keywords: &["Musek", "Museksnout", "Nout"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໂນດດ\u{ebb}ນຕ\u{eb5}"),
            keywords: &["ດ\u{ebb}ນຕ\u{eb5}", "ໂນດດ\u{ebb}ນຕ\u{eb5}", "ໂນດເພງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("muzikos nata"),
            keywords: &["muzika", "muzikos nata", "nata"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("nots"),
            keywords: &["mūzika", "nots"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohu waiata"),
            keywords: &["puoro", "tohu waiata"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("музичка нота"),
            keywords: &["музика", "музичка нота", "нота"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മ\u{d4d}യ\u{d42}സിക\u{d4d}ക\u{d4d} നോട\u{d4d}ട\u{d4d}"),
            keywords: &[
                "മ\u{d4d}യ\u{d42}സിക\u{d4d}ക\u{d4d}",
                "മ\u{d4d}യ\u{d42}സിക\u{d4d}ക\u{d4d} നോട\u{d4d}ട\u{d4d}",
                "സംഗീതം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хөгжмийн нот"),
            keywords: &["нот", "хөгжим", "хөгжмийн нот"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{902}गीताचा स\u{942}र"),
            keywords: &["स\u{902}गीत", "स\u{902}गीताचा स\u{942}र", "स\u{94d}वर"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("nota muzik"),
            keywords: &["muzik", "nota"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("nota mużikali"),
            keywords: &["mużika", "nota", "nota mużikali"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဂ\u{102e}တ သင\u{103a}\u{1039}ကေတ"),
            keywords: &[
                "ဂ\u{102e}တ",
                "ဂ\u{102e}တ သင\u{103a}\u{1039}ကေတ",
                "န\u{102f}တ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("note"),
            keywords: &["musikk", "musikknote", "note"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("सा\u{902}गीतिक नोट"),
            keywords: &["नोट", "सा\u{902}गीतिक"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("muzieknoot"),
            keywords: &["muziek", "muzieknoot", "noot"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("note"),
            keywords: &["musikk", "musikknote", "note"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସଙ\u{b4d}ଗୀତ ସମ\u{b4d}ବନ\u{b4d}ଧୀୟ ସ\u{b4d}ୱର"),
            keywords: &[
                "ସଙ\u{b4d}ଗୀତ",
                "ସଙ\u{b4d}ଗୀତ ସମ\u{b4d}ବନ\u{b4d}ଧୀୟ ନୋଟ\u{b4d}",
                "ସଙ\u{b4d}ଗୀତ ସମ\u{b4d}ବନ\u{b4d}ଧୀୟ ସ\u{b4d}ୱର",
                "ସ\u{b4d}ୱର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a70}ਗੀਤਕ ਨ\u{a4b}ਟ"),
            keywords: &["ਨ\u{a4b}ਟ", "ਸ\u{a70}ਗੀਤ", "ਸ\u{a70}ਗੀਤਕ ਨ\u{a4b}ਟ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("موسیقی دا نوٹ"),
            keywords: &["ر\u{64f}قعہ", "موسیقی", "موسیقی دا نوٹ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Miúzíkál Not"),
            keywords: &["Miúzik", "Miúzíkál Not", "Not"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("nuta"),
            keywords: &["muzyka", "nuta"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د موسیقۍ یادښت"),
            keywords: &["د موسیقۍ یادښت", "موسيقي", "يادښت"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("nota musical"),
            keywords: &["música", "nota", "nota musical"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("notas musical"),
            keywords: &["notas musical"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("notă muzicală"),
            keywords: &["muzică", "notă", "notă muzicală"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-373"),
            keywords: &["E10-373"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("нота"),
            keywords: &["звук", "музыка", "нота"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("inota ry’umuziki"),
            keywords: &["inota", "inota ry’umuziki", "umuziki"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("موسيقي جا نوٽ"),
            keywords: &["موسيقي جا نوٽ", "موسيقي، نوٽ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සංග\u{dd3}ත ස\u{dca}වරය"),
            keywords: &["සංග\u{dd3}ත ස\u{dca}වරය", "සංග\u{dd3}තය", "ස\u{dca}වරය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("nota"),
            keywords: &["hudba", "nota"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("glasbena nota"),
            keywords: &["glasba", "glasbena nota", "nota"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qoraal muusika"),
            keywords: &["muusik", "qoraal muusika"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("notë muzikore"),
            keywords: &["muzikë", "notë", "notë muzikore"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("нота"),
            keywords: &["музика", "музичка нота", "нота"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["нота"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("nota"),
            keywords: &["muzika", "muzička nota", "nota"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["nota"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("musiknot"),
            keywords: &["musik", "musiknot", "not"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("noti ya muziki"),
            keywords: &["muziki", "noti", "noti ya muziki"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("இசைக\u{bcd} குறிப\u{bcd}பு"),
            keywords: &[
                "இசை",
                "இசை மொழி",
                "இசைக\u{bcd} குறிப\u{bcd}பு",
                "குறிப\u{bcd}பு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("సంగ\u{c40}త స\u{c4d}వరం"),
            keywords: &["సంగ\u{c40}త స\u{c4d}వరం", "సంగ\u{c40}తం", "స\u{c4d}వరం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("нотаи мусиқӣ"),
            keywords: &["мусиқӣ", "нота", "нотаи мусиқӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("โน\u{e49}ตดนตร\u{e35}"),
            keywords: &["ดนตร\u{e35}", "โน\u{e49}ต", "โน\u{e49}ตดนตร\u{e35}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("nota"),
            keywords: &["aýdym-saz", "nota"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("nota"),
            keywords: &["nota"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("müzik notası"),
            keywords: &["müzik", "müzik notası", "nota"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("نوتا"),
            keywords: &["مۇزىكا", "نوتا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("музична нота"),
            keywords: &["музична нота", "музичний", "нота"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("میوزیکل نوٹ"),
            keywords: &["موسیقی", "میوزیکل نوٹ", "نوٹ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("musiqiy nota"),
            keywords: &["musiqa", "musiqiy nota", "nota"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nốt nhạc"),
            keywords: &["nhạc", "nốt nhạc"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("arafu misik"),
            keywords: &["araf", "arafu misik", "misik"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inowuthi yomculo"),
            keywords: &["inowuthi", "inowuthi yomculo", "umculo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ọ\u{300}rọ\u{300} orin"),
            keywords: &["orin", "ò\u{329}rọ\u{300}", "ọ\u{300}rọ\u{300} orin"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("音符"),
            keywords: &["音樂", "音符"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("音符"),
            keywords: &["音乐", "音符"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("音符"),
            keywords: &["乐谱", "五线谱", "八分音符", "音乐", "音符"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("音符"),
            keywords: &["音樂", "音符"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inothi lomculo"),
            keywords: &["inothi", "inothi lomculo", "umculo"],
        },
    ],
};
#[doc = "🎶"]
pub const MUSICAL_NOTES: crate::Emoji = crate::Emoji {
    glyph: "🎶",
    codepoint: "1F3B6",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "musical notes",
    group: "Objects",
    subgroup: "music",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("musieknote"),
            keywords: &["musiek", "musieknote", "noot", "note"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሙዚቃዊ ኖታዎች"),
            keywords: &["ሙዚቃ", "ሙዚቃዊ ኖታዎች", "ማስታወሻ", "ማስታወሻዎች"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("نوتات موسيقية"),
            keywords: &["موسيقى", "نوتات", "نوتات موسيقية", "نوتة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("সংগীতৰ স\u{9c1}ৰবিল\u{9be}ক"),
            keywords: &[
                "সংগীত",
                "সংগীতৰ স\u{9c1}ৰ",
                "সংগীতৰ স\u{9c1}ৰবিল\u{9be}ক",
                "স\u{9c1}ৰ",
                "স\u{9c1}ৰবিল\u{9be}ক",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("musiqi notları"),
            keywords: &["musiqi", "musiqi notları", "not", "notlar"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("музычныя ноты"),
            keywords: &["музыка", "музычны", "музычныя ноты", "ноты"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("ноти"),
            keywords: &["музика", "нота", "ноти"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("সঙ\u{9cd}গীতের নোট"),
            keywords: &["নোট", "নোটস", "সঙ\u{9cd}গীত", "সঙ\u{9cd}গীতের নোট"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("notennoù sonerezh"),
            keywords: &["notenn", "notennoù", "sonerezh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("note"),
            keywords: &["muzika", "note"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("notes musicals"),
            keywords: &["música", "notes", "notes musicals"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎧᏃᎩᏍᏙᏗ ᏗᏍᏓᏫᏛᏂᏗ"),
            keywords: &["ᎠᏍᏓᏫᏛᏂᏗ", "ᏗᎧᏃᎩᏍᏙᏗ ᏗᏍᏓᏫᏛᏂᏗ", "ᏗᎧᏃᎩᏓ", "ᏗᏍᏓᏫᏛᏂᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("noty"),
            keywords: &["hudba", "nota", "noty"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("nodau cerddorol"),
            keywords: &["cerddoriaeth", "nodau cerddorol", "nodyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("noder"),
            keywords: &["musik", "node", "noder"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Musiknoten"),
            keywords: &["Musik", "Musiknoten", "Noten"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("νότες μουσικής"),
            keywords: &["μουσική", "νότα", "νότες", "νότες μουσικής"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("musical notes"),
            keywords: &["music", "musical notes", "note", "notes"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("notas musicales"),
            keywords: &["música", "notas", "notas musicales"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["corchea", "música", "nota", "notas musicales"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["corcheas", "música", "notas", "notas musicales"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("noodid"),
            keywords: &["muusika", "noodid", "noot"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("nota musikalak"),
            keywords: &["musika", "nota", "nota musikalak", "notak"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نت\u{200c}های موسیقی"),
            keywords: &["موسیقی", "نت", "نت\u{200c}های موسیقی", "چنگ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("nuotteja"),
            keywords: &["musiikki", "nuotteja", "nuotti"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mga notang pangmusika"),
            keywords: &["kanta", "mga notang pangmusika", "musika", "nota", "tunog"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("nótar"),
            keywords: &["nótar", "tónleikur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("notes de musique"),
            keywords: &["musique", "note", "notes", "notes de musique"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("nótaí ceoil"),
            keywords: &["ceol", "nóta", "nótaí", "nótaí ceoil"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("pongan ciùil"),
            keywords: &["ceòl", "pong", "pongan", "pongan ciùil", "puing"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("notas musicais"),
            keywords: &["música", "notas", "notas musicais"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{a82}ગીતની નોટ\u{acd}સ"),
            keywords: &[
                "નોટ",
                "નોટ\u{acd}સ",
                "સ\u{a82}ગીત",
                "સ\u{a82}ગીતની નોટ\u{acd}સ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("rubuce-rubucen kiɗa"),
            keywords: &["kiɗa", "rubuce-rubuce", "rubuce-rubucen kiɗa", "rubutu"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("תווים מוזיקליים"),
            keywords: &["מוזיקה", "תווים", "תווים מוזיקליים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{902}गीत क\u{947} स\u{94d}वर"),
            keywords: &["नोट", "स\u{902}गीत", "स\u{902}गीत क\u{947} स\u{94d}वर"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("glazbene note"),
            keywords: &["glazba", "glazbene note", "nota", "note"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("hangjegyek"),
            keywords: &["hangjegy", "hangjegyek", "zene"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("նոտաներ"),
            keywords: &["երաժշտություն", "նոտա", "նոտաներ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("not-not musik"),
            keywords: &["musik", "not", "not-not musik"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ederede ụdà-egwu gasị"),
            keywords: &["ederede", "ederede ụdà-egwu gasị", "egwu", "ụdà-egwu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("nótur"),
            keywords: &["nóta", "nótur", "tónlist"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("note musicali"),
            keywords: &["musica", "nota", "note", "note musicali"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("複数の音符"),
            keywords: &["8分音符", "複数の音符", "音楽", "音符"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tangga nada"),
            keywords: &["musik", "tangga nada", "tangga nada musik"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მუსიკალური ნოტები"),
            keywords: &["მუსიკა", "მუსიკალური ნოტები", "ნოტები", "ნოტი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tizmilin tiẓawanin"),
            keywords: &["tizmilin tiẓawanin"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ноталар"),
            keywords: &["музыка", "нота", "ноталар"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("noder"),
            keywords: &["musik", "node", "noder"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ណោតភ\u{17d2}លេងដ\u{17bc}ចអក\u{17d2}សរ រ ប\u{17b8}"),
            keywords: &[
                "ណោតភ\u{17d2}លេង",
                "ណោតភ\u{17d2}លេងដ\u{17bc}ចអក\u{17d2}សរ រ ប\u{17b8}",
                "តន\u{17d2}រ\u{17d2}ត\u{17b8}",
                "ភ\u{17d2}លេង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸಂಗೀತ ಟ\u{cbf}ಪ\u{ccd}ಪಣ\u{cbf}ಗಳು"),
            keywords: &[
                "ಟ\u{cbf}ಪ\u{ccd}ಪಣ\u{cbf}",
                "ಟ\u{cbf}ಪ\u{ccd}ಪಣ\u{cbf}ಗಳು",
                "ಸಂಗೀತ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("노래 음표"),
            keywords: &["노래 음표", "음악"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("स\u{902}गीताच\u{947} स\u{94d}वर ३"),
            keywords: &[
                "स\u{902}गीत",
                "स\u{902}गीताच\u{947} स\u{94d}वर",
                "स\u{902}गीताच\u{947} स\u{94d}वर ३",
                "स\u{942}र",
                "स\u{94d}वर",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("музыкалык ноталар"),
            keywords: &["музыка", "музыкалык ноталар", "нота", "ноталар"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Museksnouten"),
            keywords: &["Musek", "Museksnouten", "Nout", "Nouten"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໂນດເພງ"),
            keywords: &["ດ\u{ebb}ນຕ\u{eb5}", "ໂນດເພງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("muzikos natos"),
            keywords: &["muzika", "muzikos natos", "nata", "natos"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("notis"),
            keywords: &["mūzika", "notis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ngā tohu waiata"),
            keywords: &["ngā tohu", "ngā tohu waiata", "puoro", "tohu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("музички ноти"),
            keywords: &["музика", "музички ноти", "ноти"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മ\u{d4d}യ\u{d42}സിക\u{d4d}ക\u{d4d} നോട\u{d4d}ട\u{d41}കൾ"),
            keywords: &[
                "മ\u{d4d}യ\u{d42}സിക\u{d4d}ക\u{d4d}",
                "മ\u{d4d}യ\u{d42}സിക\u{d4d}ക\u{d4d} നോട\u{d4d}ട\u{d41}കൾ",
                "സംഗീതം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хөгжмийн нотнууд"),
            keywords: &["нот", "хөгжим", "хөгжмийн нотнууд"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{902}गीताच\u{947} स\u{942}र"),
            keywords: &[
                "वाद\u{94d}य स\u{94d}वर",
                "स\u{902}गीत",
                "स\u{902}गीताच\u{947} स\u{942}र",
                "स\u{94d}वर",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("nota-nota muzik"),
            keywords: &["muzik", "nota", "nota-nota"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("noti mużikali"),
            keywords: &["mużika", "nota", "noti", "noti mużikali"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဂ\u{102e}တ သင\u{103a}\u{1039}ကေတများ"),
            keywords: &[
                "ဂ\u{102e}တ",
                "ဂ\u{102e}တ သင\u{103a}\u{1039}ကေတများ",
                "န\u{102f}တ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("noter"),
            keywords: &["musikk", "musikknoter", "noter"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{902}गीतको नोट"),
            keywords: &["नोट", "नोटहर\u{942}", "स\u{902}गीतको नोट", "सा\u{902}गीतिक"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("muzieknoten"),
            keywords: &["muziek", "muzieknoten", "noot", "noten"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("notar"),
            keywords: &["musikk", "musikknotar", "notar"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସଙ\u{b4d}ଗୀତ ସମ\u{b4d}ବନ\u{b4d}ଧୀୟ ସ\u{b4d}ୱରଗ\u{b41}ଡ\u{b3c}\u{b3f}କ"),
            keywords: &[
                "ସଙ\u{b4d}ଗୀତ",
                "ସଙ\u{b4d}ଗୀତ ସମ\u{b4d}ବନ\u{b4d}ଧୀୟ ନୋଟ\u{b4d}ସ",
                "ସଙ\u{b4d}ଗୀତ ସମ\u{b4d}ବନ\u{b4d}ଧୀୟ ସ\u{b4d}ୱରଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
                "ସ\u{b4d}ୱର",
                "ସ\u{b4d}ୱରଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a70}ਗੀਤਕ ਸ\u{a41}ਰ"),
            keywords: &[
                "ਸ\u{a41}ਰ",
                "ਸ\u{a70}ਗੀਤ",
                "ਸ\u{a70}ਗੀਤਕ ਨ\u{a4b}ਟਸ",
                "ਸ\u{a70}ਗੀਤਕ ਸ\u{a41}ਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("موسیقی دے نوٹس"),
            keywords: &["ر\u{64f}قعہ", "موسیقی", "موسیقی دے نوٹس", "نوٹس"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Miúzíkál Not-dẹm"),
            keywords: &["Miúzik", "Miúzíkál Not-dẹm", "Not", "Not-dẹm"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("nuty"),
            keywords: &["muzyka", "nuta", "nuty"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د موسیقۍ ساز"),
            keywords: &["د موسیقۍ ساز", "ساز", "سازونه", "موسيقي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("notas musicais"),
            keywords: &["música", "nota", "notas", "notas musicais"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["música", "notas", "notas musicais"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("notas musicales"),
            keywords: &["notas musicales"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("note muzicale"),
            keywords: &["muzică", "note", "note muzicale"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-374"),
            keywords: &["E10-374"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("ноты"),
            keywords: &["звуки", "музыка", "ноты"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("amanota y’umuziki"),
            keywords: &["amanota", "amanota y’umuziki", "inota", "umuziki"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("موسيقي وارا نوٽ"),
            keywords: &["موسيقي", "موسيقي وارا نوٽ", "نوٽ", "نوٽ\u{64e}"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සංග\u{dd3}ත ස\u{dca}වර"),
            keywords: &[
                "සංග\u{dd3}ත ස\u{dca}වර",
                "සංග\u{dd3}තය",
                "ස\u{dca}වර",
                "ස\u{dca}වරය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("noty"),
            keywords: &["hudba", "nota", "noty"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("glasbene note"),
            keywords: &["glasba", "glasbene note", "nota", "note"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qoraalo muusika"),
            keywords: &["muusik", "qoraal", "qoraalo", "qoraalo muusika"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("nota muzikore"),
            keywords: &["muzikë", "nota", "nota muzikore", "notë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("ноте"),
            keywords: &["музика", "музичке ноте", "нота", "ноте"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["ноте"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("note"),
            keywords: &["muzika", "muzičke note", "nota", "note"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["note"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("musiknoter"),
            keywords: &["musik", "musiknoter", "not", "noter"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("manoti ya muziki"),
            keywords: &["manoti", "manoti ya muziki", "muziki", "noti"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("இசைக\u{bcd} குறிப\u{bcd}புகள\u{bcd}"),
            keywords: &[
                "இசைக\u{bcd} குறிப\u{bcd}புகள\u{bcd}",
                "குறிப\u{bcd}பு",
                "குறிப\u{bcd}புகள\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("సంగ\u{c40}త స\u{c4d}వర\u{c3e}లు"),
            keywords: &[
                "సంగ\u{c40}త స\u{c4d}వర\u{c3e}లు",
                "సంగ\u{c40}తం",
                "స\u{c4d}వరం",
                "స\u{c4d}వర\u{c3e}లు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("нотаҳои мусиқӣ"),
            keywords: &["мусиқӣ", "нота", "нотаҳо", "нотаҳои мусиқӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("โน\u{e49}ตดนตร\u{e35}หลายต\u{e31}ว"),
            keywords: &[
                "โน\u{e49}ตดนตร\u{e35}",
                "โน\u{e49}ตดนตร\u{e35}หลายต\u{e31}ว",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("notalar"),
            keywords: &["aýdym-saz", "nota", "notalar"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ngaahi nota"),
            keywords: &["ngaahi nota"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("müzik notaları"),
            keywords: &["müzik", "müzik notaları", "nota", "notalar"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("نوتىلار"),
            keywords: &["مۇزىكا", "نوتا", "نوتىلار"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("музичні ноти"),
            keywords: &["музичний", "музичні ноти", "нота", "ноти"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("میوزیکل نوٹس"),
            keywords: &["موسیقی", "میوزیکل نوٹس", "نوٹس"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("musiqiy notalar"),
            keywords: &["musiqa", "musiqiy notalar", "nota", "notalar"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("các nốt nhạc"),
            keywords: &["các nốt nhạc", "nhạc", "nốt nhạc"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("arafi misik"),
            keywords: &["araf", "araf yi", "arafi misik", "misik"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iinowuthi zomculo"),
            keywords: &["iinowuthi", "iinowuthi zomculo", "inowuthi", "umculo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("nóòtì orin"),
            keywords: &[
                "nóòtì orin",
                "orin",
                "àwọn ò\u{329}rò\u{329}",
                "ọ\u{300}rọ\u{300}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("音樂符號"),
            keywords: &["音樂", "音樂符號", "音符"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("音乐符号"),
            keywords: &["音乐", "音乐符号", "音符"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("多个音符"),
            keywords: &["乐谱", "五线谱", "八分音符", "多个音符", "音乐", "音符"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("樂符"),
            keywords: &["樂符", "音樂"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("三個音符"),
            keywords: &["三個音符", "音樂", "音符｜三個音符"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("amanothi omculo"),
            keywords: &["amanothi", "amanothi omculo", "inothi", "umculo"],
        },
    ],
};
#[doc = "🎙\u{fe0f}"]
pub const STUDIO_MICROPHONE: crate::Emoji = crate::Emoji {
    glyph: "🎙\u{fe0f}",
    codepoint: "1F399 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "studio microphone",
    group: "Objects",
    subgroup: "music",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🎙",
        codepoint: "1F399",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "studio microphone",
        group: "Objects",
        subgroup: "music",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("ateljeemikrofoon"),
            keywords: &["ateljee", "ateljeemikrofoon", "mikrofoon", "musiek"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የስቲዲዮ ማይክራፎን"),
            keywords: &["ሙዚቃ", "ማይክ", "ማይክራፎን", "ስቲዲዮ", "የስቲዲዮ ማይክራፎን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ميكروفون استوديو"),
            keywords: &["استوديو", "مايك", "موسيقى", "ميكروفون"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ষ\u{9cd}ট\u{9c1}ডিঅ’ ম\u{9be}ইক\u{9cd}ৰ’ফোন"),
            keywords: &[
                "ম\u{9be}ইক",
                "ম\u{9be}ইক\u{9cd}ৰ’ফোন",
                "ষ\u{9cd}ট\u{9c1}ডিঅ’",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("studiya mikrafonu"),
            keywords: &["mik", "mikrofon", "musiqi", "studio", "studiya mikrafonu"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("студыйны мікрафон"),
            keywords: &[
                "музыка",
                "музычная",
                "мікрафон",
                "студыйны мікрафон",
                "студыя",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Студиен микрофон"),
            keywords: &["Студиен микрофон", "микрофон", "музика", "студио"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9cd}ট\u{9c1}ডিও ম\u{9be}ইক\u{9cd}রোফোন"),
            keywords: &[
                "ম\u{9be}ইক",
                "ম\u{9be}ইক\u{9cd}রোফোন",
                "সঙ\u{9cd}গীত",
                "স\u{9cd}ট\u{9c1}ডিও",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("mikrofon studio"),
            keywords: &["mikro", "mikrofon", "sonerezh", "studio"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("studijski mikrofon"),
            keywords: &["mikrofon", "pjevanje", "studijski mikrofon", "studio"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("micròfon d’estudi"),
            keywords: &["estudi", "micròfon", "micròfon d’estudi", "música"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏧᏂᏃᎩᏍᏙᏗ ᎧᏅᏑᎸ ᏍᏓᏱ ᎦᏃᏴᎵᏍᏗᏍᎩ"),
            keywords: &[
                "ᎦᏂᏱᏍᎩ",
                "ᏍᏓᏱ ᎦᏃᏴᎵᏍᏗᏍᎩ",
                "ᏗᎧᏃᎩᏍᏗ",
                "ᏧᏂᏃᎩᏍᏙᏗ ᎧᏅᏑᎸ",
                "ᏧᏂᏃᎩᏍᏙᏗ ᎧᏅᏑᎸ ᏍᏓᏱ ᎦᏃᏴᎵᏍᏗᏍᎩ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("studiový mikrofon"),
            keywords: &["hudba", "mikrofon", "studio", "studiový mikrofon"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("meicroffon stiwdio"),
            keywords: &["cerddoriaeth", "meic", "meicroffon", "stiwdio"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("studiemikrofon"),
            keywords: &["mikrofon", "musik", "studie", "studiemikrofon"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Studiomikrofon"),
            keywords: &["Mikrofon", "Studiomikrofon"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μικρόφωνο στούντιο"),
            keywords: &["μικρόφωνο", "μουσική", "στούντιο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("studio microphone"),
            keywords: &["mic", "microphone", "music", "studio"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("micrófono de estudio"),
            keywords: &["estudio", "micrófono", "micrófono de estudio", "música"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("micrófono de grabación"),
            keywords: &[
                "estudio",
                "grabación",
                "micrófono",
                "micrófono de grabación",
                "voz",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("stuudiomikrofon"),
            keywords: &["mikrofon", "muusika", "stuudio", "stuudiomikrofon"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("estudioko mikrofonoa"),
            keywords: &["estudio", "estudioko mikrofonoa", "mikrofono", "musika"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("میکروفون استودیویی"),
            keywords: &["استودیو", "موسیقی", "میکروفون", "میکروفون استودیویی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("studiomikrofoni"),
            keywords: &[
                "levytys",
                "mikrofoni",
                "musiikki",
                "studiomikrofoni",
                "äänitys",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mikroponong pang-studio"),
            keywords: &[
                "kanta",
                "mikropono",
                "mikroponong pang-studio",
                "musika",
                "studio",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("ljóðstovumikrofon"),
            keywords: &["ljóðfatur", "ljóðstovumikrofon", "ljóðtak", "mikrofon"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("micro de studio"),
            keywords: &["micro", "micro de studio"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("micreafón stiúideo"),
            keywords: &["ceol", "mic", "micreafón", "stiúideo"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("micreofon stiùideo"),
            keywords: &["ceòl", "mic", "micreofon", "stiùideo", "stiùidio"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("micrófono de gravación"),
            keywords: &[
                "gravación",
                "micrófono",
                "micrófono de gravación",
                "música",
                "radio",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}ટ\u{ac2}ડિયો માઇક\u{acd}રોફોન"),
            keywords: &[
                "માઇક",
                "માઇક\u{acd}રોફોન",
                "મ\u{acd}ય\u{ac1}ઝિક",
                "સ\u{a82}ગીત",
                "સ\u{acd}ટ\u{ac2}ડિયો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("makurofon na sutudiyo"),
            keywords: &["kiɗa", "makurofon", "makurofon na sutudiyo", "sutudiyo"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מיקרופון אולפן"),
            keywords: &["אולפן", "הקלטה", "מוזיקה", "מיקרופון", "שירה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{94d}ट\u{942}डियो माइक\u{94d}रोफ\u{93c}ोन"),
            keywords: &[
                "माइक",
                "माइक\u{94d}रोफ\u{93c}ोन",
                "स\u{902}गीत",
                "स\u{94d}ट\u{942}डियो",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("studijski mikrofon"),
            keywords: &["glazba", "mikrofon", "studijski mikrofon", "studio"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("stúdiómikrofon"),
            keywords: &["mikrofon", "stúdió", "stúdiómikrofon", "zene"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ստուդիայի խոսափող"),
            keywords: &["երաժշտություն", "խոսափող", "ստուդիա", "ստուդիայի խոսափող"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("mikrofon studio"),
            keywords: &["mik", "mikrofon", "musik", "studio"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("igweokwu nkwụrụonwe ụlọegwu"),
            keywords: &[
                "egwu",
                "igweokwu",
                "igweokwu nkwụrụonwe",
                "igweokwu nkwụrụonwe ụlọegwu",
                "ụlọegwu",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hljóðnemi í hljóðveri"),
            keywords: &["hljóðnemi", "hljóðnemi í hljóðveri", "hljóðver", "tónlist"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("microfono radiofonico"),
            keywords: &[
                "microfoni",
                "microfoni da studio",
                "microfono",
                "microfono da studio",
                "microfono radiofonico",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("スタジオマイク"),
            keywords: &["スタジオマイク", "マイク", "音楽"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("mikropon studio"),
            keywords: &["mik", "mikropon", "musik", "studio"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სტუდიური მიკროფონი"),
            keywords: &["მიკროფონი", "მუსიკა", "სტუდია", "სტუდიური მიკროფონი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("студио микрофоны"),
            keywords: &["мик", "микрофон", "музыка", "студио", "студио микрофоны"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("studiemikrofon"),
            keywords: &["mikrofon", "musik", "studie", "studiemikrofon"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ម\u{17b8}ក\u{17d2}រ\u{17bc}ហ\u{17d2}វ\u{17bc}នស\u{17d2}ទ\u{17bc}ឌ\u{17b8}យ\u{17c9}\u{17bc}",
            ),
            keywords: &[
                "តន\u{17d2}ត\u{17d2}រ\u{17b8}",
                "ម\u{17b8}ក\u{17d2}រ\u{17bc}ហ\u{17d2}វ\u{17bc}ន",
                "ម\u{17b8}ក\u{17d2}រ\u{17bc}ហ\u{17d2}វ\u{17bc}នស\u{17d2}ទ\u{17bc}ឌ\u{17b8}យ\u{17c9}\u{17bc}",
                "ម\u{17c9}ៃក\u{17d2}រ\u{17bc}ហ\u{17d2}វ\u{17bc}ន",
                "ស\u{17d2}ទ\u{17bc}ឌ\u{17b8}យោ",
                "ស\u{17d2}ទ\u{17bc}ឌ\u{17b8}យ\u{17c9}\u{17bc}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{ccd}ಟುಡ\u{cbf}ಯೊ ಮೈಕ\u{ccd}ರೋಫೋನ\u{ccd}"),
            keywords: &[
                "ಮೈಕ\u{ccd}ರೋಫೋನ\u{ccd}",
                "ಮ\u{ccd}ಯ\u{cc2}ಸ\u{cbf}ಕ\u{ccd}",
                "ಸಂಗೀತ",
                "ಸ\u{ccd}ಟುಡ\u{cbf}ಯೊ ಮೈಕ\u{ccd}ರೋಫೋನ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("스튜디오 마이크"),
            keywords: &["마이크", "사회자 마이크", "스튜디오 마이크"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("स\u{94d}ट\u{941}डियो मायक\u{94d}रोफोन"),
            keywords: &[
                "मायक",
                "मायक\u{94d}रोफोन",
                "स\u{902}गीत",
                "स\u{94d}ट\u{941}डियो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("студия микрофону"),
            keywords: &["микрофон", "музыка", "студия", "студия микрофону"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Studiosmikro"),
            keywords: &["Mikro", "Musek", "Studio", "Studiosmikro"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໄມສະຕ\u{eb9}ດ\u{eb5}ໂອ"),
            keywords: &[
                "ສະຕ\u{eb9}ດ\u{eb5}ໂອ",
                "ເພງ",
                "ໄມສະຕ\u{eb9}ດ\u{eb5}ໂອ",
                "ໄມໂຄຣໂຟນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("studijos mikrofonas"),
            keywords: &["mikrofonas", "muzika", "studija", "studijos mikrofonas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("studijas mikrofons"),
            keywords: &["mikrofons", "studija", "studijas mikrofons"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("hopuoro taiwhanga"),
            keywords: &["hopuoro", "puoro", "taiwhanga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("студиски микрофон"),
            keywords: &["микрофон", "музика", "студио", "студиски микрофон"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d4d}റ\u{d4d}റ\u{d41}ഡിയോ മൈക\u{d4d}രോഫോൺ"),
            keywords: &[
                "മൈക\u{d4d}ക\u{d4d}",
                "മൈക\u{d4d}രോഫോൺ",
                "മ\u{d4d}യ\u{d42}സിക\u{d4d}ക\u{d4d}",
                "സംഗീതം",
                "സ\u{d4d}\u{200c}റ\u{d4d}റ\u{d41}ഡിയോ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("студийн микрофон"),
            keywords: &["мик", "микрофон", "студи", "студийн микрофон", "хөгжим"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{94d}ट\u{941}डिओ मायक\u{94d}रोफोन"),
            keywords: &[
                "माइक",
                "मायक\u{94d}रोफान",
                "स\u{902}गीत",
                "स\u{94d}ट\u{941}डिओ",
                "स\u{94d}ट\u{941}डिओ मायक\u{94d}रोफोन",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("mikrofon studio"),
            keywords: &["mikrofon", "muzik", "studio"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("mikrofonu tal-istudjo"),
            keywords: &[
                "mik",
                "mikrofonu",
                "mikrofonu tal-istudjo",
                "mużika",
                "studjo",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "စတ\u{1030}ဒ\u{102e}ယ\u{102d}\u{102f} မ\u{102d}\u{102f}က\u{103a}ကရ\u{102d}\u{102f}ဖ\u{102f}န\u{103a}း",
            ),
            keywords: &[
                "ဂ\u{102e}တ",
                "စတ\u{1030}ဒ\u{102e}ယ\u{102d}\u{102f}",
                "မ\u{102d}\u{102f}က\u{103a}",
                "မ\u{102d}\u{102f}က\u{103a}ကရ\u{102d}\u{102f}ဖ\u{102f}န\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("studiomikrofon"),
            keywords: &["mik", "mikrofon", "musikk", "studio", "studiomikrofon"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}ट\u{941}डियोवाला माइक\u{94d}रोफोन"),
            keywords: &[
                "माइक\u{94d}रोफोन",
                "स\u{902}गीत",
                "स\u{94d}ट\u{941}डियो",
                "स\u{94d}ट\u{941}डियोवाला माइक\u{94d}रोफोन",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("studiomicrofoon"),
            keywords: &["microfoon", "muziek", "studio", "studiomicrofoon"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("studiomikrofon"),
            keywords: &["mik", "mikrofon", "musikk", "studio", "studiomikrofon"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଷ\u{b4d}ଟ\u{b41}ଡ\u{b3f}ଓ ମ\u{b3e}ଇକ\u{b4d}ରୋଫୋନ\u{b4d}\u{200c}"),
            keywords: &[
                "ମ\u{b3e}ଇକ\u{b4d}ରୋଫୋନ\u{b4d}\u{200c}",
                "ମ\u{b3e}ଇକ\u{b4d}\u{200c}",
                "ଷ\u{b4d}ଟ\u{b41}ଡ\u{b3f}ଓ",
                "ସଙ\u{b4d}ଗୀତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਟ\u{a42}ਡੀਓ ਮਾਈਕ\u{a4d}ਰ\u{a4b}ਫ\u{a4b}ਨ"),
            keywords: &[
                "ਮਾਈਕ",
                "ਮਾਈਕ\u{a4d}ਰ\u{a4b}ਫ\u{a4b}ਨ",
                "ਸਟ\u{a42}ਡੀਓ",
                "ਸ\u{a70}ਗੀਤ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سٹوڈیو مائیکروفون"),
            keywords: &["سٹوڈیو", "مائک", "مائیکروفون", "موسیقی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Stúdió Maikrofon"),
            keywords: &["Maik", "Maikrofon", "Miúzik", "Stúdio", "Stúdió Maikrofon"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mikrofon studyjny"),
            keywords: &["mikrofon", "muzyka", "nagrywać", "studio", "studyjny"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د سټوډیو مایکروفون"),
            keywords: &[
                "د سټوډیو مایکروفون",
                "سټوډيو",
                "مايک",
                "مايکروفون",
                "موسيقي",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("microfone de estúdio"),
            keywords: &["estúdio", "microfone", "microfone de estúdio", "música"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("microfone de estúdio"),
            keywords: &["estúdio", "microfone", "microfone de estúdio", "música"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("microfono estudiomanta"),
            keywords: &[
                "estudio",
                "micro",
                "microfono",
                "microfono estudiomanta",
                "takiy",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("microfon de studio"),
            keywords: &["microfon", "microfon de studio", "muzică", "studio"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-347"),
            keywords: &["E10-347"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("студийный микрофон"),
            keywords: &[
                "вокал",
                "звук",
                "микрофон",
                "музыка",
                "пение",
                "студийный микрофон",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("indangururamajwi ya sitidiyo"),
            keywords: &[
                "indangurura",
                "indangururamajwi",
                "indangururamajwi ya sitidiyo",
                "sitidiyo",
                "umuziki",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اسٽوڊيو جو مائيڪروفون"),
            keywords: &[
                "اسٽوڊيو",
                "اسٽوڊيو جو مائيڪروفون",
                "مائيڪ",
                "مائيڪروفون",
                "موسيقي",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ච\u{dd2}ත\u{dca}\u{200d}ර\u{dcf}ග\u{dcf}ර මය\u{dd2}ක\u{dca}\u{200d}රෆෝනය"),
            keywords: &[
                "ච\u{dd2}ත\u{dca}\u{200d}ර\u{dcf}ග\u{dcf}ර මය\u{dd2}ක\u{dca}\u{200d}රෆෝනය",
                "ච\u{dd2}ත\u{dca}\u{200d}ර\u{dcf}ග\u{dcf}රය",
                "මය\u{dd2}ක\u{dca}",
                "මය\u{dd2}ක\u{dca}\u{200d}රෆෝනය",
                "සංග\u{dd3}තය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("štúdiový mikrofón"),
            keywords: &["hudba", "mikrofón", "štúdio", "štúdiový mikrofón"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("studijski mikrofon"),
            keywords: &["glasba", "mikrofon", "studijski mikrofon", "studio"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("mikirifoonka istuudyaha"),
            keywords: &[
                "istuudyow",
                "mik",
                "mikirifoon",
                "mikirifoonka istuudyaha",
                "muusik",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("mikrofon studioje"),
            keywords: &["mikrofon", "mikrofon studioje", "muzikë", "studio"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("студијски микрофон"),
            keywords: &["микрофон", "музика", "студио", "студијски микрофон"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["студијски микрофон"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("studijski mikrofon"),
            keywords: &["mikrofon", "muzika", "studijski mikrofon", "studio"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["studijski mikrofon"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("studiomikrofon"),
            keywords: &["mikrofon", "sjunga", "studiomikrofon"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("maikrofoni ya studio"),
            keywords: &["maikrofoni", "maikrofoni ya studio", "muziki", "studio"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஸ\u{bcd}டூடியோ மைக\u{bcd}ரோஃபோன\u{bcd}"),
            keywords: &[
                "இசை",
                "ப\u{bbe}ட\u{bcd}டு",
                "மைக\u{bcd}",
                "ஸ\u{bcd}டூடியோ மைக\u{bcd}ரோஃபோன\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c4d}టూడ\u{c3f}య\u{c4b} మ\u{c48}క\u{c4d}ర\u{c4b}ఫ\u{c4b}న\u{c4d}"),
            keywords: &[
                "మ\u{c48}క\u{c4d}ర\u{c4b}ఫ\u{c4b}న\u{c4d}",
                "సంగ\u{c40}తం",
                "స\u{c4d}టూడ\u{c3f}య\u{c4b}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("микрофони студия"),
            keywords: &["мик", "микрофон", "микрофони студия", "мусиқӣ", "студия"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ไมค\u{e4c}สต\u{e39}ด\u{e34}โอ"),
            keywords: &[
                "สต\u{e39}ด\u{e34}โอ",
                "เพลง",
                "ไมค\u{e4c}",
                "ไมค\u{e4c}สต\u{e39}ด\u{e34}โอ",
                "ไมโครโฟน",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("studiýa mikrofony"),
            keywords: &[
                "aýdym-saz",
                "mik",
                "mikrofon",
                "studiýa",
                "studiýa mikrofony",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("maikalofone fakamafolalea"),
            keywords: &["maikalofone fakamafolalea"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("stüdyo mikrofonu"),
            keywords: &["mikrofon", "müzik", "stüdyo", "stüdyo mikrofonu"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئىستۇدىيە مىكروفونى"),
            keywords: &[
                "ئىستۇدىيە",
                "ئىستۇدىيە مىكروفونى",
                "مىك",
                "مىكروفون",
                "مۇزىكا",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("студійний мікрофон"),
            keywords: &["музичний", "мікрофон", "студійний мікрофон", "студія"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اسٹوڈیو مائیکروفون"),
            keywords: &["اسٹوڈیو", "مائیک", "مائیکروفون", "موسیقی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("studiya mikrofoni"),
            keywords: &["mikrofon", "musiqa", "studiya", "studiya mikrofoni"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("micrô phòng thu âm"),
            keywords: &["micrô", "micrô phòng thu âm", "nhạc", "phòng thu"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("mikrofonu studio"),
            keywords: &["mikro", "mikrofon", "mikrofonu studio", "misik", "studio"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-microphone yestudiyo"),
            keywords: &[
                "i-mic",
                "i-microphone",
                "i-microphone yestudiyo",
                "istudiyo",
                "umculo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("maikurofóònù sítúdíò"),
            keywords: &[
                "ilé-agódo",
                "maikurofóònù",
                "maikurofóònù sítúdíò",
                "maikì",
                "orin",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("錄音室咪高峰"),
            keywords: &["咪", "咪高峰", "錄音室", "錄音室咪高峰", "音樂"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("录音室咪高峰"),
            keywords: &["咪", "咪高峰", "录音室", "录音室咪高峰", "音乐"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("录音室麦克风"),
            keywords: &["录音室", "录音室麦克风", "音乐", "麦", "麦克", "麦克风"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("錄音室麥克風"),
            keywords: &["錄音室麥克風", "麥克風"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("錄音室咪高風"),
            keywords: &["咪高風", "錄音室咪高風"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("imakhrofoni yasestudiyo"),
            keywords: &[
                "imakhrofoni",
                "imakhrofoni yasestudiyo",
                "imayikhi",
                "istudiyo",
                "umculo",
            ],
        },
    ],
};
#[doc = "🎚\u{fe0f}"]
pub const LEVEL_SLIDER: crate::Emoji = crate::Emoji {
    glyph: "🎚\u{fe0f}",
    codepoint: "1F39A FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "level slider",
    group: "Objects",
    subgroup: "music",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🎚",
        codepoint: "1F39A",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "level slider",
        group: "Objects",
        subgroup: "music",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vlakglyer"),
            keywords: &["glyer", "musiek", "vlak", "vlakglyer"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ማመጣጠኛ አንሸራታች"),
            keywords: &["ሙዚቃ", "ማመጣጠኛ", "አንሸራታች"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شريط منسوب"),
            keywords: &["شريط منسوب", "مؤشر", "مستوى", "موسيقى"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("লেভেল শ\u{9cd}ল\u{9be}ইড\u{9be}ৰ"),
            keywords: &["লেভেল", "শ\u{9cd}ল\u{9be}ইড\u{9be}ৰ", "সংগীত"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("səviyyə slayderi"),
            keywords: &["musiqi", "slayder", "səviyyə", "səviyyə slayderi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("паўзунок"),
            keywords: &["музыка", "паўзунок", "узровень"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Плъзгач за нивото"),
            keywords: &["Плъзгач за нивото", "музика", "ниво", "плъзгач"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("লেবেল স\u{9cd}ল\u{9be}ইড\u{9be}র"),
            keywords: &[
                "ম\u{9be}ত\u{9cd}র\u{9be}",
                "লেবেল স\u{9cd}ল\u{9be}ইড\u{9be}র",
                "সঙ\u{9cd}গীত",
                "স\u{9cd}ল\u{9be}ইড\u{9be}র",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("klizni potenciometar"),
            keywords: &["klizač", "klizni potenciometar", "nivo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("control lliscant de nivell"),
            keywords: &["control lliscant", "control lliscant de nivell", "nivell"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏩᏂᏕᏍᎩ ᎠᏲᏟᏍᎩ"),
            keywords: &["ᎠᏲᏟᏍᎩ", "ᎤᏩᏂᏕᏍᎩ", "ᏗᎧᏃᎩᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("posuvný ovladač hlasitosti"),
            keywords: &[
                "fader",
                "hlasitost",
                "hudba",
                "jezdec",
                "posuvný ovladač hlasitosti",
                "potenciometr",
                "úroveň",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("llithrydd lefel"),
            keywords: &["cerddoriaeth", "lefel", "llithrydd lefel"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("volumenkontrol"),
            keywords: &["musik", "volumenkontrol"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schieberegler"),
            keywords: &["Musik", "Schieberegler"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ρυθμιστικό έντασης"),
            keywords: &["επίπεδο", "μουσική", "ρυθμιστικό", "ρυθμιστικό έντασης"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("level slider"),
            keywords: &["level", "music", "slider"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("control de volumen"),
            keywords: &["control", "control de volumen", "fader", "volumen"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("control deslizante"),
            keywords: &["control deslizante", "deslizar", "música", "nivel"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("liugur"),
            keywords: &["liugur", "muusika", "tase"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("graduatzailea"),
            keywords: &["graduatzailea", "maila", "musika"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("درجه\u{654} تنظیم\u{200c}کننده"),
            keywords: &[
                "درجه\u{654} تنظیم\u{200c}کننده",
                "لغزنده",
                "موسیقی",
                "میزان",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("liukusäädin"),
            keywords: &[
                "liukusäädin",
                "liu’utin",
                "musiikki",
                "valitsin",
                "voimakkuus",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("level slider"),
            keywords: &["antas", "level slider", "musika", "slider"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("dragil"),
            keywords: &[
                "dragil",
                "dragistýrari",
                "ljóðstyrki",
                "ljóðstyrkidragil",
                "stýring",
                "tónleikur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("curseur de niveau"),
            keywords: &["curseur", "curseur de niveau", "musique", "niveau"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("sleamhnán leibhéil"),
            keywords: &[
                "ceol",
                "leibhéal",
                "sleamhnáin",
                "sleamhnáin leibhéil",
                "sleamhnán leibhéil",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sleamhnachan àirde"),
            keywords: &["ceòl", "leibheil", "sleamhnachan", "àirde"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("control desprazable"),
            keywords: &["control", "control desprazable", "música", "volume"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લ\u{ac7}વલ સ\u{acd}લાઇડર"),
            keywords: &[
                "મ\u{acd}ય\u{ac1}ઝિક",
                "લ\u{ac7}વલ સ\u{acd}લાઇડર",
                "સ\u{a82}ગીત",
                "સ\u{acd}લાઇડર",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("majanyin lebur"),
            keywords: &["kiɗa", "lebur", "majanyi", "majanyin lebur"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מחוון עוצמת קול"),
            keywords: &[
                "מחוון",
                "מחוון עוצמת קול",
                "סאונד",
                "עוצמה",
                "צליל",
                "קול",
                "רמה",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ल\u{947}वल स\u{94d}लाइडर"),
            keywords: &["ल\u{947}वल स\u{94d}लाइडर", "स\u{902}गीत", "स\u{94d}लाइडर"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kliznik za podešavanje"),
            keywords: &["glazba", "klizač", "kliznik za podešavanje", "razina"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("csúszka"),
            keywords: &["csúszka", "hangerő", "zene"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ձայնի բարձրության սահոց"),
            keywords: &[
                "երաժշտություն",
                "ձայնի բարձրության սահոց",
                "մակարդակ",
                "սահոց",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("penggeser tingkat"),
            keywords: &["level", "musik", "penggeser", "penggeser tingkat"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ogo mkpọmbufè"),
            keywords: &["egwu", "mkpọmbufè", "ogo"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hljóðstyrkssleði"),
            keywords: &["hljóðstyrkssleði", "hljóðstyrkur", "sleði", "tónlist"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cursore del volume"),
            keywords: &[
                "abbassare il volume",
                "alzare il volume",
                "cursore del volume",
                "levetta del volume",
                "regolazione volume",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("レベルスライダー"),
            keywords: &["スライダー", "レベル", "レベルスライダー", "音楽"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("panggeser tingkat"),
            keywords: &["musik", "panggeser", "tingkat"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დონის გადამრთველი"),
            keywords: &["გადამრთველი", "დონე", "დონის გადამრთველი", "მუსიკა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("деңгей сырғытпасы"),
            keywords: &["деңгей", "деңгей сырғытпасы", "музыка", "сырғытпа"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("volumenkontrol"),
            keywords: &["musik", "volumenkontrol"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("របារ\u{17c6}ក\u{17b7}លក\u{17c6}រ\u{17b7}ត"),
            keywords: &[
                "កម\u{17d2}រ\u{17b7}ត",
                "តន\u{17d2}ត\u{17d2}រ\u{17b8}",
                "របាររ\u{17c6}ក\u{17b7}ល",
                "របារ\u{17c6}ក\u{17b7}លក\u{17c6}រ\u{17b7}ត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಲ\u{cc6}ವ\u{cc6}ಲ\u{ccd} ಸ\u{ccd}ಲೈಡರ\u{ccd}"),
            keywords: &[
                "ಮಟ\u{ccd}ಟ",
                "ಮ\u{ccd}ಯ\u{cc2}ಸ\u{cbf}ಕ\u{ccd}",
                "ಲ\u{cc6}ವ\u{cc6}ಲ\u{ccd} ಸ\u{ccd}ಲೈಡರ\u{ccd}",
                "ಸ\u{ccd}ಲೈಡರ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("레벨 슬라이더"),
            keywords: &["레벨 슬라이더", "음악"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पातळी स\u{94d}लायडर"),
            keywords: &["पातळी", "स\u{902}गीत", "स\u{94d}लायडर"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("нивелир"),
            keywords: &[
                "музыка",
                "нивелир",
                "сыдырма",
                "үндү катуулатып акырындаткыч",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Reegler"),
            keywords: &["Musek", "Niveau", "Reegler"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຕ\u{ebb}ວເລ\u{eb7}\u{ec8}ອນລະດ\u{eb1}ບສຽງ"),
            keywords: &[
                "ຕ\u{ebb}ວເລ\u{eb7}\u{ec8}ອນ",
                "ຕ\u{ebb}ວເລ\u{eb7}\u{ec8}ອນລະດ\u{eb1}ບສຽງ",
                "ລະດ\u{eb1}ບ",
                "ສຽງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("lygio slankiklis"),
            keywords: &["lygio slankiklis", "lygis", "muzika", "slankiklis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("skaļuma slīdnis"),
            keywords: &["mūzika", "skaļuma slīdnis", "skaļums", "slīdnis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rēreti puoro"),
            keywords: &["puoro", "rēreti", "taumata"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лизгач"),
            keywords: &["лизгач", "музика", "ниво"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ലെവൽ സൈഡർ"),
            keywords: &[
                "മ\u{d4d}യ\u{d42}സിക\u{d4d}ക\u{d4d}",
                "ലെവെൽ",
                "ലെവൽ സൈഡർ",
                "സംഗീതം",
                "സ\u{d4d}ലൈഡർ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дууны түвшин тохируулагч"),
            keywords: &[
                "дууны түвшин тохируулагч",
                "тохируулагч",
                "түвшин",
                "хөгжим",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पातळी कमी जास\u{94d}त करणारा स\u{94d}लायडर"),
            keywords: &[
                "पातळी",
                "पातळी कमी जास\u{94d}त करणारा स\u{94d}लायडर",
                "स\u{902}गीत",
                "स\u{94d}लायडर",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pelungsur aras"),
            keywords: &["aras", "muzik", "pelungsur"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("slajder tal-livell"),
            keywords: &["livell", "mużika", "slajder", "slajder tal-livell"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အသ\u{1036} ည\u{103e}\u{102d}တ\u{1036}"),
            keywords: &[
                "ဂ\u{102e}တ",
                "ည\u{103e}\u{102d}တ\u{1036}",
                "အသ\u{1036} ည\u{103e}\u{102d}တ\u{1036}",
                "အသ\u{1036}ည\u{103e}\u{102d}တ\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("glidebryter"),
            keywords: &["glidebryter", "musikk", "nivå", "skyveknapp"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}तरसम\u{94d}बन\u{94d}धी स\u{94d}लाइडर"),
            keywords: &[
                "स\u{902}गीत",
                "स\u{94d}तर",
                "स\u{94d}तरसम\u{94d}बन\u{94d}धी स\u{94d}लाइडर",
                "स\u{94d}लाइडर",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("schuifregelaar"),
            keywords: &["muziek", "niveau", "schuifregelaar"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("glidebrytar"),
            keywords: &["glidebrytar", "musikk", "nivå", "skuveknapp"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b4d}ତର ସ\u{b4d}ଲ\u{b3e}ଇଡର\u{b4d}\u{200c}"),
            keywords: &[
                "ସଙ\u{b4d}ଗୀତ",
                "ସ\u{b4d}ତର",
                "ସ\u{b4d}ତର ସ\u{b4d}ଲ\u{b3e}ଇଡର\u{b4d}\u{200c}",
                "ସ\u{b4d}ଲ\u{b3e}ଇଡ\u{b3c}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲ\u{a48}ਵਲ ਸਲਾਈਡਰ"),
            keywords: &["ਪ\u{a71}ਧਰ", "ਲ\u{a48}ਵਲ ਸਲਾਈਡਰ", "ਸਲਾਈਡਰ", "ਸ\u{a70}ਗੀਤ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("لیول سلائیڈر"),
            keywords: &["سلائیڈر", "لیول سلائیڈر", "موسیقی", "ہموار کرنا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Lẹ\u{301}vúl Slaídá Kọntrol"),
            keywords: &[
                "Lẹ\u{301}vul",
                "Lẹ\u{301}vúl Slaídá",
                "Lẹ\u{301}vúl Slaídá Kọntrol",
                "Miúzik",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("suwak miksera dźwięku"),
            keywords: &["muzyka", "poziom", "suwak", "suwak miksera dźwięku"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لیول سلایډر"),
            keywords: &["سلايډر", "ليول", "لیول سلایډر", "موسيقي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("controle de volume"),
            keywords: &["controle", "controle de volume", "música", "volume"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("controlo de nível"),
            keywords: &["controlo de nível", "música", "nível", "seletor"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("kuyuq ñiqi"),
            keywords: &["kuyuq", "takiy", "ñiqi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("glisor de nivel"),
            keywords: &["glisor", "glisor de nivel", "muzică", "nivel"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-348"),
            keywords: &["E10-348"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("слайдер"),
            keywords: &["музыка", "слайдер", "уровень"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("akagaragazarugero"),
            keywords: &["akagaragazarugero", "umuziki", "urugero"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ليول سلائيڊر"),
            keywords: &["حد", "سلائيڊر", "ليول سلائيڊر", "موسيقي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ලෙවල\u{dca} ස\u{dca}ලය\u{dd2}ඩරය"),
            keywords: &[
                "මට\u{dca}ටම",
                "ලෙවල\u{dca} ස\u{dca}ලය\u{dd2}ඩරය",
                "සංග\u{dd3}තය",
                "ස\u{dca}ලය\u{dd2}ඩරය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("posúvač"),
            keywords: &["hudba", "posúvač", "úroveň"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("drsnik za raven"),
            keywords: &["drsnik", "drsnik za raven", "glasba", "raven"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("heer qaade/dejiye"),
            keywords: &["heer", "muusik", "qaade/dejiye"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("rrëshqitësi i nivelit"),
            keywords: &["muzikë", "nivel", "rrëshqitës", "rrëshqitësi i nivelit"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("клизач за подешавање"),
            keywords: &["клизач", "клизач за подешавање", "музика", "ниво"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["клизач за подешавање"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("klizač za podešavanje"),
            keywords: &["klizač", "klizač za podešavanje", "muzika", "nivo"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["klizač za podešavanje"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("nivåreglage"),
            keywords: &["nivåreglage", "reglage"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitelezi cha kurekebisha sauti"),
            keywords: &[
                "kitelezi",
                "kitelezi cha kurekebisha sauti",
                "kiwango",
                "muziki",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("லெவல\u{bcd} ஸ\u{bcd}லைடர\u{bcd}"),
            keywords: &[
                "இசை",
                "லெவல\u{bcd} ஸ\u{bcd}லைடர\u{bcd}",
                "ஸ\u{bcd}லைடர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ల\u{c46}వల\u{c4d} స\u{c4d}లయ\u{c3f}డర\u{c4d}"),
            keywords: &[
                "ల\u{c46}వల\u{c4d}",
                "సంగ\u{c40}తం",
                "స\u{c4d}లయ\u{c3f}డర\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("василаи лағжандаи сатҳ"),
            keywords: &[
                "василаи лағжанда",
                "василаи лағжандаи сатҳ",
                "мусиқӣ",
                "сатҳ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ท\u{e35}\u{e48}ปร\u{e31}บระด\u{e31}บเส\u{e35}ยง"),
            keywords: &[
                "ท\u{e35}\u{e48}ปร\u{e31}บ",
                "ท\u{e35}\u{e48}ปร\u{e31}บระด\u{e31}บเส\u{e35}ยง",
                "ระด\u{e31}บ",
                "เพลง",
                "เส\u{e35}ยง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("dereje süýşüriji"),
            keywords: &["aýdym-saz", "dereje", "süýşüriji"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻatoʻo tohoʻi"),
            keywords: &["meʻatoʻo tohoʻi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ayarlama çubuğu"),
            keywords: &["ayar çubuğu", "ayarlama çubuğu", "kol", "müzik"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("دەرىجە سىيرىگۈچ"),
            keywords: &["دەرىجە", "سىيرىگۈچ", "مۇزىكا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("повзунок рівня"),
            keywords: &["бігунець рівня", "музичний", "повзунок", "повзунок рівня"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("لیول سلائیڈر"),
            keywords: &["سلائیڈر", "لیول", "موسیقی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("daraja slayderi"),
            keywords: &["daraja", "daraja slayderi", "musiqa", "slayder"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("thanh trượt mức"),
            keywords: &["mức", "nhạc", "thanh trượt", "thanh trượt mức"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xàjjalekaayu dayo"),
            keywords: &["dayo", "misik", "xàjjalekaay", "xàjjalekaayu dayo"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("islayida seqondo"),
            keywords: &["iqondo", "islayida seqondo", "islayisda", "umculo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ìpele yíyò\u{329}"),
            keywords: &["ipele", "orin", "yíyò\u{329}", "ìpele yíyò\u{329}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("級別滑塊"),
            keywords: &["滑塊", "級別", "級別滑塊", "音樂"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("级别滑块"),
            keywords: &["滑块", "级别", "级别滑块", "音乐"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("电平滑块"),
            keywords: &["滑块", "电平", "电平滑块", "调节", "音乐"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("調整桿"),
            keywords: &["調整桿"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("滑桿"),
            keywords: &["滑桿", "滑桿 ｜音樂"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("izinga lesilawuli"),
            keywords: &["izinga", "izinga lesilawuli", "okokulawula", "umculo"],
        },
    ],
};
#[doc = "🎛\u{fe0f}"]
pub const CONTROL_KNOBS: crate::Emoji = crate::Emoji {
    glyph: "🎛\u{fe0f}",
    codepoint: "1F39B FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "control knobs",
    group: "Objects",
    subgroup: "music",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🎛",
        codepoint: "1F39B",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "control knobs",
        group: "Objects",
        subgroup: "music",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kontroleknoppe"),
            keywords: &["knoppe", "kontrole", "kontroleknoppe", "musiek"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መቆጣጠሪያ ቁልፎች"),
            keywords: &["መቆጣጠሪያ", "መቆጣጠሪያ ቁልፎች", "ሙዚቃ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("أزرار تحكم"),
            keywords: &["أزرار", "تحكم", "موسيقى"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("নিয\u{9bc}ন\u{9cd}ত\u{9cd}ৰক ব\u{9c1}ট\u{9be}ম"),
            keywords: &[
                "নিয\u{9bc}ন\u{9cd}ত\u{9cd}ৰক ব\u{9c1}ট\u{9be}ম",
                "নিয\u{9bc}ন\u{9cd}ত\u{9cd}ৰণ",
                "ব\u{9c1}ট\u{9be}ম",
                "সংগীত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("idarə düymələri"),
            keywords: &["düymə", "idarə", "idarə düymələri", "musiqi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("рэгулятары"),
            keywords: &["музыка", "рэгуляванне", "рэгулятар", "рэгулятары"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Копчета за управление"),
            keywords: &[
                "Копчета за управление",
                "музика",
                "ръкохватки",
                "управление",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("নিয\u{9bc}ন\u{9cd}ত\u{9cd}রণ বোত\u{9be}ম"),
            keywords: &[
                "নব",
                "নিয\u{9bc}ন\u{9cd}ত\u{9cd}রণ",
                "নিয\u{9bc}ন\u{9cd}ত\u{9cd}রণ বোত\u{9be}ম",
                "সঙ\u{9cd}গীত",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("potenciometar"),
            keywords: &["dugmad", "kontrola", "potenciometar"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botons de control"),
            keywords: &["botons", "botons de control", "control", "música"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎯᎸᏍᏗ ᏗᎦᏂᏱᏙᏗ"),
            keywords: &["ᎠᎯᎸᏍᏗ", "ᏗᎦᏂᏱᏙᏗ", "ᏗᎧᏃᎩᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("ovládací knoflíky"),
            keywords: &[
                "hudba",
                "otočný",
                "ovládací knoflíky",
                "ovládání",
                "potenciometr",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dyrnau rheoli"),
            keywords: &["cerddoriaeth", "dyrnau", "rheoli"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("knapper"),
            keywords: &["knapper", "musik"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Drehregler"),
            keywords: &["Bedienknöpfe", "Drehregler", "Stellknöpfe"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κουμπιά ελέγχου"),
            keywords: &["έλεγχος", "κουμπιά", "κουμπιά ελέγχου", "μουσική"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("control knobs"),
            keywords: &["control", "knobs", "music"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ruedas de control"),
            keywords: &[
                "control",
                "diales",
                "música",
                "potenciómetros",
                "ruedas",
                "ruedas de control",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("perillas"),
            keywords: &[
                "control",
                "diales",
                "música",
                "perillas",
                "potenciómetros",
                "ruedas",
                "ruedas de control",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("perillas"),
            keywords: &[
                "control",
                "diales",
                "música",
                "perillas",
                "potenciómetros",
                "ruedas",
                "ruedas de control",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("botones de control"),
            keywords: &["botones", "botones de control", "control", "música"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("juhtnupud"),
            keywords: &["heli", "juhtnupud", "muusika", "nupud"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kontrolak"),
            keywords: &["kontrol", "kontrolak", "musika"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دسته\u{200c}های کنترل"),
            keywords: &["دسته", "دسته\u{200c}های کنترل", "موسیقی", "کنترل"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("säätimet"),
            keywords: &["musiikki", "nuppi", "säädin", "säätimet"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mga control knob"),
            keywords: &["kontrol", "mga control knob", "mga knob", "musika"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("stýringsknøttar"),
            keywords: &["stýring", "stýringsknøttar", "tónleikur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("boutons de réglage"),
            keywords: &["boutons", "boutons de commande", "boutons de réglage"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cnaipí rialaithe"),
            keywords: &["ceol", "cnaipí", "rialaithe"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("putanan-smachd"),
            keywords: &["ceòl", "putan", "putanan-smachd", "smachd"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("botóns de control"),
            keywords: &["botóns", "botóns de control", "control", "música"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કન\u{acd}ટ\u{acd}રોલ નોબ\u{acd}સ"),
            keywords: &[
                "કન\u{acd}ટ\u{acd}રોલ",
                "નોબ\u{acd}સ",
                "મ\u{acd}ય\u{ac1}ઝિક",
                "સ\u{a82}ગીત",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mamurɗin sarrafa"),
            keywords: &["kiɗa", "mamurɗi", "mamurɗin sarrafa", "sarrafa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כפתורי עוצמת קול"),
            keywords: &[
                "ווליום",
                "כפתורי עוצמת קול",
                "כפתורים",
                "מוזיקה",
                "עוצמת קול",
                "שליטה",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("क\u{902}ट\u{94d}रोल नॉब"),
            keywords: &["क\u{902}ट\u{94d}रोल", "नॉब", "स\u{902}गीत"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kontrolni gumbi"),
            keywords: &["glazba", "gumbi", "kontrola", "kontrolni gumbi"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("vezérlőgombok"),
            keywords: &["gombok", "irányítás", "vezérlőgombok", "zene"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կառավարման կոճակներ"),
            keywords: &[
                "երաժշտություն",
                "կառավարել",
                "կառավարման կոճակներ",
                "կոճակներ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kenop kontrol"),
            keywords: &["kenop", "kontrol", "musik"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("njizi kọbụ gasị"),
            keywords: &["ebe njideaka gasị", "egwu", "njizi", "njizi kọbụ gasị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("stýritakkar"),
            keywords: &["stýring", "stýritakkar", "takkar", "tónlist"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("manopole di controllo"),
            keywords: &[
                "manopole",
                "manopole del volume",
                "manopole di controllo",
                "regolazione volume",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("コントロールつまみ"),
            keywords: &[
                "つまみ",
                "コントロール",
                "コントロールつまみ",
                "ノブ",
                "音楽",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kenop kontrol"),
            keywords: &["kenop", "kontrol", "musik"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მართვის ღილაკები"),
            keywords: &["მართვა", "მართვის ღილაკები", "მუსიკა", "ღილაკები"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("басқару түймелері"),
            keywords: &["басқару", "басқару түймелері", "музыка", "түймелер"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("knapper"),
            keywords: &["knapper", "musik"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ដ\u{17bb}\u{17c6}ស\u{17ca}\u{17b8}រេ"),
            keywords: &[
                "ដ\u{17bb}\u{17c6}សារ\u{17c9}េ",
                "ដ\u{17bb}\u{17c6}ស\u{17ca}\u{17b8}រេ",
                "តន\u{17d2}ត\u{17d2}រ\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹ\u{cbf}ಗ\u{ccd}ಗುವ\u{cbf}ಕ\u{cc6} ನ\u{cbf}ಯಂತ\u{ccd}ರಣ"),
            keywords: &[
                "ನ\u{cbf}ಯಂತ\u{ccd}ರಣ",
                "ಮ\u{ccd}ಯ\u{cc2}ಸ\u{cbf}ಕ\u{ccd}",
                "ಹ\u{cbf}ಗ\u{ccd}ಗುವ\u{cbf}ಕ\u{cc6} ನ\u{cbf}ಯಂತ\u{ccd}ರಣ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("컨트롤 레버"),
            keywords: &["조작 레버", "컨트롤 레버"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("निय\u{902}त\u{94d}रण बटण"),
            keywords: &["निय\u{902}त\u{94d}रण", "बटण", "स\u{902}गीत"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("көзөмөл баскычтары"),
            keywords: &["баскыч", "көзөмөл", "көзөмөл баскычтары", "музыка"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Steierungsknäppercher"),
            keywords: &["Knäppercher", "Musek", "Steierung", "Steierungsknäppercher"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{eb8}\u{ec8}ມຄວບຄ\u{eb8}ມ"),
            keywords: &[
                "ຄວບຄ\u{eb8}ມ",
                "ປ\u{eb8}\u{ec8}ມ",
                "ປ\u{eb8}\u{ec8}ມຄວບຄ\u{eb8}ມ",
                "ສຽງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("valdymo rankenos"),
            keywords: &["muzika", "rankenos", "valdymas", "valdymo rankenos"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("slēdži"),
            keywords: &["mūzika", "pogas", "slēdži", "vadība"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ngā puku mana"),
            keywords: &["ngā puku", "ngā puku mana", "paemana", "puoro"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("копчиња за управување"),
            keywords: &["контрола", "копчиња", "копчиња за управување", "музика"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കൺട\u{d4d}രോൾ നോബ\u{d41}കൾ"),
            keywords: &[
                "കൺട\u{d4d}രോൾ",
                "കൺട\u{d4d}രോൾ നോബ\u{d41}കൾ",
                "നോബ\u{d4d}\u{200c}സ\u{d4d}",
                "മ\u{d4d}യ\u{d42}സിക\u{d4d}ക\u{d4d}",
                "സംഗീതം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("тохируулагч"),
            keywords: &["товчлуур", "тохируулагч", "хөгжим"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("निय\u{902}त\u{94d}रणाच\u{947} नॉब"),
            keywords: &[
                "निय\u{902}त\u{94d}रण",
                "निय\u{902}त\u{94d}रणाच\u{947} नॉब",
                "नॉब",
                "स\u{902}गीत",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tombol kawalan"),
            keywords: &["kawalan", "muzik", "tombol"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("pumi tal-kontroll"),
            keywords: &["kontroll", "pumi", "pumi tal-kontroll", "tal-mużika"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ထ\u{102d}န\u{103a}းချ\u{102f}ပ\u{103a}မ\u{103e}\u{102f} ခလ\u{102f}တ\u{103a}များ",
            ),
            keywords: &[
                "ခလ\u{102f}တ\u{103a}များ",
                "ဂ\u{102e}တ",
                "ထ\u{102d}န\u{103a}းချ\u{102f}ပ\u{103a}မ\u{103e}\u{102f}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kontrollbrytere"),
            keywords: &[
                "brytere",
                "knotter",
                "kontroll",
                "kontrollbrytere",
                "musikk",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("नियन\u{94d}त\u{94d}रणसम\u{94d}बन\u{94d}धी नबहर\u{942}"),
            keywords: &[
                "नबहर\u{942}",
                "नियन\u{94d}त\u{94d}रण",
                "नियन\u{94d}त\u{94d}रणसम\u{94d}बन\u{94d}धी नबहर\u{942}",
                "स\u{902}गीत",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("controleknoppen"),
            keywords: &["bediening", "controleknoppen", "knoppen", "muziek"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kontrollbrytarar"),
            keywords: &[
                "brytarar",
                "knottar",
                "kontroll",
                "kontrollbrytarar",
                "musikk",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ନ\u{b3f}ୟନ\u{b4d}ତ\u{b4d}ରଣ ନବ\u{b4d}"),
            keywords: &[
                "ନବ\u{b4d}\u{200c}\u{200c}\u{200c}\u{200c}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
                "ନ\u{b3f}ୟନ\u{b4d}ତ\u{b4d}ରଣ",
                "ନ\u{b3f}ୟନ\u{b4d}ତ\u{b4d}ରଣ ନବ\u{b4d}",
                "ସଙ\u{b4d}ଗୀତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a70}ਟਰ\u{a4b}ਲ ਬਟਨ"),
            keywords: &["ਕ\u{a70}ਟਰ\u{a4b}ਲ", "ਬਟਨ", "ਸ\u{a70}ਗੀਤ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کنٹرول کرن آلے نابز"),
            keywords: &[
                "موسیقی",
                "موٹھ آلی لاٹھی",
                "کنٹرول کرن آلے نابز",
                "کنٹرول کرنا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kọntról Bọ\u{301}tin"),
            keywords: &["Bọ\u{301}tin", "Kọntrol", "Kọntról Bọ\u{301}tin", "Miúzik"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pokrętła"),
            keywords: &["gałki", "muzyka", "pokrętła"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د کنټرول غوټې"),
            keywords: &["د کنټرول غوټې", "غوټې", "موسيقي", "کنټرول"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("botões giratórios"),
            keywords: &["botões", "botões giratórios", "controle", "música"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("botões de controlo"),
            keywords: &["botões", "botões de controlo", "comando", "música"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("perillas patachaqpaq"),
            keywords: &["patachaq", "perillas", "perillas patachaqpaq", "takiy"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("butoane de control"),
            keywords: &[
                "butoane",
                "butoane de control",
                "muzică",
                "reglaj",
                "reglare",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-349"),
            keywords: &["E10-349"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("регуляторы"),
            keywords: &[
                "звук",
                "музыка",
                "регулятор",
                "регуляторы",
                "ручка",
                "уровень",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("buto zo kugenzura"),
            keywords: &["buto", "buto zo kugenzura", "kugenzura", "umuziki"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪنٽرول نابس"),
            keywords: &["موسيقي", "نابس", "ڪنٽرول"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dcf}ලන බොත\u{dca}තම\u{dca}"),
            keywords: &[
                "ප\u{dcf}ලන බොත\u{dca}තම\u{dca}",
                "ප\u{dcf}ලනය",
                "බොත\u{dca}තම\u{dca}",
                "සංග\u{dd3}තය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("gombíky"),
            keywords: &["gombíky", "hudba", "ovládanie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kontrolni gumbi"),
            keywords: &["glasba", "gumbi", "kontrolni gumbi", "kontrolnik"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("badhanada kaantaroolida"),
            keywords: &["badhanada kaantaroolida", "badhano", "kaantarool", "muusik"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("çelësat e kontrollit"),
            keywords: &["kontroll", "muzikë", "çelësa", "çelësat e kontrollit"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("контролна дугмад"),
            keywords: &["дугмад", "контрола", "контролна дугмад", "музика"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["контролна дугмад"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kontrolna dugmad"),
            keywords: &["dugmad", "kontrola", "kontrolna dugmad", "muzika"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["kontrolna dugmad"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("reglagevred"),
            keywords: &["musik", "reglage", "reglagevred"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("vitufe vya kudhibiti"),
            keywords: &["muziki", "vidhibiti", "vitufe", "vitufe vya kudhibiti"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கன\u{bcd}ட\u{bcd}ரோல\u{bcd} நோப\u{bcd}ஸ\u{bcd}"),
            keywords: &["இசை", "கன\u{bcd}ட\u{bcd}ரோல\u{bcd} நோப\u{bcd}ஸ\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("న\u{c3f}యంత\u{c4d}రణ న\u{c3e}బ\u{c4d}\u{200c}లు"),
            keywords: &[
                "కంట\u{c4d}ర\u{c4b}ల\u{c4d}",
                "న\u{c3e}బ\u{c4d}\u{200c}లు",
                "న\u{c3f}యంత\u{c4d}రణ",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дастаҳои идора"),
            keywords: &["дастаҳо", "дастаҳои идора", "идора", "мусиқӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ป\u{e38}\u{e48}มควบค\u{e38}มเส\u{e35}ยง"),
            keywords: &[
                "ควบค\u{e38}ม",
                "ปร\u{e31}บ",
                "ป\u{e38}\u{e48}ม",
                "ป\u{e38}\u{e48}มควบค\u{e38}มเส\u{e35}ยง",
                "เพลง",
                "เส\u{e35}ยง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("dolandyryş nurbatlary"),
            keywords: &[
                "aýdym-saz",
                "dolandyrmak",
                "dolandyryş nurbatlary",
                "nurbatlar",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻatoʻo puleʻi"),
            keywords: &["meʻatoʻo puleʻi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kontrol düğmeleri"),
            keywords: &["düğme", "kontrol", "kontrol düğmeleri", "müzik"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تىزگىن تۇتقا"),
            keywords: &["تىزگىن", "تۇتقا", "مۇزىكا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("обертові регулятори"),
            keywords: &[
                "елемент керування",
                "круглі регулятори",
                "музичний",
                "обертові регулятори",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کنٹرول کرنے والی نابز"),
            keywords: &["موسیقی", "نابز", "کنٹرول", "کنٹرول کرنے والی نابز"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ovoz boshqarish paneli"),
            keywords: &[
                "boshqarish",
                "burama",
                "musiqa",
                "ovoz boshqarish paneli",
                "panel",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("núm điều khiển"),
            keywords: &["nhạc", "núm", "núm điều khiển", "điều khiển"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bitoŋu yokk/wàññi"),
            keywords: &["bitoŋ", "bitoŋu yokk/wàññi", "misik", "yokk/wàññi"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("amaqhosha olawulo"),
            keywords: &["amaqhosha", "amaqhosha olawulo", "isilawuli", "umculo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("kókó ibìdárí"),
            keywords: &["kókó", "kókó ibìdárí", "olùdarí", "orin"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("控制旋鈕"),
            keywords: &["控制", "控制旋鈕", "鈕", "音樂"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("控制旋钮"),
            keywords: &["控制", "控制旋钮", "钮", "音乐"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("控制旋钮"),
            keywords: &["控制", "控制旋钮", "旋钮", "调节", "音乐"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("控制旋鈕"),
            keywords: &["控制旋鈕", "旋鈕"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["控制旋鈕", "音樂"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("izinkinobho zezilawuli"),
            keywords: &[
                "izinkinobho",
                "izinkinobho zezilawuli",
                "ukulawula",
                "umculo",
            ],
        },
    ],
};
#[doc = "🎤"]
pub const MICROPHONE: crate::Emoji = crate::Emoji {
    glyph: "🎤",
    codepoint: "1F3A4",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "microphone",
    group: "Objects",
    subgroup: "music",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("mikrofoon"),
            keywords: &["karaoke", "mikrofoon", "musiek"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ማይክራፎን"),
            keywords: &["ማይክ", "ማይክራፎን", "ካሮኬ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ميكروفون"),
            keywords: &["كاراوكي", "مايك", "ميكروفون"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ম\u{9be}ইক\u{9cd}ৰ’ফোন"),
            keywords: &[
                "ক\u{9be}ৰ\u{9be}ওকি",
                "ম\u{9be}ইক",
                "ম\u{9be}ইক\u{9cd}ৰ’ফোন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("mikrofon"),
            keywords: &["karaoke", "mik", "mikrofon"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мікрафон"),
            keywords: &["караоке", "музыка", "мікрафон"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("микрофон"),
            keywords: &["караоке", "микрофон"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9be}ইক\u{9cd}রোফোন"),
            keywords: &[
                "ক\u{9be}র\u{9be}ওকে",
                "ম\u{9be}ইক",
                "ম\u{9be}ইক\u{9cd}রোফোন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("mikrofon"),
            keywords: &["mikro", "mikrofon", "sonerezh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("mikrofon"),
            keywords: &["karaoke", "mikrofon", "pjevanje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("micròfon"),
            keywords: &["karaoke", "micròfon"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄟\u{1112d}𑄇\u{11133}𑄢\u{1112e}𑄜\u{1112e}𑄚\u{11134}"),
            keywords: &["𑄟\u{1112d}𑄇\u{11133}𑄢\u{1112e}𑄜\u{1112e}𑄚\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏫᎦᏬᏂᏍᏙᏗ"),
            keywords: &["ᎦᏂᏱᏍᎩ", "ᏓᏂᏃᎩᏍᎬ", "ᏫᎦᏬᏂᏍᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mikrofon"),
            keywords: &["karaoke", "mikrofon"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("meicroffon"),
            keywords: &["caraoce", "meic", "meicroffon"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mikrofon"),
            keywords: &["karaoke", "mikrofon", "sang", "synge"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Mikrofon"),
            keywords: &["Karaoke", "Mikrofon", "Singen", "Unterhaltung"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μικρόφωνο"),
            keywords: &["καραόκε", "μικρόφωνο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("microphone"),
            keywords: &["karaoke", "mic", "microphone"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("micrófono"),
            keywords: &["entretenimiento", "karaoke", "micro", "micrófono"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["entretenimiento", "karaoke", "micrófono", "música"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("mikrofon"),
            keywords: &["karaoke", "mikrofon"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("mikrofonoa"),
            keywords: &["karaoke", "mikrofono", "mikrofonoa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("میکروفون"),
            keywords: &["میکروفون", "کارائوکه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("mikrofoni"),
            keywords: &["karaoke", "mikki", "mikrofoni"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mikropono"),
            keywords: &["karaoke", "mik", "mikropono"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("mikrofon"),
            keywords: &["karaoke", "ljóðfatur", "ljóðtak", "mikrofon"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("micro"),
            keywords: &["karaoke", "micro"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("micreafón"),
            keywords: &["karoke", "micreafón", "siamsaíocht"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("micreofon"),
            keywords: &["karaoke", "mic", "micreofon"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("micrófono"),
            keywords: &["karaoke", "micrófono"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("માઇક\u{acd}રોફોન"),
            keywords: &["કારાઓક", "મનોર\u{a82}જન", "માઇક", "માઇક\u{acd}રોફોન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("makurofon"),
            keywords: &["karaoke", "makurofon"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מיקרופון"),
            keywords: &["הקלטה", "מוזיקה", "מיקרופון", "קריוקי", "שירה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("माइक\u{94d}रोफ\u{93c}ोन"),
            keywords: &["क\u{948}रिओकी", "माइक", "माइक\u{94d}रोफ\u{93c}ोन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("mikrofon"),
            keywords: &["karaoke", "mikrofon"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("mikrofon"),
            keywords: &["hangjegyek", "karaoke", "mikrofon", "zene"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("խոսափող"),
            keywords: &["խոսափող", "կարաոկե"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("mikrofon"),
            keywords: &["karaoke", "mik", "mikrofon"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("igweokwu nkwụrụonwe"),
            keywords: &["igweokwu", "igweokwu nkwụrụonwe", "karaoke"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hljóðnemi"),
            keywords: &["hljóðnemi", "karaoke", "karókí", "míkrófónn", "skemmtun"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("microfono"),
            keywords: &["Karaoke", "microfono"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("マイク"),
            keywords: &["カラオケ", "マイク", "歌", "音楽"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("mikropon"),
            keywords: &["karaoke", "mik", "mikropon"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მიკროფონი"),
            keywords: &["კარაოკე", "მიკროფონი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("микрофон"),
            keywords: &["караоке", "мик", "микрофон"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("mikrofon"),
            keywords: &["mikrofon", "sang", "synge"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ម\u{17b8}ក\u{17d2}រ\u{17bc}ហ\u{17d2}វ\u{17bc}ន\u{200b}ន\u{17b7}ងណោតភ\u{17d2}លេងប\u{17b8}",
            ),
            keywords: &[
                "ណោតភ\u{17d2}លេង",
                "ម\u{17b8}ក\u{17d2}រ\u{17bc}ហ\u{17d2}វ\u{17bc}ន\u{200b}",
                "ម\u{17b8}ក\u{17d2}រ\u{17bc}ហ\u{17d2}វ\u{17bc}ន\u{200b}ន\u{17b7}ងណោតភ\u{17d2}លេងប\u{17b8}",
                "ម\u{17c9}ៃក\u{17d2}រ\u{17bc}ហ\u{17d2}វ\u{17bc}ន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮೈಕ\u{ccd}ರೋಫೋನ\u{ccd}"),
            keywords: &["ಕರೋಕ\u{cc6}", "ಮನರಂಜನ\u{cc6}", "ಮೈಕ\u{ccd}ರೋಫೋನ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("마이크"),
            keywords: &["가라오케", "노래방", "마이크", "행사"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मायक\u{94d}रोफोन"),
            keywords: &["काराओक\u{947}", "मायक", "मायक\u{94d}रोफोन"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("микрофон"),
            keywords: &["караоке", "микрофон"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Mikro"),
            keywords: &["Karaoke", "Mikro"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໄມ"),
            keywords: &["ໄມ", "ໄມໂຄຣໂຟນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mikrofonas"),
            keywords: &["karaokė", "mikrofonas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("mikrofons"),
            keywords: &["karaoke", "mikrofons"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("hopuoro"),
            keywords: &["hopuoro", "karaoke"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("микрофон"),
            keywords: &["микрофон", "музика"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മൈക\u{d4d}രോഫോൺ"),
            keywords: &[
                "കരോക\u{d4d}കെ",
                "പ\u{d3e}ട\u{d4d}ട\u{d4d}",
                "മൈക\u{d4d}രോഫോൺ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("микрофон"),
            keywords: &["караоке", "микрофон"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मायक\u{94d}रोफोन"),
            keywords: &["कराओक\u{947}", "माइक", "मायक\u{94d}रोफोन"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("mikrofon"),
            keywords: &["karaoke", "mike", "mikrofon"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("mikrofonu"),
            keywords: &["karaoke", "mik", "mikrofonu"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မ\u{102d}\u{102f}က\u{103a}ကရ\u{102d}\u{102f}ဖ\u{102f}န\u{103a}း"),
            keywords: &[
                "ကာရာအ\u{102d}\u{102f}ကေ",
                "မ\u{102d}\u{102f}က\u{103a}",
                "မ\u{102d}\u{102f}က\u{103a}ကရ\u{102d}\u{102f}ဖ\u{102f}န\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mikrofon"),
            keywords: &["karaoke", "mik", "mikrofon", "musikk", "underholdning"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("माइक\u{94d}रोफोन"),
            keywords: &["कारावोक\u{947}", "माइक", "माइक\u{94d}रोफोन"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("microfoon"),
            keywords: &["karaoke", "microfoon"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mikrofon"),
            keywords: &["karaoke", "mik", "mikrofon", "musikk", "underhaldning"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମ\u{b3e}ଇକ\u{b4d}ରୋଫୋନ\u{b4d}"),
            keywords: &[
                "କ\u{b3e}ର\u{b3e}ଓକ\u{b4d}\u{200c}",
                "ମନୋରଞ\u{b4d}ଜନ",
                "ମ\u{b3e}ଇକ\u{b4d}ରୋଫୋନ\u{b4d}",
                "ମ\u{b3e}ଇକ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮਾਈਕ\u{a4d}ਰ\u{a4b}ਫ\u{a3c}\u{a4b}ਨ"),
            keywords: &[
                "ਕਾਰਾਓਕ\u{a47}",
                "ਮਨ\u{a4b}ਰ\u{a70}ਜਨ",
                "ਮਾਈਕ",
                "ਮਾਈਕ\u{a4d}ਰ\u{a4b}ਫ\u{a3c}\u{a4b}ਨ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مائیکروفون"),
            keywords: &["مائک", "مائیکروفون", "کیراوکی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Maikrofon"),
            keywords: &["Kariókẹ", "Maik", "Maikrofon"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mikrofon"),
            keywords: &["karaoke", "mikrofon", "muzyka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("میکروفون"),
            keywords: &["مايک", "مايکروفون", "میکروفون", "کاروک"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("microfone"),
            keywords: &["entretenimento", "karaokê", "mic", "microfone"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("microfone"),
            keywords: &["karaoke", "microfone"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("micrófono"),
            keywords: &["micrófono"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("microfon"),
            keywords: &["karaoke", "microfon", "muzică"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-356"),
            keywords: &["E10-356"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("микрофон"),
            keywords: &["звук", "караоке", "микрофон", "пение"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("mikoro"),
            keywords: &["indangururamajwi", "karawoke", "mikoro"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مائيڪروفون"),
            keywords: &["مائيڪ", "مائيڪروفون", "ڪرائوڪي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මය\u{dd2}ක\u{dca}\u{200d}රෆෝනය"),
            keywords: &[
                "කැරොකේ",
                "මය\u{dd2}ක\u{dca}",
                "මය\u{dd2}ක\u{dca}\u{200d}රෆෝනය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("mikrofón"),
            keywords: &["karaoke", "mikrofón"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("mikrofon"),
            keywords: &["karaoke", "mikrofon"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("mikirifon"),
            keywords: &["karooke", "mik", "mikirifon", "mikirifoon"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("mikrofon"),
            keywords: &["karaoke", "mikrofon"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("микрофон"),
            keywords: &["кaрaoкe", "микрoфoн", "микрофон"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("mikrofon"),
            keywords: &["karaoke", "mikrofon"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("mikrofon"),
            keywords: &["karaoke", "mikrofon", "sjunga"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("maikrofoni"),
            keywords: &["karaoke", "maikrofoni"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மைக\u{bcd}ரோஃபோன\u{bcd}"),
            keywords: &[
                "கரோக\u{bcd}கி",
                "ப\u{bbe}ட\u{bcd}டு",
                "பேச\u{bcd}சு",
                "மைக\u{bcd}",
                "மைக\u{bcd}ரோஃபோன\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c48}క\u{c4d}ర\u{c4b}ఫ\u{c4b}న\u{c4d}"),
            keywords: &[
                "క\u{c3e}ర\u{c4b}క\u{c47}",
                "ప\u{c4d}రసంగం",
                "మ\u{c48}క\u{c4d}",
                "మ\u{c48}క\u{c4d}ర\u{c4b}ఫ\u{c4b}న\u{c4d}",
                "వ\u{c3f}న\u{c4b}దం",
                "సంగ\u{c40}తం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("микрофон"),
            keywords: &["караоке", "мик", "микрофон"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ไมโครโฟน"),
            keywords: &[
                "คาราโอเกะ",
                "สต\u{e39}ด\u{e34}โอ",
                "เพลง",
                "ไมค\u{e4c}",
                "ไมโครโฟน",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("mikrofon"),
            keywords: &["karaoke", "mik", "mikrofon"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("maikalofone"),
            keywords: &["maikalofone"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("mikrofon"),
            keywords: &["Karaoke", "eğlence", "mikrofon"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("مىكروفون"),
            keywords: &["كارائوكى", "مىكروفون"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("мікрофон"),
            keywords: &["караоке", "мікрофон"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مائیکروفون"),
            keywords: &["مائیک", "مائیکروفون", "موسیقی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("mikrofon"),
            keywords: &["karaoke", "mikrofon"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("micrô"),
            keywords: &["karaoke", "micrô"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("mikrofon"),
            keywords: &["karaoke", "mikro", "mikrofon"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("imayikhrofowuni"),
            keywords: &["i-karaoke", "i-mic", "imayikhrofowuni"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ẹ\u{300}rọ gbohùngbohùn kékeré"),
            keywords: &["maikurofóònù", "ẹ\u{300}rọ gbohùngbohùn kékeré"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("咪"),
            keywords: &["卡拉 OK", "咪"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("咪"),
            keywords: &["卡拉 OK", "咪"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("麦克风"),
            keywords: &["卡拉OK", "唱K", "唱歌", "麦", "麦克", "麦克风"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("麥克風"),
            keywords: &["k歌", "卡拉OK", "唱歌", "麥克風"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("咪高風"),
            keywords: &["卡拉OK", "咪高風", "唱歌", "歌"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("imakhrofoni"),
            keywords: &["ikhariyokhi", "imakhrofoni", "imayikhi"],
        },
    ],
};
#[doc = "🎧"]
pub const HEADPHONE: crate::Emoji = crate::Emoji {
    glyph: "🎧",
    codepoint: "1F3A7",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "headphone",
    group: "Objects",
    subgroup: "music",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("oorfoon"),
            keywords: &["musiek", "oorfoon", "oorknoppie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የጆሮ ማዳመጫ"),
            keywords: &["የጆሮ ማዳመጫ", "ጆሮ ተሰኪ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سماعة رأس"),
            keywords: &["ترفيه", "سماعة رأس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হেডফোন"),
            keywords: &["ইয\u{9bc}েৰব\u{9be}ড", "হেডফোন"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qulaqlıq"),
            keywords: &["qulaqlıq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("навушнікі"),
            keywords: &["вушы", "гук", "музыка", "навушнікі"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("слушалки"),
            keywords: &["слушалка", "слушалки"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হেডফোন"),
            keywords: &["ইয\u{9bc}\u{9be}রব\u{9be}ড", "হেডফোন"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("selaouelloù"),
            keywords: &["selaouelloù"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("slušalice"),
            keywords: &["bubice", "slušalice"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("auricular"),
            keywords: &["auricular"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄖𑄬𑄖\u{11134}𑄜\u{1112e}𑄚\u{11134}"),
            keywords: &["𑄖𑄬𑄖\u{11134}𑄜\u{1112e}𑄚\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᏟᎤᏍᏙᏗ"),
            keywords: &["ᎠᏟᎤᏍᏙᏗ", "ᏗᏟᎤᏍᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("sluchátka"),
            keywords: &["sluchátka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("clustffon"),
            keywords: &["clustffon"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("hovedtelefon"),
            keywords: &["hovedtelefon", "høretelefon", "lytte", "musik"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Kopfhörer"),
            keywords: &["Kopfhörer", "Musik", "Unterhaltung"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ακουστικά"),
            keywords: &["ακουστικά"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("headphone"),
            keywords: &["earbud", "headphone"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("headphones"),
            keywords: &["headphone", "headphones"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("auricular"),
            keywords: &["auricular", "cascos"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("auriculares"),
            keywords: &["auriculares", "entretenimiento", "música"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("audífonos"),
            keywords: &["audífonos"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kõrvaklapid"),
            keywords: &["kõrvaklapid"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("entzungailuak"),
            keywords: &["entzungailu", "entzungailuak"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("هدفون"),
            keywords: &["دوگوشی", "هدفون", "گوشی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kuuloke"),
            keywords: &["korvanappi", "kuuloke", "nappi", "nappikuuloke"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("headphone"),
            keywords: &["earbud", "earphone", "headphone"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("høvuðsett"),
            keywords: &["høvuðsett", "høvuðtelefon", "oyramikrofon"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("casque"),
            keywords: &["casque", "écouteurs"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("casque d’écoute"),
            keywords: &["casque d’écoute", "écouteur"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cluasáin"),
            keywords: &["ceol", "cluasáin"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("headphone"),
            keywords: &["earbud", "headphone"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("auriculares"),
            keywords: &["auriculares", "cascos"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("હ\u{ac7}ડફોન"),
            keywords: &["મનોર\u{a82}જન", "હ\u{ac7}ડફોન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mazirorin kunne"),
            keywords: &["mazirin kunne", "mazirorin kunne"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אוזניה"),
            keywords: &["אוזניה", "אוזניות", "אוזנייה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ह\u{947}डफ\u{93c}ोन"),
            keywords: &["ईयरबड", "ह\u{947}डफ\u{93c}ोन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("slušalice"),
            keywords: &["slušalica", "slušalice"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fülhallgató"),
            keywords: &["fülhallgató", "zenehallgatás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ականջակալ"),
            keywords: &["ականջակալ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("headphone"),
            keywords: &["earbud", "headphone"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ekwentịisi"),
            keywords: &["ekwentịisi", "igweokwunti"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("heyrnartól"),
            keywords: &["heyrnartól", "skemmtun"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cuffie"),
            keywords: &["cuffie", "intrattenimento"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ヘッドホン"),
            keywords: &["イヤホン", "ヘッドフォン", "ヘッドホン", "音楽"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("headphone"),
            keywords: &["earbud", "headphone"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ყურსასმენი"),
            keywords: &["ყურსასმენი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("құлақаспап"),
            keywords: &["түйме тәрізді құлақаспап", "құлақаспап"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("hovedtelefon"),
            keywords: &["hovedtelefon", "høretelefon", "lytte", "musik"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កាសន\u{17b7}ងណោតភ\u{17d2}លេងប\u{17b8}"),
            keywords: &[
                "កាស",
                "កាសន\u{17b7}ងណោតភ\u{17d2}លេងប\u{17b8}",
                "ណោតភ\u{17d2}លេង",
                "ភ\u{17d2}លេង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹ\u{cc6}ಡ\u{ccd}\u{200c}ಫೋನ\u{ccd}"),
            keywords: &["ಇಯರ\u{ccd}ಬಡ\u{ccd}", "ಹ\u{cc6}ಡ\u{ccd}\u{200c}ಫೋನ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("헤드폰"),
            keywords: &["음악 감상", "이어폰", "헤드폰"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ह\u{947}डफोन"),
            keywords: &["इयरबड", "ह\u{947}डफोन"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кулакаспап"),
            keywords: &["кулакаспап", "кулакчын"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Kopfhörer"),
            keywords: &["Kopfhörer"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{eb9}ຟ\u{eb1}ງ"),
            keywords: &["ຫ\u{eb9}ຟ\u{eb1}ງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("ausinės"),
            keywords: &["ausinės"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("austiņas"),
            keywords: &["austiņas", "ieauši"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("maupane"),
            keywords: &["maupane", "purutaringa"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("слушалки"),
            keywords: &["слушалка", "слушалки", "уво"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഹെഡ\u{d4d}\u{200c}ഫോൺ"),
            keywords: &["സംഗീതം", "ഹെഡ\u{d4d}\u{200c}ഫോൺ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("чихэвч"),
            keywords: &["чихэвч"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ह\u{947}डफोन"),
            keywords: &["गाणी", "मनोर\u{902}जन", "ह\u{947}डफोन"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("fon kepala"),
            keywords: &["fon kepala", "fon telinga"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("headphone"),
            keywords: &["earbud", "headphone"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("နားကြပ\u{103a}"),
            keywords: &[
                "နားကြပ\u{103a}",
                "နားစ\u{102d}\u{102f}\u{1037}",
                "ဖ\u{102f}န\u{103a}းနားကြပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hodetelefoner"),
            keywords: &["headset", "hodetelefoner", "underholdning", "øretelefoner"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ह\u{947}डफोन"),
            keywords: &["इयरबड", "ह\u{947}डफोन"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("hoofdtelefoon"),
            keywords: &["hoofdtelefoon", "oordopje"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("hovudtelefonar"),
            keywords: &[
                "headset",
                "hovudtelefonar",
                "underhaldning",
                "øyretelefonar",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ହେଡଫୋନ\u{b4d}\u{200c}"),
            keywords: &["ମନୋରଞ\u{b4d}ଜନ", "ହେଡଫୋନ\u{b4d}\u{200c}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਹ\u{a48}\u{a71}ਡਫ\u{a3c}\u{a4b}ਨ"),
            keywords: &["ਮਨ\u{a4b}ਰ\u{a70}ਜਨ", "ਹ\u{a48}\u{a71}ਡਫ\u{a3c}\u{a4b}ਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہیڈفون"),
            keywords: &["کان دی کونپل", "ہیڈفون"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Hẹ\u{301}dfon"),
            keywords: &["Hẹ\u{301}dfon", "Iábọd"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("słuchawki"),
            keywords: &["słuchawki"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("غوږۍ ګوشکه"),
            keywords: &["غوږۍ", "ګوشکه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("fones de ouvido"),
            keywords: &["fone de ouvido", "fones de ouvido"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("auscultador"),
            keywords: &["auscultador", "intra-auricular"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("audifono"),
            keywords: &["audifono"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cască audio"),
            keywords: &[
                "cască audio",
                "cască extraauriculară",
                "cască intraauriculară",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-359"),
            keywords: &["E10-359"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("наушники"),
            keywords: &[
                "вкладыши",
                "гарнитура",
                "затычки",
                "звук",
                "капли",
                "музыка",
                "наушники",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ekuteri"),
            keywords: &["ekuteri", "igikoresho cyagenewe ku matwi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("هيڊ فون"),
            keywords: &["ايئربڊ", "هيڊ فون"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හෙඩ\u{dca}ෆෝනය"),
            keywords: &["ඉයර\u{dca}බඩ\u{dca}", "හෙඩ\u{dca}ෆෝනය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("slúchadlá"),
            keywords: &["slúchadlo", "slúchadlá"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("slušalka"),
            keywords: &["slušalka", "ušesna slušalka"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dhago"),
            keywords: &["dhago", "dhago yaryar"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kufje"),
            keywords: &["kufje", "vesh"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("слушалица"),
            keywords: &["слушaлицa", "слушалица"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("slušalica"),
            keywords: &["slušalica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("hörlur"),
            keywords: &["hörlur", "musik"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("spika za masikioni"),
            keywords: &["kifaa cha sauti cha masikioni", "spika za masikioni"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஹெட\u{bcd}ஃபோன\u{bcd}"),
            keywords: &[
                "செய\u{bcd}தி",
                "ப\u{bbe}டல\u{bcd}",
                "ப\u{bbe}ட\u{bcd}டு கேட\u{bcd}டல\u{bcd}",
                "பொழுதுபோக\u{bcd}கு",
                "ஹெட\u{bcd}ஃபோன\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("హ\u{c46}డ\u{c4d}\u{200c}ఫ\u{c4b}న\u{c4d}"),
            keywords: &[
                "ఇయర\u{c4d}\u{200c}ఫ\u{c4b}న\u{c4d}",
                "ప\u{c3e}టలు వ\u{c3f}నడం",
                "వ\u{c3f}న\u{c4b}దం",
                "సంగ\u{c40}తం",
                "హ\u{c46}డ\u{c4d}\u{200c}ఫ\u{c4b}న\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("гӯшмонак"),
            keywords: &["гӯшмонак", "гӯшмонаки хурд"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ห\u{e39}ฟ\u{e31}ง"),
            keywords: &["ห\u{e39}ฟ\u{e31}ง", "เฮดโฟน"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("nauşnik"),
            keywords: &["gulaklyk", "nauşnik"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sipika ʻulu"),
            keywords: &["sipika ʻulu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kulaklık"),
            keywords: &["eğlence", "kulaklık"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تاقىما تىڭشىغۇچ"),
            keywords: &["تاقىما تىڭشىغۇچ", "تىڭشىغۇچ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("навушники"),
            keywords: &["навушники"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ہیڈ فون"),
            keywords: &["موسیقی", "ہیڈ فون"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("quloqlik"),
            keywords: &["quloqlik", "quloqqa tiqiladigan"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tai nghe"),
            keywords: &["tai nghe"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kasku misik"),
            keywords: &["ekutër", "kasku misik"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-headphone"),
            keywords: &["i-earbud", "i-headphone"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ẹ\u{300}rọ àdágbórinsétí"),
            keywords: &["ìrintí", "ẹ\u{300}rọ àdágbórinsétí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("耳機"),
            keywords: &["耳機"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("耳机"),
            keywords: &["耳机"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("耳机"),
            keywords: &["头戴式耳机", "耳机"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("耳機"),
            keywords: &["耳機", "音樂"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("耳筒"),
            keywords: &["耳筒", "耳筒｜音樂"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ama-headphone"),
            keywords: &["ama-headphone", "okufakwa endlebeni"],
        },
    ],
};
#[doc = "📻"]
pub const RADIO: crate::Emoji = crate::Emoji {
    glyph: "📻",
    codepoint: "1F4FB",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "radio",
    group: "Objects",
    subgroup: "music",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("radio"),
            keywords: &["draadloos", "radio"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሬዲዮ"),
            keywords: &["ሬዲዮ", "ቪዲዮ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("راديو"),
            keywords: &["راديو", "فيديو"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ৰেডিঅ’"),
            keywords: &["ভিডিঅ’", "ৰেডিঅ’"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("radio"),
            keywords: &["radio", "video"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("радыё"),
            keywords: &["відэа", "перадача", "прыёмнік", "радыё", "хваля"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("радио"),
            keywords: &["радио"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("রেডিও"),
            keywords: &["ভিডিও", "রেডিও"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("skingomzer"),
            keywords: &["skingomzer", "video"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("radio"),
            keywords: &["radio", "video"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("ràdio"),
            keywords: &["ràdio", "vídeo"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄢𑄬𑄓\u{11128}𑄠\u{1112e}"),
            keywords: &["𑄢𑄬𑄓\u{11128}𑄠\u{1112e}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎧᏃᎩᏍᎩ"),
            keywords: &["ᎠᏗᏴᎳᏛᏍᎩ", "ᏗᎧᏃᎩᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("rádio"),
            keywords: &["radiopřijímač", "rádio", "tranzistor", "tranzistorové"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("radio"),
            keywords: &["fideo", "radio"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("radio"),
            keywords: &["radio", "æteren"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Radio"),
            keywords: &["Musik", "Radio"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ραδιόφωνο"),
            keywords: &["βίντεο", "ραδιόφωνο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("radio"),
            keywords: &["radio", "video"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["AM", "FM", "radio", "wireless"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("radio"),
            keywords: &["radio"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "comunicación",
                "estación de radio",
                "música",
                "noticias",
                "radio",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["entretenimiento", "radio", "video"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("raadio"),
            keywords: &["raadio"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("irratia"),
            keywords: &["bideo", "irratia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("رادیو"),
            keywords: &["رادیو", "رادیویی", "ویدئو", "ویدیو"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("radio"),
            keywords: &["radio", "vastaanotin"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("radyo"),
            keywords: &["radyo", "video"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("útvarp"),
            keywords: &["útvarp"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("radio"),
            keywords: &["radio", "vidéo"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("raidió"),
            keywords: &["raidió"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("rèidio"),
            keywords: &["rèidio", "video"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("radio"),
            keywords: &["radio"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ર\u{ac7}ડિઓ"),
            keywords: &["ર\u{ac7}ડિઓ", "વિડિઓ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("rediyo"),
            keywords: &["bidiyo", "rediyo"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("רדיו"),
            keywords: &["מוזיקה", "רדיו"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("र\u{947}डियो"),
            keywords: &["र\u{947}डियो", "वीडियो"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("radio"),
            keywords: &["radio"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("rádió"),
            keywords: &["rádió", "rádiókészülék"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ռադիո"),
            keywords: &["ռադիո", "վիդեո"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("radio"),
            keywords: &["radio", "video"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("redio"),
            keywords: &["redio", "vidio"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("útvarp"),
            keywords: &["myndband", "útvarp"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("radio"),
            keywords: &["ascoltare la radio", "musica", "radio", "stazioni radio"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ラジオ"),
            keywords: &["ラジオ", "受信機", "放送", "音楽"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("radio"),
            keywords: &["radio", "video"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("რადიო"),
            keywords: &["ვიდეო", "რადიო"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("rradyu"),
            keywords: &["rradyu"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("радио"),
            keywords: &["бейне", "радио"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("radio"),
            keywords: &["radio", "æteren"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("វ\u{17b8}ទ\u{17d2}យ\u{17bb}"),
            keywords: &[
                "រ\u{17c9}ាឌ\u{17b8}យ\u{17c9}\u{17bc}",
                "វ\u{17b8}ទ\u{17d2}យ\u{17bb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ರೇಡ\u{cbf}ಯೊ"),
            keywords: &["ರೇಡ\u{cbf}ಯೊ", "ವೀಡ\u{cbf}ಯೊ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("라디오"),
            keywords: &["FM", "라디오"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("र\u{947}डियो"),
            keywords: &["र\u{947}डियो", "व\u{94d}हिडियो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("радио"),
            keywords: &["видео", "радио"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Radio"),
            keywords: &["Radio", "Video"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ວ\u{eb4}ທະຍ\u{eb8}"),
            keywords: &["ວ\u{eb4}ທະຍ\u{eb8}", "ເພງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("radijas"),
            keywords: &["radijas", "vaizdo įrašas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("radio"),
            keywords: &["radio", "video"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("irirangi"),
            keywords: &["ataata", "irirangi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("радио"),
            keywords: &["антена", "радио"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("റേഡിയോ"),
            keywords: &["റേഡിയോ", "വീഡിയോ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("радио"),
            keywords: &["видео", "радио"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("र\u{947}डिओ"),
            keywords: &["र\u{947}डिओ", "व\u{94d}हिडिओ"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("radio"),
            keywords: &["radio", "video"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("radju"),
            keywords: &["radju", "vidjo"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ရေဒ\u{102e}ယ\u{102d}\u{102f}"),
            keywords: &["ရေဒ\u{102e}ယ\u{102d}\u{102f}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("radio"),
            keywords: &["radio", "radiosignaler", "teknologi"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("र\u{947}डियो"),
            keywords: &["भिडियो", "र\u{947}डियो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("radio"),
            keywords: &["muziek", "radio"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("radio"),
            keywords: &["radio", "radiosignal", "teknologi"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ରେଡ\u{b3f}ଓ"),
            keywords: &[
                "ଭ\u{b3f}ଡ\u{b3c}\u{b3f}ଓ",
                "ରେଡ\u{b3c}\u{b3f}ଓ",
                "ରେଡ\u{b3f}ଓ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਰ\u{a47}ਡੀਓ"),
            keywords: &["ਰ\u{a47}ਡੀਓ", "ਵੀਡੀਓ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ريڈيو"),
            keywords: &["ريڈيو", "ویڈیو"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Rédio"),
            keywords: &["Rédio", "Vídio"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("radio"),
            keywords: &["odbiornik radiowy", "radio", "radioodbiornik", "radyjko"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("راډیو"),
            keywords: &["راډیو"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rádio"),
            keywords: &["rádio", "vídeo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["música", "rádio"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("radio"),
            keywords: &["radio"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("radio"),
            keywords: &["radio", "video"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-696"),
            keywords: &["E10-696"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("радио"),
            keywords: &["передача", "приемник", "радио", "сигнал"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("radiyo"),
            keywords: &["radiyo", "videwo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ريڊيو"),
            keywords: &["ريڊيو", "ويڊيو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("රෝඩ\u{dd2}යෝව"),
            keywords: &["රෝඩ\u{dd2}යෝව", "ව\u{dd3}ඩ\u{dd2}යෝව"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("rádio"),
            keywords: &["rádio", "video"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("radio"),
            keywords: &["glasba", "radio"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("raadiyow"),
            keywords: &["fiidiyow", "raadiyow"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("radio"),
            keywords: &["radio", "video"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("радио"),
            keywords: &["видео", "радио"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["радио"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("radio"),
            keywords: &["radio", "video"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["radio"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("radio"),
            keywords: &["radio", "video"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("redio"),
            keywords: &["redio", "video"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ரேடியோ"),
            keywords: &["எப\u{bcd}எம\u{bcd}", "ரேடியோ", "வ\u{bbe}னொலி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ర\u{c47}డ\u{c3f}య\u{c4b}"),
            keywords: &["ర\u{c47}డ\u{c3f}య\u{c4b}", "వ\u{c40}డ\u{c3f}య\u{c4b}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("радио"),
            keywords: &["видео", "радио"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ว\u{e34}ทย\u{e38}"),
            keywords: &["ว\u{e34}ทย\u{e38}", "เพลง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("radio"),
            keywords: &["radio", "wideo"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("letiō"),
            keywords: &["letiō"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("radyo"),
            keywords: &["radyo", "video"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("رادىيو"),
            keywords: &["رادىيو", "سىن"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("радіоприймач"),
            keywords: &["відео", "радіо", "радіоприймач"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ریڈیو"),
            keywords: &["برقی آلہ", "ریڈیو"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("radio"),
            keywords: &["radio", "video"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("radio"),
            keywords: &["radio", "video"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("rajo"),
            keywords: &["rajo", "wideo"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("irediyo"),
            keywords: &["irediyo", "ividoyo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("rédíò"),
            keywords: &["fídíò", "rédíò"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("收音機"),
            keywords: &["影片", "收音機"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("收音机"),
            keywords: &["影片", "收音机"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("收音机"),
            keywords: &["广播", "广播电台", "收音机", "无线电", "电台"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("收音機"),
            keywords: &["收音機"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umsakazo"),
            keywords: &["ividiyo", "umsakazo"],
        },
    ],
};
