#[doc = "💰"]
pub const MONEY_BAG: crate::Emoji = crate::Emoji {
    glyph: "💰",
    codepoint: "1F4B0",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "money bag",
    group: "Objects",
    subgroup: "money",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("geldsak"),
            keywords: &["dollar", "geld", "geldsak", "sak"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የገንዘብ ከረጢት"),
            keywords: &["ቦርሳ", "የገንዘብ ከረጢት", "ዶላር", "ገንዘብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("حقيبة نقود"),
            keywords: &["أموال", "حقيبة دولارات", "حقيبة نقود", "شنطة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ধনৰ মোন\u{9be}"),
            keywords: &["ডল\u{9be}ৰ", "ধন", "ধনৰ মোন\u{9be}", "মোন\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("pul torbası"),
            keywords: &["dollar", "kisə", "pul", "pul torbası", "çanta"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мяшок з грашыма"),
            keywords: &["грошы", "долар", "мяшок", "мяшок з грашыма"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Торба с пари"),
            keywords: &["Торба с пари", "долар", "пари", "торба"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ট\u{9be}ক\u{9be}র ব\u{9cd}য\u{9be}গ"),
            keywords: &[
                "ট\u{9be}ক\u{9be}",
                "ট\u{9be}ক\u{9be}র ব\u{9cd}য\u{9be}গ",
                "ডল\u{9be}র",
                "ব\u{9cd}য\u{9be}গ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("sacʼhad moneiz"),
            keywords: &["dollar", "moneiz", "sacʼh", "sacʼhad moneiz"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("vreća novca"),
            keywords: &["dolar", "novac", "vreća", "vreća novca"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bossa de diners"),
            keywords: &["bossa", "bossa de diners", "diners"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏕᎳ ᏕᎦᎶᏗ"),
            keywords: &["ᎠᏕᎳ", "ᎤᏃᏍᏓ", "ᏕᎦᎶᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("pytel peněz"),
            keywords: &[
                "dolar",
                "dolary",
                "měšec",
                "peníze",
                "pytel peněz",
                "vak",
                "váček",
                "zavazadlo",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bag arian"),
            keywords: &["arian", "bag", "doler"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("pengepose"),
            keywords: &["dollar", "penge", "pengepose"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Geldsack"),
            keywords: &["Geld", "Geldsack", "Sack"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σάκος με λεφτά"),
            keywords: &["δολάριο", "σάκος", "σάκος με λεφτά", "χρήματα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("money bag"),
            keywords: &["bag", "dollar", "money", "moneybag"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bolsa de dinero"),
            keywords: &["bolsa", "bolsa de dinero", "bolsa de dólares", "dinero"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["bolsa", "bolsa de dinero", "dinero", "dólares"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("rahapaun"),
            keywords: &["dollar", "kott", "raha", "rahakott", "rahapaun"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("poltsa bete diru"),
            keywords: &[
                "diru-poltsa",
                "dirua",
                "dolarra",
                "poltsa",
                "poltsa bete diru",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کیسه\u{654} پول"),
            keywords: &["دلار", "پول", "کیسه\u{654} پول", "کیف"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("rahasäkki"),
            keywords: &["raha", "rahapussi", "rahasäkki", "säkki"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("supot ng pera"),
            keywords: &["bag", "pera", "supot", "supot ng pera"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("pengasekkur"),
            keywords: &[
                "dollarar",
                "dollari",
                "pengar",
                "pengasekkur",
                "peningasekkur",
                "peningur",
                "sekkur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("sac plein d’argent"),
            keywords: &[
                "argent",
                "dollar",
                "sac",
                "sac d’argent",
                "sac plein d’argent",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("mála airgead"),
            keywords: &["airgead", "dollar", "mála airgead", "mála airgid"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("mogan airgid"),
            keywords: &["airgead", "baga", "dolar", "mogan", "mogan airgid", "poca"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("saco de diñeiro"),
            keywords: &["bolsa", "diñeiro", "dólares", "saco", "saco de diñeiro"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{ac8}સાની થ\u{ac7}લી"),
            keywords: &[
                "ડૉલર બ\u{ac5}ગ",
                "પ\u{ac8}સા",
                "પ\u{ac8}સાની થ\u{ac7}લી",
                "બ\u{ac5}ગ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("jakar kuɗi"),
            keywords: &["dala", "jaka", "jakar kuɗi", "kuɗi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שק כסף"),
            keywords: &["דולר", "כסף", "שק"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("धन वाला ब\u{948}ग"),
            keywords: &[
                "डॉलर ब\u{948}ग",
                "थ\u{948}ली",
                "धन की थ\u{948}ली",
                "धन वाला ब\u{948}ग",
                "प\u{948}स\u{947}",
                "प\u{948}सो\u{902} की थ\u{948}ली",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("vreća s novcem"),
            keywords: &["dolar", "novac", "vreća", "vreća s novcem"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("pénzeszsák"),
            keywords: &["dollár", "pénz", "pénzeszsák", "zsák"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("փողի պարկ"),
            keywords: &["դոլար", "պարկ", "փող", "փողի պարկ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kantung uang"),
            keywords: &["dolar", "kantong", "kantung uang", "uang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("àkpà ego"),
            keywords: &["dọlla", "ego", "àkpà", "àkpàego"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("peningapoki"),
            keywords: &["peningapoki", "peningar", "poki"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("sacco di soldi"),
            keywords: &["denaro", "sacco", "sacco di soldi"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ドル袋"),
            keywords: &["お金", "ドル", "ドル袋", "賞金", "金袋"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kanthong dhuwit"),
            keywords: &["dhuwit", "dolar", "kanthong"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ფულის ტომარა"),
            keywords: &["დოლარი", "ტომარა", "ფული", "ფულის ტომარა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ақша салынған қалта"),
            keywords: &["ақша", "ақша салынған қалта", "доллар", "сөмке", "әмиян"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("pengepose"),
            keywords: &["dollar", "penge", "pengepose"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ថង\u{17cb}ល\u{17bb}យ"),
            keywords: &[
                "ដ\u{17bb}ល\u{17d2}លារ",
                "ថង\u{17cb}",
                "ថង\u{17cb}ល\u{17bb}យ",
                "ល\u{17bb}យ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹಣದ ಚೀಲ"),
            keywords: &["ಚೀಲ", "ಡಾಲರ\u{ccd} ಚೀಲ", "ಹಣ", "ಹಣದ ಚೀಲ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("돈주머니"),
            keywords: &["돈가방", "돈주머니", "주머니"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पयशा\u{902}ची ब\u{945}ग"),
            keywords: &["डॉलर", "पयशा\u{902}ची ब\u{945}ग", "पयश\u{947}", "ब\u{945}ग"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("акча баштыгы"),
            keywords: &["акча", "акча баштыгы", "баштык", "доллар"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Geldsak"),
            keywords: &["Dollar", "Geld", "Geldsak", "Sak", "Suen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຖ\u{ebb}ງເງ\u{eb4}ນ"),
            keywords: &["ຖ\u{ebb}ງ", "ຖ\u{ebb}ງເງ\u{eb4}ນ", "ເງ\u{eb4}ນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("pinigų maišas"),
            keywords: &["doleris", "maišas", "pinigai", "pinigų maišas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("naudas maiss"),
            keywords: &["dolārs", "maiss", "nauda", "naudas maiss"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pēke moni"),
            keywords: &["moni", "pēke", "tāra"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("вреќа со пари"),
            keywords: &["вреќа", "вреќа со пари", "долар", "пари"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പണ ബ\u{d3e}ഗ\u{d4d}"),
            keywords: &[
                "പണ ബ\u{d3e}ഗ\u{d4d}",
                "പണം",
                "ബ\u{d3e}ഗ\u{d4d}",
                "ര\u{d42}പ\u{d3e} ബ\u{d3e}ഗ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("мөнгөтэй цүнх"),
            keywords: &["доллар", "мөнгө", "мөнгөтэй цүнх", "цүнх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{948}शा\u{902}ची पिशवी"),
            keywords: &[
                "डॉलर",
                "प\u{948}शा\u{902}ची पिशवी",
                "प\u{948}शा\u{902}चीपिशवी",
                "प\u{948}स\u{947}",
                "ब\u{945}ग",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("karung duit"),
            keywords: &["beg", "dolar", "karung duit", "wang"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("borża tal-flus"),
            keywords: &["borża", "borża tal-flus", "dollaru", "flus"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("င\u{103d}ေအ\u{102d}တ\u{103a}"),
            keywords: &[
                "င\u{103d}ေ",
                "င\u{103d}ေအ\u{102d}တ\u{103a}",
                "ဒေါ\u{103a}လာ",
                "အ\u{102d}တ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("pengesekk"),
            keywords: &["dollar", "penger", "pengesekk", "sekk"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{948}साको झोला"),
            keywords: &[
                "झोला",
                "डलर",
                "प\u{948}सा",
                "प\u{948}सा राख\u{94d}न\u{947} झोला",
                "प\u{948}साको झोला",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("zak met geld"),
            keywords: &["dollar", "geld", "geldzak", "zak", "zak met geld"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("pengesekk"),
            keywords: &["dollar", "pengar", "pengesekk", "sekk"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଟଙ\u{b4d}କ\u{b3e} ଥଳ\u{b3f}"),
            keywords: &[
                "ଟଙ\u{b4d}କ\u{b3e}",
                "ଟଙ\u{b4d}କ\u{b3e} ଥଳ\u{b3f}",
                "ଡଲ\u{b3e}ର\u{b4d} ବ\u{b4d}ୟ\u{b3e}ଗ\u{b4d}",
                "ବ\u{b4d}ୟ\u{b3e}ଗ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a48}ਸ\u{a47} ਵਾਲਾ ਬ\u{a48}ਗ"),
            keywords: &[
                "ਡਾਲਰ ਬ\u{a48}ਗ",
                "ਪ\u{a48}ਸਾ",
                "ਪ\u{a48}ਸ\u{a47} ਵਾਲਾ ਬ\u{a48}ਗ",
                "ਬ\u{a48}ਗ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پیسیاں آلا بستہ"),
            keywords: &["تھیلا", "پیسیاں آلا بستہ", "پیسے", "ڈالر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mọní Bag"),
            keywords: &["Bag", "Dọ\u{301}la", "Mọní", "MọníBag", "Naíra"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("worek z pieniędzmi"),
            keywords: &["dolary", "pieniądze", "worek", "worek z pieniędzmi"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د پيسو کڅوړه"),
            keywords: &["د پيسو کڅوړه", "پيسې", "ډالر", "کڅوړه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("saco de dinheiro"),
            keywords: &["dinheiro", "saco", "saco de dinheiro"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["dinheiro", "dólar", "saco", "saco de dinheiro"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("sac cu bani"),
            keywords: &["bani", "dolar", "pungă cu bani", "sac cu bani"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-621"),
            keywords: &["E10-621"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мешок денег"),
            keywords: &[
                "банкноты",
                "деньги",
                "доллар",
                "доллары",
                "мешок",
                "мешок денег",
                "много",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("agakapu k’amafaranga"),
            keywords: &[
                "agafuka",
                "agafuka k’amafaranga",
                "agakapu k’amafaranga",
                "idolari",
                "ifaranga",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پئسن جي ڳوٿري"),
            keywords: &["رقم", "پئسن جي ڳوٿري", "پئسن واري ڳوٿري", "ڊالر", "ڳوٿري"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ම\u{dd4}දල\u{dca} බෑගය"),
            keywords: &["ඩොලර\u{dca}", "බෑගය", "ම\u{dd4}දල\u{dca}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("mešec peňazí"),
            keywords: &[
                "dolár",
                "mešec peňazí",
                "peniaze",
                "vrece",
                "vrece na peniaze",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vreča denarja"),
            keywords: &["denar", "dolar", "vreča", "vreča denarja"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("bac lacaga"),
            keywords: &["bac", "bac lacag ah", "bac lacaga", "doolar", "lacag"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("qese parash"),
            keywords: &["dollar", "para", "qese", "qese parash", "çantë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("врећа новца"),
            keywords: &["врeћa", "врећа новца", "дoлaр", "нoвaц"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("vreća novca"),
            keywords: &["dolar", "novac", "vreća", "vreća novca"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("pengapåse"),
            keywords: &["pengapåse", "pengar", "säck"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mfuko wa pesa"),
            keywords: &["dola", "mfuko", "mfuko wa pesa", "pesa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பணப\u{bcd}பை"),
            keywords: &["ட\u{bbe}லர\u{bcd}", "பணப\u{bcd}பை", "பணம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("డబ\u{c4d}బు సంచ\u{c3f}"),
            keywords: &["డబ\u{c4d}బు సంచ\u{c3f}", "ధనం", "సంచ\u{c3f}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("халтаи пул"),
            keywords: &["доллар", "пул", "сумка", "халтаи пул"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ถ\u{e38}งเง\u{e34}น"),
            keywords: &["ถ\u{e38}งเง\u{e34}น", "เง\u{e34}น"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("pully halta"),
            keywords: &["halta", "pul", "pul haltasy", "pully halta"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tangai paʻanga"),
            keywords: &["tangai paʻanga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("para torbası"),
            keywords: &["dolar çantası", "para", "para torbası", "çanta"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("پۇل خالتىسى"),
            keywords: &["خالتا", "دوللار", "پۇل", "پۇل خالتىسى", "ھەميان"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("мішок грошей"),
            keywords: &["гроші", "долар", "мішок", "мішок грошей"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پیسوں کا بیگ"),
            keywords: &["بیگ", "رقم", "پیسوں کا بیگ", "ڈالر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("pul xalta"),
            keywords: &["dollar", "pul", "xalta"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("túi tiền"),
            keywords: &["tiền", "túi", "đô la"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("saagu xaalis"),
            keywords: &["dolaar", "saagu xaalis", "saak", "xaalis"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhegi yemali"),
            keywords: &["i-dollar", "ibhegi", "ibhegi yemali", "imali"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("apo owo"),
            keywords: &["apo owo", "dó\u{329}là", "owó", "àpò"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("錢袋"),
            keywords: &["蚊", "袋", "錢", "錢袋"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("钱袋"),
            keywords: &["蚊", "袋", "钱", "钱袋"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("钱袋"),
            keywords: &["美元", "钱", "钱包", "钱袋"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("錢袋"),
            keywords: &["錢", "錢袋"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("一袋錢"),
            keywords: &["一袋錢", "一袋錢｜錢袋｜錢"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isaka lemali"),
            keywords: &[
                "idola",
                "imali",
                "isaka lemali",
                "isikhwama",
                "isikhwama semali",
            ],
        },
    ],
};
#[doc = "🪙"]
pub const COIN: crate::Emoji = crate::Emoji {
    glyph: "🪙",
    codepoint: "1FA99",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "coin",
    group: "Objects",
    subgroup: "money",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("muntstuk"),
            keywords: &["geld", "goud", "muntstuk", "silwer", "skat"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሳንቲም"),
            keywords: &["ሳንቲም"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("عملة معدنية"),
            keywords: &["ذهب", "عملة معدنية", "فضة", "كنز", "مال", "معدن"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ম\u{9c1}দ\u{9cd}ৰ\u{9be}"),
            keywords: &[
                "ধন",
                "ধ\u{9be}ত\u{9c1}",
                "ম\u{9c1}দ\u{9cd}ৰ\u{9be}",
                "সম\u{9cd}পদ",
                "সোণ",
                "ৰ\u{9c2}প",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("xırda pul"),
            keywords: &["gümüş", "metal", "pul", "qızıl", "xırda pul", "xəzinə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("манета"),
            keywords: &["грошы", "золата", "манета", "метал", "скарб", "срэбра"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("монета"),
            keywords: &["злато", "метал", "монета", "пари", "сребро", "съкровище"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("কয\u{9bc}েন"),
            keywords: &[
                "কয\u{9bc}েন",
                "ট\u{9be}ক\u{9be}",
                "ধন",
                "ধ\u{9be}ত\u{9c1}",
                "র\u{9c1}প\u{9be}",
                "সোন\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pezh moneiz"),
            keywords: &["aour", "arcʼhant", "moneiz", "pezh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("novčić"),
            keywords: &["blago", "metal", "novac", "novčić", "srebro", "zlato"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("moneda"),
            keywords: &["metall", "moneda", "or", "plata", "tresor"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎢᏯᏓᏅᏖᏗ"),
            keywords: &[
                "ᎠᏕᎳ",
                "ᎠᏕᎳ ᎤᏁᎦ",
                "ᎠᏕᎳ ᏓᎶᏂᎨ",
                "ᎢᏯᏓᏅᏖᏗ",
                "ᏔᎷᎩᏍᎩ",
                "ᏧᎬᏩᎶᏗ ᎠᏍᏆᏂᎪᏛ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mince"),
            keywords: &["kov", "mince", "peníze", "poklad", "stříbro", "zlato"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("darn arian"),
            keywords: &["arian", "aur", "darn arian", "metel", "trysor"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mønt"),
            keywords: &["guld", "metal", "mønt", "penge", "skat", "sølv"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Münze"),
            keywords: &["Geld", "Gold", "Metall", "Münze", "Schatz", "Silber"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κέρμα"),
            keywords: &["ασήμι", "θησαυρός", "κέρμα", "μέταλλο", "χρήμα", "χρυσό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("coin"),
            keywords: &["coin", "gold", "metal", "money", "silver", "treasure"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("moneda"),
            keywords: &["dinero", "metal", "moneda", "oro", "plata", "tesoro"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("moneda"),
            keywords: &["moneda"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("moneda"),
            keywords: &["moneda"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("münt"),
            keywords: &["hõbe", "kuld", "metall", "münt", "raha", "varandus"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("txanpon"),
            keywords: &["altxorra", "dirua", "metala", "txanpon", "urrea", "zilarra"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("سکه"),
            keywords: &["سکه", "طلا", "فلز", "نقره", "پول", "گنجینه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kolikko"),
            keywords: &["aarre", "hopea", "kolikko", "kulta", "metalli", "raha"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("barya"),
            keywords: &["bakal", "barya", "ginto", "kayamanan", "pera", "pilak"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("myntur"),
            keywords: &["gull", "myntur", "pengar", "pengi", "skattur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("pièce"),
            keywords: &["argent", "métal", "or", "pièce", "trésor"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("pièce de monnaie"),
            keywords: &[
                "argent",
                "monnaie",
                "métal",
                "or",
                "pièce de monnaie",
                "trésor",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bonn"),
            keywords: &["airgead", "bonn", "miotal", "stórchiste", "ór"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bonn"),
            keywords: &["airgead", "bonn", "meatailt", "ulaidh", "òr"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("moeda"),
            keywords: &["cartos", "diñeiro", "moeda", "ouro", "prata", "tesouro"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સિક\u{acd}કો"),
            keywords: &[
                "ચા\u{a82}દી",
                "ધન",
                "ધાત\u{ac1}",
                "મ\u{ac2}લ\u{acd}યવાન વસ\u{acd}ત\u{ac1}",
                "સિક\u{acd}કો",
                "સોનાનો સિક\u{acd}કો",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מטבע"),
            keywords: &["אוצר", "זהב", "כסף", "מטבע", "מטבעות"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सिक\u{94d}का"),
            keywords: &["खजाना", "धन", "धात\u{941}", "रजत", "सिक\u{94d}का", "सोना"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kovanica"),
            keywords: &["blago", "kovanica", "metal", "novac", "srebro", "zlato"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("érme"),
            keywords: &["arany", "ezüst", "fém", "kincs", "pénz", "érme"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մետաղադրամ"),
            keywords: &["արծաթ", "գանձ", "դրամ", "մետալ", "մետաղադրամ", "ոսկի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("koin"),
            keywords: &["emas", "harta karun", "koin", "logam", "perak", "uang"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("mynt"),
            keywords: &["fjársjóður", "gull", "mynt", "málmur", "peningur", "silfur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("moneta"),
            keywords: &["argento", "denaro", "metallo", "moneta", "oro", "tesoro"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("コイン"),
            keywords: &["お金", "コイン", "小銭", "硬貨", "金貨", "銀貨"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("koin"),
            keywords: &["bandha", "duwit", "emas", "koin", "logam", "perak"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მონეტა"),
            keywords: &["ვერცხლი", "მეტალი", "მონეტა", "ოქრო", "ფული", "ხაზინა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тиын"),
            keywords: &["алтын", "ақша", "күміс", "металл", "тиын", "қазына"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កាក\u{17cb}"),
            keywords: &[
                "កាក\u{17cb}",
                "ទ\u{17d2}រព\u{17d2}យ",
                "ប\u{17d2}រាក\u{17cb}",
                "មាស",
                "ល\u{17bb}យ",
                "លោហៈ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನಾಣ\u{ccd}ಯ"),
            keywords: &[
                "ಖಜಾನ\u{cc6}",
                "ಚ\u{cbf}ನ\u{ccd}ನ",
                "ನಾಣ\u{ccd}ಯ",
                "ಬ\u{cc6}ಳ\u{ccd}ಳ\u{cbf}",
                "ಲೋಹ",
                "ಹಣ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("동전"),
            keywords: &["금", "금속", "돈", "동전", "보물", "은"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("नाण\u{947}"),
            keywords: &[
                "खजिनो",
                "धात\u{942}",
                "नाण\u{947}",
                "पयश\u{947}",
                "भा\u{902}गर",
                "र\u{941}प\u{947}\u{902}",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тыйын"),
            keywords: &["тыйын"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{ebc}ຽນ"),
            keywords: &[
                "ທອງ",
                "ສ\u{ebb}ມບ\u{eb1}ດ",
                "ຫ\u{ebc}ຽນ",
                "ເງ\u{eb4}ນ",
                "ໂລຫະ",
                "ໂລຫະເງ\u{eb4}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("moneta"),
            keywords: &[
                "auksas", "lobis", "metalas", "moneta", "pinigai", "sidabras",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("monēta"),
            keywords: &["bagātība", "metāls", "monēta", "nauda", "sudrabs", "zelts"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("паричка"),
            keywords: &["богатство", "злато", "метал", "пари", "паричка", "сребро"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ന\u{d3e}ണയം"),
            keywords: &[
                "ന\u{d3e}ണയം",
                "നിധി",
                "പണം",
                "ലോഹം",
                "വെള\u{d4d}ളി",
                "സ\u{d4d}വർണ\u{d4d}ണം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зоос"),
            keywords: &["алт", "зоос", "метал", "мөнгө", "эрдэнэс"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("नाण\u{947}"),
            keywords: &[
                "खजिना",
                "चा\u{902}दी",
                "धात\u{942}",
                "नाण\u{947}",
                "प\u{948}स\u{947}",
                "सोन\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("syiling"),
            keywords: &["duit", "emas", "harta karun", "logam", "perak", "syiling"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အကြ\u{103d}ေစေ\u{1037}"),
            keywords: &[
                "င\u{103d}ေ",
                "င\u{103d}ေကြေး",
                "ရတနာ",
                "ရ\u{103d}\u{103e}ေ",
                "သတ\u{1039}တ\u{102f}",
                "အကြ\u{103d}ေစေ\u{1037}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mynt"),
            keywords: &["gull", "metall", "mynt", "penger", "skatt", "sølv"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("सिक\u{94d}का"),
            keywords: &[
                "खजाना",
                "चा\u{901}दी",
                "धात\u{941}",
                "प\u{948}सा",
                "सिक\u{94d}का",
                "स\u{941}न",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("munt"),
            keywords: &["geld", "goud", "metaal", "munt", "schat", "zilver"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mynt"),
            keywords: &["gull", "metall", "mynt", "pengar", "skatt", "sølv"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମ\u{b41}ଦ\u{b4d}ର\u{b3e}"),
            keywords: &[
                "କୋଷ\u{b3e}ଧ\u{b4d}ୟକ\u{b4d}ଷ",
                "ଟଙ\u{b4d}କ\u{b3e}",
                "ଧ\u{b3e}ତ\u{b41}",
                "ମ\u{b41}ଦ\u{b4d}ର\u{b3e}",
                "ର\u{b42}ପ\u{b3e}",
                "ସ\u{b41}ନ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਿ\u{a71}ਕਾ"),
            keywords: &[
                "ਖਜ\u{a3c}ਾਨਾ",
                "ਚਾ\u{a02}ਦੀ",
                "ਧਨ",
                "ਧਾਤ\u{a42}",
                "ਸਿ\u{a71}ਕਾ",
                "ਸ\u{a4b}ਨਾ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kọin"),
            keywords: &[
                "Gold",
                "Kọin",
                "Mẹ\u{301}tal",
                "Mọní",
                "Sílva",
                "Trẹ\u{301}zhọ",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("moneta"),
            keywords: &[
                "metalowa",
                "moneta",
                "pieniądze",
                "skarb",
                "srebrna",
                "złota",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سکه"),
            keywords: &["خزانه", "سره زر", "سلور", "سکه", "فلز", "پېسې"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("moeda"),
            keywords: &["dinheiro", "metal", "moeda", "ouro", "prata", "tesouro"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("monedă"),
            keywords: &["argint", "aur", "bani", "comoară", "metal", "monedă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-060"),
            keywords: &["E13-060"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("монета"),
            keywords: &["деньги", "золото", "казна", "металл", "монета", "серебро"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سڪو"),
            keywords: &["خزانو", "سون", "سڪو", "پئسو", "چاندي", "ڌاتو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dcf}ස\u{dd2}ය"),
            keywords: &[
                "ක\u{dcf}ස\u{dd2}ය",
                "න\u{dd2}ධ\u{dcf}නය",
                "ම\u{dd4}දල\u{dca}",
                "රන\u{dca}",
                "ර\u{dd2}ද\u{dd3}",
                "ලෝහ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("minca"),
            keywords: &["minca", "peniaz", "peniaze", "poklad", "zlato"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kovanec"),
            keywords: &["denar", "kovanec", "kovina", "srebro", "zaklad", "zlato"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("lacag bir ah"),
            keywords: &["bir", "dahab", "khasnad", "lacag", "lacag bir ah", "qalin"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("monedhë"),
            keywords: &["argjend", "metal", "monedhë", "para", "thesar"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("новчић"),
            keywords: &["благо", "злато", "метал", "новац", "новчић", "сребро"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("novčić"),
            keywords: &["blago", "metal", "novac", "novčić", "srebro", "zlato"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("mynt"),
            keywords: &["guld", "mynt", "pengar", "silver", "skatt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("sarafu"),
            keywords: &["chuma", "dhahabu", "hazina", "pesa", "sarafu", "shaba"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ந\u{bbe}ணயம\u{bcd}"),
            keywords: &[
                "உலோகம\u{bcd}",
                "தங\u{bcd}கம\u{bcd}",
                "ந\u{bbe}ணயம\u{bcd}",
                "பணம\u{bcd}",
                "புதையல\u{bcd}",
                "வெள\u{bcd}ளி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బ\u{c3f}ళ\u{c4d}ల"),
            keywords: &[
                "డబ\u{c4d}బు",
                "న\u{c3f}ధ\u{c3f}",
                "బంగ\u{c3e}రం",
                "బ\u{c3f}ళ\u{c4d}ల",
                "ల\u{c4b}హం",
                "వ\u{c46}ండ\u{c3f}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เหร\u{e35}ยญ"),
            keywords: &[
                "ทอง",
                "สมบ\u{e31}ต\u{e34}",
                "เง\u{e34}น",
                "เง\u{e34}นทอง",
                "เหร\u{e35}ยญ",
                "โลหะ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("şaýlyk"),
            keywords: &["altyn", "hazyna", "kümüş", "metal", "pul", "şaýlyk"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("paʻanga maka"),
            keywords: &["foʻi paʻanga", "paʻanga maka"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("bozuk para"),
            keywords: &[
                "altın",
                "bozuk para",
                "gümüş",
                "hazine",
                "jeton",
                "metal",
                "para",
                "sikke",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("монета"),
            keywords: &["гроші", "золото", "метал", "монета", "скарб", "срібло"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سکہ"),
            keywords: &["خزانہ", "دھات", "رقم", "سونا", "سکہ", "چاندی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tanga"),
            keywords: &[
                "kumush", "metall", "oltin", "pul", "tanga", "tilla", "xazina",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đồng tiền"),
            keywords: &["bạc", "kho báu", "kim loại", "tiền", "vàng", "đồng tiền"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("硬幣"),
            keywords: &["寶藏", "硬幣", "金", "金屬", "銀", "錢"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("硬币"),
            keywords: &["宝藏", "硬币", "金", "金属", "钱", "银"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("硬币"),
            keywords: &["硬币", "财富", "金", "金属", "钱", "银"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("硬幣"),
            keywords: &["寶藏", "硬幣", "金", "金屬", "銀", "錢"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("imali"),
            keywords: &["gold", "imali", "metal", "money", "silver", "treasure"],
        },
    ],
};
#[doc = "💴"]
pub const YEN_BANKNOTE: crate::Emoji = crate::Emoji {
    glyph: "💴",
    codepoint: "1F4B4",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "yen banknote",
    group: "Objects",
    subgroup: "money",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("jenbanknoot"),
            keywords: &["bank", "banknoot", "geld", "jen", "jenbanknoot", "noot"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የን የወረቀት ገንዘብ"),
            keywords: &["መክፈያ", "ምንዛሬ", "የን የወረቀት ገንዘብ", "የወረቀት ገንዘብ", "ገንዘብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ورقة ين"),
            keywords: &["أموال", "بانكنوت", "ورقة ين", "ين"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("য\u{9bc}েন বেংকনোট"),
            keywords: &[
                "ধন",
                "নোট",
                "বিল",
                "বেংক",
                "বেংকনোট",
                "ম\u{9c1}দ\u{9cd}ৰ\u{9be}",
                "য\u{9bc}েন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("iena banknotu"),
            keywords: &[
                "bank",
                "banknot",
                "hesab",
                "iena",
                "iena banknotu",
                "yen banknotu",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("банкнот іены"),
            keywords: &[
                "Японія",
                "банкнот іены",
                "валюта",
                "грошы",
                "купюра",
                "іена",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Банкнота със знак за йена"),
            keywords: &[
                "Банкнота със знак за йена",
                "банкнота",
                "валута",
                "йена",
                "пари",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ইয\u{9bc}েন ব\u{9cd}য\u{9be}ঙ\u{9cd}কনোট"),
            keywords: &[
                "ইয\u{9bc}েন",
                "ট\u{9be}ক\u{9be}",
                "নোট",
                "বিল",
                "ব\u{9cd}য\u{9be}ঙ\u{9cd}কনোট",
                "ম\u{9c1}দ\u{9cd}র\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bilhed e yenoù"),
            keywords: &[
                "arcʼhant",
                "bilhed",
                "bilhed e yenoù",
                "moneiz",
                "unanenn",
                "yen",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("novčanica jena"),
            keywords: &["jen", "novac", "novčanica", "novčanica jena", "valuta"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bitllets de ien"),
            keywords: &["bitllets", "bitllets de ien", "ien", "signe"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏤᏈᏂᏏ ᎠᏕᎳ ᏧᏂᏗᎢ ᎪᏪᎵ"),
            keywords: &[
                "ᎠᏕᎳ",
                "ᎠᏕᎳ ᏧᏂᏗᎢ ᎪᏪᎵ",
                "ᎤᎾᏓᏚᎬ",
                "ᎤᏃᏍᏓ",
                "ᎪᏪᎵ",
                "ᏤᏈᏂᏏ ᎠᏕᎳ",
                "ᏤᏈᏂᏏ ᎠᏕᎳ ᏧᏂᏗᎢ ᎪᏪᎵ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("jenová bankovka"),
            keywords: &[
                "banka",
                "bankovka",
                "jen",
                "jenová bankovka",
                "měna",
                "peníze",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("papur arian yen"),
            keywords: &[
                "arian cyfredol",
                "banc",
                "papur arian",
                "papur arian yen",
                "yen",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("yenseddel"),
            keywords: &["penge", "yen", "yenseddel"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Yen-Banknote"),
            keywords: &["Geld", "Geldschein", "Yen", "Yen-Banknote"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("χαρτονόμισμα γιεν"),
            keywords: &["γιεν", "νόμισμα", "χαρτονόμισμα", "χρήματα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("yen banknote"),
            keywords: &["banknote", "bill", "currency", "money", "note", "yen"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("billete de yen"),
            keywords: &[
                "billete",
                "billete de banco",
                "billete de yen",
                "dinero",
                "yen",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["billete", "billete de yen", "dinero", "yen"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("jeeni rahatäht"),
            keywords: &[
                "jeen",
                "jeeni rahatäht",
                "pank",
                "raha",
                "rahatäht",
                "valuuta",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("yen billetea"),
            keywords: &["billetea", "dirua", "moneta", "yen billetea", "yena"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("اسکناس ین"),
            keywords: &["ارز", "اسکناس", "بانک", "پول", "ین"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("yen-seteli"),
            keywords: &["pankki", "raha", "seteli", "valuutta", "yen", "yen-seteli"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("yen bill"),
            keywords: &["banknote", "bill", "note", "pera", "salapi", "yen"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("jenn pengaseðil"),
            keywords: &["gjaldoyra", "jenn", "jennur", "pengaseðil", "seðil"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("billet en yens"),
            keywords: &["billet", "billet en yens"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["billet", "billet en yens", "yen"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("nóta bainc yen"),
            keywords: &["airgead", "nóta bainc", "nóta bainc yen", "nóta yen", "yen"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("not Yen"),
            keywords: &[
                "airgead",
                "airgeadra",
                "banca",
                "not",
                "not Yen",
                "nòta",
                "nòta-airgid",
                "nòta-banca",
                "yen",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("billete de ien"),
            keywords: &["banco", "billete", "billete de ien", "ien", "moeda"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ય\u{ac7}ન નોટ"),
            keywords: &[
                "નોટ",
                "બિલ",
                "બ\u{ac7}\u{a82}કનોટ",
                "ય\u{ac7}ન નોટ",
                "ય\u{ac7}ન નોટ. બ\u{ac7}\u{a82}ક નોટ",
                "ય\u{ac7}ન. પ\u{ac8}સા",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("takardar kuɗi na yen"),
            keywords: &[
                "banki",
                "kuɗi",
                "kuɗin banki",
                "kuɗin ƙasa",
                "takardar kuɗi",
                "takardar kuɗi na yen",
                "yen",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שטר ין"),
            keywords: &["ין", "כסף", "מטבע", "שטר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("य\u{947}न नोट"),
            keywords: &[
                "नोट",
                "प\u{948}स\u{947}",
                "बिल",
                "ब\u{948}\u{902}कनोट",
                "य\u{947}न",
                "य\u{947}न नोट, ब\u{948}\u{902}कनोट",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("novčanica sa znakom jena"),
            keywords: &[
                "banka",
                "jen",
                "novac",
                "novčanica",
                "novčanica sa znakom jena",
                "valuta",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("jen bankjegy"),
            keywords: &[
                "bank",
                "bankjegy",
                "bankó",
                "jen",
                "papírpénz",
                "pénz",
                "pénznem",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("իեն թղթադրամ"),
            keywords: &["բանկ", "թղթադրամ", "իեն", "տարադրամ", "փող"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("uang kertas yen"),
            keywords: &["mata uang", "uang", "uang kertas", "uang kertas yen", "yen"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akwụkwọego yen"),
            keywords: &[
                "akwụkwọego yen",
                "akwụkwọego ụlọakụ",
                "ego",
                "ego yen",
                "money",
                "ụgwọ",
                "ụlọakụ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("yenaseðill"),
            keywords: &["peningar", "peningaseðill", "seðill", "yen", "yenaseðill"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("banconota Yen"),
            keywords: &["Yen", "banconota", "denaro"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("円札"),
            keywords: &["お札", "お金", "円", "円札", "札束", "通貨"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("dhuwit kertas yen"),
            keywords: &[
                "dhuwit",
                "dhuwit kertas",
                "dhuwit kertas yen",
                "mata uang",
                "yen",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("იენას ბანკნოტი"),
            keywords: &[
                "ბანკი",
                "ბანკნოტი",
                "ვალუტა",
                "იენას ბანკნოტი",
                "იენი",
                "იენის ბანკნოტი",
                "ფული",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("йена банкнотасы"),
            keywords: &[
                "ақша",
                "банкнота",
                "валюта",
                "йена",
                "йена банкнотасы",
                "шот",
                "қағаз ақша",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("yenseddel"),
            keywords: &["penge", "yenseddel"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ល\u{17bb}យយេន"),
            keywords: &[
                "ក\u{17d2}រដាសប\u{17d2}រាក\u{17cb}",
                "ប\u{17d2}រាក\u{17cb}",
                "យ\u{17c9}េន",
                "រ\u{17bc}ប\u{17b7}យប\u{17d0}ណ\u{17d2}ណ",
                "ល\u{17bb}យ",
                "ល\u{17bb}យយេន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಯ\u{cc6}ನ\u{ccd} ಬ\u{ccd}ಯಾಂಕ\u{ccd}\u{200c}ನೋಟ\u{ccd}"),
            keywords: &[
                "ನೋಟ\u{ccd}",
                "ಬ\u{cbf}ಲ\u{ccd}",
                "ಬ\u{ccd}ಯಾಂಕ\u{ccd}\u{200c}ನೋಟ\u{ccd}",
                "ಯ\u{cc6}ನ\u{ccd}",
                "ಹಣ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("엔"),
            keywords: &["엔", "엔화", "일본 돈", "일본 화폐"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("य\u{947}न ब\u{901}कनोट"),
            keywords: &[
                "चलन",
                "नोट",
                "पयश\u{947}",
                "ब\u{901}कनोट",
                "बील",
                "य\u{947}न",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("иена банкнотасы"),
            keywords: &[
                "акча",
                "банкнота",
                "валюта",
                "иена",
                "иена банкнотасы",
                "эсеп",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Yen"),
            keywords: &[
                "Bank",
                "Geld",
                "Geldschäin",
                "Rechnung",
                "Schäin",
                "Suen",
                "Währung",
                "Yen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໃບເງ\u{eb4}ນເຢ\u{eb1}ນ"),
            keywords: &[
                "ທະນະບ\u{eb1}ດ",
                "ທະນາຄານ",
                "ເຢ\u{eb1}ນ",
                "ໃບເງ\u{eb4}ນ",
                "ໃບເງ\u{eb4}ນເຢ\u{eb1}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("jenos banknotas"),
            keywords: &[
                "bankas",
                "banknotas",
                "jena",
                "jenos banknotas",
                "pinigai",
                "valiuta",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("jenas banknote"),
            keywords: &["banknote", "jena", "jenas banknote", "nauda"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("monipepa Yen"),
            keywords: &[
                "momo moni",
                "moni",
                "monipepa",
                "monipepa Yen",
                "pepa",
                "pire",
                "pēke",
                "yen",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("банкнота на јен"),
            keywords: &["банкнота", "банкнота на јен", "пари", "јен"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("യെൻ ബ\u{d3e}ങ\u{d4d}ക\u{d4d} നോട\u{d4d}ട\u{d4d}"),
            keywords: &[
                "നോട\u{d4d}ട\u{d4d}",
                "പണം. ബിൽ",
                "ബ\u{d3e}ങ\u{d4d}ക\u{d4d} നോട\u{d4d}ട\u{d4d}",
                "യെൻ",
                "യെൻ ബ\u{d3e}ങ\u{d4d}ക\u{d4d} നോട\u{d4d}ട\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("иений мөнгөн тэмдэгт"),
            keywords: &[
                "банкны мөнгөн тэмдэгт",
                "валют",
                "иен",
                "иений мөнгөн тэмдэгт",
                "мөнгө",
                "нэхэмжлэх",
                "тэмдэгт",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("य\u{947}न ब\u{945}\u{902}कनोट"),
            keywords: &[
                "नोट",
                "प\u{948}सा",
                "ब\u{901}कनोट",
                "बिल",
                "य\u{947}न",
                "य\u{947}न ब\u{945}\u{902}कनोट",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("wang kertas yen"),
            keywords: &[
                "duit",
                "duit kertas",
                "mata wang",
                "wang",
                "wang kertas yen",
                "yen",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("karta tal-flus yen"),
            keywords: &[
                "bank",
                "flus",
                "karta",
                "karta tal-flus",
                "karta tal-flus yen",
                "munita",
                "nota",
                "yen",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ယန\u{103a}း င\u{103d}ေစက\u{1039}က\u{1030}"),
            keywords: &[
                "င\u{103d}ေ",
                "င\u{103d}ေကြေးစနစ\u{103a}",
                "င\u{103d}ေစက\u{1039}က\u{1030}",
                "ယန\u{103a}း င\u{103d}ေစက\u{1039}က\u{1030}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("yenseddel"),
            keywords: &["penger", "seddel", "yen", "yenseddel"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("य\u{947}न ब\u{948}\u{902}कनोट"),
            keywords: &[
                "नोट",
                "प\u{948}सा",
                "बिल",
                "ब\u{948}\u{902}कनोट",
                "म\u{941}द\u{94d}रा",
                "य\u{947}न",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("yenbiljet"),
            keywords: &[
                "bankbiljet",
                "biljet",
                "briefje",
                "geld",
                "valuta",
                "yen",
                "yenbiljet",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("yensetel"),
            keywords: &["pengar", "setel", "yen", "yensetel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ୟେନ\u{b4d}\u{200c} ବ\u{b4d}ୟ\u{b3e}ଙ\u{b4d}କନୋଟ\u{b4d}\u{200c}"),
            keywords: &[
                "ଟଙ\u{b4d}କ\u{b3e}",
                "ନୋଟ",
                "ବ\u{b4d}ୟ\u{b3e}ଙ\u{b4d}କନୋଟ\u{b4d}\u{200c}",
                "ରସ\u{b3f}ଦ\u{b4d}\u{200c}",
                "ୟେନ\u{b4d}\u{200c}",
                "\u{200d}ମ\u{b41}ଦ\u{b4d}ର\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਯ\u{a47}ਨ ਬ\u{a48}\u{a02}ਕਨ\u{a4b}ਟ"),
            keywords: &[
                "ਕਰ\u{a70}ਸੀ",
                "ਨ\u{a4b}ਟ",
                "ਪ\u{a48}ਸਾ",
                "ਬਿਲ",
                "ਬ\u{a48}\u{a71}ਕਨ\u{a4b}ਟ",
                "ਯ\u{a47}ਨ",
                "ਯ\u{a47}ਨ ਬ\u{a48}\u{a02}ਕਨ\u{a4b}ਟ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ین بینک نوٹ"),
            keywords: &[
                "بل",
                "بینک",
                "بینک دا ر\u{64f}قعہ",
                "ر\u{64f}قعہ",
                "پیسے",
                "کرنسی",
                "ین",
                "ین بینک نوٹ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Yẹn Pépá Mọní"),
            keywords: &[
                "Bil",
                "Bánknot",
                "Kọ\u{301}rẹ\u{301}nsi",
                "Mọní",
                "Not",
                "Yẹn",
                "Yẹn Pépá Mọní",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("banknot jena"),
            keywords: &[
                "bank",
                "banknot",
                "banknot jena",
                "pieniądze",
                "rachunek",
                "waluta",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ين بانک نوټ"),
            keywords: &["بل", "د بانک نوټ", "نوټ", "ين", "ين بانک نوټ", "پيسې"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("nota de iene"),
            keywords: &[
                "dinheiro",
                "iene",
                "moeda",
                "nota",
                "nota bancária",
                "nota de iene",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["banco", "dinheiro", "iene", "moeda", "nota", "nota de iene"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bancnotă yen"),
            keywords: &["bancnotă", "bani", "monedă", "valută", "yen"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-625"),
            keywords: &["E10-625"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("банкнота иены"),
            keywords: &[
                "банкнота",
                "банкнота иены",
                "валюта",
                "деньги",
                "иена",
                "япония",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("iyeni"),
            keywords: &["banki", "idovize", "ifaranga", "inoti", "iyeni"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("يين بئنڪ نوٽ"),
            keywords: &["بئنڪ", "بل", "سڪو", "نوٽ", "يين", "پئيسا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("යෙන\u{dca} බැංක\u{dd4} නෝට\u{dca}ට\u{dd4}ව"),
            keywords: &[
                "බැංක\u{dd4} නෝට\u{dca}ට\u{dd4}ව",
                "බ\u{dd2}ල",
                "ම\u{dd4}දල\u{dca} වර\u{dca}ගය",
                "යෙන\u{dca}",
                "යෙන\u{dca} බැංක\u{dd4} නෝට\u{dca}ට\u{dd4}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("jenová bankovka"),
            keywords: &[
                "banka",
                "bankovka",
                "jen",
                "jenová bankovka",
                "mena",
                "peniaze",
                "účet",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("bankovec za jen"),
            keywords: &[
                "apoen",
                "banka",
                "bankovec",
                "bankovec za jen",
                "denar",
                "jen",
                "valuta",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("lacag yeen ah"),
            keywords: &[
                "biil",
                "lacag",
                "lacag yeen ah",
                "warqad",
                "warqad bangi",
                "yeen",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kartëmonedhë jeni"),
            keywords: &[
                "faturë",
                "jen",
                "kartëmonedhë",
                "kartëmonedhë jeni",
                "valutë",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("новчаница са знаком јена"),
            keywords: &[
                "валута",
                "новац",
                "новчаница",
                "новчаница са знаком јена",
                "јен",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["новчаница са знаком јена"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("novčanica sa znakom jena"),
            keywords: &[
                "jen",
                "novac",
                "novčanica",
                "novčanica sa znakom jena",
                "valuta",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["novčanica sa znakom jena"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("yensedel"),
            keywords: &["pengar", "sedel", "yen", "yensedel"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("noti ya yeni"),
            keywords: &["benki", "noti", "noti ya yeni", "pesa", "sarafu", "yeni"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("யென\u{bcd} நோட\u{bcd}டு"),
            keywords: &[
                "ஜப\u{bcd}ப\u{bbe}ன\u{bcd}",
                "பணம\u{bcd}",
                "யென\u{bcd}",
                "யென\u{bcd} நோட\u{bcd}டு",
                "ரூப\u{bbe}ய\u{bcd} நோட\u{bcd}டு",
                "ரூப\u{bbe}ய\u{bcd} நோட\u{bcd}டுக\u{bcd} கட\u{bcd}டு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "య\u{c46}న\u{c4d} చ\u{c3f}హ\u{c4d}నం ఉన\u{c4d}న బ\u{c4d}య\u{c3e}ంకు న\u{c4b}టు",
            ),
            keywords: &[
                "కర\u{c46}న\u{c4d}స\u{c40}",
                "బ\u{c4d}య\u{c3e}ంకు న\u{c4b}టు",
                "య\u{c46}న\u{c4d}",
                "య\u{c46}న\u{c4d} చ\u{c3f}హ\u{c4d}నం ఉన\u{c4d}న బ\u{c4d}య\u{c3e}ంకు న\u{c4b}టు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("қоғази пули йен"),
            keywords: &[
                "асъор",
                "бонк",
                "йен",
                "пул",
                "қоғази пул",
                "қоғази пули йен",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ธนบ\u{e31}ตรเยน"),
            keywords: &["ธนบ\u{e31}ตร", "ธนบ\u{e31}ตรเยน", "เยน"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýen banknot"),
            keywords: &[
                "bank",
                "banknot",
                "kagyz pul",
                "pul",
                "pul birligi",
                "ýen banknot",
                "ýena",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("laʻi paʻanga fakasiapani"),
            keywords: &["laʻi paʻanga fakasiapani"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yen banknot"),
            keywords: &["banknot", "döviz", "para", "yen"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يېن"),
            keywords: &[
                "ئاقچا",
                "بانكا",
                "تەڭگە",
                "قەغەز پۇل",
                "يارماق",
                "يېن",
                "پۇل",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("єнові банкноти"),
            keywords: &[
                "банкнота",
                "валюта",
                "гроші",
                "купюра",
                "єна",
                "єнові банкноти",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ین بینک نوٹ"),
            keywords: &["بنک", "رقم", "نوٹ", "ین", "ین بینک نوٹ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("iyena banknotasi"),
            keywords: &[
                "banknot",
                "hisob",
                "iyena banknotasi",
                "pul",
                "pul birligi",
                "valyuta",
                "yen",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tiền giấy yên"),
            keywords: &[
                "hoá đơn",
                "tiền",
                "tiền giấy",
                "tiền giấy yên",
                "tiền tệ",
                "yên",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("biye yen"),
            keywords: &["biye", "bànk", "koppar", "xaalis", "xaalisu këyit", "yen"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("imali eliphepha yase-yen"),
            keywords: &[
                "i-yen",
                "ibhanki",
                "ikharensi",
                "imali",
                "imali eliphepha",
                "imali eliphepha yase-yen",
                "ityala",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("owo yen"),
            keywords: &[
                "ilé-ìfowópamó\u{329}",
                "owo yen",
                "owó",
                "owó bánkì",
                "yẹn",
                "ìwó iye owó",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("日圓紙幣"),
            keywords: &["日圓", "日圓紙幣", "紙幣", "貨幣", "銀紙", "錢"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("日圆纸币"),
            keywords: &[
                "帐单",
                "日圆",
                "日圆纸币",
                "纸币",
                "货币",
                "钱",
                "银纸",
                "银行",
            ],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("日元"),
            keywords: &["日元", "现金", "货币", "钞票", "钱"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("日幣"),
            keywords: &["日幣", "貨幣", "鈔票", "錢"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("日元紙幣"),
            keywords: &["日元", "日元紙幣", "日本貨幣"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("imali eyiyeni"),
            keywords: &[
                "ibhange",
                "imali",
                "imali eyiyeni",
                "isikweletu",
                "iyeni",
                "uhlobo lwemali",
            ],
        },
    ],
};
#[doc = "💵"]
pub const DOLLAR_BANKNOTE: crate::Emoji = crate::Emoji {
    glyph: "💵",
    codepoint: "1F4B5",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "dollar banknote",
    group: "Objects",
    subgroup: "money",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("dollarbanknoot"),
            keywords: &[
                "bank",
                "banknoot",
                "dollar",
                "dollarbanknoot",
                "geld",
                "noot",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ዶላር የወረቀት ገንዘብ"),
            keywords: &[
                "መክፈያ",
                "ምንዛሬ",
                "የወረቀት ገንዘብ",
                "ዶላር",
                "ዶላር የወረቀት ገንዘብ",
                "ገንዘብ",
            ],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ورقة دولار"),
            keywords: &["أموال", "بنكنوت", "ورقة دولار"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ডল\u{9be}ৰ বেংকনোট"),
            keywords: &[
                "ডল\u{9be}ৰ",
                "ধন",
                "নোট",
                "বিল",
                "বেংক",
                "বেংকনোট",
                "ম\u{9c1}দ\u{9cd}ৰ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("dollar əskinazı"),
            keywords: &["bank", "banknot", "dollar", "dollar əskinazı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("банкнот долара"),
            keywords: &[
                "Аўстралія",
                "ЗША",
                "Канада",
                "банкнот долара",
                "валюта",
                "грошы",
                "долар",
                "купюра",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Банкнота със знак за долар"),
            keywords: &[
                "Банкнота със знак за долар",
                "банкнота",
                "валута",
                "долар",
                "пари",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ডল\u{9be}র ব\u{9cd}য\u{9be}ঙ\u{9cd}কনোট"),
            keywords: &[
                "ট\u{9be}ক\u{9be}",
                "ডল\u{9be}র",
                "নোট",
                "বিল",
                "ব\u{9cd}য\u{9be}ঙ\u{9cd}কনোট",
                "ম\u{9c1}দ\u{9cd}র\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bilhed e dollaroù"),
            keywords: &[
                "arcʼhant",
                "bilhed",
                "bilhed e dollaroù",
                "dollar",
                "moneiz",
                "unanenn",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("novčanica dolara"),
            keywords: &["dolar", "novac", "novčanica", "novčanica dolara", "valuta"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bitllets de dòlar"),
            keywords: &["bitllets", "bitllets de dòlar", "dòlar", "signe"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏃᏍᏓ ᎠᏕᎳ ᏧᏂᏗᎢ ᎪᏪᎵ"),
            keywords: &[
                "ᎠᎹᏰᏟ ᎤᏃᏍᏓ",
                "ᎠᏕᎳ",
                "ᎠᏕᎳ ᏧᏂᏗᎢ ᎪᏪᎵ",
                "ᎤᎾᏓᏚᎬ",
                "ᎤᏃᏍᏓ",
                "ᎤᏃᏍᏓ ᎠᏕᎳ ᏧᏂᏗᎢ ᎪᏪᎵ",
                "ᎪᏪᎵ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("dolarová bankovka"),
            keywords: &[
                "banka",
                "bankovka",
                "dolar",
                "dolarová bankovka",
                "měna",
                "peníze",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("papur arian doler"),
            keywords: &[
                "arian cyfredol",
                "banc",
                "doler",
                "papur arian",
                "papur arian doler",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("dollarseddel"),
            keywords: &["dollar", "dollarseddel", "penge"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Dollar-Banknote"),
            keywords: &["Dollar", "Dollar-Banknote", "Geld", "Geldschein"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("χαρτονόμισμα δολαρίου"),
            keywords: &[
                "δολάριο",
                "νόμισμα",
                "χαρτονόμισμα",
                "χαρτονόμισμα δολαρίου",
                "χρήματα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("dollar banknote"),
            keywords: &["banknote", "bill", "currency", "dollar", "money", "note"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("billete de dólar"),
            keywords: &[
                "billete",
                "billete de banco",
                "billete de dólar",
                "dinero",
                "dólar",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["billete", "billete de dólar", "dinero", "dólar"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("dollari rahatäht"),
            keywords: &[
                "dollar",
                "dollari rahatäht",
                "pank",
                "raha",
                "rahatäht",
                "valuuta",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("dolar billetea"),
            keywords: &[
                "bankua",
                "billetea",
                "dirua",
                "dolar billetea",
                "dolarra",
                "moneta",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("اسکناس دلار"),
            keywords: &["ارز", "اسکناس", "بانک", "دلار", "پول"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("dollariseteli"),
            keywords: &[
                "dollari",
                "dollariseteli",
                "pankki",
                "raha",
                "seteli",
                "valuutta",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("dollar bill"),
            keywords: &[
                "banknote",
                "bill",
                "dollar bill",
                "dolyar",
                "pera",
                "salapi",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("dollari pengaseðil"),
            keywords: &["dollarar", "dollari", "gjaldoyra", "pengaseðil", "seðil"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("billet en dollars"),
            keywords: &["billet", "billet en dollars"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["billet", "billet en dollars", "dollar"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("nóta bainc dollair"),
            keywords: &[
                "airgead",
                "dollar",
                "nóta bainc",
                "nóta bainc dollair",
                "nóta dollair",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("not dolair"),
            keywords: &[
                "airgead",
                "airgeadra",
                "banca",
                "dolar",
                "not",
                "not dolair",
                "nòta",
                "nòta-airgid",
                "nòta-banca",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("billete de dólar"),
            keywords: &["banco", "billete", "billete de dólar", "dólar", "moeda"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ડૉલર નોટ"),
            keywords: &["ડૉલર", "નોટ", "પ\u{ac8}સા", "બિલ", "બ\u{ac7}\u{a82}કનોટ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("takardar kuɗi na dala"),
            keywords: &[
                "banki",
                "dala",
                "kuɗi",
                "kuɗin banki",
                "kuɗin ƙasa",
                "takardar kuɗi",
                "takardar kuɗi na dala",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שטר דולר"),
            keywords: &["דולר", "כסף", "מטבע", "שטר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("डॉलर नोट, ब\u{948}\u{902}कनोट"),
            keywords: &[
                "डॉलर",
                "डॉलर नोट, ब\u{948}\u{902}कनोट",
                "नोट",
                "प\u{948}स\u{947}",
                "बिल",
                "ब\u{948}\u{902}कनोट",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("novčanica sa znakom dolara"),
            keywords: &[
                "banka",
                "dolar",
                "novac",
                "novčanica",
                "novčanica sa znakom dolara",
                "valuta",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("dollár bankjegy"),
            keywords: &[
                "bank",
                "bankjegy",
                "bankó",
                "dollár",
                "papírpénz",
                "pénz",
                "pénznem",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("դոլար թղթադրամ"),
            keywords: &["բանկ", "դոլար", "թղթադրամ", "տարադրամ", "փող"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("uang kertas dolar"),
            keywords: &[
                "dolar",
                "mata uang",
                "uang",
                "uang kertas",
                "uang kertas dolar",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akwụkwọego dọlla"),
            keywords: &[
                "akwụkwọego dọlla",
                "akwụkwọego ụlọakụ",
                "dọlla",
                "ego",
                "ụgwọ",
                "ụlọakụ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("dollaraseðill"),
            keywords: &[
                "dollaraseðill",
                "dollari",
                "gjaldmiðill",
                "peningaseðill",
                "peningur",
                "seðill",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("banconota Dollaro"),
            keywords: &["Dollaro", "banconota", "denaro"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ドル札"),
            keywords: &["お札", "お金", "ドル", "ドル札", "札束", "通貨"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("dhuwit kertas dolar"),
            keywords: &[
                "dhuwit",
                "dhuwit kertas",
                "dhuwit kertas dolar",
                "euro",
                "mata uang",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დოლარის ბანკნოტი"),
            keywords: &["ბანკნოტი", "დოლარი", "დოლარის ბანკნოტი", "ვალუტა", "ფული"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("доллар банкнотасы"),
            keywords: &[
                "ақша",
                "банкнота",
                "валюта",
                "доллар",
                "доллар банкнотасы",
                "шот",
                "қағаз ақша",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("dollarseddel"),
            keywords: &["dollarseddel", "penge"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ល\u{17bb}\u{17bb}យដ\u{17bb}ល\u{17d2}លារ"),
            keywords: &[
                "ក\u{17d2}រដាសប\u{17d2}រាក\u{17cb}",
                "ដ\u{17bb}ល\u{17d2}លារ",
                "ប\u{17d2}រាក\u{17cb}",
                "រ\u{17bc}ប\u{17b7}យប\u{17d0}ណ\u{17d2}ណ",
                "ល\u{17bb}យ",
                "ល\u{17bb}យដ\u{17bb}ល\u{17d2}លារ",
                "ល\u{17bb}\u{17bb}យដ\u{17bb}ល\u{17d2}លារ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಡಾಲರ\u{ccd} ಬ\u{ccd}ಯಾಂಕ\u{ccd}\u{200c}ನೋಟ\u{ccd}"),
            keywords: &[
                "ಡಾಲರ\u{ccd}",
                "ನೋಟ\u{ccd}",
                "ಬ\u{cbf}ಲ\u{ccd}",
                "ಬ\u{ccd}ಯಾಂಕ\u{ccd}\u{200c}ನೋಟ\u{ccd}",
                "ಹಣ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("달러"),
            keywords: &["달러", "달러화", "미국 돈", "미국 화폐"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("डॉलर"),
            keywords: &["चलन", "डॉलर", "नोट", "पयश\u{947}", "ब\u{901}कनोट", "बील"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("доллар банкнотасы"),
            keywords: &[
                "акча",
                "банкнота",
                "валюта",
                "доллар",
                "доллар банкнотасы",
                "эсеп",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Dollar"),
            keywords: &[
                "Bank",
                "Dollar",
                "Geld",
                "Geldschäin",
                "Rechnung",
                "Schäin",
                "Suen",
                "Währung",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໃບເງ\u{eb4}ນໂດລາ"),
            keywords: &[
                "ທະນະບ\u{eb1}ດ",
                "ທະນາຄານ",
                "ໂດລາ",
                "ໃບເງ\u{eb4}ນ",
                "ໃບເງ\u{eb4}ນໂດລາ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("dolerio banknotas"),
            keywords: &[
                "bankas",
                "banknotas",
                "dolerio banknotas",
                "doleris",
                "pinigai",
                "valiuta",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("dolāra banknote"),
            keywords: &["banknote", "dolāra banknote", "dolārs", "nauda"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("monipepa tāra"),
            keywords: &[
                "momo moni",
                "moni",
                "monipepa",
                "pepa",
                "pire",
                "pēke",
                "tāra",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("банкнота на долар"),
            keywords: &["банкнота", "банкнота на долар", "долар", "пари"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഡോളർ ബ\u{d3e}ങ\u{d4d}ക\u{d4d} നോട\u{d4d}ട\u{d4d}"),
            keywords: &[
                "ഡോളർ",
                "ഡോളർ ബ\u{d3e}ങ\u{d4d}ക\u{d4d} നോട\u{d4d}ട\u{d4d}",
                "നോട\u{d4d}ട\u{d4d}",
                "പണം",
                "ബ\u{d3e}ങ\u{d4d}ക\u{d4d} നോട\u{d4d}ട\u{d4d}",
                "ബിൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("долларын мөнгөн тэмдэгт"),
            keywords: &[
                "банкны мөнгөн тэмдэгт",
                "валют",
                "доллар",
                "долларын мөнгөн тэмдэгт",
                "мөнгө",
                "нэхэмжлэх",
                "тэмдэгт",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("डॉलर ब\u{945}\u{902}कनोट"),
            keywords: &[
                "चलन",
                "डॉलर",
                "डॉलर ब\u{945}\u{902}कनोट",
                "नोट",
                "प\u{948}सा",
                "ब\u{901}क",
                "ब\u{901}कनोट",
                "बिल",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("wang kertas dolar"),
            keywords: &[
                "dolar",
                "mata wang",
                "wang",
                "wang kertas",
                "wang kertas dolar",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("karta tal-flus dollaru"),
            keywords: &[
                "bank",
                "dollaru",
                "flus",
                "karta",
                "karta tal-flus",
                "karta tal-flus dollaru",
                "munita",
                "nota",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဒေါ\u{103a}လာ င\u{103d}ေစက\u{1039}က\u{1030}"),
            keywords: &[
                "င\u{103d}ေ",
                "င\u{103d}ေကြေးစနစ\u{103a}",
                "င\u{103d}ေစက\u{1039}က\u{1030}",
                "ဒေါ\u{103a}လာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("dollarseddel"),
            keywords: &["dollar", "dollarseddel", "penger", "seddel"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("डलर ब\u{948}\u{902}कनोट"),
            keywords: &[
                "डलर",
                "नोट",
                "प\u{948}सा",
                "बिल",
                "ब\u{948}\u{902}क",
                "ब\u{948}\u{902}कनोट",
                "म\u{941}द\u{94d}रा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("dollarbiljet"),
            keywords: &[
                "bankbiljet",
                "biljet",
                "briefje",
                "dollar",
                "dollarbiljet",
                "geld",
                "valuta",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("dollarsetel"),
            keywords: &["dollar", "dollarsetel", "pengar", "setel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଡଲ\u{b3e}ର\u{b4d}\u{200c} ବ\u{b4d}ୟ\u{b3e}ଙ\u{b4d}କନୋଟ\u{b4d}\u{200c}"),
            keywords: &[
                "ଡଲ\u{b3e}ର\u{b4d}\u{200c} ବ\u{b4d}ୟ\u{b3e}ଙ\u{b4d}କନୋଟ\u{b4d}\u{200c}",
                "ଡ\u{b3c}ଲ\u{b3e}ର",
                "ନୋଟ\u{b4d}\u{200c}",
                "ବ\u{b4d}ୟ\u{b3e}ଙ\u{b4d}କନୋଟ\u{b4d}\u{200c}",
                "ରସ\u{b3f}ଦ\u{b4d}\u{200c}",
                "\u{200d}ଟଙ\u{b4d}କ\u{b3e}",
                "\u{200d}ମ\u{b41}ଦ\u{b4d}ର\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਡਾਲਰ ਬ\u{a48}\u{a02}ਕਨ\u{a4b}ਟ"),
            keywords: &[
                "ਕਰ\u{a70}ਸੀ",
                "ਡਾਲਰ",
                "ਡਾਲਰ ਬ\u{a48}\u{a02}ਕਨ\u{a4b}ਟ",
                "ਨ\u{a4b}ਟ",
                "ਪ\u{a48}ਸਾ",
                "ਬਿਲ",
                "ਬ\u{a48}\u{a71}ਕਨ\u{a4b}ਟ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ڈالر بینک نوٹ"),
            keywords: &[
                "بل",
                "بینک",
                "بینک دا ر\u{64f}قعہ",
                "ر\u{64f}قعہ",
                "پیسے",
                "ڈالر",
                "ڈالر بینک نوٹ",
                "کرنسی",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Dọ\u{301}la Pépá Mọní"),
            keywords: &[
                "Bil",
                "Bánknot",
                "Dọ\u{301}la",
                "Dọ\u{301}la Pépá Mọní",
                "Kọ\u{301}rẹ\u{301}nsi",
                "Mọní",
                "Not",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("banknot dolara"),
            keywords: &[
                "bank",
                "banknot",
                "banknot dolara",
                "pieniądze",
                "rachunek",
                "waluta",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ډالر بانک نوټ"),
            keywords: &["بل", "د بانک نوټ", "نوټ", "پيسې", "ډالر", "ډالر بانک نوټ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("nota de dólar"),
            keywords: &[
                "dinheiro",
                "dólar",
                "moeda",
                "nota",
                "nota bancária",
                "nota de dólar",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "banco",
                "dinheiro",
                "dólar",
                "moeda",
                "nota",
                "nota de dólar",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bancnotă dolar"),
            keywords: &["bancnotă", "bani", "dolar", "monedă", "valută"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-626"),
            keywords: &["E10-626"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("банкнота доллара"),
            keywords: &[
                "австралия",
                "банкнота",
                "банкнота доллара",
                "валюта",
                "доллар",
                "сша",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("idolari"),
            keywords: &[
                "banki",
                "idolari",
                "idovize",
                "ifaranga",
                "inoti",
                "urupapuro mvunjwafaranga",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڊائر بئنڪ نوٽ"),
            keywords: &["بئنڪ", "بل", "رقم", "سڪو", "نوٽ", "ڊائر بئنڪ نوٽ", "ڊالر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඩොලර\u{dca} බැංක\u{dd4} නෝට\u{dca}ට\u{dd4}ව"),
            keywords: &[
                "ඩොලර\u{dca}",
                "ඩොලර\u{dca} බැංක\u{dd4} නෝට\u{dca}ට\u{dd4}ව",
                "බැංක\u{dd4} නෝට\u{dca}ට\u{dd4}ව",
                "බ\u{dd2}ල",
                "ම\u{dd4}දල\u{dca} වර\u{dca}ගය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("dolárová bankovka"),
            keywords: &[
                "banka",
                "bankovka",
                "dolár",
                "dolárová bankovka",
                "mena",
                "peniaze",
                "účet",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("dolarski bankovec"),
            keywords: &[
                "apoen",
                "banka",
                "bankovec",
                "denar",
                "dolar",
                "dolarski bankovec",
                "valuta",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("lacag doolar ah"),
            keywords: &[
                "biil",
                "doolar",
                "lacag",
                "lacag doolar ah",
                "warqad",
                "warqad bangi",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kartëmonedhë dollari"),
            keywords: &[
                "dollar",
                "faturë",
                "kartëmonedhë",
                "kartëmonedhë dollari",
                "monedhë",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("новчаница са знаком долара"),
            keywords: &[
                "валута",
                "долар",
                "новац",
                "новчаница",
                "новчаница са знаком долара",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["новчаница са знаком долара"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("novčanica sa znakom dolara"),
            keywords: &[
                "dolar",
                "novac",
                "novčanica",
                "novčanica sa znakom dolara",
                "valuta",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["novčanica sa znakom dolara"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("dollarsedel"),
            keywords: &["dollar", "dollarsedel", "pengar", "sedel"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("noti ya dola"),
            keywords: &["benki", "dola", "noti", "noti ya dola", "pesa", "sarafu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ட\u{bbe}லர\u{bcd} நோட\u{bcd}டு"),
            keywords: &[
                "அமெரிக\u{bcd}க\u{bbe}",
                "ட\u{bbe}லர\u{bcd}",
                "ட\u{bbe}லர\u{bcd} நோட\u{bcd}டு",
                "பணம\u{bcd}",
                "ரூப\u{bbe}ய\u{bcd} நோட\u{bcd}டு",
                "ரூப\u{bbe}ய\u{bcd} நோட\u{bcd}டுக\u{bcd} கட\u{bcd}டு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "డ\u{c3e}లర\u{c4d} చ\u{c3f}హ\u{c4d}నం ఉన\u{c4d}న బ\u{c4d}య\u{c3e}ంకు న\u{c4b}టు",
            ),
            keywords: &[
                "కర\u{c46}న\u{c4d}స\u{c40}",
                "డ\u{c3e}లర\u{c4d}",
                "డ\u{c3e}లర\u{c4d} చ\u{c3f}హ\u{c4d}నం ఉన\u{c4d}న బ\u{c4d}య\u{c3e}ంకు న\u{c4b}టు",
                "బ\u{c4d}య\u{c3e}ంకు న\u{c4b}టు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("қоғази пули доллар"),
            keywords: &[
                "асъор",
                "бонк",
                "доллар",
                "пул",
                "қоғази пул",
                "қоғази пули доллар",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ธนบ\u{e31}ตรดอลลาร\u{e4c}"),
            keywords: &["ดอลลาร\u{e4c}", "ธนบ\u{e31}ตรดอลลาร\u{e4c}", "เง\u{e34}น"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("dollar banknot"),
            keywords: &[
                "banknot",
                "basma pul",
                "dollar",
                "kagyz pul",
                "pul",
                "pul birligi",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("laʻi paʻanga fakaʻamelika"),
            keywords: &["laʻi paʻanga fakaʻamelika"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("dolar banknot"),
            keywords: &["banknot", "dolar", "döviz", "para"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("دوللار"),
            keywords: &[
                "ئاقچا",
                "بانكا",
                "تەڭگە",
                "دوللار",
                "قەغەز پۇل",
                "يارماق",
                "پۇل",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("доларові банкноти"),
            keywords: &[
                "банкнота",
                "валюта",
                "гроші",
                "долар",
                "доларові банкноти",
                "купюра",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ڈالر بینک نوٹ"),
            keywords: &["بنک", "رقم", "نوٹ", "ڈالر", "ڈالر بینک نوٹ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("dollar banknotasi"),
            keywords: &[
                "banknot",
                "dollar",
                "dollar banknotasi",
                "hisob",
                "pul",
                "pul birligi",
                "valyuta",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tiền giấy đô la"),
            keywords: &[
                "hoá đơn",
                "tiền",
                "tiền giấy",
                "tiền giấy đô la",
                "tiền tệ",
                "đô la",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("biye dolaar"),
            keywords: &[
                "biye",
                "biye dolaar",
                "bànk",
                "dollar",
                "koppar",
                "xaalis",
                "xaalisu këyit",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("imali yephepha ye-dollar"),
            keywords: &[
                "i-dollar",
                "ibhanki",
                "ikharensi",
                "imali",
                "imali eliphepha",
                "imali yephepha ye-dollar",
                "ityala",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("owo dọla"),
            keywords: &[
                "dọ\u{301}là",
                "ilé-ìfowópamó",
                "owo dọla",
                "owó",
                "owó bánkì",
                "ìwó iye owó",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("美元紙幣"),
            keywords: &["紙幣", "美元", "美元紙幣", "貨幣", "銀紙", "錢"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("美元纸币"),
            keywords: &[
                "帐单",
                "纸币",
                "美元",
                "美元纸币",
                "货币",
                "钱",
                "银纸",
                "银行",
            ],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("美元"),
            keywords: &["现金", "纸币", "美元", "货币", "钱"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("美金"),
            keywords: &["美金", "貨幣", "鈔票", "錢"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("美金紙幣"),
            keywords: &["美金", "美金紙幣", "貨幣", "鈔票", "錢"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("imali eyidola"),
            keywords: &[
                "ibhange",
                "idola",
                "imali",
                "imali eyidola",
                "isikweletu",
                "uhlobo lwemali",
            ],
        },
    ],
};
#[doc = "💶"]
pub const EURO_BANKNOTE: crate::Emoji = crate::Emoji {
    glyph: "💶",
    codepoint: "1F4B6",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "euro banknote",
    group: "Objects",
    subgroup: "money",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("eurobanknoot"),
            keywords: &["bank", "banknoot", "euro", "eurobanknoot", "geld", "noot"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ዩሮ የወረቀት ገንዘብ"),
            keywords: &["መክፈያ", "ምንዛሬ", "ወረቀት ገንዘብ", "ዩሮ", "ዩሮ የወረቀት ገንዘብ", "ገንዘብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ورقة يورو"),
            keywords: &["أموال", "بانكنوت", "ورقة يورو", "يورو"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ইউৰ’ বেংকনোট"),
            keywords: &[
                "ইউৰ’",
                "ধন",
                "নোট",
                "বিল",
                "বেংক",
                "বেংকনোট",
                "ম\u{9c1}দ\u{9cd}ৰ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("avro əskinazı"),
            keywords: &["avro", "avro əskinazı", "bank", "banknot"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("банкнот еўра"),
            keywords: &["банкнот еўра", "валюта", "грошы", "еўра", "купюра"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Банкнота със знак за евро"),
            keywords: &[
                "Банкнота със знак за евро",
                "банкнота",
                "валута",
                "евро",
                "пари",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ইউরো ব\u{9cd}য\u{9be}ঙ\u{9cd}কনোট"),
            keywords: &[
                "ইউরো",
                "ট\u{9be}ক\u{9be}",
                "নোট",
                "বিল",
                "ব\u{9cd}য\u{9be}ঙ\u{9cd}কনোট",
                "ম\u{9c1}দ\u{9cd}র\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bilhed en euroioù"),
            keywords: &[
                "arcʼhant",
                "bilhed",
                "bilhed en euroioù",
                "euro",
                "moneiz",
                "unanenn",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("novčanica eura"),
            keywords: &["euro", "novac", "novčanica", "novčanica eura", "valuta"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bitllets d’euro"),
            keywords: &["bitllets", "bitllets d’euro", "euro", "signe"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏳᎳᏈ ᎠᏕᎳ ᏧᏂᏗᎢ ᎪᏪᎵ"),
            keywords: &[
                "ᎠᏕᎳ",
                "ᎠᏕᎳ ᏧᏂᏗᎢ ᎪᏪᎵ",
                "ᎤᎾᏓᏚᎬ",
                "ᎤᏃᏍᏓ",
                "ᎪᏪᎵ",
                "ᏳᎳᏈ ᎠᏕᎳ",
                "ᏳᎳᏈ ᎠᏕᎳ ᏧᏂᏗᎢ ᎪᏪᎵ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("eurobankovka"),
            keywords: &[
                "banka",
                "bankovka",
                "euro",
                "eurobankovka",
                "eurová",
                "měna",
                "peníze",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("papur arian ewro"),
            keywords: &[
                "arian cyfredol",
                "banc",
                "ewro",
                "papur arian",
                "papur arian ewro",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("euroseddel"),
            keywords: &["euro", "euroseddel", "penge"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Euro-Banknote"),
            keywords: &["Euro", "Euro-Banknote", "Euroschein", "Geld", "Geldschein"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("χαρτονόμισμα ευρώ"),
            keywords: &["ευρώ", "νόμισμα", "χαρτονόμισμα", "χρήματα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("euro banknote"),
            keywords: &["banknote", "bill", "currency", "euro", "money", "note"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("billete de euro"),
            keywords: &[
                "billete",
                "billete de banco",
                "billete de euro",
                "dinero",
                "euro",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["billete", "billete de euro", "dinero", "euro"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("euro rahatäht"),
            keywords: &["euro", "pank", "raha", "rahatäht", "valuuta"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("euro billetea"),
            keywords: &[
                "bankua",
                "billetea",
                "dirua",
                "euro billetea",
                "euroa",
                "moneta",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("اسکناس یورو"),
            keywords: &["ارز", "اسکناس", "بانک", "پول", "یورو"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("euroseteli"),
            keywords: &["euro", "euroseteli", "pankki", "raha", "seteli", "valuutta"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("euro bill"),
            keywords: &["banknote", "bill", "euro", "note", "pera", "salapi"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("evra pengaseðil"),
            keywords: &["evra", "evrur", "gjaldoyra", "pengaseðil", "seðil"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("billet en euros"),
            keywords: &["billet", "billet en euros"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["billet", "billet en euros", "euro"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("nóta bainc euro"),
            keywords: &[
                "Euro",
                "airgead",
                "nóta Euro",
                "nóta bainc",
                "nóta bainc euro",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("not Eòro"),
            keywords: &[
                "airgead",
                "airgeadra",
                "banca",
                "eòro",
                "not",
                "not Eòro",
                "nòta",
                "nòta-airgid",
                "nòta-banca",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("billete de euro"),
            keywords: &["banco", "billete", "billete de euro", "euro", "moeda"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ય\u{ac1}રો નોટ"),
            keywords: &[
                "નોટ",
                "પ\u{ac8}સા",
                "બિલ",
                "બ\u{ac7}\u{a82}કનોટ",
                "ય\u{ac1}રો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("takardar kuɗi na euro"),
            keywords: &[
                "banki",
                "euro",
                "kuɗi",
                "kuɗin banki",
                "kuɗin ƙasa",
                "takardar kuɗi",
                "takardar kuɗi na euro",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שטר אירו"),
            keywords: &["אירו", "כסף", "מטבע", "שטר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("य\u{942}रो नोट"),
            keywords: &[
                "नोट",
                "प\u{948}स\u{947}",
                "बिल",
                "ब\u{948}\u{902}क नोट",
                "य\u{942}रो",
                "य\u{942}रो नोट, य\u{942}रो",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("novčanica sa znakom eura"),
            keywords: &[
                "banka",
                "euro",
                "novac",
                "novčanica",
                "novčanica sa znakom eura",
                "valuta",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("euró bankjegy"),
            keywords: &[
                "bank",
                "bankjegy",
                "bankó",
                "euró",
                "papírpénz",
                "pénz",
                "pénznem",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("եվրո թղթադրամ"),
            keywords: &["բանկ", "եվրո", "թղթադրամ", "տարադրամ", "փող"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("uang kertas euro"),
            keywords: &[
                "euro",
                "mata uang",
                "uang",
                "uang kertas",
                "uang kertas euro",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akwụkwọego euro"),
            keywords: &[
                "akwụkwọego euro",
                "akwụkwọego ụlọakụ",
                "ego",
                "euro",
                "ụgwọ",
                "ụlọakụ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("evruseðill"),
            keywords: &["evra", "evruseðill", "peningar", "peningaseðill", "seðill"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("banconota Euro"),
            keywords: &["Euro", "banconota", "denaro"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ユーロ札"),
            keywords: &["お札", "お金", "ユーロ", "ユーロ札", "札束", "通貨"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("dhuwit kertas euro"),
            keywords: &["dhuwit kertas", "dhuwit kertas euro", "euro", "mata uang"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ევროს ბანკნოტი"),
            keywords: &["ბანკნოტი", "ევრო", "ევროს ბანკნოტი", "ვალუტა", "ფული"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("еуро банкнотасы"),
            keywords: &[
                "ақша",
                "банкнота",
                "валюта",
                "еуро",
                "еуро банкнотасы",
                "шот",
                "қағаз ақша",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("euroseddel"),
            keywords: &["euroseddel", "penge"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ល\u{17bb}យអ\u{17ba}រ\u{17bc}"),
            keywords: &[
                "ក\u{17d2}រដាសប\u{17d2}រាក\u{17cb}",
                "ប\u{17d2}រាក\u{17cb}",
                "រ\u{17bc}ប\u{17b7}យប\u{17d0}ណ\u{17d2}ណ",
                "ល\u{17bb}យ",
                "ល\u{17bb}យអ\u{17ba}រ\u{17bc}",
                "អ\u{17ba}រ\u{17c9}\u{17bc}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಯುರೋ ಬ\u{ccd}ಯಾಂಕ\u{ccd}\u{200c}ನೋಟ\u{ccd}"),
            keywords: &[
                "ನೋಟ\u{ccd}",
                "ಬ\u{cbf}ಲ\u{ccd}",
                "ಬ\u{ccd}ಯಾಂಕ\u{ccd}\u{200c}ನೋಟ\u{ccd}",
                "ಯುರೋ",
                "ಹಣ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("유로"),
            keywords: &["유럽 돈", "유럽 화폐", "유로", "유로화"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("य\u{941}रो ब\u{902}\u{901}कनोट"),
            keywords: &[
                "चलन",
                "नोट",
                "पयश\u{947}\u{902}",
                "ब\u{901}कनोट",
                "बील",
                "य\u{941}रो",
                "य\u{941}रो ब\u{902}\u{901}कनोट",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("евро банкнотасы"),
            keywords: &[
                "акча",
                "банкнота",
                "валюта",
                "евро",
                "евро банкнотасы",
                "эсеп",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Euro"),
            keywords: &[
                "Bank",
                "Euro",
                "Geld",
                "Geldschäin",
                "Rechnung",
                "Schäin",
                "Suen",
                "Währung",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໃບເງ\u{eb4}ນເອ\u{eb5}ໂຣ"),
            keywords: &[
                "ທະນະບ\u{eb1}ດ",
                "ທະນາຄານ",
                "ເອ\u{eb5}ໂຣ",
                "ໃບເງ\u{eb4}ນ",
                "ໃບເງ\u{eb4}ນເອ\u{eb5}ໂຣ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("euro banknotas"),
            keywords: &[
                "bankas",
                "banknotas",
                "euras",
                "euro banknotas",
                "pinigai",
                "valiuta",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("eiro banknote"),
            keywords: &["banknote", "eiro", "nauda"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("monipepa uro"),
            keywords: &[
                "momo moni",
                "moni",
                "monipepa",
                "pepa",
                "pire",
                "pēke",
                "uro",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("банкнота на евро"),
            keywords: &["банкнота", "банкнота на евро", "евро", "пари"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("യ\u{d42}റോ ബ\u{d3e}ങ\u{d4d}ക\u{d4d} നോട\u{d4d}ട\u{d4d}"),
            keywords: &[
                "നോട\u{d4d}ട\u{d4d}",
                "പണം",
                "ബ\u{d3e}ങ\u{d4d}ക\u{d4d} നോട\u{d4d}ട\u{d4d}",
                "ബിൽ",
                "യ\u{d42}റോ",
                "യ\u{d42}റോ ബ\u{d3e}ങ\u{d4d}ക\u{d4d} നോട\u{d4d}ട\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("евроны мөнгөн тэмдэгт"),
            keywords: &[
                "банкны мөнгөн тэмдэгт",
                "валют",
                "евро",
                "евроны мөнгөн тэмдэгт",
                "мөнгө",
                "нэхэмжлэх",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("य\u{941}रो ब\u{945}\u{902}कनोट"),
            keywords: &[
                "चलन",
                "नोट",
                "प\u{948}सा",
                "ब\u{901}क",
                "ब\u{901}कनोट",
                "बिल",
                "य\u{941}रो",
                "य\u{941}रो ब\u{945}\u{902}कनोट",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("wang kertas euro"),
            keywords: &[
                "euro",
                "mata wang",
                "wang",
                "wang kertas",
                "wang kertas euro",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("karta tal-flus ewro"),
            keywords: &[
                "bank",
                "euro",
                "flus",
                "karta",
                "karta tal-flus",
                "karta tal-flus ewro",
                "munita",
                "nota",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ယ\u{1030}ရ\u{102d}\u{102f} င\u{103e}စေက\u{103a}က\u{1030}"),
            keywords: &[
                "င\u{103d}ေ",
                "င\u{103d}ေကြေးစနစ\u{103a}",
                "င\u{103d}ေစက\u{1039}က\u{1030}",
                "ယ\u{1030}ရ\u{102d}\u{102f}",
                "ယ\u{1030}ရ\u{102d}\u{102f} င\u{103e}စေက\u{103a}က\u{1030}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("euroseddel"),
            keywords: &["euro", "euroseddel", "penger", "seddel"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("य\u{942}रो ब\u{948}\u{902}कनोट"),
            keywords: &[
                "बिल",
                "ब\u{948}\u{902}क",
                "ब\u{948}\u{902}कनोट",
                "म\u{941}द\u{94d}रा",
                "य\u{942}रो",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("eurobiljet"),
            keywords: &[
                "bankbiljet",
                "biljet",
                "briefje",
                "euro",
                "eurobiljet",
                "geld",
                "valuta",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("eurosetel"),
            keywords: &["euro", "eurosetel", "pengar", "setel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ୟ\u{b41}ରୋ ବ\u{b4d}ୟ\u{b3e}ଙ\u{b4d}କନୋଟ\u{b4d}\u{200c}"),
            keywords: &[
                "ନୋଟ\u{b4d}\u{200c}",
                "ବ\u{b4d}ୟ\u{b3e}ଙ\u{b4d}କନୋଟ\u{b4d}\u{200c}",
                "ରସ\u{b3f}ଦ\u{b4d}\u{200c}",
                "ୟ\u{b41}ରୋ",
                "\u{200d}ଟଙ\u{b4d}କ\u{b3e}",
                "\u{200d}ମ\u{b41}ଦ\u{b4d}ର\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਯ\u{a42}ਰ\u{a4b} ਬ\u{a48}\u{a02}ਕਨ\u{a4b}ਟ"),
            keywords: &[
                "ਕਰ\u{a70}ਸੀ",
                "ਨ\u{a4b}ਟ",
                "ਪ\u{a48}ਸਾ",
                "ਬਿਲ",
                "ਬ\u{a48}\u{a71}ਕਨ\u{a4b}ਟ",
                "ਯ\u{a42}ਰ\u{a4b}",
                "ਯ\u{a42}ਰ\u{a4b} ਬ\u{a48}\u{a02}ਕਨ\u{a4b}ਟ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("یورو بینک نوٹ"),
            keywords: &[
                "بل",
                "بینک",
                "بینک دا ر\u{64f}قعہ",
                "ر\u{64f}قعہ",
                "پیسے",
                "کرنسی",
                "یورو",
                "یورو بینک نوٹ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Yúro Pépá Mọní"),
            keywords: &[
                "Bil",
                "Bánknot",
                "Kọ\u{301}rẹ\u{301}nsi",
                "Mọní",
                "Not",
                "Yúro",
                "Yúro Pépá Mọní",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("banknot euro"),
            keywords: &[
                "bank",
                "banknot",
                "banknot euro",
                "pieniądze",
                "rachunek",
                "waluta",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("يورو بانک نوټ"),
            keywords: &["بل", "د بانک نوټ", "نوټ", "يورو", "يورو بانک نوټ", "پيسې"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("nota de euro"),
            keywords: &[
                "dinheiro",
                "euro",
                "moeda",
                "nota",
                "nota bancária",
                "nota de euro",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["banco", "dinheiro", "euro", "moeda", "nota", "nota de euro"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bancnotă euro"),
            keywords: &["bancnotă", "bani", "euro", "monedă", "valută"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-627"),
            keywords: &["E10-627"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("банкнота евро"),
            keywords: &["банкнота", "валюта", "деньги", "евро", "евросоюз"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("iyero"),
            keywords: &[
                "banki",
                "idovize",
                "ifaranga",
                "inoti",
                "iyero",
                "urupapuro mvunjwafaranga",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("يورو بئنڪ نوٽ"),
            keywords: &["بئنڪ", "بل", "رقم", "سڪو", "نوٽ", "يورو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ය\u{dd6}රෝ බැංක\u{dd4} නෝට\u{dca}ට\u{dd4}ව"),
            keywords: &[
                "නෝට\u{dca}ට\u{dd4}ව",
                "බැංක\u{dd4}ව",
                "බ\u{dd2}ල",
                "ම\u{dd4}දල\u{dca} වර\u{dca}ගය",
                "ය\u{dd6}රෝ බැංක\u{dd4} නෝට\u{dca}ට\u{dd4}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("eurová bankovka"),
            keywords: &[
                "banka",
                "bankovka",
                "euro",
                "eurová bankovka",
                "mena",
                "peniaze",
                "účet",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("evrski bankovec"),
            keywords: &[
                "apoen",
                "banka",
                "bankovec",
                "denar",
                "evro",
                "evrski bankovec",
                "valuta",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("lacag yuuro ah"),
            keywords: &[
                "biil",
                "lacag",
                "lacag yuuro ah",
                "warqad",
                "warqad bangi",
                "yuuro",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kartëmonedhë euroje"),
            keywords: &[
                "faturë",
                "kartëmonedhë",
                "kartëmonedhë euroje",
                "monedhë",
                "para",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("новчаница са знаком евра"),
            keywords: &[
                "валута",
                "евро",
                "новац",
                "новчаница",
                "новчаница са знаком евра",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["новчаница са знаком евра"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("novčanica sa znakom evra"),
            keywords: &[
                "evro",
                "novac",
                "novčanica",
                "novčanica sa znakom evra",
                "valuta",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["novčanica sa znakom evra"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("eurosedel"),
            keywords: &["euro", "eurosedel", "pengar", "sedel"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("noti ya yuro"),
            keywords: &["benki", "noti", "noti ya yuro", "pesa", "sarafu", "yuro"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("யூரோ நோட\u{bcd}டு"),
            keywords: &[
                "ஐரோப\u{bcd}ப\u{bbe}",
                "பணம\u{bcd}",
                "யூரோ",
                "யூரோ நோட\u{bcd}டு",
                "ரூப\u{bbe}ய\u{bcd} நோட\u{bcd}டு",
                "ரூப\u{bbe}ய\u{bcd} நோட\u{bcd}டுக\u{bcd} கட\u{bcd}டு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("యూర\u{c4b} చ\u{c3f}హ\u{c4d}నం ఉన\u{c4d}న బ\u{c4d}య\u{c3e}ంకు న\u{c4b}టు"),
            keywords: &[
                "కర\u{c46}న\u{c4d}స\u{c40}",
                "బ\u{c4d}య\u{c3e}ంకు న\u{c4b}టు",
                "యూర\u{c4b}",
                "యూర\u{c4b} చ\u{c3f}హ\u{c4d}నం ఉన\u{c4d}న బ\u{c4d}య\u{c3e}ంకు న\u{c4b}టు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("қоғази пули евро"),
            keywords: &[
                "асъор",
                "бонк",
                "евро",
                "пул",
                "қоғази пул",
                "қоғази пули евро",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ธนบ\u{e31}ตรย\u{e39}โร"),
            keywords: &["ธนบ\u{e31}ตร", "ธนบ\u{e31}ตรย\u{e39}โร", "ย\u{e39}โร"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýewro banknot"),
            keywords: &[
                "banknot",
                "basma pul",
                "kagyz pul",
                "pul",
                "pul birligi",
                "ýewro",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("laʻi paʻanga fakaʻeulope"),
            keywords: &["laʻi paʻanga fakaʻeulope"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("euro banknot"),
            keywords: &["avro", "banknot", "döviz", "euro", "para"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ياۋرو"),
            keywords: &[
                "ئاقچا",
                "بانكا",
                "تەڭگە",
                "قەغەز پۇل",
                "يارماق",
                "ياۋرو",
                "پۇل",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("єврові банкноти"),
            keywords: &[
                "банкнота",
                "валюта",
                "гроші",
                "купюра",
                "євро",
                "єврові банкноти",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("یورو بینک نوٹ"),
            keywords: &["بنک", "رقم", "نوٹ", "یورو", "یورو بینک نوٹ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yevro banknotasi"),
            keywords: &[
                "banknot",
                "hisob",
                "pul",
                "pul birligi",
                "valyuta",
                "yevro",
                "yevro banknotasi",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tiền giấy euro"),
            keywords: &[
                "euro",
                "hoá đơn",
                "tiền",
                "tiền giấy",
                "tiền giấy euro",
                "tiền tệ",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("biye euro"),
            keywords: &["biye", "bànk", "euro", "koppar", "xaalis", "xaalisu këyit"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("imali eliphepha ye-euro"),
            keywords: &[
                "i-euro",
                "ibhanki",
                "ikharensi",
                "imali",
                "imali eliphepha",
                "imali eliphepha ye-euro",
                "ityala",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("owo uro"),
            keywords: &[
                "ilé-ìfowópamó\u{329}",
                "owo uro",
                "owó",
                "owó bánkì",
                "ìwó iye owó",
                "úrò",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("歐元紙幣"),
            keywords: &["歐元", "歐元紙幣", "紙幣", "貨幣", "銀紙", "錢"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("欧元纸币"),
            keywords: &[
                "帐单",
                "欧元",
                "欧元纸币",
                "纸币",
                "货币",
                "钱",
                "银纸",
                "银行",
            ],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("欧元"),
            keywords: &["欧元", "现金", "货币", "钞票", "钱"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("歐元"),
            keywords: &["歐元", "貨幣", "鈔票", "錢"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("歐元紙幣"),
            keywords: &["歐元", "歐元紙幣", "貨幣", "鈔票", "錢"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("imali yase-euro"),
            keywords: &[
                "i-euro",
                "ibhange",
                "imali",
                "imali yase-euro",
                "isikweletu",
                "uhlobo lwemali",
            ],
        },
    ],
};
#[doc = "💷"]
pub const POUND_BANKNOTE: crate::Emoji = crate::Emoji {
    glyph: "💷",
    codepoint: "1F4B7",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "pound banknote",
    group: "Objects",
    subgroup: "money",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("pondbanknoot"),
            keywords: &["bank", "banknoot", "geld", "noot", "pond", "pondbanknoot"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ፓውንድ የወረቀት ገንዘብ"),
            keywords: &["መክፈያ", "ምንዛሬ", "የወረቀት ገንዘብ", "ገንዘብ", "ፓውንድ የወረቀት ገንዘብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ورقة جنيه"),
            keywords: &["أموال", "بانكنوت", "جنيه", "ورقة جنيه"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9be}উণ\u{9cd}ড বেংকনোট"),
            keywords: &[
                "ধন",
                "নোট",
                "প\u{9be}উণ\u{9cd}ড",
                "বিল",
                "বেংক",
                "বেংকনোট",
                "ম\u{9c1}দ\u{9cd}ৰ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("funt əskinazı"),
            keywords: &["bank", "funt", "funt əskinazı", "əskinaz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("банкнот фунта"),
            keywords: &[
                "Вялікабрытанія",
                "банкнот фунта",
                "валюта",
                "грошы",
                "купюра",
                "фунт",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Банкнота със знак за лира"),
            keywords: &[
                "Банкнота със знак за лира",
                "банкнота",
                "валута",
                "лира",
                "пари",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9be}উন\u{9cd}ড ব\u{9cd}য\u{9be}ঙ\u{9cd}কনোট"),
            keywords: &[
                "ট\u{9be}ক\u{9be}",
                "নোট",
                "প\u{9be}উন\u{9cd}ড",
                "বিল",
                "ব\u{9cd}য\u{9be}ঙ\u{9cd}কনোট",
                "ম\u{9c1}দ\u{9cd}র\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bilhed e lurioù"),
            keywords: &[
                "arcʼhant",
                "bilhed",
                "bilhed e lurioù",
                "lur",
                "moneiz",
                "unanenn",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("novčanica funte"),
            keywords: &["funta", "novac", "novčanica", "novčanica funte", "valuta"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bitllets de lliura"),
            keywords: &["bitllets", "bitllets de lliura", "lliura", "signe"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎩᎵᏏᏲ ᎠᏕᎳ ᏧᏂᏗᎢ ᎪᏪᎵ"),
            keywords: &[
                "ᎠᏕᎳ",
                "ᎠᏕᎳ ᏧᏂᏗᎢ ᎪᏪᎵ",
                "ᎤᎾᏓᏚᎬ",
                "ᎤᏃᏍᏓ",
                "ᎩᎵᏏᏲ ᎠᏕᎳ",
                "ᎩᎵᏏᏲ ᎠᏕᎳ ᏧᏂᏗᎢ ᎪᏪᎵ",
                "ᎪᏪᎵ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("librová bankovka"),
            keywords: &[
                "banka",
                "bankovka",
                "libra",
                "librová bankovka",
                "měna",
                "peníze",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("papur arian punt"),
            keywords: &[
                "arian cyfredol",
                "banc",
                "papur arian",
                "papur arian punt",
                "punt",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("pundseddel"),
            keywords: &["penge", "pund", "pundseddel"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Pfund-Banknote"),
            keywords: &["Geld", "Geldschein", "Pfund", "Pfund-Banknote"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("χαρτονόμισμα λίρας"),
            keywords: &[
                "αγγλική λίρα",
                "νόμισμα",
                "χαρτονόμισμα",
                "χαρτονόμισμα λίρας",
                "χρήματα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("pound banknote"),
            keywords: &["banknote", "bill", "currency", "money", "note", "pound"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &[
                "bank", "banknote", "bill", "currency", "money", "note", "pound", "sterling",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("billete de libra"),
            keywords: &["billete de banco", "billete de libra", "dinero", "libra"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["billete", "billete de libra", "dinero", "libra"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("naela rahatäht"),
            keywords: &[
                "nael",
                "naela rahatäht",
                "naelsterling",
                "pank",
                "rahatäht",
                "valuuta",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("libera billetea"),
            keywords: &[
                "banku",
                "billete",
                "diru",
                "faktura",
                "libera",
                "libera billetea",
                "moneta",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("اسکناس پوند"),
            keywords: &["ارز", "اسکناس", "بانک", "پول", "پوند"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("puntaseteli"),
            keywords: &[
                "pankki",
                "punta",
                "puntaseteli",
                "raha",
                "seteli",
                "valuutta",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pound bill"),
            keywords: &["banknote", "bill", "note", "pera", "pound", "salapi"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("pund pengaseðil"),
            keywords: &["gjaldoyra", "pengaseðil", "pund", "seðil"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("billet en livres"),
            keywords: &["billet", "billet en livres"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["billet", "billet en livres", "livre"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("nóta bainc puint"),
            keywords: &[
                "airgead",
                "nóta bainc",
                "nóta bainc puint",
                "nóta puint",
                "punt",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("not Punnd"),
            keywords: &[
                "airgead",
                "airgeadra",
                "banca",
                "not",
                "not Punnd",
                "nòta",
                "nòta-airgid",
                "nòta-banca",
                "punnd",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("billete de libra"),
            keywords: &["banco", "billete", "billete de libra", "libra", "moeda"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પાઉન\u{acd}ડ નોટ"),
            keywords: &[
                "પાઉન\u{acd}ડ",
                "પાઉન\u{acd}ડ નોટ",
                "પ\u{ac8}સા",
                "બ\u{ac7}\u{a82}કનોટ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("takardar kuɗi na fam"),
            keywords: &[
                "banki",
                "fam",
                "kuɗi",
                "kuɗin banki",
                "kuɗin ƙasa",
                "takardar kuɗi",
                "takardar kuɗi na fam",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שטר לירה שטרלינג"),
            keywords: &["כסף", "לירה שטרלינג", "מטבע", "שטר", "שטר לירה שטרלינג"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पाउ\u{902}ड नोट"),
            keywords: &[
                "पाउ\u{902}ड",
                "पाउ\u{902}ड नोट",
                "पाउ\u{902}ड नोट, ब\u{948}\u{902}कनोट",
                "प\u{948}स\u{947}",
                "ब\u{948}\u{902}कनोट",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("novčanica sa znakom funte"),
            keywords: &[
                "banka",
                "funta",
                "novac",
                "novčanica",
                "novčanica sa znakom funte",
                "valuta",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("font bankjegy"),
            keywords: &[
                "bank",
                "bankjegy",
                "bankó",
                "font",
                "papírpénz",
                "pénz",
                "pénznem",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ֆունտ թղթադրամ"),
            keywords: &["բանկ", "թղթադրամ", "տարադրամ", "փող", "ֆունտ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("uang kertas pound"),
            keywords: &[
                "mata uang",
                "pound",
                "uang",
                "uang kertas",
                "uang kertas pound",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akwụkwọego pound"),
            keywords: &[
                "akwụkwọego pound",
                "akwụkwọego ụlọakụ",
                "ego",
                "pound",
                "ụgwọ",
                "ụlọakụ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("pundaseðill"),
            keywords: &["peningar", "peningaseðill", "pund", "pundaseðill"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("banconota Sterlina"),
            keywords: &["Sterlina", "banconota", "denaro"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ポンド札"),
            keywords: &["お札", "お金", "ポンド", "ポンド札", "札束", "通貨"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("dhuwit kertas ponsterling"),
            keywords: &["dhuwit", "kertas", "mata uang", "ponsterling"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გირვანქა სტერლინგის ბანკნოტი"),
            keywords: &[
                "ბანკნოტი",
                "გირვანქა",
                "გირვანქა სტერლინგის ბანკნოტი",
                "ვალუტა",
                "სტერლინგი",
                "ფული",
                "ფუნტი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("фунт банкнотасы"),
            keywords: &[
                "ақша",
                "банкнота",
                "валюта",
                "фунт",
                "фунт банкнотасы",
                "шот",
                "қағаз ақша",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("pundseddel"),
            keywords: &["penge", "pund", "pundseddel"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ល\u{17bb}យផោន"),
            keywords: &[
                "ក\u{17d2}រដាសប\u{17d2}រាក\u{17cb}",
                "ប\u{17d2}រាក\u{17cb}",
                "ផោន",
                "រ\u{17bc}ប\u{17b7}យប\u{17d0}ណ\u{17d2}ណ",
                "ល\u{17bb}យ",
                "ល\u{17bb}យផោន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪ\u{ccc}ಂಡ\u{ccd} ಬ\u{ccd}ಯಾಂಕ\u{ccd}\u{200c}ನೋಟ\u{ccd}"),
            keywords: &[
                "ಪ\u{ccc}ಂಡ\u{ccd}",
                "ಬ\u{ccd}ಯಾಂಕ\u{ccd}\u{200c}ನೋಟ\u{ccd}",
                "ಹಣ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("파운드"),
            keywords: &["영국 돈", "영국 화폐", "파운드", "파운드화"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पाव\u{902}ड ब\u{901}कनोट"),
            keywords: &[
                "चलन",
                "नोट",
                "पयश\u{947}",
                "पाव\u{902}ड",
                "ब\u{901}कनोट",
                "बील",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("фунт банкнотасы"),
            keywords: &[
                "акча",
                "банкнота",
                "валюта",
                "фунт",
                "фунт банкнотасы",
                "эсеп",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Pound"),
            keywords: &[
                "Bank",
                "Geld",
                "Geldschäin",
                "Pound",
                "Rechnung",
                "Schäin",
                "Suen",
                "Währung",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໃບເງ\u{eb4}ນປອນ"),
            keywords: &[
                "ທະນະບ\u{eb1}ດ",
                "ທະນາຄານ",
                "ປອນ",
                "ໃບເງ\u{eb4}ນ",
                "ໃບເງ\u{eb4}ນປອນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("svaro sterlingų banknotas"),
            keywords: &[
                "bankas",
                "banknotas",
                "pinigai",
                "svaras sterlingų",
                "svaro sterlingų banknotas",
                "valiuta",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sterliņu mārciņas banknote"),
            keywords: &[
                "banknote",
                "nauda",
                "sterliņu mārciņa",
                "sterliņu mārciņas banknote",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("monipepa pauna"),
            keywords: &[
                "momo moni",
                "moni",
                "monipepa",
                "pauna",
                "pepa",
                "pire",
                "pēke",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("банкнота на фунта"),
            keywords: &["банкнота", "банкнота на фунта", "пари", "фунта"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d57}ണ\u{d4d}ട\u{d4d} ബ\u{d3e}ങ\u{d4d}ക\u{d4d} നോട\u{d4d}ട\u{d4d}"),
            keywords: &[
                "പണം",
                "പ\u{d57}ണ\u{d4d}ട\u{d4d}",
                "പ\u{d57}ണ\u{d4d}ട\u{d4d} നോട\u{d4d}ട\u{d4d}",
                "പ\u{d57}ണ\u{d4d}ട\u{d4d} ബ\u{d3e}ങ\u{d4d}ക\u{d4d} നോട\u{d4d}ട\u{d4d}",
                "ബ\u{d3e}ങ\u{d4d}ക\u{d4d} നോട\u{d4d}ട\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("фунтын мөнгөн тэмдэгт"),
            keywords: &[
                "банкны мөнгөн тэмдэгт",
                "валют",
                "мөнгө",
                "нэхэмжлэх",
                "тэмдэгт",
                "фунт",
                "фунтын мөнгөн тэмдэгт",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पाऊ\u{902}ड ब\u{945}\u{902}कनोट"),
            keywords: &[
                "चलन",
                "नोट",
                "पाऊ\u{902}ड",
                "पाऊ\u{902}ड ब\u{945}\u{902}कनोट",
                "प\u{948}सा",
                "ब\u{901}क",
                "ब\u{901}कनोट",
                "बिल",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("wang kertas paun"),
            keywords: &[
                "mata wang",
                "pound",
                "wang",
                "wang kertas",
                "wang kertas paun",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("karta tal-flus lira sterlina"),
            keywords: &[
                "bank",
                "flus",
                "karta",
                "karta tal-flus",
                "karta tal-flus lira sterlina",
                "lira",
                "munita",
                "nota",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပေါင\u{103a} င\u{103d}ေစက\u{1039}က\u{1030}"),
            keywords: &[
                "င\u{103d}ေ",
                "င\u{103d}ေကြေးစနစ\u{103a}",
                "င\u{103d}ေစက\u{1039}က\u{1030}",
                "ပေါင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("pundseddel"),
            keywords: &["penger", "pund", "pundseddel", "seddel"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पाउण\u{94d}ड ब\u{948}\u{902}कनोट"),
            keywords: &[
                "नोट",
                "पाउण\u{94d}ड",
                "प\u{948}सा",
                "बिल",
                "ब\u{948}\u{902}क",
                "ब\u{948}\u{902}कनोट",
                "म\u{941}द\u{94d}रा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("pondbiljet"),
            keywords: &[
                "bankbiljet",
                "biljet",
                "briefje",
                "geld",
                "pond",
                "pondbiljet",
                "valuta",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("pundsetel"),
            keywords: &["pengar", "pund", "pundsetel", "setel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b3e}ଉଣ\u{b4d}ଡ ବ\u{b4d}ୟ\u{b3e}ଙ\u{b4d}କନୋଟ\u{b4d}\u{200c}"),
            keywords: &[
                "ନୋଟ\u{b4d}\u{200c}",
                "ପ\u{b3e}ଉଣ\u{b4d}ଡ",
                "ବ\u{b4d}ୟ\u{b3e}ଙ\u{b4d}କନୋଟ\u{b4d}\u{200c}",
                "ରସ\u{b3f}ଦ\u{b4d}\u{200c}",
                "\u{200d}ଟଙ\u{b4d}କ\u{b3e}",
                "\u{200d}ମ\u{b41}ଦ\u{b4d}ର\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a4c}\u{a02}ਡ ਬ\u{a48}\u{a02}ਕਨ\u{a4b}ਟ"),
            keywords: &[
                "ਕਰ\u{a70}ਸੀ",
                "ਪ\u{a48}ਸਾ",
                "ਪ\u{a4c}\u{a02}ਡ",
                "ਪ\u{a4c}\u{a02}ਡ ਬ\u{a48}\u{a02}ਕਨ\u{a4b}ਟ",
                "ਬਿਲ",
                "ਬ\u{a48}\u{a02}ਕ",
                "ਬ\u{a48}\u{a71}ਕਨ\u{a4b}ਟ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پاؤنڈ بینک نوٹ"),
            keywords: &[
                "بل",
                "بینک",
                "بینک دا ر\u{64f}قعہ",
                "ر\u{64f}قعہ",
                "پاؤنڈ بینک نوٹ",
                "پونڈ",
                "پیسے",
                "کرنسی",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Paund Pépá Mọní"),
            keywords: &[
                "Bil",
                "Bánknot",
                "Kọ\u{301}rẹ\u{301}nsi",
                "Mọní",
                "Not",
                "Paund",
                "Paund Pépá Mọní",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("banknot funta"),
            keywords: &[
                "bank",
                "banknot",
                "banknot funta",
                "pieniądze",
                "rachunek",
                "waluta",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پونډه بانک نوټ"),
            keywords: &["بل", "د بانک نوټ", "نوټ", "پونډ", "پونډه بانک نوټ", "پيسې"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("nota de libra"),
            keywords: &[
                "dinheiro",
                "libra",
                "moeda",
                "nota",
                "nota bancária",
                "nota de libra",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "banco",
                "dinheiro",
                "libra",
                "moeda",
                "nota",
                "nota de libra",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bancnotă liră sterlină"),
            keywords: &[
                "bancnotă",
                "bancnotă liră sterlină",
                "bani",
                "liră sterlină",
                "monedă",
                "valută",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-628"),
            keywords: &["E10-628"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("банкнота фунта"),
            keywords: &[
                "англия",
                "банкнота",
                "банкнота фунта",
                "великобритания",
                "фунт",
                "фунт стерлингов",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ipawundi"),
            keywords: &[
                "banki",
                "idovize",
                "ifaranga",
                "inoti",
                "ipawundi",
                "urupapuro mvunjwafaranga",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پائونڊ بئنڪ نوٽ"),
            keywords: &["بئنڪ", "بل", "سڪو", "نوٽ", "پئيسا", "پائونڊ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පව\u{dd4}ම\u{dca} බැංක\u{dd4} නෝට\u{dca}ට\u{dd4}ව"),
            keywords: &[
                "නෝට\u{dca}ට\u{dd4}ව",
                "පව\u{dd4}ම\u{dca}",
                "පව\u{dd4}ම\u{dca} බැංක\u{dd4} නෝට\u{dca}ට\u{dd4}ව",
                "බැංක\u{dd4}ව",
                "බ\u{dd2}ල",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("librová bankovka"),
            keywords: &[
                "banka",
                "bankovka",
                "libra",
                "librová bankovka",
                "mena",
                "peniaze",
                "účet",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("bankovec za funt"),
            keywords: &[
                "apoen",
                "banka",
                "bankovec",
                "bankovec za funt",
                "denar",
                "funt",
                "valuta",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("lacag bownd ah"),
            keywords: &[
                "biil",
                "bownd",
                "lacag",
                "lacag bownd ah",
                "warqad",
                "warqad bangi",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kartëmonedhë paundi"),
            keywords: &["kartëmonedhë paundi", "monedhë", "para", "paund", "valutë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("новчаница са знаком фунте"),
            keywords: &[
                "валута",
                "новац",
                "новчаница",
                "новчаница са знаком фунте",
                "фунта",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["новчаница са знаком фунте"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("novčanica sa znakom funte"),
            keywords: &[
                "funta",
                "novac",
                "novčanica",
                "novčanica sa znakom funte",
                "valuta",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["novčanica sa znakom funte"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("pundsedel"),
            keywords: &["pengar", "pund", "pundsedel", "sedel"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("noti ya pauni"),
            keywords: &["benki", "noti", "noti ya pauni", "pauni", "pesa", "sarafu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பவுண\u{bcd}ட\u{bcd} நோட\u{bcd}டு"),
            keywords: &[
                "இங\u{bcd}கில\u{bbe}ந\u{bcd}து",
                "பணம\u{bcd}",
                "பவுண\u{bcd}ட\u{bcd}",
                "பவுண\u{bcd}ட\u{bcd} நோட\u{bcd}டு",
                "ரூப\u{bbe}ய\u{bcd} நோட\u{bcd}டு",
                "ரூப\u{bbe}ய\u{bcd} நோட\u{bcd}டுக\u{bcd} கட\u{bcd}டு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "ప\u{c4c}ండ\u{c4d} చ\u{c3f}హ\u{c4d}నం ఉన\u{c4d}న బ\u{c4d}య\u{c3e}ంకు న\u{c4b}టు",
            ),
            keywords: &[
                "కర\u{c46}న\u{c4d}స\u{c40}",
                "ప\u{c4c}ండ\u{c4d}",
                "ప\u{c4c}ండ\u{c4d} చ\u{c3f}హ\u{c4d}నం ఉన\u{c4d}న బ\u{c4d}య\u{c3e}ంకు న\u{c4b}టు",
                "బ\u{c4d}య\u{c3e}ంకు న\u{c4b}టు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("қоғази пули фунт"),
            keywords: &[
                "асъор",
                "бонк",
                "пул",
                "фунт",
                "қоғази пул",
                "қоғази пули фунт",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ธนบ\u{e31}ตรปอนด\u{e4c}"),
            keywords: &["ธนบ\u{e31}ตร", "ธนบ\u{e31}ตรปอนด\u{e4c}", "เง\u{e34}น"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("funt sterling banknot"),
            keywords: &[
                "bank",
                "banknot",
                "funt sterling",
                "funt sterling banknot",
                "kagyz pul",
                "pul",
                "pul birligi",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("laʻi paʻanga fakapilitania"),
            keywords: &["laʻi paʻanga fakapilitania"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sterlin banknot"),
            keywords: &["banknot", "döviz", "para", "sterlin"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("پوندستېرلىڭ"),
            keywords: &[
                "ئاقچا",
                "بانكا",
                "تەڭگە",
                "قەغەز پۇل",
                "يارماق",
                "پوند",
                "پوندستېرلىڭ",
                "پۇل",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("фунтові банкноти"),
            keywords: &[
                "банкнота",
                "валюта",
                "гроші",
                "купюра",
                "фунт",
                "фунтові банкноти",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پاؤنڈ بینک نوٹ"),
            keywords: &["بنک", "رقم", "نوٹ", "پاؤنڈ", "پاؤنڈ بینک نوٹ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("funt sterling banknotasi"),
            keywords: &[
                "banknot",
                "funt sterling",
                "funt sterling banknotasi",
                "pul",
                "pul birligi",
                "valyuta",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tiền giấy bảng"),
            keywords: &[
                "bảng",
                "hoá đơn",
                "tiền",
                "tiền giấy",
                "tiền giấy bảng",
                "tiền tệ",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("piye pound"),
            keywords: &[
                "biye",
                "bànk",
                "koppar",
                "piye pound",
                "pound",
                "xaalis",
                "xaalisu këyit",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("imali eliphepha ye-pound"),
            keywords: &[
                "i-pound",
                "ibhanki",
                "ikharensi",
                "imali",
                "imali eliphepha",
                "imali eliphepha ye-pound",
                "ityala",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("owo pọun"),
            keywords: &[
                "ilé-ìfowópamó\u{329}",
                "owo pọun",
                "owó",
                "owó bánkì",
                "pó\u{329}ùn",
                "ìwó iye owó",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("英鎊紙幣"),
            keywords: &["紙幣", "英鎊", "英鎊紙幣", "貨幣", "銀紙", "錢"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("英镑纸币"),
            keywords: &[
                "帐单",
                "纸币",
                "英镑",
                "英镑纸币",
                "货币",
                "钱",
                "银纸",
                "银行",
            ],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("英镑"),
            keywords: &["现金", "英镑", "货币", "钞票", "钱"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("英鎊"),
            keywords: &["英鎊", "貨幣", "鈔票", "錢"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("英鎊紙幣"),
            keywords: &["英鎊", "英鎊紙幣", "貨幣", "鈔票", "錢"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("imali eyi-pound"),
            keywords: &[
                "i-pound",
                "ibhange",
                "imali",
                "imali eyi-pound",
                "isikweletu",
                "uhlobo lwemali",
            ],
        },
    ],
};
#[doc = "💸"]
pub const MONEY_WITH_WINGS: crate::Emoji = crate::Emoji {
    glyph: "💸",
    codepoint: "1F4B8",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "money with wings",
    group: "Objects",
    subgroup: "money",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("geld met vlerke"),
            keywords: &["banknoot", "geld", "geld met vlerke", "noot", "vlerke"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ክንፍ ያለው ገንዘብ"),
            keywords: &["መክፈያ", "ብረር", "ክንፍ ያለው ገንዘብ", "የወረቀት ገንዘብ", "ገንዘብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("أموال تطير"),
            keywords: &["أموال", "أموال بأجنحة", "أموال تطير", "بانكنوت طائر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9be}খিয\u{9c1}ক\u{9cd}ত ধন"),
            keywords: &[
                "উৰণ",
                "ধন",
                "প\u{9be}খি",
                "প\u{9be}খিয\u{9c1}ক\u{9cd}ত ধন",
                "বিল",
                "বেংকনোট",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qanadlı pullar"),
            keywords: &[
                "bank",
                "dollar",
                "hesab",
                "not",
                "qanadlı pullar",
                "əskinaz",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("грошы з крыламі"),
            keywords: &[
                "грошы",
                "грошы з крыламі",
                "долар",
                "крылы",
                "купюра",
                "палёт",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Пари с крила"),
            keywords: &["Пари с крила", "банкнота", "долар", "крила", "пари"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ট\u{9be}ক\u{9be}র স\u{9be}থে প\u{9be}খ\u{9be}"),
            keywords: &[
                "ওড\u{9bc}\u{9be}",
                "ট\u{9be}ক\u{9be}",
                "ট\u{9be}ক\u{9be}র স\u{9be}থে প\u{9be}খ\u{9be}",
                "ড\u{9be}ন\u{9be}",
                "বিল",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("moneiz o nijal"),
            keywords: &["arcʼhant", "bilhed", "moneiz", "moneiz o nijal", "nij"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("novac sa krilima"),
            keywords: &["dolar", "krila", "novac", "novac sa krilima", "novčanica"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("diners amb ales"),
            keywords: &["ales", "diners", "diners amb ales"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏕᎳ ᏗᎪᏯᏓ"),
            keywords: &["ᎠᏕᎳ", "ᎠᏕᎳ ᏗᎪᏯᏓ", "ᎠᏕᎳ ᏧᏂᏗᎢ ᎪᏪᎵ", "ᎤᏃᏍᏓ", "ᎦᏃᎯᎵᏙᎯ", "ᏗᎧᏃᎨᏂ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("okřídlené peníze"),
            keywords: &["banka", "bankovka", "dolar", "okřídlené peníze", "peníze"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("arian gydag adenydd"),
            keywords: &[
                "adenydd",
                "arian cyfredol",
                "arian gydag adenydd",
                "banc",
                "papur arian",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("flyvende penge"),
            keywords: &["flyvende penge", "forbrug", "penge", "penge med vinger"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Geldschein mit Flügeln"),
            keywords: &["Bank", "Geld", "Geldschein mit Flügeln"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("λεφτά με φτερά"),
            keywords: &[
                "δολάριο",
                "λεφτά με φτερά",
                "φτερά",
                "χαρτονόμισμα",
                "χρήματα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("money with wings"),
            keywords: &[
                "banknote",
                "bill",
                "fly",
                "money",
                "money with wings",
                "wings",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("billete con alas"),
            keywords: &[
                "billete",
                "billete con alas",
                "billete de banco",
                "dinero",
                "dinero con alas",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["alas", "billete con alas", "billetes", "dinero", "dólares"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("tiibadega raha"),
            keywords: &["dollar", "pank", "raha", "tiibadega raha", "tiivad"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("dirua hegoekin"),
            keywords: &["billetea", "dirua", "dirua hegoekin", "dolarra", "hegan"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("اسکناس بال\u{200c}دار"),
            keywords: &[
                "ارز",
                "اسکناس",
                "اسکناس بال\u{200c}دار",
                "بال",
                "بانک",
                "پول",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("rahalla on siivet"),
            keywords: &[
                "pankki",
                "raha",
                "rahalla on siivet",
                "seteli",
                "siivet",
                "valuutta",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("perang may pakpak"),
            keywords: &[
                "banknote",
                "bill",
                "lipad",
                "pakpak",
                "pera",
                "perang may pakpak",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("pengar við veingjum"),
            keywords: &[
                "dollarar",
                "dollari",
                "gjaldoyra",
                "pengar við veingjum",
                "pengaseðil",
                "seðil",
                "veingjar",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("billet avec des ailes"),
            keywords: &["billet", "billet avec des ailes"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("airgead ag eitilt"),
            keywords: &["airgead", "airgead ag eitilt", "dollar", "eitilt"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("airgead le sgiathan"),
            keywords: &[
                "airgead",
                "airgead le sgiathan",
                "banca",
                "dolar",
                "not",
                "nòta",
                "nòta-airgid",
                "nòta-banca",
                "sgiathan",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("diñeiro voando"),
            keywords: &["alas", "billetes", "cartos", "diñeiro voando", "ás"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{a82}ખ સાથ\u{ac7}ના\u{a82} પ\u{ac8}સા"),
            keywords: &[
                "ઊડતા પ\u{ac8}સા",
                "ઊડતી બ\u{ac7}\u{a82}કનોટ",
                "નોટ",
                "પ\u{a82}ખ સાથ\u{ac7}ના\u{a82} પ\u{ac8}સા",
                "પ\u{ac8}સા",
                "બ\u{ac7}\u{a82}ક",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kuɗi mai fikafiki"),
            keywords: &[
                "banki",
                "dala",
                "fikafiki",
                "kuɗi",
                "kuɗi mai fikafiki",
                "kuɗin banki",
                "takardar kuɗi",
                "tashi",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כסף עם כנפיים"),
            keywords: &["דולר", "כנפיים", "כסף", "כסף עם כנפיים", "עף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{902}खो\u{902} वाला धन"),
            keywords: &[
                "उड\u{93c}ता ब\u{948}\u{902}कनोट",
                "उड\u{93c}त\u{947} प\u{948}स\u{947}",
                "नोट",
                "प\u{902}खो\u{902} वाला धन",
                "प\u{902}खो\u{902} वाल\u{947} प\u{948}स\u{947}",
                "प\u{948}स\u{947}",
                "ब\u{948}\u{902}क",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("novac s krilima"),
            keywords: &["krila", "letjeti", "novac", "novac s krilima", "novčanica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("pénz szárnyakkal"),
            keywords: &["bankjegy", "dollár", "pénz", "pénz szárnyakkal", "szárnyak"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("փող թևերով"),
            keywords: &[
                "բանկ",
                "դոլար",
                "թղթադրամ",
                "թռչել",
                "թևեր",
                "փող",
                "փող թևերով",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("uang bersayap"),
            keywords: &["sayap", "terbang", "uang", "uang bersayap", "uang kertas"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ego nwere ǹkù"),
            keywords: &[
                "akwụkwọego ụlọakụ",
                "dọlla",
                "ego",
                "ego nwere ǹkù",
                "fly",
                "ǹkù",
                "ụgwọ",
                "ụlọakụ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fljúgandi peningar"),
            keywords: &[
                "fljúgandi peningar",
                "fljúgandi peningaseðill",
                "peningar",
                "peningaseðill með vængi",
                "seðill",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("soldi con le ali"),
            keywords: &[
                "banconota",
                "banconota con le ali",
                "soldi",
                "soldi che volano",
                "soldi con le ali",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("羽が生えたお金"),
            keywords: &["お札", "お金", "ドル", "札束", "羽が生えたお金"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("dhuwit nduwe swiwi"),
            keywords: &[
                "dhuwit",
                "dhuwit kertas",
                "dhuwit nduwe swiwi",
                "mabur",
                "swiwi",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ფული ფრთებით"),
            keywords: &[
                "ბანკნოტი",
                "დოლარი",
                "ფრენა",
                "ფრთები",
                "ფული",
                "ფული ფრთებით",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қанаты бар ақша"),
            keywords: &[
                "ақша",
                "банкнота",
                "шот",
                "қанаттар",
                "қанаты бар ақша",
                "ұшу",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("flyvende penge"),
            keywords: &["flyvende penge", "penge", "penge med vinger"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ល\u{17bb}យម\u{17bd}យបាច\u{17cb}មានដ\u{17bb}ះស\u{17d2}លាប"),
            keywords: &[
                "ក\u{17d2}រដាសប\u{17d2}រាក\u{17cb}",
                "ល\u{17bb}យ",
                "ល\u{17bb}យមានស\u{17d2}លាប",
                "ល\u{17bb}យម\u{17bd}យបាច\u{17cb}មានដ\u{17bb}ះស\u{17d2}លាប",
                "ស\u{17d2}លាប",
                "ហោះ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ರ\u{cc6}ಕ\u{ccd}ಕ\u{cc6}ಗಳೊಂದ\u{cbf}ಗ\u{cc6} ಹಣ"),
            keywords: &[
                "ನೋಟ\u{ccd}",
                "ಬ\u{ccd}ಯಾಂಕ\u{ccd}",
                "ರ\u{cc6}ಕ\u{ccd}ಕ\u{cc6}ಗಳೊಂದ\u{cbf}ಗ\u{cc6} ಹಣ",
                "ಹಣ",
                "ಹಾರಾಡುವ ಬ\u{ccd}ಯಾಂಕ\u{ccd}\u{200c}ನೋಟ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("날개 달린 돈"),
            keywords: &[
                "날개 달린 돈",
                "날아가는 돈",
                "돈",
                "돈 날림",
                "손해",
                "지폐",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पाखा\u{902} आसपी पयश\u{947}"),
            keywords: &[
                "उडप",
                "पयश\u{947}",
                "पाखा\u{902}",
                "पाखा\u{902} आसपी पयश\u{947}",
                "ब\u{901}कनोट",
                "बील",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("канаты бар акча"),
            keywords: &["акча", "банкнота", "доллар", "канаты бар акча", "эсеп"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Geldschäiner mat Flilleken"),
            keywords: &[
                "Bank",
                "Dollar",
                "Flilleken",
                "Geld",
                "Geldschäin",
                "Geldschäiner mat Flilleken",
                "Rechnung",
                "Schäin",
                "Suen",
                "fléien",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເງ\u{eb4}ນທ\u{eb5}\u{ec8}ມ\u{eb5}ປ\u{eb5}ກ"),
            keywords: &[
                "ທະນາຄານ",
                "ປ\u{eb5}ກ",
                "ເງ\u{eb4}ນ",
                "ເງ\u{eb4}ນທ\u{eb5}\u{ec8}ມ\u{eb5}ປ\u{eb5}ກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("pinigai su sparnais"),
            keywords: &[
                "bankas",
                "banknotas",
                "doleris",
                "pinigai",
                "pinigai su sparnais",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("banknote ar spārniem"),
            keywords: &[
                "banknote",
                "banknote ar spārniem",
                "lidot",
                "nauda",
                "spārni",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("moni whai parirau"),
            keywords: &[
                "moni",
                "moni whai parirau",
                "monipepa",
                "parirau",
                "pepa",
                "pire",
                "pēke",
                "rere",
                "tāra",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("пари со крилја"),
            keywords: &["банкнота", "долар", "крилја", "пари", "пари со крилја"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ചിറക\u{d41}ള\u{d4d}ള പണം"),
            keywords: &[
                "ചിറക\u{d41}ള\u{d4d}ള പണം",
                "നോട\u{d4d}ട\u{d4d}",
                "പണം",
                "പറക\u{d4d}ക\u{d41}ന\u{d4d}ന പണം",
                "പറക\u{d4d}ക\u{d41}ന\u{d4d}ന ബ\u{d3e}ങ\u{d4d}ക\u{d4d} നോട\u{d4d}ട\u{d4d}",
                "ബ\u{d3e}ങ\u{d4d}ക\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("далавчтай мөнгө"),
            keywords: &[
                "банкны мөнгөн тэмдэгт",
                "далавч",
                "далавчтай мөнгө",
                "мөнгө",
                "нисэх",
                "нэхэмжлэх",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{902}ख असल\u{947}ला प\u{948}सा"),
            keywords: &[
                "उडण\u{947}",
                "नोट",
                "प\u{902}ख",
                "प\u{902}ख असल\u{947}ला प\u{948}सा",
                "प\u{948}सा",
                "ब\u{901}कनोट",
                "बिल",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("wang kertas bersayap"),
            keywords: &[
                "sayap",
                "terbang",
                "wang",
                "wang dengan sayap",
                "wang kertas",
                "wang kertas bersayap",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("flus bil-ġwienaħ"),
            keywords: &[
                "bank",
                "dollaru",
                "flus",
                "flus bil-ġwienaħ",
                "fly",
                "karta",
                "karta tal-flus",
                "nota",
                "ġwienaħ",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အတောင\u{103a}ပ\u{1036}ပါ င\u{103d}ေ"),
            keywords: &[
                "င\u{103d}ေ",
                "င\u{103d}ေစက\u{1039}က\u{1030}",
                "အတောင\u{103a}ပ\u{1036}",
                "အတောင\u{103a}ပ\u{1036}ပါ င\u{103d}ေ",
                "အတောင\u{103a}ပ\u{1036}ဖြန\u{1037}\u{103a} ပျ\u{1036}နေသော င\u{103d}ေစက\u{1039}က\u{1030}ပ\u{102f}\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("penger med vinger"),
            keywords: &[
                "bank",
                "flygende seddel",
                "penger",
                "penger med vinger",
                "seddel",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पख\u{947}टावाला प\u{948}सा"),
            keywords: &[
                "उड\u{94d}न\u{947}",
                "पख\u{947}टा",
                "पख\u{947}टावाला प\u{948}सा",
                "प\u{948}सा",
                "बिल",
                "\u{948}\u{902}कनोट",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vliegend geld"),
            keywords: &[
                "bankbiljet",
                "biljet",
                "geld",
                "geld met vleugels",
                "vleugels",
                "vliegen",
                "vliegend geld",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("pengar med vinger"),
            keywords: &[
                "bank",
                "flygande setel",
                "pengar",
                "pengar med vinger",
                "setel",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଡେଣ\u{b3e} ଥ\u{b3f}ବ\u{b3e} ଟଙ\u{b4d}କ\u{b3e}"),
            keywords: &[
                "ଟଙ\u{b4d}କ\u{b3e}",
                "ଡେଣ\u{b3e} ଥ\u{b3f}ବ\u{b3e} ଟଙ\u{b4d}କ\u{b3e}",
                "ପ\u{b4d}ଲ\u{b3e}ଏ",
                "ବ\u{b4d}ୟ\u{b3e}ଙ\u{b4d}କନୋଟ\u{b4d}\u{200c}",
                "ରସ\u{b3f}ଦ\u{b4d}\u{200c}",
                "ୱ\u{b3f}ଙ\u{b4d}ଗସ\u{b4d}\u{200c}",
                "ୱ\u{b3f}ଙ\u{b4d}ଗସ\u{b4d}\u{200c} ସହ\u{b3f}ତ ଟଙ\u{b4d}କ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਖ\u{a70}ਬ ਲ\u{a71}ਗ\u{a47} ਪ\u{a48}ਸ\u{a47}"),
            keywords: &[
                "ਉ\u{a71}ਡਦ\u{a47} ਪ\u{a48}ਸ\u{a47}",
                "ਖ\u{a70}ਬ ਲ\u{a71}ਗ\u{a47} ਪ\u{a48}ਸ\u{a47}",
                "ਖ\u{a70}ਭ ਲ\u{a71}ਗ\u{a47} ਪ\u{a48}ਸ\u{a47}",
                "ਨ\u{a4b}ਟ",
                "ਪ\u{a48}ਸਾ",
                "ਬਿਲ",
                "ਬ\u{a48}\u{a02}ਕ",
                "ਬ\u{a48}\u{a02}ਕਨ\u{a4b}ਟ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پیسیاں نال پر"),
            keywords: &[
                "بل",
                "بینک",
                "بینک دا ر\u{64f}قعہ",
                "ر\u{64f}قعہ",
                "مکھی",
                "پر",
                "پیسیاں نال پر",
                "پیسے",
                "ڈالر",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mọní Wé Gẹ\u{301}t Wing"),
            keywords: &[
                "Bil",
                "Bánknot",
                "Flai",
                "Mọní",
                "Mọní Wé Gẹ\u{301}t Wing",
                "Wing",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("uskrzydlone pieniądze"),
            keywords: &[
                "bank",
                "banknot",
                "pieniądze",
                "rachunek",
                "skrzydła",
                "uskrzydlone pieniądze",
                "waluta",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پیسې د وزرونو"),
            keywords: &[
                "بل",
                "د بانک نوټ",
                "وزرې",
                "پيسې",
                "پيسې د وزرونو",
                "پیسې د وزرونو",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("dinheiro voando"),
            keywords: &[
                "banco",
                "dinheiro",
                "dinheiro com asas",
                "dinheiro voando",
                "nota",
                "nota bancária voando",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("dinheiro com asas"),
            keywords: &[
                "asas",
                "banco",
                "dinheiro",
                "dinheiro com asas",
                "dólar",
                "nota",
                "voar",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bani înaripați"),
            keywords: &["aripi", "bancnotă", "bani", "bani înaripați", "zbor"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-629"),
            keywords: &["E10-629"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("банкнота с крылышками"),
            keywords: &[
                "банкнота",
                "банкнота с крылышками",
                "деньги",
                "крылья",
                "летающая банкнота",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("amafaranga afite amababa"),
            keywords: &[
                "amababa",
                "amafaranga afite amababa",
                "banki",
                "idolari",
                "ifaranga",
                "inoti",
                "kuguruka",
                "urupapuro mvunjwafaranga",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پرن وارا پئسا"),
            keywords: &[
                "اڏڻ",
                "بئنڪ",
                "بل",
                "رقم",
                "نوٽ",
                "پر",
                "پرن وارا پئسا",
                "ڊالر",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd2}ය\u{dcf}පත\u{dca} ඇත\u{dd2} ම\u{dd4}දල\u{dca}"),
            keywords: &[
                "ඩොලර\u{dca} නෝට\u{dca}ට\u{dd4}ව",
                "ප\u{dd2}ය\u{dcf}පත\u{dca} ඇත\u{dd2} ම\u{dd4}දල\u{dca}",
                "බැංක\u{dd4} නෝට\u{dca}ට\u{dd4}ව",
                "බැංක\u{dd4}ව",
                "බ\u{dd2}ල",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("peniaze s krídlami"),
            keywords: &[
                "bankovka",
                "dolár",
                "krídla",
                "lietať",
                "peniaze",
                "peniaze s krídlami",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("denar s krili"),
            keywords: &[
                "apoen",
                "banka",
                "bankovec",
                "denar",
                "denar s krili",
                "dolar",
                "krila",
                "leteti",
                "valuta",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("lacag baalal leh"),
            keywords: &[
                "baalal",
                "biil",
                "duulid",
                "lacag",
                "lacag baalal leh",
                "warqad bangi",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("para me krahë"),
            keywords: &["fluturoj", "kartëmonedhë", "krahë", "para", "para me krahë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("новац са крилима"),
            keywords: &["крилa", "лeтeњe", "нoвaц", "нoвчaницa", "новац са крилима"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("novac sa krilima"),
            keywords: &["krila", "letenje", "novac", "novac sa krilima", "novčanica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("pengar med vingar"),
            keywords: &["flygande sedlar", "pengar", "pengar med vingar"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("pesa za noti zenye mabawa"),
            keywords: &[
                "benki",
                "dola",
                "mabawa",
                "noti",
                "pepea",
                "pesa",
                "pesa za noti zenye mabawa",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பறக\u{bcd}கும\u{bcd} பணம\u{bcd}"),
            keywords: &[
                "இறக\u{bcd}கைகளுடன\u{bcd} கூடிய பணம\u{bcd}",
                "பணம\u{bcd}",
                "பறக\u{bcd}கும\u{bcd} பணம\u{bcd}",
                "பறக\u{bcd}கும\u{bcd} வங\u{bcd}கிப\u{bcd} பணம\u{bcd}",
                "வங\u{bcd}கி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ర\u{c46}క\u{c4d}కలు ఉన\u{c4d}న డబ\u{c4d}బు"),
            keywords: &[
                "డబ\u{c4d}బు ఖర\u{c4d}చయ\u{c3f}ప\u{c4b}వడం",
                "ర\u{c46}క\u{c4d}కలు ఉన\u{c4d}న డబ\u{c4d}బు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("пул бо қанотҳо"),
            keywords: &[
                "асъор",
                "бонк",
                "пул",
                "пул бо қанотҳо",
                "қанотҳо",
                "қоғази пул",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เง\u{e34}นบ\u{e34}น"),
            keywords: &["เง\u{e34}นบ\u{e34}น", "เง\u{e34}นม\u{e35}ป\u{e35}ก"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ganatly pul"),
            keywords: &["bank", "banknot", "ganatlar", "ganatly pul", "pul", "uçmak"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("paʻanga moe kapakau"),
            keywords: &["paʻanga moe kapakau"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kanatlı para"),
            keywords: &["banka", "banknot", "kanatlı para", "para", "uçan banknot"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قاناتلىق پۇل"),
            keywords: &[
                "ئاقچا",
                "ئۇچۇش",
                "بانكا",
                "تەڭگە",
                "قانات",
                "قاناتلىق پۇل",
                "قەغەز پۇل",
                "يارماق",
                "پۇل",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("гроші з крилами"),
            keywords: &[
                "банк",
                "банкнота",
                "гроші",
                "гроші з крилами",
                "долар",
                "крила",
                "купюра",
                "літати",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پروں والے نوٹ"),
            keywords: &["اڑنا", "بنک", "رقم", "نوٹ", "پر", "پروں والے نوٹ", "ڈالر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qanoti bor pul dastasi"),
            keywords: &[
                "banknot",
                "hisob",
                "pul",
                "qanot",
                "qanoti bor pul dastasi",
                "qanotlar",
                "qanotli pul",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tiền có cánh"),
            keywords: &["bay", "cánh", "tiền có cánh", "tiền giấy", "đô la"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xaalis bu am ay laaf"),
            keywords: &[
                "ay laaf",
                "biye",
                "bànk",
                "dollar",
                "fly",
                "xaalis",
                "xaalis bu am ay laaf",
                "xaalisu këyit",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("imali eneempiko"),
            keywords: &[
                "i-dollar",
                "i-fly",
                "ibhanki",
                "iimpiko",
                "imali",
                "imali eliphepha",
                "imali eneempiko",
                "ityala",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("owo pẹlu awọn iyẹ"),
            keywords: &[
                "dó\u{329}là",
                "fò",
                "ilé-ìfowópamó\u{329}",
                "owo pẹlu awọn iyẹ",
                "owó",
                "owó bánkì",
                "ìwó iye owó",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("有翼嘅錢"),
            keywords: &["有翼嘅錢", "紙幣", "翼", "銀紙", "飛"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("有翼嘅钱"),
            keywords: &[
                "帐单",
                "有翼嘅钱",
                "纸币",
                "美元",
                "翼",
                "钱",
                "银纸",
                "银行",
                "飞",
            ],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("长翅膀的钱"),
            keywords: &["纸币", "翅膀", "花钱", "钱", "长翅膀的钱"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("錢飛了"),
            keywords: &["沒錢了", "錢飛了"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("錢飛走"),
            keywords: &["冇錢", "錢飛走"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("imali enamaphiko"),
            keywords: &[
                "amaphiko",
                "ibhange",
                "idola",
                "imali",
                "imali enamaphiko",
                "isikweletu",
                "ukundiza",
            ],
        },
    ],
};
#[doc = "💳"]
pub const CREDIT_CARD: crate::Emoji = crate::Emoji {
    glyph: "💳",
    codepoint: "1F4B3",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "credit card",
    group: "Objects",
    subgroup: "money",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kredietkaart"),
            keywords: &["bank", "geld", "kaart", "krediet", "kredietkaart"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ክሬዲት ካርድ"),
            keywords: &["ባንክ", "ካርታ", "ክሬዲት", "ክሬዲት ካርድ", "ገንዘብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بطاقة ائتمان"),
            keywords: &["بطاقة", "بطاقة ائتمان"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9cd}ৰেডিট ক\u{9be}ৰ\u{9cd}ড"),
            keywords: &[
                "ক\u{9be}ৰ\u{9cd}ড",
                "ক\u{9cd}ৰেডিট ক\u{9be}ৰ\u{9cd}ড",
                "ধন",
                "ধ\u{9be}ৰ",
                "বেংক",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kredit kartı"),
            keywords: &["bank", "kart", "kredit", "kredit kartı", "pul"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("крэдытная карта"),
            keywords: &[
                "банк",
                "грошы",
                "картка",
                "крэдыт",
                "крэдытка",
                "крэдытная карта",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Кредитна карта"),
            keywords: &["Кредитна карта", "банка", "карта", "кредитна", "пари"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9cd}রেডিট ক\u{9be}র\u{9cd}ড"),
            keywords: &[
                "ক\u{9be}র\u{9cd}ড",
                "ক\u{9cd}রেডিট ক\u{9be}র\u{9cd}ড",
                "ট\u{9be}ক\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kartenn-vank"),
            keywords: &["arcʼhant", "bank", "kartenn", "kartenn-vank", "moneiz"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kreditna kartica"),
            keywords: &["kartica", "kredit", "kreditna kartica", "pare"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("targeta de crèdit"),
            keywords: &["crèdit", "targeta", "targeta de crèdit"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏓᏚᏍᎩ ᏆᏂᏲᏍᏗ"),
            keywords: &["ᎠᏓᏚᏍᎩ ᏆᏂᏲᏍᏗ", "ᎠᏕᎳ", "ᏗᎪᏯᏓ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("platební karta"),
            keywords: &[
                "banka",
                "karta",
                "kredit",
                "kreditka",
                "kreditní",
                "peníze",
                "platební karta",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cerdyn credyd"),
            keywords: &["arian", "banc", "card", "cerdyn credyd", "credyd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kreditkort"),
            keywords: &["bank", "kort", "kredit", "kreditkort", "penge"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Kreditkarte"),
            keywords: &["Guthaben", "Karte", "Kreditkarte"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πιστωτική κάρτα"),
            keywords: &["κάρτα", "πιστωτική", "χρήματα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("credit card"),
            keywords: &["card", "credit", "money"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("tarjeta de crédito"),
            keywords: &["crédito", "tarjeta", "tarjeta de crédito"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("krediitkaart"),
            keywords: &["kaart", "krediit", "krediitkaart", "pank", "raha"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kreditu-txartela"),
            keywords: &["banku", "diru", "kreditu", "kreditu-txartela", "txartel"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کارت اعتباری"),
            keywords: &["اعتبار", "بانک", "پول", "کارت", "کارت اعتباری"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("luottokortti"),
            keywords: &["kortti", "luotto", "luottokortti", "pankki", "raha"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("credit card"),
            keywords: &["card", "credit", "pera", "utang"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kredittkort"),
            keywords: &[
                "keypskort",
                "kontukort",
                "kredittkort",
                "kritkort",
                "pengar",
                "peningur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("carte bancaire"),
            keywords: &["bancaire", "carte"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("carte de crédit"),
            keywords: &["argent", "carte", "carte de crédit", "crédit"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cárta creidmheasa"),
            keywords: &["cárta", "cárta creidmheasa"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cairt-chreideis"),
            keywords: &["airgead", "banca", "cairt", "cairt-chreideis", "creideas"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("tarxeta de crédito"),
            keywords: &["banco", "diñeiro", "tarxeta", "tarxeta de crédito"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ક\u{acd}ર\u{ac7}ડિટ કાર\u{acd}ડ"),
            keywords: &["કાર\u{acd}ડ", "ક\u{acd}ર\u{ac7}ડિટ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("katin bashi"),
            keywords: &["banki", "bashi", "kati", "katin bashi", "kuɗi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כרטיס אשראי"),
            keywords: &["אשראי", "כסף", "כרטיס"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("क\u{94d}र\u{947}डिट कार\u{94d}ड"),
            keywords: &["कार\u{94d}ड", "क\u{94d}र\u{947}डिट", "धन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kreditna kartica"),
            keywords: &["kartica", "kredit", "kreditna kartica", "novac"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("hitelkártya"),
            keywords: &["bank", "bankkártya", "hitelkártya", "kártya"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("պլաստիկ քարտ"),
            keywords: &["բանկ", "պլաստիկ քարտ", "վարկ", "փող", "քարտ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kartu kredit"),
            keywords: &["kartu", "kredit", "uang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("kaadị njiakwụụgwọ"),
            keywords: &["ego", "kaadị", "njiakwụụgwọ", "ụlọakụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kreditkort"),
            keywords: &["greiðslukort", "kort", "kredit", "kreditkort"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("carta di credito"),
            keywords: &["carta", "carta di credito", "credito"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("クレジットカード"),
            keywords: &[
                "お金",
                "カード",
                "キャッシュカード",
                "クレジットカード",
                "銀行",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kertu kredhit"),
            keywords: &["dhuwit", "kertu", "kredhit"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("საკრედიტო ბარათი"),
            keywords: &["საკრედიტო", "საკრედიტო ბარათი", "ფული"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("несие картасы"),
            keywords: &["ақша", "банк", "карта", "несие", "несие картасы"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kreditkort"),
            keywords: &["bank", "kort", "kredit", "kreditkort", "penge"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កាតឥនទាន"),
            keywords: &[
                "កាត",
                "កាតឥនទាន",
                "ប\u{17d0}ណ\u{17d2}ណ",
                "ល\u{17bb}យ",
                "ឥណទាន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{ccd}ರ\u{cc6}ಡ\u{cbf}ಟ\u{ccd} ಕಾರ\u{ccd}ಡ\u{ccd}"),
            keywords: &["ಕಾರ\u{ccd}ಡ\u{ccd}", "ಕ\u{ccd}ರ\u{cc6}ಡ\u{cbf}ಟ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("신용카드"),
            keywords: &["신용카드", "카드"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("क\u{94d}र\u{947}डिट कार\u{94d}ड"),
            keywords: &["कार\u{94d}ड", "क\u{94d}र\u{947}डिट", "पयश\u{947}"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("насыя картасы"),
            keywords: &["акча", "банк", "карта", "насыя", "насыя картасы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Kreditkaart"),
            keywords: &["Bank", "Geld", "Kaart", "Kredit", "Kreditkaart", "Suen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ບ\u{eb1}ດເຄຣດ\u{eb4}ດ"),
            keywords: &[
                "ທະນາຄານ",
                "ບ\u{eb1}ດ",
                "ບ\u{eb1}ດເຄຣດ\u{eb4}ດ",
                "ເຄຣດ\u{eb4}ດ",
                "ເງ\u{eb4}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kredito kortelė"),
            keywords: &[
                "bankas",
                "kortelė",
                "kreditas",
                "kredito kortelė",
                "pinigai",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kredītkarte"),
            keywords: &["kredītkarte", "nauda"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kāri tāwere"),
            keywords: &["kāri", "moni", "pēke", "tāwere"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("кредитна картичка"),
            keywords: &["банка", "картичка", "кредитна", "пари"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d4d}രെഡിറ\u{d4d}റ\u{d4d} ക\u{d3e}ർഡ\u{d4d}"),
            keywords: &["ക\u{d3e}ർഡ\u{d4d}", "ക\u{d4d}രെഡിറ\u{d4d}റ\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("кредит карт"),
            keywords: &["карт", "кредит", "мөнгө"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("क\u{94d}र\u{947}डिट कार\u{94d}ड"),
            keywords: &[
                "कार\u{94d}ड",
                "क\u{94d}र\u{947}डिट",
                "प\u{948}सा",
                "ब\u{901}क",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kad kredit"),
            keywords: &["bank", "kad", "kredit", "wang"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("karta tal-kreditu"),
            keywords: &["bank", "flus", "karta", "karta tal-kreditu", "kreditu"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ခရက\u{103a}ဒစ\u{103a}ကတ\u{103a}"),
            keywords: &[
                "ကတ\u{103a}",
                "ခရက\u{103a}ဒစ\u{103a}",
                "ခရက\u{103a}ဒစ\u{103a}ကတ\u{103a}",
                "ဘဏ\u{103a}ကတ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kredittkort"),
            keywords: &[
                "bankkort",
                "betalingskort",
                "kort",
                "kreditt",
                "kredittkort",
                "visa",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("क\u{94d}र\u{947}डिट कार\u{94d}ड"),
            keywords: &[
                "कार\u{94d}ड",
                "क\u{94d}र\u{947}डिट",
                "प\u{948}सा",
                "ब\u{948}\u{902}क",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("creditcard"),
            keywords: &["creditcard", "geld", "kaart", "krediet"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kredittkort"),
            keywords: &[
                "bankkort",
                "betalingskort",
                "kort",
                "kreditt",
                "kredittkort",
                "visa",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b4d}ରେଡ\u{b3f}ଟ\u{b4d}\u{200c} କ\u{b3e}ର\u{b4d}ଡ\u{b4d}"),
            keywords: &[
                "କ\u{b3e}ର\u{b4d}ଡ\u{b3c}",
                "କ\u{b4d}ରେଡ\u{b3c}\u{b3f}ଟ\u{b4d}\u{200c}",
                "କ\u{b4d}ରେଡ\u{b3f}ଟ\u{b4d}\u{200c} କ\u{b3e}ର\u{b4d}ଡ\u{b4d}",
                "ଟଙ\u{b4d}କ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a4d}ਰ\u{a48}ਡਿਟ ਕਾਰਡ"),
            keywords: &[
                "ਕਾਰਡ",
                "ਕ\u{a4d}ਰ\u{a48}ਡਿਟ",
                "ਪ\u{a48}ਸਾ",
                "ਬ\u{a48}\u{a02}ਕ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کریڈٹ کارڈ"),
            keywords: &["ادھار", "بینک", "پیسے", "کارڈ", "کریڈٹ کارڈ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Krẹ\u{301}dít Kad"),
            keywords: &["Kad", "Krẹ\u{301}dit", "Krẹ\u{301}dít Kad", "Mọní"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("karta kredytowa"),
            keywords: &["bank", "karta", "karta kredytowa", "kredyt", "pieniądze"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کریډیټ کارت"),
            keywords: &["پېسې", "کارت", "کریډیټ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cartão de crédito"),
            keywords: &["cartão", "cartão de crédito", "crédito", "dinheiro"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "banco",
                "cartão",
                "cartão de crédito",
                "crédito",
                "dinheiro",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("card de credit"),
            keywords: &["bani", "card", "card de credit", "credit", "plată"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-624"),
            keywords: &["E10-624"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("кредитная карта"),
            keywords: &[
                "банковская карта",
                "банковская карточка",
                "деньги",
                "карта",
                "карточка",
                "кредитная карта",
                "кредитная карточка",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikarita ya keredi"),
            keywords: &[
                "amafaranga",
                "banki",
                "ikarita",
                "ikarita ya keredi",
                "inguzanyo",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪريڊٽ ڊالر"),
            keywords: &["بئنڪ", "رقم", "ڪارڊ", "ڪريڊٽ", "ڪريڊٽ ڊالر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ණය ක\u{dcf}ඩ\u{dca}පත"),
            keywords: &[
                "ක\u{dca}\u{200d}රෙඩ\u{dd2}ට\u{dca}",
                "ක\u{dcf}ඩ\u{dca}පත",
                "ණය ක\u{dcf}ඩ\u{dca}පත",
                "බැංක\u{dd4}ව",
                "ම\u{dd4}දල\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("platobná karta"),
            keywords: &[
                "banka",
                "karta",
                "kredit",
                "peniaze",
                "platiť",
                "platobná karta",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kreditna kartica"),
            keywords: &["banka", "denar", "kartica", "kreditna kartica", "kreditno"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kaarka deynta"),
            keywords: &["deyn", "kaar", "kaarka deynta", "lacag"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kartë krediti"),
            keywords: &["bankë", "kartë", "kartë krediti", "kredit", "para"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кредитна картица"),
            keywords: &["картица", "кредит", "кредитна картица", "новац"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["кредитна картица"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kreditna kartica"),
            keywords: &["kartica", "kredit", "kreditna kartica", "novac"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["kreditna kartica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kreditkort"),
            keywords: &["betalkort", "kort", "kreditkort"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kadi ya mkopo"),
            keywords: &["benki", "kadi", "kadi ya mkopo", "mkopo", "pesa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கிரெடிட\u{bcd} க\u{bbe}ர\u{bcd}டு"),
            keywords: &["க\u{bbe}ர\u{bcd}டு", "கிரெடிட\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c4d}ర\u{c46}డ\u{c3f}ట\u{c4d} క\u{c3e}ర\u{c4d}డ\u{c4d}"),
            keywords: &[
                "క\u{c3e}ర\u{c4d}డ\u{c4d}",
                "క\u{c4d}ర\u{c46}డ\u{c3f}ట\u{c4d}",
                "ల\u{c3e}వ\u{c3e}ద\u{c47}వ\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("корти кредитӣ"),
            keywords: &["бонк", "корт", "корти кредитӣ", "пул", "қарз"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("บ\u{e31}ตรเครด\u{e34}ต"),
            keywords: &["บ\u{e31}ตร", "บ\u{e31}ตรเครด\u{e34}ต"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kredit karty"),
            keywords: &["karz", "kredit karty", "petek", "pul"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kaati pangikē"),
            keywords: &["kaati pangikē"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kredi kartı"),
            keywords: &["kart", "kredi", "kredi kartı"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئىناۋەتلىك كارتا"),
            keywords: &["ئىناۋەت", "ئىناۋەتلىك كارتا", "بانكا", "كارتا", "پۇل"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кредитна картка"),
            keywords: &["банк", "гроші", "картка", "кредитна"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کریڈٹ کارڈ"),
            keywords: &["بنک", "رقم", "کارڈ", "کریڈٹ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kredit karta"),
            keywords: &["karta", "kredit", "pul"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("thẻ tín dụng"),
            keywords: &["thẻ", "thẻ tín dụng", "tiền", "tín dụng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kàrtu keredi"),
            keywords: &["bànk", "keredi", "kàrt", "kàrtu keredi", "xaalis"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ikhadi letyala"),
            keywords: &["ibhanki", "ikhadi", "ikhadi letyala", "ikhredithi", "imali"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("káàdì ìsọdowó"),
            keywords: &[
                "ilé ìfowópamó\u{329}",
                "káàdì",
                "káàdì ìsọdowó",
                "owó",
                "ààwìn",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("信用卡"),
            keywords: &["信用", "信用卡", "卡", "銀行", "錢"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("信用卡"),
            keywords: &["信用", "信用卡", "卡", "钱", "银行"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("信用卡"),
            keywords: &["信用卡", "借记卡", "刷卡", "卡", "贷记卡", "银行卡"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("信用卡"),
            keywords: &["信用卡", "刷卡"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["信用卡", "碌卡"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ikhredithi khadi"),
            keywords: &[
                "ibhange",
                "ikhadi",
                "ikhredithi",
                "ikhredithi khadi",
                "imali",
            ],
        },
    ],
};
#[doc = "🧾"]
pub const RECEIPT: crate::Emoji = crate::Emoji {
    glyph: "🧾",
    codepoint: "1F9FE",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "receipt",
    group: "Objects",
    subgroup: "money",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kwitansie"),
            keywords: &["bewys", "bewyse", "boekhou", "kwitansie", "rekeningkunde"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ደረሰኝ"),
            keywords: &["ሂሳብ አያያዝ", "ማረጋገጫ", "ማስረጃ", "የመዝገብ አያያዝ", "ደረሰኝ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("إيصال"),
            keywords: &["إيصال", "برهان", "حفظ الدفاتر", "دليل", "محاسبة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ৰচিদ"),
            keywords: &[
                "এক\u{9be}উণ\u{9cd}টিং",
                "প\u{9cd}ৰম\u{9be}ণ",
                "প\u{9cd}ৰ\u{9be}ম\u{9be}ণিক তথ\u{9cd}য",
                "ব\u{9c1}ককিপিং",
                "ৰচিদ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qəbz"),
            keywords: &["dəlil", "mühasibat", "mühasibatlıq", "qəbz", "sübut"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чэк"),
            keywords: &["бухгалтэрыя", "доказ", "пацвярджэнне", "разлікі", "чэк"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("разписка"),
            keywords: &["доказателство", "разписка", "счетоводство"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("রসিদ"),
            keywords: &[
                "অ\u{9cd}য\u{9be}ক\u{9be}উন\u{9cd}টিং",
                "দলিল",
                "প\u{9cd}রম\u{9be}ণ",
                "রসিদ",
                "হিস\u{9be}বরক\u{9cd}ষণ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("skrid-degemer"),
            keywords: &["prouenn", "skrid-degemer"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("račun"),
            keywords: &[
                "evidencija",
                "izvod",
                "knjigovodstvo",
                "račun",
                "računovodstvo",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("rebut"),
            keywords: &["comptabilitat", "llibres", "prova", "rebut", "tiquet"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎢᎦᎢ ᎠᎫᏴᎲᎢ ᎪᏪᎳ"),
            keywords: &["ᎠᏕᎳ ᏗᏎᎯᎯ", "ᎢᎦᎢ ᎠᎫᏴᎲᎢ ᎪᏪᎳ", "ᎪᎯᏳᏔᏅᎯ", "ᎪᏪᎵ ᏗᎦᏘᏍᏗ", "ᏗᎳᏏᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("účtenka"),
            keywords: &["doklad", "potvrzení", "stvrzenka", "účetnictví", "účtenka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("derbynneb"),
            keywords: &[
                "cadw llyfrau",
                "cyfrifyddu",
                "derbynneb",
                "prawf",
                "tystiolaeth",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvittering"),
            keywords: &["bevis", "bilag", "bogføring", "kvittering", "regnskab"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Beleg"),
            keywords: &[
                "Beleg",
                "Belege",
                "Buchhaltung",
                "Rechnung",
                "Rechnungslegung",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("απόδειξη"),
            keywords: &[
                "αποδείξεις",
                "αποδεικτικά στοιχεία",
                "απόδειξη",
                "λογιστικά",
                "λογιστική",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("receipt"),
            keywords: &["accounting", "bookkeeping", "evidence", "proof", "receipt"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("recibo"),
            keywords: &[
                "contabilidad",
                "prueba",
                "recibo",
                "teneduría de libros",
                "testimonio",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["contabilidad", "contaduría", "evidencia", "recibo"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kviitung"),
            keywords: &["arvepidamine", "kviitung", "raamatupidamine", "tõend"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ordainagiri"),
            keywords: &["froga", "kontabilitate", "ordainagiri"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("رسید"),
            keywords: &["حسابداری", "دفترداری", "رسید", "مدرک", "گواه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kuitti"),
            keywords: &[
                "kirjanpito",
                "kuitti",
                "kulut",
                "tilinpito",
                "todistus",
                "tosite",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("resibo"),
            keywords: &[
                "accounting",
                "bookkeeping",
                "katibayan",
                "patunay",
                "resibo",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kvittan"),
            keywords: &["keyp", "kvittan", "prógv", "søla"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("reçu"),
            keywords: &["comptabilité", "justificatif", "preuve", "reçu"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("admháil"),
            keywords: &["admháil", "cuntasaíocht", "fianaise", "leabharchoiméad"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cuidhteas"),
            keywords: &[
                "cuidhteas",
                "cunntas",
                "cunntasachd",
                "dearbh",
                "dearbhadh",
                "dearbhaich",
                "fianais",
                "leabhar-chunntas",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("recibo"),
            keywords: &[
                "contabilidade",
                "recibo",
                "resgardo",
                "tícket",
                "xustificante",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("રસીદ"),
            keywords: &[
                "એકાઉન\u{acd}ટિ\u{a82}ગ",
                "નામ\u{ac1}\u{a82}",
                "પ\u{ac1}રાવો",
                "રસીદ",
                "સાબિતી",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קבלה"),
            keywords: &["הוכחה", "הנהלת חשבונות", "קבלה", "ראיית חשבון"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("रसीद"),
            keywords: &[
                "प\u{94d}रमाण",
                "बहीखाता",
                "रसीद",
                "ल\u{947}खा\u{902}कन",
                "साक\u{94d}ष\u{94d}य",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("račun"),
            keywords: &["dokaz", "dokaz o kupnji", "račun", "računovodstvo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nyugta"),
            keywords: &["bizonyíták", "könyvelés", "nyugta", "pénzügyek", "számla"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("անդորրագիր"),
            keywords: &["անդորրագիր", "ապացույց", "հաշվապահություն", "վկայություն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kuitansi"),
            keywords: &["akuntansi", "bukti", "kuitansi", "pembukuan"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kvittun"),
            keywords: &[
                "bókfærsla",
                "bókhald",
                "endurskoðun",
                "kvittun",
                "sönnun",
                "sönnunargagn",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("scontrino"),
            keywords: &["contabilità", "ricevuta di pagamento", "scontrino"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("レシート"),
            keywords: &["レシート", "会計", "簿記", "領収書"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("struk tetukon"),
            keywords: &[
                "akuntansi",
                "bukti",
                "kwitansi",
                "pembukuan",
                "struk tetukon",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქვითარი"),
            keywords: &["ბუღალტერია", "მტკიცებულება", "საბუთი", "ქვითარი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("түбіртек"),
            keywords: &[
                "бухгалтерлік",
                "бухгалтерлік есеп",
                "дәлел",
                "растау",
                "түбіртек",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បង\u{17d2}កាន\u{17cb}ដៃ"),
            keywords: &[
                "ការកត\u{17cb}ត\u{17d2}រាក\u{17d2}ន\u{17bb}ងបញ\u{17d2}ជ\u{17b8}គណនេយ\u{17d2}យ",
                "គណនេយ\u{17d2}យ",
                "ត\u{17b9}កតាង",
                "បង\u{17d2}កាន\u{17cb}ដៃ",
                "ភស\u{17d2}ត\u{17bb}តាង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ರಸೀದ\u{cbf}"),
            keywords: &[
                "ಅಕ\u{ccc}ಂಟ\u{cbf}ಂಗ\u{ccd}",
                "ಪುರಾವ\u{cc6}",
                "ಪುರಾವ\u{cc6}ಗಳು",
                "ಬುಕ\u{ccd}\u{200c}ಕೀಪ\u{cbf}ಂಗ\u{ccd}",
                "ರಸೀದ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("영수증"),
            keywords: &["기록", "영수증", "증빙", "회계"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पावती"),
            keywords: &["गवाय", "पावती", "प\u{941}रावो", "हिशोब", "हिशोब बरोवप"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("дүмүрчөк"),
            keywords: &["бухгалтерия", "далил", "документ", "дүмүрчөк", "эсеп-кысап"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໃບຮ\u{eb1}ບເງ\u{eb4}ນ"),
            keywords: &[
                "ການບ\u{eb1}ນຊ\u{eb5}",
                "ຂ\u{ecd}\u{ec9}ພ\u{eb4}ສ\u{eb9}ດ",
                "ຜ\u{eb9}\u{ec9}ຖ\u{eb7}ບ\u{eb1}ນຊ\u{eb5}",
                "ຫ\u{ebc}\u{eb1}ກຖານ",
                "ໃບຮ\u{eb1}ບເງ\u{eb4}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("čekis"),
            keywords: &["apskaita", "čekis", "įrodymai"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kvīts"),
            keywords: &[
                "apstiprinājums",
                "grāmatvedība",
                "kvīts",
                "pierādījums",
                "uzskaite",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("сметка"),
            keywords: &["доказ", "евиденција", "потврда", "сметка", "сметководство"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("രസീത\u{d4d}"),
            keywords: &[
                "അക\u{d4d}ക\u{d57}ണ\u{d4d}ടിംഗ\u{d4d}",
                "തെളിവ\u{d4d}",
                "തെളിവ\u{d4d} രേഖ",
                "ബ\u{d41}ക\u{d4d}ക\u{d4d} സ\u{d42}ക\u{d4d}ഷിക\u{d4d}കൽ",
                "രസീത\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("төлбөрийн баримт"),
            keywords: &[
                "баримт",
                "данс хөтлөх",
                "нотолгоо",
                "нягтлан бодох",
                "төлбөрийн баримт",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("रीसिप\u{94d}ट"),
            keywords: &[
                "दाखला",
                "प\u{941}रावा",
                "प\u{941}स\u{94d}तपालन",
                "रीसिप\u{94d}ट",
                "ल\u{947}खा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("resit"),
            keywords: &["bukti", "keterangan", "perakaunan", "resit", "simpan kira"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပြေစာ"),
            keywords: &[
                "စာရင\u{103a}းက\u{102d}\u{102f}င\u{103a}ခြင\u{103a}း",
                "စာရင\u{103a}းက\u{102d}\u{102f}င\u{103a}လ\u{102f}ပ\u{103a}ငန\u{103a}း",
                "ပြေစာ",
                "အက\u{102d}\u{102f}းအကား",
                "အထောက\u{103a}အထား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kvittering"),
            keywords: &["arkiv", "bilag", "dokumentasjon", "kvittering", "regnskap"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("भर\u{94d}पाई"),
            keywords: &[
                "प\u{94d}रमाण",
                "ब\u{941}ककिपिङ",
                "भर\u{94d}पाई",
                "ल\u{947}खा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kassabon"),
            keywords: &[
                "administratie",
                "bewijs",
                "boekhouding",
                "kassabon",
                "kwitantie",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvittering"),
            keywords: &["arkiv", "bilag", "dokumentasjon", "kvittering", "rekneskap"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ରସ\u{b3f}ଦ"),
            keywords: &[
                "ଏକ\u{b3e}ଉଣ\u{b4d}ଟ\u{b3f}ଂ",
                "ପ\u{b4d}ରମ\u{b3e}ଣ",
                "ବ\u{b41}କକ\u{b3f}ପ\u{b3f}ଙ\u{b4d}ଗ",
                "ରସ\u{b3f}ଦ",
                "ସ\u{b41}ର\u{b3e}ଗ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਰਸੀਦ"),
            keywords: &[
                "ਪ\u{a4d}ਰਮਾਣ",
                "ਰਸੀਦ",
                "ਲ\u{a47}ਖਾ",
                "ਵਹੀ-ਖਾਤਾ",
                "ਸਬ\u{a42}ਤ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Risit"),
            keywords: &["Akaunt", "Bukkípin", "Pruv", "Risit"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("paragon"),
            keywords: &["dowód", "księgowość", "paragon", "pokwitowanie"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("رسيد"),
            keywords: &["ثبوت", "حساب کتاب", "دليل", "رسيد", "کتاب ساتنه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("recibo"),
            keywords: &[
                "contabilidade",
                "escrituração",
                "evidência",
                "prova",
                "recibo",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "comprovativo",
                "contabilidade",
                "fatura",
                "recibo",
                "tesouraria",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("chitanță"),
            keywords: &["chitanță", "contabilitate", "evidențe", "recipisă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-072"),
            keywords: &["E11-072"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("чек"),
            keywords: &["бухгалтерия", "счет", "чек"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("رسيد"),
            keywords: &["اڪائونٽنگ", "بڪ ڪيپنگ", "ثبوت", "رسيد"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ර\u{dd2}ස\u{dd2}ට\u{dca} පත"),
            keywords: &[
                "ග\u{dd2}ණ\u{dd4}ම\u{dca}කරණය",
                "පොත\u{dca} තැබ\u{dd3}ම",
                "ර\u{dd2}ස\u{dd2}ට\u{dca} පත",
                "ස\u{dcf}ක\u{dca}ෂ\u{dd2}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("účtenka"),
            keywords: &["doklad", "potvrdenie", "účtenka", "účtovníctvo"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("račun"),
            keywords: &[
                "dokaz",
                "dokazilo",
                "knjigovodstvo",
                "račun",
                "računovodstvo",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("rasiidh"),
            keywords: &[
                "cadeyn",
                "markhaati",
                "rasiidh",
                "xisaabaadka",
                "xisaabinta",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("faturë"),
            keywords: &["bllok llogarie", "faturë", "kontabilitet"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("признаница"),
            keywords: &[
                "доказ",
                "књиговодство",
                "потврда",
                "признаница",
                "рачуноводство",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("priznanica"),
            keywords: &[
                "dokaz",
                "knjigovodstvo",
                "potvrda",
                "priznanica",
                "računovodstvo",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kvitto"),
            keywords: &["belägg", "bevis", "bokföring", "kvitto", "redovisning"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("risiti"),
            keywords: &["rekodi", "risiti", "thibitisho", "uhasibu", "ushahidi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ரச\u{bc0}து"),
            keywords: &[
                "ஆத\u{bbe}ரம\u{bcd}",
                "கணக\u{bcd}குவழக\u{bcd}கு",
                "ச\u{bbe}ட\u{bcd}சியம\u{bcd}",
                "ரச\u{bc0}து",
                "வரவு செலவு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("రస\u{c40}దు"),
            keywords: &[
                "అక\u{c4c}ంట\u{c3f}ంగ\u{c4d}",
                "పుస\u{c4d}తకంల\u{c4b} న\u{c4b}ట\u{c4d} చ\u{c47}సుక\u{c4b}వడం",
                "రస\u{c40}దు",
                "రుజువు",
                "స\u{c3e}క\u{c4d}ష\u{c4d}యం",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ใบเสร\u{e47}จ"),
            keywords: &[
                "บ\u{e31}ญช\u{e35}",
                "บ\u{e34}ล",
                "ใบเสร\u{e47}จ",
                "ใบเสร\u{e47}จร\u{e31}บเง\u{e34}น",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("töleg haty"),
            keywords: &[
                "delil",
                "hasaphana",
                "hasapçylyk",
                "kwitansiýa",
                "subutnama",
                "töleg haty",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("lisiti"),
            keywords: &["lisiti"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("makbuz"),
            keywords: &["defter tutma", "kanıt", "kayıt", "makbuz", "muhasebe"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("квитанція"),
            keywords: &[
                "документ",
                "квитанція",
                "рахунок",
                "рахунок-фактура",
                "чек",
                "інвойс",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("رسید"),
            keywords: &["اکاؤنٹنگ", "ثبوت", "حساب نویسی", "رسید", "شہادت"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("chek"),
            keywords: &["buxgalteriya", "chek", "cho‘t", "hisob", "hisobchilik"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("biên nhận"),
            keywords: &[
                "biên nhận",
                "chứng từ",
                "ghi sổ sách",
                "giấy tờ chứng thực",
                "kế toán",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("收據"),
            keywords: &["收據", "會計", "簿記", "證據", "證明"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("收据"),
            keywords: &["会计", "收据", "簿记", "证据", "证明"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("收据"),
            keywords: &["凭据", "发票", "收据", "记账", "证明", "账单"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("收據"),
            keywords: &["收執聯", "收據", "發票", "紙本", "證明"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["收據", "會計", "記賬", "證據"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("receipt"),
            keywords: &["accounting", "bookkeeping", "evidence", "proof", "receipt"],
        },
    ],
};
#[doc = "💹"]
pub const CHART_INCREASING_WITH_YEN: crate::Emoji = crate::Emoji {
    glyph: "💹",
    codepoint: "1F4B9",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "chart increasing with yen",
    group: "Objects",
    subgroup: "money",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("grafiek met stygende jen"),
            keywords: &[
                "grafiek",
                "grafiek met stygende jen",
                "jen",
                "mark",
                "wisselkoers",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ከየን ጋር የሚጨምር ሰንጠረዥ"),
            keywords: &["ሰንጠረዥ", "ከየን ጋር የሚጨምር ሰንጠረዥ", "ዕድገት", "የን", "ገንዘብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}مخطط لبيانات متزايدة مع الين"),
            keywords: &["أسهم مرتفعة", "سوق", "\u{202b}مخطط لبيانات متزايدة مع الين"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("য\u{9bc}েনৰ ঊৰ\u{9cd}ধম\u{9c1}খী লেখচিত\u{9cd}ৰ"),
            keywords: &[
                "এক\u{9be}উণ\u{9cd}টিং",
                "প\u{9cd}ৰম\u{9be}ণ",
                "প\u{9cd}ৰ\u{9be}ম\u{9be}ণিক তথ\u{9cd}য",
                "ব\u{9c1}ককিপিং",
                "য\u{9bc}েনৰ ঊৰ\u{9cd}ধম\u{9c1}খী লেখচিত\u{9cd}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ien ilə qalxan qrafik"),
            keywords: &[
                "artmaq",
                "artım",
                "bank",
                "bazar",
                "cədvəl",
                "ien ilə qalxan qrafik",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("дыяграма росту са знакам іены"),
            keywords: &[
                "валюта",
                "графік",
                "грошы",
                "дыяграма",
                "дыяграма росту са знакам іены",
                "рост",
                "рынак",
                "тэндэнцыя",
                "іена",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Диаграма с възходяща тенденция и знак за йена"),
            keywords: &[
                "Диаграма с възходяща тенденция и знак за йена",
                "валута",
                "йена",
                "пари",
                "ръст",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ইয\u{9bc}েনের স\u{9be}থে ক\u{9cd}রমবর\u{9cd}ধম\u{9be}ন চ\u{9be}র\u{9cd}ট"),
            keywords: &[
                "ইয\u{9bc}েন",
                "ইয\u{9bc}েনের স\u{9be}থে ক\u{9cd}রমবর\u{9cd}ধম\u{9be}ন চ\u{9be}র\u{9cd}ট",
                "গ\u{9cd}র\u{9be}ফ",
                "চ\u{9be}র\u{9cd}ট",
                "ট\u{9be}ক\u{9be}",
                "ব\u{9c3}দ\u{9cd}ধি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("krommenn kreskiñ ar yen"),
            keywords: &[
                "grafik",
                "kreskiñ",
                "krommenn",
                "krommenn kreskiñ ar yen",
                "moneiz",
                "yen",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("grafikon sa jenom koji prikazuje rast"),
            keywords: &[
                "grafikon sa jenom koji prikazuje rast",
                "jen",
                "prikaz rasta",
                "trend",
                "valuta",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("gràfic d’augment amb el signe del ien"),
            keywords: &[
                "augment",
                "creixement",
                "gràfic",
                "gràfic d’augment amb el signe del ien",
                "ien",
                "signe",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎧᏃᎮᏓ ᏓᏟᎶᏍᏛ ᎧᏁᏉᎬᎢ ᏣᏩᏂᏏ ᎠᏕᎳ"),
            keywords: &[
                "ᎠᏕᎳ",
                "ᎧᏁᏉᎬᎢ",
                "ᎧᏃᎮᏓ ᏓᏟᎶᏍᏛ",
                "ᎧᏃᎮᏓ ᏓᏟᎶᏍᏛ ᎧᏁᏉᎬᎢ ᏣᏩᏂᏏ ᎠᏕᎳ",
                "ᎧᏃᎮᏓ ᏓᏟᎶᏍᏛᎢ",
                "ᏣᏩᏂᏏ ᎠᏕᎳ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("rostoucí graf se znakem jenu"),
            keywords: &[
                "banka",
                "graf",
                "jen",
                "měna",
                "nahoru",
                "peníze",
                "rostoucí graf se znakem jenu",
                "růst",
                "trend",
                "trh",
                "vzestup",
                "vzestupný",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("siart yn cynyddu â yen"),
            keywords: &["banc", "marchnad", "siart", "siart yn cynyddu â yen", "twf"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("stigende marked"),
            keywords: &["opadgående graf", "stigende marked"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("steigende Kurve mit Yen-Zeichen"),
            keywords: &["Diagramm", "Markt", "steigende Kurve mit Yen-Zeichen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ανοδικό γράφημα με γιεν"),
            keywords: &[
                "άνοδος",
                "ανοδικό γράφημα με γιεν",
                "αύξηση",
                "γιεν",
                "γράφημα",
                "τάση",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("chart increasing with yen"),
            keywords: &[
                "chart",
                "chart increasing with yen",
                "graph",
                "growth",
                "money",
                "yen",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("graph increasing with yen"),
            keywords: &[
                "chart",
                "chart increasing with yen",
                "graph",
                "graph increasing with yen",
                "growth",
                "money",
                "yen",
            ],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("mercado al alza"),
            keywords: &[
                "alza",
                "mercado",
                "mercado al alza",
                "mercado alcista",
                "tabla",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("mercado en alza"),
            keywords: &[
                "dinero",
                "gráfico",
                "mercado",
                "mercado en alza",
                "tendencia",
                "yen",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["gráfico", "mercado", "mercado en alza", "tendencia", "yen"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("gráfica de alza con yen"),
            keywords: &[
                "alza",
                "crecimiento",
                "dinero",
                "gráfica",
                "gráfica de alza con yen",
                "yen",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("tõusev graafik jeenisümboliga"),
            keywords: &[
                "graafik",
                "jeen",
                "kasv",
                "turg",
                "tõusev graafik jeenisümboliga",
                "valuuta",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("diagrama gorakorra yen-ikurrarekin"),
            keywords: &[
                "diagrama",
                "diagrama gorakorra yen-ikurrarekin",
                "dirua",
                "grafikoa",
                "hazkuntza",
                "yena",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نمودار صعودی با ین"),
            keywords: &[
                "ارز",
                "رشد",
                "منحنی",
                "نمودار",
                "نمودار صعودی با ین",
                "پول",
                "ین",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("yen ja nouseva käyrä"),
            keywords: &[
                "kasvu",
                "käyrä",
                "markkinat",
                "nousu",
                "pankki",
                "raha",
                "valuutta",
                "yen",
                "yen ja nouseva käyrä",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pataas na chart na may yen"),
            keywords: &[
                "graph",
                "paglago",
                "pagtaas",
                "pataas na chart na may yen",
                "pera",
                "tsart",
                "yen",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("strikumynd við jenn tekni"),
            keywords: &[
                "gjaldoyra",
                "hækkadi",
                "hækkan",
                "jenn",
                "jennur",
                "marknaður",
                "strikumynd",
                "strikumynd við jenn tekni",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("courbe avec yen en hausse"),
            keywords: &[
                "banque",
                "courbe avec yen en hausse",
                "graphique",
                "hausse",
                "monnaie",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("courbe croissante précédée du symbole du yen"),
            keywords: &[
                "courbe",
                "courbe croissante précédée du symbole du yen",
                "croissance",
                "graphique",
                "monnaie",
                "yen",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("margadh ag méadú le yen"),
            keywords: &[
                "cairt",
                "dul i méid",
                "margadh",
                "margadh ag méadú le yen",
                "margadh ag éirí",
                "méadú",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cairt a’ dol suas le Yen"),
            keywords: &[
                "airgead",
                "airgeadra",
                "banca",
                "cairt",
                "cairt a’ dol suas le Yen",
                "dìreadh",
                "fàs",
                "graf",
                "margadh",
                "margaid",
                "suas",
                "treand",
                "yen",
                "èirich",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("mercado de iens en alza"),
            keywords: &[
                "gráfico",
                "ien",
                "mercado",
                "mercado de iens en alza",
                "tendencia",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ય\u{ac7}ન સાથ\u{ac7} ઉપર જતો ચાર\u{acd}ટ"),
            keywords: &[
                "આલ\u{ac7}ખ",
                "ઉપરની તરફ",
                "ઊ\u{a82}ચ\u{ac7} જતો આલ\u{ac7}ખ",
                "ઊઠત\u{ac1}\u{a82} બજાર",
                "બજાર",
                "ય\u{ac7}ન સાથ\u{ac7} ઉપર જતો ચાર\u{acd}ટ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("zanen lissafi mai ƙaruwa da yen"),
            keywords: &[
                "banki",
                "kasuwa",
                "kuɗi",
                "kuɗin ƙasa",
                "salo",
                "tasowa",
                "yen",
                "zane",
                "zanen lissafi",
                "zanen lissafi mai ƙaruwa da yen",
                "zuwa sama",
                "ƙaruwa",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גרף עולה עם סימן ין"),
            keywords: &["גרף", "גרף עולה עם סימן ין", "ין", "כסף", "צמיחה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("य\u{947}न म\u{947}\u{902} बढ\u{93c}त का र\u{942}झान दिखाता चार\u{94d}ट"),
            keywords: &[
                "ऊपर की और",
                "ऊपर जाता चार\u{94d}ट",
                "चार\u{94d}ट",
                "बढ\u{93c}ता बाज\u{93c}ार",
                "बाज\u{93c}ार",
                "य\u{947}न क\u{947} साथ ऊपर जाता चार\u{94d}ट",
                "य\u{947}न म\u{947}\u{902} बढ\u{93c}त का र\u{942}झान दिखाता चार\u{94d}ट",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("grafikon rastućeg trenda sa znakom jena"),
            keywords: &[
                "grafikon",
                "grafikon rastućeg trenda sa znakom jena",
                "jen",
                "novac",
                "rast",
                "trend",
                "valuta",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("növekvő jendiagram"),
            keywords: &[
                "diagram",
                "emelkedés",
                "jen",
                "növekvő jendiagram",
                "pénz",
                "trend",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("աճող դիագրամ իենով"),
            keywords: &[
                "աճ",
                "աճող դիագրամ իենով",
                "բանկ",
                "բարձրանալ",
                "գրաֆիկ",
                "դիագրամ",
                "իեն",
                "միտում",
                "շուկա",
                "վերև",
                "տարադրամ",
                "փող",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bagan meningkat dengan yen"),
            keywords: &[
                "bagan",
                "bagan meningkat dengan yen",
                "grafik",
                "pertumbuhan",
                "uang",
                "yen",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("mmụba chaatị nwere yen"),
            keywords: &[
                "ahịa",
                "chaati",
                "ego",
                "grafụ",
                "mbili",
                "mmụba chaatị nwere yen",
                "otito",
                "trendi",
                "yen",
                "ịga elu",
                "ụlọ akụ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("markaður á uppleið"),
            keywords: &[
                "hækkar",
                "jákvætt",
                "markaður á uppleið",
                "verðbréfamarkaður",
                "á uppleið",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("grafico ascendente"),
            keywords: &["ascendente", "grafico", "mercato", "mercato in salita"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("為替"),
            keywords: &["グラフ", "チャート", "市場", "株", "株価", "為替"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("grafik mata uang yen mundhak"),
            keywords: &[
                "dhuwit",
                "grafik",
                "grafik mata uang yen mundhak",
                "mundhak",
                "yen",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ზრდადი გრაფიკი იენათი"),
            keywords: &[
                "ბაზარი",
                "ბანკი",
                "გრაფიკი",
                "დიაგრამა",
                "ვალუტა",
                "ზრდა",
                "ზრდადი გრაფიკი იენათი",
                "იენა",
                "მაღლა",
                "ტენდენცია",
                "ფული",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("йена бағамы көтерілгенін көрсететін диаграмма"),
            keywords: &[
                "ақша",
                "график",
                "диаграмма",
                "йена",
                "йена бағамы көтерілгенін көрсететін диаграмма",
                "өсім",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("stigende marked"),
            keywords: &["opadgående graf", "stigende marked"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("តារាងក\u{17c6}ណើនល\u{17bb}យយេន"),
            keywords: &[
                "ក\u{17c6}ណើន",
                "តារាង",
                "តារាងក\u{17c6}ណើនល\u{17bb}យយេន",
                "ល\u{17bb}យយេន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some(
                "ಯ\u{cc6}ನ\u{ccd} ನೊಂದ\u{cbf}ಗ\u{cc6} ಏರುತ\u{ccd}ತ\u{cbf}ರುವ ಚಾರ\u{ccd}ಟ\u{ccd}",
            ),
            keywords: &[
                "ಚಾರ\u{ccd}ಟ\u{ccd}",
                "ಮಾರುಕಟ\u{ccd}ಟ\u{cc6}",
                "ಮೇಲ\u{ccd}ಮುಖ ಚಾರ\u{ccd}ಟ\u{ccd}",
                "ಮೇಲ\u{ccd}ಮುಖವಾಗ\u{cbf}",
                "ಯ\u{cc6}ನ\u{ccd} ನೊಂದ\u{cbf}ಗ\u{cc6} ಏರುತ\u{ccd}ತ\u{cbf}ರುವ ಚಾರ\u{ccd}ಟ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("엔화 관련 상승하는 그래프"),
            keywords: &["시장 호황", "엔화 관련 상승하는 그래프", "호황"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("य\u{947}न सयत वाडपी तकटो"),
            keywords: &[
                "ग\u{94d}राफ",
                "तकटो",
                "पयश\u{947}",
                "य\u{947}न",
                "य\u{947}न सयत वाडपी तकटो",
                "वाड",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("иена менен көтөрүлүп жаткан диаграмма"),
            keywords: &[
                "акча",
                "диаграмма",
                "иена",
                "иена менен көтөрүлүп жаткан диаграмма",
                "көтөрүлүү",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("steigende Coursdiagramm mat Yen"),
            keywords: &[
                "Bank",
                "Cours",
                "Diagramm",
                "Geld",
                "Maart",
                "Marché",
                "Steierung",
                "Suen",
                "Tendenz",
                "Währung",
                "Yen",
                "steigen",
                "steigend",
                "steigende Coursdiagramm mat Yen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some(
                "ເສ\u{eb1}\u{ec9}ນສະແດງຄ\u{ec8}າເງ\u{eb4}ນເຢ\u{eb1}ນທ\u{eb5}\u{ec8}ເພ\u{eb5}\u{ec8}ມຂ\u{eb6}\u{ec9}ນ",
            ),
            keywords: &[
                "ທະນາຄານ",
                "ສະກ\u{eb8}ນເງ\u{eb4}ນ",
                "ເຢ\u{eb1}ນ",
                "ເສ\u{eb1}\u{ec9}ນສະແດງ",
                "ເສ\u{eb1}\u{ec9}ນສະແດງຄ\u{ec8}າເງ\u{eb4}ນເຢ\u{eb1}ນທ\u{eb5}\u{ec8}ເພ\u{eb5}\u{ec8}ມຂ\u{eb6}\u{ec9}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("didėjimo diagrama su jenos simboliu"),
            keywords: &[
                "augimas",
                "diagrama",
                "didėjimo diagrama su jenos simboliu",
                "jena",
                "tendencijos",
                "valiuta",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("augšupejoša diagrammas līkne ar jenas simbolu"),
            keywords: &[
                "augšup",
                "augšupejoša diagrammas līkne ar jenas simbolu",
                "diagramma",
                "jena",
                "līkne",
                "tirgus",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tūtohi aupiki me te yen"),
            keywords: &[
                "au",
                "aupiki",
                "kauwhata",
                "momo moni",
                "moni",
                "mākete",
                "pēke",
                "tipunga",
                "tūtohi",
                "tūtohi aupiki me te yen",
                "whakarunga",
                "yen",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("растечки графикон на јенот"),
            keywords: &[
                "валута",
                "графикон",
                "пазар",
                "пари",
                "растечки графикон на јенот",
                "јен",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മ\u{d3e}ർക\u{d4d}കറ\u{d4d}റ\u{d4d} ഉയർച\u{d4d}ച"),
            keywords: &[
                "ച\u{d3e}ർട\u{d4d}ട\u{d4d}",
                "മ\u{d3e}ർക\u{d4d}കറ\u{d4d}റ\u{d4d}",
                "മ\u{d3e}ർക\u{d4d}കറ\u{d4d}റ\u{d4d} ഉയർച\u{d4d}ച",
                "മ\u{d41}കളിലേക\u{d4d}ക\u{d41}ള\u{d4d}ള ച\u{d3e}ർട\u{d4d}ട\u{d4d}",
                "മ\u{d41}കളിലേക\u{d4d}ക\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("иенийн өсч буй диаграм"),
            keywords: &[
                "график",
                "диаграмм",
                "иен",
                "иений өсч буй диаграмм",
                "иенийн өсч буй диаграм",
                "мөнгө",
                "өсөлт",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("य\u{947}न सह वाढणारा चार\u{94d}ट"),
            keywords: &[
                "आल\u{947}ख",
                "चार\u{94d}ट",
                "प\u{948}सा",
                "बाजार",
                "य\u{947}न",
                "य\u{947}न सह वाढणारा चार\u{94d}ट",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("carta yen meningkat"),
            keywords: &[
                "carta",
                "carta meningkat dengan yen",
                "carta yen meningkat",
                "graf",
                "pertumbuhan",
                "wang",
                "yen",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ċart tiżdied bil-yen"),
            keywords: &[
                "bank",
                "flus",
                "graff",
                "munita",
                "suq",
                "tendenza",
                "tkabbir",
                "tlugħ",
                "yen",
                "ċart",
                "ċart tiżdied bil-yen",
                "’l fuq",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ယန\u{103a}းတန\u{103a}ဖ\u{102d}\u{102f}း မြင\u{1037}\u{103a}တက\u{103a}နေသည\u{1037}\u{103a} ဇယားပ\u{102f}\u{1036}",
            ),
            keywords: &[
                "ဂရပ\u{103a}ဖ\u{103a}",
                "ဂျပန\u{103a} ယန\u{103a}း",
                "င\u{103d}ေ",
                "ဇယား",
                "ယန\u{103a}းင\u{103d}ေတန\u{103a}ဖ\u{102d}\u{102f}း မြင\u{1037}\u{103a}တက\u{103a}နေပ\u{102f}\u{1036}ပြ ဇယား",
                "ယန\u{103a}းတန\u{103a}ဖ\u{102d}\u{102f}း မြင\u{1037}\u{103a}တက\u{103a}နေသည\u{1037}\u{103a} ဇယားပ\u{102f}\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("stigende diagram med yen"),
            keywords: &[
                "graf",
                "marked",
                "oppover",
                "penger",
                "stigende",
                "stigende diagram med yen",
                "trend",
                "yen",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("य\u{947}नस\u{901}ग\u{948} बढिरह\u{947}को चार\u{94d}ट"),
            keywords: &[
                "ग\u{94d}राफ",
                "चार\u{94d}ट",
                "प\u{948}सा",
                "य\u{947}न",
                "य\u{947}नस\u{901}ग\u{948} बढिरह\u{947}को चार\u{94d}ट",
                "व\u{943}द\u{94d}धि",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("stijgende grafiek met yenteken"),
            keywords: &[
                "diagram",
                "geld",
                "grafiek",
                "groei",
                "stijgende grafiek met yenteken",
                "yen",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("stigande diagram med yen"),
            keywords: &[
                "graf",
                "marknad",
                "oppover",
                "pengar",
                "stigande",
                "stigande diagram med yen",
                "trend",
                "yen",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ୟେନ\u{b4d}\u{200c} ସହ\u{b3f}ତ ବ\u{b43}ଦ\u{b4d}ଧ\u{b3f} ପ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} ଚ\u{b3e}ର\u{b4d}ଟ\u{b4d}\u{200c}",
            ),
            keywords: &[
                "ଗ\u{b4d}ର\u{b3e}ଫ\u{b4d}\u{200c}",
                "ଚ\u{b3e}ର\u{b4d}ଟ",
                "ଟଙ\u{b4d}କ\u{b3e}",
                "ବ\u{b43}ଦ\u{b4d}ଧ\u{b3f}",
                "ୟେନ\u{b4d}\u{200c}",
                "ୟେନ\u{b4d}\u{200c} ସହ\u{b3f}ତ ବ\u{b43}ଦ\u{b4d}ଧ\u{b3f} ପ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} ଚ\u{b3e}ର\u{b4d}ଟ\u{b4d}\u{200c}",
                "ୟେନ\u{b4d}\u{200c} ସହ\u{b3f}ତ ବ\u{b43}ଦ\u{b4d}ଧ\u{b3f}ପ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} ଚ\u{b3e}ର\u{b4d}ଟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਯ\u{a47}ਨ ਵਿ\u{a71}ਚ ਵਾਧਾ ਵਿਖਾਉਣ ਵਾਲਾ ਚਾਰਟ"),
            keywords: &[
                "ਚਾਰਟ",
                "ਚੜ\u{a4d}ਹਦਾ ਬਾਜ\u{a3c}ਾਰ",
                "ਪ\u{a48}ਸਾ",
                "ਯ\u{a47}ਨ",
                "ਯ\u{a47}ਨ ਵਿ\u{a71}ਚ ਵਾਧਾ ਵਿਖਾਉਣ ਵਾਲਾ ਚਾਰਟ",
                "ਰ\u{a41}ਝਾਨ",
                "ਵਾਧਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ین نال ودھدا ہوئیا چارٹ"),
            keywords: &[
                "ا\u{64f}وتلے پاس\u{651}ے",
                "ا\u{64f}ٹھان",
                "بازار",
                "بینک",
                "رجحان",
                "پرورش پانا",
                "پیسے",
                "چارٹ",
                "کرنسی",
                "گراف",
                "ین",
                "ین نال ودھدا ہوئیا چارٹ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Graf Wé Shó Sé Yẹn De Gó Ọp"),
            keywords: &["Graf", "Graf Wé Shó Sé Yẹn De Gó Ọp", "Gro", "Mọní", "Yẹn"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wykres wzrostu z symbolem jena"),
            keywords: &[
                "jen",
                "pieniądze",
                "trend wzrostowy",
                "waluta",
                "wykres",
                "wykres wzrostu z symbolem jena",
                "wzrost",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("چارټ د یین سره زیاتیږي"),
            keywords: &[
                "وده",
                "يين",
                "پېسې",
                "چارټ",
                "چارټ د یین سره زیاتیږي",
                "ګراف",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("gráfico subindo com iene"),
            keywords: &[
                "crescimento",
                "dinheiro",
                "gráfico",
                "gráfico subindo com iene",
                "iene",
                "iene em alta",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("gráfico a subir com iene"),
            keywords: &[
                "ascendente",
                "banco",
                "crescimento",
                "dinheiro",
                "gráfico",
                "gráfico a subir com iene",
                "iene",
                "mercado",
                "moeda",
                "subida",
                "tendência",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("grafic ascendent cu yen"),
            keywords: &[
                "creștere",
                "grafic",
                "grafic ascendent cu yen",
                "valută",
                "yen",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-630"),
            keywords: &["E10-630"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("биржа"),
            keywords: &["биржа", "валюта", "деньги", "рост", "рынок", "тенденция"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("imbonerahamwe igaragaza iyeni rizamuka"),
            keywords: &[
                "banki",
                "idovize",
                "ifaranga",
                "imbonerahamwe",
                "imbonerahamwe igaragaza iyeni rizamuka",
                "isoko",
                "iterambere",
                "iyeni",
                "izamuka",
                "njyejuru",
                "ukwiyongera",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("يين سان گڏ وڌندڙ چارٽ"),
            keywords: &[
                "اٿڻ",
                "بئنڪ",
                "بازار",
                "رقم",
                "رواج",
                "سڪو",
                "مٿي طرف",
                "واڌ",
                "يين",
                "يين سان گڏ وڌندڙ چارٽ",
                "چارٽ",
                "گراف",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("යෙන\u{dca} සමග වැඩ\u{dd2}වන ප\u{dca}\u{200d}රස\u{dca}ත\u{dcf}රය"),
            keywords: &[
                "ප\u{dca}\u{200d}රස\u{dca}ත\u{dcf}ර සටහන",
                "ම\u{dd4}දල\u{dca} වර\u{dca}ගය",
                "යෙන\u{dca} සමග වැඩ\u{dd2}වන ප\u{dca}\u{200d}රස\u{dca}ත\u{dcf}රය",
                "වර\u{dca}ධනය",
                "වෙළඳපොළ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("stúpajúci graf jenu"),
            keywords: &[
                "graf",
                "mena",
                "nárast",
                "peniaze",
                "stúpajúci graf jenu",
                "trend",
                "trh",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("grafikon rasti za jen"),
            keywords: &[
                "banka",
                "denar",
                "graf",
                "grafikon",
                "grafikon rasti za jen",
                "jen",
                "navzgor",
                "rast",
                "rasti",
                "trend",
                "trg",
                "valuta",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("shaxan muujinaya yeen kordhaysa"),
            keywords: &[
                "korid",
                "lacag",
                "shax",
                "shaxan",
                "shaxan muujinaya yeen kordhaysa",
                "yeen",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("grafik rritës me jenë"),
            keywords: &["grafik", "grafik rritës me jenë", "jen", "tendencë", "treg"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("графикон пораста са знаком јена"),
            keywords: &[
                "графикон",
                "графикон пораста са знаком јена",
                "новац",
                "раст",
                "јен",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["графикон пораста са знаком јена"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("grafikon porasta sa znakom jena"),
            keywords: &[
                "grafikon",
                "grafikon porasta sa znakom jena",
                "jen",
                "novac",
                "rast",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["grafikon porasta sa znakom jena"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("stigande diagram med yen"),
            keywords: &[
                "diagram",
                "diagram stigande marknad",
                "stigande diagram med yen",
                "stigande marknad",
                "uppåtpekande",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("chati inayopanda yenye yeni"),
            keywords: &[
                "chati",
                "chati inayopanda yenye yeni",
                "chayi inayopanda yenye yeni",
                "grafu",
                "ongezeka",
                "pesa",
                "yeni",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("chati inayopanda yenye yeni"),
            keywords: &[
                "benki",
                "chati",
                "chati inayopanda yenye yeni",
                "grafu",
                "juu",
                "kupanda",
                "ongezeka",
                "pesa",
                "sarafu",
                "soko",
                "uelekeo",
                "yeni",
            ],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வளரும\u{bcd} பங\u{bcd}குச\u{bcd}சந\u{bcd}தை"),
            keywords: &[
                "சந\u{bcd}தை வளர\u{bcd}ச\u{bcd}சி",
                "வளரும\u{bcd} சந\u{bcd}தை",
                "வளரும\u{bcd} பங\u{bcd}குச\u{bcd}சந\u{bcd}தை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "య\u{c46}న\u{c4d} చ\u{c3f}హ\u{c4d}నంత\u{c4b} ప\u{c48}క\u{c3f} చూపుతున\u{c4d}న చ\u{c3e}ర\u{c4d}ట\u{c4d}",
            ),
            keywords: &[
                "చ\u{c3e}ర\u{c4d}ట\u{c4d}",
                "య\u{c46}న\u{c4d}",
                "య\u{c46}న\u{c4d} చ\u{c3f}హ\u{c4d}నంత\u{c4b} ప\u{c48}క\u{c3f} చూపుతున\u{c4d}న చ\u{c3e}ర\u{c4d}ట\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("диаграммаи афзоиш бо йен"),
            keywords: &[
                "асъор",
                "афзоиш",
                "бозор",
                "боло",
                "боло рафтан",
                "бонк",
                "график",
                "диаграмма",
                "диаграммаи афзоиш бо йен",
                "йен",
                "пул",
                "тамоюл",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ตลาดข\u{e36}\u{e49}น"),
            keywords: &["ตลาดข\u{e36}\u{e49}น", "ฟอเร\u{e47}กซ\u{e4c}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýenli köpelýän grafik"),
            keywords: &["grafik", "pul", "ösüş", "ýen", "ýenli köpelýän grafik"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("siate tupulaki, paʻanga fakasiapani"),
            keywords: &["siate tupulaki, paʻanga fakasiapani"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yen simgeli artış grafiği"),
            keywords: &[
                "grafik",
                "piyasa",
                "yen simgeli artış grafiği",
                "yukarı giden grafik",
                "yukarı yönlü",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يېن ئاشما گىرافىكى"),
            keywords: &[
                "ئاقچا",
                "ئۆرلەش",
                "ئېشىش",
                "بازار",
                "بانكا",
                "جەدۋەل",
                "يۇقىرىغا",
                "يۈزلىنىش",
                "يېن",
                "يېن ئاشما گىرافىكى",
                "پۇل",
                "گىرافىك",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("графік зростання і знак єни"),
            keywords: &[
                "банк",
                "валюта",
                "вгору",
                "графік зростання і знак єни",
                "графіка",
                "гроші",
                "діаграма",
                "збільшення",
                "ринок",
                "ріст",
                "тенденція",
                "єна",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ین کے ساتھ صعودی چارٹ"),
            keywords: &[
                "اضافہ",
                "بنک",
                "رقم",
                "چارٹ",
                "گراف",
                "ین",
                "ین کے ساتھ صعودی چارٹ",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("o‘sayotgan iyena diagrammasi"),
            keywords: &[
                "diagramma",
                "grafika",
                "oʻsish",
                "o‘sayotgan iyena diagrammasi",
                "pul",
                "yen",
                "yen oʻsish diagrammasi",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("biểu đồ đồng yên tăng"),
            keywords: &["biểu đồ", "biểu đồ đồng yên tăng", "tiền", "tăng", "yên"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("grafiku yen buy yéeg"),
            keywords: &[
                "bànk",
                "grafik",
                "grafiku yen buy yéeg",
                "jëm kaw",
                "koppar",
                "kurb",
                "marse",
                "màgg",
                "xaalis",
                "xew",
                "yen",
                "yéeg",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("itshati iyanda nge-yen"),
            keywords: &[
                "ezithandwayo",
                "i-yen",
                "ibhanki",
                "igrafu",
                "ikharensi",
                "imakethi",
                "imali",
                "itshathi",
                "itshati iyanda nge-yen",
                "phezulu",
                "ukunyuka",
                "ulwando",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àtẹ n pọsi pẹlu yẹn"),
            keywords: &[
                "ilà atọ\u{301}ka àwòrán",
                "ilé ìfowópamọ\u{301}n",
                "owó",
                "yen",
                "àtẹ",
                "àtẹ n pọsi pẹlu yẹn",
                "ìdàgbàsókè",
                "ìdìde",
                "ìgbàlódé",
                "ìlọsókè",
                "ọjà",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("日元升值"),
            keywords: &["上升", "圖表", "增長", "日元", "日元升值", "貨幣"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("日元升值"),
            keywords: &[
                "上升",
                "向上",
                "图",
                "图表",
                "增长",
                "市场",
                "日元",
                "日元升值",
                "货币",
                "趋势",
                "钱",
                "银行",
            ],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("趋势向上且带有日元符号的图表"),
            keywords: &[
                "上扬",
                "上涨",
                "日元汇率",
                "货币升值图表",
                "走势",
                "趋势向上且带有日元符号的图表",
            ],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("貨幣升值"),
            keywords: &["上揚", "圖表", "市場走向", "貨幣升值"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("有日元標誌嘅向上折線圖"),
            keywords: &[
                "上升",
                "圖表",
                "市場走勢",
                "日元升值",
                "有日元標誌嘅向上折線圖",
            ],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ishadi elivuza ukukhuphuka kweyeni"),
            keywords: &[
                "ibhange",
                "igrafu",
                "imakethe",
                "imali",
                "ishadi",
                "ishadi elivuza ukukhuphuka kweyeni",
                "iyeni",
                "phezulu",
                "uhlobo lwemali",
                "ukukhula",
                "ukukhuphuka",
            ],
        },
    ],
};
