#[doc = "💉"]
pub const SYRINGE: crate::Emoji = crate::Emoji {
    glyph: "💉",
    codepoint: "1F489",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "syringe",
    group: "Objects",
    subgroup: "medical",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("inspuiting"),
            keywords: &["dokter", "inspuiting", "medisyne", "naald", "siek"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ስሪንጅ"),
            keywords: &["ሕክምና", "መርፌ", "ስሪንጅ", "ተኩስ", "የታመመ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}إبرة حقن"),
            keywords: &["حقنة", "سرنجة", "طب", "طبيب", "\u{202b}إبرة حقن"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চিৰিঞ\u{9cd}জ"),
            keywords: &[
                "ঔষধ",
                "ঔষধৰ বেজী",
                "চিকিৎসক",
                "চিৰিঞ\u{9cd}জ",
                "বেজী",
                "স\u{981}জ\u{9c1}লি",
                "ৰোগী",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("şpris"),
            keywords: &["alət", "həkim", "iynə", "naxoş", "tibb", "çəkmək", "şpris"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("шпрыц"),
            keywords: &["доктар", "лекі", "укол", "шпрыц", "іголка", "ін’екцыя"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("спринцовка"),
            keywords: &["болен", "игла", "инструмент", "медицина", "спринцовка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("সিরিঞ\u{9cd}জ"),
            keywords: &[
                "ইঞ\u{9cd}জেকশন",
                "ওষ\u{9c1}ধ",
                "ড\u{9be}ক\u{9cd}ত\u{9be}র",
                "সিরিঞ\u{9cd}জ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("strinkell"),
            keywords: &["mezegiezh", "strinkell"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("šprica"),
            keywords: &["bolest", "igla", "injekcija", "lijek", "šprica"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("xeringa"),
            keywords: &[
                "agulla",
                "injecció",
                "malalt",
                "medicina",
                "metge",
                "xeringa",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏴᎩ ᎠᏓᏣᏲᏍᏙᏗ"),
            keywords: &["ᎠᎦᎾᎦᏘ", "ᎠᏓᏣᏲᏍᏗ", "ᎤᏓᏂᎵ", "ᎬᏔᏂᏓᏍᏗ", "ᏅᏬᏘ", "ᏴᎩ ᎠᏓᏣᏲᏍᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("injekční stříkačka"),
            keywords: &[
                "doktor",
                "dávka",
                "injekce",
                "injekční stříkačka",
                "jehla",
                "lék",
                "lékař",
                "nemoc",
                "nemocný",
                "nástroj",
                "očkování",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("chwistrell"),
            keywords: &["chwistrell", "doctor", "meddygaeth", "nodwydd", "sâl"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sprøjte"),
            keywords: &["indsprøjtning", "injektion", "læge", "medicin", "sprøjte"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Spritze"),
            keywords: &["Arzt", "Injektion", "Nadel", "Spritze"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σύριγγα"),
            keywords: &[
                "άρρωστος",
                "ένεση",
                "βελόνα",
                "γιατρός",
                "εργαλείο",
                "σύριγγα",
                "φάρμακο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("syringe"),
            keywords: &["medicine", "needle", "shot", "sick", "syringe"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["ill", "injection", "medicine", "needle", "syringe"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["ill", "injection", "medicine", "needle", "syringe"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("jeringuilla"),
            keywords: &["aguja", "jeringa", "jeringuilla", "medicina", "médico"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("jeringa"),
            keywords: &["aguja", "inyección", "jeringa", "medicina", "médico"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("süstal"),
            keywords: &["arst", "haigus", "nõel", "ravim", "süstal"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("xiringa"),
            keywords: &[
                "gaixo",
                "medikuntza",
                "orratz",
                "sendagile",
                "tresna",
                "xiringa",
                "ziztada",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("سرنگ"),
            keywords: &["آمپول", "دارو", "سرنگ", "سوزن", "مریض", "واکسن", "پزشک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ruisku"),
            keywords: &[
                "lääke",
                "lääkäri",
                "piikki",
                "rokote",
                "ruisku",
                "tauti",
                "työkalu",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("hiringgilya"),
            keywords: &["gamot", "hiringgilya", "karayom", "sakit", "shot"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sproyta"),
            keywords: &[
                "amboð",
                "heilivágur",
                "innspræning",
                "lækni",
                "medisin",
                "nál",
                "sjúka",
                "sproyta",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("seringue"),
            keywords: &["aiguille", "docteur", "malade", "médecine", "seringue"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("instealladh"),
            keywords: &["dochtúir", "instealladh", "leigheas"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("steallair"),
            keywords: &[
                "acainn",
                "bochd",
                "dotair",
                "inneal",
                "leigheas",
                "snàthad",
                "stealladh",
                "steallair",
                "tinn",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("xiringa"),
            keywords: &["inxección", "médico", "vacina", "virus", "xiringa"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સીરિ\u{a82}જ"),
            keywords: &["ડોક\u{acd}ટર", "દવા", "શોટ", "સીરિ\u{a82}જ", "સોય"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("allura"),
            keywords: &[
                "allura",
                "ba da allura",
                "kayan aiki",
                "likita",
                "magani",
                "maras lafiya",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מזרק"),
            keywords: &["זריקה", "חולה", "חיסון", "מזרק", "מחט", "תרופה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सिरी\u{902}ज, स\u{942}ई"),
            keywords: &[
                "दवाई",
                "बीमार",
                "मरीज\u{93c}",
                "सिरि\u{902}ज",
                "सिरी\u{902}ज, स\u{942}ई",
                "स\u{941}ई",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("šprica"),
            keywords: &["bolest", "igla", "injekcija", "medicina", "šprica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fecskendő"),
            keywords: &["eszköz", "fecskendő", "injekciós tű", "orvos", "vérvétel"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ներարկիչ"),
            keywords: &[
                "ասեղ",
                "բժիշկ",
                "բժշկություն",
                "գործիք",
                "հիվանդ",
                "ներարկիչ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("suntikan"),
            keywords: &["jarum", "obat", "sakit", "suntikan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ntụtụ"),
            keywords: &["dọkịnta", "gbaa", "ngwaọrụ", "ntụtụ", "ọgwụ", "ọrịa"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sprauta"),
            keywords: &["lyf", "læknir", "nál", "sprauta"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("siringa"),
            keywords: &["ago", "dottore", "iniezione", "medicina", "siringa"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("注射器"),
            keywords: &["医者", "注射", "注射器", "病気", "薬"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("siring"),
            keywords: &["bat", "dom", "lara", "siring", "suntik"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("შპრიცი"),
            keywords: &[
                "ავადმყოფობა",
                "ექიმი",
                "ინსტრუმენტი",
                "მედიცინა",
                "ნემსი",
                "შპრიცი",
                "ხელსაწყო",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tisegnit"),
            keywords: &["tisegnit"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шприц"),
            keywords: &["ауру", "ине", "медицина", "салу", "шприц"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("sprøjte"),
            keywords: &["indsprøjtning", "læge", "sprøjte"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17ca}\u{17ba}រ\u{17c9}ាងចាក\u{17cb}ថ\u{17d2}មា\u{17c6}"),
            keywords: &[
                "ចាក\u{17cb}",
                "ឈ\u{17ba}",
                "ថ\u{17d2}នា\u{17c6}",
                "ម\u{17d2}ជ\u{17bb}ល",
                "ស\u{17ba}រ\u{17c9}ា\u{17c6}ង",
                "ស\u{17ca}\u{17ba}រ\u{17c9}ាងចាក\u{17cb}ថ\u{17d2}មា\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{cbf}ರ\u{cbf}ಂಜ\u{ccd}"),
            keywords: &[
                "ಔಷಧ",
                "ವೈದ\u{ccd}ಯರು",
                "ಸ\u{cbf}ರ\u{cbf}ಂಜ\u{ccd}",
                "ಸ\u{cc2}ಜ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("주사기"),
            keywords: &["병원", "주사 바늘", "주사기", "치료"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("सिरि\u{902}ज"),
            keywords: &[
                "तो\u{902}पप",
                "द\u{941}य\u{947}\u{902}त",
                "वखदा\u{902}",
                "सिरि\u{902}ज",
                "स\u{941}य",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("шприц"),
            keywords: &["дары", "ийне", "оору", "сай", "шприц"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Sprëtz"),
            keywords: &["Dokter", "Medezin", "Nol", "Sprëtz", "Utensil", "krank"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຊະແລ\u{eb1}ງ"),
            keywords: &["ຊະແລ\u{eb1}ງ", "ຫ\u{ebc}ອດສ\u{eb1}ກຢາ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("švirkštas"),
            keywords: &[
                "adata",
                "dūris",
                "gydytojas",
                "ligonis",
                "medicina",
                "įrankis",
                "švirkštas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("šļirce"),
            keywords: &["adata", "medicīna", "slims", "ārsts", "šļirce"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ngira"),
            keywords: &["mate", "ngira", "pota", "rata", "rongoā", "utauta"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("шприц"),
            keywords: &["доктор", "игла", "инјекција", "лек", "шприц"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സിറിഞ\u{d4d}ച\u{d4d}"),
            keywords: &[
                "ക\u{d41}ത\u{d4d}തിവയ\u{d4d}പ\u{d4d}പ\u{d4d}",
                "ഡോക\u{d4d}ടർ",
                "മര\u{d41}ന\u{d4d}ന\u{d4d}",
                "സിറിഞ\u{d4d}ച\u{d4d}",
                "സ\u{d42}ചി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("тариа"),
            keywords: &["зүү", "тариа", "тариур", "эм", "өвчтэй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("सिरि\u{902}ज"),
            keywords: &[
                "आजारी",
                "औषध",
                "डॉक\u{94d}टर",
                "शॉट",
                "साधन",
                "सिरि\u{902}ज",
                "स\u{941}ई",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("picagari"),
            keywords: &[
                "alat",
                "doktor",
                "jarum",
                "perubatan",
                "picagari",
                "sakit",
                "suntikan",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("siringa"),
            keywords: &[
                "għodda",
                "labra",
                "marid",
                "mediċina",
                "siringa",
                "tabib",
                "vaċċin",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဆေးထ\u{102d}\u{102f}းအပ\u{103a}"),
            keywords: &[
                "ဆေး",
                "ဆေးထ\u{102d}\u{102f}းပြ\u{103d}တ\u{103a}",
                "ဆေးထ\u{102d}\u{102f}းအပ\u{103a}",
                "ဖျားနာခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sprøyte"),
            keywords: &["medisin", "nål", "sprøyte", "syk", "vaksine"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{942}ई"),
            keywords: &["औषधि", "बिरामी", "सट", "स\u{941}ई", "स\u{942}ई"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("injectiespuit"),
            keywords: &["geneeskunde", "injectie", "injectiespuit", "naald", "ziek"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("sprøyte"),
            keywords: &["medisin", "nål", "sjuk", "sprøyte", "vaksine"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b3f}ର\u{b3f}ଞ\u{b4d}ଜ"),
            keywords: &[
                "ଔଷଧ",
                "ଛ\u{b41}ଞ\u{b4d}ଚ\u{b3f}",
                "ର\u{b41}ଗ\u{b4d}\u{200c}ଣ",
                "ସଟ\u{b4d}\u{200c}",
                "ସ\u{b3f}ର\u{b3f}ଞ\u{b4d}ଜ",
                "ସ\u{b3f}ର\u{b3f}ଞ\u{b4d}ଜ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਰਿ\u{a70}ਜ"),
            keywords: &["ਟੀਕਾ", "ਦਵਾਈ", "ਬਿਮਾਰ", "ਸਰਿ\u{a70}ਜ", "ਸ\u{a42}ਈ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ٹیکا"),
            keywords: &["اوزار", "دوائی", "سوئی", "طبیب", "علیل", "نشانہ", "ٹیکا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Sirinj"),
            keywords: &["Mẹ\u{301}dísin", "Nídul", "Shọt", "Sik", "Sirinj"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("strzykawka"),
            keywords: &[
                "chory",
                "lekarstwo",
                "strzykawka",
                "szczepienie",
                "szczepionka",
                "zastrzyk",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سرنج"),
            keywords: &["درمل", "ستن", "سرنج", "سيرنج", "ناروغ", "وهل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("seringa"),
            keywords: &["agulha", "médico", "remédio", "seringa"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "agulha",
                "doente",
                "injeção",
                "medicamento",
                "remédio",
                "seringa",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("seringă"),
            keywords: &[
                "ac",
                "doctor",
                "injecție",
                "seringă",
                "siringă",
                "tratament",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-582"),
            keywords: &["E10-582"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("шприц"),
            keywords: &["инъекция", "медицина", "препарат", "укол", "шприц"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("urushinge rwo kwa muganga"),
            keywords: &[
                "guterwa urushinge",
                "igikoresho",
                "muganga",
                "ubuvuzi",
                "urushinge",
                "urushinge rwo kwa muganga",
                "urwaye",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سرنج"),
            keywords: &["اوزار", "بيمار", "دوا", "سئي", "سرنج", "شاٽ", "ڊاڪٽر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dd2}ර\u{dd2}න\u{dca}ජය"),
            keywords: &[
                "ඉඳ\u{dd2}කට\u{dd4}ව",
                "ඖෂධ",
                "ම\u{dcf}ත\u{dca}\u{200d}ර\u{dcf}ව",
                "ලෙඩ",
                "ස\u{dd2}ර\u{dd2}න\u{dca}ජය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("injekcia"),
            keywords: &[
                "choroba",
                "doktor",
                "ihla",
                "injekcia",
                "medicína",
                "nástroj",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("injekcija"),
            keywords: &[
                "bolno",
                "igla",
                "injekcija",
                "medicina",
                "orodje",
                "zdravnik",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("irbad"),
            keywords: &["dawo", "irbad", "talaal", "xanuunsanaya"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shiringë"),
            keywords: &["doktor", "gjilpërë", "ilaç", "injeksion", "shiringë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("шприц"),
            keywords: &["болест", "игла", "инјекција", "лек", "шприц"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["шприц"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("špric"),
            keywords: &["bolest", "igla", "injekcija", "lek", "špric"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["špric"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("spruta"),
            keywords: &["nål", "sjukvård", "spruta"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("bomba la sindano"),
            keywords: &[
                "bomba la sindano",
                "daktari",
                "dawa",
                "kuchoma sindano",
                "mgonjwa",
                "sindano",
                "zana",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஊசி"),
            keywords: &[
                "ஊசி",
                "க\u{bbe}ய\u{bcd}ச\u{bcd}சல\u{bcd}",
                "மருத\u{bcd}துவம\u{bcd}",
                "மருந\u{bcd}து",
                "வைத\u{bcd}தியம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c3f}రంజ\u{c3f}"),
            keywords: &["స\u{c3f}రంజ\u{c3f}", "సూద\u{c3f}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("сӯзандору"),
            keywords: &[
                "асбоб",
                "бемор",
                "дору",
                "духтур",
                "сӯзан",
                "сӯзандору",
                "сӯзанзанӣ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("กระบอกฉ\u{e35}ดยา"),
            keywords: &["กระบอกฉ\u{e35}ดยา", "ฉ\u{e35}ดยา", "เข\u{e47}มฉ\u{e35}ดยา"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("şpris"),
            keywords: &["derman", "hassa", "iňňe", "sanjym", "şpris"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻafana faitoʻo"),
            keywords: &["meʻafana faitoʻo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("şırınga"),
            keywords: &["doktor", "ilaç", "iğne", "şırınga"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئىشپىرىس"),
            keywords: &[
                "ئوكۇل",
                "ئىشپىرىس",
                "دوختۇر",
                "دورا",
                "قورال",
                "كېسەل",
                "يىڭنە",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("шприц"),
            keywords: &[
                "голка",
                "лікар",
                "ліки",
                "укол",
                "хворий",
                "шприц",
                "інструмент",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سرنج"),
            keywords: &["آلہ", "دوائی", "سرنج", "سوئی", "ڈاکٹر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("shprits"),
            keywords: &["dori", "igna", "kasal", "shprits", "ukol"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ống tiêm"),
            keywords: &["bệnh", "kim", "thuốc", "tiêm", "ống tiêm"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("pikiir"),
            keywords: &[
                "doktor",
                "jam",
                "jumtukaay",
                "medsin",
                "pikiir",
                "puso",
                "sik",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isirinji"),
            keywords: &[
                "amayeza", "inaliti", "isirinji", "isixhobo", "ugqirha", "ukugula",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("abẹrẹ"),
            keywords: &[
                "abẹrẹ",
                "dókítà",
                "ikin",
                "irinṣẹ\u{301}",
                "yìn",
                "àìsàn",
                "òògùn",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("針筒"),
            keywords: &["工具", "注射", "生病", "醫生", "醫藥", "針", "針筒"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("针筒"),
            keywords: &["医生", "医药", "工具", "注射", "生病", "针", "针筒"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("注射器"),
            keywords: &["医学", "打针", "治疗", "注射器", "针头", "针筒"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("針筒"),
            keywords: &["注射器", "針筒"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umjovo"),
            keywords: &[
                "imithi",
                "inaliti",
                "ithuluzi",
                "udokotela",
                "ukugula",
                "ukujova",
                "umjovo",
            ],
        },
    ],
};
#[doc = "🩸"]
pub const DROP_OF_BLOOD: crate::Emoji = crate::Emoji {
    glyph: "🩸",
    codepoint: "1FA78",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "drop of blood",
    group: "Objects",
    subgroup: "medical",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("bloeddruppel"),
            keywords: &["bloeddruppel", "bloedskenk", "medisyne", "menstruasie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የደም ጠብታ"),
            keywords: &["ህክምና", "የወር አበባ", "የደም ጠብታ", "ደም ልገሳ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قطرة دم"),
            keywords: &["تبرع بالدم", "حيض", "طب", "طمث", "قطرة دم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("তেজৰ টোপ\u{9be}ল"),
            keywords: &[
                "ঋত\u{9c1}স\u{9cd}ৰ\u{9be}ব",
                "ঔষধ",
                "তেজৰ টোপ\u{9be}ল",
                "ৰক\u{9cd}তদ\u{9be}ন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qan damlası"),
            keywords: &["aybaşı", "qan damlası", "qan donoru", "tibb"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кропля крыві"),
            keywords: &["донарства крыві", "кропля крыві", "медыцына", "менструацыя"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("капка кръв"),
            keywords: &["даряване на кръв", "капка кръв", "медицина", "менструация"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("এক ফো\u{981}ট\u{9be} রক\u{9cd}ত"),
            keywords: &[
                "এক ফো\u{981}ট\u{9be} রক\u{9cd}ত",
                "ঔষধ",
                "রক\u{9cd}তদ\u{9be}ন",
                "রজঃস\u{9cd}র\u{9be}ব",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("takenn wad"),
            keywords: &["gwad", "medisinerezh", "mezegiezh", "takenn", "takenn wad"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kapljica krvi"),
            keywords: &[
                "doniranje krvi",
                "kapljica krvi",
                "medicina",
                "menstruacija",
                "menzes",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("gota de sang"),
            keywords: &["donació de sang", "gota de sang", "medicina", "menstruació"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎩᎦ"),
            keywords: &["ᎩᎦ", "ᎩᎦ ᎠᎵᏍᎪᎸᏙᏗ", "ᏅᏬᏘ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kapka krve"),
            keywords: &[
                "darování",
                "dárcovství",
                "kapka krve",
                "krev",
                "lékařství",
                "medicína",
                "menstruace",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("diferyn o waed"),
            keywords: &["diferyn o waed", "meddyginiaeth", "mislif", "rhoi gwaed"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bloddråbe"),
            keywords: &[
                "blod",
                "bloddonor",
                "bloddråbe",
                "medicin",
                "menstruation",
                "sår",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Blutstropfen"),
            keywords: &["Blutspende", "Blutstropfen", "Medizin", "Menstruation"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σταγόνα αίματος"),
            keywords: &["έμμηνος ρήση", "αιμοδοσία", "σταγόνα αίματος", "φάρμακο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("drop of blood"),
            keywords: &[
                "bleed",
                "blood donation",
                "drop of blood",
                "injury",
                "medicine",
                "menstruation",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("gota de sangre"),
            keywords: &[
                "donación de sangre",
                "donar sangre",
                "gota de sangre",
                "herida",
                "medicina",
                "sangre",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("veretilk"),
            keywords: &["meditsiin", "menstruatsioon", "veredoonorlus", "veretilk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("odol tanta"),
            keywords: &["hileroko", "medikuntza", "odol tanta", "odol-emate"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قطره خون"),
            keywords: &["اهدای خون", "دارو", "قاعدگی", "قطره خون"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("veripisara"),
            keywords: &["kuukautiset", "lääketiede", "verenluovutus", "veripisara"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("patak ng dugo"),
            keywords: &[
                "donasyon ng dugo",
                "gamot",
                "patak ng dugo",
                "regla",
                "sugat",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("blóðdropi"),
            keywords: &["blóð", "blóðdropi", "blóðgevi", "blóðgáva", "dropi"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("goutte de sang"),
            keywords: &[
                "don du sang",
                "goutte de sang",
                "menstruation",
                "médecine",
                "règles",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("braoinín fola"),
            keywords: &["braoinín fola", "deonú fola", "leigheas", "míostrú"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("boinne fala"),
            keywords: &[
                "boinne",
                "boinne fala",
                "fuil",
                "fuil mhìosail",
                "fuil-mìos",
                "leigheas",
                "tabhartas fala",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("pinga de sangue"),
            keywords: &[
                "doazón de sangue",
                "medicina",
                "menstruación",
                "pinga de sangue",
                "regra",
                "sangue",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લોહીન\u{ac1}\u{a82} ટીપ\u{ac1}\u{a82}"),
            keywords: &[
                "દવા",
                "રક\u{acd}ત દાન",
                "રજોદર\u{acd}શન",
                "લોહીન\u{ac1}\u{a82} ટીપ\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("טיפת דם"),
            keywords: &["דם", "טיפת דם", "רפואה", "תרומת דם"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ख\u{93c}\u{942}न की ब\u{942}\u{901}द"),
            keywords: &[
                "ख\u{93c}\u{942}न",
                "ख\u{93c}\u{942}न की ब\u{942}\u{901}द",
                "चिकित\u{94d}सा",
                "रक\u{94d}त",
                "रक\u{94d}तदान",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kap krvi"),
            keywords: &["doniranje krvi", "kap krvi", "medicina", "menstruacija"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("vércsepp"),
            keywords: &["gyógyszer", "menstruáció", "véradás", "vércsepp"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("արյան կաթիլ"),
            keywords: &["արյան դոնոր", "արյան կաթիլ", "բժշկություն", "դաշտան"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tetesan darah"),
            keywords: &["donor darah", "menstruasi", "obat", "tetesan darah"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("blóðdropi"),
            keywords: &["blæðingar", "blóðdropi", "blóðgjöf", "læknisfræði"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("goccia di sangue"),
            keywords: &[
                "ciclo mestruale",
                "donare il sangue",
                "donazione di sangue",
                "goccia di sangue",
                "medicina",
                "medicinale",
                "mestruazioni",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("血液"),
            keywords: &["けが", "医者", "献血", "生理", "血液"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("satetes getih"),
            keywords: &["donor getih", "menstruasi", "obat", "satetes getih"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სისხლის წვეთი"),
            keywords: &[
                "დონორი",
                "მედიცინა",
                "მენსტრუაცია",
                "სისხლი",
                "სისხლის გაღება",
                "სისხლის წვეთი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қан тамшысы"),
            keywords: &["донорлық қан тапсыру", "етеккір", "медицина", "қан тамшысы"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ត\u{17c6}ណក\u{17cb}ឈាម"),
            keywords: &[
                "ការធ\u{17d2}លាក\u{17cb}រដ\u{17bc}វ",
                "ការបរ\u{17b7}ច\u{17d2}ចាគឈាម",
                "ត\u{17c6}ណក\u{17cb}ឈាម",
                "ឱសថ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ರಕ\u{ccd}ತದ ಹನ\u{cbf}"),
            keywords: &[
                "ಋತುಚಕ\u{ccd}ರ",
                "ಔಷಧ\u{cbf}",
                "ರಕ\u{ccd}ತ ದಾನ",
                "ರಕ\u{ccd}ತದ ಹನ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("핏방울"),
            keywords: &["생리", "핏방울", "헌혈"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("रक\u{94d}ताचो थ\u{947}\u{902}बो"),
            keywords: &[
                "द\u{941}खापत",
                "मासीकधर\u{94d}म",
                "रक\u{94d}त दान",
                "रक\u{94d}ताचो थ\u{947}\u{902}बो",
                "रगत",
                "वखदा\u{902}",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тамчы кан"),
            keywords: &["айыз", "кан тапшыруу", "медицина", "тамчы кан"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຢ\u{ebb}ດ\u{200b}ເລ\u{eb7}\u{200b}ອດ"),
            keywords: &[
                "ບ\u{ecd}\u{200b}ລ\u{eb4}\u{200b}ຈາກ\u{200b}ເລ\u{eb7}ອດ",
                "ປະ\u{200b}ຈຳ\u{200b}ເດ\u{eb7}ອນ",
                "ຢ\u{ebb}ດ\u{200b}ເລ\u{eb7}\u{200b}ອດ",
                "ຮ\u{eb1}ກ\u{200b}ສາ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kraujo lašas"),
            keywords: &[
                "kraujo aukojimas",
                "kraujo lašas",
                "medicina",
                "menstruacijos",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("asins pile"),
            keywords: &["asins pile", "asins ziedošana", "medicīna", "menstruācija"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("капка крв"),
            keywords: &[
                "донирање крв",
                "капка крв",
                "крварење",
                "менструација",
                "повреда",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("രക\u{d4d}തത\u{d4d}ത\u{d41}ള\u{d4d}ളി"),
            keywords: &[
                "ആർത\u{d4d}തവം",
                "മര\u{d41}ന\u{d4d}ന\u{d4d}",
                "രക\u{d4d}തത\u{d4d}ത\u{d41}ള\u{d4d}ളി",
                "രക\u{d4d}തദ\u{d3e}നം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дусал цус"),
            keywords: &["дусал цус", "сарын тэмдэг", "цус хандивлах", "эмнэлэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("रक\u{94d}ताचा थ\u{947}\u{902}ब"),
            keywords: &[
                "औषध",
                "मासिक पाळी",
                "रक\u{94d}तदान",
                "रक\u{94d}ताचा थ\u{947}\u{902}ब",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("titisan darah"),
            keywords: &["derma darah", "haid", "perubatan", "titisan darah"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("သ\u{103d}ေးတစ\u{103a}စက\u{103a}"),
            keywords: &[
                "ဆေးဝါး",
                "ရာသ\u{102e}လာခြင\u{103a}း",
                "သ\u{103d}ေးတစ\u{103a}စက\u{103a}",
                "သ\u{103d}ေးလ\u{103e}\u{1030}ခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bloddråpe"),
            keywords: &["bloddråpe", "blodgiver", "medisin", "mens", "menstruasjon"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("रक\u{94d}तको थोपा"),
            keywords: &[
                "ऋत\u{941}स\u{94d}राव",
                "औषधी",
                "रक\u{94d}त दान",
                "रक\u{94d}तको थोपा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bloeddruppel"),
            keywords: &[
                "bloeddonor",
                "bloeddruppel",
                "bloeden",
                "geneeskunde",
                "menstruatie",
                "verwonding",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bloddrope"),
            keywords: &["bloddrope", "blodgjevar", "medisin", "mens", "menstruasjon"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ରକ\u{b4d}ତ ଟୋପ\u{b3e}"),
            keywords: &[
                "ଔଷଧ",
                "ମ\u{b3e}ସ\u{b3f}କ ସ\u{b4d}ର\u{b3e}ବ",
                "ରକ\u{b4d}ତ ଟୋପ\u{b3e}",
                "ରକ\u{b4d}ତ ଦ\u{b3e}ନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਖ\u{a42}ਨਦਾਨ"),
            keywords: &["ਖ\u{a42}ਨਦਾਨ", "ਦਵਾਈ", "ਮਾਹਵਾਰੀ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Drọ\u{301}p Ọf Blọd"),
            keywords: &[
                "Blid",
                "Drọ\u{301}p Ọf Blọd",
                "Mẹnsturéshọn",
                "Mẹ\u{301}dísin",
                "Taim",
                "To Donét Blọd",
                "Ínjúri",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kropla krwi"),
            keywords: &[
                "kropla krwi",
                "krwiodawstwo",
                "medycyna",
                "menstruacja",
                "oddawanie krwi",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د وينې څاڅکی"),
            keywords: &["حيض", "د وينې څاڅکی", "درمل", "وينه ورکول"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("gota de sangue"),
            keywords: &[
                "doação de sangue",
                "gota de sangue",
                "medicina",
                "menstruação",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("gota de sangue"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("picătură de sânge"),
            keywords: &[
                "donare de sânge",
                "medicină",
                "menstruație",
                "picătură de sânge",
                "rană",
                "sânge",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–063"),
            keywords: &["E12–063"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("капля крови"),
            keywords: &[
                "донор",
                "капля",
                "капля крови",
                "красный",
                "кровь",
                "менструация",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("رت جو فڙو"),
            keywords: &["خون جو عطيو", "دوائون", "رت جو فڙو", "مهاواري"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ලේ බ\u{dd2}න\u{dca}ද\u{dd4}ව"),
            keywords: &[
                "ඔසප\u{dca} ව\u{dd3}ම",
                "ඖෂධ",
                "ර\u{dd4}ධ\u{dd2}රය පර\u{dd2}ත\u{dca}\u{200d}ය\u{dcf}ගය",
                "ලේ බ\u{dd2}න\u{dca}ද\u{dd4}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kvapka krvi"),
            keywords: &[
                "darcovstvo",
                "darovanie",
                "krv",
                "kvapka krvi",
                "lekárstvo",
                "medicína",
                "menštruácia",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kaplja krvi"),
            keywords: &[
                "kaplja krvi",
                "krvodajalstvo",
                "medicina",
                "menstruacija",
                "zdravstvo",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dhibic dhiig ah"),
            keywords: &["dawo", "dhibic dhiig ah", "dhiig bixin"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("pikë gjaku"),
            keywords: &["dhurim gjaku", "ilaç", "menstruacione", "pikë gjaku"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кап крви"),
            keywords: &[
                "давање крви",
                "кап крви",
                "крварење",
                "лек",
                "менструација",
                "повреда",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["кап крви"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kap krvi"),
            keywords: &[
                "davanje krvi",
                "kap krvi",
                "krvarenje",
                "lek",
                "menstruacija",
                "povreda",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["kap krvi"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("blodsdroppe"),
            keywords: &["blodsdroppe", "ge blod", "medicin", "menstruation"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("tone la damu"),
            keywords: &[
                "dawa",
                "hedhi",
                "jeraha",
                "kuchangia damu",
                "tokwa na damu",
                "tone la damu",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("இரத\u{bcd}தத\u{bcd} துளி"),
            keywords: &[
                "இரத\u{bcd}த த\u{bbe}னம\u{bcd}",
                "இரத\u{bcd}தத\u{bcd} துளி",
                "மருந\u{bcd}துவம\u{bcd}",
                "ம\u{bbe}தவிட\u{bbe}ய\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("రక\u{c4d}తపు బ\u{c4a}ట\u{c4d}టు"),
            keywords: &[
                "మందు",
                "రక\u{c4d}తద\u{c3e}నం",
                "రక\u{c4d}తపు బ\u{c4a}ట\u{c4d}టు",
                "రుతుక\u{c4d}రమం",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หยดเล\u{e37}อด"),
            keywords: &[
                "การบร\u{e34}จาคเล\u{e37}อด",
                "ยา",
                "รอบประจำเด\u{e37}อน",
                "หยดเล\u{e37}อด",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gan damjasy"),
            keywords: &[
                "gan damjasy",
                "gan tabşyrmak",
                "lukmançylyk",
                "menstruasiýa",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tulutā toto"),
            keywords: &["tulutā toto"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kan damlası"),
            keywords: &[
                "aybaşı",
                "ilaç",
                "kan bağışı",
                "kan damlası",
                "mens",
                "regl",
                "âdet",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("крапля крові"),
            keywords: &[
                "аналіз крові",
                "донорство крові",
                "крапля крові",
                "медецина",
                "місячне",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("خون کا قطرہ"),
            keywords: &["حیض", "خون کا عطیہ", "خون کا قطرہ", "دوا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qon tomchisi"),
            keywords: &[
                "hayz",
                "menstruatsiya",
                "qon tomchisi",
                "qon topshirish",
                "tibbiyot",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("giọt máu"),
            keywords: &[
                "chu kỳ kinh nguyệt",
                "giọt máu",
                "hiến máu",
                "thuốc",
                "y tế",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("血液"),
            keywords: &["捐血", "月經", "血液", "醫療"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("血液"),
            keywords: &["医疗", "捐血", "月经", "血液"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("血滴"),
            keywords: &["医疗", "月经", "献血", "经血", "血滴", "输血"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("血滴"),
            keywords: &["捐血", "生理期", "藥", "血滴"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("一滴血"),
            keywords: &["一滴血", "捐血", "經期", "藥"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ithonsi legazi"),
            keywords: &["imithi", "ithonsi legazi", "ukopha", "ukuphisana ngegazi"],
        },
    ],
};
#[doc = "💊"]
pub const PILL: crate::Emoji = crate::Emoji {
    glyph: "💊",
    codepoint: "1F48A",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "pill",
    group: "Objects",
    subgroup: "medical",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("pil"),
            keywords: &["dokter", "medisyne", "pil", "siek"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ክኒን"),
            keywords: &["ሕክምና", "ክኒን", "የታመመ", "ዶክተር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("حبوب"),
            keywords: &["حبوب", "طب", "طبيب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("পিল"),
            keywords: &["ঔষধ", "চিকিৎসক", "পিল", "ৰোগী"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("həb"),
            keywords: &["həb", "həkim", "naxoş", "tibb"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("таблетка"),
            keywords: &["доктар", "лекі", "таблетка", "хворы"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("хапче"),
            keywords: &["болен", "лекар", "медицина", "хапче"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বড\u{9bc}ি"),
            keywords: &[
                "অস\u{9c1}স\u{9cd}থ",
                "ওষ\u{9c1}ধ",
                "ড\u{9be}ক\u{9cd}ত\u{9be}র",
                "বড\u{9bc}ি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pilulenn"),
            keywords: &["medisinerezh", "mezegiezh", "pilulenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("pilula"),
            keywords: &["bolest", "doktor", "medicina", "pilula"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("píndola"),
            keywords: &["malalt", "medicina", "metge", "pastilla", "píndola"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏅᏬᏓ ᎠᎩᏍᏓ"),
            keywords: &["ᎠᎦᎾᎦᏘ", "ᎤᏢᎩ", "ᏅᏬᏓ ᎠᎩᏍᏓ", "ᏅᏬᏘ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("pilulka"),
            keywords: &[
                "doktor", "lék", "lékař", "nemoc", "nemocný", "pilulka", "prášek",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("pilsen"),
            keywords: &["doctor", "meddygaeth", "pilsen", "sâl"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("pille"),
            keywords: &["læge", "medicin", "pille"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Kapsel"),
            keywords: &["Arzt", "Kapsel", "Medizin", "Tabletten"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("χάπι"),
            keywords: &["άρρωστος", "γιατρός", "φάρμακο", "χάπι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("pill"),
            keywords: &["doctor", "medicine", "pill", "sick"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["capsule", "doctor", "medicine", "pill", "sick", "tablet"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("píldora"),
            keywords: &["comprimido", "medicina", "médico", "pastilla", "píldora"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["medicamento", "medicina", "médico", "pastilla", "píldora"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("tablett"),
            keywords: &["arst", "haige", "ravim", "tablett"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("pilula"),
            keywords: &["gaixo", "medikuntza", "pilula", "sendagile"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قرص"),
            keywords: &["بیمار", "دارو", "قرص", "پزشک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pilleri"),
            keywords: &["lääke", "lääketiede", "lääkäri", "pilleri", "tauti"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pill"),
            keywords: &["doktor", "gamot", "pill", "sakit"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("pillari"),
            keywords: &["heilivágur", "lækni", "medisin", "pillari", "sjúka"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("pilule"),
            keywords: &["docteur", "malade", "médecine", "pilule"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("piolla"),
            keywords: &["dochtúir", "leigheas", "piolla"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("pile"),
            keywords: &["bochd", "dotair", "leigheas", "pile", "tinn"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("pílula"),
            keywords: &["enfermidade", "medicamento", "médico", "pastilla", "pílula"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ગોળી, ટિકડી"),
            keywords: &["ગોળી", "ગોળી, ટિકડી", "ડોક\u{acd}ટર", "દવા"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kwaya"),
            keywords: &["kwaya", "likita", "magani", "maras lafiya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כדור"),
            keywords: &["חולה", "כדור", "כמוסה", "רופא", "תרופה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("गोली"),
            keywords: &["गोली", "डॉक\u{94d}टर", "दवाई"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("pilula"),
            keywords: &["bolest", "doktor", "medicina", "pilula"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("tabletta"),
            keywords: &[
                "betegség",
                "doktor",
                "gyógyszer",
                "orvos",
                "pirula",
                "tabletta",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("դեղահաբ"),
            keywords: &["բժիշկ", "բժշկություն", "դեղահաբ", "հիվանդ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pil"),
            keywords: &["dokter", "obat", "pil", "sakit"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("mkpụrụ ọgwụ"),
            keywords: &["dọkịnta", "mkpụrụ ọgwụ", "ọgwụ", "ọrịa"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("pilla"),
            keywords: &["lyf", "læknir", "pilla"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pillola"),
            keywords: &["dottore", "medicina", "pillola"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("薬"),
            keywords: &["カプセル", "医者", "病気", "薬"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pil"),
            keywords: &["dhokter", "lara", "obat", "pil"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("აბი"),
            keywords: &["აბი", "ავადმყოფობა", "ექიმი", "მედიცინა"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: None,
            keywords: &["amejjay", "amuḍin", "tujjya"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("таблетка"),
            keywords: &["ауру", "дәрігер", "медицина", "таблетка"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("pille"),
            keywords: &["læge", "medicin", "pille"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ថ\u{17d2}នា\u{17c6}"),
            keywords: &["ជម\u{17d2}ង\u{17ba}", "ថ\u{17d2}នា\u{17c6}", "ពេទ\u{17d2}យ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಾತ\u{ccd}ರ\u{cc6}"),
            keywords: &["ಔಷಧ", "ಮಾತ\u{ccd}ರ\u{cc6}", "ವೈದ\u{ccd}ಯರು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("알약"),
            keywords: &["알약", "약"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ग\u{941}ळी"),
            keywords: &[
                "ग\u{941}ळी",
                "द\u{941}य\u{947}\u{902}त",
                "दोतोर",
                "वखदा\u{902}",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("таблетка"),
            keywords: &["дары", "дарыгер", "оору", "таблетка"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Pëll"),
            keywords: &["Dokter", "Medezin", "Pëll", "krank"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເມ\u{eb1}ດຢາ"),
            keywords: &["ຢາ", "ເປ\u{eb1}ນໄຂ\u{ec9}", "ເມ\u{eb1}ດຢາ", "ໝ\u{ecd}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("piliulė"),
            keywords: &["gydytojas", "ligonis", "medicina", "piliulė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zāļu kapsula"),
            keywords: &["medicīna", "slims", "zāles", "zāļu kapsula", "ārsts"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pire"),
            keywords: &["mate", "pire", "rata", "rongoā"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("капсула"),
            keywords: &["болен", "доктор", "капсула", "лек"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഗ\u{d41}ളിക"),
            keywords: &[
                "ഗ\u{d41}ളിക",
                "ഡോക\u{d4d}ടർ",
                "പിൽ",
                "മര\u{d41}ന\u{d4d}ന\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эм"),
            keywords: &["эм", "эмч", "өвчтэй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("औषधाची गोळी"),
            keywords: &["आजारी", "औषध", "औषधाची गोळी", "डॉक\u{94d}टर"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pil"),
            keywords: &["doktor", "perubatan", "pil", "sakit"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("pillola"),
            keywords: &["marid", "mediċina", "pillola", "tabib"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဆေးလ\u{102f}\u{1036}း"),
            keywords: &[
                "ဆရာဝန\u{103a}",
                "ဆေး",
                "ဆေးလ\u{102f}\u{1036}း",
                "ဖျားနာခြင\u{103a}း",
                "သောက\u{103a}ဆေး",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("pille"),
            keywords: &["lege", "medisin", "pille", "tablett"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("औ\u{902}षधीको गोली"),
            keywords: &[
                "औ\u{902}षधिको गोली",
                "औ\u{902}षधीको गोली",
                "औषधि",
                "डाक\u{94d}टर",
                "बिरामी",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("pil"),
            keywords: &["dokter", "geneeskunde", "pil", "ziek"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("pille"),
            keywords: &["lege", "medisin", "pille", "tablett"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବଟ\u{b3f}କ\u{b3e}"),
            keywords: &["ଔଷଧ", "ଡ\u{b3e}କ\u{b4d}ତର", "ବଟ\u{b3f}କ\u{b3e}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਦਵਾਈ ਦੀ ਗ\u{a4b}ਲੀ"),
            keywords: &["ਗ\u{a4b}ਲੀ", "ਡਾਕਟਰ", "ਦਵਾਈ", "ਦਵਾਈ ਦੀ ਗ\u{a4b}ਲੀ", "ਬੀਮਾਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("گولی"),
            keywords: &["دوائی", "طبیب", "علیل", "گولی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mẹ\u{301}dísin"),
            keywords: &["Dọ\u{301}ktọ", "Mẹ\u{301}dísin", "Pil", "Sik"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kapsułka"),
            keywords: &["kapsułka", "lekarstwo", "tabletka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ګولۍ"),
            keywords: &["درمل", "ناروغ", "ډاکټر", "ګولۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("comprimido"),
            keywords: &["comprimido", "medicina", "médico", "pílula", "remédio"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["comprimido", "doente", "medicina", "médico"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pastilă"),
            keywords: &["doctor", "medicament", "pastilă", "pilulă", "tratament"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-583"),
            keywords: &["E10-583"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("пилюля"),
            keywords: &["капсула", "лекарство", "пилюля", "препарат", "таблетка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikinini"),
            keywords: &["ikinini", "muganga", "ubuvuzi", "urwaye"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("گوري"),
            keywords: &["بيمار", "دوا", "ڊاڪٽر", "گوري"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වර\u{dca}ත\u{dd2}ක\u{dcf}ව"),
            keywords: &[
                "ඖෂධ",
                "රෝග\u{dd3}",
                "වර\u{dca}ත\u{dd2}ක\u{dcf}ව",
                "වෛද\u{dca}\u{200d}යවරය\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("tabletka"),
            keywords: &["choroba", "doktor", "medicína", "tabletka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("tableta"),
            keywords: &["bolno", "tableta", "zdravilo", "zdravnik"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kiniin"),
            keywords: &["dawo", "dhakhtar", "kiniin", "xanuunsanaya"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("pilulë"),
            keywords: &["bar", "doktor", "i sëmurë", "ilaç", "pilulë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("пилула"),
            keywords: &["бoлeст", "лекар", "мeдицинa", "пилула"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["пилула"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("pilula"),
            keywords: &["bolest", "lekar", "medicina", "pilula"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["pilula"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("piller"),
            keywords: &["medicin", "piller", "tablett"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kidonge"),
            keywords: &["daktari", "dawa", "kidonge", "mgonjwa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ம\u{bbe}த\u{bcd}திரை"),
            keywords: &[
                "உடல\u{bcd} நலக\u{bcd} குறைவு",
                "மருத\u{bcd}துவம\u{bcd}",
                "மருத\u{bcd}துவர\u{bcd}",
                "மருந\u{bcd}து",
                "ம\u{bbe}த\u{bcd}திரை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c3e}త\u{c4d}ర"),
            keywords: &["గుళ\u{c3f}క", "మ\u{c3e}త\u{c4d}ర"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дору"),
            keywords: &["бемор", "дору", "духтур"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ยาเม\u{e47}ด"),
            keywords: &["ยา", "ยาเม\u{e47}ด", "หมอ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gerdejik"),
            keywords: &["gerdejik", "hassa", "lukman", "lukmançylyk"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("foʻiʻakau"),
            keywords: &["foʻiʻakau"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("hap"),
            keywords: &["doktor", "hap", "ilaç"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تابلېتكا"),
            keywords: &["تابلېتكا", "دوختۇر", "دورا", "كېسەل"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("пігулка"),
            keywords: &["лікар", "ліки", "пігулка", "хворий"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گولی"),
            keywords: &["بیماری", "دوائی", "ڈاکٹر", "گولی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("hapdori"),
            keywords: &[
                "bemor", "doktor", "hapdori", "kasal", "shifokor", "tibbiyot",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("viên thuốc"),
            keywords: &["bác sĩ", "bệnh", "thuốc", "viên thuốc"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("garab"),
            keywords: &["doktor", "feebar", "garab", "medsin"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ipilisi"),
            keywords: &["amayeza", "ipilisi", "ugqirha", "ukugula"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("pili"),
            keywords: &["dókítà", "pili", "àìsàn", "òògùn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("藥丸"),
            keywords: &["病", "藥丸", "醫生", "醫藥"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("药丸"),
            keywords: &["医生", "医药", "病", "药丸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("药丸"),
            keywords: &["吃药", "治疗", "药", "药丸", "药物"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("藥丸"),
            keywords: &["藥", "藥丸"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iphilisi"),
            keywords: &["imithi", "iphilisi", "udokotela", "ukugula"],
        },
    ],
};
#[doc = "🩹"]
pub const ADHESIVE_BANDAGE: crate::Emoji = crate::Emoji {
    glyph: "🩹",
    codepoint: "1FA79",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "adhesive bandage",
    group: "Objects",
    subgroup: "medical",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("plakpleister"),
            keywords: &["plakpleister", "pleister"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ፋሻ ማጣበቂያ"),
            keywords: &["ፋሻ", "ፋሻ ማጣበቂያ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ضمادة لاصقة"),
            keywords: &["ضمادة لاصقة", "لاصقة جروح"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("আঠ\u{9be}লো বেণ\u{9cd}ডেজ"),
            keywords: &["আঠ\u{9be}লো বেণ\u{9cd}ডেজ", "বেণ\u{9cd}ডেজ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yapışan bandaj"),
            keywords: &["bandaj", "yapışan bandaj"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("пластыр"),
            keywords: &["бінт", "пластыр"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("лепенка за рани"),
            keywords: &["лейкопласт", "лепенка", "лепенка за рани", "пластир"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("আঠ\u{9be}লো ব\u{9cd}য\u{9be}ন\u{9cd}ডেজ"),
            keywords: &[
                "আঠ\u{9be}লো ব\u{9cd}য\u{9be}ন\u{9cd}ডেজ",
                "ব\u{9cd}য\u{9be}ণ\u{9cd}ডেজ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("lienad-peg"),
            keywords: &["bandenn", "lienad", "lienad-peg", "lienenn", "sparadrap"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ljepljivi flaster"),
            keywords: &["flaster", "ljepljivi flaster"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("tireta"),
            keywords: &["bena", "tireta"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏓᎦᏣᎦᎵ ᎠᎦᏍᏢᏅᎢ"),
            keywords: &["ᎠᎦᏍᏢᏅᎢ", "ᎤᏓᎦᏣᎦᎵ ᎠᎦᏍᏢᏅᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("náplast"),
            keywords: &["bandáž", "náplast", "obvaz"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bandej glynu"),
            keywords: &["bandej", "bandej glynu"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("plaster"),
            keywords: &["plaster"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Heftpflaster"),
            keywords: &["Heftpflaster", "Pflaster"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αυτοκόλλητο χανζαπλάστ"),
            keywords: &["αυτοκόλλητο χανζαπλάστ", "χανζαπλάστ"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("adhesive bandage"),
            keywords: &["adhesive bandage", "bandage"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("plaster"),
            keywords: &["plaster"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("bandaid"),
            keywords: &["adhesive bandage", "bandage", "bandaid", "dressing"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("plaster"),
            keywords: &["injury", "plaster", "sticking plaster"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("tirita"),
            keywords: &["apósito", "tirita"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("curita"),
            keywords: &["curita"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("curita"),
            keywords: &["curita", "tira adhesiva"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("plaaster"),
            keywords: &["meditsiin", "plaaster"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("lotura itsaskorra"),
            keywords: &["lotura", "lotura itsaskorra"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("چسب زخم"),
            keywords: &["چسب", "چسب زخم"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("laastari"),
            keywords: &["haava", "hoito", "laastari"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("adhesive na bandaid"),
            keywords: &["adhesive na bandaid", "bandaid"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("heftiplástur"),
            keywords: &["heftiplástur", "plástur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("sparadrap"),
            keywords: &[
                "bandage",
                "médecine",
                "pansement",
                "premiers secours",
                "sparadrap",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bindealán greamaitheach"),
            keywords: &["bindealán", "bindealán greamaitheach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bann-araid"),
            keywords: &["bann-araid", "cuarag", "cuaran"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("apósito"),
            keywords: &["apósito", "apósito adhesivo", "cura", "ferida", "tirita"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("એડહ\u{ac7}સિવ બ\u{ac7}ન\u{acd}ડ\u{ac7}જ"),
            keywords: &[
                "એડહ\u{ac7}સિવ બ\u{ac7}ન\u{acd}ડ\u{ac7}જ",
                "બ\u{ac7}ન\u{acd}ડ\u{ac7}જ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פלסטר"),
            keywords: &["חבישה", "פלסטר", "פצע"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चिपकान\u{947} वाली पट\u{94d}\u{200d}टी"),
            keywords: &[
                "चिपकान\u{947} वाली पट\u{94d}\u{200d}टी",
                "पट\u{94d}टी",
                "ब\u{948}\u{902}ड एड",
                "ब\u{948}\u{902}ड\u{947}ज",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("flaster"),
            keywords: &["flaster", "samoljepivi flaster"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("ragtapasz"),
            keywords: &["kötszer", "ragtapasz"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սպեղանի"),
            keywords: &["սպեղանի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("plester luka"),
            keywords: &["plester", "plester luka"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("plástur"),
            keywords: &["plástur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cerotto"),
            keywords: &["cerotto", "cerotto adesivo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("絆創膏"),
            keywords: &["けが", "ばんそうこう", "傷", "手当て", "絆創膏", "薬"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("plester"),
            keywords: &["perban", "plester"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("პლასტირი"),
            keywords: &[
                "ლეოკოპლასტირი",
                "პლასტირი",
                "სამედიცინო პლასტირი",
                "ჭრილობა",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жабысқақ пластырь"),
            keywords: &["жабысқақ пластырь", "пластырь"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បង\u{17cb}ស\u{17d2}អ\u{17b7}ត"),
            keywords: &["បង\u{17cb}", "បង\u{17cb}ស\u{17d2}អ\u{17b7}ត"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಅಂಟ\u{cbf}ಸುವ ಬ\u{ccd}ಯಾಂಡೇಜ\u{ccd}"),
            keywords: &[
                "ಅಂಟ\u{cbf}ಸುವ ಬ\u{ccd}ಯಾಂಡೇಜ\u{ccd}",
                "ಬ\u{ccd}ಯಾಂಡೇಜ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("반창고"),
            keywords: &["반창고", "밴드"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("चिकट ब\u{901}ड\u{947}ज"),
            keywords: &["चिकट ब\u{901}ड\u{947}ज", "ब\u{901}ड\u{947}ज"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чаптама бинт"),
            keywords: &["бинт", "чаптама бинт"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{ec9}າ\u{200b}ພ\u{eb1}ນ\u{200b}ບາດ\u{200b}ແຜ"),
            keywords: &[
                "ຜ\u{ec9}າ\u{200b}ພ\u{eb1}ນ\u{200b}ບາດ",
                "ຜ\u{ec9}າ\u{200b}ພ\u{eb1}ນ\u{200b}ບາດ\u{200b}ແຜ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("pleistras"),
            keywords: &["pleistras"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("plāksteris"),
            keywords: &["plāksteris"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("леплив фластер"),
            keywords: &["леплив фластер", "фластер"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഒട\u{d4d}ടിക\u{d4d}ക\u{d41}ന\u{d4d}ന ബ\u{d3e}ൻഡേജ\u{d4d}"),
            keywords: &[
                "ഒട\u{d4d}ടിക\u{d4d}ക\u{d41}ന\u{d4d}ന ബ\u{d3e}ൻഡേജ\u{d4d}",
                "ബ\u{d3e}ൻഡേജ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хурууны наалт"),
            keywords: &["боолт", "хурууны наалт"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चिकट ब\u{901}ड\u{947}ज"),
            keywords: &["चिकट ब\u{901}ड\u{947}ज", "ब\u{901}ड\u{947}ज"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pembalut adhesif"),
            keywords: &["pembalut", "pembalut adhesif"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဆေးပလပ\u{103a}စတာ"),
            keywords: &["ဆေးပလပ\u{103a}စတာ", "ပလပ\u{103a}စတာ"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("plaster"),
            keywords: &["behandling", "plaster", "sår"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("टा\u{901}स\u{94d}सिन\u{947} ब\u{94d}यान\u{94d}ड\u{947}ज"),
            keywords: &[
                "टा\u{901}स\u{94d}सिन\u{947} ब\u{94d}यान\u{94d}ड\u{947}ज",
                "ब\u{94d}यान\u{94d}ड\u{947}ज",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("pleister"),
            keywords: &["pleister", "verband"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("plaster"),
            keywords: &["behandling", "plaster", "sår"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଅଠ\u{b3e} ଦ\u{b3f}ଆ ବ\u{b4d}ୟ\u{b3e}ଣ\u{b4d}ଡେଜ"),
            keywords: &[
                "ଅଠ\u{b3e} ଦ\u{b3f}ଆ ବ\u{b4d}ୟ\u{b3e}ଣ\u{b4d}ଡେଜ",
                "ବ\u{b4d}ୟ\u{b3e}ଣ\u{b4d}ଡେଜ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚਿਪਕਣ ਵਾਲੀ ਪ\u{a71}ਟੀ"),
            keywords: &["ਚਿਪਕਣ ਵਾਲੀ ਪ\u{a71}ਟੀ", "ਪ\u{a71}ਟੀ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Plásta"),
            keywords: &["Bándej", "Plásta"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("plaster"),
            keywords: &["opatrunek", "plaster"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("نښلېدونکې پټۍ"),
            keywords: &["نښلېدونکې پټۍ", "پټۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("atadura adesiva"),
            keywords: &["atadura adesiva", "curativo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("penso rápido"),
            keywords: &["penso", "penso rápido"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("leucoplast"),
            keywords: &["bandaj adeziv", "leucoplast"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–064"),
            keywords: &["E12–064"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("пластырь"),
            keywords: &["заклеить", "лечить", "пластырь", "порез", "рана"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("چمبڙندڙ پٽي"),
            keywords: &["پٽي", "چمبڙندڙ پٽي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඇලෙන වෙළ\u{dd4}ම\u{dca} පට\u{dd2}ය"),
            keywords: &[
                "ඇලෙන වෙළ\u{dd4}ම\u{dca} පට\u{dd2}ය",
                "වෙළ\u{dd4}ම\u{dca} පට\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("náplasť"),
            keywords: &["leukoplast", "náplasť", "obväz"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("samolepilni obliž"),
            keywords: &["hanzaplast", "rana", "samolepilni obliž"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("balastar jilicsan"),
            keywords: &["balastar", "balastar jilicsan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fashë ngjitëse"),
            keywords: &["fashë", "fashë ngjitëse"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("фластер"),
            keywords: &["завој", "фластер"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("flaster"),
            keywords: &["flaster", "zavoj"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("plåster"),
            keywords: &["bandage", "plåster"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("bendeji inayonata"),
            keywords: &["bendeji", "bendeji inayonata"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஒட\u{bcd}டக\u{bcd}கூடிய பேண\u{bcd}டேஜ\u{bcd}"),
            keywords: &[
                "ஒட\u{bcd}டக\u{bcd}கூடிய பேண\u{bcd}டேஜ\u{bcd}",
                "க\u{bbe}யம\u{bcd}",
                "பேண\u{bcd}டேஜ\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("అంటుకున\u{c47} బ\u{c4d}య\u{c3e}ండ\u{c4d}"),
            keywords: &[
                "అంటుకున\u{c47} బ\u{c4d}య\u{c3e}ండ\u{c4d}",
                "బ\u{c4d}య\u{c3e}ండ\u{c47}జ\u{c40}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("พลาสเตอร\u{e4c}ป\u{e34}ดแผล"),
            keywords: &["พลาสเตอร\u{e4c}", "พลาสเตอร\u{e4c}ป\u{e34}ดแผล"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýelmeşiji plastyr"),
            keywords: &["sarag", "ýelmeşiji plastyr"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("haʻihaʻi fakapipiki"),
            keywords: &["haʻihaʻi fakapipiki"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yara bandı"),
            keywords: &["bandaj", "bant", "yapışkanlı bandaj", "yara bandı"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("пластир"),
            keywords: &["бандаж", "клейка смужка", "наліпка", "пластир"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چپکنے والی پٹی"),
            keywords: &["پٹی", "چپکنے والی پٹی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("plastir"),
            keywords: &["bandaj", "plastir"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("băng dính"),
            keywords: &["băng dán y tế", "băng dính"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("膠布"),
            keywords: &["膠布"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("胶布"),
            keywords: &["胶布"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("创可贴"),
            keywords: &["OK绷", "伤口", "创可贴", "绷带", "胶布"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("OK 繃"),
            keywords: &["OK 繃", "繃帶"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("膠布"),
            keywords: &["繃帶", "膠布"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhandishi yokubopha"),
            keywords: &["ibhandishi", "ibhandishi yokubopha"],
        },
    ],
};
#[doc = "🩺"]
pub const STETHOSCOPE: crate::Emoji = crate::Emoji {
    glyph: "🩺",
    codepoint: "1FA7A",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "stethoscope",
    group: "Objects",
    subgroup: "medical",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("stetoskoop"),
            keywords: &["dokter", "hart", "medisyne", "stetoskoop"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ማዳመጫ"),
            keywords: &["ህክምና", "ልብ", "ማዳመጫ", "ዶክተር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سماعة طبيب"),
            keywords: &["دكتور", "سماعة طبيب", "طب", "طبيب", "قلب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ষ\u{9cd}টেথ’চক’প"),
            keywords: &[
                "ঔষধ",
                "চিকিৎসক",
                "ষ\u{9cd}টেথ’চক’প",
                "হ\u{9c3}দযন\u{9cd}ত\u{9cd}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("stetoskop"),
            keywords: &["doktor", "stetoskop", "tibb", "ürək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("стэтаскоп"),
            keywords: &["доктар", "медыцына", "стэтаскоп", "сэрца"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("стетоскоп"),
            keywords: &["лекар", "медицина", "стетоскоп", "сърце"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9cd}টেথোস\u{9cd}কোপ"),
            keywords: &[
                "ঔষধ",
                "ড\u{9be}ক\u{9cd}ত\u{9be}র",
                "স\u{9cd}টেথোস\u{9cd}কোপ",
                "হ\u{9be}র\u{9cd}ট",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("stetoskop"),
            keywords: &["doktor", "medisinerezh", "mezegiezh", "stetoskop"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("stetoskop"),
            keywords: &["doktor", "medicina", "srce", "stetoskop"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("estetoscopi"),
            keywords: &["cor", "doctor", "estetoscopi", "medicina"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎾᏫ ᎠᏛᏓᏍᏗ"),
            keywords: &["ᎠᎦᎾᎦᏘ", "ᎤᎾᏫ", "ᎤᎾᏫ ᎠᏛᏓᏍᏗ", "ᏅᏬᏘ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("stetoskop"),
            keywords: &[
                "doktor",
                "lékař",
                "lékařství",
                "medicína",
                "srdce",
                "stetoskop",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("stethosgop"),
            keywords: &["calon", "meddyg", "meddyginiaeth", "stethosgop"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("stetoskop"),
            keywords: &["doktor", "hjerte", "læge", "medicin", "stetoskop"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Stethoskop"),
            keywords: &["Arzt", "Herz", "Medizin", "Stethoskop"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("στηθοσκόπιο"),
            keywords: &["γιατρός", "καρδιά", "στηθοσκόπιο", "φάρμακο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("stethoscope"),
            keywords: &["doctor", "heart", "medicine", "stethoscope"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("estetoscopio"),
            keywords: &[
                "corazón",
                "doctor",
                "estetoscopio",
                "fonendoscopio",
                "latido",
                "medicina",
                "médico",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "corazón",
                "doctor",
                "estetoscopio",
                "fonendoscopio",
                "latido",
                "medicina",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("stetoskoop"),
            keywords: &["arst", "kuuldetoru", "meditsiin", "stetoskoop", "süda"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("estetoskopioa"),
            keywords: &["bihotz", "estetoskopioa", "mediku", "medikuntza"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("گوشی پزشکی"),
            keywords: &["دارو", "دکتر", "قلب", "پزشک", "گوشی پزشکی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("stetoskooppi"),
            keywords: &["kuuntelu", "lääkäri", "stetoskooppi", "sydän"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("stethoscope"),
            keywords: &["doktor", "medisina", "puso", "stethoscope"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("stetoskop"),
            keywords: &["lurt", "læknalurt", "læknapípa", "stetoskop"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("stéthoscope"),
            keywords: &["cœur", "docteur", "médecine", "poumons", "stéthoscope"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("steiteascóp"),
            keywords: &["croí", "doctúir", "leigheas", "steiteascóp"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("steatasgop"),
            keywords: &[
                "cridhe",
                "dotair",
                "leigheas",
                "lighiche",
                "steatasgop",
                "steiteasgop",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("estetoscopio"),
            keywords: &["corazón", "estetoscopio", "fonendoscopio", "medicina"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}ટ\u{ac7}થોસ\u{acd}કોપ"),
            keywords: &[
                "ડૉક\u{acd}ટર",
                "દવા",
                "સ\u{acd}ટ\u{ac7}થોસ\u{acd}કોપ",
                "હ\u{ac3}દય",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סטתוסקופ"),
            keywords: &["מ\u{5b7}ס\u{5b0}כ\u{5b5}\u{5bc}ת", "סטתוסקופ", "רופא"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{94d}ट\u{947}थोस\u{94d}कोप"),
            keywords: &[
                "चिकित\u{94d}सा",
                "डॉक\u{94d}टर",
                "ब\u{94d}लड प\u{94d}र\u{947}शर",
                "रक\u{94d}तचाप",
                "स\u{94d}ट\u{947}थोस\u{94d}कोप",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("stetoskop"),
            keywords: &["liječnik", "medicina", "srce", "stetoskop"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("sztetoszkóp"),
            keywords: &["gyógyszer", "orvos", "sztetoszkóp", "szív"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ստեթոսկոպ"),
            keywords: &["բժիշկ", "բժշկություն", "սիրտ", "ստեթոսկոպ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("stetoskop"),
            keywords: &["dokter", "jantung", "obat", "stetoskop"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hlustunarpípa"),
            keywords: &["hjarta", "hlustunarpípa", "læknir", "læknisfræði"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("stetoscopio"),
            keywords: &[
                "cardiologo",
                "dottore",
                "fonendoscopio",
                "medico",
                "stetoscopio",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("聴診器"),
            keywords: &["医者", "心臓", "病気", "聴診器"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("stetoskop"),
            keywords: &["dhokter", "jantung", "obat", "stetoskop"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ფონენდოსკოპი"),
            keywords: &[
                "გული",
                "მედიცინა",
                "სტეთოსკოპი",
                "ფილტვები",
                "ფონენდოსკოპი",
                "წნევა",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("стетоскоп"),
            keywords: &["дәрігер", "жүрек", "медицина", "стетоскоп"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}តេត\u{17bc}"),
            keywords: &[
                "បេះដ\u{17bc}ង",
                "វេជ\u{17d2}ជបណ\u{17d2}ឌ\u{17b7}ត",
                "ស\u{17d2}តេត\u{17bc}",
                "ឱសថ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{ccd}ಟ\u{cc6}ತಸ\u{ccd}ಕೋಪ\u{ccd}"),
            keywords: &[
                "ಔಷಧ\u{cbf}",
                "ವೈದ\u{ccd}ಯರು",
                "ಸ\u{ccd}ಟ\u{cc6}ತಸ\u{ccd}ಕೋಪ\u{ccd}",
                "ಹೃದಯ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("청진기"),
            keywords: &["심박수", "의사", "청진기"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("स\u{94d}थ\u{947}थोस\u{94d}कोप"),
            keywords: &[
                "काळीज",
                "दोतोर",
                "वखदा\u{902}",
                "स\u{94d}थ\u{947}थोस\u{94d}कोप",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("стетоскоп"),
            keywords: &["дарыгер", "жүрөк", "медицина", "стетоскоп"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{eb9}\u{200b}ຟ\u{eb1}ງ\u{200b}ຂອງ\u{200b}ແພດ"),
            keywords: &[
                "ປ\u{eb4}\u{ec8}ນ\u{200b}ປ\u{ebb}ວ",
                "ຫ\u{eb9}\u{200b}ຟ\u{eb1}ງ\u{200b}ຂອງ\u{200b}ແພດ",
                "ຫ\u{ebb}ວ\u{200b}ໃຈ",
                "ຮ\u{eb1}ກ\u{200b}ສາ",
                "ແພດ",
                "ໝ\u{ecd}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("stetoskopas"),
            keywords: &["gydytojas", "medicina", "stetoskopas", "širdis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("stetoskops"),
            keywords: &["medicīna", "sirds", "stetoskops", "ārsts"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("стетоскоп"),
            keywords: &["доктор", "медицина", "срце", "стетоскоп"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d4d}റ\u{d4d}റെതസ\u{d4d}\u{200c}കോപ\u{d4d}പ\u{d4d}"),
            keywords: &[
                "ഡോക\u{d4d}\u{200c}ടർ",
                "മര\u{d41}ന\u{d4d}ന\u{d4d}",
                "സ\u{d4d}റ\u{d4d}റെതസ\u{d4d}\u{200c}കോപ\u{d4d}പ\u{d4d}",
                "ഹ\u{d43}ദയം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("чагнуур"),
            keywords: &["зүрх", "чагнуур", "эмнэлэг", "эмч"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{94d}ट\u{947}थोस\u{94d}कोप"),
            keywords: &[
                "औषध",
                "डॉक\u{94d}टर",
                "स\u{94d}ट\u{947}थोस\u{94d}कोप",
                "ह\u{943}दय",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("stetoskop"),
            keywords: &["doktor", "jantung", "perubatan", "stetoskop"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဆရာဝန\u{103a}သ\u{102f}\u{1036}း နားကြပ\u{103a}"),
            keywords: &[
                "ဆရာဝန\u{103a}",
                "ဆရာဝန\u{103a}သ\u{102f}\u{1036}း နားကြပ\u{103a}",
                "ဆေး",
                "န\u{103e}လ\u{102f}\u{1036}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("stetoskop"),
            keywords: &["hjerte", "lege", "medisin", "stetoskop"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}ट\u{947}थोस\u{94d}कोप"),
            keywords: &[
                "औषधी",
                "डाक\u{94d}टर",
                "स\u{94d}ट\u{947}थोस\u{94d}कोप",
                "ह\u{943}दय",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("ste\u{ad}tho\u{ad}scoop"),
            keywords: &["dokter", "geneeskunde", "hart", "ste\u{ad}tho\u{ad}scoop"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("stetoskop"),
            keywords: &["hjarte", "lege", "medisin", "stetoskop"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଷ\u{b4d}ଟେଥୋସ\u{b4d}କୋପ"),
            keywords: &[
                "ଔଷଧ",
                "ଡ\u{b3e}କ\u{b4d}ତର",
                "ଷ\u{b4d}ଟେଥୋସ\u{b4d}କୋପ",
                "ହ\u{b43}ଦୟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਟ\u{a47}ਥ\u{a4b}ਸਕ\u{a4b}ਪ"),
            keywords: &["ਡਾਕਟਰ", "ਦਵਾਈ", "ਦਿਲ", "ਸਟ\u{a47}ਥ\u{a4b}ਸਕ\u{a4b}ਪ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Stẹteskop"),
            keywords: &["Dọ\u{301}ktọ", "Hat", "Mẹ\u{301}dísin", "Stẹteskop"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("stetoskop"),
            keywords: &["lekarz", "medycyna", "serce", "stetoskop"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ستېتوسکوپ"),
            keywords: &["درمل", "زړه", "ستېتوسکوپ", "ډاکټر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("estetoscópio"),
            keywords: &["coração", "estetoscópio", "medicina", "médico"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("estetoscópio"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("stetoscop"),
            keywords: &["doctor", "inimă", "medicină", "stetoscop"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–065"),
            keywords: &["E12–065"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("стетоскоп"),
            keywords: &[
                "врач",
                "доктор",
                "инструмент",
                "сердце",
                "слушать",
                "стетоскоп",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اسٽيٿو اسڪوپ"),
            keywords: &["اسٽيٿو اسڪوپ", "دل", "دوا", "ڊاڪٽر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වෙද නළ\u{dcf}ව"),
            keywords: &["ඖෂධ", "දොස\u{dca}තර", "වෙද නළ\u{dcf}ව", "හදවත"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("stetoskop"),
            keywords: &[
                "doktor",
                "lekár",
                "lekárstvo",
                "medicína",
                "srdce",
                "stetoskop",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("stetoskop"),
            keywords: &[
                "medicina",
                "pljuča",
                "prsni koš",
                "srce",
                "stetoskop",
                "zdravnik",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qalabka wadnaha lagu dhageysto"),
            keywords: &[
                "daawo",
                "dhakhtar",
                "qalabka wadnaha lagu dhageysto",
                "wadne",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("stetoskop"),
            keywords: &["doktor", "ilaç", "stetoskop", "zemër"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("стетоскоп"),
            keywords: &["лекар", "медицина", "срце", "стетоскоп"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["стетоскоп"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("stetoskop"),
            keywords: &["lekar", "medicina", "srce", "stetoskop"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["stetoskop"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("stetoskop"),
            keywords: &["doktor", "hjärta", "medicin", "stetoskop"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("stetoskopu"),
            keywords: &["daktari", "dawa", "moyo", "stetoskopu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஸ\u{bcd}டெத\u{bbe}ஸ\u{bcd}கோப\u{bcd}"),
            keywords: &[
                "இதயத\u{bcd}துடிப\u{bcd}பு",
                "இதயம\u{bcd}",
                "மருத\u{bcd}துவம\u{bcd}",
                "மருத\u{bcd}துவர\u{bcd}",
                "ஸ\u{bcd}டெத\u{bbe}ஸ\u{bcd}கோப\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c4d}ట\u{c46}థస\u{c4d}క\u{c4b}ప\u{c4d}"),
            keywords: &[
                "గుండ\u{c46}",
                "మందులు",
                "వ\u{c48}ద\u{c4d}యులు",
                "స\u{c4d}ట\u{c46}థస\u{c4d}క\u{c4b}ప\u{c4d}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เคร\u{e37}\u{e48}องฟ\u{e31}งตรวจ"),
            keywords: &[
                "ยา",
                "หมอ",
                "ห\u{e31}วใจ",
                "เคร\u{e37}\u{e48}องฟ\u{e31}งตรวจ",
                "แพทย\u{e4c}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("stetoskop"),
            keywords: &["lukman", "lukmançylyk", "stetoskop", "ýürek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻa fakaongo"),
            keywords: &["meʻa fakaongo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("stetoskop"),
            keywords: &["doktor", "kalp", "stetoskop", "tıp"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("стетоскоп"),
            keywords: &["вислухувати серце", "лікар", "медицина", "стетоскоп"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سٹیتھو سکوپ"),
            keywords: &["دل", "دوا", "سٹیتھو سکوپ", "ڈاکٹر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("stetoskop"),
            keywords: &["doktor", "shifokor", "stetoskop", "tibbiyot", "yurak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ống nghe"),
            keywords: &["bác sĩ", "tim", "y tế", "ống nghe"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("聽筒"),
            keywords: &["心臟", "聽筒", "醫生", "醫療"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("听筒"),
            keywords: &["医生", "医疗", "听筒", "心脏"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("听诊器"),
            keywords: &["医生", "医疗", "听诊器", "心脏", "心跳", "诊断"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("聽診器"),
            keywords: &["心跳", "聽診器", "藥", "醫生"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-slethoscope"),
            keywords: &["i-slethoscope", "inhliziyo imithi", "udokotela"],
        },
    ],
};
