#[doc = "🔒"]
pub const LOCKED: crate::Emoji = crate::Emoji {
    glyph: "🔒",
    codepoint: "1F512",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "locked",
    group: "Objects",
    subgroup: "lock",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("slot"),
            keywords: &["gesluit", "slot", "toe"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መሸጎጫ"),
            keywords: &["መሸጎጫ", "የተዘጋ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قفل"),
            keywords: &["قفل", "مغلق"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("তল\u{9be}বদ\u{9cd}ধ"),
            keywords: &["তল\u{9be}বদ\u{9cd}ধ", "বন\u{9cd}ধ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kilid"),
            keywords: &["bağlı", "kilid"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("замкнёны замок"),
            keywords: &["заблакіравана", "закрыта", "замкнёны замок", "замок"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("катинар"),
            keywords: &["затворен", "катинар"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ত\u{9be}ল\u{9be} বন\u{9cd}ধ"),
            keywords: &["ত\u{9be}ল\u{9be} বন\u{9cd}ধ", "বন\u{9cd}ধ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kadranas serr"),
            keywords: &["kadranas", "serr"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("katanac"),
            keywords: &["katanac", "zaključano"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cadenat tancat"),
            keywords: &["cadenat", "tancar", "tancat"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏍᏓᏱ ᎠᏍᏍᎭ"),
            keywords: &["ᎠᏍᏚᎭ", "ᏍᏓᏱ ᎠᏍᏍᎭ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zamknutý zámek"),
            keywords: &[
                "visací",
                "zamknuto",
                "zamknutý zámek",
                "zamčeno",
                "zamčený",
                "zavřeno",
                "zavřený",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("clô"),
            keywords: &["ar gau", "clô", "dan glo"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("lukket hængelås"),
            keywords: &["lukket hængelås", "låst"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("geschlossenes Schloss"),
            keywords: &[
                "Datenschutz",
                "Schloss",
                "Sicherheit",
                "geschlossen",
                "geschlossenes Schloss",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κλειδωμένο"),
            keywords: &["κλειδωμένο", "κλειστό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("locked"),
            keywords: &["closed", "locked"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("candado cerrado"),
            keywords: &["candado", "cerrado", "cerrar"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["candado", "cerrado"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("lukk"),
            keywords: &["lukk", "lukus", "suletud"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("giltzarrapoa"),
            keywords: &["giltzarrapoa", "itxita"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قفل"),
            keywords: &["بسته", "قفل"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("lukko"),
            keywords: &["kiinni", "lukko"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kandado"),
            keywords: &["kandado", "naka-lock", "nakasara", "sarado"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("læst heingilás"),
            keywords: &["afturlati", "heingilás", "lás", "læst", "stongt"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cadenas fermé"),
            keywords: &["cadenas", "cadenas fermé", "verrouillé"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["cadenas", "fermé", "verrouiller", "verrouillé"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("glasáilte"),
            keywords: &["glas", "glasáilte"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("glaiste"),
            keywords: &["dùinte", "glaiste"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cadeado"),
            keywords: &["cadeado", "pechado"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("તાળ\u{ac1}\u{a82}"),
            keywords: &["તાળ\u{ac1}\u{a82}", "બ\u{a82}ધ તાળ\u{ac1}\u{a82}"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("a kulle"),
            keywords: &["a kulle", "rufaffe"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מנעול"),
            keywords: &["לסגור", "מנעול", "סגור"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ब\u{902}द ताला"),
            keywords: &["ताला", "ब\u{902}द ताला"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zaključano"),
            keywords: &["zaključano", "zatvoreno"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("lakat"),
            keywords: &["lakat", "zárt", "zárva"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կողպեք"),
            keywords: &["կողպեք", "փակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("gembok"),
            keywords: &["gembok", "tutup"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akpọchiri"),
            keywords: &["akpọchiri", "mechiri"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("lás"),
            keywords: &["lokaður lás", "lás"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("lucchetto chiuso"),
            keywords: &["chiuso", "lucchetto"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("閉じた錠"),
            keywords: &["ロック", "施錠", "錠", "鍵", "閉じた錠"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("gembok ngunci"),
            keywords: &["gembok ngunci", "nggembok", "nutup"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("საკეტი"),
            keywords: &["დახურული", "საკეტი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("yeskweṛ"),
            keywords: &["yeskweṛ"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("құлып"),
            keywords: &["жабық", "құлып"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("hængelås"),
            keywords: &["hængelås", "låst"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("មេសោជាប\u{17cb}"),
            keywords: &["មេសោ", "មេសោជាប\u{17cb}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಲಾಕ\u{ccd}"),
            keywords: &["ಮುಚ\u{ccd}ಚ\u{cbf}ದ ಲಾಕ\u{ccd}", "ಲಾಕ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("자물쇠"),
            keywords: &["락", "자물쇠", "잠금"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("लॉक क\u{947}ल\u{94d}ल\u{947}\u{902}"),
            keywords: &[
                "धा\u{902}पिल\u{94d}ल\u{947}\u{902}",
                "लॉक क\u{947}ल\u{94d}ल\u{947}\u{902}",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кулпу"),
            keywords: &["жабык", "кулпу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("zouent Schlass"),
            keywords: &["zou", "zouent Schlass"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec8}ວຍກະແຈ"),
            keywords: &["ກະແຈ", "ປ\u{eb4}ດ", "ລ\u{eb1}ອກ", "ໜ\u{ec8}ວຍກະແຈ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("spyna"),
            keywords: &["spyna", "uždaryta"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("slēdzene"),
            keywords: &["aizslēgts", "slēdzene"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kua maukati"),
            keywords: &["kua kati", "kua maukati"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("заклучен катанец"),
            keywords: &["заклучен", "заклучен катанец"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d42}ട\u{d4d}ട\u{d4d}"),
            keywords: &["പ\u{d42}ട\u{d4d}ട\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цоожтой"),
            keywords: &["хаалттай", "цоожтой"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("क\u{941}ल\u{942}प"),
            keywords: &["क\u{941}ल\u{942}प", "ब\u{902}द"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bermangga"),
            keywords: &["berkunci", "bermangga"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("imsakkar"),
            keywords: &["imsakkar", "magħluqa"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပ\u{102d}တ\u{103a}နေသော သော\u{1037}ခလောက\u{103a}"),
            keywords: &[
                "ပ\u{102d}တ\u{103a}ထား",
                "ပ\u{102d}တ\u{103a}နေသော သော\u{1037}ခလောက\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("låst"),
            keywords: &["låst"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("लक"),
            keywords: &["बन\u{94d}द गर\u{947}को", "लक"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("slot"),
            keywords: &["gesloten slot", "slot"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("låst"),
            keywords: &["låst"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଲକ\u{b4d}\u{200c}ଯ\u{b41}କ\u{b4d}ତ"),
            keywords: &[
                "ବନ\u{b4d}ଦ ହୋଇଛ\u{b3f}",
                "ଲକ\u{b4d}\u{200c}ଯ\u{b41}କ\u{b4d}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲਾਕ"),
            keywords: &["ਬ\u{a70}ਦ", "ਲਾਕ", "ਲ\u{a4c}ਕ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مقفل"),
            keywords: &["بند کیتا", "مقفل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Lọkd"),
            keywords: &["Klozd", "Lọkd"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zamknięta kłódka"),
            keywords: &["kłódka", "zablokowane", "zamknięta kłódka", "zamknięte"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کلپ شوی"),
            keywords: &["تړل شوی", "کلپ شوی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cadeado"),
            keywords: &["cadeado", "fechado", "trancado"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["cadeado", "fechado", "trancado"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("lacăt închis"),
            keywords: &["blocat", "lacăt închis", "închis"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-718"),
            keywords: &["E10-718"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("закрытый замок"),
            keywords: &["закрытый", "замок", "затвор"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("irafunze"),
            keywords: &["irafunze", "rifunze"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("لاڪ ٿيل"),
            keywords: &["بند", "لاڪ ٿيل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අග\u{dd4}ල"),
            keywords: &["අග\u{dd4}ල", "වැස\u{dd6}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zatvorená zámka"),
            keywords: &["zamknuté", "zatvorená zámka", "zatvorené", "zámka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ključavnica"),
            keywords: &["ključavnica", "zaklenjena ključavnica"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qufulan"),
            keywords: &["qufulan", "xidhadSagittarius"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kyç"),
            keywords: &["i mbyllur", "kyç"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("катанац"),
            keywords: &["зaтвoрeнo", "катанац"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("katanac"),
            keywords: &["katanac", "zatvoreno"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("låst lås"),
            keywords: &["lås", "låst lås", "stängt lås"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kufuli"),
            keywords: &["fungwa", "kufuli"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பூட\u{bcd}டு"),
            keywords: &["பூட\u{bcd}டியது", "பூட\u{bcd}டு"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వ\u{c47}స\u{c3f} ఉన\u{c4d}న త\u{c3e}ళం"),
            keywords: &[
                "త\u{c3e}ళము",
                "మూస\u{c3f}వ\u{c47}స\u{c3f}న త\u{c3e}ళము",
                "రక\u{c4d}ష\u{c3f}ంచబడ\u{c3f}ంద\u{c3f}",
                "ల\u{c3e}క\u{c4d} చ\u{c47}యబడ\u{c3f}ంద\u{c3f}",
                "వ\u{c47}స\u{c3f} ఉన\u{c4d}న త\u{c3e}ళం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("қулфшуда"),
            keywords: &["пӯшида", "қулфшуда"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e47}อคป\u{e34}ด"),
            keywords: &["ป\u{e34}ด", "ล\u{e47}อค", "ล\u{e47}อคป\u{e34}ด"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gulply"),
            keywords: &["gulply", "ýapyk"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("loka"),
            keywords: &["loka"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kilit"),
            keywords: &["kapalı kilit", "kilit"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قۇلۇپلاق"),
            keywords: &["قۇلۇپلاق", "يېپىق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("замкнений замок"),
            keywords: &["закрито", "замкнений замок"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("لاک"),
            keywords: &["بند", "لاک"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qulflangan"),
            keywords: &["qulflangan", "yopiq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("khóa"),
            keywords: &["khóa", "đóng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("tëj nañu ko"),
            keywords: &["tëj nañu ko", "ub nañu ko"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("itshixiwe"),
            keywords: &["itshixiwe", "ivaliwe"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ti tìí"),
            keywords: &["pípadé", "ti tìí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("上鎖"),
            keywords: &["上鎖", "關閉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("上锁"),
            keywords: &["上锁", "关闭"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("合上的锁"),
            keywords: &["上锁", "合上的锁", "锁", "锁住", "锁定"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("上鎖"),
            keywords: &["上鎖", "鎖"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("鎖"),
            keywords: &["鎖", "鎖上 ｜上鎖"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ingidi"),
            keywords: &["ingidi", "kuvaliwe"],
        },
    ],
};
#[doc = "🔓"]
pub const UNLOCKED: crate::Emoji = crate::Emoji {
    glyph: "🔓",
    codepoint: "1F513",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "unlocked",
    group: "Objects",
    subgroup: "lock",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("oop slot"),
            keywords: &["ontsluit", "oop", "slot"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ክፍት መሸጎጫ"),
            keywords: &["መክፈት", "ቁልፍ", "ክፍት", "ክፍት መሸጎጫ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قفل مفتوح"),
            keywords: &["فتح", "قفل", "قفل مفتوح"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("খোল\u{9be} তল\u{9be}"),
            keywords: &[
                "খোল\u{9be}",
                "খোল\u{9be} তল\u{9be}",
                "তল\u{9be} খোল",
                "তল\u{9be}বদ\u{9cd}ধ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("açıq kilid"),
            keywords: &["açıq", "kilid", "kilidi açmaq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("адамкнёны замок"),
            keywords: &["адамкнёны замок", "адкрыта", "замок", "разблакіравана"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Отворен катинар"),
            keywords: &["Отворен катинар", "катинар", "отворен", "отключен"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("খোল\u{9be} ত\u{9be}ল\u{9be}"),
            keywords: &["খোল\u{9be}", "ত\u{9be}ল\u{9be}"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kadranas digor"),
            keywords: &["digor", "kadranas"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("otključan katanac"),
            keywords: &["otključan katanac", "otključano"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cadenat obert"),
            keywords: &["cadenat", "obert", "obrir"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏙᎠᏍᏚ"),
            keywords: &["ᎠᏍᏚᎢᏓ", "ᏓᎦᏏ", "ᏙᎠᏍᏚ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("odemknutý zámek"),
            keywords: &[
                "odemknuto",
                "odemknutý zámek",
                "odemčeno",
                "odemčený",
                "otevřeno",
                "otevřený",
                "visací",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("clô agored"),
            keywords: &["agor", "cloi", "clô agored", "datgloi"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("åben hængelås"),
            keywords: &["låst op", "åben hængelås", "åben lås"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("offenes Schloss"),
            keywords: &["Schloss", "nicht gesichert", "offen", "offenes Schloss"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ξεκλείδωτο"),
            keywords: &["ανοιχτό", "κλείδωμα", "κλειδαριά", "ξεκλείδωτο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("unlocked"),
            keywords: &["lock", "open", "unlock", "unlocked"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("candado abierto"),
            keywords: &["abierto", "abrir", "candado"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["abierto", "candado"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("avatud lukk"),
            keywords: &["avatud", "lukk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("giltzarrapo irekia"),
            keywords: &["giltzarrapo", "giltzarrapo irekia", "ireki", "irekita"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قفل باز"),
            keywords: &["باز", "قفل"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("lukko auki"),
            keywords: &["auki", "avata", "lukko"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nakabukas na kandado"),
            keywords: &[
                "hindi naka-lock",
                "kandado",
                "nakabukas",
                "nakabukas na kandado",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("opi heingilás"),
            keywords: &["heingilás", "lás", "opi", "ólæst"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cadenas ouvert"),
            keywords: &["cadenas", "cadenas ouvert"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["cadenas", "déverrouiller", "déverrouillé", "ouvert"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("neamhghlasáilte"),
            keywords: &["glas oscailte", "neamhghlasáilte"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("neo-ghlaiste"),
            keywords: &["fosgail", "fosgailte", "glas", "neo-ghlais", "neo-ghlaiste"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cadeado aberto"),
            keywords: &["aberto", "cadeado", "desbloquear"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ખ\u{ac1}લ\u{acd}લ\u{ac1}\u{a82} તાળ\u{ac1}\u{a82}"),
            keywords: &[
                "ખ\u{ac1}લ\u{acd}લ\u{ac1}\u{a82} તાળ\u{ac1}\u{a82}",
                "તાળ\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("a buɗe"),
            keywords: &["a buɗe", "a kulle", "buɗe"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מנעול פתוח"),
            keywords: &["לסגור", "מנעול", "פתוח"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ख\u{941}ला ताला"),
            keywords: &["ख\u{941}ला ताला", "ताला"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("otključano"),
            keywords: &["lokot", "otključano", "otvoreno"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nyitott lakat"),
            keywords: &["kinyitás", "lakat", "nyitott lakat", "nyitva"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բաց կողպեք"),
            keywords: &["ապակողպել", "բաց", "կողպեք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("gembok terbuka"),
            keywords: &["buka", "gembok", "gembok terbuka", "tidak digembok"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akpọghere"),
            keywords: &["akpọghere", "kpọchie", "kpọghee", "mepee"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("opinn lás"),
            keywords: &["lás", "læsa", "opinn lás", "opna", "taka úr lás"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("lucchetto aperto"),
            keywords: &["aperto", "lucchetto"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("開いた錠"),
            keywords: &["ロック", "解錠", "錠", "鍵", "開いた錠"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("gembok mbukak"),
            keywords: &["gembok mbukak", "kunci", "nggembok"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ღია საკეტი"),
            keywords: &["გახსნა", "საკეტი", "ღია"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("yeldi"),
            keywords: &["yeldi"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ашық құлып"),
            keywords: &["ашық", "ашық құлып", "құлпын ашу", "құлыптау"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("åben hængelås"),
            keywords: &["åben hængelås", "åben lås"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("មេសោដោះ"),
            keywords: &["ដោះសោ", "មេសោ", "មេសោដោះ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ತ\u{cc6}ರ\u{cc6}ದ ಲಾಕ\u{ccd}"),
            keywords: &["ತ\u{cc6}ರ\u{cc6}ದ ಲಾಕ\u{ccd}", "ಲಾಕ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("열린 자물쇠"),
            keywords: &["락", "열린 자물쇠", "자물쇠", "잠금풀림"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("लॉक कर\u{942}\u{902}क नाशिल\u{94d}ल\u{947}\u{902}"),
            keywords: &[
                "अनलॉक",
                "अनलॉक\u{94d}ड",
                "उकत\u{947}\u{902}",
                "नशीब",
                "लॉक कर\u{942}\u{902}क नाशिल\u{94d}ल\u{947}\u{902}",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ачык кулпу"),
            keywords: &["ачык", "кулпу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("oppent Schlass"),
            keywords: &["Schlass", "entspären", "oppen", "oppent Schlass", "zou"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec8}ວຍກະແຈເປ\u{eb5}ດຢ\u{eb9}\u{ec8}"),
            keywords: &[
                "ກະແຈ",
                "ເປ\u{eb5}ດ",
                "ໜ\u{ec8}ວຍກະແຈເປ\u{eb5}ດຢ\u{eb9}\u{ec8}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("atrakinta spyna"),
            keywords: &["atidaryta", "atrakinta", "spyna"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("atvērta slēdzene"),
            keywords: &[
                "atslēgta",
                "atvērta slēdzene",
                "piekaramā atslēga",
                "slēdzene",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("wetemaukati"),
            keywords: &["maukati", "wetemaukati", "whakatuwhera"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("отклучен катанец"),
            keywords: &["катанец", "отклучен"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ത\u{d41}റന\u{d4d}ന പ\u{d42}ട\u{d4d}ട\u{d4d}"),
            keywords: &[
                "ത\u{d41}റന\u{d4d}ന പ\u{d42}ട\u{d4d}ട\u{d4d}",
                "ത\u{d41}റന\u{d4d}ന ലോക\u{d4d}ക\u{d4d}",
                "ലോക\u{d4d}ക\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("онгорхой цоож"),
            keywords: &[
                "нээлттэй",
                "онгорхой цоож",
                "түгжээ тайлах",
                "түгжээгүй",
                "түгжээтэй",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ख\u{941}ल\u{947} क\u{941}ल\u{942}प"),
            keywords: &[
                "क\u{941}ल\u{942}प",
                "ख\u{941}ल\u{947}",
                "ख\u{941}ल\u{947} करा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("mangga terbuka"),
            keywords: &["buka kunci", "kunci", "mangga terbuka", "terbuka"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("mhux imsakkar"),
            keywords: &["iftaħ", "mhux imsakkar", "sakkar"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပ\u{103d}င\u{1037}\u{103a}နေသော သော\u{1037}ခလောက\u{103a}"),
            keywords: &[
                "ပ\u{103d}င\u{1037}\u{103a}နေသည\u{103a}",
                "ပ\u{103d}င\u{1037}\u{103a}နေသော သော\u{1037}ခလောက\u{103a}",
                "ဖ\u{103d}င\u{1037}\u{103a}ထားသော သော\u{1037}ခလောက\u{103a}",
                "သော\u{1037}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("ulåst"),
            keywords: &["hengelås", "lås", "ulåst", "åpen"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("लक खोलिएको"),
            keywords: &["ख\u{941}ला", "लक", "लक खोलिएको"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("geopend hangslot"),
            keywords: &["geopend", "geopend hangslot", "open", "openen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("ulåst"),
            keywords: &["hengjelås", "lås", "open", "ulåst"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ତ\u{b3e}ଲ\u{b3e} ପଡ\u{b3c}\u{b3f}ନ\u{b3e}ହ\u{b3f}\u{b01}"),
            keywords: &[
                "ତ\u{b3e}ଲ\u{b3e} ପଡ\u{b3c}\u{b3f}ନ\u{b3e}ହ\u{b3f}\u{b01}",
                "ଲକ\u{b4d}",
                "ଲକ\u{b4d} ଖୋଲ\u{b3f}ବ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਖ\u{a41}\u{a71}ਲ\u{a4d}ਹਿਆ ਲਾਕ"),
            keywords: &[
                "ਅਣਲਾਕ",
                "ਅਣਲ\u{a4c}ਕ",
                "ਖ\u{a41}\u{a71}ਲ\u{a4d}ਹਾ ਲਾਕ",
                "ਖ\u{a41}\u{a71}ਲ\u{a4d}ਹਿਆ ਲਾਕ",
                "ਲਾਕ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("غير مقفل شدہ"),
            keywords: &["ان لاک", "تالا", "غير مقفل شدہ", "ک\u{64f}ھلا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ọnlọkd"),
            keywords: &["Lọk", "Ópun", "Ọnlọk", "Ọnlọkd"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("otwarta kłódka"),
            keywords: &["kłódka", "odblokować", "otwarta"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("خلاص شوی"),
            keywords: &["خلاص شوی", "خلاصول", "قفل", "کلپ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cadeado aberto"),
            keywords: &["aberto", "cadeado", "destrancado"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["aberto", "cadeado"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("lacăt deschis"),
            keywords: &["deblocat", "deschis", "lacăt"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-719"),
            keywords: &["E10-719"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("открытый замок"),
            keywords: &["замок", "затвор", "открытый"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("birafunguye"),
            keywords: &["birafunguye", "gifunguye", "gufunga", "gufungura"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("کليل"),
            keywords: &["بند", "کليل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඇර\u{dd4}ණ අග\u{dd4}ල"),
            keywords: &[
                "අග\u{dd4}ල",
                "අග\u{dd4}ළ\u{dd4} නොදැම\u{dd6}",
                "ඇර\u{dd4}ණ අග\u{dd4}ල",
                "ව\u{dd2}වෘත",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("otvorená zámka"),
            keywords: &["odomknuté", "otvorená zámka", "otvorené", "zámka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("odklenjena ključavnica"),
            keywords: &[
                "ključavnica",
                "odkleniti",
                "odklenjena ključavnica",
                "odprto",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("furan"),
            keywords: &["fur", "furan", "quful"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kyç i hapur"),
            keywords: &["hap", "i hapur", "i shkyçur", "kyç i hapur"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("отворен катанац"),
            keywords: &["oтвoрeнo", "oткључaнo", "катанац", "отворен катанац"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("откључано"),
            keywords: &["откључано"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("otvoren katanac"),
            keywords: &["katanac", "otključano", "otvoren katanac", "otvoreno"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("otključano"),
            keywords: &["otključano"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("öppet lås"),
            keywords: &["lås", "olåst", "öppet lås"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kufuli iliyofunguliwa"),
            keywords: &["funga", "fungua", "funguliwa", "kufuli iliyofunguliwa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("திறந\u{bcd}த பூட\u{bcd}டு"),
            keywords: &[
                "திறந\u{bcd}த பூட\u{bcd}டு",
                "திறந\u{bcd}தது",
                "பூட\u{bcd}ட\u{bbe}தது",
                "பூட\u{bcd}டு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("త\u{c46}ర\u{c3f}చ\u{c3f} ఉన\u{c4d}న త\u{c3e}ళం"),
            keywords: &[
                "త\u{c46}ర\u{c3f}చ\u{c3f} ఉన\u{c4d}న త\u{c3e}ళం",
                "త\u{c46}ర\u{c3f}చ\u{c3f}న త\u{c3e}ళము",
                "రక\u{c4d}ష\u{c3f}ంచబడల\u{c47}దు",
                "ల\u{c3e}క\u{c4d} త\u{c40}స\u{c3f}వ\u{c47}యబడ\u{c3f}ంద\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("кушодашуда"),
            keywords: &["кушода", "кушодан", "кушодашуда", "қулф"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e47}อคเป\u{e34}ด"),
            keywords: &[
                "ปลดล\u{e47}อค",
                "ล\u{e47}อค",
                "ล\u{e47}อคเป\u{e34}ด",
                "เป\u{e34}ด",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gulpy açyk"),
            keywords: &["açyk", "gulp", "gulpy açmak", "gulpy açyk"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("taʻeloka"),
            keywords: &["taʻeloka"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("açık kilit"),
            keywords: &["açık", "kilidini açma", "kilit"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قۇلۇپسىز"),
            keywords: &["ئېچىش", "قۇلۇپ", "قۇلۇپسىز"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("відімкнений замок"),
            keywords: &["відрити", "відімкнений замок", "відімкнути", "замок"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کھلا لاک"),
            keywords: &["لاک", "کھلا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ochiq qulf"),
            keywords: &["ochiq", "qulf", "qulflanmagan"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mở khóa"),
            keywords: &["khóa", "mở"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("tijji nañu ko"),
            keywords: &["caabi", "tijji", "tijji nañu ko", "ubbi"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ayitshixwanga"),
            keywords: &["ayitshixwanga", "ivulekile", "tshixa", "vula"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ti síi"),
            keywords: &["ti síi", "tì", "ṣí", "ṣíṣí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("解鎖"),
            keywords: &["解鎖", "鎖", "開"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("解锁"),
            keywords: &["开", "解锁", "锁"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("打开的锁"),
            keywords: &["取消锁定", "开锁", "打开的锁", "解锁", "锁"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("開鎖"),
            keywords: &["開鎖"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["打開", "解鎖", "鎖", "開鎖"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ingidi evuliwe"),
            keywords: &["ingidi", "ingidi evuliwe", "qaqa", "vula"],
        },
    ],
};
#[doc = "🔏"]
pub const LOCKED_WITH_PEN: crate::Emoji = crate::Emoji {
    glyph: "🔏",
    codepoint: "1F50F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "locked with pen",
    group: "Objects",
    subgroup: "lock",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("slot met pen"),
            keywords: &["ink", "pen", "privaat", "slot", "slot met pen"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መሸጎጫ ከብዕር ጋር"),
            keywords: &["መሸጎጫ ከብዕር ጋር", "ቀለም", "ቁልፍ", "እስኪብርቶ", "የብዕር ጫፍ", "ግላዊነት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قفل مغلق بقلم"),
            keywords: &["خصوصية", "قفل عليه قلم حبر", "قفل مغلق بقلم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কলমসহ তল\u{9be}বদ\u{9cd}ধ"),
            keywords: &[
                "কলম",
                "কলমসহ তল\u{9be}বদ\u{9cd}ধ",
                "কলমৰ নিব",
                "গোপনীয\u{9bc}ত\u{9be}",
                "চিয\u{9bc}\u{9be}\u{981}হি",
                "তল\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qələmli kilid"),
            keywords: &[
                "kilid",
                "mürəkkəb",
                "məxfi",
                "qələm",
                "qələm ucu",
                "qələmli kilid",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("замкнёны замок з пяром"),
            keywords: &[
                "бяспека",
                "замкнёны замок з пяром",
                "замок",
                "канфідэнцыяльнасць",
                "пяро",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Катинар с писалка"),
            keywords: &[
                "Катинар с писалка",
                "катинар",
                "писалка",
                "писец",
                "поверителност",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("পেনের স\u{9be}থে ত\u{9be}ল\u{9be}"),
            keywords: &[
                "কলম",
                "ক\u{9be}লি",
                "গোপনীয\u{9bc}ত\u{9be}",
                "ত\u{9be}ল\u{9be}",
                "নিব",
                "পেনের স\u{9be}থে ত\u{9be}ল\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kadranas serr gant stilo"),
            keywords: &["kadranas", "kadranas serr gant stilo", "serr", "stilo"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("katanac sa olovkom"),
            keywords: &[
                "katanac",
                "katanac s olovkom",
                "katanac sa olovkom",
                "naliv pero",
                "privatnost",
                "tinta",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cadenat amb ploma"),
            keywords: &[
                "cadenat amb ploma",
                "cadenat tancat",
                "ploma",
                "privacitat",
                "privadesa",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏍᏓᏱ ᎠᏍᏚᎲᎢ ᎫᏍᏈᏛᏗ ᎬᏗ"),
            keywords: &[
                "ᎤᏕᎵᏓ",
                "ᎦᏐᎾᎳᏛᎢ",
                "ᎪᏪᎶᏗ ᎦᏁᎯ",
                "ᏍᏓᏱ ᎠᏍᏚᎲᎢ ᎫᏍᏈᏛᏗ ᎬᏗ",
                "ᏗᎪᏪᎶᏗ",
                "ᏫᎪᏍᏓᏴ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zamknutý zámek s plnicím perem"),
            keywords: &[
                "inkoust",
                "pero",
                "soukromí",
                "soukromý",
                "tajné",
                "utajení",
                "zamknutý zámek s plnicím perem",
                "zámek",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("clô ac ysgrifbin"),
            keywords: &["cloi", "clô ac ysgrifbin", "inc", "nib", "ysgrifbin"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("lukket hængelås med pen"),
            keywords: &[
                "fyldepen",
                "lukket hængelås med pen",
                "lås med fyldepen",
                "privat",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schloss mit Füller"),
            keywords: &["Datenschutz", "Schloss mit Füller", "Sicherheit", "privat"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κλειδαριά με πένα"),
            keywords: &[
                "απόρρητο",
                "κλειδαριά",
                "κλειδαριά με πένα",
                "μελάνι",
                "πένα",
                "στιλό",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("locked with pen"),
            keywords: &["ink", "lock", "locked with pen", "nib", "pen", "privacy"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("candado con pluma estilográfica"),
            keywords: &[
                "candado",
                "candado con pluma estilográfica",
                "cerrado",
                "estilográfica",
                "pluma",
                "privacidad",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("candado y lapicera"),
            keywords: &["candado", "candado y lapicera", "lapicera", "pluma"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("candado cerrado con plumilla"),
            keywords: &[
                "candado cerrado con plumilla",
                "cerrado",
                "pluma",
                "plumilla",
                "privacidad",
                "punta",
                "tinta",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("lukk ja pastakas"),
            keywords: &[
                "lukk",
                "lukk ja pastakas",
                "lukk ja sulepea",
                "privaatsus",
                "sulepea",
                "tint",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("giltzarrapoa lumarekin"),
            keywords: &[
                "giltzarrapo",
                "giltzarrapoa lumarekin",
                "luma",
                "pribatutasun",
                "tinta",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قفل با قلم"),
            keywords: &["جوهر", "حریم خصوصی", "قفل", "قفل با قلم", "قلم"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("lukko ja kynä"),
            keywords: &[
                "kirjoittaa",
                "lukko",
                "lukko ja kynä",
                "mustekynä",
                "suojaus",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kandado na may panulat"),
            keywords: &[
                "kandado",
                "kandado na may panulat",
                "naka-lock",
                "panulat",
                "pen",
                "pribado",
                "sarado",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("lás og fyllipennur"),
            keywords: &[
                "afturlati",
                "fyllipennur",
                "heingilás",
                "lás",
                "lás og fyllipennur",
                "læst",
                "pennur",
                "stongt",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cadenas fermé avec stylo"),
            keywords: &["cadenas fermé avec stylo", "verrouillé"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "cadenas",
                "cadenas fermé avec stylo",
                "confidentialité",
                "encre",
                "stylo",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("glasáilte le peann"),
            keywords: &[
                "dúch",
                "glas agus peann",
                "glasáilte le peann",
                "príobháideachas",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("glaiste le peann"),
            keywords: &[
                "glais",
                "glaiste le peann",
                "glas",
                "gob",
                "inc",
                "peann",
                "prìobhaideachd",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cadeado con pluma"),
            keywords: &[
                "cadeado con pluma",
                "pluma",
                "seguranza",
                "sinatura dixital",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{ac7}ન સાથ\u{ac7} લૉક"),
            keywords: &[
                "ઇ\u{a82}ક પ\u{ac7}ન",
                "ઇ\u{a82}ક પ\u{ac7}ન સાથ\u{ac7} લૉક",
                "ગોપનીયતા",
                "પ\u{ac7}ન સાથ\u{ac7} લૉક",
                "લૉક કરો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("a kulle tare da alƙalami"),
            keywords: &[
                "a kulle tare da alƙalami",
                "alƙalami",
                "bakin alƙalami",
                "kulle",
                "sirri",
                "tawada",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מנעול עם עט"),
            keywords: &["מנעול", "מנעול עם עט", "סגור", "עט", "פרטיות"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("फाउ\u{902}ट\u{947}न प\u{947}न क\u{947} साथ ताला"),
            keywords: &[
                "गोपनीयता",
                "ताला",
                "फाउ\u{902}ट\u{947}न प\u{947}न क\u{947} साथ ताला",
                "स\u{94d}याही की प\u{947}न क\u{947} साथ ताला",
                "स\u{94d}याही वाली प\u{947}न",
                "स\u{94d}याही वाल\u{947} प\u{947}न क\u{947} साथ ताला",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zatvoreni lokot s nalivperom"),
            keywords: &[
                "lokot",
                "pero",
                "privatnost",
                "tinta",
                "zatvoreni lokot s nalivperom",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("lakat tollal"),
            keywords: &["adatvédelem", "lakat tollal", "tinta", "toll", "zár"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կողպեք ինքնահոսով"),
            keywords: &[
                "գաղտնիություն",
                "գրիչ",
                "գրչածայր",
                "թանաք",
                "կողպեք",
                "կողպեք ինքնահոսով",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("gembok terkunci dengan pena"),
            keywords: &[
                "gembok",
                "gembok terkunci dengan pena",
                "pena",
                "privasi",
                "tinta",
                "ujung pena",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akpọchiri n’iji mkpịsịodee"),
            keywords: &[
                "akpọchiri n’iji mkpịsịodee",
                "inki",
                "kpọchie",
                "mkpịsịodee",
                "nzuzo",
                "ọnụ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("lás með penna"),
            keywords: &[
                "blekpenni",
                "lás með blekpenna",
                "lás með penna",
                "persónuvernd",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("lucchetto con penna stilo"),
            keywords: &[
                "lucchetto",
                "lucchetto con penna stilo",
                "privacy",
                "stilografica",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("閉じた錠とペン"),
            keywords: &["プライバシー", "ロック", "鍵", "閉じた錠とペン"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("gembok nutup karo pen"),
            keywords: &[
                "dom mangsi",
                "gembok",
                "gembok nutup karo pen",
                "mangsi",
                "pen",
                "privasi",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("საკეტი და კალამი"),
            keywords: &[
                "კალამი",
                "კალმისტარი",
                "კონფიდენციალურობა",
                "მელანი",
                "საკეტი",
                "საკეტი და კალამი",
                "წვერი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қалам мен құлып"),
            keywords: &[
                "сия",
                "қалам",
                "қалам мен құлып",
                "қаламмен құлыпталған",
                "қауырсын",
                "құлып",
                "құпиялылық",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("hængelås med pen"),
            keywords: &["fyldepen", "hængelås med pen", "lås med fyldepen", "privat"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("យកប\u{17ca}\u{17b7}ចចាក\u{17cb}សោ"),
            keywords: &[
                "ចាក\u{17cb}សោ",
                "ប\u{17ca}\u{17b7}ច",
                "យកប\u{17ca}\u{17b7}ចចាក\u{17cb}សោ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪ\u{cc6}ನ\u{ccd}ನ\u{cbf}ನ\u{cbf}ಂದ ಲಾಕ\u{ccd}"),
            keywords: &[
                "ಇಂಕ\u{ccd} ಪ\u{cc6}ನ\u{ccd}",
                "ಇಂಕ\u{ccd} ಪ\u{cc6}ನ\u{ccd}\u{200c}ನೊಂದ\u{cbf}ಗ\u{cc6} ಲಾಕ\u{ccd}",
                "ಗ\u{ccc}ಪ\u{ccd}ಯತ\u{cc6}",
                "ಪ\u{cc6}ನ\u{ccd}ನ\u{cbf}ನ\u{cbf}ಂದ ಲಾಕ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("자물쇠와 펜"),
            keywords: &["사생활", "자물쇠", "자물쇠와 펜", "펜", "프라이버시"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("प\u{945}नान लॉक जाल\u{947}\u{902}"),
            keywords: &[
                "इ\u{902}क",
                "ग\u{941}प\u{94d}तताय",
                "नीब",
                "प\u{945}न",
                "प\u{945}नान लॉक जाल\u{947}\u{902}",
                "लॉक",
                "लॉक क\u{947}ल\u{94d}ल\u{947}\u{902} प\u{945}न",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("калем менен кулпулоо"),
            keywords: &["калем", "калем менен кулпулоо", "кулпу", "купуялык", "сыя"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("zouent Schlass mat Bic"),
            keywords: &[
                "Bic",
                "Fieder",
                "Schlass",
                "Tënt",
                "privat",
                "zou",
                "zouent Schlass mat Bic",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec8}ວຍກະແຈກ\u{eb1}ບປາກກາ"),
            keywords: &["ກະແຈ", "ປາກກາ", "ໜ\u{ec8}ວຍກະແຈກ\u{eb1}ບປາກກາ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("spyna ir rašiklis"),
            keywords: &[
                "privatumas",
                "rašalas",
                "rašiklis",
                "smaigalys",
                "spyna",
                "spyna ir rašiklis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("slēdzene ar rakstāmspalvu"),
            keywords: &[
                "konfidencialitāte",
                "rakstāmspalva",
                "slēdzene",
                "slēdzene ar rakstāmspalvu",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("maukati mā te pene"),
            keywords: &[
                "maukati",
                "maukati mā te pene",
                "pene",
                "timopene",
                "tūmataitinga",
                "waituhi",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("заклучен катанец со перо"),
            keywords: &[
                "заклучен катанец со перо",
                "катанец",
                "мастило",
                "перо",
                "приватност",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d42}ട\u{d4d}ട\u{d41}ം പേനയ\u{d41}ം"),
            keywords: &[
                "പ\u{d42}ട\u{d4d}ട\u{d41}ം ഇങ\u{d4d}ക\u{d4d} പേനയ\u{d41}ം",
                "പ\u{d42}ട\u{d4d}ട\u{d41}ം പേനയ\u{d41}ം",
                "സ\u{d41}രക\u{d4d}ഷ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цоож, бал"),
            keywords: &["бал", "бэх", "нууцлал", "түгжээ", "цоож, бал"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{947}नसह क\u{941}ल\u{942}प"),
            keywords: &[
                "क\u{941}ल\u{942}प",
                "गोपनीयता",
                "निब",
                "प\u{947}न",
                "प\u{947}नसह क\u{941}ल\u{942}प",
                "शाई",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("mangga dengan pen"),
            keywords: &[
                "dakwat",
                "kunci",
                "mangga dengan pen",
                "mata pen",
                "pen",
                "privasi",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("imsakkar b’pinna"),
            keywords: &[
                "imsakkar",
                "imsakkar b’pinna",
                "linka",
                "pinna",
                "ponta",
                "privatezza",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မင\u{103a}တ\u{1036}န\u{103e}င\u{1037}\u{103a} သော\u{1037}ခလောက\u{103a}"),
            keywords: &[
                "ကလောင\u{103a}သ\u{103d}ား",
                "က\u{102d}\u{102f}ယ\u{103a}ရေးက\u{102d}\u{102f}ယ\u{103a}တာ",
                "ခပ\u{103a}ထားသော သော\u{1037}ခလောက\u{103a}န\u{103e}င\u{1037}\u{103a} ကလောင\u{103a}တ\u{1036}",
                "မင\u{103a}",
                "မင\u{103a}တ\u{1036}န\u{103e}င\u{1037}\u{103a} သော\u{1037}ခလောက\u{103a}",
                "သော\u{1037}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("låst med penn"),
            keywords: &["låst med penn", "penn", "personvern"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कलमल\u{947} लक गरिएको"),
            keywords: &[
                "कलम",
                "कलमल\u{947} लक गरिएको",
                "गोपनीयता",
                "निब",
                "मसी",
                "लक",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("slot met pen"),
            keywords: &["inkt", "pen", "privacy", "slot", "slot met pen", "vulpen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("låst med penn"),
            keywords: &["låst med penn", "penn", "personvern"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ପେନ\u{b4d}\u{200c} ଦ\u{b4d}ଵ\u{b3e}ର\u{b3e} ତ\u{b3e}ଲ\u{b3e} ପଡ\u{b3c}\u{b3f}ଛ\u{b3f}",
            ),
            keywords: &[
                "ଏକ ସ\u{b4d}ୟ\u{b3e}ହ\u{b3f} ପେନ\u{b4d}\u{200c}ରେ ଲକ\u{b4d} କର\u{b3f}ବ\u{b3e}",
                "ଗୋପନୀୟତ\u{b3e}",
                "ପେନ\u{b4d}\u{200c} ଦ\u{b4d}ଵ\u{b3e}ର\u{b3e} ତ\u{b3e}ଲ\u{b3e} ପଡ\u{b3c}\u{b3f}ଛ\u{b3f}",
                "ଲକ\u{b4d}",
                "ସ\u{b4d}ୟ\u{b3e}ହ\u{b3f} ପେନ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a48}ਨ ਨਾਲ ਲਾਕ"),
            keywords: &[
                "ਇ\u{a71}ਕ ਸਿਆਹੀ ਕਲਮ ਨਾਲ ਲਾਕ",
                "ਪਰਦ\u{a47}ਦਾਰੀ",
                "ਪ\u{a48}ਨ ਨਾਲ ਲਾਕ",
                "ਲਾਕ",
                "ਸਿਆਹੀ ਕਲਮ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پین نال مقفل"),
            keywords: &[
                "تالا",
                "راز داری",
                "سیاہی",
                "قلم",
                "قلم دی نوک",
                "پین نال مقفل",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Lọ\u{301}kd Wit Pẹn"),
            keywords: &[
                "Ink",
                "Lọk",
                "Lọ\u{301}kd Wit Pẹn",
                "Nib",
                "Praívési",
                "Pẹn",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zamknięta kłódka z piórem"),
            keywords: &[
                "atrament",
                "niejawne",
                "pióro",
                "podpis",
                "prywatność",
                "zamknięta kłódka z piórem",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د قلم سره تړل شوی"),
            keywords: &["د قلم سره تړل شوی", "سياهي", "قلم", "محرمتيا", "نب", "کلپ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cadeado com caneta"),
            keywords: &[
                "cadeado com caneta",
                "cadeado com caneta tinteiro",
                "caneta tinteiro",
                "privacidade",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "aparo",
                "cadeado",
                "cadeado com caneta",
                "caneta",
                "privacidade",
                "tinta",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("lacăt cu stilou"),
            keywords: &[
                "confidențialitate",
                "lacăt",
                "lacăt cu stilou",
                "peniță",
                "stilou",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-715"),
            keywords: &["E10-715"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("закрытый замок с перьевой ручкой"),
            keywords: &[
                "закрытый замок",
                "закрытый замок с перьевой ручкой",
                "защита",
                "перьевая ручка",
                "перьевой наконечник",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ingufuri n’ikaramu"),
            keywords: &[
                "gufunga",
                "ibaba",
                "ikaramu",
                "imibereho bwite y’umuntu",
                "ingufuri n’ikaramu",
                "wino",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پين سان لاڪ"),
            keywords: &["تالو", "ذاتي", "مس", "نب", "پين", "پين سان لاڪ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පෑන සහ\u{dd2}ත අග\u{dd4}ල"),
            keywords: &[
                "අග\u{dd4}ල",
                "ත\u{dd3}න\u{dca}ත",
                "ත\u{dd4}ඩ",
                "පෑන සහ\u{dd2}ත අග\u{dd4}ල",
                "රහස\u{dca}\u{200d}යත\u{dcf}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zámka s perom"),
            keywords: &[
                "atrament",
                "hrot",
                "pero",
                "súkromie",
                "zámka",
                "zámka s perom",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ključavnica s peresom"),
            keywords: &[
                "ključavnica",
                "ključavnica s peresom",
                "konica",
                "pero",
                "zasebnost",
                "črnilo",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("xidhan oo qalin wata"),
            keywords: &[
                "af qalin",
                "gaar ah",
                "khad",
                "qalin",
                "quful",
                "xidhan oo qalin wata",
                "xidhan oo wata",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kyç me penë"),
            keywords: &["bojë", "kyç", "kyç me penë", "majë pene", "privatësi"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("катанац са наливпером"),
            keywords: &[
                "катанац",
                "катанац са наливпером",
                "мастило",
                "наливперо",
                "привaтнoст",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("katanac sa nalivperom"),
            keywords: &[
                "katanac",
                "katanac sa nalivperom",
                "mastilo",
                "nalivpero",
                "privatnost",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("lås med bläckpenna"),
            keywords: &["bläckpenna", "lås", "lås med bläckpenna"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kufuli na kalamu"),
            keywords: &[
                "faragha",
                "kalamu",
                "kufuli",
                "kufuli na kalamu",
                "nibu",
                "wino",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பேன\u{bbe}வுடன\u{bcd} பூட\u{bcd}டு"),
            keywords: &[
                "உரிமை",
                "எனதுரிமை",
                "பூட\u{bcd}டு",
                "பேன\u{bbe}",
                "பேன\u{bbe}வுடன\u{bcd} பூட\u{bcd}டு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("త\u{c3e}ళం చ\u{c46}వ\u{c3f}త\u{c4b} వ\u{c47}స\u{c3f} ఉన\u{c4d}న కలం"),
            keywords: &[
                "ఇంక\u{c4d} ప\u{c46}న\u{c4d}\u{200c}త\u{c4b} ప\u{c3e}టుగ\u{c3e} ఉన\u{c4d}న త\u{c3e}ళం",
                "చదవడ\u{c3e}న\u{c3f}క\u{c3f} మ\u{c3e}త\u{c4d}రమ\u{c47}",
                "త\u{c3e}ళం చ\u{c46}వ\u{c3f}త\u{c4b} వ\u{c47}స\u{c3f} ఉన\u{c4d}న కలం",
                "రక\u{c4d}ష\u{c3f}ంచబడ\u{c3f}ంద\u{c3f}",
                "సవర\u{c3f}ంచల\u{c47}రు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("бо қалам қулф шудааст"),
            keywords: &[
                "бо қалам қулф шудааст",
                "махфият",
                "нӯг",
                "ручка",
                "сиёҳӣ",
                "қулф",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e47}อคด\u{e49}วยปากกา"),
            keywords: &[
                "ข\u{e49}อม\u{e39}ลส\u{e48}วนต\u{e31}ว",
                "ล\u{e47}อค",
                "ล\u{e47}อคด\u{e49}วยปากกา",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ruçkaly gulply"),
            keywords: &["gizlinlik", "gulp", "ruçka", "ruçkaly gulply", "syýa", "uç"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("loka moe peni"),
            keywords: &["loka moe peni"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kilit ve kalem"),
            keywords: &[
                "gizlilik",
                "kilit ve kalem",
                "mürekkepli kalem",
                "mürekkepli kalemli kilit",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قەلەملىك قۇلۇپ"),
            keywords: &[
                "ئۇچ",
                "بوياق",
                "قۇلۇپ",
                "قەلەم",
                "قەلەملىك قۇلۇپ",
                "مەخپىيەتلىك",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("замок і чорнильна ручка"),
            keywords: &[
                "замок",
                "замок і чорнильна ручка",
                "перо",
                "приватність",
                "ручка",
                "чорнило",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پن کے ساتھ لاک"),
            keywords: &["لاک", "پرائیویسی", "پن", "پن کے ساتھ لاک"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qulf va ruchka"),
            keywords: &[
                "bo‘yoq",
                "maxfiylik",
                "pero",
                "qulf",
                "qulf va ruchka",
                "ruchka",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("khóa với bút"),
            keywords: &["bút", "khóa", "khóa với bút", "mực", "ngòi bút", "riêng tư"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("tëj nañu ko ak bik"),
            keywords: &[
                "bik",
                "caabu",
                "daa",
                "fëtar",
                "suturlu",
                "tëj nañu ko ak bik",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("itshixwe ngosiba"),
            keywords: &[
                "i-inki",
                "incam yosiba",
                "itshixwe ngosiba",
                "tshixa",
                "usiba",
                "yabucala",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ti tìí pẹlu pẹni"),
            keywords: &[
                "góngó",
                "padé",
                "pẹ\u{301}ẹ\u{300}nì",
                "ti tìí pẹlu pẹni",
                "ìkọ\u{300}kọ\u{300}",
                "ínkì",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("用筆鎖"),
            keywords: &["墨水", "用筆鎖", "筆", "筆尖", "鎖", "隱私"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("用笔锁"),
            keywords: &["墨水", "用笔锁", "笔", "笔尖", "锁", "隐私"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("墨水笔和锁"),
            keywords: &["墨水笔和锁", "笔", "笔尖", "钢笔", "锁", "隐私"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("鋼筆和鎖"),
            keywords: &["鋼筆", "鋼筆和鎖", "鎖"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ingidi enepeni"),
            keywords: &["ingidi enepeni", "ipeni", "khiya", "uvumfihlo", "uyinki"],
        },
    ],
};
#[doc = "🔐"]
pub const LOCKED_WITH_KEY: crate::Emoji = crate::Emoji {
    glyph: "🔐",
    codepoint: "1F510",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "locked with key",
    group: "Objects",
    subgroup: "lock",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("toe slot met sleutel"),
            keywords: &[
                "gesluit",
                "sleutel",
                "slot",
                "toe",
                "toe slot met sleutel",
                "veilig",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("በቁልፍ የተዘጋ መሸጎጫ"),
            keywords: &["ቁልፍ", "በቁልፍ የተዘጋ መሸጎጫ", "የተዘጋ", "ደህንነቱ አስተማማኝ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قفل مغلق بمفتاح"),
            keywords: &["آمن", "قفل عليه مفتاح", "قفل مغلق بمفتاح"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চ\u{9be}বিৰ দ\u{9cd}ব\u{9be}ৰ\u{9be} তল\u{9be} বন\u{9cd}ধ"),
            keywords: &[
                "চ\u{9be}বি",
                "চ\u{9be}বিৰ দ\u{9cd}ব\u{9be}ৰ\u{9be} তল\u{9be} বন\u{9cd}ধ",
                "তল\u{9be}",
                "বন\u{9cd}ধ",
                "স\u{9c1}ৰক\u{9cd}ষিত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("açarla bağlanmış kilid"),
            keywords: &["açar", "açarla bağlanmış kilid", "bağlı", "kilid", "secure"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("замкнёны замок з ключом"),
            keywords: &[
                "бяспека",
                "закрыта",
                "замкнёны замок з ключом",
                "замок",
                "ключ",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Затворен катинар с ключ"),
            keywords: &["Затворен катинар с ключ", "затворен", "катинар", "ключ"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চ\u{9be}বি দিয\u{9bc}ে ত\u{9be}ল\u{9be} বন\u{9cd}ধ কর\u{9be}"),
            keywords: &[
                "চ\u{9be}বি",
                "চ\u{9be}বি দিয\u{9bc}ে ত\u{9be}ল\u{9be} বন\u{9cd}ধ কর\u{9be}",
                "ত\u{9be}ল\u{9be}",
                "নির\u{9be}পদ",
                "বন\u{9cd}ধ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kadranas serr gant alcʼhwez"),
            keywords: &[
                "alcʼhwez",
                "kadranas",
                "kadranas serr gant alcʼhwez",
                "serr",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zatvoren katanac sa ključem"),
            keywords: &[
                "katanac",
                "ključ",
                "sigurno",
                "zatvoren",
                "zatvoren katanac sa ključem",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cadenat tancat amb clau"),
            keywords: &[
                "bloqueig",
                "cadenat tancat amb clau",
                "clau",
                "segur",
                "tancat",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏍᏓᏱ ᎠᏍᏚᎲᎢ ᏍᏚᎢᏍᏗ ᎬᏗ"),
            keywords: &["ᎠᏍᏚᎢᏍᏗ", "ᎠᏍᏚᎭ", "ᏍᏓᏱ ᎠᏍᏚᎲ", "ᏍᏓᏱ ᎠᏍᏚᎲᎢ ᏍᏚᎢᏍᏗ ᎬᏗ", "ᏓᎦᏏ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zamknutý zámek s klíčem"),
            keywords: &[
                "bezpečný",
                "klíč",
                "zabezpečení",
                "zamknutý zámek s klíčem",
                "zavřený",
                "zámek",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("clô ynghau gydag allwedd"),
            keywords: &[
                "allwedd",
                "cloi",
                "clô",
                "clô ynghau gydag allwedd",
                "diogel",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("lukket hængelås med nøgle"),
            keywords: &[
                "lukket hængelås med nøgle",
                "lås med nøgle",
                "låst",
                "sikker",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schloss mit Schlüssel"),
            keywords: &[
                "Datenschutz",
                "Schloss mit Schlüssel",
                "Sicherheit",
                "privat",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κλειδωμένο με κλειδί"),
            keywords: &[
                "ασφαλίζω",
                "κλειδί",
                "κλειδαριά",
                "κλειδωμένο με κλειδί",
                "κλειστό",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("locked with key"),
            keywords: &["closed", "key", "lock", "locked with key", "secure"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("candado cerrado y llave"),
            keywords: &[
                "candado",
                "candado cerrado y llave",
                "cerrado",
                "llave",
                "seguro",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["candado", "candado cerrado y llave", "cerrado", "llave"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("suletud lukk võtmega"),
            keywords: &["lukk", "lukus", "suletud", "suletud lukk võtmega", "võti"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("giltzarrapo itxia giltzarekin"),
            keywords: &[
                "giltz",
                "giltzarrapo",
                "giltzarrapo itxia giltzarekin",
                "itxita",
                "seguru",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قفل و کلید"),
            keywords: &["امن", "بسته", "قفل", "قفل و کلید", "کلید"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("avain ja lukko kiinni"),
            keywords: &["avain", "avain ja lukko kiinni", "kiinni", "lukko", "turva"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nakasarang kandado na may susi"),
            keywords: &[
                "kandado",
                "ligtas",
                "naka-lock",
                "nakasara",
                "nakasarang kandado na may susi",
                "sarado",
                "susi",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("heingilás og lykil"),
            keywords: &[
                "afturlati",
                "heingilás",
                "heingilás og lykil",
                "lykil",
                "læst",
                "stongt",
                "ás",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cadenas fermé avec clé"),
            keywords: &["cadenas fermé avec clé", "sécurisé"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("cadenas avec clé"),
            keywords: &[
                "cadenas",
                "cadenas avec clé",
                "clé",
                "fermé",
                "sécurisé",
                "sûr",
                "verrouillé",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("glasáilte le heochair"),
            keywords: &["glas dúnta agus peann", "glasáilte le heochair"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("glaiste le iuchair"),
            keywords: &[
                "dùinte",
                "glais",
                "glaiste le iuchair",
                "glas",
                "iuchair",
                "tèarainte",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cadeado con chave"),
            keywords: &["cadeado con chave", "pechado", "privacidade", "seguranza"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચાવી સાથ\u{ac7} બ\u{a82}ધ તાળ\u{ac1}\u{a82}"),
            keywords: &[
                "ચાવી સાથ\u{ac7} તાળ\u{ac1}\u{a82}",
                "ચાવી સાથ\u{ac7} બ\u{a82}ધ તાળ\u{ac1}\u{a82}",
                "બ\u{a82}ધ તાળ\u{ac1}\u{a82}",
                "સ\u{ac1}રક\u{acd}ષિત",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("a kulle da makulli"),
            keywords: &[
                "a kulle",
                "a kulle da makulli",
                "mai tsaro",
                "makulli",
                "rufaffe",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מנעול סגור עם מפתח"),
            keywords: &[
                "מאובטח",
                "מנעול",
                "מנעול סגור עם מפתח",
                "מפתח",
                "נעול עם מפתח",
                "סגור",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चाबी क\u{947} साथ ब\u{902}द ताला"),
            keywords: &[
                "चाबी क\u{947} साथ ताला",
                "चाबी क\u{947} साथ ब\u{902}द ताला",
                "ब\u{902}द ताला",
                "स\u{941}रक\u{94d}षा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zatvoreni lokot s ključem"),
            keywords: &[
                "ključ",
                "lokot",
                "sigurno",
                "zatvoreni lokot s ključem",
                "zatvoreno",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("zárt lakat kulccsal"),
            keywords: &[
                "biztonságos",
                "kulcs",
                "zárt",
                "zárt lakat kulccsal",
                "zárva",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("փակ կողպեք բանալիով"),
            keywords: &["ապահով", "բնալի", "կողպեք", "փակ", "փակ կողպեք բանալիով"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("gembok terkunci dengan kunci"),
            keywords: &[
                "aman",
                "gembok",
                "gembok terkunci dengan kunci",
                "kunci",
                "tutup",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akpọchiri n’iji ọtụgwo"),
            keywords: &[
                "akpọchiri n’iji ọtụgwo",
                "chekwaa",
                "e mechiri",
                "kpọchie",
                "ọtụgwo",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("lokaður lás"),
            keywords: &["lokaður lás", "lás með lykli", "öruggt"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("lucchetto chiuso con chiave"),
            keywords: &[
                "chiave",
                "lucchetto chiuso",
                "lucchetto chiuso con chiave",
                "sicuro",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("閉じた錠と鍵"),
            keywords: &["キー", "セキュリティ", "ロック", "安全", "閉じた錠と鍵"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("gembok nutup karo kunci"),
            keywords: &[
                "aman",
                "gembok",
                "gembok nutup karo kunci",
                "kunci",
                "nutup",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჩაკეტილი საკეტი და კალამი"),
            keywords: &[
                "გასაღები",
                "დახურული",
                "საკეტი",
                "უსაფრთხო",
                "ჩაკეტილი საკეტი და კალამი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("кілті бар жабық құлып"),
            keywords: &[
                "жабық",
                "кілт",
                "кілті бар жабық құлып",
                "қауіпсіз",
                "құлып",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("lukket hængelås med nøgle"),
            keywords: &[
                "lukket hængelås med nøgle",
                "lås med nøgle",
                "låst",
                "sikker",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ចាក\u{17cb}សោជាប\u{17cb}ដោយប\u{17d2}រើក\u{17bc}នសោ"),
            keywords: &[
                "ក\u{17bc}នសោ",
                "ចាក\u{17cb}សោ",
                "ចាក\u{17cb}សោជាប\u{17cb}ដោយប\u{17d2}រើក\u{17bc}នសោ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕೀಯೊಂದ\u{cbf}ಗ\u{cc6} ಮುಚ\u{ccd}ಚ\u{cbf}ದ ಲಾಕ\u{ccd}"),
            keywords: &[
                "ಕೀಯೊಂದ\u{cbf}ಗ\u{cc6} ಮುಚ\u{ccd}ಚ\u{cbf}ದ ಲಾಕ\u{ccd}",
                "ಕೀಯೊಂದ\u{cbf}ಗ\u{cc6} ಲಾಕ\u{ccd}",
                "ಲಾಕ\u{ccd}",
                "ಸುರಕ\u{ccd}ಷ\u{cbf}ತ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("자물쇠와 열쇠"),
            keywords: &["보안", "열쇠", "자물쇠", "자물쇠와 열쇠"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("कि सयत लॉक क\u{947}ला\u{902}"),
            keywords: &[
                "कि सयत लॉक क\u{947}ला\u{902}",
                "क\u{941}लप",
                "चावय\u{947}न क\u{941}लप घाला\u{902}",
                "चावी",
                "धा\u{902}पिल\u{94d}ल\u{947}\u{902}",
                "स\u{941}रक\u{94d}षीत",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ачкыч менен жабылган кулпу"),
            keywords: &[
                "ачкыч",
                "ачкыч менен жабылган кулпу",
                "жабык",
                "коопсуз",
                "кулпу",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("zouent Schlass mat Schlëssel"),
            keywords: &[
                "Schlass",
                "Schlëssel",
                "sécher",
                "zou",
                "zouent Schlass mat Schlëssel",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec8}ວຍກະແຈລ\u{eb1}ອກພ\u{ec9}ອມກ\u{eb1}ບລ\u{eb9}ກກະແຈ"),
            keywords: &[
                "ກະແຈ",
                "ປ\u{eb4}ດ",
                "ລ\u{eb1}ອ",
                "ລ\u{eb9}ກກະແຈ",
                "ໜ\u{ec8}ວຍກະແຈລ\u{eb1}ອກພ\u{ec9}ອມກ\u{eb1}ບລ\u{eb9}ກກະແຈ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("užrakinta spyna su raktu"),
            keywords: &[
                "raktas",
                "saugu",
                "spyna",
                "uždaryta",
                "užrakinta spyna su raktu",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("aizvērta slēdzene ar atslēgu"),
            keywords: &[
                "aizvērta slēdzene ar atslēgu",
                "atslēga",
                "drošs",
                "slēdzene",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("maukati mā te kī"),
            keywords: &["haumaru", "kati", "kī", "maukati", "maukati mā te kī"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("заклучен катанец со клуч"),
            keywords: &["заклучен", "заклучен катанец со клуч", "катанец", "клуч"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d42}ട\u{d4d}ട\u{d41}ം ത\u{d3e}ക\u{d4d}കോല\u{d41}ം"),
            keywords: &[
                "ത\u{d3e}ക\u{d4d}കഌ",
                "പ\u{d42}ട\u{d4d}ട\u{d41}ം കീയ\u{d41}ം",
                "പ\u{d42}ട\u{d4d}ട\u{d41}ം ത\u{d3e}ക\u{d4d}കോല\u{d41}ം",
                "പ\u{d42}ട\u{d4d}ട\u{d4d}",
                "ലോക\u{d4d}ക\u{d4d}",
                "സ\u{d41}രക\u{d4d}ഷ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цоож, түлхүүр"),
            keywords: &["аюулгүй", "түгжээ", "түлхүүр", "хаалттай", "цоож, түлхүүр"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चावीसह ब\u{902}द असल\u{947}ल\u{947} क\u{941}ल\u{942}प"),
            keywords: &[
                "क\u{941}ल\u{942}प",
                "चावी",
                "चावीसह ब\u{902}द असल\u{947}ल\u{947} क\u{941}ल\u{942}प",
                "ब\u{902}द",
                "स\u{941}रक\u{94d}षित",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("mangga terkunci dengan anak kunci"),
            keywords: &[
                "berkunci",
                "kunci",
                "mangga terkunci dengan anak kunci",
                "mengunci",
                "selamat",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("msakkar b’ċavetta"),
            keywords: &[
                "imsakkar",
                "magħluqa",
                "msakkar b’ċavetta",
                "sigur",
                "ċavetta",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ပ\u{102d}တ\u{103a}ထားသည\u{1037}\u{103a} သော\u{1037}ခလောက\u{103a}န\u{103e}င\u{1037}\u{103a} သော\u{1037}",
            ),
            keywords: &[
                "ပ\u{102d}တ\u{103a}ထားသည\u{1037}\u{103a} သော\u{1037}ခလောက\u{103a}န\u{103e}င\u{1037}\u{103a} သော\u{1037}",
                "ပ\u{102d}တ\u{103a}ထားသည\u{103a}",
                "လ\u{102f}\u{1036}ခြ\u{102f}\u{1036}ပါသည\u{103a}",
                "သော\u{1037}ခလောက\u{103a}န\u{103e}င\u{1037}\u{103a} သော\u{1037}တ\u{1036}",
                "သော\u{1037}တ\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("låst med nøkkel"),
            keywords: &["lås med nøkkel", "låst med nøkkel", "sikker"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("चाबील\u{947} लक गरिएको"),
            keywords: &[
                "चाबील\u{947} लक गरिएको",
                "बन\u{94d}द",
                "लक",
                "सा\u{901}चो",
                "स\u{941}रक\u{94d}षित",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gesloten slot met sleutel"),
            keywords: &[
                "beveiligd",
                "gesloten",
                "gesloten slot met sleutel",
                "sleutel",
                "slot",
                "slot met sleutel",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("låst med nøkkel"),
            keywords: &["lås med nøkkel", "låst med nøkkel", "sikker"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଚ\u{b3e}ବ\u{b3f} ସହ\u{b3f}ତ ତ\u{b3e}ଲ\u{b3e} ପଡ\u{b3f}ଛ\u{b3f}"),
            keywords: &[
                "ଏକ କୀ ସହ\u{b3f}ତ ଲକ\u{b4d}",
                "ଚ\u{b3e}ବ\u{b3f} ଦ\u{b4d}ଵ\u{b3e}ର\u{b3e} ତ\u{b3e}ଲ\u{b3e} ପଡ\u{b3f}ଛ\u{b3f}",
                "ଚ\u{b3e}ବ\u{b3f} ସହ\u{b3f}ତ ତ\u{b3e}ଲ\u{b3e} ପଡ\u{b3f}ଛ\u{b3f}",
                "ବନ\u{b4d}ଦ ହୋଇଥ\u{b3f}ବ\u{b3e} ଲକ\u{b4d}",
                "ସ\u{b41}ରକ\u{b4d}ଷ\u{b3f}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a41}\u{a70}ਜੀ ਨਾਲ ਬ\u{a70}ਦ ਕੀਤਾ ਲਾਕ"),
            keywords: &[
                "ਇ\u{a71}ਕ ਕ\u{a41}\u{a70}ਜੀ ਨਾਲ ਲਾਕ",
                "ਕ\u{a41}\u{a70}ਜੀ ਨਾਲ ਬ\u{a70}ਦ ਕੀਤਾ ਲਾਕ",
                "ਬ\u{a70}ਦ ਲਾਕ",
                "ਸ\u{a41}ਰ\u{a71}ਖਿਅਤ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کلید نال مقفل"),
            keywords: &["بند کیتا", "تالا", "محفوظ کرنا", "کلید", "کلید نال مقفل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Lọ\u{301}kd Wit Kii"),
            keywords: &["Kii", "Klozd", "Lọk", "Lọ\u{301}kd Wit Kii", "Sef"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zamknięta kłódka z kluczem"),
            keywords: &[
                "blokada",
                "kluczyk",
                "kłódka",
                "zamknięcie",
                "zamknięta kłódka z kluczem",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د کیلي سره تړل شوی"),
            keywords: &[
                "بند شوی",
                "خوندي",
                "د کیلي سره تړل شوی",
                "کلپ",
                "کيلي",
                "کيلي سره تړل شوی",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cadeado fechado com chave"),
            keywords: &["cadeado com chave", "cadeado fechado com chave", "seguro"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "cadeado",
                "cadeado fechado com chave",
                "chave",
                "fechado",
                "seguro",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("lacăt închis cu cheie"),
            keywords: &[
                "cheie",
                "lacăt",
                "lacăt închis cu cheie",
                "securizat",
                "siguranță",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-716"),
            keywords: &["E10-716"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("закрытый замок с ключом"),
            keywords: &[
                "безопасность",
                "закрытый",
                "закрытый замок с ключом",
                "замок",
                "ключ",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ingufuri ifunze n’urufunguzo"),
            keywords: &[
                "cyizewe umutekano",
                "gifunze",
                "gufunga",
                "ingufuri ifunze n’urufunguzo",
                "urufunguzo",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("چاٻي سان لاڪ"),
            keywords: &["بند ٿيل", "تالو", "محفوظ", "چاٻي", "چاٻي سان لاڪ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("යත\u{dd4}ර සහ\u{dd2}ත වැස\u{dd6} අග\u{dd4}ල"),
            keywords: &[
                "අග\u{dd4}ල",
                "ආරක\u{dca}ෂ\u{dd2}ත",
                "යත\u{dd4}ර",
                "යත\u{dd4}ර සහ\u{dd2}ත වැස\u{dd6} අග\u{dd4}ල",
                "වැස\u{dd6}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zámka s kľúčom"),
            keywords: &["kľúč", "zabezpečiť", "zatvorené", "zámka", "zámka s kľúčom"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zaprta ključavnica s ključem"),
            keywords: &[
                "ključ",
                "ključavnica",
                "varno",
                "zaprta ključavnica s ključem",
                "zaprto",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("xidhan oo fure wata"),
            keywords: &["amaan ah", "fure", "quful", "xidhan", "xidhan oo fure wata"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kyç i mbyllur me çelës"),
            keywords: &[
                "i mbyllur",
                "i sigurt",
                "kyç",
                "kyç i mbyllur me çelës",
                "çelës",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("затворен катанац са кључем"),
            keywords: &[
                "безбедно",
                "зaтвoрeнo",
                "затворен катанац са кључем",
                "катанац",
                "кључ",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["затворен катанац са кључем"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("zatvoren katanac sa ključem"),
            keywords: &[
                "bezbedno",
                "katanac",
                "ključ",
                "zatvoren katanac sa ključem",
                "zatvoreno",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["zatvoren katanac sa ključem"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("lås med nyckel"),
            keywords: &["lås", "lås med nyckel", "stängt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kufuli iliyofungwa na ufunguo"),
            keywords: &[
                "fungwa",
                "kufuli",
                "kufuli iliyofungwa na ufunguo",
                "salama",
                "ufunguo",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பூட\u{bcd}டும\u{bcd} ச\u{bbe}வியும\u{bcd}"),
            keywords: &[
                "ச\u{bbe}வி",
                "ப\u{bbe}துக\u{bbe}ப\u{bcd}பு",
                "பூட\u{bcd}டு",
                "பூட\u{bcd}டும\u{bcd} ச\u{bbe}வியும\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("త\u{c3e}ళం చ\u{c46}వ\u{c3f}త\u{c4b} వ\u{c47}స\u{c3f} ఉన\u{c4d}న త\u{c3e}ళం"),
            keywords: &[
                "త\u{c3e}ళం చ\u{c46}వ\u{c3f}త\u{c4b} ప\u{c3e}టుగ\u{c3e} మూస\u{c3f}వ\u{c47}స\u{c3f}న త\u{c3e}ళం",
                "త\u{c3e}ళం చ\u{c46}వ\u{c3f}త\u{c4b} వ\u{c47}స\u{c3f} ఉన\u{c4d}న త\u{c3e}ళం",
                "రక\u{c4d}ష\u{c3f}ంచబడ\u{c3f}ంద\u{c3f}",
                "సురక\u{c4d}ష\u{c3f}తం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("бо калид қулф шудааст"),
            keywords: &[
                "бехатар",
                "бо калид қулф шудааст",
                "калид",
                "пӯшида",
                "қулф",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e47}อคด\u{e49}วยก\u{e38}ญแจ"),
            keywords: &[
                "ก\u{e38}ญแจ",
                "ปลอดภ\u{e31}ย",
                "ป\u{e34}ด",
                "ล\u{e47}อค",
                "ล\u{e47}อคด\u{e49}วยก\u{e38}ญแจ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("açarly gulply"),
            keywords: &["açar", "açarly gulply", "gaýym", "gulp", "ýapyk"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("loka moe kī"),
            keywords: &["loka moe kī"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("anahtarlı kapalı kilit"),
            keywords: &["anahtarlı kapalı kilit", "anahtarlı kilit", "güvenli"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاچقۇچلۇق قۇلۇپ"),
            keywords: &["ئاچقۇچ", "ئاچقۇچلۇق قۇلۇپ", "بىخەتەر", "قۇلۇپ", "يېپىق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("замкнений замок із ключем"),
            keywords: &[
                "безпечно",
                "замкнений замок із ключем",
                "замкнено",
                "замок",
                "ключ",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چابی کے ساتھ بند لاک"),
            keywords: &["بند", "لاک", "محفوظ", "چابی", "چابی کے ساتھ بند لاک"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qulf va kalit"),
            keywords: &["kalit", "qulf", "qulf va kalit", "xavfsiz", "yopiq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("khóa với chìa"),
            keywords: &["bảo mật", "chìa", "khóa", "khóa với chìa", "đóng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("tëj nañu ko ak caabi"),
            keywords: &["key", "tëj", "tëj nañu ko", "tëj nañu ko ak caabi", "wóor"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("itshixwe ngesitshixo"),
            keywords: &[
                "ikhuselekile",
                "iqhosha",
                "itshixwe ngesitshixo",
                "ivaliwe",
                "tshixa",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ti tìí pẹlu kọkọrọ"),
            keywords: &[
                "kó\u{329}kọ\u{301}ró\u{329}",
                "pípadé",
                "ti tìí pẹlu kọkọrọ",
                "títì",
                "ààbò",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("用鎖匙鎖"),
            keywords: &["安全", "用鎖匙鎖", "鎖", "鎖匙", "關閉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("用锁匙锁"),
            keywords: &["关闭", "安全", "用锁匙锁", "锁", "锁匙"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("钥匙和锁"),
            keywords: &["安全", "钥匙", "钥匙和锁", "锁", "锁上"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("鑰匙和鎖"),
            keywords: &["鎖", "鑰匙", "鑰匙和鎖"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ingidi evaliwe enokhiye"),
            keywords: &[
                "ingidi",
                "ingidi evaliwe enokhiye",
                "kuphephile",
                "kuvaliwe",
                "ukhiye",
            ],
        },
    ],
};
#[doc = "🔑"]
pub const KEY: crate::Emoji = crate::Emoji {
    glyph: "🔑",
    codepoint: "1F511",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "key",
    group: "Objects",
    subgroup: "lock",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("sleutel"),
            keywords: &["sleutel", "slot", "wagwoord"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቁልፍ"),
            keywords: &["ቁልፍ", "የይለፍ ቃል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مفتاح"),
            keywords: &["كلمة مرور", "مفتاح"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চ\u{9be}বি"),
            keywords: &["চ\u{9be}বি", "তল\u{9be}", "প\u{9be}ছৱৰ\u{9cd}ড"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("açar"),
            keywords: &["açar", "kilid", "parol"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ключ"),
            keywords: &["замок", "ключ", "пароль"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("ключ"),
            keywords: &["заключване", "ключ", "парола"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চ\u{9be}বি"),
            keywords: &[
                "চ\u{9be}বি",
                "ত\u{9be}ল\u{9be}",
                "প\u{9be}সওয\u{9bc}\u{9be}র\u{9cd}ড",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("alcʼhwez"),
            keywords: &["alcʼhwez", "ger-tremen"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ključ"),
            keywords: &["ključ", "lozinka", "zaključan", "šifra"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("clau"),
            keywords: &["bloqueig", "clau", "contrasenya"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏍᏚᎢᏍᏗ"),
            keywords: &["ᎥᎧᏁᎬᎢ ᎠᏍᏚᎢᏍᏗ", "ᏍᏓᏱ ᎠᏍᏚᎲᎢ", "ᏍᏚᎢᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("klíč"),
            keywords: &["heslo", "klíč", "zámek"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("allwedd"),
            keywords: &["allwedd", "allweddair", "cloi"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("nøgle"),
            keywords: &["adgangskode", "nøgle", "password"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schlüssel"),
            keywords: &["Passwort", "Schlüssel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κλειδί"),
            keywords: &["κλειδί", "κλειδώνω", "κωδικός πρόσβασης"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("key"),
            keywords: &["key", "lock", "password"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("llave"),
            keywords: &["contraseña", "llave"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("võti"),
            keywords: &["lukk", "parool", "võti"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("giltza"),
            keywords: &["blokeo", "giltza", "pasahitza"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کلید"),
            keywords: &["قفل", "کلید", "گذرواژه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("avain"),
            keywords: &["avain", "lukittu", "salasana"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("susi"),
            keywords: &["naka-lock", "password", "susi"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("lykil"),
            keywords: &["loyniorð", "lykil", "lás"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("clé"),
            keywords: &["clé", "mot de passe", "serrure"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("eochair"),
            keywords: &["eochair"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("iuchair"),
            keywords: &["facal-faire", "glais", "glas", "iuchair"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("chave"),
            keywords: &["chave", "clave", "contrasinal"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચાવી"),
            keywords: &["કી", "ચાવી", "પાસવર\u{acd}ડ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("makulli"),
            keywords: &["kalmar sirri", "kulle", "makulli"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מפתח"),
            keywords: &["לנעול", "מפתח", "סיסמה", "רמז"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चाबी"),
            keywords: &["चाबी", "पासवर\u{94d}ड"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("ključ"),
            keywords: &["ključ", "lokot", "zaporka"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kulcs"),
            keywords: &["jelszó", "kulcs"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բանալի"),
            keywords: &["բանալի", "գաղտնաբառ", "կողպեք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kunci"),
            keywords: &["kunci", "sandi"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọtụgwo"),
            keywords: &["kpọchie", "okwuntụghe", "ọtụgwo"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("lykill"),
            keywords: &["aðgangsorð", "lykill", "lykilorð"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("chiave"),
            keywords: &["chiave", "password"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("鍵"),
            keywords: &["キー", "パスワード", "鍵"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kunci"),
            keywords: &["gembok", "kunci", "ukara sandhi"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გასაღები"),
            keywords: &["გასაღები", "პაროლი", "საკეტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("кілт"),
            keywords: &["кілт", "құлып", "құпия сөз"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("nøgle"),
            keywords: &["adgangskode", "nøgle", "password"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សោ"),
            keywords: &["ក\u{17bc}នសោ", "សោ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕೀ"),
            keywords: &["ಕೀ", "ಪಾಸ\u{ccd}\u{200c}ವರ\u{ccd}ಡ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("열쇠"),
            keywords: &["열쇠", "패스워드"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("चावी"),
            keywords: &["क\u{941}लप", "चावी", "पासवर\u{94d}ड"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ачкыч"),
            keywords: &["ачкыч", "кулпу", "сырсөз"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Schlëssel"),
            keywords: &["Passwuert", "Schlass", "Schlëssel"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{eb9}ກກະແຈ"),
            keywords: &["ລ\u{eb1}ອກ", "ລ\u{eb9}ກກະແຈ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("raktas"),
            keywords: &["raktas", "slaptažodis", "spyna"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("atslēga"),
            keywords: &["atslēga", "parole"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kī"),
            keywords: &["kupuhipa", "kī", "maukati"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("клуч"),
            keywords: &["клуч", "лозинка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ത\u{d3e}ക\u{d4d}കോൽ"),
            keywords: &[
                "ച\u{d3e}വി",
                "ത\u{d3e}ക\u{d4d}കോൽ",
                "രഹസ\u{d4d}യവ\u{d3e}ക\u{d4d}ക\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("түлхүүр"),
            keywords: &["нууц үг", "түлхүүр", "цоож"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चावी"),
            keywords: &["क\u{941}ल\u{942}प", "चावी", "स\u{902}क\u{947}तशब\u{94d}द"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kunci"),
            keywords: &["kata laluan", "kunci"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ċavetta"),
            keywords: &["password", "sakkar", "ċavetta"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("သော\u{1037}"),
            keywords: &[
                "စကားဝ\u{103e}က\u{103a}",
                "သော\u{1037}",
                "သော\u{1037}တ\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("nøkkel"),
            keywords: &["lås", "nøkkel", "passord"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("सा\u{901}चो"),
            keywords: &["ताल\u{94d}चा", "पासवर\u{94d}ड", "सा\u{901}चो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("sleutel"),
            keywords: &["beveiligd", "sleutel", "wachtwoord"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("nøkkel"),
            keywords: &["lås", "nøkkel", "passord"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଚ\u{b3e}ବ\u{b3f}"),
            keywords: &[
                "କୀ",
                "ଚ\u{b3e}ବ\u{b3f}",
                "ପ\u{b3e}ସ\u{b4d}\u{200c}ୱ\u{b3e}ର\u{b4d}ଡ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a41}\u{a70}ਜੀ"),
            keywords: &["ਕ\u{a41}\u{a70}ਜੀ", "ਪਾਸਵਰਡ", "ਲਾਕ", "ਲ\u{a4c}ਕ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کلید"),
            keywords: &["تالا", "پاس ورڈ", "کلید"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kii"),
            keywords: &["Kii", "Lọk", "Páswọd"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("klucz"),
            keywords: &["hasło", "klucz", "zamek", "zamknąć"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کیلي"),
            keywords: &["پاسورډ", "کلپ", "کيلي", "کیلي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("chave"),
            keywords: &["chave", "senha"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["chave", "fechadura", "palavra-passe", "proteção", "senha"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cheie"),
            keywords: &["cheie", "lacăt", "parolă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-717"),
            keywords: &["E10-717"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("ключ"),
            keywords: &["ключ", "пароль"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("urufunguzo"),
            keywords: &["gufunga", "urufunguzo", "urufunguzo rw’ibanga"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("چاٻي"),
            keywords: &["تالو", "پاسورڊ، لاڪ", "چاٻي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("යත\u{dd4}ර"),
            keywords: &["අග\u{dd4}ල", "ම\u{dd4}රපදය", "යත\u{dd4}ර"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kľúč"),
            keywords: &["heslo", "kľúč", "zámka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ključ"),
            keywords: &["geslo", "ključ", "ključavnica"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("fure"),
            keywords: &["baasweydh", "fure", "quful"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("çelës"),
            keywords: &["fjalëkalim", "kyç", "çelës"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кључ"),
            keywords: &["катанац", "кључ", "лозинка"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ključ"),
            keywords: &["katanac", "ključ", "lozinka"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("nyckel"),
            keywords: &["lösenord", "nyckel"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ufunguo"),
            keywords: &["kufuli", "nenosiri", "ufunguo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ச\u{bbe}வி"),
            keywords: &[
                "கடவுச\u{bcd}சொல\u{bcd}",
                "ச\u{bbe}வி",
                "ப\u{bbe}ஸ\u{bcd}வேர\u{bcd}ட\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("త\u{c3e}ళం చ\u{c46}వ\u{c3f}"),
            keywords: &[
                "చ\u{c46}వ\u{c3f}",
                "త\u{c3e}ళం",
                "ప\u{c3e}స\u{c4d}\u{200c}వర\u{c4d}డ\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("калид"),
            keywords: &["калид", "парол", "қулф"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ก\u{e38}ญแจ"),
            keywords: &["ก\u{e38}ญแจ", "รห\u{e31}สผ\u{e48}าน", "ล\u{e47}อค"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("açar"),
            keywords: &["açar", "gulp", "parol"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kī"),
            keywords: &["kī"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("anahtar"),
            keywords: &["anahtar", "kilit", "parola", "şifre"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاچقۇچ"),
            keywords: &["ئاچقۇچ", "قۇلۇپ", "پارول"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("ключ"),
            keywords: &["ключ", "пароль"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چابی"),
            keywords: &["لاک", "پاسورڈ", "چابی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kalit"),
            keywords: &["kalit", "parol", "qulf"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("chìa khóa"),
            keywords: &["chìa khóa", "khóa", "mật khẩu"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("caabi"),
            keywords: &["baatu-jàll", "caabi"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqhosha"),
            keywords: &["iphaswedi", "iqhosha", "tshixa"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("kọ\u{301}kọ\u{301}rọ\u{301}"),
            keywords: &["kọ\u{301}kọ\u{301}rọ\u{301}", "pásìwọdù", "tì"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("鎖匙"),
            keywords: &["密碼", "鎖", "鎖匙"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("锁匙"),
            keywords: &["密码", "锁", "锁匙"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("钥匙"),
            keywords: &["密码", "密钥", "开锁", "解锁", "钥匙"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("鑰匙"),
            keywords: &["密碼", "鎖", "鑰匙"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukhiye"),
            keywords: &["iphasiwedi", "khiya", "ukhiye"],
        },
    ],
};
#[doc = "🗝\u{fe0f}"]
pub const OLD_KEY: crate::Emoji = crate::Emoji {
    glyph: "🗝\u{fe0f}",
    codepoint: "1F5DD FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "old key",
    group: "Objects",
    subgroup: "lock",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🗝",
        codepoint: "1F5DD",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "old key",
        group: "Objects",
        subgroup: "lock",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("ou sleutel"),
            keywords: &["leidraad", "ou sleutel", "oud", "sleutel", "slot"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አሮጌ ቁልፍ"),
            keywords: &["ሽማግሌ", "ቁልፍ", "አሮጌ ቁልፍ", "ፍንጭ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مفتاح قديم"),
            keywords: &["قديم", "قفل", "مفتاح"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9c1}ৰণি চ\u{9be}বি"),
            keywords: &[
                "চ\u{9be}বি",
                "তল\u{9be}",
                "প\u{9c1}ৰণি",
                "শ\u{9c1}ংস\u{9c2}ত\u{9cd}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("köhnə açar"),
            keywords: &["açar", "kilid", "köhnə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("стары ключ"),
            keywords: &["замок", "ключ", "стары"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Стар ключ"),
            keywords: &["Стар ключ", "заключване", "ключ", "стар"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9c1}রোনো চ\u{9be}বি"),
            keywords: &[
                "চ\u{9be}বি",
                "ত\u{9be}ল\u{9be}",
                "প\u{9c1}র\u{9be}নো",
                "প\u{9c1}রোনো চ\u{9be}বি",
                "স\u{9c2}ত\u{9cd}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("alcʼhwez kozh"),
            keywords: &["alcʼhwez", "kozh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("stari ključ"),
            keywords: &["katanac", "ključ", "stari ključ", "trag"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("clau antiga"),
            keywords: &["antiga", "clau", "tancar"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏪᏘ ᏍᏚᎢᏍᏗ"),
            keywords: &["ᎠᏓᏃᎯᏎᎯ", "ᎤᏪᏘ", "ᎦᏐᎾᎳᏛᎢ", "ᏍᏚᎢᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("starý klíč"),
            keywords: &["dózický", "klíč", "starý", "stopa", "zámek"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("hen allwedd"),
            keywords: &["allwedd", "cliw", "cloi", "hen"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("gammel nøgle"),
            keywords: &["gammel", "lås", "nøgle"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("alter Schlüssel"),
            keywords: &["Schlüssel", "alt", "alter Schlüssel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("παλιό κλειδί"),
            keywords: &["κλειδί", "κλειδώνω", "παλιό", "στοιχείο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("old key"),
            keywords: &["clue", "key", "lock", "old"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("llave antigua"),
            keywords: &["antigua", "llave"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("vana võti"),
            keywords: &["lukk", "vana", "võti"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("giltza zaharra"),
            keywords: &[
                "blokeo",
                "giltza",
                "giltza zaharra",
                "itxi",
                "pista",
                "zahar",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کلید قدیمی"),
            keywords: &["سرنخ", "قدیمی", "قفل", "کلید"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vanha avain"),
            keywords: &["avain", "lukko", "vanha", "vihje"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lumang susi"),
            keywords: &["lumang susi", "naka-encrypt", "naka-lock", "susi"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("gamal lykil"),
            keywords: &["gamal lykil", "lykil", "lás"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("clé ancienne"),
            keywords: &["clé", "clé ancienne", "serrure"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("sean-eochair"),
            keywords: &["eochair", "leid", "loc", "sean", "sean-eochair"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("iuchair seann-nòsach"),
            keywords: &[
                "glais",
                "glas",
                "iuchair",
                "iuchair seann-nòsach",
                "oidheam",
                "sean",
                "seann",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("chave antiga"),
            keywords: &["antiga", "chave"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("જ\u{ac2}ની ચાવી"),
            keywords: &["કળ", "જ\u{ac2}ની ચાવી", "તાળ\u{ac1}\u{a82}"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("tsohon makulli"),
            keywords: &["kulle", "makulli", "matashiya", "tsoho", "tsohon makulli"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מפתח ישן"),
            keywords: &["ישן", "לנעול", "מפתח", "רמז"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{941}रानी चाबी"),
            keywords: &[
                "ताला",
                "प\u{941}राना",
                "प\u{941}रानी चाबी",
                "स\u{902}क\u{947}त",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("starinski ključ"),
            keywords: &["brava", "ključ", "starina", "starinski ključ", "znak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("régi kulcs"),
            keywords: &["régi kulcs", "öreg kulcs"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("հին բանալի"),
            keywords: &["բանալի", "կողպեք", "հին"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kunci antik"),
            keywords: &["antik", "gembok", "kunci", "petunjuk"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ochie ọtụgwo"),
            keywords: &["kpọchie", "mmata", "ochie", "ọtụgwo"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("gamall lykill"),
            keywords: &["gamall", "lykill", "lás", "vísbending"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("chiave antica"),
            keywords: &["chiave", "chiave antica", "chiudere a chiave", "serratura"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("古い鍵"),
            keywords: &["キー", "パスワード", "古い鍵", "手がかり"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kunci kuna"),
            keywords: &["gembok", "kuna", "kunci", "pituduh"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ძველი გასაღები"),
            keywords: &["გასაღები", "საკეტი", "ძველი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ескі кілт"),
            keywords: &["ескі", "кілт", "негізгі кілт", "құлып"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("gammel nøgle"),
            keywords: &["gammel", "lås", "nøgle"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សោប\u{17bb}រាណ"),
            keywords: &[
                "ក\u{17bc}នសោ",
                "ចាស\u{17cb}",
                "តម\u{17d2}រ\u{17bb}យ",
                "សោ",
                "សោប\u{17bb}រាណ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹಳ\u{cc6}ಯ ಕೀ"),
            keywords: &["ಲಾಕ\u{ccd}", "ಸಲಹ\u{cc6}", "ಹಳ\u{cc6}ಯ", "ಹಳ\u{cc6}ಯ ಕೀ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("오래된 열쇠"),
            keywords: &["보물 열쇠", "열쇠", "오래된 열쇠"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पोरणी चावी"),
            keywords: &[
                "क\u{941}लप",
                "चावी",
                "पोरणी चावी",
                "पोरण\u{947}\u{902}",
                "स\u{902}क\u{947}त",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("эски ачкыч"),
            keywords: &["ачкыч", "кулпу", "эски"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("ale Schlëssel"),
            keywords: &["Hiwäis", "Schlass", "Schlëssel", "al", "ale Schlëssel"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{eb9}ກກະແຈເກ\u{ebb}\u{ec8}າ"),
            keywords: &[
                "ລ\u{eb1}ອກ",
                "ລ\u{eb9}ກກະແຈ",
                "ລ\u{eb9}ກກະແຈເກ\u{ebb}\u{ec8}າ",
                "ເກ\u{ebb}\u{ec8}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("senas raktas"),
            keywords: &["raktas", "sena", "senas raktas", "spyna"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("veca atslēga"),
            keywords: &["atrisinājums", "atslēga", "veca atslēga"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kī tawhito"),
            keywords: &["kī", "maukati", "tawhito", "tīwhiri"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("стар клуч"),
            keywords: &["клуч", "стар"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പഴയ ത\u{d3e}ക\u{d4d}കോൽ"),
            keywords: &[
                "കീ",
                "ത\u{d3e}ക\u{d4d}കോൽ",
                "തെളിവ\u{d4d}",
                "പഴയ ത\u{d3e}ക\u{d4d}കോൽ",
                "പഴയത\u{d4d}",
                "പ\u{d42}ട\u{d4d}ട\u{d4d}",
                "ലോക\u{d4d}ക\u{d4d}",
                "സ\u{d42}ചന",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хуучин түлхүүр"),
            keywords: &["түлхүүр", "хуучин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ज\u{941}नी चावी"),
            keywords: &[
                "क\u{941}ल\u{942}प",
                "चावी",
                "ज\u{941}नी चावी",
                "स\u{902}क\u{947}त",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kunci lama"),
            keywords: &["kunci", "lama", "mengunci", "petunjuk"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ċavetta qadima"),
            keywords: &["antik", "sakkar", "ċavetta", "ċavetta qadima", "ħjiel"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("သော\u{1037}ဟောင\u{103a}း"),
            keywords: &[
                "သော\u{1037}",
                "သော\u{1037}တ\u{1036} အဟောင\u{103a}း",
                "သော\u{1037}ဟောင\u{103a}း",
                "သ\u{1032}လ\u{103d}န\u{103a}စ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("gammeldags nøkkel"),
            keywords: &["gammel", "gammeldags nøkkel", "ledetråd", "lås", "nøkkel"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{941}रानो सा\u{901}चो"),
            keywords: &[
                "ताल\u{94d}चा",
                "प\u{941}रानो",
                "स\u{902}क\u{947}त",
                "सा\u{901}चो",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("oude sleutel"),
            keywords: &["aanwijzing", "oud", "oude sleutel", "sleutel", "slot"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("gamaldags nøkkel"),
            keywords: &["gamal", "gamaldags nøkkel", "leietråd", "lås", "nøkkel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b41}ର\u{b41}ଣ\u{b3e} ଚ\u{b3e}ବ\u{b3f}"),
            keywords: &[
                "ଚ\u{b3e}ବ\u{b3f}",
                "ତ\u{b3e}ଲ\u{b3e}",
                "ପ\u{b41}ର\u{b41}ଣ\u{b3e}",
                "ରହସ\u{b4d}ୟ ଉଦ\u{b4d}\u{200c}ଘ\u{b3e}ଟନର ସ\u{b42}ତ\u{b4d}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a41}ਰਾਣੀ ਕ\u{a41}\u{a70}ਜੀ"),
            keywords: &[
                "ਕ\u{a41}\u{a70}ਜੀ",
                "ਪ\u{a41}ਰਾਣਾ",
                "ਪ\u{a41}ਰਾਣੀ ਕ\u{a41}\u{a70}ਜੀ",
                "ਲਾਕ",
                "ਲ\u{a4c}ਕ",
                "ਸ\u{a41}ਰਾਗ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پرانی کنجی"),
            keywords: &["اتا پتا", "تالا", "پرانا", "پرانی کنجی", "کلید"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Óld Kii"),
            keywords: &["Kii", "Lọk", "Old", "Sabí", "Óld Kii"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("staroświecki klucz"),
            keywords: &[
                "klucz",
                "kłódka",
                "staroświecki klucz",
                "stary",
                "zamek",
                "zamknąć",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("زاړه کیلي"),
            keywords: &["اشاره", "زاړه کیلي", "زوړ", "کلپ", "کيلي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("chave antiga"),
            keywords: &["antiga", "chave", "fechadura"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["antiga", "chave antiga", "fechadura", "pista"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cheie veche"),
            keywords: &["cheie", "cheie veche", "indiciu", "vechime"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-823"),
            keywords: &["E10-823"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("старинный ключ"),
            keywords: &["замок", "ключ", "старинный", "старый"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("urufunguzo rwa kera"),
            keywords: &[
                "gishaje",
                "gufunga",
                "ikimenyetso",
                "urufunguzo",
                "urufunguzo rwa kera",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پراڻي چاٻي"),
            keywords: &["اشارو", "تالو", "پراڻو", "پراڻي چاٻي", "چاٻي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පැරණ\u{dd2} යත\u{dd4}ර"),
            keywords: &[
                "අග\u{dd4}ල",
                "පැරණ\u{dd2}",
                "යත\u{dd4}ර",
                "හෝඩ\u{dd4}ව\u{dcf}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("starý kľúč"),
            keywords: &["kľúč", "staré", "starý kľúč", "vodidlo", "zámka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("star ključ"),
            keywords: &["ključ", "ključavnica", "namig", "star ključ", "staro"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("fure qadiimi ah"),
            keywords: &["fure", "fure qadiimi ah", "qadiimi", "quful", "tilmaan yar"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("çelës i vjetër"),
            keywords: &["i vjetër", "ide", "kyç", "çelës", "çelës i vjetër"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("стари кључ"),
            keywords: &["катанац", "кључ", "стари кључ", "старо"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["стари кључ"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("stari ključ"),
            keywords: &["katanac", "ključ", "stari ključ", "staro"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["stari ključ"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("gammal nyckel"),
            keywords: &["gammal nyckel", "nyckel"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ufunguo wa zamani"),
            keywords: &["dalili", "kufuli", "nzee", "ufunguo", "ufunguo wa zamani"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பழையச\u{bcd} ச\u{bbe}வி"),
            keywords: &[
                "குறிப\u{bcd}பு",
                "ச\u{bbe}வி",
                "பழையச\u{bcd} ச\u{bbe}வி",
                "பழையது",
                "பூட\u{bcd}டு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c3e}తక\u{c3e}లం త\u{c3e}ళం చ\u{c46}వ\u{c3f}"),
            keywords: &[
                "క\u{c4d}లూ",
                "త\u{c3e}ళం చ\u{c46}వ\u{c3f}",
                "ప\u{c3e}తక\u{c3e}లం",
                "ప\u{c3e}తక\u{c3e}లం త\u{c3e}ళం చ\u{c46}వ\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("калиди куҳна"),
            keywords: &["калид", "калиди куҳна", "куҳна", "қулф"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ก\u{e38}ญแจเก\u{e48}า"),
            keywords: &[
                "ก\u{e38}ญแจ",
                "ก\u{e38}ญแจเก\u{e48}า",
                "ล\u{e47}อค",
                "เก\u{e48}า",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("köne açar"),
            keywords: &["açar", "gulp", "köne", "ýelim"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kī motuʻa"),
            keywords: &["kī motuʻa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("eski anahtar"),
            keywords: &["anahtar", "eski", "ipucu", "kilit"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كونا ئاچقۇچ"),
            keywords: &["ئاچقۇچ", "قۇلۇپ", "كونا", "يىپ ئۇچى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("старовинний ключ"),
            keywords: &[
                "cтаровинний ключ",
                "замок",
                "ключ",
                "підказка",
                "старий",
                "старовинний ключ",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پرانی چابی"),
            keywords: &["لاک", "پاسورڈ", "پرانا", "پرانی چابی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qadimiy kalit"),
            keywords: &["eski", "kalit", "qadimiy", "qulf"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("chìa khóa cũ"),
            keywords: &["chìa khóa", "chìa khóa cũ", "cũ", "khóa", "đầu mối"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("caabi ju yàgg"),
            keywords: &["caabi", "caabi ju yàgg", "màgget", "tegtal"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqhosha elidala"),
            keywords: &["endala", "icebiso", "iqhosha", "iqhosha elidala", "tshixa"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("kó\u{329}kọ\u{301}ró\u{329} àtijó\u{329}"),
            keywords: &[
                "kó\u{329}kọ\u{301}ró\u{329} àtijó\u{329}",
                "kọ\u{301}kọ\u{301}ró\u{329}",
                "olobó",
                "títì",
                "àtijó\u{329}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("舊鎖匙"),
            keywords: &["提示", "舊", "舊鎖匙", "鎖", "鎖匙"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("旧锁匙"),
            keywords: &["提示", "旧", "旧锁匙", "锁", "锁匙"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("老式钥匙"),
            keywords: &["古老的钥匙", "旧钥匙", "老式钥匙", "钥匙"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("老鑰匙"),
            keywords: &["老鑰匙", "鑰匙"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("舊鎖匙"),
            keywords: &["舊鎖匙", "舊鎖匙｜鎖匙"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukhiye omdala"),
            keywords: &[
                "khiya",
                "okudala",
                "okukukhanyiselayo",
                "ukhiye",
                "ukhiye omdala",
            ],
        },
    ],
};
