#[doc = "🎥"]
pub const MOVIE_CAMERA: crate::Emoji = crate::Emoji {
    glyph: "🎥",
    codepoint: "1F3A5",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "movie camera",
    group: "Objects",
    subgroup: "light & video",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("rolprentkamera"),
            keywords: &["bioskoop", "fliek", "kamera", "rolprent", "rolprentkamera"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የፊልም ካሜራ"),
            keywords: &["ሲኒማ", "ካሜራ", "የፊልም ካሜራ", "ፊልም"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كاميرا أفلام"),
            keywords: &["سينما", "فيلم", "كاميرا", "كاميرا أفلام"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চলচিত\u{9cd}ৰৰ কেমেৰ\u{9be}"),
            keywords: &[
                "কেমেৰ\u{9be}",
                "চলচিত\u{9cd}ৰ",
                "চলচিত\u{9cd}ৰৰ কেমেৰ\u{9be}",
                "চিনেম\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kino kamerası"),
            keywords: &["film", "kamera", "kino", "kino kamerası"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кінакамера"),
            keywords: &["камера", "кінакамера", "кіно", "фільм"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Филмова камера"),
            keywords: &["Филмова камера", "камера", "кино", "филмова"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9c1}ভি ক\u{9cd}য\u{9be}মের\u{9be}"),
            keywords: &["ক\u{9cd}য\u{9be}মের\u{9be}", "ম\u{9c1}ভি", "সিনেম\u{9be}"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kamera"),
            keywords: &["kamera", "sinema"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kamera"),
            keywords: &["film", "kamera", "kino"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("càmera cinematogràfica"),
            keywords: &["cinema", "càmera", "càmera cinematogràfica"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄟\u{1112a}𑄞\u{11128} 𑄇𑄬𑄟𑄬𑄢"),
            keywords: &["𑄟\u{1112a}𑄞\u{11128} 𑄇𑄬𑄟𑄬𑄢"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏗᏴᎳᏛᏍᎩ ᏗᏓᏟᎶᏍᏗᏍᎩ"),
            keywords: &["ᎠᏗᏴᎳᏛᏍᎩ", "ᎠᏗᏴᎳᏛᏍᎩ ᏗᏓᏟᎶᏍᏗᏍᎩ", "ᏗᏟᎶᏍᏗᏍᎩ", "ᏧᎾᏗᏴᎳᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("filmová kamera"),
            keywords: &["film", "filmová", "kamera", "kino"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("camera ffilm"),
            keywords: &["camera", "ffilm", "sinema"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("filmkamera"),
            keywords: &["biograf", "film", "filme", "filmkamera"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Filmkamera"),
            keywords: &["Film", "Filmkamera", "Kino", "Unterhaltung"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κινηματογραφική κάμερα"),
            keywords: &[
                "βιντεοκάμερα",
                "κινηματογράφος",
                "κινηματογραφική κάμερα",
                "ταινία",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("movie camera"),
            keywords: &["camera", "cinema", "movie"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("film camera"),
            keywords: &["camera", "cinema", "film", "movie"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("movie camera"),
            keywords: &["camera", "cinema", "movie"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("movie camera"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cámara de cine"),
            keywords: &[
                "cine",
                "cámara",
                "cámara de cine",
                "entretenimiento",
                "película",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("filmadora"),
            keywords: &["cine", "cámara", "entretenimiento", "filmadora", "película"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cámara de video"),
            keywords: &["cámara de video"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cámara de filmar"),
            keywords: &[
                "cine",
                "cámara",
                "cámara de filmar",
                "entretenimiento",
                "película",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("filmikaamera"),
            keywords: &["film", "filmikaamera", "kaamera", "video"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bideokamera profesionala"),
            keywords: &["bideokamera profesionala", "film", "kamera", "zinema"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دوربین سینمایی"),
            keywords: &["دوربین", "دوربین سینمایی", "سینما", "فیلم"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("elokuvakamera"),
            keywords: &["elokuva", "elokuvakamera", "kamera", "kuvaukset"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("movie camera"),
            keywords: &["camera", "cinema", "movie camera", "palabas"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("filmstól"),
            keywords: &["biografur", "filmstól", "filmur", "upptøkutól"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("caméra"),
            keywords: &["caméra", "cinéma", "film"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ceamara scannáin"),
            keywords: &[
                "ceamara",
                "ceamara scannáin",
                "cinecheamara",
                "scannán",
                "siamsaíocht",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("camara-film"),
            keywords: &["camara", "camara-film", "film", "taigh-dhealbh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cámara cinematográfica"),
            keywords: &[
                "cine",
                "cámara cinematográfica",
                "filmar",
                "filme",
                "película",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મ\u{ac2}વીનો ક\u{ac5}મ\u{ac7}રો"),
            keywords: &[
                "મનોર\u{a82}જન",
                "મ\u{ac2}વી",
                "મ\u{ac2}વી ક\u{ac5}મ\u{ac7}રા",
                "મ\u{ac2}વીનો ક\u{ac5}મ\u{ac7}રો",
                "સિન\u{ac7}મા",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kyamarar fim"),
            keywords: &["fim", "kyamara", "kyamarar fim", "silima"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מצלמת קולנוע"),
            keywords: &["מצלמה", "מצלמת קולנוע", "סרט", "צילום", "קולנוע"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("म\u{942}वी क\u{948}मरा"),
            keywords: &[
                "क\u{948}मरा",
                "फ\u{93c}िल\u{94d}म",
                "म\u{942}वी",
                "सिन\u{947}मा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("filmska kamera"),
            keywords: &["film", "filmska kamera", "kamera", "kino"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kamera"),
            keywords: &["felvevő", "film", "kamera", "mozi"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ժապավենային տեսախցիկ"),
            keywords: &["ժապավենային տեսախցիկ", "կինո", "տեսախցիկ", "ֆիլմ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kamera film"),
            keywords: &["film", "kamera", "sinema"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihe nkiri igwefòto"),
            keywords: &[
                "igwefòto",
                "ihe nkiri",
                "ihe nkiri igwefòto",
                "ụlọ ihe nkiri",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kvikmyndatökuvél"),
            keywords: &["bíó", "kvikmynd", "kvikmyndatökuvél", "skemmtun"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cinepresa"),
            keywords: &[
                "cinema",
                "cinepresa",
                "film",
                "intrattenimento",
                "telecamera",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("映画カメラ"),
            keywords: &["カメラ", "ムービー", "映画", "映画カメラ"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kamera film"),
            keywords: &["film", "kamera", "sinema"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კინოკამერა"),
            keywords: &["კამერა", "კინო", "კინოთეატრი", "კინოკამერა"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("takamirat"),
            keywords: &["takamirat"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бейнефильм түсіретін камера"),
            keywords: &["бейнефильм түсіретін камера", "камера", "кино", "фильм"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("filmkamera"),
            keywords: &["biograf", "filme", "filmkamera"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កាមេរ\u{17c9}ាថតក\u{17bb}ន"),
            keywords: &[
                "កាមេរ\u{17c9}ា",
                "កាមេរ\u{17c9}ាថតក\u{17bb}ន",
                "ថតក\u{17bb}ន",
                "ភាពយន\u{17d2}ត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮ\u{cc2}ವೀ ಕ\u{ccd}ಯಾಮರಾ"),
            keywords: &[
                "ಕ\u{ccd}ಯಾಮರಾ",
                "ಮನರಂಜನ\u{cc6}",
                "ಮ\u{cc2}ವೀ",
                "ಸ\u{cbf}ನ\u{cbf}ಮಾ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("영화 카메라"),
            keywords: &["영화 카메라", "촬영", "카메라 촬영"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("म\u{941}व\u{94d}ही क\u{945}म\u{947}रा"),
            keywords: &["क\u{945}म\u{947}रा", "म\u{941}व\u{94d}ही", "सिन\u{947}मा"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тасма камерасы"),
            keywords: &["камера", "кинотеатр", "тасма", "тасма камерасы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Kamera"),
            keywords: &["Film", "Kamera", "Kino"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກ\u{ec9}ອງຖ\u{ec8}າຍຮ\u{eb9}ບເງ\u{ebb}າ"),
            keywords: &[
                "ກ\u{ec9}ອງ",
                "ກ\u{ec9}ອງຖ\u{ec8}າຍຮ\u{eb9}ບເງ\u{ebb}າ",
                "ຮ\u{eb9}ບເງ\u{ebb}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("filmavimo kamera"),
            keywords: &["filmas", "filmavimo kamera", "kamera", "kinas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kinokamera"),
            keywords: &["filma", "kamera", "kino", "kinokamera"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pū hopuata"),
            keywords: &["kāmera", "pū hopuata", "whare whitiāhua", "whitiāhua"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("филмска камера"),
            keywords: &["камера", "кино", "филм", "филмска камера"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മ\u{d42}വി ക\u{d4d}യ\u{d3e}മറ"),
            keywords: &["ക\u{d4d}യ\u{d3e}മറ", "മ\u{d42}വി", "വിനോദം", "സിനിമ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("киноны камер"),
            keywords: &["камер", "кино", "кино театр", "киноны камер"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चित\u{94d}रपटाचा क\u{945}म\u{947}रा"),
            keywords: &[
                "चित\u{94d}रपट",
                "चित\u{94d}रपटाचा क\u{945}म\u{947}रा",
                "मनोर\u{902}जन",
                "म\u{942}व\u{94d}ही क\u{945}म\u{947}रा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kamera filem"),
            keywords: &["filem", "kamera", "pawagam"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kamera tal-films"),
            keywords: &["filmat", "kamera", "kamera tal-films", "ċinema"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ရ\u{102f}ပ\u{103a}ရ\u{103e}င\u{103a} ကင\u{103a}မရာ"),
            keywords: &[
                "ကင\u{103a}မရာ",
                "ရ\u{102f}ပ\u{103a}ရ\u{103e}င\u{103a}",
                "ရ\u{102f}ပ\u{103a}ရ\u{103e}င\u{103a}ရ\u{102f}\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("filmkamera"),
            keywords: &["film", "filmkamera", "kamera", "kino", "underholdning"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("म\u{941}भी क\u{94d}याम\u{947}रा"),
            keywords: &[
                "क\u{94d}याम\u{947}रा",
                "चलचित\u{94d}र",
                "म\u{941}भी क\u{94d}याम\u{947}रा",
                "सिन\u{947}मा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("filmcamera"),
            keywords: &["bioscoop", "camera", "film", "filmcamera"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("filmkamera"),
            keywords: &["film", "filmkamera", "kamera", "kino", "underhaldning"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମ\u{b41}ଭ\u{b3f} କ\u{b4d}ୟ\u{b3e}ମେର\u{b3e}"),
            keywords: &[
                "କ\u{b4d}ୟ\u{b3e}ମେର\u{b3e}",
                "ଚଳଚ\u{b4d}ଚ\u{b3f}ତ\u{b4d}ର",
                "ମ\u{b41}ଭ\u{b3f} କ\u{b4d}ୟ\u{b3e}ମେର\u{b3e}",
                "ସ\u{b3f}ନେମ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a42}ਵੀ ਕ\u{a48}ਮਰਾ"),
            keywords: &[
                "ਫਿਲਮ",
                "ਫਿਲਮ ਕ\u{a48}ਮਰਾ",
                "ਮਨ\u{a4b}ਰ\u{a70}ਜਨ",
                "ਮ\u{a42}ਵੀ ਕ\u{a48}ਮਰਾ",
                "ਸਿਨ\u{a47}ਮਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مووی کیمرہ"),
            keywords: &["سینما", "فلم", "مووی کیمرہ", "کیمرہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Múví Kámẹ\u{301}ra"),
            keywords: &[
                "Fim",
                "Kámẹ\u{301}ra",
                "Múvi",
                "Múví Kámẹ\u{301}ra",
                "Sinẹmá",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kamera filmowa"),
            keywords: &["film", "kamera", "kamera filmowa", "kinematografia", "kino"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د فلم کامره"),
            keywords: &["د فلم کامره", "سنيما", "فلم", "کامره"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("câmera de cinema"),
            keywords: &[
                "cinema",
                "câmera",
                "câmera de cinema",
                "entretenimento",
                "filme",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("câmara de filmar"),
            keywords: &["cinema", "câmara", "câmara de filmar", "filme"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("camara cinepaq"),
            keywords: &["camara cinepaq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("aparat de filmat"),
            keywords: &["aparat de filmat", "cinema", "film", "filmare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-357"),
            keywords: &["E10-357"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("кинокамера"),
            keywords: &[
                "видеокамера",
                "камера",
                "кино",
                "кинокамера",
                "снять",
                "съемка",
                "фильм",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("kamera ifata videwo"),
            keywords: &[
                "19900",
                "amashusho agenda",
                "kamera",
                "kamera ifata videwo",
                "sinema",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مووي ڪئيمرا"),
            keywords: &["سينيما", "فلم", "مووي ڪئيمرا", "ڪئميرا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ච\u{dd2}ත\u{dca}\u{200d}රපට කැමර\u{dcf}ව"),
            keywords: &[
                "කැමර\u{dcf}ව",
                "ච\u{dd2}ත\u{dca}\u{200d}රපට",
                "ස\u{dd2}නම\u{dcf}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("filmová kamera"),
            keywords: &["film", "filmová kamera", "kamera", "kino"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("filmska kamera"),
            keywords: &["film", "filmska kamera", "kamera", "kino"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kamarada filimada"),
            keywords: &["kamarad", "kamarada filimada", "sinimoo"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kamerë filmi"),
            keywords: &["film", "kamerë", "kamerë filmi", "kinema"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("филмска камера"),
            keywords: &["биоскоп", "камера", "филм", "филмска камера"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["филмска камера"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("filmska kamera"),
            keywords: &["bioskop", "film", "filmska kamera", "kamera"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["filmska kamera"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("filmkamera"),
            keywords: &["film", "filmkamera", "spela in film"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kamera ya kurekodi filamu"),
            keywords: &["filamu", "kamera", "kamera ya kurekodi filamu", "sinema"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மூவி கேமர\u{bbe}"),
            keywords: &[
                "சினிம\u{bbe}",
                "திரைப\u{bcd}படம\u{bcd}",
                "பொழுதுபோக\u{bcd}கு",
                "மூவி கேமர\u{bbe}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c3f}న\u{c3f}మ\u{c3e} క\u{c46}మ\u{c46}ర\u{c3e}"),
            keywords: &[
                "చలనచ\u{c3f}త\u{c4d}రం",
                "వ\u{c3f}న\u{c4b}దం",
                "వ\u{c40}డ\u{c3f}య\u{c4b} క\u{c46}మ\u{c46}ర\u{c3e}",
                "షూట\u{c3f}ంగ\u{c4d}",
                "స\u{c3f}న\u{c3f}మ\u{c3e}",
                "స\u{c3f}న\u{c3f}మ\u{c3e} క\u{c46}మ\u{c46}ర\u{c3e}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("камераи киногирӣ"),
            keywords: &["камера", "камераи киногирӣ", "кино", "синамо"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("กล\u{e49}องถ\u{e48}ายภาพยนตร\u{e4c}"),
            keywords: &[
                "กล\u{e49}อง",
                "กล\u{e49}องถ\u{e48}ายภาพยนตร\u{e4c}",
                "ภาพยนตร\u{e4c}",
                "หน\u{e31}ง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kinokamera"),
            keywords: &["kamera", "kino", "kinokamera", "kinoteatr"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("faitā heleʻuhila"),
            keywords: &["faitā heleʻuhila"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("film kamerası"),
            keywords: &["eğlence", "film", "film kamerası", "sinema"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كىنو كامېراسى"),
            keywords: &["كامېرا", "كىنو", "كىنو كامېراسى", "كىنوخانا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кінокамера"),
            keywords: &["камера", "кіно", "кінокамера", "фільм"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مووی کیمرا"),
            keywords: &["سینما", "فلم", "مووی کیمرا", "کیمرا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kinokamera"),
            keywords: &["film", "kamera", "kino", "kinokamera"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("máy quay phim"),
            keywords: &["máy quay phim", "phim", "rạp chiếu phim"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kameraa filmu"),
            keywords: &["filmu", "kameraa filmu", "nataalukaay", "sinemaa"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ikhamera yemuvi"),
            keywords: &["ikhamera", "ikhamera yemuvi", "imuvi", "isinema"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("kamẹra fíìmù"),
            keywords: &["fíìmù", "kamẹra fíìmù", "kámé\u{329}rà", "sinimá"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("電影攝影機"),
            keywords: &["戲院", "相機", "電影", "電影攝影機"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("电影摄影机"),
            keywords: &["戏院", "电影", "电影摄影机", "相机"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("电影摄影机"),
            keywords: &["摄像机", "摄录机", "摄影", "摄影机", "电影", "电影摄影机"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("電影攝影機"),
            keywords: &["攝影機", "電影攝影機"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ikhamera yamamuvi"),
            keywords: &["icinema", "ikhamera", "ikhamera yamamuvi", "imuvi"],
        },
    ],
};
#[doc = "🎞\u{fe0f}"]
pub const FILM_FRAMES: crate::Emoji = crate::Emoji {
    glyph: "🎞\u{fe0f}",
    codepoint: "1F39E FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "film frames",
    group: "Objects",
    subgroup: "light & video",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🎞",
        codepoint: "1F39E",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "film frames",
        group: "Objects",
        subgroup: "light & video",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("filmraampies"),
            keywords: &["bioskoop", "filmraampies", "fliek", "raam", "rolprent"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የፊልም ፍሬሞች"),
            keywords: &["ሲኒማ", "የፊልም ፍሬሞች", "ፊልም"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شريط سينمائي"),
            keywords: &["إطارات", "سينما", "شريط سينمائي", "فيلم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ফিল\u{9cd}ম ফ\u{9cd}ৰেইম"),
            keywords: &[
                "চলচিত\u{9cd}ৰ",
                "চিনেম\u{9be}",
                "ফিল\u{9cd}ম",
                "ফ\u{9cd}ৰেইম",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("film kadrları"),
            keywords: &["film", "film kadrları", "kadr", "kino"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кінаплёнка"),
            keywords: &["кадры", "кінаплёнка", "кіно", "плёнка", "фільм"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Филмови кадри"),
            keywords: &["Филмови кадри", "кадри", "кино", "лента", "филм"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ফিল\u{9cd}মের ফ\u{9cd}রেম"),
            keywords: &[
                "ফিল\u{9cd}ম",
                "ফিল\u{9cd}মের ফ\u{9cd}রেম",
                "ফ\u{9cd}রেম",
                "ম\u{9c1}ভি",
                "সিনেম\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kocʼhenn"),
            keywords: &["film", "kocʼhenn", "sinema"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kadar"),
            keywords: &["film", "kadar", "kino"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("fotograma de pel·lícula"),
            keywords: &[
                "cinema",
                "fotograma",
                "fotograma de pel·lícula",
                "pel·lícula",
            ],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄜\u{11128}𑄣\u{11134}𑄟\u{11134} 𑄜\u{11133}𑄢𑄬𑄟\u{11134}𑄌\u{11134}"),
            keywords: &["𑄜\u{11128}𑄣\u{11134}𑄟\u{11134} 𑄜\u{11133}𑄢𑄬𑄟\u{11134}𑄌\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏗᏴᎳᏗᏍᎩ ᎦᏟᏙᏗ"),
            keywords: &["ᎠᏗᏴᎳᏗᏍᎩ", "ᎦᏟᏙᏗ", "ᏗᎾᏗᏴᎳᏛᏍᎬ", "ᏗᏓᏴᎳᏛᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("filmová okénka"),
            keywords: &[
                "film",
                "filmová okénka",
                "kino",
                "okénka",
                "políčka",
                "surovina",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("fframiau ffilm"),
            keywords: &["ffilm", "fframiau", "sinema"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("filmstrimmel"),
            keywords: &["biograf", "film", "filmstrimmel", "strimmel"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Filmstreifen"),
            keywords: &["Film", "Filmband", "Filmstreifen", "Kino"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καρέ φιλμ"),
            keywords: &["καρέ", "κινηματογράφος", "ταινία", "φιλμ"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("film frames"),
            keywords: &["cinema", "film", "frames", "movie"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("fotograma de película"),
            keywords: &["cine", "fotograma", "fotograma de película", "película"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cuadros de película"),
            keywords: &["cine", "cuadros de película", "película"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("fotograma"),
            keywords: &["cine", "fotograma", "película"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("filmikaadrid"),
            keywords: &["film", "filmikaadrid", "kaadrid", "video"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("filmeko fotogramak"),
            keywords: &["film", "filmeko fotogramak", "fotograma", "zinema"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("حلقه\u{654} فیلم"),
            keywords: &["حلقه\u{654} فیلم", "سینما", "فریم", "فیلم"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("filminauha"),
            keywords: &["elokuva", "filminauha", "filmirulla"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("frame ng film"),
            keywords: &[
                "cinema",
                "frame ng film",
                "mga frame",
                "palabas",
                "pelikula",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("filmstrimmil"),
            keywords: &["biografur", "filmstrimmil", "filmur", "stakmynd"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("pellicule"),
            keywords: &["bande", "cinéma", "film", "pellicule"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("frámaí scánnáin"),
            keywords: &["cineama", "frámaí", "frámaí scánnáin", "scannán"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("frèamaichean film"),
            keywords: &["film", "frèam", "frèamaichean film", "taigh-dhealbh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("fotograma de película"),
            keywords: &[
                "cine",
                "fotograma",
                "fotograma de película",
                "negativo",
                "película",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ફિલ\u{acd}મ ફ\u{acd}ર\u{ac7}મ\u{acd}સ"),
            keywords: &[
                "ફિલ\u{acd}મ",
                "ફ\u{acd}ર\u{ac7}મ\u{acd}સ",
                "મ\u{ac2}વી",
                "સિન\u{ac7}મા",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("firem-firem na fim"),
            keywords: &["fim", "firem-firem", "firem-firem na fim", "silima"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פילם"),
            keywords: &["סרט", "פילם", "צילום", "קולנוע"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("फ\u{93c}िल\u{94d}म फ\u{93c}\u{94d}र\u{947}म"),
            keywords: &[
                "फ\u{93c}िल\u{94d}म",
                "फ\u{93c}िल\u{94d}म फ\u{93c}\u{94d}र\u{947}म",
                "म\u{942}वी",
                "सिन\u{947}मा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("filmska vrpca"),
            keywords: &["film", "filmska vrpca", "kadrovi", "kino"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("filmkockák"),
            keywords: &[
                "film",
                "filmkockák",
                "filmtekercs",
                "kocka",
                "kockák",
                "mozi",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տեսաժապավեն"),
            keywords: &["ժապավեն", "կադր", "կինո", "տեսաժապավեն", "ֆիլմ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("frame film"),
            keywords: &["film", "frame", "sinema"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("fremụ ihe nkiri gasị"),
            keywords: &[
                "fremụ gasi",
                "fremụ ihe nkiri gasị",
                "ihe nkiri",
                "ụlọ ihe nkiri",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kvikmyndafilma"),
            keywords: &[
                "bíómynd",
                "kvikmynd",
                "kvikmyndafilma",
                "kvikmyndalist",
                "rammi",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pellicola cinematografica"),
            keywords: &[
                "cinema",
                "film",
                "fotogrammi",
                "fotogrammi di film",
                "pellicola",
                "pellicola cinematografica",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("映画フィルム"),
            keywords: &["フィルム", "フレーム", "ムービー", "映画", "映画フィルム"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("klise film"),
            keywords: &["film", "klise", "sinema"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კადრები"),
            keywords: &["კადრები", "კინო", "კინოთეატრი", "ფილმი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("фильм кадрлары"),
            keywords: &["бейне", "кадр", "кино", "фильм", "фильм кадрлары"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("filmstrimmel"),
            keywords: &["biograf", "film", "filmstrimmel", "strimmel"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ហ\u{17d2}វ\u{17b8}លភាពយន\u{17d2}ត"),
            keywords: &[
                "ភាពយន\u{17d2}ត",
                "ហ\u{17d2}វ\u{17b8}ល",
                "ហ\u{17d2}វ\u{17b8}លភាពយន\u{17d2}ត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಚ\u{cbf}ತ\u{ccd}ರ ಚ\u{ccc}ಕಟ\u{ccd}ಟುಗಳು"),
            keywords: &[
                "ಆಚರಣ\u{cc6}",
                "ಚ\u{cbf}ತ\u{ccd}ರ ಚ\u{ccc}ಕಟ\u{ccd}ಟುಗಳು",
                "ಫ\u{ccd}ರೇಮ\u{ccd}\u{200c}ಗಳು",
                "ಮ\u{cc2}ವೀ",
                "ಸ\u{cbf}ನ\u{cbf}ಮಾ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("영화 프레임"),
            keywords: &["영화", "영화 프레임", "필름"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("फिल\u{94d}म चौकट"),
            keywords: &[
                "चौकटी",
                "फिल\u{94d}म",
                "फिल\u{94d}म चौकट",
                "म\u{941}व\u{94d}ही",
                "सिन\u{947}मा",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тасма кадрлары"),
            keywords: &["кинотеатр", "тасма", "тасма кадрлары"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Filmklappen"),
            keywords: &["Film", "Filmklappen", "Kino", "Klappen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຟຣມຮ\u{eb9}ບເງ\u{ebb}າ"),
            keywords: &["ຮ\u{eb9}ບເງ\u{ebb}າ", "ເຟຣມ", "ເຟຣມຮ\u{eb9}ບເງ\u{ebb}າ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("filmo kadrai"),
            keywords: &["filmas", "filmo kadrai", "juosta", "kadrai", "kinas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("filmas lente"),
            keywords: &["filma", "filmas lente", "kadri", "kino"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("anga whitiāhua"),
            keywords: &["anga", "whare whitiāhua", "whitiāhua"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("филмска лента"),
            keywords: &["кадар", "кино", "филм", "филмска лента"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഫിലിം ഫ\u{d4d}രെയിമ\u{d41}കൾ"),
            keywords: &[
                "ചലച\u{d4d}ചിത\u{d4d}രം",
                "ഫിലിം",
                "ഫിലിം ഫ\u{d4d}രെയിമ\u{d41}കൾ",
                "സിനിമ",
                "സിനിമ ഫ\u{d4d}രെയിമ\u{d41}കൾ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("кино хальсны кадр"),
            keywords: &["кадрууд", "кино", "кино театр", "кино хальсны кадр"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("फिल\u{94d}मच\u{94d}या फ\u{94d}र\u{947}म"),
            keywords: &[
                "चित\u{94d}रपट",
                "फिल\u{94d}म",
                "फिल\u{94d}मच\u{94d}या फ\u{94d}र\u{947}म",
                "फ\u{94d}र\u{947}म",
                "सिन\u{947}मा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bingkai filem"),
            keywords: &["bingkai", "filem", "pawagam", "wayang"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("frejms tal-film"),
            keywords: &["film", "filmat", "frejms", "frejms tal-film", "ċinema"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဖလင\u{103a}က\u{103d}က\u{103a}များ"),
            keywords: &[
                "ဖရ\u{102d}န\u{103a}",
                "ဖလင\u{103a}",
                "ဖလင\u{103a}က\u{103d}က\u{103a}များ",
                "ရ\u{102f}ပ\u{103a}ရ\u{103e}င\u{103a}",
                "ရ\u{102f}ပ\u{103a}ရ\u{103e}င\u{103a}ရ\u{102f}\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("filmruter"),
            keywords: &["bilder", "film", "filmruter", "kino", "ruter"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("फिल\u{94d}मको फ\u{94d}र\u{947}महर\u{942}"),
            keywords: &[
                "चलचित\u{94d}र",
                "फिल\u{94d}म",
                "फिल\u{94d}मको फ\u{94d}र\u{947}महर\u{942}",
                "फ\u{94d}र\u{947}महर\u{942}",
                "सिन\u{947}मा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("filmframes"),
            keywords: &["bioscoop", "film", "filmframes", "films", "frames"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("filmruter"),
            keywords: &["bilete", "film", "filmruter", "kino", "ruter"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଫ\u{b3f}ଲ\u{b4d}ମ ଫ\u{b4d}ରେମ\u{b4d}\u{200c}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ"),
            keywords: &[
                "ଫ\u{b3f}ଲ\u{b4d}ମ ଫ\u{b4d}ରେମ\u{b4d}\u{200c}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
                "ସ\u{b3f}ନେମ\u{b3e} । ଫ\u{b3f}ଲ\u{b4d}ମ । ଫ\u{b4d}ରେମ\u{b4d}\u{200c}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ । ମ\u{b41}ଭ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਫਿਲਮ ਫਰ\u{a47}ਮ"),
            keywords: &["ਫਿਲਮ", "ਫਿਲਮ ਫਰ\u{a47}ਮ", "ਮ\u{a42}ਵੀ", "ਸਿਨ\u{a47}ਮਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("فلم نوں بنانا"),
            keywords: &["سینما", "فلم", "فلم نوں بنانا", "چاکھٹاں"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fím Frem-dem"),
            keywords: &["Fim", "Frem-dẹm", "Fím Frem-dem", "Múvi", "Sinẹmá"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("taśma filmowa"),
            keywords: &["film", "kino", "klatki", "taśma filmowa"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د فلم چوکاټ"),
            keywords: &["د فلم چوکاټ", "سنيما", "فلم", "مووي", "چوکاټونه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rolo de filmes"),
            keywords: &["cinema", "filme", "rolo de filmes"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("fotogramas"),
            keywords: &["cinema", "filme", "fotogramas"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("kanchakuna peliculamanta"),
            keywords: &["kanchakuna peliculamanta"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("peliculă de film"),
            keywords: &["cadre", "cinema", "film", "peliculă", "peliculă de film"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-350"),
            keywords: &["E10-350"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("кинопленка"),
            keywords: &[
                "кадр",
                "кинематограф",
                "кино",
                "кинопленка",
                "пленка",
                "фильм",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("amakadiri ya filime"),
            keywords: &[
                "amakadiri",
                "amakadiri ya filime",
                "filime",
                "filimi",
                "sinema",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("فلم فريم"),
            keywords: &["سئنيما", "فريم", "فلم", "مووي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ච\u{dd2}ත\u{dca}\u{200d}රපට ර\u{dcf}ම\u{dd4}"),
            keywords: &[
                "ච\u{dd2}ත\u{dca}\u{200d}රපට ර\u{dcf}ම\u{dd4}",
                "ච\u{dd2}ත\u{dca}\u{200d}රපටය",
                "ර\u{dcf}ම\u{dd4}",
                "ස\u{dd2}නම\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("filmový pás"),
            keywords: &["film", "filmový", "kino", "pás"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("filmski trak"),
            keywords: &["film", "filmski trak", "kino", "sličice"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("fareemyada filimka"),
            keywords: &["fareemyada filimka", "fareemyo", "filim", "sinimoo"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kuadro filmi"),
            keywords: &["film", "kinema", "kuadro", "kuadro filmi", "video"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кадрови филма"),
            keywords: &["биоскоп", "кадрови", "кадрови филма", "филм"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["кадрови филма"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kadrovi filma"),
            keywords: &["bioskop", "film", "kadrovi", "kadrovi filma"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["kadrovi filma"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("filmnegativ"),
            keywords: &["film", "filmnegativ", "negativ"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("fremu za utepe wa filamu"),
            keywords: &["filamu", "fremu", "fremu za utepe wa filamu", "sinema"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("திரைப\u{bcd}பட ஃபிரேம\u{bcd}கள\u{bcd}"),
            keywords: &[
                "ஃபிரேம\u{bcd}கள\u{bcd}",
                "சினிம\u{bbe}",
                "திரைப\u{bcd}பட ஃபிரேம\u{bcd}கள\u{bcd}",
                "மூவி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c3f}న\u{c3f}మ\u{c3e} ర\u{c40}లు"),
            keywords: &[
                "ఫ\u{c3f}ల\u{c4d}మ\u{c4d}",
                "మూవ\u{c40}",
                "ర\u{c40}లు",
                "స\u{c3f}న\u{c3f}మ\u{c3e}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("кадрҳои навор"),
            keywords: &["кадр", "кадрҳои навор", "кино", "навор", "синамо"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เฟรมภาพยนตร\u{e4c}"),
            keywords: &["ภาพยนตร\u{e4c}", "หน\u{e31}ง", "เฟรม", "เฟรมภาพยนตร\u{e4c}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("filmden kadrlar"),
            keywords: &["film", "filmden kadrlar", "kadrlar", "kino", "kinoteatr"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻata heleʻuhila"),
            keywords: &["ʻata heleʻuhila"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("film kareleri"),
            keywords: &["film", "film kareleri", "film karesi", "sinema"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كىنو رامكىسى"),
            keywords: &["رامكا", "فىلىم", "كىنو", "كىنو رامكىسى", "كىنوخانا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кадри кіноплівки"),
            keywords: &["кадри", "кадри кіноплівки", "кіно", "плівка", "фільм"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("فلم کے فریم"),
            keywords: &["سینما", "فریم", "فلم", "فلم کے فریم"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("film kadri"),
            keywords: &["film", "film kadri", "kadrlar", "kino"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("khung hình phim"),
            keywords: &["khung", "khung hình phim", "phim", "rạp chiếu phim"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kaadaru klise"),
            keywords: &["film", "kaadar", "kaadaru klise", "klise", "sinemaa"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("izakhelo zefilimu"),
            keywords: &[
                "ifilimu",
                "imuvi",
                "isinema",
                "izakhelo",
                "izakhelo zefilimu",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àwọn férémù fíìmù"),
            keywords: &["fíìmù", "sinemá", "àwọn férémù", "àwọn férémù fíìmù"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("電影畫面"),
            keywords: &["戲", "戲院", "畫面", "電影", "電影畫面"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("电影画面"),
            keywords: &["戏", "戏院", "电影", "电影画面", "画面"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("影片帧"),
            keywords: &["帧", "影片帧", "电影", "电影胶片", "胶卷", "胶片"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("電影膠卷"),
            keywords: &["膠卷", "電影膠卷"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("菲林"),
            keywords: &["菲林", "菲林｜電影菲林"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("amafreymi amafilimu"),
            keywords: &[
                "amafreymi amafilimu",
                "amafreymu",
                "ifilimu",
                "imuvi",
                "isinema",
            ],
        },
    ],
};
#[doc = "📽\u{fe0f}"]
pub const FILM_PROJECTOR: crate::Emoji = crate::Emoji {
    glyph: "📽\u{fe0f}",
    codepoint: "1F4FD FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "film projector",
    group: "Objects",
    subgroup: "light & video",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "📽",
        codepoint: "1F4FD",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "film projector",
        group: "Objects",
        subgroup: "light & video",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("rolprentprojektor"),
            keywords: &[
                "bioskoop",
                "fliek",
                "projektor",
                "rolprent",
                "rolprentprojektor",
                "video",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የፊልም ፕሮጄክተር"),
            keywords: &["ሲኒማ", "ቪዲዮ", "የፊልም ፕሮጄክተር", "ፊልም", "ፕሮጄክተር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("جهاز عرض أفلام"),
            keywords: &[
                "أفلام",
                "إسقاط فيديو",
                "جهاز عرض أفلام",
                "سينما",
                "عارض",
                "فيلم",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ফিল\u{9cd}ম প\u{9cd}ৰজেক\u{9cd}টৰ"),
            keywords: &[
                "চলচিত\u{9cd}ৰ",
                "চিনেম\u{9be}",
                "প\u{9cd}ৰজেক\u{9cd}টৰ",
                "ফিল\u{9cd}ম",
                "ভিডিঅ’",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kino projektoru"),
            keywords: &[
                "film",
                "kino",
                "kino projektoru",
                "kinofilm",
                "projector",
                "video",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кінапраектар"),
            keywords: &["відэа", "кінапраектар", "кіно", "праектар", "фільм"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("кинопроектор"),
            keywords: &["кино", "кинопроектор", "проектор", "филм"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ফিল\u{9cd}ম প\u{9cd}রজেক\u{9cd}টর"),
            keywords: &[
                "প\u{9cd}রজেক\u{9cd}টর",
                "ফিল\u{9cd}ম",
                "ভিডিও",
                "ম\u{9c1}ভি",
                "সিনেম\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("lucʼhvanner"),
            keywords: &["film", "lucʼhvanner", "sinema", "video"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("projektor"),
            keywords: &["film", "kino", "projektor", "video"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("projector cinematogràfic"),
            keywords: &["cinema", "projector", "projector cinematogràfic"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some(
                "𑄜\u{11128}𑄣\u{11134}𑄟\u{11134} 𑄛\u{11133}𑄢\u{11127}𑄎𑄬𑄇\u{11134}𑄑\u{11127}𑄢\u{11134}",
            ),
            keywords: &[
                "𑄜\u{11128}𑄣\u{11134}𑄟\u{11134} 𑄛\u{11133}𑄢\u{11127}𑄎𑄬𑄇\u{11134}𑄑\u{11127}𑄢\u{11134}",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏗᏴᎳᏙᏗ ᏗᎦᎸᏌᏗᏍᎩ"),
            keywords: &["ᎠᏗᏴᎳᏙᏗ", "ᎠᏗᏴᎳᏛᏍᎩ", "ᏗᎦᎸᏌᏗᏍᎩ", "ᏧᎾᏗᏴᎳᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("filmový projektor"),
            keywords: &["film", "filmový projektor", "kino", "promítačka", "video"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("taflunydd ffilm"),
            keywords: &["ffilm", "fideo", "sinema", "taflunydd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("filmprojektor"),
            keywords: &["biograf", "film", "filmprojektor", "projektor", "video"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Filmprojektor"),
            keywords: &["Filmprojektor", "Kino", "Unterhaltung"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("προβολέας ταινιών"),
            keywords: &[
                "βίντεο",
                "κινηματογράφος",
                "προβολέας",
                "προβολέας ταινιών",
                "ταινία",
                "φιλμ",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("film projector"),
            keywords: &["cinema", "film", "movie", "projector", "video"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("proyector de cine"),
            keywords: &["cine", "película", "proyector", "proyector de cine"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "cine",
                "películas",
                "proyector",
                "proyector de cine",
                "video",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("filmiprojektor"),
            keywords: &["film", "filmiprojektor", "kino", "projektor", "video"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("film-proiektorea"),
            keywords: &["bideo", "film", "film-proiektorea", "proiektore", "zinema"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پروژکتور"),
            keywords: &["سینما", "فیلم", "ویدیو", "پروژکتور"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("elokuvaprojektori"),
            keywords: &[
                "elokuva",
                "elokuvakone",
                "elokuvaprojektori",
                "projektori",
                "video",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("film projector"),
            keywords: &[
                "cinema",
                "film projector",
                "palabas",
                "pelikula",
                "projector",
                "video",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("ljósvørpa"),
            keywords: &["biografur", "filmur", "ljósvørpa", "myndatól"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("projecteur cinématographique"),
            keywords: &["projecteur", "projecteur cinématographique"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "cinéma",
                "film",
                "projecteur",
                "projecteur cinématographique",
                "vidéo",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("teilgeoir scannáin"),
            keywords: &[
                "cineama",
                "físeán",
                "scannán",
                "teilgeoir",
                "teilgeoir scannáin",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("proiseactar"),
            keywords: &["film", "proiseactar", "taigh-dhealbh", "tilgeir", "video"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("proxector cinematográfico"),
            keywords: &[
                "cine",
                "película",
                "proxector",
                "proxector cinematográfico",
                "vídeo",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ફિલ\u{acd}મ પ\u{acd}રોજ\u{ac7}ક\u{acd}ટર"),
            keywords: &[
                "પ\u{acd}રોજ\u{ac7}ક\u{acd}ટર",
                "ફિલ\u{acd}મ પ\u{acd}રોજ\u{ac7}ક\u{acd}ટર",
                "મ\u{ac2}વી",
                "વિડિઓ",
                "સિન\u{ac7}મા",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("frajekta na fim"),
            keywords: &["bidiyo", "fim", "frajekta", "frajekta na fim", "silima"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מקרן קולנוע"),
            keywords: &["וידאו", "מקרן", "סרט", "קולנוע"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("फ\u{93c}िल\u{94d}म प\u{94d}रोज\u{947}क\u{94d}टर"),
            keywords: &[
                "फ\u{93c}िल\u{94d}म",
                "फ\u{93c}िल\u{94d}म प\u{94d}रोज\u{947}क\u{94d}टर",
                "वीडियो",
                "सिन\u{947}मा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("filmski projektor"),
            keywords: &["film", "filmski projektor", "kino", "projektor", "video"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("filmvetítő"),
            keywords: &["film", "filmvetítő", "mozi", "vetítő", "videó"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ժապավենային պրոյեկտոր"),
            keywords: &[
                "ժապավեն",
                "ժապավենային պրոյեկտոր",
                "կինո",
                "պրոյեկտոր",
                "վիդեո",
                "ֆիլմ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("proyektor film"),
            keywords: &["film", "proyektor", "sinema", "video"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihe nkiri ahụ aja"),
            keywords: &["ihe nkiri", "ihe nkiri ahụ aja", "vidio", "ụlọ ihe nkiri"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sýningarvél"),
            keywords: &[
                "bíómynd",
                "kvikmynd",
                "kvikmyndalist",
                "myndband",
                "sýningarvél",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("proiettore cinematografico"),
            keywords: &[
                "fotocamera",
                "fotografare",
                "macchina fotografica",
                "proiettore cinematografico",
                "ricordi",
                "scattare foto",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("映写機"),
            keywords: &["プロジェクター", "ムービー", "映写機", "映画"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("proyektor film"),
            keywords: &["film", "proyektor", "sinema", "vidio"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კინოპროექტორი"),
            keywords: &[
                "ვიდეო",
                "კინო",
                "კინოთეატრი",
                "კინოპროექტორი",
                "პროექტორი",
                "ფილმი",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("ameskan n yisura"),
            keywords: &["ameskan n yisura"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("кинопроектор"),
            keywords: &[
                "бейне",
                "бейнефильм",
                "кино",
                "кинопроектор",
                "проектор",
                "фильм",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("filmprojektor"),
            keywords: &["biograf", "filmprojektor", "projektor", "video"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ឧបករណ\u{17cd}បញ\u{17d2}ចា\u{17c6}ងក\u{17bb}នប\u{17d2}រើហ\u{17d2}វ\u{17b8}ល"),
            keywords: &[
                "បញ\u{17d2}ចា\u{17c6}ងក\u{17bb}ន",
                "ភាពយន\u{17d2}ត",
                "វ\u{17b8}ដេអ\u{17bc}",
                "ហ\u{17d2}វ\u{17b8}ល",
                "ឧបករណ\u{17cd}បញ\u{17d2}ចា\u{17c6}ងក\u{17bb}ន",
                "ឧបករណ\u{17cd}បញ\u{17d2}ចា\u{17c6}ងក\u{17bb}នប\u{17d2}រើហ\u{17d2}វ\u{17b8}ល",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಫ\u{cbf}ಲ\u{ccd}ಮ\u{ccd} ಪ\u{ccd}ರೊಜ\u{cc6}ಕ\u{ccd}ಟರ\u{ccd}"),
            keywords: &[
                "ಚಲನಚ\u{cbf}ತ\u{ccd}ರ",
                "ಪ\u{ccd}ರೊಜ\u{cc6}ಕ\u{ccd}ಟರ\u{ccd}",
                "ಫ\u{cbf}ಲ\u{ccd}ಮ\u{ccd} ಪ\u{ccd}ರೊಜ\u{cc6}ಕ\u{ccd}ಟರ\u{ccd}",
                "ಮ\u{cc2}ವೀ",
                "ವೀಡ\u{cbf}ಯೊ",
                "ಸ\u{cbf}ನ\u{cc6}ಮಾ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("영화 프로젝터"),
            keywords: &["무비", "영화", "프로젝터"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("फिल\u{94d}म प\u{94d}रॉज\u{945}क\u{94d}टर"),
            keywords: &[
                "प\u{94d}रॉज\u{945}क\u{94d}टर",
                "फिल\u{94d}म",
                "म\u{941}व\u{94d}ही",
                "व\u{94d}हिडियो",
                "सिन\u{947}मा",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кинопроектор"),
            keywords: &["кинопроектор", "кинотеатр", "проектор", "тасма"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Filmprojekter"),
            keywords: &["Film", "Filmprojekter", "Kino", "Projekter", "Video"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຄ\u{eb7}\u{ec8}ອງສາຍຮ\u{eb9}ບເງ\u{ebb}າ"),
            keywords: &[
                "ວ\u{eb4}ດ\u{eb5}ໂອ",
                "ຮ\u{eb9}ບເງ\u{ebb}າ",
                "ເຄ\u{eb7}\u{ec8}ອງສາຍ",
                "ເຄ\u{eb7}\u{ec8}ອງສາຍຮ\u{eb9}ບເງ\u{ebb}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("filmų projektorius"),
            keywords: &[
                "filmas",
                "filmų projektorius",
                "kinas",
                "projektorius",
                "vaizdo įrašas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("filmu projektors"),
            keywords: &["filma", "filmu projektors", "kino", "projektors"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tukuata whitiāhua"),
            keywords: &["ataata", "tukuata", "whare whitiāhua", "whitiāhua"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("филмски прожектор"),
            keywords: &["камера", "кино", "прожектор", "филм", "филмски прожектор"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഫിലിം പ\u{d4d}രൊജക\u{d4d}റ\u{d4d}റർ"),
            keywords: &[
                "ചലച\u{d4d}ചിത\u{d4d}രം",
                "പ\u{d4d}രൊജക\u{d4d}\u{200c}റ\u{d4d}റർ",
                "ഫിലിം",
                "വീഡിയോ",
                "സിനിമ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("кино проектор"),
            keywords: &["кино", "проектор"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("फिल\u{94d}म प\u{94d}रोज\u{947}क\u{94d}टर"),
            keywords: &[
                "चित\u{94d}रपट",
                "प\u{94d}रोज\u{947}क\u{94d}टर",
                "फिल\u{94d}म",
                "व\u{94d}हिडिओ",
                "सिन\u{947}मा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("projektor filem"),
            keywords: &["filem", "pawagam", "projektor", "video", "wayang"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("projettur tal-filmati"),
            keywords: &[
                "film",
                "filmat",
                "projettur",
                "projettur tal-filmati",
                "vidjo",
                "ċinema",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ရ\u{102f}ပ\u{103a}ရ\u{103e}င\u{103a}ပြစက\u{103a}"),
            keywords: &[
                "ဖလင\u{103a}",
                "ဗ\u{102e}ဒ\u{102e}ယ\u{102d}\u{102f}",
                "ရ\u{102f}ပ\u{103a}ရ\u{103e}င\u{103a}",
                "ရ\u{102f}ပ\u{103a}ရ\u{103e}င\u{103a}ပြစက\u{103a}",
                "ရ\u{102f}ပ\u{103a}ရ\u{103e}င\u{103a}ရ\u{102f}\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("filmfremviser"),
            keywords: &[
                "film",
                "filmframviser",
                "filmfremviser",
                "kino",
                "projektor",
                "video",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("फिल\u{94d}म प\u{94d}रोज\u{947}क\u{94d}टर"),
            keywords: &[
                "चलचित\u{94d}र",
                "प\u{94d}रोज\u{947}क\u{94d}टर",
                "फिल\u{94d}म",
                "भिडियो",
                "सिन\u{947}मा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("filmprojector"),
            keywords: &["bioscoop", "film", "filmprojector", "projector", "video"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("filmframvisar"),
            keywords: &["film", "filmframvisar", "kino", "projektor", "video"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଫ\u{b3f}ଲ\u{b4d}ମ ପ\u{b4d}ରୋଜେକ\u{b4d}ଟର\u{b4d}\u{200c}"),
            keywords: &[
                "ଚଳଚ\u{b4d}ଚ\u{b3f}ତ\u{b4d}ର",
                "ପ\u{b4d}ରୋଜେକ\u{b4d}ଟର",
                "ଫ\u{b3f}ଲ\u{b4d}ମ",
                "ଫ\u{b3f}ଲ\u{b4d}ମ ପ\u{b4d}ରୋଜେକ\u{b4d}ଟର\u{b4d}\u{200c}",
                "ଭ\u{b3f}ଡ\u{b3c}\u{b3f}ଓ",
                "ସ\u{b3f}ନେମ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਫਿਲਮ ਪ\u{a4d}ਰ\u{a4b}ਜ\u{a48}ਕਟਰ"),
            keywords: &[
                "ਪ\u{a4d}ਰ\u{a4b}ਜ\u{a48}ਕਟਰ",
                "ਫਿਲਮ",
                "ਮ\u{a42}ਵੀ",
                "ਵੀਡੀਓ",
                "ਸਿਨ\u{a47}ਮਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("فلم پروجیکٹر"),
            keywords: &["سینما", "فلم", "ویڈیو", "پروجیکٹر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fím Projẹ\u{301}ktọ"),
            keywords: &[
                "Fim",
                "Fím Projẹ\u{301}ktọ",
                "Múvi",
                "Projẹ\u{301}ktọ",
                "Sinẹmá",
                "Vídio",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("projektor filmowy"),
            keywords: &[
                "film",
                "kino",
                "projekcja",
                "projektor",
                "projektor filmowy",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د فلم پروجیکټر"),
            keywords: &[
                "د فلم پروجیکټر",
                "سنيما",
                "فلم",
                "مووي",
                "ويډيو",
                "پروجيکټر",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("projetor de filmes"),
            keywords: &["cinema", "filme", "projetor", "projetor de filmes", "vídeo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("projetor de cinema"),
            keywords: &["cinema", "filme", "projetor", "projetor de cinema", "vídeo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("proyector cinepaq"),
            keywords: &["proyector cinepaq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("proiector de film"),
            keywords: &["cinema", "film", "proiector", "proiector de film", "video"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-698"),
            keywords: &["E10-698"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("кинопроектор"),
            keywords: &["видео", "кино", "кинопроектор", "показ", "проектор"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("porojegiteri ya filimi"),
            keywords: &[
                "amashusho agenda",
                "filimi",
                "porojegiteri",
                "porojegiteri ya filimi",
                "sinema",
                "videwo",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("فلم پروجيڪٽر"),
            keywords: &["سئنيما", "فلم", "وڊيو", "پروجيڪٽر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ච\u{dd2}ත\u{dca}\u{200d}රපට ප\u{dca}\u{200d}රොෙජක\u{dca}ටරය"),
            keywords: &[
                "ච\u{dd2}ත\u{dca}\u{200d}රපට ප\u{dca}\u{200d}රොජෙක\u{dca}ටරය",
                "ච\u{dd2}ත\u{dca}\u{200d}රපට ප\u{dca}\u{200d}රොෙජක\u{dca}ටරය",
                "ච\u{dd2}ත\u{dca}\u{200d}රපටය",
                "ව\u{dd3}ඩ\u{dd2}යෝව",
                "ස\u{dd2}නම\u{dcf}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("filmový projektor"),
            keywords: &["film", "filmový projektor", "kino", "projektor", "video"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("filmski projektor"),
            keywords: &["film", "filmski projektor", "kino", "projektor", "video"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("borojektarka filimada"),
            keywords: &[
                "borojektar",
                "borojektarka filimada",
                "fiidiyow",
                "filim",
                "sinimoo",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("projektor filmi"),
            keywords: &["film", "kinema", "projektor", "projektor filmi", "video"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("филмски пројектор"),
            keywords: &["биоскоп", "видео", "пројектор", "филм", "филмски пројектор"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["филмски пројектор"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("filmski projektor"),
            keywords: &["bioskop", "film", "filmski projektor", "projektor", "video"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["filmski projektor"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("filmprojektor"),
            keywords: &["film", "filmprojektor", "projektor"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("projekta ya filamu"),
            keywords: &[
                "filamu",
                "projekta",
                "projekta ya filamu",
                "sinema",
                "video",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பிலிம\u{bcd} புரோஜெக\u{bcd}டர\u{bcd}"),
            keywords: &[
                "சினிம\u{bbe}",
                "பிலிம\u{bcd}",
                "புரோஜெக\u{bcd}டர\u{bcd}",
                "மூவி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c3f}న\u{c3f}మ\u{c3e} ప\u{c4d}ర\u{c4a}జ\u{c46}క\u{c4d}టర\u{c4d}"),
            keywords: &[
                "ప\u{c4d}ర\u{c4a}జ\u{c46}క\u{c4d}టర\u{c4d}",
                "షూట\u{c3f}ంగ\u{c4d}",
                "స\u{c3f}న\u{c3f}మ\u{c3e}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("проектори филм"),
            keywords: &[
                "видео",
                "кино",
                "проектор",
                "проектори филм",
                "синамо",
                "филм",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เคร\u{e37}\u{e48}องฉายหน\u{e31}ง"),
            keywords: &[
                "ภาพยนตร\u{e4c}",
                "ว\u{e34}ด\u{e35}โอ",
                "หน\u{e31}ง",
                "เคร\u{e37}\u{e48}องฉาย",
                "เคร\u{e37}\u{e48}องฉายหน\u{e31}ง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("film proýektory"),
            keywords: &[
                "film",
                "film proýektory",
                "kino",
                "kinoteatr",
                "proýektor",
                "wideo",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mīsini heleʻuhila"),
            keywords: &["mīsini heleʻuhila"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("film projektörü"),
            keywords: &["film", "film projektörü", "projektör", "sinema", "video"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("فىلىم قويغۇچ"),
            keywords: &["سىن", "فىلىم", "قويغۇچ", "كىنو", "كىنوخانا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кінопроектор"),
            keywords: &["відео", "кіно", "кінопроектор", "проектор", "фільм"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("فلم پروجیکٹر"),
            keywords: &["سینما", "فلم", "پروجیکٹر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("film proyektori"),
            keywords: &["film", "film proyektori", "kino", "proyektor", "video"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("máy chiếu phim"),
            keywords: &[
                "máy chiếu",
                "máy chiếu phim",
                "phim",
                "rạp chiếu phim",
                "video",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("prosektër filmu"),
            keywords: &["filmu", "klise", "prosektër", "sinemaa", "wideo"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iprojektha yefilimu"),
            keywords: &[
                "ifilimu",
                "imuvi",
                "iprojektha",
                "iprojektha yefilimu",
                "isinema",
                "ividiyo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("è\u{329}rọ agbéwòrán jáde"),
            keywords: &[
                "fídíò",
                "fíìmù",
                "pìròjẹ\u{301}kítọ\u{300}",
                "sínímà",
                "è\u{329}rọ agbéwòrán jáde",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("電影放映機"),
            keywords: &["影片", "戲", "戲院", "放映機", "電影", "電影放映機"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("电影放映机"),
            keywords: &["影片", "戏", "戏院", "放映机", "电影", "电影放映机"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("电影放映机"),
            keywords: &["影片", "投影仪", "放映机", "电影", "电影放映机", "视频"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("電影放映機"),
            keywords: &["放映機", "電影放映機"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["投影機", "放映機", "電影放映機"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhayisikobho"),
            keywords: &["amafreymu", "ibhayisikobho", "ifilimu", "imuvi", "isinema"],
        },
    ],
};
#[doc = "🎬"]
pub const CLAPPER_BOARD: crate::Emoji = crate::Emoji {
    glyph: "🎬",
    codepoint: "1F3AC",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "clapper board",
    group: "Objects",
    subgroup: "light & video",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("klapbord"),
            keywords: &["bord", "klapbord", "klapper", "rolprent"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የፊልም ቀረጻ መቀንጠቢያ ሰሌዳ"),
            keywords: &["የፊልም ቀረጻ መቀንጠቢያ ሰሌዳ", "ፊልም"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كلاكيت"),
            keywords: &["ترفيه", "فيلم", "كلاكيت"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9cd}লেপ\u{9be}ৰ ব’ৰ\u{9cd}ড"),
            keywords: &[
                "ক\u{9cd}লেপ\u{9be}ৰ",
                "ক\u{9cd}লেপ\u{9be}ৰ ব’ৰ\u{9cd}ড",
                "চলচিত\u{9cd}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("numerator"),
            keywords: &["film", "numerator"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("нумаратар з хлапушкай"),
            keywords: &["здымка", "нумаратар з хлапушкай", "фільм", "хлапушка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("клапа"),
            keywords: &["клапа", "филмова"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9cd}ল\u{9cd}য\u{9be}প\u{9be}র বোর\u{9cd}ড"),
            keywords: &[
                "ক\u{9cd}ল\u{9cd}য\u{9be}প\u{9be}র",
                "ক\u{9cd}ল\u{9cd}য\u{9be}প\u{9be}র বোর\u{9cd}ড",
                "ম\u{9c1}ভি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("klek"),
            keywords: &["film", "klek"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("filmska klapa"),
            keywords: &["film", "filmska klapa", "klapa"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("claqueta"),
            keywords: &["cinema", "claqueta", "pel·lícula"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄇\u{11133}𑄣\u{11133}𑄠𑄛𑄢\u{11134} 𑄝\u{1112e}𑄢\u{11133}𑄓\u{11134}"),
            keywords: &["𑄇\u{11133}𑄣\u{11133}𑄠𑄛𑄢\u{11134} 𑄝\u{1112e}𑄢\u{11133}𑄓\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᏏᏛᏂᎭ ᏯᏖᎾ"),
            keywords: &["ᎠᏗᏴᎳᏛᏍᎩ", "ᏗᏏᏛᏂᎭ", "ᏗᏏᏛᏂᎭ ᏯᏖᎾ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("filmová klapka"),
            keywords: &["film", "filmová klapka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("clepiwr"),
            keywords: &["clepiwr", "ffilm"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("klaptræ"),
            keywords: &["film", "filmklapper", "klapper", "klaptræ"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Filmklappe"),
            keywords: &["Film", "Filmklappe", "Klappe", "Unterhaltung"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κλακέτα φιλμ"),
            keywords: &["κλακέτα", "κλακέτα φιλμ", "ταινία"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("clapper board"),
            keywords: &["clapper", "clapper board", "movie"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("clapperboard"),
            keywords: &["clapper", "clapperboard", "movie"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["clapper", "clapperboard", "film"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("claqueta"),
            keywords: &[
                "cine",
                "claqueta",
                "claqueta de cine",
                "entretenimiento",
                "película",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("klapptahvel"),
            keywords: &["film", "klapptahvel", "video"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("klaketa"),
            keywords: &["film", "klaketa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کلاکت"),
            keywords: &["تخته\u{200c}نشان", "فیلم", "کلاکت"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("klaffitaulu"),
            keywords: &["elokuva", "klaffi", "klaffitaulu", "kuvaukset"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("clapper board"),
            keywords: &["board", "clapper", "palabas"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("klapptræ"),
            keywords: &["filmur", "klapptræ", "upptøka"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("clap"),
            keywords: &["clap", "film"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("clabaire"),
            keywords: &["clabaire", "scannán"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bòrd-braig"),
            keywords: &["bòrd-braig", "film"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("claqueta"),
            keywords: &["cine", "cinematografía", "claqueta", "filmar", "película"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ક\u{acd}લ\u{ac7}પર બોર\u{acd}ડ"),
            keywords: &[
                "ક\u{acd}લ\u{ac7}પર",
                "ક\u{acd}લ\u{ac7}પર બોર\u{acd}ડ",
                "ક\u{acd}લ\u{ac7}પરબોર\u{acd}ડ",
                "મનોર\u{a82}જન",
                "મ\u{ac2}વી",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("allon nunan wasan fim"),
            keywords: &["allon nuna fim", "allon nunan wasan fim", "fim"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קלאפר"),
            keywords: &["סרט", "צילום", "קולנוע", "קלאפר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("क\u{94d}ल\u{948}पर बोर\u{94d}ड"),
            keywords: &[
                "क\u{94d}ल\u{948}पर",
                "क\u{94d}ल\u{948}पर बोर\u{94d}ड",
                "क\u{94d}ल\u{948}परबोर\u{94d}ड",
                "मनोर\u{902}जन",
                "म\u{942}वी",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("klapa"),
            keywords: &["film", "klapa"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("csapó"),
            keywords: &["csapó", "film"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կինոդուբլների համարացույց"),
            keywords: &["կինոդուբլ", "կինոդուբլների համարացույց", "ֆիլմ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("papan sutradara"),
            keywords: &["film", "papan sutradara"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ngwa nkụpụta ụda"),
            keywords: &["ihe nkiri", "ngwa nkụpụta ụda", "nkụpụta ụda"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("klapptré"),
            keywords: &["klappspjald", "klapptré", "kvikmynd", "skemmtun"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("ciak"),
            keywords: &["ciak", "cinema", "film", "intrattenimento"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("カチンコ"),
            keywords: &["カチンコ", "映画"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("papan aba-aba adhegan"),
            keywords: &["aba-aba", "film", "papan aba-aba adhegan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ნუმერატორი ტკაცუნათი"),
            keywords: &["კინო", "ნუმერატორი", "ნუმერატორი ტკაცუნათი", "ტკაცუნა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шартылдақ нөмірлеуіш"),
            keywords: &["фильм", "шартылдақ", "шартылдақ нөмірлеуіш"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("klaptræ"),
            keywords: &["filmklapper", "klapper", "klaptræ"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ក\u{17d2}តារធ\u{17d2}វើជាសញ\u{17d2}ញាពេលចាប\u{17cb}ផ\u{17d2}តើមថតក\u{17bb}ន",
            ),
            keywords: &[
                "ក\u{17d2}តារថតក\u{17bb}ន",
                "ក\u{17d2}តារធ\u{17d2}វើជាសញ\u{17d2}ញាពេលចាប\u{17cb}ផ\u{17d2}តើមថតក\u{17bb}ន",
                "ថតក\u{17bb}ន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{ccd}ಲಾಪರ\u{ccd} ಬೋರ\u{ccd}ಡ\u{ccd}"),
            keywords: &[
                "ಕ\u{ccd}ಲಾಪರ\u{ccd}",
                "ಕ\u{ccd}ಲಾಪರ\u{ccd} ಬೋರ\u{ccd}ಡ\u{ccd}",
                "ಮನರಂಜನ\u{cc6}",
                "ಮ\u{cc2}ವೀ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("슬레이트"),
            keywords: &["슬레이트", "영화", "영화 촬영", "클래퍼보드"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("क\u{94d}ल\u{947}पर बोर\u{94d}ड"),
            keywords: &[
                "क\u{94d}ल\u{947}पर",
                "क\u{94d}ल\u{947}पर बोर\u{94d}ड",
                "म\u{941}व\u{94d}ही",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("шакылдак нумератор"),
            keywords: &["нумератор", "тасма", "шакылдак нумератор"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Filmklapp"),
            keywords: &["Film", "Filmklapp", "Klapp"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແຜ\u{ec8}ນແຄລບເປ\u{eb5}"),
            keywords: &[
                "ຮ\u{eb9}ບເງ\u{ebb}າ",
                "ແຄລບເປ\u{eb5}",
                "ແຜ\u{ec8}ນແຄລບເປ\u{eb5}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("pliauškė"),
            keywords: &["filmas", "pliauškė", "pranešimo lenta"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("klapīte"),
            keywords: &["filma", "klapīte"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("papa papaki"),
            keywords: &["papa papaki", "papaki", "whitiāhua"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("филмска клапа"),
            keywords: &["клапа", "филм", "филмска клапа"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d4d}ല\u{d3e}പ\u{d4d}പർ ബോർഡ\u{d4d}"),
            keywords: &[
                "ക\u{d4d}ല\u{d3e}പ\u{d4d}പർ ബോർഡ\u{d4d}",
                "ഷ\u{d42}ട\u{d4d}ടിംഗ\u{d4d}",
                "സിനിമ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("кадр"),
            keywords: &["кадр", "кино"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("क\u{94d}ल\u{945}पर बोर\u{94d}ड"),
            keywords: &[
                "क\u{94d}ल\u{945}पर",
                "क\u{94d}ल\u{945}पर बोर\u{94d}ड",
                "चित\u{94d}रपट",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("papan pengetap"),
            keywords: &["filem", "papan pengetap", "pengetap"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("clapper board"),
            keywords: &["clapper", "clapper board", "filmat"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ရ\u{102f}ပ\u{103a}ရ\u{103e}င\u{103a} ကလက\u{103a}ဘ\u{102f}တ\u{103a}"),
            keywords: &[
                "ကလက\u{103a}ပါ",
                "ကလက\u{103a}ဘ\u{102f}တ\u{103a}",
                "ရ\u{102f}ပ\u{103a}ရ\u{103e}င\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("filmklapper"),
            keywords: &[
                "action",
                "film",
                "filming",
                "filmklapper",
                "klapper",
                "underholdning",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("क\u{94d}ल\u{94d}याप\u{94d}पर बोर\u{94d}ड"),
            keywords: &[
                "क\u{94d}ल\u{94d}याप\u{94d}पर",
                "क\u{94d}ल\u{94d}याप\u{94d}पर बोर\u{94d}ड",
                "चलचित\u{94d}र",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("klapbord"),
            keywords: &["film", "klapbord", "klapper"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("filmklappar"),
            keywords: &[
                "action",
                "film",
                "filming",
                "filmklappar",
                "klappar",
                "underhaldning",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b4d}ଲ\u{b3e}ପର\u{b4d}\u{200c} ବୋର\u{b4d}ଡ\u{b4d}"),
            keywords: &[
                "କ\u{b4d}ଲ\u{b3e}ପର\u{b4d}\u{200c} ବୋର\u{b4d}ଡ\u{b4d}",
                "କ\u{b4d}ଲ\u{b3e}ପର\u{b4d}\u{200c}ବୋର\u{b4d}ଡ\u{b4d}",
                "ଚଳଚ\u{b4d}ଚ\u{b3f}ତ\u{b4d}ର",
                "ତ\u{b3e}ଳ\u{b3f} ମର\u{b3e}ଯ\u{b3f}ବ\u{b3e} ଫଳକ",
                "ତ\u{b3e}ଳ\u{b3f} ମ\u{b3e}ର\u{b3f}ବ\u{b3e} ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f}",
                "ମନୋରଞ\u{b4d}ଜନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਲ\u{a48}ਪਰ ਬ\u{a4b}ਰਡ"),
            keywords: &[
                "ਕਲ\u{a48}ਪਰ",
                "ਕਲ\u{a48}ਪਰ ਬ\u{a4b}ਰਡ",
                "ਫਿਲਮ",
                "ਮਨ\u{a4b}ਰ\u{a70}ਜਨ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کلیپر بورڈ"),
            keywords: &["تاڑی مارن آلا", "فلم", "کلیپر بورڈ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Klápa Bọd"),
            keywords: &["Klápa", "Klápa Bọd", "Múvi"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("klaps"),
            keywords: &["film", "kino", "klaps"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د کلیپر تخته"),
            keywords: &["د کلیپر تخته", "فلم", "کليپر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("claquete"),
            keywords: &["cena", "claquete", "entretenimento", "filme", "tomada"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["cinema", "claquete", "filme"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("claqueta"),
            keywords: &["claqueta"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("clachetă"),
            keywords: &["clachetă", "film", "filmare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-364"),
            keywords: &["E10-364"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("хлопушка-нумератор"),
            keywords: &[
                "кино",
                "киносъемки",
                "нумератор",
                "нумератор с хлопушкой",
                "сцена",
                "хлопушка",
                "хлопушка-нумератор",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("akabaho bifashisha bakina filimi"),
            keywords: &[
                "akabaho bifashisha bakina filimi",
                "akabaho kifashishwa mu ikina rya filimi",
                "amashusho agenda",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪليپربورڊ"),
            keywords: &["فلم", "ڪليپر", "ڪليپربورڊ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dca}ලැපර\u{dca} බෝඩ\u{dca}"),
            keywords: &[
                "ක\u{dca}ලැපර\u{dca}",
                "ක\u{dca}ලැපර\u{dca} බෝඩ\u{dca}",
                "ච\u{dd2}ත\u{dca}\u{200d}රපටය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("klapka"),
            keywords: &["film", "klapka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("klapa"),
            keywords: &["film", "klapa"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("samuurada bilowga duubista"),
            keywords: &["filim", "sacabiye", "samuurada bilowga duubista"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("tabelë dublimi e skenës"),
            keywords: &["film", "tabelë dublimi", "tabelë dublimi e skenës"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("режисерска клапа"),
            keywords: &["клапа", "режисерска клапа", "филм"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["режисерска клапа"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("režiserska klapa"),
            keywords: &["film", "klapa", "režiserska klapa"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["režiserska klapa"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("filmklappa"),
            keywords: &["film", "filmklappa", "klappa"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ubao wa kuanzisha matukio wakati wa kutengeneza filamu"),
            keywords: &[
                "filamu",
                "ubao wa kuanzisha matukio wakati wa kutengeneza filamu",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கிள\u{bbe}ப\u{bcd}பர\u{bcd} போர\u{bcd}டு"),
            keywords: &[
                "கிள\u{bbe}ப\u{bcd}",
                "கிள\u{bbe}ப\u{bcd} பலகை",
                "கிள\u{bbe}ப\u{bcd} போர\u{bcd}டு",
                "கிள\u{bbe}ப\u{bcd}பர\u{bcd} போர\u{bcd}டு",
                "சினிம\u{bbe}",
                "திரைப\u{bcd}படம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c4d}ల\u{c3e}ప\u{c4d} బ\u{c4b}ర\u{c4d}డ\u{c4d}"),
            keywords: &[
                "క\u{c4d}ల\u{c3e}ప\u{c4d} క\u{c4a}ట\u{c4d}టడం",
                "క\u{c4d}ల\u{c3e}ప\u{c4d} బ\u{c4b}ర\u{c4d}డ\u{c4d}",
                "వ\u{c3f}న\u{c4b}దం",
                "సన\u{c4d}న\u{c3f}వ\u{c47}శం",
                "స\u{c3f}న\u{c3f}మ\u{c3e}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("нумератор"),
            keywords: &["кино", "нумератор", "хлопушка"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("สเลท"),
            keywords: &["ถ\u{e48}ายหน\u{e31}ง", "สเลท"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("hlopuşka"),
            keywords: &["hlopuşka", "kino", "şakyrdawuk"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("papapasi"),
            keywords: &["papapasi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("film tahtası"),
            keywords: &["eğlence", "film", "film tahtası", "tahta"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چىك-چاك"),
            keywords: &["كىنو", "چىك-چاك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кінохлопавка"),
            keywords: &["кінохлопавка", "фільм", "хлопавка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کلیپر بورڈ"),
            keywords: &["فلم", "کلیپر", "کلیپر بورڈ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("klaper taxtasi"),
            keywords: &["film", "kino", "klaper", "klaper taxtasi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bảng clapper"),
            keywords: &["bảng clapper", "phim"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("klapet"),
            keywords: &["filmu", "klapet"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhodi yemuvi"),
            keywords: &["ibhodi", "ibhodi yemuvi", "imuvi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("pataki alapade"),
            keywords: &["fíìmù", "kílápà", "pataki alapade"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("拍板"),
            keywords: &["拍板", "電影"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("拍板"),
            keywords: &["拍板", "电影"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("场记板"),
            keywords: &["场记", "场记板", "打板", "拍电影"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("場記板"),
            keywords: &["場記板"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-clapper board"),
            keywords: &["i-clapper", "i-clapper board", "imuvi"],
        },
    ],
};
#[doc = "📺"]
pub const TELEVISION: crate::Emoji = crate::Emoji {
    glyph: "📺",
    codepoint: "1F4FA",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "television",
    group: "Objects",
    subgroup: "light & video",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("televisie"),
            keywords: &["televisie", "tv", "video"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቴሌቪዥን"),
            keywords: &["ቪዲዮ", "ቲቪ", "ቴሌቪዥን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("تليفزيون"),
            keywords: &["تليفزيون", "فيديو"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("টেলিভিছন"),
            keywords: &["টিভি", "টেলিভিছন", "ভিডিঅ’"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("televizor"),
            keywords: &["televizor", "tv", "video"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("тэлевізар"),
            keywords: &["ТБ", "відэа", "тэлебачанне", "тэлевізар"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("телевизор"),
            keywords: &["телевизор"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("টেলিভিশন"),
            keywords: &["টিভি", "টেলিভিশন", "ভিডিও"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("skinwel"),
            keywords: &["skinwel", "video"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("televizor"),
            keywords: &["televizor", "tv", "video"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("televisió"),
            keywords: &["televisió", "tv", "vídeo"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄑𑄬𑄣\u{11128}𑄞\u{11128}𑄥\u{11127}𑄚\u{11134}"),
            keywords: &["𑄑𑄬𑄣\u{11128}𑄞\u{11128}𑄥\u{11127}𑄚\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᏓᏴᎵᏛᏍᎩ"),
            keywords: &["tv", "ᎠᏓᏴᎳᏛᏍᎩ", "ᏗᏓᏴᎳᏛᏍᎩ", "ᏗᏓᏴᎵᏛᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("televizor"),
            keywords: &[
                "přijímač",
                "televize",
                "televizní",
                "televizor",
                "tv",
                "video",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("teledu"),
            keywords: &["fideo", "teledu"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("tv"),
            keywords: &["fjernsyn", "tv"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Fernseher"),
            keywords: &["Fernseher", "Film", "TV"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τηλεόραση"),
            keywords: &["βίντεο", "τηλεόραση"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("television"),
            keywords: &["television", "tv", "video"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["tele", "television", "telly", "tv", "video"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["TV", "television", "video"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["television", "tv", "video"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("televisión"),
            keywords: &["televisión", "tv"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("televisor"),
            keywords: &["TV", "televisión", "televisor", "video"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("televisión"),
            keywords: &["televisión"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("teler"),
            keywords: &["teler", "tv", "video"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("telebista"),
            keywords: &["bideo", "telebista"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تلویزیون"),
            keywords: &["تلویزیون", "ویدیو"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("televisio"),
            keywords: &["televisio", "telkkari", "tv", "video"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("telebisyon"),
            keywords: &["telebisyon", "tv", "video"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sjónvarp"),
            keywords: &["sjónvarp", "sjónvarpsskíggi"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("téléviseur"),
            keywords: &["TV", "téléviseur", "télévision"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["TV", "télé", "téléviseur", "télévision", "vidéo"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("teilifís"),
            keywords: &["TV", "teilifís"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("telebhisean"),
            keywords: &["tbh", "telebhisean", "tv", "video"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("televisión"),
            keywords: &["televisión", "televisor", "vídeo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ટ\u{ac7}લિવિઝન"),
            keywords: &["ટીવી", "ટ\u{ac7}લિવિઝન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("talabijan"),
            keywords: &["bidiyo", "talabijan", "tv"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("טלוויזיה"),
            keywords: &["TV", "וידאו", "טלוויזיה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ट\u{947}लीविज\u{93c}न"),
            keywords: &["टीवी", "ट\u{947}लीविज\u{93c}न", "वीडियो"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("televizor"),
            keywords: &["televizor", "tv", "video"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("televízió"),
            keywords: &["televízió", "tévé", "tévékészülék"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("հեռուստացույց"),
            keywords: &["tv", "հեռուստացույց", "վիդեո"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("televisi"),
            keywords: &["televisi", "tv", "video"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihe onyonyo"),
            keywords: &["ihe onyonyo", "tv", "vidio"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sjónvarp"),
            keywords: &["myndband", "sjónvarp"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("televisore"),
            keywords: &["televisione", "televisore"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("テレビ"),
            keywords: &["TV", "テレビ", "ビデオ"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("televisi"),
            keywords: &["radio", "televisi", "tv"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ტელევიზორი"),
            keywords: &["ვიდეო", "ტელევიზორი", "ტვ"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tiliẓri"),
            keywords: &["tiliẓri"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("теледидар"),
            keywords: &["бейне", "теледидар"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("tv"),
            keywords: &["fjernsyn", "tv"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ទ\u{17bc}រទស\u{17d2}សន\u{17cd}"),
            keywords: &[
                "TV",
                "ទ\u{17bc}រទស\u{17d2}សន\u{17cd}",
                "វ\u{17b8}ដេអ\u{17bc}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಟ\u{cc6}ಲ\u{cbf}ವ\u{cbf}ಷನ\u{ccd}"),
            keywords: &[
                "ಟ\u{cbf}ವ\u{cbf}",
                "ಟ\u{cc6}ಲ\u{cbf}ವ\u{cbf}ಷನ\u{ccd}",
                "ದ\u{cc2}ರದರ\u{ccd}ಶನ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("텔레비전"),
            keywords: &["TV", "텔레비전", "티비"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("द\u{942}रदर\u{94d}शन"),
            keywords: &["टिवी", "द\u{942}रदर\u{94d}शन", "व\u{94d}हिडियो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("сыналгы"),
            keywords: &["видео", "сыналгы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Fernseh"),
            keywords: &["Fernseh", "TV", "Video"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໂທລະພາບ"),
            keywords: &["ທ\u{eb5}ວ\u{eb5}", "ວ\u{eb4}ດ\u{eb5}ໂອ", "ໂທລະພາບ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("televizorius"),
            keywords: &["TV", "televizorius", "vaizdo įrašas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("televizors"),
            keywords: &["TV", "televizors", "video"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pouaka whakaata"),
            keywords: &["ataata", "pouaka whakaata"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("телевизор"),
            keywords: &["видео", "тв", "телевизор"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ടെലിവിഷൻ"),
            keywords: &["ടിവി", "ടെലിവിഷൻ", "വീഡിയോ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зурагт"),
            keywords: &["видео", "зурагт", "тв"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ट\u{947}लिव\u{94d}हिजन"),
            keywords: &[
                "टीव\u{94d}ही",
                "ट\u{947}लिव\u{94d}हिजन",
                "द\u{942}रदर\u{94d}शन",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("televisyen"),
            keywords: &["televisyen", "tv", "video"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("televiżjoni"),
            keywords: &["televiżjoni", "tv", "vidjo"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ရ\u{102f}ပ\u{103a}မြင\u{103a}သ\u{1036}ကြား"),
            keywords: &[
                "တယ\u{103a}လ\u{102e}ဗစ\u{103a}ရ\u{103e}င\u{103a}း",
                "တ\u{102e}ဗ\u{102e}",
                "ဗ\u{102e}ဒ\u{102e}ယ\u{102d}\u{102f}",
                "ရ\u{102f}ပ\u{103a}မြင\u{103a}သ\u{1036}ကြား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("TV"),
            keywords: &["TV", "fjernsyn", "video"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ट\u{947}लिभिजन"),
            keywords: &["टिभी", "ट\u{947}लिभिजन", "भिडियो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("tv"),
            keywords: &["beeld", "televisie", "tv"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("TV"),
            keywords: &["TV", "fjernsyn", "video"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଟେଲ\u{b3f}ଭ\u{b3f}ଜନ\u{b4d}"),
            keywords: &[
                "ଟ\u{b3f}ଭ\u{b3f}",
                "ଟେଲ\u{b3f}ଭ\u{b3f}ଜନ\u{b4d}",
                "ଦ\u{b42}ରଦର\u{b4d}ଶନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਟ\u{a48}ਲੀਵਿਜ\u{a3c}ਨ"),
            keywords: &["tv", "ਟੀਵੀ", "ਟ\u{a48}ਲੀਵਿਜ\u{a3c}ਨ", "ਵੀਡੀਓ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ٹیلی وژن"),
            keywords: &["tv", "ویڈیو", "ٹیلی وژن"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tẹlívíshọn"),
            keywords: &["TV", "Tẹlívíshọn", "Vídio"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("telewizja"),
            keywords: &[
                "kineskop",
                "kineskopowy",
                "odbiornik",
                "stary telewizor",
                "telewizja",
                "z anteną",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("تلویزیون"),
            keywords: &["تلويزيون", "تلویزیون", "ويډيو", "ټي وي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("televisão"),
            keywords: &["TV", "televisão", "vídeo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("televisor"),
            keywords: &["televisor", "televisão", "tv", "vídeo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("television"),
            keywords: &["television"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("televizor"),
            keywords: &["televizor", "tv", "video"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-695"),
            keywords: &["E10-695"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("телевизор"),
            keywords: &["тв", "телевидение", "телевизор"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("televiziyo"),
            keywords: &["televiziyo", "tv", "videwo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٽيليوزن"),
            keywords: &["ويڊيو", "ٽي وي", "ٽيليوزن"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ර\u{dd6}පව\u{dcf}හ\u{dd2}න\u{dd2}ය"),
            keywords: &["ර\u{dd6}පව\u{dcf}හ\u{dd2}න\u{dd2}ය", "ව\u{dd3}ඩ\u{dd2}යෝව"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("televízor"),
            keywords: &["televízia", "televízor", "tv", "video"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("televizija"),
            keywords: &["televizija", "tv", "video"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("telefishan"),
            keywords: &["fiidiyow", "telefishan", "tv"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("televizor"),
            keywords: &["televizor", "tv", "video"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("телевизија"),
            keywords: &["видeo", "тв", "телевизија"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("televizija"),
            keywords: &["televizija", "tv", "video"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tv"),
            keywords: &["television", "tv", "video"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("runinga"),
            keywords: &["runinga", "tv", "video"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("தொலைக\u{bcd}க\u{bbe}ட\u{bcd}சி"),
            keywords: &["டிவி", "டெலிவிஷன\u{bcd}", "தொலைக\u{bcd}க\u{bbe}ட\u{bcd}சி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ట\u{c46}ల\u{c3f}వ\u{c3f}జన\u{c4d}"),
            keywords: &[
                "ట\u{c40}వ\u{c40}",
                "ట\u{c46}ల\u{c3f}వ\u{c3f}జన\u{c4d}",
                "దూరదర\u{c4d}శ\u{c3f}న\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("телевизор"),
            keywords: &["видео", "тв", "телевизор"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ท\u{e35}ว\u{e35}"),
            keywords: &["ท\u{e35}ว\u{e35}", "โทรท\u{e31}ศน\u{e4c}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("telewizor"),
            keywords: &["telewizor", "tw", "wideo"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("televīsone"),
            keywords: &["televīsone"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("televizyon"),
            keywords: &["televizyon", "tv", "video"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تېلېۋىزور"),
            keywords: &["تېلېۋىزور", "تېلېۋىزىيە", "سىن"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("телевізор"),
            keywords: &["відео", "тб", "телевізор"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ٹیلی ویژن"),
            keywords: &["ویڈیو", "ٹی وی", "ٹیلی ویژن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("televizor"),
            keywords: &["televizor", "tv", "video"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tivi"),
            keywords: &["tivi", "tv", "video"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("tele"),
            keywords: &["tele", "wideo"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umabonakude"),
            keywords: &["i-tv", "ividiyo", "umabonakude"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àmóhùnmáwòrán"),
            keywords: &["fídíò", "àmóhùnmáwòrán"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("電視機"),
            keywords: &["影片", "電視機"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("电视机"),
            keywords: &["影片", "电视机"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("电视机"),
            keywords: &["电视", "电视机", "看电视", "节目", "视频"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("電視"),
            keywords: &["電視"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["電視", "電視｜TV"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ithelevishini"),
            keywords: &["i-tv", "ithelevishini", "ividiyo"],
        },
    ],
};
#[doc = "📷"]
pub const CAMERA: crate::Emoji = crate::Emoji {
    glyph: "📷",
    codepoint: "1F4F7",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "camera",
    group: "Objects",
    subgroup: "light & video",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kamera"),
            keywords: &["foto", "kamera", "video"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ካሜራ"),
            keywords: &["ቪዲዮ", "ካሜራ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كاميرا"),
            keywords: &["فيديو", "كاميرا"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কেমেৰ\u{9be}"),
            keywords: &["কেমেৰ\u{9be}", "ভিডিঅ’"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kamera"),
            keywords: &["kamera", "video"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("камера"),
            keywords: &["відэа", "здымка", "камера", "фота"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("фотоапарат"),
            keywords: &["фотоапарат"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9cd}য\u{9be}মের\u{9be}"),
            keywords: &["ক\u{9cd}য\u{9be}মের\u{9be}", "ভিডিও"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("lucʼhskeudennerez"),
            keywords: &["lucʼhskeudennerez", "video"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("fotoaparat"),
            keywords: &["fotoaparat", "kamera"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("càmera"),
            keywords: &["càmera", "vídeo"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄇𑄬𑄟𑄬𑄢"),
            keywords: &["𑄇𑄬𑄟𑄬𑄢"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᏓᏟᎶᏍᏙᏗ"),
            keywords: &["ᎠᏗᏴᎳᏛᏍᎩ", "ᏗᏓᏟᎶᏍᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("fotoaparát"),
            keywords: &["aparát", "fotoaparát", "fotografický", "foťák", "video"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("camera"),
            keywords: &["camera", "fideo"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kamera"),
            keywords: &["kamera", "video"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Fotoapparat"),
            keywords: &["Fotoapparat", "Fotos", "Kamera"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("φωτογραφική μηχανή"),
            keywords: &["βίντεο", "φωτογραφική μηχανή"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("camera"),
            keywords: &["camera", "video"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cámara de fotos"),
            keywords: &["cámara", "cámara de fotos"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cámara fotográfica"),
            keywords: &["cámara", "cámara fotográfica", "fotos"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kaamera"),
            keywords: &["kaamera", "video"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kamera"),
            keywords: &["bideo", "kamera"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دوربین"),
            keywords: &["دوربین", "ویدیو"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kamera"),
            keywords: &["kamera", "video"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("camera"),
            keywords: &["camera", "video"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("myndatól"),
            keywords: &["fotografi", "myndatól"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("appareil photo"),
            keywords: &["appareil photo", "vidéo"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ceamara"),
            keywords: &["ceamara"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("camara"),
            keywords: &["camara", "video"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cámara de fotos"),
            keywords: &["cámara", "cámara de fotos", "fotografía", "fotos", "vídeos"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ક\u{ac5}મ\u{ac7}રા"),
            keywords: &["ક\u{ac5}મ\u{ac7}રા", "વિડિઓ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kyamara"),
            keywords: &["bidiyo", "kyamara"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מצלמה"),
            keywords: &["וידאו", "מצלמה", "צילום"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("क\u{948}मरा"),
            keywords: &["क\u{948}मरा", "वीडियो"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("fotoaparat"),
            keywords: &["fotoaparat", "video"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fényképezőgép"),
            keywords: &["fényképezőgép", "kamera"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ֆոտոապարատ"),
            keywords: &["վիդեո", "ֆոտոապարատ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kamera"),
            keywords: &["kamera", "video"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("igwefòto"),
            keywords: &["igwefòto", "vidio"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("myndavél"),
            keywords: &["myndavél", "myndband"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("fotocamera"),
            keywords: &[
                "fotocamera",
                "fotografare",
                "macchina fotografica",
                "ricordi",
                "scattare foto",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("カメラ"),
            keywords: &["カメラ", "写真"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kamera"),
            keywords: &["kamera", "vidio"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ფოტოაპარატი"),
            keywords: &["ვიდეო", "ფოტოაპარატი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("Takamiṛat"),
            keywords: &["Takamiṛat"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("камера"),
            keywords: &["бейне", "камера"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kamera"),
            keywords: &["kamera", "video"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កាមេរ\u{17c9}ា\u{200b}"),
            keywords: &["កាមេរ\u{17c9}ា\u{200b}", "ម\u{17c9}ាស\u{17ca}\u{17b8}នថត"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{ccd}ಯಾಮರಾ"),
            keywords: &["ಕ\u{ccd}ಯಾಮರಾ", "ವೀಡ\u{cbf}ಯೊ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("카메라"),
            keywords: &["사진", "사진 촬영", "카메라"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("क\u{945}म\u{947}रा"),
            keywords: &["क\u{945}म\u{947}रा", "व\u{94d}हिडियो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("камера"),
            keywords: &["видео", "камера"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Fotoapparat"),
            keywords: &["Fotoapparat", "Video"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກ\u{ec9}ອງຖ\u{ec8}າຍຮ\u{eb9}ບ"),
            keywords: &[
                "ກ\u{ec9}ອງ",
                "ກ\u{ec9}ອງຖ\u{ec8}າຍຮ\u{eb9}ບ",
                "ຖ\u{ec8}າຍຮ\u{eb9}ບ",
                "ວ\u{eb4}ດ\u{eb5}ໂອ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("fotoaparatas"),
            keywords: &["fotoaparatas", "vaizdo įrašas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("fotokamera"),
            keywords: &["fotoaparāts", "fotokamera", "kamera"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pūwhakaahua"),
            keywords: &["ataata", "pūwhakaahua"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("фотоапарат"),
            keywords: &["видео", "камера", "фотоапарат"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d4d}യ\u{d3e}മറ"),
            keywords: &["ക\u{d4d}യ\u{d3e}മറ", "ഫോട\u{d4d}ടോ", "വീഡിയോ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("камер"),
            keywords: &["видео", "камер"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("क\u{945}म\u{947}रा"),
            keywords: &["क\u{945}म\u{947}रा", "व\u{94d}हिडिओ"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kamera"),
            keywords: &["kamera", "video"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kamera"),
            keywords: &["kamera", "vidjo"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကင\u{103a}မရာ"),
            keywords: &["ကင\u{103a}မရာ", "ဗ\u{102e}ဒ\u{102e}ယ\u{102d}\u{102f}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kamera"),
            keywords: &["foto", "kamera", "kamerateknikk", "video"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("क\u{94d}याम\u{947}रा"),
            keywords: &["क\u{94d}याम\u{947}रा", "भिडियो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("camera"),
            keywords: &["camera", "video"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kamera"),
            keywords: &["foto", "kamera", "kamerateknikk", "video"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b4d}ୟ\u{b3e}ମେର\u{b3e}"),
            keywords: &["କ\u{b4d}ୟ\u{b3e}ମେର\u{b3e}", "ଭ\u{b3f}ଡ\u{b3f}ଓ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a48}ਮਰਾ"),
            keywords: &["ਕ\u{a48}ਮਰਾ", "ਵੀਡੀਓ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کیمرہ"),
            keywords: &["ویڈیو", "کیمرہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kámẹ\u{301}ra"),
            keywords: &["Kámẹ\u{301}ra", "Vídio"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("aparat fotograficzny"),
            keywords: &[
                "aparat fotograficzny",
                "fotografia",
                "robić zdjęcie",
                "wideo",
                "zdjęcie",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کامره"),
            keywords: &["ويډيو", "کامره"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("câmera"),
            keywords: &["câmera", "vídeo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("máquina fotográfica"),
            keywords: &["foto", "fotografia", "máquina fotográfica"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("camara"),
            keywords: &["camara"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cameră foto"),
            keywords: &[
                "aparat de fotografiat",
                "cameră foto",
                "fotografie",
                "video",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-692"),
            keywords: &["E10-692"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("фотоаппарат"),
            keywords: &["съемка", "фото", "фотоаппарат", "фотокамера"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("kamera"),
            keywords: &["kamera", "videwo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪئميرا"),
            keywords: &["ويڊيو", "ڪئميرا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කැමර\u{dcf}ව"),
            keywords: &["කැමර\u{dcf}ව", "ව\u{dd3}ඩ\u{dd2}\u{dd2}යෝව"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("fotoaparát"),
            keywords: &["fotoaparát", "video"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("fotoaparat"),
            keywords: &["fotoaparat", "video"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kamarad"),
            keywords: &["fiidiyow", "kamarad"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kamerë"),
            keywords: &["kamerë", "video"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("фотоапарат"),
            keywords: &["видeo", "фотоапарат"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("fotoaparat"),
            keywords: &["fotoaparat", "video"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kamera"),
            keywords: &["kamera", "video"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kamera"),
            keywords: &["kamera", "video"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கேமர\u{bbe}"),
            keywords: &["கேமர\u{bbe}", "படம\u{bcd}", "புகைப\u{bcd}படம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c46}మ\u{c46}ర\u{c3e}"),
            keywords: &["క\u{c46}మ\u{c46}ర\u{c3e}", "వ\u{c40}డ\u{c3f}య\u{c4b}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("камера"),
            keywords: &["видео", "камера"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("กล\u{e49}อง"),
            keywords: &["กล\u{e49}อง", "ว\u{e34}ด\u{e35}โอ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kamera"),
            keywords: &["kamera", "wideo"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("faitā"),
            keywords: &["faitā"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("fotoğraf makinesi"),
            keywords: &["fotoğraf makinesi", "video"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كامېرا"),
            keywords: &["سىن", "كامېرا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("фотоапарат"),
            keywords: &["відео", "фотоапарат"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کیمرا"),
            keywords: &["ویڈیو", "کیمرا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kamera"),
            keywords: &["kamera", "video"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("máy ảnh"),
            keywords: &["máy ảnh", "video"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("nataalukaay"),
            keywords: &["nataalukaay", "wideo"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ikhamera"),
            keywords: &["ikhamera", "ividoyo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("kámẹ\u{301}rà"),
            keywords: &["fídíò", "kámẹ\u{301}rà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("相機"),
            keywords: &["影片", "相機"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("相机"),
            keywords: &["影片", "相机"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("相机"),
            keywords: &["卡片相机", "拍照", "摄影", "照片", "照相机", "相机"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("相機"),
            keywords: &["相機"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ikhamera"),
            keywords: &["ikhamera", "ividiyo"],
        },
    ],
};
#[doc = "📸"]
pub const CAMERA_WITH_FLASH: crate::Emoji = crate::Emoji {
    glyph: "📸",
    codepoint: "1F4F8",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "camera with flash",
    group: "Objects",
    subgroup: "light & video",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kamera met flits"),
            keywords: &["flits", "foto", "kamera", "kamera met flits", "video"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ባለፍላሽ ካሜራ"),
            keywords: &["ባለፍላሽ ካሜራ", "ቪዲዮ", "ካሜራ", "ፍላሽ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كاميرا بفلاش"),
            keywords: &["فلاش", "فيديو", "كاميرا", "كاميرا بفلاش"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ফ\u{9cd}ল\u{9be}শ\u{9cd}ব সহ কেমেৰ\u{9be}"),
            keywords: &[
                "কেমেৰ\u{9be}",
                "ফ\u{9cd}ল\u{9be}শ\u{9cd}ব",
                "ফ\u{9cd}ল\u{9be}শ\u{9cd}ব সহ কেমেৰ\u{9be}",
                "ভিডিঅ’",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("işıqlı kamera"),
            keywords: &["işıq", "işıqlı kamera", "kamera", "video"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("камера з успышкай"),
            keywords: &["здымка", "камера", "камера з успышкай", "успышка", "фота"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Фотоапарат със светкавица"),
            keywords: &["Фотоапарат със светкавица", "светкавица", "фотоапарат"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ফ\u{9cd}ল\u{9cd}য\u{9be}শয\u{9c1}ক\u{9cd}ত ক\u{9cd}য\u{9be}মের\u{9be}"),
            keywords: &[
                "ক\u{9cd}য\u{9be}মের\u{9be}",
                "ফ\u{9cd}ল\u{9cd}য\u{9be}শ",
                "ফ\u{9cd}ল\u{9cd}য\u{9be}শয\u{9c1}ক\u{9cd}ত ক\u{9cd}য\u{9be}মের\u{9be}",
                "ভিডিও",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("lucʼhskeudennerez gant lucʼheder"),
            keywords: &[
                "lucʼheder",
                "lucʼhskeudennerez",
                "lucʼhskeudennerez gant lucʼheder",
                "video",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("fotoaparat sa blicom"),
            keywords: &["blic", "fotoaparat sa blicom", "kamera", "video"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("càmera amb flaix"),
            keywords: &["càmera", "càmera amb flaix", "flaix", "vídeo"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄇𑄬𑄟𑄬𑄢 𑄣\u{11127}𑄉𑄬 𑄜\u{11133}𑄣𑄌\u{11134}"),
            keywords: &["𑄇𑄬𑄟𑄬𑄢 𑄣\u{11127}𑄉𑄬 𑄜\u{11133}𑄣𑄌\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᏓᏟᎶᏍᏙᏗ ᎤᏥᏍᏓᎷᎩ ᎠᏩᏠᏯᏍᏓ"),
            keywords: &["ᎠᏗᏴᎳᏛᏍᎩ", "ᎤᏥᏍᏓᎷᎩ", "ᏗᏓᏟᎶᏍᏙᏗ", "ᏗᏓᏟᎶᏍᏙᏗ ᎤᏥᏍᏓᎷᎩ ᎠᏩᏠᏯᏍᏓ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("fotoaparát s bleskem"),
            keywords: &[
                "aparát",
                "blesk",
                "fotoaparát s bleskem",
                "fotografický",
                "foťák",
                "video",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("camera â fflach"),
            keywords: &["camera", "camera â fflach", "fflach", "fideo"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kamera med blitz"),
            keywords: &["blitz", "kamera", "kamera med blitz", "video"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Fotoapparat mit Blitz"),
            keywords: &["Blitz", "Fotoapparat", "Fotoapparat mit Blitz"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("φωτογραφική μηχανή με φλας"),
            keywords: &[
                "βίντεο",
                "βιντεοκάμερα",
                "φλας",
                "φωτογραφική μηχανή με φλας",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("camera with flash"),
            keywords: &["camera", "camera with flash", "flash", "video"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cámara con flash"),
            keywords: &["cámara", "cámara con flash", "flash"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("välguga kaamera"),
            keywords: &["foto", "kaamera", "pildistamine", "välguga kaamera", "välk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kamera flasharekin"),
            keywords: &["bideo", "flash", "kamera", "kamera flasharekin"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دوربین با فلاش"),
            keywords: &["دوربین", "دوربین با فلاش", "فلاش", "ویدیو"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kamera ja salama"),
            keywords: &["kamera", "kamera ja salama", "salama", "video"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("camera na may flash"),
            keywords: &["camera", "camera na may flash", "flash", "video"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("myndatól við blits"),
            keywords: &["blits", "fotografi", "myndatól", "myndatól við blits"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("appareil photo avec flash"),
            keywords: &["appareil photo", "appareil photo avec flash"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["appareil photo", "appareil photo avec flash", "flash"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ceamara le splanc"),
            keywords: &["ceamara", "ceamara le splanc", "físeán", "splanc"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("camara le solas-boillsgidh"),
            keywords: &[
                "boillsgeadh",
                "camara",
                "camara le solas-boillsgidh",
                "solas-boillsgidh",
                "video",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cámara de fotos con flash"),
            keywords: &["cámara", "cámara de fotos con flash", "flash", "fotografía"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ફ\u{acd}લ\u{ac7}શ સાથ\u{ac7}નો ક\u{ac5}મ\u{ac7}રો"),
            keywords: &[
                "કમ\u{ac7}રો",
                "ફ\u{acd}લ\u{ac7}શ",
                "ફ\u{acd}લ\u{ac7}શ સાથ\u{ac7}નો ક\u{ac5}મ\u{ac7}રો",
                "વિડિઓ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kyamara mai ƙyalla"),
            keywords: &["bidiyo", "kyamara", "kyamara mai ƙyalla", "ƙyalla"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מצלמה עם פלאש"),
            keywords: &["הבזק", "מבזק", "מצלמה", "מצלמה עם פלאש", "פלאש", "צילום"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("फ\u{93c}\u{94d}ल\u{948}श वाला क\u{948}मरा"),
            keywords: &[
                "क\u{948}मरा",
                "फ\u{93c}\u{94d}ल\u{948}श वाला क\u{948}मरा",
                "वीडियो",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("fotoaparat s bljeskalicom"),
            keywords: &[
                "bljeskalica",
                "fotoaparat",
                "fotoaparat s bljeskalicom",
                "video",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fényképező vakuval"),
            keywords: &["fényképező vakuval", "fényképezőgép", "vaku", "videó"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ֆոտոապարատ լուսաթարթիչով"),
            keywords: &[
                "լուսաթարթիչ",
                "վիդեո",
                "ֆոտոապարատ",
                "ֆոտոապարատ լուսաթարթիչով",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kamera dengan flash"),
            keywords: &["flash", "kamera", "kamera dengan flash", "video"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("igwefòto nwere ọkụ"),
            keywords: &["igwefòto", "igwefòto nwere ọkụ", "vidio", "ọkụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("myndavél með flassi"),
            keywords: &["flass", "myndavél", "myndavél með flassi", "myndband"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("fotocamera con flash"),
            keywords: &[
                "fotocamera con flash",
                "fotografare",
                "macchina fotografica con flash",
                "ricordi",
                "scattare foto",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("フラッシュを焚いているカメラ"),
            keywords: &[
                "カメラ",
                "カメラフラッシュ",
                "フラッシュを焚いているカメラ",
                "写真",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kamera mawa lampu jepret"),
            keywords: &[
                "kamera",
                "kamera mawa lampu jepret",
                "lampu jepret",
                "vidio",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ფოტოაპარატი ბლიცით"),
            keywords: &["ბლიცი", "ვიდეო", "კამერა", "მაშუქი", "ფოტოაპარატი ბლიცით"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жарқылы бар камера"),
            keywords: &["бейне", "жарқыл", "жарқылы бар камера", "камера"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kamera med blitz"),
            keywords: &["blitz", "kamera", "kamera med blitz", "video"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កាមេរ\u{17c9}ាបាញ\u{17cb}ភ\u{17d2}លើងហ\u{17d2}វ\u{17d2}លាស\u{17cb}"),
            keywords: &[
                "កាមេរ\u{17c9}ា",
                "កាមេរ\u{17c9}ាបាញ\u{17cb}ភ\u{17d2}លើងហ\u{17d2}វ\u{17d2}លាស\u{17cb}",
                "បាញ\u{17cb}ភ\u{17d2}លើង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಫ\u{ccd}ಲ\u{ccd}ಯಾಶ\u{ccd}\u{200c}ನೊಂದ\u{cbf}ಗ\u{cc6} ಕ\u{ccd}ಯಾಮರಾ"),
            keywords: &[
                "ಕ\u{ccd}ಯಾಮರಾ",
                "ಫ\u{ccd}ಲ\u{ccd}ಯಾಶ\u{ccd}",
                "ಫ\u{ccd}ಲ\u{ccd}ಯಾಶ\u{ccd}\u{200c}ನೊಂದ\u{cbf}ಗ\u{cc6} ಕ\u{ccd}ಯಾಮರಾ",
                "ವೀಡ\u{cbf}ಯೊ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("플래시를 터트리고 있는 카메라"),
            keywords: &["카메라", "플래시", "플래시를 터트리고 있는 카메라"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("फ\u{94d}ल\u{945}श आसपी क\u{945}म\u{947}रा"),
            keywords: &[
                "क\u{945}म\u{947}रा",
                "फ\u{94d}ल\u{945}श",
                "फ\u{94d}ल\u{945}श आसपी क\u{945}म\u{947}रा",
                "व\u{94d}हिडियो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жаркылдагы менен камера"),
            keywords: &["видео", "жаркылдагы менен камера", "жаркылдак", "камера"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Fotoapparat mat Blëtz"),
            keywords: &[
                "Blëtz",
                "Flash",
                "Fotoapparat",
                "Fotoapparat mat Blëtz",
                "Kamera",
                "Video",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກ\u{ec9}ອງຖ\u{ec8}າຍຮ\u{eb9}ບເປ\u{eb5}ດແຟຣ\u{eb1}ຊ"),
            keywords: &[
                "ກ\u{ec9}ອງ",
                "ກ\u{ec9}ອງຖ\u{ec8}າຍຮ\u{eb9}ບເປ\u{eb5}ດແຟຣ\u{eb1}ຊ",
                "ຖ\u{ec8}າຍຮ\u{eb9}ບ",
                "ແຟຣ\u{eb1}ຊ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("fotoaparatas su blykste"),
            keywords: &[
                "blykstė",
                "fotoaparatas",
                "fotoaparatas su blykste",
                "vaizdo įrašas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("fotokamera ar zibspuldzi"),
            keywords: &[
                "fotoaparāts",
                "fotokamera",
                "fotokamera ar zibspuldzi",
                "kamera",
                "zibspuldze",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pūwhakaahua whai hikohiko"),
            keywords: &[
                "ataata",
                "hikohiko",
                "pūwhakaahua",
                "pūwhakaahua whai hikohiko",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("фотоапарат со блиц"),
            keywords: &["блиц", "фотоапарат", "фотоапарат со блиц"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഫ\u{d4d}ല\u{d3e}ഷ\u{d41}ള\u{d4d}ള ക\u{d4d}യ\u{d3e}മറ"),
            keywords: &[
                "ക\u{d4d}യ\u{d3e}മറ",
                "ഫ\u{d4d}ല\u{d3e}ഷ\u{d41}ള\u{d4d}ള ക\u{d4d}യ\u{d3e}മറ",
                "ഫ\u{d4d}ല\u{d3e}ഷ\u{d4d}",
                "വീഡിയോ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гэрэл асдаг камер"),
            keywords: &["видео", "гэрэл", "гэрэл асдаг камер", "камер"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("फ\u{94d}ल\u{945}शसह क\u{945}म\u{947}रा"),
            keywords: &[
                "क\u{945}म\u{947}रा",
                "फ\u{94d}ल\u{945}श",
                "फ\u{94d}ल\u{945}शसह क\u{945}म\u{947}रा",
                "व\u{94d}हिडिओ",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kamera dengan denyar"),
            keywords: &["denyar", "kamera", "kamera dengan denyar", "video"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kamera bi flash"),
            keywords: &["flash", "kamera", "kamera bi flash", "vidjo"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မ\u{102e}းပါသည\u{1037}\u{103a} ကင\u{103a}မရာ"),
            keywords: &[
                "ကင\u{103a}မရာ",
                "ဖလက\u{103a}ရ\u{103e}\u{103a}",
                "ဖလက\u{103a}ရ\u{103e}\u{103a}မ\u{102e}းပါသည\u{1037}\u{103a} ကင\u{103a}မရာ",
                "ဗ\u{102e}ဒ\u{102e}ယ\u{102d}\u{102f}",
                "မ\u{102e}းပါသည\u{1037}\u{103a} ကင\u{103a}မရာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kamera med blits"),
            keywords: &["blits", "foto", "kamera", "kamera med blits", "video"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("फ\u{94d}ल\u{94d}याशसहितको क\u{94d}याम\u{947}रा"),
            keywords: &[
                "क\u{94d}याम\u{947}रा",
                "फ\u{94d}ल\u{94d}याश",
                "फ\u{94d}ल\u{94d}याशसहितको क\u{94d}याम\u{947}रा",
                "भिडियो",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("camera met flitser"),
            keywords: &["camera", "camera met flitser", "flitser", "video"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kamera med blits"),
            keywords: &["blits", "foto", "kamera", "kamera med blits", "video"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଫ\u{b4d}ଲ\u{b3e}ଶ\u{b4d}\u{200c} ସହ\u{b3f}ତ କ\u{b4d}ୟ\u{b3e}ମେର\u{b3e}"),
            keywords: &[
                "କ\u{b4d}ୟ\u{b3e}ମେର\u{b3e} । ଫ\u{b4d}ଲ\u{b3e}ଶ\u{b4d}\u{200c} । ଭ\u{b3f}ଡ\u{b3f}ଓ",
                "ଫ\u{b4d}ଲ\u{b3e}ଶ\u{b4d}\u{200c} ସହ\u{b3f}ତ କ\u{b4d}ୟ\u{b3e}ମେର\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਫਲ\u{a48}ਸ\u{a3c} ਵਾਲਾ ਕ\u{a48}ਮਰਾ"),
            keywords: &[
                "ਕ\u{a48}ਮਰਾ",
                "ਫਲ\u{a48}ਸ",
                "ਫਲ\u{a48}ਸ\u{a3c} ਵਾਲਾ ਕ\u{a48}ਮਰਾ",
                "ਵੀਡੀਓ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("فلیشن نال کیمرہ"),
            keywords: &["فلیشن نال کیمرہ", "ویڈیو", "چمچمونا", "کیمرہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kámẹ\u{301}ra Wé Gẹ\u{301}t Flash"),
            keywords: &[
                "Flash",
                "Kámẹ\u{301}ra",
                "Kámẹ\u{301}ra Wé Gẹ\u{301}t Flash",
                "Vídio",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("aparat fotograficzny z lampą błyskową"),
            keywords: &[
                "aparat",
                "aparat fotograficzny z lampą błyskową",
                "flesz",
                "lampa błyskowa",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("فلش لرونکې کامره"),
            keywords: &["فلش", "فلش لرونکې کامره", "ويډيو", "کامره"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("câmera com flash"),
            keywords: &["câmera", "câmera com flash", "flash", "vídeo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("máquina fotográfica com flash"),
            keywords: &["câmara", "flash", "máquina fotográfica com flash", "vídeo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("camara flash kaqwan"),
            keywords: &["camara flash kaqwan"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cameră foto cu bliț"),
            keywords: &[
                "aparat de fotografiat",
                "bliț",
                "cameră foto cu bliț",
                "fotografie",
                "video",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-693"),
            keywords: &["E10-693"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("фотоаппарат со вспышкой"),
            keywords: &[
                "вспышка",
                "съемка",
                "фото",
                "фотоаппарат",
                "фотоаппарат со вспышкой",
                "фотокамера",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("kamera ifite umurabyo"),
            keywords: &["kamera", "kamera ifite umurabyo", "umurabyo", "videwo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("فليش واري ڪئميرا"),
            keywords: &["فليش", "فليش واري ڪئميرا", "ويڊيو", "ڪئميرا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ෆ\u{dca}ලෑෂරය සහ\u{dd2}ත කැමර\u{dcf}ව"),
            keywords: &[
                "කමර\u{dcf}ව",
                "ව\u{dd3}ඩ\u{dd2}යෝව",
                "ෆ\u{dca}ලෑෂරය සහ\u{dd2}ත කැමර\u{dcf}ව",
                "ෆ\u{dca}ලෑෂ\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("fotoaparát s bleskom"),
            keywords: &["blesk", "fotoaparát", "fotoaparát s bleskom", "video"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("fotoaparat z bliskavico"),
            keywords: &[
                "bliskavica",
                "fotoaparat",
                "fotoaparat z bliskavico",
                "video",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kamarad khashaafad leh"),
            keywords: &[
                "fiidiyow",
                "kamarad",
                "kamarad khashaafad leh",
                "khashaafad",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kamerë me blic"),
            keywords: &["blic", "kamerë", "kamerë me blic", "video"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("фотоапарат са блицем"),
            keywords: &["блиц", "видeo", "фoтoaпaрaт", "фотоапарат са блицем"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("fotoaparat sa blicem"),
            keywords: &["blic", "fotoaparat", "fotoaparat sa blicem", "video"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kamera med blixt"),
            keywords: &["blixt", "kamera", "kamera med blixt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kamera yenye mmweko"),
            keywords: &["kamera", "kamera yenye mmweko", "mmweko", "video"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பிள\u{bbe}ஷ\u{bcd} அடிக\u{bcd}கும\u{bcd} கேமர\u{bbe}"),
            keywords: &[
                "பிள\u{bbe}ஷ\u{bcd} அடிக\u{bcd}கும\u{bcd} கேமர\u{bbe}",
                "பிள\u{bbe}ஷ\u{bcd} கேமர\u{bbe}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఫ\u{c4d}ల\u{c3e}ష\u{c4d} క\u{c46}మ\u{c46}ర\u{c3e}"),
            keywords: &[
                "క\u{c46}మ\u{c46}ర\u{c3e}",
                "ఫ\u{c4b}ట\u{c4b} త\u{c40}యడం",
                "ఫ\u{c4d}ల\u{c3e}ష\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("камера бо дурахш"),
            keywords: &["видео", "дурахш", "камера", "камера бо дурахш"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("กล\u{e49}องเป\u{e34}ดแฟลช"),
            keywords: &[
                "กล\u{e49}อง",
                "กล\u{e49}องเป\u{e34}ดแฟลช",
                "ว\u{e34}ด\u{e35}โอ",
                "แฟลช",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("wspyşkaly kamera"),
            keywords: &["kamera", "wideo", "wspyşka", "wspyşkaly kamera"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("faitā moe kasa"),
            keywords: &["faitā moe kasa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("flaşlı fotoğraf makinesi"),
            keywords: &["flaş", "flaşlı fotoğraf makinesi", "kamera", "video"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چىراقلىق كامېرا"),
            keywords: &["سىن", "كامېرا", "چاقماق چىراق", "چىراقلىق كامېرا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("фотоапарат зі спалахом"),
            keywords: &["відео", "камера", "спалах", "фотоапарат зі спалахом"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("فلیش والا کیمرا"),
            keywords: &["فلیش", "فلیش والا کیمرا", "ویڈیو", "کیمرا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("chaqmoqli kamera"),
            keywords: &["chaqmoqli kamera", "kamera", "video"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("máy ảnh có đèn flash"),
            keywords: &["máy ảnh", "máy ảnh có đèn flash", "video", "đèn flash"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("nataalukaay bu ànd ak flaas"),
            keywords: &[
                "flash",
                "nataalukaay",
                "nataalukaay bu ànd ak flaas",
                "wideo",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ikhamera enefleshi"),
            keywords: &["ifleshi", "ikhamera", "ikhamera enefleshi", "ividiyo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("kámẹ\u{301}rà pẹlu filaṣi"),
            keywords: &[
                "fídíò",
                "fílásì",
                "kámẹ\u{301}rà",
                "kámẹ\u{301}rà pẹlu filaṣi",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("閃光燈相機"),
            keywords: &["影片", "相機", "閃光", "閃光燈相機"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("闪光灯相机"),
            keywords: &["影片", "相机", "闪光", "闪光灯相机"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("开闪光灯的相机"),
            keywords: &["开闪光灯的相机", "拍照", "相机", "闪光灯", "闪光灯打开"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("開閃光燈"),
            keywords: &["拍照", "開閃光燈"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("開咗閃光燈嘅相機"),
            keywords: &["照", "開咗閃光燈嘅相機", "開閃光燈｜相機"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ikhamera enefleshi"),
            keywords: &["ifleshi", "ikhamera", "ikhamera enefleshi", "ividiyo"],
        },
    ],
};
#[doc = "📹"]
pub const VIDEO_CAMERA: crate::Emoji = crate::Emoji {
    glyph: "📹",
    codepoint: "1F4F9",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "video camera",
    group: "Objects",
    subgroup: "light & video",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("videokamera"),
            keywords: &["kamera", "video", "videokamera"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የቪዲዮ ካሜራ"),
            keywords: &["ቪዲዮ", "ካሜራ", "የቪዲዮ ካሜራ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كاميرا فيديو"),
            keywords: &["فيديو", "كاميرا"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ভিডিঅ’ কেমেৰ\u{9be}"),
            keywords: &["কেমেৰ\u{9be}", "ভিডিঅ’"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("video kamera"),
            keywords: &["kamera", "video"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("відэакамера"),
            keywords: &["відэа", "відэакамера", "здымка", "камера"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("видеокамера"),
            keywords: &["видео", "видеокамера", "камера"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ভিডিও ক\u{9cd}য\u{9be}মের\u{9be}"),
            keywords: &["ক\u{9cd}য\u{9be}মের\u{9be}", "ভিডিও"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kamenroller"),
            keywords: &["kamenroller", "video"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("digitalna kamera"),
            keywords: &["digitalna kamera", "kamera", "video"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("càmera de vídeo"),
            keywords: &["càmera", "càmera de vídeo", "vídeo"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄞\u{11128}𑄓\u{11128}𑄠\u{1112e} 𑄇𑄬𑄟𑄬𑄢"),
            keywords: &["𑄞\u{11128}𑄓\u{11128}𑄠\u{1112e} 𑄇𑄬𑄟𑄬𑄢"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏓᏴᎵᏛᏍᎩ ᏗᏓᏟᎶᏍᏗᏍᎩ"),
            keywords: &["ᎠᏓᏴᎵᏛᏍᎩ ᏗᏓᏟᎶᏍᏗᏍᎩ", "ᎠᏗᏴᎳᏛᏍᎩ", "ᏗᏓᏟᎶᏍᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("videokamera"),
            keywords: &["kamera", "video", "videokamera"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("camera fideo"),
            keywords: &["camera", "fideo"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("videokamera"),
            keywords: &["kamera", "video", "videokamera"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Videokamera"),
            keywords: &["Videokamera", "Videos"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("βιντεοκάμερα"),
            keywords: &["βίντεο", "βιντεοκάμερα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("video camera"),
            keywords: &["camera", "video"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["camcorder", "camera", "video"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("videocámara"),
            keywords: &["cámara", "videocámara", "vídeo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["cámara", "video", "videocámara"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("videokaamera"),
            keywords: &["kaamera", "video", "videokaamera"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bideokamera"),
            keywords: &["bideoa", "bideokamera", "kamera"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دوربین فیلم\u{200c}برداری"),
            keywords: &["دوربین", "دوربین فیلم\u{200c}برداری", "ویدیو"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("videokamera"),
            keywords: &["kamera", "video", "videokamera"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("video camera"),
            keywords: &["camera", "video"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sjónupptøkutól"),
            keywords: &["myndatól", "sjónupptøkutól", "upptøkutól", "video"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("caméscope"),
            keywords: &["caméra", "caméscope", "vidéo"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["caméra", "caméscope", "vidéo"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("físcheamara"),
            keywords: &["físcheamara"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("camara-video"),
            keywords: &["camara", "camara-video", "video"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cámara de vídeo"),
            keywords: &["cámara", "cámara de vídeo", "vídeo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વિડિઓ ક\u{ac5}મ\u{ac7}રો"),
            keywords: &["ક\u{ac5}મ\u{ac7}રો", "વિડિઓ", "વિડિઓ ક\u{ac5}મ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kyamarar bidiyo"),
            keywords: &["bidiyo", "kyamara", "kyamarar bidiyo"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מצלמת וידאו"),
            keywords: &["וידאו", "מצלמה", "מצלמת וידאו", "צילום"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("वीडियो क\u{948}मरा"),
            keywords: &["क\u{948}मरा", "वीडियो"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("videokamera"),
            keywords: &["kamera", "video", "videokamera"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("videokamera"),
            keywords: &["kamera", "videokamera", "videók"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տեսախցիկ"),
            keywords: &["վիդեո", "տեսախցիկ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kamera video"),
            keywords: &["kamera", "video"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("igwefòto vidio"),
            keywords: &["igwefòto", "vidio"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("lítil kvikmyndatökuvél"),
            keywords: &["lítil kvikmyndatökuvél", "myndavél", "vídeó"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("videocamera"),
            keywords: &["telecamera", "video", "videocamera"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ビデオカメラ"),
            keywords: &["カメラ", "ビデオ", "ビデオカメラ", "ムービー", "動画"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kamera vidio"),
            keywords: &["kamera", "vidio"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ვიდეოკამერა"),
            keywords: &["ვიდეო", "ვიდეოკამერა", "კამერა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бейнекамера"),
            keywords: &["бейне", "бейнекамера", "камера"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("videokamera"),
            keywords: &["kamera", "video", "videokamera"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កាមេរ\u{17c9}ាថតវ\u{17b8}ដេអ\u{17bc}"),
            keywords: &[
                "កាមេរ\u{17c9}ា",
                "កាមេរ\u{17c9}ាថតវ\u{17b8}ដេអ\u{17bc}",
                "វ\u{17b8}ដេអ\u{17bc}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ವೀಡ\u{cbf}ಯೊ ಕ\u{ccd}ಯಾಮರಾ"),
            keywords: &["ಕ\u{ccd}ಯಾಮರಾ", "ಕ\u{ccd}ಯಾಮ\u{ccd}", "ವೀಡ\u{cbf}ಯೊ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("캠코더"),
            keywords: &["동영상 촬영", "비디오 카메라", "캠코더"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("व\u{94d}हिडियो क\u{945}म\u{947}रा"),
            keywords: &["क\u{945}म\u{947}रा", "व\u{94d}हिडियो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("видео камера"),
            keywords: &["видео", "камера"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Videokamera"),
            keywords: &["Kamera", "Video", "Videokamera"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກ\u{ec9}ອງວ\u{eb4}ດ\u{eb5}ໂອ"),
            keywords: &[
                "ກ\u{ec9}ອງ",
                "ກ\u{ec9}ອງວ\u{eb4}ດ\u{eb5}ໂອ",
                "ວ\u{eb4}ດ\u{eb5}ໂອ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vaizdo kamera"),
            keywords: &["fotoaparatas", "vaizdo kamera", "vaizdo įrašas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("videokamera"),
            keywords: &["kamera", "videokamera"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pūwhakaahua ataata"),
            keywords: &["ataata", "pūwhakaahua"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("видеокамера"),
            keywords: &["видео", "видеокамера", "камера"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വീഡിയോ ക\u{d4d}യ\u{d3e}മറ"),
            keywords: &["ക\u{d4d}യ\u{d3e}മറ", "വീഡിയോ", "വെബ\u{d4d} ക\u{d3e}ം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("видео камер"),
            keywords: &["видео", "камер"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("व\u{94d}हिडिओ क\u{945}म\u{947}रा"),
            keywords: &["क\u{945}म\u{947}रा", "व\u{94d}हिडिओ"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kamera video"),
            keywords: &["kamera", "video"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("vidjo kamera"),
            keywords: &["kamera", "vidjo"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဗ\u{102e}ဒ\u{102e}ယ\u{102d}\u{102f} ကင\u{103a}မရာ"),
            keywords: &["ကင\u{103a}မရာ", "ဗ\u{102e}ဒ\u{102e}ယ\u{102d}\u{102f}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("videokamera"),
            keywords: &["kamera", "video", "videokamera"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("भिडियो क\u{94d}याम\u{947}रा"),
            keywords: &["क\u{94d}याम\u{947}रा", "भिडियो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("videocamera"),
            keywords: &["camera", "video", "videocamera"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("videokamera"),
            keywords: &["kamera", "video", "videokamera"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଭ\u{b3f}ଡ\u{b3f}ଓ କ\u{b4d}ୟ\u{b3e}ମେର\u{b3e}"),
            keywords: &[
                "କ\u{b4d}ୟ\u{b3e}ମେର\u{b3e}",
                "ଭ\u{b3f}ଡ\u{b3f}ଓ",
                "ଭ\u{b3f}ଡ\u{b3f}ଓ କ\u{b4d}ୟ\u{b3e}ମ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਵੀਡੀਓ ਕ\u{a48}ਮਰਾ"),
            keywords: &["ਕ\u{a48}ਮਰਾ", "ਵੀਡੀਓ", "ਵੀਡੀਓ ਕ\u{a48}ਮ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ویڈیو کیمرہ"),
            keywords: &["ویڈیو", "کیمرہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Vídió Kámẹ\u{301}ra"),
            keywords: &["Kámẹ\u{301}ra", "Vídio", "Vídió Kámẹ\u{301}ra"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kamera wideo"),
            keywords: &["kamera", "wideo"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ویډیو کامره"),
            keywords: &["ویډیو کامره"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("câmera de vídeo"),
            keywords: &["câmera", "câmera de vídeo", "vídeo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("câmara de vídeo"),
            keywords: &["câmara", "câmara de vídeo", "vídeo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("videocamara"),
            keywords: &["videocamara"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cameră video"),
            keywords: &["cameră", "filmare", "video"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-694"),
            keywords: &["E10-694"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("видеокамера"),
            keywords: &["видео", "видеокамера", "запись", "съемка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("kamera ya videwo"),
            keywords: &["kamera ya videwo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ويڊيو ڪئميرا"),
            keywords: &["ويڊيو", "ڪئميرا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ව\u{dd3}ඩ\u{dd2}යෝ කැමර\u{dcf}ව"),
            keywords: &[
                "කැමර\u{dcf}ව",
                "ව\u{dd3}ඩ\u{dd2}යෝ කැමර\u{dcf}ව",
                "ව\u{dd3}ඩ\u{dd2}යෝව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("videokamera"),
            keywords: &["fotoaparát", "video", "videokamera"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("videokamera"),
            keywords: &["video", "videokamera"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kamarad fiidiyow"),
            keywords: &["fiidiyow", "kamarad"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("videokamerë"),
            keywords: &["kamerë", "video", "videokamerë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("видео камера"),
            keywords: &["видео", "камера"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["видео камера"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("video kamera"),
            keywords: &["kamera", "video"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["video kamera"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("videokamera"),
            keywords: &["kamera", "video", "videokamera"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kamera ya kurekodi video"),
            keywords: &["kamera", "kamera ya kurekodi video", "video"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வ\u{bc0}டியோ கேமர\u{bbe}"),
            keywords: &[
                "கேம\u{bcd} க\u{bbe}ர\u{bcd}டர\u{bcd}",
                "வ\u{bc0}டியோ",
                "வ\u{bc0}டியோ கேமர\u{bbe}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వ\u{c40}డ\u{c3f}య\u{c4b} క\u{c46}మ\u{c46}ర\u{c3e}"),
            keywords: &["క\u{c46}మ\u{c46}ర\u{c3e}", "వ\u{c40}డ\u{c3f}య\u{c4b}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("видеокамера"),
            keywords: &["видео", "видеокамера", "камера"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("กล\u{e49}องว\u{e34}ด\u{e35}โอ"),
            keywords: &[
                "กล\u{e49}อง",
                "กล\u{e49}องว\u{e34}ด\u{e35}โอ",
                "ว\u{e34}ด\u{e35}โอ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("wideokamera"),
            keywords: &["kamera", "wideo", "wideokamera"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("faitā vitiō"),
            keywords: &["faitā vitiō"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("video kamera"),
            keywords: &["kamera", "video"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سىن كامېرا"),
            keywords: &["سىن", "كامېرا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("відеокамера"),
            keywords: &["відео", "відеокамера", "камера"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ویڈیو کیمرا"),
            keywords: &["ویڈیو", "کیمرا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("videokamera"),
            keywords: &["kamera", "video", "videokamera"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("máy quay video"),
            keywords: &["máy quay phim", "máy quay video", "video"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("nataalukaay wideo"),
            keywords: &["kameraa wideo", "nataalukaay wideo"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ikhamera yevidiyo"),
            keywords: &["ikhamera", "ikhamera yevidiyo", "ividiyo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ayàwòrán fídíò"),
            keywords: &["ayàwòrán fídíò", "fídíò", "kámé\u{329}rà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("錄像機"),
            keywords: &["影片", "相機", "錄像機"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("录像机"),
            keywords: &["录像机", "影片", "相机"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("摄像机"),
            keywords: &["录像", "录影", "拍摄", "摄像机", "摄影机", "视频"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("攝影機"),
            keywords: &["攝影機", "錄影"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("錄影機"),
            keywords: &["攝影機", "錄影機"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ividiyo khamera"),
            keywords: &["ikhamera", "ividiyo", "ividiyo khamera"],
        },
    ],
};
#[doc = "📼"]
pub const VIDEOCASSETTE: crate::Emoji = crate::Emoji {
    glyph: "📼",
    codepoint: "1F4FC",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "videocassette",
    group: "Objects",
    subgroup: "light & video",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("videokasset"),
            keywords: &["band", "kasset", "vhs", "video", "videokasset"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የቪዲዮ ካሴት"),
            keywords: &["ቪዲዮ", "ቴፕ", "የቪዲዮ ካሴት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شريط فيديو"),
            keywords: &["شريط", "فيديو"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ভিডিঅ’ কেছেট"),
            keywords: &["টেপ", "ভিএইচ\u{9cd}ছএছ", "ভিডিঅ’", "ভিডিঅ’ কেছেট"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("video kaset"),
            keywords: &["kasset", "vhs", "video", "video kaset"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("відэакасета"),
            keywords: &["відэа", "відэакасета", "касета", "плёнка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("видеокасета"),
            keywords: &["[vhs]", "видео", "видеокасета", "лента"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ভিডিও ক\u{9cd}য\u{9be}সেট"),
            keywords: &["টেপ", "ভিএচইএস", "ভিডিও", "ভিডিও ক\u{9cd}য\u{9be}সেট"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kasedig-video"),
            keywords: &["kasedig-video", "video"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("video-kaseta"),
            keywords: &["kaseta", "vhs", "video", "video-kaseta"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("videocasset"),
            keywords: &["cinta", "vhs", "videocasset", "vídeo"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄞\u{11128}𑄓\u{11128}𑄠\u{1112e}𑄇𑄬𑄥𑄬𑄖\u{11134}"),
            keywords: &["𑄞\u{11128}𑄓\u{11128}𑄠\u{1112e}𑄇𑄬𑄥𑄬𑄖\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏠᏗ ᏗᎧᏃᎩᏍᎩ"),
            keywords: &["vhs", "ᎦᏠᏗ", "ᎦᏠᏗ ᏗᎧᏃᎩᏍᎩ", "ᏗᏓᏴᎳᏛᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("videokazeta"),
            keywords: &["kazeta", "pásek", "páska", "vhs", "video", "videokazeta"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("casét fideo"),
            keywords: &["casét fideo", "fideo", "tap", "vhs"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("videobånd"),
            keywords: &["video", "videobånd"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Videokassette"),
            keywords: &["Video", "Videokassette"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("βιντεοκασέτα"),
            keywords: &["vhs", "βίντεο", "βιντεοκασέτα", "κασέτα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("videocassette"),
            keywords: &["tape", "vhs", "video", "videocassette"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["VHS", "tape", "video", "videocassette"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cinta de vídeo"),
            keywords: &["cinta", "cinta de vídeo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cinta de video"),
            keywords: &["cinta", "cinta de video", "video"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("videocasete"),
            keywords: &["videocasete"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("videocassette"),
            keywords: &["cinta", "vhs", "video", "videocassette"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("videokassett"),
            keywords: &["kassett", "video", "videokassett"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bideo-kasetea"),
            keywords: &["bideo", "bideo-kasetea", "vhs", "zinta"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کاست ویدیویی"),
            keywords: &["نوار", "ویدیو", "وی\u{200c}اچ\u{200c}اس", "کاست ویدیویی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("videokasetti"),
            keywords: &["VHS", "nauha", "video", "videokasetti", "videonauha"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("videotape"),
            keywords: &["tape", "vhs", "video", "videocassette", "videotape"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sjónband"),
            keywords: &["band", "sjónband", "sjónbandshúsi", "video"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cassette vidéo"),
            keywords: &["cassette vidéo", "vhs", "vidéocassette"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["cassette", "vhs", "vidéo"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("fístéip"),
            keywords: &["físeán", "fístéip", "téip"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cèiseag-video"),
            keywords: &["cèiseag-video", "teip", "vhs", "video"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("videocasete"),
            keywords: &["VHS", "cinta", "cinta de vídeo", "videocasete"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વિડિઓક\u{ac7}સ\u{ac7}ટ"),
            keywords: &["ટ\u{ac7}પ", "વિડિઓ", "વિડિઓક\u{ac7}સ\u{ac7}ટ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kaset na bidiyo"),
            keywords: &["bidiyo", "kaset", "kaset na bidiyo", "vhs"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קלטת וידאו"),
            keywords: &["וידאו", "קלטת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("वीडियो क\u{948}स\u{947}ट"),
            keywords: &["vhs", "ट\u{947}प", "वीडियो", "वीडियो क\u{948}स\u{947}ट"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("videokaseta"),
            keywords: &["vhs", "video", "videokaseta", "vrpca"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("videokazetta"),
            keywords: &["kazetta", "szalag", "videokazetta", "videó"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տեսաերիզ"),
            keywords: &["vhs", "երիզ", "վիդեո", "տեսաերիզ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kaset video"),
            keywords: &["kaset video", "pita", "vhs", "video"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("vidiokaseeti"),
            keywords: &["tepụ", "vhs", "vidio", "vidiokaseeti"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("myndbandsspóla"),
            keywords: &["myndbandsspóla", "vídeóspóla"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("videocassetta"),
            keywords: &["VHS", "cassetta", "video", "videocassetta"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ビデオテープ"),
            keywords: &["VHS", "ビデオカセット", "ビデオテープ", "動画"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kaset vidio"),
            keywords: &["kaset vidio", "tape", "vhs", "vidio"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ვიდეოკასეტა"),
            keywords: &["vhs", "ვიდეო", "ვიდეოკასეტა", "კასეტა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бейне кассета"),
            keywords: &["vhs", "бейне", "кассета"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("videobånd"),
            keywords: &["video", "videobånd"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ដ\u{17bb}\u{17c6}កាសែតវ\u{17b8}ដេអ\u{17bc}"),
            keywords: &[
                "កាសែត",
                "កាសែតវ\u{17b8}ដេអ\u{17bc}",
                "ដ\u{17bb}\u{17c6}កាសែតវ\u{17b8}ដេអ\u{17bc}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ವೀಡ\u{cbf}ಯೊಕ\u{ccd}ಯಾಸ\u{cc6}ಟ\u{ccd}"),
            keywords: &[
                "ವೀಡ\u{cbf}ಯೊ",
                "ವೀಡ\u{cbf}ಯೊ ಟೇಪ\u{ccd}",
                "ವೀಡ\u{cbf}ಯೊಕ\u{ccd}ಯಾಸ\u{cc6}ಟ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("비디오테이프"),
            keywords: &["비디오", "비디오테이프", "테이프"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("व\u{94d}हिडियोक\u{945}स\u{947}ट"),
            keywords: &[
                "ट\u{947}प",
                "व\u{94d}हिडियो",
                "व\u{94d}हिडियोक\u{945}स\u{947}ट",
                "व\u{94d}हीएचएस",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("видеокассета"),
            keywords: &["видео", "видеокассета", "пленка"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Videokassett"),
            keywords: &["Kassett", "VHS", "Video", "Videokassett"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກະແຊ\u{eb1}ດວ\u{eb4}ດ\u{eb5}ໂອ"),
            keywords: &[
                "ກະແຊ\u{eb1}ດ",
                "ກະແຊ\u{eb1}ດວ\u{eb4}ດ\u{eb5}ໂອ",
                "ວ\u{eb4}ດ\u{eb5}ໂອ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vaizdo įrašų kasetė"),
            keywords: &["VHS", "juosta", "vaizdo įrašas", "vaizdo įrašų kasetė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("videokasete"),
            keywords: &["VHS", "kasete", "videokasete"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rīpene-ataata"),
            keywords: &["ataata", "rīpene", "rīpene-ataata", "vhs"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("видеокасета"),
            keywords: &["видео", "видеокасета", "камера", "касета"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വീഡിയോ ക\u{d3e}സറ\u{d4d}റ\u{d4d}"),
            keywords: &["ക\u{d3e}സറ\u{d4d}റ\u{d4d}", "ടേപ\u{d4d}പ\u{d4d}", "വീഡിയോ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("видеоны хуурцаг"),
            keywords: &["видео", "видеоны хуурцаг", "хуурцаг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("व\u{94d}हिडिओक\u{945}स\u{947}ट"),
            keywords: &[
                "ट\u{947}प",
                "व\u{94d}हिएचएस",
                "व\u{94d}हिडिओ",
                "व\u{94d}हिडिओक\u{945}स\u{947}ट",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pita video"),
            keywords: &["pita", "vhs", "video"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("videocassette"),
            keywords: &["tejp", "vhs", "videocassette", "vidjo"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဗ\u{102e}ဒ\u{102e}ယ\u{102d}\u{102f} ကက\u{103a}ဆက\u{103a}"),
            keywords: &[
                "ဗ\u{102e}ဒ\u{102e}ယ\u{102d}\u{102f}",
                "ဗ\u{102e}ဒ\u{102e}ယ\u{102d}\u{102f} ကက\u{103a}ဆက\u{103a}",
                "ဗ\u{102e}ဒ\u{102e}ယ\u{102d}\u{102f} တ\u{102d}ပ\u{103a}ခ\u{103d}ေ",
                "ဗ\u{102e}အ\u{102d}တ\u{103a}ခ\u{103a}ျအက\u{103a}စ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("videokassett"),
            keywords: &["kassett", "opptak", "vhs", "video", "videokassett"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("भिडियो क\u{94d}यास\u{947}ट"),
            keywords: &[
                "ट\u{947}प",
                "भिएचएस",
                "भिडियो",
                "भिडियो क\u{94d}यास\u{947}ट",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("videoband"),
            keywords: &["band", "vhs", "video", "videoband"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("videokassett"),
            keywords: &["kassett", "opptak", "vhs", "video", "videokassett"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଭ\u{b3f}ଡ\u{b3f}ଓ କ\u{b4d}ୟ\u{b3e}ସେଟ\u{b4d}\u{200c}"),
            keywords: &[
                "ଟ\u{b4d}ୟ\u{b3e}ପ\u{b4d}",
                "ଭ\u{b3f}ଡ\u{b3f}ଓ",
                "ଭ\u{b3f}ଡ\u{b3f}ଓ କ\u{b4d}ୟ\u{b3e}ସେଟ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਵੀਡੀਓ ਕ\u{a48}ਸ\u{a47}ਟ"),
            keywords: &["vhs", "ਟ\u{a47}ਪ", "ਵੀਡੀਓ", "ਵੀਡੀਓ ਕ\u{a48}ਸ\u{a47}ਟ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ویڈیو کیسٹ"),
            keywords: &["vhs", "فیتہ", "ویڈیو", "ویڈیو کیسٹ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Vídiókasẹt"),
            keywords: &["Tep", "VHS", "Vídio", "Vídiókasẹt"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kaseta wideo"),
            keywords: &["kaseta wideo", "taśma"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ویډیو کیسټ"),
            keywords: &["وي ايچ ايس", "ويډيو", "ويډيو کيسټ", "ویډیو کیسټ", "ټيپ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("videocassete"),
            keywords: &["fita", "vhs", "videocassete", "vídeo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["cassete", "vhs", "videocassete", "vídeo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("videocaset"),
            keywords: &["videocaset"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("casetă video"),
            keywords: &["VHS", "casetă", "video"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-697"),
            keywords: &["E10-697"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("видеокассета"),
            keywords: &["видео", "видеокассета", "кассета", "пленка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("kasete videwo"),
            keywords: &["kasete videwo", "umugozi", "vhs", "videwo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ويڊيو ڪيسٽ"),
            keywords: &["وي ايڇ ايس", "ويڊيو", "ويڊيو ڪيسٽ", "ٽيپ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ව\u{dd3}ඩ\u{dd2}යෝ කැසටය"),
            keywords: &[
                "ටේප\u{dca}",
                "ව\u{dd3}එච\u{dca}එස\u{dca}",
                "ව\u{dd3}ඩ\u{dd2}යෝ කැසටය",
                "ව\u{dd3}ඩ\u{dd2}යෝව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("videokazeta"),
            keywords: &["kazeta", "vhs", "video", "videokazeta"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("videokaseta"),
            keywords: &["kaseta", "vhs", "video", "videokaseta"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("cajalad fiidiyow"),
            keywords: &["cajalad", "fiidiyow", "vhs"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("videokasetë"),
            keywords: &["shirit", "vhs", "video", "videokasetë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("видео касета"),
            keywords: &["vhs", "видeo", "видео касета", "трака"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("video kaseta"),
            keywords: &["traka", "vhs", "video", "video kaseta"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("videokassett"),
            keywords: &["VHS", "video", "videoband", "videokassett"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kaseti ya video"),
            keywords: &["kanda", "kaseti ya video", "vhs", "video"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வ\u{bc0}டியோ கேசட\u{bcd}"),
            keywords: &["கேசட\u{bcd}", "வ\u{bc0}டியோ கேசட\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వ\u{c40}డ\u{c3f}య\u{c4b} క\u{c4d}య\u{c3e}స\u{c46}ట\u{c4d}"),
            keywords: &[
                "వ\u{c40}డ\u{c3f}య\u{c4b} క\u{c4d}య\u{c3e}స\u{c46}ట\u{c4d}",
                "వ\u{c40}డ\u{c3f}య\u{c4b} ట\u{c47}ప\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("кассетаи видео"),
            keywords: &["видео", "видеосистемаи хонагӣ", "кассетаи видео", "навор"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ว\u{e34}ด\u{e35}โอเทป"),
            keywords: &["ว\u{e34}ด\u{e35}โอเทป", "ว\u{e34}ทย\u{e38}", "เทป", "เพลง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("wideokasseta"),
            keywords: &["magnitofon", "wideo", "wideo kasseta", "wideokasseta"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kasete vitiō"),
            keywords: &["kasete vitiō"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("videokaset"),
            keywords: &["teyp", "video", "video kaseti", "videokaset"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سىنئالغۇ لېنتىسى"),
            keywords: &["سىن", "سىنئالغۇ", "سىنئالغۇ لېنتىسى", "لېنتا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("відеокасета"),
            keywords: &["відео", "відеокасета", "касета", "стрічка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ویڈیو کیسٹ"),
            keywords: &["ویڈیو", "ویڈیو کیسٹ", "ٹیپ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("videokasseta"),
            keywords: &["vhs", "videokasseta", "videol videokasseta"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("băng video"),
            keywords: &["băng", "vhs", "video"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kasetu wideo"),
            keywords: &["bànk", "kasetu wideo", "vhs", "wideo"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ikhasethi levidiyo"),
            keywords: &["i-vhs", "ikhasethi levidiyo", "itheyiphu", "ividiyo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("awọn kaadi ododo iṣere"),
            keywords: &["awọn kaadi ododo iṣere", "fídíò", "téèpù"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("錄影帶"),
            keywords: &["帶", "影片", "錄影帶", "錄影機"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("录影带"),
            keywords: &["带", "录影带", "录影机", "影片"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("录像带"),
            keywords: &["VHS", "录像带", "录影带", "磁带"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("錄影帶"),
            keywords: &["VHS", "錄影帶"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ividiyo khasethi"),
            keywords: &["ikhasethi", "ividiyo", "ividiyo khasethi", "vhs"],
        },
    ],
};
#[doc = "🔍"]
pub const MAGNIFYING_GLASS_TILTED_LEFT: crate::Emoji = crate::Emoji {
    glyph: "🔍",
    codepoint: "1F50D",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "magnifying glass tilted left",
    group: "Objects",
    subgroup: "light & video",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vergrootglas na links"),
            keywords: &["glas", "soek", "vergroot", "vergrootglas na links"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ግራ ጠቋሚ ማጉያ መነጽር"),
            keywords: &["መሣሪያ", "መነጽር", "ማጉያ", "ግራ ጠቋሚ ማጉያ መነጽር", "ፍለጋ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}عدسة مكبرة اتجاه اليسار"),
            keywords: &[
                "بحث",
                "عدسة",
                "عدسة مكبرة لليسار",
                "\u{202b}عدسة مكبرة اتجاه اليسار",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ব\u{9be}ও\u{981}ফ\u{9be}লে হল\u{9be} আতচী ক\u{9be}চ"),
            keywords: &[
                "গ\u{9cd}ল\u{9be}ছ",
                "ব\u{9be}ও\u{981}ফ\u{9be}লে হল\u{9be} আতচী ক\u{9be}চ",
                "বিবৰ\u{9cd}ধন",
                "স\u{981}জ\u{9c1}লি",
                "সন\u{9cd}ধ\u{9be}ন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sola yönəlmiş böyüdücü şüşə"),
            keywords: &[
                "alət",
                "axtarmaq",
                "böyüdücü",
                "sola yönəlmiş böyüdücü şüşə",
                "şüşə",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("лупа павернута ўлева"),
            keywords: &[
                "лупа павернута ўлева",
                "павелічэнне",
                "пошук",
                "шкло",
                "інструмент",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Наклонена наляво лупа"),
            keywords: &["Наклонена наляво лупа", "инструмент", "лупа", "търсене"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9be}\u{981}দিকে হেল\u{9be}নো আতস ক\u{9be}\u{981}চ"),
            keywords: &[
                "অন\u{9c1}সন\u{9cd}ধ\u{9be}ন",
                "আতস",
                "ক\u{9be}চ",
                "ব\u{9be}\u{981}দিকে হেল\u{9be}নো আতস ক\u{9be}\u{981}চ",
                "সরঞ\u{9cd}জ\u{9be}ম",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("gwerenn-greskiñ a-gleiz"),
            keywords: &["gwerenn", "gwerenn-greskiñ a-gleiz"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("povećalo okrenuto ulijevo"),
            keywords: &[
                "alat",
                "povećalo",
                "povećalo okrenuto ulijevo",
                "staklo",
                "traženje",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("lupa cap a l’esquerra"),
            keywords: &[
                "buscar",
                "eina",
                "esquerra",
                "lupa",
                "lupa cap a l’esquerra",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎦᏍᎦᏂ ᎠᎦᏙᏗ ᎠᏔᏃᎯᏍᏗᏍᎩ ᎤᎸᏌᏗ"),
            keywords: &[
                "ᎠᎦᏍᎦᏂ ᎠᎦᏙᏗ ᎠᏔᏃᎯᏍᏗᏍᎩ ᎤᎸᏌᏗ",
                "ᎠᏔᏃᎯᏍᏗᏍᎩ",
                "ᎠᏱᏍᏗᎢ",
                "ᎤᎸᏌᏗ",
                "ᎬᏔᏂᏓᏍᏗ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("lupa nakloněná doleva"),
            keywords: &[
                "hledání",
                "lupa nakloněná doleva",
                "nástroj",
                "nářadí",
                "sklo",
                "zvětšení",
                "zvětšovací",
                "zvětšování",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("chwyddwydr yn wynebu’r chwith"),
            keywords: &[
                "chwilio",
                "chwyddwydr",
                "chwyddwydr yn wynebu’r chwith",
                "gwydr",
                "offeryn",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("forstørrelsesglas til venstre"),
            keywords: &[
                "forstørrelse",
                "forstørrelsesglas",
                "forstørrelsesglas til venstre",
                "søgning",
                "værktøj",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Lupe nach links"),
            keywords: &["Lupe nach links", "Suche", "Vergrößerungsglas"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: None,
            keywords: &["Lupe nach links"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αριστερός μεγεθυντικός φακός"),
            keywords: &[
                "αναζήτηση",
                "αριστερός μεγεθυντικός φακός",
                "εργαλείο",
                "μεγεθυντικός",
                "φακός",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("magnifying glass tilted left"),
            keywords: &[
                "glass",
                "magnifying",
                "magnifying glass tilted left",
                "search",
                "tool",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("lupa orientada hacia la izquierda"),
            keywords: &["buscar", "lupa", "lupa orientada hacia la izquierda"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("lupa hacia la izquierda"),
            keywords: &[
                "aumento",
                "buscar",
                "instrumento",
                "lupa",
                "lupa hacia la izquierda",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("vasakule kallutatud luup"),
            keywords: &[
                "otsi",
                "suurendusklaas",
                "tööriist",
                "vasakule kallutatud luup",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ezkerrera begira dagoen lupa"),
            keywords: &[
                "beira",
                "bilatu",
                "ezkerrera begira dagoen lupa",
                "lupa",
                "tresna",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ذره\u{200c}بین روبه\u{200c}چپ"),
            keywords: &[
                "ابزار",
                "جستجو",
                "ذره\u{200c}بین",
                "ذره\u{200c}بین روبه\u{200c}چپ",
                "شیشه",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("suurennuslasi vasemmalle"),
            keywords: &[
                "etsi",
                "haku",
                "lasi",
                "suurennuslasi",
                "suurennuslasi vasemmalle",
                "työkalu",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("magnifying glass na nakahilig sa kaliwa"),
            keywords: &[
                "glass",
                "kagamitan",
                "kaliwa",
                "magnifying",
                "magnifying glass na nakahilig sa kaliwa",
                "nakahilig",
                "paghahanap",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("luppur á skák til vinstru"),
            keywords: &[
                "lesiglas",
                "luppur",
                "luppur á skák til vinstru",
                "sjóneyka",
                "størkingarglas",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("loupe orientée à gauche"),
            keywords: &["loupe", "loupe orientée à gauche", "recherche"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "agrandir",
                "loupe",
                "loupe orientée à gauche",
                "outil",
                "rechercher",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("gloine formhéadúcháin ar chlé"),
            keywords: &["gloine formhéadúcháin ar chlé"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("glainne-mheudachaidh dhan taobh chlì"),
            keywords: &[
                "acainn",
                "glainne",
                "glainne-mheudachaidh ag aomadh dhan taobh chlì",
                "glainne-mheudachaidh dhan taobh chlì",
                "inneal",
                "lorg",
                "meudachadh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("lupa cara a esquerda"),
            keywords: &["buscar", "esquerda", "lupa", "lupa cara a esquerda"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ડાબી તરફનો બ\u{ac3}હદદર\u{acd}શક કાચ"),
            keywords: &[
                "કાચ",
                "ડાબી તરફનો",
                "ડાબી તરફનો બ\u{ac3}હદદર\u{acd}શક કાચ",
                "બ\u{ac3}હદદર\u{acd}શક કાચ",
                "શોધો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("gilashi mai ƙara girma mai nunawa hagu"),
            keywords: &[
                "gilashi",
                "gilashi mai ƙara girma mai nunawa hagu",
                "kayan aiki",
                "mai ƙara girma",
                "nema",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("זכוכית מגדלת נוטה שמאלה"),
            keywords: &["זכוכית", "זכוכית מגדלת נוטה שמאלה", "חיפוש", "מגדלת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बाई\u{902} ओर झ\u{941}का आवर\u{94d}धक का\u{901}च"),
            keywords: &[
                "आवर\u{94d}धक का\u{901}च",
                "औज\u{93c}ार",
                "का\u{901}च",
                "खोज",
                "बाई\u{902} ओर झ\u{941}का आवर\u{94d}धक का\u{901}च",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("povećalo nagnuto ulijevo"),
            keywords: &[
                "alat",
                "povećalo",
                "povećalo nagnuto ulijevo",
                "staklo",
                "traženje",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("balra mutató nagyító"),
            keywords: &["balra mutató nagyító", "keresés", "lencse", "nagyító"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ձախ ուղղված խոշորացույց"),
            keywords: &[
                "ապակի",
                "գործիք",
                "խոշորացնող",
                "ձախ ուղղված խոշորացույց",
                "որոնել",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kaca pembesar arah kiri"),
            keywords: &[
                "alat",
                "kaca",
                "kaca pembesar arah kiri",
                "pembesar",
                "penelusuran",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ènyò mbawanye na-atụga akaekpe"),
            keywords: &[
                "chọọ",
                "mbawanye",
                "ngwaọrụ",
                "ènyò",
                "ènyò mbawanye na-atụga akaekpe",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("stækkunargler sem vísar til vinstri"),
            keywords: &[
                "leita",
                "stækkunargler",
                "stækkunargler sem vísar til vinstri",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("lente di ingrandimento rivolta a sinistra"),
            keywords: &[
                "cerca",
                "lente",
                "lente di ingrandimento rivolta a sinistra",
                "lente ingrandimento",
                "lente ingrandimento verso sinistra",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("虫眼鏡左"),
            keywords: &["ルーペ", "検索", "虫めがね", "虫眼鏡左"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("suryakantha minger ngiwa"),
            keywords: &[
                "kaca",
                "nggedhekkake",
                "nggoleki",
                "pranti",
                "suryakantha minger ngiwa",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მარცხნივ მიმართული გამადიდებელი შუშა"),
            keywords: &[
                "გამადიდებელი",
                "ინსტრუმენტი",
                "მარცხნივ მიმართული გამადიდებელი შუშა",
                "შუშა",
                "ძებნა",
                "ძიება",
                "ხელსაწყო",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сол жақты көрсететін үлкейткіш әйнек"),
            keywords: &[
                "сол жақты көрсететін үлкейткіш әйнек",
                "шыны",
                "іздеу",
                "құрал",
                "үлкейту",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("forstørrelsesglas til venstre"),
            keywords: &[
                "forstørrelse",
                "forstørrelsesglas",
                "forstørrelsesglas til venstre",
                "søgning",
                "værktøj",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កែវពង\u{17d2}រ\u{17b8}កទ\u{17d2}រេតទៅឆ\u{17d2}វេង"),
            keywords: &[
                "កែវពង\u{17d2}រ\u{17b8}ក",
                "កែវពង\u{17d2}រ\u{17b8}កទ\u{17d2}រេតទៅឆ\u{17d2}វេង",
                "ពង\u{17d2}រ\u{17b8}ក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಎಡಗಡ\u{cc6} ಸ\u{cc2}ಚ\u{cbf}ಸುವ ಭ\u{cc2}ತಗನ\u{ccd}ನಡ\u{cbf}"),
            keywords: &[
                "ಎಡ ಸ\u{cc2}ಚ\u{cbf}ಸುವ",
                "ಎಡಗಡ\u{cc6} ಸ\u{cc2}ಚ\u{cbf}ಸುವ ಭ\u{cc2}ತಗನ\u{ccd}ನಡ\u{cbf}",
                "ಗಾಜ\u{cbf}ನ",
                "ಹುಡುಕಾಟ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("왼쪽으로 향한 돋보기"),
            keywords: &["검색", "검색하기", "왼쪽으로 향한 돋보기"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दाव\u{94d}यान पळोवपी म\u{945}ग\u{94d}नीफाई\u{902}ग ग\u{94d}लास"),
            keywords: &[
                "ग\u{94d}लास",
                "दाव\u{94d}यान पळोवपी म\u{945}ग\u{94d}नीफाई\u{902}ग ग\u{94d}लास",
                "म\u{945}ग\u{94d}नीफाई\u{902}ग",
                "साधन",
                "सोद",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("сол жакты караган лупа"),
            keywords: &["издөө", "курал", "лупа", "сол жакты караган лупа"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("no lénks geriicht Lupp"),
            keywords: &[
                "Glas",
                "Lupp",
                "Utensil",
                "no lénks geriicht Lupp",
                "sichen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແວ\u{ec8}ນຂະຫຍາຍຊ\u{eb5}\u{ec9}ໄປຊ\u{ec9}າຍ"),
            keywords: &[
                "ເຄ\u{eb7}\u{ec8}ອງມ\u{eb7}",
                "ແວ\u{ec8}ນຂະຫຍາຍ",
                "ແວ\u{ec8}ນຂະຫຍາຍຊ\u{eb5}\u{ec9}ໄປຊ\u{ec9}າຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("didinimo stiklas į kairę"),
            keywords: &[
                "didinimo",
                "didinimo stiklas į kairę",
                "paieška",
                "stiklas",
                "įrankis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pa kreisi vērsta lupa"),
            keywords: &["lupa", "pa kreisi vērsta lupa", "palielināt"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kārāhe whārahi anga mauī"),
            keywords: &[
                "karāhe",
                "kārāhe whārahi anga mauī",
                "rapu",
                "utauta",
                "whārahi",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лупа свртена налево"),
            keywords: &[
                "зголемување",
                "лево",
                "лупа",
                "лупа свртена налево",
                "пребарување",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ഇടത\u{d4d}തേക\u{d4d}ക\u{d4d} പോയിന\u{d4d}റ\u{d4d} ചെയ\u{d4d}യ\u{d41}ന\u{d4d}ന ഭ\u{d42}തക\u{d4d}കണ\u{d4d}ണ\u{d3e}ടി",
            ),
            keywords: &[
                "ഇടത\u{d4d}തേക\u{d4d}ക\u{d4d} പോയിന\u{d4d}റ\u{d4d} ചെയ\u{d4d}യ\u{d41}ന\u{d4d}ന ഭ\u{d42}തക\u{d4d}കണ\u{d4d}ണ\u{d3e}ടി",
                "ഉപകരണം",
                "കണ\u{d4d}ണ\u{d3e}ടി",
                "ഭ\u{d42}തക\u{d4d}കണ\u{d4d}ണ\u{d3e}ടി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зүүн тийш хазайлгасан томруулагч шил"),
            keywords: &[
                "зүүн",
                "зүүн тийш хазайлгасан томруулагч шил",
                "томруулагч",
                "шил",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("डाव\u{947} दर\u{94d}शविणार\u{947} विशालक भि\u{902}ग"),
            keywords: &[
                "काच",
                "डाव\u{947} दर\u{94d}शविणार\u{947} विशालक भि\u{902}ग",
                "विशालक भि\u{902}ग",
                "शोध",
                "साधन",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kanta pembesar condong ke kiri"),
            keywords: &[
                "alat",
                "carian",
                "kanta",
                "kanta pembesar condong ke kiri",
                "pembesar",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("lenti tat-tkabbir tipponta xellug"),
            keywords: &[
                "fittex",
                "għodda",
                "lenti tat-tkabbir tipponta xellug",
                "tkabbir ottiku",
                "ħġieġ",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ဘယ\u{103a}သ\u{102d}\u{102f}\u{1037}စောင\u{103a}းထားသည\u{1037}\u{103a} မ\u{103e}န\u{103a}ဘ\u{102e}လ\u{1030}း",
            ),
            keywords: &[
                "ဘယ\u{103a}သ\u{102d}\u{102f}\u{1037}စောင\u{103a}းထားသည\u{1037}\u{103a} မ\u{103e}န\u{103a}ဘ\u{102e}လ\u{1030}း",
                "မ\u{103e}န\u{103a}ဘ\u{102e}လ\u{1030}း",
                "အကြ\u{102e}းချ\u{1032}\u{1037}ခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("forstørrelsesglass mot venstre"),
            keywords: &[
                "forstørrelse",
                "forstørrelsesglass mot venstre",
                "glass",
                "lupe",
                "søk",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some(
                "बाया\u{901}तर\u{94d}फ ढल\u{94d}क\u{947}को म\u{94d}याग\u{94d}निफाइङ ग\u{94d}लास",
            ),
            keywords: &[
                "उपकरण",
                "खोज",
                "ग\u{94d}लास",
                "बाया\u{901}तर\u{94d}फ ढल\u{94d}क\u{947}को म\u{94d}याग\u{94d}निफाइङ ग\u{94d}लास",
                "म\u{94d}याग\u{94d}निफाइङ",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vergrootglas naar links gericht"),
            keywords: &[
                "gereedschap",
                "glas",
                "vergrootglas naar links gericht",
                "vergroten",
                "zoeken",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("forstørringsglas mot venstre"),
            keywords: &[
                "forstørring",
                "forstørringsglas mot venstre",
                "glas",
                "lupe",
                "søk",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3e}ମକ\u{b41} ଢଳ\u{b3f}ଥ\u{b3f}ବ\u{b3e} ଯବକ\u{b3e}ଚ"),
            keywords: &[
                "କ\u{b3e}ଚ",
                "ଜବକ\u{b3e}ଚ",
                "ବ\u{b3e}ମକ\u{b41} ଢଳ\u{b3f}ଥ\u{b3f}ବ\u{b3e} ଯବକ\u{b3e}ଚ",
                "ବ\u{b3e}ମକ\u{b41} ଦ\u{b43}ଷ\u{b4d}ଟ\u{b3f} ନ\u{b3f}କ\u{b4d}ଷେପ କର\u{b41}ଥ\u{b3f}ବ\u{b3e}",
                "ବ\u{b3e}ମକ\u{b41} ଦ\u{b43}ଷ\u{b4d}ଟ\u{b3f} ନ\u{b3f}କ\u{b4d}ଷେପ କର\u{b41}ଥ\u{b3f}ବ\u{b3e} ଜବକ\u{b3e}ଚ",
                "ସନ\u{b4d}ଧ\u{b3e}ନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਖ\u{a71}ਬ\u{a47} ਪਾਸ\u{a47} ਝ\u{a41}ਕਿਆ ਵਡਦਰਸ\u{a3c}ੀ ਸ\u{a3c}ੀਸ\u{a3c}ਾ"),
            keywords: &[
                "ਖ\u{a4b}ਜ",
                "ਖ\u{a71}ਬਾ ਪਾਇ\u{a70}ਟ",
                "ਖ\u{a71}ਬ\u{a47} ਪਾਇ\u{a70}ਟ ਤ\u{a4b}\u{a02} ਮ\u{a48}ਗਨੀਫਾਇ\u{a70}ਗ ਗਲਾਸ",
                "ਖ\u{a71}ਬ\u{a47} ਪਾਸ\u{a47} ਝ\u{a41}ਕਿਆ ਵਡਦਰਸ\u{a3c}ੀ ਸ\u{a3c}ੀਸ\u{a3c}ਾ",
                "ਗਲਾਸ",
                "ਮ\u{a48}ਗਨੀਫਾਇ\u{a70}ਗ ਗਲਾਸ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کھبے ـ اشارہ کردا وڈا کرن آلا شیشہ"),
            keywords: &[
                "اوزار",
                "وڈا کرنا",
                "کھبے ـ اشارہ کردا وڈا کرن آلا شیشہ",
                "کھوج لانا",
                "گلاس",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Magnifáyín Glas Wé Bẹ\u{301}nd Lẹft"),
            keywords: &[
                "Glas",
                "Magnifáyin",
                "Magnifáyín Glas Wé Bẹ\u{301}nd Lẹft",
                "Sach",
                "Tul",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("lupa pochylona w lewo"),
            keywords: &[
                "lupa",
                "lupa pochylona w lewo",
                "skierowana w lewo",
                "szukaj",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لويوونکې ښيښه چپ اړخ ته کږه"),
            keywords: &[
                "اله",
                "لويوونکې",
                "لويوونکې ښيښه چپ اړخ ته کږه",
                "لټون",
                "ښيښه",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("lupa para a esquerda"),
            keywords: &[
                "ferramenta",
                "lente de aumento",
                "lupa",
                "lupa para a esquerda",
                "pesquisa",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("lupa inclinada para a esquerda"),
            keywords: &[
                "ferramenta",
                "lupa",
                "lupa inclinada para a esquerda",
                "pesquisar",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("lupă înclinată spre stânga"),
            keywords: &[
                "căutare",
                "instrument",
                "lupă",
                "lupă înclinată spre stânga",
                "mărire",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-713"),
            keywords: &["E10-713"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("лупа, наклоненная влево"),
            keywords: &[
                "влево",
                "лупа",
                "лупа, наклоненная влево",
                "стекло",
                "увеличительное стекло",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("rupe ireba ibumoso"),
            keywords: &[
                "gutubura",
                "igikoresho",
                "ikirahuri",
                "ishakisha",
                "rupe ireba ibumoso",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ميگنيفائينگ کاٻي پاسي مڙيل شيشو"),
            keywords: &[
                "اوزار",
                "شيشو",
                "ميگنيفائينگ",
                "ميگنيفائينگ کاٻي پاسي مڙيل شيشو",
                "ڳولڻ",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වමට යොම\u{dd4} ව\u{dd6} ව\u{dd2}ශ\u{dcf}ලන ක\u{dcf}චය"),
            keywords: &[
                "මෙවලම",
                "වමට යොම\u{dd4} ව\u{dd6} ව\u{dd2}ශ\u{dcf}ලන ක\u{dcf}චය",
                "ව\u{dd2}ශ\u{dcf}ලනය",
                "ව\u{dd3}ද\u{dd4}ර\u{dd4}ව",
                "සෙව\u{dd3}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("doľava naklonená lupa"),
            keywords: &[
                "doľava naklonená lupa",
                "hľadanie",
                "lupa",
                "nástroj",
                "priblíženie",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("povečevalno steklo, usmerjeno v levo"),
            keywords: &[
                "iskanje",
                "orodje",
                "povečevalno",
                "povečevalno steklo, usmerjeno v levo",
                "steklo",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("quruurad weynayso ah oo u jeeda bidix"),
            keywords: &[
                "qalab",
                "quruurad",
                "quruurad weynayso ah oo u jeeda bidix",
                "raadin",
                "weynayso",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("lupë zmadhuese që tregon majtas"),
            keywords: &[
                "kërko",
                "lupë",
                "lupë zmadhuese që tregon majtas",
                "xham zmadhues",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лупа усмерена налево"),
            keywords: &["aлaт", "лупа", "лупа усмерена налево", "стaклo", "трaжeњe"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("лупа усмјерена налијево"),
            keywords: &["лупа усмјерена налијево"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lupa usmerena nalevo"),
            keywords: &["alat", "lupa", "lupa usmerena nalevo", "staklo", "traženje"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("lupa usmjerena nalijevo"),
            keywords: &["lupa usmjerena nalijevo"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("förstoringsglas som lutar åt vänster"),
            keywords: &[
                "förstoringsglas",
                "förstoringsglas som lutar åt vänster",
                "förstoringsglas vänster",
                "vänsterpekande",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kioo cha ukuzaji kinachoelekeza kushoto"),
            keywords: &[
                "glasi",
                "kioo cha ukuzaji kinachoelekeza kushoto",
                "kukuza",
                "tafuta",
                "zana",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("இடது ச\u{bbe}ய\u{bcd}வு லென\u{bcd}ஸ\u{bcd}"),
            keywords: &[
                "இடது ச\u{bbe}ய\u{bcd}வு லென\u{bcd}ஸ\u{bcd}",
                "தேடல\u{bcd}",
                "தேடு",
                "லென\u{bcd}ஸ\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఎడమక\u{c3f} వంగ\u{c3f} ఉన\u{c4d}న భూతద\u{c4d}దం"),
            keywords: &[
                "ఎడమక\u{c3f} వంగ\u{c3f} ఉన\u{c4d}న భూతద\u{c4d}దం",
                "ఎడమవ\u{c48}పు సూచ\u{c3f}ంచ\u{c47} భూతద\u{c4d}దం",
                "శ\u{c4b}ధన చ\u{c3f}హ\u{c4d}నం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("пурбини ба тарафи чап ишоракунанда"),
            keywords: &[
                "асбоб",
                "бузургкунӣ",
                "пурбини ба тарафи чап ишоракунанда",
                "шиша",
                "ҷустуҷӯ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แว\u{e48}นขยายเอ\u{e35}ยงซ\u{e49}าย"),
            keywords: &[
                "ขยาย",
                "ค\u{e49}นหา",
                "เคร\u{e37}\u{e48}องม\u{e37}อ",
                "แว\u{e48}น",
                "แว\u{e48}นขยายเอ\u{e35}ยงซ\u{e49}าย",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çepe egilen lupa"),
            keywords: &["aýna", "gural", "gözleg", "lupa", "çepe egilen lupa"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sioʻata ʻesiafi falala ki hema"),
            keywords: &["sioʻata ʻesiafi falala ki hema"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sola dönük büyüteç"),
            keywords: &[
                "arama",
                "cam",
                "sola dönük büyüteç",
                "solu gösteren",
                "solu gösteren büyüteç",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سولغا قارىغان چوڭايتقۇچ"),
            keywords: &[
                "ئىزدەش",
                "ئەينەك",
                "سولغا قارىغان چوڭايتقۇچ",
                "قورال",
                "چوڭايتقۇچ",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("збільшувальне скло з нахилом уліво"),
            keywords: &[
                "збільшувальне скло з нахилом уліво",
                "збільшувальне скло, спрямоване ліворуч",
                "лупа",
                "пошук",
                "інструмент",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بائیں اشارہ کرتا محدب عدسہ"),
            keywords: &[
                "آلہ",
                "اشارہ",
                "بائیں",
                "بائیں اشارہ کرتا محدب عدسہ",
                "سمت",
                "عدسہ",
                "محدب",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("chapga qiyshaygan lupa"),
            keywords: &[
                "asbob",
                "chapga qaragan lupa",
                "chapga qiyshaygan lupa",
                "kattalashtirish",
                "qidirish",
                "shisha",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("kính phóng đại nghiêng sang trái"),
            keywords: &[
                "dụng cụ",
                "kính",
                "kính phóng đại nghiêng sang trái",
                "phóng đại",
                "tìm kiếm",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("lup bu féete càmmoñ"),
            keywords: &["jumtukaay", "lup bu féete càmmoñ", "rëyal", "seet", "weer"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iglasi yokwandisa ekhombe ekhohlo"),
            keywords: &[
                "iglasi",
                "iglasi yokwandisa ekhombe ekhohlo",
                "isixhobo",
                "khangela",
                "yokwandisa",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("gilasi itọka-osi amohun tobi"),
            keywords: &[
                "díígí",
                "gilasi itọka-osi amohun tobi",
                "irinṣẹ\u{301}",
                "ìfojúsóde",
                "ìsọdinlá",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("放大鏡向左傾斜"),
            keywords: &["工具", "搜尋", "放大", "放大鏡向左傾斜", "鏡片"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("放大镜向左倾斜"),
            keywords: &["工具", "搜寻", "放大", "放大镜向左倾斜", "镜片"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("左斜的放大镜"),
            keywords: &["工具", "左斜的放大镜", "搜索", "放大", "放大镜", "查找"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("向左的放大鏡"),
            keywords: &["向左的放大鏡", "放大鏡"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("向左嘅放大鏡"),
            keywords: &["向左嘅放大鏡", "向左嘅放大鏡｜放大｜搜尋"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhodlela elikhulisayo elibheke kwesokunxele"),
            keywords: &[
                "ibhodlela",
                "ibhodlela elikhulisayo elibheke kwesokunxele",
                "ithuluzi",
                "ukukhulisa",
                "ukusesha",
            ],
        },
    ],
};
#[doc = "🔎"]
pub const MAGNIFYING_GLASS_TILTED_RIGHT: crate::Emoji = crate::Emoji {
    glyph: "🔎",
    codepoint: "1F50E",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "magnifying glass tilted right",
    group: "Objects",
    subgroup: "light & video",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vergrootglas na regs"),
            keywords: &["glas", "soek", "vergroot", "vergrootglas na regs"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቀኝ ጠቋሚ ማጉያ መነጽር"),
            keywords: &["መሣሪያ", "መነጽር", "ማጉያ", "ቀኝ ጠቋሚ ማጉያ መነጽር", "ፍለጋ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}عدسة مكبرة اتجاه اليمين"),
            keywords: &[
                "بحث",
                "عدسة",
                "عدسة مكبرة لليمين",
                "\u{202b}عدسة مكبرة اتجاه اليمين",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("সো\u{981}ফ\u{9be}লে হল\u{9be} আতচী ক\u{9be}চ"),
            keywords: &[
                "গ\u{9cd}ল\u{9be}ছ",
                "বিবৰ\u{9cd}ধন",
                "স\u{981}জ\u{9c1}লি",
                "সন\u{9cd}ধ\u{9be}ন",
                "সো\u{981}ফ\u{9be}লে হল\u{9be} আতচী ক\u{9be}চ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sağa yönəlmiş böyüdücü şüşə"),
            keywords: &[
                "alət",
                "axtarmaq",
                "böyüdücü",
                "sağa yönəlmiş böyüdücü şüşə",
                "şüşə",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("лупа павернута ўправа"),
            keywords: &[
                "лупа павернута ўправа",
                "павелічэнне",
                "пошук",
                "шкло",
                "інструмент",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Наклонена надясно лупа"),
            keywords: &["Наклонена надясно лупа", "инструмент", "лупа", "търсене"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ড\u{9be}নদিকে হেল\u{9be}নো আতস ক\u{9be}\u{981}চ"),
            keywords: &[
                "অন\u{9c1}সন\u{9cd}ধ\u{9be}ন",
                "আতস",
                "ক\u{9be}চ",
                "ড\u{9be}নদিকে হেল\u{9be}নো আতস ক\u{9be}\u{981}চ",
                "সরঞ\u{9cd}জ\u{9be}ম",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("gwerenn-greskiñ a-zehoù"),
            keywords: &["gwerenn", "gwerenn-greskiñ a-zehoù"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("povećalo okrenuto udesno"),
            keywords: &[
                "alat",
                "povećalo",
                "povećalo okrenuto udesno",
                "staklo",
                "traženje",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("lupa cap a la dreta"),
            keywords: &["buscar", "dreta", "eina", "lupa", "lupa cap a la dreta"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎦᏘᏏ ᏩᏎᎯᎲ ᎡᏆ ᏂᎬᏁ ᎫᎦ"),
            keywords: &["ᎠᎦᏘᏏ ᏩᏎᎯᎲ ᎡᏆ ᏂᎬᏁ ᎫᎦ", "ᎠᏔᏃᎯᏍᏗᏍᎩ", "ᎠᏱᏍᏗᎢ", "ᎤᎸᏌᏗ", "ᎬᏔᏂᏓᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("lupa nakloněná doprava"),
            keywords: &[
                "hledání",
                "lupa nakloněná doprava",
                "nástroj",
                "nářadí",
                "sklo",
                "zvětšení",
                "zvětšovací",
                "zvětšování",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("chwyddwydr yn wynebu’r dde"),
            keywords: &[
                "chwilio",
                "chwyddo",
                "chwyddwydr yn wynebu’r dde",
                "gwydr",
                "offeryn",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("forstørrelsesglas til højre"),
            keywords: &[
                "forstørrelse",
                "forstørrelsesglas",
                "forstørrelsesglas til højre",
                "søgning",
                "værktøj",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Lupe nach rechts"),
            keywords: &["Lupe nach rechts", "Suche", "Vergrößerungsglas"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: None,
            keywords: &["Lupe nach rechts"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("δεξιός μεγεθυντικός φακός"),
            keywords: &[
                "αναζήτηση",
                "δεξιός μεγεθυντικός φακός",
                "εργαλείο",
                "μεγεθυντικός",
                "φακός",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("magnifying glass tilted right"),
            keywords: &[
                "glass",
                "magnifying",
                "magnifying glass tilted right",
                "search",
                "tool",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("lupa orientada hacia la derecha"),
            keywords: &["buscar", "lupa", "lupa orientada hacia la derecha"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("lupa hacia la derecha"),
            keywords: &[
                "aumento",
                "buscar",
                "instrumento",
                "lupa",
                "lupa hacia la derecha",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("paremale kallutatud luup"),
            keywords: &[
                "otsi",
                "paremale kallutatud luup",
                "suurendusklaas",
                "tööriist",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("eskuinera begira dagoen lupa"),
            keywords: &[
                "beira",
                "bilatu",
                "eskuinera begira dagoen lupa",
                "lupa",
                "tresna",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ذره\u{200c}بین روبه\u{200c}راست"),
            keywords: &[
                "ابزار",
                "جستجو",
                "ذره\u{200c}بین",
                "ذره\u{200c}بین روبه\u{200c}راست",
                "شیشه",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("suurennuslasi oikealle"),
            keywords: &[
                "etsi",
                "haku",
                "lasi",
                "suurennuslasi",
                "suurennuslasi oikealle",
                "työkalu",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("magnifying glass na nakahilig sa kanan"),
            keywords: &[
                "glass",
                "kagamitan",
                "kanan",
                "magnifying",
                "magnifying glass na nakahilig sa kanan",
                "nakahilig",
                "paghahanap",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("luppur á skák til høgru"),
            keywords: &[
                "lesiglas",
                "luppur",
                "luppur á skák til høgru",
                "sjóneyka",
                "størkingarglas",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("loupe orientée à droite"),
            keywords: &["loupe", "loupe orientée à droite", "recherche"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "agrandir",
                "loupe",
                "loupe orientée à droite",
                "outil",
                "rechercher",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("gloine formhéadúcháin ar dheis"),
            keywords: &["gloine formhéadúcháin ar dheis"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("glainne-mheudachaidh dhan taobh dheas"),
            keywords: &[
                "acainn",
                "glainne",
                "glainne-mheudachaidh ag aomadh dhan taobh dheas",
                "glainne-mheudachaidh dhan taobh dheas",
                "inneal",
                "lorg",
                "meudachadh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("lupa cara a dereita"),
            keywords: &["buscar", "dereita", "lupa", "lupa cara a dereita"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("જમણી તરફનો બ\u{ac3}હદદર\u{acd}શક કાચ"),
            keywords: &[
                "કાચ",
                "જમણી તરફનો",
                "જમણી તરફનો બ\u{ac3}હદદર\u{acd}શક કાચ",
                "બ\u{ac3}હદદર\u{acd}શક કાચ",
                "શોધો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("gilashi mai ƙara girma mai nunawa dama"),
            keywords: &[
                "gilashi",
                "gilashi mai ƙara girma mai nunawa dama",
                "kayan aiki",
                "mai ƙara girma",
                "nema",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("זכוכית מגדלת נוטה ימינה"),
            keywords: &["זכוכית", "זכוכית מגדלת נוטה ימינה", "חיפוש", "מגדלת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("दाई\u{902} ओर झ\u{941}का आवर\u{94d}धक का\u{901}च"),
            keywords: &[
                "आवर\u{94d}धक का\u{902}च",
                "औज\u{93c}ार",
                "का\u{901}च",
                "खोज",
                "दाई\u{902} ओर झ\u{941}का आवर\u{94d}धक का\u{901}च",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("povećalo nagnuto udesno"),
            keywords: &[
                "alat",
                "povećalo",
                "povećalo nagnuto udesno",
                "staklo",
                "traženje",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("jobbra mutató nagyító"),
            keywords: &["jobbra mutató nagyító", "keresés", "lencse", "nagyító"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("աջ ուղղված խոշորացույց"),
            keywords: &[
                "ապակի",
                "աջ ուղղված խոշորացույց",
                "գործիք",
                "խոշորացնող",
                "որոնել",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kaca pembesar arah kanan"),
            keywords: &[
                "alat",
                "kaca",
                "kaca pembesar arah kanan",
                "pembesar",
                "penelusuran",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ènyò mbawanye na-atụga akanri"),
            keywords: &[
                "chọọ",
                "mbawanye",
                "ngwaọrụ",
                "ènyò",
                "ènyò mbawanye na-atụga akanri",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("stækkunargler sem vísar til hægri"),
            keywords: &[
                "leita",
                "stækkunargler",
                "stækkunargler sem vísar til hægri",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("lente di ingrandimento rivolta a destra"),
            keywords: &[
                "cerca",
                "lente",
                "lente di ingrandimento rivolta a destra",
                "lente ingrandimento",
                "lente ingrandimento verso destra",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("虫眼鏡右"),
            keywords: &["ルーペ", "検索", "虫めがね", "虫眼鏡右"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("suryakantha minger nengen"),
            keywords: &[
                "kaca",
                "nggedhekkake",
                "nggoleki",
                "pranti",
                "suryakantha minger nengen",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მარჯვნივ მიმართული გამადიდებელი შუშა"),
            keywords: &[
                "გამადიდებელი",
                "ინსტრუმენტი",
                "მარჯვნივ მიმართული გამადიდებელი შუშა",
                "შუშა",
                "ძებნა",
                "ძიება",
                "ხელსაწყო",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("оң жақты көрсететін үлкейткіш әйнек"),
            keywords: &[
                "оң жақты көрсететін үлкейткіш әйнек",
                "шыны",
                "іздеу",
                "құрал",
                "үлкейту",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("forstørrelsesglas til højre"),
            keywords: &[
                "forstørrelse",
                "forstørrelsesglas",
                "forstørrelsesglas til højre",
                "søgning",
                "værktøj",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កែវពង\u{17d2}រ\u{17b8}កទ\u{17d2}រេតទៅស\u{17d2}តា\u{17c6}"),
            keywords: &[
                "កែវពង\u{17d2}រ\u{17b8}ក",
                "កែវពង\u{17d2}រ\u{17b8}កទ\u{17d2}រេតទៅស\u{17d2}តា\u{17c6}",
                "ពង\u{17d2}រ\u{17b8}ក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬಲಕ\u{ccd}ಕ\u{cc6} ಓರ\u{cc6}ಯಾಗ\u{cbf}ರುವ ಭ\u{cc2}ತಗನ\u{ccd}ನಡ\u{cbf}"),
            keywords: &[
                "ಗಾಜ\u{cbf}ನ",
                "ಬಲ ಸ\u{cc2}ಚ\u{cbf}ಸುವ",
                "ಬಲ ಸ\u{cc2}ಚ\u{cbf}ಸುವ ಭ\u{cc2}ತಗನ\u{ccd}ನಡ\u{cbf}",
                "ಬಲಕ\u{ccd}ಕ\u{cc6} ಓರ\u{cc6}ಯಾಗ\u{cbf}ರುವ ಭ\u{cc2}ತಗನ\u{ccd}ನಡ\u{cbf}",
                "ಬಲ\u{cc2} ಸ\u{cc2}ಚ\u{cbf}ಸುವ ಭ\u{cc2}ತಗನ\u{ccd}ನಡ\u{cbf}",
                "ಹುಡುಕಾಟ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("오른쪽으로 향한 돋보기"),
            keywords: &["검색", "검색하기", "오른쪽으로 향한 돋보기"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उजव\u{94d}यान पळोवपी म\u{945}ग\u{94d}नीफाई\u{902}ग ग\u{94d}लास"),
            keywords: &[
                "उजव\u{94d}यान पळोवपी म\u{945}ग\u{94d}नीफाई\u{902}ग ग\u{94d}लास",
                "ग\u{94d}लास",
                "म\u{945}ग\u{94d}नीफाई\u{902}ग",
                "सोद साधन",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("оң жакты караган лупа"),
            keywords: &["издөө", "курал", "лупа", "оң жакты караган лупа"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("no riets geriicht Lupp"),
            keywords: &[
                "Glas",
                "Lupp",
                "Utensil",
                "no riets geriicht Lupp",
                "sichen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແວ\u{ec8}ນຂະຫຍາຍຊ\u{eb5}\u{ec9}ໄປຂວາ"),
            keywords: &[
                "ເຄ\u{eb7}\u{ec8}ອງມ\u{eb7}",
                "ແວ\u{ec8}ນຂະຫຍາຍ",
                "ແວ\u{ec8}ນຂະຫຍາຍຊ\u{eb5}\u{ec9}ໄປຂວາ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("didinimo stiklas į dešinę"),
            keywords: &[
                "didinimo",
                "didinimo stiklas į dešinę",
                "paieška",
                "stiklas",
                "įrankis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pa labi vērsta lupa"),
            keywords: &["lupa", "pa labi vērsta lupa", "palielināt"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("karāhe whārahi anga matau"),
            keywords: &[
                "karāhe",
                "karāhe whārahi anga matau",
                "rapu",
                "utauta",
                "whārahi",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лупа свртена надесно"),
            keywords: &[
                "десно",
                "зголемување",
                "лупа",
                "лупа свртена надесно",
                "пребарување",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "വലത\u{d4d}തേക\u{d4d}ക\u{d4d} പോയിന\u{d4d}റ\u{d4d} ചെയ\u{d4d}യ\u{d41}ന\u{d4d}ന ഭ\u{d42}തക\u{d4d}കണ\u{d4d}ണ\u{d3e}ടി",
            ),
            keywords: &[
                "ഉപകരണം",
                "കണ\u{d4d}ണ\u{d3e}ടി",
                "ഭ\u{d42}തക\u{d4d}കണ\u{d4d}ണ\u{d3e}ടി",
                "വലത\u{d4d}തേക\u{d4d}ക\u{d4d} പോയിന\u{d4d}റ\u{d4d} ചെയ\u{d4d}യ\u{d41}ന\u{d4d}ന ഭ\u{d42}തക\u{d4d}കണ\u{d4d}ണ\u{d3e}ടി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("баруун тийш хазайлгасан томруулагч шил"),
            keywords: &[
                "баруун",
                "баруун тийш хазайлгасан томруулагч шил",
                "томруулагч",
                "шил",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("उजव\u{947} दर\u{94d}शविणार\u{947} विशालक भि\u{902}ग"),
            keywords: &[
                "उजव\u{947} दर\u{94d}शविणार\u{947} विशालक भि\u{902}ग",
                "काच",
                "विशालक भि\u{902}ग",
                "शोध",
                "साधन",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kanta pembesar condong ke kanan"),
            keywords: &[
                "alat",
                "carian",
                "kanta",
                "kanta pembesar condong ke kanan",
                "pembesar",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("lenti tat-tkabbir tipponta Lemin"),
            keywords: &[
                "fittex",
                "għodda",
                "lenti tat-tkabbir tipponta Lemin",
                "tkabbir ottiku",
                "ħġieġ",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ညာသ\u{102d}\u{102f}\u{1037}စောင\u{103a}းထားသည\u{1037}\u{103a} မ\u{103e}န\u{103a}ဘ\u{102e}လ\u{1030}း",
            ),
            keywords: &[
                "ညာသ\u{102d}\u{102f}\u{1037}စောင\u{103a}းထားသည\u{1037}\u{103a} မ\u{103e}န\u{103a}ဘ\u{102e}လ\u{1030}း",
                "မ\u{103e}န\u{103a}ဘ\u{102e}လ\u{1030}း",
                "အကြ\u{102e}းချ\u{1032}\u{1037}ခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("forstørrelsesglass mot høyre"),
            keywords: &[
                "forstørrelse",
                "forstørrelsesglass mot høyre",
                "glass",
                "lupe",
                "søk",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some(
                "दाया\u{901}तर\u{94d}फ ढल\u{94d}क\u{947}को म\u{94d}याग\u{94d}निफाइङ ग\u{94d}लास",
            ),
            keywords: &[
                "उपकरण",
                "खोज",
                "ग\u{94d}लास",
                "दाया\u{901}तर\u{94d}फ ढल\u{94d}क\u{947}को म\u{94d}याग\u{94d}निफाइङ ग\u{94d}लास",
                "म\u{94d}याग\u{94d}निफाइङ",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vergrootglas naar rechts gericht"),
            keywords: &[
                "gereedschap",
                "glas",
                "vergrootglas naar rechts gericht",
                "vergroten",
                "zoeken",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("forstørringsglas mot høgre"),
            keywords: &[
                "forstørring",
                "forstørringsglas mot høgre",
                "glas",
                "lupe",
                "søk",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଡ\u{b3e}ହ\u{b3e}ଣକ\u{b41} ଢଳ\u{b3f}ଥ\u{b3f}ବ\u{b3e} ଯବକ\u{b3e}ଚ"),
            keywords: &[
                "କ\u{b3e}ଚ",
                "ଜବକ\u{b3e}ଚ",
                "ଡ\u{b3e}ହ\u{b3e}ଣକ\u{b41} ଢଳ\u{b3f}ଥ\u{b3f}ବ\u{b3e} ଯବକ\u{b3e}ଚ",
                "ଡ\u{b3e}ହ\u{b3e}ଣକ\u{b41} ଦ\u{b43}ଷ\u{b4d}ଟ\u{b3f} ନ\u{b3f}କ\u{b4d}ଷେପ କର\u{b41}ଥ\u{b3f}ବ\u{b3e}",
                "ଡ\u{b3e}ହ\u{b3e}ଣକ\u{b41} ଦ\u{b43}ଷ\u{b4d}ଟ\u{b3f} ନ\u{b3f}କ\u{b4d}ଷେପ କର\u{b41}ଥ\u{b3f}ବ\u{b3e} ଜବକ\u{b3e}ଚ",
                "ସନ\u{b4d}ଧ\u{b3e}ନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a71}ਜ\u{a47}-ਵ\u{a71}ਲ ਇਸ\u{a3c}ਾਰਾ ਕਰਦਾ ਮ\u{a48}ਗਨੀਫਾਇ\u{a70}ਗ ਗਲਾਸ"),
            keywords: &[
                "ਖ\u{a4b}ਜ",
                "ਗਲਾਸ",
                "ਮ\u{a48}ਗਨੀਫਾਇ\u{a70}ਗ ਗਲਾਸ",
                "ਸ\u{a4b}ਜਾ ਪਾਇ\u{a70}ਟ",
                "ਸ\u{a71}ਜ\u{a47} ਪਾਇ\u{a70}ਟ ਤ\u{a4b}\u{a02} ਮ\u{a48}ਗਨੀਫਾਇ\u{a70}ਗ ਗਲਾਸ",
                "ਸ\u{a71}ਜ\u{a47}-ਵ\u{a71}ਲ ਇਸ\u{a3c}ਾਰਾ ਕਰਦਾ ਮ\u{a48}ਗਨੀਫਾਇ\u{a70}ਗ ਗਲਾਸ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سجے ـ اشارہ کردا وڈا کرن آلا شیشہ"),
            keywords: &[
                "اوزار",
                "سجے ـ اشارہ کردا وڈا کرن آلا شیشہ",
                "وڈا کرنا",
                "کھوج لانا",
                "گلاس",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Magnifáyín Glas Wé Bẹ\u{301}nd Rait"),
            keywords: &[
                "Glas",
                "Magnifáyin",
                "Magnifáyín Glas Wé Bẹ\u{301}nd Rait",
                "Sach",
                "Tul",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("lupa pochylona w prawo"),
            keywords: &[
                "lupa",
                "lupa pochylona w prawo",
                "skierowana w prawo",
                "szukaj",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښي لور ته ذره بین لرونکې ښیښه"),
            keywords: &[
                "اله",
                "لويوونکې",
                "لويوونکې ښيښه ښۍ اړخ ته کږه",
                "لټون",
                "ښي لور ته ذره بین لرونکې ښیښه",
                "ښيښه",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("lupa para a direita"),
            keywords: &[
                "ferramenta",
                "lente de aumento",
                "lupa",
                "lupa para a direita",
                "pesquisa",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("lupa inclinada para a direita"),
            keywords: &[
                "ferramenta",
                "lupa",
                "lupa inclinada para a direita",
                "pesquisar",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("lupă înclinată spre dreapta"),
            keywords: &[
                "căutare",
                "instrument",
                "lupă",
                "lupă înclinată spre dreapta",
                "mărire",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-714"),
            keywords: &["E10-714"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("лупа, наклоненная вправо"),
            keywords: &[
                "вправо",
                "лупа",
                "лупа, наклоненная вправо",
                "стекло",
                "увеличительное стекло",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("rupe ireba iburyo"),
            keywords: &[
                "gutubura",
                "igikoresho",
                "ikirahuri",
                "ishakisha",
                "rupe ireba iburyo",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ميگنيفائينگ ساڄي پاسي مڙيل شيشو"),
            keywords: &[
                "اوزار",
                "شيشو",
                "ميگنيفائينگ",
                "ميگنيفائينگ ساڄي پاسي مڙيل شيشو",
                "ڳولڻ",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("දක\u{dd4}ණට යොම\u{dd4} ව\u{dd6} ව\u{dd2}ශ\u{dcf}ලන ක\u{dcf}චය"),
            keywords: &[
                "දක\u{dd4}ණට යොම\u{dd4} ව\u{dd6} ව\u{dd2}ශ\u{dcf}ලන ක\u{dcf}චය",
                "මෙවලම",
                "ව\u{dd2}ශ\u{dcf}ලනය",
                "ව\u{dd3}ද\u{dd4}ර\u{dd4}ව",
                "සෙව\u{dd3}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("doprava naklonená lupa"),
            keywords: &[
                "doprava naklonená lupa",
                "hľadanie",
                "lupa",
                "nástroj",
                "priblíženie",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("povečevalno steklo, usmerjeno v desno"),
            keywords: &[
                "iskanje",
                "orodje",
                "povečevalno",
                "povečevalno steklo, usmerjeno v desno",
                "steklo",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("quruurad weynayso ah oo u jeeda midig"),
            keywords: &[
                "qalab",
                "quruurad",
                "quruurad weynayso ah oo u jeeda midig",
                "raadin",
                "weynayso",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("lupë zmadhuese e drejtuar djathtas"),
            keywords: &[
                "kërko",
                "lupë",
                "lupë zmadhuese e drejtuar djathtas",
                "lupë zmadhuese që tregon djathtas",
                "xham zmadhues",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лупа усмерена надесно"),
            keywords: &["aлaт", "лупа", "лупа усмерена надесно", "стaклo", "трaжeњe"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("лупа усмјерена надесно"),
            keywords: &["лупа усмјерена надесно"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lupa usmerena nadesno"),
            keywords: &[
                "alat",
                "lupa",
                "lupa usmerena nadesno",
                "staklo",
                "traženje",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("lupa usmjerena nadesno"),
            keywords: &["lupa usmjerena nadesno"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("förstoringsglas som lutar åt höger"),
            keywords: &[
                "förstoringsglas",
                "förstoringsglas höger",
                "förstoringsglas som lutar åt höger",
                "högerpekande",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kioo cha ukuzaji kinachoelekeza kulia"),
            keywords: &[
                "glasi",
                "kioo cha ukuzaji kinachoelekeza kulia",
                "kukuza",
                "tafuta",
                "zana",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வலது ச\u{bbe}ய\u{bcd}வு லென\u{bcd}ஸ\u{bcd}"),
            keywords: &[
                "தேடல\u{bcd}",
                "தேடு",
                "லென\u{bcd}ஸ\u{bcd}",
                "வலது ச\u{bbe}ய\u{bcd}வு லென\u{bcd}ஸ\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కుడ\u{c3f}క\u{c3f} వంగ\u{c3f} ఉన\u{c4d}న భూతద\u{c4d}దం"),
            keywords: &[
                "కుడ\u{c3f}క\u{c3f} వంగ\u{c3f} ఉన\u{c4d}న భూతద\u{c4d}దం",
                "కుడ\u{c3f}వ\u{c48}పు సూచ\u{c3f}ంచ\u{c47} భూతద\u{c4d}దం",
                "శ\u{c4b}ధన చ\u{c3f}హ\u{c4d}నం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("пурбини ба тарфи рост ишоракунанда"),
            keywords: &[
                "асбоб",
                "бузургкунӣ",
                "пурбини ба тарфи рост ишоракунанда",
                "шиша",
                "ҷустуҷӯ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แว\u{e48}นขยายเอ\u{e35}ยงขวา"),
            keywords: &[
                "ขยาย",
                "ค\u{e49}นหา",
                "เคร\u{e37}\u{e48}องม\u{e37}อ",
                "แว\u{e48}น",
                "แว\u{e48}นขยายเอ\u{e35}ยงขวา",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("saga egilen lupa"),
            keywords: &["aýna", "gural", "gözleg", "lupa", "saga egilen lupa"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sioʻata ʻesiafi falala ki mataʻu"),
            keywords: &["sioʻata ʻesiafi falala ki mataʻu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sağa dönük büyüteç"),
            keywords: &[
                "arama",
                "cam",
                "sağa dönük büyüteç",
                "sağı gösteren",
                "sağı gösteren büyüteç",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئوڭغا قارىغان چوڭايتقۇچ"),
            keywords: &[
                "ئوڭغا قارىغان چوڭايتقۇچ",
                "ئىزدەش",
                "ئەينەك",
                "قورال",
                "چوڭايتقۇچ",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("збільшувальне скло з нахилом управо"),
            keywords: &[
                "збільшувальне скло з нахилом управо",
                "збільшувальне скло, спрямоване праворуч",
                "лупа",
                "пошук",
                "інструмент",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("دائیں اشارہ کرتا محدب عدسہ"),
            keywords: &[
                "آلہ",
                "اشارہ",
                "دائیں",
                "دائیں اشارہ کرتا محدب عدسہ",
                "سمت",
                "عدسہ",
                "محدب",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("oʻngga qiyshaygan lupa"),
            keywords: &[
                "asbob",
                "kattalashtirish",
                "oʻngga qiyshaygan lupa",
                "o‘ngga qaragan lupa",
                "qidirish",
                "shisha",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("kính lúp nghiêng sang phải"),
            keywords: &[
                "dụng cụ",
                "kính",
                "kính lúp nghiêng sang phải",
                "kính phóng đại nghiêng sang phải",
                "phóng đại",
                "tìm kiếm",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("lup bu féete ndijoor"),
            keywords: &["jumtukaay", "lup bu féete ndijoor", "rëyal", "seet", "weer"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iglasi yokwandisa eyalathe ekunene"),
            keywords: &[
                "iglasi",
                "iglasi yokwandisa eyalathe ekunene",
                "isixhobo",
                "khangela",
                "yokwandisa",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("gilasi itọka-ọtun amohun tobi"),
            keywords: &[
                "díígí",
                "gilasi itọka-ọtun amohun tobi",
                "irinṣẹ\u{301}",
                "ìfojúsóde",
                "ìsọdinlá",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("放大鏡向右傾斜"),
            keywords: &["工具", "搜尋", "放大", "放大鏡向右傾斜", "鏡片"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("放大镜向右倾斜"),
            keywords: &["工具", "搜寻", "放大", "放大镜向右倾斜", "镜片"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("右斜的放大镜"),
            keywords: &["右斜的放大镜", "工具", "搜索", "放大", "放大镜", "查找"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("放大鏡"),
            keywords: &["搜尋", "放大", "放大鏡"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("向右嘅放大鏡"),
            keywords: &["向右嘅放大鏡", "向右嘅放大鏡｜放大｜搜尋"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhodlela elikhulisayo elibheke kwesokudla"),
            keywords: &[
                "ibhodlela",
                "ibhodlela elikhulisayo elibheke kwesokudla",
                "ithuluzi",
                "ukukhulisa",
                "ukusesha",
            ],
        },
    ],
};
#[doc = "🕯\u{fe0f}"]
pub const CANDLE: crate::Emoji = crate::Emoji {
    glyph: "🕯\u{fe0f}",
    codepoint: "1F56F FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "candle",
    group: "Objects",
    subgroup: "light & video",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🕯",
        codepoint: "1F56F",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "candle",
        group: "Objects",
        subgroup: "light & video",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kers"),
            keywords: &["kers", "lig", "vlam"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሻማ"),
            keywords: &["ሻማ", "ብርሃን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شمعة"),
            keywords: &["شمعة", "ضوء"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মম"),
            keywords: &["পোহৰ", "মম"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("şam"),
            keywords: &["işıq", "şam"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("свечка"),
            keywords: &["агонь", "свечка", "святло"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("свещ"),
            keywords: &["светлина", "свещ"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মোমব\u{9be}তি"),
            keywords: &["আলো", "মোমব\u{9be}তি"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("goulaouenn"),
            keywords: &["goulaouenn", "gouloù"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("svijeća"),
            keywords: &["svijeća", "svjetlo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("espelma"),
            keywords: &["cera", "espelma", "flama", "llum"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄟\u{1112a}𑄟\u{11134}𑄝𑄖\u{11134}\u{11128}"),
            keywords: &["𑄟\u{1112a}𑄟\u{11134}𑄝𑄖\u{11134}\u{11128}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎧᎾᏫ ᎠᏨᏍᏗ"),
            keywords: &["ᎠᏨᏍᏗ", "ᎤᎧᎾᏫ ᎠᏨᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("svíčka"),
            keywords: &["svíčka", "světlo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cannwyll"),
            keywords: &["cannwyll", "golau"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("stearinlys"),
            keywords: &["lys", "stearinlys"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Kerze"),
            keywords: &["Kerze", "Licht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κερί"),
            keywords: &["κερί", "φως"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("candle"),
            keywords: &["candle", "light"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("vela"),
            keywords: &["luz", "vela"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["cera", "fuego", "luz", "vela"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("küünal"),
            keywords: &["küünal", "valgus"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kandela"),
            keywords: &["argi", "kandela"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("شمع"),
            keywords: &["رمانتیک", "شعله", "شمع", "نور"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kynttilä"),
            keywords: &["kynttilä", "valo"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kandila"),
            keywords: &["ilaw", "kandila"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("livandi ljós"),
            keywords: &["kertiljós", "livandi ljós", "ljós"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bougie"),
            keywords: &["bougie", "lumière"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("coinneal"),
            keywords: &["coinneal", "solas"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("coinneal"),
            keywords: &["coinneal", "solas"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("candea"),
            keywords: &["candea", "cera", "iluminar", "luz"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મીણબત\u{acd}તી"),
            keywords: &["મીણબત\u{acd}તી", "લાઇટ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kyandir"),
            keywords: &["kyandir", "wutar lantarki"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("נר"),
            keywords: &["אור", "להבה", "נר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("मोमबत\u{94d}ती"),
            keywords: &["प\u{94d}रकाश", "मोमबत\u{94d}ती"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("svijeća"),
            keywords: &["svijeća", "svjetlo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("gyertya"),
            keywords: &["gyertya", "világítás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մոմ"),
            keywords: &["լույս", "մոմ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("lilin"),
            keywords: &["cahaya", "lilin"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("kandụ\u{300}l"),
            keywords: &["kandụ\u{300}l", "ọkụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kerti"),
            keywords: &["kerti", "ljós"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("candela"),
            keywords: &[
                "a lume di candela",
                "candela",
                "candela accesa",
                "cera",
                "illuminare",
                "luce",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ろうそく"),
            keywords: &["ろうそく", "キャンドル", "ロウソク", "明かり"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("lilin"),
            keywords: &["cahya", "lilin"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სანთელი"),
            keywords: &["სანთელი", "სინათლე", "შუქი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("майшам"),
            keywords: &["майшам", "шам"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("stearinlys"),
            keywords: &["lys", "stearinlys"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ទៀន"),
            keywords: &[
                "ទៀន",
                "ពន\u{17d2}ល\u{17ba}",
                "ភ\u{17d2}លើងទៀនភ\u{17d2}ល\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{ccd}ಯಾಂಡಲ\u{ccd}"),
            keywords: &[
                "ಕ\u{ccd}ಯಾಂಡಲ\u{ccd}",
                "ಬ\u{cc6}ಳಕು",
                "ಮೋಂಬತ\u{ccd}ತ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("양초"),
            keywords: &["양초", "캔들"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("म\u{947}णवाक"),
            keywords: &["उजवाड", "म\u{947}णवाक", "म\u{947}णवात"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("шам"),
            keywords: &["жарык", "шам"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Käerz"),
            keywords: &["Käerz", "Luucht"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ທຽນ"),
            keywords: &["ທຽນ", "ແສງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žvakė"),
            keywords: &["šviesa", "žvakė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("svece"),
            keywords: &["svece", "uguns"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kānara"),
            keywords: &["kānara", "rama"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("свеќа"),
            keywords: &["светло", "свеќа"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മെഴ\u{d41}ക\u{d41}തിരി"),
            keywords: &["മെഴ\u{d41}ക\u{d41}തിരി", "വെളിച\u{d4d}ചം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("лаа"),
            keywords: &["гэрэл", "лаа"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("म\u{947}णबत\u{94d}ती"),
            keywords: &["दिवा", "म\u{947}णबत\u{94d}ती"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("lilin"),
            keywords: &["cahaya", "lilin"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("xemgħa"),
            keywords: &["dawl", "xemgħa"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဖယောင\u{103a}းတ\u{102d}\u{102f}င\u{103a}"),
            keywords: &["ဖယောင\u{103a}းတ\u{102d}\u{102f}င\u{103a}", "မ\u{102e}း"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("stearinlys"),
            keywords: &["lys", "stearin", "stearinlys"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("म\u{948}नबत\u{94d}ती"),
            keywords: &["बत\u{94d}ती", "म\u{948}नबत\u{94d}ती"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kaars"),
            keywords: &["kaars", "licht"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("stearinlys"),
            keywords: &["lys", "stearin", "stearinlys"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମହମ"),
            keywords: &["ଆଲୋକ", "ମହମ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a4b}ਮਬ\u{a71}ਤੀ"),
            keywords: &["ਮ\u{a4b}ਮਬ\u{a71}ਤੀ", "ਰ\u{a4c}ਸ\u{a3c}ਨੀ", "ਲਾਈਟਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("موم بتی"),
            keywords: &["بتی", "موم بتی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kándul"),
            keywords: &["Kándul", "Lait"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("świeca"),
            keywords: &["światło", "świeca", "świeczka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شمع"),
            keywords: &["رڼا", "شمع"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("vela"),
            keywords: &["luz", "vela"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("vela"),
            keywords: &["luz", "vela"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("vela"),
            keywords: &["vela"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("lumânare"),
            keywords: &["flacără", "lumină", "lumânare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-792"),
            keywords: &["E10-792"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("свеча"),
            keywords: &["воск", "огонь", "пламя", "свет", "свеча", "свечка", "тепло"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("buji"),
            keywords: &["Ikeye", "buji"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ميڻ بتي"),
            keywords: &["روشني", "ميڻ بتي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඉට\u{dd2}පන\u{dca}දම"),
            keywords: &["ආලෝකය", "ඉට\u{dd2}පන\u{dca}දම"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("sviečka"),
            keywords: &["svetlo", "sviečka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("sveča"),
            keywords: &["luč", "sveča"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("shamac"),
            keywords: &["shamac", "shamac iftiin"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("qiri"),
            keywords: &["dritë", "qiri"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("свећа"),
            keywords: &["светлo", "свећа"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("свијећа"),
            keywords: &["свијећа"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("sveća"),
            keywords: &["svetlo", "sveća"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("svijeća"),
            keywords: &["svijeća"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("stearinljus"),
            keywords: &["levande ljus", "ljus", "stearinljus"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mshumaa"),
            keywords: &["mshumaa", "mwanga"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மெழுகுவர\u{bcd}த\u{bcd}தி"),
            keywords: &[
                "ஒளி",
                "கேண\u{bcd}டில\u{bcd} ப\u{bbe}ர\u{bcd}ட\u{bcd}டி",
                "மெழுகுவர\u{bcd}த\u{bcd}தி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c4a}వ\u{c4d}వ\u{c4a}త\u{c4d}త\u{c3f}"),
            keywords: &[
                "క\u{c4a}వ\u{c4d}వ\u{c4a}త\u{c4d}త\u{c3f}",
                "ద\u{c40}పం",
                "వ\u{c46}లుగు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("шамъ"),
            keywords: &["рӯшноӣ", "шамъ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เท\u{e35}ยน"),
            keywords: &["เท\u{e35}ยน", "แสง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("şem"),
            keywords: &["çyra", "şem"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("teʻelango"),
            keywords: &["teʻelango"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("mum"),
            keywords: &["mum", "ışık"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("شام"),
            keywords: &["شام", "چىراق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("свічка"),
            keywords: &["світло", "свічка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("موم بتی"),
            keywords: &["بتی", "روشنی", "موم"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("sham"),
            keywords: &["sham", "yorug‘lik"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nến"),
            keywords: &["nến", "ánh sáng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("sondeel"),
            keywords: &["làmp", "sondeel"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ikhandlela"),
            keywords: &["ikhandlela", "isibane"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("kándúùlù"),
            keywords: &["iná", "kándúùlù"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("蠟燭"),
            keywords: &["光", "蠟燭"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("蜡烛"),
            keywords: &["光", "蜡烛"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("蜡烛"),
            keywords: &["光", "烛光", "烛火", "照明", "燃烧", "蜡烛"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("蠟燭"),
            keywords: &["蠟燭"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ikhandlela"),
            keywords: &["ikhandlela", "ukukhanya"],
        },
    ],
};
#[doc = "💡"]
pub const LIGHT_BULB: crate::Emoji = crate::Emoji {
    glyph: "💡",
    codepoint: "1F4A1",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "light bulb",
    group: "Objects",
    subgroup: "light & video",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gloeilamp"),
            keywords: &["elektries", "gloeilamp", "idee", "lig", "skyn"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አምፖል"),
            keywords: &["ሐሳብ", "ብርሃን", "አምፖል", "አስቂኝ", "ኤሌክትሪክ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مصباح مضاء"),
            keywords: &["كهرباء", "لمبة مضيئة", "مصباح مضاء"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বিজ\u{9c1}লী-ব\u{9be}তি"),
            keywords: &[
                "কমিক",
                "ধ\u{9be}ৰণ\u{9be}",
                "পোহৰ",
                "ব\u{9be}ল\u{9cd}ব",
                "বিজ\u{9c1}লী-ব\u{9be}তি",
                "বৈদ\u{9cd}য\u{9c1}তিক",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("işıq lampası"),
            keywords: &[
                "elektrik",
                "ideya",
                "işıq",
                "işıq lampası",
                "komik",
                "lampa",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("лямпачка"),
            keywords: &[
                "комікс",
                "лямпа",
                "лямпачка",
                "святло",
                "электрычнасць",
                "эўрыка",
                "ідэя",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Електрическа крушка"),
            keywords: &[
                "Електрическа крушка",
                "идея",
                "комикс",
                "крушка",
                "светлина",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("আলোর ব\u{9be}ল\u{9cd}ব"),
            keywords: &[
                "আলো",
                "আলোর ব\u{9be}ল\u{9cd}ব",
                "কমিক",
                "ধ\u{9be}রণ\u{9be}",
                "ব\u{9be}ল\u{9cd}ব",
                "বৈদ\u{9cd}য\u{9c1}তিক",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("klogorenn"),
            keywords: &["klogorenn", "tredan"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("sijalica"),
            keywords: &["elektrika", "ideja", "sijalica", "stripovi", "svjetlo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bombeta"),
            keywords: &["bombeta", "còmic", "electricitat", "idea", "llum"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄟\u{1112a}𑄟\u{11134}𑄝𑄖\u{11134}\u{11128} 𑄝𑄣\u{11133}𑄛\u{11134}"),
            keywords: &["𑄟\u{1112a}𑄟\u{11134}𑄝𑄖\u{11134}\u{11128} 𑄝𑄣\u{11133}𑄛\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏨᏍᏗ ᎦᏗ"),
            keywords: &["ᎠᏓᏅᏖᏢ", "ᎠᏨᏍᏗ", "ᎠᏨᏍᏗ ᎦᏗ", "ᎤᏬᏟᏗ", "ᏗᎾᎦᎵᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("žárovka"),
            keywords: &[
                "baňka",
                "elektrická",
                "elektřina",
                "komiks",
                "nápad",
                "světlo",
                "žárovka",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bwlb golau"),
            keywords: &["bwlb", "bwlb golau", "comig", "syniad", "trydanol"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("elpære"),
            keywords: &["elpære", "ide", "idé", "lys ide"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Glühbirne"),
            keywords: &["Glühbirne", "Idee", "Licht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("λαμπτήρας"),
            keywords: &["ηλεκτρικό", "ιδέα", "κόμικ", "λαμπτήρας", "φως"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("light bulb"),
            keywords: &["bulb", "comic", "electric", "idea", "light"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("light globe"),
            keywords: &["bulb", "comic", "electric", "globe", "idea", "light"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bombilla"),
            keywords: &["bombilla", "cómic", "electricidad", "idea", "luz"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("lámpara"),
            keywords: &["cómic", "idea", "lamparita", "lámpara"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("foco"),
            keywords: &["foco"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("foco"),
            keywords: &["cómic", "electricidad", "foco", "idea", "luz"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("lamp"),
            keywords: &["elekter", "idee", "lamp", "pirn", "valgus"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bonbilla"),
            keywords: &["argi", "bonbilla", "elektriko", "ideia", "komiki"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("لامپ"),
            keywords: &["الکتریسیته", "ایده", "برق", "حباب", "لامپ", "نور"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hehkulamppu"),
            keywords: &["ajatus", "hehkulamppu", "lamppu", "sähkö", "valo"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bumbilya ng ilaw"),
            keywords: &[
                "bumbilya",
                "bumbilya ng ilaw",
                "comic",
                "de-kuryente",
                "ideya",
                "ilaw",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("ljóspera"),
            keywords: &["hugskot", "ljós", "ljóspera", "pera"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("ampoule"),
            keywords: &["ampoule", "dessin", "idée", "lumière"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["ampoule", "idée", "lumière"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bolgán solais"),
            keywords: &["bolgán", "bolgán solais", "leictreach", "solas"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bolgan solais"),
            keywords: &[
                "beachd",
                "beachd-smuain",
                "bolgan",
                "bolgan solais",
                "dealan",
                "dealanach",
                "dealbh-èibhinn",
                "solas",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("lámpada"),
            keywords: &["cómic", "electricidade", "idea", "luz", "lámpada"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લાઇટનો બલ\u{acd}બ"),
            keywords: &[
                "કોમિક",
                "ગોળો",
                "લાઇટનો બલ\u{acd}બ",
                "વિચાર આવ\u{acd}યો",
                "વીજ",
                "વીજળી",
                "વીજળીનો ગોળો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kwan fitila"),
            keywords: &[
                "gulob",
                "kwan fitila",
                "mai ban dariya",
                "na lantarki",
                "shawara",
                "wuta",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("נורה"),
            keywords: &["אור", "חשמל", "נורה", "רעיון"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("लाइट बल\u{94d}ब, विचार"),
            keywords: &[
                "कॉमिक",
                "प\u{94d}रकाश",
                "बल\u{94d}ब",
                "बिजली",
                "लाइट बल\u{94d}ब",
                "लाइट बल\u{94d}ब, विचार",
                "विचार",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("žarulja"),
            keywords: &["ideja", "struja", "svjetlo", "žarulja"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("villanykörte"),
            keywords: &["fény", "képregény", "villanykörte", "világítás", "ötlet"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("էլեկտրական լամպ"),
            keywords: &["գաղափար", "էլեկտրական", "լամպ", "լույս", "կոմիքս"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bohlam"),
            keywords: &["bohlam", "elektrik", "ide", "komik", "lampu"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọkụ bọlbụ"),
            keywords: &["latrikị", "mkpaọchị", "uche", "ọkụ", "ọkụ bọlbụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ljósapera"),
            keywords: &["hugmynd", "ljós", "ljósapera", "rafmagn", "skrípó"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("lampadina"),
            keywords: &["elettrica", "fumetto", "idea", "lampadina", "luce"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("電球"),
            keywords: &["ひらめき", "ぴこーん", "明かり", "電球"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bohlam"),
            keywords: &["bohlam", "cahya", "elektrik", "ide", "komik"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ნათურა"),
            keywords: &["ელექტრო", "იდეა", "ნათურა", "სასაცილო", "სინათლე", "შუქი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("лампа"),
            keywords: &["комик", "лампа", "пікір", "шам", "электрлік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("elpære"),
            keywords: &["elpære", "ide", "lys ide"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("អ\u{17c6}ព\u{17bc}លពងមាន\u{17cb}"),
            keywords: &[
                "ពន\u{17d2}ល\u{17ba}",
                "ភ\u{17d2}ល\u{17ba}",
                "ភ\u{17d2}លើង",
                "អ\u{17c6}ព\u{17bc}ល",
                "អ\u{17c6}ព\u{17bc}លពងមាន\u{17cb}",
                "អ\u{17c6}ព\u{17bc}លភ\u{17d2}លើង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{cc6}ಳಕ\u{cbf}ನ ಬಲ\u{ccd}ಬ\u{ccd}"),
            keywords: &[
                "ಐಡ\u{cbf}ಯಾ",
                "ಕಾಮ\u{cbf}ಕ\u{ccd}",
                "ಬಲ\u{ccd}ಬ\u{ccd}",
                "ಬ\u{cc6}ಳಕ\u{cbf}ನ ಬಲ\u{ccd}ಬ\u{ccd}",
                "ಬ\u{cc6}ಳಕು",
                "ವ\u{cbf}ದ\u{ccd}ಯುತ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("전구"),
            keywords: &["기발한 생각", "아이디어", "아하", "전구"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("लायटीचो दिवो"),
            keywords: &[
                "उजवाड",
                "कल\u{94d}पना",
                "बल\u{94d}ब",
                "लायटीचो दिवो",
                "विद\u{94d}य\u{941}त",
                "विनोदी",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жарык лампочкасы"),
            keywords: &["жарык лампочкасы", "идея", "комикс", "лампочка", "электр"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Bir"),
            keywords: &["Bir", "Comic", "Iddi", "Liicht", "Luucht", "elektresch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ດອກໄຟ"),
            keywords: &["ດອກໄຟ", "ແສງສະຫວ\u{ec8}າງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("lemputė"),
            keywords: &["elektra", "idėja", "komiksas", "lemputė", "šviesa"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("spuldze"),
            keywords: &["elektrība", "gaisma", "ideja", "komikss", "spuldze"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("puku mārama"),
            keywords: &["hiko", "mārama", "puku", "whakaaro", "whakakata"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("светилка"),
            keywords: &["електрична", "светилка", "светло"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ബൾബ\u{d4d}"),
            keywords: &[
                "ഇലക\u{d4d}ട\u{d4d}രിക\u{d4d}ക\u{d4d}",
                "ഒര\u{d41} ആശയമ\u{d41}ണ\u{d4d}ട\u{d4d}",
                "കോമിക\u{d4d}ക\u{d4d}",
                "ബൾബ\u{d4d}",
                "ലൈറ\u{d4d}റ\u{d4d} ബൾബ\u{d4d}",
                "വെളിച\u{d4d}ചം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гэрлийн чийдэн"),
            keywords: &[
                "гэрлийн чийдэн",
                "гэрэл",
                "инээдмийн",
                "санаа",
                "цахилгаан",
                "чийдэн",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{94d}रकाशाचा दिवा"),
            keywords: &[
                "एक कल\u{94d}पना मिळाली",
                "प\u{94d}रकाश",
                "प\u{94d}रकाशाचा दिवा",
                "बल\u{94d}ब",
                "विज\u{947}चा दिवा",
                "विद\u{94d}य\u{941}त",
                "विनोदी",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("mentol lampu"),
            keywords: &[
                "cahaya",
                "elektrik",
                "idea",
                "komik",
                "mentol",
                "mentol lampu",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("bozza"),
            keywords: &["bozza", "dawl", "elettriku", "idea", "komiku"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မ\u{102e}းလ\u{102f}\u{1036}း"),
            keywords: &[
                "မ\u{102e}းလ\u{102f}\u{1036}း",
                "မ\u{102e}းသ\u{102e}း",
                "လျ\u{103e}ပ\u{103a}စစ\u{103a}",
                "ဟာသ",
                "အကြ\u{1036}ဉာဏ\u{103a}",
                "အလင\u{103a}းရောင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("lyspære"),
            keywords: &[
                "elektrisitet",
                "idé",
                "lys",
                "lyspære",
                "pære",
                "tegneserie",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बत\u{94d}तीको चिम"),
            keywords: &[
                "बत\u{94d}ती",
                "बत\u{94d}तीको चिम",
                "विचार",
                "विद\u{94d}य\u{941}तीय",
                "हास\u{94d}य",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gloeilamp"),
            keywords: &[
                "elektrisch",
                "gloeilamp",
                "idee",
                "licht",
                "peertje",
                "strip",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("lyspære"),
            keywords: &[
                "elektrisitet",
                "idé",
                "lys",
                "lyspære",
                "pære",
                "teikneserie",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଲ\u{b3e}ଇଟ\u{b4d}\u{200c} ବଲ\u{b4d}ୱ"),
            keywords: &[
                "ଆଲୋକ",
                "ଆଲୋକ ବଲବ\u{b4d}\u{200c}",
                "ଏକ ଧ\u{b3e}ରଣ\u{b3e} ପ\u{b3e}ଇବ\u{b3e}",
                "ବଲକ\u{b4d}\u{200c}",
                "ବୈଦ\u{b4d}ୟ\u{b41}ତ\u{b3f}କ",
                "ଲ\u{b3e}ଇଟ\u{b4d}\u{200c} ବଲ\u{b4d}ୱ",
                "ହ\u{b3e}ସ\u{b4d}ୟୋଦ\u{b4d}ଦୀପକ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲਾਈਟ ਬ\u{a71}ਲਬ"),
            keywords: &[
                "ਇ\u{a71}ਕ ਵਿਚਾਰ ਮਿਲਿਆ",
                "ਕਾਮਿਕ",
                "ਚਾਨਣ",
                "ਬਿਜਲੀ",
                "ਬ\u{a71}ਲਬ",
                "ਲਾਈਟ ਬ\u{a71}ਲਬ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بتی آلا بلب"),
            keywords: &[
                "بتی",
                "بتی آلا بلب",
                "برقی",
                "بلب",
                "رائے",
                "م\u{64f}ضح\u{650}کہ خیز",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Laít Bọlb"),
            keywords: &[
                "Aidia",
                "Bọlb",
                "Lait",
                "Laít Bọlb",
                "Ple",
                "Sọ\u{301}mtin Wé De Mék Pẹ\u{301}sin Laf",
                "Ẹlẹ\u{301}ktrik",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("żarówka"),
            keywords: &["pomysł", "światło", "żarówka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د رڼا بلب"),
            keywords: &[
                "برېښنايي",
                "بلب",
                "د رڼا بلب",
                "د رڼا ګروپ",
                "رڼا",
                "لکۍ دار",
                "نظر",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("lâmpada"),
            keywords: &["elétrica", "ideia", "luz", "lâmpada", "quadrinhos"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("lâmpada"),
            keywords: &["desenho", "eletricidade", "ideia", "luz", "lâmpada"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("kʼancha"),
            keywords: &["kʼancha"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bec"),
            keywords: &["bandă desenată", "bec", "electricitate", "idee", "lumină"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-606"),
            keywords: &["E10-606"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("лампочка"),
            keywords: &[
                "идея",
                "лампа",
                "лампочка",
                "свет",
                "эврика",
                "электричество",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ampule"),
            keywords: &[
                "ampule",
                "cy’amashanyarazi",
                "gishekeje",
                "igitekerezo",
                "urumuri",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("روشني جو بلب"),
            keywords: &["برقي", "بلب", "خيال", "روشني", "روشني جو بلب", "ڪامڪ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ව\u{dd2}ද\u{dd4}ල\u{dd2} බ\u{dd4}බ\u{dd4}ළ"),
            keywords: &[
                "අදහස",
                "ආලෝකය",
                "බල\u{dca}බය",
                "ව\u{dd2}ද\u{dd4}ල\u{dd2} බ\u{dd4}බ\u{dd4}ළ",
                "ව\u{dd2}ද\u{dd4}ල\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("žiarovka"),
            keywords: &["elektrické", "komiks", "nápad", "svetlo", "žiarovka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("žarnica"),
            keywords: &["električno", "luč", "strip", "zamisel", "žarnica"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("laambad dab"),
            keywords: &["dab", "fikrad", "iftiin", "laambad", "xaraabe"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("llambë"),
            keywords: &["dritë", "elektrik", "ide", "llambë", "vizatim komik"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("сијалица"),
            keywords: &["идeja", "свeтлo", "сијалица", "струja"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["сијалица"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("sijalica"),
            keywords: &["ideja", "sijalica", "struja", "svetlo"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["sijalica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("glödlampa"),
            keywords: &["elektrisk", "fått en idé", "glödlampa", "lampa"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("taa"),
            keywords: &["kibonzo", "mwanga", "taa", "umeme", "wazo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மின\u{bcd}விளக\u{bcd}கு"),
            keywords: &[
                "ஐடிய\u{bbe}",
                "ஒளி",
                "நகைச\u{bcd}சுவை",
                "பல\u{bcd}பு",
                "மின\u{bcd}ச\u{bbe}ரம\u{bcd}",
                "மின\u{bcd}விளக\u{bcd}கு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బల\u{c4d}బ\u{c4d}"),
            keywords: &[
                "ఆల\u{c4b}చన ర\u{c3e}వడం",
                "బల\u{c4d}బ\u{c4d}",
                "వ\u{c3f}ద\u{c4d}యుత\u{c4d}తు",
                "వ\u{c46}లుతురు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("чароғак"),
            keywords: &[
                "барқӣ",
                "идея",
                "мазҳакавӣ",
                "рӯшноӣ",
                "фурӯзонак",
                "чароғак",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หลอดไฟ"),
            keywords: &["ป\u{e34}\u{e4a}งไอเด\u{e35}ย", "หลอดไฟ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("lampa"),
            keywords: &["gülkünç", "lampa", "pikir", "tok", "yşyk"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("foʻi ʻuhila"),
            keywords: &["foʻi ʻuhila"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ampul"),
            keywords: &["ampul", "bir fikrim var", "elektrik", "çizgi roman", "ışık"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("لامپۇچكا"),
            keywords: &[
                "توكلۇق",
                "كۆزقاراش",
                "كۈلكىلىك",
                "لامپا",
                "لامپۇچكا",
                "چىراق",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("лампочка"),
            keywords: &["електричний", "лампочка", "малюнок", "світло", "ідея"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("لائٹ بلب"),
            keywords: &["برقی", "بلب", "روشنی", "لائٹ بلب"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("elektr lampasi"),
            keywords: &["elektr", "elektr lampasi", "fikr", "latifa", "yorugʻlik"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bóng đèn"),
            keywords: &["bóng đèn", "hài hước", "ánh sáng", "ý tưởng", "điện"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("àmpul"),
            keywords: &["bu-kuuraŋ", "làmp", "reelu", "xalaat", "àmpul"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhalbhu yesibane"),
            keywords: &[
                "ibhalbhu",
                "ibhalbhu yesibane",
                "ingcinga",
                "isibane",
                "ukuhlekisa",
                "yombane",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("gólòbù iná"),
            keywords: &[
                "bó\u{329}ọ\u{300}bù",
                "gólòbù iná",
                "iná",
                "kọ\u{301}míìkì",
                "òye",
                "ẹ\u{300}lẹ\u{301}tíríìkì",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("燈膽"),
            keywords: &["光", "想法", "漫畫", "燈泡", "燈膽", "電"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("灯胆"),
            keywords: &["光", "想法", "漫画", "灯泡", "灯胆", "电"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("灯泡"),
            keywords: &["主意", "想法", "灯泡", "电灯泡", "白炽灯"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("燈泡"),
            keywords: &["燈泡"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("燈膽"),
            keywords: &["燈膽"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("igilobhu likagesi"),
            keywords: &[
                "igilobhu",
                "igilobhu likagesi",
                "opopayi",
                "ugesi",
                "ukukhanya",
                "umbono",
            ],
        },
    ],
};
#[doc = "🔦"]
pub const FLASHLIGHT: crate::Emoji = crate::Emoji {
    glyph: "🔦",
    codepoint: "1F526",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "flashlight",
    group: "Objects",
    subgroup: "light & video",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("flits"),
            keywords: &["elektries", "flits", "lig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የእጅ ባትሪ"),
            keywords: &["መሣሪያ", "ብርሃን", "ኤሌክትሪክ", "የእጅ ባትሪ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ضوء فلاش"),
            keywords: &["ضوء", "ضوء فلاش", "كشاف", "كهربائي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ফ\u{9cd}ল\u{9be}শ\u{9cd}বল\u{9be}ইট"),
            keywords: &[
                "টৰ\u{9cd}চ",
                "পোহৰ",
                "ফ\u{9cd}ল\u{9be}শ\u{9cd}বল\u{9be}ইট",
                "বৈদ\u{9cd}য\u{9c1}তিক",
                "স\u{981}জ\u{9c1}লি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("fənər"),
            keywords: &["alət", "elektrik", "fənər", "işıq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ліхтарык"),
            keywords: &["ліхтарык", "святло", "электрычнасць", "інструмент"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("фенерче"),
            keywords: &["електрическа", "инструмент", "светлина", "фенерче"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ফ\u{9cd}ল\u{9cd}য\u{9be}শ ল\u{9be}ইট"),
            keywords: &[
                "আলো",
                "ফ\u{9cd}ল\u{9cd}য\u{9be}শ ল\u{9be}ইট",
                "বৈদ\u{9cd}য\u{9c1}তিক",
                "মশ\u{9be}ল",
                "সরঞ\u{9cd}জ\u{9be}ম",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("etev-goulaouiñ"),
            keywords: &["etev-goulaouiñ", "tredan"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("baterijska lampa"),
            keywords: &["alat", "baterijska lampa", "elektrika", "lampa", "svjetlo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("llanterna"),
            keywords: &["eina", "electricitat", "llanterna", "llum"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄑\u{11128}𑄛\u{11134}𑄝\u{11128}𑄖\u{11134}\u{11128}"),
            keywords: &["𑄑\u{11128}𑄛\u{11134}𑄝\u{11128}𑄖\u{11134}\u{11128}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏍᏗ ᎠᏨᏍᏗ"),
            keywords: &["ᎠᎾᎦᎵᏍᎩ", "ᎠᏨᏍᏗ", "ᎤᏍᏗ ᎠᏨᏍᏗ", "ᎬᏔᏂᏓᏍᏗ", "ᏳᎳᏉ ᎠᏨᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("baterka"),
            keywords: &["baterka", "elektrický", "nářadí", "svítilna", "světlo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("tortsh"),
            keywords: &["golau", "offeryn", "tortsh", "trydanol"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("lommelygte"),
            keywords: &["lommelygte", "lygte"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Taschenlampe"),
            keywords: &["Lampe", "Licht", "Taschenlampe"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("φακός"),
            keywords: &["εργαλείο", "ηλεκτρικό", "φακός", "φως"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("flashlight"),
            keywords: &["electric", "flashlight", "light", "tool", "torch"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("torch"),
            keywords: &["electric", "light", "tool", "torch"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("flashlight"),
            keywords: &["electric", "flashlight", "light", "tool", "torch"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("linterna"),
            keywords: &["linterna", "luz"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["herramienta", "linterna", "luz"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("taskulamp"),
            keywords: &["elekter", "taskulamp", "tööriist", "valgus"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("linterna"),
            keywords: &["argi", "elektriko", "linterna", "tresna"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("چراغ\u{200c}قوه"),
            keywords: &["ابزار", "الکتریسیته", "نور", "چراغ\u{200c}قوه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("taskulamppu"),
            keywords: &["lamppu", "sähkö", "taskulamppu", "valo"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("flashlight"),
            keywords: &["de-kuryente", "flashlight", "ilaw", "tool", "torch"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("lummalykt"),
            keywords: &["ljós", "lummalykt", "lykt", "stavlykt"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("torche"),
            keywords: &["lumière", "torche"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("lampe de poche"),
            keywords: &["lampe de poche", "lumière"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("tóirse"),
            keywords: &["lampa leictreach", "tóirse"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("toirds dealain"),
            keywords: &[
                "dealanach",
                "inneal",
                "lòchran",
                "solas",
                "toirds",
                "toirds dealain",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("lanterna"),
            keywords: &["lanterna", "luz"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ફ\u{acd}લ\u{ac7}શલાઇટ"),
            keywords: &[
                "ઇલ\u{ac7}ક\u{acd}ટ\u{acd}રિક",
                "ટોર\u{acd}ચ",
                "પ\u{acd}રકાશ",
                "ફ\u{acd}લ\u{ac7}શલાઇટ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("tocila"),
            keywords: &["kayan aiki", "na lantarki", "tocila", "wuta"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פנס"),
            keywords: &["אור", "פנס"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("टॉर\u{94d}च"),
            keywords: &[
                "टॉर\u{94d}च",
                "प\u{94d}रकाश",
                "फ\u{93c}\u{94d}ल\u{948}शलाइट",
                "बिजली",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("ručna svjetiljka"),
            keywords: &["alat", "lampa", "ručna svjetiljka", "struja", "svjetlo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("zseblámpa"),
            keywords: &[
                "elektronikus",
                "elemlámpa",
                "fény",
                "világítás",
                "zseblámpa",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("գրպանի լապտեր"),
            keywords: &["գործիք", "գրպանի լապտեր", "էլեկտրական", "լապտեր", "լույս"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("lampu senter"),
            keywords: &["alat", "cahaya", "lampu senter", "listrik", "senter"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nchaọkụ"),
            keywords: &["latrikị", "nchaọkụ", "ngwaọrụ", "ọkụ", "ọkụ mpanaka"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("vasaljós"),
            keywords: &["ljós", "vasaljós"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("torcia"),
            keywords: &["pila", "torcia"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("懐中電灯"),
            keywords: &["ライト", "懐中電灯", "明かり"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("senter"),
            keywords: &["cahya", "elektrik", "lampu sorot", "pranti", "senter"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ფანარი"),
            keywords: &[
                "ელექტრო",
                "ინსტრუმენტი",
                "სინათლე",
                "ფანარი",
                "შუქი",
                "ხელსაწყო",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жарқыл жарығы"),
            keywords: &["алау", "жарқыл жарығы", "шам", "электрлік", "құрал"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("lommelygte"),
            keywords: &["lommelygte", "lygte"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ព\u{17b7}ល"),
            keywords: &[
                "ពន\u{17d2}ល\u{17ba}",
                "ព\u{17b7}ល",
                "ភ\u{17d2}លើង",
                "ភ\u{17d2}លើងព\u{17b7}ល",
                "អគ\u{17d2}គ\u{17b7}សន\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಫ\u{ccd}ಲ\u{ccd}ಯಾಶ\u{ccd}\u{200c} ಲೈಟ\u{ccd}"),
            keywords: &[
                "ಎಲ\u{cc6}ಕ\u{ccd}ಟ\u{ccd}ರ\u{cbf}ಕ\u{ccd}",
                "ಟಾರ\u{ccd}ಚ\u{ccd}",
                "ಫ\u{ccd}ಲ\u{ccd}ಯಾಶ\u{ccd}\u{200c} ಲೈಟ\u{ccd}",
                "ಬ\u{cc6}ಳಕು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("손전등"),
            keywords: &["손전등", "전등"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("फ\u{94d}ल\u{945}शलायट"),
            keywords: &[
                "टॉर\u{94d}च",
                "फ\u{94d}ल\u{945}शलायट",
                "लायट",
                "विद\u{94d}य\u{941}त",
                "साधन",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("колчырак"),
            keywords: &["жарык", "колчырак", "курал", "электр"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Täscheluucht"),
            keywords: &["Apparat", "Luucht", "Täsch", "Täscheluucht", "elektresch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໄຟສາຍ"),
            keywords: &["ເຄ\u{eb7}\u{ec8}ອງມ\u{eb7}", "ແສງ", "ໄຟຟ\u{ec9}າ", "ໄຟສາຍ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žibintuvėlis"),
            keywords: &["deglas", "elektra", "įrankis", "šviesa", "žibintuvėlis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kabatas lukturītis"),
            keywords: &["elektrība", "gaisma", "kabatas lukturītis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kōrama"),
            keywords: &["hiko", "kōrama", "mārama", "utauta"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("батериска ламба"),
            keywords: &["батериска ламба", "батерија", "светилка", "светло"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ടോർച\u{d4d}ച\u{d4d}"),
            keywords: &[
                "ഇലക\u{d4d}\u{200c}ട\u{d4d}രിക\u{d4d} ടോർച\u{d4d}ച\u{d4d}",
                "ടോർച\u{d4d}ച\u{d4d}",
                "പ\u{d4d}രക\u{d3e}ശം",
                "വെളിച\u{d4d}ചം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гар чийдэн"),
            keywords: &["багаж", "гар чийдэн", "гэрэл", "цахилгаан"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("विज\u{947}री"),
            keywords: &[
                "प\u{94d}रकाश",
                "मशाल",
                "विज\u{947}री",
                "विद\u{94d}य\u{941}त",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("lampu suluh"),
            keywords: &["alat", "cahaya", "elektrik", "lampu suluh"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("torċ"),
            keywords: &["dawl", "elettriku", "għodda", "torċ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဓာတ\u{103a}မ\u{102e}း"),
            keywords: &[
                "ဓာတ\u{103a}မ\u{102e}း",
                "လျ\u{103e}ပ\u{103a}စစ\u{103a}",
                "အလင\u{103a}းရောင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("lommelykt"),
            keywords: &["elektrisk", "lommelykt", "lykt", "lys"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("फ\u{94d}ल\u{94d}याश लाइट"),
            keywords: &[
                "उपकरण",
                "टर\u{94d}च",
                "फ\u{94d}ल\u{94d}याश लाइट",
                "बत\u{94d}ती",
                "विद\u{94d}य\u{941}तीय",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("zaklamp"),
            keywords: &["elektrisch", "lamp", "licht", "zaklamp", "zaklantaarn"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("lommelykt"),
            keywords: &["elektrisk", "lommelykt", "lykt", "lys"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଫ\u{b4d}ଲ\u{b3e}ଶ\u{b4d}\u{200c}ଲ\u{b3e}ଇଟ\u{b4d}\u{200c}"),
            keywords: &[
                "ଆଲୋକ",
                "ଇଲେକ\u{b4d}ଟ\u{b4d}ର\u{b3f}କ\u{b4d}",
                "ଟର\u{b4d}ଚ\u{b4d}ଚ",
                "ଫ\u{b4d}ଲ\u{b3e}ଶ\u{b4d}\u{200c}ଲ\u{b3e}ଇଟ\u{b4d}\u{200c}",
                "ଫ\u{b4d}ଲ\u{b3e}ସ\u{b4d}\u{200c}ଲ\u{b3e}ଇଟ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਫਲ\u{a48}ਸ\u{a3c}ਲਾਈਟ"),
            keywords: &[
                "ਔਜ\u{a3c}ਾਰ",
                "ਚਾਨਣ",
                "ਟਾਰਚ",
                "ਫਲ\u{a48}ਸਲਾਈਟ",
                "ਫਲ\u{a48}ਸ\u{a3c} ਲਾਈਟ",
                "ਫਲ\u{a48}ਸ\u{a3c}ਲਾਈਟ",
                "ਬਿਜਲੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ٹارچ"),
            keywords: &["اوزار", "بتی", "برقی", "ٹارچ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tọ\u{301}chlait"),
            keywords: &["Tul", "Tọch", "Tọ\u{301}chlait", "Ẹlẹ\u{301}ktrik"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("latarka"),
            keywords: &["elektryczna", "lampka", "latarka", "światło"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لاسي څراغ"),
            keywords: &["اله", "برېښنايي", "بيټري", "رڼا", "لاسي څراغ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("lanterna"),
            keywords: &["elétrica", "ferramenta", "lanterna", "luz"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["eletricidade", "lanterna", "luz", "utensílio"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("flash"),
            keywords: &["flash"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("lanternă"),
            keywords: &["baterie", "electric", "instrument", "lanternă", "lumină"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-738"),
            keywords: &["E10-738"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("фонарик"),
            keywords: &["свет", "фонарик", "фонарь", "электричество"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("itoroshi"),
            keywords: &["cy’amashanyarazi", "itara", "itoroshi", "urumuri"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("فليش لائيٽ"),
            keywords: &["اوزار", "برقي", "روشني", "فليش لائيٽ", "ٽارچ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ෆ\u{dca}ලෑෂ\u{dca}ලය\u{dd2}ට\u{dca}"),
            keywords: &[
                "ආලෝකය",
                "මෙවලම",
                "ව\u{dd2}ද\u{dd4}ල\u{dd2} පන\u{dca}දම",
                "ව\u{dd2}ද\u{dd4}ල\u{dd2}ය",
                "ෆ\u{dca}ලෑෂ\u{dca}ලය\u{dd2}ට\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("baterka"),
            keywords: &["baterka", "elektrické", "nástroj", "svetlo", "svietidlo"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("svetilka"),
            keywords: &["električno", "luč", "orodje", "svetilka"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("toosh"),
            keywords: &["dab", "iftiin", "qalab", "toosh"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("elektrik dore"),
            keywords: &["dritë", "elektrik", "elektrik dore", "fener", "vegël"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("батеријска лампа"),
            keywords: &["aлaт", "батеријска лампа", "лaмпa", "свeтлo", "струja"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["батеријска лампа"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("baterijska lampa"),
            keywords: &["alat", "baterijska lampa", "lampa", "struja", "svetlo"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["baterijska lampa"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ficklampa"),
            keywords: &["ficklampa", "lampa"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kurunzi"),
            keywords: &["kurunzi", "mwanga", "umeme", "zana"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ட\u{bbe}ர\u{bcd}ச\u{bcd} லைட\u{bcd}"),
            keywords: &[
                "ட\u{bbe}ர\u{bcd}ச\u{bcd}",
                "பிள\u{bbe}ஷ\u{bcd}",
                "லைட\u{bcd}",
                "விளக\u{bcd}கு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ట\u{c3e}ర\u{c4d}చ\u{c4d} ల\u{c48}ట\u{c4d}"),
            keywords: &[
                "ట\u{c3e}ర\u{c4d}చ\u{c4d} ల\u{c48}ట\u{c4d}",
                "ఫ\u{c4d}ల\u{c3e}ష\u{c4d} ల\u{c48}ట\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("фонус"),
            keywords: &["асбоб", "барқӣ", "машъал", "рӯшноӣ", "фонус"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ไฟฉาย"),
            keywords: &[
                "เคร\u{e37}\u{e48}องม\u{e37}อ",
                "แสง",
                "ไฟฉาย",
                "ไฟฟ\u{e49}า",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("fonar"),
            keywords: &["fakel", "fonar", "gural", "tok", "yşyk"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kasa"),
            keywords: &["kasa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("el feneri"),
            keywords: &["el feneri", "elektrik", "ışık"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قولچىراق"),
            keywords: &["توك", "قورال", "قولچىراق", "يورۇتۇش", "چىراق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("ліхтарик"),
            keywords: &["електричний", "ліхтарик", "світло", "інструмент"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("فلیش لائٹ"),
            keywords: &["برقی", "روشنی", "فلیش", "فلیش لائٹ", "ٹارچ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("fonar"),
            keywords: &["asbob", "chiroq", "elektr", "fonar", "mash’al"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đèn pin"),
            keywords: &["dụng cụ", "ánh sáng", "điện", "đèn pin"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("làmp-tors"),
            keywords: &["bu-kuuraŋ", "jumtukaay", "light", "làmp-tors"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isibane"),
            keywords: &["isibane", "isixhobo", "itotshi", "umbane"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("iná fílásì"),
            keywords: &[
                "iná",
                "iná fílásì",
                "iná mọ\u{300}nà-mó\u{329}ná",
                "irjṣé\u{329}",
                "tọ\u{301}ọ\u{301}ṣì",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("電筒"),
            keywords: &["工具", "燈", "電", "電筒"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("电筒"),
            keywords: &["工具", "灯", "电", "电筒"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("手电筒"),
            keywords: &["光", "工具", "手电", "手电筒", "照明", "电筒"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("手電筒"),
            keywords: &["手電筒"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("電筒"),
            keywords: &["燈", "電筒"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ithoshi"),
            keywords: &["ithoshi", "ithuluzi", "ugesi", "ukukhanya"],
        },
    ],
};
#[doc = "🏮"]
pub const RED_PAPER_LANTERN: crate::Emoji = crate::Emoji {
    glyph: "🏮",
    codepoint: "1F3EE",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "red paper lantern",
    group: "Objects",
    subgroup: "light & video",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("rooi papierlantern"),
            keywords: &[
                "japannees",
                "kroeg",
                "lantern",
                "lig",
                "rooi",
                "rooi papierlantern",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሬድ ፔፐር መብራት"),
            keywords: &["መብራት", "ሬድ ፔፐር መብራት", "ቀይ", "አሞሌ", "የጃፓን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}فانوس بورق أحمر"),
            keywords: &["إزاكايا", "فانوس", "مطعم", "\u{202b}فانوس بورق أحمر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ৰঙ\u{9be} ক\u{9be}গজৰ লণ\u{9cd}ঠন"),
            keywords: &[
                "পোহৰ",
                "ব\u{9be}ৰ",
                "লণ\u{9cd}ঠন",
                "ৰঙ\u{9be}",
                "ৰঙ\u{9be} ক\u{9be}গজৰ লণ\u{9cd}ঠন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qırmızı kağız fənər"),
            keywords: &[
                "bar",
                "fənər",
                "işıq",
                "qırmızı",
                "qırmızı kağız fənər",
                "yapon",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чырвоны папяровы ліхтар"),
            keywords: &[
                "святло",
                "чырвоны",
                "чырвоны папяровы ліхтар",
                "японскі",
                "ідзакая",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Червен хартиен фенер"),
            keywords: &["Червен хартиен фенер", "бар", "светлина", "фенер", "червен"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ল\u{9be}ল ক\u{9be}গজের লণ\u{9cd}ঠন"),
            keywords: &[
                "আলো",
                "জ\u{9be}প\u{9be}নি",
                "ব\u{9be}র",
                "লণ\u{9cd}ঠন",
                "ল\u{9be}ল",
                "ল\u{9be}ল ক\u{9be}গজের লণ\u{9cd}ঠন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("lampig ruz"),
            keywords: &["lampig ruz", "letern", "ruz", "tavarn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("crveni papirni fenjer"),
            keywords: &[
                "crveni papirni fenjer",
                "crveno",
                "kineska lampa",
                "svjetlo",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("fanal de paper vermell"),
            keywords: &["fanal", "fanal de paper vermell", "paper", "vermell"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎩᎦᎨ ᎪᏪᎳ ᎠᏨᏍᏗ"),
            keywords: &["ᎠᏨᏍᏗ", "ᎠᏨᏍᏗ ᎦᎪᏗ", "ᎦᎾᎸ", "ᎩᎦᎨ", "ᎩᎦᎨ ᎪᏪᎳ ᎠᏨᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("červený lampion"),
            keywords: &[
                "japonský",
                "lucerna",
                "světlo",
                "červená",
                "červený lampion",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("llusern bapur coch"),
            keywords: &["Japaneaidd", "bar", "coch", "llusern", "llusern bapur coch"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("papirlanterne"),
            keywords: &["lanterne", "papirlanterne", "rød lygte"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("rote Papierlaterne"),
            keywords: &["Izakaya", "japanisches Lokal", "rote Papierlaterne"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κόκκινο χάρτινο φανάρι"),
            keywords: &[
                "ιαπωνικό",
                "κόκκινο",
                "κόκκινο χάρτινο φανάρι",
                "φανάρι",
                "φως",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("red paper lantern"),
            keywords: &["bar", "lantern", "light", "red", "red paper lantern"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("lámpara japonesa"),
            keywords: &[
                "izakaya",
                "linterna izakaya",
                "linterna japonesa",
                "lámpara japonesa",
                "lámpara roja",
                "restaurante",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("farol de papel japonés"),
            keywords: &[
                "farol",
                "farol de papel japonés",
                "izakaya",
                "linterna",
                "papel",
                "restaurante",
                "roja",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "farol",
                "farol de papel japonés",
                "izakaya",
                "linterna",
                "papel",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("linterna de papel roja"),
            keywords: &[
                "izakaya",
                "linterna",
                "linterna de papel roja",
                "luz",
                "roja",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("punane paberlatern"),
            keywords: &["lamp", "latern", "punane", "punane paberlatern", "valgus"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("paper gorrizko faroltxoa"),
            keywords: &[
                "argi",
                "faroltxo",
                "gorri",
                "japonia",
                "paper gorrizko faroltxoa",
                "taberna",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("فانوس کاغذی قرمز"),
            keywords: &[
                "فانوس",
                "فانوس کاغذی قرمز",
                "قرمز",
                "میخانه",
                "می\u{200c}فروشی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("punainen paperilyhty"),
            keywords: &[
                "Japani",
                "baari",
                "lyhty",
                "punainen",
                "punainen paperilyhty",
                "valo",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pulang paper lantern"),
            keywords: &[
                "bar",
                "ilaw",
                "lantern",
                "pula",
                "pulang papel na lantern",
                "pulang paper lantern",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("reyð pappírlanterna"),
            keywords: &["lanterna", "ljós", "pappírlanterna", "reyð"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("lampion rouge"),
            keywords: &["japonais", "lampion rouge", "lanterne", "lumière", "rouge"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("lanterne d’izakaya"),
            keywords: &[
                "japonais",
                "lanterne",
                "lanterne d’izakaya",
                "lumière",
                "rouge",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("laindéar dearg"),
            keywords: &["dearg", "izakaya", "laindéar dearg", "laintéar"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("lanntair-pàipeir dearg"),
            keywords: &[
                "bàr",
                "dearg",
                "lanntair",
                "lanntair-pàipeir dearg",
                "solas",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("lanterna de papel vermella"),
            keywords: &[
                "lanterna",
                "lanterna de papel vermella",
                "luz",
                "vermella",
                "xaponesa",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લાલ ફાનસ"),
            keywords: &[
                "ઇઝાક\u{acd}યા",
                "ફાનસ",
                "બાર",
                "ર\u{ac7}સ\u{acd}ટોરન\u{acd}ટ",
                "લાલ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("jan fitilan takarda"),
            keywords: &["fitila", "ja", "jan fitilan takarda", "sanda", "wuta"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פנס נייר אדום"),
            keywords: &["אדום", "נייר", "סיני", "פנס"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("लाल काग\u{93c}ज\u{93c}ी लालट\u{947}न"),
            keywords: &[
                "क\u{902}दील",
                "लाल",
                "लाल काग\u{93c}ज\u{93c}ी लालट\u{947}न",
                "लाल लालट\u{947}न",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("crveni lampion"),
            keywords: &[
                "bar",
                "crveni lampion",
                "crveni papirnati lampion",
                "crveno",
                "lampion",
                "svjetlo",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("piros papírlámpa"),
            keywords: &["bár", "japán", "lámpa", "piros", "piros papírlámpa"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("թղթե կարմիր լապտեր"),
            keywords: &[
                "բար",
                "թղթե կարմիր լապտեր",
                "լապտեր",
                "լույս",
                "կարմիր",
                "ճապոնական",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("lampion merah"),
            keywords: &["bar", "cahaya", "lampion merah", "lentera", "merah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("mpanaka akwụkwọ ọbara"),
            keywords: &["mpanaka", "mpanaka akwụkwọ ọbara", "ogwe", "ọbara", "ọkụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("rauður lampi"),
            keywords: &["bar", "izakaya", "lampi", "rauður", "veitingastaður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("lanterna rossa"),
            keywords: &[
                "izakaya",
                "lanterna",
                "lanterna giapponese",
                "lanterna rossa",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("赤ちょうちん"),
            keywords: &["ちょうちん", "居酒屋", "赤ちょうちん", "飲み屋"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("lampion kertas abang"),
            keywords: &["abang", "bar", "cahya", "lampion", "lampion kertas abang"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქაღალდის წითელი ფარანი"),
            keywords: &[
                "ბარი",
                "იაპონური",
                "სინათლე",
                "ფარანი",
                "ქაღალდის წითელი ფარანი",
                "შუქი",
                "წითელი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қағаздан жасалған қызыл шам"),
            keywords: &[
                "тақта",
                "шам",
                "қағаз шам",
                "қағаздан жасалған қызыл шам",
                "қызыл",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("lygte"),
            keywords: &["lanterne", "lygte", "rød lygte"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("គោមពណ\u{17cc}ក\u{17d2}រហម"),
            keywords: &["គោម", "គោមពណ\u{17cc}ក\u{17d2}រហម"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{cc6}ಂಪು ಪೇಪರ\u{ccd} ಲಾಟೀನು"),
            keywords: &[
                "ಇಝಾಕ\u{cbf}ಯಾ",
                "ಕ\u{cc6}ಂಪು",
                "ಕ\u{cc6}ಂಪು ಪೇಪರ\u{ccd} ಲಾಟೀನು",
                "ಬಾರ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("일본식 등"),
            keywords: &["선술집", "이자카야", "일본식 등", "일본식 선술집", "홍등"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ता\u{902}बड\u{94d}या प\u{947}पराचो क\u{902}दील"),
            keywords: &[
                "उजवाड",
                "क\u{902}दील",
                "ता\u{902}बडो",
                "ता\u{902}बड\u{94d}या प\u{947}पराचो क\u{902}दील",
                "बार",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кызыл кагаздан жасалган лампа"),
            keywords: &[
                "жапончо",
                "жарык",
                "кызыл",
                "кызыл кагаздан жасалган лампа",
                "лампа",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("roude Lampion"),
            keywords: &[
                "Bar",
                "Lampion",
                "Lanter",
                "Luucht",
                "roude Lampion",
                "rout",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໂຄມໄຟເຈ\u{ec9}ຍສ\u{eb5}ແດງ"),
            keywords: &["ສ\u{eb5}ແດງ", "ແສງ", "ໂຄມໄຟ", "ໂຄມໄຟເຈ\u{ec9}ຍສ\u{eb5}ແດງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("raudonas popierinis žibintas"),
            keywords: &[
                "baras",
                "raudonas",
                "raudonas popierinis žibintas",
                "šviesa",
                "žibintas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sarkana papīra laterna"),
            keywords: &[
                "bārs",
                "japāņu",
                "laterna",
                "papīrs",
                "sarkana papīra laterna",
                "sarkans",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rātana pepa whero"),
            keywords: &["mārama", "pae", "rama", "rātana pepa whero", "whero"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("црвен фенер"),
            keywords: &["светло", "фенер", "црвен", "јапонски"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("റ\u{d3e}ന\u{d4d}തൽ വിളക\u{d4d}ക\u{d4d}"),
            keywords: &[
                "ഇസകയ",
                "ച\u{d41}വന\u{d4d}ന റ\u{d3e}ന\u{d4d}തൽ",
                "റ\u{d3e}ന\u{d4d}തൽ വിളക\u{d4d}ക\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("улаан цаасан дэнлүү"),
            keywords: &["дэнлүү", "улаан цаасан дэнлүү", "цаас", "цаасан дэнлүү"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("लाल कागदाचा क\u{902}दील"),
            keywords: &[
                "इजाकाया",
                "क\u{902}दील",
                "बार",
                "र\u{947}स\u{94d}टॉर\u{902}ट",
                "लाल",
                "लाल कागदाचा क\u{902}दील",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tanglung kertas merah"),
            keywords: &[
                "bar",
                "cahaya",
                "merah",
                "tanglung",
                "tanglung kertas merah",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("lanterna tal-karti ħamra"),
            keywords: &[
                "aħmar",
                "bar",
                "dawl",
                "lanterna",
                "lanterna tal-karti ħamra",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စက\u{1039}က\u{1030}မ\u{102e}းအ\u{102d}မ\u{103a} အန\u{102e}"),
            keywords: &[
                "စက\u{1039}က\u{1030}မ\u{102e}းအ\u{102d}မ\u{103a} အန\u{102e}",
                "ဘား",
                "လက\u{103a}စ\u{103d}\u{1032}မ\u{102e}းအ\u{102d}မ\u{103a}",
                "အန\u{102e}ရောင\u{103a}",
                "အလင\u{103a}းရောင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("rød papirlykt"),
            keywords: &[
                "bar",
                "izakaya",
                "lampe",
                "lanterne",
                "lykt",
                "rød",
                "rød papirlykt",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("रातो पानाको लालटिन"),
            keywords: &[
                "प\u{94d}रकाश",
                "बार",
                "रातो",
                "रातो पानाको लालटिन",
                "लालटिन",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("rode papieren lantaarn"),
            keywords: &["bar", "lantaarn", "licht", "rode papieren lantaarn", "rood"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("raud papirlykt"),
            keywords: &[
                "bar",
                "izakaya",
                "lampe",
                "lanterne",
                "lykt",
                "raud",
                "raud papirlykt",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଲ\u{b3e}ଲ\u{b4d}\u{200c} କ\u{b3e}ଗଜ ଲଣ\u{b4d}ଠନ"),
            keywords: &[
                "ବ\u{b3e}ର\u{b4d}\u{200c}",
                "ରେଷ\u{b4d}ଟ\u{b41}ର\u{b3e}ଣ\u{b4d}ଟ",
                "ଲଣ\u{b4d}ଠନ",
                "ଲ\u{b3e}ଲ\u{b4d}\u{200c}",
                "ଲ\u{b3e}ଲ\u{b4d}\u{200c} କ\u{b3e}ଗଜ ଲଣ\u{b4d}ଠନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲਾਲ ਕਾਗਜ\u{a3c} ਵਾਲੀ ਲਾਲਟ\u{a47}ਨ"),
            keywords: &[
                "ਜਾਪਾਨੀ",
                "ਬਾਰ",
                "ਲਾਲ ਕਾਗਜ\u{a3c} ਵਾਲੀ ਲਾਲਟ\u{a47}ਨ",
                "ਲਾਲ ਬ\u{a71}ਤੀ",
                "ਲਾਲਟ\u{a47}ਨ",
                "ਹ\u{a4b}ਟਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("لال کاغذی لالٹین"),
            keywords: &["بتی", "سیخ", "لال", "لال کاغذی لالٹین", "لالٹین"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Rẹ\u{301}d Pépá Lamp"),
            keywords: &["Baa", "Lait", "Lamp", "Rẹd", "Rẹ\u{301}d Pépá Lamp"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("czerwony lampion"),
            keywords: &["bar izakaya", "czerwony lampion", "izakaya"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د سور کاغذ لاټين"),
            keywords: &["بار", "د سور کاغذ لاټين", "رڼا", "سور", "لاټين"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("lanterna vermelha de papel"),
            keywords: &[
                "bar",
                "izakaya",
                "lanterna",
                "lanterna de papel",
                "lanterna vermelha de papel",
                "vermelha",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("lanterna de papel vermelha"),
            keywords: &[
                "bar",
                "japonês",
                "lanterna",
                "lanterna de papel vermelha",
                "luz",
                "vermelha",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("izakaya linterna"),
            keywords: &["izakaya linterna"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("felinar din hârtie roșie"),
            keywords: &[
                "Japonia",
                "felinar",
                "felinar din hârtie roșie",
                "hârtie",
                "lumină",
                "roșu",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-430"),
            keywords: &["E10-430"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("красный бумажный фонарик"),
            keywords: &[
                "бумажный фонарик",
                "китайский фонарик",
                "красный бумажный фонарик",
                "красный фонарик",
                "фонарик",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("itara ry’umutuku"),
            keywords: &[
                "itara",
                "itara ry’umutuku",
                "itoroshi",
                "umurongo",
                "urumuri",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڳاڙهي ڪاغذ واري لينٽرن"),
            keywords: &["بار", "روشني", "لالٽين", "ڳاڙهو", "ڳاڙهي ڪاغذ واري لينٽرن"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("රත\u{dd4} කඩද\u{dcf}ස\u{dd2} පහන"),
            keywords: &[
                "ආලෝකය",
                "ජපන\u{dca}",
                "බ\u{dcf}ර\u{dca}",
                "රත\u{dd4}",
                "රත\u{dd4} කඩද\u{dcf}ස\u{dd2} පහන",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("červený lampión"),
            keywords: &[
                "bar",
                "japonský",
                "lampión",
                "svetlo",
                "červené",
                "červený lampión",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("rdeči lampijon"),
            keywords: &[
                "bar",
                "japonsko",
                "lampijon",
                "luč",
                "rdeče",
                "rdeči lampijon",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("siraad warqad cas"),
            keywords: &["casaan", "fidsan", "iftiin", "siraad", "siraad warqad cas"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fener me letër të kuqe"),
            keywords: &["dritë", "fener me letër të kuqe", "i kuq", "japoneze"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лампион од црвеног папира"),
            keywords: &[
                "бар",
                "лампион",
                "лампион од црвеног папира",
                "светло",
                "црвена",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["лампион од црвеног папира"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lampion od crvenog papira"),
            keywords: &[
                "bar",
                "crvena",
                "lampion",
                "lampion od crvenog papira",
                "svetlo",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["lampion od crvenog papira"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("röd papperslykta"),
            keywords: &["lykta", "restaurang", "röd lykta", "röd papperslykta"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("taa nyekundu ya karatasi"),
            keywords: &[
                "baa",
                "kijapani",
                "mwanga",
                "nyekundu",
                "taa",
                "taa nyekundu ya karatasi",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சிவப\u{bcd}பு நிற விளக\u{bcd}கு"),
            keywords: &[
                "க\u{bbe}கித விளக\u{bcd}கு",
                "சிகப\u{bcd}பு விளக\u{bcd}கு",
                "சிவப\u{bcd}பு நிற விளக\u{bcd}கு",
                "சிவப\u{bcd}பு விளக\u{bcd}கு",
                "ப\u{bbe}ர\u{bcd}",
                "விளக\u{bcd}கு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఎరుపు ల\u{c3e}ంతరు"),
            keywords: &[
                "ఎరుపు రంగు",
                "ఎరుపు ల\u{c3e}ంతరు",
                "జపన\u{c40}స\u{c4d} బ\u{c3e}ర\u{c4d} గుర\u{c4d}తు",
                "జపన\u{c40}స\u{c4d} ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d} గుర\u{c4d}తు",
                "ల\u{c3e}ంతరు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("чароғ аз қозаи сурх"),
            keywords: &["бар", "рӯшноӣ", "сурх", "чароғ", "чароғ аз қозаи сурх"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("โคมไฟแดง"),
            keywords: &["บาร\u{e4c}", "ส\u{e35}แดง", "แสงไฟ", "โคมไฟ", "โคมไฟแดง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gyzyl hytaý fonarjygy"),
            keywords: &["fonar", "gyzyl", "gyzyl hytaý fonarjygy", "taýak", "yşyk"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("maama matangi kulokula"),
            keywords: &["maama matangi kulokula"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kırmızı kağıt fener"),
            keywords: &[
                "bar",
                "fener",
                "izakaya",
                "kırmızı",
                "kırmızı kağıt fener",
                "restoran",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قىزىل پانۇس"),
            keywords: &["قاۋاق", "قىزىل", "پانۇس", "چىراق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("червоний паперовий ліхтар"),
            keywords: &[
                "бар",
                "ліхтар",
                "ліхтар ізакайа",
                "світло",
                "червоний",
                "червоний паперовий ліхтар",
                "японський",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سرخ کاغذی لالٹین"),
            keywords: &[
                "بار",
                "روشنی",
                "سرخ",
                "سرخ مرچ",
                "سرخ کاغذی لالٹین",
                "لالٹین",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qizil qog‘ozli lampa"),
            keywords: &[
                "bar",
                "lampa",
                "qizil",
                "qizil qog‘ozli lampa",
                "yapon",
                "yorug‘lik",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đèn lồng giấy màu đỏ"),
            keywords: &["quán bar", "đèn", "đèn lồng", "đèn lồng giấy màu đỏ", "đỏ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("làntern bu xonk"),
            keywords: &["laat", "làmp", "làntern", "làntern bu xonk", "xonk"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isibane sephepha elibomvu"),
            keywords: &["bomvu", "ibhari", "isibane", "isibane sephepha elibomvu"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("atupa iwe pupa"),
            keywords: &["atupa iwe pupa", "iná", "pupa", "àtùpà", "ìdènà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("紅色紙燈籠"),
            keywords: &["燈", "燈籠", "紅色", "紅色紙燈籠", "長條"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("红色纸灯笼"),
            keywords: &["灯", "灯笼", "红色", "红色纸灯笼", "长条"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("红灯笼"),
            keywords: &["光", "喜庆", "灯笼", "红灯笼", "节日"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("燈籠"),
            keywords: &["居酒屋", "燈籠"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["居酒屋｜燈籠", "燈", "燈籠", "紙燈籠"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ilambu elibomvu"),
            keywords: &[
                "ibha",
                "ilambu",
                "ilambu elibomvu",
                "japanese",
                "okubomvu",
                "ukukhanya",
            ],
        },
    ],
};
#[doc = "🪔"]
pub const DIYA_LAMP: crate::Emoji = crate::Emoji {
    glyph: "🪔",
    codepoint: "1FA94",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "diya lamp",
    group: "Objects",
    subgroup: "light & video",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("Indiese olielamp"),
            keywords: &["Indies", "Indiese olielamp", "diya", "olielamp"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ኩራዝ"),
            keywords: &["መብራት", "ኩራዝ", "ዘይት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مصباح ضياء"),
            keywords: &["إضاءة", "زيت", "مصباح", "مصباح ضياء"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বন\u{9cd}তি"),
            keywords: &["চ\u{9be}কি", "তেল", "বন\u{9cd}তি"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yağ lampası"),
            keywords: &["lampa", "yağ", "yağ lampası"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("лямпа дыя"),
            keywords: &["алейная", "дыя", "каганец", "лямпа"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("маслена лампа"),
            keywords: &["дия", "лампа", "маслена лампа", "масло"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9cd}রদীপ"),
            keywords: &["তেল", "প\u{9cd}রদীপ", "ব\u{9be}তি"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("diya"),
            keywords: &["diya", "eoul", "lamp"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("diya lampa"),
            keywords: &["diya", "lampa", "ulje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("llum d’oli"),
            keywords: &["ble", "llum", "llum d’oli", "llàntia", "làmpada", "oli"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᏯ ᎠᏨᏍᏗ"),
            keywords: &["ᎠᏨᏍᏗ", "ᎪᎢ", "ᏗᏯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("indická olejová lampa"),
            keywords: &["diya", "indická olejová lampa", "lampa", "olej"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("lamp diya"),
            keywords: &["diya", "lamp", "olew"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("diya-lampe"),
            keywords: &["diya", "diya-lampe", "lampe", "olielampe"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Öllampe"),
            keywords: &["Diya", "Lampe", "Öl", "Öllampe"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("λάμπα diya"),
            keywords: &["diya", "λάδι", "λάμπα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("diya lamp"),
            keywords: &["diya", "lamp", "oil"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("lámpara de aceite"),
            keywords: &["aceite", "diya", "lámpara", "lámpara de aceite"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("diya-lamp"),
            keywords: &["diya", "diya-lamp", "lamp", "õli"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("diya lanpara"),
            keywords: &["diya", "lanpara", "olio"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("چراغ دایا"),
            keywords: &["دایا", "روغن", "چراغ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("savilamppu"),
            keywords: &["diya", "lamppu", "savilamppu", "öljy", "öljylamppu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lamparang diya"),
            keywords: &["diya", "lampara", "lamparang diya", "langis"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("diyalampa"),
            keywords: &["diya", "diyalampa", "lampa", "olja"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("diya"),
            keywords: &["Diwali", "diya", "huile", "lampe", "lampe à beurre", "ārtī"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("lampa diya"),
            keywords: &["diya", "lampa", "ola"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("lampa-eòlain"),
            keywords: &["diya", "lampa", "lampa-eòlain", "ola"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("lámpada de aceite"),
            keywords: &["diya", "hinduísmo", "lámpada de aceite", "zoroastrismo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("દિવો"),
            keywords: &["ત\u{ac7}લ", "દિવડો", "દિવો"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מנורת דייה"),
            keywords: &["דייה", "הודו", "מנורה", "מנורת דייה", "מנורת שמן"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("दीपक"),
            keywords: &["दिया", "दीपक", "प\u{94d}रदीप", "बाती"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("diya lampa"),
            keywords: &["diya", "lampa", "ulje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("olajlámpa"),
            keywords: &["diya", "lámpa", "olaj", "olajlámpa"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("դիյա լամպ"),
            keywords: &["դիյա", "լամպ", "յուղ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("lampu diya"),
            keywords: &["diya", "lampu", "lentera", "minyak"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("diya-lampi"),
            keywords: &["diya", "diya-lampi", "lampi", "olía", "olíulampi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("diya"),
            keywords: &[
                "deepak",
                "deepam",
                "divaa",
                "diya",
                "lampada a olio tradizionale",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ディヤランプ"),
            keywords: &["オイル", "ディヤランプ", "ランプ", "明かり"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("lampu diyan"),
            keywords: &["diyan", "lampu", "minyak"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ნავთის ლამპა"),
            keywords: &["დია", "ლამპა", "ნავთი", "ნავთის ლამპა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("дия"),
            keywords: &["дия", "май", "шам"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ចង\u{17d2}កៀងឌ\u{17b8}យ\u{17c9}ា"),
            keywords: &[
                "ចង\u{17d2}កៀង",
                "ចង\u{17d2}កៀងឌ\u{17b8}យ\u{17c9}ា",
                "ឌ\u{17b8}យ\u{17c9}ា",
                "ប\u{17d2}រេង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಣ\u{ccd}ಣ\u{cbf}ನ ಹಣತ\u{cc6}"),
            keywords: &["ಎಣ\u{ccd}ಣ\u{cc6}", "ದೀಪ", "ಮಣ\u{ccd}ಣ\u{cbf}ನ ಹಣತ\u{cc6}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("기름 램프"),
            keywords: &["기름", "디야", "램프"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दिया दिवो"),
            keywords: &["त\u{947}ल", "दिया", "दिवो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("дия май чырагы"),
            keywords: &["дия", "дия май чырагы", "лампа", "май"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຕະ\u{200b}ກຽງດ\u{eb4}\u{200b}ຢາ"),
            keywords: &[
                "ດ\u{eb4}\u{200b}ຢາ",
                "ຕະ\u{200b}ກຽງ",
                "ຕະ\u{200b}ກຽງດ\u{eb4}\u{200b}ຢາ",
                "ນ\u{ec9}ຳ\u{200b}ມ\u{eb1}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žibalinė lempa"),
            keywords: &["lempa", "žibalas", "žibalinė lempa", "žvakė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("eļļas lampa"),
            keywords: &["eļļa", "eļļas lampa", "lampa"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("ламба дија"),
            keywords: &["дија", "ламба", "масло"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ദിയ\u{d3e} വിളക\u{d4d}ക\u{d4d}"),
            keywords: &["എണ\u{d4d}ണ", "ദിയ\u{d3e}", "വിളക\u{d4d}ക\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("тосон дэн"),
            keywords: &["дэнлүү", "тос", "тосон дэн"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पणती"),
            keywords: &["त\u{947}ल", "दिवा", "पणती"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("lampu diya"),
            keywords: &["diya", "lampu", "minyak"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဆ\u{102e}မ\u{102e}းခ\u{103d}က\u{103a}"),
            keywords: &[
                "ဆ\u{102e}",
                "ဆ\u{102e}မ\u{102e}းခ\u{103d}က\u{103a}",
                "မ\u{102e}းခ\u{103d}က\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("åpen oljelampe"),
            keywords: &["diya", "lampe", "olje", "åpen oljelampe"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("दियो बत\u{94d}ती"),
            keywords: &[
                "त\u{947}ल",
                "दियो",
                "दियो बत\u{94d}ती",
                "ल\u{94d}याम\u{94d}प",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("diya-lamp"),
            keywords: &["diya", "diya-lamp", "lamp", "olie"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("open oljelampe"),
            keywords: &["diya", "lampe", "olje", "open oljelampe"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଦୀପ ଲ\u{b4d}ୟ\u{b3e}ମ\u{b4d}ପ"),
            keywords: &["ତେଲ", "ଦୀପ", "ଲ\u{b4d}ୟ\u{b3e}ମ\u{b4d}ପ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਦੀਵਾ"),
            keywords: &["ਤ\u{a47}ਲ ਦਾ ਦੀਵਾ", "ਦੀਵਾ", "ਲ\u{a48}\u{a02}ਪ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Díya Ọ\u{301}yil Lamp"),
            keywords: &["Díya", "Lamp", "Ọ\u{301}yil"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("dipa"),
            keywords: &["dipa", "lampka", "oliwna"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ډيوه څراغ"),
            keywords: &["تيل", "څراغ", "ډيوه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("lâmpada de óleo"),
            keywords: &["diya", "lâmpada", "lâmpada de óleo", "óleo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("lâmpada diya"),
            keywords: &["diya", "lâmpada", "óleo"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("lampă diya"),
            keywords: &["diya", "lampă", "ulei"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–073"),
            keywords: &["E12–073"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("масляная лампа"),
            keywords: &["гореть", "дия", "лампа", "масло", "масляная лампа", "свет"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڏيو بتي"),
            keywords: &["بتي", "تيل", "ڏيو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ද\u{dd2}ය\u{dcf} ල\u{dcf}ම\u{dca}ප\u{dd4}ව"),
            keywords: &[
                "තෙල\u{dca}",
                "ද\u{dd2}ය\u{dcf}",
                "ල\u{dcf}ම\u{dca}ප\u{dd4}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("dija"),
            keywords: &["dija", "indická", "lampa", "olej"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("oljna lučka"),
            keywords: &["dyja", "lučka", "olje", "oljna lučka", "svetilka"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("feynuusta diya"),
            keywords: &["diya", "feynuus", "feynuusta diya", "saliid"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("llambë me vaj"),
            keywords: &["kandil indian", "llambë", "llambë me vaj", "vaj"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("уљана лампа"),
            keywords: &["лампа", "уљана", "уље"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("uljana lampa"),
            keywords: &["lampa", "uljana", "ulje"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("diyalampa"),
            keywords: &["diya", "diyalampa", "lampa", "oljelampa"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("taa ya diya"),
            keywords: &["diya", "mafuta", "taa", "taa ya diya"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அகல\u{bcd} விளக\u{bcd}கு"),
            keywords: &["அகல\u{bcd}", "எண\u{bcd}ணெய\u{bcd}", "விளக\u{bcd}கு"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ద\u{c3f}య\u{c3e} ద\u{c40}పం"),
            keywords: &["ద\u{c3f}య\u{c3e}", "ద\u{c40}పం", "నూన\u{c46}"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ตะเก\u{e35}ยงด\u{e34}ยา"),
            keywords: &[
                "ด\u{e34}ยา",
                "ตะเก\u{e35}ยง",
                "ตะเก\u{e35}ยงด\u{e34}ยา",
                "น\u{e49}ำม\u{e31}น",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("diýa çyrasy"),
            keywords: &["diýa", "diýa çyrasy", "çyra", "ýag"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("maama tia"),
            keywords: &["maama tia"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("diya lamba"),
            keywords: &["diya", "lamba", "yağ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("каганець"),
            keywords: &[
                "блимавка",
                "каганець",
                "лампа",
                "лампадка",
                "мигунець",
                "олійна",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("دیا لیمپ"),
            keywords: &["تیل", "د\u{650}یا", "دیا لیمپ", "لیمپ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("moychiroq"),
            keywords: &["chiroq", "diya", "moy", "moychiroq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đèn diya"),
            keywords: &["diya", "dầu", "đèn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("迪亞燈"),
            keywords: &["油", "燈", "迪亞", "迪亞燈"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("迪亚灯"),
            keywords: &["油", "灯", "迪亚", "迪亚灯"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("印度油灯"),
            keywords: &["印度油灯", "排灯节", "油", "灯", "迪亚"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("陶碗油燈"),
            keywords: &["油", "燈", "陶碗", "陶碗油燈"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isibani se-diya"),
            keywords: &["i-diya", "isibani", "isibani se-diya", "uwoyela"],
        },
    ],
};
