#[doc = "🚪"]
pub const DOOR: crate::Emoji = crate::Emoji {
    glyph: "🚪",
    codepoint: "1F6AA",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "door",
    group: "Objects",
    subgroup: "household",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("deur"),
            keywords: &["deur", "kosyn"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("በር"),
            keywords: &["በር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("باب"),
            keywords: &["باب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("দ\u{9c1}ৱ\u{9be}ৰ"),
            keywords: &["দ\u{9c1}ৱ\u{9be}ৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qapı"),
            keywords: &["qapı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("дзверы"),
            keywords: &["дзверы"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("врата"),
            keywords: &["врата"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("দরজ\u{9be}"),
            keywords: &["দরজ\u{9be}"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("dor"),
            keywords: &["dor"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("vrata"),
            keywords: &["vrata"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("porta"),
            keywords: &["porta"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏍᏚᏗ"),
            keywords: &["ᏍᏚᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("dveře"),
            keywords: &["dveře"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("drws"),
            keywords: &["drws"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("dør"),
            keywords: &["dør", "lukket dør"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Tür"),
            keywords: &["Eingang", "Tür", "geschlossen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πόρτα"),
            keywords: &["πόρτα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("door"),
            keywords: &["door"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("puerta"),
            keywords: &["puerta"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("uks"),
            keywords: &["uks"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("atea"),
            keywords: &["ate", "atea"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("در"),
            keywords: &["در", "درب", "راهرو"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ovi"),
            keywords: &["ovi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pinto"),
            keywords: &["pinto", "pintuan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hurð"),
            keywords: &["hurð"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("porte"),
            keywords: &["porte"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("doras"),
            keywords: &["doras"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("doras"),
            keywords: &["doras"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("porta"),
            keywords: &["porta"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("દરવાજો"),
            keywords: &["દરવાજો"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ƙofa"),
            keywords: &["ƙofa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("דלת"),
            keywords: &["דלת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("दरवाज\u{93c}ा"),
            keywords: &["दरवाज\u{93c}ा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("vrata"),
            keywords: &["vrata"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("ajtó"),
            keywords: &["ajtó"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("դուռ"),
            keywords: &["դուռ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pintu"),
            keywords: &["pintu"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụzọ"),
            keywords: &["ụzọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("dyr"),
            keywords: &["dyr", "hurð"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("porta"),
            keywords: &["porta"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ドア"),
            keywords: &["ドア", "戸", "扉"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("lawang"),
            keywords: &["lawang"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კარი"),
            keywords: &["კარი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tabburt"),
            keywords: &["tabburt"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("есік"),
            keywords: &["есік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("dør"),
            keywords: &["dør", "åben dør"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ទ\u{17d2}វារ"),
            keywords: &["ទ\u{17d2}វារ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬಾಗ\u{cbf}ಲು"),
            keywords: &["ಬಾಗ\u{cbf}ಲು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("문"),
            keywords: &["도어", "문"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दार"),
            keywords: &["दार"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("эшик"),
            keywords: &["каалга", "эшик"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Dier"),
            keywords: &["Dier"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປະຕ\u{eb9}"),
            keywords: &["ປະຕ\u{eb9}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("durys"),
            keywords: &["durys"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("durvis"),
            keywords: &["durvis", "ieeja", "izeja"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kūwaha"),
            keywords: &["kūwaha"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("врата"),
            keywords: &["врата"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വ\u{d3e}തിൽ"),
            keywords: &["വ\u{d3e}തിൽ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хаалга"),
            keywords: &["хаалга"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("दरवाजा"),
            keywords: &["दरवाजा"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pintu"),
            keywords: &["pintu"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("bieb"),
            keywords: &["bieb"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တ\u{1036}ခါး"),
            keywords: &["တ\u{1036}ခါး"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("dør"),
            keywords: &["dør"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ढोका"),
            keywords: &["ढोका"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("deur"),
            keywords: &["deur"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("dør"),
            keywords: &["dør"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କବ\u{b3e}ଟ"),
            keywords: &["କବ\u{b3e}ଟ", "ଦ\u{b4d}ଵ\u{b3e}ର"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਦਰਵਾਜ\u{a3c}ਾ"),
            keywords: &["ਦਰਵਾਜ\u{a3c}ਾ", "ਦਰਵਾਜਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بوا"),
            keywords: &["بوا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Dọọ"),
            keywords: &["Dọọ"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("drzwi"),
            keywords: &["drzwi"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("دروازه"),
            keywords: &["دروازه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("porta"),
            keywords: &["porta"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ușă"),
            keywords: &["ușă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-958"),
            keywords: &["E10-958"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("дверь"),
            keywords: &[
                "вход",
                "входная",
                "выход",
                "двери",
                "дверь",
                "закрытая",
                "проем",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("urugi"),
            keywords: &["urugi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("دروازو"),
            keywords: &["دروازو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("දොර"),
            keywords: &["දොර"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("dvere"),
            keywords: &["dvere"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vrata"),
            keywords: &["vrata"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("albaab"),
            keywords: &["albaab"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("derë"),
            keywords: &["derë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("врата"),
            keywords: &["врата"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["врата"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("vrata"),
            keywords: &["vrata"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["vrata"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("dörr"),
            keywords: &["dörr"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mlango"),
            keywords: &["mlango"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கதவு"),
            keywords: &["கதவு", "மரப\u{bcd}பொருள\u{bcd}", "முடிந\u{bcd}தது"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("తలుపు"),
            keywords: &["తలుపు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дар"),
            keywords: &["дар"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ประต\u{e39}"),
            keywords: &["ประต\u{e39}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gapy"),
            keywords: &["gapy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("matapā"),
            keywords: &["matapā"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kapı"),
            keywords: &["kapı"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئىشىك"),
            keywords: &["ئىشىك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("двері"),
            keywords: &["двері"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("دروازہ"),
            keywords: &["دروازہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("eshik"),
            keywords: &["eshik"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cửa"),
            keywords: &["cửa"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("buntu"),
            keywords: &["buntu"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ucango"),
            keywords: &["ucango"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ìlẹ\u{300}kùn"),
            keywords: &["Ìlẹ\u{300}kùn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("門"),
            keywords: &["門"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("门"),
            keywords: &["门"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("门"),
            keywords: &["出入口", "大门", "屋门", "房门", "房间", "门"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("門"),
            keywords: &["門"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isicabha"),
            keywords: &["isicabha"],
        },
    ],
};
#[doc = "🛗"]
pub const ELEVATOR: crate::Emoji = crate::Emoji {
    glyph: "🛗",
    codepoint: "1F6D7",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "elevator",
    group: "Objects",
    subgroup: "household",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("hysbak"),
            keywords: &["hys", "hysbak", "lig", "toeganklikheid"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አሳንሱር"),
            keywords: &["አሳንሱር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مصعد"),
            keywords: &["إمكانية الوصول", "رافع", "مصعد"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("এলিভেটৰ"),
            keywords: &[
                "এলিভেটৰ",
                "প\u{9cd}ৰৱেশযোগ\u{9cd}যত\u{9be}",
                "লিফ\u{9cd}ট",
                "হইষ\u{9cd}ট",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("lift"),
            keywords: &["lift", "qaldırmaq", "qaldırıcı", "əlverişlilik"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ліфт"),
            keywords: &["даступнасць", "ліфт", "пад’ёмнік"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("асансьор"),
            keywords: &["асансьор", "достъпност", "издигане", "лифт"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("এলিভেটর"),
            keywords: &[
                "অ\u{9cd}য\u{9be}কসেসিবিলিটি",
                "এলিভেটর",
                "লিফ\u{9cd}ট",
                "হয\u{9bc}েস\u{9cd}ট",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pignerez"),
            keywords: &["pignerez", "saverez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("lift"),
            keywords: &["dizanje", "elevator", "lift", "pomagalo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("ascensor"),
            keywords: &["accessibilitat", "ascensor", "muntacàrregues"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏓᏌᎳᏗᏍᎩ"),
            keywords: &["ᎠᏌᎳᏗᎠ", "ᎠᏌᎳᏙᏗ", "ᎠᏓᏌᎳᏗᏍᎩ", "ᎬᏴᏍᏗ ᎨᏒᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("výtah"),
            keywords: &["přístup", "usnadnění", "výtah", "zdviž"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("lifft"),
            keywords: &["hosiad", "hygyrchedd", "lifft"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("elevator"),
            keywords: &[
                "adgangsforhold",
                "elevator",
                "handicapadgang",
                "handicapvenligt",
                "hejs",
                "tilgængelighed",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Fahrstuhl"),
            keywords: &["Aufzug", "Fahrstuhl", "Lift"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Lift"),
            keywords: &[""],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ασανσέρ"),
            keywords: &["ανελκυστήρας", "ασανσέρ", "προσβασιμότητα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("elevator"),
            keywords: &["accessibility", "elevator", "hoist", "lift"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("lift"),
            keywords: &[""],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("lift"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ascensor"),
            keywords: &["accesibilidad", "ascensor", "elevador", "montacargas"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("ascensor"),
            keywords: &["ascensor"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("lift"),
            keywords: &["elevaator", "lift", "ligipääs", "tõstuk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("igogailua"),
            keywords: &["igogailua", "irisgarritasuna", "karga-jasogailua"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بالابر"),
            keywords: &["آسانسور", "بالابر", "جرثقیل", "دسترس\u{200c}پذیری"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hissi"),
            keywords: &["esteettömyys", "hissi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("elevator"),
            keywords: &["elevator", "pagiging naa-access"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("lyfta"),
            keywords: &["elevatorur", "lyfta"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("ascenseur"),
            keywords: &["accessibilité", "ascenseur", "monte-personnes"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("ascenseur"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ardaitheoir"),
            keywords: &["ardaitheoir", "inrochtaineacht"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("àrdaichear"),
            keywords: &["so-ruigsinneachd", "tog", "togail", "àrdaichear"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("ascensor"),
            keywords: &["accesibilidade", "ascensor", "montacargas"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("એલિવ\u{ac7}ટર"),
            keywords: &[
                "ઉપર ઊઠાવવ\u{ac1}\u{a82}",
                "ઍક\u{acd}સ\u{ac7}સિબિલિટી",
                "એલિવ\u{ac7}ટર",
                "લિફ\u{acd}ટ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מעלית"),
            keywords: &["בניין גבוה", "לעלות", "מעלית", "נגישות"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("एलिव\u{947}टर"),
            keywords: &["एलिव\u{947}टर", "लिफ\u{93c}\u{94d}ट", "स\u{941}लभता"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("dizalo"),
            keywords: &["dizalo", "dizanje", "lift", "pristupačnost"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("lift"),
            keywords: &["akadálymentesítés", "felvonó", "lift"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("վերելակ"),
            keywords: &["ամբարձիչ", "հատուկ կարիքներ", "վերելակ", "վերհան"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("elevator"),
            keywords: &["aksesibilitas", "elevator", "kerekan", "lift"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("lyfta"),
            keywords: &["aðgengi", "hífa", "lyfta"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("ascensore"),
            keywords: &["accessibilità", "ascensore", "montacarichi"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("エレベーター"),
            keywords: &[
                "アクセシビリティ",
                "エレベーター",
                "バリアフリー",
                "リフト",
                "昇降機",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ondo mlaku"),
            keywords: &["kalancaran", "munggah", "ngangkat", "ondo mlaku"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ლიფტი"),
            keywords: &["ამწე", "ლიფტი", "უნივერსალური წვდომა", "შშმ პირი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("лифт"),
            keywords: &["көтеру", "лифт", "мүмкіндігі шектеулі"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ជណ\u{17d2}ដើរយន\u{17d2}តប\u{17d2}រអប\u{17cb}"),
            keywords: &[
                "គ\u{17d2}រឿងលើកស\u{17d2}ទ\u{17bc}ច",
                "ជណ\u{17d2}ដើរប\u{17d2}រអប\u{17cb}",
                "ជណ\u{17d2}ដើរយន\u{17d2}តប\u{17d2}រអប\u{17cb}",
                "លទ\u{17d2}ធភាពច\u{17bc}ល",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಎಲ\u{cbf}ವೇಟರ\u{ccd}\u{200c}"),
            keywords: &[
                "ಎತ\u{ccd}ತುವುದು",
                "ಎಲ\u{cbf}ವೇಟರ\u{ccd}\u{200c}",
                "ಲಭ\u{ccd}ಯತ\u{cc6}",
                "ಲ\u{cbf}ಫ\u{ccd}ಟ\u{ccd}\u{200c}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("엘리베이터"),
            keywords: &["승강 장치", "승강기", "엘리베이터", "접근성"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("एलिव\u{947}टर"),
            keywords: &[
                "ऍक\u{94d}स\u{945}सिबिलिटी",
                "एलिव\u{947}टर",
                "लिफ\u{94d}ट",
                "होयस\u{94d}ट",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("лифт"),
            keywords: &["лифт"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{eb4}ບ"),
            keywords: &[
                "ການ\u{200b}ຊ\u{ec8}ວຍ\u{200b}ເຂ\u{ebb}\u{ec9}າ\u{200b}ເຖ\u{eb4}ງ",
                "ຍ\u{ebb}ກ\u{200b}ຂ\u{eb6}\u{ec9}ນ",
                "ລ\u{eb4}ບ",
                "ເຄ\u{eb7}\u{ec8}ອນ\u{200b}ທ\u{eb5}\u{ec8}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("elevatorius"),
            keywords: &["elevatorius", "keltuvas", "liftas", "prieinamumas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("lifts"),
            keywords: &["lifts", "pacēlājs", "pieejamība"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лифт"),
            keywords: &["кревање", "лифт", "пристапност"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("എലവേറ\u{d4d}റർ"),
            keywords: &[
                "ആക\u{d4d}സസബിലിറ\u{d4d}റി",
                "എലവേറ\u{d4d}റർ",
                "പൊക\u{d4d}ക\u{d41}ക",
                "ലിഫ\u{d4d}റ\u{d4d}റ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("лифт"),
            keywords: &["лифт", "хүртээмж", "цахилгаан шат", "өргөгч"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("वर चढवणारा"),
            keywords: &[
                "अ\u{945}क\u{94d}स\u{947}स\u{947}बिलीटी",
                "एलिव\u{947}टर",
                "लिफ\u{94d}ट",
                "वर चढण\u{94d}याच\u{947} य\u{902}त\u{94d}र",
                "वर चढवणारा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("elevator"),
            keywords: &["elevator", "kebolehcapaian", "lif", "pengangkat"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စက\u{103a}လ\u{103e}ေကား"),
            keywords: &[
                "စက\u{103a}လ\u{103e}ေကား",
                "ဓာတ\u{103a}လ\u{103e}ေကား",
                "မ တင\u{103a}သည\u{103a}",
                "အများသ\u{102f}\u{1036}းန\u{102d}\u{102f}င\u{103a}မ\u{103e}\u{102f}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("heis"),
            keywords: &["heis", "tilgjengelighet"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("एलिभ\u{947}टर"),
            keywords: &[
                "उपलब\u{94d}धता",
                "एलिभ\u{947}टर",
                "लिफ\u{94d}ट",
                "होइस\u{94d}ट",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("lift"),
            keywords: &["hijstoestel", "lift", "personenlift", "toegankelijkheid"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("heis"),
            keywords: &["heis", "tilgjenge"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଲ\u{b3f}ପ\u{b4d}ଟ"),
            keywords: &[
                "ଉଠ\u{b3e}ଇବ\u{b3e}",
                "ଉତ\u{b4d}ତୋଳନ କର\u{b3f}ବ\u{b3e}",
                "ଲ\u{b3f}ପ\u{b4d}ଟ",
                "ସ\u{b3e}ନ\u{b4d}ନ\u{b3f}ଧ\u{b4d}ୟଲ\u{b3e}ଭର ମ\u{b3e}ର\u{b4d}ଗ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲਿਫਟ"),
            keywords: &["ਐਲੀਵ\u{a47}ਟਰ", "ਪਹ\u{a41}\u{a70}ਚਯ\u{a4b}ਗਤਾ", "ਲਿਫਟ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Lìft"),
            keywords: &[
                "Hẹ\u{301}ví Lód Máshin",
                "Lift",
                "Lìft",
                "Máshin To Ték Kárí Ọ\u{301}p Hẹ\u{301}ví Lod",
                "Ízí To Yuz",
                "Ẹ\u{301}livétọ",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("winda"),
            keywords: &["dostępność", "winda"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لوړګر"),
            keywords: &["لاسرسی", "لوړګر", "هسک ګر", "هسکول"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("elevador"),
            keywords: &["acessibilidade", "elevador", "elevar", "subir"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("lift"),
            keywords: &["accesibilitate", "ascensor", "elevator", "lift"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-066"),
            keywords: &["E13-066"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("лифт"),
            keywords: &["лифт", "подъемник", "специальные возможности"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ايليويٽر"),
            keywords: &["ايليويٽر", "رسائي پذيري", "لفٽ", "هوئسٽ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සෝප\u{dcf}නය"),
            keywords: &[
                "ඔසවන\u{dca}න",
                "ප\u{dca}\u{200d}රවේශ\u{dca}\u{200d}යත\u{dcf}ව",
                "සෝප\u{dcf}නය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("výťah"),
            keywords: &["výťah"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("dvigalo"),
            keywords: &["dostopnost", "dvigalo", "elevator", "lift"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("wiish"),
            keywords: &["dallicid", "marin u helid", "qaadid", "wiish"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("ashensor"),
            keywords: &["ashensor", "qasshmëri"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лифт"),
            keywords: &["доступност", "лифт"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lift"),
            keywords: &["dostupnost", "lift"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("hiss"),
            keywords: &["hiss", "lift", "tillgång", "vinsch"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kambarau"),
            keywords: &["kambarau", "kuinua", "lifti", "ufikivu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("எலவேட\u{bcd}டர\u{bcd}"),
            keywords: &[
                "அணுகல\u{bcd}தன\u{bcd}மை",
                "எலவேட\u{bcd}டர\u{bcd}",
                "ஏற\u{bcd}றுதல\u{bcd}",
                "மின\u{bcd}தூக\u{bcd}கி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఎల\u{c3f}వ\u{c47}టర\u{c4d}"),
            keywords: &[
                "ఎల\u{c3f}వ\u{c47}టర\u{c4d}",
                "ల\u{c3f}ఫ\u{c4d}ట\u{c4d}",
                "హ\u{c3e}య\u{c3f}స\u{c4d}ట\u{c4d}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e34}ฟต\u{e4c}"),
            keywords: &[
                "การช\u{e48}วยการเข\u{e49}าถ\u{e36}ง",
                "รอก",
                "ล\u{e34}ฟต\u{e4c}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("lift"),
            keywords: &["elýeterlilik", "galdyryjy", "lift"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("lifi"),
            keywords: &["lifi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("asansör"),
            keywords: &["asansör", "erişilebilirlik", "lift"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("ліфт"),
            keywords: &["ліфт", "підйомник", "підіймач", "спеціальні можливості"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ایلیویٹر"),
            keywords: &["ایلیویٹر", "رسائی", "لفٹ", "لہرانا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("lift"),
            keywords: &["koʻtarilish", "lift", "maxsus imkoniyatlar"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("thang máy"),
            keywords: &["khả năng tiếp cận", "kéo lên", "nhấc", "thang máy"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("升降機"),
            keywords: &["升降機", "無障礙", "起重機"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("升降机"),
            keywords: &["升降机", "无障碍", "起重机"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("电梯"),
            keywords: &["升降机", "可达性", "电梯"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("電梯"),
            keywords: &["上升", "方便", "貨梯", "電梯"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ikheshi"),
            keywords: &[
                "i-elevator",
                "ikheshi",
                "phakamisa",
                "ukufinyeleleka",
                "ukuphakama",
            ],
        },
    ],
};
#[doc = "🪞"]
pub const MIRROR: crate::Emoji = crate::Emoji {
    glyph: "🪞",
    codepoint: "1FA9E",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "mirror",
    group: "Objects",
    subgroup: "household",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("spieël"),
            keywords: &["spektrum", "spieël", "weerkaats", "weerkaatsing"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መስታወት"),
            keywords: &["መስታወት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مرآة"),
            keywords: &["انعكاس", "عاكس", "مرآة", "مرآة معدنية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("আইন\u{9be}"),
            keywords: &[
                "আইন\u{9be}",
                "প\u{9cd}ৰতিফলক",
                "প\u{9cd}ৰতিফলন",
                "স\u{9cd}পেকট\u{9cd}ৰ\u{9be}ম",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("güzgü"),
            keywords: &["güzgü", "reflektor", "əksetdirmə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("люстэрка"),
            keywords: &["адбітак", "адлюстраванне", "люстэрка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("огледало"),
            keywords: &["огледало", "отражател", "отражение"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("আয\u{9bc}ন\u{9be}"),
            keywords: &["আয\u{9bc}ন\u{9be}", "দর\u{9cd}পণ", "প\u{9cd}রতিবিম\u{9cd}ব"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("melezour"),
            keywords: &["melezour"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ogledalo"),
            keywords: &["metalno ogledalo", "odraz", "ogledalo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("mirall"),
            keywords: &["espill", "mirall", "reflector", "reflex"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏓᎨᏗ"),
            keywords: &["ᎠᏓᎨᏗ", "ᎠᏘᏍᏗᏍᎩ", "ᏄᏍᏛ ᏛᏓᏓᎧᏂᏍᎬ", "ᏄᏍᏛ ᏨᏓᏓᎧᏁᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zrcadlo"),
            keywords: &["obraz", "odlesk", "odraz", "zrcadlo", "zrcátko"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("drych"),
            keywords: &["adlewyrchiad", "adlewyrchydd", "drych", "sbecwlwm"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("spejl"),
            keywords: &[
                "genspejling",
                "spejl",
                "spejlbillede",
                "spejling",
                "spekulum",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Spiegel"),
            keywords: &["Reflexion", "Spiegel", "Spiegelbild"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καθρέφτης"),
            keywords: &["ανακλαστήρας", "αντανάκλαση", "κάτοπτρο", "καθρέφτης"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("mirror"),
            keywords: &["mirror", "reflection", "reflector", "speculum"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["looking glass", "reflection", "reflector"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["looking glass", "mirror", "reflection", "reflector"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("espejo"),
            keywords: &["espejo", "espéculo", "reflector", "reflejo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("espejo"),
            keywords: &["espejo"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("espejo"),
            keywords: &["espejo"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("peegel"),
            keywords: &["peegel", "peegeldi", "peegeldus"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ispilua"),
            keywords: &[
                "erreflektorea",
                "isla",
                "islagailua",
                "islatzailea",
                "ispilua",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("آینه"),
            keywords: &["آینه", "آینه طبی", "انعکاس", "منعکس\u{200c}کننده"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("peili"),
            keywords: &["heijastus", "peilata", "peili"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("salamin"),
            keywords: &["reflector", "repleksyon", "salamin"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("spegil"),
            keywords: &["spegil", "spegilsmynd", "spegl", "speglast", "sýna", "vísa"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("miroir"),
            keywords: &["glace", "miroir", "psyché", "reflet"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("miroir"),
            keywords: &["glace", "miroir", "reflet"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("scáthán"),
            keywords: &["scáthán"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sgàthan"),
            keywords: &["ath-thilgeil", "faileas", "frith-thilgear", "sgàthan"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("espello"),
            keywords: &["espello", "reflectir", "reflexo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કાચ"),
            keywords: &[
                "કાચ",
                "પ\u{acd}રતિબિ\u{a82}બ",
                "રિફ\u{acd}લ\u{ac7}ક\u{acd}ટર",
                "સ\u{acd}પ\u{ac7}ક\u{acd}ય\u{ac1}લમ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מראה"),
            keywords: &["בבואה", "השתקפות", "מראה", "ראי"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("आईना"),
            keywords: &[
                "आईना",
                "दर\u{94d}पण",
                "परावर\u{94d}तक",
                "प\u{94d}रतिबि\u{902}ब",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zrcalo"),
            keywords: &["odraz", "ogledalo", "zrcalo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("tükör"),
            keywords: &["tükröződés", "tükör", "visszaverődés"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("հայելի"),
            keywords: &["արտացոլություն", "արտացոլում", "հայելի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("cermin"),
            keywords: &["cermin", "pantulan", "reflektor", "spekulum"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("spegill"),
            keywords: &["endurspeglun", "endurvarp", "spegill", "speglun"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("specchio"),
            keywords: &["riflesso", "specchio"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("鏡"),
            keywords: &["ミラー", "反射", "姿見", "身だしなみ", "鏡"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kaca pangilon"),
            keywords: &["kaca pangilon", "mantul", "pamantulan", "spekulum"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სარკე"),
            keywords: &["ანარეკლი", "ზერცალო", "სარკე"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("айна"),
            keywords: &["айна", "шағылдырғыш", "шағылыс"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កញ\u{17d2}ចក\u{17cb}"),
            keywords: &[
                "កញ\u{17d2}ចក\u{17cb}",
                "កញ\u{17d2}ចក\u{17cb}ច\u{17c6}ណា\u{17c6}ងផ\u{17d2}លាត",
                "ច\u{17c6}ណា\u{17c6}ងផ\u{17d2}លាត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕನ\u{ccd}ನಡ\u{cbf}"),
            keywords: &[
                "ಕನ\u{ccd}ನಡ\u{cbf}",
                "ಪ\u{ccd}ರತ\u{cbf}ಫಲಕ",
                "ಪ\u{ccd}ರತ\u{cbf}ಫಲನ",
                "ಸ\u{ccd}ಪ\u{cc6}ಕ\u{ccd}ಯುಲಂ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("거울"),
            keywords: &["거울", "검경", "반사", "반사체"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("आरसो"),
            keywords: &[
                "आरसो",
                "प\u{94d}रतिबि\u{902}ब",
                "प\u{94d}रतिबि\u{902}बक",
                "भि\u{902}ग",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("күзгү"),
            keywords: &["күзгү"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແວ\u{ec8}ນ"),
            keywords: &[
                "ພາບສະ\u{200b}ທ\u{ec9}ອນ",
                "ເຄ\u{eb7}\u{ec8}ອງ\u{200b}ສະ\u{200b}ທ\u{ec9}ອນ",
                "ແວ\u{ec8}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("veidrodis"),
            keywords: &["atspindys", "atšvaitas", "reflektorius", "veidrodis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("spogulis"),
            keywords: &["atspīdums", "reflektors", "spogulis"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("огледало"),
            keywords: &["огледало", "одраз", "рефлексија"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കണ\u{d4d}ണ\u{d3e}ടി"),
            keywords: &[
                "കണ\u{d4d}ണ\u{d3e}ടി",
                "പ\u{d4d}രതിഫലനം",
                "റിഫ\u{d4d}ലക\u{d4d}റ\u{d4d}റർ",
                "ലോഹക\u{d4d}കണ\u{d4d}ണ\u{d3e}ടി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("толь"),
            keywords: &["ойлгогч", "толь", "тусгал", "тэлэгч"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("आरसा"),
            keywords: &[
                "आरसा",
                "द\u{941}र\u{94d}बिणीत वापरला जाणारा आरसा",
                "परावर\u{94d}तक",
                "प\u{94d}रतिबि\u{902}ब",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("cermin"),
            keywords: &["cermin", "pantulan", "pemantul", "spekulum"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မ\u{103e}န\u{103a}"),
            keywords: &["ပြန\u{103a}ကန\u{103a}", "မ\u{103e}န\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("speil"),
            keywords: &["refleksjon", "speil", "speilbilde"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ऐना"),
            keywords: &[
                "ऐना",
                "प\u{94d}रतिबिम\u{94d}ब",
                "प\u{94d}रतिबिम\u{94d}बकर\u{94d}ता",
                "स\u{94d}प\u{947}क\u{941}ल\u{941}म",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("spiegel"),
            keywords: &["reflector", "speculum", "spiegel", "weerspiegeling"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("spegel"),
            keywords: &["refleksjon", "spegel", "spegelbilete"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଦର\u{b4d}ପଣ"),
            keywords: &[
                "ଦର\u{b4d}ପଣ",
                "ଧ\u{b3e}ତବ ଦର\u{b4d}ପଣ",
                "ପ\u{b4d}ରତ\u{b3f}ଫଳକ",
                "ପ\u{b4d}ରତ\u{b3f}ବ\u{b3f}ମ\u{b4d}ବ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a3c}ੀਸ\u{a3c}ਾ"),
            keywords: &[
                "ਅਕਸ",
                "ਦਰਪਣ",
                "ਪ\u{a4d}ਰਤਿਬਿ\u{a70}ਬ",
                "ਸਪ\u{a48}ਕ\u{a41}ਲਮ",
                "ਸ\u{a3c}ੀਸ\u{a3c}ਾ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mírọ"),
            keywords: &[
                "Imej",
                "Lukin Glas",
                "Mírọ",
                "Riflẹ\u{301}ktọ",
                "Spẹ\u{301}kulum",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("lustro"),
            keywords: &["lustro", "odbicie", "zwierciadło"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("هنداره"),
            keywords: &["آينه", "انعکاس", "منکس کوونکی", "هنداره"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("espelho"),
            keywords: &["espelho", "espéculo", "refletor", "reflexão"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["espelho", "espéculo", "refletor", "reflexão"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("oglindă"),
            keywords: &["oglindire", "oglindă", "reflectare", "reflexie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-067"),
            keywords: &["E13-067"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("зеркало"),
            keywords: &["зеркало", "отражатель", "отражение"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("آئينو"),
            keywords: &["آئينو", "اسپيڪيولم", "ريفليڪٽر", "پاڇو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කැඩපත"),
            keywords: &[
                "කැඩපත",
                "පර\u{dcf}වර\u{dca}තකය",
                "පර\u{dcf}වර\u{dca}තනය",
                "සමපේක\u{dca}ෂනය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zrkadlo"),
            keywords: &["odraz", "zrkadlenie", "zrkadlo"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zrcalo"),
            keywords: &["odsev", "ogledalo", "zrcalo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("muraayad"),
            keywords: &["birta muraayda", "milicsiga", "muraayad", "muuqaal"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("pasqyrë"),
            keywords: &["pasqyrim", "pasqyrë", "refleks"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("огледало"),
            keywords: &["огледало", "одраз", "рефлексија", "рефлектор"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ogledalo"),
            keywords: &["odraz", "ogledalo", "refleksija", "reflektor"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("spegel"),
            keywords: &["reflektor", "spegel", "spegelglas"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kioo"),
            keywords: &["kiakisi", "kioo", "kuakisi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கண\u{bcd}ண\u{bbe}டி"),
            keywords: &[
                "கண\u{bcd}ண\u{bbe}டி",
                "பிரதிபலிப\u{bcd}ப\u{bbe}ன\u{bcd}",
                "பிரதிபலிப\u{bcd}பு",
                "மெருகேற\u{bcd}றப\u{bcd}பட\u{bcd}ட உலோகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("అద\u{c4d}దం"),
            keywords: &[
                "అద\u{c4d}దం",
                "దర\u{c4d}పణం",
                "ప\u{c4d}రత\u{c3f}బ\u{c3f}ంబం",
                "ప\u{c4d}రత\u{c3f}బ\u{c3f}ంబ\u{c3e}న\u{c4d}న\u{c3f} చూప\u{c47}ద\u{c3f}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("กระจก"),
            keywords: &[
                "กระจก",
                "กระจกเงา",
                "การสะท\u{e49}อน",
                "ต\u{e31}วสะท\u{e49}อน",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("aýna"),
            keywords: &["aýna", "giňeldiji", "serpikdiriji", "serpikme"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sioʻata"),
            keywords: &["sioʻata"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ayna"),
            keywords: &["ayna", "reflektör", "spekulum", "yansıma", "yansıtıcı"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("дзеркало"),
            keywords: &["відбивач", "відображення", "дзеркало", "рефлектор"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("آئینہ"),
            keywords: &["آئینہ", "عکاسی", "منعکس کرنے والا", "منعکس کنندہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("oyna"),
            keywords: &["aks etish", "aks ettirgich", "oyna", "reflektor"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("gương"),
            keywords: &["gương", "gương phản xạ", "phản xạ", "phản ánh"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("鏡"),
            keywords: &["反射", "反射器", "反射鏡", "鏡"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("镜"),
            keywords: &["反射", "反射器", "反射镜", "镜"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("镜子"),
            keywords: &["反射", "反射镜", "窥镜", "镜子"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("鏡子"),
            keywords: &["反射", "反射鏡", "反映", "鏡子"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isibuko"),
            keywords: &["i-speculum", "isibonakaliso", "isibuko", "ukuzindla"],
        },
    ],
};
#[doc = "🪟"]
pub const WINDOW: crate::Emoji = crate::Emoji {
    glyph: "🪟",
    codepoint: "1FA9F",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "window",
    group: "Objects",
    subgroup: "household",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("venster"),
            keywords: &["deursigtig", "opening", "raam", "uitsig", "vars", "venster"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መስኮት"),
            keywords: &["መስኮት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("نافذة"),
            keywords: &[
                "إطار",
                "إطلالة",
                "شفاف",
                "فتحة",
                "منظر",
                "نافذة",
                "هواء منعش",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("খিৰিকী"),
            keywords: &[
                "খিৰিকী",
                "খোল\u{9be}",
                "দ\u{9c3}শ\u{9cd}য",
                "ফ\u{9cd}ৰেম",
                "সতেজ বত\u{9be}হ",
                "স\u{9cd}বচ\u{9cd}ছ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("pəncərə"),
            keywords: &[
                "açılır",
                "görünüş",
                "pəncərə",
                "təmiz hava",
                "çərçivə",
                "şəffaf",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("акно"),
            keywords: &[
                "адчыняць",
                "акно",
                "від",
                "празрысты",
                "рама",
                "свежае паветра",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("прозорец"),
            keywords: &[
                "изглед",
                "отваряне",
                "прозорец",
                "прозрачно",
                "рамка",
                "свеж въздух",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("জ\u{9be}ন\u{9be}ল\u{9be}"),
            keywords: &[
                "খোল\u{9be}",
                "জ\u{9be}ন\u{9be}ল\u{9be}",
                "ত\u{9be}জ\u{9be} ব\u{9be}ত\u{9be}স",
                "দ\u{9c3}শ\u{9cd}য",
                "ফ\u{9cd}রেম",
                "স\u{9cd}বচ\u{9cd}ছ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("prenestr"),
            keywords: &["framm", "gweled", "prenestr", "stern", "treuzwelus"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("prozor"),
            keywords: &[
                "okvir",
                "otvaranje",
                "pogled",
                "prozor",
                "svjež zrak",
                "transparentno",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("finestra"),
            keywords: &[
                "aire fresc",
                "finestra",
                "marc",
                "obertura",
                "transparent",
                "vista",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏦᎳᏂ"),
            keywords: &["ᎠᎪᎵᏰᏗ", "ᎠᏍᏚᎢᏓ", "ᎦᎸᏙᏗ", "ᏘᎬᏩᎸᏌᏓ", "ᏦᎳᏂ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("okno"),
            keywords: &[
                "okno",
                "otvor",
                "průhled",
                "průhledný",
                "rám",
                "výhled",
                "čerstvý vzduch",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ffenestr"),
            keywords: &[
                "agoriad",
                "awyr iach",
                "ffenestr",
                "ffrâm",
                "golwg",
                "tryloyw",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("vindue"),
            keywords: &[
                "frisk luft",
                "gennemsigtig",
                "gennemsigtighed",
                "karm",
                "rude",
                "udsigt",
                "vindue",
                "vindueskarm",
                "åbning",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Fenster"),
            keywords: &[
                "Aussicht",
                "Fenster",
                "Rahmen",
                "durchsichtig",
                "frische Luft",
                "Öffnung",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("παράθυρο"),
            keywords: &[
                "άνοιγμα",
                "διαφανές",
                "θέα",
                "καθαρός αέρας",
                "παράθυρο",
                "πλαίσιο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("window"),
            keywords: &[
                "frame",
                "fresh air",
                "opening",
                "transparent",
                "view",
                "window",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ventana"),
            keywords: &[
                "abertura",
                "apertura",
                "cristal",
                "marco",
                "transparente",
                "ventana",
                "vista",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("ventana"),
            keywords: &["ventana"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("aken"),
            keywords: &["aken", "avamine", "läbipaistev", "raam", "vaade"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("leihoa"),
            keywords: &[
                "gardena",
                "ikuspegia",
                "irekidura",
                "irekiera",
                "leihoa",
                "markoa",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پنجره"),
            keywords: &[
                "دریچه",
                "شفاف",
                "قاب",
                "هوای تازه",
                "پنجره",
                "چشم\u{200c}انداز",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ikkuna"),
            keywords: &[
                "aukko",
                "ikkuna",
                "kehys",
                "läpinäkyvä",
                "näkymä",
                "raikas ilma",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bintana"),
            keywords: &["bintana", "bukasan", "frame", "sariwang hangin", "view"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("vindeyga"),
            keywords: &["gluggi", "rútar", "rútur", "vindeyga"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("fenêtre"),
            keywords: &[
                "air frais",
                "cadre",
                "fenêtre",
                "ouverture",
                "transparent",
                "vue",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("fenêtre"),
            keywords: &[
                "air frais",
                "cadre",
                "fenêtre",
                "ouverture",
                "transparent",
                "vue",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("fuinneog"),
            keywords: &["aer", "fráma", "fuinneog", "oscailt", "radharc"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("uinneag"),
            keywords: &[
                "adhair ùr",
                "coimhead",
                "fosgladh",
                "frèam",
                "seall",
                "sealladh",
                "trìd-shoilleir",
                "uinneag",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("fiestra"),
            keywords: &["fiestra", "ventá", "vista", "xanela"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બારી"),
            keywords: &[
                "આરપાર",
                "ખ\u{ac1}લતી",
                "તાજી હવા",
                "દ\u{ac7}ખાવ\u{ac1}\u{a82}",
                "ફ\u{acd}ર\u{ac7}મ",
                "બારી",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חלון"),
            keywords: &["חלון", "מסגרת", "פתח"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("खिड\u{93c}की"),
            keywords: &[
                "खिड\u{93c}की",
                "खोलना",
                "ताज\u{93c}ी हवा",
                "द\u{943}श\u{94d}य",
                "पारदर\u{94d}शी",
                "फ\u{93c}\u{94d}र\u{947}म",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("prozor"),
            keywords: &[
                "okvir",
                "otvaranje",
                "pogled",
                "prozirno",
                "prozor",
                "svjež zrak",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("ablak"),
            keywords: &[
                "ablak",
                "friss levegő",
                "keret",
                "kilátás",
                "nyílás",
                "átlátszó",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("պատուհան"),
            keywords: &[
                "թարմ",
                "թափանցիկ",
                "լուսամուտ",
                "շրջանակ",
                "պատուհան",
                "տեսարան",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("jendela"),
            keywords: &[
                "bingkai",
                "bukaan",
                "jendela",
                "pemadangan",
                "transparan",
                "udara segar",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("gluggi"),
            keywords: &[
                "ferskt loft",
                "gegnsætt",
                "gluggi",
                "opna",
                "rammi",
                "útsýni",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("finestra"),
            keywords: &[
                "apertura",
                "aria fresca",
                "finestra",
                "telaio",
                "trasparente",
                "vista",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("窓"),
            keywords: &["フレーム", "換気", "眺め", "窓", "開ける"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("cendela"),
            keywords: &[
                "cendela",
                "mbukak",
                "pamandangan",
                "pigura",
                "tembus cahya",
                "udara seger",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ფანჯარა"),
            keywords: &[
                "გამჭვირვალე",
                "გახსნა",
                "სარკმელი",
                "ფანჯარა",
                "ჩარჩო",
                "ჰაერი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("терезе"),
            keywords: &[
                "жақтау",
                "көрініс",
                "мөлдір",
                "саңылау",
                "таза ауа",
                "терезе",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បង\u{17d2}អ\u{17bd}ច"),
            keywords: &[
                "ខ\u{17d2}យល\u{17cb}បរ\u{17b7}ស\u{17bb}ទ\u{17d2}ធ",
                "ថ\u{17d2}លា",
                "ទ\u{17b7}ដ\u{17d2}ឋភាព",
                "បង\u{17d2}អ\u{17bd}ច",
                "ប\u{17d2}រហោង",
                "ស\u{17ca}\u{17bb}ម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{cbf}ಟಕ\u{cbf}"),
            keywords: &[
                "ಅಂಚು",
                "ಕ\u{cbf}ಟಕ\u{cbf}",
                "ತಾಜಾ ಗಾಳ\u{cbf}",
                "ತ\u{cc6}ರ\u{cc6}ಯುವುದು",
                "ನೋಟ",
                "ಪಾರದರ\u{ccd}ಶಕ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("창문"),
            keywords: &["맑은 공기", "전망", "창문", "창틀", "투명한"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जन\u{947}ल"),
            keywords: &[
                "उकत\u{947}\u{902}",
                "चौकट",
                "जन\u{947}ल",
                "ताजी हवा",
                "द\u{943}श\u{94d}य",
                "पारदर\u{94d}शक",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("терезе"),
            keywords: &["терезе"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{ec8}ອງ\u{200b}ຢ\u{ec9}ຽມ"),
            keywords: &[
                "ຂອບ",
                "ປະ\u{200b}ຕ\u{eb9}",
                "ປ\u{ec8}ອງ\u{200b}ຢ\u{ec9}ຽມ",
                "ວ\u{eb4}ວ",
                "ເປ\u{eb5}ດ",
                "ໜ\u{ec9}າ\u{200b}ຕ\u{ec8}າງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("langas"),
            keywords: &[
                "atvėrimas",
                "langas",
                "perregimas",
                "rėmas",
                "vaizdas",
                "šviežias oras",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("logs"),
            keywords: &[
                "atvērums",
                "caurspīdīgs",
                "logs",
                "rāmis",
                "skats",
                "svaigs gaiss",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("прозорец"),
            keywords: &[
                "отвор",
                "поглед",
                "прозорец",
                "проѕирно",
                "рамка",
                "свеж воздух",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ജനൽ"),
            keywords: &[
                "ജനൽ",
                "ജ\u{d3e}ലകം",
                "ദർശനം",
                "ഫ\u{d4d}രെയിം",
                "ശ\u{d41}ദ\u{d4d}ധ വ\u{d3e}യ\u{d41}",
                "സ\u{d41}ത\u{d3e}ര\u{d4d}യം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цонх"),
            keywords: &[
                "ил тод",
                "онгойх",
                "харагдац",
                "хүрээ",
                "цонх",
                "цэвэр агаар",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("खिडकी"),
            keywords: &[
                "उघडण\u{947}",
                "खिडकी",
                "ताजी हवा",
                "द\u{943}श\u{94d}य",
                "पारदर\u{94d}शक",
                "फ\u{94d}र\u{947}म",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tingkap"),
            keywords: &["bingkai", "bukaan", "lutsinar", "pandangan", "tingkap"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပြတင\u{103a}းပေါက\u{103a}"),
            keywords: &[
                "ပြတင\u{103a}းပေါက\u{103a}",
                "ဘောင\u{103a}",
                "မြင\u{103a}က\u{103d}င\u{103a}း",
                "လေကောင\u{103a}းလေသန\u{1037}\u{103a}",
                "အကြည\u{103a}",
                "အပေါက\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("vindu"),
            keywords: &[
                "frisk luft",
                "gjennomsiktig",
                "ramme",
                "utsikt",
                "vindu",
                "åpning",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("झ\u{94d}याल"),
            keywords: &[
                "ख\u{941}ला",
                "झ\u{94d}याल",
                "ताजा हावा",
                "द\u{943}श\u{94d}य",
                "पारदर\u{94d}शी",
                "फ\u{94d}र\u{947}म",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("raam"),
            keywords: &[
                "doorzichtig",
                "frisse lucht",
                "kozijn",
                "opening",
                "raam",
                "uitzicht",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("vindauge"),
            keywords: &[
                "frisk luft",
                "gjennomsiktig",
                "opning",
                "ramme",
                "utsikt",
                "vindauge",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଝରକ\u{b3e}"),
            keywords: &[
                "ଖୋଲ\u{b3f}ବ\u{b3e}",
                "ଚୌକ\u{b3e}ଠ",
                "ଝରକ\u{b3e}",
                "ଦେଖ\u{b3f}ବ\u{b3e}",
                "ସତେଜ ବ\u{b3e}ୟ\u{b41}",
                "ସ\u{b4d}ୱଚ\u{b4d}ଛ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਖਿੜਕੀ"),
            keywords: &[
                "ਖਿੜਕੀ",
                "ਚ\u{a4c}ਖਟਾ",
                "ਤਾਜ\u{a3c}ੀ ਹਵਾ",
                "ਦ\u{a4d}ਰਿਸ\u{a3c}",
                "ਪਾਰਦਰਸ\u{a3c}ੀ",
                "ਫ\u{a4d}ਰ\u{a47}ਮ",
                "ਵਿਰਲ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wíndo"),
            keywords: &[
                "Frem",
                "Frẹ\u{301}sh Ea",
                "Luk",
                "Sí Tru",
                "Wíndo",
                "Ópunin",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("okno"),
            keywords: &[
                "framuga",
                "okno",
                "otwór",
                "przezroczyste",
                "widok",
                "świeże powietrze",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کړکۍ"),
            keywords: &["برسيره کول", "تازه هوا", "شفاف", "نظاره", "چوکاټ", "کړکۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("janela"),
            keywords: &[
                "abertura",
                "ar fresco",
                "janela",
                "quadro",
                "transparente",
                "vista",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("fereastră"),
            keywords: &[
                "aer proaspăt",
                "deschidere",
                "fereastră",
                "geam",
                "ramă",
                "transparent",
                "vedere",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-068"),
            keywords: &["E13-068"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("окно"),
            keywords: &[
                "вид",
                "окно",
                "прозрачный",
                "рама",
                "свежий воздух",
                "стекло",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("دري"),
            keywords: &["تازي هوا", "دري", "شفاف", "فريم", "منظر", "کليل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කව\u{dd4}ළ\u{dd4}ව"),
            keywords: &[
                "කව\u{dd4}ළ\u{dd4}ව",
                "නරඹන\u{dca}න",
                "නැව\u{dd4}ම\u{dca} ව\u{dcf}තය",
                "ර\u{dcf}ම\u{dd4}ව",
                "ව\u{dd2}න\u{dd2}ව\u{dd2}ද පෙනෙන",
                "ව\u{dd2}වෘත",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("okno"),
            keywords: &["okno", "otvoriť", "rám", "vzduch", "výhľad"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("okno"),
            keywords: &[
                "odprtina",
                "okno",
                "okvir",
                "pogled",
                "prosojno",
                "svež zrak",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("daaqad"),
            keywords: &[
                "arag gudbiye",
                "daaqad",
                "daaqada",
                "fareem",
                "furitaanka",
                "hawo fareesh ah",
                "muuqaalka",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("dritare"),
            keywords: &[
                "ajër i pastër",
                "dritare",
                "hapje",
                "kasë",
                "pamje",
                "transparent",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("прозор"),
            keywords: &[
                "оквир",
                "отвор",
                "поглед",
                "провидно",
                "прозор",
                "свеж ваздух",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["прозор"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("prozor"),
            keywords: &[
                "okvir",
                "otvor",
                "pogled",
                "providno",
                "prozor",
                "svež vazduh",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["prozor"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("fönster"),
            keywords: &["fönster", "genomskinlig", "ram", "utsikt", "öppning"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("dirisha"),
            keywords: &["angavu", "dirisha", "fremu", "hewa safi", "kuona", "mwanya"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஜன\u{bcd}னல\u{bcd}"),
            keywords: &[
                "ஒளிப\u{bcd}புகும\u{bcd} தன\u{bcd}மை",
                "க\u{bbe}ட\u{bcd}சி",
                "சட\u{bcd}டம\u{bcd}",
                "ஜன\u{bcd}னல\u{bcd}",
                "திறப\u{bcd}பு",
                "தூய\u{bcd}மைய\u{bbe}ன க\u{bbe}ற\u{bcd}று",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c3f}ట\u{c3f}క\u{c40}"),
            keywords: &[
                "క\u{c3f}ట\u{c3f}క\u{c40}",
                "త\u{c3e}జ\u{c3e} గ\u{c3e}ల\u{c3f}",
                "త\u{c46}రవగల\u{c3f}గ\u{c47}ద\u{c3f}",
                "ప\u{c3e}రదర\u{c4d}శకతత\u{c4b} కూడ\u{c3f}నద\u{c3f}",
                "ఫ\u{c4d}ర\u{c47}మ\u{c4d}",
                "వ\u{c40}క\u{c4d}షణ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าต\u{e48}าง"),
            keywords: &[
                "กรอบ",
                "การเป\u{e34}ด",
                "ภาพท\u{e34}วท\u{e31}ศน\u{e4c}",
                "หน\u{e49}าต\u{e48}าง",
                "อากาศบร\u{e34}ส\u{e38}ทธ\u{e34}\u{e4c}",
                "โปร\u{e48}งใส",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("penjire"),
            keywords: &["açyklyk", "dury", "görnüş", "penjire", "çarçuwa"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("matapā-sioʻata"),
            keywords: &["matapā-sioʻata"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("pencere"),
            keywords: &[
                "açılım",
                "manzara",
                "pencere",
                "saydam",
                "temiz hava",
                "çerçeve",
                "şeffaf",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("вікно"),
            keywords: &[
                "відчинити",
                "вікно",
                "краєвид",
                "прозоре",
                "рама",
                "свіже повітря",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کھڑکی"),
            keywords: &["تازہ ہوا", "شفاف", "فریم", "منظر", "کھلا", "کھڑکی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("deraza"),
            keywords: &["deraza", "koʻrish", "ochilish", "oyna", "rom", "shaffof"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cửa sổ"),
            keywords: &[
                "cửa sổ",
                "khung",
                "không khí trong lành",
                "mở",
                "trong suốt",
                "xem",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("窗"),
            keywords: &["打開", "景觀", "框架", "窗", "透明"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("窗"),
            keywords: &["打开", "景观", "框架", "窗", "透明"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("窗户"),
            keywords: &["开窗", "新鲜空气", "景色", "窗户", "窗框", "透明"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("窗戶"),
            keywords: &["框", "窗", "窗戶", "觀景", "透明"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iwindi"),
            keywords: &[
                "buka",
                "evulekile",
                "iwindi",
                "uhlaka",
                "ukuvula",
                "umoya omusha",
            ],
        },
    ],
};
#[doc = "🛏\u{fe0f}"]
pub const BED: crate::Emoji = crate::Emoji {
    glyph: "🛏\u{fe0f}",
    codepoint: "1F6CF FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "bed",
    group: "Objects",
    subgroup: "household",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🛏",
        codepoint: "1F6CF",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "bed",
        group: "Objects",
        subgroup: "household",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("bed"),
            keywords: &["bed", "hotel", "slaap"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አልጋ"),
            keywords: &["ሆቴል", "አልጋ", "እንቅልፍ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سرير"),
            keywords: &["سرير", "فندق", "نوم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বিচন\u{9be}"),
            keywords: &["নিদ\u{9cd}ৰ\u{9be}", "বিচন\u{9be}", "হোটেল"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yataq"),
            keywords: &["otel", "yataq", "yatmaq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ложак"),
            keywords: &["гасцініца", "гатэль", "ложак", "сон"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("легло"),
            keywords: &["легло", "сън", "хотел"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বিছ\u{9be}ন\u{9be}"),
            keywords: &["বিছ\u{9be}ন\u{9be}", "শোওয\u{9bc}\u{9be}", "হোটেল"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("gwele"),
            keywords: &["gwele", "kousket", "leti"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("krevet"),
            keywords: &["hotel", "krevet", "spavanje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("llit"),
            keywords: &["dormir", "hotel", "llit"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏂᏟ"),
            keywords: &["ᎦᏂᏟ", "ᎦᏢᏅᏗ", "ᏧᏂᏒᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("postel"),
            keywords: &["hotel", "postel", "spánek"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("gwely"),
            keywords: &["cysgu", "gwely", "gwesty"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("seng"),
            keywords: &["hotel", "seng", "sove"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Bett"),
            keywords: &["Bett", "Hotel", "schlafen", "Übernachtung"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κρεβάτι"),
            keywords: &["κρεβάτι", "ξενοδοχείο", "ύπνος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("bed"),
            keywords: &["bed", "hotel", "sleep"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cama"),
            keywords: &["cama", "dormir", "hotel"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["cama", "dormir", "habitación", "hotel", "recámara"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("voodi"),
            keywords: &["hotell", "uni", "voodi"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ohea"),
            keywords: &["hotel", "lo", "ohea"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تختخواب"),
            keywords: &["تختخواب", "خوابیدن", "هتل"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("sänky"),
            keywords: &["hotelli", "nukkua", "sänky", "uni"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("higaan"),
            keywords: &["higaan", "hotel", "tulog"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("song"),
            keywords: &["song", "sova"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("lit"),
            keywords: &["dormir", "hôtel", "lit"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("leaba"),
            keywords: &["codladh", "leaba", "óstán"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("leabaidh"),
            keywords: &["cadal", "leabaidh", "taigh-òsta"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cama"),
            keywords: &["cama", "durmir", "hotel"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પથારી"),
            keywords: &["ઊ\u{a82}ઘ", "નિ\u{a82}દ\u{acd}રા", "પથારી", "હોટલ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("gado"),
            keywords: &["barci", "gado", "hotal"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מיטה"),
            keywords: &["לינה", "לישון", "מיטה", "מלון"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बिस\u{94d}तर"),
            keywords: &["बिस\u{94d}तर", "होटल"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("krevet"),
            keywords: &["hotel", "krevet", "spavanje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("ágy"),
            keywords: &["alvás", "szálloda", "ágy"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մահճակալ"),
            keywords: &["հյուրանոց", "մահճակալ", "քնել"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tempat tidur"),
            keywords: &["hotel", "tempat tidur", "tidur"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("àkwà"),
            keywords: &["àkwà", "ụlọ nkwarị", "ụra"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("rúm"),
            keywords: &["hótel", "rúm", "sofa"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("letto"),
            keywords: &["dormire", "hotel", "letto"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ベッド"),
            keywords: &["ベッド", "ホテル", "寝る", "睡眠"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("amben"),
            keywords: &["amben", "hotel", "turu"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("საწოლი"),
            keywords: &["სასტუმრო", "საწოლი", "ძილი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("кереует"),
            keywords: &["кереует", "қонақ үй", "ұйқы"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("seng"),
            keywords: &["hotel", "seng", "sove"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("គ\u{17d2}រែ"),
            keywords: &["គ\u{17d2}រែ", "ដេក", "សណ\u{17d2}ឋាគារ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹಾಸ\u{cbf}ಗ\u{cc6}"),
            keywords: &[
                "ನ\u{cbf}ದ\u{ccd}ರ\u{cc6}",
                "ಹಾಸ\u{cbf}ಗ\u{cc6}",
                "ಹೊಟೇಲ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("침대"),
            keywords: &["침대", "호텔"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("खाट"),
            keywords: &["खाट", "न\u{94d}हीद", "हॉट\u{947}ल"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("төшөк"),
            keywords: &["мейманкана", "төшөк", "укта"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Bett"),
            keywords: &["Bett", "Hotel", "schlofen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຕຽງນອນ"),
            keywords: &["ຕຽງນອນ", "ໂຮງແຮມ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("lova"),
            keywords: &["lova", "miegoti", "viešbutis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("gulta"),
            keywords: &["gulta", "gulēt", "viesnīca"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("moenga"),
            keywords: &["hōtēra", "moe", "moenga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("кревет"),
            keywords: &["кревет", "спиење", "хотел"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ബെഡ\u{d4d}"),
            keywords: &["ഉറക\u{d4d}കം", "ബെഡ\u{d4d}", "ഹോട\u{d4d}ടൽ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ор"),
            keywords: &["зочид буудал", "нойр", "ор"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("बिछाना"),
            keywords: &["झोप", "बिछाना", "हॉट\u{947}ल"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("katil"),
            keywords: &["hotel", "katil", "tidur"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("sodda"),
            keywords: &["lukanda", "rqad", "sodda"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ခ\u{102f}တင\u{103a}"),
            keywords: &[
                "ခ\u{102f}တင\u{103a}",
                "ဟ\u{102d}\u{102f}တယ\u{103a}",
                "အ\u{102d}ပ\u{103a}ရာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("seng"),
            keywords: &["hotell", "seng", "sove"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("खाट"),
            keywords: &["खाट", "स\u{941}त\u{94d}न\u{947}", "होट\u{947}ल"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bed"),
            keywords: &["bed", "hotel", "slapen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("seng"),
            keywords: &["hotell", "seng", "sove"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଶେଯ"),
            keywords: &["ଖଟ", "ଶେଯ", "ଶୋଇବ\u{b3e}", "ହୋଟେଲ\u{b4d}\u{200c}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬਿਸਤਰ"),
            keywords: &["ਬਿਸਤਰ", "ਵਿਅਕਤੀ", "ਹ\u{a4b}ਟਲ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بیڈ"),
            keywords: &["بیڈ", "سونا", "ہوٹل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bẹdi"),
            keywords: &["Bẹdi", "Họtẹl", "Slip"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("łóżko"),
            keywords: &["hotel", "nocleg", "sen", "łóżko"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بستره"),
            keywords: &["بستره", "هوتل", "ويده کېدل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cama"),
            keywords: &["cama", "hotel", "sono"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["cama", "dormir", "hotel"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pat"),
            keywords: &["cazare", "hotel", "pat", "somn"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-990"),
            keywords: &["E10-990"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("кровать"),
            keywords: &["гостиница", "дом", "кровать", "отель", "пустая", "спальня"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("uburiri"),
            keywords: &["hoteli", "kuryama", "uburiri"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بسترو"),
            keywords: &["بسترو", "سمهڻ", "هوٽل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඇඳ"),
            keywords: &["ඇඳ", "න\u{dd2}න\u{dca}ද", "හෝටලය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("posteľ"),
            keywords: &["hotel", "posteľ", "spánok"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("postelja"),
            keywords: &["hotel", "postelja", "spanje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("sariir"),
            keywords: &["hudheel", "hurdo", "sariir"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("krevat"),
            keywords: &["gjumë", "hotel", "krevat"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кревет"),
            keywords: &["кревет", "спaвaњe", "хoтeл"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("krevet"),
            keywords: &["hotel", "krevet", "spavanje"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("säng"),
            keywords: &["hotell", "säng", "sömn"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitanda"),
            keywords: &["hoteli", "kitanda", "lala"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("படுக\u{bcd}கை"),
            keywords: &["தூக\u{bcd}கம\u{bcd}", "படுக\u{bcd}கை", "விடுதி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("పరుపు"),
            keywords: &["న\u{c3f}ద\u{c4d}ర", "పరుపు", "హ\u{c4b}టల\u{c4d}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("бистар"),
            keywords: &["бистар", "меҳмонхона", "хоб кардан"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เต\u{e35}ยง"),
            keywords: &["หล\u{e31}บ", "เต\u{e35}ยง", "โรงแรม"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýatalga"),
            keywords: &["myhmanhana", "uky", "ýatalga"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mohenga"),
            keywords: &["mohenga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yatak"),
            keywords: &["otel", "uyuma", "yatak"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كارىۋات"),
            keywords: &["ئۇخلاش", "كارىۋات", "مېھمانخانا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("ліжко"),
            keywords: &["готель", "ліжко", "сон"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بستر"),
            keywords: &["بستر", "نیند", "ہوٹل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("karavot"),
            keywords: &["karavot", "mehmonxona", "uxlash", "uyqu"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("giường"),
            keywords: &["giường", "khách sạn", "ngủ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("lal"),
            keywords: &["lal", "nelaw", "otel"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhedi"),
            keywords: &["ibhedi", "ihotele", "lala"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ibùsùn"),
            keywords: &["ibùsùn", "ilé ìtura", "sùn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("床"),
            keywords: &["床", "訓覺", "酒店"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("床"),
            keywords: &["床", "训觉", "酒店"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("床"),
            keywords: &["宾馆", "床", "床垫", "床铺", "睡眠", "睡觉"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("床"),
            keywords: &["床", "睡覺"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umbhede"),
            keywords: &["ihhotela", "ukulala", "umbhede"],
        },
    ],
};
#[doc = "🛋\u{fe0f}"]
pub const COUCH_AND_LAMP: crate::Emoji = crate::Emoji {
    glyph: "🛋\u{fe0f}",
    codepoint: "1F6CB FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "couch and lamp",
    group: "Objects",
    subgroup: "household",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🛋",
        codepoint: "1F6CB",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "couch and lamp",
        group: "Objects",
        subgroup: "household",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("rusbank en lamp"),
            keywords: &["bank", "hotel", "lamp", "rus", "rusbank en lamp"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሶፋ እና መብራት"),
            keywords: &["ሆቴል", "መብራት", "ሶፋ", "ሶፋ እና መብራት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كنبة ومصباح"),
            keywords: &["فندق", "كنبة", "كنبة ومصباح", "مصباح"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9be}লংক আৰ\u{9c1} লেম\u{9cd}প"),
            keywords: &[
                "ক\u{9be}উচ",
                "প\u{9be}লংক আৰ\u{9c1} লেম\u{9cd}প",
                "লেম\u{9cd}প",
                "হোটেল",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("divan və lampa"),
            keywords: &["divan", "divan və lampa", "lampa", "otel"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("канапа з лямпай"),
            keywords: &["гасцініца", "гатэль", "канапа", "канапа з лямпай", "лямпа"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Канапе и лампа"),
            keywords: &["Канапе и лампа", "канапе", "лампа", "хотел"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9be}লঙ\u{9cd}ক ও ব\u{9be}তি"),
            keywords: &[
                "ক\u{9be}উচ",
                "প\u{9be}লঙ\u{9cd}ক ও ব\u{9be}তি",
                "ল\u{9cd}য\u{9be}ম\u{9cd}প",
                "হোটেল",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("gourvezvank ha lamp"),
            keywords: &[
                "gourvezvank",
                "gourvezvank ha lamp",
                "kleuzeur",
                "lamp",
                "leti",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kauč i lampa"),
            keywords: &["hotel", "kauč", "kauč i lampa", "lampa"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("sofà i làmpada"),
            keywords: &["hotel", "làmpada", "sofà", "sofà i làmpada"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏅᎯᏓ ᎦᏍᎩᎶ ᎠᎴ ᎠᏨᏍᏗ"),
            keywords: &["ᎠᏨᏍᏗ", "ᎦᏅᎯᏓ ᎦᏍᎩᎶ", "ᎦᏅᎯᏓ ᎦᏍᎩᎶ ᎠᎴ ᎠᏨᏍᏗ", "ᏧᏂᏒᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("gauč a lampa"),
            keywords: &["gauč", "gauč a lampa", "hotel", "lampa"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("soffa a lamp"),
            keywords: &["gwesty", "lamp", "soffa", "soffa a lamp"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sofa og lampe"),
            keywords: &["hotel", "lampe", "sofa", "sofa og lampe"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Sofa und Lampe"),
            keywords: &["Lampe", "Sofa", "Sofa und Lampe"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καναπές και φωτιστικό"),
            keywords: &[
                "καναπές",
                "καναπές και φωτιστικό",
                "ξενοδοχείο",
                "φωτιστικό",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("couch and lamp"),
            keywords: &["couch", "couch and lamp", "hotel", "lamp"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("sofa and lamp"),
            keywords: &["couch", "hotel", "lamp", "sofa", "sofa and lamp"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("couch and lamp"),
            keywords: &[
                "couch",
                "couch and lamp",
                "hotel",
                "lamp",
                "sofa",
                "sofa and lamp",
            ],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("couch and lamp"),
            keywords: &[
                "couch",
                "couch and lamp",
                "hotel",
                "lamp",
                "sofa",
                "sofa and lamp",
            ],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("sofá y lámpara"),
            keywords: &["hotel", "lámpara", "sofá", "sofá y lámpara"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("diivan ja lamp"),
            keywords: &["diivan", "diivan ja lamp", "hotell", "lamp"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("sofa eta lanpara"),
            keywords: &["hotel", "lanpara", "sofa", "sofa eta lanpara"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مبل راحتی و چراغ"),
            keywords: &["لامپ", "مبل", "مبل راحتی و چراغ", "هتل", "چراغ", "کاناپه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("sohva ja lamppu"),
            keywords: &["hotelli", "lamppu", "sohva", "sohva ja lamppu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("sofa at ilaw"),
            keywords: &["hotel", "ilaw", "sofa", "sofa at ilaw", "upuan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sofa og lampa"),
            keywords: &["lampa", "sofa", "sofa og lampa"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("canapé et lampe"),
            keywords: &["canapé", "canapé et lampe", "lampe"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("sofa et lampe"),
            keywords: &["canapé", "divan", "lampe", "sofa", "sofa et lampe"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("tolg agus lampa"),
            keywords: &["lampa", "tolg", "tolg agus lampa", "óstán"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("langasaid ’s lampa"),
            keywords: &["lampa", "langasaid", "langasaid ’s lampa", "taigh-òsta"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("sofá e lámpada"),
            keywords: &["hotel", "lámpada", "sofá", "sofá e lámpada"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કાઉચ અન\u{ac7} લ\u{ac7}મ\u{acd}પ"),
            keywords: &[
                "કાઉચ",
                "કાઉચ અન\u{ac7} લ\u{ac7}મ\u{acd}પ",
                "લ\u{ac7}મ\u{acd}પ",
                "સોફો",
                "હોટલ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kujerar kwance da fitila"),
            keywords: &[
                "fitila",
                "hotal",
                "kujerar kwance",
                "kujerar kwance da fitila",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ספה ומנורה"),
            keywords: &["מלון", "מנורה", "סלון", "ספה", "ספה ומנורה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सोफ\u{93c}ा और ल\u{948}\u{902}प"),
            keywords: &[
                "ल\u{948}\u{902}प",
                "सोफ\u{93c}ा",
                "सोफ\u{93c}ा और ल\u{948}\u{902}प",
                "होटल",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kauč i svjetiljka"),
            keywords: &["hotel", "kauč", "kauč i svjetiljka", "svjetiljka"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kanapé és lámpa"),
            keywords: &["kanapé", "kanapé és lámpa", "lámpa", "szálloda"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բազմոց և լամպ"),
            keywords: &["բազմոց", "բազմոց և լամպ", "լամպ", "հյուրանոց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("sofa dan lampu"),
            keywords: &["hotel", "lampu", "sofa", "sofa dan lampu"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("oche na mpanaka"),
            keywords: &["mpanaka", "oche", "oche na mpanaka", "ụlọ nkwarị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sófi og lampi"),
            keywords: &["hótel", "lampi", "sófi", "sófi og lampi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("divano e lampada"),
            keywords: &["divano", "divano e lampada", "relax", "salotto"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ソファとランプ"),
            keywords: &["ソファ", "ソファとランプ", "ホテル", "ランプ"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sofa lan lampu"),
            keywords: &["hotel", "lampu", "sofa", "sofa lan lampu"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დივანი და ლამპა"),
            keywords: &["დივანი", "დივანი და ლამპა", "ლამპა", "სასტუმრო"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("диван мен шам"),
            keywords: &["диван", "диван мен шам", "шам", "қонақ үй"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("sofa og lampe"),
            keywords: &["hotel", "lampe", "sofa", "sofa og lampe"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សាឡ\u{17bb}ងន\u{17b7}ងអ\u{17c6}ព\u{17bc}ល"),
            keywords: &[
                "សាឡ\u{17bb}ង",
                "សាឡ\u{17bb}ងន\u{17b7}ងអ\u{17c6}ព\u{17bc}ល",
                "អ\u{17c6}ព\u{17bc}ល",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸೋಫಾ ಮತ\u{ccd}ತು ಲ\u{ccd}ಯಾಂಪ\u{ccd}"),
            keywords: &[
                "ಕೋಚ\u{ccd}",
                "ಲ\u{ccd}ಯಾಂಪು ಮತ\u{ccd}ತು ಸೋಫಾ",
                "ಸೋಫಾ ಮತ\u{ccd}ತು ಲ\u{ccd}ಯಾಂಪ\u{ccd}",
                "ಹೊಟೇಲ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("소파와 전등"),
            keywords: &["소파", "소파와 전등", "전등"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("कोच आनी ल\u{945}म\u{94d}प"),
            keywords: &[
                "कोच",
                "कोच आनी ल\u{945}म\u{94d}प",
                "ल\u{945}म\u{94d}प",
                "हॉट\u{947}ल",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("софа жана лампа"),
            keywords: &["лампа", "мейманкана", "софа", "софа жана лампа"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Couche a Luucht"),
            keywords: &["Couche", "Couche a Luucht", "Hotel", "Luucht"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໂຊຟາກ\u{eb1}ບໂຄມໄຟ"),
            keywords: &["ໂຄມໄຟ", "ໂຊຟາ", "ໂຊຟາກ\u{eb1}ບໂຄມໄຟ", "ໂຮງແຮມ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("sofa ir lempa"),
            keywords: &["lempa", "sofa", "sofa ir lempa", "viešbutis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("dīvāns un lampa"),
            keywords: &["dīvāns", "dīvāns un lampa", "lampa", "viesnīca"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("nohoanga roa me te rama"),
            keywords: &["hōtēra", "nohoanga roa", "nohoanga roa me te rama", "rama"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("кауч и ламба"),
            keywords: &["кауч", "кауч и ламба", "ламба", "хотел"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കിടക\u{d4d}കയ\u{d41}ം വിളക\u{d4d}ക\u{d41}ം"),
            keywords: &[
                "കിടക\u{d4d}ക",
                "കിടക\u{d4d}കയ\u{d41}ം വിളക\u{d4d}ക\u{d41}ം",
                "വിളക\u{d4d}ക\u{d4d}",
                "ഹോട\u{d4d}ടൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("буйдан, ширээний гэрэл"),
            keywords: &["буйдан", "буйдан, ширээний гэрэл", "ширээний гэрэл"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("काऊच आणि दिवा"),
            keywords: &["काऊच", "काऊच आणि दिवा", "दिवा", "हॉट\u{947}ल"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("sofa dan lampu"),
            keywords: &["hotel", "lampu", "sofa", "sofa dan lampu"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("sufan u lampa"),
            keywords: &["fanal", "lukanda", "sufan", "sufan u lampa"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ဆ\u{102d}\u{102f}ဖာန\u{103e}င\u{1037}\u{103a} မ\u{102e}းတ\u{102d}\u{102f}င\u{103a}",
            ),
            keywords: &[
                "ဆ\u{102d}\u{102f}ဖာ",
                "ဆ\u{102d}\u{102f}ဖာန\u{103e}င\u{1037}\u{103a} မ\u{102e}းတ\u{102d}\u{102f}င\u{103a}",
                "မ\u{102e}းတ\u{102d}\u{102f}င\u{103a}",
                "ဟ\u{102d}\u{102f}တယ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sofa og lampe"),
            keywords: &["hotell", "lampe", "sofa", "sofa og lampe"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कउच र बत\u{94d}ती"),
            keywords: &["कउच", "कउच र बत\u{94d}ती", "बत\u{94d}ती", "होट\u{947}ल"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bank en lamp"),
            keywords: &["bank", "bank en lamp", "hotel", "lamp"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("sofa og lampe"),
            keywords: &["hotell", "lampe", "sofa", "sofa og lampe"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b3e}ଉଚ\u{b4d}\u{200c} ଏବଂ ବତ\u{b3f}"),
            keywords: &[
                "କ\u{b3e}ଉଚ\u{b4d}\u{200c}",
                "କ\u{b3e}ଉଚ\u{b4d}\u{200c} ଏବଂ ବତ\u{b3f}",
                "ବତ\u{b3f}",
                "ହୋଟେଲ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a4b}ਫਾ ਅਤ\u{a47} ਲ\u{a48}\u{a02}ਪ"),
            keywords: &[
                "ਜੀਵਨ-ਸ\u{a3c}\u{a48}ਲੀ",
                "ਫਰਨੀਚਰ",
                "ਲ\u{a48}\u{a02}ਪ",
                "ਸ\u{a4b}ਫਾ",
                "ਸ\u{a4b}ਫਾ ਅਤ\u{a47} ਲ\u{a48}\u{a02}ਪ",
                "ਹ\u{a4b}ਟਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("صوفہ اتے چراغ"),
            keywords: &["صوفہ", "صوفہ اتے چراغ", "لیمپ", "ہوٹل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Sẹtii An Lamp"),
            keywords: &[
                "Hotẹl",
                "Kauch",
                "Lait",
                "Sófa",
                "Sófa An Lait",
                "Sẹtii",
                "Sẹtii An Lamp",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kanapa i lampa"),
            keywords: &["hotel", "kanapa", "kanapa i lampa", "lampa"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سوفه او څراغ"),
            keywords: &["سوفه", "سوفه او څراغ", "سوفې او څراغ", "هوتل", "څراغ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("sofá e luminária"),
            keywords: &["hotel", "lâmpada", "sofá", "sofá e luminária"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("sofá e candeeiro"),
            keywords: &["candeeiro", "hotel", "sofá", "sofá e candeeiro"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("canapea și lampă"),
            keywords: &["canapea", "canapea și lampă", "hotel", "lampă", "lumină"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-986"),
            keywords: &["E10-986"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("диван и торшер"),
            keywords: &["диван", "диван и торшер", "лампа", "торшер", "уют"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ifoteyi n’itara"),
            keywords: &["hoteli", "ifoteyi", "ifoteyi n’itara", "itara"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("صوفو ۽ بتي"),
            keywords: &["بتي", "صوفو", "صوفو ۽ بتي", "هوٽل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dd4}ඩ\u{dcf} ඇඳ සහ ල\u{dcf}ම\u{dca}ප\u{dd4}ව"),
            keywords: &[
                "කව\u{dd2}ච\u{dca}ච\u{dd2}ය",
                "ක\u{dd4}ඩ\u{dcf} ඇඳ සහ ල\u{dcf}ම\u{dca}ප\u{dd4}ව",
                "ල\u{dcf}ම\u{dca}ප\u{dd4}ව",
                "හෝටලය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("gauč a lampa"),
            keywords: &["gauč", "gauč a lampa", "hotel", "lampa"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kavč in svetilka"),
            keywords: &["hotel", "kavč", "kavč in svetilka", "svetilka"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("fadhi iyo laambad"),
            keywords: &["fadhi", "fadhi iyo laambad", "hudheel"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("divan dhe llambë"),
            keywords: &["divan", "divan dhe llambë", "hotel", "llambë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кауч и лампа"),
            keywords: &["кaуч", "кауч и лампа", "лампа", "хoтeл"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kauč i lampa"),
            keywords: &["hotel", "kauč", "kauč i lampa", "lampa"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("soffa och lampa"),
            keywords: &["hotell", "lampa", "soffa", "soffa och lampa"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kochi na taa"),
            keywords: &["hoteli", "kochi", "kochi na taa", "taa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மின\u{bcd}விளக\u{bcd}கும\u{bcd} படுக\u{bcd}கையும\u{bcd}"),
            keywords: &[
                "படுக\u{bcd}கை",
                "மின\u{bcd}விளக\u{bcd}கு",
                "மின\u{bcd}விளக\u{bcd}குடன\u{bcd} படுக\u{bcd}கை",
                "மின\u{bcd}விளக\u{bcd}கும\u{bcd} படுக\u{bcd}கையும\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c4b}ఫ\u{c3e} మర\u{c3f}యు ల\u{c4d}య\u{c3e}ంప\u{c4d}"),
            keywords: &[
                "ల\u{c4d}య\u{c3e}ంప\u{c4d}",
                "స\u{c4b}ఫ\u{c3e}",
                "స\u{c4b}ఫ\u{c3e} మర\u{c3f}యు ల\u{c4d}య\u{c3e}ంప\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("диван ва чароғ"),
            keywords: &["диван", "диван ва чароғ", "меҳмонхона", "чароғ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("โซฟาก\u{e31}บโคมไฟ"),
            keywords: &["โคมไฟ", "โซฟา", "โซฟาก\u{e31}บโคมไฟ", "โรงแรม"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("diwan we çyra"),
            keywords: &["diwan", "diwan we çyra", "myhmanhana", "çyra"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sea mālōlōʻanga moe maama"),
            keywords: &["sea mālōlōʻanga moe maama"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kanepe ve lamba"),
            keywords: &["kanepe", "kanepe ve lamba", "lamba", "otel"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("دىۋان ۋە چىراق"),
            keywords: &["دىۋان", "دىۋان ۋە چىراق", "مېھمانخانا", "چىراق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("канапа й торшер"),
            keywords: &["готель", "диван", "канапа й торшер", "лампа"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کاؤچ اور لیمپ"),
            keywords: &["لیمپ", "کاؤچ", "کاؤچ اور لیمپ", "ہوٹل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("divan va lampa"),
            keywords: &["chiroq", "divan", "divan va lampa", "lampa", "mehmonxona"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ghế dài và đèn"),
            keywords: &["ghế dài và đèn", "khách sạn", "đi văng", "đèn"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanape and làmp"),
            keywords: &["kanape", "kanape and làmp", "làmp", "otel"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isofa nesibane"),
            keywords: &["ihotele", "isibane", "isofa", "isofa nesibane"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ìjókò àti àtùpà"),
            keywords: &["ilé ìtura", "àtùpà", "ìjókò", "ìjókò àti àtùpà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("沙發和座燈"),
            keywords: &["座燈", "沙發", "沙發和座燈", "酒店"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("沙发和座灯"),
            keywords: &["座灯", "沙发", "沙发和座灯", "酒店"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("沙发和灯"),
            keywords: &["家", "沙发", "沙发和灯", "灯", "阅读"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("沙發和立燈"),
            keywords: &["沙發", "沙發和立燈", "立燈"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("梳化和座地燈"),
            keywords: &["梳化和座地燈", "梳化｜座地燈"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("usofa ilambu"),
            keywords: &["ihhotela", "ilambu", "usofa"],
        },
    ],
};
#[doc = "🪑"]
pub const CHAIR: crate::Emoji = crate::Emoji {
    glyph: "🪑",
    codepoint: "1FA91",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "chair",
    group: "Objects",
    subgroup: "household",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("stoel"),
            keywords: &["sit", "sitplek", "stoel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መቀመጫ"),
            keywords: &["መቀመጫ", "ተቀመጠ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كرسي"),
            keywords: &["جلوس", "قعود", "كرسي", "مقعد"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চকী"),
            keywords: &["আসন", "চকী", "বহ\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("stul"),
            keywords: &["oturacaq", "oturmaq", "stul"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("крэсла"),
            keywords: &["крэсла", "месца", "сядзець"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("стол"),
            keywords: &["седене", "стол", "сядане"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চেয\u{9bc}\u{9be}র"),
            keywords: &["চেয\u{9bc}\u{9be}র", "বস\u{9be}র জ\u{9be}য\u{9bc}গ\u{9be}"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kador"),
            keywords: &["azezenn", "kador"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("stolica"),
            keywords: &["sjedalo", "sjediti", "sjedište", "stolica"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cadira"),
            keywords: &["cadira", "seient", "seure"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏍᎩᎶ"),
            keywords: &["ᎤᏬᏝ", "ᎦᏍᎩᎶ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("židle"),
            keywords: &[
                "posezení",
                "sedadlo",
                "sedačka",
                "sedátko",
                "sedět",
                "sezení",
                "židle",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cadair"),
            keywords: &["cadair", "eistedd", "sedd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("stol"),
            keywords: &["stol"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Stuhl"),
            keywords: &["Stuhl", "sitzen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καρέκλα"),
            keywords: &["θέση", "κάθισμα", "κάθομαι", "καρέκλα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("chair"),
            keywords: &["chair", "seat", "sit"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("silla"),
            keywords: &["asiento", "sentarse", "silla"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("tool"),
            keywords: &["iste", "istumine", "tool"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("aulki"),
            keywords: &["aulki", "eserleku", "jarleku"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("صندلی"),
            keywords: &["صندلی", "نشستن", "نیمکت"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tuoli"),
            keywords: &["istua", "istuin", "istumapaikka", "tuoli"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("silya"),
            keywords: &["silya", "umupo", "upuan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("stólur"),
            keywords: &["sessur", "setur", "stólur", "sæti"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("chaise"),
            keywords: &["assis", "chaise", "siège"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cathaoir"),
            keywords: &["cathaoir", "suí", "suíochán"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sèithear"),
            keywords: &["cathair", "suidhe", "suidheachan", "sèithear"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cadeira"),
            keywords: &["asento", "cadeira", "sentar"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ખ\u{ac1}રશી"),
            keywords: &["ખ\u{ac1}રશી", "બ\u{ac7}ઠક", "બ\u{ac7}સો"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כיסא"),
            keywords: &["ישיבה", "כיסא", "כסא", "לשבת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("क\u{941}र\u{94d}सी"),
            keywords: &["क\u{941}र\u{94d}सी", "च\u{947}यर", "फ\u{93c}र\u{94d}निचर"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("stolica"),
            keywords: &["sjediti", "sjesti", "stolica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szék"),
            keywords: &["szék", "ül", "ülés"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("աթոռ"),
            keywords: &["աթոռ", "նստատեղ", "նստել"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bangku"),
            keywords: &["bangku", "duduk", "kursi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("stóll"),
            keywords: &["setjast", "sitja", "stóll"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("sedia"),
            keywords: &["mettersi seduti", "sedersi", "sedia"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("椅子"),
            keywords: &["シート", "チェア", "家具", "椅子", "腰掛け"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kursi"),
            keywords: &["jagongan", "kursi", "njagong"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სკამი"),
            keywords: &["დასვენება", "დაჯდომა", "სკამი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("арқалығы бар орындық"),
            keywords: &["арқалығы бар орындық", "орын", "отыру"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កៅអ\u{17b8}"),
            keywords: &["កៅអ\u{17b8}", "អង\u{17d2}គ\u{17bb}យ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕುರ\u{ccd}ಚ\u{cbf}"),
            keywords: &[
                "ಕುರ\u{ccd}ಚ\u{cbf}",
                "ಕುಳ\u{cbf}ತುಕೊಳ\u{ccd}ಳ\u{cbf}",
                "ಸೀಟ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("의자"),
            keywords: &["앉기", "의자"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("कद\u{947}ल"),
            keywords: &["कद\u{947}ल", "बस", "सीट"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("стул"),
            keywords: &["орун", "отур", "стул"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຕ\u{eb1}\u{ec8}ງ"),
            keywords: &[
                "ຕ\u{eb1}\u{ec8}ງ",
                "ຕ\u{eb1}\u{ec8}ງ\u{200b}ນ\u{eb1}\u{ec8}ງ",
                "ນ\u{eb1}\u{ec8}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kėdė"),
            keywords: &["kėdė", "sėdėti"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("krēsls"),
            keywords: &["krēsls", "sēdeklis", "sēdēt"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("стол"),
            keywords: &["седи", "стол", "столица", "столче"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കസേര"),
            keywords: &["ഇരിക\u{d4d}ക\u{d41}ക", "കസേര", "സീറ\u{d4d}റ\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("сандал"),
            keywords: &["сандал", "суудал", "суух"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ख\u{941}र\u{94d}ची"),
            keywords: &["आसन", "ख\u{941}र\u{94d}ची", "बसण\u{947}"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kerusi"),
            keywords: &["duduk", "kerusi", "tempat duduk"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("က\u{102f}လားထ\u{102d}\u{102f}င\u{103a}"),
            keywords: &[
                "က\u{102f}လားထ\u{102d}\u{102f}င\u{103a}",
                "ထ\u{102d}\u{102f}င\u{103a}",
                "ထ\u{102d}\u{102f}င\u{103a}ခ\u{102f}\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("stol"),
            keywords: &["sete", "sitte", "sitteplass", "stol"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("क\u{941}र\u{94d}सी"),
            keywords: &[
                "क\u{941}र\u{94d}सी",
                "बस\u{94d}न\u{941}",
                "बस\u{94d}न\u{947} ठाउ\u{901}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("hoge stoel"),
            keywords: &["hoge stoel", "stoel", "zitten"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("stol"),
            keywords: &["sete", "sitje", "sitjeplass", "stol"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଚୌକ\u{b3f}"),
            keywords: &["ଚୌକ\u{b3f}", "ବସ\u{b3f}ବ\u{b3e}", "ବସ\u{b3f}ବ\u{b3e} ଆସନ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a41}ਰਸੀ"),
            keywords: &["ਕ\u{a41}ਰਸੀ", "ਬ\u{a48}ਠਣਾ", "ਸੀਟ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Chia"),
            keywords: &["Chia", "Sit"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("krzesło"),
            keywords: &["krzesło", "siadać", "siedzenie"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("چوکۍ"),
            keywords: &["سيټ", "چوکۍ", "کښيناستل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cadeira"),
            keywords: &["assento", "cadeira", "sentar"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cadeira"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("scaun"),
            keywords: &["loc", "scaun"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–070"),
            keywords: &["E12–070"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("стул"),
            keywords: &["сидение", "сидеть", "сидя", "стул", "стулья"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪرسي"),
            keywords: &["سيٽ", "ويهو", "ڪرسي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd4}ට\u{dd4}ව"),
            keywords: &["අස\u{dd4}න", "ඉඳ ගැන\u{dd3}ම", "ප\u{dd4}ට\u{dd4}ව"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("stolička"),
            keywords: &["sedadlo", "sedenie", "sedieť", "stolička"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("stol"),
            keywords: &["sedeti", "sedež", "stol"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kursi"),
            keywords: &["fadhi", "fariiso", "kursi"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("karrige"),
            keywords: &["karrige", "rri ulur", "ulëse"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("столица"),
            keywords: &["место", "седиште", "столица"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["столица"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("stolica"),
            keywords: &["mesto", "sedište", "stolica"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["stolica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("stol"),
            keywords: &["sitta", "stol", "säte"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kiti"),
            keywords: &["keti", "kiti"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மர ந\u{bbe}ற\u{bcd}க\u{bbe}லி"),
            keywords: &[
                "இருக\u{bcd}கை",
                "உட\u{bcd}க\u{bbe}ருதல\u{bcd}",
                "மர ந\u{bbe}ற\u{bcd}க\u{bbe}லி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కుర\u{c4d}చ\u{c40}"),
            keywords: &["కుర\u{c4d}చ\u{c40}", "కూర\u{c4d}చ\u{c4b}వడం", "స\u{c40}టు"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เก\u{e49}าอ\u{e35}\u{e49}"),
            keywords: &[
                "ท\u{e35}\u{e48}น\u{e31}\u{e48}ง",
                "น\u{e31}\u{e48}ง",
                "เก\u{e49}าอ\u{e35}\u{e49}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("oturgyç"),
            keywords: &["otur", "oturgyç", "oturylýan ýer"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sea"),
            keywords: &["sea"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sandalye"),
            keywords: &["iskemle", "oturma", "sandalye"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("стілець"),
            keywords: &["сидіння", "сидіти", "стілець"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کرسی"),
            keywords: &["بیٹھنا", "سیٹ", "کرسی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("stul"),
            keywords: &["kursi", "oʻtirish", "stul"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ghế"),
            keywords: &["chỗ ngồi", "ghế", "ngồi"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("櫈"),
            keywords: &["坐", "櫈"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("櫈"),
            keywords: &["坐", "櫈"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("椅子"),
            keywords: &["坐", "座位", "椅子", "椅背"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("椅子"),
            keywords: &["坐", "椅子"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isitulo"),
            keywords: &["hlala", "isihlalo", "isitulo"],
        },
    ],
};
#[doc = "🚽"]
pub const TOILET: crate::Emoji = crate::Emoji {
    glyph: "🚽",
    codepoint: "1F6BD",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "toilet",
    group: "Objects",
    subgroup: "household",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("toilet"),
            keywords: &["toilet", "toiletbak"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሽንት ቤት"),
            keywords: &["ሽንት ቤት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مرحاض"),
            keywords: &["حمام", "مرحاض"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("শৌচ\u{9be}গ\u{9be}ৰ"),
            keywords: &["টয\u{9bc}লেট", "শৌচ\u{9be}গ\u{9be}ৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("tualet"),
            keywords: &["tualet"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("унітаз"),
            keywords: &["туалет", "унітаз"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("тоалетна чиния"),
            keywords: &["тоалетна", "тоалетна чиния"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("শৌচ\u{9be}গ\u{9be}র"),
            keywords: &["টয\u{9bc}লেট", "শৌচ\u{9be}গ\u{9be}র"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("privezioù"),
            keywords: &["privezioù"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("wc šolja"),
            keywords: &["toalet", "wc", "wc šolja"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("lavabo"),
            keywords: &["inodor", "lavabo", "tassa", "vàter"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏙᏱ ᎡᏓᏍᏗ"),
            keywords: &["ᏙᏱ ᎡᏓᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("toaletní mísa"),
            keywords: &["WC", "klozet", "toaleta", "toaletní mísa", "záchod"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("toiled"),
            keywords: &["toiled"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("toilet"),
            keywords: &["toilet", "wc"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Toilette"),
            keywords: &["Toilette", "WC"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τουαλέτα"),
            keywords: &["λεκάνη", "τουαλέτα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("toilet"),
            keywords: &["toilet"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["lavatory", "loo", "toilet"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["WC", "facilities", "loo", "toilet"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["lavatory", "toilet"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("inodoro"),
            keywords: &["baño", "inodoro", "váter", "wc"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["baño", "escusado", "inodoro", "retrete"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("WC-pott"),
            keywords: &["WC-pott", "tualett", "wc"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bainugela"),
            keywords: &["bainugela", "komuna"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("توالت"),
            keywords: &["توالت", "دستشویی", "مستراح"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vessanpönttö"),
            keywords: &["vessa", "vessanpönttö"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("inodoro"),
            keywords: &["banyo", "cr", "inodoro", "palikuran"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("ves"),
            keywords: &["kumma", "toilett", "ves"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("toilettes"),
            keywords: &["toilettes"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("siège de toilette"),
            keywords: &["cabinet de toilette", "siège de toilette", "toilettes"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("leithreas"),
            keywords: &["leithreas"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("taigh-beag"),
            keywords: &["taigh-beag"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("váter"),
            keywords: &["inodoro", "retrete", "váter"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ટૉઇલ\u{ac7}ટ"),
            keywords: &["ટૉઇલ\u{ac7}ટ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ban-ɗaki"),
            keywords: &["ban-ɗaki"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אסלה"),
            keywords: &["אסלה", "שירותים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("शौचालय"),
            keywords: &["शौचालय"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("WC školjka"),
            keywords: &["WC školjka", "kupaonica", "toalet"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("vécé"),
            keywords: &["mosdó", "toalett", "vécé"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("զուգարանակոնք"),
            keywords: &["զուգարան", "զուգարանակոնք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("toilet"),
            keywords: &["toilet"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụlọ mpochi"),
            keywords: &["ụlọ mpochi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("klósett"),
            keywords: &["klósett", "salerni"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("toilette"),
            keywords: &["toilette", "water"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("便器"),
            keywords: &["お手洗い", "トイレ", "便器", "便座"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kakus"),
            keywords: &["kakus"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ტუალეტი"),
            keywords: &["საპირფარეშო", "ტუალეტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("унитаз"),
            keywords: &["унитаз"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("toilet"),
            keywords: &["toilet", "wc"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បង\u{17d2}គន\u{17cb}"),
            keywords: &["បង\u{17d2}គន\u{17cb}", "បន\u{17d2}ទោរបង\u{17cb}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಶ\u{ccc}ಚಾಲಯ"),
            keywords: &["ಶ\u{ccc}ಚ ಗೃಹ", "ಶ\u{ccc}ಚಾಲಯ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("변기"),
            keywords: &["변기"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("टॉयल\u{947}ट"),
            keywords: &["टॉयल\u{947}ट"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("туалет"),
            keywords: &["даараткана", "туалет"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Toilett"),
            keywords: &["Toilett"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ວ\u{eb4}ດຖ\u{ec8}າຍ"),
            keywords: &[
                "ວ\u{eb4}ດ",
                "ວ\u{eb4}ດຖ\u{ec8}າຍ",
                "ຫ\u{ec9}ອງນ\u{ecd}\u{ec9}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("tualetas"),
            keywords: &["tualetas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("tualetes pods"),
            keywords: &["pods", "tualete", "tualetes pods"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("heketua"),
            keywords: &["heketua"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("тоалетна школка"),
            keywords: &["тоалет", "тоалетна школка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ടോയ\u{d4d}\u{200c}ലറ\u{d4d}റ\u{d4d}"),
            keywords: &["ടോയ\u{d4d}\u{200c}ലറ\u{d4d}റ\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("жорлон"),
            keywords: &["жорлон"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("शौचालय"),
            keywords: &["शौचालय"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("mangkuk tandas"),
            keywords: &["mangkuk tandas", "tandas"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("toilet"),
            keywords: &["toilet"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အ\u{102d}မ\u{103a}သာ"),
            keywords: &["အ\u{102d}မ\u{103a}သာ"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("toalett"),
            keywords: &["dass", "do", "toalett", "vannklosett", "wc"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("चर\u{94d}पी"),
            keywords: &["चर\u{94d}पी"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("toilet"),
            keywords: &["toilet", "wc"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("toalett"),
            keywords: &["dass", "do", "toalett", "vassklosett", "wc"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b3e}ଇଖ\u{b3e}ନ\u{b3e}"),
            keywords: &["ଟଏଲେଟ\u{b4d}", "ପ\u{b3e}ଇଖ\u{b3e}ନ\u{b3e}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਗ\u{a41}ਸਲਖ\u{a3c}ਾਨਾ"),
            keywords: &["ਗ\u{a41}ਸਲਖ\u{a3c}ਾਨਾ", "ਟ\u{a4b}ਆਇਲਟ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بیت الخلا"),
            keywords: &["بیت الخلا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wọ\u{301}tá Sístẹm"),
            keywords: &["Toílẹt", "Wọ\u{301}tá Sístẹm"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("muszla klozetowa"),
            keywords: &[
                "dolnopłuk",
                "muszla klozetowa",
                "sedes",
                "toaleta",
                "ubikacja",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("تشناب"),
            keywords: &["تشناب"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("vaso sanitário"),
            keywords: &[
                "banheiro",
                "privada",
                "sanitário",
                "toalete",
                "vaso sanitário",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("sanita"),
            keywords: &["casa de banho", "sanita"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("toaletă"),
            keywords: &["toaletă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-977"),
            keywords: &["E10-977"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("унитаз"),
            keywords: &["бачок", "туалет", "унитаз"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umusarane"),
            keywords: &["umusarane"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بيت الاخلا"),
            keywords: &["بيت الاخلا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වැස\u{dd2}ක\u{dd2}ළ\u{dd2}ය"),
            keywords: &["වැස\u{dd2}ක\u{dd2}ළ\u{dd2}ය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("záchod"),
            keywords: &["toaleta", "záchod"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("straniščna školjka"),
            keywords: &["stranišče", "straniščna školjka"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("musqul"),
            keywords: &["musqul"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("tualet"),
            keywords: &["tualet"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("ве-це шоља"),
            keywords: &["ве-це шоља"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["ве-це шоља"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ve-ce šolja"),
            keywords: &["ve-ce šolja"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["ve-ce šolja"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("toalett"),
            keywords: &["toalett"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("choo"),
            keywords: &["choo", "maliwato"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கழிப\u{bcd}பறை"),
            keywords: &["கழிப\u{bcd}பறை", "ட\u{bbe}ய\u{bcd}லட\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ట\u{c3e}య\u{c3f}\u{200c}ల\u{c46}ట\u{c4d}"),
            keywords: &["ట\u{c3e}య\u{c3f}\u{200c}ల\u{c46}ట\u{c4d}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҳоҷатхона"),
            keywords: &["ҳоҷатхона"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("โถส\u{e49}วม"),
            keywords: &["ห\u{e49}องน\u{e49}ำ", "โถส\u{e49}วม"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("hajathana"),
            keywords: &["hajathana"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("po toileti"),
            keywords: &["po toileti"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("klozet"),
            keywords: &["WC", "klozet", "tuvalet"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ھاجەتخانا"),
            keywords: &["ھاجەتخانا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("унітаз"),
            keywords: &["туалет", "унітаз"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بیت الخلا"),
            keywords: &["بیت الخلا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tualet"),
            keywords: &["hojatxona", "tualet"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bồn cầu"),
            keywords: &["bệ xí", "bồn cầu"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("wanag"),
            keywords: &["wanag"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ithoyilethi"),
            keywords: &["ithoyilethi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ilé ìgbẹ\u{301}"),
            keywords: &["Ilé ìgbẹ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("廁所"),
            keywords: &["廁所"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("厕所"),
            keywords: &["厕所"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("马桶"),
            keywords: &["WC", "卫生间", "厕所", "洗手间", "马桶"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("馬桶"),
            keywords: &["廁所", "馬桶"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("廁所"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("indlu yangasese"),
            keywords: &["indlu yangasese"],
        },
    ],
};
#[doc = "🪠"]
pub const PLUNGER: crate::Emoji = crate::Emoji {
    glyph: "🪠",
    codepoint: "1FAA0",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "plunger",
    group: "Objects",
    subgroup: "household",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("druksuier"),
            keywords: &["druksuier", "loodgieter", "suigkrag", "toilet"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መወርወሪያ"),
            keywords: &["መወርወሪያ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مكبس غطاس"),
            keywords: &[
                "امتصاص",
                "حمام",
                "سباك",
                "سباكة",
                "ضغط",
                "مرحاض",
                "مكبس غطاس",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9cd}ল\u{9be}ংগ\u{9be}ৰ"),
            keywords: &[
                "প\u{9cd}ল\u{9be}ংগ\u{9be}ৰ",
                "প\u{9cd}ল\u{9be}ম\u{9cd}ব\u{9be}ৰ",
                "ফ’ৰ\u{9cd}চ ক\u{9be}প",
                "শোষণ",
                "শৌচ\u{9be}লয\u{9bc}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("porşen"),
            keywords: &["lehimçi", "porşen", "sorma", "tualet", "vantuz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("вантуз"),
            keywords: &["адпампоўваць", "вантуз", "сантэхнік", "туалет"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("вакуумна помпа за отпушване"),
            keywords: &[
                "вакуумна помпа за отпушване",
                "водопроводчик",
                "изсмукване",
                "плунжер",
                "тоалетна",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9cd}ল\u{9be}নজ\u{9be}র"),
            keywords: &[
                "চোষণ",
                "টয\u{9bc}লেট",
                "প\u{9cd}ল\u{9be}নজ\u{9be}র",
                "প\u{9cd}ল\u{9be}মব\u{9be}র",
                "ফোর\u{9cd}স ক\u{9be}প",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("mandoz"),
            keywords: &["mandoz", "plomer", "privezioù"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("pumpa za odčepljivanje odvoda"),
            keywords: &[
                "kupatilo",
                "odčepljivanje odvoda",
                "odčepljivač odvoda",
                "pumpa za odčepljivanje odvoda",
                "toalet",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("desembossador"),
            keywords: &["desembossador", "embós", "lampista", "lavabo", "succió"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏙᏱ ᎡᏓᏍᏘᏱ ᎪᎱᏍᏗ ᎬᏔᏂᏓᏍᏗ"),
            keywords: &[
                "ᎤᏓᏅᎦᎸᏓ",
                "ᎤᏝᏂᎬᎬ ᎠᎫᎩᏍᏗ",
                "ᏙᏱ ᎡᏓᏍᏘᏱ ᎪᎱᏍᏗ ᎬᏔᏂᏓᏍᏗ",
                "ᏧᏒᏙᏂ ᎣᏍᏓ ᏱᏗᎬᏁᎯ",
                "ᏧᏒᏙᏂ ᎣᏍᏓ ᏱᏗᎬᏁᎯ ᎠᎵᏍᏕᎵᏍᎩ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zvon na WC"),
            keywords: &[
                "instalatér",
                "podtlak",
                "toaleta",
                "ucpaný",
                "zvon na WC",
                "záchod",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("offeryn sugno"),
            keywords: &[
                "cwpan rym",
                "offeryn sugno",
                "plymiwr",
                "plymwr",
                "sugnedd",
                "toiled",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("svupper"),
            keywords: &[
                "blikkenslager",
                "stoppet afløb",
                "suge",
                "sugekop",
                "svupper",
                "toilet",
                "vvs",
                "vvs-tekniker",
                "wc",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Saugglocke"),
            keywords: &["Saugglocke", "Saugglocken", "Toilette", "verstopft"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Saugglocke"),
            keywords: &["Klempner", "Pümpel", "Sanitär", "Saugglocke", "WC"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("βεντούζα απόφραξης"),
            keywords: &["αναρρόφηση", "βεντούζα απόφραξης", "τουαλέτα", "υδραυλικός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("plunger"),
            keywords: &["force cup", "plumber", "plunger", "suction", "toilet"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("desatascador"),
            keywords: &[
                "desatascador",
                "fontanero",
                "retrete",
                "servicio",
                "succión",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("destapacaños"),
            keywords: &["destapacaños"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("valamupump"),
            keywords: &[
                "imipump",
                "pump",
                "pumpamine",
                "ummistus",
                "valamu",
                "valamupump",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("libragailu"),
            keywords: &["libragailu", "libragailua", "libratu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("لوله\u{200c}بازکن"),
            keywords: &[
                "توالت",
                "لوله\u{200c}بازکن",
                "لوله\u{200c}کش",
                "مکش",
                "مکینه",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("viemäripumppu"),
            keywords: &["WC", "imukuppi", "putkimies", "viemäripumppu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("plunger"),
            keywords: &["kubeta", "plunger"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("súgvari"),
            keywords: &["kumma", "súgvari", "toilett", "typt", "ves"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("ventouse"),
            keywords: &["déboucheur", "plombier", "succion", "toilettes", "ventouse"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("ventouse"),
            keywords: &["force", "plombier", "succion", "toilette", "ventouse"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("suncaire"),
            keywords: &["leithreas", "pluiméir", "suncaire"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("loinid"),
            keywords: &["loinid", "plumair", "sùghadh", "taigh-beag"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("desatascador"),
            keywords: &["desatascador", "desatoador", "fontaneiro"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{acd}લ\u{a82}જર"),
            keywords: &[
                "ચ\u{ac2}સણ",
                "પ\u{acd}લ\u{a82}જર",
                "પ\u{acd}લમ\u{acd}બર",
                "ફોર\u{acd}સ કપ",
                "શૌચાલય",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פומפה"),
            keywords: &[
                "אינסטלטור",
                "פומפה",
                "פמפמת",
                "פתיחת סתימות",
                "שירותים",
                "שרברב",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पिस\u{94d}टन"),
            keywords: &[
                "टॉयल\u{947}ट",
                "नलसाज\u{93c}",
                "पिस\u{94d}टन",
                "फ\u{93c}ोर\u{94d}स कप",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("odčepljivač"),
            keywords: &[
                "WC",
                "odčepljivanje",
                "odčepljivač",
                "vakuum",
                "vodoinstalater",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("vécépumpa"),
            keywords: &["dugulás", "vécé", "vécépumpa", "vízvezeték-szerelő", "wc"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("վանտուզ"),
            keywords: &["զուգարան", "խցանում", "ջրմուղ", "սանհանգույց", "վանտուզ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("penyedot wc"),
            keywords: &["penyedot", "penyedot wc", "toilet", "tukang ledeng"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("drullusokkur"),
            keywords: &["drullusokkur", "klósett", "pípulagningar", "salerni"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("sturalavandini"),
            keywords: &[
                "aspirazione",
                "idraulico",
                "scarico",
                "sturalavandini",
                "ventosa",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ラバーカップ"),
            keywords: &[
                "すっぽん",
                "トイレ",
                "プランジャー",
                "ラバーカップ",
                "吸引カップ",
                "通水カップ",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("panyedot kakus"),
            keywords: &["kakus", "panyedot kakus", "panyedotan", "tukang pipa"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დგუში"),
            keywords: &["ამოტუმბვა", "დგუში", "პლუნჟერი", "ტუალეტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("вантуз"),
            keywords: &["вантуз", "дәретхана", "сантехник-слесарь", "сору"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17c6}ពង\u{17cb}ប\u{17c6}បាត\u{17cb}ស\u{17d2}ទះ"),
            keywords: &[
                "ជាងទ\u{17bb}យោ",
                "បង\u{17d2}គន\u{17cb}",
                "ប\u{17c6}ពង\u{17cb}ប\u{17c6}បាត\u{17cb}ស\u{17d2}ទះ",
                "ប\u{17d2}រដាប\u{17cb}ប\u{17ba}ត",
                "ប\u{17d2}រដាប\u{17cb}ប\u{17ba}តក\u{17c6}ណកស\u{17d2}ទះ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪ\u{ccd}ಲಂಗರ\u{ccd}\u{200c}"),
            keywords: &[
                "ಕೊಳಾಯ\u{cbf}ಗಾರ",
                "ಪ\u{ccd}ಲಂಗರ\u{ccd}\u{200c}",
                "ಫೋರ\u{ccd}ಸ\u{ccd} ಕಪ\u{ccd}",
                "ಶ\u{ccc}ಚಾಲಯ",
                "ಹೀರುವ\u{cbf}ಕ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("뚫어뻥"),
            keywords: &["뚫어뻥", "배관공", "변기", "화장실", "흡입"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("प\u{94d}ल\u{902}गर"),
            keywords: &[
                "टॉयल\u{947}ट",
                "प\u{94d}ल\u{902}गर",
                "प\u{94d}ल\u{902}बर",
                "फोर\u{94d}स कप",
                "सक\u{94d}शन",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("вантуз"),
            keywords: &["вантуз"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{eb9}ກສ\u{eb9}ບ"),
            keywords: &[
                "ຖ\u{ec9}ວຍໄວ\u{ec9}ດ\u{eb1}ນ",
                "ປ\u{ec9}ຳ",
                "ລ\u{eb9}ກສ\u{eb9}ບ",
                "ຫ\u{ec9}ອງນຳ\u{ec9}",
                "ອ\u{eb1}ນດ\u{eb9}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("santechninė pompa"),
            keywords: &["santechnikas", "santechninė pompa", "siurbimas", "tualetas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vantūzs"),
            keywords: &[
                "kanalizācijas buča",
                "santehniķis",
                "sūkšana",
                "tualete",
                "vantūzs",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("одзатнувач"),
            keywords: &["водоводџија", "одзатнувач", "тоалет"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d4d}ലഞ\u{d4d}ചർ"),
            keywords: &[
                "പ\u{d4d}ലംബർ",
                "പ\u{d4d}ലഞ\u{d4d}ചർ",
                "ഫോഴ\u{d4d}സ\u{d4d} കപ\u{d4d}പ\u{d4d}",
                "വലിച\u{d4d}ചെട\u{d41}ക\u{d4d}കൽ",
                "ശ\u{d41}ചിമ\u{d41}റി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("жорлонгийн бөглөө гаргагч"),
            keywords: &[
                "бүлүүр",
                "жорлон",
                "жорлонгийн бөглөө гаргагч",
                "резинэн аяга",
                "сантехникч",
                "сорох",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{902}पाचा दट\u{94d}टया"),
            keywords: &[
                "प\u{902}पाचा दट\u{94d}टया",
                "प\u{94d}ल\u{902}बर",
                "फोर\u{94d}स कप",
                "शोष\u{942}न घ\u{947}ण\u{947}",
                "शौचालय",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pelocok"),
            keywords: &[
                "locok",
                "pelocok",
                "pembantu tukang paip",
                "penekup paksa",
                "tukang paip",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စ\u{102f}ပ\u{103a}ခ\u{103d}က\u{103a}"),
            keywords: &[
                "စ\u{102f}ပ\u{103a}ခ\u{103d}က\u{103a}",
                "ပ\u{102d}\u{102f}က\u{103a}ပြင\u{103a}သ\u{1030}",
                "အ\u{102d}မ\u{103a}သာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("avløpsåpner"),
            keywords: &["avløp", "avløpsåpner", "mekanisk", "toalett", "vask"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{94d}लन\u{94d}जर"),
            keywords: &[
                "प\u{94d}लन\u{94d}जर",
                "प\u{94d}लम\u{94d}बर",
                "फोर\u{94d}स कप",
                "शौचालय",
                "सक\u{94d}सन",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("ontstopper"),
            keywords: &["loodgieter", "ontstopper", "toilet", "zuiger", "zuigkracht"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("avløpsopnar"),
            keywords: &["avløp", "avløpsopnar", "mekanisk", "toalett", "vask"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b4d}ଲ\u{b41}ଙ\u{b4d}ଗର"),
            keywords: &[
                "ଚ\u{b41}ଷ\u{b3f}ବ\u{b3e}",
                "ପ\u{b3e}ଇପ\u{b4d}\u{200c} ମ\u{b3f}ସ\u{b4d}ତ\u{b4d}ରୀ",
                "ପ\u{b4d}ଲ\u{b41}ଙ\u{b4d}ଗର",
                "ଫୋର\u{b4d}ସ କପ\u{b4d}\u{200c}",
                "ଶୌଚ\u{b3e}ଗ\u{b3e}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪਲ\u{a70}ਜਰ"),
            keywords: &[
                "ਟਾਇਲਟ",
                "ਟ\u{a71}ਟੀਖਾਨਾ",
                "ਨਾਲਸਾਜ\u{a3c}",
                "ਪਲ\u{a70}ਜਰ",
                "ਪਲ\u{a70}ਬਰ",
                "ਸਕਸ\u{a3c}ਨ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Plúnja"),
            keywords: &["Plúnja", "Plọnj", "Toílẹt", "Wọ\u{301}tá Sístẹm"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("przepychacz"),
            keywords: &[
                "hydraulik",
                "odetkać",
                "przepychacz",
                "przepychać",
                "toaleta",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پلنجر"),
            keywords: &["تشناب", "راکښل", "غاب", "پلنجر", "ګلکار"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("desentupidor"),
            keywords: &["banheiro", "desentupidor", "encanador", "sucção"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["desentupidor"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pompă de aspirare"),
            keywords: &[
                "desfundare",
                "instalator",
                "pompă de aspirare",
                "pompă de desfundat",
                "toaletă",
                "ventuză",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-069"),
            keywords: &["E13-069"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("вантуз"),
            keywords: &[
                "вантуз",
                "засор",
                "прочистка",
                "сантехник",
                "слив",
                "туалет",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پلونگر"),
            keywords: &["سڪشن", "فورس ڪپ", "ٽوائليٽ", "پلمبر", "پلونگر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ජලනල පොම\u{dca}පය"),
            keywords: &[
                "ච\u{dd6}ෂණ",
                "ජලනල",
                "ජලනල පොම\u{dca}පය",
                "බල ක\u{dd4}සල\u{dcf}න",
                "වැස\u{dd2}ක\u{dd2}ළ\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("čistiaci zvon"),
            keywords: &["inštalatér", "upchatý", "záchod", "čistiaci zvon"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("odmaševalnik"),
            keywords: &[
                "odmaševalnik",
                "sesalna skodela",
                "sesanje",
                "stranišče",
                "vodoinštalater",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("biyo mareen baneeye"),
            keywords: &[
                "biyo mareen baneeye",
                "kor u xoojin",
                "nuugista",
                "suuli",
                "tuubiiste",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("pompë"),
            keywords: &["hidraulik", "pompë", "shtupë", "thithje", "tualet"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("отпушивач"),
            keywords: &["водоинсталатер", "отпушивач", "отпушити", "снага", "тоалет"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("otpušivač"),
            keywords: &["otpušiti", "otpušivač", "snaga", "toalet", "vodoinstalater"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("vaskrensare"),
            keywords: &["rörmokare", "sugkopp", "toalett", "vaskrensare"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kizibuo"),
            keywords: &["choo", "fundi bomba", "kifyonzaji", "kizibuo", "ufyonzaji"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ப\u{bcd}ளங\u{bcd}கர\u{bcd}"),
            keywords: &[
                "உறிஞ\u{bcd}சுதல\u{bcd}",
                "உறியும\u{bcd} கப\u{bcd}",
                "கழிவறை",
                "ப\u{bcd}ளங\u{bcd}கர\u{bcd}",
                "ப\u{bcd}ளம\u{bcd}பர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c4d}లంజర\u{c4d}"),
            keywords: &[
                "ట\u{c3e}య\u{c3f}ల\u{c46}ట\u{c4d}",
                "న\u{c46}ట\u{c4d}ట\u{c3f} వ\u{c47}స\u{c47}",
                "ప\u{c40}డన\u{c3e}న\u{c4d}న\u{c3f} కలుగజ\u{c47}స\u{c47} కప\u{c4d}",
                "ప\u{c4d}లంజర\u{c4d}",
                "ప\u{c4d}లంబర\u{c4d}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ท\u{e35}\u{e48}ป\u{e31}\u{e4a}มช\u{e31}กโครก"),
            keywords: &[
                "การด\u{e39}ด",
                "ช\u{e48}างประปา",
                "ท\u{e35}\u{e48}ด\u{e39}ดท\u{e48}อน\u{e49}ำท\u{e34}\u{e49}ง",
                "ท\u{e35}\u{e48}ด\u{e39}ดส\u{e49}วม",
                "ท\u{e35}\u{e48}ป\u{e31}\u{e4a}มช\u{e31}กโครก",
                "ห\u{e49}องน\u{e49}ำ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("plunžer"),
            keywords: &["hajathana", "plunžer", "santehnik", "sorujy", "soruş"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻapamu toileti"),
            keywords: &["meʻapamu toileti"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("lavabo pompası"),
            keywords: &[
                "açıcı",
                "lavabo açıcı",
                "lavabo pompası",
                "tuvalet",
                "çekme",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("вантуз"),
            keywords: &[
                "вантуз",
                "гумова присоска",
                "прочищення",
                "сантехнік",
                "туалет",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پلنجر"),
            keywords: &["فورس کپ", "ٹوائلٹ", "پلمبر", "پلنجر", "چوسنا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tortgich"),
            keywords: &[
                "kuch bilan tortish",
                "santexnikning yordamchisi",
                "tortgich",
                "tortish",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("dụng cụ thông tắc"),
            keywords: &[
                "dụng cụ thông tắc",
                "hút",
                "lực cốc",
                "nhà vệ sinh",
                "thợ sửa ống nước",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("廁所泵"),
            keywords: &["廁所泵", "水喉技工", "通渠"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("厕所泵"),
            keywords: &["厕所泵", "水喉技工", "通渠"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("活塞"),
            keywords: &["吸力", "水管工", "活塞", "马桶"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("吸把"),
            keywords: &["吸把", "通水器", "通馬桶"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-plunger"),
            keywords: &[
                "i-plunger",
                "indlu yangasese",
                "ipulazi",
                "ukuphoqa indebe",
                "ukusondeza",
            ],
        },
    ],
};
#[doc = "🚿"]
pub const SHOWER: crate::Emoji = crate::Emoji {
    glyph: "🚿",
    codepoint: "1F6BF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "shower",
    group: "Objects",
    subgroup: "household",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("stort"),
            keywords: &["stort", "water"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሻወር"),
            keywords: &["ሻወር", "ውሃ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("دوش"),
            keywords: &["استحمام شاور", "دوش"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("শ\u{9cd}ব\u{9be}ৱ\u{9be}ৰ"),
            keywords: &["প\u{9be}নী", "শ\u{9cd}ব\u{9be}ৱ\u{9be}ৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("duş"),
            keywords: &["duş", "su"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("душ"),
            keywords: &["вада", "душ"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("душ"),
            keywords: &["вода", "душ"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("শ\u{9be}ওয\u{9bc}\u{9be}র"),
            keywords: &["জল", "শ\u{9be}ওয\u{9bc}\u{9be}র"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("strinkerez"),
            keywords: &["dour", "strinkerez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("tuš"),
            keywords: &["tuš", "voda"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dutxa"),
            keywords: &["aigua", "dutxa"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᏚᏟᏥᏙ"),
            keywords: &["ᎠᎹ", "ᎠᏍᏚᏟᏥᏙ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("sprcha"),
            keywords: &["koupelna", "sprcha", "voda"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cawod"),
            keywords: &["cawod", "dŵr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("brusebad"),
            keywords: &["bad", "brusebad"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Dusche"),
            keywords: &["Dusche"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ντους"),
            keywords: &["νερό", "ντους"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("shower"),
            keywords: &["shower", "water"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ducha"),
            keywords: &["agua", "baño", "ducha"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("regadera"),
            keywords: &["regadera"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("dušš"),
            keywords: &["dušš", "vesi"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("dutxa"),
            keywords: &["dutxa", "ur"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دوش"),
            keywords: &["آب", "حمام", "دوش"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("suihku"),
            keywords: &["suihku", "vesi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("shower"),
            keywords: &["ligo", "shower", "tubig"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("brúsubað"),
            keywords: &["brúsa", "brúsubað", "vatn"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("douche"),
            keywords: &["douche", "eau"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cithfholcadán"),
            keywords: &["cithfholcadán", "uisce"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("frasair"),
            keywords: &["bùrn", "frasair", "uisge"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("ducha"),
            keywords: &["auga", "ducha"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("શાવર"),
            keywords: &["શાવર", "શૉવર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("shawa"),
            keywords: &["ruwa", "shawa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מקלחת"),
            keywords: &["מים", "מקלחת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{94d}नान"),
            keywords: &["पानी", "स\u{94d}नान"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tuš"),
            keywords: &["tuš", "voda"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("zuhanyzó"),
            keywords: &["víz", "vízsugár", "zuhanyzó"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("լոգարանի ցնցուղ"),
            keywords: &["լոգարանի ցնցուղ", "ջուր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("shower"),
            keywords: &["air", "shower"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("igwe asamụahụ"),
            keywords: &["igwe asamụahụ", "mmiri"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sturta"),
            keywords: &["sturta", "vatn"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("doccia"),
            keywords: &["doccia", "fare la doccia", "lavarsi"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("シャワー"),
            keywords: &["シャワー", "風呂"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pancuran"),
            keywords: &["banyu", "pancuran"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("შხაპი"),
            keywords: &["შხაპი", "წყალი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("душ"),
            keywords: &["душ", "су"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("brusebad"),
            keywords: &["bad", "brusebad"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រ\u{17c9}\u{17bc}ប\u{17ca}\u{17b8}នេទ\u{17b9}កផ\u{17d2}កាឈ\u{17bc}ក"),
            keywords: &[
                "ទ\u{17b9}កផ\u{17d2}កាឈ\u{17bc}ក",
                "រ\u{17c9}\u{17bc}ប\u{17ca}\u{17b8}នេ",
                "រ\u{17c9}\u{17bc}ប\u{17ca}\u{17b8}នេទ\u{17b9}កផ\u{17d2}កាឈ\u{17bc}ក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಶವರ\u{ccd}"),
            keywords: &["ನೀರು", "ಶವರ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("샤워"),
            keywords: &["물", "샤워"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("शोवर"),
            keywords: &["उदक", "शोवर"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("душ"),
            keywords: &["душ", "суу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Dusch"),
            keywords: &["Dusch", "Waasser"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຝ\u{eb1}ກບ\u{ebb}ວອາບນ\u{ecd}\u{ec9}າ"),
            keywords: &[
                "ນ\u{ecd}\u{ec9}າ",
                "ຝ\u{eb1}ກບ\u{ebb}ວ",
                "ຝ\u{eb1}ກບ\u{ebb}ວອາບນ\u{ecd}\u{ec9}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("dušas"),
            keywords: &["dušas", "vanduo"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("duša"),
            keywords: &["duša", "ūdens"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("uwhiuwhi"),
            keywords: &["uwhiuwhi", "wai"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("туш"),
            keywords: &["вода", "туш", "туширање"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഷവർ"),
            keywords: &["ക\u{d41}ളി", "വെള\u{d4d}ളം", "ഷവർ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("усанд орох"),
            keywords: &["орох", "ус", "усанд орох"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("शॉवर"),
            keywords: &["पाणी", "शॉवर"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pancuran"),
            keywords: &["air", "pancuran"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("doxxa"),
            keywords: &["doxxa", "ilma"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ရေပန\u{103a}း"),
            keywords: &["ရေ", "ရေပန\u{103a}း"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("dusj"),
            keywords: &["dusj", "vann"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("न\u{941}हाउन\u{947}"),
            keywords: &["न\u{941}हाउन\u{947}", "पानी"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("douche"),
            keywords: &["douche", "water"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("dusj"),
            keywords: &["dusj", "vatn"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b3e}ୱ\u{b3e}ର\u{b4d}"),
            keywords: &["ପ\u{b3e}ଣ\u{b3f}", "ସ\u{b3e}ୱ\u{b3e}ର\u{b4d}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a3c}ਾਵਰ"),
            keywords: &["ਫ\u{a41}ਹਾਰਾ", "ਸ\u{a3c}ਾਵਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("غسل"),
            keywords: &["غسل", "پانی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Sháwa"),
            keywords: &["Sháwa", "Wọtá"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("prysznic"),
            keywords: &["prysznic", "woda", "łazienka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شاور"),
            keywords: &["اوبه", "شاور"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("chuveiro"),
            keywords: &["banho", "chuveiro", "ducha", "água"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["chuveiro", "duche", "água"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("duș"),
            keywords: &["apă", "duș"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-979"),
            keywords: &["E10-979"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("душ"),
            keywords: &["вода", "душ", "мыться", "чистота"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("dushe"),
            keywords: &["amazi", "dushe"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڦوارو"),
            keywords: &["پاڻي", "ڦوارو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වත\u{dd4}ර මල"),
            keywords: &["වත\u{dd4}ර", "වත\u{dd4}ර මල"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("sprcha"),
            keywords: &["sprcha", "voda"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("tuš"),
            keywords: &["tuš", "voda"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("shaawar"),
            keywords: &["biyo", "shaawar"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("dush"),
            keywords: &["dush", "ujë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("туш"),
            keywords: &["вoдa", "туш"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("tuš"),
            keywords: &["tuš", "voda"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("dusch"),
            keywords: &["dusch", "vatten"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("bafu ya manyunyu"),
            keywords: &["bafu ya manyunyu", "maji"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஷவர\u{bcd}"),
            keywords: &["ஷவர\u{bcd}", "ஷவர\u{bcd} குளியல\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("న\u{c40}ట\u{c3f} తుంపరలు"),
            keywords: &["తుంపర", "న\u{c40}ట\u{c3f} తుంపరలు", "న\u{c40}రు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("душ"),
            keywords: &["душ", "об"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ฝ\u{e31}กบ\u{e31}ว"),
            keywords: &["น\u{e49}ำ", "ฝ\u{e31}กบ\u{e31}ว"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("duş"),
            keywords: &["duş", "suw"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻa fakapihi kaukau"),
            keywords: &["meʻa fakapihi kaukau"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("duş"),
            keywords: &["duş", "su"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يۇيۇنۇش"),
            keywords: &["سۇ", "يۇيۇنۇش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("душ"),
            keywords: &["вода", "душ"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("شاور"),
            keywords: &["شاور", "پانی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("dush"),
            keywords: &["dush", "suv"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("vòi hoa sen"),
            keywords: &["nước", "vòi hoa sen"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("duus"),
            keywords: &["duus", "ndox"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ishawa"),
            keywords: &["amanzi", "ishawa"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ìwẹ\u{300}"),
            keywords: &["omi", "Ìwẹ\u{300}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("花灑"),
            keywords: &["水", "花灑"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("花洒"),
            keywords: &["水", "花洒"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("淋浴"),
            keywords: &["喷头", "喷水", "水", "洗澡 花洒", "淋浴"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("淋浴"),
            keywords: &["淋浴", "蓮蓬頭"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["淋浴", "花灑頭"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ishawa"),
            keywords: &["amanzi", "ishawa"],
        },
    ],
};
#[doc = "🛁"]
pub const BATHTUB: crate::Emoji = crate::Emoji {
    glyph: "🛁",
    codepoint: "1F6C1",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "bathtub",
    group: "Objects",
    subgroup: "household",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("bad"),
            keywords: &["bad", "water"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የገላ መታጠቢያ ገንዳ"),
            keywords: &["የገላ መታጠቢያ ገንዳ", "ገላን መታጠብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("حوض استحمام"),
            keywords: &["حوض استحمام", "مغطس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ব\u{9be}থট\u{9be}ব"),
            keywords: &["ব\u{9be}থট\u{9be}ব", "স\u{9cd}ন\u{9be}ন"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("vanna"),
            keywords: &["hamam", "vanna"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ванна"),
            keywords: &["вада", "ванна", "купанне"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("вана"),
            keywords: &["баня", "вана"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9be}থটব"),
            keywords: &["ব\u{9be}থটব", "স\u{9cd}ন\u{9be}ন"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kibell"),
            keywords: &["dour", "kibell"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kada"),
            keywords: &["kada", "kupanje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("banyera"),
            keywords: &["bany", "banyera"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎾᏓᏬᏍᏗ"),
            keywords: &["ᎠᏓᏬᏍᏗ", "ᎤᎾᏓᏬᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("vana"),
            keywords: &["koupel", "koupelna", "lázeň", "vana", "voda"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("twba bath"),
            keywords: &["bath", "twba bath"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("badekar"),
            keywords: &["bad", "badekar", "karbad"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Badewanne"),
            keywords: &["Bad", "Badewanne", "Badezimmer"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μπανιέρα"),
            keywords: &["μπανιέρα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("bathtub"),
            keywords: &["bath", "bathtub"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("bath"),
            keywords: &["bath", "bathtub", "tub"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("bath"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bañera"),
            keywords: &["bañera", "baño"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("tina"),
            keywords: &["tina"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("vann"),
            keywords: &["vann"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bainuontzia"),
            keywords: &["bainu", "bainuontzia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("وان حمام"),
            keywords: &["حمام", "وان حمام"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kylpyamme"),
            keywords: &["kylpy", "kylpyamme"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bathtub"),
            keywords: &["bathtub", "ligo", "tubig"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("baðikar"),
            keywords: &["bað", "baðikar"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("baignoire"),
            keywords: &["baignoire", "bain"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("folcadán"),
            keywords: &["folcadán"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ballan-ionnlaid"),
            keywords: &["amar", "ballan-ionnlaid", "ionnlad", "ionnlaid"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("bañeira"),
            keywords: &["bañeira", "baño"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બાથ ટબ"),
            keywords: &["નાહવ\u{ac1}\u{a82}", "બાથ", "બાથ ટબ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("baho"),
            keywords: &["baho", "wanka"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אמבטיה"),
            keywords: &["אמבטיה", "מקלחת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बाथ टब"),
            keywords: &["बाथ टब", "स\u{94d}नान"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kada"),
            keywords: &["kada", "kupanje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fürdőkád"),
            keywords: &["fürdés", "fürdőkád"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("լոգարան"),
            keywords: &["լոգասենյակ", "լոգարան"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bathtub"),
            keywords: &["bathtub", "mandi"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ngwa asamụahụ"),
            keywords: &["asamụahụ", "ngwa asamụahụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("baðker"),
            keywords: &["bað", "baðkar", "baðker"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("vasca"),
            keywords: &["vasca", "vasca da bagno"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("バスタブ"),
            keywords: &["バスタブ", "浴槽", "風呂"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bak kungkum"),
            keywords: &["adus", "bak kungkum"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("აბაზანა"),
            keywords: &["აბაზანა", "სააბაზანო"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ванна"),
            keywords: &["ванна"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("badekar"),
            keywords: &["bad", "badekar"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("អាងង\u{17bc}តទ\u{17b9}ក"),
            keywords: &["ង\u{17bc}តទ\u{17b9}ក", "អាងង\u{17bc}តទ\u{17b9}ក"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬಾತ\u{ccd}\u{200c}ಟಬ\u{ccd}"),
            keywords: &[
                "ಬಾತ\u{ccd}\u{200c}ಟಬ\u{ccd}",
                "ಸ\u{ccd}ನಾನ",
                "ಸ\u{ccd}ನಾನದ ಟಬ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("욕조"),
            keywords: &["목욕", "샤워", "욕조"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बाथटब"),
            keywords: &["न\u{94d}हाण", "बाथटब"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ванна"),
            keywords: &["ванна", "жуун"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Buedbidden"),
            keywords: &["Bidden", "Buedbidden"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ອ\u{ec8}າງອາບນ\u{ecd}\u{ec9}າ"),
            keywords: &[
                "ອາບນ\u{ecd}\u{ec9}າ",
                "ອ\u{ec8}າງ",
                "ອ\u{ec8}າງອາບນ\u{ecd}\u{ec9}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vonia"),
            keywords: &["vonia"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vanna"),
            keywords: &["vanna", "ūdens"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tāpukaukau"),
            keywords: &["kaukau", "tāpukaukau"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("када"),
            keywords: &["бања", "када"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ബ\u{d3e}ത\u{d4d}ത\u{d4d} ടബ\u{d4d}"),
            keywords: &["ക\u{d41}ളി", "ബ\u{d3e}ത\u{d4d}ത\u{d4d} ടബ\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ванн"),
            keywords: &["ванн"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("आ\u{902}घोळीचा टब"),
            keywords: &["आ\u{902}घोळ", "आ\u{902}घोळीचा टब"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tab mandi"),
            keywords: &["mandi", "tab mandi"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("banju"),
            keywords: &["banju"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ရေချ\u{102d}\u{102f}းကန\u{103a}"),
            keywords: &["ရေချ\u{102d}\u{102f}း", "ရေချ\u{102d}\u{102f}းကန\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("badekar"),
            keywords: &["bad", "badekar", "badestamp"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बाथटब"),
            keywords: &["बाथ", "बाथटब"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("badkuip"),
            keywords: &["bad", "badkuip"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("badekar"),
            keywords: &["bad", "badekar", "badestamp"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଗ\u{b3e}ଧ\u{b41}ଆ କ\u{b41}ଣ\u{b4d}ଡ ବ\u{b3e} ବ\u{b3e}ଥଟବ\u{b4d}\u{200c}"),
            keywords: &[
                "ଗ\u{b3e}ଧ\u{b41}ଆ କ\u{b41}ଣ\u{b4d}ଡ ବ\u{b3e} ବ\u{b3e}ଥଟବ\u{b4d}\u{200c}",
                "ବ\u{b3e}ଥ\u{b4d}\u{200c}ଟବ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਨਹਾਉਣ ਵਾਲਾ ਟ\u{a71}ਬ"),
            keywords: &["ਨਹਾਉਣ ਵਾਲਾ ਟ\u{a71}ਬ", "ਬਾਥ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("باتھ-ٹب"),
            keywords: &["باتھ-ٹب", "نہاؤنا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Baf"),
            keywords: &["Baf", "Báf Bézin"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wanna"),
            keywords: &["kąpiel", "wanna"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د لامبلو ټب"),
            keywords: &["د لامبلو ټب", "لامبل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("banheira"),
            keywords: &["banheira"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["banheira", "banho"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cadă"),
            keywords: &["baie", "cadă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-981"),
            keywords: &["E10-981"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("ванна"),
            keywords: &["ванна", "ванная", "вода", "мыться", "чистота"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("urwogero"),
            keywords: &["ubwiyuhagiriro", "urwogero"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("وهنجڻ جو ڪونڏو"),
            keywords: &["وهنجڻ", "وهنجڻ جو ڪونڏو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("න\u{dcf}න බේසම"),
            keywords: &["න\u{dcf}න බේසම", "නෑම"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("vaňa"),
            keywords: &["vaňa"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kad"),
            keywords: &["banja", "kad"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("sinxi maydhasho"),
            keywords: &["maydhasho", "sinxi maydhasho"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("vaskë"),
            keywords: &["vaskë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("када"),
            keywords: &["када", "купање"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["када"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kada"),
            keywords: &["kada", "kupanje"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["kada"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("badkar"),
            keywords: &["bad", "badkar"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("bafu"),
            keywords: &["bafu", "hamamu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("குளியல\u{bcd} தொட\u{bcd}டி"),
            keywords: &["குளியலறை", "குளியல\u{bcd} தொட\u{bcd}டி", "தொட\u{bcd}டி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c4d}న\u{c3e}నపు త\u{c4a}ట\u{c4d}ట\u{c46}"),
            keywords: &[
                "త\u{c4a}ట\u{c4d}ట\u{c46}",
                "స\u{c4d}న\u{c3e}నం",
                "స\u{c4d}న\u{c3e}నపు త\u{c4a}ట\u{c4d}ట\u{c46}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ванна"),
            keywords: &["ванна", "ҳаммом"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("อ\u{e48}างอาบน\u{e49}ำ"),
            keywords: &["อาบน\u{e49}ำ", "อ\u{e48}าง", "อ\u{e48}างอาบน\u{e49}ำ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("wanna"),
            keywords: &["duş", "wanna"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("topu kaukau"),
            keywords: &["topu kaukau"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("banyo küveti"),
            keywords: &["banyo", "banyo küveti"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يۇيۇنداق"),
            keywords: &["مۇنچا", "يۇيۇنداق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("ванна"),
            keywords: &["ванна", "купатися"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("نہانے کا ٹب"),
            keywords: &["نہانا", "نہانے کا ٹب"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("vanna"),
            keywords: &["hammom", "vanna"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bồn tắm"),
            keywords: &["bồn tắm", "tắm"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("beñuwaar"),
            keywords: &["beñuwaar", "sangu"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhafu yokuhlambela"),
            keywords: &["ibhafu", "ibhafu yokuhlambela"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Àgbá ìwẹ\u{300}"),
            keywords: &["Àgbá ìwẹ\u{300}", "ìwẹ\u{300}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("浴缸"),
            keywords: &["沖涼", "浴缸"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("浴缸"),
            keywords: &["冲凉", "浴缸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("浴缸"),
            keywords: &["沐浴", "泡沫浴", "泡澡", "洗澡", "浴缸", "澡盆"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("澡盆"),
            keywords: &["浴盆", "澡盆"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("浴缸"),
            keywords: &["浴缸"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubhavu wokugezela"),
            keywords: &["ubhavu wokugezela", "ukugeza"],
        },
    ],
};
#[doc = "🪤"]
pub const MOUSE_TRAP: crate::Emoji = crate::Emoji {
    glyph: "🪤",
    codepoint: "1FAA4",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "mouse trap",
    group: "Objects",
    subgroup: "household",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("muisvalletjie"),
            keywords: &["lokaas", "muisvalletjie", "strik", "wip"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የአይጥ ማጥመጃ"),
            keywords: &["የአይጥ ማጥመጃ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مصيدة فئران"),
            keywords: &["طعم", "فخ", "كمين", "مصيدة", "مصيدة فئران"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("নিগনি ধৰ\u{9be} সজ\u{9be}"),
            keywords: &[
                "জ\u{9be}ল",
                "নিগনি ধৰ\u{9be} সজ\u{9be}",
                "ফ\u{9be}ন\u{9cd}দ",
                "বেইট",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("siçan tələsi"),
            keywords: &["siçan tələsi", "tutmaq", "tələ", "tələ yemi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("пастка"),
            keywords: &["мышыная пастка", "пастка", "прынада", "сіло"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("капан за мишки"),
            keywords: &[
                "капан",
                "капан за мишки",
                "миши капан",
                "примамка",
                "примка",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ই\u{981}দ\u{9c1}র ধর\u{9be}র কল"),
            keywords: &[
                "ই\u{981}দ\u{9c1}র ধর\u{9be}র কল",
                "টোপ",
                "ফ\u{9be}\u{981}দ",
                "ফ\u{9be}\u{981}দে ধর\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("logotouer"),
            keywords: &["logod", "logotouer"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("klopka za miševe"),
            keywords: &[
                "klopka",
                "klopka za miševe",
                "mamac",
                "zamka",
                "zamka za miševe",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("ratera"),
            keywords: &["parany", "rata", "ratera", "ratolí", "trampa"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏥᏍᏕᏥ ᏌᏛᏗ"),
            keywords: &["ᎠᏑᏗ ᎦᏙᏗ", "ᏌᏛᏗ", "ᏌᏛᏗᎢ", "ᏥᏍᏕᏥ ᏌᏛᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("pastička na myši"),
            keywords: &[
                "nástraha",
                "návnada",
                "past",
                "pastička",
                "pastička na myši",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("trap llygod"),
            keywords: &["abwyd", "maglu", "trap", "trap llygod", "trap llygoden"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("musefælde"),
            keywords: &["fange", "fælde", "lokkemad", "musefælde", "snare"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Mausefalle"),
            keywords: &["Falle", "Mausefalle", "Mäusefalle"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ποντικοπαγίδα"),
            keywords: &["δόλωμα", "παγίδα", "ποντικοπαγίδα", "φάκα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("mouse trap"),
            keywords: &["bait", "mouse trap", "mousetrap", "snare", "trap"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("mousetrap"),
            keywords: &[""],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("mouse trap"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("mousetrap"),
            keywords: &["bait", "mouse", "mousetrap", "snare", "trap"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("mousetrap"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("trampa de ratones"),
            keywords: &[
                "cebo",
                "cepo",
                "engañar",
                "ratonera",
                "ratón",
                "trampa",
                "trampa de ratones",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("trampa para ratones"),
            keywords: &["trampa para ratones"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("ratonera"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("hiirelõks"),
            keywords: &["hiirelõks", "lõks", "püünis", "sööt"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("sagu-arte"),
            keywords: &[
                "amua",
                "sagu-arte",
                "sagu-artea",
                "sagutegia",
                "satartea",
                "tranpa",
                "zepoa",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تله موش"),
            keywords: &["تله", "تله موش", "دام", "طعمه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hiirenloukku"),
            keywords: &["ansa", "hiirenloukku", "loukku", "syötti"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("panghuli ng daga"),
            keywords: &["daga", "panghuli", "panghuli ng daga", "trap"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("músafella"),
            keywords: &["fella", "lokkingarmatur", "músafella"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("tapette à souris"),
            keywords: &[
                "appât",
                "piège",
                "piège à souris",
                "tapette",
                "tapette à souris",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("piège à souris"),
            keywords: &["apât", "piège", "piège à souris"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("gaiste luchóg"),
            keywords: &["baoite", "dol", "gaise", "gaiste luchóg"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("trap lucha"),
            keywords: &[
                "biadh",
                "luch",
                "ribe",
                "strap",
                "strap lucha",
                "trap",
                "trap lucha",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("trampa para ratos"),
            keywords: &[
                "cebo",
                "desratizar",
                "enganar",
                "ratos",
                "trampa para ratos",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઉ\u{a82}દર પકડવાન\u{ac1}\u{a82} પા\u{a82}જર\u{ac1}\u{a82}"),
            keywords: &[
                "ઉ\u{a82}દર પકડવાન\u{ac1}\u{a82} પા\u{a82}જર\u{ac1}\u{a82}",
                "ઉ\u{a82}દરન\u{ac7} પકડવાન\u{ac1}\u{a82} પા\u{a82}જર\u{ac1}\u{a82}",
                "પા\u{a82}જરામા\u{a82} મ\u{ac2}ક\u{ac7}લી ખાજ",
                "પાશ",
                "ફસાવવ\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מלכודת עכברים"),
            keywords: &["להפיל בפח", "מלכודת", "מלכודת עכברים", "פח"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("च\u{942}ह\u{947}दानी"),
            keywords: &[
                "च\u{942}ह\u{947}दानी",
                "जाल",
                "पि\u{902}जरा",
                "प\u{94d}रलोभन",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("mišolovka"),
            keywords: &["klopka", "mamac", "mišolovka", "uhvatiti", "zamka"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("egércsapda"),
            keywords: &["csali", "csalétek", "csapda", "egércsapda"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մկան թակարդ"),
            keywords: &["թալակ", "թակարդ", "ծուղակ", "մկան թակարդ", "որոգայթ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("perangkap tikus"),
            keywords: &["jebakan", "jerat", "perangkap tikus", "umpan"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("músagildra"),
            keywords: &["gildra", "músagildra", "veiði"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("trappola per topi"),
            keywords: &["esca", "trappola", "trappola per topi"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ねずみ捕り"),
            keywords: &[
                "おびき寄せる",
                "ねずみ捕り",
                "ばね",
                "わな",
                "マウストラップ",
                "仕掛け",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("panjebak tikus"),
            keywords: &["pangikat", "panjebak", "panjebak tikus", "umpan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სათაგური"),
            keywords: &["მიტყუება", "სათაგური", "შეტყუება", "ხაფანგი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қақпан"),
            keywords: &["тосқын", "тұзақ", "тұзақ жем", "қақпан"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("អង\u{17d2}គប\u{17cb}កណ\u{17d2}ដ\u{17bb}រ"),
            keywords: &[
                "ន\u{17bb}យ",
                "អង\u{17d2}គប\u{17cb}",
                "អង\u{17d2}គប\u{17cb}កណ\u{17d2}ដ\u{17bb}រ",
                "អន\u{17d2}ទាក\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮ\u{ccc}ಸ\u{ccd} ಬಲ\u{cc6}"),
            keywords: &[
                "ಬಲ\u{cc6}",
                "ಬ\u{cc6}ಟ\u{ccd}",
                "ಮ\u{ccc}ಸ\u{ccd} ಬಲ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("쥐덫"),
            keywords: &["덫", "미끼", "쥐덫", "함정"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उ\u{902}दराच\u{947}\u{902} जाळ\u{947}\u{902}"),
            keywords: &[
                "उ\u{902}दराच\u{947}\u{902} जाळ\u{947}\u{902}",
                "धरप",
                "पा\u{902}जरो",
                "पा\u{902}दरो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чычкан капкан"),
            keywords: &["чычкан капкан"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກ\u{eb1}ບດ\u{eb1}ກໜ\u{eb9}"),
            keywords: &[
                "ກ\u{eb1}ບດ\u{eb1}ກ",
                "ກ\u{eb1}ບດ\u{eb1}ກໜ\u{eb9}",
                "ຫ\u{ec8}ວງ",
                "ເຫຍ\u{eb7}\u{ec8}ອ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("pelėkautai"),
            keywords: &["pelėkautai", "spąstai"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("peļu slazds"),
            keywords: &["lamatas", "peļu slazds", "slazds", "ēsma"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("стапица за глувци"),
            keywords: &["мамка", "стапица", "стапица за глувци"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("എലിപ\u{d4d}പെട\u{d4d}ടി"),
            keywords: &[
                "എലിക\u{d4d}കെണി",
                "എലിപ\u{d4d}പെട\u{d4d}ടി",
                "കെണി",
                "വല",
                "വശീകരണം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хулганы хавх"),
            keywords: &["урхи", "хулганы хавх", "өгөөш"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("उ\u{902}दीर पकडण\u{94d}\u{200d}याचा पि\u{902}जरा"),
            keywords: &[
                "उ\u{902}दीर पकडण\u{94d}\u{200d}याचा पि\u{902}जरा",
                "घोड\u{94d}याच\u{947} अन\u{94d}न",
                "जाळ\u{94d}यात पकडण\u{947}",
                "सापळा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("perangkap tikus"),
            keywords: &["jerat", "perangkap", "perangkap tikus", "umpan"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကြ\u{103d}က\u{103a}ထောင\u{103a}ချောက\u{103a}"),
            keywords: &[
                "ကျော\u{1037}က\u{103d}င\u{103a}း",
                "ကြ\u{103d}က\u{103a}ထောင\u{103a}ချောက\u{103a}",
                "ထောင\u{103a}ချောက\u{103a}",
                "မျ\u{103e}ားစာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("musefelle"),
            keywords: &["felle", "mus", "musefelle", "snare", "åte"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("म\u{941}साको जालो"),
            keywords: &[
                "जालो",
                "ब\u{947}ट",
                "म\u{941}साको जालो",
                "स\u{94d}न\u{947}यर",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("muizenval"),
            keywords: &["aas", "muizenval", "strik", "valstrik"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("musefelle"),
            keywords: &["felle", "mus", "musefelle", "snare", "åte"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମ\u{b42}ଷ\u{b3e} ଯନ\u{b4d}ତ\u{b3e}"),
            keywords: &[
                "ଥୋପ",
                "ଫ\u{b3e}ଶ",
                "ମ\u{b42}ଷ\u{b3e} ଯନ\u{b4d}ତ\u{b3e}",
                "ମ\u{b42}ଷ\u{b3e}ଯନ\u{b4d}ତ\u{b3e}",
                "ଯନ\u{b4d}ତ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚ\u{a42}ਹ\u{a47}ਦਾਨੀ"),
            keywords: &[
                "ਚ\u{a42}ਹ\u{a47}ਦਾਨੀ",
                "ਜਾਲ",
                "ਜਾਲ ਵਿਛਾਉਣਾ",
                "ਪਿ\u{a70}ਜਰਾ",
                "ਫਸਾਉਣਾ",
                "ਫੜਣਾ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Rát Trap"),
            keywords: &[
                "Bẹt",
                "Fud Wé Dẹm Pút Ọn Tọ\u{301}p Trap",
                "Maús Trap",
                "Maústrap",
                "Rát Trap",
                "Ráttrap",
                "Trap",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pułapka na myszy"),
            keywords: &["przynęta", "pułapka", "pułapka na myszy", "sidła"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لټ"),
            keywords: &["تېرايستل", "جال", "شومه", "لټ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("ratoeira"),
            keywords: &["armadilha", "isca", "prender", "ratoeira"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["apanhar", "armadilha", "engodo", "isca", "isco", "ratoeira"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cursă de șoareci"),
            keywords: &[
                "ademeni",
                "capcană de șoareci",
                "cursă de șoareci",
                "momeală",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-070"),
            keywords: &["E13-070"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мышеловка"),
            keywords: &["западня", "капкан", "ловушка", "мышеловка", "приманка"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مائوس ٽريپ"),
            keywords: &["بيٽ", "سنيئر", "مائوس ٽريپ", "ٽريپ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ම\u{dd3} කත\u{dd4}ර"),
            keywords: &["ඇමක\u{dca}", "උග\u{dd4}ල", "ම\u{dd3} කත\u{dd4}ර"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("pasca na myši"),
            keywords: &["myš", "nástraha", "návnada", "pasca na myši", "syr"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("mišolovka"),
            keywords: &["mišolovka", "past za miši", "vaba"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dabin jiirka"),
            keywords: &[
                "cunto lagu xiro dabin",
                "dabin",
                "dabin jiirka",
                "shabaq dabin",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("çark"),
            keywords: &["grackë", "karrem", "kurth", "çark"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мишоловка"),
            keywords: &["замка", "мамац", "мишоловка", "намештаљка"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["мишоловка"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("mišolovka"),
            keywords: &["mamac", "mišolovka", "nameštaljka", "zamka"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["mišolovka"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("musfälla"),
            keywords: &["bete", "fälla", "musfälla", "snara"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mtego wa panya"),
            keywords: &["chambo", "kitanzi", "mtego", "mtego wa panya"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("எலிப\u{bcd}பொறி"),
            keywords: &["எலிப\u{bcd}பொறி", "தூண\u{bcd}டில\u{bcd}", "பொறி", "வலை"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఎలుక బ\u{c4b}ను"),
            keywords: &["ఎలుక బ\u{c4b}ను", "ఎలుకల మందు", "బ\u{c4b}ను"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ก\u{e31}บด\u{e31}กหน\u{e39}"),
            keywords: &[
                "ก\u{e31}บด\u{e31}ก",
                "ก\u{e31}บด\u{e31}กหน\u{e39}",
                "วางก\u{e31}บด\u{e31}ก",
                "เหย\u{e37}\u{e48}อ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gapan"),
            keywords: &["aldawaç", "duzak", "gapan", "syçan gapany", "tor"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tauhele kumā"),
            keywords: &["tauhele kumā"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("fare kapanı"),
            keywords: &["fare kapanı", "kapan", "kıskaç", "tuzak"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("мишоловка"),
            keywords: &["мишоловка", "пастка", "приманка", "сильце"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چوہے کا پھندہ"),
            keywords: &["پھندہ", "چارہ", "چوہے کا پھندہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("sichqon tutgich"),
            keywords: &["qopqon", "sichqon tutgich", "tuzoq", "xoʻrak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bẫy chuột"),
            keywords: &["bẩy", "bẫy", "bẫy chuột", "mồi"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("老鼠夾"),
            keywords: &["老鼠夾", "陷阱", "餌"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("老鼠夹"),
            keywords: &["老鼠夹", "陷阱", "饵"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("捕鼠器"),
            keywords: &["捕鼠器", "诱饵", "陷进"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("捕鼠器"),
            keywords: &["捕鼠", "捕鼠器", "捕鼠夾", "陷阱", "餌"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("unoxhaka"),
            keywords: &["isicuphi", "ugibe", "umgibe", "unoxhaka"],
        },
    ],
};
#[doc = "🪒"]
pub const RAZOR: crate::Emoji = crate::Emoji {
    glyph: "🪒",
    codepoint: "1FA92",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "razor",
    group: "Objects",
    subgroup: "household",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("skeermes"),
            keywords: &["skeer", "skeermes", "skerp"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ምላጭ"),
            keywords: &["መላጨት", "ምላጭ", "ሹል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("موس حلاقة"),
            keywords: &["حاد", "حلاقة", "موس حلاقة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9cd}ষ\u{9c1}ৰ"),
            keywords: &[
                "ক\u{9cd}ষ\u{9c1}ৰ",
                "ক\u{9cd}ষৌৰ কৰ\u{9cd}ম",
                "তীক\u{9cd}ষ\u{9cd}ণধ\u{9be}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ülgüc"),
            keywords: &["iti", "kəsici", "ülgüc"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("брытва"),
            keywords: &["брытва", "востры", "галіцца"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("бръснач"),
            keywords: &["бръснач", "бръснене", "острие"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9cd}ষ\u{9c1}র"),
            keywords: &[
                "ক\u{9cd}ষ\u{9c1}র",
                "দ\u{9be}ড\u{9bc}ি ক\u{9be}ম\u{9be}নো",
                "ধ\u{9be}র\u{9be}ল",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("aotenn"),
            keywords: &["aotenn", "aotenniñ"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("čakija"),
            keywords: &["brijač", "oštrica", "čakija"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("navalla d’afaitar"),
            keywords: &["afaitada", "esmolada", "navalla d’afaitar"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎵᏍᏙᏯᏙᏗ"),
            keywords: &["ᎠᎵᏍᏙᏯᏗ", "ᎠᎵᏍᏙᏯᏙᏗ", "ᎪᏍᏓᏱ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("břitva"),
            keywords: &["břitva", "holení", "holicí", "holit", "oholit", "ostrý"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("rasel"),
            keywords: &["eillio", "miniog", "rasel", "siafio"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ragekniv"),
            keywords: &["ragekniv"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Rasierer"),
            keywords: &["Rasierer", "rasieren", "scharf"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ξυράφι"),
            keywords: &["κοφτερό", "ξυράφι", "ξύρισμα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("razor"),
            keywords: &["razor", "sharp", "shave"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("razor"),
            keywords: &["razor"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("razor"),
            keywords: &["cut-throat", "razor", "sharp", "shave"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cuchilla de afeitar"),
            keywords: &[
                "afeitado",
                "afeitar",
                "afilado",
                "barbero",
                "cuchilla de afeitar",
                "navaja",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("navaja de afeitar"),
            keywords: &["navaja de afeitar"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("habemenuga"),
            keywords: &["habe", "habemenuga", "raseerimine", "terav"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bizar-labana"),
            keywords: &["bizar-labana", "bizarra kendu", "zorrotz"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ریش\u{200c}تراش"),
            keywords: &["تراشیدن", "تیز", "ریش\u{200c}تراش"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("partaveitsi"),
            keywords: &["ajaa parta", "partaveitsi", "terävä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("razor"),
            keywords: &["matalas", "pang-ahit", "razor"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("rakiknívur"),
            keywords: &["barberblað", "knívur", "raka", "rakiblað", "rakiknívur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("rasoir"),
            keywords: &["coupant", "lame", "raser", "rasoir", "tranchant"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("rásúr"),
            keywords: &["bearradh", "gearr", "rásúr"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ealtainn"),
            keywords: &["bearradh", "beàrr", "ealtainn", "geur"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("coitela"),
            keywords: &["afeitar", "barbeiro", "coitela"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ર\u{ac7}ઝર"),
            keywords: &["તીક\u{acd}ષ\u{acd}ણ", "ર\u{ac7}ઝર", "શ\u{ac7}વ"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סכין גילוח"),
            keywords: &["גילוח", "חד", "סכין", "תער"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("उस\u{94d}तरा"),
            keywords: &[
                "उस\u{94d}तरा",
                "छ\u{941}रा",
                "छ\u{941}री",
                "ब\u{94d}ल\u{947}ड",
                "र\u{947}ज\u{93c}र",
                "श\u{947}व",
                "श\u{947}वि\u{902}ग",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("britva"),
            keywords: &["brijanje", "britva", "oštro"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("borotva"),
            keywords: &["borotva", "borotvál", "éles"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ածելի"),
            keywords: &["ածելի", "սափրիչ", "սափրվել", "սուր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pisau cukur"),
            keywords: &["cukur", "pisau cukur", "tajam"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("rakhnífur"),
            keywords: &["beittur", "raka sig", "rakhnífur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("rasoio"),
            keywords: &[
                "farsi la barba",
                "lama da barba",
                "lama da barbiere",
                "radersi",
                "rasoio",
                "rasoio da barbiere",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("剃刀"),
            keywords: &["ひげそり", "レーザー", "刃", "剃刀"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("peso cukur"),
            keywords: &["cukur", "landhep", "peso cukur"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბრიტვა"),
            keywords: &["ბასრი", "ბრიტვა", "პარსვა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ұстара"),
            keywords: &["қырыну", "ұстара", "өткір"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កា\u{17c6}ប\u{17b7}តកោរព\u{17bb}កមាត\u{17cb}"),
            keywords: &[
                "កា\u{17c6}ប\u{17b7}តកោរព\u{17bb}កមាត\u{17cb}",
                "កោរ",
                "ម\u{17bb}ត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ರೇಸರ\u{ccd}"),
            keywords: &["ಚ\u{cc2}ಪಾದ", "ರೇಸರ\u{ccd}", "ಶೇವ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("면도칼"),
            keywords: &["날카로운", "면도", "면도칼"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("कातर"),
            keywords: &["कातर", "धारदार", "श\u{947}व"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("устара"),
            keywords: &["курч", "сакал алуу", "устара"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ມ\u{eb5}ດ\u{200b}ແຖ"),
            keywords: &["ຄ\u{ebb}ມ", "ມ\u{eb5}ດ", "ມ\u{eb5}ດ\u{200b}ແຖ", "ແຖ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("skustuvas"),
            keywords: &["aštrus", "skusti", "skustuvas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("bārdas nazis"),
            keywords: &["ass", "bārdas nazis", "skūt"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("брич"),
            keywords: &["брич", "бричење", "остар"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("റേസർ"),
            keywords: &[
                "ക\u{d42}ർത\u{d4d}തത\u{d4d}",
                "ക\u{d4d}ഷ\u{d57}രം ചെയ\u{d4d}യ\u{d41}ക",
                "റേസർ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("сахлын хутга"),
            keywords: &["ир", "сахал хусах", "сахлын хутга", "хутга"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("वस\u{94d}तरा"),
            keywords: &["दाढी", "धारदार", "वस\u{94d}तरा"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pisau cukur"),
            keywords: &["cukur", "pisau cukur", "tajam"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မောင\u{103a}းချဓား"),
            keywords: &["ထက\u{103a}သော", "မောင\u{103a}းချဓား", "ရ\u{102d}တ\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("barberkniv"),
            keywords: &["barbere", "barbering", "barberkniv", "skarp"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("र\u{947}जर"),
            keywords: &["खौरिन\u{941}", "तिखो", "र\u{947}जर"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("scheermes"),
            keywords: &["scheermes", "scheren", "scherp"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("barberkniv"),
            keywords: &["barbere", "barbering", "barberkniv", "skarp"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ରେଜର"),
            keywords: &[
                "ଦ\u{b3e}ଢ\u{b3c}\u{b3f} କ\u{b3e}ଟ\u{b3f}ବ\u{b3e}",
                "ମ\u{b41}ନ\u{b3f}ଆ",
                "ରେଜର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਉਸਤਰਾ"),
            keywords: &["ਉਸਤਰਾ", "ਤਿ\u{a71}ਖਾ", "ਹਜਾਮਤ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Rézọ"),
            keywords: &["Rézọ", "Shap", "Shev"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("brzytwa"),
            keywords: &["brzytwa", "golenie", "ostre narzędzie"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("چاړه (د ږيرې)"),
            keywords: &["تېره", "خريينه", "چاړه (د ږيرې)"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("lâmina"),
            keywords: &["afiada", "barbear", "lâmina"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("lâmina de barbear"),
            keywords: &["afiado", "barbear", "lâmina de barbear"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("brici"),
            keywords: &["ascuțit", "brici", "bărbierit", "ras"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–071"),
            keywords: &["E12–071"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("бритва"),
            keywords: &["бритва", "бритье", "бриться", "опасная"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ريزر"),
            keywords: &["تيز", "ريزر", "شيو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("දැළ\u{dd2} ප\u{dd2}හ\u{dd2}ය"),
            keywords: &[
                "ත\u{dd2}ය\u{dd4}ණ\u{dd4}",
                "දැළ\u{dd2} ප\u{dd2}හ\u{dd2}ය",
                "රැව\u{dd4}ල බෑම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("britva"),
            keywords: &["britva", "holenie", "holiace", "holiť", "oholiť", "ostrý"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("britev"),
            keywords: &["britev", "britje", "britvica", "ostro"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("sakiin"),
            keywords: &["af leh", "sakiin", "xiirid"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("brisk rroje"),
            keywords: &["brisk rroje", "i mprehtë", "rruajtje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("бријач"),
            keywords: &["бријач", "бријање", "избријан"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("brijač"),
            keywords: &["brijanje", "brijač", "izbrijan"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("rakhyvel"),
            keywords: &["raka", "rakhyvel", "vass"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("wembe"),
            keywords: &["kali", "kunyoa", "wembe"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ரேஸர\u{bcd}"),
            keywords: &[
                "கூர\u{bcd}மென\u{bcd}கத\u{bcd}தி",
                "சவரக\u{bcd}கத\u{bcd}தி",
                "ரேஸர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ర\u{c47}జర\u{c4d}"),
            keywords: &["క\u{c4d}షవరం", "పదును", "ర\u{c47}జర\u{c4d}"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ใบม\u{e35}ดโกน"),
            keywords: &["คม", "โกนหนวด", "ใบม\u{e35}ดโกน"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("päki"),
            keywords: &["päki", "sakal syr", "ýiti"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("telekava"),
            keywords: &["telekava"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ustura"),
            keywords: &["keskin", "tıraş", "ustura"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("бритва"),
            keywords: &["бритва", "голити", "голитися", "гостра", "небезпечна"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("استرا"),
            keywords: &["استرا", "تیز دھار", "شیو"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ustara"),
            keywords: &["oʻtkir", "soqol olish", "tigʻ", "ustara"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("dao cạo"),
            keywords: &["cạo râu", "dao cạo", "sắc"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("剃刀"),
            keywords: &["利", "剃刀", "剃鬚"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("剃刀"),
            keywords: &["利", "剃刀", "剃须"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("剃须刀"),
            keywords: &["刀", "刮", "剃须刀", "毛", "胡子", "锋利"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("剃刀"),
            keywords: &["剃", "剃刀", "鋒利"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-razor"),
            keywords: &["cija", "i-razor", "shefa"],
        },
    ],
};
#[doc = "🧴"]
pub const LOTION_BOTTLE: crate::Emoji = crate::Emoji {
    glyph: "🧴",
    codepoint: "1F9F4",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "lotion bottle",
    group: "Objects",
    subgroup: "household",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("lyfroombottel"),
            keywords: &[
                "lyfroom",
                "lyfroombottel",
                "room",
                "sjampoe",
                "sonbrandmiddel",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የቅባት ጠርሙስ"),
            keywords: &["ሻምፖ", "ቅባት", "የቅባት ጠርሙስ", "የጸሃይ ቅባት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("زجاجة غسول"),
            keywords: &["زجاجة غسول", "شامبو", "غسول", "مرطب", "واقي من الشمس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("লোশ\u{9cd}বনৰ বটল"),
            keywords: &[
                "চেম\u{9cd}প\u{9c1}",
                "ছ\u{9be}নস\u{9cd}ক\u{9cd}ৰীণ",
                "মইশ\u{9cd}চ\u{9be}ৰ\u{9be}ইজ\u{9be}ৰ",
                "লোশ\u{9cd}বন",
                "লোশ\u{9cd}বনৰ বটল",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("losyon şüşəsi"),
            keywords: &[
                "gün kremi",
                "losyon",
                "losyon şüşəsi",
                "nəmləndirici",
                "şampun",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("бутэлька з ласьёнам"),
            keywords: &[
                "ахова ад сонца",
                "бутэлька з ласьёнам",
                "крэм",
                "ласьён",
                "шампунь",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("бутилка с лосион"),
            keywords: &[
                "бутилка с лосион",
                "лосион",
                "слънцезащитен продукт",
                "хидратантен крем",
                "шампоан",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("লোশন বোতল"),
            keywords: &[
                "ময\u{9bc}শ\u{9cd}চ\u{9be}র\u{9be}ইজ\u{9be}র",
                "লোশন",
                "লোশন বোতল",
                "শ\u{9cd}য\u{9be}ম\u{9cd}প\u{9c1}",
                "স\u{9be}নস\u{9cd}ক\u{9cd}রিন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("boutailhad golcʼhad"),
            keywords: &["boutailhad", "champouenn", "golcʼhad"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("losion"),
            keywords: &["losion", "ovlaživač", "zaštitni faktor", "šampon"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("ampolla de crema"),
            keywords: &[
                "ampolla de crema",
                "loció",
                "protecció solar",
                "suavitzant",
                "xampú",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏓᏅᎵᏰᏗ ᎫᎦ"),
            keywords: &[
                "ᎠᏓᏅᎵᏰᏗ",
                "ᎠᏓᏅᎵᏰᏗ ᎫᎦ",
                "ᎠᏰᎸ ᎦᏅᎵᏰᏗ",
                "ᎣᏜ ᎠᎵᏍᏚᎵᏙᏗ",
                "ᏅᏓ ᎠᏓᎴᏗᏍᎩ ᏂᎦᏒᎾ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("láhev na kosmetiku"),
            keywords: &[
                "gel",
                "krém",
                "láhev na kosmetiku",
                "opalovací",
                "pleťový",
                "šampon",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("potel hufen"),
            keywords: &["eli haul", "hufen", "lleithydd", "potel hufen", "siampw"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bodylotion"),
            keywords: &[
                "bodylotion",
                "fugtighedscreme",
                "lotion",
                "shampoo",
                "solcreme",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Creme"),
            keywords: &[
                "Creme",
                "Feuchtigkeitscreme",
                "Körpercreme",
                "Shampoo",
                "Sonnencreme",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μπουκάλι λοσιόν"),
            keywords: &[
                "αντιηλιακό",
                "ενυδατική",
                "λοσιόν",
                "μπουκάλι λοσιόν",
                "σαμπουάν",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("lotion bottle"),
            keywords: &[
                "lotion",
                "lotion bottle",
                "moisturizer",
                "shampoo",
                "sunscreen",
            ],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &[
                "lotion",
                "lotion bottle",
                "moisturiser",
                "shampoo",
                "sunscreen",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &[
                "lotion",
                "lotion bottle",
                "moisturiser",
                "shampoo",
                "sunscreen",
            ],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bote de crema"),
            keywords: &[
                "bote de crema",
                "champú",
                "crema",
                "hidratante",
                "protector solar",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("botella de loción"),
            keywords: &[
                "botella de loción",
                "champú",
                "humectante",
                "loción",
                "protector solar",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("emulsioonipudel"),
            keywords: &[
                "emulsioon",
                "emulsioonipudel",
                "niisutav kreem",
                "päevituskreem",
                "šampoon",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("lozio-botila"),
            keywords: &[
                "eguzki-babes",
                "hidratatzaile",
                "lozio",
                "lozio-botila",
                "xanpu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بطری لوسیون"),
            keywords: &[
                "بطری لوسیون",
                "شامپو",
                "لوسیون",
                "مرطوب\u{200c}کننده",
                "کرم ضدآفتاب",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hoitoainepullo"),
            keywords: &[
                "aurinkovoide",
                "hoitoaine",
                "hoitoainepullo",
                "kosteusvoide",
                "sampoo",
                "shampoo",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bote ng losyon"),
            keywords: &[
                "bote ng losyon",
                "bote ng lotion",
                "lotion",
                "moisturizer",
                "shampoo",
                "sunscreen",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("lotiónfløska"),
            keywords: &["fløska", "húðkrem", "lotión", "lotiónfløska", "smyrsl"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bouteille de lotion"),
            keywords: &[
                "bouteille de lotion",
                "crème hydratante",
                "crème solaire",
                "flacon",
                "lotion",
                "shampooing",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("buidéal lóise"),
            keywords: &[
                "buidéal lóise",
                "lóis",
                "maothóir",
                "seampú",
                "uachtar gréine",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("botal lòisein"),
            keywords: &[
                "bana-bhuidseach",
                "botal lòisein",
                "buidseach",
                "glanadh",
                "sguabadh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("envase cosmético"),
            keywords: &[
                "champú",
                "crema solar",
                "envase cosmético",
                "loción",
                "suavizante",
                "xel",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લોશનની બોટલ"),
            keywords: &[
                "મોઇસ\u{acd}ચરાઇઝર",
                "લોશન",
                "લોશનની બોટલ",
                "શ\u{ac7}મ\u{acd}પ\u{ac2}",
                "સનસ\u{acd}ક\u{acd}રીન",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קרם לחות"),
            keywords: &["לחות", "קרם", "קרם הגנה", "שמפו", "תחליב"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("लोशन की बोतल"),
            keywords: &[
                "मॉइश\u{94d}चरॉइज\u{93c}र",
                "लोशन",
                "लोशन की बोतल",
                "श\u{948}\u{902}प\u{942}",
                "सनस\u{94d}क\u{94d}रीन",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("bočica losiona"),
            keywords: &[
                "bočica losiona",
                "krema za sunčanje",
                "losion",
                "losion za tijelo",
                "šampon",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("krémes flakon"),
            keywords: &[
                "hidratáló",
                "krém",
                "krémes flakon",
                "napvédő krém",
                "sampon",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("լոսիոնի շիշ"),
            keywords: &["լոսիոն", "լոսիոնի շիշ", "խոնավացնող", "շամպուն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("botol losion"),
            keywords: &[
                "botol losion",
                "losion",
                "moisturizer",
                "sampo",
                "tabir surya",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("áburðarflaska"),
            keywords: &["krem", "sjampó", "sólarvörn", "áburðarflaska", "áburður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("flacone"),
            keywords: &[
                "crema idratante",
                "crema solare",
                "flacone",
                "lozione",
                "shampoo",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ローション"),
            keywords: &["シャンプー", "ローション", "化粧水", "日焼け止め"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("botol losion"),
            keywords: &[
                "botol losion",
                "krim kulit",
                "losion",
                "sampo",
                "tabir surya",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ლოსიონის ბოთლი"),
            keywords: &[
                "ლოსიონი",
                "ლოსიონის ბოთლი",
                "მზისგან დამცავი",
                "სველსაფენი",
                "შამპუნი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("лосьон құтысы"),
            keywords: &[
                "күннен қорғау",
                "лосьон",
                "лосьон құтысы",
                "шампун",
                "ылғалдағыш",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ដបឡេ"),
            keywords: &[
                "ក\u{17d2}រែមរក\u{17d2}សាស\u{17c6}ណើម",
                "ដបឡេ",
                "សាប\u{17ca}\u{17bc}កក\u{17cb}សក\u{17cb}",
                "ឡេ",
                "ឡេការពារកម\u{17d2}ដៅថ\u{17d2}ងៃ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಲೋಷನ\u{ccd} ಬಾಟಲ\u{ccd}"),
            keywords: &[
                "ಮಾಯ\u{cbf}ಶ\u{ccd}ಚರೈಸರ\u{ccd}",
                "ಲೋಷನ\u{ccd}",
                "ಲೋಷನ\u{ccd} ಬಾಟಲ\u{ccd}",
                "ಶಾಂಪ\u{cc2}",
                "ಸನ\u{ccd}\u{200c}ಸ\u{ccd}ಕ\u{ccd}ರೀನ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("로션"),
            keywords: &["로션", "모이스처라이저", "샴푸", "선크림"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("लोशन बाटली"),
            keywords: &[
                "मॉयश\u{94d}चरायझर",
                "लोशन",
                "लोशन बाटली",
                "श\u{945}म\u{94d}प\u{942}",
                "सन\u{94d}स\u{94d}क\u{94d}रिन",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("лосьон куюлган идиш"),
            keywords: &[
                "күндөн коргоо",
                "лосьон",
                "лосьон куюлган идиш",
                "нымдагыч",
                "шампунь",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຂວດໂລຊ\u{eb1}\u{ec8}ນ"),
            keywords: &[
                "ຂວດໂລຊ\u{eb1}\u{ec8}ນ",
                "ຄຣ\u{eb5}ມກ\u{eb1}ນແດດ",
                "ຄວາມຊ\u{eb8}ມຊ\u{eb7}\u{ec8}ນ",
                "ແຊມພ\u{eb9}",
                "ໂລຊ\u{eb1}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("losjono buteliukas"),
            keywords: &[
                "apsauga nuo saulės",
                "drėkinamasis kremas",
                "losjonas",
                "losjono buteliukas",
                "šampūnas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("losjona pudele"),
            keywords: &[
                "losjona pudele",
                "losjons",
                "mitrinātājs",
                "sauļošanās krēms",
                "šampūns",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("шише со лосион"),
            keywords: &[
                "влажност",
                "заштита од сонце",
                "лосион",
                "шампон",
                "шише со лосион",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ലോഷൻ ബോട\u{d4d}ടിൽ"),
            keywords: &[
                "മോയ\u{d4d}\u{200c}ച\u{d4d}ച\u{d41}റൈസർ",
                "ലോഷൻ",
                "ലോഷൻ ബോട\u{d4d}ടിൽ",
                "ഷ\u{d3e}മ\u{d4d}പ\u{d42}",
                "സൺസ\u{d4d}\u{200c}ക\u{d4d}രീൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("тосны сав"),
            keywords: &["нарны тос", "тос", "тосны сав", "чийгшүүлэгч", "шампунь"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("लोशन बॉटल"),
            keywords: &[
                "मॉइस\u{94d}चरायझर",
                "लोशन",
                "लोशन बॉटल",
                "शाम\u{94d}प\u{942}",
                "सनस\u{94d}क\u{94d}रीन",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("botol losyen"),
            keywords: &[
                "botol losyen",
                "losyen",
                "pelembab",
                "penapis suria",
                "syampu",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လ\u{102d}မ\u{103a}းဆေးဘ\u{1030}း"),
            keywords: &[
                "ခေါင\u{103a}းလျ\u{103e}ော\u{103a}ရည\u{103a}",
                "နေပ\u{1030}ခ\u{1036}လ\u{102d}မ\u{103a}းဆေး",
                "လ\u{102d}မ\u{103a}းဆေး",
                "လ\u{102d}မ\u{103a}းဆေးဘ\u{1030}း",
                "အလ\u{103e}ဆ\u{102e}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("lotionflaske"),
            keywords: &[
                "fuktighetskrem",
                "lotion",
                "lotionflaske",
                "shampoo",
                "sjampo",
                "solkrem",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("लोसनको बोतल"),
            keywords: &[
                "मोइस\u{94d}चराइजर",
                "लोसन",
                "लोसनको बोतल",
                "श\u{94d}याम\u{94d}प\u{941}",
                "सनस\u{94d}क\u{94d}रिन",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("lotionfles"),
            keywords: &[
                "hydraterende lotion",
                "lotion",
                "lotionfles",
                "shampoo",
                "zonnebrandolie",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("lotionflaske"),
            keywords: &[
                "fuktigheitskrem",
                "lotion",
                "lotionflaske",
                "shampoo",
                "sjampo",
                "solkrem",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଲୋସନ ବଟଲ\u{b4d}\u{200c}"),
            keywords: &[
                "ମଶ\u{b4d}ଚ\u{b41}ର\u{b3e}ଇଜର",
                "ଲୋସନ",
                "ଲୋସନ ବଟଲ\u{b4d}\u{200c}",
                "ଶ\u{b3e}ମ\u{b4d}ପୋ",
                "ସନ\u{b4d}\u{200c}ସ\u{b4d}କ\u{b4d}ର\u{b3f}ନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲ\u{a4b}ਸ\u{a3c}ਣ ਵਾਲੀ ਬ\u{a4b}ਤਲ"),
            keywords: &[
                "ਮ\u{a4b}ਆਇਚਰਾਈਜ\u{a3c}ਰ",
                "ਲ\u{a4b}ਸ\u{a3c}ਣ ਵਾਲੀ ਬ\u{a4b}ਤਲ",
                "ਲ\u{a4b}ਸ\u{a3c}ਨ",
                "ਸਨਸਕ\u{a4d}ਰੀਨ",
                "ਸ\u{a3c}\u{a48}\u{a02}ਪ\u{a42}",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Lóshọ\u{301}n Bọ\u{301}tul"),
            keywords: &[
                "Krim Wé De Mék Bọdí Mék I Nọ\u{301} Dé Drai",
                "Lóshọn",
                "Lóshọ\u{301}n Bọ\u{301}tul",
                "Mọischọraíza",
                "Shampú",
                "Sọ\u{301}nskrin",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("butelka z płynem"),
            keywords: &[
                "balsam",
                "butelka z płynem",
                "krem do opalania",
                "mleczko",
                "szampon",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د مرهم بوتل"),
            keywords: &[
                "د لمر څخه حفاظت",
                "د مرهم بوتل",
                "شامبو",
                "لوشن",
                "نرموونکی",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("frasco de loção"),
            keywords: &[
                "frasco de loção",
                "hidratante",
                "loção",
                "protetor solar",
                "xampu",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "champô",
                "frasco de loção",
                "hidratante",
                "loção",
                "protetor solar",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("flacon de loțiune"),
            keywords: &[
                "cremă",
                "flacon de loțiune",
                "loțiune",
                "protecție solară",
                "șampon",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-062"),
            keywords: &["E11-062"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("бутылка лосьона"),
            keywords: &[
                "бальзам",
                "бутылка лосьона",
                "гель для душа",
                "кондиционер",
                "шампунь",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("لوشن جي بوتل"),
            keywords: &["سن اسڪرين", "شيمپو", "لوشن", "لوشن جي بوتل", "موئسچرائيز"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ලෝෂන\u{dca} බෝතලය"),
            keywords: &[
                "මොය\u{dd2}ස\u{dca}චරය\u{dd2}සර\u{dca}",
                "ලෝෂන\u{dca}",
                "ලෝෂන\u{dca} බෝතලය",
                "ෂැම\u{dca}ප\u{dd4}",
                "හ\u{dd2}ර\u{dd4} ක\u{dca}\u{200d}ර\u{dd3}ම\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("vodička"),
            keywords: &["hydratačný krém", "slnečný krém", "vodička", "šampón"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("steklenička losjona"),
            keywords: &[
                "krema za sončenje",
                "losjon",
                "steklenička losjona",
                "vlažilna krema",
                "šampon",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("caagada looshinka"),
            keywords: &[
                "caagada looshinka",
                "kiriimka cadceeda",
                "looshin",
                "qaleyl biiye",
                "shaamboo",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shishe solucioni"),
            keywords: &[
                "locion",
                "shampo",
                "shishe solucioni",
                "solucion",
                "tretës",
                "zbutës",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("боца за лосион"),
            keywords: &[
                "боца за лосион",
                "лосион",
                "препарат за сунчање",
                "хидратантна крема",
                "шампон",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("boca za losion"),
            keywords: &[
                "boca za losion",
                "hidratantna krema",
                "losion",
                "preparat za sunčanje",
                "šampon",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("lotionflaska"),
            keywords: &["kräm", "lotion", "lotionflaska", "shampoo", "solkräm"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("chupa ya losheni"),
            keywords: &[
                "chupa ya losheni",
                "kisitiri jua",
                "losheni",
                "mafuta",
                "shampuu",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("லோஷன\u{bcd} ப\u{bbe}ட\u{bcd}டில\u{bcd}"),
            keywords: &[
                "சன\u{bcd}ஸ\u{bcd}கிர\u{bc0}ன\u{bcd}",
                "ம\u{bbe}ய\u{bcd}ஸ\u{bcd}சரைசர\u{bcd}",
                "லோஷன\u{bcd}",
                "லோஷன\u{bcd} ப\u{bbe}ட\u{bcd}டில\u{bcd}",
                "ஷ\u{bbe}ம\u{bcd}பு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ల\u{c4b}షన\u{c4d} బ\u{c3e}ట\u{c3f}ల\u{c4d}"),
            keywords: &[
                "మ\u{c3e}య\u{c3f}శ\u{c4d}చర\u{c48}జర\u{c4d}",
                "ల\u{c4b}షన\u{c4d}",
                "ల\u{c4b}షన\u{c4d} బ\u{c3e}ట\u{c3f}ల\u{c4d}",
                "ష\u{c3e}ంపూ",
                "సన\u{c4d}\u{200c}స\u{c4d}క\u{c4d}ర\u{c40}న\u{c4d}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ขวดโลช\u{e31}\u{e48}น"),
            keywords: &[
                "ขวดโลช\u{e31}\u{e48}น",
                "คร\u{e35}มก\u{e31}นแดด",
                "คร\u{e35}มบำร\u{e38}งผ\u{e34}ว",
                "แชมพ\u{e39}",
                "โลช\u{e31}\u{e48}น",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("losýon çüýşesi"),
            keywords: &[
                "günden goraýjy",
                "losýon",
                "losýon çüýşesi",
                "çyglandyryjy",
                "şampun",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("hina kilimi milimili"),
            keywords: &["hina kilimi milimili"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("losyon şişesi"),
            keywords: &[
                "güneş kremi",
                "losyon",
                "losyon şişesi",
                "nemlendirici",
                "şampuan",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("лосьйон"),
            keywords: &["зволожувач", "лосьйон", "сонцезахисний крем", "шампунь"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("لوشن کی بوتل"),
            keywords: &[
                "سورج کی تمازت سے بچنے کے لیے ج\u{650}لدی کریم",
                "شیمپو",
                "لوشن",
                "لوشن کی بوتل",
                "موئسچرائزر",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("losyon shishasi"),
            keywords: &[
                "balzam",
                "dush geli",
                "konditsioner",
                "losyon",
                "losyon shishasi",
                "namlagich",
                "shampun",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("chai sữa dưỡng da"),
            keywords: &[
                "chai sữa dưỡng da",
                "dầu gội",
                "kem chống nắng",
                "kem dưỡng ẩm",
                "sữa dưỡng da",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("乳液樽"),
            keywords: &["乳液", "乳液樽", "洗頭水", "潤膚霜", "防曬"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("乳液樽"),
            keywords: &["乳液", "乳液樽", "洗头水", "润肤霜", "防晒"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("乳液瓶"),
            keywords: &["乳液", "乳液瓶", "护肤霜", "洗发水", "防晒霜"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("乳液瓶"),
            keywords: &["乳液", "乳液瓶", "保濕", "洗髮精", "防曬"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("潤膚乳樽"),
            keywords: &["lotion", "保濕", "洗髮水", "潤膚乳", "潤膚乳樽", "防曬"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhodlela leloshini"),
            keywords: &[
                "ibhodlela leloshini",
                "lotion",
                "lotion bottle",
                "moisturizer",
                "shampoo",
                "sunscreen",
            ],
        },
    ],
};
#[doc = "🧷"]
pub const SAFETY_PIN: crate::Emoji = crate::Emoji {
    glyph: "🧷",
    codepoint: "1F9F7",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "safety pin",
    group: "Objects",
    subgroup: "household",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("haakspeld"),
            keywords: &["doek", "haakspeld", "punk rock"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መርፌ ቁልፍ"),
            keywords: &["መርፌ ቁልፍ", "የተልባ እግር", "ፐንክ ሮክ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("دبوس أمان"),
            keywords: &["حفاضة", "حقيبة بانك روك", "دبوس أمان"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ছেফ\u{9cd}টী পিন"),
            keywords: &["ছেফ\u{9cd}টী পিন", "ড\u{9be}ইপ\u{9be}ৰ", "প\u{9be}ংক ৰক"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sancaq"),
            keywords: &["pank rok", "ped", "sancaq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("шпілька"),
            keywords: &["панк-рок", "шпілька"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("безопасна игла"),
            keywords: &["безопасна игла", "закопчавам", "игла"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("সেফটি পিন"),
            keywords: &["ড\u{9be}ইপ\u{9be}র", "প\u{9be}ঙ\u{9cd}ক রক", "সেফটি পিন"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("spilhenn-alcʼhwez"),
            keywords: &["gwiadennoù", "lienoù", "spilhenn-alcʼhwez", "trezenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("bašlija"),
            keywords: &["bašlija", "punk rock"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("imperdible"),
            keywords: &["imperdible", "punk", "punk rock"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏍᏆᏘ"),
            keywords: &["ᎤᎾᏎᎶᏙᏗ", "ᎤᏍᏆᏘ", "ᏔᏩᎵ ᏅᏯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("spínací špendlík"),
            keywords: &[
                "pankáč",
                "plenky",
                "pleny",
                "punk",
                "spínací špendlík",
                "zavírací špendlík",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("pin diogelwch"),
            keywords: &["cewyn", "pin diogelwch", "roc pync"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sikkerhedsnål"),
            keywords: &["ble", "punk-rock", "sikkerhedsnål"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Sicherheitsnadel"),
            keywords: &["Punk", "Sicherheitsnadel", "Windel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("παραμάνα"),
            keywords: &["πάνα", "πανκ ροκ", "παραμάνα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("safety pin"),
            keywords: &["diaper", "punk rock", "safety pin"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["nappy", "punk rock", "safety pin"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["nappy", "punk rock", "safety pin"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["nappy", "punk rock", "safety pin"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("imperdible"),
            keywords: &["imperdible", "pañal", "punk rock"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("broche de seguridad"),
            keywords: &["broche", "broche de seguridad", "pañal"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["imperdible", "pañal", "seguro"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("haaknõel"),
            keywords: &["haaknõel", "mähe", "punkrokk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kateorratz"),
            keywords: &["kateorratz", "pixoihal", "punk"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("سنجاق قفلی"),
            keywords: &["سنجاق", "سنجاق قفلی", "سوزن", "پانک\u{200c}راک", "پوشک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hakaneula"),
            keywords: &["hakaneula", "punk", "punkkari", "vaippa"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("perdible"),
            keywords: &["diaper", "perdible", "punk rock"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("trygdarnál"),
            keywords: &["læsinál", "nál", "trygdarnál"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("épingle de sûreté"),
            keywords: &["couche", "lange", "punk rock", "épingle de sûreté"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("biorán dúnta"),
            keywords: &["biorán dúnta", "clúdín", "punc-cheol"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("prìne-dùbailte"),
            keywords: &["badan", "prìne-dùbailte", "puncair", "punk"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("imperdible"),
            keywords: &["imperdible", "prendedor", "prender"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{ac7}ફ\u{acd}ટી પિન"),
            keywords: &["ડાયપર", "પ\u{a82}ક રૉક", "સ\u{ac7}ફ\u{acd}ટી પિન"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סיכת ביטחון"),
            keywords: &["חיתול", "סיכת ביטחון", "פאנק רוק"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{947}फ\u{93c}\u{94d}टी पिन"),
            keywords: &["डायपर", "प\u{902}क रॉक", "स\u{947}फ\u{93c}\u{94d}टी पिन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("sigurnica"),
            keywords: &["pelena", "punk rock", "sigurnica", "ziherica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("biztosítótű"),
            keywords: &["biztosítótű", "pelenka", "punk rock"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("անգլիական քորոց"),
            keywords: &["անգլիական քորոց", "տակդիր", "փանկ ռոք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("peniti"),
            keywords: &["peniti", "popok", "punk rock"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("öryggisnæla"),
            keywords: &["bleyja", "pönk", "sikrisnæla", "öryggisnæla"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("spilla da balia"),
            keywords: &["pannolone", "punk rock", "spilla da balia"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("安全ピン"),
            keywords: &["安全ピン", "止めピン"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("peniti"),
            keywords: &["peniti", "popok", "punk rock"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქინძისთავი"),
            keywords: &["სამაგრი", "ქინძისთავი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("түйреуіш"),
            keywords: &["ою мата", "панк-рок", "түйреуіш"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17d2}ជ\u{17bb}លខ\u{17d2}ទាស\u{17cb}"),
            keywords: &[
                "ក\u{17d2}រណាត\u{17cb}ទ\u{17d2}រាប\u{17cb}គ\u{17bc}ទក\u{17d2}មេង",
                "តន\u{17d2}ត\u{17d2}រ\u{17b8}រ\u{17c9}\u{17bb}កញាក\u{17cb}ខ\u{17d2}លា\u{17c6}ង",
                "ម\u{17d2}ជ\u{17bb}លខ\u{17d2}ទាស\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸೇಫ\u{ccd}ಟ\u{cbf} ಪ\u{cbf}ನ\u{ccd}"),
            keywords: &[
                "ಡೈಪರ\u{ccd}",
                "ಪಂಕ\u{ccd} ರಾಕ\u{ccd}",
                "ಸೇಫ\u{ccd}ಟ\u{cbf} ಪ\u{cbf}ನ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("옷핀"),
            keywords: &["고정용 핀", "옷핀"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("स\u{947}फ\u{94d}टी पिन"),
            keywords: &[
                "आल\u{94d}फिन\u{947}त",
                "डायपर",
                "प\u{902}क रॉक",
                "स\u{947}फ\u{94d}टी पिन",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("төөнөгүч"),
            keywords: &["панк рок", "төөнөгүч"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ມ\u{eb8}ດປ\u{eb1}ກກ\u{eb1}ນໄພ"),
            keywords: &[
                "ນາງແພດສະຍາ",
                "ຜ\u{ec9}າອ\u{ec9}ອມເດ\u{eb1}ກ",
                "ມ\u{eb8}ດປ\u{eb1}ກກ\u{eb1}ນໄພ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žiogelis"),
            keywords: &["pankrokas", "vystyklai", "žiogelis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("saspraude"),
            keywords: &["autiņi", "pankroks", "saspraude"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("безопасна игла"),
            keywords: &["безопасна игла", "панк-рок", "пелена"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സേഫ\u{d4d}\u{200c}റ\u{d4d}റി പിൻ"),
            keywords: &[
                "ഡയപ\u{d4d}പർ",
                "പങ\u{d4d}ക\u{d4d} റോക\u{d4d}ക\u{d4d}",
                "സേഫ\u{d4d}\u{200c}റ\u{d4d}റി പിൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("сүлбээр зүү"),
            keywords: &["живх", "панк рок", "сүлбээр зүү"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{947}फ\u{94d}टि पिन"),
            keywords: &["डायपर", "प\u{902}क रॉक", "स\u{947}फ\u{94d}टि पिन"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pin dawai"),
            keywords: &["lampin", "pin dawai", "punk rock"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တ\u{103d}ယ\u{103a}ချ\u{102d}တ\u{103a}"),
            keywords: &[
                "ကလေး ခါးထောင\u{103a}းကျ\u{102d}\u{102f}က\u{103a}ပ\u{102d}တ\u{103a}စ",
                "တ\u{103d}ယ\u{103a}ချ\u{102d}တ\u{103a}",
                "ပန\u{1037}\u{103a}ခ\u{103a} ရော\u{1037}ခ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sikkerhetsnål"),
            keywords: &["bleie", "punk", "sikkerhetsnål"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ह\u{941}क\u{94d}सियो"),
            keywords: &["डायपर", "पङ\u{94d}क रक", "ह\u{941}क\u{94d}सियो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("veiligheidsspeld"),
            keywords: &["luier", "punk", "veiligheidsspeld"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("sikkerheitsnål"),
            keywords: &["bleie", "punk", "sikkerheitsnål"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସେପ\u{b4d}ଟ\u{b3f} ପ\u{b3f}ନ\u{b4d}\u{200c}"),
            keywords: &[
                "ଡ\u{b3e}ଏପର\u{b4d}\u{200c}",
                "ପଙ\u{b4d}କ ରକ\u{b4d}\u{200c}",
                "ସେପ\u{b4d}ଟ\u{b3f} ପ\u{b3f}ନ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a47}ਫ\u{a3c}ਟੀ ਪਿ\u{a70}ਨ"),
            keywords: &[
                "ਡਾਇਪਰ",
                "ਪ\u{a70}ਕ ਰ\u{a4c}ਕ",
                "ਸ\u{a47}ਫ\u{a3c}ਟੀ ਪਿ\u{a70}ਨ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Séfti Pin"),
            keywords: &["Bébí Nápkin", "Séfti Pin"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("agrafka"),
            keywords: &["agrafka", "pielucha", "punk", "punk rock"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("حفاظتي پن"),
            keywords: &["بکسوه", "حفاظتي پن", "ډايپر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("alfinete de segurança"),
            keywords: &["alfinete de segurança", "fralda", "punk rock"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("alfinete de dama"),
            keywords: &["alfinete de dama", "fralda", "punk rock"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ac de siguranță"),
            keywords: &["ac de siguranță", "scutec"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-065"),
            keywords: &["E11-065"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("английская булавка"),
            keywords: &["английская булавка", "булавка", "пристегнуть"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("حفاظتي پن"),
            keywords: &["حفاظتي پن", "پنڪ روڪ", "ڊائپر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ආරක\u{dca}ෂ\u{dd2}ත ප\u{dd2}න\u{dca}"),
            keywords: &[
                "ආරක\u{dca}ෂ\u{dd2}ත ප\u{dd2}න\u{dca}",
                "ඩයපර\u{dca}",
                "පැන\u{dca}ක\u{dca} රොක\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("spínací špendlík"),
            keywords: &["pankáč", "pankáčka", "spínací špendlík"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("varnostna zaponka"),
            keywords: &["plenica", "punk rock", "varnostna zaponka"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("biinka dharka"),
            keywords: &["biinka dharka", "buun rok", "xafaayad"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("paramane"),
            keywords: &["mbërtheckë", "paramane", "pëlhurë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("зихернадла"),
            keywords: &["зихернадла", "панк-рок", "пелена"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("zihernadla"),
            keywords: &["pank-rok", "pelena", "zihernadla"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("säkerhetsnål"),
            keywords: &["blöja", "punkrock", "säkerhetsnål"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kikwasi"),
            keywords: &["kikwasi", "nepi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஊக\u{bcd}கு"),
            keywords: &[
                "ஊக\u{bcd}கு",
                "டயபர\u{bcd}",
                "பங\u{bcd}க\u{bcd} ர\u{bbe}க\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c3f}న\u{c4d}ను, ప\u{c3f}న\u{c4d}న\u{c40}సు"),
            keywords: &[
                "డ\u{c48}పర\u{c4d}",
                "పంక\u{c4d} ర\u{c3e}క\u{c4d}",
                "ప\u{c3f}న\u{c4d}ను",
                "ప\u{c3f}న\u{c4d}ను, ప\u{c3f}న\u{c4d}న\u{c40}సు",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เข\u{e47}มกล\u{e31}ดซ\u{e48}อนปลาย"),
            keywords: &[
                "ผ\u{e49}าอ\u{e49}อม",
                "พ\u{e31}\u{e49}งค\u{e4c}ร\u{e47}อค",
                "เข\u{e47}มกล\u{e31}ดซ\u{e48}อนปลาย",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("iňňebagjyk"),
            keywords: &["arlyk", "iňňebagjyk", "pank-rok"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pine nāpikeni"),
            keywords: &["pine nāpikeni"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("çengelli iğne"),
            keywords: &["bebek bezi", "punk rock", "çengelli iğne"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("англійська шпилька"),
            keywords: &[
                "англійська шпилька",
                "булавка",
                "зглаз",
                "панк-рок",
                "шпилька",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ح\u{650}فاظتی پ\u{650}ن"),
            keywords: &["ح\u{650}فاظتی پ\u{650}ن", "پ\u{64e}نک راک", "ڈائپر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("to‘g‘nag‘ich"),
            keywords: &["igna-tugma", "ildirish", "qadash", "to‘g‘nag‘ich"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ghim băng"),
            keywords: &["chất thải", "ghim băng", "tã"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("扣針"),
            keywords: &["尿片", "扣針"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("扣针"),
            keywords: &["尿片", "扣针"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("安全别针"),
            keywords: &["别针", "安全别针", "扣针"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("安全別針"),
            keywords: &["安全別針", "尿布", "龐克搖滾"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("扣針"),
            keywords: &["尿片｜punk rock", "扣針"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isipeletu"),
            keywords: &["diaper", "isipeletu", "punk rock"],
        },
    ],
};
#[doc = "🧹"]
pub const BROOM: crate::Emoji = crate::Emoji {
    glyph: "🧹",
    codepoint: "1F9F9",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "broom",
    group: "Objects",
    subgroup: "household",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("besem"),
            keywords: &["besem", "heks", "skoonmaak", "vee"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መጥረጊያ"),
            keywords: &["መጥረጊያ", "መጥረግ", "ማጽዳት", "አስማተኛ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مكنسة"),
            keywords: &["تنظيف", "ساحرة", "كنس", "مكنسة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ঝ\u{9be}ড\u{9bc}\u{9c1}"),
            keywords: &[
                "চ\u{9be}ফ\u{9be}ই কৰ\u{9be}",
                "ঝ\u{9be}ড\u{9bc}\u{9c1}",
                "ঝ\u{9be}ড\u{9bc}\u{9c1} দিয\u{9bc}\u{9be}",
                "য\u{9be}দ\u{9c1} কৰ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("süpürgə"),
            keywords: &["cadugər", "süpürgə", "süpürmə", "təmizləmə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мятла"),
            keywords: &["ведзьма", "мятла", "падмятаць", "прыбіраць"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("метла"),
            keywords: &["Баба Яга", "мета", "метла", "чистя"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ঝ\u{9be}ড\u{9bc}\u{9c1}"),
            keywords: &[
                "ঝ\u{9be}ড\u{9bc}\u{9c1}",
                "ঝ\u{9be}ড\u{9bc}\u{9c1} দেওয\u{9bc}\u{9be}",
                "ড\u{9be}ইনি",
                "স\u{9be}ফ\u{9be}ই",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("skubellenn"),
            keywords: &["naetaat", "skubellenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("metla"),
            keywords: &["metenje", "metla", "vještica", "čišćenje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("escombra"),
            keywords: &["bruixa", "escombra", "escombrar", "netejar"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎬᏃᏌᏯᏍᏗ"),
            keywords: &["ᎬᏃᏌᏯᏍᏗ", "ᏕᎦᏅᎦᎵᏍᎬ", "ᏕᎬᏃᏌᏍᎩ", "ᏥᎩᎵ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("koště"),
            keywords: &["koště", "uklízení", "zametání", "úklid", "čarodějnice"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ysgubell"),
            keywords: &["glanhau", "wrach", "ysgubell", "ysgubo"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kost"),
            keywords: &["feje", "heks", "kost", "rengøring"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Besen"),
            keywords: &["Besen", "Fegen", "Hexe", "Kehren"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σκούπα"),
            keywords: &["καθάρισμα", "μάγισσα", "σκούπα", "σκούπισμα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("broom"),
            keywords: &["broom", "cleaning", "sweeping", "witch"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("escoba"),
            keywords: &["barrer", "bruja", "escoba", "fregar"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("escoba"),
            keywords: &["barrer", "bruja", "escoba", "limpiar"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("escoba"),
            keywords: &["escoba"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("luud"),
            keywords: &["luud", "nõid", "puhastamine", "pühkimine"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("erratz"),
            keywords: &["erratz", "errazte", "garbitze", "sorgin"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("جارو"),
            keywords: &["تمیز کردن", "جادوگر", "جارو", "جارو زدن", "ساحره"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("luuta"),
            keywords: &["harja", "lakaisu", "luuta", "noita", "siivous"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("walis"),
            keywords: &["bruha", "maglinis", "magwalis", "walis"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kustur"),
            keywords: &["gandakelling", "kelling", "kustur", "sópa", "vaska"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("balai"),
            keywords: &["balai", "balayage", "nettoyage", "sorcière"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("scruab"),
            keywords: &["cailleach", "glanadh", "scruab", "scuabadh"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sguab"),
            keywords: &[
                "bana-bhuidseach",
                "buidseach",
                "glanadh",
                "sguab",
                "sguabadh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("vasoira"),
            keywords: &["bruxa", "limpar", "varrer", "vasoira"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લા\u{a82}બા હાથાવાળ\u{ac1}\u{a82} ઝાડ\u{ac1}"),
            keywords: &[
                "કચરાજાળા",
                "લા\u{a82}બા હાથાવાળ\u{ac1}\u{a82} ઝાડ\u{ac1}",
                "સફાઈ",
                "સાફસફાઈ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מטאטא"),
            keywords: &["לטאטא", "לנקות", "מטאטא", "מכשפה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("झाड\u{93c}\u{942}"),
            keywords: &[
                "जाद\u{942}गरनी",
                "झाड\u{93c}\u{942}",
                "झाड\u{942} निकालना",
                "सफ\u{93c}ाई करना",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("metla"),
            keywords: &["metenje", "metla", "vještica", "čišćenje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("seprű"),
            keywords: &["boszorkány", "seprés", "seprű", "tisztítás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ավել"),
            keywords: &["ավել", "ավլում", "կախարդ", "մաքրում"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("sapu"),
            keywords: &["membersihkan", "menyapu", "penyihir", "sapu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kústur"),
            keywords: &["kústur", "norn", "sópa", "þrif"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("scopa"),
            keywords: &["pulire", "scopa", "scopare", "spazzare", "strega"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ほうき"),
            keywords: &["ほうき", "掃く", "掃除", "魔女"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sapu"),
            keywords: &["nyapu", "penyihir", "reresik", "sapu"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ცოცხი"),
            keywords: &["დასუფთავება", "კუდიანი", "მეეზოვე", "ცოცხი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сыпырғы"),
            keywords: &["жалмауыз кемпір", "сыпыру", "сыпырғы", "тазалау"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("អម\u{17d2}បោស"),
            keywords: &[
                "ការបោស",
                "ការសម\u{17d2}អាត",
                "ធ\u{17d2}មប\u{17cb}",
                "អម\u{17d2}បោស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪೊರಕ\u{cc6}"),
            keywords: &[
                "ಗುಡ\u{cbf}ಸುವುದು",
                "ಪೊರಕ\u{cc6}",
                "ಸ\u{ccd}ವಚ\u{ccd}ಛಗೊಳ\u{cbf}ಸುವುದು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("빗자루"),
            keywords: &["마녀", "비질", "빗자루"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("सान\u{94d}न"),
            keywords: &["कोयर", "निवळ करप", "सान\u{94d}न", "सान\u{94d}न मारप"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("шыпыргы"),
            keywords: &["мастан", "тазалоо", "шыпыргоо", "шыпыргы"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຟອຍປ\u{eb1}ດກວດ"),
            keywords: &[
                "ປ\u{eb1}ດກວດ",
                "ຟອຍປ\u{eb1}ດກວດ",
                "ອະນາໄມ",
                "ແມ\u{ec8}ມ\u{ebb}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("šluota"),
            keywords: &["ragana", "valymas", "šlavimas", "šluota"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("slota"),
            keywords: &["slaucīšana", "slota", "tīrīšana"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("метла"),
            keywords: &["вештерка", "метење", "метла", "чистење"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ച\u{d42}ൽ"),
            keywords: &[
                "അടിച\u{d4d}ച\u{d41}വ\u{d3e}രൽ",
                "ച\u{d42}ൽ",
                "മന\u{d4d}ത\u{d4d}രവ\u{d3e}ദിനി",
                "വ\u{d43}ത\u{d4d}തിയ\u{d3e}ക\u{d4d}കൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хогийн шүүр"),
            keywords: &["хогийн шүүр", "цэвэрлэгээ", "шулам", "шүүрдэх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("झाड\u{942}"),
            keywords: &[
                "क\u{94d}लीनि\u{902}ग",
                "झाड\u{942}",
                "विच",
                "स\u{94d}वीपि\u{902}ग",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("penyapu"),
            keywords: &["ahli sihir", "membersih", "menyapu", "penyapu"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တ\u{1036}မြက\u{103a}စည\u{103a}း"),
            keywords: &[
                "စ\u{102f}န\u{103a}းမ",
                "တ\u{1036}မြက\u{103a}စည\u{103a}း",
                "တ\u{1036}မြက\u{103a}လ\u{103e}ည\u{103a}းခြင\u{103a}း",
                "သန\u{1037}\u{103a}ရ\u{103e}င\u{103a}းရေး",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("feiekost"),
            keywords: &["feie", "feiekost", "heks", "rengjøre"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("क\u{941}चो"),
            keywords: &[
                "क\u{941}चो",
                "बढार\u{94d}न\u{947} कार\u{94d}य",
                "बोक\u{94d}सी",
                "सफाइ कार\u{94d}य",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bezem"),
            keywords: &["bezem", "heks", "schoonmaken", "vegen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("feiekost"),
            keywords: &["feie", "feiekost", "heks", "reingjere"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଝ\u{b3e}ଡ\u{b41}"),
            keywords: &[
                "ଝ\u{b3e}ଡ\u{b41}",
                "ପ\u{b3f}ଶ\u{b3e}ଚ",
                "ବ\u{b4d}ୟ\u{b3e}ପକ",
                "ସଫ\u{b3e}କର\u{b3f}ବ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਝਾੜ\u{a42}"),
            keywords: &[
                "ਜਾਦ\u{a42}ਗਰਨੀ",
                "ਝਾੜ-ਪ\u{a42}\u{a70}ਝ",
                "ਝਾੜ\u{a42}",
                "ਸਫਾਈ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Brum"),
            keywords: &["Brum", "Klin", "Klínin", "Swip", "Wich"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("miotła"),
            keywords: &["czarownica", "miotła", "sprzątanie", "zamiatanie"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("جارو"),
            keywords: &["جارو", "جارو کول", "پاکول", "کوډ ګره"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("vassoura"),
            keywords: &["bruxa", "limpar", "varrer", "vassoura"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("mătură"),
            keywords: &["curățenie", "măturat", "mătură", "vrăjitoare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-067"),
            keywords: &["E11-067"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("метла"),
            keywords: &["ведьма", "веник", "метла", "подметать", "уборка"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٻهاري"),
            keywords: &["بروم", "جهاڙو", "سفائي", "ٻهاري", "ڏائڻ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කොස\u{dca}ස"),
            keywords: &[
                "කොස\u{dca}ස",
                "ප\u{dd2}ර\u{dd2}ස\u{dd2}ද\u{dd4} ක\u{dd2}ර\u{dd3}ම",
                "ප\u{dd4}ල\u{dd4}ල\u{dca} ක\u{dd2}ර\u{dd3}ම",
                "ම\u{dcf}ය\u{dcf}ක\u{dcf}ර\u{dd3}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("metla"),
            keywords: &["metla", "striga", "upratovať", "zametať"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("metla"),
            keywords: &["metla", "pometanje", "čarovnica", "čiščenje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("mafiiq/buluuyey"),
            keywords: &["mafiiq", "mafiiq/buluuyey", "masaxid", "nadiifin", "sixir"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fshesë"),
            keywords: &["fshesë", "fshirëse", "pastruese", "shtrigë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("метла"),
            keywords: &["брисање", "вештица", "метла", "чишћење"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["метла"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("metla"),
            keywords: &["brisanje", "metla", "veštica", "čišćenje"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["metla"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kvast"),
            keywords: &["häxa", "kvast", "sopa", "städa"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ufagio"),
            keywords: &["kufagia", "kusafisha", "mchawi", "ufagio"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("துடைப\u{bcd}பம\u{bcd}"),
            keywords: &[
                "சுத\u{bcd}தம\u{bcd}",
                "சூனியக\u{bcd}க\u{bbe}ரி",
                "துடைப\u{bcd}பம\u{bcd}",
                "துப\u{bcd}புரவு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c40}పురు"),
            keywords: &[
                "ఊడ\u{c4d}చడం",
                "చ\u{c40}పురు",
                "వ\u{c3f}చ\u{c4d}",
                "శుభ\u{c4d}రపరచడం",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ไม\u{e49}กวาด"),
            keywords: &[
                "กวาดบ\u{e49}าน",
                "ทำความสะอาด",
                "แม\u{e48}มด",
                "ไม\u{e49}กวาด",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("sübse"),
            keywords: &["arassalamak", "jadygöý", "syrmak", "sübse"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("taufale"),
            keywords: &["taufale"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("süpürge"),
            keywords: &["cadı", "süpürge", "süpürme", "temizlik"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("мітла"),
            keywords: &["відьма", "віник", "мітла", "прибирати", "підмітати"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جھاڑو"),
            keywords: &["جادوگرنی", "جھاڑو", "جھاڑو لگانا", "صفائی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("supurgi"),
            keywords: &["supurgi", "supurish", "tozalash", "yalmog‘iz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cây chổi"),
            keywords: &["cây chổi", "làm sạch", "phù thủy", "quét"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("掃把"),
            keywords: &["巫婆", "掃", "掃把", "清潔"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("扫把"),
            keywords: &["巫婆", "扫", "扫把", "清洁"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("扫帚"),
            keywords: &["女巫", "打扫", "扫地", "扫帚"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("掃帚"),
            keywords: &["巫婆", "掃", "掃帚", "清潔"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umshanelo"),
            keywords: &["cleaning", "sweeping", "umshanelo", "witch"],
        },
    ],
};
#[doc = "🧺"]
pub const BASKET: crate::Emoji = crate::Emoji {
    glyph: "🧺",
    codepoint: "1F9FA",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "basket",
    group: "Objects",
    subgroup: "household",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("mandjie"),
            keywords: &["mandjie", "oes", "piekniek", "plaas", "wasgoed"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቅርጫት"),
            keywords: &["ልብስ ማጠቢያ", "ሽርሽር", "ቅርጫት", "እርሻ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سلة"),
            keywords: &["رحلة قصيرة", "زراعة", "سلة", "غسيل"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ব\u{9be}স\u{9cd}কেট"),
            keywords: &[
                "ক\u{9c3}ষি",
                "ধোব\u{9be}খ\u{9be}ন\u{9be}",
                "পিকনিক",
                "ব\u{9be}স\u{9cd}কেট",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("səbət"),
            keywords: &["paltar səbəti", "piknik", "səbət"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кошык"),
            keywords: &["кошык", "мыццё", "пікнік", "фермерства"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("кошница"),
            keywords: &["беритба", "кош за пране", "кошница", "пазаруване", "пикник"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ট\u{9c1}করি"),
            keywords: &["ক\u{9c3}ষি", "ট\u{9c1}করি", "পিকনিক", "লন\u{9cd}ড\u{9cd}রি"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("paner"),
            keywords: &["paner", "piknik"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("korpa"),
            keywords: &["korpa", "piknik", "poljoprivreda", "veš"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cistella"),
            keywords: &["bugada", "cistella", "granja", "pícnic"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏔᎷᏣ"),
            keywords: &["ᎤᎾᏓᏟᏌᎲ", "ᏔᎷᏣ", "ᏕᎦᎶᎩᏍᎬ", "ᏗᎩᎶᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("koš"),
            keywords: &["koš", "košík", "piknik", "proutí", "prádlo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("basged"),
            keywords: &["basged", "ffermio", "golchi dillad", "picnic"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kurv"),
            keywords: &["indkøb", "kurv", "picnic", "vasketøj"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Korb"),
            keywords: &["Korb", "Picknick", "Wäsche"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καλάθι"),
            keywords: &["γεωργία", "καλάθι", "πικνικ", "πλυντήριο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("basket"),
            keywords: &["basket", "farming", "laundry", "picnic"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cesta"),
            keywords: &["cesta", "colada", "cosecha", "pícnic"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("canasta"),
            keywords: &["campesino", "canasta", "lavar la ropa", "picnic"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("canasta"),
            keywords: &["canasta"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("korv"),
            keywords: &["korv", "pesu", "piknik", "taluelu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("saski"),
            keywords: &["gobada", "nekazaritza", "piknik", "saski"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("سبد"),
            keywords: &["سبد", "لباسشویی", "پیک\u{200c}نیک", "کشاورزی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kori"),
            keywords: &["kori", "maatalous", "piknik", "pyykki", "pyykkikori"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("basket"),
            keywords: &["basket", "paglalaba", "pagsasaka", "picnic"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kurv"),
            keywords: &["kurv"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("panier"),
            keywords: &["agriculture", "linge", "panier", "pique-nique"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ciseán"),
            keywords: &["ciseán", "feirmeoireacht", "níochán", "picnic"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("basgaid"),
            keywords: &[
                "basgaid",
                "croitearachd",
                "cuim-cnuic",
                "tuathanachas",
                "tuathanasachd",
                "àiteach",
                "àiteachas",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cesta"),
            keywords: &["agricultura", "cesta", "cesto", "coada", "pícnic"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બાસ\u{acd}ક\u{ac7}ટ"),
            keywords: &[
                "ખ\u{ac7}તી",
                "પિકનીક",
                "બાસ\u{acd}ક\u{ac7}ટ",
                "લોન\u{acd}ડ\u{acd}રી",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סל"),
            keywords: &["כביסה", "סל", "פיקניק"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बास\u{94d}क\u{947}ट"),
            keywords: &[
                "किसानी",
                "पिकनिक",
                "बास\u{94d}क\u{947}ट",
                "लॉन\u{94d}ड\u{94d}री",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("košara"),
            keywords: &["domaćinstvo", "košara", "piknik", "rublje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kosár"),
            keywords: &["gazdálkodás", "kosár", "piknik", "szennyes"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("զամբյուղ"),
            keywords: &["գյուղատնտեսություն", "զամբյուղ", "լվացք", "պիկնիկ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("keranjang"),
            keywords: &["berkebun", "cucian", "keranjang", "piknik"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("karfa"),
            keywords: &["búskapur", "karfa", "lautarferð", "þvottur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cesto"),
            keywords: &["bucato", "cesto", "orto", "picnic"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("かご"),
            keywords: &["かご", "ピクニック", "収穫", "洗濯"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kranjang"),
            keywords: &["kranjang", "kumbahan", "piknik", "tani"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კალათა"),
            keywords: &["კალათა", "პიკნიკი", "სარეცხი", "ფერმა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("себет"),
            keywords: &["кір жуатын орын", "пикник", "себет", "шаруашылық"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កន\u{17d2}ត\u{17d2}រក"),
            keywords: &[
                "កន\u{17d2}ត\u{17d2}រក",
                "ការធ\u{17d2}វើកស\u{17b7}កម\u{17d2}ម",
                "ការបោកសម\u{17d2}លៀកប\u{17c6}ពាក\u{17cb}",
                "ព\u{17b7}ចន\u{17b7}ច",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{ccd}ಯಾಸ\u{ccd}ಕ\u{cc6}ಟ\u{ccd}"),
            keywords: &[
                "ಕೃಷ\u{cbf}",
                "ಪ\u{cbf}ಕ\u{ccd}ನ\u{cbf}ಕ\u{ccd}",
                "ಬ\u{ccd}ಯಾಸ\u{ccd}ಕ\u{cc6}ಟ\u{ccd}",
                "ಲಾಂಡ\u{ccd}ರ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("바구니"),
            keywords: &["바구니", "빨래바구니"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बास\u{94d}क\u{947}ट"),
            keywords: &[
                "पिकनीक",
                "बास\u{94d}क\u{947}ट",
                "ला\u{901}ड\u{94d}री",
                "श\u{947}त",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("себет"),
            keywords: &["кир жуу", "пикник", "себет", "чарба"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກະຕ\u{ec8}າ"),
            keywords: &[
                "ກະຕ\u{ec8}າ",
                "ກ\u{eb4}ນເຂ\u{ebb}\u{ec9}າປ\u{ec8}າ",
                "ຊ\u{eb1}ກເຄ\u{eb7}\u{ec8}ອງ",
                "ຊ\u{ec8}າວນາ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("pintinė"),
            keywords: &["iškyla", "pintinė", "skalbiniai", "ūkininkavimas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("grozs"),
            keywords: &["grozs", "lauksaimniecība", "pikniks", "veļas mazgātuve"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("корпа"),
            keywords: &["земјоделство", "корпа", "перење алишта", "пикник"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d41}ട\u{d4d}ട"),
            keywords: &[
                "അലക\u{d4d}ക\u{d41}ശ\u{d3e}ല",
                "ക\u{d41}ട\u{d4d}ട",
                "ക\u{d43}ഷി",
                "പിക\u{d4d}\u{200c}നിക\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("сагс"),
            keywords: &["зугаалга", "сагс", "ферм", "хувцас угаалга"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("बास\u{94d}क\u{947}ट"),
            keywords: &[
                "पिकनिक",
                "फार\u{94d}मि\u{902}ग",
                "बास\u{94d}क\u{947}ट",
                "ला\u{901}ड\u{94d}री",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bakul"),
            keywords: &["bakul", "berkelah", "berladang", "dobi-mendobi"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ခြင\u{103a}းတောင\u{103a}း"),
            keywords: &[
                "ခြင\u{103a}းတောင\u{103a}း",
                "စ\u{102d}\u{102f}က\u{103a}ပျ\u{102d}\u{102f}းမ\u{103d}ေးမြ\u{1030}ရေး",
                "ပျော\u{103a}ပ\u{103d}\u{1032}စား",
                "အဝတ\u{103a}လျ\u{103e}ော\u{103a}ခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kurv"),
            keywords: &["jordbruk", "klesvask", "kurv", "piknik"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("डालो"),
            keywords: &[
                "ख\u{947}तीपाती",
                "डालो",
                "बनभोज",
                "ल\u{941}गा ध\u{941}न\u{947} कार\u{94d}य",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("mand"),
            keywords: &["mand", "oogsten", "picknick", "wasgoed"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("korg"),
            keywords: &["jordbruk", "klesvask", "korg", "piknik"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3e}ସ\u{b4d}କେଟ\u{b4d}\u{200c}"),
            keywords: &[
                "ଚ\u{b3e}ଷବ\u{b3e}ସ",
                "ପ\u{b3f}କନ\u{b3f}କ\u{b4d}\u{200c}",
                "ବ\u{b3e}ସ\u{b4d}କେଟ\u{b4d}\u{200c}",
                "ଲଣ\u{b4d}ଡ\u{b4d}ର\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਟ\u{a4b}ਕਰੀ"),
            keywords: &["ਖ\u{a47}ਤੀਬਾੜੀ", "ਟ\u{a4b}ਕਰੀ", "ਪਿਕਨਿਕ", "ਲਾ\u{a02}ਡਰੀ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Baskẹt"),
            keywords: &[
                "Baskẹt",
                "Fámin",
                "Klọt Wé Yu Wán Wọsh",
                "Lọ\u{301}ndri",
                "Píknik",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kosz"),
            keywords: &["kosz", "piknik", "pranie", "rolnictwo"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ټوکرۍ"),
            keywords: &["سيل", "ټوکرۍ", "کالي مينځل", "کرونده"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cesta"),
            keywords: &["agrícola", "cesta", "cesto de roupa", "piquenique"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["agricultura", "cesta", "cesto de roupa", "piquenique"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("coș"),
            keywords: &["agricultură", "coș", "picnic", "rufe"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-068"),
            keywords: &["E11-068"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("корзина"),
            keywords: &["корзина", "корзина с бельем", "пикник", "стирка", "ягоды"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٽوڪري"),
            keywords: &["تفريع", "فارمنگ", "لانڊري", "ٽوڪري"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dd6}ඩය"),
            keywords: &[
                "ක\u{dd6}ඩය",
                "ගොව\u{dd2}තැන\u{dca} ක\u{dd2}ර\u{dd3}ම",
                "රෙද\u{dd2} සේද\u{dd3}ම",
                "ව\u{dd2}නෝද ච\u{dcf}ර\u{dd2}ක\u{dcf}වක\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kôš"),
            keywords: &["kôš", "piknik", "pranie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("košara"),
            keywords: &["kmetovanje", "košara", "perilo", "piknik"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("salad"),
            keywords: &["beerasho", "dhar-dhaqid", "salad", "tamashle"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shportë"),
            keywords: &["kosh", "piknik", "rroba", "shportë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("корпа"),
            keywords: &["корпа", "пикник", "пољопривреда", "прање веша"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("korpa"),
            keywords: &["korpa", "piknik", "poljoprivreda", "pranje veša"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("korg"),
            keywords: &["jordbruk", "korg", "picknick", "tvätt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kikapu"),
            keywords: &["kikapu", "kufua nguo", "kulima", "mandari"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கூடை"),
            keywords: &[
                "கூடை",
                "சலவை",
                "சுற\u{bcd}றுல\u{bbe}",
                "விவச\u{bbe}யம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బుట\u{c4d}ట"),
            keywords: &[
                "ప\u{c3f}క\u{c4d}\u{200c}న\u{c3f}క\u{c4d}",
                "బుట\u{c4d}ట",
                "ల\u{c3e}ండ\u{c4d}ర\u{c40}",
                "వ\u{c4d}యవస\u{c3e}యం",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ตะกร\u{e49}า"),
            keywords: &[
                "ซ\u{e31}กผ\u{e49}า",
                "ตะกร\u{e49}า",
                "ตะกร\u{e49}าผ\u{e49}า",
                "ป\u{e34}กน\u{e34}ก",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("sebet"),
            keywords: &["daýhançylyk", "kir ýuwma", "piknik", "sebet"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kato lālanga"),
            keywords: &["kato lālanga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sepet"),
            keywords: &["piknik", "sepet", "çamaşır", "çiftçilik"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кошик"),
            keywords: &["білизна", "корзина", "кошик", "пікнік", "ферма"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ٹوکری"),
            keywords: &["فارمنگ", "لانڈری", "ٹوکری", "پکنک"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("savat"),
            keywords: &["kir", "meva", "rezavor", "savat", "sayr", "yuvish"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cái giỏ"),
            keywords: &["cái giỏ", "dã ngoại", "giặt ủi", "trồng trọt"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("籃"),
            keywords: &["洗衫", "籃", "耕種", "野餐"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("篮"),
            keywords: &["洗衫", "篮", "耕种", "野餐"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("筐"),
            keywords: &["农作", "筐", "脏衣篮", "野餐"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("籃子"),
            keywords: &["洗衣", "種植", "籃子", "野餐"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("籃"),
            keywords: &["洗衫", "種菜", "籃", "野餐"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubhasikidi"),
            keywords: &["farming", "laundry", "picnic", "ubhasikidi"],
        },
    ],
};
#[doc = "🧻"]
pub const ROLL_OF_PAPER: crate::Emoji = crate::Emoji {
    glyph: "🧻",
    codepoint: "1F9FB",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "roll of paper",
    group: "Objects",
    subgroup: "household",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("papierrol"),
            keywords: &["kombuispapier", "papierrol", "toiletpapier"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የወረቀት ጥቅል"),
            keywords: &["ሶፍት", "የወረቀት ጥቅል", "የወረቀት ፎጣ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("لفة ورق"),
            keywords: &["لفة ورق", "مناشف ورقية", "ورق تواليت"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9be}গজৰ ন\u{9c1}ৰ\u{9be}"),
            keywords: &[
                "ক\u{9be}গজৰ ত\u{9be}ৱেল",
                "ক\u{9be}গজৰ ন\u{9c1}ৰ\u{9be}",
                "টয\u{9bc}লেট পেপ\u{9be}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kağız rulonu"),
            keywords: &["kağız rulonu", "tualet kağızı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("рулон паперы"),
            keywords: &["папяровыя ручнікі", "рулон паперы", "туалетная папера"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("тоалетна хартия"),
            keywords: &["руло хартия", "тоалетна хартия", "тоалетно руло"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9be}গজের রোল"),
            keywords: &[
                "ক\u{9be}গজের তোয\u{9bc}\u{9be}লে",
                "ক\u{9be}গজের রোল",
                "টয\u{9bc}লেট পেপ\u{9be}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("roll paper"),
            keywords: &["paper privezioù", "roll paper"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("papirni ubrusi"),
            keywords: &["papirni ubrusi", "toalet papir"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("rotlle de paper"),
            keywords: &[
                "paper de vàter",
                "paper higiènic",
                "rotlle de paper",
                "tovalloleta de paper",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎪᏪᎵ ᎦᏇᏅᏔᏅ"),
            keywords: &["ᎪᏪᎵ ᎦᏇᏅᏔᏅ", "ᎪᏪᎵ ᏗᎵᎩᏲᏗ", "ᏙᏱ ᎡᏓᏍᏘᏱ ᎪᏪᎵ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("role papíru"),
            keywords: &[
                "papírové ručníky",
                "papírové utěrky",
                "role papíru",
                "toaletní papír",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("rholyn o bapur"),
            keywords: &["papur toiled", "rholyn o bapur", "tywelion papur"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("papirrulle"),
            keywords: &["køkkenrulle", "papirrulle", "toiletpapir"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Küchenrolle"),
            keywords: &[
                "Klopapier",
                "Küchenrolle",
                "Papiertücher",
                "Toilettenpapier",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ρολό χαρτί"),
            keywords: &["ρολό χαρτί", "χαρτί κουζίνας", "χαρτί υγείας"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("roll of paper"),
            keywords: &["paper towels", "roll of paper", "toilet paper"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &[
                "paper towels",
                "roll of paper",
                "toilet paper",
                "toilet roll",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &[
                "paper towels",
                "roll of paper",
                "toilet paper",
                "toilet roll",
            ],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("rollo de papel"),
            keywords: &["papel absorbente", "papel higiénico", "rollo de papel"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("rollo de papel"),
            keywords: &["papel higiénico", "rollo de papel", "toallas de papel"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("rollo de papel"),
            keywords: &["rollo de papel"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("paberirull"),
            keywords: &["paberirull", "paberkäterätid", "tualettpaber"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("paper-bilkari"),
            keywords: &["komuneko paper", "paper-bilkari", "paperezko zapi"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("رول کاغذ"),
            keywords: &[
                "حوله\u{654} کاغذی",
                "دستمال توالت",
                "رول کاغذ",
                "کاغذ توالت",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("paperirulla"),
            keywords: &[
                "paperipyyhkeet",
                "paperirulla",
                "talouspaperi",
                "vessapaperi",
                "wc-paperi",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("rolyo ng tisyu"),
            keywords: &["pangbanyo", "papel", "rolyo ng tisyu", "tisyu"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("vesipappír"),
            keywords: &["kukka", "toilettpappír", "ves", "vesipappír"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("rouleau de papier"),
            keywords: &[
                "essuie-tout",
                "papier hygiénique",
                "papier toilette",
                "rouleau de papier",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "essuie-main",
                "essuie-tout",
                "papier hygiénique",
                "papier toilette",
                "rouleau de papier",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("rolla páipéir"),
            keywords: &["páipéar leithris", "rolla páipéir", "tuáillí leithris"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("rola pàipeir"),
            keywords: &["pàipear-tòin", "rola pàipeir", "tubhailt pàipeir"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("rolo de papel"),
            keywords: &[
                "papel de cociña",
                "papel hixiénico",
                "rolo",
                "rolo de papel",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{ac7}પરનો રોલ"),
            keywords: &[
                "ટોઇલ\u{ac7}ટ પ\u{ac7}પર",
                "પ\u{ac7}પર ટ\u{ac1}વાલ",
                "પ\u{ac7}પરનો રોલ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גליל נייר"),
            keywords: &["גליל נייר", "מגבות נייר", "נייר טואלט"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{947}पर का रोल"),
            keywords: &[
                "टॉयल\u{947}ट प\u{947}पर",
                "प\u{947}पर का रोल",
                "प\u{947}पर टॉव\u{947}ल",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("rola papira"),
            keywords: &["papirnati ručnici", "rola papira", "toaletni papir"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("papírtekercs"),
            keywords: &["WC-papír", "papírtekercs", "papírtörölköző"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("թղթի գլան"),
            keywords: &["զուգարանի թուղթ", "թղթե սրբիչ", "թղթի գլան"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("gulungan kertas"),
            keywords: &["gulungan kertas", "tisu toilet"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("pappírsrúlla"),
            keywords: &["klósettpappír", "pappírsrúlla", "salernispappír"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("rotolo di carta igienica"),
            keywords: &["carta igienica", "rotolo", "rotolo di carta igienica"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("トイレットペーパー"),
            keywords: &["キッチンペーパー", "トイレットペーパー", "ペーパータオル"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tisu gulung"),
            keywords: &["lap tisu", "tisu gulung", "tisu wese"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქაღალდის გრაგნილი"),
            keywords: &[
                "ტუალეტის ქაღალდი",
                "ქაღალდის გრაგნილი",
                "ქაღალდის პირსახოცი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қағаз орамасы"),
            keywords: &["дәретхана қағазы", "қағаз орамалдар", "қағаз орамасы"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រប\u{17bb}\u{17c6}ក\u{17d2}រដាស"),
            keywords: &[
                "ក\u{17d2}រដាសបង\u{17d2}គន\u{17cb}",
                "ក\u{17d2}រដាសអនាម\u{17d0}យ",
                "រប\u{17bb}\u{17c6}ក\u{17d2}រដាស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪೇಪರ\u{ccd}\u{200c}ನ ರೋಲ\u{ccd}"),
            keywords: &[
                "ಟಾಯ\u{ccd}ಲ\u{cc6}ಟ\u{ccd} ಪೇಪರ\u{ccd}",
                "ಪೇಪರ\u{ccd} ಟವಲ\u{ccd}\u{200c}ಗಳು",
                "ಪೇಪರ\u{ccd}\u{200c}ನ ರೋಲ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("두루마리"),
            keywords: &["두루마리", "종이 수건", "화장지", "휴지"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("प\u{947}पराची ग\u{941}\u{902}डाळी"),
            keywords: &[
                "टॉयल\u{947}ट प\u{947}पर",
                "टॉव\u{947}ल प\u{947}पर",
                "प\u{947}पराची ग\u{941}\u{902}डाळी",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("түрүлгөн кагаз"),
            keywords: &["даарат кагазы", "кагаз кол аарчысы", "түрүлгөн кагаз"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກ\u{ecd}\u{ec9}ເຈ\u{ec9}ຍ"),
            keywords: &[
                "ກ\u{ecd}\u{ec9}ເຈ\u{ec9}ຍ",
                "ເຈ\u{ec9}ຍອະນາໄມ",
                "ແພເຈ\u{ec9}ຍເຊ\u{eb1}ດຕ\u{ebb}ວ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("popieriaus ritinys"),
            keywords: &[
                "popieriaus ritinys",
                "popieriniai rankšluosčiai",
                "tualetinis popierius",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("papīra rullis"),
            keywords: &["papīra dvieļi", "papīra rullis", "tualetes papīrs"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("ролна хартија"),
            keywords: &["ролна хартија", "тоалетна хартија", "хартиени марамчиња"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പേപ\u{d4d}പർ റോൾ"),
            keywords: &[
                "ടോയ\u{d4d}\u{200c}ലെറ\u{d4d}റ\u{d4d} പേപ\u{d4d}പർ",
                "പേപ\u{d4d}പർ ടവൽ",
                "പേപ\u{d4d}പർ റോൾ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хуйлсан цаас"),
            keywords: &["жорлонгийн цаас", "хуйлсан цаас", "цаасан алчуур"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{947}परचा रोल"),
            keywords: &[
                "टॉयल\u{947}ट प\u{947}पर",
                "प\u{947}पर टॉव\u{947}ल\u{94d}स",
                "प\u{947}परचा रोल",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("gulungan kertas"),
            keywords: &["gulungan kertas", "kertas tandas", "tuala kertas"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လက\u{103a}သ\u{102f}ပ\u{103a}စက\u{1039}က\u{1030}လ\u{102d}ပ\u{103a}"),
            keywords: &[
                "လက\u{103a}သ\u{102f}ပ\u{103a}စက\u{1039}က\u{1030}လ\u{102d}ပ\u{103a}",
                "အ\u{102d}မ\u{103a}သာသ\u{102f}\u{1036}းစက\u{1039}က\u{1030}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("rull med papir"),
            keywords: &["rull med papir", "toalettpapir", "tørkepapir", "tørkerull"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कागजको बण\u{94d}डल"),
            keywords: &[
                "कागजको तौलिया",
                "कागजको बण\u{94d}डल",
                "ट\u{94d}वाइल\u{947}ट प\u{947}पर",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("rol papier"),
            keywords: &["keukenrol", "rol papier", "wc-rol"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("rull med papir"),
            keywords: &["rull med papir", "toalettpapir", "tørkepapir", "tørkerull"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b3e}ଗଜ ର ରୋଲ\u{b4d}\u{200c}"),
            keywords: &[
                "କ\u{b3e}ଗଜ ର ରୋଲ\u{b4d}\u{200c}",
                "ଟଏଲେଟ ପେପର",
                "ପେପେର ଟ\u{b3e}ୱେଲ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਾਗਜ\u{a3c} ਦਾ ਰ\u{a4b}ਲ"),
            keywords: &[
                "ਕਾਗਜ\u{a3c} ਦਾ ਰ\u{a4b}ਲ",
                "ਟਾਇਲਟ ਪ\u{a47}ਪਰ",
                "ਪ\u{a47}ਪਰ ਟਾਵਲ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tọílẹ\u{301}t Rol"),
            keywords: &[
                "Pépá Tọ\u{301}wẹl",
                "Ról Ọf Pépa",
                "Tọílẹ\u{301}t Pépa",
                "Tọílẹ\u{301}t Rol",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("rolka papieru"),
            keywords: &["papier toaletowy", "rolka papieru", "ręczniki papierowe"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د کاغذ بنډل"),
            keywords: &["د تشناب کاغذ", "د کاغذ بنډل", "د کاغذ تولياګانې"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rolo de papel"),
            keywords: &["papel higiênico", "rolo de papel", "toalhas de papel"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("rolo de cozinha"),
            keywords: &["papel de cozinha", "papel higiênico", "rolo de cozinha"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("sul de hârtie"),
            keywords: &["hârtie de toaletă", "hârtie igienică", "sul de hârtie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-069"),
            keywords: &["E11-069"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("рулон бумаги"),
            keywords: &[
                "бумага",
                "бумажные полотенца",
                "рулон",
                "рулон бумаги",
                "туалетная бумага",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پيپر جو رول"),
            keywords: &["ٽوائليٽ پيپر", "پيپر جو رول", "پيپر ٽاول"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කඩද\u{dcf}ස\u{dd2} රෝල\u{dca}"),
            keywords: &[
                "කඩද\u{dcf}ස\u{dd2} ත\u{dd4}ව\u{dcf}",
                "කඩද\u{dcf}ස\u{dd2} රෝල\u{dca}",
                "ටොය\u{dd2}ලට\u{dca} පේපර\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("rolka papiera"),
            keywords: &["papierová utierka", "rolka papiera", "toaletný papier"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zvitek papirja"),
            keywords: &["papirnate brisače", "toaletni papir", "zvitek papirja"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("duub waraaq ah"),
            keywords: &[
                "duub waraaq ah",
                "tuwaalada waraaqda ah",
                "warqad musquleed",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("rrotë letre"),
            keywords: &["letra higjienike", "letër për pastrim", "rrotë letre"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("ролна папира"),
            keywords: &["папирни убруси", "ролна папира", "тоалет-папир"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("rolna papira"),
            keywords: &["papirni ubrusi", "rolna papira", "toalet-papir"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("toarulle"),
            keywords: &["pappershanddukar", "toalettpapper", "toarulle"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("karatasi"),
            keywords: &["karatasi", "karatasi ya kuchambia"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பேப\u{bcd}பர\u{bcd} ரோல\u{bcd}"),
            keywords: &[
                "ட\u{bbe}ய\u{bcd}லெட\u{bcd} பேப\u{bcd}பர\u{bcd}",
                "பேப\u{bcd}பர\u{bcd} டவல\u{bcd}",
                "பேப\u{bcd}பர\u{bcd} ரோல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c47}పర\u{c4d} ర\u{c4b}ల\u{c4d}"),
            keywords: &[
                "ట\u{c3e}య\u{c3f}ల\u{c46}ట\u{c4d} ప\u{c47}పర\u{c4d}",
                "ప\u{c47}పర\u{c4d} టవల\u{c4d}\u{200c}లు",
                "ప\u{c47}పర\u{c4d} ర\u{c4b}ల\u{c4d}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("กระดาษชำระ"),
            keywords: &[
                "กระดาษชำระ",
                "กระดาษม\u{e49}วน",
                "ท\u{e34}ชช\u{e39}\u{e48}ม\u{e49}วน",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kagyz rulony"),
            keywords: &["hajathana kagyzy", "kagyz rulony", "kagyz süpürgiç"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("takainga pepa"),
            keywords: &["takainga pepa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kağıt rulosu"),
            keywords: &["kağıt havlu", "kağıt rulosu", "tuvalet kağıdı"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("рулон паперу"),
            keywords: &[
                "паперові рушники",
                "папір",
                "рулон паперу",
                "туалет",
                "туалетний папір",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کاغذی رول"),
            keywords: &["ٹوائلٹ پیپر", "کاغذی تولیے", "کاغذی رول"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qog‘oz o‘rami"),
            keywords: &[
                "hojatxona qog‘ozi",
                "o‘ram",
                "qog‘oz",
                "qog‘oz o‘rami",
                "qog‘oz sochiq",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cuộn giấy"),
            keywords: &["cuộn giấy", "giấy toilet", "giấy vệ sinh"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("卷紙"),
            keywords: &["卷紙", "廁紙", "紙巾"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("卷纸"),
            keywords: &["卷纸", "厕纸", "纸巾"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("卷纸"),
            keywords: &["卫生纸", "卷纸", "纸巾"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("捲筒衛生紙"),
            keywords: &["捲筒衛生紙", "紙巾", "衛生紙"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("一捲廁紙"),
            keywords: &["一捲廁紙", "廁紙｜紙巾"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("roll of paper"),
            keywords: &["paper towels", "roll of paper", "toilet paper"],
        },
    ],
};
#[doc = "🪣"]
pub const BUCKET: crate::Emoji = crate::Emoji {
    glyph: "🪣",
    codepoint: "1FAA3",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "bucket",
    group: "Objects",
    subgroup: "household",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("emmer"),
            keywords: &["emmer", "vat"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ባልዲ"),
            keywords: &["ባልዲ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("دلو"),
            keywords: &["برميل", "خابية", "دلو", "وعاء"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ব\u{9be}কেট"),
            keywords: &["ক\u{9be}স\u{9cd}ক", "পেইল", "ব\u{9be}কেট", "ভেট"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("vedrə"),
            keywords: &["bak", "boçka", "vedrə", "çəllək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("вядро"),
            keywords: &["бочачка", "бітон", "вядро", "ёмістасць"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("кофа"),
            keywords: &["ведро", "кофа", "леген"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9be}লতি"),
            keywords: &[
                "চৌব\u{9be}চ\u{9cd}চ\u{9be}",
                "জলপ\u{9be}ত\u{9cd}র",
                "পিপ\u{9be}",
                "ব\u{9be}লতি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("sailh"),
            keywords: &["kelorn", "sailh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kanta"),
            keywords: &["bure", "kaca", "kanta", "kofa"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cubell"),
            keywords: &["cubell", "galleda"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎹ ᎠᎫᎩᏍᏙᏗ"),
            keywords: &["ᎠᎹ ᎠᎫᎩᏍᏙᏗ", "ᎠᎹ ᎫᎢᏍᏙᏗ", "ᎠᏟᏍᏙᏗ ᎡᏙᏂ", "ᏒᏙᏂ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kbelík"),
            keywords: &["džber", "kbelík", "kyblík", "kýbl", "vědro"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bwced"),
            keywords: &["bwced", "casgen", "cerwyn", "stwc"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("spand"),
            keywords: &["bassin", "beholder", "spand"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Eimer"),
            keywords: &["Behälter", "Bottich", "Eimer", "Kübel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κουβάς"),
            keywords: &["κάδος", "κουβάς"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("bucket"),
            keywords: &["bucket", "cask", "pail", "vat"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cubo"),
            keywords: &["balde", "barreño", "cuba", "cubeta", "cubo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("balde"),
            keywords: &["balde"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("balde"),
            keywords: &["balde"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("ämber"),
            keywords: &["pang", "ämber"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("perrail"),
            keywords: &["baldea", "perrail", "perraila", "treska", "uhoitza"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("سطل"),
            keywords: &["بشکه", "خمره", "دلو", "سطل"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ämpäri"),
            keywords: &["sanko", "ämpäri"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("timba"),
            keywords: &["balde", "timba"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("spann"),
            keywords: &["oysa", "pøs", "spann"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("seau"),
            keywords: &["conteneur", "seau"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("seau"),
            keywords: &["chaudière", "seau"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("buicéad"),
            keywords: &["buicéad", "gogán", "paol", "síothal", "tobán"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bucaid"),
            keywords: &["bacaid", "ballan", "bucaid", "peile"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("caldeiro"),
            keywords: &["balde", "caldeiro", "fregar", "praia"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બાલદી"),
            keywords: &["ટા\u{a82}કી", "ડોલ", "પીપડ\u{ac1}\u{a82}", "બાલદી"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("דלי"),
            keywords: &["דלי", "מיכל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बाल\u{94d}टी"),
            keywords: &["ट\u{902}की", "डोल", "पीपा", "बाल\u{94d}टी"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kanta"),
            keywords: &["bačva", "kabao", "kanta", "vjedro"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("vödör"),
            keywords: &["felmosó", "vödör"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("դույլ"),
            keywords: &["դույլ", "թիթեղաման"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("ember"),
            keywords: &["ember", "tong", "wadah"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fata"),
            keywords: &["fata", "skjóla", "ílát"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("secchio"),
            keywords: &["secchia", "secchio"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("バケツ"),
            keywords: &["おけ", "ばけつ", "バケツ", "ポリバケツ", "容器"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ember"),
            keywords: &["ember", "gendul", "timba", "tong"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ვედრო"),
            keywords: &["ვედრო", "სათლი", "ურნა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шелек"),
            keywords: &["бөшке", "кірлен", "шелек", "қауға"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ធ\u{17bb}ង"),
            keywords: &["ធ\u{17bb}ង", "ធ\u{17bb}ងឈើ", "ធ\u{17bb}ងយ\u{17bd}រដៃ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬಕ\u{cc6}ಟ\u{ccd}"),
            keywords: &[
                "ಪ\u{cc6}ಟ\u{ccd}ಟ\u{cbf}ಗ\u{cc6}",
                "ಪೈಲ\u{ccd}",
                "ಬಕ\u{cc6}ಟ\u{ccd}",
                "ವ\u{ccd}ಯಾಟ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("양동이"),
            keywords: &["들통", "양동이", "통"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बालदी"),
            keywords: &["टमर\u{947}ल", "पिप", "बादली", "बालदी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чака"),
            keywords: &["чака"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຄ\u{eb8}"),
            keywords: &[
                "ຄ\u{eb8}",
                "ຄ\u{eb8}ນ\u{ec9}ຳ",
                "ຄ\u{eb8}ໃຫຍ\u{ec8}",
                "ຖ\u{eb1}ງນ\u{ec9}ຳ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kibiras"),
            keywords: &["kibiras"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("spainis"),
            keywords: &["spainis", "toveris", "tvertne"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("кофа"),
            keywords: &["кофа", "сад", "стомна"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ബക\u{d4d}കറ\u{d4d}റ\u{d4d}"),
            keywords: &[
                "ചെര\u{d41}വം",
                "തൊട\u{d4d}ടി",
                "ബക\u{d4d}കറ\u{d4d}റ\u{d4d}",
                "വീപ\u{d4d}പ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хувин"),
            keywords: &["сав уулга", "торх", "хувин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("बादली"),
            keywords: &[
                "क\u{941}\u{902}ड",
                "पाण\u{94d}याच\u{947} भा\u{902}ड\u{947}",
                "पि\u{902}प",
                "बादली",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("timba"),
            keywords: &["baldi", "pak", "timba", "vat"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပ\u{102f}\u{1036}း"),
            keywords: &[
                "ပ\u{102f}\u{1036}စ\u{1036}ခ\u{103d}က\u{103a}",
                "ပ\u{102f}\u{1036}း",
                "လက\u{103a}ဆ\u{103d}\u{1032}ပ\u{102f}\u{1036}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bøtte"),
            keywords: &["beholder", "bøtte", "kar", "spann"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बक\u{947}ट"),
            keywords: &["कास\u{94d}क", "प\u{947}ल", "बक\u{947}ट", "भ\u{94d}याट"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("emmer"),
            keywords: &["aker", "emmer", "putemmer", "vat"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bøtte"),
            keywords: &["behaldar", "bøtte", "kar", "spann"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3e}ଲ\u{b4d}\u{200c}ଟ\u{b3f}"),
            keywords: &[
                "ପ\u{b3f}ମ\u{b4d}ପ\u{b3e}",
                "ବ\u{b3e}ଲ\u{b4d}\u{200c}ଟ\u{b3f}",
                "ଭ\u{b3e}ଟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬਾਲਟੀ"),
            keywords: &["ਡ\u{a4b}ਲ", "ਤ\u{a4b}ੜਾ", "ਪੀਪਾ", "ਬਾਲਟੀ", "ਮਟਕਾ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bọ\u{301}kẹt"),
            keywords: &["Bọ\u{301}kẹt", "Drọm", "Pel", "Vat"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wiadro"),
            keywords: &["kubeł", "wiaderko", "wiadro"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ستل"),
            keywords: &["بالټی", "ستل", "چاټۍ", "کاسک"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("balde"),
            keywords: &["balde", "barril"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["balde"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("găleată"),
            keywords: &["căldare", "găleată", "recipient", "vas"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-071"),
            keywords: &["E13-071"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("ведро"),
            keywords: &["бадья", "ведерко", "ведро"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بڪيٽ"),
            keywords: &["بڪيٽ", "ويٽ", "پيل", "ڪاسڪ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බ\u{dcf}ල\u{dca}ද\u{dd2}ය"),
            keywords: &[
                "ක\u{dd4}ඩ\u{dcf} බ\u{dcf}ල\u{dca}ද\u{dd2}ය",
                "ප\u{dd3}ප\u{dca}පය",
                "බ\u{dcf}ල\u{dca}ද\u{dd2}ය",
                "ව\u{dd2}ශ\u{dcf}ල බ\u{dcf}ල\u{dca}ද\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("vedro"),
            keywords: &["nádoba", "súdok", "vedro"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vedro"),
            keywords: &["sod", "vedro", "čeber", "škaf"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("baaldi"),
            keywords: &["baaldi", "dambiil", "haan", "sakeel"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kovë"),
            keywords: &["bucelë", "kade", "kovë", "vozë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кофа"),
            keywords: &["кофа"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["кофа"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kofa"),
            keywords: &["kofa"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["kofa"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("spann"),
            keywords: &["hink", "kärl", "spann", "ämbar"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ndoo"),
            keywords: &["ndoo", "pipa", "pipa kubwa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வ\u{bbe}ளி"),
            keywords: &[
                "பக\u{bcd}கெட\u{bcd}",
                "ப\u{bc0}ப\u{bcd}ப\u{bbe}ய\u{bcd}",
                "வ\u{bbe}ளி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బక\u{c46}ట\u{c4d}"),
            keywords: &["క\u{c3e}స\u{c4d}క\u{c4d}", "బక\u{c46}ట\u{c4d}"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ถ\u{e31}ง"),
            keywords: &[
                "ถ\u{e31}ง",
                "ถ\u{e31}งขนาดใหญ\u{e48}",
                "ถ\u{e31}งน\u{e49}ำ",
                "ภาชนะใส\u{e48}น\u{e49}ำขนาดใหญ\u{e48}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("bedre"),
            keywords: &["bedre", "boçka", "çelek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kane"),
            keywords: &["kane"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kova"),
            keywords: &["fıçı", "kap", "kepçe", "kova"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("відро"),
            keywords: &["бак", "відро", "чан", "шаплик"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بالٹی"),
            keywords: &["بالٹی", "حوض", "ٹوکری", "پیپا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("chelak"),
            keywords: &["chelak", "idish", "paqir", "satil"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("xô"),
            keywords: &["thùng", "thùng to", "xô"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("水桶"),
            keywords: &["木桶", "水桶", "缸"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("水桶"),
            keywords: &["木桶", "水桶", "缸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("桶"),
            keywords: &["大桶", "木桶", "桶", "水桶", "缸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("水桶"),
            keywords: &["一桶", "提桶", "桶", "桶子", "水桶"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhakede"),
            keywords: &["ibhakede", "ikhasikhi", "pheyili", "vethi"],
        },
    ],
};
#[doc = "🧼"]
pub const SOAP: crate::Emoji = crate::Emoji {
    glyph: "🧼",
    codepoint: "1F9FC",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "soap",
    group: "Objects",
    subgroup: "household",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("seep"),
            keywords: &["bad", "koekie seep", "seep", "seepbakkie", "skoon", "skuim"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሳሙና"),
            keywords: &["ማጽዳት", "ሳሙና", "ሻወር", "አሞሌ", "አረፋ", "የሳሙና ሳህን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("صابون"),
            keywords: &["استحمام", "تنظيف", "رغوة", "صابون", "طبق صابون", "قالب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চ\u{9be}বোন"),
            keywords: &[
                "চ\u{9be}বোন",
                "চ\u{9be}বোনৰ ফেন",
                "চ\u{9be}বোনৰ ব\u{9be}কচ",
                "দণ\u{9cd}ড",
                "পৰিষ\u{9cd}ক\u{9be}ৰ কৰ\u{9be}",
                "স\u{9cd}ন\u{9be}ন কৰ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sabun"),
            keywords: &["sabun", "sabunqabı", "təmizlənmək", "çimmək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мыла"),
            keywords: &["купанне", "мыла", "мыльніца", "мыццё", "пена"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("сапун"),
            keywords: &["къпане", "почистване", "сапун", "сапунерка", "сапунисване"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9be}ব\u{9be}ন"),
            keywords: &[
                "পরিষ\u{9cd}ক\u{9be}র",
                "ব\u{9be}র",
                "স\u{9be}ব\u{9be}ন",
                "স\u{9be}ব\u{9be}নদ\u{9be}নি",
                "স\u{9be}ব\u{9be}নের ফেন\u{9be}",
                "স\u{9cd}ন\u{9be}ন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("soavon"),
            keywords: &["kibellañ", "soavon"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("sapun"),
            keywords: &["kupanje", "pranje", "sapun", "sapunica", "čišćenje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("sabó"),
            keywords: &[
                "bany",
                "ensabonar-se",
                "netejar",
                "pastilla",
                "sabonera",
                "sabó",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎣᏝ"),
            keywords: &["ᎠᏓᏬᏍᎬ", "ᎣᏜ ᎠᏠᏗ ᏖᎵᏙ", "ᎣᏝ", "ᎤᏬᎩᏟ", "ᎦᎾᎸ", "ᏕᎦᏅᎦᎵᏍᎬ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mýdlo"),
            keywords: &[
                "kostka",
                "koupel",
                "miska na mýdlo",
                "mydlení",
                "mytí",
                "mýdlo",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sebon"),
            keywords: &[
                "bar",
                "dysgl sebon",
                "glanhau",
                "sebon",
                "trochion sebon",
                "ymolchi",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sæbe"),
            keywords: &["bad", "håndsæbe", "sæbe", "sæbeskum", "sæbeskål", "vaske"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Seife"),
            keywords: &["Baden", "Seife", "Seifenschale", "säubern"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σαπούνι"),
            keywords: &[
                "καθάρισμα",
                "μπάνιο",
                "πλάκα",
                "σαπουνίζω",
                "σαπουνοθήκη",
                "σαπούνι",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("soap"),
            keywords: &["bar", "bathing", "cleaning", "lather", "soap", "soapdish"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("jabón"),
            keywords: &[
                "bañarse",
                "enjabonarse",
                "jabonera",
                "jabón",
                "lavarse",
                "pastilla",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("jabón"),
            keywords: &["barra", "barra de jabón", "bañarse", "jabón", "lavar"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("jabón"),
            keywords: &["jabón"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("seep"),
            keywords: &[
                "pesemine",
                "puhastamine",
                "seebialus",
                "seebivaht",
                "seep",
                "tükiseep",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("xaboi"),
            keywords: &[
                "apar",
                "bainu",
                "garbitze",
                "pastilla",
                "xaboi",
                "xaboi-ontzi",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("صابون"),
            keywords: &["تمیز کردن", "حمام کردن", "صابون", "ظرف صابون", "نوار", "کف"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("saippua"),
            keywords: &[
                "kylpy",
                "palasaippua",
                "peseytyminen",
                "saippua",
                "saippuavaahto",
                "siivous",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("sabon"),
            keywords: &["bareta", "habonera", "pangligo", "panglinis", "sabon"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hondsápa"),
            keywords: &["hendur", "hond", "hondsápa", "sápa", "vaska"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("savon"),
            keywords: &[
                "bain",
                "lavage",
                "mousse",
                "pain de savon",
                "porte-savon",
                "savon",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["bain", "mousse", "pain", "savon", "savonnette"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("sópa"),
            keywords: &["babhla sópa", "barra", "glanadh", "snámh", "sobal", "sópa"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("siabann"),
            keywords: &["glan", "glanadh", "gàd", "nighe", "siabann"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("xabón"),
            keywords: &["bañarse", "enxaboar", "lavarse", "pastilla", "xabón"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સાબ\u{ac1}"),
            keywords: &[
                "સફાઈ",
                "સાબ\u{ac1}",
                "સાબ\u{ac1}ના ફીણ",
                "સાબ\u{ac1}ની ગોટી",
                "સાબ\u{ac1}ન\u{ac1}\u{a82} પાત\u{acd}ર",
                "સ\u{acd}નાન",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סבון"),
            keywords: &["להתרחץ", "לרחוץ", "סבון", "ספוג"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("साब\u{941}न"),
            keywords: &[
                "नहाना",
                "बार",
                "सफ\u{93c}ाई करना",
                "साब\u{941}न",
                "साब\u{941}न का झाग",
                "सोपडिश",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("sapun"),
            keywords: &["kupanje", "pjena", "pranje", "sapun", "sapunica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szappan"),
            keywords: &[
                "darab",
                "fürdés",
                "szappan",
                "szappanhab",
                "szappantartó",
                "tisztálkodás",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("օճառ"),
            keywords: &["լոգանք", "մաքրություն", "փրփուր", "օճառ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("sabun"),
            keywords: &[
                "batang",
                "busa",
                "mandi",
                "membersihkan",
                "sabun",
                "wadah sabun",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sápa"),
            keywords: &["bað", "löður", "s´ápudiskur", "sápa", "sápustykki", "þrif"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("sapone"),
            keywords: &["bagno", "sapone", "saponetta", "schiuma"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("石けん"),
            keywords: &["ソープ", "石けん", "風呂"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sabun"),
            keywords: &[
                "adus",
                "kothak",
                "reresik",
                "sabun",
                "sabunan",
                "wadhah sabun",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("საპონი"),
            keywords: &["ბანაობა", "გარეცხვა", "საპონი", "სასაპნე"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сабын"),
            keywords: &[
                "ванна",
                "ваннада жуу",
                "көбік",
                "сабын",
                "сабын салғыш",
                "тазалау",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សាប\u{17ca}\u{17bc}ដ\u{17bb}\u{17c6}"),
            keywords: &[
                "ការង\u{17bc}តទ\u{17b9}ក",
                "ការសម\u{17d2}អាត",
                "ចានសាប\u{17ca}\u{17bc}ដ\u{17bb}\u{17c6}",
                "ដ\u{17bb}\u{17c6}",
                "ពព\u{17bb}ះ",
                "សាប\u{17ca}\u{17bc}ដ\u{17bb}\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸೋಪ\u{ccd}"),
            keywords: &[
                "ಬಾಥ\u{cbf}ಂಗ\u{ccd}",
                "ಬಾರ\u{ccd}",
                "ಲೇಥರ\u{ccd}",
                "ಶುಚ\u{cbf} ಗೊಳ\u{cbf}ಸುವ\u{cbf}ಕ\u{cc6}",
                "ಸೋಪ\u{ccd}",
                "ಸೋಪ\u{ccd}\u{200c}ಡ\u{cbf}ಷ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("비누"),
            keywords: &["목욕", "비누", "비누 거품", "비누 그릇", "클렌징"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("साबण"),
            keywords: &[
                "नितळसाण",
                "न\u{94d}हा\u{902}वप",
                "फ\u{947}स",
                "बार",
                "साबण",
                "साबणाची बशी",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("самын"),
            keywords: &[
                "кесинди",
                "самын",
                "самын салгыч",
                "тазалоо",
                "тери",
                "чайынуу",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສະບ\u{eb9}"),
            keywords: &[
                "ການອາບນ\u{ecd}\u{ec9}າ",
                "ຄານ",
                "ຖານສະບ\u{eb9}",
                "ທ\u{ecd}າຄວາມສະອາດ",
                "ສະບ\u{eb9}",
                "ໜ\u{eb1}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("muilas"),
            keywords: &[
                "maudytis", "muilas", "muilinti", "muilinė", "plytelė", "praustis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ziepes"),
            keywords: &[
                "tīrīšana",
                "vannošana",
                "ziepes",
                "ziepju putas",
                "ziepju trauks",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("сапун"),
            keywords: &["капење", "сапун", "сапуница", "чистење"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സോപ\u{d4d}പ\u{d4d}"),
            keywords: &[
                "ക\u{d41}ളിക\u{d4d}കൽ",
                "ബ\u{d3e}ർ",
                "വ\u{d43}ത\u{d4d}തിയ\u{d3e}ക\u{d4d}കൽ",
                "സോപ\u{d4d}പ\u{d41}പത",
                "സോപ\u{d4d}പ\u{d4d}",
                "സോപ\u{d4d}പ\u{d4d}\u{200c}ഡിഷ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("саван"),
            keywords: &[
                "саван",
                "савангийн тавиур",
                "усанд орох",
                "хөөс",
                "цэвэрлэгээ",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("साबण"),
            keywords: &[
                "फ\u{947}स",
                "बार",
                "साबण",
                "सोपडिश",
                "स\u{94d}नान",
                "स\u{94d}वच\u{94d}छता",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("sabun"),
            keywords: &[
                "bekas sabun",
                "buih",
                "mandi",
                "membersih",
                "sabun",
                "sebuku",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဆပ\u{103a}ပြာ"),
            keywords: &[
                "ဆပ\u{103a}ပြာ",
                "ဆပ\u{103a}ပြာခ\u{103d}က\u{103a}",
                "ဆပ\u{103a}ပြာတ\u{102f}\u{1036}း",
                "ဆပ\u{103a}ပြာမြ\u{103e}\u{102f}ပ\u{103a}",
                "ရေချ\u{102d}\u{102f}းခြင\u{103a}း",
                "သန\u{1037}\u{103a}စင\u{103a}ခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("såpe"),
            keywords: &["bad", "skum", "såpe", "såpeskål", "såpestykke", "vaske"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("साब\u{941}न"),
            keywords: &[
                "ध\u{941}न\u{947} कार\u{94d}य",
                "न\u{941}हाउन\u{947} कार\u{94d}य",
                "फि\u{901}ज",
                "बार",
                "साब\u{941}न",
                "साब\u{941}नको झोल",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("zeep"),
            keywords: &[
                "baden",
                "schoonmaken",
                "schuim",
                "stuk zeep",
                "zeep",
                "zeephouder",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("såpe"),
            keywords: &["bad", "skum", "såpe", "såpeskål", "såpestykke", "vaske"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b3e}ବ\u{b41}ନ"),
            keywords: &[
                "ପ\u{b3e}ଉଡର",
                "ବ\u{b3e}ର",
                "ସଫ\u{b3e}କର\u{b3f}ବ\u{b3e}",
                "ସ\u{b3e}ବ\u{b41}ନ",
                "ସ\u{b3e}ବ\u{b41}ନ କେସ\u{b4d}\u{200c}",
                "ସ\u{b4d}ନ\u{b3e}ନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਾਬਣ"),
            keywords: &["ਨਹਾਉਣਾ", "ਪਾਊਡਰ", "ਬਾਰ", "ਸਫ\u{a3c}ਾਈ", "ਸਾਬਣ", "ਸਾਬਣਦਾਨੀ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Sop"),
            keywords: &["Baa", "Baf", "Fom", "Klin", "Sop", "Sópdish"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mydło"),
            keywords: &["kostka", "kąpiel", "mycie", "mydelniczka", "mydło", "piana"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("صابن"),
            keywords: &["صابن", "صابن دانه", "لامبل", "پاکول", "پوستکې", "چکۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("sabonete"),
            keywords: &[
                "banho",
                "barra",
                "espuma",
                "limpeza",
                "sabonete",
                "saboneteira",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["banho", "espuma", "limpeza", "sabonete", "saboneteira"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("săpun"),
            keywords: &["clăbuc", "curățenie", "săpun", "îmbăiere"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-070"),
            keywords: &["E11-070"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мыло"),
            keywords: &[
                "купание",
                "кусок мыла",
                "мало",
                "мыло",
                "мыльная пена",
                "пена",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("صابڻ"),
            keywords: &["سفائي", "صابڻ", "صابڻ داڻي", "ليٿر", "وهنجڻ", "چڪي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සබන\u{dca}"),
            keywords: &[
                "නෑම",
                "ප\u{dd2}ර\u{dd2}ස\u{dd2}ද\u{dd4} ක\u{dd2}ර\u{dd3}ම",
                "බ\u{dcf}ර\u{dca}",
                "සබන\u{dca}",
                "සබන\u{dca} තැට\u{dd2}ය",
                "සබන\u{dca} පෙන",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("mydlo"),
            keywords: &["kúpanie", "mydlo", "pena", "sprchovanie", "umývanie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("milo"),
            keywords: &[
                "kopanje",
                "kos",
                "milo",
                "pena",
                "posodica za milo",
                "čiščenje",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("saabuun"),
            keywords: &["maydhasho", "nadiifin", "qurub", "saabuun", "xunbo"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("sapun"),
            keywords: &[
                "banjë",
                "kallëp sapuni",
                "larje",
                "mbajtëse sapuni",
                "sapun",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("сапун"),
            keywords: &[
                "бар",
                "купање",
                "посуда за сапун",
                "сапун",
                "сапуница",
                "чишћење",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("sapun"),
            keywords: &[
                "bar",
                "kupanje",
                "posuda za sapun",
                "sapun",
                "sapunica",
                "čišćenje",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tvål"),
            keywords: &["bada", "duscha", "lödder", "skål", "tvål", "tvålbit"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("sabuni"),
            keywords: &[
                "kisahani cha sabuni",
                "kuoga",
                "kupaka",
                "kusafisha",
                "sabuni",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சோப\u{bcd}பு"),
            keywords: &[
                "குளியல\u{bcd}",
                "சுத\u{bcd}தம\u{bcd}",
                "சோப\u{bcd}",
                "சோப\u{bcd}பு",
                "சோப\u{bcd}பு டப\u{bcd}ப\u{bbe}",
                "நுரை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("సబ\u{c4d}బు"),
            keywords: &[
                "నురగ",
                "బ\u{c3e}ర\u{c4d}",
                "శుభ\u{c4d}రపరచడం",
                "సబ\u{c4d}బు",
                "స\u{c4b}ప\u{c4d}\u{200c}డ\u{c3f}ష\u{c4d}",
                "స\u{c4d}న\u{c3e}నం",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("สบ\u{e39}\u{e48}"),
            keywords: &[
                "จานวางสบ\u{e39}\u{e48}",
                "ทำความสะอาด",
                "ล\u{e49}างต\u{e31}ว",
                "สบ\u{e39}\u{e48}",
                "สบ\u{e39}\u{e48}ก\u{e49}อน",
                "อาบน\u{e49}ำ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("sabyn"),
            keywords: &[
                "arassalamak",
                "bar",
                "köpürjikletmek",
                "sabyn",
                "sabynlyk",
                "ýuwunmak",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("koa"),
            keywords: &["koa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sabun"),
            keywords: &["banyo", "kalıp", "köpük", "sabun", "sabunluk", "temizlik"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("мило"),
            keywords: &["купатися", "мило", "митися", "чистити", "шкіра"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("صابن"),
            keywords: &["جھاگ", "صابن", "صابن کی ڈش", "صفائی", "غسل", "ٹکیہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("sovun"),
            keywords: &[
                "ko‘pik",
                "sovun",
                "sovun bo‘lagi",
                "sovun ko‘pigi",
                "yuvinish",
                "yuvish",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("xà phòng"),
            keywords: &[
                "bánh",
                "tắm",
                "vệ sinh",
                "xà phòng",
                "xà phòng bánh",
                "xát xà phòng",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("番梘"),
            keywords: &["沖涼", "泡泡", "清潔", "番梘", "番梘盒"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("番枧"),
            keywords: &["冲凉", "泡泡", "清洁", "番枧", "番枧盒"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("皂"),
            keywords: &["杀菌", "洗手", "清洁", "皂", "肥皂泡", "肥皂盒"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("肥皂"),
            keywords: &["泡沫", "洗澡", "清潔", "肥皂", "肥皂盤"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("番梘"),
            keywords: &["沖涼", "泡泡", "清潔", "番梘", "番梘碟"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("insipho"),
            keywords: &[
                "bar", "bathing", "cleaning", "insipho", "lather", "soapdish",
            ],
        },
    ],
};
#[doc = "🪥"]
pub const TOOTHBRUSH: crate::Emoji = crate::Emoji {
    glyph: "🪥",
    codepoint: "1FAA5",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "toothbrush",
    group: "Objects",
    subgroup: "household",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("tandeborsel"),
            keywords: &[
                "badkamer",
                "borsel",
                "higiëne",
                "skoon",
                "tande",
                "tandeborsel",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የጥርስ ብሩሽ"),
            keywords: &["የጥርስ ብሩሽ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("فرشاة أسنان"),
            keywords: &["أسنان", "تنظيف", "حمام", "فرشاة", "فم", "نظافة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ট\u{9c1}থব\u{9cd}ৰ\u{9be}চ"),
            keywords: &[
                "ট\u{9c1}থব\u{9cd}ৰ\u{9be}চ",
                "ডেণ\u{9cd}টেল",
                "দ\u{9be}\u{981}ত",
                "পৰিষ\u{9cd}ক\u{9be}ৰ কৰ\u{9be}",
                "ব\u{9be}থৰ\u{9c1}ম",
                "ব\u{9cd}ৰ\u{9be}চ",
                "হ\u{9be}ইজিন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("diş fırçası"),
            keywords: &[
                "diş",
                "diş fırçası",
                "dişlər",
                "fırça",
                "gigiyena",
                "təmiz",
                "vanna otağı",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("зубная шчотка"),
            keywords: &[
                "ванны пакой",
                "гігіена",
                "зубная шчотка",
                "зубны",
                "зубы",
                "чысціць",
                "шчотка",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("четка за зъби"),
            keywords: &[
                "баня",
                "дентален",
                "зъби",
                "миене",
                "хигиена",
                "четка",
                "четка за зъби",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9cd}র\u{9be}শ"),
            keywords: &[
                "দন\u{9cd}ত",
                "দ\u{9be}\u{981}ত",
                "পরিষ\u{9cd}ক\u{9be}র",
                "ব\u{9be}থর\u{9c1}ম",
                "ব\u{9cd}র\u{9be}শ",
                "স\u{9cd}ব\u{9be}স\u{9cd}থ\u{9cd}যবিধি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("broust-dent"),
            keywords: &["broust", "broust-dent", "dent", "sal-dour", "yecʼhederezh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("četkica za zube"),
            keywords: &[
                "dentalna higijena",
                "kupatilo",
                "oralna higijena",
                "zubi",
                "četkica",
                "četkica za zube",
                "čiščenje",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("raspall de dents"),
            keywords: &[
                "dental",
                "dents",
                "higiene",
                "lavabo",
                "raspall",
                "raspall de dents",
                "rentar",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏛᎦᎾᏙᎬ ᏗᎦᏅᎦᎸᏙᏗ"),
            keywords: &["ᎠᏓᏓᏅᎦᎶᏗ", "ᎤᏓᏅᎦᎸᏓ", "ᏕᎦᏅᏙᎬ", "ᏗᎦᏅᎦᎸᏙᏗ", "ᏙᏱ ᎡᏓᏍᏘᏱ", "ᏛᎦᎾᏙᎬ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zubní kartáček"),
            keywords: &[
                "dentální",
                "hygiena",
                "kartáček",
                "koupelna",
                "zubní",
                "zuby",
                "čistit",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("brwsh dannedd"),
            keywords: &[
                "brwsh",
                "dannedd",
                "deintyddol",
                "glanhau",
                "hylendid",
                "ystafell ymolchi",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("tandbørste"),
            keywords: &[
                "badeværelse",
                "børste",
                "hygiejne",
                "mund",
                "mundhygiejne",
                "rene tænder",
                "tandbørste",
                "tænder",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Zahnbürste"),
            keywords: &[
                "Badezimmer",
                "Bürste",
                "Zahnbürste",
                "Zahnhygiene",
                "Zähne",
                "sauber",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("οδοντόβουρτσα"),
            keywords: &[
                "βούρτσα",
                "δόντια",
                "καθαρό",
                "μπάνιο",
                "οδοντικός",
                "οδοντόβουρτσα",
                "υγιεινή",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("toothbrush"),
            keywords: &[
                "bathroom",
                "brush",
                "clean",
                "dental",
                "hygiene",
                "teeth",
                "toothbrush",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cepillo de dientes"),
            keywords: &[
                "cepillo",
                "cepillo de dientes",
                "dental",
                "higiene",
                "limpio",
                "servicio",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cepillo de dientes"),
            keywords: &["cepillo de dientes"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("hambahari"),
            keywords: &[
                "hambad",
                "hambahari",
                "hari",
                "hügieen",
                "pesema",
                "vannituba",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("hortzetako eskuila"),
            keywords: &[
                "eskuila",
                "eskuilatu",
                "garbi",
                "higienea",
                "hortzak",
                "hortzetako eskuila",
                "komuna",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مسواک"),
            keywords: &[
                "بهداشت",
                "تمیز کردن",
                "حمام",
                "دندان",
                "مربوط به دندان",
                "مسواک",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hammasharja"),
            keywords: &[
                "hammasharja",
                "hampaat",
                "harja",
                "hygienia",
                "kylpyhuone",
                "puhdas",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("sipilyo"),
            keywords: &["banyo", "kalinisan", "malinis", "ngipin", "sipilyo"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("tannbust"),
            keywords: &["busta", "tannbust", "tannrøkt", "tenn"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("brosse à dents"),
            keywords: &[
                "brosse",
                "brosse à dents",
                "dentaire",
                "dents",
                "hygiène",
                "laver",
                "salle de bain",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("brosse à dents"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("scuab fiacla"),
            keywords: &[
                "fiacail",
                "glan",
                "scuab",
                "scuab fiacla",
                "seomra folctha",
                "sláinteachas",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bruis-fhiaclan"),
            keywords: &[
                "bruis",
                "bruis-fhiaclan",
                "fiacal",
                "fiaclan",
                "seòmar-ionnlaid",
                "slàinteachas",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cepillo de dentes"),
            keywords: &[
                "baño",
                "cepillo de dentes",
                "dentes",
                "hixiene",
                "lavar os dentes",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ટ\u{ac2}થબ\u{acd}રશ"),
            keywords: &[
                "ટ\u{ac2}થબ\u{acd}રશ",
                "ડ\u{ac7}ન\u{acd}ટલ",
                "દા\u{a82}ત",
                "બાથર\u{ac2}મ",
                "બ\u{acd}રશ",
                "સાફ કરવ\u{ac1}\u{a82}",
                "સ\u{acd}વચ\u{acd}છતા",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מברשת שיניים"),
            keywords: &["דנטלי", "היגיינת הפה", "לצחצח", "מברשת", "צחצוח", "שיניים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ट\u{942}थब\u{94d}रश"),
            keywords: &[
                "ट\u{942}थब\u{94d}रश",
                "ड\u{947}\u{902}टल",
                "दा\u{901}त",
                "बाथर\u{942}म",
                "ब\u{94d}रश",
                "सफ\u{93c}ाई",
                "हाइजीन",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("četkica za zube"),
            keywords: &[
                "dentalna",
                "higijena",
                "kupaonica",
                "zubi",
                "četkanje",
                "četkica za zube",
                "čisto",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fogkefe"),
            keywords: &[
                "fogak",
                "fogkefe",
                "fogmosás",
                "fogászat",
                "fürdőszoba",
                "higiénia",
                "kefe",
                "tisztítás",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ատամի խոզանակ"),
            keywords: &[
                "ատամի խոզանակ",
                "ատամներ",
                "լոգասենյակ",
                "լոգարան",
                "խոզանակ",
                "հիգիենա",
                "մաքուր",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("sikat gigi"),
            keywords: &[
                "bersih",
                "gigi",
                "gigi dan mulut",
                "higienis",
                "kamar mandi",
                "sikat",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("tannbursti"),
            keywords: &[
                "baðherbergi",
                "bursti",
                "hreinlæti",
                "hreinn",
                "tannbursti",
                "tannhirða",
                "tennur",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("spazzolino da denti"),
            keywords: &[
                "bagno",
                "dentale",
                "denti",
                "igiene",
                "pulito",
                "spazzolino",
                "spazzolino da denti",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("歯ブラシ"),
            keywords: &["お手入れ", "歯ブラシ", "歯磨き", "洗面所", "虫歯", "衛生"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sikat untu"),
            keywords: &["dental", "papan adus", "resik", "resikan", "sikat", "untu"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კბილის ჯაგრისი"),
            keywords: &[
                "გახეხვა",
                "კბილები",
                "კბილის ჯაგრისი",
                "სააბაზანო",
                "ჯაგრისი",
                "ჰიგიენა",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тіс щеткасы"),
            keywords: &[
                "ванна",
                "гигиена",
                "стоматологиялық",
                "тазалау",
                "тіс",
                "тіс щеткасы",
                "щетка",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ច\u{17d2}រាសដ\u{17bb}សធ\u{17d2}មេញ"),
            keywords: &[
                "ច\u{17d2}រាស",
                "ច\u{17d2}រាសដ\u{17bb}សធ\u{17d2}មេញ",
                "ធេ\u{17d2}មញ",
                "បន\u{17d2}ទប\u{17cb}ទ\u{17b9}ក",
                "សម\u{17d2}អាត",
                "អនាម\u{17d0}យ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಟ\u{cc2}ತ\u{ccd} ಬ\u{ccd}ರಷ\u{ccd}"),
            keywords: &[
                "ಟ\u{cc2}ತ\u{ccd} ಬ\u{ccd}ರಷ\u{ccd}",
                "ದಂತ",
                "ನೈರ\u{ccd}ಮಲ\u{ccd}ಯ",
                "ಬ\u{ccd}ರಷ\u{ccd}",
                "ಸ\u{ccd}ನಾನಗೃಹ",
                "ಹಲ\u{ccd}ಲುಗಳು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("칫솔"),
            keywords: &["깨끗한", "솔", "욕실", "위생", "이", "칫솔"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ट\u{941}थब\u{94d}रश"),
            keywords: &[
                "ट\u{941}थब\u{94d}रश",
                "दा\u{902}त",
                "दा\u{902}ताच\u{947}\u{902}",
                "नितळ",
                "नितळसाण",
                "न\u{94d}हाणीघर",
                "ब\u{94d}रश",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тиш щётка"),
            keywords: &["тиш щётка"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແປງຖ\u{eb9}ແຂ\u{ec9}ວ"),
            keywords: &[
                "ສະອາດ",
                "ສ\u{eb8}ຂະອານາໄມ",
                "ຫ\u{ec9}ອງນ\u{ec9}ຳ",
                "ແຂ\u{ec9}ວ",
                "ແປງ",
                "ແປງຖ\u{eb9}ແຂ\u{ec9}ວ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("dantų šepetėlis"),
            keywords: &[
                "dantys",
                "dantų šepetėlis",
                "higiena",
                "valyti",
                "vonios kambarys",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zobu suka"),
            keywords: &["higiēna", "suka", "tīrs", "vannasistaba", "zobi", "zobu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("четкичка за заби"),
            keywords: &[
                "заби",
                "купатило",
                "хигиена",
                "четка",
                "четкичка за заби",
                "чисто",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പല\u{d4d}ല\u{d41}തേക\u{d4d}ക\u{d3e}ന\u{d41}ള\u{d4d}ള ബ\u{d4d}രഷ\u{d4d}"),
            keywords: &[
                "ക\u{d41}ളിമ\u{d41}റി",
                "ട\u{d42}ത\u{d4d}ത\u{d4d}ബ\u{d4d}രഷ\u{d4d}",
                "ഡൻറൽ",
                "പല\u{d4d}ല\u{d41}കൾ",
                "പല\u{d4d}ല\u{d41}തേക\u{d4d}ക\u{d3e}ന\u{d41}ള\u{d4d}ള ബ\u{d4d}രഷ\u{d4d}",
                "ബ\u{d4d}രഷ\u{d4d}",
                "വ\u{d43}ത\u{d4d}തിയ\u{d3e}ക\u{d4d}ക\u{d41}ക",
                "ശ\u{d41}ചിത\u{d4d}വം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("шүдний сойз"),
            keywords: &[
                "ванны өрөө",
                "сойз",
                "цэвэрлэх",
                "шүд",
                "шүдний",
                "эрүүл ахуйн",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ट\u{942}थब\u{94d}रश"),
            keywords: &[
                "आरोग\u{94d}य",
                "ट\u{942}थब\u{94d}रश",
                "दात",
                "दातास\u{902}ब\u{902}धित",
                "बाथर\u{942}म",
                "ब\u{94d}रश",
                "साफ करण\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("berus gigi"),
            keywords: &[
                "bersih",
                "berus",
                "bilik mandi",
                "gigi",
                "kebersihan",
                "pergigian",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("သ\u{103d}ားပ\u{103d}တ\u{103a}တ\u{1036}"),
            keywords: &[
                "တစ\u{103a}က\u{102d}\u{102f}ယ\u{103a}ရေ သန\u{1037}\u{103a}ရ\u{103e}င\u{103a}းရေး",
                "ရေချ\u{102d}\u{102f}းခန\u{103a}း",
                "သ\u{103d}ား",
                "သ\u{103d}ားပ\u{103d}တ\u{103a}တ\u{1036}",
                "သ\u{103d}ားဘက\u{103a}ဆ\u{102d}\u{102f}င\u{103a}ရာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("tannbørste"),
            keywords: &[
                "bad",
                "baderom",
                "børste",
                "dental",
                "hygiene",
                "ren",
                "tannbørste",
                "tenner",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("मन\u{94d}जन"),
            keywords: &[
                "दन\u{94d}त",
                "दा\u{901}त",
                "बाथर\u{941}म",
                "ब\u{94d}रस",
                "मन\u{94d}जन",
                "सफा",
                "हाइजिन",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("tandenborstel"),
            keywords: &[
                "badkamer",
                "hygiëne",
                "poetsen",
                "reinigen",
                "tand",
                "tanden",
                "tandenborstel",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("tannbørste"),
            keywords: &[
                "bad",
                "baderom",
                "børste",
                "dental",
                "hygiene",
                "rein",
                "tannbørste",
                "tenner",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଦ\u{b3e}ନ\u{b4d}ତଘଷ\u{b3e}\u{200d}ବ\u{b4d}ରସ\u{b4d}\u{200c}"),
            keywords: &[
                "ଗ\u{b3e}ଧ\u{b41}ଆଘର",
                "ଦ\u{b3e}ନ\u{b4d}ତ",
                "ଦ\u{b3e}ନ\u{b4d}ତ ସମ\u{b4d}ୱନ\u{b4d}ଧୀୟ",
                "ଦ\u{b3e}ନ\u{b4d}ତଘଷ\u{b3e}\u{200d}ବ\u{b4d}ରସ\u{b4d}\u{200c}",
                "ବ\u{b4d}ରସ\u{b4d}\u{200c}",
                "ସଫ\u{b3e}",
                "ସ\u{b4d}ୱ\u{b3e}ସ\u{b4d}ଥ\u{b4d}ୟରକ\u{b4d}ଷ\u{b3e}ନୀତ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਦ\u{a70}ਦ ਬ\u{a41}ਰਸ\u{a3c}"),
            keywords: &[
                "ਗ\u{a41}ਸਲਖਾਨਾ",
                "ਦ\u{a70}ਦ",
                "ਦ\u{a70}ਦਾ\u{a02} ਸ\u{a70}ਬ\u{a70}ਧੀ",
                "ਬਾਥਰ\u{a42}ਮ",
                "ਬ\u{a41}ਰਸ\u{a3c}",
                "ਸਾਫ-ਸਫਾਈ",
                "ਹਾਈਜੀਨ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tútbrọsh"),
            keywords: &[
                "Bafrum",
                "Brọsh",
                "Haijin",
                "Klin",
                "Tins Wé Kọnsán Tit",
                "Tit",
                "Tútbrọsh",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("szczoteczka do zębów"),
            keywords: &[
                "czyszczenie",
                "higiena",
                "jama ustna",
                "szczoteczka do zębów",
                "szczotka",
                "zęby",
                "łazienka",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د غاښو برش"),
            keywords: &[
                "برش",
                "د غاښو",
                "د غاښو برش",
                "غاښ",
                "غسل خانه",
                "نظافت",
                "پاک",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("escova de dentes"),
            keywords: &[
                "banheiro",
                "dental",
                "dentes",
                "escova",
                "escova de dentes",
                "higiene",
                "limpeza",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "dental",
                "dentes",
                "escova",
                "escova de dentes",
                "higiene",
                "limpeza",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("periuță de dinți"),
            keywords: &[
                "baie",
                "curățare",
                "dantură",
                "dentară",
                "dinte",
                "igienă",
                "periaj",
                "periere",
                "periuță de dinți",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-072"),
            keywords: &["E13-072"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("зубная щетка"),
            keywords: &[
                "ванная",
                "гигиена",
                "зубная щетка",
                "зубы",
                "чистый",
                "щетка",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٽوٿ برش"),
            keywords: &["باٿ روم", "برش", "صفائي", "ٽوٿ برش", "ڊينٽل", "ڏند"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("දත\u{dca} බ\u{dd4}ර\u{dd4}ස\u{dd4}ව"),
            keywords: &[
                "දත\u{dca}",
                "දත\u{dca} ප\u{dd2}ළ\u{dd2}බඳ",
                "න\u{dcf}න ක\u{dcf}මරය",
                "ප\u{dd2}ර\u{dd2}ස\u{dd2}ද\u{dd4}",
                "බ\u{dd4}ර\u{dd4}ස\u{dd4}ව",
                "සන\u{dd3}ප\u{dcf}රක\u{dca}ෂ\u{dcf}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zubná kefka"),
            keywords: &["kefka", "kúpeľňa", "zubná kefka", "zuby", "čistiť"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zobna ščetka"),
            keywords: &["higiena", "kopalnica", "zobje", "zobna", "čisto", "ščetka"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("caday"),
            keywords: &[
                "burush",
                "caday",
                "ilkaha",
                "nadaafaada",
                "nadiifi",
                "suuli",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("furçë dhëmbësh"),
            keywords: &[
                "banjë",
                "dhëmbë",
                "fije dhëmbësh",
                "furçë",
                "furçë dhëmbësh",
                "higjienë",
                "pastroj",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("четкица за зубе"),
            keywords: &[
                "зуби",
                "зубна",
                "купатило",
                "опрати",
                "хигијена",
                "четкица",
                "четкица за зубе",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("četkica za zube"),
            keywords: &[
                "higijena",
                "kupatilo",
                "oprati",
                "zubi",
                "zubna",
                "četkica",
                "četkica za zube",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tandborste"),
            keywords: &[
                "borste",
                "ren",
                "tandborste",
                "tandhygien",
                "tvätta",
                "tänder",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mswaki"),
            keywords: &["bafu", "meno", "mswaki", "safi", "sugua", "usafi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("டூத\u{bcd}பிரஷ\u{bcd}"),
            keywords: &[
                "குளியலறை",
                "சுக\u{bbe}த\u{bbe}ரம\u{bcd}",
                "சுத\u{bcd}தம\u{bcd}",
                "டூத\u{bcd}பிரஷ\u{bcd}",
                "டெண\u{bcd}ட\u{bcd}டல\u{bcd}",
                "பற\u{bcd}கள\u{bcd}",
                "பிரஷ\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("పళ\u{c4d}లు త\u{c4b}మ\u{c47} బ\u{c4d}రష\u{c4d}"),
            keywords: &[
                "ఆర\u{c4b}గ\u{c4d}యవంతమ\u{c48}న",
                "దంత సంబంధ\u{c3f}త",
                "పళ\u{c4d}లు",
                "పళ\u{c4d}లు త\u{c4b}మ\u{c47} బ\u{c4d}రష\u{c4d}",
                "బ\u{c3e}త\u{c4d}రూమ\u{c4d}",
                "బ\u{c4d}రష\u{c4d}",
                "శుభ\u{c4d}రమ\u{c48}న",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แปรงส\u{e35}ฟ\u{e31}น"),
            keywords: &[
                "ฟ\u{e31}น",
                "สะอาด",
                "ห\u{e49}องอาบน\u{e49}ำ",
                "อนาม\u{e31}ย",
                "เก\u{e35}\u{e48}ยวก\u{e31}บฟ\u{e31}น",
                "แปรง",
                "แปรงส\u{e35}ฟ\u{e31}น",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("diş çotga"),
            keywords: &[
                "arassalamak",
                "diş",
                "dişler",
                "gigiýena",
                "hammam",
                "çotga",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fulufulunifo"),
            keywords: &["fulufulunifo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("diş fırçası"),
            keywords: &[
                "banyo",
                "dental",
                "diş",
                "diş fırçası",
                "fırça",
                "hijyen",
                "lavabo",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("зубна щітка"),
            keywords: &[
                "ванна кімната",
                "гігієна",
                "зуби",
                "зубна",
                "чистити",
                "щітка",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ٹوتھ برش"),
            keywords: &[
                "برش",
                "حفظان صحت",
                "دانت",
                "دندان",
                "صاف",
                "غسل خانہ",
                "ٹوتھ برش",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tish choʻtkasi"),
            keywords: &[
                "choʻtka",
                "gigiyena",
                "hammom",
                "tish",
                "tish choʻtkasi",
                "tozalash",
                "vannaxona",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bàn chải răng"),
            keywords: &[
                "bàn chải",
                "bàn chải răng",
                "nha khoa",
                "phòng tắm",
                "răng",
                "sạch sẽ",
                "vệ sinh",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("牙刷"),
            keywords: &["乾淨", "刷", "浴室", "牙", "牙刷", "牙科", "衛生"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("牙刷"),
            keywords: &["刷", "卫生", "干净", "浴室", "牙", "牙刷", "牙科"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("牙刷"),
            keywords: &["刷", "卫生", "情节", "浴室", "牙刷", "牙科", "牙齿"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("牙刷"),
            keywords: &["刷子", "浴室", "清潔", "牙刷", "牙齒"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isixubho"),
            keywords: &[
                "amazinyo",
                "hlanzekile",
                "ibhulashi",
                "indlu yokugezela",
                "isixubho",
                "okwamazinyo",
                "ukuhlanzeka",
            ],
        },
    ],
};
#[doc = "🧽"]
pub const SPONGE: crate::Emoji = crate::Emoji {
    glyph: "🧽",
    codepoint: "1F9FD",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "sponge",
    group: "Objects",
    subgroup: "household",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("spons"),
            keywords: &["absorbeer", "opsuig", "poreus", "skoonmaak", "spons"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ስፖንጅ"),
            keywords: &["መምጠጥ", "ማጽዳት", "ስፖንጅ", "ወንፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("اسفنجة"),
            keywords: &["اسفنجة", "تنظيف", "ماص", "مسامي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("স\u{9cd}পঞ\u{9cd}জ"),
            keywords: &[
                "ছিদ\u{9cd}ৰময\u{9bc}",
                "পৰিষ\u{9cd}ক\u{9be}ৰ কৰ\u{9be}",
                "বিশোষণ",
                "স\u{9cd}পঞ\u{9cd}জ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("süngər"),
            keywords: &["hopdurmaq", "məsaməli", "süngər", "təmizləmək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мачалка"),
            keywords: &["ачышчэнне", "мачалка", "мыццё", "порысты"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("гъба за баня"),
            keywords: &["абсорбира", "гъба за баня", "къпане", "хигиена"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9cd}পঞ\u{9cd}জ"),
            keywords: &[
                "ছিদ\u{9cd}রময\u{9bc}",
                "শোষক",
                "স\u{9be}ফ\u{9be}ই",
                "স\u{9cd}পঞ\u{9cd}জ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("spoueenn"),
            keywords: &["naetaat", "spoueenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("spužva"),
            keywords: &["porozno", "spužva", "upijanje", "čišćenje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("esponja"),
            keywords: &["absorbent", "esponja", "netejar", "porosa"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏓᏬᎵ ᎢᏳᏍᏗ"),
            keywords: &["ᎠᎧᏲᏗᏍᎬ", "ᎤᏯ ᎤᏍᏗ ᏗᏔᎸᎢᏓ", "ᏓᏬᎵ ᎢᏳᏍᏗ", "ᏕᎦᏅᎦᎵᏍᎬ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mycí houba"),
            keywords: &[
                "houba",
                "koupelová",
                "mycí houba",
                "mytí",
                "porézní",
                "savá",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sbwng"),
            keywords: &["amsugno", "glanhau", "mandyllog", "sbwng"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("vaskesvamp"),
            keywords: &["absorbere", "porøs", "vaske", "vaskesvamp"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schwamm"),
            keywords: &["Schwamm", "absorbieren", "aufsaugen", "porös"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σφουγγάρι"),
            keywords: &["απορροφητικό", "καθάρισμα", "πορώδης", "σφουγγάρι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("sponge"),
            keywords: &["absorbing", "cleaning", "porous", "sponge"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("esponja"),
            keywords: &["absorbente", "esponja", "limpiar", "poroso"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("esponja"),
            keywords: &["absorber", "esponja", "limpiar", "poroso"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("esponja"),
            keywords: &["esponja"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("pesukäsn"),
            keywords: &["imav", "pesemine", "pesukäsn", "poorne"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("belaki"),
            keywords: &["belaki", "garbitze", "porotsu", "xurgatze"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("لیف حمام"),
            keywords: &["اسفنج", "تمیز کردن", "جاذب", "لیف", "لیف حمام", "پرمنفذ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pesusieni"),
            keywords: &[
                "huokoinen",
                "imukykyinen",
                "pesu",
                "pesusieni",
                "sieni",
                "siivous",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("espongha"),
            keywords: &["espongha", "panglinis", "porous", "sumipsip"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("svampur"),
            keywords: &["holutur", "svampur", "vaska"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("éponge"),
            keywords: &["absorbante", "nettoyage", "poreuse", "éponge"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("spúinse"),
            keywords: &["glanadh", "ionsúigh", "póiriúil", "spúinse"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("spong"),
            keywords: &["cìobail", "glan", "glanadh", "nighe", "spong", "sùghadh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("esponxa"),
            keywords: &["absorbente", "bañarse", "baño", "esponxa"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}પ\u{a82}જ"),
            keywords: &[
                "છિદ\u{acd}રાળ\u{ac1}",
                "શોષવ\u{ac1}\u{a82}",
                "સફાઈ",
                "સ\u{acd}પ\u{a82}જ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ספוג"),
            keywords: &["לנקות", "לספוג", "לרחוץ", "נקבובי", "ספוג"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{94d}प\u{902}ज"),
            keywords: &[
                "छिद\u{94d}रय\u{941}क\u{94d}त",
                "सफ\u{93c}ाई",
                "सोखना",
                "स\u{94d}प\u{902}ज",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("spužva"),
            keywords: &["porozno", "pranje", "spužva", "upijanje", "čišćenje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szivacs"),
            keywords: &["nedvszívó", "porózus", "szivacs", "tisztítás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սպունգ"),
            keywords: &["ծակոտիներ", "մաքրություն", "ներծծում", "սպունգ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("spons"),
            keywords: &["berpori", "membersihkan", "menyerap", "spons"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("svampur"),
            keywords: &["drekkur í sig", "gljúpur", "svampur", "þrif"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("spugna"),
            keywords: &["assorbenza", "pulizia", "spugna", "spugna porosa"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("スポンジ"),
            keywords: &["スポンジ", "吸収", "掃除", "海綿"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sepon"),
            keywords: &["bolong-bolong", "nyerep", "reresik", "sepon"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სარეცხი ღრუბელი"),
            keywords: &["რეცხვა", "სარეცხი ღრუბელი", "შესრუტვა", "წმენდა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("губка"),
            keywords: &["губка", "сіңіру", "тазалау", "тесікті"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("អេប\u{17c9}\u{17bb}ង"),
            keywords: &[
                "ការសម\u{17d2}អាត",
                "ការស\u{17d2}រ\u{17bc}ប",
                "ជ\u{17d2}រាបទ\u{17b9}ក",
                "អេប\u{17c9}\u{17bb}ង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{ccd}ಪಾಂಜ\u{ccd}"),
            keywords: &[
                "ಸರಂಧ\u{ccd}ರ",
                "ಸ\u{ccd}ಪಾಂಜ\u{ccd}",
                "ಸ\u{ccd}ವಚ\u{ccd}ಛಗೊಳ\u{cbf}ಸುವ",
                "ಹೀರ\u{cbf}ಕೊಳ\u{ccd}ಳುವ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("스펀지"),
            keywords: &["스펀지", "청소", "흡수"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("स\u{94d}पा\u{901}ज"),
            keywords: &["ओडपी", "नितळसाण", "शोशण", "स\u{94d}पा\u{901}ज"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("губка"),
            keywords: &["губка", "соргуч", "тазалоо", "тешиктүү"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຟອງສະບ\u{eb9}"),
            keywords: &[
                "ດ\u{eb9}ດຊ\u{eb7}ມ",
                "ທ\u{ecd}າຄວາມສະອາດ",
                "ຟອງສະບ\u{eb9}",
                "ຮ\u{eb9}ຂ\u{ebb}ນໜາວ ເຕ\u{ebb}\u{ec9}າດ\u{eb1}ບເພ\u{eb4}ງ",
                "ຮ\u{ec9}ອນໃໝ\u{ec9}",
                "ໄຟ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kempinė"),
            keywords: &["akytas", "kempinė", "praustis", "sugeriantis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sūklis"),
            keywords: &["porains", "sūklis", "tīrīšana", "uzsūkšana"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("сунѓер"),
            keywords: &["впива", "порозен", "сунѓер", "чисти"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d4d}\u{200c}പോഞ\u{d4d}ച\u{d4d}"),
            keywords: &[
                "ആഗിരണം ചെയ\u{d4d}യൽ",
                "വ\u{d43}ത\u{d4d}തിയ\u{d3e}ക\u{d4d}കൽ",
                "സ\u{d41}ഷിരം",
                "സ\u{d4d}\u{200c}പോഞ\u{d4d}ച\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хөвсгөр ус шингээгч резин"),
            keywords: &[
                "хөвсгөр ус шингээгч резин",
                "хөөстэй",
                "цэвэрлэгээ",
                "шингээх",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{94d}प\u{902}ज"),
            keywords: &[
                "शोषण\u{947}",
                "सच\u{94d}छिद\u{94d}र",
                "स\u{94d}प\u{902}ज",
                "स\u{94d}वच\u{94d}छता",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("span"),
            keywords: &["membersih", "menyerap", "poros", "span"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ရေမြ\u{103e}\u{102f}ပ\u{103a}"),
            keywords: &[
                "စ\u{102d}မ\u{1037}\u{103a}ဝင\u{103a}ခြင\u{103a}း",
                "စ\u{102f}ပ\u{103a}ယ\u{1030}ခြင\u{103a}း",
                "ရေမြ\u{103e}\u{102f}ပ\u{103a}",
                "သန\u{1037}\u{103a}စင\u{103a}ခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("svamp"),
            keywords: &["absorberende", "porøs", "rengjøre", "svamp", "vaske"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}पोन\u{94d}ज"),
            keywords: &[
                "सरसफाइ कार\u{94d}य",
                "ससाना प\u{94d}वाल भएको",
                "सोस\u{94d}न\u{947} कार\u{94d}य",
                "स\u{94d}पोन\u{94d}ज",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("spons"),
            keywords: &["absorberend", "poreus", "schoonmaken", "spons"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("svamp"),
            keywords: &["absorberande", "porøs", "reingjere", "svamp", "vaske"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b4d}ପଞ\u{b4d}ଜ"),
            keywords: &[
                "ଅବଶୋଷଣ",
                "ଛ\u{b3f}ଦ\u{b4d}ର\u{b3f}ତ",
                "ସଫ\u{b3e} କର\u{b3f}ବ\u{b3e}",
                "ସ\u{b4d}ପଞ\u{b4d}ଜ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਪ\u{a70}ਜ"),
            keywords: &[
                "ਸਪ\u{a70}ਜ",
                "ਸਫਾਈ",
                "ਸ\u{a41}ਰਾਖਾ\u{a02}-ਵਾਲੀ",
                "ਸ\u{a4b}ਖਣਾ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Spọnj"),
            keywords: &["Klin", "Sok", "Spọnj"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("gąbka"),
            keywords: &["gąbka", "mycie", "porowata", "wchłanianie"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("اسفنج"),
            keywords: &["اسفنج", "راکښل", "سوري دار", "پاکول"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("esponja"),
            keywords: &["absorvente", "esponja", "limpeza", "porosa"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("burete"),
            keywords: &["absorbant", "burete", "curățenie", "poros"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-071"),
            keywords: &["E11-071"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("губка"),
            keywords: &["губка", "мочалка", "мытье посуды", "посуда", "чистить"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("جذب ڪار"),
            keywords: &["اسپونج", "جذب ڪار", "جذب ڪندڙ", "سفائي", "پورس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dca}පොන\u{dca}ජ\u{dca}"),
            keywords: &[
                "අවශෝෂණය ව\u{dd3}ම",
                "ද\u{dd2}ය උර\u{dcf}ගන\u{dca}න\u{dcf}",
                "ප\u{dd2}ර\u{dd2}ස\u{dd2}ද\u{dd4} ක\u{dd2}ර\u{dd3}ම",
                "ස\u{dca}පොන\u{dca}ජ\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("špongia"),
            keywords: &["kúpať", "sprchovať", "vsať", "čistiť", "špongia"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("spužva"),
            keywords: &["porozno", "spužva", "vpojno", "čiščenje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("isboonji"),
            keywords: &["isboonji", "liqaya", "nadiifin", "nuugaya"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("sfungjer"),
            keywords: &["material poroz", "pastrim", "sfungjer", "thithës"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("сунђер"),
            keywords: &["порозан", "сунђер", "упијање", "чишћење"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("sunđer"),
            keywords: &["porozan", "sunđer", "upijanje", "čišćenje"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tvättsvamp"),
            keywords: &["mjuk", "rengörande", "tvättsvamp"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("sifongo"),
            keywords: &["kufyonza", "kunyonya", "kusafisha", "sifongo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஸ\u{bcd}ப\u{bbe}ன\u{bcd}ஞ\u{bcd}"),
            keywords: &[
                "உறிஞ\u{bcd}சுதல\u{bcd}",
                "சுத\u{bcd}தம\u{bcd}",
                "துளைகள\u{bcd}",
                "ஸ\u{bcd}ப\u{bbe}ன\u{bcd}ஞ\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c4d}ప\u{c3e}ంజ\u{c4d}"),
            keywords: &[
                "ప\u{c40}ల\u{c4d}చుక\u{c4b}వడం",
                "రంధ\u{c4d}ర\u{c3e}లు",
                "శుభ\u{c4d}రపరచడం",
                "స\u{c4d}ప\u{c3e}ంజ\u{c4d}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ฟองน\u{e49}ำ"),
            keywords: &[
                "ด\u{e39}ดซ\u{e36}ม",
                "ทำความสะอาด",
                "ฟองน\u{e49}ำ",
                "ร\u{e39}พร\u{e38}น",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("moçalka"),
            keywords: &["arassalamak", "deşikli", "moçalka", "sormak"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("oma"),
            keywords: &["oma"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sünger"),
            keywords: &["emici", "gözenekli", "sünger", "temizlik"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("губка"),
            keywords: &["губка", "мочалка", "поглинати", "пори", "чистити"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اسفنج"),
            keywords: &["اسفنج", "جذب کرنے والا", "صفائی", "مسام دار"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yuvgich"),
            keywords: &["gubka", "idish", "shimish", "tozalash", "yuvgich", "yuvish"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bọt biển"),
            keywords: &["bọt biển", "hút", "hấp thụ", "làm sạch", "vệ sinh", "xốp"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("海綿"),
            keywords: &["吸水", "多窿", "海綿", "清潔"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("海绵"),
            keywords: &["吸水", "多窿", "海绵", "清洁"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("海绵"),
            keywords: &["吸水", "海绵", "清洁", "渗透"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("海綿"),
            keywords: &["吸水", "海綿", "清潔", "透氣"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isipontshi"),
            keywords: &["absorbing", "cleaning", "isipontshi", "porous"],
        },
    ],
};
#[doc = "🧯"]
pub const FIRE_EXTINGUISHER: crate::Emoji = crate::Emoji {
    glyph: "🧯",
    codepoint: "1F9EF",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "fire extinguisher",
    group: "Objects",
    subgroup: "household",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vuurblusser"),
            keywords: &["blus", "uitdoof", "vuur", "vuurblusser"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("እሳት ማጥፊያ"),
            keywords: &["ማጥፊያ", "አጠፋ", "እሳት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مطفأة حريق"),
            keywords: &["إخماد", "إطفاء", "حريق", "مطفأة حريق"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("অগ\u{9cd}নি নিৰ\u{9cd}ব\u{9be}পক"),
            keywords: &[
                "অগ\u{9cd}নি নিৰ\u{9cd}ব\u{9be}পক",
                "জ\u{9c1}ই",
                "নিৰ\u{9cd}ব\u{9be}পণ কৰ\u{9be}",
                "ন\u{9c1}ম\u{9c1}ওৱ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("alov söndürən"),
            keywords: &["alov", "alov söndürən", "ocaq", "söndürmək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("вогнетушыцель"),
            keywords: &["вогнетушыцель", "гасіць", "пажар", "тушыць"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("пожарогасител"),
            keywords: &[
                "гасене на пожар",
                "пожар",
                "пожарогасител",
                "пяна против пожар",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("অগ\u{9cd}নি নির\u{9cd}ব\u{9be}পক"),
            keywords: &[
                "অগ\u{9cd}নি নির\u{9cd}ব\u{9be}পক",
                "আগ\u{9c1}ন",
                "নির\u{9cd}ব\u{9be}পণ",
                "নেভ\u{9be}ন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("mouger-tan"),
            keywords: &["mouger-tan", "tan", "tan-gwall"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("aparat za gašenje požara"),
            keywords: &["aparat za gašenje požara", "gašenje", "požar", "vatra"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("extintor"),
            keywords: &["apagar", "extingir", "extintor", "foc"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏓᏪᎳᎩᏍᎬ ᏗᎦᏟᏗᏍᏙᏗ"),
            keywords: &["ᎠᏅᏜᏗ", "ᎠᏓᏪᎳᎩᏍᎬ", "ᎠᏓᏪᎳᎩᏍᎬ ᏗᎦᏟᏗᏍᏙᏗ", "ᏚᏙᎵᏤᎸ ᏄᏔᏕᎩᏍᎬᎾ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("hasicí přístroj"),
            keywords: &["hasicí přístroj", "hašení", "oheň", "požár"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("diffoddydd tân"),
            keywords: &[
                "diffodd",
                "diffoddwr tân",
                "diffoddydd tân",
                "disychedu",
                "tân",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("brandslukker"),
            keywords: &["brand", "brandslukker", "pulverslukker", "slukke"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Feuerlöscher"),
            keywords: &["Feuer", "Feuerlöscher", "löschen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πυροσβεστήρας"),
            keywords: &["κατασβήνω", "πυροσβεστήρας", "σβήνω", "φωτιά"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("fire extinguisher"),
            keywords: &["extinguish", "fire", "fire extinguisher", "quench"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("extintor"),
            keywords: &["apagar", "extinguir", "extintor", "incendio"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("extintor"),
            keywords: &["apagar", "extinguir", "extintor", "fuego", "matafuegos"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("extintor"),
            keywords: &["extintor"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("tulekustuti"),
            keywords: &["kustutamine", "summutamine", "tulekustuti", "tuli"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("su-itzalgailu"),
            keywords: &["amatatu", "itzali", "su", "su-itzalgailu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کپسول آتش\u{200c}نشانی"),
            keywords: &[
                "آتش",
                "آتش خاموش\u{200c}کن",
                "اطفای حریق",
                "خاموش کردن",
                "کپسول آتش\u{200c}نشانی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("sammutin"),
            keywords: &[
                "palonsammutin",
                "sammutin",
                "sammuttaa",
                "sammutusväline",
                "tulipalo",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pamatay apoy"),
            keywords: &[
                "apoy",
                "fire extinguisher",
                "pamatay apoy",
                "pamuksa",
                "pansugpo",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("eldskøkkjari"),
            keywords: &["eld", "eldskøkkjari", "eldur", "sløkkja", "trygd"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("extincteur"),
            keywords: &["extincteur", "feu", "incendie", "éteindre"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("múchtóir tine"),
            keywords: &["múch", "múchtóir tine", "tine"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("inneal-smàlaidh"),
            keywords: &["inneal-smàlaidh", "smàladh", "teine"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("extintor"),
            keywords: &["apagar", "extintor", "incendio", "lapas", "lume"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("અગ\u{acd}નિશામક"),
            keywords: &[
                "અગ\u{acd}નિશામક",
                "અગ\u{acd}નિશામન",
                "આગ",
                "ઓલવવ\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מטף אש"),
            keywords: &["אש", "כיבוי", "לכבות אש", "מטף אש"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("अग\u{94d}निशामक"),
            keywords: &[
                "अग\u{94d}नि",
                "अग\u{94d}निशमन",
                "अग\u{94d}निशामक",
                "आग",
                "ब\u{941}झाना",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("vatrogasni aparat"),
            keywords: &["gašenje vatre", "požar", "vatrogasni aparat"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("tűzoltó készülék"),
            keywords: &["elfojt", "elolt", "tűz", "tűzoltó készülék"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կրակմարիչ"),
            keywords: &["կրակ", "կրակմարիչ", "հրդեհ", "մարում"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("alat pemadam api ringan"),
            keywords: &["alat pemadam api ringan", "api", "padam", "pemadam"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("slökkvitæki"),
            keywords: &["eldur", "kæfa", "slökkva", "slökkvitæki"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("estintore"),
            keywords: &["estintore", "fiamme", "fuoco", "spegnere un incendio"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("消火器"),
            keywords: &["消火", "消火器", "消火器具", "消防"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pambasmi geni"),
            keywords: &["geni", "mateni", "mbasmi", "pambasmi geni"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ცეცხლსაქრობი"),
            keywords: &["ჩაქრობა", "ცეცხლსაქრობი", "ხანძარი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("өрт сөндіргіш"),
            keywords: &["сөндіру", "өрт", "өрт сөндіргіш"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17c6}ពង\u{17cb}ពន\u{17d2}លត\u{17cb}អគ\u{17d2}គ\u{17b7}ភ\u{17d0}យ"),
            keywords: &[
                "ប\u{17c6}ពង\u{17cb}ពន\u{17d2}លត\u{17cb}អគ\u{17d2}គ\u{17b7}ភ\u{17d0}យ",
                "ពន\u{17d2}លត\u{17cb}",
                "ពន\u{17d2}លត\u{17cb}ភ\u{17d2}លើង",
                "ភ\u{17d2}លើង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{cc6}ಂಕ\u{cbf} ಆರ\u{cbf}ಸುವ\u{cbf}ಕ\u{cc6}"),
            keywords: &[
                "ತಗ\u{ccd}ಗ\u{cbf}ಸು",
                "ನಂದ\u{cbf}ಸು",
                "ಬ\u{cc6}ಂಕ\u{cbf}",
                "ಬ\u{cc6}ಂಕ\u{cbf} ಆರ\u{cbf}ಸುವ\u{cbf}ಕ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("소화기"),
            keywords: &["소화", "소화기", "진화"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उजो पालोवपी"),
            keywords: &[
                "उजो",
                "उजो पालोवपी",
                "एक\u{94d}सटि\u{902}ग\u{94d}विशर",
                "पालोवप",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("өрт өчүргүч"),
            keywords: &["басуу", "өрт", "өрт өчүргүч", "өчүрүү"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຕ\u{ebb}\u{ec9}\u{ec8}າດ\u{eb1}ບເຟ\u{eb5}ງ"),
            keywords: &[
                "ຮ\u{ec9}ອນໃໝ\u{ec9}",
                "ເຕ\u{ebb}\u{ec9}າດ\u{eb1}ບເພ\u{eb4}ງ",
                "ເຕ\u{ebb}\u{ec9}\u{ec8}າດ\u{eb1}ບເຟ\u{eb5}ງ",
                "ໄຟ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("gesintuvas"),
            keywords: &["gesinti", "gesintuvas", "ugnis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ugunsdzēsības aparāts"),
            keywords: &["apdzēst", "dzēst", "uguns", "ugunsdzēsības aparāts"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("противпожарен апарат"),
            keywords: &["апарат", "гаси", "противпожарен"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("അഗ\u{d4d}നിശമനോപകരണം"),
            keywords: &[
                "അഗ\u{d4d}നിശമനോപകരണം",
                "എക\u{d4d}\u{200c}സിറ\u{d4d}റിങ\u{d4d}ക\u{d4d}വിഷ\u{d4d}",
                "തീ",
                "ശമിപ\u{d4d}പിക\u{d4d}ക\u{d41}ക",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гал унтраагч"),
            keywords: &["гал", "гал унтраагч", "унтраах"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("फायर एक\u{94d}स\u{94d}टि\u{902}ग\u{94d}विशर"),
            keywords: &[
                "एक\u{94d}स\u{94d}टि\u{902}ग\u{94d}विश",
                "क\u{94d}व\u{947}\u{902}च",
                "फायर",
                "फायर एक\u{94d}स\u{94d}टि\u{902}ग\u{94d}विशर",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("alat pemadam api"),
            keywords: &["alat pemadam api", "api", "lindap", "padam"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မ\u{102e}းသတ\u{103a}ဘ\u{1030}း"),
            keywords: &[
                "ငြ\u{102d}မ\u{103a}းသတ\u{103a}ခြင\u{103a}း",
                "ငြ\u{102d}မ\u{103a}းသတ\u{103a}သည\u{103a}",
                "မ\u{102e}း",
                "မ\u{102e}းသတ\u{103a}ဘ\u{1030}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("brannslukningsapparat"),
            keywords: &[
                "brann",
                "brannslokkingsapparat",
                "brannslukningsapparat",
                "slokke",
                "slukke",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("आगो निभाउन\u{947}"),
            keywords: &[
                "आगो",
                "आगो निभाउन\u{947}",
                "निभाउन\u{941}",
                "निभाउन\u{947} कार\u{94d}य",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("brandblusapparaat"),
            keywords: &["blussen", "brandblusapparaat", "doven", "vuur"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("brannsløkkingsapparat"),
            keywords: &["brann", "brannsløkkingsapparat", "sløkke", "sløkkje"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଅଗ\u{b4d}ନ\u{b3f}ଶ\u{b3e}ମକ"),
            keywords: &[
                "ଅଗ\u{b4d}ନ\u{b3f}",
                "ଅଗ\u{b4d}ନ\u{b3f}ଶ\u{b3e}ମକ",
                "ଦମନ କର\u{b3f}ବ\u{b3e}",
                "ଶ\u{b3e}ମକ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਅ\u{a71}ਗ ਬ\u{a41}ਝਾਉਣ ਵਾਲਾ ਯ\u{a70}ਤਰ"),
            keywords: &[
                "ਅ\u{a71}ਗ",
                "ਅ\u{a71}ਗ ਬ\u{a41}ਝਾਉਣ ਵਾਲਾ ਯ\u{a70}ਤਰ",
                "ਠ\u{a70}ਡਾ ਕਰਨਾ",
                "ਬ\u{a41}ਝਾਉਣਾ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fáyá Ẹkstíngwísha"),
            keywords: &["Fáya", "Fáyá Ẹkstíngwísha", "Kwẹnch"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("gaśnica"),
            keywords: &["gaśnica", "ogień", "ugasić", "zgasić"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("اور وژونکی"),
            keywords: &["اور", "اور وژونکی", "مړ کول", "وژل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("extintor de incêndio"),
            keywords: &["apagar", "extinguir", "extintor de incêndio", "incêndio"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("extintor"),
            keywords: &["apagar", "extinguir", "extintor", "incêndio"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("stingător de incendiu"),
            keywords: &["foc", "stingere", "stingător de incendiu", "înăbușire"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-057"),
            keywords: &["E11-057"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("огнетушитель"),
            keywords: &["огнетушитель", "огонь", "пожар", "тушение пожара"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("باهه وسائيندڙ"),
            keywords: &["باهه", "باهه وسائيندڙ", "وسائڻ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ග\u{dd2}න\u{dd2} න\u{dd2}වනය"),
            keywords: &[
                "ග\u{dd2}න\u{dca}න",
                "ග\u{dd2}න\u{dd2} න\u{dd2}වනය",
                "න\u{dd2}ව\u{dcf}දැම\u{dd3}ම",
                "න\u{dd2}ව\u{dd3} යය\u{dd2}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("hasiaci prístroj"),
            keywords: &["hasiaci prístroj", "hasiť", "požiar"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gasilni aparat"),
            keywords: &["gasilni aparat", "gašenje", "ogenj", "pogasiti"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dab-damiye"),
            keywords: &["bakhtii", "dab", "dab-damiye", "damin"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fikës zjarri"),
            keywords: &[
                "fikës zjarri",
                "ftohës",
                "lëndë shuarjeje",
                "shuarës zjarri",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("противпожарни апарат"),
            keywords: &["гасити", "пожар", "противпожарни апарат", "сузбијати"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("protivpožarni aparat"),
            keywords: &["gasiti", "požar", "protivpožarni aparat", "suzbijati"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("brandsläckare"),
            keywords: &["brandsläckare", "eld", "kväva", "släcka"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kizima moto"),
            keywords: &["kizima moto", "moto", "zima"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("த\u{bc0} அணைப\u{bcd}ப\u{bbe}ன\u{bcd}"),
            keywords: &[
                "அணைத\u{bcd}தல\u{bcd}",
                "தணித\u{bcd}தல\u{bcd}",
                "த\u{bc0}",
                "த\u{bc0} அணைப\u{bcd}ப\u{bbe}ன\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("అగ\u{c4d}న\u{c3f}మ\u{c3e}పక పర\u{c3f}కరం"),
            keywords: &[
                "అగ\u{c4d}న\u{c3f}",
                "అగ\u{c4d}న\u{c3f}మ\u{c3e}పక పర\u{c3f}కరం",
                "ఆర\u{c4d}పడం",
                "న\u{c3f}ర\u{c4b}ధ\u{c3f}ంచడం",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ท\u{e35}\u{e48}ด\u{e31}บเพล\u{e34}ง"),
            keywords: &[
                "ด\u{e31}บ",
                "ด\u{e31}บเพล\u{e34}ง",
                "ท\u{e35}\u{e48}ด\u{e31}บเพล\u{e34}ง",
                "ไฟไหม\u{e49}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýangyn söndüriji"),
            keywords: &["gandyrmak", "söndürmek", "ýangyn", "ýangyn söndüriji"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻa tāmateʻi afi"),
            keywords: &["meʻa tāmateʻi afi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yangın söndürücü"),
            keywords: &["ateş", "söndürme", "yangın", "yangın söndürücü"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("вогнегасник"),
            keywords: &[
                "вогнегасник",
                "вогонь",
                "гасити",
                "пожежа",
                "тушити",
                "тушіння",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("آگ ب\u{64f}جھانے والا آلہ"),
            keywords: &[
                "آتش",
                "آگ بجھانا",
                "آگ ب\u{64f}جھانے والا آلہ",
                "ٹھنڈا کرنا",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("o‘to‘chirgich"),
            keywords: &["olov", "o‘to‘chirgich", "yong‘in", "yong‘inni o‘chirish"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bình chữa cháy"),
            keywords: &[
                "bình chữa cháy",
                "chữa cháy",
                "cứu hỏa",
                "dập",
                "dập tắt",
                "lửa",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("㵴火筒"),
            keywords: &["㵴火", "㵴火筒", "火", "熄"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("㵴火筒"),
            keywords: &["㵴火", "㵴火筒", "火", "熄"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("灭火器"),
            keywords: &["火灾", "灭火", "灭火器"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("滅火器"),
            keywords: &["撲滅", "滅火", "滅火器"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("滅火筒"),
            keywords: &["撲滅", "滅火", "滅火筒"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isicishamlilo"),
            keywords: &["extinguish", "fire", "isicishamlilo", "quench"],
        },
    ],
};
#[doc = "🛒"]
pub const SHOPPING_CART: crate::Emoji = crate::Emoji {
    glyph: "🛒",
    codepoint: "1F6D2",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "shopping cart",
    group: "Objects",
    subgroup: "household",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("winkeltrollie"),
            keywords: &["inkopies", "trollie", "winkeltrollie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የመገብያ ጋሪ"),
            keywords: &["መገብየት", "የመገብያ ጋሪ", "ጋሪ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("عربة التسوق"),
            keywords: &["تروللي", "تسوق", "عربة", "عربة التسوق"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বজ\u{9be}ৰ কৰ\u{9be} ঠেল\u{9be}গ\u{9be}ড\u{9bc}ী"),
            keywords: &[
                "ট\u{9cd}ৰলি",
                "ঠেল\u{9be}গ\u{9be}ড\u{9bc}ী",
                "বজ\u{9be}ৰ কৰ\u{9be}",
                "বজ\u{9be}ৰ কৰ\u{9be} ঠেল\u{9be}গ\u{9be}ড\u{9bc}ী",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("alış-veriş arabası"),
            keywords: &["alış-veriş", "alış-veriş arabası", "araba", "kisə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("каляска для тавараў"),
            keywords: &["каляска", "каляска для тавараў", "пакупкі", "тавары"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("количка за пазаруване"),
            keywords: &["количка", "количка за пазаруване", "пазаруване"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("শপিং ক\u{9be}র\u{9cd}ট"),
            keywords: &["ক\u{9be}র\u{9cd}ট", "ট\u{9cd}রলি", "শপিং"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("karrigell"),
            keywords: &["karrigell", "paner"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("šoping"),
            keywords: &["kolica", "kupovina", "supermarket", "šoping"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("carretó"),
            keywords: &["carretó", "compra"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏙᎴᎳ"),
            keywords: &["ᎠᏓᎾᎾᎩᎠ", "ᎠᏦᏙᏗ", "ᎦᏌᏙᏱᏓᏍᏗ", "ᏙᎴᎳ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("nákupní vozík"),
            keywords: &["košík", "nakupování", "nákupní", "vozík"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("troli siopa"),
            keywords: &["cert", "siopa", "troli"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("indkøbsvogn"),
            keywords: &[
                "butik",
                "forretning",
                "indkøb",
                "indkøbsvogn",
                "køb",
                "shopping",
                "vogn",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Einkaufswagen"),
            keywords: &["Einkaufswagen", "einkaufen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καρότσι αγορών"),
            keywords: &["αγορές", "καλάθι", "καρότσι αγορών", "ψώνια"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("shopping cart"),
            keywords: &["cart", "shopping", "trolley"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("shopping trolley"),
            keywords: &["shopping trolley"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("shopping trolley"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("shopping cart"),
            keywords: &["basket", "cart", "shopping", "trolley"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("carrito de la compra"),
            keywords: &[
                "carrito",
                "carrito de la compra",
                "carro",
                "compra",
                "supermercado",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("carrito de compras"),
            keywords: &[
                "carriito",
                "carrito de compras",
                "carro",
                "compras",
                "supermercado",
                "tienda",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "carriito",
                "carrito de compras",
                "carro",
                "compras",
                "supermercado",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "carriito",
                "carrito de compras",
                "carro",
                "compras",
                "supermercado",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("ostukäru"),
            keywords: &["käru", "ostma", "ostukäru", "poodlemine"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("erosketa-orga"),
            keywords: &["erosketa", "erosketa-orga", "orga", "orgatxoa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("گاری خرید"),
            keywords: &["خرید", "سبد", "چرخ دستی", "گاری خرید"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ostoskärryt"),
            keywords: &["kärryt", "ostaminen", "ostokset", "ostoskärryt"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("shopping cart"),
            keywords: &["cart", "pamimili", "shopping", "trolley"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("innkeypsvognur"),
            keywords: &["innkeyp", "innkeypsvognur", "keypsvognur", "vognur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("chariot"),
            keywords: &["chariot", "panier", "shopping"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("panier d’épicerie"),
            keywords: &["chariot", "panier", "panier d’épicerie", "shopping"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("tralaí"),
            keywords: &["ollmhargadh", "siopadóireacht", "tralaí"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cairt seopadaireachd"),
            keywords: &[
                "cairt",
                "ceannach",
                "ceannachd",
                "ceannaich",
                "seopadaireachd",
                "troilidh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("carro da compra"),
            keywords: &["carro", "carro da compra", "compra", "supermercado"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("શૉપિ\u{a82}ગ કાર\u{acd}ટ"),
            keywords: &["કાર\u{acd}ટ", "ટ\u{acd}રૉલી", "શૉપિ\u{a82}ગ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("amalanke"),
            keywords: &["amalanke", "kura", "sayayya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עגלת קניות"),
            keywords: &["עגלה", "עגלת קניות", "קניות"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("शॉपि\u{902}ग कार\u{94d}ट"),
            keywords: &[
                "कार\u{94d}ट",
                "ख\u{93c}रीदारी",
                "ट\u{94d}राली",
                "शॉपि\u{902}ग कार\u{94d}ट",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kolica za kupnju"),
            keywords: &["kolica", "kolica za kupnju", "kupnja", "kupovanje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("bevásárlókocsi"),
            keywords: &[
                "bevásárló",
                "bevásárlókocsi",
                "kocsi",
                "shopping",
                "vásárlás",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("գնումների զամբյուղ"),
            keywords: &["գնումներ", "գնումների զամբյուղ", "զամբյուղ", "սայլակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("troli belanja"),
            keywords: &["belanja", "troli"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ịzụ ahịa karti"),
            keywords: &["igwe ahịa", "kaatị", "ịzụ ahịa", "ịzụ ahịa karti"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("innkaupakerra"),
            keywords: &["innkaup", "innkaupakerra", "innkaupavagn", "kerra"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("carrello"),
            keywords: &[
                "carrello",
                "carrello della spesa",
                "centro commerciale",
                "fare la spesa",
                "supermercato",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ショッピングカート"),
            keywords: &[
                "カート",
                "ショッピング",
                "ショッピングカート",
                "スーパー",
                "買い物",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("troli blanja"),
            keywords: &["blanja", "troli"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("საყიდლების ურიკა"),
            keywords: &["საყიდლები", "საყიდლების ურიკა", "ურიკა", "ყიდვა", "შოპინგი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("taqecwalt n tiɣin"),
            keywords: &["taqecwalt n tiɣin"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сауда арбасы"),
            keywords: &["арба", "дүкен", "сауда", "сауда арбасы"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("indkøbsvogn"),
            keywords: &[
                "butik",
                "forretning",
                "indkøb",
                "indkøbsvogn",
                "køb",
                "vogn",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រទេះទ\u{17b7}ញអ\u{17b8}វ\u{17c9}ាន\u{17cb}"),
            keywords: &[
                "ការទ\u{17b7}ញអ\u{17b8}វ\u{17c9}ាន\u{17cb}",
                "រទេះ",
                "រទេះទ\u{17b7}ញអ\u{17b8}វ\u{17c9}ាន\u{17cb}",
                "រទេះរ\u{17bb}ញ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಶಾಪ\u{cbf}ಂಗ\u{ccd} ಕಾರ\u{ccd}ಟ\u{ccd}"),
            keywords: &[
                "ಕಾರ\u{ccd}ಟ\u{ccd}",
                "ಟ\u{ccd}ರಾಲ\u{cbf}",
                "ಶಾಪ\u{cbf}ಂಗ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("쇼핑카트"),
            keywords: &["쇼핑카트", "장보기", "카트"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("शॉपि\u{902}ग कार\u{94d}ट"),
            keywords: &["कार\u{94d}ट", "ट\u{94d}रॉली", "शॉपि\u{902}ग"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("дүкөн арабасы"),
            keywords: &["араба", "дүкөн арабасы", "дүкөнгө баруу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Akafsweenchen"),
            keywords: &["Akafsweenchen", "Shopping", "Weenchen", "akafen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{ebb}ດເຂ\u{eb1}ນຊ\u{eb7}\u{ec9}ເຄ\u{eb7}\u{ec8}ອງ"),
            keywords: &[
                "ຊ\u{eb1}ອບປ\u{eb4}ງ",
                "ຊ\u{eb7}\u{ec9}ເຄ\u{eb7}\u{ec8}ອງ",
                "ລ\u{ebb}ດເຂ\u{eb1}ນ",
                "ລ\u{ebb}ດເຂ\u{eb1}ນຊ\u{eb7}\u{ec9}ເຄ\u{eb7}\u{ec8}ອງ",
                "ລ\u{ecd}\u{ec9}ຍ\u{eb9}\u{ec9}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("pirkinių vežimėlis"),
            keywords: &[
                "apsipirkimas",
                "parduotuvė",
                "pirkinių vežimėlis",
                "vežimėlis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("iepirkumu ratiņi"),
            keywords: &["iepirkumu ratiņi", "iepirkšanās", "ratiņi", "veikals"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tāiki panapana"),
            keywords: &["hokohoko", "kāta", "tāiki panapana"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("шопинг"),
            keywords: &["количка", "пазарење", "супермаркет", "шопинг"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഷോപ\u{d4d}പിംഗ\u{d4d} ക\u{d3e}ർട\u{d4d}ട\u{d4d}"),
            keywords: &[
                "ക\u{d3e}ർട\u{d4d}ട\u{d4d}",
                "ട\u{d4d}രോളി",
                "ഷോപ\u{d4d}പിംഗ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дэлгүүрийн тэрэг"),
            keywords: &["дэлгүүр хэсэх", "дэлгүүрийн тэрэг", "тэргэнцэр", "тэрэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("शॉपि\u{902}ग कार\u{94d}ट"),
            keywords: &["कार\u{94d}ट", "ट\u{94d}रॉली", "शॉपि\u{902}ग"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("troli beli-belah"),
            keywords: &["beli-belah", "troli"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("basket tax-xiri"),
            keywords: &["basket", "basket tax-xiri", "troli", "xiri"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စျေးဝယ\u{103a}တ\u{103d}န\u{103a}းလ\u{103e}ည\u{103a}း"),
            keywords: &[
                "စျေးဝယ\u{103a}တ\u{103d}န\u{103a}းလ\u{103e}ည\u{103a}း",
                "စျေးဝယ\u{103a}သည\u{103a}",
                "တ\u{103d}န\u{103a}းလ\u{103e}ည\u{103a}း",
                "လက\u{103a}တ\u{103d}န\u{103a}းလ\u{103e}ည\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("handlevogn"),
            keywords: &["handle", "handlevogn", "innkjøp", "tralle", "vogn"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("किनम\u{947}ल गर\u{94d}न\u{947} कार\u{94d}ट"),
            keywords: &[
                "कार\u{94d}ट",
                "किनम\u{947}ल",
                "किनम\u{947}ल गर\u{94d}न\u{947} कार\u{94d}ट",
                "ट\u{94d}रली",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("winkelwagen"),
            keywords: &["shoppen", "wagen", "wagentje", "winkelen", "winkelwagen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("handlevogn"),
            keywords: &["handle", "handlevogn", "innkjøp", "tralle", "vogn"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଶପ\u{b3f}ଂ କ\u{b3e}ର\u{b4d}ଟ\u{b4d}\u{200c}"),
            keywords: &[
                "ଗ\u{b3e}ଡ\u{b3c}\u{b3f}",
                "ଟ\u{b4d}ରଲ\u{b3f}",
                "ଶପ\u{b3f}ଂ କ\u{b3e}ର\u{b4d}ଟ\u{b4d}\u{200c}",
                "ସପ\u{b3f}ଂ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਖਰੀਦਦਾਰੀ ਛਕੜਾ"),
            keywords: &["ਖਰੀਦਦਾਰੀ ਛਕੜਾ", "ਗਡ\u{a4d}ਹੀਰਾ", "ਗ\u{a71}ਡੀ", "ਟਰਾਲੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("خریداری کرن آلی ٹوکری"),
            keywords: &["خریداری", "خریداری کرن آلی ٹوکری", "ٹرالی", "ٹوکری"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kart"),
            keywords: &["Kart", "Shọp", "Shọ\u{301}pin"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wózek sklepowy"),
            keywords: &["koszyk", "sklep", "wózek", "wózek sklepowy", "zakupy"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د سودا لاس ګاړۍ"),
            keywords: &["د سودا لاس ګاړۍ", "سودا کول", "کراچۍ", "ګاړۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("carrinho de compras"),
            keywords: &["carrinho", "carrinho de compras", "compras", "mercado"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["carrinho", "carrinho de compras", "compras"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cărucior de cumpărături"),
            keywords: &["coș", "cumpărături", "cărucior", "cărucior de cumpărături"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-993"),
            keywords: &["E10-993"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("тележка для покупок"),
            keywords: &["покупки", "тележка", "тележка для покупок"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("akagare babahiramo"),
            keywords: &["agakapu", "akagare", "akagare babahiramo", "guhaha"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("خريداري جو گاڏو"),
            keywords: &["خريداري", "خريداري جو گاڏو", "ٽرالي", "ڪارٽ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dcf}ප\u{dca}ප\u{dd4} කරත\u{dca}තය"),
            keywords: &[
                "කරත\u{dca}තය",
                "ට\u{dca}\u{200d}රොල\u{dd2}ය",
                "ස\u{dcf}ප\u{dca}ප\u{dd4} කරත\u{dca}තය",
                "ස\u{dcf}ප\u{dca}ප\u{dd4} යෑම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("nákupný vozík"),
            keywords: &["košík", "nakupovanie", "nákupný", "vozík"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("nakupovalni voziček"),
            keywords: &["košarica", "nakupovalni voziček", "nakupovanje", "voziček"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gaari-gacanka dukaameysiga"),
            keywords: &[
                "dukaameysi",
                "gaar-gacan",
                "gaari-gacanka dukaameysiga",
                "tarooli",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("karrocë pazari"),
            keywords: &[
                "blerje",
                "karrocë",
                "karrocë dore",
                "karrocë pazari",
                "pazar",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("колица за куповину"),
            keywords: &["колица", "колица за куповину", "куповина"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["колица за куповину"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kolica za kupovinu"),
            keywords: &["kolica", "kolica za kupovinu", "kupovina"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["kolica za kupovinu"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("shoppingvagn"),
            keywords: &["handla", "inköp", "shopping", "shoppingvagn", "vagn"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mkokoteni"),
            keywords: &["mkokoteni", "toroli", "ununuzi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("kigari cha kununulia bidhaa"),
            keywords: &[
                "kigari cha kununulia bidhaa",
                "mkokoteni",
                "toroli",
                "ununuzi",
            ],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஷ\u{bbe}ப\u{bcd}பிங\u{bcd} கூடை"),
            keywords: &["கூடை", "ஷ\u{bbe}ப\u{bcd}பிங\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ష\u{c3e}ప\u{c3f}ంగ\u{c4d} క\u{c3e}ర\u{c4d}ట\u{c4d}"),
            keywords: &[
                "క\u{c3e}ర\u{c4d}ట\u{c4d}",
                "ట\u{c4d}ర\u{c3e}ల\u{c40}",
                "ష\u{c3e}ప\u{c3f}ంగ\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("аробача барои харид кардан"),
            keywords: &["ароба", "аробача", "аробача барои харид кардан", "харид"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รถเข\u{e47}น"),
            keywords: &[
                "จ\u{e48}าย",
                "ช\u{e47}อปป\u{e34}\u{e49}ง",
                "ซ\u{e37}\u{e49}อ",
                "ตะกร\u{e49}า",
                "รถเข\u{e47}น",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("söwda merkezi arabajygy"),
            keywords: &[
                "araba",
                "el arabasy",
                "söwda etmek",
                "söwda merkezi arabajygy",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("saliote tanakiʻanga fakatau"),
            keywords: &["saliote tanakiʻanga fakatau"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("alışveriş arabası"),
            keywords: &["alışveriş", "alışveriş arabası", "araba", "pazar arabası"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("مال ھارۋىسى"),
            keywords: &["سودىلىق", "سۆرەم", "مال ھارۋىسى", "ھارۋا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("магазинний візок"),
            keywords: &[
                "возик",
                "магазин",
                "магазинний візок",
                "супермаркет",
                "шопінг",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("شاپنگ ٹرالی"),
            keywords: &["شاپنگ", "ٹرالی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("xarid savatchasi"),
            keywords: &["aravacha", "xarid", "xarid aravachasi", "xarid savatchasi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("xe mua hàng"),
            keywords: &["mua hàng", "xe mua hàng", "xe đẩy"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("puus-puusu bagaas"),
            keywords: &["ndugg", "puus-puus", "puus-puusu bagaas", "sariyoo"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inqwelo yokuthenga"),
            keywords: &["inqwelo", "inqwelo yokuthenga", "itroli", "ukuthenga"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Àtẹ Iraja"),
            keywords: &["kẹ\u{300}kẹ\u{301} ìkójàsí", "Àtẹ Iraja", "Ìrajà", "àtẹ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("購物車"),
            keywords: &["購物", "購物車", "車"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("购物车"),
            keywords: &["购物", "购物车", "车"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("购物车"),
            keywords: &["手推车", "购物车", "采购"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("購物車"),
            keywords: &["推車", "購物", "購物車"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inqola yokuthenga"),
            keywords: &["ikalishi", "inqola", "inqola yokuthenga", "ukuthenga"],
        },
    ],
};
