#[doc = "🔋"]
pub const BATTERY: crate::Emoji = crate::Emoji {
    glyph: "🔋",
    codepoint: "1F50B",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "battery",
    group: "Objects",
    subgroup: "computer",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("battery"),
            keywords: &["battery", "krag"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ባትሪ"),
            keywords: &["ባትሪ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بطارية"),
            keywords: &["بطارية", "طاقة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বেট\u{9be}ৰী"),
            keywords: &["বেট\u{9be}ৰী"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("batareya"),
            keywords: &["batareya"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("батарэйка"),
            keywords: &["акумулятар", "батарэйка", "батарэя"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("батерия"),
            keywords: &["батерия"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9cd}য\u{9be}ট\u{9be}রি"),
            keywords: &["ব\u{9cd}য\u{9be}ট\u{9be}রি"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pil"),
            keywords: &["pil"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("baterija"),
            keywords: &["baterija"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bateria"),
            keywords: &["bateria", "càrrega"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄝𑄬𑄑𑄢\u{11128}"),
            keywords: &["𑄝𑄬𑄑𑄢\u{11128}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎾᎦᎵᏍᎩ"),
            keywords: &["ᎠᎾᎦᎵᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("baterie"),
            keywords: &["akumulátor", "baterie", "baterka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("batri"),
            keywords: &["batri"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("batteri"),
            keywords: &["batteri", "opladet", "opladning"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Batterie"),
            keywords: &["Akku", "Batterie"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μπαταρία"),
            keywords: &["μπαταρία"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("battery"),
            keywords: &["battery"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pila"),
            keywords: &["batería", "pila"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("aku"),
            keywords: &["aku", "patarei"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bateria"),
            keywords: &["bateria"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("باتری"),
            keywords: &["باتری", "باطری", "شارژ", "شارژ کردن"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("akku"),
            keywords: &["akku", "akkuvirta", "paristo"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("baterya"),
            keywords: &["baterya"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("battarí"),
            keywords: &["battarí", "ravlað"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("pile"),
            keywords: &["pile"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["batterie", "pile"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ceallra"),
            keywords: &["ceallra"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bataraidh"),
            keywords: &["bataraidh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("pila"),
            keywords: &["batería", "carga", "pila"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બ\u{ac5}ટરી"),
            keywords: &["બ\u{ac5}ટરી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("batir"),
            keywords: &["batir"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סוללה"),
            keywords: &["בטריה", "מצבר", "סוללה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ब\u{948}टरी"),
            keywords: &["ब\u{948}टरी"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("baterija"),
            keywords: &["baterija"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("elem"),
            keywords: &["akkumulátor", "elem"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մարտկոց"),
            keywords: &["մարտկոց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("baterai"),
            keywords: &["baterai"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("batrị"),
            keywords: &["batrị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("rafhlaða"),
            keywords: &["batterí", "rafhlaða"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("batteria"),
            keywords: &[
                "autonomia",
                "batteria",
                "batteria carica",
                "batteria scarica",
                "ricaricare",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("電池"),
            keywords: &["バッテリー", "乾電池", "電池"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("baterai"),
            keywords: &["baterai"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბატარეა"),
            keywords: &["ბატარეა"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("aẓru"),
            keywords: &["aẓru"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("батарея"),
            keywords: &["батарея"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("batteri"),
            keywords: &["batteri"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ថ\u{17d2}មព\u{17b7}ល"),
            keywords: &["ថ\u{17d2}ម", "ថ\u{17d2}មព\u{17b7}ល"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{ccd}ಯಾಟರ\u{cbf}"),
            keywords: &["ಬ\u{ccd}ಯಾಟರ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("배터리"),
            keywords: &["건전지", "배터리", "배터리 충전"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ब\u{945}टरी"),
            keywords: &["ब\u{945}टरी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("батарея"),
            keywords: &["батарея"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Batterie"),
            keywords: &["Batterie"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແບ\u{eb1}ດເຕ\u{eb5}ຣ\u{eb5}"),
            keywords: &["ແບ\u{eb1}ດເຕ\u{eb5}ຣ\u{eb5}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("baterija"),
            keywords: &["baterija"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("baterija"),
            keywords: &["baterija"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pūhiko"),
            keywords: &["pūhiko"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("батерија"),
            keywords: &["батерија"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ബ\u{d3e}റ\u{d4d}ററി"),
            keywords: &["ച\u{d3e}ർജ\u{d4d}", "ബ\u{d3e}റ\u{d4d}ററി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("батарей"),
            keywords: &["батарей"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ब\u{945}टरी"),
            keywords: &["ब\u{945}टरी", "विज\u{947}री"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bateri"),
            keywords: &["bateri"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("batterija"),
            keywords: &["batterija"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဘက\u{103a}ထရ\u{102e}"),
            keywords: &["ဘက\u{103a}ထရ\u{102e}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("batteri"),
            keywords: &["batteri", "energilagring", "strøm"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ब\u{94d}याट\u{94d}री"),
            keywords: &["ब\u{94d}याट\u{94d}री"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("batterij"),
            keywords: &["batterij"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("batteri"),
            keywords: &["batteri", "energilagring", "straum"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b4d}ୟ\u{b3e}ଟେରୀ"),
            keywords: &["ବ\u{b4d}ୟ\u{b3e}ଟେରୀ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a48}ਟਰੀ"),
            keywords: &["ਬ\u{a48}ਟਰੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بیٹری"),
            keywords: &["بیٹری"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bátri"),
            keywords: &["Bátri"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("bateria"),
            keywords: &["akumulator", "akumulatorek", "bateria"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بیټري"),
            keywords: &["بیټري"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pilha"),
            keywords: &["bateria", "pilha"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("bateria"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("kallpa waqaychaq"),
            keywords: &["kallpa waqaychaq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("baterie"),
            keywords: &["baterie", "energie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-711"),
            keywords: &["E10-711"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("батарейка"),
            keywords: &[
                "аккумулятор",
                "батарейка",
                "батарея",
                "заряд",
                "уровень заряда",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("batiri"),
            keywords: &["batiri"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بيٽري"),
            keywords: &["بيٽري"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බැටර\u{dd2}ය"),
            keywords: &["බැටර\u{dd2}ය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("batéria"),
            keywords: &["batéria"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("baterija"),
            keywords: &["baterija"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("baytari"),
            keywords: &["baytari"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("bateri"),
            keywords: &["bateri"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("батерија"),
            keywords: &["батерија"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["батерија"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("baterija"),
            keywords: &["baterija"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["baterija"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("batteri"),
            keywords: &["batteri"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("betri"),
            keywords: &["betri"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பேட\u{bcd}டரி"),
            keywords: &["பேட\u{bcd}டரி", "மின\u{bcd}கலம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బ\u{c4d}య\u{c3e}టర\u{c40}"),
            keywords: &[
                "బ\u{c4d}య\u{c3e}టర\u{c40}",
                "బ\u{c4d}య\u{c3e}టర\u{c40} చ\u{c3f}హ\u{c4d}నం",
                "బ\u{c4d}య\u{c3e}టర\u{c40} సూచ\u{c3f}క",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("батарея"),
            keywords: &["батарея"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แบตเตอร\u{e35}\u{e48}"),
            keywords: &["แบตเตอร\u{e35}\u{e48}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("batareý"),
            keywords: &["batareý"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("maka fakaʻuhila"),
            keywords: &["maka", "maka fakaʻuhila", "ʻuhila"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("pil"),
            keywords: &["pil"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("باتارېيە"),
            keywords: &["باتارېيە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("батарея"),
            keywords: &["акумулятор", "батарейка", "батарея"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بیٹری"),
            keywords: &["بیٹری"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("batareya"),
            keywords: &["batareya"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("pin"),
            keywords: &["pin"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("batiri"),
            keywords: &["batiri"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhetri"),
            keywords: &["ibhetri"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("bátìrì"),
            keywords: &["bátìrì"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("電池"),
            keywords: &["電池"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("电池"),
            keywords: &["电池"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("电池"),
            keywords: &["正极", "电极", "电池", "电源", "蓄电池", "负极"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("電池"),
            keywords: &["電池"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhetri"),
            keywords: &["ibhetri"],
        },
    ],
};
#[doc = "🔌"]
pub const ELECTRIC_PLUG: crate::Emoji = crate::Emoji {
    glyph: "🔌",
    codepoint: "1F50C",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "electric plug",
    group: "Objects",
    subgroup: "computer",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("elektriese prop"),
            keywords: &["elektries", "elektriese prop", "elektrisiteit", "prop"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የኤሌክትሪክ ሶኬት"),
            keywords: &["ሶኬት", "ኤሌክትሪክ", "ኤሌክትሪክሲቲ", "የኤሌክትሪክ ሶኬት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("فيشة كهرباء"),
            keywords: &["فيشة كهرباء", "كهرباء"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বৈদ\u{9cd}য\u{9c1}তিক প\u{9cd}ল\u{9be}গ"),
            keywords: &[
                "প\u{9cd}ল\u{9be}গ",
                "বিদ\u{9cd}য\u{9c1}ৎ",
                "বৈদ\u{9cd}য\u{9c1}তিক",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("elektrik ştepseli"),
            keywords: &["elektrik", "elektrik ştepseli", "ştepsel"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("вілка"),
            keywords: &["вілка", "разетка", "штэкер", "электрычнасць"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Електрически щепсел"),
            keywords: &["Електрически щепсел", "електрически", "щепсел"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ইলেকট\u{9cd}রিক প\u{9cd}ল\u{9cd}য\u{9be}গ"),
            keywords: &[
                "ইলেকট\u{9cd}রিক প\u{9cd}ল\u{9cd}য\u{9be}গ",
                "প\u{9cd}ল\u{9be}গ",
                "বিদ\u{9cd}য\u{9c1}ৎ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("sankell dredan"),
            keywords: &[
                "lugell",
                "lugell dredan",
                "sankell",
                "sankell dredan",
                "tredan",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("eletrični utikač"),
            keywords: &["eletrični utikač", "struja", "utikač"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("endoll"),
            keywords: &["connexió", "electricitat", "endoll"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎾᎦᎵᏍᎩ ᏗᎫᏓᎸᏗ"),
            keywords: &["ᎠᎾᎦᎵᏍᎩ", "ᎠᎾᎦᎵᏍᎩ ᏗᎦᎷᎩ", "ᏗᎫᏓᎸᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zástrčka"),
            keywords: &["elektrický", "elektřina", "síťová", "vidlice", "zástrčka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("plwg trydanol"),
            keywords: &["plwg", "trydan", "trydanol"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("stik"),
            keywords: &["elektricitet", "elektrisk", "ledning", "stik"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Netzstecker"),
            keywords: &["Netzstecker", "Stecker", "Stromstecker"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("βύσμα ρεύματος"),
            keywords: &["βύσμα", "βύσμα ρεύματος", "ηλεκτρικό", "ρεύμα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("electric plug"),
            keywords: &["electric", "electricity", "plug"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("enchufe eléctrico"),
            keywords: &["corriente", "electricidad", "eléctrico", "enchufe"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["electricidad", "enchufe", "enchufe eléctrico"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("elektripistik"),
            keywords: &["elekter", "elektripistik", "pistik"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("entxufea"),
            keywords: &["argindar", "elektriko", "entxufe", "entxufea"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دوشاخه"),
            keywords: &["الکتریسیته", "الکتریکی", "برق", "دوشاخه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pistoke"),
            keywords: &[
                "pistoke",
                "sähkö",
                "sähköpistoke",
                "sähkötöpseli",
                "töpseli",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("electric plug"),
            keywords: &["de-kuryente", "electric plug", "kuryente", "plug"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("stikkari"),
            keywords: &["elektrisitet", "ravmagn", "stikkari", "stikkproppur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("câble avec fiche électrique"),
            keywords: &["câble avec fiche électrique", "prise"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("prise électrique"),
            keywords: &["prise", "prise électrique"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("pluga leictreach"),
            keywords: &["pluga leictreach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("pluga dealain"),
            keywords: &["dealan", "dealanach", "pluga", "pluga dealain"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("enchufe"),
            keywords: &["electricidade", "enchufar", "enchufe"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઇલ\u{ac7}ક\u{acd}ટ\u{acd}રિક પ\u{acd}લગ"),
            keywords: &[
                "ઇલ\u{ac7}ક\u{acd}ટ\u{acd}રિક",
                "ઇલ\u{ac7}ક\u{acd}ટ\u{acd}રિક પ\u{acd}લગ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fulogin lantarki"),
            keywords: &[
                "fulogi",
                "fulogin lantarki",
                "na lantarki",
                "wutar lantarki",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("תקע חשמלי"),
            keywords: &["חשמל", "מתח", "תקע", "תקע חשמלי"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बिजली का प\u{94d}लग"),
            keywords: &["बिजली", "बिजली का प\u{94d}लग"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("strujni utikač"),
            keywords: &["struja", "strujni utikač", "utikač"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("elektromos dugó"),
            keywords: &["dugó", "elektromos dugó", "elektronika", "villamosság"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("էլեկտրական խրոց"),
            keywords: &["էլեկտրական", "էլեկտրականություն", "խրոց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("steker"),
            keywords: &["listrik", "steker"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihe nkwụnye latriki"),
            keywords: &["ihe kwụnye", "ihe nkwụnye latriki", "latriki", "latrisiti"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("innstunga"),
            keywords: &["innstunga", "rafmagn"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("spina elettrica"),
            keywords: &["elettricità", "presa elettrica", "spina elettrica"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("コンセント"),
            keywords: &["コンセント", "プラグ", "電源"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("colokan listrik"),
            keywords: &["colokan", "kelistrikan", "listrik"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("შტეკერი"),
            keywords: &["ელექტრო", "ელექტროობა", "შტეკერი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тығын"),
            keywords: &["тығын", "электр желісі", "электрлік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("stik"),
            keywords: &["elektricitet", "elektrisk", "stik"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ឌ\u{17bb}យដោត"),
            keywords: &["ឌ\u{17bb}យ", "ឌ\u{17bb}យដោត"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಎಲ\u{cc6}ಕ\u{ccd}ಟ\u{ccd}ರ\u{cbf}ಕ\u{ccd} ಪ\u{ccd}ಲಗ\u{ccd}"),
            keywords: &[
                "ಎಲ\u{cc6}ಕ\u{ccd}ಟ\u{ccd}ರ\u{cbf}ಕಲ\u{ccd}",
                "ಎಲ\u{cc6}ಕ\u{ccd}ಟ\u{ccd}ರ\u{cbf}ಕ\u{ccd}",
                "ಪ\u{ccd}ಲಗ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("전기 플러그"),
            keywords: &["전기", "플러그"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("विज\u{947}चो प\u{94d}लग"),
            keywords: &["प\u{94d}लग", "विज", "विज\u{947}चो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("электр вилкасы"),
            keywords: &["вилка", "электр", "электр вилкасы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Stecker"),
            keywords: &["Stecker", "Stroum", "elektresch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{eb1}ກສຽບໄຟ"),
            keywords: &["ປ\u{eb1}ກສຽບ", "ປ\u{eb1}ກສຽບໄຟ", "ໄຟຟ\u{ec9}າ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("elektros kištukas"),
            keywords: &["elektra", "elektros kištukas", "kištukas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kontaktdakša"),
            keywords: &["elektrība", "kontaktdakša", "spraudnis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("puru hiko"),
            keywords: &["hiko", "puru"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("електричен приклучок"),
            keywords: &["електричен", "приклучок"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഇലക\u{d4d}\u{200c}ട\u{d4d}രിക\u{d4d} പ\u{d4d}ലഗ\u{d4d}"),
            keywords: &[
                "ഇലക\u{d4d}\u{200c}ട\u{d4d}രിക\u{d4d} പ\u{d4d}ലഗ\u{d4d}",
                "പ\u{d4d}ലഗ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("залгуур"),
            keywords: &["залгуур", "тог", "цахилгаан"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("इल\u{947}क\u{94d}ट\u{94d}रिक प\u{94d}लग"),
            keywords: &[
                "इल\u{947}क\u{94d}ट\u{94d}रिक",
                "प\u{94d}लग",
                "विद\u{94d}य\u{941}त",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("palam elektrik"),
            keywords: &["elektrik", "kuasa elektrik", "palam"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("plagga elettrika"),
            keywords: &["Ipplaggja", "elettriku", "l-elettriku", "plagga elettrika"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လျ\u{103e}ပ\u{103a}စစ\u{103a} ပလပ\u{103a}"),
            keywords: &[
                "ပလပ\u{103a}",
                "လျ\u{103e}ပ\u{103a}စစ\u{103a}",
                "လျ\u{103e}ပ\u{103a}စစ\u{103a} ဓာတ\u{103a}အား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("støpsel"),
            keywords: &["elektrisitet", "elektrisk", "plugg", "støpsel"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बिध\u{941}तीय प\u{94d}लग"),
            keywords: &["प\u{94d}लग", "बिध\u{941}त", "बिध\u{941}तीय"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("stekker"),
            keywords: &["elektriciteit", "elektrisch", "stekker"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("støpsel"),
            keywords: &["elektrisitet", "elektrisk", "plugg", "støpsel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବୈଦ\u{b4d}ୟ\u{b41}ତ\u{b3f}କ\u{b4d}\u{200c} ପ\u{b4d}ଲଗ\u{b4d}\u{200c}"),
            keywords: &[
                "ପ\u{b4d}ଲଗ\u{b4d}\u{200c}",
                "ବ\u{b3f}ଦ\u{b4d}ୟ\u{b41}ତ\u{b4d}\u{200c}",
                "ବୈଦ\u{b41}ତ\u{b3f}କ",
                "ବୈଦ\u{b4d}ୟ\u{b41}ତ\u{b3f}କ\u{b4d}\u{200c} ପ\u{b4d}ଲଗ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬਿਜਲੀ ਪਲ\u{a71}ਗ"),
            keywords: &["ਬਿਜਲੀ", "ਬਿਜਲੀ ਪਲ\u{a71}ਗ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بجلی دا پلگ"),
            keywords: &["بت\u{651}ی", "بجلی دا پلگ", "برقی", "پلگ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ẹlẹ\u{301}trík Plọg"),
            keywords: &["Plọg", "Ẹlẹ\u{301}trík Plọg", "Ẹlẹ\u{301}trísíti"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wtyczka elektryczna"),
            keywords: &["elektryczna", "podłączyć", "wtyczka elektryczna"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("برېښنايي پلګ"),
            keywords: &["برېښنا", "برېښنايي", "پلګ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("tomada elétrica"),
            keywords: &["eletricidade", "elétrica", "plugue", "tomada elétrica"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("ficha elétrica"),
            keywords: &["eletricidade", "elétrica", "ficha"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("enchufe"),
            keywords: &["enchufe"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("fișă electrică"),
            keywords: &[
                "electric",
                "electricitate",
                "fișă electrică",
                "priză",
                "ștecher",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-712"),
            keywords: &["E10-712"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("вилка"),
            keywords: &["вилка", "розетка", "штекер", "штепсель", "электричество"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("purize"),
            keywords: &["amashanyarazi", "cy’amashanyarazi", "purize", "urucomeko"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("برقي پلگ"),
            keywords: &["بجلي", "برقي", "پلگ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ව\u{dd2}ද\u{dd4}ල\u{dd2} පේන\u{dd4}ව"),
            keywords: &[
                "පේන\u{dd4}ව",
                "ව\u{dd2}ද\u{dd4}ල\u{dd2}",
                "ව\u{dd2}ද\u{dd4}ල\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zástrčka"),
            keywords: &["elektrická", "elektrina", "prípojka", "zástrčka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("električni vtikač"),
            keywords: &["elektrika", "električni vtikač", "električno", "vtikač"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("xadhiga dabka"),
            keywords: &["dab", "koronto", "xadhig", "xadhiga dabka"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("spinë elektrike"),
            keywords: &["elektricitet", "elektrike", "spinë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("струјни утикач"),
            keywords: &["струја", "струјни", "утикач"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["струјни утикач"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("strujni utikač"),
            keywords: &["struja", "strujni", "utikač"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["strujni utikač"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("elkontakt"),
            keywords: &["elkontakt", "kontakt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("plagi ya umeme"),
            keywords: &["nguvu za umeme", "plagi", "plagi ya umeme", "umeme"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பிளக\u{bcd}"),
            keywords: &["பிளக\u{bcd}", "பிளக\u{bcd} ப\u{bbe}யின\u{bcd}ட\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఎలక\u{c4d}ట\u{c4d}ర\u{c3f}క\u{c4d} ప\u{c4d}లగ\u{c4d}"),
            keywords: &[
                "ఎలక\u{c4d}ట\u{c4d}ర\u{c3f}క\u{c4d} ప\u{c4d}లగ\u{c4d}",
                "పవర\u{c4d} కన\u{c46}క\u{c4d}ట\u{c4d} చ\u{c47}యబడ\u{c3f}ంద\u{c3f}",
                "ప\u{c4d}లగ\u{c3f}న\u{c4d} చ\u{c47}యబడ\u{c3f}ంద\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("васлаки электрикӣ"),
            keywords: &["барқ", "барқӣ", "васлак", "васлаки электрикӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ปล\u{e31}\u{e4a}กไฟ"),
            keywords: &["ปล\u{e31}\u{e4a}ก", "ปล\u{e31}\u{e4a}กไฟ", "ไฟฟ\u{e49}า"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("tok wilkasy"),
            keywords: &["dürtgüç", "elektrik", "tok", "tok wilkasy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻumosi ʻuhila"),
            keywords: &["ʻumosi ʻuhila"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("elektrik fişi"),
            keywords: &["elektrik", "elektrik fişi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چاتقۇچ"),
            keywords: &["ئېلېكتىر", "توك", "چاتقۇچ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("штепсель"),
            keywords: &["вилка", "електрика", "електричний", "штепсель"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("الیکٹرک پلگ"),
            keywords: &["الیکٹرک پلگ", "برقی", "پلگ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("elektr kabel sanchqisi"),
            keywords: &[
                "elektr",
                "elektr energiyasi",
                "elektr kabel sanchqisi",
                "ulash",
                "vilka",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("phích cắm điện"),
            keywords: &["phích cắm điện", "điện"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("priisu kuuraŋ"),
            keywords: &["bu-kuuraŋ", "kuuraŋ", "priis", "priisu kuuraŋ"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iplagi yombane"),
            keywords: &["iplagi", "umbane", "yombane"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("pulọgi onina"),
            keywords: &[
                "pulọgi onina",
                "púlọ\u{301}ọ\u{300}gì",
                "ìná mọ\u{300}nà-mọ\u{301}ná",
                "ẹ\u{300}lé\u{329}tíríìkì",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("插頭"),
            keywords: &["插頭", "電", "電力"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("插头"),
            keywords: &["插头", "电", "电力"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("电源插头"),
            keywords: &["插头", "电插头", "电源", "电源插头", "电线"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("插頭"),
            keywords: &["插頭"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("插蘇"),
            keywords: &["插蘇"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ipulaki likagesi"),
            keywords: &["ipulaki", "ipulaki likagesi", "ugesi"],
        },
    ],
};
#[doc = "💻"]
pub const LAPTOP: crate::Emoji = crate::Emoji {
    glyph: "💻",
    codepoint: "1F4BB",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "laptop",
    group: "Objects",
    subgroup: "computer",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("skootrekenaar"),
            keywords: &["rekenaar", "skoot", "skootrekenaar"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ላፕቶፕ ኮምፒውተር"),
            keywords: &["ላፕቶፕ ኮምፒውተር", "ኮምፒውተር", "የግል", "ፒሲ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}كمبيوتر محمول"),
            keywords: &["شخصي", "كمبيوتر", "لابتوب", "\u{202b}كمبيوتر محمول"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("লেপটপ কম\u{9cd}পিউট\u{9be}ৰ"),
            keywords: &[
                "কম\u{9cd}পিউট\u{9be}ৰ",
                "পিচি",
                "ব\u{9cd}যক\u{9cd}তিগত",
                "লেপটপ কম\u{9cd}পিউট\u{9be}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kompüter"),
            keywords: &["kompüter", "pk", "şəxsi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ноўтбук"),
            keywords: &["ПК", "камп’ютар", "ноўтбук", "персанальны"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("лаптоп"),
            keywords: &["компютър", "лаптоп", "персонален"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ল\u{9cd}য\u{9be}পটপ কম\u{9cd}পিউট\u{9be}র"),
            keywords: &[
                "কম\u{9cd}পিউট\u{9be}র",
                "পিসি",
                "ব\u{9cd}যক\u{9cd}তিগত",
                "ল\u{9cd}য\u{9be}পটপ কম\u{9cd}পিউট\u{9be}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("urzhiataer hezoug"),
            keywords: &["PC", "urzhiataer", "urzhiataer hezoug"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("laptop"),
            keywords: &["laptop", "računar"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("ordinador portàtil"),
            keywords: &["PC", "equip", "ordinador portàtil", "personal", "portàtil"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some(
                "𑄣\u{11133}𑄠𑄛\u{11134}𑄑\u{11127}𑄛\u{11134} 𑄇\u{11127}𑄟\u{11134}𑄛𑄅𑄑𑄢\u{11134}",
            ),
            keywords: &[
                "𑄣\u{11133}𑄠𑄛\u{11134}𑄑\u{11127}𑄛\u{11134} 𑄇\u{11127}𑄟\u{11134}𑄛𑄅𑄑𑄢\u{11134}",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏄᎵᏍᏗ ᎠᎦᏙᎥᏒᎢ ᎠᏍᏆᏂᎪᏗᏍᎩ"),
            keywords: &[
                "pc",
                "ᎠᎦᏙᎥᎯᏍᏗ ᎠᏍᏆᏂᎪᏗᏍᎩ",
                "ᎠᏄᎵᏍᏗ ᎠᎦᏙᎥᎯᏍᏗ ᎠᏍᏆᏂᎪᏗᏍᎩ",
                "ᎠᏄᎵᏍᏗ ᎠᎦᏙᎥᏒᎢ ᎠᏍᏆᏂᎪᏗᏍᎩ",
                "ᎠᏏᏴᏫ ᎤᏤᎵ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("notebook"),
            keywords: &["laptop", "notebook", "osobní", "pc", "počítač"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cluniadur"),
            keywords: &["cluniadur", "cyfrifiadur", "personol"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bærbar computer"),
            keywords: &["bærbar computer", "pc"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Laptop"),
            keywords: &["Computer", "Laptop", "Notebook", "PC"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("φορητός υπολογιστής"),
            keywords: &["pc", "προσωπικός", "υπολογιστής", "φορητός υπολογιστής"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("laptop"),
            keywords: &["computer", "laptop", "pc", "personal"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["computer", "laptop", "pc", "personal"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["PC", "computer", "laptop", "personal"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ordenador portátil"),
            keywords: &["ordenador", "ordenador portátil", "pc", "personal"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("laptop"),
            keywords: &["computadora", "laptop", "netbook", "notebook", "personal"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("sülearvuti"),
            keywords: &["arvuti", "sülearvuti"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ordenagailu eramangarria"),
            keywords: &["ordenagailu", "ordenagailu eramangarria", "pc", "pertsonal"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("رایانه\u{654} کیفی"),
            keywords: &["رایانه", "رایانه\u{654} کیفی", "شخصی", "پی\u{200c}سی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kannettava tietokone"),
            keywords: &["kannetava", "kannettava tietokone", "läppäri", "tietokone"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("laptop computer"),
            keywords: &["computer", "laptop", "pc", "personal"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("fartelda"),
            keywords: &["fartelda", "telda"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("ordinateur portable"),
            keywords: &["ordinateur", "ordinateur portable"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ríomhaire glúine"),
            keywords: &["PC", "ríomhaire", "ríomhaire glúine"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("laptop"),
            keywords: &["coimpiutair", "laptop", "pc", "pearsanta"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("ordenador portátil"),
            keywords: &["ordenador", "portátil"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લ\u{ac7}પટોપ કમ\u{acd}પ\u{acd}ય\u{ac1}ટર"),
            keywords: &[
                "કમ\u{acd}પ\u{acd}ય\u{ac1}ટર",
                "પર\u{acd}સનલ કમ\u{acd}પ\u{acd}ય\u{ac1}ટર",
                "પીસી",
                "લ\u{ac7}પટોપ કમ\u{acd}પ\u{acd}ય\u{ac1}ટર",
                "વ\u{acd}યક\u{acd}તિગત",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kwamfutar tafi-da-gidanka"),
            keywords: &["kwamfuta", "kwamfutar tafi-da-gidanka", "na keɓe", "pc"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מחשב נייד"),
            keywords: &["אישי", "מחשב", "מחשב נייד", "פי סי"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ल\u{948}पटॉप"),
            keywords: &[
                "क\u{902}प\u{94d}य\u{942}टर",
                "पर\u{94d}सनल क\u{902}प\u{94d}य\u{942}टर",
                "पीसी",
                "ल\u{948}पटॉप",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("prijenosno računalo"),
            keywords: &["osobno računalo", "pc", "prijenosno računalo", "računalo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("laptop"),
            keywords: &["laptop", "notebook", "számítógép"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("նոթբուք"),
            keywords: &["անձնական", "համակարգիչ", "նոթբուք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("komputer laptop"),
            keywords: &["PC", "komputer", "komputer laptop", "personal"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("kọmpụtà nkunụkwụ"),
            keywords: &["keonwe", "kọmpụta", "kọmpụtà nkunụkwụ", "pc"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("tölva"),
            keywords: &["fartölva", "tölva"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("computer portatile"),
            keywords: &["PC", "computer portatile", "portatile"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ノートパソコン"),
            keywords: &[
                "PC",
                "コンピューター",
                "ノートパソコン",
                "パソコン",
                "ラップトップ",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("komputer laptop"),
            keywords: &["komputer", "komputer laptop", "pc", "personal"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ლეპტოპი"),
            keywords: &["კომპიუტერი", "ლეპტოპი", "პერსონალური", "პირადი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("aselkim aziraz"),
            keywords: &["aselkim aziraz"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ноутбук"),
            keywords: &["дк", "жеке", "компьютер", "ноутбук"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("computer"),
            keywords: &["computer"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ក\u{17bb}\u{17c6}ព\u{17d2}យ\u{17bc}ទ\u{17d0}រយ\u{17bd}រដៃ"),
            keywords: &[
                "pc",
                "ក\u{17bb}\u{17c6}ព\u{17d2}យ\u{17bc}ទ\u{17d0}រ",
                "ក\u{17bb}\u{17c6}ព\u{17d2}យ\u{17bc}ទ\u{17d0}រយ\u{17bd}រដៃ",
                "យកតាមខ\u{17d2}ល\u{17bd}ន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಲ\u{ccd}ಯಾಪ\u{ccd}\u{200c}ಟಾಪ\u{ccd} ಕಂಪ\u{ccd}ಯ\u{cc2}ಟರ\u{ccd}"),
            keywords: &[
                "ಕಂಪ\u{ccd}ಯ\u{cc2}ಟರ\u{ccd}",
                "ಪರ\u{ccd}ಸನಲ\u{ccd} ಕಂಪ\u{ccd}ಯ\u{cc2}ಟರ\u{ccd}",
                "ಲ\u{ccd}ಯಾಪ\u{ccd}\u{200c}ಟಾಪ\u{ccd} ಕಂಪ\u{ccd}ಯ\u{cc2}ಟರ\u{ccd}",
                "ವೈಯಕ\u{ccd}ತ\u{cbf}ಕ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("노트북"),
            keywords: &["PC", "노트북", "랩탑"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ल\u{945}पटॉप"),
            keywords: &["pc", "ल\u{945}पटॉप", "व\u{94d}यक\u{94d}तीगत", "स\u{902}गणक"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ноутбук"),
            keywords: &["жеке", "ноутбук"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Laptop"),
            keywords: &["Computer", "Laptop", "PC", "perséinlech"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຄອມພ\u{eb4}ວເຕ\u{eb5}ແລ\u{eb1}ບທ\u{eb1}ອບ"),
            keywords: &[
                "ຄອມພ\u{eb4}ວເຕ\u{eb5}",
                "ຄອມພ\u{eb4}ວເຕ\u{eb5}ແລ\u{eb1}ບທ\u{eb1}ອບ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("skreitinis kompiuteris"),
            keywords: &["asmeninis", "kompiuteris", "skreitinis kompiuteris"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("klēpjdators"),
            keywords: &["dators", "klēpjdators", "personālais"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("paparorohiko"),
            keywords: &["paparorohiko", "rorohiko", "rw", "whaiaro"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лаптоп"),
            keywords: &["компјутер", "лаптоп", "персонален"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ല\u{d3e}പ\u{d4d}\u{200c}ടോപ\u{d4d}പ\u{d4d} കമ\u{d4d}പ\u{d4d}യ\u{d42}ട\u{d4d}ടർ",
            ),
            keywords: &[
                "പിസി",
                "പേഴ\u{d4d}സണൽ",
                "പേഴ\u{d4d}സണൽ കമ\u{d4d}പ\u{d4d}യ\u{d42}ട\u{d4d}ടർ",
                "ല\u{d3e}പ\u{d4d}\u{200c}ടോപ\u{d4d}പ\u{d4d} കമ\u{d4d}പ\u{d4d}യ\u{d42}ട\u{d4d}ടർ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зөөврийн компьютер"),
            keywords: &["pc", "зөөврийн компьютер", "компьютер", "суурин компьютер"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ल\u{945}पटॉप स\u{902}गणक"),
            keywords: &[
                "का\u{901}प\u{94d}य\u{942}टर",
                "पीसी",
                "ल\u{945}पटॉप",
                "व\u{948}सक\u{94d}तिक",
                "स\u{902}गणक",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("komputer riba"),
            keywords: &["komputer", "komputer riba", "pc", "peribadi"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kompjuter laptop"),
            keywords: &["kompjuter", "kompjuter laptop", "pc", "personali"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ခရ\u{102e}းဆောင\u{103a} က\u{103d}န\u{103a}ပျ\u{1030}တာ"),
            keywords: &[
                "က\u{103d}န\u{103a}ပျ\u{1030}တာ",
                "ခရ\u{102e}းဆောင\u{103a} က\u{103d}န\u{103a}ပျ\u{1030}တာ",
                "ပ\u{102e}စ\u{102e}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bærbar datamaskin"),
            keywords: &["PC", "bærbar datamaskin", "datamaskin", "maskin"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ल\u{94d}यापटप कम\u{94d}प\u{94d}य\u{941}टर"),
            keywords: &[
                "कम\u{94d}प\u{94d}य\u{941}टर",
                "पिसी",
                "ल\u{94d}यापटप कम\u{94d}प\u{94d}य\u{941}टर",
                "व\u{94d}यक\u{94d}तिगत",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("laptop"),
            keywords: &["computer", "laptop", "pc", "personal computer"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("berbar datamaskin"),
            keywords: &["PC", "berbar datamaskin", "datamaskin", "maskin"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଲ\u{b3e}ପଟପ\u{b4d}\u{200c} କମ\u{b4d}ପ\u{b4d}ୟ\u{b41}ଟର\u{b4d}\u{200c}"),
            keywords: &[
                "କମ\u{b4d}ପ\u{b4d}ୟ\u{b41}ଟର\u{b4d}",
                "ପର\u{b4d}ସନ\u{b3e}ଲ\u{b4d}",
                "ପ\u{b3f}ସ\u{b3f}",
                "ଲ\u{b3e}ପଟପ\u{b4d}\u{200c} କମ\u{b4d}ପ\u{b4d}ୟ\u{b41}ଟର\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲ\u{a48}ਪਟਾਪ ਕ\u{a70}ਪਿਊਟਰ"),
            keywords: &[
                "pc",
                "ਨਿ\u{a71}ਜੀ",
                "ਨਿ\u{a71}ਜੀ ਕ\u{a70}ਪਿਉਟਰ",
                "ਲ\u{a48}ਪਟਾਪ ਕ\u{a70}ਪਿਊਟਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کمپیوٹر لیپ ٹاپ"),
            keywords: &["ذاتی", "کمپیوٹر", "کمپیوٹر لیپ ٹاپ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Láptọp"),
            keywords: &["Kọmpúta", "Láptọp", "PC", "Pẹ\u{301}sínal"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("laptop"),
            keywords: &["komputer", "laptop", "notebook", "osobisty", "wyświetlacz"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لپټاپ کمپیوټر"),
            keywords: &["شخصي", "لپټاپ کمپيوټر", "لپټاپ کمپیوټر", "پي سي", "کمپيوټر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("laptop"),
            keywords: &["PC", "computador", "laptop", "pessoal"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("computador portátil"),
            keywords: &["computador", "pc", "pessoal", "portátil"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("computer laptop"),
            keywords: &[
                "PC",
                "computer laptop",
                "computer personal",
                "laptop",
                "notebook",
                "portabil",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-632"),
            keywords: &["E10-632"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("ноутбук"),
            keywords: &["компьютер", "ноутбук", "портативный"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("mudasobwa igendanwa"),
            keywords: &["mudasobwa", "mudasobwa igendanwa", "y’umuntu"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ليپٽاپ ڪمپيوٽر"),
            keywords: &["ذاتي", "ليپٽاپ ڪمپيوٽر", "پي سي", "ڪمپيوٽر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ලැප\u{dca}ටොප\u{dca} පර\u{dd2}ගණකය"),
            keywords: &[
                "පර\u{dd2}ගණකය",
                "ප\u{dd3}ස\u{dd3}",
                "ප\u{dd4}ද\u{dca}ගල",
                "ලැප\u{dca}ටොප\u{dca} පර\u{dd2}ගණකය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("prenosný počítač"),
            keywords: &["osobný", "pc", "počítač", "prenosný počítač"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("prenosnik"),
            keywords: &["osebno", "prenosnik", "računalnik", "sistem", "windows"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("koombuyuutar laabtob ah"),
            keywords: &["bc", "gaar ah", "kombuyuutar", "koombuyuutar laabtob ah"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("laptop"),
            keywords: &["kompjuter", "laptop", "personal"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лаптоп рачунар"),
            keywords: &["лаптоп рачунар", "лични", "рачунар"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["лаптоп рачунар"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("laptop računar"),
            keywords: &["laptop računar", "lični", "računar"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["laptop računar"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("bärbar dator"),
            keywords: &["bärbar", "dator", "laptop", "pc"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kompyuta ndogo"),
            keywords: &["binafsi", "kompyuta", "kompyuta ndogo", "pc"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("லேப\u{bcd}ட\u{bbe}ப\u{bcd} கணினி"),
            keywords: &[
                "கணினி",
                "கணிப\u{bcd}பொறி",
                "தனிநபர\u{bcd} கணினி",
                "லேப\u{bcd}ட\u{bbe}ப\u{bcd} கணினி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ల\u{c4d}య\u{c3e}ప\u{c4d}\u{200c}ట\u{c3e}ప\u{c4d} కంప\u{c4d}యూటర\u{c4d}"),
            keywords: &[
                "ల\u{c4d}య\u{c3e}ప\u{c4d}\u{200c}ట\u{c3e}ప\u{c4d} కంప\u{c4d}యూటర\u{c4d}",
                "వ\u{c4d}యక\u{c4d}త\u{c3f}గత కంప\u{c4d}యూటర\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("компютери лэптоп"),
            keywords: &["компютер", "компютери лэптоп", "шахсӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แล\u{e47}ปท\u{e47}อป"),
            keywords: &[
                "คอมพ\u{e34}วเตอร\u{e4c}",
                "พ\u{e35}ซ\u{e35}",
                "แล\u{e47}ปท\u{e47}อป",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("noutbuk"),
            keywords: &["kompýuter", "noutbuk", "pk", "şahsy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("komipiuta fungasino"),
            keywords: &["komipiuta fungasino"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("dizüstü bilgisayar"),
            keywords: &["bilgisayar", "dizüstü bilgisayar", "kişisel"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("خاتىرە كومپيۇتېر"),
            keywords: &["خاتىرە كومپيۇتېر", "شەخسىي", "كومپيۇتېر"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("ноутбук"),
            keywords: &["комп’ютер", "ноутбук", "персональний", "пк"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("لیپ ٹاپ کمپیوٹر"),
            keywords: &["لیپ ٹاپ", "لیپ ٹاپ کمپیوٹر", "کمپیوٹر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("noutbuk"),
            keywords: &["kompyuter", "noutbuk", "shaxsiy"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("máy tính xách tay"),
            keywords: &["cá nhân", "máy tính", "máy tính xách tay", "pc"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("ordi portaabal"),
            keywords: &["benn-nit", "ordi portaabal", "ordinatër", "pc"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ikhompyutha ye-laptop"),
            keywords: &["i-pc", "ikhompyutha", "ikhompyutha ye-laptop", "yobuqu"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("kọ\u{300}ǹpútà àgbélétan"),
            keywords: &[
                "kọ\u{300}npútà",
                "kọ\u{300}npútà aládàni",
                "kọ\u{300}ǹpútà àgbélétan",
                "àdáni",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("筆記本電腦"),
            keywords: &["個人", "個人電腦", "筆記本電腦", "電腦"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("笔记本电脑"),
            keywords: &["个人", "个人电脑", "电脑", "笔记本电脑"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("笔记本电脑"),
            keywords: &["PC", "个人电脑", "手提电脑", "电脑", "笔记本电脑"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("筆電"),
            keywords: &["筆記型電腦", "筆電"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("手提電腦"),
            keywords: &["pc", "手提電腦", "筆記型電腦"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ikhompyutha eyilephuthophi"),
            keywords: &[
                "eqondene nomuntu",
                "i-pc",
                "ikhomputha",
                "ikhompyutha eyilephuthophi",
            ],
        },
    ],
};
#[doc = "🖥\u{fe0f}"]
pub const DESKTOP_COMPUTER: crate::Emoji = crate::Emoji {
    glyph: "🖥\u{fe0f}",
    codepoint: "1F5A5 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "desktop computer",
    group: "Objects",
    subgroup: "computer",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🖥",
        codepoint: "1F5A5",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "desktop computer",
        group: "Objects",
        subgroup: "computer",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("tafelrekenaar"),
            keywords: &["lessenaar", "rekenaar", "tafel", "tafelrekenaar"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ዴስክቶፕ ኮምፒውተር"),
            keywords: &["ኮምፒውተር", "ዴስክቶፕ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كمبيوتر"),
            keywords: &["سطح مكتب", "كمبيوتر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ডেস\u{9cd}কটপ কম\u{9cd}পিউট\u{9be}ৰ"),
            keywords: &["কম\u{9cd}পিউট\u{9be}ৰ", "ডেস\u{9cd}কটপ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("masaüstü kompüter"),
            keywords: &["kompüter", "masaüstü"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("стацыянарны камп’ютар"),
            keywords: &["камп’ютар", "стацыянарны"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Настолен компютър"),
            keywords: &["Настолен компютър", "компютър", "настолен"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ডেস\u{9cd}কটপ কম\u{9cd}পিউট\u{9be}র"),
            keywords: &["কম\u{9cd}পিউট\u{9be}র", "ডেস\u{9cd}কটপ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("urzhiataer burev"),
            keywords: &["urzhiataer", "urzhiataer burev"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("računar"),
            keywords: &["računar", "sto"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("ordinador d’escriptori"),
            keywords: &[
                "equip",
                "escriptori",
                "ordinador de sobretaula",
                "ordinador d’escriptori",
            ],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some(
                "𑄓𑄬𑄌\u{11134}𑄇\u{11134}𑄑\u{11127}𑄛\u{11134} 𑄇\u{11127}𑄟\u{11134}𑄛𑄅𑄑𑄢\u{11134}",
            ),
            keywords: &[
                "𑄓𑄬𑄌\u{11134}𑄇\u{11134}𑄑\u{11127}𑄛\u{11134} 𑄇\u{11127}𑄟\u{11134}𑄛𑄅𑄑𑄢\u{11134}",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏍᎩᎶᎩ ᎦᏚ ᎠᎦᏙᎥᎯᏍᏗᏍᎩ ᎠᏍᏆᏂᎪᏗᏍᎩ"),
            keywords: &[
                "ᎠᎦᏙᎥᎯᏍᏗᏍᎩ ᎠᏍᏆᏂᎪᏗᏍᎩ",
                "ᎦᏍᎩᎶᎩ ᎦᏚ",
                "ᎦᏍᎩᎶᎩ ᎦᏚ ᎠᎦᏙᎥᎯᏍᏗᏍᎩ ᎠᏍᏆᏂᎪᏗᏍᎩ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("počítač"),
            keywords: &["desktop", "osobní", "počítač", "stolní"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cyfrifiadur"),
            keywords: &["bwrdd gwaith", "cyfrifiadur"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("stationær computer"),
            keywords: &["computer", "stationær"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Desktopcomputer"),
            keywords: &["Bildschirm", "Desktop", "Desktopcomputer", "Monitor"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("επιτραπέζιος υπολογιστής"),
            keywords: &["επιτραπέζιος", "υπολογιστής"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("desktop computer"),
            keywords: &["computer", "desktop"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ordenador de sobremesa"),
            keywords: &["ordenador", "ordenador de sobremesa", "sobremesa"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("computadora de escritorio"),
            keywords: &["computadora", "computadora de escritorio", "escritorio"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["computadora", "computadora de escritorio", "pc"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("lauaarvuti"),
            keywords: &["arvuti", "lauaarvuti"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("mahaigaineko ordenagailua"),
            keywords: &["mahaigain", "mahaigaineko ordenagailua", "ordenagailu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("رایانه\u{654} میزی"),
            keywords: &["رایانه", "رایانه\u{654} میزی", "رومیزی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pöytäkone"),
            keywords: &["pöytäkone", "tietokone"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("desktop computer"),
            keywords: &["computer", "desktop"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("telda"),
            keywords: &["borðtelda", "telda"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("ordinateur de bureau"),
            keywords: &["ordinateur", "ordinateur de bureau"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ríomhaire deisce"),
            keywords: &["deisce", "ríomhaire"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("coimpiutair deasg"),
            keywords: &["coimpiutair", "deasg", "desktop"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("ordenador de escritorio"),
            keywords: &["escritorio", "ordenador", "ordenador de escritorio"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ડ\u{ac7}સ\u{acd}કટૉપ કમ\u{acd}પ\u{acd}ય\u{ac1}ટર"),
            keywords: &["કમ\u{acd}પ\u{acd}ય\u{ac1}ટર", "ડ\u{ac7}સ\u{acd}કટૉપ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kwamfutar na destof"),
            keywords: &["destof", "kwamfuta", "kwamfutar na destof"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מחשב שולחני"),
            keywords: &["מחשב", "מחשב שולחני"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ड\u{947}स\u{94d}कटॉप"),
            keywords: &[
                "क\u{902}प\u{94d}य\u{942}टर",
                "ड\u{947}स\u{94d}कटॉप",
                "स\u{902}गणक",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("stolno računalo"),
            keywords: &["računalo", "stolno računalo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("asztali számítógép"),
            keywords: &["asztali", "pc", "számítógép"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("համակարգիչ"),
            keywords: &["համակարգիչ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("komputer desktop"),
            keywords: &["desktop", "komputer"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("desktọọp kọmpụta"),
            keywords: &["desktọọp", "kọmpụta"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("heimilistölva"),
            keywords: &["borðtölva", "heimilistölva", "tölva"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("computer fisso"),
            keywords: &["PC tutto in uno", "computer fisso", "desktop", "desktop PC"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("デスクトップパソコン"),
            keywords: &[
                "PC",
                "コンピューター",
                "デスクトップ",
                "デスクトップパソコン",
                "パソコン",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("komputer desktop"),
            keywords: &["desktop", "komputer"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დესკტოპი"),
            keywords: &["დესკტოპი", "კომპიუტერი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("aselkim n tnarit"),
            keywords: &["aselkim n tnarit"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("дербес компьютер"),
            keywords: &["дербес компьютер", "жұмыс үстелі", "компьютер"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("stationær computer"),
            keywords: &["computer", "stationær"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ក\u{17bb}\u{17c6}\u{17bb}\u{17c6}ព\u{17d2}យ\u{17bc}ទ\u{17d0}រលើត\u{17bb}"),
            keywords: &[
                "ក\u{17bb}\u{17c6}ព\u{17d2}យ\u{17bc}ទ\u{17d0}រ",
                "ក\u{17bb}\u{17c6}ព\u{17d2}យ\u{17bc}ទ\u{17d0}រលើត\u{17bb}",
                "ក\u{17bb}\u{17c6}\u{17bb}\u{17c6}ព\u{17d2}យ\u{17bc}ទ\u{17d0}រលើត\u{17bb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಡ\u{cc6}ಸ\u{ccd}ಕ\u{ccd}\u{200c}ಟಾಪ\u{ccd} ಕಂಪ\u{ccd}ಯ\u{cc2}ಟರ\u{ccd}"),
            keywords: &[
                "ಕಂಪ\u{ccd}ಯ\u{cc2}ಟರ\u{ccd}",
                "ಡ\u{cc6}ಸ\u{ccd}ಕ\u{ccd}\u{200c}ಟಾಪ\u{ccd} ಕಂಪ\u{ccd}ಯ\u{cc2}ಟರ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("데스크톱 컴퓨터"),
            keywords: &["데스크톱", "컴퓨터"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ड\u{945}स\u{94d}कटॉप स\u{902}गणक"),
            keywords: &["ड\u{945}स\u{94d}कटॉप", "स\u{902}गणक"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("иш тактасындагы компьютер"),
            keywords: &["иш тактасы", "иш тактасындагы компьютер", "компьютер"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Desktopcomputer"),
            keywords: &["Computer", "Desktop", "Desktopcomputer"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຄອມພ\u{eb4}ວເຕ\u{eb5}ຕ\u{eb1}\u{ec9}ງໂຕະ"),
            keywords: &[
                "ຄອມພ\u{eb4}ວເຕ\u{eb5}",
                "ຄອມພ\u{eb4}ວເຕ\u{eb5}ຕ\u{eb1}\u{ec9}ງໂຕະ",
                "ຕ\u{eb1}\u{ec9}ງໂຕະ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("stalinis kompiuteris"),
            keywords: &["kompiuteris", "stalinis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("galddators"),
            keywords: &["dators", "galddators"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rorohiko papamahi"),
            keywords: &["papamahi", "rorohiko"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("компјутер"),
            keywords: &["десктоп", "компјутер"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ഡെസ\u{d4d}\u{200c}ക\u{d4d}\u{200c}ടോപ\u{d4d}പ\u{d4d} കമ\u{d4d}പ\u{d4d}യ\u{d42}ട\u{d4d}ടർ",
            ),
            keywords: &[
                "കമ\u{d4d}പ\u{d4d}യ\u{d42}ട\u{d4d}ടർ",
                "ഡെസ\u{d4d}\u{200c}ക\u{d4d}ക\u{d4d}ടോപ\u{d4d}പ\u{d4d}",
                "ഡെസ\u{d4d}\u{200c}ക\u{d4d}\u{200c}ടോപ\u{d4d}പ\u{d4d} കമ\u{d4d}പ\u{d4d}യ\u{d42}ട\u{d4d}ടർ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ширээний компьютер"),
            keywords: &["компьютер", "ширээний компьютер"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ड\u{947}स\u{94d}कटॉप स\u{902}गणक"),
            keywords: &["ड\u{947}स\u{94d}कटॉप", "स\u{902}गणक"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("komputer meja"),
            keywords: &["komputer", "meja"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kompjuter desktop"),
            keywords: &["desktop", "kompjuter"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စားပ\u{103d}\u{1032}တင\u{103a} က\u{103d}န\u{103a}ပျ\u{1030}တာ"),
            keywords: &[
                "က\u{103d}န\u{103a}ပျ\u{1030}တာ",
                "စားပ\u{103d}\u{1032}တင\u{103a} က\u{103d}န\u{103a}ပျ\u{1030}တာ",
                "ဒက\u{103a}စ\u{103a}တော\u{1037}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("stasjonær datamaskin"),
            keywords: &["PC", "datamaskin", "stasjonær"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ड\u{947}स\u{94d}कटप कम\u{94d}प\u{94d}य\u{941}टर"),
            keywords: &["कम\u{94d}प\u{94d}य\u{941}टर", "ड\u{947}स\u{94d}कटप"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("desktop"),
            keywords: &["computer", "desktop"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("stasjonær datamaskin"),
            keywords: &["PC", "datamaskin", "stasjonær"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଡେସ\u{b4d}କଟପ\u{b4d}\u{200c} କମ\u{b4d}ପ\u{b4d}ୟ\u{b41}ଟର\u{b4d}\u{200c}"),
            keywords: &[
                "କମ\u{b4d}ପ\u{b4d}ୟ\u{b41}ଟର",
                "ଡ\u{b3c}େସ\u{b4d}କଟପ\u{b4d}\u{200c}",
                "ଡେସ\u{b4d}କଟପ\u{b4d}\u{200c} କମ\u{b4d}ପ\u{b4d}ୟ\u{b41}ଟର\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਡ\u{a48}ਸਕਟਾਪ ਕ\u{a70}ਪਿਊਟਰ"),
            keywords: &["ਕ\u{a70}ਪਿਊਟਰ ਡ\u{a48}ਸਕਟਾਪ", "ਡ\u{a48}ਸਕਟਾਪ ਕ\u{a70}ਪਿਊਟਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ڈیسک ٹاپ کمپیوٹر"),
            keywords: &["ڈیسک ٹاپ", "ڈیسک ٹاپ کمپیوٹر", "کمپیوٹر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Dẹ\u{301}sktọ\u{301}p Kọmpúta"),
            keywords: &["Dẹ\u{301}sktọp", "Dẹ\u{301}sktọ\u{301}p Kọmpúta", "Kọmpúta"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("komputer"),
            keywords: &[
                "biurkowy",
                "ekran",
                "komputer",
                "stacjonarny",
                "wyświetlacz",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ډیسکټاپ کمپیوټر"),
            keywords: &["ډیسکټاپ", "کمپیوټر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("computador de mesa"),
            keywords: &["computador", "computador de mesa", "desktop"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("computador de secretária"),
            keywords: &["computador", "computador de secretária", "secretária"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("hanpara computadora"),
            keywords: &["computadora", "hanpara"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("computer desktop"),
            keywords: &["birou", "computer", "computer de birou", "computer desktop"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-811"),
            keywords: &["E10-811"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("компьютер"),
            keywords: &["компьютер", "настольный"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("mudasobwa iterekwa ku meza"),
            keywords: &[
                "iterekwa ku meza",
                "mudasobwa",
                "mudasobwa iterekwa ku meza",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڊيسڪٽاپ ڪمپيوٽر"),
            keywords: &["ڊيسڪ ٽاپ", "ڊيسڪٽاپ ڪمپيوٽر", "ڪمپيوٽر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඩෙස\u{dca}ක\u{dca}ටොප\u{dca} පර\u{dd2}ගණකය"),
            keywords: &[
                "ඩෙස\u{dca}ක\u{dca}ටොප\u{dca}",
                "ඩෙස\u{dca}ක\u{dca}ටොප\u{dca} පර\u{dd2}ගණකය",
                "පර\u{dd2}\u{dd2}ගණකය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("stolný počítač"),
            keywords: &["stolný", "stolný počítač"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("namizni računalnik"),
            keywords: &["namizni računalnik", "namizno", "računalnik"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("koombuyuutarka miiska"),
            keywords: &["koombuyuutar", "koombuyuutarka miiska", "miis"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kompjuter desktop"),
            keywords: &["desktop", "kompjuter"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("стони рачунар"),
            keywords: &["рачунар", "стони рачунар"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["стони рачунар"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("stoni računar"),
            keywords: &["računar", "stoni računar"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["stoni računar"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("stationär dator"),
            keywords: &["dator", "pc", "stationär dator"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kompyuta ya mezani"),
            keywords: &["kompyuta", "kompyuta ya mezani"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("டெஸ\u{bcd}க\u{bcd}ட\u{bbe}ப\u{bcd} கணினி"),
            keywords: &["கணினி", "டெஸ\u{bcd}க\u{bcd}ட\u{bbe}ப\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("డ\u{c46}స\u{c4d}క\u{c4d}\u{200c}ట\u{c3e}ప\u{c4d} కంప\u{c4d}యూటర\u{c4d}"),
            keywords: &[
                "కంప\u{c4d}యూటర\u{c4d}",
                "డ\u{c46}స\u{c4d}క\u{c4d}\u{200c}ట\u{c3e}ప\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("компютери рӯимизӣ"),
            keywords: &["компютер", "компютери рӯимизӣ", "рӯимизӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("คอมพ\u{e34}วเตอร\u{e4c}เดสก\u{e4c}ท\u{e47}อป"),
            keywords: &[
                "คอมพ\u{e34}วเตอร\u{e4c}",
                "คอมพ\u{e34}วเตอร\u{e4c}เดสก\u{e4c}ท\u{e47}อป",
                "ต\u{e31}\u{e49}งโต\u{e4a}ะ",
                "เดสก\u{e4c}ท\u{e47}อป",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("iş stoly kompýuteri"),
            keywords: &["iş stoly", "iş stoly kompýuteri", "kompýuter"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("komipiuta"),
            keywords: &["komipiuta"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("masaüstü bilgisayar"),
            keywords: &["bilgisayar", "masaüstü"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئۈستەل كومپيۇتېرى"),
            keywords: &["ئۈستەل", "ئۈستەل كومپيۇتېرى", "كومپيۇتېر"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("комп’ютер"),
            keywords: &["комп’ютер", "настільний"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ڈیسک ٹاپ کمپیوٹر"),
            keywords: &["ڈیسک ٹاپ", "ڈیسک ٹاپ کمپیوٹر", "کمپیوٹر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ish stoli kompyuteri"),
            keywords: &["ish stoli kompyuteri", "kompyuter"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("máy tính để bàn"),
            keywords: &["máy tính", "máy tính để bàn"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("ordi-biro ordinatër"),
            keywords: &["ordi-biro", "ordinatër"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ikhompyutha yedesktophu"),
            keywords: &["idesktophu", "ikhompyutha", "ikhompyutha yedesktophu"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("kọ\u{300}npútà a-gbé-lórí-tábílì"),
            keywords: &["a-gbé-lórí-tábílì", "kọ\u{300}npútà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("桌面電腦"),
            keywords: &["桌面", "桌面電腦", "電腦"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("桌面电脑"),
            keywords: &["桌面", "桌面电脑", "电脑"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("台式电脑"),
            keywords: &["PC", "个人电脑", "台式电脑", "显示器", "显示屏", "计算机"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("電腦"),
            keywords: &["桌上型電腦", "桌機", "電腦"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["桌上型電腦", "桌面電腦", "電腦"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ikhompyutha yedeskhithophu"),
            keywords: &["ideskhithophu", "ikhompyutha", "ikhompyutha yedeskhithophu"],
        },
    ],
};
#[doc = "🖨\u{fe0f}"]
pub const PRINTER: crate::Emoji = crate::Emoji {
    glyph: "🖨\u{fe0f}",
    codepoint: "1F5A8 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "printer",
    group: "Objects",
    subgroup: "computer",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🖨",
        codepoint: "1F5A8",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "printer",
        group: "Objects",
        subgroup: "computer",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("drukker"),
            keywords: &["druk", "drukker", "rekenaar"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ማተሚያ"),
            keywords: &["ማተሚያ", "ኮምፒውተር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("طابعة"),
            keywords: &["طابعة", "كمبيوتر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9cd}ৰিণ\u{9cd}ট\u{9be}ৰ"),
            keywords: &["কম\u{9cd}পিউট\u{9be}ৰ", "প\u{9cd}ৰিণ\u{9cd}ট\u{9be}ৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("printer"),
            keywords: &["kompüter", "printer"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("прынтар"),
            keywords: &["друк", "камп’ютар", "папера", "перыферыя", "прынтар"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("принтер"),
            keywords: &["компютър", "принтер"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9cd}রিন\u{9cd}ট\u{9be}র"),
            keywords: &["কম\u{9cd}পিউট\u{9be}র", "প\u{9cd}রিন\u{9cd}ট\u{9be}র"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("moullerez"),
            keywords: &["moullerez", "urzhiataer"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("štampač"),
            keywords: &["printer", "računar", "štampač"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("impressora"),
            keywords: &["impressora", "ordinador"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄛\u{11133}𑄢\u{11128}𑄚\u{11134}𑄑𑄢\u{11134}"),
            keywords: &["𑄛\u{11133}𑄢\u{11128}𑄚\u{11134}𑄑𑄢\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎦᎴᏴᏗᏍᎩ"),
            keywords: &["ᎠᎦᏙᎥᎯᏍᏗᏍᎩ ᎠᏍᏆᏂᎪᏗᏍᎩ", "ᏗᎦᎴᏴᏗᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("tiskárna"),
            keywords: &["počítač", "tiskárna"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("argraffydd"),
            keywords: &["argraffydd", "cyfrifiadur"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("printer"),
            keywords: &["computer", "printer", "stationær"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Drucker"),
            keywords: &["Computer", "Drucker"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("εκτυπωτής"),
            keywords: &["εκτυπωτής", "υπολογιστής"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("printer"),
            keywords: &["computer", "printer"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("impresora"),
            keywords: &["impresora", "ordenador"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["accesorio", "computadora", "impresora"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("printer"),
            keywords: &["arvuti", "printer"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("inprimagailua"),
            keywords: &["inprimagailua", "ordenagailua"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("چاپگر"),
            keywords: &["رایانه", "چاپگر"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tulostin"),
            keywords: &["printteri", "tietokone", "tulostin"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("printer"),
            keywords: &["computer", "printer"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("prentari"),
            keywords: &["prentari"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("imprimante"),
            keywords: &["imprimante", "ordinateur"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("printéir"),
            keywords: &["printéir", "ríomhaire"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("clò-bhualadair"),
            keywords: &[
                "clò-bhualadair",
                "clò-bhualadh",
                "coimpiutair",
                "prionntair",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("impresora"),
            keywords: &["impresora", "imprimir", "ordenador"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{acd}રિન\u{acd}ટર"),
            keywords: &["કમ\u{acd}પ\u{acd}ય\u{ac1}ટર", "પ\u{acd}રિન\u{acd}ટર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("na’urar ɗab’i"),
            keywords: &["kwamfuta", "na’urar ɗab’i"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מדפסת"),
            keywords: &["מדפסת", "מחשב"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{94d}रि\u{902}टर"),
            keywords: &["क\u{902}प\u{94d}य\u{942}टर", "प\u{94d}रि\u{902}टर"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("pisač"),
            keywords: &["pisač", "računalo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nyomtató"),
            keywords: &["nyomtató", "számítógép"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տպիչ"),
            keywords: &["համակարգիչ", "տպիչ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("printer"),
            keywords: &["komputer", "printer"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("igwe mbipụta"),
            keywords: &["igwe mbipụta", "kọmpụta"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("prentari"),
            keywords: &["prentari", "tölva"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("stampante"),
            keywords: &["stampante", "stampare", "stampe"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("プリンタ"),
            keywords: &["コピー機", "プリンタ", "プリンター", "印刷機", "複合機"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("printer"),
            keywords: &["komputer", "printer"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("პრინტერი"),
            keywords: &["კომპიუტერი", "პრინტერი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tasaggazt"),
            keywords: &["tasaggazt"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("принтер"),
            keywords: &["компьютер", "принтер"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("printer"),
            keywords: &["computer", "printer", "stationær"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17c9}ាស\u{17ca}\u{17b8}នព\u{17d2}រ\u{17b8}នធ\u{17d0}រ"),
            keywords: &[
                "ព\u{17d2}រ\u{17b8}នធ\u{17d0}រ",
                "ម\u{17c9}ាស\u{17ca}\u{17b8}នព\u{17d2}រ\u{17b8}នធ\u{17d0}រ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪ\u{ccd}ರ\u{cbf}ಂಟರ\u{ccd}"),
            keywords: &[
                "ಕಂಪ\u{ccd}ಯ\u{cc2}ಟರ\u{ccd}",
                "ಪ\u{ccd}ರ\u{cbf}ಂಟರ\u{ccd}",
                "ಮುದ\u{ccd}ರಣ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("프린터"),
            keywords: &["인쇄기", "프린터"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("म\u{941}द\u{94d}रक"),
            keywords: &["म\u{941}द\u{94d}रक", "स\u{902}गणक"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("принтер"),
            keywords: &["компьютер", "принтер"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Drécker"),
            keywords: &["Computer", "Drécker"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຄ\u{eb7}\u{ec8}ອງພ\u{eb4}ມ"),
            keywords: &["ຄອມພ\u{eb4}ວເຕ\u{eb5}", "ເຄ\u{eb7}\u{ec8}ອງພ\u{eb4}ມ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("spausdintuvas"),
            keywords: &["kompiuteris", "spausdintuvas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("printeris"),
            keywords: &["dators", "printeris"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pūreretā"),
            keywords: &["pūreretā", "rorohiko"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("печатач"),
            keywords: &["компјутер", "печатач", "хардвер"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d4d}രിന\u{d4d}റർ"),
            keywords: &[
                "കമ\u{d4d}പ\u{d4d}യ\u{d42}ട\u{d4d}ടർ",
                "പ\u{d4d}രിന\u{d4d}റർ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хэвлэгч"),
            keywords: &["компьютер", "хэвлэгч"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{94d}रि\u{902}टर"),
            keywords: &["प\u{94d}रि\u{902}टर", "स\u{902}गणक"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pencetak"),
            keywords: &["komputer", "pencetak"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("printer"),
            keywords: &["kompjuter", "printer"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပ\u{102f}\u{1036}န\u{103e}\u{102d}ပ\u{103a}စက\u{103a}"),
            keywords: &[
                "က\u{103d}န\u{103a}ပျ\u{1030}တာ",
                "ပ\u{102f}\u{1036}န\u{103e}\u{102d}ပ\u{103a}စက\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("skriver"),
            keywords: &["datamaskin", "printer", "skriver"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{94d}रिन\u{94d}टर"),
            keywords: &["कम\u{94d}प\u{94d}य\u{941}टर", "प\u{94d}रिन\u{94d}टर"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("printer"),
            keywords: &["computer", "printer"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("skrivar"),
            keywords: &["datamaskin", "printer", "skrivar"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b4d}ର\u{b3f}ଣ\u{b4d}ଟର\u{b4d}\u{200c}"),
            keywords: &[
                "କମ\u{b4d}ପ\u{b4d}ୟ\u{b41}ଟର\u{b4d}\u{200c}",
                "ପ\u{b4d}ର\u{b3f}ଣ\u{b4d}ଟର\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a4d}ਰਿ\u{a70}ਟਰ"),
            keywords: &["ਕ\u{a70}ਪਿਿਊਟਰ ਪ\u{a4d}ਰਿ\u{a70}ਟਰ", "ਪ\u{a4d}ਰਿ\u{a70}ਟਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پرنٹر"),
            keywords: &["پرنٹر", "کمپیوٹر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Prínta"),
            keywords: &["Kọmpúta", "Prínta"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("drukarka"),
            keywords: &["drukarka", "komputer"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پرنټر"),
            keywords: &["پرنټر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("impressora"),
            keywords: &["acessório", "computador", "impressora"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["computador", "impressora"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("impresora"),
            keywords: &["impresora"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("imprimantă"),
            keywords: &["computer", "imprimantă", "imprimare", "tipărire"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-812"),
            keywords: &["E10-812"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("принтер"),
            keywords: &["бумага", "печать", "принтер"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("mucapyi"),
            keywords: &["mucapyi", "mudasobwa"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پرنٽر"),
            keywords: &["پرنٽر", "ڪمپيوٽر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ම\u{dd4}ද\u{dca}\u{200d}රණ යන\u{dca}ත\u{dca}\u{200d}රය"),
            keywords: &[
                "පර\u{dd2}ගණකය",
                "ම\u{dd4}ද\u{dca}\u{200d}රණ යන\u{dca}ත\u{dca}\u{200d}රය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("tlačiareň"),
            keywords: &["počítač", "tlačiareň"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("tiskalnik"),
            keywords: &["računalnik", "tiskalnik"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("daabace"),
            keywords: &["daabace", "koombuyuutar"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("printer"),
            keywords: &["kompjuter", "printer"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("штампач"),
            keywords: &["рaчунaр", "штампач"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("štampač"),
            keywords: &["računar", "štampač"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("skrivare"),
            keywords: &["dator", "skrivare"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("printa"),
            keywords: &["kompyuta", "printa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பிரிண\u{bcd}டர\u{bcd}"),
            keywords: &["கணினி உபகரணம\u{bcd}", "பிரிண\u{bcd}டர\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c4d}ర\u{c3f}ంటర\u{c4d}"),
            keywords: &["ప\u{c4d}ర\u{c3f}ంటర\u{c4d}", "ముద\u{c4d}రణ"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("принтер"),
            keywords: &["компютер", "принтер"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เคร\u{e37}\u{e48}องพ\u{e34}มพ\u{e4c}"),
            keywords: &[
                "คอมพ\u{e34}วเตอร\u{e4c}",
                "เคร\u{e37}\u{e48}องพ\u{e34}มพ\u{e4c}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("printer"),
            keywords: &["kompýuter", "printer"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mīsini paaki"),
            keywords: &["mīsini paaki"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yazıcı"),
            keywords: &["bilgisayar", "yazıcı"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("باسقۇچ"),
            keywords: &["باسقۇچ", "كومپيۇتېر"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("принтер"),
            keywords: &["комп’ютер", "принтер"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پرنٹر"),
            keywords: &["پرنٹ", "پرنٹر", "کمپیوٹر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("printer"),
            keywords: &["kompyuter", "printer"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("máy in"),
            keywords: &["máy in", "máy tính"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("emprimaant"),
            keywords: &["emprimaant", "ordinatër"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iprinta"),
            keywords: &["ikhompyutha", "iprinta"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("pínríntà"),
            keywords: &["kọ\u{300}npútà", "pínríntà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("打印機"),
            keywords: &["打印機", "電腦"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("打印机"),
            keywords: &["打印机", "电脑"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("打印机"),
            keywords: &["印刷机", "喷墨打印", "复印", "打印机", "扫描", "激光打印"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("印表機"),
            keywords: &["列表機", "印表機"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["列印機", "印表機"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iphrinta"),
            keywords: &["ikhompyutha", "iphrinta"],
        },
    ],
};
#[doc = "⌨\u{fe0f}"]
pub const KEYBOARD: crate::Emoji = crate::Emoji {
    glyph: "⌨\u{fe0f}",
    codepoint: "2328 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "keyboard",
    group: "Objects",
    subgroup: "computer",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "⌨",
        codepoint: "2328",
        status: crate::Status::Unqualified,
        introduction_version: 1f32,
        name: "keyboard",
        group: "Objects",
        subgroup: "computer",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("sleutelbord"),
            keywords: &["rekenaar", "sleutel", "sleutelbord", "tik", "toets"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የቁልፍ ሰሌዳ"),
            keywords: &["ኮምፒውተር", "የቁልፍ ሰሌዳ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("لوحة مفاتيح"),
            keywords: &["الكمبيوتر", "لوحة مفاتيح"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কীব’ৰ\u{9cd}ড"),
            keywords: &["কম\u{9cd}পিউট\u{9be}ৰ", "কীব’ৰ\u{9cd}ড"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("klaviatura"),
            keywords: &["klaviatura", "kompüter"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("клавіятура"),
            keywords: &["камп’ютар", "клавішы", "клавіятура", "перыферыя"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("клавиатура"),
            keywords: &["клавиатура", "компютър"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("কিবোর\u{9cd}ড"),
            keywords: &["কম\u{9cd}পিউট\u{9be}র", "কিবোর\u{9cd}ড"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("klavier"),
            keywords: &["klavier", "urzhiataer"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("tastatura"),
            keywords: &["računar", "tastatura"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("teclat"),
            keywords: &["ordinador", "teclat"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄇\u{11128}𑄝\u{1112e}𑄖\u{11134}𑄢\u{11134}"),
            keywords: &["𑄇\u{11128}𑄝\u{1112e}𑄖\u{11134}𑄢\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᏐᏅᏍᏙᏗ"),
            keywords: &["ᎠᎦᏙᎥᎯᏍᏗᏍᎩ ᎠᏍᏆᏂᎪᏗᏍᎩ", "ᏗᏐᏅᏍᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("klávesnice"),
            keywords: &["klávesnice", "počítač"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bysellfwrdd"),
            keywords: &["bysellfwrdd", "cyfrifiadur"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("tastatur"),
            keywords: &["computer", "keyboard", "tastatur"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Tastatur"),
            keywords: &["Computer", "Tastatur"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πληκτρολόγιο"),
            keywords: &["πληκτρολόγιο", "υπολογιστής"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("keyboard"),
            keywords: &["computer", "keyboard"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("teclado"),
            keywords: &["ordenador", "teclado"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["accesorio", "computadora", "teclado"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("klaviatuur"),
            keywords: &["arvuti", "klaviatuur"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("teklatua"),
            keywords: &["ordenagailua", "teklatua"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("صفحه\u{200c}کلید"),
            keywords: &["رایانه", "صفحه\u{200c}کلید"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("näppäimistö"),
            keywords: &["näppis", "näppäimet", "näppäimistö", "tietokone"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("keyboard"),
            keywords: &["computer", "keyboard"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("knappaborð"),
            keywords: &["knappaborð"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("clavier"),
            keywords: &["clavier", "ordinateur"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("méarchlár"),
            keywords: &["méarchlár", "ríomhaire"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("meur-chlàr"),
            keywords: &["coimpiutair", "meur-chlàr"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("teclado"),
            keywords: &["ordenador", "teclado"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કીબોર\u{acd}ડ"),
            keywords: &["કમ\u{acd}પ\u{acd}ય\u{ac1}ટર", "કીબોર\u{acd}ડ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kibod"),
            keywords: &["kibod", "kwamfuta"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מקלדת"),
            keywords: &["לוח מקשים", "מחשב", "מקלדת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("कीबोर\u{94d}ड"),
            keywords: &["क\u{902}प\u{94d}य\u{942}टर", "कीबोर\u{94d}ड"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tipkovnica"),
            keywords: &["računalo", "tipkovnica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("billentyűzet"),
            keywords: &["billentyűzet", "számítógép"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ստեղնաշար"),
            keywords: &["համակարգիչ", "ստեղնաշար"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("keyboard"),
            keywords: &["keyboard", "komputer"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụgbọọtụgwo"),
            keywords: &["kọmpụta", "ụgbọọtụgwo"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("lyklaborð"),
            keywords: &["lyklaborð", "tölva"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("tastiera"),
            keywords: &["computer", "tasti", "tastiera", "tastiera senza fili"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("キーボード"),
            keywords: &["PC", "キーボード", "コンピューター", "パソコン"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("keyboard"),
            keywords: &["keyboard", "komputer"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კლავიატურა"),
            keywords: &["კლავიატურა", "კომპიუტერი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("anasiw"),
            keywords: &["anasiw"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("пернетақта"),
            keywords: &["компьютер", "пернетақта"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("tastatur"),
            keywords: &["computer", "tastatur"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ក\u{17d2}តារច\u{17bb}ច"),
            keywords: &[
                "ក\u{17bb}\u{17c6}ព\u{17d2}យ\u{17bc}ទ\u{17d0}រ",
                "ក\u{17d2}តារច\u{17bb}ច",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕೀಬೋರ\u{ccd}ಡ\u{ccd}"),
            keywords: &[
                "ಕಂಪ\u{ccd}ಯ\u{cc2}ಟರ\u{ccd}",
                "ಕೀಬೋರ\u{ccd}ಡ\u{ccd}",
                "ಮುದ\u{ccd}ರಣ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("키보드"),
            keywords: &["키보드"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("किबोर\u{94d}ड"),
            keywords: &["किबोर\u{94d}ड", "स\u{902}गणक"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("баскычтоп"),
            keywords: &["баскычтоп", "компьютер"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Tastatur"),
            keywords: &["Computer", "Tastatur"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແປ\u{ec9}ນພ\u{eb4}ມ"),
            keywords: &["ຄອມພ\u{eb4}ວເຕ\u{eb5}", "ແປ\u{ec9}ນພ\u{eb4}ມ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("klaviatūra"),
            keywords: &["klaviatūra", "kompiuteris"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("tastatūra"),
            keywords: &["dators", "tastatūra"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("papapātuhi"),
            keywords: &["papapātuhi", "rorohiko"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("тастатура"),
            keywords: &["компјутер", "тастатура", "хардвер"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കീബോർഡ\u{d4d}"),
            keywords: &["കമ\u{d4d}പ\u{d4d}യ\u{d42}ട\u{d4d}ടർ", "കീബോർഡ\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("компьютерийн гар"),
            keywords: &["компьютер", "компьютерийн гар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कीबोर\u{94d}ड"),
            keywords: &["कीबोर\u{94d}ड", "स\u{902}गणक"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("papan kekunci"),
            keywords: &["komputer", "papan kekunci"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("tastiera"),
            keywords: &["kompjuter", "tastiera"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("က\u{102e}းဘ\u{102f}တ\u{103a}"),
            keywords: &[
                "က\u{102e}းဘ\u{102f}တ\u{103a}",
                "က\u{103d}န\u{103a}ပျ\u{1030}တာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("tastatur"),
            keywords: &["datamaskin", "tastatur"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("किबोर\u{94d}ड"),
            keywords: &["कम\u{94d}प\u{94d}य\u{941}टर", "किबोर\u{94d}ड"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("toetsenbord"),
            keywords: &["computer", "toetsenbord"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("tastatur"),
            keywords: &["datamaskin", "tastatur"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କୀବୋର\u{b4d}ଡ\u{b4d}\u{200c}"),
            keywords: &[
                "କମ\u{b4d}ପ\u{b4d}ୟ\u{b41}ଟର\u{b4d}\u{200c}",
                "କୀବୋର\u{b4d}ଡ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕੀ-ਬ\u{a4b}ਰਡ"),
            keywords: &["ਕੀ-ਬ\u{a4b}ਰਡ", "ਕ\u{a70}\u{a70}ਪਿਊਟਰ ਕੀ-ਬ\u{a4b}ਰਡ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کلیدی تختہ"),
            keywords: &["کلیدی تختہ", "کمپیوٹر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kíbọd"),
            keywords: &["Kíbọd", "Kọmpúta"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("klawiatura"),
            keywords: &["klawiatura", "komputer", "pisać"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کیبورډ"),
            keywords: &["کمپیوټر", "کیبورډ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("teclado"),
            keywords: &["acessório", "computador", "digitação", "teclado"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["computador", "teclado"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("ñitina"),
            keywords: &["ñitina"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("tastatură"),
            keywords: &["computer", "tastatură", "taste"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-016"),
            keywords: &["E10-016"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("клавиатура"),
            keywords: &["клавиатура", "клавиши", "периферия"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("mwandikisho"),
            keywords: &["mudasobwa", "mwandikisho"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪليدي بورڊ"),
            keywords: &["ڪليدي بورڊ", "ڪمپيوٽر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("යත\u{dd4}ර\u{dd4} ප\u{dd4}වර\u{dd4}ව"),
            keywords: &["පර\u{dd2}ගණකය", "යත\u{dd4}ර\u{dd4} ප\u{dd4}වර\u{dd4}ව"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("klávesnica"),
            keywords: &["klávesnica", "počítač"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("tipkovnica"),
            keywords: &["računalnik", "tipkovnica"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kiiboodh"),
            keywords: &["kiiboodh", "koombuyuutar"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("tastierë"),
            keywords: &["kompjuter", "tastierë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("тастатура"),
            keywords: &["рaчунaр", "тастатура"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("tastatura"),
            keywords: &["računar", "tastatura"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tangentbord"),
            keywords: &["dator", "tangentbord"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kibodi"),
            keywords: &["kibodi", "kompyuta"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("விசைப\u{bcd}பலகை"),
            keywords: &["க\u{bc0}போர\u{bcd}டு", "விசைப\u{bcd}பலகை"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c40}బ\u{c4b}ర\u{c4d}డ\u{c4d}"),
            keywords: &[
                "కంప\u{c4d}యూటర\u{c4d}",
                "క\u{c40}బ\u{c4b}ర\u{c4d}డ\u{c4d}",
                "ట\u{c48}ప\u{c3f}ంగ\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("клавиатура"),
            keywords: &["клавиатура", "компютер"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แป\u{e49}นพ\u{e34}มพ\u{e4c}"),
            keywords: &["คอมพ\u{e34}วเตอร\u{e4c}", "แป\u{e49}นพ\u{e34}มพ\u{e4c}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("klawiatura"),
            keywords: &["klawiatura", "kompýuter"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ngaahi foʻi kī"),
            keywords: &["ngaahi foʻi kī"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("klavye"),
            keywords: &["bilgisayar", "klavye"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كۇنۇپكا تاختىسى"),
            keywords: &["كومپيۇتېر", "كۇنۇپكا تاختىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("клавіатура"),
            keywords: &["клавіатура", "комп’ютер"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کی بورڈ"),
            keywords: &["ٹائپنگ", "کمپیوٹر", "کی بورڈ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("klaviatura"),
            keywords: &["klaviatura", "kompyuter"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bàn phím"),
            keywords: &["bàn phím", "máy tính"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("klaawiyee"),
            keywords: &["klaawiyee", "ordinatër"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ikhibhodi"),
            keywords: &["ikhibhodi", "ikhompyutha"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("kííbọọ\u{300}dù"),
            keywords: &["kííbọọ\u{300}dù", "kọ\u{300}npútà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("鍵盤"),
            keywords: &["鍵盤", "電腦"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("键盘"),
            keywords: &["电脑", "键盘"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("键盘"),
            keywords: &["打字", "按键", "电脑", "输入", "键盘"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("鍵盤"),
            keywords: &["鍵盤", "電腦"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ikhibhodi"),
            keywords: &["ikhibhodi", "ikhompytha"],
        },
    ],
};
#[doc = "🖱\u{fe0f}"]
pub const COMPUTER_MOUSE: crate::Emoji = crate::Emoji {
    glyph: "🖱\u{fe0f}",
    codepoint: "1F5B1 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "computer mouse",
    group: "Objects",
    subgroup: "computer",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🖱",
        codepoint: "1F5B1",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "computer mouse",
        group: "Objects",
        subgroup: "computer",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("rekenaarmuis"),
            keywords: &["3", "drie", "knoppie", "muis", "rekenaar", "rekenaarmuis"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የኮምፒውተር መዳፊት"),
            keywords: &["ኮምፒውተር", "የኮምፒውተር መዳፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ماوس"),
            keywords: &["3", "ثلاثة", "زر", "كمبيوتر", "ماوس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কম\u{9cd}পিউট\u{9be}ৰ ম\u{9be}উচ"),
            keywords: &["কম\u{9cd}পিউট\u{9be}ৰ", "কম\u{9cd}পিউট\u{9be}ৰ ম\u{9be}উচ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kompüter siçanı"),
            keywords: &["3", "düymə", "kompüter", "kompüter siçanı", "siçan", "üç"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("камп’ютарная мыш"),
            keywords: &[
                "камп’ютар",
                "камп’ютарная мыш",
                "кнопкі",
                "мыш",
                "перыферыя",
                "тры",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Компютърна мишка"),
            keywords: &["Компютърна мишка", "бутон", "компютър", "мишка", "три"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("কম\u{9cd}পিউট\u{9be}রের ম\u{9be}উস"),
            keywords: &[
                "কম\u{9cd}পিউট\u{9be}র",
                "কম\u{9cd}পিউট\u{9be}রের ম\u{9be}উস",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("logodenn urzhiataer"),
            keywords: &["logodenn", "urzhiataer"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("miš za računar"),
            keywords: &["miš", "miš za računar", "računar"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("ratolí d’ordinador"),
            keywords: &["ordinador", "ratolí", "ratolí d’ordinador"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄇\u{11127}𑄟\u{11134}𑄛𑄅𑄑𑄢\u{11134} 𑄟𑄅𑄌\u{11134}\u{11134}"),
            keywords: &["𑄇\u{11127}𑄟\u{11134}𑄛𑄅𑄑𑄢\u{11134} 𑄟𑄅𑄌\u{11134}\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎦᏙᎥᎯᏍᏗᏍᎩ ᎠᏍᏆᏂᎪᏗᏍᎩ ᏥᏍᏕᏥ"),
            keywords: &["ᎠᎦᏙᎥᎯᏍᏗᏍᎩ ᎠᏍᏆᏂᎪᏗᏍᎩ", "ᎠᎦᏙᎥᎯᏍᏗᏍᎩ ᎠᏍᏆᏂᎪᏗᏍᎩ ᏥᏍᏕᏥ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("počítačová myš"),
            keywords: &["počítač", "počítačová myš"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("llygoden gyfrifiadurol"),
            keywords: &["botwm", "llygoden", "llygoden gyfrifiadurol"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("computermus"),
            keywords: &["computer", "computermus", "knap", "mus"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Computermaus"),
            keywords: &["Computer", "Computermaus"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ποντίκι υπολογιστή"),
            keywords: &["ποντίκι", "ποντίκι υπολογιστή", "υπολογιστής"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("computer mouse"),
            keywords: &["computer", "computer mouse"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ratón de ordenador"),
            keywords: &["ordenador", "ratón", "ratón de ordenador"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("mouse"),
            keywords: &["accesorio", "computadora", "mouse"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("arvutihiir"),
            keywords: &["arvuti", "arvutihiir", "hiir", "nupp"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ordenagailuko sagua"),
            keywords: &[
                "3",
                "botoi",
                "hiru",
                "ordenagailu",
                "ordenagailuko sagua",
                "sagu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("موشواره"),
            keywords: &["دکمه", "رایانه", "سه", "موشواره", "۳"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tietokoneen hiiri"),
            keywords: &["hiiri", "tietokone", "tietokoneen hiiri"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("computer mouse"),
            keywords: &["computer", "computer mouse"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("teldumús"),
            keywords: &["mús", "teldumús"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("souris d’ordinateur"),
            keywords: &["souris", "souris d’ordinateur"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("luchóg ríomhaire"),
            keywords: &["3", "cnaipe", "luchóg", "ríomhaire", "trí"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("luchag"),
            keywords: &["coimpiutair", "luchag"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("rato de ordenador"),
            keywords: &["ordenador", "rato", "rato de ordenador"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કમ\u{acd}પ\u{acd}ય\u{ac1}ટર માઉસ"),
            keywords: &[
                "3",
                "કમ\u{acd}પ\u{acd}ય\u{ac1}ટર",
                "ત\u{acd}રણ",
                "બટન",
                "માઉસ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("linzamin kwamfuta"),
            keywords: &["kwamfuta", "linzamin kwamfuta"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עכבר למחשב"),
            keywords: &["מחשב", "עכבר", "עכבר למחשב"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("माउस"),
            keywords: &["क\u{902}प\u{94d}य\u{942}टर माउस", "माउस"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("računalni miš"),
            keywords: &["miš", "računalni miš", "računalo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("számítógépes egér"),
            keywords: &[
                "3 gombos",
                "egér",
                "három",
                "számítógép",
                "számítógépes egér",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("համակարգչի մկնիկ"),
            keywords: &[
                "3",
                "երեք",
                "կոճակ",
                "համակարգիչ",
                "համակարգչի մկնիկ",
                "մկնիկ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("mouse komputer"),
            keywords: &["komputer", "mouse komputer"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwambe kọmpụta"),
            keywords: &["kọmpụta", "nwambe kọmpụta"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("tölvumús"),
            keywords: &["mús", "takki", "tölva", "tölvumús"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("mouse"),
            keywords: &["cursore", "mouse", "mouse senza fili"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("マウス"),
            keywords: &["PC", "コンピューター", "パソコン", "マウス"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("mouse komputer"),
            keywords: &["komputer", "mouse komputer"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მაუსი"),
            keywords: &["3", "თაგვი", "კომპიუტერი", "მაუსი", "სამი", "ღილაკი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("taɣerdayt n uselkim"),
            keywords: &["taɣerdayt n uselkim"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тінтуір"),
            keywords: &["3", "компьютер", "тінтуір", "түйме", "үш"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("computermus"),
            keywords: &["computer", "computermus", "knap", "mus"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17c9}ៅ"),
            keywords: &[
                "ក\u{17bb}\u{17c6}ព\u{17d2}យ\u{17bc}ទ\u{17d0}រ",
                "ម\u{17c9}ៅ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಂಪ\u{ccd}ಯ\u{cc2}ಟರ\u{ccd} ಮ\u{ccc}ಸ\u{ccd}"),
            keywords: &[
                "ಕಂಪ\u{ccd}ಯ\u{cc2}ಟರ\u{ccd}",
                "ಕಂಪ\u{ccd}ಯ\u{cc2}ಟರ\u{ccd} ಮ\u{ccc}ಸ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("컴퓨터 마우스"),
            keywords: &["마우스", "컴퓨터"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("स\u{902}गणक मावस"),
            keywords: &["स\u{902}गणक", "स\u{902}गणक मावस"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("компьютер чычканы"),
            keywords: &["компьютер", "компьютер чычканы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Computermaus"),
            keywords: &["Computer", "Computermaus"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເມ\u{ebb}າສ\u{ecc}ຄອມພ\u{eb4}ວເຕ\u{eb5}"),
            keywords: &[
                "ຄອມພ\u{eb4}ວເຕ\u{eb5}",
                "ເມ\u{ebb}າສ\u{ecc}",
                "ເມ\u{ebb}າສ\u{ecc}ຄອມພ\u{eb4}ວເຕ\u{eb5}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kompiuterio pelė"),
            keywords: &["kompiuterio pelė", "kompiuteris"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("datorpele"),
            keywords: &["datorpele", "dators", "pele"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kiore rorohiko"),
            keywords: &["kiore rorohiko", "rorohiko"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("глувче за компјутер"),
            keywords: &["глувче", "глувче за компјутер", "компјутер", "хардвер"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കമ\u{d4d}പ\u{d4d}യ\u{d42}ട\u{d4d}ടർ മ\u{d57}സ\u{d4d}"),
            keywords: &[
                "കമ\u{d4d}പ\u{d4d}യ\u{d42}ട\u{d4d}ടർ",
                "ബട\u{d4d}ടൺ",
                "മ\u{d57}സ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("компьютерийн хулгана"),
            keywords: &["компьютер", "компьютерийн хулгана"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{902}गणकाचा माऊस"),
            keywords: &["स\u{902}गणक", "स\u{902}गणकाचा माऊस"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tetikus komputer"),
            keywords: &["komputer", "tetikus komputer"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("maws tal-kompjuter"),
            keywords: &["kompjuter", "maws tal-kompjuter"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("က\u{103d}န\u{103a}ပျ\u{1030}တာမောက\u{103a}စ\u{103a}"),
            keywords: &[
                "က\u{103d}န\u{103a}ပျ\u{1030}တာ",
                "က\u{103d}န\u{103a}ပျ\u{1030}တာ မောက\u{103a}စ\u{103a}",
                "က\u{103d}န\u{103a}ပျ\u{1030}တာမောက\u{103a}စ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("datamus"),
            keywords: &["datamaskin", "datamus", "knapp", "mus"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कम\u{94d}प\u{94d}य\u{941}टर माउस"),
            keywords: &[
                "कम\u{94d}प\u{94d}य\u{941}टर",
                "कम\u{94d}प\u{94d}य\u{941}टर माउस",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("computermuis"),
            keywords: &["computer", "computermuis"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("datamus"),
            keywords: &["datamaskin", "datamus", "knapp", "mus"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କମ\u{b4d}ପ\u{b4d}ୟ\u{b41}ଟର\u{b4d}\u{200c} ମ\u{b3e}ଉସ\u{b4d}\u{200c}"),
            keywords: &[
                "କମ\u{b4d}ପ\u{b4d}ୟ\u{b41}ଟର\u{b4d}\u{200c}",
                "କମ\u{b4d}ପ\u{b4d}ୟ\u{b41}ଟର\u{b4d}\u{200c} ମ\u{b3e}ଉସ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a70}ਪਿਊਟਰ ਮਾਊਸ"),
            keywords: &["3", "ਕ\u{a70}ਪਿਊਟਰ", "ਤਿ\u{a70}ਨ", "ਬਟਨ", "ਮਾਊਸ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کمپیوٹر دا ماؤس"),
            keywords: &["کمپیوٹر", "کمپیوٹر دا ماؤس"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kọmpútá Maus"),
            keywords: &["Kọmpúta", "Kọmpútá Maus"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mysz komputerowa"),
            keywords: &["komputerowa", "mysz", "trzyprzyciskowa", "trójprzyciskowa"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د کمپیوټر موږک"),
            keywords: &["د کمپیوټر موږک", "کمپیوټر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mouse"),
            keywords: &["acessório", "computador", "mouse"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("rato de computador"),
            keywords: &["computador", "rato", "rato de computador"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("mouse computadorapaq"),
            keywords: &["mouse computadorapaq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("maus"),
            keywords: &["computer", "maus", "periferic"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-813"),
            keywords: &["E10-813"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мышка"),
            keywords: &["кнопки", "мышка", "мышь", "периферия", "устройство"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("imbeba ya mudasobwa"),
            keywords: &["imbeba ya mudasobwa", "mudasobwa"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪمپيوٽر مائوس"),
            keywords: &["ڪمپيوٽر", "ڪمپيوٽر مائوس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පර\u{dd2}ගණක ම\u{dd6}ස\u{dd2}කය"),
            keywords: &[
                "3",
                "පර\u{dd2}ගණක ම\u{dd6}ස\u{dd2}කය",
                "පර\u{dd2}ගණකය",
                "බොත\u{dca}තම",
                "ම\u{dd6}ස\u{dd2}කය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("počítačová myš"),
            keywords: &["myš", "počítač", "počítačová myš", "tlačidlo"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("računalniška miška"),
            keywords: &["računalnik", "računalniška miška"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("mawska koombuyuutarka"),
            keywords: &[
                "kombuyuutar",
                "mawska koombuyuutarka",
                "mowska koombuyuutarka",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("miu i kompjuterit"),
            keywords: &["kompjuter", "miu i kompjuterit"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("рачунарски миш"),
            keywords: &["рачунар", "рачунарски миш"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["рачунарски миш"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("računarski miš"),
            keywords: &["računar", "računarski miš"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["računarski miš"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("datormus"),
            keywords: &["dator", "datormus", "mus"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kipanya cha kompyuta"),
            keywords: &[
                "3",
                "kipanya",
                "kipanya cha kompyuta",
                "kitufe",
                "kompyuta",
                "tatu",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கணினி மவுஸ\u{bcd}"),
            keywords: &["கணினி மவுஸ\u{bcd}", "சுட\u{bcd}டி", "மவுஸ\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కంప\u{c4d}యూటర\u{c4d} మ\u{c4c}స\u{c4d}"),
            keywords: &[
                "కంప\u{c4d}యూటర\u{c4d}",
                "కర\u{c4d}సర\u{c4d}",
                "మ\u{c4c}స\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("муши компютер"),
            keywords: &["компютер", "муши компютер"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เมาส\u{e4c}"),
            keywords: &["คอมพ\u{e34}วเตอร\u{e4c}", "เมาส\u{e4c}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kompýuteriň syçanjygy"),
            keywords: &["kompýuter", "kompýuteriň syçanjygy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kumā fakakomipiuta"),
            keywords: &["kumā fakakomipiuta"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("bilgisayar faresi"),
            keywords: &["bilgisayar", "bilgisayar faresi", "düğme", "fare"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("مائۇس"),
            keywords: &["كومپيۇتېر", "مائۇس"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("комп’ютерна миша"),
            keywords: &["комп’ютер", "комп’ютерна миша", "миша"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کمپیوٹر ماؤس"),
            keywords: &["کرسر", "کمپیوٹر", "کمپیوٹر ماؤس"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kompyuter sichqonchasi"),
            keywords: &[
                "3",
                "kompyuter",
                "kompyuter sichqonchasi",
                "sichqoncha",
                "tugma",
                "uch",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("chuột máy tính"),
            keywords: &["chuột máy tính", "máy tính"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("suuri ordinatër"),
            keywords: &["ordinatër", "suuri ordinatër"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("imawusi yekhompyutha"),
            keywords: &["ikhompyutha", "imawusi yekhompyutha"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("máòsì kọ\u{300}npútà"),
            keywords: &["kọ\u{300}npútà", "máòsì kọ\u{300}npútà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("電腦滑鼠"),
            keywords: &["電腦", "電腦滑鼠"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("电脑滑鼠"),
            keywords: &["电脑", "电脑滑鼠"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("电脑鼠标"),
            keywords: &["有线鼠标", "激光鼠标", "点击", "点按", "电脑", "电脑鼠标"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("滑鼠"),
            keywords: &["滑鼠", "電腦"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isilawuli sekhompyutha"),
            keywords: &[
                "3",
                "ikhompyutha",
                "inkinobho",
                "isilawuli",
                "isilawuli sekhompyutha",
            ],
        },
    ],
};
#[doc = "🖲\u{fe0f}"]
pub const TRACKBALL: crate::Emoji = crate::Emoji {
    glyph: "🖲\u{fe0f}",
    codepoint: "1F5B2 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "trackball",
    group: "Objects",
    subgroup: "computer",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🖲",
        codepoint: "1F5B2",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "trackball",
        group: "Objects",
        subgroup: "computer",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("stuurbal"),
            keywords: &["bal", "rekenaar", "stuur", "stuurbal"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ትራክቦል"),
            keywords: &["ትራክቦል", "ኮምፒውተር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كرة مسار"),
            keywords: &["كرة مسار", "كمبيوتر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ট\u{9cd}ৰেকবল"),
            keywords: &["কম\u{9cd}পিউট\u{9be}ৰ", "ট\u{9cd}ৰেকবল"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kürəşəkilli manipulyator"),
            keywords: &["kompüter", "kürəşəkilli manipulyator"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("трэкбол"),
            keywords: &["камп’ютар", "перыферыя", "трэкбол", "шар"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("трекбол"),
            keywords: &["компютър", "трекбол"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ট\u{9cd}র\u{9cd}য\u{9be}কবল"),
            keywords: &["কম\u{9cd}পিউট\u{9be}র", "ট\u{9cd}র\u{9cd}য\u{9be}কবল"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kuglica za kretanje"),
            keywords: &["kuglica za kretanje", "računar", "trackball"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("ratolí de bola"),
            keywords: &["ordinador", "ratolí de bola"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄑\u{11133}𑄢𑄇\u{11134}𑄝\u{11127}𑄣\u{11134}"),
            keywords: &["𑄑\u{11133}𑄢𑄇\u{11134}𑄝\u{11127}𑄣\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎪᎷᏅᏓᏍᏆᏞᏍᏗ"),
            keywords: &["ᎠᎦᏙᎥᎯᏍᏗᏍᎩ ᎠᏍᏆᏂᎪᏗᏍᎩ", "ᎪᎷᏅᏓᏍᏆᏞᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("trackball"),
            keywords: &["počítač", "trackball"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("pelen lwybro"),
            keywords: &["cyfrifiadur", "pelen lwybro"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("trackball"),
            keywords: &["computer", "trackball"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Trackball"),
            keywords: &["Computer", "Trackball"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ιχνόσφαιρα"),
            keywords: &["ιχνόσφαιρα", "υπολογιστής"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("trackball"),
            keywords: &["computer", "trackball"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bola de desplazamiento"),
            keywords: &["bola de desplazamiento", "ordenador", "trackball"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("rueda de desplazamiento"),
            keywords: &["accesorio", "computadora", "rueda de desplazamiento"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["computadora", "rueda de desplazamiento", "trackball"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("juhtkuul"),
            keywords: &["arvuti", "juhtkuul", "kuul"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kontrolagailua"),
            keywords: &["kontrolagailua", "ordenagailu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("توپک"),
            keywords: &["توپک", "رایانه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ohjauspallo"),
            keywords: &["hiiri", "ohjauspallo", "tietokone"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("trackball"),
            keywords: &["computer", "trackball"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("stýrikúla"),
            keywords: &["stýrikúla"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("boule de commande"),
            keywords: &["boule de commande", "ordinateur", "souris à boule"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("boule de commande"),
            keywords: &["boule de commande"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("rianliathróid"),
            keywords: &["rianliathróid", "ríomhaire"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("trackball"),
            keywords: &["coimpiutair", "trackball"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("rato de bola"),
            keywords: &["ordenador", "rato", "rato de bola"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ટ\u{acd}ર\u{ac7}કબોલ"),
            keywords: &["કમ\u{acd}પ\u{acd}ય\u{ac1}ટર", "ટ\u{acd}ર\u{ac7}કબોલ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("bal na bin sawu"),
            keywords: &["bal na bin sawu", "kwamfuta"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גלגלת עכבר"),
            keywords: &["גלגלת", "מחשב", "עכבר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ट\u{94d}र\u{948}कबॉल"),
            keywords: &["क\u{902}प\u{94d}य\u{942}टर", "ट\u{94d}र\u{948}कबॉल"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("upravljačka kuglica"),
            keywords: &["računalo", "upravljačka kuglica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("trackball"),
            keywords: &["számítógép", "trackball"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("թրեքբոլ"),
            keywords: &["թրեքբոլ", "համակարգիչ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("trackball"),
            keywords: &["komputer", "trackball"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("bọọlụtraakị"),
            keywords: &["bọọlụtraakị", "kọmpụta"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("stýrihjól"),
            keywords: &["stýrihjól", "tölva"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("trackball"),
            keywords: &[
                "mouse a sfera",
                "mouse con trackball",
                "puntamento",
                "trackball",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("トラックボール"),
            keywords: &["PC", "コンピューター", "トラックボール", "パソコン"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("trakbal"),
            keywords: &["trakbal", "trakbal komputer"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბურთიანი მიმთითებელი"),
            keywords: &["ბურთიანი მიმთითებელი", "კომპიუტერი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: None,
            keywords: &["aselkim"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("трекбол"),
            keywords: &["компьютер", "трекбол"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("trackball"),
            keywords: &["computer", "trackball"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("គ\u{17d2}រាប\u{17cb}ឃ\u{17d2}ល\u{17b8}ក\u{17d2}ន\u{17bb}ងម\u{17c9}ៅ"),
            keywords: &[
                "ក\u{17bc}នឃ\u{17d2}ល\u{17b8}",
                "គ\u{17d2}រាប\u{17cb}ឃ\u{17d2}ល\u{17b8}",
                "គ\u{17d2}រាប\u{17cb}ឃ\u{17d2}ល\u{17b8}ក\u{17d2}ន\u{17bb}ងម\u{17c9}ៅ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಟ\u{ccd}ರಾಕ\u{ccd} ಬಾಲ\u{ccd}"),
            keywords: &[
                "ಕಂಪ\u{ccd}ಯ\u{cc2}ಟರ\u{ccd}",
                "ಟ\u{ccd}ರಾಕ\u{ccd} ಬಾಲ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("트랙볼"),
            keywords: &["마우스", "컴퓨터", "트랙볼"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ट\u{94d}र\u{945}कबॉल"),
            keywords: &["ट\u{94d}र\u{945}कबॉल", "स\u{902}गणक"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жылдыруу шары"),
            keywords: &["жылдыруу шары", "компьютер"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Trackball"),
            keywords: &["Computer", "Trackball"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{eb9}ກກ\u{ebb}ມຄວບຄ\u{eb8}ມ"),
            keywords: &[
                "ຄອມພ\u{eb4}ວເຕ\u{eb5}",
                "ລ\u{eb9}ກກ\u{ebb}ມ",
                "ລ\u{eb9}ກກ\u{ebb}ມຄວບຄ\u{eb8}ມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("rutulinis manipuliatorius"),
            keywords: &["kompiuteris", "rutulinis manipuliatorius"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kursorbumba"),
            keywords: &["dators", "kursorbumba"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pōrotaki"),
            keywords: &["pōrotaki", "rorohiko"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("топче за управување"),
            keywords: &["компјутер", "топче за управување", "хардвер"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ട\u{d4d}ര\u{d3e}ക\u{d4d}ക\u{d4d}\u{200c}ബോൾ"),
            keywords: &[
                "കമ\u{d4d}പ\u{d4d}യ\u{d42}ട\u{d4d}ടർ",
                "ട\u{d4d}ര\u{d3e}ക\u{d4d}ക\u{d4d}\u{200c}ബോൾ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("удирдлагын бөмбөг"),
            keywords: &["компьютер", "удирдлагын бөмбөг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ट\u{94d}र\u{945}कबॉल"),
            keywords: &["ट\u{94d}र\u{945}कबॉल", "स\u{902}गणक"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bebola jejak"),
            keywords: &["bebola jejak", "komputer"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("trackball"),
            keywords: &["kompjuter", "trackball"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မောက\u{103a}စ\u{103a}"),
            keywords: &["က\u{103d}န\u{103a}ပျ\u{1030}တာ", "မောက\u{103a}စ\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("styrekule"),
            keywords: &["datamaskin", "styrekule"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ट\u{94d}रयाकबल"),
            keywords: &["कम\u{94d}प\u{94d}य\u{941}टर", "ट\u{94d}रयाकबल"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("trackball"),
            keywords: &["computer", "trackball"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("styrekule"),
            keywords: &["datamaskin", "styrekule"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଟ\u{b4d}ର\u{b3e}କ\u{b4d}\u{200c}ବଲ\u{b4d}\u{200c}"),
            keywords: &[
                "କମ\u{b4d}ପ\u{b4d}ୟ\u{b41}ଟର\u{b4d}\u{200c}",
                "ଟ\u{b4d}ର\u{b3e}କ\u{b4d}\u{200c}ବଲ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਟ\u{a4d}ਰ\u{a47}ਕਬਾਲ"),
            keywords: &["ਕ\u{a70}ਪਿਊਟਰ", "ਟ\u{a4d}ਰ\u{a47}ਕਬਾਲ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ٹریک بال"),
            keywords: &["ٹریک بال", "کمپیوٹر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Trákbọl"),
            keywords: &["Kọmpúta", "Trákbọl"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("trackball"),
            keywords: &["komputer", "trackball"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ټریکبال"),
            keywords: &["ټریکبال", "کمپیوټر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("trackball"),
            keywords: &["computador", "mouse", "trackball"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("trackball"),
            keywords: &["computador", "informática", "trackball"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("muyu mousepi"),
            keywords: &["muyu mousepi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("trackball"),
            keywords: &["computer", "periferic", "trackball"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-814"),
            keywords: &["E10-814"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("трекбол"),
            keywords: &["ввод", "компьютер", "трекбол", "шар"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("Akayoborandanga"),
            keywords: &["Akayoborandanga", "mudasobwa"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٽريڪ بال"),
            keywords: &["ٽريڪ بال", "ڪمپيوٽر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ට\u{dca}\u{200d}රැක\u{dca}බෝල\u{dca}"),
            keywords: &["ට\u{dca}\u{200d}රැක\u{dca}බෝල\u{dca}", "පර\u{dd2}ගණකය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("trackball"),
            keywords: &["počítač", "trackball"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("sledilna kroglica"),
            keywords: &["računalnik", "sledilna kroglica"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kubada mowska"),
            keywords: &["koombuyuutar", "kubada mowska"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("sfera rrotulluese"),
            keywords: &["kompjuter", "sfera rrotulluese"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("куглица за кретање"),
            keywords: &["куглица за кретање", "рaчунaр"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kuglica za kretanje"),
            keywords: &["kuglica za kretanje", "računar"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("styrkula"),
            keywords: &["dator", "mus", "styrkula"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitufe cha kompyuta kinachoendesha kishale"),
            keywords: &["kitufe cha kompyuta kinachoendesha kishale", "kompyuta"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("டிர\u{bbe}க\u{bcd}ப\u{bbe}ல\u{bcd}"),
            keywords: &[
                "டிர\u{bbe}க\u{bcd}ப\u{bbe}ல\u{bcd}",
                "மவுஸ\u{bcd} ப\u{bbe}ல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ట\u{c4d}ర\u{c3e}క\u{c4d}\u{200c}బ\u{c3e}ల\u{c4d}"),
            keywords: &[
                "ట\u{c4d}ర\u{c3e}క\u{c4d}\u{200c}బ\u{c3e}ల\u{c4d}",
                "ప\u{c3e}య\u{c3f}ంటర\u{c4d}",
                "మ\u{c4c}స\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("трекбол"),
            keywords: &["компютер", "трекбол"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แทร\u{e47}กบอล"),
            keywords: &["คอมพ\u{e34}วเตอร\u{e4c}", "แทร\u{e47}กบอล"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("syçanjygyň topy"),
            keywords: &["kompýuter", "syçanjygyň topy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("polo toho"),
            keywords: &["polo toho"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("iz topu"),
            keywords: &["bilgisayar", "iz topu"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("مائۇس شارچىسى"),
            keywords: &["كومپيۇتېر", "مائۇس شارچىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("трекбол"),
            keywords: &["комп’ютер", "трекбол"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ٹریک بال"),
            keywords: &["بال", "ٹریک", "کمپیوٹر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("trekbol"),
            keywords: &["kompyuter", "trekbol"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bi xoay"),
            keywords: &["bi xoay", "máy tính"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("trackball"),
            keywords: &["ordinatër", "trackball"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-trackball"),
            keywords: &["i-trackball", "ikhompyutha"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("òntè\u{329} afinimọ\u{300}nà"),
            keywords: &["kọ\u{300}npútà", "òntè\u{329} afinimọ\u{300}nà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("軌跡球"),
            keywords: &["軌跡球", "電腦"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("轨迹球"),
            keywords: &["电脑", "轨迹球"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("轨迹球"),
            keywords: &["有线鼠标", "电脑", "轨迹球", "追踪球", "鼠标"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("軌跡球"),
            keywords: &["軌跡球"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("itrackball"),
            keywords: &["ikhompyutha", "itrackball"],
        },
    ],
};
#[doc = "💽"]
pub const COMPUTER_DISK: crate::Emoji = crate::Emoji {
    glyph: "💽",
    codepoint: "1F4BD",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "computer disk",
    group: "Objects",
    subgroup: "computer",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("miniskyf"),
            keywords: &["miniskyf", "opties", "rekenaar", "skyf"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሚኒዲስክ"),
            keywords: &["ሚኒዲስክ", "ኦፕቲካል", "ኮምፒውተር", "ዲስክ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}قرص كمبيوتر"),
            keywords: &["قرص", "\u{202b}قرص كمبيوتر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কম\u{9cd}পিউট\u{9be}ৰ ডিস\u{9cd}ক"),
            keywords: &[
                "অপ\u{9cd}টিকেল",
                "কম\u{9cd}পিউট\u{9be}ৰ",
                "ডিস\u{9cd}ক",
                "মিনিডিস\u{9cd}ক",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("mini disk"),
            keywords: &["disk", "kompüter", "mini disk", "minidisk", "optik"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("міні-дыск"),
            keywords: &["аптычны", "дыск", "камп’ютар", "міні-дыск", "носьбіт"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("минидиск"),
            keywords: &["диск", "компютър", "минидиск", "оптичен"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("কম\u{9cd}পিউট\u{9be}র ডিস\u{9cd}ক"),
            keywords: &[
                "অপটিক\u{9cd}য\u{9be}ল",
                "কম\u{9cd}পিউট\u{9be}র",
                "ডিস\u{9cd}ক",
                "মিনি ডিস\u{9cd}ক",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pladenn urzhiater"),
            keywords: &["pladenn", "urzhiater"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("disk"),
            keywords: &["disk", "minidisk", "optički", "računar"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("minidisc"),
            keywords: &["disc", "equip", "minidisc", "òptic"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄇\u{11127}𑄟\u{11134}𑄛𑄅𑄑𑄢\u{11134} 𑄓\u{11128}𑄌\u{11134}𑄇\u{11134}"),
            keywords: &["𑄇\u{11127}𑄟\u{11134}𑄛𑄅𑄑𑄢\u{11134} 𑄓\u{11128}𑄌\u{11134}𑄇\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎦᏙᎥᎯᏍᏗᏍᎩ ᎠᏍᏆᏂᎪᏗᏍᎩ ᎠᏠᏗ"),
            keywords: &[
                "ᎠᎦᏙᎥᎯᏍᏗᏍᎩ ᎠᏍᏆᏂᎪᏗᏍᎩ",
                "ᎠᎦᏙᎥᎯᏍᏗᏍᎩ ᎠᏍᏆᏂᎪᏗᏍᎩ ᎠᏠᏗ",
                "ᎠᎪᏩᏛᏗ",
                "ᎠᏠᏗ",
                "ᎤᏍᏗ ᎠᏠᏗ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("minidisk"),
            keywords: &["disk", "minidisk", "optické", "optický", "počítač"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("disg mini"),
            keywords: &["cyfrifiadur", "disg", "disg mini", "optegol"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("cd-rom"),
            keywords: &["cd-rom", "disk"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Minidisc"),
            keywords: &["MD", "Minidisc"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("δίσκος υπολογιστή"),
            keywords: &[
                "minidisk",
                "δίσκος",
                "δίσκος υπολογιστή",
                "οπτικός",
                "υπολογιστής",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("computer disk"),
            keywords: &["computer", "disk", "minidisk", "optical"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("minidisc"),
            keywords: &["disco", "md", "minidisc"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("minidisco"),
            keywords: &["computadora", "disco", "minidisc", "minidisco"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("disco duro"),
            keywords: &["disco duro"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("arvutiketas"),
            keywords: &["arvuti", "arvutiketas", "ketas", "optiline"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("minidisc-a"),
            keywords: &["disko", "minidisc-a", "minidisk", "optiko", "ordenagailu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مینی دیسک"),
            keywords: &["دیسک", "رایانه", "مینی دیسک", "نوری"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("minidisk"),
            keywords: &["levy", "minidisc", "minidisk", "tietokone"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("minidisc"),
            keywords: &["computer", "disk", "minidisc", "minidisk", "optikal"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("teldudiskur"),
            keywords: &["diskur", "teldudiskur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("disque d’ordinateur"),
            keywords: &["disque", "disque d’ordinateur"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("disque dur"),
            keywords: &["disque", "disque dur", "optique", "ordinateur"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("diosca ríomhaire"),
            keywords: &["MD", "diosca ríomhaire", "miondiosca"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("diosga coimpiutair"),
            keywords: &[
                "coimpiutair",
                "diosg",
                "diosga coimpiutair",
                "lèirsinneach",
                "meanbh-dhiosg",
                "minidisk",
                "optaigeach",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("minidisc"),
            keywords: &["disco", "minidisc", "ordenador"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મિનિ ડિસ\u{acd}ક"),
            keywords: &[
                "ઑપ\u{acd}ટિકલ",
                "કમ\u{acd}પ\u{acd}ય\u{ac1}ટર",
                "ડિસ\u{acd}ક",
                "મિનિ ડિસ\u{acd}ક",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("diskin kwamfuta"),
            keywords: &[
                "diski",
                "diskin kwamfuta",
                "kwamfuta",
                "na da’ira",
                "ƙaramin diski",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("דיסק"),
            keywords: &["אופטי", "דיסק", "דיסק קשיח", "מחשב", "מינידיסק"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("क\u{902}प\u{94d}य\u{942}टर डिस\u{94d}क"),
            keywords: &[
                "ऑप\u{94d}टिकल",
                "क\u{902}प\u{94d}य\u{942}टर",
                "डिस\u{94d}क",
                "मिनी डिस\u{94d}क",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("minidisk"),
            keywords: &["disk", "minidisk", "optički", "računalo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("minidisk"),
            keywords: &["lemez", "minidisk", "optikai", "számítógép"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մինի սկավառակ"),
            keywords: &["համակարգիչ", "մինի սկավառակ", "սկավառակ", "օպտիկական"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("disk komputer"),
            keywords: &["disk", "disk mini", "komputer", "optik"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("diiski kọmpụta"),
            keywords: &["diiski", "diiskiobere", "kọmpụta", "ọptịkal"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("MD-diskur"),
            keywords: &["MD", "MD-diskur", "mini disc", "smádiskur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("minidisc"),
            keywords: &["MD", "disc", "mini disc", "minidisc"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("MD"),
            keywords: &["MD", "MO", "コンピューター", "ミニディスク"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("cakram komputer"),
            keywords: &["cakram", "cakram cilik", "komputer", "optik"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მინიდისკი"),
            keywords: &["დისკი", "კომპიუტერი", "მინიდისკი", "ოპტიკური"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("aḍebsi n uselkim"),
            keywords: &["aḍebsi n uselkim"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шағын диск"),
            keywords: &["диск", "компьютер", "оптикалық", "шағын диск"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("mini disk"),
            keywords: &["disk", "mini disk"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ឌ\u{17b8}សខ\u{17d2}នាតត\u{17bc}ច"),
            keywords: &[
                "ឌ\u{17b8}ស",
                "ឌ\u{17b8}សខ\u{17d2}នាតត\u{17bc}ច",
                "ស\u{17ca}\u{17b8}ឌ\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಂಪ\u{ccd}ಯ\u{cc2}ಟರ\u{ccd} ಡ\u{cbf}ಸ\u{ccd}ಕ\u{ccd}"),
            keywords: &[
                "ಆಪ\u{ccd}ಟ\u{cbf}ಕಲ\u{ccd}",
                "ಕಂಪ\u{ccd}ಯ\u{cc2}ಟರ\u{ccd}",
                "ಡ\u{cbf}ಸ\u{ccd}ಕ\u{ccd}",
                "ಮ\u{cbf}ನ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("엠디"),
            keywords: &["MD", "디스크", "미니 디스크", "엠디"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("स\u{902}गणक डिस\u{94d}क"),
            keywords: &[
                "ऑप\u{94d}टिकल",
                "डिस\u{94d}क",
                "मिनिडिस\u{94d}क",
                "स\u{902}गणक",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("минидиск"),
            keywords: &["диск", "компьютер", "минидиск", "оптикалык"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Minidisk"),
            keywords: &["Computer", "Disk", "Minidisk", "optesch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແຜ\u{ec8}ນດ\u{eb4}ສ"),
            keywords: &["ຄອມພ\u{eb4}ວເຕ\u{eb5}", "ແຜ\u{ec8}ນດ\u{eb4}ສ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kompiuterio diskas"),
            keywords: &[
                "diskas",
                "kompiuterio diskas",
                "kompiuteris",
                "minidiskas",
                "optinis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("minidisks"),
            keywords: &["dators", "disks", "minidisks", "optiskais"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kōpae rorohiko"),
            keywords: &["kōpae", "kōpae-iti", "rorohiko", "whatu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("минидиск"),
            keywords: &["компјутер", "минидиск", "хардвер"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മിനി ഡിസ\u{d4d}ക\u{d4d}ക\u{d4d}"),
            keywords: &[
                "എംഡി",
                "ഒപ\u{d4d}\u{200c}റ\u{d4d}റിക\u{d4d}കൽ",
                "കമ\u{d4d}പ\u{d4d}യ\u{d42}ട\u{d4d}ടർ",
                "ഡിസ\u{d4d}ക\u{d4d}ക\u{d4d}",
                "മിനി ഡിസ\u{d4d}ക\u{d4d}ക\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("компьютерын диск"),
            keywords: &[
                "диск",
                "компьютер",
                "компьютерын диск",
                "мини диск",
                "оптикал",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मिनिडिस\u{94d}क"),
            keywords: &[
                "ऑप\u{94d}टिकल",
                "डिस\u{94d}क",
                "मिनिडिस\u{94d}क",
                "स\u{902}गणक",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("cakera komputer"),
            keywords: &["cakera", "cakera mini", "komputer", "optik"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("diska tal-kompjuter"),
            keywords: &[
                "diska",
                "diska tal-kompjuter",
                "kompjuter",
                "minidisk",
                "ottiċi",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မ\u{102e}န\u{102e}ဒစ\u{103a}"),
            keywords: &[
                "က\u{103d}န\u{103a}ပျ\u{1030}တာ",
                "ဒစ\u{103a}စ\u{103a}ခ\u{103a}",
                "မ\u{102e}န\u{102e}ဒစ\u{103a}",
                "မ\u{102e}န\u{102e}ဒစ\u{103a}စ\u{103a}ခ\u{103a}",
                "အော\u{1037}ပ\u{103a}တစ\u{103a}ကယ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("datadisk"),
            keywords: &["MD", "datadisk", "disk", "lagring", "minidisk", "optisk"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कम\u{94d}प\u{94d}य\u{941}टर डिस\u{94d}क"),
            keywords: &[
                "अप\u{94d}टिकल",
                "कम\u{94d}प\u{94d}य\u{941}टर",
                "डिस\u{94d}क",
                "मिनी डिस\u{94d}क",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("harddisk"),
            keywords: &["computer", "disk", "harddisk", "optisch"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("datadisk"),
            keywords: &["MD", "datadisk", "disk", "lagring", "minidisk", "optisk"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କମ\u{b4d}ପ\u{b4d}ୟ\u{b41}ଟର\u{b4d}\u{200c} ଡ\u{b3f}ସ\u{b4d}କ\u{b4d}"),
            keywords: &[
                "ଅପ\u{b4d}ଟ\u{b3f}କ\u{b3e}ଲ\u{b4d}",
                "କମ\u{b4d}ପ\u{b4d}ୟ\u{b41}ଟର\u{b4d}\u{200c} ଡ\u{b3f}ସ\u{b4d}କ",
                "କମ\u{b4d}ପ\u{b4d}ୟ\u{b41}ଟର\u{b4d}\u{200c} ଡ\u{b3f}ସ\u{b4d}କ\u{b4d}",
                "ଡ\u{b3f}ସ\u{b4d}କ\u{b4d}",
                "ମ\u{b3f}ନ\u{b3f} ଡ\u{b3f}ସ\u{b4d}କ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a70}ਪਿਊਟਰ ਡਿਸਕ"),
            keywords: &["ਆਪਟੀਕਲ", "ਕ\u{a70}ਪਿਊਟਰ", "ਡਿਸਕ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کمپیوٹر ڈسک"),
            keywords: &["بصریات", "چھوٹی ڈسک", "ڈسک", "کمپیوٹر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kọmpútá Disk"),
            keywords: &[
                "Disk",
                "Kọmpúta",
                "Kọmpútá Disk",
                "Mínídisk",
                "Vẹ\u{301}rí Smọ\u{301}l Disk",
                "Ọ\u{301}ptíkal",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("dysk komputerowy"),
            keywords: &["dysk MD", "dysk komputerowy", "płyta"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د کمپیوټر ډیسک"),
            keywords: &["آپتيکي", "د کمپیوټر ډیسک", "مني ډسک", "ډسک", "کمپيوټر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("minidisc"),
            keywords: &[
                "MD",
                "computador",
                "disco",
                "mini disc",
                "minidisc",
                "minidisk",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("minidisco"),
            keywords: &["computador", "disco", "minidisco", "ótico"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("computadora ruyru"),
            keywords: &["computadora ruyru"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("disc de computer"),
            keywords: &[
                "computer",
                "disc",
                "disc de computer",
                "minidisc",
                "unitate optică",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-634"),
            keywords: &["E10-634"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("диск"),
            keywords: &["диск", "компьютер", "компьютерный диск", "оптический диск"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("disiki ya mudasobwa"),
            keywords: &[
                "disike",
                "disike nto",
                "disiki ya mudasobwa",
                "kijyanye no kubera",
                "mudasobwa",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪمپيوٽر جي ڊسڪ"),
            keywords: &["آپٽيڪل", "ننڍي ڊسڪ", "ڊسڪ", "ڪمپيوٽر", "ڪمپيوٽر جي ڊسڪ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ම\u{dd2}න\u{dd2}ඩ\u{dd2}ස\u{dca}ක\u{dca}"),
            keywords: &[
                "තැට\u{dd2}ය",
                "පර\u{dd2}ගණකය",
                "ප\u{dca}\u{200d}රක\u{dcf}ශ",
                "ම\u{dd2}න\u{dd2}ඩ\u{dd2}ස\u{dca}ක\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("počítačový disk"),
            keywords: &["disk", "optický", "počítač", "počítačový disk"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("minidisk"),
            keywords: &["disk", "minidisk", "optično", "računalnik"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("cajalada koombuyuutarka"),
            keywords: &[
                "cajalad",
                "cajalad yar",
                "cajalada koombuyuutarka",
                "koombuyuutar",
                "obtikal",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("disk i vogël"),
            keywords: &["disk", "disk i vogël", "kompjuter", "minidisk", "optik"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мини-диск"),
            keywords: &["oптички", "диск", "мини-диск", "рaчунaр"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("mini-disk"),
            keywords: &["disk", "mini-disk", "optički", "računar"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("datordiskett"),
            keywords: &["dator", "datordiskett", "optisk", "skiva"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("diski ndogo"),
            keywords: &["diski", "diski ndogo", "kompyuta", "ya macho"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["diski", "diski ndogo", "kompyuta", "mwangaza"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மினி டிஸ\u{bcd}க\u{bcd}"),
            keywords: &[
                "டிஸ\u{bcd}க\u{bcd}",
                "மினி டிஸ\u{bcd}க\u{bcd}",
                "வட\u{bcd}டு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c3f}న\u{c40}డ\u{c3f}స\u{c4d}క\u{c4d}"),
            keywords: &[
                "ఆప\u{c4d}ట\u{c3f}కల\u{c4d}",
                "కంప\u{c4d}యూటర\u{c4d}",
                "డ\u{c3f}స\u{c4d}క\u{c4d}",
                "మ\u{c3f}న\u{c40}డ\u{c3f}స\u{c4d}క\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("диски компютер"),
            keywords: &["диск", "диски компютер", "компютер", "минидиск", "оптикӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แผ\u{e48}นด\u{e34}สก\u{e4c}"),
            keywords: &[
                "คอมพ\u{e34}วเตอร\u{e4c}",
                "ด\u{e34}สก\u{e4c}",
                "แผ\u{e48}นด\u{e34}สก\u{e4c}",
                "แผ\u{e48}นด\u{e34}สก\u{e4c}ขนาดเล\u{e47}ก",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kompýuter diski"),
            keywords: &[
                "disk",
                "kompýuter",
                "kompýuter diski",
                "mini disk",
                "optiki",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tisi fefeka"),
            keywords: &["tisi fefeka"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("mini disk"),
            keywords: &["disk", "mini disk"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كومپيۇتېر دىسكىسى"),
            keywords: &[
                "دىسكا",
                "كومپيۇتېر",
                "كومپيۇتېر دىسكىسى",
                "كىچىك دىسكا",
                "نۇر",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("міні-диск"),
            keywords: &["диск", "комп’ютер", "міні-диск", "оптичний"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کمپیوٹر ڈسک"),
            keywords: &["منی", "ڈسک", "کمپیوٹر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("mini-disk"),
            keywords: &["disk", "kompyuter", "mini-disk", "optika"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đĩa máy tính"),
            keywords: &["máy tính", "quang học", "đĩa", "đĩa mini", "đĩa máy tính"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("disku ordi"),
            keywords: &[
                "bu-optik",
                "disk",
                "disk bu ndaw",
                "disku ordi",
                "ordinatër",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("idiski yekhompyutha"),
            keywords: &[
                "idiski",
                "idiski encinane",
                "idiski yekhompyutha",
                "ikhomyutha",
                "yeliso",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("dísìkì kọ\u{300}ǹpútà"),
            keywords: &[
                "dísìkì kọ\u{300}ǹpútà",
                "kọ\u{300}npútà",
                "ojú àwo",
                "àwo",
                "àwo pélébé",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("電腦光碟"),
            keywords: &["光學", "光碟", "迷你光碟", "電腦", "電腦光碟"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("电脑光碟"),
            keywords: &["光学", "光碟", "电脑", "电脑光碟", "迷你光碟"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("电脑光盘"),
            keywords: &[
                "minidisk",
                "mini光盘",
                "光盘",
                "电脑光盘",
                "迷你光碟",
                "迷你唱片",
            ],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("迷你光碟"),
            keywords: &["迷你光碟"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("idiski encane"),
            keywords: &["idiski", "idiski encane", "ikhompyutha"],
        },
    ],
};
#[doc = "💾"]
pub const FLOPPY_DISK: crate::Emoji = crate::Emoji {
    glyph: "💾",
    codepoint: "1F4BE",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "floppy disk",
    group: "Objects",
    subgroup: "computer",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("slapskyf"),
            keywords: &["disket", "rekenaar", "skyf", "slap", "slapskyf"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ፍሎፒ ዲስክ"),
            keywords: &["ኮምፒውተር", "ዲስክ", "ፍሎፒ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قرص مرن"),
            keywords: &["فلوبي", "قرص", "قرص مرن"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ফ\u{9cd}লপী ডিস\u{9cd}ক"),
            keywords: &["কম\u{9cd}পিউট\u{9be}ৰ", "ডিস\u{9cd}ক", "ফ\u{9cd}লপী"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("çevik disk"),
            keywords: &["disk", "kompüter", "çevik"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("дыскета"),
            keywords: &["гібкі", "дыск", "дыскета", "камп’ютар", "носьбіт"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("дискета"),
            keywords: &["диск", "дискета", "компютър"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ফ\u{9cd}লপি ডিস\u{9cd}ক"),
            keywords: &["কম\u{9cd}পিউট\u{9be}র", "ডিস\u{9cd}ক", "ফ\u{9cd}লপি"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pladennig"),
            keywords: &["pladennig", "urzhiater"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("disketa"),
            keywords: &["disk", "disketa", "floppy"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("disquet"),
            keywords: &["disc", "disquet", "equip"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄜\u{11133}𑄣\u{11127}𑄛\u{11128} 𑄓\u{11128}𑄌\u{11134}𑄇\u{11134}"),
            keywords: &["𑄜\u{11133}𑄣\u{11127}𑄛\u{11128} 𑄓\u{11128}𑄌\u{11134}𑄇\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏩᏂᎨ ᎠᏠᏗ"),
            keywords: &["ᎠᎦᏙᎥᎯᏍᏗᏍᎩ ᎠᏍᏆᏂᎪᏗᏍᎩ", "ᎠᏠᏗ", "ᏩᏂᎨ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("disketa"),
            keywords: &["disk", "disketa", "počítač"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("disg hyblyg"),
            keywords: &["cyfrifiadur", "disg", "hyblyg"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("diskette"),
            keywords: &["computer", "diskette"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Diskette"),
            keywords: &["Datenträger", "Diskette"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("δισκέτα"),
            keywords: &["δίσκος", "δισκέτα", "υπολογιστής"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("floppy disk"),
            keywords: &["computer", "disk", "floppy"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["computer", "disk", "diskette", "floppy"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["computer", "disk", "diskette", "floppy"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("disquete"),
            keywords: &["disco", "disco de 3 1/2", "disquete"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["disco", "diskette", "disquete", "floppy"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("diskett"),
            keywords: &["arvuti", "diskett", "ketas"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("disketea"),
            keywords: &["diskete", "disketea", "disko", "ordenagailu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("فلاپی دیسک"),
            keywords: &["دیسک", "رایانه", "فلاپی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("disketti"),
            keywords: &["disketti", "korppu", "levyke", "tietokone"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("floppy disk"),
            keywords: &["computer", "disk", "floppy"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("diskil"),
            keywords: &["disketta", "diskil"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("disquette"),
            keywords: &["disque", "disquette", "ordinateur"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("diosca bog"),
            keywords: &["bog", "diosca"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("diosg bog"),
            keywords: &["bog", "coimpiutair", "diosg", "floppy"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("disquete"),
            keywords: &["disquete", "disqueteira", "ordenador"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ફ\u{acd}લોપી ડિસ\u{acd}ક"),
            keywords: &["ડિસ\u{acd}ક", "ફ\u{acd}લોપી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("diski na floppy"),
            keywords: &["diski", "diski na floppy", "kwamfuta", "na floppy"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("דיסקט"),
            keywords: &["דיסקט", "מחשב", "פלופי"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("फ\u{93c}\u{94d}लॉपी डिस\u{94d}क"),
            keywords: &[
                "क\u{902}प\u{94d}य\u{942}टर",
                "डिस\u{94d}क",
                "फ\u{93c}\u{94d}लॉपी",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("disketa"),
            keywords: &["disk", "disketa", "računalo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("floppylemez"),
            keywords: &[
                "floppy",
                "floppylemez",
                "hajlékonylemez",
                "lemez",
                "számítógép",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ֆլոպի սկավառակ"),
            keywords: &["համակարգիչ", "սկավառակ", "ֆլոպի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("disket"),
            keywords: &["disk", "disket", "komputer"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("flọpi diiski"),
            keywords: &["diiski", "flọpi", "kọmpụta"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("disketta"),
            keywords: &["disketta", "diskur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("floppy disc"),
            keywords: &["disc", "floppy"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("フロッピー"),
            keywords: &["FD", "コンピューター", "ディスク", "フロッピー"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("disket flopi"),
            keywords: &["disket", "flopi", "komputer"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დრეკადი დისკი"),
            keywords: &["დისკი", "დრეკადი", "კომპიუტერი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("алмалы диск"),
            keywords: &["алмалы диск", "диск", "компьютер"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("diskette"),
            keywords: &["computer", "diskette"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ឌ\u{17b8}សប\u{17bd}នជ\u{17d2}រ\u{17bb}ងរក\u{17d2}សាទ\u{17bb}កឯកសារ (ហ\u{17bd}សសម\u{17d0}យ)",
            ),
            keywords: &[
                "ក\u{17bb}\u{17c6}ព\u{17d2}យ\u{17bc}ទ\u{17d0}រ",
                "ឌ\u{17b8}ស",
                "ឌ\u{17b8}សជ\u{17d2}រ\u{17bb}ង",
                "ឌ\u{17b8}សប\u{17bd}នជ\u{17d2}រ\u{17bb}ងរក\u{17d2}សាទ\u{17bb}កឯកសារ (ហ\u{17bd}សសម\u{17d0}យ)",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಫ\u{ccd}ಲಾಪ\u{cbf} ಡ\u{cbf}ಸ\u{ccd}ಕ\u{ccd}"),
            keywords: &["ಡ\u{cbf}ಸ\u{ccd}ಕ\u{ccd}", "ಫ\u{ccd}ಲಾಪ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("플로피 디스크"),
            keywords: &["디스켓", "플로피 디스크"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("फ\u{94d}लॉपी डिस\u{94d}क"),
            keywords: &["डिस\u{94d}क", "फ\u{94d}लॉपी", "स\u{902}गणक"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("дискета"),
            keywords: &["диск", "дискета", "компьютер"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Diskett"),
            keywords: &["Computer", "Disk", "Diskett"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຟລ\u{eb1}ອບປ\u{eb5}\u{ec9}ດ\u{eb4}ສ"),
            keywords: &[
                "ດ\u{eb4}ສ",
                "ຟລ\u{eb1}ອບປ\u{eb5}\u{ec9}",
                "ຟລ\u{eb1}ອບປ\u{eb5}\u{ec9}ດ\u{eb4}ສ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("diskelis"),
            keywords: &["diskas", "diskelis", "kompiuteris"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("diskete"),
            keywords: &["dators", "diskete"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kōpae pīngore"),
            keywords: &["kōpae", "pīngore", "rorohiko"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("дискета"),
            keywords: &["дискета", "компјутер", "хардвер"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഫ\u{d4d}ലോപ\u{d4d}പി ഡിസ\u{d4d}ക\u{d4d}ക\u{d4d}"),
            keywords: &["ഡിസ\u{d4d}ക\u{d4d}ക\u{d4d}", "ഫ\u{d4d}ലോപ\u{d4d}പി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("уян диск"),
            keywords: &["диск", "компьютер", "уян"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("फ\u{94d}लॉपी डिस\u{94d}क"),
            keywords: &["डिस\u{94d}क", "फ\u{94d}लॉपी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("cakera liut"),
            keywords: &["cakera", "komputer", "liut"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("diskett"),
            keywords: &["diska", "diskett", "floppy", "kompjuter"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဖလော\u{103a}ပ\u{102e}ဒစ\u{103a}"),
            keywords: &[
                "က\u{103d}န\u{103a}ပျ\u{1030}တာ",
                "ဒစ\u{103a}ခ\u{103a}",
                "ဖလော\u{103a}ပ\u{102e}",
                "ဖလော\u{103a}ပ\u{102e}ဒစ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("diskett"),
            keywords: &["datamaskin", "disk", "diskett", "lagring"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("फ\u{94d}लपी डिस\u{94d}क"),
            keywords: &["कम\u{94d}प\u{94d}य\u{941}टर", "डिस\u{94d}क", "फ\u{94d}लपी"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("floppydisk"),
            keywords: &["disk", "diskette", "floppy", "floppydisk"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("diskett"),
            keywords: &["datamaskin", "disk", "diskett", "lagring"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଫ\u{b4d}ଲପ\u{b3f} ଡ\u{b3f}ସ\u{b4d}କ\u{b4d}"),
            keywords: &[
                "ଡ\u{b3f}ସ\u{b4d}କ\u{b4d}",
                "ଫ\u{b4d}ଲପ\u{b3f}",
                "ଫ\u{b4d}ଲପ\u{b3f} ଡ\u{b3f}ସ\u{b4d}କ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਫਲ\u{a4c}ਪੀ ਡਿਸਕ"),
            keywords: &["ਡਿਸਕ", "ਫਲਾਪੀ", "ਫਲ\u{a4c}ਪੀ ਡਿਸਕ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("فلاپی ڈسک"),
            keywords: &["فلاپی", "ڈسک", "کمپیوٹر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Flọ\u{301}pí Disk"),
            keywords: &["Disk", "Flọ\u{301}pí", "Kọmpúta"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("dyskietka"),
            keywords: &["dyskietka", "komputerowa", "miękki dysk"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("فلاپي ډیسک"),
            keywords: &["فلاپي", "فلاپي ډیسک", "ډسک", "کمپيوټر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("disquete"),
            keywords: &["computador", "disco", "disco flexível", "disquete"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["computador", "disquete", "floppy"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("disquete"),
            keywords: &["disquete"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("dischetă"),
            keywords: &["computer", "dischetă", "floppy", "stocare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-635"),
            keywords: &["E10-635"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("дискета"),
            keywords: &["данные", "дискета", "компьютер", "носитель"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("disikete"),
            keywords: &["disike", "disikete", "folopi disiki", "mudasobwa"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("فلاپي ڊسڪ"),
            keywords: &["فلاپي", "ڊسڪ", "ڪمپيوٽر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dd4}නම\u{dca}\u{200d}ය තැට\u{dd2}ය"),
            keywords: &["තැට\u{dd2}ය", "පර\u{dd2}ගණකය", "ස\u{dd4}නම\u{dca}\u{200d}ය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("disketa"),
            keywords: &["disk", "disketa", "počítač"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("disketa"),
            keywords: &["disk", "disketa", "računalnik"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("cajalada faloobida"),
            keywords: &["cajalad", "cajalada faloobida", "faloobi", "koombuyuutar"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("disketë"),
            keywords: &["disk", "disketë", "kompjuter"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("дискета"),
            keywords: &["диск", "дискета", "рачунар"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["дискета"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("disketa"),
            keywords: &["disk", "disketa", "računar"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["disketa"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("diskett"),
            keywords: &["dator", "diskett"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("diski laini"),
            keywords: &["diski", "diski laini", "kompyuta"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பிள\u{bbe}ப\u{bcd}பி டிஸ\u{bcd}க\u{bcd}"),
            keywords: &["டிஸ\u{bcd}க\u{bcd}", "பிள\u{bbe}ப\u{bcd}பி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఫ\u{c4d}ల\u{c3e}ప\u{c40} డ\u{c3f}స\u{c4d}క\u{c4d}"),
            keywords: &[
                "కంప\u{c4d}యూటర\u{c4d}",
                "డ\u{c3f}స\u{c4d}క\u{c4d}",
                "ఫ\u{c4d}ల\u{c3e}ప\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("диски нарм"),
            keywords: &["диск", "диски нарм", "компютер", "нарм"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ฟลอปป\u{e35}\u{e49}ด\u{e34}สก\u{e4c}"),
            keywords: &[
                "ด\u{e34}สก\u{e4c}",
                "ฟลอปป\u{e35}\u{e49}",
                "ฟลอปป\u{e35}\u{e49}ด\u{e34}สก\u{e4c}",
                "แผ\u{e48}นบ\u{e31}นท\u{e36}ก",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çeýe disk"),
            keywords: &["disk", "kompýuter", "çeýe"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tisi molū"),
            keywords: &["tisi molū"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("disket"),
            keywords: &["disket", "floppy"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يۇمشاق دىسكا"),
            keywords: &["دىسكا", "كومپيۇتېر", "يۇمشاق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("дискета"),
            keywords: &["диск", "дискета", "комп’ютер"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("فلاپی ڈسک"),
            keywords: &["فلاپی", "ڈسک", "کمپیوٹر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("disketa"),
            keywords: &["disk", "disketa", "kompyuter", "yumshoq disk"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đĩa mềm"),
            keywords: &["máy tính", "mềm", "đĩa"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("disket"),
            keywords: &["disk", "disket", "ordinatër"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("idiski ye-floppy"),
            keywords: &["i-floppy", "idiski", "idiski ye-floppy", "ikhompyutha"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("dísìkì fílọ\u{300}pì"),
            keywords: &[
                "dísìkì fílọ\u{300}pì",
                "fíló\u{329}pì",
                "kọ\u{300}npútà",
                "àwo",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("磁碟"),
            keywords: &["光碟", "磁碟", "軟", "電腦"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("磁碟"),
            keywords: &["光碟", "电脑", "磁碟", "软"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("软盘"),
            keywords: &["3.5英寸", "便携", "存储", "磁盘", "软盘"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("磁碟片"),
            keywords: &["磁碟片"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("磁碟"),
            keywords: &["磁碟"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-floppy diski"),
            keywords: &["i-floppy", "i-floppy diski", "idiski", "ikhompyutha"],
        },
    ],
};
#[doc = "💿"]
pub const OPTICAL_DISK: crate::Emoji = crate::Emoji {
    glyph: "💿",
    codepoint: "1F4BF",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "optical disk",
    group: "Objects",
    subgroup: "computer",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("optiese skyf"),
            keywords: &[
                "blu-ray",
                "cd",
                "dvd",
                "opties",
                "optiese skyf",
                "rekenaar",
                "skyf",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ኦፕቲካል ዲስክ"),
            keywords: &["ሲዲ", "ኦፕቲካል", "ኮምፒውተር", "ዲስክ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سي دي"),
            keywords: &["دي في دي", "سي دي", "قرص", "قرص ضوئي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("অপ\u{9cd}টিকেল ডিস\u{9cd}ক"),
            keywords: &[
                "অপ\u{9cd}টিকেল",
                "ক\u{9be}ম\u{9cd}পিউট\u{9be}ৰ",
                "চিডি",
                "ডিস\u{9cd}ক",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("optik disk"),
            keywords: &["blu-rey", "cd", "disk", "dvd", "kompüter", "optik"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("аптычны дыск"),
            keywords: &[
                "CD",
                "аптычны",
                "аптычны дыск",
                "кампакт-дыск",
                "камп’ютар",
                "носьбіт",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Оптичен диск"),
            keywords: &[
                "[blu-ray]",
                "[cd]",
                "[dvd]",
                "Оптичен диск",
                "диск",
                "оптичен",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("অপ\u{9cd}টিক\u{9cd}য\u{9be}ল ডিস\u{9cd}ক"),
            keywords: &[
                "অপটিক\u{9cd}য\u{9be}ল",
                "অপ\u{9cd}টিক\u{9cd}য\u{9be}ল ডিস\u{9cd}ক",
                "ডিস\u{9cd}ক",
                "সিডি । কম\u{9cd}পিউট\u{9be}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("CD"),
            keywords: &["CD", "pladenn", "urzhiater"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("cd"),
            keywords: &["blu-ray", "cd", "disk", "optički", "računar"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("disc òptic"),
            keywords: &["cd", "disc", "dvd", "equip", "ordinador", "òptic"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some(
                "𑄃\u{11127}𑄛\u{11134}𑄑\u{11128}𑄇\u{11133}𑄠𑄣\u{11134} 𑄓\u{11128}𑄌\u{11134}𑄇\u{11134}",
            ),
            keywords: &[
                "𑄃\u{11127}𑄛\u{11134}𑄑\u{11128}𑄇\u{11133}𑄠𑄣\u{11134} 𑄓\u{11128}𑄌\u{11134}𑄇\u{11134}",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎪᏩᏛᏗ ᎠᏠᏗ"),
            keywords: &["cd", "ᎠᎦᏙᎥᎯᏍᏗ ᎠᏍᏆᏂᎪᏗᏍᎩ", "ᎠᎪᏩᏛᏗ", "ᎠᏠᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("optický disk"),
            keywords: &[
                "bd",
                "blu-ray",
                "blue-ray",
                "cd",
                "disk",
                "dvd",
                "optické",
                "optický",
                "počítač",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("disg optegol"),
            keywords: &[
                "blu-ray",
                "cd",
                "computer",
                "disg optegol",
                "disk",
                "dvd",
                "optical",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("cd"),
            keywords: &["cd", "dvd"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("CD"),
            keywords: &["Blu-Ray", "CD", "DVD"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("οπτικός δίσκος"),
            keywords: &["blu-ray", "cd", "dvd", "δίσκος", "οπτικός", "υπολογιστής"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("optical disk"),
            keywords: &["cd", "computer", "disk", "optical"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["CD", "computer", "disk", "optical"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("disco óptico"),
            keywords: &["cd", "disco", "disco óptico"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["Blu-ray", "CD", "DVD", "disco", "óptico"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("optiline ketas"),
            keywords: &["CD", "DVD", "arvuti", "ketas", "optiline"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("disko optikoa"),
            keywords: &[
                "blu-ray",
                "cd",
                "disko",
                "disko optikoa",
                "dvd",
                "optiko",
                "ordenagailu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("سی\u{200c}دی"),
            keywords: &[
                "بلوری",
                "دیسک",
                "دی\u{200c}وی\u{200c}دی",
                "رایانه",
                "سی\u{200c}دی",
                "لوح فشرده",
                "نوری",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("CD"),
            keywords: &["CD", "blu-ray", "dvd", "levy", "tietokone"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("optical disc"),
            keywords: &["cd", "computer", "disk", "optical disc", "optikal"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sjónbandsfløga"),
            keywords: &["cd", "diskur", "sjónbandsfløga"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("CD"),
            keywords: &["CD", "disque"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["CD", "disque", "ordinateur"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("diosca optúil"),
            keywords: &["DVD", "blu-ray", "diosca", "diosca optúil"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("diosg optaigeach"),
            keywords: &["cd", "coimpiutair", "diosg", "lèirsinneach", "optaigeach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("CD"),
            keywords: &["CD", "disco", "ordenador"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઑપ\u{acd}ટિકલ ડિસ\u{acd}ક"),
            keywords: &[
                "ઑપ\u{acd}ટિકલ",
                "કમ\u{acd}પ\u{acd}ય\u{ac1}ટર",
                "ડિસ\u{acd}ક",
                "સીડી",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("diski na da’ira"),
            keywords: &["cd", "diski", "diski na da’ira", "kwamfuta", "na da’ira"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("דיסק אופטי"),
            keywords: &["אופטי", "דיסק", "מחשב", "תקליטור"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ऑप\u{94d}टिकल डिस\u{94d}क"),
            keywords: &[
                "ऑप\u{94d}टिकल",
                "क\u{902}प\u{94d}य\u{942}टर",
                "डिस\u{94d}क",
                "सीडी",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("optički disk"),
            keywords: &["cd", "disk", "optički", "računalo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("optikai lemez"),
            keywords: &["blu-ray", "dvd", "lemez", "optikai", "számítógép"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("օպտիկական սկավառակ"),
            keywords: &[
                "blu-ray",
                "cd",
                "dvd",
                "համակարգիչ",
                "սկավառակ",
                "օպտիկական",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("disk optik"),
            keywords: &["cd", "disk", "komputer", "optik"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("diiski ọptịkal"),
            keywords: &["cd", "diiski", "kọmpụta", "ọptịkal"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("blu-ray"),
            keywords: &["blu-ray", "diskur", "geisladiskur", "tölva"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("disco ottico"),
            keywords: &["CD", "DVD", "blu-ray", "disco", "disco ottico"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("CD"),
            keywords: &["Blu-ray", "CD", "DVD", "ディスク", "ブルーレイ"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("cakram optikal"),
            keywords: &["cakram", "cd", "komputer", "optikal"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ოპტიკური დისკი"),
            keywords: &["blu-ray", "cd", "dvd", "დისკი", "კომპიუტერი", "ოპტიკური"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("оптикалық диск"),
            keywords: &["диск", "компьютер", "оптикалық", "шағын диск"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("cd"),
            keywords: &["cd", "dvd"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ឌ\u{17b8}សឡាស\u{17ca}ែរ"),
            keywords: &[
                "ក\u{17bb}\u{17c6}ព\u{17d2}យ\u{17bc}ទ\u{17d0}រ",
                "ឌ\u{17b8}ស",
                "ឌ\u{17b8}សឡាស\u{17ca}ែរ",
                "ស\u{17ca}\u{17b8}ឌ\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಆಪ\u{ccd} ಡ\u{cbf}ಸ\u{ccd}ಕ\u{ccd}"),
            keywords: &[
                "ಆಪ\u{ccd} ಡ\u{cbf}ಸ\u{ccd}ಕ\u{ccd}",
                "ಆಪ\u{ccd}ಟ\u{cbf}ಕಲ\u{ccd}",
                "ಕಂಪ\u{ccd}ಯ\u{cc2}ಟರ\u{ccd}",
                "ಡ\u{cbf}ಸ\u{ccd}ಕ\u{ccd}",
                "ಸ\u{cbf}ಡ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("씨디"),
            keywords: &["CD", "DVD", "광학 디스크", "디비디", "블루레이", "씨디"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ऑप\u{94d}टिकल डिस\u{94d}क"),
            keywords: &[
                "ऑप\u{94d}टिकल डिस\u{94d}क",
                "ऑप\u{94d}टीकल",
                "डिस\u{94d}क",
                "स\u{902}गणक",
                "सीडी",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("оптикалык диск"),
            keywords: &["blu-ray", "cd", "dvd", "диск", "компьютер", "оптикалык"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("CD"),
            keywords: &["CD", "Computer", "Disk", "optesch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ອ\u{eb1}ອບຕ\u{eb5}ໂຄດ\u{eb4}ສ"),
            keywords: &[
                "ດ\u{eb4}ສ",
                "ອ\u{eb1}ອບຕ\u{eb5}ໂຄ",
                "ອ\u{eb1}ອບຕ\u{eb5}ໂຄດ\u{eb4}ສ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("optinis diskas"),
            keywords: &[
                "CD",
                "diskas",
                "kompaktinis diskas",
                "kompiuteris",
                "optinis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("optiskais disks"),
            keywords: &["CD", "dators", "kompaktdisks", "optiskais disks"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kōpae whatu"),
            keywords: &["kōpae", "kōpaepae", "rorohiko", "whatu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("цд"),
            keywords: &["компјутер", "хардвер", "цд"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഒപ\u{d4d}റ\u{d4d}റിക\u{d4d}കൽ ഡിസ\u{d4d}ക\u{d4d}"),
            keywords: &[
                "ഒപ\u{d4d}റ\u{d4d}റിക\u{d4d}കൽ ഡിസ\u{d4d}ക\u{d4d}",
                "ഒപ\u{d4d}റ\u{d4d}റിക\u{d4d}കൽ ഡിസ\u{d4d}ക\u{d4d}ക\u{d4d}",
                "ഡിവിഡി",
                "ഡിസ\u{d4d}ക\u{d4d}ക\u{d4d}",
                "ബ\u{d4d}ല\u{d42}-റേ",
                "സിഡി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("оптик диск"),
            keywords: &["cd", "диск", "компьютер", "оптик диск", "оптикал"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ऑप\u{94d}टिकल डिस\u{94d}क"),
            keywords: &[
                "ऑप\u{94d}टिकल डिस\u{94d}क",
                "डिस\u{94d}क",
                "डीव\u{94d}हीडी",
                "ब\u{94d}ल\u{94d}य\u{942}-र\u{947}",
                "सीडी",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("cakera optik"),
            keywords: &["cakera", "cd", "komputer", "optik"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("diska ottika"),
            keywords: &["cd", "diska", "diska ottika", "kompjuter", "ottiċi"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အလင\u{103a}းသ\u{102f}\u{1036}းဒစ\u{103a}"),
            keywords: &[
                "က\u{103d}န\u{103a}ပျ\u{1030}တာ",
                "စ\u{102e}ဒ\u{102e}",
                "ဒစ\u{103a}ခ\u{103a}",
                "အလင\u{103a}းသ\u{102f}\u{1036}းဒစ\u{103a}",
                "အော\u{1037}ပ\u{103a}တစ\u{103a}ကယ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("optisk plate"),
            keywords: &["CD", "DVD", "blu-ray", "disk", "lagring", "optisk plate"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("अप\u{94d}टिकल डिस\u{94d}क"),
            keywords: &[
                "अप\u{94d}टिकल",
                "कम\u{94d}प\u{94d}य\u{941}टर",
                "डिस\u{94d}क",
                "सिडी",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("optische schijf"),
            keywords: &["cd", "computer", "optisch", "optische schijf", "schijf"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("optisk plate"),
            keywords: &["CD", "DVD", "blu-ray", "disk", "lagring", "optisk plate"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଅପ\u{b4d}ଟ\u{b3f}କ\u{b3e}ଲ\u{b4d}\u{200c} ଡ\u{b3f}ସ\u{b4d}କ\u{b4d}"),
            keywords: &[
                "ଅପ\u{b4d}ଟ\u{b3f}କ\u{b3e}ଲ\u{b4d}\u{200c} ଡ\u{b3f}ସ\u{b4d}କ",
                "ଅପ\u{b4d}ଟ\u{b3f}କ\u{b3e}ଲ\u{b4d}\u{200c} ଡ\u{b3f}ସ\u{b4d}କ\u{b4d}",
                "ଡ\u{b3f}ଭ\u{b3f}ଡ\u{b3f}",
                "ଡ\u{b3f}ସ\u{b4d}କ\u{b4d}",
                "ବ\u{b4d}ଲ\u{b41}-ରେ",
                "ସ\u{b3f}ଡ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬਲ\u{a42}-ਰ\u{a47} ਡਿਸਕ"),
            keywords: &[
                "ਆਪਟੀਕਲ ਡਿਸਕ",
                "ਡਿਸਕ",
                "ਡੀਵੀਡੀ",
                "ਬਲ\u{a42}-ਰ\u{a47}",
                "ਸੀਡੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("آپٹیکل ڈسک"),
            keywords: &["cd", "آپٹیکل ڈسک", "بصریات", "ڈسک", "کمپیوٹر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ọ\u{301}ptíkál Disk"),
            keywords: &[
                "CD",
                "Disk",
                "Kọmpúta",
                "Ọ\u{301}ptíkal",
                "Ọ\u{301}ptíkál Disk",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("dysk optyczny"),
            keywords: &["Blu-ray", "CD", "DVD", "dysk", "dysk optyczny"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("آپتيکي ډسک"),
            keywords: &["آپتيکي", "سي ډې", "ډسک", "کمپيوټر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cd"),
            keywords: &["cd", "computador", "disco", "óptico"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("disco ótico"),
            keywords: &["cd", "computador", "disco", "óptico", "ótico"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("disku"),
            keywords: &["cd", "computadora", "disku", "optico", "ruyru"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cd"),
            keywords: &["cd", "computer", "disc", "unitate optică"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-636"),
            keywords: &["E10-636"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("CD"),
            keywords: &[
                "CD",
                "cd",
                "диск",
                "компакт",
                "компакт-диск",
                "сиди",
                "формат",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("disiki"),
            keywords: &["cd", "disiki", "kijyanye no kureba", "mudasobwa"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("آپٽيڪل ڊسڪ"),
            keywords: &["آپٽيڪل", "سي ڊي", "ڊسڪ", "ڪمپيوٽر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dca}\u{200d}රක\u{dcf}ශ තැට\u{dd2}ය"),
            keywords: &[
                "ඩ\u{dd3}ව\u{dd3}ඩ\u{dd3}",
                "තැට\u{dd2}ය",
                "පර\u{dd2}ගණකය",
                "ප\u{dca}\u{200d}රක\u{dcf}ශ තැට\u{dd2}ය",
                "බ\u{dca}ල\u{dd6} රේ",
                "ස\u{dd3}ඩ\u{dd3}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("optický disk"),
            keywords: &["cd", "dvd", "optický disk", "počítač"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("optični disk"),
            keywords: &[
                "blu-ray",
                "cd",
                "disk",
                "dvd",
                "optični disk",
                "optično",
                "računalnik",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("cajalada obtikaalka ah"),
            keywords: &[
                "cajalad",
                "cajalada obtikaalka ah",
                "cd",
                "koombuyuutar",
                "obtikaal",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("disk optik"),
            keywords: &["cd", "disk", "kompjuter", "optik"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("оптички диск"),
            keywords: &["cd", "диск", "оптички", "рачунар"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["оптички диск"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("optički disk"),
            keywords: &["cd", "disk", "optički", "računar"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["optički disk"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("optisk skiva"),
            keywords: &["bluray-skiva", "cd-skiva", "dvd-skiva", "optisk skiva"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("diski"),
            keywords: &["blu-ray", "cd", "diski", "dvd", "kompyuta", "ya macho"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("diski ya kutumia mwangaza"),
            keywords: &[
                "blu-ray",
                "cd",
                "diski",
                "diski ya kutumia mwangaza",
                "dvd",
                "kompyuta",
                "mwangaza",
            ],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆப\u{bcd}டிகல\u{bcd} டிஸ\u{bcd}க\u{bcd}"),
            keywords: &[
                "ஆப\u{bcd}டிகல\u{bcd} டிஸ\u{bcd}க\u{bcd}",
                "சிடி",
                "டிவிடி",
                "டிஸ\u{bcd}க\u{bcd}",
                "ப\u{bcd}ளூ-ரே",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఆప\u{c4d}ట\u{c3f}కల\u{c4d} డ\u{c3f}స\u{c4d}క\u{c4d}"),
            keywords: &[
                "ఆప\u{c4d}ట\u{c3f}కల\u{c4d} డ\u{c3f}స\u{c4d}క\u{c4d}",
                "స\u{c3f}డ\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("диски оптикӣ"),
            keywords: &["cd", "диск", "диски оптикӣ", "компютер", "оптикӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("บล\u{e39}เรย\u{e4c}"),
            keywords: &[
                "ซ\u{e35}ด\u{e35}",
                "ด\u{e35}ว\u{e35}ด\u{e35}",
                "บล\u{e39}เรย\u{e4c}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("optiki disk"),
            keywords: &["cd", "disk", "kompýuter", "optiki"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tisi mamata"),
            keywords: &["tisi mamata"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("optik disk"),
            keywords: &["CD", "DVD", "disk", "optik disk"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("نۇر دىسكا"),
            keywords: &["cd", "دىسكا", "كومپيۇتېر", "نۇر"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("компакт-диск"),
            keywords: &[
                "blu-ray",
                "cd",
                "dvd",
                "диск",
                "компакт-диск",
                "комп’ютер",
                "оптичний",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("آپٹکل ڈسک"),
            keywords: &["آپٹکل", "ڈسک", "کمپیوٹر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("optik disk"),
            keywords: &["blu-ray", "cd", "disk", "dvd", "kompyuter", "optik"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đĩa quang"),
            keywords: &["cd", "máy tính", "quang", "đĩa"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("disk optik"),
            keywords: &["bu-optik", "cd", "disk", "disk optik", "ordinatër"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("idiksi yeliso"),
            keywords: &["i-cd", "idiksi yeliso", "idiski", "ikhomyutha", "yeliso"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àwo aká-ọ\u{300}rọ\u{300} aláfojúrí"),
            keywords: &[
                "kọ\u{300}npútà",
                "ojú àwo",
                "àwo",
                "àwo aká-ọ\u{300}rọ\u{300} aláfojúrí",
                "àwo ìgbàlódé",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("光碟"),
            keywords: &["光學", "光碟", "電腦"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("光碟"),
            keywords: &["光学", "光碟", "电脑"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("光盘"),
            keywords: &["cd", "专辑", "光盘", "存储", "影片", "音乐"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("光碟"),
            keywords: &["CD", "光碟"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isidi"),
            keywords: &["blu-ray", "i-dvd", "idiski", "ikhompyutha", "isidi"],
        },
    ],
};
#[doc = "📀"]
pub const DVD: crate::Emoji = crate::Emoji {
    glyph: "📀",
    codepoint: "1F4C0",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "dvd",
    group: "Objects",
    subgroup: "computer",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("dvd"),
            keywords: &["blu-ray", "cd", "dvd", "opties", "rekenaar", "skyf"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ዲቪዲ"),
            keywords: &["ሉ-ሬይ", "ኦፕቲካል", "ኮምፒውተር", "ዲስክ", "ዲቪዲ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قرص Dvd"),
            keywords: &["قرص", "قرص Dvd", "قرص دي في دي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ডিভিডি"),
            keywords: &[
                "অপ\u{9cd}টিকেল",
                "ক\u{9be}ম\u{9cd}পিউট\u{9be}ৰ",
                "ডিভিডি",
                "ডিস\u{9cd}ক",
                "ব\u{9cd}ল\u{9c1}-ৰে",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("dvd"),
            keywords: &["blu-rey", "cd", "disk", "dvd", "kompüter", "optik"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("DVD"),
            keywords: &[
                "DVD",
                "blu-ray",
                "аптычны",
                "блюрэй",
                "кампакт-дыск",
                "камп’ютар",
                "носьбіт",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("[DVD]"),
            keywords: &["[DVD]", "[blu-ray]", "[dvd]", "диск", "компютър", "оптичен"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ডিভিডি"),
            keywords: &[
                "অপটিক\u{9cd}য\u{9be}ল",
                "কম\u{9cd}পিউট\u{9be}র",
                "ডিভিডি",
                "ডিস\u{9cd}ক",
                "নীল রশ\u{9cd}মি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("DVD"),
            keywords: &["DVD", "pladenn", "urzhiater"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("dvd"),
            keywords: &["blu-ray", "disk", "dvd", "optički", "računar"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("DVD"),
            keywords: &[
                "Blu-ray",
                "DVD",
                "cd",
                "disc",
                "equip",
                "ordinador",
                "òptic",
            ],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄓\u{11128}𑄞\u{11128}𑄓\u{11128}"),
            keywords: &["𑄓\u{11128}𑄞\u{11128}𑄓\u{11128}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("dvd"),
            keywords: &["blu-ray", "dvd", "ᎠᎦᏙᎥᎯᏍᏗ ᎠᏍᏆᏂᎪᏗᏍᎩ", "ᎠᎪᏩᏛᏗ", "ᎠᏠᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("dvd"),
            keywords: &[
                "bd",
                "blu-ray",
                "blue-ray",
                "cd",
                "disk",
                "dvd",
                "optické",
                "optický",
                "počítač",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dvd"),
            keywords: &["blu-ray", "cd", "cyfrifiadur", "disg", "dvd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("dvd"),
            keywords: &["blu-ray", "cd", "computer", "disk", "dvd", "optisk"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("DVD"),
            keywords: &["CD", "DVD"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("dvd"),
            keywords: &["blu-ray", "cd", "dvd", "δίσκος", "οπτικός", "υπολογιστής"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("dvd"),
            keywords: &["blu-ray", "computer", "disk", "dvd", "optical"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("DVD"),
            keywords: &["DVD", "blu-ray", "computer", "disk", "dvd", "optical"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("disco DVD"),
            keywords: &["disco", "disco DVD", "dvd"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("DVD"),
            keywords: &["DVD", "disco"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["DVD", "blu-ray", "computadora", "disco", "óptico"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("DVD"),
            keywords: &["DVD", "arvuti", "blu-ray", "ketas", "optiline"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("DVD"),
            keywords: &["DVD", "blu-ray", "cd", "disko", "optiko", "ordenagailu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دی\u{200c}وی\u{200c}دی"),
            keywords: &[
                "بلوری",
                "دیسک",
                "دی\u{200c}وی\u{200c}دی",
                "رایانه",
                "سی\u{200c}دی",
                "نوری",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("DVD"),
            keywords: &["DVD", "blu-ray", "cd", "levy", "tietokone"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("dvd"),
            keywords: &["blu-ray", "computer", "disk", "dvd", "optikal"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("margfløga"),
            keywords: &["blu-ray", "diskur", "dvd", "margfløga"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("DVD"),
            keywords: &["DVD", "disque"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["DVD", "blu-ray", "disque", "ordinateur"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("DVD"),
            keywords: &["DVD", "diosca"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("DVD"),
            keywords: &[
                "DVD",
                "blu-ray",
                "coimpiutair",
                "diosg",
                "dvd",
                "lèirsinneach",
                "optaigeach",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("DVD"),
            keywords: &["DVD", "disco", "ordenador"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ડીવીડી"),
            keywords: &[
                "ઑપ\u{acd}ટિકલ",
                "કમ\u{acd}પ\u{acd}ય\u{ac1}ટર",
                "ડિસ\u{acd}ક",
                "ડીવીડી",
                "બ\u{acd}લ\u{ac1}-ર\u{ac7}",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("dvd"),
            keywords: &["blu-ray", "diski", "dvd", "kwamfuta", "na da’ira"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("dvd"),
            keywords: &["dvd", "אופטי", "דיסק", "מחשב", "תקליטור"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("डीवीडी"),
            keywords: &[
                "ऑप\u{94d}टिकल",
                "क\u{902}प\u{94d}य\u{942}टर",
                "डिस\u{94d}क",
                "डीवीडी",
                "ब\u{94d}ल\u{942} र\u{947}",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("dvd"),
            keywords: &["blu-ray", "disk", "dvd", "optički", "računalo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("dvd"),
            keywords: &["blu-ray", "cd", "dvd", "lemez", "optikai", "számítógép"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("DVD"),
            keywords: &[
                "DVD",
                "blu-ray",
                "cd",
                "համակարգիչ",
                "սկավառակ",
                "օպտիկական",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("dvd"),
            keywords: &["blu-ray", "disk", "dvd", "komputer", "optik"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("dvd"),
            keywords: &["blu-ray", "diiski", "dvd", "kọmpụta", "ọptịkal"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("DVD"),
            keywords: &[
                "DVD",
                "blu-ray",
                "diskur",
                "geisladiskur",
                "mynddiskur",
                "tölva",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("DVD"),
            keywords: &["DVD", "blu-ray", "computer disk", "dvd"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("DVD"),
            keywords: &["Blu-ray", "CD", "DVD", "ディスク", "ブルーレイ"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("cakram dvd"),
            keywords: &["blu-ray", "cakram", "dvd", "komputer", "optikal"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("dvd"),
            keywords: &["blu-ray", "cd", "dvd", "დისკი", "კომპიუტერი", "ოპტიკური"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("DVD"),
            keywords: &["DVD", "blu-ray", "диск", "компьютер", "оптикалық"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("DVD"),
            keywords: &["DVD", "blu-ray", "cd", "computer", "disk", "optisk"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ឌ\u{17b8}វ\u{17b8}ឌ\u{17b8}"),
            keywords: &[
                "ឌ\u{17b8}វ\u{17b8}ឌ\u{17b8}",
                "ឌ\u{17b8}ស",
                "ស\u{17ca}\u{17b8}ឌ\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಡ\u{cbf}ವ\u{cbf}ಡ\u{cbf}"),
            keywords: &[
                "ಆಪ\u{ccd}ಟ\u{cbf}ಕಲ\u{ccd}",
                "ಕಂಪ\u{ccd}ಯ\u{cc2}ಟರ\u{ccd}",
                "ಡ\u{cbf}ವ\u{cbf}ಡ\u{cbf}",
                "ಡ\u{cbf}ಸ\u{ccd}ಕ\u{ccd}",
                "ಬ\u{ccd}ಲ\u{cc2}-ರೇ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("디비디"),
            keywords: &["DVD", "디비디"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("डीवीडी"),
            keywords: &[
                "ऑप\u{94d}टीकल",
                "डिस\u{94d}क",
                "डीवीडी",
                "ब\u{94d}ल\u{942}-र\u{947}",
                "स\u{902}गणक",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("dvd"),
            keywords: &["blu-ray", "cd", "dvd", "диск", "компьютер", "оптикалык"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("DVD"),
            keywords: &["Blu-ray", "Computer", "DVD", "Disk", "optesch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ດ\u{eb5}ວ\u{eb5}ດ\u{eb5}"),
            keywords: &[
                "ຄອມພ\u{eb4}ວເຕ\u{eb5}",
                "ດ\u{eb4}ສ",
                "ດ\u{eb5}ວ\u{eb5}ດ\u{eb5}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("skaitmeninis vaizdo diskas"),
            keywords: &[
                "Blu-Ray",
                "diskas",
                "kompaktinis diskas",
                "kompiuteris",
                "optinis",
                "skaitmeninis vaizdo diskas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("dvd"),
            keywords: &["CD", "DVD", "blu-ray", "dators", "dvd", "kompaktdisks"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kam"),
            keywords: &["blu-ray", "kam", "kōpae", "rorohiko", "whatu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("двд"),
            keywords: &["двд", "компјутер", "хардвер"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഡിവിഡി"),
            keywords: &["ഡിവിഡി", "ഡിസ\u{d4d}ക\u{d4d}ക\u{d4d}", "സിഡി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("dvd"),
            keywords: &["blu-ray", "dvd", "диск", "компьютер", "оптикал"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("डीव\u{94d}हीडी"),
            keywords: &["डिस\u{94d}क", "डीव\u{94d}हीडी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("dvd"),
            keywords: &["blu-ray", "cakera", "dvd", "komputer", "optik"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("dvd"),
            keywords: &["blu-ray", "diska", "dvd", "kompjuter", "ottiċi"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဒ\u{102e}ဗ\u{102e}ဒ\u{102e}"),
            keywords: &[
                "က\u{103d}န\u{103a}ပျ\u{1030}တာ",
                "ဒစ\u{103a}ခ\u{103a}",
                "ဒ\u{102e}ဗ\u{102e}ဒ\u{102e}",
                "ဘလ\u{1030}းရေး",
                "အော\u{1037}ပ\u{103a}တစ\u{103a}ကယ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("DVD"),
            keywords: &["DVD", "DVD-plate", "disk", "lagring", "optisk", "plate"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("डिभिडी"),
            keywords: &[
                "अप\u{94d}टिकल",
                "कम\u{94d}प\u{94d}य\u{941}टर",
                "डिभिडी",
                "डिस\u{94d}क",
                "ब\u{94d}ल\u{941}-र\u{947}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("dvd"),
            keywords: &["blu-ray", "computer", "dvd", "optisch", "schijf"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("DVD"),
            keywords: &["DVD", "DVD-plate", "disk", "lagring", "optisk", "plate"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଡ\u{b3f}ଭ\u{b3f}ଡ\u{b3f}"),
            keywords: &["ଡ\u{b3f}ଭ\u{b3f}ଡ\u{b3f}", "ଡ\u{b3f}ସ\u{b4d}କ\u{b4d}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਡੀ.ਵੀ.ਡੀ"),
            keywords: &[
                "ਆਪਟੀਕਲ",
                "ਕ\u{a70}ਪਿਊਟਰ",
                "ਡਿਸਕ",
                "ਡੀ.ਵੀ.ਡੀ",
                "ਬਲ\u{a42}-ਰ\u{a47}",
                "ਸੀਡੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("dvd"),
            keywords: &["dvd", "بصریات", "بلو-رے", "ڈسک", "کمپیوٹر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("DVD"),
            keywords: &["Blú-Ré", "DVD", "Disk", "Kọmpúta", "Ọ\u{301}ptíkal"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("DVD"),
            keywords: &["Blu-ray", "CD", "DVD", "dysk"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ډي وي ډي"),
            keywords: &["آپتيکي", "بليو ری", "ډسک", "ډي وي ډي", "کمپيوټر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("DVD"),
            keywords: &["DVD", "blu-ray", "computador", "disco", "dvd", "óptico"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("dvd"),
            keywords: &["blu-ray", "computador", "disco", "dvd", "óptico", "ótico"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("dvd"),
            keywords: &["dvd"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("dvd"),
            keywords: &["blu-ray", "computer", "disc", "dvd", "optic"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-637"),
            keywords: &["E10-637"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("DVD"),
            keywords: &["DVD", "dvd", "двд", "двд-диск", "дивиди", "диск", "формат"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("dvd"),
            keywords: &[
                "burureyi",
                "disiki",
                "dvd",
                "kijyanye no kureba",
                "mudasobwa",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڊي وي ڊي"),
            keywords: &["آپٽيڪل", "بلو ري", "ڊسڪ", "ڊي وي ڊي", "ڪمپيوٽر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඩ\u{dd3}ව\u{dd3}ඩ\u{dd3}"),
            keywords: &[
                "ඩ\u{dd3}ව\u{dd3}ඩ\u{dd3}",
                "තැට\u{dd2}ය",
                "පර\u{dd2}ගණකය",
                "බ\u{dca}ල\u{dd6} රේ",
                "ස\u{dd3}ඩ\u{dd3}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("dvd"),
            keywords: &["blu-ray", "cd", "dvd", "počítač"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("dvd"),
            keywords: &["blu-ray", "cd", "disk", "dvd", "optično", "računalnik"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dvd"),
            keywords: &["buluu-raay", "cajalad", "dvd", "kombuyuutar", "obtikaal"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("dvd"),
            keywords: &["blu-ray", "disk", "dvd", "kompjuter", "optik"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("dvd"),
            keywords: &["blu-ray", "dvd", "диск", "оптички", "рачунар"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["dvd"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("dvd"),
            keywords: &["blu-ray", "disk", "dvd", "optički", "računar"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["dvd"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("dvd-skiva"),
            keywords: &["bluray-skiva", "dvd-skiva"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("diski dijitali"),
            keywords: &[
                "blu-ray",
                "cd",
                "diski",
                "diski dijitali",
                "kompyuta",
                "ya macho",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &[
                "blu-ray",
                "cd",
                "diski",
                "diski dijitali",
                "kompyuta",
                "mwangaza",
            ],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("டிவிடி"),
            keywords: &["டிவிடி", "டிஸ\u{bcd}க\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("డ\u{c3f}వ\u{c3f}డ\u{c3f}"),
            keywords: &["డ\u{c3f}వ\u{c3f}డ\u{c3f}", "డ\u{c3f}స\u{c4d}క\u{c4d}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("dvd"),
            keywords: &["blu-ray", "dvd", "диск", "компютер", "оптикӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ด\u{e35}ว\u{e35}ด\u{e35}"),
            keywords: &[
                "คอมพ\u{e34}วเตอร\u{e4c}",
                "ด\u{e34}สก\u{e4c}",
                "ด\u{e35}ว\u{e35}ด\u{e35}",
                "บล\u{e39}เรย\u{e4c}",
                "แผ\u{e48}นด\u{e35}ว\u{e35}ด\u{e35}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("DVD"),
            keywords: &["DVD", "blu-ray", "disk", "dvd", "kompýuter", "optiki"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tisi faiva"),
            keywords: &["tisi faiva"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("dvd"),
            keywords: &["DVD disk", "blu-ray", "disk", "dvd"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("dvd"),
            keywords: &["blu-ray", "dvd", "دىسكا", "كومپيۇتېر", "نۇر"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("[DVD]-диск"),
            keywords: &[
                "DVD-диск",
                "[DVD]-диск",
                "blu-ray",
                "cd",
                "диск",
                "комп’ютер",
                "оптичний",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ڈی وی ڈی"),
            keywords: &["ڈسک", "ڈی وی ڈی", "کمپیوٹر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("dvd"),
            keywords: &["blu-ray", "cd", "disk", "dvd", "kompyuter", "optik"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("dvd"),
            keywords: &["chuẩn đĩa quang", "dvd", "máy tính", "quang", "đĩa"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("dvd"),
            keywords: &["blu-ray", "bu-optik", "disk", "dvd", "ordinatër"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-dvd"),
            keywords: &["i-blu-ray", "i-dvd", "idiski", "ikhomyutha", "yeliso"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("dvd"),
            keywords: &["búlúù-réè", "dvd", "dísìkì", "kọ\u{300}npútà", "ojú àwo"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("DVD"),
            keywords: &["DVD", "光學", "光碟", "藍光", "電腦"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("DVD"),
            keywords: &["DVD", "光学", "光碟", "电脑", "蓝光"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("DVD"),
            keywords: &["DVD", "dvd", "光盘", "光碟", "影片", "音乐"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("DVD"),
            keywords: &["DVD", "光碟"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("idividi"),
            keywords: &[
                "blu-ray",
                "i-dvd",
                "idiski",
                "idividi",
                "ikhompyutha",
                "isidi",
            ],
        },
    ],
};
#[doc = "🧮"]
pub const ABACUS: crate::Emoji = crate::Emoji {
    glyph: "🧮",
    codepoint: "1F9EE",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "abacus",
    group: "Objects",
    subgroup: "computer",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("telraam"),
            keywords: &["somme", "telraam"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አባከስ"),
            keywords: &["ሂሳብ ማስሊያ", "አባከስ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("معداد"),
            keywords: &["تعداد", "معداد"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("গণন\u{9be}-যন\u{9cd}ত\u{9cd}ৰবিশেষ"),
            keywords: &["গণন\u{9be}", "গণন\u{9be}-যন\u{9cd}ত\u{9cd}ৰবিশেষ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("çötkə"),
            keywords: &["hesablama", "çötkə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("лічыльнікі"),
            keywords: &["лічыльнікі", "разлік"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("сметало"),
            keywords: &["сметало", "смятане"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("অ\u{9cd}য\u{9be}ব\u{9be}ক\u{9be}স"),
            keywords: &["অ\u{9cd}য\u{9be}ব\u{9be}ক\u{9be}স", "গণন\u{9be}"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("boulaoueg"),
            keywords: &["boulaoueg", "jediñ"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("računaljka"),
            keywords: &["računaljka", "računanje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("àbac"),
            keywords: &["càlcul", "àbac"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄃\u{11133}𑄠𑄝𑄇𑄌\u{11134}"),
            keywords: &["𑄃\u{11133}𑄠𑄝𑄇𑄌\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᏎᏍᏗ ᏗᏎᏍᏙᏗ"),
            keywords: &["ᏗᏎᎯᏍᏙᏗ", "ᏗᏎᏍᏗ ᏗᏎᏍᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("počitadlo"),
            keywords: &["abakus", "počitadlo", "počty", "počítání"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("abacws"),
            keywords: &["abacws", "cyfrifiad"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kugleramme"),
            keywords: &["kugleramme", "matematik", "regne"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Abakus"),
            keywords: &[
                "Abaki",
                "Abakus",
                "Abakusse",
                "Rechenhilfe",
                "Rechenschieber",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άβακας"),
            keywords: &["άβακας", "υπολογισμός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("abacus"),
            keywords: &["abacus", "calculation"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ábaco"),
            keywords: &["contar", "cálculo", "matemáticas", "ábaco"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("arvelaud"),
            keywords: &["arvelaud", "arvutamine"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("abakoa"),
            keywords: &["abakoa", "kalkulua"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("چرتکه"),
            keywords: &["برآورد", "محاسبات", "محاسبه", "چرتکه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("helmitaulu"),
            keywords: &["helmitaulu", "laskeminen"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("abacus"),
            keywords: &["abacus", "kalkulasyon", "pambilang"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kúluramma"),
            keywords: &["abakus", "kúluramma", "roknibretti"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("abaque"),
            keywords: &["abaque", "calcul"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("abacas"),
            keywords: &["abacas", "ríomh"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("abacas"),
            keywords: &["abacas", "cunntas", "àireamhachadh", "àireamhaich"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("ábaco"),
            keywords: &["contar", "cálculo", "xoguete", "ábaco"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મણકા ઘોડી"),
            keywords: &["ગણતરી", "મણકા ઘોડી"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חשבונייה"),
            keywords: &["אבקוס", "חישוב", "חשבון", "חשבונייה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("अब\u{948}कस"),
            keywords: &["अब\u{948}कस", "गणना"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("abakus"),
            keywords: &["abakus", "računanje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("abakusz"),
            keywords: &["abakusz", "számolás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("հաշվիչ"),
            keywords: &["հաշվիչ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("sempoa"),
            keywords: &["kalkulasi", "sempoa"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("talnagrind"),
            keywords: &["reikningur", "talnagrind"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("abaco"),
            keywords: &["abaco", "fare i calcoli"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("そろばん"),
            keywords: &["そろばん", "アバカス", "算盤"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sempoa"),
            keywords: &["itung-itungan", "sempoa"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("საანგარიშო დაფა"),
            keywords: &["აბაკუსი", "ანგარიში", "გამოთვლა", "საანგარიშო დაფა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("абакус"),
            keywords: &["абакус", "есептеу"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ក\u{17d2}បាច\u{17cb}"),
            keywords: &["ការគណនា", "ក\u{17d2}បាច\u{17cb}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಅಬಾಕಸ\u{ccd}"),
            keywords: &["ಅಬಾಕಸ\u{ccd}", "ಲ\u{cc6}ಕ\u{ccd}ಕಾಚಾರ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("주판"),
            keywords: &["암산", "주판"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("अबास\u{94d}कस"),
            keywords: &["अबास\u{94d}कस", "म\u{947}जणी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("абакус"),
            keywords: &["абакус", "эсептөө"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{eb9}ກຄ\u{eb4}ດ"),
            keywords: &["ການຄ\u{eb4}ດໄລ\u{ec8}", "ລ\u{eb9}ກຄ\u{eb4}ດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("skaitytuvai"),
            keywords: &["skaitytuvai", "skaičiavimas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("skaitīkļi"),
            keywords: &["skaitīkļi", "skaitīšana"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("сметалка"),
            keywords: &["сметалка", "сметање"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("അബ\u{d3e}ക\u{d4d}കസ\u{d4d}"),
            keywords: &[
                "അബ\u{d3e}ക\u{d4d}കസ\u{d4d}",
                "കണക\u{d4d}ക\u{d41}ക\u{d42}ട\u{d4d}ടൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("сампин"),
            keywords: &["сампин", "тооцоолол"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("अब\u{945}कस"),
            keywords: &["अब\u{945}कस", "गणना"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("sempua"),
            keywords: &["pengiraan", "sempua"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပေသ\u{102e}းတ\u{103d}က\u{103a}ခ\u{102f}\u{1036}"),
            keywords: &[
                "တ\u{103d}က\u{103a}ချက\u{103a}ခြင\u{103a}း",
                "ပေသ\u{102e}းတ\u{103d}က\u{103a}ခ\u{102f}\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kuleramme"),
            keywords: &["abakus", "kuleramme", "regning"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("एब\u{94d}याकस"),
            keywords: &["एब\u{94d}याकस", "गणना"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("abacus"),
            keywords: &["abacus", "berekenen", "telraam"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kuleramme"),
            keywords: &["abakus", "kuleramme", "rekning"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଆବ\u{b3e}କସ\u{b4d}\u{200c}"),
            keywords: &["ଆବ\u{b3e}କସ\u{b4d}\u{200c}", "ଗଣନ\u{b3e}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਐਬਾਕਸ"),
            keywords: &["ਐਬਾਕਸ", "ਗਣਨਾ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ábákọs"),
            keywords: &["Kalkuléshọn", "Ábákọs"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("liczydło"),
            keywords: &["abakus", "liczydło", "obliczanie"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ابيکس"),
            keywords: &["ابيکس", "حساب کتاب"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("ábaco"),
            keywords: &["cálculo", "ábaco"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("abac"),
            keywords: &["abac", "calcul", "calcule", "numărătoare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-056"),
            keywords: &["E11-056"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("счеты"),
            keywords: &["вычисления", "подсчет", "счеты"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ابيڪس"),
            keywords: &["ابيڪس", "حساب"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඇබකසය"),
            keywords: &["ඇබකසය", "ගණනය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("počítadlo"),
            keywords: &["abakus", "počty", "počítadlo", "počítanie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("abak"),
            keywords: &["abak", "izračun"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("tiriye"),
            keywords: &["tiriye", "xisaabiye"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("abak"),
            keywords: &["abak", "llogaritës", "numërator", "panel mozaik"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("рачунаљка"),
            keywords: &["рачунаљка", "рачунање"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("računaljka"),
            keywords: &["računaljka", "računanje"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kulram"),
            keywords: &["beräkning", "kulram"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("abaki"),
            keywords: &["abaki", "kokotoa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அப\u{bbe}க\u{bcd}கஸ\u{bcd}"),
            keywords: &["அப\u{bbe}க\u{bcd}கஸ\u{bcd}", "கணக\u{bcd}கு"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("అబ\u{c3e}కస\u{c4d}"),
            keywords: &["అబ\u{c3e}కస\u{c4d}", "గణన"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e39}กค\u{e34}ด"),
            keywords: &["คำนวณ", "ค\u{e34}ดเลข", "ล\u{e39}กค\u{e34}ด"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çot"),
            keywords: &["hasaplamak", "çot"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("solopani"),
            keywords: &["solopani"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("abaküs"),
            keywords: &["abaküs", "hesaplama"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("рахівниця"),
            keywords: &["абак", "обчислення", "рахівниця"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گ\u{650}نتارا"),
            keywords: &["حساب کتاب", "گ\u{650}نتارا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("cho‘t"),
            keywords: &["cho‘t", "cho‘tga tashlash", "hisoblash", "qo‘shish"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bàn tính"),
            keywords: &["bàn tính", "tính toán"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("算盤"),
            keywords: &["算盤", "計數"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("算盘"),
            keywords: &["算盘", "计数"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("算盘"),
            keywords: &["算盘", "计算"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("算盤"),
            keywords: &["算盤", "計算"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["算盤", "計數"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("abacus"),
            keywords: &["abacus", "calculation"],
        },
    ],
};
