#[doc = "👓"]
pub const GLASSES: crate::Emoji = crate::Emoji {
    glyph: "👓",
    codepoint: "1F453",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "glasses",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("bril"),
            keywords: &["bril", "klere", "oog"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መነጽር"),
            keywords: &["መነጽር", "አልባሳት", "ዓይን", "ዓይን ተለባሽ", "ዓይንመነጽር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("نظارة"),
            keywords: &["ملابس", "نظارة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("গ\u{9cd}ল\u{9be}ছ"),
            keywords: &[
                "আইগ\u{9cd}ল\u{9be}ছ",
                "গ\u{9cd}ল\u{9be}ছ",
                "চক\u{9c1}",
                "চশম\u{9be}",
                "পোছ\u{9be}ক",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("eynək"),
            keywords: &["eynək", "geyim", "göz", "gün eynəyi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("акуляры"),
            keywords: &["аксесуар", "акуляры", "вочы", "зрок"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("очила"),
            keywords: &["облекло", "око", "очила"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চশম\u{9be}"),
            keywords: &["চশম\u{9be}", "চোখ", "চোখে পর\u{9be}র", "পোশ\u{9be}ক"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("lunedoù gwelet"),
            keywords: &["daoulagad", "lunedoù", "lunedoù gwelet"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("naočale"),
            keywords: &["asesoar", "naočale", "oči", "predmet"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("ulleres"),
            keywords: &["complements", "ull", "ulleres", "vestuari"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎦᏘᏅᏗ"),
            keywords: &["ᎠᎦᏘ", "ᏗᎦᏘᏅᏗ", "ᏗᎿᏬ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("brýle"),
            keywords: &["brýle", "dioptrie", "oblečení", "oko", "skla"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sbectol"),
            keywords: &["dillad", "llygad", "sbectol"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("briller"),
            keywords: &["beklædning", "briller"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Brille"),
            keywords: &["Accessoire", "Brille"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γυαλιά"),
            keywords: &["ένδυμα", "γυαλιά", "μάτι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("glasses"),
            keywords: &["clothing", "eye", "eyeglasses", "eyewear", "glasses"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &[
                "clothing",
                "eye",
                "eyeglasses",
                "eyewear",
                "specs",
                "spectacles",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("gafas"),
            keywords: &["accesorios", "gafas", "ojo", "ropa"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("lentes"),
            keywords: &["gafas", "lentes", "ropa", "vestimenta"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("lentes"),
            keywords: &["anteojos", "lentes", "ropa", "vestimenta"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("prillid"),
            keywords: &["mood", "prillid", "silm"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("betaurrekoak"),
            keywords: &["arropa", "begi", "betaurreko", "betaurrekoak"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("عینک طبی"),
            keywords: &["عینک", "عینک طبی", "پوشاک", "چشم"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("silmälasit"),
            keywords: &["silmä", "silmälasit", "vaatteet"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("salamin sa mata"),
            keywords: &["eyeglasses", "mata", "salamin", "salamin sa mata"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("brillur"),
            keywords: &["brillur", "eyga"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("lunettes de vue"),
            keywords: &["lunettes", "lunettes de vue", "vêtements", "œil"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("spéaclaí"),
            keywords: &["feisteas", "spéaclaí", "súil"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("speuclairean"),
            keywords: &["aodach", "speuclairean", "sùil"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("anteollos"),
            keywords: &["anteollos", "lentes"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચશ\u{acd}મા"),
            keywords: &[
                "આ\u{a82}ખના\u{a82} ચશ\u{acd}મા",
                "કપડા\u{a82}",
                "ચશ\u{acd}મા",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("tabarau"),
            keywords: &["ido", "kayan ido", "sutura", "tabarau"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("משקפיים"),
            keywords: &["משקפיים", "עיניים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चश\u{94d}मा"),
            keywords: &["चश\u{94d}मा", "पोषाक"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("naočale"),
            keywords: &["naočale", "odjeća", "oko"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szemüveg"),
            keywords: &["szem", "szemüveg", "viselet"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ակնոց"),
            keywords: &["ակնոց", "աչք", "հագուստ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kacamata"),
            keywords: &["kaca", "kacamata", "mata", "pakaian"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ènyò gasị"),
            keywords: &["akwà", "anya", "mpù n’anya", "ugogbeanya", "ènyò gasị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("gleraugu"),
            keywords: &["augu", "gleraugu", "klæðnaður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("occhiali da vista"),
            keywords: &["abbigliamento", "occhiali", "occhiali da vista"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("メガネ"),
            keywords: &["メガネ"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kacamata"),
            keywords: &[
                "kaca tingal",
                "kacamata",
                "mata",
                "panganggo mripat",
                "sandangan",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სათვალე"),
            keywords: &["თვალი", "სათვალე", "ტანსაცმელი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("көзілдірік"),
            keywords: &["кию", "көз", "көзге тағу", "көзілдірік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("briller"),
            keywords: &["beklædning", "briller"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("វ\u{17c9}ែនតា"),
            keywords: &["ម\u{17c9}\u{17d2}ញ\u{17bc}ប", "វ\u{17c9}ែនតា"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕನ\u{ccd}ನಡಕಗಳು"),
            keywords: &[
                "ಉಡುಪು",
                "ಕಣ\u{ccd}ಣು",
                "ಕನ\u{ccd}ನಡಕಗಳು",
                "ನಯನತೊಡುಗ\u{cc6}ಗಳು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("안경"),
            keywords: &["눈", "안경"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ओक\u{94d}ल"),
            keywords: &[
                "ओक\u{94d}ल",
                "ओक\u{94d}ला\u{902}",
                "कपड\u{947}",
                "दोळो",
                "दोळ\u{94d}या\u{902}क घालपाच\u{947}\u{902}",
                "दोळ\u{94d}याओक\u{94d}ल",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("көз айнек"),
            keywords: &["кийим", "көз", "көз айнек"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Brëll"),
            keywords: &["A", "Brëll", "Kleedung"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແວ\u{ec8}ນຕາ"),
            keywords: &["ຕາ", "ແວ\u{ec8}ນຕາ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("akiniai"),
            keywords: &["akiniai", "akys", "apranga"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("brilles"),
            keywords: &["acis", "brilles"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("mōhiti karu"),
            keywords: &["karu", "kākahu", "mōhiti"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("очила"),
            keywords: &["очи", "очила"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കണ\u{d4d}ണട"),
            keywords: &[
                "കണ\u{d4d}ണട",
                "കണ\u{d4d}ണടകൾ",
                "വസ\u{d4d}ത\u{d4d}രം",
                "സൺ ഗ\u{d4d}ല\u{d3e}സ\u{d4d}സ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("харааны шил"),
            keywords: &["хараа", "харааны шил", "шил"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चष\u{94d}मा"),
            keywords: &["कपड\u{947}", "चष\u{94d}मा", "डोळ\u{947}"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("cermin mata"),
            keywords: &["cermin mata", "kaca mata", "mata", "pakaian"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("nuċċali"),
            keywords: &["għajn", "nuċċali", "nuċċalijiet", "ħwejjeġ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မျက\u{103a}မ\u{103e}န\u{103a}"),
            keywords: &[
                "နေကာမျက\u{103a}မ\u{103e}န\u{103a}",
                "မျက\u{103a}မ\u{103e}န\u{103a}",
                "မျက\u{103a}လ\u{102f}\u{1036}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("briller"),
            keywords: &["briller", "klær", "lesebriller"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("चस\u{94d}मा"),
            keywords: &[
                "आ\u{901}खा",
                "आ\u{901}खाको चस\u{94d}मा",
                "आ\u{901}खामा लगाउन\u{947}",
                "कपडा",
                "चस\u{94d}मा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bril"),
            keywords: &["bril", "brillen", "kleding", "oog"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("briller"),
            keywords: &["briller", "klede", "lesebriller"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଚଷମ\u{b3e}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ"),
            keywords: &[
                "ଆଇଗ\u{b4d}ଲ\u{b3e}ସ\u{b4d}\u{200c}",
                "ଚଷମ\u{b3e}",
                "ଚଷମ\u{b3e}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
                "ପୋଷ\u{b3e}କ ପର\u{b3f}ଚ\u{b4d}ଛଦ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਐਨਕਾ\u{a02}"),
            keywords: &["ਐਨਕ", "ਐਨਕਾ\u{a02}", "ਲਿਬਾਸ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("عینک"),
            keywords: &["اکھ", "اکھ پ\u{64f}وش", "عینک", "عینکاں", "کپڑے"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Aí Glásis"),
            keywords: &["Ai", "Aí Glásis", "Aíwia", "Glásis", "Klọt"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("okulary"),
            keywords: &["oczy", "okulary", "szkła"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("عینکې"),
            keywords: &["سترګو عینکې", "سترګې", "عینکې", "کالی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("óculos"),
            keywords: &["acessório", "óculos"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["acessório", "olhos", "óculos"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("lentes"),
            keywords: &["lentes"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ochelari"),
            keywords: &["ochelari", "ochi", "vedere"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-528"),
            keywords: &["E10-528"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("очки"),
            keywords: &["аксессуар", "глаза", "защита", "одежда", "очки"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("amadarubindi"),
            keywords: &["amadarubindi", "amataratara", "ijisho", "imyambaro"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عينڪ"),
            keywords: &["اک", "اک جا چشما", "شيشا", "عينڪ", "لباس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කණ\u{dca}ණ\u{dcf}ඩ\u{dd2}"),
            keywords: &[
                "ඇඳ\u{dd4}ම\u{dca}",
                "ඇස",
                "ඇස\u{dca} පැළද\u{dd4}ම\u{dca}",
                "කණ\u{dca}ණ\u{dcf}ඩ\u{dd2}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("okuliare"),
            keywords: &["oko", "okuliare"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("očala"),
            keywords: &["oblačila", "očala", "oči"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("muraayado"),
            keywords: &[
                "dhar",
                "indho",
                "indho-gashi",
                "muraayad",
                "muraayad indhood",
                "muraayado",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("syze"),
            keywords: &["sy", "syze", "veshje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("наочари"),
            keywords: &["наочари", "одећа", "око"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["наочари"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("naočari"),
            keywords: &["naočari", "odeća", "oko"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["naočari"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("glasögon"),
            keywords: &["accessoarer", "brillor", "glasögon", "ögon"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("miwani"),
            keywords: &["jicho", "maiwani", "mavazi", "miwani", "miwani ya macho"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["jicho", "mavazi", "miwani", "miwani ya macho"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மூக\u{bcd}குக\u{bcd} கண\u{bcd}ண\u{bbe}டிகள\u{bcd}"),
            keywords: &[
                "ஆடை அணிகலன\u{bcd}",
                "கண\u{bcd}ண\u{bbe}டி",
                "கண\u{bcd}ண\u{bbe}டிகள\u{bcd}",
                "மூக\u{bcd}குக\u{bcd} கண\u{bcd}ண\u{bbe}டி",
                "மூக\u{bcd}குக\u{bcd} கண\u{bcd}ண\u{bbe}டிகள\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కళ\u{c4d}లద\u{c4d}ద\u{c3e}లు"),
            keywords: &[
                "కన\u{c4d}ను",
                "కళ\u{c4d}లజ\u{c4b}ళ\u{c4d}లు",
                "కళ\u{c4d}లద\u{c4d}ద\u{c3e}లు",
                "దుస\u{c4d}తులు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("айнак"),
            keywords: &["айнак", "айнаки муҳофизатӣ", "либос", "чашм"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แว\u{e48}นตา"),
            keywords: &["ตา", "แว\u{e48}นตา", "แว\u{e48}นสายตา"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("äýnek"),
            keywords: &["eşik", "göz", "pensne", "äýnek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("matasioʻata"),
            keywords: &["matasioʻata"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("gözlük"),
            keywords: &["giyim", "gözlük"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئەينەك"),
            keywords: &["ئەينەك", "كىيىم", "كۆز", "كۆزەينەك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("окуляри"),
            keywords: &["одяг", "око", "окуляри"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چشمے"),
            keywords: &["آنکھ", "جشمے", "لباس", "چشمے"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ko‘zoynak"),
            keywords: &["kiyim", "ko‘z", "ko‘zoynak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("kính mắt"),
            keywords: &["kính", "mắt", "quần áo", "đeo kính"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("linet"),
            keywords: &["bët", "bëtweer", "linet", "lunet", "yéere"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iiglasi"),
            keywords: &["iiglasi", "iindondo", "iliso", "impahla"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Digi"),
            keywords: &["Digi", "aṣọ", "gíláásì ojú", "ìbòjú", "ẹyinjú"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("眼鏡"),
            keywords: &["服裝", "眼", "眼鏡"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("眼镜"),
            keywords: &["服装", "眼", "眼镜"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("眼镜"),
            keywords: &["服饰", "眼睛", "眼镜"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("眼鏡"),
            keywords: &["眼鏡"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("izibuko"),
            keywords: &[
                "ihlo",
                "impahla yokugqoka",
                "izibuko",
                "izibuko zamehlo",
                "ukugqokisa amehlo",
            ],
        },
    ],
};
#[doc = "🕶\u{fe0f}"]
pub const SUNGLASSES: crate::Emoji = crate::Emoji {
    glyph: "🕶\u{fe0f}",
    codepoint: "1F576 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "sunglasses",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🕶",
        codepoint: "1F576",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "sunglasses",
        group: "Objects",
        subgroup: "clothing",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("sonbril"),
            keywords: &["bril", "donker", "oog", "son", "sonbril"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የፀሐይ መነጽር"),
            keywords: &["መነጽር", "ዓይን", "ዓይን ተለባሽ", "የፀሐይ መነጽር", "ጨለማ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("نظارة شمس"),
            keywords: &["عين", "مظلم", "نظارات", "نظارة", "نظارة شمس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ছ\u{9be}নগ\u{9cd}ল\u{9be}ছ"),
            keywords: &[
                "অন\u{9cd}ধক\u{9be}ৰ",
                "গ\u{9cd}ল\u{9be}ছ",
                "চক\u{9c1}",
                "চশম\u{9be}",
                "ছ\u{9be}নগ\u{9cd}ল\u{9be}ছ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("gün eynəyi"),
            keywords: &["eynək", "göz", "gün eynəyi", "tünd"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сонечныя акуляры"),
            keywords: &["аксесуар", "акуляры", "вочы", "сонечныя акуляры", "цёмны"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Тъмни очила"),
            keywords: &["Тъмни очила", "око", "очила", "тъмен"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9be}নগ\u{9cd}ল\u{9be}স"),
            keywords: &[
                "গ\u{9be}ঢ\u{9bc}",
                "চশম\u{9be}",
                "চোখ",
                "স\u{9be}নগ\u{9cd}ল\u{9be}স",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("lunedoù-heol"),
            keywords: &["daoulagad", "lunedoù", "lunedoù-heol"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("sunčane naočale"),
            keywords: &["asesoar", "naočale", "oči", "predmet", "sunčane naočale"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("ulleres de sol"),
            keywords: &["fosques", "sol", "ull", "ulleres", "ulleres de sol"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎦᎵᏍᎬᎢ ᏗᎦᏘᏅᏛᏗ"),
            keywords: &["ᎠᎦᎵᏍᎬᎢ ᏗᎦᏘᏅᏛᏗ", "ᎠᎦᏘ", "ᎤᎵᏏᎩ", "ᏗᎦᏘᏅᏗ", "ᏗᎦᏘᏅᏗᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("sluneční brýle"),
            keywords: &["brýle", "oko", "skla", "sluneční brýle", "tmavé"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sbectol haul"),
            keywords: &["llygad", "sbectol", "sbectol haul", "tywyll"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("solbriller"),
            keywords: &["briller", "mørk", "solbriller", "øje"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Sonnenbrille"),
            keywords: &["Augen", "Brille", "Sonnenbrille", "dunkel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γυαλιά ηλίου"),
            keywords: &["γυαλιά", "γυαλιά ηλίου", "μάτι", "οπτικά", "σκοτεινός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("sunglasses"),
            keywords: &["dark", "eye", "eyewear", "glasses", "sunglasses"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["dark", "eye", "eyewear", "glasses", "sunglasses", "sunnies"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("gafas de sol"),
            keywords: &["gafas", "gafas de sol", "ojo", "oscuras", "sol"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("anteojos de sol"),
            keywords: &[
                "anteojos",
                "anteojos de sol",
                "gafas",
                "oscuros",
                "ropa",
                "sol",
                "vestimenta",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("lentes de sol"),
            keywords: &["lentes de sol", "lentes oscuros", "sol"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "anteojos",
                "anteojos de sol",
                "gafas",
                "lentes de sol",
                "oscuros",
                "sol",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("päikeseprillid"),
            keywords: &["prillid", "päikeseprillid", "silm", "tume"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("eguzkitako betaurrekoak"),
            keywords: &["begi", "betaurreko", "eguzkitako betaurrekoak", "ilun"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("عینک آفتابی"),
            keywords: &["تیره", "عینک آفتابی", "چشم"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("aurinkolasit"),
            keywords: &["aurinkolasit", "lasit", "silmä", "silmälasit", "tumma"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("shades"),
            keywords: &["maaraw", "salamin sa mata", "shades", "sunglasses"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sólbrillur"),
            keywords: &["brillur", "sól", "sólbrillur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("lunettes de soleil"),
            keywords: &["lunettes", "lunettes de soleil", "soleil"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("spéaclaí gréine"),
            keywords: &[
                "dorcha",
                "spéaclaí",
                "spéaclaí gréine",
                "súil",
                "súilbheart",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("speuclairean-grèine"),
            keywords: &["dorcha", "speuclairean", "speuclairean-grèine", "sùil"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("lentes de sol"),
            keywords: &["anteollos", "lentes", "lentes de sol", "sol"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સનગ\u{acd}લાસ\u{ac7}સ"),
            keywords: &["આ\u{a82}ખ", "ચશ\u{acd}મા\u{a82}", "સનગ\u{acd}લાસ\u{ac7}સ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("gilashin rana"),
            keywords: &["duhu", "gilashin rana", "ido", "kayan ido", "tabarau"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("משקפי שמש"),
            keywords: &["משקפי שמש", "משקפיים", "שמש"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ध\u{942}प का चश\u{94d}मा"),
            keywords: &[
                "अ\u{902}ध\u{947}रा",
                "आ\u{902}ख",
                "आईवियर",
                "चश\u{94d}मा",
                "ध\u{942}प का चश\u{94d}मा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("sunčane naočale"),
            keywords: &["naočale", "oko", "sunčane naočale", "tamno"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("napszemüveg"),
            keywords: &["kiegészítő", "napszemüveg", "szem", "szemüveg", "sötét"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("արևային ակնոց"),
            keywords: &["ակնոց", "աչք", "արևային ակնոց", "մուգ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kacamata hitam"),
            keywords: &["hitam", "kaca", "kacamata hitam", "mata"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ugogbeanya"),
            keywords: &["anya", "mpù n’anya", "oji", "ugogbeanya", "ènyò gasị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sólgleraugu"),
            keywords: &["auga", "dimmt", "gleraugu", "sólgleraugu"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("occhiali da sole"),
            keywords: &["occhiali da sole", "occhiali scuri"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("サングラス"),
            keywords: &["サングラス", "メガネ"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kacamata ireng"),
            keywords: &[
                "kacamata",
                "kacamata ireng",
                "mripat",
                "panganggo mripat",
                "peteng",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მზის სათვალე"),
            keywords: &["თვალი", "მზის სათვალე", "მუქი", "სათვალე"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("күннен қорғайтын көзілдірік"),
            keywords: &[
                "күннен қорғайтын көзілдірік",
                "күңгірт",
                "көз",
                "көзге тағу",
                "көзілдірік",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("solbriller"),
            keywords: &["briller", "mørk", "solbriller", "øje"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("វ\u{17c9}ែនតាខ\u{17d2}មៅ"),
            keywords: &[
                "ខ\u{17d2}មៅ",
                "ងង\u{17b9}ត",
                "វ\u{17c9}ែនតា",
                "វ\u{17c9}ែនតាខ\u{17d2}មៅ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ತಂಪು ಕನ\u{ccd}ನಡಕಗಳು"),
            keywords: &[
                "ಕಣ\u{ccd}ಣು",
                "ಕನ\u{ccd}ನಡಕ",
                "ಕಪ\u{ccd}ಪು",
                "ತಂಪು ಕನ\u{ccd}ನಡಕಗಳು",
                "ನಯನತೊಡುಗ\u{cc6}ಗಳು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("선글라스"),
            keywords: &["선글라스", "안경"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("सनग\u{94d}लास"),
            keywords: &[
                "ओक\u{94d}ल",
                "काळो",
                "दोळो",
                "दोळ\u{94d}या\u{902}क घालपाच\u{947}\u{902}",
                "सनग\u{94d}लास",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кара көз айнек"),
            keywords: &["кара", "кара көз айнек", "көз", "көз айнек"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Sonnebrëll"),
            keywords: &["A", "Brëll", "Sonnebrëll", "däischter"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແວ\u{ec8}ນຕາກ\u{eb1}ນແດດ"),
            keywords: &["ຕາ", "ແດດ", "ແວ\u{ec8}ນຕາ", "ແວ\u{ec8}ນຕາກ\u{eb1}ນແດດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("akiniai nuo saulės"),
            keywords: &["akiniai", "akiniai nuo saulės", "akys", "tamsūs"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("saulesbrilles"),
            keywords: &["acis", "brilles", "saulesbrilles"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("mōhitirā"),
            keywords: &["karu", "mōhiti", "mōhitirā", "pōuri"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("очила за сонце"),
            keywords: &["очи", "очила", "очила за сонце", "сонце", "темни"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സൺഗ\u{d4d}ല\u{d3e}സ\u{d4d}"),
            keywords: &[
                "കണ\u{d4d}ണട",
                "കണ\u{d4d}ണടകൾ",
                "കണ\u{d4d}ണ\u{d4d}",
                "കറ\u{d41}പ\u{d4d}പ\u{d4d}",
                "സൺഗ\u{d4d}ല\u{d3e}സ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нарны шил"),
            keywords: &["нар", "нарны шил", "шил"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("उन\u{94d}हाचा चष\u{94d}मा"),
            keywords: &[
                "उन\u{94d}हाचा चष\u{94d}मा",
                "काळा",
                "चष\u{94d}मा",
                "डोळ\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kaca mata hitam"),
            keywords: &[
                "cermin mata",
                "gelap",
                "kaca mata",
                "kaca mata hitam",
                "mata",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("nuċċali tax-xemx"),
            keywords: &["għajn", "nuċċali", "nuċċali tax-xemx", "skur"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("နေကာ မျက\u{103a}မ\u{103e}န\u{103a}"),
            keywords: &[
                "နေကာ မျက\u{103a}မ\u{103e}န\u{103a}",
                "နေကာမျက\u{103a}မ\u{103e}န\u{103a} အမည\u{103a}း",
                "မျက\u{103a}မ\u{103e}န\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("solbriller"),
            keywords: &["briller", "mørkt", "solbriller", "øye"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("घाममा लगाउन\u{947} चस\u{94d}मा"),
            keywords: &[
                "अ\u{901}ध\u{94d}यारो",
                "आ\u{901}खा",
                "आ\u{901}खामा लगाउन\u{947}",
                "घाममा लगाउन\u{947} चस\u{94d}मा",
                "चस\u{94d}मा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("zonnebril"),
            keywords: &["bril", "brillen", "donker", "oog", "zonnebril"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("solbriller"),
            keywords: &["auge", "briller", "mørkt", "solbriller"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସନଗ\u{b4d}ଲ\u{b3e}ସ\u{b4d}\u{200c}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ"),
            keywords: &[
                "ଆଇୱେୟ\u{b3e}ର\u{b4d}\u{200c}",
                "ଆଖ\u{b3f}",
                "ଗ\u{b3e}ଢ\u{b3c}",
                "ଚଷମ\u{b3e}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
                "ସନଗ\u{b4d}ଲ\u{b3e}ସ\u{b4d}\u{200c}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਾਲੀਆ\u{a02} ਐਨਕਾ\u{a02}"),
            keywords: &[
                "ਅ\u{a71}ਖ",
                "ਐਨਕਾ\u{a02}",
                "ਕਾਲਾ",
                "ਕਾਲੀਆ\u{a02} ਐਨਕਾ\u{a02}",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("دھوپ آلیاں عینکاں"),
            keywords: &[
                "اکھ",
                "اکھ پ\u{64f}وش",
                "دھوپ آلیاں عینکاں",
                "عینک",
                "ہنیرا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Sọ\u{301}nglásis"),
            keywords: &["Ai", "Aíwia", "Dak", "Glásis", "Sọ\u{301}nglásis"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("okulary słoneczne"),
            keywords: &[
                "ciemne okulary",
                "okulary słoneczne",
                "przeciwsłoneczne",
                "słoneczne",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لمر عینکې"),
            keywords: &["تیاره", "سترګه", "عینکې", "لمر عینکې"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("óculos escuros"),
            keywords: &["óculos", "óculos de sol", "óculos escuros"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("óculos de sol"),
            keywords: &[
                "acessório",
                "escuro",
                "olhos",
                "óculos",
                "óculos de sol",
                "óculos escuros",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("lentes intipaq"),
            keywords: &["lentes intipaq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ochelari de soare"),
            keywords: &["ochelari", "ochelari de soare", "protecție", "soare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-797"),
            keywords: &["E10-797"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("солнечные очки"),
            keywords: &[
                "аксессуар",
                "защита",
                "очки",
                "солнечные очки",
                "солнце",
                "темные",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("fime"),
            keywords: &["amataratara", "fime", "ijisho", "kijimye"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ا\u{64f}س جا چشما"),
            keywords: &["انڌيرو", "ا\u{64f}س جا چشما", "اک", "عينڪ", "چشما"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අව\u{dca} කණ\u{dca}ණ\u{dcf}ඩ\u{dd2}"),
            keywords: &[
                "අඳ\u{dd4}ර\u{dd4}",
                "අව\u{dca} කණ\u{dca}ණ\u{dcf}ඩ\u{dd2}",
                "ඇස",
                "ඇස\u{dca} පැළද\u{dd4}ම\u{dca}",
                "කණ\u{dca}ණ\u{dcf}ඩ\u{dd2}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("slnečné okuliare"),
            keywords: &["oko", "okuliare", "slnečné okuliare", "tmavé"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("sončna očala"),
            keywords: &["očala", "oči", "sončna očala", "temno"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("muraayada qoraxda"),
            keywords: &[
                "indho",
                "indho-gashi",
                "madow",
                "muraayad",
                "muraayada qoraxda",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("syze dielli"),
            keywords: &["i errët", "sy", "syze", "syze dielli"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("наочари за сунце"),
            keywords: &["oкo", "нaoчaри", "наочари за сунце", "тaмнo"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("naočari za sunce"),
            keywords: &["naočari", "naočari za sunce", "oko", "tamno"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("solglasögon"),
            keywords: &["glasögon", "solglasögon"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("miwani ya jua"),
            keywords: &[
                "jicho",
                "miwani",
                "miwani ya jua",
                "miwani ya macho",
                "nyeusi",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சன\u{bcd}கிள\u{bbe}சஸ\u{bcd}"),
            keywords: &[
                "கருப\u{bcd}புக\u{bcd} கண\u{bcd}ண\u{bbe}டி",
                "சன\u{bcd}கிள\u{bbe}சஸ\u{bcd}",
                "சன\u{bcd}கிள\u{bbe}ஸ\u{bcd}கள\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చలువ కళ\u{c4d}లద\u{c4d}ద\u{c3e}లు"),
            keywords: &["కళ\u{c4d}లద\u{c4d}ద\u{c3e}లు", "చలువ"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("айнаки офтобӣ"),
            keywords: &[
                "айнак",
                "айнаки муҳофизатӣ",
                "айнаки офтобӣ",
                "торик",
                "чашм",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แว\u{e48}นก\u{e31}นแดด"),
            keywords: &["ตา", "แดด", "แว\u{e48}นก\u{e31}นแดด", "แว\u{e48}นตา"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gara äýnek"),
            keywords: &["gara", "göz", "pensne", "äýnek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("matasioʻatalaʻā"),
            keywords: &["matasioʻatalaʻā"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("güneş gözlüğü"),
            keywords: &["göz", "gözlük", "güneş gözlüğü", "kara"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كۈن ئەينىكى"),
            keywords: &["ئەينەك", "قاراڭغۇ", "كۆز", "كۆزەينەك", "كۈن ئەينىكى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("сонцезахисні окуляри"),
            keywords: &["око", "окуляри", "сонцезахисні окуляри", "темний"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("دھوپ چشمے"),
            keywords: &["آنکھ", "جشمے", "دھوپ چشمے", "لباس"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("quyoshdan himoyalaydigan ko‘zoynak"),
            keywords: &[
                "ko‘z",
                "ko‘zoynak",
                "qorong‘u",
                "quyoshdan himoyalaydigan ko‘zoynak",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("kính râm"),
            keywords: &["bóng tối", "kính mắt", "kính râm", "mắt", "đeo kính"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("nuwaarfime"),
            keywords: &["bët", "lunet", "lëndëm", "nuwaarfime", "weer"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iindondo"),
            keywords: &["iiglasi", "iindondo", "iliso", "mnyama"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("gíláásì òrùn"),
            keywords: &["dúdú", "gíláásì", "gíláásì òrùn", "ojú", "ìbòjú"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("太陽眼鏡"),
            keywords: &["太陽眼鏡", "眼", "眼鏡", "黑暗"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("太阳眼镜"),
            keywords: &["太阳眼镜", "眼", "眼镜", "黑暗"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("墨镜"),
            keywords: &["墨镜", "太阳镜"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("太陽眼鏡"),
            keywords: &["墨鏡", "太陽眼鏡"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("izibuko zelanga"),
            keywords: &[
                "ihlo",
                "izibuko",
                "izibuko zamehlo",
                "izibuko zelanga",
                "ubumnyana",
            ],
        },
    ],
};
#[doc = "🥽"]
pub const GOGGLES: crate::Emoji = crate::Emoji {
    glyph: "🥽",
    codepoint: "1F97D",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "goggles",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("skermbril"),
            keywords: &["duik", "oogbeskerming", "skermbril", "sweis", "swem"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የመዋኛ መነጽር"),
            keywords: &["መበየድ", "መዋኘት", "የመዋኛ መነጽር", "የአይን መከላከያ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("نظارة واقية"),
            keywords: &[
                "حماية",
                "حماية العينين",
                "سباحة",
                "شرارة",
                "عينين",
                "لحام",
                "مياه",
                "نظارة واقية",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("গ’গলছ\u{9cd}"),
            keywords: &[
                "গ’গলছ\u{9cd}",
                "চক\u{9c1}ৰ স\u{9c1}ৰক\u{9cd}ষ\u{9be}",
                "স\u{9be}\u{981}তোৰ",
                "ৱেল\u{9cd}ডিং",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("su eynəyi"),
            keywords: &["göz müdafiyəsi", "qaynaq", "su eynəyi", "üzmək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ахоўныя акуляры"),
            keywords: &["ахова вачэй", "ахоўныя акуляры", "зварка", "плаванне"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("предпазни очила"),
            keywords: &[
                "заваряване",
                "защита на очите",
                "плуване",
                "предпазни очила",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("গগলস"),
            keywords: &[
                "গগলস",
                "চোখের স\u{9c1}রক\u{9cd}ষ\u{9be}",
                "ঝ\u{9be}ল\u{9be}ই",
                "স\u{9be}\u{981}ত\u{9be}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("lunedoù-kouronkañ"),
            keywords: &["daoulagad", "lunedoù", "lunedoù-kouronkañ"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zaštitne naočale"),
            keywords: &[
                "plivanje",
                "zavarivanje",
                "zaštita za oči",
                "zaštitne naočale",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("ulleres de piscina"),
            keywords: &[
                "natació",
                "protecció",
                "protecció dels ulls",
                "protecció ocular",
                "ulleres de piscina",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏂᎫᎦᎵ"),
            keywords: &["ᎠᏂᎫᎦᎵ", "ᎠᏓᏬᏍᎬ", "ᏕᎧᏅᏫᎠ", "ᏨᏙᎵ ᎠᏓᎵᏍᎦᏍᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("ochranné brýle"),
            keywords: &[
                "ochrana očí",
                "ochranné brýle",
                "plavecké",
                "plavání",
                "svařování",
                "svářečské",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("gogls"),
            keywords: &["amddiffyn llygad", "gogls", "nofio", "weldio"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sikkerhedsbriller"),
            keywords: &["sikkerhedsbriller", "svejse", "svømme", "øjenbeskyttelse"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schutzbrille"),
            keywords: &["Augenschutz", "Schutzbrille", "Schweißen", "Schwimmen"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: None,
            keywords: &["Schutzbrille"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("προστατευτικά γυαλιά"),
            keywords: &[
                "κολύμπι",
                "προστασία ματιών",
                "προστατευτικά γυαλιά",
                "συγκόλληση",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("goggles"),
            keywords: &["eye protection", "goggles", "swimming", "welding"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("gafas de protección"),
            keywords: &[
                "gafas",
                "gafas de protección",
                "nadar",
                "protección ocular",
                "soldar",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("goggles"),
            keywords: &[
                "goggles",
                "lentes de natación",
                "lentes de protección",
                "lentes para nadar",
                "soldar",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "gafas",
                "gafas de protección",
                "goggles",
                "nadar",
                "protección ocular",
                "soldar",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kaitseprillid"),
            keywords: &["kaitseprillid", "keevitamine", "silmakaitse", "ujumine"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("igeriketako betaurrekoak"),
            keywords: &[
                "begien babes",
                "igeriketa",
                "igeriketako betaurrekoak",
                "soldadura",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("عینک ایمنی"),
            keywords: &["جوشکاری", "شنا", "عینک ایمنی", "محافظ چشم"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("suojalasit"),
            keywords: &["hitsaus", "silmien suojelu", "suojalasit", "uimalasit"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("goggles"),
            keywords: &["goggles", "proteksyon sa mata", "swimming", "welding"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("verjubrillur"),
            keywords: &["brillur", "skíðbrillur", "verjubrillur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("lunettes"),
            keywords: &["lunettes", "natation", "protection des yeux", "soudage"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "lunettes",
                "natation",
                "protection des yeux",
                "soudage",
                "soudure",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("spéaclaí cosanta"),
            keywords: &["cosaint súl", "snámh", "spéaclaí cosanta", "táthú"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("glainne-dhìona"),
            keywords: &["dìon sùla", "glainne-dhìona", "snàmh", "sùil", "tàthadh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("gafas de protección"),
            keywords: &["gafas de protección", "natación", "protección", "soldar"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ગોગલ\u{acd}સ"),
            keywords: &["ગોગલ\u{acd}સ"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("משקפי שחייה"),
            keywords: &["משקפי מגן", "משקפי שחייה", "משקפיים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("गॉगल"),
            keywords: &[
                "आ\u{901}खो\u{902} की स\u{941}रक\u{94d}षा",
                "गॉगल",
                "त\u{948}राकी",
                "व\u{947}ल\u{94d}डि\u{902}ग",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zaštitne naočale"),
            keywords: &[
                "naočale za plivanje",
                "plivanje",
                "varenje",
                "zaštitne naočale",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("védőszemüveg"),
            keywords: &["hegesztés", "szemvédelem", "védőszemüveg", "úszás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("պաշտպանիչ ակնոց"),
            keywords: &["աչքերի պաշտպանություն", "զոդում", "լող", "պաշտպանիչ ակնոց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kacamata renang"),
            keywords: &["berenang", "kacamata renang", "mengelas", "pelindung mata"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hlífðargleraugu"),
            keywords: &["hlífðargleraugu", "logsuða", "rafsuða", "sund"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("maschera"),
            keywords: &[
                "maschera",
                "nuoto",
                "occhiali di protezione",
                "occhialini",
                "saldatura",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ゴーグル"),
            keywords: &["ゴーグル", "保護メガネ", "水泳", "溶接"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("gogel"),
            keywords: &["gogel", "ngelas", "nglangi", "proteksi mripat"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დამცავი სათვალე"),
            keywords: &["დამცავი სათვალე", "თვალების დაცვა", "ყვინთვა", "ცურვა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жаздық көзілдірік"),
            keywords: &["дәнекерлеу", "жаздық көзілдірік", "жүзу", "көзді қорғау"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("វ\u{17c9}ែនតាការពារ"),
            keywords: &[
                "ការការពារភ\u{17d2}នែក",
                "ការផ\u{17d2}សាដែក",
                "ការហែលទ\u{17b9}ក",
                "វ\u{17c9}ែនតាការពារ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕನ\u{ccd}ನಡಕ"),
            keywords: &[
                "ಈಜು",
                "ಕಣ\u{ccd}ಣ\u{cbf}ನ ರಕ\u{ccd}ಷಣ\u{cc6}",
                "ಕನ\u{ccd}ನಡಕ",
                "ವ\u{cc6}ಲ\u{ccd}ಡ\u{cbf}ಂಗ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("고글"),
            keywords: &[
                "고글",
                "물안경",
                "수영",
                "수영 안경",
                "안구 보호 장비",
                "용접",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("गॉगल\u{94d}स"),
            keywords: &[
                "गॉगल\u{94d}स",
                "गॉ\u{93c}गल\u{94d}स",
                "दोळ\u{94d}याची राखण",
                "प\u{947}\u{902}वप",
                "व\u{947}ल\u{94d}डी\u{902}ग",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("коргоочу көз айнек"),
            keywords: &["коргоочу көз айнек", "көздү коргоо", "сүзүү", "ширетүү"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແວ\u{ec8}ນຕາກ\u{eb1}ນລ\u{ebb}ມ"),
            keywords: &[
                "ປ\u{ec9}ອງກ\u{eb1}ນດວງຕາ",
                "ລອຍນ\u{ec9}ຳ",
                "ເຊ\u{eb7}\u{ec8}ອມຈອດ",
                "ແວ\u{ec8}ນຕາກ\u{eb1}ນລ\u{ebb}ມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("apsauginiai akiniai"),
            keywords: &[
                "akių apsauga",
                "apsauginiai akiniai",
                "plaukimas",
                "suvirinimas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("aizsargbrilles"),
            keywords: &[
                "acu aizsardzība",
                "aizsargbrilles",
                "metināšana",
                "peldēšana",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("заштитни очила"),
            keywords: &[
                "заварување",
                "заштита на очите",
                "заштитни очила",
                "пливање",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കണ\u{d4d}ണടകൾ"),
            keywords: &[
                "കണ\u{d4d}ണടകൾ",
                "കണ\u{d4d}ണിന\u{d4d}റെ സ\u{d41}രക\u{d4d}ഷ",
                "നീന\u{d4d}തൽ",
                "വെൽഡിംഗ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нүдний шил"),
            keywords: &["гагнуур", "нүдний хамгаалалт", "нүдний шил", "усанд сэлэлт"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("गॉगल\u{94d}स"),
            keywords: &[
                "गॉगल\u{94d}स",
                "जोडण\u{947}",
                "डोळ\u{94d}याच\u{947} स\u{902}रक\u{94d}षण",
                "पोहण\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("gogal"),
            keywords: &["berenang", "gogal", "mengimpal", "perlindungan mata"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လေ/ရေကာ မျက\u{103a}မ\u{103e}န\u{103a}"),
            keywords: &[
                "ဂဟေဆော\u{103a}ခြင\u{103a}း",
                "မျက\u{103a}လ\u{102f}\u{1036}းကာက\u{103d}ယ\u{103a}ခြင\u{103a}း",
                "ရေက\u{1030}းခြင\u{103a}း",
                "လေ/ရေကာ မျက\u{103a}မ\u{103e}န\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("beskyttelsesbriller"),
            keywords: &["beskyttelsesbriller", "sveising", "svømming", "øyevern"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("शितल\u{941} चस\u{94d}मा"),
            keywords: &[
                "आ\u{901}खाको स\u{941}रक\u{94d}षा",
                "पौ\u{901}डी ख\u{947}ल\u{94d}न\u{947} कार\u{94d}य",
                "व\u{947}ल\u{94d}डिङ",
                "शितल\u{941} चस\u{94d}मा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("oogscherm"),
            keywords: &["lassen", "oogbescherming", "oogscherm", "zwemmen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("vernebriller"),
            keywords: &["augevern", "sveising", "symjing", "vernebriller"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଚଷମ\u{b3e}"),
            keywords: &[
                "ଆଖ\u{b3f}ର ସ\u{b41}ରକ\u{b4d}ଷ\u{b3e}",
                "ଚଷମ\u{b3e}",
                "ଝଳେଇ",
                "ପହ\u{b01}ର\u{b3f}ବ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਧ\u{a41}\u{a71}ਪ ਤ\u{a4b}\u{a02} ਐਨਕਾ\u{a02}"),
            keywords: &[
                "ਅ\u{a71}ਖਾ\u{a02} ਦੀ ਸ\u{a41}ਰ\u{a71}ਖਿਆ ਲਈ ਐਨਕਾ\u{a02}",
                "ਤ\u{a48}ਰਾਕੀ ਲਈ ਐਨਕਾ\u{a02}",
                "ਧ\u{a41}\u{a71}ਪ ਤ\u{a4b}\u{a02} ਐਨਕਾ\u{a02}",
                "ਵ\u{a48}ਲਡਿ\u{a70}ਗ ਲਈ ਐਨਕਾ\u{a02}",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Gọ\u{301}guls"),
            keywords: &[
                "Gọ\u{301}guls",
                "Prótẹ\u{301}kt Ai",
                "Swímin",
                "Wẹ\u{301}ldin",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("okulary ochronne"),
            keywords: &["ochrona oczu", "okulary ochronne", "pływanie", "spawanie"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("عينکې"),
            keywords: &["د سترګو حفاظت", "عينکې", "لامبو وهل", "کوشيرول"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("óculos de proteção"),
            keywords: &[
                "natação",
                "proteção para os olhos",
                "soldagem",
                "óculos de proteção",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ochelari de protecție"),
            keywords: &[
                "ochelari de protecție",
                "protecția vederii",
                "sudură",
                "înot",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-019"),
            keywords: &["E11-019"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("защитные очки"),
            keywords: &["защита", "защитные очки", "лыжная маска", "маска", "очки"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("چشما"),
            keywords: &["اک جو تحفظ", "ترڻ", "ويلڊنگ", "چشما"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඇස\u{dca} ආවරණ"),
            keywords: &[
                "ඇස\u{dca} ආරක\u{dca}ෂ\u{dcf} ක\u{dd2}ර\u{dd3}ම",
                "ඇස\u{dca} ආවරණ",
                "ප\u{dd2}හ\u{dd2}න\u{dd3}ම",
                "වෙල\u{dca}ඩ\u{dd2}න\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ochranné okuliare"),
            keywords: &["ochrana očí", "ochranné okuliare", "plávanie", "zváranie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zaščitna očala"),
            keywords: &["plavanje", "varjenje", "zaščita oči", "zaščitna očala"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("murayaadaha ilaalinta"),
            keywords: &[
                "alxamida",
                "dabaasha",
                "ilaalinta isha",
                "muraayadaha ilaalinta",
                "murayaadaha ilaalinta",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("syze mbrojtëse"),
            keywords: &[
                "mbrojtëse për sytë",
                "syze mbrojtëse",
                "syze notimi",
                "syze saldimi",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("заштитне наочари"),
            keywords: &["варење", "заштита очију", "заштитне наочари", "пливање"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("заштитне наочари"),
            keywords: &["заштитне наочари"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("zaštitne naočari"),
            keywords: &["plivanje", "varenje", "zaštita očiju", "zaštitne naočari"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("zaštitne naočari"),
            keywords: &["zaštitne naočari"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("simglasögon"),
            keywords: &["simglasögon", "simma", "svetsning", "ögonskydd"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("miwani ya kuogelea"),
            keywords: &[
                "kufua vyuma",
                "kuogelea",
                "linda macho",
                "miwani ya kuogelea",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கண\u{bcd}ண\u{bbe}டிகள\u{bcd}"),
            keywords: &[
                "கண\u{bcd} ப\u{bbe}துக\u{bbe}ப\u{bcd}பு",
                "கண\u{bcd}ண\u{bbe}டிகள\u{bcd}",
                "ந\u{bc0}ச\u{bcd}சல\u{bcd}",
                "வெல\u{bcd}டிங\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("గ\u{c3e}గుల\u{c4d}స\u{c4d}"),
            keywords: &[
                "ఈత",
                "కంట\u{c3f} రక\u{c4d}షణ",
                "గ\u{c3e}గుల\u{c4d}స\u{c4d}",
                "వ\u{c46}ల\u{c4d}డ\u{c3f}ంగ\u{c4d}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แว\u{e48}นตาก\u{e31}นลม"),
            keywords: &[
                "แว\u{e48}นตาก\u{e31}นลม",
                "แว\u{e48}นตาว\u{e48}ายน\u{e49}ำ",
                "แว\u{e48}นป\u{e49}องก\u{e31}นดวงตา",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("goraýjy äýnek"),
            keywords: &["goraýjy äýnek", "göz goragy", "kebşirleme", "ýüzmek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sioʻata malu"),
            keywords: &["sioʻata malu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("koruyucu gözlük"),
            keywords: &["göz koruması", "kaynak", "koruyucu gözlük", "yüzme"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("захисні окуляри"),
            keywords: &[
                "захисні окуляри",
                "захист",
                "захист очей",
                "зварювання",
                "плавання",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گاگل"),
            keywords: &["آنکھوں کا تحفظ", "تیراکی", "ویلڈنگ", "گاگل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("himoya ko‘zoynagi"),
            keywords: &[
                "himoya ko‘zoynagi",
                "ko‘zni himoyalash",
                "ko‘zoynak",
                "payvandlash",
                "quyosh ko‘zoynagi",
                "suzish ko‘zoynagi",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("kính bảo hộ"),
            keywords: &["bơi", "bảo vệ mắt", "hàn", "kính bảo hộ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("護鏡"),
            keywords: &["保護眼睛", "游水", "燒焊", "護鏡"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("护镜"),
            keywords: &["保护眼睛", "护镜", "游水", "烧焊"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("护目镜"),
            keywords: &["护目镜", "护眼", "游泳", "焊接"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("蛙鏡"),
            keywords: &["保護眼睛", "游泳", "焊工", "蛙鏡"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["游泳", "焊工", "蛙鏡", "護眼罩"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("izibuko zokuzivikela"),
            keywords: &[
                "eye protection",
                "izibuko zokuzivikela",
                "ukubhukuda",
                "ukushisela",
            ],
        },
    ],
};
#[doc = "🥼"]
pub const LAB_COAT: crate::Emoji = crate::Emoji {
    glyph: "🥼",
    codepoint: "1F97C",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "lab coat",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("laboratoriumjas"),
            keywords: &["dokter", "eksperiment", "laboratoriumjas", "wetenskaplike"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የቤተ ሙከራ ቤት"),
            keywords: &["ሙከራ", "ሳይንቲስት", "የቤተ ሙከራ ቤት", "ዶክተር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("معطف مختبر"),
            keywords: &[
                "تجارب",
                "حكيم",
                "دكتور",
                "طبيب",
                "عالم",
                "علوم",
                "مختبرات",
                "معطف مختبر",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("গৱেষণ\u{9be}গ\u{9be}ৰত পিন\u{9cd}ধ\u{9be} কোট"),
            keywords: &[
                "অভিজ\u{9cd}ঞত\u{9be}",
                "গৱেষণ\u{9be}গ\u{9be}ৰত পিন\u{9cd}ধ\u{9be} কোট",
                "চিকিৎসক",
                "বৈজ\u{9cd}ঞ\u{9be}নিক",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("laboratoriya geyimi"),
            keywords: &["həkim", "laboratoriya geyimi", "qaynaq", "təcrübə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("лабараторны халат"),
            keywords: &["вучоны", "доктар", "лабараторны халат", "эксперымент"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("лабораторна престилка"),
            keywords: &["доктор", "експеримент", "лабораторна престилка", "учен"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ল\u{9cd}য\u{9be}ব কোট"),
            keywords: &[
                "গবেষণ\u{9be}",
                "ড\u{9be}ক\u{9cd}ত\u{9be}র",
                "বিজ\u{9cd}ঞ\u{9be}নী",
                "ল\u{9cd}য\u{9be}ব কোট",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("flotantenn wenn"),
            keywords: &["doktor", "flotantenn wenn", "skiantour"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("laboratorijski mantil"),
            keywords: &[
                "doktor",
                "doktorica",
                "eksperiment",
                "laboratorijski mantil",
                "naučnica",
                "naučnik",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bata de laboratori"),
            keywords: &["bata de laboratori", "científic", "doctor", "experiment"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎦᏛᏙᏗ ᎧᏅᏑᎸ ᎦᏌᎴᎾ"),
            keywords: &["ᎠᎦᏛᏂᏓᏍᏗ", "ᎠᎦᏛᏙᏗ ᎧᏅᏑᎸ ᎦᏌᎴᎾ", "ᎠᏏᎾᏍᏏ ᎠᎦᏔᎿᎢ", "ᎦᎾᎦᏘ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("laboratorní plášť"),
            keywords: &[
                "doktor",
                "experiment",
                "laboratorní plášť",
                "lékař",
                "pokus",
                "vědec",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cot lab"),
            keywords: &["arbrawf", "cot lab", "gwyddonydd", "meddyg"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kittel"),
            keywords: &["eksperiment", "forsker", "kittel", "læge"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Laborkittel"),
            keywords: &["Doktor", "Experiment", "Laborkittel", "Wissenschaftler"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ρόμπα εργαστηρίου"),
            keywords: &["γιατρός", "επιστήμονας", "πείραμα", "ρόμπα εργαστηρίου"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("lab coat"),
            keywords: &["doctor", "experiment", "lab coat", "scientist"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bata de laboratorio"),
            keywords: &[
                "bata de laboratorio",
                "científico",
                "doctor",
                "experimento",
                "médico",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("bata de laboratorio"),
            keywords: &["bata de laboratorio", "científico", "experimento", "médico"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("bata de laboratorio"),
            keywords: &["bata de laboratorio"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("laborikittel"),
            keywords: &["arst", "katse", "laborant", "laborikittel", "teadlane"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("laborategiko jantzia"),
            keywords: &[
                "esperimentu",
                "laborategiko jantzia",
                "mediku",
                "zientzialari",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("روپوش آزمایشگاه"),
            keywords: &["آزمایش", "دانشمند", "دکتر", "روپوش آزمایشگاه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("laboratoriotakki"),
            keywords: &[
                "koe",
                "laboratoriotakki",
                "lääkärintakki",
                "tohtori",
                "tutkija",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kapa sa lab"),
            keywords: &[
                "doktor",
                "eksperimento",
                "kapa sa lab",
                "lab coat",
                "siyentista",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kittil"),
            keywords: &["kittil", "lækni", "náttúruvísind", "roynd"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("blouse blanche"),
            keywords: &["blouse blanche", "docteur", "expérience", "scientifique"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["blouse blanche", "docteur", "expérience", "scientifique"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cóta saotharlainne"),
            keywords: &["cóta saotharlainne", "doctúir", "eolaí", "turgnamh"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("còta deuchainn-lainn"),
            keywords: &[
                "còta deuchainn-lainn",
                "deuchainn",
                "dotair",
                "ollamh",
                "saidheans",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("bata branca"),
            keywords: &[
                "bata branca",
                "científica",
                "laboratorio",
                "médica",
                "médico",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લ\u{ac7}બ કોટ"),
            keywords: &["લ\u{ac7}બ કોટ"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חלוק מעבדה"),
            keywords: &["חוקר", "חלוק מעבדה", "מדען", "רופא"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ल\u{948}ब कोट"),
            keywords: &[
                "डॉक\u{94d}टर",
                "प\u{94d}रयोग",
                "ल\u{948}ब कोट",
                "व\u{948}ज\u{94d}ञानिक",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("laboratorijska kuta"),
            keywords: &[
                "eksperiment",
                "laboratorijska kuta",
                "liječnik",
                "znanstvenik",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("laborköpeny"),
            keywords: &["kísérlet", "laborköpeny", "orvos", "tudós"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սպիտակ խալաթ"),
            keywords: &["բժիշկ", "գիտնական", "սպիտակ խալաթ", "փորձարկում"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("jas laboratorium"),
            keywords: &["dokter", "ilmuwan", "jas laboratorium", "percobaan"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("læknasloppur"),
            keywords: &["læknasloppur", "læknir", "tilraun", "vísindamaður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("camice"),
            keywords: &["camice", "dottore", "esperimento", "scienziato"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("白衣"),
            keywords: &["医者", "実験", "白衣", "科学者"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("jas lab"),
            keywords: &["dokter", "eksperimen", "ilmuwan", "jas lab"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ლაბორატორიის კოსტიუმი"),
            keywords: &["ექიმი", "ექსპერიმენტი", "ლაბორატორიის კოსტიუმი", "მეცნიერი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("зертханалық киім"),
            keywords: &["дәрігер", "зертханалық киім", "тәжірибе", "ғалым"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("អាវមន\u{17d2}ទ\u{17b8}រព\u{17b7}សោធន\u{17cd}"),
            keywords: &[
                "ព\u{17b7}សោធន\u{17cd}",
                "វេជ\u{17d2}ជបណ\u{17d2}ឌ\u{17b7}ត",
                "អាវមន\u{17d2}ទ\u{17b8}រព\u{17b7}សោធន\u{17cd}",
                "អ\u{17d2}នកវ\u{17b7}ទ\u{17d2}យាសាស\u{17d2}ត\u{17d2}រ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಲ\u{ccd}ಯಾಬ\u{ccd} ಕೋಟ\u{ccd}"),
            keywords: &[
                "ಪ\u{ccd}ರಯೋಗ",
                "ಲ\u{ccd}ಯಾಬ\u{ccd} ಕೋಟ\u{ccd}",
                "ವ\u{cbf}ಜ\u{ccd}ಞಾನ\u{cbf}",
                "ವೈದ\u{ccd}ಯ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("실험실 가운"),
            keywords: &["과학자", "실험실", "실험실 가운", "의사"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ल\u{945}ब कोट"),
            keywords: &[
                "दोतोर",
                "प\u{94d}रयोग",
                "ल\u{945}ब कोट",
                "शास\u{94d}त\u{94d}रज\u{94d}ञ",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("лаборатория халаты"),
            keywords: &["доктор", "лаборатория халаты", "окумуштуу", "тажрыйба"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ທ\u{ec8}ານໝ\u{ecd}"),
            keywords: &[
                "ການທ\u{ebb}ດລອງ",
                "ທ\u{ec8}ານໝ\u{ecd}",
                "ນ\u{eb1}ກວ\u{eb4}ທະຍາສາດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("laboratorinis chalatas"),
            keywords: &[
                "bandymas",
                "gydytojas",
                "laboratorinis chalatas",
                "mokslininkas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("laboratorijas halāts"),
            keywords: &[
                "eksperiments",
                "laboratorijas halāts",
                "zinātnieks",
                "ārsts",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("мантил"),
            keywords: &["доктор", "експеримент", "мантил", "научник"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ല\u{d3e}ബ\u{d4d} കോട\u{d4d}ട\u{d4d}"),
            keywords: &[
                "ഡോക\u{d4d}\u{200c}ടർ",
                "പരീക\u{d4d}ഷണം",
                "ല\u{d3e}ബ\u{d4d} കോട\u{d4d}ട\u{d4d}",
                "ശ\u{d3e}സ\u{d4d}\u{200c}ത\u{d4d}രജ\u{d4d}ഞൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("лабораторын өмсгөл"),
            keywords: &["лабораторын өмсгөл", "туршилт", "шинжлэх ухаанч", "эмч"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ल\u{945}ब कोट"),
            keywords: &[
                "डॉक\u{94d}टर",
                "प\u{94d}रयोग",
                "ल\u{945}ब कोट",
                "शास\u{94d}त\u{94d}रज\u{94d}ञ",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kot makmal"),
            keywords: &["doktor", "eksperimen", "kot makmal", "saintis"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စမ\u{103a}းသပ\u{103a}ခန\u{103a}း ဝတ\u{103a}စ\u{102f}\u{1036}"),
            keywords: &[
                "စမ\u{103a}းသပ\u{103a}ခန\u{103a}း ဝတ\u{103a}စ\u{102f}\u{1036}",
                "စမ\u{103a}းသပ\u{103a}ခြင\u{103a}း",
                "ဆရာဝန\u{103a}",
                "သ\u{102d}ပ\u{1039}ပ\u{1036}ပညာရ\u{103e}င\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("labfrakk"),
            keywords: &["doktor", "eksperiment", "forsker", "labfrakk", "lege"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{94d}रयोगशालाको कोट"),
            keywords: &[
                "चिकित\u{94d}सक",
                "प\u{94d}रयोग",
                "प\u{94d}रयोगशालाको कोट",
                "व\u{948}ज\u{94d}ञानिक",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("labjas"),
            keywords: &["dokter", "experiment", "labjas", "wetenschapper"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("labfrakk"),
            keywords: &["dokter", "eksperiment", "forskar", "labfrakk", "lege"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b4d}ରୟୋଗଶ\u{b3e}ଳ କୋଟ\u{b4d}\u{200c}"),
            keywords: &[
                "ଡକ\u{b4d}ଟର",
                "ପରୀକ\u{b4d}ଷଣ",
                "ପ\u{b4d}ରୟୋଗଶ\u{b3e}ଳ କୋଟ\u{b4d}\u{200c}",
                "ବୈଜ\u{b4d}ଞ\u{b3e}ନ\u{b3f}କ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲ\u{a48}ਬ ਵਿ\u{a71}ਚ ਪਹਿਨਣ ਵਾਲਾ ਕ\u{a4b}ਟ"),
            keywords: &[
                "ਡਾਕਟਰ",
                "ਪ\u{a4d}ਰਯ\u{a4b}ਗ",
                "ਲ\u{a48}ਬ ਵਿ\u{a71}ਚ ਪਹਿਨਣ ਵਾਲਾ ਕ\u{a4b}ਟ",
                "ਵਿਗਿਆਨੀ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Láb Kot"),
            keywords: &[
                "Dọ\u{301}ktọ",
                "Láb Kot",
                "Sayẹ\u{301}ns Ẹ\u{301}spat",
                "Ẹspẹ\u{301}rímẹnt",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("biały fartuch"),
            keywords: &[
                "biały fartuch",
                "eksperyment",
                "kitel",
                "lekarz",
                "naukowiec",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د لابراتور کرتۍ"),
            keywords: &["د لابراتور کرتۍ", "سائينس دان", "څېړنه", "ډاکټر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("jaleco"),
            keywords: &["cientista", "experiência", "jaleco", "médico"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("bata de laboratório"),
            keywords: &["bata de laboratório", "cientista", "experiência", "médico"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("halat de laborator"),
            keywords: &[
                "doctor",
                "experiment",
                "halat de laborator",
                "om de știință",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-018"),
            keywords: &["E11-018"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("лабораторный халат"),
            keywords: &[
                "белый халат",
                "лаборатория",
                "лабораторный халат",
                "форма",
                "халат",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ليب ڪوٽ"),
            keywords: &["تجربو", "سائنسدان", "ليب ڪوٽ", "ڊاڪٽر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පර\u{dd3}ක\u{dca}ෂණ\u{dcf}ග\u{dcf}ර කබ\u{dcf}ය"),
            keywords: &[
                "අත\u{dca}හද\u{dcf} බැල\u{dd3}ම\u{dca}",
                "පර\u{dd3}ක\u{dca}ෂණ\u{dcf}ග\u{dcf}ර කබ\u{dcf}ය",
                "ව\u{dd2}ද\u{dca}\u{200d}ය\u{dcf}ඥය\u{dcf}",
                "වෛද\u{dca}\u{200d}යවරය\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("laboratórny plášť"),
            keywords: &["doktor", "laboratórny plášť", "pokus", "vedec"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("laboratorijska halja"),
            keywords: &[
                "eksperiment",
                "laboratorijska halja",
                "zdravnik",
                "znanstvenik",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("koodhka laabka"),
            keywords: &["dhakhtar", "koodhka laabka", "saynis yahan", "tijaabo"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("pardesy laboratori"),
            keywords: &["doktor", "eksperiment", "pardesy laboratori", "shkencëtar"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("бели мантил"),
            keywords: &["бели мантил", "доктор", "експеримент", "научник"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("бијели мантил"),
            keywords: &["бијели мантил", "доктор", "експеримент", "научник"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("beli mantil"),
            keywords: &["beli mantil", "doktor", "eksperiment", "naučnik"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("bijeli mantil"),
            keywords: &["bijeli mantil", "doktor", "eksperiment", "naučnik"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("labbrock"),
            keywords: &["doktor", "experiment", "labbrock", "vetenskapsman"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("koti jeupe"),
            keywords: &["daktari", "koti jeupe", "maabara", "mwanasayansi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆய\u{bcd}வக உடை"),
            keywords: &[
                "ஆய\u{bcd}வக உடை",
                "பரிசோதனை",
                "மருத\u{bcd}துவர\u{bcd}",
                "விஞ\u{bcd}ஞ\u{bbe}னி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ల\u{c4d}య\u{c3e}బ\u{c4d} క\u{c4b}టు"),
            keywords: &[
                "ప\u{c4d}రయ\u{c4b}గం",
                "ల\u{c4d}య\u{c3e}బ\u{c4d} క\u{c4b}టు",
                "వ\u{c48}ద\u{c4d}యులు",
                "శ\u{c3e}స\u{c4d}త\u{c4d}రవ\u{c47}త\u{c4d}త",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เส\u{e37}\u{e49}อกาวน\u{e4c}"),
            keywords: &[
                "การทดลอง",
                "น\u{e31}กว\u{e34}ทยาศาสตร\u{e4c}",
                "หมอ",
                "เส\u{e37}\u{e49}อกาวน\u{e4c}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("barlaghana halady"),
            keywords: &["alym", "barlaghana halady", "lukman", "tejribe"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kote kemi"),
            keywords: &["kote kemi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("laboratuvar önlüğü"),
            keywords: &["bilim insanı", "deney", "doktor", "laboratuvar önlüğü"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("лабораторний халат"),
            keywords: &[
                "доктор",
                "експеримент",
                "лабораторний халат",
                "лікар",
                "науковець",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("لیب میں پہننے والا کوٹ"),
            keywords: &["تجربہ", "سائنسدان", "لیب میں پہننے والا کوٹ", "ڈاکٹر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("laboratoriya xalati"),
            keywords: &[
                "doktor",
                "laboratoriya",
                "laboratoriya xalati",
                "olim",
                "oq xalat",
                "tajriba",
                "xalat",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("áo phòng thí nghiệm"),
            keywords: &[
                "bác sĩ",
                "nhà khoa học",
                "thí nghiệm",
                "áo phòng thí nghiệm",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("實驗袍"),
            keywords: &["實驗", "實驗袍", "科學家", "醫生"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("实验袍"),
            keywords: &["医生", "实验", "实验袍", "科学家"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("白大褂"),
            keywords: &["医生", "实验人员", "白大褂", "科学家"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("實驗袍"),
            keywords: &["實驗", "實驗袍", "科學家", "醫生"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("lab coat"),
            keywords: &["doctor", "experiment", "lab coat", "scientist"],
        },
    ],
};
#[doc = "🦺"]
pub const SAFETY_VEST: crate::Emoji = crate::Emoji {
    glyph: "🦺",
    codepoint: "1F9BA",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "safety vest",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("veiligheidsonderbaadjie"),
            keywords: &[
                "nooddiens",
                "noodgeval",
                "onderbaadjie",
                "veiligheid",
                "veiligheidsonderbaadjie",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የአደጋ መከላከያ ልብስ"),
            keywords: &["ልብስ", "የአደጋ መከላከያ ልብስ", "ደህንነት", "ድንገተኛ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سترة سلامة"),
            keywords: &["أمان", "سترة", "سلامة", "صديري", "صرية", "طوارئ", "ملابس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("স\u{9c1}ৰক\u{9cd}ষ\u{9be} কবচ"),
            keywords: &[
                "গেঞ\u{9cd}জী",
                "জৰ\u{9c1}ৰীক\u{9be}লীন",
                "স\u{9c1}ৰক\u{9cd}ষ\u{9be}",
                "স\u{9c1}ৰক\u{9cd}ষ\u{9be} কবচ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("güvənlik jaketi"),
            keywords: &["güvənlik", "güvənlik jaketi", "jaket", "təcililik"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сігнальная камізэлька"),
            keywords: &["засцерагальная", "камізэлька", "сігнальная"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("светлоотразителна жилетка"),
            keywords: &[
                "безопасност",
                "жилетка",
                "светлоотразителна жилетка",
                "спешен случай",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("সেফ\u{9cd}টি জ\u{9cd}য\u{9be}কেট"),
            keywords: &[
                "জর\u{9c1}রী অবস\u{9cd}থ\u{9be}",
                "জ\u{9cd}য\u{9be}কেট",
                "নির\u{9be}পত\u{9cd}ত\u{9be}",
                "সেফ\u{9cd}টি জ\u{9cd}য\u{9be}কেট",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("jiletenn surentez"),
            keywords: &["jiletenn", "surentez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("sigurnosni prsluk"),
            keywords: &["opasnost", "prsluk", "sigurnosni prsluk", "sigurnost"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("armilla salvavides"),
            keywords: &["armilla", "armilla salvavides", "emergència", "seguretat"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏄᎾᏰᎯᏍᏛᎾ ᏪᏍᏗ"),
            keywords: &["ᎤᎵᏍᏓ ᎢᎦᎵᏍᏗᏍᎩ", "ᏄᎾᏰᎯᏍᏛᎾ", "ᏪᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("bezpečnostní vesta"),
            keywords: &[
                "bezpečnost",
                "bezpečnostní vesta",
                "nouze",
                "reflexní",
                "vesta",
                "výstražná",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("siaced ddiogelwch"),
            keywords: &["argyfwng", "diogelwch", "siaced", "siaced ddiogelwch"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sikkerhedsvest"),
            keywords: &["nødsituation", "sikkerhed", "sikkerhedsvest", "vest"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Sicherheitsweste"),
            keywords: &["Notfall", "Sicherheit", "Sicherheitsweste", "Weste"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γιλέκο ασφαλείας"),
            keywords: &["έκτακτη ανάγκη", "ασφάλεια", "γιλέκο", "γιλέκο ασφαλείας"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("safety vest"),
            keywords: &["emergency", "safety", "vest"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &[
                "emergency",
                "hi-vis",
                "high-vis",
                "jacket",
                "life jacket",
                "safety",
                "vest",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &[
                "emergency",
                "hi-vis",
                "high-vis",
                "jacket",
                "life jacket",
                "safety",
                "vest",
            ],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("chaleco de seguridad"),
            keywords: &["chaleco", "chaleco de seguridad", "emergencia", "seguridad"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("ohutusvest"),
            keywords: &["hädaolukord", "ohutus", "ohutusvest", "vest"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("segurtasun-jaka"),
            keywords: &["jaka", "larrialdi", "segurtasun", "segurtasun-jaka"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("جلیقه ایمنی"),
            keywords: &["اورژانس", "ایمنی", "جلیقه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("turvaliivi"),
            keywords: &["hätätilanne", "liivi", "turvaliivi", "turvallisuus"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("life vest"),
            keywords: &["kaligtasan", "life vest", "pang-emergency"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("trygdarvestur"),
            keywords: &["trygd", "trygdarvestur", "vestur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("gilet de sécurité"),
            keywords: &[
                "fluo",
                "gilet de sécurité",
                "gilet jaune",
                "sécurité",
                "sûreté",
                "visibilité",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("veste de sécurité"),
            keywords: &["sécurité", "urgence", "veste", "veste de sécurité"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("veist sábháilteachta"),
            keywords: &[
                "sábháilteacht",
                "veist",
                "veist sábháilteachta",
                "éigeandáil",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("èideadh sàbhailteachd"),
            keywords: &[
                "peiteag",
                "sàbhailteachd",
                "èideadh sàbhailteachd",
                "èiginn",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("chaleco salvavidas"),
            keywords: &[
                "chaleco salvavidas",
                "emerxencia",
                "salvavidas",
                "seguranza",
                "seguridade",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{ac1}રક\u{acd}ષા જ\u{ac7}ક\u{ac7}ટ"),
            keywords: &["કટોકટી", "જ\u{ac7}ક\u{ac7}ટ", "સ\u{ac1}રક\u{acd}ષા"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אפוד בטיחות"),
            keywords: &["אפוד", "בטיחות", "חירום"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("रक\u{94d}षा ज\u{948}क\u{947}ट"),
            keywords: &[
                "आपातकाल",
                "आपातकालीन",
                "कवच",
                "ज\u{948}क\u{947}ट",
                "रक\u{94d}षा",
                "स\u{941}रक\u{94d}षा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("sigurnosni prsluk"),
            keywords: &["hitni slučaj", "prsluk", "sigurnosni prsluk", "sigurnost"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("mentőmellény"),
            keywords: &[
                "biztonság",
                "mellény",
                "mentő",
                "mentőmellény",
                "vészhelyzet",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("փրկաբաճկոն"),
            keywords: &[
                "անվտանգություն",
                "արտակարգ իրավիճակ",
                "բաճկոն",
                "փրկաբաճկոն",
                "փրկություն",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("rompi pengaman"),
            keywords: &["darurat", "keselamatan", "pengaman", "rompi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("öryggisvesti"),
            keywords: &["neyðartilfelli", "vesti", "öryggi", "öryggisvesti"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("gilet di sicurezza"),
            keywords: &[
                "antinfortunistica",
                "emergenza",
                "gilet antinfortunistica",
                "gilet di sicurezza",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("安全ベスト"),
            keywords: &["チョッキ", "ベスト", "反射", "安全ベスト", "工事", "緊急"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rompi keslametan"),
            keywords: &["darurat", "keslametan", "rompi"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("უსაფრთხოების ჟილეტი"),
            keywords: &[
                "გადაუდებელი",
                "დახმარება",
                "ჟილეტი",
                "უსაფრთხოება",
                "უსაფრთხოების ჟილეტი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сигналдық жилет"),
            keywords: &["жилет", "сигналдық", "төтенше жағдай"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("អាវពោងស\u{17bb}វត\u{17d2}ថ\u{17b7}ភាព"),
            keywords: &[
                "គ\u{17d2}រាអាសន\u{17d2}ន",
                "ស\u{17bb}វត\u{17d2}ថ\u{17b7}ភាព",
                "អាវពោង",
                "អាវពោងស\u{17bb}វត\u{17d2}ថ\u{17b7}ភាព",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸುರಕ\u{ccd}ಷತ\u{cc6} ಕವಚ"),
            keywords: &[
                "ಕವಚ",
                "ತುರ\u{ccd}ತುಪರ\u{cbf}ಸ\u{ccd}ಥ\u{cbf}ತ\u{cbf}",
                "ಸುರಕ\u{ccd}ಷತ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("구명조끼"),
            keywords: &["구명조끼", "안전", "응급", "조끼"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("स\u{941}रक\u{94d}ष\u{947}चो कोट"),
            keywords: &[
                "आपात\u{94d}काळ",
                "कोट",
                "स\u{941}रक\u{94d}षा",
                "स\u{941}रक\u{94d}ष\u{947}चो कोट",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("коопсуздук жилети"),
            keywords: &["жилет", "коопсуздук", "коопсуздук жилети", "өзгөчө кырдаал"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເສ\u{eb7}\u{ec9}\u{200b}ອ\u{200b}ກ\u{eb1}ນ\u{200b}ໄພ"),
            keywords: &[
                "ປ\u{ec9}\u{200b}ອງ\u{200b}ກ\u{eb1}ນ",
                "ສ\u{eb8}ກ\u{200b}ເສ\u{eb5}ນ",
                "ເສ\u{eb7}\u{ec9}\u{200b}ອ",
                "ເສ\u{eb7}\u{ec9}\u{200b}ອ\u{200b}ກ\u{eb1}ນ\u{200b}ໄພ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("gelbėjimosi liemenė"),
            keywords: &["gelbėjimosi", "kritinė padėtis", "liemenė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("drošības veste"),
            keywords: &["drošība", "drošības veste", "veste", "ārkārtas"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("безбедносен елек"),
            keywords: &["безбедносен елек", "безбедност", "итен случај"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d41}രക\u{d4d}ഷ\u{d3e} വസ\u{d4d}\u{200c}ത\u{d4d}രം"),
            keywords: &[
                "അടിയന\u{d4d}തിരസഹചര\u{d4d}യം",
                "വസ\u{d4d}\u{200c}ത\u{d4d}രം",
                "സ\u{d41}രക\u{d4d}ഷ",
                "സ\u{d41}രക\u{d4d}ഷ\u{d3e} വസ\u{d4d}\u{200c}ത\u{d4d}രം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("аврах хантааз"),
            keywords: &["аврах", "осол", "тусламж", "хантааз"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{941}रक\u{94d}षा जाकिट"),
            keywords: &["आणीबाणी", "जाकिट", "स\u{941}रक\u{94d}षा"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("rompi keselamatan"),
            keywords: &["kecemasan", "keselamatan", "rompi"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လ\u{102f}\u{1036}ခြ\u{102f}\u{1036}ရေး ဂျာကင\u{103a}"),
            keywords: &[
                "လ\u{102f}\u{1036}ခြ\u{102f}\u{1036}ရေး",
                "လ\u{102f}\u{1036}ခြ\u{102f}\u{1036}ရေး ဂျာကင\u{103a}",
                "အရေးပေါ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("refleksvest"),
            keywords: &[
                "nødssituasjon",
                "refleks",
                "refleksvest",
                "sikkerhet",
                "vest",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{941}रक\u{94d}षा भ\u{947}स\u{94d}ट"),
            keywords: &[
                "आपत\u{94d}कालीन",
                "भ\u{947}स\u{94d}ट",
                "स\u{941}रक\u{94d}षा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("veilig\u{ad}heids\u{ad}vest"),
            keywords: &[
                "noodgeval",
                "veiligheid",
                "veilig\u{ad}heids\u{ad}vest",
                "vest",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("refleksvest"),
            keywords: &[
                "naudsituasjon",
                "refleks",
                "refleksvest",
                "tryggleik",
                "vest",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b41}ରକ\u{b4d}ଷ\u{b3e} ଜ\u{b3e}ମ\u{b3e}"),
            keywords: &[
                "ଆପ\u{b3e}ତକ\u{b3e}ଳୀନ",
                "ଜ\u{b3e}ମ\u{b3e}",
                "ସ\u{b41}ରକ\u{b4d}ଷ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a41}ਰ\u{a71}ਖਿਆ ਪ\u{a41}ਸ\u{a3c}ਾਕ"),
            keywords: &[
                "ਅਪਾਤਕਾਲੀ",
                "ਪ\u{a4b}ਸ\u{a3c}ਾਕ",
                "ਸ\u{a41}ਰ\u{a71}ਖਿਆ",
                "ਸ\u{a41}ਰ\u{a71}ਖਿਆ ਪ\u{a41}ਸ\u{a3c}ਾਕ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Klọt To Ték Kíp Pẹ\u{301}sin Sef"),
            keywords: &[
                "Imájẹ\u{301}nsi",
                "Klọt",
                "Klọt To Ték Kíp Pẹ\u{301}sin Sef",
                "Séfti",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kamizelka ratunkowa"),
            keywords: &[
                "kamizelka",
                "kamizelka ratunkowa",
                "ratowanie",
                "sytuacja awaryjna",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("حفاظتي ملابند"),
            keywords: &["بيړنه", "حفاظت", "حفاظتي ملابند", "سينه بند"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("colete salva-vidas"),
            keywords: &["colete", "colete salva-vidas", "emergência", "segurança"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("colete de segurança"),
            keywords: &["colete", "colete de segurança", "emergência", "segurança"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("vestă de siguranță"),
            keywords: &["siguranță", "urgență", "vestă", "vestă de siguranță"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–036"),
            keywords: &["E12–036"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("спасательный жилет"),
            keywords: &["жилет", "защитный", "спасательный", "спасать", "экстренный"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("تحفظ ڪوٽ"),
            keywords: &["ايمرجنسي", "تحفظ", "ڪوٽ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ආරක\u{dca}ෂක බැන\u{dd2}යම"),
            keywords: &[
                "ආරක\u{dca}ෂක බැන\u{dd2}යම",
                "ආරක\u{dca}ෂ\u{dcf}ව",
                "බැන\u{dd2}යම",
                "හද\u{dd2}ස\u{dd2}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("bezpečnostná vesta"),
            keywords: &[
                "bezpečnostná vesta",
                "bezpečnosť",
                "núdza",
                "reflexná",
                "vesta",
                "výstražná",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("varnostni jopič"),
            keywords: &["jopič", "reševalni", "v sili", "varnostni jopič"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("jaakeetka garbo-gaabka ah ee badbaadada"),
            keywords: &[
                "badbaadada",
                "jaakeet",
                "jaakeetka garbo-gaabka ah ee badbaadada",
                "xaalad degdeg ah",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("jelek sigurimi"),
            keywords: &["emergjencë", "jelek", "jelek sigurimi", "sigurim"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("прслук за спасавање"),
            keywords: &["безбедност", "прслук за спасавање", "хитан случај"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["прслук за спасавање"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("prsluk za spasavanje"),
            keywords: &["bezbednost", "hitan slučaj", "prsluk za spasavanje"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["prsluk za spasavanje"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("varselväst"),
            keywords: &["nöd", "säkerhet", "varselväst", "väst"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("jaketi la usalama"),
            keywords: &["dharura", "jaketi la usalama", "usalama"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ப\u{bbe}துக\u{bbe}ப\u{bcd}பு மேற\u{bcd}சட\u{bcd}டை"),
            keywords: &[
                "அவசர சூழல\u{bcd}",
                "ப\u{bbe}துக\u{bbe}ப\u{bcd}பு",
                "மேற\u{bcd}சட\u{bcd}டை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("భద\u{c4d}రత చ\u{c4a}క\u{c4d}క\u{c3e}"),
            keywords: &["అత\u{c4d}యవసరం", "చ\u{c4a}క\u{c4d}క\u{c3e}", "భద\u{c4d}రత"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เส\u{e37}\u{e49}อน\u{e34}รภ\u{e31}ย"),
            keywords: &[
                "ความปลอดภ\u{e31}ย",
                "ฉ\u{e38}กเฉ\u{e34}น",
                "เส\u{e37}\u{e49}อก\u{e31}\u{e4a}ก",
                "เส\u{e37}\u{e49}อน\u{e34}รภ\u{e31}ย",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("halas ediş gursakçasy"),
            keywords: &[
                "adatdan daşary ýagdaý",
                "gursakça",
                "halas ediş gursakçasy",
                "howpsuzlyk",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("vesi"),
            keywords: &["vesi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("güvenlik yeleği"),
            keywords: &["acil durum", "güvenlik", "güvenlik yeleği", "yelek"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("сигнальний жилет"),
            keywords: &[
                "аварійно-захисний",
                "аварійно-рятувальний",
                "жилет",
                "сигнальний жилет",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("حفاظتی واسکٹ"),
            keywords: &["ایمرجنسی", "حفاظت", "حفاظتی واسکٹ", "واسکٹ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qutqaruv kamzuli"),
            keywords: &[
                "favqulodda holat",
                "kamzul",
                "qutqarish",
                "qutqaruv kamzuli",
                "xavfsizlik",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("áo bảo hộ"),
            keywords: &["an toàn", "khẩn cấp", "áo", "áo bảo hộ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("救生衣"),
            keywords: &["安全", "救生衣", "緊急", "背心"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("救生衣"),
            keywords: &["安全", "救生衣", "紧急", "背心"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("救生衣"),
            keywords: &["安全", "救生衣", "紧急", "背心", "逃生"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("救生衣"),
            keywords: &["安全", "救生衣", "緊急狀況", "背心"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iveste yokuphepha"),
            keywords: &["iveste", "iveste yokuphepha", "okuphuthumayo", "ukuphepha"],
        },
    ],
};
#[doc = "👔"]
pub const NECKTIE: crate::Emoji = crate::Emoji {
    glyph: "👔",
    codepoint: "1F454",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "necktie",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("das"),
            keywords: &["das", "klere"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ከረባት"),
            keywords: &["አልባሳት", "ከረባት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("رابطة عنق"),
            keywords: &["رابطة عنق", "كرافتة", "ملابس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("নেকট\u{9be}ই"),
            keywords: &["নেকট\u{9be}ই", "পোছ\u{9be}ক"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qalstuk"),
            keywords: &["geyim", "qalstuk"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("гальштук"),
            keywords: &["адзенне", "гальштук"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("вратовръзка"),
            keywords: &["вратовръзка", "облекло"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("গল\u{9be}র ট\u{9be}ই"),
            keywords: &["গল\u{9be}র ট\u{9be}ই", "পোশ\u{9be}ক"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kravatenn"),
            keywords: &["dilhad", "kravatenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kravata"),
            keywords: &["kravata", "odjevni predmet"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("corbata"),
            keywords: &["corbata", "roba"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎭᏢᏗ"),
            keywords: &["ᎠᎭᏢᏗ", "ᎠᎭᏢᏗᎢ", "ᏗᎿᏬ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kravata"),
            keywords: &["kravata", "oblečení"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("tei"),
            keywords: &["dillad", "tei"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("slips"),
            keywords: &["beklædning", "slips"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Hemd mit Krawatte"),
            keywords: &["Hemd mit Krawatte", "Kleidung", "Kragen", "Schlips"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γραβάτα"),
            keywords: &["γραβάτα", "ρούχο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("necktie"),
            keywords: &["clothing", "necktie", "tie"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("tie"),
            keywords: &[""],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("tie"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("tie"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("corbata"),
            keywords: &["accesorio", "corbata", "ropa"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["camisa", "corbata", "ropa", "vestimenta"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("lips"),
            keywords: &["lips", "riided"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gorbata"),
            keywords: &["arropa", "gorbata"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کراوات"),
            keywords: &["پوشاک", "کراوات"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("solmio"),
            keywords: &["asuste", "kravatti", "solmio", "vaatteet"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kurbata"),
            keywords: &["damit", "kausotan", "kurbata", "necktie", "pormal"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("slips"),
            keywords: &["klæði", "skjúrta", "slips"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cravate"),
            keywords: &["cravate", "vêtements"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("carbhat"),
            keywords: &["carbhat", "éadaí"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("tàidh"),
            keywords: &["aodach", "tàidh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("gravata"),
            keywords: &["gravata"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ન\u{ac7}કટાઇ"),
            keywords: &["કપડા\u{a82}", "ટાઇ", "ન\u{ac7}કટાઇ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("taye"),
            keywords: &["sutura", "taye"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חולצה עם עניבה"),
            keywords: &["בגד", "חולצה", "חולצה עם עניבה", "מחויט", "עניבה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("न\u{947}कटाई"),
            keywords: &["टाई", "न\u{947}कटाई", "पोषाक"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kravata"),
            keywords: &["kravata", "odjeća"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nyakkendő"),
            keywords: &["elegancia", "nyakkendő", "ruházat"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("փողկապ"),
            keywords: &["հագուստ", "փողկապ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("dasi"),
            keywords: &["dasi", "pakaian"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("mmaolu akwà"),
            keywords: &["mmaolu akwà", "na-eme akwà"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hálsbindi"),
            keywords: &["bindi", "hálsbindi", "klæðnaður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cravatta"),
            keywords: &["abbigliamento", "cravatta"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ネクタイ"),
            keywords: &["シャツ", "ネクタイ", "ワイシャツ", "服"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("dasi"),
            keywords: &["dasi", "sandhangan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჰალსტუხი"),
            keywords: &["ტანსაცმელი", "ჰალსტუხი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("галстук"),
            keywords: &["галстук", "киім"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("slips"),
            keywords: &["beklædning", "slips"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ក\u{17d2}រវាត\u{17cb}កជាប\u{17cb}ន\u{17b9}ងអាវ"),
            keywords: &[
                "ក\u{17d2}រវាត\u{17cb}ក",
                "ក\u{17d2}រវាត\u{17cb}កជាប\u{17cb}ន\u{17b9}ងអាវ",
                "សម\u{17d2}លៀកប\u{17c6}ពាក\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನ\u{cc6}ಕ\u{ccd}\u{200c}ಟೈ"),
            keywords: &["ಉಡುಪು", "ನ\u{cc6}ಕ\u{ccd}\u{200c}ಟೈ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("넥타이"),
            keywords: &["넥타이", "샐러리맨", "타이"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("न\u{947}कटाय"),
            keywords: &["कपड\u{947}", "टाय", "न\u{947}कटाय"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("галстук"),
            keywords: &["галстук", "кийим"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Krawatt"),
            keywords: &["Kleedung", "Krawatt"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກາລະຫວ\u{eb1}ດ"),
            keywords: &["ກາລະຫວ\u{eb1}ດ", "ເສ\u{eb7}\u{ec9}ອຜ\u{ec9}າ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kaklaraištis"),
            keywords: &["drabužiai", "kaklaraištis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kaklasaite"),
            keywords: &["apģērbs", "drēbes", "kaklasaite"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("neketai"),
            keywords: &["kākahu", "neketai"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("вратоврска"),
            keywords: &["вратоврска", "облека"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("നെക\u{d4d}ക\u{d4d} ടൈ"),
            keywords: &["ടൈ", "നെക\u{d4d}ക\u{d4d} ടൈ", "വസ\u{d4d}ത\u{d4d}രം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зангиа"),
            keywords: &["зангиа", "хувцаслалт"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("टाय"),
            keywords: &["कपड\u{947}", "टाय", "न\u{947}कटाय"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tali leher"),
            keywords: &["pakaian", "tali leher"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ingravata"),
            keywords: &["ingravata", "ħwejjeġ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("နက\u{103a}ကတ\u{102d}\u{102f}င\u{103a}"),
            keywords: &["နက\u{103a}ကတ\u{102d}\u{102f}င\u{103a}", "ဝတ\u{103a}စရာ"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("slips"),
            keywords: &["klær", "slips"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("टाई"),
            keywords: &["कपडा", "टाई"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("stropdas"),
            keywords: &["kleding", "stropdas"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("slips"),
            keywords: &["klede", "slips"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ନେକଟ\u{b3e}ଏ"),
            keywords: &[
                "ଟ\u{b3e}ଏ",
                "ନେକଟ\u{b3e}ଏ",
                "ପୋଷକ ପର\u{b3f}ଚ\u{b4d}ଛଦ",
                "ବେକରଟ\u{b3e}ଏ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਟਾਈ"),
            keywords: &["ਟਾਈ", "ਲਿਬਾਸ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ٹائی"),
            keywords: &["ٹائی", "کپڑے"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tai"),
            keywords: &["Klọt", "Tai"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("krawat"),
            keywords: &["koszula", "krawat", "męski", "ozdoba"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("نیکټائي"),
            keywords: &["لباس", "نیکټائي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("gravata"),
            keywords: &["acessório", "gravata", "roupa"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["acessório", "gravata", "vestuário"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("corbata"),
            keywords: &["corbata"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cravată"),
            keywords: &["cravată", "îmbrăcăminte"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-529"),
            keywords: &["E10-529"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("галстук"),
            keywords: &["галстук", "завязывать", "одежда", "рубашка", "узел"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("karuvati"),
            keywords: &["imyambaro", "karuvati"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٽائي"),
            keywords: &["ٽائي", "ڪپڙا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ගෙළ පට\u{dd2}ය"),
            keywords: &["ඇඳ\u{dd4}\u{dd4}ම\u{dca}", "ගෙළ පට\u{dd2}ය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kravata"),
            keywords: &["kravata", "oblečenie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kravata"),
            keywords: &["kravata", "oblačila"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("taayga qoorta"),
            keywords: &["dhar", "taay", "taayga qoorta"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kravatë"),
            keywords: &["kravatë", "veshje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кравата"),
            keywords: &["кравата", "одећа"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["кравата"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kravata"),
            keywords: &["kravata", "odeća"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["kravata"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("skjorta med slips"),
            keywords: &["kläder", "skjorta", "skjorta med slips", "slips"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("tai"),
            keywords: &["mavazi", "tai"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கழுத\u{bcd}து டை"),
            keywords: &["ஆடை அணிகலன\u{bcd}", "கழுத\u{bcd}து டை", "டை", "துணி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("న\u{c46}క\u{c4d} ట\u{c48}"),
            keywords: &["ట\u{c48}", "న\u{c46}క\u{c4d}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("галстук"),
            keywords: &["галстук", "пӯшок"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เนคไท"),
            keywords: &["เนคไท", "เส\u{e37}\u{e49}อผ\u{e49}า"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("boýunbagy"),
            keywords: &["boýunbagy", "egin-eşik", "galstuk"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("hēkesi"),
            keywords: &["hēkesi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kravat"),
            keywords: &["giyim", "kravat"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("گالىستۇك"),
            keywords: &["كىيىم-كېچەك", "گالىستۇك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("краватка"),
            keywords: &["краватка", "одяг"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("نیکٹائی"),
            keywords: &["لباس", "نیک ٹائی", "نیکٹائی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("bo‘yinbog‘"),
            keywords: &["boʻyinbogʻ", "bo‘yinbog‘", "galstuk", "kiyim"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cà vạt"),
            keywords: &["cà vạt", "quần áo"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("karawaat"),
            keywords: &["karawaat", "yéere"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqhina"),
            keywords: &["impahla", "iqhina"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Okùnọrùn"),
            keywords: &["Okùnọrùn", "Wíwọṣọ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("領呔"),
            keywords: &["服裝", "領呔"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("领呔"),
            keywords: &["服装", "领呔"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("领带"),
            keywords: &["衬衫领带", "领带"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("領帶"),
            keywords: &["領帶"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("領呔"),
            keywords: &["領呔"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uthayi womqala"),
            keywords: &["impahla yokugqoka", "uthayi womqala"],
        },
    ],
};
#[doc = "👕"]
pub const T_SHIRT: crate::Emoji = crate::Emoji {
    glyph: "👕",
    codepoint: "1F455",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "t-shirt",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("t-hemp"),
            keywords: &["hemp", "klere", "t-hemp"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቲሸርት"),
            keywords: &["ሸሚዝ", "ቲሸርት", "አልባሳት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("تي شيرت"),
            keywords: &["تي شيرت", "قميص", "ملابس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("টিচ\u{9be}ৰ\u{9cd}ট"),
            keywords: &[
                "চ\u{9be}ৰ\u{9cd}ট",
                "টি-চ\u{9be}ৰ\u{9cd}ট",
                "টিচ\u{9be}ৰ\u{9cd}ট",
                "পোছ\u{9be}ক",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("köynək"),
            keywords: &["futbolka", "geyim", "köynək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("футболка"),
            keywords: &["адзенне", "кашуля", "майка", "саколка", "футболка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("тениска"),
            keywords: &["облекло", "тениска"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("টি-শ\u{9be}র\u{9cd}ট"),
            keywords: &[
                "টি শ\u{9be}র\u{9cd}ট",
                "টি-শ\u{9be}র\u{9cd}ট",
                "পোশ\u{9be}ক",
                "শ\u{9be}র\u{9cd}ট",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("tee-shirt"),
            keywords: &["dilhad", "tee-shirt"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("majica kratkih rukava"),
            keywords: &["majica", "majica kratkih rukava", "odjevni predmet"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("samarreta"),
            keywords: &["roba", "samarreta"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎭᏫᎾ-ᎠᎿᏬᏍᏗ"),
            keywords: &["ᎠᎿᏬ", "ᎭᏫᎾ-ᎠᎿᏬᏍᏗ", "ᏗᎿᏬ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("tričko"),
            keywords: &["košile", "oblečení", "triko", "tričko"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("crys T"),
            keywords: &["crys", "crys T", "dillad"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("T-shirt"),
            keywords: &["T-shirt", "beklædning", "bluse", "trøje"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("T-Shirt"),
            keywords: &["Kleidung", "Shirt", "T-Shirt"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μπλουζάκι"),
            keywords: &["μπλουζάκι", "μπλούζα", "πουκάμισο", "ρούχο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("t-shirt"),
            keywords: &["clothing", "shirt", "t-shirt", "tshirt"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("T-shirt"),
            keywords: &["T-shirt", "clothing", "shirt", "tshirt"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["T-shirt", "clothing", "shirt", "t-shirt", "tee", "tshirt"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "T-shirt",
                "clothing",
                "shirt",
                "t-shirt",
                "tee-shirt",
                "tshirt",
            ],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("camiseta"),
            keywords: &["camiseta", "ropa"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["camiseta", "remera", "ropa", "vestimenta"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["camiseta", "playera", "ropa", "vestimenta"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["camiseta", "ropa", "t-shirt", "vestimenta"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("T-särk"),
            keywords: &["T-särk", "riided", "särk", "t-särk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("elastikoa"),
            keywords: &["alkandora", "arropa", "elastiko", "elastikoa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تی\u{200c}شرت"),
            keywords: &["بلوز", "تی\u{200c}شرت", "پوشاک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("t-paita"),
            keywords: &["paita", "t-paita", "vaatteet"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kamiseta"),
            keywords: &["damit", "kamiseta", "kasuotan", "shirt", "t-shirt"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("t-shirt"),
            keywords: &["klæði", "skjúrta", "t-shirt", "tshirt"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("T-shirt"),
            keywords: &["T-shirt", "tee-shirt", "vêtements"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["T-shirt", "chandail", "gaminet", "tee-shirt", "vêtements"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("t-léine"),
            keywords: &["t-léine", "éadaí"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("lèine-t"),
            keywords: &["aodach", "lèine", "lèine-t"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("camiseta"),
            keywords: &["camiseta"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ટી-શર\u{acd}ટ"),
            keywords: &["કપડા\u{a82}", "ટી-શર\u{acd}ટ", "શર\u{acd}ટ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ti-shat"),
            keywords: &["riga", "sutura", "ti-shat", "tshat"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חולצת טי"),
            keywords: &["בגד", "חולצה", "חולצת טי", "חולצת טריקו"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("टी–शर\u{94d}ट"),
            keywords: &["टी–शर\u{94d}ट", "पोषाक", "शर\u{94d}ट"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("majica kratkih rukava"),
            keywords: &["majica", "majica kratkih rukava", "odjeća"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("póló"),
            keywords: &["póló", "ruha", "ruházat"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սպորտային վերնաշապիկ"),
            keywords: &["հագուստ", "սպորտային", "վերնաշապիկ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kaos"),
            keywords: &["kaos", "kaus", "pakaian", "polo"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akwa-t"),
            keywords: &["akwa-t", "akwàt", "na-eme akwà", "uwe ahụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("stuttermabolur"),
            keywords: &["bolur", "klæðnaður", "stuttermabolur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("t-shirt"),
            keywords: &["abbigliamento", "maglietta", "t-shirt"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("Tシャツ"),
            keywords: &["Tシャツ", "シャツ", "服"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kaos lengen cendhak"),
            keywords: &["kaos", "kaos lengen cendhak", "kaus", "sandhangan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მაისური"),
            keywords: &["ზედა", "მაისური", "ტანსაცმელი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("футболка"),
            keywords: &["жейде", "киім", "футболка"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("T-shirt"),
            keywords: &["T-shirt", "beklædning", "bluse", "trøje"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("អាវយ\u{17ba}ត"),
            keywords: &["សម\u{17d2}លៀកប\u{17c6}ពាក\u{17cb}", "អាវ", "អាវយ\u{17ba}ត"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಟ\u{cbf}-ಶರ\u{ccd}ಟ\u{ccd}"),
            keywords: &[
                "ಉಡುಪು",
                "ಟ\u{cbf}-ಶರ\u{ccd}ಟ\u{ccd}",
                "ಟ\u{cbf}ಶರ\u{ccd}ಟ\u{ccd}",
                "ಶರ\u{ccd}ಟ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("티셔츠"),
            keywords: &["티", "티셔츠"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("टी-शर\u{94d}ट"),
            keywords: &["कपड\u{947}", "टी-शर\u{94d}ट", "टीशर\u{94d}ट", "शर\u{94d}ट"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("футболка"),
            keywords: &["кийим", "футболка"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("T-Shirt"),
            keywords: &["Hiem", "Kleedung", "T-Shirt"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເສ\u{eb7}\u{ec9}ອຍ\u{eb7}ດ"),
            keywords: &["ເສ\u{eb7}\u{ec9}ອຍ\u{eb7}ດ", "ເສ\u{eb7}\u{ec9}ອຜ\u{ec9}າ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("marškinėliai"),
            keywords: &["drabužiai", "marškiniai", "marškinėliai"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("T krekls"),
            keywords: &["T krekls", "apģērbs", "drēbes", "t krekls"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tī-hāte"),
            keywords: &["hāte", "kākahu", "tī-hāte"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("маица"),
            keywords: &["блуза", "кратки ракави", "маица", "облека"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ടീഷർട\u{d4d}ട\u{d4d}"),
            keywords: &[
                "ടീഷർട\u{d4d}ട\u{d4d}",
                "വസ\u{d4d}ത\u{d4d}രം",
                "ഷർട\u{d4d}ട\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("подволк"),
            keywords: &["подволк", "хувцас"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("टीशर\u{94d}ट"),
            keywords: &["कपड\u{947}", "टी-शर\u{94d}ट", "टीशर\u{94d}ट", "शर\u{94d}ट"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kemeja-t"),
            keywords: &["kemeja", "kemeja-t", "pakaian"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("t-shirt"),
            keywords: &["qmis", "t-shirt", "tshirt", "ħwejjeġ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တ\u{102e}ရ\u{103e}ပ\u{103a}"),
            keywords: &[
                "စ\u{103d}ပ\u{103a}ကျယ\u{103a} အ\u{102d}င\u{103a}\u{1039}ကျ\u{102e}",
                "တ\u{102e}ရ\u{103e}ပ\u{103a}",
                "ဝတ\u{103a}စရာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("t-skjorte"),
            keywords: &["klær", "skjorte", "t-skjorte"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("टि-सर\u{94d}ट"),
            keywords: &["कपडा", "टि-सर\u{94d}ट", "टिसर\u{94d}ट"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("T-shirt"),
            keywords: &["T-shirt", "kleding", "shirt"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("t-skjorte"),
            keywords: &["klede", "skjorte", "t-skjorte"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଟ\u{b3f}-ସ\u{b3e}ର\u{b4d}ଟ\u{b4d}\u{200c}"),
            keywords: &[
                "ଟ\u{b3f}-ସ\u{b3e}ର\u{b4d}ଟ\u{b4d}\u{200c}",
                "ପୋଷ\u{b3e}କ ପର\u{b3f}ଚ\u{b4d}ଛଦ",
                "ସ\u{b3e}ର\u{b4d}ଟ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਟੀ-ਸ\u{a3c}ਰਟ"),
            keywords: &["ਕਮੀਜ\u{a3c}", "ਟੀ-ਸ\u{a3c}ਰਟ", "ਲਿਬਾਸ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ٹی ـ شرٹ"),
            keywords: &["شرٹ", "ٹی شرٹ", "ٹی ـ شرٹ", "کپڑے"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("T-Shẹt"),
            keywords: &["Klọt", "Shẹt", "T-Shẹt", "Tshẹt"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("koszulka"),
            keywords: &["koszulka", "męska", "z krótkimi rękawami"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ټی شرټ"),
            keywords: &["شرټ", "لباس", "ټی شرټ", "ټیشرټ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("camiseta"),
            keywords: &["camisa", "camiseta", "roupa"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("t-shirt"),
            keywords: &["camisola", "manga curta", "t-shirt", "vestuário"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("camisa"),
            keywords: &["camisa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("tricou"),
            keywords: &["tricou", "îmbrăcăminte"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-530"),
            keywords: &["E10-530"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("футболка"),
            keywords: &["короткие", "одежда", "рубашка", "рукава", "футболка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umupira wo kwambara"),
            keywords: &["agapira", "imyambaro", "ishati", "umupira wo kwambara"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٽي شرٽ"),
            keywords: &["قميض", "لباس", "ٽي شرٽ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ට\u{dd3}-ෂර\u{dca}ටය"),
            keywords: &[
                "ඇඳ\u{dd4}ම\u{dca}",
                "කම\u{dd2}සය",
                "ට\u{dd3}-ෂර\u{dca}ටය",
                "ට\u{dd3}ෂර\u{dca}ට\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("tričko"),
            keywords: &["košeľa", "oblečenie", "tričko"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("majica"),
            keywords: &["kratka majica", "majica", "oblačila", "srajca"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("garan"),
            keywords: &["dhar", "garan", "shaar"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("bluzë"),
            keywords: &["bluzë", "këmishë", "veshje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мајица"),
            keywords: &["мajицa", "мајица", "одећа"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["мајица"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("majica"),
            keywords: &["majica", "odeća"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["majica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("t-shirt"),
            keywords: &["kläder", "t-shirt", "tröja"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("fulana"),
            keywords: &["fulana", "mavazi", "shati"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("டி-சர\u{bcd}ட\u{bcd}"),
            keywords: &[
                "ஆடை அணிகலன\u{bcd}",
                "சர\u{bcd}ட\u{bcd}",
                "டி-சர\u{bcd}ட\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ట\u{c40} షర\u{c4d}ట\u{c4d}"),
            keywords: &["చ\u{c4a}క\u{c4d}క\u{c3e}", "ట\u{c40} షర\u{c4d}ట\u{c4d}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("футболка"),
            keywords: &["курта", "либос", "футболка"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เส\u{e37}\u{e49}อย\u{e37}ด"),
            keywords: &["เส\u{e37}\u{e49}อผ\u{e49}า", "เส\u{e37}\u{e49}อย\u{e37}ด"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("futbolka"),
            keywords: &["eşik", "futbolka", "köýnek", "ýeňsiz köýnek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("falani"),
            keywords: &["falani"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("tişört"),
            keywords: &["giyim", "gömlek", "tişört"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كۆڭلەك"),
            keywords: &["كىيىم", "كۆينەك", "كۆڭلەك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("теніска поло"),
            keywords: &["одяг", "теніска поло", "топ", "футболка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ٹی شرٹ"),
            keywords: &["لباس", "ٹی شرٹ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("futbolka"),
            keywords: &["futbolka", "kiyim", "ko‘ylak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("áo phông"),
            keywords: &["quần áo", "áo phông", "áo sơ mi", "áo thun"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("tiset"),
            keywords: &["sëmiis", "tiset", "yéere"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isikipa"),
            keywords: &["ihempe", "impahla", "isikipa"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ṣẹẹti"),
            keywords: &[
                "aṣọ",
                "tṣẹ\u{301}ẹ\u{300}tì",
                "Ṣẹẹti",
                "ṣẹ\u{301}ẹ\u{300}tì",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("T 裇"),
            keywords: &["T 裇", "服裝", "裇衫"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("T 裇"),
            keywords: &["T 裇", "服装", "裇衫"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("T恤"),
            keywords: &["T恤", "恤衫"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("T卹"),
            keywords: &["T卹", "襯衫"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("T恤"),
            keywords: &["T恤", "襯衫"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isikibha"),
            keywords: &["ihembe", "impahla yokugqoka", "isikibha"],
        },
    ],
};
#[doc = "👖"]
pub const JEANS: crate::Emoji = crate::Emoji {
    glyph: "👖",
    codepoint: "1F456",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "jeans",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("jean"),
            keywords: &["broek", "denim", "jean", "klere"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጂንስ"),
            keywords: &["ሱሪ", "አልባሳት", "ጂንስ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}بنطلون جينز"),
            keywords: &["جينز", "ملابس", "\u{202b}بنطلون جينز"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("জিনছ\u{9cd}"),
            keywords: &[
                "জিনছ\u{9cd}",
                "ট\u{9cd}ৰ\u{9be}উজ\u{9be}ৰ",
                "পেণ\u{9cd}ট",
                "পোছ\u{9be}ক",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("cins"),
            keywords: &["cins", "geyim", "şalvar"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("джынсы"),
            keywords: &["адзенне", "джынсы", "штаны"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("дънки"),
            keywords: &["дънки", "облекло", "панталони"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("জিনস"),
            keywords: &[
                "জিনস",
                "ট\u{9cd}র\u{9be}উজ\u{9be}র\u{9cd}স",
                "পোশ\u{9be}ক",
                "প\u{9cd}য\u{9be}ন\u{9cd}ট",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("jeanʼs"),
            keywords: &["dilhad", "jeanʼs"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("farmerke"),
            keywords: &["farmerke", "hlače", "odjevni predmet", "pantalone"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("texans"),
            keywords: &["pantalons", "pantaló", "roba", "texans"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᏑᎶ"),
            keywords: &["ᎠᎿᏬ", "ᏗᏑᎶ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("džíny"),
            keywords: &["džíny", "kalhoty", "oblečení"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("jîns"),
            keywords: &["dillad", "jîns", "trwser"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bukser"),
            keywords: &["beklædning", "bukser", "jeans"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Jeans"),
            keywords: &["Hose", "Jeans", "Kleidung"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τζιν παντελόνι"),
            keywords: &["παντελόνι", "ρούχο", "τζιν παντελόνι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("jeans"),
            keywords: &["clothing", "jeans", "pants", "trousers"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["clothing", "trousers"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["clothing", "jeans", "pants", "trousers"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("vaqueros"),
            keywords: &["pantalones", "ropa", "vaqueros"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("jeans"),
            keywords: &["jeans", "pantalones", "ropa", "vaquero", "vestimenta"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("pantalones de mezclilla"),
            keywords: &[
                "jeans",
                "pantalones de mezclilla",
                "ropa",
                "vaquero",
                "vestimenta",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("jeans"),
            keywords: &["jeans"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("teksad"),
            keywords: &["püksid", "riided", "teksad"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("galtza bakeroak"),
            keywords: &["arropa", "galtza bakeroak", "galtzak", "prakak"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("شلوار جین"),
            keywords: &["جین", "شلوار", "پوشاک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("farkut"),
            keywords: &["farkut", "housut", "vaatteet"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pantalon"),
            keywords: &["damit", "jeans", "kasuotan", "maong", "pantalon"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("cowboybuksur"),
            keywords: &["buksur", "cowboybuksur", "klæði"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("jean"),
            keywords: &["jean", "pantalon", "vêtements"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["jean", "pantalon", "vêtements"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("brístí géine"),
            keywords: &["bríste", "brístí", "brístí géine", "treabhsar"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("dìnichean"),
            keywords: &["aodach", "briogais", "dìnichean"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("vaqueiros"),
            keywords: &["pantalóns", "vaqueiros"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("જીન\u{acd}સ"),
            keywords: &[
                "કપડા\u{a82}",
                "જીન\u{acd}સ",
                "ટ\u{acd}રાઉઝર",
                "પ\u{ac7}ન\u{acd}ટ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("jin"),
            keywords: &["jin", "suruta", "turoza", "wanduna"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מכנסי ג׳ינס"),
            keywords: &["בגד", "ג׳ינס", "מכנסי ג׳ינס", "מכנסיים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("जी\u{902}स"),
            keywords: &[
                "जी\u{902}स",
                "ट\u{94d}राउज\u{93c}र",
                "प\u{948}\u{902}ट\u{94d}स",
                "पोषाक",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("traperice"),
            keywords: &["hlače", "odjeća", "traperice"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("farmer"),
            keywords: &["farmer", "farmernadrág", "nadrág", "ruha", "ruházat"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ջինս"),
            keywords: &["հագուստ", "շալվար", "ջինս", "տաբատ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("celana jeans"),
            keywords: &["celana", "celana jeans", "pakaian", "panjang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Jinsi"),
            keywords: &["Jinsi", "na-eme akwà", "trọza gasị", "ọbante"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("buxur"),
            keywords: &["buxur", "gallabuxur", "klæðnaður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("jeans"),
            keywords: &["abbigliamento", "jeans"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ジーンズ"),
            keywords: &["ジーンズ", "ズボン", "デニム", "パンツ", "服"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("jins"),
            keywords: &["jins", "kathok", "kathok dawa", "sandhangan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჯინსი"),
            keywords: &["ტანსაცმელი", "შარვალი", "ჯინსი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("джинс"),
            keywords: &["джинс", "киім", "сым", "шалбар"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("bukser"),
            keywords: &["beklædning", "bukser"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ខោខ\u{17bc}វប\u{17ca}យ"),
            keywords: &["ខោ", "ខោខ\u{17bc}វប\u{17ca}យ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಜೀನ\u{ccd}ಸ\u{ccd}"),
            keywords: &["ಉಡುಪು", "ಜೀನ\u{ccd}ಸ\u{ccd}", "ಪ\u{ccd}ಯಾಂಟ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("바지"),
            keywords: &["면바지", "바지", "청바지"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जीन\u{94d}स"),
            keywords: &[
                "कपड\u{947}",
                "जीन\u{94d}स",
                "ट\u{94d}रावजर",
                "प\u{945}ण\u{94d}ट\u{94d}स",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("джинсы шым"),
            keywords: &["джинсы шым", "кийим", "шым"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Jeans"),
            keywords: &["Box", "Jeans", "Kleedung"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໂສ\u{ec9}ງຢ\u{eb5}ນ"),
            keywords: &["ເສ\u{eb7}\u{ec9}ອຜ\u{ec9}າ", "ໂສ\u{ec9}ງຢ\u{eb5}ນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("džinsai"),
            keywords: &["drabužiai", "džinsai", "kelnės", "trumpikės"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("džinsi"),
            keywords: &["apģērbs", "bikses", "drēbes", "džinsi"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tarau tāngari"),
            keywords: &["kākahu", "tarau", "tarau tāngari"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("фармерки"),
            keywords: &["облека", "панталони", "фармерки"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ജീൻസ\u{d4d}"),
            keywords: &[
                "ജീൻസ\u{d4d}",
                "ട\u{d4d}ര\u{d57}സർ",
                "പ\u{d3e}ന\u{d4d}റ\u{d4d}സ\u{d4d}",
                "വസ\u{d4d}ത\u{d4d}രം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("жинс"),
            keywords: &["жинс", "хувцас"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("जिन\u{94d}स"),
            keywords: &["कपड\u{947}", "जिन\u{94d}स", "ट\u{94d}राउझर", "प\u{901}ट"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("seluar jean"),
            keywords: &["celana", "pakaian", "seluar", "seluar jean"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("jeans"),
            keywords: &["jeans", "qalziet", "qliezet", "ħwejjeġ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဂျင\u{103a}းဘောင\u{103a}းဘ\u{102e}"),
            keywords: &[
                "ဂျင\u{103a}းဘောင\u{103a}းဘ\u{102e}",
                "ဘောင\u{103a}းဘ\u{102e}",
                "ဝတ\u{103a}စရာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bukser"),
            keywords: &["bukser", "jeans", "klær"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("जिन\u{94d}स"),
            keywords: &["कपडा", "जिन\u{94d}स", "ट\u{94d}राउजर", "प\u{947}न\u{94d}ट"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("spijkerbroek"),
            keywords: &["jeans", "kleding", "spijkerbroek"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bukser"),
            keywords: &["bukser", "jeans", "klede"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଜ\u{b3f}ନ\u{b4d}ସ"),
            keywords: &[
                "ଜ\u{b3f}ନ\u{b4d}ସ",
                "ଟ\u{b4d}ର\u{b3e}ଉଜର\u{b4d}\u{200c}",
                "ପୋଷ\u{b3e}କ ପର\u{b3f}ଚ\u{b4d}ଛଦ",
                "ପ\u{b4d}ୟ\u{b3e}ଣ\u{b4d}ଟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜੀਨ ਦੀ ਪ\u{a48}\u{a02}ਟ"),
            keywords: &[
                "ਜੀਨ",
                "ਜੀਨ ਦੀ ਪ\u{a48}\u{a02}ਟ",
                "ਪਜਾਮਾ",
                "ਪ\u{a48}\u{a02}ਟ",
                "ਲਿਬਾਸ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("جینز"),
            keywords: &["جینز", "دل دیاں دھڑکناں", "پاجامہ", "کپڑے"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Jins"),
            keywords: &["Jins", "Klọt", "Traúza"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("dżinsy"),
            keywords: &["dżinsy", "jeansy", "portki", "ubiór", "ubranie"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کاوبای پتلون"),
            keywords: &["لباس", "پتلون", "کاوبای پتلون"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("jeans"),
            keywords: &["calça", "jeans", "roupa"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("calças de ganga"),
            keywords: &["calças", "calças de ganga", "jeans", "vestuário"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("jeans"),
            keywords: &["jeans"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("blugi"),
            keywords: &["blugi", "jeans", "pantalon", "îmbrăcăminte"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-531"),
            keywords: &["E10-531"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("джинсы"),
            keywords: &["брюки", "джинсы", "штаны"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikoboyi"),
            keywords: &["amapantaro", "ikoboyi", "ipantaro", "umwambaro"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("جينس"),
            keywords: &["جينس", "شلوار", "لباس", "پتلون"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ද\u{dd2}ග කල\u{dd2}සම\u{dca}"),
            keywords: &[
                "ඇඳ\u{dd4}ම\u{dca}",
                "කල\u{dd2}සම\u{dca}",
                "ද\u{dd2}ග කල\u{dd2}සම\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("rifle"),
            keywords: &["gate", "nohavice", "oblečenie", "rifle"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kavbojke"),
            keywords: &["hlače", "kavbojke", "oblačila"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("jiinis"),
            keywords: &["dhar", "jiinis", "surwaal"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("xhinse"),
            keywords: &["pantallona", "veshje", "xhinse"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("фармерке"),
            keywords: &["одећа", "панталоне", "фармерке"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["фармерке"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("farmerke"),
            keywords: &["farmerke", "odeća", "pantalone"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["farmerke"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("jeans"),
            keywords: &["byxor", "jeans", "kläder"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("suruali ya jinzi"),
            keywords: &["mavazi", "suruali", "suruali ya jinzi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஜ\u{bc0}ன\u{bcd}ஸ\u{bcd}"),
            keywords: &[
                "ஆடைகள\u{bcd}",
                "க\u{bbe}ற\u{bcd}சட\u{bcd}டை",
                "ஜ\u{bc0}ன\u{bcd}ஸ\u{bcd}",
                "டிரவுசர\u{bcd}ஸ\u{bcd}",
                "பேன\u{bcd}ட\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("జ\u{c40}న\u{c4d}స\u{c4d} ప\u{c4d}య\u{c3e}ంట\u{c4d}"),
            keywords: &["జ\u{c40}న\u{c4d}స\u{c4d}", "ప\u{c4d}య\u{c3e}ంట\u{c4d}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҷинс"),
            keywords: &["либос", "шим", "ҷинс"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ย\u{e35}นส\u{e4c}"),
            keywords: &[
                "กางเกง",
                "กางเกงขายาว",
                "ย\u{e35}นส\u{e4c}",
                "เส\u{e37}\u{e49}อผ\u{e49}า",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("jinsi"),
            keywords: &["balak", "eşik", "jalbar", "jinsi"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("talausese"),
            keywords: &["talausese"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kot"),
            keywords: &["blucin", "blue jean", "giyim", "kot", "pantolon"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("پادىچىلار ئىشتىنى"),
            keywords: &["ئىشتان", "شىم", "كىيىم", "پادىچىلار ئىشتىنى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("джинси"),
            keywords: &["джинси", "одяг", "штани"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جینز"),
            keywords: &["جینز", "لباس"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("jinsi shim"),
            keywords: &["jinsi shim", "kiyim", "shim"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("quần bò"),
            keywords: &["quần", "quần bò", "quần dài", "quần áo"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jiin"),
            keywords: &["jiin", "pàntaloŋ", "tubëy", "yéere"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iijini"),
            keywords: &["ibhulukwe", "iibhulukhwe", "iijini", "impahla"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Jinsi"),
            keywords: &["Jinsi", "aṣọ", "pátá", "ṣòkòtò"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("牛仔褲"),
            keywords: &["服裝", "牛仔褲", "褲", "長褲"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("牛仔裤"),
            keywords: &["服装", "牛仔裤", "裤", "长裤"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("牛仔裤"),
            keywords: &["牛仔裤", "裤子"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("牛仔褲"),
            keywords: &["牛仔褲", "褲子"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ijini"),
            keywords: &["ibhulukwe", "ijini", "impahla yokugqoka"],
        },
    ],
};
#[doc = "🧣"]
pub const SCARF: crate::Emoji = crate::Emoji {
    glyph: "🧣",
    codepoint: "1F9E3",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "scarf",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("serp"),
            keywords: &["nek", "serp"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ስካርፍ"),
            keywords: &["ስካርፍ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وشاح"),
            keywords: &["عنق", "وشاح"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("স\u{9cd}ক\u{9be}ৰ\u{9cd}ফ"),
            keywords: &["ডিঙি", "স\u{9cd}ক\u{9be}ৰ\u{9cd}ফ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("şərf"),
            keywords: &["boyun", "şərf"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("шалік"),
            keywords: &["шалік", "шыя"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("шал"),
            keywords: &["врат", "шал"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9cd}ক\u{9be}র\u{9cd}ফ"),
            keywords: &["গল\u{9be}বন\u{9cd}ধ", "স\u{9cd}ক\u{9be}র\u{9cd}ফ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("skerb"),
            keywords: &["dilhad", "skerb"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("šal"),
            keywords: &["vrat", "šal"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bufanda"),
            keywords: &["bufanda", "coll"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏯᏠ"),
            keywords: &["ᎠᏯᏠ", "ᎠᏴᏤᏂ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("šála"),
            keywords: &["krk", "šála"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("scarff"),
            keywords: &["gwddf", "scarff"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("halstørklæde"),
            keywords: &["beklædning", "hals", "halstørklæde", "vinter"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schal"),
            keywords: &["Hals", "Schal"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κασκόλ"),
            keywords: &["κασκόλ", "λαιμός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("scarf"),
            keywords: &["neck", "scarf"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bufanda"),
            keywords: &["abrigo", "bufanda", "cuello"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["bufanda", "cuello", "vestimenta"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("sall"),
            keywords: &["kael", "sall"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("zapi"),
            keywords: &["lepoa", "zapi"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("روسری"),
            keywords: &["روسری", "گردن"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("huivi"),
            keywords: &["asuste", "huivi", "kaula", "kaulaliina"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bandana"),
            keywords: &["bandana", "leeg"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hálsturriklæði"),
            keywords: &["háls", "hálsturriklæði", "klæði", "turriklæði"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("foulard"),
            keywords: &["cou", "foulard", "vêtements"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("scairf"),
            keywords: &["muineál", "scairf"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("stoc-amhaich"),
            keywords: &["amhach", "stoc-amhaich"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("bufanda"),
            keywords: &["bufanda", "pescozo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}કાફ"),
            keywords: &["સ\u{acd}કાફ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ɗankwali"),
            keywords: &["wuya", "ɗankwali"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("צעיף"),
            keywords: &["חורף", "צוואר", "צעיף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{94d}कार\u{94d}फ\u{93c}"),
            keywords: &["गर\u{94d}दन, गला", "स\u{94d}कार\u{94d}फ\u{93c}"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("šal"),
            keywords: &["vrat", "šal"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("sál"),
            keywords: &["nyak", "sál"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("վզկապ"),
            keywords: &["պարանոց", "վզկապ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("syal"),
            keywords: &["leher", "syal"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ichafù"),
            keywords: &["ichafù", "olu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("trefill"),
            keywords: &["háls", "trefill"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("sciarpa"),
            keywords: &["collo", "sciarpa"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("マフラー"),
            keywords: &["スカーフ", "マフラー", "襟巻き", "首巻き"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("skarf"),
            keywords: &["gulu", "skarf"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კაშნე"),
            keywords: &["კაშნე", "კისერი", "შარფი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шарф"),
            keywords: &["шарф"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កន\u{17d2}សែង"),
            keywords: &["ក", "កន\u{17d2}សែង"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{ccd}ಕಾರ\u{ccd}ಫ\u{ccd}"),
            keywords: &["ಕುತ\u{ccd}ತ\u{cbf}ಗ\u{cc6}", "ಸ\u{ccd}ಕಾರ\u{ccd}ಫ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("스카프"),
            keywords: &["스카프"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("स\u{94d}कार\u{94d}फ"),
            keywords: &["मान", "स\u{94d}कार\u{94d}फ"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("шарф"),
            keywords: &["моюн", "шарф"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Schal"),
            keywords: &["Hals", "Schal"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{ec9}າພ\u{eb1}ນຄ\u{ecd}"),
            keywords: &["ຄ\u{ecd}", "ຜ\u{ec9}າພ\u{eb1}ນຄ\u{ecd}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("skara"),
            keywords: &["kaklas", "skara"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("šalle"),
            keywords: &["kakls", "šalle"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kāmeta"),
            keywords: &["kakī", "kāmeta"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("шал"),
            keywords: &["врат", "шал"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d4d}\u{200c}ക\u{d3e}ർഫ\u{d4d}"),
            keywords: &[
                "കഴ\u{d41}ത\u{d4d}ത\u{d4d}",
                "ഷ\u{d3e}ൾ",
                "സ\u{d4d}\u{200c}ക\u{d3e}ർഫ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("алчуур"),
            keywords: &["алчуур", "хүзүү"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{94d}कार\u{94d}फ"),
            keywords: &["मान", "स\u{94d}कार\u{94d}फ"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("skaf"),
            keywords: &["leher", "skaf"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("xalpa"),
            keywords: &["għonq", "xalpa"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လည\u{103a}စည\u{103a}း"),
            keywords: &["လည\u{103a}စည\u{103a}း", "လည\u{103a}ပင\u{103a}း"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("skjerf"),
            keywords: &["hals", "klær", "skjerf"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("गलबन\u{94d}दी"),
            keywords: &["गलबन\u{94d}दी", "घा\u{901}टी"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("sjaal"),
            keywords: &["nek", "sjaal"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("skjerf"),
            keywords: &["hals", "klede", "skjerf"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b4d}କ\u{b3e}ର\u{b4d}ଫ\u{b4d}\u{200c}"),
            keywords: &["ବେକ", "ସ\u{b4d}କ\u{b3e}ର\u{b4d}ଫ\u{b4d}\u{200c}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਕਾਫ\u{a3c}"),
            keywords: &["ਗਰਦਨ", "ਸਕਾਫ\u{a3c}"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سکاف"),
            keywords: &["دھون", "سکاف"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mọ\u{301}fla"),
            keywords: &["Mọ\u{301}fla", "Nẹk", "Skaf"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("szalik"),
            keywords: &["szalik", "szyja"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("غاړې دسمال"),
            keywords: &["غاړه", "غاړې دسمال"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cachecol"),
            keywords: &["cachecol", "inverno", "pescoço"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("lenço"),
            keywords: &["cachecol", "lenço", "pescoço", "écharpe"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("chalina"),
            keywords: &["chalina"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("eșarfă"),
            keywords: &["eșarfă", "gât"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1140"),
            keywords: &["E10-1140"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("шарф"),
            keywords: &["обмотать", "повязать", "шарф", "шея"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("furari"),
            keywords: &["Ijosi", "furari"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("حجاب"),
            keywords: &["حجاب", "ڳچي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("උත\u{dd4}ර\u{dd4}සළ\u{dd4}ව"),
            keywords: &["උත\u{dd4}ර\u{dd4}සළ\u{dd4}ව", "බෙල\u{dca}ල"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("šál"),
            keywords: &["krk", "šál"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("šal"),
            keywords: &["šal"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("safaleeti"),
            keywords: &["qoor", "safaleeti"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shall"),
            keywords: &["qafë", "shall"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("шал"),
            keywords: &["врат", "шал"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("šal"),
            keywords: &["vrat", "šal"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("halsduk"),
            keywords: &["hals", "halsduk", "scarf"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("shali"),
            keywords: &["shali", "shingo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஸ\u{bcd}க\u{bbe}ர\u{bcd}ஃப\u{bcd}"),
            keywords: &[
                "கழுத\u{bcd}து",
                "கழுத\u{bcd}து அணி",
                "ஸ\u{bcd}க\u{bbe}ர\u{bcd}ஃப\u{bcd}",
                "ஸ\u{bcd}டைல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c46}డకు కట\u{c4d}టుకున\u{c47} వస\u{c4d}త\u{c4d}రం"),
            keywords: &[
                "మ\u{c46}డ",
                "మ\u{c46}డకు కట\u{c4d}టుకున\u{c47} వస\u{c4d}త\u{c4d}రం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("шарф"),
            keywords: &["гардан", "шарф"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ผ\u{e49}าพ\u{e31}นคอ"),
            keywords: &["คอ", "ผ\u{e49}าพ\u{e31}นคอ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("şarf"),
            keywords: &["boýun", "şarf"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sikaafi"),
            keywords: &["sikaafi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("atkı"),
            keywords: &["atkı", "yaka"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("شارپا"),
            keywords: &["بويۇن", "شارپا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("шарф"),
            keywords: &["шарф", "шия"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اسکارف"),
            keywords: &["اسکارف", "گردن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("sharf"),
            keywords: &["sharf"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("khăn quàng"),
            keywords: &["cổ", "khăn quàng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kol"),
            keywords: &["baat", "kol"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isikhafu"),
            keywords: &["intamo", "isikhafu"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("síkáfù"),
            keywords: &["síkáfù", "ọrùn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("頸巾"),
            keywords: &["頸", "頸巾"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("颈巾"),
            keywords: &["颈", "颈巾"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("围巾"),
            keywords: &["围巾"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("圍巾"),
            keywords: &["圍巾", "脖子"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("頸巾"),
            keywords: &["圍巾", "頸巾"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iskhafu"),
            keywords: &["intamo", "iskhafu"],
        },
    ],
};
#[doc = "🧤"]
pub const GLOVES: crate::Emoji = crate::Emoji {
    glyph: "🧤",
    codepoint: "1F9E4",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "gloves",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("handskoene"),
            keywords: &["hand", "handskoene"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጓንት"),
            keywords: &["ጓንት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قف\u{651}ازان"),
            keywords: &["قف\u{651}ازان", "يد"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("গ\u{9cd}ল’ভছ"),
            keywords: &["গ\u{9cd}ল’ভছ", "হ\u{9be}ত"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("əlcəklər"),
            keywords: &["əl", "əlcəklər"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("пальчаткі"),
            keywords: &["пальчаткі", "рука"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("ръкавици"),
            keywords: &["ръка", "ръкавици"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("দস\u{9cd}ত\u{9be}ন\u{9be}"),
            keywords: &["দস\u{9cd}ত\u{9be}ন\u{9be}", "হ\u{9be}ত"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("manegoù"),
            keywords: &["dilhad", "manegoù"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("rukavice"),
            keywords: &["ruka", "rukavice"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("guants"),
            keywords: &["guants", "mà"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎵᏰᏑᎶ"),
            keywords: &["ᎤᏬᏱ", "ᏗᎵᏰᏑᎶ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("rukavice"),
            keywords: &["ruka", "rukavice"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("menyg"),
            keywords: &["llaw", "menyg"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("handsker"),
            keywords: &["beklædning", "handsker", "hånd", "vinter"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Handschuhe"),
            keywords: &["Hand", "Handschuhe"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γάντια"),
            keywords: &["γάντια", "χέρι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("gloves"),
            keywords: &["gloves", "hand"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("guantes"),
            keywords: &["guantes", "mano"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["guantes", "mano", "vestimenta"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kindad"),
            keywords: &["kindad", "käsi"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("eskularruak"),
            keywords: &["esku", "eskularruak"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دستکش"),
            keywords: &["دست", "دستکش"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hansikkaat"),
            keywords: &["asuste", "hansikkaat", "kädet", "käsineet"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("guwantes"),
            keywords: &["guwantes", "kamay"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("handskar"),
            keywords: &["handskar", "hond", "klæði", "vøttur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("gants"),
            keywords: &["gants", "main", "vêtements"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("lámhainní"),
            keywords: &["lámh", "lámhainní"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("miotagan"),
            keywords: &["làmh", "miotagan"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("luvas"),
            keywords: &["guantes", "luvas", "mans"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("હાથના મોજા\u{a82}"),
            keywords: &["હાથના મોજા\u{a82}"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("safar hannu"),
            keywords: &["hannu", "safar hannu"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כפפות"),
            keywords: &["יד", "כפפות"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("दस\u{94d}तान\u{947}"),
            keywords: &["दस\u{94d}तान\u{947}", "हाथ"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("rukavice"),
            keywords: &["ruka", "rukavice"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kesztyű"),
            keywords: &["kesztyű", "kéz"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ձեռնոցներ"),
            keywords: &["ձեռնոցներ", "ձեռք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("sarung tangan"),
            keywords: &["sarung tangan", "tangan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("mgbaaka gasị"),
            keywords: &["aka", "mgbaaka gasị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hanskar"),
            keywords: &["hanskar", "hendi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("guanti"),
            keywords: &["guanti", "mano"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("手袋"),
            keywords: &["手袋"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sarung tangan"),
            keywords: &["sarung tangan", "tangan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ხელთათმანი"),
            keywords: &["ხელთათმანი", "ხელი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қолғап"),
            keywords: &["қолғап"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}រោមដៃ"),
            keywords: &["ប\u{17d2}រអប\u{17cb}ដៃ", "ស\u{17d2}រោមដៃ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಗ\u{ccd}ಲೋವ\u{ccd}ಸ\u{ccd}"),
            keywords: &["ಕೈ", "ಗ\u{ccd}ಲೋವ\u{ccd}ಸ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("장갑"),
            keywords: &["장갑"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("हातमोज\u{947}"),
            keywords: &["हात", "हातमोज\u{947}"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("колкап"),
            keywords: &["кол", "колкап"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Händchen"),
            keywords: &["Hand", "Händchen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຖ\u{ebb}ງມ\u{eb7}"),
            keywords: &["ຖ\u{ebb}ງມ\u{eb7}", "ມ\u{eb7}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("pirštinės"),
            keywords: &["pirštinės", "ranka"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("cimdi"),
            keywords: &["cimdi", "roka"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("karapu"),
            keywords: &["karapu", "ringa"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("ракавици"),
            keywords: &["дланка", "ракавици"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കയ\u{d4d}യ\u{d41}റകൾ"),
            keywords: &["കയ\u{d4d}യ\u{d41}റകൾ", "കൈ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бээлий"),
            keywords: &["бээлий", "гар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("हातमोज\u{947}"),
            keywords: &["हात", "हातमोज\u{947}"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("sarung tangan"),
            keywords: &["sarung tangan", "tangan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ingwanti"),
            keywords: &["id", "ingwanti"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လက\u{103a}အ\u{102d}တ\u{103a}"),
            keywords: &["လက\u{103a}", "လက\u{103a}အ\u{102d}တ\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hansker"),
            keywords: &["hansker", "hånd", "klær"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पन\u{94d}जा"),
            keywords: &["पन\u{94d}जा", "हात"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("handschoenen"),
            keywords: &["hand", "handschoenen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("hanskar"),
            keywords: &["hand", "hanskar", "klede"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଗ\u{b4d}ଲୋଭ\u{b4d}ସ"),
            keywords: &["ଗ\u{b4d}ଲୋଭ\u{b4d}ସ", "ହ\u{b3e}ତ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਦਸਤਾਨ\u{a47}"),
            keywords: &["ਦਸਤਾਨ\u{a47}", "ਹ\u{a71}ਥ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("دستانے"),
            keywords: &["دستانے", "ہتھ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Glov-dẹm"),
            keywords: &["Glov-dẹm", "Hand"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("rękawiczki"),
            keywords: &["ręka", "rękawiczki"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("دستکشی"),
            keywords: &["دستکشی", "لاس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("luvas"),
            keywords: &["inverno", "luvas", "mãos"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("luvas"),
            keywords: &["luva", "luvas", "mão"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("guantes"),
            keywords: &["guantes"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("mănuși"),
            keywords: &["mână", "mănuși"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1141"),
            keywords: &["E10-1141"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("перчатки"),
            keywords: &["аксессуар", "одежда", "перчатки", "руки"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("udupfukantoki"),
            keywords: &["Ikiganza", "udupfukantoki"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("دستانا"),
            keywords: &["دستانا", "هاٿ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අත\u{dca}වැස\u{dd4}ම\u{dca}"),
            keywords: &["අත", "අත\u{dca}වැස\u{dd4}ම\u{dca}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("rukavice"),
            keywords: &["ruka", "rukavice"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("rokavice"),
            keywords: &["rokavice"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gacmo-gashi"),
            keywords: &["gacan", "gacmo-gashi"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("dorashka"),
            keywords: &["dorashka", "dorë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("рукавице"),
            keywords: &["рукавице", "шака"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("rukavice"),
            keywords: &["rukavice", "šaka"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("handske"),
            keywords: &["hand", "handske"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("glavu"),
            keywords: &["glavu", "mkono"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கையுறைகள\u{bcd}"),
            keywords: &["கிளவுஸ\u{bcd}", "கை", "கையுறைகள\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c47}త\u{c3f} త\u{c4a}డుగులు"),
            keywords: &["చ\u{c47}త\u{c3f}", "చ\u{c47}త\u{c3f} త\u{c4a}డుగులు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дастпӯшак"),
            keywords: &["даст", "дастпӯшак"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ถ\u{e38}งม\u{e37}อ"),
            keywords: &["ถ\u{e38}งม\u{e37}อ", "ม\u{e37}อ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ellik"),
            keywords: &["el", "ellik"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kofunima"),
            keywords: &["kofunima"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("eldiven"),
            keywords: &["el", "eldiven"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("پەلەي"),
            keywords: &["قول", "پەلەي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("рукавички"),
            keywords: &["рука", "рукавички"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("دستانے"),
            keywords: &["دستانے"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qo‘lqop"),
            keywords: &["qo‘lqop"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("găng tay"),
            keywords: &["găng tay", "tay"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("gant"),
            keywords: &["gant", "loxo"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iiglavu"),
            keywords: &["iiglavu", "isandla"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ìbọ\u{300}wọ\u{301}"),
            keywords: &["ìbọ\u{300}wọ\u{301}", "ọwọ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("手套"),
            keywords: &["手", "手套"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("手套"),
            keywords: &["手", "手套"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("手套"),
            keywords: &["手套"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("手套"),
            keywords: &["手", "手套"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("amaglavu"),
            keywords: &["amaglavu", "isandla"],
        },
    ],
};
#[doc = "🧥"]
pub const COAT: crate::Emoji = crate::Emoji {
    glyph: "🧥",
    codepoint: "1F9E5",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "coat",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("jas"),
            keywords: &["baadjie", "jas"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ኮት"),
            keywords: &["ኮት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("معطف"),
            keywords: &["سترة", "معطف"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কোট"),
            keywords: &["কোট", "জেকেট"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("palto"),
            keywords: &["palto", "pencək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("паліто"),
            keywords: &["куртка", "паліто"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("палто"),
            keywords: &["палто", "яке"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("কোট"),
            keywords: &["কোট", "জ\u{9cd}য\u{9be}কেট"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("mantell"),
            keywords: &["chupenn", "dilhad", "mantell"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kaput"),
            keywords: &["jakna", "kaput"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("abric"),
            keywords: &["abric", "jaqueta"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏌᎴᎾ"),
            keywords: &["ᎦᏌᎴᎾ", "ᏴᏫ ᎦᏌᎴᎾ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kabát"),
            keywords: &["bunda", "kabát"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("côt"),
            keywords: &["côt", "siaced"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("frakke"),
            keywords: &["beklædning", "frakke", "jakke", "vinter"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Mantel"),
            keywords: &["Jacke", "Mantel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("παλτό"),
            keywords: &["μπουφάν", "παλτό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("coat"),
            keywords: &["coat", "jacket"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("abrigo"),
            keywords: &["abrigo", "chaquetón"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["abrigo", "chamarra", "vestimenta"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("mantel"),
            keywords: &["jakk", "mantel"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("berokia"),
            keywords: &["berokia", "jaka"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پالتو"),
            keywords: &["پالتو", "کت"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("takki"),
            keywords: &["pusero", "päällysvaate", "takki", "vaatteet"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kapa"),
            keywords: &["jacket", "kapa"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("jakki"),
            keywords: &["frakki", "jakki", "klæði"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("manteau"),
            keywords: &["manteau", "veste", "vêtements"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cóta"),
            keywords: &["cóta", "seaicéad"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("còta"),
            keywords: &["còta", "seacaid"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("abrigo"),
            keywords: &["abrigo", "chaqueta"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કોટ"),
            keywords: &["કોટ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kwat"),
            keywords: &["jakiti", "kwat"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מעיל"),
            keywords: &["ג׳קט", "ז׳קט", "חורף", "מעיל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("कोट"),
            keywords: &["कोट", "ज\u{948}क\u{947}ट"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kaput"),
            keywords: &["jakna", "kaput"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kabát"),
            keywords: &["dzseki", "kabát"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("վերարկու"),
            keywords: &["բաճկոն", "վերարկու"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("mantel"),
            keywords: &["jaket", "mantel"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("kotu"),
            keywords: &["akwà mkpuchi ahụ", "kotu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kápa"),
            keywords: &["jakki", "kápa"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cappotto"),
            keywords: &["cappotto", "giacca"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("コート"),
            keywords: &["アウター", "オーバー", "コート", "ジャケット", "服"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("mantel"),
            keywords: &["jaket", "mantel"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქურთუკი"),
            keywords: &["მოსაცმელი", "ჟაკეტი", "ქურთუკი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("пальто"),
            keywords: &["пальто"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("អាវធ\u{17c6}វែង"),
            keywords: &["អាវធ\u{17c6}ខ\u{17d2}ល\u{17b8}", "អាវធ\u{17c6}វែង"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕೋಟು"),
            keywords: &["ಕೋಟು", "ಜ\u{ccd}ಯಾಕ\u{cc6}ಟ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("코트"),
            keywords: &["재킷", "코트"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("कोट"),
            keywords: &["कोट", "ज\u{945}क\u{947}ट"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("пальто"),
            keywords: &["күрмө", "пальто"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Mantel"),
            keywords: &["Jackett", "Mantel"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເສ\u{eb7}\u{ec9}ອຂ\u{ebb}ນສ\u{eb1}ດ"),
            keywords: &[
                "ເສ\u{eb7}\u{ec9}ອຂ\u{ebb}ນສ\u{eb1}ດ",
                "ເສ\u{eb7}\u{ec9}ອຄ\u{eb8}ມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("paltas"),
            keywords: &["paltas", "švarkas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("mētelis"),
            keywords: &["jaka", "mētelis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("koti"),
            keywords: &["koti"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("палто"),
            keywords: &["палто", "јакна"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കോട\u{d4d}ട\u{d4d}"),
            keywords: &["കോട\u{d4d}ട\u{d4d}", "ജ\u{d3e}ക\u{d4d}കറ\u{d4d}റ\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цув"),
            keywords: &["хүрэм", "цув"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कोट"),
            keywords: &["कोट", "जाकीट"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kot"),
            keywords: &["jaket", "kot"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kowt"),
            keywords: &["kowt", "ġakketta"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("က\u{102f}တ\u{103a}"),
            keywords: &["က\u{102f}တ\u{103a}", "ဂျာကင\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("jakke"),
            keywords: &["frakk", "jakke", "klær", "kåpe"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कोट"),
            keywords: &["कोट", "ज\u{94d}याक\u{947}ट"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("jas"),
            keywords: &["blazer", "jas"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("jakke"),
            keywords: &["frakk", "jakke", "klede", "kåpe"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କୋଟ\u{b4d}\u{200c}"),
            keywords: &["କୋଟ\u{b4d}\u{200c}", "ଜ\u{b4d}ୟ\u{b3e}କେଟ\u{b4d}\u{200c}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a4b}ਟ"),
            keywords: &["ਕ\u{a4b}ਟ", "ਜ\u{a48}ਕਟ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کوٹ"),
            keywords: &["جیکٹ", "کوٹ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kot"),
            keywords: &["Jákẹt", "Kot"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("płaszcz"),
            keywords: &["kurtka", "płaszcz"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("جامپر"),
            keywords: &["جامپر", "جاکټ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("casaco"),
            keywords: &["blusa", "casaco", "jaqueta"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("casaco"),
            keywords: &["casaco", "jaqueta"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("abrigo"),
            keywords: &["abrigo"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("palton"),
            keywords: &["haină", "jachetă", "palton", "pardesiu"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1142"),
            keywords: &["E10-1142"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("пальто"),
            keywords: &["верхняя", "куртка", "одежда", "пальто", "пиджак"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikoti"),
            keywords: &["ijaketi", "ikoti"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪوٽ"),
            keywords: &["جاڪيٽ", "ڪوٽ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කබ\u{dcf}ය"),
            keywords: &["කබ\u{dcf}ය", "ජැකට\u{dca}ට\u{dd4}ව"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kabát"),
            keywords: &["bunda", "kabát"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("plašč"),
            keywords: &["plašč"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("koodh"),
            keywords: &["jaakeet", "koodh"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("pallto"),
            keywords: &["pallto", "xhaketë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("капут"),
            keywords: &["капут", "јакна"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kaput"),
            keywords: &["jakna", "kaput"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("jacka"),
            keywords: &["jacka", "kavaj"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("koti"),
            keywords: &["jaketi", "koti"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கோட\u{bcd}"),
            keywords: &[
                "ஆடை",
                "கோட\u{bcd}",
                "கோட\u{bcd} ஜ\u{bbe}க\u{bcd}கெட\u{bcd}",
                "சூட\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c4b}టు"),
            keywords: &["క\u{c4b}టు", "జ\u{c3e}క\u{c46}ట\u{c4d}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("палто"),
            keywords: &["палто", "пиҷак"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เส\u{e37}\u{e49}อโค\u{e49}ต"),
            keywords: &["เส\u{e37}\u{e49}อโค\u{e49}ต", "เส\u{e37}\u{e49}อโค\u{e49}ท"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("palto"),
            keywords: &["palto", "penjek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kote"),
            keywords: &["kote"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kaban"),
            keywords: &["kaban"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("پەلتو"),
            keywords: &["پەلتو", "چاپان"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("пальто"),
            keywords: &["куртка", "пальто"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کوٹ"),
            keywords: &["جیکٹ", "کوٹ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("palto"),
            keywords: &["palto"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("áo khoác"),
            keywords: &["áo choàng", "áo khoác"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("màntóo"),
            keywords: &["jaket", "màntóo"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("idyasi"),
            keywords: &["idyasi", "ijakethi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("kóòtù"),
            keywords: &["jákẹ\u{301}tì", "kóòtù"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("外套"),
            keywords: &["外套"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("外套"),
            keywords: &["外套"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("外套"),
            keywords: &["外套", "夹克"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("外套"),
            keywords: &["外套", "夾克"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("大褸"),
            keywords: &["外套", "大衣", "大褸", "夾克"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ijazi"),
            keywords: &["ijakhethi", "ijazi"],
        },
    ],
};
#[doc = "🧦"]
pub const SOCKS: crate::Emoji = crate::Emoji {
    glyph: "🧦",
    codepoint: "1F9E6",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "socks",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("sokkies"),
            keywords: &["sokkies", "sykouse"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ካልሲ"),
            keywords: &["ካልሲ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("جورب"),
            keywords: &["جورب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মোজ\u{9be}"),
            keywords: &["মোজ\u{9be}", "ষ\u{9cd}টকিং"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("corablar"),
            keywords: &["corablar", "stoker"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("шкарпэткі"),
            keywords: &["панчохі", "шкарпэткі"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("чорапи"),
            keywords: &["три-четвърти чорапи", "чорапи"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মোজ\u{9be}"),
            keywords: &["মোজ\u{9be}", "স\u{9cd}টকিং"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("loeroù"),
            keywords: &["dilhad", "loeroù", "treid"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("čarape"),
            keywords: &["čarapa", "čarape"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("mitjons"),
            keywords: &["mitja", "mitjons"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎵᏲ"),
            keywords: &["ᎠᏂᎨᏴ ᏧᎾᎵᏲ", "ᏗᎵᏲ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("ponožky"),
            keywords: &["ponožky", "punčochy"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sanau"),
            keywords: &["hosan", "sanau"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sokker"),
            keywords: &["beklædning", "sokker", "strømper"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Socken"),
            keywords: &["Socken", "Strümpfe"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κάλτσες"),
            keywords: &["κάλτσες", "καλσόν"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("socks"),
            keywords: &["socks", "stocking"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("calcetines"),
            keywords: &["calcetines", "pies", "ropa"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["calcetines", "pies", "ropa", "vestimenta"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("sokid"),
            keywords: &["sokid", "sukk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("galtzerdiak"),
            keywords: &["galtzerdiak", "galtzeta"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("جوراب"),
            keywords: &["جوراب", "جوراب ساق بلند"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("sukat"),
            keywords: &["sukat", "vaatteet", "villasukka"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("medyas"),
            keywords: &["medyas", "stocking"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sokkar"),
            keywords: &["hosur", "klæði", "sokkar"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("chaussettes"),
            keywords: &["chaussettes", "pieds", "vêtements"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["bas", "chaussettes", "pieds"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("stocaí"),
            keywords: &["stocaí"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("stocainnean"),
            keywords: &["stocainn", "stocainnean"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("calcetíns"),
            keywords: &["calcetíns"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મોજા\u{a82}"),
            keywords: &["મોજા\u{a82}"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("safa"),
            keywords: &["safa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גרביים"),
            keywords: &["גרביים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("मोज\u{93c}\u{947}"),
            keywords: &["ज\u{941}राब\u{947}\u{902}", "मोज\u{93c}\u{947}"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("čarape"),
            keywords: &["najlonke", "čarape"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("zokni"),
            keywords: &["harisnya", "zokni"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("գուլպաներ"),
            keywords: &["գուլպաներ", "զուգագուլպա"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kaus kaki"),
            keywords: &["kaos kaki", "kaus kaki", "stocking", "stoking"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("sọọsụ"),
            keywords: &["akwàụkwụ", "sọọsụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sokkar"),
            keywords: &["háir sokkar", "sokkar"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("calzini"),
            keywords: &["calze", "calzini"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ソックス"),
            keywords: &["ソックス", "靴下"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kaos sikil"),
            keywords: &["kaos sikil", "stoking"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("წინდები"),
            keywords: &["წინდები"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шұлық"),
            keywords: &["шұлық"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}រោមជើង"),
            keywords: &["ស\u{17d2}រោមជើង", "ស\u{17d2}រោមជើងវែង"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸಾಕ\u{ccd}ಸ\u{ccd}"),
            keywords: &["ಬ\u{cbf}ಗ\u{cbf}ಯುಡುಪು", "ಸಾಕ\u{ccd}ಸ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("양말"),
            keywords: &["양말"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("म\u{947}य"),
            keywords: &["म\u{947}य", "स\u{94d}टॉकि\u{902}ग"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("байпак"),
            keywords: &["байпак", "колготки"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Strëmp"),
            keywords: &["Collant", "Strëmp"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຖ\u{ebb}ງຕ\u{eb5}ນ"),
            keywords: &["ຖ\u{ebb}ງຕ\u{eb5}ນ", "ຖ\u{ebb}ງນ\u{ec8}ອງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kojinės"),
            keywords: &["blauzdinė", "kojinės"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zeķes"),
            keywords: &["zeķbikses", "zeķes"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tōkena"),
            keywords: &["tōkena"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("чорапи"),
            keywords: &["хулахопки", "чорапи"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സോക\u{d4d}\u{200c}സ\u{d4d}"),
            keywords: &["ക\u{d3e}ല\u{d41}റ", "സോക\u{d4d}\u{200c}സ\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("оймс"),
            keywords: &["оймс", "трико"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मोज\u{947}"),
            keywords: &["मोज\u{947}", "स\u{94d}टॉकि\u{902}ग"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("stoking"),
            keywords: &["stoking"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kalzetti qosra"),
            keywords: &["kalzetti qosra", "stoking"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ခြေအ\u{102d}တ\u{103a}"),
            keywords: &["ခြေအ\u{102d}တ\u{103a}", "စတော\u{1037}ကင\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sokker"),
            keywords: &["klær", "labber", "sokker", "strømper"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("मोजा"),
            keywords: &["मोजा", "लामो मोजा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("sokken"),
            keywords: &["kousen", "sokken"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("sokkar"),
            keywords: &["klede", "labbar", "sokkar", "strømper"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମୋଜ\u{b3e}"),
            keywords: &["ମୋଜ\u{b3e}", "ଷ\u{b4d}ଟକ\u{b3f}ଂ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜ\u{a3c}\u{a41}ਰਾਬਾ\u{a02}"),
            keywords: &[
                "ਜ\u{a3c}\u{a41}ਰਾਬਾ\u{a02}",
                "ਵ\u{a71}ਡੀਆ\u{a02} ਜ\u{a3c}\u{a41}ਰਾਬਾ\u{a02}",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("جراباں"),
            keywords: &["جراباں", "سٹاک کرنا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Sọks"),
            keywords: &["Stọ\u{301}kins", "Sọks"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("skarpetki"),
            keywords: &["skarpetki", "skarpety"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("جرابي"),
            keywords: &["اوږدي جرابي", "جرابي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("meias"),
            keywords: &["meias"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("meias"),
            keywords: &["meia", "meias", "peúgas"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("medias"),
            keywords: &["medias"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("șosete"),
            keywords: &["ciorapi", "șosete"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1143"),
            keywords: &["E10-1143"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("носки"),
            keywords: &["ноги", "носки", "чулки"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("amasogisi"),
            keywords: &["amasogisi", "kubika"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("جوراب"),
            keywords: &["جوراب"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මේස\u{dca}"),
            keywords: &["මේස\u{dca}", "ස\u{dca}ටොක\u{dd2}ං"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ponožky"),
            keywords: &["pančucha", "ponožky"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("nogavice"),
            keywords: &["nogavice"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("sharibaado"),
            keywords: &["luga-gashi", "sharibaado"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("çorape"),
            keywords: &["çorape", "çorapë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("чарапе"),
            keywords: &["чарапа", "чарапе"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["чарапе"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("čarape"),
            keywords: &["čarapa", "čarape"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["čarape"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("sockor"),
            keywords: &["sockor", "strumpa"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("soksi"),
            keywords: &["soksi", "soksi ndefu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ச\u{bbe}க\u{bcd}ஸ\u{bcd}"),
            keywords: &[
                "க\u{bbe}லுறை",
                "ச\u{bbe}க\u{bcd}ஸ\u{bcd}",
                "ஸ\u{bcd}ட\u{bbe}க\u{bcd}கிங\u{bcd}ஸ\u{bcd}",
                "ஸ\u{bcd}டைல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c3e}క\u{c4d}స\u{c4d}"),
            keywords: &["మ\u{c47}జ\u{c4b}డు", "స\u{c3e}క\u{c4d}స\u{c4d}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҷуроб"),
            keywords: &["ҷуроб", "ҷуроби дароз"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ถ\u{e38}งเท\u{e49}า"),
            keywords: &["ถ\u{e38}งน\u{e48}อง", "ถ\u{e38}งเท\u{e49}า"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("jorap"),
            keywords: &["jorap", "joraplar"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sitōkeni"),
            keywords: &["sitōkeni"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("çorap"),
            keywords: &["çorap"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("پايپاق"),
            keywords: &["دۆۋىلىنىش", "پايپاق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("шкарпетки"),
            keywords: &["панчохи", "шкарпетки"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جرابیں"),
            keywords: &["جراب", "جرابیں"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("paypoq"),
            keywords: &["paypoq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tất"),
            keywords: &["bít tất", "tất", "vớ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kawas"),
            keywords: &["denc", "kawas"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iikawusi"),
            keywords: &["i-stocking", "iikawusi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ìbọ\u{300}sẹ\u{300}"),
            keywords: &["ìbọ\u{300}sẹ\u{300}", "ìbọ\u{300}sẹ\u{300} obìnrin gígùn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("襪"),
            keywords: &["襪"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("袜"),
            keywords: &["袜"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("袜子"),
            keywords: &["短袜", "袜子", "长袜"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("襪子"),
            keywords: &["絲襪", "襪子"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["襪子", "長襪"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("amasokisi"),
            keywords: &["amasokisi", "amastokhingi"],
        },
    ],
};
#[doc = "👗"]
pub const DRESS: crate::Emoji = crate::Emoji {
    glyph: "👗",
    codepoint: "1F457",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "dress",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("rok"),
            keywords: &["klere", "rok"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቀሚስ"),
            keywords: &["ቀሚስ", "አልባሳት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("فستان"),
            keywords: &["فستان", "قطعة واحدة", "ملابس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ড\u{9cd}ৰেছ"),
            keywords: &["ড\u{9cd}ৰেছ", "পোছ\u{9be}ক"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("don"),
            keywords: &["don", "geyim"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сукенка"),
            keywords: &["адзенне", "сукенка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("рокля"),
            keywords: &["облекло", "рокля"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ফ\u{9cd}রক"),
            keywords: &["জ\u{9be}ম\u{9be}", "ফ\u{9cd}রক"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("sae"),
            keywords: &["dilhad", "sae"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("haljina"),
            keywords: &["haljina", "odjevni predmet"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("vestit"),
            keywords: &["roba", "vestit"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏌᏃ"),
            keywords: &["ᎠᏌᏃ", "ᏗᎿᏬ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("šaty"),
            keywords: &["oblečení", "šaty"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ffrog"),
            keywords: &["dillad", "ffrog"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kjole"),
            keywords: &["beklædning", "kjole"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Kleid"),
            keywords: &["Kleid", "Kleidung"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("φόρεμα"),
            keywords: &["ρούχο", "φόρεμα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("dress"),
            keywords: &["clothing", "dress"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["clothing", "dress", "woman’s clothes"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("vestido"),
            keywords: &["mujer", "ropa", "vestido"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["ropa", "vestido", "vestimenta"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["ropa", "vestido", "vestimenta"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kleit"),
            keywords: &["kleit", "riided"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("soinekoa"),
            keywords: &["arropa", "soinekoa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پیراهن زنانه"),
            keywords: &["زنانه", "مجلسی", "پوشاک", "پیراهن زنانه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("mekko"),
            keywords: &["leninki", "mekko", "vaatteet"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bestida"),
            keywords: &[
                "bestida", "damit", "daster", "dress", "kasuotan", "pambabae",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kjóli"),
            keywords: &["kjóli", "klæði"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("robe"),
            keywords: &["robe", "vêtements"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("gúna"),
            keywords: &["gúna"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("dreasa"),
            keywords: &["aodach", "dreasa"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("vestido"),
            keywords: &["vestido"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ડ\u{acd}ર\u{ac7}સ"),
            keywords: &["કપડા\u{a82}", "ડ\u{acd}ર\u{ac7}સ", "વન-પીસ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("riga"),
            keywords: &["riga", "sutura"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שמלה"),
            keywords: &["בגד", "שמלה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पोषाक"),
            keywords: &["ड\u{94d}र\u{947}स", "पोषाक", "वन पीस"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("haljina"),
            keywords: &["haljina", "odjeća"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("ruha"),
            keywords: &["ruha", "ruházat"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("զգեստ"),
            keywords: &["զգեստ", "հագուստ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("gaun"),
            keywords: &["gaun", "pakaian"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("uwe"),
            keywords: &["na-eme akwà", "uwe"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kjóll"),
            keywords: &["föt", "kjóll", "klæðnaður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("vestito"),
            keywords: &["abbigliamento", "abito", "vestito"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ワンピース"),
            keywords: &["ドレス", "ワンピース", "服"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rok"),
            keywords: &["rok", "sandhangan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კაბა"),
            keywords: &["კაბა", "ტანსაცმელი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("көйлек"),
            keywords: &["киім", "көйлек"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kjole"),
            keywords: &["beklædning", "kjole"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("រ\u{17c9}\u{17bc}ប"),
            keywords: &["រ\u{17c9}\u{17bc}ប", "សម\u{17d2}លៀកប\u{17c6}ពាក\u{17cb}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಉಡುಗ\u{cc6}"),
            keywords: &["ಉಡುಗ\u{cc6}", "ಬಟ\u{ccd}ಟ\u{cc6}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("원피스"),
            keywords: &["드레스", "원피스"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पोश\u{947}ग"),
            keywords: &["कपड\u{947}", "पोश\u{947}ग"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("көйнөк"),
            keywords: &["кийим", "көйнөк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Rack"),
            keywords: &["Kleedung", "Rack"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຊ\u{eb8}ດກະໂປ\u{ec8}ງ"),
            keywords: &["ຊ\u{eb8}ດກະໂປ\u{ec8}ງ", "ເສ\u{eb7}\u{ec9}ອຜ\u{ec9}າ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("suknelė"),
            keywords: &["drabužiai", "suknelė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kleita"),
            keywords: &["apģērbs", "kleita"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kākahu"),
            keywords: &["kākahu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("фустан"),
            keywords: &["жена", "облека", "фустан"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വസ\u{d4d}ത\u{d4d}രം"),
            keywords: &["വസ\u{d4d}ത\u{d4d}രം", "വൺ-പീസ\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("даашинз"),
            keywords: &["даашинз", "хувцас"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कपड\u{947}"),
            keywords: &["कपड\u{947}", "ड\u{94d}र\u{947}स"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("gaun"),
            keywords: &["gaun", "pakaian"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("libsa"),
            keywords: &["libsa", "ħwejjeġ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဝတ\u{103a}စ\u{102f}\u{1036}"),
            keywords: &["ဝတ\u{103a}စ\u{102f}\u{1036}", "အဝတ\u{103a}အစား"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kjole"),
            keywords: &["kjole", "klær"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ल\u{941}गा"),
            keywords: &["कपडा", "ल\u{941}गा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("jurk"),
            keywords: &["jurk", "kleding"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kjole"),
            keywords: &["kjole", "klede"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପୋଷ\u{b3e}କ"),
            keywords: &["ପୋଷ\u{b3e}କ", "ପୋଷ\u{b3e}କ ପର\u{b3f}ଚ\u{b4d}ଛଦ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲਿਬਾਸ"),
            keywords: &["ਇ\u{a71}ਕ", "ਪਹਿਰਾਵਾ", "ਲਿਬਾਸ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("لباس"),
            keywords: &["لباس", "کپڑے"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Gaun"),
            keywords: &["Drẹs", "Gaun", "Klọt"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("sukienka"),
            keywords: &["sukienka", "suknia", "ubiór", "ubranie"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کمیس"),
            keywords: &["لباس", "کمیس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("vestido"),
            keywords: &["peça única", "roupa", "vestido"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["vestido", "vestuário"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("aqsu"),
            keywords: &["aqsu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("rochie"),
            keywords: &["rochie", "îmbrăcăminte"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-532"),
            keywords: &["E10-532"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("платье"),
            keywords: &["женская одежда", "женское", "одежда", "платье"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikanzu"),
            keywords: &["ikanzu", "imyambaro"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("وڳو"),
            keywords: &["وڳو", "ڪپڙا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ගව\u{dd4}ම"),
            keywords: &["ඇඳ\u{dd4}ම\u{dca}", "ගව\u{dd4}ම"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("šaty"),
            keywords: &["oblečenie", "šaty"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ženska obleka"),
            keywords: &["oblačila", "ženska obleka"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("toob"),
            keywords: &["dhar", "toob"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fustan"),
            keywords: &["fustan", "veshje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("хаљина"),
            keywords: &["одећа", "хаљина"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["хаљина"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("haljina"),
            keywords: &["haljina", "odeća"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["haljina"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("klänning"),
            keywords: &["kläder", "klänning"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nguo"),
            keywords: &["mavazi", "nguo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆடை"),
            keywords: &["ஆடை", "உடை", "பெண\u{bcd}கள\u{bcd} உடை"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("దుస\u{c4d}తులు"),
            keywords: &["దుస\u{c4d}తులు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("куртаи занона"),
            keywords: &["куртаи занона", "пӯшок"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ช\u{e38}ดกระโปรง"),
            keywords: &["ช\u{e38}ดกระโปรง", "เดรส"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("eşik"),
            keywords: &["egin-eşik", "eşik"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kofu"),
            keywords: &["kofu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("elbise"),
            keywords: &["elbise", "giyim", "tek parça"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كىيىم"),
            keywords: &["كىيىم", "كىيىم-كېچەك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("сукня"),
            keywords: &["одяг", "сукня"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("لباس"),
            keywords: &["لباس", "ڈریس", "کپڑے"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("libos"),
            keywords: &["kiyim", "libos"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("váy"),
            keywords: &["quần áo", "váy"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("robbu"),
            keywords: &["robbu", "yéere"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ilokhwe"),
            keywords: &["ilokhwe", "impahla"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Aṣọ"),
            keywords: &["Aṣọ", "Wíwọṣọ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("裙"),
            keywords: &["服裝", "裙"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("裙"),
            keywords: &["服装", "裙"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("连衣裙"),
            keywords: &["衣服", "连衣裙"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("洋裝"),
            keywords: &["洋裝", "裙子"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("連身裙"),
            keywords: &["裙子", "連身裙"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("irokwe"),
            keywords: &["ingubo yokugqoka", "irokwe"],
        },
    ],
};
#[doc = "👘"]
pub const KIMONO: crate::Emoji = crate::Emoji {
    glyph: "👘",
    codepoint: "1F458",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "kimono",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kimono"),
            keywords: &["kimono", "klere"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የጃፓን ቀሚስ"),
            keywords: &["አልባሳት", "የጃፓን ቀሚስ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كيمونو ياباني"),
            keywords: &["فستان", "كيمونو ياباني", "ملابس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কিম’ন’"),
            keywords: &["কিম’ন’", "পোছ\u{9be}ক"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kimono"),
            keywords: &["geyim", "kimono"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кімано"),
            keywords: &["адзенне", "кімано"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("кимоно"),
            keywords: &["кимоно", "облекло"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("কিমোনো"),
            keywords: &["কিমোনো", "পোশ\u{9be}ক"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kimono"),
            keywords: &["dilhad", "kimono"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kimono"),
            keywords: &["kimono", "odjevni predmet"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("quimono"),
            keywords: &["japonès", "quimono", "roba", "vestit"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎩᎼᏃ"),
            keywords: &["ᎩᎼᏃ", "ᏗᎿᏬ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kimono"),
            keywords: &["kimono", "oblečení"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cimono"),
            keywords: &["cimono", "dillad"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kimono"),
            keywords: &["beklædning", "kimono", "kåbe"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Kimono"),
            keywords: &["Kimono", "Kleid", "Kleidung"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κιμονό"),
            keywords: &["κιμονό", "ρούχο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("kimono"),
            keywords: &["clothing", "kimono"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("kimono"),
            keywords: &["japonés", "kimono", "ropa"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["japonés", "kimono", "ropa", "vestido", "vestimenta"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kimono"),
            keywords: &["kimono", "riided"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kimonoa"),
            keywords: &["arropa", "kimonoa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کیمونو"),
            keywords: &["پوشاک", "ژاپنی", "کیمونو"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kimono"),
            keywords: &["japanilainen", "kimono", "vaatteet"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kimono"),
            keywords: &["damit", "japanese", "kasuotan", "kimono", "tradisyonal"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kimono"),
            keywords: &["kimono", "klæði"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("kimono"),
            keywords: &["kimono", "vêtements"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cimeonó"),
            keywords: &["cimeonó", "gúna", "kimono"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("kimono"),
            keywords: &["aodach", "kimono"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("quimono"),
            keywords: &["quimono"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કિમોનો"),
            keywords: &["કપડા\u{a82}", "કિમોનો", "ડ\u{acd}ર\u{ac7}સ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kimono"),
            keywords: &["kimono", "sutura"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קימונו"),
            keywords: &["בגד", "יפן", "יפני", "קימונו"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("किमोनो"),
            keywords: &["किमोनो", "ड\u{94d}र\u{947}स", "पोषाक"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kimono"),
            keywords: &["kimono", "odjeća"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kimonó"),
            keywords: &["kimonó", "ruha", "ruházat"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կիմոնո"),
            keywords: &["կիմոնո", "հագուստ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kimono"),
            keywords: &["kimono", "pakaian"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("kimono"),
            keywords: &["kimono", "na-eme akwà"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kímónó"),
            keywords: &["klæðnaður", "kímónó", "sloppur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("kimono"),
            keywords: &["abbigliamento", "kimono", "vestito"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("着物"),
            keywords: &["服", "着物"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kimono"),
            keywords: &["kimono", "sandhangan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კიმონო"),
            keywords: &["კიმონო", "ტანსაცმელი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("кимоно"),
            keywords: &["кимоно", "киім"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kimono"),
            keywords: &["beklædning", "kimono", "kåbe"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "គ\u{17b8}ម\u{17c9}\u{17bc}ណ\u{17bc} (ឈ\u{17bb}តប\u{17d2}រពៃណ\u{17b8}ជប\u{17c9}\u{17bb}ន)",
            ),
            keywords: &[
                "គ\u{17b8}ម\u{17c9}\u{17bc}ណ\u{17bc} (ឈ\u{17bb}តប\u{17d2}រពៃណ\u{17b8}ជប\u{17c9}\u{17bb}ន)",
                "ឈ\u{17bb}តប\u{17d2}រពៃណ\u{17b8}",
                "សម\u{17d2}លៀកប\u{17c6}ពាក\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನ\u{cbf}ಲುವಂಗ\u{cbf}"),
            keywords: &["ಉಡುಗ\u{cc6}", "ನ\u{cbf}ಲುವಂಗ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("기모노"),
            keywords: &["기모노", "일본 기모노"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("किमोनो"),
            keywords: &["कपड\u{947}", "किमोनो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кимоно"),
            keywords: &["кийим", "кимоно"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Kimono"),
            keywords: &["Kimono", "Kleedung"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຊ\u{eb8}ດກ\u{eb5}ໂມໂນ"),
            keywords: &[
                "ຊ\u{eb8}ກກ\u{eb5}ໂມໂນ",
                "ຊ\u{eb8}ດກ\u{eb5}ໂມໂນ",
                "ເສ\u{eb7}\u{ec9}ອຜ\u{ec9}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kimono"),
            keywords: &["drabužiai", "kimono"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kimono"),
            keywords: &["apģērbs", "kimono"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kimono"),
            keywords: &["kimono", "kākahu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("кимоно"),
            keywords: &["жена", "кимоно", "облека", "јапонска"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കിമോണോ"),
            keywords: &["കിമോണോ", "ഡ\u{d4d}രസ\u{d4d}സ\u{d4d}", "വസ\u{d4d}ത\u{d4d}രം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("кимоно"),
            keywords: &["кимоно", "хувцас"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("किमोनो"),
            keywords: &["कपड\u{947}", "किमोनो"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kimono"),
            keywords: &["kimono", "pakaian"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kimono"),
            keywords: &["kimono", "ħwejjeġ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("က\u{102e}မ\u{102d}\u{102f}န\u{102d}\u{102f}"),
            keywords: &[
                "က\u{102e}မ\u{102d}\u{102f}န\u{102d}\u{102f}",
                "အဝတ\u{103a}အစား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kimono"),
            keywords: &["kimono", "kjole", "klær"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("किमोनो"),
            keywords: &["कपडा", "किमोनो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kimono"),
            keywords: &["kimono", "kleding"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kimono"),
            keywords: &["kimono", "kjole", "klede"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b3f}ମୋନୋ"),
            keywords: &["କ\u{b3f}ମୋନୋ", "ପୋଷ\u{b3e}କ ପର\u{b3f}ଚ\u{b4d}ଛଦ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਿਮ\u{a4b}ਨ\u{a4b}"),
            keywords: &["ਕਿਮ\u{a4b}ਨ\u{a4b}", "ਪਹਿਰਾਵਾ", "ਲਿਬਾਸ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ک\u{64f}ھلا لباس"),
            keywords: &["ک\u{64f}ھلا لباس", "کپڑے"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Japán Klọt Wé Im Nem Na Kimóno"),
            keywords: &["Japán Klọt Wé Im Nem Na Kimóno", "Klọt"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kimono"),
            keywords: &["kimono", "ubiór", "ubranie"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کیمینو"),
            keywords: &["لباس", "کیمینو"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("quimono"),
            keywords: &["quimono", "roupa", "vestir"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["quimono", "vestuário"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("kimono"),
            keywords: &["kimono"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("chimono"),
            keywords: &["chimono", "kimono", "îmbrăcăminte"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-533"),
            keywords: &["E10-533"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("кимоно"),
            keywords: &["кимоно", "одежда", "традиции", "япония"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("imyenda bakinana karate"),
            keywords: &["imyambaro", "imyenda bakinana karate"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("گائون"),
            keywords: &["ڪپڙا", "گائون"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dd2}මොන\u{dcf}ව"),
            keywords: &["ඇඳ\u{dd4}ම\u{dca}", "ක\u{dd2}මොන\u{dcf}ව"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kimono"),
            keywords: &["kimono", "oblečenie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kimono"),
            keywords: &["kimono", "oblačila"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kimoono"),
            keywords: &["dhar", "kimoono"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kimono"),
            keywords: &["kimono", "veshje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кимоно"),
            keywords: &["кимоно", "одећа"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["кимоно"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kimono"),
            keywords: &["kimono", "odeća"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["kimono"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kimono"),
            keywords: &["kimono", "kläder", "klänning"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kimono"),
            keywords: &["kimono", "mavazi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கிமோனோ"),
            keywords: &["ஆடை", "ஆடை அணிகலன\u{bcd}", "உடைகள\u{bcd}", "கிமோனோ"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "జప\u{c3e}న\u{c4d} ద\u{c47}శ\u{c40}యులు ఉపయ\u{c4b}గ\u{c3f}ంచ\u{c47} దుస\u{c4d}తులు",
            ),
            keywords: &[
                "జప\u{c3e}న\u{c4d}",
                "జప\u{c3e}న\u{c4d} ద\u{c47}శ\u{c40}యులు ఉపయ\u{c4b}గ\u{c3f}ంచ\u{c47} దుస\u{c4d}తులు",
                "దుస\u{c4d}తులు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("кимоно"),
            keywords: &["кимоно", "пӯшок"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ก\u{e34}โมโน"),
            keywords: &["ก\u{e34}โมโน", "เส\u{e37}\u{e49}อผ\u{e49}า"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kimono"),
            keywords: &["egin-eşik", "kimono"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kimono"),
            keywords: &["kimono", "vala"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kimono"),
            keywords: &["elbise", "giyim", "kimono"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كىمونو"),
            keywords: &["كىمونو", "كىيىم-كېچەك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кімоно"),
            keywords: &["кімоно", "одяг"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("خواتین کا روایتی جاپانی لباس"),
            keywords: &["خواتین کا روایتی جاپانی لباس", "لباس"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kimono"),
            keywords: &["kimono", "kiyim"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("kimono"),
            keywords: &["kimono", "quần áo"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kimono"),
            keywords: &["kimono", "yéere"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-kimono"),
            keywords: &["i-kimono", "impahla"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Kimono"),
            keywords: &["Kimono", "Wíwọṣọ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("和服"),
            keywords: &["和服", "服裝"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("和服"),
            keywords: &["和服", "服装"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("和服"),
            keywords: &["和服", "日本"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("和服"),
            keywords: &["和服", "日本"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ikinomo"),
            keywords: &["ikinomo", "ingubo yokugqoka"],
        },
    ],
};
#[doc = "🥻"]
pub const SARI: crate::Emoji = crate::Emoji {
    glyph: "🥻",
    codepoint: "1F97B",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "sari",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("sari"),
            keywords: &["klere", "rok", "sari"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሴሪ"),
            keywords: &["ልብስ", "ሴሪ", "ቀሚስ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ساري"),
            keywords: &["ساري", "فستان", "ملابس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("শ\u{9be}ড\u{9bc}ী"),
            keywords: &[
                "ক\u{9be}পোৰ-ক\u{9be}নি",
                "শ\u{9be}ড\u{9bc}ী",
                "স\u{9be}জ-পোছ\u{9be}ক",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sari"),
            keywords: &["geyim", "paltar", "sari"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сары"),
            keywords: &["адзенне", "сары", "сукенка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("сари"),
            keywords: &["дреха", "рокля", "сари"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("শ\u{9be}ড\u{9bc}ি"),
            keywords: &["ক\u{9be}পড\u{9bc}", "পোশ\u{9be}ক", "শ\u{9be}ড\u{9bc}ি"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("sari"),
            keywords: &["dilhad", "sari"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("sari odjeća"),
            keywords: &["haljina", "odjeća", "sari odjeća"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("sari"),
            keywords: &["roba", "sari", "vestit"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎯᏂᏗ ᎠᏌᏃ"),
            keywords: &["ᎠᏌᏃ", "ᎯᏂᏗ ᎠᏌᏃ", "ᏗᎿᏬᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("sárí"),
            keywords: &["oblečení", "oděv", "sárí", "šaty"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sari"),
            keywords: &["dillad", "gwisg", "sari"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sari"),
            keywords: &["kjole", "sari", "tøj"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Sari"),
            keywords: &["Kleid", "Kleidung", "Sari"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σάρι"),
            keywords: &["ρουχισμός", "σάρι", "φόρεμα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("sari"),
            keywords: &["clothing", "dress", "sari"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("sari"),
            keywords: &["prenda", "ropa", "sari", "vestido"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["India", "prenda", "ropa", "sari", "vestido"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("sari"),
            keywords: &["kleit", "rõivas", "sari"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("saria"),
            keywords: &["arropa", "saria", "soineko"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ساری"),
            keywords: &["ساری", "لباس", "پیراهن زنانه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("sari"),
            keywords: &["mekko", "sari", "vaate"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("sari"),
            keywords: &["bestida", "damit", "sari"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sari"),
            keywords: &["India", "búni", "konufólkabúni", "sari"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("sari"),
            keywords: &["mode", "robe", "sari", "vêtement"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["robe", "sari", "vêtement"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("sáirí"),
            keywords: &["gúna", "sáirí", "éadaí"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sari"),
            keywords: &["aodach", "dreasa", "sari"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("sari"),
            keywords: &["A India", "hindú", "roupa", "sari", "vestido"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સાડી"),
            keywords: &["કપડા\u{a82}", "વસ\u{acd}ત\u{acd}ર", "સાડી"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סארי"),
            keywords: &["בגד", "הודו", "סארי"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("साड\u{93c}ी"),
            keywords: &[
                "कपड\u{93c}\u{947}",
                "परिधान",
                "पार\u{902}परिक",
                "पोशाक",
                "महिला",
                "वस\u{94d}त\u{94d}र",
                "साड\u{93c}ी",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("sari"),
            keywords: &["haljina", "odjeća", "sari"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szári"),
            keywords: &["ruha", "ruházat", "szári"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սարի"),
            keywords: &["զգեստ", "հագուստ", "սարի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("sari"),
            keywords: &["gaun", "pakaian", "sari", "terusan"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sari"),
            keywords: &["föt", "kjóll", "klæðnaður", "sari"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("sari"),
            keywords: &[
                "abbigliamento",
                "abito tradizionale indiano",
                "sari",
                "vestito tradizionale",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("サリー"),
            keywords: &["サリー", "服", "民族衣装"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sari"),
            keywords: &["rok", "sandhangan", "sari"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სარი"),
            keywords: &["კაბა", "სამოსი", "სარი", "ტანსაცმელი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сари"),
            keywords: &["киім", "көйлек", "сари"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សារ\u{17bb}ងឥណ\u{17d2}ឌា"),
            keywords: &[
                "សម\u{17d2}លៀកប\u{17c6}ពាក\u{17cb}",
                "សារ\u{17bb}ងឥណ\u{17d2}ឌា",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸೀರ\u{cc6}"),
            keywords: &["ಉಡ\u{cbf}ಗ\u{cc6}", "ತೊಡ\u{cbf}ಗ\u{cc6}", "ಸೀರ\u{cc6}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("사리"),
            keywords: &["드레스", "사리", "의복"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("साडी"),
            keywords: &["कपड\u{947}", "पोश\u{947}ग", "साडी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("сари"),
            keywords: &["кийим", "көйнөк", "сари"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{ec8}າ\u{200b}ຣ\u{eb5}"),
            keywords: &[
                "ຊ\u{eb8}ດ",
                "ຜ\u{ec9}າ",
                "ສ\u{ec8}າ\u{200b}ຣ\u{eb5}",
                "ເສ\u{eb7}\u{ec9}\u{200b}ອ\u{200b}ຜ\u{ec9}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("saris"),
            keywords: &["apranga", "saris", "suknelė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sari"),
            keywords: &["apģērbs", "kleita", "sari"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("сари"),
            keywords: &["облека", "сари", "фустан"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d3e}രി"),
            keywords: &["വസ\u{d4d}\u{200c}ത\u{d4d}രം", "സ\u{d3e}രി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("саарий"),
            keywords: &["саарий", "хувцас ︱ даашинз"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("साडी"),
            keywords: &["कपड\u{947}", "पोशाख", "साडी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("sari"),
            keywords: &["baju", "pakaian", "sari"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဆာရ\u{102e}"),
            keywords: &["ဂါဝန\u{103a}", "ဆာရ\u{102e}", "အဝတ\u{103a}အစား"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sari"),
            keywords: &["kjole", "klær", "sari"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("साडी"),
            keywords: &["पहिरन", "पोशाक", "साडी"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("sari"),
            keywords: &["jurk", "kleding", "sari"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("sari"),
            keywords: &["kjole", "klede", "sari"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଶ\u{b3e}ଢ\u{b3c}ୀ"),
            keywords: &["ପୋଷ\u{b3e}କ", "ବସ\u{b4d}ତ\u{b4d}ର", "ଶ\u{b3e}ଢ\u{b3c}ୀ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਾੜੀ"),
            keywords: &["ਕ\u{a71}ਪੜ\u{a47}", "ਸਾੜੀ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Sári Klọt"),
            keywords: &["Drẹs", "Klọt", "Sári"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("sari"),
            keywords: &["odzież", "sari", "suknia", "ubranie"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ساړې"),
            keywords: &["جامې", "ساړې", "کالي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("sari"),
            keywords: &["roupa", "sari", "vestido"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("sari"),
            keywords: &["sari", "vestido", "vestuário"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("sari"),
            keywords: &["rochie", "sari", "îmbrăcăminte"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–027"),
            keywords: &["E12–027"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("сари"),
            keywords: &[
                "Индия",
                "женская",
                "одежда",
                "платье",
                "сари",
                "традиционная",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ساڙي"),
            keywords: &["ساڙي", "ڊريس", "ڪپڙا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dcf}ර\u{dd2}ය"),
            keywords: &["ඇඳ\u{dd4}ම", "ඇඳ\u{dd4}ම\u{dca}", "ස\u{dcf}ර\u{dd2}ය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("sárí"),
            keywords: &["oblečenie", "odev", "sárí", "šaty"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("sari"),
            keywords: &["oblačilo", "obleka", "ogrinjalo", "sari"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("saarii"),
            keywords: &["dhar", "saarii", "toob"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("sari"),
            keywords: &["fustan", "sari", "veshje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("сари"),
            keywords: &["одећа", "сари", "хаљина"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["сари"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("sari"),
            keywords: &["haljina", "odeća", "sari"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["sari"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("sari"),
            keywords: &["kläder", "klänning", "sari"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("sari"),
            keywords: &["mavazi", "nguo", "sari"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சேலை"),
            keywords: &["ஆடை", "உடை", "சேலை"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c40}ర"),
            keywords: &["చ\u{c40}ర", "డ\u{c4d}ర\u{c46}స\u{c4d}", "దుస\u{c4d}తులు"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ช\u{e38}ดส\u{e48}าหร\u{e35}"),
            keywords: &[
                "ช\u{e38}ดกระโปรง",
                "ช\u{e38}ดส\u{e48}าหร\u{e35}",
                "ช\u{e38}ดเดรส",
                "เส\u{e37}\u{e49}อผ\u{e49}า",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("sari"),
            keywords: &["geýim", "köýnek", "sari"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sali"),
            keywords: &["sali"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sari"),
            keywords: &["elbise", "giysi", "sari"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("сарі"),
            keywords: &["вбрання", "одяг", "сарі"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ساڑھی"),
            keywords: &["ساڑھی", "لباس", "کپڑے"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("sari"),
            keywords: &["kiyim", "koʻylak", "sari"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("xari"),
            keywords: &["quần áo", "trang phục", "váy", "xari", "đầm"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("紗麗"),
            keywords: &["服裝", "紗麗", "裙"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("纱丽"),
            keywords: &["服装", "纱丽", "裙"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("纱丽"),
            keywords: &["印度", "披肩", "纱丽", "衣服"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("莎麗服"),
            keywords: &["洋裝", "莎麗服", "衣服"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("莎麗"),
            keywords: &["莎麗", "衣服", "裙"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-sari"),
            keywords: &["i-sari", "ingubo", "izingubo"],
        },
    ],
};
#[doc = "🩱"]
pub const ONE_PIECE_SWIMSUIT: crate::Emoji = crate::Emoji {
    glyph: "🩱",
    codepoint: "1FA71",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "one-piece swimsuit",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("eenstukswembroek"),
            keywords: &["eenstukswembroek", "swembroek"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወጥ የዋና ልብስ"),
            keywords: &["ወጥ የዋና ልብስ", "የዋና ልብስ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مايوه من قطعة واحدة"),
            keywords: &["بدلة استحمام", "بدلة سباحة", "مايوه من قطعة واحدة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("এট\u{9be} স\u{9be}\u{981}তোৰ\u{9be} জেকেট"),
            keywords: &[
                "এট\u{9be} স\u{9be}\u{981}তোৰ\u{9be} জেকেট",
                "স\u{9be}\u{981}তোৰোতে পিন\u{9cd}ধ\u{9be} পোছ\u{9be}ক",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("bir hissəli üzgüçülük geyimi"),
            keywords: &["bir hissəli üzgüçülük geyimi", "hamam geyimi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("закрыты купальнік"),
            keywords: &["закрыты купальнік", "купальны касцюм"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("цял бански"),
            keywords: &["бански костюм", "костюм за къпане", "цял бански"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9c1}ইমিং কস\u{9cd}টিউম"),
            keywords: &[
                "স\u{9be}\u{981}ত\u{9be}রের পোশ\u{9be}ক",
                "স\u{9c1}ইমিং কস\u{9cd}টিউম",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("sae-gouronkañ unpezh"),
            keywords: &["dilhad-kouronkañ", "sae-gouronkañ", "unpezh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("jednodijelni kupaći kostim"),
            keywords: &["jednodijelni kupaći kostim", "kupaći kostim"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("banyador"),
            keywords: &["banyador", "vestit de bany"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏌᏊᎯ ᎥᏓᏬᏍᎬᎢ ᏗᎿᏬᏍᏗ"),
            keywords: &["ᎥᏓᏬᏍᎬ ᏗᎿᏬᏍᏗ", "ᏌᏊᎯ ᎥᏓᏬᏍᎬᎢ ᏗᎿᏬᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("jednodílné plavky"),
            keywords: &["dámské plavky", "jednodílné plavky"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("siwt nofio"),
            keywords: &["gwisg nofio", "siwt nofio"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("badedragt"),
            keywords: &["badedragt"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("einteiliger Badeanzug"),
            keywords: &["Badeanzug", "einteiliger Badeanzug"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ολόσωμο μαγιό"),
            keywords: &["ολόσωμο μαγιό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("one-piece swimsuit"),
            keywords: &["bathing suit", "one-piece swimsuit"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("traje de baño de una pieza"),
            keywords: &["bañador", "traje de baño de una pieza"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["traje de baño", "traje de baño de una pieza"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("ujumistrikoo"),
            keywords: &["trikoo", "ujumiskostüüm", "ujumistrikoo"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bainujantzi osoa"),
            keywords: &["bainujantzi", "bainujantzi osoa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مایو یک\u{200c}تکه"),
            keywords: &["مایو", "مایو یک\u{200c}تکه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("uimapuku"),
            keywords: &["uima-asu", "uimapuku"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("one-piece na swimsuit"),
            keywords: &["bathing suit", "one-piece na swimsuit", "panligo"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("svimjibúni"),
            keywords: &["svimjibúni", "svimjing"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("maillot de bain une pièce"),
            keywords: &["maillot de bain", "maillot de bain une pièce"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("culaith shnámha aonphíosa"),
            keywords: &["culaith shnámha", "culaith shnámha aonphíosa"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("deise-shnàimh"),
            keywords: &["deise-shnàimh", "snàmh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("traxe de baño"),
            keywords: &["bañador", "traxe de baño"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વન-પીસ સ\u{acd}વીમસ\u{acd}ય\u{ac2}ટ"),
            keywords: &[
                "બાથ સ\u{acd}ય\u{ac2}ટ",
                "વન-પીસ સ\u{acd}વીમસ\u{acd}ય\u{ac2}ટ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("בגד ים שלם"),
            keywords: &["בגד ים", "בגד ים שלם", "ים", "שחייה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("वन-पीस स\u{94d}विमस\u{942}ट"),
            keywords: &[
                "वन-पीस स\u{94d}विमस\u{942}ट",
                "स\u{94d}विमस\u{942}ट",
                "स\u{94d}विमि\u{902}ग",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("jednodijelni kupaći kostim"),
            keywords: &["jednodijelni kupaći kostim", "kupaći kostim"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("egyrészes fürdőruha"),
            keywords: &["egyrészes fürdőruha", "fürdőruha"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("միակտոր լողազգեստ"),
            keywords: &["լողազգեստ", "միակտոր լողազգեստ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pakaian renang one-piece"),
            keywords: &["pakaian renang", "pakaian renang one-piece"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sundföt"),
            keywords: &["sundbolur", "sundföt"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("costume da bagno intero"),
            keywords: &["costume da bagno", "costume da bagno intero"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ワンピースの水着"),
            keywords: &["スイムウェア", "ワンピースの水着", "水着"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("klambi nglangi terusan"),
            keywords: &["klambi adus", "klambi nglangi terusan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ერთიანი საცურაო კოსტიუმი"),
            keywords: &[
                "ერთიანი საცურაო კოსტიუმი",
                "სანაპირო",
                "საცურაო კოსტიუმი",
                "ცურვა",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жабық шомылу киімі"),
            keywords: &["жабық шомылу киімі", "шомылу костюмі"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ឈ\u{17bb}តហែលទ\u{17b9}ក"),
            keywords: &["ឈ\u{17bb}តហែលទ\u{17b9}ក"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಒಂದೇ ತುಂಡ\u{cbf}ನ ಈಜುಡುಗ\u{cc6}"),
            keywords: &[
                "ಒಂದೇ ತುಂಡ\u{cbf}ನ ಈಜುಡುಗ\u{cc6}",
                "ಸ\u{ccd}ನಾನದ ಉಡುಗ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("원피스 수영복"),
            keywords: &["수영복", "원피스 수영복"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("एक-पीस स\u{94d}विमस\u{941}ट"),
            keywords: &["एक-पीस स\u{94d}विमस\u{941}ट", "बाथी\u{902}ग स\u{941}ट"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бүтүн суулук"),
            keywords: &["бүтүн суулук", "сууга түшүүчү кийим"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some(
                "ຊ\u{eb8}ດ\u{200b}ລອຍ\u{200b}ນ\u{ec9}ຳ\u{200b}ແບບ\u{200b}ສ\u{ec8}ວນ\u{200b}ດຽວ",
            ),
            keywords: &[
                "ຊ\u{eb8}ດ\u{200b}ລອຍ\u{200b}ນ\u{ec9}ຳ",
                "ຊ\u{eb8}ດ\u{200b}ລອຍ\u{200b}ນ\u{ec9}ຳ\u{200b}ແບບ\u{200b}ວ\u{eb1}ນພ\u{eb4}ສ",
                "ຊ\u{eb8}ດ\u{200b}ລອຍ\u{200b}ນ\u{ec9}ຳ\u{200b}ແບບ\u{200b}ສ\u{ec8}ວນ\u{200b}ດຽວ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vientisas maudymosi kostiumėlis"),
            keywords: &["maudymosi kostiumėlis", "vientisas maudymosi kostiumėlis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kopējais peldkostīms"),
            keywords: &["kopējais peldkostīms", "peldkostīms"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("едноделен костим за капење"),
            keywords: &["едноделен костим за капење", "костим за капење"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഒറ\u{d4d}റ പീസ\u{d4d} നീന\u{d4d}തൽ വസ\u{d4d}\u{200c}ത\u{d4d}രം"),
            keywords: &[
                "ഒറ\u{d4d}റ പീസ\u{d4d} നീന\u{d4d}തൽ വസ\u{d4d}\u{200c}ത\u{d4d}രം",
                "ബ\u{d3e}ത\u{d4d}തിംഗ\u{d4d} സ\u{d4d}യ\u{d42}ട\u{d4d}ട\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("усны үргэлж хувцас"),
            keywords: &["усны хувцас", "усны үргэлж хувцас"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("अख\u{902}ड कपड\u{94d}याचा पोहण\u{94d}याचा स\u{942}ट"),
            keywords: &[
                "अख\u{902}ड कपड\u{94d}याचा पोहण\u{94d}याचा स\u{942}ट",
                "आ\u{902}घोळ करताना घालायचा स\u{942}ट",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("sut renang terus"),
            keywords: &["sut mandi", "sut renang terus"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "က\u{102d}\u{102f}ယ\u{103a}လ\u{102f}\u{1036}းပြည\u{1037}\u{103a} ရေက\u{1030}းဝတ\u{103a}စ\u{102f}\u{1036}",
            ),
            keywords: &[
                "က\u{102d}\u{102f}ယ\u{103a}လ\u{102f}\u{1036}းပြည\u{1037}\u{103a} ရေက\u{1030}းဝတ\u{103a}စ\u{102f}\u{1036}",
                "ရေက\u{1030}းဝတ\u{103a}စ\u{102f}\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("badedrakt"),
            keywords: &["badedrakt", "badetøy"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("वान-पिस स\u{94d}विमस\u{941}ट"),
            keywords: &["न\u{941}हाउन\u{947} पोशाक", "वान-पिस स\u{94d}विमस\u{941}ट"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("badpak"),
            keywords: &["badpak", "zwempak"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("badedrakt"),
            keywords: &["badedrakt", "badetøy"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଏକ ଖଣ\u{b4d}ଡ ସ\u{b4d}ୱ\u{b3f}ମସ\u{b41}ଟ"),
            keywords: &[
                "ଏକ ଖଣ\u{b4d}ଡ ସ\u{b4d}ୱ\u{b3f}ମସ\u{b41}ଟ",
                "ଗ\u{b3e}ଧେଇବ\u{b3e} ପୋଷ\u{b3e}କ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਇ\u{a71}ਕ-ਪੀਸ ਵਾਲਾ ਸਵਿਮ ਸ\u{a42}ਟ"),
            keywords: &["ਇ\u{a71}ਕ-ਪੀਸ ਵਾਲਾ ਸਵਿਮ ਸ\u{a42}ਟ", "ਨਹਾਉਣ ਲਈ ਸ\u{a42}ਟ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tú-In-Wọ\u{301}n Swímín Klọt"),
            keywords: &["Báfín Klọt", "Tú-In-Wọ\u{301}n Swímín Klọt"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("strój kąpielowy jednoczęściowy"),
            keywords: &["kostium do kąpieli", "strój kąpielowy jednoczęściowy"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("يو ستوی د لامبو سوټ"),
            keywords: &["د لامبلو سوټ", "يو ستوی د لامبو سوټ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("maiô"),
            keywords: &["maiô", "roupa de banho"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("fato de banho"),
            keywords: &["fato de banho"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("costum de înot întreg"),
            keywords: &["costum de baie", "costum de înot întreg"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–060"),
            keywords: &["E12–060"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("цельный купальник"),
            keywords: &["закрытый", "купальник", "плавать", "спорт", "цельный"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("هڪ-پيس سوم سوٽ"),
            keywords: &["باٿنگ سوٽ", "هڪ-پيس سوم سوٽ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("තන\u{dd2}-කොටස\u{dca} ප\u{dd2}හ\u{dd2}න\u{dd4}ම\u{dca} ඇඳ\u{dd4}ම"),
            keywords: &[
                "තන\u{dd2}-කොටස\u{dca} ප\u{dd2}හ\u{dd2}න\u{dd4}ම\u{dca} ඇඳ\u{dd4}ම",
                "න\u{dcf}න ඇඳ\u{dd4}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("jednodielne plavky"),
            keywords: &["dámske plavky", "jednodielne plavky"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("enodelne kopalke"),
            keywords: &["enodelne kopalke", "kopalna obleka", "ženske kopalke"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("hal calal oo dharka dabaasha ah"),
            keywords: &["hal calal oo dharka dabaasha ah", "suudka dabaasha"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kostum plazhi"),
            keywords: &["kostum", "kostum plazhi", "plazh", "rroba plazhi"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("једноделни купаћи"),
            keywords: &["купаћи костим", "једноделни купаћи"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("једнодијелни купаћи"),
            keywords: &["једнодијелни купаћи"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("jednodelni kupaći"),
            keywords: &["jednodelni kupaći", "kupaći kostim"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("jednodijelni kupaći"),
            keywords: &["jednodijelni kupaći"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("baddräkt"),
            keywords: &["baddräkt", "simdräkt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nguo ya kuogelea"),
            keywords: &["nguo ya kuogelea", "vazi la kuogelea"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ந\u{bc0}ச\u{bcd}சல\u{bcd} ஆடை"),
            keywords: &["ஆடை", "குளியல\u{bcd} ஆடை", "ந\u{bc0}ச\u{bcd}சல\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వన\u{c4d}-ప\u{c40}స\u{c4d} స\u{c4d}వ\u{c3f}మ\u{c4d}\u{200c}సూట\u{c4d}"),
            keywords: &[
                "బ\u{c3e}త\u{c3f}ంగ\u{c4d} సూట\u{c4d}",
                "వన\u{c4d}-ప\u{c40}స\u{c4d} స\u{c4d}వ\u{c3f}మ\u{c4d}\u{200c}సూట\u{c4d}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ช\u{e38}ดว\u{e48}ายน\u{e49}ำว\u{e31}นพ\u{e35}ซ"),
            keywords: &[
                "ช\u{e38}ดว\u{e48}ายน\u{e49}ำ",
                "ช\u{e38}ดว\u{e48}ายน\u{e49}ำว\u{e31}นพ\u{e35}ซ",
                "ช\u{e38}ดเล\u{e48}นน\u{e49}ำ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("bitewi kupalnik"),
            keywords: &["bitewi kupalnik", "suwa düşülýän geýim"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("vala matātahi kongataha"),
            keywords: &["vala matātahi kongataha"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("tek parça mayo"),
            keywords: &["mayo", "tek parça mayo"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("суцільний купальник"),
            keywords: &["закритий", "купальний костюм", "суцільний купальник"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("و\u{64e}ن پیس تیراکی کا لباس"),
            keywords: &["نہانے کا لباس", "و\u{64e}ن پیس تیراکی کا لباس"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yaxlit choʻmilish kiyimi"),
            keywords: &["choʻmilish kiyimi", "yaxlit choʻmilish kiyimi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("áo tắm một mảnh"),
            keywords: &["bộ áo tắm", "áo tắm một mảnh"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("一件頭泳衣"),
            keywords: &["一件頭泳衣", "泳衣"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("一件头泳衣"),
            keywords: &["一件头泳衣", "泳衣"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("连体泳衣"),
            keywords: &["一片式", "泳衣", "泳装", "游泳", "连体泳衣"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("一件式泳裝"),
            keywords: &["一件式泳裝", "泳衣"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("一件式泳衣"),
            keywords: &["一件式泳衣", "泳衣"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("insudu yokubhukuda eyodwa"),
            keywords: &["insudu yebhavu", "insudu yokubhukuda eyodwa"],
        },
    ],
};
#[doc = "🩲"]
pub const BRIEFS: crate::Emoji = crate::Emoji {
    glyph: "🩲",
    codepoint: "1FA72",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "briefs",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("mansportswembroek"),
            keywords: &["eenstuk", "mansportswembroek", "onderklere", "swembroek"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አጭር መግለጫ"),
            keywords: &["አጭር መግለጫ", "ወጥ", "የመዋኛ ልብስ", "የዋና ልብስ", "ፓንት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ملابس تحتية"),
            keywords: &[
                "بدلة استحمام",
                "بدلة سباحة",
                "قطعة واحدة",
                "مايوه",
                "ملابس تحتية",
                "ملابس داخلية",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মহিল\u{9be}ৰ জ\u{9be}ঙ\u{9cd}গিয\u{9bc}\u{9be}"),
            keywords: &[
                "অন\u{9cd}তৰ\u{9cd}ব\u{9be}স",
                "এট\u{9be} স\u{9be}\u{981}তোৰৰ পোছ\u{9be}ক",
                "মহিল\u{9be}ৰ জ\u{9be}ঙ\u{9cd}গিয\u{9bc}\u{9be}",
                "স\u{9be}\u{981}তোৰোতে পিন\u{9cd}ধ\u{9be} জেকেট",
                "স\u{9be}\u{981}তোৰোতে পিন\u{9cd}ধ\u{9be} পোছ\u{9be}ক",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("trusik"),
            keywords: &["alt paltar", "hamam geyimi", "trusik", "üzgüçülük geyimi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("плаўкі"),
            keywords: &[
                "закрыты купальнік",
                "купальны касцюм",
                "ніжняя бялізна",
                "плаўкі",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("бански"),
            keywords: &["бански", "бански костюм", "долно бельо"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("জ\u{9be}ঙ\u{9cd}গিয\u{9bc}\u{9be}"),
            keywords: &[
                "এক-পিস",
                "জ\u{9be}ঙ\u{9cd}গিয\u{9bc}\u{9be}",
                "স\u{9c1}ইমিং কস\u{9cd}টিউম",
                "স\u{9cd}ন\u{9be}রের পোশ\u{9be}ক",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("slip"),
            keywords: &["dilhad-dindan", "dilhad-kouronkañ", "slip", "unpezh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("gaće"),
            keywords: &[
                "donji veš",
                "gaće",
                "jednodijelni",
                "kupaće gaće",
                "kupaći kostim",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("eslip"),
            keywords: &["banyador", "eslip", "roba interior", "vestit de bany"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏑᎶ ᏙᏳ ᏍᏆᎳ"),
            keywords: &["ᎠᏑᎶ ᏙᏳ ᏍᏆᎳ", "ᎠᏓᏬᎠ", "ᎥᏓᏬᏍᎬ ᏗᎿᏬᏍᏗ", "ᎭᏫᏂ ᏗᎿᏬᏍᏗ", "ᏌᏊᎯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("pánské plavky"),
            keywords: &["jednodílné", "plavky", "pánské plavky", "spodky"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("trôns"),
            keywords: &["gwisg nofio", "siwt nofio", "trôns"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("badebukser"),
            keywords: &["badebukser", "badetøj", "bikiniunderdel", "undertøj"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Slip"),
            keywords: &["Badeanzug", "Einteiler", "Slip", "Unterwäsche"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σλιπ"),
            keywords: &["εσώρουχο", "μαγιό", "μονοκόμματο", "σλιπ"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("briefs"),
            keywords: &[
                "bathing suit",
                "briefs",
                "one-piece",
                "swimsuit",
                "underwear",
            ],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &[
                "bathing suit",
                "briefs",
                "one-piece",
                "pants",
                "swimsuit",
                "underwear",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["bathers", "briefs", "speedos", "underwear"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &[
                "bathing suit",
                "briefs",
                "one-piece",
                "pants",
                "swimsuit",
                "underwear",
            ],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ropa interior"),
            keywords: &[
                "bañador",
                "bragas",
                "braguitas",
                "calzoncillos",
                "ropa interior",
                "slip",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["calzoncillos", "ropa interior", "slip", "traje de baño"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "bañador",
                "calzoncillo",
                "pantaleta",
                "ropa interior",
                "traje de baño",
                "una pieza",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("ujumispüksid"),
            keywords: &["aluspesu", "ujumiskostüüm", "ujumispüksid", "ujumisriie"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("galtzontzilloak"),
            keywords: &["azpiko arropa", "bainujantzi", "galtzontzilloak", "osoa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("شورت اسلیپ"),
            keywords: &["شورت اسلیپ", "لباس زیر", "مایو", "یک\u{200c}تکه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("uimahousut"),
            keywords: &["alushousut", "uima-asu", "uimahousut"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mga brief"),
            keywords: &[
                "bathing suit",
                "damit panloob",
                "mga brief",
                "one-piece",
                "panligo",
                "swimsuit",
                "underwear",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("trussur"),
            keywords: &["trussur", "undirklæðir"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("slip"),
            keywords: &["maillot de bain", "slip", "sous-vêtement"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "bobettes",
                "maillot de bain",
                "slip",
                "sous-vêtement",
                "une pièce",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("culaith shnámha fir"),
            keywords: &[
                "aonphíosa",
                "culaith shnámha",
                "culaith shnámha fir",
                "fo-éadaí",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("briogais-shnàimh"),
            keywords: &["briogais-shnàimh", "deise-snàmh", "fo-aodach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("calzón"),
            keywords: &["bañarse", "calzón", "roupa interior", "traxe de baño"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચડ\u{acd}ડી"),
            keywords: &[
                "અ\u{a82}ડરવ\u{ac7}યર",
                "ચડ\u{acd}ડી",
                "બાથ સ\u{acd}ય\u{ac2}ટ",
                "વન-પીસ",
                "સ\u{acd}વિમસ\u{acd}ય\u{ac2}ટ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("תחתונים"),
            keywords: &["בגד ים", "הלבשה תחתונה", "תחתון", "תחתונים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("अ\u{902}डरवियर"),
            keywords: &[
                "अ\u{902}डरवियर",
                "बाथ स\u{942}ट",
                "वनपीस",
                "स\u{94d}विमस\u{942}ट",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("gaćice"),
            keywords: &["donje rublje", "gaćice", "kupaći kostim"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fürdőnadrág"),
            keywords: &["alsó", "egyrészes", "fürdőnadrág"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("լողավարտիք"),
            keywords: &["անդրավարտիք", "լողազգեստ", "լողավարտիք", "ներքնազգեստ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("celana renang"),
            keywords: &[
                "baju renang",
                "celana renang",
                "one-piece",
                "pakaian dalam",
                "pakaian renang",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("nærbuxur"),
            keywords: &["nærbuxur", "nærföt", "sundbolur", "sundföt"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("slip"),
            keywords: &[
                "costume da bagno maschile",
                "costume da uomo",
                "intimo",
                "mutande da uomo",
                "slip",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ブリーフ"),
            keywords: &["スイムウェア", "パンツ", "ブリーフ", "下着", "水着"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kathok njero"),
            keywords: &[
                "kathok njero",
                "klambi nglangi",
                "klambi njero",
                "mantel adus",
                "terusan",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("საცურაო ტრუსი"),
            keywords: &["საცურაო კოსტიუმი", "საცურაო ტრუსი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("плавки"),
            keywords: &[
                "жабық",
                "плавки",
                "шомылу киімі",
                "шомылу костюмі",
                "іш киім",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ខោក\u{17d2}ន\u{17bb}ង"),
            keywords: &[
                "ខោក\u{17d2}ន\u{17bb}ង",
                "ឈ\u{17bb}តង\u{17bd}តទ\u{17b9}ក",
                "ឈ\u{17bb}តហែលទ\u{17b9}ក",
                "ម\u{17bd}យឈ\u{17bb}ត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{ccd}ರೀಫ\u{ccd}\u{200c}ಗಳು"),
            keywords: &[
                "ಅಂಡರ\u{ccd}\u{200c}ವೇರ\u{ccd}",
                "ಈಜುಡುಗ\u{cc6}",
                "ಒಂದು ತುಂಡು",
                "ಬ\u{ccd}ರೀಫ\u{ccd}\u{200c}ಗಳು",
                "ಸ\u{ccd}ನಾನದ ಉಡುಗ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("삼각 수영복"),
            keywords: &["삼각 수영복", "수영복", "언더웨어"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ब\u{94d}रिफ\u{94d}स"),
            keywords: &[
                "अ\u{902}डरवियर",
                "अ\u{902}तर\u{94d}वस\u{94d}त\u{94d}र",
                "च\u{947}ड\u{94d}डी",
                "न\u{94d}हावपा स\u{941}ट",
                "प\u{947}\u{902}वपास\u{941}ट",
                "ब\u{94d}रिफ\u{94d}स",
                "वनपीस",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ич кийим"),
            keywords: &[
                "бир даана",
                "ич кийим",
                "ички кийим",
                "мончо кийими",
                "сууга сүзүүчү кийим",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໂສ\u{ec9}ງ\u{200b}ຊ\u{ec9}ອນ\u{200b}ໃນ\u{200b}ຜ\u{eb9}\u{ec9}\u{200b}ຊາຍ"),
            keywords: &[
                "ຊ\u{eb8}ດ\u{200b}ລອຍ\u{200b}ນ\u{ec9}ຳ",
                "ໂສ\u{ec9}ງ\u{200b}ຊ\u{ec9}ອນ\u{200b}ໃນ\u{200b}ຜ\u{eb9}\u{ec9}\u{200b}ຊາຍ",
                "ໂສ\u{ec9}ງ\u{200b}ຊ\u{ec9}\u{200b}ອນ\u{200b}ໃນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("trumpikės"),
            keywords: &[
                "apatiniai",
                "maudymosi kostiumėlis",
                "trumpikės",
                "viena dalis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("peldbikses"),
            keywords: &[
                "apakšveļa",
                "peldbikses",
                "peldkostīms",
                "peldēšanās tērps",
                "viengabala",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("килоти"),
            keywords: &["долна облека", "килоти", "костим за капење"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("അടിവസ\u{d4d}\u{200c}ത\u{d4d}രം"),
            keywords: &[
                "അടിവസ\u{d4d}\u{200c}ത\u{d4d}രം",
                "നീന\u{d4d}തൽ വസ\u{d4d}\u{200c}ത\u{d4d}രം",
                "ബ\u{d3e}ത\u{d4d}തിംഗ\u{d4d} സ\u{d4d}യ\u{d42}ട\u{d4d}ട\u{d4d}",
                "വൺ-പീസ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дотуур өмд"),
            keywords: &[
                "дотуур хувцас",
                "дотуур өмд",
                "купальник",
                "салдаггүй",
                "усны хувцас",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ब\u{94d}रीफ"),
            keywords: &[
                "अ\u{902}डरव\u{947}अर",
                "अख\u{902}ड कपड\u{94d}याचा",
                "आ\u{902}घोळ करताना घालायचा स\u{942}ट",
                "पोहण\u{94d}याचा स\u{942}ट",
                "ब\u{94d}रीफ",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("seluar dalam"),
            keywords: &[
                "pakaian dalam",
                "seluar dalam",
                "sut mandi",
                "sut renang",
                "terus",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အတ\u{103d}င\u{103a}းခ\u{1036} ဘောင\u{103a}းဘ\u{102e}"),
            keywords: &[
                "ရေက\u{1030}းဝတ\u{103a}စ\u{102f}\u{1036}",
                "အတ\u{103d}င\u{103a}းခ\u{1036}",
                "အတ\u{103d}င\u{103a}းခ\u{1036} ဘောင\u{103a}းဘ\u{102e}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("truse"),
            keywords: &["badebukse", "badetøy", "bikinitruse", "truse", "undertøy"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ब\u{94d}रिफ\u{94d}स"),
            keywords: &[
                "कट\u{94d}ट\u{941}",
                "न\u{941}हाउन\u{947} पोशाक",
                "ब\u{94d}रिफ\u{94d}स",
                "वान-पिस",
                "स\u{94d}विमस\u{941}ट",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("slip"),
            keywords: &["ondergoed", "slip", "zwembroek"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("truse"),
            keywords: &["badebukse", "badetøy", "bikinitruse", "truse", "undertøy"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b4d}ର\u{b3f}ଫ"),
            keywords: &[
                "ଏକ ଖଣ\u{b4d}ଡ",
                "ଗ\u{b3e}ଧେଇବ\u{b3e} ପୋଷ\u{b3e}କ",
                "ଚଡ\u{b3f}",
                "ବ\u{b4d}ର\u{b3f}ଫ",
                "ସ\u{b4d}ୱ\u{b3f}ମସ\u{b41}ଟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a71}ਛ\u{a47}"),
            keywords: &[
                "ਅ\u{a70}ਡਰਵੀਅਰ",
                "ਕ\u{a71}ਛ\u{a47}",
                "ਤ\u{a48}ਰਾਕੀ ਲਈ ਸ\u{a42}ਟ",
                "ਨਹਾਉਣ ਲਈ ਸ\u{a42}ਟ",
                "ਵਨ-ਪੀਸ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mán Swímín Pant"),
            keywords: &[
                "Báfín Klọt",
                "Mán Swímín Pant",
                "Pant",
                "Swímín Klọt",
                "Tú-In-Wọn",
                "Ọndawia",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kąpielówki"),
            keywords: &[
                "bielizna",
                "kąpielówki",
                "majtki do kąpieli",
                "strój do kąpieli",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لنډ جانګی"),
            keywords: &["جانګی", "د لامبلو سوټ", "لنډ جانګی", "يو ستوے د لامبو سوټ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cueca"),
            keywords: &[
                "cueca",
                "peça única",
                "roupa de banho",
                "roupa de praia",
                "roupa íntima",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("slip de banho"),
            keywords: &["fato de banho", "roupa interior", "slip de banho"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("slip"),
            keywords: &["chilot", "costum de baie", "lenjerie", "slip"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–061"),
            keywords: &["E12–061"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("плавки"),
            keywords: &["купальник", "плавать", "плавки", "трусы", "шорты"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بريفس"),
            keywords: &["انڊر ويئر", "باٿنگ سوٽ", "بريفس", "سوم سوٽ", "ون-پيس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සංක\u{dca}ෂ\u{dd2}ප\u{dca}තයන\u{dca}"),
            keywords: &[
                "තන\u{dd2}-කැබැල\u{dca}ල",
                "න\u{dcf}න ඇඳ\u{dd4}ම",
                "ප\u{dd2}හ\u{dd2}න\u{dd4}ම\u{dca} ඇඳ\u{dd4}ම",
                "යට ඇඳ\u{dd4}ම\u{dca}",
                "සංක\u{dca}ෂ\u{dd2}ප\u{dca}තයන\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("slipy"),
            keywords: &["bielizeň", "jednodielne", "plavky", "slipy", "spodky"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("spodnje hlače"),
            keywords: &[
                "enodelno",
                "kopalke",
                "kopalno oblačilo",
                "spodnje hlače",
                "spodnje perilo",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("nigis"),
            keywords: &["dharka dabaasha", "hal calal", "nigis", "suudka dabaasha"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("mbathje plazhi"),
            keywords: &["kostum", "mbathje plazhi", "rroba plazhi", "të brendshme"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("гаће"),
            keywords: &["гаће", "доњи веш", "купаће гаће"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("gaće"),
            keywords: &["donji veš", "gaće", "kupaće gaće"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("badbyxor"),
            keywords: &["badbyxor", "badkläder", "badshorts", "simutrustning"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("chupi"),
            keywords: &["chupi", "nguo", "nguo ya kuogelea", "vazi la kuogelea"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("குறுங\u{bcd}க\u{bbe}ல\u{bcd}சட\u{bcd}டை"),
            keywords: &[
                "உள\u{bcd}ள\u{bbe}டை",
                "குறுங\u{bcd}க\u{bbe}ல\u{bcd}சட\u{bcd}டை",
                "குளியல\u{bcd} ஆடை",
                "ந\u{bc0}ச\u{bcd}சல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ల\u{c4b}దుస\u{c4d}తులు"),
            keywords: &[
                "బ\u{c3e}త\u{c3f}ంగ\u{c4d} సూట\u{c4d}",
                "ల\u{c4b}దుస\u{c4d}తులు",
                "వన\u{c4d}-ప\u{c40}స\u{c4d}",
                "స\u{c4d}వ\u{c3f}మ\u{c4d}\u{200c}సూట\u{c4d}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("กางเกงช\u{e31}\u{e49}นในชาย"),
            keywords: &[
                "กางเกงช\u{e31}\u{e49}นในชาย",
                "ข\u{e38}ดช\u{e31}\u{e49}นใน",
                "ช\u{e38}ดว\u{e48}ายน\u{e49}ำ",
                "ช\u{e38}ดเล\u{e48}นน\u{e49}ำ",
                "ว\u{e31}นพ\u{e35}ซ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gysga türsük"),
            keywords: &[
                "bitewi",
                "gysga türsük",
                "içki geýim",
                "suwa düşülýän geýim",
                "ýüzülýän geýim",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("talausese loto"),
            keywords: &["talausese loto"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("slip mayo"),
            keywords: &["alt", "mayo", "slip", "tek parça"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("плавки"),
            keywords: &[
                "брифи",
                "купальник",
                "одинарний",
                "плавки",
                "спіднє",
                "труси",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جانگھیا"),
            keywords: &[
                "تیراکی کا لباس",
                "جانگھیا",
                "زیر\u{650} جامہ",
                "نہانے کا لباس",
                "و\u{64e}ن پیس",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("trusik"),
            keywords: &[
                "chomilish trusigi",
                "choʻmilish kiyimi",
                "ich kiyim",
                "trusik",
                "yaxlit",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("quần lót"),
            keywords: &["bộ đồ bơi", "bộ đồ tắm", "một mảnh", "quần lót"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("泳褲"),
            keywords: &["一件頭", "內衣", "泳衣", "泳褲"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("泳裤"),
            keywords: &["一件头", "内衣", "泳衣", "泳裤"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("三角裤"),
            keywords: &["一片式", "三角裤", "内裤", "泳衣", "泳装", "短裤"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("泳褲"),
            keywords: &["一件式", "泳裝", "泳褲"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["一件式", "泳衣", "泳褲"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("izifinyezo"),
            keywords: &[
                "insudu yebhavu",
                "insudu yokubhukuda",
                "izifinyezo",
                "kokugqoka ngaphansi",
                "ucezu olulodwa",
            ],
        },
    ],
};
#[doc = "🩳"]
pub const SHORTS: crate::Emoji = crate::Emoji {
    glyph: "🩳",
    codepoint: "1FA73",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "shorts",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("manswembroek"),
            keywords: &["broek", "manswembroek", "onderklere", "swembroek"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቁምጣ"),
            keywords: &["ሙታንታና ካናቴራ", "ቁምጣ", "የዋና ልብስ", "ፓንት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شورت"),
            keywords: &[
                "بدلة استحمام",
                "شورت",
                "مايوه",
                "ملابس تحتية",
                "ملابس داخلية",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হ\u{9be}ফপেণ\u{9cd}ট"),
            keywords: &[
                "অন\u{9cd}তৰ\u{9cd}ব\u{9be}স",
                "পেণ\u{9cd}ট",
                "স\u{9cd}ন\u{9be}ন কৰো\u{981}তে পিন\u{9cd}ধ\u{9be} পোছ\u{9be}ক",
                "হ\u{9be}ফপেণ\u{9cd}ট",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("şort"),
            keywords: &["alt paltar", "hamam geyimi", "şalvar", "şort"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("шорты"),
            keywords: &["купальны касцюм", "ніжняя бялізна", "трусы", "шорты"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("плувни шорти"),
            keywords: &[
                "бански костюм",
                "долно бельо",
                "къси панталони",
                "плувни шорти",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("শর\u{9cd}টস"),
            keywords: &[
                "অন\u{9cd}তর\u{9cd}ব\u{9be}স",
                "প\u{9cd}য\u{9be}ন\u{9cd}ট",
                "শর\u{9cd}টস",
                "স\u{9cd}ন\u{9be}নের পোশ\u{9be}ক",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bragoù-berr"),
            keywords: &["bragoù-berr", "dilhad-kouronkañ", "unpezh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("šorc"),
            keywords: &["donji veš", "kupaći kostim", "kupaći šorc", "šorc"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pantalons curts"),
            keywords: &[
                "banyador",
                "pantalons curts",
                "pantaló",
                "roba interior",
                "vestit de bany",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏑᎶ ᏍᏆᎳ"),
            keywords: &["ᎠᏑᎶ", "ᎠᏑᎶ ᏍᏆᎳ", "ᎥᏓᏬᏍᎬ ᏗᎿᏬᏍᏗ", "ᎭᏫᏂ ᏗᎿᏬᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("šortky"),
            keywords: &[
                "jednodílné",
                "kraťasy",
                "krátké kalhoty",
                "plavky",
                "spodky",
                "trenýrky",
                "šortky",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("siorts"),
            keywords: &["dillad isa", "siorts", "siwt nofio", "trôns"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("shorts"),
            keywords: &["badebukser", "shorts", "underbukser"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Shorts"),
            keywords: &["Badebekleidung", "Boxershorts", "Schwimmshorts", "Shorts"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σορτσάκι"),
            keywords: &["βερμούδα", "εσώρουχο", "μαγιό", "σορτς", "σορτσάκι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("shorts"),
            keywords: &["bathing suit", "pants", "shorts", "underwear"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &[
                "bathing suit",
                "boardshorts",
                "shorts",
                "swim shorts",
                "underwear",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &[
                "bathing suit",
                "boardies",
                "boardshorts",
                "shorts",
                "swim shorts",
                "underwear",
            ],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &[
                "bathing suit",
                "boardshorts",
                "shorts",
                "swim shorts",
                "underwear",
            ],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pantalones cortos"),
            keywords: &[
                "bañador",
                "bermudas",
                "calzoncillos",
                "pantalones cortos",
                "ropa interior",
                "shorts",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("shorts"),
            keywords: &["shorts"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "cortos",
                "pantalones",
                "ropa interior",
                "shorts",
                "traje de baño",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("šortsid"),
            keywords: &["aluspesu", "lühikesed püksid", "ujumisriie", "šortsid"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("galtzamotzak"),
            keywords: &["azpiko arropa", "bainujantzi", "galtzak", "galtzamotzak"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("شلوارک"),
            keywords: &["شلوار", "شلوارک", "لباس زیر", "مایو"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("uimashortsit"),
            keywords: &["alushousut", "shortsit", "uimashortsit"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("shorts"),
            keywords: &[
                "bathing suit",
                "damit panloob",
                "panligo",
                "shorts",
                "underwear",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("shorts"),
            keywords: &["brøkur", "shorts", "stuttar"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("short"),
            keywords: &["caleçon", "maillot de bain", "short", "sous-vêtement"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("brístí gearra"),
            keywords: &["bríste", "brístí gearra", "culaith shnámha", "fo-éadaí"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("briogais-ghlùine"),
            keywords: &[
                "briogais-ghlùine",
                "briogais-shnàimh",
                "deise-snàmh",
                "fo-aodach",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("pantalón curto"),
            keywords: &[
                "bañador",
                "calzón",
                "pantalón curto",
                "roupa interior",
                "traxe de baño",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("શૉર\u{acd}ટ\u{acd}સ"),
            keywords: &[
                "અ\u{a82}ડરવ\u{ac7}યર",
                "પ\u{ac7}ન\u{acd}ટ",
                "બાથ સ\u{acd}ય\u{ac2}ટ",
                "શૉર\u{acd}ટ\u{acd}સ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מכנסיים קצרים"),
            keywords: &[
                "בגד ים",
                "בגד רחצה",
                "הלבשה תחתונה",
                "מכנס קצר",
                "מכנסיים קצרים",
                "תחתונים",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("शॉर\u{94d}ट\u{94d}स"),
            keywords: &[
                "अ\u{902}डरवियर",
                "पतल\u{942}न",
                "प\u{948}\u{902}ट",
                "बाथि\u{902}ग स\u{942}ट",
                "शॉर\u{94d}ट\u{94d}स",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kratke hlače"),
            keywords: &[
                "donje rublje",
                "hlače",
                "hlačice za kupanje",
                "kratke hlače",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("rövidnadrág"),
            keywords: &["alsó", "fürdőnadrág", "rövidnadrág"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("շորտեր"),
            keywords: &["լողավարտիք", "ներքնազգեստ", "շորտեր", "վարտիք", "տաբատ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("celana pendek"),
            keywords: &[
                "baju renang",
                "celana",
                "celana pendek",
                "pakaian dalam",
                "pakaian renang",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("stuttbuxur"),
            keywords: &["buxur", "nærbuxur", "nærföt", "stuttbuxur", "sundföt"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pantaloncini"),
            keywords: &[
                "boxer",
                "costume da bagno maschile",
                "costume da uomo",
                "intimo",
                "mutande da uomo",
                "pantaloncini",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ショーツ"),
            keywords: &["ショーツ", "スイムウェア", "パンツ", "下着", "水着"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kathok cendhak"),
            keywords: &["kathok", "kathok cendhak", "klambi adus", "klambi njero"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("შორტები"),
            keywords: &[
                "საბანაო კოსტიუმი",
                "საბანაო შორტები",
                "საცვალი",
                "საცურაო კოსტიუმი",
                "შორტები",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шолақ шалбар"),
            keywords: &["дамбал", "шолақ шалбар", "шомылу костюмі", "іш киім"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ខោខ\u{17d2}ល\u{17b8}"),
            keywords: &[
                "ខោក\u{17d2}ន\u{17bb}ង",
                "ខោខ\u{17d2}ល\u{17b8}",
                "ឈ\u{17bb}តង\u{17bd}តទ\u{17b9}ក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಶಾರ\u{ccd}ಟ\u{ccd}ಸ\u{ccd}"),
            keywords: &[
                "ಅಂಡರ\u{ccd}\u{200c}ವೇರ\u{ccd}",
                "ಪ\u{ccd}ಯಾಂಟ\u{ccd}\u{200c}ಗಳು",
                "ಶಾರ\u{ccd}ಟ\u{ccd}ಸ\u{ccd}",
                "ಸ\u{ccd}ನಾನದ ಉಡುಗ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("반바지"),
            keywords: &["반바지", "수영복"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("शॉर\u{94d}ट\u{94d}स"),
            keywords: &[
                "अ\u{902}डरवियर",
                "अ\u{902}तर\u{94d}वस\u{94d}त\u{94d}र",
                "न\u{94d}हा\u{902}वपा स\u{941}ट",
                "प\u{945}ण\u{94d}ट\u{94d}स",
                "शॉर\u{94d}ट\u{94d}स",
                "हाफ-चड\u{94d}डी",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чолок шым"),
            keywords: &["ички кийим", "мончо кийими", "чолок шым", "шым"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໂສ\u{ec9}ງ\u{200b}ຂາ\u{200b}ສ\u{eb1}\u{ec9}ນ"),
            keywords: &[
                "ຊ\u{200b}\u{eb8}ດ\u{200b}ລ\u{200b}ອຍ\u{200b}ນ\u{ec9}ຳ",
                "ໂສ\u{ec9}ງ",
                "ໂສ\u{ec9}ງ\u{200b}ຂາ\u{200b}ສ\u{eb1}\u{ec9}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("šortai"),
            keywords: &["apatiniai", "maudymosi kostiumas", "trumpikės", "šortai"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("šorti"),
            keywords: &["apakšveļa", "bikses", "peldkostīms", "šorti"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("шорцеви"),
            keywords: &["кратки панталони", "шорцеви"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഷോർട\u{d4d}\u{200c}സ\u{d4d}"),
            keywords: &[
                "അടിവസ\u{d4d}\u{200c}ത\u{d4d}രം",
                "പ\u{d3e}ന\u{d4d}റ\u{d4d}സ\u{d4d}",
                "ബ\u{d3e}ത\u{d4d}തിംഗ\u{d4d} സ\u{d4d}യ\u{d42}ട\u{d4d}ട\u{d4d}",
                "ഷോർട\u{d4d}\u{200c}സ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("богино өмд"),
            keywords: &["богино өмд", "дотуур өмд", "усны хувцас", "өмд"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("शॉर\u{94d}ट\u{94d}स"),
            keywords: &[
                "अ\u{902}डरव\u{947}अर",
                "आ\u{902}घोळ करताना घालायचा स\u{942}ट",
                "प\u{901}ट",
                "शॉर\u{94d}ट\u{94d}स",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("seluar pendek"),
            keywords: &["baju mandi", "pakaian dalam", "seluar", "seluar pendek"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဘောင\u{103a}းဘ\u{102e}တ\u{102d}\u{102f}"),
            keywords: &[
                "ဘောင\u{103a}းဘ\u{102e}",
                "ဘောင\u{103a}းဘ\u{102e}တ\u{102d}\u{102f}",
                "ရေက\u{1030}းဘောင\u{103a}းဘ\u{102e}",
                "အတ\u{103d}င\u{103a}းခ\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("shorts"),
            keywords: &[
                "badeshorts",
                "badetøy",
                "bukse",
                "shorts",
                "underbukse",
                "undertøy",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("छोटो ल\u{941}गा"),
            keywords: &[
                "कट\u{94d}ट\u{941}",
                "छोटो ल\u{941}गा",
                "न\u{941}हाउन\u{947} पोशाक",
                "स\u{941}र\u{941}वाल",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("korte broek"),
            keywords: &["korte broek", "onderbroek", "shorts", "zwembroek"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("shorts"),
            keywords: &[
                "badeshorts",
                "badetøy",
                "bukse",
                "shorts",
                "underbukse",
                "undertøy",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସର\u{b4d}ଟ\u{b4d}ସ"),
            keywords: &[
                "ଗ\u{b3e}ଧେଇବ\u{b3e} ପୋଷ\u{b3e}କ",
                "ଚଡ\u{b3f}",
                "ପ\u{b4d}ୟ\u{b3e}ଣ\u{b4d}ଟ",
                "ସର\u{b4d}ଟ\u{b4d}ସ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਨਿ\u{a71}ਕਰਾ\u{a02}"),
            keywords: &[
                "ਅ\u{a70}ਡਰਵੀਅਰ",
                "ਨਹਾਉਣ ਲਈ ਸ\u{a42}ਟ",
                "ਨਿ\u{a71}ਕਰਾ\u{a02}",
                "ਪ\u{a48}\u{a02}ਟਾ\u{a02}",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Shọ\u{301}t Níka"),
            keywords: &[
                "Báfín Klọt",
                "Pant",
                "Shọ\u{301}t Níka",
                "Shọ\u{301}tníka",
                "Ọndawia",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("szorty"),
            keywords: &[
                "bermudy",
                "bielizna",
                "spodenki",
                "strój do kąpieli",
                "szorty",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("جانګی"),
            keywords: &["جانګی", "د لامبلو سوټ", "پتلون"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("shorts"),
            keywords: &["bermuda", "roupa de banho", "roupa de praia", "shorts"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("calções de banho"),
            keywords: &[
                "calções de banho",
                "fato de banho",
                "roupa interior",
                "slip",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("șort"),
            keywords: &["boxeri", "costum de baie", "lenjerie", "șort"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–062"),
            keywords: &["E12–062"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("шорты"),
            keywords: &["белье", "плавать", "плавки", "спорт", "трусы", "шорты"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("شارٽس"),
            keywords: &["انڊر ويئر", "باٿنگ سوٽ", "شارٽس", "پينٽس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කොට කල\u{dd2}සම\u{dca}"),
            keywords: &[
                "කොට කල\u{dd2}සම\u{dca}",
                "න\u{dcf}න ඇඳ\u{dd4}ම",
                "යට ඇඳ\u{dd4}ම",
                "යට කල\u{dd2}සම\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("šortky"),
            keywords: &[
                "jednodielne",
                "kraťasy",
                "krátke nohavice",
                "plavky",
                "spodky",
                "trenírky",
                "šortky",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kratke hlače"),
            keywords: &["kopalke", "kopalne hlače", "kratke hlače", "spodnje perilo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("shoorti"),
            keywords: &["dharka dabaasha", "nigis", "shoorti", "surwaal"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("pantallona të shkurtra"),
            keywords: &["pantallona të shkurtra", "rroba plazhi", "të brendshme"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("шорц"),
            keywords: &["доњи веш", "купаћи костим", "панталоне", "шорц"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["шорц"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("šorc"),
            keywords: &["donji veš", "kupaći kostim", "pantalone", "šorc"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["šorc"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("shorts"),
            keywords: &["badbyxor", "badkläder", "shorts", "underkläder"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kaptura"),
            keywords: &["chupi", "kaptura", "suruali", "vazi la kuogelea"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("க\u{bbe}ல\u{bcd}சட\u{bcd}டை"),
            keywords: &[
                "உள\u{bcd}ள\u{bbe}டை",
                "க\u{bbe}ல\u{bcd}சட\u{bcd}டை",
                "குளியல\u{bcd} ஆடை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ష\u{c3e}ర\u{c4d}ట\u{c4d}స\u{c4d}"),
            keywords: &[
                "ప\u{c4d}య\u{c3e}ంటులు",
                "బ\u{c3e}త\u{c3f}ంగ\u{c4d} సూట\u{c4d}",
                "ల\u{c4b}దుస\u{c4d}తులు",
                "ష\u{c3e}ర\u{c4d}ట\u{c4d}స\u{c4d}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("กางเกงขาส\u{e31}\u{e49}น"),
            keywords: &[
                "กางเกงขายาว",
                "กางเกงขาส\u{e31}\u{e49}น",
                "ข\u{e38}ดช\u{e31}\u{e49}นใน",
                "ช\u{e38}ดว\u{e48}ายน\u{e49}ำ",
                "ช\u{e38}ดเล\u{e48}นน\u{e49}ำ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("şorty"),
            keywords: &["içki geýim", "jalbar", "suwa düşülýän geýimler", "şorty"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("talausese mutu"),
            keywords: &["talausese mutu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("şort"),
            keywords: &["alt", "mayo", "şort"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("шорти"),
            keywords: &["купальник", "спіднє", "труси", "шорти"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("نیکر"),
            keywords: &["زیر\u{650} جامہ", "نہانے کا لباس", "نیکر", "پینٹس"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kalta ishton"),
            keywords: &["choʻmilish kiyimi", "ich kiyimi", "ishton", "kalta ishton"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("quần soóc"),
            keywords: &["bộ đồ tắm", "quần dài", "quần lót", "quần soóc"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("短褲"),
            keywords: &["內衣", "泳衣", "短褲"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("短裤"),
            keywords: &["内衣", "泳衣", "短裤"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("短裤"),
            keywords: &["内裤", "四角裤", "泳衣", "泳装", "短裤", "裤子"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("短泳褲"),
            keywords: &["泳褲", "短泳褲", "褲裝"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("短褲"),
            keywords: &["底褲", "泳褲", "短褲", "褲"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("izikhindi"),
            keywords: &[
                "ibhulukwe",
                "insudu yebhavu",
                "izikhindi",
                "kokugqoka ngaphansi",
            ],
        },
    ],
};
#[doc = "👙"]
pub const BIKINI: crate::Emoji = crate::Emoji {
    glyph: "👙",
    codepoint: "1F459",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "bikini",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("bikini"),
            keywords: &["bikini", "klere", "swem"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቢኪኒ"),
            keywords: &["ቢኪኒ", "አልባሳት", "ዋና"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ملابس البحر"),
            keywords: &["ملابس", "ملابس استحمام", "ملابس البحر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বিকিনি"),
            keywords: &["পোছ\u{9be}ক", "বিকিনি", "স\u{9be}\u{981}তোৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("bikini"),
            keywords: &["bikini", "geyim", "üzmək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("бікіні"),
            keywords: &["адзенне", "бікіні", "купальнік"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("бикини"),
            keywords: &["бикини", "облекло", "плуване"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বিকিনি"),
            keywords: &[
                "পোশ\u{9be}ক",
                "বিকিনি",
                "স\u{9be}\u{981}ত\u{9be}র ক\u{9be}ট\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bikini"),
            keywords: &["bikini", "dilhad-kouronkañ"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("bikini"),
            keywords: &["bikini", "kupaći", "odjevni predmet"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("biquini"),
            keywords: &["biquini", "nedar", "roba"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎥᏓᏬᏍᎬᎢ ᏗᎿᏬᏍᏗ"),
            keywords: &["ᎠᏓᏬ", "ᎥᏓᏬᏍᎬᎢ ᏗᎿᏬᏍᏗ", "ᏗᎿᏬᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("bikiny"),
            keywords: &["bikiny", "koupání", "oblečení", "plavky", "plavání"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bicini"),
            keywords: &["bicini", "dillad", "nofio"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bikini"),
            keywords: &["badetøj", "beklædning", "bikini"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Bikini"),
            keywords: &["Badeanzug", "Bikini", "Kleidung"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μπικίνι"),
            keywords: &["κολύμβηση", "μπικίνι", "ρούχο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("bikini"),
            keywords: &["bikini", "clothing", "swim"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["bikini", "clothing", "swim suit", "two-piece"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bikini"),
            keywords: &["baño", "bikini", "playa", "ropa"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "baño",
                "bikini",
                "nadar",
                "pileta",
                "piscina",
                "ropa",
                "traje",
                "vestimenta",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "alberca",
                "bikini",
                "nadar",
                "piscina",
                "ropa",
                "traje de baño",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["bikini", "nadar", "pileta", "piscina", "ropa", "traje"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("bikiinid"),
            keywords: &["bikiinid", "riided", "ujumine"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bikinia"),
            keywords: &["arropa", "bikinia", "igeri"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بیکینی"),
            keywords: &["بیکینی", "شنا", "مایو", "پوشاک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("bikinit"),
            keywords: &["bikinit", "uida", "uimapuku", "vaatteet"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bikini"),
            keywords: &[
                "bikini",
                "damit",
                "kasuotan",
                "pandagat",
                "panlangoy",
                "swimsuit",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("bikini"),
            keywords: &["bikini", "klæði", "svimjiklæðir"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bikini"),
            keywords: &["bikini", "maillot de bain"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["bikini", "maillot de bain", "vêtements"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bicíní"),
            keywords: &["bicíní", "bikini", "éadaí snámha"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bikini"),
            keywords: &["aodach", "bikini", "snàmh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("bikini"),
            keywords: &["bañarse", "bikini"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બિકીની"),
            keywords: &["કપડા\u{a82}", "નાહવાના\u{a82} કપડા\u{a82}", "બિકીની"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("bikini"),
            keywords: &["bikini", "ninƙaya", "sutura"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ביקיני"),
            keywords: &["בגד", "ביקיני", "ים", "קיץ"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बिकनी"),
            keywords: &["पोषाक", "बाथि\u{902}ग स\u{942}ट", "बिकनी"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("bikini"),
            keywords: &["bikini", "odjeća", "plivanje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("bikini"),
            keywords: &["bikini", "fürdő", "ruha", "ruházat", "úszás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բիկինի"),
            keywords: &["բիկինի", "լողալ", "հագուստ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bikini"),
            keywords: &["bikini", "pakaian", "renang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("bikini"),
            keywords: &["akwà mmiri", "bikini", "na-eme akwà"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("bikíní"),
            keywords: &["bikíní", "klæðnaður", "sundföt"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("bikini"),
            keywords: &["abbigliamento", "bikini", "costume due pezzi"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ビキニ"),
            keywords: &["ビキニ", "水着"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bikini"),
            keywords: &["bikini", "nglangi", "sandhangan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბიკინი"),
            keywords: &["ბიკინი", "საცურაო", "ტანსაცმელი", "ცურვა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бикини"),
            keywords: &["бикини", "жүзу", "киім"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("bikini"),
            keywords: &["badetøj", "beklædning", "bikini"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ឈ\u{17bb}តប\u{17ca}\u{17b8}គ\u{17b8}ន\u{17b8} (ឈ\u{17bb}តហែលទ\u{17b9}ក)"),
            keywords: &[
                "ឈ\u{17bb}តប\u{17ca}\u{17b8}គ\u{17b8}ន\u{17b8} (ឈ\u{17bb}តហែលទ\u{17b9}ក)",
                "ឈ\u{17bb}តហែលទ\u{17b9}ក",
                "ស\u{17ca}\u{17b7}ចស\u{17ca}\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{cbf}ಕ\u{cbf}ನ\u{cbf}"),
            keywords: &["ಬ\u{cbf}ಕ\u{cbf}ನ\u{cbf}", "ಸ\u{ccd}ನಾನದ ಸ\u{cc2}ಟ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("비키니"),
            keywords: &["비키니", "수영복"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बिकिनी"),
            keywords: &["कपड\u{947}", "प\u{947}\u{902}वप", "बिकिनी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бикини"),
            keywords: &["бикини", "кийим", "сууда сүз"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Bikini"),
            keywords: &["Bikini", "Kleedung", "schwammen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຊ\u{eb8}ດຊ\u{eb1}\u{ec9}ນໃນ"),
            keywords: &["ຊ\u{eb8}ດຊ\u{eb1}\u{ec9}ນໃນ", "ເສ\u{eb7}\u{ec9}ອຜ\u{ec9}າ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("bikinis"),
            keywords: &["bikinis", "drabužiai", "plaukti"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("bikini"),
            keywords: &["apģērbs", "bikini", "peldēt"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pikīni"),
            keywords: &["kaukau", "kākahu", "pikīni"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("бикини"),
            keywords: &["бикини", "жена", "облека", "пливање"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ബിക\u{d4d}കിനി"),
            keywords: &[
                "നീന\u{d4d}തൽ വസ\u{d4d}ത\u{d4d}രം",
                "ബിക\u{d4d}കിനി",
                "വസ\u{d4d}ത\u{d4d}രം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("усны хувцас"),
            keywords: &["сэлэлт", "усны хувцас"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("बिकिनी"),
            keywords: &["कपड\u{947}", "पोहण\u{947}", "बिकिनी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bikini"),
            keywords: &["bikini", "pakaian", "renang"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("bikini"),
            keywords: &["bikini", "għawm", "ħwejjeġ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဘ\u{102e}က\u{102e}န\u{102e}"),
            keywords: &[
                "ဘ\u{102e}က\u{102e}န\u{102e}",
                "ဝတ\u{103a}စရာ",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း ရေက\u{1030}းဝတ\u{103a}စ\u{102f}\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bikini"),
            keywords: &["badedrakt", "badetøy", "bikini", "klær"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बिकिनी"),
            keywords: &["कपडा", "पौडिन\u{947}", "बिकिनी"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bikini"),
            keywords: &["bikini", "kleding", "zwemmen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bikini"),
            keywords: &["badedrakt", "badetøy", "bikini", "klede"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3f}କ\u{b3f}ନ\u{b3f}"),
            keywords: &[
                "ପୋଷ\u{b3e}କ ପର\u{b3f}ଚ\u{b4d}ଛଦ । ପହ\u{b01}ର\u{b3f}ବ\u{b3e}",
                "ବ\u{b3f}କ\u{b3f}ନ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬਿਕਨੀ"),
            keywords: &["ਬਾਥਿ\u{a70}ਗ ਸ\u{a42}ਟ", "ਬਿਕਨੀ", "ਲਿਬਾਸ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بکنی"),
            keywords: &["بکنی", "تیرنا", "کپڑے"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bikíni"),
            keywords: &["Bikíni", "Klọt", "Swim"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("bikini"),
            keywords: &[
                "bikini",
                "do pływania",
                "strój kąpielowy",
                "ubiór",
                "ubranie",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بکینی"),
            keywords: &["بکینی", "لامبل", "لباس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("biquíni"),
            keywords: &["biquíni", "roupa", "traje de banho"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["biquíni", "praia", "vestuário"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("bikini"),
            keywords: &["bikini"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("costum de baie"),
            keywords: &["bikini", "costum de baie", "feminin", "înot"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-534"),
            keywords: &["E10-534"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("бикини"),
            keywords: &["бикини", "купальник"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("utwenda two ku mazi"),
            keywords: &["koga", "umwambaro", "utwenda two ku mazi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بڪني"),
            keywords: &["بڪني", "ترڻ", "لباس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බ\u{dd2}ක\u{dd2}න\u{dd2}ය"),
            keywords: &[
                "ඇඳ\u{dd4}ම\u{dca}",
                "ප\u{dd2}හ\u{dd2}න\u{dd4}ම\u{dca}",
                "බ\u{dd2}ක\u{dd2}න\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("bikini"),
            keywords: &["bikini", "oblečenie", "plávanie", "plávať"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("bikini"),
            keywords: &["bikini", "oblačila", "plavati"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("nigis iyo keeshali"),
            keywords: &["dabaalasho", "dhar", "nigis iyo keeshali"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("bikini"),
            keywords: &["bikini", "not", "rroba banje", "veshje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("бикини"),
            keywords: &["бикини", "одећа", "пливaњe"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["бикини"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("bikini"),
            keywords: &["bikini", "odeća", "plivanje"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["bikini"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("bikini"),
            keywords: &["badkläder", "bikini", "kläder"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("bikini"),
            keywords: &["bikini", "kuogelea", "mavazi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ந\u{bc0}ச\u{bcd}சல\u{bbe}டை"),
            keywords: &[
                "ஆடை அணிகலன\u{bcd}",
                "குளிப\u{bcd}பதற\u{bcd}க\u{bbe}ன ஆடை",
                "ந\u{bc0}ச\u{bcd}சல\u{bbe}டை",
                "ந\u{bc0}ச\u{bcd}சலுடை",
                "பிகினி உடை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఈత దుస\u{c4d}తులు"),
            keywords: &["ఈత", "దుస\u{c4d}తులు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("либоси оббозӣ"),
            keywords: &["либоси оббозӣ", "оббозӣ кардан", "пӯшок"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("บ\u{e34}ก\u{e34}น\u{e35}"),
            keywords: &[
                "บ\u{e34}ก\u{e34}น\u{e35}",
                "ว\u{e48}ายน\u{e49}ำ",
                "เส\u{e37}\u{e49}อผ\u{e49}า",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("bikini"),
            keywords: &["bikini", "eşik", "ýüzmek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("vala matātahi kongaua"),
            keywords: &["vala matātahi kongaua"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("bikini"),
            keywords: &["bikini", "deniz giysisi", "giyim"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("باغىرداق"),
            keywords: &["ئۈزۈش", "باغىرداق", "كىيىم-كېچەك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("бікіні"),
            keywords: &["бікіні", "одяг", "плавати"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بکنی"),
            keywords: &["بکنی", "لباس"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("bikini"),
            keywords: &["bikini", "kiyim", "suzish"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("áo tắm hai mảnh"),
            keywords: &["bơi", "quần áo", "áo tắm hai mảnh"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bikini"),
            keywords: &["bikini", "féey", "yéere"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-bikini"),
            keywords: &["i-bikini", "impahla", "qubha"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Pata obinrin"),
            keywords: &["Pata obinrin", "aṣọ", "wẹdò"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("比堅尼"),
            keywords: &["服裝", "比堅尼", "游水"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("比坚尼"),
            keywords: &["服装", "比坚尼", "游水"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("比基尼"),
            keywords: &["三点式", "比基尼", "泳装"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("比基尼"),
            keywords: &["三點式", "比基尼"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("比堅尼"),
            keywords: &["三點式", "比堅尼"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibikini"),
            keywords: &["ibikini", "ingubo yokugqoka", "ukubhukuda"],
        },
    ],
};
#[doc = "👚"]
pub const WOMANS_CLOTHES: crate::Emoji = crate::Emoji {
    glyph: "👚",
    codepoint: "1F45A",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "woman’s clothes",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vroueklere"),
            keywords: &["klere", "vrou", "vroueklere"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሴት ልብስ"),
            keywords: &["ሴት", "አልባሳት", "የሴት ልብስ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ملابس حريمي"),
            keywords: &["ملابس", "ملابس حريمي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মহিল\u{9be}ৰ পোছ\u{9be}ক"),
            keywords: &["পোছ\u{9be}ক", "মহিল\u{9be}", "মহিল\u{9be}ৰ পোছ\u{9be}ক"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qadın paltarı"),
            keywords: &["geyim", "qadın", "qadın paltarı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("жаночае адзенне"),
            keywords: &["адзенне", "жаночае адзенне", "жанчына"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Дамско облекло"),
            keywords: &["Дамско облекло", "жена", "облекло"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মহিল\u{9be}দের পোশ\u{9be}ক"),
            keywords: &["ন\u{9be}রী", "পোশ\u{9be}ক", "মহিল\u{9be}দের পোশ\u{9be}ক"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("dilhad mercʼhed"),
            keywords: &["dilhad", "mercʼhed"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ženska odjeća"),
            keywords: &["odjeća", "žena", "ženska odjeća"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("roba de dona"),
            keywords: &["dona", "roba", "roba de dona"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ ᏧᎾᏬᏍᏗ"),
            keywords: &["ᎠᎨᏯ", "ᎠᎨᏯ ᏧᎾᏬᏍᏗ", "ᏗᎿᏬᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("dámská blůza"),
            keywords: &["dámská blůza", "oblečení", "žena"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dillad menywod"),
            keywords: &["dillad", "dillad menywod", "menyw"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bluse"),
            keywords: &["beklædning", "bluse"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Bluse"),
            keywords: &["Bluse", "Damenmode", "Kleidung", "Oberbekleidung"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γυναικεία ρούχα"),
            keywords: &["γυναίκα", "γυναικεία ρούχα", "ρούχο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("woman’s clothes"),
            keywords: &["clothing", "woman", "woman’s clothes"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("blouse"),
            keywords: &["blouse", "clothing", "top", "woman", "woman’s clothes"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ropa de mujer"),
            keywords: &["blusa", "camisa", "femenina", "ropa", "ropa de mujer"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["blusa", "mujer", "ropa", "ropa de mujer", "vestimenta"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["mujer", "ropa", "ropa de mujer", "vestimenta"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("naisteriided"),
            keywords: &["naine", "naisteriided", "riided"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("emakumeentzako arropa"),
            keywords: &["arropa", "emakume", "emakumeentzako arropa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("لباس زنانه"),
            keywords: &["زنانه", "لباس زنانه", "پوشاک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("naistenvaatteet"),
            keywords: &["nainen", "naistenvaatteet", "vaatteet"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mga damit na pambabae"),
            keywords: &["damit", "kasuotan", "mga damit na pambabae", "pambabae"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("konufólkaklæðir"),
            keywords: &[
                "klæði",
                "kona",
                "konufólk",
                "konufólkaklæðir",
                "kvinna",
                "plagg",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("vêtements de femme"),
            keywords: &["femme", "vêtements", "vêtements de femme"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["femme", "vêtements", "vêtements de femme"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("éadaí mná"),
            keywords: &["éadaí", "éadaí mná"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodach boireannaich"),
            keywords: &["aodach", "aodach boireannaich", "boireannach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("roupa de muller"),
            keywords: &["muller", "roupa", "roupa de muller"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}ત\u{acd}રીના\u{a82} કપડા\u{a82}"),
            keywords: &["કપડા\u{a82}", "સ\u{acd}ત\u{acd}રીના\u{a82} કપડા\u{a82}"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("suturar mace"),
            keywords: &["mace", "sutura", "suturar mace"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חולצת אישה"),
            keywords: &["אישה", "בגד", "חולצה", "חולצת אישה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("महिला क\u{947} कपड\u{93c}\u{947}"),
            keywords: &[
                "कपड\u{93c}\u{947}",
                "पोषाक",
                "महिला क\u{947} कपड\u{93c}\u{947}",
                "महिलाओ\u{902} क\u{947} परिधान",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("ženska odjeća"),
            keywords: &["odjeća", "žene", "ženska odjeća"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("női ruha"),
            keywords: &["női ruha", "nők", "ruha", "ruházat"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կնոջ հագուստ"),
            keywords: &["կին", "կնոջ հագուստ", "հագուստ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pakaian wanita"),
            keywords: &["pakaian", "wanita"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akwà ụmụnwanyị"),
            keywords: &["akwà ụmụnwanyị", "na-eme akwà", "nwanyị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kvenföt"),
            keywords: &["föt", "klæðnaður", "kona", "kvenföt"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("maglietta da donna"),
            keywords: &["abbigliamento", "maglietta da donna", "vestiti"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("婦人服"),
            keywords: &["シャツ", "ブラウス", "婦人服", "服"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sandhangan wong wadon"),
            keywords: &["sandhangan", "sandhangan wong wadon", "wong wadon"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქალის ტანსაცმელი"),
            keywords: &["ტანსაცმელი", "ქალი", "ქალის ტანსაცმელი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("әйелдер киімі"),
            keywords: &["киім", "әйел", "әйелдер киімі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("bluse"),
            keywords: &["beklædning", "bluse"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("អាវមន\u{17bb}ស\u{17d2}សស\u{17d2}រ\u{17b8}"),
            keywords: &[
                "មន\u{17bb}ស\u{17d2}សស\u{17d2}រ\u{17b8}",
                "អាវ",
                "អាវមន\u{17bb}ស\u{17d2}សស\u{17d2}រ\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಹ\u{cbf}ಳ\u{cc6}ಯರ ಉಡುಪು"),
            keywords: &[
                "ಬಟ\u{ccd}ಟ\u{cc6}ಗಳು",
                "ಮಹ\u{cbf}ಳ\u{cc6}ಯ ಉಡುಪುಗಳು",
                "ಮಹ\u{cbf}ಳ\u{cc6}ಯರ ಉಡುಪು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("여성복"),
            keywords: &["블라우스", "여성복"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बायला\u{902}च\u{947} कपड\u{947}"),
            keywords: &["कपड\u{947}", "बायल", "बायला\u{902}च\u{947} कपड\u{947}"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("аялдар кийими"),
            keywords: &["аял", "аялдар кийими", "кийим"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Fraekleedung"),
            keywords: &["Fra", "Fraekleedung", "Kleedung"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເສ\u{eb7}\u{ec9}ອຜ\u{ec9}າແມ\u{ec8}ຍ\u{eb4}ງ"),
            keywords: &[
                "ຊ\u{eb8}ດແມ\u{ec8}ຍ\u{eb4}ງ",
                "ເສ\u{eb7}\u{ec9}ອຜ\u{ec9}າ",
                "ເສ\u{eb7}\u{ec9}ອຜ\u{ec9}າແມ\u{ec8}ຍ\u{eb4}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("moteriški drabužiai"),
            keywords: &["drabužiai", "moteris", "moteriški drabužiai"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sieviešu drēbes"),
            keywords: &["apģērbs", "sieviešu", "sieviešu drēbes"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kākahu wahine"),
            keywords: &["kākahu", "wahine"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("женска облека"),
            keywords: &["жена", "женска облека", "облека"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d4d}ത\u{d4d}രീകള\u{d41}ടെ വസ\u{d4d}ത\u{d4d}രം"),
            keywords: &[
                "വസ\u{d4d}ത\u{d4d}രം",
                "സ\u{d4d}ത\u{d4d}രീകള\u{d41}ടെ വസ\u{d4d}ത\u{d4d}രം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эмэгтэй хувцас"),
            keywords: &["хувцас", "эмэгтэй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("महिला\u{902}च\u{947} कपड\u{947}"),
            keywords: &[
                "कपड\u{947}",
                "महिला\u{902}च\u{947} कपड\u{947}",
                "स\u{94d}त\u{94d}री",
                "स\u{94d}त\u{94d}रीच\u{947} कपड\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pakaian wanita"),
            keywords: &["pakaian", "wanita"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ħwejjeġ ta’ mara"),
            keywords: &["mara", "ħwejjeġ", "ħwejjeġ ta’ mara"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမျ\u{102d}\u{102f}းသမ\u{102e}း အဝတ\u{103a}အစားများ"),
            keywords: &[
                "ဝတ\u{103a}စရာ",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း အဝတ\u{103a}အစား",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း အဝတ\u{103a}အစားများ",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}းဝတ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("dameklær"),
            keywords: &["dameklær", "klær"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("महिलाको कपडा"),
            keywords: &["कपडा", "महिला", "महिलाको कपडा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("dameskleding"),
            keywords: &["dames", "dameskleding", "kleding"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("dameklede"),
            keywords: &["dameklede", "klede"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମହ\u{b3f}ଳ\u{b3e}ଙ\u{b4d}କ ପୋଷ\u{b3e}କପତ\u{b4d}ର"),
            keywords: &[
                "ପୋଷ\u{b3e}କ ପର\u{b3f}ଚ\u{b4d}ଛଦ । ମହ\u{b3f}ଳ\u{b3e}",
                "ମହ\u{b3f}ଳ\u{b3e}ଙ\u{b4d}କ ପୋଷ\u{b3e}କପତ\u{b4d}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਔਰਤਾ\u{a02} ਦ\u{a47} ਕ\u{a71}ਪੜ\u{a47}"),
            keywords: &[
                "ਔਰਤਾ\u{a02} ਦ\u{a47} ਕ\u{a71}ਪੜ\u{a47}",
                "ਕ\u{a71}ਪੜ\u{a47}",
                "ਲਿਬਾਸ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("زنانیاں دے کپڑے"),
            keywords: &["زنانی", "زنانیاں دے کپڑے", "کپڑے"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wúmán Klọt"),
            keywords: &["Klọt", "Wúman", "Wúmán Klọt"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("ubranie damskie"),
            keywords: &["damska", "ubiór", "ubranie", "ubranie damskie"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښځینه لباس"),
            keywords: &["لباس", "ښځه", "ښځینه لباس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("roupas femininas"),
            keywords: &["roupas", "roupas femininas"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("roupas de senhora"),
            keywords: &[
                "roupa de senhora",
                "roupas de senhora",
                "senhora",
                "vestuário",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("warmip pʼachan´"),
            keywords: &["warmip pʼachan´"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("haine de damă"),
            keywords: &["femeie", "feminin", "haine", "haine de damă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-535"),
            keywords: &["E10-535"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("блузка"),
            keywords: &["блузка", "женщина", "одежда", "платье"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("imyenda y’abagore"),
            keywords: &["imyenda y’abagore", "umugore", "umwambaro"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عورت جا ڪپڙا"),
            keywords: &["عورت", "عورت جا ڪپڙا", "لباس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dcf}න\u{dca}ත\u{dcf} ඇඳ\u{dd4}ම\u{dca}"),
            keywords: &["ඇඳ\u{dd4}ම\u{dca}", "ක\u{dcf}න\u{dca}ත\u{dcf}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("dámske oblečenie"),
            keywords: &["dámske oblečenie", "oblečenie", "žena"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ženska oblačila"),
            keywords: &["oblačila", "ženska"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dharka dumarka"),
            keywords: &["dhar", "dharka dumarka", "dumar"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("rroba femrash"),
            keywords: &["femër", "rroba femrash", "veshje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("женска одећа"),
            keywords: &["жена", "женска одећа", "одећа"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("женска одјећа"),
            keywords: &["женска одјећа"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ženska odeća"),
            keywords: &["odeća", "žena", "ženska odeća"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("ženska odjeća"),
            keywords: &["ženska odjeća"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("blus"),
            keywords: &["blus", "damkläder", "kläder"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nguo za wanawake"),
            keywords: &["mavazi", "mwanamke", "nguo za wanawake"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பெண\u{bcd}களின\u{bcd} ஆடைகள\u{bcd}"),
            keywords: &[
                "ஆடை அணிகலன\u{bcd}",
                "ஆடைகள\u{bcd}",
                "உடைகள\u{bcd}",
                "பெண\u{bcd}களின\u{bcd} ஆடைகள\u{bcd}",
                "பெண\u{bcd}கள\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఆడవ\u{c3e}ళ\u{c4d}ల దుస\u{c4d}తులు"),
            keywords: &[
                "ఆడవ\u{c3e}ళ\u{c4d}ల దుస\u{c4d}తులు",
                "ఆడవ\u{c3e}ళ\u{c4d}లు",
                "దుస\u{c4d}తులు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("либосҳои занона"),
            keywords: &["зан", "либосҳои занона", "пӯшок"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เส\u{e37}\u{e49}อผ\u{e39}\u{e49}หญ\u{e34}ง"),
            keywords: &[
                "เส\u{e37}\u{e49}อผ\u{e39}\u{e49}หญ\u{e34}ง",
                "เส\u{e37}\u{e49}อผ\u{e49}า",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("aýal eşikleri"),
            keywords: &["aýal eşikleri", "eşik", "zenan"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("vala fefine"),
            keywords: &["vala fefine"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kadın giysisi"),
            keywords: &["giyim", "giysiler", "kadın giysisi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئايالچە كىيىم"),
            keywords: &["ئايال", "ئايالچە كىيىم", "كىيىم-كېچەك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("жіночий одяг"),
            keywords: &["жінка", "жіночий одяг", "одяг"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("عورتوں کے کپڑے"),
            keywords: &["عورت", "عورتوں کے کپڑے", "لباس"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ayollar kiyimi"),
            keywords: &["ayol", "ayollar kiyimi", "kiyim"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("quần áo nữ"),
            keywords: &["nữ", "quần áo", "quần áo nữ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("yéere jigéen"),
            keywords: &["jigéen", "yéere"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iimpahla zamabhinqa"),
            keywords: &["ibhinqa", "iimpahla zamabhinqa", "impahla"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Awọn Aṣọ Obinrin"),
            keywords: &["Awọn Aṣọ Obinrin", "aṣọ", "obìnrin"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("女裝"),
            keywords: &["女", "女裝", "服裝"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("女装"),
            keywords: &["女", "女装", "服装"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("女装"),
            keywords: &["女", "女装", "衣服"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("女裝"),
            keywords: &["女裝", "衣服"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("impahla yomuntu wesifazane"),
            keywords: &[
                "impahla yomuntu wesifazane",
                "ingubo yokugqoka",
                "umuntu wesifazane",
            ],
        },
    ],
};
#[doc = "👛"]
pub const PURSE: crate::Emoji = crate::Emoji {
    glyph: "👛",
    codepoint: "1F45B",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "purse",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("beursie"),
            keywords: &["beursie", "geld", "klere"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሴት የእጅ ቦርሳ"),
            keywords: &["ሳንቲም", "አልባሳት", "የሴት የእጅ ቦርሳ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كيس نقود"),
            keywords: &["كيس نقود", "ملابس", "نقود"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9be}ৰ\u{9cd}ছ"),
            keywords: &[
                "প\u{9be}ৰ\u{9cd}ছ",
                "পোছ\u{9be}ক",
                "ম\u{9c1}দ\u{9cd}ৰ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("pul kisəsi"),
            keywords: &["geyim", "pul kisəsi", "qəpik"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кашалёк"),
            keywords: &["аксесуар", "капейка", "кашалёк", "манета"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("портмоне"),
            keywords: &["аксесоар", "монети", "портмоне"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9be}র\u{9cd}স"),
            keywords: &[
                "প\u{9be}র\u{9cd}স",
                "পোশ\u{9be}ক",
                "ম\u{9c1}দ\u{9cd}র\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("doug-moneiz"),
            keywords: &["doug-moneiz", "moneiz"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("tašna"),
            keywords: &["asesoar", "odjevni predmet", "tašna"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("moneder"),
            keywords: &["accessori", "moneda", "moneder", "roba"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏔᏁᏌᏟᏗ"),
            keywords: &["ᎠᏔᏁᏌᏟᏗ", "ᎠᏕᎳ", "ᏗᎿᏬᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("peněženka"),
            keywords: &["mince", "oblečení", "peněženka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("pwrs"),
            keywords: &["darn arian", "dillad", "pwrs"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("pung"),
            keywords: &["pengepung", "pung"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Geldbörse"),
            keywords: &["Accessoire", "Brieftasche", "Geldbörse", "Portemonnaie"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πορτοφόλι"),
            keywords: &["ένδυμα", "κέρμα", "πορτοφόλι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("purse"),
            keywords: &["clothing", "coin", "purse"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["accessories", "coin", "purse"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("monedero"),
            keywords: &["accesorios", "cartera", "complementos", "monedero", "mujer"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "cartera",
                "dinero",
                "monedas",
                "monedero",
                "ropa",
                "vestimenta",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("ridikül"),
            keywords: &["kott", "münt", "rahakott", "ridikül"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("diru-zorroa"),
            keywords: &["arropa", "diru-zorroa", "txanpon"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کیف دستی"),
            keywords: &["سکه", "پوشاک", "کیف", "کیف دستی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("rahakukkaro"),
            keywords: &["asuste", "kolikko", "rahakukkaro"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pitaka"),
            keywords: &["coin purse", "pitaka", "purse"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("pungur"),
            keywords: &["klæði", "myntir", "pengar", "pungur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("porte-monnaie"),
            keywords: &["monnaie", "porte-monnaie", "vêtements"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["monnaie", "porte-monnaie", "vêtements"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("sparán"),
            keywords: &["airgead", "sparán", "éadaí"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sporan"),
            keywords: &["aodach", "bonn", "sporan"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("moedeiro"),
            keywords: &["moedas", "moedeiro", "portamoedas"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પર\u{acd}સ"),
            keywords: &[
                "કપડા\u{a82}",
                "પર\u{acd}સ",
                "પાકીટ",
                "પ\u{ac8}સા રાખવાન\u{ac1}\u{a82} પાકીટ",
                "સિક\u{acd}કો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ƙaramar jakar hannu"),
            keywords: &["sutura", "tsaba", "ƙaramar jakar hannu"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ארנק"),
            keywords: &["ארנק", "כסף", "מטבעות"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पर\u{94d}स"),
            keywords: &["कॉइन पर\u{94d}स", "पर\u{94d}स", "पोषाक", "सिक\u{94d}का"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("novčanik"),
            keywords: &["novčanik", "odjeća", "sitan novac"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("pénztárca"),
            keywords: &["kiegészítő", "pénz", "pénztárca"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("դրամապանակ"),
            keywords: &["դրամապանակ", "հագուստ", "մետաղադրամ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("dompet"),
            keywords: &["dompet", "koin", "pakaian"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("obere àkpà ntinye ego"),
            keywords: &["kọịnụ", "na-eme akwà", "obere àkpà ntinye ego"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("budda"),
            keywords: &["budda", "klæðnaður", "peningabudda", "smápeningar"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("borsellino"),
            keywords: &["abbigliamento", "borsellino", "moneta", "porta monete"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("がま口"),
            keywords: &["がま口", "小銭入れ", "財布"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tas"),
            keywords: &["koin", "sandhangan", "tas"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("საფულე"),
            keywords: &["მონეტა", "საფულე", "ტანსაცმელი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("әйелдер әмияны"),
            keywords: &["киім", "тиын", "әйелдер әмияны"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("pung"),
            keywords: &["pengepung", "pung"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ការប\u{17bc}បដៃ"),
            keywords: &[
                "កាប\u{17bc}បដៃ",
                "កាប\u{17bc}បល\u{17bb}យ",
                "ការប\u{17bc}បដៃ",
                "ក\u{17bc}នកាប\u{17bc}ប",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪರ\u{ccd}ಸ\u{ccd}"),
            keywords: &["ಉಡುಪು", "ನಾಣ\u{ccd}ಯ", "ಪರ\u{ccd}ಸ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("지갑"),
            keywords: &["동전", "지갑"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पर\u{94d}स"),
            keywords: &["कपड\u{947}", "नाण\u{947}", "पर\u{94d}स"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("капчык"),
            keywords: &["капчык", "кийим", "тыйын"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Portmonni"),
            keywords: &["Geld", "Kleedung", "Portmonni", "Suen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກະເປ\u{ebb}າເງ\u{eb4}ນ"),
            keywords: &[
                "ກະເປ\u{ebb}າເງ\u{eb4}ນ",
                "ຫ\u{eb9}ຽນ",
                "ເຄ\u{eb7}\u{ec8}\u{ec8}ອງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("piniginė"),
            keywords: &["drabužiai", "monetos", "piniginė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("naudasmaks"),
            keywords: &["maks", "monētas", "nauda", "naudasmaks"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pāhi"),
            keywords: &["kākahu", "moni uka", "pāhi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("паричник"),
            keywords: &["жена", "монети", "пари", "паричник", "чанта"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പേഴ\u{d4d}\u{200c}സ\u{d4d}"),
            keywords: &[
                "കോയിൻ",
                "ന\u{d3e}ണയം",
                "പേഴ\u{d4d}\u{200c}സ\u{d4d}",
                "വസ\u{d4d}ത\u{d4d}രം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("түрийвч"),
            keywords: &["зоос", "түрийвч"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पर\u{94d}स"),
            keywords: &["कपड\u{947}", "नाण\u{947}", "पर\u{94d}स"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("dompet"),
            keywords: &["dompet", "duit syiling", "pakaian"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("portmoni"),
            keywords: &["munita", "portmoni", "ħwejjaġ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပ\u{102d}\u{102f}က\u{103a}ဆ\u{1036}အ\u{102d}တ\u{103a}"),
            keywords: &[
                "ပ\u{102d}\u{102f}က\u{103a}ဆ\u{1036}အ\u{102d}တ\u{103a}",
                "အကြ\u{103d}ေအ\u{102d}တ\u{103a}",
                "အသ\u{102f}\u{1036}းအဆောင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("portemoné"),
            keywords: &["klær", "portemoné", "pung"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पर\u{94d}स"),
            keywords: &["कपडा", "पर\u{94d}स", "सिक\u{94d}का"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("portemonnee"),
            keywords: &["kleding", "munt", "portemonnee"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("portemoné"),
            keywords: &["klede", "portemoné", "pung"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପର\u{b4d}ସ\u{b4d}\u{200c}"),
            keywords: &[
                "କଏନ\u{b4d}\u{200c} ପର\u{b4d}ସ\u{b4d}",
                "ପର\u{b4d}ସ\u{b4d}\u{200c}",
                "ପୋଷ\u{b3e}କ ପର\u{b3f}ଚ\u{b4d}ଛଦ",
                "ମ\u{b41}ଦ\u{b4d}ର\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬਟ\u{a42}ਆ"),
            keywords: &[
                "ਪਰਸ",
                "ਪਰਸ\u{a3c}",
                "ਬਟ\u{a42}ਆ",
                "ਲਿਬਾਸ",
                "ਸਿ\u{a71}ਕਾ",
                "ਸਿ\u{a71}ਕਿਆ\u{a02} ਲਈ ਬਟ\u{a42}ਆ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پرس"),
            keywords: &["سکہ", "پرس", "کپڑے"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pọs"),
            keywords: &["Klọt", "Kọin", "Pọs"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("portmonetka"),
            keywords: &["na monety", "portmonetka", "torebka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پرس"),
            keywords: &["لباس", "پرس", "کاین"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bolsinha"),
            keywords: &["acessório", "bolsinha", "moedas", "niqueleira"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("carteira"),
            keywords: &["acessório", "carteira", "dinheiro", "porta-moedas"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pulcera"),
            keywords: &["pulcera"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("poșetă"),
            keywords: &["accesoriu", "feminin", "poșetă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-536"),
            keywords: &["E10-536"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("кошелек"),
            keywords: &["аксессуар", "деньги", "кошелек", "сумка", "сумочка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikofi"),
            keywords: &["igiceri", "ikofi", "umwambaro"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٻٽون"),
            keywords: &["سڪو", "لباس", "ٻٽون"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පර\u{dca}ස\u{dca} එක"),
            keywords: &[
                "ඇඳ\u{dd4}ම\u{dca}",
                "ක\u{dcf}ස\u{dd2}",
                "පර\u{dca}ස\u{dca} එක",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("peňaženka"),
            keywords: &["koruna", "oblečenie", "peňaženka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("drobižnica"),
            keywords: &["drobižnica", "kovanec", "oblačila"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("boorso"),
            keywords: &["boorso", "dhar", "qadaadiic"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kuletë"),
            keywords: &["kuletë", "monedhë", "veshje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("ташница"),
            keywords: &["одећа", "ситнина", "ташница"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["ташница"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("tašnica"),
            keywords: &["odeća", "sitnina", "tašnica"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["tašnica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("portmonnä"),
            keywords: &["accessoar", "portmonnä"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kibeti"),
            keywords: &["kibeti", "mavazi", "sarafu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பர\u{bcd}ஸ\u{bcd}"),
            keywords: &[
                "ஆடை அணிகலன\u{bcd}",
                "பணப\u{bcd}பை",
                "பர\u{bcd}ஸ\u{bcd}",
                "மணி பர\u{bcd}ஸ\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఆడవ\u{c3e}ళ\u{c4d}ల పర\u{c4d}సు"),
            keywords: &[
                "ఆడవ\u{c3e}ళ\u{c4d}ల పర\u{c4d}సు",
                "ఆడవ\u{c3e}ళ\u{c4d}లు",
                "పర\u{c4d}సు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҳамён"),
            keywords: &["либос", "танга", "ҳамён"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("กระเป\u{e4b}าใส\u{e48}เง\u{e34}น"),
            keywords: &[
                "กระเป\u{e4b}าสตางค\u{e4c}",
                "กระเป\u{e4b}าใส\u{e48}เง\u{e34}น",
                "กระเป\u{e4b}าใส\u{e48}เหร\u{e35}ยญ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gapjyk"),
            keywords: &["eşik", "gapjyk", "teňňe"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kato paʻanga"),
            keywords: &["kato paʻanga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("cüzdan"),
            keywords: &["bozuk para", "bozuk para çantası", "cüzdan", "giyim"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ھەميان"),
            keywords: &["كىيىم-كېچەك", "پۇل", "ھەميان"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("гаманець"),
            keywords: &["аксесуар", "гаманець", "гроші", "монета", "одяг"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پرس"),
            keywords: &["لباس", "پرس", "پیسہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("hamyon"),
            keywords: &["hamyon", "kiyim", "tanga"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ví"),
            keywords: &["quần áo", "ví", "đồng tiền"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("nafa"),
            keywords: &["nafa", "piyees", "yéere"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isipaji"),
            keywords: &["impahla", "ingqekembe", "isipaji"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Pọọsi"),
            keywords: &["Pọọsi", "aṣọ", "kóbọ\u{300}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("散子包"),
            keywords: &["散子", "散子包", "服裝"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("散子包"),
            keywords: &["散子", "散子包", "服装"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("钱包"),
            keywords: &["钱包"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("錢包"),
            keywords: &["荷包", "錢包"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("銀包"),
            keywords: &["荷包", "銀包"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isikhwama semali"),
            keywords: &["impahla yokugqoka", "isikhwama semali", "uhleza"],
        },
    ],
};
#[doc = "👜"]
pub const HANDBAG: crate::Emoji = crate::Emoji {
    glyph: "👜",
    codepoint: "1F45C",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "handbag",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("handsak"),
            keywords: &["handsak", "klere", "sak", "tas"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የእጅ ቦርሳ"),
            keywords: &["ቦርሳ", "አልባሳት", "የእጅ ቦርሳ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شنطة يد"),
            keywords: &["حقيبة يد", "شنطة", "شنطة يد", "ملابس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হেণ\u{9cd}ডবেগ"),
            keywords: &["প\u{9be}ৰ\u{9cd}ছ", "পোছ\u{9be}ক", "বেগ", "হেণ\u{9cd}ডবেগ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("əl çantası"),
            keywords: &["geyim", "çanta", "əl çantası"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("дамская сумачка"),
            keywords: &["аксесуар", "дамская сумачка", "сумка", "торба"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("чанта"),
            keywords: &["облекло", "чанта"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হ\u{9be}তের ব\u{9cd}য\u{9be}গ"),
            keywords: &[
                "প\u{9be}র\u{9cd}স",
                "পোশ\u{9be}ক",
                "ব\u{9cd}য\u{9be}গ",
                "হ\u{9be}তের ব\u{9cd}য\u{9be}গ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("sacʼh-dorn"),
            keywords: &["dilhad", "sacʼh", "sacʼh-dorn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ručna torba"),
            keywords: &["asesoar", "odjevni predmet", "ručna torba", "torba"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bossa de mà"),
            keywords: &["accessori", "bossa", "bossa de mà", "roba"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏕᎦᎵᏟᏗ ᎧᏂᏓᏍᏗ"),
            keywords: &["ᎠᏔᏁᏌᏟᏗ", "ᏕᎦᎵᏟᏗ", "ᏕᎦᎵᏟᏗ ᎧᏂᏓᏍᏗ", "ᏗᎿᏬᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kabelka"),
            keywords: &["kabelka", "oblečení", "zavazadlo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bag llaw"),
            keywords: &["bag", "bag llaw", "dillad"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("håndtaske"),
            keywords: &["håndtaske", "taske"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Handtasche"),
            keywords: &["Accessoire", "Handtasche", "Tasche"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τσάντα χειρός"),
            keywords: &["ένδυμα", "τσάντα", "τσάντα χειρός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("handbag"),
            keywords: &["bag", "clothing", "handbag", "purse"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["accessories", "bag", "handbag", "tote"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bolso"),
            keywords: &["accesorios", "bolso", "complementos", "mujer"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "bolsa",
                "bolso",
                "cartera",
                "cartera de mano",
                "mujer",
                "ropa",
                "vestimenta",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("bolso"),
            keywords: &["bolso"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("bolso"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("käekott"),
            keywords: &["kott", "käekott", "riided"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("eskuko poltsa"),
            keywords: &["arropa", "eskuko poltsa", "poltsa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کیف دوشی"),
            keywords: &["پوشاک", "کیف", "کیف دوشی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("käsilaukku"),
            keywords: &["asuste", "käsilaukku", "laukku"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("handbag"),
            keywords: &["bag", "handbag", "pambabae"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("handtaska"),
            keywords: &["handtaska", "hondtaska", "klæði", "taska"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("sac à main"),
            keywords: &["sac", "sac à main", "vêtements"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["sac", "sac à main", "vêtements"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("mála láimhe"),
            keywords: &["mála", "mála láimhe"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("baga-làimhe"),
            keywords: &["aodach", "baga", "baga-làimhe", "sporan"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("bolso"),
            keywords: &["bolso"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("હ\u{ac7}ન\u{acd}ડબ\u{ac7}ગ"),
            keywords: &["કપડા\u{a82}", "બ\u{ac7}ગ", "હ\u{ac7}ન\u{acd}ડબ\u{ac7}ગ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("jakar mata"),
            keywords: &["jaka", "jakar mata", "sutura", "ƙaramar jakar hannu"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("תיק יד"),
            keywords: &["ארנק", "תיק יד"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ह\u{948}\u{902}डब\u{948}ग"),
            keywords: &["पोषाक", "ब\u{948}ग", "ह\u{948}\u{902}डब\u{948}ग"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("ručna torbica"),
            keywords: &["odjeća", "ručna torbica", "torba"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("női táska"),
            keywords: &["kiegészítő", "női táska", "táska"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ձեռքի պայուսակ"),
            keywords: &["հագուստ", "ձեռքի պայուսակ", "պայուսակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tas jinjing"),
            keywords: &["pakaian", "tas", "tas jinjing"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("àgbankò n’aka"),
            keywords: &[
                "na-eme akwà",
                "obere àkpà ntinye ego",
                "àgbankò n’aka",
                "àkpà",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("handtaska"),
            keywords: &["handtaska", "klæðnaður", "taska"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("borsa"),
            keywords: &["abbigliamento", "borsa", "borsetta"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ハンドバッグ"),
            keywords: &["かばん", "ハンドバッグ", "バッグ"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tas tangan"),
            keywords: &["sandhangan", "tas", "tas tangan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ხელჩანთა"),
            keywords: &["ტანსაცმელი", "ჩანთა", "ხელჩანთა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қолдорба"),
            keywords: &["киім", "сөмке", "қолдорба"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("håndtaske"),
            keywords: &["håndtaske", "taske"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ការប\u{17bc}\u{17bc}ស\u{17d2}ពាយច\u{17c6}ហៀង"),
            keywords: &[
                "កាប\u{17bc}បយ\u{17bd}រដៃ",
                "កាប\u{17bc}បស\u{17d2}ពាយច\u{17c6}ហៀង",
                "ការប\u{17bc}\u{17bc}ស\u{17d2}ពាយច\u{17c6}ហៀង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹ\u{ccd}ಯಾಂಡ\u{ccd}\u{200c}ಬ\u{ccd}ಯಾಗ\u{ccd}"),
            keywords: &[
                "ಬಟ\u{ccd}ಟ\u{cc6}",
                "ಬ\u{ccd}ಯಾಗ\u{ccd}",
                "ಹ\u{ccd}ಯಾಂಡ\u{ccd}\u{200c}ಬ\u{ccd}ಯಾಗ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("핸드백"),
            keywords: &["가방", "백", "핸드백"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ह\u{901}डब\u{945}ग"),
            keywords: &[
                "कपड\u{947}",
                "पर\u{94d}स",
                "ब\u{945}ग",
                "ह\u{901}डब\u{945}ग",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("колбаштык"),
            keywords: &["баштык", "кийим", "колбаштык"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Posch"),
            keywords: &["Kleedung", "Portmonni", "Posch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກະເປ\u{ebb}າແບບຖ\u{eb6}"),
            keywords: &[
                "ກະເປ\u{ebb}າ",
                "ກະເປ\u{ebb}າເງ\u{eb4}ນ",
                "ກະເປ\u{ebb}າແບບຖ\u{eb6}",
                "ເຄ\u{eb7}\u{ec8}ອງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("rankinė"),
            keywords: &["drabužiai", "krepšys", "rankinė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("rokassoma"),
            keywords: &["rokassoma", "soma"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pāhi ā-ringa"),
            keywords: &["kākahu", "pāhi", "pāhi ā-ringa", "pēke"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("чанта"),
            keywords: &["жена", "чанта"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഹ\u{d3e}ൻഡ\u{d4d} ബ\u{d3e}ഗ\u{d4d}"),
            keywords: &[
                "ബ\u{d3e}ഗ\u{d4d}",
                "വസ\u{d4d}ത\u{d4d}രം",
                "ഹ\u{d3e}ൻഡ\u{d4d} ബ\u{d3e}ഗ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гар цүнх"),
            keywords: &["гар", "цүнх", "эдлэл"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("हातात धरण\u{94d}\u{200d}याची पिशवी"),
            keywords: &[
                "कपड\u{947}",
                "पर\u{94d}स",
                "ब\u{945}ग",
                "हातात धरण\u{94d}\u{200d}याची पिशवी",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("beg tangan"),
            keywords: &["beg", "beg tangan", "pakaian"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("handbag"),
            keywords: &["borża", "handbag", "portmoni", "ħwejjeġ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လက\u{103a}ဆ\u{103d}\u{1032}အ\u{102d}တ\u{103a}"),
            keywords: &[
                "လက\u{103a}က\u{102d}\u{102f}င\u{103a}အ\u{102d}တ\u{103a}",
                "လက\u{103a}ဆ\u{103d}\u{1032}အ\u{102d}တ\u{103a}",
                "အသ\u{102f}\u{1036}းအဆောင\u{103a}",
                "အ\u{102d}တ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("håndveske"),
            keywords: &["håndveske", "klær", "veske"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("हात\u{947}ब\u{94d}याग"),
            keywords: &["कपडा", "ब\u{94d}याग", "हात\u{947}ब\u{94d}याग"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("handtas"),
            keywords: &["handtas", "kleding", "tas"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("handveske"),
            keywords: &["handveske", "klede", "veske"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ହ\u{b4d}ୟ\u{b3e}ଣ\u{b4d}ଡବ\u{b4d}ୟ\u{b3e}ଗ\u{b4d}\u{200c}"),
            keywords: &[
                "ପୋଷ\u{b3e}କ ପର\u{b3f}ଚ\u{b4d}ଛଦ",
                "ବ\u{b4d}ୟ\u{b3e}ଗ\u{b4d}",
                "ହ\u{b4d}ୟ\u{b3e}ଣ\u{b4d}ଡବ\u{b4d}ୟ\u{b3e}ଗ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਹ\u{a48}\u{a02}ਡਬ\u{a48}ਗ"),
            keywords: &[
                "ਬ\u{a48}ਗ",
                "ਲਿਬਾਸ",
                "ਹ\u{a48}\u{a02}ਡਬ\u{a48}ਗ",
                "ਹ\u{a71}ਥ ਬ\u{a48}ਗ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("دستی-بیگ"),
            keywords: &["تھیلا", "دستی-بیگ", "پرس", "کپڑے"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Hándbag"),
            keywords: &["Bag", "Hándbag", "Klọt", "Pọs"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("torebka"),
            keywords: &["bagaż", "damska torebka", "torebka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("دسکول"),
            keywords: &["بکس", "دسکول", "لباس", "پرس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bolsa de mão"),
            keywords: &["acessório", "bolsa", "bolsa de mão"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("mala"),
            keywords: &["acessório", "carteira", "mala", "saco"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("bolso"),
            keywords: &["bolso"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("geantă de mână"),
            keywords: &["accesoriu", "feminin", "geantă de mână", "poșetă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-537"),
            keywords: &["E10-537"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("сумка"),
            keywords: &["женская", "сумка", "сумочка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isakoshi"),
            keywords: &["agasakoshi", "igikapu", "isakoshi", "umwambaro"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("هٿ جو ٿيلو"),
            keywords: &["بيگ", "لباس", "هٿ جو ٿيلو", "پرس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අත\u{dca} බෑගය"),
            keywords: &["අත\u{dca} බෑගය", "ඇඳ\u{dd4}ම\u{dca}", "බෑගය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kabelka"),
            keywords: &["kabelka", "oblečenie", "taška"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ročna torbica"),
            keywords: &["oblačila", "ročna torbica", "torbica"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("shandada gacanta"),
            keywords: &["boorso", "dhar", "shandad", "shandada gacanta"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("çantë dore"),
            keywords: &["veshje", "çantë", "çantë dore"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("ташна"),
            keywords: &["одећа", "тoрбa", "ташна"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["ташна"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("tašna"),
            keywords: &["odeća", "tašna", "torba"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["tašna"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("handväska"),
            keywords: &["accessoar", "handväska", "väska"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mfuko"),
            keywords: &["mavazi", "mfuko"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஹேண\u{bcd}ட\u{bcd} பேக\u{bcd}"),
            keywords: &[
                "ஆடை அணிகலன\u{bcd}",
                "கைப\u{bcd}பை",
                "பேக\u{bcd}",
                "பை",
                "ஹேண\u{bcd}ட\u{bcd} பேக\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఆడవ\u{c3e}ళ\u{c4d}ల హ\u{c4d}య\u{c3e}ండ\u{c4d} బ\u{c4d}య\u{c3e}గ\u{c4d}"),
            keywords: &[
                "ఆడవ\u{c3e}ళ\u{c4d}ల హ\u{c4d}య\u{c3e}ండ\u{c4d} బ\u{c4d}య\u{c3e}గ\u{c4d}",
                "ఆడవ\u{c3e}ళ\u{c4d}లు",
                "బ\u{c4d}య\u{c3e}గ\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("сумка"),
            keywords: &["либос", "сумка", "ҳамён"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("กระเป\u{e4b}าถ\u{e37}อ"),
            keywords: &["กระเป\u{e4b}า", "กระเป\u{e4b}าถ\u{e37}อ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("el sumka"),
            keywords: &["el sumka", "eşik", "gapjyk", "goşhalta"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kato"),
            keywords: &["kato"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("el çantası"),
            keywords: &["el çantası", "giyim", "çanta"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قولسومكا"),
            keywords: &["خالتا", "قولسومكا", "كىيىم", "ھەميان"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("сумка"),
            keywords: &["одяг", "сумка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ہینڈ بیگ"),
            keywords: &["بیگ", "لباس", "ہینڈ بیگ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ayollar qo‘l sumkasi"),
            keywords: &["ayollar qo‘l sumkasi", "kiyim", "sumka"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("túi xách"),
            keywords: &["quần áo", "túi", "túi xách", "ví"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("saagu loxo"),
            keywords: &["bag", "nafa", "saagu loxo", "yéere"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ingxowa yamakhosikazi"),
            keywords: &["ibhegi", "impahla", "ingxowa yamakhosikazi", "isipaji"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ìpamọ\u{301}wọ\u{301}"),
            keywords: &[
                "aṣọ",
                "pọ\u{301}ọ\u{300}sì",
                "Ìpamọ\u{301}wọ\u{301}",
                "àpamọ\u{301}wọ\u{301}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("手袋"),
            keywords: &["手袋", "散子包", "服裝"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("手袋"),
            keywords: &["手袋", "散子包", "服装"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("手提包"),
            keywords: &["手提包", "挎包"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("手提包"),
            keywords: &["包包", "手提包"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("手袋"),
            keywords: &["包包", "手袋", "皮包"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isikhwama esincane"),
            keywords: &["impahla yokugqoka", "isikhwama", "isikhwama esincane"],
        },
    ],
};
#[doc = "👝"]
pub const CLUTCH_BAG: crate::Emoji = crate::Emoji {
    glyph: "👝",
    codepoint: "1F45D",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "clutch bag",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("palmtassie"),
            keywords: &["klere", "palmtassie", "sakkie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሴት ቦርሳ"),
            keywords: &["ቦርሳ", "አልባሳት", "የሴት ቦርሳ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("محفظة يد"),
            keywords: &["حقيبة يد", "محفظة يد", "ملابس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9cd}ল\u{9be}টচ\u{9cd} বেগ"),
            keywords: &[
                "ক\u{9cd}ল\u{9be}টচ\u{9cd} বেগ",
                "প\u{9be}উচ",
                "পোছ\u{9be}ক",
                "বেগ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("torba"),
            keywords: &["geyim", "torba", "çanta"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сумачка"),
            keywords: &["аксесуар", "сумачка", "сумка", "торба"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("чантичка"),
            keywords: &["облекло", "чанта", "чантичка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9cd}য\u{9be}গ"),
            keywords: &["প\u{9be}উচ", "পোশ\u{9be}ক", "ব\u{9cd}য\u{9be}গ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("godellig"),
            keywords: &["godellig", "sacʼh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("neseser"),
            keywords: &["neseser", "odjevni predmet", "torbica"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bossa"),
            keywords: &["accessori", "bossa", "roba"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏂᏴᏙᏗ ᏕᎦᎶᏗ"),
            keywords: &["ᎤᏍᏗ ᏕᎦᎵᏟᏗ", "ᎦᏂᏴᏙᏗ ᏕᎦᎶᏗ", "ᏕᎦᎵᏟᏗ", "ᏗᎿᏬᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kosmetická taška"),
            keywords: &["kosmetická taška", "oblečení", "zavazadlo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cwd"),
            keywords: &["bag", "cwd", "dillad"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("clutch"),
            keywords: &["clutch", "pung", "taske"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Clutch"),
            keywords: &["Accessoire", "Clutch", "Tasche"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τσαντάκι"),
            keywords: &["ένδυμα", "κασετίνα", "τσάντα", "τσαντάκι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("clutch bag"),
            keywords: &["bag", "clothing", "clutch bag", "pouch"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("pouch"),
            keywords: &["accessories", "bag", "clutch bag", "pouch"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bolso de mano"),
            keywords: &[
                "accesorios",
                "bolso",
                "bolso de mano",
                "cartera",
                "complementos",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "bolso",
                "bolso de mano",
                "cartera",
                "ropa",
                "sobre",
                "vestimenta",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("bolso de mano"),
            keywords: &["bolso de mano", "cartera", "ropa", "sobre", "vestimenta"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("bolso de mano"),
            keywords: &["bolso de mano", "cartera", "ropa", "sobre", "vestimenta"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kott"),
            keywords: &["kott", "riided"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("zorroa"),
            keywords: &["arropa", "poltsa", "zorroa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کیف بدون تسمه زنانه"),
            keywords: &[
                "پوشاک",
                "کیسه کوچک",
                "کیف",
                "کیف بدون تسمه زنانه",
                "کیف پول",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kirjekuorilaukku"),
            keywords: &["asuste", "iltalaukku", "kirjekuorilaukku", "laukku"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("clutch bag"),
            keywords: &["bag", "clutch bag"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("taska"),
            keywords: &["handtaska", "hondtaska", "klæði", "pungur", "taska"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("pochette"),
            keywords: &["pochette", "sac", "vêtements"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["pochette", "sac", "vêtements"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("mála"),
            keywords: &["máilín", "mála", "tiachóg"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("clutch bag"),
            keywords: &["aodach", "baga", "clutch bag", "pùidse"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("bolso de man"),
            keywords: &["bolso", "bolso de man", "carteira", "neceser"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પાઉચ"),
            keywords: &["કપડા\u{a82}", "પાઉચ", "બ\u{ac7}ગ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("jaka mara hannu"),
            keywords: &["jaka", "jaka mara hannu", "sutura", "zabira"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("תיק ערב"),
            keywords: &["תיק ערב", "תיק קלאץ׳"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पाउच"),
            keywords: &["पाउच", "पोषाक", "ब\u{948}ग"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("torbica"),
            keywords: &["odjeća", "torba", "torbica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("táska"),
            keywords: &["kiegészítő", "táska"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("պայուսակ"),
            keywords: &["հագուստ", "պայուսակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kantung"),
            keywords: &["kantung", "pakaian", "tas"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("àkpà njina n’aka"),
            keywords: &["na-eme akwà", "obere àkpà", "àkpà", "àkpà njina n’aka"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("smáveski"),
            keywords: &["budda", "klæðnaður", "smáveski"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pochette"),
            keywords: &["abbigliamento", "borsa", "pochette"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ポーチ"),
            keywords: &["バッグ", "ポーチ"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tas jinjing"),
            keywords: &["dompet", "sandhangan", "tas", "tas jinjing"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჩანთა"),
            keywords: &["ტანსაცმელი", "ჩანთა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сөмке"),
            keywords: &["киім", "сөмке"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("taske"),
            keywords: &["pung", "taske"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កាប\u{17bc}បប\u{17ca}\u{17b7}ច"),
            keywords: &["កាប\u{17bc}បប\u{17ca}\u{17b7}ច", "កាប\u{17bc}បរ\u{17bc}ត"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪ\u{ccc}ಚ\u{ccd}"),
            keywords: &["ಪ\u{ccc}ಚ\u{ccd}", "ಬಟ\u{ccd}ಟ\u{cc6}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("파우치"),
            keywords: &["가방", "파우치"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("क\u{94d}लच ब\u{945}ग"),
            keywords: &["कपड\u{947}", "क\u{94d}लच ब\u{945}ग", "पावच", "ब\u{945}ग"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("клатч"),
            keywords: &["баштык", "кийим", "клатч"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Clutch"),
            keywords: &["Clutch", "Kleedung", "Posch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກະເປ\u{ebb}າແບບຈ\u{eb1}ບເອ\u{ebb}າ"),
            keywords: &[
                "ກະເປ\u{ebb}າ",
                "ກະເປ\u{ebb}າແບບຈ\u{eb1}ບເອ\u{ebb}າ",
                "ເຄ\u{eb7}\u{ec8}ອງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("maišelis"),
            keywords: &["drabužiai", "krepšys", "maišelis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kosmētikas maciņš"),
            keywords: &["apģērbs", "kosmētikas maciņš", "maisiņš", "soma"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pāhi hopu"),
            keywords: &["kākahu", "pāhi hopu", "pēke", "pūkoro"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("торбичка"),
            keywords: &["жена", "торбичка", "чанта"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d4d}ലച\u{d4d}ച\u{d4d} ബ\u{d3e}ഗ\u{d4d}"),
            keywords: &[
                "ക\u{d4d}ലച\u{d4d}ച\u{d4d} ബ\u{d3e}ഗ\u{d4d}",
                "ബ\u{d3e}ഗ\u{d4d}",
                "വസ\u{d4d}ത\u{d4d}രം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цүнх"),
            keywords: &["цүнх", "эдлэл"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("छोटी पिशवी"),
            keywords: &["कपड\u{947}", "छोटी पिशवी", "पाउच", "ब\u{945}ग"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pau"),
            keywords: &["beg", "pakaian", "pau"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kartiera"),
            keywords: &["borża", "kartiera", "pouch", "ħwejjeġ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လက\u{103a}က\u{102d}\u{102f}င\u{103a}အ\u{102d}တ\u{103a}"),
            keywords: &[
                "လက\u{103a}က\u{102d}\u{102f}င\u{103a}အ\u{102d}တ\u{103a}",
                "သားရေအ\u{102d}တ\u{103a}",
                "အသ\u{102f}\u{1036}းအဆောင\u{103a}",
                "အ\u{102d}တ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("clutch-veske"),
            keywords: &["clutch-veske", "klær", "liten veske"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("थ\u{948}ली"),
            keywords: &["कपडा", "थ\u{948}ली", "ब\u{94d}याग"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("tasje"),
            keywords: &["enveloptas", "kleding", "tas", "tasje"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("clutch-veske"),
            keywords: &["clutch-veske", "klede", "lita veske"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b4d}ଲଚ\u{b4d}\u{200c} ବ\u{b4d}ୟ\u{b3e}ଗ\u{b4d}\u{200c}"),
            keywords: &[
                "କ\u{b4d}ଲଚ\u{b4d}\u{200c} ବ\u{b4d}ୟ\u{b3e}ଗ\u{b4d}\u{200c}",
                "ଛୋଟ ଥଳ\u{b3f}",
                "ପୋଷ\u{b3e}କ ପର\u{b3f}ଚ\u{b4d}ଛଦ",
                "ବ\u{b4d}ୟ\u{b3e}ଗ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪਾਉਚ ਬ\u{a48}ਗ"),
            keywords: &["ਥ\u{a48}ਲੀ", "ਪਾਉਚ ਬ\u{a48}ਗ", "ਬ\u{a48}ਗ", "ਲਿਬਾਸ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہتھ وچ پھڑن آلا بیگ"),
            keywords: &["تھیلا", "پاؤچ", "کپڑے", "ہتھ وچ پھڑن آلا بیگ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bag Wé Wúman De Hóld Taít Tait"),
            keywords: &[
                "Bag",
                "Bag Wé Wúman De Hóld Taít Tait",
                "Klọt",
                "Smọ\u{301}l Bag",
                "Wúmán Hándbag Wé Nọ\u{301} Gẹ\u{301}t Rop",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("saszetka"),
            keywords: &["damska", "saszetka", "torebka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کڅوړي بکسه"),
            keywords: &["بټوه", "بکس", "لباس", "کڅوړي بکسه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bolsa pequena"),
            keywords: &["acessório", "bolsa pequena"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["acessório", "bolsa", "bolsa pequena", "pochete", "saco"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("cartera"),
            keywords: &["cartera"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("gentuță"),
            keywords: &["accesoriu", "geantă", "gentuță"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-538"),
            keywords: &["E10-538"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("клатч"),
            keywords: &["аксессуар", "женское", "клатч", "сумочка", "театр"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("agasakoshi"),
            keywords: &["agasakoshi", "igikapu", "umwambaro", "uruhago"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عورتن جو ٻٽون"),
            keywords: &["بيگ", "عورتن جو ٻٽون", "لباس", "ٿيلي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පස\u{dd4}ම\u{dca}බ\u{dd2}ය"),
            keywords: &["ඇඳ\u{dd4}ම\u{dca}", "පස\u{dd4}ම\u{dca}බ\u{dd2}ය", "බෑගය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("malá kabelka"),
            keywords: &["malá kabelka", "oblečenie", "taška"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("večerna torbica"),
            keywords: &["oblačila", "torbica", "večerna torbica"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("shandad yar"),
            keywords: &["boorso", "dhar", "shandad", "shandad yar"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("çantë"),
            keywords: &["veshje", "çantë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("несесер"),
            keywords: &["несесер", "одећа", "тoрбa"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["несесер"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("neseser"),
            keywords: &["neseser", "odeća", "torba"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["neseser"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kuvertväska"),
            keywords: &["accessoar", "clutch", "kuvertväska"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kipochi"),
            keywords: &["kipochi", "mavazi", "mkoba"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பவுச\u{bcd}"),
            keywords: &["ஆடை அணிகலன\u{bcd}", "பவுச\u{bcd}", "பை"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c4c}చ\u{c4d}"),
            keywords: &[
                "ప\u{c4c}చ\u{c4d}",
                "బ\u{c4d}య\u{c3e}గ\u{c4d}",
                "మగవ\u{c3e}ళ\u{c4d}ల పర\u{c4d}సు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("клатч"),
            keywords: &["клатч", "либос", "сумка", "сумкача"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("กระเป\u{e4b}าใบเล\u{e47}ก"),
            keywords: &["กระเป\u{e4b}า", "กระเป\u{e4b}าใบเล\u{e47}ก"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("klaç sumka"),
            keywords: &["eşik", "goşhalta", "jübi", "klaç sumka"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("peesi teuteu"),
            keywords: &["peesi teuteu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("para kesesi"),
            keywords: &["giyim", "para kesesi", "çanta"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قولبوغچا"),
            keywords: &["خالتا", "سومكا", "قولبوغچا", "كىيىم"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("клатч"),
            keywords: &["клатч", "одяг", "сумка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بیگ"),
            keywords: &["بیگ", "لباس"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kichik sumka"),
            keywords: &["kichik sumka", "kiyim", "sumka"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("túi cắp nách"),
            keywords: &["quần áo", "túi", "túi cắp nách", "túi nhỏ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("poset"),
            keywords: &["poos", "poset", "saag", "yéere"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhegi ephathwayo"),
            keywords: &["ibhegi", "ibhegi ephathwayo", "impahla", "isipaji"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Baagi Ipamọwọ"),
            keywords: &["Baagi Ipamọwọ", "aṣọ", "páùṣì", "àpamọ\u{301}wọ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("手提袋"),
            keywords: &["手提袋", "服裝", "袋"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("手提袋"),
            keywords: &["手提袋", "服装", "袋"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("手袋"),
            keywords: &["包", "手拿包", "手袋"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("手拿包"),
            keywords: &["包包", "手拿包"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isikhwama"),
            keywords: &["impahla yokugqoka", "isikhwama"],
        },
    ],
};
#[doc = "🛍\u{fe0f}"]
pub const SHOPPING_BAGS: crate::Emoji = crate::Emoji {
    glyph: "🛍\u{fe0f}",
    codepoint: "1F6CD FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "shopping bags",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🛍",
        codepoint: "1F6CD",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "shopping bags",
        group: "Objects",
        subgroup: "clothing",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("winkelsakke"),
            keywords: &["inkopies", "sak", "winkel", "winkelsakke"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የመገበያያ ቦርሳዎች"),
            keywords: &["ሆቴል", "ቦርሳ", "የመገበያያ ቦርሳዎች", "ገበያ መውጣት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("حقائب تسوق"),
            keywords: &["تسوق", "حقائب تسوق", "حقيبة", "فندق"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("শ\u{9cd}বপিং বেগ"),
            keywords: &["বেগ", "শ\u{9cd}বপিং", "হোটেল"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("alış-veriş çantaları"),
            keywords: &["alış-veriş çantaları", "otel", "çanta", "şoppinq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("пакеты для шопінгу"),
            keywords: &["гатэль", "пакет", "пакеты для шопінгу", "шопінг"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Пазарски чанти"),
            keywords: &["Пазарски чанти", "пазаруване", "хотел", "чанта"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("কেন\u{9be}ক\u{9be}ট\u{9be}র ব\u{9cd}য\u{9be}গ"),
            keywords: &[
                "কেন\u{9be}ক\u{9be}ট\u{9be}",
                "কেন\u{9be}ক\u{9be}ট\u{9be}র ব\u{9cd}য\u{9be}গ",
                "ব\u{9cd}য\u{9be}গ",
                "হোটেল",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("seier kabas"),
            keywords: &["sacʼh", "seier kabas"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("vrećice za kupovinu"),
            keywords: &["kupovina", "vrećica", "vrećice za kupovinu", "šoping"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bosses de compres"),
            keywords: &["bosses", "bosses de compres", "compra"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏓᎿᎿᎩᎠ ᏗᏕᎦᎵᏟᏗ"),
            keywords: &["ᎠᏓᎿᎿᎩᎠ", "ᎠᏓᎿᎿᎩᎠ ᏗᏕᎦᎵᏟᏗ", "ᏕᎦᎵᏟᏗ", "ᏧᏂᏒᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("nákupní tašky"),
            keywords: &[
                "hotel",
                "nakupování",
                "nákupní tašky",
                "nákupy",
                "zavazadlo",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bagiau siopa"),
            keywords: &["bag", "bagiau siopa", "gwesty", "siopa"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("indkøbsposer"),
            keywords: &["hotel", "indkøbsposer", "pose", "shopping"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Einkaufstüten"),
            keywords: &[
                "Einkaufen",
                "Einkaufstüten",
                "Shopping",
                "einkaufen",
                "shoppen",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τσάντες για ψώνια"),
            keywords: &["ξενοδοχείο", "τσάντα", "τσάντες για ψώνια", "ψώνια"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("shopping bags"),
            keywords: &["bag", "hotel", "shopping", "shopping bags"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bolsas de compras"),
            keywords: &["bolsa", "bolsas de compras", "compra"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["bolsa", "bolsas de compras", "compras"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "bolsa",
                "bolsa de compras",
                "bolsas de compras",
                "compras",
                "hotel",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("ostukotid"),
            keywords: &["hotell", "kott", "ostud", "ostukotid"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("erosketa-poltsak"),
            keywords: &["erosketa", "erosketa-poltsak", "hotel", "poltsa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کیف خرید"),
            keywords: &["خرید", "هتل", "کیف"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ostoskassit"),
            keywords: &["kauppakassi", "laukku", "ostoskassit", "shoppailu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mga shopping bag"),
            keywords: &["bag", "mga shopping bag", "paper bag", "shopping"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("keypstaskur"),
            keywords: &[
                "beriposar",
                "beriposi",
                "innkeyp",
                "keyp",
                "keypstaskur",
                "posar",
                "posi",
                "shoppa",
                "shopping",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("sacs de shopping"),
            keywords: &["sac", "sacs de shopping", "shopping"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("sacs de magasinage"),
            keywords: &[
                "hôtel",
                "magasinage",
                "sac",
                "sacs de magasinage",
                "shopping",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("málaí siopadóireachta"),
            keywords: &[
                "ag siopadóireacht",
                "mála",
                "málaí siopadóireachta",
                "óstán",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bagaichean seopadaireachd"),
            keywords: &[
                "baga",
                "bagaichean seopadaireachd",
                "ceannachd",
                "seopadaireachd",
                "taigh-òsta",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("bolsas de compras"),
            keywords: &["bolsas", "bolsas de compras", "compras", "hotel"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("શોપિ\u{a82}ગ બ\u{ac7}ગ\u{acd}સ"),
            keywords: &[
                "ખરીદી",
                "શોપિ\u{a82}ગ",
                "શોપિ\u{a82}ગ બ\u{ac7}ગ\u{acd}સ",
                "હોટલ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("jakukkuna sayayya"),
            keywords: &["hotal", "jaka", "jakukkuna sayayya", "sayayya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שקיות קניות"),
            keywords: &["קניות", "שופינג", "שקיות"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("शॉपि\u{902}ग ब\u{948}ग"),
            keywords: &["खरीदारी", "ब\u{948}ग", "शॉपि\u{902}ग ब\u{948}ग", "होटल"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("vrećice za kupovinu"),
            keywords: &["kupovanje", "shopping", "vrećica", "vrećice za kupovinu"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("bevásárlótáskák"),
            keywords: &["bevásárlótáska", "bevásárlótáskák", "táska", "vásárlás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("գնումների պայուսակ"),
            keywords: &["գնումներ", "գնումների պայուսակ", "հյուրանոց", "պայուսակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tas belanja"),
            keywords: &["belanja", "hotel", "tas"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("àkpà azụmaahịa gasị"),
            keywords: &["azụmaahịa", "àkpà", "àkpà azụmaahịa gasị", "ụlọ nkwarị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("innkaupapoki"),
            keywords: &["hótel", "innkaupapoki", "poki", "verslunarleiðangur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("borse della spesa"),
            keywords: &["borse della spesa", "sacchetti", "sacchetti regalo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("紙袋"),
            keywords: &["ショッピングバッグ", "バッグ", "紙手提げ", "紙袋"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tas blanja"),
            keywords: &["blanja", "hotel", "tas"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("საყიდლების პარკები"),
            keywords: &["სასტუმრო", "საყიდლები", "საყიდლების პარკები", "ჩანთა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сауда қалталары"),
            keywords: &["дүкен", "сауда қалталары", "сөмке", "қонақ үй"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("indkøbsposer"),
            keywords: &["hotel", "indkøbsposer", "pose"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ថង\u{17cb}ដាក\u{17cb}ទ\u{17c6}ន\u{17b7}ញ"),
            keywords: &[
                "ថង\u{17cb}ដាក\u{17cb}ទ\u{17c6}ន\u{17b7}ញ",
                "ថង\u{17cb}ដាក\u{17cb}ឥវ\u{17c9}ាន\u{17cb}",
                "អ\u{17b8}វ\u{17c9}ាន\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಶಾಪ\u{cbf}ಂಗ\u{ccd} ಬ\u{ccd}ಯಾಗ\u{ccd}\u{200c}ಗಳು"),
            keywords: &[
                "ಬ\u{ccd}ಯಾಗ\u{ccd}",
                "ಶಾಪ\u{cbf}ಂಗ\u{ccd}",
                "ಶಾಪ\u{cbf}ಂಗ\u{ccd} ಬ\u{ccd}ಯಾಗ\u{ccd}\u{200c}ಗಳು",
                "ಹೋಟ\u{cc6}ಲ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("쇼핑백"),
            keywords: &["쇼핑가방", "쇼핑백"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("शॉपि\u{902}ग ब\u{945}गा\u{902}"),
            keywords: &[
                "ब\u{945}ग",
                "शॉपि\u{902}ग",
                "शॉपि\u{902}ग ब\u{945}गा\u{902}",
                "हॉट\u{947}ल",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("соода баштыктары"),
            keywords: &["баштык", "мейманкана", "соода", "соода баштыктары"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Akafstuten"),
            keywords: &["Akafstuten", "Hotel", "Shopping", "Tut", "akafen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຖ\u{ebb}ງໃສ\u{ec8}ເຄ\u{eb7}\u{ec8}ອງ"),
            keywords: &[
                "ຖ\u{ebb}ງ",
                "ຖ\u{ebb}ງໃສ\u{ec8}ເຄ\u{eb7}\u{ec8}ອງ",
                "ເຄ\u{eb7}\u{ec8}ອງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("pirkinių krepšeliai"),
            keywords: &[
                "apsipirkimas",
                "krepšys",
                "pirkinių krepšeliai",
                "viešbutis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("iepirkumu maisiņi"),
            keywords: &["iepirkumu maisiņi", "iepirkumu somas", "maisiņš", "soma"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pēke hokohoko"),
            keywords: &["hokohoko", "hōtēra", "pēke"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("кеси за пазарење"),
            keywords: &["кеси за пазарење", "пазарење", "хотел", "чанта"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഷോപ\u{d4d}പിംഗ\u{d4d} ബ\u{d3e}ഗ\u{d41}കൾ"),
            keywords: &[
                "ബ\u{d3e}ഗ\u{d4d}",
                "ഷോപ\u{d4d}പിംഗ\u{d4d}",
                "ഷോപ\u{d4d}പിംഗ\u{d4d} ബ\u{d3e}ഗ\u{d41}കൾ",
                "ഹോട\u{d4d}ടൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дэлгүүр хэсэг зориулалттай цүнх"),
            keywords: &[
                "буудал",
                "дэлгүүр",
                "дэлгүүр хэсэг зориулалттай цүнх",
                "цүнх",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("खर\u{947}दीची पिशवी"),
            keywords: &[
                "खर\u{947}दी",
                "खर\u{947}दीची पिशवी",
                "खर\u{947}दीच\u{94d}या पिशव\u{94d}या",
                "ब\u{945}ग",
                "हॉट\u{947}ल",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("beg beli-belah"),
            keywords: &["beg", "beg beli-belah", "hotel", "membeli-belah"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("basktijiet tax-xiri"),
            keywords: &["basktijiet tax-xiri", "borża", "lukanda", "xiri"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဈေးဝယ\u{103a} အ\u{102d}တ\u{103a}များ"),
            keywords: &[
                "စျေးဝယ\u{103a}ခြင\u{103a}း",
                "စျေးဝယ\u{103a}အ\u{102d}တ\u{103a}များ",
                "ဈေးဝယ\u{103a} အ\u{102d}တ\u{103a}များ",
                "ထည\u{1037}\u{103a}စရာ အ\u{102d}တ\u{103a}",
                "ဟ\u{102d}\u{102f}တယ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("handleposer"),
            keywords: &["handleposer", "hotell", "pose", "shopping"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("किनम\u{947}ल गर\u{94d}न\u{947} झोला"),
            keywords: &[
                "किनम\u{947}ल",
                "किनम\u{947}ल गर\u{94d}न\u{947} झोला",
                "झोला",
                "होट\u{947}ल",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("boodschappentassen"),
            keywords: &["boodschappentassen", "hotel", "tas", "winkelen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("handleposar"),
            keywords: &["handleposar", "hotell", "pose", "shopping"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଶପ\u{b3f}ଂ ବ\u{b4d}ୟ\u{b3e}ଗ\u{b4d}\u{200c}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ"),
            keywords: &[
                "ବ\u{b4d}ୟ\u{b3e}ଗ\u{b4d}\u{200c} । ହୋଟେଲ\u{b4d}\u{200c} । ଶପ\u{b3f}ଂ",
                "ଶପ\u{b3f}ଂ ବ\u{b4d}ୟ\u{b3e}ଗ\u{b4d}\u{200c}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਖਰੀਦਦਾਰੀ ਵਾਲ\u{a47} ਬ\u{a48}ਗ"),
            keywords: &[
                "ਖਰੀਦਦਾਰੀ",
                "ਖਰੀਦਦਾਰੀ ਵਾਲ\u{a47} ਬ\u{a48}ਗ",
                "ਬ\u{a48}ਗ",
                "ਹ\u{a4b}ਟਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("خریداری آلے تھیلے"),
            keywords: &["تھیلا", "خریداری", "خریداری آلے تھیلے", "ہوٹل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Shọ\u{301}pín Bag"),
            keywords: &[
                "Bag",
                "Họtẹl",
                "Klọt",
                "Shọ\u{301}pin",
                "Shọ\u{301}pín Bag",
                "Shọ\u{301}pín Bag-dẹm",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("torby na zakupy"),
            keywords: &["torby", "torby na zakupy", "torebki"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("خریدارۍ بکسه"),
            keywords: &["بکس", "خریداری", "خریدارۍ بکسه", "هوټل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("sacolas de compras"),
            keywords: &[
                "compras",
                "sacolas",
                "sacolas de compras",
                "sacolas de shopping",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("sacos de compras"),
            keywords: &["compras", "hotel", "saco", "sacos de compras"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("ratina qamaña"),
            keywords: &["ratina qamaña"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("sacoșe de cumpărături"),
            keywords: &["cumpărături", "sacoșe de cumpărături", "transport"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-988"),
            keywords: &["E10-988"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("пакеты"),
            keywords: &["магазины", "новое", "пакеты", "покупки"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibikapu bahahiramo"),
            keywords: &["ibikapu bahahiramo", "igikapu", "umwambaro", "uruhago"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("خريداري جي ٿيلي"),
            keywords: &["بيگ", "خريداري", "خريداري جي ٿيلي", "هوٽل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ෂොප\u{dd2}න\u{dca} බෑග\u{dca}"),
            keywords: &[
                "බෑගය",
                "ෂොප\u{dd2}න\u{dca} බෑග\u{dca}",
                "ස\u{dcf}ප\u{dca}ප\u{dd4} සව\u{dcf}ර\u{dd2}ය",
                "හෝටලය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("nákupné tašky"),
            keywords: &["hotel", "nakupovanie", "nákupné tašky", "taška"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("nakupovalni vrečki"),
            keywords: &["hotel", "nakupovalni vrečki", "nakupovanje", "torbica"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("bacaha dukaameysiga"),
            keywords: &["bac", "bacaha dukaameysiga", "dukaameysi", "hudheel"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("qese dyqani"),
            keywords: &["blerje", "dyqan", "hotel", "qese", "qese dyqani"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("торбе за куповину"),
            keywords: &["купoвaњe", "торба", "торбе за куповину", "хотел"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("torbe za kupovinu"),
            keywords: &["hotel", "kupovanje", "torba", "torbe za kupovinu"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("shoppingpåsar"),
            keywords: &["påsar", "shopping", "shoppingpåsar"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mifuko ya kubebea bidhaa"),
            keywords: &[
                "hoteli",
                "mifuko ya kubeba bidhaa baada ya kununua",
                "mifuko ya kubebea bidhaa",
                "mkoba",
                "ununuzi",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஷ\u{bbe}ப\u{bcd}பிங\u{bcd} பேக\u{bcd}ஸ\u{bcd}"),
            keywords: &[
                "பிக\u{bcd} ஷ\u{bbe}ப\u{bcd}பர\u{bcd} பேக\u{bcd}",
                "ஷ\u{bbe}ப\u{bcd}பிங\u{bcd}",
                "ஷ\u{bbe}ப\u{bcd}பிங\u{bcd} பேக\u{bcd}குகள\u{bcd}",
                "ஷ\u{bbe}ப\u{bcd}பிங\u{bcd} பேக\u{bcd}ஸ\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "ష\u{c3e}ప\u{c3f}ంగ\u{c4d}\u{200c}క\u{c3f} వ\u{c3e}డ\u{c47} బ\u{c4d}య\u{c3e}గులు",
            ),
            keywords: &[
                "బ\u{c4d}య\u{c3e}గ\u{c4d}",
                "ష\u{c3e}ప\u{c3f}ంగ\u{c4d}",
                "ష\u{c3e}ప\u{c3f}ంగ\u{c4d}\u{200c}క\u{c3f} వ\u{c3e}డ\u{c47} బ\u{c4d}య\u{c3e}గులు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("сумкаҳо барои харид кардан"),
            keywords: &["меҳмонхона", "сумка", "сумкаҳо барои харид кардан", "харид"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ถ\u{e38}งช\u{e47}อปป\u{e34}\u{e49}ง"),
            keywords: &[
                "ช\u{e49}อปป\u{e34}\u{e49}ง",
                "ถ\u{e38}ง",
                "ถ\u{e38}งช\u{e47}อปป\u{e34}\u{e49}ง",
                "ห\u{e49}าง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("söwda goşhaltalary"),
            keywords: &["goşhalta", "otel", "söwda goşhaltalary", "şoping"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kato faʻoʻanga fakatau"),
            keywords: &["kato faʻoʻanga fakatau"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("alışveriş çantası"),
            keywords: &["alışveriş", "alışveriş çantası", "otel", "çanta"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("مال سېتىۋېلىش خالتىسى"),
            keywords: &["خالتا", "سېتىۋېلىش", "مال سېتىۋېلىش خالتىسى", "مېھمانخانا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("сумки для покупок"),
            keywords: &["покупки", "сумка", "сумки для покупок"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("شاپنگ بیگز"),
            keywords: &["بیگ", "شاپنگ", "شاپنگ بیگز", "ہوٹل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("xarid sumkalari"),
            keywords: &["mehmonxona", "sumka", "xarid", "xarid sumkalari"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("túi mua sắm"),
            keywords: &["khách sạn", "mua sắm", "túi", "túi mua sắm"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("saagu ndugg"),
            keywords: &["ndugg", "otel", "saag", "saagu ndugg"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iibhegi zokuthenga"),
            keywords: &["ibhegi", "ihotele", "iibhegi zokuthenga", "ukuthenga"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àwọn àpamọ\u{301}wọ\u{301} ọjà"),
            keywords: &[
                "ilé ìtura",
                "àpamọ\u{301}wọ\u{301}",
                "àwọn àpamọ\u{301}wọ\u{301} ọjà",
                "ọjà",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("購物袋"),
            keywords: &["袋", "購物", "購物袋", "酒店"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("购物袋"),
            keywords: &["袋", "购物", "购物袋", "酒店"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("购物袋"),
            keywords: &["包", "袋", "购物袋", "逛街"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("紙袋"),
            keywords: &["紙袋", "購物袋"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("izikhwama zokuthenga"),
            keywords: &["ihhotela", "isikhwama", "izikhwama zokuthenga", "ukuthenga"],
        },
    ],
};
#[doc = "🎒"]
pub const BACKPACK: crate::Emoji = crate::Emoji {
    glyph: "🎒",
    codepoint: "1F392",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "backpack",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("rugsak"),
            keywords: &["rugsak", "sak", "skool", "skoolrugsak", "tas"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የትምህርት ቤት ቦርሳ"),
            keywords: &["ቦርሳ", "ትምህርት ቤት", "ክርታስ", "የትምህርት ቤት ቦርሳ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("حقيبة مدرسة"),
            keywords: &["حقيبة مدرسة", "مدرسة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("স\u{9cd}ক\u{9c1}ল বেকপেক"),
            keywords: &[
                "ছেটচেল",
                "বেগ",
                "স\u{9cd}ক\u{9c1}ল",
                "স\u{9cd}ক\u{9c1}ল বেকপেক",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("məktəbli bel çantası"),
            keywords: &["bel çantası", "məktəb", "məktəbli bel çantası", "çanta"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("школьны ранец"),
            keywords: &["кніжная сумка", "сумка", "школа", "школьны ранец"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Ученическа чанта"),
            keywords: &["Ученическа чанта", "раница", "училище", "чанта"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9cd}ক\u{9c1}লের পিঠে নেওয\u{9bc}\u{9be}র ব\u{9cd}য\u{9be}গ"),
            keywords: &[
                "ব\u{9cd}য\u{9be}গ",
                "স\u{9cd}ক\u{9c1}ল",
                "স\u{9cd}ক\u{9c1}লের পিঠে নেওয\u{9bc}\u{9be}র ব\u{9cd}য\u{9be}গ",
                "স\u{9cd}ক\u{9c1}লের ব\u{9cd}য\u{9be}গ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("sacʼh-kein"),
            keywords: &["sacʼh", "sacʼh-kein", "sacʼh-skol"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ruksak"),
            keywords: &["ruksak", "torba", "đačka torba", "škola"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("motxilla d’escola"),
            keywords: &["escola", "motxilla", "motxilla d’escola"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᏕᎶᏆᏍᏗ ᎦᎵᏒᏍᏓ"),
            keywords: &["ᏕᎦᎵᏟᏗ", "ᏕᎦᎶᏗ ᎤᏍᏗ", "ᏕᎦᎶᏗ ᎤᏔᎾ", "ᏗᏕᎶᏆᏍᏗ ᎦᎵᏒᏍᏓ", "ᏧᎾᏕᎶᏆᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("školní batoh"),
            keywords: &[
                "aktovka",
                "batoh",
                "taška",
                "zavazadlo",
                "škola",
                "školní batoh",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bag ysgol"),
            keywords: &["bag", "ysgol"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("rygsæk"),
            keywords: &["rygsæk", "skole", "skoletaske", "taske"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schulranzen"),
            keywords: &["Ranzen", "Rucksack", "Schule", "Schulranzen", "Tornister"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σχολική σάκα"),
            keywords: &["σχολείο", "σχολική σάκα", "σχολική τσάντα", "τσάντα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("backpack"),
            keywords: &["backpack", "bag", "rucksack", "satchel", "school"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("school bag"),
            keywords: &[""],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("backpack"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("mochila escolar"),
            keywords: &["colegio", "mochila", "mochila escolar"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("mochila"),
            keywords: &["escuela", "estudiar", "maletín", "mochila"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("mochila escolar"),
            keywords: &["escuela", "estudiar", "maletín", "mochila escolar"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("mochila escolar"),
            keywords: &["escuela", "estudiar", "maletín", "mochila escolar"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("ranits"),
            keywords: &["kool", "kott", "ranits"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bizkar-zorroa"),
            keywords: &[
                "bizkar-zorro",
                "bizkar-zorroa",
                "eskola",
                "eskolako bizkar-zorroa",
                "poltsa",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کوله\u{200c}پشتی"),
            keywords: &["مدرسه", "کوله\u{200c}پشتی", "کولی", "کیف"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("koulureppu"),
            keywords: &["koulu", "koululaukku", "koulureppu", "laukku"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("backpack na pang-eskwela"),
            keywords: &[
                "backpack",
                "backpack na pang-eskwela",
                "bag",
                "estudyante",
                "mag-aaral",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("skúlataska"),
            keywords: &["herðataska", "skúlataska", "skúli", "taska"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cartable"),
            keywords: &["cartable", "sac", "sac à dos", "école"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("sac d’école"),
            keywords: &["sac", "sac d’école", "sac à dos", "école"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("mála scoile"),
            keywords: &["mála", "mála scoile", "scoil"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("baga-droma sgoile"),
            keywords: &["baga", "baga-droma", "baga-droma sgoile", "màla", "sgoil"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("mochila"),
            keywords: &["escola", "mochila"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}ક\u{ac2}લન\u{ac1}\u{a82} દફતર"),
            keywords: &[
                "દફતર",
                "સ\u{acd}ક\u{ac2}લ",
                "સ\u{acd}ક\u{ac2}લ બ\u{ac7}ગ",
                "સ\u{acd}ક\u{ac2}લન\u{ac1}\u{a82} દફતર",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("jakar baya ta makaranta"),
            keywords: &["gafaka", "jaka", "jakar baya ta makaranta", "makaranta"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ילקוט"),
            keywords: &["בית ספר", "ילקוט", "לימודים", "תיק"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{94d}क\u{942}ल का बस\u{94d}ता"),
            keywords: &[
                "बस\u{94d}ता",
                "विद\u{94d}यालय",
                "स\u{94d}क\u{942}ल का बस\u{94d}ता",
                "स\u{94d}क\u{942}ल ब\u{948}ग",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("školski ruksak"),
            keywords: &["torba", "škola", "školski ruksak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("iskolatáska"),
            keywords: &["hátizsák", "iskola", "iskolatáska", "táska"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("դպրոցական պայուսակ"),
            keywords: &["դպրոց", "դպրոցական պայուսակ", "ուսապարկ", "պայուսակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tas sekolah"),
            keywords: &["ransel", "sekolah", "tas"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("àkpà akwụkwọ nkwọ\u{300} n’azụ"),
            keywords: &[
                "akpụkpanụ",
                "àkpà",
                "àkpà akwụkwọ nkwọ\u{300} n’azụ",
                "ụlọakwụkwọ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("skólataska"),
            keywords: &["skólataska", "skóli", "taska"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("zaino"),
            keywords: &[
                "cartella",
                "cartella di scuola",
                "scuola",
                "zaino",
                "zaino per la scuola",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("バックパック"),
            keywords: &[
                "バックパック",
                "ランドセル",
                "リュックサック",
                "学校",
                "小学校",
                "小学生",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ransel"),
            keywords: &["ransel", "sekolah", "tas", "tas cangklong", "tas gendhong"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სკოლის ზურგჩანთა"),
            keywords: &["ზურგჩანთა", "სკოლა", "სკოლის ზურგჩანთა", "ჩანთა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("папка"),
            keywords: &["арқаға асатын сөмке", "мектеп", "папка", "сөмке"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("rygsæk"),
            keywords: &["rygsæk", "skole", "skoletaske", "taske"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កាប\u{17bc}បស\u{17d2}ពាយខ\u{17d2}នង"),
            keywords: &[
                "កាតាប",
                "កាប\u{17bc}ប",
                "កាប\u{17bc}បស\u{17d2}ពាយ",
                "កាប\u{17bc}បស\u{17d2}ពាយខ\u{17d2}នង",
                "កាប\u{17bc}បស\u{17d2}ពាយព\u{17b8}ក\u{17d2}រោយ",
                "សាលារៀន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಶಾಲ\u{cc6}ಯ ಬ\u{ccd}ಯಾಕ\u{ccd}\u{200c}ಪ\u{ccd}ಯಾಕ\u{ccd}"),
            keywords: &[
                "ರಕ\u{ccd}ಸ\u{ccd}ಯಾಕ\u{ccd}",
                "ಶಾಲ\u{cc6}ಯ ಚೀಲ",
                "ಶಾಲ\u{cc6}ಯ ಬ\u{ccd}ಯಾಕ\u{ccd}\u{200c}ಪ\u{ccd}ಯಾಕ\u{ccd}",
                "ಸ\u{ccd}ಯಾಚ\u{cc6}ಲ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("학교 가방"),
            keywords: &["가방", "학교 가방", "학생 가방"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ब\u{945}कप\u{945}क"),
            keywords: &[
                "ब\u{945}कप\u{945}क",
                "ब\u{945}ग",
                "रस\u{94d}कस\u{945}क",
                "शाळा",
                "स\u{945}च\u{947}ल",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("окуучулардын жонбаштыгы"),
            keywords: &["баштык", "мектеп", "окуучулардын жонбаштыгы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Schoulsak"),
            keywords: &["Posch", "Schoul", "Schoulsak"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກະເປ\u{ebb}າເປ\u{ec9}"),
            keywords: &[
                "ກະເປ\u{ebb}າເປ\u{ec9}",
                "ຖ\u{ebb}ງເປ\u{ec9}",
                "ຖ\u{ebb}ງເປ\u{ec9}ໄປໂຮງຮຽນ",
                "ໂຮງຮຽນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mokyklinė kuprinė"),
            keywords: &["krepšys", "kuprinė", "mokykla", "mokyklinė kuprinė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("mugursoma"),
            keywords: &["mugursoma", "skola", "skolas mugursoma", "soma"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pēketuarā kura"),
            keywords: &["kura", "pēke", "pēke tari", "pēketuarā kura"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("училишен ранец"),
            keywords: &["ранец", "торба", "училишен ранец", "училиште", "чанта"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d4d}\u{200c}ക\u{d42}ൾ ബ\u{d3e}ഗ\u{d4d}"),
            keywords: &[
                "ബ\u{d3e}ഗ\u{d4d}",
                "സഞ\u{d4d}ചി",
                "സ\u{d4d}\u{200c}ക\u{d42}ൾ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("үүргэвч"),
            keywords: &["аяны үүргэвч", "сургууль", "цүнх", "үүргэвч"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("शाळ\u{947}च\u{947} दप\u{94d}तर"),
            keywords: &[
                "ब\u{945}ग",
                "शाळा",
                "शाळ\u{947}च\u{947} दप\u{94d}तर",
                "स\u{945}च\u{947}ल",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("beg galas sekolah"),
            keywords: &["beg", "beg galas", "beg galas sekolah", "sekolah"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("basket tal-iskola"),
            keywords: &["basket tal-iskola", "borża", "satchel", "skola"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကျောင\u{103a}းသား ကျောပ\u{102d}\u{102f}းအ\u{102d}တ\u{103a}"),
            keywords: &[
                "ကျောင\u{103a}းသား ကျောပ\u{102d}\u{102f}းအ\u{102d}တ\u{103a}",
                "ကျောင\u{103a}းသ\u{102f}\u{1036}း ကျောပ\u{102d}\u{102f}းအ\u{102d}တ\u{103a}",
                "ကျောပ\u{102d}\u{102f}းအ\u{102d}တ\u{103a}",
                "ပတ\u{1039}တ\u{1030}လ\u{103d}ယ\u{103a}အ\u{102d}တ\u{103a}",
                "အ\u{102d}တ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("skolesekk"),
            keywords: &["ransel", "ryggsekk", "skolesekk"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}क\u{941}ल\u{947} ब\u{94d}याकप\u{94d}याक"),
            keywords: &[
                "झोला",
                "विद\u{94d}यालय",
                "स\u{94d}क\u{941}ल\u{947} झोला",
                "स\u{94d}क\u{941}ल\u{947} ब\u{94d}याकप\u{94d}याक",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("schooltas"),
            keywords: &["rugzak", "school", "schooltas", "tas"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("skulesekk"),
            keywords: &["ransel", "ryggsekk", "skulesekk"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b4d}ୟ\u{b3e}କ\u{b4d}\u{200c}ପ\u{b4d}ୟ\u{b3e}କ\u{b4d}\u{200c}"),
            keywords: &[
                "ବସ\u{b4d}ତ\u{b3e}ନ\u{b3f}",
                "ବ\u{b3f}ଦ\u{b4d}ୟ\u{b3e}ଳୟ",
                "ବ\u{b4d}ୟ\u{b3e}କ\u{b4d}\u{200c}ପ\u{b4d}ୟ\u{b3e}କ\u{b4d}\u{200c}",
                "ସ\u{b4d}କ\u{b41}ଲ\u{b4d}\u{200c} ବ\u{b4d}ୟ\u{b3e}କପ\u{b4d}ୟ\u{b3e}କ\u{b4d}\u{200c}",
                "ସ\u{b4d}କ\u{b41}ଲ\u{b4d}\u{200c} ବ\u{b4d}ୟ\u{b3e}ଗ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਕ\u{a42}ਲ ਬ\u{a48}ਗ"),
            keywords: &["ਬ\u{a48}ਗ", "ਸਕ\u{a42}ਲ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سکول دے سامان نال سفر"),
            keywords: &["بستہ", "تھیلا", "سکول", "سکول دے سامان نال سفر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bákpák Bag"),
            keywords: &[
                "Bag",
                "Bag Wé Pípil De Kárí Fọ Bak",
                "Bákpak Bag",
                "Bákpák Bag",
                "Rọ\u{301}ksák Bag",
                "Skul",
                "Sáchẹl Bag",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("tornister"),
            keywords: &["plecak", "tornister"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د مکتب بکسه"),
            keywords: &["بکس", "د مکتب بکسه", "مکتب"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mochila"),
            keywords: &["bolsa escolar", "escola", "mochila", "mochila escolar"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("mochila da escola"),
            keywords: &["escola", "mochila", "mochila da escola", "pasta", "saco"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("rucsac"),
            keywords: &["ghiozdan", "rechizite", "rucsac", "școală"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-343"),
            keywords: &["E10-343"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("ранец"),
            keywords: &["портфель", "ранец", "рюкзак", "школа"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igikapu cy’umunyeshuri"),
            keywords: &["igikapu", "igikapu cy’umunyeshuri", "isashi", "ishuri"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اسڪول جو پٺن وارو ٿيلو"),
            keywords: &["اسڪول", "اسڪول جو پٺن وارو ٿيلو", "بيگ", "ٿيلها"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd2}ටේ බැඳන\u{dca} යන ප\u{dcf}සැල\u{dca} බෑගය"),
            keywords: &[
                "උරහ\u{dd2}ස\u{dca} බෑගය",
                "ප\u{dcf}සල",
                "ප\u{dd2}ටේ බැඳන\u{dca} යන ප\u{dcf}සැල\u{dca} බෑගය",
                "බෑගය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("školský batoh"),
            keywords: &["aktovka", "batoh", "škola", "školský batoh"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("šolski nahrbtnik"),
            keywords: &["nahrbtnik", "torba", "šola", "šolski nahrbtnik"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("shandad dhabar"),
            keywords: &[
                "dhabar-saar",
                "dugsi",
                "garab-saar",
                "shandad",
                "shandad dhabar",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("çantë shkolle"),
            keywords: &["shkollë", "çantë", "çantë shkolle", "çantë shpine"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("школски ранац"),
            keywords: &["тoрбa", "шкoлa", "школски ранац"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("školski ranac"),
            keywords: &["torba", "škola", "školski ranac"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ryggsäck"),
            keywords: &["ryggsäck", "skolväska", "väska"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mfuko wa shuleni"),
            keywords: &["begi", "mfuko wa shuleni", "mkoba", "shule"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பள\u{bcd}ளிக\u{bcd}கூட பை"),
            keywords: &[
                "பள\u{bcd}ளிக\u{bcd}கூட பை",
                "பள\u{bcd}ளிக\u{bcd}கூடம\u{bcd}",
                "பை",
                "ம\u{bbe}ணவர\u{bcd}கள\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c4d}కూల\u{c4d} బ\u{c4d}య\u{c3e}గ\u{c4d}"),
            keywords: &["బ\u{c4d}య\u{c3e}గ\u{c4d}", "స\u{c4d}కూల\u{c4d}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("борхалтаи мактабӣ"),
            keywords: &["борхалтаи мактабӣ", "мактаб", "сумка", "ҷузъдон"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เป\u{e49}น\u{e31}กเร\u{e35}ยน"),
            keywords: &[
                "กระเป\u{e4b}า",
                "กระเป\u{e4b}าเร\u{e35}ยน",
                "เป\u{e49}น\u{e31}กเร\u{e35}ยน",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("mekdep goşhaltasy"),
            keywords: &[
                "goşhalta",
                "mekdep",
                "mekdep goşhaltasy",
                "portfel",
                "rýukzak",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kato ako"),
            keywords: &["kato ako"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("okul çantası"),
            keywords: &["okul", "okul sırt çantası", "okul çantası", "sırt çantası"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كىتاب بوغچىسى"),
            keywords: &["خالتا", "سومكا", "كىتاب بوغچىسى", "مەكتەپ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("шкільний рюкзак"),
            keywords: &["навчання", "ранець", "сумка", "школа", "шкільний рюкзак"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اسکول کا بستہ"),
            keywords: &["اسکول", "اسکول کا بستہ", "بیگ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ryukzak"),
            keywords: &["jild", "maktab", "ryukzak", "sumka"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ba lô đi học"),
            keywords: &["ba lô đi học", "cặp", "trường", "túi"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("saagu ndongo daara"),
            keywords: &["daara", "saag", "saagu ndongo daara", "satchel"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubhaka wesikolo"),
            keywords: &["ibhegi", "ingxowana", "isikolo", "ubhaka wesikolo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Baagi Ile-ẹkọ Agbekẹyin"),
            keywords: &[
                "Baagi Ile-ẹkọ Agbekẹyin",
                "ilé ìwé",
                "sáṣẹ\u{300}lì",
                "àpamọ\u{301}wọ\u{301}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("學校背囊"),
            keywords: &["學校", "學校背囊", "書包", "袋"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("学校背囊"),
            keywords: &["书包", "学校", "学校背囊", "袋"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("书包"),
            keywords: &["书包", "包"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("書包"),
            keywords: &["書包", "肩揹書包"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isikhwama sesikole"),
            keywords: &["isikhwama", "isikhwama sesikole", "isikole", "ubhaka"],
        },
    ],
};
#[doc = "🩴"]
pub const THONG_SANDAL: crate::Emoji = crate::Emoji {
    glyph: "🩴",
    codepoint: "1FA74",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "thong sandal",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("tussentoonplakkie"),
            keywords: &[
                "deurtoonplakkies",
                "plakkies",
                "stortplakkies",
                "strandplakkies",
                "tussentoonplakkie",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የነጠላ ጫማ ማሰሪያ"),
            keywords: &["የነጠላ ጫማ ማሰሪያ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("صندل إصبع"),
            keywords: &["بإصبع", "صنادل", "صنادل إصبع", "صندل إصبع", "صندل للشاطئ"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ৰচী থক\u{9be} চেণ\u{9cd}ডেল"),
            keywords: &[
                "চেণ\u{9cd}ডেল",
                "জৰী",
                "বিচ\u{9cd}চত পিন\u{9cd}ধ\u{9be} চেণ\u{9cd}ডেল",
                "ৰচী",
                "ৰচী থক\u{9be} চেণ\u{9cd}ডেল",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("vyetnamka"),
            keywords: &[
                "rezin vyetnamka",
                "səndəllər",
                "vyetnamka",
                "vyetnamkalar",
                "zori",
                "çimərlik səndəlləri",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("в’етнамка"),
            keywords: &[
                "в’етнамка",
                "в’етнамкі",
                "дзоры",
                "пляжныя сандалі",
                "сандалі",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("джапанки"),
            keywords: &["джапанки", "плажни сандали", "сандали", "чехли"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চটি"),
            keywords: &[
                "চটি",
                "চপ\u{9cd}পল",
                "জোরি",
                "স\u{9cd}য\u{9be}ন\u{9cd}ডেল",
                "হ\u{9be}ওয\u{9bc}\u{9be}ই চপ\u{9cd}পল",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("tong"),
            keywords: &["sandalenn", "soledenn", "solenn", "tong"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("japanke"),
            keywords: &["japanke", "papuče za plažu", "sandale", "sandale za plažu"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("xancleta de dit"),
            keywords: &["xancleta", "xancleta de dit", "xancleta de platja"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᏚᎢᏓ ᎠᎳᏑᎶ"),
            keywords: &[
                "ᎠᏍᏚᎢᏓ ᎠᎳᏑᎶ",
                "ᎪᎩ ᏗᎳᏑᎶ",
                "ᎪᎩ ᏗᏍᏚᎢᏓ ᏗᎳᏑᎶ",
                "ᏃᏱ ᏗᏍᏚᎢᏓ ᏗᎳᏑᎶ",
                "ᏐᎵ",
                "ᏗᏍᏚᎢᏍᏓ ᏗᎳᏑᎶ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("žabka"),
            keywords: &[
                "pláž",
                "sandál",
                "sandále",
                "sandály",
                "vietnamky",
                "žabka",
                "žabky",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sandal thong"),
            keywords: &[
                "sandal thong",
                "sandalau",
                "sandalau thong",
                "sandalau traeth",
                "thongs",
                "zōri",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("klipklapper"),
            keywords: &["klipklapper", "sandaler", "strandsandaler", "zōri"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Zehensandale"),
            keywords: &["Zehensandale", "Zehensandalen"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Flipflops"),
            keywords: &["Flipflops", "Zehensandale", "Zehensandalen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σαγιονάρα"),
            keywords: &["σαγιονάρα", "σαγιονάρες", "σανδάλια", "σανδάλια παραλίας"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("thong sandal"),
            keywords: &[
                "beach sandals",
                "sandals",
                "thong sandal",
                "thong sandals",
                "thongs",
                "zōri",
            ],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("flip-flop"),
            keywords: &[
                "beach sandals",
                "flip-flop",
                "flipflop",
                "sandals",
                "thong sandals",
                "thongs",
                "zori",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("thongs"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("flip-flop"),
            keywords: &["beach sandal", "flip-flop", "sandal", "thong", "zōri"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("flip-flop"),
            keywords: &[
                "beach sandals",
                "flip-flop",
                "flipflop",
                "sandals",
                "thong sandals",
                "thongs",
                "zori",
            ],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &[
                "beach sandals",
                "flip-flop",
                "sandals",
                "thong sandal",
                "thong sandals",
                "thongs",
                "zōri",
            ],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("chancla"),
            keywords: &[
                "chancla",
                "chancla de dedo",
                "chancleta",
                "chinela",
                "sandalia",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("chancla"),
            keywords: &["chancla", "chancleta", "chinela", "sandalia"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("varbavahesandaalid"),
            keywords: &[
                "plätud",
                "rannajalatsid",
                "rannasandaalid",
                "sandaalid",
                "varbavahesandaalid",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("hondartzarako sandalia"),
            keywords: &[
                "hondartzako sandaliak",
                "hondartzarako sandalia",
                "sandalia uhaldunak",
                "sandaliak",
                "zōri",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دمپایی لاانگشتی"),
            keywords: &[
                "دمپایی ساحلی",
                "دمپایی لاانگشتی",
                "دمپایی چوبی لاانگشتی",
                "صندل",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("varvassandaali"),
            keywords: &[
                "rantasandaalit",
                "sandaalit",
                "varvassandaali",
                "varvassandaalit",
                "varvastossut",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tsinelas"),
            keywords: &["pang-beach na tsinelas", "sandals", "tsinelas"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sandála"),
            keywords: &["sandála", "thong"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("tong"),
            keywords: &[
                "claquettes",
                "sandales",
                "sandales de plage",
                "tatanes",
                "tong",
                "tongs",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("gougoune"),
            keywords: &["gougoune", "sandales", "sandales de plage", "tongs", "zōri"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cuarán"),
            keywords: &["cuarán"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cuaran-èill"),
            keywords: &["cuaran", "cuaran-èill", "iall", "zōri"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("chancleta"),
            keywords: &["calzado", "chancleta", "praia", "sandalia"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("થો\u{a82}ગ સ\u{ac7}ન\u{acd}ડલ"),
            keywords: &[
                "ઝોરી",
                "થો\u{a82}ગ સ\u{ac7}ન\u{acd}ડલ",
                "થો\u{a82}ગ\u{acd}સ",
                "બીચ પર પહ\u{ac7}રવાના સ\u{ac7}ન\u{acd}ડલ",
                "સ\u{ac7}ન\u{acd}ડલ\u{acd}સ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כפכפי אצבע"),
            keywords: &["כפכפי אצבע", "כפכפים", "נעלי אצבע"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("थॉन\u{94d}ग स\u{948}\u{902}डल"),
            keywords: &[
                "चप\u{94d}पल\u{947}\u{902}",
                "ज\u{93c}ोरी",
                "थॉन\u{94d}ग",
                "थॉन\u{94d}ग स\u{948}\u{902}डल",
                "बीच पर पहनन\u{947} वाल\u{947} स\u{948}\u{902}डल",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("japanka"),
            keywords: &[
                "japanka",
                "japanke",
                "obuća za plažu",
                "sandale",
                "sandale za plažu",
                "zōri",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("tangapapucs"),
            keywords: &["papucs", "strandpapucs", "szandál", "tangapapucs"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ռետինե հողաթափեր"),
            keywords: &[
                "լողափի հողաթափեր",
                "կոշիկներ",
                "ռետինե հողաթափեր",
                "սանդալներ",
                "վիետնամկաներ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("sandal jepit"),
            keywords: &["sandal", "sandal jepit", "sandal pantai", "zōri"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sandali með ól"),
            keywords: &[
                "flipflops",
                "sandalar",
                "sandali með ól",
                "strandsandalar",
                "zori",
                "ól",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("infradito"),
            keywords: &["ciabatte", "infradito", "sandali", "spiaggia"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ビーチサンダル"),
            keywords: &[
                "ゴムぞうり",
                "サンダル",
                "トングサンダル",
                "ビーサン",
                "ビーチサンダル",
                "靴",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sandal japit"),
            keywords: &["japit", "sandal", "sandal gisik", "sandal zori"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("თასმიანი სანდლები"),
            keywords: &[
                "თასმიანი",
                "თასმიანი სანდლები",
                "სანაპიროს სანდლები",
                "სანდალი",
                "ჩუსტი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("вьетнамдық сандал"),
            keywords: &["вьетнамдық", "дзори", "жағажай сандалы", "сандал"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}បែកជើងផ\u{17d2}ទាត\u{17cb}"),
            keywords: &[
                "ស\u{17d2}បែកជើង",
                "ស\u{17d2}បែកជើងផ\u{17d2}ទាត\u{17cb}",
                "ស\u{17d2}បែកជើងសម\u{17d2}រាប\u{17cb}ដើរលើឆ\u{17d2}នេរ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹವಾಯ\u{cbf} ಚಪ\u{ccd}ಪಲ\u{cbf}"),
            keywords: &[
                "ಚಪ\u{ccd}ಪಲ\u{cbf}",
                "ತೊಂಗ\u{ccd}ಸ\u{ccd}",
                "ಬೀಚ\u{ccd} ಚಪ\u{ccd}ಪಲ\u{cbf}",
                "ಹವಾಯ\u{cbf} ಚಪ\u{ccd}ಪಲ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("가락신"),
            keywords: &["가락신", "가죽 끈", "비치 샌들", "샌들", "조리"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("टो\u{902}ग स\u{901}डल"),
            keywords: &[
                "झोरी",
                "टो\u{902}ग स\u{901}डल",
                "टो\u{902}ग\u{94d}स",
                "बीच स\u{902}\u{901}डल",
                "स\u{901}डल",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("сандальдын тилке кайышы"),
            keywords: &["сандальдын тилке кайышы"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເກ\u{eb5}ບແຕະສ\u{eb5}ທອງ"),
            keywords: &[
                "zōri",
                "ທອງ",
                "ເກ\u{eb5}ບແຕະ",
                "ເກ\u{eb5}ບແຕະສ\u{eb5}ທອງ",
                "ເກ\u{eb5}ບແຕະໃສ\u{ec8}ໄປຊາຍຫາດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("sandalai su dirželiu"),
            keywords: &[
                "dirželiai",
                "paplūdimio sandalai",
                "sandalai",
                "sandalai su dirželiu",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("siksniņsandale"),
            keywords: &[
                "pirkstiņsandales",
                "pludmales sandales",
                "sandales",
                "siksniņsandale",
                "siksniņsandales",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("апостолка"),
            keywords: &["апостолка", "апостолки", "папучи", "папучи за плажа"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വള\u{d4d}ളിച\u{d4d}ചെര\u{d41}പ\u{d4d}പ\u{d4d}"),
            keywords: &[
                "ചെര\u{d41}പ\u{d4d}പ\u{d41}കൾ",
                "ജപ\u{d4d}പ\u{d3e}നിലെ ഒര\u{d41}തരം ചെരിപ\u{d4d}പ\u{d4d}",
                "ബീച\u{d4d}ച\u{d4d} ചെര\u{d41}പ\u{d4d}പ\u{d41}കൾ",
                "വള\u{d4d}ളിച\u{d4d}ചെര\u{d41}പ\u{d4d}പ\u{d41}കൾ",
                "വള\u{d4d}ളിച\u{d4d}ചെര\u{d41}പ\u{d4d}പ\u{d4d}",
                "വ\u{d3e}റ\u{d41}കൾ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("углааш"),
            keywords: &["далайн эргийн сандаал", "сандаал", "углааш"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ब\u{902}द असल\u{947}ल\u{947} स\u{945}\u{902}डल"),
            keywords: &[
                "जपानी पद\u{94d}धतीच\u{947} जोड\u{947}",
                "पट\u{94d}ट\u{947}",
                "ब\u{902}द असल\u{947}ल\u{947} स\u{945}\u{902}डल",
                "ब\u{902}द लावल\u{947}ल\u{947} स\u{945}\u{902}डल",
                "सम\u{941}द\u{94d}र किनारी घालावयाच\u{947} स\u{945}\u{902}डल",
                "स\u{945}\u{902}डल\u{94d}स",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("sandal tali kulit"),
            keywords: &[
                "sandal",
                "sandal pantai",
                "sandal tali kulit",
                "tali kulit",
                "zōri",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ည\u{103e}ပ\u{103a}ဖ\u{102d}နပ\u{103a}"),
            keywords: &[
                "ကမ\u{103a}းခြေစ\u{102e}း ဖ\u{102d}နပ\u{103a}",
                "ခြေည\u{103e}ပ\u{103a}ဖ\u{102d}နပ\u{103a}",
                "ည\u{103e}ပ\u{103a}ဖ\u{102d}နပ\u{103a}",
                "ဖ\u{102d}နပ\u{103a}ပါး",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("flippflopp"),
            keywords: &[
                "flipflops",
                "flippflopp",
                "flippflopper",
                "havaianas",
                "sandaler",
                "strandsandaler",
                "zoori",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("थङ स\u{94d}यान\u{94d}डल"),
            keywords: &[
                "जोरी",
                "थङ स\u{94d}यानलहर\u{942}",
                "थङ स\u{94d}यान\u{94d}डल",
                "थङहर\u{942}",
                "सम\u{941}द\u{94d}रतट स\u{94d}यान\u{94d}डलहर\u{942}",
                "स\u{94d}यान\u{94d}डलहर\u{942}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("teenslipper"),
            keywords: &[
                "slipper",
                "strandslipper",
                "teenslipper",
                "teenslof",
                "zori",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("flippflopp"),
            keywords: &[
                "flipflops",
                "flippflopp",
                "flippfloppar",
                "havalanas",
                "sandalar",
                "strandsandalar",
                "zoori",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଚମଡ\u{b3c}\u{b3e} ଫ\u{b3f}ତ\u{b3e} ଥ\u{b3f}ବ\u{b3e} ଚପଲ"),
            keywords: &[
                "ଚପଲ",
                "ଚମଡ\u{b3c}\u{b3e} ଫ\u{b3f}ତ\u{b3e} ଥ\u{b3f}ବ\u{b3e} ଚପଲ",
                "ଜୋର\u{b3f}",
                "ବେଳ\u{b3e}ଭ\u{b42}ମ\u{b3f} ଚପଲ",
                "ସର\u{b41} ଚମଡ\u{b3c}\u{b3e} ଦଉଡ\u{b3c}\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚ\u{a71}ਪਲ"),
            keywords: &[
                "ਚਸਮਾ\u{a02}",
                "ਚ\u{a71}ਪਲ",
                "ਚ\u{a71}ਪਲਾ\u{a02}",
                "ਜਪਾਨੀ ਚ\u{a71}ਪਲਾ\u{a02}",
                "ਬੀਚ ਸ\u{a48}\u{a02}ਡਲ",
                "ਸ\u{a48}\u{a02}ਡਲ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Slípas"),
            keywords: &[
                "Bích Shu",
                "Bích Sándal",
                "Jápán Slípas",
                "Shu",
                "Slípas",
                "Sándal",
                "Wọtasaíd Slípas",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("japonka"),
            keywords: &["japonka", "japonki", "sandały", "sandały na plażę"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("واهه چپلې"),
            keywords: &[
                "beach sandals",
                "د ګورت چپلې",
                "زوري",
                "سينډل",
                "واهه چپلې",
                "ګورت",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("chinelo"),
            keywords: &["alpargatas", "chinelo", "chinelo de praia", "rasteirinha"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["chinelo"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("șlap"),
            keywords: &["papuci de plajă", "sandale", "sandale de plajă", "șlap"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-056"),
            keywords: &["E13-056"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("вьетнамки"),
            keywords: &["вьетнамки", "сланцы", "шлепанцы", "шлепки"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٿونگ سينڊل"),
            keywords: &["بيچ سينڊل", "زوري", "سينڊل", "ٿونگ سينڊل", "ٿونگز"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පට\u{dd2} සෙරෙප\u{dca}ප\u{dd4}ව"),
            keywords: &[
                "පට\u{dd2}",
                "පට\u{dd2} සෙරෙප\u{dca}ප\u{dd4}ව",
                "බ\u{dd3}ච\u{dca} සෙරෙප\u{dca}ප\u{dd4}",
                "සෙරෙප\u{dca}ප\u{dd4}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("žabky"),
            keywords: &["pláž", "sandále", "žabky"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("japonke"),
            keywords: &[
                "japonke",
                "obuvalo za plažo",
                "sandali",
                "sandali za plažo",
                "zōri",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dacas"),
            keywords: &["dacas", "dacaska xeebta", "thongs", "zori"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("sandale me rrip përpara"),
            keywords: &[
                "sandale",
                "sandale me rrip mesi",
                "sandale me rrip përpara",
                "sandale plazhi",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("јапанка"),
            keywords: &["сандале за плажу", "јапанка", "јапанке"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("japanka"),
            keywords: &["japanka", "japanke", "sandale za plažu"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("flip-flops"),
            keywords: &["flip-flops", "remsko", "sandaler"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ndara"),
            keywords: &["kandambili", "ndara", "sapatu", "zori"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("த\u{bbe}ங\u{bcd} செருப\u{bcd}பு"),
            keywords: &[
                "செருப\u{bcd}புகள\u{bcd}",
                "சோரி",
                "த\u{bbe}ங\u{bcd} செருப\u{bcd}பு",
                "த\u{bbe}ங\u{bcd} செருப\u{bcd}புகள\u{bcd}",
                "த\u{bbe}ங\u{bcd}குகள\u{bcd}",
                "ப\u{bc0}ச\u{bcd} செருப\u{bcd}பு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("థ\u{c3e}ంగ\u{c4d} స\u{c3e}ండల\u{c4d}"),
            keywords: &[
                "జ\u{c4b}ర\u{c3f}",
                "థ\u{c3e}ంగ\u{c4d} స\u{c3e}ండల\u{c4d}",
                "థ\u{c3e}ంగ\u{c4d} స\u{c3e}ండల\u{c4d}స\u{c4d}",
                "ధ\u{c3e}ంగ\u{c4d}స\u{c4d}",
                "బ\u{c40}చ\u{c4d} స\u{c3e}ండల\u{c4d}స\u{c4d}",
                "స\u{c3e}ండల\u{c4d}స\u{c4d}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รองเท\u{e49}าลำลอง"),
            keywords: &[
                "รองเท\u{e49}าลำลอง",
                "รองเท\u{e49}าแตะ",
                "รองเท\u{e49}าแตะแบบหน\u{e35}บ",
                "โซร\u{e34}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("şypbyk"),
            keywords: &["kenar şypbygy", "sandal", "zori", "şypbyk"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("saniteli"),
            keywords: &["saniteli"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("parmak arası terlik"),
            keywords: &[
                "deniz terliği",
                "kumsal terliği",
                "parmak arası",
                "parmak arası terlik",
                "sandalet",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("в’єтнамки"),
            keywords: &[
                "в’єтнамки",
                "дзорі",
                "пляжні сандалі",
                "сандалі",
                "шльопанці",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("تھونگ سینڈل"),
            keywords: &[
                "تھونگ سینڈل",
                "تھونگ سینڈلز",
                "تھونگز",
                "زوری",
                "ساحلی سینڈلز",
                "سینڈلز",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tasmali sandal"),
            keywords: &[
                "plyaj shippagi",
                "sandal",
                "shippak",
                "tasma",
                "tasmali sandal",
                "zori",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("dép xỏ ngón"),
            keywords: &["dép", "dép lê", "dép xỏ ngón", "dép đi biển", "zōri"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("人字拖鞋"),
            keywords: &["人字拖鞋", "木屐", "沙灘拖鞋", "涼鞋"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("人字拖鞋"),
            keywords: &["人字拖鞋", "凉鞋", "木屐", "沙滩拖鞋"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("夹趾凉鞋"),
            keywords: &["凉鞋", "夹趾凉鞋", "沙滩凉鞋", "草屡"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("人字拖"),
            keywords: &["人字拖", "拖鞋", "沙灘涼鞋", "海灘鞋", "草鞋"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isicathulo esingena kubhozo"),
            keywords: &[
                "Izicathulo ze-thong",
                "ama-thongs",
                "isicathulo esingena kubhozo",
                "izicathulo",
                "izicathulo zasebhishi",
                "zōri",
            ],
        },
    ],
};
#[doc = "👞"]
pub const MANS_SHOE: crate::Emoji = crate::Emoji {
    glyph: "👞",
    codepoint: "1F45E",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "man’s shoe",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("manskoen"),
            keywords: &["klere", "man", "manskoen", "skoen"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የወንድ ጫማ"),
            keywords: &["አልባሳት", "ወንድ", "የወንድ ጫማ", "ጫማ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("حذاء رجالي"),
            keywords: &["حذاء", "حذاء رجالي", "ملابس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9c1}ৰ\u{9c1}ষৰ জোত\u{9be}"),
            keywords: &[
                "জোত\u{9be}",
                "প\u{9c1}ৰ\u{9c1}ষ",
                "প\u{9c1}ৰ\u{9c1}ষৰ জোত\u{9be}",
                "পোছ\u{9be}ক",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kişi ayaqqabısı"),
            keywords: &["ayaqqabı", "geyim", "kişi", "kişi ayaqqabısı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мужчынскі туфель"),
            keywords: &["абутак", "мужчына", "мужчынскі туфель", "туфель"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Мъжка обувка"),
            keywords: &["Мъжка обувка", "мъж", "облекло", "обувка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9c1}র\u{9c1}ষের জ\u{9c1}তো"),
            keywords: &[
                "জ\u{9c1}তো",
                "প\u{9c1}র\u{9c1}ষ",
                "প\u{9c1}র\u{9c1}ষের জ\u{9c1}তো",
                "পোশ\u{9be}ক",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("muška cipela"),
            keywords: &["cipela", "muška cipela", "muškarac", "obuća"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("sabata d’home"),
            keywords: &["calçat", "home", "sabata", "sabata d’home"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᎦᏯ ᎤᎳᎱᎶᎢ"),
            keywords: &["ᎠᎳᏑᎶ", "ᎠᏍᎦᏯ", "ᎠᏍᎦᏯ ᎤᎳᎱᎶᎢ", "ᏗᎿᏬᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("pánská bota"),
            keywords: &["bota", "muž", "oblečení", "pánská bota"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("esgid dyn"),
            keywords: &["dillad", "dyn", "esgid"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("herresko"),
            keywords: &["herresko", "sko"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Herrenschuh"),
            keywords: &["Herren", "Herrenschuh", "Schuh"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ανδρικό παπούτσι"),
            keywords: &["άνδρας", "ανδρικό παπούτσι", "παπούτσι", "ρουχισμός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("man’s shoe"),
            keywords: &["clothing", "man", "man’s shoe", "shoe"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("zapato de hombre"),
            keywords: &["calzado", "hombre", "ropa", "zapato", "zapato de hombre"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["hombre", "ropa", "vestimenta", "zapato", "zapato de hombre"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("meesteking"),
            keywords: &["king", "mees", "meesteking", "riided"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gizonentzako oinetakoa"),
            keywords: &["arropa", "gizon", "gizonentzako oinetakoa", "oinetako"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کفش مردانه"),
            keywords: &["مردانه", "پوشاک", "کفش"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("miehen kenkä"),
            keywords: &["kenkä", "miehen kenkä", "mies", "vaatteet"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("sapatos na panlalaki"),
            keywords: &["kasuotan", "panlalaki", "sapatos", "sapatos na panlalaki"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("mannfólkaskógvur"),
            keywords: &["klæði", "mannfólk", "mannfólkaskógvur", "skógvur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("chaussure d’homme"),
            keywords: &["chaussure", "chaussure d’homme", "homme", "vêtements"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "chaussure",
                "chaussure d’homme",
                "homme",
                "soulier",
                "vêtements",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bróg fir"),
            keywords: &["bróg", "bróg fir"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bròg fir"),
            keywords: &["aodach", "bròg", "bròg fir", "duine", "fireannach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("zapato de home"),
            keywords: &["home", "zapato", "zapato de home"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{ac1}ર\u{ac1}ષના જ\u{ac2}તા"),
            keywords: &[
                "કપડા\u{a82}",
                "જ\u{ac2}તા",
                "પ\u{ac1}ર\u{ac1}ષના જ\u{ac2}તા",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("takalmin maza"),
            keywords: &["mutum", "sutura", "takalmi", "takalmin maza"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("נעל של גבר"),
            keywords: &["גבר", "נעל", "נעל של גבר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{941}र\u{941}षो\u{902} का ज\u{942}ता"),
            keywords: &[
                "ज\u{942}त\u{947}",
                "प\u{941}र\u{941}षो\u{902} का ज\u{942}ता",
                "प\u{941}र\u{941}षो\u{902} क\u{947} ज\u{942}त\u{947}",
                "पोषाक",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("muška cipela"),
            keywords: &["cipela", "muška cipela", "muškarci", "obuća"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("férfi cipő"),
            keywords: &["cipő", "férfi", "ruha", "ruházat"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տղամարդու կոշիկ"),
            keywords: &["կոշիկ", "հագուստ", "տղամարդ", "տղամարդու կոշիկ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("sepatu pria"),
            keywords: &["pakaian", "pria", "sepatu"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akpụkpọụkwụ nwoke"),
            keywords: &["akpụkpọụkwụ", "na-eme akwà", "nwoke"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("herraskór"),
            keywords: &["herraskór", "karl", "klæðnaður", "skór"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("scarpa da uomo"),
            keywords: &["abbigliamento", "scarpa", "scarpa da uomo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("紳士靴"),
            keywords: &["ローファー", "紳士靴", "革靴", "靴"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sepatu lanang"),
            keywords: &["lanang", "sandhangan", "sepatu lanang"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კაცის ფეხსაცმელი"),
            keywords: &["კაცი", "კაცის ფეხსაცმელი", "ტანსაცმელი", "ფეხსაცმელი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("туфли"),
            keywords: &["ер", "киім", "туфли"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("herresko"),
            keywords: &["herresko", "sko"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}បែកជើងប\u{17bb}រស"),
            keywords: &[
                "ស\u{17d2}បែកជើង",
                "ស\u{17d2}បែកជើងឃ\u{17d2}វា",
                "ស\u{17d2}បែកជើងប\u{17bb}រស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪುರುುಷರ ಶ\u{cc2}"),
            keywords: &["ಪುರುಷರ ಶ\u{cc2}", "ಪುರುುಷರ ಶ\u{cc2}", "ಶ\u{cc2}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("남성용 구두"),
            keywords: &["구두", "남성용 구두", "남성용 신발", "신발"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दादल\u{94d}याच\u{947} जोत\u{947}\u{902}"),
            keywords: &[
                "कपड\u{947}",
                "जोत\u{947}\u{902}",
                "दादलो",
                "दादल\u{94d}याच\u{947} जोत\u{947}\u{902}",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("эркектер бут кийими"),
            keywords: &["бут кийим", "кийим", "эркек", "эркектер бут кийими"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Männerschong"),
            keywords: &["Kleedung", "Mann", "Männerschong", "Schong"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເກ\u{eb5}ບຜ\u{eb9}\u{ec9}ຊາຍ"),
            keywords: &["ເກ\u{eb5}ບ", "ເກ\u{eb5}ບຜ\u{eb9}\u{ec9}ຊາຍ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vyriškas batas"),
            keywords: &["batas", "drabužiai", "vyras", "vyriškas batas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vīriešu kurpe"),
            keywords: &["apavi", "vīriešu", "vīriešu kurpe"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("hū tāne"),
            keywords: &["hū", "kākahu", "tāne"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("машки чевел"),
            keywords: &["маж", "машки чевел", "обувки", "чевли"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d41}ര\u{d41}ഷന\u{d4d}മ\u{d3e}ര\u{d41}ടെ ഷ\u{d42}"),
            keywords: &[
                "പ\u{d41}ര\u{d41}ഷന\u{d4d}മ\u{d3e}ര\u{d41}ടെ ഷ\u{d42}",
                "വസ\u{d4d}ത\u{d4d}രം",
                "ഷ\u{d42}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эрэгтэй гутал"),
            keywords: &["гутал", "хувцас", "эрэгтэй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{941}र\u{942}षा\u{902}च\u{947} जोड\u{947}"),
            keywords: &[
                "कपड\u{947}",
                "जोड\u{947}",
                "प\u{941}र\u{942}ष",
                "प\u{941}र\u{942}षा\u{902}च\u{947} जोड\u{947}",
                "प\u{941}र\u{942}षाच\u{947} जोड\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kasut lelaki"),
            keywords: &["kasut", "lelaki", "pakaian"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("żarbun tal-irġiel"),
            keywords: &["raġel", "ħwejjeġ", "żarbun", "żarbun tal-irġiel"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမျ\u{102d}\u{102f}းသား ဖ\u{102d}နပ\u{103a}"),
            keywords: &[
                "ရ\u{103e}\u{1030}းဖ\u{102d}နပ\u{103a}",
                "အမျ\u{102d}\u{102f}းသား",
                "အမျ\u{102d}\u{102f}းသား ဖ\u{102d}နပ\u{103a}",
                "အမျ\u{102d}\u{102f}းသားစ\u{102e}း ရ\u{103e}\u{1030}းဖ\u{102d}နပ\u{103a}",
                "အဝတ\u{103a}အစား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("herresko"),
            keywords: &["herresko", "klær", "sko"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{941}र\u{941}षको ज\u{941}त\u{94d}ता"),
            keywords: &["कपडा", "ज\u{941}त\u{94d}ता", "प\u{941}र\u{941}षको"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("herenschoen"),
            keywords: &["herenschoen", "kleding", "man", "schoen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("herresko"),
            keywords: &["herresko", "klede", "sko"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b41}ର\u{b41}ଷଙ\u{b4d}କ ଜୋତ\u{b3e}"),
            keywords: &[
                "ଜୋତ\u{b3e}",
                "ପ\u{b41}ର\u{b41}ଷଙ\u{b4d}କ ଜୋତ\u{b3e}",
                "ପୋଷ\u{b3e}କ ପର\u{b3f}ଚ\u{b4d}ଛଦ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਆਦਮੀ ਦਾ ਬ\u{a42}ਟ"),
            keywords: &[
                "ਆਦਮੀ ਦਾ ਬ\u{a42}ਟ",
                "ਆਦਮੀ ਲਈ ਬ\u{a42}ਟ",
                "ਬ\u{a42}ਟ",
                "ਲਿਬਾਸ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مردانہ جوتی"),
            keywords: &["بندہ", "جوتا", "مردانہ جوتی", "کپڑے"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mán Shu"),
            keywords: &["Klọt", "Man", "Mán Shu", "Shu"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("but męski"),
            keywords: &["but", "męski"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("نارینه بوټان"),
            keywords: &["بوټان", "لباس", "نارینه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("sapato masculino"),
            keywords: &["acessório", "sapato masculino", "sapatos"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("sapato de homem"),
            keywords: &["calçado", "calçado masculino", "homem", "sapato de homem"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("runap phapatun"),
            keywords: &["runap phapatun"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pantof bărbătesc"),
            keywords: &["bărbat", "masculin", "pantof bărbătesc", "încălțăminte"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-539"),
            keywords: &["E10-539"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("ботинок"),
            keywords: &["ботинки", "ботинок", "мужчина", "обувь", "туфли"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("urukweto rw’abagabo"),
            keywords: &["imyambaro", "umugabo", "urukweto", "urukweto rw’abagabo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مرد جو جوتو"),
            keywords: &["جوتو", "لباس", "مرد", "مرد جو جوتو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd2}ර\u{dd2}ම\u{dd2}\u{dd2} සපත\u{dca}ත\u{dd4}ව"),
            keywords: &[
                "ඇඳ\u{dd4}ම\u{dca}",
                "ප\u{dd2}ර\u{dd2}ම\u{dd2}ය\u{dcf}",
                "ප\u{dd2}ර\u{dd2}ම\u{dd2}\u{dd2} සපත\u{dca}ත\u{dd4}ව",
                "සපත\u{dca}ත\u{dd4}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("pánska topánka"),
            keywords: &["muž", "oblečenie", "pánska topánka", "topánka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("moški čevelj"),
            keywords: &["moški", "oblačila", "čevelj"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kabo rag"),
            keywords: &["dhar", "kabo", "kabo rag", "nin"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("këpucë burrash"),
            keywords: &["burrë", "këpucë", "këpucë burrash", "veshje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мушка ципела"),
            keywords: &["мушка ципела", "мушкарац", "одећа", "ципела"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["мушка ципела"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("muška cipela"),
            keywords: &["cipela", "muška cipela", "muškarac", "odeća"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["muška cipela"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("herrsko"),
            keywords: &["herrsko", "sko", "skor"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kiatu cha wanaume"),
            keywords: &["kiatu", "kiatu cha wanaume", "mavazi", "mwanamume"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆண\u{bcd}களுக\u{bcd}க\u{bbe}ன ஷூ"),
            keywords: &[
                "ஆடை அணிகலன\u{bcd}",
                "ஆண\u{bcd}களுக\u{bcd}க\u{bbe}ன ஷூ",
                "ஆண\u{bcd}கள\u{bcd}",
                "ஷூ",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మగవ\u{c3e}ళ\u{c4d}ల బూట\u{c4d}లు"),
            keywords: &["పురుషుడు", "మగవ\u{c3e}ళ\u{c4d}ల బూట\u{c4d}లు", "షూ"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("пойафзоли мардона"),
            keywords: &["либос", "мард", "пойафзол", "пойафзоли мардона"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รองเท\u{e49}าชาย"),
            keywords: &[
                "ผ\u{e39}\u{e49}ชาย",
                "รองเท\u{e49}า",
                "รองเท\u{e49}าชาย",
                "รองเท\u{e49}าผ\u{e39}\u{e49}ชาย",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("erkek aýakgaby"),
            keywords: &["erkek", "erkek aýakgaby", "eşik", "köwüş"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sū fakatangata"),
            keywords: &["sū fakatangata"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("erkek ayakkabısı"),
            keywords: &["ayakkabı", "erkek ayakkabısı", "giyim"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئەرەنچە ئاياغ"),
            keywords: &["ئاياغ", "ئەر", "ئەرەنچە ئاياغ", "كىيىم"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("чоловіча туфля"),
            keywords: &["взуття", "одяг", "чоловік", "чоловіча туфля"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مرد کا جوتا"),
            keywords: &["آدمی", "جوتا", "لباس", "مرد کا جوتا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("erkaklar tuflisi"),
            keywords: &["erkak", "erkaklar tuflisi", "kiyim", "tufli"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("giày nam"),
            keywords: &["giày", "giày nam", "quần áo", "đàn ông"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("dàllu góor"),
            keywords: &["dàll", "dàllu góor", "góor", "yéere"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isihlangu sendoda"),
            keywords: &["impahla", "indoda", "isihlangu", "isihlangu sendoda"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bata Ọkunrin"),
            keywords: &["Bata Ọkunrin", "aṣọ", "bàtà", "ọkùnrin"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("男裝鞋"),
            keywords: &["服裝", "男士", "男裝鞋", "鞋"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("男装鞋"),
            keywords: &["服装", "男士", "男装鞋", "鞋"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("男鞋"),
            keywords: &["男鞋", "鞋"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("皮鞋"),
            keywords: &["皮鞋", "鞋"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("izicathulo zamadoda"),
            keywords: &[
                "impahla yukugqoka",
                "indoda",
                "isicathulo",
                "izicathulo zamadoda",
            ],
        },
    ],
};
#[doc = "👟"]
pub const RUNNING_SHOE: crate::Emoji = crate::Emoji {
    glyph: "👟",
    codepoint: "1F45F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "running shoe",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("hardloopskoen"),
            keywords: &["atletiek", "draf", "hardloopskoen", "klere", "skoen"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሩጫ ጫማ"),
            keywords: &["አልባሳት", "አትሌታዊ", "የሩጫ ጫማ", "ጫማ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("حذاء رياضي"),
            keywords: &["حذاء", "حذاء رياضي", "ملابس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ৰ\u{9be}ণিং শ\u{9cd}ব\u{9c1}"),
            keywords: &[
                "এথলেটিক",
                "জোত\u{9be}",
                "পোছ\u{9be}ক",
                "স\u{9cd}নিক\u{9be}ৰ",
                "ৰ\u{9be}ণিং শ\u{9cd}ব\u{9c1}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qaçış ayaqqabısı"),
            keywords: &[
                "atletik",
                "ayaqqabı",
                "geyim",
                "krossovka",
                "qaçış ayaqqabısı",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("красовак"),
            keywords: &["абутак", "бег", "красовак", "спорт"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Спортна обувка"),
            keywords: &[
                "Спортна обувка",
                "маратонка",
                "облекло",
                "обувка",
                "спортна",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("দৌড\u{9bc}\u{9be}নোর জ\u{9c1}তো"),
            keywords: &[
                "ক\u{9cd}রীড\u{9bc}\u{9be}বিষয\u{9bc}ক",
                "জ\u{9c1}তো",
                "দৌড\u{9bc}\u{9be}নোর জ\u{9c1}তো",
                "পোশ\u{9be}ক",
                "স\u{9cd}নীক\u{9be}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("botez sport"),
            keywords: &["botez", "botez sport"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("patika"),
            keywords: &["atletika", "obuća", "patika"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("sabatilla de córrer"),
            keywords: &["calçat", "córrer", "sabatilla", "sabatilla de córrer"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏟᏓᏍᏗ ᎠᎳᏑᎶᎯ"),
            keywords: &["ᎠᎳᏑᎶ", "ᎠᏟᏓᏍᏗ ᎠᎳᏑᎶᎯ", "ᏁᏦᏗ", "ᏗᎿᏬ", "ᏗᏁᎶᎲᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("běžecká bota"),
            keywords: &[
                "atletika",
                "bota",
                "běžecká bota",
                "oblečení",
                "sport",
                "teniska",
                "tretra",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("esgidiau rhedeg"),
            keywords: &["athletig", "dillad", "esgid", "esgidiau rhedeg", "rhedeg"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("løbesko"),
            keywords: &["fritidssko", "løbesko", "sko", "tennissko"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Sportschuh"),
            keywords: &["Schuh", "Sneaker", "Sportschuh", "sportlich"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αθλητικό παπούτσι"),
            keywords: &["αθλητικά", "αθλητικό παπούτσι", "παπούτσι", "ρουχισμός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("running shoe"),
            keywords: &["athletic", "clothing", "running shoe", "shoe", "sneaker"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["athletic", "clothing", "shoe", "trainer"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("sneaker"),
            keywords: &[
                "athletic",
                "clothing",
                "runners",
                "running shoe",
                "shoe",
                "sneaker",
                "trainer",
            ],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("zapatilla deportiva"),
            keywords: &["calzado", "correr", "ropa", "tenis", "zapatilla deportiva"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("zapato deportivo"),
            keywords: &[
                "deporte",
                "ropa deportiva",
                "vestimenta",
                "zapato deportivo",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("tenis"),
            keywords: &["ropa", "tenis", "vestimenta", "zapato deportivo"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("jooksuking"),
            keywords: &["jooksuking", "king", "riided", "sport", "toss"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("korrika egiteko oinetakoa"),
            keywords: &["arropa", "kirol", "korrika egiteko oinetakoa", "oinetako"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کفش دویدن"),
            keywords: &["اسنیکر", "ورزشی", "پوشاک", "کفش", "کفش دویدن"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("juoksukenkä"),
            keywords: &["juoksukenkä", "kenkä", "lenkkarit", "urheilu", "vaatteet"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("running shoes"),
            keywords: &[
                "kasuotan",
                "pang-atleta",
                "rubber shoes",
                "running shoes",
                "sapatos",
                "sneakers",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("renniskógvur"),
            keywords: &[
                "klæði",
                "renniskógvur",
                "skógvur",
                "tennisskógvur",
                "ítrótt",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("chaussure de sport"),
            keywords: &["chaussure", "chaussure de sport", "vêtements"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "chaussure",
                "chaussure de sport",
                "course",
                "espadrille",
                "sport",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bróg reatha"),
            keywords: &["bróg", "bróg reatha"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bròg-ruith"),
            keywords: &[
                "aodach",
                "bròg",
                "bròg-ruith",
                "bròg-thrèanaidh",
                "lùth-chleasachd",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("zapatilla deportiva"),
            keywords: &[
                "calzado",
                "correr",
                "deporte",
                "zapatilla",
                "zapatilla deportiva",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ખ\u{ac7}લક\u{ac2}દ માટ\u{ac7}ના\u{a82} જ\u{ac2}તા"),
            keywords: &[
                "કપડા\u{a82}",
                "ખ\u{ac7}લક\u{ac2}દ માટ\u{ac7}ના\u{a82} જ\u{ac2}તા",
                "જ\u{ac2}તા",
                "સ\u{acd}નીકર",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("takalmin gudu"),
            keywords: &[
                "kambas",
                "sutura",
                "takalmi",
                "takalmin gudu",
                "wasan guje-guje",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("נעל ריצה"),
            keywords: &["נעל", "ספורט", "ריצה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("एथल\u{947}टिक ज\u{942}ता"),
            keywords: &[
                "एथल\u{947}टिक ज\u{942}ता",
                "एथल\u{947}टिक ज\u{942}त\u{947}",
                "ज\u{942}त\u{947}",
                "पोषाक",
                "स\u{94d}नीकर",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tenisica"),
            keywords: &["cipela", "obuća", "sport", "tenisica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("futócipő"),
            keywords: &[
                "atlétika",
                "cipő",
                "edzőcipő",
                "futás",
                "futócipő",
                "tornacipő",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սպորտային կոշիկ"),
            keywords: &["կեդեր", "կոշիկ", "հագուստ", "մարզական", "սպորտային կոշիկ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("sepatu lari"),
            keywords: &["atletik", "kets", "pakaian", "sepatu", "sepatu lari"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akpụkpọụkwụ eji àgba ọsọ"),
            keywords: &[
                "akpụkpọụkwụ",
                "akpụkpọụkwụ eji àgba ọsọ",
                "akpụkpọụkwụ ndị mfe",
                "mgbaọsọ",
                "na-eme akwà",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("íþróttaskór"),
            keywords: &["klæðnaður", "skór", "strigaskór", "íþróttaskór"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("scarpa sportiva"),
            keywords: &["abbigliamento", "scarpa", "scarpa sportiva", "sneaker"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("スニーカー"),
            keywords: &["スニーカー", "靴"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sepatu mlayu"),
            keywords: &["atletik", "kets", "sandhangan", "sepatu", "sepatu mlayu"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბოტასი"),
            keywords: &["ბოტასი", "სპორტული", "ტანსაცმელი", "ფეხსაცმელი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("кроссовка"),
            keywords: &["атлетикалық", "киім", "кроссовка", "туфли"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("gummisko"),
            keywords: &["fritidssko", "gummisko", "sko", "tennissko"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}បែងជើងរត\u{17cb}ក\u{17b8}ឡា"),
            keywords: &[
                "ស\u{17d2}បែកជើងក\u{17b8}ឡា",
                "ស\u{17d2}បែងជើងរត\u{17cb}ក\u{17b8}ឡា",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಓಟದ ಶ\u{cc2}"),
            keywords: &[
                "ಅಥ\u{ccd}ಲೇಟ\u{cbf}ಕ\u{ccd} ಶ\u{cc2}",
                "ಓಟದ ಶ\u{cc2}",
                "ಸ\u{ccd}ನೀಕರ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("운동화"),
            keywords: &["스니커즈", "신발", "운동화"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("धा\u{902}वपाच\u{947} श\u{942}ज"),
            keywords: &[
                "एथल\u{947}टिक",
                "कपड\u{947}",
                "जोत\u{947}\u{902}",
                "धा\u{902}वपाच\u{947} श\u{942}ज",
                "स\u{94d}निकर",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("спорттук бут кийим"),
            keywords: &["бут кийим", "кийим", "спорттук бут кийим", "спортчу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Lafschong"),
            keywords: &["Kleedung", "Lafschong", "Schong", "Sport", "Turnschlappen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເກ\u{eb5}ບສຳລ\u{eb1}ບແລ\u{ec8}ນ"),
            keywords: &[
                "ກ\u{eb4}ລາ",
                "ເກ\u{eb5}ບ",
                "ເກ\u{eb5}ບສຳລ\u{eb1}ບແລ\u{ec8}ນ",
                "ເສ\u{eb7}\u{ec9}ອຜ\u{ec9}າ",
                "ແລ\u{ec8}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("bėgimo batelis"),
            keywords: &[
                "atletiškas",
                "batas",
                "bėgimo batelis",
                "drabužiai",
                "sportinis batelis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("skriešanas apavi"),
            keywords: &["apavi", "skriešanas apavi", "skriešanas kurpe", "sports"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("hū omaama"),
            keywords: &["hū", "hū ngohengohe", "hū omaama", "kākahu", "whakataetae"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("патика"),
            keywords: &["обувки", "патика", "патики", "спорт", "чевли"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("അത\u{d4d}\u{200c}ലറ\u{d4d}റിക\u{d4d} ഷ\u{d42}"),
            keywords: &[
                "അത\u{d4d}\u{200c}ലറ\u{d4d}റിക\u{d4d} ഷ\u{d42}",
                "അത\u{d4d}\u{200c}ലെറ\u{d4d}റിക\u{d4d}",
                "വസ\u{d4d}\u{200c}ത\u{d4d}രം",
                "ഷ\u{d42}",
                "സ\u{d4d}\u{200c}നീക\u{d4d}കർ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("пүүз"),
            keywords: &["гутал", "гүйлт", "пүүз"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("धावताना घालायच\u{947} जोड\u{947}"),
            keywords: &[
                "अ\u{945}थल\u{947}टिक",
                "कपड\u{947}",
                "जोड\u{947}",
                "धावताना घालायच\u{947} जोड\u{947}",
                "स\u{94d}नीकर",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kasut lari"),
            keywords: &["kasut", "kasut lari", "olahraga", "pakaian", "sneaker"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("papoċċ tal-ġiri"),
            keywords: &[
                "atletika",
                "papoċċ tal-ġiri",
                "sneaker",
                "ħwejjeġ",
                "żarbun",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အပြေး ဖ\u{102d}နပ\u{103a}"),
            keywords: &[
                "ပတ\u{1039}တ\u{1030}ဖ\u{102d}နပ\u{103a}",
                "အပြေး ဖ\u{102d}နပ\u{103a}",
                "အပြေးသမားစ\u{102e}း ဖ\u{102d}နပ\u{103a}",
                "အဝတ\u{103a}အစား",
                "အားကစား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("joggesko"),
            keywords: &["fritidssko", "joggesko", "klær", "sko", "tennissko"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("दौडदा लगाउन\u{947} ज\u{941}त\u{94d}ता"),
            keywords: &[
                "ख\u{947}लक\u{941}द सम\u{94d}बन\u{94d}धी",
                "ज\u{941}त\u{94d}ता",
                "दौडदा लगाउन\u{947} ज\u{941}त\u{94d}ता",
                "ल\u{941}गा लवाइ",
                "स\u{94d}निकर",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("sportschoen"),
            keywords: &["atletiek", "kleding", "schoen", "sneaker", "sportschoen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("joggesko"),
            keywords: &["fritidssko", "joggesko", "klede", "sko", "tennissko"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଦୌଡ\u{b3c}\u{b3f}ବ\u{b3e} ଜୋତ\u{b3e}"),
            keywords: &[
                "ଜୋତ\u{b3e}",
                "ଦୌଡ\u{b3c}କ\u{b41}ଦ ସମ\u{b4d}ବନ\u{b4d}ଧ\u{b3f}ତ ଜୋତ\u{b3e}",
                "ଦୌଡ\u{b3c}\u{b3f}ବ\u{b3e} ଜୋତ\u{b3e}",
                "ନରମ ତଳ ଥ\u{b3f}ବ\u{b3e} ଜୋତ\u{b3e}",
                "ପୋଷ\u{b3e}କ ପର\u{b3f}ଚ\u{b4d}ଛଦ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਦ\u{a4c}ੜਨ ਵਾਲ\u{a47} ਬ\u{a42}ਟ"),
            keywords: &[
                "ਅਥਲ\u{a48}ਟਿਕ ਬ\u{a42}ਟ",
                "ਦ\u{a4c}ੜਨ ਵਾਲ\u{a47} ਬ\u{a42}ਟ",
                "ਲਿਬਾਸ",
                "ਸਨੀਕਰ ਬ\u{a42}ਟ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("نٹھن آلی جوتی"),
            keywords: &["جوتا", "سینکر", "نٹھن آلی جوتی", "چ\u{64f}ست", "کپڑے"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Shu Fọ Rọ\u{301}nin"),
            keywords: &[
                "Klọt",
                "Shu",
                "Shu Fọ Rọ\u{301}nin",
                "Sníkas",
                "Átlẹ\u{301}tics",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("but do biegania"),
            keywords: &["bieganie", "but", "but do biegania", "sport", "trampek"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د منډي بوټان"),
            keywords: &["بوټان", "د منډي بوټان", "لباس", "نخی بوټان", "ورزشي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("tênis de corrida"),
            keywords: &["sapato esportivo", "tênis", "tênis de corrida"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("sapatilha"),
            keywords: &["calçado", "desporto", "sapatilha", "ténis", "vestuário"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("phawasqa phapatu"),
            keywords: &["phawasqa phapatu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pantof sport"),
            keywords: &[
                "alergare",
                "atletism",
                "pantof sport",
                "sport",
                "încălțăminte",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-540"),
            keywords: &["E10-540"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("кроссовки"),
            keywords: &["бег", "кеды", "кроссовки", "обувь", "спорт"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("urukweto rwo kwirukankana"),
            keywords: &[
                "inkweto za siporo",
                "umukinnyi",
                "umwambaro",
                "urukweto",
                "urukweto rwo kwirukankana",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڊوڙڻ وارو جوتو"),
            keywords: &["ايٿليٽڪ", "جوتو", "راند جو جوتو", "لباس", "ڊوڙڻ وارو جوتو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ද\u{dd2}ව\u{dd3}මේ සපත\u{dca}ත\u{dd4}ව"),
            keywords: &[
                "ඇඳ\u{dd4}ම\u{dca}",
                "කැන\u{dca}වස\u{dca} ප\u{dcf}වහන\u{dca}",
                "ද\u{dd2}ව\u{dd3}මේ සපත\u{dca}ත\u{dd4}ව",
                "මලල ක\u{dca}\u{200d}ර\u{dd3}ඩ\u{dcf}",
                "සපත\u{dca}ත\u{dd4}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("bežecká topánka"),
            keywords: &[
                "bežecká topánka",
                "oblečenie",
                "teniska",
                "topánka",
                "športové",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("tekaški čevelj"),
            keywords: &["oblačila", "superga", "tekaški čevelj", "čevelj", "športno"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kabo orod"),
            keywords: &["ciyaartoy", "dhar", "isniikar", "kabo", "kabo orod"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("atlete"),
            keywords: &["atlete", "atletike", "këpucë", "veshje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("патика"),
            keywords: &["атлетски", "одећа", "патика", "патике за трчање", "ципела"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["патика"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("patika"),
            keywords: &["atletski", "cipela", "odeća", "patika", "patike za trčanje"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["patika"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("gympasko"),
            keywords: &["gympasko", "sko", "sneaker"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kiatu cha kukimbia"),
            keywords: &[
                "kiatu",
                "kiatu cha kukimbia",
                "mavazi",
                "mbio",
                "raba ya kukimbia",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("தடகள வ\u{bc0}ரர\u{bcd}களுக\u{bcd}க\u{bbe}ன ஷூ"),
            keywords: &[
                "ஆடை அணிகலன\u{bcd}",
                "தடகள வ\u{bc0}ரர\u{bcd}களுக\u{bcd}க\u{bbe}ன ஷூ",
                "மிருதுவ\u{bbe}ன ஷூ",
                "ஷூ",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c4d}ర\u{c40}డ\u{c3e}క\u{c3e}రుల బూట\u{c4d}లు"),
            keywords: &[
                "క\u{c4d}ర\u{c40}డ\u{c3e}",
                "క\u{c4d}ర\u{c40}డ\u{c3e}క\u{c3e}రుల బూట\u{c4d}లు",
                "షూ",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("пойафзол барои давидан"),
            keywords: &[
                "варзишӣ",
                "либос",
                "пойафзол",
                "пойафзол барои давидан",
                "пойафзоли варзишӣ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รองเท\u{e49}าก\u{e35}ฬา"),
            keywords: &[
                "รองเท\u{e49}า",
                "รองเท\u{e49}าก\u{e35}ฬา",
                "รองเท\u{e49}าผ\u{e49}าใบ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ylgaw aýakgaby"),
            keywords: &["atletika", "eşik", "krossowka", "köwüş", "ylgaw aýakgaby"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sū lele"),
            keywords: &["sū lele"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("koşu ayakkabısı"),
            keywords: &["ayakkabı", "bez ayakkabı", "giyim", "koşu ayakkabısı"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يۈگۈرۈش ئايىغى"),
            keywords: &[
                "ئاياغ",
                "توپ ئايىغى",
                "تەنتەربىيە",
                "كىيىم",
                "يۈگۈرۈش ئايىغى",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кросівка"),
            keywords: &["взуття", "кросівка", "кросівок", "одяг", "спортивний"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("دوڑنے والا جوتا"),
            keywords: &["جوتے", "دوڑنے والا جوتا", "لباس"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("krossovka"),
            keywords: &["atletika", "kiyim", "krossovka", "tufli"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("giày chạy"),
            keywords: &[
                "giày",
                "giày chạy",
                "giày chạy bộ",
                "giày đế mềm",
                "quần áo",
                "thể thao",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("dàllu daw"),
            keywords: &["atletik", "dàll", "dàllu daw", "sneaker", "yéere"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isihlangu sokubaleka"),
            keywords: &[
                "imbaleki",
                "impahla",
                "isihlangu",
                "isihlangu sokubaleka",
                "iteki",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bata Isare"),
            keywords: &["Bata Isare", "aṣọ", "bàtà", "ẹní sáré"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("跑鞋"),
            keywords: &["服裝", "跑鞋", "運動", "運動鞋", "鞋"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("跑鞋"),
            keywords: &["服装", "跑鞋", "运动", "运动鞋", "鞋"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("跑鞋"),
            keywords: &["跑鞋", "运动鞋", "鞋"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("運動鞋"),
            keywords: &["球鞋", "運動鞋"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("波鞋"),
            keywords: &["波鞋", "運動鞋"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("izicathulo zokugijima"),
            keywords: &[
                "impahla yokugqoka",
                "isicathulo",
                "iteku",
                "izicathulo zokugijima",
                "ukugijima",
            ],
        },
    ],
};
#[doc = "🥾"]
pub const HIKING_BOOT: crate::Emoji = crate::Emoji {
    glyph: "🥾",
    codepoint: "1F97E",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "hiking boot",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("stapskoen"),
            keywords: &["kamp", "rugsakstap", "stap", "stapskoen", "staptog"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የእግር ሽርሽር ጫማ"),
            keywords: &["ካምፕ", "የእግር ሽርሽር", "የእግር ሽርሽር ጫማ", "የጀርባ ቦርሳ", "ጫማ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("حذاء لرحلات المشي"),
            keywords: &["تخييم", "جزمة", "حذاء لرحلات المشي", "مشي لمسافات طويلة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("পৰ\u{9cd}বত\u{9be}ৰোহনত পিন\u{9cd}ধ\u{9be} জোত\u{9be}"),
            keywords: &[
                "পৰ\u{9cd}বত\u{9be}ৰোহন",
                "পৰ\u{9cd}বত\u{9be}ৰোহনত পিন\u{9cd}ধ\u{9be} জোত\u{9be}",
                "ব\u{9c1}ট জোত\u{9be}",
                "বেকপেকিং",
                "শিবিৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("gəzinti botinkası"),
            keywords: &[
                "botinka",
                "gəzinti",
                "gəzinti botinkası",
                "kempinq",
                "əşyaları yığmaq",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("паходны бот"),
            keywords: &["бот", "паход", "паходны бот", "пешы турызм", "турызм"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("туристическа обувка"),
            keywords: &[
                "ботуш",
                "къмпинг",
                "походи",
                "походи с раница",
                "туристическа обувка",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("পর\u{9cd}বত\u{9be}রহণের জ\u{9c1}তো"),
            keywords: &[
                "জ\u{9c1}তো",
                "পর\u{9cd}বত\u{9be}রহণের জ\u{9c1}তো",
                "পর\u{9cd}বত\u{9be}রোহণ",
                "ব\u{9cd}য\u{9be}কপ\u{9cd}য\u{9be}কিং",
                "শিবির",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("botez bale"),
            keywords: &["bale", "botez", "kampiñ"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("gojzerica"),
            keywords: &[
                "gojzerica",
                "kampovanje",
                "pješačenje",
                "planinarenje",
                "čizma",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bota de muntanya"),
            keywords: &[
                "bota",
                "bota de muntanya",
                "càmping",
                "excursionisme",
                "trekking",
                "tresc",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏨᏏᏰᏍᎬ ᎬᏩᎵᏲᏍᏗ"),
            keywords: &["ᎠᎵᏏᏓᏍᏗ ᎦᎵᏔᏅᏙᏗ", "ᎤᏨᏏᏰᏍᎬ", "ᎦᎵᏦᏛᎢ", "ᎬᏩᎵᏲᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("pohorka"),
            keywords: &[
                "kanada",
                "kempování",
                "pohorka",
                "turistika",
                "túra",
                "výšlap",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("esgid gerdded"),
            keywords: &["bacpacio", "cerdded", "esgid", "esgid gerdded", "gwersylla"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("vandrestøvle"),
            keywords: &[
                "backpacking",
                "camping",
                "friluft",
                "støvle",
                "vandre",
                "vandrestøvle",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Wanderstiefel"),
            keywords: &["Camping", "Wandern", "Wanderstiefel", "Wanderung"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μπότα ορειβασίας"),
            keywords: &["κάμπιγκ", "μπότα", "μπότα ορειβασίας", "ορειβασία"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("hiking boot"),
            keywords: &["backpacking", "boot", "camping", "hiking"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bota de senderismo"),
            keywords: &[
                "bota",
                "bota de senderismo",
                "camping",
                "mochilero",
                "senderismo",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("botas de excursión"),
            keywords: &[
                "acampar",
                "bota",
                "botas de excursión",
                "excursión",
                "senderismo",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("matkasaabas"),
            keywords: &[
                "matk",
                "matkaja",
                "matkamine",
                "matkasaabas",
                "saabas",
                "seljakotimatk",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("mendiko bota"),
            keywords: &[
                "bota",
                "kanpin",
                "mendiko bota",
                "motxila",
                "xendazaletasun",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("چکمه راه\u{200c}پیمایی"),
            keywords: &[
                "اردو زدن",
                "راه\u{200c}پیمایی",
                "چکمه",
                "کمپ",
                "کوله\u{200c}گردی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vaelluskenkä"),
            keywords: &[
                "erävaellus",
                "kenkä",
                "patikointi",
                "retkeily",
                "telttailu",
                "vaelluskenkä",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pang-hiking na bota"),
            keywords: &[
                "backpacking",
                "bota",
                "camping",
                "hiking",
                "pang-hiking na bota",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("gangistilvi"),
            keywords: &[
                "fjakka",
                "ganga",
                "gangistilvi",
                "gongutúr",
                "stilvi",
                "tjalding",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("chaussure de randonnée"),
            keywords: &[
                "camping",
                "chaussure",
                "chaussure de marche",
                "chaussure de randonnée",
                "marche",
                "randonnée",
                "vêtements",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("buatais siúlóireachta"),
            keywords: &[
                "buatais",
                "buatais siúlóireachta",
                "campáil",
                "saoire an mhála droma",
                "siúlóireacht",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("botan coiseachd"),
            keywords: &["botan", "campachadh", "coiseachd", "turas poca-droma"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("bota de montaña"),
            keywords: &[
                "Camiño de Santiago",
                "bota de montaña",
                "camiñar",
                "excursionismo",
                "montaña",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("હાઈકી\u{a82}ગ બ\u{ac2}ટ"),
            keywords: &["હાઈકી\u{a82}ગ બ\u{ac2}ટ"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("נעלי הליכה"),
            keywords: &["הליכה", "טיול", "טרק", "מחנאות", "נעלי הליכה", "נעליים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("हाइकि\u{902}ग ब\u{942}ट"),
            keywords: &[
                "क\u{948}\u{902}पि\u{902}ग",
                "ब\u{942}ट",
                "ब\u{948}कप\u{948}कि\u{902}ग",
                "हाइकि\u{902}ग",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("gojzerica"),
            keywords: &[
                "gojzerica",
                "kampiranje",
                "obuća za planinarenje",
                "planinarenje",
                "čizma",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("túrabakancs"),
            keywords: &[
                "bakancs",
                "hátizsákos túra",
                "kemping",
                "túrabakancs",
                "túrázás",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("արշավային կոշիկ"),
            keywords: &["արշավ", "արշավային կոշիկ", "զբոսաշրջություն", "կոշիկ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("sepatu boot untuk mendaki"),
            keywords: &[
                "backpacking",
                "boot",
                "kemping",
                "mendaki",
                "sepatu boot untuk mendaki",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("gönguskór"),
            keywords: &[
                "bakpokaferðalag",
                "fjallganga",
                "gönguskór",
                "tjaldferðalag",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("stivale da trekking"),
            keywords: &[
                "campeggio",
                "stivale",
                "stivale da trekking",
                "trekking",
                "viaggio zaino in spalla",
                "zaino in spalla",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ハイキングシューズ"),
            keywords: &[
                "キャンプ",
                "ハイキング",
                "ハイキングシューズ",
                "ブーツ",
                "登山靴",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sepatu bot hiking"),
            keywords: &[
                "backpacking",
                "bot",
                "hiking",
                "kemping",
                "sepatu bot hiking",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბათინკი"),
            keywords: &["ბათინკი", "კემპინგი", "ლაშქრობა", "მოგზაურობა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("туристік аяқкиім"),
            keywords: &[
                "бәтеңке",
                "жаяу туризм",
                "жүру",
                "лагерьлік",
                "туристік аяқкиім",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}បែកជើងកវែង"),
            keywords: &[
                "ការដើរ",
                "ការធ\u{17d2}វើដណើរកម\u{17d2}សាន\u{17d2}ត\u{200b}ដោយស\u{17d2}ពាយកាប\u{17bc}បនៅក\u{17d2}រោយខ\u{17d2}នង",
                "ការបោះជ\u{17c6}រ\u{17c6}",
                "ស\u{17d2}បែកជើងកវែង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹೈಕ\u{cbf}ಂಗ\u{ccd} ಬ\u{cc2}ಟು"),
            keywords: &[
                "ಕ\u{ccd}ಯಾಂಪ\u{cbf}ಂಗ\u{ccd}",
                "ಬ\u{cc2}ಟ\u{ccd}",
                "ಬ\u{ccd}ಯಾಕ\u{ccd}\u{200c}ಪ\u{ccd}ಯಾಕ\u{cbf}ಂಗ\u{ccd}",
                "ಹೈಕ\u{cbf}ಂಗ\u{ccd}",
                "ಹೈಕ\u{cbf}ಂಗ\u{ccd} ಬ\u{cc2}ಟು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("등산화"),
            keywords: &["등산", "등산화", "부츠", "캠핑", "하이킹"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("हायकी\u{902}ग ब\u{942}ट"),
            keywords: &[
                "ब\u{942}ट",
                "ब\u{945}कप\u{945}कि\u{902}ग",
                "शिबीर",
                "हायकी\u{902}ग",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ботинка"),
            keywords: &["ботинка", "жон баштык", "кемпинг", "саякаттоо"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເກ\u{eb5}ບບ\u{ebb}ດ"),
            keywords: &[
                "ກະເປ\u{ebb}\u{ec9}າເປ\u{ec9}",
                "ເກ\u{eb5}ບບ\u{eb8}ດ",
                "ເກ\u{eb5}ບບ\u{ebb}ດ",
                "ເດ\u{eb5}ນປ\u{ec8}າ",
                "ແຄມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žygio batai"),
            keywords: &["batas", "kuprinė", "stovyklavietė", "žygiai", "žygio batai"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pārgājienu zābaks"),
            keywords: &[
                "kempings",
                "mugursoma",
                "pārgājiens",
                "pārgājienu zābaks",
                "zābaks",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("чизми за планинарење"),
            keywords: &["кампување", "планинарење", "чизма", "чизми за планинарење"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഹൈക\u{d4d}കിംഗ\u{d4d} ബ\u{d42}ട\u{d4d}ട\u{d4d}"),
            keywords: &[
                "ക\u{d4d}യ\u{d3e}മ\u{d4d}പിംഗ\u{d4d}",
                "ബ\u{d3e}ക\u{d4d}ക\u{d4d}\u{200c}പ\u{d3e}ക\u{d4d}കിംഗ\u{d4d}",
                "ബ\u{d42}ട\u{d4d}ട\u{d4d}",
                "ഹൈക\u{d4d}കിംഗ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("уулны гутал"),
            keywords: &[
                "гутал",
                "кэмп",
                "ууланд авирах",
                "уулны гутал",
                "үүргэвчтэй аялал",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("हायकि\u{902}ग ब\u{942}ट"),
            keywords: &[
                "क\u{901}पि\u{902}ग",
                "ब\u{942}ट",
                "ब\u{945}कप\u{945}कि\u{902}ग",
                "हायकि\u{902}ग",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("but kembara"),
            keywords: &["berkhemah", "but", "kembara", "membawa beg galas"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တောစ\u{102e}း ဘ\u{103d}တ\u{103a}ဖ\u{102d}နပ\u{103a}"),
            keywords: &[
                "ကျောပ\u{102d}\u{102f}းအ\u{102d}တ\u{103a}ဖြင\u{1037}\u{103a} ခရ\u{102e}းသ\u{103d}ားခြင\u{103a}း",
                "တောစ\u{102e}း ဘ\u{103d}တ\u{103a}ဖ\u{102d}နပ\u{103a}",
                "တောတ\u{103d}င\u{103a}း ခြေလျင\u{103a}ခရ\u{102e}းထ\u{103d}က\u{103a}ခြင\u{103a}း",
                "ဘ\u{103d}တ\u{103a}ဖ\u{102d}နပ\u{103a}",
                "အပျော\u{103a}စခန\u{103a}းချခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("turstøvel"),
            keywords: &["fjelltur", "gåtur", "støvel", "telttur", "tur", "turstøvel"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("हाइकिङ जा\u{901}दा लगाउन\u{947} ज\u{941}त\u{94d}ता"),
            keywords: &[
                "क\u{94d}याम\u{94d}पिङ",
                "ब\u{941}ट",
                "ब\u{94d}याकप\u{94d}याकिङ",
                "हाइकिङ",
                "हाइकिङ जा\u{901}दा लगाउन\u{947} ज\u{941}त\u{94d}ता",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("wandelschoen"),
            keywords: &["kamperen", "schoen", "trotteur", "wandelen", "wandelschoen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("turstøvel"),
            keywords: &["fjelltur", "gåtur", "støvel", "telttur", "tur", "turstøvel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ହ\u{b3e}ଇକ\u{b3f}ଂ ବ\u{b41}ଟ\u{b4d}\u{200c}"),
            keywords: &[
                "କ\u{b4d}ୟ\u{b3e}ମ\u{b4d}ପ\u{b3f}ଂ",
                "ବ\u{b41}ଟ\u{b4d}\u{200c}",
                "ବ\u{b4d}ୟ\u{b3e}କପ\u{b4d}ୟ\u{b3e}କ\u{b3f}ଂ",
                "ହ\u{b3e}ଇକ\u{b3f}ଂ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਹਾਈਕਿ\u{a70}ਗ ਬ\u{a42}ਟ"),
            keywords: &[
                "ਕ\u{a48}\u{a02}ਪਿ\u{a70}ਗ",
                "ਬ\u{a42}ਟ",
                "ਬ\u{a48}ਕਪ\u{a48}ਕਿ\u{a70}ਗ",
                "ਹਾਈਕਿ\u{a70}ਗ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("But Wé Pípol De Wia Fọ Waká Gó Faa"),
            keywords: &[
                "But",
                "But Wé Pípol De Wia Fọ Waká Gó Faa",
                "To Kámp Fọ Sọm Ples",
                "To Kárí Yọ Tins Ínsaíd Bákpák Bag",
                "To Waká Gó Faa",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("but turystyczny"),
            keywords: &[
                "biwak",
                "but",
                "but turystyczny",
                "piesze wędrówki",
                "wędrówki z plecakiem",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("په غره د ختلو بوټ"),
            keywords: &[
                "بوټ",
                "په شا سامان تړل",
                "په غره ختل",
                "په غره د ختلو بوټ",
                "کامپنګ",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bota de trekking"),
            keywords: &[
                "acampar",
                "bota",
                "bota de trekking",
                "caminhada",
                "mochilão",
                "trilha",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("bota de caminhada"),
            keywords: &[
                "acampamento",
                "bota",
                "bota de caminhada",
                "caminhada",
                "mochila",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bocanc"),
            keywords: &["bocanc", "camping", "drumeție", "gheată"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-020"),
            keywords: &["E11-020"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("треккинговый ботинок"),
            keywords: &[
                "треккинговая обувь",
                "треккинговые ботинки",
                "треккинговый ботинок",
                "туристическая обувь",
                "туристические ботинки",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("هائيڪنگ بوٽ"),
            keywords: &["بوٽ", "بيڪ پيڪنگ", "هائيڪنگ", "ڪيمپنگ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඇව\u{dd2}ද\u{dd3}මේ බ\u{dd6}ට\u{dca}"),
            keywords: &[
                "ඇව\u{dd2}ද\u{dd3}මේ බ\u{dd6}ට\u{dca}",
                "උර පොද\u{dd2}යක\u{dca} ගෙන සංච\u{dcf}රය ක\u{dd2}ර\u{dd3}ම",
                "කඳව\u{dd4}ර\u{dd4} බැඳ\u{dd2}",
                "ද\u{dd2}ඟ\u{dd4} ප\u{dcf}ගමන\u{dca}",
                "බ\u{dd6}ට\u{dca}\u{200c}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("pohorka"),
            keywords: &["kempovať", "pohorka", "stanovať", "turistika", "táboriť"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("pohodniški čevelj"),
            keywords: &[
                "kampiranje",
                "planinarjenje",
                "pohodniški čevelj",
                "pohodništvo",
                "čevelj",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("buudjhka socodka dheer"),
            keywords: &[
                "buudh",
                "buudjhka socodka dheer",
                "shandad-dhabarka safarka",
                "socod dheer",
                "xero u dhixid",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("këpucë ekskursioni"),
            keywords: &[
                "ekskursion",
                "kamp",
                "këpucë",
                "këpucë ekskursioni",
                "çantë shpine",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("ципела за планинарење"),
            keywords: &[
                "камповање",
                "планинарење",
                "ранац",
                "ципела за планинарење",
                "чизма",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("ципела за планинарење"),
            keywords: &["ципела за планинарење"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("cipela za planinarenje"),
            keywords: &[
                "cipela za planinarenje",
                "kampovanje",
                "planinarenje",
                "ranac",
                "čizma",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("cipela za planinarenje"),
            keywords: &["cipela za planinarenje"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("vandringskänga"),
            keywords: &["camping", "pjäxor", "vandring", "vandringskänga"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kiatu cha kutembea mbali"),
            keywords: &[
                "begi ya mgongoni",
                "buti",
                "kiatu cha kutembea mbali",
                "kupiga kambi",
                "kutembea",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஹைக\u{bcd}கிங\u{bcd} பூட\u{bcd}"),
            keywords: &[
                "கேம\u{bcd}பிங\u{bcd}",
                "பூட\u{bcd}",
                "பேக\u{bcd}பேக\u{bcd}கிங\u{bcd}",
                "ஹைக\u{bcd}கிங\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("హ\u{c48}క\u{c3f}ంగ\u{c4d} బూట\u{c4d}లు"),
            keywords: &[
                "క\u{c4d}య\u{c3e}ంప\u{c3f}ంగ\u{c4d}",
                "బూట\u{c4d}లు",
                "బ\u{c4d}య\u{c3e}గ\u{c4d}\u{200c}ప\u{c4d}య\u{c3e}క\u{c4d}",
                "హ\u{c48}క\u{c3f}ంగ\u{c4d}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รองเท\u{e49}าป\u{e35}นเขา"),
            keywords: &[
                "ต\u{e31}\u{e49}งแคมป\u{e4c}",
                "ป\u{e35}นเขา",
                "รองเท\u{e49}าบ\u{e39}\u{e4a}ท",
                "รองเท\u{e49}าป\u{e35}นเขา",
                "แบ\u{e47}คแพ\u{e47}คก\u{e34}\u{e49}ง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýöriş botinkasy"),
            keywords: &[
                "botinka",
                "kemping",
                "rýukzak ýygnamak",
                "ýöriş",
                "ýöriş botinkasy",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sū puti ʻeva lalo"),
            keywords: &["sū puti ʻeva lalo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yürüyüş botu"),
            keywords: &["bot", "kamp", "sırt çantası", "yürüyüş", "yürüyüş botu"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("похідні черевики"),
            keywords: &[
                "взуття",
                "похід",
                "похідні черевики",
                "табір",
                "туристичні чоботи",
                "хайкінг",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ہائکنگ بوٹ"),
            keywords: &["بوٹ", "بیک پیکنگ", "کیمپنگ", "ہائکنگ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tog‘ poyafzali"),
            keywords: &[
                "oyoq kiyimi",
                "sayohat poyafzali",
                "tog‘ poyafzali",
                "tog‘ sayri",
                "trekking",
                "trekking oyoq kiyimi",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("giày leo núi"),
            keywords: &[
                "cắm trại",
                "du lịch bụi",
                "giày leo núi",
                "giày ống",
                "đi bộ đường dài",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("行山鞋"),
            keywords: &["背囊", "行山", "行山鞋", "露營", "靴"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("行山鞋"),
            keywords: &["背囊", "行山", "行山鞋", "露营", "靴"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("登山鞋"),
            keywords: &["徒步", "登山", "登山鞋", "远足野营", "露营"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("登山靴"),
            keywords: &["健行", "登山靴", "背包", "露營", "靴子"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["登山靴", "皮靴", "背包", "行山", "露營"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("amabhuthi okuqwala"),
            keywords: &[
                "amabhuthi okuqwala",
                "backpacking",
                "boot",
                "camping",
                "hiking",
            ],
        },
    ],
};
#[doc = "🥿"]
pub const FLAT_SHOE: crate::Emoji = crate::Emoji {
    glyph: "🥿",
    codepoint: "1F97F",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "flat shoe",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("plat skoen"),
            keywords: &[
                "aanglip",
                "aanglipskoen",
                "balletskoen",
                "plat",
                "plat skoen",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጠፍጣፋ ጫማ"),
            keywords: &["ባሌ ዳንስ", "ነጠላ ጫማ", "ጠለቅ አደረገ", "ጠፍጣፋ ጫማ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("حذاء نسائي بدون كعب"),
            keywords: &[
                "باليرينا",
                "حذاء باليه",
                "حذاء نسائي بدون كعب",
                "خف",
                "خفان",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("সম\u{9be}ন চ’লৰ জোত\u{9be}"),
            keywords: &[
                "বেলেট জোত\u{9be}",
                "শ\u{9cd}লিপ অন",
                "শ\u{9cd}লিপ\u{9be}ৰ",
                "সম\u{9be}ন চ’লৰ জোত\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yastı ayaqqabı"),
            keywords: &[
                "botinka",
                "gəzinti",
                "kempinq",
                "yastı ayaqqabı",
                "əşyaları yığmaq",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("балетка"),
            keywords: &["балетка", "без шнуркоў", "тапак"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("обувка без ток"),
            keywords: &["балеринки", "ниска обувка", "обувка без ток", "пантофка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ফ\u{9cd}ল\u{9cd}য\u{9be}ট জ\u{9c1}তো"),
            keywords: &[
                "চটি",
                "ফ\u{9cd}ল\u{9cd}য\u{9be}ট জ\u{9c1}তো",
                "ব\u{9cd}য\u{9be}লেট ফ\u{9cd}ল\u{9cd}য\u{9be}ট",
                "স\u{9cd}লিপ-অন",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("baletanka"),
            keywords: &["baletanka", "cipela s ravnim đonom", "papuča"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("sabata plana"),
            keywords: &[
                "ballarina",
                "calçat",
                "sabata plana",
                "sabatilla",
                "xinel·la",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏯᏛᏌ ᏗᎳᏑᎶ"),
            keywords: &["ᎠᏍᎩᏍᏓ ᎠᏯᏛᏌ", "ᎠᏯᏛᏌ ᏗᎳᏑᎶ", "ᏗᎧᏁᏍᏗ ᏂᎨᏒᎾ ᏗᎳᏑᎶ", "ᏗᎧᏁᏍᏗ-ᏂᎨᏒᎾ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("střevíček bez podpatku"),
            keywords: &[
                "balerinka",
                "baletní bota",
                "bota na balet",
                "piškotka",
                "plochá bota",
                "střevíček bez podpatku",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("esgid fflat"),
            keywords: &["esgid fflat", "fflat bale", "slip-on", "sliper"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("flad sko"),
            keywords: &["ballerina", "damesko", "flad sko", "slippers"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("flacher Schuh"),
            keywords: &["Ballet-Pumps", "Slipper", "flacher Schuh"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ίσιο παπούτσι"),
            keywords: &[
                "ίσιο παπούτσι",
                "επίπεδο παπούτσι",
                "μπαλαρίνα",
                "παντοφλέ",
                "χαμηλοτάκουνο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("flat shoe"),
            keywords: &["ballet flat", "flat shoe", "slip-on", "slipper"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bailarina"),
            keywords: &["bailarina", "calzado", "mujer", "zapato"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("zapato de piso"),
            keywords: &[
                "bailarina",
                "calzado de piso",
                "zapato de piso",
                "zapato plano",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("madal king"),
            keywords: &["baleriina", "madal king", "paelteta king", "sussking"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("zapata laua"),
            keywords: &["mokasin", "zapata lau", "zapata laua", "zapatila"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کفش بی\u{200c}پاشنه"),
            keywords: &[
                "دمپایی",
                "کفش باله\u{200c}مانند",
                "کفش بی\u{200c}پاشنه",
                "کفش خانه",
                "کفش راحتی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("balleriina"),
            keywords: &["balettitossu", "balleriina", "kenkä", "lipokas", "tossu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("flat na sapatos"),
            keywords: &["ballet flat", "flat na sapatos", "slip-on", "tsinelas"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("flatbotnaður skógvur"),
            keywords: &["flatbotnaður", "flatur", "skógvur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("chaussure plate"),
            keywords: &[
                "ballerine",
                "chaussure plate",
                "chaussure sans lacets",
                "mule",
                "vêtements",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "ballerine",
                "chaussure plate",
                "chaussure sans lacets",
                "pantoufle",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bróg chothrom"),
            keywords: &["bróg bhailé", "bróg chothrom", "bróg dhúnta", "slipéar"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bròg"),
            keywords: &["asair", "ballet", "bròg", "fasair", "laobhag", "slipeir"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("zapato baixo"),
            keywords: &["bailarina", "zapatilla", "zapato baixo", "zapato plano"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સપાટ બ\u{ac2}ટ"),
            keywords: &["સપાટ બ\u{ac2}ટ"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("נעל שטוחה"),
            keywords: &["נעל שטוחה", "נעלי בובה", "נעלי בלט", "נעלי סירה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("फ\u{93c}\u{94d}ल\u{948}ट ज\u{942}ती"),
            keywords: &[
                "फ\u{93c}\u{94d}ल\u{948}ट ज\u{942}ती",
                "ब\u{948}ल\u{947} फ\u{93c}\u{94d}ल\u{948}ट",
                "स\u{94d}लिप-ऑन",
                "स\u{94d}लिपर",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("balerinka"),
            keywords: &["balerinka", "cipela s ravnim đonom", "papuča"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("lapos sarkú cipő"),
            keywords: &["balenira", "lapos sarkú cipő", "mokaszin", "papucs"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տափակ կոշիկ"),
            keywords: &["բալետի կոշիկ", "լոֆեր", "հողաթափ", "տափակ կոշիկ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("sepatu flat"),
            keywords: &["sandal selop", "selop", "sepatu balet", "sepatu flat"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("lágbotna skór"),
            keywords: &["ballettskór", "inniskór", "lágbotna skór", "skór"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("ballerina"),
            keywords: &["ballerina", "scarpa senza lacci", "scarpe da ballerina"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("フラットシューズ"),
            keywords: &[
                "ぺたんこ靴",
                "スリッポン",
                "バレエシューズ",
                "フラットシューズ",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sepatu trepes"),
            keywords: &["pantofel", "selop", "sepatu trepes", "trepes balet"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("უქუსლო ფეხსაცმელი"),
            keywords: &["ბალეტკები", "პუანტები", "უქუსლო ფეხსაცმელი", "წუღა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жайпақ туфли"),
            keywords: &["балетка", "жайпақ туфли", "жеңіл аяқкиім", "шәрке"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}បែកជើងបាតរាប"),
            keywords: &[
                "ស\u{17d2}បែកជើងបាតរាប",
                "ស\u{17d2}បែកជើងបាតរាបសម\u{17d2}រាប\u{17cb}ស\u{17d2}ត\u{17d2}រ\u{17b8}",
                "ស\u{17d2}បែកជើងបាតរាបឥតខ\u{17d2}សែ",
                "ស\u{17d2}បែកជើងផ\u{17d2}ទាត\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸಮತಟ\u{ccd}ಟಾದ ಶ\u{cc2}"),
            keywords: &[
                "ಬ\u{ccd}ಯಾಲ\u{cc6} ಸಮತಟ\u{ccd}ಟಾದ",
                "ಸಮತಟ\u{ccd}ಟಾದ ಶ\u{cc2}",
                "ಸ\u{ccd}ಲ\u{cbf}ಪ\u{ccd}-ಆನ\u{ccd}",
                "ಸ\u{ccd}ಲ\u{cbf}ಪ\u{ccd}ಪರ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("플랫 슈즈"),
            keywords: &["단화", "발레 슈즈", "플랫 슈즈"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("सपाट जोत\u{947}\u{902}"),
            keywords: &[
                "ब\u{945}ल\u{947} सपाट",
                "सपाट जोत\u{947}\u{902}",
                "स\u{94d}लिपर",
                "स\u{94d}लीप-ऑन",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жалпак туфли"),
            keywords: &["боосуз бут кийим", "бутка илип алма", "жалпак туфли"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເກ\u{eb5}ບແຕະ"),
            keywords: &[
                "ເກ\u{eb5}ບຊ\u{eb8}ບ",
                "ເກ\u{eb5}ບພ\u{eb7}\u{ec9}ນແປ",
                "ເກ\u{eb5}ບແຕະ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("lygiapadis batelis"),
            keywords: &[
                "avalynė be raištelių",
                "baleto batelis",
                "lygiapadis batelis",
                "šlepetė",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("baleta kurpe"),
            keywords: &["baleta kurpe", "iešļūcene", "čība"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("балетанка"),
            keywords: &["балетанка", "папуча"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഫ\u{d4d}ല\u{d3e}റ\u{d4d}റ\u{d4d} ഷ\u{d42}"),
            keywords: &[
                "ഫ\u{d4d}ല\u{d3e}റ\u{d4d}റ\u{d4d} ഷ\u{d42}",
                "ബ\u{d3e}ലറ\u{d4d}റ\u{d4d} ഫ\u{d4d}ല\u{d3e}റ\u{d4d}റ\u{d4d}",
                "സ\u{d4d}ലിപ\u{d4d}പ\u{d4d}-ഓൺ",
                "സ\u{d4d}ലിപ\u{d4d}പർ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("намхан ултай гутал"),
            keywords: &["гэрийн шаахай", "намхан ултай гутал", "үдээсгүй гутал"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("फ\u{94d}ल\u{945}ट श\u{942}"),
            keywords: &[
                "फ\u{94d}ल\u{945}ट श\u{942}",
                "ब\u{945}ल\u{947}ट फ\u{94d}ल\u{945}ट",
                "स\u{94d}लिप-ऑन",
                "स\u{94d}लिपर",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kasut rata"),
            keywords: &["kasut rata", "kasut sarung", "rata balet", "selipar"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဒေါက\u{103a}မပါ ရ\u{103e}\u{1030}းဖ\u{102d}နပ\u{103a}"),
            keywords: &[
                "က\u{103d}င\u{103a}းထ\u{102d}\u{102f}းဖ\u{102d}နပ\u{103a}",
                "ခြေည\u{103e}ပ\u{103a}ဖ\u{102d}နပ\u{103a}",
                "ဒေါက\u{103a}မပါ ရ\u{103e}\u{1030}းဖ\u{102d}နပ\u{103a}",
                "ဘ\u{1032}လေး ဖ\u{102d}နပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("pumps"),
            keywords: &["flate sko", "pumps", "uten hæl"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बिना हिलको ज\u{941}त\u{94d}ता"),
            keywords: &[
                "ख\u{941}ट\u{94d}टा छिराउन\u{947}",
                "चप\u{94d}पल",
                "बिना हिलको",
                "बिना हिलको ज\u{941}त\u{94d}ता",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("platte schoen"),
            keywords: &["ballerina", "instapper", "platte schoen", "slip-on"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("pumps"),
            keywords: &["flate sko", "pumps", "utan hæl"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଫ\u{b4d}ଲ\u{b3e}ଟ\u{b4d}\u{200c} ସ\u{b41}"),
            keywords: &[
                "ଫ\u{b4d}ଲ\u{b3e}ଟ\u{b4d}\u{200c} ସ\u{b41}",
                "ବଲେଟ\u{b4d}\u{200c} ଫ\u{b4d}ଲ\u{b3e}ଟ\u{b4d}\u{200c}",
                "ସ\u{b4d}ଲ\u{b3f}ପରୋ",
                "ସ\u{b4d}ଲ\u{b3f}ପ\u{b4d}\u{200c}-ଅନ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਫਲ\u{a48}ਟ ਜ\u{a41}\u{a71}ਤ\u{a47}"),
            keywords: &[
                "ਫਲ\u{a48}ਟ ਜ\u{a41}\u{a71}ਤ\u{a47}",
                "ਬ\u{a48}ਲੀ ਫਲ\u{a48}ਟ",
                "ਸਲਿ\u{a71}ਪ-ਆਨ",
                "ਸਲੀਪਰ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Flát Shu"),
            keywords: &[
                "Balẹ\u{301}t Flát Shu",
                "Flát Shu",
                "Slí-ọ\u{301}n Shu",
                "Slípas",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("baleriny"),
            keywords: &["baleriny", "baletki", "but wsuwany", "pantofelek"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("هوار پېزار"),
            keywords: &["بيلټ هوار", "سلپ آن", "هوار پېزار", "چپل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("sapatilha"),
            keywords: &["sapatilha", "sapatilha de balé", "sapato", "sem fivela"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("sabrina"),
            keywords: &["chinelo", "sabrina", "slip-on"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pantof fără toc"),
            keywords: &["balerin", "mocasin", "pantof fără toc"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-021"),
            keywords: &["E11-021"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("балетки"),
            keywords: &[
                "балетки",
                "без каблука",
                "обувь на плоской подошве",
                "туфли без каблука",
                "туфли на плоской подошве",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("فليٽ جوتو"),
            keywords: &["بيليٽ فليٽ", "سلپ-آن", "سلپر", "فليٽ جوتو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පැතල\u{dd2} සපත\u{dca}ත\u{dd4}"),
            keywords: &[
                "පැතල\u{dd2} සපත\u{dca}ත\u{dd4}",
                "පැළද\u{dcf} ස\u{dd2}ට\u{dd2}න",
                "බැලේ පැතළ\u{dd2}",
                "සෙරෙප\u{dca}ප\u{dd4}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("balerína"),
            keywords: &["balerína", "balerínka", "cvička", "papučka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("balerinke"),
            keywords: &["balerinke", "balernike", "brez pete", "natakniti"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kabo siman"),
            keywords: &[
                "dacas",
                "kabaha ciyaarta ee isku siman",
                "kabo siiban kara",
                "kabo siman",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("këpucë e sheshtë"),
            keywords: &["heqël", "këpucë baleti", "këpucë e sheshtë", "pantofël"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("равна ципела"),
            keywords: &["балетанка", "мокасина", "папуча", "равна ципела"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("равна ципела"),
            keywords: &["равна ципела"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ravna cipela"),
            keywords: &["baletanka", "mokasina", "papuča", "ravna cipela"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("ravna cipela"),
            keywords: &["ravna cipela"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ballerinasko"),
            keywords: &["ballerinasko", "lågklackad", "toffla"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kiatu kisicho na kisigino"),
            keywords: &[
                "kandambili",
                "kiatu kisicho na kisigino",
                "ndara",
                "viatu vya bale",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("தட\u{bcd}டைய\u{bbe}ன ஷூ"),
            keywords: &[
                "தட\u{bcd}டைய\u{bbe}ன ஷூ",
                "ப\u{bbe}லே ஃபிள\u{bbe}ட\u{bcd}",
                "ஸ\u{bcd}லிப\u{bcd} ஆன\u{bcd}",
                "ஸ\u{bcd}லிப\u{bcd}பர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఫ\u{c4d}ల\u{c3e}ట\u{c4d} షూ"),
            keywords: &[
                "ఫ\u{c4d}ల\u{c3e}ట\u{c4d} షూ",
                "బ\u{c4d}య\u{c3e}ల\u{c46}ట\u{c4d} ఫ\u{c4d}ల\u{c3e}ట\u{c4d}",
                "స\u{c4d}ల\u{c3f}ప\u{c4d}-ఆన\u{c4d}",
                "స\u{c4d}ల\u{c3f}ప\u{c4d}పర\u{c4d}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รองเท\u{e49}าส\u{e49}นเต\u{e35}\u{e49}ย"),
            keywords: &[
                "รองเท\u{e49}าค\u{e31}ทช\u{e39}",
                "รองเท\u{e49}าบ\u{e31}ลเล\u{e48}ต\u{e4c}",
                "รองเท\u{e49}าสล\u{e34}ปเปอร\u{e4c}",
                "รองเท\u{e49}าส\u{e49}นเต\u{e35}\u{e49}ย",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("tekiz köwüş"),
            keywords: &["balet köwşi", "köýnek", "tekiz köwüş", "şypbyk"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sū fakafefine"),
            keywords: &["sū fakafefine"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("düz ayakkabı"),
            keywords: &["babet", "düz ayakkabı", "terlik", "topuksuz"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("туфлі без підборів"),
            keywords: &[
                "балетки",
                "кеди",
                "сліпони",
                "тапочки",
                "туфлі без підборів",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ہموار جوتا"),
            keywords: &[
                "آسانی سے پہنا جا سکنے والا",
                "بیلے فلیٹ",
                "سلیپر",
                "ہموار جوتا",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("baletka"),
            keywords: &[
                "baletka",
                "oyoq kiyim",
                "poshnasiz",
                "poshnasiz oyoq kiyim",
                "poyafzal",
                "tagliksiz",
                "tekis taglikli poyafzal",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("giày bệt"),
            keywords: &["giày búp bê", "giày bệt", "giày lười", "giày đi trong nhà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("平底鞋"),
            keywords: &["平底鞋", "拖鞋", "芭蕾平底", "著上"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("平底鞋"),
            keywords: &["平底鞋", "拖鞋", "着上", "芭蕾平底"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("平底鞋"),
            keywords: &["一脚蹬", "便鞋", "平底芭蕾舞鞋", "平底鞋"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("平底鞋"),
            keywords: &["平底鞋", "懶人鞋", "拖鞋", "芭蕾舞鞋"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isicathulo esiphansi"),
            keywords: &["ballet flat", "isicathulo esiphansi", "slip-on", "slipper"],
        },
    ],
};
#[doc = "👠"]
pub const HIGH_HEELED_SHOE: crate::Emoji = crate::Emoji {
    glyph: "👠",
    codepoint: "1F460",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "high-heeled shoe",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("hoëhakskoen"),
            keywords: &["hak", "hoëhakskoen", "klere", "skoen", "vrou"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ባለ ተረከዝ የሴት ጫማ"),
            keywords: &["ሴት", "ባለ ተረከዝ የሴት ጫማ", "ተረከዝ", "አልባሳት", "ጫማ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("حذاء بكعب عال\u{64d}"),
            keywords: &["حذاء", "حذاء بكعب عال\u{64d}", "ملابس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ওখ হিলৰ জোত\u{9be}"),
            keywords: &[
                "ওখ হিলৰ জোত\u{9be}",
                "জোত\u{9be}",
                "পোছ\u{9be}ক",
                "মহিল\u{9be}",
                "হিল",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("hündür daban ayaqqabı"),
            keywords: &[
                "ayaqqabı",
                "daban",
                "geyim",
                "hündür daban ayaqqabı",
                "qadın",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("туфель на абцасе"),
            keywords: &["абутак", "абцас", "жанчына", "туфель на абцасе"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Обувка с висок ток"),
            keywords: &["Обувка с висок ток", "жена", "облекло", "обувка", "ток"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("উচ\u{9c1} হিলের জ\u{9c1}তো"),
            keywords: &[
                "উচ\u{9c1} হিলের জ\u{9c1}তো",
                "গোড\u{9bc}\u{9be}লি",
                "জ\u{9c1}তো",
                "ন\u{9be}রী",
                "পোশ\u{9be}ক",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("skarpin"),
            keywords: &["botez", "skarpin"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("cipela s visokim potpeticama"),
            keywords: &[
                "cipela",
                "cipela s visokim potpeticama",
                "visoka peta",
                "štikla",
                "žena",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("sabata de taló"),
            keywords: &["calçat", "sabata", "sabata de taló", "taló"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎢᎾ-ᎢᏗᎦᏘ ᎠᎳᏑᎶ"),
            keywords: &["ᎠᎨᏯ", "ᎠᎳᏑᎶ", "ᎢᎾ ᏧᏍᏓᏟ", "ᎢᎾ-ᎢᏗᎦᏘ ᎠᎳᏑᎶ", "ᏗᎿᏬ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("bota na podpatku"),
            keywords: &["bota", "bota na podpatku", "oblečení", "podpatek", "žena"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("esgidiau sodlau uchel"),
            keywords: &["dillad", "esgid", "esgidiau sodlau uchel", "menyw", "sawdl"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("høje hæle"),
            keywords: &["høje hæle", "højhælet sko", "sko", "stiletter"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Stöckelschuh"),
            keywords: &["Absatzschuh", "Damen", "Highheels", "Pumps", "Stöckelschuh"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ψηλοτάκουνο παπούτσι"),
            keywords: &[
                "γυναίκα",
                "παπούτσι",
                "ρουχισμός",
                "τακούνι",
                "ψηλοτάκουνο παπούτσι",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("high-heeled shoe"),
            keywords: &["clothing", "heel", "high-heeled shoe", "shoe", "woman"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["clothing", "heel", "shoe", "stiletto", "woman"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("zapato de tacón"),
            keywords: &["mujer", "tacón", "zapato", "zapato de tacón"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("zapato de taco alto"),
            keywords: &[
                "mujer",
                "tacón",
                "zapato",
                "zapato de taco alto",
                "zapato de tacón",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("zapatilla"),
            keywords: &["mujer", "ropa", "vestimenta", "zapatilla", "zapato"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("zapato de tacón alto"),
            keywords: &[
                "mujer",
                "ropa",
                "tacón",
                "vestimenta",
                "zapato",
                "zapato de tacón alto",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kõrge kontsaga king"),
            keywords: &["king", "konts", "kõrge kontsaga king", "naine", "riided"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("oinetako takoidunak"),
            keywords: &[
                "arropa",
                "emakume",
                "oinetako",
                "oinetako takoidunak",
                "takoi",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کفش پاشنه بلند"),
            keywords: &["زن", "پاشنه", "پوشاک", "کفش", "کفش پاشنه بلند"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("korkokenkä"),
            keywords: &["kenkä", "korko", "korkokenkä", "nainen", "vaatteet"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("high heels"),
            keywords: &["heels", "high heels", "kasuotan", "pambabae", "sapatos"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("høghælaður skógvur"),
            keywords: &[
                "høghælaður skógvur",
                "klæði",
                "kona",
                "konufólk",
                "kvinna",
                "skógvur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("chaussure à talon haut"),
            keywords: &["chaussure", "chaussure à talon haut", "vêtements"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "chaussure",
                "chaussure à talon haut",
                "femme",
                "talon",
                "vêtements",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("sáil ard"),
            keywords: &["bróg", "sáil ard", "sála arda"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bròg le sàil àrd"),
            keywords: &["aodach", "boireannach", "bròg", "bròg le sàil àrd", "sàil"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("zapato de tacón"),
            keywords: &["muller", "tacón", "zapato", "zapato de tacón"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઉ\u{a82}ચી હિલવાળા જ\u{ac2}તા"),
            keywords: &[
                "ઉ\u{a82}ચી હિલ",
                "ઉ\u{a82}ચી હિલવાળા જ\u{ac2}તા",
                "કપડા\u{a82}",
                "જ\u{ac2}તા",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("takalmi mai doguwar dunduniya"),
            keywords: &[
                "diddige",
                "mace",
                "sutura",
                "takalmi",
                "takalmi mai doguwar dunduniya",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("נעל עקב גבוה"),
            keywords: &["אישה", "נעל", "נעל עקב גבוה", "עקב"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ऊ\u{901}ची एड\u{93c}ी का स\u{948}\u{902}डिल"),
            keywords: &[
                "ऊ\u{901}ची एड\u{93c}ी का स\u{948}\u{902}डिल",
                "ज\u{942}त\u{947}",
                "पोषाक",
                "हाई–हील",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("cipela s visokom potpeticom"),
            keywords: &[
                "cipela",
                "cipela s visokom potpeticom",
                "obuća",
                "potpetica",
                "žene",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("magas sarkú cipő"),
            keywords: &["magas sarkú cipő", "magassarkú", "nők", "ruha", "ruházat"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բարձրակրունկ կոշիկ"),
            keywords: &["բարձրակրունկ կոշիկ", "կին", "կոշիկ", "կրունկ", "հագուստ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("sepatu hak tinggi"),
            keywords: &["hak", "pakaian", "sepatu", "sepatu hak tinggi", "wanita"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akpụkpọụkwụ pịrị ọnụ"),
            keywords: &[
                "akpụkpọụkwụ",
                "akpụkpọụkwụ pịrị ọnụ",
                "na-eme akwà",
                "nwanyị",
                "pịrị ọnụ dị elu",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("háhælaður skór"),
            keywords: &["háhælaður skór", "klæðnaður", "skór"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("scarpa con il tacco"),
            keywords: &["abbigliamento", "scarpa", "scarpa con il tacco", "tacco"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ハイヒール"),
            keywords: &["ハイヒール", "ピンヒール", "靴"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sepatu hak dhuwur"),
            keywords: &["hak", "sandhangan", "sepatu", "sepatu hak dhuwur", "wadon"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მაღალქუსლიანი ფეხსაცმელი"),
            keywords: &[
                "მაღალქუსლიანი ფეხსაცმელი",
                "ტანსაცმელი",
                "ფეხსაცმელი",
                "ქალი",
                "ქუსლი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("биік өкшелі туфли"),
            keywords: &["биік өкшелі туфли", "киім", "туфли", "әйел", "өкше"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("høje hæle"),
            keywords: &["høje hæle", "højhælet sko", "sko"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}បែកជើងកែងចោត"),
            keywords: &["កែងចោត", "ស\u{17d2}បែកជើកែង", "ស\u{17d2}បែកជើងកែងចោត"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಎತ\u{ccd}ತರದ ಹ\u{cbf}ಮ\u{ccd}ಮಡ\u{cbf}ಯ ಶ\u{cc2}"),
            keywords: &[
                "ಉಡುಪು",
                "ಎತ\u{ccd}ತರದ ಹ\u{cbf}ಮ\u{ccd}ಮಡ\u{cbf}ಯ ಶ\u{cc2}",
                "ಮಹ\u{cbf}ಳ\u{cc6}",
                "ಹೀಲ\u{ccd}",
                "ಹ\u{cc6}ಚ\u{ccd}ಚು ಎತ\u{ccd}ತರದ ಶ\u{cc2}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("하이힐"),
            keywords: &["구두", "신발", "여성용 구두", "여성용 신발", "하이힐"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("चड हिलाच\u{947}\u{902} जोत\u{947}\u{902}"),
            keywords: &[
                "कपड\u{947}",
                "चड हिलाच\u{947}\u{902} जोत\u{947}\u{902}",
                "जोत\u{947}\u{902}",
                "बायल",
                "हील",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бийик такалуу бут кийим"),
            keywords: &[
                "аял",
                "бийик такалуу бут кийим",
                "бут кийим",
                "кийим",
                "така",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Tallekeschong"),
            keywords: &["Fra", "Kleedung", "Schong", "Tallek", "Tallekeschong"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເກ\u{eb5}ບສ\u{ebb}\u{ec9}ນສ\u{eb9}ງ"),
            keywords: &[
                "ສ\u{ebb}\u{ec9}ນສ\u{eb9}ງ",
                "ເກ\u{eb5}ບ",
                "ເກ\u{eb5}ບສ\u{ebb}\u{ec9}ນສ\u{eb9}ງ",
                "ເກ\u{eb5}ບແມ\u{ec8}ຍ\u{eb4}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("aukštakulnis batelis"),
            keywords: &[
                "aukštakulnis batelis",
                "batas",
                "drabužiai",
                "kulnas",
                "moteris",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("augstpapēžu kurpe"),
            keywords: &["apavi", "augstpapēžu kurpe", "papēdis", "sieviešu"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("hū rekereke-teitei"),
            keywords: &["hū", "hū rekereke-teitei", "kākahu", "rekereke", "wahine"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("чевел со висока потпетица"),
            keywords: &["жена", "обувки", "чевел со висока потпетица", "чевли"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഹൈ ഹീൽ ഷ\u{d42}"),
            keywords: &[
                "വസ\u{d4d}\u{200c}ത\u{d4d}രം",
                "ഷ\u{d42}",
                "സ\u{d4d}\u{200c}ത\u{d4d}രീ",
                "ഹീൽ",
                "ഹൈ ഹീൽ ഷ\u{d42}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("өндөр өсгийтэй гутал"),
            keywords: &[
                "гутал",
                "хувцаслалт",
                "эмэгтэй",
                "өндөр өсгийт",
                "өндөр өсгийтэй гутал",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("उ\u{902}च टाचा\u{902}ची महिला\u{902}ची स\u{901}डल"),
            keywords: &[
                "उ\u{902}च टाचा\u{902}ची महिला\u{902}ची स\u{901}डल",
                "उ\u{902}च टाचा\u{902}च\u{947} महिला\u{902}च\u{947} जोड\u{947}",
                "कपड\u{947}",
                "जोड\u{947}",
                "टाच",
                "महिला",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kasut tumit tinggi"),
            keywords: &["kasut", "kasut tumit tinggi", "pakaian", "tumit", "wanita"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("żarbun b’takkuna għolja"),
            keywords: &[
                "mara",
                "takkuna",
                "ħwejjeġ",
                "żarbun",
                "żarbun b’takkuna għolja",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဒေါက\u{103a}မြင\u{1037}\u{103a} ဖ\u{102d}နပ\u{103a}"),
            keywords: &[
                "ဒေါက\u{103a}",
                "ဒေါက\u{103a}မြင\u{1037}\u{103a} ဖ\u{102d}နပ\u{103a}",
                "ဒေါက\u{103a}မြင\u{1037}\u{103a}ဖ\u{102d}နပ\u{103a}",
                "မ\u{102d}န\u{103a}းမစ\u{102e}း ရ\u{103e}\u{1030}းဖ\u{102d}နပ\u{103a}",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း",
                "အဝတ\u{103a}အစား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("høyhælt sko"),
            keywords: &["høyhælt sko", "klær", "sko"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("अग\u{94d}लो हिल भएको ज\u{941}त\u{94d}ता"),
            keywords: &[
                "अग\u{94d}लो हिल भएको ज\u{941}त\u{94d}ता",
                "कपडा",
                "छोरी मान\u{94d}छ\u{947}",
                "ज\u{941}त\u{94d}ता",
                "हिल",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("schoen met hoge hak"),
            keywords: &["hak", "kleding", "schoen", "schoen met hoge hak", "vrouw"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("høghæla sko"),
            keywords: &["høghæla sko", "klede", "sko"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଉଚ\u{b4d}ଚ-ଗୋଇଠ\u{b3f}ଯ\u{b41}କ\u{b4d}ତ ଜୋତ\u{b3e}"),
            keywords: &[
                "ଉଚ\u{b4d}ଚ-ଗୋଇଠ\u{b3f}ଯ\u{b41}କ\u{b4d}ତ ଜୋତ\u{b3e}",
                "ଜୋତ\u{b3e}",
                "ପୋଷ\u{b3e}କ ପର\u{b3f}ଚ\u{b4d}ଛଦ",
                "ହ\u{b3e}ଇ-ହ\u{b3f}ଲ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਉ\u{a71}ਚੀ-ਅ\u{a71}ਡੀ ਵਾਲੀ ਜ\u{a41}\u{a71}ਤੀ"),
            keywords: &[
                "ਉ\u{a71}ਚ-ਅ\u{a71}ਡੀ",
                "ਉ\u{a71}ਚੀ-ਅ\u{a71}ਡੀ ਵਾਲੀ ਜ\u{a41}\u{a71}ਤੀ",
                "ਔਰਤ",
                "ਬ\u{a42}ਟ",
                "ਲਿਬਾਸ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ا\u{64f}وچی اڈی آلی جوتی"),
            keywords: &["ا\u{64f}وچی اڈی آلی جوتی", "ایڑھی", "جوتا", "زنانی", "کپڑے"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Haí-Híl Shu"),
            keywords: &["Haí-Híl Shu", "Hil", "Klọt", "Shu", "Wúman"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("but na wysokim obcasie"),
            keywords: &[
                "but na wysokim obcasie",
                "na szpilkach",
                "szpilka",
                "wysoki obcas",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کوری-بلند بوټان"),
            keywords: &["بوټان", "لباس", "ښځه", "کوری-بلند بوټان", "کورۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("sapato de salto alto"),
            keywords: &["acessório", "sapato", "sapato de salto alto"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "calçado",
                "salto",
                "saltos altos",
                "sapato de salto alto",
                "senhora",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tacones phapatu"),
            keywords: &["tacones phapatu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pantof cu toc"),
            keywords: &[
                "femeie",
                "feminin",
                "pantof cu toc",
                "toc înalt",
                "încălțăminte",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-541"),
            keywords: &["E10-541"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("туфли на каблуке"),
            keywords: &[
                "женщина",
                "каблук",
                "на каблуке",
                "обувь",
                "стиль",
                "туфли",
                "туфли на каблуке",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("urukweto rufite taro ndende"),
            keywords: &[
                "agatsintsino",
                "umugore",
                "umwambaro",
                "urukweto",
                "urukweto rufite taro ndende",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("وڏي کڙي وارو جوتو"),
            keywords: &["جوتو", "عورت", "لباس", "وڏي کڙي وارو جوتو", "کڙي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අඩ\u{dd2} උස සපත\u{dca}ත\u{dd4}ව"),
            keywords: &[
                "අඩ\u{dd2} උස සපත\u{dca}ත\u{dd4}ව",
                "අඩ\u{dd2}ය",
                "ඇඳ\u{dd4}ම\u{dca}",
                "ක\u{dcf}න\u{dca}ත\u{dcf}ව",
                "සපත\u{dca}ත\u{dd4}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("topánka na podpätku"),
            keywords: &[
                "oblečenie",
                "podpätok",
                "topánka",
                "topánka na podpätku",
                "žena",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("čevelj z visoko peto"),
            keywords: &[
                "oblačila",
                "peta",
                "čevelj",
                "čevelj z visoko peto",
                "ženska",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kabo cidhib dhaadheer"),
            keywords: &[
                "cidhib",
                "dhar",
                "gabadh",
                "kabo",
                "kabo cidhib dhaadheer",
                "kabo cidhib dheer",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("këpucë me takë të lartë"),
            keywords: &[
                "grua",
                "këpucë",
                "këpucë me takë të lartë",
                "takë",
                "veshje",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("ципела са штиклом"),
            keywords: &["жена", "одећа", "ципела", "ципела са штиклом", "штикла"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["ципела са штиклом"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("cipela sa štiklom"),
            keywords: &["cipela", "cipela sa štiklom", "odeća", "štikla", "žena"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["cipela sa štiklom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("högklackad sko"),
            keywords: &["högklackad sko", "klack", "pumps", "sko"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kiatu chenye kisigino kirefu"),
            keywords: &[
                "kiatu",
                "kiatu chenye kisigino kirefu",
                "kisigino",
                "mavazi",
                "mwanamke",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஹைஹ\u{bc0}ல\u{bcd} செருப\u{bcd}பு"),
            keywords: &[
                "ஆடை அணிகலன\u{bcd}",
                "ஹ\u{bc0}ல\u{bcd}",
                "ஹை ஹ\u{bc0}ல\u{bcd}ஸ\u{bcd}",
                "ஹைஹ\u{bc0}ல\u{bcd} செருப\u{bcd}பு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c4d}త\u{c4d}ర\u{c40}ల ఎత\u{c4d}తు చ\u{c46}ప\u{c4d}పులు"),
            keywords: &[
                "చ\u{c46}ప\u{c4d}పులు",
                "స\u{c4d}త\u{c4d}ర\u{c40}",
                "స\u{c4d}త\u{c4d}ర\u{c40}ల ఎత\u{c4d}తు చ\u{c46}ప\u{c4d}పులు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("пойафзоли пошнабаланд"),
            keywords: &["зан", "либос", "пойафзол", "пойафзоли пошнабаланд", "пошна"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รองเท\u{e49}าส\u{e49}นส\u{e39}ง"),
            keywords: &[
                "รองเท\u{e49}า",
                "รองเท\u{e49}าผ\u{e39}\u{e49}หญ\u{e34}ง",
                "รองเท\u{e49}าส\u{e49}นส\u{e39}ง",
                "ส\u{e49}นส\u{e39}ง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ökjeli köwüş"),
            keywords: &["eşik", "köwüş", "zenan", "ökje", "ökjeli köwüş"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sū ʻete"),
            keywords: &["sū ʻete"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yüksek topuklu ayakkabı"),
            keywords: &["ayakkabı", "giyim", "yüksek topuklu ayakkabı"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئېگىز پاشنىلىق ئاياغ"),
            keywords: &["ئاياغ", "ئايال", "ئېگىز پاشنىلىق ئاياغ", "كىيىم", "پاشنا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("туфля на високому підборі"),
            keywords: &[
                "взуття",
                "жінка",
                "каблук",
                "одяг",
                "туфля на високому підборі",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اونچی ایڑی والا جوتا"),
            keywords: &["اونچی ایڑی", "اونچی ایڑی والا جوتا", "جوتا", "عورت", "لباس"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("baland poshnali tufli"),
            keywords: &["ayol", "baland poshnali tufli", "kiyim", "poshna", "tufli"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("giày cao gót"),
            keywords: &["giày", "giày cao gót", "gót chân", "phụ nữ", "quần áo"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("koket yu gudd"),
            keywords: &["dàll", "jigéen", "koket yu gudd", "taloŋ", "yéere"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isihlangu esinesithende esiphakamileyo"),
            keywords: &[
                "ibhinqa",
                "impahla",
                "isihlangu",
                "isihlangu esinesithende esiphakamileyo",
                "isithende",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bata Gogoro"),
            keywords: &["Bata Gogoro", "aṣọ", "bàtà", "bàtà gogoro", "obìnrin"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("高根鞋"),
            keywords: &["女士", "服裝", "鞋", "高根鞋"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("高根鞋"),
            keywords: &["女士", "服装", "鞋", "高根鞋"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("高跟鞋"),
            keywords: &["女", "鞋", "高跟鞋"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("高跟鞋"),
            keywords: &["女鞋", "高跟鞋"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("高踭鞋"),
            keywords: &["女裝鞋", "高踭鞋"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iqhoksi"),
            keywords: &["impahla yokugqoka", "iqhoksi", "isicathulo", "owesimame"],
        },
    ],
};
#[doc = "👡"]
pub const WOMANS_SANDAL: crate::Emoji = crate::Emoji {
    glyph: "👡",
    codepoint: "1F461",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "woman’s sandal",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vrouesandaal"),
            keywords: &["klere", "sandaal", "skoen", "vrou", "vrouesandaal"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሴት ሰንደል ጫማ"),
            keywords: &["ሰንደል", "ሴት", "አልባሳት", "የሴት ሰንደል ጫማ", "ጫማ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("صندل حريمي"),
            keywords: &["صندل", "صندل حريمي", "ملابس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মহিল\u{9be}ৰ চেণ\u{9cd}ডেল"),
            keywords: &[
                "চেণ\u{9cd}ডেল",
                "জোত\u{9be}",
                "পোছ\u{9be}ক",
                "মহিল\u{9be}",
                "মহিল\u{9be}ৰ চেণ\u{9cd}ডেল",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qadın səndəli"),
            keywords: &["ayaqqabı", "geyim", "qadın", "qadın səndəli", "səndəl"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("жаночая сандаля"),
            keywords: &["абутак", "жаночая сандаля", "жанчына", "сандалі"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Дамска отворена обувка"),
            keywords: &[
                "Дамска отворена обувка",
                "жена",
                "облекло",
                "обувка",
                "отворена",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মহিল\u{9be}দের চটি"),
            keywords: &[
                "জ\u{9c1}তো",
                "ন\u{9be}রী",
                "পোশ\u{9be}ক",
                "মহিল\u{9be}দের চটি",
                "স\u{9cd}য\u{9be}ন\u{9cd}ডেল",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ženska sandala"),
            keywords: &["obuća", "sandala", "žena", "ženska sandala"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("sandàlia de dona"),
            keywords: &["calçat", "dona", "sandàlia", "sandàlia de dona"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ ᏧᎳᏑᎶ"),
            keywords: &["ᎠᎨᏯ", "ᎠᎨᏯ ᏧᎳᏑᎶ", "ᎠᎳᏑᎶ", "ᎠᏍᏚᎢᏓ ᎠᎳᏑᎶ", "ᏗᎿᏬ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("dámský sandál"),
            keywords: &[
                "bota",
                "dámský sandál",
                "oblečení",
                "sandál",
                "střevíc",
                "střevíček",
                "žena",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sandal menyw"),
            keywords: &["dillad", "esgid", "menyw", "sandal"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("damesandal"),
            keywords: &["damesandal", "sandaler"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Damensandale"),
            keywords: &["Damen", "Damensandale", "Sandale", "Schuh"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γυναικείο σανδάλι"),
            keywords: &[
                "γυναίκα",
                "γυναικείο σανδάλι",
                "παπούτσι",
                "ρουχισμός",
                "σανδάλι",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("woman’s sandal"),
            keywords: &["clothing", "sandal", "shoe", "woman", "woman’s sandal"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("sandalia de mujer"),
            keywords: &["calzado", "mujer", "ropa", "sandalia", "sandalia de mujer"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "mujer",
                "ropa",
                "sandalia",
                "sandalia de mujer",
                "vestimenta",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("naistesandaal"),
            keywords: &["king", "naine", "naistesandaal", "riided", "sandaal"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("emakumeentzako sandalia"),
            keywords: &[
                "arropa",
                "emakume",
                "emakumeentzako sandalia",
                "oinetako",
                "sandalia",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("صندل زنانه"),
            keywords: &["زن", "صندل", "صندل زنانه", "پوشاک", "کفش"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("naisen sandaali"),
            keywords: &["kenkä", "nainen", "naisen sandaali", "sandaali", "vaatteet"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pambabaeng sandals"),
            keywords: &[
                "kasuotan",
                "pambabae",
                "pambabaeng sandals",
                "sandals",
                "sandalyas",
                "sapatos",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("konufólkasandála"),
            keywords: &[
                "klæði",
                "kona",
                "konufólk",
                "konufólkasandála",
                "kvinna",
                "sandála",
                "skógvur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("sandale de femme"),
            keywords: &["chaussure", "sandale de femme", "vêtements"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("sandale à talon"),
            keywords: &[
                "chaussure",
                "femme",
                "sandale",
                "sandale à talon",
                "talon",
                "vêtements",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cuarán mná"),
            keywords: &["bróg", "cuarán", "cuarán mná"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cuaran boireannaich"),
            keywords: &[
                "aodach",
                "boireannach",
                "bròg",
                "cuaran",
                "cuaran boireannaich",
                "sandal",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("sandalia de muller"),
            keywords: &["calzado", "muller", "sandalia", "sandalia de muller"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}ત\u{acd}રીના\u{a82} સ\u{ac7}ન\u{acd}ડલ"),
            keywords: &[
                "કપડા\u{a82}",
                "સ\u{ac7}ન\u{acd}ડલ",
                "સ\u{acd}ત\u{acd}રી",
                "સ\u{acd}ત\u{acd}રીના\u{a82} સ\u{ac7}ન\u{acd}ડલ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("sandal mace"),
            keywords: &["mace", "sandal", "sutura", "takalmi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סנדל של אישה"),
            keywords: &["אישה", "סנדל", "סנדל של אישה", "קיץ"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("महिलाओ\u{902} का स\u{948}\u{902}डल"),
            keywords: &[
                "पोषाक",
                "महिला",
                "महिलाओ\u{902} का स\u{948}\u{902}डल",
                "महिलाओ\u{902} क\u{947} स\u{948}\u{902}डल",
                "स\u{948}\u{902}डल",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("ženska sandala"),
            keywords: &["cipela", "obuća", "sandala", "žene", "ženska sandala"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("női szandál"),
            keywords: &["női szandál", "nők", "ruha", "ruházat", "szandál"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կնոջ սանդալ"),
            keywords: &["կին", "կնոջ սանդալ", "կոշիկ", "հագուստ", "սանդալ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("sandal wanita"),
            keywords: &["pakaian", "sandal", "sepatu", "wanita"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akpụkpọụkwụ nkechi ụmụnwanyị"),
            keywords: &[
                "akpụkpọụkwụ",
                "akpụkpọụkwụ nkechi",
                "akpụkpọụkwụ nkechi ụmụnwanyị",
                "na-eme akwà",
                "nwanyị",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kvensandali"),
            keywords: &["klæðnaður", "kvensandali", "kvenskór", "sandali"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("sandalo da donna"),
            keywords: &["abbigliamento", "donna", "sandalo", "sandalo da donna"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("サンダル"),
            keywords: &["サンダル", "靴"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sandhal wadon"),
            keywords: &["sandhal", "sandhangan", "sepatu", "wadon"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქალის სანდალი"),
            keywords: &[
                "სანდალი",
                "ტანსაცმელი",
                "ფეხსაცმელი",
                "ქალი",
                "ქალის სანდალი",
                "ქვიშა",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("әйелдер сандалы"),
            keywords: &["аяқ киім", "киім", "сандал", "әйел", "әйелдер сандалы"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("damesandaler"),
            keywords: &["damesandaler", "sandaler"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}បែងជើងកែងស\u{17ca}ក"),
            keywords: &[
                "ស\u{17d2}បែកជើងស\u{17d2}រ\u{17b8}",
                "ស\u{17d2}បែកជើស\u{17ca}ក",
                "ស\u{17d2}បែងជើងកែងស\u{17ca}ក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಹ\u{cbf}ಳ\u{cc6}ಯರ ಸ\u{ccd}ಯಾಂಡಲ\u{ccd}"),
            keywords: &[
                "ಚಪ\u{ccd}ಪಲ\u{cbf}",
                "ಮಹ\u{cbf}ಳ\u{cc6}ಯ ಚಪ\u{ccd}ಪಲ\u{cbf}ಗಳು",
                "ಮಹ\u{cbf}ಳ\u{cc6}ಯರ ಸ\u{ccd}ಯಾಂಡಲ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("샌들"),
            keywords: &["샌들", "신발", "여성용 샌들", "여성용 신발"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बायला\u{902}च\u{947} स\u{901}डल"),
            keywords: &[
                "कपड\u{947}",
                "जोत\u{947}\u{902}",
                "बायल",
                "बायला\u{902}च\u{947} स\u{901}डल",
                "बायला\u{902}च\u{947}\u{902} स\u{901}डल",
                "स\u{902}\u{901}डल",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("аялдар сандалиясы"),
            keywords: &["аял", "аялдар сандалиясы", "бут кийим", "кийим", "сандалия"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Fraesandal"),
            keywords: &["Fra", "Fraesandal", "Kleedung", "Sandal", "Schong"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເກ\u{eb5}ບແຕະແມ\u{ec8}ຍ\u{eb4}ງ"),
            keywords: &[
                "ເກ\u{eb5}ບແຕະ",
                "ເກ\u{eb5}ບແຕະແມ\u{ec8}ຍ\u{eb4}ງ",
                "ເສ\u{eb7}\u{ec9}ອຜ\u{ec9}າດ ແມ\u{ec8}ຍ\u{eb4}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("moteriška basutė"),
            keywords: &[
                "batas",
                "drabužiai",
                "moteris",
                "moteriška basutė",
                "sandalas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sieviešu sandale"),
            keywords: &["apavi", "sandale", "sieviešu"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kopa wahine"),
            keywords: &["hū", "kopa", "kākahu", "wahine"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("женска сандала"),
            keywords: &["женска сандала", "лето", "обувки", "сандали", "чевли"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d4d}\u{200c}ത\u{d4d}രീകള\u{d41}ടെ ചെര\u{d41}പ\u{d4d}പ\u{d4d}"),
            keywords: &[
                "പ\u{d3e}ദരക\u{d4d}ഷ",
                "വനിത",
                "വസ\u{d4d}ത\u{d4d}രം",
                "വിമൻസ\u{d4d} സ\u{d3e}ൻഡൽ",
                "ഷ\u{d42}",
                "സ\u{d3e}ൻഡൽ",
                "സ\u{d4d}\u{200c}ത\u{d4d}രീകള\u{d41}ടെ ചെര\u{d41}പ\u{d4d}പ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эмэгтэй углааш"),
            keywords: &["углааш", "хүн", "эмэгтэй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("महिला\u{902}च\u{947} स\u{901}डल"),
            keywords: &[
                "कपड\u{947}",
                "जोड\u{947}",
                "महिला",
                "महिला\u{902}च\u{947} स\u{901}डल",
                "स\u{901}डल",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("sandal wanita"),
            keywords: &["kasut", "pakaian", "sandal", "wanita"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("sandli ta’ mara"),
            keywords: &["mara", "sandli", "sandli ta’ mara", "ħwejjeġ", "żarbun"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမျ\u{102d}\u{102f}းသမ\u{102e}း ည\u{103e}ပ\u{103a}ဖ\u{102d}နပ\u{103a}"),
            keywords: &[
                "ကြ\u{102d}\u{102f}းသ\u{102d}\u{102f}င\u{103a}းဖ\u{102d}နပ\u{103a}",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း ည\u{103e}ပ\u{103a}ဖ\u{102d}နပ\u{103a}",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}းစ\u{102e}း ကြ\u{102d}\u{102f}းသ\u{102d}\u{102f}င\u{103a}းဖ\u{102d}နပ\u{103a}",
                "အဝတ\u{103a}အစား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("damesandal"),
            keywords: &["dame", "damesandal", "klær", "sandal", "sko"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("छोरी मान\u{94d}छ\u{947}को चप\u{94d}पल"),
            keywords: &[
                "कपडा",
                "छोरी मान\u{94d}छ\u{947}",
                "छोरी मान\u{94d}छ\u{947}को चप\u{94d}पल",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("damessandaal"),
            keywords: &["damessandaal", "kleding", "sandaal", "schoen", "vrouw"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("damesandal"),
            keywords: &["dame", "damesandal", "klede", "sandal", "sko"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମହ\u{b3f}ଳ\u{b3e}ଙ\u{b4d}କ ଚପଲ"),
            keywords: &[
                "ଚପଲ",
                "ପୋଷ\u{b3e}କ ପର\u{b3f}ଚ\u{b4d}ଛଦ",
                "ମହ\u{b3f}ଳ\u{b3e}",
                "ମହ\u{b3f}ଳ\u{b3e}ଙ\u{b4d}କ ଚପଲ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਔਰਤ ਦਾ ਸ\u{a48}\u{a02}ਡਲ"),
            keywords: &[
                "ਔਰਤ",
                "ਔਰਤ ਦਾ ਸ\u{a48}\u{a02}ਡਲ",
                "ਔਰਤ ਲਈ ਸ\u{a48}\u{a02}ਡਲ",
                "ਲਿਬਾਸ",
                "ਸ\u{a48}\u{a02}ਡਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("زنانیاں دے سینڈل"),
            keywords: &["جوتا", "زنانی", "زنانیاں دے سینڈل", "سینڈل", "کپڑے"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wúmán Sándal"),
            keywords: &["Klọt", "Shu", "Sándal", "Wúman", "Wúmán Sándal"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("sandał damski"),
            keywords: &["but", "damski", "obuwie", "sandał"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښځینه سینډل"),
            keywords: &["بوټان", "سینډل", "لباس", "ښځه", "ښځینه سینډل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("sandália feminina"),
            keywords: &["acessório", "feminino", "sandália feminina", "sandálias"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("sandália de senhora"),
            keywords: &[
                "calçado",
                "sandália",
                "sandália de senhora",
                "senhora",
                "vestuário",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("warmip sandalian"),
            keywords: &["warmip sandalian"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("sanda de damă"),
            keywords: &[
                "femeie",
                "feminin",
                "pantof",
                "sanda de damă",
                "încălțăminte",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-542"),
            keywords: &["E10-542"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("босоножки"),
            keywords: &[
                "босоножки",
                "женщина",
                "каблук",
                "лето",
                "обувь",
                "сандалии",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("sandale z’abagore"),
            keywords: &[
                "sandale z’abagore",
                "sandari",
                "umugore",
                "umwambaro",
                "urukweto",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عورت جو سينڊل"),
            keywords: &["جوتو", "سينڊل", "عورت", "عورت جو سينڊل", "لباس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dcf}න\u{dca}ත\u{dcf} පට\u{dd2} සපත\u{dca}ත\u{dd4}ව"),
            keywords: &[
                "ඇඳ\u{dd4}ම\u{dca}",
                "ක\u{dcf}න\u{dca}ත\u{dcf} පට\u{dd2} සපත\u{dca}ත\u{dd4}ව",
                "ක\u{dcf}න\u{dca}ත\u{dcf}ව",
                "සපත\u{dca}ත\u{dd4}ව",
                "සැඬලය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("dámsky sandál"),
            keywords: &["dámsky sandál", "oblečenie", "sandál", "topánka", "žena"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ženski sandali"),
            keywords: &["oblačila", "sandal", "čevelj", "ženska", "ženski sandali"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("sandhalka dumarka"),
            keywords: &["dhar", "gabadh", "kabo", "sandhal", "sandhalka dumarka"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("sandale femrash"),
            keywords: &["femër", "këpucë", "sandale", "sandale femrash", "veshje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("женска сандала"),
            keywords: &["жена", "женска сандала", "одећа", "сандала", "ципела"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["женска сандала"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ženska sandala"),
            keywords: &["cipela", "odeća", "sandala", "žena", "ženska sandala"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["ženska sandala"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("damsandal"),
            keywords: &["damsandal", "sandal", "sko"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ndara ya mwanamke"),
            keywords: &["kiatu", "mavazi", "mwanamke", "ndara", "ndara ya mwanamke"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பெண\u{bcd}கள\u{bcd} செருப\u{bcd}பு"),
            keywords: &[
                "ஆடை அணிகலன\u{bcd}",
                "ச\u{bbe}ண\u{bcd}டல\u{bcd}",
                "செருப\u{bcd}பு",
                "பெண\u{bcd}கள\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c4d}త\u{c4d}ర\u{c40}ల చ\u{c46}ప\u{c4d}పులు"),
            keywords: &[
                "చ\u{c46}ప\u{c4d}పులు",
                "స\u{c4d}త\u{c4d}ర\u{c40}",
                "స\u{c4d}త\u{c4d}ర\u{c40}ల చ\u{c46}ప\u{c4d}పులు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("кафши сабуки занона"),
            keywords: &[
                "зан",
                "кафши сабук",
                "кафши сабуки занона",
                "либос",
                "пойафзол",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รองเท\u{e49}าแตะผ\u{e39}\u{e49}หญ\u{e34}ง"),
            keywords: &[
                "ผ\u{e39}\u{e49}หญ\u{e34}ง",
                "รองเท\u{e49}า",
                "รองเท\u{e49}าแตะ",
                "รองเท\u{e49}าแตะผ\u{e39}\u{e49}หญ\u{e34}ง",
                "เส\u{e37}\u{e49}อผ\u{e49}า",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("aýal çepegi"),
            keywords: &["aýal çepegi", "eşik", "köwüş", "zenan", "şypbyk"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("saniteli fakafefine"),
            keywords: &["saniteli fakafefine"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kadın sandaleti"),
            keywords: &["giyim", "kadın", "kadın sandaleti", "sandalet"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئايالچە سالقىن ئاياغ"),
            keywords: &["ئاياغ", "ئايال", "ئايالچە سالقىن ئاياغ", "سالقىن", "كىيىم"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("жіноча сандалія з підбором"),
            keywords: &[
                "взуття",
                "жінка",
                "жіноча сандалія з підбором",
                "одяг",
                "сандалі",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("عورت کی سینڈل"),
            keywords: &["جوتا", "سینڈل", "عورت", "عورت کی سینڈل", "لباس"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ayollar shippagi"),
            keywords: &["ayol", "ayollar shippagi", "kiyim", "shippak", "tufli"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("xăng đan nữ"),
            keywords: &["giày", "phụ nữ", "quần áo", "xăng đan", "xăng đan nữ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("caraxu jigéen"),
            keywords: &["carax", "caraxu jigéen", "dàll", "jigéen", "yéere"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("imbadada yebhinqa"),
            keywords: &[
                "ibhinqa",
                "imbadada",
                "imbadada yebhinqa",
                "impahla",
                "isihlangu",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bata Obinrin pẹlẹbẹ"),
            keywords: &[
                "Bata Obinrin pẹlẹbẹ",
                "aṣọ",
                "bàtà",
                "bátá pẹlẹbẹ",
                "obìnrin",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("女裝涼鞋"),
            keywords: &["女士", "女裝涼鞋", "服裝", "涼鞋", "鞋"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("女装凉鞋"),
            keywords: &["凉鞋", "女士", "女装凉鞋", "服装", "鞋"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("女式凉鞋"),
            keywords: &["凉鞋", "女", "女式凉鞋"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("涼鞋"),
            keywords: &["拖鞋", "涼鞋"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("amasendeli owesimame"),
            keywords: &["amasendeli", "impahla yokugqoka", "isicathulo", "owesimame"],
        },
    ],
};
#[doc = "🩰"]
pub const BALLET_SHOES: crate::Emoji = crate::Emoji {
    glyph: "🩰",
    codepoint: "1FA70",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "ballet shoes",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("balletskoene"),
            keywords: &["ballet", "balletskoene", "dans"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የባሌ ዳንስ ጫማ"),
            keywords: &["የባሌ ዳንስ", "የባሌ ዳንስ ጫማ", "ዳንስ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("حذاء باليه"),
            keywords: &["باليه", "حذاء باليه", "رقص"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বেলেট শ\u{9cd}ব\u{9c1}"),
            keywords: &["ন\u{9c3}ত\u{9cd}য", "বেলেট", "বেলেট শ\u{9cd}ব\u{9c1}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("balet ayaqqabıları"),
            keywords: &["balet", "balet ayaqqabıları", "rəqs"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("пуанты"),
            keywords: &["балет", "пуанты", "танец"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("балетни обувки"),
            keywords: &["балет", "балетни обувки", "танц"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9cd}য\u{9be}লের জ\u{9c1}তো"),
            keywords: &[
                "ন\u{9be}চ",
                "ব\u{9cd}য\u{9be}লে",
                "ব\u{9cd}য\u{9be}লের জ\u{9c1}তো",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("baletske cipele"),
            keywords: &["balet", "baletske cipele", "ples"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("sabatilles de ballet"),
            keywords: &["ballet", "dansa", "sabatilles de ballet"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎳᏍᎩᏍᏗ ᏗᎳᏑᎶ"),
            keywords: &["ᎠᎳᏍᎩᎠ", "ᎠᎳᏍᎩᏍᏗ", "ᎠᎳᏍᎩᏍᏗ ᏗᎳᏑᎶ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("baletní piškoty"),
            keywords: &["balet", "baletní piškoty", "tanec"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("esgidiau bale"),
            keywords: &["bale", "dawnsio", "esgidiau bale"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("balletsko"),
            keywords: &["ballet", "balletsko", "dans"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Ballettschuhe"),
            keywords: &["Ballett", "Ballettschuhe", "Tanz"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("παπούτσια μπαλέτου"),
            keywords: &["μπαλέτο", "παπούτσια μπαλέτου", "χορός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("ballet shoes"),
            keywords: &["ballet", "ballet shoes", "dance"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("zapatillas de ballet"),
            keywords: &["bailar", "ballet", "balé", "danza", "zapatillas de ballet"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["bailar", "ballet", "danza", "zapatillas de ballet"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("balletikingad"),
            keywords: &["balletikingad", "ballett", "tants"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("balleteko oin-puntak"),
            keywords: &["ballet", "balleteko oin-puntak", "dantza"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کفش باله"),
            keywords: &["باله", "رقص", "کفش باله"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("balettitossut"),
            keywords: &["baletti", "balettitossut", "tanssi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("sapatos pang-ballet"),
            keywords: &[
                "ballet",
                "sapatos na pang-ballet",
                "sapatos na pansayaw",
                "sapatos pang-ballet",
                "sayaw",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("balletskógvar"),
            keywords: &[
                "ballet",
                "balletskógvar",
                "dansa",
                "dansiskógvar",
                "skógvar",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("chaussons de danse"),
            keywords: &["ballet", "chaussons de danse", "chaussures", "danse"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bróga bailé"),
            keywords: &["bailé", "bróga bailé", "damhsa"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("brògan ballet"),
            keywords: &["baileat", "ballet", "brògan ballet", "dannsa"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("bailarinas"),
            keywords: &["bailarinas", "baile", "ballet", "zapatillas"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બ\u{ac7}લ\u{ac7} શ\u{ac2}ઝ"),
            keywords: &[
                "ન\u{ac3}ત\u{acd}ય, ડા\u{a82}સ",
                "બ\u{ac7}લ\u{ac7}",
                "બ\u{ac7}લ\u{ac7} શ\u{ac2}ઝ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("נעלי בלט"),
            keywords: &["בלט", "נעלי בלט", "נעליים", "ריקוד"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ब\u{948}ल\u{947}ट ज\u{942}त\u{947}"),
            keywords: &["ज\u{942}त\u{947}", "ब\u{948}ल\u{947}ट"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("baletne papučice"),
            keywords: &["balet", "baletne papučice", "ples"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("balettcipő"),
            keywords: &["balett", "balettcipő", "tánc"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բալետի կոշիկ"),
            keywords: &["բալետ", "բալետի կոշիկ", "պար"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("sepatu balet"),
            keywords: &["balet", "menari", "sepatu balet", "tari", "tarian"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("balletskór"),
            keywords: &["ballet", "balletskór", "dans"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("scarpette da ballerina"),
            keywords: &[
                "balletto",
                "danza",
                "danza classica",
                "scarpette da ballerina",
                "scarpette da ballo",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("トウシューズ"),
            keywords: &["シューズ", "ダンス", "トウシューズ", "バレエ", "靴"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sepatu balet"),
            keywords: &["balet", "sepatu balet", "tarian"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("პუანტები"),
            keywords: &["ბალეტი", "პუანტები", "პუანტი", "საბალეტო ფეხსაცმელი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("балетшінің аяқ киімі"),
            keywords: &["балет", "балетшінің аяқ киімі", "би"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ស\u{17d2}បែកជើងសម\u{17d2}រាប\u{17cb}\u{200b}រា\u{17c6}របា\u{17c6}\u{200b}បាឡេ",
            ),
            keywords: &[
                "របា\u{17c6}បាឡេ",
                "រា\u{17c6}",
                "ស\u{17d2}បែកជើងសម\u{17d2}រាប\u{17cb}\u{200b}រា\u{17c6}របា\u{17c6}\u{200b}បាឡេ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{ccd}ಯಾಲ\u{cc6}ಟ\u{ccd} ಶ\u{cc2}ಸ\u{ccd}"),
            keywords: &[
                "ಡ\u{ccd}ಯಾನ\u{ccd}ಸ\u{ccd}",
                "ಬ\u{ccd}ಯಾಲ\u{cc6}ಟ\u{ccd}",
                "ಬ\u{ccd}ಯಾಲ\u{cc6}ಟ\u{ccd} ಶ\u{cc2}ಸ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("발레 슈즈"),
            keywords: &["발레", "발레 슈즈", "춤"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ब\u{945}ल\u{947} श\u{942}ज"),
            keywords: &["नाच", "ब\u{945}ल\u{947}", "ब\u{945}ल\u{947} श\u{942}ज"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("балет бут кийими"),
            keywords: &["балет", "балет бут кийими", "бий"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເກ\u{eb5}ບ\u{200b}ເຕ\u{eb1}\u{ec9}ນ\u{200b}ບ\u{eb1}ນ\u{200b}ເລ\u{ec9}"),
            keywords: &[
                "ບ\u{eb1}\u{200b}ນ\u{200b}ເລ\u{ec9}",
                "ເກ\u{eb5}ບ",
                "ເກ\u{eb5}ບ\u{200b}ເຕ\u{eb1}\u{ec9}ນ\u{200b}ບ\u{eb1}ນ\u{200b}ເລ\u{ec9}",
                "ເຕ\u{eb1}\u{ec9}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("baleto bateliai"),
            keywords: &["baletas", "baleto bateliai", "šokis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("baleta kurpes"),
            keywords: &["baleta kurpes", "balets", "deja"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("балетанки"),
            keywords: &["балет", "балетанки", "танц"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ബ\u{d3e}ലേ ഷ\u{d42}സ\u{d4d}"),
            keywords: &[
                "ന\u{d43}ത\u{d4d}തം",
                "ബ\u{d3e}ലെ",
                "ബ\u{d3e}ലേ ഷ\u{d42}സ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("балетын шаахай"),
            keywords: &["балет", "балетын шаахай", "бүжиг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("न\u{943}त\u{94d}यनाट\u{94d}य करताना घालायच\u{947} जोड\u{947}"),
            keywords: &[
                "न\u{943}त\u{94d}य",
                "न\u{943}त\u{94d}यनाट\u{94d}य",
                "न\u{943}त\u{94d}यनाट\u{94d}य करताना घालायच\u{947} जोड\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kasut balet"),
            keywords: &["balet", "kasut balet", "tarian"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဘ\u{1032}လေးရ\u{103e}\u{1030}းဖ\u{102d}နပ\u{103a}"),
            keywords: &[
                "ဘ\u{1032}လေး",
                "ဘ\u{1032}လေးရ\u{103e}\u{1030}းဖ\u{102d}နပ\u{103a}",
                "အက",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("ballettsko"),
            keywords: &["ballett", "ballettsko", "dans"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ब\u{94d}याल\u{947}ट ज\u{941}त\u{94d}ता"),
            keywords: &[
                "नाच",
                "ब\u{94d}याल\u{947}ट",
                "ब\u{94d}याल\u{947}ट ज\u{941}त\u{94d}ता",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("balletschoenen"),
            keywords: &["ballet", "balletschoenen", "dans"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("ballettsko"),
            keywords: &["ballett", "ballettsko", "dans"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b4d}ୟ\u{b3e}ଲେଟ\u{b4d}\u{200c} ଜୋତ\u{b3e}"),
            keywords: &[
                "ନ\u{b3e}ଚ",
                "ବ\u{b4d}ୟ\u{b3e}ଲେଟ\u{b4d}\u{200c}",
                "ବ\u{b4d}ୟ\u{b3e}ଲେଟ\u{b4d}\u{200c} ଜୋତ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a48}ਲ\u{a47} ਲਈ ਜ\u{a41}\u{a71}ਤ\u{a47}"),
            keywords: &[
                "ਨਾਚ",
                "ਬ\u{a48}ਲ\u{a47}",
                "ਬ\u{a48}ਲ\u{a47} ਲਈ ਜ\u{a41}\u{a71}ਤ\u{a47}",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Shu Fọ Ték Dáns Balẹ\u{301}t Dans"),
            keywords: &[
                "Balẹt",
                "Balẹ\u{301}t Shu",
                "Dans",
                "Shu Fọ Ték Dáns Balẹ\u{301}t Dans",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("baletki"),
            keywords: &["balet", "baletki", "taniec"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د نڅا پېزار"),
            keywords: &["د نڅا پېزار", "نڅا", "يو ډول نڅا"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("sapatilha de balé"),
            keywords: &["balé", "dança", "sapatilha de balé"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("sapatos de ballet"),
            keywords: &["ballet", "dança", "sapatos de ballet"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pantofi de balet"),
            keywords: &["balet", "dans", "pantofi de balet"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–059"),
            keywords: &["E12–059"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("пуанты"),
            keywords: &["балерина", "балет", "обувь", "пуанты", "танец", "туфли"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بيليٽ جوتا"),
            keywords: &["بليٽ", "بيليٽ جوتا", "ڊانس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බැලට\u{dca} සපත\u{dca}ත\u{dd4}"),
            keywords: &[
                "නර\u{dca}තනය",
                "බැලට\u{dca}",
                "බැලට\u{dca} සපත\u{dca}ත\u{dd4}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("baletné špice"),
            keywords: &["balet", "baletné špice", "tanec"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("baletni čeveljci"),
            keywords: &["balet", "baletni čeveljci", "ples"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kabaha ballet-ka"),
            keywords: &["kabaha ballet-ka", "qoob-ka-cayaarka ballet"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("këpucë baleti"),
            keywords: &["balet", "këpucë", "këpucë baleti", "kërcim"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("балетске патике"),
            keywords: &["балет", "балетске патике", "плес"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("baletske patike"),
            keywords: &["balet", "baletske patike", "ples"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ballettskor"),
            keywords: &["balett", "ballettskor", "dans"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("viatu vya bale"),
            keywords: &["bale", "densi", "viatu vya bale"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ப\u{bbe}லே க\u{bbe}லணிகள\u{bcd}"),
            keywords: &[
                "க\u{bbe}லணி",
                "நடனம\u{bcd}",
                "ப\u{bbe}லே",
                "ப\u{bbe}லே க\u{bbe}லணிகள\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బ\u{c4d}య\u{c3e}ల\u{c47} షూలు"),
            keywords: &[
                "నృత\u{c4d}యం",
                "బ\u{c4d}య\u{c3e}ల\u{c47}",
                "బ\u{c4d}య\u{c3e}ల\u{c47} షూలు",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รองเท\u{e49}าบ\u{e31}ลเล\u{e48}ต\u{e4c}"),
            keywords: &[
                "บ\u{e31}ลเล\u{e48}ต\u{e4c}",
                "รองเท\u{e49}าบ\u{e31}ลเล\u{e48}ต\u{e4c}",
                "เต\u{e49}น",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("balet köwşi"),
            keywords: &["balet", "balet köwşi", "tans"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sū faiva pālangi"),
            keywords: &["sū faiva pālangi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("bale ayakkabıları"),
            keywords: &["bale", "bale ayakkabıları", "dans"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("балетні туфлі"),
            keywords: &["балет", "балетні туфлі", "пуанти", "танцювальні"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("رقص کے جوتے"),
            keywords: &["رقص", "رقص کے جوتے", "ڈانس"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("balet poyafzali"),
            keywords: &["balet", "balet poyafzali", "raqs"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("giày múa balê"),
            keywords: &["balê", "giày múa balê", "múa"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("芭蕾舞鞋"),
            keywords: &["芭蕾舞", "芭蕾舞鞋", "跳舞"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("芭蕾舞鞋"),
            keywords: &["芭蕾舞", "芭蕾舞鞋", "跳舞"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("芭蕾舞鞋"),
            keywords: &["舞蹈", "舞鞋", "芭蕾舞鞋", "足尖鞋", "跳舞"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("芭蕾舞鞋"),
            keywords: &["舞", "芭蕾", "芭蕾舞鞋"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("izicathulo ze-ballet"),
            keywords: &["izicathulo ze-ballet"],
        },
    ],
};
#[doc = "👢"]
pub const WOMANS_BOOT: crate::Emoji = crate::Emoji {
    glyph: "👢",
    codepoint: "1F462",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "woman’s boot",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vrouestewel"),
            keywords: &["klere", "skoen", "stewel", "vrou", "vrouestewel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሴት ቡትስ ጫማ"),
            keywords: &["ሴት", "ቡትስ", "አልባሳት", "የሴት ቡትስ ጫማ", "ጫማ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("حذاء طويل الساق حريمي"),
            keywords: &["حذاء طويل الساق حريمي", "حذاء عال", "ملابس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মহিল\u{9be}ৰ ব\u{9c1}ট"),
            keywords: &[
                "জোত\u{9be}",
                "পোছ\u{9be}ক",
                "ব\u{9c1}ট",
                "মহিল\u{9be}",
                "মহিল\u{9be}ৰ ব\u{9c1}ট",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qadın çəkməsi"),
            keywords: &["ayaqqabı", "geyim", "qadın", "qadın çəkməsi", "çəkmə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("жаночы бот"),
            keywords: &["абутак", "боты", "жаночы бот", "жанчына"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Дамски ботуш"),
            keywords: &["Дамски ботуш", "ботуш", "жена", "облекло", "обувка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মহিল\u{9be}দের ব\u{9c1}ট"),
            keywords: &[
                "জ\u{9c1}তো",
                "ন\u{9be}রী",
                "পোশ\u{9be}ক",
                "ব\u{9c1}ট",
                "মহিল\u{9be}দের ব\u{9c1}ট",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ženska čizma"),
            keywords: &["obuća", "čizma", "žena", "ženska čizma"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bota de dona"),
            keywords: &["bota", "bota de dona", "calçat", "dona"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ ᎤᎳᏑᎶᎢ"),
            keywords: &["ᎠᎨᏯ", "ᎠᎨᏯ ᎤᎳᏑᎶᎢ", "ᎠᎳᏑᎶ", "ᏗᎦᎵᏲᏍᏗ", "ᏗᎿᏬ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("dámská kozačka"),
            keywords: &["bota", "dámská kozačka", "kozačka", "oblečení", "žena"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("esgid fenyw"),
            keywords: &["dillad", "esgid", "esgid fenyw", "menyw"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("damestøvle"),
            keywords: &["damestøvle", "støvler"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Damenstiefel"),
            keywords: &["Damen", "Damenstiefel", "Schuh", "Stiefel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γυναικεία μπότα"),
            keywords: &[
                "γυναίκα",
                "γυναικεία μπότα",
                "μπότα",
                "παπούτσι",
                "ρουχισμός",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("woman’s boot"),
            keywords: &["boot", "clothing", "shoe", "woman", "woman’s boot"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bota de mujer"),
            keywords: &["bota", "bota de mujer", "calzado", "mujer", "ropa"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["bota", "bota de mujer", "mujer", "ropa", "vestimenta"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("naistesaabas"),
            keywords: &["king", "naine", "naistesaabas", "riided", "saabas"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("emakumeentzako bota"),
            keywords: &[
                "arropa",
                "bota",
                "emakume",
                "emakumeentzako bota",
                "oinetako",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پوتین زنانه"),
            keywords: &["بوت", "زن", "پوتین", "پوتین زنانه", "پوشاک", "چکمه", "کفش"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("naisen saapas"),
            keywords: &["kenkä", "nainen", "naisen saapas", "saapas", "vaatteet"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pambabaeng boots"),
            keywords: &[
                "boots",
                "kasuotan",
                "pambabae",
                "pambabaeng boots",
                "sapatos",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("konufólkastilvi"),
            keywords: &[
                "klæði",
                "kona",
                "konufólk",
                "konufólkastilvi",
                "kvinna",
                "skógvur",
                "stivli",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("botte de femme"),
            keywords: &["botte", "botte de femme", "chaussure", "vêtements"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["botte", "botte de femme", "chaussure", "femme", "vêtements"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("buataisí mná"),
            keywords: &["bróg", "buatais", "buataisí mná"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bòtann boireannaich"),
            keywords: &[
                "aodach",
                "boireannach",
                "bròg",
                "bòtann",
                "bòtann boireannaich",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("botas de muller"),
            keywords: &["botas", "botas de muller", "calzado", "muller"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}ત\u{acd}રીના બ\u{ac2}ટ"),
            keywords: &[
                "કપડા\u{a82}",
                "બ\u{ac2}ટ",
                "સ\u{acd}ત\u{acd}રી",
                "સ\u{acd}ત\u{acd}રીના બ\u{ac2}ટ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("but na mace"),
            keywords: &["but", "but na mace", "mace", "sutura", "takalmi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מגף של אישה"),
            keywords: &["אישה", "חורף", "מגף", "מגף של אישה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("महिलाओ\u{902} का ब\u{942}ट"),
            keywords: &[
                "पोषाक",
                "ब\u{942}ट",
                "महिला",
                "महिलाओ\u{902} का ब\u{942}ट",
                "महिलाओ\u{902} क\u{947} ब\u{942}ट",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("ženska čizma"),
            keywords: &["cipela", "obuća", "čizma", "žene", "ženska čizma"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("női csizma"),
            keywords: &["csizma", "lábbeli", "női csizma", "nők", "ruha", "ruházat"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կնոջ երկարաճիթք կոշիկ"),
            keywords: &[
                "երկարաճիթք կոշիկ",
                "կին",
                "կնոջ երկարաճիթք կոշիկ",
                "կոշիկ",
                "հագուստ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("sepatu bot wanita"),
            keywords: &["bot", "pakaian", "sepatu bot wanita", "wanita"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akpụkpọụkwụ akpụkpọanụ ụmụnwanyị"),
            keywords: &[
                "akpụkpọụkwụ",
                "akpụkpọụkwụ akpụkpọanụ",
                "akpụkpọụkwụ akpụkpọanụ ụmụnwanyị",
                "na-eme akwà",
                "nwanyị",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kvenstígvél"),
            keywords: &["klæðnaður", "kvenskór", "kvenstígvél", "stígvél"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("stivale da donna"),
            keywords: &["abbigliamento", "donna", "stivale", "stivale da donna"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ブーツ"),
            keywords: &["ブーツ", "ロングブーツ", "靴"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sepatu bot wadon"),
            keywords: &["bot", "sandhangan", "sepatu", "wadon"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქალის ჩექმა"),
            keywords: &["ტანსაცმელი", "ფეხსაცმელი", "ქალი", "ქალის ჩექმა", "ჩექმა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("әйелдер етігі"),
            keywords: &["аяқ киім", "етік", "киім", "әйел", "әйелдер етігі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("damestøvler"),
            keywords: &["damestøvler", "støvler"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}បែកជើងកវែងនារ\u{17b8}"),
            keywords: &[
                "ស\u{17d2}បែកជើងកវែង",
                "ស\u{17d2}បែកជើងកវែងនារ\u{17b8}",
                "ស\u{17d2}បែកជើងស\u{17d2}រ\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಹ\u{cbf}ಳ\u{cc6}ಯರ ಬ\u{cc2}ಟು"),
            keywords: &[
                "ಬ\u{cc2}ಟ\u{ccd}",
                "ಮಹ\u{cbf}ಳ\u{cc6}ಯ ಬ\u{cc2}ಟ\u{ccd}",
                "ಮಹ\u{cbf}ಳ\u{cc6}ಯರ ಬ\u{cc2}ಟು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("부츠"),
            keywords: &["부츠", "신발", "여성용 부츠", "여성용 신발"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बायला\u{902}च\u{947} ब\u{942}ट"),
            keywords: &[
                "कपड\u{947}",
                "जोत\u{947}\u{902}",
                "बायल",
                "बायला\u{902}च\u{947} ब\u{942}ट",
                "ब\u{942}ट",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("аялдар өтүгү"),
            keywords: &["аял", "аялдар өтүгү", "бут кийим", "кийим", "өтүк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Fraestiwwel"),
            keywords: &["Fra", "Fraestiwwel", "Kleedung", "Schong", "Stiwwel"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເກ\u{eb5}ບບ\u{eb9}ດແມ\u{ec8}ຍ\u{eb4}ງ"),
            keywords: &[
                "ເກ\u{eb5}ບບ\u{eb9}ດ",
                "ເກ\u{eb5}ບບ\u{eb9}ດແມ\u{ec8}ຍ\u{eb4}ງ",
                "ແມ\u{ec8}ຍ\u{eb4}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("moteriškas batas"),
            keywords: &[
                "batas",
                "batelis",
                "drabužiai",
                "moteris",
                "moteriškas batas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sieviešu zābaks"),
            keywords: &["apavi", "sieviešu", "zābaks"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pūtu wahine"),
            keywords: &["hū", "kākahu", "pūtu", "wahine"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("женска чизма"),
            keywords: &["женска чизма", "зима", "обувки", "чевли", "чизми"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d4d}\u{200c}ത\u{d4d}രീകള\u{d41}ടെ ബ\u{d42}ട\u{d4d}ട\u{d4d}"),
            keywords: &[
                "പ\u{d3e}ദരക\u{d4d}ഷ",
                "ബ\u{d42}ട\u{d4d}ട\u{d4d}",
                "വനിത",
                "വസ\u{d4d}ത\u{d4d}രം",
                "വിമൻസ\u{d4d} ബ\u{d42}ട\u{d4d}ട\u{d4d}",
                "സ\u{d4d}\u{200c}ത\u{d4d}രീകള\u{d41}ടെ ബ\u{d42}ട\u{d4d}ട\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эмэгтэй гутал"),
            keywords: &["гутал", "хүн", "эмэгтэй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("महिला\u{902}च\u{947} जोड\u{947}"),
            keywords: &[
                "कपड\u{947}",
                "ब\u{942}ट",
                "महिला",
                "महिला\u{902}च\u{947} जोड\u{947}",
                "महिला\u{902}च\u{947} ब\u{942}ट",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("but wanita"),
            keywords: &["but", "kasut", "pakaian", "wanita"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("buts ta’ mara"),
            keywords: &["buts", "buts ta’ mara", "mara", "ħwejjeġ", "żarbun"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမျ\u{102d}\u{102f}းသမ\u{102e}း ဘ\u{103d}တ\u{103a}ဖ\u{102d}နပ\u{103a}"),
            keywords: &[
                "ဘ\u{103d}တ\u{103a}ဖ\u{102d}နပ\u{103a}",
                "မ\u{102d}န\u{103a}းမစ\u{102e}း ဘ\u{103d}တ\u{103a}ဖ\u{102d}နပ\u{103a}",
                "ရ\u{103e}\u{1030}းဖ\u{102d}နပ\u{103a}",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း",
                "အဝတ\u{103a}အစား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("damestøvlett"),
            keywords: &["dame", "damestøvlett", "klær", "sko", "støvlett"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("छोरी मान\u{94d}छ\u{947}को ब\u{941}ट ज\u{941}त\u{94d}ता"),
            keywords: &[
                "कपडा",
                "छोरी मान\u{94d}छ\u{947}",
                "छोरी मान\u{94d}छ\u{947}को ब\u{941}ट ज\u{941}त\u{94d}ता",
                "ज\u{941}त\u{94d}ता",
                "ब\u{941}ट",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("dameslaars"),
            keywords: &["dameslaars", "kleding", "laars", "schoen", "vrouw"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("damestøvlett"),
            keywords: &[
                "dame",
                "damestøvlett",
                "damstøvlett",
                "klede",
                "sko",
                "støvlett",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମହ\u{b3f}ଳ\u{b3e}ଙ\u{b4d}କ ଜୋତ\u{b3e}"),
            keywords: &[
                "ପୋଷ\u{b3e}କ ପର\u{b3f}ଚ\u{b4d}ଛଦ",
                "ବ\u{b41}ଟ\u{b4d}\u{200c}",
                "ମହ\u{b3f}ଳ\u{b3e}",
                "ମହ\u{b3f}ଳ\u{b3e}ଙ\u{b4d}କ ଜୋତ\u{b3e}",
                "ମହ\u{b3f}ଳ\u{b3e}ଙ\u{b4d}କ ବ\u{b41}ଟ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਔਰਤਾ\u{a02} ਦਾ ਬ\u{a42}ਟ"),
            keywords: &[
                "ਔਰਤ",
                "ਔਰਤਾ\u{a02} ਦਾ ਬ\u{a42}ਟ",
                "ਔਰਤਾ\u{a02} ਲਈ ਬ\u{a42}ਟ",
                "ਬ\u{a42}ਟ",
                "ਲਿਬਾਸ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("زنانیاں دے بوٹ"),
            keywords: &["ب\u{64f}وٹ", "جوتا", "زنانی", "زنانیاں دے بوٹ", "کپڑے"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wúmán But"),
            keywords: &["But", "Klọt", "Shu", "Wúman", "Wúmán But"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kozak damski"),
            keywords: &["kozaczek", "kozak damski"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښځینه موزي"),
            keywords: &["بوټان", "لباس", "موزي", "ښځه", "ښځینه موزي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bota feminina"),
            keywords: &["acessório", "bota feminina", "botas", "feminino"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("bota de senhora"),
            keywords: &["bota", "bota de senhora", "calçado", "senhora", "vestuário"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("warmip botan"),
            keywords: &["warmip botan"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cizmă de damă"),
            keywords: &[
                "cizmă de damă",
                "femeie",
                "feminin",
                "pantof",
                "încălțăminte",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-543"),
            keywords: &["E10-543"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("сапог"),
            keywords: &["высокая", "каблук", "обувь", "сапог", "сапоги", "холодно"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("bote z’abagore"),
            keywords: &["bote", "bote z’abagore", "umugore", "umwambaro", "urukweto"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عورت جو بوٽ"),
            keywords: &["بوٽ", "جوتو", "عورت", "عورت جو بوٽ", "لباس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dcf}න\u{dca}ත\u{dcf} බ\u{dd6}ට\u{dca} සපත\u{dca}ත\u{dd4}ව"),
            keywords: &[
                "ඇඳ\u{dd4}ම\u{dca}",
                "ක\u{dcf}න\u{dca}ත\u{dcf} බ\u{dd6}ට\u{dca} සපත\u{dca}ත\u{dd4}ව",
                "ක\u{dcf}න\u{dca}ත\u{dcf}ව",
                "බ\u{dd6}ට\u{dca} සපත\u{dca}ත\u{dd4}ව",
                "සපත\u{dca}ත\u{dd4}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("dámska čižma"),
            keywords: &["dámska čižma", "oblečenie", "obuv", "čižma", "žena"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ženski škorenj"),
            keywords: &["oblačila", "čevelj", "škorenj", "ženska", "ženski škorenj"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("buudh dumar"),
            keywords: &["buudh", "dhar", "dumar", "kabo"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("çizme femrash"),
            keywords: &["femër", "këpucë", "veshje", "çizme", "çizme femrash"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("женска чизма"),
            keywords: &["oбућa", "жeнe", "женска чизма", "ципeлa", "чизмa"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ženska čizma"),
            keywords: &["cipela", "obuća", "čizma", "žene", "ženska čizma"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("damstövel"),
            keywords: &["damstövel", "sko", "stövel"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("buti la mwanamke"),
            keywords: &["buti", "buti la mwanamke", "kiatu", "mavazi", "mwanamke"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பெண\u{bcd}கள\u{bcd} பூட\u{bcd}"),
            keywords: &["ஆடை அணிகலன\u{bcd}", "பூட\u{bcd}", "பெண\u{bcd}கள\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c4d}త\u{c4d}ర\u{c40}ల బూట\u{c4d}లు"),
            keywords: &[
                "బూట\u{c4d}లు",
                "స\u{c4d}త\u{c4d}ర\u{c40}",
                "స\u{c4d}త\u{c4d}ర\u{c40}ల బూట\u{c4d}లు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("мӯзаи занона"),
            keywords: &["ботинка", "зан", "либос", "мӯзаи занона", "пойафзол"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รองเท\u{e49}าบ\u{e39}\u{e4a}ตผ\u{e39}\u{e49}หญ\u{e34}ง"),
            keywords: &[
                "ผ\u{e39}\u{e49}หญ\u{e34}ง",
                "รองเท\u{e49}าบ\u{e39}\u{e4a}ต",
                "รองเท\u{e49}าบ\u{e39}\u{e4a}ตผ\u{e39}\u{e49}หญ\u{e34}ง",
                "เส\u{e37}\u{e49}อผ\u{e49}า",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("aýal ädigi"),
            keywords: &["aýal ädigi", "eşik", "köwüş", "zenan", "ädik"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sū puti fakafefine"),
            keywords: &["sū puti fakafefine"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kadın botu"),
            keywords: &["bot", "giyim", "kadın", "kadın botu"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئايالچە ئۆتۈك"),
            keywords: &["ئاياغ", "ئايال", "ئايالچە ئۆتۈك", "ئۆتۈك", "كىيىم"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("жіночий чобіт"),
            keywords: &["взуття", "жінка", "жіночий чобіт", "одяг", "чобіт"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("عورت کا بوٹ"),
            keywords: &["بوٹ", "جوتا", "عورت", "عورت کا بوٹ", "لباس"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ayollar etigi"),
            keywords: &[
                "ayol",
                "ayollar etigi",
                "etik",
                "kiyim",
                "oyoq kiyim",
                "tufli",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("giày bốt nữ"),
            keywords: &["bốt", "giày", "giày bốt nữ", "phụ nữ", "quần áo"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("botu jigééen"),
            keywords: &["bot", "botu jigééen", "dàll", "jigéen", "yéere"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhutsi yebhinqa"),
            keywords: &[
                "ibhinqa",
                "ibhutsi",
                "ibhutsi yebhinqa",
                "impahla",
                "isihlangu",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Buutu Obinrin"),
            keywords: &["Buutu Obinrin", "aṣọ", "bàtà", "búùtù", "obìnrin"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("女裝靴"),
            keywords: &["女士", "女裝靴", "服裝", "靴子", "鞋"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("女装靴"),
            keywords: &["女士", "女装靴", "服装", "靴子", "鞋"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("女靴"),
            keywords: &["女", "女靴", "靴子"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("靴子"),
            keywords: &["長靴", "靴子"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhuzu lowesimame"),
            keywords: &[
                "ibhuzu",
                "ibhuzu lowesimame",
                "impahla yokugqoka",
                "isicathulo",
                "owesimame",
            ],
        },
    ],
};
#[doc = "👑"]
pub const CROWN: crate::Emoji = crate::Emoji {
    glyph: "👑",
    codepoint: "1F451",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "crown",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kroon"),
            keywords: &["klere", "koning", "koningin", "kroon"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ዘውድ"),
            keywords: &["ንጉሥ", "ንግሥት", "አልባሳት", "ዘውድ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("تاج"),
            keywords: &["تاج", "ملابس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ম\u{9c1}ক\u{9c1}ট"),
            keywords: &[
                "পোছ\u{9be}ক",
                "ম\u{9c1}ক\u{9c1}ট",
                "ৰজ\u{9be}",
                "ৰ\u{9be}ণী",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("tac"),
            keywords: &["geyim", "kral", "kraliça", "tac"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("карона"),
            keywords: &["аксесуар", "каралева", "кароль", "карона"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("корона"),
            keywords: &["корона", "крал", "кралица", "облекло"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9c1}ক\u{9c1}ট"),
            keywords: &[
                "পোশ\u{9be}ক",
                "ম\u{9c1}ক\u{9c1}ট",
                "র\u{9be}জ\u{9be}",
                "র\u{9be}ণী",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kurunenn"),
            keywords: &["dilhad", "kurunenn", "tog"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kruna"),
            keywords: &["asesoar", "kralj", "kraljica", "kruna"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("corona"),
            keywords: &["cap", "complement", "corona", "rei", "reina"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎬᏫᏳᎯ ᎠᎵᏍᏚᎶ"),
            keywords: &["ᎤᎬᏫᏳᎯ", "ᎤᎬᏫᏳᎯ ᎠᎨᏯ", "ᎤᎬᏫᏳᎯ ᎠᎵᏍᏚᎶ", "ᏗᎿᏬᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("koruna"),
            keywords: &["koruna", "král", "královna", "oblečení"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("coron"),
            keywords: &["brenhines", "brenin", "coron", "dillad"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("krone"),
            keywords: &["diadem", "dronning", "konge", "krone"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Krone"),
            keywords: &["Krone", "König", "Königin"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("στέμμα"),
            keywords: &["βασίλισσα", "βασιλιάς", "ρουχισμός", "στέμμα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("crown"),
            keywords: &["clothing", "crown", "king", "queen"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("corona"),
            keywords: &["accesorios", "complementos", "corona", "reina", "rey"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["corona", "reina", "rey", "ropa", "vestimenta"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["corona", "realeza", "reina", "rey"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kroon"),
            keywords: &["kroon", "kuninganna", "kuningas", "riided"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("koroa"),
            keywords: &["arropa", "errege", "erregina", "koroa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تاج"),
            keywords: &["تاج", "شاه", "ملکه", "پوشاک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kruunu"),
            keywords: &["asuste", "kruunu", "kuningas", "kuningatar"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("korona"),
            keywords: &["hari", "kasuotan", "korona", "reyna"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("krúna"),
            keywords: &["drotning", "kongur", "krúna", "prinsessa", "prinsur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("couronne"),
            keywords: &["couronne", "reine", "roi", "vêtements"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("coróin"),
            keywords: &["banríon", "coróin", "rí"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("crùn"),
            keywords: &["aodach", "bànrigh", "crùn", "rìgh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("coroa"),
            keywords: &["coroa", "raíña", "rei"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મ\u{ac1}ક\u{ac1}ટ"),
            keywords: &["કપડા\u{a82}", "મ\u{ac1}ક\u{ac1}ટ", "રાજા", "રાણી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kambi"),
            keywords: &["kambi", "sarauniya", "sarki", "sutura"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כתר"),
            keywords: &["כתר", "מלך", "מלכה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("म\u{941}क\u{941}ट"),
            keywords: &["क\u{94d}राउन", "पोषाक", "म\u{941}क\u{941}ट"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kruna"),
            keywords: &["kralj", "kraljica", "kruna", "odjeća"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("korona"),
            keywords: &["kiegészítő", "király", "királynő", "korona"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("թագ"),
            keywords: &["արքա", "թագ", "թագուհի", "հագուստ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("mahkota"),
            keywords: &["mahkota", "pakaian", "raja", "ratu"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("òkpueze"),
            keywords: &["ezè", "ezènwanyị", "na-eme akwà", "òkpueze"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kóróna"),
            keywords: &["klæðnaður", "kóróna"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("corona"),
            keywords: &["abbigliamento", "corona", "re", "regina"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("王冠"),
            keywords: &["クラウン", "冠", "王冠"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("makutha"),
            keywords: &["makutha", "raja", "ratu", "sandhangan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გვირგვინი"),
            keywords: &["გვირგვინი", "დედოფალი", "მეფე", "ტანსაცმელი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тәж"),
            keywords: &["кию", "король", "тәж", "ханшайым"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("krone"),
            keywords: &["beklædning", "krone"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17d2}ក\u{17bb}ជ"),
            keywords: &["ម\u{17d2}ក\u{17bb}ជ", "ស\u{17d2}តេច"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{cbf}ರೀಟ"),
            keywords: &["ಉಡುಪು", "ಕ\u{cbf}ರೀಟ", "ರಾಜ", "ರಾಣ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("왕관"),
            keywords: &["왕", "왕관", "왕족"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("म\u{941}क\u{941}ट"),
            keywords: &["कपड\u{947}", "म\u{941}क\u{941}ट", "राजा", "राणी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("таажы"),
            keywords: &["кийим", "падыша", "таажы", "ханыша"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Kroun"),
            keywords: &["Kinnek", "Kinnigin", "Kleedung", "Kroun"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ມ\u{eb8}ງກ\u{eb8}ດ"),
            keywords: &[
                "ພະລາຊະນ\u{eb5}",
                "ພະລາຊາ",
                "ມ\u{eb8}ງກ\u{eb8}ດ",
                "ມ\u{ebb}ງກ\u{eb8}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("karūna"),
            keywords: &["drabužiai", "karalienė", "karalius", "karūna"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kronis"),
            keywords: &["karaliene", "karalis", "kronis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("karauna"),
            keywords: &["karauna", "kuini", "kākahu", "kīngi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("круна"),
            keywords: &["крал", "кралица", "круна", "цар", "царица"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കിരീടം"),
            keywords: &[
                "കിരീടം",
                "ര\u{d3e}ജ\u{d3e}വ\u{d4d}",
                "ര\u{d3e}ജ\u{d4d}ഞി",
                "വസ\u{d4d}\u{200c}ത\u{d4d}രം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("титэм"),
            keywords: &["гүнж", "титэм", "хаан", "хатан"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("म\u{941}क\u{941}ट"),
            keywords: &["कपड\u{947}", "म\u{941}क\u{941}ट", "राजा", "राणी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("mahkota"),
            keywords: &["mahkota", "pakaian", "permaisuri", "raja"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kuruna"),
            keywords: &["kuruna", "re", "reġina", "ħwejjeġ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("သရဖ\u{1030}"),
            keywords: &[
                "ဘ\u{102f}ရင\u{103a}",
                "ဘ\u{102f}ရင\u{103a}မ",
                "သရဖ\u{1030}",
                "အဝတ\u{103a}အထည\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("krone"),
            keywords: &["dronning", "klær", "konge", "krone"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("क\u{94d}राउन"),
            keywords: &["कपडा", "क\u{94d}राउन", "राजा", "रानी"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kroon"),
            keywords: &["kleding", "koning", "koningin", "kroon"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("krone"),
            keywords: &["dronning", "klede", "konge", "krone"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମ\u{b41}କ\u{b41}ଟ"),
            keywords: &["ପୋଷ\u{b3e}କ ପର\u{b3f}ଚ\u{b4d}ଛଦ", "ମ\u{b41}କ\u{b41}ଟ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਤਾਜ"),
            keywords: &["ਤਾਜ", "ਰਾਜ", "ਰਾਣੀ", "ਲਿਬਾਸ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("تاج"),
            keywords: &["بادشاہ", "تاج", "ملکہ", "کپڑے"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kraun"),
            keywords: &["King", "Klọt", "Kraun", "Kwin"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("korona"),
            keywords: &["korona", "król", "królowa"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("تاج"),
            keywords: &["تاج", "لباس", "ملکه", "پاچا"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("coroa"),
            keywords: &["acessório", "coroa"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["acessório", "coroa", "rainha", "rei", "vestuário"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pillu"),
            keywords: &["pillu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("coroană"),
            keywords: &[
                "coroană",
                "putere",
                "regalitate",
                "rege",
                "regină",
                "încoronat",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-526"),
            keywords: &["E10-526"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("корона"),
            keywords: &["королева", "король", "корона", "монарх", "царица", "царь"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikamba"),
            keywords: &["ikamba", "umwambaro", "umwami", "umwamikazi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("تاج"),
            keywords: &["بادشاه", "تاج", "راڻي", "لباس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඔට\u{dd4}න\u{dca}න"),
            keywords: &[
                "ඇඳ\u{dd4}ම\u{dca}",
                "ඔට\u{dd4}න\u{dca}න",
                "රජ",
                "රැජ\u{dd2}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("koruna"),
            keywords: &["koruna", "kráľ", "kráľovná", "oblečenie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("krona"),
            keywords: &["kralj", "kraljica", "krona", "oblačila"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("taaj"),
            keywords: &["boqor", "boqorad", "dhar", "taaj"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kurorë"),
            keywords: &["kurorë", "mbret", "mbretëreshë", "veshje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("круна"),
            keywords: &["крaљ", "крaљицa", "круна", "одећа"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["круна"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kruna"),
            keywords: &["kralj", "kraljica", "kruna", "odeća"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["kruna"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("krona"),
            keywords: &["drottning", "krona", "kung", "kungakrona"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("taji"),
            keywords: &["malkia", "mavazi", "mfalme", "taji"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கிர\u{bc0}டம\u{bcd}"),
            keywords: &["ஆடை அணிகலன\u{bcd}", "கிர\u{bc0}டம\u{bcd}", "மகுடம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c3f}ర\u{c40}టం"),
            keywords: &[
                "క\u{c3f}ర\u{c40}టం",
                "దుస\u{c4d}తులు",
                "ర\u{c3e}జు",
                "ర\u{c3e}ణ\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тоҷ"),
            keywords: &["либос", "малика", "тоҷ", "шоҳ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("มงก\u{e38}ฎ"),
            keywords: &["พระราชา", "พระราช\u{e34}น\u{e35}", "มงก\u{e38}ฎ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("täç"),
            keywords: &["eşik", "täç", "şa", "şa aýaly"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kalauni"),
            keywords: &["kalauni"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("taç"),
            keywords: &["giyim", "taç"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تاج"),
            keywords: &["تاج", "خان", "خانىش", "كىيىم"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("корона"),
            keywords: &["королева", "король", "корона", "одяг"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("تاج"),
            keywords: &["بادشاہ", "تاج", "لباس", "ملکہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("toj"),
            keywords: &["kiyim", "qirol", "qirolicha", "toj"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("vương miện"),
            keywords: &["nữ hoàng", "quần áo", "vua", "vương miện"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kuron"),
            keywords: &["buur", "kuron", "lingeer", "yéere"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isithsaba"),
            keywords: &["impahla", "isithsaba", "ukumkani", "ukumkanikazi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ade"),
            keywords: &["Ade", "aṣọ", "olorì", "ọba"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("皇冠"),
            keywords: &["國王", "女王", "服裝", "皇冠"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("皇冠"),
            keywords: &["国王", "女王", "服装", "皇冠"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("皇冠"),
            keywords: &["王冠", "皇冠"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("皇冠"),
            keywords: &["皇冠"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umqhele"),
            keywords: &["impahla yokugqoka", "inkosazana", "inkosi", "umqhele"],
        },
    ],
};
#[doc = "👒"]
pub const WOMANS_HAT: crate::Emoji = crate::Emoji {
    glyph: "👒",
    codepoint: "1F452",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "woman’s hat",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vrouehoed"),
            keywords: &["hoed", "klere", "vrou", "vrouehoed"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሴት ባርኔጣ"),
            keywords: &["ሴት", "አልባሳት", "ኮፊያ", "የሴት ባርኔጣ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قبعة حريمي"),
            keywords: &["قبعة", "قبعة حريمي", "ملابس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মহিল\u{9be}ৰ ট\u{9c1}পী"),
            keywords: &[
                "ট\u{9c1}পী",
                "পোছ\u{9be}ক",
                "মহিল\u{9be}",
                "মহিল\u{9be}ৰ ট\u{9c1}পী",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qadın şlyapası"),
            keywords: &["geyim", "papaq", "qadın", "qadın şlyapası"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("жаночы капялюш"),
            keywords: &[
                "адзенне",
                "аксесуар",
                "жаночы капялюш",
                "жанчына",
                "капялюш",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Дамска шапка"),
            keywords: &["Дамска шапка", "жена", "облекло", "шапка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মহিল\u{9be}দের ট\u{9c1}পি"),
            keywords: &[
                "ট\u{9c1}পি",
                "ন\u{9be}রী",
                "পোশ\u{9be}ক",
                "মহিল\u{9be}দের ট\u{9c1}পি",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ženski šešir"),
            keywords: &["asesoar", "šešir", "žena", "ženski šešir"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("barret de dona"),
            keywords: &["accessori", "barret", "barret de dona", "dona"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ ᎤᎵᏚᎶ"),
            keywords: &["ᎠᎨᏯ", "ᎠᎨᏯ ᎤᎵᏚᎶ", "ᎠᎵᏍᏇᏔᏬ", "ᏗᎿᏬᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("dámský klobouk"),
            keywords: &["dámský klobouk", "klobouk", "oblečení", "žena"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("het fenyw"),
            keywords: &["dillad", "het", "het fenyw", "menyw"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("hat"),
            keywords: &["beklædning", "damehat", "hat"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Damenhut"),
            keywords: &[
                "Damenhut",
                "Damenhut mit Schleife",
                "Hut",
                "Kopfbedeckung",
                "Schleife",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γυναικείο καπέλο"),
            keywords: &["γυναίκα", "γυναικείο καπέλο", "καπέλο", "ρουχισμός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("woman’s hat"),
            keywords: &["clothing", "hat", "woman", "woman’s hat"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("sombrero de mujer"),
            keywords: &[
                "accesorio",
                "mujer",
                "ropa",
                "sombrero",
                "sombrero de mujer",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "mujer",
                "ropa",
                "sombrero",
                "sombrero de mujer",
                "vestimenta",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("naistekübar"),
            keywords: &["kübar", "müts", "naine", "naistekübar", "riided"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("emakumeentzako kapelua"),
            keywords: &["arropa", "emakume", "emakumeentzako kapelua", "kapelu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کلاه زنانه"),
            keywords: &["زن", "پوشاک", "کلاه", "کلاه زنانه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("naisen hattu"),
            keywords: &["hattu", "nainen", "naisen hattu", "vaatteet"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("sumbrerong pambabae"),
            keywords: &["kasuotan", "pambabae", "sombrero", "sumbrerong pambabae"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("konufólkahattur"),
            keywords: &[
                "hattur",
                "klæði",
                "kona",
                "konufólk",
                "konufólkahattur",
                "kvinna",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("chapeau de femme"),
            keywords: &["chapeau", "chapeau de femme", "femme", "vêtements"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["chapeau", "chapeau de femme", "femme", "vêtements"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("hata mná"),
            keywords: &["hata", "hata mná"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ad boireannaich"),
            keywords: &["ad", "ad boireannaich", "aodach", "boireannach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("sombreiro de muller"),
            keywords: &["muller", "sombreiro", "sombreiro de muller"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}ત\u{acd}રીની હ\u{ac7}ટ"),
            keywords: &["કપડા\u{a82}", "સ\u{acd}ત\u{acd}રીની હ\u{ac7}ટ", "હ\u{ac7}ટ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("hular mace"),
            keywords: &["hula", "hular mace", "mace", "sutura"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כובע של אישה"),
            keywords: &["אישה", "כובע", "כובע של אישה", "קיץ"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("महिला की ह\u{948}ट"),
            keywords: &["टोप", "पोषाक", "महिला की ह\u{948}ट"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("ženski šešir"),
            keywords: &["odjeća", "šešir", "žene", "ženski šešir"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("női kalap"),
            keywords: &["kalap", "női kalap", "nők", "ruha", "ruházat"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կնոջ գլխարկ"),
            keywords: &["գլխարկ", "կին", "կնոջ գլխարկ", "հագուստ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("topi wanita"),
            keywords: &["pakaian", "topi", "wanita"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("òkpu nwaanyị"),
            keywords: &["na-eme akwà", "nwanyị", "òkpu", "òkpu nwaanyị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kvenhattur"),
            keywords: &["hattur", "klæðnaður", "kvenhattur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cappello da donna"),
            keywords: &["abbigliamento", "cappello", "cappello da donna"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("婦人帽子"),
            keywords: &["婦人帽子", "帽子", "麦わら", "麦わら帽子"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("topi wadon"),
            keywords: &["sandhangan", "topi", "wadon"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქალის ქუდი"),
            keywords: &["ტანსაცმელი", "ქალი", "ქალის ქუდი", "ქუდი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("әйелдер қалпағы"),
            keywords: &["кию", "қалпақ", "әйел", "әйелдер қалпағы"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("hat"),
            keywords: &["beklædning", "hat", "kvindes hat"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bd}កនារ\u{17b8}"),
            keywords: &["ម\u{17bd}កនារ\u{17b8}", "ម\u{17bd}កស\u{17d2}រ\u{17b8}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಹ\u{cbf}ಳ\u{cc6}ಯರ ಹ\u{ccd}ಯಾಟ\u{ccd}"),
            keywords: &[
                "ಟೋಪ\u{cbf}",
                "ಮಹ\u{cbf}ಳ\u{cc6}ಯ ಟೋಪ\u{cbf}",
                "ಮಹ\u{cbf}ಳ\u{cc6}ಯರ ಹ\u{ccd}ಯಾಟ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("여성용 모자"),
            keywords: &["모자", "여성용 모자", "챙 넓은 모자"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बायला\u{902}च\u{947}\u{902} ह\u{945}ट"),
            keywords: &[
                "कपड\u{947}",
                "बायल",
                "बायला\u{902}च\u{947}\u{902} ह\u{945}ट",
                "ह\u{945}ट",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("аялдар баш кийими"),
            keywords: &["аял", "аялдар баш кийими", "баш кийим", "кийим"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Fraenhutt"),
            keywords: &["Fra", "Fraenhutt", "Hutt", "Kleedung"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໝວກແມ\u{ec8}ຍ\u{eb4}ງ"),
            keywords: &["ແມ\u{ec8}ຍ\u{eb4}ງ", "ໝວກ", "ໝວກແມ\u{ec8}ຍ\u{eb4}ງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("moteriška skrybėlė"),
            keywords: &["drabužiai", "moteris", "moteriška skrybėlė", "skrybėlė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sieviešu cepure"),
            keywords: &["cepure", "platmale", "sieviešu cepure"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pōtae wahine"),
            keywords: &["kākahu", "pōtae", "wahine"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("женска шапка"),
            keywords: &["жена", "женска шапка", "капа"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d4d}\u{200c}ത\u{d4d}രീകള\u{d41}ടെ തൊപ\u{d4d}പി"),
            keywords: &[
                "തൊപ\u{d4d}പി",
                "വനിത\u{d3e} ഹ\u{d3e}റ\u{d4d}റ\u{d4d}",
                "വസ\u{d4d}\u{200c}ത\u{d4d}രം",
                "സ\u{d4d}\u{200c}ത\u{d4d}രീ",
                "സ\u{d4d}\u{200c}ത\u{d4d}രീകള\u{d41}ടെ തൊപ\u{d4d}പി",
                "ഹ\u{d3e}റ\u{d4d}റ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эмэгтэй малгай"),
            keywords: &["малгай", "хувцас", "эмэгтэй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("महिला\u{902}ची टोपी"),
            keywords: &["कपड\u{947}", "टोपी", "महिला", "महिला\u{902}ची टोपी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("topi wanita"),
            keywords: &["pakaian", "topi", "wanita"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kappell ta’ mara"),
            keywords: &["kappell", "kappell ta’ mara", "mara", "ħwejjeġ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမျ\u{102d}\u{102f}းသမ\u{102e}း ဦးထ\u{102f}ပ\u{103a}"),
            keywords: &[
                "မ\u{102d}န\u{103a}းမဆောင\u{103a}း ဦးထ\u{102f}ပ\u{103a}",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း",
                "အဝတ\u{103a}အထည\u{103a}",
                "ဦးထ\u{102f}ပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("damehatt"),
            keywords: &["damehatt", "hatt", "klær"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("महिलाको टोपी"),
            keywords: &["कपडा", "टोपी", "महिला", "महिलाको टोपी"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("dameshoed"),
            keywords: &["dameshoed", "hoed", "kleding", "vrouw"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("damehatt"),
            keywords: &["damehatt", "hatt", "klede"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମହ\u{b3f}ଳ\u{b3e}ଙ\u{b4d}କ ଟୋପ\u{b3f}"),
            keywords: &[
                "ଟୋପ\u{b3f}",
                "ପୋଷ\u{b3e}କ ପର\u{b3f}ଚ\u{b4d}ଛଦ",
                "ମହ\u{b3f}ଳ\u{b3e}ଙ\u{b4d}କ ଟୋପ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਔਰਤ ਦੀ ਟ\u{a4b}ਪੀ"),
            keywords: &[
                "ਔਰਤ",
                "ਔਰਤ ਦੀ ਟ\u{a4b}ਪੀ",
                "ਔਰਤਾ\u{a02} ਦੀ ਟ\u{a4b}ਪੀ",
                "ਟ\u{a4b}ਪੀ",
                "ਲਿਬਾਸ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("زنانیاں دا ہیٹ"),
            keywords: &["زنانی", "زنانیاں دا ہیٹ", "کپڑے", "ہیٹ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wúmán Hat"),
            keywords: &["Hat", "Klọt", "Wúman", "Wúmán Hat"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kapelusz damski"),
            keywords: &["damski", "kapelusz", "nakrycie głowy", "ze wstążką"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښځینه خولۍ"),
            keywords: &["خولۍ", "لباس", "ښځه", "ښځینه خولۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("chapéu feminino"),
            keywords: &["acessório", "chapéu", "chapéu feminino"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("chapéu de senhora"),
            keywords: &[
                "acessório",
                "chapéu",
                "chapéu de senhora",
                "senhora",
                "vestuário",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("warmip chikun"),
            keywords: &["warmip chikun"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pălărie de damă"),
            keywords: &[
                "femeie",
                "feminin",
                "pălărie",
                "pălărie de damă",
                "îmbrăcăminte",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-527"),
            keywords: &["E10-527"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("шляпка"),
            keywords: &["бант", "женщина", "солома", "шляпка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ingofero y’abagore"),
            keywords: &["ingofero", "ingofero y’abagore", "umugore", "umwambaro"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عورت جي ٽوپي"),
            keywords: &["عورت", "عورت جي ٽوپي", "لباس", "ٽوپي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dcf}න\u{dca}ත\u{dcf} හ\u{dd2}ස\u{dca} වැස\u{dd4}ම"),
            keywords: &[
                "ඇඳ\u{dd4}ම\u{dca}",
                "ක\u{dcf}න\u{dca}ත\u{dcf} හ\u{dd2}ස\u{dca} වැස\u{dd4}ම",
                "ක\u{dcf}න\u{dca}ත\u{dcf}ව",
                "තොප\u{dca}ප\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("dámsky klobúk"),
            keywords: &["dámsky klobúk", "klobúk", "oblečenie", "žena"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ženski klobuk"),
            keywords: &["klobuk", "oblačila", "ženska", "ženski klobuk"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("koofiyad dumar"),
            keywords: &["dhar", "dumar", "koofiyad"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kapelë femrash"),
            keywords: &["femër", "kapelë", "kapelë femrash", "veshje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("женски шешир"),
            keywords: &["жeнe", "женски шешир", "одећа", "шeшир"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["женски шешир"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ženski šešir"),
            keywords: &["odeća", "šešir", "žene", "ženski šešir"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["ženski šešir"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("damhatt"),
            keywords: &["damhatt", "hatt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kofia ya mwanamke"),
            keywords: &["kofia", "kofia ya mwanamke", "mavazi", "mwanamke"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பெண\u{bcd}கள\u{bcd} தொப\u{bcd}பி"),
            keywords: &[
                "ஆடை அணிகலன\u{bcd}",
                "தொப\u{bcd}பி",
                "பெண\u{bcd}கள\u{bcd} தொப\u{bcd}பி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఆడవ\u{c3e}ళ\u{c4d}ల ట\u{c4b}ప\u{c40}"),
            keywords: &[
                "ఆడవ\u{c3e}ళ\u{c4d}ల ట\u{c4b}ప\u{c40}",
                "ఆడవ\u{c3e}ళ\u{c4d}లు",
                "ట\u{c4b}ప\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("кулоҳи занона"),
            keywords: &["зан", "кулоҳ", "кулоҳи занона", "либос"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หมวกผ\u{e39}\u{e49}หญ\u{e34}ง"),
            keywords: &[
                "ผ\u{e39}\u{e49}หญ\u{e34}ง",
                "หมวก",
                "หมวกผ\u{e39}\u{e49}หญ\u{e34}ง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("aýal şlýapasy"),
            keywords: &["aýal şlýapasy", "eşik", "papak", "zenan"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tatā fakafefine"),
            keywords: &["tatā fakafefine"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kadın şapkası"),
            keywords: &["giyim", "kadın şapkası", "şapka"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئايالچە قالپاق"),
            keywords: &["ئايال", "ئايالچە قالپاق", "قالپاق", "كىيىم"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("жіночий капелюшок"),
            keywords: &["жінка", "жіночий капелюшок", "капелюх", "одяг"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("عورت کا ہیٹ"),
            keywords: &["عورت", "عورت کا ہیٹ", "لباس", "ہیٹ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ayollar shlyapasi"),
            keywords: &["ayol", "ayollar shlyapasi", "kiyim", "shlyapa"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mũ phụ nữ"),
            keywords: &["cái mũ", "mũ phụ nữ", "phụ nữ", "quần áo"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("mbaxane jigeen"),
            keywords: &["jigéen", "mbaxane", "mbaxane jigeen", "yéere"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umnqwazi webhinqa"),
            keywords: &["ibhinqa", "impahla", "umnqwazi", "umnqwazi webhinqa"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Haati Obinrin"),
            keywords: &["Haati Obinrin", "aṣọ", "fìlà", "obìnrin"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("女裝帽"),
            keywords: &["女士", "女裝帽", "帽", "服裝"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("女装帽"),
            keywords: &["女士", "女装帽", "帽", "服装"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("女帽"),
            keywords: &["女", "女帽", "帽子"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("帽子"),
            keywords: &["帽子", "淑女帽"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isigqoko sowesimame"),
            keywords: &[
                "impahla yokugqoka",
                "isigqoko",
                "isigqoko sowesimame",
                "owesimame",
            ],
        },
    ],
};
#[doc = "🎩"]
pub const TOP_HAT: crate::Emoji = crate::Emoji {
    glyph: "🎩",
    codepoint: "1F3A9",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "top hat",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("keil"),
            keywords: &["hoed", "keil", "klere", "pluiskeil"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የወንድ የሙሉ ልብስ ባርኔጣ"),
            keywords: &["ቶፕ ኮፊያ", "አልባሳት", "ከላይ ተለባሽ", "ኮፊያ", "የወንድ የሙሉ ልብስ ባርኔጣ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}قبعة رسمية"),
            keywords: &["ترفيه", "قبعة عالية", "\u{202b}قبعة رسمية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ম\u{9c2}ৰৰ ট\u{9c1}পী"),
            keywords: &[
                "ট\u{9c1}পী",
                "পোছ\u{9be}ক",
                "ম\u{9c2}ৰৰ ট\u{9c1}পী",
                "শীৰ\u{9cd}ষ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("silindr şlyapa"),
            keywords: &["baş", "geyim", "papaq", "silindr papaq", "silindr şlyapa"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("цыліндр"),
            keywords: &["адзенне", "аксесуар", "капялюш", "мужчына", "цыліндр"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("цилиндър"),
            keywords: &["облекло", "цилиндър", "шапка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("উ\u{981}চ\u{9c1} ট\u{9c1}পি"),
            keywords: &[
                "উ\u{981}চ\u{9c1} ট\u{9c1}পি",
                "টপ",
                "ট\u{9c1}পি",
                "পোশ\u{9be}ক",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("tog moull uhel"),
            keywords: &["dilhad", "tog", "tog moull uhel"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("cilindar"),
            keywords: &["asesoar", "cilindar", "odjevni predmet", "šešir"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("barret de copa"),
            keywords: &["barret", "barret de copa", "copa"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏚ ᎠᎵᏍᏇᏚᏬ"),
            keywords: &["ᎠᎵᏍᏇᏔᏬ", "ᎦᏚ", "ᎦᏚ ᎠᎵᏍᏇᏚᏬ", "ᏗᎿᏬᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("cylindr"),
            keywords: &["cylindr", "klobouk", "oblečení", "pokrývka hlavy"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("het silc"),
            keywords: &["dillad", "het", "het silc"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("høj hat"),
            keywords: &["hat", "høj hat", "sort hat"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Zylinder"),
            keywords: &["Hut", "Kopfbedeckung", "Zylinder", "Zylinderhut"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ημίψηλο καπέλο"),
            keywords: &["ημίψηλο καπέλο", "καπέλο", "ρουχισμός", "ψηλό καπέλο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("top hat"),
            keywords: &["clothing", "hat", "top", "tophat"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("sombrero de copa"),
            keywords: &["chistera", "copa", "ropa", "sombrero", "sombrero de copa"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("galera"),
            keywords: &["caballero", "copa", "galera", "hombre", "sombrero"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("sombrero de copa"),
            keywords: &[
                "caballero",
                "copa",
                "galera",
                "sombrero",
                "sombrero de copa",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("sombrero de copa"),
            keywords: &[
                "caballero",
                "copa",
                "hombre",
                "sombrero",
                "sombrero de copa",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("torukübar"),
            keywords: &["kübar", "müts", "riided", "torukübar"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kapelu altua"),
            keywords: &["altu", "arropa", "kapelu", "kapelu altua"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کلاه مردانه استوانه\u{200c}ای"),
            keywords: &[
                "بالا",
                "تاپ\u{200c}هت",
                "پوشاک",
                "کلاه",
                "کلاه مردانه استوانه\u{200c}ای",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("silinteri"),
            keywords: &["hattu", "silinteri", "vaatteet"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("top hat"),
            keywords: &["kasuotan", "sombrero", "top hat"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("høgur hattur"),
            keywords: &["hattur", "høgur", "klæði"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("haut de forme"),
            keywords: &["chapeau", "haut de forme", "vêtements"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("haut-de-forme"),
            keywords: &["chapeau", "haut-de-forme", "vêtements"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("hata ard"),
            keywords: &["hata", "hata ard"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ad àrd"),
            keywords: &["ad", "aodach", "àrd"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("sombreiro de copa"),
            keywords: &["mago", "sombreiro", "sombreiro de copa"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ટોપ હ\u{ac7}ટ"),
            keywords: &["ટોપ હ\u{ac7}ટ", "મનોરજન", "હ\u{ac7}ટ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("shaho"),
            keywords: &["hula", "sama", "shaho", "sutura"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מגבעת צילינדר"),
            keywords: &["גבר", "כובע", "מגבעת צילינדר", "מהודר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सरटोप"),
            keywords: &["टोपी", "मनोर\u{902}जन", "सरटोप"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("cilindar"),
            keywords: &["cilindar", "odjeća", "šešir"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("cilinder"),
            keywords: &["cilinder", "kalap", "ruha", "ruházat"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ցիլինդր"),
            keywords: &["գլխարկ", "հագուստ", "ցիլինդր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("topi tinggi"),
            keywords: &["pakaian", "sulap", "topi", "topi tinggi"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("òkpu dị elu"),
            keywords: &["di elu", "na-eme akwà", "òkpu", "òkpu dị elu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("pípuhattur"),
            keywords: &["hattur", "pípuhattur", "skemmtun"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cilindro"),
            keywords: &["cappello", "cilindro", "intrattenimento"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("シルクハット"),
            keywords: &["シルクハット", "帽子"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("topi dhuwur"),
            keywords: &["dhuwur", "sandhangan", "sepatu dhuwur", "topi"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ცილინდრი"),
            keywords: &["ტანსაცმელი", "ქუდი", "ცილინდრი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: None,
            keywords: &["tarazalt"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қоқырайма"),
            keywords: &["жоғары", "киім", "қалпақ", "қоқырайма"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("høj hat"),
            keywords: &["hat", "høj hat", "sort hat"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bd}កអ\u{17d2}នកលេងសៀក"),
            keywords: &["ម\u{17bd}ក", "ម\u{17bd}កវែង", "ម\u{17bd}កអ\u{17d2}នកលេងសៀក"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮೇಲ\u{cbf}ನ ಹ\u{ccd}ಯಾಟ\u{ccd}"),
            keywords: &[
                "ಎತ\u{ccd}ತರವಾದ ರೇಷ\u{ccd}ಮ\u{cc6}ಟೊಪ\u{ccd}ಪ\u{cbf}ಗ\u{cc6}",
                "ಟೊಪ\u{ccd}ಪ\u{cbf}",
                "ಮೇಲ\u{cbf}ನ ಹ\u{ccd}ಯಾಟ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("마술사 모자"),
            keywords: &["마술사", "마술사 모자"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("टॉप ह\u{945}ट"),
            keywords: &["कपड\u{947}", "टॉप", "टॉपह\u{945}ट", "ह\u{945}ट"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бийик шляпа"),
            keywords: &["баш кийим", "бийик шляпа", "кийим"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Zilinder"),
            keywords: &["Hutt", "Kleedung", "Zilinder", "héich"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໝວກກະບອກສ\u{eb9}ງ"),
            keywords: &["ໝວກ", "ໝວກກະບອກສ\u{eb9}ງ", "ໝວກສ\u{eb9}ງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("cilindras"),
            keywords: &["aukšta", "cilindras", "drabužiai", "skrybėlė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("cilindrs"),
            keywords: &["apģērbs", "cepure", "cilindrs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pōtae tihi"),
            keywords: &["kākahu", "pōtae", "tihi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("цилиндар"),
            keywords: &["капа", "маж", "цилиндар"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("തൊപ\u{d4d}പി"),
            keywords: &[
                "ക\u{d4d}യ\u{d3e}പ\u{d4d}പ\u{d4d}",
                "ടോപ\u{d4d}പ\u{d4d}",
                "തൊപ\u{d4d}പി",
                "വസ\u{d4d}\u{200c}ത\u{d4d}രം",
                "ഹ\u{d3e}റ\u{d4d}റ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("өндөр малгай"),
            keywords: &["малгай", "хувцас өмсгөл", "өндөр"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("उ\u{902}च टोपी"),
            keywords: &["उ\u{902}च", "उ\u{902}चटोपी", "कपड\u{947}", "टोपी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("topi tinggi"),
            keywords: &["pakaian", "tinggi", "topi"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kpiepel top"),
            keywords: &["kappell", "kpiepel top", "quċċata", "tophat", "ħwejjeġ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဦးထ\u{102f}ပ\u{103a}မြင\u{1037}\u{103a}"),
            keywords: &[
                "အဝတ\u{103a}အထည\u{103a}",
                "ဦးထ\u{102f}ပ\u{103a}",
                "ဦးထ\u{102f}ပ\u{103a}မြင\u{1037}\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("flosshatt"),
            keywords: &["flosshatt", "hatt", "klær"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("अग\u{94d}लो टोपी"),
            keywords: &[
                "अग\u{94d}लो टोप",
                "अग\u{94d}लो टोपी",
                "कपडा",
                "टोपी",
                "शीर\u{94d}ष",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("hoge hoed"),
            keywords: &["hoed", "hoge hoed", "hoog", "kleding"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("flosshatt"),
            keywords: &["flosshatt", "hatt", "klede"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଲମ\u{b4d}ବ\u{b3e} ଟୋପ\u{b3f}"),
            keywords: &[
                "ଉପର",
                "ଉପରଟୋପ\u{b3f}",
                "ଟୋପ\u{b3f}",
                "ପୋଷ\u{b3e}କ ପର\u{b3f}ଚ\u{b4d}ଛଦ",
                "ଲମ\u{b4d}ବ\u{b3e} ଟୋପ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਵ\u{a71}ਡੀ ਟ\u{a4b}ਪੀ"),
            keywords: &[
                "ਕ\u{a71}ਪੜ\u{a47}",
                "ਟ\u{a4b}ਪ",
                "ਟ\u{a4b}ਪਹ\u{a48}ਟ",
                "ਟ\u{a4b}ਪੀ",
                "ਵ\u{a71}ਡੀ ਟ\u{a4b}ਪੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ا\u{64f}وتلا ہیٹ"),
            keywords: &[
                "ا\u{64f}وتلا ہیٹ",
                "ا\u{64f}وچی ٹوپی",
                "چوٹی",
                "کپڑے",
                "ہیٹ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tọ\u{301}l Hat"),
            keywords: &["Hat", "Klọt", "Tọl", "Tọ\u{301}l Hat", "Tọ\u{301}lhat"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("cylinder"),
            keywords: &["cylinder", "kapelusz", "męskie nakrycie głowy"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("تندی خولۍ"),
            keywords: &["تندی خولۍ", "تندۍ", "خولۍ", "لباس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cartola"),
            keywords: &["cartola", "chapéu", "roupa"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["acessório", "cartola", "chapéu", "chapéu alto", "vestuário"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("hanaq chiku"),
            keywords: &["hanaq chiku"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("joben"),
            keywords: &["joben", "pălărie", "îmbrăcăminte"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-361"),
            keywords: &["E10-361"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("цилиндр"),
            keywords: &["мужчина", "цилиндр", "шляпа"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ingofero ireba hejuru"),
            keywords: &[
                "hejuru",
                "ingofero",
                "ingofero ireba hejuru",
                "ingofero y’agasongero",
                "umwambaro",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مٿي جي ٽوپي"),
            keywords: &["لباس", "مٿي", "مٿي جي ٽوپي", "ٽاپ هيٽ", "ٽوپي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("උස තොප\u{dca}ප\u{dd2}ය"),
            keywords: &[
                "ඇඳ\u{dd4}ම\u{dca}",
                "උස තොප\u{dca}ප\u{dd2}ය",
                "උස\u{dca}",
                "තොප\u{dca}ප\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("cylinder"),
            keywords: &["cylinder", "klobúk", "oblečenie", "vysoký"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("cilinder"),
            keywords: &["cilinder", "klobuk", "oblačila"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("koofiyad dheer"),
            keywords: &["dhar", "koofiyad", "koofiyad dheer", "sare"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kapelë cilindrike"),
            keywords: &["cilindër", "kapelë", "kapelë cilindrike", "lart", "veshje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("цилиндар"),
            keywords: &["одећа", "цилиндaр", "цилиндар", "шeшир"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["цилиндар"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("cilindar"),
            keywords: &["cilindar", "odeća", "šešir"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["cilindar"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("hög hatt"),
            keywords: &["hatt", "hög hatt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kofia ya mwanamume"),
            keywords: &["juu", "kofia", "kofia ya mwanamume", "mavazi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பெரிய தொப\u{bcd}பி"),
            keywords: &[
                "ஆண\u{bcd}",
                "தொப\u{bcd}பி",
                "பெரிய தொப\u{bcd}பி",
                "பொழுதுபோக\u{bcd}கு",
                "மேஜிக\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఇంద\u{c4d}రజ\u{c3e}ల\u{c3f}కున\u{c3f} ట\u{c4b}ప\u{c40}"),
            keywords: &[
                "ఇంద\u{c4d}రజ\u{c3e}లం",
                "ఇంద\u{c4d}రజ\u{c3e}ల\u{c3f}కున\u{c3f} ట\u{c4b}ప\u{c40}",
                "ట\u{c4b}ప\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("кулоҳи баланд"),
            keywords: &["боло", "кулоҳ", "кулоҳи баланд", "либос"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หมวกส\u{e39}ง"),
            keywords: &["หมวก", "หมวกส\u{e39}ง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çüri şlýapa"),
            keywords: &["depe", "eşik", "papak", "çüri papak", "çüri şlýapa"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tatā māʻolunga"),
            keywords: &["tatā māʻolunga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("silindir şapka"),
            keywords: &["eğlence", "silindir şapka", "şapka"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئۇزۇن قالپاق"),
            keywords: &["ئۇزۇن قالپاق", "باش", "قالپاق", "كىيىم"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("циліндр (капелюх)"),
            keywords: &["капелюх", "одяг", "циліндр (капелюх)", "чоловік"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اوپری ٹوپ"),
            keywords: &["اوپری ٹوپ", "لباس", "ٹاپ ہیٹ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("silindr shlyapa"),
            keywords: &["bosh", "bosh kiyimi", "kiyim", "shlyapa", "silindr shlyapa"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mũ chóp cao"),
            keywords: &["cái mũ", "mũ chóp cao", "quần áo", "đầu"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("mbaxane joniwalkër"),
            keywords: &[
                "kaw",
                "mbaxane",
                "mbaxane joniwalkër",
                "topmbaxane",
                "yéere",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-top hat"),
            keywords: &["i-top hat", "i-tophat", "impahla", "phezulu", "umnqwazi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Haati Oke"),
            keywords: &["Haati Oke", "aṣọ", "fìlà", "òkè"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("頂帽"),
            keywords: &["帽", "服裝", "頂帽", "高頂禮帽"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("顶帽"),
            keywords: &["帽", "服装", "顶帽", "高顶礼帽"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("礼帽"),
            keywords: &["帽子", "礼帽", "高帽"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("禮帽"),
            keywords: &["禮帽", "紳士帽"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["帽子", "禮帽", "紳士帽", "魔術師帽"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isigqoko sabesilisa"),
            keywords: &[
                "impahla yokugqoka",
                "isigqoko",
                "isigqoko sabesilisa",
                "umswenko",
            ],
        },
    ],
};
#[doc = "🎓"]
pub const GRADUATION_CAP: crate::Emoji = crate::Emoji {
    glyph: "🎓",
    codepoint: "1F393",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "graduation cap",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gradeplegtigheidsmus"),
            keywords: &[
                "graad",
                "gradeplegtigheidsmus",
                "hoed",
                "klere",
                "mus",
                "viering",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የምርቃት ኮፍያ"),
            keywords: &["ምርቃት", "አልባሳት", "ኬፕ", "ክብረ በዓል", "ኮፊያ", "የምርቃት ኮፍያ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قبعة تخرج"),
            keywords: &["احتفال", "تخرج", "قبعة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("গ\u{9cd}ৰেজ\u{9c1}ৱেশ\u{9cd}বন কেপ"),
            keywords: &[
                "উদয\u{9be}পন",
                "কেপ",
                "গ\u{9cd}ৰেজ\u{9c1}ৱেশ\u{9cd}বন কেপ",
                "ট\u{9c1}পী",
                "পোছ\u{9be}ক",
                "স\u{9cd}ন\u{9be}তক",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("məzuniyyət papağı"),
            keywords: &[
                "bayram",
                "geyim",
                "kepka",
                "məzuniyyət",
                "məzuniyyət papağı",
                "papaq",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("акадэмічная шапачка"),
            keywords: &["акадэмічная шапачка", "выпуск", "свята", "шапачка", "шапка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Шапка за дипломиране"),
            keywords: &[
                "Шапка за дипломиране",
                "дипломиране",
                "облекло",
                "празнуване",
                "шапка",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("গ\u{9cd}র\u{9be}জ\u{9c1}য\u{9bc}েশনের ট\u{9c1}পি"),
            keywords: &[
                "উদয\u{9be}পন",
                "গ\u{9cd}র\u{9be}জ\u{9c1}য\u{9bc}েশনের ট\u{9c1}পি",
                "ট\u{9c1}পি",
                "পোশ\u{9be}ক",
                "স\u{9cd}ন\u{9be}তক হওয\u{9bc}\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("tok skol-veur"),
            keywords: &["dilhad", "tog", "tok skol-veur"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("maturska kapa"),
            keywords: &["asesoar", "cilindar", "maturska kapa", "proslava", "šešir"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("barret de graduació"),
            keywords: &[
                "barret",
                "barret de graduació",
                "birret",
                "celebració",
                "graduació",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᏍᏆᏗᏍᎩ ᎤᎵᏍᏚᎶ"),
            keywords: &[
                "ᎠᎵᏍᏇᏔᏬ",
                "ᎠᎵᏍᏚᎶ",
                "ᎠᎾᎵᎮᎵᎬᎢ",
                "ᏓᏂᏍᏆᏗᏍᎬᎢ",
                "ᏗᎿᏬᏍᏗ",
                "ᏗᏍᏆᏗᏍᎩ ᎤᎵᏍᏚᎶ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("promoční čepice"),
            keywords: &[
                "absolvent",
                "klobouk",
                "oblečení",
                "oslava",
                "pokrývka hlavy",
                "promoce",
                "promoční čepice",
                "student",
                "studium",
                "čapka",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cap graddio"),
            keywords: &["cap", "cap graddio", "dathlu", "dillad", "het"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("eksamenshat"),
            keywords: &["eksamen", "eksamenshat", "hat"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Doktorhut"),
            keywords: &["Abschlussfeier", "Doktorhut"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καπέλο αποφοίτησης"),
            keywords: &[
                "αποφοίτηση",
                "γιορτή",
                "καπέλο",
                "καπέλο αποφοίτησης",
                "ρουχισμός",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("graduation cap"),
            keywords: &["cap", "celebration", "clothing", "graduation", "hat"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &[
                "cap",
                "celebration",
                "clothing",
                "graduation",
                "hat",
                "mortarboard",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["cap", "celebration", "clothing", "graduation", "hat"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("birrete"),
            keywords: &["birrete", "celebración", "gorro", "graduación"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("gorro de graduación"),
            keywords: &[
                "birrete",
                "celebración",
                "gorro de graduación",
                "graduación",
                "graduado",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("birrete"),
            keywords: &["birrete", "celebración", "graduación", "graduado"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("birrete"),
            keywords: &["birrete"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("koolilõpumüts"),
            keywords: &["koolilõpumüts", "lõpetamine", "müts", "riided"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("graduatu-txanoa"),
            keywords: &[
                "arropa",
                "graduatu-txanoa",
                "graduazio",
                "ospakizun",
                "txano",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کلاه فارغ\u{200c}التحصیلی"),
            keywords: &["جشن", "فارغ\u{200c}التحصیلی", "پوشاک", "کلاه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("valmistujaislakki"),
            keywords: &[
                "hattu",
                "juhla",
                "lakki",
                "vaatteet",
                "valmistujaiset",
                "valmistujaislakki",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("graduation cap"),
            keywords: &["cap", "graduation", "kasuotan", "pagtatapos"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("fráfaringarhúgva"),
            keywords: &[
                "fráfaring",
                "fráfaringarhúgva",
                "hattur",
                "húgva",
                "klæði",
                "próvtøka",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("toque universitaire"),
            keywords: &["chapeau", "toque universitaire", "vêtements"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("chapeau de diplômé"),
            keywords: &[
                "chapeau",
                "chapeau de diplômé",
                "diplômé",
                "mortier",
                "remise de diplômes",
                "vêtements",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("caipín bronnta céime"),
            keywords: &[
                "bronnadh céime",
                "caipín bronnta céime",
                "lucht acadúil",
                "ollscoil",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("currac ceumnachaidh"),
            keywords: &[
                "ad",
                "aodach",
                "ceumnachadh",
                "comharrachadh",
                "currac",
                "currac ceumnachaidh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("barrete de graduación"),
            keywords: &[
                "barrete de graduación",
                "birrete",
                "graduación",
                "universidade",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}નાતક ટોપી"),
            keywords: &["ઉજવણી", "ટોપી", "સ\u{acd}નાતક"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("hular saukar karatu"),
            keywords: &[
                "hula",
                "hular saukar karatu",
                "saukar karatu",
                "shagali",
                "sutura",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כובע סיום לימודים"),
            keywords: &[
                "אוניברסיטה",
                "אקדמיה",
                "דיפלומה",
                "כובע",
                "כובע סיום לימודים",
                "תעודה",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{94d}नातक टोप"),
            keywords: &["टोपी", "समारोह", "स\u{94d}नातक", "स\u{94d}नातक टोप"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("maturalna kapa"),
            keywords: &[
                "diploma",
                "kapa",
                "kićanka",
                "matura",
                "maturalna kapa",
                "odjeća",
                "slavlje",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("diplomaosztón használt kalap"),
            keywords: &[
                "diplomaosztó",
                "diplomaosztón használt kalap",
                "kalap",
                "ruha",
                "ruházat",
                "ünneplés",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("շրջանավարտի գլխարկ"),
            keywords: &[
                "ավարտական",
                "գլխարկ",
                "հագուստ",
                "շրջանավարտի գլխարկ",
                "տոն",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("topi wisuda"),
            keywords: &["pakaian", "perayaan", "toga", "topi", "wisuda"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("òkpu nzere"),
            keywords: &["enwemụaṅụrị", "na-eme akwà", "nzere", "òkpu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("útskriftarhúfa"),
            keywords: &[
                "hátíð",
                "húfa",
                "stúdentshúfa",
                "útskrift",
                "útskriftarhúfa",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cappello da laureato"),
            keywords: &["cappello", "cappello da laureato", "festa", "laurea"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("角帽"),
            keywords: &["卒業", "帽子", "角帽"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("topi wisuda"),
            keywords: &["perayaan", "sandhangan", "topi", "wisuda"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გამოსაშვები ქუდი"),
            keywords: &[
                "აღნიშვნა",
                "გამოსაშვები ქუდი",
                "გამოშვება",
                "ზეიმი",
                "ტანსაცმელი",
                "ქუდი",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("agerdas"),
            keywords: &["agerdas"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бітіру қалпағы"),
            keywords: &[
                "бітіру",
                "бітіру қалпағы",
                "кепка",
                "киім",
                "тойлау",
                "қалпақ",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("eksamenshat"),
            keywords: &["eksamen", "eksamenshat", "hat"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bd}កទទ\u{17bd}លសញ\u{17d2}ញាបត\u{17d2}រ"),
            keywords: &[
                "ទទ\u{17bd}លសញ\u{17d2}ញាបត\u{17d2}រ",
                "ម\u{17bd}ក",
                "ម\u{17bd}កទទ\u{17bd}លសញ\u{17d2}ញាបត\u{17d2}រ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪದವ\u{cbf} ಕ\u{ccd}ಯಾಪ\u{ccd}"),
            keywords: &[
                "ಪದವ\u{cbf}",
                "ಪದವ\u{cbf} ಕ\u{ccd}ಯಾಪ\u{ccd}",
                "ಪದವ\u{cbf} ವ\u{ccd}ಯಾಸಂಗದ ಟೊಪ\u{ccd}ಪ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("졸업 모자"),
            keywords: &["졸업", "졸업 모자", "졸업생", "졸업식"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पदवी क\u{945}प"),
            keywords: &[
                "कपड\u{947}",
                "क\u{945}प",
                "पदवी",
                "स\u{941}वाळो",
                "ह\u{945}ट",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бүтүрүүчүлөрдүн баш кийими"),
            keywords: &[
                "баш кийим",
                "бүтүрүүчү",
                "бүтүрүүчүлөрдүн баш кийими",
                "кийим",
                "майрам",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Diplomiwwerreechungshutt"),
            keywords: &[
                "Diplomiwwerreechung",
                "Diplomiwwerreechungshutt",
                "Feier",
                "Hutt",
                "Kap",
                "Kleedung",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໝວກຮ\u{eb1}ບໃບປະກາດ"),
            keywords: &["ໃບປະກາດ", "ໝວກ", "ໝວກຮ\u{eb1}ບໃບປະກາດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mokyklos baigimo kepurėlė"),
            keywords: &[
                "baigimas",
                "drabužiai",
                "kepurė",
                "kepurėlė",
                "mokyklos baigimo kepurėlė",
                "šventė",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("izlaiduma cepure"),
            keywords: &[
                "absolventa cepure",
                "cepure",
                "izlaiduma cepure",
                "izlaidums",
                "svinības",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kape whiwhinga tohu"),
            keywords: &[
                "kape",
                "kape whiwhinga tohu",
                "kākahu",
                "paetahi",
                "pōtae",
                "whakanuinga",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("капа за дипломирање"),
            keywords: &[
                "диплома",
                "капа",
                "капа за дипломирање",
                "матура",
                "прослава",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ബിര\u{d41}ദ ക\u{d4d}യ\u{d3e}പ\u{d4d}പ\u{d4d}"),
            keywords: &[
                "ആഘോഷം",
                "ക\u{d4d}യ\u{d3e}പ\u{d4d}പ\u{d4d}",
                "ഗ\u{d4d}ര\u{d3e}ജ\u{d4d}യ\u{d41}വേഷൻ ക\u{d4d}യ\u{d3e}പ\u{d4d}പ\u{d4d}",
                "ബിര\u{d41}ദ ക\u{d4d}യ\u{d3e}പ\u{d4d}പ\u{d4d}",
                "ബിര\u{d41}ദം",
                "ബിര\u{d41}ദദ\u{d3e}ന തൊപ\u{d4d}പി",
                "വസ\u{d4d}\u{200c}ത\u{d4d}രം",
                "ഹ\u{d3e}റ\u{d4d}റ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("төгсөлтийн малгай"),
            keywords: &[
                "малгай",
                "тэмдэглэх",
                "төгсөлт",
                "төгсөлтийн малгай",
                "хувцаслалт",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पदवी घ\u{947}ताना घालायची टोपी"),
            keywords: &[
                "उत\u{94d}सव",
                "कपड\u{947}",
                "टोपी",
                "पदवी",
                "पदवी घ\u{947}ताना घालायची टोपी",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("topi konvokesyen"),
            keywords: &[
                "kep",
                "pakaian",
                "rai",
                "tamat pengajian",
                "topi konvokesyen",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("berettin tal-gradwazzjoni"),
            keywords: &[
                "berettin",
                "berettin tal-gradwazzjoni",
                "gradwazzjoni",
                "kappell",
                "ċelebrazzjoni",
                "ħwejjeġ",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဘ\u{103d}\u{1032}\u{1037}ဦးထ\u{102f}ပ\u{103a}"),
            keywords: &[
                "ဘ\u{103d}\u{1032}\u{1037}န\u{103e}င\u{103a}းသဘင\u{103a}",
                "ဘ\u{103d}\u{1032}\u{1037}ဦးထ\u{102f}ပ\u{103a}",
                "အဝတ\u{103a}အထည\u{103a}",
                "အောင\u{103a}ပ\u{103d}\u{1032}ခ\u{1036}ခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("studentlue"),
            keywords: &["feiring", "hatt", "klær", "studentlue", "uteksaminering"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("दीक\u{94d}षान\u{94d}त टोपी"),
            keywords: &[
                "उत\u{94d}सव मनाउन\u{941}",
                "कपडा",
                "छत\u{94d}र\u{947} टोपी",
                "टोपी",
                "दीक\u{94d}षान\u{94d}त टोपी",
                "श\u{948}क\u{94d}षिक योग\u{94d}यता हासिल गर\u{94d}न\u{941}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("academische baret"),
            keywords: &[
                "academische baret",
                "eindexamen",
                "hoed",
                "kleding",
                "viering",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("studentlue"),
            keywords: &["feiring", "hatt", "klede", "studentlue", "uteksaminering"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b4d}ନ\u{b3e}ତକ ଟୋପ\u{b3f}"),
            keywords: &[
                "ଉତ\u{b4d}ସବ",
                "ଗ\u{b4d}ର\u{b3e}ଜ\u{b41}ଏସନ\u{b4d} ଟୋପ\u{b3f}",
                "ଟୋପ\u{b3f}",
                "ସ\u{b4d}ନ\u{b3e}ତକ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਗ\u{a4d}ਰ\u{a48}ਜ\u{a42}ਏਸ\u{a3c}ਨ ਟ\u{a4b}ਪੀ"),
            keywords: &[
                "ਕ\u{a48}ਪ",
                "ਗ\u{a4d}ਰ\u{a48}ਜ\u{a42}ਏਸ\u{a3c}ਨ",
                "ਜਸ\u{a3c}ਨ",
                "ਟ\u{a4b}ਪੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("گریجویشن دی ٹوپی"),
            keywords: &[
                "منانا",
                "ٹوپی",
                "کپڑے",
                "گریجویشن",
                "گریجویشن دی ٹوپی",
                "ہیٹ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Grajuẹt Sẹ\u{301}rímọ\u{301}ni Kap"),
            keywords: &[
                "Grajuéshọn",
                "Grajuẹt Sẹ\u{301}rímọ\u{301}ni Kap",
                "Hat",
                "Kap",
                "Klọt",
                "Sẹlibréshọn",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("biret"),
            keywords: &[
                "biret",
                "czapka absolwenta",
                "nakrycie głowy",
                "ubiór",
                "uroczystość",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("فراغت خولۍ"),
            keywords: &["خولۍ", "فراغت", "لباس", "لمانځل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("chapéu de formatura"),
            keywords: &["chapéu", "chapéu de formatura", "comemoração", "formatura"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("chapéu de graduação"),
            keywords: &[
                "acessório",
                "celebração",
                "chapéu",
                "chapéu de finalista",
                "chapéu de graduação",
                "formatura",
                "licenciatura",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("graduacion chiku"),
            keywords: &["graduacion chiku"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("tichie de absolvent"),
            keywords: &[
                "absolvire",
                "festiv",
                "pălărie",
                "sărbătorire",
                "tichie de absolvent",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-344"),
            keywords: &["E10-344"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("шапочка выпускника"),
            keywords: &[
                "бонет",
                "выпускник",
                "выпускной",
                "конфедератка",
                "шапочка",
                "шапочка выпускника",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ingofero yo gusoza kaminuza"),
            keywords: &[
                "ibirori",
                "ibirori byo guhabwa impamyabumenyi",
                "ingofero",
                "ingofero yo gusoza kaminuza",
                "umwambaro",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("گريجوئيشن واري ٽوپي"),
            keywords: &[
                "توپي",
                "لباس",
                "ملهائڻ",
                "ٽوپي",
                "گريجوئيشن",
                "گريجوئيشن واري ٽوپي",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("උප\u{dcf}ධ\u{dd2} තොප\u{dca}ප\u{dd2}ය"),
            keywords: &[
                "ඇඳ\u{dd4}ම\u{dca}",
                "උත\u{dca}සවය",
                "උප\u{dcf}ධ\u{dd2} තොප\u{dca}ප\u{dd2}ය",
                "උප\u{dcf}ධ\u{dd2} ප\u{dca}\u{200d}රද\u{dcf}නෝත\u{dca}සවය",
                "තොප\u{dca}ප\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("promočná čiapka"),
            keywords: &[
                "klobúk",
                "oblečenie",
                "oslava",
                "promočná čiapka",
                "promócia",
                "čiapka",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("maturantska kapa"),
            keywords: &[
                "kapa",
                "klobuk",
                "matura",
                "maturantska kapa",
                "oblačila",
                "slavje",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("koofiyada qalinjabinta"),
            keywords: &[
                "dabaaldeg",
                "dhar",
                "koofiyad",
                "koofiyada qalinjabinta",
                "qalinjabin",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kapelë diplomimi"),
            keywords: &["diplomim", "festë", "kapelë", "kapelë diplomimi"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("капа за дипломце"),
            keywords: &[
                "капа",
                "капа за дипломце",
                "матура",
                "одећа",
                "прослава",
                "шешир",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["капа за дипломце"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kapa za diplomce"),
            keywords: &[
                "kapa",
                "kapa za diplomce",
                "matura",
                "odeća",
                "proslava",
                "šešir",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["kapa za diplomce"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("examenshatt"),
            keywords: &["examen", "examenshatt", "hatt", "högtid"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kofia ya mahafali"),
            keywords: &[
                "hitimu",
                "kofia",
                "kofia ya mahafali",
                "kusherehekea",
                "mavazi",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பட\u{bcd}டமளிப\u{bcd}புத\u{bcd} தொப\u{bcd}பி"),
            keywords: &[
                "கல\u{bcd}லூரி",
                "கொண\u{bcd}ட\u{bbe}ட\u{bcd}டம\u{bcd}",
                "தொப\u{bcd}பி",
                "பட\u{bcd}டமளிப\u{bcd}பு",
                "பட\u{bcd}டமளிப\u{bcd}புத\u{bcd} தொப\u{bcd}பி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("పట\u{c4d}టభద\u{c4d}రుల ట\u{c4b}ప\u{c40}"),
            keywords: &[
                "ట\u{c4b}ప\u{c40}",
                "పట\u{c4d}టభద\u{c4d}రుల ట\u{c4b}ప\u{c40}",
                "పట\u{c4d}టభద\u{c4d}రులు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("конфедератка"),
            keywords: &["кепка", "конфедератка", "кулоҳ", "либос", "хатм", "ҷашн"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หมวกร\u{e31}บปร\u{e34}ญญา"),
            keywords: &["ร\u{e31}บปร\u{e34}ญญา", "หมวก", "หมวกร\u{e31}บปร\u{e34}ญญา"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("uçurym papagy"),
            keywords: &[
                "dabara",
                "eşik",
                "gutardyş",
                "kepka",
                "papak",
                "uçurym papagy",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tatā maʻu mataʻitohi"),
            keywords: &["tatā maʻu mataʻitohi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("mezuniyet kepi"),
            keywords: &["kep", "kutlama", "mezuniyet", "mezuniyet kepi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئوقۇش پۈتتۈرۈش قالپىقى"),
            keywords: &[
                "ئوقۇش پۈتتۈرۈش",
                "ئوقۇش پۈتتۈرۈش قالپىقى",
                "تەبرىكلەش",
                "شەپكە",
                "قالپاق",
                "كىيىم",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("квадратна академічна шапочка"),
            keywords: &[
                "випуск",
                "капелюх",
                "квадратна академічна шапочка",
                "одяг",
                "шапка",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گریجوئیشن کیپ"),
            keywords: &["لباس", "ٹوپی", "گریجوئیشن", "گریجوئیشن کیپ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("akademik bosh kiyim"),
            keywords: &[
                "akademik bosh kiyim",
                "bitiruv",
                "kiyim",
                "nishonlash",
                "qalpoq",
                "shapka",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mũ tốt nghiệp"),
            keywords: &[
                "cái mũ",
                "lễ kỷ niệm",
                "mũ tốt nghiệp",
                "quần áo",
                "tốt nghiệp",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("mbaxane lijaasa"),
            keywords: &[
                "joxe-lijaasa",
                "kap",
                "mbaxane",
                "mbaxane lijaasa",
                "màggal",
                "yéere",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umnqwazi wothweso-zidanga"),
            keywords: &[
                "impahla",
                "umbhiyozo",
                "umnqwazi",
                "umnqwazi wothweso-zidanga",
                "uthweso-zidanga",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Fila Aṣeyọri"),
            keywords: &["Fila Aṣeyọri", "ayẹyẹ", "aṣọ", "fìlà", "àṣeyọrí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("畢業帽"),
            keywords: &["帽", "慶祝", "服裝", "畢業", "畢業帽"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("毕业帽"),
            keywords: &["帽", "庆祝", "服装", "毕业", "毕业帽"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("毕业帽"),
            keywords: &["四方帽", "毕业帽"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("畢業帽"),
            keywords: &["畢業帽"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isigqoko semiyezane"),
            keywords: &[
                "ikepisi",
                "impahla yokugqoka",
                "isigqoko",
                "isigqoko semiyezane",
                "ukuthweswa imiyezane",
                "umbungazo",
            ],
        },
    ],
};
#[doc = "🧢"]
pub const BILLED_CAP: crate::Emoji = crate::Emoji {
    glyph: "🧢",
    codepoint: "1F9E2",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "billed cap",
    group: "Objects",
    subgroup: "clothing",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("hardepuntpet"),
            keywords: &["bofbalpet", "hardepuntpet"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የተከፈለበት ባርኔጣ"),
            keywords: &["የተከፈለበት ባርኔጣ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Som