#[doc = "📔"]
pub const NOTEBOOK_WITH_DECORATIVE_COVER: crate::Emoji = crate::Emoji {
    glyph: "📔",
    codepoint: "1F4D4",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "notebook with decorative cover",
    group: "Objects",
    subgroup: "book-paper",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("notaboek met sieromslag"),
            keywords: &[
                "boek",
                "notaboek",
                "notaboek met sieromslag",
                "omslag",
                "versiering",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ባለጌጥ ሽፋን ማስታወሻ ደብተር"),
            keywords: &["መጽሐፍ", "ማስታወሻ ደብተር", "ሽፋን", "ባለጌጥ ሽፋን ማስታወሻ ደብተር", "ያጌጠ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("دفتر مزين"),
            keywords: &["دفتر مزخرف", "دفتر مزين", "دفتر ملاحظات", "غلاف"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("অলংক\u{9c3}ত বেট\u{9c1}প\u{9be}তয\u{9c1}ক\u{9cd}ত টোক\u{9be}বহী"),
            keywords: &[
                "অলংক\u{9c3}ত",
                "অলংক\u{9c3}ত বেট\u{9c1}প\u{9be}তয\u{9c1}ক\u{9cd}ত টোক\u{9be}বহী",
                "কিত\u{9be}প",
                "টোক\u{9be}বহী",
                "বেট\u{9c1}প\u{9be}ত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("bəzəkli cildli dəftər"),
            keywords: &[
                "bəzəkli cildli dəftər",
                "bəzənmiş",
                "cild",
                "dəftər",
                "kitab",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("нататнік з дэкаратыўнай вокладкай"),
            keywords: &[
                "вокладка",
                "дэкаратыўны",
                "кніга",
                "нататнік",
                "нататнік з дэкаратыўнай вокладкай",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Бележник с декоративна корица"),
            keywords: &[
                "Бележник с декоративна корица",
                "бележник",
                "книга",
                "корица",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("সজ\u{9cd}জিত মল\u{9be}টয\u{9c1}ক\u{9cd}ত নোটবই"),
            keywords: &[
                "আবরণ",
                "নোটবই",
                "বই",
                "সজ\u{9cd}জিত",
                "সজ\u{9cd}জিত মল\u{9be}টয\u{9c1}ক\u{9cd}ত নোটবই",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("karned gant golo kinklet"),
            keywords: &["golo", "karned", "karned gant golo kinklet", "levr"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("sveska sa ukrasnim koricama"),
            keywords: &[
                "knjiga",
                "korice",
                "sveska",
                "sveska sa ukrasnim koricama",
                "ukrasne",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("quadern amb coberta decorativa"),
            keywords: &[
                "coberta decorativa",
                "llibre",
                "quadern",
                "quadern amb coberta decorativa",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎪᏪᎵ ᎤᎵᎪᏒ ᏗᏟᎶᏍᏓᏅ ᎫᏢᏗ"),
            keywords: &["ᎪᏪᎵ", "ᎪᏪᎵ ᎤᎵᎪᏒ ᏗᏟᎶᏍᏓᏅ ᎫᏢᏗ", "ᎪᏪᎶᏗᎢ ᎪᏪᎵ", "ᎫᏝᎥ", "ᏓᏟᎶᏍᏗᏓᏅᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zápisník v ozdobných deskách"),
            keywords: &[
                "desky",
                "kniha",
                "obal",
                "obálka",
                "ozdobené",
                "ozdobné",
                "zdobené",
                "zápisník",
                "zápisník v ozdobných deskách",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("llyfr nodiadau gyda chlawr addurnol"),
            keywords: &[
                "addurnol",
                "clawr",
                "llyfr",
                "llyfr nodiadau",
                "llyfr nodiadau gyda chlawr addurnol",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("notesbog med udsmykning"),
            keywords: &["notesbog", "notesbog med udsmykning"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Notizbuch mit dekorativem Einband"),
            keywords: &["Einband", "Notizbuch", "Notizbuch mit dekorativem Einband"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σημειωματάριο με διακοσμητικό εξώφυλλο"),
            keywords: &[
                "βιβλίο",
                "διακοσμημένο",
                "εξώφυλλο",
                "σημειωματάριο",
                "σημειωματάριο με διακοσμητικό εξώφυλλο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("notebook with decorative cover"),
            keywords: &[
                "book",
                "cover",
                "decorated",
                "notebook",
                "notebook with decorative cover",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cuaderno con tapa decorativa"),
            keywords: &[
                "cuaderno",
                "cuaderno con tapa decorativa",
                "decoración",
                "tapa",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "cuaderno",
                "cuaderno con tapa decorativa",
                "decorado",
                "tapa",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("dekoratiivse kaanega märkmik"),
            keywords: &[
                "dekoratiivse kaanega märkmik",
                "kaaned",
                "märkmik",
                "raamat",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("estalki apaingarria duen koadernoa"),
            keywords: &[
                "apaindu",
                "estalki",
                "estalki apaingarria duen koadernoa",
                "koaderno",
                "liburu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دفتر با جلد سخت"),
            keywords: &[
                "جلد",
                "دفتر",
                "دفتر با جلد تزئینی",
                "دفتر با جلد سخت",
                "صحافی",
                "کتاب",
                "کتاب صحافی\u{200c}شده",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("koristeellinen muistikirja"),
            keywords: &[
                "kansi",
                "kirja",
                "koristeellinen muistikirja",
                "lehtiö",
                "muistikirja",
                "muistio",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("notebook na may disenyo ang pabalat"),
            keywords: &[
                "libro",
                "may disenyo",
                "notebook",
                "notebook na may disenyo ang pabalat",
                "pabalat",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("lummabók við prýðiligari perma"),
            keywords: &[
                "lummabók",
                "lummabók við prýðiligari perma",
                "perma",
                "prýðilig",
                "umslag",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("carnet avec couverture"),
            keywords: &["carnet", "carnet avec couverture"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("carnet avec couverture décorative"),
            keywords: &[
                "bloc-notes",
                "carnet avec couverture décorative",
                "couverture",
                "livre",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("leabhar nótaí maisithe"),
            keywords: &["leabhar nótaí maisithe"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("leabhar-nòtaichean sgeadaichte"),
            keywords: &[
                "còmhdachadh",
                "leabhar",
                "leabhar-nòtaichean",
                "leabhar-nòtaichean le còmhdachadh sgeadaichte",
                "sgeadaichte",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("caderno de tapas decoradas"),
            keywords: &[
                "caderno",
                "caderno de tapas decoradas",
                "cuberta",
                "decorada",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{ac1}શોભિત કવરવાળી નોટબ\u{ac1}ક"),
            keywords: &[
                "કવર",
                "નોટબ\u{ac1}ક",
                "સ\u{ac1}શોભનવાળી નોટબ\u{ac1}ક",
                "સ\u{ac1}શોભિત કવરવાળી નોટબ\u{ac1}ક",
                "સ\u{ac1}શોભિત નોટબ\u{ac1}ક",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("littafin rubutu mai sama na ado"),
            keywords: &[
                "littafi",
                "littafin rubutu",
                "littafin rubutu mai sama na ado",
                "mai ado",
                "sama",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מחברת עם כריכה מעוטרת"),
            keywords: &["כריכה", "מחברת", "מחברת עם כריכה מעוטרת", "ספר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सजावटी कवर वाली नोटब\u{941}क"),
            keywords: &[
                "कवर",
                "किताब",
                "नोटब\u{941}क",
                "सजावट",
                "सजावटी कवर वाली नोटब\u{941}क",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("bilježnica s ukrasnim omotom"),
            keywords: &[
                "bilježnica",
                "bilježnica s ukrasnim omotom",
                "knjiga",
                "omot",
                "ukras",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("jegyzetfüzet díszkötésben"),
            keywords: &[
                "borító",
                "díszes",
                "díszkötés",
                "füzet",
                "jegyzetfüzet",
                "jegyzetfüzet díszkötésben",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ձևավոր կազմով տետր"),
            keywords: &[
                "գիրք",
                "կազմ",
                "ձևավոր կազմով տետր",
                "ձևավորված",
                "նոթատետր",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("buku catatan bersampul"),
            keywords: &[
                "buku",
                "buku catatan",
                "buku catatan bersampul",
                "dekorasi",
                "sampul",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akwụkwọnoòtù nwere mkpuchi ichọ mma"),
            keywords: &[
                "akwụkwọ",
                "akwụkwọnoòtù",
                "akwụkwọnoòtù nwere mkpuchi ichọ mma",
                "edoziri nke oma",
                "kpuchie",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("glósubók með skrautkápu"),
            keywords: &[
                "glósubók",
                "glósubók með skrautkápu",
                "kápa",
                "skreytt glósubók",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("quaderno con copertina decorata"),
            keywords: &[
                "copertina",
                "quaderno con copertina decorata",
                "taccuino",
                "taccuino con decorazione",
                "taccuino copertina decorata",
                "taccuino decorato",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("表紙付きノート"),
            keywords: &["文具", "文房具", "表紙付きノート"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("notebook wadhahe motif apik"),
            keywords: &[
                "buku",
                "kanthong wadhah",
                "motif",
                "notebook",
                "notebook wadhahe motif apik",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("რვეული დეკორატიული ყდით"),
            keywords: &[
                "დეკორირებული",
                "რვეული",
                "რვეული დეკორატიული ყდით",
                "ყდა",
                "წიგნი",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("imedlis s tduli icebḥen"),
            keywords: &["imedlis s tduli icebḥen"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("декоративтік мұқабасы бар дәптер"),
            keywords: &[
                "безелген",
                "декоративтік мұқабасы бар дәптер",
                "дәптер",
                "кітап",
                "мұқаба",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("notesbog med udsmykning"),
            keywords: &["notesbog", "notesbog med udsmykning"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សៀវភៅកត\u{17cb}ត\u{17d2}រាមានក\u{17d2}រប"),
            keywords: &[
                "ក\u{17bc}នសៀវភៅ",
                "សៀវភៅ",
                "សៀវភៅកត\u{17cb}ត\u{17d2}រា",
                "សៀវភៅកត\u{17cb}ត\u{17d2}រាមានក\u{17d2}រប",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಅಲಂಕಾರ\u{cbf}ಕ ಕವರ\u{cbf}ನ ನೋಟ\u{ccd}\u{200c}ಬುಕ\u{ccd}"),
            keywords: &[
                "ಅಲಂಕಾರದೊಂದ\u{cbf}ಗ\u{cc6} ನೋಟ\u{ccd}\u{200c}ಬುಕ\u{ccd}",
                "ಅಲಂಕಾರ\u{cbf}ಕ ಕವರ\u{cbf}ನ ನೋಟ\u{ccd}\u{200c}ಬುಕ\u{ccd}",
                "ಅಲಾಂಕಾರ\u{cbf}ತ ಕವರ\u{cbf}ನ ನೋಟ\u{ccd}\u{200c}ಬುಕ\u{ccd}",
                "ಕವರ\u{ccd}",
                "ನೋಟ\u{ccd}\u{200c}ಬುಕ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("표지가 있는 노트"),
            keywords: &["공책", "노트", "표지가 있는 노트"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("श\u{943}\u{902}गारक कवरा सयत चोपडी"),
            keywords: &[
                "कवर",
                "चोपडी",
                "प\u{941}स\u{94d}तक",
                "श\u{943}\u{902}गार क\u{947}ल\u{94d}ल\u{947}\u{902}",
                "श\u{943}\u{902}गारक कवरा सयत चोपडी",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("мукабасы кооздолгон блокнот"),
            keywords: &[
                "блокнот",
                "кооздолгон",
                "мукаба",
                "мукабасы кооздолгон блокнот",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("dekoréierten Notizblock"),
            keywords: &[
                "Buch",
                "Deckel",
                "Notizblock",
                "dekoréiert",
                "dekoréierten Notizblock",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some(
                "ປ\u{eb7}\u{ec9}ມບ\u{eb1}ນທ\u{eb6}ກທ\u{eb5}ໜ\u{ec9}າປ\u{ebb}ກໄດ\u{ec9}ຮ\u{eb1}ບການຕ\u{ebb}ບແຕ\u{ec8}ງ",
            ),
            keywords: &[
                "ຕ\u{ebb}ບແຕ\u{ec8}ງ",
                "ທ\u{eb5}\u{ec8}ໜ\u{ec9}າປ\u{ebb}ກໄດ\u{ec9}ຮ\u{eb1}ບການຕ\u{ebb}ບແຕ\u{ec8}ງ",
                "ປ\u{eb6}\u{ec9}ມບ\u{eb1}ນທ\u{eb6}ກ",
                "ປ\u{eb7}\u{ec9}ມ",
                "ປ\u{eb7}\u{ec9}ມບ\u{eb1}ນທ\u{eb6}ກທ\u{eb5}ໜ\u{ec9}າປ\u{ebb}ກໄດ\u{ec9}ຮ\u{eb1}ບການຕ\u{ebb}ບແຕ\u{ec8}ງ",
                "ໜ\u{ec9}າປ\u{ebb}ກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("užrašų knygelė su dekoratyviniu viršeliu"),
            keywords: &[
                "dekoratyvinis",
                "knyga",
                "užrašų knygelė",
                "užrašų knygelė su dekoratyviniu viršeliu",
                "viršelis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("bloknots ar dekoratīvu vāku"),
            keywords: &[
                "bloknots",
                "bloknots ar dekoratīvu vāku",
                "dekoratīvs",
                "grāmata",
                "vāks",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pukatuhipoka whai uhi whakairoiro"),
            keywords: &[
                "pukapuka",
                "pukatuhipoka",
                "pukatuhipoka whai uhi whakairoiro",
                "uhi",
                "whakairoiro",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("тетратка со украсна корица"),
            keywords: &["корица", "тетратка", "тетратка со украсна корица", "украс"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ഭംഗിയ\u{d41}ള\u{d4d}ള കവറ\u{d41}ള\u{d4d}ള നോട\u{d4d}ട\u{d4d}ബ\u{d41}ക\u{d4d}ക\u{d4d}",
            ),
            keywords: &[
                "അലങ\u{d4d}കരിച\u{d4d}ച നോട\u{d4d}ട\u{d4d} ബ\u{d41}ക\u{d4d}ക\u{d4d}",
                "അലങ\u{d4d}ക\u{d3e}രമ\u{d41}ള\u{d4d}ള നോട\u{d4d}ട\u{d4d} ബ\u{d41}ക\u{d4d}ക\u{d4d}",
                "ഭംഗിയ\u{d41}ള\u{d4d}ള കവറ\u{d41}ള\u{d4d}ള നോട\u{d4d}ട\u{d4d}ബ\u{d41}ക\u{d4d}ക\u{d4d}",
                "ഭംഗിയ\u{d41}ള\u{d4d}ള കവർ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("чимэглэсэн хавтастай тэмдэглэлийн дэвтэр"),
            keywords: &[
                "ном",
                "тэмдэглэлийн дэвтэр",
                "хавтас",
                "чимэглэсэн",
                "чимэглэсэн хавтастай тэмдэглэлийн дэвтэр",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("सजावटीच\u{94d}या कव\u{94d}हरसह वही"),
            keywords: &[
                "कव\u{94d}हर",
                "नोटब\u{941}क",
                "प\u{941}स\u{94d}तक",
                "सजविल\u{947}ल\u{947}",
                "सजावटीच\u{94d}या कव\u{94d}हरसह वही",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("buku nota dengan kulit berhias"),
            keywords: &[
                "berhias",
                "buku",
                "buku nota",
                "buku nota dengan kulit berhias",
                "kulit",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("notebook b’kopertura dekorattiva"),
            keywords: &[
                "imżejna",
                "kopertura",
                "ktieb",
                "notebook",
                "notebook b’kopertura dekorattiva",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အလ\u{103e}မျက\u{103a}န\u{103e}ာဖ\u{102f}\u{1036}းန\u{103e}င\u{1037}\u{103a} မ\u{103e}တ\u{103a}စ\u{102f}စာအ\u{102f}ပ\u{103a}",
            ),
            keywords: &[
                "စာအ\u{102f}ပ\u{103a}",
                "ပြင\u{103a}ဆင\u{103a}ထားခြင\u{103a}း",
                "မ\u{103e}တ\u{103a}စ\u{102f}စာအ\u{102f}ပ\u{103a}",
                "အဖ\u{102f}\u{1036}း",
                "အလ\u{103e}မျက\u{103a}န\u{103e}ာဖ\u{102f}\u{1036}းန\u{103e}င\u{1037}\u{103a} မ\u{103e}တ\u{103a}စ\u{102f}စာအ\u{102f}ပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("dekorert notatbok"),
            keywords: &["dekorert notatbok", "notatbok", "omslag"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("सजिएको कभरसहितको नोटब\u{941}क"),
            keywords: &[
                "कभर",
                "नोटब\u{941}क",
                "प\u{941}स\u{94d}तक",
                "सजिएको",
                "सजिएको कभरसहितको नोटब\u{941}क",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("versierd schrift"),
            keywords: &["boek", "notitieboekje", "omslag", "schrift", "versierd"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("dekorert notatbok"),
            keywords: &["dekorert notatbok", "notatbok", "omslag"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଶୋଭ\u{b3e}ବର\u{b4d}ଦ\u{b4d}ଧକ ମଲ\u{b3e}ଟ ଥ\u{b3f}ବ\u{b3e} ନୋଟ\u{b4d}\u{200c}ବ\u{b41}କ\u{b4d}\u{200c}",
            ),
            keywords: &[
                "କଭର\u{b4d}",
                "ଚ\u{b3f}ତ\u{b4d}ରବ\u{b3f}ଚ\u{b3f}ତ\u{b4d}ର ନୋଟ\u{b4d}\u{200c}ବ\u{b41}କ\u{b4d}",
                "ଚ\u{b3f}ତ\u{b4d}ରବ\u{b3f}ଚ\u{b3f}ତ\u{b4d}ର ବ\u{b3f}ଶ\u{b3f}ଷ\u{b4d}ଟ ନୋଟ\u{b4d}\u{200c}ବ\u{b41}କ\u{b4d}",
                "ନୋଟ\u{b4d}\u{200c}ବ\u{b41}କ\u{b4d}",
                "ଶୋଭ\u{b3e}ବର\u{b4d}ଦ\u{b4d}ଧକ ମଲ\u{b3e}ଟ ଥ\u{b3f}ବ\u{b3e} ନୋଟ\u{b4d}\u{200c}ବ\u{b41}କ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਜਾਵਟੀ ਕਵਰ ਨਾਲ ਨ\u{a4b}ਟਬ\u{a41}\u{a71}ਕ"),
            keywords: &[
                "ਕਵਰ",
                "ਨ\u{a4b}ਟਬ\u{a41}\u{a71}ਕ",
                "ਸਜਾਇਆ ਨ\u{a4b}ਟਬ\u{a41}\u{a71}ਕ",
                "ਸਜਾਵਟ ਨਾਲ ਨ\u{a4b}ਟਬ\u{a41}\u{a71}ਕ",
                "ਸਜਾਵਟੀ ਕਵਰ ਨਾਲ ਨ\u{a4b}ਟਬ\u{a41}\u{a71}ਕ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("آرائشی پن\u{651}ے نال نوٹ بک"),
            keywords: &[
                "آرائشی پن\u{651}ے نال نوٹ بک",
                "سجایا ہوئیا",
                "نوٹ بک",
                "ڈھکنا",
                "کتاب",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Nótbuk Wé Gẹ\u{301}t Faín Kọ\u{301}va"),
            keywords: &[
                "Buk",
                "Dẹkọret",
                "Kọ\u{301}va",
                "Nótbuk",
                "Nótbuk Wé Gẹ\u{301}t Faín Kọ\u{301}va",
                "To Mék Sọ\u{301}mtin Mék I Fain",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("notes z dekoracyjną okładką"),
            keywords: &[
                "książka",
                "notatnik",
                "notes",
                "notes z dekoracyjną okładką",
                "okładka",
                "ozdobna",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د ښايسته جلد کاپي"),
            keywords: &["جلد", "د ښايسته جلد کاپي", "ښايسته", "کاپي", "کتاب"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("caderno decorado"),
            keywords: &["caderno", "capa", "decorado", "livro"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("bloco de notas com capa decorada"),
            keywords: &[
                "bloco de notas",
                "bloco de notas com capa decorada",
                "capa",
                "decorada",
                "livro",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("yachaykunapaq pʼanqa kʼacha rapiwan"),
            keywords: &["yachaykunapaq pʼanqa kʼacha rapiwan"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("caiet cu copertă decorativă"),
            keywords: &[
                "caiet",
                "caiet cu copertă decorativă",
                "carnet",
                "copertă",
                "decorațiune",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-657"),
            keywords: &["E10-657"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("записная книжка"),
            keywords: &["блокнот", "записная", "книжка", "красивая", "обложка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikayi ifite igifuniko gitatse"),
            keywords: &[
                "agatabo",
                "gitatse",
                "igifuniko",
                "igitabo",
                "ikayi ifite igifuniko gitatse",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سينگاريل پاٺي وارو ڪتاب"),
            keywords: &[
                "سينگاريل",
                "سينگاريل پاٺي وارو ڪتاب",
                "نوٽ بوڪ",
                "پاٺو",
                "ڪتاب",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අලංක\u{dcf}ර කවරයක\u{dca} සහ\u{dd2}ත සටහන\u{dca} පොත"),
            keywords: &[
                "අලංක\u{dcf}ර කවරයක\u{dca} සහ\u{dd2}ත සටහන\u{dca} පොත",
                "කවරය",
                "පොත",
                "සටහන\u{dca} පොත",
                "සැරස\u{dd2}ල\u{dd2}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zápisník so zdobeným obalom"),
            keywords: &[
                "kniha",
                "obal",
                "zdobený",
                "zápisník",
                "zápisník so zdobeným obalom",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zvezek z okrasno platnico"),
            keywords: &[
                "knjiga",
                "okrašeno",
                "platnica",
                "zvezek",
                "zvezek z okrasno platnico",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("buug gal qurux badan leh"),
            keywords: &["buug", "buug gal qurux badan leh", "gal", "la qurxiyay"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("bllok shënimesh me kapak dekorativ"),
            keywords: &[
                "bllok shënimesh",
                "bllok shënimesh me kapak dekorativ",
                "dekorativ",
                "kapak",
                "libër",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("свеска са украсним корицама"),
            keywords: &[
                "корице",
                "књигa",
                "свеска",
                "свеска са украсним корицама",
                "укрaс",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("sveska sa ukrasnim koricama"),
            keywords: &[
                "knjiga",
                "korice",
                "sveska",
                "sveska sa ukrasnim koricama",
                "ukras",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("anteckningsbok med dekorativt omslag"),
            keywords: &[
                "anteckningsbok med dekorativt omslag",
                "anteckningsbok med snyggt omslag",
                "skrivbok",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("daftari lenye jalada lililopambwa"),
            keywords: &[
                "daftari",
                "daftari lenye jalada lililopambwa",
                "jalada",
                "kitabu",
                "lililopambwa",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அழக\u{bbe}ன கவர\u{bcd} போடப\u{bcd}பட\u{bcd}ட நோட\u{bcd}டு"),
            keywords: &[
                "அட\u{bcd}டை",
                "அழக\u{bbe}ன கவர\u{bcd} போடப\u{bcd}பட\u{bcd}ட நோட\u{bcd}டு",
                "அழக\u{bbe}ன நோட\u{bcd}டு",
                "வேலைப\u{bcd}ப\u{bbe}ட\u{bbe}ன அட\u{bcd}டை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ముందువ\u{c48}పు అలంకర\u{c3f}ంచ\u{c3f}న పుస\u{c4d}తకం"),
            keywords: &[
                "అట\u{c4d}ట",
                "అలంక\u{c3e}రం",
                "పుస\u{c4d}తకం",
                "ముందువ\u{c48}పు అలంకర\u{c3f}ంచ\u{c3f}న పుస\u{c4d}తకం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дафтар бо муқоваи ороишӣ"),
            keywords: &[
                "дафтар",
                "дафтар бо муқоваи ороишӣ",
                "китоб",
                "муқова",
                "ороишдода",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("สม\u{e38}ดโน\u{e49}ตม\u{e35}ลาย"),
            keywords: &["สม\u{e38}ดโน\u{e49}ต", "สม\u{e38}ดโน\u{e49}ตม\u{e35}ลาย"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("bezelen gapakly depderçe"),
            keywords: &[
                "bezelen",
                "bezelen gapakly depderçe",
                "depderçe",
                "gapak",
                "kitap",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pepa tohi teuʻi"),
            keywords: &["pepa tohi teuʻi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("süslü not defteri"),
            keywords: &[
                "dekorasyonlu not defteri",
                "kapak",
                "not defteri",
                "süslü not defteri",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("رەڭلىك خاتىرە"),
            keywords: &["بېزەك", "تاش", "خاتىرە", "رەڭلىك خاتىرە", "كىتاب"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("записник у декоративній обкладинці"),
            keywords: &[
                "декоративна",
                "записник",
                "записник у декоративній обкладинці",
                "книжка",
                "обкладинка",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سجاوٹی کوور والی نوٹ بک"),
            keywords: &["سجاوٹ", "سجاوٹی کوور والی نوٹ بک", "نوٹ بک", "کتاب", "کوور"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("bezakli muqovali daftar"),
            keywords: &[
                "bezak",
                "bezakli muqovali daftar",
                "daftar",
                "kitob",
                "muqova",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("sổ ghi chép có bìa trang trí"),
            keywords: &[
                "bìa",
                "sách",
                "sổ ghi chép",
                "sổ ghi chép có bìa trang trí",
                "trang trí",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kàrne bu ànd ak kubéer gu rafet"),
            keywords: &[
                "buñ-taaral",
                "kubéer",
                "kàrne",
                "kàrne bu ànd ak kubéer gu rafet",
                "téere",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("incwadi yamanqaku enomphandle ohonjisiweyo"),
            keywords: &[
                "ehonjisiweyo",
                "incwadi",
                "incwadi yamanqaku",
                "incwadi yamanqaku enomphandle ohonjisiweyo",
                "umphandle",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àfikọ\u{300}wé pẹlu ẹyin ọlọṣọ"),
            keywords: &[
                "àfikọ\u{300}wé pẹlu ẹyin ọlọṣọ",
                "ìwé",
                "ìwé àkọsílè\u{329}",
                "ìṣelẹ\u{301}ṣọ\u{300}ó\u{329}",
                "ẹ\u{300}yìn ìwé",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("有裝飾包裝嘅筆記簿"),
            keywords: &["封面", "書", "有裝飾包裝嘅筆記簿", "筆記簿", "裝飾"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("有装饰包装嘅笔记簿"),
            keywords: &["书", "封面", "有装饰包装嘅笔记簿", "笔记簿", "装饰"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("精装笔记本"),
            keywords: &["封面", "本子", "笔记", "笔记本", "精装笔记本", "记录"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("彩色封面的筆記本"),
            keywords: &["彩色封面的筆記本", "筆記本"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("彩色封面筆記簿"),
            keywords: &["彩色封面筆記簿", "彩色封面筆記簿｜筆記簿"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("incwajana enekhava ehlotshisiwe"),
            keywords: &[
                "ikhava",
                "incwadi",
                "incwajana",
                "incwajana enekhava ehlotshisiwe",
                "umhlobiso",
            ],
        },
    ],
};
#[doc = "📕"]
pub const CLOSED_BOOK: crate::Emoji = crate::Emoji {
    glyph: "📕",
    codepoint: "1F4D5",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "closed book",
    group: "Objects",
    subgroup: "book-paper",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("geslote boek"),
            keywords: &["boek", "geslote boek", "toe"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የተዘጋ መጽሐፍ"),
            keywords: &["መጽሐፍ", "የተዘጋ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كتاب مغلق"),
            keywords: &["كتاب", "كتاب مغلق"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বন\u{9cd}ধ কিত\u{9be}প"),
            keywords: &["কিত\u{9be}প", "বন\u{9cd}ধ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("bağlı kitab"),
            keywords: &["bağlı", "kitab"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("закрытая кніга"),
            keywords: &["закрытая", "кніга"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Затворена книга"),
            keywords: &["Затворена книга", "затворен", "книга"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বন\u{9cd}ধ বই"),
            keywords: &["বই", "বন\u{9cd}ধ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("levr serr"),
            keywords: &["levr", "serr"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zatvorena knjiga"),
            keywords: &["knjiga", "zatvorena"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("llibre tancat"),
            keywords: &["llibre", "tancat"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᏚᎲ ᎪᏪᎵ"),
            keywords: &["ᎠᏍᏚᎭ", "ᎠᏍᏚᎲ ᎪᏪᎵ", "ᎪᏪᎵ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zavřená kniha"),
            keywords: &["kniha", "zavřená kniha", "zavřený"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("llyfr ynghau"),
            keywords: &["llyfr", "ynghau"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("lukket bog"),
            keywords: &["bog", "lukket bog"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("geschlossenes Buch"),
            keywords: &["Buch", "geschlossen", "geschlossenes Buch"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κλειστό βιβλίο"),
            keywords: &["βιβλίο", "κλειστό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("closed book"),
            keywords: &["book", "closed"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("libro cerrado"),
            keywords: &["cerrado", "libro"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("suletud raamat"),
            keywords: &["raamat", "suletud"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("liburu itxia"),
            keywords: &["itxita", "liburu itxia", "liburua"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کتاب بسته"),
            keywords: &["بسته", "کتاب"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("suljettu kirja"),
            keywords: &["kirja", "suljettu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nakasarang aklat"),
            keywords: &["libro", "nakasara", "nakasarang aklat"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("afturlatin bók"),
            keywords: &["afturlatin", "bók"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("livre fermé"),
            keywords: &["livre", "livre fermé"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("leabhar dúnta"),
            keywords: &["leabhar", "leabhar dúnta"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("leabhar dùinte"),
            keywords: &["dùinte", "leabhar"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("libro pechado"),
            keywords: &["libro", "pechado"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બ\u{a82}ધ પ\u{ac1}સ\u{acd}તક"),
            keywords: &["પ\u{ac1}સ\u{acd}તક", "બ\u{a82}ધ પ\u{ac1}સ\u{acd}તક"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("rufaffen littafi"),
            keywords: &["littafi", "rufaffe", "rufaffen littafi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ספר סגור"),
            keywords: &["סגור", "ספר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ब\u{902}द किताब"),
            keywords: &["प\u{941}स\u{94d}तक", "ब\u{902}द किताब"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zatvorena knjiga"),
            keywords: &["knjiga", "zatvorena knjiga", "zatvoreno"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("becsukott könyv"),
            keywords: &["becsukott könyv", "csukott", "könyv"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("փակված գիրք"),
            keywords: &["գիրք", "փակված"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("buku tertutup"),
            keywords: &["buku", "tertutup"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akwukwọ emechiri"),
            keywords: &["akwukwọ emechiri", "akwụkwọ", "emechiri"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("lokuð bók"),
            keywords: &["bók", "lokuð bók"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("libro chiuso"),
            keywords: &["libro", "libro chiuso"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("閉じた本"),
            keywords: &["書籍", "閉じた本"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tutup buku"),
            keywords: &["buku", "nutup", "tutup buku"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დახურული წიგნი"),
            keywords: &["დახურული", "წიგნი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("adlis imedlen"),
            keywords: &["adlis imedlen"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жабық кітап"),
            keywords: &["жабық", "кітап"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("lukket bog"),
            keywords: &["bog", "lukket bog"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សៀវភៅប\u{17b7}ទ"),
            keywords: &["ប\u{17b7}ទ", "សៀវភៅ", "សៀវភៅប\u{17b7}ទ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮುಚ\u{ccd}ಚ\u{cbf}ದ ಪುಸ\u{ccd}ತಕ"),
            keywords: &["ಪುಸ\u{ccd}ತಕ", "ಮುಚ\u{ccd}ಚ\u{cbf}ದ ಪುಸ\u{ccd}ತಕ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("펼치지 않은 책"),
            keywords: &["도서", "책", "펼치지 않은 책"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("धा\u{902}पिल\u{94d}ल\u{947}\u{902} प\u{941}स\u{94d}तक"),
            keywords: &["धा\u{902}पिल\u{94d}ल\u{947}\u{902}", "प\u{941}स\u{94d}तक"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жабык китеп"),
            keywords: &["жабык", "китеп"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("zouent Buch"),
            keywords: &["Buch", "zou", "zouent Buch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{eb7}\u{ec9}ມທ\u{eb5}\u{ec8}ປ\u{eb4}ດຢ\u{eb9}\u{ec8}"),
            keywords: &[
                "ປ\u{eb4}ດ",
                "ປ\u{eb7}\u{ec9}ມ",
                "ປ\u{eb7}\u{ec9}ມທ\u{eb5}\u{ec8}ປ\u{eb4}ດຢ\u{eb9}\u{ec8}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("užversta knyga"),
            keywords: &["knyga", "užversta knyga", "užverta"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("aizvērta grāmata"),
            keywords: &["aizvērta", "grāmata"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pukapuka kopi"),
            keywords: &["kopi", "pukapuka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("затворена книга"),
            keywords: &["затворена", "книга"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("അടഞ\u{d4d}ഞ പ\u{d41}സ\u{d4d}\u{200c}തകം"),
            keywords: &[
                "അടച\u{d4d}ച പ\u{d41}സ\u{d4d}തകം",
                "അടഞ\u{d4d}ഞ പ\u{d41}സ\u{d4d}\u{200c}തകം",
                "പ\u{d41}സ\u{d4d}തകം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хаалттай ном"),
            keywords: &["ном", "хаалттай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ब\u{902}द प\u{941}स\u{94d}तक"),
            keywords: &["प\u{941}स\u{94d}तक", "ब\u{902}द प\u{941}स\u{94d}तक"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("buku tertutup"),
            keywords: &["buku", "tertutup"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ktieb magħluq"),
            keywords: &["ktieb", "magħluq"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပ\u{102d}တ\u{103a}ထားသည\u{1037}\u{103a} စာအ\u{102f}ပ\u{103a}"),
            keywords: &[
                "စာအ\u{102f}ပ\u{103a}",
                "ပ\u{102d}တ\u{103a}ထားသည\u{1037}\u{103a} စာအ\u{102f}ပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("lukket bok"),
            keywords: &["bok", "lukket"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बन\u{94d}द गर\u{947}को प\u{941}स\u{94d}तक"),
            keywords: &[
                "प\u{941}स\u{94d}तक",
                "बन\u{94d}द गर\u{947}को",
                "बन\u{94d}द गर\u{947}को प\u{941}स\u{94d}तक",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gesloten boek"),
            keywords: &["boek", "gesloten"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("lukka bok"),
            keywords: &["bok", "lukka"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବନ\u{b4d}ଦ ଥ\u{b3f}ବ\u{b3e} ବହ\u{b3f}"),
            keywords: &[
                "ପ\u{b41}ସ\u{b4d}ତକ",
                "ବନ\u{b4d}ଦ ଥ\u{b3f}ବ\u{b3e} ବହ\u{b3f}",
                "ବନ\u{b4d}ଦକର\u{b3f}ବ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a70}ਦ ਕਿਤਾਬ"),
            keywords: &["ਕਿਤਾਬ", "ਬ\u{a70}ਦ ਕਿਤਾਬ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بند کیتی کتاب"),
            keywords: &["بند کیتا", "بند کیتی کتاب", "کتاب"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Klózd Buk"),
            keywords: &["Buk", "Kloz", "Klózd Buk"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zamknięta książka"),
            keywords: &["książka", "zamknięta"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بند کتاب"),
            keywords: &["بند", "کتاب"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("livro fechado"),
            keywords: &["fechado", "livro"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["fechado", "livro"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("wichqasqa pʼanqa"),
            keywords: &["p’anqa", "wichqasqa", "wichqasqa pʼanqa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("carte închisă"),
            keywords: &["carte", "carte închisă", "închis"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-658"),
            keywords: &["E10-658"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("закрытая книга"),
            keywords: &[
                "закрытая книга",
                "закрытая книжка",
                "захлопнутая книга",
                "захлопнутая книжка",
                "обложка",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igitabo gifunze"),
            keywords: &["igitabo gifunze"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بند ڪتاب"),
            keywords: &["بند ٿيل", "بند ڪتاب", "ڪتاب"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වැස\u{dd6} පොත"),
            keywords: &["පොත", "වැස\u{dd6}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zatvorená kniha"),
            keywords: &["kniha", "zatvorená"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zaprta knjiga"),
            keywords: &["knjiga", "zaprta knjiga", "zaprto"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("buug xidhan"),
            keywords: &["buug", "xidhan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("libër i mbyllur"),
            keywords: &["i mbyllur", "libër", "libër i mbyllur"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("затворена књига"),
            keywords: &["затворена књига", "затворено", "књига"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["затворена књига"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("zatvorena knjiga"),
            keywords: &["knjiga", "zatvorena knjiga", "zatvoreno"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["zatvorena knjiga"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("stängd bok"),
            keywords: &["bok", "stängd bok"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitabu kilichofungwa"),
            keywords: &["kitabu", "kitabu kilichofungwa", "kufungwa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மூடிய புத\u{bcd}தகம\u{bcd}"),
            keywords: &["புத\u{bcd}தகம\u{bcd}", "மூடிய புத\u{bcd}தகம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మూస\u{c3f}న పుస\u{c4d}తకం"),
            keywords: &["పుస\u{c4d}తకం", "మూయడం", "మూస\u{c3f}న పుస\u{c4d}తకం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("китоби пӯшида"),
            keywords: &["китоб", "китоби пӯшида", "пӯшида"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e31}งส\u{e37}อป\u{e34}ด"),
            keywords: &["หน\u{e31}งส\u{e37}อ", "หน\u{e31}งส\u{e37}อป\u{e34}ด"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýapyk kitap"),
            keywords: &["kitap", "ýapyk"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tohi mapuni"),
            keywords: &["tohi mapuni"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kapalı kitap"),
            keywords: &["kapalı kitap", "kitap"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يېپىق كىتاب"),
            keywords: &["كىتاب", "يېپىق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("закрита книга"),
            keywords: &["закрита", "закрита книга", "книжка", "червоний підручник"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بند کتاب"),
            keywords: &["بند", "کتاب"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yopiq kitob"),
            keywords: &["kitob", "yopiq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("sách đóng"),
            keywords: &["sách", "đóng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("téere bu tëju"),
            keywords: &["buñ tëj", "téere", "téere bu tëju"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("incwadi evaliweyo"),
            keywords: &["evaliweyo", "incwadi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("iwe ti pade"),
            keywords: &["iwe ti pade", "pípadé", "ìwé"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("閂埋左嘅書"),
            keywords: &["書", "閂埋", "閂埋左嘅書"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("闩埋左嘅书"),
            keywords: &["书", "闩埋", "闩埋左嘅书"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("合上的书本"),
            keywords: &["书", "书本", "合上", "合上的书本"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("合起來的書本"),
            keywords: &["合起來的書本", "書本"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("閂埋嘅書"),
            keywords: &["閂埋嘅書", "閂埋嘅書｜書"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("incwadi evaliwe"),
            keywords: &["incwadi", "incwadi evaliwe", "okuvaliwe"],
        },
    ],
};
#[doc = "📖"]
pub const OPEN_BOOK: crate::Emoji = crate::Emoji {
    glyph: "📖",
    codepoint: "1F4D6",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "open book",
    group: "Objects",
    subgroup: "book-paper",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("oop boek"),
            keywords: &["boek", "oop"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ክፍት መጽሐፍ"),
            keywords: &["መጽሐፍ", "ክፍት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كتاب مفتوح"),
            keywords: &["كتاب", "كتاب مفتوح"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("খোল\u{9be} কিত\u{9be}প"),
            keywords: &["কিত\u{9be}প", "খোল\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("açıq kitab"),
            keywords: &["açıq", "kitab"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("адкрытая кніга"),
            keywords: &["адкрытая", "кніга"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("отворена книга"),
            keywords: &["книга", "отворен", "отворена книга"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("খোল\u{9be} বই"),
            keywords: &["খোল\u{9be}", "বই"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("levr digor"),
            keywords: &["digor", "levr"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("otvorena knjiga"),
            keywords: &["knjiga", "otvorena"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("llibre obert"),
            keywords: &["llibre", "obert"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎯᏍᏚᎢ ᎪᏪᎵ ᏗᎪᎵᏰᏗ"),
            keywords: &["ᎠᏍᏚᎢᏓ", "ᎪᏪᎵ", "ᎯᏍᏚᎢ ᎪᏪᎵ ᏗᎪᎵᏰᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("otevřená kniha"),
            keywords: &["kniha", "otevřená kniha", "otevřený"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("llyfr agored"),
            keywords: &["agored", "llyfr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("åben bog"),
            keywords: &["bog", "læse", "åben bog"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("offenes Buch"),
            keywords: &["Buch", "geöffnet", "offen", "offenes Buch"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ανοικτό βιβλίο"),
            keywords: &["ανοικτό βιβλίο", "ανοιχτό", "βιβλίο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("open book"),
            keywords: &["book", "open"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("libro abierto"),
            keywords: &["abierto", "libro"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("avatud raamat"),
            keywords: &["avatud", "raamat"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("liburu irekia"),
            keywords: &["irekita", "liburu irekia", "liburua"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کتاب باز"),
            keywords: &["باز", "کتاب"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("avoin kirja"),
            keywords: &["avoin", "kirja"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nakabukas na aklat"),
            keywords: &["aklat", "nakabukas", "nakabukas na aklat"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("opin bók"),
            keywords: &["bók", "opin"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("livre ouvert"),
            keywords: &["livre", "livre ouvert"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("leabhar oscailte"),
            keywords: &["leabhar", "leabhar oscailte"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("leabhar fosgailte"),
            keywords: &["fosgailte", "leabhar"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("libro aberto"),
            keywords: &["aberto", "libro"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ખ\u{ac1}લ\u{acd}લ\u{ac1}\u{a82} પ\u{ac1}સ\u{acd}તક"),
            keywords: &[
                "ખ\u{ac1}લ\u{acd}લ\u{ac1}\u{a82} પ\u{ac1}સ\u{acd}તક",
                "પ\u{ac1}સ\u{acd}તક",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("buɗaɗɗen littafi"),
            keywords: &["buɗaɗɗen littafi", "littafi buɗaɗɗe"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ספר פתוח"),
            keywords: &["ספר", "פתוח"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ख\u{941}ली किताब"),
            keywords: &["ख\u{941}ली किताब", "प\u{941}स\u{94d}तक"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("otvorena knjiga"),
            keywords: &["knjiga", "otvorena knjiga", "otvoreno"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nyitott könyv"),
            keywords: &["könyv", "nyitott"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բացված գիրք"),
            keywords: &["բացված", "գիրք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("buku terbuka"),
            keywords: &["buku", "terbuka"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akwukwọ emepere"),
            keywords: &["akwukwọ", "emepere"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("opin bók"),
            keywords: &["bók", "opin bók"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("libro aperto"),
            keywords: &["libro", "libro aperto"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("開いた本"),
            keywords: &["書籍", "開いた本"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("mbukak buku"),
            keywords: &["buku", "mbukak"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გადაშლილი წიგნი"),
            keywords: &["გადაშლილი წიგნი", "ღია", "წიგნი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("adlis yeldin"),
            keywords: &["adlis yeldin"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ашық кітап"),
            keywords: &["ашық", "кітап"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("åben bog"),
            keywords: &["bog", "åben bog"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សៀវភៅបើក"),
            keywords: &["បើក", "សៀវភៅ", "សៀវភៅបើក"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ತ\u{cc6}ರ\u{cc6}ದ ಪುಸ\u{ccd}ತಕ"),
            keywords: &[
                "ತ\u{cc6}ರ\u{cc6}",
                "ತ\u{cc6}ರ\u{cc6}ದ ಪುಸ\u{ccd}ತಕ",
                "ಪುಸ\u{ccd}ತಕ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("펼쳐진 책"),
            keywords: &["책", "펼쳐진 책"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उकत\u{947}\u{902} प\u{941}स\u{94d}तक"),
            keywords: &["उकत\u{947}\u{902}", "प\u{941}स\u{94d}तक"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ачык китеп"),
            keywords: &["ачык", "китеп"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("oppent Buch"),
            keywords: &["Buch", "oppen", "oppent Buch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{eb7}\u{ec9}ມທ\u{eb5}\u{ec8}ເປ\u{eb5}ດຢ\u{eb9}\u{ec8}"),
            keywords: &[
                "ທ\u{eb5}\u{ec8}ເປ\u{eb5}ດຢ\u{eb9}\u{ec8}",
                "ປ\u{eb7}\u{ec9}ມ",
                "ປ\u{eb7}\u{ec9}ມທ\u{eb5}\u{ec8}ເປ\u{eb5}ດຢ\u{eb9}\u{ec8}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("atversta knyga"),
            keywords: &["atversta", "knyga"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("atvērta grāmata"),
            keywords: &["atvērta", "grāmata"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pukapuka tuwhera"),
            keywords: &["pukapuka", "tuwhera"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("отворена книга"),
            keywords: &["книга", "отворена"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ത\u{d41}റന\u{d4d}ന പ\u{d41}സ\u{d4d}\u{200c}തകം"),
            keywords: &[
                "ത\u{d41}റന\u{d4d}ന പ\u{d41}സ\u{d4d}\u{200c}തകം",
                "പ\u{d41}സ\u{d4d}തകം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нээлттэй ном"),
            keywords: &["ном", "нээлттэй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ख\u{941}ल\u{947} प\u{941}स\u{94d}तक"),
            keywords: &[
                "उघड\u{947} प\u{941}स\u{94d}तक",
                "ख\u{941}ल\u{947} प\u{941}स\u{94d}तक",
                "प\u{941}स\u{94d}तक",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("buka terbuka"),
            keywords: &["buka terbuka", "buku", "terbuka"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ktieb miftuħ"),
            keywords: &["ktieb", "miftuħ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဖ\u{103d}င\u{1037}\u{103a}ထားသည\u{1037}\u{103a} စာအ\u{102f}ပ\u{103a}"),
            keywords: &[
                "စာအ\u{102f}ပ\u{103a}",
                "ဖ\u{103d}င\u{1037}\u{103a}ထားသည\u{1037}\u{103a} စာအ\u{102f}ပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("åpen bok"),
            keywords: &["bok", "åpen"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ख\u{941}ला प\u{941}स\u{94d}तक"),
            keywords: &["ख\u{941}ला", "प\u{941}स\u{94d}तक"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("geopend boek"),
            keywords: &["boek", "geopend", "open"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("open bok"),
            keywords: &["bok", "open"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଖୋଲ\u{b3e} ବହ\u{b3f}"),
            keywords: &[
                "ଖୋଲ\u{b3e} ବହ\u{b3f}",
                "ଖୋଲ\u{b3f}ବ\u{b3e}",
                "ପ\u{b41}ସ\u{b4d}ତକ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਖ\u{a41}\u{a71}ਲ\u{a4d}ਹੀ ਕਿਤਾਬ"),
            keywords: &[
                "ਕਿਤਾਬ",
                "ਖ\u{a41}\u{a71}ਲ\u{a4d}ਹੀ ਕਿਤਬ",
                "ਖ\u{a41}\u{a71}ਲ\u{a4d}ਹੀ ਕਿਤਾਬ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کھلی کتاب"),
            keywords: &["کتاب", "ک\u{64f}ھلا", "کھلی کتاب"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ópún Buk"),
            keywords: &["Buk", "Ópún Buk"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("otwarta książka"),
            keywords: &["książka", "otwarta"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("خلاص کتاب"),
            keywords: &["خلاص", "کتاب"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("livro aberto"),
            keywords: &["aberto", "livro"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["aberto", "livro"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("kichasqa pʼanqa"),
            keywords: &["kichasqa pʼanqa", "kichay", "p’anqa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("carte deschisă"),
            keywords: &["carte", "carte deschisă", "deschis"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-659"),
            keywords: &["E10-659"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("открытая книга"),
            keywords: &[
                "книга",
                "открытая книга",
                "открытая книжка",
                "раскрытая книга",
                "раскрытая книжка",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igitabo gifunguye"),
            keywords: &["gifunguye", "igitabo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("کليل ڪتاب"),
            keywords: &["کليل", "ڪتاب"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ව\u{dd2}වෘත පොත"),
            keywords: &["පොත", "ව\u{dd2}වෘත"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("otvorená kniha"),
            keywords: &["kniha", "otvorená"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("odprta knjiga"),
            keywords: &["knjiga", "odprta knjiga", "odprto"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("buug furan"),
            keywords: &["buug", "furan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("libër i hapur"),
            keywords: &["hap", "i hapur", "libër", "libër i hapur"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("отворена књига"),
            keywords: &["књига", "отворена књига", "отворено"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["отворена књига"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("otvorena knjiga"),
            keywords: &["knjiga", "otvorena knjiga", "otvoreno"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["otvorena knjiga"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("öppen bok"),
            keywords: &["bok", "öppen bok"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitabu kilichofunguliwa"),
            keywords: &["kitabu", "kitabu kilichofunguliwa", "kufunguliwa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("திறந\u{bcd}த புத\u{bcd}தகம\u{bcd}"),
            keywords: &["திறந\u{bcd}த புத\u{bcd}தகம\u{bcd}", "புத\u{bcd}தகம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("త\u{c46}ర\u{c3f}చ\u{c3f}న పుస\u{c4d}తకం"),
            keywords: &[
                "త\u{c46}రవడం",
                "త\u{c46}ర\u{c3f}చ\u{c3f}న పుస\u{c4d}తకం",
                "పుస\u{c4d}తకం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("китоби кушода"),
            keywords: &["китоб", "китоби кушода", "кушода"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e31}งส\u{e37}อเป\u{e34}ด"),
            keywords: &["หน\u{e31}งส\u{e37}อ", "หน\u{e31}งส\u{e37}อเป\u{e34}ด"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("açyk kitap"),
            keywords: &["açyk", "kitap"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tohi fakaava"),
            keywords: &["tohi fakaava"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("açık kitap"),
            keywords: &["açık kitap", "kitap"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئوچۇق كىتاب"),
            keywords: &["ئوچۇق", "كىتاب"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("відкрита книга"),
            keywords: &["відкрита", "відкрита книга", "книжка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کھلی کتاب"),
            keywords: &["کتاب", "کھلی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ochiq kitob"),
            keywords: &["kitob", "ochiq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("sách đang mở"),
            keywords: &["mở", "sách", "sách đang mở"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("téere bu ubbiku"),
            keywords: &["téere", "téere bu ubbiku", "ubbeeku"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("incwadi evulekileyo"),
            keywords: &["evulekileyo", "incwadi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("iwe ṣi silẹ"),
            keywords: &["iwe ṣi silẹ", "ìwé", "ṣíṣí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("打開本書"),
            keywords: &["打開", "打開本書", "書"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("打开本书"),
            keywords: &["书", "打开", "打开本书"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("打开的书本"),
            keywords: &["书", "书本", "打开", "打开的书本", "读书", "阅读"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("打開來的書本"),
            keywords: &["打開來的書本", "書本"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("打開嘅書"),
            keywords: &["打開嘅書", "打開嘅書｜書"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("incwadi evuliwe"),
            keywords: &["incwadi", "incwadi evuliwe", "okuvuliwe"],
        },
    ],
};
#[doc = "📗"]
pub const GREEN_BOOK: crate::Emoji = crate::Emoji {
    glyph: "📗",
    codepoint: "1F4D7",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "green book",
    group: "Objects",
    subgroup: "book-paper",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("groen boek"),
            keywords: &["boek", "groen"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አረንጓዴ መጽሐፍ"),
            keywords: &["መጽሐፍ", "አረንጓዴ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كتاب أخضر"),
            keywords: &["كتاب", "كتاب أخضر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("সেউজীয\u{9bc}\u{9be} কিত\u{9be}প"),
            keywords: &["কিত\u{9be}প", "সেউজীয\u{9bc}\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yaşıl kitab"),
            keywords: &["kitab", "yaşıl"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("зялёная кніга"),
            keywords: &["зялёная", "кніга"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("зелена книга"),
            keywords: &["зелен", "зелена книга", "книга"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("সব\u{9c1}জ বই"),
            keywords: &["বই", "সব\u{9c1}জ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("levr gwer"),
            keywords: &["gwer", "levr"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zelena knjiga"),
            keywords: &["knjiga", "zelena knjiga"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("llibre verd"),
            keywords: &["llibre", "verd"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎢᏤᏳᏍᏗ ᏗᎪᏪᎵ"),
            keywords: &["ᎢᏤ ᎢᏳᏍᏗ", "ᎢᏤᏳᏍᏗ ᏗᎪᏪᎵ", "ᎪᏪᎵ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zelená kniha"),
            keywords: &["kniha", "zelená"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("llyfr gwyrdd"),
            keywords: &["gwyrdd", "llyfr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("grøn bog"),
            keywords: &["bog", "grøn bog"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("grünes Buch"),
            keywords: &["Buch", "grün", "grünes Buch"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πράσινο βιβλίο"),
            keywords: &["βιβλίο", "πράσινο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("green book"),
            keywords: &["book", "green"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("libro verde"),
            keywords: &["libro", "verde"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("roheline raamat"),
            keywords: &["raamat", "roheline"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("liburu berdea"),
            keywords: &["berde", "liburu", "liburu berdea"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کتاب سبز"),
            keywords: &["سبز", "کتاب"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vihreä kirja"),
            keywords: &["kirja", "vihreä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("berdeng aklat"),
            keywords: &["aklat", "berde", "berdeng aklat"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("grøn bók"),
            keywords: &["bók", "grøn"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("livre vert"),
            keywords: &["livre", "livre vert"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("leabhar glas"),
            keywords: &["leabhar glas"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("leabhar uaine"),
            keywords: &["leabhar", "uaine"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("libro verde"),
            keywords: &["libro", "verde"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લીલ\u{ac1}\u{a82} પ\u{ac1}સ\u{acd}તક"),
            keywords: &["પ\u{ac1}સ\u{acd}તક", "લીલ\u{ac1}\u{a82} પ\u{ac1}સ\u{acd}તક"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("koren littafi"),
            keywords: &["kore", "koren littafi", "littafi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ספר ירוק"),
            keywords: &["ירוק", "ספר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("हरी किताब"),
            keywords: &["प\u{941}स\u{94d}तक", "हरी किताब"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zelena knjiga"),
            keywords: &["knjiga", "zelena knjiga", "zeleno"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("zöld könyv"),
            keywords: &["könyv", "zöld"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կանաչ գիրք"),
            keywords: &["գիրք", "կանաչ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("buku hijau"),
            keywords: &["buku", "hijau"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akwukwọ ndụ ndụ"),
            keywords: &["akwukwọ", "akwukwọ ndụ ndụ", "ndụ ndụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("græn bók"),
            keywords: &["bók", "græn"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("libro verde"),
            keywords: &["libro", "libro verde"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("緑の本"),
            keywords: &["書籍", "緑の本"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("buku ijo"),
            keywords: &["buku", "ijo"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მწვანე წიგნი"),
            keywords: &["მწვანე", "წიგნი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("adlis azegzaw"),
            keywords: &["adlis azegzaw"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жасыл кітап"),
            keywords: &["жасыл", "кітап"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("grøn bog"),
            keywords: &["bog", "grøn bog"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សៀវភៅក\u{17d2}របពណ\u{17cc}បៃតង"),
            keywords: &["បៃតង", "សៀវភៅ", "សៀវភៅក\u{17d2}របពណ\u{17cc}បៃតង"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹಸ\u{cbf}ರು ಪುಸ\u{ccd}ತಕ"),
            keywords: &["ಪುಸ\u{ccd}ತಕ", "ಹಸ\u{cbf}ರು ಪುಸ\u{ccd}ತಕ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("초록색 책"),
            keywords: &["녹색 책", "책", "초록색 책"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पाचव\u{947}\u{902} प\u{941}स\u{94d}तक"),
            keywords: &["पाचव\u{947}\u{902}", "प\u{941}स\u{94d}तक"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жашыл китеп"),
            keywords: &["жашыл", "китеп"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("gréngt Buch"),
            keywords: &["Buch", "gréng", "gréngt Buch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{eb7}\u{ec9}ມສ\u{eb5}ຂຽວ"),
            keywords: &[
                "ປ\u{eb7}\u{ec9}ມ",
                "ປ\u{eb7}\u{ec9}ມສ\u{eb5}ຂຽວ",
                "ສ\u{eb5}ຂຽວ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žalia knyga"),
            keywords: &["knyga", "žalia"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zaļa grāmata"),
            keywords: &["grāmata", "zaļa"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pukapuka kākāriki"),
            keywords: &["kākāriki", "pukapuka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("зелена книга"),
            keywords: &["зелена", "книга"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പച\u{d4d}ച പ\u{d41}സ\u{d4d}\u{200c}തകം"),
            keywords: &[
                "പച\u{d4d}ച പ\u{d41}സ\u{d4d}\u{200c}തകം",
                "പ\u{d41}സ\u{d4d}തകം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ногоон ном"),
            keywords: &["ногоон", "ном"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("शासकीय घडामोडी\u{902}च\u{947} प\u{941}स\u{94d}तक"),
            keywords: &[
                "प\u{941}स\u{94d}तक",
                "शासकीय घडामोडी\u{902}च\u{947} प\u{941}स\u{94d}तक",
                "हिरवा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("buku hijau"),
            keywords: &["buku", "hijau"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ktieb aħdar"),
            keywords: &["aħdar", "ktieb"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အစ\u{102d}မ\u{103a}းရောင\u{103a} စာအ\u{102f}ပ\u{103a}"),
            keywords: &[
                "စာအ\u{102f}ပ\u{103a}",
                "အစ\u{102d}မ\u{103a}းရောင\u{103a} စာအ\u{102f}ပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("grønn bok"),
            keywords: &["bok", "grønn"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("हरियो प\u{941}स\u{94d}तक"),
            keywords: &["प\u{941}स\u{94d}तक", "हरियो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("groen boek"),
            keywords: &["boek", "groen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("grøn bok"),
            keywords: &["bok", "grøn"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସବ\u{b41}ଜ ବହ\u{b3f}"),
            keywords: &["ପ\u{b41}ସ\u{b4d}ତକ", "ସବ\u{b41}ଜ", "ସବ\u{b41}ଜ ବହ\u{b3f}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਹਰੀ ਕਿਤਾਬ"),
            keywords: &["ਕਿਤਾਬ", "ਹਰੀ ਕਿਤਾਬ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سبز کتاب"),
            keywords: &["سبز کتاب", "کتاب", "ہرا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Grín Buk"),
            keywords: &["Buk", "Grin", "Grín Buk"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zielona książka"),
            keywords: &["książka", "zielona"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شنه کتاب"),
            keywords: &["شنه کتاب"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("livro verde"),
            keywords: &["livro", "verde"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["livro", "verde"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("qʼumir pʼanqa"),
            keywords: &["p’anqa", "qʼumir pʼanqa", "q’umir"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("carte verde"),
            keywords: &["carte", "verde"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-660"),
            keywords: &["E10-660"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("зеленая книга"),
            keywords: &["зеленая", "книга", "книжка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igitabo cy’icyatsi"),
            keywords: &["cy’icyatsi kibisi", "igitabo", "igitabo cy’icyatsi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سائو ڪتاب"),
            keywords: &["سائو", "ڪتاب"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කොළ පොත"),
            keywords: &["කොළ", "පොත"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zelená kniha"),
            keywords: &["kniha", "zelená"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zelena knjiga"),
            keywords: &["knjiga", "zelena knjiga", "zeleno"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("buug akhtara"),
            keywords: &["akhtar", "buug", "buug akhtara"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("libër jeshil"),
            keywords: &["jeshil", "libër"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("зелена књига"),
            keywords: &["зелена књига", "зелено", "књига"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["зелена књига"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("zelena knjiga"),
            keywords: &["knjiga", "zelena knjiga", "zeleno"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["zelena knjiga"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("grön bok"),
            keywords: &["bok", "grön bok"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitabu cha kijani"),
            keywords: &["kijani", "kitabu", "kitabu cha kijani"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பச\u{bcd}சை புத\u{bcd}தகம\u{bcd}"),
            keywords: &["பச\u{bcd}சை புத\u{bcd}தகம\u{bcd}", "புத\u{bcd}தகம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("పచ\u{c4d}చ రంగు పుస\u{c4d}తకం"),
            keywords: &[
                "పచ\u{c4d}చ రంగు",
                "పచ\u{c4d}చ రంగు పుస\u{c4d}తకం",
                "పుస\u{c4d}తకం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("китоби сабз"),
            keywords: &["китоб", "китоби сабз", "сабз"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e31}งส\u{e37}อส\u{e35}เข\u{e35}ยว"),
            keywords: &[
                "หน\u{e31}งส\u{e37}อ",
                "หน\u{e31}งส\u{e37}อส\u{e35}เข\u{e35}ยว",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýaşyl kitap"),
            keywords: &["kitap", "ýaşyl"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tohi lanumata"),
            keywords: &["tohi lanumata"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yeşil kitap"),
            keywords: &["kitap", "yeşil kitap"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يېشىل كىتاب"),
            keywords: &["كىتاب", "يېشىل"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("зелений підручник"),
            keywords: &["зелений", "зелений підручник", "книжка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سبز کتاب"),
            keywords: &["رنگ", "سبز", "کتاب"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yashil kitob"),
            keywords: &["kitob", "yashil"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("sách màu lục"),
            keywords: &["sách", "sách màu lục", "xanh lục"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("téere bu wert"),
            keywords: &["téere", "téere bu wert", "wert"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("incwadi eluhlaza"),
            keywords: &["eluhlaza", "incwadi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("iwe alawọ ewe"),
            keywords: &["iwe alawọ ewe", "àwò\u{329} ewé", "ìwé"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("綠色書"),
            keywords: &["書", "綠色", "綠色書"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("绿色书"),
            keywords: &["书", "绿色", "绿色书"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("绿色书本"),
            keywords: &["书", "书本", "绿", "绿色", "绿色书本"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("綠色的書本"),
            keywords: &["書本", "綠色的書本"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("綠色簿"),
            keywords: &["綠色簿", "綠色簿｜書｜綠色"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("incwadi eluhlaza satshani"),
            keywords: &["incwadi", "incwadi eluhlaza satshani", "luhlaza satshani"],
        },
    ],
};
#[doc = "📘"]
pub const BLUE_BOOK: crate::Emoji = crate::Emoji {
    glyph: "📘",
    codepoint: "1F4D8",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "blue book",
    group: "Objects",
    subgroup: "book-paper",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("blou boek"),
            keywords: &["blou", "boek"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሰማያዊ መጽሐፍ"),
            keywords: &["መጽሐፍ", "ሰማያዊ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كتاب أزرق"),
            keywords: &["أزرق", "كتاب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("নীল\u{9be} কিত\u{9be}প"),
            keywords: &["কিত\u{9be}প", "নীল\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("mavi kitab"),
            keywords: &["kitab", "mavi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сіняя кніга"),
            keywords: &["кніга", "сіняя"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("синя книга"),
            keywords: &["книга", "син", "синя книга"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("নীল বই"),
            keywords: &["নীল", "বই"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("levr glas"),
            keywords: &["glas", "levr"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("plava knjiga"),
            keywords: &["knjiga", "plava knjiga"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("llibre blau"),
            keywords: &["blau", "llibre"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏌᎪᏂᎨ ᎪᏪᎵ"),
            keywords: &["ᎪᏪᎵ", "ᏌᎪᏂᎨ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("modrá kniha"),
            keywords: &["kniha", "modrá"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("llyfr glas"),
            keywords: &["glas", "llyfr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("blå bog"),
            keywords: &["blå bog", "bog"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("blaues Buch"),
            keywords: &["Buch", "blau", "blaues Buch"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μπλε βιβλίο"),
            keywords: &["βιβλίο", "μπλε"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("blue book"),
            keywords: &["blue", "book"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("libro azul"),
            keywords: &["azul", "libro"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("sinine raamat"),
            keywords: &["raamat", "sinine"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("liburu urdina"),
            keywords: &["liburu", "liburu urdina", "urdin"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کتاب آبی"),
            keywords: &["آبی", "کتاب"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("sininen kirja"),
            keywords: &["kirja", "sininen"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("asul na aklat"),
            keywords: &["aklat", "asul", "asul na aklat"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("blá bók"),
            keywords: &["blá", "bók"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("livre bleu"),
            keywords: &["livre", "livre bleu"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("leabhar gorm"),
            keywords: &["leabhar gorm"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("leabhar gorm"),
            keywords: &["gorm", "leabhar"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("libro azul"),
            keywords: &["azul", "libro"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વાદળી પ\u{ac1}સ\u{acd}તક"),
            keywords: &["પ\u{ac1}સ\u{acd}તક", "વાદળી પ\u{ac1}સ\u{acd}તક"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("shuɗin littafi"),
            keywords: &["littafi", "shuɗi", "shuɗin littafi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ספר כחול"),
            keywords: &["כחול", "ספר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("नीली किताब"),
            keywords: &["नीली किताब", "प\u{941}स\u{94d}तक"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("plava knjiga"),
            keywords: &["knjiga", "plava knjiga", "plavo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kék könyv"),
            keywords: &["kék", "könyv"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կապույտ գիրք"),
            keywords: &["գիրք", "կապույտ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("buku biru"),
            keywords: &["biru", "buku"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akwukwọ blu"),
            keywords: &["akwukwọ", "blu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("blá bók"),
            keywords: &["blá", "bók"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("libro blu"),
            keywords: &["libro", "libro blu"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("青の本"),
            keywords: &["書籍", "青の本"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("buku biru"),
            keywords: &["biru", "buku"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ლურჯი წიგნი"),
            keywords: &["ლურჯი", "ცისფერი", "წიგნი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("adlis amidadi"),
            keywords: &["adlis amidadi"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("көк кітап"),
            keywords: &["кітап", "көк"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("blå bog"),
            keywords: &["blå bog", "bog"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សៀវភៅក\u{17d2}របពណ\u{17cc}ខៀវ"),
            keywords: &["ខៀវ", "សៀវភៅ", "សៀវភៅក\u{17d2}របពណ\u{17cc}ខៀវ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನೀಲ\u{cbf} ಪುಸ\u{ccd}ತಕ"),
            keywords: &["ನೀಲ\u{cbf}", "ನೀಲ\u{cbf} ಪುಸ\u{ccd}ತಕ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("파란색 책"),
            keywords: &["책", "파란 책", "파란색 책"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("निळ\u{947}\u{902} प\u{941}स\u{94d}तक"),
            keywords: &["निळ\u{947}\u{902}", "प\u{941}स\u{94d}तक"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("көк китеп"),
            keywords: &["китеп", "көк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("blot Buch"),
            keywords: &["Buch", "blo", "blot Buch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{eb7}\u{ec9}ມສ\u{eb5}ຟ\u{ec9}າ"),
            keywords: &[
                "ປ\u{eb7}\u{ec9}ມ",
                "ປ\u{eb7}\u{ec9}ມສ\u{eb5}ຟ\u{ec9}າ",
                "ສ\u{eb5}ຟ\u{ec9}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mėlyna knyga"),
            keywords: &["knyga", "mėlyna"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zila grāmata"),
            keywords: &["grāmata", "zila"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pukapuka kikorangi"),
            keywords: &["kikorangi", "pukapuka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("сина книга"),
            keywords: &["книга", "сина"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("നീല പ\u{d41}സ\u{d4d}\u{200c}തകം"),
            keywords: &["നീല പ\u{d41}സ\u{d4d}\u{200c}തകം", "പ\u{d41}സ\u{d4d}തകം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цэнхэр ном"),
            keywords: &["ном", "цэнхэр"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("शासनाचा अहवाल असल\u{947}ल\u{947} प\u{941}स\u{94d}तक"),
            keywords: &[
                "निळा",
                "प\u{941}स\u{94d}तक",
                "शासनाचा अहवाल असल\u{947}ल\u{947} प\u{941}स\u{94d}तक",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("buku biru"),
            keywords: &["biru", "buku"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ktieb blu"),
            keywords: &["blu", "ktieb"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အပြာရောင\u{103a} စာအ\u{102f}ပ\u{103a}"),
            keywords: &["အပြာ", "အပြာရောင\u{103a} စာအ\u{102f}ပ\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("blå bok"),
            keywords: &["blå", "bok"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("नीलो प\u{941}स\u{94d}तक"),
            keywords: &["नीलो", "प\u{941}स\u{94d}तक"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("blauw boek"),
            keywords: &["blauw", "boek"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("blå bok"),
            keywords: &["blå", "bok"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ନୀଳ ବହ\u{b3f}"),
            keywords: &["ନୀଳ", "ନୀଳ ବହ\u{b3f}", "ପ\u{b41}ସ\u{b4d}ତକ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਨੀਲੀ ਕਿਤਾਬ"),
            keywords: &["ਕਿਤਾਬ", "ਨੀਲੀ ਕਿਤਾਬ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("نیلی کتاب"),
            keywords: &["نیلا", "نیلی کتاب", "کتاب"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Blú Buk"),
            keywords: &["Blu", "Blú Buk", "Buk"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("niebieska książka"),
            keywords: &["książka", "niebieska"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("آسماني رنګ کتاب"),
            keywords: &["آسماني رنګ", "آسماني رنګ کتاب", "کتاب"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("livro azul"),
            keywords: &["azul", "livro"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["azul", "livro"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("anqas p’anqa"),
            keywords: &["anqas pʼanqa", "anqas p’anqa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("carte albastră"),
            keywords: &["albastră", "carte"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-661"),
            keywords: &["E10-661"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("синяя книга"),
            keywords: &[
                "голубая книга",
                "голубая книжка",
                "книга",
                "синяя книга",
                "синяя книжка",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igitabo cy’ubururu"),
            keywords: &["igitabo cy’ubururu"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("نيرو ڪتاب"),
            keywords: &["نيرو", "ڪتاب"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("න\u{dd2}ල\u{dca} පොත"),
            keywords: &["න\u{dd2}ල\u{dca}", "පොත"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("modrá kniha"),
            keywords: &["kniha", "modrá"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("modra knjiga"),
            keywords: &["knjiga", "modra knjiga", "modro"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("buug buluuga"),
            keywords: &["buluug", "buug", "buug buluuga"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("libër blu"),
            keywords: &["blu", "libër"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("плава књига"),
            keywords: &["књига", "плава књига", "плаво"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["плава књига"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("plava knjiga"),
            keywords: &["knjiga", "plava knjiga", "plavo"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["plava knjiga"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("blå bok"),
            keywords: &["blå bok", "bok"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitabu cha samawati"),
            keywords: &["kitabu", "kitabu cha samawati", "samawati"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ந\u{bc0}லப\u{bcd} புத\u{bcd}தகம\u{bcd}"),
            keywords: &[
                "ந\u{bc0}லப\u{bcd} புத\u{bcd}தகம\u{bcd}",
                "புத\u{bcd}தகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("న\u{c40}ల\u{c3f} రంగు పుస\u{c4d}తకం"),
            keywords: &[
                "న\u{c40}ల\u{c3f} రంగు",
                "న\u{c40}ల\u{c3f} రంగు పుస\u{c4d}తకం",
                "పుస\u{c4d}తకం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("китоби кабуд"),
            keywords: &["кабуд", "китоб", "китоби кабуд"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e31}งส\u{e37}อส\u{e35}น\u{e49}ำเง\u{e34}น"),
            keywords: &[
                "หน\u{e31}งส\u{e37}อ",
                "หน\u{e31}งส\u{e37}อส\u{e35}น\u{e49}ำเง\u{e34}น",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gök kitap"),
            keywords: &["gök", "kitap"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tohi lanupulū"),
            keywords: &["tohi lanupulū"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("mavi kitap"),
            keywords: &["kitap", "mavi kitap"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كۆك كىتاب"),
            keywords: &["كىتاب", "كۆك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("синій підручник"),
            keywords: &["книжка", "синій", "синій підручник"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("نیلی کتاب"),
            keywords: &["رنگ", "نیلا", "نیلی کتاب", "کتاب"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ko‘k kitob"),
            keywords: &["havorang", "kitob", "ko‘k"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("sách màu lam"),
            keywords: &["sách", "sách màu lam", "xanh lam"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("téere bu baxa"),
            keywords: &["baxa", "téere", "téere bu baxa"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("incwadi ebhlowu"),
            keywords: &["ebhlowu", "incwadi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("iwe alawọ bulu"),
            keywords: &["bulu", "iwe alawọ", "iwe alawọ bulu"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("藍色書"),
            keywords: &["書", "藍色", "藍色書"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("蓝色书"),
            keywords: &["书", "蓝色", "蓝色书"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("蓝色书本"),
            keywords: &["书", "书本", "篮", "蓝色", "蓝色书本"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("藍色的書本"),
            keywords: &["書本", "藍色的書本"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("藍色簿"),
            keywords: &["藍色簿", "藍色簿｜書｜藍色"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("incwadi eluhlaza sasibhakabhaka"),
            keywords: &[
                "incwadi",
                "incwadi eluhlaza sasibhakabhaka",
                "luhlaza sasibhabhaka",
            ],
        },
    ],
};
#[doc = "📙"]
pub const ORANGE_BOOK: crate::Emoji = crate::Emoji {
    glyph: "📙",
    codepoint: "1F4D9",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "orange book",
    group: "Objects",
    subgroup: "book-paper",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("oranje boek"),
            keywords: &["boek", "oranje"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ብርትኳናማ መጽሐፍ"),
            keywords: &["መጽሐፍ", "ብርትኳናማ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كتاب برتقالي"),
            keywords: &["كتاب", "كتاب برتقالي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কমল\u{9be}ৰঙী কিত\u{9be}প"),
            keywords: &["কমল\u{9be}", "কমল\u{9be}ৰঙী কিত\u{9be}প", "কিত\u{9be}প"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("narıncı kitab"),
            keywords: &["kitab", "narıncı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("аранжавая кніга"),
            keywords: &["аранжавая", "кніга"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("оранжева книга"),
            keywords: &["книга", "оранжев", "оранжева книга"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("কমল\u{9be} বই"),
            keywords: &["কমল\u{9be}", "বই"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("levr orañjez"),
            keywords: &["levr", "orañjez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("narandžasta knjiga"),
            keywords: &["knjiga", "narandžasta knjiga"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("llibre taronja"),
            keywords: &["llibre", "taronja"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏓᎶᏂᎨ ᎪᏪᎵ ᏗᎪᎵᏰᏙᏗ"),
            keywords: &["ᎠᏓᎶᏂᎨ", "ᎠᏓᎶᏂᎨ ᎪᏪᎵ ᏗᎪᎵᏰᏙᏗ", "ᎪᏪᎵ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("oranžová kniha"),
            keywords: &["kniha", "oranžová"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("llyfr oren"),
            keywords: &["llyfr", "oren"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("orange bog"),
            keywords: &["bog", "orange bog"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("orangefarbenes Buch"),
            keywords: &["Buch", "orangefarben", "orangefarbenes Buch"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πορτοκαλί βιβλίο"),
            keywords: &["βιβλίο", "πορτοκαλί"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("orange book"),
            keywords: &["book", "orange"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("libro naranja"),
            keywords: &["libro", "naranja"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("libro anaranjado"),
            keywords: &["libro", "libro anaranjado", "naranja"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("oranž raamat"),
            keywords: &["oranž", "raamat"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("liburu laranja"),
            keywords: &["laranja", "liburu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کتاب نارنجی"),
            keywords: &["نارنجی", "کتاب"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("oranssi kirja"),
            keywords: &["kirja", "oranssi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("orange na aklat"),
            keywords: &["aklat", "orange", "orange na aklat"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("appilsingul bók"),
            keywords: &["appilsingul", "bók"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("livre orange"),
            keywords: &["livre", "livre orange"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("leabhar flannbhuí"),
            keywords: &["flannbhuí", "leabhar", "oráiste"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("leabhar orains"),
            keywords: &["leabhar", "orainds", "orains"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("libro laranxa"),
            keywords: &["laranxa", "libro"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("નાર\u{a82}ગી પ\u{ac1}સ\u{acd}તક"),
            keywords: &["નાર\u{a82}ગી પ\u{ac1}સ\u{acd}તક", "પ\u{ac1}સ\u{acd}તક"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("littafi na ruwan goro"),
            keywords: &["littafi", "littafi na ruwan goro", "ruwan goro"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ספר כתום"),
            keywords: &["כתום", "ספר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("नार\u{902}गी किताब"),
            keywords: &["नार\u{902}गी किताब", "प\u{941}स\u{94d}तक"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("narančasta knjiga"),
            keywords: &["knjiga", "narančasta knjiga", "narančasto"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("narancssárga könyv"),
            keywords: &["könyv", "narancssárga"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("նարնջագույն գիրք"),
            keywords: &["գիրք", "նարնջագույն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("buku oranye"),
            keywords: &["buku", "oranye"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akwukwọ oroma"),
            keywords: &["akwukwọ", "oroma"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("appelsínugul bók"),
            keywords: &["appelsínugul", "bók"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("libro arancione"),
            keywords: &["libro", "libro arancione"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("オレンジの本"),
            keywords: &["オレンジの本", "書籍"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("buku kunir"),
            keywords: &["buku", "buku kunir", "werna kunir"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სტაფილოსფერი წიგნი"),
            keywords: &["ნარინჯისფერი", "სტაფილოსფერი", "წიგნი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("adlis ačinawi"),
            keywords: &["adlis ačinawi"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сарғыш кітап"),
            keywords: &["кітап", "сарғыш"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("orange bog"),
            keywords: &["bog", "orange bog"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សៀវភៅក\u{17d2}របពណ\u{17cc}ទ\u{17b9}កក\u{17d2}រ\u{17bc}ច"),
            keywords: &[
                "ទ\u{17b9}កក\u{17d2}រ\u{17bc}ច",
                "សៀវភៅ",
                "សៀវភៅក\u{17d2}របពណ\u{17cc}ទ\u{17b9}កក\u{17d2}រ\u{17bc}ច",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{cbf}ತ\u{ccd}ತಲ\u{cc6} ಬಣ\u{ccd}ಣದ ಪುಸ\u{ccd}ತಕ"),
            keywords: &[
                "ಕ\u{cbf}ತ\u{ccd}ತಲ\u{cc6} ಬಣ\u{ccd}ಣದ ಪುಸ\u{ccd}ತಕ",
                "ಪುಸ\u{ccd}ತಕ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("주황색 책"),
            keywords: &["오렌지색 책", "주황색 책", "책"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("लारा\u{902}जी प\u{941}स\u{94d}तक"),
            keywords: &["प\u{941}स\u{94d}तक", "लारा\u{902}जी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("саргыч китеп"),
            keywords: &["китеп", "саргыч"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("oranget Buch"),
            keywords: &["Buch", "orange", "oranget Buch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{eb7}\u{ec9}ມສ\u{eb5}ໝາກກ\u{ec9}ຽງ"),
            keywords: &[
                "ປ\u{eb7}\u{ec9}ມ",
                "ປ\u{eb7}\u{ec9}ມສ\u{eb5}ໝາກກ\u{ec9}ຽງ",
                "ສ\u{eb5}ສ\u{ebb}\u{ec9}ມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("oranžinė knyga"),
            keywords: &["knyga", "oranžinė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("oranža grāmata"),
            keywords: &["grāmata", "oranža"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pukapuka karaka"),
            keywords: &["karaka", "pukapuka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("портокалова книга"),
            keywords: &["книга", "портокалова"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഓറഞ\u{d4d}ച\u{d4d} പ\u{d41}സ\u{d4d}\u{200c}തകം"),
            keywords: &[
                "ഓറഞ\u{d4d}ച\u{d4d} പ\u{d41}സ\u{d4d}\u{200c}തകം",
                "പ\u{d41}സ\u{d4d}തകം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("улбар шар ном"),
            keywords: &["ном", "улбар шар", "улбар шар ном"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("औषधा\u{902}स\u{902}बधी माहितीच\u{947} प\u{941}स\u{94d}तक"),
            keywords: &[
                "औषधा\u{902}स\u{902}बधी माहितीच\u{947} प\u{941}स\u{94d}तक",
                "औषधास\u{902}ब\u{902}धी माहितीच\u{947} प\u{941}स\u{94d}तक",
                "नार\u{902}गी",
                "प\u{941}स\u{94d}तक",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("buku oren"),
            keywords: &["buku", "oren"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ktieb oranġjo"),
            keywords: &["ktieb", "oranġjo"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လ\u{102d}မ\u{1039}မော\u{103a}ရောင\u{103a} စာအ\u{102f}ပ\u{103a}"),
            keywords: &[
                "စာအ\u{102f}ပ\u{103a}",
                "လ\u{102d}မ\u{1039}မော\u{103a}ရောင\u{103a} စာအ\u{102f}ပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("oransje bok"),
            keywords: &["bok", "oransje"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{941}न\u{94d}तला रङको प\u{941}स\u{94d}तक"),
            keywords: &[
                "प\u{941}स\u{94d}तक",
                "स\u{941}न\u{94d}तला",
                "स\u{941}न\u{94d}तला रङको प\u{941}स\u{94d}तक",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("oranje boek"),
            keywords: &["boek", "oranje"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("oransje bok"),
            keywords: &["bok", "oransje"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କମଳ\u{b3e} ବହ\u{b3f}"),
            keywords: &["କମଳ\u{b3e}", "କମଳ\u{b3e} ବହ\u{b3f}", "ପ\u{b41}ସ\u{b4d}ତକ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a70}ਤਰੀ ਕਿਤਾਬ"),
            keywords: &["ਕਿਤਾਬ", "ਸ\u{a70}ਤਰੀ ਕਿਤਾਬ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("نارنگی کتاب"),
            keywords: &["مالٹا", "نارنگی کتاب", "کتاب"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ọ\u{301}rénj Kọ\u{301}lọ Buk"),
            keywords: &[
                "Buk",
                "Ọ\u{301}rénj Kọ\u{301}lọ",
                "Ọ\u{301}rénj Kọ\u{301}lọ Buk",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pomarańczowa książka"),
            keywords: &["książka", "pomarańczowa"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("نارنجي کتاب"),
            keywords: &["نارنجي", "کتاب"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("livro laranja"),
            keywords: &["laranja", "livro"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("livro cor de laranja"),
            keywords: &["cor de laranja", "livro", "livro cor de laranja"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("willapi pʼanqa"),
            keywords: &["p’anqa", "willapi", "willapi pʼanqa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("carte portocalie"),
            keywords: &["carte", "carte portocalie", "portocaliu"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-662"),
            keywords: &["E10-662"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("оранжевая книга"),
            keywords: &["книга", "книжка", "оранжевая"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igitabo cya oranje"),
            keywords: &["igitabo cya oranje"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("نارنگي ڪتاب"),
            keywords: &["نارنگي", "ڪتاب"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("තැඹ\u{dd2}ල\u{dd2} පොත"),
            keywords: &["තැඹ\u{dd2}ල\u{dd2}", "පොත"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("oranžová kniha"),
            keywords: &["kniha", "oranžová"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("oranžna knjiga"),
            keywords: &["knjiga", "oranžna knjiga", "oranžno"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("buug liimi ah"),
            keywords: &["buug", "buug liimi ah", "liimi"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("libër portokalli"),
            keywords: &["libër", "portokalli"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("наранџаста књига"),
            keywords: &["књига", "наранџаста књига", "наранџасто"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["наранџаста књига"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("narandžasta knjiga"),
            keywords: &["knjiga", "narandžasta knjiga", "narandžasto"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["narandžasta knjiga"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("orange bok"),
            keywords: &["bok", "orange bok"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitabu cha njano"),
            keywords: &["kitabu", "kitabu cha njano", "manjano"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆரஞ\u{bcd}சு புத\u{bcd}தகம\u{bcd}"),
            keywords: &["ஆரஞ\u{bcd}சு புத\u{bcd}தகம\u{bcd}", "புத\u{bcd}தகம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("న\u{c3e}ర\u{c3f}ంజ రంగు పుస\u{c4d}తకం"),
            keywords: &[
                "న\u{c3e}ర\u{c3f}ంజ రంగు",
                "న\u{c3e}ర\u{c3f}ంజ రంగు పుస\u{c4d}తకం",
                "పుస\u{c4d}తకం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("китоби норанҷӣ"),
            keywords: &["китоб", "китоби норанҷӣ", "норанҷӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e31}งส\u{e37}อส\u{e35}ส\u{e49}ม"),
            keywords: &[
                "หน\u{e31}งส\u{e37}อ",
                "หน\u{e31}งส\u{e37}อส\u{e35}ส\u{e49}ม",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("mämişi kitap"),
            keywords: &["kitap", "mämişi"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tohi lanumoli"),
            keywords: &["tohi lanumoli"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("turuncu kitap"),
            keywords: &["kitap", "turuncu kitap"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قىزغۇچ كىتاب"),
            keywords: &["قىزغۇچ", "كىتاب"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("оранжевий підручник"),
            keywords: &["книжка", "оранжевий", "оранжевий підручник"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("نارنجی کتاب"),
            keywords: &["رنگ", "نارنجی", "کتاب"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("to‘q sariq kitob"),
            keywords: &["kitob", "toʻq sariq", "to‘q sariq kitob"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("sách màu cam"),
            keywords: &["màu cam", "sách", "sách màu cam"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("téere bu oraas"),
            keywords: &["oraas", "téere", "téere bu oraas"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("incwadi eorenji"),
            keywords: &["eorenji", "incwadi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("iwe alawọ ọsan"),
            keywords: &["aláwò\u{329} ọsàn", "iwe alawọ ọsan", "ìwé"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("橙色書"),
            keywords: &["書", "橙色", "橙色書"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("橙色书"),
            keywords: &["书", "橙色", "橙色书"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("橙色书本"),
            keywords: &["书", "书本", "橙色", "橙色书本"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("橘色的書本"),
            keywords: &["書本", "橘色的書本"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("橙色簿"),
            keywords: &["橙色簿", "橙色簿｜書｜橙色"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("incwadi ephuzi"),
            keywords: &["incwadi", "incwadi ephuzi", "okuphuzi"],
        },
    ],
};
#[doc = "📚"]
pub const BOOKS: crate::Emoji = crate::Emoji {
    glyph: "📚",
    codepoint: "1F4DA",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "books",
    group: "Objects",
    subgroup: "book-paper",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("boeke"),
            keywords: &["boeke"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መጽሐፍት"),
            keywords: &["መጽሐፍ", "መጽሐፍት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كتب"),
            keywords: &["كتاب", "كتب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কিত\u{9be}পসম\u{9c2}হ"),
            keywords: &["কিত\u{9be}প", "কিত\u{9be}পসম\u{9c2}হ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kitablar"),
            keywords: &["kitab", "kitablar"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кнігі"),
            keywords: &["кніга", "кнігі"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("книги"),
            keywords: &["книга", "книги"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বই"),
            keywords: &["বই"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("levrioù"),
            keywords: &["levr", "levrioù"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("knjige"),
            keywords: &["knjiga", "knjige"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("llibres"),
            keywords: &["llibre", "llibres"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎪᏪᎵ"),
            keywords: &["ᎪᏪᎵ", "ᏗᎪᏪᎵ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("knihy"),
            keywords: &["kniha", "knihy"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("llyfrau"),
            keywords: &["llyfr", "llyfrau"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bøger"),
            keywords: &["bog", "bøger"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Bücherstapel"),
            keywords: &["Bücher", "Bücherstapel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("βιβλία"),
            keywords: &["βιβλία", "βιβλίο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("books"),
            keywords: &["book", "books"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("libros"),
            keywords: &["libros"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["libro", "libros", "pila"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("raamatud"),
            keywords: &["raamat", "raamatud"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("liburuak"),
            keywords: &["liburu", "liburuak"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("چند کتاب"),
            keywords: &["چند کتاب", "کتاب"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kirjoja"),
            keywords: &["kirja", "kirjapino", "kirjat", "kirjoja"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mga aklat"),
            keywords: &["aklat", "mga aklat"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("bøkur"),
            keywords: &["bók", "bøkur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("livres"),
            keywords: &["livre", "livres"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("leabhair"),
            keywords: &["leabhair"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("leabhraichean"),
            keywords: &["leabhar", "leabhraichean"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("libros"),
            keywords: &["libros"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{ac1}સ\u{acd}તકો"),
            keywords: &["પ\u{ac1}સ\u{acd}તક", "પ\u{ac1}સ\u{acd}તકો"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("littattafai"),
            keywords: &["littafi", "littattafai"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ספרים"),
            keywords: &["ספר", "ספרים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("किताब\u{947}\u{902}"),
            keywords: &["किताब\u{947}\u{902}", "प\u{941}स\u{94d}तक"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("knjige"),
            keywords: &["knjiga", "knjige"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("könyvek"),
            keywords: &["könyv", "könyvek"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("գրքեր"),
            keywords: &["գիրք", "գրքեր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("buku"),
            keywords: &["buku"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akwukwọ gasị"),
            keywords: &["akwukwọ", "akwukwọ gasị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("bækur"),
            keywords: &["bækur", "bók"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("libri"),
            keywords: &["libri", "pila di libri"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("本の山"),
            keywords: &["書籍", "本の山"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("buku-buku"),
            keywords: &["buku", "buku-buku"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("წიგნები"),
            keywords: &["წიგნები", "წიგნი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("idlisen"),
            keywords: &["idlisen"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("кітаптар"),
            keywords: &["кітап", "кітаптар"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("bøger"),
            keywords: &["bog", "bøger"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សៀវភៅប\u{17b8}ត\u{17d2}រ\u{17bd}តលើគ\u{17d2}នា"),
            keywords: &[
                "ក\u{17bc}នសៀវភៅ",
                "គ\u{17c6}នរសៀវភៅ",
                "សៀវភៅ",
                "សៀវភៅកត\u{17cb}ត\u{17d2}រា",
                "សៀវភៅប\u{17b8}ត\u{17d2}រ\u{17bd}តលើគ\u{17d2}នា",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪುಸ\u{ccd}ತಕಗಳು"),
            keywords: &["ಪುಸ\u{ccd}ತಕ", "ಪುಸ\u{ccd}ತಕಗಳು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("책 여러 권"),
            keywords: &["책", "책 여러 권"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("प\u{941}स\u{94d}तका\u{902}"),
            keywords: &["प\u{941}स\u{94d}तक", "प\u{941}स\u{94d}तका\u{902}"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("китептер"),
            keywords: &["китеп", "китептер"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Bicher"),
            keywords: &["Bicher", "Buch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{eb7}\u{ec9}ມຫ\u{ebc}າຍຫ\u{ebb}ວ"),
            keywords: &["ປ\u{eb7}\u{ec9}ມ", "ປ\u{eb7}\u{ec9}ມຫ\u{ebc}າຍຫ\u{ebb}ວ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("knygos"),
            keywords: &["knyga", "knygos"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("grāmatas"),
            keywords: &["grāmata", "grāmatas"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ngā pukapuka"),
            keywords: &["ngā pukapuka", "pukapuka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("книги"),
            keywords: &["книга", "книги"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d41}സ\u{d4d}\u{200c}തകങ\u{d4d}ങൾ"),
            keywords: &[
                "പ\u{d41}സ\u{d4d}തകം",
                "പ\u{d41}സ\u{d4d}\u{200c}തകങ\u{d4d}ങൾ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ном"),
            keywords: &["ном", "номнууд"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{941}स\u{94d}तक\u{947}"),
            keywords: &["प\u{941}स\u{94d}तक", "प\u{941}स\u{94d}तक\u{947}"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("buku"),
            keywords: &["buku"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kotba"),
            keywords: &["kotba", "ktieb"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စာအ\u{102f}ပ\u{103a}များ"),
            keywords: &["စာအ\u{102f}ပ\u{103a}", "စာအ\u{102f}ပ\u{103a}များ"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bøker"),
            keywords: &["bok", "bøker"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{941}स\u{94d}तकहर\u{942}"),
            keywords: &["प\u{941}स\u{94d}तक", "प\u{941}स\u{94d}तकहर\u{942}"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("boeken"),
            keywords: &["boek", "boeken"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bøker"),
            keywords: &["bok", "bøker"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବହ\u{b3f}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ"),
            keywords: &["ପ\u{b41}ସ\u{b4d}ତକ", "ବହ\u{b3f}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਿਤਾਬਾ\u{a02}"),
            keywords: &["ਕਿਤਾਬ", "ਕਿਤਾਬਾ\u{a02}"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کتاباں"),
            keywords: &["کتاب", "کتاباں"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Buk-dẹm"),
            keywords: &["Buk", "Buk-dẹm"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("książki"),
            keywords: &["książka", "książki"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کتابونه"),
            keywords: &["کتاب", "کتابونه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("livros"),
            keywords: &["livro", "livros"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pʼanqakuna"),
            keywords: &["pʼanqakuna"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cărți"),
            keywords: &["carte", "cărți"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-663"),
            keywords: &["E10-663"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("книги"),
            keywords: &["книги", "книжки", "много книг", "стопка", "стопка книг"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibitabo"),
            keywords: &["ibitabo", "igitabo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪتابون"),
            keywords: &["ڪتاب", "ڪتابون"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පොත\u{dca}"),
            keywords: &["පොත", "පොත\u{dca}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("knihy"),
            keywords: &["kniha", "knihy", "literatúra"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("knjige"),
            keywords: &["knjiga", "knjige"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("buugaag"),
            keywords: &["buug", "buugaag"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("libra"),
            keywords: &["libra", "libër"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("књиге"),
            keywords: &["књигa", "књиге"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("knjige"),
            keywords: &["knjiga", "knjige"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("böcker"),
            keywords: &["bok", "böcker"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("vitabu"),
            keywords: &["kitabu", "vitabu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("புத\u{bcd}தகங\u{bcd}கள\u{bcd}"),
            keywords: &["புத\u{bcd}தகங\u{bcd}கள\u{bcd}", "புத\u{bcd}தகம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("పుస\u{c4d}తక\u{c3e}లు"),
            keywords: &["చదువు", "పుస\u{c4d}తక\u{c3e}లు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("китобҳо"),
            keywords: &["китоб", "китобҳо"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e31}งส\u{e37}อ"),
            keywords: &["จด", "หน\u{e31}งส\u{e37}อ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kitaplar"),
            keywords: &["kitap", "kitaplar"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻū tohi"),
            keywords: &["ʻū tohi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kitaplar"),
            keywords: &["kitap", "kitaplar"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كىتابلار"),
            keywords: &["كىتاب", "كىتابلار"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("книги"),
            keywords: &["книги", "книжка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کتابیں"),
            keywords: &["کتاب", "کتابیں"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kitoblar"),
            keywords: &["kitob", "kitoblar"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("sách"),
            keywords: &["sách"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("téere yi"),
            keywords: &["téere", "téere yi"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iincwadi"),
            keywords: &["iincwadi", "incwadi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àwọn ìwé"),
            keywords: &["àwọn ìwé", "ìwé"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("書"),
            keywords: &["書"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("书"),
            keywords: &["书"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("书"),
            keywords: &["书", "书本", "书籍", "图书", "学习"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("書本"),
            keywords: &["書", "書本", "書籍"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("一疊書"),
            keywords: &["一疊書", "書", "書本", "書籍｜一疊書"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("izincwadi"),
            keywords: &["incwadi", "izincwadi"],
        },
    ],
};
#[doc = "📓"]
pub const NOTEBOOK: crate::Emoji = crate::Emoji {
    glyph: "📓",
    codepoint: "1F4D3",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "notebook",
    group: "Objects",
    subgroup: "book-paper",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("notaboek"),
            keywords: &["notaboek"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ማስታወሻ ደብተር"),
            keywords: &["ማስታወሻ ደብተር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("دفتر ملاحظات"),
            keywords: &["دفتر", "دفتر ملاحظات"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("টোক\u{9be}বহী"),
            keywords: &["টোক\u{9be}বহী"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("bloknot"),
            keywords: &["bloknot"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("нататнік"),
            keywords: &["блакнот", "запіс", "нататка", "нататнік"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("бележник"),
            keywords: &["бележник"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("নোটব\u{9c1}ক"),
            keywords: &["নোটবই", "নোটব\u{9c1}ক"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("karned"),
            keywords: &["karned"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("sveska"),
            keywords: &["sveska"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("llibreta"),
            keywords: &["llibreta", "quadern"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎪᏪᎵ ᏗᎪᏪᎶᏙᏗ"),
            keywords: &["ᎪᏪᎵ ᏗᎪᏪᎶᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("sešit"),
            keywords: &["sešit", "zápisník"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("llyfr nodiadau"),
            keywords: &["llyfr nodiadau"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("notesbog"),
            keywords: &["noter", "notesbog"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Notizbuch"),
            keywords: &["Notizbuch", "Notizen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σημειωματάριο"),
            keywords: &["σημειωματάριο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("notebook"),
            keywords: &["notebook"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cuaderno"),
            keywords: &["cuaderno", "libreta"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["cuaderno", "negro"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["cuaderno", "negro"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("päevik"),
            keywords: &["päevik", "raamat"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("koadernoa"),
            keywords: &["koaderno", "koadernoa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دفتر یادداشت"),
            keywords: &["دفتر", "دفتر یادداشت", "دفترچه", "کتابچه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("muistikirja"),
            keywords: &["kirja", "lehtiö", "muistikirja", "muistio"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("notebook"),
            keywords: &["notebook"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("lummabók"),
            keywords: &[
                "blokkur",
                "bók",
                "lummabók",
                "minnisbók",
                "skriviblokkur",
                "uppritsbók",
                "uppskrivingarbók",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("carnet"),
            keywords: &["carnet"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["cahier", "carnet"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("leabhar nótaí"),
            keywords: &["leabhar nótaí"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("leabhar-nòtaichean"),
            keywords: &["leabhar", "leabhar-nòtaichean"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("caderno"),
            keywords: &["caderno"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("નોટબ\u{ac1}ક"),
            keywords: &["નોટબ\u{ac1}ક"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("littafin rubutu"),
            keywords: &["littafin rubutu"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מחברת"),
            keywords: &["מחברת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("नोटब\u{941}क"),
            keywords: &["नोटब\u{941}क"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("bilježnica"),
            keywords: &["bilježnica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("jegyzetfüzet"),
            keywords: &["füzet", "jegyzetek", "jegyzetfüzet"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տետր"),
            keywords: &["տետր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("buku catatan"),
            keywords: &["buku catatan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akwukwọnoòtù"),
            keywords: &["akwukwọnoòtù"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("glósubók"),
            keywords: &["dagbók", "glósubók"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("quaderno"),
            keywords: &["appunti", "prendere nota", "quaderno", "taccuino"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ノート"),
            keywords: &["ノート", "文具", "文房具"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("notebook"),
            keywords: &["notebook"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ნოუთბუქი"),
            keywords: &["ლეპტოპი", "ნოუთბუქი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("imedlis"),
            keywords: &["imedlis"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("дәптер"),
            keywords: &["дәптер"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("notesbog"),
            keywords: &["noter", "notesbog"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សៀវភៅកត\u{17cb}ត\u{17d2}រា"),
            keywords: &["ក\u{17bc}នសៀវភៅ", "សៀវភៅ", "សៀវភៅកត\u{17cb}ត\u{17d2}រា"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನೋಟ\u{ccd} ಬುಕ\u{ccd}"),
            keywords: &["ಕ\u{cbf}ರುಪುಸ\u{ccd}ತಕ", "ನೋಟ\u{ccd} ಬುಕ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("공책"),
            keywords: &["공책", "노트"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("चोपडी"),
            keywords: &["चोपडी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("дептер"),
            keywords: &["дептер"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Notizblock"),
            keywords: &["Notizblock"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສະໝ\u{eb8}ດບ\u{eb1}ນທ\u{eb6}ກ"),
            keywords: &["ສະໝ\u{eb8}ດບ\u{eb1}ນທ\u{eb6}ກ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("užrašinė"),
            keywords: &["užrašinė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("piezīmju grāmata"),
            keywords: &["piezīmju grāmata"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pukatuhipoka"),
            keywords: &["pukatuhipoka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("бележник"),
            keywords: &["бележник"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("നോട\u{d4d}ട\u{d4d}ബ\u{d41}ക\u{d4d}ക\u{d4d}"),
            keywords: &[
                "നോട\u{d4d}ട\u{d4d} ബ\u{d41}ക\u{d4d}ക\u{d4d}",
                "നോട\u{d4d}ട\u{d4d}ബ\u{d41}ക\u{d4d}ക\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дэвтэр"),
            keywords: &["дэвтэр"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("वही"),
            keywords: &["नोटब\u{941}क", "वही"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("buku nota"),
            keywords: &["buku nota"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("notebook"),
            keywords: &["notebook"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မ\u{103e}တ\u{103a}စ\u{102f}စာအ\u{102f}ပ\u{103a}"),
            keywords: &["မ\u{103e}တ\u{103a}စ\u{102f}စာအ\u{102f}ပ\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("notatbok"),
            keywords: &["kladdebok", "kontorrekvisita", "notatbok"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("नोटब\u{941}क"),
            keywords: &["नोटब\u{941}क"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("schrift"),
            keywords: &["notitieboek", "schrift"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("notatbok"),
            keywords: &["kladdebok", "kontorrekvisita", "notatbok"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ନୋଟ\u{b4d}\u{200c}ବ\u{b41}କ\u{b4d}\u{200c}"),
            keywords: &["ନୋଟ\u{b4d}\u{200c}ବ\u{b41}କ\u{b4d}\u{200c}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਨ\u{a4b}ਟਬ\u{a41}\u{a71}ਕ"),
            keywords: &["ਨ\u{a4b}ਟਬ\u{a41}\u{a71}ਕ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("نوٹ بک"),
            keywords: &["نوٹ بک"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Nótbuk"),
            keywords: &["Nótbuk"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("notes"),
            keywords: &["notatnik", "notes", "szary", "zeszyt"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کاپي"),
            keywords: &["کاپي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("caderno"),
            keywords: &["caderno", "folhas"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("huchuy qillqanacha"),
            keywords: &["huchuy qillqanacha"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("carnet"),
            keywords: &["carnet"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-656"),
            keywords: &["E10-656"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("тетрадь"),
            keywords: &["блокнот", "записная книжка", "тетрадка", "тетрадь"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("mudasobwa nini"),
            keywords: &["mudasobwa nini"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("نوٽ بڪ"),
            keywords: &["نوٽ بڪ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සටහන\u{dca} පොත"),
            keywords: &["සටහන\u{dca} පොත"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zápisník"),
            keywords: &["poznámkový zošit", "zápisník"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zvezek"),
            keywords: &["zvezek"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("buug"),
            keywords: &["buug"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("bllok shënimesh"),
            keywords: &["bllok shënimesh"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("свеска"),
            keywords: &["свеска"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("sveska"),
            keywords: &["sveska"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("anteckningsbok"),
            keywords: &["anteckningsbok", "skrivbok"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("daftari"),
            keywords: &["daftari"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("நோட\u{bcd}டுப\u{bcd}புத\u{bcd}தகம\u{bcd}"),
            keywords: &[
                "நோட\u{bcd}டுப\u{bcd}புத\u{bcd}தகம\u{bcd}",
                "நோட\u{bcd}புக\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("న\u{c4b}టు పుస\u{c4d}తకం"),
            keywords: &["న\u{c4b}టు పుస\u{c4d}తకం", "పుస\u{c4d}తకం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дафтар"),
            keywords: &["дафтар"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("สม\u{e38}ดโน\u{e49}ต"),
            keywords: &["จด", "บ\u{e31}นท\u{e36}ก", "สม\u{e38}ดโน\u{e49}ต"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("depderçe"),
            keywords: &["depderçe"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pepa tohi"),
            keywords: &["pepa tohi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("not defteri"),
            keywords: &["not defteri"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("خاتىرە دەپتەر"),
            keywords: &["خاتىرە دەپتەر"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("зошит для творів"),
            keywords: &["блокнот", "записник", "зошит для творів"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("نوٹ بک"),
            keywords: &["نوٹ بک", "کتاب"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("noutbook"),
            keywords: &["noutbook"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("sổ ghi chép"),
            keywords: &["sổ ghi chép"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kàrne"),
            keywords: &["kàrne"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("incwadi yamanqaku"),
            keywords: &["incwadi yamanqaku"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àfikọ\u{300}wé"),
            keywords: &["àfikọ\u{300}wé"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("筆記簿"),
            keywords: &["筆記簿"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("笔记簿"),
            keywords: &["笔记簿"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("笔记本"),
            keywords: &["日记本", "本子", "笔记", "笔记本", "记事本", "记录"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("筆記本"),
            keywords: &["筆記本"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("筆記簿"),
            keywords: &["筆記簿"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("incwajana"),
            keywords: &["incwajana"],
        },
    ],
};
#[doc = "📒"]
pub const LEDGER: crate::Emoji = crate::Emoji {
    glyph: "📒",
    codepoint: "1F4D2",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "ledger",
    group: "Objects",
    subgroup: "book-paper",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("lêer"),
            keywords: &["lêer", "omslag"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መዝገብ"),
            keywords: &["መዝገብ", "ማስታወሻ ደብተር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("دفتر"),
            keywords: &["دفتر", "كراسة ملاحظات"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("জম\u{9be}-খৰচৰ বহী"),
            keywords: &["জম\u{9be}-খৰচৰ বহী", "টোক\u{9be}বহী"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("mühasibatlıq kitabı"),
            keywords: &["dəftər", "mühasibatlıq kitabı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("бухгалтарская кніга"),
            keywords: &["бухгалтарская кніга", "запіс", "справаводства", "улік"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Главна книга"),
            keywords: &["Главна книга", "бележник"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("খ\u{9be}ত\u{9be}"),
            keywords: &["খ\u{9be}ত\u{9be}", "নোটবই"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("marilh"),
            keywords: &["karned", "marilh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("rokovnik"),
            keywords: &["rokovnik", "sveska"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("llibre de comptabilitat"),
            keywords: &["comptabilitat", "llibre", "llibre de comptabilitat"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎪᏪᎵ ᎤᎭᎨᏓ"),
            keywords: &["ᎪᏪᎵ ᎤᎭᎨᏓ", "ᎪᏪᎵ ᏗᎪᏪᎶᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("účetní kniha"),
            keywords: &["sešit", "zápisník", "účetní kniha"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cyfriflyfr"),
            keywords: &["cyfriflyfr", "llyfr nodiadau"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("regnskabsbog"),
            keywords: &["notesbog", "regnskabsbog"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Spiralblock"),
            keywords: &["Notizblock", "Spiralblock"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("λογιστικό βιβλίο"),
            keywords: &["λογιστικό βιβλίο", "σημειωματάριο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("ledger"),
            keywords: &["ledger", "notebook"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("libro de contabilidad"),
            keywords: &["cuaderno", "libro de contabilidad"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["contabilidad", "libro", "libro de contabilidad"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("arveraamat"),
            keywords: &["arve", "arveraamat", "raamat"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kontabilitate-liburua"),
            keywords: &["koaderno", "kontabilitate-liburua"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دفتر سیمی"),
            keywords: &["دفتر", "دفتر سیمی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tilikirja"),
            keywords: &["kirja", "kirjanpito", "lehtiö", "tilikirja"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("ledger"),
            keywords: &["ledger", "notebook"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("høvuðsbók"),
            keywords: &["høvuðsbók", "lummabók"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("carnet de compte"),
            keywords: &["carnet de compte", "grand livre"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("carnet de compte"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("mórleabhar"),
            keywords: &["leabhar nótaí", "mórleabhar"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("leabhar-cunntais"),
            keywords: &["leabhar", "leabhar-cunntais", "leabhar-nòtaichean"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("libro de contabilidade"),
            keywords: &[
                "caderno",
                "contabilidade",
                "libro",
                "libro de contabilidade",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ખાતાવહી"),
            keywords: &["ખાતાવહી", "નોટબ\u{ac1}ક"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("laja"),
            keywords: &["laja", "littafin rubutu"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("יומן"),
            keywords: &["יומן", "מחברת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ल\u{947}जर, नोटब\u{941}क"),
            keywords: &["नोटब\u{941}क", "ल\u{947}जर", "ल\u{947}जर, नोटब\u{941}क"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("računovodstvena knjiga"),
            keywords: &["bilježnica", "računovodstvena knjiga"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("főkönyv"),
            keywords: &["főkönyv", "könyv"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("հաշվապահական մատյան"),
            keywords: &["հաշվապահական մատյան", "նոթատետր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("buku besar"),
            keywords: &["buku besar", "buku catatan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("leja"),
            keywords: &["akwukwọnoòtù", "leja"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("dagbók"),
            keywords: &["dagbók", "færslubók"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("quaderno ad anelli"),
            keywords: &[
                "blocco",
                "block notes",
                "libro mastro",
                "quaderno ad anelli",
                "taccuino",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("リングノート"),
            keywords: &["リングノート", "台帳", "文具", "文房具"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("buku besar"),
            keywords: &["buku besar", "notebook"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დავთარი"),
            keywords: &["დავთარი", "რვეული"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("ambellez"),
            keywords: &["ambellez"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("басты кітап"),
            keywords: &["басты кітап", "дәптер"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("regnskabsbog"),
            keywords: &["notesbog", "regnskabsbog"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សៀវភៅបញ\u{17d2}ជ\u{17b8}"),
            keywords: &[
                "ក\u{17bc}នសៀវភៅ",
                "សៀវភៅ",
                "សៀវភៅកត\u{17cb}ត\u{17d2}រា",
                "សៀវភៅបញ\u{17d2}ជ\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಲ\u{cc6}ಡ\u{ccd}ಜರ\u{ccd}"),
            keywords: &[
                "ಟ\u{cbf}ಪ\u{ccd}ಪಣ\u{cbf} ಪುಸ\u{ccd}ತಕ",
                "ನೋಟ\u{ccd}\u{200c}ಬುಕ\u{ccd}",
                "ಪುಸ\u{ccd}ತಕಗಳು",
                "ಲ\u{cc6}ಡ\u{ccd}ಜರ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("노트"),
            keywords: &["공책", "노트", "원장"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ल\u{947}जर"),
            keywords: &["चोपडी", "ल\u{947}जर"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бухгалтердик китепче"),
            keywords: &["блокнот", "бухгалтердик китепче"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Haaptbuch"),
            keywords: &["Haaptbuch", "Notizblock"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{eb7}\u{ec9}ມບ\u{eb1}ນທ\u{eb6}ກເຈາະຮ\u{eb9}ຂ\u{ec9}າງ"),
            keywords: &[
                "ປ\u{eb7}\u{ec9}ມບ\u{eb1}ນທ\u{eb6}ກ",
                "ປ\u{eb7}\u{ec9}ມບ\u{eb1}ນທ\u{eb6}ກເຈາະຮ\u{eb9}ຂ\u{ec9}າງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("sąskaitų knyga"),
            keywords: &["sąskaitų knyga", "užrašų knygelė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("grāmata ar spirāli"),
            keywords: &["grāmata", "grāmata ar spirāli", "spirāle"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("puka kaute"),
            keywords: &["puka kaute", "pukatuhipoka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("тефтер"),
            keywords: &["тетратка", "тефтер"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ലെഡ\u{d4d}\u{200c}ജർ"),
            keywords: &[
                "നോട\u{d4d}ട\u{d4d} ബ\u{d41}ക\u{d4d}ക\u{d4d}",
                "ലെഡ\u{d4d}\u{200c}ജർ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("өврийн дэвтэр"),
            keywords: &["дэвтэр", "өврийн дэвтэр", "өвөр"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ल\u{947}जर"),
            keywords: &["नोटब\u{941}क", "ल\u{947}जर"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("lejar"),
            keywords: &["buku nota", "lejar"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("leġer"),
            keywords: &["leġer", "notebook"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လယ\u{103a}ဂျာစာအ\u{102f}ပ\u{103a}"),
            keywords: &[
                "မ\u{103e}တ\u{103a}စ\u{102f}စာအ\u{102f}ပ\u{103a}",
                "လယ\u{103a}ဂျာစာအ\u{102f}ပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("spiralblokk"),
            keywords: &["kontorrekvisita", "notatbok", "spiralblokk"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ल\u{947}जर"),
            keywords: &["नोटब\u{941}क", "ल\u{947}जर"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("grootboek"),
            keywords: &["grootboek", "notitieboek", "schrift"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("spiralblokk"),
            keywords: &["kontorrekvisita", "notatbok", "spiralblokk"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଲେଜର\u{b4d}"),
            keywords: &["ନୋଟ\u{b4d}\u{200c}ବ\u{b41}କ\u{b4d}", "ଲେଜର\u{b4d}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬਹੀ"),
            keywords: &["ਨ\u{a4b}ਟਬ\u{a41}\u{a71}ਕ", "ਬਹੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("لیجر"),
            keywords: &["لیجر", "نوٹ بک"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Lẹ\u{301}ja"),
            keywords: &["Lẹ\u{301}ja", "Nótbuk"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("skoroszyt"),
            keywords: &["notatnik", "skoroszyt", "zeszyt", "żółty"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ليجر"),
            keywords: &["ليجر", "کاپي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("livro contábil"),
            keywords: &["caderno", "livro contábil"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("livro-razão"),
            keywords: &["bloco de notas", "livro-razão"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pʼanqa siwukunawan"),
            keywords: &["pʼanqa siwukunawan"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("registru"),
            keywords: &["carnet", "registru"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-655"),
            keywords: &["E10-655"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("блокнот"),
            keywords: &[
                "блокнот",
                "блокнотик",
                "записная книжка",
                "тетрадка",
                "тетрадь",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igitabo"),
            keywords: &["igitabo", "mudasobwa nini"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ليجر"),
            keywords: &["ليجر", "نوٽ بڪ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ලෙජරය"),
            keywords: &["ලෙජරය", "සටහන\u{dca} පොත"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("účtovná kniha"),
            keywords: &["poznámkový zošit", "účtovná kniha"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zvezek s spiralno vezavo"),
            keywords: &["zvezek", "zvezek s spiralno vezavo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("buuga xisaabaadka"),
            keywords: &["buug", "buuga xisaabaadka"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("libër llogarish"),
            keywords: &["bllok shënimesh", "libër llogarish"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("бележница"),
            keywords: &["бележница", "свеска"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("биљежница"),
            keywords: &["биљежница"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("beležnica"),
            keywords: &["beležnica", "sveska"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("bilježnica"),
            keywords: &["bilježnica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("liggare"),
            keywords: &["liggare", "skrivbok"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("leja"),
            keywords: &["daftari", "leja"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("லெட\u{bcd}ஜெர\u{bcd}"),
            keywords: &[
                "நோட\u{bcd}டு",
                "புத\u{bcd}தகம\u{bcd}",
                "லெட\u{bcd}ஜெர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ల\u{c46}డ\u{c4d}జర\u{c4d}"),
            keywords: &[
                "ఆవర\u{c4d}జ\u{c3e}",
                "ఖ\u{c3e}త\u{c3e}",
                "పుస\u{c4d}తకం",
                "ల\u{c46}డ\u{c4d}జర\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дафтари бухғалтерӣ"),
            keywords: &["дафтар", "дафтари бухғалтерӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("สม\u{e38}ดโน\u{e49}ตเจาะร\u{e39}ข\u{e49}าง"),
            keywords: &[
                "สม\u{e38}ดโน\u{e49}ต",
                "สม\u{e38}ดโน\u{e49}ตเจาะร\u{e39}ข\u{e49}าง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("buhgalter kitaby"),
            keywords: &["buhgalter kitaby", "depderçe"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("lētisa"),
            keywords: &["lētisa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("resmi defter"),
            keywords: &["not defteri", "resmi defter"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("دەپتەر"),
            keywords: &["خاتىرە دەپتەر", "دەپتەر"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("гросбух"),
            keywords: &["гросбух", "записник"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("لیجر"),
            keywords: &["لیجر", "نوٹ بک"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ro‘yxatga olish kitobi"),
            keywords: &["daftar", "ro‘yxatga olish kitobi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("sổ cái"),
            keywords: &["sổ cái", "sổ ghi chép"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("téere bu rëy"),
            keywords: &["kàrne", "téere bu rëy"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ileja"),
            keywords: &["ileja", "incwadi yamanqaku"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("lé\u{329}jà"),
            keywords: &["lé\u{329}jà", "àfikọ\u{300}wé"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("賬簿"),
            keywords: &["筆記簿", "賬簿"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("账簿"),
            keywords: &["笔记簿", "账簿"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("账本"),
            keywords: &["笔记本", "记事本", "记账", "账本", "账簿"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("帳本"),
            keywords: &["帳本", "帳簿"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("帳簿"),
            keywords: &["帳簿", "帳簿｜簿"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ileja"),
            keywords: &["ileja", "incwajana"],
        },
    ],
};
#[doc = "📃"]
pub const PAGE_WITH_CURL: crate::Emoji = crate::Emoji {
    glyph: "📃",
    codepoint: "1F4C3",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "page with curl",
    group: "Objects",
    subgroup: "book-paper",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("bladsy met krul"),
            keywords: &["bladsy", "bladsy met krul", "dokument", "krul", "papier"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሸብለል ያለ ወረቀት"),
            keywords: &["ሰነድ", "ሸብለል ያለ ወረቀት", "ገጽ", "ጥቅልል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("صفحة ملفوفة"),
            keywords: &["صفحة", "صفحة بطية", "صفحة ملفوفة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মেৰখোৱ\u{9be} প\u{9c3}ষ\u{9cd}ঠ\u{9be}"),
            keywords: &[
                "নথি",
                "প\u{9be}ক খোৱ\u{9be}",
                "প\u{9c3}ষ\u{9cd}ঠ\u{9be}",
                "মেৰখোৱ\u{9be} প\u{9c3}ষ\u{9cd}ঠ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qatlanmış səhifə"),
            keywords: &["qatlanmış səhifə", "spiral", "səhifə", "sənəd"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("старонка з загібам"),
            keywords: &[
                "дакумент",
                "завіток",
                "загіб",
                "старонка",
                "старонка з загібам",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Завита страница"),
            keywords: &["Завита страница", "документ", "завита", "страница"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মোড\u{9bc}\u{9be}নো প\u{9c3}ষ\u{9cd}ঠ\u{9be}"),
            keywords: &[
                "ক\u{9c1}ন\u{9cd}ডলী প\u{9be}ক\u{9be}নো",
                "নথি",
                "প\u{9c3}ষ\u{9cd}ঠ\u{9be}",
                "মোড\u{9bc}\u{9be}নো প\u{9c3}ষ\u{9cd}ঠ\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pajenn rollet"),
            keywords: &["pajenn", "pajenn rollet"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("stranica blago savijena"),
            keywords: &["dokument", "stranica", "stranica blago savijena", "uvoj"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pàgina que es cargola"),
            keywords: &["cargolada", "pàgina", "pàgina que es cargola"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎦᏅᏓᏛ ᎤᎵᎪᏗ ᎤᎵᏥᏍᏆᏁᏗ"),
            keywords: &["ᎤᎦᏅᏓᏛ ᎤᎵᎪᏗ ᎤᎵᏥᏍᏆᏁᏗ", "ᎤᎦᏅᏓᏛᎢ", "ᎦᏄᏖᏲᎸ", "ᎪᏪᎳᏅᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zkroucená stránka"),
            keywords: &[
                "dokument",
                "ohnutá",
                "stočená",
                "stránka",
                "svinutá",
                "svitek",
                "zkroucená stránka",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("tudalen gyda chwrl"),
            keywords: &["cwrl", "dogfen", "tudalen", "tudalen gyda chwrl"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("side med fold"),
            keywords: &["side", "side med fold"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("teilweise eingerolltes Blatt"),
            keywords: &[
                "Dokument",
                "Papier",
                "Seite",
                "teilweise eingerolltes Blatt",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κυρτωμένη σελίδα"),
            keywords: &["έγγραφο", "κυρτωμένη σελίδα", "κυρτός", "σελίδα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("page with curl"),
            keywords: &["curl", "document", "page", "page with curl"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("página doblada"),
            keywords: &["documento", "página", "página doblada"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("documento doblado"),
            keywords: &["doblada", "documento doblado", "página"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("página doblada"),
            keywords: &["página doblada"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kaardunud paberileht"),
            keywords: &["dokument", "kaardunud paberileht", "leht"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("orri tolestua"),
            keywords: &["dokumentu", "orri", "orri tolestua", "tolestu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("صفحه\u{654} تاشده"),
            keywords: &["تا", "جمع\u{200c}شده", "سند", "صفحه", "صفحه\u{654} تاشده"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("käännetty sivu"),
            keywords: &["asiakirja", "dokumentti", "käännetty sivu", "sivu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pahinang bahagyang nakarolyo"),
            keywords: &[
                "dokumento",
                "pahina",
                "pahina na may tupi",
                "pahinang bahagyang nakarolyo",
                "tupi",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("krúlla pappír"),
            keywords: &["bræv", "krúlla", "pappír", "prógv", "skjal"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("page enroulée"),
            keywords: &["page", "page enroulée"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("leathanach le coirnín"),
            keywords: &[
                "doiciméad",
                "leathanach craptha",
                "leathanach le choirnín",
                "leathanach le coirnín",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("duilleag le lùbadh"),
            keywords: &["duilleag", "duilleag le lùbadh", "lùbadh", "sgrìobhainn"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("páxina coa parte inferior enrolada"),
            keywords: &[
                "contrato",
                "documento",
                "enrolada",
                "páxina coa parte inferior enrolada",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વળ\u{ac7}લ\u{ac1}\u{a82} પ\u{ac3}ષ\u{acd}ઠ"),
            keywords: &[
                "દસ\u{acd}તાવ\u{ac7}જ",
                "પ\u{ac3}ષ\u{acd}ઠ",
                "વળ\u{ac7}લ\u{ac1}\u{a82} પ\u{ac3}ષ\u{acd}ઠ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("shafi mai nannaɗi"),
            keywords: &["daftari", "nannaɗi", "shafi", "shafi mai nannaɗi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("דף עם קצה מגולגל"),
            keywords: &["דף", "דף עם קצה מגולגל", "מגולגל", "מסמך", "נייר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("म\u{941}ड\u{93c}ा ह\u{941}आ प\u{943}ष\u{94d}ठ"),
            keywords: &[
                "दस\u{94d}ताव\u{947}ज\u{93c}",
                "प\u{943}ष\u{94d}ठ",
                "म\u{941}ड\u{93c}ा ह\u{941}आ प\u{943}ष\u{94d}ठ",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("savinuta stranica"),
            keywords: &["dokument", "savinuta stranica", "savinuto", "stranica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kunkorodó lap"),
            keywords: &["dokumentum", "kunkorodik", "kunkorodó lap", "lap"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կլորացած էջ"),
            keywords: &["էջ", "կլորացած", "փաստաթուղթ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("halaman tergulung"),
            keywords: &["dokumen", "gulung", "halaman", "halaman tergulung"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihuakwụkwọ nwere mpịaji"),
            keywords: &[
                "dọkụmenti",
                "ihuakwụkwọ",
                "ihuakwụkwọ nwere mpịaji",
                "pịajie",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("skjal"),
            keywords: &["skjal", "síða", "uppábrett síða"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pagina con piega"),
            keywords: &[
                "documento",
                "pagina",
                "pagina arricciata",
                "pagina con piega",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("巻きページ"),
            keywords: &["カール", "巻きページ", "文書", "書類"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("salembar kertas nglunthung"),
            keywords: &[
                "dokumen",
                "klunthung",
                "lembaran",
                "salembar kertas nglunthung",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მომრგვალებული გვერდი"),
            keywords: &["გვერდი", "დოკუმენტი", "მომრგვალებული გვერდი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("asebter yettwasekwren"),
            keywords: &["asebter yettwasekwren"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бір шеті оралған бет"),
            keywords: &["бет", "бір шеті оралған бет", "орау", "құжат"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("side med fold"),
            keywords: &["side", "side med fold"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សន\u{17d2}ល\u{17b9}កក\u{17d2}រដាសរម\u{17bc}លព\u{17b8}ក\u{17d2}រោម"),
            keywords: &[
                "ក\u{17d2}រដាស",
                "សន\u{17d2}ល\u{17b9}កក\u{17d2}រដាស",
                "សន\u{17d2}ល\u{17b9}កក\u{17d2}រដាសរម\u{17bc}លព\u{17b8}ក\u{17d2}រោម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸುರಳ\u{cbf} ಪುಟ"),
            keywords: &[
                "ಒಂದು ಸುರುಳ\u{cbf}ಯ ಪುಟ",
                "ಡಾಕ\u{ccd}ಯುಮ\u{cc6}ಂಟ\u{ccd}",
                "ಪುಟ",
                "ಸುರಳ\u{cbf} ಪುಟ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("안으로 말린 문서"),
            keywords: &["안으로 말린 문서", "페이지"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दोडिल\u{94d}ल\u{947}\u{902} पान"),
            keywords: &["दस\u{94d}ताव\u{947}ज", "दोडिल\u{94d}ल\u{947}\u{902}", "पान"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("оролган барак"),
            keywords: &["барак", "документ", "оролган барак", "оролгон"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("opgerullte Säit"),
            keywords: &[
                "Dokument",
                "Kréngel",
                "Säit",
                "opgerullt",
                "opgerullte Säit",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຈ\u{ec9}ຍມ\u{ec9}ວນປາຍ"),
            keywords: &[
                "ມ\u{ec9}ວນ",
                "ເຈ\u{ec9}ຍມ\u{ec9}ວນປາຍ",
                "ເອກະສານ",
                "ໜ\u{ec9}າເຈ\u{ec9}ຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("užsirietęs puslapis"),
            keywords: &["dokumentas", "puslapis", "užsirietęs"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("lapa ar atliektu malu"),
            keywords: &["dokuments", "lapa", "lapa ar atliektu malu"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("whārangi whai piko"),
            keywords: &["piko", "tuhinga", "whārangi", "whārangi whai piko"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("свиткан лист"),
            keywords: &["документ", "свиткан", "свиткан лист", "страница"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ച\u{d41}ര\u{d41}ണ\u{d4d}ട പേജ\u{d4d}"),
            keywords: &[
                "ച\u{d41}ര\u{d41}ണ\u{d4d}ട പേജ\u{d4d}",
                "ഡോക\u{d4d}യ\u{d41}മെന\u{d4d}റ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хуудас"),
            keywords: &["бичиг баримт", "хуудас"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("वलय असल\u{947}ल\u{947} प\u{943}ष\u{94d}\u{200d}ठ"),
            keywords: &[
                "दस\u{94d}तऐवज",
                "प\u{943}ष\u{94d}ठ",
                "वलय",
                "वलय असल\u{947}ल\u{947} प\u{941}स\u{94d}तक",
                "वलय असल\u{947}ल\u{947} प\u{943}ष\u{94d}\u{200d}ठ",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("halaman ikal"),
            keywords: &["dokumen", "halaman", "ikal"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("paġna b’nokkla"),
            keywords: &["dokument", "nokkla", "paġna", "paġna b’nokkla"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တ\u{103d}န\u{1037}\u{103a}လ\u{102d}ပ\u{103a}နေသော စာရ\u{103d}က\u{103a}"),
            keywords: &[
                "စာရ\u{103d}က\u{103a}",
                "စာရ\u{103d}က\u{103a}စာတမ\u{103a}း",
                "တ\u{103d}န\u{1037}\u{103a}လ\u{102d}ပ\u{103a}နေသော စာရ\u{103d}က\u{103a}",
                "အတ\u{103d}န\u{1037}\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("side med bøy"),
            keywords: &["ark", "opprullet", "side", "side med bøy"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कर\u{94d}लसहितको प\u{943}ष\u{94d}ठ"),
            keywords: &[
                "कर\u{94d}ल",
                "कर\u{94d}लसहितको प\u{943}ष\u{94d}ठ",
                "कागजात",
                "प\u{943}ष\u{94d}ठ",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("omkrullende pagina"),
            keywords: &[
                "document",
                "krul",
                "omkrullende pagina",
                "pagina",
                "pagina met krul",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("side med bøy"),
            keywords: &["ark", "opprulla", "side", "side med bøy"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମୋଡ\u{b3c}\u{b3f} ହୋଇଥ\u{b3f}ବ\u{b3e} ପ\u{b43}ଷ\u{b4d}ଠ\u{b3e}"),
            keywords: &[
                "କ\u{b41}ଞ\u{b4d}ଚ\u{b3f}ତ ପ\u{b43}ଷ\u{b4d}ଠ\u{b3e}",
                "ଡକ\u{b4d}ୟ\u{b41}ମେଣ\u{b4d}ଟ\u{b4d}",
                "ପ\u{b43}ଷ\u{b4d}ଠ\u{b3e}",
                "ମୋଡ\u{b3c}\u{b3f} ହୋଇଥ\u{b3f}ବ\u{b3e} ପ\u{b43}ଷ\u{b4d}ଠ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a41}ੜਿਆ ਹ\u{a4b}ਇਆ ਪ\u{a70}ਨਾ"),
            keywords: &[
                "ਕਰਲ ਨਾਲ ਪ\u{a70}ਨਾ",
                "ਦਸਤਾਵ\u{a47}ਜ\u{a3c}",
                "ਪ\u{a70}ਨਾ",
                "ਮ\u{a41}ੜਿਆ ਹ\u{a4b}ਇਆ ਪ\u{a70}ਨਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("خم نال صفحہ"),
            keywords: &["خم نال صفحہ", "دستاویز", "صفحہ", "گھونگر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pej Wé Di Maut Bẹnd"),
            keywords: &["Bẹnd", "Pej", "Pej Wé Di Maut Bẹnd", "Pépa"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zawinięta strona"),
            keywords: &["kartka", "maszynopis", "strona", "zawinięta strona"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پاڼه د تاو سره"),
            keywords: &["تاو", "سند", "پاڼه", "پاڼه د تاو سره"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("página dobrada"),
            keywords: &["dobrado", "documento", "página", "página dobrada"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("página com dobra"),
            keywords: &["dobra", "documento", "página", "página com dobra"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("llinkʼu rapi"),
            keywords: &["llinkʼu rapi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pagină rulată"),
            keywords: &["document", "pagină", "pagină rulată", "rulare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-640"),
            keywords: &["E10-640"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("страница с загибом"),
            keywords: &[
                "документ",
                "загнутая страница",
                "загнутый лист",
                "лист с загибом",
                "страница с загибом",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("paji yihinnye"),
            keywords: &["inyandiko", "kihinnye", "paji", "paji yihinnye"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("وڪڙ سان صفحو"),
            keywords: &["دستاويز", "صفحو", "وڪڙ", "وڪڙ سان صفحو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("රෝල\u{dca} ව\u{dd6} ප\u{dd2}ට\u{dd4}ව"),
            keywords: &[
                "ප\u{dd2}ට\u{dd4}ව",
                "රෝල\u{dca}",
                "රෝල\u{dca} ව\u{dd6} ප\u{dd2}ට\u{dd4}ව",
                "ලේඛනය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ohnutá stránka"),
            keywords: &["dokument", "ohnutie", "ohnutá stránka", "stránka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zvita stran"),
            keywords: &["dokument", "nagrbančiti se", "stran", "zvita stran"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("bog laaban"),
            keywords: &["bog", "bog laaban", "dokumenti", "laab"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("faqe e përthyer"),
            keywords: &["dokument", "faqe", "faqe e përthyer", "përthyej"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("страница са увијеном ивицом"),
            keywords: &[
                "дoкумeнт",
                "стрaницa",
                "страница са увијеном ивицом",
                "увијено",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("stranica sa uvijenom ivicom"),
            keywords: &[
                "dokument",
                "stranica",
                "stranica sa uvijenom ivicom",
                "uvijeno",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("upprullad sida"),
            keywords: &["dokument", "upprullad sida"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ukurasa uliokunjwa"),
            keywords: &["hati", "kukunja", "ukurasa", "ukurasa uliokunjwa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("க\u{bc0}ழே சுருட\u{bcd}டிய பக\u{bcd}கம\u{bcd}"),
            keywords: &[
                "க\u{bc0}ழே சுருட\u{bcd}டிய பக\u{bcd}கம\u{bcd}",
                "சுருண\u{bcd}ட ஆவணம\u{bcd}",
                "சுருள\u{bcd} பக\u{bcd}கம\u{bcd}",
                "பக\u{bcd}கச\u{bcd} சுருள\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ద\u{c3f}గువ మడ\u{c3f}చ\u{c3f}న ప\u{c47}జ\u{c40}"),
            keywords: &[
                "ద\u{c3f}గువ మడ\u{c3f}చ\u{c3f}న ప\u{c47}జ\u{c40}",
                "ప\u{c47}జ\u{c40}",
                "మడవడం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("саҳифа бо қатшавӣ"),
            keywords: &["саҳифа", "саҳифа бо қатшавӣ", "қатшавӣ", "ҳуҷҷат"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เอกสารม\u{e49}วนปลาย"),
            keywords: &["เอกสารงอ", "เอกสารม\u{e49}วนปลาย"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("düýrümli sahypa"),
            keywords: &["düýrlemek", "düýrümli sahypa", "resminama", "sahypa"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pepa fafatu"),
            keywords: &["pepa fafatu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kıvrık sayfa"),
            keywords: &["kenarı kıvrılmış sayfa", "kıvrık sayfa", "sayfa"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئەگمە بەت"),
            keywords: &["ئەگمە", "بەت", "پۈتۈك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("сторінка із завитком"),
            keywords: &["документ", "завиток", "сторінка", "сторінка із завитком"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مڑا ہوا صفحہ"),
            keywords: &["دستاویز", "صفحہ", "مڑا ہوا", "مڑا ہوا صفحہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("gajakli sahifa"),
            keywords: &["gajakli", "hujjat", "sahifa"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trang bị quăn"),
            keywords: &["quăn", "trang", "trang bị quăn", "tài liệu"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("këyit wuñ lem muus wi"),
            keywords: &["këyit wuñ lem muus wi", "lemu", "wayndare", "xët"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iphepha elinomjiko"),
            keywords: &["iphepha", "iphepha elinomjiko", "umjiko", "uxwebhu"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("oju-iwe pẹlu lilọ"),
            keywords: &[
                "oju-iwe pẹlu lilọ",
                "ojú ìwé",
                "ìló\u{329}pọ\u{300}",
                "ìwé ìpamó\u{329}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("捲頁"),
            keywords: &["捲", "捲頁", "文件", "頁"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("卷页"),
            keywords: &["卷", "卷页", "文件", "页"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("带卷边的页面"),
            keywords: &["卷边", "带卷边的页面", "文书", "文件", "文档"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("文件檔"),
            keywords: &["文件檔", "文書"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("彎曲嘅文件"),
            keywords: &["彎曲嘅文件", "文件", "文件檔"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ikhasi eligobile"),
            keywords: &["ikhasi", "ikhasi eligobile", "ukugoba", "umbhalo"],
        },
    ],
};
#[doc = "📜"]
pub const SCROLL: crate::Emoji = crate::Emoji {
    glyph: "📜",
    codepoint: "1F4DC",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "scroll",
    group: "Objects",
    subgroup: "book-paper",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("boekrol"),
            keywords: &["boekrol", "perkament"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሽብልል"),
            keywords: &["ሽብልል", "ወረቀት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ورقة ملفوفة"),
            keywords: &["ورقة", "ورقة ملفوفة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9be}কতৰ ন\u{9c1}ৰ\u{9be}"),
            keywords: &["ক\u{9be}কতৰ ন\u{9c1}ৰ\u{9be}", "ক\u{9be}গজ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("lülə halında bükülmüş kağız"),
            keywords: &["kağız", "lülə halında bükülmüş kağız"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("скрутак"),
            keywords: &["папера", "пергамент", "скрутак"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("свитък"),
            keywords: &["свитък", "хартия"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9be}ক\u{9be}নো"),
            keywords: &["ক\u{9be}গজ", "প\u{9be}ক\u{9be}নো"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("parchenn"),
            keywords: &["paperenn", "parchenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("svitak"),
            keywords: &["papir", "svitak"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pergamí"),
            keywords: &["escriptura", "paper", "pell", "pergamí"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏅᏍᎩ"),
            keywords: &["ᎦᏅᏍᎩ", "ᎪᏪᎵ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("svitek"),
            keywords: &["papír", "svitek"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sgrôl"),
            keywords: &["papur", "sgrôl"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("skriftrulle"),
            keywords: &["papir", "skriftrulle"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schriftrolle"),
            keywords: &["Papier", "Schriftrolle"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("περγαμηνή"),
            keywords: &["περγαμηνή", "χαρτί"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("scroll"),
            keywords: &["paper", "scroll"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pergamino"),
            keywords: &["pergamino", "pergamino de papel"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("käsikiri"),
            keywords: &["käsikiri", "paber"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("paper-biribilkia"),
            keywords: &["paper", "paper-biribilkia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("طومار"),
            keywords: &["طومار", "ورق", "کاغذ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kirjakäärö"),
            keywords: &["kirjakäärö", "käärö", "paperi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kalatas"),
            keywords: &["dokumento", "kalatas"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("skriftrulla"),
            keywords: &["bókarrulla", "rulla", "skriftrulla"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("parchemin"),
            keywords: &["papier", "parchemin"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("scrolla"),
            keywords: &["scrolla", "scrolla páipéir"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sgrola"),
            keywords: &["pàipear", "sgrola"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("pergameo"),
            keywords: &["papel", "pergameo", "pergamiño"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}ક\u{acd}રોલ"),
            keywords: &["પ\u{ac7}પર સ\u{acd}ક\u{acd}રોલ", "સ\u{acd}ક\u{acd}રોલ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("gungura"),
            keywords: &["gungura", "takarda"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מגילה"),
            keywords: &["מגילה", "נייר", "קלף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{94d}क\u{94d}रॉल, प\u{947}पर स\u{94d}क\u{94d}रॉल"),
            keywords: &[
                "काग\u{93c}ज\u{93c}",
                "स\u{94d}क\u{94d}रॉल, प\u{947}पर स\u{94d}क\u{94d}रॉल",
                "स\u{94d}क\u{94d}रोल",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("svitak"),
            keywords: &["papir", "svitak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("tekercs"),
            keywords: &["papír", "papírtekercs", "tekercs"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("գալարաթուղթ"),
            keywords: &["գալարաթուղթ", "թուղթ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("gulungan"),
            keywords: &["gulungan", "kertas"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("kpụ\u{300}gharị\u{300}a"),
            keywords: &["akwukwọ", "kpụ\u{300}gharị\u{300}a"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("bókrolla"),
            keywords: &["bókrolla", "pappír"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pergamena"),
            keywords: &["decreto", "laurea", "pergamena", "rotolo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("巻き物"),
            keywords: &["巻き物", "文書", "書類"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("gulungan"),
            keywords: &["gulungan", "kertas"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გრაგნილი"),
            keywords: &["გრაგნილი", "ქაღალდი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("adrurem"),
            keywords: &["adrurem"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бұрама қағаз"),
            keywords: &["бұрама қағаз", "қағаз"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("skriftrulle"),
            keywords: &["papir", "skriftrulle"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "សន\u{17d2}ល\u{17b9}កក\u{17d2}រដាសរម\u{17bc}លព\u{17b8}ខាងលើន\u{17b7}ងខាងក\u{17d2}រោម",
            ),
            keywords: &[
                "ក\u{17d2}រដាស",
                "សន\u{17d2}ល\u{17b9}កក\u{17d2}រដាស",
                "សន\u{17d2}ល\u{17b9}កក\u{17d2}រដាសរម\u{17bc}លព\u{17b8}ខាងលើន\u{17b7}ងខាងក\u{17d2}រោម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{ccd}ಕ\u{ccd}ರಾಲ\u{ccd}"),
            keywords: &[
                "ಡಾಕ\u{ccd}ಯುಮ\u{cc6}ಂಟ\u{ccd}",
                "ಪೇಪರ\u{ccd} ಸ\u{ccd}ಕ\u{ccd}ರಾಲ\u{ccd}",
                "ಸ\u{ccd}ಕ\u{ccd}ರಾಲ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("문서"),
            keywords: &["문서", "스크롤"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("स\u{94d}क\u{94d}रोल"),
            keywords: &["प\u{947}पर", "स\u{94d}क\u{94d}रोल"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ороо"),
            keywords: &["кагаз", "ороо"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Schrëftrullo"),
            keywords: &["Pabeier", "Schrëftrullo"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ມ\u{ec9}ວນເຈ\u{ec9}ຍ"),
            keywords: &["ມ\u{ec9}ວນ", "ມ\u{ec9}ວນເຈ\u{ec9}ຍ", "ເຈ\u{ec9}ຍ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("susuktas lapas"),
            keywords: &["popierius", "susuktas lapas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("papīra tīstoklis"),
            keywords: &["papīra tīstoklis", "papīrs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tuhinga pōkai"),
            keywords: &["pepa", "tuhinga pōkai"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("свиток"),
            keywords: &["свиток", "хартија"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പേപ\u{d4d}പർ സ\u{d4d}ക\u{d4d}രോൾ"),
            keywords: &["പേപ\u{d4d}പർ സ\u{d4d}ക\u{d4d}രോൾ", "സ\u{d4d}ക\u{d4d}രോൾ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хуйлмал"),
            keywords: &["хуйлмал", "цаас"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{94d}र\u{94d}क\u{94d}रोल"),
            keywords: &["कागद", "स\u{94d}क\u{94d}रोल", "स\u{94d}र\u{94d}क\u{94d}रोल"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("skrol"),
            keywords: &["kertas", "skrol"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("skrollja"),
            keywords: &["karta", "skrollja"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စက\u{1039}က\u{1030}လ\u{102d}ပ\u{103a}"),
            keywords: &[
                "စက\u{1039}က\u{1030}လ\u{102d}ပ\u{103a}",
                "စာရ\u{103d}က\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("pergamentrull"),
            keywords: &[
                "papir",
                "papirrull",
                "papyrus",
                "pergament",
                "pergamentrull",
                "rull",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}क\u{94d}रोल"),
            keywords: &["पाना", "स\u{94d}क\u{94d}रोल"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("rol"),
            keywords: &["papierrol", "rol"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("pergamentrull"),
            keywords: &[
                "papir",
                "papirrull",
                "papyrus",
                "pergament",
                "pergamentrull",
                "rull",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b4d}କ\u{b4d}ରୋଲ\u{b4d}"),
            keywords: &[
                "କ\u{b3e}ଗଜ ସ\u{b4d}କ\u{b4d}ରୋଲ\u{b4d}",
                "ସ\u{b4d}କ\u{b4d}ରୋଲ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਕਰ\u{a4b}ਲ"),
            keywords: &["ਪ\u{a47}ਪਰ", "ਸਕਰ\u{a4b}ਲ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سکرول"),
            keywords: &["سکرول", "کاغذ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Skrol"),
            keywords: &["Pépa", "Skrol"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zwój"),
            keywords: &["edykt", "pergamin", "pismo", "zwój"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("اڼه اړول"),
            keywords: &["اڼه اړول"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pergaminho"),
            keywords: &["pergaminho", "rolo de papel"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["papel", "pergaminho"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("suchuririy"),
            keywords: &["suchuririy"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pergament"),
            keywords: &["hârtie", "pergament", "rulou", "sul"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-665"),
            keywords: &["E10-665"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("свиток"),
            keywords: &["бумага", "свиток"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("kunyereza"),
            keywords: &["kunyereza", "urupapuro"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ويڙهيل"),
            keywords: &["ويڙهيل", "ڪاغذ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dca}ක\u{dca}\u{200d}රොල\u{dca}"),
            keywords: &["කඩද\u{dcf}ස\u{dd2}ය", "ස\u{dca}ක\u{dca}\u{200d}රොල\u{dca}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zvitok"),
            keywords: &["papier", "zvitok"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zvitek"),
            keywords: &["papir", "zvitek"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("duuban"),
            keywords: &["duuban", "warqad"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("dorëshkrim i mbledhur rrotull"),
            keywords: &["dorëshkrim i mbledhur rrotull", "letër"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("свитак"),
            keywords: &["пaпир", "свитак"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("svitak"),
            keywords: &["papir", "svitak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("bokrulle"),
            keywords: &["bokrulle", "pergament", "rulle"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("hati ya kukunja kwa kuviringisha"),
            keywords: &["hati ya kukunja kwa kuviringisha", "karatasi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சுருள\u{bcd}"),
            keywords: &[
                "சுருட\u{bcd}டு",
                "சுருள\u{bcd}",
                "பேப\u{bcd}பரை சுருட\u{bcd}டு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c4d}క\u{c4d}ర\u{c4b}ల\u{c4d}"),
            keywords: &[
                "ప\u{c47}పర\u{c4d}",
                "మడవడం",
                "స\u{c4d}క\u{c4d}ర\u{c4b}ల\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("навори ҳаракат"),
            keywords: &["навори ҳаракат", "қоғаз"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ม\u{e49}วนกระดาษ"),
            keywords: &["กระดาษ", "ม\u{e49}วนกระดาษ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("düýrlem"),
            keywords: &["düýrlem", "kagyz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("takainga tohi"),
            keywords: &["takainga tohi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("parşömen"),
            keywords: &["kağıt parşömen", "parşömen"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سىيرىش"),
            keywords: &["سىيرىش", "قەغەز"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("сувій"),
            keywords: &["папір", "сувій"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اسکرول"),
            keywords: &["اسکرول", "صفحہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("o‘ralgan xat"),
            keywords: &["o‘ralgan xat", "qog‘oz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cuộn sách"),
            keywords: &["cuộn giấy", "cuộn sách", "giấy"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("tawal"),
            keywords: &["këyit", "tawal"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("skrola"),
            keywords: &["iphepha", "skrola"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("gbéjáde"),
            keywords: &["gbéjáde", "pépà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("滾動"),
            keywords: &["滾動", "紙"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("滚动"),
            keywords: &["滚动", "纸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("卷轴"),
            keywords: &["卷轴", "画卷", "纸", "纸卷", "羊皮纸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("捲軸"),
            keywords: &["捲軸", "文書"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["捲軸", "書卷", "羊皮紙"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umqulu"),
            keywords: &["ikhasi", "umqulu"],
        },
    ],
};
#[doc = "📄"]
pub const PAGE_FACING_UP: crate::Emoji = crate::Emoji {
    glyph: "📄",
    codepoint: "1F4C4",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "page facing up",
    group: "Objects",
    subgroup: "book-paper",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("bladsy na bo"),
            keywords: &["bladsy", "bladsy na bo", "dokument", "papier"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወደ ላይ የተቀመጠ ወረቀት"),
            keywords: &["ሰነድ", "ወደ ላይ የተቀመጠ ወረቀት", "ገጽ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مستند"),
            keywords: &["صفحة", "صفحة بوجه لأعلى", "مستند", "وجه لأعلى"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ঊৰ\u{9cd}ধম\u{9c1}খী প\u{9c3}ষ\u{9cd}ঠ\u{9be}"),
            keywords: &[
                "ঊৰ\u{9cd}ধম\u{9c1}খী প\u{9c3}ষ\u{9cd}ঠ\u{9be}",
                "নথি",
                "প\u{9c3}ষ\u{9cd}ঠ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("üzüyuxarı səhifə"),
            keywords: &["səhifə", "sənəd", "üzüyuxarı səhifə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("старонка"),
            keywords: &["аркуш", "дакумент", "ліст", "старонка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Страница с лицето нагоре"),
            keywords: &["Страница с лицето нагоре", "документ", "страница"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9c3}ষ\u{9cd}ঠ\u{9be}টির ম\u{9c1}খ উপরের দিকে"),
            keywords: &[
                "নথি",
                "প\u{9c3}ষ\u{9cd}ঠ\u{9be}",
                "প\u{9c3}ষ\u{9cd}ঠ\u{9be}টির ম\u{9c1}খ উপরের দিকে",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pajenn"),
            keywords: &["pajenn", "teul"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("stranica okrenuta prema gore"),
            keywords: &["dokument", "stranica", "stranica okrenuta prema gore"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pàgina"),
            keywords: &["amunt", "document", "pàgina", "pàgina cap amunt"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎦᏅᏓᏛ ᎤᎧᏛ ᎦᎸᎳᏗ"),
            keywords: &["ᎤᎦᏅᏓᏛ ᎤᎧᏛ ᎦᎸᎳᏗ", "ᎤᎦᏅᏓᏛᎢ", "ᎪᏪᎳᏅᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("stránka lícem nahoru"),
            keywords: &["dokument", "strana", "stránka lícem nahoru"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("tudalen yn wynebu i fyny"),
            keywords: &["dogfen", "tudalen", "tudalen yn wynebu i fyny"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("dokument"),
            keywords: &["dokument", "side"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Vorderseite eines Blattes"),
            keywords: &["Dokument", "Papier", "Seite", "Vorderseite eines Blattes"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("όρθια σελίδα"),
            keywords: &["έγγραφο", "σελίδα", "όρθια σελίδα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("page facing up"),
            keywords: &["document", "page", "page facing up"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("página hacia arriba"),
            keywords: &["anverso", "documento", "página", "página hacia arriba"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("documento"),
            keywords: &["documento", "frente", "hoja", "página"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("página viendo hacia arriba"),
            keywords: &["documento", "página", "página viendo hacia arriba"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("paberilehe eestvaade"),
            keywords: &["dokument", "leht", "paberilehe eestvaade"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gora begira dagoen orria"),
            keywords: &["dokumentu", "gora begira dagoen orria", "orri"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("صفحه\u{654} روبه\u{200c}بالا"),
            keywords: &["سند", "صفحه", "صفحه\u{654} روبه\u{200c}بالا"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("sivu"),
            keywords: &["asiakirja", "dokumentti", "sivu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pahinang nakaharap"),
            keywords: &["dokumento", "pahina", "pahinang nakaharap"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("pappír sum vendur uppeftir"),
            keywords: &[
                "bræv",
                "pappír",
                "pappír sum vendur uppeftir",
                "prógv",
                "skjal",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("page"),
            keywords: &["document", "page"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("leathanach iompaithe suas"),
            keywords: &[
                "aghaidh suas",
                "doiciméad",
                "leathanach",
                "leathanach aghaidh suas",
                "leathanach iompaithe suas",
                "leathanach le aghaidh aníos",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("duilleag le h-aghaidh os a cionn"),
            keywords: &[
                "duilleag",
                "duilleag le h-aghaidh os a cionn",
                "sgrìobhainn",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("páxina cunha esquina dobrada"),
            keywords: &["anverso", "documento", "páxina cunha esquina dobrada"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચત\u{acd}ત\u{ac1} પ\u{ac3}ષ\u{acd}ઠ"),
            keywords: &[
                "ચત\u{acd}ત\u{ac1}",
                "દસ\u{acd}તાવ\u{ac7}જ",
                "પ\u{ac3}ષ\u{acd}ઠ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("shafi mai kallon sama"),
            keywords: &["daftari", "shafi", "shafi mai kallon sama"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("דף עם הפנים כלפי מעלה"),
            keywords: &["דף", "דף עם הפנים כלפי מעלה", "מסמך"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ऊपरी प\u{943}ष\u{94d}ठ"),
            keywords: &[
                "ऊपरी प\u{943}ष\u{94d}ठ",
                "दस\u{94d}ताव\u{947}ज\u{93c}",
                "प\u{943}ष\u{94d}ठ",
                "सामन\u{947} की ओर प\u{943}ष\u{94d}ठ",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("stranica okrenuta prema gore"),
            keywords: &["dokument", "stranica", "stranica okrenuta prema gore"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("felfelé néző oldal"),
            keywords: &["dokumentum", "felfelé néző oldal", "lap"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("էջ"),
            keywords: &["էջ", "փաստաթութղ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("halaman tampak depan"),
            keywords: &["dokumen", "halaman", "halaman tampak depan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihuakwụkwọ chewara ihu elu"),
            keywords: &["dọkụmenti", "ihuakwụkwọ", "ihuakwụkwọ chewara ihu elu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("skjal snýr upp"),
            keywords: &["skjal snýr upp", "snýr upp", "síða", "síða snýr upp"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pagina"),
            keywords: &["documento", "pagina"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ページ"),
            keywords: &["ページ", "文書", "書類"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("lembaran kertas katon ngarep"),
            keywords: &["dhokumen", "lembaran", "lembaran kertas katon ngarep"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გვერდი პირით ზემოთ"),
            keywords: &["გვერდი", "გვერდი პირით ზემოთ", "დოკუმენტი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("asebter"),
            keywords: &["asebter"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жоғары қарап тұрған бет"),
            keywords: &["бет", "жоғары қарап тұрған бет", "құжат"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("dokument"),
            keywords: &["dokument", "side"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សន\u{17d2}ល\u{17b9}កក\u{17d2}រដាសផ\u{17d2}ងារ"),
            keywords: &[
                "ក\u{17d2}រដាស",
                "សន\u{17d2}ល\u{17b9}កក\u{17d2}រដាស",
                "សន\u{17d2}ល\u{17b9}កក\u{17d2}រដាសផ\u{17d2}ងារ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮೇಲ\u{ccd}ಮುಖ ಪುಟ"),
            keywords: &["ಎದುರ\u{cbf}ಸುವ", "ಪುಟ", "ಮೇಲ\u{ccd}ಮುಖ ಪುಟ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("오른쪽 모서리가 접힌 문서"),
            keywords: &["오른쪽 모서리가 접힌 문서", "페이지"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("वयर पळोवपी पान"),
            keywords: &["दस\u{94d}ताव\u{947}ज", "पान", "वयर पळोवपी पान"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("өйдө караган барак"),
            keywords: &["барак", "документ", "өйдө караган барак"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("bedréckt Säit"),
            keywords: &["Dokument", "Säit", "bedréckt Säit"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຈ\u{ec9}ຍປ\u{eb5}\u{ec9}ນໜ\u{ec9}າຂ\u{eb6}\u{ec9}ນ"),
            keywords: &[
                "ປ\u{eb5}\u{ec9}ນໜ\u{ec9}າຂ\u{eb6}\u{ec9}ນ",
                "ເຈ\u{ec9}ຍ",
                "ເຈ\u{ec9}ຍປ\u{eb5}\u{ec9}ນໜ\u{ec9}າຂ\u{eb6}\u{ec9}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("puslapis viršutine puse"),
            keywords: &["dokumentas", "puslapis", "puslapis viršutine puse"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("papīra lapa"),
            keywords: &["dokuments", "papīra lapa", "papīrs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("whārangi anga ake"),
            keywords: &["tuhinga", "whārangi", "whārangi anga ake"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("страница свртена нагоре"),
            keywords: &["документ", "страница", "страница свртена нагоре"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഒര\u{d41} കോണിൽ മടക\u{d4d}ക\u{d41}ള\u{d4d}ള പേജ\u{d4d}"),
            keywords: &[
                "ഒര\u{d41} കോണിൽ മടക\u{d4d}ക\u{d41}ള\u{d4d}ള പേജ\u{d4d}",
                "ഡോക\u{d4d}യ\u{d41}മെന\u{d4d}റ\u{d4d}",
                "മ\u{d42}ല മടക\u{d4d}കിയ പേജ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цаас"),
            keywords: &["бичиг баримт", "цаас"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{941}ढील बाज\u{942} समोर असणार\u{947} प\u{943}ष\u{94d}\u{200d}ठ"),
            keywords: &[
                "दस\u{94d}तऐवज",
                "प\u{941}ढील बाज\u{942} समोर असणार\u{947} प\u{943}ष\u{94d}\u{200d}ठ",
                "प\u{941}ढील बाज\u{942} समोर असल\u{947}ल\u{947} प\u{941}स\u{94d}तक",
                "प\u{943}ष\u{94d}ठ",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("halaman menghadap atas"),
            keywords: &["dokumen", "halaman", "halaman menghadap atas"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("paġna wiċċha ’l fuq"),
            keywords: &["dokument", "paġna", "paġna wiċċha ’l fuq"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မြင\u{103a}နေရသည\u{1037}\u{103a} စာမျက\u{103a}န\u{103e}ာ"),
            keywords: &[
                "စာရ\u{103d}က\u{103a}",
                "စာရ\u{103d}က\u{103a}စာတမ\u{103a}း",
                "မြင\u{103a}နေရသည\u{1037}\u{103a} စာမျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("side som vender opp"),
            keywords: &["ark", "papir", "side", "side som vender opp"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("माथि फर\u{94d}क\u{947}को पाना"),
            keywords: &["कागजात", "पाना", "माथि फर\u{94d}क\u{947}को पाना"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("pagina met bovenzijde omhoog"),
            keywords: &["document", "pagina", "pagina met bovenzijde omhoog"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("side som vender opp"),
            keywords: &["ark", "papir", "side", "side som vender opp"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଉପରକ\u{b41} ମ\u{b41}ହ\u{b01} କର\u{b3f}ଥ\u{b3f}ବ\u{b3e} ପ\u{b43}ଷ\u{b4d}ଠ\u{b3e}",
            ),
            keywords: &[
                "ଉପରକ\u{b41} ମ\u{b41}ହ\u{b01} କର\u{b3f}ଥ\u{b3f}ବ\u{b3e} ପ\u{b43}ଷ\u{b4d}ଠ\u{b3e}",
                "ଉପର\u{b41} ମୋଡ\u{b3c}\u{b3f} ହୋଇଥ\u{b3f}ବ\u{b3e}",
                "ଉପର\u{b41} ମୋଡ\u{b3c}\u{b3f} ହୋଇଥ\u{b3f}ବ\u{b3e} ପ\u{b43}ଷ\u{b4d}ଠ\u{b3e}",
                "ଡକ\u{b4d}ୟ\u{b41}ମେଣ\u{b4d}ଟ\u{b4d}",
                "ପ\u{b43}ଷ\u{b4d}ଠ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਉ\u{a71}ਤਲਾ ਪ\u{a70}ਨਾ"),
            keywords: &[
                "ਉ\u{a71}ਤਲਾ ਪ\u{a70}ਨਾ",
                "ਉ\u{a71}ਤਲਾ ਹਿ\u{a71}ਸਾ",
                "ਦਸਤਾਵ\u{a47}ਜ\u{a3c}",
                "ਪ\u{a70}ਨਾ",
                "ਪ\u{a70}ਨ\u{a47} ਦਾ ਉ\u{a71}ਤਲਾ ਹਿ\u{a71}ਸਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("اوتلا سامنا کردا صفحہ"),
            keywords: &["اوتلا سامنا کردا صفحہ", "دستاویز", "صفحہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pej Wé De Fés Ọp"),
            keywords: &["Pej", "Pej Wé De Fés Ọp", "Pépa"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("strona"),
            keywords: &["kartka", "maszynopis", "pismo", "strona"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پاڼه سره مخ کړي"),
            keywords: &["سند", "پاڼه", "پاڼه سره مخ کړي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("página voltada para cima"),
            keywords: &[
                "documento",
                "parte da frente para cima",
                "página",
                "página com a parte da frente para cima",
                "página voltada para cima",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("página virada para cima"),
            keywords: &["documento", "página", "página virada para cima"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("hanaqman rapi"),
            keywords: &["hanaqman rapi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pagină cu fața în sus"),
            keywords: &["document", "pagină", "pagină cu fața în sus"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-641"),
            keywords: &["E10-641"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("страница"),
            keywords: &["вертикально", "лист", "страница"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("paji itangiriye hejuru"),
            keywords: &["inyandiko", "ipaji", "paji itangiriye hejuru"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مٿي منهن ڪندڙ صفحو"),
            keywords: &["دستاويز", "صفحو", "مٿي منهن ڪندڙ صفحو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඉහළට ම\u{dd4}හ\u{dd4}ණත ඇත\u{dd2} ප\u{dd2}ට\u{dd4}ව"),
            keywords: &[
                "ඉහළට ම\u{dd4}හ\u{dd4}ණත ඇත\u{dd2} ප\u{dd2}ට\u{dd4}ව",
                "ප\u{dd2}ට\u{dd4}ව",
                "ලේඛනය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("líce stránky"),
            keywords: &["dokument", "líce stránky", "stránka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("list s prikazano popisano stranjo"),
            keywords: &["dokument", "list s prikazano popisano stranjo", "stran"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("bog kor u jeeda"),
            keywords: &["bog", "bog kor u jeeda", "dokumenti"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("faqe e drejtuar lart"),
            keywords: &["dokument", "faqe", "faqe e drejtuar lart"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("страница окренута нагоре"),
            keywords: &["дoкумeнт", "стрaницa", "страница окренута нагоре"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("stranica okrenuta nagore"),
            keywords: &["dokument", "stranica", "stranica okrenuta nagore"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("sida med text uppåt"),
            keywords: &["dokument", "sida", "sida med text uppåt", "text uppåt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ukurasa unaotazama juu"),
            keywords: &["hati", "ukurasa", "ukurasa unaotazama juu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("நேர\u{bcd} ஆவணம\u{bcd}"),
            keywords: &["திறந\u{bcd}த ஆவணம\u{bcd}", "நேர\u{bcd} ஆவணம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c48}న మడ\u{c3f}చ\u{c3f}న ప\u{c47}జ\u{c40}"),
            keywords: &[
                "ప\u{c47}జ\u{c40} మడవడం",
                "ప\u{c47}పర\u{c4d}",
                "ప\u{c48}న మడ\u{c3f}చ\u{c3f}న ప\u{c47}జ\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("саҳифа бо рӯйгардонкунӣ"),
            keywords: &["саҳифа", "саҳифа бо рӯйгардонкунӣ", "ҳуҷҷат"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เอกสาร"),
            keywords: &["หน\u{e49}า", "เอกสาร"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("açyk sahypa"),
            keywords: &["açyk sahypa", "resminama", "sahypa"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pepa hanga hake"),
            keywords: &["pepa hanga hake"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yüzü yukarıda sayfa"),
            keywords: &[
                "doküman",
                "sayfa",
                "yüzü yukarıda sayfa",
                "ön yüz",
                "ön yüzü görünen sayfa",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئۈستىگە قارىغان بەت"),
            keywords: &["ئۈستىگە قارىغان بەت", "قەغەز", "پۈتۈك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("сторінка лицевою стороною"),
            keywords: &["документ", "сторінка", "сторінка лицевою стороною"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("صفحے کا سامنے والا حصہ"),
            keywords: &["سامنے", "صفحہ", "صفحے کا سامنے والا حصہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("oldiga qarab turgan sahifa"),
            keywords: &["hujjat", "oldiga qarab turgan sahifa", "sahifa"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trang hướng lên trên"),
            keywords: &["trang", "trang hướng lên trên", "tài liệu"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam gu téen"),
            keywords: &["kanam gu téen", "wayndare", "xët"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iphepha elijonge phezulu"),
            keywords: &["iphepha", "iphepha elijonge phezulu", "uxwebhu"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("oju-iwe wa loke"),
            keywords: &[
                "dọ\u{301}kúmé\u{329}ẹ\u{300}tì",
                "oju-iwe wa loke",
                "ojú ìwé",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("頁面向上"),
            keywords: &["文件", "頁", "頁面向上"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("页面向上"),
            keywords: &["文件", "页", "页面向上"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("文件"),
            keywords: &["文书", "文件", "文档"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("文件"),
            keywords: &["文件", "文書", "文檔"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("文件正面"),
            keywords: &["文件", "文件正面", "文書", "文檔"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ikhasi elibheke phezulu"),
            keywords: &["ikhasi", "ikhasi elibheke phezulu", "umbhalo"],
        },
    ],
};
#[doc = "📰"]
pub const NEWSPAPER: crate::Emoji = crate::Emoji {
    glyph: "📰",
    codepoint: "1F4F0",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "newspaper",
    group: "Objects",
    subgroup: "book-paper",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("koerant"),
            keywords: &["koerant", "nuus"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጋዜጣ"),
            keywords: &["ወረቀት", "ዜና", "ጋዜጣ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("جريدة"),
            keywords: &["أخبار", "جريدة", "صحيفة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ব\u{9be}তৰিক\u{9be}কত"),
            keywords: &["ক\u{9be}কত", "ব\u{9be}তৰি", "ব\u{9be}তৰিক\u{9be}কত"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qəzet"),
            keywords: &["kağız", "qəzet", "xəbər"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("газета"),
            keywords: &["газета", "навіны", "папера", "прэса"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("вестник"),
            keywords: &["вестник", "новини"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("সংব\u{9be}দপত\u{9cd}র"),
            keywords: &["ক\u{9be}গজ", "সংব\u{9be}দ", "সংব\u{9be}দপত\u{9cd}র"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kazetenn"),
            keywords: &["journal", "kazetenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("novine"),
            keywords: &["novine", "novosti", "papir"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("diari"),
            keywords: &["diari", "notícies"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎦᏃᏣᎳᏅᎢ"),
            keywords: &["ᎪᏪᎵ", "ᏗᎦᏃᏣᎳᏅᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("noviny"),
            keywords: &["noviny", "papír", "tisk", "zprávy"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("papur newydd"),
            keywords: &["newyddion", "papur", "papur newydd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("avis"),
            keywords: &["avis", "nyheder"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Zeitung"),
            keywords: &["Nachrichten", "Zeitung"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("εφημερίδα"),
            keywords: &["ειδήσεις", "εφημερίδα", "χαρτί"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("newspaper"),
            keywords: &["news", "newspaper", "paper"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("periódico"),
            keywords: &["diario", "periódico"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["diario", "noticias", "periódico"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("ajaleht"),
            keywords: &["ajaleht", "uudised"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("egunkaria"),
            keywords: &["albisteak", "egunkari", "egunkaria"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("روزنامه"),
            keywords: &["اخبار", "روزنامه", "صفحه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("sanomalehti"),
            keywords: &["lehti", "sanomalehti", "uutiset"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("dyaryo"),
            keywords: &["balita", "dyaryo", "papel"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("tíðindablað"),
            keywords: &["blað", "nýggjheitir", "tíðindablað", "tíðindi"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("journal"),
            keywords: &["actualités", "journal"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("nuachtán"),
            keywords: &["nuacht", "nuachtán", "páipéar nuachta"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("pàipear-naidheachd"),
            keywords: &[
                "naidheachd",
                "naidheachdan",
                "pàipear",
                "pàipear-naidheachd",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("xornal"),
            keywords: &["artigos", "diario", "noticias", "xornal"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સમાચારપત\u{acd}ર, છાપ\u{ac1}\u{a82}"),
            keywords: &[
                "કાગળ",
                "સમાચાર",
                "સમાચારપત\u{acd}ર",
                "સમાચારપત\u{acd}ર, છાપ\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("jarida"),
            keywords: &["jarida", "labarai", "takarda"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עיתון"),
            keywords: &["חדשות", "עיתון"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("समाचारपत\u{94d}र"),
            keywords: &["अख\u{93c}बार", "प\u{947}पर", "समाचारपत\u{94d}र"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("novine"),
            keywords: &["novine", "papir", "vijesti"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("újság"),
            keywords: &["újság", "újságos"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("լրագիր"),
            keywords: &["թերթ", "լրագիր", "նորություններ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("koran"),
            keywords: &["berita", "kertas", "koran"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akwụkwọ akụkọ"),
            keywords: &["akwụkwọ", "akụkọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("dagblað"),
            keywords: &["blað", "dagblað", "fréttir"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("quotidiano"),
            keywords: &["giornale", "quotidiano"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("新聞"),
            keywords: &["ニュース", "新聞", "新聞紙"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("koran"),
            keywords: &["kabar", "kertas", "koran"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გაზეთი"),
            keywords: &["ახალი ამბები", "გაზეთი", "ქაღალდი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("aɣmis"),
            keywords: &["aɣmis"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("газет"),
            keywords: &["газет", "жаңалықтар", "қағаз"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("avis"),
            keywords: &["avis", "nyheder"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កាសែត"),
            keywords: &["កាសែត"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ವೃತ\u{ccd}ತ ಪತ\u{ccd}ರ\u{cbf}ಕ\u{cc6}"),
            keywords: &[
                "ಕಾಗದ",
                "ವೃತ\u{ccd}ತ ಪತ\u{ccd}ರ\u{cbf}ಕ\u{cc6}",
                "ಸುದ\u{ccd}ದ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("신문"),
            keywords: &["소식", "신문", "정보"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("खबरापत\u{94d}र"),
            keywords: &["खबरापत\u{94d}र", "खबरो", "प\u{947}पर"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("гезит"),
            keywords: &["гезит", "жаңылыктар"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Zeitung"),
            keywords: &["Neiegkeeten", "Pabeier", "Zeitung"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{eb1}ງສ\u{eb7}ພ\u{eb4}ມ"),
            keywords: &["ຂ\u{ec8}າວ", "ໜ\u{eb1}ງສ\u{eb7}ພ\u{eb4}ມ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("laikraštis"),
            keywords: &["laikraštis", "naujienos", "popierius"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("avīze"),
            keywords: &["avīze", "laikraksts", "ziņas"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("nūpepa"),
            keywords: &["nūpepa", "pepa", "rongo"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("весник"),
            keywords: &["весник", "новина"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പത\u{d4d}രം"),
            keywords: &[
                "ന\u{d4d}യ\u{d42}സ\u{d4d} പേപ\u{d4d}പർ",
                "പത\u{d4d}രം",
                "വർത\u{d4d}തമ\u{d3e}നപത\u{d4d}രം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("сонин"),
            keywords: &["мэдээ", "сонин", "цаас"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("वर\u{94d}तमानपत\u{94d}र"),
            keywords: &[
                "बातम\u{94d}या",
                "वर\u{94d}तमानपत\u{94d}र",
                "व\u{943}त\u{94d}तपत\u{94d}र",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("akhbar"),
            keywords: &["akhbar", "berita", "kertas"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("gazzetta"),
            keywords: &["gazzetta", "l-aħbarijiet", "tal-karta"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("သတင\u{103a}းစာ"),
            keywords: &["သတင\u{103a}း", "သတင\u{103a}းစာ"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("avis"),
            keywords: &["avis", "nyheter", "publikasjon"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("समाचारपत\u{94d}र"),
            keywords: &["पत\u{94d}र", "समाचार", "समाचारपत\u{94d}र"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("krant"),
            keywords: &["krant", "nieuws", "nieuwsblad"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("avis"),
            keywords: &["avis", "nyhende", "publikasjon"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସମ\u{b4d}ବ\u{b3e}ଦପତ\u{b4d}ର"),
            keywords: &[
                "ନ\u{b4d}ୟ\u{b41}ଜ\u{b4d}",
                "ନ\u{b4d}ୟ\u{b41}ଜ\u{b4d}\u{200c}ପେପର\u{b4d}",
                "ପେପର\u{b4d}",
                "ସମ\u{b4d}ବ\u{b3e}ଦପତ\u{b4d}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਅਖ\u{a3c}ਬਾਰ"),
            keywords: &["ਅਖਬਾਰ", "ਅਖ\u{a3c}ਬਾਰ", "ਖ\u{a3c}ਬਰਾ\u{a02}", "ਪ\u{a47}ਪਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("اخبار"),
            keywords: &["اخبار", "خبراں", "کاغذ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Niúzpépa"),
            keywords: &["Niuz", "Niúzpépa", "Pépa"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("gazeta"),
            keywords: &["gazeta", "wiadomości"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ورځپاڼې"),
            keywords: &["خبرونه", "ورځپاڼه", "ورځپاڼې", "کاغذ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("jornal"),
            keywords: &["jornal", "notícias"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["jornal", "notícias", "papel"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("periodico"),
            keywords: &["periodico"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ziar"),
            keywords: &["hârtie", "publicație", "ziar", "știri"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-685"),
            keywords: &["E10-685"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("газета"),
            keywords: &["газета", "известия", "издание", "новости", "печать"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikinyamakuru"),
            keywords: &["amakuru", "ikinyamakuru", "urupapuro"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اخبار"),
            keywords: &["اخبار", "خبرون", "پنو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd4}වත\u{dca} පත"),
            keywords: &[
                "පත\u{dca}\u{200d}රය",
                "ප\u{dd4}වත\u{dca}",
                "ප\u{dd4}වත\u{dca} පත",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("noviny"),
            keywords: &["noviny", "správy"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("časopis"),
            keywords: &["novice", "časopis"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("jaraaid"),
            keywords: &["jaraaid", "war", "warqad"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gazetë"),
            keywords: &["gazetë", "lajme", "letër"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("новине"),
            keywords: &["вести", "новине", "папир"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["новине"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("novine"),
            keywords: &["novine", "papir", "vesti"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["novine"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tidning"),
            keywords: &["nyheter", "tidning"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("gazeti"),
            keywords: &["gazeti", "habari", "karatasi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("செய\u{bcd}தித\u{bcd}த\u{bbe}ள\u{bcd}"),
            keywords: &[
                "செய\u{bcd}திகள\u{bcd}",
                "செய\u{bcd}தித\u{bcd}த\u{bbe}ள\u{bcd}",
                "நியூஸ\u{bcd} பேப\u{bcd}பர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వ\u{c3e}ర\u{c4d}త\u{c3e}పత\u{c4d}ర\u{c3f}క"),
            keywords: &[
                "న\u{c4d}యూస\u{c4d}\u{200c}ప\u{c47}పర\u{c4d}",
                "పత\u{c4d}ర\u{c3f}క",
                "వ\u{c3e}ర\u{c4d}త\u{c3e}పత\u{c4d}ర\u{c3f}క",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("газета"),
            keywords: &["газета", "хабарҳо", "қоғаз"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e31}งส\u{e37}อพ\u{e34}มพ\u{e4c}"),
            keywords: &["ข\u{e48}าวสาร", "หน\u{e31}งส\u{e37}อพ\u{e34}มพ\u{e4c}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gazet"),
            keywords: &["gazet", "habar", "kagyz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("nusipepa"),
            keywords: &["nusipepa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("gazete"),
            keywords: &["gazete", "haber", "kâğıt"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("گېزىت"),
            keywords: &["خەۋەر", "قەغەز", "گېزىت"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("газета"),
            keywords: &["газета", "новини", "папір"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اخبار"),
            keywords: &["اخبار", "اطلاع", "خبر", "معلومات"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("gazeta"),
            keywords: &["gazeta", "qog‘oz", "yangiliklar"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("báo"),
            keywords: &["báo", "tạp chí"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("këyitu xibaar"),
            keywords: &["këyit", "këyitu xibaar", "xibaar"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iphephandaba"),
            keywords: &["iindaba", "iphepha", "iphephandaba"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ìwé ìròyìn"),
            keywords: &["pépà", "ìròyìn", "ìwé ìròyìn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("報紙"),
            keywords: &["報紙", "新聞", "紙"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("报纸"),
            keywords: &["报纸", "新闻", "纸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("报纸"),
            keywords: &["报纸", "报道", "新闻", "看报", "读报"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("報紙"),
            keywords: &["報紙", "新聞"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iphephandaba"),
            keywords: &["iphepha", "iphephandaba", "izindaba"],
        },
    ],
};
#[doc = "🗞\u{fe0f}"]
pub const ROLLED_UP_NEWSPAPER: crate::Emoji = crate::Emoji {
    glyph: "🗞\u{fe0f}",
    codepoint: "1F5DE FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "rolled-up newspaper",
    group: "Objects",
    subgroup: "book-paper",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🗞",
        codepoint: "1F5DE",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "rolled-up newspaper",
        group: "Objects",
        subgroup: "book-paper",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("opgerolde koerant"),
            keywords: &["gerol", "koerant", "nuus", "opgerolde koerant"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የተጠቀለለ ጋዜጣ"),
            keywords: &["ወረቀት", "ዜና", "የተጠቀለለ ጋዜጣ", "ጋዜጣ", "ጥቅል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("صحيفة مطوية"),
            keywords: &["أخبار", "جريدة", "صحيفة", "مطوية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ন\u{9c1}ৰিয\u{9bc}\u{9be}ই থোৱ\u{9be} ব\u{9be}তৰিক\u{9be}কত"),
            keywords: &[
                "ক\u{9be}কত",
                "ন\u{9c1}ৰিয\u{9bc}\u{9be}ই থোৱ\u{9be}",
                "ন\u{9c1}ৰিয\u{9bc}\u{9be}ই থোৱ\u{9be} ব\u{9be}তৰিক\u{9be}কত",
                "ব\u{9be}তৰি",
                "ব\u{9be}তৰিক\u{9be}কত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("bükülmüş qəzet"),
            keywords: &["burulmuş", "bükülmüş qəzet", "kağız", "qəzet", "xəbər"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("скручаная газета"),
            keywords: &["газета", "навіны", "папера", "скручаная"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Навит на руло вестник"),
            keywords: &["Навит на руло вестник", "вестник", "новини", "руло"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("রোল কর\u{9be} সংব\u{9be}দপত\u{9cd}র"),
            keywords: &[
                "ক\u{9be}গজ",
                "প\u{9be}ক\u{9be}নো",
                "রোল কর\u{9be} সংব\u{9be}দপত\u{9cd}র",
                "সংব\u{9be}দ",
                "সংব\u{9be}দপত\u{9cd}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kazetenn rollet"),
            keywords: &["journal", "kazetenn", "kazetenn rollet"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("smotane novine"),
            keywords: &["novine", "novosti", "papir", "smotane novine", "smotano"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("diari enrotllat"),
            keywords: &["diari", "enrotllat"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏐᏆᎴᏢᎢ-ᏗᎦᏃᏣᎳᏅᎢ ᎪᏪᎵ"),
            keywords: &[
                "ᎦᏐᏆᎴᏢᎢ",
                "ᎦᏐᏆᎴᏢᎢ-ᏗᎦᏃᏣᎳᏅᎢ ᎪᏪᎵ",
                "ᎪᏪᎵ",
                "ᏗᎦᏃᏣᎳᏅᎢ",
                "ᏗᎦᏃᏣᎳᏅᎢᎪᏪᎵ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("srolované noviny"),
            keywords: &["noviny", "papír", "srolované", "stočené", "tisk", "zprávy"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("papur newydd wedi’i rolio"),
            keywords: &[
                "newyddion",
                "papur",
                "papur newydd",
                "papur newydd wedi’i rolio",
                "wedi’i rolio",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sammenrullet avis"),
            keywords: &["avis", "nyheder", "sammenrullet"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("zusammengerollte Zeitung"),
            keywords: &["Zeitung", "zusammengerollt", "zusammengerollte Zeitung"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τυλιγμένη εφημερίδα"),
            keywords: &[
                "ειδήσεις",
                "εφημερίδα",
                "τυλιγμένη εφημερίδα",
                "τυλιγμένο",
                "χαρτί",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("rolled-up newspaper"),
            keywords: &[
                "news",
                "newspaper",
                "paper",
                "rolled",
                "rolled-up newspaper",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("periódico enrollado"),
            keywords: &["noticias", "papel", "periódico", "periódico enrollado"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["diario", "noticias", "periódico", "periódico enrollado"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("rullikeeratud ajaleht"),
            keywords: &["ajaleht", "rull", "rullikeeratud ajaleht", "uudised"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("egunkari bildua"),
            keywords: &["albisteak", "bildu", "egunkari", "egunkari bildua"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("رول روزنامه"),
            keywords: &[
                "اخبار",
                "رل",
                "روزنامه",
                "روزنامه\u{654} لوله\u{200c}شده",
                "رول روزنامه",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("sanomalehti rullalla"),
            keywords: &["lehti", "rulla", "sanomalehti rullalla", "uutiset"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nakarolyong dyaryo"),
            keywords: &[
                "balita",
                "dyaryo",
                "nakarolyo",
                "nakarolyong dyaryo",
                "papel",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("samanrulla tíðindablað"),
            keywords: &[
                "blað",
                "nýggjheitir",
                "samanrulla",
                "tíðindablað",
                "tíðindi",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("journal roulé"),
            keywords: &["journal", "journal roulé"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("nuachtán rollaithe suas"),
            keywords: &[
                "nuacht",
                "nuachtán rollaithe suas",
                "páipéar",
                "páipéar nuachta",
                "páipéar nuachta rollaithe suas",
                "rollaithe",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("pàipear-naidheachd truiste"),
            keywords: &[
                "naidheachd",
                "naidheachdan",
                "pàipear",
                "pàipear-naidheachd truiste",
                "roiligeadh",
                "truiste",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("xornal enrolado"),
            keywords: &[
                "artigos",
                "diario",
                "enrolado",
                "noticias",
                "xornal enrolado",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વાળ\u{ac7}લ\u{ac1}\u{a82} છાપ\u{ac1}\u{a82}"),
            keywords: &[
                "વાળ\u{ac7}લ\u{ac1}\u{a82} છાપ\u{ac1}\u{a82}",
                "સમાચારપત\u{acd}ર",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("naɗaɗɗiyar jarida"),
            keywords: &[
                "jarida",
                "labarai",
                "naɗaɗɗe",
                "naɗaɗɗiyar jarida",
                "takarda",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עיתון מגולגל"),
            keywords: &["חדשות", "מגולגל", "עיתון"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("रोल किया ह\u{941}आ समाचारपत\u{94d}र"),
            keywords: &[
                "अख\u{93c}बार",
                "प\u{947}पर",
                "मोड\u{93c}ा ह\u{941}आ समाचारपत\u{94d}र",
                "रोल किया ह\u{941}आ समाचारपत\u{94d}र",
                "समाचारपत\u{94d}र",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zarolane novine"),
            keywords: &[
                "novine",
                "papir",
                "presavinuto",
                "vijesti",
                "zarolane novine",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("feltekert újság"),
            keywords: &["feltekert", "papír", "újság"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կլորացրած լրագիր"),
            keywords: &["թերթ", "լրագիր", "կլորացրած", "նորություններ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("gulungan koran"),
            keywords: &["berita", "gulungan koran", "kertas", "koran", "tergulung"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akwụkwọ akụkọ kpọghariri elu"),
            keywords: &[
                "akwụkwọ",
                "akwụkwọ akụkọ kpọghariri elu",
                "akụkọ",
                "kpọgharia",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("samanrúllað dagblað"),
            keywords: &["dagblað", "fréttir", "pappír", "samanrúllað"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("quotidiano arrotolato"),
            keywords: &[
                "giornale",
                "giornale arrotolato",
                "giornali",
                "giornali arrotolati",
                "quotidiani",
                "quotidiano",
                "quotidiano arrotolato",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("丸めた新聞"),
            keywords: &["ニュース", "丸めた新聞", "新聞", "新聞紙"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("koran digulung"),
            keywords: &["digulung", "kabar", "kertas", "koran"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დახვეული გაზეთი"),
            keywords: &["ახალი ამბები", "გაზეთი", "დახვეული", "ქაღალდი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бүктелген газет"),
            keywords: &["бүктелген газет", "газет", "жаңалықтар", "оралған"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("sammenrullet avis"),
            keywords: &["avis", "nyheder", "sammenrullet"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កាសែតរ\u{17bb}\u{17c6}ជាដ\u{17bb}\u{17c6}"),
            keywords: &[
                "កាសែត",
                "កាសែតរ\u{17bb}\u{17c6}ជាដ\u{17bb}\u{17c6}",
                "រ\u{17bb}\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸುತ\u{ccd}ತ\u{cbf}ಕೊಂಡ ವೃತ\u{ccd}ತಪತ\u{ccd}ರ\u{cbf}ಕ\u{cc6}"),
            keywords: &[
                "ಕಾಗದ",
                "ಪತ\u{ccd}ರ\u{cbf}ಕ\u{cc6}",
                "ಸುತ\u{ccd}ತ\u{cbf}ಕೊಂಡ ವೃತ\u{ccd}ತಪತ\u{ccd}ರ\u{cbf}ಕ\u{cc6}",
                "ಸುತ\u{ccd}ತ\u{cbf}ಕೊಳ\u{ccd}ಳಲಾಗ\u{cbf}ದ\u{cc6}",
                "ಸುದ\u{ccd}ದ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("돌돌 말린 신문"),
            keywords: &["돌돌 말린 신문", "신문", "신문 뭉치"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ग\u{941}ठलायिल\u{94d}ल\u{947}\u{902} खबरापत\u{94d}र"),
            keywords: &[
                "खबरापत\u{94d}र",
                "खबरो",
                "ग\u{941}ठलायिल\u{94d}ल\u{947}\u{902}",
                "प\u{947}पर",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("оролгон гезит"),
            keywords: &["гезит", "жаңылыктар", "оролгон"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("opgerullt Zeitung"),
            keywords: &[
                "Neiegkeeten",
                "Pabeier",
                "Zeitung",
                "gerullt",
                "opgerullt Zeitung",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກ\u{ecd}\u{ec9}ໜ\u{eb1}ງສ\u{eb7}ພ\u{eb4}ມ"),
            keywords: &[
                "ກ\u{ecd}\u{ec9}",
                "ກ\u{ecd}\u{ec9}ໜ\u{eb1}ງສ\u{eb7}ພ\u{eb4}ມ",
                "ຂ\u{ec8}າວ",
                "ໜ\u{eb1}ງສ\u{eb7}ພ\u{eb4}ມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("susuktas laikraštis"),
            keywords: &["laikraštis", "naujienos", "popierius", "susuktas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("satīta avīze"),
            keywords: &["avīze", "laikraksts", "satīta avīze", "satīts", "ziņas"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("nūpepa pōkai"),
            keywords: &["nūpepa", "pepa", "pōkai", "rongo"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("замотан весник"),
            keywords: &["весник", "замотан", "ролна"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ച\u{d41}ര\u{d41}ള\u{d3e}ക\u{d4d}കിയ പത\u{d4d}രം"),
            keywords: &[
                "ച\u{d41}ര\u{d41}ള\u{d3e}ക\u{d4d}കിയ പത\u{d4d}രം",
                "ന\u{d4d}യ\u{d42}സ\u{d4d} പേപ\u{d4d}പർ",
                "പത\u{d4d}ര ച\u{d41}ര\u{d41}ൾ",
                "പത\u{d4d}രം",
                "വർത\u{d4d}തമ\u{d3e}നപത\u{d4d}രം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хуйлсан сонин"),
            keywords: &["мэдээ", "сонин", "хуйлсан"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ग\u{941}\u{902}डाळल\u{947}ल\u{947} वर\u{94d}तमानपत\u{94d}र"),
            keywords: &[
                "ग\u{941}\u{902}डाळल\u{947}ल\u{947}",
                "बातम\u{94d}या",
                "वर\u{94d}तमानपत\u{94d}र",
                "व\u{943}त\u{94d}तपत\u{94d}र",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("akhbar bergulung"),
            keywords: &["akhbar", "bergulung", "berita", "kertas"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("gazzetti rromblati"),
            keywords: &["aħbarijiet", "gazzetti", "karta", "rromblati"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လ\u{102d}ပ\u{103a}ထားသည\u{1037}\u{103a} သတင\u{103a}းစာ"),
            keywords: &[
                "လ\u{102d}ပ\u{103a}ထားသည\u{1037}\u{103a} သတင\u{103a}းစာ",
                "လ\u{102d}ပ\u{103a}ထားသည\u{103a}",
                "သတင\u{103a}း",
                "သတင\u{103a}းစာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sammenrullet avis"),
            keywords: &["avis", "nyheter", "opprullet", "papir", "sammenrullet avis"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("माथि-रोल भएको समाचारपत\u{94d}र"),
            keywords: &[
                "पत\u{94d}र",
                "माथि-रोल भएको समाचारपत\u{94d}र",
                "रोल गरिएको",
                "समाचार",
                "समाचारपत\u{94d}र",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("opgerolde krant"),
            keywords: &[
                "krant",
                "nieuws",
                "nieuwsblad",
                "opgerold",
                "opgerolde krant",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("samanrulla avis"),
            keywords: &["avis", "nyhende", "opprulla", "papir", "samanrulla avis"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଗ\u{b41}ଡ\u{b3c}\u{b3e} ହୋଇଥ\u{b3f}ବ\u{b3e} ସମ\u{b4d}ବ\u{b3e}ଦପତ\u{b4d}ର"),
            keywords: &[
                "କ\u{b3e}ଗଜ",
                "ଗ\u{b41}ଡ\u{b3c}\u{b3e} ହୋଇଥ\u{b3f}ବ\u{b3e}",
                "ଗ\u{b41}ଡ\u{b3c}\u{b3e} ହୋଇଥ\u{b3f}ବ\u{b3e} ସମ\u{b4d}ବ\u{b3e}ଦପତ\u{b4d}ର",
                "ସମ\u{b4d}ବ\u{b3e}ଦ",
                "ସମ\u{b4d}ବ\u{b3e}ଦପତ\u{b4d}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲਪ\u{a47}ਟੀ ਹ\u{a4b}ਈ ਅਖ\u{a3c}ਬਾਰ"),
            keywords: &[
                "ਅਖਬਾਰ",
                "ਖ\u{a3c}ਬਰਾ\u{a02}",
                "ਪ\u{a47}ਪਰ",
                "ਲਪ\u{a47}ਟਿਆ ਅਖਬਾਰ",
                "ਲਪ\u{a47}ਟੀ ਹ\u{a4b}ਈ ਅਖ\u{a3c}ਬਾਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("لویٹیا ہوئیا اخبار"),
            keywords: &[
                "اخبار",
                "خبراں",
                "لویٹیا ہوئیا اخبار",
                "کاغذ",
                "گھومیاں ہوئیا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Niúzpépa Wé Dẹm Ról Togẹ\u{301}da"),
            keywords: &[
                "Niuz",
                "Niúzpépa",
                "Niúzpépa Wé Dẹm Ról Togẹ\u{301}da",
                "Pépa",
                "Rol",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zwinięta gazeta"),
            keywords: &[
                "gazeta",
                "papier",
                "rulon",
                "zrolowana",
                "zwinięta",
                "zwitek",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("تړل شوی ورځپاڼې"),
            keywords: &["تړل شوی ورځپاڼې", "تړل شوې", "خبرونه", "ورځپاڼه", "کاغذ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("jornal enrolado"),
            keywords: &["enrolado", "jornal", "notícias"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["enrolado", "jornal", "notícias", "papel"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("periodico ch’umisqa"),
            keywords: &["periodico ch’umisqa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ziar rulat"),
            keywords: &["hârtie", "publicație", "rulat", "ziar rulat", "știri"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-824"),
            keywords: &["E10-824"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("свернутая газета"),
            keywords: &["бумага", "газета", "новости", "свернутая"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikinyamakuru kizingazinze"),
            keywords: &["amakuru", "ikinyamakuru", "kizingazinze", "urupapuro"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ويڙهيل اخبار"),
            keywords: &["اخبار", "خبرون", "ويڙهيل", "پنا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("රෝල\u{dca} කළ ප\u{dd4}වත\u{dca} පත"),
            keywords: &[
                "කඩද\u{dcf}ස\u{dd2}ය",
                "ප\u{dd4}වත\u{dca}",
                "ප\u{dd4}වත\u{dca}පත",
                "රෝල\u{dca} කළ",
                "රෝල\u{dca} කළ ප\u{dd4}වත\u{dca} පත",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zvinuté noviny"),
            keywords: &["noviny", "správy", "zrolované", "zvinuté"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zvit časopis"),
            keywords: &["novice", "zvit časopis", "zvito", "časopis"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("jaraaid duuduuban"),
            keywords: &["duuban", "jaraaid", "jaraaid duuduuban", "war", "warqad"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gazetë e mbledhur rrotull"),
            keywords: &[
                "gazetë",
                "gazetë e mbledhur rrotull",
                "lajme",
                "letër",
                "rrotull",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("умотане новине"),
            keywords: &["вeсти", "нoвинe", "пaпир", "умотане новине", "умотано"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["умотане новине"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("umotane novine"),
            keywords: &["novine", "papir", "umotane novine", "umotano", "vesti"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["umotane novine"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ihoprullad tidning"),
            keywords: &["ihoprullad", "nyheter", "tidning"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("gazeti lililokunjwa"),
            keywords: &[
                "gazeti",
                "gazeti lililokunjwa",
                "habari",
                "karatasi",
                "kukunjwa",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "சுருட\u{bcd}டி மடிக\u{bcd}கப\u{bcd}பட\u{bcd}ட செய\u{bcd}தித\u{bcd}த\u{bbe}ள\u{bcd}",
            ),
            keywords: &[
                "சுருட\u{bcd}டப\u{bcd}பட\u{bcd}ட செய\u{bcd}தித\u{bcd}த\u{bbe}ள\u{bcd}",
                "சுருட\u{bcd}டப\u{bcd}பட\u{bcd}டது",
                "சுருட\u{bcd}டி மடிக\u{bcd}கப\u{bcd}பட\u{bcd}ட செய\u{bcd}தித\u{bcd}த\u{bbe}ள\u{bcd}",
                "செய\u{bcd}தித\u{bcd}த\u{bbe}ள\u{bcd}",
                "நியூஸ\u{bcd} பேப\u{bcd}பர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చుట\u{c4d}ట\u{c3f} ఉన\u{c4d}న వ\u{c3e}ర\u{c4d}త\u{c3e}పత\u{c4d}ర\u{c3f}క"),
            keywords: &[
                "చుట\u{c4d}టడం",
                "చుట\u{c4d}ట\u{c3f} ఉన\u{c4d}న వ\u{c3e}ర\u{c4d}త\u{c3e}పత\u{c4d}ర\u{c3f}క",
                "న\u{c4d}యూస\u{c4d}\u{200c}ప\u{c47}పర\u{c4d}",
                "పత\u{c4d}ర\u{c3f}క",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("газетаи гардондашуда"),
            keywords: &[
                "газета",
                "газетаи гардондашуда",
                "гардондашуда",
                "хабарҳо",
                "қоғаз",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ม\u{e49}วนหน\u{e31}งส\u{e37}อพ\u{e34}มพ\u{e4c}"),
            keywords: &[
                "กระดาษ",
                "ข\u{e48}าว",
                "ม\u{e49}วน",
                "ม\u{e49}วนหน\u{e31}งส\u{e37}อพ\u{e34}มพ\u{e4c}",
                "หน\u{e31}งส\u{e37}อพ\u{e34}มพ\u{e4c}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("düýrlenen gazet"),
            keywords: &["düýrlenen gazet", "düýrüm", "gazet", "habar", "kagyz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("nusipepa takainga"),
            keywords: &["nusipepa takainga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("rulo gazete"),
            keywords: &["gazete", "haber", "kağıt", "rulo"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئوراق گېزىت"),
            keywords: &["ئوراق گېزىت", "ئورام", "خەۋەر", "قەغەز", "گېزىت"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("скручена газета"),
            keywords: &[
                "газета",
                "звивена газета",
                "згорнута",
                "новини",
                "папір",
                "скручена газета",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("رول کیا ہوا اخبار"),
            keywords: &["اخبار", "رول", "رول کیا ہوا اخبار", "کاغذ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("o‘ralgan gazeta"),
            keywords: &["gazeta", "o‘ralgan", "qog‘oz", "yangiliklar"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tờ báo được cuộn tròn"),
            keywords: &["báo", "cuộn", "tạp chí", "tờ báo được cuộn tròn"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("këyitu xibaar buñ lem"),
            keywords: &[
                "këyit",
                "këyitu xibaar",
                "këyitu xibaar buñ lem",
                "rolled",
                "xibaar",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iphephandaba elisongiweyo"),
            keywords: &[
                "esongiweyo",
                "iindaba",
                "iphepha",
                "iphephandaba",
                "iphephandaba elisongiweyo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ìwé ìròyìn aláyípọ\u{300}"),
            keywords: &[
                "pépà",
                "àkápọ\u{300}",
                "ìròyìn",
                "ìwé ìròyìn",
                "ìwé ìròyìn aláyípọ\u{300}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("捲起嘅報紙"),
            keywords: &["報紙", "捲起", "捲起嘅報紙", "新聞", "紙"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("卷起嘅报纸"),
            keywords: &["卷起", "卷起嘅报纸", "报纸", "新闻", "纸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("报纸卷"),
            keywords: &["卷起", "卷起的报纸", "报纸", "报纸卷", "新闻", "纸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("捲好的報紙"),
            keywords: &["報紙", "捲好的報紙", "新聞"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("捲起嘅報紙"),
            keywords: &["報紙", "捲起嘅報紙", "新聞"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iphephandaba eligoqiwe"),
            keywords: &["eligoqiwe", "iphepha", "iphephandaba", "izindaba"],
        },
    ],
};
#[doc = "📑"]
pub const BOOKMARK_TABS: crate::Emoji = crate::Emoji {
    glyph: "📑",
    codepoint: "1F4D1",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "bookmark tabs",
    group: "Objects",
    subgroup: "book-paper",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("boekmerkoortjies"),
            keywords: &["boekmerk", "boekmerkoortjies", "merker", "oortjies"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("እልባት ማድረጊያ ትሮች"),
            keywords: &["መጽሐፍምልክት", "ማርከር", "ምልክት", "ትሮች", "እልባት ማድረጊያ ትሮች"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("لصاقات علامات توقف قراءة"),
            keywords: &["علامة", "لصاقات علامات توقف قراءة", "لصاقة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ব\u{9c1}কম\u{9be}ৰ\u{9cd}ক টেব"),
            keywords: &[
                "চিহ\u{9cd}ন",
                "চিহ\u{9cd}নিত কৰ\u{9be}",
                "টেব",
                "ব\u{9c1}কম\u{9be}ৰ\u{9cd}ক",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("əlfəcin tabları"),
            keywords: &["işarə", "marker", "tablar", "əlfəcin", "əlfəcin tabları"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("закладкі"),
            keywords: &["закладка", "закладкі", "маркер", "метка", "укладка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("отметки"),
            keywords: &["знак", "отметка", "отметки"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9c1}কমম\u{9be}র\u{9cd}ক ট\u{9cd}য\u{9be}ব"),
            keywords: &[
                "চিহ\u{9cd}ন",
                "ট\u{9cd}য\u{9be}ব",
                "ব\u{9c1}কমম\u{9be}র\u{9cd}ক ট\u{9cd}য\u{9be}ব",
                "ব\u{9c1}কম\u{9be}র\u{9cd}ক",
                "ম\u{9be}র\u{9cd}ক\u{9be}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("sinedoù"),
            keywords: &["merk", "sinedoù"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("markeri za knjige"),
            keywords: &["bukmark", "marker", "markeri za knjige", "oznaka"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("marcadors"),
            keywords: &["fitxa", "marca", "marcador", "marcadors", "punt"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎪᏪᎵᎪᏣᎸᏗ ᏗᎦᏗ"),
            keywords: &["ᎤᏙᏪᎸ", "ᎪᏪᎵᎪᏣᎸᏗ", "ᏗᎦᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("stránky se záložkami"),
            keywords: &[
                "ouška",
                "ouško",
                "papíry",
                "poznámky",
                "stránky se záložkami",
                "značka",
                "záložka",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("tabiau nodau tudalen"),
            keywords: &[
                "llyfrnod",
                "marc",
                "nod tudalen",
                "tabiau",
                "tabiau nodau tudalen",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("faner"),
            keywords: &["bogmærke", "faner", "mærke"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Pagemarker"),
            keywords: &["Notizen", "Pagemarker"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καρτέλες σελιδοδεικτών"),
            keywords: &[
                "ένδειξη",
                "δείκτης",
                "καρτέλες",
                "καρτέλες σελιδοδεικτών",
                "σελιδοδείκτης",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("bookmark tabs"),
            keywords: &["bookmark", "mark", "marker", "tabs"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("marcadores"),
            keywords: &["marcadores", "pestañas"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("pestañas de marcador"),
            keywords: &["marcador", "pestañas", "pestañas de marcador"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("etiquetas separadoras"),
            keywords: &[
                "etiquetas",
                "etiquetas separadoras",
                "marcapáginas",
                "pestañas",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("järjehoidjad"),
            keywords: &["järjehoidja", "järjehoidjad", "marker", "märgis"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("laster-markak"),
            keywords: &["laster", "laster-markak", "marka", "markatu", "markatzaile"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("برچسب\u{200c}های نشانه\u{200c}گذاری"),
            keywords: &[
                "برچسب\u{200c}های نشانه\u{200c}گذاری",
                "زبانه",
                "علامت",
                "علامت\u{200c}گذار",
                "نشانه",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kirjanmerkkivälilehdet"),
            keywords: &[
                "kirjanmerkki",
                "kirjanmerkkivälilehdet",
                "merkki",
                "välilehti",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mga bookmark tab"),
            keywords: &[
                "bookmark",
                "marker",
                "mga bookmark tab",
                "mga tab",
                "palatandaan",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("bókamerkir"),
            keywords: &["bókamerki", "bókamerkir"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("signets"),
            keywords: &["marque", "marqueur", "onglets", "signet", "signets"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("onglets"),
            keywords: &["marque", "marqueur", "onglets", "signet"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("clibeanna leabharmhairc"),
            keywords: &[
                "clibeanna leabharmhairc",
                "leabharmharc",
                "leabharmharcanna",
                "táib",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("tabaichean-leabhair"),
            keywords: &[
                "comharra",
                "comharra-leabhair",
                "comharraich",
                "taba",
                "tabaichean-leabhair",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("marcador autoadhesivo"),
            keywords: &["bandeiriña adhesiva", "marcador", "marcador autoadhesivo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બ\u{ac1}કમાર\u{acd}ક\u{acd}સ ટ\u{ac7}બ\u{acd}સ"),
            keywords: &[
                "ટ\u{ac7}બ\u{acd}સ",
                "બ\u{ac1}કમાર\u{acd}ક",
                "બ\u{ac1}કમાર\u{acd}ક\u{acd}સ ટ\u{ac7}બ\u{acd}સ",
                "માર\u{acd}કર",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("maɓallan ma’ajiyar rubutu"),
            keywords: &[
                "ma sa maki",
                "maki",
                "maɓallai",
                "maɓallan ma’ajiyar rubutu",
                "ma’ajiyar rubutu",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("תוויות סימניה"),
            keywords: &["מסמכים", "סימון", "סימניה", "סימניות", "תוויות"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ब\u{941}कमार\u{94d}क ट\u{948}ब"),
            keywords: &["ट\u{948}ब", "ब\u{941}कमार\u{94d}क", "मार\u{94d}कर"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kartice knjižnih oznaka"),
            keywords: &[
                "jezičak",
                "kartice knjižnih oznaka",
                "knjižna oznaka",
                "marker",
                "oznaka",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("könyvjelzők"),
            keywords: &["fülek", "jelzés", "könyvjelző", "könyvjelzők"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("էջանիշ ներդիրներ"),
            keywords: &["էջանիշ", "էջանիշ ներդիրներ", "ներդիր", "նշել", "նշիչ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("penanda halaman buku"),
            keywords: &["penanda", "penanda halaman buku", "tab", "tanda"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("taabụ bukumakị"),
            keywords: &[
                "akara",
                "bukumakị",
                "onyee akara",
                "taabụ bukumakị",
                "taabụ gasị",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("bókamerki í tölvu"),
            keywords: &["bókamerki í tölvu", "flipar", "merki"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("etichette segnalibro"),
            keywords: &["etichette segnalibro", "linguette", "segnalibro"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ページに付箋"),
            keywords: &["ふせん", "ページに付箋", "付箋", "文具", "文房具"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tetenger"),
            keywords: &["panandha", "tandha", "tenger", "tetenger"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სანიშნი ჩანართები"),
            keywords: &["სანიშნე", "სანიშნი ჩანართები", "ჩანართები"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: None,
            keywords: &["tacreṭ", "tacreṭ n usebter"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бетбелгілер қойындысы"),
            keywords: &[
                "белгі",
                "белгілегіш",
                "бетбелгі",
                "бетбелгілер қойындысы",
                "қойынды",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("faner"),
            keywords: &["bogmærke", "faner", "mærke"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ទ\u{17c6}ព\u{17d0}រមានបន\u{17d2}ទះសៀតច\u{17c6}ណា\u{17c6}"),
            keywords: &[
                "ច\u{17c6}ណា\u{17c6}",
                "ទ\u{17c6}ព\u{17d0}រមានបន\u{17d2}ទះសៀតច\u{17c6}ណា\u{17c6}",
                "បន\u{17d2}ទះសៀតច\u{17c6}ណា\u{17c6}",
                "សម\u{17d2}គាល\u{17cb}",
                "សៀតច\u{17c6}ណា\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬುಕ\u{ccd}\u{200c}ಮಾರ\u{ccd}ಕ\u{ccd} ಟ\u{ccd}ಯಾಬ\u{ccd}\u{200c}ಗಳು"),
            keywords: &[
                "ಗುರುತು",
                "ಟ\u{ccd}ಯಾಬ\u{ccd}\u{200c}ಗಳು",
                "ಬುಕ\u{ccd}\u{200c}ಮಾರ\u{ccd}ಕ\u{ccd}",
                "ಮಾರ\u{ccd}ಕರ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("북마크 탭"),
            keywords: &["마커", "북마크 탭", "포스트잇"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ब\u{942}कमार\u{94d}क ट\u{945}ब\u{94d}स"),
            keywords: &[
                "ट\u{945}ब\u{94d}स",
                "ब\u{942}कमार\u{94d}क",
                "मार\u{94d}क",
                "म\u{947}कर",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кыстарма өтмөктөрү"),
            keywords: &["белги", "кыстарма", "кыстарма өтмөктөрү", "өтмөк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Lieszeechestickeren"),
            keywords: &[
                "Lieszeechen",
                "Lieszeechestickeren",
                "Markéierung",
                "Stickeren",
                "Zeechen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແຖບຂ\u{eb1}\u{ec9}ນໜ\u{ec9}າເຈ\u{ec9}ຍ"),
            keywords: &[
                "ຂ\u{eb1}\u{ec9}ນໜ\u{ec9}າ",
                "ເຄ\u{eb7}\u{ec8}ອງໝາຍ",
                "ແຖບຂ\u{eb1}\u{ec9}ນໜ\u{ec9}າເຈ\u{ec9}ຍ",
                "ແທ\u{eb1}ບ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žymių skirtukai"),
            keywords: &["skirtukai", "žyma", "žymeklis", "žymių skirtukai", "žymė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("līmkarodziņi"),
            keywords: &["grāmatzīme", "līmkarodziņi", "zīme"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ripa tohuwāhi"),
            keywords: &["ngā ripa", "ripa tohuwāhi", "tohu", "tohuwāhi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("обележани страници"),
            keywords: &["обележани страници", "обележувач", "ознака"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ബ\u{d41}ക\u{d4d}ക\u{d4d}\u{200c}മ\u{d3e}ർക\u{d4d}ക\u{d4d} ട\u{d3e}ബ\u{d41}കൾ",
            ),
            keywords: &[
                "ട\u{d3e}ബ\u{d4d}",
                "ബ\u{d41}ക\u{d4d}ക\u{d4d}\u{200c}മ\u{d3e}ർക\u{d4d}ക\u{d4d}",
                "ബ\u{d41}ക\u{d4d}ക\u{d4d}\u{200c}മ\u{d3e}ർക\u{d4d}ക\u{d4d} ട\u{d3e}ബ\u{d41}കൾ",
                "മ\u{d3e}ർക\u{d4d}കർ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("номын хавчуургын табууд"),
            keywords: &[
                "номын хавчуурга",
                "номын хавчуургын табууд",
                "табууд",
                "тодруулагч",
                "тэмдэг",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ब\u{941}कमार\u{94d}क ट\u{945}ब"),
            keywords: &[
                "ख\u{942}ण",
                "ट\u{945}ब",
                "ब\u{941}कमार\u{94d}क",
                "मार\u{94d}कर",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tab penanda halaman"),
            keywords: &[
                "penanda",
                "penanda halaman",
                "tab",
                "tab penanda halaman",
                "tanda",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("tabs tal-bookmarks"),
            keywords: &[
                "bookmarks",
                "marka",
                "markatur",
                "tabs",
                "tabs tal-bookmarks",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စာည\u{103e}ပ\u{103a} တဘ\u{103a}များ"),
            keywords: &[
                "စာည\u{103e}ပ\u{103a}",
                "ည\u{103d}\u{103e}န\u{103a}မ\u{103e}တ\u{103a}",
                "တဘ\u{103a}များ",
                "အမ\u{103e}တ\u{103a}အသား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bokmerkefane"),
            keywords: &["bokmerke", "bokmerkefane", "faner", "markør", "merker"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ब\u{941}कमार\u{94d}क ट\u{94d}याबहर\u{942}"),
            keywords: &[
                "चिन\u{94d}ह",
                "ट\u{94d}याबहर\u{942}",
                "ब\u{941}कमार\u{94d}क",
                "मार\u{94d}कर",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bladwijzertabs"),
            keywords: &["bladwijzer", "bladwijzertabs", "markering", "tabs"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bokmerkefane"),
            keywords: &["bokmerke", "bokmerkefane", "faner", "markør", "merke"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ବ\u{b41}କ\u{b4d}\u{200c}ମ\u{b3e}ର\u{b4d}କ\u{b4d}\u{200c} ଟ\u{b4d}ୟ\u{b3e}ବ\u{b4d}\u{200c}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
            ),
            keywords: &[
                "ଟ\u{b4d}ୟ\u{b3e}ବ\u{b4d}",
                "ପ\u{b41}ସ\u{b4d}ତକଚ\u{b3f}ହ\u{b4d}ନ",
                "ବ\u{b41}କ\u{b4d}\u{200c}ମ\u{b3e}ର\u{b4d}କ\u{b4d}\u{200c} ଟ\u{b4d}ୟ\u{b3e}ବ\u{b4d}\u{200c}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
                "ମ\u{b3e}ର\u{b4d}କର\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a41}\u{a71}ਕਮਾਰਕ ਟ\u{a48}ਬਾ\u{a02}"),
            keywords: &[
                "ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਟ\u{a48}ਬ",
                "ਬ\u{a41}\u{a71}ਕਮਾਰਕ",
                "ਬ\u{a41}\u{a71}ਕਮਾਰਕ ਟ\u{a48}ਬਾ\u{a02}",
                "ਮਾਰਕ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بک مارک ٹیبز"),
            keywords: &[
                "بک مارک",
                "بک مارک ٹیبز",
                "لوحہ",
                "نشان لان آلا",
                "نشان لانا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bukmák Tab-dẹm"),
            keywords: &["Bukmák", "Mak", "Máka", "Tab-dẹm"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("karty zakładek"),
            keywords: &["karta", "karty zakładek", "przekładka", "zakładka", "znak"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د کتاب نښې ټيبز"),
            keywords: &["د کتاب نښه", "د کتاب نښې ټيبز", "مارکر", "نښه", "ټيبز"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("marcadores de página"),
            keywords: &[
                "marcador",
                "marcador de página",
                "marcadores de página",
                "marcar",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("marcadores de folhas"),
            keywords: &["marcadores", "marcadores de folhas", "marcar"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("rapi chinpuqkunawan"),
            keywords: &[
                "chinpuq",
                "chinpuy",
                "qawachiqkuna",
                "rapi chinpuq",
                "rapi chinpuqkunawan",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("marcatoare de pagini"),
            keywords: &["marcatoare de pagini", "marcator", "semn", "semn de carte"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-654"),
            keywords: &["E10-654"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("стикеры-закладки"),
            keywords: &[
                "закладки",
                "клеящиеся закладки",
                "наклейки",
                "стикеры",
                "стикеры-закладки",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("utudirishya tw’ubushyinguropaji"),
            keywords: &[
                "gushyingura paji",
                "gushyiraho ikimenyetso",
                "ikimenyetso",
                "utudirishya",
                "utudirishya tw’ubushyinguropaji",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بڪ مارڪ وارا ٽيب"),
            keywords: &["بوڪ مارڪ", "بڪ مارڪ وارا ٽيب", "مارڪ", "مارڪر", "ٽيبس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd2}ට\u{dd4} සලක\u{dd4}ණ\u{dd4} ටැබ"),
            keywords: &[
                "ටැබ",
                "ප\u{dd2}ට\u{dd4} සලක\u{dd4}ණ",
                "ප\u{dd2}ට\u{dd4} සලක\u{dd4}ණ\u{dd4} ටැබ",
                "සලක\u{dd4}ණ",
                "සලක\u{dd4}ණ\u{dd4}ක\u{dcf}රකය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("záložky"),
            keywords: &["karty", "označenie", "značka", "záložka", "záložky"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zaznamki na straneh"),
            keywords: &[
                "marker",
                "oznaka",
                "zavihki",
                "zaznamek",
                "zaznamki na straneh",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qeybaha calaamadeynta buuga"),
            keywords: &[
                "calaamadeeye",
                "calaamadeyn",
                "calaamadeynta buuga",
                "qeybaha calaamadeynta buuga",
                "qeybo",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("skedat e faqeshënuesve"),
            keywords: &[
                "faqeshënues",
                "shenjë",
                "shënues",
                "skeda",
                "skedat e faqeshënuesve",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("странице са белешкама"),
            keywords: &[
                "картице",
                "обележивач",
                "обележивач страница у књизи",
                "ознака",
                "странице са белешкама",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("странице са биљешкама"),
            keywords: &["странице са биљешкама"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("stranice sa beleškama"),
            keywords: &[
                "kartice",
                "obeleživač",
                "obeleživač stranica u knjizi",
                "oznaka",
                "stranice sa beleškama",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("stranice sa bilješkama"),
            keywords: &["stranice sa bilješkama"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("bokmärkesflikar"),
            keywords: &["bokmärken", "bokmärkesflikar", "flikar", "markörer"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("vichupo vya alamisho"),
            keywords: &[
                "alama",
                "alamisho",
                "vichupo",
                "vichupo vya alamisho",
                "weka alama",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("புக\u{bcd}ம\u{bbe}ர\u{bcd}க\u{bcd} டேப\u{bcd}ஸ\u{bcd}"),
            keywords: &[
                "குறித\u{bcd}தல\u{bcd}",
                "டேப\u{bcd}ஸ\u{bcd}",
                "புக\u{bcd}ம\u{bbe}ர\u{bcd}க\u{bcd}",
                "புத\u{bcd}தகத\u{bcd}தில\u{bcd} குறித\u{bcd}தல\u{bcd}",
                "ம\u{bbe}ர\u{bcd}க\u{bcd}கர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "బుక\u{c4d}\u{200c}మ\u{c3e}ర\u{c4d}క\u{c4d} ట\u{c4d}య\u{c3e}బ\u{c4d}\u{200c}లు",
            ),
            keywords: &[
                "గుర\u{c4d}తు ప\u{c46}ట\u{c4d}టడం",
                "ట\u{c4d}య\u{c3e}బ\u{c4d}\u{200c}లు",
                "బుక\u{c4d}\u{200c}మ\u{c3e}ర\u{c4d}క\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("варақаҳои хатбарак"),
            keywords: &[
                "аломат",
                "варақаҳо",
                "варақаҳои хатбарак",
                "маркер",
                "хатбарак",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แถบค\u{e31}\u{e48}นหน\u{e49}า"),
            keywords: &[
                "ค\u{e31}\u{e48}นหน\u{e49}า",
                "เคร\u{e37}\u{e48}องหมาย",
                "แถบค\u{e31}\u{e48}นหน\u{e49}า",
                "แท\u{e47}บ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("bellikçe tablary"),
            keywords: &[
                "alamat",
                "bellikçe tablary",
                "marker",
                "tablar",
                "ýer belligi",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("vahevahe tohi"),
            keywords: &["vahevahe tohi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sayfa ayraçları"),
            keywords: &["ayraçlar", "işaretçi", "sayfa ayraçları", "sayfa işareti"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يىغقۇچ بەتكۈچى"),
            keywords: &["بەتكۈچ", "بەلگە", "خەتكۈچ", "يىغقۇچ", "يىغقۇچ بەتكۈچى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("мітки закладок"),
            keywords: &["вкладка", "закладка", "значок", "мітка", "мітки закладок"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ب\u{64f}ک مارک ٹیبز"),
            keywords: &["ب\u{64f}ک مارک ٹیبز", "بک مارک", "ٹیبز"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("sahifalardagi xatcho‘p"),
            keywords: &[
                "belgilash",
                "marker",
                "sahifalardagi xatcho‘p",
                "varaqlar",
                "xatchoʻp",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tab dấu trang"),
            keywords: &["dấu trang", "tab", "tab dấu trang", "đánh dấu"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("boole ci yi ma gënal"),
            keywords: &[
                "boole ci yi ma gënal",
                "laf yi",
                "xàmme",
                "xàmme-téere",
                "xàmmekaay",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iithebhu zebhukmakhi"),
            keywords: &[
                "ibhukmakhi",
                "iithebhu",
                "iithebhu zebhukmakhi",
                "isiphawuli",
                "uphawu",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àmì ìwé àwọn táàbù"),
            keywords: &[
                "ohun èlò ìfàmìsí",
                "táàbù",
                "àmì",
                "àmì ìwé àwọn táàbù",
                "ìfàmìsí",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("書籤標籤"),
            keywords: &["書籤", "書籤標籤", "標籤", "標記", "標誌"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("书签标签"),
            keywords: &["书签", "书签标签", "标志", "标签", "标记"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("标签页"),
            keywords: &["书签", "有书签的页面", "标签页"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("頁籤"),
            keywords: &["標籤", "頁籤"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("書籤頁"),
            keywords: &["書籤標籤", "書籤頁", "標記頁面"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ama-tabs okumaka ibhuku"),
            keywords: &[
                "ama-tabs",
                "ama-tabs okumaka ibhuku",
                "okokumaka ibhuku",
                "umaka",
            ],
        },
    ],
};
#[doc = "🔖"]
pub const BOOKMARK: crate::Emoji = crate::Emoji {
    glyph: "🔖",
    codepoint: "1F516",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "bookmark",
    group: "Objects",
    subgroup: "book-paper",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("boekmerk"),
            keywords: &["boekmerk", "merker"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("እልባት"),
            keywords: &["ምልክት", "እልባት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("علامة توقف قراءة"),
            keywords: &["علامة", "علامة توقف قراءة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ব\u{9c1}কম\u{9be}ৰ\u{9cd}ক"),
            keywords: &["চিহ\u{9cd}নিত কৰ\u{9be}", "ব\u{9c1}কম\u{9be}ৰ\u{9cd}ক"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("əlfəcin"),
            keywords: &["işarə", "əlfəcin"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("закладка"),
            keywords: &["закладка", "маркер", "метка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("отметка"),
            keywords: &["знак", "отметка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9c1}কম\u{9be}র\u{9cd}ক"),
            keywords: &["চিহ\u{9cd}ন", "ব\u{9c1}কম\u{9be}র\u{9cd}ক"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("merk-pajenn"),
            keywords: &["merk", "merk-pajenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("marker"),
            keywords: &["marker", "oznaka"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("punt de llibre"),
            keywords: &["marcador", "punt", "punt de llibre"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎪᏪᎵᎪᏣᎸᏗ"),
            keywords: &["ᎪᏪᎳᏅᎯ", "ᎪᏪᎵᎪᏣᎸᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("záložka"),
            keywords: &["značka", "záložka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("nod tudalen"),
            keywords: &["marc", "nod tudalen"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bogmærke"),
            keywords: &["bogmærke", "mærke"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Lesezeichen"),
            keywords: &["Lesen", "Lesezeichen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σελιδοδείκτης"),
            keywords: &["δείκτης", "σελιδοδείκτης"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("bookmark"),
            keywords: &["bookmark", "mark"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("marcapáginas"),
            keywords: &["marcador", "marcapáginas"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("separador"),
            keywords: &["marcapágina", "separador"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("järjehoidja"),
            keywords: &["järjehoidja"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("laster-marka"),
            keywords: &["laster-marka", "marka"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نشان\u{200c}گذار کتاب"),
            keywords: &["نشان\u{200c}گذار کتاب", "چوب\u{200c}الف", "چوق\u{200c}الف"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kirjanmerkki"),
            keywords: &["kirjanmerkki", "merkki"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bookmark"),
            keywords: &["bookmark", "palatandaan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("bókamerki"),
            keywords: &["bókamerki", "bókamerkir"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("marque-page"),
            keywords: &["marque-page", "marqueur"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("leabharmharc"),
            keywords: &["leabharmharc"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("comharra-leabhair"),
            keywords: &["comharra", "comharra-leabhair", "comharraich"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("marcapáxinas"),
            keywords: &[
                "marcador",
                "marcalibros",
                "marcapáxinas",
                "punto de lectura",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બ\u{ac1}કમાર\u{acd}ક"),
            keywords: &["બ\u{ac1}કમાર\u{acd}ક", "માર\u{acd}ક"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ma’ajiyar rubutu"),
            keywords: &["maki", "ma’ajiyar rubutu"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סימנייה"),
            keywords: &["סימון", "סימנייה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ब\u{941}कमार\u{94d}क"),
            keywords: &["निशान", "ब\u{941}कमार\u{94d}क"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("knjižna oznaka"),
            keywords: &["knjižna oznaka", "oznaka"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("könyvjelző"),
            keywords: &["könyvjelző"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("էջանիշ"),
            keywords: &["էջանիշ", "նշել"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pembatas buku"),
            keywords: &["pembatas buku", "tanda"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("bukumakị"),
            keywords: &["akara", "bukumakị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("bókamerki"),
            keywords: &["bókamerki", "merki"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("segnalibro"),
            keywords: &["lettura", "libro", "segnalibro"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("しおり"),
            keywords: &["しおり", "タグ", "ブックマーク", "付箋"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tenger"),
            keywords: &["tandha", "tenger"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სანიშნე"),
            keywords: &["სანიშნე"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tacreṭ n usebter"),
            keywords: &["tacreṭ n usebter"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бетбелгі"),
            keywords: &["белгі", "бетбелгі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("bogmærke"),
            keywords: &["bogmærke", "mærke"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17d2}រដាប\u{17cb}សៀតច\u{17c6}ណា\u{17c6}ទ\u{17c6}ព\u{17d0}រ"),
            keywords: &[
                "ច\u{17c6}ណា\u{17c6}ទ\u{17c6}ព\u{17d0}រ",
                "ប\u{17d2}រដាប\u{17cb}សៀត",
                "ប\u{17d2}រដាប\u{17cb}សៀតច\u{17c6}ណា\u{17c6}ទ\u{17c6}ព\u{17d0}រ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬುಕ\u{ccd}\u{200c}\u{200c}ಮಾರ\u{ccd}ಕ\u{ccd}"),
            keywords: &["ಗುರುತು", "ಬುಕ\u{ccd}\u{200c}\u{200c}ಮಾರ\u{ccd}ಕ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("북마크"),
            keywords: &["마크", "북마크", "책갈피", "표시"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ब\u{942}कमार\u{94d}क"),
            keywords: &["ब\u{942}कमार\u{94d}क", "मार\u{94d}क"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кыстарма"),
            keywords: &["белги", "кыстарма"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Lieszeechen"),
            keywords: &["Lieszeechen", "Zeechen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແນວຂ\u{eb1}\u{ec9}ນໜ\u{ec9}າເຈ\u{ec9}ຍ"),
            keywords: &[
                "ເຄ\u{eb7}\u{ec8}ອງໝາຍ",
                "ແນວຂ\u{eb1}\u{ec9}ນ",
                "ແນວຂ\u{eb1}\u{ec9}ນໜ\u{ec9}າເຈ\u{ec9}ຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žymė"),
            keywords: &["žyma", "žymė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("grāmatzīme"),
            keywords: &["grāmatzīme", "zīme"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohuwāhi"),
            keywords: &["tohu", "tohuwāhi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("обележувач"),
            keywords: &["обележувач", "ознака"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ബ\u{d41}ക\u{d4d}ക\u{d4d}\u{200c}മ\u{d3e}ർക\u{d4d}ക\u{d4d}"),
            keywords: &["ബ\u{d41}ക\u{d4d}ക\u{d4d}\u{200c}മ\u{d3e}ർക\u{d4d}ക\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("номны хавчуурга"),
            keywords: &["номны хавчуурга", "тэмдэглэх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ब\u{941}कमार\u{94d}क"),
            keywords: &["ब\u{941}कमार\u{94d}क", "मार\u{94d}क"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("penanda buku"),
            keywords: &["penanda buku", "tanda"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("bookmark"),
            keywords: &["bookmark", "marka"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စာည\u{103e}ပ\u{103a}"),
            keywords: &["စာည\u{103e}ပ\u{103a}", "အမ\u{103e}တ\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bokmerke"),
            keywords: &["bokmerke", "merke"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ब\u{941}कमार\u{94d}क"),
            keywords: &["चिन\u{94d}ह", "ब\u{941}कमार\u{94d}क"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bladwijzer"),
            keywords: &["bladwijzer", "markering"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bokmerke"),
            keywords: &["bokmerke", "merke"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b41}କ\u{b4d}\u{200c}ମ\u{b3e}ର\u{b4d}କ\u{b4d}\u{200c}"),
            keywords: &[
                "ପ\u{b41}ସ\u{b4d}ତକଚ\u{b3f}ହ\u{b4d}ନ",
                "ବ\u{b41}କ\u{b4d}\u{200c}ମ\u{b3e}ର\u{b4d}କ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a41}\u{a71}\u{a71}ਕਮਾਰਕ"),
            keywords: &[
                "ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਬ\u{a41}\u{a71}ਕਮਾਰਕ",
                "ਬ\u{a41}\u{a71}\u{a71}ਕਮਾਰਕ",
                "ਮਾਰਕ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بک مارک"),
            keywords: &["بک مارک", "نشان لانا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bukmák"),
            keywords: &["Bukmák", "Mak"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zakładka"),
            keywords: &["zakładka", "zaznaczenie"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د کتاب نښه"),
            keywords: &["د کتاب نښه", "نښه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("marcador de página"),
            keywords: &["marcador", "marcador de página", "página"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("marcador de livros"),
            keywords: &["marcador de livros", "marcar"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("chinpuq"),
            keywords: &["chinpuq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("semn de carte"),
            keywords: &["marcator", "semn", "semn de carte"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-722"),
            keywords: &["E10-722"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("закладка"),
            keywords: &["закладка", "книга", "книжка", "отметка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ubushyinguropaji"),
            keywords: &["kugaragaza", "ubushyinguropaji"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بڪ مارڪ"),
            keywords: &["بڪ مارڪ", "نشان"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd2}ට\u{dd4} සලක\u{dd4}ණ"),
            keywords: &["ප\u{dd2}ට\u{dd4} සලක\u{dd4}ණ", "සලක\u{dd4}ණ"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("záložka"),
            keywords: &["karty", "označenie", "značka", "záložka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zaznamek"),
            keywords: &["oznaka", "zaznamek"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("calaamadeeye"),
            keywords: &["calaamad", "calaamadeeye"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("faqeshënues"),
            keywords: &["faqeshënues", "shenjë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("обележивач страница у књизи"),
            keywords: &["oзнaкa", "обележивач страница у књизи"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("обиљеживач страница у књизи"),
            keywords: &["обиљеживач страница у књизи"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("obeleživač stranica u knjizi"),
            keywords: &["obeleživač stranica u knjizi", "oznaka"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("obilježivač stranica u knjizi"),
            keywords: &["obilježivač stranica u knjizi"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("bokmärke"),
            keywords: &["bokmärke", "märke"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("alamisho"),
            keywords: &["alamisho", "weka alama"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("புக\u{bcd}ம\u{bbe}ர\u{bcd}க\u{bcd}"),
            keywords: &[
                "பக\u{bcd}க அடைய\u{bbe}ளம\u{bcd}",
                "பட\u{bcd}டி",
                "புக\u{bcd}ம\u{bbe}ர\u{bcd}க\u{bcd}",
                "புத\u{bcd}தகக\u{bcd}குறி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బుక\u{c4d}\u{200c}మ\u{c3e}ర\u{c4d}క\u{c4d}"),
            keywords: &[
                "ట\u{c4d}య\u{c3e}గ\u{c4d}",
                "బుక\u{c4d}\u{200c}మ\u{c3e}ర\u{c4d}క\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("хатбарак"),
            keywords: &["аломат", "хатбарак"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ท\u{e35}\u{e48}ค\u{e31}\u{e48}นหน\u{e31}งส\u{e37}อ"),
            keywords: &[
                "ค\u{e31}\u{e48}น",
                "ท\u{e35}\u{e48}ค\u{e31}\u{e48}นหน\u{e31}งส\u{e37}อ",
                "หน\u{e31}งส\u{e37}อ",
                "เคร\u{e37}\u{e48}องหมาย",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("bellikçe"),
            keywords: &["belgi", "bellikçe"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakaʻilonga tohi"),
            keywords: &["fakaʻilonga tohi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yer işareti"),
            keywords: &["işaret", "yer işareti"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يىغقۇچ"),
            keywords: &["بەلگە", "يىغقۇچ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("закладка"),
            keywords: &["закладка", "значок"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ب\u{64f}ک مارک"),
            keywords: &["ب\u{64f}ک مارک", "بک مارک"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("xatcho‘p"),
            keywords: &["belgi", "xatcho‘p"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đánh dấu trang"),
            keywords: &["đánh dấu", "đánh dấu trang"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xàmme-téere"),
            keywords: &["xàmme", "xàmme-téere"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhukmakhi"),
            keywords: &["ibhukmakhi", "uphawu"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àmì ìwé"),
            keywords: &["àmì", "àmì ìwé"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("書籤"),
            keywords: &["書籤", "標記"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("书签"),
            keywords: &["书签", "标记"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("书签"),
            keywords: &["书签", "标签", "读书", "阅读"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("書籤"),
            keywords: &["書籤"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhuku lokumaka"),
            keywords: &["ibhuku lokumaka", "ukumaka"],
        },
    ],
};
#[doc = "🏷\u{fe0f}"]
pub const LABEL: crate::Emoji = crate::Emoji {
    glyph: "🏷\u{fe0f}",
    codepoint: "1F3F7 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "label",
    group: "Objects",
    subgroup: "book-paper",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🏷",
        codepoint: "1F3F7",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "label",
        group: "Objects",
        subgroup: "book-paper",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("etiket"),
            keywords: &["etiket"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መለያ"),
            keywords: &["መለያ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ملصق"),
            keywords: &["علامة", "ملصق"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("লেবেল"),
            keywords: &["লেবেল"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("etiket"),
            keywords: &["etiket"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("бірка"),
            keywords: &["бірка", "цэтлік", "ярлык"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("етикет"),
            keywords: &["етикет"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("লেবেল"),
            keywords: &["লেবেল"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("tikedenn"),
            keywords: &["tikedenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("etiketa"),
            keywords: &["etiketa"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("etiqueta"),
            keywords: &["etiqueta"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎪᏪᎸᎢ"),
            keywords: &["ᎪᏪᎸᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("visačka"),
            keywords: &["cedulka", "cenovka", "jmenovka", "visačka", "štítek"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("label"),
            keywords: &["label"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mærkat"),
            keywords: &["etiket", "label", "mærkat", "seddel"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Etikett"),
            keywords: &["Etikett", "Label", "Marke"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ετικέτα"),
            keywords: &["ετικέτα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("label"),
            keywords: &["label"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["label", "tag"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("etiqueta"),
            keywords: &["etiqueta"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("silt"),
            keywords: &["silt"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("etiketa"),
            keywords: &["etiketa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("برچسب"),
            keywords: &["اتیکت", "اتیکت زدن", "برچسب", "برچسب زدن", "علامت"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("lappu"),
            keywords: &["etiketti", "kortti", "lappu", "lipuke"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("label"),
            keywords: &["etiketa", "label", "tatak"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("merkiseðil"),
            keywords: &["merkiseðil", "navnaseðil", "seðil", "spjaldur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("étiquette"),
            keywords: &["étiquette"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("lipéad"),
            keywords: &["lipéad"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bileag"),
            keywords: &["bileag", "leubail"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("etiqueta"),
            keywords: &["etiqueta"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લ\u{ac7}બલ"),
            keywords: &["લ\u{ac7}બલ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("alama"),
            keywords: &["alama"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("תווית"),
            keywords: &["סימון", "תוויות", "תווית", "תיוג"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ल\u{947}बल"),
            keywords: &["ल\u{947}बल"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("oznaka"),
            keywords: &["oznaka"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("címke"),
            keywords: &["címke"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("պիտակ"),
            keywords: &["պիտակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("label"),
            keywords: &["label"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nnyeaha"),
            keywords: &["nnyeaha"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("merkimiði"),
            keywords: &["merki", "merkimiði"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("etichetta"),
            keywords: &["etichetta", "identificativo", "talloncino"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("荷札"),
            keywords: &["タグ", "ラベル", "荷札"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("label tenger"),
            keywords: &["label tenger"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("იარლიყი"),
            keywords: &["იარლიყი", "ლეიბლი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tabzimt"),
            keywords: &["tabzimt"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("затбелгі"),
            keywords: &["затбелгі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("label"),
            keywords: &["etiket", "label", "mærkat", "seddel"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}លាក"),
            keywords: &["ស\u{17d2}លាក", "ស\u{17d2}លាកឈ\u{17d2}មោះ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಲೇಬಲ\u{ccd}"),
            keywords: &["ಲೇಬಲ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("라벨"),
            keywords: &["라벨", "택"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ल\u{947}बल"),
            keywords: &["ल\u{947}बल"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("энбелги"),
            keywords: &["белги", "энбелги"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Etikett"),
            keywords: &["Etikett"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{ec9}າຍກຳກ\u{eb1}ບ"),
            keywords: &["ປ\u{ec9}າຍກຳກ\u{eb1}ບ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("etiketė"),
            keywords: &["etiketė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("atzīme"),
            keywords: &["atzīme"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tapanga"),
            keywords: &["tapanga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("етикета"),
            keywords: &["етикета"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ലേബൽ"),
            keywords: &["ലേബൽ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("шошго"),
            keywords: &["шошго"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ल\u{947}बल"),
            keywords: &["ल\u{947}बल"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("label"),
            keywords: &["label"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("tikketta"),
            keywords: &["tikketta"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တ\u{1036}ဆ\u{102d}ပ\u{103a}"),
            keywords: &["တ\u{1036}ဆ\u{102d}ပ\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("etikett"),
            keywords: &["etikett", "merke"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ल\u{947}बल"),
            keywords: &["ल\u{947}बल"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("label"),
            keywords: &["label"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("etikett"),
            keywords: &["etikett", "merke"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଲେବ\u{b41}ଲ\u{b4d}\u{200c}"),
            keywords: &["ଲେବ\u{b41}ଲ\u{b4d}\u{200c}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲ\u{a47}ਬਲ"),
            keywords: &["ਮ\u{a4b}ਹਰ", "ਲ\u{a47}ਬਲ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سرنامہ"),
            keywords: &["سرنامہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Lébẹl"),
            keywords: &["Lébẹl"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("przywieszka do kluczy"),
            keywords: &["breloczek", "etykieta", "przywieszka do kluczy"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لیبل"),
            keywords: &["لیبل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("etiqueta"),
            keywords: &["etiqueta", "rótulo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("sutichaq"),
            keywords: &["sutichaq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("etichetă"),
            keywords: &["etichetă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-436"),
            keywords: &["E10-436"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("бирка"),
            keywords: &["бирка", "сведения", "этикетка", "ярлык"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("akarango"),
            keywords: &["akarango"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٺپو"),
            keywords: &["ٺپو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ලේබලය"),
            keywords: &["ලේබලය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("štítok"),
            keywords: &["ceduľka", "menovka", "štítok"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("etiketa"),
            keywords: &["etiketa", "nalepka", "oznaka"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("warqad wax sheegaysa"),
            keywords: &["warqad wax sheegaysa"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("etiketë"),
            keywords: &["etiketë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("ознака"),
            keywords: &["ознака"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["ознака"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("oznaka"),
            keywords: &["oznaka"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["oznaka"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("etikett"),
            keywords: &["etikett"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("lebo"),
            keywords: &["lebo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("லேபிள\u{bcd}"),
            keywords: &["அட\u{bcd}டை", "மஞ\u{bcd}சள\u{bcd}", "லேபிள\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ల\u{c47}బుల\u{c4d}"),
            keywords: &["చ\u{c40}ట\u{c40}", "ల\u{c47}బుల\u{c4d}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тамға"),
            keywords: &["тамға"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ป\u{e49}าย"),
            keywords: &["ป\u{e49}าย"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("tagma"),
            keywords: &["tagma"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakaʻilonga"),
            keywords: &["fakaʻilonga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("etiket"),
            keywords: &["etiket"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("خەتكۈچ"),
            keywords: &["خەتكۈچ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("бирка"),
            keywords: &["бирка", "ярлик"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("لیبل"),
            keywords: &["لیبل", "ٹیگ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yorliq"),
            keywords: &["yorliq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nhãn"),
            keywords: &["nhãn"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("màndarga"),
            keywords: &["màndarga"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ileyibhuli"),
            keywords: &["ileyibhuli"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àkọ\u{301}lé"),
            keywords: &["àkọ\u{301}lé"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("標籤"),
            keywords: &["標籤"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("标签"),
            keywords: &["标签"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("标签"),
            keywords: &["吊牌", "标签", "标记", "行李牌"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("吊牌"),
            keywords: &["吊牌", "標籤"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("標籤"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ilebula"),
            keywords: &["ilebula"],
        },
    ],
};
