#[doc = " Total number of names available for lookup"]
pub fn num_names() -> usize {
    NAME_LOOKUP_MAP.len()
}
#[doc = " Is the name provided documented in this crate?"]
pub fn contains_name(name: &str) -> bool {
    NAME_LOOKUP_MAP.contains_key(name)
}
#[doc = " Get the [Emoji](../struct.Emoji.html) associated with this name"]
pub fn lookup(name: &str) -> Option<&'static crate::Emoji> {
    NAME_LOOKUP_MAP.get(name)
}
#[doc = " An iterator over every name->[Emoji](../struct.Emoji.html) pair  "]
#[doc = " Does not include variants"]
pub fn iter_name_emoji() -> phf::map::Entries<'static, &'static str, crate::Emoji> {
    NAME_LOOKUP_MAP.entries()
}
#[doc = " An iterator over every name"]
pub fn iter_name() -> phf::map::Keys<'static, &'static str, crate::Emoji> {
    NAME_LOOKUP_MAP.keys()
}
#[doc = " An iterator over every [Emoji](../struct.Emoji.html)  "]
#[doc = " Does not include variants"]
pub fn iter_emoji() -> phf::map::Values<'static, &'static str, crate::Emoji> {
    NAME_LOOKUP_MAP.values()
}
static NAME_LOOKUP_MAP: phf::Map<&'static str, crate::Emoji> = phf::phf_map! { "grinning face" => crate :: smileys_and_emotion :: face_smiling :: GRINNING_FACE , "grinning face with big eyes" => crate :: smileys_and_emotion :: face_smiling :: GRINNING_FACE_WITH_BIG_EYES , "grinning face with smiling eyes" => crate :: smileys_and_emotion :: face_smiling :: GRINNING_FACE_WITH_SMILING_EYES , "beaming face with smiling eyes" => crate :: smileys_and_emotion :: face_smiling :: BEAMING_FACE_WITH_SMILING_EYES , "grinning squinting face" => crate :: smileys_and_emotion :: face_smiling :: GRINNING_SQUINTING_FACE , "grinning face with sweat" => crate :: smileys_and_emotion :: face_smiling :: GRINNING_FACE_WITH_SWEAT , "rolling on the floor laughing" => crate :: smileys_and_emotion :: face_smiling :: ROLLING_ON_THE_FLOOR_LAUGHING , "face with tears of joy" => crate :: smileys_and_emotion :: face_smiling :: FACE_WITH_TEARS_OF_JOY , "slightly smiling face" => crate :: smileys_and_emotion :: face_smiling :: SLIGHTLY_SMILING_FACE , "upside-down face" => crate :: smileys_and_emotion :: face_smiling :: UPSIDE_DOWN_FACE , "winking face" => crate :: smileys_and_emotion :: face_smiling :: WINKING_FACE , "smiling face with smiling eyes" => crate :: smileys_and_emotion :: face_smiling :: SMILING_FACE_WITH_SMILING_EYES , "smiling face with halo" => crate :: smileys_and_emotion :: face_smiling :: SMILING_FACE_WITH_HALO , "smiling face with hearts" => crate :: smileys_and_emotion :: face_affection :: SMILING_FACE_WITH_HEARTS , "smiling face with heart-eyes" => crate :: smileys_and_emotion :: face_affection :: SMILING_FACE_WITH_HEART_EYES , "star-struck" => crate :: smileys_and_emotion :: face_affection :: STAR_STRUCK , "face blowing a kiss" => crate :: smileys_and_emotion :: face_affection :: FACE_BLOWING_A_KISS , "kissing face" => crate :: smileys_and_emotion :: face_affection :: KISSING_FACE , "smiling face" => crate :: smileys_and_emotion :: face_affection :: SMILING_FACE , "kissing face with closed eyes" => crate :: smileys_and_emotion :: face_affection :: KISSING_FACE_WITH_CLOSED_EYES , "kissing face with smiling eyes" => crate :: smileys_and_emotion :: face_affection :: KISSING_FACE_WITH_SMILING_EYES , "smiling face with tear" => crate :: smileys_and_emotion :: face_affection :: SMILING_FACE_WITH_TEAR , "face savoring food" => crate :: smileys_and_emotion :: face_tongue :: FACE_SAVORING_FOOD , "face with tongue" => crate :: smileys_and_emotion :: face_tongue :: FACE_WITH_TONGUE , "winking face with tongue" => crate :: smileys_and_emotion :: face_tongue :: WINKING_FACE_WITH_TONGUE , "zany face" => crate :: smileys_and_emotion :: face_tongue :: ZANY_FACE , "squinting face with tongue" => crate :: smileys_and_emotion :: face_tongue :: SQUINTING_FACE_WITH_TONGUE , "money-mouth face" => crate :: smileys_and_emotion :: face_tongue :: MONEY_MOUTH_FACE , "hugging face" => crate :: smileys_and_emotion :: face_hand :: HUGGING_FACE , "face with hand over mouth" => crate :: smileys_and_emotion :: face_hand :: FACE_WITH_HAND_OVER_MOUTH , "shushing face" => crate :: smileys_and_emotion :: face_hand :: SHUSHING_FACE , "thinking face" => crate :: smileys_and_emotion :: face_hand :: THINKING_FACE , "zipper-mouth face" => crate :: smileys_and_emotion :: face_neutral_skeptical :: ZIPPER_MOUTH_FACE , "face with raised eyebrow" => crate :: smileys_and_emotion :: face_neutral_skeptical :: FACE_WITH_RAISED_EYEBROW , "neutral face" => crate :: smileys_and_emotion :: face_neutral_skeptical :: NEUTRAL_FACE , "expressionless face" => crate :: smileys_and_emotion :: face_neutral_skeptical :: EXPRESSIONLESS_FACE , "face without mouth" => crate :: smileys_and_emotion :: face_neutral_skeptical :: FACE_WITHOUT_MOUTH , "face in clouds" => crate :: smileys_and_emotion :: face_neutral_skeptical :: FACE_IN_CLOUDS , "smirking face" => crate :: smileys_and_emotion :: face_neutral_skeptical :: SMIRKING_FACE , "unamused face" => crate :: smileys_and_emotion :: face_neutral_skeptical :: UNAMUSED_FACE , "face with rolling eyes" => crate :: smileys_and_emotion :: face_neutral_skeptical :: FACE_WITH_ROLLING_EYES , "grimacing face" => crate :: smileys_and_emotion :: face_neutral_skeptical :: GRIMACING_FACE , "face exhaling" => crate :: smileys_and_emotion :: face_neutral_skeptical :: FACE_EXHALING , "lying face" => crate :: smileys_and_emotion :: face_neutral_skeptical :: LYING_FACE , "relieved face" => crate :: smileys_and_emotion :: face_sleepy :: RELIEVED_FACE , "pensive face" => crate :: smileys_and_emotion :: face_sleepy :: PENSIVE_FACE , "sleepy face" => crate :: smileys_and_emotion :: face_sleepy :: SLEEPY_FACE , "drooling face" => crate :: smileys_and_emotion :: face_sleepy :: DROOLING_FACE , "sleeping face" => crate :: smileys_and_emotion :: face_sleepy :: SLEEPING_FACE , "face with medical mask" => crate :: smileys_and_emotion :: face_unwell :: FACE_WITH_MEDICAL_MASK , "face with thermometer" => crate :: smileys_and_emotion :: face_unwell :: FACE_WITH_THERMOMETER , "face with head-bandage" => crate :: smileys_and_emotion :: face_unwell :: FACE_WITH_HEAD_BANDAGE , "nauseated face" => crate :: smileys_and_emotion :: face_unwell :: NAUSEATED_FACE , "face vomiting" => crate :: smileys_and_emotion :: face_unwell :: FACE_VOMITING , "sneezing face" => crate :: smileys_and_emotion :: face_unwell :: SNEEZING_FACE , "hot face" => crate :: smileys_and_emotion :: face_unwell :: HOT_FACE , "cold face" => crate :: smileys_and_emotion :: face_unwell :: COLD_FACE , "woozy face" => crate :: smileys_and_emotion :: face_unwell :: WOOZY_FACE , "knocked-out face" => crate :: smileys_and_emotion :: face_unwell :: KNOCKED_OUT_FACE , "face with spiral eyes" => crate :: smileys_and_emotion :: face_unwell :: FACE_WITH_SPIRAL_EYES , "exploding head" => crate :: smileys_and_emotion :: face_unwell :: EXPLODING_HEAD , "cowboy hat face" => crate :: smileys_and_emotion :: face_hat :: COWBOY_HAT_FACE , "partying face" => crate :: smileys_and_emotion :: face_hat :: PARTYING_FACE , "disguised face" => crate :: smileys_and_emotion :: face_hat :: DISGUISED_FACE , "smiling face with sunglasses" => crate :: smileys_and_emotion :: face_glasses :: SMILING_FACE_WITH_SUNGLASSES , "nerd face" => crate :: smileys_and_emotion :: face_glasses :: NERD_FACE , "face with monocle" => crate :: smileys_and_emotion :: face_glasses :: FACE_WITH_MONOCLE , "confused face" => crate :: smileys_and_emotion :: face_concerned :: CONFUSED_FACE , "worried face" => crate :: smileys_and_emotion :: face_concerned :: WORRIED_FACE , "slightly frowning face" => crate :: smileys_and_emotion :: face_concerned :: SLIGHTLY_FROWNING_FACE , "frowning face" => crate :: smileys_and_emotion :: face_concerned :: FROWNING_FACE , "face with open mouth" => crate :: smileys_and_emotion :: face_concerned :: FACE_WITH_OPEN_MOUTH , "hushed face" => crate :: smileys_and_emotion :: face_concerned :: HUSHED_FACE , "astonished face" => crate :: smileys_and_emotion :: face_concerned :: ASTONISHED_FACE , "flushed face" => crate :: smileys_and_emotion :: face_concerned :: FLUSHED_FACE , "pleading face" => crate :: smileys_and_emotion :: face_concerned :: PLEADING_FACE , "frowning face with open mouth" => crate :: smileys_and_emotion :: face_concerned :: FROWNING_FACE_WITH_OPEN_MOUTH , "anguished face" => crate :: smileys_and_emotion :: face_concerned :: ANGUISHED_FACE , "fearful face" => crate :: smileys_and_emotion :: face_concerned :: FEARFUL_FACE , "anxious face with sweat" => crate :: smileys_and_emotion :: face_concerned :: ANXIOUS_FACE_WITH_SWEAT , "sad but relieved face" => crate :: smileys_and_emotion :: face_concerned :: SAD_BUT_RELIEVED_FACE , "crying face" => crate :: smileys_and_emotion :: face_concerned :: CRYING_FACE , "loudly crying face" => crate :: smileys_and_emotion :: face_concerned :: LOUDLY_CRYING_FACE , "face screaming in fear" => crate :: smileys_and_emotion :: face_concerned :: FACE_SCREAMING_IN_FEAR , "confounded face" => crate :: smileys_and_emotion :: face_concerned :: CONFOUNDED_FACE , "persevering face" => crate :: smileys_and_emotion :: face_concerned :: PERSEVERING_FACE , "disappointed face" => crate :: smileys_and_emotion :: face_concerned :: DISAPPOINTED_FACE , "downcast face with sweat" => crate :: smileys_and_emotion :: face_concerned :: DOWNCAST_FACE_WITH_SWEAT , "weary face" => crate :: smileys_and_emotion :: face_concerned :: WEARY_FACE , "tired face" => crate :: smileys_and_emotion :: face_concerned :: TIRED_FACE , "yawning face" => crate :: smileys_and_emotion :: face_concerned :: YAWNING_FACE , "face with steam from nose" => crate :: smileys_and_emotion :: face_negative :: FACE_WITH_STEAM_FROM_NOSE , "pouting face" => crate :: smileys_and_emotion :: face_negative :: POUTING_FACE , "angry face" => crate :: smileys_and_emotion :: face_negative :: ANGRY_FACE , "face with symbols on mouth" => crate :: smileys_and_emotion :: face_negative :: FACE_WITH_SYMBOLS_ON_MOUTH , "smiling face with horns" => crate :: smileys_and_emotion :: face_negative :: SMILING_FACE_WITH_HORNS , "angry face with horns" => crate :: smileys_and_emotion :: face_negative :: ANGRY_FACE_WITH_HORNS , "skull" => crate :: smileys_and_emotion :: face_negative :: SKULL , "skull and crossbones" => crate :: smileys_and_emotion :: face_negative :: SKULL_AND_CROSSBONES , "pile of poo" => crate :: smileys_and_emotion :: face_costume :: PILE_OF_POO , "clown face" => crate :: smileys_and_emotion :: face_costume :: CLOWN_FACE , "ogre" => crate :: smileys_and_emotion :: face_costume :: OGRE , "goblin" => crate :: smileys_and_emotion :: face_costume :: GOBLIN , "ghost" => crate :: smileys_and_emotion :: face_costume :: GHOST , "alien" => crate :: smileys_and_emotion :: face_costume :: ALIEN , "alien monster" => crate :: smileys_and_emotion :: face_costume :: ALIEN_MONSTER , "robot" => crate :: smileys_and_emotion :: face_costume :: ROBOT , "grinning cat" => crate :: smileys_and_emotion :: cat_face :: GRINNING_CAT , "grinning cat with smiling eyes" => crate :: smileys_and_emotion :: cat_face :: GRINNING_CAT_WITH_SMILING_EYES , "cat with tears of joy" => crate :: smileys_and_emotion :: cat_face :: CAT_WITH_TEARS_OF_JOY , "smiling cat with heart-eyes" => crate :: smileys_and_emotion :: cat_face :: SMILING_CAT_WITH_HEART_EYES , "cat with wry smile" => crate :: smileys_and_emotion :: cat_face :: CAT_WITH_WRY_SMILE , "kissing cat" => crate :: smileys_and_emotion :: cat_face :: KISSING_CAT , "weary cat" => crate :: smileys_and_emotion :: cat_face :: WEARY_CAT , "crying cat" => crate :: smileys_and_emotion :: cat_face :: CRYING_CAT , "pouting cat" => crate :: smileys_and_emotion :: cat_face :: POUTING_CAT , "see-no-evil monkey" => crate :: smileys_and_emotion :: monkey_face :: SEE_NO_EVIL_MONKEY , "hear-no-evil monkey" => crate :: smileys_and_emotion :: monkey_face :: HEAR_NO_EVIL_MONKEY , "speak-no-evil monkey" => crate :: smileys_and_emotion :: monkey_face :: SPEAK_NO_EVIL_MONKEY , "kiss mark" => crate :: smileys_and_emotion :: emotion :: KISS_MARK , "love letter" => crate :: smileys_and_emotion :: emotion :: LOVE_LETTER , "heart with arrow" => crate :: smileys_and_emotion :: emotion :: HEART_WITH_ARROW , "heart with ribbon" => crate :: smileys_and_emotion :: emotion :: HEART_WITH_RIBBON , "sparkling heart" => crate :: smileys_and_emotion :: emotion :: SPARKLING_HEART , "growing heart" => crate :: smileys_and_emotion :: emotion :: GROWING_HEART , "beating heart" => crate :: smileys_and_emotion :: emotion :: BEATING_HEART , "revolving hearts" => crate :: smileys_and_emotion :: emotion :: REVOLVING_HEARTS , "two hearts" => crate :: smileys_and_emotion :: emotion :: TWO_HEARTS , "heart decoration" => crate :: smileys_and_emotion :: emotion :: HEART_DECORATION , "heart exclamation" => crate :: smileys_and_emotion :: emotion :: HEART_EXCLAMATION , "broken heart" => crate :: smileys_and_emotion :: emotion :: BROKEN_HEART , "heart on fire" => crate :: smileys_and_emotion :: emotion :: HEART_ON_FIRE , "mending heart" => crate :: smileys_and_emotion :: emotion :: MENDING_HEART , "red heart" => crate :: smileys_and_emotion :: emotion :: RED_HEART , "orange heart" => crate :: smileys_and_emotion :: emotion :: ORANGE_HEART , "yellow heart" => crate :: smileys_and_emotion :: emotion :: YELLOW_HEART , "green heart" => crate :: smileys_and_emotion :: emotion :: GREEN_HEART , "blue heart" => crate :: smileys_and_emotion :: emotion :: BLUE_HEART , "purple heart" => crate :: smileys_and_emotion :: emotion :: PURPLE_HEART , "brown heart" => crate :: smileys_and_emotion :: emotion :: BROWN_HEART , "black heart" => crate :: smileys_and_emotion :: emotion :: BLACK_HEART , "white heart" => crate :: smileys_and_emotion :: emotion :: WHITE_HEART , "hundred points" => crate :: smileys_and_emotion :: emotion :: HUNDRED_POINTS , "anger symbol" => crate :: smileys_and_emotion :: emotion :: ANGER_SYMBOL , "collision" => crate :: smileys_and_emotion :: emotion :: COLLISION , "dizzy" => crate :: smileys_and_emotion :: emotion :: DIZZY , "sweat droplets" => crate :: smileys_and_emotion :: emotion :: SWEAT_DROPLETS , "dashing away" => crate :: smileys_and_emotion :: emotion :: DASHING_AWAY , "hole" => crate :: smileys_and_emotion :: emotion :: HOLE , "bomb" => crate :: smileys_and_emotion :: emotion :: BOMB , "speech balloon" => crate :: smileys_and_emotion :: emotion :: SPEECH_BALLOON , "eye in speech bubble" => crate :: smileys_and_emotion :: emotion :: EYE_IN_SPEECH_BUBBLE , "left speech bubble" => crate :: smileys_and_emotion :: emotion :: LEFT_SPEECH_BUBBLE , "right anger bubble" => crate :: smileys_and_emotion :: emotion :: RIGHT_ANGER_BUBBLE , "thought balloon" => crate :: smileys_and_emotion :: emotion :: THOUGHT_BALLOON , "zzz" => crate :: smileys_and_emotion :: emotion :: ZZZ , "waving hand" => crate :: people_and_body :: hand_fingers_open :: WAVING_HAND , "waving hand: light skin tone" => crate :: people_and_body :: hand_fingers_open :: WAVING_HAND_LIGHT_SKIN_TONE , "waving hand: medium-light skin tone" => crate :: people_and_body :: hand_fingers_open :: WAVING_HAND_MEDIUM_LIGHT_SKIN_TONE , "waving hand: medium skin tone" => crate :: people_and_body :: hand_fingers_open :: WAVING_HAND_MEDIUM_SKIN_TONE , "waving hand: medium-dark skin tone" => crate :: people_and_body :: hand_fingers_open :: WAVING_HAND_MEDIUM_DARK_SKIN_TONE , "waving hand: dark skin tone" => crate :: people_and_body :: hand_fingers_open :: WAVING_HAND_DARK_SKIN_TONE , "raised back of hand" => crate :: people_and_body :: hand_fingers_open :: RAISED_BACK_OF_HAND , "raised back of hand: light skin tone" => crate :: people_and_body :: hand_fingers_open :: RAISED_BACK_OF_HAND_LIGHT_SKIN_TONE , "raised back of hand: medium-light skin tone" => crate :: people_and_body :: hand_fingers_open :: RAISED_BACK_OF_HAND_MEDIUM_LIGHT_SKIN_TONE , "raised back of hand: medium skin tone" => crate :: people_and_body :: hand_fingers_open :: RAISED_BACK_OF_HAND_MEDIUM_SKIN_TONE , "raised back of hand: medium-dark skin tone" => crate :: people_and_body :: hand_fingers_open :: RAISED_BACK_OF_HAND_MEDIUM_DARK_SKIN_TONE , "raised back of hand: dark skin tone" => crate :: people_and_body :: hand_fingers_open :: RAISED_BACK_OF_HAND_DARK_SKIN_TONE , "hand with fingers splayed" => crate :: people_and_body :: hand_fingers_open :: HAND_WITH_FINGERS_SPLAYED , "hand with fingers splayed: light skin tone" => crate :: people_and_body :: hand_fingers_open :: HAND_WITH_FINGERS_SPLAYED_LIGHT_SKIN_TONE , "hand with fingers splayed: medium-light skin tone" => crate :: people_and_body :: hand_fingers_open :: HAND_WITH_FINGERS_SPLAYED_MEDIUM_LIGHT_SKIN_TONE , "hand with fingers splayed: medium skin tone" => crate :: people_and_body :: hand_fingers_open :: HAND_WITH_FINGERS_SPLAYED_MEDIUM_SKIN_TONE , "hand with fingers splayed: medium-dark skin tone" => crate :: people_and_body :: hand_fingers_open :: HAND_WITH_FINGERS_SPLAYED_MEDIUM_DARK_SKIN_TONE , "hand with fingers splayed: dark skin tone" => crate :: people_and_body :: hand_fingers_open :: HAND_WITH_FINGERS_SPLAYED_DARK_SKIN_TONE , "raised hand" => crate :: people_and_body :: hand_fingers_open :: RAISED_HAND , "raised hand: light skin tone" => crate :: people_and_body :: hand_fingers_open :: RAISED_HAND_LIGHT_SKIN_TONE , "raised hand: medium-light skin tone" => crate :: people_and_body :: hand_fingers_open :: RAISED_HAND_MEDIUM_LIGHT_SKIN_TONE , "raised hand: medium skin tone" => crate :: people_and_body :: hand_fingers_open :: RAISED_HAND_MEDIUM_SKIN_TONE , "raised hand: medium-dark skin tone" => crate :: people_and_body :: hand_fingers_open :: RAISED_HAND_MEDIUM_DARK_SKIN_TONE , "raised hand: dark skin tone" => crate :: people_and_body :: hand_fingers_open :: RAISED_HAND_DARK_SKIN_TONE , "vulcan salute" => crate :: people_and_body :: hand_fingers_open :: VULCAN_SALUTE , "vulcan salute: light skin tone" => crate :: people_and_body :: hand_fingers_open :: VULCAN_SALUTE_LIGHT_SKIN_TONE , "vulcan salute: medium-light skin tone" => crate :: people_and_body :: hand_fingers_open :: VULCAN_SALUTE_MEDIUM_LIGHT_SKIN_TONE , "vulcan salute: medium skin tone" => crate :: people_and_body :: hand_fingers_open :: VULCAN_SALUTE_MEDIUM_SKIN_TONE , "vulcan salute: medium-dark skin tone" => crate :: people_and_body :: hand_fingers_open :: VULCAN_SALUTE_MEDIUM_DARK_SKIN_TONE , "vulcan salute: dark skin tone" => crate :: people_and_body :: hand_fingers_open :: VULCAN_SALUTE_DARK_SKIN_TONE , "OK hand" => crate :: people_and_body :: hand_fingers_partial :: OK_HAND , "OK hand: light skin tone" => crate :: people_and_body :: hand_fingers_partial :: OK_HAND_LIGHT_SKIN_TONE , "OK hand: medium-light skin tone" => crate :: people_and_body :: hand_fingers_partial :: OK_HAND_MEDIUM_LIGHT_SKIN_TONE , "OK hand: medium skin tone" => crate :: people_and_body :: hand_fingers_partial :: OK_HAND_MEDIUM_SKIN_TONE , "OK hand: medium-dark skin tone" => crate :: people_and_body :: hand_fingers_partial :: OK_HAND_MEDIUM_DARK_SKIN_TONE , "OK hand: dark skin tone" => crate :: people_and_body :: hand_fingers_partial :: OK_HAND_DARK_SKIN_TONE , "pinched fingers" => crate :: people_and_body :: hand_fingers_partial :: PINCHED_FINGERS , "pinched fingers: light skin tone" => crate :: people_and_body :: hand_fingers_partial :: PINCHED_FINGERS_LIGHT_SKIN_TONE , "pinched fingers: medium-light skin tone" => crate :: people_and_body :: hand_fingers_partial :: PINCHED_FINGERS_MEDIUM_LIGHT_SKIN_TONE , "pinched fingers: medium skin tone" => crate :: people_and_body :: hand_fingers_partial :: PINCHED_FINGERS_MEDIUM_SKIN_TONE , "pinched fingers: medium-dark skin tone" => crate :: people_and_body :: hand_fingers_partial :: PINCHED_FINGERS_MEDIUM_DARK_SKIN_TONE , "pinched fingers: dark skin tone" => crate :: people_and_body :: hand_fingers_partial :: PINCHED_FINGERS_DARK_SKIN_TONE , "pinching hand" => crate :: people_and_body :: hand_fingers_partial :: PINCHING_HAND , "pinching hand: light skin tone" => crate :: people_and_body :: hand_fingers_partial :: PINCHING_HAND_LIGHT_SKIN_TONE , "pinching hand: medium-light skin tone" => crate :: people_and_body :: hand_fingers_partial :: PINCHING_HAND_MEDIUM_LIGHT_SKIN_TONE , "pinching hand: medium skin tone" => crate :: people_and_body :: hand_fingers_partial :: PINCHING_HAND_MEDIUM_SKIN_TONE , "pinching hand: medium-dark skin tone" => crate :: people_and_body :: hand_fingers_partial :: PINCHING_HAND_MEDIUM_DARK_SKIN_TONE , "pinching hand: dark skin tone" => crate :: people_and_body :: hand_fingers_partial :: PINCHING_HAND_DARK_SKIN_TONE , "victory hand" => crate :: people_and_body :: hand_fingers_partial :: VICTORY_HAND , "victory hand: light skin tone" => crate :: people_and_body :: hand_fingers_partial :: VICTORY_HAND_LIGHT_SKIN_TONE , "victory hand: medium-light skin tone" => crate :: people_and_body :: hand_fingers_partial :: VICTORY_HAND_MEDIUM_LIGHT_SKIN_TONE , "victory hand: medium skin tone" => crate :: people_and_body :: hand_fingers_partial :: VICTORY_HAND_MEDIUM_SKIN_TONE , "victory hand: medium-dark skin tone" => crate :: people_and_body :: hand_fingers_partial :: VICTORY_HAND_MEDIUM_DARK_SKIN_TONE , "victory hand: dark skin tone" => crate :: people_and_body :: hand_fingers_partial :: VICTORY_HAND_DARK_SKIN_TONE , "crossed fingers" => crate :: people_and_body :: hand_fingers_partial :: CROSSED_FINGERS , "crossed fingers: light skin tone" => crate :: people_and_body :: hand_fingers_partial :: CROSSED_FINGERS_LIGHT_SKIN_TONE , "crossed fingers: medium-light skin tone" => crate :: people_and_body :: hand_fingers_partial :: CROSSED_FINGERS_MEDIUM_LIGHT_SKIN_TONE , "crossed fingers: medium skin tone" => crate :: people_and_body :: hand_fingers_partial :: CROSSED_FINGERS_MEDIUM_SKIN_TONE , "crossed fingers: medium-dark skin tone" => crate :: people_and_body :: hand_fingers_partial :: CROSSED_FINGERS_MEDIUM_DARK_SKIN_TONE , "crossed fingers: dark skin tone" => crate :: people_and_body :: hand_fingers_partial :: CROSSED_FINGERS_DARK_SKIN_TONE , "love-you gesture" => crate :: people_and_body :: hand_fingers_partial :: LOVE_YOU_GESTURE , "love-you gesture: light skin tone" => crate :: people_and_body :: hand_fingers_partial :: LOVE_YOU_GESTURE_LIGHT_SKIN_TONE , "love-you gesture: medium-light skin tone" => crate :: people_and_body :: hand_fingers_partial :: LOVE_YOU_GESTURE_MEDIUM_LIGHT_SKIN_TONE , "love-you gesture: medium skin tone" => crate :: people_and_body :: hand_fingers_partial :: LOVE_YOU_GESTURE_MEDIUM_SKIN_TONE , "love-you gesture: medium-dark skin tone" => crate :: people_and_body :: hand_fingers_partial :: LOVE_YOU_GESTURE_MEDIUM_DARK_SKIN_TONE , "love-you gesture: dark skin tone" => crate :: people_and_body :: hand_fingers_partial :: LOVE_YOU_GESTURE_DARK_SKIN_TONE , "sign of the horns" => crate :: people_and_body :: hand_fingers_partial :: SIGN_OF_THE_HORNS , "sign of the horns: light skin tone" => crate :: people_and_body :: hand_fingers_partial :: SIGN_OF_THE_HORNS_LIGHT_SKIN_TONE , "sign of the horns: medium-light skin tone" => crate :: people_and_body :: hand_fingers_partial :: SIGN_OF_THE_HORNS_MEDIUM_LIGHT_SKIN_TONE , "sign of the horns: medium skin tone" => crate :: people_and_body :: hand_fingers_partial :: SIGN_OF_THE_HORNS_MEDIUM_SKIN_TONE , "sign of the horns: medium-dark skin tone" => crate :: people_and_body :: hand_fingers_partial :: SIGN_OF_THE_HORNS_MEDIUM_DARK_SKIN_TONE , "sign of the horns: dark skin tone" => crate :: people_and_body :: hand_fingers_partial :: SIGN_OF_THE_HORNS_DARK_SKIN_TONE , "call me hand" => crate :: people_and_body :: hand_fingers_partial :: CALL_ME_HAND , "call me hand: light skin tone" => crate :: people_and_body :: hand_fingers_partial :: CALL_ME_HAND_LIGHT_SKIN_TONE , "call me hand: medium-light skin tone" => crate :: people_and_body :: hand_fingers_partial :: CALL_ME_HAND_MEDIUM_LIGHT_SKIN_TONE , "call me hand: medium skin tone" => crate :: people_and_body :: hand_fingers_partial :: CALL_ME_HAND_MEDIUM_SKIN_TONE , "call me hand: medium-dark skin tone" => crate :: people_and_body :: hand_fingers_partial :: CALL_ME_HAND_MEDIUM_DARK_SKIN_TONE , "call me hand: dark skin tone" => crate :: people_and_body :: hand_fingers_partial :: CALL_ME_HAND_DARK_SKIN_TONE , "backhand index pointing left" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_LEFT , "backhand index pointing left: light skin tone" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_LEFT_LIGHT_SKIN_TONE , "backhand index pointing left: medium-light skin tone" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_LEFT_MEDIUM_LIGHT_SKIN_TONE , "backhand index pointing left: medium skin tone" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_LEFT_MEDIUM_SKIN_TONE , "backhand index pointing left: medium-dark skin tone" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_LEFT_MEDIUM_DARK_SKIN_TONE , "backhand index pointing left: dark skin tone" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_LEFT_DARK_SKIN_TONE , "backhand index pointing right" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_RIGHT , "backhand index pointing right: light skin tone" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_RIGHT_LIGHT_SKIN_TONE , "backhand index pointing right: medium-light skin tone" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_RIGHT_MEDIUM_LIGHT_SKIN_TONE , "backhand index pointing right: medium skin tone" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_RIGHT_MEDIUM_SKIN_TONE , "backhand index pointing right: medium-dark skin tone" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_RIGHT_MEDIUM_DARK_SKIN_TONE , "backhand index pointing right: dark skin tone" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_RIGHT_DARK_SKIN_TONE , "backhand index pointing up" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_UP , "backhand index pointing up: light skin tone" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_UP_LIGHT_SKIN_TONE , "backhand index pointing up: medium-light skin tone" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_UP_MEDIUM_LIGHT_SKIN_TONE , "backhand index pointing up: medium skin tone" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_UP_MEDIUM_SKIN_TONE , "backhand index pointing up: medium-dark skin tone" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_UP_MEDIUM_DARK_SKIN_TONE , "backhand index pointing up: dark skin tone" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_UP_DARK_SKIN_TONE , "middle finger" => crate :: people_and_body :: hand_single_finger :: MIDDLE_FINGER , "middle finger: light skin tone" => crate :: people_and_body :: hand_single_finger :: MIDDLE_FINGER_LIGHT_SKIN_TONE , "middle finger: medium-light skin tone" => crate :: people_and_body :: hand_single_finger :: MIDDLE_FINGER_MEDIUM_LIGHT_SKIN_TONE , "middle finger: medium skin tone" => crate :: people_and_body :: hand_single_finger :: MIDDLE_FINGER_MEDIUM_SKIN_TONE , "middle finger: medium-dark skin tone" => crate :: people_and_body :: hand_single_finger :: MIDDLE_FINGER_MEDIUM_DARK_SKIN_TONE , "middle finger: dark skin tone" => crate :: people_and_body :: hand_single_finger :: MIDDLE_FINGER_DARK_SKIN_TONE , "backhand index pointing down" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_DOWN , "backhand index pointing down: light skin tone" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_DOWN_LIGHT_SKIN_TONE , "backhand index pointing down: medium-light skin tone" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_DOWN_MEDIUM_LIGHT_SKIN_TONE , "backhand index pointing down: medium skin tone" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_DOWN_MEDIUM_SKIN_TONE , "backhand index pointing down: medium-dark skin tone" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_DOWN_MEDIUM_DARK_SKIN_TONE , "backhand index pointing down: dark skin tone" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_DOWN_DARK_SKIN_TONE , "index pointing up" => crate :: people_and_body :: hand_single_finger :: INDEX_POINTING_UP , "index pointing up: light skin tone" => crate :: people_and_body :: hand_single_finger :: INDEX_POINTING_UP_LIGHT_SKIN_TONE , "index pointing up: medium-light skin tone" => crate :: people_and_body :: hand_single_finger :: INDEX_POINTING_UP_MEDIUM_LIGHT_SKIN_TONE , "index pointing up: medium skin tone" => crate :: people_and_body :: hand_single_finger :: INDEX_POINTING_UP_MEDIUM_SKIN_TONE , "index pointing up: medium-dark skin tone" => crate :: people_and_body :: hand_single_finger :: INDEX_POINTING_UP_MEDIUM_DARK_SKIN_TONE , "index pointing up: dark skin tone" => crate :: people_and_body :: hand_single_finger :: INDEX_POINTING_UP_DARK_SKIN_TONE , "thumbs up" => crate :: people_and_body :: hand_fingers_closed :: THUMBS_UP , "thumbs up: light skin tone" => crate :: people_and_body :: hand_fingers_closed :: THUMBS_UP_LIGHT_SKIN_TONE , "thumbs up: medium-light skin tone" => crate :: people_and_body :: hand_fingers_closed :: THUMBS_UP_MEDIUM_LIGHT_SKIN_TONE , "thumbs up: medium skin tone" => crate :: people_and_body :: hand_fingers_closed :: THUMBS_UP_MEDIUM_SKIN_TONE , "thumbs up: medium-dark skin tone" => crate :: people_and_body :: hand_fingers_closed :: THUMBS_UP_MEDIUM_DARK_SKIN_TONE , "thumbs up: dark skin tone" => crate :: people_and_body :: hand_fingers_closed :: THUMBS_UP_DARK_SKIN_TONE , "thumbs down" => crate :: people_and_body :: hand_fingers_closed :: THUMBS_DOWN , "thumbs down: light skin tone" => crate :: people_and_body :: hand_fingers_closed :: THUMBS_DOWN_LIGHT_SKIN_TONE , "thumbs down: medium-light skin tone" => crate :: people_and_body :: hand_fingers_closed :: THUMBS_DOWN_MEDIUM_LIGHT_SKIN_TONE , "thumbs down: medium skin tone" => crate :: people_and_body :: hand_fingers_closed :: THUMBS_DOWN_MEDIUM_SKIN_TONE , "thumbs down: medium-dark skin tone" => crate :: people_and_body :: hand_fingers_closed :: THUMBS_DOWN_MEDIUM_DARK_SKIN_TONE , "thumbs down: dark skin tone" => crate :: people_and_body :: hand_fingers_closed :: THUMBS_DOWN_DARK_SKIN_TONE , "raised fist" => crate :: people_and_body :: hand_fingers_closed :: RAISED_FIST , "raised fist: light skin tone" => crate :: people_and_body :: hand_fingers_closed :: RAISED_FIST_LIGHT_SKIN_TONE , "raised fist: medium-light skin tone" => crate :: people_and_body :: hand_fingers_closed :: RAISED_FIST_MEDIUM_LIGHT_SKIN_TONE , "raised fist: medium skin tone" => crate :: people_and_body :: hand_fingers_closed :: RAISED_FIST_MEDIUM_SKIN_TONE , "raised fist: medium-dark skin tone" => crate :: people_and_body :: hand_fingers_closed :: RAISED_FIST_MEDIUM_DARK_SKIN_TONE , "raised fist: dark skin tone" => crate :: people_and_body :: hand_fingers_closed :: RAISED_FIST_DARK_SKIN_TONE , "oncoming fist" => crate :: people_and_body :: hand_fingers_closed :: ONCOMING_FIST , "oncoming fist: light skin tone" => crate :: people_and_body :: hand_fingers_closed :: ONCOMING_FIST_LIGHT_SKIN_TONE , "oncoming fist: medium-light skin tone" => crate :: people_and_body :: hand_fingers_closed :: ONCOMING_FIST_MEDIUM_LIGHT_SKIN_TONE , "oncoming fist: medium skin tone" => crate :: people_and_body :: hand_fingers_closed :: ONCOMING_FIST_MEDIUM_SKIN_TONE , "oncoming fist: medium-dark skin tone" => crate :: people_and_body :: hand_fingers_closed :: ONCOMING_FIST_MEDIUM_DARK_SKIN_TONE , "oncoming fist: dark skin tone" => crate :: people_and_body :: hand_fingers_closed :: ONCOMING_FIST_DARK_SKIN_TONE , "left-facing fist" => crate :: people_and_body :: hand_fingers_closed :: LEFT_FACING_FIST , "left-facing fist: light skin tone" => crate :: people_and_body :: hand_fingers_closed :: LEFT_FACING_FIST_LIGHT_SKIN_TONE , "left-facing fist: medium-light skin tone" => crate :: people_and_body :: hand_fingers_closed :: LEFT_FACING_FIST_MEDIUM_LIGHT_SKIN_TONE , "left-facing fist: medium skin tone" => crate :: people_and_body :: hand_fingers_closed :: LEFT_FACING_FIST_MEDIUM_SKIN_TONE , "left-facing fist: medium-dark skin tone" => crate :: people_and_body :: hand_fingers_closed :: LEFT_FACING_FIST_MEDIUM_DARK_SKIN_TONE , "left-facing fist: dark skin tone" => crate :: people_and_body :: hand_fingers_closed :: LEFT_FACING_FIST_DARK_SKIN_TONE , "right-facing fist" => crate :: people_and_body :: hand_fingers_closed :: RIGHT_FACING_FIST , "right-facing fist: light skin tone" => crate :: people_and_body :: hand_fingers_closed :: RIGHT_FACING_FIST_LIGHT_SKIN_TONE , "right-facing fist: medium-light skin tone" => crate :: people_and_body :: hand_fingers_closed :: RIGHT_FACING_FIST_MEDIUM_LIGHT_SKIN_TONE , "right-facing fist: medium skin tone" => crate :: people_and_body :: hand_fingers_closed :: RIGHT_FACING_FIST_MEDIUM_SKIN_TONE , "right-facing fist: medium-dark skin tone" => crate :: people_and_body :: hand_fingers_closed :: RIGHT_FACING_FIST_MEDIUM_DARK_SKIN_TONE , "right-facing fist: dark skin tone" => crate :: people_and_body :: hand_fingers_closed :: RIGHT_FACING_FIST_DARK_SKIN_TONE , "clapping hands" => crate :: people_and_body :: hands :: CLAPPING_HANDS , "clapping hands: light skin tone" => crate :: people_and_body :: hands :: CLAPPING_HANDS_LIGHT_SKIN_TONE , "clapping hands: medium-light skin tone" => crate :: people_and_body :: hands :: CLAPPING_HANDS_MEDIUM_LIGHT_SKIN_TONE , "clapping hands: medium skin tone" => crate :: people_and_body :: hands :: CLAPPING_HANDS_MEDIUM_SKIN_TONE , "clapping hands: medium-dark skin tone" => crate :: people_and_body :: hands :: CLAPPING_HANDS_MEDIUM_DARK_SKIN_TONE , "clapping hands: dark skin tone" => crate :: people_and_body :: hands :: CLAPPING_HANDS_DARK_SKIN_TONE , "raising hands" => crate :: people_and_body :: hands :: RAISING_HANDS , "raising hands: light skin tone" => crate :: people_and_body :: hands :: RAISING_HANDS_LIGHT_SKIN_TONE , "raising hands: medium-light skin tone" => crate :: people_and_body :: hands :: RAISING_HANDS_MEDIUM_LIGHT_SKIN_TONE , "raising hands: medium skin tone" => crate :: people_and_body :: hands :: RAISING_HANDS_MEDIUM_SKIN_TONE , "raising hands: medium-dark skin tone" => crate :: people_and_body :: hands :: RAISING_HANDS_MEDIUM_DARK_SKIN_TONE , "raising hands: dark skin tone" => crate :: people_and_body :: hands :: RAISING_HANDS_DARK_SKIN_TONE , "open hands" => crate :: people_and_body :: hands :: OPEN_HANDS , "open hands: light skin tone" => crate :: people_and_body :: hands :: OPEN_HANDS_LIGHT_SKIN_TONE , "open hands: medium-light skin tone" => crate :: people_and_body :: hands :: OPEN_HANDS_MEDIUM_LIGHT_SKIN_TONE , "open hands: medium skin tone" => crate :: people_and_body :: hands :: OPEN_HANDS_MEDIUM_SKIN_TONE , "open hands: medium-dark skin tone" => crate :: people_and_body :: hands :: OPEN_HANDS_MEDIUM_DARK_SKIN_TONE , "open hands: dark skin tone" => crate :: people_and_body :: hands :: OPEN_HANDS_DARK_SKIN_TONE , "palms up together" => crate :: people_and_body :: hands :: PALMS_UP_TOGETHER , "palms up together: light skin tone" => crate :: people_and_body :: hands :: PALMS_UP_TOGETHER_LIGHT_SKIN_TONE , "palms up together: medium-light skin tone" => crate :: people_and_body :: hands :: PALMS_UP_TOGETHER_MEDIUM_LIGHT_SKIN_TONE , "palms up together: medium skin tone" => crate :: people_and_body :: hands :: PALMS_UP_TOGETHER_MEDIUM_SKIN_TONE , "palms up together: medium-dark skin tone" => crate :: people_and_body :: hands :: PALMS_UP_TOGETHER_MEDIUM_DARK_SKIN_TONE , "palms up together: dark skin tone" => crate :: people_and_body :: hands :: PALMS_UP_TOGETHER_DARK_SKIN_TONE , "handshake" => crate :: people_and_body :: hands :: HANDSHAKE , "folded hands" => crate :: people_and_body :: hands :: FOLDED_HANDS , "folded hands: light skin tone" => crate :: people_and_body :: hands :: FOLDED_HANDS_LIGHT_SKIN_TONE , "folded hands: medium-light skin tone" => crate :: people_and_body :: hands :: FOLDED_HANDS_MEDIUM_LIGHT_SKIN_TONE , "folded hands: medium skin tone" => crate :: people_and_body :: hands :: FOLDED_HANDS_MEDIUM_SKIN_TONE , "folded hands: medium-dark skin tone" => crate :: people_and_body :: hands :: FOLDED_HANDS_MEDIUM_DARK_SKIN_TONE , "folded hands: dark skin tone" => crate :: people_and_body :: hands :: FOLDED_HANDS_DARK_SKIN_TONE , "writing hand" => crate :: people_and_body :: hand_prop :: WRITING_HAND , "writing hand: light skin tone" => crate :: people_and_body :: hand_prop :: WRITING_HAND_LIGHT_SKIN_TONE , "writing hand: medium-light skin tone" => crate :: people_and_body :: hand_prop :: WRITING_HAND_MEDIUM_LIGHT_SKIN_TONE , "writing hand: medium skin tone" => crate :: people_and_body :: hand_prop :: WRITING_HAND_MEDIUM_SKIN_TONE , "writing hand: medium-dark skin tone" => crate :: people_and_body :: hand_prop :: WRITING_HAND_MEDIUM_DARK_SKIN_TONE , "writing hand: dark skin tone" => crate :: people_and_body :: hand_prop :: WRITING_HAND_DARK_SKIN_TONE , "nail polish" => crate :: people_and_body :: hand_prop :: NAIL_POLISH , "nail polish: light skin tone" => crate :: people_and_body :: hand_prop :: NAIL_POLISH_LIGHT_SKIN_TONE , "nail polish: medium-light skin tone" => crate :: people_and_body :: hand_prop :: NAIL_POLISH_MEDIUM_LIGHT_SKIN_TONE , "nail polish: medium skin tone" => crate :: people_and_body :: hand_prop :: NAIL_POLISH_MEDIUM_SKIN_TONE , "nail polish: medium-dark skin tone" => crate :: people_and_body :: hand_prop :: NAIL_POLISH_MEDIUM_DARK_SKIN_TONE , "nail polish: dark skin tone" => crate :: people_and_body :: hand_prop :: NAIL_POLISH_DARK_SKIN_TONE , "selfie" => crate :: people_and_body :: hand_prop :: SELFIE , "selfie: light skin tone" => crate :: people_and_body :: hand_prop :: SELFIE_LIGHT_SKIN_TONE , "selfie: medium-light skin tone" => crate :: people_and_body :: hand_prop :: SELFIE_MEDIUM_LIGHT_SKIN_TONE , "selfie: medium skin tone" => crate :: people_and_body :: hand_prop :: SELFIE_MEDIUM_SKIN_TONE , "selfie: medium-dark skin tone" => crate :: people_and_body :: hand_prop :: SELFIE_MEDIUM_DARK_SKIN_TONE , "selfie: dark skin tone" => crate :: people_and_body :: hand_prop :: SELFIE_DARK_SKIN_TONE , "flexed biceps" => crate :: people_and_body :: body_parts :: FLEXED_BICEPS , "flexed biceps: light skin tone" => crate :: people_and_body :: body_parts :: FLEXED_BICEPS_LIGHT_SKIN_TONE , "flexed biceps: medium-light skin tone" => crate :: people_and_body :: body_parts :: FLEXED_BICEPS_MEDIUM_LIGHT_SKIN_TONE , "flexed biceps: medium skin tone" => crate :: people_and_body :: body_parts :: FLEXED_BICEPS_MEDIUM_SKIN_TONE , "flexed biceps: medium-dark skin tone" => crate :: people_and_body :: body_parts :: FLEXED_BICEPS_MEDIUM_DARK_SKIN_TONE , "flexed biceps: dark skin tone" => crate :: people_and_body :: body_parts :: FLEXED_BICEPS_DARK_SKIN_TONE , "mechanical arm" => crate :: people_and_body :: body_parts :: MECHANICAL_ARM , "mechanical leg" => crate :: people_and_body :: body_parts :: MECHANICAL_LEG , "leg" => crate :: people_and_body :: body_parts :: LEG , "leg: light skin tone" => crate :: people_and_body :: body_parts :: LEG_LIGHT_SKIN_TONE , "leg: medium-light skin tone" => crate :: people_and_body :: body_parts :: LEG_MEDIUM_LIGHT_SKIN_TONE , "leg: medium skin tone" => crate :: people_and_body :: body_parts :: LEG_MEDIUM_SKIN_TONE , "leg: medium-dark skin tone" => crate :: people_and_body :: body_parts :: LEG_MEDIUM_DARK_SKIN_TONE , "leg: dark skin tone" => crate :: people_and_body :: body_parts :: LEG_DARK_SKIN_TONE , "foot" => crate :: people_and_body :: body_parts :: FOOT , "foot: light skin tone" => crate :: people_and_body :: body_parts :: FOOT_LIGHT_SKIN_TONE , "foot: medium-light skin tone" => crate :: people_and_body :: body_parts :: FOOT_MEDIUM_LIGHT_SKIN_TONE , "foot: medium skin tone" => crate :: people_and_body :: body_parts :: FOOT_MEDIUM_SKIN_TONE , "foot: medium-dark skin tone" => crate :: people_and_body :: body_parts :: FOOT_MEDIUM_DARK_SKIN_TONE , "foot: dark skin tone" => crate :: people_and_body :: body_parts :: FOOT_DARK_SKIN_TONE , "ear" => crate :: people_and_body :: body_parts :: EAR , "ear: light skin tone" => crate :: people_and_body :: body_parts :: EAR_LIGHT_SKIN_TONE , "ear: medium-light skin tone" => crate :: people_and_body :: body_parts :: EAR_MEDIUM_LIGHT_SKIN_TONE , "ear: medium skin tone" => crate :: people_and_body :: body_parts :: EAR_MEDIUM_SKIN_TONE , "ear: medium-dark skin tone" => crate :: people_and_body :: body_parts :: EAR_MEDIUM_DARK_SKIN_TONE , "ear: dark skin tone" => crate :: people_and_body :: body_parts :: EAR_DARK_SKIN_TONE , "ear with hearing aid" => crate :: people_and_body :: body_parts :: EAR_WITH_HEARING_AID , "ear with hearing aid: light skin tone" => crate :: people_and_body :: body_parts :: EAR_WITH_HEARING_AID_LIGHT_SKIN_TONE , "ear with hearing aid: medium-light skin tone" => crate :: people_and_body :: body_parts :: EAR_WITH_HEARING_AID_MEDIUM_LIGHT_SKIN_TONE , "ear with hearing aid: medium skin tone" => crate :: people_and_body :: body_parts :: EAR_WITH_HEARING_AID_MEDIUM_SKIN_TONE , "ear with hearing aid: medium-dark skin tone" => crate :: people_and_body :: body_parts :: EAR_WITH_HEARING_AID_MEDIUM_DARK_SKIN_TONE , "ear with hearing aid: dark skin tone" => crate :: people_and_body :: body_parts :: EAR_WITH_HEARING_AID_DARK_SKIN_TONE , "nose" => crate :: people_and_body :: body_parts :: NOSE , "nose: light skin tone" => crate :: people_and_body :: body_parts :: NOSE_LIGHT_SKIN_TONE , "nose: medium-light skin tone" => crate :: people_and_body :: body_parts :: NOSE_MEDIUM_LIGHT_SKIN_TONE , "nose: medium skin tone" => crate :: people_and_body :: body_parts :: NOSE_MEDIUM_SKIN_TONE , "nose: medium-dark skin tone" => crate :: people_and_body :: body_parts :: NOSE_MEDIUM_DARK_SKIN_TONE , "nose: dark skin tone" => crate :: people_and_body :: body_parts :: NOSE_DARK_SKIN_TONE , "brain" => crate :: people_and_body :: body_parts :: BRAIN , "anatomical heart" => crate :: people_and_body :: body_parts :: ANATOMICAL_HEART , "lungs" => crate :: people_and_body :: body_parts :: LUNGS , "tooth" => crate :: people_and_body :: body_parts :: TOOTH , "bone" => crate :: people_and_body :: body_parts :: BONE , "eyes" => crate :: people_and_body :: body_parts :: EYES , "eye" => crate :: people_and_body :: body_parts :: EYE , "tongue" => crate :: people_and_body :: body_parts :: TONGUE , "mouth" => crate :: people_and_body :: body_parts :: MOUTH , "baby" => crate :: people_and_body :: person :: BABY , "baby: light skin tone" => crate :: people_and_body :: person :: BABY_LIGHT_SKIN_TONE , "baby: medium-light skin tone" => crate :: people_and_body :: person :: BABY_MEDIUM_LIGHT_SKIN_TONE , "baby: medium skin tone" => crate :: people_and_body :: person :: BABY_MEDIUM_SKIN_TONE , "baby: medium-dark skin tone" => crate :: people_and_body :: person :: BABY_MEDIUM_DARK_SKIN_TONE , "baby: dark skin tone" => crate :: people_and_body :: person :: BABY_DARK_SKIN_TONE , "child" => crate :: people_and_body :: person :: CHILD , "child: light skin tone" => crate :: people_and_body :: person :: CHILD_LIGHT_SKIN_TONE , "child: medium-light skin tone" => crate :: people_and_body :: person :: CHILD_MEDIUM_LIGHT_SKIN_TONE , "child: medium skin tone" => crate :: people_and_body :: person :: CHILD_MEDIUM_SKIN_TONE , "child: medium-dark skin tone" => crate :: people_and_body :: person :: CHILD_MEDIUM_DARK_SKIN_TONE , "child: dark skin tone" => crate :: people_and_body :: person :: CHILD_DARK_SKIN_TONE , "boy" => crate :: people_and_body :: person :: BOY , "boy: light skin tone" => crate :: people_and_body :: person :: BOY_LIGHT_SKIN_TONE , "boy: medium-light skin tone" => crate :: people_and_body :: person :: BOY_MEDIUM_LIGHT_SKIN_TONE , "boy: medium skin tone" => crate :: people_and_body :: person :: BOY_MEDIUM_SKIN_TONE , "boy: medium-dark skin tone" => crate :: people_and_body :: person :: BOY_MEDIUM_DARK_SKIN_TONE , "boy: dark skin tone" => crate :: people_and_body :: person :: BOY_DARK_SKIN_TONE , "girl" => crate :: people_and_body :: person :: GIRL , "girl: light skin tone" => crate :: people_and_body :: person :: GIRL_LIGHT_SKIN_TONE , "girl: medium-light skin tone" => crate :: people_and_body :: person :: GIRL_MEDIUM_LIGHT_SKIN_TONE , "girl: medium skin tone" => crate :: people_and_body :: person :: GIRL_MEDIUM_SKIN_TONE , "girl: medium-dark skin tone" => crate :: people_and_body :: person :: GIRL_MEDIUM_DARK_SKIN_TONE , "girl: dark skin tone" => crate :: people_and_body :: person :: GIRL_DARK_SKIN_TONE , "person" => crate :: people_and_body :: person :: PERSON , "person: light skin tone" => crate :: people_and_body :: person :: PERSON_LIGHT_SKIN_TONE , "person: medium-light skin tone" => crate :: people_and_body :: person :: PERSON_MEDIUM_LIGHT_SKIN_TONE , "person: medium skin tone" => crate :: people_and_body :: person :: PERSON_MEDIUM_SKIN_TONE , "person: medium-dark skin tone" => crate :: people_and_body :: person :: PERSON_MEDIUM_DARK_SKIN_TONE , "person: dark skin tone" => crate :: people_and_body :: person :: PERSON_DARK_SKIN_TONE , "person: blond hair" => crate :: people_and_body :: person :: PERSON_BLOND_HAIR , "person: light skin tone, blond hair" => crate :: people_and_body :: person :: PERSON_LIGHT_SKIN_TONE_BLOND_HAIR , "person: medium-light skin tone, blond hair" => crate :: people_and_body :: person :: PERSON_MEDIUM_LIGHT_SKIN_TONE_BLOND_HAIR , "person: medium skin tone, blond hair" => crate :: people_and_body :: person :: PERSON_MEDIUM_SKIN_TONE_BLOND_HAIR , "person: medium-dark skin tone, blond hair" => crate :: people_and_body :: person :: PERSON_MEDIUM_DARK_SKIN_TONE_BLOND_HAIR , "person: dark skin tone, blond hair" => crate :: people_and_body :: person :: PERSON_DARK_SKIN_TONE_BLOND_HAIR , "man" => crate :: people_and_body :: person :: MAN , "man: light skin tone" => crate :: people_and_body :: person :: MAN_LIGHT_SKIN_TONE , "man: medium-light skin tone" => crate :: people_and_body :: person :: MAN_MEDIUM_LIGHT_SKIN_TONE , "man: medium skin tone" => crate :: people_and_body :: person :: MAN_MEDIUM_SKIN_TONE , "man: medium-dark skin tone" => crate :: people_and_body :: person :: MAN_MEDIUM_DARK_SKIN_TONE , "man: dark skin tone" => crate :: people_and_body :: person :: MAN_DARK_SKIN_TONE , "person: beard" => crate :: people_and_body :: person :: PERSON_BEARD , "person: light skin tone, beard" => crate :: people_and_body :: person :: PERSON_LIGHT_SKIN_TONE_BEARD , "person: medium-light skin tone, beard" => crate :: people_and_body :: person :: PERSON_MEDIUM_LIGHT_SKIN_TONE_BEARD , "person: medium skin tone, beard" => crate :: people_and_body :: person :: PERSON_MEDIUM_SKIN_TONE_BEARD , "person: medium-dark skin tone, beard" => crate :: people_and_body :: person :: PERSON_MEDIUM_DARK_SKIN_TONE_BEARD , "person: dark skin tone, beard" => crate :: people_and_body :: person :: PERSON_DARK_SKIN_TONE_BEARD , "man: beard" => crate :: people_and_body :: person :: MAN_BEARD , "man: light skin tone, beard" => crate :: people_and_body :: person :: MAN_LIGHT_SKIN_TONE_BEARD , "man: medium-light skin tone, beard" => crate :: people_and_body :: person :: MAN_MEDIUM_LIGHT_SKIN_TONE_BEARD , "man: medium skin tone, beard" => crate :: people_and_body :: person :: MAN_MEDIUM_SKIN_TONE_BEARD , "man: medium-dark skin tone, beard" => crate :: people_and_body :: person :: MAN_MEDIUM_DARK_SKIN_TONE_BEARD , "man: dark skin tone, beard" => crate :: people_and_body :: person :: MAN_DARK_SKIN_TONE_BEARD , "woman: beard" => crate :: people_and_body :: person :: WOMAN_BEARD , "woman: light skin tone, beard" => crate :: people_and_body :: person :: WOMAN_LIGHT_SKIN_TONE_BEARD , "woman: medium-light skin tone, beard" => crate :: people_and_body :: person :: WOMAN_MEDIUM_LIGHT_SKIN_TONE_BEARD , "woman: medium skin tone, beard" => crate :: people_and_body :: person :: WOMAN_MEDIUM_SKIN_TONE_BEARD , "woman: medium-dark skin tone, beard" => crate :: people_and_body :: person :: WOMAN_MEDIUM_DARK_SKIN_TONE_BEARD , "woman: dark skin tone, beard" => crate :: people_and_body :: person :: WOMAN_DARK_SKIN_TONE_BEARD , "man: red hair" => crate :: people_and_body :: person :: MAN_RED_HAIR , "man: light skin tone, red hair" => crate :: people_and_body :: person :: MAN_LIGHT_SKIN_TONE_RED_HAIR , "man: medium-light skin tone, red hair" => crate :: people_and_body :: person :: MAN_MEDIUM_LIGHT_SKIN_TONE_RED_HAIR , "man: medium skin tone, red hair" => crate :: people_and_body :: person :: MAN_MEDIUM_SKIN_TONE_RED_HAIR , "man: medium-dark skin tone, red hair" => crate :: people_and_body :: person :: MAN_MEDIUM_DARK_SKIN_TONE_RED_HAIR , "man: dark skin tone, red hair" => crate :: people_and_body :: person :: MAN_DARK_SKIN_TONE_RED_HAIR , "man: curly hair" => crate :: people_and_body :: person :: MAN_CURLY_HAIR , "man: light skin tone, curly hair" => crate :: people_and_body :: person :: MAN_LIGHT_SKIN_TONE_CURLY_HAIR , "man: medium-light skin tone, curly hair" => crate :: people_and_body :: person :: MAN_MEDIUM_LIGHT_SKIN_TONE_CURLY_HAIR , "man: medium skin tone, curly hair" => crate :: people_and_body :: person :: MAN_MEDIUM_SKIN_TONE_CURLY_HAIR , "man: medium-dark skin tone, curly hair" => crate :: people_and_body :: person :: MAN_MEDIUM_DARK_SKIN_TONE_CURLY_HAIR , "man: dark skin tone, curly hair" => crate :: people_and_body :: person :: MAN_DARK_SKIN_TONE_CURLY_HAIR , "man: white hair" => crate :: people_and_body :: person :: MAN_WHITE_HAIR , "man: light skin tone, white hair" => crate :: people_and_body :: person :: MAN_LIGHT_SKIN_TONE_WHITE_HAIR , "man: medium-light skin tone, white hair" => crate :: people_and_body :: person :: MAN_MEDIUM_LIGHT_SKIN_TONE_WHITE_HAIR , "man: medium skin tone, white hair" => crate :: people_and_body :: person :: MAN_MEDIUM_SKIN_TONE_WHITE_HAIR , "man: medium-dark skin tone, white hair" => crate :: people_and_body :: person :: MAN_MEDIUM_DARK_SKIN_TONE_WHITE_HAIR , "man: dark skin tone, white hair" => crate :: people_and_body :: person :: MAN_DARK_SKIN_TONE_WHITE_HAIR , "man: bald" => crate :: people_and_body :: person :: MAN_BALD , "man: light skin tone, bald" => crate :: people_and_body :: person :: MAN_LIGHT_SKIN_TONE_BALD , "man: medium-light skin tone, bald" => crate :: people_and_body :: person :: MAN_MEDIUM_LIGHT_SKIN_TONE_BALD , "man: medium skin tone, bald" => crate :: people_and_body :: person :: MAN_MEDIUM_SKIN_TONE_BALD , "man: medium-dark skin tone, bald" => crate :: people_and_body :: person :: MAN_MEDIUM_DARK_SKIN_TONE_BALD , "man: dark skin tone, bald" => crate :: people_and_body :: person :: MAN_DARK_SKIN_TONE_BALD , "woman" => crate :: people_and_body :: person :: WOMAN , "woman: light skin tone" => crate :: people_and_body :: person :: WOMAN_LIGHT_SKIN_TONE , "woman: medium-light skin tone" => crate :: people_and_body :: person :: WOMAN_MEDIUM_LIGHT_SKIN_TONE , "woman: medium skin tone" => crate :: people_and_body :: person :: WOMAN_MEDIUM_SKIN_TONE , "woman: medium-dark skin tone" => crate :: people_and_body :: person :: WOMAN_MEDIUM_DARK_SKIN_TONE , "woman: dark skin tone" => crate :: people_and_body :: person :: WOMAN_DARK_SKIN_TONE , "woman: red hair" => crate :: people_and_body :: person :: WOMAN_RED_HAIR , "woman: light skin tone, red hair" => crate :: people_and_body :: person :: WOMAN_LIGHT_SKIN_TONE_RED_HAIR , "woman: medium-light skin tone, red hair" => crate :: people_and_body :: person :: WOMAN_MEDIUM_LIGHT_SKIN_TONE_RED_HAIR , "woman: medium skin tone, red hair" => crate :: people_and_body :: person :: WOMAN_MEDIUM_SKIN_TONE_RED_HAIR , "woman: medium-dark skin tone, red hair" => crate :: people_and_body :: person :: WOMAN_MEDIUM_DARK_SKIN_TONE_RED_HAIR , "woman: dark skin tone, red hair" => crate :: people_and_body :: person :: WOMAN_DARK_SKIN_TONE_RED_HAIR , "person: red hair" => crate :: people_and_body :: person :: PERSON_RED_HAIR , "person: light skin tone, red hair" => crate :: people_and_body :: person :: PERSON_LIGHT_SKIN_TONE_RED_HAIR , "person: medium-light skin tone, red hair" => crate :: people_and_body :: person :: PERSON_MEDIUM_LIGHT_SKIN_TONE_RED_HAIR , "person: medium skin tone, red hair" => crate :: people_and_body :: person :: PERSON_MEDIUM_SKIN_TONE_RED_HAIR , "person: medium-dark skin tone, red hair" => crate :: people_and_body :: person :: PERSON_MEDIUM_DARK_SKIN_TONE_RED_HAIR , "person: dark skin tone, red hair" => crate :: people_and_body :: person :: PERSON_DARK_SKIN_TONE_RED_HAIR , "woman: curly hair" => crate :: people_and_body :: person :: WOMAN_CURLY_HAIR , "woman: light skin tone, curly hair" => crate :: people_and_body :: person :: WOMAN_LIGHT_SKIN_TONE_CURLY_HAIR , "woman: medium-light skin tone, curly hair" => crate :: people_and_body :: person :: WOMAN_MEDIUM_LIGHT_SKIN_TONE_CURLY_HAIR , "woman: medium skin tone, curly hair" => crate :: people_and_body :: person :: WOMAN_MEDIUM_SKIN_TONE_CURLY_HAIR , "woman: medium-dark skin tone, curly hair" => crate :: people_and_body :: person :: WOMAN_MEDIUM_DARK_SKIN_TONE_CURLY_HAIR , "woman: dark skin tone, curly hair" => crate :: people_and_body :: person :: WOMAN_DARK_SKIN_TONE_CURLY_HAIR , "person: curly hair" => crate :: people_and_body :: person :: PERSON_CURLY_HAIR , "person: light skin tone, curly hair" => crate :: people_and_body :: person :: PERSON_LIGHT_SKIN_TONE_CURLY_HAIR , "person: medium-light skin tone, curly hair" => crate :: people_and_body :: person :: PERSON_MEDIUM_LIGHT_SKIN_TONE_CURLY_HAIR , "person: medium skin tone, curly hair" => crate :: people_and_body :: person :: PERSON_MEDIUM_SKIN_TONE_CURLY_HAIR , "person: medium-dark skin tone, curly hair" => crate :: people_and_body :: person :: PERSON_MEDIUM_DARK_SKIN_TONE_CURLY_HAIR , "person: dark skin tone, curly hair" => crate :: people_and_body :: person :: PERSON_DARK_SKIN_TONE_CURLY_HAIR , "woman: white hair" => crate :: people_and_body :: person :: WOMAN_WHITE_HAIR , "woman: light skin tone, white hair" => crate :: people_and_body :: person :: WOMAN_LIGHT_SKIN_TONE_WHITE_HAIR , "woman: medium-light skin tone, white hair" => crate :: people_and_body :: person :: WOMAN_MEDIUM_LIGHT_SKIN_TONE_WHITE_HAIR , "woman: medium skin tone, white hair" => crate :: people_and_body :: person :: WOMAN_MEDIUM_SKIN_TONE_WHITE_HAIR , "woman: medium-dark skin tone, white hair" => crate :: people_and_body :: person :: WOMAN_MEDIUM_DARK_SKIN_TONE_WHITE_HAIR , "woman: dark skin tone, white hair" => crate :: people_and_body :: person :: WOMAN_DARK_SKIN_TONE_WHITE_HAIR , "person: white hair" => crate :: people_and_body :: person :: PERSON_WHITE_HAIR , "person: light skin tone, white hair" => crate :: people_and_body :: person :: PERSON_LIGHT_SKIN_TONE_WHITE_HAIR , "person: medium-light skin tone, white hair" => crate :: people_and_body :: person :: PERSON_MEDIUM_LIGHT_SKIN_TONE_WHITE_HAIR , "person: medium skin tone, white hair" => crate :: people_and_body :: person :: PERSON_MEDIUM_SKIN_TONE_WHITE_HAIR , "person: medium-dark skin tone, white hair" => crate :: people_and_body :: person :: PERSON_MEDIUM_DARK_SKIN_TONE_WHITE_HAIR , "person: dark skin tone, white hair" => crate :: people_and_body :: person :: PERSON_DARK_SKIN_TONE_WHITE_HAIR , "woman: bald" => crate :: people_and_body :: person :: WOMAN_BALD , "woman: light skin tone, bald" => crate :: people_and_body :: person :: WOMAN_LIGHT_SKIN_TONE_BALD , "woman: medium-light skin tone, bald" => crate :: people_and_body :: person :: WOMAN_MEDIUM_LIGHT_SKIN_TONE_BALD , "woman: medium skin tone, bald" => crate :: people_and_body :: person :: WOMAN_MEDIUM_SKIN_TONE_BALD , "woman: medium-dark skin tone, bald" => crate :: people_and_body :: person :: WOMAN_MEDIUM_DARK_SKIN_TONE_BALD , "woman: dark skin tone, bald" => crate :: people_and_body :: person :: WOMAN_DARK_SKIN_TONE_BALD , "person: bald" => crate :: people_and_body :: person :: PERSON_BALD , "person: light skin tone, bald" => crate :: people_and_body :: person :: PERSON_LIGHT_SKIN_TONE_BALD , "person: medium-light skin tone, bald" => crate :: people_and_body :: person :: PERSON_MEDIUM_LIGHT_SKIN_TONE_BALD , "person: medium skin tone, bald" => crate :: people_and_body :: person :: PERSON_MEDIUM_SKIN_TONE_BALD , "person: medium-dark skin tone, bald" => crate :: people_and_body :: person :: PERSON_MEDIUM_DARK_SKIN_TONE_BALD , "person: dark skin tone, bald" => crate :: people_and_body :: person :: PERSON_DARK_SKIN_TONE_BALD , "woman: blond hair" => crate :: people_and_body :: person :: WOMAN_BLOND_HAIR , "woman: light skin tone, blond hair" => crate :: people_and_body :: person :: WOMAN_LIGHT_SKIN_TONE_BLOND_HAIR , "woman: medium-light skin tone, blond hair" => crate :: people_and_body :: person :: WOMAN_MEDIUM_LIGHT_SKIN_TONE_BLOND_HAIR , "woman: medium skin tone, blond hair" => crate :: people_and_body :: person :: WOMAN_MEDIUM_SKIN_TONE_BLOND_HAIR , "woman: medium-dark skin tone, blond hair" => crate :: people_and_body :: person :: WOMAN_MEDIUM_DARK_SKIN_TONE_BLOND_HAIR , "woman: dark skin tone, blond hair" => crate :: people_and_body :: person :: WOMAN_DARK_SKIN_TONE_BLOND_HAIR , "man: blond hair" => crate :: people_and_body :: person :: MAN_BLOND_HAIR , "man: light skin tone, blond hair" => crate :: people_and_body :: person :: MAN_LIGHT_SKIN_TONE_BLOND_HAIR , "man: medium-light skin tone, blond hair" => crate :: people_and_body :: person :: MAN_MEDIUM_LIGHT_SKIN_TONE_BLOND_HAIR , "man: medium skin tone, blond hair" => crate :: people_and_body :: person :: MAN_MEDIUM_SKIN_TONE_BLOND_HAIR , "man: medium-dark skin tone, blond hair" => crate :: people_and_body :: person :: MAN_MEDIUM_DARK_SKIN_TONE_BLOND_HAIR , "man: dark skin tone, blond hair" => crate :: people_and_body :: person :: MAN_DARK_SKIN_TONE_BLOND_HAIR , "older person" => crate :: people_and_body :: person :: OLDER_PERSON , "older person: light skin tone" => crate :: people_and_body :: person :: OLDER_PERSON_LIGHT_SKIN_TONE , "older person: medium-light skin tone" => crate :: people_and_body :: person :: OLDER_PERSON_MEDIUM_LIGHT_SKIN_TONE , "older person: medium skin tone" => crate :: people_and_body :: person :: OLDER_PERSON_MEDIUM_SKIN_TONE , "older person: medium-dark skin tone" => crate :: people_and_body :: person :: OLDER_PERSON_MEDIUM_DARK_SKIN_TONE , "older person: dark skin tone" => crate :: people_and_body :: person :: OLDER_PERSON_DARK_SKIN_TONE , "old man" => crate :: people_and_body :: person :: OLD_MAN , "old man: light skin tone" => crate :: people_and_body :: person :: OLD_MAN_LIGHT_SKIN_TONE , "old man: medium-light skin tone" => crate :: people_and_body :: person :: OLD_MAN_MEDIUM_LIGHT_SKIN_TONE , "old man: medium skin tone" => crate :: people_and_body :: person :: OLD_MAN_MEDIUM_SKIN_TONE , "old man: medium-dark skin tone" => crate :: people_and_body :: person :: OLD_MAN_MEDIUM_DARK_SKIN_TONE , "old man: dark skin tone" => crate :: people_and_body :: person :: OLD_MAN_DARK_SKIN_TONE , "old woman" => crate :: people_and_body :: person :: OLD_WOMAN , "old woman: light skin tone" => crate :: people_and_body :: person :: OLD_WOMAN_LIGHT_SKIN_TONE , "old woman: medium-light skin tone" => crate :: people_and_body :: person :: OLD_WOMAN_MEDIUM_LIGHT_SKIN_TONE , "old woman: medium skin tone" => crate :: people_and_body :: person :: OLD_WOMAN_MEDIUM_SKIN_TONE , "old woman: medium-dark skin tone" => crate :: people_and_body :: person :: OLD_WOMAN_MEDIUM_DARK_SKIN_TONE , "old woman: dark skin tone" => crate :: people_and_body :: person :: OLD_WOMAN_DARK_SKIN_TONE , "person frowning" => crate :: people_and_body :: person_gesture :: PERSON_FROWNING , "person frowning: light skin tone" => crate :: people_and_body :: person_gesture :: PERSON_FROWNING_LIGHT_SKIN_TONE , "person frowning: medium-light skin tone" => crate :: people_and_body :: person_gesture :: PERSON_FROWNING_MEDIUM_LIGHT_SKIN_TONE , "person frowning: medium skin tone" => crate :: people_and_body :: person_gesture :: PERSON_FROWNING_MEDIUM_SKIN_TONE , "person frowning: medium-dark skin tone" => crate :: people_and_body :: person_gesture :: PERSON_FROWNING_MEDIUM_DARK_SKIN_TONE , "person frowning: dark skin tone" => crate :: people_and_body :: person_gesture :: PERSON_FROWNING_DARK_SKIN_TONE , "man frowning" => crate :: people_and_body :: person_gesture :: MAN_FROWNING , "man frowning: light skin tone" => crate :: people_and_body :: person_gesture :: MAN_FROWNING_LIGHT_SKIN_TONE , "man frowning: medium-light skin tone" => crate :: people_and_body :: person_gesture :: MAN_FROWNING_MEDIUM_LIGHT_SKIN_TONE , "man frowning: medium skin tone" => crate :: people_and_body :: person_gesture :: MAN_FROWNING_MEDIUM_SKIN_TONE , "man frowning: medium-dark skin tone" => crate :: people_and_body :: person_gesture :: MAN_FROWNING_MEDIUM_DARK_SKIN_TONE , "man frowning: dark skin tone" => crate :: people_and_body :: person_gesture :: MAN_FROWNING_DARK_SKIN_TONE , "woman frowning" => crate :: people_and_body :: person_gesture :: WOMAN_FROWNING , "woman frowning: light skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_FROWNING_LIGHT_SKIN_TONE , "woman frowning: medium-light skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_FROWNING_MEDIUM_LIGHT_SKIN_TONE , "woman frowning: medium skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_FROWNING_MEDIUM_SKIN_TONE , "woman frowning: medium-dark skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_FROWNING_MEDIUM_DARK_SKIN_TONE , "woman frowning: dark skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_FROWNING_DARK_SKIN_TONE , "person pouting" => crate :: people_and_body :: person_gesture :: PERSON_POUTING , "person pouting: light skin tone" => crate :: people_and_body :: person_gesture :: PERSON_POUTING_LIGHT_SKIN_TONE , "person pouting: medium-light skin tone" => crate :: people_and_body :: person_gesture :: PERSON_POUTING_MEDIUM_LIGHT_SKIN_TONE , "person pouting: medium skin tone" => crate :: people_and_body :: person_gesture :: PERSON_POUTING_MEDIUM_SKIN_TONE , "person pouting: medium-dark skin tone" => crate :: people_and_body :: person_gesture :: PERSON_POUTING_MEDIUM_DARK_SKIN_TONE , "person pouting: dark skin tone" => crate :: people_and_body :: person_gesture :: PERSON_POUTING_DARK_SKIN_TONE , "man pouting" => crate :: people_and_body :: person_gesture :: MAN_POUTING , "man pouting: light skin tone" => crate :: people_and_body :: person_gesture :: MAN_POUTING_LIGHT_SKIN_TONE , "man pouting: medium-light skin tone" => crate :: people_and_body :: person_gesture :: MAN_POUTING_MEDIUM_LIGHT_SKIN_TONE , "man pouting: medium skin tone" => crate :: people_and_body :: person_gesture :: MAN_POUTING_MEDIUM_SKIN_TONE , "man pouting: medium-dark skin tone" => crate :: people_and_body :: person_gesture :: MAN_POUTING_MEDIUM_DARK_SKIN_TONE , "man pouting: dark skin tone" => crate :: people_and_body :: person_gesture :: MAN_POUTING_DARK_SKIN_TONE , "woman pouting" => crate :: people_and_body :: person_gesture :: WOMAN_POUTING , "woman pouting: light skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_POUTING_LIGHT_SKIN_TONE , "woman pouting: medium-light skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_POUTING_MEDIUM_LIGHT_SKIN_TONE , "woman pouting: medium skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_POUTING_MEDIUM_SKIN_TONE , "woman pouting: medium-dark skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_POUTING_MEDIUM_DARK_SKIN_TONE , "woman pouting: dark skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_POUTING_DARK_SKIN_TONE , "person gesturing NO" => crate :: people_and_body :: person_gesture :: PERSON_GESTURING_NO , "person gesturing NO: light skin tone" => crate :: people_and_body :: person_gesture :: PERSON_GESTURING_NO_LIGHT_SKIN_TONE , "person gesturing NO: medium-light skin tone" => crate :: people_and_body :: person_gesture :: PERSON_GESTURING_NO_MEDIUM_LIGHT_SKIN_TONE , "person gesturing NO: medium skin tone" => crate :: people_and_body :: person_gesture :: PERSON_GESTURING_NO_MEDIUM_SKIN_TONE , "person gesturing NO: medium-dark skin tone" => crate :: people_and_body :: person_gesture :: PERSON_GESTURING_NO_MEDIUM_DARK_SKIN_TONE , "person gesturing NO: dark skin tone" => crate :: people_and_body :: person_gesture :: PERSON_GESTURING_NO_DARK_SKIN_TONE , "man gesturing NO" => crate :: people_and_body :: person_gesture :: MAN_GESTURING_NO , "man gesturing NO: light skin tone" => crate :: people_and_body :: person_gesture :: MAN_GESTURING_NO_LIGHT_SKIN_TONE , "man gesturing NO: medium-light skin tone" => crate :: people_and_body :: person_gesture :: MAN_GESTURING_NO_MEDIUM_LIGHT_SKIN_TONE , "man gesturing NO: medium skin tone" => crate :: people_and_body :: person_gesture :: MAN_GESTURING_NO_MEDIUM_SKIN_TONE , "man gesturing NO: medium-dark skin tone" => crate :: people_and_body :: person_gesture :: MAN_GESTURING_NO_MEDIUM_DARK_SKIN_TONE , "man gesturing NO: dark skin tone" => crate :: people_and_body :: person_gesture :: MAN_GESTURING_NO_DARK_SKIN_TONE , "woman gesturing NO" => crate :: people_and_body :: person_gesture :: WOMAN_GESTURING_NO , "woman gesturing NO: light skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_GESTURING_NO_LIGHT_SKIN_TONE , "woman gesturing NO: medium-light skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_GESTURING_NO_MEDIUM_LIGHT_SKIN_TONE , "woman gesturing NO: medium skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_GESTURING_NO_MEDIUM_SKIN_TONE , "woman gesturing NO: medium-dark skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_GESTURING_NO_MEDIUM_DARK_SKIN_TONE , "woman gesturing NO: dark skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_GESTURING_NO_DARK_SKIN_TONE , "person gesturing OK" => crate :: people_and_body :: person_gesture :: PERSON_GESTURING_OK , "person gesturing OK: light skin tone" => crate :: people_and_body :: person_gesture :: PERSON_GESTURING_OK_LIGHT_SKIN_TONE , "person gesturing OK: medium-light skin tone" => crate :: people_and_body :: person_gesture :: PERSON_GESTURING_OK_MEDIUM_LIGHT_SKIN_TONE , "person gesturing OK: medium skin tone" => crate :: people_and_body :: person_gesture :: PERSON_GESTURING_OK_MEDIUM_SKIN_TONE , "person gesturing OK: medium-dark skin tone" => crate :: people_and_body :: person_gesture :: PERSON_GESTURING_OK_MEDIUM_DARK_SKIN_TONE , "person gesturing OK: dark skin tone" => crate :: people_and_body :: person_gesture :: PERSON_GESTURING_OK_DARK_SKIN_TONE , "man gesturing OK" => crate :: people_and_body :: person_gesture :: MAN_GESTURING_OK , "man gesturing OK: light skin tone" => crate :: people_and_body :: person_gesture :: MAN_GESTURING_OK_LIGHT_SKIN_TONE , "man gesturing OK: medium-light skin tone" => crate :: people_and_body :: person_gesture :: MAN_GESTURING_OK_MEDIUM_LIGHT_SKIN_TONE , "man gesturing OK: medium skin tone" => crate :: people_and_body :: person_gesture :: MAN_GESTURING_OK_MEDIUM_SKIN_TONE , "man gesturing OK: medium-dark skin tone" => crate :: people_and_body :: person_gesture :: MAN_GESTURING_OK_MEDIUM_DARK_SKIN_TONE , "man gesturing OK: dark skin tone" => crate :: people_and_body :: person_gesture :: MAN_GESTURING_OK_DARK_SKIN_TONE , "woman gesturing OK" => crate :: people_and_body :: person_gesture :: WOMAN_GESTURING_OK , "woman gesturing OK: light skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_GESTURING_OK_LIGHT_SKIN_TONE , "woman gesturing OK: medium-light skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_GESTURING_OK_MEDIUM_LIGHT_SKIN_TONE , "woman gesturing OK: medium skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_GESTURING_OK_MEDIUM_SKIN_TONE , "woman gesturing OK: medium-dark skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_GESTURING_OK_MEDIUM_DARK_SKIN_TONE , "woman gesturing OK: dark skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_GESTURING_OK_DARK_SKIN_TONE , "person tipping hand" => crate :: people_and_body :: person_gesture :: PERSON_TIPPING_HAND , "person tipping hand: light skin tone" => crate :: people_and_body :: person_gesture :: PERSON_TIPPING_HAND_LIGHT_SKIN_TONE , "person tipping hand: medium-light skin tone" => crate :: people_and_body :: person_gesture :: PERSON_TIPPING_HAND_MEDIUM_LIGHT_SKIN_TONE , "person tipping hand: medium skin tone" => crate :: people_and_body :: person_gesture :: PERSON_TIPPING_HAND_MEDIUM_SKIN_TONE , "person tipping hand: medium-dark skin tone" => crate :: people_and_body :: person_gesture :: PERSON_TIPPING_HAND_MEDIUM_DARK_SKIN_TONE , "person tipping hand: dark skin tone" => crate :: people_and_body :: person_gesture :: PERSON_TIPPING_HAND_DARK_SKIN_TONE , "man tipping hand" => crate :: people_and_body :: person_gesture :: MAN_TIPPING_HAND , "man tipping hand: light skin tone" => crate :: people_and_body :: person_gesture :: MAN_TIPPING_HAND_LIGHT_SKIN_TONE , "man tipping hand: medium-light skin tone" => crate :: people_and_body :: person_gesture :: MAN_TIPPING_HAND_MEDIUM_LIGHT_SKIN_TONE , "man tipping hand: medium skin tone" => crate :: people_and_body :: person_gesture :: MAN_TIPPING_HAND_MEDIUM_SKIN_TONE , "man tipping hand: medium-dark skin tone" => crate :: people_and_body :: person_gesture :: MAN_TIPPING_HAND_MEDIUM_DARK_SKIN_TONE , "man tipping hand: dark skin tone" => crate :: people_and_body :: person_gesture :: MAN_TIPPING_HAND_DARK_SKIN_TONE , "woman tipping hand" => crate :: people_and_body :: person_gesture :: WOMAN_TIPPING_HAND , "woman tipping hand: light skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_TIPPING_HAND_LIGHT_SKIN_TONE , "woman tipping hand: medium-light skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_TIPPING_HAND_MEDIUM_LIGHT_SKIN_TONE , "woman tipping hand: medium skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_TIPPING_HAND_MEDIUM_SKIN_TONE , "woman tipping hand: medium-dark skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_TIPPING_HAND_MEDIUM_DARK_SKIN_TONE , "woman tipping hand: dark skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_TIPPING_HAND_DARK_SKIN_TONE , "person raising hand" => crate :: people_and_body :: person_gesture :: PERSON_RAISING_HAND , "person raising hand: light skin tone" => crate :: people_and_body :: person_gesture :: PERSON_RAISING_HAND_LIGHT_SKIN_TONE , "person raising hand: medium-light skin tone" => crate :: people_and_body :: person_gesture :: PERSON_RAISING_HAND_MEDIUM_LIGHT_SKIN_TONE , "person raising hand: medium skin tone" => crate :: people_and_body :: person_gesture :: PERSON_RAISING_HAND_MEDIUM_SKIN_TONE , "person raising hand: medium-dark skin tone" => crate :: people_and_body :: person_gesture :: PERSON_RAISING_HAND_MEDIUM_DARK_SKIN_TONE , "person raising hand: dark skin tone" => crate :: people_and_body :: person_gesture :: PERSON_RAISING_HAND_DARK_SKIN_TONE , "man raising hand" => crate :: people_and_body :: person_gesture :: MAN_RAISING_HAND , "man raising hand: light skin tone" => crate :: people_and_body :: person_gesture :: MAN_RAISING_HAND_LIGHT_SKIN_TONE , "man raising hand: medium-light skin tone" => crate :: people_and_body :: person_gesture :: MAN_RAISING_HAND_MEDIUM_LIGHT_SKIN_TONE , "man raising hand: medium skin tone" => crate :: people_and_body :: person_gesture :: MAN_RAISING_HAND_MEDIUM_SKIN_TONE , "man raising hand: medium-dark skin tone" => crate :: people_and_body :: person_gesture :: MAN_RAISING_HAND_MEDIUM_DARK_SKIN_TONE , "man raising hand: dark skin tone" => crate :: people_and_body :: person_gesture :: MAN_RAISING_HAND_DARK_SKIN_TONE , "woman raising hand" => crate :: people_and_body :: person_gesture :: WOMAN_RAISING_HAND , "woman raising hand: light skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_RAISING_HAND_LIGHT_SKIN_TONE , "woman raising hand: medium-light skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_RAISING_HAND_MEDIUM_LIGHT_SKIN_TONE , "woman raising hand: medium skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_RAISING_HAND_MEDIUM_SKIN_TONE , "woman raising hand: medium-dark skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_RAISING_HAND_MEDIUM_DARK_SKIN_TONE , "woman raising hand: dark skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_RAISING_HAND_DARK_SKIN_TONE , "deaf person" => crate :: people_and_body :: person_gesture :: DEAF_PERSON , "deaf person: light skin tone" => crate :: people_and_body :: person_gesture :: DEAF_PERSON_LIGHT_SKIN_TONE , "deaf person: medium-light skin tone" => crate :: people_and_body :: person_gesture :: DEAF_PERSON_MEDIUM_LIGHT_SKIN_TONE , "deaf person: medium skin tone" => crate :: people_and_body :: person_gesture :: DEAF_PERSON_MEDIUM_SKIN_TONE , "deaf person: medium-dark skin tone" => crate :: people_and_body :: person_gesture :: DEAF_PERSON_MEDIUM_DARK_SKIN_TONE , "deaf person: dark skin tone" => crate :: people_and_body :: person_gesture :: DEAF_PERSON_DARK_SKIN_TONE , "deaf man" => crate :: people_and_body :: person_gesture :: DEAF_MAN , "deaf man: light skin tone" => crate :: people_and_body :: person_gesture :: DEAF_MAN_LIGHT_SKIN_TONE , "deaf man: medium-light skin tone" => crate :: people_and_body :: person_gesture :: DEAF_MAN_MEDIUM_LIGHT_SKIN_TONE , "deaf man: medium skin tone" => crate :: people_and_body :: person_gesture :: DEAF_MAN_MEDIUM_SKIN_TONE , "deaf man: medium-dark skin tone" => crate :: people_and_body :: person_gesture :: DEAF_MAN_MEDIUM_DARK_SKIN_TONE , "deaf man: dark skin tone" => crate :: people_and_body :: person_gesture :: DEAF_MAN_DARK_SKIN_TONE , "deaf woman" => crate :: people_and_body :: person_gesture :: DEAF_WOMAN , "deaf woman: light skin tone" => crate :: people_and_body :: person_gesture :: DEAF_WOMAN_LIGHT_SKIN_TONE , "deaf woman: medium-light skin tone" => crate :: people_and_body :: person_gesture :: DEAF_WOMAN_MEDIUM_LIGHT_SKIN_TONE , "deaf woman: medium skin tone" => crate :: people_and_body :: person_gesture :: DEAF_WOMAN_MEDIUM_SKIN_TONE , "deaf woman: medium-dark skin tone" => crate :: people_and_body :: person_gesture :: DEAF_WOMAN_MEDIUM_DARK_SKIN_TONE , "deaf woman: dark skin tone" => crate :: people_and_body :: person_gesture :: DEAF_WOMAN_DARK_SKIN_TONE , "person bowing" => crate :: people_and_body :: person_gesture :: PERSON_BOWING , "person bowing: light skin tone" => crate :: people_and_body :: person_gesture :: PERSON_BOWING_LIGHT_SKIN_TONE , "person bowing: medium-light skin tone" => crate :: people_and_body :: person_gesture :: PERSON_BOWING_MEDIUM_LIGHT_SKIN_TONE , "person bowing: medium skin tone" => crate :: people_and_body :: person_gesture :: PERSON_BOWING_MEDIUM_SKIN_TONE , "person bowing: medium-dark skin tone" => crate :: people_and_body :: person_gesture :: PERSON_BOWING_MEDIUM_DARK_SKIN_TONE , "person bowing: dark skin tone" => crate :: people_and_body :: person_gesture :: PERSON_BOWING_DARK_SKIN_TONE , "man bowing" => crate :: people_and_body :: person_gesture :: MAN_BOWING , "man bowing: light skin tone" => crate :: people_and_body :: person_gesture :: MAN_BOWING_LIGHT_SKIN_TONE , "man bowing: medium-light skin tone" => crate :: people_and_body :: person_gesture :: MAN_BOWING_MEDIUM_LIGHT_SKIN_TONE , "man bowing: medium skin tone" => crate :: people_and_body :: person_gesture :: MAN_BOWING_MEDIUM_SKIN_TONE , "man bowing: medium-dark skin tone" => crate :: people_and_body :: person_gesture :: MAN_BOWING_MEDIUM_DARK_SKIN_TONE , "man bowing: dark skin tone" => crate :: people_and_body :: person_gesture :: MAN_BOWING_DARK_SKIN_TONE , "woman bowing" => crate :: people_and_body :: person_gesture :: WOMAN_BOWING , "woman bowing: light skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_BOWING_LIGHT_SKIN_TONE , "woman bowing: medium-light skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_BOWING_MEDIUM_LIGHT_SKIN_TONE , "woman bowing: medium skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_BOWING_MEDIUM_SKIN_TONE , "woman bowing: medium-dark skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_BOWING_MEDIUM_DARK_SKIN_TONE , "woman bowing: dark skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_BOWING_DARK_SKIN_TONE , "person facepalming" => crate :: people_and_body :: person_gesture :: PERSON_FACEPALMING , "person facepalming: light skin tone" => crate :: people_and_body :: person_gesture :: PERSON_FACEPALMING_LIGHT_SKIN_TONE , "person facepalming: medium-light skin tone" => crate :: people_and_body :: person_gesture :: PERSON_FACEPALMING_MEDIUM_LIGHT_SKIN_TONE , "person facepalming: medium skin tone" => crate :: people_and_body :: person_gesture :: PERSON_FACEPALMING_MEDIUM_SKIN_TONE , "person facepalming: medium-dark skin tone" => crate :: people_and_body :: person_gesture :: PERSON_FACEPALMING_MEDIUM_DARK_SKIN_TONE , "person facepalming: dark skin tone" => crate :: people_and_body :: person_gesture :: PERSON_FACEPALMING_DARK_SKIN_TONE , "man facepalming" => crate :: people_and_body :: person_gesture :: MAN_FACEPALMING , "man facepalming: light skin tone" => crate :: people_and_body :: person_gesture :: MAN_FACEPALMING_LIGHT_SKIN_TONE , "man facepalming: medium-light skin tone" => crate :: people_and_body :: person_gesture :: MAN_FACEPALMING_MEDIUM_LIGHT_SKIN_TONE , "man facepalming: medium skin tone" => crate :: people_and_body :: person_gesture :: MAN_FACEPALMING_MEDIUM_SKIN_TONE , "man facepalming: medium-dark skin tone" => crate :: people_and_body :: person_gesture :: MAN_FACEPALMING_MEDIUM_DARK_SKIN_TONE , "man facepalming: dark skin tone" => crate :: people_and_body :: person_gesture :: MAN_FACEPALMING_DARK_SKIN_TONE , "woman facepalming" => crate :: people_and_body :: person_gesture :: WOMAN_FACEPALMING , "woman facepalming: light skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_FACEPALMING_LIGHT_SKIN_TONE , "woman facepalming: medium-light skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_FACEPALMING_MEDIUM_LIGHT_SKIN_TONE , "woman facepalming: medium skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_FACEPALMING_MEDIUM_SKIN_TONE , "woman facepalming: medium-dark skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_FACEPALMING_MEDIUM_DARK_SKIN_TONE , "woman facepalming: dark skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_FACEPALMING_DARK_SKIN_TONE , "person shrugging" => crate :: people_and_body :: person_gesture :: PERSON_SHRUGGING , "person shrugging: light skin tone" => crate :: people_and_body :: person_gesture :: PERSON_SHRUGGING_LIGHT_SKIN_TONE , "person shrugging: medium-light skin tone" => crate :: people_and_body :: person_gesture :: PERSON_SHRUGGING_MEDIUM_LIGHT_SKIN_TONE , "person shrugging: medium skin tone" => crate :: people_and_body :: person_gesture :: PERSON_SHRUGGING_MEDIUM_SKIN_TONE , "person shrugging: medium-dark skin tone" => crate :: people_and_body :: person_gesture :: PERSON_SHRUGGING_MEDIUM_DARK_SKIN_TONE , "person shrugging: dark skin tone" => crate :: people_and_body :: person_gesture :: PERSON_SHRUGGING_DARK_SKIN_TONE , "man shrugging" => crate :: people_and_body :: person_gesture :: MAN_SHRUGGING , "man shrugging: light skin tone" => crate :: people_and_body :: person_gesture :: MAN_SHRUGGING_LIGHT_SKIN_TONE , "man shrugging: medium-light skin tone" => crate :: people_and_body :: person_gesture :: MAN_SHRUGGING_MEDIUM_LIGHT_SKIN_TONE , "man shrugging: medium skin tone" => crate :: people_and_body :: person_gesture :: MAN_SHRUGGING_MEDIUM_SKIN_TONE , "man shrugging: medium-dark skin tone" => crate :: people_and_body :: person_gesture :: MAN_SHRUGGING_MEDIUM_DARK_SKIN_TONE , "man shrugging: dark skin tone" => crate :: people_and_body :: person_gesture :: MAN_SHRUGGING_DARK_SKIN_TONE , "woman shrugging" => crate :: people_and_body :: person_gesture :: WOMAN_SHRUGGING , "woman shrugging: light skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_SHRUGGING_LIGHT_SKIN_TONE , "woman shrugging: medium-light skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_SHRUGGING_MEDIUM_LIGHT_SKIN_TONE , "woman shrugging: medium skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_SHRUGGING_MEDIUM_SKIN_TONE , "woman shrugging: medium-dark skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_SHRUGGING_MEDIUM_DARK_SKIN_TONE , "woman shrugging: dark skin tone" => crate :: people_and_body :: person_gesture :: WOMAN_SHRUGGING_DARK_SKIN_TONE , "health worker" => crate :: people_and_body :: person_role :: HEALTH_WORKER , "health worker: light skin tone" => crate :: people_and_body :: person_role :: HEALTH_WORKER_LIGHT_SKIN_TONE , "health worker: medium-light skin tone" => crate :: people_and_body :: person_role :: HEALTH_WORKER_MEDIUM_LIGHT_SKIN_TONE , "health worker: medium skin tone" => crate :: people_and_body :: person_role :: HEALTH_WORKER_MEDIUM_SKIN_TONE , "health worker: medium-dark skin tone" => crate :: people_and_body :: person_role :: HEALTH_WORKER_MEDIUM_DARK_SKIN_TONE , "health worker: dark skin tone" => crate :: people_and_body :: person_role :: HEALTH_WORKER_DARK_SKIN_TONE , "man health worker" => crate :: people_and_body :: person_role :: MAN_HEALTH_WORKER , "man health worker: light skin tone" => crate :: people_and_body :: person_role :: MAN_HEALTH_WORKER_LIGHT_SKIN_TONE , "man health worker: medium-light skin tone" => crate :: people_and_body :: person_role :: MAN_HEALTH_WORKER_MEDIUM_LIGHT_SKIN_TONE , "man health worker: medium skin tone" => crate :: people_and_body :: person_role :: MAN_HEALTH_WORKER_MEDIUM_SKIN_TONE , "man health worker: medium-dark skin tone" => crate :: people_and_body :: person_role :: MAN_HEALTH_WORKER_MEDIUM_DARK_SKIN_TONE , "man health worker: dark skin tone" => crate :: people_and_body :: person_role :: MAN_HEALTH_WORKER_DARK_SKIN_TONE , "woman health worker" => crate :: people_and_body :: person_role :: WOMAN_HEALTH_WORKER , "woman health worker: light skin tone" => crate :: people_and_body :: person_role :: WOMAN_HEALTH_WORKER_LIGHT_SKIN_TONE , "woman health worker: medium-light skin tone" => crate :: people_and_body :: person_role :: WOMAN_HEALTH_WORKER_MEDIUM_LIGHT_SKIN_TONE , "woman health worker: medium skin tone" => crate :: people_and_body :: person_role :: WOMAN_HEALTH_WORKER_MEDIUM_SKIN_TONE , "woman health worker: medium-dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_HEALTH_WORKER_MEDIUM_DARK_SKIN_TONE , "woman health worker: dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_HEALTH_WORKER_DARK_SKIN_TONE , "student" => crate :: people_and_body :: person_role :: STUDENT , "student: light skin tone" => crate :: people_and_body :: person_role :: STUDENT_LIGHT_SKIN_TONE , "student: medium-light skin tone" => crate :: people_and_body :: person_role :: STUDENT_MEDIUM_LIGHT_SKIN_TONE , "student: medium skin tone" => crate :: people_and_body :: person_role :: STUDENT_MEDIUM_SKIN_TONE , "student: medium-dark skin tone" => crate :: people_and_body :: person_role :: STUDENT_MEDIUM_DARK_SKIN_TONE , "student: dark skin tone" => crate :: people_and_body :: person_role :: STUDENT_DARK_SKIN_TONE , "man student" => crate :: people_and_body :: person_role :: MAN_STUDENT , "man student: light skin tone" => crate :: people_and_body :: person_role :: MAN_STUDENT_LIGHT_SKIN_TONE , "man student: medium-light skin tone" => crate :: people_and_body :: person_role :: MAN_STUDENT_MEDIUM_LIGHT_SKIN_TONE , "man student: medium skin tone" => crate :: people_and_body :: person_role :: MAN_STUDENT_MEDIUM_SKIN_TONE , "man student: medium-dark skin tone" => crate :: people_and_body :: person_role :: MAN_STUDENT_MEDIUM_DARK_SKIN_TONE , "man student: dark skin tone" => crate :: people_and_body :: person_role :: MAN_STUDENT_DARK_SKIN_TONE , "woman student" => crate :: people_and_body :: person_role :: WOMAN_STUDENT , "woman student: light skin tone" => crate :: people_and_body :: person_role :: WOMAN_STUDENT_LIGHT_SKIN_TONE , "woman student: medium-light skin tone" => crate :: people_and_body :: person_role :: WOMAN_STUDENT_MEDIUM_LIGHT_SKIN_TONE , "woman student: medium skin tone" => crate :: people_and_body :: person_role :: WOMAN_STUDENT_MEDIUM_SKIN_TONE , "woman student: medium-dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_STUDENT_MEDIUM_DARK_SKIN_TONE , "woman student: dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_STUDENT_DARK_SKIN_TONE , "teacher" => crate :: people_and_body :: person_role :: TEACHER , "teacher: light skin tone" => crate :: people_and_body :: person_role :: TEACHER_LIGHT_SKIN_TONE , "teacher: medium-light skin tone" => crate :: people_and_body :: person_role :: TEACHER_MEDIUM_LIGHT_SKIN_TONE , "teacher: medium skin tone" => crate :: people_and_body :: person_role :: TEACHER_MEDIUM_SKIN_TONE , "teacher: medium-dark skin tone" => crate :: people_and_body :: person_role :: TEACHER_MEDIUM_DARK_SKIN_TONE , "teacher: dark skin tone" => crate :: people_and_body :: person_role :: TEACHER_DARK_SKIN_TONE , "man teacher" => crate :: people_and_body :: person_role :: MAN_TEACHER , "man teacher: light skin tone" => crate :: people_and_body :: person_role :: MAN_TEACHER_LIGHT_SKIN_TONE , "man teacher: medium-light skin tone" => crate :: people_and_body :: person_role :: MAN_TEACHER_MEDIUM_LIGHT_SKIN_TONE , "man teacher: medium skin tone" => crate :: people_and_body :: person_role :: MAN_TEACHER_MEDIUM_SKIN_TONE , "man teacher: medium-dark skin tone" => crate :: people_and_body :: person_role :: MAN_TEACHER_MEDIUM_DARK_SKIN_TONE , "man teacher: dark skin tone" => crate :: people_and_body :: person_role :: MAN_TEACHER_DARK_SKIN_TONE , "woman teacher" => crate :: people_and_body :: person_role :: WOMAN_TEACHER , "woman teacher: light skin tone" => crate :: people_and_body :: person_role :: WOMAN_TEACHER_LIGHT_SKIN_TONE , "woman teacher: medium-light skin tone" => crate :: people_and_body :: person_role :: WOMAN_TEACHER_MEDIUM_LIGHT_SKIN_TONE , "woman teacher: medium skin tone" => crate :: people_and_body :: person_role :: WOMAN_TEACHER_MEDIUM_SKIN_TONE , "woman teacher: medium-dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_TEACHER_MEDIUM_DARK_SKIN_TONE , "woman teacher: dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_TEACHER_DARK_SKIN_TONE , "judge" => crate :: people_and_body :: person_role :: JUDGE , "judge: light skin tone" => crate :: people_and_body :: person_role :: JUDGE_LIGHT_SKIN_TONE , "judge: medium-light skin tone" => crate :: people_and_body :: person_role :: JUDGE_MEDIUM_LIGHT_SKIN_TONE , "judge: medium skin tone" => crate :: people_and_body :: person_role :: JUDGE_MEDIUM_SKIN_TONE , "judge: medium-dark skin tone" => crate :: people_and_body :: person_role :: JUDGE_MEDIUM_DARK_SKIN_TONE , "judge: dark skin tone" => crate :: people_and_body :: person_role :: JUDGE_DARK_SKIN_TONE , "man judge" => crate :: people_and_body :: person_role :: MAN_JUDGE , "man judge: light skin tone" => crate :: people_and_body :: person_role :: MAN_JUDGE_LIGHT_SKIN_TONE , "man judge: medium-light skin tone" => crate :: people_and_body :: person_role :: MAN_JUDGE_MEDIUM_LIGHT_SKIN_TONE , "man judge: medium skin tone" => crate :: people_and_body :: person_role :: MAN_JUDGE_MEDIUM_SKIN_TONE , "man judge: medium-dark skin tone" => crate :: people_and_body :: person_role :: MAN_JUDGE_MEDIUM_DARK_SKIN_TONE , "man judge: dark skin tone" => crate :: people_and_body :: person_role :: MAN_JUDGE_DARK_SKIN_TONE , "woman judge" => crate :: people_and_body :: person_role :: WOMAN_JUDGE , "woman judge: light skin tone" => crate :: people_and_body :: person_role :: WOMAN_JUDGE_LIGHT_SKIN_TONE , "woman judge: medium-light skin tone" => crate :: people_and_body :: person_role :: WOMAN_JUDGE_MEDIUM_LIGHT_SKIN_TONE , "woman judge: medium skin tone" => crate :: people_and_body :: person_role :: WOMAN_JUDGE_MEDIUM_SKIN_TONE , "woman judge: medium-dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_JUDGE_MEDIUM_DARK_SKIN_TONE , "woman judge: dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_JUDGE_DARK_SKIN_TONE , "farmer" => crate :: people_and_body :: person_role :: FARMER , "farmer: light skin tone" => crate :: people_and_body :: person_role :: FARMER_LIGHT_SKIN_TONE , "farmer: medium-light skin tone" => crate :: people_and_body :: person_role :: FARMER_MEDIUM_LIGHT_SKIN_TONE , "farmer: medium skin tone" => crate :: people_and_body :: person_role :: FARMER_MEDIUM_SKIN_TONE , "farmer: medium-dark skin tone" => crate :: people_and_body :: person_role :: FARMER_MEDIUM_DARK_SKIN_TONE , "farmer: dark skin tone" => crate :: people_and_body :: person_role :: FARMER_DARK_SKIN_TONE , "man farmer" => crate :: people_and_body :: person_role :: MAN_FARMER , "man farmer: light skin tone" => crate :: people_and_body :: person_role :: MAN_FARMER_LIGHT_SKIN_TONE , "man farmer: medium-light skin tone" => crate :: people_and_body :: person_role :: MAN_FARMER_MEDIUM_LIGHT_SKIN_TONE , "man farmer: medium skin tone" => crate :: people_and_body :: person_role :: MAN_FARMER_MEDIUM_SKIN_TONE , "man farmer: medium-dark skin tone" => crate :: people_and_body :: person_role :: MAN_FARMER_MEDIUM_DARK_SKIN_TONE , "man farmer: dark skin tone" => crate :: people_and_body :: person_role :: MAN_FARMER_DARK_SKIN_TONE , "woman farmer" => crate :: people_and_body :: person_role :: WOMAN_FARMER , "woman farmer: light skin tone" => crate :: people_and_body :: person_role :: WOMAN_FARMER_LIGHT_SKIN_TONE , "woman farmer: medium-light skin tone" => crate :: people_and_body :: person_role :: WOMAN_FARMER_MEDIUM_LIGHT_SKIN_TONE , "woman farmer: medium skin tone" => crate :: people_and_body :: person_role :: WOMAN_FARMER_MEDIUM_SKIN_TONE , "woman farmer: medium-dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_FARMER_MEDIUM_DARK_SKIN_TONE , "woman farmer: dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_FARMER_DARK_SKIN_TONE , "cook" => crate :: people_and_body :: person_role :: COOK , "cook: light skin tone" => crate :: people_and_body :: person_role :: COOK_LIGHT_SKIN_TONE , "cook: medium-light skin tone" => crate :: people_and_body :: person_role :: COOK_MEDIUM_LIGHT_SKIN_TONE , "cook: medium skin tone" => crate :: people_and_body :: person_role :: COOK_MEDIUM_SKIN_TONE , "cook: medium-dark skin tone" => crate :: people_and_body :: person_role :: COOK_MEDIUM_DARK_SKIN_TONE , "cook: dark skin tone" => crate :: people_and_body :: person_role :: COOK_DARK_SKIN_TONE , "man cook" => crate :: people_and_body :: person_role :: MAN_COOK , "man cook: light skin tone" => crate :: people_and_body :: person_role :: MAN_COOK_LIGHT_SKIN_TONE , "man cook: medium-light skin tone" => crate :: people_and_body :: person_role :: MAN_COOK_MEDIUM_LIGHT_SKIN_TONE , "man cook: medium skin tone" => crate :: people_and_body :: person_role :: MAN_COOK_MEDIUM_SKIN_TONE , "man cook: medium-dark skin tone" => crate :: people_and_body :: person_role :: MAN_COOK_MEDIUM_DARK_SKIN_TONE , "man cook: dark skin tone" => crate :: people_and_body :: person_role :: MAN_COOK_DARK_SKIN_TONE , "woman cook" => crate :: people_and_body :: person_role :: WOMAN_COOK , "woman cook: light skin tone" => crate :: people_and_body :: person_role :: WOMAN_COOK_LIGHT_SKIN_TONE , "woman cook: medium-light skin tone" => crate :: people_and_body :: person_role :: WOMAN_COOK_MEDIUM_LIGHT_SKIN_TONE , "woman cook: medium skin tone" => crate :: people_and_body :: person_role :: WOMAN_COOK_MEDIUM_SKIN_TONE , "woman cook: medium-dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_COOK_MEDIUM_DARK_SKIN_TONE , "woman cook: dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_COOK_DARK_SKIN_TONE , "mechanic" => crate :: people_and_body :: person_role :: MECHANIC , "mechanic: light skin tone" => crate :: people_and_body :: person_role :: MECHANIC_LIGHT_SKIN_TONE , "mechanic: medium-light skin tone" => crate :: people_and_body :: person_role :: MECHANIC_MEDIUM_LIGHT_SKIN_TONE , "mechanic: medium skin tone" => crate :: people_and_body :: person_role :: MECHANIC_MEDIUM_SKIN_TONE , "mechanic: medium-dark skin tone" => crate :: people_and_body :: person_role :: MECHANIC_MEDIUM_DARK_SKIN_TONE , "mechanic: dark skin tone" => crate :: people_and_body :: person_role :: MECHANIC_DARK_SKIN_TONE , "man mechanic" => crate :: people_and_body :: person_role :: MAN_MECHANIC , "man mechanic: light skin tone" => crate :: people_and_body :: person_role :: MAN_MECHANIC_LIGHT_SKIN_TONE , "man mechanic: medium-light skin tone" => crate :: people_and_body :: person_role :: MAN_MECHANIC_MEDIUM_LIGHT_SKIN_TONE , "man mechanic: medium skin tone" => crate :: people_and_body :: person_role :: MAN_MECHANIC_MEDIUM_SKIN_TONE , "man mechanic: medium-dark skin tone" => crate :: people_and_body :: person_role :: MAN_MECHANIC_MEDIUM_DARK_SKIN_TONE , "man mechanic: dark skin tone" => crate :: people_and_body :: person_role :: MAN_MECHANIC_DARK_SKIN_TONE , "woman mechanic" => crate :: people_and_body :: person_role :: WOMAN_MECHANIC , "woman mechanic: light skin tone" => crate :: people_and_body :: person_role :: WOMAN_MECHANIC_LIGHT_SKIN_TONE , "woman mechanic: medium-light skin tone" => crate :: people_and_body :: person_role :: WOMAN_MECHANIC_MEDIUM_LIGHT_SKIN_TONE , "woman mechanic: medium skin tone" => crate :: people_and_body :: person_role :: WOMAN_MECHANIC_MEDIUM_SKIN_TONE , "woman mechanic: medium-dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_MECHANIC_MEDIUM_DARK_SKIN_TONE , "woman mechanic: dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_MECHANIC_DARK_SKIN_TONE , "factory worker" => crate :: people_and_body :: person_role :: FACTORY_WORKER , "factory worker: light skin tone" => crate :: people_and_body :: person_role :: FACTORY_WORKER_LIGHT_SKIN_TONE , "factory worker: medium-light skin tone" => crate :: people_and_body :: person_role :: FACTORY_WORKER_MEDIUM_LIGHT_SKIN_TONE , "factory worker: medium skin tone" => crate :: people_and_body :: person_role :: FACTORY_WORKER_MEDIUM_SKIN_TONE , "factory worker: medium-dark skin tone" => crate :: people_and_body :: person_role :: FACTORY_WORKER_MEDIUM_DARK_SKIN_TONE , "factory worker: dark skin tone" => crate :: people_and_body :: person_role :: FACTORY_WORKER_DARK_SKIN_TONE , "man factory worker" => crate :: people_and_body :: person_role :: MAN_FACTORY_WORKER , "man factory worker: light skin tone" => crate :: people_and_body :: person_role :: MAN_FACTORY_WORKER_LIGHT_SKIN_TONE , "man factory worker: medium-light skin tone" => crate :: people_and_body :: person_role :: MAN_FACTORY_WORKER_MEDIUM_LIGHT_SKIN_TONE , "man factory worker: medium skin tone" => crate :: people_and_body :: person_role :: MAN_FACTORY_WORKER_MEDIUM_SKIN_TONE , "man factory worker: medium-dark skin tone" => crate :: people_and_body :: person_role :: MAN_FACTORY_WORKER_MEDIUM_DARK_SKIN_TONE , "man factory worker: dark skin tone" => crate :: people_and_body :: person_role :: MAN_FACTORY_WORKER_DARK_SKIN_TONE , "woman factory worker" => crate :: people_and_body :: person_role :: WOMAN_FACTORY_WORKER , "woman factory worker: light skin tone" => crate :: people_and_body :: person_role :: WOMAN_FACTORY_WORKER_LIGHT_SKIN_TONE , "woman factory worker: medium-light skin tone" => crate :: people_and_body :: person_role :: WOMAN_FACTORY_WORKER_MEDIUM_LIGHT_SKIN_TONE , "woman factory worker: medium skin tone" => crate :: people_and_body :: person_role :: WOMAN_FACTORY_WORKER_MEDIUM_SKIN_TONE , "woman factory worker: medium-dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_FACTORY_WORKER_MEDIUM_DARK_SKIN_TONE , "woman factory worker: dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_FACTORY_WORKER_DARK_SKIN_TONE , "office worker" => crate :: people_and_body :: person_role :: OFFICE_WORKER , "office worker: light skin tone" => crate :: people_and_body :: person_role :: OFFICE_WORKER_LIGHT_SKIN_TONE , "office worker: medium-light skin tone" => crate :: people_and_body :: person_role :: OFFICE_WORKER_MEDIUM_LIGHT_SKIN_TONE , "office worker: medium skin tone" => crate :: people_and_body :: person_role :: OFFICE_WORKER_MEDIUM_SKIN_TONE , "office worker: medium-dark skin tone" => crate :: people_and_body :: person_role :: OFFICE_WORKER_MEDIUM_DARK_SKIN_TONE , "office worker: dark skin tone" => crate :: people_and_body :: person_role :: OFFICE_WORKER_DARK_SKIN_TONE , "man office worker" => crate :: people_and_body :: person_role :: MAN_OFFICE_WORKER , "man office worker: light skin tone" => crate :: people_and_body :: person_role :: MAN_OFFICE_WORKER_LIGHT_SKIN_TONE , "man office worker: medium-light skin tone" => crate :: people_and_body :: person_role :: MAN_OFFICE_WORKER_MEDIUM_LIGHT_SKIN_TONE , "man office worker: medium skin tone" => crate :: people_and_body :: person_role :: MAN_OFFICE_WORKER_MEDIUM_SKIN_TONE , "man office worker: medium-dark skin tone" => crate :: people_and_body :: person_role :: MAN_OFFICE_WORKER_MEDIUM_DARK_SKIN_TONE , "man office worker: dark skin tone" => crate :: people_and_body :: person_role :: MAN_OFFICE_WORKER_DARK_SKIN_TONE , "woman office worker" => crate :: people_and_body :: person_role :: WOMAN_OFFICE_WORKER , "woman office worker: light skin tone" => crate :: people_and_body :: person_role :: WOMAN_OFFICE_WORKER_LIGHT_SKIN_TONE , "woman office worker: medium-light skin tone" => crate :: people_and_body :: person_role :: WOMAN_OFFICE_WORKER_MEDIUM_LIGHT_SKIN_TONE , "woman office worker: medium skin tone" => crate :: people_and_body :: person_role :: WOMAN_OFFICE_WORKER_MEDIUM_SKIN_TONE , "woman office worker: medium-dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_OFFICE_WORKER_MEDIUM_DARK_SKIN_TONE , "woman office worker: dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_OFFICE_WORKER_DARK_SKIN_TONE , "scientist" => crate :: people_and_body :: person_role :: SCIENTIST , "scientist: light skin tone" => crate :: people_and_body :: person_role :: SCIENTIST_LIGHT_SKIN_TONE , "scientist: medium-light skin tone" => crate :: people_and_body :: person_role :: SCIENTIST_MEDIUM_LIGHT_SKIN_TONE , "scientist: medium skin tone" => crate :: people_and_body :: person_role :: SCIENTIST_MEDIUM_SKIN_TONE , "scientist: medium-dark skin tone" => crate :: people_and_body :: person_role :: SCIENTIST_MEDIUM_DARK_SKIN_TONE , "scientist: dark skin tone" => crate :: people_and_body :: person_role :: SCIENTIST_DARK_SKIN_TONE , "man scientist" => crate :: people_and_body :: person_role :: MAN_SCIENTIST , "man scientist: light skin tone" => crate :: people_and_body :: person_role :: MAN_SCIENTIST_LIGHT_SKIN_TONE , "man scientist: medium-light skin tone" => crate :: people_and_body :: person_role :: MAN_SCIENTIST_MEDIUM_LIGHT_SKIN_TONE , "man scientist: medium skin tone" => crate :: people_and_body :: person_role :: MAN_SCIENTIST_MEDIUM_SKIN_TONE , "man scientist: medium-dark skin tone" => crate :: people_and_body :: person_role :: MAN_SCIENTIST_MEDIUM_DARK_SKIN_TONE , "man scientist: dark skin tone" => crate :: people_and_body :: person_role :: MAN_SCIENTIST_DARK_SKIN_TONE , "woman scientist" => crate :: people_and_body :: person_role :: WOMAN_SCIENTIST , "woman scientist: light skin tone" => crate :: people_and_body :: person_role :: WOMAN_SCIENTIST_LIGHT_SKIN_TONE , "woman scientist: medium-light skin tone" => crate :: people_and_body :: person_role :: WOMAN_SCIENTIST_MEDIUM_LIGHT_SKIN_TONE , "woman scientist: medium skin tone" => crate :: people_and_body :: person_role :: WOMAN_SCIENTIST_MEDIUM_SKIN_TONE , "woman scientist: medium-dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_SCIENTIST_MEDIUM_DARK_SKIN_TONE , "woman scientist: dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_SCIENTIST_DARK_SKIN_TONE , "technologist" => crate :: people_and_body :: person_role :: TECHNOLOGIST , "technologist: light skin tone" => crate :: people_and_body :: person_role :: TECHNOLOGIST_LIGHT_SKIN_TONE , "technologist: medium-light skin tone" => crate :: people_and_body :: person_role :: TECHNOLOGIST_MEDIUM_LIGHT_SKIN_TONE , "technologist: medium skin tone" => crate :: people_and_body :: person_role :: TECHNOLOGIST_MEDIUM_SKIN_TONE , "technologist: medium-dark skin tone" => crate :: people_and_body :: person_role :: TECHNOLOGIST_MEDIUM_DARK_SKIN_TONE , "technologist: dark skin tone" => crate :: people_and_body :: person_role :: TECHNOLOGIST_DARK_SKIN_TONE , "man technologist" => crate :: people_and_body :: person_role :: MAN_TECHNOLOGIST , "man technologist: light skin tone" => crate :: people_and_body :: person_role :: MAN_TECHNOLOGIST_LIGHT_SKIN_TONE , "man technologist: medium-light skin tone" => crate :: people_and_body :: person_role :: MAN_TECHNOLOGIST_MEDIUM_LIGHT_SKIN_TONE , "man technologist: medium skin tone" => crate :: people_and_body :: person_role :: MAN_TECHNOLOGIST_MEDIUM_SKIN_TONE , "man technologist: medium-dark skin tone" => crate :: people_and_body :: person_role :: MAN_TECHNOLOGIST_MEDIUM_DARK_SKIN_TONE , "man technologist: dark skin tone" => crate :: people_and_body :: person_role :: MAN_TECHNOLOGIST_DARK_SKIN_TONE , "woman technologist" => crate :: people_and_body :: person_role :: WOMAN_TECHNOLOGIST , "woman technologist: light skin tone" => crate :: people_and_body :: person_role :: WOMAN_TECHNOLOGIST_LIGHT_SKIN_TONE , "woman technologist: medium-light skin tone" => crate :: people_and_body :: person_role :: WOMAN_TECHNOLOGIST_MEDIUM_LIGHT_SKIN_TONE , "woman technologist: medium skin tone" => crate :: people_and_body :: person_role :: WOMAN_TECHNOLOGIST_MEDIUM_SKIN_TONE , "woman technologist: medium-dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_TECHNOLOGIST_MEDIUM_DARK_SKIN_TONE , "woman technologist: dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_TECHNOLOGIST_DARK_SKIN_TONE , "singer" => crate :: people_and_body :: person_role :: SINGER , "singer: light skin tone" => crate :: people_and_body :: person_role :: SINGER_LIGHT_SKIN_TONE , "singer: medium-light skin tone" => crate :: people_and_body :: person_role :: SINGER_MEDIUM_LIGHT_SKIN_TONE , "singer: medium skin tone" => crate :: people_and_body :: person_role :: SINGER_MEDIUM_SKIN_TONE , "singer: medium-dark skin tone" => crate :: people_and_body :: person_role :: SINGER_MEDIUM_DARK_SKIN_TONE , "singer: dark skin tone" => crate :: people_and_body :: person_role :: SINGER_DARK_SKIN_TONE , "man singer" => crate :: people_and_body :: person_role :: MAN_SINGER , "man singer: light skin tone" => crate :: people_and_body :: person_role :: MAN_SINGER_LIGHT_SKIN_TONE , "man singer: medium-light skin tone" => crate :: people_and_body :: person_role :: MAN_SINGER_MEDIUM_LIGHT_SKIN_TONE , "man singer: medium skin tone" => crate :: people_and_body :: person_role :: MAN_SINGER_MEDIUM_SKIN_TONE , "man singer: medium-dark skin tone" => crate :: people_and_body :: person_role :: MAN_SINGER_MEDIUM_DARK_SKIN_TONE , "man singer: dark skin tone" => crate :: people_and_body :: person_role :: MAN_SINGER_DARK_SKIN_TONE , "woman singer" => crate :: people_and_body :: person_role :: WOMAN_SINGER , "woman singer: light skin tone" => crate :: people_and_body :: person_role :: WOMAN_SINGER_LIGHT_SKIN_TONE , "woman singer: medium-light skin tone" => crate :: people_and_body :: person_role :: WOMAN_SINGER_MEDIUM_LIGHT_SKIN_TONE , "woman singer: medium skin tone" => crate :: people_and_body :: person_role :: WOMAN_SINGER_MEDIUM_SKIN_TONE , "woman singer: medium-dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_SINGER_MEDIUM_DARK_SKIN_TONE , "woman singer: dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_SINGER_DARK_SKIN_TONE , "artist" => crate :: people_and_body :: person_role :: ARTIST , "artist: light skin tone" => crate :: people_and_body :: person_role :: ARTIST_LIGHT_SKIN_TONE , "artist: medium-light skin tone" => crate :: people_and_body :: person_role :: ARTIST_MEDIUM_LIGHT_SKIN_TONE , "artist: medium skin tone" => crate :: people_and_body :: person_role :: ARTIST_MEDIUM_SKIN_TONE , "artist: medium-dark skin tone" => crate :: people_and_body :: person_role :: ARTIST_MEDIUM_DARK_SKIN_TONE , "artist: dark skin tone" => crate :: people_and_body :: person_role :: ARTIST_DARK_SKIN_TONE , "man artist" => crate :: people_and_body :: person_role :: MAN_ARTIST , "man artist: light skin tone" => crate :: people_and_body :: person_role :: MAN_ARTIST_LIGHT_SKIN_TONE , "man artist: medium-light skin tone" => crate :: people_and_body :: person_role :: MAN_ARTIST_MEDIUM_LIGHT_SKIN_TONE , "man artist: medium skin tone" => crate :: people_and_body :: person_role :: MAN_ARTIST_MEDIUM_SKIN_TONE , "man artist: medium-dark skin tone" => crate :: people_and_body :: person_role :: MAN_ARTIST_MEDIUM_DARK_SKIN_TONE , "man artist: dark skin tone" => crate :: people_and_body :: person_role :: MAN_ARTIST_DARK_SKIN_TONE , "woman artist" => crate :: people_and_body :: person_role :: WOMAN_ARTIST , "woman artist: light skin tone" => crate :: people_and_body :: person_role :: WOMAN_ARTIST_LIGHT_SKIN_TONE , "woman artist: medium-light skin tone" => crate :: people_and_body :: person_role :: WOMAN_ARTIST_MEDIUM_LIGHT_SKIN_TONE , "woman artist: medium skin tone" => crate :: people_and_body :: person_role :: WOMAN_ARTIST_MEDIUM_SKIN_TONE , "woman artist: medium-dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_ARTIST_MEDIUM_DARK_SKIN_TONE , "woman artist: dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_ARTIST_DARK_SKIN_TONE , "pilot" => crate :: people_and_body :: person_role :: PILOT , "pilot: light skin tone" => crate :: people_and_body :: person_role :: PILOT_LIGHT_SKIN_TONE , "pilot: medium-light skin tone" => crate :: people_and_body :: person_role :: PILOT_MEDIUM_LIGHT_SKIN_TONE , "pilot: medium skin tone" => crate :: people_and_body :: person_role :: PILOT_MEDIUM_SKIN_TONE , "pilot: medium-dark skin tone" => crate :: people_and_body :: person_role :: PILOT_MEDIUM_DARK_SKIN_TONE , "pilot: dark skin tone" => crate :: people_and_body :: person_role :: PILOT_DARK_SKIN_TONE , "man pilot" => crate :: people_and_body :: person_role :: MAN_PILOT , "man pilot: light skin tone" => crate :: people_and_body :: person_role :: MAN_PILOT_LIGHT_SKIN_TONE , "man pilot: medium-light skin tone" => crate :: people_and_body :: person_role :: MAN_PILOT_MEDIUM_LIGHT_SKIN_TONE , "man pilot: medium skin tone" => crate :: people_and_body :: person_role :: MAN_PILOT_MEDIUM_SKIN_TONE , "man pilot: medium-dark skin tone" => crate :: people_and_body :: person_role :: MAN_PILOT_MEDIUM_DARK_SKIN_TONE , "man pilot: dark skin tone" => crate :: people_and_body :: person_role :: MAN_PILOT_DARK_SKIN_TONE , "woman pilot" => crate :: people_and_body :: person_role :: WOMAN_PILOT , "woman pilot: light skin tone" => crate :: people_and_body :: person_role :: WOMAN_PILOT_LIGHT_SKIN_TONE , "woman pilot: medium-light skin tone" => crate :: people_and_body :: person_role :: WOMAN_PILOT_MEDIUM_LIGHT_SKIN_TONE , "woman pilot: medium skin tone" => crate :: people_and_body :: person_role :: WOMAN_PILOT_MEDIUM_SKIN_TONE , "woman pilot: medium-dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_PILOT_MEDIUM_DARK_SKIN_TONE , "woman pilot: dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_PILOT_DARK_SKIN_TONE , "astronaut" => crate :: people_and_body :: person_role :: ASTRONAUT , "astronaut: light skin tone" => crate :: people_and_body :: person_role :: ASTRONAUT_LIGHT_SKIN_TONE , "astronaut: medium-light skin tone" => crate :: people_and_body :: person_role :: ASTRONAUT_MEDIUM_LIGHT_SKIN_TONE , "astronaut: medium skin tone" => crate :: people_and_body :: person_role :: ASTRONAUT_MEDIUM_SKIN_TONE , "astronaut: medium-dark skin tone" => crate :: people_and_body :: person_role :: ASTRONAUT_MEDIUM_DARK_SKIN_TONE , "astronaut: dark skin tone" => crate :: people_and_body :: person_role :: ASTRONAUT_DARK_SKIN_TONE , "man astronaut" => crate :: people_and_body :: person_role :: MAN_ASTRONAUT , "man astronaut: light skin tone" => crate :: people_and_body :: person_role :: MAN_ASTRONAUT_LIGHT_SKIN_TONE , "man astronaut: medium-light skin tone" => crate :: people_and_body :: person_role :: MAN_ASTRONAUT_MEDIUM_LIGHT_SKIN_TONE , "man astronaut: medium skin tone" => crate :: people_and_body :: person_role :: MAN_ASTRONAUT_MEDIUM_SKIN_TONE , "man astronaut: medium-dark skin tone" => crate :: people_and_body :: person_role :: MAN_ASTRONAUT_MEDIUM_DARK_SKIN_TONE , "man astronaut: dark skin tone" => crate :: people_and_body :: person_role :: MAN_ASTRONAUT_DARK_SKIN_TONE , "woman astronaut" => crate :: people_and_body :: person_role :: WOMAN_ASTRONAUT , "woman astronaut: light skin tone" => crate :: people_and_body :: person_role :: WOMAN_ASTRONAUT_LIGHT_SKIN_TONE , "woman astronaut: medium-light skin tone" => crate :: people_and_body :: person_role :: WOMAN_ASTRONAUT_MEDIUM_LIGHT_SKIN_TONE , "woman astronaut: medium skin tone" => crate :: people_and_body :: person_role :: WOMAN_ASTRONAUT_MEDIUM_SKIN_TONE , "woman astronaut: medium-dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_ASTRONAUT_MEDIUM_DARK_SKIN_TONE , "woman astronaut: dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_ASTRONAUT_DARK_SKIN_TONE , "firefighter" => crate :: people_and_body :: person_role :: FIREFIGHTER , "firefighter: light skin tone" => crate :: people_and_body :: person_role :: FIREFIGHTER_LIGHT_SKIN_TONE , "firefighter: medium-light skin tone" => crate :: people_and_body :: person_role :: FIREFIGHTER_MEDIUM_LIGHT_SKIN_TONE , "firefighter: medium skin tone" => crate :: people_and_body :: person_role :: FIREFIGHTER_MEDIUM_SKIN_TONE , "firefighter: medium-dark skin tone" => crate :: people_and_body :: person_role :: FIREFIGHTER_MEDIUM_DARK_SKIN_TONE , "firefighter: dark skin tone" => crate :: people_and_body :: person_role :: FIREFIGHTER_DARK_SKIN_TONE , "man firefighter" => crate :: people_and_body :: person_role :: MAN_FIREFIGHTER , "man firefighter: light skin tone" => crate :: people_and_body :: person_role :: MAN_FIREFIGHTER_LIGHT_SKIN_TONE , "man firefighter: medium-light skin tone" => crate :: people_and_body :: person_role :: MAN_FIREFIGHTER_MEDIUM_LIGHT_SKIN_TONE , "man firefighter: medium skin tone" => crate :: people_and_body :: person_role :: MAN_FIREFIGHTER_MEDIUM_SKIN_TONE , "man firefighter: medium-dark skin tone" => crate :: people_and_body :: person_role :: MAN_FIREFIGHTER_MEDIUM_DARK_SKIN_TONE , "man firefighter: dark skin tone" => crate :: people_and_body :: person_role :: MAN_FIREFIGHTER_DARK_SKIN_TONE , "woman firefighter" => crate :: people_and_body :: person_role :: WOMAN_FIREFIGHTER , "woman firefighter: light skin tone" => crate :: people_and_body :: person_role :: WOMAN_FIREFIGHTER_LIGHT_SKIN_TONE , "woman firefighter: medium-light skin tone" => crate :: people_and_body :: person_role :: WOMAN_FIREFIGHTER_MEDIUM_LIGHT_SKIN_TONE , "woman firefighter: medium skin tone" => crate :: people_and_body :: person_role :: WOMAN_FIREFIGHTER_MEDIUM_SKIN_TONE , "woman firefighter: medium-dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_FIREFIGHTER_MEDIUM_DARK_SKIN_TONE , "woman firefighter: dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_FIREFIGHTER_DARK_SKIN_TONE , "police officer" => crate :: people_and_body :: person_role :: POLICE_OFFICER , "police officer: light skin tone" => crate :: people_and_body :: person_role :: POLICE_OFFICER_LIGHT_SKIN_TONE , "police officer: medium-light skin tone" => crate :: people_and_body :: person_role :: POLICE_OFFICER_MEDIUM_LIGHT_SKIN_TONE , "police officer: medium skin tone" => crate :: people_and_body :: person_role :: POLICE_OFFICER_MEDIUM_SKIN_TONE , "police officer: medium-dark skin tone" => crate :: people_and_body :: person_role :: POLICE_OFFICER_MEDIUM_DARK_SKIN_TONE , "police officer: dark skin tone" => crate :: people_and_body :: person_role :: POLICE_OFFICER_DARK_SKIN_TONE , "man police officer" => crate :: people_and_body :: person_role :: MAN_POLICE_OFFICER , "man police officer: light skin tone" => crate :: people_and_body :: person_role :: MAN_POLICE_OFFICER_LIGHT_SKIN_TONE , "man police officer: medium-light skin tone" => crate :: people_and_body :: person_role :: MAN_POLICE_OFFICER_MEDIUM_LIGHT_SKIN_TONE , "man police officer: medium skin tone" => crate :: people_and_body :: person_role :: MAN_POLICE_OFFICER_MEDIUM_SKIN_TONE , "man police officer: medium-dark skin tone" => crate :: people_and_body :: person_role :: MAN_POLICE_OFFICER_MEDIUM_DARK_SKIN_TONE , "man police officer: dark skin tone" => crate :: people_and_body :: person_role :: MAN_POLICE_OFFICER_DARK_SKIN_TONE , "woman police officer" => crate :: people_and_body :: person_role :: WOMAN_POLICE_OFFICER , "woman police officer: light skin tone" => crate :: people_and_body :: person_role :: WOMAN_POLICE_OFFICER_LIGHT_SKIN_TONE , "woman police officer: medium-light skin tone" => crate :: people_and_body :: person_role :: WOMAN_POLICE_OFFICER_MEDIUM_LIGHT_SKIN_TONE , "woman police officer: medium skin tone" => crate :: people_and_body :: person_role :: WOMAN_POLICE_OFFICER_MEDIUM_SKIN_TONE , "woman police officer: medium-dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_POLICE_OFFICER_MEDIUM_DARK_SKIN_TONE , "woman police officer: dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_POLICE_OFFICER_DARK_SKIN_TONE , "detective" => crate :: people_and_body :: person_role :: DETECTIVE , "detective: light skin tone" => crate :: people_and_body :: person_role :: DETECTIVE_LIGHT_SKIN_TONE , "detective: medium-light skin tone" => crate :: people_and_body :: person_role :: DETECTIVE_MEDIUM_LIGHT_SKIN_TONE , "detective: medium skin tone" => crate :: people_and_body :: person_role :: DETECTIVE_MEDIUM_SKIN_TONE , "detective: medium-dark skin tone" => crate :: people_and_body :: person_role :: DETECTIVE_MEDIUM_DARK_SKIN_TONE , "detective: dark skin tone" => crate :: people_and_body :: person_role :: DETECTIVE_DARK_SKIN_TONE , "man detective" => crate :: people_and_body :: person_role :: MAN_DETECTIVE , "man detective: light skin tone" => crate :: people_and_body :: person_role :: MAN_DETECTIVE_LIGHT_SKIN_TONE , "man detective: medium-light skin tone" => crate :: people_and_body :: person_role :: MAN_DETECTIVE_MEDIUM_LIGHT_SKIN_TONE , "man detective: medium skin tone" => crate :: people_and_body :: person_role :: MAN_DETECTIVE_MEDIUM_SKIN_TONE , "man detective: medium-dark skin tone" => crate :: people_and_body :: person_role :: MAN_DETECTIVE_MEDIUM_DARK_SKIN_TONE , "man detective: dark skin tone" => crate :: people_and_body :: person_role :: MAN_DETECTIVE_DARK_SKIN_TONE , "woman detective" => crate :: people_and_body :: person_role :: WOMAN_DETECTIVE , "woman detective: light skin tone" => crate :: people_and_body :: person_role :: WOMAN_DETECTIVE_LIGHT_SKIN_TONE , "woman detective: medium-light skin tone" => crate :: people_and_body :: person_role :: WOMAN_DETECTIVE_MEDIUM_LIGHT_SKIN_TONE , "woman detective: medium skin tone" => crate :: people_and_body :: person_role :: WOMAN_DETECTIVE_MEDIUM_SKIN_TONE , "woman detective: medium-dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_DETECTIVE_MEDIUM_DARK_SKIN_TONE , "woman detective: dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_DETECTIVE_DARK_SKIN_TONE , "guard" => crate :: people_and_body :: person_role :: GUARD , "guard: light skin tone" => crate :: people_and_body :: person_role :: GUARD_LIGHT_SKIN_TONE , "guard: medium-light skin tone" => crate :: people_and_body :: person_role :: GUARD_MEDIUM_LIGHT_SKIN_TONE , "guard: medium skin tone" => crate :: people_and_body :: person_role :: GUARD_MEDIUM_SKIN_TONE , "guard: medium-dark skin tone" => crate :: people_and_body :: person_role :: GUARD_MEDIUM_DARK_SKIN_TONE , "guard: dark skin tone" => crate :: people_and_body :: person_role :: GUARD_DARK_SKIN_TONE , "man guard" => crate :: people_and_body :: person_role :: MAN_GUARD , "man guard: light skin tone" => crate :: people_and_body :: person_role :: MAN_GUARD_LIGHT_SKIN_TONE , "man guard: medium-light skin tone" => crate :: people_and_body :: person_role :: MAN_GUARD_MEDIUM_LIGHT_SKIN_TONE , "man guard: medium skin tone" => crate :: people_and_body :: person_role :: MAN_GUARD_MEDIUM_SKIN_TONE , "man guard: medium-dark skin tone" => crate :: people_and_body :: person_role :: MAN_GUARD_MEDIUM_DARK_SKIN_TONE , "man guard: dark skin tone" => crate :: people_and_body :: person_role :: MAN_GUARD_DARK_SKIN_TONE , "woman guard" => crate :: people_and_body :: person_role :: WOMAN_GUARD , "woman guard: light skin tone" => crate :: people_and_body :: person_role :: WOMAN_GUARD_LIGHT_SKIN_TONE , "woman guard: medium-light skin tone" => crate :: people_and_body :: person_role :: WOMAN_GUARD_MEDIUM_LIGHT_SKIN_TONE , "woman guard: medium skin tone" => crate :: people_and_body :: person_role :: WOMAN_GUARD_MEDIUM_SKIN_TONE , "woman guard: medium-dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_GUARD_MEDIUM_DARK_SKIN_TONE , "woman guard: dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_GUARD_DARK_SKIN_TONE , "ninja" => crate :: people_and_body :: person_role :: NINJA , "ninja: light skin tone" => crate :: people_and_body :: person_role :: NINJA_LIGHT_SKIN_TONE , "ninja: medium-light skin tone" => crate :: people_and_body :: person_role :: NINJA_MEDIUM_LIGHT_SKIN_TONE , "ninja: medium skin tone" => crate :: people_and_body :: person_role :: NINJA_MEDIUM_SKIN_TONE , "ninja: medium-dark skin tone" => crate :: people_and_body :: person_role :: NINJA_MEDIUM_DARK_SKIN_TONE , "ninja: dark skin tone" => crate :: people_and_body :: person_role :: NINJA_DARK_SKIN_TONE , "construction worker" => crate :: people_and_body :: person_role :: CONSTRUCTION_WORKER , "construction worker: light skin tone" => crate :: people_and_body :: person_role :: CONSTRUCTION_WORKER_LIGHT_SKIN_TONE , "construction worker: medium-light skin tone" => crate :: people_and_body :: person_role :: CONSTRUCTION_WORKER_MEDIUM_LIGHT_SKIN_TONE , "construction worker: medium skin tone" => crate :: people_and_body :: person_role :: CONSTRUCTION_WORKER_MEDIUM_SKIN_TONE , "construction worker: medium-dark skin tone" => crate :: people_and_body :: person_role :: CONSTRUCTION_WORKER_MEDIUM_DARK_SKIN_TONE , "construction worker: dark skin tone" => crate :: people_and_body :: person_role :: CONSTRUCTION_WORKER_DARK_SKIN_TONE , "man construction worker" => crate :: people_and_body :: person_role :: MAN_CONSTRUCTION_WORKER , "man construction worker: light skin tone" => crate :: people_and_body :: person_role :: MAN_CONSTRUCTION_WORKER_LIGHT_SKIN_TONE , "man construction worker: medium-light skin tone" => crate :: people_and_body :: person_role :: MAN_CONSTRUCTION_WORKER_MEDIUM_LIGHT_SKIN_TONE , "man construction worker: medium skin tone" => crate :: people_and_body :: person_role :: MAN_CONSTRUCTION_WORKER_MEDIUM_SKIN_TONE , "man construction worker: medium-dark skin tone" => crate :: people_and_body :: person_role :: MAN_CONSTRUCTION_WORKER_MEDIUM_DARK_SKIN_TONE , "man construction worker: dark skin tone" => crate :: people_and_body :: person_role :: MAN_CONSTRUCTION_WORKER_DARK_SKIN_TONE , "woman construction worker" => crate :: people_and_body :: person_role :: WOMAN_CONSTRUCTION_WORKER , "woman construction worker: light skin tone" => crate :: people_and_body :: person_role :: WOMAN_CONSTRUCTION_WORKER_LIGHT_SKIN_TONE , "woman construction worker: medium-light skin tone" => crate :: people_and_body :: person_role :: WOMAN_CONSTRUCTION_WORKER_MEDIUM_LIGHT_SKIN_TONE , "woman construction worker: medium skin tone" => crate :: people_and_body :: person_role :: WOMAN_CONSTRUCTION_WORKER_MEDIUM_SKIN_TONE , "woman construction worker: medium-dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_CONSTRUCTION_WORKER_MEDIUM_DARK_SKIN_TONE , "woman construction worker: dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_CONSTRUCTION_WORKER_DARK_SKIN_TONE , "prince" => crate :: people_and_body :: person_role :: PRINCE , "prince: light skin tone" => crate :: people_and_body :: person_role :: PRINCE_LIGHT_SKIN_TONE , "prince: medium-light skin tone" => crate :: people_and_body :: person_role :: PRINCE_MEDIUM_LIGHT_SKIN_TONE , "prince: medium skin tone" => crate :: people_and_body :: person_role :: PRINCE_MEDIUM_SKIN_TONE , "prince: medium-dark skin tone" => crate :: people_and_body :: person_role :: PRINCE_MEDIUM_DARK_SKIN_TONE , "prince: dark skin tone" => crate :: people_and_body :: person_role :: PRINCE_DARK_SKIN_TONE , "princess" => crate :: people_and_body :: person_role :: PRINCESS , "princess: light skin tone" => crate :: people_and_body :: person_role :: PRINCESS_LIGHT_SKIN_TONE , "princess: medium-light skin tone" => crate :: people_and_body :: person_role :: PRINCESS_MEDIUM_LIGHT_SKIN_TONE , "princess: medium skin tone" => crate :: people_and_body :: person_role :: PRINCESS_MEDIUM_SKIN_TONE , "princess: medium-dark skin tone" => crate :: people_and_body :: person_role :: PRINCESS_MEDIUM_DARK_SKIN_TONE , "princess: dark skin tone" => crate :: people_and_body :: person_role :: PRINCESS_DARK_SKIN_TONE , "person wearing turban" => crate :: people_and_body :: person_role :: PERSON_WEARING_TURBAN , "person wearing turban: light skin tone" => crate :: people_and_body :: person_role :: PERSON_WEARING_TURBAN_LIGHT_SKIN_TONE , "person wearing turban: medium-light skin tone" => crate :: people_and_body :: person_role :: PERSON_WEARING_TURBAN_MEDIUM_LIGHT_SKIN_TONE , "person wearing turban: medium skin tone" => crate :: people_and_body :: person_role :: PERSON_WEARING_TURBAN_MEDIUM_SKIN_TONE , "person wearing turban: medium-dark skin tone" => crate :: people_and_body :: person_role :: PERSON_WEARING_TURBAN_MEDIUM_DARK_SKIN_TONE , "person wearing turban: dark skin tone" => crate :: people_and_body :: person_role :: PERSON_WEARING_TURBAN_DARK_SKIN_TONE , "man wearing turban" => crate :: people_and_body :: person_role :: MAN_WEARING_TURBAN , "man wearing turban: light skin tone" => crate :: people_and_body :: person_role :: MAN_WEARING_TURBAN_LIGHT_SKIN_TONE , "man wearing turban: medium-light skin tone" => crate :: people_and_body :: person_role :: MAN_WEARING_TURBAN_MEDIUM_LIGHT_SKIN_TONE , "man wearing turban: medium skin tone" => crate :: people_and_body :: person_role :: MAN_WEARING_TURBAN_MEDIUM_SKIN_TONE , "man wearing turban: medium-dark skin tone" => crate :: people_and_body :: person_role :: MAN_WEARING_TURBAN_MEDIUM_DARK_SKIN_TONE , "man wearing turban: dark skin tone" => crate :: people_and_body :: person_role :: MAN_WEARING_TURBAN_DARK_SKIN_TONE , "woman wearing turban" => crate :: people_and_body :: person_role :: WOMAN_WEARING_TURBAN , "woman wearing turban: light skin tone" => crate :: people_and_body :: person_role :: WOMAN_WEARING_TURBAN_LIGHT_SKIN_TONE , "woman wearing turban: medium-light skin tone" => crate :: people_and_body :: person_role :: WOMAN_WEARING_TURBAN_MEDIUM_LIGHT_SKIN_TONE , "woman wearing turban: medium skin tone" => crate :: people_and_body :: person_role :: WOMAN_WEARING_TURBAN_MEDIUM_SKIN_TONE , "woman wearing turban: medium-dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_WEARING_TURBAN_MEDIUM_DARK_SKIN_TONE , "woman wearing turban: dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_WEARING_TURBAN_DARK_SKIN_TONE , "person with skullcap" => crate :: people_and_body :: person_role :: PERSON_WITH_SKULLCAP , "person with skullcap: light skin tone" => crate :: people_and_body :: person_role :: PERSON_WITH_SKULLCAP_LIGHT_SKIN_TONE , "person with skullcap: medium-light skin tone" => crate :: people_and_body :: person_role :: PERSON_WITH_SKULLCAP_MEDIUM_LIGHT_SKIN_TONE , "person with skullcap: medium skin tone" => crate :: people_and_body :: person_role :: PERSON_WITH_SKULLCAP_MEDIUM_SKIN_TONE , "person with skullcap: medium-dark skin tone" => crate :: people_and_body :: person_role :: PERSON_WITH_SKULLCAP_MEDIUM_DARK_SKIN_TONE , "person with skullcap: dark skin tone" => crate :: people_and_body :: person_role :: PERSON_WITH_SKULLCAP_DARK_SKIN_TONE , "woman with headscarf" => crate :: people_and_body :: person_role :: WOMAN_WITH_HEADSCARF , "woman with headscarf: light skin tone" => crate :: people_and_body :: person_role :: WOMAN_WITH_HEADSCARF_LIGHT_SKIN_TONE , "woman with headscarf: medium-light skin tone" => crate :: people_and_body :: person_role :: WOMAN_WITH_HEADSCARF_MEDIUM_LIGHT_SKIN_TONE , "woman with headscarf: medium skin tone" => crate :: people_and_body :: person_role :: WOMAN_WITH_HEADSCARF_MEDIUM_SKIN_TONE , "woman with headscarf: medium-dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_WITH_HEADSCARF_MEDIUM_DARK_SKIN_TONE , "woman with headscarf: dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_WITH_HEADSCARF_DARK_SKIN_TONE , "person in tuxedo" => crate :: people_and_body :: person_role :: PERSON_IN_TUXEDO , "person in tuxedo: light skin tone" => crate :: people_and_body :: person_role :: PERSON_IN_TUXEDO_LIGHT_SKIN_TONE , "person in tuxedo: medium-light skin tone" => crate :: people_and_body :: person_role :: PERSON_IN_TUXEDO_MEDIUM_LIGHT_SKIN_TONE , "person in tuxedo: medium skin tone" => crate :: people_and_body :: person_role :: PERSON_IN_TUXEDO_MEDIUM_SKIN_TONE , "person in tuxedo: medium-dark skin tone" => crate :: people_and_body :: person_role :: PERSON_IN_TUXEDO_MEDIUM_DARK_SKIN_TONE , "person in tuxedo: dark skin tone" => crate :: people_and_body :: person_role :: PERSON_IN_TUXEDO_DARK_SKIN_TONE , "man in tuxedo" => crate :: people_and_body :: person_role :: MAN_IN_TUXEDO , "man in tuxedo: light skin tone" => crate :: people_and_body :: person_role :: MAN_IN_TUXEDO_LIGHT_SKIN_TONE , "man in tuxedo: medium-light skin tone" => crate :: people_and_body :: person_role :: MAN_IN_TUXEDO_MEDIUM_LIGHT_SKIN_TONE , "man in tuxedo: medium skin tone" => crate :: people_and_body :: person_role :: MAN_IN_TUXEDO_MEDIUM_SKIN_TONE , "man in tuxedo: medium-dark skin tone" => crate :: people_and_body :: person_role :: MAN_IN_TUXEDO_MEDIUM_DARK_SKIN_TONE , "man in tuxedo: dark skin tone" => crate :: people_and_body :: person_role :: MAN_IN_TUXEDO_DARK_SKIN_TONE , "woman in tuxedo" => crate :: people_and_body :: person_role :: WOMAN_IN_TUXEDO , "woman in tuxedo: light skin tone" => crate :: people_and_body :: person_role :: WOMAN_IN_TUXEDO_LIGHT_SKIN_TONE , "woman in tuxedo: medium-light skin tone" => crate :: people_and_body :: person_role :: WOMAN_IN_TUXEDO_MEDIUM_LIGHT_SKIN_TONE , "woman in tuxedo: medium skin tone" => crate :: people_and_body :: person_role :: WOMAN_IN_TUXEDO_MEDIUM_SKIN_TONE , "woman in tuxedo: medium-dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_IN_TUXEDO_MEDIUM_DARK_SKIN_TONE , "woman in tuxedo: dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_IN_TUXEDO_DARK_SKIN_TONE , "person with veil" => crate :: people_and_body :: person_role :: PERSON_WITH_VEIL , "person with veil: light skin tone" => crate :: people_and_body :: person_role :: PERSON_WITH_VEIL_LIGHT_SKIN_TONE , "person with veil: medium-light skin tone" => crate :: people_and_body :: person_role :: PERSON_WITH_VEIL_MEDIUM_LIGHT_SKIN_TONE , "person with veil: medium skin tone" => crate :: people_and_body :: person_role :: PERSON_WITH_VEIL_MEDIUM_SKIN_TONE , "person with veil: medium-dark skin tone" => crate :: people_and_body :: person_role :: PERSON_WITH_VEIL_MEDIUM_DARK_SKIN_TONE , "person with veil: dark skin tone" => crate :: people_and_body :: person_role :: PERSON_WITH_VEIL_DARK_SKIN_TONE , "man with veil" => crate :: people_and_body :: person_role :: MAN_WITH_VEIL , "man with veil: light skin tone" => crate :: people_and_body :: person_role :: MAN_WITH_VEIL_LIGHT_SKIN_TONE , "man with veil: medium-light skin tone" => crate :: people_and_body :: person_role :: MAN_WITH_VEIL_MEDIUM_LIGHT_SKIN_TONE , "man with veil: medium skin tone" => crate :: people_and_body :: person_role :: MAN_WITH_VEIL_MEDIUM_SKIN_TONE , "man with veil: medium-dark skin tone" => crate :: people_and_body :: person_role :: MAN_WITH_VEIL_MEDIUM_DARK_SKIN_TONE , "man with veil: dark skin tone" => crate :: people_and_body :: person_role :: MAN_WITH_VEIL_DARK_SKIN_TONE , "woman with veil" => crate :: people_and_body :: person_role :: WOMAN_WITH_VEIL , "woman with veil: light skin tone" => crate :: people_and_body :: person_role :: WOMAN_WITH_VEIL_LIGHT_SKIN_TONE , "woman with veil: medium-light skin tone" => crate :: people_and_body :: person_role :: WOMAN_WITH_VEIL_MEDIUM_LIGHT_SKIN_TONE , "woman with veil: medium skin tone" => crate :: people_and_body :: person_role :: WOMAN_WITH_VEIL_MEDIUM_SKIN_TONE , "woman with veil: medium-dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_WITH_VEIL_MEDIUM_DARK_SKIN_TONE , "woman with veil: dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_WITH_VEIL_DARK_SKIN_TONE , "pregnant woman" => crate :: people_and_body :: person_role :: PREGNANT_WOMAN , "pregnant woman: light skin tone" => crate :: people_and_body :: person_role :: PREGNANT_WOMAN_LIGHT_SKIN_TONE , "pregnant woman: medium-light skin tone" => crate :: people_and_body :: person_role :: PREGNANT_WOMAN_MEDIUM_LIGHT_SKIN_TONE , "pregnant woman: medium skin tone" => crate :: people_and_body :: person_role :: PREGNANT_WOMAN_MEDIUM_SKIN_TONE , "pregnant woman: medium-dark skin tone" => crate :: people_and_body :: person_role :: PREGNANT_WOMAN_MEDIUM_DARK_SKIN_TONE , "pregnant woman: dark skin tone" => crate :: people_and_body :: person_role :: PREGNANT_WOMAN_DARK_SKIN_TONE , "breast-feeding" => crate :: people_and_body :: person_role :: BREAST_FEEDING , "breast-feeding: light skin tone" => crate :: people_and_body :: person_role :: BREAST_FEEDING_LIGHT_SKIN_TONE , "breast-feeding: medium-light skin tone" => crate :: people_and_body :: person_role :: BREAST_FEEDING_MEDIUM_LIGHT_SKIN_TONE , "breast-feeding: medium skin tone" => crate :: people_and_body :: person_role :: BREAST_FEEDING_MEDIUM_SKIN_TONE , "breast-feeding: medium-dark skin tone" => crate :: people_and_body :: person_role :: BREAST_FEEDING_MEDIUM_DARK_SKIN_TONE , "breast-feeding: dark skin tone" => crate :: people_and_body :: person_role :: BREAST_FEEDING_DARK_SKIN_TONE , "woman feeding baby" => crate :: people_and_body :: person_role :: WOMAN_FEEDING_BABY , "woman feeding baby: light skin tone" => crate :: people_and_body :: person_role :: WOMAN_FEEDING_BABY_LIGHT_SKIN_TONE , "woman feeding baby: medium-light skin tone" => crate :: people_and_body :: person_role :: WOMAN_FEEDING_BABY_MEDIUM_LIGHT_SKIN_TONE , "woman feeding baby: medium skin tone" => crate :: people_and_body :: person_role :: WOMAN_FEEDING_BABY_MEDIUM_SKIN_TONE , "woman feeding baby: medium-dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_FEEDING_BABY_MEDIUM_DARK_SKIN_TONE , "woman feeding baby: dark skin tone" => crate :: people_and_body :: person_role :: WOMAN_FEEDING_BABY_DARK_SKIN_TONE , "man feeding baby" => crate :: people_and_body :: person_role :: MAN_FEEDING_BABY , "man feeding baby: light skin tone" => crate :: people_and_body :: person_role :: MAN_FEEDING_BABY_LIGHT_SKIN_TONE , "man feeding baby: medium-light skin tone" => crate :: people_and_body :: person_role :: MAN_FEEDING_BABY_MEDIUM_LIGHT_SKIN_TONE , "man feeding baby: medium skin tone" => crate :: people_and_body :: person_role :: MAN_FEEDING_BABY_MEDIUM_SKIN_TONE , "man feeding baby: medium-dark skin tone" => crate :: people_and_body :: person_role :: MAN_FEEDING_BABY_MEDIUM_DARK_SKIN_TONE , "man feeding baby: dark skin tone" => crate :: people_and_body :: person_role :: MAN_FEEDING_BABY_DARK_SKIN_TONE , "person feeding baby" => crate :: people_and_body :: person_role :: PERSON_FEEDING_BABY , "person feeding baby: light skin tone" => crate :: people_and_body :: person_role :: PERSON_FEEDING_BABY_LIGHT_SKIN_TONE , "person feeding baby: medium-light skin tone" => crate :: people_and_body :: person_role :: PERSON_FEEDING_BABY_MEDIUM_LIGHT_SKIN_TONE , "person feeding baby: medium skin tone" => crate :: people_and_body :: person_role :: PERSON_FEEDING_BABY_MEDIUM_SKIN_TONE , "person feeding baby: medium-dark skin tone" => crate :: people_and_body :: person_role :: PERSON_FEEDING_BABY_MEDIUM_DARK_SKIN_TONE , "person feeding baby: dark skin tone" => crate :: people_and_body :: person_role :: PERSON_FEEDING_BABY_DARK_SKIN_TONE , "baby angel" => crate :: people_and_body :: person_fantasy :: BABY_ANGEL , "baby angel: light skin tone" => crate :: people_and_body :: person_fantasy :: BABY_ANGEL_LIGHT_SKIN_TONE , "baby angel: medium-light skin tone" => crate :: people_and_body :: person_fantasy :: BABY_ANGEL_MEDIUM_LIGHT_SKIN_TONE , "baby angel: medium skin tone" => crate :: people_and_body :: person_fantasy :: BABY_ANGEL_MEDIUM_SKIN_TONE , "baby angel: medium-dark skin tone" => crate :: people_and_body :: person_fantasy :: BABY_ANGEL_MEDIUM_DARK_SKIN_TONE , "baby angel: dark skin tone" => crate :: people_and_body :: person_fantasy :: BABY_ANGEL_DARK_SKIN_TONE , "Santa Claus" => crate :: people_and_body :: person_fantasy :: SANTA_CLAUS , "Santa Claus: light skin tone" => crate :: people_and_body :: person_fantasy :: SANTA_CLAUS_LIGHT_SKIN_TONE , "Santa Claus: medium-light skin tone" => crate :: people_and_body :: person_fantasy :: SANTA_CLAUS_MEDIUM_LIGHT_SKIN_TONE , "Santa Claus: medium skin tone" => crate :: people_and_body :: person_fantasy :: SANTA_CLAUS_MEDIUM_SKIN_TONE , "Santa Claus: medium-dark skin tone" => crate :: people_and_body :: person_fantasy :: SANTA_CLAUS_MEDIUM_DARK_SKIN_TONE , "Santa Claus: dark skin tone" => crate :: people_and_body :: person_fantasy :: SANTA_CLAUS_DARK_SKIN_TONE , "Mrs. Claus" => crate :: people_and_body :: person_fantasy :: MRS_CLAUS , "Mrs. Claus: light skin tone" => crate :: people_and_body :: person_fantasy :: MRS_CLAUS_LIGHT_SKIN_TONE , "Mrs. Claus: medium-light skin tone" => crate :: people_and_body :: person_fantasy :: MRS_CLAUS_MEDIUM_LIGHT_SKIN_TONE , "Mrs. Claus: medium skin tone" => crate :: people_and_body :: person_fantasy :: MRS_CLAUS_MEDIUM_SKIN_TONE , "Mrs. Claus: medium-dark skin tone" => crate :: people_and_body :: person_fantasy :: MRS_CLAUS_MEDIUM_DARK_SKIN_TONE , "Mrs. Claus: dark skin tone" => crate :: people_and_body :: person_fantasy :: MRS_CLAUS_DARK_SKIN_TONE , "mx claus" => crate :: people_and_body :: person_fantasy :: MX_CLAUS , "mx claus: light skin tone" => crate :: people_and_body :: person_fantasy :: MX_CLAUS_LIGHT_SKIN_TONE , "mx claus: medium-light skin tone" => crate :: people_and_body :: person_fantasy :: MX_CLAUS_MEDIUM_LIGHT_SKIN_TONE , "mx claus: medium skin tone" => crate :: people_and_body :: person_fantasy :: MX_CLAUS_MEDIUM_SKIN_TONE , "mx claus: medium-dark skin tone" => crate :: people_and_body :: person_fantasy :: MX_CLAUS_MEDIUM_DARK_SKIN_TONE , "mx claus: dark skin tone" => crate :: people_and_body :: person_fantasy :: MX_CLAUS_DARK_SKIN_TONE , "superhero" => crate :: people_and_body :: person_fantasy :: SUPERHERO , "superhero: light skin tone" => crate :: people_and_body :: person_fantasy :: SUPERHERO_LIGHT_SKIN_TONE , "superhero: medium-light skin tone" => crate :: people_and_body :: person_fantasy :: SUPERHERO_MEDIUM_LIGHT_SKIN_TONE , "superhero: medium skin tone" => crate :: people_and_body :: person_fantasy :: SUPERHERO_MEDIUM_SKIN_TONE , "superhero: medium-dark skin tone" => crate :: people_and_body :: person_fantasy :: SUPERHERO_MEDIUM_DARK_SKIN_TONE , "superhero: dark skin tone" => crate :: people_and_body :: person_fantasy :: SUPERHERO_DARK_SKIN_TONE , "man superhero" => crate :: people_and_body :: person_fantasy :: MAN_SUPERHERO , "man superhero: light skin tone" => crate :: people_and_body :: person_fantasy :: MAN_SUPERHERO_LIGHT_SKIN_TONE , "man superhero: medium-light skin tone" => crate :: people_and_body :: person_fantasy :: MAN_SUPERHERO_MEDIUM_LIGHT_SKIN_TONE , "man superhero: medium skin tone" => crate :: people_and_body :: person_fantasy :: MAN_SUPERHERO_MEDIUM_SKIN_TONE , "man superhero: medium-dark skin tone" => crate :: people_and_body :: person_fantasy :: MAN_SUPERHERO_MEDIUM_DARK_SKIN_TONE , "man superhero: dark skin tone" => crate :: people_and_body :: person_fantasy :: MAN_SUPERHERO_DARK_SKIN_TONE , "woman superhero" => crate :: people_and_body :: person_fantasy :: WOMAN_SUPERHERO , "woman superhero: light skin tone" => crate :: people_and_body :: person_fantasy :: WOMAN_SUPERHERO_LIGHT_SKIN_TONE , "woman superhero: medium-light skin tone" => crate :: people_and_body :: person_fantasy :: WOMAN_SUPERHERO_MEDIUM_LIGHT_SKIN_TONE , "woman superhero: medium skin tone" => crate :: people_and_body :: person_fantasy :: WOMAN_SUPERHERO_MEDIUM_SKIN_TONE , "woman superhero: medium-dark skin tone" => crate :: people_and_body :: person_fantasy :: WOMAN_SUPERHERO_MEDIUM_DARK_SKIN_TONE , "woman superhero: dark skin tone" => crate :: people_and_body :: person_fantasy :: WOMAN_SUPERHERO_DARK_SKIN_TONE , "supervillain" => crate :: people_and_body :: person_fantasy :: SUPERVILLAIN , "supervillain: light skin tone" => crate :: people_and_body :: person_fantasy :: SUPERVILLAIN_LIGHT_SKIN_TONE , "supervillain: medium-light skin tone" => crate :: people_and_body :: person_fantasy :: SUPERVILLAIN_MEDIUM_LIGHT_SKIN_TONE , "supervillain: medium skin tone" => crate :: people_and_body :: person_fantasy :: SUPERVILLAIN_MEDIUM_SKIN_TONE , "supervillain: medium-dark skin tone" => crate :: people_and_body :: person_fantasy :: SUPERVILLAIN_MEDIUM_DARK_SKIN_TONE , "supervillain: dark skin tone" => crate :: people_and_body :: person_fantasy :: SUPERVILLAIN_DARK_SKIN_TONE , "man supervillain" => crate :: people_and_body :: person_fantasy :: MAN_SUPERVILLAIN , "man supervillain: light skin tone" => crate :: people_and_body :: person_fantasy :: MAN_SUPERVILLAIN_LIGHT_SKIN_TONE , "man supervillain: medium-light skin tone" => crate :: people_and_body :: person_fantasy :: MAN_SUPERVILLAIN_MEDIUM_LIGHT_SKIN_TONE , "man supervillain: medium skin tone" => crate :: people_and_body :: person_fantasy :: MAN_SUPERVILLAIN_MEDIUM_SKIN_TONE , "man supervillain: medium-dark skin tone" => crate :: people_and_body :: person_fantasy :: MAN_SUPERVILLAIN_MEDIUM_DARK_SKIN_TONE , "man supervillain: dark skin tone" => crate :: people_and_body :: person_fantasy :: MAN_SUPERVILLAIN_DARK_SKIN_TONE , "woman supervillain" => crate :: people_and_body :: person_fantasy :: WOMAN_SUPERVILLAIN , "woman supervillain: light skin tone" => crate :: people_and_body :: person_fantasy :: WOMAN_SUPERVILLAIN_LIGHT_SKIN_TONE , "woman supervillain: medium-light skin tone" => crate :: people_and_body :: person_fantasy :: WOMAN_SUPERVILLAIN_MEDIUM_LIGHT_SKIN_TONE , "woman supervillain: medium skin tone" => crate :: people_and_body :: person_fantasy :: WOMAN_SUPERVILLAIN_MEDIUM_SKIN_TONE , "woman supervillain: medium-dark skin tone" => crate :: people_and_body :: person_fantasy :: WOMAN_SUPERVILLAIN_MEDIUM_DARK_SKIN_TONE , "woman supervillain: dark skin tone" => crate :: people_and_body :: person_fantasy :: WOMAN_SUPERVILLAIN_DARK_SKIN_TONE , "mage" => crate :: people_and_body :: person_fantasy :: MAGE , "mage: light skin tone" => crate :: people_and_body :: person_fantasy :: MAGE_LIGHT_SKIN_TONE , "mage: medium-light skin tone" => crate :: people_and_body :: person_fantasy :: MAGE_MEDIUM_LIGHT_SKIN_TONE , "mage: medium skin tone" => crate :: people_and_body :: person_fantasy :: MAGE_MEDIUM_SKIN_TONE , "mage: medium-dark skin tone" => crate :: people_and_body :: person_fantasy :: MAGE_MEDIUM_DARK_SKIN_TONE , "mage: dark skin tone" => crate :: people_and_body :: person_fantasy :: MAGE_DARK_SKIN_TONE , "man mage" => crate :: people_and_body :: person_fantasy :: MAN_MAGE , "man mage: light skin tone" => crate :: people_and_body :: person_fantasy :: MAN_MAGE_LIGHT_SKIN_TONE , "man mage: medium-light skin tone" => crate :: people_and_body :: person_fantasy :: MAN_MAGE_MEDIUM_LIGHT_SKIN_TONE , "man mage: medium skin tone" => crate :: people_and_body :: person_fantasy :: MAN_MAGE_MEDIUM_SKIN_TONE , "man mage: medium-dark skin tone" => crate :: people_and_body :: person_fantasy :: MAN_MAGE_MEDIUM_DARK_SKIN_TONE , "man mage: dark skin tone" => crate :: people_and_body :: person_fantasy :: MAN_MAGE_DARK_SKIN_TONE , "woman mage" => crate :: people_and_body :: person_fantasy :: WOMAN_MAGE , "woman mage: light skin tone" => crate :: people_and_body :: person_fantasy :: WOMAN_MAGE_LIGHT_SKIN_TONE , "woman mage: medium-light skin tone" => crate :: people_and_body :: person_fantasy :: WOMAN_MAGE_MEDIUM_LIGHT_SKIN_TONE , "woman mage: medium skin tone" => crate :: people_and_body :: person_fantasy :: WOMAN_MAGE_MEDIUM_SKIN_TONE , "woman mage: medium-dark skin tone" => crate :: people_and_body :: person_fantasy :: WOMAN_MAGE_MEDIUM_DARK_SKIN_TONE , "woman mage: dark skin tone" => crate :: people_and_body :: person_fantasy :: WOMAN_MAGE_DARK_SKIN_TONE , "fairy" => crate :: people_and_body :: person_fantasy :: FAIRY , "fairy: light skin tone" => crate :: people_and_body :: person_fantasy :: FAIRY_LIGHT_SKIN_TONE , "fairy: medium-light skin tone" => crate :: people_and_body :: person_fantasy :: FAIRY_MEDIUM_LIGHT_SKIN_TONE , "fairy: medium skin tone" => crate :: people_and_body :: person_fantasy :: FAIRY_MEDIUM_SKIN_TONE , "fairy: medium-dark skin tone" => crate :: people_and_body :: person_fantasy :: FAIRY_MEDIUM_DARK_SKIN_TONE , "fairy: dark skin tone" => crate :: people_and_body :: person_fantasy :: FAIRY_DARK_SKIN_TONE , "man fairy" => crate :: people_and_body :: person_fantasy :: MAN_FAIRY , "man fairy: light skin tone" => crate :: people_and_body :: person_fantasy :: MAN_FAIRY_LIGHT_SKIN_TONE , "man fairy: medium-light skin tone" => crate :: people_and_body :: person_fantasy :: MAN_FAIRY_MEDIUM_LIGHT_SKIN_TONE , "man fairy: medium skin tone" => crate :: people_and_body :: person_fantasy :: MAN_FAIRY_MEDIUM_SKIN_TONE , "man fairy: medium-dark skin tone" => crate :: people_and_body :: person_fantasy :: MAN_FAIRY_MEDIUM_DARK_SKIN_TONE , "man fairy: dark skin tone" => crate :: people_and_body :: person_fantasy :: MAN_FAIRY_DARK_SKIN_TONE , "woman fairy" => crate :: people_and_body :: person_fantasy :: WOMAN_FAIRY , "woman fairy: light skin tone" => crate :: people_and_body :: person_fantasy :: WOMAN_FAIRY_LIGHT_SKIN_TONE , "woman fairy: medium-light skin tone" => crate :: people_and_body :: person_fantasy :: WOMAN_FAIRY_MEDIUM_LIGHT_SKIN_TONE , "woman fairy: medium skin tone" => crate :: people_and_body :: person_fantasy :: WOMAN_FAIRY_MEDIUM_SKIN_TONE , "woman fairy: medium-dark skin tone" => crate :: people_and_body :: person_fantasy :: WOMAN_FAIRY_MEDIUM_DARK_SKIN_TONE , "woman fairy: dark skin tone" => crate :: people_and_body :: person_fantasy :: WOMAN_FAIRY_DARK_SKIN_TONE , "vampire" => crate :: people_and_body :: person_fantasy :: VAMPIRE , "vampire: light skin tone" => crate :: people_and_body :: person_fantasy :: VAMPIRE_LIGHT_SKIN_TONE , "vampire: medium-light skin tone" => crate :: people_and_body :: person_fantasy :: VAMPIRE_MEDIUM_LIGHT_SKIN_TONE , "vampire: medium skin tone" => crate :: people_and_body :: person_fantasy :: VAMPIRE_MEDIUM_SKIN_TONE , "vampire: medium-dark skin tone" => crate :: people_and_body :: person_fantasy :: VAMPIRE_MEDIUM_DARK_SKIN_TONE , "vampire: dark skin tone" => crate :: people_and_body :: person_fantasy :: VAMPIRE_DARK_SKIN_TONE , "man vampire" => crate :: people_and_body :: person_fantasy :: MAN_VAMPIRE , "man vampire: light skin tone" => crate :: people_and_body :: person_fantasy :: MAN_VAMPIRE_LIGHT_SKIN_TONE , "man vampire: medium-light skin tone" => crate :: people_and_body :: person_fantasy :: MAN_VAMPIRE_MEDIUM_LIGHT_SKIN_TONE , "man vampire: medium skin tone" => crate :: people_and_body :: person_fantasy :: MAN_VAMPIRE_MEDIUM_SKIN_TONE , "man vampire: medium-dark skin tone" => crate :: people_and_body :: person_fantasy :: MAN_VAMPIRE_MEDIUM_DARK_SKIN_TONE , "man vampire: dark skin tone" => crate :: people_and_body :: person_fantasy :: MAN_VAMPIRE_DARK_SKIN_TONE , "woman vampire" => crate :: people_and_body :: person_fantasy :: WOMAN_VAMPIRE , "woman vampire: light skin tone" => crate :: people_and_body :: person_fantasy :: WOMAN_VAMPIRE_LIGHT_SKIN_TONE , "woman vampire: medium-light skin tone" => crate :: people_and_body :: person_fantasy :: WOMAN_VAMPIRE_MEDIUM_LIGHT_SKIN_TONE , "woman vampire: medium skin tone" => crate :: people_and_body :: person_fantasy :: WOMAN_VAMPIRE_MEDIUM_SKIN_TONE , "woman vampire: medium-dark skin tone" => crate :: people_and_body :: person_fantasy :: WOMAN_VAMPIRE_MEDIUM_DARK_SKIN_TONE , "woman vampire: dark skin tone" => crate :: people_and_body :: person_fantasy :: WOMAN_VAMPIRE_DARK_SKIN_TONE , "merperson" => crate :: people_and_body :: person_fantasy :: MERPERSON , "merperson: light skin tone" => crate :: people_and_body :: person_fantasy :: MERPERSON_LIGHT_SKIN_TONE , "merperson: medium-light skin tone" => crate :: people_and_body :: person_fantasy :: MERPERSON_MEDIUM_LIGHT_SKIN_TONE , "merperson: medium skin tone" => crate :: people_and_body :: person_fantasy :: MERPERSON_MEDIUM_SKIN_TONE , "merperson: medium-dark skin tone" => crate :: people_and_body :: person_fantasy :: MERPERSON_MEDIUM_DARK_SKIN_TONE , "merperson: dark skin tone" => crate :: people_and_body :: person_fantasy :: MERPERSON_DARK_SKIN_TONE , "merman" => crate :: people_and_body :: person_fantasy :: MERMAN , "merman: light skin tone" => crate :: people_and_body :: person_fantasy :: MERMAN_LIGHT_SKIN_TONE , "merman: medium-light skin tone" => crate :: people_and_body :: person_fantasy :: MERMAN_MEDIUM_LIGHT_SKIN_TONE , "merman: medium skin tone" => crate :: people_and_body :: person_fantasy :: MERMAN_MEDIUM_SKIN_TONE , "merman: medium-dark skin tone" => crate :: people_and_body :: person_fantasy :: MERMAN_MEDIUM_DARK_SKIN_TONE , "merman: dark skin tone" => crate :: people_and_body :: person_fantasy :: MERMAN_DARK_SKIN_TONE , "mermaid" => crate :: people_and_body :: person_fantasy :: MERMAID , "mermaid: light skin tone" => crate :: people_and_body :: person_fantasy :: MERMAID_LIGHT_SKIN_TONE , "mermaid: medium-light skin tone" => crate :: people_and_body :: person_fantasy :: MERMAID_MEDIUM_LIGHT_SKIN_TONE , "mermaid: medium skin tone" => crate :: people_and_body :: person_fantasy :: MERMAID_MEDIUM_SKIN_TONE , "mermaid: medium-dark skin tone" => crate :: people_and_body :: person_fantasy :: MERMAID_MEDIUM_DARK_SKIN_TONE , "mermaid: dark skin tone" => crate :: people_and_body :: person_fantasy :: MERMAID_DARK_SKIN_TONE , "elf" => crate :: people_and_body :: person_fantasy :: ELF , "elf: light skin tone" => crate :: people_and_body :: person_fantasy :: ELF_LIGHT_SKIN_TONE , "elf: medium-light skin tone" => crate :: people_and_body :: person_fantasy :: ELF_MEDIUM_LIGHT_SKIN_TONE , "elf: medium skin tone" => crate :: people_and_body :: person_fantasy :: ELF_MEDIUM_SKIN_TONE , "elf: medium-dark skin tone" => crate :: people_and_body :: person_fantasy :: ELF_MEDIUM_DARK_SKIN_TONE , "elf: dark skin tone" => crate :: people_and_body :: person_fantasy :: ELF_DARK_SKIN_TONE , "man elf" => crate :: people_and_body :: person_fantasy :: MAN_ELF , "man elf: light skin tone" => crate :: people_and_body :: person_fantasy :: MAN_ELF_LIGHT_SKIN_TONE , "man elf: medium-light skin tone" => crate :: people_and_body :: person_fantasy :: MAN_ELF_MEDIUM_LIGHT_SKIN_TONE , "man elf: medium skin tone" => crate :: people_and_body :: person_fantasy :: MAN_ELF_MEDIUM_SKIN_TONE , "man elf: medium-dark skin tone" => crate :: people_and_body :: person_fantasy :: MAN_ELF_MEDIUM_DARK_SKIN_TONE , "man elf: dark skin tone" => crate :: people_and_body :: person_fantasy :: MAN_ELF_DARK_SKIN_TONE , "woman elf" => crate :: people_and_body :: person_fantasy :: WOMAN_ELF , "woman elf: light skin tone" => crate :: people_and_body :: person_fantasy :: WOMAN_ELF_LIGHT_SKIN_TONE , "woman elf: medium-light skin tone" => crate :: people_and_body :: person_fantasy :: WOMAN_ELF_MEDIUM_LIGHT_SKIN_TONE , "woman elf: medium skin tone" => crate :: people_and_body :: person_fantasy :: WOMAN_ELF_MEDIUM_SKIN_TONE , "woman elf: medium-dark skin tone" => crate :: people_and_body :: person_fantasy :: WOMAN_ELF_MEDIUM_DARK_SKIN_TONE , "woman elf: dark skin tone" => crate :: people_and_body :: person_fantasy :: WOMAN_ELF_DARK_SKIN_TONE , "genie" => crate :: people_and_body :: person_fantasy :: GENIE , "man genie" => crate :: people_and_body :: person_fantasy :: MAN_GENIE , "woman genie" => crate :: people_and_body :: person_fantasy :: WOMAN_GENIE , "zombie" => crate :: people_and_body :: person_fantasy :: ZOMBIE , "man zombie" => crate :: people_and_body :: person_fantasy :: MAN_ZOMBIE , "woman zombie" => crate :: people_and_body :: person_fantasy :: WOMAN_ZOMBIE , "person getting massage" => crate :: people_and_body :: person_activity :: PERSON_GETTING_MASSAGE , "person getting massage: light skin tone" => crate :: people_and_body :: person_activity :: PERSON_GETTING_MASSAGE_LIGHT_SKIN_TONE , "person getting massage: medium-light skin tone" => crate :: people_and_body :: person_activity :: PERSON_GETTING_MASSAGE_MEDIUM_LIGHT_SKIN_TONE , "person getting massage: medium skin tone" => crate :: people_and_body :: person_activity :: PERSON_GETTING_MASSAGE_MEDIUM_SKIN_TONE , "person getting massage: medium-dark skin tone" => crate :: people_and_body :: person_activity :: PERSON_GETTING_MASSAGE_MEDIUM_DARK_SKIN_TONE , "person getting massage: dark skin tone" => crate :: people_and_body :: person_activity :: PERSON_GETTING_MASSAGE_DARK_SKIN_TONE , "man getting massage" => crate :: people_and_body :: person_activity :: MAN_GETTING_MASSAGE , "man getting massage: light skin tone" => crate :: people_and_body :: person_activity :: MAN_GETTING_MASSAGE_LIGHT_SKIN_TONE , "man getting massage: medium-light skin tone" => crate :: people_and_body :: person_activity :: MAN_GETTING_MASSAGE_MEDIUM_LIGHT_SKIN_TONE , "man getting massage: medium skin tone" => crate :: people_and_body :: person_activity :: MAN_GETTING_MASSAGE_MEDIUM_SKIN_TONE , "man getting massage: medium-dark skin tone" => crate :: people_and_body :: person_activity :: MAN_GETTING_MASSAGE_MEDIUM_DARK_SKIN_TONE , "man getting massage: dark skin tone" => crate :: people_and_body :: person_activity :: MAN_GETTING_MASSAGE_DARK_SKIN_TONE , "woman getting massage" => crate :: people_and_body :: person_activity :: WOMAN_GETTING_MASSAGE , "woman getting massage: light skin tone" => crate :: people_and_body :: person_activity :: WOMAN_GETTING_MASSAGE_LIGHT_SKIN_TONE , "woman getting massage: medium-light skin tone" => crate :: people_and_body :: person_activity :: WOMAN_GETTING_MASSAGE_MEDIUM_LIGHT_SKIN_TONE , "woman getting massage: medium skin tone" => crate :: people_and_body :: person_activity :: WOMAN_GETTING_MASSAGE_MEDIUM_SKIN_TONE , "woman getting massage: medium-dark skin tone" => crate :: people_and_body :: person_activity :: WOMAN_GETTING_MASSAGE_MEDIUM_DARK_SKIN_TONE , "woman getting massage: dark skin tone" => crate :: people_and_body :: person_activity :: WOMAN_GETTING_MASSAGE_DARK_SKIN_TONE , "person getting haircut" => crate :: people_and_body :: person_activity :: PERSON_GETTING_HAIRCUT , "person getting haircut: light skin tone" => crate :: people_and_body :: person_activity :: PERSON_GETTING_HAIRCUT_LIGHT_SKIN_TONE , "person getting haircut: medium-light skin tone" => crate :: people_and_body :: person_activity :: PERSON_GETTING_HAIRCUT_MEDIUM_LIGHT_SKIN_TONE , "person getting haircut: medium skin tone" => crate :: people_and_body :: person_activity :: PERSON_GETTING_HAIRCUT_MEDIUM_SKIN_TONE , "person getting haircut: medium-dark skin tone" => crate :: people_and_body :: person_activity :: PERSON_GETTING_HAIRCUT_MEDIUM_DARK_SKIN_TONE , "person getting haircut: dark skin tone" => crate :: people_and_body :: person_activity :: PERSON_GETTING_HAIRCUT_DARK_SKIN_TONE , "man getting haircut" => crate :: people_and_body :: person_activity :: MAN_GETTING_HAIRCUT , "man getting haircut: light skin tone" => crate :: people_and_body :: person_activity :: MAN_GETTING_HAIRCUT_LIGHT_SKIN_TONE , "man getting haircut: medium-light skin tone" => crate :: people_and_body :: person_activity :: MAN_GETTING_HAIRCUT_MEDIUM_LIGHT_SKIN_TONE , "man getting haircut: medium skin tone" => crate :: people_and_body :: person_activity :: MAN_GETTING_HAIRCUT_MEDIUM_SKIN_TONE , "man getting haircut: medium-dark skin tone" => crate :: people_and_body :: person_activity :: MAN_GETTING_HAIRCUT_MEDIUM_DARK_SKIN_TONE , "man getting haircut: dark skin tone" => crate :: people_and_body :: person_activity :: MAN_GETTING_HAIRCUT_DARK_SKIN_TONE , "woman getting haircut" => crate :: people_and_body :: person_activity :: WOMAN_GETTING_HAIRCUT , "woman getting haircut: light skin tone" => crate :: people_and_body :: person_activity :: WOMAN_GETTING_HAIRCUT_LIGHT_SKIN_TONE , "woman getting haircut: medium-light skin tone" => crate :: people_and_body :: person_activity :: WOMAN_GETTING_HAIRCUT_MEDIUM_LIGHT_SKIN_TONE , "woman getting haircut: medium skin tone" => crate :: people_and_body :: person_activity :: WOMAN_GETTING_HAIRCUT_MEDIUM_SKIN_TONE , "woman getting haircut: medium-dark skin tone" => crate :: people_and_body :: person_activity :: WOMAN_GETTING_HAIRCUT_MEDIUM_DARK_SKIN_TONE , "woman getting haircut: dark skin tone" => crate :: people_and_body :: person_activity :: WOMAN_GETTING_HAIRCUT_DARK_SKIN_TONE , "person walking" => crate :: people_and_body :: person_activity :: PERSON_WALKING , "person walking: light skin tone" => crate :: people_and_body :: person_activity :: PERSON_WALKING_LIGHT_SKIN_TONE , "person walking: medium-light skin tone" => crate :: people_and_body :: person_activity :: PERSON_WALKING_MEDIUM_LIGHT_SKIN_TONE , "person walking: medium skin tone" => crate :: people_and_body :: person_activity :: PERSON_WALKING_MEDIUM_SKIN_TONE , "person walking: medium-dark skin tone" => crate :: people_and_body :: person_activity :: PERSON_WALKING_MEDIUM_DARK_SKIN_TONE , "person walking: dark skin tone" => crate :: people_and_body :: person_activity :: PERSON_WALKING_DARK_SKIN_TONE , "man walking" => crate :: people_and_body :: person_activity :: MAN_WALKING , "man walking: light skin tone" => crate :: people_and_body :: person_activity :: MAN_WALKING_LIGHT_SKIN_TONE , "man walking: medium-light skin tone" => crate :: people_and_body :: person_activity :: MAN_WALKING_MEDIUM_LIGHT_SKIN_TONE , "man walking: medium skin tone" => crate :: people_and_body :: person_activity :: MAN_WALKING_MEDIUM_SKIN_TONE , "man walking: medium-dark skin tone" => crate :: people_and_body :: person_activity :: MAN_WALKING_MEDIUM_DARK_SKIN_TONE , "man walking: dark skin tone" => crate :: people_and_body :: person_activity :: MAN_WALKING_DARK_SKIN_TONE , "woman walking" => crate :: people_and_body :: person_activity :: WOMAN_WALKING , "woman walking: light skin tone" => crate :: people_and_body :: person_activity :: WOMAN_WALKING_LIGHT_SKIN_TONE , "woman walking: medium-light skin tone" => crate :: people_and_body :: person_activity :: WOMAN_WALKING_MEDIUM_LIGHT_SKIN_TONE , "woman walking: medium skin tone" => crate :: people_and_body :: person_activity :: WOMAN_WALKING_MEDIUM_SKIN_TONE , "woman walking: medium-dark skin tone" => crate :: people_and_body :: person_activity :: WOMAN_WALKING_MEDIUM_DARK_SKIN_TONE , "woman walking: dark skin tone" => crate :: people_and_body :: person_activity :: WOMAN_WALKING_DARK_SKIN_TONE , "person standing" => crate :: people_and_body :: person_activity :: PERSON_STANDING , "person standing: light skin tone" => crate :: people_and_body :: person_activity :: PERSON_STANDING_LIGHT_SKIN_TONE , "person standing: medium-light skin tone" => crate :: people_and_body :: person_activity :: PERSON_STANDING_MEDIUM_LIGHT_SKIN_TONE , "person standing: medium skin tone" => crate :: people_and_body :: person_activity :: PERSON_STANDING_MEDIUM_SKIN_TONE , "person standing: medium-dark skin tone" => crate :: people_and_body :: person_activity :: PERSON_STANDING_MEDIUM_DARK_SKIN_TONE , "person standing: dark skin tone" => crate :: people_and_body :: person_activity :: PERSON_STANDING_DARK_SKIN_TONE , "man standing" => crate :: people_and_body :: person_activity :: MAN_STANDING , "man standing: light skin tone" => crate :: people_and_body :: person_activity :: MAN_STANDING_LIGHT_SKIN_TONE , "man standing: medium-light skin tone" => crate :: people_and_body :: person_activity :: MAN_STANDING_MEDIUM_LIGHT_SKIN_TONE , "man standing: medium skin tone" => crate :: people_and_body :: person_activity :: MAN_STANDING_MEDIUM_SKIN_TONE , "man standing: medium-dark skin tone" => crate :: people_and_body :: person_activity :: MAN_STANDING_MEDIUM_DARK_SKIN_TONE , "man standing: dark skin tone" => crate :: people_and_body :: person_activity :: MAN_STANDING_DARK_SKIN_TONE , "woman standing" => crate :: people_and_body :: person_activity :: WOMAN_STANDING , "woman standing: light skin tone" => crate :: people_and_body :: person_activity :: WOMAN_STANDING_LIGHT_SKIN_TONE , "woman standing: medium-light skin tone" => crate :: people_and_body :: person_activity :: WOMAN_STANDING_MEDIUM_LIGHT_SKIN_TONE , "woman standing: medium skin tone" => crate :: people_and_body :: person_activity :: WOMAN_STANDING_MEDIUM_SKIN_TONE , "woman standing: medium-dark skin tone" => crate :: people_and_body :: person_activity :: WOMAN_STANDING_MEDIUM_DARK_SKIN_TONE , "woman standing: dark skin tone" => crate :: people_and_body :: person_activity :: WOMAN_STANDING_DARK_SKIN_TONE , "person kneeling" => crate :: people_and_body :: person_activity :: PERSON_KNEELING , "person kneeling: light skin tone" => crate :: people_and_body :: person_activity :: PERSON_KNEELING_LIGHT_SKIN_TONE , "person kneeling: medium-light skin tone" => crate :: people_and_body :: person_activity :: PERSON_KNEELING_MEDIUM_LIGHT_SKIN_TONE , "person kneeling: medium skin tone" => crate :: people_and_body :: person_activity :: PERSON_KNEELING_MEDIUM_SKIN_TONE , "person kneeling: medium-dark skin tone" => crate :: people_and_body :: person_activity :: PERSON_KNEELING_MEDIUM_DARK_SKIN_TONE , "person kneeling: dark skin tone" => crate :: people_and_body :: person_activity :: PERSON_KNEELING_DARK_SKIN_TONE , "man kneeling" => crate :: people_and_body :: person_activity :: MAN_KNEELING , "man kneeling: light skin tone" => crate :: people_and_body :: person_activity :: MAN_KNEELING_LIGHT_SKIN_TONE , "man kneeling: medium-light skin tone" => crate :: people_and_body :: person_activity :: MAN_KNEELING_MEDIUM_LIGHT_SKIN_TONE , "man kneeling: medium skin tone" => crate :: people_and_body :: person_activity :: MAN_KNEELING_MEDIUM_SKIN_TONE , "man kneeling: medium-dark skin tone" => crate :: people_and_body :: person_activity :: MAN_KNEELING_MEDIUM_DARK_SKIN_TONE , "man kneeling: dark skin tone" => crate :: people_and_body :: person_activity :: MAN_KNEELING_DARK_SKIN_TONE , "woman kneeling" => crate :: people_and_body :: person_activity :: WOMAN_KNEELING , "woman kneeling: light skin tone" => crate :: people_and_body :: person_activity :: WOMAN_KNEELING_LIGHT_SKIN_TONE , "woman kneeling: medium-light skin tone" => crate :: people_and_body :: person_activity :: WOMAN_KNEELING_MEDIUM_LIGHT_SKIN_TONE , "woman kneeling: medium skin tone" => crate :: people_and_body :: person_activity :: WOMAN_KNEELING_MEDIUM_SKIN_TONE , "woman kneeling: medium-dark skin tone" => crate :: people_and_body :: person_activity :: WOMAN_KNEELING_MEDIUM_DARK_SKIN_TONE , "woman kneeling: dark skin tone" => crate :: people_and_body :: person_activity :: WOMAN_KNEELING_DARK_SKIN_TONE , "person with white cane" => crate :: people_and_body :: person_activity :: PERSON_WITH_WHITE_CANE , "person with white cane: light skin tone" => crate :: people_and_body :: person_activity :: PERSON_WITH_WHITE_CANE_LIGHT_SKIN_TONE , "person with white cane: medium-light skin tone" => crate :: people_and_body :: person_activity :: PERSON_WITH_WHITE_CANE_MEDIUM_LIGHT_SKIN_TONE , "person with white cane: medium skin tone" => crate :: people_and_body :: person_activity :: PERSON_WITH_WHITE_CANE_MEDIUM_SKIN_TONE , "person with white cane: medium-dark skin tone" => crate :: people_and_body :: person_activity :: PERSON_WITH_WHITE_CANE_MEDIUM_DARK_SKIN_TONE , "person with white cane: dark skin tone" => crate :: people_and_body :: person_activity :: PERSON_WITH_WHITE_CANE_DARK_SKIN_TONE , "man with white cane" => crate :: people_and_body :: person_activity :: MAN_WITH_WHITE_CANE , "man with white cane: light skin tone" => crate :: people_and_body :: person_activity :: MAN_WITH_WHITE_CANE_LIGHT_SKIN_TONE , "man with white cane: medium-light skin tone" => crate :: people_and_body :: person_activity :: MAN_WITH_WHITE_CANE_MEDIUM_LIGHT_SKIN_TONE , "man with white cane: medium skin tone" => crate :: people_and_body :: person_activity :: MAN_WITH_WHITE_CANE_MEDIUM_SKIN_TONE , "man with white cane: medium-dark skin tone" => crate :: people_and_body :: person_activity :: MAN_WITH_WHITE_CANE_MEDIUM_DARK_SKIN_TONE , "man with white cane: dark skin tone" => crate :: people_and_body :: person_activity :: MAN_WITH_WHITE_CANE_DARK_SKIN_TONE , "woman with white cane" => crate :: people_and_body :: person_activity :: WOMAN_WITH_WHITE_CANE , "woman with white cane: light skin tone" => crate :: people_and_body :: person_activity :: WOMAN_WITH_WHITE_CANE_LIGHT_SKIN_TONE , "woman with white cane: medium-light skin tone" => crate :: people_and_body :: person_activity :: WOMAN_WITH_WHITE_CANE_MEDIUM_LIGHT_SKIN_TONE , "woman with white cane: medium skin tone" => crate :: people_and_body :: person_activity :: WOMAN_WITH_WHITE_CANE_MEDIUM_SKIN_TONE , "woman with white cane: medium-dark skin tone" => crate :: people_and_body :: person_activity :: WOMAN_WITH_WHITE_CANE_MEDIUM_DARK_SKIN_TONE , "woman with white cane: dark skin tone" => crate :: people_and_body :: person_activity :: WOMAN_WITH_WHITE_CANE_DARK_SKIN_TONE , "person in motorized wheelchair" => crate :: people_and_body :: person_activity :: PERSON_IN_MOTORIZED_WHEELCHAIR , "person in motorized wheelchair: light skin tone" => crate :: people_and_body :: person_activity :: PERSON_IN_MOTORIZED_WHEELCHAIR_LIGHT_SKIN_TONE , "person in motorized wheelchair: medium-light skin tone" => crate :: people_and_body :: person_activity :: PERSON_IN_MOTORIZED_WHEELCHAIR_MEDIUM_LIGHT_SKIN_TONE , "person in motorized wheelchair: medium skin tone" => crate :: people_and_body :: person_activity :: PERSON_IN_MOTORIZED_WHEELCHAIR_MEDIUM_SKIN_TONE , "person in motorized wheelchair: medium-dark skin tone" => crate :: people_and_body :: person_activity :: PERSON_IN_MOTORIZED_WHEELCHAIR_MEDIUM_DARK_SKIN_TONE , "person in motorized wheelchair: dark skin tone" => crate :: people_and_body :: person_activity :: PERSON_IN_MOTORIZED_WHEELCHAIR_DARK_SKIN_TONE , "man in motorized wheelchair" => crate :: people_and_body :: person_activity :: MAN_IN_MOTORIZED_WHEELCHAIR , "man in motorized wheelchair: light skin tone" => crate :: people_and_body :: person_activity :: MAN_IN_MOTORIZED_WHEELCHAIR_LIGHT_SKIN_TONE , "man in motorized wheelchair: medium-light skin tone" => crate :: people_and_body :: person_activity :: MAN_IN_MOTORIZED_WHEELCHAIR_MEDIUM_LIGHT_SKIN_TONE , "man in motorized wheelchair: medium skin tone" => crate :: people_and_body :: person_activity :: MAN_IN_MOTORIZED_WHEELCHAIR_MEDIUM_SKIN_TONE , "man in motorized wheelchair: medium-dark skin tone" => crate :: people_and_body :: person_activity :: MAN_IN_MOTORIZED_WHEELCHAIR_MEDIUM_DARK_SKIN_TONE , "man in motorized wheelchair: dark skin tone" => crate :: people_and_body :: person_activity :: MAN_IN_MOTORIZED_WHEELCHAIR_DARK_SKIN_TONE , "woman in motorized wheelchair" => crate :: people_and_body :: person_activity :: WOMAN_IN_MOTORIZED_WHEELCHAIR , "woman in motorized wheelchair: light skin tone" => crate :: people_and_body :: person_activity :: WOMAN_IN_MOTORIZED_WHEELCHAIR_LIGHT_SKIN_TONE , "woman in motorized wheelchair: medium-light skin tone" => crate :: people_and_body :: person_activity :: WOMAN_IN_MOTORIZED_WHEELCHAIR_MEDIUM_LIGHT_SKIN_TONE , "woman in motorized wheelchair: medium skin tone" => crate :: people_and_body :: person_activity :: WOMAN_IN_MOTORIZED_WHEELCHAIR_MEDIUM_SKIN_TONE , "woman in motorized wheelchair: medium-dark skin tone" => crate :: people_and_body :: person_activity :: WOMAN_IN_MOTORIZED_WHEELCHAIR_MEDIUM_DARK_SKIN_TONE , "woman in motorized wheelchair: dark skin tone" => crate :: people_and_body :: person_activity :: WOMAN_IN_MOTORIZED_WHEELCHAIR_DARK_SKIN_TONE , "person in manual wheelchair" => crate :: people_and_body :: person_activity :: PERSON_IN_MANUAL_WHEELCHAIR , "person in manual wheelchair: light skin tone" => crate :: people_and_body :: person_activity :: PERSON_IN_MANUAL_WHEELCHAIR_LIGHT_SKIN_TONE , "person in manual wheelchair: medium-light skin tone" => crate :: people_and_body :: person_activity :: PERSON_IN_MANUAL_WHEELCHAIR_MEDIUM_LIGHT_SKIN_TONE , "person in manual wheelchair: medium skin tone" => crate :: people_and_body :: person_activity :: PERSON_IN_MANUAL_WHEELCHAIR_MEDIUM_SKIN_TONE , "person in manual wheelchair: medium-dark skin tone" => crate :: people_and_body :: person_activity :: PERSON_IN_MANUAL_WHEELCHAIR_MEDIUM_DARK_SKIN_TONE , "person in manual wheelchair: dark skin tone" => crate :: people_and_body :: person_activity :: PERSON_IN_MANUAL_WHEELCHAIR_DARK_SKIN_TONE , "man in manual wheelchair" => crate :: people_and_body :: person_activity :: MAN_IN_MANUAL_WHEELCHAIR , "man in manual wheelchair: light skin tone" => crate :: people_and_body :: person_activity :: MAN_IN_MANUAL_WHEELCHAIR_LIGHT_SKIN_TONE , "man in manual wheelchair: medium-light skin tone" => crate :: people_and_body :: person_activity :: MAN_IN_MANUAL_WHEELCHAIR_MEDIUM_LIGHT_SKIN_TONE , "man in manual wheelchair: medium skin tone" => crate :: people_and_body :: person_activity :: MAN_IN_MANUAL_WHEELCHAIR_MEDIUM_SKIN_TONE , "man in manual wheelchair: medium-dark skin tone" => crate :: people_and_body :: person_activity :: MAN_IN_MANUAL_WHEELCHAIR_MEDIUM_DARK_SKIN_TONE , "man in manual wheelchair: dark skin tone" => crate :: people_and_body :: person_activity :: MAN_IN_MANUAL_WHEELCHAIR_DARK_SKIN_TONE , "woman in manual wheelchair" => crate :: people_and_body :: person_activity :: WOMAN_IN_MANUAL_WHEELCHAIR , "woman in manual wheelchair: light skin tone" => crate :: people_and_body :: person_activity :: WOMAN_IN_MANUAL_WHEELCHAIR_LIGHT_SKIN_TONE , "woman in manual wheelchair: medium-light skin tone" => crate :: people_and_body :: person_activity :: WOMAN_IN_MANUAL_WHEELCHAIR_MEDIUM_LIGHT_SKIN_TONE , "woman in manual wheelchair: medium skin tone" => crate :: people_and_body :: person_activity :: WOMAN_IN_MANUAL_WHEELCHAIR_MEDIUM_SKIN_TONE , "woman in manual wheelchair: medium-dark skin tone" => crate :: people_and_body :: person_activity :: WOMAN_IN_MANUAL_WHEELCHAIR_MEDIUM_DARK_SKIN_TONE , "woman in manual wheelchair: dark skin tone" => crate :: people_and_body :: person_activity :: WOMAN_IN_MANUAL_WHEELCHAIR_DARK_SKIN_TONE , "person running" => crate :: people_and_body :: person_activity :: PERSON_RUNNING , "person running: light skin tone" => crate :: people_and_body :: person_activity :: PERSON_RUNNING_LIGHT_SKIN_TONE , "person running: medium-light skin tone" => crate :: people_and_body :: person_activity :: PERSON_RUNNING_MEDIUM_LIGHT_SKIN_TONE , "person running: medium skin tone" => crate :: people_and_body :: person_activity :: PERSON_RUNNING_MEDIUM_SKIN_TONE , "person running: medium-dark skin tone" => crate :: people_and_body :: person_activity :: PERSON_RUNNING_MEDIUM_DARK_SKIN_TONE , "person running: dark skin tone" => crate :: people_and_body :: person_activity :: PERSON_RUNNING_DARK_SKIN_TONE , "man running" => crate :: people_and_body :: person_activity :: MAN_RUNNING , "man running: light skin tone" => crate :: people_and_body :: person_activity :: MAN_RUNNING_LIGHT_SKIN_TONE , "man running: medium-light skin tone" => crate :: people_and_body :: person_activity :: MAN_RUNNING_MEDIUM_LIGHT_SKIN_TONE , "man running: medium skin tone" => crate :: people_and_body :: person_activity :: MAN_RUNNING_MEDIUM_SKIN_TONE , "man running: medium-dark skin tone" => crate :: people_and_body :: person_activity :: MAN_RUNNING_MEDIUM_DARK_SKIN_TONE , "man running: dark skin tone" => crate :: people_and_body :: person_activity :: MAN_RUNNING_DARK_SKIN_TONE , "woman running" => crate :: people_and_body :: person_activity :: WOMAN_RUNNING , "woman running: light skin tone" => crate :: people_and_body :: person_activity :: WOMAN_RUNNING_LIGHT_SKIN_TONE , "woman running: medium-light skin tone" => crate :: people_and_body :: person_activity :: WOMAN_RUNNING_MEDIUM_LIGHT_SKIN_TONE , "woman running: medium skin tone" => crate :: people_and_body :: person_activity :: WOMAN_RUNNING_MEDIUM_SKIN_TONE , "woman running: medium-dark skin tone" => crate :: people_and_body :: person_activity :: WOMAN_RUNNING_MEDIUM_DARK_SKIN_TONE , "woman running: dark skin tone" => crate :: people_and_body :: person_activity :: WOMAN_RUNNING_DARK_SKIN_TONE , "woman dancing" => crate :: people_and_body :: person_activity :: WOMAN_DANCING , "woman dancing: light skin tone" => crate :: people_and_body :: person_activity :: WOMAN_DANCING_LIGHT_SKIN_TONE , "woman dancing: medium-light skin tone" => crate :: people_and_body :: person_activity :: WOMAN_DANCING_MEDIUM_LIGHT_SKIN_TONE , "woman dancing: medium skin tone" => crate :: people_and_body :: person_activity :: WOMAN_DANCING_MEDIUM_SKIN_TONE , "woman dancing: medium-dark skin tone" => crate :: people_and_body :: person_activity :: WOMAN_DANCING_MEDIUM_DARK_SKIN_TONE , "woman dancing: dark skin tone" => crate :: people_and_body :: person_activity :: WOMAN_DANCING_DARK_SKIN_TONE , "man dancing" => crate :: people_and_body :: person_activity :: MAN_DANCING , "man dancing: light skin tone" => crate :: people_and_body :: person_activity :: MAN_DANCING_LIGHT_SKIN_TONE , "man dancing: medium-light skin tone" => crate :: people_and_body :: person_activity :: MAN_DANCING_MEDIUM_LIGHT_SKIN_TONE , "man dancing: medium skin tone" => crate :: people_and_body :: person_activity :: MAN_DANCING_MEDIUM_SKIN_TONE , "man dancing: medium-dark skin tone" => crate :: people_and_body :: person_activity :: MAN_DANCING_MEDIUM_DARK_SKIN_TONE , "man dancing: dark skin tone" => crate :: people_and_body :: person_activity :: MAN_DANCING_DARK_SKIN_TONE , "person in suit levitating" => crate :: people_and_body :: person_activity :: PERSON_IN_SUIT_LEVITATING , "person in suit levitating: light skin tone" => crate :: people_and_body :: person_activity :: PERSON_IN_SUIT_LEVITATING_LIGHT_SKIN_TONE , "person in suit levitating: medium-light skin tone" => crate :: people_and_body :: person_activity :: PERSON_IN_SUIT_LEVITATING_MEDIUM_LIGHT_SKIN_TONE , "person in suit levitating: medium skin tone" => crate :: people_and_body :: person_activity :: PERSON_IN_SUIT_LEVITATING_MEDIUM_SKIN_TONE , "person in suit levitating: medium-dark skin tone" => crate :: people_and_body :: person_activity :: PERSON_IN_SUIT_LEVITATING_MEDIUM_DARK_SKIN_TONE , "person in suit levitating: dark skin tone" => crate :: people_and_body :: person_activity :: PERSON_IN_SUIT_LEVITATING_DARK_SKIN_TONE , "people with bunny ears" => crate :: people_and_body :: person_activity :: PEOPLE_WITH_BUNNY_EARS , "men with bunny ears" => crate :: people_and_body :: person_activity :: MEN_WITH_BUNNY_EARS , "women with bunny ears" => crate :: people_and_body :: person_activity :: WOMEN_WITH_BUNNY_EARS , "person in steamy room" => crate :: people_and_body :: person_activity :: PERSON_IN_STEAMY_ROOM , "person in steamy room: light skin tone" => crate :: people_and_body :: person_activity :: PERSON_IN_STEAMY_ROOM_LIGHT_SKIN_TONE , "person in steamy room: medium-light skin tone" => crate :: people_and_body :: person_activity :: PERSON_IN_STEAMY_ROOM_MEDIUM_LIGHT_SKIN_TONE , "person in steamy room: medium skin tone" => crate :: people_and_body :: person_activity :: PERSON_IN_STEAMY_ROOM_MEDIUM_SKIN_TONE , "person in steamy room: medium-dark skin tone" => crate :: people_and_body :: person_activity :: PERSON_IN_STEAMY_ROOM_MEDIUM_DARK_SKIN_TONE , "person in steamy room: dark skin tone" => crate :: people_and_body :: person_activity :: PERSON_IN_STEAMY_ROOM_DARK_SKIN_TONE , "man in steamy room" => crate :: people_and_body :: person_activity :: MAN_IN_STEAMY_ROOM , "man in steamy room: light skin tone" => crate :: people_and_body :: person_activity :: MAN_IN_STEAMY_ROOM_LIGHT_SKIN_TONE , "man in steamy room: medium-light skin tone" => crate :: people_and_body :: person_activity :: MAN_IN_STEAMY_ROOM_MEDIUM_LIGHT_SKIN_TONE , "man in steamy room: medium skin tone" => crate :: people_and_body :: person_activity :: MAN_IN_STEAMY_ROOM_MEDIUM_SKIN_TONE , "man in steamy room: medium-dark skin tone" => crate :: people_and_body :: person_activity :: MAN_IN_STEAMY_ROOM_MEDIUM_DARK_SKIN_TONE , "man in steamy room: dark skin tone" => crate :: people_and_body :: person_activity :: MAN_IN_STEAMY_ROOM_DARK_SKIN_TONE , "woman in steamy room" => crate :: people_and_body :: person_activity :: WOMAN_IN_STEAMY_ROOM , "woman in steamy room: light skin tone" => crate :: people_and_body :: person_activity :: WOMAN_IN_STEAMY_ROOM_LIGHT_SKIN_TONE , "woman in steamy room: medium-light skin tone" => crate :: people_and_body :: person_activity :: WOMAN_IN_STEAMY_ROOM_MEDIUM_LIGHT_SKIN_TONE , "woman in steamy room: medium skin tone" => crate :: people_and_body :: person_activity :: WOMAN_IN_STEAMY_ROOM_MEDIUM_SKIN_TONE , "woman in steamy room: medium-dark skin tone" => crate :: people_and_body :: person_activity :: WOMAN_IN_STEAMY_ROOM_MEDIUM_DARK_SKIN_TONE , "woman in steamy room: dark skin tone" => crate :: people_and_body :: person_activity :: WOMAN_IN_STEAMY_ROOM_DARK_SKIN_TONE , "person climbing" => crate :: people_and_body :: person_activity :: PERSON_CLIMBING , "person climbing: light skin tone" => crate :: people_and_body :: person_activity :: PERSON_CLIMBING_LIGHT_SKIN_TONE , "person climbing: medium-light skin tone" => crate :: people_and_body :: person_activity :: PERSON_CLIMBING_MEDIUM_LIGHT_SKIN_TONE , "person climbing: medium skin tone" => crate :: people_and_body :: person_activity :: PERSON_CLIMBING_MEDIUM_SKIN_TONE , "person climbing: medium-dark skin tone" => crate :: people_and_body :: person_activity :: PERSON_CLIMBING_MEDIUM_DARK_SKIN_TONE , "person climbing: dark skin tone" => crate :: people_and_body :: person_activity :: PERSON_CLIMBING_DARK_SKIN_TONE , "man climbing" => crate :: people_and_body :: person_activity :: MAN_CLIMBING , "man climbing: light skin tone" => crate :: people_and_body :: person_activity :: MAN_CLIMBING_LIGHT_SKIN_TONE , "man climbing: medium-light skin tone" => crate :: people_and_body :: person_activity :: MAN_CLIMBING_MEDIUM_LIGHT_SKIN_TONE , "man climbing: medium skin tone" => crate :: people_and_body :: person_activity :: MAN_CLIMBING_MEDIUM_SKIN_TONE , "man climbing: medium-dark skin tone" => crate :: people_and_body :: person_activity :: MAN_CLIMBING_MEDIUM_DARK_SKIN_TONE , "man climbing: dark skin tone" => crate :: people_and_body :: person_activity :: MAN_CLIMBING_DARK_SKIN_TONE , "woman climbing" => crate :: people_and_body :: person_activity :: WOMAN_CLIMBING , "woman climbing: light skin tone" => crate :: people_and_body :: person_activity :: WOMAN_CLIMBING_LIGHT_SKIN_TONE , "woman climbing: medium-light skin tone" => crate :: people_and_body :: person_activity :: WOMAN_CLIMBING_MEDIUM_LIGHT_SKIN_TONE , "woman climbing: medium skin tone" => crate :: people_and_body :: person_activity :: WOMAN_CLIMBING_MEDIUM_SKIN_TONE , "woman climbing: medium-dark skin tone" => crate :: people_and_body :: person_activity :: WOMAN_CLIMBING_MEDIUM_DARK_SKIN_TONE , "woman climbing: dark skin tone" => crate :: people_and_body :: person_activity :: WOMAN_CLIMBING_DARK_SKIN_TONE , "person fencing" => crate :: people_and_body :: person_sport :: PERSON_FENCING , "horse racing" => crate :: people_and_body :: person_sport :: HORSE_RACING , "horse racing: light skin tone" => crate :: people_and_body :: person_sport :: HORSE_RACING_LIGHT_SKIN_TONE , "horse racing: medium-light skin tone" => crate :: people_and_body :: person_sport :: HORSE_RACING_MEDIUM_LIGHT_SKIN_TONE , "horse racing: medium skin tone" => crate :: people_and_body :: person_sport :: HORSE_RACING_MEDIUM_SKIN_TONE , "horse racing: medium-dark skin tone" => crate :: people_and_body :: person_sport :: HORSE_RACING_MEDIUM_DARK_SKIN_TONE , "horse racing: dark skin tone" => crate :: people_and_body :: person_sport :: HORSE_RACING_DARK_SKIN_TONE , "skier" => crate :: people_and_body :: person_sport :: SKIER , "snowboarder" => crate :: people_and_body :: person_sport :: SNOWBOARDER , "snowboarder: light skin tone" => crate :: people_and_body :: person_sport :: SNOWBOARDER_LIGHT_SKIN_TONE , "snowboarder: medium-light skin tone" => crate :: people_and_body :: person_sport :: SNOWBOARDER_MEDIUM_LIGHT_SKIN_TONE , "snowboarder: medium skin tone" => crate :: people_and_body :: person_sport :: SNOWBOARDER_MEDIUM_SKIN_TONE , "snowboarder: medium-dark skin tone" => crate :: people_and_body :: person_sport :: SNOWBOARDER_MEDIUM_DARK_SKIN_TONE , "snowboarder: dark skin tone" => crate :: people_and_body :: person_sport :: SNOWBOARDER_DARK_SKIN_TONE , "person golfing" => crate :: people_and_body :: person_sport :: PERSON_GOLFING , "person golfing: light skin tone" => crate :: people_and_body :: person_sport :: PERSON_GOLFING_LIGHT_SKIN_TONE , "person golfing: medium-light skin tone" => crate :: people_and_body :: person_sport :: PERSON_GOLFING_MEDIUM_LIGHT_SKIN_TONE , "person golfing: medium skin tone" => crate :: people_and_body :: person_sport :: PERSON_GOLFING_MEDIUM_SKIN_TONE , "person golfing: medium-dark skin tone" => crate :: people_and_body :: person_sport :: PERSON_GOLFING_MEDIUM_DARK_SKIN_TONE , "person golfing: dark skin tone" => crate :: people_and_body :: person_sport :: PERSON_GOLFING_DARK_SKIN_TONE , "man golfing" => crate :: people_and_body :: person_sport :: MAN_GOLFING , "man golfing: light skin tone" => crate :: people_and_body :: person_sport :: MAN_GOLFING_LIGHT_SKIN_TONE , "man golfing: medium-light skin tone" => crate :: people_and_body :: person_sport :: MAN_GOLFING_MEDIUM_LIGHT_SKIN_TONE , "man golfing: medium skin tone" => crate :: people_and_body :: person_sport :: MAN_GOLFING_MEDIUM_SKIN_TONE , "man golfing: medium-dark skin tone" => crate :: people_and_body :: person_sport :: MAN_GOLFING_MEDIUM_DARK_SKIN_TONE , "man golfing: dark skin tone" => crate :: people_and_body :: person_sport :: MAN_GOLFING_DARK_SKIN_TONE , "woman golfing" => crate :: people_and_body :: person_sport :: WOMAN_GOLFING , "woman golfing: light skin tone" => crate :: people_and_body :: person_sport :: WOMAN_GOLFING_LIGHT_SKIN_TONE , "woman golfing: medium-light skin tone" => crate :: people_and_body :: person_sport :: WOMAN_GOLFING_MEDIUM_LIGHT_SKIN_TONE , "woman golfing: medium skin tone" => crate :: people_and_body :: person_sport :: WOMAN_GOLFING_MEDIUM_SKIN_TONE , "woman golfing: medium-dark skin tone" => crate :: people_and_body :: person_sport :: WOMAN_GOLFING_MEDIUM_DARK_SKIN_TONE , "woman golfing: dark skin tone" => crate :: people_and_body :: person_sport :: WOMAN_GOLFING_DARK_SKIN_TONE , "person surfing" => crate :: people_and_body :: person_sport :: PERSON_SURFING , "person surfing: light skin tone" => crate :: people_and_body :: person_sport :: PERSON_SURFING_LIGHT_SKIN_TONE , "person surfing: medium-light skin tone" => crate :: people_and_body :: person_sport :: PERSON_SURFING_MEDIUM_LIGHT_SKIN_TONE , "person surfing: medium skin tone" => crate :: people_and_body :: person_sport :: PERSON_SURFING_MEDIUM_SKIN_TONE , "person surfing: medium-dark skin tone" => crate :: people_and_body :: person_sport :: PERSON_SURFING_MEDIUM_DARK_SKIN_TONE , "person surfing: dark skin tone" => crate :: people_and_body :: person_sport :: PERSON_SURFING_DARK_SKIN_TONE , "man surfing" => crate :: people_and_body :: person_sport :: MAN_SURFING , "man surfing: light skin tone" => crate :: people_and_body :: person_sport :: MAN_SURFING_LIGHT_SKIN_TONE , "man surfing: medium-light skin tone" => crate :: people_and_body :: person_sport :: MAN_SURFING_MEDIUM_LIGHT_SKIN_TONE , "man surfing: medium skin tone" => crate :: people_and_body :: person_sport :: MAN_SURFING_MEDIUM_SKIN_TONE , "man surfing: medium-dark skin tone" => crate :: people_and_body :: person_sport :: MAN_SURFING_MEDIUM_DARK_SKIN_TONE , "man surfing: dark skin tone" => crate :: people_and_body :: person_sport :: MAN_SURFING_DARK_SKIN_TONE , "woman surfing" => crate :: people_and_body :: person_sport :: WOMAN_SURFING , "woman surfing: light skin tone" => crate :: people_and_body :: person_sport :: WOMAN_SURFING_LIGHT_SKIN_TONE , "woman surfing: medium-light skin tone" => crate :: people_and_body :: person_sport :: WOMAN_SURFING_MEDIUM_LIGHT_SKIN_TONE , "woman surfing: medium skin tone" => crate :: people_and_body :: person_sport :: WOMAN_SURFING_MEDIUM_SKIN_TONE , "woman surfing: medium-dark skin tone" => crate :: people_and_body :: person_sport :: WOMAN_SURFING_MEDIUM_DARK_SKIN_TONE , "woman surfing: dark skin tone" => crate :: people_and_body :: person_sport :: WOMAN_SURFING_DARK_SKIN_TONE , "person rowing boat" => crate :: people_and_body :: person_sport :: PERSON_ROWING_BOAT , "person rowing boat: light skin tone" => crate :: people_and_body :: person_sport :: PERSON_ROWING_BOAT_LIGHT_SKIN_TONE , "person rowing boat: medium-light skin tone" => crate :: people_and_body :: person_sport :: PERSON_ROWING_BOAT_MEDIUM_LIGHT_SKIN_TONE , "person rowing boat: medium skin tone" => crate :: people_and_body :: person_sport :: PERSON_ROWING_BOAT_MEDIUM_SKIN_TONE , "person rowing boat: medium-dark skin tone" => crate :: people_and_body :: person_sport :: PERSON_ROWING_BOAT_MEDIUM_DARK_SKIN_TONE , "person rowing boat: dark skin tone" => crate :: people_and_body :: person_sport :: PERSON_ROWING_BOAT_DARK_SKIN_TONE , "man rowing boat" => crate :: people_and_body :: person_sport :: MAN_ROWING_BOAT , "man rowing boat: light skin tone" => crate :: people_and_body :: person_sport :: MAN_ROWING_BOAT_LIGHT_SKIN_TONE , "man rowing boat: medium-light skin tone" => crate :: people_and_body :: person_sport :: MAN_ROWING_BOAT_MEDIUM_LIGHT_SKIN_TONE , "man rowing boat: medium skin tone" => crate :: people_and_body :: person_sport :: MAN_ROWING_BOAT_MEDIUM_SKIN_TONE , "man rowing boat: medium-dark skin tone" => crate :: people_and_body :: person_sport :: MAN_ROWING_BOAT_MEDIUM_DARK_SKIN_TONE , "man rowing boat: dark skin tone" => crate :: people_and_body :: person_sport :: MAN_ROWING_BOAT_DARK_SKIN_TONE , "woman rowing boat" => crate :: people_and_body :: person_sport :: WOMAN_ROWING_BOAT , "woman rowing boat: light skin tone" => crate :: people_and_body :: person_sport :: WOMAN_ROWING_BOAT_LIGHT_SKIN_TONE , "woman rowing boat: medium-light skin tone" => crate :: people_and_body :: person_sport :: WOMAN_ROWING_BOAT_MEDIUM_LIGHT_SKIN_TONE , "woman rowing boat: medium skin tone" => crate :: people_and_body :: person_sport :: WOMAN_ROWING_BOAT_MEDIUM_SKIN_TONE , "woman rowing boat: medium-dark skin tone" => crate :: people_and_body :: person_sport :: WOMAN_ROWING_BOAT_MEDIUM_DARK_SKIN_TONE , "woman rowing boat: dark skin tone" => crate :: people_and_body :: person_sport :: WOMAN_ROWING_BOAT_DARK_SKIN_TONE , "person swimming" => crate :: people_and_body :: person_sport :: PERSON_SWIMMING , "person swimming: light skin tone" => crate :: people_and_body :: person_sport :: PERSON_SWIMMING_LIGHT_SKIN_TONE , "person swimming: medium-light skin tone" => crate :: people_and_body :: person_sport :: PERSON_SWIMMING_MEDIUM_LIGHT_SKIN_TONE , "person swimming: medium skin tone" => crate :: people_and_body :: person_sport :: PERSON_SWIMMING_MEDIUM_SKIN_TONE , "person swimming: medium-dark skin tone" => crate :: people_and_body :: person_sport :: PERSON_SWIMMING_MEDIUM_DARK_SKIN_TONE , "person swimming: dark skin tone" => crate :: people_and_body :: person_sport :: PERSON_SWIMMING_DARK_SKIN_TONE , "man swimming" => crate :: people_and_body :: person_sport :: MAN_SWIMMING , "man swimming: light skin tone" => crate :: people_and_body :: person_sport :: MAN_SWIMMING_LIGHT_SKIN_TONE , "man swimming: medium-light skin tone" => crate :: people_and_body :: person_sport :: MAN_SWIMMING_MEDIUM_LIGHT_SKIN_TONE , "man swimming: medium skin tone" => crate :: people_and_body :: person_sport :: MAN_SWIMMING_MEDIUM_SKIN_TONE , "man swimming: medium-dark skin tone" => crate :: people_and_body :: person_sport :: MAN_SWIMMING_MEDIUM_DARK_SKIN_TONE , "man swimming: dark skin tone" => crate :: people_and_body :: person_sport :: MAN_SWIMMING_DARK_SKIN_TONE , "woman swimming" => crate :: people_and_body :: person_sport :: WOMAN_SWIMMING , "woman swimming: light skin tone" => crate :: people_and_body :: person_sport :: WOMAN_SWIMMING_LIGHT_SKIN_TONE , "woman swimming: medium-light skin tone" => crate :: people_and_body :: person_sport :: WOMAN_SWIMMING_MEDIUM_LIGHT_SKIN_TONE , "woman swimming: medium skin tone" => crate :: people_and_body :: person_sport :: WOMAN_SWIMMING_MEDIUM_SKIN_TONE , "woman swimming: medium-dark skin tone" => crate :: people_and_body :: person_sport :: WOMAN_SWIMMING_MEDIUM_DARK_SKIN_TONE , "woman swimming: dark skin tone" => crate :: people_and_body :: person_sport :: WOMAN_SWIMMING_DARK_SKIN_TONE , "person bouncing ball" => crate :: people_and_body :: person_sport :: PERSON_BOUNCING_BALL , "person bouncing ball: light skin tone" => crate :: people_and_body :: person_sport :: PERSON_BOUNCING_BALL_LIGHT_SKIN_TONE , "person bouncing ball: medium-light skin tone" => crate :: people_and_body :: person_sport :: PERSON_BOUNCING_BALL_MEDIUM_LIGHT_SKIN_TONE , "person bouncing ball: medium skin tone" => crate :: people_and_body :: person_sport :: PERSON_BOUNCING_BALL_MEDIUM_SKIN_TONE , "person bouncing ball: medium-dark skin tone" => crate :: people_and_body :: person_sport :: PERSON_BOUNCING_BALL_MEDIUM_DARK_SKIN_TONE , "person bouncing ball: dark skin tone" => crate :: people_and_body :: person_sport :: PERSON_BOUNCING_BALL_DARK_SKIN_TONE , "man bouncing ball" => crate :: people_and_body :: person_sport :: MAN_BOUNCING_BALL , "man bouncing ball: light skin tone" => crate :: people_and_body :: person_sport :: MAN_BOUNCING_BALL_LIGHT_SKIN_TONE , "man bouncing ball: medium-light skin tone" => crate :: people_and_body :: person_sport :: MAN_BOUNCING_BALL_MEDIUM_LIGHT_SKIN_TONE , "man bouncing ball: medium skin tone" => crate :: people_and_body :: person_sport :: MAN_BOUNCING_BALL_MEDIUM_SKIN_TONE , "man bouncing ball: medium-dark skin tone" => crate :: people_and_body :: person_sport :: MAN_BOUNCING_BALL_MEDIUM_DARK_SKIN_TONE , "man bouncing ball: dark skin tone" => crate :: people_and_body :: person_sport :: MAN_BOUNCING_BALL_DARK_SKIN_TONE , "woman bouncing ball" => crate :: people_and_body :: person_sport :: WOMAN_BOUNCING_BALL , "woman bouncing ball: light skin tone" => crate :: people_and_body :: person_sport :: WOMAN_BOUNCING_BALL_LIGHT_SKIN_TONE , "woman bouncing ball: medium-light skin tone" => crate :: people_and_body :: person_sport :: WOMAN_BOUNCING_BALL_MEDIUM_LIGHT_SKIN_TONE , "woman bouncing ball: medium skin tone" => crate :: people_and_body :: person_sport :: WOMAN_BOUNCING_BALL_MEDIUM_SKIN_TONE , "woman bouncing ball: medium-dark skin tone" => crate :: people_and_body :: person_sport :: WOMAN_BOUNCING_BALL_MEDIUM_DARK_SKIN_TONE , "woman bouncing ball: dark skin tone" => crate :: people_and_body :: person_sport :: WOMAN_BOUNCING_BALL_DARK_SKIN_TONE , "person lifting weights" => crate :: people_and_body :: person_sport :: PERSON_LIFTING_WEIGHTS , "person lifting weights: light skin tone" => crate :: people_and_body :: person_sport :: PERSON_LIFTING_WEIGHTS_LIGHT_SKIN_TONE , "person lifting weights: medium-light skin tone" => crate :: people_and_body :: person_sport :: PERSON_LIFTING_WEIGHTS_MEDIUM_LIGHT_SKIN_TONE , "person lifting weights: medium skin tone" => crate :: people_and_body :: person_sport :: PERSON_LIFTING_WEIGHTS_MEDIUM_SKIN_TONE , "person lifting weights: medium-dark skin tone" => crate :: people_and_body :: person_sport :: PERSON_LIFTING_WEIGHTS_MEDIUM_DARK_SKIN_TONE , "person lifting weights: dark skin tone" => crate :: people_and_body :: person_sport :: PERSON_LIFTING_WEIGHTS_DARK_SKIN_TONE , "man lifting weights" => crate :: people_and_body :: person_sport :: MAN_LIFTING_WEIGHTS , "man lifting weights: light skin tone" => crate :: people_and_body :: person_sport :: MAN_LIFTING_WEIGHTS_LIGHT_SKIN_TONE , "man lifting weights: medium-light skin tone" => crate :: people_and_body :: person_sport :: MAN_LIFTING_WEIGHTS_MEDIUM_LIGHT_SKIN_TONE , "man lifting weights: medium skin tone" => crate :: people_and_body :: person_sport :: MAN_LIFTING_WEIGHTS_MEDIUM_SKIN_TONE , "man lifting weights: medium-dark skin tone" => crate :: people_and_body :: person_sport :: MAN_LIFTING_WEIGHTS_MEDIUM_DARK_SKIN_TONE , "man lifting weights: dark skin tone" => crate :: people_and_body :: person_sport :: MAN_LIFTING_WEIGHTS_DARK_SKIN_TONE , "woman lifting weights" => crate :: people_and_body :: person_sport :: WOMAN_LIFTING_WEIGHTS , "woman lifting weights: light skin tone" => crate :: people_and_body :: person_sport :: WOMAN_LIFTING_WEIGHTS_LIGHT_SKIN_TONE , "woman lifting weights: medium-light skin tone" => crate :: people_and_body :: person_sport :: WOMAN_LIFTING_WEIGHTS_MEDIUM_LIGHT_SKIN_TONE , "woman lifting weights: medium skin tone" => crate :: people_and_body :: person_sport :: WOMAN_LIFTING_WEIGHTS_MEDIUM_SKIN_TONE , "woman lifting weights: medium-dark skin tone" => crate :: people_and_body :: person_sport :: WOMAN_LIFTING_WEIGHTS_MEDIUM_DARK_SKIN_TONE , "woman lifting weights: dark skin tone" => crate :: people_and_body :: person_sport :: WOMAN_LIFTING_WEIGHTS_DARK_SKIN_TONE , "person biking" => crate :: people_and_body :: person_sport :: PERSON_BIKING , "person biking: light skin tone" => crate :: people_and_body :: person_sport :: PERSON_BIKING_LIGHT_SKIN_TONE , "person biking: medium-light skin tone" => crate :: people_and_body :: person_sport :: PERSON_BIKING_MEDIUM_LIGHT_SKIN_TONE , "person biking: medium skin tone" => crate :: people_and_body :: person_sport :: PERSON_BIKING_MEDIUM_SKIN_TONE , "person biking: medium-dark skin tone" => crate :: people_and_body :: person_sport :: PERSON_BIKING_MEDIUM_DARK_SKIN_TONE , "person biking: dark skin tone" => crate :: people_and_body :: person_sport :: PERSON_BIKING_DARK_SKIN_TONE , "man biking" => crate :: people_and_body :: person_sport :: MAN_BIKING , "man biking: light skin tone" => crate :: people_and_body :: person_sport :: MAN_BIKING_LIGHT_SKIN_TONE , "man biking: medium-light skin tone" => crate :: people_and_body :: person_sport :: MAN_BIKING_MEDIUM_LIGHT_SKIN_TONE , "man biking: medium skin tone" => crate :: people_and_body :: person_sport :: MAN_BIKING_MEDIUM_SKIN_TONE , "man biking: medium-dark skin tone" => crate :: people_and_body :: person_sport :: MAN_BIKING_MEDIUM_DARK_SKIN_TONE , "man biking: dark skin tone" => crate :: people_and_body :: person_sport :: MAN_BIKING_DARK_SKIN_TONE , "woman biking" => crate :: people_and_body :: person_sport :: WOMAN_BIKING , "woman biking: light skin tone" => crate :: people_and_body :: person_sport :: WOMAN_BIKING_LIGHT_SKIN_TONE , "woman biking: medium-light skin tone" => crate :: people_and_body :: person_sport :: WOMAN_BIKING_MEDIUM_LIGHT_SKIN_TONE , "woman biking: medium skin tone" => crate :: people_and_body :: person_sport :: WOMAN_BIKING_MEDIUM_SKIN_TONE , "woman biking: medium-dark skin tone" => crate :: people_and_body :: person_sport :: WOMAN_BIKING_MEDIUM_DARK_SKIN_TONE , "woman biking: dark skin tone" => crate :: people_and_body :: person_sport :: WOMAN_BIKING_DARK_SKIN_TONE , "person mountain biking" => crate :: people_and_body :: person_sport :: PERSON_MOUNTAIN_BIKING , "person mountain biking: light skin tone" => crate :: people_and_body :: person_sport :: PERSON_MOUNTAIN_BIKING_LIGHT_SKIN_TONE , "person mountain biking: medium-light skin tone" => crate :: people_and_body :: person_sport :: PERSON_MOUNTAIN_BIKING_MEDIUM_LIGHT_SKIN_TONE , "person mountain biking: medium skin tone" => crate :: people_and_body :: person_sport :: PERSON_MOUNTAIN_BIKING_MEDIUM_SKIN_TONE , "person mountain biking: medium-dark skin tone" => crate :: people_and_body :: person_sport :: PERSON_MOUNTAIN_BIKING_MEDIUM_DARK_SKIN_TONE , "person mountain biking: dark skin tone" => crate :: people_and_body :: person_sport :: PERSON_MOUNTAIN_BIKING_DARK_SKIN_TONE , "man mountain biking" => crate :: people_and_body :: person_sport :: MAN_MOUNTAIN_BIKING , "man mountain biking: light skin tone" => crate :: people_and_body :: person_sport :: MAN_MOUNTAIN_BIKING_LIGHT_SKIN_TONE , "man mountain biking: medium-light skin tone" => crate :: people_and_body :: person_sport :: MAN_MOUNTAIN_BIKING_MEDIUM_LIGHT_SKIN_TONE , "man mountain biking: medium skin tone" => crate :: people_and_body :: person_sport :: MAN_MOUNTAIN_BIKING_MEDIUM_SKIN_TONE , "man mountain biking: medium-dark skin tone" => crate :: people_and_body :: person_sport :: MAN_MOUNTAIN_BIKING_MEDIUM_DARK_SKIN_TONE , "man mountain biking: dark skin tone" => crate :: people_and_body :: person_sport :: MAN_MOUNTAIN_BIKING_DARK_SKIN_TONE , "woman mountain biking" => crate :: people_and_body :: person_sport :: WOMAN_MOUNTAIN_BIKING , "woman mountain biking: light skin tone" => crate :: people_and_body :: person_sport :: WOMAN_MOUNTAIN_BIKING_LIGHT_SKIN_TONE , "woman mountain biking: medium-light skin tone" => crate :: people_and_body :: person_sport :: WOMAN_MOUNTAIN_BIKING_MEDIUM_LIGHT_SKIN_TONE , "woman mountain biking: medium skin tone" => crate :: people_and_body :: person_sport :: WOMAN_MOUNTAIN_BIKING_MEDIUM_SKIN_TONE , "woman mountain biking: medium-dark skin tone" => crate :: people_and_body :: person_sport :: WOMAN_MOUNTAIN_BIKING_MEDIUM_DARK_SKIN_TONE , "woman mountain biking: dark skin tone" => crate :: people_and_body :: person_sport :: WOMAN_MOUNTAIN_BIKING_DARK_SKIN_TONE , "person cartwheeling" => crate :: people_and_body :: person_sport :: PERSON_CARTWHEELING , "person cartwheeling: light skin tone" => crate :: people_and_body :: person_sport :: PERSON_CARTWHEELING_LIGHT_SKIN_TONE , "person cartwheeling: medium-light skin tone" => crate :: people_and_body :: person_sport :: PERSON_CARTWHEELING_MEDIUM_LIGHT_SKIN_TONE , "person cartwheeling: medium skin tone" => crate :: people_and_body :: person_sport :: PERSON_CARTWHEELING_MEDIUM_SKIN_TONE , "person cartwheeling: medium-dark skin tone" => crate :: people_and_body :: person_sport :: PERSON_CARTWHEELING_MEDIUM_DARK_SKIN_TONE , "person cartwheeling: dark skin tone" => crate :: people_and_body :: person_sport :: PERSON_CARTWHEELING_DARK_SKIN_TONE , "man cartwheeling" => crate :: people_and_body :: person_sport :: MAN_CARTWHEELING , "man cartwheeling: light skin tone" => crate :: people_and_body :: person_sport :: MAN_CARTWHEELING_LIGHT_SKIN_TONE , "man cartwheeling: medium-light skin tone" => crate :: people_and_body :: person_sport :: MAN_CARTWHEELING_MEDIUM_LIGHT_SKIN_TONE , "man cartwheeling: medium skin tone" => crate :: people_and_body :: person_sport :: MAN_CARTWHEELING_MEDIUM_SKIN_TONE , "man cartwheeling: medium-dark skin tone" => crate :: people_and_body :: person_sport :: MAN_CARTWHEELING_MEDIUM_DARK_SKIN_TONE , "man cartwheeling: dark skin tone" => crate :: people_and_body :: person_sport :: MAN_CARTWHEELING_DARK_SKIN_TONE , "woman cartwheeling" => crate :: people_and_body :: person_sport :: WOMAN_CARTWHEELING , "woman cartwheeling: light skin tone" => crate :: people_and_body :: person_sport :: WOMAN_CARTWHEELING_LIGHT_SKIN_TONE , "woman cartwheeling: medium-light skin tone" => crate :: people_and_body :: person_sport :: WOMAN_CARTWHEELING_MEDIUM_LIGHT_SKIN_TONE , "woman cartwheeling: medium skin tone" => crate :: people_and_body :: person_sport :: WOMAN_CARTWHEELING_MEDIUM_SKIN_TONE , "woman cartwheeling: medium-dark skin tone" => crate :: people_and_body :: person_sport :: WOMAN_CARTWHEELING_MEDIUM_DARK_SKIN_TONE , "woman cartwheeling: dark skin tone" => crate :: people_and_body :: person_sport :: WOMAN_CARTWHEELING_DARK_SKIN_TONE , "people wrestling" => crate :: people_and_body :: person_sport :: PEOPLE_WRESTLING , "men wrestling" => crate :: people_and_body :: person_sport :: MEN_WRESTLING , "women wrestling" => crate :: people_and_body :: person_sport :: WOMEN_WRESTLING , "person playing water polo" => crate :: people_and_body :: person_sport :: PERSON_PLAYING_WATER_POLO , "person playing water polo: light skin tone" => crate :: people_and_body :: person_sport :: PERSON_PLAYING_WATER_POLO_LIGHT_SKIN_TONE , "person playing water polo: medium-light skin tone" => crate :: people_and_body :: person_sport :: PERSON_PLAYING_WATER_POLO_MEDIUM_LIGHT_SKIN_TONE , "person playing water polo: medium skin tone" => crate :: people_and_body :: person_sport :: PERSON_PLAYING_WATER_POLO_MEDIUM_SKIN_TONE , "person playing water polo: medium-dark skin tone" => crate :: people_and_body :: person_sport :: PERSON_PLAYING_WATER_POLO_MEDIUM_DARK_SKIN_TONE , "person playing water polo: dark skin tone" => crate :: people_and_body :: person_sport :: PERSON_PLAYING_WATER_POLO_DARK_SKIN_TONE , "man playing water polo" => crate :: people_and_body :: person_sport :: MAN_PLAYING_WATER_POLO , "man playing water polo: light skin tone" => crate :: people_and_body :: person_sport :: MAN_PLAYING_WATER_POLO_LIGHT_SKIN_TONE , "man playing water polo: medium-light skin tone" => crate :: people_and_body :: person_sport :: MAN_PLAYING_WATER_POLO_MEDIUM_LIGHT_SKIN_TONE , "man playing water polo: medium skin tone" => crate :: people_and_body :: person_sport :: MAN_PLAYING_WATER_POLO_MEDIUM_SKIN_TONE , "man playing water polo: medium-dark skin tone" => crate :: people_and_body :: person_sport :: MAN_PLAYING_WATER_POLO_MEDIUM_DARK_SKIN_TONE , "man playing water polo: dark skin tone" => crate :: people_and_body :: person_sport :: MAN_PLAYING_WATER_POLO_DARK_SKIN_TONE , "woman playing water polo" => crate :: people_and_body :: person_sport :: WOMAN_PLAYING_WATER_POLO , "woman playing water polo: light skin tone" => crate :: people_and_body :: person_sport :: WOMAN_PLAYING_WATER_POLO_LIGHT_SKIN_TONE , "woman playing water polo: medium-light skin tone" => crate :: people_and_body :: person_sport :: WOMAN_PLAYING_WATER_POLO_MEDIUM_LIGHT_SKIN_TONE , "woman playing water polo: medium skin tone" => crate :: people_and_body :: person_sport :: WOMAN_PLAYING_WATER_POLO_MEDIUM_SKIN_TONE , "woman playing water polo: medium-dark skin tone" => crate :: people_and_body :: person_sport :: WOMAN_PLAYING_WATER_POLO_MEDIUM_DARK_SKIN_TONE , "woman playing water polo: dark skin tone" => crate :: people_and_body :: person_sport :: WOMAN_PLAYING_WATER_POLO_DARK_SKIN_TONE , "person playing handball" => crate :: people_and_body :: person_sport :: PERSON_PLAYING_HANDBALL , "person playing handball: light skin tone" => crate :: people_and_body :: person_sport :: PERSON_PLAYING_HANDBALL_LIGHT_SKIN_TONE , "person playing handball: medium-light skin tone" => crate :: people_and_body :: person_sport :: PERSON_PLAYING_HANDBALL_MEDIUM_LIGHT_SKIN_TONE , "person playing handball: medium skin tone" => crate :: people_and_body :: person_sport :: PERSON_PLAYING_HANDBALL_MEDIUM_SKIN_TONE , "person playing handball: medium-dark skin tone" => crate :: people_and_body :: person_sport :: PERSON_PLAYING_HANDBALL_MEDIUM_DARK_SKIN_TONE , "person playing handball: dark skin tone" => crate :: people_and_body :: person_sport :: PERSON_PLAYING_HANDBALL_DARK_SKIN_TONE , "man playing handball" => crate :: people_and_body :: person_sport :: MAN_PLAYING_HANDBALL , "man playing handball: light skin tone" => crate :: people_and_body :: person_sport :: MAN_PLAYING_HANDBALL_LIGHT_SKIN_TONE , "man playing handball: medium-light skin tone" => crate :: people_and_body :: person_sport :: MAN_PLAYING_HANDBALL_MEDIUM_LIGHT_SKIN_TONE , "man playing handball: medium skin tone" => crate :: people_and_body :: person_sport :: MAN_PLAYING_HANDBALL_MEDIUM_SKIN_TONE , "man playing handball: medium-dark skin tone" => crate :: people_and_body :: person_sport :: MAN_PLAYING_HANDBALL_MEDIUM_DARK_SKIN_TONE , "man playing handball: dark skin tone" => crate :: people_and_body :: person_sport :: MAN_PLAYING_HANDBALL_DARK_SKIN_TONE , "woman playing handball" => crate :: people_and_body :: person_sport :: WOMAN_PLAYING_HANDBALL , "woman playing handball: light skin tone" => crate :: people_and_body :: person_sport :: WOMAN_PLAYING_HANDBALL_LIGHT_SKIN_TONE , "woman playing handball: medium-light skin tone" => crate :: people_and_body :: person_sport :: WOMAN_PLAYING_HANDBALL_MEDIUM_LIGHT_SKIN_TONE , "woman playing handball: medium skin tone" => crate :: people_and_body :: person_sport :: WOMAN_PLAYING_HANDBALL_MEDIUM_SKIN_TONE , "woman playing handball: medium-dark skin tone" => crate :: people_and_body :: person_sport :: WOMAN_PLAYING_HANDBALL_MEDIUM_DARK_SKIN_TONE , "woman playing handball: dark skin tone" => crate :: people_and_body :: person_sport :: WOMAN_PLAYING_HANDBALL_DARK_SKIN_TONE , "person juggling" => crate :: people_and_body :: person_sport :: PERSON_JUGGLING , "person juggling: light skin tone" => crate :: people_and_body :: person_sport :: PERSON_JUGGLING_LIGHT_SKIN_TONE , "person juggling: medium-light skin tone" => crate :: people_and_body :: person_sport :: PERSON_JUGGLING_MEDIUM_LIGHT_SKIN_TONE , "person juggling: medium skin tone" => crate :: people_and_body :: person_sport :: PERSON_JUGGLING_MEDIUM_SKIN_TONE , "person juggling: medium-dark skin tone" => crate :: people_and_body :: person_sport :: PERSON_JUGGLING_MEDIUM_DARK_SKIN_TONE , "person juggling: dark skin tone" => crate :: people_and_body :: person_sport :: PERSON_JUGGLING_DARK_SKIN_TONE , "man juggling" => crate :: people_and_body :: person_sport :: MAN_JUGGLING , "man juggling: light skin tone" => crate :: people_and_body :: person_sport :: MAN_JUGGLING_LIGHT_SKIN_TONE , "man juggling: medium-light skin tone" => crate :: people_and_body :: person_sport :: MAN_JUGGLING_MEDIUM_LIGHT_SKIN_TONE , "man juggling: medium skin tone" => crate :: people_and_body :: person_sport :: MAN_JUGGLING_MEDIUM_SKIN_TONE , "man juggling: medium-dark skin tone" => crate :: people_and_body :: person_sport :: MAN_JUGGLING_MEDIUM_DARK_SKIN_TONE , "man juggling: dark skin tone" => crate :: people_and_body :: person_sport :: MAN_JUGGLING_DARK_SKIN_TONE , "woman juggling" => crate :: people_and_body :: person_sport :: WOMAN_JUGGLING , "woman juggling: light skin tone" => crate :: people_and_body :: person_sport :: WOMAN_JUGGLING_LIGHT_SKIN_TONE , "woman juggling: medium-light skin tone" => crate :: people_and_body :: person_sport :: WOMAN_JUGGLING_MEDIUM_LIGHT_SKIN_TONE , "woman juggling: medium skin tone" => crate :: people_and_body :: person_sport :: WOMAN_JUGGLING_MEDIUM_SKIN_TONE , "woman juggling: medium-dark skin tone" => crate :: people_and_body :: person_sport :: WOMAN_JUGGLING_MEDIUM_DARK_SKIN_TONE , "woman juggling: dark skin tone" => crate :: people_and_body :: person_sport :: WOMAN_JUGGLING_DARK_SKIN_TONE , "person in lotus position" => crate :: people_and_body :: person_resting :: PERSON_IN_LOTUS_POSITION , "person in lotus position: light skin tone" => crate :: people_and_body :: person_resting :: PERSON_IN_LOTUS_POSITION_LIGHT_SKIN_TONE , "person in lotus position: medium-light skin tone" => crate :: people_and_body :: person_resting :: PERSON_IN_LOTUS_POSITION_MEDIUM_LIGHT_SKIN_TONE , "person in lotus position: medium skin tone" => crate :: people_and_body :: person_resting :: PERSON_IN_LOTUS_POSITION_MEDIUM_SKIN_TONE , "person in lotus position: medium-dark skin tone" => crate :: people_and_body :: person_resting :: PERSON_IN_LOTUS_POSITION_MEDIUM_DARK_SKIN_TONE , "person in lotus position: dark skin tone" => crate :: people_and_body :: person_resting :: PERSON_IN_LOTUS_POSITION_DARK_SKIN_TONE , "man in lotus position" => crate :: people_and_body :: person_resting :: MAN_IN_LOTUS_POSITION , "man in lotus position: light skin tone" => crate :: people_and_body :: person_resting :: MAN_IN_LOTUS_POSITION_LIGHT_SKIN_TONE , "man in lotus position: medium-light skin tone" => crate :: people_and_body :: person_resting :: MAN_IN_LOTUS_POSITION_MEDIUM_LIGHT_SKIN_TONE , "man in lotus position: medium skin tone" => crate :: people_and_body :: person_resting :: MAN_IN_LOTUS_POSITION_MEDIUM_SKIN_TONE , "man in lotus position: medium-dark skin tone" => crate :: people_and_body :: person_resting :: MAN_IN_LOTUS_POSITION_MEDIUM_DARK_SKIN_TONE , "man in lotus position: dark skin tone" => crate :: people_and_body :: person_resting :: MAN_IN_LOTUS_POSITION_DARK_SKIN_TONE , "woman in lotus position" => crate :: people_and_body :: person_resting :: WOMAN_IN_LOTUS_POSITION , "woman in lotus position: light skin tone" => crate :: people_and_body :: person_resting :: WOMAN_IN_LOTUS_POSITION_LIGHT_SKIN_TONE , "woman in lotus position: medium-light skin tone" => crate :: people_and_body :: person_resting :: WOMAN_IN_LOTUS_POSITION_MEDIUM_LIGHT_SKIN_TONE , "woman in lotus position: medium skin tone" => crate :: people_and_body :: person_resting :: WOMAN_IN_LOTUS_POSITION_MEDIUM_SKIN_TONE , "woman in lotus position: medium-dark skin tone" => crate :: people_and_body :: person_resting :: WOMAN_IN_LOTUS_POSITION_MEDIUM_DARK_SKIN_TONE , "woman in lotus position: dark skin tone" => crate :: people_and_body :: person_resting :: WOMAN_IN_LOTUS_POSITION_DARK_SKIN_TONE , "person taking bath" => crate :: people_and_body :: person_resting :: PERSON_TAKING_BATH , "person taking bath: light skin tone" => crate :: people_and_body :: person_resting :: PERSON_TAKING_BATH_LIGHT_SKIN_TONE , "person taking bath: medium-light skin tone" => crate :: people_and_body :: person_resting :: PERSON_TAKING_BATH_MEDIUM_LIGHT_SKIN_TONE , "person taking bath: medium skin tone" => crate :: people_and_body :: person_resting :: PERSON_TAKING_BATH_MEDIUM_SKIN_TONE , "person taking bath: medium-dark skin tone" => crate :: people_and_body :: person_resting :: PERSON_TAKING_BATH_MEDIUM_DARK_SKIN_TONE , "person taking bath: dark skin tone" => crate :: people_and_body :: person_resting :: PERSON_TAKING_BATH_DARK_SKIN_TONE , "person in bed" => crate :: people_and_body :: person_resting :: PERSON_IN_BED , "person in bed: light skin tone" => crate :: people_and_body :: person_resting :: PERSON_IN_BED_LIGHT_SKIN_TONE , "person in bed: medium-light skin tone" => crate :: people_and_body :: person_resting :: PERSON_IN_BED_MEDIUM_LIGHT_SKIN_TONE , "person in bed: medium skin tone" => crate :: people_and_body :: person_resting :: PERSON_IN_BED_MEDIUM_SKIN_TONE , "person in bed: medium-dark skin tone" => crate :: people_and_body :: person_resting :: PERSON_IN_BED_MEDIUM_DARK_SKIN_TONE , "person in bed: dark skin tone" => crate :: people_and_body :: person_resting :: PERSON_IN_BED_DARK_SKIN_TONE , "people holding hands" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS , "people holding hands: light skin tone" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_LIGHT_SKIN_TONE , "people holding hands: light skin tone, medium-light skin tone" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_LIGHT_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "people holding hands: light skin tone, medium skin tone" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "people holding hands: light skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "people holding hands: light skin tone, dark skin tone" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "people holding hands: medium-light skin tone, light skin tone" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE_LIGHT_SKIN_TONE , "people holding hands: medium-light skin tone" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE , "people holding hands: medium-light skin tone, medium skin tone" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "people holding hands: medium-light skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "people holding hands: medium-light skin tone, dark skin tone" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "people holding hands: medium skin tone, light skin tone" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_MEDIUM_SKIN_TONE_LIGHT_SKIN_TONE , "people holding hands: medium skin tone, medium-light skin tone" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_MEDIUM_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "people holding hands: medium skin tone" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_MEDIUM_SKIN_TONE , "people holding hands: medium skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_MEDIUM_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "people holding hands: medium skin tone, dark skin tone" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_MEDIUM_SKIN_TONE_DARK_SKIN_TONE , "people holding hands: medium-dark skin tone, light skin tone" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "people holding hands: medium-dark skin tone, medium-light skin tone" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "people holding hands: medium-dark skin tone, medium skin tone" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "people holding hands: medium-dark skin tone" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE , "people holding hands: medium-dark skin tone, dark skin tone" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE_DARK_SKIN_TONE , "people holding hands: dark skin tone, light skin tone" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "people holding hands: dark skin tone, medium-light skin tone" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "people holding hands: dark skin tone, medium skin tone" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "people holding hands: dark skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_DARK_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "people holding hands: dark skin tone" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_DARK_SKIN_TONE , "women holding hands" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS , "women holding hands: light skin tone" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_LIGHT_SKIN_TONE , "women holding hands: light skin tone, medium-light skin tone" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_LIGHT_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "women holding hands: light skin tone, medium skin tone" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "women holding hands: light skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "women holding hands: light skin tone, dark skin tone" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "women holding hands: medium-light skin tone, light skin tone" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE_LIGHT_SKIN_TONE , "women holding hands: medium-light skin tone" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE , "women holding hands: medium-light skin tone, medium skin tone" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "women holding hands: medium-light skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "women holding hands: medium-light skin tone, dark skin tone" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "women holding hands: medium skin tone, light skin tone" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_MEDIUM_SKIN_TONE_LIGHT_SKIN_TONE , "women holding hands: medium skin tone, medium-light skin tone" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_MEDIUM_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "women holding hands: medium skin tone" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_MEDIUM_SKIN_TONE , "women holding hands: medium skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_MEDIUM_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "women holding hands: medium skin tone, dark skin tone" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_MEDIUM_SKIN_TONE_DARK_SKIN_TONE , "women holding hands: medium-dark skin tone, light skin tone" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "women holding hands: medium-dark skin tone, medium-light skin tone" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "women holding hands: medium-dark skin tone, medium skin tone" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "women holding hands: medium-dark skin tone" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE , "women holding hands: medium-dark skin tone, dark skin tone" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE_DARK_SKIN_TONE , "women holding hands: dark skin tone, light skin tone" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "women holding hands: dark skin tone, medium-light skin tone" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "women holding hands: dark skin tone, medium skin tone" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "women holding hands: dark skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_DARK_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "women holding hands: dark skin tone" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_DARK_SKIN_TONE , "woman and man holding hands" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS , "woman and man holding hands: light skin tone" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_LIGHT_SKIN_TONE , "woman and man holding hands: light skin tone, medium-light skin tone" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_LIGHT_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "woman and man holding hands: light skin tone, medium skin tone" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "woman and man holding hands: light skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "woman and man holding hands: light skin tone, dark skin tone" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "woman and man holding hands: medium-light skin tone, light skin tone" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE_LIGHT_SKIN_TONE , "woman and man holding hands: medium-light skin tone" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE , "woman and man holding hands: medium-light skin tone, medium skin tone" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "woman and man holding hands: medium-light skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "woman and man holding hands: medium-light skin tone, dark skin tone" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "woman and man holding hands: medium skin tone, light skin tone" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_MEDIUM_SKIN_TONE_LIGHT_SKIN_TONE , "woman and man holding hands: medium skin tone, medium-light skin tone" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_MEDIUM_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "woman and man holding hands: medium skin tone" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_MEDIUM_SKIN_TONE , "woman and man holding hands: medium skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_MEDIUM_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "woman and man holding hands: medium skin tone, dark skin tone" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_MEDIUM_SKIN_TONE_DARK_SKIN_TONE , "woman and man holding hands: medium-dark skin tone, light skin tone" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "woman and man holding hands: medium-dark skin tone, medium-light skin tone" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "woman and man holding hands: medium-dark skin tone, medium skin tone" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "woman and man holding hands: medium-dark skin tone" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE , "woman and man holding hands: medium-dark skin tone, dark skin tone" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE_DARK_SKIN_TONE , "woman and man holding hands: dark skin tone, light skin tone" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "woman and man holding hands: dark skin tone, medium-light skin tone" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "woman and man holding hands: dark skin tone, medium skin tone" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "woman and man holding hands: dark skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_DARK_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "woman and man holding hands: dark skin tone" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_DARK_SKIN_TONE , "men holding hands" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS , "men holding hands: light skin tone" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_LIGHT_SKIN_TONE , "men holding hands: light skin tone, medium-light skin tone" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_LIGHT_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "men holding hands: light skin tone, medium skin tone" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "men holding hands: light skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "men holding hands: light skin tone, dark skin tone" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "men holding hands: medium-light skin tone, light skin tone" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE_LIGHT_SKIN_TONE , "men holding hands: medium-light skin tone" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE , "men holding hands: medium-light skin tone, medium skin tone" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "men holding hands: medium-light skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "men holding hands: medium-light skin tone, dark skin tone" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "men holding hands: medium skin tone, light skin tone" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_MEDIUM_SKIN_TONE_LIGHT_SKIN_TONE , "men holding hands: medium skin tone, medium-light skin tone" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_MEDIUM_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "men holding hands: medium skin tone" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_MEDIUM_SKIN_TONE , "men holding hands: medium skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_MEDIUM_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "men holding hands: medium skin tone, dark skin tone" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_MEDIUM_SKIN_TONE_DARK_SKIN_TONE , "men holding hands: medium-dark skin tone, light skin tone" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "men holding hands: medium-dark skin tone, medium-light skin tone" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "men holding hands: medium-dark skin tone, medium skin tone" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "men holding hands: medium-dark skin tone" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE , "men holding hands: medium-dark skin tone, dark skin tone" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE_DARK_SKIN_TONE , "men holding hands: dark skin tone, light skin tone" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "men holding hands: dark skin tone, medium-light skin tone" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "men holding hands: dark skin tone, medium skin tone" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "men holding hands: dark skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_DARK_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "men holding hands: dark skin tone" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_DARK_SKIN_TONE , "kiss" => crate :: people_and_body :: family :: KISS , "kiss: person, person, light skin tone, medium-light skin tone" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_LIGHT_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "kiss: person, person, light skin tone, medium skin tone" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "kiss: person, person, light skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "kiss: person, person, light skin tone, dark skin tone" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "kiss: person, person, medium-light skin tone, light skin tone" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_MEDIUM_LIGHT_SKIN_TONE_LIGHT_SKIN_TONE , "kiss: person, person, medium-light skin tone, medium skin tone" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "kiss: person, person, medium-light skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "kiss: person, person, medium-light skin tone, dark skin tone" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_MEDIUM_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "kiss: person, person, medium skin tone, light skin tone" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_MEDIUM_SKIN_TONE_LIGHT_SKIN_TONE , "kiss: person, person, medium skin tone, medium-light skin tone" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_MEDIUM_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "kiss: person, person, medium skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_MEDIUM_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "kiss: person, person, medium skin tone, dark skin tone" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_MEDIUM_SKIN_TONE_DARK_SKIN_TONE , "kiss: person, person, medium-dark skin tone, light skin tone" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_MEDIUM_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "kiss: person, person, medium-dark skin tone, medium-light skin tone" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_MEDIUM_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "kiss: person, person, medium-dark skin tone, medium skin tone" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_MEDIUM_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "kiss: person, person, medium-dark skin tone, dark skin tone" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_MEDIUM_DARK_SKIN_TONE_DARK_SKIN_TONE , "kiss: person, person, dark skin tone, light skin tone" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "kiss: person, person, dark skin tone, medium-light skin tone" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "kiss: person, person, dark skin tone, medium skin tone" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "kiss: person, person, dark skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_DARK_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "kiss: woman, man" => crate :: people_and_body :: family :: KISS_WOMAN_MAN , "kiss: woman, man, light skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_LIGHT_SKIN_TONE , "kiss: woman, man, light skin tone, medium-light skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_LIGHT_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "kiss: woman, man, light skin tone, medium skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "kiss: woman, man, light skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "kiss: woman, man, light skin tone, dark skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "kiss: woman, man, medium-light skin tone, light skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_LIGHT_SKIN_TONE_LIGHT_SKIN_TONE , "kiss: woman, man, medium-light skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_LIGHT_SKIN_TONE , "kiss: woman, man, medium-light skin tone, medium skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "kiss: woman, man, medium-light skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "kiss: woman, man, medium-light skin tone, dark skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "kiss: woman, man, medium skin tone, light skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_SKIN_TONE_LIGHT_SKIN_TONE , "kiss: woman, man, medium skin tone, medium-light skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "kiss: woman, man, medium skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_SKIN_TONE , "kiss: woman, man, medium skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "kiss: woman, man, medium skin tone, dark skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_SKIN_TONE_DARK_SKIN_TONE , "kiss: woman, man, medium-dark skin tone, light skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "kiss: woman, man, medium-dark skin tone, medium-light skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "kiss: woman, man, medium-dark skin tone, medium skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "kiss: woman, man, medium-dark skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_DARK_SKIN_TONE , "kiss: woman, man, medium-dark skin tone, dark skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_DARK_SKIN_TONE_DARK_SKIN_TONE , "kiss: woman, man, dark skin tone, light skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "kiss: woman, man, dark skin tone, medium-light skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "kiss: woman, man, dark skin tone, medium skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "kiss: woman, man, dark skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_DARK_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "kiss: woman, man, dark skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_DARK_SKIN_TONE , "kiss: man, man" => crate :: people_and_body :: family :: KISS_MAN_MAN , "kiss: man, man, light skin tone" => crate :: people_and_body :: family :: KISS_MAN_MAN_LIGHT_SKIN_TONE , "kiss: man, man, light skin tone, medium-light skin tone" => crate :: people_and_body :: family :: KISS_MAN_MAN_LIGHT_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "kiss: man, man, light skin tone, medium skin tone" => crate :: people_and_body :: family :: KISS_MAN_MAN_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "kiss: man, man, light skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: KISS_MAN_MAN_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "kiss: man, man, light skin tone, dark skin tone" => crate :: people_and_body :: family :: KISS_MAN_MAN_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "kiss: man, man, medium-light skin tone, light skin tone" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_LIGHT_SKIN_TONE_LIGHT_SKIN_TONE , "kiss: man, man, medium-light skin tone" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_LIGHT_SKIN_TONE , "kiss: man, man, medium-light skin tone, medium skin tone" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "kiss: man, man, medium-light skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "kiss: man, man, medium-light skin tone, dark skin tone" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "kiss: man, man, medium skin tone, light skin tone" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_SKIN_TONE_LIGHT_SKIN_TONE , "kiss: man, man, medium skin tone, medium-light skin tone" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "kiss: man, man, medium skin tone" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_SKIN_TONE , "kiss: man, man, medium skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "kiss: man, man, medium skin tone, dark skin tone" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_SKIN_TONE_DARK_SKIN_TONE , "kiss: man, man, medium-dark skin tone, light skin tone" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "kiss: man, man, medium-dark skin tone, medium-light skin tone" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "kiss: man, man, medium-dark skin tone, medium skin tone" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "kiss: man, man, medium-dark skin tone" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_DARK_SKIN_TONE , "kiss: man, man, medium-dark skin tone, dark skin tone" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_DARK_SKIN_TONE_DARK_SKIN_TONE , "kiss: man, man, dark skin tone, light skin tone" => crate :: people_and_body :: family :: KISS_MAN_MAN_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "kiss: man, man, dark skin tone, medium-light skin tone" => crate :: people_and_body :: family :: KISS_MAN_MAN_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "kiss: man, man, dark skin tone, medium skin tone" => crate :: people_and_body :: family :: KISS_MAN_MAN_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "kiss: man, man, dark skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: KISS_MAN_MAN_DARK_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "kiss: man, man, dark skin tone" => crate :: people_and_body :: family :: KISS_MAN_MAN_DARK_SKIN_TONE , "kiss: woman, woman" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN , "kiss: woman, woman, light skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_LIGHT_SKIN_TONE , "kiss: woman, woman, light skin tone, medium-light skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_LIGHT_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "kiss: woman, woman, light skin tone, medium skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "kiss: woman, woman, light skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "kiss: woman, woman, light skin tone, dark skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "kiss: woman, woman, medium-light skin tone, light skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_LIGHT_SKIN_TONE_LIGHT_SKIN_TONE , "kiss: woman, woman, medium-light skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_LIGHT_SKIN_TONE , "kiss: woman, woman, medium-light skin tone, medium skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "kiss: woman, woman, medium-light skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "kiss: woman, woman, medium-light skin tone, dark skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "kiss: woman, woman, medium skin tone, light skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_SKIN_TONE_LIGHT_SKIN_TONE , "kiss: woman, woman, medium skin tone, medium-light skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "kiss: woman, woman, medium skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_SKIN_TONE , "kiss: woman, woman, medium skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "kiss: woman, woman, medium skin tone, dark skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_SKIN_TONE_DARK_SKIN_TONE , "kiss: woman, woman, medium-dark skin tone, light skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "kiss: woman, woman, medium-dark skin tone, medium-light skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "kiss: woman, woman, medium-dark skin tone, medium skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "kiss: woman, woman, medium-dark skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_DARK_SKIN_TONE , "kiss: woman, woman, medium-dark skin tone, dark skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_DARK_SKIN_TONE_DARK_SKIN_TONE , "kiss: woman, woman, dark skin tone, light skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "kiss: woman, woman, dark skin tone, medium-light skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "kiss: woman, woman, dark skin tone, medium skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "kiss: woman, woman, dark skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_DARK_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "kiss: woman, woman, dark skin tone" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_DARK_SKIN_TONE , "couple with heart" => crate :: people_and_body :: family :: COUPLE_WITH_HEART , "couple with heart: person, person, light skin tone, medium-light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_LIGHT_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "couple with heart: person, person, light skin tone, medium skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "couple with heart: person, person, light skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "couple with heart: person, person, light skin tone, dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "couple with heart: person, person, medium-light skin tone, light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_MEDIUM_LIGHT_SKIN_TONE_LIGHT_SKIN_TONE , "couple with heart: person, person, medium-light skin tone, medium skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "couple with heart: person, person, medium-light skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "couple with heart: person, person, medium-light skin tone, dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_MEDIUM_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "couple with heart: person, person, medium skin tone, light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_MEDIUM_SKIN_TONE_LIGHT_SKIN_TONE , "couple with heart: person, person, medium skin tone, medium-light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_MEDIUM_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "couple with heart: person, person, medium skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_MEDIUM_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "couple with heart: person, person, medium skin tone, dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_MEDIUM_SKIN_TONE_DARK_SKIN_TONE , "couple with heart: person, person, medium-dark skin tone, light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_MEDIUM_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "couple with heart: person, person, medium-dark skin tone, medium-light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_MEDIUM_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "couple with heart: person, person, medium-dark skin tone, medium skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_MEDIUM_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "couple with heart: person, person, medium-dark skin tone, dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_MEDIUM_DARK_SKIN_TONE_DARK_SKIN_TONE , "couple with heart: person, person, dark skin tone, light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "couple with heart: person, person, dark skin tone, medium-light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "couple with heart: person, person, dark skin tone, medium skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "couple with heart: person, person, dark skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_DARK_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "couple with heart: woman, man" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN , "couple with heart: woman, man, light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_LIGHT_SKIN_TONE , "couple with heart: woman, man, light skin tone, medium-light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_LIGHT_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "couple with heart: woman, man, light skin tone, medium skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "couple with heart: woman, man, light skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "couple with heart: woman, man, light skin tone, dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "couple with heart: woman, man, medium-light skin tone, light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_LIGHT_SKIN_TONE_LIGHT_SKIN_TONE , "couple with heart: woman, man, medium-light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_LIGHT_SKIN_TONE , "couple with heart: woman, man, medium-light skin tone, medium skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "couple with heart: woman, man, medium-light skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "couple with heart: woman, man, medium-light skin tone, dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "couple with heart: woman, man, medium skin tone, light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_SKIN_TONE_LIGHT_SKIN_TONE , "couple with heart: woman, man, medium skin tone, medium-light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "couple with heart: woman, man, medium skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_SKIN_TONE , "couple with heart: woman, man, medium skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "couple with heart: woman, man, medium skin tone, dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_SKIN_TONE_DARK_SKIN_TONE , "couple with heart: woman, man, medium-dark skin tone, light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "couple with heart: woman, man, medium-dark skin tone, medium-light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "couple with heart: woman, man, medium-dark skin tone, medium skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "couple with heart: woman, man, medium-dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_DARK_SKIN_TONE , "couple with heart: woman, man, medium-dark skin tone, dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_DARK_SKIN_TONE_DARK_SKIN_TONE , "couple with heart: woman, man, dark skin tone, light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "couple with heart: woman, man, dark skin tone, medium-light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "couple with heart: woman, man, dark skin tone, medium skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "couple with heart: woman, man, dark skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_DARK_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "couple with heart: woman, man, dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_DARK_SKIN_TONE , "couple with heart: man, man" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN , "couple with heart: man, man, light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_LIGHT_SKIN_TONE , "couple with heart: man, man, light skin tone, medium-light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_LIGHT_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "couple with heart: man, man, light skin tone, medium skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "couple with heart: man, man, light skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "couple with heart: man, man, light skin tone, dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "couple with heart: man, man, medium-light skin tone, light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_LIGHT_SKIN_TONE_LIGHT_SKIN_TONE , "couple with heart: man, man, medium-light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_LIGHT_SKIN_TONE , "couple with heart: man, man, medium-light skin tone, medium skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "couple with heart: man, man, medium-light skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "couple with heart: man, man, medium-light skin tone, dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "couple with heart: man, man, medium skin tone, light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_SKIN_TONE_LIGHT_SKIN_TONE , "couple with heart: man, man, medium skin tone, medium-light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "couple with heart: man, man, medium skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_SKIN_TONE , "couple with heart: man, man, medium skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "couple with heart: man, man, medium skin tone, dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_SKIN_TONE_DARK_SKIN_TONE , "couple with heart: man, man, medium-dark skin tone, light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "couple with heart: man, man, medium-dark skin tone, medium-light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "couple with heart: man, man, medium-dark skin tone, medium skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "couple with heart: man, man, medium-dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_DARK_SKIN_TONE , "couple with heart: man, man, medium-dark skin tone, dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_DARK_SKIN_TONE_DARK_SKIN_TONE , "couple with heart: man, man, dark skin tone, light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "couple with heart: man, man, dark skin tone, medium-light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "couple with heart: man, man, dark skin tone, medium skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "couple with heart: man, man, dark skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_DARK_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "couple with heart: man, man, dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_DARK_SKIN_TONE , "couple with heart: woman, woman" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN , "couple with heart: woman, woman, light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_LIGHT_SKIN_TONE , "couple with heart: woman, woman, light skin tone, medium-light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_LIGHT_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "couple with heart: woman, woman, light skin tone, medium skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "couple with heart: woman, woman, light skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "couple with heart: woman, woman, light skin tone, dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "couple with heart: woman, woman, medium-light skin tone, light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_LIGHT_SKIN_TONE_LIGHT_SKIN_TONE , "couple with heart: woman, woman, medium-light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_LIGHT_SKIN_TONE , "couple with heart: woman, woman, medium-light skin tone, medium skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "couple with heart: woman, woman, medium-light skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "couple with heart: woman, woman, medium-light skin tone, dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "couple with heart: woman, woman, medium skin tone, light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_SKIN_TONE_LIGHT_SKIN_TONE , "couple with heart: woman, woman, medium skin tone, medium-light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "couple with heart: woman, woman, medium skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_SKIN_TONE , "couple with heart: woman, woman, medium skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "couple with heart: woman, woman, medium skin tone, dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_SKIN_TONE_DARK_SKIN_TONE , "couple with heart: woman, woman, medium-dark skin tone, light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "couple with heart: woman, woman, medium-dark skin tone, medium-light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "couple with heart: woman, woman, medium-dark skin tone, medium skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "couple with heart: woman, woman, medium-dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_DARK_SKIN_TONE , "couple with heart: woman, woman, medium-dark skin tone, dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_DARK_SKIN_TONE_DARK_SKIN_TONE , "couple with heart: woman, woman, dark skin tone, light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "couple with heart: woman, woman, dark skin tone, medium-light skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "couple with heart: woman, woman, dark skin tone, medium skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "couple with heart: woman, woman, dark skin tone, medium-dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_DARK_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "couple with heart: woman, woman, dark skin tone" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_DARK_SKIN_TONE , "family" => crate :: people_and_body :: family :: FAMILY , "family: man, woman, boy" => crate :: people_and_body :: family :: FAMILY_MAN_WOMAN_BOY , "family: man, woman, girl" => crate :: people_and_body :: family :: FAMILY_MAN_WOMAN_GIRL , "family: man, woman, girl, boy" => crate :: people_and_body :: family :: FAMILY_MAN_WOMAN_GIRL_BOY , "family: man, woman, boy, boy" => crate :: people_and_body :: family :: FAMILY_MAN_WOMAN_BOY_BOY , "family: man, woman, girl, girl" => crate :: people_and_body :: family :: FAMILY_MAN_WOMAN_GIRL_GIRL , "family: man, man, boy" => crate :: people_and_body :: family :: FAMILY_MAN_MAN_BOY , "family: man, man, girl" => crate :: people_and_body :: family :: FAMILY_MAN_MAN_GIRL , "family: man, man, girl, boy" => crate :: people_and_body :: family :: FAMILY_MAN_MAN_GIRL_BOY , "family: man, man, boy, boy" => crate :: people_and_body :: family :: FAMILY_MAN_MAN_BOY_BOY , "family: man, man, girl, girl" => crate :: people_and_body :: family :: FAMILY_MAN_MAN_GIRL_GIRL , "family: woman, woman, boy" => crate :: people_and_body :: family :: FAMILY_WOMAN_WOMAN_BOY , "family: woman, woman, girl" => crate :: people_and_body :: family :: FAMILY_WOMAN_WOMAN_GIRL , "family: woman, woman, girl, boy" => crate :: people_and_body :: family :: FAMILY_WOMAN_WOMAN_GIRL_BOY , "family: woman, woman, boy, boy" => crate :: people_and_body :: family :: FAMILY_WOMAN_WOMAN_BOY_BOY , "family: woman, woman, girl, girl" => crate :: people_and_body :: family :: FAMILY_WOMAN_WOMAN_GIRL_GIRL , "family: man, boy" => crate :: people_and_body :: family :: FAMILY_MAN_BOY , "family: man, boy, boy" => crate :: people_and_body :: family :: FAMILY_MAN_BOY_BOY , "family: man, girl" => crate :: people_and_body :: family :: FAMILY_MAN_GIRL , "family: man, girl, boy" => crate :: people_and_body :: family :: FAMILY_MAN_GIRL_BOY , "family: man, girl, girl" => crate :: people_and_body :: family :: FAMILY_MAN_GIRL_GIRL , "family: woman, boy" => crate :: people_and_body :: family :: FAMILY_WOMAN_BOY , "family: woman, boy, boy" => crate :: people_and_body :: family :: FAMILY_WOMAN_BOY_BOY , "family: woman, girl" => crate :: people_and_body :: family :: FAMILY_WOMAN_GIRL , "family: woman, girl, boy" => crate :: people_and_body :: family :: FAMILY_WOMAN_GIRL_BOY , "family: woman, girl, girl" => crate :: people_and_body :: family :: FAMILY_WOMAN_GIRL_GIRL , "speaking head" => crate :: people_and_body :: person_symbol :: SPEAKING_HEAD , "bust in silhouette" => crate :: people_and_body :: person_symbol :: BUST_IN_SILHOUETTE , "busts in silhouette" => crate :: people_and_body :: person_symbol :: BUSTS_IN_SILHOUETTE , "people hugging" => crate :: people_and_body :: person_symbol :: PEOPLE_HUGGING , "footprints" => crate :: people_and_body :: person_symbol :: FOOTPRINTS , "light skin tone" => crate :: component :: skin_tone :: LIGHT_SKIN_TONE , "medium-light skin tone" => crate :: component :: skin_tone :: MEDIUM_LIGHT_SKIN_TONE , "medium skin tone" => crate :: component :: skin_tone :: MEDIUM_SKIN_TONE , "medium-dark skin tone" => crate :: component :: skin_tone :: MEDIUM_DARK_SKIN_TONE , "dark skin tone" => crate :: component :: skin_tone :: DARK_SKIN_TONE , "red hair" => crate :: component :: hair_style :: RED_HAIR , "curly hair" => crate :: component :: hair_style :: CURLY_HAIR , "white hair" => crate :: component :: hair_style :: WHITE_HAIR , "bald" => crate :: component :: hair_style :: BALD , "monkey face" => crate :: animals_and_nature :: animal_mammal :: MONKEY_FACE , "monkey" => crate :: animals_and_nature :: animal_mammal :: MONKEY , "gorilla" => crate :: animals_and_nature :: animal_mammal :: GORILLA , "orangutan" => crate :: animals_and_nature :: animal_mammal :: ORANGUTAN , "dog face" => crate :: animals_and_nature :: animal_mammal :: DOG_FACE , "dog" => crate :: animals_and_nature :: animal_mammal :: DOG , "guide dog" => crate :: animals_and_nature :: animal_mammal :: GUIDE_DOG , "service dog" => crate :: animals_and_nature :: animal_mammal :: SERVICE_DOG , "poodle" => crate :: animals_and_nature :: animal_mammal :: POODLE , "wolf" => crate :: animals_and_nature :: animal_mammal :: WOLF , "fox" => crate :: animals_and_nature :: animal_mammal :: FOX , "raccoon" => crate :: animals_and_nature :: animal_mammal :: RACCOON , "cat face" => crate :: animals_and_nature :: animal_mammal :: CAT_FACE , "cat" => crate :: animals_and_nature :: animal_mammal :: CAT , "black cat" => crate :: animals_and_nature :: animal_mammal :: BLACK_CAT , "lion" => crate :: animals_and_nature :: animal_mammal :: LION , "tiger face" => crate :: animals_and_nature :: animal_mammal :: TIGER_FACE , "tiger" => crate :: animals_and_nature :: animal_mammal :: TIGER , "leopard" => crate :: animals_and_nature :: animal_mammal :: LEOPARD , "horse face" => crate :: animals_and_nature :: animal_mammal :: HORSE_FACE , "horse" => crate :: animals_and_nature :: animal_mammal :: HORSE , "unicorn" => crate :: animals_and_nature :: animal_mammal :: UNICORN , "zebra" => crate :: animals_and_nature :: animal_mammal :: ZEBRA , "deer" => crate :: animals_and_nature :: animal_mammal :: DEER , "bison" => crate :: animals_and_nature :: animal_mammal :: BISON , "cow face" => crate :: animals_and_nature :: animal_mammal :: COW_FACE , "ox" => crate :: animals_and_nature :: animal_mammal :: OX , "water buffalo" => crate :: animals_and_nature :: animal_mammal :: WATER_BUFFALO , "cow" => crate :: animals_and_nature :: animal_mammal :: COW , "pig face" => crate :: animals_and_nature :: animal_mammal :: PIG_FACE , "pig" => crate :: animals_and_nature :: animal_mammal :: PIG , "boar" => crate :: animals_and_nature :: animal_mammal :: BOAR , "pig nose" => crate :: animals_and_nature :: animal_mammal :: PIG_NOSE , "ram" => crate :: animals_and_nature :: animal_mammal :: RAM , "ewe" => crate :: animals_and_nature :: animal_mammal :: EWE , "goat" => crate :: animals_and_nature :: animal_mammal :: GOAT , "camel" => crate :: animals_and_nature :: animal_mammal :: CAMEL , "two-hump camel" => crate :: animals_and_nature :: animal_mammal :: TWO_HUMP_CAMEL , "llama" => crate :: animals_and_nature :: animal_mammal :: LLAMA , "giraffe" => crate :: animals_and_nature :: animal_mammal :: GIRAFFE , "elephant" => crate :: animals_and_nature :: animal_mammal :: ELEPHANT , "mammoth" => crate :: animals_and_nature :: animal_mammal :: MAMMOTH , "rhinoceros" => crate :: animals_and_nature :: animal_mammal :: RHINOCEROS , "hippopotamus" => crate :: animals_and_nature :: animal_mammal :: HIPPOPOTAMUS , "mouse face" => crate :: animals_and_nature :: animal_mammal :: MOUSE_FACE , "mouse" => crate :: animals_and_nature :: animal_mammal :: MOUSE , "rat" => crate :: animals_and_nature :: animal_mammal :: RAT , "hamster" => crate :: animals_and_nature :: animal_mammal :: HAMSTER , "rabbit face" => crate :: animals_and_nature :: animal_mammal :: RABBIT_FACE , "rabbit" => crate :: animals_and_nature :: animal_mammal :: RABBIT , "chipmunk" => crate :: animals_and_nature :: animal_mammal :: CHIPMUNK , "beaver" => crate :: animals_and_nature :: animal_mammal :: BEAVER , "hedgehog" => crate :: animals_and_nature :: animal_mammal :: HEDGEHOG , "bat" => crate :: animals_and_nature :: animal_mammal :: BAT , "bear" => crate :: animals_and_nature :: animal_mammal :: BEAR , "polar bear" => crate :: animals_and_nature :: animal_mammal :: POLAR_BEAR , "koala" => crate :: animals_and_nature :: animal_mammal :: KOALA , "panda" => crate :: animals_and_nature :: animal_mammal :: PANDA , "sloth" => crate :: animals_and_nature :: animal_mammal :: SLOTH , "otter" => crate :: animals_and_nature :: animal_mammal :: OTTER , "skunk" => crate :: animals_and_nature :: animal_mammal :: SKUNK , "kangaroo" => crate :: animals_and_nature :: animal_mammal :: KANGAROO , "badger" => crate :: animals_and_nature :: animal_mammal :: BADGER , "paw prints" => crate :: animals_and_nature :: animal_mammal :: PAW_PRINTS , "turkey" => crate :: animals_and_nature :: animal_bird :: TURKEY , "chicken" => crate :: animals_and_nature :: animal_bird :: CHICKEN , "rooster" => crate :: animals_and_nature :: animal_bird :: ROOSTER , "hatching chick" => crate :: animals_and_nature :: animal_bird :: HATCHING_CHICK , "baby chick" => crate :: animals_and_nature :: animal_bird :: BABY_CHICK , "front-facing baby chick" => crate :: animals_and_nature :: animal_bird :: FRONT_FACING_BABY_CHICK , "bird" => crate :: animals_and_nature :: animal_bird :: BIRD , "penguin" => crate :: animals_and_nature :: animal_bird :: PENGUIN , "dove" => crate :: animals_and_nature :: animal_bird :: DOVE , "eagle" => crate :: animals_and_nature :: animal_bird :: EAGLE , "duck" => crate :: animals_and_nature :: animal_bird :: DUCK , "swan" => crate :: animals_and_nature :: animal_bird :: SWAN , "owl" => crate :: animals_and_nature :: animal_bird :: OWL , "dodo" => crate :: animals_and_nature :: animal_bird :: DODO , "feather" => crate :: animals_and_nature :: animal_bird :: FEATHER , "flamingo" => crate :: animals_and_nature :: animal_bird :: FLAMINGO , "peacock" => crate :: animals_and_nature :: animal_bird :: PEACOCK , "parrot" => crate :: animals_and_nature :: animal_bird :: PARROT , "frog" => crate :: animals_and_nature :: animal_amphibian :: FROG , "crocodile" => crate :: animals_and_nature :: animal_reptile :: CROCODILE , "turtle" => crate :: animals_and_nature :: animal_reptile :: TURTLE , "lizard" => crate :: animals_and_nature :: animal_reptile :: LIZARD , "snake" => crate :: animals_and_nature :: animal_reptile :: SNAKE , "dragon face" => crate :: animals_and_nature :: animal_reptile :: DRAGON_FACE , "dragon" => crate :: animals_and_nature :: animal_reptile :: DRAGON , "sauropod" => crate :: animals_and_nature :: animal_reptile :: SAUROPOD , "T-Rex" => crate :: animals_and_nature :: animal_reptile :: T_REX , "spouting whale" => crate :: animals_and_nature :: animal_marine :: SPOUTING_WHALE , "whale" => crate :: animals_and_nature :: animal_marine :: WHALE , "dolphin" => crate :: animals_and_nature :: animal_marine :: DOLPHIN , "seal" => crate :: animals_and_nature :: animal_marine :: SEAL , "fish" => crate :: animals_and_nature :: animal_marine :: FISH , "tropical fish" => crate :: animals_and_nature :: animal_marine :: TROPICAL_FISH , "blowfish" => crate :: animals_and_nature :: animal_marine :: BLOWFISH , "shark" => crate :: animals_and_nature :: animal_marine :: SHARK , "octopus" => crate :: animals_and_nature :: animal_marine :: OCTOPUS , "spiral shell" => crate :: animals_and_nature :: animal_marine :: SPIRAL_SHELL , "snail" => crate :: animals_and_nature :: animal_bug :: SNAIL , "butterfly" => crate :: animals_and_nature :: animal_bug :: BUTTERFLY , "bug" => crate :: animals_and_nature :: animal_bug :: BUG , "ant" => crate :: animals_and_nature :: animal_bug :: ANT , "honeybee" => crate :: animals_and_nature :: animal_bug :: HONEYBEE , "beetle" => crate :: animals_and_nature :: animal_bug :: BEETLE , "lady beetle" => crate :: animals_and_nature :: animal_bug :: LADY_BEETLE , "cricket" => crate :: animals_and_nature :: animal_bug :: CRICKET , "cockroach" => crate :: animals_and_nature :: animal_bug :: COCKROACH , "spider" => crate :: animals_and_nature :: animal_bug :: SPIDER , "spider web" => crate :: animals_and_nature :: animal_bug :: SPIDER_WEB , "scorpion" => crate :: animals_and_nature :: animal_bug :: SCORPION , "mosquito" => crate :: animals_and_nature :: animal_bug :: MOSQUITO , "fly" => crate :: animals_and_nature :: animal_bug :: FLY , "worm" => crate :: animals_and_nature :: animal_bug :: WORM , "microbe" => crate :: animals_and_nature :: animal_bug :: MICROBE , "bouquet" => crate :: animals_and_nature :: plant_flower :: BOUQUET , "cherry blossom" => crate :: animals_and_nature :: plant_flower :: CHERRY_BLOSSOM , "white flower" => crate :: animals_and_nature :: plant_flower :: WHITE_FLOWER , "rosette" => crate :: animals_and_nature :: plant_flower :: ROSETTE , "rose" => crate :: animals_and_nature :: plant_flower :: ROSE , "wilted flower" => crate :: animals_and_nature :: plant_flower :: WILTED_FLOWER , "hibiscus" => crate :: animals_and_nature :: plant_flower :: HIBISCUS , "sunflower" => crate :: animals_and_nature :: plant_flower :: SUNFLOWER , "blossom" => crate :: animals_and_nature :: plant_flower :: BLOSSOM , "tulip" => crate :: animals_and_nature :: plant_flower :: TULIP , "seedling" => crate :: animals_and_nature :: plant_other :: SEEDLING , "potted plant" => crate :: animals_and_nature :: plant_other :: POTTED_PLANT , "evergreen tree" => crate :: animals_and_nature :: plant_other :: EVERGREEN_TREE , "deciduous tree" => crate :: animals_and_nature :: plant_other :: DECIDUOUS_TREE , "palm tree" => crate :: animals_and_nature :: plant_other :: PALM_TREE , "cactus" => crate :: animals_and_nature :: plant_other :: CACTUS , "sheaf of rice" => crate :: animals_and_nature :: plant_other :: SHEAF_OF_RICE , "herb" => crate :: animals_and_nature :: plant_other :: HERB , "shamrock" => crate :: animals_and_nature :: plant_other :: SHAMROCK , "four leaf clover" => crate :: animals_and_nature :: plant_other :: FOUR_LEAF_CLOVER , "maple leaf" => crate :: animals_and_nature :: plant_other :: MAPLE_LEAF , "fallen leaf" => crate :: animals_and_nature :: plant_other :: FALLEN_LEAF , "leaf fluttering in wind" => crate :: animals_and_nature :: plant_other :: LEAF_FLUTTERING_IN_WIND , "grapes" => crate :: food_and_drink :: food_fruit :: GRAPES , "melon" => crate :: food_and_drink :: food_fruit :: MELON , "watermelon" => crate :: food_and_drink :: food_fruit :: WATERMELON , "tangerine" => crate :: food_and_drink :: food_fruit :: TANGERINE , "lemon" => crate :: food_and_drink :: food_fruit :: LEMON , "banana" => crate :: food_and_drink :: food_fruit :: BANANA , "pineapple" => crate :: food_and_drink :: food_fruit :: PINEAPPLE , "mango" => crate :: food_and_drink :: food_fruit :: MANGO , "red apple" => crate :: food_and_drink :: food_fruit :: RED_APPLE , "green apple" => crate :: food_and_drink :: food_fruit :: GREEN_APPLE , "pear" => crate :: food_and_drink :: food_fruit :: PEAR , "peach" => crate :: food_and_drink :: food_fruit :: PEACH , "cherries" => crate :: food_and_drink :: food_fruit :: CHERRIES , "strawberry" => crate :: food_and_drink :: food_fruit :: STRAWBERRY , "blueberries" => crate :: food_and_drink :: food_fruit :: BLUEBERRIES , "kiwi fruit" => crate :: food_and_drink :: food_fruit :: KIWI_FRUIT , "tomato" => crate :: food_and_drink :: food_fruit :: TOMATO , "olive" => crate :: food_and_drink :: food_fruit :: OLIVE , "coconut" => crate :: food_and_drink :: food_fruit :: COCONUT , "avocado" => crate :: food_and_drink :: food_vegetable :: AVOCADO , "eggplant" => crate :: food_and_drink :: food_vegetable :: EGGPLANT , "potato" => crate :: food_and_drink :: food_vegetable :: POTATO , "carrot" => crate :: food_and_drink :: food_vegetable :: CARROT , "ear of corn" => crate :: food_and_drink :: food_vegetable :: EAR_OF_CORN , "hot pepper" => crate :: food_and_drink :: food_vegetable :: HOT_PEPPER , "bell pepper" => crate :: food_and_drink :: food_vegetable :: BELL_PEPPER , "cucumber" => crate :: food_and_drink :: food_vegetable :: CUCUMBER , "leafy green" => crate :: food_and_drink :: food_vegetable :: LEAFY_GREEN , "broccoli" => crate :: food_and_drink :: food_vegetable :: BROCCOLI , "garlic" => crate :: food_and_drink :: food_vegetable :: GARLIC , "onion" => crate :: food_and_drink :: food_vegetable :: ONION , "mushroom" => crate :: food_and_drink :: food_vegetable :: MUSHROOM , "peanuts" => crate :: food_and_drink :: food_vegetable :: PEANUTS , "chestnut" => crate :: food_and_drink :: food_vegetable :: CHESTNUT , "bread" => crate :: food_and_drink :: food_prepared :: BREAD , "croissant" => crate :: food_and_drink :: food_prepared :: CROISSANT , "baguette bread" => crate :: food_and_drink :: food_prepared :: BAGUETTE_BREAD , "flatbread" => crate :: food_and_drink :: food_prepared :: FLATBREAD , "pretzel" => crate :: food_and_drink :: food_prepared :: PRETZEL , "bagel" => crate :: food_and_drink :: food_prepared :: BAGEL , "pancakes" => crate :: food_and_drink :: food_prepared :: PANCAKES , "waffle" => crate :: food_and_drink :: food_prepared :: WAFFLE , "cheese wedge" => crate :: food_and_drink :: food_prepared :: CHEESE_WEDGE , "meat on bone" => crate :: food_and_drink :: food_prepared :: MEAT_ON_BONE , "poultry leg" => crate :: food_and_drink :: food_prepared :: POULTRY_LEG , "cut of meat" => crate :: food_and_drink :: food_prepared :: CUT_OF_MEAT , "bacon" => crate :: food_and_drink :: food_prepared :: BACON , "hamburger" => crate :: food_and_drink :: food_prepared :: HAMBURGER , "french fries" => crate :: food_and_drink :: food_prepared :: FRENCH_FRIES , "pizza" => crate :: food_and_drink :: food_prepared :: PIZZA , "hot dog" => crate :: food_and_drink :: food_prepared :: HOT_DOG , "sandwich" => crate :: food_and_drink :: food_prepared :: SANDWICH , "taco" => crate :: food_and_drink :: food_prepared :: TACO , "burrito" => crate :: food_and_drink :: food_prepared :: BURRITO , "tamale" => crate :: food_and_drink :: food_prepared :: TAMALE , "stuffed flatbread" => crate :: food_and_drink :: food_prepared :: STUFFED_FLATBREAD , "falafel" => crate :: food_and_drink :: food_prepared :: FALAFEL , "egg" => crate :: food_and_drink :: food_prepared :: EGG , "cooking" => crate :: food_and_drink :: food_prepared :: COOKING , "shallow pan of food" => crate :: food_and_drink :: food_prepared :: SHALLOW_PAN_OF_FOOD , "pot of food" => crate :: food_and_drink :: food_prepared :: POT_OF_FOOD , "fondue" => crate :: food_and_drink :: food_prepared :: FONDUE , "bowl with spoon" => crate :: food_and_drink :: food_prepared :: BOWL_WITH_SPOON , "green salad" => crate :: food_and_drink :: food_prepared :: GREEN_SALAD , "popcorn" => crate :: food_and_drink :: food_prepared :: POPCORN , "butter" => crate :: food_and_drink :: food_prepared :: BUTTER , "salt" => crate :: food_and_drink :: food_prepared :: SALT , "canned food" => crate :: food_and_drink :: food_prepared :: CANNED_FOOD , "bento box" => crate :: food_and_drink :: food_asian :: BENTO_BOX , "rice cracker" => crate :: food_and_drink :: food_asian :: RICE_CRACKER , "rice ball" => crate :: food_and_drink :: food_asian :: RICE_BALL , "cooked rice" => crate :: food_and_drink :: food_asian :: COOKED_RICE , "curry rice" => crate :: food_and_drink :: food_asian :: CURRY_RICE , "steaming bowl" => crate :: food_and_drink :: food_asian :: STEAMING_BOWL , "spaghetti" => crate :: food_and_drink :: food_asian :: SPAGHETTI , "roasted sweet potato" => crate :: food_and_drink :: food_asian :: ROASTED_SWEET_POTATO , "oden" => crate :: food_and_drink :: food_asian :: ODEN , "sushi" => crate :: food_and_drink :: food_asian :: SUSHI , "fried shrimp" => crate :: food_and_drink :: food_asian :: FRIED_SHRIMP , "fish cake with swirl" => crate :: food_and_drink :: food_asian :: FISH_CAKE_WITH_SWIRL , "moon cake" => crate :: food_and_drink :: food_asian :: MOON_CAKE , "dango" => crate :: food_and_drink :: food_asian :: DANGO , "dumpling" => crate :: food_and_drink :: food_asian :: DUMPLING , "fortune cookie" => crate :: food_and_drink :: food_asian :: FORTUNE_COOKIE , "takeout box" => crate :: food_and_drink :: food_asian :: TAKEOUT_BOX , "crab" => crate :: food_and_drink :: food_marine :: CRAB , "lobster" => crate :: food_and_drink :: food_marine :: LOBSTER , "shrimp" => crate :: food_and_drink :: food_marine :: SHRIMP , "squid" => crate :: food_and_drink :: food_marine :: SQUID , "oyster" => crate :: food_and_drink :: food_marine :: OYSTER , "soft ice cream" => crate :: food_and_drink :: food_sweet :: SOFT_ICE_CREAM , "shaved ice" => crate :: food_and_drink :: food_sweet :: SHAVED_ICE , "ice cream" => crate :: food_and_drink :: food_sweet :: ICE_CREAM , "doughnut" => crate :: food_and_drink :: food_sweet :: DOUGHNUT , "cookie" => crate :: food_and_drink :: food_sweet :: COOKIE , "birthday cake" => crate :: food_and_drink :: food_sweet :: BIRTHDAY_CAKE , "shortcake" => crate :: food_and_drink :: food_sweet :: SHORTCAKE , "cupcake" => crate :: food_and_drink :: food_sweet :: CUPCAKE , "pie" => crate :: food_and_drink :: food_sweet :: PIE , "chocolate bar" => crate :: food_and_drink :: food_sweet :: CHOCOLATE_BAR , "candy" => crate :: food_and_drink :: food_sweet :: CANDY , "lollipop" => crate :: food_and_drink :: food_sweet :: LOLLIPOP , "custard" => crate :: food_and_drink :: food_sweet :: CUSTARD , "honey pot" => crate :: food_and_drink :: food_sweet :: HONEY_POT , "baby bottle" => crate :: food_and_drink :: drink :: BABY_BOTTLE , "glass of milk" => crate :: food_and_drink :: drink :: GLASS_OF_MILK , "hot beverage" => crate :: food_and_drink :: drink :: HOT_BEVERAGE , "teapot" => crate :: food_and_drink :: drink :: TEAPOT , "teacup without handle" => crate :: food_and_drink :: drink :: TEACUP_WITHOUT_HANDLE , "sake" => crate :: food_and_drink :: drink :: SAKE , "bottle with popping cork" => crate :: food_and_drink :: drink :: BOTTLE_WITH_POPPING_CORK , "wine glass" => crate :: food_and_drink :: drink :: WINE_GLASS , "cocktail glass" => crate :: food_and_drink :: drink :: COCKTAIL_GLASS , "tropical drink" => crate :: food_and_drink :: drink :: TROPICAL_DRINK , "beer mug" => crate :: food_and_drink :: drink :: BEER_MUG , "clinking beer mugs" => crate :: food_and_drink :: drink :: CLINKING_BEER_MUGS , "clinking glasses" => crate :: food_and_drink :: drink :: CLINKING_GLASSES , "tumbler glass" => crate :: food_and_drink :: drink :: TUMBLER_GLASS , "cup with straw" => crate :: food_and_drink :: drink :: CUP_WITH_STRAW , "bubble tea" => crate :: food_and_drink :: drink :: BUBBLE_TEA , "beverage box" => crate :: food_and_drink :: drink :: BEVERAGE_BOX , "mate" => crate :: food_and_drink :: drink :: MATE , "ice" => crate :: food_and_drink :: drink :: ICE , "chopsticks" => crate :: food_and_drink :: dishware :: CHOPSTICKS , "fork and knife with plate" => crate :: food_and_drink :: dishware :: FORK_AND_KNIFE_WITH_PLATE , "fork and knife" => crate :: food_and_drink :: dishware :: FORK_AND_KNIFE , "spoon" => crate :: food_and_drink :: dishware :: SPOON , "kitchen knife" => crate :: food_and_drink :: dishware :: KITCHEN_KNIFE , "amphora" => crate :: food_and_drink :: dishware :: AMPHORA , "globe showing Europe-Africa" => crate :: travel_and_places :: place_map :: GLOBE_SHOWING_EUROPE_AFRICA , "globe showing Americas" => crate :: travel_and_places :: place_map :: GLOBE_SHOWING_AMERICAS , "globe showing Asia-Australia" => crate :: travel_and_places :: place_map :: GLOBE_SHOWING_ASIA_AUSTRALIA , "globe with meridians" => crate :: travel_and_places :: place_map :: GLOBE_WITH_MERIDIANS , "world map" => crate :: travel_and_places :: place_map :: WORLD_MAP , "map of Japan" => crate :: travel_and_places :: place_map :: MAP_OF_JAPAN , "compass" => crate :: travel_and_places :: place_map :: COMPASS , "snow-capped mountain" => crate :: travel_and_places :: place_geographic :: SNOW_CAPPED_MOUNTAIN , "mountain" => crate :: travel_and_places :: place_geographic :: MOUNTAIN , "volcano" => crate :: travel_and_places :: place_geographic :: VOLCANO , "mount fuji" => crate :: travel_and_places :: place_geographic :: MOUNT_FUJI , "camping" => crate :: travel_and_places :: place_geographic :: CAMPING , "beach with umbrella" => crate :: travel_and_places :: place_geographic :: BEACH_WITH_UMBRELLA , "desert" => crate :: travel_and_places :: place_geographic :: DESERT , "desert island" => crate :: travel_and_places :: place_geographic :: DESERT_ISLAND , "national park" => crate :: travel_and_places :: place_geographic :: NATIONAL_PARK , "stadium" => crate :: travel_and_places :: place_building :: STADIUM , "classical building" => crate :: travel_and_places :: place_building :: CLASSICAL_BUILDING , "building construction" => crate :: travel_and_places :: place_building :: BUILDING_CONSTRUCTION , "brick" => crate :: travel_and_places :: place_building :: BRICK , "rock" => crate :: travel_and_places :: place_building :: ROCK , "wood" => crate :: travel_and_places :: place_building :: WOOD , "hut" => crate :: travel_and_places :: place_building :: HUT , "houses" => crate :: travel_and_places :: place_building :: HOUSES , "derelict house" => crate :: travel_and_places :: place_building :: DERELICT_HOUSE , "house" => crate :: travel_and_places :: place_building :: HOUSE , "house with garden" => crate :: travel_and_places :: place_building :: HOUSE_WITH_GARDEN , "office building" => crate :: travel_and_places :: place_building :: OFFICE_BUILDING , "Japanese post office" => crate :: travel_and_places :: place_building :: JAPANESE_POST_OFFICE , "post office" => crate :: travel_and_places :: place_building :: POST_OFFICE , "hospital" => crate :: travel_and_places :: place_building :: HOSPITAL , "bank" => crate :: travel_and_places :: place_building :: BANK , "hotel" => crate :: travel_and_places :: place_building :: HOTEL , "love hotel" => crate :: travel_and_places :: place_building :: LOVE_HOTEL , "convenience store" => crate :: travel_and_places :: place_building :: CONVENIENCE_STORE , "school" => crate :: travel_and_places :: place_building :: SCHOOL , "department store" => crate :: travel_and_places :: place_building :: DEPARTMENT_STORE , "factory" => crate :: travel_and_places :: place_building :: FACTORY , "Japanese castle" => crate :: travel_and_places :: place_building :: JAPANESE_CASTLE , "castle" => crate :: travel_and_places :: place_building :: CASTLE , "wedding" => crate :: travel_and_places :: place_building :: WEDDING , "Tokyo tower" => crate :: travel_and_places :: place_building :: TOKYO_TOWER , "Statue of Liberty" => crate :: travel_and_places :: place_building :: STATUE_OF_LIBERTY , "church" => crate :: travel_and_places :: place_religious :: CHURCH , "mosque" => crate :: travel_and_places :: place_religious :: MOSQUE , "hindu temple" => crate :: travel_and_places :: place_religious :: HINDU_TEMPLE , "synagogue" => crate :: travel_and_places :: place_religious :: SYNAGOGUE , "shinto shrine" => crate :: travel_and_places :: place_religious :: SHINTO_SHRINE , "kaaba" => crate :: travel_and_places :: place_religious :: KAABA , "fountain" => crate :: travel_and_places :: place_other :: FOUNTAIN , "tent" => crate :: travel_and_places :: place_other :: TENT , "foggy" => crate :: travel_and_places :: place_other :: FOGGY , "night with stars" => crate :: travel_and_places :: place_other :: NIGHT_WITH_STARS , "cityscape" => crate :: travel_and_places :: place_other :: CITYSCAPE , "sunrise over mountains" => crate :: travel_and_places :: place_other :: SUNRISE_OVER_MOUNTAINS , "sunrise" => crate :: travel_and_places :: place_other :: SUNRISE , "cityscape at dusk" => crate :: travel_and_places :: place_other :: CITYSCAPE_AT_DUSK , "sunset" => crate :: travel_and_places :: place_other :: SUNSET , "bridge at night" => crate :: travel_and_places :: place_other :: BRIDGE_AT_NIGHT , "hot springs" => crate :: travel_and_places :: place_other :: HOT_SPRINGS , "carousel horse" => crate :: travel_and_places :: place_other :: CAROUSEL_HORSE , "ferris wheel" => crate :: travel_and_places :: place_other :: FERRIS_WHEEL , "roller coaster" => crate :: travel_and_places :: place_other :: ROLLER_COASTER , "barber pole" => crate :: travel_and_places :: place_other :: BARBER_POLE , "circus tent" => crate :: travel_and_places :: place_other :: CIRCUS_TENT , "locomotive" => crate :: travel_and_places :: transport_ground :: LOCOMOTIVE , "railway car" => crate :: travel_and_places :: transport_ground :: RAILWAY_CAR , "high-speed train" => crate :: travel_and_places :: transport_ground :: HIGH_SPEED_TRAIN , "bullet train" => crate :: travel_and_places :: transport_ground :: BULLET_TRAIN , "train" => crate :: travel_and_places :: transport_ground :: TRAIN , "metro" => crate :: travel_and_places :: transport_ground :: METRO , "light rail" => crate :: travel_and_places :: transport_ground :: LIGHT_RAIL , "station" => crate :: travel_and_places :: transport_ground :: STATION , "tram" => crate :: travel_and_places :: transport_ground :: TRAM , "monorail" => crate :: travel_and_places :: transport_ground :: MONORAIL , "mountain railway" => crate :: travel_and_places :: transport_ground :: MOUNTAIN_RAILWAY , "tram car" => crate :: travel_and_places :: transport_ground :: TRAM_CAR , "bus" => crate :: travel_and_places :: transport_ground :: BUS , "oncoming bus" => crate :: travel_and_places :: transport_ground :: ONCOMING_BUS , "trolleybus" => crate :: travel_and_places :: transport_ground :: TROLLEYBUS , "minibus" => crate :: travel_and_places :: transport_ground :: MINIBUS , "ambulance" => crate :: travel_and_places :: transport_ground :: AMBULANCE , "fire engine" => crate :: travel_and_places :: transport_ground :: FIRE_ENGINE , "police car" => crate :: travel_and_places :: transport_ground :: POLICE_CAR , "oncoming police car" => crate :: travel_and_places :: transport_ground :: ONCOMING_POLICE_CAR , "taxi" => crate :: travel_and_places :: transport_ground :: TAXI , "oncoming taxi" => crate :: travel_and_places :: transport_ground :: ONCOMING_TAXI , "automobile" => crate :: travel_and_places :: transport_ground :: AUTOMOBILE , "oncoming automobile" => crate :: travel_and_places :: transport_ground :: ONCOMING_AUTOMOBILE , "sport utility vehicle" => crate :: travel_and_places :: transport_ground :: SPORT_UTILITY_VEHICLE , "pickup truck" => crate :: travel_and_places :: transport_ground :: PICKUP_TRUCK , "delivery truck" => crate :: travel_and_places :: transport_ground :: DELIVERY_TRUCK , "articulated lorry" => crate :: travel_and_places :: transport_ground :: ARTICULATED_LORRY , "tractor" => crate :: travel_and_places :: transport_ground :: TRACTOR , "racing car" => crate :: travel_and_places :: transport_ground :: RACING_CAR , "motorcycle" => crate :: travel_and_places :: transport_ground :: MOTORCYCLE , "motor scooter" => crate :: travel_and_places :: transport_ground :: MOTOR_SCOOTER , "manual wheelchair" => crate :: travel_and_places :: transport_ground :: MANUAL_WHEELCHAIR , "motorized wheelchair" => crate :: travel_and_places :: transport_ground :: MOTORIZED_WHEELCHAIR , "auto rickshaw" => crate :: travel_and_places :: transport_ground :: AUTO_RICKSHAW , "bicycle" => crate :: travel_and_places :: transport_ground :: BICYCLE , "kick scooter" => crate :: travel_and_places :: transport_ground :: KICK_SCOOTER , "skateboard" => crate :: travel_and_places :: transport_ground :: SKATEBOARD , "roller skate" => crate :: travel_and_places :: transport_ground :: ROLLER_SKATE , "bus stop" => crate :: travel_and_places :: transport_ground :: BUS_STOP , "motorway" => crate :: travel_and_places :: transport_ground :: MOTORWAY , "railway track" => crate :: travel_and_places :: transport_ground :: RAILWAY_TRACK , "oil drum" => crate :: travel_and_places :: transport_ground :: OIL_DRUM , "fuel pump" => crate :: travel_and_places :: transport_ground :: FUEL_PUMP , "police car light" => crate :: travel_and_places :: transport_ground :: POLICE_CAR_LIGHT , "horizontal traffic light" => crate :: travel_and_places :: transport_ground :: HORIZONTAL_TRAFFIC_LIGHT , "vertical traffic light" => crate :: travel_and_places :: transport_ground :: VERTICAL_TRAFFIC_LIGHT , "stop sign" => crate :: travel_and_places :: transport_ground :: STOP_SIGN , "construction" => crate :: travel_and_places :: transport_ground :: CONSTRUCTION , "anchor" => crate :: travel_and_places :: transport_water :: ANCHOR , "sailboat" => crate :: travel_and_places :: transport_water :: SAILBOAT , "canoe" => crate :: travel_and_places :: transport_water :: CANOE , "speedboat" => crate :: travel_and_places :: transport_water :: SPEEDBOAT , "passenger ship" => crate :: travel_and_places :: transport_water :: PASSENGER_SHIP , "ferry" => crate :: travel_and_places :: transport_water :: FERRY , "motor boat" => crate :: travel_and_places :: transport_water :: MOTOR_BOAT , "ship" => crate :: travel_and_places :: transport_water :: SHIP , "airplane" => crate :: travel_and_places :: transport_air :: AIRPLANE , "small airplane" => crate :: travel_and_places :: transport_air :: SMALL_AIRPLANE , "airplane departure" => crate :: travel_and_places :: transport_air :: AIRPLANE_DEPARTURE , "airplane arrival" => crate :: travel_and_places :: transport_air :: AIRPLANE_ARRIVAL , "parachute" => crate :: travel_and_places :: transport_air :: PARACHUTE , "seat" => crate :: travel_and_places :: transport_air :: SEAT , "helicopter" => crate :: travel_and_places :: transport_air :: HELICOPTER , "suspension railway" => crate :: travel_and_places :: transport_air :: SUSPENSION_RAILWAY , "mountain cableway" => crate :: travel_and_places :: transport_air :: MOUNTAIN_CABLEWAY , "aerial tramway" => crate :: travel_and_places :: transport_air :: AERIAL_TRAMWAY , "satellite" => crate :: travel_and_places :: transport_air :: SATELLITE , "rocket" => crate :: travel_and_places :: transport_air :: ROCKET , "flying saucer" => crate :: travel_and_places :: transport_air :: FLYING_SAUCER , "bellhop bell" => crate :: travel_and_places :: hotel :: BELLHOP_BELL , "luggage" => crate :: travel_and_places :: hotel :: LUGGAGE , "hourglass done" => crate :: travel_and_places :: time :: HOURGLASS_DONE , "hourglass not done" => crate :: travel_and_places :: time :: HOURGLASS_NOT_DONE , "watch" => crate :: travel_and_places :: time :: WATCH , "alarm clock" => crate :: travel_and_places :: time :: ALARM_CLOCK , "stopwatch" => crate :: travel_and_places :: time :: STOPWATCH , "timer clock" => crate :: travel_and_places :: time :: TIMER_CLOCK , "mantelpiece clock" => crate :: travel_and_places :: time :: MANTELPIECE_CLOCK , "twelve o’clock" => crate :: travel_and_places :: time :: TWELVE_OCLOCK , "twelve-thirty" => crate :: travel_and_places :: time :: TWELVE_THIRTY , "one o’clock" => crate :: travel_and_places :: time :: ONE_OCLOCK , "one-thirty" => crate :: travel_and_places :: time :: ONE_THIRTY , "two o’clock" => crate :: travel_and_places :: time :: TWO_OCLOCK , "two-thirty" => crate :: travel_and_places :: time :: TWO_THIRTY , "three o’clock" => crate :: travel_and_places :: time :: THREE_OCLOCK , "three-thirty" => crate :: travel_and_places :: time :: THREE_THIRTY , "four o’clock" => crate :: travel_and_places :: time :: FOUR_OCLOCK , "four-thirty" => crate :: travel_and_places :: time :: FOUR_THIRTY , "five o’clock" => crate :: travel_and_places :: time :: FIVE_OCLOCK , "five-thirty" => crate :: travel_and_places :: time :: FIVE_THIRTY , "six o’clock" => crate :: travel_and_places :: time :: SIX_OCLOCK , "six-thirty" => crate :: travel_and_places :: time :: SIX_THIRTY , "seven o’clock" => crate :: travel_and_places :: time :: SEVEN_OCLOCK , "seven-thirty" => crate :: travel_and_places :: time :: SEVEN_THIRTY , "eight o’clock" => crate :: travel_and_places :: time :: EIGHT_OCLOCK , "eight-thirty" => crate :: travel_and_places :: time :: EIGHT_THIRTY , "nine o’clock" => crate :: travel_and_places :: time :: NINE_OCLOCK , "nine-thirty" => crate :: travel_and_places :: time :: NINE_THIRTY , "ten o’clock" => crate :: travel_and_places :: time :: TEN_OCLOCK , "ten-thirty" => crate :: travel_and_places :: time :: TEN_THIRTY , "eleven o’clock" => crate :: travel_and_places :: time :: ELEVEN_OCLOCK , "eleven-thirty" => crate :: travel_and_places :: time :: ELEVEN_THIRTY , "new moon" => crate :: travel_and_places :: sky_and_weather :: NEW_MOON , "waxing crescent moon" => crate :: travel_and_places :: sky_and_weather :: WAXING_CRESCENT_MOON , "first quarter moon" => crate :: travel_and_places :: sky_and_weather :: FIRST_QUARTER_MOON , "waxing gibbous moon" => crate :: travel_and_places :: sky_and_weather :: WAXING_GIBBOUS_MOON , "full moon" => crate :: travel_and_places :: sky_and_weather :: FULL_MOON , "waning gibbous moon" => crate :: travel_and_places :: sky_and_weather :: WANING_GIBBOUS_MOON , "last quarter moon" => crate :: travel_and_places :: sky_and_weather :: LAST_QUARTER_MOON , "waning crescent moon" => crate :: travel_and_places :: sky_and_weather :: WANING_CRESCENT_MOON , "crescent moon" => crate :: travel_and_places :: sky_and_weather :: CRESCENT_MOON , "new moon face" => crate :: travel_and_places :: sky_and_weather :: NEW_MOON_FACE , "first quarter moon face" => crate :: travel_and_places :: sky_and_weather :: FIRST_QUARTER_MOON_FACE , "last quarter moon face" => crate :: travel_and_places :: sky_and_weather :: LAST_QUARTER_MOON_FACE , "thermometer" => crate :: travel_and_places :: sky_and_weather :: THERMOMETER , "sun" => crate :: travel_and_places :: sky_and_weather :: SUN , "full moon face" => crate :: travel_and_places :: sky_and_weather :: FULL_MOON_FACE , "sun with face" => crate :: travel_and_places :: sky_and_weather :: SUN_WITH_FACE , "ringed planet" => crate :: travel_and_places :: sky_and_weather :: RINGED_PLANET , "star" => crate :: travel_and_places :: sky_and_weather :: STAR , "glowing star" => crate :: travel_and_places :: sky_and_weather :: GLOWING_STAR , "shooting star" => crate :: travel_and_places :: sky_and_weather :: SHOOTING_STAR , "milky way" => crate :: travel_and_places :: sky_and_weather :: MILKY_WAY , "cloud" => crate :: travel_and_places :: sky_and_weather :: CLOUD , "sun behind cloud" => crate :: travel_and_places :: sky_and_weather :: SUN_BEHIND_CLOUD , "cloud with lightning and rain" => crate :: travel_and_places :: sky_and_weather :: CLOUD_WITH_LIGHTNING_AND_RAIN , "sun behind small cloud" => crate :: travel_and_places :: sky_and_weather :: SUN_BEHIND_SMALL_CLOUD , "sun behind large cloud" => crate :: travel_and_places :: sky_and_weather :: SUN_BEHIND_LARGE_CLOUD , "sun behind rain cloud" => crate :: travel_and_places :: sky_and_weather :: SUN_BEHIND_RAIN_CLOUD , "cloud with rain" => crate :: travel_and_places :: sky_and_weather :: CLOUD_WITH_RAIN , "cloud with snow" => crate :: travel_and_places :: sky_and_weather :: CLOUD_WITH_SNOW , "cloud with lightning" => crate :: travel_and_places :: sky_and_weather :: CLOUD_WITH_LIGHTNING , "tornado" => crate :: travel_and_places :: sky_and_weather :: TORNADO , "fog" => crate :: travel_and_places :: sky_and_weather :: FOG , "wind face" => crate :: travel_and_places :: sky_and_weather :: WIND_FACE , "cyclone" => crate :: travel_and_places :: sky_and_weather :: CYCLONE , "rainbow" => crate :: travel_and_places :: sky_and_weather :: RAINBOW , "closed umbrella" => crate :: travel_and_places :: sky_and_weather :: CLOSED_UMBRELLA , "umbrella" => crate :: travel_and_places :: sky_and_weather :: UMBRELLA , "umbrella with rain drops" => crate :: travel_and_places :: sky_and_weather :: UMBRELLA_WITH_RAIN_DROPS , "umbrella on ground" => crate :: travel_and_places :: sky_and_weather :: UMBRELLA_ON_GROUND , "high voltage" => crate :: travel_and_places :: sky_and_weather :: HIGH_VOLTAGE , "snowflake" => crate :: travel_and_places :: sky_and_weather :: SNOWFLAKE , "snowman" => crate :: travel_and_places :: sky_and_weather :: SNOWMAN , "snowman without snow" => crate :: travel_and_places :: sky_and_weather :: SNOWMAN_WITHOUT_SNOW , "comet" => crate :: travel_and_places :: sky_and_weather :: COMET , "fire" => crate :: travel_and_places :: sky_and_weather :: FIRE , "droplet" => crate :: travel_and_places :: sky_and_weather :: DROPLET , "water wave" => crate :: travel_and_places :: sky_and_weather :: WATER_WAVE , "jack-o-lantern" => crate :: activities :: event :: JACK_O_LANTERN , "Christmas tree" => crate :: activities :: event :: CHRISTMAS_TREE , "fireworks" => crate :: activities :: event :: FIREWORKS , "sparkler" => crate :: activities :: event :: SPARKLER , "firecracker" => crate :: activities :: event :: FIRECRACKER , "sparkles" => crate :: activities :: event :: SPARKLES , "balloon" => crate :: activities :: event :: BALLOON , "party popper" => crate :: activities :: event :: PARTY_POPPER , "confetti ball" => crate :: activities :: event :: CONFETTI_BALL , "tanabata tree" => crate :: activities :: event :: TANABATA_TREE , "pine decoration" => crate :: activities :: event :: PINE_DECORATION , "Japanese dolls" => crate :: activities :: event :: JAPANESE_DOLLS , "carp streamer" => crate :: activities :: event :: CARP_STREAMER , "wind chime" => crate :: activities :: event :: WIND_CHIME , "moon viewing ceremony" => crate :: activities :: event :: MOON_VIEWING_CEREMONY , "red envelope" => crate :: activities :: event :: RED_ENVELOPE , "ribbon" => crate :: activities :: event :: RIBBON , "wrapped gift" => crate :: activities :: event :: WRAPPED_GIFT , "reminder ribbon" => crate :: activities :: event :: REMINDER_RIBBON , "admission tickets" => crate :: activities :: event :: ADMISSION_TICKETS , "ticket" => crate :: activities :: event :: TICKET , "military medal" => crate :: activities :: award_medal :: MILITARY_MEDAL , "trophy" => crate :: activities :: award_medal :: TROPHY , "sports medal" => crate :: activities :: award_medal :: SPORTS_MEDAL , "1st place medal" => crate :: activities :: award_medal :: FIRST_PLACE_MEDAL , "2nd place medal" => crate :: activities :: award_medal :: SECOND_PLACE_MEDAL , "3rd place medal" => crate :: activities :: award_medal :: THIRD_PLACE_MEDAL , "soccer ball" => crate :: activities :: sport :: SOCCER_BALL , "baseball" => crate :: activities :: sport :: BASEBALL , "softball" => crate :: activities :: sport :: SOFTBALL , "basketball" => crate :: activities :: sport :: BASKETBALL , "volleyball" => crate :: activities :: sport :: VOLLEYBALL , "american football" => crate :: activities :: sport :: AMERICAN_FOOTBALL , "rugby football" => crate :: activities :: sport :: RUGBY_FOOTBALL , "tennis" => crate :: activities :: sport :: TENNIS , "flying disc" => crate :: activities :: sport :: FLYING_DISC , "bowling" => crate :: activities :: sport :: BOWLING , "cricket game" => crate :: activities :: sport :: CRICKET_GAME , "field hockey" => crate :: activities :: sport :: FIELD_HOCKEY , "ice hockey" => crate :: activities :: sport :: ICE_HOCKEY , "lacrosse" => crate :: activities :: sport :: LACROSSE , "ping pong" => crate :: activities :: sport :: PING_PONG , "badminton" => crate :: activities :: sport :: BADMINTON , "boxing glove" => crate :: activities :: sport :: BOXING_GLOVE , "martial arts uniform" => crate :: activities :: sport :: MARTIAL_ARTS_UNIFORM , "goal net" => crate :: activities :: sport :: GOAL_NET , "flag in hole" => crate :: activities :: sport :: FLAG_IN_HOLE , "ice skate" => crate :: activities :: sport :: ICE_SKATE , "fishing pole" => crate :: activities :: sport :: FISHING_POLE , "diving mask" => crate :: activities :: sport :: DIVING_MASK , "running shirt" => crate :: activities :: sport :: RUNNING_SHIRT , "skis" => crate :: activities :: sport :: SKIS , "sled" => crate :: activities :: sport :: SLED , "curling stone" => crate :: activities :: sport :: CURLING_STONE , "bullseye" => crate :: activities :: game :: BULLSEYE , "yo-yo" => crate :: activities :: game :: YO_YO , "kite" => crate :: activities :: game :: KITE , "pool 8 ball" => crate :: activities :: game :: POOL_8_BALL , "crystal ball" => crate :: activities :: game :: CRYSTAL_BALL , "magic wand" => crate :: activities :: game :: MAGIC_WAND , "nazar amulet" => crate :: activities :: game :: NAZAR_AMULET , "video game" => crate :: activities :: game :: VIDEO_GAME , "joystick" => crate :: activities :: game :: JOYSTICK , "slot machine" => crate :: activities :: game :: SLOT_MACHINE , "game die" => crate :: activities :: game :: GAME_DIE , "puzzle piece" => crate :: activities :: game :: PUZZLE_PIECE , "teddy bear" => crate :: activities :: game :: TEDDY_BEAR , "piñata" => crate :: activities :: game :: PINATA , "nesting dolls" => crate :: activities :: game :: NESTING_DOLLS , "spade suit" => crate :: activities :: game :: SPADE_SUIT , "heart suit" => crate :: activities :: game :: HEART_SUIT , "diamond suit" => crate :: activities :: game :: DIAMOND_SUIT , "club suit" => crate :: activities :: game :: CLUB_SUIT , "chess pawn" => crate :: activities :: game :: CHESS_PAWN , "joker" => crate :: activities :: game :: JOKER , "mahjong red dragon" => crate :: activities :: game :: MAHJONG_RED_DRAGON , "flower playing cards" => crate :: activities :: game :: FLOWER_PLAYING_CARDS , "performing arts" => crate :: activities :: arts_and_crafts :: PERFORMING_ARTS , "framed picture" => crate :: activities :: arts_and_crafts :: FRAMED_PICTURE , "artist palette" => crate :: activities :: arts_and_crafts :: ARTIST_PALETTE , "thread" => crate :: activities :: arts_and_crafts :: THREAD , "sewing needle" => crate :: activities :: arts_and_crafts :: SEWING_NEEDLE , "yarn" => crate :: activities :: arts_and_crafts :: YARN , "knot" => crate :: activities :: arts_and_crafts :: KNOT , "glasses" => crate :: objects :: clothing :: GLASSES , "sunglasses" => crate :: objects :: clothing :: SUNGLASSES , "goggles" => crate :: objects :: clothing :: GOGGLES , "lab coat" => crate :: objects :: clothing :: LAB_COAT , "safety vest" => crate :: objects :: clothing :: SAFETY_VEST , "necktie" => crate :: objects :: clothing :: NECKTIE , "t-shirt" => crate :: objects :: clothing :: T_SHIRT , "jeans" => crate :: objects :: clothing :: JEANS , "scarf" => crate :: objects :: clothing :: SCARF , "gloves" => crate :: objects :: clothing :: GLOVES , "coat" => crate :: objects :: clothing :: COAT , "socks" => crate :: objects :: clothing :: SOCKS , "dress" => crate :: objects :: clothing :: DRESS , "kimono" => crate :: objects :: clothing :: KIMONO , "sari" => crate :: objects :: clothing :: SARI , "one-piece swimsuit" => crate :: objects :: clothing :: ONE_PIECE_SWIMSUIT , "briefs" => crate :: objects :: clothing :: BRIEFS , "shorts" => crate :: objects :: clothing :: SHORTS , "bikini" => crate :: objects :: clothing :: BIKINI , "woman’s clothes" => crate :: objects :: clothing :: WOMANS_CLOTHES , "purse" => crate :: objects :: clothing :: PURSE , "handbag" => crate :: objects :: clothing :: HANDBAG , "clutch bag" => crate :: objects :: clothing :: CLUTCH_BAG , "shopping bags" => crate :: objects :: clothing :: SHOPPING_BAGS , "backpack" => crate :: objects :: clothing :: BACKPACK , "thong sandal" => crate :: objects :: clothing :: THONG_SANDAL , "man’s shoe" => crate :: objects :: clothing :: MANS_SHOE , "running shoe" => crate :: objects :: clothing :: RUNNING_SHOE , "hiking boot" => crate :: objects :: clothing :: HIKING_BOOT , "flat shoe" => crate :: objects :: clothing :: FLAT_SHOE , "high-heeled shoe" => crate :: objects :: clothing :: HIGH_HEELED_SHOE , "woman’s sandal" => crate :: objects :: clothing :: WOMANS_SANDAL , "ballet shoes" => crate :: objects :: clothing :: BALLET_SHOES , "woman’s boot" => crate :: objects :: clothing :: WOMANS_BOOT , "crown" => crate :: objects :: clothing :: CROWN , "woman’s hat" => crate :: objects :: clothing :: WOMANS_HAT , "top hat" => crate :: objects :: clothing :: TOP_HAT , "graduation cap" => crate :: objects :: clothing :: GRADUATION_CAP , "billed cap" => crate :: objects :: clothing :: BILLED_CAP , "military helmet" => crate :: objects :: clothing :: MILITARY_HELMET , "rescue worker’s helmet" => crate :: objects :: clothing :: RESCUE_WORKERS_HELMET , "prayer beads" => crate :: objects :: clothing :: PRAYER_BEADS , "lipstick" => crate :: objects :: clothing :: LIPSTICK , "ring" => crate :: objects :: clothing :: RING , "gem stone" => crate :: objects :: clothing :: GEM_STONE , "muted speaker" => crate :: objects :: sound :: MUTED_SPEAKER , "speaker low volume" => crate :: objects :: sound :: SPEAKER_LOW_VOLUME , "speaker medium volume" => crate :: objects :: sound :: SPEAKER_MEDIUM_VOLUME , "speaker high volume" => crate :: objects :: sound :: SPEAKER_HIGH_VOLUME , "loudspeaker" => crate :: objects :: sound :: LOUDSPEAKER , "megaphone" => crate :: objects :: sound :: MEGAPHONE , "postal horn" => crate :: objects :: sound :: POSTAL_HORN , "bell" => crate :: objects :: sound :: BELL , "bell with slash" => crate :: objects :: sound :: BELL_WITH_SLASH , "musical score" => crate :: objects :: music :: MUSICAL_SCORE , "musical note" => crate :: objects :: music :: MUSICAL_NOTE , "musical notes" => crate :: objects :: music :: MUSICAL_NOTES , "studio microphone" => crate :: objects :: music :: STUDIO_MICROPHONE , "level slider" => crate :: objects :: music :: LEVEL_SLIDER , "control knobs" => crate :: objects :: music :: CONTROL_KNOBS , "microphone" => crate :: objects :: music :: MICROPHONE , "headphone" => crate :: objects :: music :: HEADPHONE , "radio" => crate :: objects :: music :: RADIO , "saxophone" => crate :: objects :: musical_instrument :: SAXOPHONE , "accordion" => crate :: objects :: musical_instrument :: ACCORDION , "guitar" => crate :: objects :: musical_instrument :: GUITAR , "musical keyboard" => crate :: objects :: musical_instrument :: MUSICAL_KEYBOARD , "trumpet" => crate :: objects :: musical_instrument :: TRUMPET , "violin" => crate :: objects :: musical_instrument :: VIOLIN , "banjo" => crate :: objects :: musical_instrument :: BANJO , "drum" => crate :: objects :: musical_instrument :: DRUM , "long drum" => crate :: objects :: musical_instrument :: LONG_DRUM , "mobile phone" => crate :: objects :: phone :: MOBILE_PHONE , "mobile phone with arrow" => crate :: objects :: phone :: MOBILE_PHONE_WITH_ARROW , "telephone" => crate :: objects :: phone :: TELEPHONE , "telephone receiver" => crate :: objects :: phone :: TELEPHONE_RECEIVER , "pager" => crate :: objects :: phone :: PAGER , "fax machine" => crate :: objects :: phone :: FAX_MACHINE , "battery" => crate :: objects :: computer :: BATTERY , "electric plug" => crate :: objects :: computer :: ELECTRIC_PLUG , "laptop" => crate :: objects :: computer :: LAPTOP , "desktop computer" => crate :: objects :: computer :: DESKTOP_COMPUTER , "printer" => crate :: objects :: computer :: PRINTER , "keyboard" => crate :: objects :: computer :: KEYBOARD , "computer mouse" => crate :: objects :: computer :: COMPUTER_MOUSE , "trackball" => crate :: objects :: computer :: TRACKBALL , "computer disk" => crate :: objects :: computer :: COMPUTER_DISK , "floppy disk" => crate :: objects :: computer :: FLOPPY_DISK , "optical disk" => crate :: objects :: computer :: OPTICAL_DISK , "dvd" => crate :: objects :: computer :: DVD , "abacus" => crate :: objects :: computer :: ABACUS , "movie camera" => crate :: objects :: light_and_video :: MOVIE_CAMERA , "film frames" => crate :: objects :: light_and_video :: FILM_FRAMES , "film projector" => crate :: objects :: light_and_video :: FILM_PROJECTOR , "clapper board" => crate :: objects :: light_and_video :: CLAPPER_BOARD , "television" => crate :: objects :: light_and_video :: TELEVISION , "camera" => crate :: objects :: light_and_video :: CAMERA , "camera with flash" => crate :: objects :: light_and_video :: CAMERA_WITH_FLASH , "video camera" => crate :: objects :: light_and_video :: VIDEO_CAMERA , "videocassette" => crate :: objects :: light_and_video :: VIDEOCASSETTE , "magnifying glass tilted left" => crate :: objects :: light_and_video :: MAGNIFYING_GLASS_TILTED_LEFT , "magnifying glass tilted right" => crate :: objects :: light_and_video :: MAGNIFYING_GLASS_TILTED_RIGHT , "candle" => crate :: objects :: light_and_video :: CANDLE , "light bulb" => crate :: objects :: light_and_video :: LIGHT_BULB , "flashlight" => crate :: objects :: light_and_video :: FLASHLIGHT , "red paper lantern" => crate :: objects :: light_and_video :: RED_PAPER_LANTERN , "diya lamp" => crate :: objects :: light_and_video :: DIYA_LAMP , "notebook with decorative cover" => crate :: objects :: book_paper :: NOTEBOOK_WITH_DECORATIVE_COVER , "closed book" => crate :: objects :: book_paper :: CLOSED_BOOK , "open book" => crate :: objects :: book_paper :: OPEN_BOOK , "green book" => crate :: objects :: book_paper :: GREEN_BOOK , "blue book" => crate :: objects :: book_paper :: BLUE_BOOK , "orange book" => crate :: objects :: book_paper :: ORANGE_BOOK , "books" => crate :: objects :: book_paper :: BOOKS , "notebook" => crate :: objects :: book_paper :: NOTEBOOK , "ledger" => crate :: objects :: book_paper :: LEDGER , "page with curl" => crate :: objects :: book_paper :: PAGE_WITH_CURL , "scroll" => crate :: objects :: book_paper :: SCROLL , "page facing up" => crate :: objects :: book_paper :: PAGE_FACING_UP , "newspaper" => crate :: objects :: book_paper :: NEWSPAPER , "rolled-up newspaper" => crate :: objects :: book_paper :: ROLLED_UP_NEWSPAPER , "bookmark tabs" => crate :: objects :: book_paper :: BOOKMARK_TABS , "bookmark" => crate :: objects :: book_paper :: BOOKMARK , "label" => crate :: objects :: book_paper :: LABEL , "money bag" => crate :: objects :: money :: MONEY_BAG , "coin" => crate :: objects :: money :: COIN , "yen banknote" => crate :: objects :: money :: YEN_BANKNOTE , "dollar banknote" => crate :: objects :: money :: DOLLAR_BANKNOTE , "euro banknote" => crate :: objects :: money :: EURO_BANKNOTE , "pound banknote" => crate :: objects :: money :: POUND_BANKNOTE , "money with wings" => crate :: objects :: money :: MONEY_WITH_WINGS , "credit card" => crate :: objects :: money :: CREDIT_CARD , "receipt" => crate :: objects :: money :: RECEIPT , "chart increasing with yen" => crate :: objects :: money :: CHART_INCREASING_WITH_YEN , "envelope" => crate :: objects :: mail :: ENVELOPE , "e-mail" => crate :: objects :: mail :: E_MAIL , "incoming envelope" => crate :: objects :: mail :: INCOMING_ENVELOPE , "envelope with arrow" => crate :: objects :: mail :: ENVELOPE_WITH_ARROW , "outbox tray" => crate :: objects :: mail :: OUTBOX_TRAY , "inbox tray" => crate :: objects :: mail :: INBOX_TRAY , "package" => crate :: objects :: mail :: PACKAGE , "closed mailbox with raised flag" => crate :: objects :: mail :: CLOSED_MAILBOX_WITH_RAISED_FLAG , "closed mailbox with lowered flag" => crate :: objects :: mail :: CLOSED_MAILBOX_WITH_LOWERED_FLAG , "open mailbox with raised flag" => crate :: objects :: mail :: OPEN_MAILBOX_WITH_RAISED_FLAG , "open mailbox with lowered flag" => crate :: objects :: mail :: OPEN_MAILBOX_WITH_LOWERED_FLAG , "postbox" => crate :: objects :: mail :: POSTBOX , "ballot box with ballot" => crate :: objects :: mail :: BALLOT_BOX_WITH_BALLOT , "pencil" => crate :: objects :: writing :: PENCIL , "black nib" => crate :: objects :: writing :: BLACK_NIB , "fountain pen" => crate :: objects :: writing :: FOUNTAIN_PEN , "pen" => crate :: objects :: writing :: PEN , "paintbrush" => crate :: objects :: writing :: PAINTBRUSH , "crayon" => crate :: objects :: writing :: CRAYON , "memo" => crate :: objects :: writing :: MEMO , "briefcase" => crate :: objects :: office :: BRIEFCASE , "file folder" => crate :: objects :: office :: FILE_FOLDER , "open file folder" => crate :: objects :: office :: OPEN_FILE_FOLDER , "card index dividers" => crate :: objects :: office :: CARD_INDEX_DIVIDERS , "calendar" => crate :: objects :: office :: CALENDAR , "tear-off calendar" => crate :: objects :: office :: TEAR_OFF_CALENDAR , "spiral notepad" => crate :: objects :: office :: SPIRAL_NOTEPAD , "spiral calendar" => crate :: objects :: office :: SPIRAL_CALENDAR , "card index" => crate :: objects :: office :: CARD_INDEX , "chart increasing" => crate :: objects :: office :: CHART_INCREASING , "chart decreasing" => crate :: objects :: office :: CHART_DECREASING , "bar chart" => crate :: objects :: office :: BAR_CHART , "clipboard" => crate :: objects :: office :: CLIPBOARD , "pushpin" => crate :: objects :: office :: PUSHPIN , "round pushpin" => crate :: objects :: office :: ROUND_PUSHPIN , "paperclip" => crate :: objects :: office :: PAPERCLIP , "linked paperclips" => crate :: objects :: office :: LINKED_PAPERCLIPS , "straight ruler" => crate :: objects :: office :: STRAIGHT_RULER , "triangular ruler" => crate :: objects :: office :: TRIANGULAR_RULER , "scissors" => crate :: objects :: office :: SCISSORS , "card file box" => crate :: objects :: office :: CARD_FILE_BOX , "file cabinet" => crate :: objects :: office :: FILE_CABINET , "wastebasket" => crate :: objects :: office :: WASTEBASKET , "locked" => crate :: objects :: lock :: LOCKED , "unlocked" => crate :: objects :: lock :: UNLOCKED , "locked with pen" => crate :: objects :: lock :: LOCKED_WITH_PEN , "locked with key" => crate :: objects :: lock :: LOCKED_WITH_KEY , "key" => crate :: objects :: lock :: KEY , "old key" => crate :: objects :: lock :: OLD_KEY , "hammer" => crate :: objects :: tool :: HAMMER , "axe" => crate :: objects :: tool :: AXE , "pick" => crate :: objects :: tool :: PICK , "hammer and pick" => crate :: objects :: tool :: HAMMER_AND_PICK , "hammer and wrench" => crate :: objects :: tool :: HAMMER_AND_WRENCH , "dagger" => crate :: objects :: tool :: DAGGER , "crossed swords" => crate :: objects :: tool :: CROSSED_SWORDS , "water pistol" => crate :: objects :: tool :: WATER_PISTOL , "boomerang" => crate :: objects :: tool :: BOOMERANG , "bow and arrow" => crate :: objects :: tool :: BOW_AND_ARROW , "shield" => crate :: objects :: tool :: SHIELD , "carpentry saw" => crate :: objects :: tool :: CARPENTRY_SAW , "wrench" => crate :: objects :: tool :: WRENCH , "screwdriver" => crate :: objects :: tool :: SCREWDRIVER , "nut and bolt" => crate :: objects :: tool :: NUT_AND_BOLT , "gear" => crate :: objects :: tool :: GEAR , "clamp" => crate :: objects :: tool :: CLAMP , "balance scale" => crate :: objects :: tool :: BALANCE_SCALE , "white cane" => crate :: objects :: tool :: WHITE_CANE , "link" => crate :: objects :: tool :: LINK , "chains" => crate :: objects :: tool :: CHAINS , "hook" => crate :: objects :: tool :: HOOK , "toolbox" => crate :: objects :: tool :: TOOLBOX , "magnet" => crate :: objects :: tool :: MAGNET , "ladder" => crate :: objects :: tool :: LADDER , "alembic" => crate :: objects :: science :: ALEMBIC , "test tube" => crate :: objects :: science :: TEST_TUBE , "petri dish" => crate :: objects :: science :: PETRI_DISH , "dna" => crate :: objects :: science :: DNA , "microscope" => crate :: objects :: science :: MICROSCOPE , "telescope" => crate :: objects :: science :: TELESCOPE , "satellite antenna" => crate :: objects :: science :: SATELLITE_ANTENNA , "syringe" => crate :: objects :: medical :: SYRINGE , "drop of blood" => crate :: objects :: medical :: DROP_OF_BLOOD , "pill" => crate :: objects :: medical :: PILL , "adhesive bandage" => crate :: objects :: medical :: ADHESIVE_BANDAGE , "stethoscope" => crate :: objects :: medical :: STETHOSCOPE , "door" => crate :: objects :: household :: DOOR , "elevator" => crate :: objects :: household :: ELEVATOR , "mirror" => crate :: objects :: household :: MIRROR , "window" => crate :: objects :: household :: WINDOW , "bed" => crate :: objects :: household :: BED , "couch and lamp" => crate :: objects :: household :: COUCH_AND_LAMP , "chair" => crate :: objects :: household :: CHAIR , "toilet" => crate :: objects :: household :: TOILET , "plunger" => crate :: objects :: household :: PLUNGER , "shower" => crate :: objects :: household :: SHOWER , "bathtub" => crate :: objects :: household :: BATHTUB , "mouse trap" => crate :: objects :: household :: MOUSE_TRAP , "razor" => crate :: objects :: household :: RAZOR , "lotion bottle" => crate :: objects :: household :: LOTION_BOTTLE , "safety pin" => crate :: objects :: household :: SAFETY_PIN , "broom" => crate :: objects :: household :: BROOM , "basket" => crate :: objects :: household :: BASKET , "roll of paper" => crate :: objects :: household :: ROLL_OF_PAPER , "bucket" => crate :: objects :: household :: BUCKET , "soap" => crate :: objects :: household :: SOAP , "toothbrush" => crate :: objects :: household :: TOOTHBRUSH , "sponge" => crate :: objects :: household :: SPONGE , "fire extinguisher" => crate :: objects :: household :: FIRE_EXTINGUISHER , "shopping cart" => crate :: objects :: household :: SHOPPING_CART , "cigarette" => crate :: objects :: other_object :: CIGARETTE , "coffin" => crate :: objects :: other_object :: COFFIN , "headstone" => crate :: objects :: other_object :: HEADSTONE , "funeral urn" => crate :: objects :: other_object :: FUNERAL_URN , "moai" => crate :: objects :: other_object :: MOAI , "placard" => crate :: objects :: other_object :: PLACARD , "ATM sign" => crate :: symbols :: transport_sign :: ATM_SIGN , "litter in bin sign" => crate :: symbols :: transport_sign :: LITTER_IN_BIN_SIGN , "potable water" => crate :: symbols :: transport_sign :: POTABLE_WATER , "wheelchair symbol" => crate :: symbols :: transport_sign :: WHEELCHAIR_SYMBOL , "men’s room" => crate :: symbols :: transport_sign :: MENS_ROOM , "women’s room" => crate :: symbols :: transport_sign :: WOMENS_ROOM , "restroom" => crate :: symbols :: transport_sign :: RESTROOM , "baby symbol" => crate :: symbols :: transport_sign :: BABY_SYMBOL , "water closet" => crate :: symbols :: transport_sign :: WATER_CLOSET , "passport control" => crate :: symbols :: transport_sign :: PASSPORT_CONTROL , "customs" => crate :: symbols :: transport_sign :: CUSTOMS , "baggage claim" => crate :: symbols :: transport_sign :: BAGGAGE_CLAIM , "left luggage" => crate :: symbols :: transport_sign :: LEFT_LUGGAGE , "warning" => crate :: symbols :: warning :: WARNING , "children crossing" => crate :: symbols :: warning :: CHILDREN_CROSSING , "no entry" => crate :: symbols :: warning :: NO_ENTRY , "prohibited" => crate :: symbols :: warning :: PROHIBITED , "no bicycles" => crate :: symbols :: warning :: NO_BICYCLES , "no smoking" => crate :: symbols :: warning :: NO_SMOKING , "no littering" => crate :: symbols :: warning :: NO_LITTERING , "non-potable water" => crate :: symbols :: warning :: NON_POTABLE_WATER , "no pedestrians" => crate :: symbols :: warning :: NO_PEDESTRIANS , "no mobile phones" => crate :: symbols :: warning :: NO_MOBILE_PHONES , "no one under eighteen" => crate :: symbols :: warning :: NO_ONE_UNDER_EIGHTEEN , "radioactive" => crate :: symbols :: warning :: RADIOACTIVE , "biohazard" => crate :: symbols :: warning :: BIOHAZARD , "up arrow" => crate :: symbols :: arrow :: UP_ARROW , "up-right arrow" => crate :: symbols :: arrow :: UP_RIGHT_ARROW , "right arrow" => crate :: symbols :: arrow :: RIGHT_ARROW , "down-right arrow" => crate :: symbols :: arrow :: DOWN_RIGHT_ARROW , "down arrow" => crate :: symbols :: arrow :: DOWN_ARROW , "down-left arrow" => crate :: symbols :: arrow :: DOWN_LEFT_ARROW , "left arrow" => crate :: symbols :: arrow :: LEFT_ARROW , "up-left arrow" => crate :: symbols :: arrow :: UP_LEFT_ARROW , "up-down arrow" => crate :: symbols :: arrow :: UP_DOWN_ARROW , "left-right arrow" => crate :: symbols :: arrow :: LEFT_RIGHT_ARROW , "right arrow curving left" => crate :: symbols :: arrow :: RIGHT_ARROW_CURVING_LEFT , "left arrow curving right" => crate :: symbols :: arrow :: LEFT_ARROW_CURVING_RIGHT , "right arrow curving up" => crate :: symbols :: arrow :: RIGHT_ARROW_CURVING_UP , "right arrow curving down" => crate :: symbols :: arrow :: RIGHT_ARROW_CURVING_DOWN , "clockwise vertical arrows" => crate :: symbols :: arrow :: CLOCKWISE_VERTICAL_ARROWS , "counterclockwise arrows button" => crate :: symbols :: arrow :: COUNTERCLOCKWISE_ARROWS_BUTTON , "BACK arrow" => crate :: symbols :: arrow :: BACK_ARROW , "END arrow" => crate :: symbols :: arrow :: END_ARROW , "ON! arrow" => crate :: symbols :: arrow :: ON_ARROW , "SOON arrow" => crate :: symbols :: arrow :: SOON_ARROW , "TOP arrow" => crate :: symbols :: arrow :: TOP_ARROW , "place of worship" => crate :: symbols :: religion :: PLACE_OF_WORSHIP , "atom symbol" => crate :: symbols :: religion :: ATOM_SYMBOL , "om" => crate :: symbols :: religion :: OM , "star of David" => crate :: symbols :: religion :: STAR_OF_DAVID , "wheel of dharma" => crate :: symbols :: religion :: WHEEL_OF_DHARMA , "yin yang" => crate :: symbols :: religion :: YIN_YANG , "latin cross" => crate :: symbols :: religion :: LATIN_CROSS , "orthodox cross" => crate :: symbols :: religion :: ORTHODOX_CROSS , "star and crescent" => crate :: symbols :: religion :: STAR_AND_CRESCENT , "peace symbol" => crate :: symbols :: religion :: PEACE_SYMBOL , "menorah" => crate :: symbols :: religion :: MENORAH , "dotted six-pointed star" => crate :: symbols :: religion :: DOTTED_SIX_POINTED_STAR , "Aries" => crate :: symbols :: zodiac :: ARIES , "Taurus" => crate :: symbols :: zodiac :: TAURUS , "Gemini" => crate :: symbols :: zodiac :: GEMINI , "Cancer" => crate :: symbols :: zodiac :: CANCER , "Leo" => crate :: symbols :: zodiac :: LEO , "Virgo" => crate :: symbols :: zodiac :: VIRGO , "Libra" => crate :: symbols :: zodiac :: LIBRA , "Scorpio" => crate :: symbols :: zodiac :: SCORPIO , "Sagittarius" => crate :: symbols :: zodiac :: SAGITTARIUS , "Capricorn" => crate :: symbols :: zodiac :: CAPRICORN , "Aquarius" => crate :: symbols :: zodiac :: AQUARIUS , "Pisces" => crate :: symbols :: zodiac :: PISCES , "Ophiuchus" => crate :: symbols :: zodiac :: OPHIUCHUS , "shuffle tracks button" => crate :: symbols :: av_symbol :: SHUFFLE_TRACKS_BUTTON , "repeat button" => crate :: symbols :: av_symbol :: REPEAT_BUTTON , "repeat single button" => crate :: symbols :: av_symbol :: REPEAT_SINGLE_BUTTON , "play button" => crate :: symbols :: av_symbol :: PLAY_BUTTON , "fast-forward button" => crate :: symbols :: av_symbol :: FAST_FORWARD_BUTTON , "next track button" => crate :: symbols :: av_symbol :: NEXT_TRACK_BUTTON , "play or pause button" => crate :: symbols :: av_symbol :: PLAY_OR_PAUSE_BUTTON , "reverse button" => crate :: symbols :: av_symbol :: REVERSE_BUTTON , "fast reverse button" => crate :: symbols :: av_symbol :: FAST_REVERSE_BUTTON , "last track button" => crate :: symbols :: av_symbol :: LAST_TRACK_BUTTON , "upwards button" => crate :: symbols :: av_symbol :: UPWARDS_BUTTON , "fast up button" => crate :: symbols :: av_symbol :: FAST_UP_BUTTON , "downwards button" => crate :: symbols :: av_symbol :: DOWNWARDS_BUTTON , "fast down button" => crate :: symbols :: av_symbol :: FAST_DOWN_BUTTON , "pause button" => crate :: symbols :: av_symbol :: PAUSE_BUTTON , "stop button" => crate :: symbols :: av_symbol :: STOP_BUTTON , "record button" => crate :: symbols :: av_symbol :: RECORD_BUTTON , "eject button" => crate :: symbols :: av_symbol :: EJECT_BUTTON , "cinema" => crate :: symbols :: av_symbol :: CINEMA , "dim button" => crate :: symbols :: av_symbol :: DIM_BUTTON , "bright button" => crate :: symbols :: av_symbol :: BRIGHT_BUTTON , "antenna bars" => crate :: symbols :: av_symbol :: ANTENNA_BARS , "vibration mode" => crate :: symbols :: av_symbol :: VIBRATION_MODE , "mobile phone off" => crate :: symbols :: av_symbol :: MOBILE_PHONE_OFF , "female sign" => crate :: symbols :: gender :: FEMALE_SIGN , "male sign" => crate :: symbols :: gender :: MALE_SIGN , "transgender symbol" => crate :: symbols :: gender :: TRANSGENDER_SYMBOL , "multiply" => crate :: symbols :: math :: MULTIPLY , "plus" => crate :: symbols :: math :: PLUS , "minus" => crate :: symbols :: math :: MINUS , "divide" => crate :: symbols :: math :: DIVIDE , "infinity" => crate :: symbols :: math :: INFINITY , "double exclamation mark" => crate :: symbols :: punctuation :: DOUBLE_EXCLAMATION_MARK , "exclamation question mark" => crate :: symbols :: punctuation :: EXCLAMATION_QUESTION_MARK , "red question mark" => crate :: symbols :: punctuation :: RED_QUESTION_MARK , "white question mark" => crate :: symbols :: punctuation :: WHITE_QUESTION_MARK , "white exclamation mark" => crate :: symbols :: punctuation :: WHITE_EXCLAMATION_MARK , "red exclamation mark" => crate :: symbols :: punctuation :: RED_EXCLAMATION_MARK , "wavy dash" => crate :: symbols :: punctuation :: WAVY_DASH , "currency exchange" => crate :: symbols :: currency :: CURRENCY_EXCHANGE , "heavy dollar sign" => crate :: symbols :: currency :: HEAVY_DOLLAR_SIGN , "medical symbol" => crate :: symbols :: other_symbol :: MEDICAL_SYMBOL , "recycling symbol" => crate :: symbols :: other_symbol :: RECYCLING_SYMBOL , "fleur-de-lis" => crate :: symbols :: other_symbol :: FLEUR_DE_LIS , "trident emblem" => crate :: symbols :: other_symbol :: TRIDENT_EMBLEM , "name badge" => crate :: symbols :: other_symbol :: NAME_BADGE , "Japanese symbol for beginner" => crate :: symbols :: other_symbol :: JAPANESE_SYMBOL_FOR_BEGINNER , "hollow red circle" => crate :: symbols :: other_symbol :: HOLLOW_RED_CIRCLE , "check mark button" => crate :: symbols :: other_symbol :: CHECK_MARK_BUTTON , "check box with check" => crate :: symbols :: other_symbol :: CHECK_BOX_WITH_CHECK , "check mark" => crate :: symbols :: other_symbol :: CHECK_MARK , "cross mark" => crate :: symbols :: other_symbol :: CROSS_MARK , "cross mark button" => crate :: symbols :: other_symbol :: CROSS_MARK_BUTTON , "curly loop" => crate :: symbols :: other_symbol :: CURLY_LOOP , "double curly loop" => crate :: symbols :: other_symbol :: DOUBLE_CURLY_LOOP , "part alternation mark" => crate :: symbols :: other_symbol :: PART_ALTERNATION_MARK , "eight-spoked asterisk" => crate :: symbols :: other_symbol :: EIGHT_SPOKED_ASTERISK , "eight-pointed star" => crate :: symbols :: other_symbol :: EIGHT_POINTED_STAR , "sparkle" => crate :: symbols :: other_symbol :: SPARKLE , "copyright" => crate :: symbols :: other_symbol :: COPYRIGHT , "registered" => crate :: symbols :: other_symbol :: REGISTERED , "trade mark" => crate :: symbols :: other_symbol :: TRADE_MARK , "keycap: #" => crate :: symbols :: keycap :: KEYCAP_POUND , "keycap: *" => crate :: symbols :: keycap :: KEYCAP_ASTERISK , "keycap: 0" => crate :: symbols :: keycap :: KEYCAP_0 , "keycap: 1" => crate :: symbols :: keycap :: KEYCAP_1 , "keycap: 2" => crate :: symbols :: keycap :: KEYCAP_2 , "keycap: 3" => crate :: symbols :: keycap :: KEYCAP_3 , "keycap: 4" => crate :: symbols :: keycap :: KEYCAP_4 , "keycap: 5" => crate :: symbols :: keycap :: KEYCAP_5 , "keycap: 6" => crate :: symbols :: keycap :: KEYCAP_6 , "keycap: 7" => crate :: symbols :: keycap :: KEYCAP_7 , "keycap: 8" => crate :: symbols :: keycap :: KEYCAP_8 , "keycap: 9" => crate :: symbols :: keycap :: KEYCAP_9 , "keycap: 10" => crate :: symbols :: keycap :: KEYCAP_10 , "input latin uppercase" => crate :: symbols :: alphanum :: INPUT_LATIN_UPPERCASE , "input latin lowercase" => crate :: symbols :: alphanum :: INPUT_LATIN_LOWERCASE , "input numbers" => crate :: symbols :: alphanum :: INPUT_NUMBERS , "input symbols" => crate :: symbols :: alphanum :: INPUT_SYMBOLS , "input latin letters" => crate :: symbols :: alphanum :: INPUT_LATIN_LETTERS , "A button (blood type)" => crate :: symbols :: alphanum :: A_BUTTON_BLOOD_TYPE , "AB button (blood type)" => crate :: symbols :: alphanum :: AB_BUTTON_BLOOD_TYPE , "B button (blood type)" => crate :: symbols :: alphanum :: B_BUTTON_BLOOD_TYPE , "CL button" => crate :: symbols :: alphanum :: CL_BUTTON , "COOL button" => crate :: symbols :: alphanum :: COOL_BUTTON , "FREE button" => crate :: symbols :: alphanum :: FREE_BUTTON , "information" => crate :: symbols :: alphanum :: INFORMATION , "ID button" => crate :: symbols :: alphanum :: ID_BUTTON , "circled M" => crate :: symbols :: alphanum :: CIRCLED_M , "NEW button" => crate :: symbols :: alphanum :: NEW_BUTTON , "NG button" => crate :: symbols :: alphanum :: NG_BUTTON , "O button (blood type)" => crate :: symbols :: alphanum :: O_BUTTON_BLOOD_TYPE , "OK button" => crate :: symbols :: alphanum :: OK_BUTTON , "P button" => crate :: symbols :: alphanum :: P_BUTTON , "SOS button" => crate :: symbols :: alphanum :: SOS_BUTTON , "UP! button" => crate :: symbols :: alphanum :: UP_BUTTON , "VS button" => crate :: symbols :: alphanum :: VS_BUTTON , "Japanese “here” button" => crate :: symbols :: alphanum :: JAPANESE__HERE__BUTTON , "Japanese “service charge” button" => crate :: symbols :: alphanum :: JAPANESE__SERVICE_CHARGE__BUTTON , "Japanese “monthly amount” button" => crate :: symbols :: alphanum :: JAPANESE__MONTHLY_AMOUNT__BUTTON , "Japanese “not free of charge” button" => crate :: symbols :: alphanum :: JAPANESE__NOT_FREE_OF_CHARGE__BUTTON , "Japanese “reserved” button" => crate :: symbols :: alphanum :: JAPANESE__RESERVED__BUTTON , "Japanese “bargain” button" => crate :: symbols :: alphanum :: JAPANESE__BARGAIN__BUTTON , "Japanese “discount” button" => crate :: symbols :: alphanum :: JAPANESE__DISCOUNT__BUTTON , "Japanese “free of charge” button" => crate :: symbols :: alphanum :: JAPANESE__FREE_OF_CHARGE__BUTTON , "Japanese “prohibited” button" => crate :: symbols :: alphanum :: JAPANESE__PROHIBITED__BUTTON , "Japanese “acceptable” button" => crate :: symbols :: alphanum :: JAPANESE__ACCEPTABLE__BUTTON , "Japanese “application” button" => crate :: symbols :: alphanum :: JAPANESE__APPLICATION__BUTTON , "Japanese “passing grade” button" => crate :: symbols :: alphanum :: JAPANESE__PASSING_GRADE__BUTTON , "Japanese “vacancy” button" => crate :: symbols :: alphanum :: JAPANESE__VACANCY__BUTTON , "Japanese “congratulations” button" => crate :: symbols :: alphanum :: JAPANESE__CONGRATULATIONS__BUTTON , "Japanese “secret” button" => crate :: symbols :: alphanum :: JAPANESE__SECRET__BUTTON , "Japanese “open for business” button" => crate :: symbols :: alphanum :: JAPANESE__OPEN_FOR_BUSINESS__BUTTON , "Japanese “no vacancy” button" => crate :: symbols :: alphanum :: JAPANESE__NO_VACANCY__BUTTON , "red circle" => crate :: symbols :: geometric :: RED_CIRCLE , "orange circle" => crate :: symbols :: geometric :: ORANGE_CIRCLE , "yellow circle" => crate :: symbols :: geometric :: YELLOW_CIRCLE , "green circle" => crate :: symbols :: geometric :: GREEN_CIRCLE , "blue circle" => crate :: symbols :: geometric :: BLUE_CIRCLE , "purple circle" => crate :: symbols :: geometric :: PURPLE_CIRCLE , "brown circle" => crate :: symbols :: geometric :: BROWN_CIRCLE , "black circle" => crate :: symbols :: geometric :: BLACK_CIRCLE , "white circle" => crate :: symbols :: geometric :: WHITE_CIRCLE , "red square" => crate :: symbols :: geometric :: RED_SQUARE , "orange square" => crate :: symbols :: geometric :: ORANGE_SQUARE , "yellow square" => crate :: symbols :: geometric :: YELLOW_SQUARE , "green square" => crate :: symbols :: geometric :: GREEN_SQUARE , "blue square" => crate :: symbols :: geometric :: BLUE_SQUARE , "purple square" => crate :: symbols :: geometric :: PURPLE_SQUARE , "brown square" => crate :: symbols :: geometric :: BROWN_SQUARE , "black large square" => crate :: symbols :: geometric :: BLACK_LARGE_SQUARE , "white large square" => crate :: symbols :: geometric :: WHITE_LARGE_SQUARE , "black medium square" => crate :: symbols :: geometric :: BLACK_MEDIUM_SQUARE , "white medium square" => crate :: symbols :: geometric :: WHITE_MEDIUM_SQUARE , "black medium-small square" => crate :: symbols :: geometric :: BLACK_MEDIUM_SMALL_SQUARE , "white medium-small square" => crate :: symbols :: geometric :: WHITE_MEDIUM_SMALL_SQUARE , "black small square" => crate :: symbols :: geometric :: BLACK_SMALL_SQUARE , "white small square" => crate :: symbols :: geometric :: WHITE_SMALL_SQUARE , "large orange diamond" => crate :: symbols :: geometric :: LARGE_ORANGE_DIAMOND , "large blue diamond" => crate :: symbols :: geometric :: LARGE_BLUE_DIAMOND , "small orange diamond" => crate :: symbols :: geometric :: SMALL_ORANGE_DIAMOND , "small blue diamond" => crate :: symbols :: geometric :: SMALL_BLUE_DIAMOND , "red triangle pointed up" => crate :: symbols :: geometric :: RED_TRIANGLE_POINTED_UP , "red triangle pointed down" => crate :: symbols :: geometric :: RED_TRIANGLE_POINTED_DOWN , "diamond with a dot" => crate :: symbols :: geometric :: DIAMOND_WITH_A_DOT , "radio button" => crate :: symbols :: geometric :: RADIO_BUTTON , "white square button" => crate :: symbols :: geometric :: WHITE_SQUARE_BUTTON , "black square button" => crate :: symbols :: geometric :: BLACK_SQUARE_BUTTON , "chequered flag" => crate :: flags :: flag :: CHEQUERED_FLAG , "triangular flag" => crate :: flags :: flag :: TRIANGULAR_FLAG , "crossed flags" => crate :: flags :: flag :: CROSSED_FLAGS , "black flag" => crate :: flags :: flag :: BLACK_FLAG , "white flag" => crate :: flags :: flag :: WHITE_FLAG , "rainbow flag" => crate :: flags :: flag :: RAINBOW_FLAG , "transgender flag" => crate :: flags :: flag :: TRANSGENDER_FLAG , "pirate flag" => crate :: flags :: flag :: PIRATE_FLAG , "flag: Ascension Island" => crate :: flags :: country_flag :: FLAG_ASCENSION_ISLAND , "flag: Andorra" => crate :: flags :: country_flag :: FLAG_ANDORRA , "flag: United Arab Emirates" => crate :: flags :: country_flag :: FLAG_UNITED_ARAB_EMIRATES , "flag: Afghanistan" => crate :: flags :: country_flag :: FLAG_AFGHANISTAN , "flag: Antigua & Barbuda" => crate :: flags :: country_flag :: FLAG_ANTIGUA_AND_BARBUDA , "flag: Anguilla" => crate :: flags :: country_flag :: FLAG_ANGUILLA , "flag: Albania" => crate :: flags :: country_flag :: FLAG_ALBANIA , "flag: Armenia" => crate :: flags :: country_flag :: FLAG_ARMENIA , "flag: Angola" => crate :: flags :: country_flag :: FLAG_ANGOLA , "flag: Antarctica" => crate :: flags :: country_flag :: FLAG_ANTARCTICA , "flag: Argentina" => crate :: flags :: country_flag :: FLAG_ARGENTINA , "flag: American Samoa" => crate :: flags :: country_flag :: FLAG_AMERICAN_SAMOA , "flag: Austria" => crate :: flags :: country_flag :: FLAG_AUSTRIA , "flag: Australia" => crate :: flags :: country_flag :: FLAG_AUSTRALIA , "flag: Aruba" => crate :: flags :: country_flag :: FLAG_ARUBA , "flag: Åland Islands" => crate :: flags :: country_flag :: FLAG_ALAND_ISLANDS , "flag: Azerbaijan" => crate :: flags :: country_flag :: FLAG_AZERBAIJAN , "flag: Bosnia & Herzegovina" => crate :: flags :: country_flag :: FLAG_BOSNIA_AND_HERZEGOVINA , "flag: Barbados" => crate :: flags :: country_flag :: FLAG_BARBADOS , "flag: Bangladesh" => crate :: flags :: country_flag :: FLAG_BANGLADESH , "flag: Belgium" => crate :: flags :: country_flag :: FLAG_BELGIUM , "flag: Burkina Faso" => crate :: flags :: country_flag :: FLAG_BURKINA_FASO , "flag: Bulgaria" => crate :: flags :: country_flag :: FLAG_BULGARIA , "flag: Bahrain" => crate :: flags :: country_flag :: FLAG_BAHRAIN , "flag: Burundi" => crate :: flags :: country_flag :: FLAG_BURUNDI , "flag: Benin" => crate :: flags :: country_flag :: FLAG_BENIN , "flag: St. Barthélemy" => crate :: flags :: country_flag :: FLAG_ST_BARTHELEMY , "flag: Bermuda" => crate :: flags :: country_flag :: FLAG_BERMUDA , "flag: Brunei" => crate :: flags :: country_flag :: FLAG_BRUNEI , "flag: Bolivia" => crate :: flags :: country_flag :: FLAG_BOLIVIA , "flag: Caribbean Netherlands" => crate :: flags :: country_flag :: FLAG_CARIBBEAN_NETHERLANDS , "flag: Brazil" => crate :: flags :: country_flag :: FLAG_BRAZIL , "flag: Bahamas" => crate :: flags :: country_flag :: FLAG_BAHAMAS , "flag: Bhutan" => crate :: flags :: country_flag :: FLAG_BHUTAN , "flag: Bouvet Island" => crate :: flags :: country_flag :: FLAG_BOUVET_ISLAND , "flag: Botswana" => crate :: flags :: country_flag :: FLAG_BOTSWANA , "flag: Belarus" => crate :: flags :: country_flag :: FLAG_BELARUS , "flag: Belize" => crate :: flags :: country_flag :: FLAG_BELIZE , "flag: Canada" => crate :: flags :: country_flag :: FLAG_CANADA , "flag: Cocos (Keeling) Islands" => crate :: flags :: country_flag :: FLAG_COCOS_KEELING_ISLANDS , "flag: Congo - Kinshasa" => crate :: flags :: country_flag :: FLAG_CONGO___KINSHASA , "flag: Central African Republic" => crate :: flags :: country_flag :: FLAG_CENTRAL_AFRICAN_REPUBLIC , "flag: Congo - Brazzaville" => crate :: flags :: country_flag :: FLAG_CONGO___BRAZZAVILLE , "flag: Switzerland" => crate :: flags :: country_flag :: FLAG_SWITZERLAND , "flag: Côte d’Ivoire" => crate :: flags :: country_flag :: FLAG_COTE_DIVOIRE , "flag: Cook Islands" => crate :: flags :: country_flag :: FLAG_COOK_ISLANDS , "flag: Chile" => crate :: flags :: country_flag :: FLAG_CHILE , "flag: Cameroon" => crate :: flags :: country_flag :: FLAG_CAMEROON , "flag: China" => crate :: flags :: country_flag :: FLAG_CHINA , "flag: Colombia" => crate :: flags :: country_flag :: FLAG_COLOMBIA , "flag: Clipperton Island" => crate :: flags :: country_flag :: FLAG_CLIPPERTON_ISLAND , "flag: Costa Rica" => crate :: flags :: country_flag :: FLAG_COSTA_RICA , "flag: Cuba" => crate :: flags :: country_flag :: FLAG_CUBA , "flag: Cape Verde" => crate :: flags :: country_flag :: FLAG_CAPE_VERDE , "flag: Curaçao" => crate :: flags :: country_flag :: FLAG_CURACAO , "flag: Christmas Island" => crate :: flags :: country_flag :: FLAG_CHRISTMAS_ISLAND , "flag: Cyprus" => crate :: flags :: country_flag :: FLAG_CYPRUS , "flag: Czechia" => crate :: flags :: country_flag :: FLAG_CZECHIA , "flag: Germany" => crate :: flags :: country_flag :: FLAG_GERMANY , "flag: Diego Garcia" => crate :: flags :: country_flag :: FLAG_DIEGO_GARCIA , "flag: Djibouti" => crate :: flags :: country_flag :: FLAG_DJIBOUTI , "flag: Denmark" => crate :: flags :: country_flag :: FLAG_DENMARK , "flag: Dominica" => crate :: flags :: country_flag :: FLAG_DOMINICA , "flag: Dominican Republic" => crate :: flags :: country_flag :: FLAG_DOMINICAN_REPUBLIC , "flag: Algeria" => crate :: flags :: country_flag :: FLAG_ALGERIA , "flag: Ceuta & Melilla" => crate :: flags :: country_flag :: FLAG_CEUTA_AND_MELILLA , "flag: Ecuador" => crate :: flags :: country_flag :: FLAG_ECUADOR , "flag: Estonia" => crate :: flags :: country_flag :: FLAG_ESTONIA , "flag: Egypt" => crate :: flags :: country_flag :: FLAG_EGYPT , "flag: Western Sahara" => crate :: flags :: country_flag :: FLAG_WESTERN_SAHARA , "flag: Eritrea" => crate :: flags :: country_flag :: FLAG_ERITREA , "flag: Spain" => crate :: flags :: country_flag :: FLAG_SPAIN , "flag: Ethiopia" => crate :: flags :: country_flag :: FLAG_ETHIOPIA , "flag: European Union" => crate :: flags :: country_flag :: FLAG_EUROPEAN_UNION , "flag: Finland" => crate :: flags :: country_flag :: FLAG_FINLAND , "flag: Fiji" => crate :: flags :: country_flag :: FLAG_FIJI , "flag: Falkland Islands" => crate :: flags :: country_flag :: FLAG_FALKLAND_ISLANDS , "flag: Micronesia" => crate :: flags :: country_flag :: FLAG_MICRONESIA , "flag: Faroe Islands" => crate :: flags :: country_flag :: FLAG_FAROE_ISLANDS , "flag: France" => crate :: flags :: country_flag :: FLAG_FRANCE , "flag: Gabon" => crate :: flags :: country_flag :: FLAG_GABON , "flag: United Kingdom" => crate :: flags :: country_flag :: FLAG_UNITED_KINGDOM , "flag: Grenada" => crate :: flags :: country_flag :: FLAG_GRENADA , "flag: Georgia" => crate :: flags :: country_flag :: FLAG_GEORGIA , "flag: French Guiana" => crate :: flags :: country_flag :: FLAG_FRENCH_GUIANA , "flag: Guernsey" => crate :: flags :: country_flag :: FLAG_GUERNSEY , "flag: Ghana" => crate :: flags :: country_flag :: FLAG_GHANA , "flag: Gibraltar" => crate :: flags :: country_flag :: FLAG_GIBRALTAR , "flag: Greenland" => crate :: flags :: country_flag :: FLAG_GREENLAND , "flag: Gambia" => crate :: flags :: country_flag :: FLAG_GAMBIA , "flag: Guinea" => crate :: flags :: country_flag :: FLAG_GUINEA , "flag: Guadeloupe" => crate :: flags :: country_flag :: FLAG_GUADELOUPE , "flag: Equatorial Guinea" => crate :: flags :: country_flag :: FLAG_EQUATORIAL_GUINEA , "flag: Greece" => crate :: flags :: country_flag :: FLAG_GREECE , "flag: South Georgia & South Sandwich Islands" => crate :: flags :: country_flag :: FLAG_SOUTH_GEORGIA_AND_SOUTH_SANDWICH_ISLANDS , "flag: Guatemala" => crate :: flags :: country_flag :: FLAG_GUATEMALA , "flag: Guam" => crate :: flags :: country_flag :: FLAG_GUAM , "flag: Guinea-Bissau" => crate :: flags :: country_flag :: FLAG_GUINEA_BISSAU , "flag: Guyana" => crate :: flags :: country_flag :: FLAG_GUYANA , "flag: Hong Kong SAR China" => crate :: flags :: country_flag :: FLAG_HONG_KONG_SAR_CHINA , "flag: Heard & McDonald Islands" => crate :: flags :: country_flag :: FLAG_HEARD_AND_MCDONALD_ISLANDS , "flag: Honduras" => crate :: flags :: country_flag :: FLAG_HONDURAS , "flag: Croatia" => crate :: flags :: country_flag :: FLAG_CROATIA , "flag: Haiti" => crate :: flags :: country_flag :: FLAG_HAITI , "flag: Hungary" => crate :: flags :: country_flag :: FLAG_HUNGARY , "flag: Canary Islands" => crate :: flags :: country_flag :: FLAG_CANARY_ISLANDS , "flag: Indonesia" => crate :: flags :: country_flag :: FLAG_INDONESIA , "flag: Ireland" => crate :: flags :: country_flag :: FLAG_IRELAND , "flag: Israel" => crate :: flags :: country_flag :: FLAG_ISRAEL , "flag: Isle of Man" => crate :: flags :: country_flag :: FLAG_ISLE_OF_MAN , "flag: India" => crate :: flags :: country_flag :: FLAG_INDIA , "flag: British Indian Ocean Territory" => crate :: flags :: country_flag :: FLAG_BRITISH_INDIAN_OCEAN_TERRITORY , "flag: Iraq" => crate :: flags :: country_flag :: FLAG_IRAQ , "flag: Iran" => crate :: flags :: country_flag :: FLAG_IRAN , "flag: Iceland" => crate :: flags :: country_flag :: FLAG_ICELAND , "flag: Italy" => crate :: flags :: country_flag :: FLAG_ITALY , "flag: Jersey" => crate :: flags :: country_flag :: FLAG_JERSEY , "flag: Jamaica" => crate :: flags :: country_flag :: FLAG_JAMAICA , "flag: Jordan" => crate :: flags :: country_flag :: FLAG_JORDAN , "flag: Japan" => crate :: flags :: country_flag :: FLAG_JAPAN , "flag: Kenya" => crate :: flags :: country_flag :: FLAG_KENYA , "flag: Kyrgyzstan" => crate :: flags :: country_flag :: FLAG_KYRGYZSTAN , "flag: Cambodia" => crate :: flags :: country_flag :: FLAG_CAMBODIA , "flag: Kiribati" => crate :: flags :: country_flag :: FLAG_KIRIBATI , "flag: Comoros" => crate :: flags :: country_flag :: FLAG_COMOROS , "flag: St. Kitts & Nevis" => crate :: flags :: country_flag :: FLAG_ST_KITTS_AND_NEVIS , "flag: North Korea" => crate :: flags :: country_flag :: FLAG_NORTH_KOREA , "flag: South Korea" => crate :: flags :: country_flag :: FLAG_SOUTH_KOREA , "flag: Kuwait" => crate :: flags :: country_flag :: FLAG_KUWAIT , "flag: Cayman Islands" => crate :: flags :: country_flag :: FLAG_CAYMAN_ISLANDS , "flag: Kazakhstan" => crate :: flags :: country_flag :: FLAG_KAZAKHSTAN , "flag: Laos" => crate :: flags :: country_flag :: FLAG_LAOS , "flag: Lebanon" => crate :: flags :: country_flag :: FLAG_LEBANON , "flag: St. Lucia" => crate :: flags :: country_flag :: FLAG_ST_LUCIA , "flag: Liechtenstein" => crate :: flags :: country_flag :: FLAG_LIECHTENSTEIN , "flag: Sri Lanka" => crate :: flags :: country_flag :: FLAG_SRI_LANKA , "flag: Liberia" => crate :: flags :: country_flag :: FLAG_LIBERIA , "flag: Lesotho" => crate :: flags :: country_flag :: FLAG_LESOTHO , "flag: Lithuania" => crate :: flags :: country_flag :: FLAG_LITHUANIA , "flag: Luxembourg" => crate :: flags :: country_flag :: FLAG_LUXEMBOURG , "flag: Latvia" => crate :: flags :: country_flag :: FLAG_LATVIA , "flag: Libya" => crate :: flags :: country_flag :: FLAG_LIBYA , "flag: Morocco" => crate :: flags :: country_flag :: FLAG_MOROCCO , "flag: Monaco" => crate :: flags :: country_flag :: FLAG_MONACO , "flag: Moldova" => crate :: flags :: country_flag :: FLAG_MOLDOVA , "flag: Montenegro" => crate :: flags :: country_flag :: FLAG_MONTENEGRO , "flag: St. Martin" => crate :: flags :: country_flag :: FLAG_ST_MARTIN , "flag: Madagascar" => crate :: flags :: country_flag :: FLAG_MADAGASCAR , "flag: Marshall Islands" => crate :: flags :: country_flag :: FLAG_MARSHALL_ISLANDS , "flag: North Macedonia" => crate :: flags :: country_flag :: FLAG_NORTH_MACEDONIA , "flag: Mali" => crate :: flags :: country_flag :: FLAG_MALI , "flag: Myanmar (Burma)" => crate :: flags :: country_flag :: FLAG_MYANMAR_BURMA , "flag: Mongolia" => crate :: flags :: country_flag :: FLAG_MONGOLIA , "flag: Macao SAR China" => crate :: flags :: country_flag :: FLAG_MACAO_SAR_CHINA , "flag: Northern Mariana Islands" => crate :: flags :: country_flag :: FLAG_NORTHERN_MARIANA_ISLANDS , "flag: Martinique" => crate :: flags :: country_flag :: FLAG_MARTINIQUE , "flag: Mauritania" => crate :: flags :: country_flag :: FLAG_MAURITANIA , "flag: Montserrat" => crate :: flags :: country_flag :: FLAG_MONTSERRAT , "flag: Malta" => crate :: flags :: country_flag :: FLAG_MALTA , "flag: Mauritius" => crate :: flags :: country_flag :: FLAG_MAURITIUS , "flag: Maldives" => crate :: flags :: country_flag :: FLAG_MALDIVES , "flag: Malawi" => crate :: flags :: country_flag :: FLAG_MALAWI , "flag: Mexico" => crate :: flags :: country_flag :: FLAG_MEXICO , "flag: Malaysia" => crate :: flags :: country_flag :: FLAG_MALAYSIA , "flag: Mozambique" => crate :: flags :: country_flag :: FLAG_MOZAMBIQUE , "flag: Namibia" => crate :: flags :: country_flag :: FLAG_NAMIBIA , "flag: New Caledonia" => crate :: flags :: country_flag :: FLAG_NEW_CALEDONIA , "flag: Niger" => crate :: flags :: country_flag :: FLAG_NIGER , "flag: Norfolk Island" => crate :: flags :: country_flag :: FLAG_NORFOLK_ISLAND , "flag: Nigeria" => crate :: flags :: country_flag :: FLAG_NIGERIA , "flag: Nicaragua" => crate :: flags :: country_flag :: FLAG_NICARAGUA , "flag: Netherlands" => crate :: flags :: country_flag :: FLAG_NETHERLANDS , "flag: Norway" => crate :: flags :: country_flag :: FLAG_NORWAY , "flag: Nepal" => crate :: flags :: country_flag :: FLAG_NEPAL , "flag: Nauru" => crate :: flags :: country_flag :: FLAG_NAURU , "flag: Niue" => crate :: flags :: country_flag :: FLAG_NIUE , "flag: New Zealand" => crate :: flags :: country_flag :: FLAG_NEW_ZEALAND , "flag: Oman" => crate :: flags :: country_flag :: FLAG_OMAN , "flag: Panama" => crate :: flags :: country_flag :: FLAG_PANAMA , "flag: Peru" => crate :: flags :: country_flag :: FLAG_PERU , "flag: French Polynesia" => crate :: flags :: country_flag :: FLAG_FRENCH_POLYNESIA , "flag: Papua New Guinea" => crate :: flags :: country_flag :: FLAG_PAPUA_NEW_GUINEA , "flag: Philippines" => crate :: flags :: country_flag :: FLAG_PHILIPPINES , "flag: Pakistan" => crate :: flags :: country_flag :: FLAG_PAKISTAN , "flag: Poland" => crate :: flags :: country_flag :: FLAG_POLAND , "flag: St. Pierre & Miquelon" => crate :: flags :: country_flag :: FLAG_ST_PIERRE_AND_MIQUELON , "flag: Pitcairn Islands" => crate :: flags :: country_flag :: FLAG_PITCAIRN_ISLANDS , "flag: Puerto Rico" => crate :: flags :: country_flag :: FLAG_PUERTO_RICO , "flag: Palestinian Territories" => crate :: flags :: country_flag :: FLAG_PALESTINIAN_TERRITORIES , "flag: Portugal" => crate :: flags :: country_flag :: FLAG_PORTUGAL , "flag: Palau" => crate :: flags :: country_flag :: FLAG_PALAU , "flag: Paraguay" => crate :: flags :: country_flag :: FLAG_PARAGUAY , "flag: Qatar" => crate :: flags :: country_flag :: FLAG_QATAR , "flag: Réunion" => crate :: flags :: country_flag :: FLAG_REUNION , "flag: Romania" => crate :: flags :: country_flag :: FLAG_ROMANIA , "flag: Serbia" => crate :: flags :: country_flag :: FLAG_SERBIA , "flag: Russia" => crate :: flags :: country_flag :: FLAG_RUSSIA , "flag: Rwanda" => crate :: flags :: country_flag :: FLAG_RWANDA , "flag: Saudi Arabia" => crate :: flags :: country_flag :: FLAG_SAUDI_ARABIA , "flag: Solomon Islands" => crate :: flags :: country_flag :: FLAG_SOLOMON_ISLANDS , "flag: Seychelles" => crate :: flags :: country_flag :: FLAG_SEYCHELLES , "flag: Sudan" => crate :: flags :: country_flag :: FLAG_SUDAN , "flag: Sweden" => crate :: flags :: country_flag :: FLAG_SWEDEN , "flag: Singapore" => crate :: flags :: country_flag :: FLAG_SINGAPORE , "flag: St. Helena" => crate :: flags :: country_flag :: FLAG_ST_HELENA , "flag: Slovenia" => crate :: flags :: country_flag :: FLAG_SLOVENIA , "flag: Svalbard & Jan Mayen" => crate :: flags :: country_flag :: FLAG_SVALBARD_AND_JAN_MAYEN , "flag: Slovakia" => crate :: flags :: country_flag :: FLAG_SLOVAKIA , "flag: Sierra Leone" => crate :: flags :: country_flag :: FLAG_SIERRA_LEONE , "flag: San Marino" => crate :: flags :: country_flag :: FLAG_SAN_MARINO , "flag: Senegal" => crate :: flags :: country_flag :: FLAG_SENEGAL , "flag: Somalia" => crate :: flags :: country_flag :: FLAG_SOMALIA , "flag: Suriname" => crate :: flags :: country_flag :: FLAG_SURINAME , "flag: South Sudan" => crate :: flags :: country_flag :: FLAG_SOUTH_SUDAN , "flag: São Tomé & Príncipe" => crate :: flags :: country_flag :: FLAG_SAO_TOME_AND_PRINCIPE , "flag: El Salvador" => crate :: flags :: country_flag :: FLAG_EL_SALVADOR , "flag: Sint Maarten" => crate :: flags :: country_flag :: FLAG_SINT_MAARTEN , "flag: Syria" => crate :: flags :: country_flag :: FLAG_SYRIA , "flag: Eswatini" => crate :: flags :: country_flag :: FLAG_ESWATINI , "flag: Tristan da Cunha" => crate :: flags :: country_flag :: FLAG_TRISTAN_DA_CUNHA , "flag: Turks & Caicos Islands" => crate :: flags :: country_flag :: FLAG_TURKS_AND_CAICOS_ISLANDS , "flag: Chad" => crate :: flags :: country_flag :: FLAG_CHAD , "flag: French Southern Territories" => crate :: flags :: country_flag :: FLAG_FRENCH_SOUTHERN_TERRITORIES , "flag: Togo" => crate :: flags :: country_flag :: FLAG_TOGO , "flag: Thailand" => crate :: flags :: country_flag :: FLAG_THAILAND , "flag: Tajikistan" => crate :: flags :: country_flag :: FLAG_TAJIKISTAN , "flag: Tokelau" => crate :: flags :: country_flag :: FLAG_TOKELAU , "flag: Timor-Leste" => crate :: flags :: country_flag :: FLAG_TIMOR_LESTE , "flag: Turkmenistan" => crate :: flags :: country_flag :: FLAG_TURKMENISTAN , "flag: Tunisia" => crate :: flags :: country_flag :: FLAG_TUNISIA , "flag: Tonga" => crate :: flags :: country_flag :: FLAG_TONGA , "flag: Turkey" => crate :: flags :: country_flag :: FLAG_TURKEY , "flag: Trinidad & Tobago" => crate :: flags :: country_flag :: FLAG_TRINIDAD_AND_TOBAGO , "flag: Tuvalu" => crate :: flags :: country_flag :: FLAG_TUVALU , "flag: Taiwan" => crate :: flags :: country_flag :: FLAG_TAIWAN , "flag: Tanzania" => crate :: flags :: country_flag :: FLAG_TANZANIA , "flag: Ukraine" => crate :: flags :: country_flag :: FLAG_UKRAINE , "flag: Uganda" => crate :: flags :: country_flag :: FLAG_UGANDA , "flag: U.S. Outlying Islands" => crate :: flags :: country_flag :: FLAG_US_OUTLYING_ISLANDS , "flag: United Nations" => crate :: flags :: country_flag :: FLAG_UNITED_NATIONS , "flag: United States" => crate :: flags :: country_flag :: FLAG_UNITED_STATES , "flag: Uruguay" => crate :: flags :: country_flag :: FLAG_URUGUAY , "flag: Uzbekistan" => crate :: flags :: country_flag :: FLAG_UZBEKISTAN , "flag: Vatican City" => crate :: flags :: country_flag :: FLAG_VATICAN_CITY , "flag: St. Vincent & Grenadines" => crate :: flags :: country_flag :: FLAG_ST_VINCENT_AND_GRENADINES , "flag: Venezuela" => crate :: flags :: country_flag :: FLAG_VENEZUELA , "flag: British Virgin Islands" => crate :: flags :: country_flag :: FLAG_BRITISH_VIRGIN_ISLANDS , "flag: U.S. Virgin Islands" => crate :: flags :: country_flag :: FLAG_US_VIRGIN_ISLANDS , "flag: Vietnam" => crate :: flags :: country_flag :: FLAG_VIETNAM , "flag: Vanuatu" => crate :: flags :: country_flag :: FLAG_VANUATU , "flag: Wallis & Futuna" => crate :: flags :: country_flag :: FLAG_WALLIS_AND_FUTUNA , "flag: Samoa" => crate :: flags :: country_flag :: FLAG_SAMOA , "flag: Kosovo" => crate :: flags :: country_flag :: FLAG_KOSOVO , "flag: Yemen" => crate :: flags :: country_flag :: FLAG_YEMEN , "flag: Mayotte" => crate :: flags :: country_flag :: FLAG_MAYOTTE , "flag: South Africa" => crate :: flags :: country_flag :: FLAG_SOUTH_AFRICA , "flag: Zambia" => crate :: flags :: country_flag :: FLAG_ZAMBIA , "flag: Zimbabwe" => crate :: flags :: country_flag :: FLAG_ZIMBABWE , "flag: England" => crate :: flags :: subdivision_flag :: FLAG_ENGLAND , "flag: Scotland" => crate :: flags :: subdivision_flag :: FLAG_SCOTLAND , "flag: Wales" => crate :: flags :: subdivision_flag :: FLAG_WALES };
