#[doc = " Total number of glyphs available for lookup"]
pub fn num_glyphs() -> usize {
    GLYPH_LOOKUP_MAP.len()
}
#[doc = " Is the glyph provided documented in this crate?"]
pub fn contains_glyph(glyph: &str) -> bool {
    GLYPH_LOOKUP_MAP.contains_key(glyph)
}
#[doc = " Get the [Emoji](../struct.Emoji.html) associated with this glyph"]
pub fn lookup(glyph: &str) -> Option<&'static crate::Emoji> {
    GLYPH_LOOKUP_MAP.get(glyph)
}
#[doc = " An iterator over every glyph->[Emoji](../struct.Emoji.html) pair  "]
#[doc = " Includes variants"]
pub fn iter_glyph_emoji() -> phf::map::Entries<'static, &'static str, crate::Emoji> {
    GLYPH_LOOKUP_MAP.entries()
}
#[doc = " An iterator over every glyph"]
pub fn iter_glyph() -> phf::map::Keys<'static, &'static str, crate::Emoji> {
    GLYPH_LOOKUP_MAP.keys()
}
#[doc = " An iterator over every [Emoji](../struct.Emoji.html)  "]
#[doc = " Includes variants"]
pub fn iter_emoji() -> phf::map::Values<'static, &'static str, crate::Emoji> {
    GLYPH_LOOKUP_MAP.values()
}
static GLYPH_LOOKUP_MAP: phf::Map<&'static str, crate::Emoji> = phf::phf_map! { "😀" => crate :: smileys_and_emotion :: face_smiling :: GRINNING_FACE , "😃" => crate :: smileys_and_emotion :: face_smiling :: GRINNING_FACE_WITH_BIG_EYES , "😄" => crate :: smileys_and_emotion :: face_smiling :: GRINNING_FACE_WITH_SMILING_EYES , "😁" => crate :: smileys_and_emotion :: face_smiling :: BEAMING_FACE_WITH_SMILING_EYES , "😆" => crate :: smileys_and_emotion :: face_smiling :: GRINNING_SQUINTING_FACE , "😅" => crate :: smileys_and_emotion :: face_smiling :: GRINNING_FACE_WITH_SWEAT , "🤣" => crate :: smileys_and_emotion :: face_smiling :: ROLLING_ON_THE_FLOOR_LAUGHING , "😂" => crate :: smileys_and_emotion :: face_smiling :: FACE_WITH_TEARS_OF_JOY , "🙂" => crate :: smileys_and_emotion :: face_smiling :: SLIGHTLY_SMILING_FACE , "🙃" => crate :: smileys_and_emotion :: face_smiling :: UPSIDE_DOWN_FACE , "😉" => crate :: smileys_and_emotion :: face_smiling :: WINKING_FACE , "😊" => crate :: smileys_and_emotion :: face_smiling :: SMILING_FACE_WITH_SMILING_EYES , "😇" => crate :: smileys_and_emotion :: face_smiling :: SMILING_FACE_WITH_HALO , "🥰" => crate :: smileys_and_emotion :: face_affection :: SMILING_FACE_WITH_HEARTS , "😍" => crate :: smileys_and_emotion :: face_affection :: SMILING_FACE_WITH_HEART_EYES , "🤩" => crate :: smileys_and_emotion :: face_affection :: STAR_STRUCK , "😘" => crate :: smileys_and_emotion :: face_affection :: FACE_BLOWING_A_KISS , "😗" => crate :: smileys_and_emotion :: face_affection :: KISSING_FACE , "☺\u{fe0f}" => crate :: smileys_and_emotion :: face_affection :: SMILING_FACE , "☺" => crate :: smileys_and_emotion :: face_affection :: SMILING_FACE , "😚" => crate :: smileys_and_emotion :: face_affection :: KISSING_FACE_WITH_CLOSED_EYES , "😙" => crate :: smileys_and_emotion :: face_affection :: KISSING_FACE_WITH_SMILING_EYES , "🥲" => crate :: smileys_and_emotion :: face_affection :: SMILING_FACE_WITH_TEAR , "😋" => crate :: smileys_and_emotion :: face_tongue :: FACE_SAVORING_FOOD , "😛" => crate :: smileys_and_emotion :: face_tongue :: FACE_WITH_TONGUE , "😜" => crate :: smileys_and_emotion :: face_tongue :: WINKING_FACE_WITH_TONGUE , "🤪" => crate :: smileys_and_emotion :: face_tongue :: ZANY_FACE , "😝" => crate :: smileys_and_emotion :: face_tongue :: SQUINTING_FACE_WITH_TONGUE , "🤑" => crate :: smileys_and_emotion :: face_tongue :: MONEY_MOUTH_FACE , "🤗" => crate :: smileys_and_emotion :: face_hand :: HUGGING_FACE , "🤭" => crate :: smileys_and_emotion :: face_hand :: FACE_WITH_HAND_OVER_MOUTH , "🤫" => crate :: smileys_and_emotion :: face_hand :: SHUSHING_FACE , "🤔" => crate :: smileys_and_emotion :: face_hand :: THINKING_FACE , "🤐" => crate :: smileys_and_emotion :: face_neutral_skeptical :: ZIPPER_MOUTH_FACE , "🤨" => crate :: smileys_and_emotion :: face_neutral_skeptical :: FACE_WITH_RAISED_EYEBROW , "😐" => crate :: smileys_and_emotion :: face_neutral_skeptical :: NEUTRAL_FACE , "😑" => crate :: smileys_and_emotion :: face_neutral_skeptical :: EXPRESSIONLESS_FACE , "😶" => crate :: smileys_and_emotion :: face_neutral_skeptical :: FACE_WITHOUT_MOUTH , "😶\u{200d}🌫\u{fe0f}" => crate :: smileys_and_emotion :: face_neutral_skeptical :: FACE_IN_CLOUDS , "😶\u{200d}🌫" => crate :: smileys_and_emotion :: face_neutral_skeptical :: FACE_IN_CLOUDS , "😏" => crate :: smileys_and_emotion :: face_neutral_skeptical :: SMIRKING_FACE , "😒" => crate :: smileys_and_emotion :: face_neutral_skeptical :: UNAMUSED_FACE , "🙄" => crate :: smileys_and_emotion :: face_neutral_skeptical :: FACE_WITH_ROLLING_EYES , "😬" => crate :: smileys_and_emotion :: face_neutral_skeptical :: GRIMACING_FACE , "😮\u{200d}💨" => crate :: smileys_and_emotion :: face_neutral_skeptical :: FACE_EXHALING , "🤥" => crate :: smileys_and_emotion :: face_neutral_skeptical :: LYING_FACE , "😌" => crate :: smileys_and_emotion :: face_sleepy :: RELIEVED_FACE , "😔" => crate :: smileys_and_emotion :: face_sleepy :: PENSIVE_FACE , "😪" => crate :: smileys_and_emotion :: face_sleepy :: SLEEPY_FACE , "🤤" => crate :: smileys_and_emotion :: face_sleepy :: DROOLING_FACE , "😴" => crate :: smileys_and_emotion :: face_sleepy :: SLEEPING_FACE , "😷" => crate :: smileys_and_emotion :: face_unwell :: FACE_WITH_MEDICAL_MASK , "🤒" => crate :: smileys_and_emotion :: face_unwell :: FACE_WITH_THERMOMETER , "🤕" => crate :: smileys_and_emotion :: face_unwell :: FACE_WITH_HEAD_BANDAGE , "🤢" => crate :: smileys_and_emotion :: face_unwell :: NAUSEATED_FACE , "🤮" => crate :: smileys_and_emotion :: face_unwell :: FACE_VOMITING , "🤧" => crate :: smileys_and_emotion :: face_unwell :: SNEEZING_FACE , "🥵" => crate :: smileys_and_emotion :: face_unwell :: HOT_FACE , "🥶" => crate :: smileys_and_emotion :: face_unwell :: COLD_FACE , "🥴" => crate :: smileys_and_emotion :: face_unwell :: WOOZY_FACE , "😵" => crate :: smileys_and_emotion :: face_unwell :: KNOCKED_OUT_FACE , "😵\u{200d}💫" => crate :: smileys_and_emotion :: face_unwell :: FACE_WITH_SPIRAL_EYES , "🤯" => crate :: smileys_and_emotion :: face_unwell :: EXPLODING_HEAD , "🤠" => crate :: smileys_and_emotion :: face_hat :: COWBOY_HAT_FACE , "🥳" => crate :: smileys_and_emotion :: face_hat :: PARTYING_FACE , "🥸" => crate :: smileys_and_emotion :: face_hat :: DISGUISED_FACE , "😎" => crate :: smileys_and_emotion :: face_glasses :: SMILING_FACE_WITH_SUNGLASSES , "🤓" => crate :: smileys_and_emotion :: face_glasses :: NERD_FACE , "🧐" => crate :: smileys_and_emotion :: face_glasses :: FACE_WITH_MONOCLE , "😕" => crate :: smileys_and_emotion :: face_concerned :: CONFUSED_FACE , "😟" => crate :: smileys_and_emotion :: face_concerned :: WORRIED_FACE , "🙁" => crate :: smileys_and_emotion :: face_concerned :: SLIGHTLY_FROWNING_FACE , "☹\u{fe0f}" => crate :: smileys_and_emotion :: face_concerned :: FROWNING_FACE , "☹" => crate :: smileys_and_emotion :: face_concerned :: FROWNING_FACE , "😮" => crate :: smileys_and_emotion :: face_concerned :: FACE_WITH_OPEN_MOUTH , "😯" => crate :: smileys_and_emotion :: face_concerned :: HUSHED_FACE , "😲" => crate :: smileys_and_emotion :: face_concerned :: ASTONISHED_FACE , "😳" => crate :: smileys_and_emotion :: face_concerned :: FLUSHED_FACE , "🥺" => crate :: smileys_and_emotion :: face_concerned :: PLEADING_FACE , "😦" => crate :: smileys_and_emotion :: face_concerned :: FROWNING_FACE_WITH_OPEN_MOUTH , "😧" => crate :: smileys_and_emotion :: face_concerned :: ANGUISHED_FACE , "😨" => crate :: smileys_and_emotion :: face_concerned :: FEARFUL_FACE , "😰" => crate :: smileys_and_emotion :: face_concerned :: ANXIOUS_FACE_WITH_SWEAT , "😥" => crate :: smileys_and_emotion :: face_concerned :: SAD_BUT_RELIEVED_FACE , "😢" => crate :: smileys_and_emotion :: face_concerned :: CRYING_FACE , "😭" => crate :: smileys_and_emotion :: face_concerned :: LOUDLY_CRYING_FACE , "😱" => crate :: smileys_and_emotion :: face_concerned :: FACE_SCREAMING_IN_FEAR , "😖" => crate :: smileys_and_emotion :: face_concerned :: CONFOUNDED_FACE , "😣" => crate :: smileys_and_emotion :: face_concerned :: PERSEVERING_FACE , "😞" => crate :: smileys_and_emotion :: face_concerned :: DISAPPOINTED_FACE , "😓" => crate :: smileys_and_emotion :: face_concerned :: DOWNCAST_FACE_WITH_SWEAT , "😩" => crate :: smileys_and_emotion :: face_concerned :: WEARY_FACE , "😫" => crate :: smileys_and_emotion :: face_concerned :: TIRED_FACE , "🥱" => crate :: smileys_and_emotion :: face_concerned :: YAWNING_FACE , "😤" => crate :: smileys_and_emotion :: face_negative :: FACE_WITH_STEAM_FROM_NOSE , "😡" => crate :: smileys_and_emotion :: face_negative :: POUTING_FACE , "😠" => crate :: smileys_and_emotion :: face_negative :: ANGRY_FACE , "🤬" => crate :: smileys_and_emotion :: face_negative :: FACE_WITH_SYMBOLS_ON_MOUTH , "😈" => crate :: smileys_and_emotion :: face_negative :: SMILING_FACE_WITH_HORNS , "👿" => crate :: smileys_and_emotion :: face_negative :: ANGRY_FACE_WITH_HORNS , "💀" => crate :: smileys_and_emotion :: face_negative :: SKULL , "☠\u{fe0f}" => crate :: smileys_and_emotion :: face_negative :: SKULL_AND_CROSSBONES , "☠" => crate :: smileys_and_emotion :: face_negative :: SKULL_AND_CROSSBONES , "💩" => crate :: smileys_and_emotion :: face_costume :: PILE_OF_POO , "🤡" => crate :: smileys_and_emotion :: face_costume :: CLOWN_FACE , "👹" => crate :: smileys_and_emotion :: face_costume :: OGRE , "👺" => crate :: smileys_and_emotion :: face_costume :: GOBLIN , "👻" => crate :: smileys_and_emotion :: face_costume :: GHOST , "👽" => crate :: smileys_and_emotion :: face_costume :: ALIEN , "👾" => crate :: smileys_and_emotion :: face_costume :: ALIEN_MONSTER , "🤖" => crate :: smileys_and_emotion :: face_costume :: ROBOT , "😺" => crate :: smileys_and_emotion :: cat_face :: GRINNING_CAT , "😸" => crate :: smileys_and_emotion :: cat_face :: GRINNING_CAT_WITH_SMILING_EYES , "😹" => crate :: smileys_and_emotion :: cat_face :: CAT_WITH_TEARS_OF_JOY , "😻" => crate :: smileys_and_emotion :: cat_face :: SMILING_CAT_WITH_HEART_EYES , "😼" => crate :: smileys_and_emotion :: cat_face :: CAT_WITH_WRY_SMILE , "😽" => crate :: smileys_and_emotion :: cat_face :: KISSING_CAT , "🙀" => crate :: smileys_and_emotion :: cat_face :: WEARY_CAT , "😿" => crate :: smileys_and_emotion :: cat_face :: CRYING_CAT , "😾" => crate :: smileys_and_emotion :: cat_face :: POUTING_CAT , "🙈" => crate :: smileys_and_emotion :: monkey_face :: SEE_NO_EVIL_MONKEY , "🙉" => crate :: smileys_and_emotion :: monkey_face :: HEAR_NO_EVIL_MONKEY , "🙊" => crate :: smileys_and_emotion :: monkey_face :: SPEAK_NO_EVIL_MONKEY , "💋" => crate :: smileys_and_emotion :: emotion :: KISS_MARK , "💌" => crate :: smileys_and_emotion :: emotion :: LOVE_LETTER , "💘" => crate :: smileys_and_emotion :: emotion :: HEART_WITH_ARROW , "💝" => crate :: smileys_and_emotion :: emotion :: HEART_WITH_RIBBON , "💖" => crate :: smileys_and_emotion :: emotion :: SPARKLING_HEART , "💗" => crate :: smileys_and_emotion :: emotion :: GROWING_HEART , "💓" => crate :: smileys_and_emotion :: emotion :: BEATING_HEART , "💞" => crate :: smileys_and_emotion :: emotion :: REVOLVING_HEARTS , "💕" => crate :: smileys_and_emotion :: emotion :: TWO_HEARTS , "💟" => crate :: smileys_and_emotion :: emotion :: HEART_DECORATION , "❣\u{fe0f}" => crate :: smileys_and_emotion :: emotion :: HEART_EXCLAMATION , "❣" => crate :: smileys_and_emotion :: emotion :: HEART_EXCLAMATION , "💔" => crate :: smileys_and_emotion :: emotion :: BROKEN_HEART , "❤\u{fe0f}\u{200d}🔥" => crate :: smileys_and_emotion :: emotion :: HEART_ON_FIRE , "❤\u{200d}🔥" => crate :: smileys_and_emotion :: emotion :: HEART_ON_FIRE , "❤\u{fe0f}\u{200d}🩹" => crate :: smileys_and_emotion :: emotion :: MENDING_HEART , "❤\u{200d}🩹" => crate :: smileys_and_emotion :: emotion :: MENDING_HEART , "❤\u{fe0f}" => crate :: smileys_and_emotion :: emotion :: RED_HEART , "❤" => crate :: smileys_and_emotion :: emotion :: RED_HEART , "🧡" => crate :: smileys_and_emotion :: emotion :: ORANGE_HEART , "💛" => crate :: smileys_and_emotion :: emotion :: YELLOW_HEART , "💚" => crate :: smileys_and_emotion :: emotion :: GREEN_HEART , "💙" => crate :: smileys_and_emotion :: emotion :: BLUE_HEART , "💜" => crate :: smileys_and_emotion :: emotion :: PURPLE_HEART , "🤎" => crate :: smileys_and_emotion :: emotion :: BROWN_HEART , "🖤" => crate :: smileys_and_emotion :: emotion :: BLACK_HEART , "🤍" => crate :: smileys_and_emotion :: emotion :: WHITE_HEART , "💯" => crate :: smileys_and_emotion :: emotion :: HUNDRED_POINTS , "💢" => crate :: smileys_and_emotion :: emotion :: ANGER_SYMBOL , "💥" => crate :: smileys_and_emotion :: emotion :: COLLISION , "💫" => crate :: smileys_and_emotion :: emotion :: DIZZY , "💦" => crate :: smileys_and_emotion :: emotion :: SWEAT_DROPLETS , "💨" => crate :: smileys_and_emotion :: emotion :: DASHING_AWAY , "🕳\u{fe0f}" => crate :: smileys_and_emotion :: emotion :: HOLE , "🕳" => crate :: smileys_and_emotion :: emotion :: HOLE , "💣" => crate :: smileys_and_emotion :: emotion :: BOMB , "💬" => crate :: smileys_and_emotion :: emotion :: SPEECH_BALLOON , "👁\u{fe0f}\u{200d}🗨\u{fe0f}" => crate :: smileys_and_emotion :: emotion :: EYE_IN_SPEECH_BUBBLE , "👁\u{200d}🗨\u{fe0f}" => crate :: smileys_and_emotion :: emotion :: EYE_IN_SPEECH_BUBBLE , "👁\u{fe0f}\u{200d}🗨" => crate :: smileys_and_emotion :: emotion :: EYE_IN_SPEECH_BUBBLE , "👁\u{200d}🗨" => crate :: smileys_and_emotion :: emotion :: EYE_IN_SPEECH_BUBBLE , "🗨\u{fe0f}" => crate :: smileys_and_emotion :: emotion :: LEFT_SPEECH_BUBBLE , "🗨" => crate :: smileys_and_emotion :: emotion :: LEFT_SPEECH_BUBBLE , "🗯\u{fe0f}" => crate :: smileys_and_emotion :: emotion :: RIGHT_ANGER_BUBBLE , "🗯" => crate :: smileys_and_emotion :: emotion :: RIGHT_ANGER_BUBBLE , "💭" => crate :: smileys_and_emotion :: emotion :: THOUGHT_BALLOON , "💤" => crate :: smileys_and_emotion :: emotion :: ZZZ , "👋" => crate :: people_and_body :: hand_fingers_open :: WAVING_HAND , "👋🏻" => crate :: people_and_body :: hand_fingers_open :: WAVING_HAND_LIGHT_SKIN_TONE , "👋🏼" => crate :: people_and_body :: hand_fingers_open :: WAVING_HAND_MEDIUM_LIGHT_SKIN_TONE , "👋🏽" => crate :: people_and_body :: hand_fingers_open :: WAVING_HAND_MEDIUM_SKIN_TONE , "👋🏾" => crate :: people_and_body :: hand_fingers_open :: WAVING_HAND_MEDIUM_DARK_SKIN_TONE , "👋🏿" => crate :: people_and_body :: hand_fingers_open :: WAVING_HAND_DARK_SKIN_TONE , "🤚" => crate :: people_and_body :: hand_fingers_open :: RAISED_BACK_OF_HAND , "🤚🏻" => crate :: people_and_body :: hand_fingers_open :: RAISED_BACK_OF_HAND_LIGHT_SKIN_TONE , "🤚🏼" => crate :: people_and_body :: hand_fingers_open :: RAISED_BACK_OF_HAND_MEDIUM_LIGHT_SKIN_TONE , "🤚🏽" => crate :: people_and_body :: hand_fingers_open :: RAISED_BACK_OF_HAND_MEDIUM_SKIN_TONE , "🤚🏾" => crate :: people_and_body :: hand_fingers_open :: RAISED_BACK_OF_HAND_MEDIUM_DARK_SKIN_TONE , "🤚🏿" => crate :: people_and_body :: hand_fingers_open :: RAISED_BACK_OF_HAND_DARK_SKIN_TONE , "🖐\u{fe0f}" => crate :: people_and_body :: hand_fingers_open :: HAND_WITH_FINGERS_SPLAYED , "🖐" => crate :: people_and_body :: hand_fingers_open :: HAND_WITH_FINGERS_SPLAYED , "🖐🏻" => crate :: people_and_body :: hand_fingers_open :: HAND_WITH_FINGERS_SPLAYED_LIGHT_SKIN_TONE , "🖐🏼" => crate :: people_and_body :: hand_fingers_open :: HAND_WITH_FINGERS_SPLAYED_MEDIUM_LIGHT_SKIN_TONE , "🖐🏽" => crate :: people_and_body :: hand_fingers_open :: HAND_WITH_FINGERS_SPLAYED_MEDIUM_SKIN_TONE , "🖐🏾" => crate :: people_and_body :: hand_fingers_open :: HAND_WITH_FINGERS_SPLAYED_MEDIUM_DARK_SKIN_TONE , "🖐🏿" => crate :: people_and_body :: hand_fingers_open :: HAND_WITH_FINGERS_SPLAYED_DARK_SKIN_TONE , "✋" => crate :: people_and_body :: hand_fingers_open :: RAISED_HAND , "✋🏻" => crate :: people_and_body :: hand_fingers_open :: RAISED_HAND_LIGHT_SKIN_TONE , "✋🏼" => crate :: people_and_body :: hand_fingers_open :: RAISED_HAND_MEDIUM_LIGHT_SKIN_TONE , "✋🏽" => crate :: people_and_body :: hand_fingers_open :: RAISED_HAND_MEDIUM_SKIN_TONE , "✋🏾" => crate :: people_and_body :: hand_fingers_open :: RAISED_HAND_MEDIUM_DARK_SKIN_TONE , "✋🏿" => crate :: people_and_body :: hand_fingers_open :: RAISED_HAND_DARK_SKIN_TONE , "🖖" => crate :: people_and_body :: hand_fingers_open :: VULCAN_SALUTE , "🖖🏻" => crate :: people_and_body :: hand_fingers_open :: VULCAN_SALUTE_LIGHT_SKIN_TONE , "🖖🏼" => crate :: people_and_body :: hand_fingers_open :: VULCAN_SALUTE_MEDIUM_LIGHT_SKIN_TONE , "🖖🏽" => crate :: people_and_body :: hand_fingers_open :: VULCAN_SALUTE_MEDIUM_SKIN_TONE , "🖖🏾" => crate :: people_and_body :: hand_fingers_open :: VULCAN_SALUTE_MEDIUM_DARK_SKIN_TONE , "🖖🏿" => crate :: people_and_body :: hand_fingers_open :: VULCAN_SALUTE_DARK_SKIN_TONE , "👌" => crate :: people_and_body :: hand_fingers_partial :: OK_HAND , "👌🏻" => crate :: people_and_body :: hand_fingers_partial :: OK_HAND_LIGHT_SKIN_TONE , "👌🏼" => crate :: people_and_body :: hand_fingers_partial :: OK_HAND_MEDIUM_LIGHT_SKIN_TONE , "👌🏽" => crate :: people_and_body :: hand_fingers_partial :: OK_HAND_MEDIUM_SKIN_TONE , "👌🏾" => crate :: people_and_body :: hand_fingers_partial :: OK_HAND_MEDIUM_DARK_SKIN_TONE , "👌🏿" => crate :: people_and_body :: hand_fingers_partial :: OK_HAND_DARK_SKIN_TONE , "🤌" => crate :: people_and_body :: hand_fingers_partial :: PINCHED_FINGERS , "🤌🏻" => crate :: people_and_body :: hand_fingers_partial :: PINCHED_FINGERS_LIGHT_SKIN_TONE , "🤌🏼" => crate :: people_and_body :: hand_fingers_partial :: PINCHED_FINGERS_MEDIUM_LIGHT_SKIN_TONE , "🤌🏽" => crate :: people_and_body :: hand_fingers_partial :: PINCHED_FINGERS_MEDIUM_SKIN_TONE , "🤌🏾" => crate :: people_and_body :: hand_fingers_partial :: PINCHED_FINGERS_MEDIUM_DARK_SKIN_TONE , "🤌🏿" => crate :: people_and_body :: hand_fingers_partial :: PINCHED_FINGERS_DARK_SKIN_TONE , "🤏" => crate :: people_and_body :: hand_fingers_partial :: PINCHING_HAND , "🤏🏻" => crate :: people_and_body :: hand_fingers_partial :: PINCHING_HAND_LIGHT_SKIN_TONE , "🤏🏼" => crate :: people_and_body :: hand_fingers_partial :: PINCHING_HAND_MEDIUM_LIGHT_SKIN_TONE , "🤏🏽" => crate :: people_and_body :: hand_fingers_partial :: PINCHING_HAND_MEDIUM_SKIN_TONE , "🤏🏾" => crate :: people_and_body :: hand_fingers_partial :: PINCHING_HAND_MEDIUM_DARK_SKIN_TONE , "🤏🏿" => crate :: people_and_body :: hand_fingers_partial :: PINCHING_HAND_DARK_SKIN_TONE , "✌\u{fe0f}" => crate :: people_and_body :: hand_fingers_partial :: VICTORY_HAND , "✌" => crate :: people_and_body :: hand_fingers_partial :: VICTORY_HAND , "✌🏻" => crate :: people_and_body :: hand_fingers_partial :: VICTORY_HAND_LIGHT_SKIN_TONE , "✌🏼" => crate :: people_and_body :: hand_fingers_partial :: VICTORY_HAND_MEDIUM_LIGHT_SKIN_TONE , "✌🏽" => crate :: people_and_body :: hand_fingers_partial :: VICTORY_HAND_MEDIUM_SKIN_TONE , "✌🏾" => crate :: people_and_body :: hand_fingers_partial :: VICTORY_HAND_MEDIUM_DARK_SKIN_TONE , "✌🏿" => crate :: people_and_body :: hand_fingers_partial :: VICTORY_HAND_DARK_SKIN_TONE , "🤞" => crate :: people_and_body :: hand_fingers_partial :: CROSSED_FINGERS , "🤞🏻" => crate :: people_and_body :: hand_fingers_partial :: CROSSED_FINGERS_LIGHT_SKIN_TONE , "🤞🏼" => crate :: people_and_body :: hand_fingers_partial :: CROSSED_FINGERS_MEDIUM_LIGHT_SKIN_TONE , "🤞🏽" => crate :: people_and_body :: hand_fingers_partial :: CROSSED_FINGERS_MEDIUM_SKIN_TONE , "🤞🏾" => crate :: people_and_body :: hand_fingers_partial :: CROSSED_FINGERS_MEDIUM_DARK_SKIN_TONE , "🤞🏿" => crate :: people_and_body :: hand_fingers_partial :: CROSSED_FINGERS_DARK_SKIN_TONE , "🤟" => crate :: people_and_body :: hand_fingers_partial :: LOVE_YOU_GESTURE , "🤟🏻" => crate :: people_and_body :: hand_fingers_partial :: LOVE_YOU_GESTURE_LIGHT_SKIN_TONE , "🤟🏼" => crate :: people_and_body :: hand_fingers_partial :: LOVE_YOU_GESTURE_MEDIUM_LIGHT_SKIN_TONE , "🤟🏽" => crate :: people_and_body :: hand_fingers_partial :: LOVE_YOU_GESTURE_MEDIUM_SKIN_TONE , "🤟🏾" => crate :: people_and_body :: hand_fingers_partial :: LOVE_YOU_GESTURE_MEDIUM_DARK_SKIN_TONE , "🤟🏿" => crate :: people_and_body :: hand_fingers_partial :: LOVE_YOU_GESTURE_DARK_SKIN_TONE , "🤘" => crate :: people_and_body :: hand_fingers_partial :: SIGN_OF_THE_HORNS , "🤘🏻" => crate :: people_and_body :: hand_fingers_partial :: SIGN_OF_THE_HORNS_LIGHT_SKIN_TONE , "🤘🏼" => crate :: people_and_body :: hand_fingers_partial :: SIGN_OF_THE_HORNS_MEDIUM_LIGHT_SKIN_TONE , "🤘🏽" => crate :: people_and_body :: hand_fingers_partial :: SIGN_OF_THE_HORNS_MEDIUM_SKIN_TONE , "🤘🏾" => crate :: people_and_body :: hand_fingers_partial :: SIGN_OF_THE_HORNS_MEDIUM_DARK_SKIN_TONE , "🤘🏿" => crate :: people_and_body :: hand_fingers_partial :: SIGN_OF_THE_HORNS_DARK_SKIN_TONE , "🤙" => crate :: people_and_body :: hand_fingers_partial :: CALL_ME_HAND , "🤙🏻" => crate :: people_and_body :: hand_fingers_partial :: CALL_ME_HAND_LIGHT_SKIN_TONE , "🤙🏼" => crate :: people_and_body :: hand_fingers_partial :: CALL_ME_HAND_MEDIUM_LIGHT_SKIN_TONE , "🤙🏽" => crate :: people_and_body :: hand_fingers_partial :: CALL_ME_HAND_MEDIUM_SKIN_TONE , "🤙🏾" => crate :: people_and_body :: hand_fingers_partial :: CALL_ME_HAND_MEDIUM_DARK_SKIN_TONE , "🤙🏿" => crate :: people_and_body :: hand_fingers_partial :: CALL_ME_HAND_DARK_SKIN_TONE , "👈" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_LEFT , "👈🏻" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_LEFT_LIGHT_SKIN_TONE , "👈🏼" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_LEFT_MEDIUM_LIGHT_SKIN_TONE , "👈🏽" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_LEFT_MEDIUM_SKIN_TONE , "👈🏾" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_LEFT_MEDIUM_DARK_SKIN_TONE , "👈🏿" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_LEFT_DARK_SKIN_TONE , "👉" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_RIGHT , "👉🏻" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_RIGHT_LIGHT_SKIN_TONE , "👉🏼" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_RIGHT_MEDIUM_LIGHT_SKIN_TONE , "👉🏽" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_RIGHT_MEDIUM_SKIN_TONE , "👉🏾" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_RIGHT_MEDIUM_DARK_SKIN_TONE , "👉🏿" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_RIGHT_DARK_SKIN_TONE , "👆" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_UP , "👆🏻" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_UP_LIGHT_SKIN_TONE , "👆🏼" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_UP_MEDIUM_LIGHT_SKIN_TONE , "👆🏽" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_UP_MEDIUM_SKIN_TONE , "👆🏾" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_UP_MEDIUM_DARK_SKIN_TONE , "👆🏿" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_UP_DARK_SKIN_TONE , "🖕" => crate :: people_and_body :: hand_single_finger :: MIDDLE_FINGER , "🖕🏻" => crate :: people_and_body :: hand_single_finger :: MIDDLE_FINGER_LIGHT_SKIN_TONE , "🖕🏼" => crate :: people_and_body :: hand_single_finger :: MIDDLE_FINGER_MEDIUM_LIGHT_SKIN_TONE , "🖕🏽" => crate :: people_and_body :: hand_single_finger :: MIDDLE_FINGER_MEDIUM_SKIN_TONE , "🖕🏾" => crate :: people_and_body :: hand_single_finger :: MIDDLE_FINGER_MEDIUM_DARK_SKIN_TONE , "🖕🏿" => crate :: people_and_body :: hand_single_finger :: MIDDLE_FINGER_DARK_SKIN_TONE , "👇" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_DOWN , "👇🏻" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_DOWN_LIGHT_SKIN_TONE , "👇🏼" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_DOWN_MEDIUM_LIGHT_SKIN_TONE , "👇🏽" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_DOWN_MEDIUM_SKIN_TONE , "👇🏾" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_DOWN_MEDIUM_DARK_SKIN_TONE , "👇🏿" => crate :: people_and_body :: hand_single_finger :: BACKHAND_INDEX_POINTING_DOWN_DARK_SKIN_TONE , "☝\u{fe0f}" => crate :: people_and_body :: hand_single_finger :: INDEX_POINTING_UP , "☝" => crate :: people_and_body :: hand_single_finger :: INDEX_POINTING_UP , "☝🏻" => crate :: people_and_body :: hand_single_finger :: INDEX_POINTING_UP_LIGHT_SKIN_TONE , "☝🏼" => crate :: people_and_body :: hand_single_finger :: INDEX_POINTING_UP_MEDIUM_LIGHT_SKIN_TONE , "☝🏽" => crate :: people_and_body :: hand_single_finger :: INDEX_POINTING_UP_MEDIUM_SKIN_TONE , "☝🏾" => crate :: people_and_body :: hand_single_finger :: INDEX_POINTING_UP_MEDIUM_DARK_SKIN_TONE , "☝🏿" => crate :: people_and_body :: hand_single_finger :: INDEX_POINTING_UP_DARK_SKIN_TONE , "👍" => crate :: people_and_body :: hand_fingers_closed :: THUMBS_UP , "👍🏻" => crate :: people_and_body :: hand_fingers_closed :: THUMBS_UP_LIGHT_SKIN_TONE , "👍🏼" => crate :: people_and_body :: hand_fingers_closed :: THUMBS_UP_MEDIUM_LIGHT_SKIN_TONE , "👍🏽" => crate :: people_and_body :: hand_fingers_closed :: THUMBS_UP_MEDIUM_SKIN_TONE , "👍🏾" => crate :: people_and_body :: hand_fingers_closed :: THUMBS_UP_MEDIUM_DARK_SKIN_TONE , "👍🏿" => crate :: people_and_body :: hand_fingers_closed :: THUMBS_UP_DARK_SKIN_TONE , "👎" => crate :: people_and_body :: hand_fingers_closed :: THUMBS_DOWN , "👎🏻" => crate :: people_and_body :: hand_fingers_closed :: THUMBS_DOWN_LIGHT_SKIN_TONE , "👎🏼" => crate :: people_and_body :: hand_fingers_closed :: THUMBS_DOWN_MEDIUM_LIGHT_SKIN_TONE , "👎🏽" => crate :: people_and_body :: hand_fingers_closed :: THUMBS_DOWN_MEDIUM_SKIN_TONE , "👎🏾" => crate :: people_and_body :: hand_fingers_closed :: THUMBS_DOWN_MEDIUM_DARK_SKIN_TONE , "👎🏿" => crate :: people_and_body :: hand_fingers_closed :: THUMBS_DOWN_DARK_SKIN_TONE , "✊" => crate :: people_and_body :: hand_fingers_closed :: RAISED_FIST , "✊🏻" => crate :: people_and_body :: hand_fingers_closed :: RAISED_FIST_LIGHT_SKIN_TONE , "✊🏼" => crate :: people_and_body :: hand_fingers_closed :: RAISED_FIST_MEDIUM_LIGHT_SKIN_TONE , "✊🏽" => crate :: people_and_body :: hand_fingers_closed :: RAISED_FIST_MEDIUM_SKIN_TONE , "✊🏾" => crate :: people_and_body :: hand_fingers_closed :: RAISED_FIST_MEDIUM_DARK_SKIN_TONE , "✊🏿" => crate :: people_and_body :: hand_fingers_closed :: RAISED_FIST_DARK_SKIN_TONE , "👊" => crate :: people_and_body :: hand_fingers_closed :: ONCOMING_FIST , "👊🏻" => crate :: people_and_body :: hand_fingers_closed :: ONCOMING_FIST_LIGHT_SKIN_TONE , "👊🏼" => crate :: people_and_body :: hand_fingers_closed :: ONCOMING_FIST_MEDIUM_LIGHT_SKIN_TONE , "👊🏽" => crate :: people_and_body :: hand_fingers_closed :: ONCOMING_FIST_MEDIUM_SKIN_TONE , "👊🏾" => crate :: people_and_body :: hand_fingers_closed :: ONCOMING_FIST_MEDIUM_DARK_SKIN_TONE , "👊🏿" => crate :: people_and_body :: hand_fingers_closed :: ONCOMING_FIST_DARK_SKIN_TONE , "🤛" => crate :: people_and_body :: hand_fingers_closed :: LEFT_FACING_FIST , "🤛🏻" => crate :: people_and_body :: hand_fingers_closed :: LEFT_FACING_FIST_LIGHT_SKIN_TONE , "🤛🏼" => crate :: people_and_body :: hand_fingers_closed :: LEFT_FACING_FIST_MEDIUM_LIGHT_SKIN_TONE , "🤛🏽" => crate :: people_and_body :: hand_fingers_closed :: LEFT_FACING_FIST_MEDIUM_SKIN_TONE , "🤛🏾" => crate :: people_and_body :: hand_fingers_closed :: LEFT_FACING_FIST_MEDIUM_DARK_SKIN_TONE , "🤛🏿" => crate :: people_and_body :: hand_fingers_closed :: LEFT_FACING_FIST_DARK_SKIN_TONE , "🤜" => crate :: people_and_body :: hand_fingers_closed :: RIGHT_FACING_FIST , "🤜🏻" => crate :: people_and_body :: hand_fingers_closed :: RIGHT_FACING_FIST_LIGHT_SKIN_TONE , "🤜🏼" => crate :: people_and_body :: hand_fingers_closed :: RIGHT_FACING_FIST_MEDIUM_LIGHT_SKIN_TONE , "🤜🏽" => crate :: people_and_body :: hand_fingers_closed :: RIGHT_FACING_FIST_MEDIUM_SKIN_TONE , "🤜🏾" => crate :: people_and_body :: hand_fingers_closed :: RIGHT_FACING_FIST_MEDIUM_DARK_SKIN_TONE , "🤜🏿" => crate :: people_and_body :: hand_fingers_closed :: RIGHT_FACING_FIST_DARK_SKIN_TONE , "👏" => crate :: people_and_body :: hands :: CLAPPING_HANDS , "👏🏻" => crate :: people_and_body :: hands :: CLAPPING_HANDS_LIGHT_SKIN_TONE , "👏🏼" => crate :: people_and_body :: hands :: CLAPPING_HANDS_MEDIUM_LIGHT_SKIN_TONE , "👏🏽" => crate :: people_and_body :: hands :: CLAPPING_HANDS_MEDIUM_SKIN_TONE , "👏🏾" => crate :: people_and_body :: hands :: CLAPPING_HANDS_MEDIUM_DARK_SKIN_TONE , "👏🏿" => crate :: people_and_body :: hands :: CLAPPING_HANDS_DARK_SKIN_TONE , "🙌" => crate :: people_and_body :: hands :: RAISING_HANDS , "🙌🏻" => crate :: people_and_body :: hands :: RAISING_HANDS_LIGHT_SKIN_TONE , "🙌🏼" => crate :: people_and_body :: hands :: RAISING_HANDS_MEDIUM_LIGHT_SKIN_TONE , "🙌🏽" => crate :: people_and_body :: hands :: RAISING_HANDS_MEDIUM_SKIN_TONE , "🙌🏾" => crate :: people_and_body :: hands :: RAISING_HANDS_MEDIUM_DARK_SKIN_TONE , "🙌🏿" => crate :: people_and_body :: hands :: RAISING_HANDS_DARK_SKIN_TONE , "👐" => crate :: people_and_body :: hands :: OPEN_HANDS , "👐🏻" => crate :: people_and_body :: hands :: OPEN_HANDS_LIGHT_SKIN_TONE , "👐🏼" => crate :: people_and_body :: hands :: OPEN_HANDS_MEDIUM_LIGHT_SKIN_TONE , "👐🏽" => crate :: people_and_body :: hands :: OPEN_HANDS_MEDIUM_SKIN_TONE , "👐🏾" => crate :: people_and_body :: hands :: OPEN_HANDS_MEDIUM_DARK_SKIN_TONE , "👐🏿" => crate :: people_and_body :: hands :: OPEN_HANDS_DARK_SKIN_TONE , "🤲" => crate :: people_and_body :: hands :: PALMS_UP_TOGETHER , "🤲🏻" => crate :: people_and_body :: hands :: PALMS_UP_TOGETHER_LIGHT_SKIN_TONE , "🤲🏼" => crate :: people_and_body :: hands :: PALMS_UP_TOGETHER_MEDIUM_LIGHT_SKIN_TONE , "🤲🏽" => crate :: people_and_body :: hands :: PALMS_UP_TOGETHER_MEDIUM_SKIN_TONE , "🤲🏾" => crate :: people_and_body :: hands :: PALMS_UP_TOGETHER_MEDIUM_DARK_SKIN_TONE , "🤲🏿" => crate :: people_and_body :: hands :: PALMS_UP_TOGETHER_DARK_SKIN_TONE , "🤝" => crate :: people_and_body :: hands :: HANDSHAKE , "🙏" => crate :: people_and_body :: hands :: FOLDED_HANDS , "🙏🏻" => crate :: people_and_body :: hands :: FOLDED_HANDS_LIGHT_SKIN_TONE , "🙏🏼" => crate :: people_and_body :: hands :: FOLDED_HANDS_MEDIUM_LIGHT_SKIN_TONE , "🙏🏽" => crate :: people_and_body :: hands :: FOLDED_HANDS_MEDIUM_SKIN_TONE , "🙏🏾" => crate :: people_and_body :: hands :: FOLDED_HANDS_MEDIUM_DARK_SKIN_TONE , "🙏🏿" => crate :: people_and_body :: hands :: FOLDED_HANDS_DARK_SKIN_TONE , "✍\u{fe0f}" => crate :: people_and_body :: hand_prop :: WRITING_HAND , "✍" => crate :: people_and_body :: hand_prop :: WRITING_HAND , "✍🏻" => crate :: people_and_body :: hand_prop :: WRITING_HAND_LIGHT_SKIN_TONE , "✍🏼" => crate :: people_and_body :: hand_prop :: WRITING_HAND_MEDIUM_LIGHT_SKIN_TONE , "✍🏽" => crate :: people_and_body :: hand_prop :: WRITING_HAND_MEDIUM_SKIN_TONE , "✍🏾" => crate :: people_and_body :: hand_prop :: WRITING_HAND_MEDIUM_DARK_SKIN_TONE , "✍🏿" => crate :: people_and_body :: hand_prop :: WRITING_HAND_DARK_SKIN_TONE , "💅" => crate :: people_and_body :: hand_prop :: NAIL_POLISH , "💅🏻" => crate :: people_and_body :: hand_prop :: NAIL_POLISH_LIGHT_SKIN_TONE , "💅🏼" => crate :: people_and_body :: hand_prop :: NAIL_POLISH_MEDIUM_LIGHT_SKIN_TONE , "💅🏽" => crate :: people_and_body :: hand_prop :: NAIL_POLISH_MEDIUM_SKIN_TONE , "💅🏾" => crate :: people_and_body :: hand_prop :: NAIL_POLISH_MEDIUM_DARK_SKIN_TONE , "💅🏿" => crate :: people_and_body :: hand_prop :: NAIL_POLISH_DARK_SKIN_TONE , "🤳" => crate :: people_and_body :: hand_prop :: SELFIE , "🤳🏻" => crate :: people_and_body :: hand_prop :: SELFIE_LIGHT_SKIN_TONE , "🤳🏼" => crate :: people_and_body :: hand_prop :: SELFIE_MEDIUM_LIGHT_SKIN_TONE , "🤳🏽" => crate :: people_and_body :: hand_prop :: SELFIE_MEDIUM_SKIN_TONE , "🤳🏾" => crate :: people_and_body :: hand_prop :: SELFIE_MEDIUM_DARK_SKIN_TONE , "🤳🏿" => crate :: people_and_body :: hand_prop :: SELFIE_DARK_SKIN_TONE , "💪" => crate :: people_and_body :: body_parts :: FLEXED_BICEPS , "💪🏻" => crate :: people_and_body :: body_parts :: FLEXED_BICEPS_LIGHT_SKIN_TONE , "💪🏼" => crate :: people_and_body :: body_parts :: FLEXED_BICEPS_MEDIUM_LIGHT_SKIN_TONE , "💪🏽" => crate :: people_and_body :: body_parts :: FLEXED_BICEPS_MEDIUM_SKIN_TONE , "💪🏾" => crate :: people_and_body :: body_parts :: FLEXED_BICEPS_MEDIUM_DARK_SKIN_TONE , "💪🏿" => crate :: people_and_body :: body_parts :: FLEXED_BICEPS_DARK_SKIN_TONE , "🦾" => crate :: people_and_body :: body_parts :: MECHANICAL_ARM , "🦿" => crate :: people_and_body :: body_parts :: MECHANICAL_LEG , "🦵" => crate :: people_and_body :: body_parts :: LEG , "🦵🏻" => crate :: people_and_body :: body_parts :: LEG_LIGHT_SKIN_TONE , "🦵🏼" => crate :: people_and_body :: body_parts :: LEG_MEDIUM_LIGHT_SKIN_TONE , "🦵🏽" => crate :: people_and_body :: body_parts :: LEG_MEDIUM_SKIN_TONE , "🦵🏾" => crate :: people_and_body :: body_parts :: LEG_MEDIUM_DARK_SKIN_TONE , "🦵🏿" => crate :: people_and_body :: body_parts :: LEG_DARK_SKIN_TONE , "🦶" => crate :: people_and_body :: body_parts :: FOOT , "🦶🏻" => crate :: people_and_body :: body_parts :: FOOT_LIGHT_SKIN_TONE , "🦶🏼" => crate :: people_and_body :: body_parts :: FOOT_MEDIUM_LIGHT_SKIN_TONE , "🦶🏽" => crate :: people_and_body :: body_parts :: FOOT_MEDIUM_SKIN_TONE , "🦶🏾" => crate :: people_and_body :: body_parts :: FOOT_MEDIUM_DARK_SKIN_TONE , "🦶🏿" => crate :: people_and_body :: body_parts :: FOOT_DARK_SKIN_TONE , "👂" => crate :: people_and_body :: body_parts :: EAR , "👂🏻" => crate :: people_and_body :: body_parts :: EAR_LIGHT_SKIN_TONE , "👂🏼" => crate :: people_and_body :: body_parts :: EAR_MEDIUM_LIGHT_SKIN_TONE , "👂🏽" => crate :: people_and_body :: body_parts :: EAR_MEDIUM_SKIN_TONE , "👂🏾" => crate :: people_and_body :: body_parts :: EAR_MEDIUM_DARK_SKIN_TONE , "👂🏿" => crate :: people_and_body :: body_parts :: EAR_DARK_SKIN_TONE , "🦻" => crate :: people_and_body :: body_parts :: EAR_WITH_HEARING_AID , "🦻🏻" => crate :: people_and_body :: body_parts :: EAR_WITH_HEARING_AID_LIGHT_SKIN_TONE , "🦻🏼" => crate :: people_and_body :: body_parts :: EAR_WITH_HEARING_AID_MEDIUM_LIGHT_SKIN_TONE , "🦻🏽" => crate :: people_and_body :: body_parts :: EAR_WITH_HEARING_AID_MEDIUM_SKIN_TONE , "🦻🏾" => crate :: people_and_body :: body_parts :: EAR_WITH_HEARING_AID_MEDIUM_DARK_SKIN_TONE , "🦻🏿" => crate :: people_and_body :: body_parts :: EAR_WITH_HEARING_AID_DARK_SKIN_TONE , "👃" => crate :: people_and_body :: body_parts :: NOSE , "👃🏻" => crate :: people_and_body :: body_parts :: NOSE_LIGHT_SKIN_TONE , "👃🏼" => crate :: people_and_body :: body_parts :: NOSE_MEDIUM_LIGHT_SKIN_TONE , "👃🏽" => crate :: people_and_body :: body_parts :: NOSE_MEDIUM_SKIN_TONE , "👃🏾" => crate :: people_and_body :: body_parts :: NOSE_MEDIUM_DARK_SKIN_TONE , "👃🏿" => crate :: people_and_body :: body_parts :: NOSE_DARK_SKIN_TONE , "🧠" => crate :: people_and_body :: body_parts :: BRAIN , "🫀" => crate :: people_and_body :: body_parts :: ANATOMICAL_HEART , "🫁" => crate :: people_and_body :: body_parts :: LUNGS , "🦷" => crate :: people_and_body :: body_parts :: TOOTH , "🦴" => crate :: people_and_body :: body_parts :: BONE , "👀" => crate :: people_and_body :: body_parts :: EYES , "👁\u{fe0f}" => crate :: people_and_body :: body_parts :: EYE , "👁" => crate :: people_and_body :: body_parts :: EYE , "👅" => crate :: people_and_body :: body_parts :: TONGUE , "👄" => crate :: people_and_body :: body_parts :: MOUTH , "👶" => crate :: people_and_body :: person :: BABY , "👶🏻" => crate :: people_and_body :: person :: BABY_LIGHT_SKIN_TONE , "👶🏼" => crate :: people_and_body :: person :: BABY_MEDIUM_LIGHT_SKIN_TONE , "👶🏽" => crate :: people_and_body :: person :: BABY_MEDIUM_SKIN_TONE , "👶🏾" => crate :: people_and_body :: person :: BABY_MEDIUM_DARK_SKIN_TONE , "👶🏿" => crate :: people_and_body :: person :: BABY_DARK_SKIN_TONE , "🧒" => crate :: people_and_body :: person :: CHILD , "🧒🏻" => crate :: people_and_body :: person :: CHILD_LIGHT_SKIN_TONE , "🧒🏼" => crate :: people_and_body :: person :: CHILD_MEDIUM_LIGHT_SKIN_TONE , "🧒🏽" => crate :: people_and_body :: person :: CHILD_MEDIUM_SKIN_TONE , "🧒🏾" => crate :: people_and_body :: person :: CHILD_MEDIUM_DARK_SKIN_TONE , "🧒🏿" => crate :: people_and_body :: person :: CHILD_DARK_SKIN_TONE , "👦" => crate :: people_and_body :: person :: BOY , "👦🏻" => crate :: people_and_body :: person :: BOY_LIGHT_SKIN_TONE , "👦🏼" => crate :: people_and_body :: person :: BOY_MEDIUM_LIGHT_SKIN_TONE , "👦🏽" => crate :: people_and_body :: person :: BOY_MEDIUM_SKIN_TONE , "👦🏾" => crate :: people_and_body :: person :: BOY_MEDIUM_DARK_SKIN_TONE , "👦🏿" => crate :: people_and_body :: person :: BOY_DARK_SKIN_TONE , "👧" => crate :: people_and_body :: person :: GIRL , "👧🏻" => crate :: people_and_body :: person :: GIRL_LIGHT_SKIN_TONE , "👧🏼" => crate :: people_and_body :: person :: GIRL_MEDIUM_LIGHT_SKIN_TONE , "👧🏽" => crate :: people_and_body :: person :: GIRL_MEDIUM_SKIN_TONE , "👧🏾" => crate :: people_and_body :: person :: GIRL_MEDIUM_DARK_SKIN_TONE , "👧🏿" => crate :: people_and_body :: person :: GIRL_DARK_SKIN_TONE , "🧑" => crate :: people_and_body :: person :: PERSON , "🧑🏻" => crate :: people_and_body :: person :: PERSON_LIGHT_SKIN_TONE , "🧑🏼" => crate :: people_and_body :: person :: PERSON_MEDIUM_LIGHT_SKIN_TONE , "🧑🏽" => crate :: people_and_body :: person :: PERSON_MEDIUM_SKIN_TONE , "🧑🏾" => crate :: people_and_body :: person :: PERSON_MEDIUM_DARK_SKIN_TONE , "🧑🏿" => crate :: people_and_body :: person :: PERSON_DARK_SKIN_TONE , "👱" => crate :: people_and_body :: person :: PERSON_BLOND_HAIR , "👱🏻" => crate :: people_and_body :: person :: PERSON_LIGHT_SKIN_TONE_BLOND_HAIR , "👱🏼" => crate :: people_and_body :: person :: PERSON_MEDIUM_LIGHT_SKIN_TONE_BLOND_HAIR , "👱🏽" => crate :: people_and_body :: person :: PERSON_MEDIUM_SKIN_TONE_BLOND_HAIR , "👱🏾" => crate :: people_and_body :: person :: PERSON_MEDIUM_DARK_SKIN_TONE_BLOND_HAIR , "👱🏿" => crate :: people_and_body :: person :: PERSON_DARK_SKIN_TONE_BLOND_HAIR , "👨" => crate :: people_and_body :: person :: MAN , "👨🏻" => crate :: people_and_body :: person :: MAN_LIGHT_SKIN_TONE , "👨🏼" => crate :: people_and_body :: person :: MAN_MEDIUM_LIGHT_SKIN_TONE , "👨🏽" => crate :: people_and_body :: person :: MAN_MEDIUM_SKIN_TONE , "👨🏾" => crate :: people_and_body :: person :: MAN_MEDIUM_DARK_SKIN_TONE , "👨🏿" => crate :: people_and_body :: person :: MAN_DARK_SKIN_TONE , "🧔" => crate :: people_and_body :: person :: PERSON_BEARD , "🧔🏻" => crate :: people_and_body :: person :: PERSON_LIGHT_SKIN_TONE_BEARD , "🧔🏼" => crate :: people_and_body :: person :: PERSON_MEDIUM_LIGHT_SKIN_TONE_BEARD , "🧔🏽" => crate :: people_and_body :: person :: PERSON_MEDIUM_SKIN_TONE_BEARD , "🧔🏾" => crate :: people_and_body :: person :: PERSON_MEDIUM_DARK_SKIN_TONE_BEARD , "🧔🏿" => crate :: people_and_body :: person :: PERSON_DARK_SKIN_TONE_BEARD , "🧔\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person :: MAN_BEARD , "🧔\u{200d}♂" => crate :: people_and_body :: person :: MAN_BEARD , "🧔🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person :: MAN_LIGHT_SKIN_TONE_BEARD , "🧔🏻\u{200d}♂" => crate :: people_and_body :: person :: MAN_LIGHT_SKIN_TONE_BEARD , "🧔🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person :: MAN_MEDIUM_LIGHT_SKIN_TONE_BEARD , "🧔🏼\u{200d}♂" => crate :: people_and_body :: person :: MAN_MEDIUM_LIGHT_SKIN_TONE_BEARD , "🧔🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person :: MAN_MEDIUM_SKIN_TONE_BEARD , "🧔🏽\u{200d}♂" => crate :: people_and_body :: person :: MAN_MEDIUM_SKIN_TONE_BEARD , "🧔🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person :: MAN_MEDIUM_DARK_SKIN_TONE_BEARD , "🧔🏾\u{200d}♂" => crate :: people_and_body :: person :: MAN_MEDIUM_DARK_SKIN_TONE_BEARD , "🧔🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person :: MAN_DARK_SKIN_TONE_BEARD , "🧔🏿\u{200d}♂" => crate :: people_and_body :: person :: MAN_DARK_SKIN_TONE_BEARD , "🧔\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person :: WOMAN_BEARD , "🧔\u{200d}♀" => crate :: people_and_body :: person :: WOMAN_BEARD , "🧔🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person :: WOMAN_LIGHT_SKIN_TONE_BEARD , "🧔🏻\u{200d}♀" => crate :: people_and_body :: person :: WOMAN_LIGHT_SKIN_TONE_BEARD , "🧔🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person :: WOMAN_MEDIUM_LIGHT_SKIN_TONE_BEARD , "🧔🏼\u{200d}♀" => crate :: people_and_body :: person :: WOMAN_MEDIUM_LIGHT_SKIN_TONE_BEARD , "🧔🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person :: WOMAN_MEDIUM_SKIN_TONE_BEARD , "🧔🏽\u{200d}♀" => crate :: people_and_body :: person :: WOMAN_MEDIUM_SKIN_TONE_BEARD , "🧔🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person :: WOMAN_MEDIUM_DARK_SKIN_TONE_BEARD , "🧔🏾\u{200d}♀" => crate :: people_and_body :: person :: WOMAN_MEDIUM_DARK_SKIN_TONE_BEARD , "🧔🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person :: WOMAN_DARK_SKIN_TONE_BEARD , "🧔🏿\u{200d}♀" => crate :: people_and_body :: person :: WOMAN_DARK_SKIN_TONE_BEARD , "👨\u{200d}🦰" => crate :: people_and_body :: person :: MAN_RED_HAIR , "👨🏻\u{200d}🦰" => crate :: people_and_body :: person :: MAN_LIGHT_SKIN_TONE_RED_HAIR , "👨🏼\u{200d}🦰" => crate :: people_and_body :: person :: MAN_MEDIUM_LIGHT_SKIN_TONE_RED_HAIR , "👨🏽\u{200d}🦰" => crate :: people_and_body :: person :: MAN_MEDIUM_SKIN_TONE_RED_HAIR , "👨🏾\u{200d}🦰" => crate :: people_and_body :: person :: MAN_MEDIUM_DARK_SKIN_TONE_RED_HAIR , "👨🏿\u{200d}🦰" => crate :: people_and_body :: person :: MAN_DARK_SKIN_TONE_RED_HAIR , "👨\u{200d}🦱" => crate :: people_and_body :: person :: MAN_CURLY_HAIR , "👨🏻\u{200d}🦱" => crate :: people_and_body :: person :: MAN_LIGHT_SKIN_TONE_CURLY_HAIR , "👨🏼\u{200d}🦱" => crate :: people_and_body :: person :: MAN_MEDIUM_LIGHT_SKIN_TONE_CURLY_HAIR , "👨🏽\u{200d}🦱" => crate :: people_and_body :: person :: MAN_MEDIUM_SKIN_TONE_CURLY_HAIR , "👨🏾\u{200d}🦱" => crate :: people_and_body :: person :: MAN_MEDIUM_DARK_SKIN_TONE_CURLY_HAIR , "👨🏿\u{200d}🦱" => crate :: people_and_body :: person :: MAN_DARK_SKIN_TONE_CURLY_HAIR , "👨\u{200d}🦳" => crate :: people_and_body :: person :: MAN_WHITE_HAIR , "👨🏻\u{200d}🦳" => crate :: people_and_body :: person :: MAN_LIGHT_SKIN_TONE_WHITE_HAIR , "👨🏼\u{200d}🦳" => crate :: people_and_body :: person :: MAN_MEDIUM_LIGHT_SKIN_TONE_WHITE_HAIR , "👨🏽\u{200d}🦳" => crate :: people_and_body :: person :: MAN_MEDIUM_SKIN_TONE_WHITE_HAIR , "👨🏾\u{200d}🦳" => crate :: people_and_body :: person :: MAN_MEDIUM_DARK_SKIN_TONE_WHITE_HAIR , "👨🏿\u{200d}🦳" => crate :: people_and_body :: person :: MAN_DARK_SKIN_TONE_WHITE_HAIR , "👨\u{200d}🦲" => crate :: people_and_body :: person :: MAN_BALD , "👨🏻\u{200d}🦲" => crate :: people_and_body :: person :: MAN_LIGHT_SKIN_TONE_BALD , "👨🏼\u{200d}🦲" => crate :: people_and_body :: person :: MAN_MEDIUM_LIGHT_SKIN_TONE_BALD , "👨🏽\u{200d}🦲" => crate :: people_and_body :: person :: MAN_MEDIUM_SKIN_TONE_BALD , "👨🏾\u{200d}🦲" => crate :: people_and_body :: person :: MAN_MEDIUM_DARK_SKIN_TONE_BALD , "👨🏿\u{200d}🦲" => crate :: people_and_body :: person :: MAN_DARK_SKIN_TONE_BALD , "👩" => crate :: people_and_body :: person :: WOMAN , "👩🏻" => crate :: people_and_body :: person :: WOMAN_LIGHT_SKIN_TONE , "👩🏼" => crate :: people_and_body :: person :: WOMAN_MEDIUM_LIGHT_SKIN_TONE , "👩🏽" => crate :: people_and_body :: person :: WOMAN_MEDIUM_SKIN_TONE , "👩🏾" => crate :: people_and_body :: person :: WOMAN_MEDIUM_DARK_SKIN_TONE , "👩🏿" => crate :: people_and_body :: person :: WOMAN_DARK_SKIN_TONE , "👩\u{200d}🦰" => crate :: people_and_body :: person :: WOMAN_RED_HAIR , "👩🏻\u{200d}🦰" => crate :: people_and_body :: person :: WOMAN_LIGHT_SKIN_TONE_RED_HAIR , "👩🏼\u{200d}🦰" => crate :: people_and_body :: person :: WOMAN_MEDIUM_LIGHT_SKIN_TONE_RED_HAIR , "👩🏽\u{200d}🦰" => crate :: people_and_body :: person :: WOMAN_MEDIUM_SKIN_TONE_RED_HAIR , "👩🏾\u{200d}🦰" => crate :: people_and_body :: person :: WOMAN_MEDIUM_DARK_SKIN_TONE_RED_HAIR , "👩🏿\u{200d}🦰" => crate :: people_and_body :: person :: WOMAN_DARK_SKIN_TONE_RED_HAIR , "🧑\u{200d}🦰" => crate :: people_and_body :: person :: PERSON_RED_HAIR , "🧑🏻\u{200d}🦰" => crate :: people_and_body :: person :: PERSON_LIGHT_SKIN_TONE_RED_HAIR , "🧑🏼\u{200d}🦰" => crate :: people_and_body :: person :: PERSON_MEDIUM_LIGHT_SKIN_TONE_RED_HAIR , "🧑🏽\u{200d}🦰" => crate :: people_and_body :: person :: PERSON_MEDIUM_SKIN_TONE_RED_HAIR , "🧑🏾\u{200d}🦰" => crate :: people_and_body :: person :: PERSON_MEDIUM_DARK_SKIN_TONE_RED_HAIR , "🧑🏿\u{200d}🦰" => crate :: people_and_body :: person :: PERSON_DARK_SKIN_TONE_RED_HAIR , "👩\u{200d}🦱" => crate :: people_and_body :: person :: WOMAN_CURLY_HAIR , "👩🏻\u{200d}🦱" => crate :: people_and_body :: person :: WOMAN_LIGHT_SKIN_TONE_CURLY_HAIR , "👩🏼\u{200d}🦱" => crate :: people_and_body :: person :: WOMAN_MEDIUM_LIGHT_SKIN_TONE_CURLY_HAIR , "👩🏽\u{200d}🦱" => crate :: people_and_body :: person :: WOMAN_MEDIUM_SKIN_TONE_CURLY_HAIR , "👩🏾\u{200d}🦱" => crate :: people_and_body :: person :: WOMAN_MEDIUM_DARK_SKIN_TONE_CURLY_HAIR , "👩🏿\u{200d}🦱" => crate :: people_and_body :: person :: WOMAN_DARK_SKIN_TONE_CURLY_HAIR , "🧑\u{200d}🦱" => crate :: people_and_body :: person :: PERSON_CURLY_HAIR , "🧑🏻\u{200d}🦱" => crate :: people_and_body :: person :: PERSON_LIGHT_SKIN_TONE_CURLY_HAIR , "🧑🏼\u{200d}🦱" => crate :: people_and_body :: person :: PERSON_MEDIUM_LIGHT_SKIN_TONE_CURLY_HAIR , "🧑🏽\u{200d}🦱" => crate :: people_and_body :: person :: PERSON_MEDIUM_SKIN_TONE_CURLY_HAIR , "🧑🏾\u{200d}🦱" => crate :: people_and_body :: person :: PERSON_MEDIUM_DARK_SKIN_TONE_CURLY_HAIR , "🧑🏿\u{200d}🦱" => crate :: people_and_body :: person :: PERSON_DARK_SKIN_TONE_CURLY_HAIR , "👩\u{200d}🦳" => crate :: people_and_body :: person :: WOMAN_WHITE_HAIR , "👩🏻\u{200d}🦳" => crate :: people_and_body :: person :: WOMAN_LIGHT_SKIN_TONE_WHITE_HAIR , "👩🏼\u{200d}🦳" => crate :: people_and_body :: person :: WOMAN_MEDIUM_LIGHT_SKIN_TONE_WHITE_HAIR , "👩🏽\u{200d}🦳" => crate :: people_and_body :: person :: WOMAN_MEDIUM_SKIN_TONE_WHITE_HAIR , "👩🏾\u{200d}🦳" => crate :: people_and_body :: person :: WOMAN_MEDIUM_DARK_SKIN_TONE_WHITE_HAIR , "👩🏿\u{200d}🦳" => crate :: people_and_body :: person :: WOMAN_DARK_SKIN_TONE_WHITE_HAIR , "🧑\u{200d}🦳" => crate :: people_and_body :: person :: PERSON_WHITE_HAIR , "🧑🏻\u{200d}🦳" => crate :: people_and_body :: person :: PERSON_LIGHT_SKIN_TONE_WHITE_HAIR , "🧑🏼\u{200d}🦳" => crate :: people_and_body :: person :: PERSON_MEDIUM_LIGHT_SKIN_TONE_WHITE_HAIR , "🧑🏽\u{200d}🦳" => crate :: people_and_body :: person :: PERSON_MEDIUM_SKIN_TONE_WHITE_HAIR , "🧑🏾\u{200d}🦳" => crate :: people_and_body :: person :: PERSON_MEDIUM_DARK_SKIN_TONE_WHITE_HAIR , "🧑🏿\u{200d}🦳" => crate :: people_and_body :: person :: PERSON_DARK_SKIN_TONE_WHITE_HAIR , "👩\u{200d}🦲" => crate :: people_and_body :: person :: WOMAN_BALD , "👩🏻\u{200d}🦲" => crate :: people_and_body :: person :: WOMAN_LIGHT_SKIN_TONE_BALD , "👩🏼\u{200d}🦲" => crate :: people_and_body :: person :: WOMAN_MEDIUM_LIGHT_SKIN_TONE_BALD , "👩🏽\u{200d}🦲" => crate :: people_and_body :: person :: WOMAN_MEDIUM_SKIN_TONE_BALD , "👩🏾\u{200d}🦲" => crate :: people_and_body :: person :: WOMAN_MEDIUM_DARK_SKIN_TONE_BALD , "👩🏿\u{200d}🦲" => crate :: people_and_body :: person :: WOMAN_DARK_SKIN_TONE_BALD , "🧑\u{200d}🦲" => crate :: people_and_body :: person :: PERSON_BALD , "🧑🏻\u{200d}🦲" => crate :: people_and_body :: person :: PERSON_LIGHT_SKIN_TONE_BALD , "🧑🏼\u{200d}🦲" => crate :: people_and_body :: person :: PERSON_MEDIUM_LIGHT_SKIN_TONE_BALD , "🧑🏽\u{200d}🦲" => crate :: people_and_body :: person :: PERSON_MEDIUM_SKIN_TONE_BALD , "🧑🏾\u{200d}🦲" => crate :: people_and_body :: person :: PERSON_MEDIUM_DARK_SKIN_TONE_BALD , "🧑🏿\u{200d}🦲" => crate :: people_and_body :: person :: PERSON_DARK_SKIN_TONE_BALD , "👱\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person :: WOMAN_BLOND_HAIR , "👱\u{200d}♀" => crate :: people_and_body :: person :: WOMAN_BLOND_HAIR , "👱🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person :: WOMAN_LIGHT_SKIN_TONE_BLOND_HAIR , "👱🏻\u{200d}♀" => crate :: people_and_body :: person :: WOMAN_LIGHT_SKIN_TONE_BLOND_HAIR , "👱🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person :: WOMAN_MEDIUM_LIGHT_SKIN_TONE_BLOND_HAIR , "👱🏼\u{200d}♀" => crate :: people_and_body :: person :: WOMAN_MEDIUM_LIGHT_SKIN_TONE_BLOND_HAIR , "👱🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person :: WOMAN_MEDIUM_SKIN_TONE_BLOND_HAIR , "👱🏽\u{200d}♀" => crate :: people_and_body :: person :: WOMAN_MEDIUM_SKIN_TONE_BLOND_HAIR , "👱🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person :: WOMAN_MEDIUM_DARK_SKIN_TONE_BLOND_HAIR , "👱🏾\u{200d}♀" => crate :: people_and_body :: person :: WOMAN_MEDIUM_DARK_SKIN_TONE_BLOND_HAIR , "👱🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person :: WOMAN_DARK_SKIN_TONE_BLOND_HAIR , "👱🏿\u{200d}♀" => crate :: people_and_body :: person :: WOMAN_DARK_SKIN_TONE_BLOND_HAIR , "👱\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person :: MAN_BLOND_HAIR , "👱\u{200d}♂" => crate :: people_and_body :: person :: MAN_BLOND_HAIR , "👱🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person :: MAN_LIGHT_SKIN_TONE_BLOND_HAIR , "👱🏻\u{200d}♂" => crate :: people_and_body :: person :: MAN_LIGHT_SKIN_TONE_BLOND_HAIR , "👱🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person :: MAN_MEDIUM_LIGHT_SKIN_TONE_BLOND_HAIR , "👱🏼\u{200d}♂" => crate :: people_and_body :: person :: MAN_MEDIUM_LIGHT_SKIN_TONE_BLOND_HAIR , "👱🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person :: MAN_MEDIUM_SKIN_TONE_BLOND_HAIR , "👱🏽\u{200d}♂" => crate :: people_and_body :: person :: MAN_MEDIUM_SKIN_TONE_BLOND_HAIR , "👱🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person :: MAN_MEDIUM_DARK_SKIN_TONE_BLOND_HAIR , "👱🏾\u{200d}♂" => crate :: people_and_body :: person :: MAN_MEDIUM_DARK_SKIN_TONE_BLOND_HAIR , "👱🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person :: MAN_DARK_SKIN_TONE_BLOND_HAIR , "👱🏿\u{200d}♂" => crate :: people_and_body :: person :: MAN_DARK_SKIN_TONE_BLOND_HAIR , "🧓" => crate :: people_and_body :: person :: OLDER_PERSON , "🧓🏻" => crate :: people_and_body :: person :: OLDER_PERSON_LIGHT_SKIN_TONE , "🧓🏼" => crate :: people_and_body :: person :: OLDER_PERSON_MEDIUM_LIGHT_SKIN_TONE , "🧓🏽" => crate :: people_and_body :: person :: OLDER_PERSON_MEDIUM_SKIN_TONE , "🧓🏾" => crate :: people_and_body :: person :: OLDER_PERSON_MEDIUM_DARK_SKIN_TONE , "🧓🏿" => crate :: people_and_body :: person :: OLDER_PERSON_DARK_SKIN_TONE , "👴" => crate :: people_and_body :: person :: OLD_MAN , "👴🏻" => crate :: people_and_body :: person :: OLD_MAN_LIGHT_SKIN_TONE , "👴🏼" => crate :: people_and_body :: person :: OLD_MAN_MEDIUM_LIGHT_SKIN_TONE , "👴🏽" => crate :: people_and_body :: person :: OLD_MAN_MEDIUM_SKIN_TONE , "👴🏾" => crate :: people_and_body :: person :: OLD_MAN_MEDIUM_DARK_SKIN_TONE , "👴🏿" => crate :: people_and_body :: person :: OLD_MAN_DARK_SKIN_TONE , "👵" => crate :: people_and_body :: person :: OLD_WOMAN , "👵🏻" => crate :: people_and_body :: person :: OLD_WOMAN_LIGHT_SKIN_TONE , "👵🏼" => crate :: people_and_body :: person :: OLD_WOMAN_MEDIUM_LIGHT_SKIN_TONE , "👵🏽" => crate :: people_and_body :: person :: OLD_WOMAN_MEDIUM_SKIN_TONE , "👵🏾" => crate :: people_and_body :: person :: OLD_WOMAN_MEDIUM_DARK_SKIN_TONE , "👵🏿" => crate :: people_and_body :: person :: OLD_WOMAN_DARK_SKIN_TONE , "🙍" => crate :: people_and_body :: person_gesture :: PERSON_FROWNING , "🙍🏻" => crate :: people_and_body :: person_gesture :: PERSON_FROWNING_LIGHT_SKIN_TONE , "🙍🏼" => crate :: people_and_body :: person_gesture :: PERSON_FROWNING_MEDIUM_LIGHT_SKIN_TONE , "🙍🏽" => crate :: people_and_body :: person_gesture :: PERSON_FROWNING_MEDIUM_SKIN_TONE , "🙍🏾" => crate :: people_and_body :: person_gesture :: PERSON_FROWNING_MEDIUM_DARK_SKIN_TONE , "🙍🏿" => crate :: people_and_body :: person_gesture :: PERSON_FROWNING_DARK_SKIN_TONE , "🙍\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_FROWNING , "🙍\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_FROWNING , "🙍🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_FROWNING_LIGHT_SKIN_TONE , "🙍🏻\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_FROWNING_LIGHT_SKIN_TONE , "🙍🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_FROWNING_MEDIUM_LIGHT_SKIN_TONE , "🙍🏼\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_FROWNING_MEDIUM_LIGHT_SKIN_TONE , "🙍🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_FROWNING_MEDIUM_SKIN_TONE , "🙍🏽\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_FROWNING_MEDIUM_SKIN_TONE , "🙍🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_FROWNING_MEDIUM_DARK_SKIN_TONE , "🙍🏾\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_FROWNING_MEDIUM_DARK_SKIN_TONE , "🙍🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_FROWNING_DARK_SKIN_TONE , "🙍🏿\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_FROWNING_DARK_SKIN_TONE , "🙍\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_FROWNING , "🙍\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_FROWNING , "🙍🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_FROWNING_LIGHT_SKIN_TONE , "🙍🏻\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_FROWNING_LIGHT_SKIN_TONE , "🙍🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_FROWNING_MEDIUM_LIGHT_SKIN_TONE , "🙍🏼\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_FROWNING_MEDIUM_LIGHT_SKIN_TONE , "🙍🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_FROWNING_MEDIUM_SKIN_TONE , "🙍🏽\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_FROWNING_MEDIUM_SKIN_TONE , "🙍🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_FROWNING_MEDIUM_DARK_SKIN_TONE , "🙍🏾\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_FROWNING_MEDIUM_DARK_SKIN_TONE , "🙍🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_FROWNING_DARK_SKIN_TONE , "🙍🏿\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_FROWNING_DARK_SKIN_TONE , "🙎" => crate :: people_and_body :: person_gesture :: PERSON_POUTING , "🙎🏻" => crate :: people_and_body :: person_gesture :: PERSON_POUTING_LIGHT_SKIN_TONE , "🙎🏼" => crate :: people_and_body :: person_gesture :: PERSON_POUTING_MEDIUM_LIGHT_SKIN_TONE , "🙎🏽" => crate :: people_and_body :: person_gesture :: PERSON_POUTING_MEDIUM_SKIN_TONE , "🙎🏾" => crate :: people_and_body :: person_gesture :: PERSON_POUTING_MEDIUM_DARK_SKIN_TONE , "🙎🏿" => crate :: people_and_body :: person_gesture :: PERSON_POUTING_DARK_SKIN_TONE , "🙎\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_POUTING , "🙎\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_POUTING , "🙎🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_POUTING_LIGHT_SKIN_TONE , "🙎🏻\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_POUTING_LIGHT_SKIN_TONE , "🙎🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_POUTING_MEDIUM_LIGHT_SKIN_TONE , "🙎🏼\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_POUTING_MEDIUM_LIGHT_SKIN_TONE , "🙎🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_POUTING_MEDIUM_SKIN_TONE , "🙎🏽\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_POUTING_MEDIUM_SKIN_TONE , "🙎🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_POUTING_MEDIUM_DARK_SKIN_TONE , "🙎🏾\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_POUTING_MEDIUM_DARK_SKIN_TONE , "🙎🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_POUTING_DARK_SKIN_TONE , "🙎🏿\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_POUTING_DARK_SKIN_TONE , "🙎\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_POUTING , "🙎\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_POUTING , "🙎🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_POUTING_LIGHT_SKIN_TONE , "🙎🏻\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_POUTING_LIGHT_SKIN_TONE , "🙎🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_POUTING_MEDIUM_LIGHT_SKIN_TONE , "🙎🏼\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_POUTING_MEDIUM_LIGHT_SKIN_TONE , "🙎🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_POUTING_MEDIUM_SKIN_TONE , "🙎🏽\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_POUTING_MEDIUM_SKIN_TONE , "🙎🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_POUTING_MEDIUM_DARK_SKIN_TONE , "🙎🏾\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_POUTING_MEDIUM_DARK_SKIN_TONE , "🙎🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_POUTING_DARK_SKIN_TONE , "🙎🏿\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_POUTING_DARK_SKIN_TONE , "🙅" => crate :: people_and_body :: person_gesture :: PERSON_GESTURING_NO , "🙅🏻" => crate :: people_and_body :: person_gesture :: PERSON_GESTURING_NO_LIGHT_SKIN_TONE , "🙅🏼" => crate :: people_and_body :: person_gesture :: PERSON_GESTURING_NO_MEDIUM_LIGHT_SKIN_TONE , "🙅🏽" => crate :: people_and_body :: person_gesture :: PERSON_GESTURING_NO_MEDIUM_SKIN_TONE , "🙅🏾" => crate :: people_and_body :: person_gesture :: PERSON_GESTURING_NO_MEDIUM_DARK_SKIN_TONE , "🙅🏿" => crate :: people_and_body :: person_gesture :: PERSON_GESTURING_NO_DARK_SKIN_TONE , "🙅\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_GESTURING_NO , "🙅\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_GESTURING_NO , "🙅🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_GESTURING_NO_LIGHT_SKIN_TONE , "🙅🏻\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_GESTURING_NO_LIGHT_SKIN_TONE , "🙅🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_GESTURING_NO_MEDIUM_LIGHT_SKIN_TONE , "🙅🏼\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_GESTURING_NO_MEDIUM_LIGHT_SKIN_TONE , "🙅🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_GESTURING_NO_MEDIUM_SKIN_TONE , "🙅🏽\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_GESTURING_NO_MEDIUM_SKIN_TONE , "🙅🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_GESTURING_NO_MEDIUM_DARK_SKIN_TONE , "🙅🏾\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_GESTURING_NO_MEDIUM_DARK_SKIN_TONE , "🙅🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_GESTURING_NO_DARK_SKIN_TONE , "🙅🏿\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_GESTURING_NO_DARK_SKIN_TONE , "🙅\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_GESTURING_NO , "🙅\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_GESTURING_NO , "🙅🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_GESTURING_NO_LIGHT_SKIN_TONE , "🙅🏻\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_GESTURING_NO_LIGHT_SKIN_TONE , "🙅🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_GESTURING_NO_MEDIUM_LIGHT_SKIN_TONE , "🙅🏼\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_GESTURING_NO_MEDIUM_LIGHT_SKIN_TONE , "🙅🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_GESTURING_NO_MEDIUM_SKIN_TONE , "🙅🏽\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_GESTURING_NO_MEDIUM_SKIN_TONE , "🙅🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_GESTURING_NO_MEDIUM_DARK_SKIN_TONE , "🙅🏾\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_GESTURING_NO_MEDIUM_DARK_SKIN_TONE , "🙅🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_GESTURING_NO_DARK_SKIN_TONE , "🙅🏿\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_GESTURING_NO_DARK_SKIN_TONE , "🙆" => crate :: people_and_body :: person_gesture :: PERSON_GESTURING_OK , "🙆🏻" => crate :: people_and_body :: person_gesture :: PERSON_GESTURING_OK_LIGHT_SKIN_TONE , "🙆🏼" => crate :: people_and_body :: person_gesture :: PERSON_GESTURING_OK_MEDIUM_LIGHT_SKIN_TONE , "🙆🏽" => crate :: people_and_body :: person_gesture :: PERSON_GESTURING_OK_MEDIUM_SKIN_TONE , "🙆🏾" => crate :: people_and_body :: person_gesture :: PERSON_GESTURING_OK_MEDIUM_DARK_SKIN_TONE , "🙆🏿" => crate :: people_and_body :: person_gesture :: PERSON_GESTURING_OK_DARK_SKIN_TONE , "🙆\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_GESTURING_OK , "🙆\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_GESTURING_OK , "🙆🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_GESTURING_OK_LIGHT_SKIN_TONE , "🙆🏻\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_GESTURING_OK_LIGHT_SKIN_TONE , "🙆🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_GESTURING_OK_MEDIUM_LIGHT_SKIN_TONE , "🙆🏼\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_GESTURING_OK_MEDIUM_LIGHT_SKIN_TONE , "🙆🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_GESTURING_OK_MEDIUM_SKIN_TONE , "🙆🏽\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_GESTURING_OK_MEDIUM_SKIN_TONE , "🙆🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_GESTURING_OK_MEDIUM_DARK_SKIN_TONE , "🙆🏾\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_GESTURING_OK_MEDIUM_DARK_SKIN_TONE , "🙆🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_GESTURING_OK_DARK_SKIN_TONE , "🙆🏿\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_GESTURING_OK_DARK_SKIN_TONE , "🙆\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_GESTURING_OK , "🙆\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_GESTURING_OK , "🙆🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_GESTURING_OK_LIGHT_SKIN_TONE , "🙆🏻\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_GESTURING_OK_LIGHT_SKIN_TONE , "🙆🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_GESTURING_OK_MEDIUM_LIGHT_SKIN_TONE , "🙆🏼\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_GESTURING_OK_MEDIUM_LIGHT_SKIN_TONE , "🙆🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_GESTURING_OK_MEDIUM_SKIN_TONE , "🙆🏽\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_GESTURING_OK_MEDIUM_SKIN_TONE , "🙆🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_GESTURING_OK_MEDIUM_DARK_SKIN_TONE , "🙆🏾\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_GESTURING_OK_MEDIUM_DARK_SKIN_TONE , "🙆🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_GESTURING_OK_DARK_SKIN_TONE , "🙆🏿\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_GESTURING_OK_DARK_SKIN_TONE , "💁" => crate :: people_and_body :: person_gesture :: PERSON_TIPPING_HAND , "💁🏻" => crate :: people_and_body :: person_gesture :: PERSON_TIPPING_HAND_LIGHT_SKIN_TONE , "💁🏼" => crate :: people_and_body :: person_gesture :: PERSON_TIPPING_HAND_MEDIUM_LIGHT_SKIN_TONE , "💁🏽" => crate :: people_and_body :: person_gesture :: PERSON_TIPPING_HAND_MEDIUM_SKIN_TONE , "💁🏾" => crate :: people_and_body :: person_gesture :: PERSON_TIPPING_HAND_MEDIUM_DARK_SKIN_TONE , "💁🏿" => crate :: people_and_body :: person_gesture :: PERSON_TIPPING_HAND_DARK_SKIN_TONE , "💁\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_TIPPING_HAND , "💁\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_TIPPING_HAND , "💁🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_TIPPING_HAND_LIGHT_SKIN_TONE , "💁🏻\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_TIPPING_HAND_LIGHT_SKIN_TONE , "💁🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_TIPPING_HAND_MEDIUM_LIGHT_SKIN_TONE , "💁🏼\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_TIPPING_HAND_MEDIUM_LIGHT_SKIN_TONE , "💁🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_TIPPING_HAND_MEDIUM_SKIN_TONE , "💁🏽\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_TIPPING_HAND_MEDIUM_SKIN_TONE , "💁🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_TIPPING_HAND_MEDIUM_DARK_SKIN_TONE , "💁🏾\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_TIPPING_HAND_MEDIUM_DARK_SKIN_TONE , "💁🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_TIPPING_HAND_DARK_SKIN_TONE , "💁🏿\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_TIPPING_HAND_DARK_SKIN_TONE , "💁\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_TIPPING_HAND , "💁\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_TIPPING_HAND , "💁🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_TIPPING_HAND_LIGHT_SKIN_TONE , "💁🏻\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_TIPPING_HAND_LIGHT_SKIN_TONE , "💁🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_TIPPING_HAND_MEDIUM_LIGHT_SKIN_TONE , "💁🏼\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_TIPPING_HAND_MEDIUM_LIGHT_SKIN_TONE , "💁🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_TIPPING_HAND_MEDIUM_SKIN_TONE , "💁🏽\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_TIPPING_HAND_MEDIUM_SKIN_TONE , "💁🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_TIPPING_HAND_MEDIUM_DARK_SKIN_TONE , "💁🏾\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_TIPPING_HAND_MEDIUM_DARK_SKIN_TONE , "💁🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_TIPPING_HAND_DARK_SKIN_TONE , "💁🏿\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_TIPPING_HAND_DARK_SKIN_TONE , "🙋" => crate :: people_and_body :: person_gesture :: PERSON_RAISING_HAND , "🙋🏻" => crate :: people_and_body :: person_gesture :: PERSON_RAISING_HAND_LIGHT_SKIN_TONE , "🙋🏼" => crate :: people_and_body :: person_gesture :: PERSON_RAISING_HAND_MEDIUM_LIGHT_SKIN_TONE , "🙋🏽" => crate :: people_and_body :: person_gesture :: PERSON_RAISING_HAND_MEDIUM_SKIN_TONE , "🙋🏾" => crate :: people_and_body :: person_gesture :: PERSON_RAISING_HAND_MEDIUM_DARK_SKIN_TONE , "🙋🏿" => crate :: people_and_body :: person_gesture :: PERSON_RAISING_HAND_DARK_SKIN_TONE , "🙋\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_RAISING_HAND , "🙋\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_RAISING_HAND , "🙋🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_RAISING_HAND_LIGHT_SKIN_TONE , "🙋🏻\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_RAISING_HAND_LIGHT_SKIN_TONE , "🙋🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_RAISING_HAND_MEDIUM_LIGHT_SKIN_TONE , "🙋🏼\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_RAISING_HAND_MEDIUM_LIGHT_SKIN_TONE , "🙋🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_RAISING_HAND_MEDIUM_SKIN_TONE , "🙋🏽\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_RAISING_HAND_MEDIUM_SKIN_TONE , "🙋🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_RAISING_HAND_MEDIUM_DARK_SKIN_TONE , "🙋🏾\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_RAISING_HAND_MEDIUM_DARK_SKIN_TONE , "🙋🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_RAISING_HAND_DARK_SKIN_TONE , "🙋🏿\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_RAISING_HAND_DARK_SKIN_TONE , "🙋\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_RAISING_HAND , "🙋\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_RAISING_HAND , "🙋🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_RAISING_HAND_LIGHT_SKIN_TONE , "🙋🏻\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_RAISING_HAND_LIGHT_SKIN_TONE , "🙋🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_RAISING_HAND_MEDIUM_LIGHT_SKIN_TONE , "🙋🏼\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_RAISING_HAND_MEDIUM_LIGHT_SKIN_TONE , "🙋🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_RAISING_HAND_MEDIUM_SKIN_TONE , "🙋🏽\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_RAISING_HAND_MEDIUM_SKIN_TONE , "🙋🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_RAISING_HAND_MEDIUM_DARK_SKIN_TONE , "🙋🏾\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_RAISING_HAND_MEDIUM_DARK_SKIN_TONE , "🙋🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_RAISING_HAND_DARK_SKIN_TONE , "🙋🏿\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_RAISING_HAND_DARK_SKIN_TONE , "🧏" => crate :: people_and_body :: person_gesture :: DEAF_PERSON , "🧏🏻" => crate :: people_and_body :: person_gesture :: DEAF_PERSON_LIGHT_SKIN_TONE , "🧏🏼" => crate :: people_and_body :: person_gesture :: DEAF_PERSON_MEDIUM_LIGHT_SKIN_TONE , "🧏🏽" => crate :: people_and_body :: person_gesture :: DEAF_PERSON_MEDIUM_SKIN_TONE , "🧏🏾" => crate :: people_and_body :: person_gesture :: DEAF_PERSON_MEDIUM_DARK_SKIN_TONE , "🧏🏿" => crate :: people_and_body :: person_gesture :: DEAF_PERSON_DARK_SKIN_TONE , "🧏\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: DEAF_MAN , "🧏\u{200d}♂" => crate :: people_and_body :: person_gesture :: DEAF_MAN , "🧏🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: DEAF_MAN_LIGHT_SKIN_TONE , "🧏🏻\u{200d}♂" => crate :: people_and_body :: person_gesture :: DEAF_MAN_LIGHT_SKIN_TONE , "🧏🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: DEAF_MAN_MEDIUM_LIGHT_SKIN_TONE , "🧏🏼\u{200d}♂" => crate :: people_and_body :: person_gesture :: DEAF_MAN_MEDIUM_LIGHT_SKIN_TONE , "🧏🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: DEAF_MAN_MEDIUM_SKIN_TONE , "🧏🏽\u{200d}♂" => crate :: people_and_body :: person_gesture :: DEAF_MAN_MEDIUM_SKIN_TONE , "🧏🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: DEAF_MAN_MEDIUM_DARK_SKIN_TONE , "🧏🏾\u{200d}♂" => crate :: people_and_body :: person_gesture :: DEAF_MAN_MEDIUM_DARK_SKIN_TONE , "🧏🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: DEAF_MAN_DARK_SKIN_TONE , "🧏🏿\u{200d}♂" => crate :: people_and_body :: person_gesture :: DEAF_MAN_DARK_SKIN_TONE , "🧏\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: DEAF_WOMAN , "🧏\u{200d}♀" => crate :: people_and_body :: person_gesture :: DEAF_WOMAN , "🧏🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: DEAF_WOMAN_LIGHT_SKIN_TONE , "🧏🏻\u{200d}♀" => crate :: people_and_body :: person_gesture :: DEAF_WOMAN_LIGHT_SKIN_TONE , "🧏🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: DEAF_WOMAN_MEDIUM_LIGHT_SKIN_TONE , "🧏🏼\u{200d}♀" => crate :: people_and_body :: person_gesture :: DEAF_WOMAN_MEDIUM_LIGHT_SKIN_TONE , "🧏🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: DEAF_WOMAN_MEDIUM_SKIN_TONE , "🧏🏽\u{200d}♀" => crate :: people_and_body :: person_gesture :: DEAF_WOMAN_MEDIUM_SKIN_TONE , "🧏🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: DEAF_WOMAN_MEDIUM_DARK_SKIN_TONE , "🧏🏾\u{200d}♀" => crate :: people_and_body :: person_gesture :: DEAF_WOMAN_MEDIUM_DARK_SKIN_TONE , "🧏🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: DEAF_WOMAN_DARK_SKIN_TONE , "🧏🏿\u{200d}♀" => crate :: people_and_body :: person_gesture :: DEAF_WOMAN_DARK_SKIN_TONE , "🙇" => crate :: people_and_body :: person_gesture :: PERSON_BOWING , "🙇🏻" => crate :: people_and_body :: person_gesture :: PERSON_BOWING_LIGHT_SKIN_TONE , "🙇🏼" => crate :: people_and_body :: person_gesture :: PERSON_BOWING_MEDIUM_LIGHT_SKIN_TONE , "🙇🏽" => crate :: people_and_body :: person_gesture :: PERSON_BOWING_MEDIUM_SKIN_TONE , "🙇🏾" => crate :: people_and_body :: person_gesture :: PERSON_BOWING_MEDIUM_DARK_SKIN_TONE , "🙇🏿" => crate :: people_and_body :: person_gesture :: PERSON_BOWING_DARK_SKIN_TONE , "🙇\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_BOWING , "🙇\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_BOWING , "🙇🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_BOWING_LIGHT_SKIN_TONE , "🙇🏻\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_BOWING_LIGHT_SKIN_TONE , "🙇🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_BOWING_MEDIUM_LIGHT_SKIN_TONE , "🙇🏼\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_BOWING_MEDIUM_LIGHT_SKIN_TONE , "🙇🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_BOWING_MEDIUM_SKIN_TONE , "🙇🏽\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_BOWING_MEDIUM_SKIN_TONE , "🙇🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_BOWING_MEDIUM_DARK_SKIN_TONE , "🙇🏾\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_BOWING_MEDIUM_DARK_SKIN_TONE , "🙇🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_BOWING_DARK_SKIN_TONE , "🙇🏿\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_BOWING_DARK_SKIN_TONE , "🙇\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_BOWING , "🙇\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_BOWING , "🙇🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_BOWING_LIGHT_SKIN_TONE , "🙇🏻\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_BOWING_LIGHT_SKIN_TONE , "🙇🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_BOWING_MEDIUM_LIGHT_SKIN_TONE , "🙇🏼\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_BOWING_MEDIUM_LIGHT_SKIN_TONE , "🙇🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_BOWING_MEDIUM_SKIN_TONE , "🙇🏽\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_BOWING_MEDIUM_SKIN_TONE , "🙇🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_BOWING_MEDIUM_DARK_SKIN_TONE , "🙇🏾\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_BOWING_MEDIUM_DARK_SKIN_TONE , "🙇🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_BOWING_DARK_SKIN_TONE , "🙇🏿\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_BOWING_DARK_SKIN_TONE , "🤦" => crate :: people_and_body :: person_gesture :: PERSON_FACEPALMING , "🤦🏻" => crate :: people_and_body :: person_gesture :: PERSON_FACEPALMING_LIGHT_SKIN_TONE , "🤦🏼" => crate :: people_and_body :: person_gesture :: PERSON_FACEPALMING_MEDIUM_LIGHT_SKIN_TONE , "🤦🏽" => crate :: people_and_body :: person_gesture :: PERSON_FACEPALMING_MEDIUM_SKIN_TONE , "🤦🏾" => crate :: people_and_body :: person_gesture :: PERSON_FACEPALMING_MEDIUM_DARK_SKIN_TONE , "🤦🏿" => crate :: people_and_body :: person_gesture :: PERSON_FACEPALMING_DARK_SKIN_TONE , "🤦\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_FACEPALMING , "🤦\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_FACEPALMING , "🤦🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_FACEPALMING_LIGHT_SKIN_TONE , "🤦🏻\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_FACEPALMING_LIGHT_SKIN_TONE , "🤦🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_FACEPALMING_MEDIUM_LIGHT_SKIN_TONE , "🤦🏼\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_FACEPALMING_MEDIUM_LIGHT_SKIN_TONE , "🤦🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_FACEPALMING_MEDIUM_SKIN_TONE , "🤦🏽\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_FACEPALMING_MEDIUM_SKIN_TONE , "🤦🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_FACEPALMING_MEDIUM_DARK_SKIN_TONE , "🤦🏾\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_FACEPALMING_MEDIUM_DARK_SKIN_TONE , "🤦🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_FACEPALMING_DARK_SKIN_TONE , "🤦🏿\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_FACEPALMING_DARK_SKIN_TONE , "🤦\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_FACEPALMING , "🤦\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_FACEPALMING , "🤦🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_FACEPALMING_LIGHT_SKIN_TONE , "🤦🏻\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_FACEPALMING_LIGHT_SKIN_TONE , "🤦🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_FACEPALMING_MEDIUM_LIGHT_SKIN_TONE , "🤦🏼\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_FACEPALMING_MEDIUM_LIGHT_SKIN_TONE , "🤦🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_FACEPALMING_MEDIUM_SKIN_TONE , "🤦🏽\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_FACEPALMING_MEDIUM_SKIN_TONE , "🤦🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_FACEPALMING_MEDIUM_DARK_SKIN_TONE , "🤦🏾\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_FACEPALMING_MEDIUM_DARK_SKIN_TONE , "🤦🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_FACEPALMING_DARK_SKIN_TONE , "🤦🏿\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_FACEPALMING_DARK_SKIN_TONE , "🤷" => crate :: people_and_body :: person_gesture :: PERSON_SHRUGGING , "🤷🏻" => crate :: people_and_body :: person_gesture :: PERSON_SHRUGGING_LIGHT_SKIN_TONE , "🤷🏼" => crate :: people_and_body :: person_gesture :: PERSON_SHRUGGING_MEDIUM_LIGHT_SKIN_TONE , "🤷🏽" => crate :: people_and_body :: person_gesture :: PERSON_SHRUGGING_MEDIUM_SKIN_TONE , "🤷🏾" => crate :: people_and_body :: person_gesture :: PERSON_SHRUGGING_MEDIUM_DARK_SKIN_TONE , "🤷🏿" => crate :: people_and_body :: person_gesture :: PERSON_SHRUGGING_DARK_SKIN_TONE , "🤷\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_SHRUGGING , "🤷\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_SHRUGGING , "🤷🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_SHRUGGING_LIGHT_SKIN_TONE , "🤷🏻\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_SHRUGGING_LIGHT_SKIN_TONE , "🤷🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_SHRUGGING_MEDIUM_LIGHT_SKIN_TONE , "🤷🏼\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_SHRUGGING_MEDIUM_LIGHT_SKIN_TONE , "🤷🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_SHRUGGING_MEDIUM_SKIN_TONE , "🤷🏽\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_SHRUGGING_MEDIUM_SKIN_TONE , "🤷🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_SHRUGGING_MEDIUM_DARK_SKIN_TONE , "🤷🏾\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_SHRUGGING_MEDIUM_DARK_SKIN_TONE , "🤷🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_gesture :: MAN_SHRUGGING_DARK_SKIN_TONE , "🤷🏿\u{200d}♂" => crate :: people_and_body :: person_gesture :: MAN_SHRUGGING_DARK_SKIN_TONE , "🤷\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_SHRUGGING , "🤷\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_SHRUGGING , "🤷🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_SHRUGGING_LIGHT_SKIN_TONE , "🤷🏻\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_SHRUGGING_LIGHT_SKIN_TONE , "🤷🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_SHRUGGING_MEDIUM_LIGHT_SKIN_TONE , "🤷🏼\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_SHRUGGING_MEDIUM_LIGHT_SKIN_TONE , "🤷🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_SHRUGGING_MEDIUM_SKIN_TONE , "🤷🏽\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_SHRUGGING_MEDIUM_SKIN_TONE , "🤷🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_SHRUGGING_MEDIUM_DARK_SKIN_TONE , "🤷🏾\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_SHRUGGING_MEDIUM_DARK_SKIN_TONE , "🤷🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_gesture :: WOMAN_SHRUGGING_DARK_SKIN_TONE , "🤷🏿\u{200d}♀" => crate :: people_and_body :: person_gesture :: WOMAN_SHRUGGING_DARK_SKIN_TONE , "🧑\u{200d}⚕\u{fe0f}" => crate :: people_and_body :: person_role :: HEALTH_WORKER , "🧑\u{200d}⚕" => crate :: people_and_body :: person_role :: HEALTH_WORKER , "🧑🏻\u{200d}⚕\u{fe0f}" => crate :: people_and_body :: person_role :: HEALTH_WORKER_LIGHT_SKIN_TONE , "🧑🏻\u{200d}⚕" => crate :: people_and_body :: person_role :: HEALTH_WORKER_LIGHT_SKIN_TONE , "🧑🏼\u{200d}⚕\u{fe0f}" => crate :: people_and_body :: person_role :: HEALTH_WORKER_MEDIUM_LIGHT_SKIN_TONE , "🧑🏼\u{200d}⚕" => crate :: people_and_body :: person_role :: HEALTH_WORKER_MEDIUM_LIGHT_SKIN_TONE , "🧑🏽\u{200d}⚕\u{fe0f}" => crate :: people_and_body :: person_role :: HEALTH_WORKER_MEDIUM_SKIN_TONE , "🧑🏽\u{200d}⚕" => crate :: people_and_body :: person_role :: HEALTH_WORKER_MEDIUM_SKIN_TONE , "🧑🏾\u{200d}⚕\u{fe0f}" => crate :: people_and_body :: person_role :: HEALTH_WORKER_MEDIUM_DARK_SKIN_TONE , "🧑🏾\u{200d}⚕" => crate :: people_and_body :: person_role :: HEALTH_WORKER_MEDIUM_DARK_SKIN_TONE , "🧑🏿\u{200d}⚕\u{fe0f}" => crate :: people_and_body :: person_role :: HEALTH_WORKER_DARK_SKIN_TONE , "🧑🏿\u{200d}⚕" => crate :: people_and_body :: person_role :: HEALTH_WORKER_DARK_SKIN_TONE , "👨\u{200d}⚕\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_HEALTH_WORKER , "👨\u{200d}⚕" => crate :: people_and_body :: person_role :: MAN_HEALTH_WORKER , "👨🏻\u{200d}⚕\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_HEALTH_WORKER_LIGHT_SKIN_TONE , "👨🏻\u{200d}⚕" => crate :: people_and_body :: person_role :: MAN_HEALTH_WORKER_LIGHT_SKIN_TONE , "👨🏼\u{200d}⚕\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_HEALTH_WORKER_MEDIUM_LIGHT_SKIN_TONE , "👨🏼\u{200d}⚕" => crate :: people_and_body :: person_role :: MAN_HEALTH_WORKER_MEDIUM_LIGHT_SKIN_TONE , "👨🏽\u{200d}⚕\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_HEALTH_WORKER_MEDIUM_SKIN_TONE , "👨🏽\u{200d}⚕" => crate :: people_and_body :: person_role :: MAN_HEALTH_WORKER_MEDIUM_SKIN_TONE , "👨🏾\u{200d}⚕\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_HEALTH_WORKER_MEDIUM_DARK_SKIN_TONE , "👨🏾\u{200d}⚕" => crate :: people_and_body :: person_role :: MAN_HEALTH_WORKER_MEDIUM_DARK_SKIN_TONE , "👨🏿\u{200d}⚕\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_HEALTH_WORKER_DARK_SKIN_TONE , "👨🏿\u{200d}⚕" => crate :: people_and_body :: person_role :: MAN_HEALTH_WORKER_DARK_SKIN_TONE , "👩\u{200d}⚕\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_HEALTH_WORKER , "👩\u{200d}⚕" => crate :: people_and_body :: person_role :: WOMAN_HEALTH_WORKER , "👩🏻\u{200d}⚕\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_HEALTH_WORKER_LIGHT_SKIN_TONE , "👩🏻\u{200d}⚕" => crate :: people_and_body :: person_role :: WOMAN_HEALTH_WORKER_LIGHT_SKIN_TONE , "👩🏼\u{200d}⚕\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_HEALTH_WORKER_MEDIUM_LIGHT_SKIN_TONE , "👩🏼\u{200d}⚕" => crate :: people_and_body :: person_role :: WOMAN_HEALTH_WORKER_MEDIUM_LIGHT_SKIN_TONE , "👩🏽\u{200d}⚕\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_HEALTH_WORKER_MEDIUM_SKIN_TONE , "👩🏽\u{200d}⚕" => crate :: people_and_body :: person_role :: WOMAN_HEALTH_WORKER_MEDIUM_SKIN_TONE , "👩🏾\u{200d}⚕\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_HEALTH_WORKER_MEDIUM_DARK_SKIN_TONE , "👩🏾\u{200d}⚕" => crate :: people_and_body :: person_role :: WOMAN_HEALTH_WORKER_MEDIUM_DARK_SKIN_TONE , "👩🏿\u{200d}⚕\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_HEALTH_WORKER_DARK_SKIN_TONE , "👩🏿\u{200d}⚕" => crate :: people_and_body :: person_role :: WOMAN_HEALTH_WORKER_DARK_SKIN_TONE , "🧑\u{200d}🎓" => crate :: people_and_body :: person_role :: STUDENT , "🧑🏻\u{200d}🎓" => crate :: people_and_body :: person_role :: STUDENT_LIGHT_SKIN_TONE , "🧑🏼\u{200d}🎓" => crate :: people_and_body :: person_role :: STUDENT_MEDIUM_LIGHT_SKIN_TONE , "🧑🏽\u{200d}🎓" => crate :: people_and_body :: person_role :: STUDENT_MEDIUM_SKIN_TONE , "🧑🏾\u{200d}🎓" => crate :: people_and_body :: person_role :: STUDENT_MEDIUM_DARK_SKIN_TONE , "🧑🏿\u{200d}🎓" => crate :: people_and_body :: person_role :: STUDENT_DARK_SKIN_TONE , "👨\u{200d}🎓" => crate :: people_and_body :: person_role :: MAN_STUDENT , "👨🏻\u{200d}🎓" => crate :: people_and_body :: person_role :: MAN_STUDENT_LIGHT_SKIN_TONE , "👨🏼\u{200d}🎓" => crate :: people_and_body :: person_role :: MAN_STUDENT_MEDIUM_LIGHT_SKIN_TONE , "👨🏽\u{200d}🎓" => crate :: people_and_body :: person_role :: MAN_STUDENT_MEDIUM_SKIN_TONE , "👨🏾\u{200d}🎓" => crate :: people_and_body :: person_role :: MAN_STUDENT_MEDIUM_DARK_SKIN_TONE , "👨🏿\u{200d}🎓" => crate :: people_and_body :: person_role :: MAN_STUDENT_DARK_SKIN_TONE , "👩\u{200d}🎓" => crate :: people_and_body :: person_role :: WOMAN_STUDENT , "👩🏻\u{200d}🎓" => crate :: people_and_body :: person_role :: WOMAN_STUDENT_LIGHT_SKIN_TONE , "👩🏼\u{200d}🎓" => crate :: people_and_body :: person_role :: WOMAN_STUDENT_MEDIUM_LIGHT_SKIN_TONE , "👩🏽\u{200d}🎓" => crate :: people_and_body :: person_role :: WOMAN_STUDENT_MEDIUM_SKIN_TONE , "👩🏾\u{200d}🎓" => crate :: people_and_body :: person_role :: WOMAN_STUDENT_MEDIUM_DARK_SKIN_TONE , "👩🏿\u{200d}🎓" => crate :: people_and_body :: person_role :: WOMAN_STUDENT_DARK_SKIN_TONE , "🧑\u{200d}🏫" => crate :: people_and_body :: person_role :: TEACHER , "🧑🏻\u{200d}🏫" => crate :: people_and_body :: person_role :: TEACHER_LIGHT_SKIN_TONE , "🧑🏼\u{200d}🏫" => crate :: people_and_body :: person_role :: TEACHER_MEDIUM_LIGHT_SKIN_TONE , "🧑🏽\u{200d}🏫" => crate :: people_and_body :: person_role :: TEACHER_MEDIUM_SKIN_TONE , "🧑🏾\u{200d}🏫" => crate :: people_and_body :: person_role :: TEACHER_MEDIUM_DARK_SKIN_TONE , "🧑🏿\u{200d}🏫" => crate :: people_and_body :: person_role :: TEACHER_DARK_SKIN_TONE , "👨\u{200d}🏫" => crate :: people_and_body :: person_role :: MAN_TEACHER , "👨🏻\u{200d}🏫" => crate :: people_and_body :: person_role :: MAN_TEACHER_LIGHT_SKIN_TONE , "👨🏼\u{200d}🏫" => crate :: people_and_body :: person_role :: MAN_TEACHER_MEDIUM_LIGHT_SKIN_TONE , "👨🏽\u{200d}🏫" => crate :: people_and_body :: person_role :: MAN_TEACHER_MEDIUM_SKIN_TONE , "👨🏾\u{200d}🏫" => crate :: people_and_body :: person_role :: MAN_TEACHER_MEDIUM_DARK_SKIN_TONE , "👨🏿\u{200d}🏫" => crate :: people_and_body :: person_role :: MAN_TEACHER_DARK_SKIN_TONE , "👩\u{200d}🏫" => crate :: people_and_body :: person_role :: WOMAN_TEACHER , "👩🏻\u{200d}🏫" => crate :: people_and_body :: person_role :: WOMAN_TEACHER_LIGHT_SKIN_TONE , "👩🏼\u{200d}🏫" => crate :: people_and_body :: person_role :: WOMAN_TEACHER_MEDIUM_LIGHT_SKIN_TONE , "👩🏽\u{200d}🏫" => crate :: people_and_body :: person_role :: WOMAN_TEACHER_MEDIUM_SKIN_TONE , "👩🏾\u{200d}🏫" => crate :: people_and_body :: person_role :: WOMAN_TEACHER_MEDIUM_DARK_SKIN_TONE , "👩🏿\u{200d}🏫" => crate :: people_and_body :: person_role :: WOMAN_TEACHER_DARK_SKIN_TONE , "🧑\u{200d}⚖\u{fe0f}" => crate :: people_and_body :: person_role :: JUDGE , "🧑\u{200d}⚖" => crate :: people_and_body :: person_role :: JUDGE , "🧑🏻\u{200d}⚖\u{fe0f}" => crate :: people_and_body :: person_role :: JUDGE_LIGHT_SKIN_TONE , "🧑🏻\u{200d}⚖" => crate :: people_and_body :: person_role :: JUDGE_LIGHT_SKIN_TONE , "🧑🏼\u{200d}⚖\u{fe0f}" => crate :: people_and_body :: person_role :: JUDGE_MEDIUM_LIGHT_SKIN_TONE , "🧑🏼\u{200d}⚖" => crate :: people_and_body :: person_role :: JUDGE_MEDIUM_LIGHT_SKIN_TONE , "🧑🏽\u{200d}⚖\u{fe0f}" => crate :: people_and_body :: person_role :: JUDGE_MEDIUM_SKIN_TONE , "🧑🏽\u{200d}⚖" => crate :: people_and_body :: person_role :: JUDGE_MEDIUM_SKIN_TONE , "🧑🏾\u{200d}⚖\u{fe0f}" => crate :: people_and_body :: person_role :: JUDGE_MEDIUM_DARK_SKIN_TONE , "🧑🏾\u{200d}⚖" => crate :: people_and_body :: person_role :: JUDGE_MEDIUM_DARK_SKIN_TONE , "🧑🏿\u{200d}⚖\u{fe0f}" => crate :: people_and_body :: person_role :: JUDGE_DARK_SKIN_TONE , "🧑🏿\u{200d}⚖" => crate :: people_and_body :: person_role :: JUDGE_DARK_SKIN_TONE , "👨\u{200d}⚖\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_JUDGE , "👨\u{200d}⚖" => crate :: people_and_body :: person_role :: MAN_JUDGE , "👨🏻\u{200d}⚖\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_JUDGE_LIGHT_SKIN_TONE , "👨🏻\u{200d}⚖" => crate :: people_and_body :: person_role :: MAN_JUDGE_LIGHT_SKIN_TONE , "👨🏼\u{200d}⚖\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_JUDGE_MEDIUM_LIGHT_SKIN_TONE , "👨🏼\u{200d}⚖" => crate :: people_and_body :: person_role :: MAN_JUDGE_MEDIUM_LIGHT_SKIN_TONE , "👨🏽\u{200d}⚖\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_JUDGE_MEDIUM_SKIN_TONE , "👨🏽\u{200d}⚖" => crate :: people_and_body :: person_role :: MAN_JUDGE_MEDIUM_SKIN_TONE , "👨🏾\u{200d}⚖\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_JUDGE_MEDIUM_DARK_SKIN_TONE , "👨🏾\u{200d}⚖" => crate :: people_and_body :: person_role :: MAN_JUDGE_MEDIUM_DARK_SKIN_TONE , "👨🏿\u{200d}⚖\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_JUDGE_DARK_SKIN_TONE , "👨🏿\u{200d}⚖" => crate :: people_and_body :: person_role :: MAN_JUDGE_DARK_SKIN_TONE , "👩\u{200d}⚖\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_JUDGE , "👩\u{200d}⚖" => crate :: people_and_body :: person_role :: WOMAN_JUDGE , "👩🏻\u{200d}⚖\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_JUDGE_LIGHT_SKIN_TONE , "👩🏻\u{200d}⚖" => crate :: people_and_body :: person_role :: WOMAN_JUDGE_LIGHT_SKIN_TONE , "👩🏼\u{200d}⚖\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_JUDGE_MEDIUM_LIGHT_SKIN_TONE , "👩🏼\u{200d}⚖" => crate :: people_and_body :: person_role :: WOMAN_JUDGE_MEDIUM_LIGHT_SKIN_TONE , "👩🏽\u{200d}⚖\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_JUDGE_MEDIUM_SKIN_TONE , "👩🏽\u{200d}⚖" => crate :: people_and_body :: person_role :: WOMAN_JUDGE_MEDIUM_SKIN_TONE , "👩🏾\u{200d}⚖\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_JUDGE_MEDIUM_DARK_SKIN_TONE , "👩🏾\u{200d}⚖" => crate :: people_and_body :: person_role :: WOMAN_JUDGE_MEDIUM_DARK_SKIN_TONE , "👩🏿\u{200d}⚖\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_JUDGE_DARK_SKIN_TONE , "👩🏿\u{200d}⚖" => crate :: people_and_body :: person_role :: WOMAN_JUDGE_DARK_SKIN_TONE , "🧑\u{200d}🌾" => crate :: people_and_body :: person_role :: FARMER , "🧑🏻\u{200d}🌾" => crate :: people_and_body :: person_role :: FARMER_LIGHT_SKIN_TONE , "🧑🏼\u{200d}🌾" => crate :: people_and_body :: person_role :: FARMER_MEDIUM_LIGHT_SKIN_TONE , "🧑🏽\u{200d}🌾" => crate :: people_and_body :: person_role :: FARMER_MEDIUM_SKIN_TONE , "🧑🏾\u{200d}🌾" => crate :: people_and_body :: person_role :: FARMER_MEDIUM_DARK_SKIN_TONE , "🧑🏿\u{200d}🌾" => crate :: people_and_body :: person_role :: FARMER_DARK_SKIN_TONE , "👨\u{200d}🌾" => crate :: people_and_body :: person_role :: MAN_FARMER , "👨🏻\u{200d}🌾" => crate :: people_and_body :: person_role :: MAN_FARMER_LIGHT_SKIN_TONE , "👨🏼\u{200d}🌾" => crate :: people_and_body :: person_role :: MAN_FARMER_MEDIUM_LIGHT_SKIN_TONE , "👨🏽\u{200d}🌾" => crate :: people_and_body :: person_role :: MAN_FARMER_MEDIUM_SKIN_TONE , "👨🏾\u{200d}🌾" => crate :: people_and_body :: person_role :: MAN_FARMER_MEDIUM_DARK_SKIN_TONE , "👨🏿\u{200d}🌾" => crate :: people_and_body :: person_role :: MAN_FARMER_DARK_SKIN_TONE , "👩\u{200d}🌾" => crate :: people_and_body :: person_role :: WOMAN_FARMER , "👩🏻\u{200d}🌾" => crate :: people_and_body :: person_role :: WOMAN_FARMER_LIGHT_SKIN_TONE , "👩🏼\u{200d}🌾" => crate :: people_and_body :: person_role :: WOMAN_FARMER_MEDIUM_LIGHT_SKIN_TONE , "👩🏽\u{200d}🌾" => crate :: people_and_body :: person_role :: WOMAN_FARMER_MEDIUM_SKIN_TONE , "👩🏾\u{200d}🌾" => crate :: people_and_body :: person_role :: WOMAN_FARMER_MEDIUM_DARK_SKIN_TONE , "👩🏿\u{200d}🌾" => crate :: people_and_body :: person_role :: WOMAN_FARMER_DARK_SKIN_TONE , "🧑\u{200d}🍳" => crate :: people_and_body :: person_role :: COOK , "🧑🏻\u{200d}🍳" => crate :: people_and_body :: person_role :: COOK_LIGHT_SKIN_TONE , "🧑🏼\u{200d}🍳" => crate :: people_and_body :: person_role :: COOK_MEDIUM_LIGHT_SKIN_TONE , "🧑🏽\u{200d}🍳" => crate :: people_and_body :: person_role :: COOK_MEDIUM_SKIN_TONE , "🧑🏾\u{200d}🍳" => crate :: people_and_body :: person_role :: COOK_MEDIUM_DARK_SKIN_TONE , "🧑🏿\u{200d}🍳" => crate :: people_and_body :: person_role :: COOK_DARK_SKIN_TONE , "👨\u{200d}🍳" => crate :: people_and_body :: person_role :: MAN_COOK , "👨🏻\u{200d}🍳" => crate :: people_and_body :: person_role :: MAN_COOK_LIGHT_SKIN_TONE , "👨🏼\u{200d}🍳" => crate :: people_and_body :: person_role :: MAN_COOK_MEDIUM_LIGHT_SKIN_TONE , "👨🏽\u{200d}🍳" => crate :: people_and_body :: person_role :: MAN_COOK_MEDIUM_SKIN_TONE , "👨🏾\u{200d}🍳" => crate :: people_and_body :: person_role :: MAN_COOK_MEDIUM_DARK_SKIN_TONE , "👨🏿\u{200d}🍳" => crate :: people_and_body :: person_role :: MAN_COOK_DARK_SKIN_TONE , "👩\u{200d}🍳" => crate :: people_and_body :: person_role :: WOMAN_COOK , "👩🏻\u{200d}🍳" => crate :: people_and_body :: person_role :: WOMAN_COOK_LIGHT_SKIN_TONE , "👩🏼\u{200d}🍳" => crate :: people_and_body :: person_role :: WOMAN_COOK_MEDIUM_LIGHT_SKIN_TONE , "👩🏽\u{200d}🍳" => crate :: people_and_body :: person_role :: WOMAN_COOK_MEDIUM_SKIN_TONE , "👩🏾\u{200d}🍳" => crate :: people_and_body :: person_role :: WOMAN_COOK_MEDIUM_DARK_SKIN_TONE , "👩🏿\u{200d}🍳" => crate :: people_and_body :: person_role :: WOMAN_COOK_DARK_SKIN_TONE , "🧑\u{200d}🔧" => crate :: people_and_body :: person_role :: MECHANIC , "🧑🏻\u{200d}🔧" => crate :: people_and_body :: person_role :: MECHANIC_LIGHT_SKIN_TONE , "🧑🏼\u{200d}🔧" => crate :: people_and_body :: person_role :: MECHANIC_MEDIUM_LIGHT_SKIN_TONE , "🧑🏽\u{200d}🔧" => crate :: people_and_body :: person_role :: MECHANIC_MEDIUM_SKIN_TONE , "🧑🏾\u{200d}🔧" => crate :: people_and_body :: person_role :: MECHANIC_MEDIUM_DARK_SKIN_TONE , "🧑🏿\u{200d}🔧" => crate :: people_and_body :: person_role :: MECHANIC_DARK_SKIN_TONE , "👨\u{200d}🔧" => crate :: people_and_body :: person_role :: MAN_MECHANIC , "👨🏻\u{200d}🔧" => crate :: people_and_body :: person_role :: MAN_MECHANIC_LIGHT_SKIN_TONE , "👨🏼\u{200d}🔧" => crate :: people_and_body :: person_role :: MAN_MECHANIC_MEDIUM_LIGHT_SKIN_TONE , "👨🏽\u{200d}🔧" => crate :: people_and_body :: person_role :: MAN_MECHANIC_MEDIUM_SKIN_TONE , "👨🏾\u{200d}🔧" => crate :: people_and_body :: person_role :: MAN_MECHANIC_MEDIUM_DARK_SKIN_TONE , "👨🏿\u{200d}🔧" => crate :: people_and_body :: person_role :: MAN_MECHANIC_DARK_SKIN_TONE , "👩\u{200d}🔧" => crate :: people_and_body :: person_role :: WOMAN_MECHANIC , "👩🏻\u{200d}🔧" => crate :: people_and_body :: person_role :: WOMAN_MECHANIC_LIGHT_SKIN_TONE , "👩🏼\u{200d}🔧" => crate :: people_and_body :: person_role :: WOMAN_MECHANIC_MEDIUM_LIGHT_SKIN_TONE , "👩🏽\u{200d}🔧" => crate :: people_and_body :: person_role :: WOMAN_MECHANIC_MEDIUM_SKIN_TONE , "👩🏾\u{200d}🔧" => crate :: people_and_body :: person_role :: WOMAN_MECHANIC_MEDIUM_DARK_SKIN_TONE , "👩🏿\u{200d}🔧" => crate :: people_and_body :: person_role :: WOMAN_MECHANIC_DARK_SKIN_TONE , "🧑\u{200d}🏭" => crate :: people_and_body :: person_role :: FACTORY_WORKER , "🧑🏻\u{200d}🏭" => crate :: people_and_body :: person_role :: FACTORY_WORKER_LIGHT_SKIN_TONE , "🧑🏼\u{200d}🏭" => crate :: people_and_body :: person_role :: FACTORY_WORKER_MEDIUM_LIGHT_SKIN_TONE , "🧑🏽\u{200d}🏭" => crate :: people_and_body :: person_role :: FACTORY_WORKER_MEDIUM_SKIN_TONE , "🧑🏾\u{200d}🏭" => crate :: people_and_body :: person_role :: FACTORY_WORKER_MEDIUM_DARK_SKIN_TONE , "🧑🏿\u{200d}🏭" => crate :: people_and_body :: person_role :: FACTORY_WORKER_DARK_SKIN_TONE , "👨\u{200d}🏭" => crate :: people_and_body :: person_role :: MAN_FACTORY_WORKER , "👨🏻\u{200d}🏭" => crate :: people_and_body :: person_role :: MAN_FACTORY_WORKER_LIGHT_SKIN_TONE , "👨🏼\u{200d}🏭" => crate :: people_and_body :: person_role :: MAN_FACTORY_WORKER_MEDIUM_LIGHT_SKIN_TONE , "👨🏽\u{200d}🏭" => crate :: people_and_body :: person_role :: MAN_FACTORY_WORKER_MEDIUM_SKIN_TONE , "👨🏾\u{200d}🏭" => crate :: people_and_body :: person_role :: MAN_FACTORY_WORKER_MEDIUM_DARK_SKIN_TONE , "👨🏿\u{200d}🏭" => crate :: people_and_body :: person_role :: MAN_FACTORY_WORKER_DARK_SKIN_TONE , "👩\u{200d}🏭" => crate :: people_and_body :: person_role :: WOMAN_FACTORY_WORKER , "👩🏻\u{200d}🏭" => crate :: people_and_body :: person_role :: WOMAN_FACTORY_WORKER_LIGHT_SKIN_TONE , "👩🏼\u{200d}🏭" => crate :: people_and_body :: person_role :: WOMAN_FACTORY_WORKER_MEDIUM_LIGHT_SKIN_TONE , "👩🏽\u{200d}🏭" => crate :: people_and_body :: person_role :: WOMAN_FACTORY_WORKER_MEDIUM_SKIN_TONE , "👩🏾\u{200d}🏭" => crate :: people_and_body :: person_role :: WOMAN_FACTORY_WORKER_MEDIUM_DARK_SKIN_TONE , "👩🏿\u{200d}🏭" => crate :: people_and_body :: person_role :: WOMAN_FACTORY_WORKER_DARK_SKIN_TONE , "🧑\u{200d}💼" => crate :: people_and_body :: person_role :: OFFICE_WORKER , "🧑🏻\u{200d}💼" => crate :: people_and_body :: person_role :: OFFICE_WORKER_LIGHT_SKIN_TONE , "🧑🏼\u{200d}💼" => crate :: people_and_body :: person_role :: OFFICE_WORKER_MEDIUM_LIGHT_SKIN_TONE , "🧑🏽\u{200d}💼" => crate :: people_and_body :: person_role :: OFFICE_WORKER_MEDIUM_SKIN_TONE , "🧑🏾\u{200d}💼" => crate :: people_and_body :: person_role :: OFFICE_WORKER_MEDIUM_DARK_SKIN_TONE , "🧑🏿\u{200d}💼" => crate :: people_and_body :: person_role :: OFFICE_WORKER_DARK_SKIN_TONE , "👨\u{200d}💼" => crate :: people_and_body :: person_role :: MAN_OFFICE_WORKER , "👨🏻\u{200d}💼" => crate :: people_and_body :: person_role :: MAN_OFFICE_WORKER_LIGHT_SKIN_TONE , "👨🏼\u{200d}💼" => crate :: people_and_body :: person_role :: MAN_OFFICE_WORKER_MEDIUM_LIGHT_SKIN_TONE , "👨🏽\u{200d}💼" => crate :: people_and_body :: person_role :: MAN_OFFICE_WORKER_MEDIUM_SKIN_TONE , "👨🏾\u{200d}💼" => crate :: people_and_body :: person_role :: MAN_OFFICE_WORKER_MEDIUM_DARK_SKIN_TONE , "👨🏿\u{200d}💼" => crate :: people_and_body :: person_role :: MAN_OFFICE_WORKER_DARK_SKIN_TONE , "👩\u{200d}💼" => crate :: people_and_body :: person_role :: WOMAN_OFFICE_WORKER , "👩🏻\u{200d}💼" => crate :: people_and_body :: person_role :: WOMAN_OFFICE_WORKER_LIGHT_SKIN_TONE , "👩🏼\u{200d}💼" => crate :: people_and_body :: person_role :: WOMAN_OFFICE_WORKER_MEDIUM_LIGHT_SKIN_TONE , "👩🏽\u{200d}💼" => crate :: people_and_body :: person_role :: WOMAN_OFFICE_WORKER_MEDIUM_SKIN_TONE , "👩🏾\u{200d}💼" => crate :: people_and_body :: person_role :: WOMAN_OFFICE_WORKER_MEDIUM_DARK_SKIN_TONE , "👩🏿\u{200d}💼" => crate :: people_and_body :: person_role :: WOMAN_OFFICE_WORKER_DARK_SKIN_TONE , "🧑\u{200d}🔬" => crate :: people_and_body :: person_role :: SCIENTIST , "🧑🏻\u{200d}🔬" => crate :: people_and_body :: person_role :: SCIENTIST_LIGHT_SKIN_TONE , "🧑🏼\u{200d}🔬" => crate :: people_and_body :: person_role :: SCIENTIST_MEDIUM_LIGHT_SKIN_TONE , "🧑🏽\u{200d}🔬" => crate :: people_and_body :: person_role :: SCIENTIST_MEDIUM_SKIN_TONE , "🧑🏾\u{200d}🔬" => crate :: people_and_body :: person_role :: SCIENTIST_MEDIUM_DARK_SKIN_TONE , "🧑🏿\u{200d}🔬" => crate :: people_and_body :: person_role :: SCIENTIST_DARK_SKIN_TONE , "👨\u{200d}🔬" => crate :: people_and_body :: person_role :: MAN_SCIENTIST , "👨🏻\u{200d}🔬" => crate :: people_and_body :: person_role :: MAN_SCIENTIST_LIGHT_SKIN_TONE , "👨🏼\u{200d}🔬" => crate :: people_and_body :: person_role :: MAN_SCIENTIST_MEDIUM_LIGHT_SKIN_TONE , "👨🏽\u{200d}🔬" => crate :: people_and_body :: person_role :: MAN_SCIENTIST_MEDIUM_SKIN_TONE , "👨🏾\u{200d}🔬" => crate :: people_and_body :: person_role :: MAN_SCIENTIST_MEDIUM_DARK_SKIN_TONE , "👨🏿\u{200d}🔬" => crate :: people_and_body :: person_role :: MAN_SCIENTIST_DARK_SKIN_TONE , "👩\u{200d}🔬" => crate :: people_and_body :: person_role :: WOMAN_SCIENTIST , "👩🏻\u{200d}🔬" => crate :: people_and_body :: person_role :: WOMAN_SCIENTIST_LIGHT_SKIN_TONE , "👩🏼\u{200d}🔬" => crate :: people_and_body :: person_role :: WOMAN_SCIENTIST_MEDIUM_LIGHT_SKIN_TONE , "👩🏽\u{200d}🔬" => crate :: people_and_body :: person_role :: WOMAN_SCIENTIST_MEDIUM_SKIN_TONE , "👩🏾\u{200d}🔬" => crate :: people_and_body :: person_role :: WOMAN_SCIENTIST_MEDIUM_DARK_SKIN_TONE , "👩🏿\u{200d}🔬" => crate :: people_and_body :: person_role :: WOMAN_SCIENTIST_DARK_SKIN_TONE , "🧑\u{200d}💻" => crate :: people_and_body :: person_role :: TECHNOLOGIST , "🧑🏻\u{200d}💻" => crate :: people_and_body :: person_role :: TECHNOLOGIST_LIGHT_SKIN_TONE , "🧑🏼\u{200d}💻" => crate :: people_and_body :: person_role :: TECHNOLOGIST_MEDIUM_LIGHT_SKIN_TONE , "🧑🏽\u{200d}💻" => crate :: people_and_body :: person_role :: TECHNOLOGIST_MEDIUM_SKIN_TONE , "🧑🏾\u{200d}💻" => crate :: people_and_body :: person_role :: TECHNOLOGIST_MEDIUM_DARK_SKIN_TONE , "🧑🏿\u{200d}💻" => crate :: people_and_body :: person_role :: TECHNOLOGIST_DARK_SKIN_TONE , "👨\u{200d}💻" => crate :: people_and_body :: person_role :: MAN_TECHNOLOGIST , "👨🏻\u{200d}💻" => crate :: people_and_body :: person_role :: MAN_TECHNOLOGIST_LIGHT_SKIN_TONE , "👨🏼\u{200d}💻" => crate :: people_and_body :: person_role :: MAN_TECHNOLOGIST_MEDIUM_LIGHT_SKIN_TONE , "👨🏽\u{200d}💻" => crate :: people_and_body :: person_role :: MAN_TECHNOLOGIST_MEDIUM_SKIN_TONE , "👨🏾\u{200d}💻" => crate :: people_and_body :: person_role :: MAN_TECHNOLOGIST_MEDIUM_DARK_SKIN_TONE , "👨🏿\u{200d}💻" => crate :: people_and_body :: person_role :: MAN_TECHNOLOGIST_DARK_SKIN_TONE , "👩\u{200d}💻" => crate :: people_and_body :: person_role :: WOMAN_TECHNOLOGIST , "👩🏻\u{200d}💻" => crate :: people_and_body :: person_role :: WOMAN_TECHNOLOGIST_LIGHT_SKIN_TONE , "👩🏼\u{200d}💻" => crate :: people_and_body :: person_role :: WOMAN_TECHNOLOGIST_MEDIUM_LIGHT_SKIN_TONE , "👩🏽\u{200d}💻" => crate :: people_and_body :: person_role :: WOMAN_TECHNOLOGIST_MEDIUM_SKIN_TONE , "👩🏾\u{200d}💻" => crate :: people_and_body :: person_role :: WOMAN_TECHNOLOGIST_MEDIUM_DARK_SKIN_TONE , "👩🏿\u{200d}💻" => crate :: people_and_body :: person_role :: WOMAN_TECHNOLOGIST_DARK_SKIN_TONE , "🧑\u{200d}🎤" => crate :: people_and_body :: person_role :: SINGER , "🧑🏻\u{200d}🎤" => crate :: people_and_body :: person_role :: SINGER_LIGHT_SKIN_TONE , "🧑🏼\u{200d}🎤" => crate :: people_and_body :: person_role :: SINGER_MEDIUM_LIGHT_SKIN_TONE , "🧑🏽\u{200d}🎤" => crate :: people_and_body :: person_role :: SINGER_MEDIUM_SKIN_TONE , "🧑🏾\u{200d}🎤" => crate :: people_and_body :: person_role :: SINGER_MEDIUM_DARK_SKIN_TONE , "🧑🏿\u{200d}🎤" => crate :: people_and_body :: person_role :: SINGER_DARK_SKIN_TONE , "👨\u{200d}🎤" => crate :: people_and_body :: person_role :: MAN_SINGER , "👨🏻\u{200d}🎤" => crate :: people_and_body :: person_role :: MAN_SINGER_LIGHT_SKIN_TONE , "👨🏼\u{200d}🎤" => crate :: people_and_body :: person_role :: MAN_SINGER_MEDIUM_LIGHT_SKIN_TONE , "👨🏽\u{200d}🎤" => crate :: people_and_body :: person_role :: MAN_SINGER_MEDIUM_SKIN_TONE , "👨🏾\u{200d}🎤" => crate :: people_and_body :: person_role :: MAN_SINGER_MEDIUM_DARK_SKIN_TONE , "👨🏿\u{200d}🎤" => crate :: people_and_body :: person_role :: MAN_SINGER_DARK_SKIN_TONE , "👩\u{200d}🎤" => crate :: people_and_body :: person_role :: WOMAN_SINGER , "👩🏻\u{200d}🎤" => crate :: people_and_body :: person_role :: WOMAN_SINGER_LIGHT_SKIN_TONE , "👩🏼\u{200d}🎤" => crate :: people_and_body :: person_role :: WOMAN_SINGER_MEDIUM_LIGHT_SKIN_TONE , "👩🏽\u{200d}🎤" => crate :: people_and_body :: person_role :: WOMAN_SINGER_MEDIUM_SKIN_TONE , "👩🏾\u{200d}🎤" => crate :: people_and_body :: person_role :: WOMAN_SINGER_MEDIUM_DARK_SKIN_TONE , "👩🏿\u{200d}🎤" => crate :: people_and_body :: person_role :: WOMAN_SINGER_DARK_SKIN_TONE , "🧑\u{200d}🎨" => crate :: people_and_body :: person_role :: ARTIST , "🧑🏻\u{200d}🎨" => crate :: people_and_body :: person_role :: ARTIST_LIGHT_SKIN_TONE , "🧑🏼\u{200d}🎨" => crate :: people_and_body :: person_role :: ARTIST_MEDIUM_LIGHT_SKIN_TONE , "🧑🏽\u{200d}🎨" => crate :: people_and_body :: person_role :: ARTIST_MEDIUM_SKIN_TONE , "🧑🏾\u{200d}🎨" => crate :: people_and_body :: person_role :: ARTIST_MEDIUM_DARK_SKIN_TONE , "🧑🏿\u{200d}🎨" => crate :: people_and_body :: person_role :: ARTIST_DARK_SKIN_TONE , "👨\u{200d}🎨" => crate :: people_and_body :: person_role :: MAN_ARTIST , "👨🏻\u{200d}🎨" => crate :: people_and_body :: person_role :: MAN_ARTIST_LIGHT_SKIN_TONE , "👨🏼\u{200d}🎨" => crate :: people_and_body :: person_role :: MAN_ARTIST_MEDIUM_LIGHT_SKIN_TONE , "👨🏽\u{200d}🎨" => crate :: people_and_body :: person_role :: MAN_ARTIST_MEDIUM_SKIN_TONE , "👨🏾\u{200d}🎨" => crate :: people_and_body :: person_role :: MAN_ARTIST_MEDIUM_DARK_SKIN_TONE , "👨🏿\u{200d}🎨" => crate :: people_and_body :: person_role :: MAN_ARTIST_DARK_SKIN_TONE , "👩\u{200d}🎨" => crate :: people_and_body :: person_role :: WOMAN_ARTIST , "👩🏻\u{200d}🎨" => crate :: people_and_body :: person_role :: WOMAN_ARTIST_LIGHT_SKIN_TONE , "👩🏼\u{200d}🎨" => crate :: people_and_body :: person_role :: WOMAN_ARTIST_MEDIUM_LIGHT_SKIN_TONE , "👩🏽\u{200d}🎨" => crate :: people_and_body :: person_role :: WOMAN_ARTIST_MEDIUM_SKIN_TONE , "👩🏾\u{200d}🎨" => crate :: people_and_body :: person_role :: WOMAN_ARTIST_MEDIUM_DARK_SKIN_TONE , "👩🏿\u{200d}🎨" => crate :: people_and_body :: person_role :: WOMAN_ARTIST_DARK_SKIN_TONE , "🧑\u{200d}✈\u{fe0f}" => crate :: people_and_body :: person_role :: PILOT , "🧑\u{200d}✈" => crate :: people_and_body :: person_role :: PILOT , "🧑🏻\u{200d}✈\u{fe0f}" => crate :: people_and_body :: person_role :: PILOT_LIGHT_SKIN_TONE , "🧑🏻\u{200d}✈" => crate :: people_and_body :: person_role :: PILOT_LIGHT_SKIN_TONE , "🧑🏼\u{200d}✈\u{fe0f}" => crate :: people_and_body :: person_role :: PILOT_MEDIUM_LIGHT_SKIN_TONE , "🧑🏼\u{200d}✈" => crate :: people_and_body :: person_role :: PILOT_MEDIUM_LIGHT_SKIN_TONE , "🧑🏽\u{200d}✈\u{fe0f}" => crate :: people_and_body :: person_role :: PILOT_MEDIUM_SKIN_TONE , "🧑🏽\u{200d}✈" => crate :: people_and_body :: person_role :: PILOT_MEDIUM_SKIN_TONE , "🧑🏾\u{200d}✈\u{fe0f}" => crate :: people_and_body :: person_role :: PILOT_MEDIUM_DARK_SKIN_TONE , "🧑🏾\u{200d}✈" => crate :: people_and_body :: person_role :: PILOT_MEDIUM_DARK_SKIN_TONE , "🧑🏿\u{200d}✈\u{fe0f}" => crate :: people_and_body :: person_role :: PILOT_DARK_SKIN_TONE , "🧑🏿\u{200d}✈" => crate :: people_and_body :: person_role :: PILOT_DARK_SKIN_TONE , "👨\u{200d}✈\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_PILOT , "👨\u{200d}✈" => crate :: people_and_body :: person_role :: MAN_PILOT , "👨🏻\u{200d}✈\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_PILOT_LIGHT_SKIN_TONE , "👨🏻\u{200d}✈" => crate :: people_and_body :: person_role :: MAN_PILOT_LIGHT_SKIN_TONE , "👨🏼\u{200d}✈\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_PILOT_MEDIUM_LIGHT_SKIN_TONE , "👨🏼\u{200d}✈" => crate :: people_and_body :: person_role :: MAN_PILOT_MEDIUM_LIGHT_SKIN_TONE , "👨🏽\u{200d}✈\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_PILOT_MEDIUM_SKIN_TONE , "👨🏽\u{200d}✈" => crate :: people_and_body :: person_role :: MAN_PILOT_MEDIUM_SKIN_TONE , "👨🏾\u{200d}✈\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_PILOT_MEDIUM_DARK_SKIN_TONE , "👨🏾\u{200d}✈" => crate :: people_and_body :: person_role :: MAN_PILOT_MEDIUM_DARK_SKIN_TONE , "👨🏿\u{200d}✈\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_PILOT_DARK_SKIN_TONE , "👨🏿\u{200d}✈" => crate :: people_and_body :: person_role :: MAN_PILOT_DARK_SKIN_TONE , "👩\u{200d}✈\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_PILOT , "👩\u{200d}✈" => crate :: people_and_body :: person_role :: WOMAN_PILOT , "👩🏻\u{200d}✈\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_PILOT_LIGHT_SKIN_TONE , "👩🏻\u{200d}✈" => crate :: people_and_body :: person_role :: WOMAN_PILOT_LIGHT_SKIN_TONE , "👩🏼\u{200d}✈\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_PILOT_MEDIUM_LIGHT_SKIN_TONE , "👩🏼\u{200d}✈" => crate :: people_and_body :: person_role :: WOMAN_PILOT_MEDIUM_LIGHT_SKIN_TONE , "👩🏽\u{200d}✈\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_PILOT_MEDIUM_SKIN_TONE , "👩🏽\u{200d}✈" => crate :: people_and_body :: person_role :: WOMAN_PILOT_MEDIUM_SKIN_TONE , "👩🏾\u{200d}✈\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_PILOT_MEDIUM_DARK_SKIN_TONE , "👩🏾\u{200d}✈" => crate :: people_and_body :: person_role :: WOMAN_PILOT_MEDIUM_DARK_SKIN_TONE , "👩🏿\u{200d}✈\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_PILOT_DARK_SKIN_TONE , "👩🏿\u{200d}✈" => crate :: people_and_body :: person_role :: WOMAN_PILOT_DARK_SKIN_TONE , "🧑\u{200d}🚀" => crate :: people_and_body :: person_role :: ASTRONAUT , "🧑🏻\u{200d}🚀" => crate :: people_and_body :: person_role :: ASTRONAUT_LIGHT_SKIN_TONE , "🧑🏼\u{200d}🚀" => crate :: people_and_body :: person_role :: ASTRONAUT_MEDIUM_LIGHT_SKIN_TONE , "🧑🏽\u{200d}🚀" => crate :: people_and_body :: person_role :: ASTRONAUT_MEDIUM_SKIN_TONE , "🧑🏾\u{200d}🚀" => crate :: people_and_body :: person_role :: ASTRONAUT_MEDIUM_DARK_SKIN_TONE , "🧑🏿\u{200d}🚀" => crate :: people_and_body :: person_role :: ASTRONAUT_DARK_SKIN_TONE , "👨\u{200d}🚀" => crate :: people_and_body :: person_role :: MAN_ASTRONAUT , "👨🏻\u{200d}🚀" => crate :: people_and_body :: person_role :: MAN_ASTRONAUT_LIGHT_SKIN_TONE , "👨🏼\u{200d}🚀" => crate :: people_and_body :: person_role :: MAN_ASTRONAUT_MEDIUM_LIGHT_SKIN_TONE , "👨🏽\u{200d}🚀" => crate :: people_and_body :: person_role :: MAN_ASTRONAUT_MEDIUM_SKIN_TONE , "👨🏾\u{200d}🚀" => crate :: people_and_body :: person_role :: MAN_ASTRONAUT_MEDIUM_DARK_SKIN_TONE , "👨🏿\u{200d}🚀" => crate :: people_and_body :: person_role :: MAN_ASTRONAUT_DARK_SKIN_TONE , "👩\u{200d}🚀" => crate :: people_and_body :: person_role :: WOMAN_ASTRONAUT , "👩🏻\u{200d}🚀" => crate :: people_and_body :: person_role :: WOMAN_ASTRONAUT_LIGHT_SKIN_TONE , "👩🏼\u{200d}🚀" => crate :: people_and_body :: person_role :: WOMAN_ASTRONAUT_MEDIUM_LIGHT_SKIN_TONE , "👩🏽\u{200d}🚀" => crate :: people_and_body :: person_role :: WOMAN_ASTRONAUT_MEDIUM_SKIN_TONE , "👩🏾\u{200d}🚀" => crate :: people_and_body :: person_role :: WOMAN_ASTRONAUT_MEDIUM_DARK_SKIN_TONE , "👩🏿\u{200d}🚀" => crate :: people_and_body :: person_role :: WOMAN_ASTRONAUT_DARK_SKIN_TONE , "🧑\u{200d}🚒" => crate :: people_and_body :: person_role :: FIREFIGHTER , "🧑🏻\u{200d}🚒" => crate :: people_and_body :: person_role :: FIREFIGHTER_LIGHT_SKIN_TONE , "🧑🏼\u{200d}🚒" => crate :: people_and_body :: person_role :: FIREFIGHTER_MEDIUM_LIGHT_SKIN_TONE , "🧑🏽\u{200d}🚒" => crate :: people_and_body :: person_role :: FIREFIGHTER_MEDIUM_SKIN_TONE , "🧑🏾\u{200d}🚒" => crate :: people_and_body :: person_role :: FIREFIGHTER_MEDIUM_DARK_SKIN_TONE , "🧑🏿\u{200d}🚒" => crate :: people_and_body :: person_role :: FIREFIGHTER_DARK_SKIN_TONE , "👨\u{200d}🚒" => crate :: people_and_body :: person_role :: MAN_FIREFIGHTER , "👨🏻\u{200d}🚒" => crate :: people_and_body :: person_role :: MAN_FIREFIGHTER_LIGHT_SKIN_TONE , "👨🏼\u{200d}🚒" => crate :: people_and_body :: person_role :: MAN_FIREFIGHTER_MEDIUM_LIGHT_SKIN_TONE , "👨🏽\u{200d}🚒" => crate :: people_and_body :: person_role :: MAN_FIREFIGHTER_MEDIUM_SKIN_TONE , "👨🏾\u{200d}🚒" => crate :: people_and_body :: person_role :: MAN_FIREFIGHTER_MEDIUM_DARK_SKIN_TONE , "👨🏿\u{200d}🚒" => crate :: people_and_body :: person_role :: MAN_FIREFIGHTER_DARK_SKIN_TONE , "👩\u{200d}🚒" => crate :: people_and_body :: person_role :: WOMAN_FIREFIGHTER , "👩🏻\u{200d}🚒" => crate :: people_and_body :: person_role :: WOMAN_FIREFIGHTER_LIGHT_SKIN_TONE , "👩🏼\u{200d}🚒" => crate :: people_and_body :: person_role :: WOMAN_FIREFIGHTER_MEDIUM_LIGHT_SKIN_TONE , "👩🏽\u{200d}🚒" => crate :: people_and_body :: person_role :: WOMAN_FIREFIGHTER_MEDIUM_SKIN_TONE , "👩🏾\u{200d}🚒" => crate :: people_and_body :: person_role :: WOMAN_FIREFIGHTER_MEDIUM_DARK_SKIN_TONE , "👩🏿\u{200d}🚒" => crate :: people_and_body :: person_role :: WOMAN_FIREFIGHTER_DARK_SKIN_TONE , "👮" => crate :: people_and_body :: person_role :: POLICE_OFFICER , "👮🏻" => crate :: people_and_body :: person_role :: POLICE_OFFICER_LIGHT_SKIN_TONE , "👮🏼" => crate :: people_and_body :: person_role :: POLICE_OFFICER_MEDIUM_LIGHT_SKIN_TONE , "👮🏽" => crate :: people_and_body :: person_role :: POLICE_OFFICER_MEDIUM_SKIN_TONE , "👮🏾" => crate :: people_and_body :: person_role :: POLICE_OFFICER_MEDIUM_DARK_SKIN_TONE , "👮🏿" => crate :: people_and_body :: person_role :: POLICE_OFFICER_DARK_SKIN_TONE , "👮\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_POLICE_OFFICER , "👮\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_POLICE_OFFICER , "👮🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_POLICE_OFFICER_LIGHT_SKIN_TONE , "👮🏻\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_POLICE_OFFICER_LIGHT_SKIN_TONE , "👮🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_POLICE_OFFICER_MEDIUM_LIGHT_SKIN_TONE , "👮🏼\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_POLICE_OFFICER_MEDIUM_LIGHT_SKIN_TONE , "👮🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_POLICE_OFFICER_MEDIUM_SKIN_TONE , "👮🏽\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_POLICE_OFFICER_MEDIUM_SKIN_TONE , "👮🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_POLICE_OFFICER_MEDIUM_DARK_SKIN_TONE , "👮🏾\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_POLICE_OFFICER_MEDIUM_DARK_SKIN_TONE , "👮🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_POLICE_OFFICER_DARK_SKIN_TONE , "👮🏿\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_POLICE_OFFICER_DARK_SKIN_TONE , "👮\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_POLICE_OFFICER , "👮\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_POLICE_OFFICER , "👮🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_POLICE_OFFICER_LIGHT_SKIN_TONE , "👮🏻\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_POLICE_OFFICER_LIGHT_SKIN_TONE , "👮🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_POLICE_OFFICER_MEDIUM_LIGHT_SKIN_TONE , "👮🏼\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_POLICE_OFFICER_MEDIUM_LIGHT_SKIN_TONE , "👮🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_POLICE_OFFICER_MEDIUM_SKIN_TONE , "👮🏽\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_POLICE_OFFICER_MEDIUM_SKIN_TONE , "👮🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_POLICE_OFFICER_MEDIUM_DARK_SKIN_TONE , "👮🏾\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_POLICE_OFFICER_MEDIUM_DARK_SKIN_TONE , "👮🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_POLICE_OFFICER_DARK_SKIN_TONE , "👮🏿\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_POLICE_OFFICER_DARK_SKIN_TONE , "🕵\u{fe0f}" => crate :: people_and_body :: person_role :: DETECTIVE , "🕵" => crate :: people_and_body :: person_role :: DETECTIVE , "🕵🏻" => crate :: people_and_body :: person_role :: DETECTIVE_LIGHT_SKIN_TONE , "🕵🏼" => crate :: people_and_body :: person_role :: DETECTIVE_MEDIUM_LIGHT_SKIN_TONE , "🕵🏽" => crate :: people_and_body :: person_role :: DETECTIVE_MEDIUM_SKIN_TONE , "🕵🏾" => crate :: people_and_body :: person_role :: DETECTIVE_MEDIUM_DARK_SKIN_TONE , "🕵🏿" => crate :: people_and_body :: person_role :: DETECTIVE_DARK_SKIN_TONE , "🕵\u{fe0f}\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_DETECTIVE , "🕵\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_DETECTIVE , "🕵\u{fe0f}\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_DETECTIVE , "🕵\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_DETECTIVE , "🕵🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_DETECTIVE_LIGHT_SKIN_TONE , "🕵🏻\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_DETECTIVE_LIGHT_SKIN_TONE , "🕵🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_DETECTIVE_MEDIUM_LIGHT_SKIN_TONE , "🕵🏼\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_DETECTIVE_MEDIUM_LIGHT_SKIN_TONE , "🕵🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_DETECTIVE_MEDIUM_SKIN_TONE , "🕵🏽\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_DETECTIVE_MEDIUM_SKIN_TONE , "🕵🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_DETECTIVE_MEDIUM_DARK_SKIN_TONE , "🕵🏾\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_DETECTIVE_MEDIUM_DARK_SKIN_TONE , "🕵🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_DETECTIVE_DARK_SKIN_TONE , "🕵🏿\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_DETECTIVE_DARK_SKIN_TONE , "🕵\u{fe0f}\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_DETECTIVE , "🕵\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_DETECTIVE , "🕵\u{fe0f}\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_DETECTIVE , "🕵\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_DETECTIVE , "🕵🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_DETECTIVE_LIGHT_SKIN_TONE , "🕵🏻\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_DETECTIVE_LIGHT_SKIN_TONE , "🕵🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_DETECTIVE_MEDIUM_LIGHT_SKIN_TONE , "🕵🏼\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_DETECTIVE_MEDIUM_LIGHT_SKIN_TONE , "🕵🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_DETECTIVE_MEDIUM_SKIN_TONE , "🕵🏽\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_DETECTIVE_MEDIUM_SKIN_TONE , "🕵🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_DETECTIVE_MEDIUM_DARK_SKIN_TONE , "🕵🏾\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_DETECTIVE_MEDIUM_DARK_SKIN_TONE , "🕵🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_DETECTIVE_DARK_SKIN_TONE , "🕵🏿\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_DETECTIVE_DARK_SKIN_TONE , "💂" => crate :: people_and_body :: person_role :: GUARD , "💂🏻" => crate :: people_and_body :: person_role :: GUARD_LIGHT_SKIN_TONE , "💂🏼" => crate :: people_and_body :: person_role :: GUARD_MEDIUM_LIGHT_SKIN_TONE , "💂🏽" => crate :: people_and_body :: person_role :: GUARD_MEDIUM_SKIN_TONE , "💂🏾" => crate :: people_and_body :: person_role :: GUARD_MEDIUM_DARK_SKIN_TONE , "💂🏿" => crate :: people_and_body :: person_role :: GUARD_DARK_SKIN_TONE , "💂\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_GUARD , "💂\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_GUARD , "💂🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_GUARD_LIGHT_SKIN_TONE , "💂🏻\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_GUARD_LIGHT_SKIN_TONE , "💂🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_GUARD_MEDIUM_LIGHT_SKIN_TONE , "💂🏼\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_GUARD_MEDIUM_LIGHT_SKIN_TONE , "💂🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_GUARD_MEDIUM_SKIN_TONE , "💂🏽\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_GUARD_MEDIUM_SKIN_TONE , "💂🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_GUARD_MEDIUM_DARK_SKIN_TONE , "💂🏾\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_GUARD_MEDIUM_DARK_SKIN_TONE , "💂🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_GUARD_DARK_SKIN_TONE , "💂🏿\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_GUARD_DARK_SKIN_TONE , "💂\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_GUARD , "💂\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_GUARD , "💂🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_GUARD_LIGHT_SKIN_TONE , "💂🏻\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_GUARD_LIGHT_SKIN_TONE , "💂🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_GUARD_MEDIUM_LIGHT_SKIN_TONE , "💂🏼\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_GUARD_MEDIUM_LIGHT_SKIN_TONE , "💂🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_GUARD_MEDIUM_SKIN_TONE , "💂🏽\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_GUARD_MEDIUM_SKIN_TONE , "💂🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_GUARD_MEDIUM_DARK_SKIN_TONE , "💂🏾\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_GUARD_MEDIUM_DARK_SKIN_TONE , "💂🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_GUARD_DARK_SKIN_TONE , "💂🏿\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_GUARD_DARK_SKIN_TONE , "🥷" => crate :: people_and_body :: person_role :: NINJA , "🥷🏻" => crate :: people_and_body :: person_role :: NINJA_LIGHT_SKIN_TONE , "🥷🏼" => crate :: people_and_body :: person_role :: NINJA_MEDIUM_LIGHT_SKIN_TONE , "🥷🏽" => crate :: people_and_body :: person_role :: NINJA_MEDIUM_SKIN_TONE , "🥷🏾" => crate :: people_and_body :: person_role :: NINJA_MEDIUM_DARK_SKIN_TONE , "🥷🏿" => crate :: people_and_body :: person_role :: NINJA_DARK_SKIN_TONE , "👷" => crate :: people_and_body :: person_role :: CONSTRUCTION_WORKER , "👷🏻" => crate :: people_and_body :: person_role :: CONSTRUCTION_WORKER_LIGHT_SKIN_TONE , "👷🏼" => crate :: people_and_body :: person_role :: CONSTRUCTION_WORKER_MEDIUM_LIGHT_SKIN_TONE , "👷🏽" => crate :: people_and_body :: person_role :: CONSTRUCTION_WORKER_MEDIUM_SKIN_TONE , "👷🏾" => crate :: people_and_body :: person_role :: CONSTRUCTION_WORKER_MEDIUM_DARK_SKIN_TONE , "👷🏿" => crate :: people_and_body :: person_role :: CONSTRUCTION_WORKER_DARK_SKIN_TONE , "👷\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_CONSTRUCTION_WORKER , "👷\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_CONSTRUCTION_WORKER , "👷🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_CONSTRUCTION_WORKER_LIGHT_SKIN_TONE , "👷🏻\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_CONSTRUCTION_WORKER_LIGHT_SKIN_TONE , "👷🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_CONSTRUCTION_WORKER_MEDIUM_LIGHT_SKIN_TONE , "👷🏼\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_CONSTRUCTION_WORKER_MEDIUM_LIGHT_SKIN_TONE , "👷🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_CONSTRUCTION_WORKER_MEDIUM_SKIN_TONE , "👷🏽\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_CONSTRUCTION_WORKER_MEDIUM_SKIN_TONE , "👷🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_CONSTRUCTION_WORKER_MEDIUM_DARK_SKIN_TONE , "👷🏾\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_CONSTRUCTION_WORKER_MEDIUM_DARK_SKIN_TONE , "👷🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_CONSTRUCTION_WORKER_DARK_SKIN_TONE , "👷🏿\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_CONSTRUCTION_WORKER_DARK_SKIN_TONE , "👷\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_CONSTRUCTION_WORKER , "👷\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_CONSTRUCTION_WORKER , "👷🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_CONSTRUCTION_WORKER_LIGHT_SKIN_TONE , "👷🏻\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_CONSTRUCTION_WORKER_LIGHT_SKIN_TONE , "👷🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_CONSTRUCTION_WORKER_MEDIUM_LIGHT_SKIN_TONE , "👷🏼\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_CONSTRUCTION_WORKER_MEDIUM_LIGHT_SKIN_TONE , "👷🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_CONSTRUCTION_WORKER_MEDIUM_SKIN_TONE , "👷🏽\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_CONSTRUCTION_WORKER_MEDIUM_SKIN_TONE , "👷🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_CONSTRUCTION_WORKER_MEDIUM_DARK_SKIN_TONE , "👷🏾\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_CONSTRUCTION_WORKER_MEDIUM_DARK_SKIN_TONE , "👷🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_CONSTRUCTION_WORKER_DARK_SKIN_TONE , "👷🏿\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_CONSTRUCTION_WORKER_DARK_SKIN_TONE , "🤴" => crate :: people_and_body :: person_role :: PRINCE , "🤴🏻" => crate :: people_and_body :: person_role :: PRINCE_LIGHT_SKIN_TONE , "🤴🏼" => crate :: people_and_body :: person_role :: PRINCE_MEDIUM_LIGHT_SKIN_TONE , "🤴🏽" => crate :: people_and_body :: person_role :: PRINCE_MEDIUM_SKIN_TONE , "🤴🏾" => crate :: people_and_body :: person_role :: PRINCE_MEDIUM_DARK_SKIN_TONE , "🤴🏿" => crate :: people_and_body :: person_role :: PRINCE_DARK_SKIN_TONE , "👸" => crate :: people_and_body :: person_role :: PRINCESS , "👸🏻" => crate :: people_and_body :: person_role :: PRINCESS_LIGHT_SKIN_TONE , "👸🏼" => crate :: people_and_body :: person_role :: PRINCESS_MEDIUM_LIGHT_SKIN_TONE , "👸🏽" => crate :: people_and_body :: person_role :: PRINCESS_MEDIUM_SKIN_TONE , "👸🏾" => crate :: people_and_body :: person_role :: PRINCESS_MEDIUM_DARK_SKIN_TONE , "👸🏿" => crate :: people_and_body :: person_role :: PRINCESS_DARK_SKIN_TONE , "👳" => crate :: people_and_body :: person_role :: PERSON_WEARING_TURBAN , "👳🏻" => crate :: people_and_body :: person_role :: PERSON_WEARING_TURBAN_LIGHT_SKIN_TONE , "👳🏼" => crate :: people_and_body :: person_role :: PERSON_WEARING_TURBAN_MEDIUM_LIGHT_SKIN_TONE , "👳🏽" => crate :: people_and_body :: person_role :: PERSON_WEARING_TURBAN_MEDIUM_SKIN_TONE , "👳🏾" => crate :: people_and_body :: person_role :: PERSON_WEARING_TURBAN_MEDIUM_DARK_SKIN_TONE , "👳🏿" => crate :: people_and_body :: person_role :: PERSON_WEARING_TURBAN_DARK_SKIN_TONE , "👳\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_WEARING_TURBAN , "👳\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_WEARING_TURBAN , "👳🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_WEARING_TURBAN_LIGHT_SKIN_TONE , "👳🏻\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_WEARING_TURBAN_LIGHT_SKIN_TONE , "👳🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_WEARING_TURBAN_MEDIUM_LIGHT_SKIN_TONE , "👳🏼\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_WEARING_TURBAN_MEDIUM_LIGHT_SKIN_TONE , "👳🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_WEARING_TURBAN_MEDIUM_SKIN_TONE , "👳🏽\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_WEARING_TURBAN_MEDIUM_SKIN_TONE , "👳🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_WEARING_TURBAN_MEDIUM_DARK_SKIN_TONE , "👳🏾\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_WEARING_TURBAN_MEDIUM_DARK_SKIN_TONE , "👳🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_WEARING_TURBAN_DARK_SKIN_TONE , "👳🏿\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_WEARING_TURBAN_DARK_SKIN_TONE , "👳\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_WEARING_TURBAN , "👳\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_WEARING_TURBAN , "👳🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_WEARING_TURBAN_LIGHT_SKIN_TONE , "👳🏻\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_WEARING_TURBAN_LIGHT_SKIN_TONE , "👳🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_WEARING_TURBAN_MEDIUM_LIGHT_SKIN_TONE , "👳🏼\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_WEARING_TURBAN_MEDIUM_LIGHT_SKIN_TONE , "👳🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_WEARING_TURBAN_MEDIUM_SKIN_TONE , "👳🏽\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_WEARING_TURBAN_MEDIUM_SKIN_TONE , "👳🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_WEARING_TURBAN_MEDIUM_DARK_SKIN_TONE , "👳🏾\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_WEARING_TURBAN_MEDIUM_DARK_SKIN_TONE , "👳🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_WEARING_TURBAN_DARK_SKIN_TONE , "👳🏿\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_WEARING_TURBAN_DARK_SKIN_TONE , "👲" => crate :: people_and_body :: person_role :: PERSON_WITH_SKULLCAP , "👲🏻" => crate :: people_and_body :: person_role :: PERSON_WITH_SKULLCAP_LIGHT_SKIN_TONE , "👲🏼" => crate :: people_and_body :: person_role :: PERSON_WITH_SKULLCAP_MEDIUM_LIGHT_SKIN_TONE , "👲🏽" => crate :: people_and_body :: person_role :: PERSON_WITH_SKULLCAP_MEDIUM_SKIN_TONE , "👲🏾" => crate :: people_and_body :: person_role :: PERSON_WITH_SKULLCAP_MEDIUM_DARK_SKIN_TONE , "👲🏿" => crate :: people_and_body :: person_role :: PERSON_WITH_SKULLCAP_DARK_SKIN_TONE , "🧕" => crate :: people_and_body :: person_role :: WOMAN_WITH_HEADSCARF , "🧕🏻" => crate :: people_and_body :: person_role :: WOMAN_WITH_HEADSCARF_LIGHT_SKIN_TONE , "🧕🏼" => crate :: people_and_body :: person_role :: WOMAN_WITH_HEADSCARF_MEDIUM_LIGHT_SKIN_TONE , "🧕🏽" => crate :: people_and_body :: person_role :: WOMAN_WITH_HEADSCARF_MEDIUM_SKIN_TONE , "🧕🏾" => crate :: people_and_body :: person_role :: WOMAN_WITH_HEADSCARF_MEDIUM_DARK_SKIN_TONE , "🧕🏿" => crate :: people_and_body :: person_role :: WOMAN_WITH_HEADSCARF_DARK_SKIN_TONE , "🤵" => crate :: people_and_body :: person_role :: PERSON_IN_TUXEDO , "🤵🏻" => crate :: people_and_body :: person_role :: PERSON_IN_TUXEDO_LIGHT_SKIN_TONE , "🤵🏼" => crate :: people_and_body :: person_role :: PERSON_IN_TUXEDO_MEDIUM_LIGHT_SKIN_TONE , "🤵🏽" => crate :: people_and_body :: person_role :: PERSON_IN_TUXEDO_MEDIUM_SKIN_TONE , "🤵🏾" => crate :: people_and_body :: person_role :: PERSON_IN_TUXEDO_MEDIUM_DARK_SKIN_TONE , "🤵🏿" => crate :: people_and_body :: person_role :: PERSON_IN_TUXEDO_DARK_SKIN_TONE , "🤵\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_IN_TUXEDO , "🤵\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_IN_TUXEDO , "🤵🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_IN_TUXEDO_LIGHT_SKIN_TONE , "🤵🏻\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_IN_TUXEDO_LIGHT_SKIN_TONE , "🤵🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_IN_TUXEDO_MEDIUM_LIGHT_SKIN_TONE , "🤵🏼\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_IN_TUXEDO_MEDIUM_LIGHT_SKIN_TONE , "🤵🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_IN_TUXEDO_MEDIUM_SKIN_TONE , "🤵🏽\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_IN_TUXEDO_MEDIUM_SKIN_TONE , "🤵🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_IN_TUXEDO_MEDIUM_DARK_SKIN_TONE , "🤵🏾\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_IN_TUXEDO_MEDIUM_DARK_SKIN_TONE , "🤵🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_IN_TUXEDO_DARK_SKIN_TONE , "🤵🏿\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_IN_TUXEDO_DARK_SKIN_TONE , "🤵\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_IN_TUXEDO , "🤵\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_IN_TUXEDO , "🤵🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_IN_TUXEDO_LIGHT_SKIN_TONE , "🤵🏻\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_IN_TUXEDO_LIGHT_SKIN_TONE , "🤵🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_IN_TUXEDO_MEDIUM_LIGHT_SKIN_TONE , "🤵🏼\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_IN_TUXEDO_MEDIUM_LIGHT_SKIN_TONE , "🤵🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_IN_TUXEDO_MEDIUM_SKIN_TONE , "🤵🏽\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_IN_TUXEDO_MEDIUM_SKIN_TONE , "🤵🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_IN_TUXEDO_MEDIUM_DARK_SKIN_TONE , "🤵🏾\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_IN_TUXEDO_MEDIUM_DARK_SKIN_TONE , "🤵🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_IN_TUXEDO_DARK_SKIN_TONE , "🤵🏿\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_IN_TUXEDO_DARK_SKIN_TONE , "👰" => crate :: people_and_body :: person_role :: PERSON_WITH_VEIL , "👰🏻" => crate :: people_and_body :: person_role :: PERSON_WITH_VEIL_LIGHT_SKIN_TONE , "👰🏼" => crate :: people_and_body :: person_role :: PERSON_WITH_VEIL_MEDIUM_LIGHT_SKIN_TONE , "👰🏽" => crate :: people_and_body :: person_role :: PERSON_WITH_VEIL_MEDIUM_SKIN_TONE , "👰🏾" => crate :: people_and_body :: person_role :: PERSON_WITH_VEIL_MEDIUM_DARK_SKIN_TONE , "👰🏿" => crate :: people_and_body :: person_role :: PERSON_WITH_VEIL_DARK_SKIN_TONE , "👰\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_WITH_VEIL , "👰\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_WITH_VEIL , "👰🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_WITH_VEIL_LIGHT_SKIN_TONE , "👰🏻\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_WITH_VEIL_LIGHT_SKIN_TONE , "👰🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_WITH_VEIL_MEDIUM_LIGHT_SKIN_TONE , "👰🏼\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_WITH_VEIL_MEDIUM_LIGHT_SKIN_TONE , "👰🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_WITH_VEIL_MEDIUM_SKIN_TONE , "👰🏽\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_WITH_VEIL_MEDIUM_SKIN_TONE , "👰🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_WITH_VEIL_MEDIUM_DARK_SKIN_TONE , "👰🏾\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_WITH_VEIL_MEDIUM_DARK_SKIN_TONE , "👰🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_role :: MAN_WITH_VEIL_DARK_SKIN_TONE , "👰🏿\u{200d}♂" => crate :: people_and_body :: person_role :: MAN_WITH_VEIL_DARK_SKIN_TONE , "👰\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_WITH_VEIL , "👰\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_WITH_VEIL , "👰🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_WITH_VEIL_LIGHT_SKIN_TONE , "👰🏻\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_WITH_VEIL_LIGHT_SKIN_TONE , "👰🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_WITH_VEIL_MEDIUM_LIGHT_SKIN_TONE , "👰🏼\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_WITH_VEIL_MEDIUM_LIGHT_SKIN_TONE , "👰🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_WITH_VEIL_MEDIUM_SKIN_TONE , "👰🏽\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_WITH_VEIL_MEDIUM_SKIN_TONE , "👰🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_WITH_VEIL_MEDIUM_DARK_SKIN_TONE , "👰🏾\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_WITH_VEIL_MEDIUM_DARK_SKIN_TONE , "👰🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_role :: WOMAN_WITH_VEIL_DARK_SKIN_TONE , "👰🏿\u{200d}♀" => crate :: people_and_body :: person_role :: WOMAN_WITH_VEIL_DARK_SKIN_TONE , "🤰" => crate :: people_and_body :: person_role :: PREGNANT_WOMAN , "🤰🏻" => crate :: people_and_body :: person_role :: PREGNANT_WOMAN_LIGHT_SKIN_TONE , "🤰🏼" => crate :: people_and_body :: person_role :: PREGNANT_WOMAN_MEDIUM_LIGHT_SKIN_TONE , "🤰🏽" => crate :: people_and_body :: person_role :: PREGNANT_WOMAN_MEDIUM_SKIN_TONE , "🤰🏾" => crate :: people_and_body :: person_role :: PREGNANT_WOMAN_MEDIUM_DARK_SKIN_TONE , "🤰🏿" => crate :: people_and_body :: person_role :: PREGNANT_WOMAN_DARK_SKIN_TONE , "🤱" => crate :: people_and_body :: person_role :: BREAST_FEEDING , "🤱🏻" => crate :: people_and_body :: person_role :: BREAST_FEEDING_LIGHT_SKIN_TONE , "🤱🏼" => crate :: people_and_body :: person_role :: BREAST_FEEDING_MEDIUM_LIGHT_SKIN_TONE , "🤱🏽" => crate :: people_and_body :: person_role :: BREAST_FEEDING_MEDIUM_SKIN_TONE , "🤱🏾" => crate :: people_and_body :: person_role :: BREAST_FEEDING_MEDIUM_DARK_SKIN_TONE , "🤱🏿" => crate :: people_and_body :: person_role :: BREAST_FEEDING_DARK_SKIN_TONE , "👩\u{200d}🍼" => crate :: people_and_body :: person_role :: WOMAN_FEEDING_BABY , "👩🏻\u{200d}🍼" => crate :: people_and_body :: person_role :: WOMAN_FEEDING_BABY_LIGHT_SKIN_TONE , "👩🏼\u{200d}🍼" => crate :: people_and_body :: person_role :: WOMAN_FEEDING_BABY_MEDIUM_LIGHT_SKIN_TONE , "👩🏽\u{200d}🍼" => crate :: people_and_body :: person_role :: WOMAN_FEEDING_BABY_MEDIUM_SKIN_TONE , "👩🏾\u{200d}🍼" => crate :: people_and_body :: person_role :: WOMAN_FEEDING_BABY_MEDIUM_DARK_SKIN_TONE , "👩🏿\u{200d}🍼" => crate :: people_and_body :: person_role :: WOMAN_FEEDING_BABY_DARK_SKIN_TONE , "👨\u{200d}🍼" => crate :: people_and_body :: person_role :: MAN_FEEDING_BABY , "👨🏻\u{200d}🍼" => crate :: people_and_body :: person_role :: MAN_FEEDING_BABY_LIGHT_SKIN_TONE , "👨🏼\u{200d}🍼" => crate :: people_and_body :: person_role :: MAN_FEEDING_BABY_MEDIUM_LIGHT_SKIN_TONE , "👨🏽\u{200d}🍼" => crate :: people_and_body :: person_role :: MAN_FEEDING_BABY_MEDIUM_SKIN_TONE , "👨🏾\u{200d}🍼" => crate :: people_and_body :: person_role :: MAN_FEEDING_BABY_MEDIUM_DARK_SKIN_TONE , "👨🏿\u{200d}🍼" => crate :: people_and_body :: person_role :: MAN_FEEDING_BABY_DARK_SKIN_TONE , "🧑\u{200d}🍼" => crate :: people_and_body :: person_role :: PERSON_FEEDING_BABY , "🧑🏻\u{200d}🍼" => crate :: people_and_body :: person_role :: PERSON_FEEDING_BABY_LIGHT_SKIN_TONE , "🧑🏼\u{200d}🍼" => crate :: people_and_body :: person_role :: PERSON_FEEDING_BABY_MEDIUM_LIGHT_SKIN_TONE , "🧑🏽\u{200d}🍼" => crate :: people_and_body :: person_role :: PERSON_FEEDING_BABY_MEDIUM_SKIN_TONE , "🧑🏾\u{200d}🍼" => crate :: people_and_body :: person_role :: PERSON_FEEDING_BABY_MEDIUM_DARK_SKIN_TONE , "🧑🏿\u{200d}🍼" => crate :: people_and_body :: person_role :: PERSON_FEEDING_BABY_DARK_SKIN_TONE , "👼" => crate :: people_and_body :: person_fantasy :: BABY_ANGEL , "👼🏻" => crate :: people_and_body :: person_fantasy :: BABY_ANGEL_LIGHT_SKIN_TONE , "👼🏼" => crate :: people_and_body :: person_fantasy :: BABY_ANGEL_MEDIUM_LIGHT_SKIN_TONE , "👼🏽" => crate :: people_and_body :: person_fantasy :: BABY_ANGEL_MEDIUM_SKIN_TONE , "👼🏾" => crate :: people_and_body :: person_fantasy :: BABY_ANGEL_MEDIUM_DARK_SKIN_TONE , "👼🏿" => crate :: people_and_body :: person_fantasy :: BABY_ANGEL_DARK_SKIN_TONE , "🎅" => crate :: people_and_body :: person_fantasy :: SANTA_CLAUS , "🎅🏻" => crate :: people_and_body :: person_fantasy :: SANTA_CLAUS_LIGHT_SKIN_TONE , "🎅🏼" => crate :: people_and_body :: person_fantasy :: SANTA_CLAUS_MEDIUM_LIGHT_SKIN_TONE , "🎅🏽" => crate :: people_and_body :: person_fantasy :: SANTA_CLAUS_MEDIUM_SKIN_TONE , "🎅🏾" => crate :: people_and_body :: person_fantasy :: SANTA_CLAUS_MEDIUM_DARK_SKIN_TONE , "🎅🏿" => crate :: people_and_body :: person_fantasy :: SANTA_CLAUS_DARK_SKIN_TONE , "🤶" => crate :: people_and_body :: person_fantasy :: MRS_CLAUS , "🤶🏻" => crate :: people_and_body :: person_fantasy :: MRS_CLAUS_LIGHT_SKIN_TONE , "🤶🏼" => crate :: people_and_body :: person_fantasy :: MRS_CLAUS_MEDIUM_LIGHT_SKIN_TONE , "🤶🏽" => crate :: people_and_body :: person_fantasy :: MRS_CLAUS_MEDIUM_SKIN_TONE , "🤶🏾" => crate :: people_and_body :: person_fantasy :: MRS_CLAUS_MEDIUM_DARK_SKIN_TONE , "🤶🏿" => crate :: people_and_body :: person_fantasy :: MRS_CLAUS_DARK_SKIN_TONE , "🧑\u{200d}🎄" => crate :: people_and_body :: person_fantasy :: MX_CLAUS , "🧑🏻\u{200d}🎄" => crate :: people_and_body :: person_fantasy :: MX_CLAUS_LIGHT_SKIN_TONE , "🧑🏼\u{200d}🎄" => crate :: people_and_body :: person_fantasy :: MX_CLAUS_MEDIUM_LIGHT_SKIN_TONE , "🧑🏽\u{200d}🎄" => crate :: people_and_body :: person_fantasy :: MX_CLAUS_MEDIUM_SKIN_TONE , "🧑🏾\u{200d}🎄" => crate :: people_and_body :: person_fantasy :: MX_CLAUS_MEDIUM_DARK_SKIN_TONE , "🧑🏿\u{200d}🎄" => crate :: people_and_body :: person_fantasy :: MX_CLAUS_DARK_SKIN_TONE , "🦸" => crate :: people_and_body :: person_fantasy :: SUPERHERO , "🦸🏻" => crate :: people_and_body :: person_fantasy :: SUPERHERO_LIGHT_SKIN_TONE , "🦸🏼" => crate :: people_and_body :: person_fantasy :: SUPERHERO_MEDIUM_LIGHT_SKIN_TONE , "🦸🏽" => crate :: people_and_body :: person_fantasy :: SUPERHERO_MEDIUM_SKIN_TONE , "🦸🏾" => crate :: people_and_body :: person_fantasy :: SUPERHERO_MEDIUM_DARK_SKIN_TONE , "🦸🏿" => crate :: people_and_body :: person_fantasy :: SUPERHERO_DARK_SKIN_TONE , "🦸\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_SUPERHERO , "🦸\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_SUPERHERO , "🦸🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_SUPERHERO_LIGHT_SKIN_TONE , "🦸🏻\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_SUPERHERO_LIGHT_SKIN_TONE , "🦸🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_SUPERHERO_MEDIUM_LIGHT_SKIN_TONE , "🦸🏼\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_SUPERHERO_MEDIUM_LIGHT_SKIN_TONE , "🦸🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_SUPERHERO_MEDIUM_SKIN_TONE , "🦸🏽\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_SUPERHERO_MEDIUM_SKIN_TONE , "🦸🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_SUPERHERO_MEDIUM_DARK_SKIN_TONE , "🦸🏾\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_SUPERHERO_MEDIUM_DARK_SKIN_TONE , "🦸🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_SUPERHERO_DARK_SKIN_TONE , "🦸🏿\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_SUPERHERO_DARK_SKIN_TONE , "🦸\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_SUPERHERO , "🦸\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_SUPERHERO , "🦸🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_SUPERHERO_LIGHT_SKIN_TONE , "🦸🏻\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_SUPERHERO_LIGHT_SKIN_TONE , "🦸🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_SUPERHERO_MEDIUM_LIGHT_SKIN_TONE , "🦸🏼\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_SUPERHERO_MEDIUM_LIGHT_SKIN_TONE , "🦸🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_SUPERHERO_MEDIUM_SKIN_TONE , "🦸🏽\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_SUPERHERO_MEDIUM_SKIN_TONE , "🦸🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_SUPERHERO_MEDIUM_DARK_SKIN_TONE , "🦸🏾\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_SUPERHERO_MEDIUM_DARK_SKIN_TONE , "🦸🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_SUPERHERO_DARK_SKIN_TONE , "🦸🏿\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_SUPERHERO_DARK_SKIN_TONE , "🦹" => crate :: people_and_body :: person_fantasy :: SUPERVILLAIN , "🦹🏻" => crate :: people_and_body :: person_fantasy :: SUPERVILLAIN_LIGHT_SKIN_TONE , "🦹🏼" => crate :: people_and_body :: person_fantasy :: SUPERVILLAIN_MEDIUM_LIGHT_SKIN_TONE , "🦹🏽" => crate :: people_and_body :: person_fantasy :: SUPERVILLAIN_MEDIUM_SKIN_TONE , "🦹🏾" => crate :: people_and_body :: person_fantasy :: SUPERVILLAIN_MEDIUM_DARK_SKIN_TONE , "🦹🏿" => crate :: people_and_body :: person_fantasy :: SUPERVILLAIN_DARK_SKIN_TONE , "🦹\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_SUPERVILLAIN , "🦹\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_SUPERVILLAIN , "🦹🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_SUPERVILLAIN_LIGHT_SKIN_TONE , "🦹🏻\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_SUPERVILLAIN_LIGHT_SKIN_TONE , "🦹🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_SUPERVILLAIN_MEDIUM_LIGHT_SKIN_TONE , "🦹🏼\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_SUPERVILLAIN_MEDIUM_LIGHT_SKIN_TONE , "🦹🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_SUPERVILLAIN_MEDIUM_SKIN_TONE , "🦹🏽\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_SUPERVILLAIN_MEDIUM_SKIN_TONE , "🦹🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_SUPERVILLAIN_MEDIUM_DARK_SKIN_TONE , "🦹🏾\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_SUPERVILLAIN_MEDIUM_DARK_SKIN_TONE , "🦹🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_SUPERVILLAIN_DARK_SKIN_TONE , "🦹🏿\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_SUPERVILLAIN_DARK_SKIN_TONE , "🦹\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_SUPERVILLAIN , "🦹\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_SUPERVILLAIN , "🦹🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_SUPERVILLAIN_LIGHT_SKIN_TONE , "🦹🏻\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_SUPERVILLAIN_LIGHT_SKIN_TONE , "🦹🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_SUPERVILLAIN_MEDIUM_LIGHT_SKIN_TONE , "🦹🏼\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_SUPERVILLAIN_MEDIUM_LIGHT_SKIN_TONE , "🦹🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_SUPERVILLAIN_MEDIUM_SKIN_TONE , "🦹🏽\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_SUPERVILLAIN_MEDIUM_SKIN_TONE , "🦹🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_SUPERVILLAIN_MEDIUM_DARK_SKIN_TONE , "🦹🏾\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_SUPERVILLAIN_MEDIUM_DARK_SKIN_TONE , "🦹🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_SUPERVILLAIN_DARK_SKIN_TONE , "🦹🏿\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_SUPERVILLAIN_DARK_SKIN_TONE , "🧙" => crate :: people_and_body :: person_fantasy :: MAGE , "🧙🏻" => crate :: people_and_body :: person_fantasy :: MAGE_LIGHT_SKIN_TONE , "🧙🏼" => crate :: people_and_body :: person_fantasy :: MAGE_MEDIUM_LIGHT_SKIN_TONE , "🧙🏽" => crate :: people_and_body :: person_fantasy :: MAGE_MEDIUM_SKIN_TONE , "🧙🏾" => crate :: people_and_body :: person_fantasy :: MAGE_MEDIUM_DARK_SKIN_TONE , "🧙🏿" => crate :: people_and_body :: person_fantasy :: MAGE_DARK_SKIN_TONE , "🧙\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_MAGE , "🧙\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_MAGE , "🧙🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_MAGE_LIGHT_SKIN_TONE , "🧙🏻\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_MAGE_LIGHT_SKIN_TONE , "🧙🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_MAGE_MEDIUM_LIGHT_SKIN_TONE , "🧙🏼\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_MAGE_MEDIUM_LIGHT_SKIN_TONE , "🧙🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_MAGE_MEDIUM_SKIN_TONE , "🧙🏽\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_MAGE_MEDIUM_SKIN_TONE , "🧙🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_MAGE_MEDIUM_DARK_SKIN_TONE , "🧙🏾\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_MAGE_MEDIUM_DARK_SKIN_TONE , "🧙🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_MAGE_DARK_SKIN_TONE , "🧙🏿\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_MAGE_DARK_SKIN_TONE , "🧙\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_MAGE , "🧙\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_MAGE , "🧙🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_MAGE_LIGHT_SKIN_TONE , "🧙🏻\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_MAGE_LIGHT_SKIN_TONE , "🧙🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_MAGE_MEDIUM_LIGHT_SKIN_TONE , "🧙🏼\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_MAGE_MEDIUM_LIGHT_SKIN_TONE , "🧙🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_MAGE_MEDIUM_SKIN_TONE , "🧙🏽\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_MAGE_MEDIUM_SKIN_TONE , "🧙🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_MAGE_MEDIUM_DARK_SKIN_TONE , "🧙🏾\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_MAGE_MEDIUM_DARK_SKIN_TONE , "🧙🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_MAGE_DARK_SKIN_TONE , "🧙🏿\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_MAGE_DARK_SKIN_TONE , "🧚" => crate :: people_and_body :: person_fantasy :: FAIRY , "🧚🏻" => crate :: people_and_body :: person_fantasy :: FAIRY_LIGHT_SKIN_TONE , "🧚🏼" => crate :: people_and_body :: person_fantasy :: FAIRY_MEDIUM_LIGHT_SKIN_TONE , "🧚🏽" => crate :: people_and_body :: person_fantasy :: FAIRY_MEDIUM_SKIN_TONE , "🧚🏾" => crate :: people_and_body :: person_fantasy :: FAIRY_MEDIUM_DARK_SKIN_TONE , "🧚🏿" => crate :: people_and_body :: person_fantasy :: FAIRY_DARK_SKIN_TONE , "🧚\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_FAIRY , "🧚\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_FAIRY , "🧚🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_FAIRY_LIGHT_SKIN_TONE , "🧚🏻\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_FAIRY_LIGHT_SKIN_TONE , "🧚🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_FAIRY_MEDIUM_LIGHT_SKIN_TONE , "🧚🏼\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_FAIRY_MEDIUM_LIGHT_SKIN_TONE , "🧚🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_FAIRY_MEDIUM_SKIN_TONE , "🧚🏽\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_FAIRY_MEDIUM_SKIN_TONE , "🧚🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_FAIRY_MEDIUM_DARK_SKIN_TONE , "🧚🏾\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_FAIRY_MEDIUM_DARK_SKIN_TONE , "🧚🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_FAIRY_DARK_SKIN_TONE , "🧚🏿\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_FAIRY_DARK_SKIN_TONE , "🧚\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_FAIRY , "🧚\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_FAIRY , "🧚🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_FAIRY_LIGHT_SKIN_TONE , "🧚🏻\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_FAIRY_LIGHT_SKIN_TONE , "🧚🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_FAIRY_MEDIUM_LIGHT_SKIN_TONE , "🧚🏼\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_FAIRY_MEDIUM_LIGHT_SKIN_TONE , "🧚🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_FAIRY_MEDIUM_SKIN_TONE , "🧚🏽\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_FAIRY_MEDIUM_SKIN_TONE , "🧚🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_FAIRY_MEDIUM_DARK_SKIN_TONE , "🧚🏾\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_FAIRY_MEDIUM_DARK_SKIN_TONE , "🧚🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_FAIRY_DARK_SKIN_TONE , "🧚🏿\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_FAIRY_DARK_SKIN_TONE , "🧛" => crate :: people_and_body :: person_fantasy :: VAMPIRE , "🧛🏻" => crate :: people_and_body :: person_fantasy :: VAMPIRE_LIGHT_SKIN_TONE , "🧛🏼" => crate :: people_and_body :: person_fantasy :: VAMPIRE_MEDIUM_LIGHT_SKIN_TONE , "🧛🏽" => crate :: people_and_body :: person_fantasy :: VAMPIRE_MEDIUM_SKIN_TONE , "🧛🏾" => crate :: people_and_body :: person_fantasy :: VAMPIRE_MEDIUM_DARK_SKIN_TONE , "🧛🏿" => crate :: people_and_body :: person_fantasy :: VAMPIRE_DARK_SKIN_TONE , "🧛\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_VAMPIRE , "🧛\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_VAMPIRE , "🧛🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_VAMPIRE_LIGHT_SKIN_TONE , "🧛🏻\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_VAMPIRE_LIGHT_SKIN_TONE , "🧛🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_VAMPIRE_MEDIUM_LIGHT_SKIN_TONE , "🧛🏼\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_VAMPIRE_MEDIUM_LIGHT_SKIN_TONE , "🧛🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_VAMPIRE_MEDIUM_SKIN_TONE , "🧛🏽\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_VAMPIRE_MEDIUM_SKIN_TONE , "🧛🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_VAMPIRE_MEDIUM_DARK_SKIN_TONE , "🧛🏾\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_VAMPIRE_MEDIUM_DARK_SKIN_TONE , "🧛🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_VAMPIRE_DARK_SKIN_TONE , "🧛🏿\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_VAMPIRE_DARK_SKIN_TONE , "🧛\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_VAMPIRE , "🧛\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_VAMPIRE , "🧛🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_VAMPIRE_LIGHT_SKIN_TONE , "🧛🏻\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_VAMPIRE_LIGHT_SKIN_TONE , "🧛🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_VAMPIRE_MEDIUM_LIGHT_SKIN_TONE , "🧛🏼\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_VAMPIRE_MEDIUM_LIGHT_SKIN_TONE , "🧛🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_VAMPIRE_MEDIUM_SKIN_TONE , "🧛🏽\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_VAMPIRE_MEDIUM_SKIN_TONE , "🧛🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_VAMPIRE_MEDIUM_DARK_SKIN_TONE , "🧛🏾\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_VAMPIRE_MEDIUM_DARK_SKIN_TONE , "🧛🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_VAMPIRE_DARK_SKIN_TONE , "🧛🏿\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_VAMPIRE_DARK_SKIN_TONE , "🧜" => crate :: people_and_body :: person_fantasy :: MERPERSON , "🧜🏻" => crate :: people_and_body :: person_fantasy :: MERPERSON_LIGHT_SKIN_TONE , "🧜🏼" => crate :: people_and_body :: person_fantasy :: MERPERSON_MEDIUM_LIGHT_SKIN_TONE , "🧜🏽" => crate :: people_and_body :: person_fantasy :: MERPERSON_MEDIUM_SKIN_TONE , "🧜🏾" => crate :: people_and_body :: person_fantasy :: MERPERSON_MEDIUM_DARK_SKIN_TONE , "🧜🏿" => crate :: people_and_body :: person_fantasy :: MERPERSON_DARK_SKIN_TONE , "🧜\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MERMAN , "🧜\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MERMAN , "🧜🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MERMAN_LIGHT_SKIN_TONE , "🧜🏻\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MERMAN_LIGHT_SKIN_TONE , "🧜🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MERMAN_MEDIUM_LIGHT_SKIN_TONE , "🧜🏼\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MERMAN_MEDIUM_LIGHT_SKIN_TONE , "🧜🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MERMAN_MEDIUM_SKIN_TONE , "🧜🏽\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MERMAN_MEDIUM_SKIN_TONE , "🧜🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MERMAN_MEDIUM_DARK_SKIN_TONE , "🧜🏾\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MERMAN_MEDIUM_DARK_SKIN_TONE , "🧜🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MERMAN_DARK_SKIN_TONE , "🧜🏿\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MERMAN_DARK_SKIN_TONE , "🧜\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MERMAID , "🧜\u{200d}♀" => crate :: people_and_body :: person_fantasy :: MERMAID , "🧜🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MERMAID_LIGHT_SKIN_TONE , "🧜🏻\u{200d}♀" => crate :: people_and_body :: person_fantasy :: MERMAID_LIGHT_SKIN_TONE , "🧜🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MERMAID_MEDIUM_LIGHT_SKIN_TONE , "🧜🏼\u{200d}♀" => crate :: people_and_body :: person_fantasy :: MERMAID_MEDIUM_LIGHT_SKIN_TONE , "🧜🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MERMAID_MEDIUM_SKIN_TONE , "🧜🏽\u{200d}♀" => crate :: people_and_body :: person_fantasy :: MERMAID_MEDIUM_SKIN_TONE , "🧜🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MERMAID_MEDIUM_DARK_SKIN_TONE , "🧜🏾\u{200d}♀" => crate :: people_and_body :: person_fantasy :: MERMAID_MEDIUM_DARK_SKIN_TONE , "🧜🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MERMAID_DARK_SKIN_TONE , "🧜🏿\u{200d}♀" => crate :: people_and_body :: person_fantasy :: MERMAID_DARK_SKIN_TONE , "🧝" => crate :: people_and_body :: person_fantasy :: ELF , "🧝🏻" => crate :: people_and_body :: person_fantasy :: ELF_LIGHT_SKIN_TONE , "🧝🏼" => crate :: people_and_body :: person_fantasy :: ELF_MEDIUM_LIGHT_SKIN_TONE , "🧝🏽" => crate :: people_and_body :: person_fantasy :: ELF_MEDIUM_SKIN_TONE , "🧝🏾" => crate :: people_and_body :: person_fantasy :: ELF_MEDIUM_DARK_SKIN_TONE , "🧝🏿" => crate :: people_and_body :: person_fantasy :: ELF_DARK_SKIN_TONE , "🧝\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_ELF , "🧝\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_ELF , "🧝🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_ELF_LIGHT_SKIN_TONE , "🧝🏻\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_ELF_LIGHT_SKIN_TONE , "🧝🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_ELF_MEDIUM_LIGHT_SKIN_TONE , "🧝🏼\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_ELF_MEDIUM_LIGHT_SKIN_TONE , "🧝🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_ELF_MEDIUM_SKIN_TONE , "🧝🏽\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_ELF_MEDIUM_SKIN_TONE , "🧝🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_ELF_MEDIUM_DARK_SKIN_TONE , "🧝🏾\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_ELF_MEDIUM_DARK_SKIN_TONE , "🧝🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_ELF_DARK_SKIN_TONE , "🧝🏿\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_ELF_DARK_SKIN_TONE , "🧝\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_ELF , "🧝\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_ELF , "🧝🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_ELF_LIGHT_SKIN_TONE , "🧝🏻\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_ELF_LIGHT_SKIN_TONE , "🧝🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_ELF_MEDIUM_LIGHT_SKIN_TONE , "🧝🏼\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_ELF_MEDIUM_LIGHT_SKIN_TONE , "🧝🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_ELF_MEDIUM_SKIN_TONE , "🧝🏽\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_ELF_MEDIUM_SKIN_TONE , "🧝🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_ELF_MEDIUM_DARK_SKIN_TONE , "🧝🏾\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_ELF_MEDIUM_DARK_SKIN_TONE , "🧝🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_ELF_DARK_SKIN_TONE , "🧝🏿\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_ELF_DARK_SKIN_TONE , "🧞" => crate :: people_and_body :: person_fantasy :: GENIE , "🧞\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_GENIE , "🧞\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_GENIE , "🧞\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_GENIE , "🧞\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_GENIE , "🧟" => crate :: people_and_body :: person_fantasy :: ZOMBIE , "🧟\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_fantasy :: MAN_ZOMBIE , "🧟\u{200d}♂" => crate :: people_and_body :: person_fantasy :: MAN_ZOMBIE , "🧟\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_fantasy :: WOMAN_ZOMBIE , "🧟\u{200d}♀" => crate :: people_and_body :: person_fantasy :: WOMAN_ZOMBIE , "💆" => crate :: people_and_body :: person_activity :: PERSON_GETTING_MASSAGE , "💆🏻" => crate :: people_and_body :: person_activity :: PERSON_GETTING_MASSAGE_LIGHT_SKIN_TONE , "💆🏼" => crate :: people_and_body :: person_activity :: PERSON_GETTING_MASSAGE_MEDIUM_LIGHT_SKIN_TONE , "💆🏽" => crate :: people_and_body :: person_activity :: PERSON_GETTING_MASSAGE_MEDIUM_SKIN_TONE , "💆🏾" => crate :: people_and_body :: person_activity :: PERSON_GETTING_MASSAGE_MEDIUM_DARK_SKIN_TONE , "💆🏿" => crate :: people_and_body :: person_activity :: PERSON_GETTING_MASSAGE_DARK_SKIN_TONE , "💆\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_GETTING_MASSAGE , "💆\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_GETTING_MASSAGE , "💆🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_GETTING_MASSAGE_LIGHT_SKIN_TONE , "💆🏻\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_GETTING_MASSAGE_LIGHT_SKIN_TONE , "💆🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_GETTING_MASSAGE_MEDIUM_LIGHT_SKIN_TONE , "💆🏼\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_GETTING_MASSAGE_MEDIUM_LIGHT_SKIN_TONE , "💆🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_GETTING_MASSAGE_MEDIUM_SKIN_TONE , "💆🏽\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_GETTING_MASSAGE_MEDIUM_SKIN_TONE , "💆🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_GETTING_MASSAGE_MEDIUM_DARK_SKIN_TONE , "💆🏾\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_GETTING_MASSAGE_MEDIUM_DARK_SKIN_TONE , "💆🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_GETTING_MASSAGE_DARK_SKIN_TONE , "💆🏿\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_GETTING_MASSAGE_DARK_SKIN_TONE , "💆\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_GETTING_MASSAGE , "💆\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_GETTING_MASSAGE , "💆🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_GETTING_MASSAGE_LIGHT_SKIN_TONE , "💆🏻\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_GETTING_MASSAGE_LIGHT_SKIN_TONE , "💆🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_GETTING_MASSAGE_MEDIUM_LIGHT_SKIN_TONE , "💆🏼\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_GETTING_MASSAGE_MEDIUM_LIGHT_SKIN_TONE , "💆🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_GETTING_MASSAGE_MEDIUM_SKIN_TONE , "💆🏽\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_GETTING_MASSAGE_MEDIUM_SKIN_TONE , "💆🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_GETTING_MASSAGE_MEDIUM_DARK_SKIN_TONE , "💆🏾\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_GETTING_MASSAGE_MEDIUM_DARK_SKIN_TONE , "💆🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_GETTING_MASSAGE_DARK_SKIN_TONE , "💆🏿\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_GETTING_MASSAGE_DARK_SKIN_TONE , "💇" => crate :: people_and_body :: person_activity :: PERSON_GETTING_HAIRCUT , "💇🏻" => crate :: people_and_body :: person_activity :: PERSON_GETTING_HAIRCUT_LIGHT_SKIN_TONE , "💇🏼" => crate :: people_and_body :: person_activity :: PERSON_GETTING_HAIRCUT_MEDIUM_LIGHT_SKIN_TONE , "💇🏽" => crate :: people_and_body :: person_activity :: PERSON_GETTING_HAIRCUT_MEDIUM_SKIN_TONE , "💇🏾" => crate :: people_and_body :: person_activity :: PERSON_GETTING_HAIRCUT_MEDIUM_DARK_SKIN_TONE , "💇🏿" => crate :: people_and_body :: person_activity :: PERSON_GETTING_HAIRCUT_DARK_SKIN_TONE , "💇\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_GETTING_HAIRCUT , "💇\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_GETTING_HAIRCUT , "💇🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_GETTING_HAIRCUT_LIGHT_SKIN_TONE , "💇🏻\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_GETTING_HAIRCUT_LIGHT_SKIN_TONE , "💇🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_GETTING_HAIRCUT_MEDIUM_LIGHT_SKIN_TONE , "💇🏼\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_GETTING_HAIRCUT_MEDIUM_LIGHT_SKIN_TONE , "💇🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_GETTING_HAIRCUT_MEDIUM_SKIN_TONE , "💇🏽\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_GETTING_HAIRCUT_MEDIUM_SKIN_TONE , "💇🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_GETTING_HAIRCUT_MEDIUM_DARK_SKIN_TONE , "💇🏾\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_GETTING_HAIRCUT_MEDIUM_DARK_SKIN_TONE , "💇🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_GETTING_HAIRCUT_DARK_SKIN_TONE , "💇🏿\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_GETTING_HAIRCUT_DARK_SKIN_TONE , "💇\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_GETTING_HAIRCUT , "💇\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_GETTING_HAIRCUT , "💇🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_GETTING_HAIRCUT_LIGHT_SKIN_TONE , "💇🏻\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_GETTING_HAIRCUT_LIGHT_SKIN_TONE , "💇🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_GETTING_HAIRCUT_MEDIUM_LIGHT_SKIN_TONE , "💇🏼\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_GETTING_HAIRCUT_MEDIUM_LIGHT_SKIN_TONE , "💇🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_GETTING_HAIRCUT_MEDIUM_SKIN_TONE , "💇🏽\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_GETTING_HAIRCUT_MEDIUM_SKIN_TONE , "💇🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_GETTING_HAIRCUT_MEDIUM_DARK_SKIN_TONE , "💇🏾\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_GETTING_HAIRCUT_MEDIUM_DARK_SKIN_TONE , "💇🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_GETTING_HAIRCUT_DARK_SKIN_TONE , "💇🏿\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_GETTING_HAIRCUT_DARK_SKIN_TONE , "🚶" => crate :: people_and_body :: person_activity :: PERSON_WALKING , "🚶🏻" => crate :: people_and_body :: person_activity :: PERSON_WALKING_LIGHT_SKIN_TONE , "🚶🏼" => crate :: people_and_body :: person_activity :: PERSON_WALKING_MEDIUM_LIGHT_SKIN_TONE , "🚶🏽" => crate :: people_and_body :: person_activity :: PERSON_WALKING_MEDIUM_SKIN_TONE , "🚶🏾" => crate :: people_and_body :: person_activity :: PERSON_WALKING_MEDIUM_DARK_SKIN_TONE , "🚶🏿" => crate :: people_and_body :: person_activity :: PERSON_WALKING_DARK_SKIN_TONE , "🚶\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_WALKING , "🚶\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_WALKING , "🚶🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_WALKING_LIGHT_SKIN_TONE , "🚶🏻\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_WALKING_LIGHT_SKIN_TONE , "🚶🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_WALKING_MEDIUM_LIGHT_SKIN_TONE , "🚶🏼\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_WALKING_MEDIUM_LIGHT_SKIN_TONE , "🚶🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_WALKING_MEDIUM_SKIN_TONE , "🚶🏽\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_WALKING_MEDIUM_SKIN_TONE , "🚶🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_WALKING_MEDIUM_DARK_SKIN_TONE , "🚶🏾\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_WALKING_MEDIUM_DARK_SKIN_TONE , "🚶🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_WALKING_DARK_SKIN_TONE , "🚶🏿\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_WALKING_DARK_SKIN_TONE , "🚶\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_WALKING , "🚶\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_WALKING , "🚶🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_WALKING_LIGHT_SKIN_TONE , "🚶🏻\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_WALKING_LIGHT_SKIN_TONE , "🚶🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_WALKING_MEDIUM_LIGHT_SKIN_TONE , "🚶🏼\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_WALKING_MEDIUM_LIGHT_SKIN_TONE , "🚶🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_WALKING_MEDIUM_SKIN_TONE , "🚶🏽\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_WALKING_MEDIUM_SKIN_TONE , "🚶🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_WALKING_MEDIUM_DARK_SKIN_TONE , "🚶🏾\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_WALKING_MEDIUM_DARK_SKIN_TONE , "🚶🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_WALKING_DARK_SKIN_TONE , "🚶🏿\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_WALKING_DARK_SKIN_TONE , "🧍" => crate :: people_and_body :: person_activity :: PERSON_STANDING , "🧍🏻" => crate :: people_and_body :: person_activity :: PERSON_STANDING_LIGHT_SKIN_TONE , "🧍🏼" => crate :: people_and_body :: person_activity :: PERSON_STANDING_MEDIUM_LIGHT_SKIN_TONE , "🧍🏽" => crate :: people_and_body :: person_activity :: PERSON_STANDING_MEDIUM_SKIN_TONE , "🧍🏾" => crate :: people_and_body :: person_activity :: PERSON_STANDING_MEDIUM_DARK_SKIN_TONE , "🧍🏿" => crate :: people_and_body :: person_activity :: PERSON_STANDING_DARK_SKIN_TONE , "🧍\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_STANDING , "🧍\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_STANDING , "🧍🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_STANDING_LIGHT_SKIN_TONE , "🧍🏻\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_STANDING_LIGHT_SKIN_TONE , "🧍🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_STANDING_MEDIUM_LIGHT_SKIN_TONE , "🧍🏼\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_STANDING_MEDIUM_LIGHT_SKIN_TONE , "🧍🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_STANDING_MEDIUM_SKIN_TONE , "🧍🏽\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_STANDING_MEDIUM_SKIN_TONE , "🧍🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_STANDING_MEDIUM_DARK_SKIN_TONE , "🧍🏾\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_STANDING_MEDIUM_DARK_SKIN_TONE , "🧍🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_STANDING_DARK_SKIN_TONE , "🧍🏿\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_STANDING_DARK_SKIN_TONE , "🧍\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_STANDING , "🧍\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_STANDING , "🧍🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_STANDING_LIGHT_SKIN_TONE , "🧍🏻\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_STANDING_LIGHT_SKIN_TONE , "🧍🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_STANDING_MEDIUM_LIGHT_SKIN_TONE , "🧍🏼\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_STANDING_MEDIUM_LIGHT_SKIN_TONE , "🧍🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_STANDING_MEDIUM_SKIN_TONE , "🧍🏽\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_STANDING_MEDIUM_SKIN_TONE , "🧍🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_STANDING_MEDIUM_DARK_SKIN_TONE , "🧍🏾\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_STANDING_MEDIUM_DARK_SKIN_TONE , "🧍🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_STANDING_DARK_SKIN_TONE , "🧍🏿\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_STANDING_DARK_SKIN_TONE , "🧎" => crate :: people_and_body :: person_activity :: PERSON_KNEELING , "🧎🏻" => crate :: people_and_body :: person_activity :: PERSON_KNEELING_LIGHT_SKIN_TONE , "🧎🏼" => crate :: people_and_body :: person_activity :: PERSON_KNEELING_MEDIUM_LIGHT_SKIN_TONE , "🧎🏽" => crate :: people_and_body :: person_activity :: PERSON_KNEELING_MEDIUM_SKIN_TONE , "🧎🏾" => crate :: people_and_body :: person_activity :: PERSON_KNEELING_MEDIUM_DARK_SKIN_TONE , "🧎🏿" => crate :: people_and_body :: person_activity :: PERSON_KNEELING_DARK_SKIN_TONE , "🧎\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_KNEELING , "🧎\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_KNEELING , "🧎🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_KNEELING_LIGHT_SKIN_TONE , "🧎🏻\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_KNEELING_LIGHT_SKIN_TONE , "🧎🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_KNEELING_MEDIUM_LIGHT_SKIN_TONE , "🧎🏼\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_KNEELING_MEDIUM_LIGHT_SKIN_TONE , "🧎🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_KNEELING_MEDIUM_SKIN_TONE , "🧎🏽\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_KNEELING_MEDIUM_SKIN_TONE , "🧎🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_KNEELING_MEDIUM_DARK_SKIN_TONE , "🧎🏾\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_KNEELING_MEDIUM_DARK_SKIN_TONE , "🧎🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_KNEELING_DARK_SKIN_TONE , "🧎🏿\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_KNEELING_DARK_SKIN_TONE , "🧎\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_KNEELING , "🧎\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_KNEELING , "🧎🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_KNEELING_LIGHT_SKIN_TONE , "🧎🏻\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_KNEELING_LIGHT_SKIN_TONE , "🧎🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_KNEELING_MEDIUM_LIGHT_SKIN_TONE , "🧎🏼\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_KNEELING_MEDIUM_LIGHT_SKIN_TONE , "🧎🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_KNEELING_MEDIUM_SKIN_TONE , "🧎🏽\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_KNEELING_MEDIUM_SKIN_TONE , "🧎🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_KNEELING_MEDIUM_DARK_SKIN_TONE , "🧎🏾\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_KNEELING_MEDIUM_DARK_SKIN_TONE , "🧎🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_KNEELING_DARK_SKIN_TONE , "🧎🏿\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_KNEELING_DARK_SKIN_TONE , "🧑\u{200d}🦯" => crate :: people_and_body :: person_activity :: PERSON_WITH_WHITE_CANE , "🧑🏻\u{200d}🦯" => crate :: people_and_body :: person_activity :: PERSON_WITH_WHITE_CANE_LIGHT_SKIN_TONE , "🧑🏼\u{200d}🦯" => crate :: people_and_body :: person_activity :: PERSON_WITH_WHITE_CANE_MEDIUM_LIGHT_SKIN_TONE , "🧑🏽\u{200d}🦯" => crate :: people_and_body :: person_activity :: PERSON_WITH_WHITE_CANE_MEDIUM_SKIN_TONE , "🧑🏾\u{200d}🦯" => crate :: people_and_body :: person_activity :: PERSON_WITH_WHITE_CANE_MEDIUM_DARK_SKIN_TONE , "🧑🏿\u{200d}🦯" => crate :: people_and_body :: person_activity :: PERSON_WITH_WHITE_CANE_DARK_SKIN_TONE , "👨\u{200d}🦯" => crate :: people_and_body :: person_activity :: MAN_WITH_WHITE_CANE , "👨🏻\u{200d}🦯" => crate :: people_and_body :: person_activity :: MAN_WITH_WHITE_CANE_LIGHT_SKIN_TONE , "👨🏼\u{200d}🦯" => crate :: people_and_body :: person_activity :: MAN_WITH_WHITE_CANE_MEDIUM_LIGHT_SKIN_TONE , "👨🏽\u{200d}🦯" => crate :: people_and_body :: person_activity :: MAN_WITH_WHITE_CANE_MEDIUM_SKIN_TONE , "👨🏾\u{200d}🦯" => crate :: people_and_body :: person_activity :: MAN_WITH_WHITE_CANE_MEDIUM_DARK_SKIN_TONE , "👨🏿\u{200d}🦯" => crate :: people_and_body :: person_activity :: MAN_WITH_WHITE_CANE_DARK_SKIN_TONE , "👩\u{200d}🦯" => crate :: people_and_body :: person_activity :: WOMAN_WITH_WHITE_CANE , "👩🏻\u{200d}🦯" => crate :: people_and_body :: person_activity :: WOMAN_WITH_WHITE_CANE_LIGHT_SKIN_TONE , "👩🏼\u{200d}🦯" => crate :: people_and_body :: person_activity :: WOMAN_WITH_WHITE_CANE_MEDIUM_LIGHT_SKIN_TONE , "👩🏽\u{200d}🦯" => crate :: people_and_body :: person_activity :: WOMAN_WITH_WHITE_CANE_MEDIUM_SKIN_TONE , "👩🏾\u{200d}🦯" => crate :: people_and_body :: person_activity :: WOMAN_WITH_WHITE_CANE_MEDIUM_DARK_SKIN_TONE , "👩🏿\u{200d}🦯" => crate :: people_and_body :: person_activity :: WOMAN_WITH_WHITE_CANE_DARK_SKIN_TONE , "🧑\u{200d}🦼" => crate :: people_and_body :: person_activity :: PERSON_IN_MOTORIZED_WHEELCHAIR , "🧑🏻\u{200d}🦼" => crate :: people_and_body :: person_activity :: PERSON_IN_MOTORIZED_WHEELCHAIR_LIGHT_SKIN_TONE , "🧑🏼\u{200d}🦼" => crate :: people_and_body :: person_activity :: PERSON_IN_MOTORIZED_WHEELCHAIR_MEDIUM_LIGHT_SKIN_TONE , "🧑🏽\u{200d}🦼" => crate :: people_and_body :: person_activity :: PERSON_IN_MOTORIZED_WHEELCHAIR_MEDIUM_SKIN_TONE , "🧑🏾\u{200d}🦼" => crate :: people_and_body :: person_activity :: PERSON_IN_MOTORIZED_WHEELCHAIR_MEDIUM_DARK_SKIN_TONE , "🧑🏿\u{200d}🦼" => crate :: people_and_body :: person_activity :: PERSON_IN_MOTORIZED_WHEELCHAIR_DARK_SKIN_TONE , "👨\u{200d}🦼" => crate :: people_and_body :: person_activity :: MAN_IN_MOTORIZED_WHEELCHAIR , "👨🏻\u{200d}🦼" => crate :: people_and_body :: person_activity :: MAN_IN_MOTORIZED_WHEELCHAIR_LIGHT_SKIN_TONE , "👨🏼\u{200d}🦼" => crate :: people_and_body :: person_activity :: MAN_IN_MOTORIZED_WHEELCHAIR_MEDIUM_LIGHT_SKIN_TONE , "👨🏽\u{200d}🦼" => crate :: people_and_body :: person_activity :: MAN_IN_MOTORIZED_WHEELCHAIR_MEDIUM_SKIN_TONE , "👨🏾\u{200d}🦼" => crate :: people_and_body :: person_activity :: MAN_IN_MOTORIZED_WHEELCHAIR_MEDIUM_DARK_SKIN_TONE , "👨🏿\u{200d}🦼" => crate :: people_and_body :: person_activity :: MAN_IN_MOTORIZED_WHEELCHAIR_DARK_SKIN_TONE , "👩\u{200d}🦼" => crate :: people_and_body :: person_activity :: WOMAN_IN_MOTORIZED_WHEELCHAIR , "👩🏻\u{200d}🦼" => crate :: people_and_body :: person_activity :: WOMAN_IN_MOTORIZED_WHEELCHAIR_LIGHT_SKIN_TONE , "👩🏼\u{200d}🦼" => crate :: people_and_body :: person_activity :: WOMAN_IN_MOTORIZED_WHEELCHAIR_MEDIUM_LIGHT_SKIN_TONE , "👩🏽\u{200d}🦼" => crate :: people_and_body :: person_activity :: WOMAN_IN_MOTORIZED_WHEELCHAIR_MEDIUM_SKIN_TONE , "👩🏾\u{200d}🦼" => crate :: people_and_body :: person_activity :: WOMAN_IN_MOTORIZED_WHEELCHAIR_MEDIUM_DARK_SKIN_TONE , "👩🏿\u{200d}🦼" => crate :: people_and_body :: person_activity :: WOMAN_IN_MOTORIZED_WHEELCHAIR_DARK_SKIN_TONE , "🧑\u{200d}🦽" => crate :: people_and_body :: person_activity :: PERSON_IN_MANUAL_WHEELCHAIR , "🧑🏻\u{200d}🦽" => crate :: people_and_body :: person_activity :: PERSON_IN_MANUAL_WHEELCHAIR_LIGHT_SKIN_TONE , "🧑🏼\u{200d}🦽" => crate :: people_and_body :: person_activity :: PERSON_IN_MANUAL_WHEELCHAIR_MEDIUM_LIGHT_SKIN_TONE , "🧑🏽\u{200d}🦽" => crate :: people_and_body :: person_activity :: PERSON_IN_MANUAL_WHEELCHAIR_MEDIUM_SKIN_TONE , "🧑🏾\u{200d}🦽" => crate :: people_and_body :: person_activity :: PERSON_IN_MANUAL_WHEELCHAIR_MEDIUM_DARK_SKIN_TONE , "🧑🏿\u{200d}🦽" => crate :: people_and_body :: person_activity :: PERSON_IN_MANUAL_WHEELCHAIR_DARK_SKIN_TONE , "👨\u{200d}🦽" => crate :: people_and_body :: person_activity :: MAN_IN_MANUAL_WHEELCHAIR , "👨🏻\u{200d}🦽" => crate :: people_and_body :: person_activity :: MAN_IN_MANUAL_WHEELCHAIR_LIGHT_SKIN_TONE , "👨🏼\u{200d}🦽" => crate :: people_and_body :: person_activity :: MAN_IN_MANUAL_WHEELCHAIR_MEDIUM_LIGHT_SKIN_TONE , "👨🏽\u{200d}🦽" => crate :: people_and_body :: person_activity :: MAN_IN_MANUAL_WHEELCHAIR_MEDIUM_SKIN_TONE , "👨🏾\u{200d}🦽" => crate :: people_and_body :: person_activity :: MAN_IN_MANUAL_WHEELCHAIR_MEDIUM_DARK_SKIN_TONE , "👨🏿\u{200d}🦽" => crate :: people_and_body :: person_activity :: MAN_IN_MANUAL_WHEELCHAIR_DARK_SKIN_TONE , "👩\u{200d}🦽" => crate :: people_and_body :: person_activity :: WOMAN_IN_MANUAL_WHEELCHAIR , "👩🏻\u{200d}🦽" => crate :: people_and_body :: person_activity :: WOMAN_IN_MANUAL_WHEELCHAIR_LIGHT_SKIN_TONE , "👩🏼\u{200d}🦽" => crate :: people_and_body :: person_activity :: WOMAN_IN_MANUAL_WHEELCHAIR_MEDIUM_LIGHT_SKIN_TONE , "👩🏽\u{200d}🦽" => crate :: people_and_body :: person_activity :: WOMAN_IN_MANUAL_WHEELCHAIR_MEDIUM_SKIN_TONE , "👩🏾\u{200d}🦽" => crate :: people_and_body :: person_activity :: WOMAN_IN_MANUAL_WHEELCHAIR_MEDIUM_DARK_SKIN_TONE , "👩🏿\u{200d}🦽" => crate :: people_and_body :: person_activity :: WOMAN_IN_MANUAL_WHEELCHAIR_DARK_SKIN_TONE , "🏃" => crate :: people_and_body :: person_activity :: PERSON_RUNNING , "🏃🏻" => crate :: people_and_body :: person_activity :: PERSON_RUNNING_LIGHT_SKIN_TONE , "🏃🏼" => crate :: people_and_body :: person_activity :: PERSON_RUNNING_MEDIUM_LIGHT_SKIN_TONE , "🏃🏽" => crate :: people_and_body :: person_activity :: PERSON_RUNNING_MEDIUM_SKIN_TONE , "🏃🏾" => crate :: people_and_body :: person_activity :: PERSON_RUNNING_MEDIUM_DARK_SKIN_TONE , "🏃🏿" => crate :: people_and_body :: person_activity :: PERSON_RUNNING_DARK_SKIN_TONE , "🏃\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_RUNNING , "🏃\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_RUNNING , "🏃🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_RUNNING_LIGHT_SKIN_TONE , "🏃🏻\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_RUNNING_LIGHT_SKIN_TONE , "🏃🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_RUNNING_MEDIUM_LIGHT_SKIN_TONE , "🏃🏼\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_RUNNING_MEDIUM_LIGHT_SKIN_TONE , "🏃🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_RUNNING_MEDIUM_SKIN_TONE , "🏃🏽\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_RUNNING_MEDIUM_SKIN_TONE , "🏃🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_RUNNING_MEDIUM_DARK_SKIN_TONE , "🏃🏾\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_RUNNING_MEDIUM_DARK_SKIN_TONE , "🏃🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_RUNNING_DARK_SKIN_TONE , "🏃🏿\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_RUNNING_DARK_SKIN_TONE , "🏃\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_RUNNING , "🏃\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_RUNNING , "🏃🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_RUNNING_LIGHT_SKIN_TONE , "🏃🏻\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_RUNNING_LIGHT_SKIN_TONE , "🏃🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_RUNNING_MEDIUM_LIGHT_SKIN_TONE , "🏃🏼\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_RUNNING_MEDIUM_LIGHT_SKIN_TONE , "🏃🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_RUNNING_MEDIUM_SKIN_TONE , "🏃🏽\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_RUNNING_MEDIUM_SKIN_TONE , "🏃🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_RUNNING_MEDIUM_DARK_SKIN_TONE , "🏃🏾\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_RUNNING_MEDIUM_DARK_SKIN_TONE , "🏃🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_RUNNING_DARK_SKIN_TONE , "🏃🏿\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_RUNNING_DARK_SKIN_TONE , "💃" => crate :: people_and_body :: person_activity :: WOMAN_DANCING , "💃🏻" => crate :: people_and_body :: person_activity :: WOMAN_DANCING_LIGHT_SKIN_TONE , "💃🏼" => crate :: people_and_body :: person_activity :: WOMAN_DANCING_MEDIUM_LIGHT_SKIN_TONE , "💃🏽" => crate :: people_and_body :: person_activity :: WOMAN_DANCING_MEDIUM_SKIN_TONE , "💃🏾" => crate :: people_and_body :: person_activity :: WOMAN_DANCING_MEDIUM_DARK_SKIN_TONE , "💃🏿" => crate :: people_and_body :: person_activity :: WOMAN_DANCING_DARK_SKIN_TONE , "🕺" => crate :: people_and_body :: person_activity :: MAN_DANCING , "🕺🏻" => crate :: people_and_body :: person_activity :: MAN_DANCING_LIGHT_SKIN_TONE , "🕺🏼" => crate :: people_and_body :: person_activity :: MAN_DANCING_MEDIUM_LIGHT_SKIN_TONE , "🕺🏽" => crate :: people_and_body :: person_activity :: MAN_DANCING_MEDIUM_SKIN_TONE , "🕺🏾" => crate :: people_and_body :: person_activity :: MAN_DANCING_MEDIUM_DARK_SKIN_TONE , "🕺🏿" => crate :: people_and_body :: person_activity :: MAN_DANCING_DARK_SKIN_TONE , "🕴\u{fe0f}" => crate :: people_and_body :: person_activity :: PERSON_IN_SUIT_LEVITATING , "🕴" => crate :: people_and_body :: person_activity :: PERSON_IN_SUIT_LEVITATING , "🕴🏻" => crate :: people_and_body :: person_activity :: PERSON_IN_SUIT_LEVITATING_LIGHT_SKIN_TONE , "🕴🏼" => crate :: people_and_body :: person_activity :: PERSON_IN_SUIT_LEVITATING_MEDIUM_LIGHT_SKIN_TONE , "🕴🏽" => crate :: people_and_body :: person_activity :: PERSON_IN_SUIT_LEVITATING_MEDIUM_SKIN_TONE , "🕴🏾" => crate :: people_and_body :: person_activity :: PERSON_IN_SUIT_LEVITATING_MEDIUM_DARK_SKIN_TONE , "🕴🏿" => crate :: people_and_body :: person_activity :: PERSON_IN_SUIT_LEVITATING_DARK_SKIN_TONE , "👯" => crate :: people_and_body :: person_activity :: PEOPLE_WITH_BUNNY_EARS , "👯\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MEN_WITH_BUNNY_EARS , "👯\u{200d}♂" => crate :: people_and_body :: person_activity :: MEN_WITH_BUNNY_EARS , "👯\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMEN_WITH_BUNNY_EARS , "👯\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMEN_WITH_BUNNY_EARS , "🧖" => crate :: people_and_body :: person_activity :: PERSON_IN_STEAMY_ROOM , "🧖🏻" => crate :: people_and_body :: person_activity :: PERSON_IN_STEAMY_ROOM_LIGHT_SKIN_TONE , "🧖🏼" => crate :: people_and_body :: person_activity :: PERSON_IN_STEAMY_ROOM_MEDIUM_LIGHT_SKIN_TONE , "🧖🏽" => crate :: people_and_body :: person_activity :: PERSON_IN_STEAMY_ROOM_MEDIUM_SKIN_TONE , "🧖🏾" => crate :: people_and_body :: person_activity :: PERSON_IN_STEAMY_ROOM_MEDIUM_DARK_SKIN_TONE , "🧖🏿" => crate :: people_and_body :: person_activity :: PERSON_IN_STEAMY_ROOM_DARK_SKIN_TONE , "🧖\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_IN_STEAMY_ROOM , "🧖\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_IN_STEAMY_ROOM , "🧖🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_IN_STEAMY_ROOM_LIGHT_SKIN_TONE , "🧖🏻\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_IN_STEAMY_ROOM_LIGHT_SKIN_TONE , "🧖🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_IN_STEAMY_ROOM_MEDIUM_LIGHT_SKIN_TONE , "🧖🏼\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_IN_STEAMY_ROOM_MEDIUM_LIGHT_SKIN_TONE , "🧖🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_IN_STEAMY_ROOM_MEDIUM_SKIN_TONE , "🧖🏽\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_IN_STEAMY_ROOM_MEDIUM_SKIN_TONE , "🧖🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_IN_STEAMY_ROOM_MEDIUM_DARK_SKIN_TONE , "🧖🏾\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_IN_STEAMY_ROOM_MEDIUM_DARK_SKIN_TONE , "🧖🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_IN_STEAMY_ROOM_DARK_SKIN_TONE , "🧖🏿\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_IN_STEAMY_ROOM_DARK_SKIN_TONE , "🧖\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_IN_STEAMY_ROOM , "🧖\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_IN_STEAMY_ROOM , "🧖🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_IN_STEAMY_ROOM_LIGHT_SKIN_TONE , "🧖🏻\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_IN_STEAMY_ROOM_LIGHT_SKIN_TONE , "🧖🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_IN_STEAMY_ROOM_MEDIUM_LIGHT_SKIN_TONE , "🧖🏼\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_IN_STEAMY_ROOM_MEDIUM_LIGHT_SKIN_TONE , "🧖🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_IN_STEAMY_ROOM_MEDIUM_SKIN_TONE , "🧖🏽\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_IN_STEAMY_ROOM_MEDIUM_SKIN_TONE , "🧖🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_IN_STEAMY_ROOM_MEDIUM_DARK_SKIN_TONE , "🧖🏾\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_IN_STEAMY_ROOM_MEDIUM_DARK_SKIN_TONE , "🧖🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_IN_STEAMY_ROOM_DARK_SKIN_TONE , "🧖🏿\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_IN_STEAMY_ROOM_DARK_SKIN_TONE , "🧗" => crate :: people_and_body :: person_activity :: PERSON_CLIMBING , "🧗🏻" => crate :: people_and_body :: person_activity :: PERSON_CLIMBING_LIGHT_SKIN_TONE , "🧗🏼" => crate :: people_and_body :: person_activity :: PERSON_CLIMBING_MEDIUM_LIGHT_SKIN_TONE , "🧗🏽" => crate :: people_and_body :: person_activity :: PERSON_CLIMBING_MEDIUM_SKIN_TONE , "🧗🏾" => crate :: people_and_body :: person_activity :: PERSON_CLIMBING_MEDIUM_DARK_SKIN_TONE , "🧗🏿" => crate :: people_and_body :: person_activity :: PERSON_CLIMBING_DARK_SKIN_TONE , "🧗\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_CLIMBING , "🧗\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_CLIMBING , "🧗🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_CLIMBING_LIGHT_SKIN_TONE , "🧗🏻\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_CLIMBING_LIGHT_SKIN_TONE , "🧗🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_CLIMBING_MEDIUM_LIGHT_SKIN_TONE , "🧗🏼\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_CLIMBING_MEDIUM_LIGHT_SKIN_TONE , "🧗🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_CLIMBING_MEDIUM_SKIN_TONE , "🧗🏽\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_CLIMBING_MEDIUM_SKIN_TONE , "🧗🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_CLIMBING_MEDIUM_DARK_SKIN_TONE , "🧗🏾\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_CLIMBING_MEDIUM_DARK_SKIN_TONE , "🧗🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_activity :: MAN_CLIMBING_DARK_SKIN_TONE , "🧗🏿\u{200d}♂" => crate :: people_and_body :: person_activity :: MAN_CLIMBING_DARK_SKIN_TONE , "🧗\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_CLIMBING , "🧗\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_CLIMBING , "🧗🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_CLIMBING_LIGHT_SKIN_TONE , "🧗🏻\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_CLIMBING_LIGHT_SKIN_TONE , "🧗🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_CLIMBING_MEDIUM_LIGHT_SKIN_TONE , "🧗🏼\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_CLIMBING_MEDIUM_LIGHT_SKIN_TONE , "🧗🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_CLIMBING_MEDIUM_SKIN_TONE , "🧗🏽\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_CLIMBING_MEDIUM_SKIN_TONE , "🧗🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_CLIMBING_MEDIUM_DARK_SKIN_TONE , "🧗🏾\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_CLIMBING_MEDIUM_DARK_SKIN_TONE , "🧗🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_activity :: WOMAN_CLIMBING_DARK_SKIN_TONE , "🧗🏿\u{200d}♀" => crate :: people_and_body :: person_activity :: WOMAN_CLIMBING_DARK_SKIN_TONE , "🤺" => crate :: people_and_body :: person_sport :: PERSON_FENCING , "🏇" => crate :: people_and_body :: person_sport :: HORSE_RACING , "🏇🏻" => crate :: people_and_body :: person_sport :: HORSE_RACING_LIGHT_SKIN_TONE , "🏇🏼" => crate :: people_and_body :: person_sport :: HORSE_RACING_MEDIUM_LIGHT_SKIN_TONE , "🏇🏽" => crate :: people_and_body :: person_sport :: HORSE_RACING_MEDIUM_SKIN_TONE , "🏇🏾" => crate :: people_and_body :: person_sport :: HORSE_RACING_MEDIUM_DARK_SKIN_TONE , "🏇🏿" => crate :: people_and_body :: person_sport :: HORSE_RACING_DARK_SKIN_TONE , "⛷\u{fe0f}" => crate :: people_and_body :: person_sport :: SKIER , "⛷" => crate :: people_and_body :: person_sport :: SKIER , "🏂" => crate :: people_and_body :: person_sport :: SNOWBOARDER , "🏂🏻" => crate :: people_and_body :: person_sport :: SNOWBOARDER_LIGHT_SKIN_TONE , "🏂🏼" => crate :: people_and_body :: person_sport :: SNOWBOARDER_MEDIUM_LIGHT_SKIN_TONE , "🏂🏽" => crate :: people_and_body :: person_sport :: SNOWBOARDER_MEDIUM_SKIN_TONE , "🏂🏾" => crate :: people_and_body :: person_sport :: SNOWBOARDER_MEDIUM_DARK_SKIN_TONE , "🏂🏿" => crate :: people_and_body :: person_sport :: SNOWBOARDER_DARK_SKIN_TONE , "🏌\u{fe0f}" => crate :: people_and_body :: person_sport :: PERSON_GOLFING , "🏌" => crate :: people_and_body :: person_sport :: PERSON_GOLFING , "🏌🏻" => crate :: people_and_body :: person_sport :: PERSON_GOLFING_LIGHT_SKIN_TONE , "🏌🏼" => crate :: people_and_body :: person_sport :: PERSON_GOLFING_MEDIUM_LIGHT_SKIN_TONE , "🏌🏽" => crate :: people_and_body :: person_sport :: PERSON_GOLFING_MEDIUM_SKIN_TONE , "🏌🏾" => crate :: people_and_body :: person_sport :: PERSON_GOLFING_MEDIUM_DARK_SKIN_TONE , "🏌🏿" => crate :: people_and_body :: person_sport :: PERSON_GOLFING_DARK_SKIN_TONE , "🏌\u{fe0f}\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_GOLFING , "🏌\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_GOLFING , "🏌\u{fe0f}\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_GOLFING , "🏌\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_GOLFING , "🏌🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_GOLFING_LIGHT_SKIN_TONE , "🏌🏻\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_GOLFING_LIGHT_SKIN_TONE , "🏌🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_GOLFING_MEDIUM_LIGHT_SKIN_TONE , "🏌🏼\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_GOLFING_MEDIUM_LIGHT_SKIN_TONE , "🏌🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_GOLFING_MEDIUM_SKIN_TONE , "🏌🏽\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_GOLFING_MEDIUM_SKIN_TONE , "🏌🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_GOLFING_MEDIUM_DARK_SKIN_TONE , "🏌🏾\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_GOLFING_MEDIUM_DARK_SKIN_TONE , "🏌🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_GOLFING_DARK_SKIN_TONE , "🏌🏿\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_GOLFING_DARK_SKIN_TONE , "🏌\u{fe0f}\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_GOLFING , "🏌\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_GOLFING , "🏌\u{fe0f}\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_GOLFING , "🏌\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_GOLFING , "🏌🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_GOLFING_LIGHT_SKIN_TONE , "🏌🏻\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_GOLFING_LIGHT_SKIN_TONE , "🏌🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_GOLFING_MEDIUM_LIGHT_SKIN_TONE , "🏌🏼\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_GOLFING_MEDIUM_LIGHT_SKIN_TONE , "🏌🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_GOLFING_MEDIUM_SKIN_TONE , "🏌🏽\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_GOLFING_MEDIUM_SKIN_TONE , "🏌🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_GOLFING_MEDIUM_DARK_SKIN_TONE , "🏌🏾\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_GOLFING_MEDIUM_DARK_SKIN_TONE , "🏌🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_GOLFING_DARK_SKIN_TONE , "🏌🏿\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_GOLFING_DARK_SKIN_TONE , "🏄" => crate :: people_and_body :: person_sport :: PERSON_SURFING , "🏄🏻" => crate :: people_and_body :: person_sport :: PERSON_SURFING_LIGHT_SKIN_TONE , "🏄🏼" => crate :: people_and_body :: person_sport :: PERSON_SURFING_MEDIUM_LIGHT_SKIN_TONE , "🏄🏽" => crate :: people_and_body :: person_sport :: PERSON_SURFING_MEDIUM_SKIN_TONE , "🏄🏾" => crate :: people_and_body :: person_sport :: PERSON_SURFING_MEDIUM_DARK_SKIN_TONE , "🏄🏿" => crate :: people_and_body :: person_sport :: PERSON_SURFING_DARK_SKIN_TONE , "🏄\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_SURFING , "🏄\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_SURFING , "🏄🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_SURFING_LIGHT_SKIN_TONE , "🏄🏻\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_SURFING_LIGHT_SKIN_TONE , "🏄🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_SURFING_MEDIUM_LIGHT_SKIN_TONE , "🏄🏼\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_SURFING_MEDIUM_LIGHT_SKIN_TONE , "🏄🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_SURFING_MEDIUM_SKIN_TONE , "🏄🏽\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_SURFING_MEDIUM_SKIN_TONE , "🏄🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_SURFING_MEDIUM_DARK_SKIN_TONE , "🏄🏾\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_SURFING_MEDIUM_DARK_SKIN_TONE , "🏄🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_SURFING_DARK_SKIN_TONE , "🏄🏿\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_SURFING_DARK_SKIN_TONE , "🏄\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_SURFING , "🏄\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_SURFING , "🏄🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_SURFING_LIGHT_SKIN_TONE , "🏄🏻\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_SURFING_LIGHT_SKIN_TONE , "🏄🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_SURFING_MEDIUM_LIGHT_SKIN_TONE , "🏄🏼\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_SURFING_MEDIUM_LIGHT_SKIN_TONE , "🏄🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_SURFING_MEDIUM_SKIN_TONE , "🏄🏽\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_SURFING_MEDIUM_SKIN_TONE , "🏄🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_SURFING_MEDIUM_DARK_SKIN_TONE , "🏄🏾\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_SURFING_MEDIUM_DARK_SKIN_TONE , "🏄🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_SURFING_DARK_SKIN_TONE , "🏄🏿\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_SURFING_DARK_SKIN_TONE , "🚣" => crate :: people_and_body :: person_sport :: PERSON_ROWING_BOAT , "🚣🏻" => crate :: people_and_body :: person_sport :: PERSON_ROWING_BOAT_LIGHT_SKIN_TONE , "🚣🏼" => crate :: people_and_body :: person_sport :: PERSON_ROWING_BOAT_MEDIUM_LIGHT_SKIN_TONE , "🚣🏽" => crate :: people_and_body :: person_sport :: PERSON_ROWING_BOAT_MEDIUM_SKIN_TONE , "🚣🏾" => crate :: people_and_body :: person_sport :: PERSON_ROWING_BOAT_MEDIUM_DARK_SKIN_TONE , "🚣🏿" => crate :: people_and_body :: person_sport :: PERSON_ROWING_BOAT_DARK_SKIN_TONE , "🚣\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_ROWING_BOAT , "🚣\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_ROWING_BOAT , "🚣🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_ROWING_BOAT_LIGHT_SKIN_TONE , "🚣🏻\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_ROWING_BOAT_LIGHT_SKIN_TONE , "🚣🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_ROWING_BOAT_MEDIUM_LIGHT_SKIN_TONE , "🚣🏼\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_ROWING_BOAT_MEDIUM_LIGHT_SKIN_TONE , "🚣🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_ROWING_BOAT_MEDIUM_SKIN_TONE , "🚣🏽\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_ROWING_BOAT_MEDIUM_SKIN_TONE , "🚣🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_ROWING_BOAT_MEDIUM_DARK_SKIN_TONE , "🚣🏾\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_ROWING_BOAT_MEDIUM_DARK_SKIN_TONE , "🚣🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_ROWING_BOAT_DARK_SKIN_TONE , "🚣🏿\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_ROWING_BOAT_DARK_SKIN_TONE , "🚣\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_ROWING_BOAT , "🚣\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_ROWING_BOAT , "🚣🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_ROWING_BOAT_LIGHT_SKIN_TONE , "🚣🏻\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_ROWING_BOAT_LIGHT_SKIN_TONE , "🚣🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_ROWING_BOAT_MEDIUM_LIGHT_SKIN_TONE , "🚣🏼\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_ROWING_BOAT_MEDIUM_LIGHT_SKIN_TONE , "🚣🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_ROWING_BOAT_MEDIUM_SKIN_TONE , "🚣🏽\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_ROWING_BOAT_MEDIUM_SKIN_TONE , "🚣🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_ROWING_BOAT_MEDIUM_DARK_SKIN_TONE , "🚣🏾\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_ROWING_BOAT_MEDIUM_DARK_SKIN_TONE , "🚣🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_ROWING_BOAT_DARK_SKIN_TONE , "🚣🏿\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_ROWING_BOAT_DARK_SKIN_TONE , "🏊" => crate :: people_and_body :: person_sport :: PERSON_SWIMMING , "🏊🏻" => crate :: people_and_body :: person_sport :: PERSON_SWIMMING_LIGHT_SKIN_TONE , "🏊🏼" => crate :: people_and_body :: person_sport :: PERSON_SWIMMING_MEDIUM_LIGHT_SKIN_TONE , "🏊🏽" => crate :: people_and_body :: person_sport :: PERSON_SWIMMING_MEDIUM_SKIN_TONE , "🏊🏾" => crate :: people_and_body :: person_sport :: PERSON_SWIMMING_MEDIUM_DARK_SKIN_TONE , "🏊🏿" => crate :: people_and_body :: person_sport :: PERSON_SWIMMING_DARK_SKIN_TONE , "🏊\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_SWIMMING , "🏊\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_SWIMMING , "🏊🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_SWIMMING_LIGHT_SKIN_TONE , "🏊🏻\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_SWIMMING_LIGHT_SKIN_TONE , "🏊🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_SWIMMING_MEDIUM_LIGHT_SKIN_TONE , "🏊🏼\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_SWIMMING_MEDIUM_LIGHT_SKIN_TONE , "🏊🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_SWIMMING_MEDIUM_SKIN_TONE , "🏊🏽\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_SWIMMING_MEDIUM_SKIN_TONE , "🏊🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_SWIMMING_MEDIUM_DARK_SKIN_TONE , "🏊🏾\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_SWIMMING_MEDIUM_DARK_SKIN_TONE , "🏊🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_SWIMMING_DARK_SKIN_TONE , "🏊🏿\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_SWIMMING_DARK_SKIN_TONE , "🏊\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_SWIMMING , "🏊\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_SWIMMING , "🏊🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_SWIMMING_LIGHT_SKIN_TONE , "🏊🏻\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_SWIMMING_LIGHT_SKIN_TONE , "🏊🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_SWIMMING_MEDIUM_LIGHT_SKIN_TONE , "🏊🏼\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_SWIMMING_MEDIUM_LIGHT_SKIN_TONE , "🏊🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_SWIMMING_MEDIUM_SKIN_TONE , "🏊🏽\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_SWIMMING_MEDIUM_SKIN_TONE , "🏊🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_SWIMMING_MEDIUM_DARK_SKIN_TONE , "🏊🏾\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_SWIMMING_MEDIUM_DARK_SKIN_TONE , "🏊🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_SWIMMING_DARK_SKIN_TONE , "🏊🏿\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_SWIMMING_DARK_SKIN_TONE , "⛹\u{fe0f}" => crate :: people_and_body :: person_sport :: PERSON_BOUNCING_BALL , "⛹" => crate :: people_and_body :: person_sport :: PERSON_BOUNCING_BALL , "⛹🏻" => crate :: people_and_body :: person_sport :: PERSON_BOUNCING_BALL_LIGHT_SKIN_TONE , "⛹🏼" => crate :: people_and_body :: person_sport :: PERSON_BOUNCING_BALL_MEDIUM_LIGHT_SKIN_TONE , "⛹🏽" => crate :: people_and_body :: person_sport :: PERSON_BOUNCING_BALL_MEDIUM_SKIN_TONE , "⛹🏾" => crate :: people_and_body :: person_sport :: PERSON_BOUNCING_BALL_MEDIUM_DARK_SKIN_TONE , "⛹🏿" => crate :: people_and_body :: person_sport :: PERSON_BOUNCING_BALL_DARK_SKIN_TONE , "⛹\u{fe0f}\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_BOUNCING_BALL , "⛹\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_BOUNCING_BALL , "⛹\u{fe0f}\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_BOUNCING_BALL , "⛹\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_BOUNCING_BALL , "⛹🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_BOUNCING_BALL_LIGHT_SKIN_TONE , "⛹🏻\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_BOUNCING_BALL_LIGHT_SKIN_TONE , "⛹🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_BOUNCING_BALL_MEDIUM_LIGHT_SKIN_TONE , "⛹🏼\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_BOUNCING_BALL_MEDIUM_LIGHT_SKIN_TONE , "⛹🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_BOUNCING_BALL_MEDIUM_SKIN_TONE , "⛹🏽\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_BOUNCING_BALL_MEDIUM_SKIN_TONE , "⛹🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_BOUNCING_BALL_MEDIUM_DARK_SKIN_TONE , "⛹🏾\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_BOUNCING_BALL_MEDIUM_DARK_SKIN_TONE , "⛹🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_BOUNCING_BALL_DARK_SKIN_TONE , "⛹🏿\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_BOUNCING_BALL_DARK_SKIN_TONE , "⛹\u{fe0f}\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_BOUNCING_BALL , "⛹\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_BOUNCING_BALL , "⛹\u{fe0f}\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_BOUNCING_BALL , "⛹\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_BOUNCING_BALL , "⛹🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_BOUNCING_BALL_LIGHT_SKIN_TONE , "⛹🏻\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_BOUNCING_BALL_LIGHT_SKIN_TONE , "⛹🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_BOUNCING_BALL_MEDIUM_LIGHT_SKIN_TONE , "⛹🏼\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_BOUNCING_BALL_MEDIUM_LIGHT_SKIN_TONE , "⛹🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_BOUNCING_BALL_MEDIUM_SKIN_TONE , "⛹🏽\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_BOUNCING_BALL_MEDIUM_SKIN_TONE , "⛹🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_BOUNCING_BALL_MEDIUM_DARK_SKIN_TONE , "⛹🏾\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_BOUNCING_BALL_MEDIUM_DARK_SKIN_TONE , "⛹🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_BOUNCING_BALL_DARK_SKIN_TONE , "⛹🏿\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_BOUNCING_BALL_DARK_SKIN_TONE , "🏋\u{fe0f}" => crate :: people_and_body :: person_sport :: PERSON_LIFTING_WEIGHTS , "🏋" => crate :: people_and_body :: person_sport :: PERSON_LIFTING_WEIGHTS , "🏋🏻" => crate :: people_and_body :: person_sport :: PERSON_LIFTING_WEIGHTS_LIGHT_SKIN_TONE , "🏋🏼" => crate :: people_and_body :: person_sport :: PERSON_LIFTING_WEIGHTS_MEDIUM_LIGHT_SKIN_TONE , "🏋🏽" => crate :: people_and_body :: person_sport :: PERSON_LIFTING_WEIGHTS_MEDIUM_SKIN_TONE , "🏋🏾" => crate :: people_and_body :: person_sport :: PERSON_LIFTING_WEIGHTS_MEDIUM_DARK_SKIN_TONE , "🏋🏿" => crate :: people_and_body :: person_sport :: PERSON_LIFTING_WEIGHTS_DARK_SKIN_TONE , "🏋\u{fe0f}\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_LIFTING_WEIGHTS , "🏋\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_LIFTING_WEIGHTS , "🏋\u{fe0f}\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_LIFTING_WEIGHTS , "🏋\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_LIFTING_WEIGHTS , "🏋🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_LIFTING_WEIGHTS_LIGHT_SKIN_TONE , "🏋🏻\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_LIFTING_WEIGHTS_LIGHT_SKIN_TONE , "🏋🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_LIFTING_WEIGHTS_MEDIUM_LIGHT_SKIN_TONE , "🏋🏼\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_LIFTING_WEIGHTS_MEDIUM_LIGHT_SKIN_TONE , "🏋🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_LIFTING_WEIGHTS_MEDIUM_SKIN_TONE , "🏋🏽\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_LIFTING_WEIGHTS_MEDIUM_SKIN_TONE , "🏋🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_LIFTING_WEIGHTS_MEDIUM_DARK_SKIN_TONE , "🏋🏾\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_LIFTING_WEIGHTS_MEDIUM_DARK_SKIN_TONE , "🏋🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_LIFTING_WEIGHTS_DARK_SKIN_TONE , "🏋🏿\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_LIFTING_WEIGHTS_DARK_SKIN_TONE , "🏋\u{fe0f}\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_LIFTING_WEIGHTS , "🏋\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_LIFTING_WEIGHTS , "🏋\u{fe0f}\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_LIFTING_WEIGHTS , "🏋\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_LIFTING_WEIGHTS , "🏋🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_LIFTING_WEIGHTS_LIGHT_SKIN_TONE , "🏋🏻\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_LIFTING_WEIGHTS_LIGHT_SKIN_TONE , "🏋🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_LIFTING_WEIGHTS_MEDIUM_LIGHT_SKIN_TONE , "🏋🏼\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_LIFTING_WEIGHTS_MEDIUM_LIGHT_SKIN_TONE , "🏋🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_LIFTING_WEIGHTS_MEDIUM_SKIN_TONE , "🏋🏽\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_LIFTING_WEIGHTS_MEDIUM_SKIN_TONE , "🏋🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_LIFTING_WEIGHTS_MEDIUM_DARK_SKIN_TONE , "🏋🏾\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_LIFTING_WEIGHTS_MEDIUM_DARK_SKIN_TONE , "🏋🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_LIFTING_WEIGHTS_DARK_SKIN_TONE , "🏋🏿\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_LIFTING_WEIGHTS_DARK_SKIN_TONE , "🚴" => crate :: people_and_body :: person_sport :: PERSON_BIKING , "🚴🏻" => crate :: people_and_body :: person_sport :: PERSON_BIKING_LIGHT_SKIN_TONE , "🚴🏼" => crate :: people_and_body :: person_sport :: PERSON_BIKING_MEDIUM_LIGHT_SKIN_TONE , "🚴🏽" => crate :: people_and_body :: person_sport :: PERSON_BIKING_MEDIUM_SKIN_TONE , "🚴🏾" => crate :: people_and_body :: person_sport :: PERSON_BIKING_MEDIUM_DARK_SKIN_TONE , "🚴🏿" => crate :: people_and_body :: person_sport :: PERSON_BIKING_DARK_SKIN_TONE , "🚴\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_BIKING , "🚴\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_BIKING , "🚴🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_BIKING_LIGHT_SKIN_TONE , "🚴🏻\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_BIKING_LIGHT_SKIN_TONE , "🚴🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_BIKING_MEDIUM_LIGHT_SKIN_TONE , "🚴🏼\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_BIKING_MEDIUM_LIGHT_SKIN_TONE , "🚴🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_BIKING_MEDIUM_SKIN_TONE , "🚴🏽\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_BIKING_MEDIUM_SKIN_TONE , "🚴🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_BIKING_MEDIUM_DARK_SKIN_TONE , "🚴🏾\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_BIKING_MEDIUM_DARK_SKIN_TONE , "🚴🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_BIKING_DARK_SKIN_TONE , "🚴🏿\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_BIKING_DARK_SKIN_TONE , "🚴\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_BIKING , "🚴\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_BIKING , "🚴🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_BIKING_LIGHT_SKIN_TONE , "🚴🏻\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_BIKING_LIGHT_SKIN_TONE , "🚴🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_BIKING_MEDIUM_LIGHT_SKIN_TONE , "🚴🏼\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_BIKING_MEDIUM_LIGHT_SKIN_TONE , "🚴🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_BIKING_MEDIUM_SKIN_TONE , "🚴🏽\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_BIKING_MEDIUM_SKIN_TONE , "🚴🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_BIKING_MEDIUM_DARK_SKIN_TONE , "🚴🏾\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_BIKING_MEDIUM_DARK_SKIN_TONE , "🚴🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_BIKING_DARK_SKIN_TONE , "🚴🏿\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_BIKING_DARK_SKIN_TONE , "🚵" => crate :: people_and_body :: person_sport :: PERSON_MOUNTAIN_BIKING , "🚵🏻" => crate :: people_and_body :: person_sport :: PERSON_MOUNTAIN_BIKING_LIGHT_SKIN_TONE , "🚵🏼" => crate :: people_and_body :: person_sport :: PERSON_MOUNTAIN_BIKING_MEDIUM_LIGHT_SKIN_TONE , "🚵🏽" => crate :: people_and_body :: person_sport :: PERSON_MOUNTAIN_BIKING_MEDIUM_SKIN_TONE , "🚵🏾" => crate :: people_and_body :: person_sport :: PERSON_MOUNTAIN_BIKING_MEDIUM_DARK_SKIN_TONE , "🚵🏿" => crate :: people_and_body :: person_sport :: PERSON_MOUNTAIN_BIKING_DARK_SKIN_TONE , "🚵\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_MOUNTAIN_BIKING , "🚵\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_MOUNTAIN_BIKING , "🚵🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_MOUNTAIN_BIKING_LIGHT_SKIN_TONE , "🚵🏻\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_MOUNTAIN_BIKING_LIGHT_SKIN_TONE , "🚵🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_MOUNTAIN_BIKING_MEDIUM_LIGHT_SKIN_TONE , "🚵🏼\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_MOUNTAIN_BIKING_MEDIUM_LIGHT_SKIN_TONE , "🚵🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_MOUNTAIN_BIKING_MEDIUM_SKIN_TONE , "🚵🏽\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_MOUNTAIN_BIKING_MEDIUM_SKIN_TONE , "🚵🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_MOUNTAIN_BIKING_MEDIUM_DARK_SKIN_TONE , "🚵🏾\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_MOUNTAIN_BIKING_MEDIUM_DARK_SKIN_TONE , "🚵🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_MOUNTAIN_BIKING_DARK_SKIN_TONE , "🚵🏿\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_MOUNTAIN_BIKING_DARK_SKIN_TONE , "🚵\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_MOUNTAIN_BIKING , "🚵\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_MOUNTAIN_BIKING , "🚵🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_MOUNTAIN_BIKING_LIGHT_SKIN_TONE , "🚵🏻\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_MOUNTAIN_BIKING_LIGHT_SKIN_TONE , "🚵🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_MOUNTAIN_BIKING_MEDIUM_LIGHT_SKIN_TONE , "🚵🏼\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_MOUNTAIN_BIKING_MEDIUM_LIGHT_SKIN_TONE , "🚵🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_MOUNTAIN_BIKING_MEDIUM_SKIN_TONE , "🚵🏽\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_MOUNTAIN_BIKING_MEDIUM_SKIN_TONE , "🚵🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_MOUNTAIN_BIKING_MEDIUM_DARK_SKIN_TONE , "🚵🏾\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_MOUNTAIN_BIKING_MEDIUM_DARK_SKIN_TONE , "🚵🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_MOUNTAIN_BIKING_DARK_SKIN_TONE , "🚵🏿\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_MOUNTAIN_BIKING_DARK_SKIN_TONE , "🤸" => crate :: people_and_body :: person_sport :: PERSON_CARTWHEELING , "🤸🏻" => crate :: people_and_body :: person_sport :: PERSON_CARTWHEELING_LIGHT_SKIN_TONE , "🤸🏼" => crate :: people_and_body :: person_sport :: PERSON_CARTWHEELING_MEDIUM_LIGHT_SKIN_TONE , "🤸🏽" => crate :: people_and_body :: person_sport :: PERSON_CARTWHEELING_MEDIUM_SKIN_TONE , "🤸🏾" => crate :: people_and_body :: person_sport :: PERSON_CARTWHEELING_MEDIUM_DARK_SKIN_TONE , "🤸🏿" => crate :: people_and_body :: person_sport :: PERSON_CARTWHEELING_DARK_SKIN_TONE , "🤸\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_CARTWHEELING , "🤸\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_CARTWHEELING , "🤸🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_CARTWHEELING_LIGHT_SKIN_TONE , "🤸🏻\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_CARTWHEELING_LIGHT_SKIN_TONE , "🤸🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_CARTWHEELING_MEDIUM_LIGHT_SKIN_TONE , "🤸🏼\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_CARTWHEELING_MEDIUM_LIGHT_SKIN_TONE , "🤸🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_CARTWHEELING_MEDIUM_SKIN_TONE , "🤸🏽\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_CARTWHEELING_MEDIUM_SKIN_TONE , "🤸🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_CARTWHEELING_MEDIUM_DARK_SKIN_TONE , "🤸🏾\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_CARTWHEELING_MEDIUM_DARK_SKIN_TONE , "🤸🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_CARTWHEELING_DARK_SKIN_TONE , "🤸🏿\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_CARTWHEELING_DARK_SKIN_TONE , "🤸\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_CARTWHEELING , "🤸\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_CARTWHEELING , "🤸🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_CARTWHEELING_LIGHT_SKIN_TONE , "🤸🏻\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_CARTWHEELING_LIGHT_SKIN_TONE , "🤸🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_CARTWHEELING_MEDIUM_LIGHT_SKIN_TONE , "🤸🏼\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_CARTWHEELING_MEDIUM_LIGHT_SKIN_TONE , "🤸🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_CARTWHEELING_MEDIUM_SKIN_TONE , "🤸🏽\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_CARTWHEELING_MEDIUM_SKIN_TONE , "🤸🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_CARTWHEELING_MEDIUM_DARK_SKIN_TONE , "🤸🏾\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_CARTWHEELING_MEDIUM_DARK_SKIN_TONE , "🤸🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_CARTWHEELING_DARK_SKIN_TONE , "🤸🏿\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_CARTWHEELING_DARK_SKIN_TONE , "🤼" => crate :: people_and_body :: person_sport :: PEOPLE_WRESTLING , "🤼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MEN_WRESTLING , "🤼\u{200d}♂" => crate :: people_and_body :: person_sport :: MEN_WRESTLING , "🤼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMEN_WRESTLING , "🤼\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMEN_WRESTLING , "🤽" => crate :: people_and_body :: person_sport :: PERSON_PLAYING_WATER_POLO , "🤽🏻" => crate :: people_and_body :: person_sport :: PERSON_PLAYING_WATER_POLO_LIGHT_SKIN_TONE , "🤽🏼" => crate :: people_and_body :: person_sport :: PERSON_PLAYING_WATER_POLO_MEDIUM_LIGHT_SKIN_TONE , "🤽🏽" => crate :: people_and_body :: person_sport :: PERSON_PLAYING_WATER_POLO_MEDIUM_SKIN_TONE , "🤽🏾" => crate :: people_and_body :: person_sport :: PERSON_PLAYING_WATER_POLO_MEDIUM_DARK_SKIN_TONE , "🤽🏿" => crate :: people_and_body :: person_sport :: PERSON_PLAYING_WATER_POLO_DARK_SKIN_TONE , "🤽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_PLAYING_WATER_POLO , "🤽\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_PLAYING_WATER_POLO , "🤽🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_PLAYING_WATER_POLO_LIGHT_SKIN_TONE , "🤽🏻\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_PLAYING_WATER_POLO_LIGHT_SKIN_TONE , "🤽🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_PLAYING_WATER_POLO_MEDIUM_LIGHT_SKIN_TONE , "🤽🏼\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_PLAYING_WATER_POLO_MEDIUM_LIGHT_SKIN_TONE , "🤽🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_PLAYING_WATER_POLO_MEDIUM_SKIN_TONE , "🤽🏽\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_PLAYING_WATER_POLO_MEDIUM_SKIN_TONE , "🤽🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_PLAYING_WATER_POLO_MEDIUM_DARK_SKIN_TONE , "🤽🏾\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_PLAYING_WATER_POLO_MEDIUM_DARK_SKIN_TONE , "🤽🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_PLAYING_WATER_POLO_DARK_SKIN_TONE , "🤽🏿\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_PLAYING_WATER_POLO_DARK_SKIN_TONE , "🤽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_PLAYING_WATER_POLO , "🤽\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_PLAYING_WATER_POLO , "🤽🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_PLAYING_WATER_POLO_LIGHT_SKIN_TONE , "🤽🏻\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_PLAYING_WATER_POLO_LIGHT_SKIN_TONE , "🤽🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_PLAYING_WATER_POLO_MEDIUM_LIGHT_SKIN_TONE , "🤽🏼\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_PLAYING_WATER_POLO_MEDIUM_LIGHT_SKIN_TONE , "🤽🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_PLAYING_WATER_POLO_MEDIUM_SKIN_TONE , "🤽🏽\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_PLAYING_WATER_POLO_MEDIUM_SKIN_TONE , "🤽🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_PLAYING_WATER_POLO_MEDIUM_DARK_SKIN_TONE , "🤽🏾\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_PLAYING_WATER_POLO_MEDIUM_DARK_SKIN_TONE , "🤽🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_PLAYING_WATER_POLO_DARK_SKIN_TONE , "🤽🏿\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_PLAYING_WATER_POLO_DARK_SKIN_TONE , "🤾" => crate :: people_and_body :: person_sport :: PERSON_PLAYING_HANDBALL , "🤾🏻" => crate :: people_and_body :: person_sport :: PERSON_PLAYING_HANDBALL_LIGHT_SKIN_TONE , "🤾🏼" => crate :: people_and_body :: person_sport :: PERSON_PLAYING_HANDBALL_MEDIUM_LIGHT_SKIN_TONE , "🤾🏽" => crate :: people_and_body :: person_sport :: PERSON_PLAYING_HANDBALL_MEDIUM_SKIN_TONE , "🤾🏾" => crate :: people_and_body :: person_sport :: PERSON_PLAYING_HANDBALL_MEDIUM_DARK_SKIN_TONE , "🤾🏿" => crate :: people_and_body :: person_sport :: PERSON_PLAYING_HANDBALL_DARK_SKIN_TONE , "🤾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_PLAYING_HANDBALL , "🤾\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_PLAYING_HANDBALL , "🤾🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_PLAYING_HANDBALL_LIGHT_SKIN_TONE , "🤾🏻\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_PLAYING_HANDBALL_LIGHT_SKIN_TONE , "🤾🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_PLAYING_HANDBALL_MEDIUM_LIGHT_SKIN_TONE , "🤾🏼\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_PLAYING_HANDBALL_MEDIUM_LIGHT_SKIN_TONE , "🤾🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_PLAYING_HANDBALL_MEDIUM_SKIN_TONE , "🤾🏽\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_PLAYING_HANDBALL_MEDIUM_SKIN_TONE , "🤾🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_PLAYING_HANDBALL_MEDIUM_DARK_SKIN_TONE , "🤾🏾\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_PLAYING_HANDBALL_MEDIUM_DARK_SKIN_TONE , "🤾🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_PLAYING_HANDBALL_DARK_SKIN_TONE , "🤾🏿\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_PLAYING_HANDBALL_DARK_SKIN_TONE , "🤾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_PLAYING_HANDBALL , "🤾\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_PLAYING_HANDBALL , "🤾🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_PLAYING_HANDBALL_LIGHT_SKIN_TONE , "🤾🏻\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_PLAYING_HANDBALL_LIGHT_SKIN_TONE , "🤾🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_PLAYING_HANDBALL_MEDIUM_LIGHT_SKIN_TONE , "🤾🏼\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_PLAYING_HANDBALL_MEDIUM_LIGHT_SKIN_TONE , "🤾🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_PLAYING_HANDBALL_MEDIUM_SKIN_TONE , "🤾🏽\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_PLAYING_HANDBALL_MEDIUM_SKIN_TONE , "🤾🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_PLAYING_HANDBALL_MEDIUM_DARK_SKIN_TONE , "🤾🏾\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_PLAYING_HANDBALL_MEDIUM_DARK_SKIN_TONE , "🤾🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_PLAYING_HANDBALL_DARK_SKIN_TONE , "🤾🏿\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_PLAYING_HANDBALL_DARK_SKIN_TONE , "🤹" => crate :: people_and_body :: person_sport :: PERSON_JUGGLING , "🤹🏻" => crate :: people_and_body :: person_sport :: PERSON_JUGGLING_LIGHT_SKIN_TONE , "🤹🏼" => crate :: people_and_body :: person_sport :: PERSON_JUGGLING_MEDIUM_LIGHT_SKIN_TONE , "🤹🏽" => crate :: people_and_body :: person_sport :: PERSON_JUGGLING_MEDIUM_SKIN_TONE , "🤹🏾" => crate :: people_and_body :: person_sport :: PERSON_JUGGLING_MEDIUM_DARK_SKIN_TONE , "🤹🏿" => crate :: people_and_body :: person_sport :: PERSON_JUGGLING_DARK_SKIN_TONE , "🤹\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_JUGGLING , "🤹\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_JUGGLING , "🤹🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_JUGGLING_LIGHT_SKIN_TONE , "🤹🏻\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_JUGGLING_LIGHT_SKIN_TONE , "🤹🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_JUGGLING_MEDIUM_LIGHT_SKIN_TONE , "🤹🏼\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_JUGGLING_MEDIUM_LIGHT_SKIN_TONE , "🤹🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_JUGGLING_MEDIUM_SKIN_TONE , "🤹🏽\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_JUGGLING_MEDIUM_SKIN_TONE , "🤹🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_JUGGLING_MEDIUM_DARK_SKIN_TONE , "🤹🏾\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_JUGGLING_MEDIUM_DARK_SKIN_TONE , "🤹🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_sport :: MAN_JUGGLING_DARK_SKIN_TONE , "🤹🏿\u{200d}♂" => crate :: people_and_body :: person_sport :: MAN_JUGGLING_DARK_SKIN_TONE , "🤹\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_JUGGLING , "🤹\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_JUGGLING , "🤹🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_JUGGLING_LIGHT_SKIN_TONE , "🤹🏻\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_JUGGLING_LIGHT_SKIN_TONE , "🤹🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_JUGGLING_MEDIUM_LIGHT_SKIN_TONE , "🤹🏼\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_JUGGLING_MEDIUM_LIGHT_SKIN_TONE , "🤹🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_JUGGLING_MEDIUM_SKIN_TONE , "🤹🏽\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_JUGGLING_MEDIUM_SKIN_TONE , "🤹🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_JUGGLING_MEDIUM_DARK_SKIN_TONE , "🤹🏾\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_JUGGLING_MEDIUM_DARK_SKIN_TONE , "🤹🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_sport :: WOMAN_JUGGLING_DARK_SKIN_TONE , "🤹🏿\u{200d}♀" => crate :: people_and_body :: person_sport :: WOMAN_JUGGLING_DARK_SKIN_TONE , "🧘" => crate :: people_and_body :: person_resting :: PERSON_IN_LOTUS_POSITION , "🧘🏻" => crate :: people_and_body :: person_resting :: PERSON_IN_LOTUS_POSITION_LIGHT_SKIN_TONE , "🧘🏼" => crate :: people_and_body :: person_resting :: PERSON_IN_LOTUS_POSITION_MEDIUM_LIGHT_SKIN_TONE , "🧘🏽" => crate :: people_and_body :: person_resting :: PERSON_IN_LOTUS_POSITION_MEDIUM_SKIN_TONE , "🧘🏾" => crate :: people_and_body :: person_resting :: PERSON_IN_LOTUS_POSITION_MEDIUM_DARK_SKIN_TONE , "🧘🏿" => crate :: people_and_body :: person_resting :: PERSON_IN_LOTUS_POSITION_DARK_SKIN_TONE , "🧘\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_resting :: MAN_IN_LOTUS_POSITION , "🧘\u{200d}♂" => crate :: people_and_body :: person_resting :: MAN_IN_LOTUS_POSITION , "🧘🏻\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_resting :: MAN_IN_LOTUS_POSITION_LIGHT_SKIN_TONE , "🧘🏻\u{200d}♂" => crate :: people_and_body :: person_resting :: MAN_IN_LOTUS_POSITION_LIGHT_SKIN_TONE , "🧘🏼\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_resting :: MAN_IN_LOTUS_POSITION_MEDIUM_LIGHT_SKIN_TONE , "🧘🏼\u{200d}♂" => crate :: people_and_body :: person_resting :: MAN_IN_LOTUS_POSITION_MEDIUM_LIGHT_SKIN_TONE , "🧘🏽\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_resting :: MAN_IN_LOTUS_POSITION_MEDIUM_SKIN_TONE , "🧘🏽\u{200d}♂" => crate :: people_and_body :: person_resting :: MAN_IN_LOTUS_POSITION_MEDIUM_SKIN_TONE , "🧘🏾\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_resting :: MAN_IN_LOTUS_POSITION_MEDIUM_DARK_SKIN_TONE , "🧘🏾\u{200d}♂" => crate :: people_and_body :: person_resting :: MAN_IN_LOTUS_POSITION_MEDIUM_DARK_SKIN_TONE , "🧘🏿\u{200d}♂\u{fe0f}" => crate :: people_and_body :: person_resting :: MAN_IN_LOTUS_POSITION_DARK_SKIN_TONE , "🧘🏿\u{200d}♂" => crate :: people_and_body :: person_resting :: MAN_IN_LOTUS_POSITION_DARK_SKIN_TONE , "🧘\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_resting :: WOMAN_IN_LOTUS_POSITION , "🧘\u{200d}♀" => crate :: people_and_body :: person_resting :: WOMAN_IN_LOTUS_POSITION , "🧘🏻\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_resting :: WOMAN_IN_LOTUS_POSITION_LIGHT_SKIN_TONE , "🧘🏻\u{200d}♀" => crate :: people_and_body :: person_resting :: WOMAN_IN_LOTUS_POSITION_LIGHT_SKIN_TONE , "🧘🏼\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_resting :: WOMAN_IN_LOTUS_POSITION_MEDIUM_LIGHT_SKIN_TONE , "🧘🏼\u{200d}♀" => crate :: people_and_body :: person_resting :: WOMAN_IN_LOTUS_POSITION_MEDIUM_LIGHT_SKIN_TONE , "🧘🏽\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_resting :: WOMAN_IN_LOTUS_POSITION_MEDIUM_SKIN_TONE , "🧘🏽\u{200d}♀" => crate :: people_and_body :: person_resting :: WOMAN_IN_LOTUS_POSITION_MEDIUM_SKIN_TONE , "🧘🏾\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_resting :: WOMAN_IN_LOTUS_POSITION_MEDIUM_DARK_SKIN_TONE , "🧘🏾\u{200d}♀" => crate :: people_and_body :: person_resting :: WOMAN_IN_LOTUS_POSITION_MEDIUM_DARK_SKIN_TONE , "🧘🏿\u{200d}♀\u{fe0f}" => crate :: people_and_body :: person_resting :: WOMAN_IN_LOTUS_POSITION_DARK_SKIN_TONE , "🧘🏿\u{200d}♀" => crate :: people_and_body :: person_resting :: WOMAN_IN_LOTUS_POSITION_DARK_SKIN_TONE , "🛀" => crate :: people_and_body :: person_resting :: PERSON_TAKING_BATH , "🛀🏻" => crate :: people_and_body :: person_resting :: PERSON_TAKING_BATH_LIGHT_SKIN_TONE , "🛀🏼" => crate :: people_and_body :: person_resting :: PERSON_TAKING_BATH_MEDIUM_LIGHT_SKIN_TONE , "🛀🏽" => crate :: people_and_body :: person_resting :: PERSON_TAKING_BATH_MEDIUM_SKIN_TONE , "🛀🏾" => crate :: people_and_body :: person_resting :: PERSON_TAKING_BATH_MEDIUM_DARK_SKIN_TONE , "🛀🏿" => crate :: people_and_body :: person_resting :: PERSON_TAKING_BATH_DARK_SKIN_TONE , "🛌" => crate :: people_and_body :: person_resting :: PERSON_IN_BED , "🛌🏻" => crate :: people_and_body :: person_resting :: PERSON_IN_BED_LIGHT_SKIN_TONE , "🛌🏼" => crate :: people_and_body :: person_resting :: PERSON_IN_BED_MEDIUM_LIGHT_SKIN_TONE , "🛌🏽" => crate :: people_and_body :: person_resting :: PERSON_IN_BED_MEDIUM_SKIN_TONE , "🛌🏾" => crate :: people_and_body :: person_resting :: PERSON_IN_BED_MEDIUM_DARK_SKIN_TONE , "🛌🏿" => crate :: people_and_body :: person_resting :: PERSON_IN_BED_DARK_SKIN_TONE , "🧑\u{200d}🤝\u{200d}🧑" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS , "🧑🏻\u{200d}🤝\u{200d}🧑🏻" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_LIGHT_SKIN_TONE , "🧑🏻\u{200d}🤝\u{200d}🧑🏼" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_LIGHT_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "🧑🏻\u{200d}🤝\u{200d}🧑🏽" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "🧑🏻\u{200d}🤝\u{200d}🧑🏾" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "🧑🏻\u{200d}🤝\u{200d}🧑🏿" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "🧑🏼\u{200d}🤝\u{200d}🧑🏻" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE_LIGHT_SKIN_TONE , "🧑🏼\u{200d}🤝\u{200d}🧑🏼" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE , "🧑🏼\u{200d}🤝\u{200d}🧑🏽" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "🧑🏼\u{200d}🤝\u{200d}🧑🏾" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "🧑🏼\u{200d}🤝\u{200d}🧑🏿" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "🧑🏽\u{200d}🤝\u{200d}🧑🏻" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_MEDIUM_SKIN_TONE_LIGHT_SKIN_TONE , "🧑🏽\u{200d}🤝\u{200d}🧑🏼" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_MEDIUM_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "🧑🏽\u{200d}🤝\u{200d}🧑🏽" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_MEDIUM_SKIN_TONE , "🧑🏽\u{200d}🤝\u{200d}🧑🏾" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_MEDIUM_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "🧑🏽\u{200d}🤝\u{200d}🧑🏿" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_MEDIUM_SKIN_TONE_DARK_SKIN_TONE , "🧑🏾\u{200d}🤝\u{200d}🧑🏻" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "🧑🏾\u{200d}🤝\u{200d}🧑🏼" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "🧑🏾\u{200d}🤝\u{200d}🧑🏽" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "🧑🏾\u{200d}🤝\u{200d}🧑🏾" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE , "🧑🏾\u{200d}🤝\u{200d}🧑🏿" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE_DARK_SKIN_TONE , "🧑🏿\u{200d}🤝\u{200d}🧑🏻" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "🧑🏿\u{200d}🤝\u{200d}🧑🏼" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "🧑🏿\u{200d}🤝\u{200d}🧑🏽" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "🧑🏿\u{200d}🤝\u{200d}🧑🏾" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_DARK_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "🧑🏿\u{200d}🤝\u{200d}🧑🏿" => crate :: people_and_body :: family :: PEOPLE_HOLDING_HANDS_DARK_SKIN_TONE , "👭" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS , "👭🏻" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_LIGHT_SKIN_TONE , "👩🏻\u{200d}🤝\u{200d}👩🏼" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_LIGHT_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏻\u{200d}🤝\u{200d}👩🏽" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏻\u{200d}🤝\u{200d}👩🏾" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏻\u{200d}🤝\u{200d}👩🏿" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "👩🏼\u{200d}🤝\u{200d}👩🏻" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE_LIGHT_SKIN_TONE , "👭🏼" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE , "👩🏼\u{200d}🤝\u{200d}👩🏽" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏼\u{200d}🤝\u{200d}👩🏾" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏼\u{200d}🤝\u{200d}👩🏿" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "👩🏽\u{200d}🤝\u{200d}👩🏻" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_MEDIUM_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏽\u{200d}🤝\u{200d}👩🏼" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_MEDIUM_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👭🏽" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_MEDIUM_SKIN_TONE , "👩🏽\u{200d}🤝\u{200d}👩🏾" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_MEDIUM_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏽\u{200d}🤝\u{200d}👩🏿" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_MEDIUM_SKIN_TONE_DARK_SKIN_TONE , "👩🏾\u{200d}🤝\u{200d}👩🏻" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏾\u{200d}🤝\u{200d}👩🏼" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏾\u{200d}🤝\u{200d}👩🏽" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "👭🏾" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE , "👩🏾\u{200d}🤝\u{200d}👩🏿" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE_DARK_SKIN_TONE , "👩🏿\u{200d}🤝\u{200d}👩🏻" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏿\u{200d}🤝\u{200d}👩🏼" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏿\u{200d}🤝\u{200d}👩🏽" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏿\u{200d}🤝\u{200d}👩🏾" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_DARK_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👭🏿" => crate :: people_and_body :: family :: WOMEN_HOLDING_HANDS_DARK_SKIN_TONE , "👫" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS , "👫🏻" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_LIGHT_SKIN_TONE , "👩🏻\u{200d}🤝\u{200d}👨🏼" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_LIGHT_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏻\u{200d}🤝\u{200d}👨🏽" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏻\u{200d}🤝\u{200d}👨🏾" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏻\u{200d}🤝\u{200d}👨🏿" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "👩🏼\u{200d}🤝\u{200d}👨🏻" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE_LIGHT_SKIN_TONE , "👫🏼" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE , "👩🏼\u{200d}🤝\u{200d}👨🏽" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏼\u{200d}🤝\u{200d}👨🏾" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏼\u{200d}🤝\u{200d}👨🏿" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "👩🏽\u{200d}🤝\u{200d}👨🏻" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_MEDIUM_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏽\u{200d}🤝\u{200d}👨🏼" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_MEDIUM_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👫🏽" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_MEDIUM_SKIN_TONE , "👩🏽\u{200d}🤝\u{200d}👨🏾" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_MEDIUM_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏽\u{200d}🤝\u{200d}👨🏿" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_MEDIUM_SKIN_TONE_DARK_SKIN_TONE , "👩🏾\u{200d}🤝\u{200d}👨🏻" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏾\u{200d}🤝\u{200d}👨🏼" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏾\u{200d}🤝\u{200d}👨🏽" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "👫🏾" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE , "👩🏾\u{200d}🤝\u{200d}👨🏿" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE_DARK_SKIN_TONE , "👩🏿\u{200d}🤝\u{200d}👨🏻" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏿\u{200d}🤝\u{200d}👨🏼" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏿\u{200d}🤝\u{200d}👨🏽" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏿\u{200d}🤝\u{200d}👨🏾" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_DARK_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👫🏿" => crate :: people_and_body :: family :: WOMAN_AND_MAN_HOLDING_HANDS_DARK_SKIN_TONE , "👬" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS , "👬🏻" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_LIGHT_SKIN_TONE , "👨🏻\u{200d}🤝\u{200d}👨🏼" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_LIGHT_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👨🏻\u{200d}🤝\u{200d}👨🏽" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "👨🏻\u{200d}🤝\u{200d}👨🏾" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👨🏻\u{200d}🤝\u{200d}👨🏿" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "👨🏼\u{200d}🤝\u{200d}👨🏻" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE_LIGHT_SKIN_TONE , "👬🏼" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE , "👨🏼\u{200d}🤝\u{200d}👨🏽" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "👨🏼\u{200d}🤝\u{200d}👨🏾" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👨🏼\u{200d}🤝\u{200d}👨🏿" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_MEDIUM_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "👨🏽\u{200d}🤝\u{200d}👨🏻" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_MEDIUM_SKIN_TONE_LIGHT_SKIN_TONE , "👨🏽\u{200d}🤝\u{200d}👨🏼" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_MEDIUM_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👬🏽" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_MEDIUM_SKIN_TONE , "👨🏽\u{200d}🤝\u{200d}👨🏾" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_MEDIUM_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👨🏽\u{200d}🤝\u{200d}👨🏿" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_MEDIUM_SKIN_TONE_DARK_SKIN_TONE , "👨🏾\u{200d}🤝\u{200d}👨🏻" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "👨🏾\u{200d}🤝\u{200d}👨🏼" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👨🏾\u{200d}🤝\u{200d}👨🏽" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "👬🏾" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE , "👨🏾\u{200d}🤝\u{200d}👨🏿" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_MEDIUM_DARK_SKIN_TONE_DARK_SKIN_TONE , "👨🏿\u{200d}🤝\u{200d}👨🏻" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "👨🏿\u{200d}🤝\u{200d}👨🏼" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👨🏿\u{200d}🤝\u{200d}👨🏽" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "👨🏿\u{200d}🤝\u{200d}👨🏾" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_DARK_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👬🏿" => crate :: people_and_body :: family :: MEN_HOLDING_HANDS_DARK_SKIN_TONE , "💏" => crate :: people_and_body :: family :: KISS , "🧑🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏼" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_LIGHT_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "🧑🏻\u{200d}❤\u{200d}💋\u{200d}🧑🏼" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_LIGHT_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "🧑🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏽" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "🧑🏻\u{200d}❤\u{200d}💋\u{200d}🧑🏽" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "🧑🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏾" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "🧑🏻\u{200d}❤\u{200d}💋\u{200d}🧑🏾" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "🧑🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏿" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "🧑🏻\u{200d}❤\u{200d}💋\u{200d}🧑🏿" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "🧑🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏻" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_MEDIUM_LIGHT_SKIN_TONE_LIGHT_SKIN_TONE , "🧑🏼\u{200d}❤\u{200d}💋\u{200d}🧑🏻" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_MEDIUM_LIGHT_SKIN_TONE_LIGHT_SKIN_TONE , "🧑🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏽" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "🧑🏼\u{200d}❤\u{200d}💋\u{200d}🧑🏽" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "🧑🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏾" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "🧑🏼\u{200d}❤\u{200d}💋\u{200d}🧑🏾" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "🧑🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏿" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_MEDIUM_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "🧑🏼\u{200d}❤\u{200d}💋\u{200d}🧑🏿" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_MEDIUM_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "🧑🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏻" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_MEDIUM_SKIN_TONE_LIGHT_SKIN_TONE , "🧑🏽\u{200d}❤\u{200d}💋\u{200d}🧑🏻" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_MEDIUM_SKIN_TONE_LIGHT_SKIN_TONE , "🧑🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏼" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_MEDIUM_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "🧑🏽\u{200d}❤\u{200d}💋\u{200d}🧑🏼" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_MEDIUM_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "🧑🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏾" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_MEDIUM_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "🧑🏽\u{200d}❤\u{200d}💋\u{200d}🧑🏾" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_MEDIUM_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "🧑🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏿" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_MEDIUM_SKIN_TONE_DARK_SKIN_TONE , "🧑🏽\u{200d}❤\u{200d}💋\u{200d}🧑🏿" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_MEDIUM_SKIN_TONE_DARK_SKIN_TONE , "🧑🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏻" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_MEDIUM_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "🧑🏾\u{200d}❤\u{200d}💋\u{200d}🧑🏻" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_MEDIUM_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "🧑🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏼" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_MEDIUM_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "🧑🏾\u{200d}❤\u{200d}💋\u{200d}🧑🏼" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_MEDIUM_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "🧑🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏽" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_MEDIUM_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "🧑🏾\u{200d}❤\u{200d}💋\u{200d}🧑🏽" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_MEDIUM_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "🧑🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏿" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_MEDIUM_DARK_SKIN_TONE_DARK_SKIN_TONE , "🧑🏾\u{200d}❤\u{200d}💋\u{200d}🧑🏿" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_MEDIUM_DARK_SKIN_TONE_DARK_SKIN_TONE , "🧑🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏻" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "🧑🏿\u{200d}❤\u{200d}💋\u{200d}🧑🏻" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "🧑🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏼" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "🧑🏿\u{200d}❤\u{200d}💋\u{200d}🧑🏼" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "🧑🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏽" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "🧑🏿\u{200d}❤\u{200d}💋\u{200d}🧑🏽" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "🧑🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}🧑🏾" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_DARK_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "🧑🏿\u{200d}❤\u{200d}💋\u{200d}🧑🏾" => crate :: people_and_body :: family :: KISS_PERSON_PERSON_DARK_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨" => crate :: people_and_body :: family :: KISS_WOMAN_MAN , "👩\u{200d}❤\u{200d}💋\u{200d}👨" => crate :: people_and_body :: family :: KISS_WOMAN_MAN , "👩🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏻" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_LIGHT_SKIN_TONE , "👩🏻\u{200d}❤\u{200d}💋\u{200d}👨🏻" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_LIGHT_SKIN_TONE , "👩🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏼" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_LIGHT_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏻\u{200d}❤\u{200d}💋\u{200d}👨🏼" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_LIGHT_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏽" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏻\u{200d}❤\u{200d}💋\u{200d}👨🏽" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏾" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏻\u{200d}❤\u{200d}💋\u{200d}👨🏾" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏿" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "👩🏻\u{200d}❤\u{200d}💋\u{200d}👨🏿" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "👩🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏻" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_LIGHT_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏼\u{200d}❤\u{200d}💋\u{200d}👨🏻" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_LIGHT_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏼" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_LIGHT_SKIN_TONE , "👩🏼\u{200d}❤\u{200d}💋\u{200d}👨🏼" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_LIGHT_SKIN_TONE , "👩🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏽" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏼\u{200d}❤\u{200d}💋\u{200d}👨🏽" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏾" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏼\u{200d}❤\u{200d}💋\u{200d}👨🏾" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏿" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "👩🏼\u{200d}❤\u{200d}💋\u{200d}👨🏿" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "👩🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏻" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏽\u{200d}❤\u{200d}💋\u{200d}👨🏻" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏼" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏽\u{200d}❤\u{200d}💋\u{200d}👨🏼" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏽" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_SKIN_TONE , "👩🏽\u{200d}❤\u{200d}💋\u{200d}👨🏽" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_SKIN_TONE , "👩🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏾" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏽\u{200d}❤\u{200d}💋\u{200d}👨🏾" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏿" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_SKIN_TONE_DARK_SKIN_TONE , "👩🏽\u{200d}❤\u{200d}💋\u{200d}👨🏿" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_SKIN_TONE_DARK_SKIN_TONE , "👩🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏻" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏾\u{200d}❤\u{200d}💋\u{200d}👨🏻" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏼" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏾\u{200d}❤\u{200d}💋\u{200d}👨🏼" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏽" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏾\u{200d}❤\u{200d}💋\u{200d}👨🏽" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏾" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_DARK_SKIN_TONE , "👩🏾\u{200d}❤\u{200d}💋\u{200d}👨🏾" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_DARK_SKIN_TONE , "👩🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏿" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_DARK_SKIN_TONE_DARK_SKIN_TONE , "👩🏾\u{200d}❤\u{200d}💋\u{200d}👨🏿" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_MEDIUM_DARK_SKIN_TONE_DARK_SKIN_TONE , "👩🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏻" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏿\u{200d}❤\u{200d}💋\u{200d}👨🏻" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏼" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏿\u{200d}❤\u{200d}💋\u{200d}👨🏼" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏽" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏿\u{200d}❤\u{200d}💋\u{200d}👨🏽" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏾" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_DARK_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏿\u{200d}❤\u{200d}💋\u{200d}👨🏾" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_DARK_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏿" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_DARK_SKIN_TONE , "👩🏿\u{200d}❤\u{200d}💋\u{200d}👨🏿" => crate :: people_and_body :: family :: KISS_WOMAN_MAN_DARK_SKIN_TONE , "👨\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨" => crate :: people_and_body :: family :: KISS_MAN_MAN , "👨\u{200d}❤\u{200d}💋\u{200d}👨" => crate :: people_and_body :: family :: KISS_MAN_MAN , "👨🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏻" => crate :: people_and_body :: family :: KISS_MAN_MAN_LIGHT_SKIN_TONE , "👨🏻\u{200d}❤\u{200d}💋\u{200d}👨🏻" => crate :: people_and_body :: family :: KISS_MAN_MAN_LIGHT_SKIN_TONE , "👨🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏼" => crate :: people_and_body :: family :: KISS_MAN_MAN_LIGHT_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👨🏻\u{200d}❤\u{200d}💋\u{200d}👨🏼" => crate :: people_and_body :: family :: KISS_MAN_MAN_LIGHT_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👨🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏽" => crate :: people_and_body :: family :: KISS_MAN_MAN_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "👨🏻\u{200d}❤\u{200d}💋\u{200d}👨🏽" => crate :: people_and_body :: family :: KISS_MAN_MAN_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "👨🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏾" => crate :: people_and_body :: family :: KISS_MAN_MAN_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👨🏻\u{200d}❤\u{200d}💋\u{200d}👨🏾" => crate :: people_and_body :: family :: KISS_MAN_MAN_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👨🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏿" => crate :: people_and_body :: family :: KISS_MAN_MAN_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "👨🏻\u{200d}❤\u{200d}💋\u{200d}👨🏿" => crate :: people_and_body :: family :: KISS_MAN_MAN_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "👨🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏻" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_LIGHT_SKIN_TONE_LIGHT_SKIN_TONE , "👨🏼\u{200d}❤\u{200d}💋\u{200d}👨🏻" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_LIGHT_SKIN_TONE_LIGHT_SKIN_TONE , "👨🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏼" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_LIGHT_SKIN_TONE , "👨🏼\u{200d}❤\u{200d}💋\u{200d}👨🏼" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_LIGHT_SKIN_TONE , "👨🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏽" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "👨🏼\u{200d}❤\u{200d}💋\u{200d}👨🏽" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "👨🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏾" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👨🏼\u{200d}❤\u{200d}💋\u{200d}👨🏾" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👨🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏿" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "👨🏼\u{200d}❤\u{200d}💋\u{200d}👨🏿" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "👨🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏻" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_SKIN_TONE_LIGHT_SKIN_TONE , "👨🏽\u{200d}❤\u{200d}💋\u{200d}👨🏻" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_SKIN_TONE_LIGHT_SKIN_TONE , "👨🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏼" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👨🏽\u{200d}❤\u{200d}💋\u{200d}👨🏼" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👨🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏽" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_SKIN_TONE , "👨🏽\u{200d}❤\u{200d}💋\u{200d}👨🏽" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_SKIN_TONE , "👨🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏾" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👨🏽\u{200d}❤\u{200d}💋\u{200d}👨🏾" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👨🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏿" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_SKIN_TONE_DARK_SKIN_TONE , "👨🏽\u{200d}❤\u{200d}💋\u{200d}👨🏿" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_SKIN_TONE_DARK_SKIN_TONE , "👨🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏻" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "👨🏾\u{200d}❤\u{200d}💋\u{200d}👨🏻" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "👨🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏼" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👨🏾\u{200d}❤\u{200d}💋\u{200d}👨🏼" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👨🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏽" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "👨🏾\u{200d}❤\u{200d}💋\u{200d}👨🏽" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "👨🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏾" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_DARK_SKIN_TONE , "👨🏾\u{200d}❤\u{200d}💋\u{200d}👨🏾" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_DARK_SKIN_TONE , "👨🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏿" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_DARK_SKIN_TONE_DARK_SKIN_TONE , "👨🏾\u{200d}❤\u{200d}💋\u{200d}👨🏿" => crate :: people_and_body :: family :: KISS_MAN_MAN_MEDIUM_DARK_SKIN_TONE_DARK_SKIN_TONE , "👨🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏻" => crate :: people_and_body :: family :: KISS_MAN_MAN_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "👨🏿\u{200d}❤\u{200d}💋\u{200d}👨🏻" => crate :: people_and_body :: family :: KISS_MAN_MAN_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "👨🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏼" => crate :: people_and_body :: family :: KISS_MAN_MAN_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👨🏿\u{200d}❤\u{200d}💋\u{200d}👨🏼" => crate :: people_and_body :: family :: KISS_MAN_MAN_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👨🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏽" => crate :: people_and_body :: family :: KISS_MAN_MAN_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "👨🏿\u{200d}❤\u{200d}💋\u{200d}👨🏽" => crate :: people_and_body :: family :: KISS_MAN_MAN_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "👨🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏾" => crate :: people_and_body :: family :: KISS_MAN_MAN_DARK_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👨🏿\u{200d}❤\u{200d}💋\u{200d}👨🏾" => crate :: people_and_body :: family :: KISS_MAN_MAN_DARK_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👨🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👨🏿" => crate :: people_and_body :: family :: KISS_MAN_MAN_DARK_SKIN_TONE , "👨🏿\u{200d}❤\u{200d}💋\u{200d}👨🏿" => crate :: people_and_body :: family :: KISS_MAN_MAN_DARK_SKIN_TONE , "👩\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN , "👩\u{200d}❤\u{200d}💋\u{200d}👩" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN , "👩🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏻" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_LIGHT_SKIN_TONE , "👩🏻\u{200d}❤\u{200d}💋\u{200d}👩🏻" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_LIGHT_SKIN_TONE , "👩🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏼" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_LIGHT_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏻\u{200d}❤\u{200d}💋\u{200d}👩🏼" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_LIGHT_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏽" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏻\u{200d}❤\u{200d}💋\u{200d}👩🏽" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏾" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏻\u{200d}❤\u{200d}💋\u{200d}👩🏾" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏻\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏿" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "👩🏻\u{200d}❤\u{200d}💋\u{200d}👩🏿" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "👩🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏻" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_LIGHT_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏼\u{200d}❤\u{200d}💋\u{200d}👩🏻" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_LIGHT_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏼" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_LIGHT_SKIN_TONE , "👩🏼\u{200d}❤\u{200d}💋\u{200d}👩🏼" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_LIGHT_SKIN_TONE , "👩🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏽" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏼\u{200d}❤\u{200d}💋\u{200d}👩🏽" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏾" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏼\u{200d}❤\u{200d}💋\u{200d}👩🏾" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏼\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏿" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "👩🏼\u{200d}❤\u{200d}💋\u{200d}👩🏿" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "👩🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏻" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏽\u{200d}❤\u{200d}💋\u{200d}👩🏻" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏼" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏽\u{200d}❤\u{200d}💋\u{200d}👩🏼" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏽" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_SKIN_TONE , "👩🏽\u{200d}❤\u{200d}💋\u{200d}👩🏽" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_SKIN_TONE , "👩🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏾" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏽\u{200d}❤\u{200d}💋\u{200d}👩🏾" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏽\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏿" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_SKIN_TONE_DARK_SKIN_TONE , "👩🏽\u{200d}❤\u{200d}💋\u{200d}👩🏿" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_SKIN_TONE_DARK_SKIN_TONE , "👩🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏻" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏾\u{200d}❤\u{200d}💋\u{200d}👩🏻" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏼" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏾\u{200d}❤\u{200d}💋\u{200d}👩🏼" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏽" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏾\u{200d}❤\u{200d}💋\u{200d}👩🏽" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏾" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_DARK_SKIN_TONE , "👩🏾\u{200d}❤\u{200d}💋\u{200d}👩🏾" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_DARK_SKIN_TONE , "👩🏾\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏿" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_DARK_SKIN_TONE_DARK_SKIN_TONE , "👩🏾\u{200d}❤\u{200d}💋\u{200d}👩🏿" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_MEDIUM_DARK_SKIN_TONE_DARK_SKIN_TONE , "👩🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏻" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏿\u{200d}❤\u{200d}💋\u{200d}👩🏻" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏼" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏿\u{200d}❤\u{200d}💋\u{200d}👩🏼" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏽" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏿\u{200d}❤\u{200d}💋\u{200d}👩🏽" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏾" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_DARK_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏿\u{200d}❤\u{200d}💋\u{200d}👩🏾" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_DARK_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏿\u{200d}❤\u{fe0f}\u{200d}💋\u{200d}👩🏿" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_DARK_SKIN_TONE , "👩🏿\u{200d}❤\u{200d}💋\u{200d}👩🏿" => crate :: people_and_body :: family :: KISS_WOMAN_WOMAN_DARK_SKIN_TONE , "💑" => crate :: people_and_body :: family :: COUPLE_WITH_HEART , "🧑🏻\u{200d}❤\u{fe0f}\u{200d}🧑🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_LIGHT_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "🧑🏻\u{200d}❤\u{200d}🧑🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_LIGHT_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "🧑🏻\u{200d}❤\u{fe0f}\u{200d}🧑🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "🧑🏻\u{200d}❤\u{200d}🧑🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "🧑🏻\u{200d}❤\u{fe0f}\u{200d}🧑🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "🧑🏻\u{200d}❤\u{200d}🧑🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "🧑🏻\u{200d}❤\u{fe0f}\u{200d}🧑🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "🧑🏻\u{200d}❤\u{200d}🧑🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "🧑🏼\u{200d}❤\u{fe0f}\u{200d}🧑🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_MEDIUM_LIGHT_SKIN_TONE_LIGHT_SKIN_TONE , "🧑🏼\u{200d}❤\u{200d}🧑🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_MEDIUM_LIGHT_SKIN_TONE_LIGHT_SKIN_TONE , "🧑🏼\u{200d}❤\u{fe0f}\u{200d}🧑🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "🧑🏼\u{200d}❤\u{200d}🧑🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "🧑🏼\u{200d}❤\u{fe0f}\u{200d}🧑🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "🧑🏼\u{200d}❤\u{200d}🧑🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "🧑🏼\u{200d}❤\u{fe0f}\u{200d}🧑🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_MEDIUM_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "🧑🏼\u{200d}❤\u{200d}🧑🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_MEDIUM_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "🧑🏽\u{200d}❤\u{fe0f}\u{200d}🧑🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_MEDIUM_SKIN_TONE_LIGHT_SKIN_TONE , "🧑🏽\u{200d}❤\u{200d}🧑🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_MEDIUM_SKIN_TONE_LIGHT_SKIN_TONE , "🧑🏽\u{200d}❤\u{fe0f}\u{200d}🧑🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_MEDIUM_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "🧑🏽\u{200d}❤\u{200d}🧑🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_MEDIUM_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "🧑🏽\u{200d}❤\u{fe0f}\u{200d}🧑🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_MEDIUM_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "🧑🏽\u{200d}❤\u{200d}🧑🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_MEDIUM_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "🧑🏽\u{200d}❤\u{fe0f}\u{200d}🧑🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_MEDIUM_SKIN_TONE_DARK_SKIN_TONE , "🧑🏽\u{200d}❤\u{200d}🧑🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_MEDIUM_SKIN_TONE_DARK_SKIN_TONE , "🧑🏾\u{200d}❤\u{fe0f}\u{200d}🧑🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_MEDIUM_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "🧑🏾\u{200d}❤\u{200d}🧑🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_MEDIUM_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "🧑🏾\u{200d}❤\u{fe0f}\u{200d}🧑🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_MEDIUM_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "🧑🏾\u{200d}❤\u{200d}🧑🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_MEDIUM_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "🧑🏾\u{200d}❤\u{fe0f}\u{200d}🧑🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_MEDIUM_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "🧑🏾\u{200d}❤\u{200d}🧑🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_MEDIUM_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "🧑🏾\u{200d}❤\u{fe0f}\u{200d}🧑🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_MEDIUM_DARK_SKIN_TONE_DARK_SKIN_TONE , "🧑🏾\u{200d}❤\u{200d}🧑🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_MEDIUM_DARK_SKIN_TONE_DARK_SKIN_TONE , "🧑🏿\u{200d}❤\u{fe0f}\u{200d}🧑🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "🧑🏿\u{200d}❤\u{200d}🧑🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "🧑🏿\u{200d}❤\u{fe0f}\u{200d}🧑🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "🧑🏿\u{200d}❤\u{200d}🧑🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "🧑🏿\u{200d}❤\u{fe0f}\u{200d}🧑🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "🧑🏿\u{200d}❤\u{200d}🧑🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "🧑🏿\u{200d}❤\u{fe0f}\u{200d}🧑🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_DARK_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "🧑🏿\u{200d}❤\u{200d}🧑🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_PERSON_PERSON_DARK_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩\u{200d}❤\u{fe0f}\u{200d}👨" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN , "👩\u{200d}❤\u{200d}👨" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN , "👩🏻\u{200d}❤\u{fe0f}\u{200d}👨🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_LIGHT_SKIN_TONE , "👩🏻\u{200d}❤\u{200d}👨🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_LIGHT_SKIN_TONE , "👩🏻\u{200d}❤\u{fe0f}\u{200d}👨🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_LIGHT_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏻\u{200d}❤\u{200d}👨🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_LIGHT_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏻\u{200d}❤\u{fe0f}\u{200d}👨🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏻\u{200d}❤\u{200d}👨🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏻\u{200d}❤\u{fe0f}\u{200d}👨🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏻\u{200d}❤\u{200d}👨🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏻\u{200d}❤\u{fe0f}\u{200d}👨🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "👩🏻\u{200d}❤\u{200d}👨🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "👩🏼\u{200d}❤\u{fe0f}\u{200d}👨🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_LIGHT_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏼\u{200d}❤\u{200d}👨🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_LIGHT_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏼\u{200d}❤\u{fe0f}\u{200d}👨🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_LIGHT_SKIN_TONE , "👩🏼\u{200d}❤\u{200d}👨🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_LIGHT_SKIN_TONE , "👩🏼\u{200d}❤\u{fe0f}\u{200d}👨🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏼\u{200d}❤\u{200d}👨🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏼\u{200d}❤\u{fe0f}\u{200d}👨🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏼\u{200d}❤\u{200d}👨🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏼\u{200d}❤\u{fe0f}\u{200d}👨🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "👩🏼\u{200d}❤\u{200d}👨🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "👩🏽\u{200d}❤\u{fe0f}\u{200d}👨🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏽\u{200d}❤\u{200d}👨🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏽\u{200d}❤\u{fe0f}\u{200d}👨🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏽\u{200d}❤\u{200d}👨🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏽\u{200d}❤\u{fe0f}\u{200d}👨🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_SKIN_TONE , "👩🏽\u{200d}❤\u{200d}👨🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_SKIN_TONE , "👩🏽\u{200d}❤\u{fe0f}\u{200d}👨🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏽\u{200d}❤\u{200d}👨🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏽\u{200d}❤\u{fe0f}\u{200d}👨🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_SKIN_TONE_DARK_SKIN_TONE , "👩🏽\u{200d}❤\u{200d}👨🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_SKIN_TONE_DARK_SKIN_TONE , "👩🏾\u{200d}❤\u{fe0f}\u{200d}👨🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏾\u{200d}❤\u{200d}👨🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏾\u{200d}❤\u{fe0f}\u{200d}👨🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏾\u{200d}❤\u{200d}👨🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏾\u{200d}❤\u{fe0f}\u{200d}👨🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏾\u{200d}❤\u{200d}👨🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏾\u{200d}❤\u{fe0f}\u{200d}👨🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_DARK_SKIN_TONE , "👩🏾\u{200d}❤\u{200d}👨🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_DARK_SKIN_TONE , "👩🏾\u{200d}❤\u{fe0f}\u{200d}👨🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_DARK_SKIN_TONE_DARK_SKIN_TONE , "👩🏾\u{200d}❤\u{200d}👨🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_MEDIUM_DARK_SKIN_TONE_DARK_SKIN_TONE , "👩🏿\u{200d}❤\u{fe0f}\u{200d}👨🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏿\u{200d}❤\u{200d}👨🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏿\u{200d}❤\u{fe0f}\u{200d}👨🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏿\u{200d}❤\u{200d}👨🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏿\u{200d}❤\u{fe0f}\u{200d}👨🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏿\u{200d}❤\u{200d}👨🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏿\u{200d}❤\u{fe0f}\u{200d}👨🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_DARK_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏿\u{200d}❤\u{200d}👨🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_DARK_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏿\u{200d}❤\u{fe0f}\u{200d}👨🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_DARK_SKIN_TONE , "👩🏿\u{200d}❤\u{200d}👨🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_MAN_DARK_SKIN_TONE , "👨\u{200d}❤\u{fe0f}\u{200d}👨" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN , "👨\u{200d}❤\u{200d}👨" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN , "👨🏻\u{200d}❤\u{fe0f}\u{200d}👨🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_LIGHT_SKIN_TONE , "👨🏻\u{200d}❤\u{200d}👨🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_LIGHT_SKIN_TONE , "👨🏻\u{200d}❤\u{fe0f}\u{200d}👨🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_LIGHT_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👨🏻\u{200d}❤\u{200d}👨🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_LIGHT_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👨🏻\u{200d}❤\u{fe0f}\u{200d}👨🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "👨🏻\u{200d}❤\u{200d}👨🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "👨🏻\u{200d}❤\u{fe0f}\u{200d}👨🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👨🏻\u{200d}❤\u{200d}👨🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👨🏻\u{200d}❤\u{fe0f}\u{200d}👨🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "👨🏻\u{200d}❤\u{200d}👨🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "👨🏼\u{200d}❤\u{fe0f}\u{200d}👨🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_LIGHT_SKIN_TONE_LIGHT_SKIN_TONE , "👨🏼\u{200d}❤\u{200d}👨🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_LIGHT_SKIN_TONE_LIGHT_SKIN_TONE , "👨🏼\u{200d}❤\u{fe0f}\u{200d}👨🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_LIGHT_SKIN_TONE , "👨🏼\u{200d}❤\u{200d}👨🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_LIGHT_SKIN_TONE , "👨🏼\u{200d}❤\u{fe0f}\u{200d}👨🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "👨🏼\u{200d}❤\u{200d}👨🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "👨🏼\u{200d}❤\u{fe0f}\u{200d}👨🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👨🏼\u{200d}❤\u{200d}👨🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👨🏼\u{200d}❤\u{fe0f}\u{200d}👨🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "👨🏼\u{200d}❤\u{200d}👨🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "👨🏽\u{200d}❤\u{fe0f}\u{200d}👨🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_SKIN_TONE_LIGHT_SKIN_TONE , "👨🏽\u{200d}❤\u{200d}👨🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_SKIN_TONE_LIGHT_SKIN_TONE , "👨🏽\u{200d}❤\u{fe0f}\u{200d}👨🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👨🏽\u{200d}❤\u{200d}👨🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👨🏽\u{200d}❤\u{fe0f}\u{200d}👨🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_SKIN_TONE , "👨🏽\u{200d}❤\u{200d}👨🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_SKIN_TONE , "👨🏽\u{200d}❤\u{fe0f}\u{200d}👨🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👨🏽\u{200d}❤\u{200d}👨🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👨🏽\u{200d}❤\u{fe0f}\u{200d}👨🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_SKIN_TONE_DARK_SKIN_TONE , "👨🏽\u{200d}❤\u{200d}👨🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_SKIN_TONE_DARK_SKIN_TONE , "👨🏾\u{200d}❤\u{fe0f}\u{200d}👨🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "👨🏾\u{200d}❤\u{200d}👨🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "👨🏾\u{200d}❤\u{fe0f}\u{200d}👨🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👨🏾\u{200d}❤\u{200d}👨🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👨🏾\u{200d}❤\u{fe0f}\u{200d}👨🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "👨🏾\u{200d}❤\u{200d}👨🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "👨🏾\u{200d}❤\u{fe0f}\u{200d}👨🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_DARK_SKIN_TONE , "👨🏾\u{200d}❤\u{200d}👨🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_DARK_SKIN_TONE , "👨🏾\u{200d}❤\u{fe0f}\u{200d}👨🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_DARK_SKIN_TONE_DARK_SKIN_TONE , "👨🏾\u{200d}❤\u{200d}👨🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_MEDIUM_DARK_SKIN_TONE_DARK_SKIN_TONE , "👨🏿\u{200d}❤\u{fe0f}\u{200d}👨🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "👨🏿\u{200d}❤\u{200d}👨🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "👨🏿\u{200d}❤\u{fe0f}\u{200d}👨🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👨🏿\u{200d}❤\u{200d}👨🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👨🏿\u{200d}❤\u{fe0f}\u{200d}👨🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "👨🏿\u{200d}❤\u{200d}👨🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "👨🏿\u{200d}❤\u{fe0f}\u{200d}👨🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_DARK_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👨🏿\u{200d}❤\u{200d}👨🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_DARK_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👨🏿\u{200d}❤\u{fe0f}\u{200d}👨🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_DARK_SKIN_TONE , "👨🏿\u{200d}❤\u{200d}👨🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_MAN_MAN_DARK_SKIN_TONE , "👩\u{200d}❤\u{fe0f}\u{200d}👩" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN , "👩\u{200d}❤\u{200d}👩" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN , "👩🏻\u{200d}❤\u{fe0f}\u{200d}👩🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_LIGHT_SKIN_TONE , "👩🏻\u{200d}❤\u{200d}👩🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_LIGHT_SKIN_TONE , "👩🏻\u{200d}❤\u{fe0f}\u{200d}👩🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_LIGHT_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏻\u{200d}❤\u{200d}👩🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_LIGHT_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏻\u{200d}❤\u{fe0f}\u{200d}👩🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏻\u{200d}❤\u{200d}👩🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏻\u{200d}❤\u{fe0f}\u{200d}👩🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏻\u{200d}❤\u{200d}👩🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏻\u{200d}❤\u{fe0f}\u{200d}👩🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "👩🏻\u{200d}❤\u{200d}👩🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "👩🏼\u{200d}❤\u{fe0f}\u{200d}👩🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_LIGHT_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏼\u{200d}❤\u{200d}👩🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_LIGHT_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏼\u{200d}❤\u{fe0f}\u{200d}👩🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_LIGHT_SKIN_TONE , "👩🏼\u{200d}❤\u{200d}👩🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_LIGHT_SKIN_TONE , "👩🏼\u{200d}❤\u{fe0f}\u{200d}👩🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏼\u{200d}❤\u{200d}👩🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏼\u{200d}❤\u{fe0f}\u{200d}👩🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏼\u{200d}❤\u{200d}👩🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_LIGHT_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏼\u{200d}❤\u{fe0f}\u{200d}👩🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "👩🏼\u{200d}❤\u{200d}👩🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_LIGHT_SKIN_TONE_DARK_SKIN_TONE , "👩🏽\u{200d}❤\u{fe0f}\u{200d}👩🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏽\u{200d}❤\u{200d}👩🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏽\u{200d}❤\u{fe0f}\u{200d}👩🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏽\u{200d}❤\u{200d}👩🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏽\u{200d}❤\u{fe0f}\u{200d}👩🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_SKIN_TONE , "👩🏽\u{200d}❤\u{200d}👩🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_SKIN_TONE , "👩🏽\u{200d}❤\u{fe0f}\u{200d}👩🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏽\u{200d}❤\u{200d}👩🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏽\u{200d}❤\u{fe0f}\u{200d}👩🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_SKIN_TONE_DARK_SKIN_TONE , "👩🏽\u{200d}❤\u{200d}👩🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_SKIN_TONE_DARK_SKIN_TONE , "👩🏾\u{200d}❤\u{fe0f}\u{200d}👩🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏾\u{200d}❤\u{200d}👩🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏾\u{200d}❤\u{fe0f}\u{200d}👩🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏾\u{200d}❤\u{200d}👩🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏾\u{200d}❤\u{fe0f}\u{200d}👩🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏾\u{200d}❤\u{200d}👩🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏾\u{200d}❤\u{fe0f}\u{200d}👩🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_DARK_SKIN_TONE , "👩🏾\u{200d}❤\u{200d}👩🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_DARK_SKIN_TONE , "👩🏾\u{200d}❤\u{fe0f}\u{200d}👩🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_DARK_SKIN_TONE_DARK_SKIN_TONE , "👩🏾\u{200d}❤\u{200d}👩🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_MEDIUM_DARK_SKIN_TONE_DARK_SKIN_TONE , "👩🏿\u{200d}❤\u{fe0f}\u{200d}👩🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏿\u{200d}❤\u{200d}👩🏻" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_DARK_SKIN_TONE_LIGHT_SKIN_TONE , "👩🏿\u{200d}❤\u{fe0f}\u{200d}👩🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏿\u{200d}❤\u{200d}👩🏼" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_DARK_SKIN_TONE_MEDIUM_LIGHT_SKIN_TONE , "👩🏿\u{200d}❤\u{fe0f}\u{200d}👩🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏿\u{200d}❤\u{200d}👩🏽" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_DARK_SKIN_TONE_MEDIUM_SKIN_TONE , "👩🏿\u{200d}❤\u{fe0f}\u{200d}👩🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_DARK_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏿\u{200d}❤\u{200d}👩🏾" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_DARK_SKIN_TONE_MEDIUM_DARK_SKIN_TONE , "👩🏿\u{200d}❤\u{fe0f}\u{200d}👩🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_DARK_SKIN_TONE , "👩🏿\u{200d}❤\u{200d}👩🏿" => crate :: people_and_body :: family :: COUPLE_WITH_HEART_WOMAN_WOMAN_DARK_SKIN_TONE , "👪" => crate :: people_and_body :: family :: FAMILY , "👨\u{200d}👩\u{200d}👦" => crate :: people_and_body :: family :: FAMILY_MAN_WOMAN_BOY , "👨\u{200d}👩\u{200d}👧" => crate :: people_and_body :: family :: FAMILY_MAN_WOMAN_GIRL , "👨\u{200d}👩\u{200d}👧\u{200d}👦" => crate :: people_and_body :: family :: FAMILY_MAN_WOMAN_GIRL_BOY , "👨\u{200d}👩\u{200d}👦\u{200d}👦" => crate :: people_and_body :: family :: FAMILY_MAN_WOMAN_BOY_BOY , "👨\u{200d}👩\u{200d}👧\u{200d}👧" => crate :: people_and_body :: family :: FAMILY_MAN_WOMAN_GIRL_GIRL , "👨\u{200d}👨\u{200d}👦" => crate :: people_and_body :: family :: FAMILY_MAN_MAN_BOY , "👨\u{200d}👨\u{200d}👧" => crate :: people_and_body :: family :: FAMILY_MAN_MAN_GIRL , "👨\u{200d}👨\u{200d}👧\u{200d}👦" => crate :: people_and_body :: family :: FAMILY_MAN_MAN_GIRL_BOY , "👨\u{200d}👨\u{200d}👦\u{200d}👦" => crate :: people_and_body :: family :: FAMILY_MAN_MAN_BOY_BOY , "👨\u{200d}👨\u{200d}👧\u{200d}👧" => crate :: people_and_body :: family :: FAMILY_MAN_MAN_GIRL_GIRL , "👩\u{200d}👩\u{200d}👦" => crate :: people_and_body :: family :: FAMILY_WOMAN_WOMAN_BOY , "👩\u{200d}👩\u{200d}👧" => crate :: people_and_body :: family :: FAMILY_WOMAN_WOMAN_GIRL , "👩\u{200d}👩\u{200d}👧\u{200d}👦" => crate :: people_and_body :: family :: FAMILY_WOMAN_WOMAN_GIRL_BOY , "👩\u{200d}👩\u{200d}👦\u{200d}👦" => crate :: people_and_body :: family :: FAMILY_WOMAN_WOMAN_BOY_BOY , "👩\u{200d}👩\u{200d}👧\u{200d}👧" => crate :: people_and_body :: family :: FAMILY_WOMAN_WOMAN_GIRL_GIRL , "👨\u{200d}👦" => crate :: people_and_body :: family :: FAMILY_MAN_BOY , "👨\u{200d}👦\u{200d}👦" => crate :: people_and_body :: family :: FAMILY_MAN_BOY_BOY , "👨\u{200d}👧" => crate :: people_and_body :: family :: FAMILY_MAN_GIRL , "👨\u{200d}👧\u{200d}👦" => crate :: people_and_body :: family :: FAMILY_MAN_GIRL_BOY , "👨\u{200d}👧\u{200d}👧" => crate :: people_and_body :: family :: FAMILY_MAN_GIRL_GIRL , "👩\u{200d}👦" => crate :: people_and_body :: family :: FAMILY_WOMAN_BOY , "👩\u{200d}👦\u{200d}👦" => crate :: people_and_body :: family :: FAMILY_WOMAN_BOY_BOY , "👩\u{200d}👧" => crate :: people_and_body :: family :: FAMILY_WOMAN_GIRL , "👩\u{200d}👧\u{200d}👦" => crate :: people_and_body :: family :: FAMILY_WOMAN_GIRL_BOY , "👩\u{200d}👧\u{200d}👧" => crate :: people_and_body :: family :: FAMILY_WOMAN_GIRL_GIRL , "🗣\u{fe0f}" => crate :: people_and_body :: person_symbol :: SPEAKING_HEAD , "🗣" => crate :: people_and_body :: person_symbol :: SPEAKING_HEAD , "👤" => crate :: people_and_body :: person_symbol :: BUST_IN_SILHOUETTE , "👥" => crate :: people_and_body :: person_symbol :: BUSTS_IN_SILHOUETTE , "🫂" => crate :: people_and_body :: person_symbol :: PEOPLE_HUGGING , "👣" => crate :: people_and_body :: person_symbol :: FOOTPRINTS , "🏻" => crate :: component :: skin_tone :: LIGHT_SKIN_TONE , "🏼" => crate :: component :: skin_tone :: MEDIUM_LIGHT_SKIN_TONE , "🏽" => crate :: component :: skin_tone :: MEDIUM_SKIN_TONE , "🏾" => crate :: component :: skin_tone :: MEDIUM_DARK_SKIN_TONE , "🏿" => crate :: component :: skin_tone :: DARK_SKIN_TONE , "🦰" => crate :: component :: hair_style :: RED_HAIR , "🦱" => crate :: component :: hair_style :: CURLY_HAIR , "🦳" => crate :: component :: hair_style :: WHITE_HAIR , "🦲" => crate :: component :: hair_style :: BALD , "🐵" => crate :: animals_and_nature :: animal_mammal :: MONKEY_FACE , "🐒" => crate :: animals_and_nature :: animal_mammal :: MONKEY , "🦍" => crate :: animals_and_nature :: animal_mammal :: GORILLA , "🦧" => crate :: animals_and_nature :: animal_mammal :: ORANGUTAN , "🐶" => crate :: animals_and_nature :: animal_mammal :: DOG_FACE , "🐕" => crate :: animals_and_nature :: animal_mammal :: DOG , "🦮" => crate :: animals_and_nature :: animal_mammal :: GUIDE_DOG , "🐕\u{200d}🦺" => crate :: animals_and_nature :: animal_mammal :: SERVICE_DOG , "🐩" => crate :: animals_and_nature :: animal_mammal :: POODLE , "🐺" => crate :: animals_and_nature :: animal_mammal :: WOLF , "🦊" => crate :: animals_and_nature :: animal_mammal :: FOX , "🦝" => crate :: animals_and_nature :: animal_mammal :: RACCOON , "🐱" => crate :: animals_and_nature :: animal_mammal :: CAT_FACE , "🐈" => crate :: animals_and_nature :: animal_mammal :: CAT , "🐈\u{200d}⬛" => crate :: animals_and_nature :: animal_mammal :: BLACK_CAT , "🦁" => crate :: animals_and_nature :: animal_mammal :: LION , "🐯" => crate :: animals_and_nature :: animal_mammal :: TIGER_FACE , "🐅" => crate :: animals_and_nature :: animal_mammal :: TIGER , "🐆" => crate :: animals_and_nature :: animal_mammal :: LEOPARD , "🐴" => crate :: animals_and_nature :: animal_mammal :: HORSE_FACE , "🐎" => crate :: animals_and_nature :: animal_mammal :: HORSE , "🦄" => crate :: animals_and_nature :: animal_mammal :: UNICORN , "🦓" => crate :: animals_and_nature :: animal_mammal :: ZEBRA , "🦌" => crate :: animals_and_nature :: animal_mammal :: DEER , "🦬" => crate :: animals_and_nature :: animal_mammal :: BISON , "🐮" => crate :: animals_and_nature :: animal_mammal :: COW_FACE , "🐂" => crate :: animals_and_nature :: animal_mammal :: OX , "🐃" => crate :: animals_and_nature :: animal_mammal :: WATER_BUFFALO , "🐄" => crate :: animals_and_nature :: animal_mammal :: COW , "🐷" => crate :: animals_and_nature :: animal_mammal :: PIG_FACE , "🐖" => crate :: animals_and_nature :: animal_mammal :: PIG , "🐗" => crate :: animals_and_nature :: animal_mammal :: BOAR , "🐽" => crate :: animals_and_nature :: animal_mammal :: PIG_NOSE , "🐏" => crate :: animals_and_nature :: animal_mammal :: RAM , "🐑" => crate :: animals_and_nature :: animal_mammal :: EWE , "🐐" => crate :: animals_and_nature :: animal_mammal :: GOAT , "🐪" => crate :: animals_and_nature :: animal_mammal :: CAMEL , "🐫" => crate :: animals_and_nature :: animal_mammal :: TWO_HUMP_CAMEL , "🦙" => crate :: animals_and_nature :: animal_mammal :: LLAMA , "🦒" => crate :: animals_and_nature :: animal_mammal :: GIRAFFE , "🐘" => crate :: animals_and_nature :: animal_mammal :: ELEPHANT , "🦣" => crate :: animals_and_nature :: animal_mammal :: MAMMOTH , "🦏" => crate :: animals_and_nature :: animal_mammal :: RHINOCEROS , "🦛" => crate :: animals_and_nature :: animal_mammal :: HIPPOPOTAMUS , "🐭" => crate :: animals_and_nature :: animal_mammal :: MOUSE_FACE , "🐁" => crate :: animals_and_nature :: animal_mammal :: MOUSE , "🐀" => crate :: animals_and_nature :: animal_mammal :: RAT , "🐹" => crate :: animals_and_nature :: animal_mammal :: HAMSTER , "🐰" => crate :: animals_and_nature :: animal_mammal :: RABBIT_FACE , "🐇" => crate :: animals_and_nature :: animal_mammal :: RABBIT , "🐿\u{fe0f}" => crate :: animals_and_nature :: animal_mammal :: CHIPMUNK , "🐿" => crate :: animals_and_nature :: animal_mammal :: CHIPMUNK , "🦫" => crate :: animals_and_nature :: animal_mammal :: BEAVER , "🦔" => crate :: animals_and_nature :: animal_mammal :: HEDGEHOG , "🦇" => crate :: animals_and_nature :: animal_mammal :: BAT , "🐻" => crate :: animals_and_nature :: animal_mammal :: BEAR , "🐻\u{200d}❄\u{fe0f}" => crate :: animals_and_nature :: animal_mammal :: POLAR_BEAR , "🐻\u{200d}❄" => crate :: animals_and_nature :: animal_mammal :: POLAR_BEAR , "🐨" => crate :: animals_and_nature :: animal_mammal :: KOALA , "🐼" => crate :: animals_and_nature :: animal_mammal :: PANDA , "🦥" => crate :: animals_and_nature :: animal_mammal :: SLOTH , "🦦" => crate :: animals_and_nature :: animal_mammal :: OTTER , "🦨" => crate :: animals_and_nature :: animal_mammal :: SKUNK , "🦘" => crate :: animals_and_nature :: animal_mammal :: KANGAROO , "🦡" => crate :: animals_and_nature :: animal_mammal :: BADGER , "🐾" => crate :: animals_and_nature :: animal_mammal :: PAW_PRINTS , "🦃" => crate :: animals_and_nature :: animal_bird :: TURKEY , "🐔" => crate :: animals_and_nature :: animal_bird :: CHICKEN , "🐓" => crate :: animals_and_nature :: animal_bird :: ROOSTER , "🐣" => crate :: animals_and_nature :: animal_bird :: HATCHING_CHICK , "🐤" => crate :: animals_and_nature :: animal_bird :: BABY_CHICK , "🐥" => crate :: animals_and_nature :: animal_bird :: FRONT_FACING_BABY_CHICK , "🐦" => crate :: animals_and_nature :: animal_bird :: BIRD , "🐧" => crate :: animals_and_nature :: animal_bird :: PENGUIN , "🕊\u{fe0f}" => crate :: animals_and_nature :: animal_bird :: DOVE , "🕊" => crate :: animals_and_nature :: animal_bird :: DOVE , "🦅" => crate :: animals_and_nature :: animal_bird :: EAGLE , "🦆" => crate :: animals_and_nature :: animal_bird :: DUCK , "🦢" => crate :: animals_and_nature :: animal_bird :: SWAN , "🦉" => crate :: animals_and_nature :: animal_bird :: OWL , "🦤" => crate :: animals_and_nature :: animal_bird :: DODO , "🪶" => crate :: animals_and_nature :: animal_bird :: FEATHER , "🦩" => crate :: animals_and_nature :: animal_bird :: FLAMINGO , "🦚" => crate :: animals_and_nature :: animal_bird :: PEACOCK , "🦜" => crate :: animals_and_nature :: animal_bird :: PARROT , "🐸" => crate :: animals_and_nature :: animal_amphibian :: FROG , "🐊" => crate :: animals_and_nature :: animal_reptile :: CROCODILE , "🐢" => crate :: animals_and_nature :: animal_reptile :: TURTLE , "🦎" => crate :: animals_and_nature :: animal_reptile :: LIZARD , "🐍" => crate :: animals_and_nature :: animal_reptile :: SNAKE , "🐲" => crate :: animals_and_nature :: animal_reptile :: DRAGON_FACE , "🐉" => crate :: animals_and_nature :: animal_reptile :: DRAGON , "🦕" => crate :: animals_and_nature :: animal_reptile :: SAUROPOD , "🦖" => crate :: animals_and_nature :: animal_reptile :: T_REX , "🐳" => crate :: animals_and_nature :: animal_marine :: SPOUTING_WHALE , "🐋" => crate :: animals_and_nature :: animal_marine :: WHALE , "🐬" => crate :: animals_and_nature :: animal_marine :: DOLPHIN , "🦭" => crate :: animals_and_nature :: animal_marine :: SEAL , "🐟" => crate :: animals_and_nature :: animal_marine :: FISH , "🐠" => crate :: animals_and_nature :: animal_marine :: TROPICAL_FISH , "🐡" => crate :: animals_and_nature :: animal_marine :: BLOWFISH , "🦈" => crate :: animals_and_nature :: animal_marine :: SHARK , "🐙" => crate :: animals_and_nature :: animal_marine :: OCTOPUS , "🐚" => crate :: animals_and_nature :: animal_marine :: SPIRAL_SHELL , "🐌" => crate :: animals_and_nature :: animal_bug :: SNAIL , "🦋" => crate :: animals_and_nature :: animal_bug :: BUTTERFLY , "🐛" => crate :: animals_and_nature :: animal_bug :: BUG , "🐜" => crate :: animals_and_nature :: animal_bug :: ANT , "🐝" => crate :: animals_and_nature :: animal_bug :: HONEYBEE , "🪲" => crate :: animals_and_nature :: animal_bug :: BEETLE , "🐞" => crate :: animals_and_nature :: animal_bug :: LADY_BEETLE , "🦗" => crate :: animals_and_nature :: animal_bug :: CRICKET , "🪳" => crate :: animals_and_nature :: animal_bug :: COCKROACH , "🕷\u{fe0f}" => crate :: animals_and_nature :: animal_bug :: SPIDER , "🕷" => crate :: animals_and_nature :: animal_bug :: SPIDER , "🕸\u{fe0f}" => crate :: animals_and_nature :: animal_bug :: SPIDER_WEB , "🕸" => crate :: animals_and_nature :: animal_bug :: SPIDER_WEB , "🦂" => crate :: animals_and_nature :: animal_bug :: SCORPION , "🦟" => crate :: animals_and_nature :: animal_bug :: MOSQUITO , "🪰" => crate :: animals_and_nature :: animal_bug :: FLY , "🪱" => crate :: animals_and_nature :: animal_bug :: WORM , "🦠" => crate :: animals_and_nature :: animal_bug :: MICROBE , "💐" => crate :: animals_and_nature :: plant_flower :: BOUQUET , "🌸" => crate :: animals_and_nature :: plant_flower :: CHERRY_BLOSSOM , "💮" => crate :: animals_and_nature :: plant_flower :: WHITE_FLOWER , "🏵\u{fe0f}" => crate :: animals_and_nature :: plant_flower :: ROSETTE , "🏵" => crate :: animals_and_nature :: plant_flower :: ROSETTE , "🌹" => crate :: animals_and_nature :: plant_flower :: ROSE , "🥀" => crate :: animals_and_nature :: plant_flower :: WILTED_FLOWER , "🌺" => crate :: animals_and_nature :: plant_flower :: HIBISCUS , "🌻" => crate :: animals_and_nature :: plant_flower :: SUNFLOWER , "🌼" => crate :: animals_and_nature :: plant_flower :: BLOSSOM , "🌷" => crate :: animals_and_nature :: plant_flower :: TULIP , "🌱" => crate :: animals_and_nature :: plant_other :: SEEDLING , "🪴" => crate :: animals_and_nature :: plant_other :: POTTED_PLANT , "🌲" => crate :: animals_and_nature :: plant_other :: EVERGREEN_TREE , "🌳" => crate :: animals_and_nature :: plant_other :: DECIDUOUS_TREE , "🌴" => crate :: animals_and_nature :: plant_other :: PALM_TREE , "🌵" => crate :: animals_and_nature :: plant_other :: CACTUS , "🌾" => crate :: animals_and_nature :: plant_other :: SHEAF_OF_RICE , "🌿" => crate :: animals_and_nature :: plant_other :: HERB , "☘\u{fe0f}" => crate :: animals_and_nature :: plant_other :: SHAMROCK , "☘" => crate :: animals_and_nature :: plant_other :: SHAMROCK , "🍀" => crate :: animals_and_nature :: plant_other :: FOUR_LEAF_CLOVER , "🍁" => crate :: animals_and_nature :: plant_other :: MAPLE_LEAF , "🍂" => crate :: animals_and_nature :: plant_other :: FALLEN_LEAF , "🍃" => crate :: animals_and_nature :: plant_other :: LEAF_FLUTTERING_IN_WIND , "🍇" => crate :: food_and_drink :: food_fruit :: GRAPES , "🍈" => crate :: food_and_drink :: food_fruit :: MELON , "🍉" => crate :: food_and_drink :: food_fruit :: WATERMELON , "🍊" => crate :: food_and_drink :: food_fruit :: TANGERINE , "🍋" => crate :: food_and_drink :: food_fruit :: LEMON , "🍌" => crate :: food_and_drink :: food_fruit :: BANANA , "🍍" => crate :: food_and_drink :: food_fruit :: PINEAPPLE , "🥭" => crate :: food_and_drink :: food_fruit :: MANGO , "🍎" => crate :: food_and_drink :: food_fruit :: RED_APPLE , "🍏" => crate :: food_and_drink :: food_fruit :: GREEN_APPLE , "🍐" => crate :: food_and_drink :: food_fruit :: PEAR , "🍑" => crate :: food_and_drink :: food_fruit :: PEACH , "🍒" => crate :: food_and_drink :: food_fruit :: CHERRIES , "🍓" => crate :: food_and_drink :: food_fruit :: STRAWBERRY , "🫐" => crate :: food_and_drink :: food_fruit :: BLUEBERRIES , "🥝" => crate :: food_and_drink :: food_fruit :: KIWI_FRUIT , "🍅" => crate :: food_and_drink :: food_fruit :: TOMATO , "🫒" => crate :: food_and_drink :: food_fruit :: OLIVE , "🥥" => crate :: food_and_drink :: food_fruit :: COCONUT , "🥑" => crate :: food_and_drink :: food_vegetable :: AVOCADO , "🍆" => crate :: food_and_drink :: food_vegetable :: EGGPLANT , "🥔" => crate :: food_and_drink :: food_vegetable :: POTATO , "🥕" => crate :: food_and_drink :: food_vegetable :: CARROT , "🌽" => crate :: food_and_drink :: food_vegetable :: EAR_OF_CORN , "🌶\u{fe0f}" => crate :: food_and_drink :: food_vegetable :: HOT_PEPPER , "🌶" => crate :: food_and_drink :: food_vegetable :: HOT_PEPPER , "🫑" => crate :: food_and_drink :: food_vegetable :: BELL_PEPPER , "🥒" => crate :: food_and_drink :: food_vegetable :: CUCUMBER , "🥬" => crate :: food_and_drink :: food_vegetable :: LEAFY_GREEN , "🥦" => crate :: food_and_drink :: food_vegetable :: BROCCOLI , "🧄" => crate :: food_and_drink :: food_vegetable :: GARLIC , "🧅" => crate :: food_and_drink :: food_vegetable :: ONION , "🍄" => crate :: food_and_drink :: food_vegetable :: MUSHROOM , "🥜" => crate :: food_and_drink :: food_vegetable :: PEANUTS , "🌰" => crate :: food_and_drink :: food_vegetable :: CHESTNUT , "🍞" => crate :: food_and_drink :: food_prepared :: BREAD , "🥐" => crate :: food_and_drink :: food_prepared :: CROISSANT , "🥖" => crate :: food_and_drink :: food_prepared :: BAGUETTE_BREAD , "🫓" => crate :: food_and_drink :: food_prepared :: FLATBREAD , "🥨" => crate :: food_and_drink :: food_prepared :: PRETZEL , "🥯" => crate :: food_and_drink :: food_prepared :: BAGEL , "🥞" => crate :: food_and_drink :: food_prepared :: PANCAKES , "🧇" => crate :: food_and_drink :: food_prepared :: WAFFLE , "🧀" => crate :: food_and_drink :: food_prepared :: CHEESE_WEDGE , "🍖" => crate :: food_and_drink :: food_prepared :: MEAT_ON_BONE , "🍗" => crate :: food_and_drink :: food_prepared :: POULTRY_LEG , "🥩" => crate :: food_and_drink :: food_prepared :: CUT_OF_MEAT , "🥓" => crate :: food_and_drink :: food_prepared :: BACON , "🍔" => crate :: food_and_drink :: food_prepared :: HAMBURGER , "🍟" => crate :: food_and_drink :: food_prepared :: FRENCH_FRIES , "🍕" => crate :: food_and_drink :: food_prepared :: PIZZA , "🌭" => crate :: food_and_drink :: food_prepared :: HOT_DOG , "🥪" => crate :: food_and_drink :: food_prepared :: SANDWICH , "🌮" => crate :: food_and_drink :: food_prepared :: TACO , "🌯" => crate :: food_and_drink :: food_prepared :: BURRITO , "🫔" => crate :: food_and_drink :: food_prepared :: TAMALE , "🥙" => crate :: food_and_drink :: food_prepared :: STUFFED_FLATBREAD , "🧆" => crate :: food_and_drink :: food_prepared :: FALAFEL , "🥚" => crate :: food_and_drink :: food_prepared :: EGG , "🍳" => crate :: food_and_drink :: food_prepared :: COOKING , "🥘" => crate :: food_and_drink :: food_prepared :: SHALLOW_PAN_OF_FOOD , "🍲" => crate :: food_and_drink :: food_prepared :: POT_OF_FOOD , "🫕" => crate :: food_and_drink :: food_prepared :: FONDUE , "🥣" => crate :: food_and_drink :: food_prepared :: BOWL_WITH_SPOON , "🥗" => crate :: food_and_drink :: food_prepared :: GREEN_SALAD , "🍿" => crate :: food_and_drink :: food_prepared :: POPCORN , "🧈" => crate :: food_and_drink :: food_prepared :: BUTTER , "🧂" => crate :: food_and_drink :: food_prepared :: SALT , "🥫" => crate :: food_and_drink :: food_prepared :: CANNED_FOOD , "🍱" => crate :: food_and_drink :: food_asian :: BENTO_BOX , "🍘" => crate :: food_and_drink :: food_asian :: RICE_CRACKER , "🍙" => crate :: food_and_drink :: food_asian :: RICE_BALL , "🍚" => crate :: food_and_drink :: food_asian :: COOKED_RICE , "🍛" => crate :: food_and_drink :: food_asian :: CURRY_RICE , "🍜" => crate :: food_and_drink :: food_asian :: STEAMING_BOWL , "🍝" => crate :: food_and_drink :: food_asian :: SPAGHETTI , "🍠" => crate :: food_and_drink :: food_asian :: ROASTED_SWEET_POTATO , "🍢" => crate :: food_and_drink :: food_asian :: ODEN , "🍣" => crate :: food_and_drink :: food_asian :: SUSHI , "🍤" => crate :: food_and_drink :: food_asian :: FRIED_SHRIMP , "🍥" => crate :: food_and_drink :: food_asian :: FISH_CAKE_WITH_SWIRL , "🥮" => crate :: food_and_drink :: food_asian :: MOON_CAKE , "🍡" => crate :: food_and_drink :: food_asian :: DANGO , "🥟" => crate :: food_and_drink :: food_asian :: DUMPLING , "🥠" => crate :: food_and_drink :: food_asian :: FORTUNE_COOKIE , "🥡" => crate :: food_and_drink :: food_asian :: TAKEOUT_BOX , "🦀" => crate :: food_and_drink :: food_marine :: CRAB , "🦞" => crate :: food_and_drink :: food_marine :: LOBSTER , "🦐" => crate :: food_and_drink :: food_marine :: SHRIMP , "🦑" => crate :: food_and_drink :: food_marine :: SQUID , "🦪" => crate :: food_and_drink :: food_marine :: OYSTER , "🍦" => crate :: food_and_drink :: food_sweet :: SOFT_ICE_CREAM , "🍧" => crate :: food_and_drink :: food_sweet :: SHAVED_ICE , "🍨" => crate :: food_and_drink :: food_sweet :: ICE_CREAM , "🍩" => crate :: food_and_drink :: food_sweet :: DOUGHNUT , "🍪" => crate :: food_and_drink :: food_sweet :: COOKIE , "🎂" => crate :: food_and_drink :: food_sweet :: BIRTHDAY_CAKE , "🍰" => crate :: food_and_drink :: food_sweet :: SHORTCAKE , "🧁" => crate :: food_and_drink :: food_sweet :: CUPCAKE , "🥧" => crate :: food_and_drink :: food_sweet :: PIE , "🍫" => crate :: food_and_drink :: food_sweet :: CHOCOLATE_BAR , "🍬" => crate :: food_and_drink :: food_sweet :: CANDY , "🍭" => crate :: food_and_drink :: food_sweet :: LOLLIPOP , "🍮" => crate :: food_and_drink :: food_sweet :: CUSTARD , "🍯" => crate :: food_and_drink :: food_sweet :: HONEY_POT , "🍼" => crate :: food_and_drink :: drink :: BABY_BOTTLE , "🥛" => crate :: food_and_drink :: drink :: GLASS_OF_MILK , "☕" => crate :: food_and_drink :: drink :: HOT_BEVERAGE , "🫖" => crate :: food_and_drink :: drink :: TEAPOT , "🍵" => crate :: food_and_drink :: drink :: TEACUP_WITHOUT_HANDLE , "🍶" => crate :: food_and_drink :: drink :: SAKE , "🍾" => crate :: food_and_drink :: drink :: BOTTLE_WITH_POPPING_CORK , "🍷" => crate :: food_and_drink :: drink :: WINE_GLASS , "🍸" => crate :: food_and_drink :: drink :: COCKTAIL_GLASS , "🍹" => crate :: food_and_drink :: drink :: TROPICAL_DRINK , "🍺" => crate :: food_and_drink :: drink :: BEER_MUG , "🍻" => crate :: food_and_drink :: drink :: CLINKING_BEER_MUGS , "🥂" => crate :: food_and_drink :: drink :: CLINKING_GLASSES , "🥃" => crate :: food_and_drink :: drink :: TUMBLER_GLASS , "🥤" => crate :: food_and_drink :: drink :: CUP_WITH_STRAW , "🧋" => crate :: food_and_drink :: drink :: BUBBLE_TEA , "🧃" => crate :: food_and_drink :: drink :: BEVERAGE_BOX , "🧉" => crate :: food_and_drink :: drink :: MATE , "🧊" => crate :: food_and_drink :: drink :: ICE , "🥢" => crate :: food_and_drink :: dishware :: CHOPSTICKS , "🍽\u{fe0f}" => crate :: food_and_drink :: dishware :: FORK_AND_KNIFE_WITH_PLATE , "🍽" => crate :: food_and_drink :: dishware :: FORK_AND_KNIFE_WITH_PLATE , "🍴" => crate :: food_and_drink :: dishware :: FORK_AND_KNIFE , "🥄" => crate :: food_and_drink :: dishware :: SPOON , "🔪" => crate :: food_and_drink :: dishware :: KITCHEN_KNIFE , "🏺" => crate :: food_and_drink :: dishware :: AMPHORA , "🌍" => crate :: travel_and_places :: place_map :: GLOBE_SHOWING_EUROPE_AFRICA , "🌎" => crate :: travel_and_places :: place_map :: GLOBE_SHOWING_AMERICAS , "🌏" => crate :: travel_and_places :: place_map :: GLOBE_SHOWING_ASIA_AUSTRALIA , "🌐" => crate :: travel_and_places :: place_map :: GLOBE_WITH_MERIDIANS , "🗺\u{fe0f}" => crate :: travel_and_places :: place_map :: WORLD_MAP , "🗺" => crate :: travel_and_places :: place_map :: WORLD_MAP , "🗾" => crate :: travel_and_places :: place_map :: MAP_OF_JAPAN , "🧭" => crate :: travel_and_places :: place_map :: COMPASS , "🏔\u{fe0f}" => crate :: travel_and_places :: place_geographic :: SNOW_CAPPED_MOUNTAIN , "🏔" => crate :: travel_and_places :: place_geographic :: SNOW_CAPPED_MOUNTAIN , "⛰\u{fe0f}" => crate :: travel_and_places :: place_geographic :: MOUNTAIN , "⛰" => crate :: travel_and_places :: place_geographic :: MOUNTAIN , "🌋" => crate :: travel_and_places :: place_geographic :: VOLCANO , "🗻" => crate :: travel_and_places :: place_geographic :: MOUNT_FUJI , "🏕\u{fe0f}" => crate :: travel_and_places :: place_geographic :: CAMPING , "🏕" => crate :: travel_and_places :: place_geographic :: CAMPING , "🏖\u{fe0f}" => crate :: travel_and_places :: place_geographic :: BEACH_WITH_UMBRELLA , "🏖" => crate :: travel_and_places :: place_geographic :: BEACH_WITH_UMBRELLA , "🏜\u{fe0f}" => crate :: travel_and_places :: place_geographic :: DESERT , "🏜" => crate :: travel_and_places :: place_geographic :: DESERT , "🏝\u{fe0f}" => crate :: travel_and_places :: place_geographic :: DESERT_ISLAND , "🏝" => crate :: travel_and_places :: place_geographic :: DESERT_ISLAND , "🏞\u{fe0f}" => crate :: travel_and_places :: place_geographic :: NATIONAL_PARK , "🏞" => crate :: travel_and_places :: place_geographic :: NATIONAL_PARK , "🏟\u{fe0f}" => crate :: travel_and_places :: place_building :: STADIUM , "🏟" => crate :: travel_and_places :: place_building :: STADIUM , "🏛\u{fe0f}" => crate :: travel_and_places :: place_building :: CLASSICAL_BUILDING , "🏛" => crate :: travel_and_places :: place_building :: CLASSICAL_BUILDING , "🏗\u{fe0f}" => crate :: travel_and_places :: place_building :: BUILDING_CONSTRUCTION , "🏗" => crate :: travel_and_places :: place_building :: BUILDING_CONSTRUCTION , "🧱" => crate :: travel_and_places :: place_building :: BRICK , "🪨" => crate :: travel_and_places :: place_building :: ROCK , "🪵" => crate :: travel_and_places :: place_building :: WOOD , "🛖" => crate :: travel_and_places :: place_building :: HUT , "🏘\u{fe0f}" => crate :: travel_and_places :: place_building :: HOUSES , "🏘" => crate :: travel_and_places :: place_building :: HOUSES , "🏚\u{fe0f}" => crate :: travel_and_places :: place_building :: DERELICT_HOUSE , "🏚" => crate :: travel_and_places :: place_building :: DERELICT_HOUSE , "🏠" => crate :: travel_and_places :: place_building :: HOUSE , "🏡" => crate :: travel_and_places :: place_building :: HOUSE_WITH_GARDEN , "🏢" => crate :: travel_and_places :: place_building :: OFFICE_BUILDING , "🏣" => crate :: travel_and_places :: place_building :: JAPANESE_POST_OFFICE , "🏤" => crate :: travel_and_places :: place_building :: POST_OFFICE , "🏥" => crate :: travel_and_places :: place_building :: HOSPITAL , "🏦" => crate :: travel_and_places :: place_building :: BANK , "🏨" => crate :: travel_and_places :: place_building :: HOTEL , "🏩" => crate :: travel_and_places :: place_building :: LOVE_HOTEL , "🏪" => crate :: travel_and_places :: place_building :: CONVENIENCE_STORE , "🏫" => crate :: travel_and_places :: place_building :: SCHOOL , "🏬" => crate :: travel_and_places :: place_building :: DEPARTMENT_STORE , "🏭" => crate :: travel_and_places :: place_building :: FACTORY , "🏯" => crate :: travel_and_places :: place_building :: JAPANESE_CASTLE , "🏰" => crate :: travel_and_places :: place_building :: CASTLE , "💒" => crate :: travel_and_places :: place_building :: WEDDING , "🗼" => crate :: travel_and_places :: place_building :: TOKYO_TOWER , "🗽" => crate :: travel_and_places :: place_building :: STATUE_OF_LIBERTY , "⛪" => crate :: travel_and_places :: place_religious :: CHURCH , "🕌" => crate :: travel_and_places :: place_religious :: MOSQUE , "🛕" => crate :: travel_and_places :: place_religious :: HINDU_TEMPLE , "🕍" => crate :: travel_and_places :: place_religious :: SYNAGOGUE , "⛩\u{fe0f}" => crate :: travel_and_places :: place_religious :: SHINTO_SHRINE , "⛩" => crate :: travel_and_places :: place_religious :: SHINTO_SHRINE , "🕋" => crate :: travel_and_places :: place_religious :: KAABA , "⛲" => crate :: travel_and_places :: place_other :: FOUNTAIN , "⛺" => crate :: travel_and_places :: place_other :: TENT , "🌁" => crate :: travel_and_places :: place_other :: FOGGY , "🌃" => crate :: travel_and_places :: place_other :: NIGHT_WITH_STARS , "🏙\u{fe0f}" => crate :: travel_and_places :: place_other :: CITYSCAPE , "🏙" => crate :: travel_and_places :: place_other :: CITYSCAPE , "🌄" => crate :: travel_and_places :: place_other :: SUNRISE_OVER_MOUNTAINS , "🌅" => crate :: travel_and_places :: place_other :: SUNRISE , "🌆" => crate :: travel_and_places :: place_other :: CITYSCAPE_AT_DUSK , "🌇" => crate :: travel_and_places :: place_other :: SUNSET , "🌉" => crate :: travel_and_places :: place_other :: BRIDGE_AT_NIGHT , "♨\u{fe0f}" => crate :: travel_and_places :: place_other :: HOT_SPRINGS , "♨" => crate :: travel_and_places :: place_other :: HOT_SPRINGS , "🎠" => crate :: travel_and_places :: place_other :: CAROUSEL_HORSE , "🎡" => crate :: travel_and_places :: place_other :: FERRIS_WHEEL , "🎢" => crate :: travel_and_places :: place_other :: ROLLER_COASTER , "💈" => crate :: travel_and_places :: place_other :: BARBER_POLE , "🎪" => crate :: travel_and_places :: place_other :: CIRCUS_TENT , "🚂" => crate :: travel_and_places :: transport_ground :: LOCOMOTIVE , "🚃" => crate :: travel_and_places :: transport_ground :: RAILWAY_CAR , "🚄" => crate :: travel_and_places :: transport_ground :: HIGH_SPEED_TRAIN , "🚅" => crate :: travel_and_places :: transport_ground :: BULLET_TRAIN , "🚆" => crate :: travel_and_places :: transport_ground :: TRAIN , "🚇" => crate :: travel_and_places :: transport_ground :: METRO , "🚈" => crate :: travel_and_places :: transport_ground :: LIGHT_RAIL , "🚉" => crate :: travel_and_places :: transport_ground :: STATION , "🚊" => crate :: travel_and_places :: transport_ground :: TRAM , "🚝" => crate :: travel_and_places :: transport_ground :: MONORAIL , "🚞" => crate :: travel_and_places :: transport_ground :: MOUNTAIN_RAILWAY , "🚋" => crate :: travel_and_places :: transport_ground :: TRAM_CAR , "🚌" => crate :: travel_and_places :: transport_ground :: BUS , "🚍" => crate :: travel_and_places :: transport_ground :: ONCOMING_BUS , "🚎" => crate :: travel_and_places :: transport_ground :: TROLLEYBUS , "🚐" => crate :: travel_and_places :: transport_ground :: MINIBUS , "🚑" => crate :: travel_and_places :: transport_ground :: AMBULANCE , "🚒" => crate :: travel_and_places :: transport_ground :: FIRE_ENGINE , "🚓" => crate :: travel_and_places :: transport_ground :: POLICE_CAR , "🚔" => crate :: travel_and_places :: transport_ground :: ONCOMING_POLICE_CAR , "🚕" => crate :: travel_and_places :: transport_ground :: TAXI , "🚖" => crate :: travel_and_places :: transport_ground :: ONCOMING_TAXI , "🚗" => crate :: travel_and_places :: transport_ground :: AUTOMOBILE , "🚘" => crate :: travel_and_places :: transport_ground :: ONCOMING_AUTOMOBILE , "🚙" => crate :: travel_and_places :: transport_ground :: SPORT_UTILITY_VEHICLE , "🛻" => crate :: travel_and_places :: transport_ground :: PICKUP_TRUCK , "🚚" => crate :: travel_and_places :: transport_ground :: DELIVERY_TRUCK , "🚛" => crate :: travel_and_places :: transport_ground :: ARTICULATED_LORRY , "🚜" => crate :: travel_and_places :: transport_ground :: TRACTOR , "🏎\u{fe0f}" => crate :: travel_and_places :: transport_ground :: RACING_CAR , "🏎" => crate :: travel_and_places :: transport_ground :: RACING_CAR , "🏍\u{fe0f}" => crate :: travel_and_places :: transport_ground :: MOTORCYCLE , "🏍" => crate :: travel_and_places :: transport_ground :: MOTORCYCLE , "🛵" => crate :: travel_and_places :: transport_ground :: MOTOR_SCOOTER , "🦽" => crate :: travel_and_places :: transport_ground :: MANUAL_WHEELCHAIR , "🦼" => crate :: travel_and_places :: transport_ground :: MOTORIZED_WHEELCHAIR , "🛺" => crate :: travel_and_places :: transport_ground :: AUTO_RICKSHAW , "🚲" => crate :: travel_and_places :: transport_ground :: BICYCLE , "🛴" => crate :: travel_and_places :: transport_ground :: KICK_SCOOTER , "🛹" => crate :: travel_and_places :: transport_ground :: SKATEBOARD , "🛼" => crate :: travel_and_places :: transport_ground :: ROLLER_SKATE , "🚏" => crate :: travel_and_places :: transport_ground :: BUS_STOP , "🛣\u{fe0f}" => crate :: travel_and_places :: transport_ground :: MOTORWAY , "🛣" => crate :: travel_and_places :: transport_ground :: MOTORWAY , "🛤\u{fe0f}" => crate :: travel_and_places :: transport_ground :: RAILWAY_TRACK , "🛤" => crate :: travel_and_places :: transport_ground :: RAILWAY_TRACK , "🛢\u{fe0f}" => crate :: travel_and_places :: transport_ground :: OIL_DRUM , "🛢" => crate :: travel_and_places :: transport_ground :: OIL_DRUM , "⛽" => crate :: travel_and_places :: transport_ground :: FUEL_PUMP , "🚨" => crate :: travel_and_places :: transport_ground :: POLICE_CAR_LIGHT , "🚥" => crate :: travel_and_places :: transport_ground :: HORIZONTAL_TRAFFIC_LIGHT , "🚦" => crate :: travel_and_places :: transport_ground :: VERTICAL_TRAFFIC_LIGHT , "🛑" => crate :: travel_and_places :: transport_ground :: STOP_SIGN , "🚧" => crate :: travel_and_places :: transport_ground :: CONSTRUCTION , "⚓" => crate :: travel_and_places :: transport_water :: ANCHOR , "⛵" => crate :: travel_and_places :: transport_water :: SAILBOAT , "🛶" => crate :: travel_and_places :: transport_water :: CANOE , "🚤" => crate :: travel_and_places :: transport_water :: SPEEDBOAT , "🛳\u{fe0f}" => crate :: travel_and_places :: transport_water :: PASSENGER_SHIP , "🛳" => crate :: travel_and_places :: transport_water :: PASSENGER_SHIP , "⛴\u{fe0f}" => crate :: travel_and_places :: transport_water :: FERRY , "⛴" => crate :: travel_and_places :: transport_water :: FERRY , "🛥\u{fe0f}" => crate :: travel_and_places :: transport_water :: MOTOR_BOAT , "🛥" => crate :: travel_and_places :: transport_water :: MOTOR_BOAT , "🚢" => crate :: travel_and_places :: transport_water :: SHIP , "✈\u{fe0f}" => crate :: travel_and_places :: transport_air :: AIRPLANE , "✈" => crate :: travel_and_places :: transport_air :: AIRPLANE , "🛩\u{fe0f}" => crate :: travel_and_places :: transport_air :: SMALL_AIRPLANE , "🛩" => crate :: travel_and_places :: transport_air :: SMALL_AIRPLANE , "🛫" => crate :: travel_and_places :: transport_air :: AIRPLANE_DEPARTURE , "🛬" => crate :: travel_and_places :: transport_air :: AIRPLANE_ARRIVAL , "🪂" => crate :: travel_and_places :: transport_air :: PARACHUTE , "💺" => crate :: travel_and_places :: transport_air :: SEAT , "🚁" => crate :: travel_and_places :: transport_air :: HELICOPTER , "🚟" => crate :: travel_and_places :: transport_air :: SUSPENSION_RAILWAY , "🚠" => crate :: travel_and_places :: transport_air :: MOUNTAIN_CABLEWAY , "🚡" => crate :: travel_and_places :: transport_air :: AERIAL_TRAMWAY , "🛰\u{fe0f}" => crate :: travel_and_places :: transport_air :: SATELLITE , "🛰" => crate :: travel_and_places :: transport_air :: SATELLITE , "🚀" => crate :: travel_and_places :: transport_air :: ROCKET , "🛸" => crate :: travel_and_places :: transport_air :: FLYING_SAUCER , "🛎\u{fe0f}" => crate :: travel_and_places :: hotel :: BELLHOP_BELL , "🛎" => crate :: travel_and_places :: hotel :: BELLHOP_BELL , "🧳" => crate :: travel_and_places :: hotel :: LUGGAGE , "⌛" => crate :: travel_and_places :: time :: HOURGLASS_DONE , "⏳" => crate :: travel_and_places :: time :: HOURGLASS_NOT_DONE , "⌚" => crate :: travel_and_places :: time :: WATCH , "⏰" => crate :: travel_and_places :: time :: ALARM_CLOCK , "⏱\u{fe0f}" => crate :: travel_and_places :: time :: STOPWATCH , "⏱" => crate :: travel_and_places :: time :: STOPWATCH , "⏲\u{fe0f}" => crate :: travel_and_places :: time :: TIMER_CLOCK , "⏲" => crate :: travel_and_places :: time :: TIMER_CLOCK , "🕰\u{fe0f}" => crate :: travel_and_places :: time :: MANTELPIECE_CLOCK , "🕰" => crate :: travel_and_places :: time :: MANTELPIECE_CLOCK , "🕛" => crate :: travel_and_places :: time :: TWELVE_OCLOCK , "🕧" => crate :: travel_and_places :: time :: TWELVE_THIRTY , "🕐" => crate :: travel_and_places :: time :: ONE_OCLOCK , "🕜" => crate :: travel_and_places :: time :: ONE_THIRTY , "🕑" => crate :: travel_and_places :: time :: TWO_OCLOCK , "🕝" => crate :: travel_and_places :: time :: TWO_THIRTY , "🕒" => crate :: travel_and_places :: time :: THREE_OCLOCK , "🕞" => crate :: travel_and_places :: time :: THREE_THIRTY , "🕓" => crate :: travel_and_places :: time :: FOUR_OCLOCK , "🕟" => crate :: travel_and_places :: time :: FOUR_THIRTY , "🕔" => crate :: travel_and_places :: time :: FIVE_OCLOCK , "🕠" => crate :: travel_and_places :: time :: FIVE_THIRTY , "🕕" => crate :: travel_and_places :: time :: SIX_OCLOCK , "🕡" => crate :: travel_and_places :: time :: SIX_THIRTY , "🕖" => crate :: travel_and_places :: time :: SEVEN_OCLOCK , "🕢" => crate :: travel_and_places :: time :: SEVEN_THIRTY , "🕗" => crate :: travel_and_places :: time :: EIGHT_OCLOCK , "🕣" => crate :: travel_and_places :: time :: EIGHT_THIRTY , "🕘" => crate :: travel_and_places :: time :: NINE_OCLOCK , "🕤" => crate :: travel_and_places :: time :: NINE_THIRTY , "🕙" => crate :: travel_and_places :: time :: TEN_OCLOCK , "🕥" => crate :: travel_and_places :: time :: TEN_THIRTY , "🕚" => crate :: travel_and_places :: time :: ELEVEN_OCLOCK , "🕦" => crate :: travel_and_places :: time :: ELEVEN_THIRTY , "🌑" => crate :: travel_and_places :: sky_and_weather :: NEW_MOON , "🌒" => crate :: travel_and_places :: sky_and_weather :: WAXING_CRESCENT_MOON , "🌓" => crate :: travel_and_places :: sky_and_weather :: FIRST_QUARTER_MOON , "🌔" => crate :: travel_and_places :: sky_and_weather :: WAXING_GIBBOUS_MOON , "🌕" => crate :: travel_and_places :: sky_and_weather :: FULL_MOON , "🌖" => crate :: travel_and_places :: sky_and_weather :: WANING_GIBBOUS_MOON , "🌗" => crate :: travel_and_places :: sky_and_weather :: LAST_QUARTER_MOON , "🌘" => crate :: travel_and_places :: sky_and_weather :: WANING_CRESCENT_MOON , "🌙" => crate :: travel_and_places :: sky_and_weather :: CRESCENT_MOON , "🌚" => crate :: travel_and_places :: sky_and_weather :: NEW_MOON_FACE , "🌛" => crate :: travel_and_places :: sky_and_weather :: FIRST_QUARTER_MOON_FACE , "🌜" => crate :: travel_and_places :: sky_and_weather :: LAST_QUARTER_MOON_FACE , "🌡\u{fe0f}" => crate :: travel_and_places :: sky_and_weather :: THERMOMETER , "🌡" => crate :: travel_and_places :: sky_and_weather :: THERMOMETER , "☀\u{fe0f}" => crate :: travel_and_places :: sky_and_weather :: SUN , "☀" => crate :: travel_and_places :: sky_and_weather :: SUN , "🌝" => crate :: travel_and_places :: sky_and_weather :: FULL_MOON_FACE , "🌞" => crate :: travel_and_places :: sky_and_weather :: SUN_WITH_FACE , "🪐" => crate :: travel_and_places :: sky_and_weather :: RINGED_PLANET , "⭐" => crate :: travel_and_places :: sky_and_weather :: STAR , "🌟" => crate :: travel_and_places :: sky_and_weather :: GLOWING_STAR , "🌠" => crate :: travel_and_places :: sky_and_weather :: SHOOTING_STAR , "🌌" => crate :: travel_and_places :: sky_and_weather :: MILKY_WAY , "☁\u{fe0f}" => crate :: travel_and_places :: sky_and_weather :: CLOUD , "☁" => crate :: travel_and_places :: sky_and_weather :: CLOUD , "⛅" => crate :: travel_and_places :: sky_and_weather :: SUN_BEHIND_CLOUD , "⛈\u{fe0f}" => crate :: travel_and_places :: sky_and_weather :: CLOUD_WITH_LIGHTNING_AND_RAIN , "⛈" => crate :: travel_and_places :: sky_and_weather :: CLOUD_WITH_LIGHTNING_AND_RAIN , "🌤\u{fe0f}" => crate :: travel_and_places :: sky_and_weather :: SUN_BEHIND_SMALL_CLOUD , "🌤" => crate :: travel_and_places :: sky_and_weather :: SUN_BEHIND_SMALL_CLOUD , "🌥\u{fe0f}" => crate :: travel_and_places :: sky_and_weather :: SUN_BEHIND_LARGE_CLOUD , "🌥" => crate :: travel_and_places :: sky_and_weather :: SUN_BEHIND_LARGE_CLOUD , "🌦\u{fe0f}" => crate :: travel_and_places :: sky_and_weather :: SUN_BEHIND_RAIN_CLOUD , "🌦" => crate :: travel_and_places :: sky_and_weather :: SUN_BEHIND_RAIN_CLOUD , "🌧\u{fe0f}" => crate :: travel_and_places :: sky_and_weather :: CLOUD_WITH_RAIN , "🌧" => crate :: travel_and_places :: sky_and_weather :: CLOUD_WITH_RAIN , "🌨\u{fe0f}" => crate :: travel_and_places :: sky_and_weather :: CLOUD_WITH_SNOW , "🌨" => crate :: travel_and_places :: sky_and_weather :: CLOUD_WITH_SNOW , "🌩\u{fe0f}" => crate :: travel_and_places :: sky_and_weather :: CLOUD_WITH_LIGHTNING , "🌩" => crate :: travel_and_places :: sky_and_weather :: CLOUD_WITH_LIGHTNING , "🌪\u{fe0f}" => crate :: travel_and_places :: sky_and_weather :: TORNADO , "🌪" => crate :: travel_and_places :: sky_and_weather :: TORNADO , "🌫\u{fe0f}" => crate :: travel_and_places :: sky_and_weather :: FOG , "🌫" => crate :: travel_and_places :: sky_and_weather :: FOG , "🌬\u{fe0f}" => crate :: travel_and_places :: sky_and_weather :: WIND_FACE , "🌬" => crate :: travel_and_places :: sky_and_weather :: WIND_FACE , "🌀" => crate :: travel_and_places :: sky_and_weather :: CYCLONE , "🌈" => crate :: travel_and_places :: sky_and_weather :: RAINBOW , "🌂" => crate :: travel_and_places :: sky_and_weather :: CLOSED_UMBRELLA , "☂\u{fe0f}" => crate :: travel_and_places :: sky_and_weather :: UMBRELLA , "☂" => crate :: travel_and_places :: sky_and_weather :: UMBRELLA , "☔" => crate :: travel_and_places :: sky_and_weather :: UMBRELLA_WITH_RAIN_DROPS , "⛱\u{fe0f}" => crate :: travel_and_places :: sky_and_weather :: UMBRELLA_ON_GROUND , "⛱" => crate :: travel_and_places :: sky_and_weather :: UMBRELLA_ON_GROUND , "⚡" => crate :: travel_and_places :: sky_and_weather :: HIGH_VOLTAGE , "❄\u{fe0f}" => crate :: travel_and_places :: sky_and_weather :: SNOWFLAKE , "❄" => crate :: travel_and_places :: sky_and_weather :: SNOWFLAKE , "☃\u{fe0f}" => crate :: travel_and_places :: sky_and_weather :: SNOWMAN , "☃" => crate :: travel_and_places :: sky_and_weather :: SNOWMAN , "⛄" => crate :: travel_and_places :: sky_and_weather :: SNOWMAN_WITHOUT_SNOW , "☄\u{fe0f}" => crate :: travel_and_places :: sky_and_weather :: COMET , "☄" => crate :: travel_and_places :: sky_and_weather :: COMET , "🔥" => crate :: travel_and_places :: sky_and_weather :: FIRE , "💧" => crate :: travel_and_places :: sky_and_weather :: DROPLET , "🌊" => crate :: travel_and_places :: sky_and_weather :: WATER_WAVE , "🎃" => crate :: activities :: event :: JACK_O_LANTERN , "🎄" => crate :: activities :: event :: CHRISTMAS_TREE , "🎆" => crate :: activities :: event :: FIREWORKS , "🎇" => crate :: activities :: event :: SPARKLER , "🧨" => crate :: activities :: event :: FIRECRACKER , "✨" => crate :: activities :: event :: SPARKLES , "🎈" => crate :: activities :: event :: BALLOON , "🎉" => crate :: activities :: event :: PARTY_POPPER , "🎊" => crate :: activities :: event :: CONFETTI_BALL , "🎋" => crate :: activities :: event :: TANABATA_TREE , "🎍" => crate :: activities :: event :: PINE_DECORATION , "🎎" => crate :: activities :: event :: JAPANESE_DOLLS , "🎏" => crate :: activities :: event :: CARP_STREAMER , "🎐" => crate :: activities :: event :: WIND_CHIME , "🎑" => crate :: activities :: event :: MOON_VIEWING_CEREMONY , "🧧" => crate :: activities :: event :: RED_ENVELOPE , "🎀" => crate :: activities :: event :: RIBBON , "🎁" => crate :: activities :: event :: WRAPPED_GIFT , "🎗\u{fe0f}" => crate :: activities :: event :: REMINDER_RIBBON , "🎗" => crate :: activities :: event :: REMINDER_RIBBON , "🎟\u{fe0f}" => crate :: activities :: event :: ADMISSION_TICKETS , "🎟" => crate :: activities :: event :: ADMISSION_TICKETS , "🎫" => crate :: activities :: event :: TICKET , "🎖\u{fe0f}" => crate :: activities :: award_medal :: MILITARY_MEDAL , "🎖" => crate :: activities :: award_medal :: MILITARY_MEDAL , "🏆" => crate :: activities :: award_medal :: TROPHY , "🏅" => crate :: activities :: award_medal :: SPORTS_MEDAL , "🥇" => crate :: activities :: award_medal :: FIRST_PLACE_MEDAL , "🥈" => crate :: activities :: award_medal :: SECOND_PLACE_MEDAL , "🥉" => crate :: activities :: award_medal :: THIRD_PLACE_MEDAL , "⚽" => crate :: activities :: sport :: SOCCER_BALL , "⚾" => crate :: activities :: sport :: BASEBALL , "🥎" => crate :: activities :: sport :: SOFTBALL , "🏀" => crate :: activities :: sport :: BASKETBALL , "🏐" => crate :: activities :: sport :: VOLLEYBALL , "🏈" => crate :: activities :: sport :: AMERICAN_FOOTBALL , "🏉" => crate :: activities :: sport :: RUGBY_FOOTBALL , "🎾" => crate :: activities :: sport :: TENNIS , "🥏" => crate :: activities :: sport :: FLYING_DISC , "🎳" => crate :: activities :: sport :: BOWLING , "🏏" => crate :: activities :: sport :: CRICKET_GAME , "🏑" => crate :: activities :: sport :: FIELD_HOCKEY , "🏒" => crate :: activities :: sport :: ICE_HOCKEY , "🥍" => crate :: activities :: sport :: LACROSSE , "🏓" => crate :: activities :: sport :: PING_PONG , "🏸" => crate :: activities :: sport :: BADMINTON , "🥊" => crate :: activities :: sport :: BOXING_GLOVE , "🥋" => crate :: activities :: sport :: MARTIAL_ARTS_UNIFORM , "🥅" => crate :: activities :: sport :: GOAL_NET , "⛳" => crate :: activities :: sport :: FLAG_IN_HOLE , "⛸\u{fe0f}" => crate :: activities :: sport :: ICE_SKATE , "⛸" => crate :: activities :: sport :: ICE_SKATE , "🎣" => crate :: activities :: sport :: FISHING_POLE , "🤿" => crate :: activities :: sport :: DIVING_MASK , "🎽" => crate :: activities :: sport :: RUNNING_SHIRT , "🎿" => crate :: activities :: sport :: SKIS , "🛷" => crate :: activities :: sport :: SLED , "🥌" => crate :: activities :: sport :: CURLING_STONE , "🎯" => crate :: activities :: game :: BULLSEYE , "🪀" => crate :: activities :: game :: YO_YO , "🪁" => crate :: activities :: game :: KITE , "🎱" => crate :: activities :: game :: POOL_8_BALL , "🔮" => crate :: activities :: game :: CRYSTAL_BALL , "🪄" => crate :: activities :: game :: MAGIC_WAND , "🧿" => crate :: activities :: game :: NAZAR_AMULET , "🎮" => crate :: activities :: game :: VIDEO_GAME , "🕹\u{fe0f}" => crate :: activities :: game :: JOYSTICK , "🕹" => crate :: activities :: game :: JOYSTICK , "🎰" => crate :: activities :: game :: SLOT_MACHINE , "🎲" => crate :: activities :: game :: GAME_DIE , "🧩" => crate :: activities :: game :: PUZZLE_PIECE , "🧸" => crate :: activities :: game :: TEDDY_BEAR , "🪅" => crate :: activities :: game :: PINATA , "🪆" => crate :: activities :: game :: NESTING_DOLLS , "♠\u{fe0f}" => crate :: activities :: game :: SPADE_SUIT , "♠" => crate :: activities :: game :: SPADE_SUIT , "♥\u{fe0f}" => crate :: activities :: game :: HEART_SUIT , "♥" => crate :: activities :: game :: HEART_SUIT , "♦\u{fe0f}" => crate :: activities :: game :: DIAMOND_SUIT , "♦" => crate :: activities :: game :: DIAMOND_SUIT , "♣\u{fe0f}" => crate :: activities :: game :: CLUB_SUIT , "♣" => crate :: activities :: game :: CLUB_SUIT , "♟\u{fe0f}" => crate :: activities :: game :: CHESS_PAWN , "♟" => crate :: activities :: game :: CHESS_PAWN , "🃏" => crate :: activities :: game :: JOKER , "🀄" => crate :: activities :: game :: MAHJONG_RED_DRAGON , "🎴" => crate :: activities :: game :: FLOWER_PLAYING_CARDS , "🎭" => crate :: activities :: arts_and_crafts :: PERFORMING_ARTS , "🖼\u{fe0f}" => crate :: activities :: arts_and_crafts :: FRAMED_PICTURE , "🖼" => crate :: activities :: arts_and_crafts :: FRAMED_PICTURE , "🎨" => crate :: activities :: arts_and_crafts :: ARTIST_PALETTE , "🧵" => crate :: activities :: arts_and_crafts :: THREAD , "🪡" => crate :: activities :: arts_and_crafts :: SEWING_NEEDLE , "🧶" => crate :: activities :: arts_and_crafts :: YARN , "🪢" => crate :: activities :: arts_and_crafts :: KNOT , "👓" => crate :: objects :: clothing :: GLASSES , "🕶\u{fe0f}" => crate :: objects :: clothing :: SUNGLASSES , "🕶" => crate :: objects :: clothing :: SUNGLASSES , "🥽" => crate :: objects :: clothing :: GOGGLES , "🥼" => crate :: objects :: clothing :: LAB_COAT , "🦺" => crate :: objects :: clothing :: SAFETY_VEST , "👔" => crate :: objects :: clothing :: NECKTIE , "👕" => crate :: objects :: clothing :: T_SHIRT , "👖" => crate :: objects :: clothing :: JEANS , "🧣" => crate :: objects :: clothing :: SCARF , "🧤" => crate :: objects :: clothing :: GLOVES , "🧥" => crate :: objects :: clothing :: COAT , "🧦" => crate :: objects :: clothing :: SOCKS , "👗" => crate :: objects :: clothing :: DRESS , "👘" => crate :: objects :: clothing :: KIMONO , "🥻" => crate :: objects :: clothing :: SARI , "🩱" => crate :: objects :: clothing :: ONE_PIECE_SWIMSUIT , "🩲" => crate :: objects :: clothing :: BRIEFS , "🩳" => crate :: objects :: clothing :: SHORTS , "👙" => crate :: objects :: clothing :: BIKINI , "👚" => crate :: objects :: clothing :: WOMANS_CLOTHES , "👛" => crate :: objects :: clothing :: PURSE , "👜" => crate :: objects :: clothing :: HANDBAG , "👝" => crate :: objects :: clothing :: CLUTCH_BAG , "🛍\u{fe0f}" => crate :: objects :: clothing :: SHOPPING_BAGS , "🛍" => crate :: objects :: clothing :: SHOPPING_BAGS , "🎒" => crate :: objects :: clothing :: BACKPACK , "🩴" => crate :: objects :: clothing :: THONG_SANDAL , "👞" => crate :: objects :: clothing :: MANS_SHOE , "👟" => crate :: objects :: clothing :: RUNNING_SHOE , "🥾" => crate :: objects :: clothing :: HIKING_BOOT , "🥿" => crate :: objects :: clothing :: FLAT_SHOE , "👠" => crate :: objects :: clothing :: HIGH_HEELED_SHOE , "👡" => crate :: objects :: clothing :: WOMANS_SANDAL , "🩰" => crate :: objects :: clothing :: BALLET_SHOES , "👢" => crate :: objects :: clothing :: WOMANS_BOOT , "👑" => crate :: objects :: clothing :: CROWN , "👒" => crate :: objects :: clothing :: WOMANS_HAT , "🎩" => crate :: objects :: clothing :: TOP_HAT , "🎓" => crate :: objects :: clothing :: GRADUATION_CAP , "🧢" => crate :: objects :: clothing :: BILLED_CAP , "🪖" => crate :: objects :: clothing :: MILITARY_HELMET , "⛑\u{fe0f}" => crate :: objects :: clothing :: RESCUE_WORKERS_HELMET , "⛑" => crate :: objects :: clothing :: RESCUE_WORKERS_HELMET , "📿" => crate :: objects :: clothing :: PRAYER_BEADS , "💄" => crate :: objects :: clothing :: LIPSTICK , "💍" => crate :: objects :: clothing :: RING , "💎" => crate :: objects :: clothing :: GEM_STONE , "🔇" => crate :: objects :: sound :: MUTED_SPEAKER , "🔈" => crate :: objects :: sound :: SPEAKER_LOW_VOLUME , "🔉" => crate :: objects :: sound :: SPEAKER_MEDIUM_VOLUME , "🔊" => crate :: objects :: sound :: SPEAKER_HIGH_VOLUME , "📢" => crate :: objects :: sound :: LOUDSPEAKER , "📣" => crate :: objects :: sound :: MEGAPHONE , "📯" => crate :: objects :: sound :: POSTAL_HORN , "🔔" => crate :: objects :: sound :: BELL , "🔕" => crate :: objects :: sound :: BELL_WITH_SLASH , "🎼" => crate :: objects :: music :: MUSICAL_SCORE , "🎵" => crate :: objects :: music :: MUSICAL_NOTE , "🎶" => crate :: objects :: music :: MUSICAL_NOTES , "🎙\u{fe0f}" => crate :: objects :: music :: STUDIO_MICROPHONE , "🎙" => crate :: objects :: music :: STUDIO_MICROPHONE , "🎚\u{fe0f}" => crate :: objects :: music :: LEVEL_SLIDER , "🎚" => crate :: objects :: music :: LEVEL_SLIDER , "🎛\u{fe0f}" => crate :: objects :: music :: CONTROL_KNOBS , "🎛" => crate :: objects :: music :: CONTROL_KNOBS , "🎤" => crate :: objects :: music :: MICROPHONE , "🎧" => crate :: objects :: music :: HEADPHONE , "📻" => crate :: objects :: music :: RADIO , "🎷" => crate :: objects :: musical_instrument :: SAXOPHONE , "🪗" => crate :: objects :: musical_instrument :: ACCORDION , "🎸" => crate :: objects :: musical_instrument :: GUITAR , "🎹" => crate :: objects :: musical_instrument :: MUSICAL_KEYBOARD , "🎺" => crate :: objects :: musical_instrument :: TRUMPET , "🎻" => crate :: objects :: musical_instrument :: VIOLIN , "🪕" => crate :: objects :: musical_instrument :: BANJO , "🥁" => crate :: objects :: musical_instrument :: DRUM , "🪘" => crate :: objects :: musical_instrument :: LONG_DRUM , "📱" => crate :: objects :: phone :: MOBILE_PHONE , "📲" => crate :: objects :: phone :: MOBILE_PHONE_WITH_ARROW , "☎\u{fe0f}" => crate :: objects :: phone :: TELEPHONE , "☎" => crate :: objects :: phone :: TELEPHONE , "📞" => crate :: objects :: phone :: TELEPHONE_RECEIVER , "📟" => crate :: objects :: phone :: PAGER , "📠" => crate :: objects :: phone :: FAX_MACHINE , "🔋" => crate :: objects :: computer :: BATTERY , "🔌" => crate :: objects :: computer :: ELECTRIC_PLUG , "💻" => crate :: objects :: computer :: LAPTOP , "🖥\u{fe0f}" => crate :: objects :: computer :: DESKTOP_COMPUTER , "🖥" => crate :: objects :: computer :: DESKTOP_COMPUTER , "🖨\u{fe0f}" => crate :: objects :: computer :: PRINTER , "🖨" => crate :: objects :: computer :: PRINTER , "⌨\u{fe0f}" => crate :: objects :: computer :: KEYBOARD , "⌨" => crate :: objects :: computer :: KEYBOARD , "🖱\u{fe0f}" => crate :: objects :: computer :: COMPUTER_MOUSE , "🖱" => crate :: objects :: computer :: COMPUTER_MOUSE , "🖲\u{fe0f}" => crate :: objects :: computer :: TRACKBALL , "🖲" => crate :: objects :: computer :: TRACKBALL , "💽" => crate :: objects :: computer :: COMPUTER_DISK , "💾" => crate :: objects :: computer :: FLOPPY_DISK , "💿" => crate :: objects :: computer :: OPTICAL_DISK , "📀" => crate :: objects :: computer :: DVD , "🧮" => crate :: objects :: computer :: ABACUS , "🎥" => crate :: objects :: light_and_video :: MOVIE_CAMERA , "🎞\u{fe0f}" => crate :: objects :: light_and_video :: FILM_FRAMES , "🎞" => crate :: objects :: light_and_video :: FILM_FRAMES , "📽\u{fe0f}" => crate :: objects :: light_and_video :: FILM_PROJECTOR , "📽" => crate :: objects :: light_and_video :: FILM_PROJECTOR , "🎬" => crate :: objects :: light_and_video :: CLAPPER_BOARD , "📺" => crate :: objects :: light_and_video :: TELEVISION , "📷" => crate :: objects :: light_and_video :: CAMERA , "📸" => crate :: objects :: light_and_video :: CAMERA_WITH_FLASH , "📹" => crate :: objects :: light_and_video :: VIDEO_CAMERA , "📼" => crate :: objects :: light_and_video :: VIDEOCASSETTE , "🔍" => crate :: objects :: light_and_video :: MAGNIFYING_GLASS_TILTED_LEFT , "🔎" => crate :: objects :: light_and_video :: MAGNIFYING_GLASS_TILTED_RIGHT , "🕯\u{fe0f}" => crate :: objects :: light_and_video :: CANDLE , "🕯" => crate :: objects :: light_and_video :: CANDLE , "💡" => crate :: objects :: light_and_video :: LIGHT_BULB , "🔦" => crate :: objects :: light_and_video :: FLASHLIGHT , "🏮" => crate :: objects :: light_and_video :: RED_PAPER_LANTERN , "🪔" => crate :: objects :: light_and_video :: DIYA_LAMP , "📔" => crate :: objects :: book_paper :: NOTEBOOK_WITH_DECORATIVE_COVER , "📕" => crate :: objects :: book_paper :: CLOSED_BOOK , "📖" => crate :: objects :: book_paper :: OPEN_BOOK , "📗" => crate :: objects :: book_paper :: GREEN_BOOK , "📘" => crate :: objects :: book_paper :: BLUE_BOOK , "📙" => crate :: objects :: book_paper :: ORANGE_BOOK , "📚" => crate :: objects :: book_paper :: BOOKS , "📓" => crate :: objects :: book_paper :: NOTEBOOK , "📒" => crate :: objects :: book_paper :: LEDGER , "📃" => crate :: objects :: book_paper :: PAGE_WITH_CURL , "📜" => crate :: objects :: book_paper :: SCROLL , "📄" => crate :: objects :: book_paper :: PAGE_FACING_UP , "📰" => crate :: objects :: book_paper :: NEWSPAPER , "🗞\u{fe0f}" => crate :: objects :: book_paper :: ROLLED_UP_NEWSPAPER , "🗞" => crate :: objects :: book_paper :: ROLLED_UP_NEWSPAPER , "📑" => crate :: objects :: book_paper :: BOOKMARK_TABS , "🔖" => crate :: objects :: book_paper :: BOOKMARK , "🏷\u{fe0f}" => crate :: objects :: book_paper :: LABEL , "🏷" => crate :: objects :: book_paper :: LABEL , "💰" => crate :: objects :: money :: MONEY_BAG , "🪙" => crate :: objects :: money :: COIN , "💴" => crate :: objects :: money :: YEN_BANKNOTE , "💵" => crate :: objects :: money :: DOLLAR_BANKNOTE , "💶" => crate :: objects :: money :: EURO_BANKNOTE , "💷" => crate :: objects :: money :: POUND_BANKNOTE , "💸" => crate :: objects :: money :: MONEY_WITH_WINGS , "💳" => crate :: objects :: money :: CREDIT_CARD , "🧾" => crate :: objects :: money :: RECEIPT , "💹" => crate :: objects :: money :: CHART_INCREASING_WITH_YEN , "✉\u{fe0f}" => crate :: objects :: mail :: ENVELOPE , "✉" => crate :: objects :: mail :: ENVELOPE , "📧" => crate :: objects :: mail :: E_MAIL , "📨" => crate :: objects :: mail :: INCOMING_ENVELOPE , "📩" => crate :: objects :: mail :: ENVELOPE_WITH_ARROW , "📤" => crate :: objects :: mail :: OUTBOX_TRAY , "📥" => crate :: objects :: mail :: INBOX_TRAY , "📦" => crate :: objects :: mail :: PACKAGE , "📫" => crate :: objects :: mail :: CLOSED_MAILBOX_WITH_RAISED_FLAG , "📪" => crate :: objects :: mail :: CLOSED_MAILBOX_WITH_LOWERED_FLAG , "📬" => crate :: objects :: mail :: OPEN_MAILBOX_WITH_RAISED_FLAG , "📭" => crate :: objects :: mail :: OPEN_MAILBOX_WITH_LOWERED_FLAG , "📮" => crate :: objects :: mail :: POSTBOX , "🗳\u{fe0f}" => crate :: objects :: mail :: BALLOT_BOX_WITH_BALLOT , "🗳" => crate :: objects :: mail :: BALLOT_BOX_WITH_BALLOT , "✏\u{fe0f}" => crate :: objects :: writing :: PENCIL , "✏" => crate :: objects :: writing :: PENCIL , "✒\u{fe0f}" => crate :: objects :: writing :: BLACK_NIB , "✒" => crate :: objects :: writing :: BLACK_NIB , "🖋\u{fe0f}" => crate :: objects :: writing :: FOUNTAIN_PEN , "🖋" => crate :: objects :: writing :: FOUNTAIN_PEN , "🖊\u{fe0f}" => crate :: objects :: writing :: PEN , "🖊" => crate :: objects :: writing :: PEN , "🖌\u{fe0f}" => crate :: objects :: writing :: PAINTBRUSH , "🖌" => crate :: objects :: writing :: PAINTBRUSH , "🖍\u{fe0f}" => crate :: objects :: writing :: CRAYON , "🖍" => crate :: objects :: writing :: CRAYON , "📝" => crate :: objects :: writing :: MEMO , "💼" => crate :: objects :: office :: BRIEFCASE , "📁" => crate :: objects :: office :: FILE_FOLDER , "📂" => crate :: objects :: office :: OPEN_FILE_FOLDER , "🗂\u{fe0f}" => crate :: objects :: office :: CARD_INDEX_DIVIDERS , "🗂" => crate :: objects :: office :: CARD_INDEX_DIVIDERS , "📅" => crate :: objects :: office :: CALENDAR , "📆" => crate :: objects :: office :: TEAR_OFF_CALENDAR , "🗒\u{fe0f}" => crate :: objects :: office :: SPIRAL_NOTEPAD , "🗒" => crate :: objects :: office :: SPIRAL_NOTEPAD , "🗓\u{fe0f}" => crate :: objects :: office :: SPIRAL_CALENDAR , "🗓" => crate :: objects :: office :: SPIRAL_CALENDAR , "📇" => crate :: objects :: office :: CARD_INDEX , "📈" => crate :: objects :: office :: CHART_INCREASING , "📉" => crate :: objects :: office :: CHART_DECREASING , "📊" => crate :: objects :: office :: BAR_CHART , "📋" => crate :: objects :: office :: CLIPBOARD , "📌" => crate :: objects :: office :: PUSHPIN , "📍" => crate :: objects :: office :: ROUND_PUSHPIN , "📎" => crate :: objects :: office :: PAPERCLIP , "🖇\u{fe0f}" => crate :: objects :: office :: LINKED_PAPERCLIPS , "🖇" => crate :: objects :: office :: LINKED_PAPERCLIPS , "📏" => crate :: objects :: office :: STRAIGHT_RULER , "📐" => crate :: objects :: office :: TRIANGULAR_RULER , "✂\u{fe0f}" => crate :: objects :: office :: SCISSORS , "✂" => crate :: objects :: office :: SCISSORS , "🗃\u{fe0f}" => crate :: objects :: office :: CARD_FILE_BOX , "🗃" => crate :: objects :: office :: CARD_FILE_BOX , "🗄\u{fe0f}" => crate :: objects :: office :: FILE_CABINET , "🗄" => crate :: objects :: office :: FILE_CABINET , "🗑\u{fe0f}" => crate :: objects :: office :: WASTEBASKET , "🗑" => crate :: objects :: office :: WASTEBASKET , "🔒" => crate :: objects :: lock :: LOCKED , "🔓" => crate :: objects :: lock :: UNLOCKED , "🔏" => crate :: objects :: lock :: LOCKED_WITH_PEN , "🔐" => crate :: objects :: lock :: LOCKED_WITH_KEY , "🔑" => crate :: objects :: lock :: KEY , "🗝\u{fe0f}" => crate :: objects :: lock :: OLD_KEY , "🗝" => crate :: objects :: lock :: OLD_KEY , "🔨" => crate :: objects :: tool :: HAMMER , "🪓" => crate :: objects :: tool :: AXE , "⛏\u{fe0f}" => crate :: objects :: tool :: PICK , "⛏" => crate :: objects :: tool :: PICK , "⚒\u{fe0f}" => crate :: objects :: tool :: HAMMER_AND_PICK , "⚒" => crate :: objects :: tool :: HAMMER_AND_PICK , "🛠\u{fe0f}" => crate :: objects :: tool :: HAMMER_AND_WRENCH , "🛠" => crate :: objects :: tool :: HAMMER_AND_WRENCH , "🗡\u{fe0f}" => crate :: objects :: tool :: DAGGER , "🗡" => crate :: objects :: tool :: DAGGER , "⚔\u{fe0f}" => crate :: objects :: tool :: CROSSED_SWORDS , "⚔" => crate :: objects :: tool :: CROSSED_SWORDS , "🔫" => crate :: objects :: tool :: WATER_PISTOL , "🪃" => crate :: objects :: tool :: BOOMERANG , "🏹" => crate :: objects :: tool :: BOW_AND_ARROW , "🛡\u{fe0f}" => crate :: objects :: tool :: SHIELD , "🛡" => crate :: objects :: tool :: SHIELD , "🪚" => crate :: objects :: tool :: CARPENTRY_SAW , "🔧" => crate :: objects :: tool :: WRENCH , "🪛" => crate :: objects :: tool :: SCREWDRIVER , "🔩" => crate :: objects :: tool :: NUT_AND_BOLT , "⚙\u{fe0f}" => crate :: objects :: tool :: GEAR , "⚙" => crate :: objects :: tool :: GEAR , "🗜\u{fe0f}" => crate :: objects :: tool :: CLAMP , "🗜" => crate :: objects :: tool :: CLAMP , "⚖\u{fe0f}" => crate :: objects :: tool :: BALANCE_SCALE , "⚖" => crate :: objects :: tool :: BALANCE_SCALE , "🦯" => crate :: objects :: tool :: WHITE_CANE , "🔗" => crate :: objects :: tool :: LINK , "⛓\u{fe0f}" => crate :: objects :: tool :: CHAINS , "⛓" => crate :: objects :: tool :: CHAINS , "🪝" => crate :: objects :: tool :: HOOK , "🧰" => crate :: objects :: tool :: TOOLBOX , "🧲" => crate :: objects :: tool :: MAGNET , "🪜" => crate :: objects :: tool :: LADDER , "⚗\u{fe0f}" => crate :: objects :: science :: ALEMBIC , "⚗" => crate :: objects :: science :: ALEMBIC , "🧪" => crate :: objects :: science :: TEST_TUBE , "🧫" => crate :: objects :: science :: PETRI_DISH , "🧬" => crate :: objects :: science :: DNA , "🔬" => crate :: objects :: science :: MICROSCOPE , "🔭" => crate :: objects :: science :: TELESCOPE , "📡" => crate :: objects :: science :: SATELLITE_ANTENNA , "💉" => crate :: objects :: medical :: SYRINGE , "🩸" => crate :: objects :: medical :: DROP_OF_BLOOD , "💊" => crate :: objects :: medical :: PILL , "🩹" => crate :: objects :: medical :: ADHESIVE_BANDAGE , "🩺" => crate :: objects :: medical :: STETHOSCOPE , "🚪" => crate :: objects :: household :: DOOR , "🛗" => crate :: objects :: household :: ELEVATOR , "🪞" => crate :: objects :: household :: MIRROR , "🪟" => crate :: objects :: household :: WINDOW , "🛏\u{fe0f}" => crate :: objects :: household :: BED , "🛏" => crate :: objects :: household :: BED , "🛋\u{fe0f}" => crate :: objects :: household :: COUCH_AND_LAMP , "🛋" => crate :: objects :: household :: COUCH_AND_LAMP , "🪑" => crate :: objects :: household :: CHAIR , "🚽" => crate :: objects :: household :: TOILET , "🪠" => crate :: objects :: household :: PLUNGER , "🚿" => crate :: objects :: household :: SHOWER , "🛁" => crate :: objects :: household :: BATHTUB , "🪤" => crate :: objects :: household :: MOUSE_TRAP , "🪒" => crate :: objects :: household :: RAZOR , "🧴" => crate :: objects :: household :: LOTION_BOTTLE , "🧷" => crate :: objects :: household :: SAFETY_PIN , "🧹" => crate :: objects :: household :: BROOM , "🧺" => crate :: objects :: household :: BASKET , "🧻" => crate :: objects :: household :: ROLL_OF_PAPER , "🪣" => crate :: objects :: household :: BUCKET , "🧼" => crate :: objects :: household :: SOAP , "🪥" => crate :: objects :: household :: TOOTHBRUSH , "🧽" => crate :: objects :: household :: SPONGE , "🧯" => crate :: objects :: household :: FIRE_EXTINGUISHER , "🛒" => crate :: objects :: household :: SHOPPING_CART , "🚬" => crate :: objects :: other_object :: CIGARETTE , "⚰\u{fe0f}" => crate :: objects :: other_object :: COFFIN , "⚰" => crate :: objects :: other_object :: COFFIN , "🪦" => crate :: objects :: other_object :: HEADSTONE , "⚱\u{fe0f}" => crate :: objects :: other_object :: FUNERAL_URN , "⚱" => crate :: objects :: other_object :: FUNERAL_URN , "🗿" => crate :: objects :: other_object :: MOAI , "🪧" => crate :: objects :: other_object :: PLACARD , "🏧" => crate :: symbols :: transport_sign :: ATM_SIGN , "🚮" => crate :: symbols :: transport_sign :: LITTER_IN_BIN_SIGN , "🚰" => crate :: symbols :: transport_sign :: POTABLE_WATER , "♿" => crate :: symbols :: transport_sign :: WHEELCHAIR_SYMBOL , "🚹" => crate :: symbols :: transport_sign :: MENS_ROOM , "🚺" => crate :: symbols :: transport_sign :: WOMENS_ROOM , "🚻" => crate :: symbols :: transport_sign :: RESTROOM , "🚼" => crate :: symbols :: transport_sign :: BABY_SYMBOL , "🚾" => crate :: symbols :: transport_sign :: WATER_CLOSET , "🛂" => crate :: symbols :: transport_sign :: PASSPORT_CONTROL , "🛃" => crate :: symbols :: transport_sign :: CUSTOMS , "🛄" => crate :: symbols :: transport_sign :: BAGGAGE_CLAIM , "🛅" => crate :: symbols :: transport_sign :: LEFT_LUGGAGE , "⚠\u{fe0f}" => crate :: symbols :: warning :: WARNING , "⚠" => crate :: symbols :: warning :: WARNING , "🚸" => crate :: symbols :: warning :: CHILDREN_CROSSING , "⛔" => crate :: symbols :: warning :: NO_ENTRY , "🚫" => crate :: symbols :: warning :: PROHIBITED , "🚳" => crate :: symbols :: warning :: NO_BICYCLES , "🚭" => crate :: symbols :: warning :: NO_SMOKING , "🚯" => crate :: symbols :: warning :: NO_LITTERING , "🚱" => crate :: symbols :: warning :: NON_POTABLE_WATER , "🚷" => crate :: symbols :: warning :: NO_PEDESTRIANS , "📵" => crate :: symbols :: warning :: NO_MOBILE_PHONES , "🔞" => crate :: symbols :: warning :: NO_ONE_UNDER_EIGHTEEN , "☢\u{fe0f}" => crate :: symbols :: warning :: RADIOACTIVE , "☢" => crate :: symbols :: warning :: RADIOACTIVE , "☣\u{fe0f}" => crate :: symbols :: warning :: BIOHAZARD , "☣" => crate :: symbols :: warning :: BIOHAZARD , "⬆\u{fe0f}" => crate :: symbols :: arrow :: UP_ARROW , "⬆" => crate :: symbols :: arrow :: UP_ARROW , "↗\u{fe0f}" => crate :: symbols :: arrow :: UP_RIGHT_ARROW , "↗" => crate :: symbols :: arrow :: UP_RIGHT_ARROW , "➡\u{fe0f}" => crate :: symbols :: arrow :: RIGHT_ARROW , "➡" => crate :: symbols :: arrow :: RIGHT_ARROW , "↘\u{fe0f}" => crate :: symbols :: arrow :: DOWN_RIGHT_ARROW , "↘" => crate :: symbols :: arrow :: DOWN_RIGHT_ARROW , "⬇\u{fe0f}" => crate :: symbols :: arrow :: DOWN_ARROW , "⬇" => crate :: symbols :: arrow :: DOWN_ARROW , "↙\u{fe0f}" => crate :: symbols :: arrow :: DOWN_LEFT_ARROW , "↙" => crate :: symbols :: arrow :: DOWN_LEFT_ARROW , "⬅\u{fe0f}" => crate :: symbols :: arrow :: LEFT_ARROW , "⬅" => crate :: symbols :: arrow :: LEFT_ARROW , "↖\u{fe0f}" => crate :: symbols :: arrow :: UP_LEFT_ARROW , "↖" => crate :: symbols :: arrow :: UP_LEFT_ARROW , "↕\u{fe0f}" => crate :: symbols :: arrow :: UP_DOWN_ARROW , "↕" => crate :: symbols :: arrow :: UP_DOWN_ARROW , "↔\u{fe0f}" => crate :: symbols :: arrow :: LEFT_RIGHT_ARROW , "↔" => crate :: symbols :: arrow :: LEFT_RIGHT_ARROW , "↩\u{fe0f}" => crate :: symbols :: arrow :: RIGHT_ARROW_CURVING_LEFT , "↩" => crate :: symbols :: arrow :: RIGHT_ARROW_CURVING_LEFT , "↪\u{fe0f}" => crate :: symbols :: arrow :: LEFT_ARROW_CURVING_RIGHT , "↪" => crate :: symbols :: arrow :: LEFT_ARROW_CURVING_RIGHT , "⤴\u{fe0f}" => crate :: symbols :: arrow :: RIGHT_ARROW_CURVING_UP , "⤴" => crate :: symbols :: arrow :: RIGHT_ARROW_CURVING_UP , "⤵\u{fe0f}" => crate :: symbols :: arrow :: RIGHT_ARROW_CURVING_DOWN , "⤵" => crate :: symbols :: arrow :: RIGHT_ARROW_CURVING_DOWN , "🔃" => crate :: symbols :: arrow :: CLOCKWISE_VERTICAL_ARROWS , "🔄" => crate :: symbols :: arrow :: COUNTERCLOCKWISE_ARROWS_BUTTON , "🔙" => crate :: symbols :: arrow :: BACK_ARROW , "🔚" => crate :: symbols :: arrow :: END_ARROW , "🔛" => crate :: symbols :: arrow :: ON_ARROW , "🔜" => crate :: symbols :: arrow :: SOON_ARROW , "🔝" => crate :: symbols :: arrow :: TOP_ARROW , "🛐" => crate :: symbols :: religion :: PLACE_OF_WORSHIP , "⚛\u{fe0f}" => crate :: symbols :: religion :: ATOM_SYMBOL , "⚛" => crate :: symbols :: religion :: ATOM_SYMBOL , "🕉\u{fe0f}" => crate :: symbols :: religion :: OM , "🕉" => crate :: symbols :: religion :: OM , "✡\u{fe0f}" => crate :: symbols :: religion :: STAR_OF_DAVID , "✡" => crate :: symbols :: religion :: STAR_OF_DAVID , "☸\u{fe0f}" => crate :: symbols :: religion :: WHEEL_OF_DHARMA , "☸" => crate :: symbols :: religion :: WHEEL_OF_DHARMA , "☯\u{fe0f}" => crate :: symbols :: religion :: YIN_YANG , "☯" => crate :: symbols :: religion :: YIN_YANG , "✝\u{fe0f}" => crate :: symbols :: religion :: LATIN_CROSS , "✝" => crate :: symbols :: religion :: LATIN_CROSS , "☦\u{fe0f}" => crate :: symbols :: religion :: ORTHODOX_CROSS , "☦" => crate :: symbols :: religion :: ORTHODOX_CROSS , "☪\u{fe0f}" => crate :: symbols :: religion :: STAR_AND_CRESCENT , "☪" => crate :: symbols :: religion :: STAR_AND_CRESCENT , "☮\u{fe0f}" => crate :: symbols :: religion :: PEACE_SYMBOL , "☮" => crate :: symbols :: religion :: PEACE_SYMBOL , "🕎" => crate :: symbols :: religion :: MENORAH , "🔯" => crate :: symbols :: religion :: DOTTED_SIX_POINTED_STAR , "♈" => crate :: symbols :: zodiac :: ARIES , "♉" => crate :: symbols :: zodiac :: TAURUS , "♊" => crate :: symbols :: zodiac :: GEMINI , "♋" => crate :: symbols :: zodiac :: CANCER , "♌" => crate :: symbols :: zodiac :: LEO , "♍" => crate :: symbols :: zodiac :: VIRGO , "♎" => crate :: symbols :: zodiac :: LIBRA , "♏" => crate :: symbols :: zodiac :: SCORPIO , "♐" => crate :: symbols :: zodiac :: SAGITTARIUS , "♑" => crate :: symbols :: zodiac :: CAPRICORN , "♒" => crate :: symbols :: zodiac :: AQUARIUS , "♓" => crate :: symbols :: zodiac :: PISCES , "⛎" => crate :: symbols :: zodiac :: OPHIUCHUS , "🔀" => crate :: symbols :: av_symbol :: SHUFFLE_TRACKS_BUTTON , "🔁" => crate :: symbols :: av_symbol :: REPEAT_BUTTON , "🔂" => crate :: symbols :: av_symbol :: REPEAT_SINGLE_BUTTON , "▶\u{fe0f}" => crate :: symbols :: av_symbol :: PLAY_BUTTON , "▶" => crate :: symbols :: av_symbol :: PLAY_BUTTON , "⏩" => crate :: symbols :: av_symbol :: FAST_FORWARD_BUTTON , "⏭\u{fe0f}" => crate :: symbols :: av_symbol :: NEXT_TRACK_BUTTON , "⏭" => crate :: symbols :: av_symbol :: NEXT_TRACK_BUTTON , "⏯\u{fe0f}" => crate :: symbols :: av_symbol :: PLAY_OR_PAUSE_BUTTON , "⏯" => crate :: symbols :: av_symbol :: PLAY_OR_PAUSE_BUTTON , "◀\u{fe0f}" => crate :: symbols :: av_symbol :: REVERSE_BUTTON , "◀" => crate :: symbols :: av_symbol :: REVERSE_BUTTON , "⏪" => crate :: symbols :: av_symbol :: FAST_REVERSE_BUTTON , "⏮\u{fe0f}" => crate :: symbols :: av_symbol :: LAST_TRACK_BUTTON , "⏮" => crate :: symbols :: av_symbol :: LAST_TRACK_BUTTON , "🔼" => crate :: symbols :: av_symbol :: UPWARDS_BUTTON , "⏫" => crate :: symbols :: av_symbol :: FAST_UP_BUTTON , "🔽" => crate :: symbols :: av_symbol :: DOWNWARDS_BUTTON , "⏬" => crate :: symbols :: av_symbol :: FAST_DOWN_BUTTON , "⏸\u{fe0f}" => crate :: symbols :: av_symbol :: PAUSE_BUTTON , "⏸" => crate :: symbols :: av_symbol :: PAUSE_BUTTON , "⏹\u{fe0f}" => crate :: symbols :: av_symbol :: STOP_BUTTON , "⏹" => crate :: symbols :: av_symbol :: STOP_BUTTON , "⏺\u{fe0f}" => crate :: symbols :: av_symbol :: RECORD_BUTTON , "⏺" => crate :: symbols :: av_symbol :: RECORD_BUTTON , "⏏\u{fe0f}" => crate :: symbols :: av_symbol :: EJECT_BUTTON , "⏏" => crate :: symbols :: av_symbol :: EJECT_BUTTON , "🎦" => crate :: symbols :: av_symbol :: CINEMA , "🔅" => crate :: symbols :: av_symbol :: DIM_BUTTON , "🔆" => crate :: symbols :: av_symbol :: BRIGHT_BUTTON , "📶" => crate :: symbols :: av_symbol :: ANTENNA_BARS , "📳" => crate :: symbols :: av_symbol :: VIBRATION_MODE , "📴" => crate :: symbols :: av_symbol :: MOBILE_PHONE_OFF , "♀\u{fe0f}" => crate :: symbols :: gender :: FEMALE_SIGN , "♀" => crate :: symbols :: gender :: FEMALE_SIGN , "♂\u{fe0f}" => crate :: symbols :: gender :: MALE_SIGN , "♂" => crate :: symbols :: gender :: MALE_SIGN , "⚧\u{fe0f}" => crate :: symbols :: gender :: TRANSGENDER_SYMBOL , "⚧" => crate :: symbols :: gender :: TRANSGENDER_SYMBOL , "✖\u{fe0f}" => crate :: symbols :: math :: MULTIPLY , "✖" => crate :: symbols :: math :: MULTIPLY , "➕" => crate :: symbols :: math :: PLUS , "➖" => crate :: symbols :: math :: MINUS , "➗" => crate :: symbols :: math :: DIVIDE , "♾\u{fe0f}" => crate :: symbols :: math :: INFINITY , "♾" => crate :: symbols :: math :: INFINITY , "‼\u{fe0f}" => crate :: symbols :: punctuation :: DOUBLE_EXCLAMATION_MARK , "‼" => crate :: symbols :: punctuation :: DOUBLE_EXCLAMATION_MARK , "⁉\u{fe0f}" => crate :: symbols :: punctuation :: EXCLAMATION_QUESTION_MARK , "⁉" => crate :: symbols :: punctuation :: EXCLAMATION_QUESTION_MARK , "❓" => crate :: symbols :: punctuation :: RED_QUESTION_MARK , "❔" => crate :: symbols :: punctuation :: WHITE_QUESTION_MARK , "❕" => crate :: symbols :: punctuation :: WHITE_EXCLAMATION_MARK , "❗" => crate :: symbols :: punctuation :: RED_EXCLAMATION_MARK , "〰\u{fe0f}" => crate :: symbols :: punctuation :: WAVY_DASH , "〰" => crate :: symbols :: punctuation :: WAVY_DASH , "💱" => crate :: symbols :: currency :: CURRENCY_EXCHANGE , "💲" => crate :: symbols :: currency :: HEAVY_DOLLAR_SIGN , "⚕\u{fe0f}" => crate :: symbols :: other_symbol :: MEDICAL_SYMBOL , "⚕" => crate :: symbols :: other_symbol :: MEDICAL_SYMBOL , "♻\u{fe0f}" => crate :: symbols :: other_symbol :: RECYCLING_SYMBOL , "♻" => crate :: symbols :: other_symbol :: RECYCLING_SYMBOL , "⚜\u{fe0f}" => crate :: symbols :: other_symbol :: FLEUR_DE_LIS , "⚜" => crate :: symbols :: other_symbol :: FLEUR_DE_LIS , "🔱" => crate :: symbols :: other_symbol :: TRIDENT_EMBLEM , "📛" => crate :: symbols :: other_symbol :: NAME_BADGE , "🔰" => crate :: symbols :: other_symbol :: JAPANESE_SYMBOL_FOR_BEGINNER , "⭕" => crate :: symbols :: other_symbol :: HOLLOW_RED_CIRCLE , "✅" => crate :: symbols :: other_symbol :: CHECK_MARK_BUTTON , "☑\u{fe0f}" => crate :: symbols :: other_symbol :: CHECK_BOX_WITH_CHECK , "☑" => crate :: symbols :: other_symbol :: CHECK_BOX_WITH_CHECK , "✔\u{fe0f}" => crate :: symbols :: other_symbol :: CHECK_MARK , "✔" => crate :: symbols :: other_symbol :: CHECK_MARK , "❌" => crate :: symbols :: other_symbol :: CROSS_MARK , "❎" => crate :: symbols :: other_symbol :: CROSS_MARK_BUTTON , "➰" => crate :: symbols :: other_symbol :: CURLY_LOOP , "➿" => crate :: symbols :: other_symbol :: DOUBLE_CURLY_LOOP , "〽\u{fe0f}" => crate :: symbols :: other_symbol :: PART_ALTERNATION_MARK , "〽" => crate :: symbols :: other_symbol :: PART_ALTERNATION_MARK , "✳\u{fe0f}" => crate :: symbols :: other_symbol :: EIGHT_SPOKED_ASTERISK , "✳" => crate :: symbols :: other_symbol :: EIGHT_SPOKED_ASTERISK , "✴\u{fe0f}" => crate :: symbols :: other_symbol :: EIGHT_POINTED_STAR , "✴" => crate :: symbols :: other_symbol :: EIGHT_POINTED_STAR , "❇\u{fe0f}" => crate :: symbols :: other_symbol :: SPARKLE , "❇" => crate :: symbols :: other_symbol :: SPARKLE , "©\u{fe0f}" => crate :: symbols :: other_symbol :: COPYRIGHT , "©" => crate :: symbols :: other_symbol :: COPYRIGHT , "®\u{fe0f}" => crate :: symbols :: other_symbol :: REGISTERED , "®" => crate :: symbols :: other_symbol :: REGISTERED , "™\u{fe0f}" => crate :: symbols :: other_symbol :: TRADE_MARK , "™" => crate :: symbols :: other_symbol :: TRADE_MARK , "#\u{fe0f}\u{20e3}" => crate :: symbols :: keycap :: KEYCAP_POUND , "#\u{20e3}" => crate :: symbols :: keycap :: KEYCAP_POUND , "*\u{fe0f}\u{20e3}" => crate :: symbols :: keycap :: KEYCAP_ASTERISK , "*\u{20e3}" => crate :: symbols :: keycap :: KEYCAP_ASTERISK , "0\u{fe0f}\u{20e3}" => crate :: symbols :: keycap :: KEYCAP_0 , "0\u{20e3}" => crate :: symbols :: keycap :: KEYCAP_0 , "1\u{fe0f}\u{20e3}" => crate :: symbols :: keycap :: KEYCAP_1 , "1\u{20e3}" => crate :: symbols :: keycap :: KEYCAP_1 , "2\u{fe0f}\u{20e3}" => crate :: symbols :: keycap :: KEYCAP_2 , "2\u{20e3}" => crate :: symbols :: keycap :: KEYCAP_2 , "3\u{fe0f}\u{20e3}" => crate :: symbols :: keycap :: KEYCAP_3 , "3\u{20e3}" => crate :: symbols :: keycap :: KEYCAP_3 , "4\u{fe0f}\u{20e3}" => crate :: symbols :: keycap :: KEYCAP_4 , "4\u{20e3}" => crate :: symbols :: keycap :: KEYCAP_4 , "5\u{fe0f}\u{20e3}" => crate :: symbols :: keycap :: KEYCAP_5 , "5\u{20e3}" => crate :: symbols :: keycap :: KEYCAP_5 , "6\u{fe0f}\u{20e3}" => crate :: symbols :: keycap :: KEYCAP_6 , "6\u{20e3}" => crate :: symbols :: keycap :: KEYCAP_6 , "7\u{fe0f}\u{20e3}" => crate :: symbols :: keycap :: KEYCAP_7 , "7\u{20e3}" => crate :: symbols :: keycap :: KEYCAP_7 , "8\u{fe0f}\u{20e3}" => crate :: symbols :: keycap :: KEYCAP_8 , "8\u{20e3}" => crate :: symbols :: keycap :: KEYCAP_8 , "9\u{fe0f}\u{20e3}" => crate :: symbols :: keycap :: KEYCAP_9 , "9\u{20e3}" => crate :: symbols :: keycap :: KEYCAP_9 , "🔟" => crate :: symbols :: keycap :: KEYCAP_10 , "🔠" => crate :: symbols :: alphanum :: INPUT_LATIN_UPPERCASE , "🔡" => crate :: symbols :: alphanum :: INPUT_LATIN_LOWERCASE , "🔢" => crate :: symbols :: alphanum :: INPUT_NUMBERS , "🔣" => crate :: symbols :: alphanum :: INPUT_SYMBOLS , "🔤" => crate :: symbols :: alphanum :: INPUT_LATIN_LETTERS , "🅰\u{fe0f}" => crate :: symbols :: alphanum :: A_BUTTON_BLOOD_TYPE , "🅰" => crate :: symbols :: alphanum :: A_BUTTON_BLOOD_TYPE , "🆎" => crate :: symbols :: alphanum :: AB_BUTTON_BLOOD_TYPE , "🅱\u{fe0f}" => crate :: symbols :: alphanum :: B_BUTTON_BLOOD_TYPE , "🅱" => crate :: symbols :: alphanum :: B_BUTTON_BLOOD_TYPE , "🆑" => crate :: symbols :: alphanum :: CL_BUTTON , "🆒" => crate :: symbols :: alphanum :: COOL_BUTTON , "🆓" => crate :: symbols :: alphanum :: FREE_BUTTON , "ℹ\u{fe0f}" => crate :: symbols :: alphanum :: INFORMATION , "ℹ" => crate :: symbols :: alphanum :: INFORMATION , "🆔" => crate :: symbols :: alphanum :: ID_BUTTON , "Ⓜ\u{fe0f}" => crate :: symbols :: alphanum :: CIRCLED_M , "Ⓜ" => crate :: symbols :: alphanum :: CIRCLED_M , "🆕" => crate :: symbols :: alphanum :: NEW_BUTTON , "🆖" => crate :: symbols :: alphanum :: NG_BUTTON , "🅾\u{fe0f}" => crate :: symbols :: alphanum :: O_BUTTON_BLOOD_TYPE , "🅾" => crate :: symbols :: alphanum :: O_BUTTON_BLOOD_TYPE , "🆗" => crate :: symbols :: alphanum :: OK_BUTTON , "🅿\u{fe0f}" => crate :: symbols :: alphanum :: P_BUTTON , "🅿" => crate :: symbols :: alphanum :: P_BUTTON , "🆘" => crate :: symbols :: alphanum :: SOS_BUTTON , "🆙" => crate :: symbols :: alphanum :: UP_BUTTON , "🆚" => crate :: symbols :: alphanum :: VS_BUTTON , "🈁" => crate :: symbols :: alphanum :: JAPANESE__HERE__BUTTON , "🈂\u{fe0f}" => crate :: symbols :: alphanum :: JAPANESE__SERVICE_CHARGE__BUTTON , "🈂" => crate :: symbols :: alphanum :: JAPANESE__SERVICE_CHARGE__BUTTON , "🈷\u{fe0f}" => crate :: symbols :: alphanum :: JAPANESE__MONTHLY_AMOUNT__BUTTON , "🈷" => crate :: symbols :: alphanum :: JAPANESE__MONTHLY_AMOUNT__BUTTON , "🈶" => crate :: symbols :: alphanum :: JAPANESE__NOT_FREE_OF_CHARGE__BUTTON , "🈯" => crate :: symbols :: alphanum :: JAPANESE__RESERVED__BUTTON , "🉐" => crate :: symbols :: alphanum :: JAPANESE__BARGAIN__BUTTON , "🈹" => crate :: symbols :: alphanum :: JAPANESE__DISCOUNT__BUTTON , "🈚" => crate :: symbols :: alphanum :: JAPANESE__FREE_OF_CHARGE__BUTTON , "🈲" => crate :: symbols :: alphanum :: JAPANESE__PROHIBITED__BUTTON , "🉑" => crate :: symbols :: alphanum :: JAPANESE__ACCEPTABLE__BUTTON , "🈸" => crate :: symbols :: alphanum :: JAPANESE__APPLICATION__BUTTON , "🈴" => crate :: symbols :: alphanum :: JAPANESE__PASSING_GRADE__BUTTON , "🈳" => crate :: symbols :: alphanum :: JAPANESE__VACANCY__BUTTON , "㊗\u{fe0f}" => crate :: symbols :: alphanum :: JAPANESE__CONGRATULATIONS__BUTTON , "㊗" => crate :: symbols :: alphanum :: JAPANESE__CONGRATULATIONS__BUTTON , "㊙\u{fe0f}" => crate :: symbols :: alphanum :: JAPANESE__SECRET__BUTTON , "㊙" => crate :: symbols :: alphanum :: JAPANESE__SECRET__BUTTON , "🈺" => crate :: symbols :: alphanum :: JAPANESE__OPEN_FOR_BUSINESS__BUTTON , "🈵" => crate :: symbols :: alphanum :: JAPANESE__NO_VACANCY__BUTTON , "🔴" => crate :: symbols :: geometric :: RED_CIRCLE , "🟠" => crate :: symbols :: geometric :: ORANGE_CIRCLE , "🟡" => crate :: symbols :: geometric :: YELLOW_CIRCLE , "🟢" => crate :: symbols :: geometric :: GREEN_CIRCLE , "🔵" => crate :: symbols :: geometric :: BLUE_CIRCLE , "🟣" => crate :: symbols :: geometric :: PURPLE_CIRCLE , "🟤" => crate :: symbols :: geometric :: BROWN_CIRCLE , "⚫" => crate :: symbols :: geometric :: BLACK_CIRCLE , "⚪" => crate :: symbols :: geometric :: WHITE_CIRCLE , "🟥" => crate :: symbols :: geometric :: RED_SQUARE , "🟧" => crate :: symbols :: geometric :: ORANGE_SQUARE , "🟨" => crate :: symbols :: geometric :: YELLOW_SQUARE , "🟩" => crate :: symbols :: geometric :: GREEN_SQUARE , "🟦" => crate :: symbols :: geometric :: BLUE_SQUARE , "🟪" => crate :: symbols :: geometric :: PURPLE_SQUARE , "🟫" => crate :: symbols :: geometric :: BROWN_SQUARE , "⬛" => crate :: symbols :: geometric :: BLACK_LARGE_SQUARE , "⬜" => crate :: symbols :: geometric :: WHITE_LARGE_SQUARE , "◼\u{fe0f}" => crate :: symbols :: geometric :: BLACK_MEDIUM_SQUARE , "◼" => crate :: symbols :: geometric :: BLACK_MEDIUM_SQUARE , "◻\u{fe0f}" => crate :: symbols :: geometric :: WHITE_MEDIUM_SQUARE , "◻" => crate :: symbols :: geometric :: WHITE_MEDIUM_SQUARE , "◾" => crate :: symbols :: geometric :: BLACK_MEDIUM_SMALL_SQUARE , "◽" => crate :: symbols :: geometric :: WHITE_MEDIUM_SMALL_SQUARE , "▪\u{fe0f}" => crate :: symbols :: geometric :: BLACK_SMALL_SQUARE , "▪" => crate :: symbols :: geometric :: BLACK_SMALL_SQUARE , "▫\u{fe0f}" => crate :: symbols :: geometric :: WHITE_SMALL_SQUARE , "▫" => crate :: symbols :: geometric :: WHITE_SMALL_SQUARE , "🔶" => crate :: symbols :: geometric :: LARGE_ORANGE_DIAMOND , "🔷" => crate :: symbols :: geometric :: LARGE_BLUE_DIAMOND , "🔸" => crate :: symbols :: geometric :: SMALL_ORANGE_DIAMOND , "🔹" => crate :: symbols :: geometric :: SMALL_BLUE_DIAMOND , "🔺" => crate :: symbols :: geometric :: RED_TRIANGLE_POINTED_UP , "🔻" => crate :: symbols :: geometric :: RED_TRIANGLE_POINTED_DOWN , "💠" => crate :: symbols :: geometric :: DIAMOND_WITH_A_DOT , "🔘" => crate :: symbols :: geometric :: RADIO_BUTTON , "🔳" => crate :: symbols :: geometric :: WHITE_SQUARE_BUTTON , "🔲" => crate :: symbols :: geometric :: BLACK_SQUARE_BUTTON , "🏁" => crate :: flags :: flag :: CHEQUERED_FLAG , "🚩" => crate :: flags :: flag :: TRIANGULAR_FLAG , "🎌" => crate :: flags :: flag :: CROSSED_FLAGS , "🏴" => crate :: flags :: flag :: BLACK_FLAG , "🏳\u{fe0f}" => crate :: flags :: flag :: WHITE_FLAG , "🏳" => crate :: flags :: flag :: WHITE_FLAG , "🏳\u{fe0f}\u{200d}🌈" => crate :: flags :: flag :: RAINBOW_FLAG , "🏳\u{200d}🌈" => crate :: flags :: flag :: RAINBOW_FLAG , "🏳\u{fe0f}\u{200d}⚧\u{fe0f}" => crate :: flags :: flag :: TRANSGENDER_FLAG , "🏳\u{200d}⚧\u{fe0f}" => crate :: flags :: flag :: TRANSGENDER_FLAG , "🏳\u{fe0f}\u{200d}⚧" => crate :: flags :: flag :: TRANSGENDER_FLAG , "🏳\u{200d}⚧" => crate :: flags :: flag :: TRANSGENDER_FLAG , "🏴\u{200d}☠\u{fe0f}" => crate :: flags :: flag :: PIRATE_FLAG , "🏴\u{200d}☠" => crate :: flags :: flag :: PIRATE_FLAG , "🇦🇨" => crate :: flags :: country_flag :: FLAG_ASCENSION_ISLAND , "🇦🇩" => crate :: flags :: country_flag :: FLAG_ANDORRA , "🇦🇪" => crate :: flags :: country_flag :: FLAG_UNITED_ARAB_EMIRATES , "🇦🇫" => crate :: flags :: country_flag :: FLAG_AFGHANISTAN , "🇦🇬" => crate :: flags :: country_flag :: FLAG_ANTIGUA_AND_BARBUDA , "🇦🇮" => crate :: flags :: country_flag :: FLAG_ANGUILLA , "🇦🇱" => crate :: flags :: country_flag :: FLAG_ALBANIA , "🇦🇲" => crate :: flags :: country_flag :: FLAG_ARMENIA , "🇦🇴" => crate :: flags :: country_flag :: FLAG_ANGOLA , "🇦🇶" => crate :: flags :: country_flag :: FLAG_ANTARCTICA , "🇦🇷" => crate :: flags :: country_flag :: FLAG_ARGENTINA , "🇦🇸" => crate :: flags :: country_flag :: FLAG_AMERICAN_SAMOA , "🇦🇹" => crate :: flags :: country_flag :: FLAG_AUSTRIA , "🇦🇺" => crate :: flags :: country_flag :: FLAG_AUSTRALIA , "🇦🇼" => crate :: flags :: country_flag :: FLAG_ARUBA , "🇦🇽" => crate :: flags :: country_flag :: FLAG_ALAND_ISLANDS , "🇦🇿" => crate :: flags :: country_flag :: FLAG_AZERBAIJAN , "🇧🇦" => crate :: flags :: country_flag :: FLAG_BOSNIA_AND_HERZEGOVINA , "🇧🇧" => crate :: flags :: country_flag :: FLAG_BARBADOS , "🇧🇩" => crate :: flags :: country_flag :: FLAG_BANGLADESH , "🇧🇪" => crate :: flags :: country_flag :: FLAG_BELGIUM , "🇧🇫" => crate :: flags :: country_flag :: FLAG_BURKINA_FASO , "🇧🇬" => crate :: flags :: country_flag :: FLAG_BULGARIA , "🇧🇭" => crate :: flags :: country_flag :: FLAG_BAHRAIN , "🇧🇮" => crate :: flags :: country_flag :: FLAG_BURUNDI , "🇧🇯" => crate :: flags :: country_flag :: FLAG_BENIN , "🇧🇱" => crate :: flags :: country_flag :: FLAG_ST_BARTHELEMY , "🇧🇲" => crate :: flags :: country_flag :: FLAG_BERMUDA , "🇧🇳" => crate :: flags :: country_flag :: FLAG_BRUNEI , "🇧🇴" => crate :: flags :: country_flag :: FLAG_BOLIVIA , "🇧🇶" => crate :: flags :: country_flag :: FLAG_CARIBBEAN_NETHERLANDS , "🇧🇷" => crate :: flags :: country_flag :: FLAG_BRAZIL , "🇧🇸" => crate :: flags :: country_flag :: FLAG_BAHAMAS , "🇧🇹" => crate :: flags :: country_flag :: FLAG_BHUTAN , "🇧🇻" => crate :: flags :: country_flag :: FLAG_BOUVET_ISLAND , "🇧🇼" => crate :: flags :: country_flag :: FLAG_BOTSWANA , "🇧🇾" => crate :: flags :: country_flag :: FLAG_BELARUS , "🇧🇿" => crate :: flags :: country_flag :: FLAG_BELIZE , "🇨🇦" => crate :: flags :: country_flag :: FLAG_CANADA , "🇨🇨" => crate :: flags :: country_flag :: FLAG_COCOS_KEELING_ISLANDS , "🇨🇩" => crate :: flags :: country_flag :: FLAG_CONGO___KINSHASA , "🇨🇫" => crate :: flags :: country_flag :: FLAG_CENTRAL_AFRICAN_REPUBLIC , "🇨🇬" => crate :: flags :: country_flag :: FLAG_CONGO___BRAZZAVILLE , "🇨🇭" => crate :: flags :: country_flag :: FLAG_SWITZERLAND , "🇨🇮" => crate :: flags :: country_flag :: FLAG_COTE_DIVOIRE , "🇨🇰" => crate :: flags :: country_flag :: FLAG_COOK_ISLANDS , "🇨🇱" => crate :: flags :: country_flag :: FLAG_CHILE , "🇨🇲" => crate :: flags :: country_flag :: FLAG_CAMEROON , "🇨🇳" => crate :: flags :: country_flag :: FLAG_CHINA , "🇨🇴" => crate :: flags :: country_flag :: FLAG_COLOMBIA , "🇨🇵" => crate :: flags :: country_flag :: FLAG_CLIPPERTON_ISLAND , "🇨🇷" => crate :: flags :: country_flag :: FLAG_COSTA_RICA , "🇨🇺" => crate :: flags :: country_flag :: FLAG_CUBA , "🇨🇻" => crate :: flags :: country_flag :: FLAG_CAPE_VERDE , "🇨🇼" => crate :: flags :: country_flag :: FLAG_CURACAO , "🇨🇽" => crate :: flags :: country_flag :: FLAG_CHRISTMAS_ISLAND , "🇨🇾" => crate :: flags :: country_flag :: FLAG_CYPRUS , "🇨🇿" => crate :: flags :: country_flag :: FLAG_CZECHIA , "🇩🇪" => crate :: flags :: country_flag :: FLAG_GERMANY , "🇩🇬" => crate :: flags :: country_flag :: FLAG_DIEGO_GARCIA , "🇩🇯" => crate :: flags :: country_flag :: FLAG_DJIBOUTI , "🇩🇰" => crate :: flags :: country_flag :: FLAG_DENMARK , "🇩🇲" => crate :: flags :: country_flag :: FLAG_DOMINICA , "🇩🇴" => crate :: flags :: country_flag :: FLAG_DOMINICAN_REPUBLIC , "🇩🇿" => crate :: flags :: country_flag :: FLAG_ALGERIA , "🇪🇦" => crate :: flags :: country_flag :: FLAG_CEUTA_AND_MELILLA , "🇪🇨" => crate :: flags :: country_flag :: FLAG_ECUADOR , "🇪🇪" => crate :: flags :: country_flag :: FLAG_ESTONIA , "🇪🇬" => crate :: flags :: country_flag :: FLAG_EGYPT , "🇪🇭" => crate :: flags :: country_flag :: FLAG_WESTERN_SAHARA , "🇪🇷" => crate :: flags :: country_flag :: FLAG_ERITREA , "🇪🇸" => crate :: flags :: country_flag :: FLAG_SPAIN , "🇪🇹" => crate :: flags :: country_flag :: FLAG_ETHIOPIA , "🇪🇺" => crate :: flags :: country_flag :: FLAG_EUROPEAN_UNION , "🇫🇮" => crate :: flags :: country_flag :: FLAG_FINLAND , "🇫🇯" => crate :: flags :: country_flag :: FLAG_FIJI , "🇫🇰" => crate :: flags :: country_flag :: FLAG_FALKLAND_ISLANDS , "🇫🇲" => crate :: flags :: country_flag :: FLAG_MICRONESIA , "🇫🇴" => crate :: flags :: country_flag :: FLAG_FAROE_ISLANDS , "🇫🇷" => crate :: flags :: country_flag :: FLAG_FRANCE , "🇬🇦" => crate :: flags :: country_flag :: FLAG_GABON , "🇬🇧" => crate :: flags :: country_flag :: FLAG_UNITED_KINGDOM , "🇬🇩" => crate :: flags :: country_flag :: FLAG_GRENADA , "🇬🇪" => crate :: flags :: country_flag :: FLAG_GEORGIA , "🇬🇫" => crate :: flags :: country_flag :: FLAG_FRENCH_GUIANA , "🇬🇬" => crate :: flags :: country_flag :: FLAG_GUERNSEY , "🇬🇭" => crate :: flags :: country_flag :: FLAG_GHANA , "🇬🇮" => crate :: flags :: country_flag :: FLAG_GIBRALTAR , "🇬🇱" => crate :: flags :: country_flag :: FLAG_GREENLAND , "🇬🇲" => crate :: flags :: country_flag :: FLAG_GAMBIA , "🇬🇳" => crate :: flags :: country_flag :: FLAG_GUINEA , "🇬🇵" => crate :: flags :: country_flag :: FLAG_GUADELOUPE , "🇬🇶" => crate :: flags :: country_flag :: FLAG_EQUATORIAL_GUINEA , "🇬🇷" => crate :: flags :: country_flag :: FLAG_GREECE , "🇬🇸" => crate :: flags :: country_flag :: FLAG_SOUTH_GEORGIA_AND_SOUTH_SANDWICH_ISLANDS , "🇬🇹" => crate :: flags :: country_flag :: FLAG_GUATEMALA , "🇬🇺" => crate :: flags :: country_flag :: FLAG_GUAM , "🇬🇼" => crate :: flags :: country_flag :: FLAG_GUINEA_BISSAU , "🇬🇾" => crate :: flags :: country_flag :: FLAG_GUYANA , "🇭🇰" => crate :: flags :: country_flag :: FLAG_HONG_KONG_SAR_CHINA , "🇭🇲" => crate :: flags :: country_flag :: FLAG_HEARD_AND_MCDONALD_ISLANDS , "🇭🇳" => crate :: flags :: country_flag :: FLAG_HONDURAS , "🇭🇷" => crate :: flags :: country_flag :: FLAG_CROATIA , "🇭🇹" => crate :: flags :: country_flag :: FLAG_HAITI , "🇭🇺" => crate :: flags :: country_flag :: FLAG_HUNGARY , "🇮🇨" => crate :: flags :: country_flag :: FLAG_CANARY_ISLANDS , "🇮🇩" => crate :: flags :: country_flag :: FLAG_INDONESIA , "🇮🇪" => crate :: flags :: country_flag :: FLAG_IRELAND , "🇮🇱" => crate :: flags :: country_flag :: FLAG_ISRAEL , "🇮🇲" => crate :: flags :: country_flag :: FLAG_ISLE_OF_MAN , "🇮🇳" => crate :: flags :: country_flag :: FLAG_INDIA , "🇮🇴" => crate :: flags :: country_flag :: FLAG_BRITISH_INDIAN_OCEAN_TERRITORY , "🇮🇶" => crate :: flags :: country_flag :: FLAG_IRAQ , "🇮🇷" => crate :: flags :: country_flag :: FLAG_IRAN , "🇮🇸" => crate :: flags :: country_flag :: FLAG_ICELAND , "🇮🇹" => crate :: flags :: country_flag :: FLAG_ITALY , "🇯🇪" => crate :: flags :: country_flag :: FLAG_JERSEY , "🇯🇲" => crate :: flags :: country_flag :: FLAG_JAMAICA , "🇯🇴" => crate :: flags :: country_flag :: FLAG_JORDAN , "🇯🇵" => crate :: flags :: country_flag :: FLAG_JAPAN , "🇰🇪" => crate :: flags :: country_flag :: FLAG_KENYA , "🇰🇬" => crate :: flags :: country_flag :: FLAG_KYRGYZSTAN , "🇰🇭" => crate :: flags :: country_flag :: FLAG_CAMBODIA , "🇰🇮" => crate :: flags :: country_flag :: FLAG_KIRIBATI , "🇰🇲" => crate :: flags :: country_flag :: FLAG_COMOROS , "🇰🇳" => crate :: flags :: country_flag :: FLAG_ST_KITTS_AND_NEVIS , "🇰🇵" => crate :: flags :: country_flag :: FLAG_NORTH_KOREA , "🇰🇷" => crate :: flags :: country_flag :: FLAG_SOUTH_KOREA , "🇰🇼" => crate :: flags :: country_flag :: FLAG_KUWAIT , "🇰🇾" => crate :: flags :: country_flag :: FLAG_CAYMAN_ISLANDS , "🇰🇿" => crate :: flags :: country_flag :: FLAG_KAZAKHSTAN , "🇱🇦" => crate :: flags :: country_flag :: FLAG_LAOS , "🇱🇧" => crate :: flags :: country_flag :: FLAG_LEBANON , "🇱🇨" => crate :: flags :: country_flag :: FLAG_ST_LUCIA , "🇱🇮" => crate :: flags :: country_flag :: FLAG_LIECHTENSTEIN , "🇱🇰" => crate :: flags :: country_flag :: FLAG_SRI_LANKA , "🇱🇷" => crate :: flags :: country_flag :: FLAG_LIBERIA , "🇱🇸" => crate :: flags :: country_flag :: FLAG_LESOTHO , "🇱🇹" => crate :: flags :: country_flag :: FLAG_LITHUANIA , "🇱🇺" => crate :: flags :: country_flag :: FLAG_LUXEMBOURG , "🇱🇻" => crate :: flags :: country_flag :: FLAG_LATVIA , "🇱🇾" => crate :: flags :: country_flag :: FLAG_LIBYA , "🇲🇦" => crate :: flags :: country_flag :: FLAG_MOROCCO , "🇲🇨" => crate :: flags :: country_flag :: FLAG_MONACO , "🇲🇩" => crate :: flags :: country_flag :: FLAG_MOLDOVA , "🇲🇪" => crate :: flags :: country_flag :: FLAG_MONTENEGRO , "🇲🇫" => crate :: flags :: country_flag :: FLAG_ST_MARTIN , "🇲🇬" => crate :: flags :: country_flag :: FLAG_MADAGASCAR , "🇲🇭" => crate :: flags :: country_flag :: FLAG_MARSHALL_ISLANDS , "🇲🇰" => crate :: flags :: country_flag :: FLAG_NORTH_MACEDONIA , "🇲🇱" => crate :: flags :: country_flag :: FLAG_MALI , "🇲🇲" => crate :: flags :: country_flag :: FLAG_MYANMAR_BURMA , "🇲🇳" => crate :: flags :: country_flag :: FLAG_MONGOLIA , "🇲🇴" => crate :: flags :: country_flag :: FLAG_MACAO_SAR_CHINA , "🇲🇵" => crate :: flags :: country_flag :: FLAG_NORTHERN_MARIANA_ISLANDS , "🇲🇶" => crate :: flags :: country_flag :: FLAG_MARTINIQUE , "🇲🇷" => crate :: flags :: country_flag :: FLAG_MAURITANIA , "🇲🇸" => crate :: flags :: country_flag :: FLAG_MONTSERRAT , "🇲🇹" => crate :: flags :: country_flag :: FLAG_MALTA , "🇲🇺" => crate :: flags :: country_flag :: FLAG_MAURITIUS , "🇲🇻" => crate :: flags :: country_flag :: FLAG_MALDIVES , "🇲🇼" => crate :: flags :: country_flag :: FLAG_MALAWI , "🇲🇽" => crate :: flags :: country_flag :: FLAG_MEXICO , "🇲🇾" => crate :: flags :: country_flag :: FLAG_MALAYSIA , "🇲🇿" => crate :: flags :: country_flag :: FLAG_MOZAMBIQUE , "🇳🇦" => crate :: flags :: country_flag :: FLAG_NAMIBIA , "🇳🇨" => crate :: flags :: country_flag :: FLAG_NEW_CALEDONIA , "🇳🇪" => crate :: flags :: country_flag :: FLAG_NIGER , "🇳🇫" => crate :: flags :: country_flag :: FLAG_NORFOLK_ISLAND , "🇳🇬" => crate :: flags :: country_flag :: FLAG_NIGERIA , "🇳🇮" => crate :: flags :: country_flag :: FLAG_NICARAGUA , "🇳🇱" => crate :: flags :: country_flag :: FLAG_NETHERLANDS , "🇳🇴" => crate :: flags :: country_flag :: FLAG_NORWAY , "🇳🇵" => crate :: flags :: country_flag :: FLAG_NEPAL , "🇳🇷" => crate :: flags :: country_flag :: FLAG_NAURU , "🇳🇺" => crate :: flags :: country_flag :: FLAG_NIUE , "🇳🇿" => crate :: flags :: country_flag :: FLAG_NEW_ZEALAND , "🇴🇲" => crate :: flags :: country_flag :: FLAG_OMAN , "🇵🇦" => crate :: flags :: country_flag :: FLAG_PANAMA , "🇵🇪" => crate :: flags :: country_flag :: FLAG_PERU , "🇵🇫" => crate :: flags :: country_flag :: FLAG_FRENCH_POLYNESIA , "🇵🇬" => crate :: flags :: country_flag :: FLAG_PAPUA_NEW_GUINEA , "🇵🇭" => crate :: flags :: country_flag :: FLAG_PHILIPPINES , "🇵🇰" => crate :: flags :: country_flag :: FLAG_PAKISTAN , "🇵🇱" => crate :: flags :: country_flag :: FLAG_POLAND , "🇵🇲" => crate :: flags :: country_flag :: FLAG_ST_PIERRE_AND_MIQUELON , "🇵🇳" => crate :: flags :: country_flag :: FLAG_PITCAIRN_ISLANDS , "🇵🇷" => crate :: flags :: country_flag :: FLAG_PUERTO_RICO , "🇵🇸" => crate :: flags :: country_flag :: FLAG_PALESTINIAN_TERRITORIES , "🇵🇹" => crate :: flags :: country_flag :: FLAG_PORTUGAL , "🇵🇼" => crate :: flags :: country_flag :: FLAG_PALAU , "🇵🇾" => crate :: flags :: country_flag :: FLAG_PARAGUAY , "🇶🇦" => crate :: flags :: country_flag :: FLAG_QATAR , "🇷🇪" => crate :: flags :: country_flag :: FLAG_REUNION , "🇷🇴" => crate :: flags :: country_flag :: FLAG_ROMANIA , "🇷🇸" => crate :: flags :: country_flag :: FLAG_SERBIA , "🇷🇺" => crate :: flags :: country_flag :: FLAG_RUSSIA , "🇷🇼" => crate :: flags :: country_flag :: FLAG_RWANDA , "🇸🇦" => crate :: flags :: country_flag :: FLAG_SAUDI_ARABIA , "🇸🇧" => crate :: flags :: country_flag :: FLAG_SOLOMON_ISLANDS , "🇸🇨" => crate :: flags :: country_flag :: FLAG_SEYCHELLES , "🇸🇩" => crate :: flags :: country_flag :: FLAG_SUDAN , "🇸🇪" => crate :: flags :: country_flag :: FLAG_SWEDEN , "🇸🇬" => crate :: flags :: country_flag :: FLAG_SINGAPORE , "🇸🇭" => crate :: flags :: country_flag :: FLAG_ST_HELENA , "🇸🇮" => crate :: flags :: country_flag :: FLAG_SLOVENIA , "🇸🇯" => crate :: flags :: country_flag :: FLAG_SVALBARD_AND_JAN_MAYEN , "🇸🇰" => crate :: flags :: country_flag :: FLAG_SLOVAKIA , "🇸🇱" => crate :: flags :: country_flag :: FLAG_SIERRA_LEONE , "🇸🇲" => crate :: flags :: country_flag :: FLAG_SAN_MARINO , "🇸🇳" => crate :: flags :: country_flag :: FLAG_SENEGAL , "🇸🇴" => crate :: flags :: country_flag :: FLAG_SOMALIA , "🇸🇷" => crate :: flags :: country_flag :: FLAG_SURINAME , "🇸🇸" => crate :: flags :: country_flag :: FLAG_SOUTH_SUDAN , "🇸🇹" => crate :: flags :: country_flag :: FLAG_SAO_TOME_AND_PRINCIPE , "🇸🇻" => crate :: flags :: country_flag :: FLAG_EL_SALVADOR , "🇸🇽" => crate :: flags :: country_flag :: FLAG_SINT_MAARTEN , "🇸🇾" => crate :: flags :: country_flag :: FLAG_SYRIA , "🇸🇿" => crate :: flags :: country_flag :: FLAG_ESWATINI , "🇹🇦" => crate :: flags :: country_flag :: FLAG_TRISTAN_DA_CUNHA , "🇹🇨" => crate :: flags :: country_flag :: FLAG_TURKS_AND_CAICOS_ISLANDS , "🇹🇩" => crate :: flags :: country_flag :: FLAG_CHAD , "🇹🇫" => crate :: flags :: country_flag :: FLAG_FRENCH_SOUTHERN_TERRITORIES , "🇹🇬" => crate :: flags :: country_flag :: FLAG_TOGO , "🇹🇭" => crate :: flags :: country_flag :: FLAG_THAILAND , "🇹🇯" => crate :: flags :: country_flag :: FLAG_TAJIKISTAN , "🇹🇰" => crate :: flags :: country_flag :: FLAG_TOKELAU , "🇹🇱" => crate :: flags :: country_flag :: FLAG_TIMOR_LESTE , "🇹🇲" => crate :: flags :: country_flag :: FLAG_TURKMENISTAN , "🇹🇳" => crate :: flags :: country_flag :: FLAG_TUNISIA , "🇹🇴" => crate :: flags :: country_flag :: FLAG_TONGA , "🇹🇷" => crate :: flags :: country_flag :: FLAG_TURKEY , "🇹🇹" => crate :: flags :: country_flag :: FLAG_TRINIDAD_AND_TOBAGO , "🇹🇻" => crate :: flags :: country_flag :: FLAG_TUVALU , "🇹🇼" => crate :: flags :: country_flag :: FLAG_TAIWAN , "🇹🇿" => crate :: flags :: country_flag :: FLAG_TANZANIA , "🇺🇦" => crate :: flags :: country_flag :: FLAG_UKRAINE , "🇺🇬" => crate :: flags :: country_flag :: FLAG_UGANDA , "🇺🇲" => crate :: flags :: country_flag :: FLAG_US_OUTLYING_ISLANDS , "🇺🇳" => crate :: flags :: country_flag :: FLAG_UNITED_NATIONS , "🇺🇸" => crate :: flags :: country_flag :: FLAG_UNITED_STATES , "🇺🇾" => crate :: flags :: country_flag :: FLAG_URUGUAY , "🇺🇿" => crate :: flags :: country_flag :: FLAG_UZBEKISTAN , "🇻🇦" => crate :: flags :: country_flag :: FLAG_VATICAN_CITY , "🇻🇨" => crate :: flags :: country_flag :: FLAG_ST_VINCENT_AND_GRENADINES , "🇻🇪" => crate :: flags :: country_flag :: FLAG_VENEZUELA , "🇻🇬" => crate :: flags :: country_flag :: FLAG_BRITISH_VIRGIN_ISLANDS , "🇻🇮" => crate :: flags :: country_flag :: FLAG_US_VIRGIN_ISLANDS , "🇻🇳" => crate :: flags :: country_flag :: FLAG_VIETNAM , "🇻🇺" => crate :: flags :: country_flag :: FLAG_VANUATU , "🇼🇫" => crate :: flags :: country_flag :: FLAG_WALLIS_AND_FUTUNA , "🇼🇸" => crate :: flags :: country_flag :: FLAG_SAMOA , "🇽🇰" => crate :: flags :: country_flag :: FLAG_KOSOVO , "🇾🇪" => crate :: flags :: country_flag :: FLAG_YEMEN , "🇾🇹" => crate :: flags :: country_flag :: FLAG_MAYOTTE , "🇿🇦" => crate :: flags :: country_flag :: FLAG_SOUTH_AFRICA , "🇿🇲" => crate :: flags :: country_flag :: FLAG_ZAMBIA , "🇿🇼" => crate :: flags :: country_flag :: FLAG_ZIMBABWE , "🏴\u{e0067}\u{e0062}\u{e0065}\u{e006e}\u{e0067}\u{e007f}" => crate :: flags :: subdivision_flag :: FLAG_ENGLAND , "🏴\u{e0067}\u{e0062}\u{e0073}\u{e0063}\u{e0074}\u{e007f}" => crate :: flags :: subdivision_flag :: FLAG_SCOTLAND , "🏴\u{e0067}\u{e0062}\u{e0077}\u{e006c}\u{e0073}\u{e007f}" => crate :: flags :: subdivision_flag :: FLAG_WALES };
