#[doc = "🥑"]
pub const AVOCADO: crate::Emoji = crate::Emoji {
    glyph: "🥑",
    codepoint: "1F951",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "avocado",
    group: "Food & Drink",
    subgroup: "food-vegetable",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("avokado"),
            keywords: &["avokado", "kos", "vrug"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አቦካዶ"),
            keywords: &["ምግብ", "አቦካዶ", "ፍራፍሬ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("أفوكادو"),
            keywords: &["أفوكادو", "طعام", "فاكهة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("এভোক\u{9be}ডো"),
            keywords: &["এভোক\u{9be}ডো", "খ\u{9be}দ\u{9cd}য", "ফল"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("avokado"),
            keywords: &["avokado", "meyvə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("авакада"),
            keywords: &["авакада", "садавіна", "фрукт"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("авокадо"),
            keywords: &["авокадо", "плод", "храна"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("অ\u{9cd}য\u{9be}ভোক\u{9cd}য\u{9be}ডো"),
            keywords: &[
                "অ\u{9cd}য\u{9be}ভোক\u{9cd}য\u{9be}ডো",
                "খ\u{9be}ব\u{9be}র",
                "ফল",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("avoukez"),
            keywords: &["avoukez", "frouezh", "legumaj"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("avokado"),
            keywords: &["avokado", "hrana", "voće"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("alvocat"),
            keywords: &["alvocat", "fruita", "menjar"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄆𑄝𑄇𑄘\u{1112e}"),
            keywords: &["𑄆𑄝𑄇𑄘\u{1112e}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏧᎳᏍᎩ ᎤᏪᏥ"),
            keywords: &["ᎠᎵᏍᏓᏴᏗ", "ᎤᏓᏔᏅᎢ", "ᏧᎳᏍᎩ ᎤᏪᏥ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("avokádo"),
            keywords: &["avokádo", "jídlo", "ovoce"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("afocado"),
            keywords: &["afocado", "bwyd", "ffrwyth"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("avokado"),
            keywords: &["avocado", "avokado", "frugt", "mad"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Avocado"),
            keywords: &["Avocado", "Frucht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αβοκάντο"),
            keywords: &["αβοκάντο", "τροφή", "φρούτο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("avocado"),
            keywords: &["avocado", "food", "fruit"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("aguacate"),
            keywords: &["aguacate", "comida", "fruta"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("palta"),
            keywords: &["comida", "fruta", "palta"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("aguacate"),
            keywords: &["aguacate"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("aguacate"),
            keywords: &["aguacate", "comida", "fruta"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("avokaado"),
            keywords: &["avokaado", "puuvili", "toit"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ahuakatea"),
            keywords: &["ahuakate", "ahuakatea", "fruitu", "janari"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("آووکادو"),
            keywords: &["آووکادو", "خوراکی", "غذا", "میوه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("avokado"),
            keywords: &["avokado", "hedelmä", "ruoka"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("abokado"),
            keywords: &["abokado", "pagkain", "prutas"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("avokado"),
            keywords: &["avokado", "frukt"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("avocat"),
            keywords: &["avocat", "fruit"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("abhacád"),
            keywords: &["abhacád", "bia", "toradh"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("abhocado"),
            keywords: &["abhocado", "biadh", "meas"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("aguacate"),
            keywords: &["aguacate", "comida", "froita"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઍવકાડો"),
            keywords: &["ઍવકાડો", "ફળ", "ભોજન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("avocado"),
            keywords: &["abinci", "avocade", "avocado", "ɗan itace"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אבוקדו"),
            keywords: &["אבוקדו", "אוכל", "פרי"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("अवोकाडो"),
            keywords: &["अवोकाडो", "फल", "भोजन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("avokado"),
            keywords: &["avokado", "hrana", "voće"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("avokádó"),
            keywords: &["avokádó", "gyümölcs", "étel"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ավոկադո"),
            keywords: &["ավոկադո", "միրգ", "ուտելիք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("alpukat"),
            keywords: &["alpukat", "alpuket", "avokad", "avokado", "buah", "makanan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ube bèkee"),
            keywords: &["mkpụrụosisi", "nri", "ube bèkee"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("avókadó"),
            keywords: &["avókadó", "grænmeti", "matur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("avocado"),
            keywords: &["avocado", "cibo", "frutta"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("アボカド"),
            keywords: &["アボカド", "果物", "野菜"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("avokad"),
            keywords: &["avokad", "pangan", "woh-wohan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ავოკადო"),
            keywords: &["ავოკადო", "საკვები", "ხილი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tavukatt"),
            keywords: &["tavukatt"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("авокадо"),
            keywords: &["авокадо", "тағам"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("avokado"),
            keywords: &["avokado", "frugt", "mad"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ផ\u{17d2}លែប\u{17ca}\u{17ba}"),
            keywords: &[
                "ប\u{17ca}\u{17ba}រ",
                "ផ\u{17d2}លែឈើ",
                "ផ\u{17d2}លែប\u{17ca}\u{17ba}",
                "អាហារ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಅವಕಾಡೋ"),
            keywords: &["ಅವಕಾಡೋ", "ಆಹಾರ", "ಹಣ\u{ccd}ಣು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("아보카도"),
            keywords: &["과일", "식품", "아보카도", "아보카드", "열매"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("अवोकाडो"),
            keywords: &["अन\u{94d}न", "अवोकाडो", "फळ"],
        },
        #[cfg(feature = "ku")]
        crate::Annotation {
            lang: "ku",
            tts: Some("avokado"),
            keywords: &["avokado", "fêkî", "xwarin"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("авокадо"),
            keywords: &["авокадо", "мөмө-жемиш", "тамак"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Avocado"),
            keywords: &["Avocado", "Fruucht", "Iessen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ອະໂວຄາໂດ"),
            keywords: &["ອະໂວຄາໂດ", "ອາຫານ", "ໝາກໄມ\u{ec9}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("avokadas"),
            keywords: &["avokadas", "maistas", "vaisius"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("avokado"),
            keywords: &["auglis", "avokado", "pārtika"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("awakāro"),
            keywords: &["awakāro", "huarākau", "kai"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("авокадо"),
            keywords: &["авокадо", "овошје", "храна"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വെണ\u{d4d}ണപ\u{d4d}പഴം"),
            keywords: &["പഴം", "ഭക\u{d4d}ഷണം", "വെണ\u{d4d}ണപ\u{d4d}പഴം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("авокадо"),
            keywords: &["авокадо", "жимс", "хүнс"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("अ\u{945}व\u{94d}होक\u{945}डो"),
            keywords: &["अ\u{945}व\u{94d}होक\u{945}डो", "खाद\u{94d}य", "फळ"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("avokado"),
            keywords: &["avokado", "buah", "makanan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("avokado"),
            keywords: &["avokado", "frott", "ikel"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ထောပတ\u{103a}သ\u{102e}း"),
            keywords: &[
                "ထောပတ\u{103a}သ\u{102e}း",
                "သစ\u{103a}သ\u{102e}း",
                "အစားအသောက\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("avokado"),
            keywords: &["avokado", "frukt", "mat"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("अभोकाडो"),
            keywords: &["अभोकाडो", "खाना", "फल"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("avocado"),
            keywords: &["avocado", "fruit", "voedsel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("avokado"),
            keywords: &["avokado", "frukt", "mat"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଆଭୋକ\u{b3e}ଡୋ"),
            keywords: &["ଆଭୋକ\u{b3e}ଡୋ", "ଆଭୋକ\u{b3e}ଡୋ । ଖ\u{b3e}ଦ\u{b4d}ୟ", "ଫଳ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਅਵ\u{a4b}ਕ\u{a48}ਡ\u{a4b}"),
            keywords: &["ਅਵ\u{a4b}ਕ\u{a48}ਡ\u{a4b}", "ਫਲ\u{a3c}", "ਭ\u{a4b}ਜਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مگر ناشپاتی"),
            keywords: &["خوراک", "مگر ناشپاتی", "پ\u{64e}ھل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ávokádo Pia"),
            keywords: &["Frut", "Fud", "Ávokádo Pia"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("awokado"),
            keywords: &["awokado", "jedzenie", "owoc"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پاپيته"),
            keywords: &["پاپيته", "پاپيته، خواړه، مېوه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("abacate"),
            keywords: &["abacate", "comida", "fruta"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["abacate", "fruta"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("palta"),
            keywords: &["mikhuna", "palta", "ruru"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("avocado"),
            keywords: &["avocado", "fruct", "mâncare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1069"),
            keywords: &["E10-1069"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("авокадо"),
            keywords: &["авокадо", "еда", "фрукт"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("avoka"),
            keywords: &["avoka", "ibiribwa", "urubuto", "voka"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مگر ناشپتي"),
            keywords: &["مگر ناشپتي", "مگر ناشپتي، ميوو، کاڌو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අල\u{dd2}ගැට පේර"),
            keywords: &["අල\u{dd2}ගැට පේර", "කෑම", "පළත\u{dd4}ර"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("avokádo"),
            keywords: &["avokádo", "jedlo", "ovocie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("avokado"),
            keywords: &["avokado", "hrana", "sadje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("afokaadho"),
            keywords: &["afokaadho", "cunto", "khudaar"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("avokado"),
            keywords: &["avokado", "frutë", "ushqim"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("авокадо"),
            keywords: &["авокадо", "воће", "храна"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("avokado"),
            keywords: &["avokado", "hrana", "voće"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("avokado"),
            keywords: &["avokado", "frukt", "mat"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("parachichi"),
            keywords: &["chakula", "matunda", "parachichi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வெண\u{bcd}ணைப\u{bcd} பழம\u{bcd}"),
            keywords: &[
                "உணவு",
                "பழம\u{bcd}",
                "வெண\u{bcd}ணைப\u{bcd} பழம\u{bcd}",
                "வெண\u{bcd}ணைப\u{bcd}பழம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("అవక\u{c3e}డ\u{c4b}"),
            keywords: &["అవక\u{c3e}డ\u{c4b}", "ఆహ\u{c3e}రం", "పండు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("авакадо"),
            keywords: &["авакадо", "мева", "ғизо"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("อาโวคาโด"),
            keywords: &["ผลไม\u{e49}", "อาหาร", "อาโวคาโด"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("awokado"),
            keywords: &["awokado", "iýmit", "miwe"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻāvoka"),
            keywords: &["ʻāvoka"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("avokado"),
            keywords: &["avokado", "meyve", "yiyecek"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاۋوكادو"),
            keywords: &["ئاۋوكادو", "مېۋە", "يېمەكلىك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("авокадо"),
            keywords: &["авокадо", "плід", "їжа"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ایوو کیڈو"),
            keywords: &["ایوو کیڈو", "خوراک", "پھل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("avokado"),
            keywords: &["avokado", "meva", "taom"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("quả bơ"),
            keywords: &["hoa quả", "quả bơ", "thức ăn"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("awokaa"),
            keywords: &["awokaa", "lekk", "meññeef"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-avocado"),
            keywords: &["i-avocado", "i-ocado", "isiqhamo", "ukutya"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Afokado"),
            keywords: &["Afokado", "afokádò", "èso", "ónjẹ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("牛油果"),
            keywords: &["牛油果", "生果", "食物"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("牛油果"),
            keywords: &["牛油果", "生果", "食物"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("鳄梨"),
            keywords: &["水果", "牛油果", "食物", "鳄梨"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("酪梨"),
            keywords: &["水果", "酪梨", "食物"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("牛油果"),
            keywords: &["牛油果"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukotapheya"),
            keywords: &["isithelo", "ukotapheya", "ukudla"],
        },
    ],
};
#[doc = "🍆"]
pub const EGGPLANT: crate::Emoji = crate::Emoji {
    glyph: "🍆",
    codepoint: "1F346",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "eggplant",
    group: "Food & Drink",
    subgroup: "food-vegetable",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("eiervrug"),
            keywords: &["brinjal", "eiervrug", "groente", "plant"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ኤግፕላንት ፍሬ"),
            keywords: &["ተክል", "አታክልት", "ኡበርጂን", "ኤግፕላንት ፍሬ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("باذنجان"),
            keywords: &["باذنجان", "خضار"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বেঙেন\u{9be}"),
            keywords: &["গছ", "প\u{9be}চলি", "বেঙেন\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("badımcan"),
            keywords: &["badımcan", "tərəvəz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("баклажан"),
            keywords: &["баклажан", "гародніна", "расліна"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("патладжан"),
            keywords: &["зеленчук", "патладжан", "растение"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বেগ\u{9c1}ন"),
            keywords: &["গ\u{9be}ছ", "বেগ\u{9c1}ন", "সব\u{9cd}জি"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("berjinez"),
            keywords: &["berjinez", "legumaj"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("patlidžan"),
            keywords: &["biljka", "patlidžan", "plavi", "povrće"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("albergínia"),
            keywords: &["albergínia", "hortalissa", "planta", "verdura"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄝𑄢\u{11133}𑄦\u{11127} 𑄟𑄌\u{11133}𑄠\u{11134} 𑄝\u{11128}𑄉\u{1112a}𑄚\u{11134}"),
            keywords: &[
                "𑄝𑄢\u{11133}𑄦\u{11127} 𑄟𑄌\u{11133}𑄠\u{11134} 𑄝\u{11128}𑄉\u{1112a}𑄚\u{11134}",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏪᏥᎦᎪᏗ"),
            keywords: &["ᎠᏓᎲᎵᎨ ᎠᏓᏛᏍᎩ", "ᎠᏫᏒᏅ ᎤᏛᏒ", "ᎤᏪᏥᎦᎪᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("lilek"),
            keywords: &["baklažán", "lilek", "rostlina", "zelenina"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ŵylyst"),
            keywords: &["llysieuyn", "ŵylyst"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("aubergine"),
            keywords: &["aubergine", "grøntsag"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Aubergine"),
            keywords: &["Aubergine", "Gemüse"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μελιτζάνα"),
            keywords: &["λαχανικό", "μελιτζάνα", "φυτό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("eggplant"),
            keywords: &["aubergine", "eggplant", "vegetable"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("aubergine"),
            keywords: &[""],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("eggplant"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("berenjena"),
            keywords: &["berenjena", "fruto", "verdura"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["berenjena", "planta", "vegetal", "verdura"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("baklažaan"),
            keywords: &["baklažaan", "köögivili", "taim"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("alberjinia"),
            keywords: &["alberjinia", "barazki", "landare"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بادمجان"),
            keywords: &["بادمجان", "سبزیجات", "گیاه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("munakoiso"),
            keywords: &["kasvi", "kasvis", "munakoiso", "vihannes"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("talong"),
            keywords: &["bunga", "eggplant", "gulay", "halaman", "talong"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("aubergina"),
            keywords: &["aubergina", "grønmeti"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("aubergine"),
            keywords: &["aubergine", "légume"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ubhthoradh"),
            keywords: &["glasra", "ubhthoradh"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aubergine"),
            keywords: &["aubergine", "glasraich"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("berenxena"),
            keywords: &["berenxena", "vexetal"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("રી\u{a82}ગણ, શાક"),
            keywords: &[
                "બ\u{ac7}\u{a82}ગન",
                "રી\u{a82}ગણ",
                "રી\u{a82}ગણ, શાક",
                "શાક",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("gauta"),
            keywords: &["abincin ganye", "aubergine", "gauta"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חציל"),
            keywords: &["חציל", "ירק"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ब\u{948}\u{902}गन"),
            keywords: &["ब\u{947}\u{902}गन", "ब\u{948}\u{902}गन", "सब\u{94d}जी"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("patlidžan"),
            keywords: &["biljka", "patlidžan", "povrće"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("padlizsán"),
            keywords: &["növény", "padlizsán", "zöldség"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սմբուկ"),
            keywords: &["բանջարեղեն", "բույս", "սմբուկ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("terung"),
            keywords: &["sayur", "tanaman", "terung"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("mkpụrụosisi ndịka akwa"),
            keywords: &[
                "akwụkwọnri",
                "mkpụrụosisi aubergine",
                "mkpụrụosisi ndịka akwa",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("eggaldin"),
            keywords: &["eggaldin", "grænmeti"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("melanzana"),
            keywords: &["melanzana", "verdura"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ナス"),
            keywords: &["ナス", "野菜"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("terong"),
            keywords: &["sayuran", "terong", "terung"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბადრიჯანი"),
            keywords: &["ბადრიჯანი", "ბოსტნეული", "მცენარე"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tapatengalt"),
            keywords: &["tapatengalt"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("баялды"),
            keywords: &["баялды", "көкөніс", "өсімдік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("aubergine"),
            keywords: &["aubergine", "grøntsag"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ត\u{17d2}រប\u{17cb}វែង"),
            keywords: &["ត\u{17d2}រប\u{17cb}វែង", "បន\u{17d2}លែ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬದನ\u{cc6}ಕಾಯ\u{cbf}"),
            keywords: &[
                "ಅಬರ\u{ccd}ಗ\u{cbf}ನ\u{ccd}",
                "ತರಕಾರ\u{cbf}",
                "ಬದನ\u{cc6}ಕಾಯ\u{cbf}",
                "ಬ\u{cbf}ಳ\u{cbf}ಬದನ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("가지"),
            keywords: &["가지", "야채", "채소"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("वाय\u{902}ग\u{947}\u{902}"),
            keywords: &["भाजी", "वाय\u{902}गण", "वाय\u{902}ग\u{947}\u{902}"],
        },
        #[cfg(feature = "ku")]
        crate::Annotation {
            lang: "ku",
            tts: Some("balîcan"),
            keywords: &["balîcan", "sebze"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("баклажан"),
            keywords: &["баклажан", "жашылча", "өсүмдүк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Aubergine"),
            keywords: &["Aubergine", "Geméis"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໝາກເຂ\u{eb7}ອ"),
            keywords: &["ຜ\u{eb1}ກ", "ພ\u{eb7}ດ", "ໝາກເຂ\u{eb7}ອ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("baklažanas"),
            keywords: &["augalas", "baklažanas", "daržovė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("baklažāns"),
            keywords: &["augs", "baklažāns", "dārzenis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("otahua"),
            keywords: &["huawhenua", "otahua"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("модар патлиџан"),
            keywords: &["зеленчук", "модар патлиџан", "растение"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വഴ\u{d41}തന"),
            keywords: &["പച\u{d4d}ചക\u{d4d}കറി", "വഴ\u{d41}തന"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хаш"),
            keywords: &["ногоо", "хаш"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("वा\u{902}गी"),
            keywords: &["उबदार", "भाजीपाला", "वा\u{902}गी", "वा\u{902}ग\u{947}"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("terung"),
            keywords: &["sayur-sayuran", "terung"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("brunġiela"),
            keywords: &["brunġiel", "brunġiela", "ħaxix"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ခရမ\u{103a}းသ\u{102e}း"),
            keywords: &[
                "ခရမ\u{103a}းသ\u{102e}း",
                "ဟင\u{103a}းသ\u{102e}းဟင\u{103a}းရ\u{103d}က\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("aubergine"),
            keywords: &["aubergine", "grønnsak"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("भ\u{94d}यान\u{94d}टा"),
            keywords: &["बिर\u{942}वा", "भ\u{94d}यान\u{94d}टा", "सागपात"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("aubergine"),
            keywords: &["aubergine", "groente"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("aubergine"),
            keywords: &["aubergine", "grønsak"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3e}ଇଗଣ"),
            keywords: &["ପନ\u{b3f}ପର\u{b3f}ବ\u{b3e}", "ବ\u{b3e}ଇଗଣ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a48}\u{a02}ਗਣ"),
            keywords: &[
                "ਬ\u{a48}\u{a02}ਗਣ",
                "ਬ\u{a48}\u{a02}ਗਣ ਦਾ ਬ\u{a42}ਟਾ",
                "ਸਬਜ\u{a3c}ੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بتوں"),
            keywords: &["بتوں", "بینگن دا بوٹا", "سبزیاں"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ẹ\u{301}gplant"),
            keywords: &["Obajin", "Vẹ\u{301}jítébul", "Ẹ\u{301}gplant"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("bakłażan"),
            keywords: &["bakłażan", "oberżyna", "warzywo"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("توربانجان"),
            keywords: &["تور بانجان، سبزي", "توربانجان"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("berinjela"),
            keywords: &["berinjela", "legume"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("beringela"),
            keywords: &["beringela", "legume"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("berenjena"),
            keywords: &["berenjena", "vegetal"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("vânătă"),
            keywords: &["legumă", "vânătă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-267"),
            keywords: &["E10-267"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("баклажан"),
            keywords: &["баклажан", "овощ", "синенькие", "синенький"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikibiringanya"),
            keywords: &["ikibiringanya", "imboga", "intoryi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("وانڱڻ"),
            keywords: &["وانڱڻ", "واڱڻ، ڀاڄي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වම\u{dca}බට\u{dd4}"),
            keywords: &["එළවළ\u{dd4}", "පැළය", "වම\u{dca}බට\u{dd4}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("baklažán"),
            keywords: &["baklažán", "rastlina", "zelenina", "ľuľok"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("jajčevec"),
            keywords: &["jajčevec", "rastlina", "zelenjava"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dhir ukun"),
            keywords: &["dhir ukun", "khudrad", "qajaar dibadeed"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("patëllxhan"),
            keywords: &["bimë", "patëllxhan", "perime"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("пaтлиџaн"),
            keywords: &["биљкa", "пaтлиџaн", "пoврћe"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("patlidžan"),
            keywords: &["biljka", "patlidžan", "povrće"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("aubergine"),
            keywords: &["aubergine", "grönsak", "äggplanta"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("biringanya"),
            keywords: &["biringanya", "mbogamboga", "mmea"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["biringanya", "mboga", "mmea"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கத\u{bcd}தரிக\u{bcd}க\u{bbe}ய\u{bcd}"),
            keywords: &[
                "உணவு",
                "கத\u{bcd}தரிக\u{bcd}க\u{bbe}ய\u{bcd}",
                "க\u{bbe}ய\u{bcd}கறி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వంగ చ\u{c46}ట\u{c4d}టు"),
            keywords: &["కూరగ\u{c3e}య", "వంక\u{c3e}య", "వంగ చ\u{c46}ట\u{c4d}టు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("бодимҷон"),
            keywords: &["бодимҷон", "бодинҷон", "сабзавот"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("มะเข\u{e37}อยาว"),
            keywords: &["ผ\u{e31}ก", "มะเข\u{e37}อยาว"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("badamjan"),
            keywords: &["badamjan", "gök önüm"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("paingani"),
            keywords: &["paingani"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("patlıcan"),
            keywords: &["patlıcan", "sebze"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("پىدىگەن"),
            keywords: &["كۆكتات", "پىدىگەن"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("баклажан"),
            keywords: &["баклажан", "овоч"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بینگن"),
            keywords: &["بینگن", "سبزی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("baqlajon"),
            keywords: &["baqlajon", "o‘simlik", "sabzavot"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cà tím"),
            keywords: &["cà tím", "rau", "thực vật"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("basante"),
            keywords: &["basante", "lujum"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-eggplant"),
            keywords: &["i-aubergine", "i-eggplant", "umfuno"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Igba"),
            keywords: &["Igba", "èso", "ìgbá"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("茄子"),
            keywords: &["茄子", "蔬菜"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("茄子"),
            keywords: &["茄子", "蔬菜"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("茄子"),
            keywords: &["茄子", "蔬菜"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("茄子"),
            keywords: &["茄子", "蔬菜"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("茄子"),
            keywords: &["矮瓜", "茄子", "蔬菜"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubrinjoli"),
            keywords: &["imifino", "isitshalo", "ubrinjoli"],
        },
    ],
};
#[doc = "🥔"]
pub const POTATO: crate::Emoji = crate::Emoji {
    glyph: "🥔",
    codepoint: "1F954",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "potato",
    group: "Food & Drink",
    subgroup: "food-vegetable",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("aartappel"),
            keywords: &["aartappel", "groente", "kos", "stysel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ድንች"),
            keywords: &["ምግብ", "አትክልት", "ድንች"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بطاطس"),
            keywords: &["بطاطس", "خضروات", "طعام"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("আল\u{9c1}"),
            keywords: &["আল\u{9c1}", "খ\u{9be}দ\u{9cd}য", "প\u{9be}চলি"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kartof"),
            keywords: &["kartof", "tərəvəz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("бульба"),
            keywords: &["бульба", "гародніна", "ежа"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("картоф"),
            keywords: &["зеленчук", "картоф", "храна"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("আল\u{9c1}"),
            keywords: &["আল\u{9c1}", "খ\u{9be}ব\u{9be}র", "সবজি"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("aval-douar"),
            keywords: &["aval-douar", "boued", "legumaj"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("krompir"),
            keywords: &["hrana", "krompir", "povrće"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("patata"),
            keywords: &["hortalissa", "menjar", "patata", "tubercle"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄃𑄣\u{1112a}"),
            keywords: &["𑄃𑄣\u{1112a}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏄᎾ"),
            keywords: &["ᎠᎵᏍᏓᏴᏗ", "ᎠᏫᏒᏅ ᎤᏛᏒᎢ", "ᏄᎾ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("brambor"),
            keywords: &["brambor", "brambora", "jídlo", "zelenina"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("taten"),
            keywords: &["bwyd", "llysieuyn", "taten"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kartoffel"),
            keywords: &["grøntsag", "kartoffel", "mad", "rodfrugt"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Kartoffel"),
            keywords: &["Essen", "Kartoffel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πατάτα"),
            keywords: &["λαχανικό", "πατάτα", "τροφή"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("potato"),
            keywords: &["food", "potato", "vegetable"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("patata"),
            keywords: &["comida", "papa", "patata", "verdura"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("papa"),
            keywords: &["comida", "papa", "patata", "vegetal"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kartul"),
            keywords: &["juurvili", "kartul", "toit"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("patata"),
            keywords: &["barazki", "janari", "patata"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("سیب زمینی"),
            keywords: &["سبزیجات", "سیب زمینی", "سیب\u{200c}زمینی", "غذا"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("peruna"),
            keywords: &["peruna", "ruoka", "vihannes"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("patatas"),
            keywords: &["gulay", "pagkain", "patatas"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("epli"),
            keywords: &["epli", "grønmeti"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("pomme de terre"),
            keywords: &["légume", "patate", "pomme de terre"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("práta"),
            keywords: &["bia", "glasra", "práta"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("buntàta"),
            keywords: &["biadh", "buntàta", "glasraich"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("pataca"),
            keywords: &["comida", "pataca", "vexetal"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બટાકો"),
            keywords: &["બટાકો", "ભોજન", "શાકભાજી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("dankali"),
            keywords: &["abinci", "dankali", "ganye"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("תפוח אדמה"),
            keywords: &["אוכל", "ארוחה", "תוספת", "תפוד", "תפוח אדמה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("आल\u{942}"),
            keywords: &["आल\u{942}", "भोजन", "सब\u{94d}जी"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("krumpir"),
            keywords: &["hrana", "krumpir", "povrće"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("krumpli"),
            keywords: &["krumpli", "zöldség", "étel"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կարտոֆիլ"),
            keywords: &["բանջարեղեն", "կարտոֆիլ", "ուտելիք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kentang"),
            keywords: &["kentang", "makanan", "sayur", "sayuran"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ji bèkee"),
            keywords: &["akwụkwọnri", "ji bèkee", "nri"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kartafla"),
            keywords: &["grænmeti", "kartafla", "matur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("patata"),
            keywords: &["cibo", "ortaggio", "patata", "tubero"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ジャガイモ"),
            keywords: &["イモ", "ジャガイモ", "ポテト", "野菜"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kenthang"),
            keywords: &["kenthang", "pangan", "sayuran"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კარტოფილი"),
            keywords: &["ბოსტნეული", "კარტოფილი", "საკვები"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tabaṭaṭatt"),
            keywords: &["tabaṭaṭatt"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("картоп"),
            keywords: &["картоп", "көкөніс", "тағам"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kartoffel"),
            keywords: &["grøntsag", "kartoffel", "mad", "rodfrugt"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ដ\u{17c6}ឡ\u{17bc}ង"),
            keywords: &["ដ\u{17c6}ឡ\u{17bc}ង", "បន\u{17d2}លែ", "អាហារ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಆಲ\u{cc2}ಗಡ\u{ccd}ಡ\u{cc6}"),
            keywords: &["ಆಲ\u{cc2}ಗಡ\u{ccd}ಡ\u{cc6}", "ಆಹಾರ", "ತರಕಾರ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("감자"),
            keywords: &["감자", "식품", "채소", "포테이토"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बटाट"),
            keywords: &["अन\u{94d}न", "बटाट", "भाजी"],
        },
        #[cfg(feature = "ku")]
        crate::Annotation {
            lang: "ku",
            tts: Some("kartol"),
            keywords: &["kartol"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("картөшкө"),
            keywords: &["жашылча", "картөшкө", "тамак"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Gromper"),
            keywords: &["Geméis", "Gromper", "Iessen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ມ\u{eb1}ນຝຣ\u{eb1}\u{ec8}ງ"),
            keywords: &["ຜ\u{eb1}ກ", "ມ\u{eb1}ນຝຣ\u{eb1}\u{ec8}ງ", "ອາຫານ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("bulvė"),
            keywords: &["bulvė", "daržovė", "maistas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kartupelis"),
            keywords: &["dārzenis", "kartupelis", "pārtika"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rīwai"),
            keywords: &["huawhenua", "kai", "rīwai"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("компир"),
            keywords: &["зеленчук", "компир", "храна"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഉര\u{d41}ളക\u{d4d}കിഴങ\u{d4d}ങ\u{d4d}"),
            keywords: &[
                "ഉര\u{d41}ളക\u{d4d}കിഴങ\u{d4d}ങ\u{d4d}",
                "പച\u{d4d}ചക\u{d4d}കറി",
                "ഭക\u{d4d}ഷണം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("төмс"),
            keywords: &["ногоо", "төмс", "хүнс"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("बटाट\u{947}"),
            keywords: &["खाद\u{94d}य", "बटाट\u{947}", "भाजीपाला"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("ubi kentang"),
            keywords: &["makanan", "sayur", "ubi kentang"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("patata"),
            keywords: &["ikel", "patata", "ħaxix"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အာလ\u{1030}း"),
            keywords: &[
                "အစားအသောက\u{103a}",
                "အသ\u{102e}းအန\u{103e}\u{1036}",
                "အာလ\u{1030}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("potet"),
            keywords: &["grønnsak", "mat", "potet"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("आल\u{941}"),
            keywords: &["आल\u{941}", "खाना", "तरकारी"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("aardappel"),
            keywords: &["aardappel", "groente", "voedsel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("potet"),
            keywords: &["grønsak", "mat", "potet"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଆଳ\u{b41}"),
            keywords: &[
                "ଆଳ\u{b41}",
                "ଆଳ\u{b41} । ପନ\u{b3f}ପର\u{b3f}ବ\u{b3e}",
                "ଖ\u{b3e}ଦ\u{b4d}ୟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਆਲ\u{a42}"),
            keywords: &["ਆਲ\u{a42}", "ਭ\u{a4b}ਜਨ", "ਸਬਜ\u{a3c}ੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("آلو"),
            keywords: &["آلو", "خوراک", "سبزی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Potéto"),
            keywords: &["Fud", "Potéto", "Vẹ\u{301}jítébul"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("ziemniak"),
            keywords: &["jedzenie", "kartofel", "warzywo", "ziemniak"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("آلو"),
            keywords: &["آلو", "خواړه، آلو، سبزي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("batata"),
            keywords: &["batata", "comida", "legume"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["batata", "legume"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("patata"),
            keywords: &["mikhuna", "patata", "vegetal"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cartof"),
            keywords: &["cartof", "cartofi", "legume", "mâncare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1072"),
            keywords: &["E10-1072"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("картофель"),
            keywords: &["еда", "картофель", "овощ"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikirayi"),
            keywords: &["ibiribwa", "ikirayi", "imboga"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پٽاٽو"),
            keywords: &["پٽاٽو", "پٽاٽو، ڀاڄي، کاڌو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අල"),
            keywords: &["අල", "එළවළ\u{dd4}", "කෑම"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zemiak"),
            keywords: &["jedlo", "zelenina", "zemiak"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("krompir"),
            keywords: &["hrana", "krompir", "zelenjava"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("baradha"),
            keywords: &["baradha", "cunto", "khudradda"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("patate"),
            keywords: &["patate", "perime", "ushqim"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кромпир"),
            keywords: &["кромпир", "поврће", "храна"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("krompir"),
            keywords: &["hrana", "krompir", "povrće"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("potatis"),
            keywords: &["grönsak", "mat", "potatis"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("viazi"),
            keywords: &["chakula", "mboga", "viazi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("உருளைக\u{bcd}கிழங\u{bcd}கு"),
            keywords: &[
                "உணவு",
                "உருளை",
                "உருளைக\u{bcd}கிழங\u{bcd}கு",
                "க\u{bbe}ய\u{bcd}கறி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బంగ\u{c3e}ళ\u{c3e}దుంప"),
            keywords: &["ఆహ\u{c3e}రం", "కూరగ\u{c3e}య", "బంగ\u{c3e}ళ\u{c3e}దుంప"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("картошка"),
            keywords: &["картошка", "сабзавот", "ғизо"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ม\u{e31}นฝร\u{e31}\u{e48}ง"),
            keywords: &[
                "ผ\u{e31}ก",
                "ม\u{e31}น",
                "ม\u{e31}นฝร\u{e31}\u{e48}ง",
                "อาหาร",
                "โปเตโต\u{e49}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýeralma"),
            keywords: &["gök önüm", "iýmit", "ýeralma"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pateta"),
            keywords: &["pateta"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("patates"),
            keywords: &["patates", "sebze", "yiyecek"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("بەرەڭگە"),
            keywords: &["بەرەڭگە", "كۆكتات", "يېمەكلىك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("картопля"),
            keywords: &["картопля", "овоч", "їжа"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("آلو"),
            keywords: &["آلو", "خوراک", "سبزی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kartoshka"),
            keywords: &["kartoshka", "sabzavot", "taom"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("khoai tây"),
            keywords: &["khoai tây", "thức ăn", "thực vật"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("pombiteer"),
            keywords: &["lujum", "meññeef", "pombiteer", "potaas"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("itapile"),
            keywords: &["imifuno", "itapile", "ukutya"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ànàmọ\u{301}"),
            keywords: &["Ànàmọ\u{301}", "ànàmọ\u{301}", "ónjẹ", "ẹ\u{300}fọ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("薯仔"),
            keywords: &["蔬菜", "薯仔", "食物"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("薯仔"),
            keywords: &["蔬菜", "薯仔", "食物"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("土豆"),
            keywords: &["土豆", "蔬菜", "食物", "马铃薯"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("馬鈴薯"),
            keywords: &["根莖類", "蔬菜", "食物", "馬鈴薯"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("薯仔"),
            keywords: &["蔬菜", "薯仔", "馬鈴薯"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("izambane"),
            keywords: &["isithelo", "izambane", "ukudla"],
        },
    ],
};
#[doc = "🥕"]
pub const CARROT: crate::Emoji = crate::Emoji {
    glyph: "🥕",
    codepoint: "1F955",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "carrot",
    group: "Food & Drink",
    subgroup: "food-vegetable",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("wortel"),
            keywords: &["groente", "kos", "wortel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ካሮት"),
            keywords: &["ምግብ", "አትክልት", "ካሮት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("جزر"),
            keywords: &["جزر", "خضروات", "طعام"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("গ\u{9be}জৰ"),
            keywords: &["খ\u{9be}দ\u{9cd}য", "গ\u{9be}জৰ", "প\u{9be}চলি"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kök"),
            keywords: &["kök", "tərəvəz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("морква"),
            keywords: &["гародніна", "ежа", "морква"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("морков"),
            keywords: &["зеленчук", "морков", "храна"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("গ\u{9be}জর"),
            keywords: &["খ\u{9be}ব\u{9be}র", "গ\u{9be}জর", "সবজি"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("karotez"),
            keywords: &["boued", "karotez", "legumaj"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("mrkva"),
            keywords: &["hrana", "mrkva", "povrće"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pastanaga"),
            keywords: &["hortalissa", "menjar", "pastanaga", "verdura"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄉𑄎\u{11127}𑄢\u{11134}"),
            keywords: &["𑄉𑄎\u{11127}𑄢\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏓᎶᏂᎨ ᎦᏢᏍᎩ"),
            keywords: &["ᎠᎵᏍᏓᏴᏗ", "ᎠᏫᏒᏅ ᎤᏛᏒᎢ", "ᏓᎶᏂᎨ ᎦᏢᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mrkev"),
            keywords: &["jídlo", "mrkev", "zelenina"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("moron"),
            keywords: &["bwyd", "llysieuyn", "moron"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("gulerod"),
            keywords: &["grøntsag", "gulerod", "mad", "rodfrugt"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Karotte"),
            keywords: &["Gemüse", "Karotte", "Mohrrübe", "Möhre"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καρότο"),
            keywords: &["καρότο", "λαχανικό", "τροφή"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("carrot"),
            keywords: &["carrot", "food", "vegetable"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("zanahoria"),
            keywords: &["comida", "verdura", "zanahoria"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["comida", "vegetal", "zanahoria"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("porgand"),
            keywords: &["juurvili", "porgand", "toit"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("azenarioa"),
            keywords: &["azenario", "azenarioa", "barazki", "janari"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("هویج"),
            keywords: &["سبزیجات", "غذا", "هویج"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("porkkana"),
            keywords: &["porkkana", "ruoka", "vihannes"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("carrot"),
            keywords: &["carrot", "gulay", "pagkain"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("gularót"),
            keywords: &["grønmeti", "gularót"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("carotte"),
            keywords: &["carotte", "légume"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("meacan dearg"),
            keywords: &["bia", "glasra", "meacan dearg"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("curran"),
            keywords: &["biadh", "curran", "glasraich"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cenoria"),
            keywords: &["cenoria", "comida", "vexetal"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ગાજર"),
            keywords: &["ગાજર", "ભોજન", "શાકભાજી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("karas"),
            keywords: &["abinci", "ganye", "karas"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גזר"),
            keywords: &["גזר", "ירק", "סלט"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("गाजर"),
            keywords: &["गाजर", "भोजन", "सब\u{94d}जी"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("mrkva"),
            keywords: &["hrana", "mrkva", "povrće"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("sárgarépa"),
            keywords: &["sárgarépa", "zöldség", "étel"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("գազար"),
            keywords: &["բանջարեղեն", "գազար", "ուտելիք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wortel"),
            keywords: &["makanan", "sayur", "wortel"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Karọt"),
            keywords: &["Karọt", "akwụkwọnri", "karọt", "nri"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("gulrót"),
            keywords: &["grænmeti", "gulrót", "matur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("carota"),
            keywords: &["carota", "cibo", "ortaggio", "radice"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("人参"),
            keywords: &["ニンジン", "人参", "野菜"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wortel"),
            keywords: &["pangan", "sayuran", "wortel"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სტაფილო"),
            keywords: &["ბოსტნეული", "საკვები", "სტაფილო"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("taẓrudgatt"),
            keywords: &["taẓrudgatt"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сәбіз"),
            keywords: &["көкөніс", "сәбіз", "тағам"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("gulerod"),
            keywords: &["grøntsag", "gulerod", "mad", "rodfrugt"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ការ\u{17c9}\u{17bb}ត"),
            keywords: &["ការ\u{17c9}\u{17bb}ត", "បន\u{17d2}លែ", "អាហារ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{ccd}ಯಾರ\u{cc6}ಟ\u{ccd}"),
            keywords: &["ಆಹಾರ", "ಕ\u{ccd}ಯಾರ\u{cc6}ಟ\u{ccd}", "ತರಕಾರ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("당근"),
            keywords: &["당근", "식품", "채소"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("गाजर"),
            keywords: &["अन\u{94d}न", "गाजर", "भाजी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("сабиз"),
            keywords: &["жашылча", "сабиз", "тамак"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Wuerzel"),
            keywords: &["Geméis", "Iessen", "Wuerzel"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແຄຣ\u{eb1}ອດ"),
            keywords: &["ຜ\u{eb1}ກ", "ອາຫານ", "ແຄຣ\u{eb1}ອດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("morka"),
            keywords: &["daržovė", "maistas", "morka"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("burkāns"),
            keywords: &["burkāns", "dārzenis", "pārtika"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kāroti"),
            keywords: &["huawhenua", "kai", "kāroti"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("морков"),
            keywords: &["зеленчук", "морков", "храна"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d4d}യ\u{d3e}രറ\u{d4d}റ\u{d4d}"),
            keywords: &[
                "ക\u{d4d}യ\u{d3e}രറ\u{d4d}റ\u{d4d}",
                "പച\u{d4d}ചക\u{d4d}കറി",
                "ഭക\u{d4d}ഷണം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("лууван"),
            keywords: &["лууван", "ногоо", "хүнс"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("गाजर"),
            keywords: &["खाद\u{94d}य", "गाजर", "भाजी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("lobak merah"),
            keywords: &["lobak merah", "makanan", "sayur"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("zunnerija"),
            keywords: &["ikel", "zunnerija", "ħaxix"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မ\u{102f}န\u{103a}လာဥ"),
            keywords: &[
                "မ\u{102f}န\u{103a}လာဥ",
                "အစားအသောက\u{103a}",
                "အသ\u{102e}းအန\u{103e}\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("gulrot"),
            keywords: &["grønnsak", "gulrot", "mat", "rot"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("गाजर"),
            keywords: &["खाना", "गाजर", "तरकारी"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("wortel"),
            keywords: &["groente", "voedsel", "wortel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("gulrot"),
            keywords: &["grønsak", "gulrot", "mat", "rot"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଗ\u{b3e}ଜର"),
            keywords: &[
                "ଖ\u{b3e}ଦ\u{b4d}ୟ । ପନ\u{b3f}ପର\u{b3f}ବ\u{b3e}",
                "ଗ\u{b3e}ଜର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਗਾਜਰ"),
            keywords: &["ਗਾਜਰ", "ਭ\u{a4b}ਜਨ", "ਸਬਜ\u{a3c}ੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("گاجر"),
            keywords: &["خوراک", "سبزیاں", "گاجر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kárọt"),
            keywords: &["Fud", "Kárọt", "Vẹ\u{301}jítébul"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("marchew"),
            keywords: &["jedzenie", "marchew", "marchewka", "warzywo"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("زردکه"),
            keywords: &["زردکه", "زردکه، خواړه، سبزي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cenoura"),
            keywords: &["cenoura", "comida", "legume"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["cenoura", "legume"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("zanahoria"),
            keywords: &["mikhuna", "vegetal", "zanahoria"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("morcov"),
            keywords: &["legume", "morcov", "mâncare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1073"),
            keywords: &["E10-1073"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("морковь"),
            keywords: &["еда", "морковка", "морковь", "овощ"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("karoti"),
            keywords: &["ibiribwa", "imboga", "karoti"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("گجر"),
            keywords: &["گجر", "گجر، ڀاڄي، کاڌو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කෑරට\u{dca}"),
            keywords: &["එළවළ\u{dd4}", "කෑම", "කෑරට\u{dca}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("mrkva"),
            keywords: &["jedlo", "mrkva", "zelenina"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("korenje"),
            keywords: &["hrana", "korenje", "zelenjava"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dabocase"),
            keywords: &["cunto", "dabocase", "khudrad"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("karotë"),
            keywords: &["karotë", "perime", "ushqim"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("шаргарепа"),
            keywords: &["поврће", "храна", "шаргарепа"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("мрква"),
            keywords: &["мрква"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("šargarepa"),
            keywords: &["hrana", "povrće", "šargarepa"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("mrkva"),
            keywords: &["mrkva"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("morot"),
            keywords: &["grönsak", "mat", "morot", "rotfrukt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("karoti"),
            keywords: &["chakula", "karoti", "mboga"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கேரட\u{bcd}"),
            keywords: &["உணவு", "க\u{bbe}ய\u{bcd}கறி", "கேரட\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c4d}య\u{c3e}ర\u{c46}ట\u{c4d}"),
            keywords: &[
                "ఆహ\u{c3e}రం",
                "కూరగ\u{c3e}య",
                "క\u{c4d}య\u{c3e}ర\u{c46}ట\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("сабзӣ"),
            keywords: &["сабзавот", "сабзӣ", "ғизо"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แครอท"),
            keywords: &["ผ\u{e31}ก", "อาหาร", "แครอท"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("käşir"),
            keywords: &["gök önüm", "iýmit", "käşir"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kāloti"),
            keywords: &["kāloti"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("havuç"),
            keywords: &["havuç", "sebze", "yiyecek"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سەۋزە"),
            keywords: &["سەۋزە", "كۆكتات", "يېمەكلىك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("морква"),
            keywords: &["морква", "морквина", "овоч", "їжа"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گاجر"),
            keywords: &["خوراک", "سبزی", "گاجر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("sabzi"),
            keywords: &["sabzavot", "sabzi", "taom"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cà rốt"),
            keywords: &["cà rốt", "thức ăn", "thực vật"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("karot"),
            keywords: &["karot", "lekk", "lujum"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umnqathe"),
            keywords: &["imifuno", "ukutya", "umnqathe"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Kárọ\u{300}tì"),
            keywords: &[
                "Kárọ\u{300}tì",
                "kárọ\u{301}tì",
                "ónjẹ",
                "ẹ\u{300}fọ\u{301}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("紅蘿蔔"),
            keywords: &["紅蘿蔔", "蔬菜", "食物"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("红萝卜"),
            keywords: &["红萝卜", "蔬菜", "食物"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("胡萝卜"),
            keywords: &["胡萝卜", "蔬菜", "食物"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("胡蘿蔔"),
            keywords: &["根莖類", "紅蘿蔔", "胡蘿蔔", "蔬菜", "食物"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("紅蘿蔔"),
            keywords: &["紅蘿蔔", "胡蘿蔔", "蔬菜", "蘿蔔"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukhalothi"),
            keywords: &["amaveji", "ukhalothi", "ukudla"],
        },
    ],
};
#[doc = "🌽"]
pub const EAR_OF_CORN: crate::Emoji = crate::Emoji {
    glyph: "🌽",
    codepoint: "1F33D",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "ear of corn",
    group: "Food & Drink",
    subgroup: "food-vegetable",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("mielie"),
            keywords: &["mielie", "pitte", "plant", "stronk"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የበቆሎ ዛላ"),
            keywords: &["በቆሎ", "ተክል", "የበቆሎ ዛላ", "ጆሮ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ذرة"),
            keywords: &["ذرة", "كوز"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("গোমধ\u{9be}ন"),
            keywords: &["ক\u{9be}ণ", "গোমধ\u{9be}ন", "ম\u{9be}কৈ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qarğıdalı sünbülü"),
            keywords: &[
                "qarğıdalı",
                "qarğıdalı qamışı",
                "qarğıdalı sünbülü",
                "sünbül",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("катах кукурузы"),
            keywords: &["катах", "катах кукурузы", "кукуруза", "пачатак", "расліна"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("царевичен кочан"),
            keywords: &["кочан", "растение", "царевица", "царевичен кочан"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ভ\u{9c1}ট\u{9cd}ট\u{9be}র ক\u{9be}ন"),
            keywords: &[
                "ধ\u{9be}\u{981}ধ\u{9be}",
                "ভ\u{9c1}ট\u{9cd}ট\u{9be}",
                "ভ\u{9c1}ট\u{9cd}ট\u{9be}র ক\u{9be}ন",
                "ভ\u{9c1}ট\u{9cd}ট\u{9be}র দ\u{9be}ন\u{9be}",
                "ভ\u{9c2}ট\u{9cd}ট\u{9be}",
                "শীষ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("penn-maiz"),
            keywords: &["maiz", "penn-maiz"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("klas"),
            keywords: &["biljka", "klas", "kukuruz"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("panotxa"),
            keywords: &["blat de moro", "dacsa", "moresc", "panotxa", "panís"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄟\u{1112e}𑄇\u{11133}𑄠\u{11134} 𑄌\u{1112e}𑄉\u{1112e}𑄣"),
            keywords: &["𑄟\u{1112e}𑄇\u{11133}𑄠\u{11134} 𑄌\u{1112e}𑄉\u{1112e}𑄣"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏎᎷ ᎦᎵᏟᎬ"),
            keywords: &["ᎠᎷ", "ᎠᏓᎴᎾᏍᏗᏍᎩ", "ᎦᎴ", "ᏎᎷ", "ᏎᎷ ᎦᎵᏟᎬ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kukuřičný klas"),
            keywords: &["klas", "kukuřičný klas", "obilí", "rostlina", "zrno"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("tywysen o gorn"),
            keywords: &["corn", "tywysen", "tywysen o gorn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("majs"),
            keywords: &["majs", "majskolbe"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Maiskolben"),
            keywords: &["Mais", "Maiskolben"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καλαμπόκι"),
            keywords: &["αραβόσιτος", "καλαμπόκι", "φυτό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("ear of corn"),
            keywords: &["corn", "ear", "ear of corn", "maize", "maze"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("espiga de maíz"),
            keywords: &["espiga", "espiga de maíz", "mazorca", "maíz", "mijo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("mazorca de maíz"),
            keywords: &["choclo", "mazorca", "mazorca de maíz", "maíz", "planta"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["choclo", "elote", "mazorca", "mazorca de maíz", "maíz"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("maisitõlvik"),
            keywords: &["mais", "maisitõlvik", "taim", "tõlvik"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("artaburua"),
            keywords: &["artaburua", "arto", "buru", "landare"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بلال ذرت"),
            keywords: &["بلال", "دانه ذرت", "ذرت", "گیاه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("maissintähkä"),
            keywords: &["kasvi", "maissi", "maissintähkä", "tähkä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("busal ng mais"),
            keywords: &["busal", "busal ng mais", "corn", "halaman", "mais"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("maiskolba"),
            keywords: &["aks", "kolba", "korn", "mais", "maisaks", "maiskolba"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("épi de maïs"),
            keywords: &["maïs", "épi", "épi de maïs"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["blé d’Inde", "maïs", "épi de blé d’Inde", "épi de maïs"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("dias arbhair"),
            keywords: &[
                "arbhar",
                "arbhar Indiach",
                "cathair ghríbháin",
                "dias",
                "dias arbhair",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("dias Innseanach"),
            keywords: &["coirce", "dias", "dias Innseanach", "innseanach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("mazaroca"),
            keywords: &["espiga", "mazaroca", "millo", "vexetal"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મકાઈ"),
            keywords: &["ડોડો", "મકાઈ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("zangarniyar hatsi"),
            keywords: &[
                "hatsi",
                "masara",
                "tararrun gadina",
                "zangarniya",
                "zangarniyar hatsi",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קלח תירס"),
            keywords: &["ירק", "קלח תירס", "תירס"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("भ\u{941}ट\u{94d}टा, मकई का भ\u{941}ट\u{94d}टा"),
            keywords: &[
                "भ\u{941}ट\u{94d}टा",
                "भ\u{941}ट\u{94d}टा, मकई का भ\u{941}ट\u{94d}टा",
                "मकई का भ\u{941}ट\u{94d}टा",
                "मक\u{94d}का",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("klip kukuruza"),
            keywords: &["biljka", "klip", "klip kukuruza", "kukuruz"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kukoricacső"),
            keywords: &["cső", "kukorica", "kukoricacső", "növény"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("եգիպտացորեն"),
            keywords: &["ականջ", "բույս", "եգիպտացորեն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bonggol jagung"),
            keywords: &["bonggol jagung", "bulir", "tanaman"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ogbo nke ọkà"),
            keywords: &["nti", "ogbo nke ọkà", "ọkà", "ụzọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("maís"),
            keywords: &["maís"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pannocchia"),
            keywords: &["granoturco", "mais", "pannocchia"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("とうもろこし"),
            keywords: &["とうもろこし", "コーン", "野菜"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tongkol jagung"),
            keywords: &["jagung", "klembak", "maizena", "tongkol jagung"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სიმინდის ტარო"),
            keywords: &["მცენარე", "სიმინდი", "სიმინდის ტარო", "ტარო"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("ageṭṭuc"),
            keywords: &["ageṭṭuc"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жүгері собығы"),
            keywords: &["жүгері", "жүгері собығы", "лабиринт", "сабағы", "өсімдік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("majs"),
            keywords: &["majs", "majskolbe"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ផ\u{17d2}លែពោត"),
            keywords: &["ផ\u{17d2}លែពោត", "ពោត", "រ\u{17bb}ក\u{17d2}ខជាត\u{17b7}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{cbf}ಡ\u{cbf}ಸ\u{cbf}ರುವ ಜೋಳ"),
            keywords: &[
                "ಜೋಳ",
                "ಬ\u{cbf}ಡ\u{cbf}ಸ\u{cbf}ರುವ ಜೋಳ",
                "ಮ\u{cc6}ಕ\u{ccd}ಕ\u{cc6}ಜೋಳ",
                "ಹೊಟ\u{ccd}ಟು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("옥수수"),
            keywords: &["농작물", "식물", "옥수수", "콘"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मक\u{94d}याच\u{947}\u{902} कणस"),
            keywords: &["कणस", "मक\u{947}", "मको", "मक\u{94d}याच\u{947}\u{902} कणस"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бир баш жүгөрү"),
            keywords: &["баш", "бир баш жүгөрү", "дан", "жүгөрү", "өсүмдүк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Mais"),
            keywords: &["Kolben", "Labyrinth", "Mais"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຮວງສາລ\u{eb5}"),
            keywords: &[
                "ພ\u{eb7}ດ",
                "ສ\u{eb5}ລ\u{eb5}",
                "ຮວງສາລ\u{eb5}",
                "ເຂ\u{ebb}\u{ec9}າໂພດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kukurūzo burbuolė"),
            keywords: &["augalas", "kukurūzas", "kukurūzo burbuolė", "varpa"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kukurūzas vālīte"),
            keywords: &["augs", "dārzenis", "kukurūza", "kukurūzas vālīte"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("puku kānga"),
            keywords: &["kānga", "puku kānga", "taringa"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("клас пченка"),
            keywords: &["клас", "клас пченка", "кочан", "растение"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ചോളം"),
            keywords: &["ചോളം", "ചോളക\u{d4d}കതിർ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("шошны навч"),
            keywords: &["навч", "ургамал", "шош", "шошны навч"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कणसाच\u{947} पान"),
            keywords: &[
                "कणसाच\u{947} पान",
                "कणीस",
                "ग\u{941}\u{902}ताग\u{941}\u{902}त",
                "पान",
                "मका",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tongkol jagung"),
            keywords: &["jagung", "setongkol", "tongkol jagung"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("widna tal-qamħ"),
            keywords: &["qamħ", "qamħirrum", "qamħirrun", "widna", "widna tal-qamħ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပြောင\u{103a}းန\u{103e}\u{1036}"),
            keywords: &[
                "ပြောင\u{103a}းန\u{103e}\u{1036}",
                "ပြောင\u{103a}းဖ\u{1030}း",
                "ပြောင\u{103a}းဖ\u{1030}းစေ\u{1037}",
                "ဝင\u{103a}\u{1039}ကပါ",
                "အန\u{103e}\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("maiskolbe"),
            keywords: &["mais", "maiskolbe"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("मक\u{948}को पात"),
            keywords: &["कान", "बिर\u{942}वा", "मक\u{948}", "मक\u{948}को पात"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("maïskolf"),
            keywords: &["kolf", "maïskolf", "plant"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("maiskolbe"),
            keywords: &["mais", "maiskolbe"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମକ\u{b3e} ଦ\u{b3e}ନ\u{b3e}"),
            keywords: &["କ\u{b3e}ମ", "ମକ\u{b3e}", "ମକ\u{b3e} ଦ\u{b3e}ନ\u{b3e}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a71}ਕੀ ਦੀ ਛ\u{a71}ਲੀ"),
            keywords: &["ਬ\u{a42}ਟਾ", "ਮ\u{a71}ਕੀ ਦੀ ਛ\u{a71}ਲੀ", "ਸਿ\u{a71}ਟਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مکئی دا کان"),
            keywords: &["الجھن", "مکئی", "مکئی دا بوٹا", "مکئی دا کان", "کان"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kọn"),
            keywords: &[
                "Kọn",
                "Mez",
                "Tọ\u{301}p Pát Ọf Gren Wiá Sid Dè",
                "Tọ\u{301}p Pát Ọf Kọn Wiá Sid Dè",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kolba kukurydzy"),
            keywords: &["kolba kukurydzy", "kukurydza"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د جوار وږی"),
            keywords: &["جوار، وږې، د جوار وږې، جوار", "د جوار وږی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("milho"),
            keywords: &["espiga", "espiga de milho", "milho"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("espiga de milho"),
            keywords: &["cereal", "espiga", "espiga de milho", "milho"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("chuqllu"),
            keywords: &["chinkana", "chuqllu", "ninri", "sara", "sarasara"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("știulete de porumb"),
            keywords: &["cereală", "porumb", "știulete", "știulete de porumb"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-258"),
            keywords: &["E10-258"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("кукурузный початок"),
            keywords: &["кукуруза", "кукурузный початок", "початок"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikibabi cy’ikigori"),
            keywords: &["ikibabi cy’ikigori", "ikigori", "maze", "ugutwi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مڪئي جا داڻا"),
            keywords: &["مڪئي", "مڪئي جا داڻا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඉර\u{dd2}ඟ\u{dd4}"),
            keywords: &[
                "ඉර\u{dd2}ඟ\u{dd4}",
                "කරල",
                "පැළය",
                "බඩ ඉර\u{dd2}ඟ\u{dd4}",
                "වංක ග\u{dd2}ර\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kukuričný klas"),
            keywords: &["klas", "kukurica", "kukuričný klas", "rastlina"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("koruzni storž"),
            keywords: &["klas", "koruza", "koruzni storž", "rastlina"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("sabuul galley"),
            keywords: &["dhag", "galley", "sabuul galley", "xabbaasha"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kalli misri"),
            keywords: &["bimë", "kalli", "kalli misri", "misër"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("клип кукуруза"),
            keywords: &["биљкa", "клип", "клип кукуруза", "кукуруз"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("klip kukuruza"),
            keywords: &["biljka", "klip", "klip kukuruza", "kukuruz"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("majskolv"),
            keywords: &["majs", "majskolv"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mahindi"),
            keywords: &["mahindi", "mmea", "nafaka", "sikio", "tazaa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சோளக\u{bcd}கதிர\u{bcd}"),
            keywords: &[
                "சோளக\u{bcd}கதிர\u{bcd}",
                "ப\u{bbe}ப\u{bcd}க\u{bbe}ர\u{bcd}ன\u{bcd}",
                "மக\u{bcd}க\u{bbe}ச\u{bcd}சோளம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c4a}క\u{c4d}కజ\u{c4a}న\u{c4d}న కంక\u{c3f}"),
            keywords: &[
                "కంకులు",
                "మ\u{c4a}క\u{c4d}కజ\u{c4a}న\u{c4d}న",
                "మ\u{c4a}క\u{c4d}కజ\u{c4a}న\u{c4d}న కంక\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("сӯтаи ҷуворимакка"),
            keywords: &[
                "гӯш",
                "лабиринт",
                "сӯтаи ҷуворимакка",
                "ҷуворимакка",
                "ҷуворӣ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ข\u{e49}าวโพด"),
            keywords: &["ข\u{e49}าวโพด", "ธ\u{e31}ญพ\u{e37}ช", "พ\u{e37}ช"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("mekgejöwen"),
            keywords: &["gulak", "gulpak", "mekge", "mekgejöwen"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("foʻi koane"),
            keywords: &["foʻi koane"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("mısır koçanı"),
            keywords: &["başak", "mısır koçanı"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قوناق قۇلىقى"),
            keywords: &["سىرلىق", "قوناق", "قوناق قۇلىقى", "قۇلاق", "كۆممىقوناق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("качан кукурудзи"),
            keywords: &["качан", "качан кукурудзи", "кукурудза", "маїс", "суцвіття"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چھلی"),
            keywords: &["پودا", "چھلی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("makkajo‘xori"),
            keywords: &["boshoq", "jo‘xori", "makkajo‘xori", "o‘simlik"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bắp ngô"),
            keywords: &["bắp", "ngô"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("noppi mboq"),
            keywords: &["mboq", "nopp", "noppi mboq"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isikhwebu sombona"),
            keywords: &[
                "indlebe",
                "irhasi",
                "isikhwebu sombona",
                "umbona",
                "umqathango",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Agbado"),
            keywords: &[
                "Agbado",
                "etí",
                "àgbàdo",
                "àgbàdo yínyín",
                "ọ\u{300}nà ìrújú",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("粟米"),
            keywords: &["玉米", "粟米"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("粟米"),
            keywords: &["玉米", "粟米"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("玉米"),
            keywords: &["玉米", "苞米"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("玉米"),
            keywords: &["玉米", "蔬菜"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("粟米"),
            keywords: &["玉米", "粟米", "蔬菜"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iqabunga lommbila"),
            keywords: &["iqabunga", "iqabunga lommbila", "isithalo", "ummbila"],
        },
    ],
};
#[doc = "🌶\u{fe0f}"]
pub const HOT_PEPPER: crate::Emoji = crate::Emoji {
    glyph: "🌶\u{fe0f}",
    codepoint: "1F336 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "hot pepper",
    group: "Food & Drink",
    subgroup: "food-vegetable",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🌶",
        codepoint: "1F336",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "hot pepper",
        group: "Food & Drink",
        subgroup: "food-vegetable",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("brandrissie"),
            keywords: &["brand", "brandrissie", "plant", "rissie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሚጥሚጣ ቃሪያ"),
            keywords: &["ሚጥሚጣ", "ተክል", "የሚያቃጥል", "የሚጥሚጣ ቃሪያ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("فلفل حار"),
            keywords: &["حار", "فلفل", "نبات"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("জ\u{9cd}বল\u{9be} জলকীয\u{9bc}\u{9be}"),
            keywords: &[
                "গৰম",
                "জলকীয\u{9bc}\u{9be}",
                "জ\u{9cd}বল\u{9be} জলকীয\u{9bc}\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("acı bibər"),
            keywords: &["acı", "acı bibər", "bitki", "istiot"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("востры перац"),
            keywords: &["востры", "перац", "расліна"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("люта чушка"),
            keywords: &["лют", "люта чушка", "растение", "чушка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ঝ\u{9be}ল লঙ\u{9cd}ক\u{9be}"),
            keywords: &[
                "গরম",
                "গ\u{9be}ছ",
                "ঝ\u{9be}ল লঙ\u{9cd}ক\u{9be}",
                "লঙ\u{9cd}ক\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pimant ruz"),
            keywords: &["pimant", "pimant ruz"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ljuti feferon"),
            keywords: &["feferon", "ljuta paprika", "ljuti feferon"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bitxo"),
            keywords: &["bitxo", "pebrot", "picant", "planta", "xili"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄏𑄣\u{11134} 𑄟\u{11127}𑄢\u{11128}𑄌\u{11134}"),
            keywords: &["𑄏𑄣\u{11134} 𑄟\u{11127}𑄢\u{11128}𑄌\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏗᏞᎩ ᏗᏆᏲᏗ"),
            keywords: &["ᎤᏗᏞᎩ", "ᏗᏆᏲᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("feferonka"),
            keywords: &[
                "chilli",
                "feferonka",
                "ostrý",
                "paprika",
                "paprička",
                "pálivý",
                "rostlina",
                "čili",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("pupur twym"),
            keywords: &["planhigyn", "pupur", "twym"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("chili"),
            keywords: &["chili", "peber", "plante", "stærk"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Peperoni"),
            keywords: &[
                "Chili", "Paprika", "Peperoni", "Pfeffer", "Pflanze", "scharf",
            ],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Chili"),
            keywords: &[""],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καυτερή πιπεριά"),
            keywords: &["καυτερή", "πιπεριά", "φυτό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("hot pepper"),
            keywords: &["hot", "pepper"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("chilli"),
            keywords: &["chilli", "hot", "pepper"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["chilli", "pepper"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("chile picante"),
            keywords: &["chile", "picante", "planta"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("pimiento picante"),
            keywords: &["comida", "picante", "pimiento"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("chile picante"),
            keywords: &["chile picante"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("chile"),
            keywords: &["chile", "picoso"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("tuline pipar"),
            keywords: &["pipar", "taim", "tuline"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("txilea"),
            keywords: &["bizi", "landare", "piper", "txile", "txilea"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("فلفل قرمز"),
            keywords: &["تند", "داغ", "فلفل", "فلفل قرمز", "گیاه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("jalapeno"),
            keywords: &["jalapeno", "kasvi", "kuuma", "paprika", "tulinen"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("sili"),
            keywords: &["bunga", "halaman", "maanghang", "sili"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sterkt pipar"),
            keywords: &["pipar", "sterkt"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("piment rouge"),
            keywords: &["piment", "piment rouge"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("píobar te"),
            keywords: &["píobar", "te"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("piobar-teth"),
            keywords: &["piobar", "piobar-teth", "teth"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("chile picante"),
            keywords: &["chile", "picante"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લાલ મરચ\u{ac1}\u{a82}"),
            keywords: &[
                "છોડ",
                "તીખ\u{ac1}\u{a82}",
                "મરચ\u{ac1}\u{a82}",
                "લાલ મરચ\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("barkono mai zafi"),
            keywords: &["barkono", "barkono mai zafi", "zafi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פלפל חריף"),
            keywords: &["חריף", "ירק", "פלפל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("तीखी मिर\u{94d}च"),
            keywords: &["तीखी", "पौधा", "मिर\u{94d}च"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("ljuta papričica"),
            keywords: &["biljka", "ljuta papričica", "ljuto", "paprika", "papričica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("erőspaprika"),
            keywords: &["erős", "erőspaprika", "növény", "paprika"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կծու պղպեղ"),
            keywords: &["բույս", "կծու", "պղպեղ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("cabai pedas"),
            keywords: &["cabai pedas", "lada", "pedas", "tanaman"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọsọ ọkụ"),
            keywords: &["oso", "ọkụ", "ọsọ ọkụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("chilipipar"),
            keywords: &["chilipipar", "chilli", "pipar", "planta", "sterkt"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("peperoncino"),
            keywords: &["peperoncino", "piccante"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("とうがらし"),
            keywords: &["とうがらし", "辛い", "野菜", "香辛料"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("lombok"),
            keywords: &["lombok", "pedhes"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ცხარე წიწაკა"),
            keywords: &["მცენარე", "ცხარე", "წიწაკა"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("ifelfel azggaɣ"),
            keywords: &["ifelfel azggaɣ"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ащы бұрыш"),
            keywords: &["ащы", "бұрыш", "өсімдік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("chili"),
            keywords: &["chili", "peber", "plante", "stærk"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17d2}ទេសក\u{17d2}រហម"),
            keywords: &["ម\u{17d2}ទេស", "ម\u{17d2}ទេសក\u{17d2}រហម", "ហ\u{17b9}រ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{cc6}ಂಪು ಮ\u{cc6}ಣಸ\u{cbf}ನಕಾಯ\u{cbf}"),
            keywords: &[
                "ಕ\u{cc6}ಂಪು ಮ\u{cc6}ಣಸ\u{cbf}ನಕಾಯ\u{cbf}",
                "ಮ\u{cc6}ಣಸ\u{cbf}ನ ಕಾಯ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("홍고추"),
            keywords: &["고추", "빨간 고추", "홍고추"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("तारवटी मिरसा\u{902}ग"),
            keywords: &["तारवटी", "मिरसा\u{902}ग"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ачуу калемпир"),
            keywords: &["ачуу", "калемпир", "өсүмдүк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Peperoni"),
            keywords: &["Peperoni", "schaarf"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໝາກເຜ\u{eb1}ດ"),
            keywords: &["ພ\u{eb4}ກ", "ພ\u{eb7}ດ", "ໝາກເຜ\u{eb1}ດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("aštrusis pipiras"),
            keywords: &["aštrus", "aštrusis pipiras", "pipiras"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("asais pipars"),
            keywords: &["asais pipars", "ass", "augs", "pipars"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pepa wera"),
            keywords: &["pepa", "wera"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лута пиперка"),
            keywords: &["лута пиперка", "луто", "пиперка", "растение"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ച\u{d41}വന\u{d4d}ന മ\u{d41}ളക\u{d4d}"),
            keywords: &[
                "എരിവ\u{d4d}",
                "ച\u{d41}വന\u{d4d}ന മ\u{d41}ളക\u{d4d}",
                "പച\u{d4d}ചക\u{d4d}കറി",
                "മ\u{d41}ളക\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("халуун чинжүү"),
            keywords: &["ургамал", "халуун", "чинжүү"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("लाल मिरची"),
            keywords: &["गरम", "मिरी", "लाल मिरची"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("cili api"),
            keywords: &["cili api", "lada", "pedas"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("bżar jaħraq"),
            keywords: &["bżar", "jaħraq"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ငရ\u{102f}တ\u{103a}သ\u{102e}း"),
            keywords: &["ငရ\u{102f}တ\u{103a}သ\u{102e}း", "အစပ\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("rød chili"),
            keywords: &["chili", "plante", "rød", "sterk"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पिरो ख\u{941}र\u{94d}सानी"),
            keywords: &["कालो", "पिरो ख\u{941}र\u{94d}सानी", "बिर\u{942}वा", "मरिच"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("hete peper"),
            keywords: &["heet", "hete peper", "peper"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("raud chili"),
            keywords: &["chili", "plante", "raud", "sterk"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ର\u{b3e}ଗ ଲ\u{b3e}ଲମର\u{b3f}ଚ"),
            keywords: &[
                "ଗରମ । ଗୋଲମର\u{b3f}ଚ",
                "ର\u{b3e}ଗ ଗୋଲମର\u{b3f}ଚ",
                "ର\u{b3e}ଗ ଲ\u{b3e}ଲମର\u{b3f}ଚ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਤਿ\u{a71}ਖੀ ਮਿਰਚ"),
            keywords: &["ਤਿ\u{a71}ਖੀ", "ਬ\u{a42}ਟਾ", "ਮਿਰਚ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("تیز مرچ"),
            keywords: &["تتا", "تیز مرچ", "مرچ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Họ\u{301}t Pẹ\u{301}pẹ"),
            keywords: &["Họt", "Họ\u{301}t Pẹ\u{301}pẹ", "Pẹ\u{301}pẹ"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("ostra papryka"),
            keywords: &["ostra papryka", "ostry", "papryka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ګرم مرچ"),
            keywords: &["مرچ", "ګرم"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pimenta"),
            keywords: &["apimentado", "pimenta", "tempero"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("malagueta"),
            keywords: &["legume", "malagueta", "picante"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("jaya pimienta"),
            keywords: &["jaya", "pimienta"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ardei iute"),
            keywords: &["ardei", "iute", "legumă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-251"),
            keywords: &["E10-251"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("острый перец"),
            keywords: &["красный", "острый", "перец", "растение"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("urusenda"),
            keywords: &["bishyushye", "urusenda"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("گرم مرچ"),
            keywords: &["مرچ", "گرم مرچ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අම\u{dd4} ගම\u{dca}ම\u{dd2}ර\u{dd2}ස\u{dca}"),
            keywords: &["අම\u{dd4}", "ගම\u{dca}ම\u{dd2}ර\u{dd2}ස\u{dca}", "පැළය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("čili paprička"),
            keywords: &["paprika", "pálivá", "rastlina", "čili", "čili paprička"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("feferon"),
            keywords: &["feferon", "paprika", "pekoče"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("basbaas"),
            keywords: &["basbaas", "kulul"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("spec djegës"),
            keywords: &["bimë", "djegës", "spec"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("љута папричица"),
            keywords: &["биљкa", "пaприкa", "пaпричицa", "љутo", "љута папричица"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ljuta papričica"),
            keywords: &["biljka", "ljuta papričica", "ljuto", "paprika", "papričica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("chili"),
            keywords: &["chili", "peppar", "starkt", "växt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("pilipili kali"),
            keywords: &["mmea", "moto", "pilipili", "pilipili kali"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மிளக\u{bbe}ய\u{bcd} பெப\u{bcd}பர\u{bcd}"),
            keywords: &[
                "க\u{bbe}ரம\u{bcd}",
                "சிவப\u{bcd}பு மிளக\u{bbe}ய\u{bcd}",
                "பெப\u{bcd}பர\u{bcd}",
                "மிளக\u{bbe}ய\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఘ\u{c3e}టు మ\u{c3f}ర\u{c4d}చ\u{c3f}"),
            keywords: &[
                "ఘ\u{c3e}టు",
                "ఘ\u{c3e}టు మ\u{c3f}ర\u{c4d}చ\u{c3f}",
                "మ\u{c3f}రప",
                "మ\u{c4a}క\u{c4d}క",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("қаланфури тез"),
            keywords: &["гарм", "қаланфур", "қаланфури тез"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("พร\u{e34}ก"),
            keywords: &["พร\u{e34}ก", "พ\u{e37}ช", "เผ\u{e47}ด"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ajy garaburç"),
            keywords: &["ajy", "garaburç"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("polo fifisi"),
            keywords: &["polo fifisi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("acı biber"),
            keywords: &["acı", "biber", "bitki"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاچچىق مۇچ"),
            keywords: &["ئاچچىق مۇچ", "قىزىق", "مۇچ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("гострий перець"),
            keywords: &["гострий", "перець"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("تیز مرچ"),
            keywords: &["تیز", "مرچ", "پودا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("achchiq qalampir"),
            keywords: &["achchiq", "o‘simlik", "qalampir"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("quả ớt"),
            keywords: &["nóng", "quả ớt", "ớt"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kaani xeeñ"),
            keywords: &["kaani", "xeeñ"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ipepile eshushu"),
            keywords: &["eshushu", "ipepile"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ata gbígbónọ\u{300}"),
            keywords: &["ata", "gbígbónọ\u{300}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("辣椒"),
            keywords: &["辣", "辣椒"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("辣椒"),
            keywords: &["辣", "辣椒"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("红辣椒"),
            keywords: &["红辣椒", "辣椒"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("辣椒"),
            keywords: &["蔬菜", "辣椒"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["指天椒", "紅椒", "蔬菜", "辣椒"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("upelepele obabayo"),
            keywords: &["isitshalo", "ukubaba", "upelepele", "upelepele obabayo"],
        },
    ],
};
#[doc = "🫑"]
pub const BELL_PEPPER: crate::Emoji = crate::Emoji {
    glyph: "🫑",
    codepoint: "1FAD1",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "bell pepper",
    group: "Food & Drink",
    subgroup: "food-vegetable",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("soetrissie"),
            keywords: &["groente", "rissies", "soetrissie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የፈረንጅ ቃሪያ"),
            keywords: &["የፈረንጅ ቃሪያ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("فلفل حلو"),
            keywords: &["خضار", "فلفل", "فلفل أحمر", "فلفل حلو"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বেল পেপ\u{9be}ৰ"),
            keywords: &[
                "কেপচিক\u{9be}ম",
                "জলকীয\u{9bc}\u{9be}",
                "বেল পেপ\u{9be}ৰ",
                "শ\u{9be}ক-প\u{9be}চলি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("bolqar bibəri"),
            keywords: &["bibər", "bolqar bibəri", "ispan bibəri", "tərəvəz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("балгарскі перац"),
            keywords: &["агародніна", "балгарскі перац", "перац", "чырвоны перац"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("пипер тип долма"),
            keywords: &["зеленчук", "капсикум", "пипер", "пипер тип долма"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9cd}য\u{9be}পসিক\u{9be}ম"),
            keywords: &[
                "ক\u{9cd}য\u{9be}পসিক\u{9be}ম",
                "বেল পেপ\u{9be}র",
                "মরিচ",
                "সবজি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("skilbebr"),
            keywords: &["legumaj", "skilbebr"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("paprika babura"),
            keywords: &["babura", "paprika", "povrće"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pebrot vermell"),
            keywords: &["capsicum", "hortalissa", "pebrot", "pebrot vermell"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎭᎸᏂ ᎤᏥᎸ ᎤᏴᏍᏗ"),
            keywords: &["ᎠᏫᏌᏂ", "ᎤᎭᎸᏂ ᎤᏥᎸ ᎤᏴᏍᏗ", "ᎤᏗᏞᎬᎢ", "ᎤᏥᎸ ᎤᏴᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("paprika"),
            keywords: &["kapie", "paprika", "sladká", "zelenina"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("pupryn"),
            keywords: &["llysieuyn", "pupryn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("peberfrugt"),
            keywords: &["grøntsag", "paprika", "peber", "peberfrugt", "rød peber"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Paprika"),
            keywords: &["Gemüse", "Gemüsepaprika", "Paprika"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Peperoni"),
            keywords: &["Gemüse", "Paprika", "Peperoni"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πιπεριά"),
            keywords: &["λαχανικό", "πιπεριά"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("bell pepper"),
            keywords: &["bell pepper", "capsicum", "pepper", "vegetable"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("pepper"),
            keywords: &[
                "bell pepper",
                "capsicum",
                "pepper",
                "sweet pepper",
                "vegetable",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("pepper"),
            keywords: &[
                "bell pepper",
                "capsicum",
                "pepper",
                "sweet pepper",
                "vegetable",
            ],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("bell pepper"),
            keywords: &["bell pepper", "capsicum", "pepper", "vegetable"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pimiento"),
            keywords: &["ají", "chile", "morrón", "pimiento", "rojo", "verdura"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("pimiento morrón"),
            keywords: &["pimiento morrón"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("pimiento morrón"),
            keywords: &["pimiento morrón"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("paprika"),
            keywords: &["köögivili", "paprika", "pipar"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("piper"),
            keywords: &["barazkia", "piper", "piperra"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("فلفل دلمه\u{200c}ای"),
            keywords: &["سبزیجات", "فلفل", "فلفل دلمه\u{200c}ای"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("paprika"),
            keywords: &["capsicum", "paprika", "vihannes"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bell pepper"),
            keywords: &["bell pepper", "capsicum", "gulay", "sili"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("piparfrukt"),
            keywords: &["grønmeti", "pipar", "piparfrukt"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("poivron"),
            keywords: &["légume", "piment", "poivron"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("poivron rouge"),
            keywords: &["légume", "piment", "poivron", "poivron rouge"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("piobar"),
            keywords: &["capsicum", "glasra", "piobar"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("piobar-milis"),
            keywords: &["glasraich", "piobar", "piobar-milis"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("pemento"),
            keywords: &["pemento", "vexetal"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સિમલા મરચ\u{ac1}\u{a82}"),
            keywords: &[
                "મરચાનો છોડ",
                "મરચ\u{ac1}\u{a82}",
                "શાકભાજી",
                "સિમલા મરચ\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פלפל אדום"),
            keywords: &["גמבה", "ירק", "פלפל", "פלפל אדום"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("शिमला मिर\u{94d}च"),
            keywords: &[
                "पहाड\u{93c}ी मिर\u{94d}च",
                "मिर\u{94d}च",
                "शिमला मिर\u{94d}च",
                "सब\u{94d}ज\u{93c}ी",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("paprika"),
            keywords: &["babura", "paprika", "papričica", "povrće"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kaliforniai paprika"),
            keywords: &["kaliforniai paprika", "paprika", "zöldség"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տաքդեղ"),
            keywords: &["բանջարեղեն", "պղպեղ", "տաքդեղ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("paprika"),
            keywords: &["capsicum", "paprika", "sayuran"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("paprika"),
            keywords: &["grænmeti", "paprika"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("peperone"),
            keywords: &["ortaggio", "peperone"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("赤ピーマン"),
            keywords: &["とうがらし", "パプリカ", "ピーマン", "赤ピーマン", "野菜"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("paprika"),
            keywords: &["kapsikum", "lombok", "paprika", "sayuran"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბულგარული წიწაკა"),
            keywords: &["ბოსტნეული", "ბულგარული წიწაკა", "წიწაკა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("болгар бұрышы"),
            keywords: &["болгар бұрышы", "бұршаққынды бұрыш", "бұрыш", "көкөніс"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17d2}ទេសប\u{17d2}លោក"),
            keywords: &[
                "បន\u{17d2}លែ",
                "ពព\u{17bd}កម\u{17d2}ទេស",
                "ម\u{17d2}ទេស",
                "ម\u{17d2}ទេសប\u{17d2}លោក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ದೊಡ\u{ccd}ಡ ಮ\u{cc6}ಣಸ\u{cbf}ನಕಾಯ\u{cbf}"),
            keywords: &[
                "ಕ\u{ccd}ಯಾಪ\u{ccd}ಸ\u{cbf}ಕಂ",
                "ತರಕಾರ\u{cbf}",
                "ದೊಡ\u{ccd}ಡ ಮ\u{cc6}ಣಸ\u{cbf}ನಕಾಯ\u{cbf}",
                "ಮ\u{cc6}ಣಸು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("피망"),
            keywords: &["고추", "채소", "피망", "후추"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ढब\u{94d}ब\u{942} मिरसा\u{902}ग"),
            keywords: &[
                "काश\u{94d}मिरी मिरसा\u{902}ग",
                "ढब\u{94d}ब\u{942}",
                "ढब\u{94d}ब\u{942} मिरसा\u{902}ग",
                "भाजी",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("таттуу мурч"),
            keywords: &["таттуу мурч"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໝາກເຜ\u{eb1}ດໃຫຍ\u{ec8}"),
            keywords: &[
                "ຜ\u{eb1}ກ",
                "ພ\u{eb4}ກໄທ",
                "ໝາກເຜ\u{eb1}ດ",
                "ໝາກເຜ\u{eb1}ດໃຫຍ\u{ec8}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("paprika"),
            keywords: &["daržovė", "paprika", "pipirai"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("paprika"),
            keywords: &["dārzenis", "paprika", "pipars", "sarkanie pipari"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("бабура"),
            keywords: &["бабура", "зеленчук", "пиперка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മണി ക\u{d41}ര\u{d41}മ\u{d41}ളക\u{d4d}"),
            keywords: &[
                "ക\u{d3e}പ\u{d4d}സിക\u{d4d}കം",
                "ക\u{d41}ര\u{d41}മ\u{d41}ളക\u{d4d}",
                "പച\u{d4d}ചക\u{d4d}കറി",
                "മണി ക\u{d41}ര\u{d41}മ\u{d41}ളക\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("амтат чинжүү"),
            keywords: &["амтат чинжүү", "хүнсний ногоо", "чинжүү"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ढोबळी मिरची"),
            keywords: &["काळी मिरी", "ढोबळी मिरची", "भाजी", "शिमला मिर\u{94d}ची"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("cili kembung"),
            keywords: &["cili kembung", "lada", "lada benggala", "sayur"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ငရ\u{102f}တ\u{103a}ပ\u{103d}"),
            keywords: &[
                "ကပ\u{103a}စ\u{102e}ကန\u{103a}",
                "ငရ\u{102f}တ\u{103a}",
                "ငရ\u{102f}တ\u{103a}ပ\u{103d}",
                "ဟင\u{103a}းသ\u{102e}းဟင\u{103a}းရ\u{103d}က\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("paprika"),
            keywords: &["capsicum", "chili", "grønnsak", "paprika"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ब\u{947}ल प\u{947}पर"),
            keywords: &[
                "ख\u{941}र\u{94d}सानी",
                "डल\u{94d}\u{200d}ल\u{947} ख\u{941}र\u{94d}सानी",
                "तरकारी",
                "ब\u{947}ल प\u{947}पर",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("paprika"),
            keywords: &["capsicum", "groente", "paprika", "peper"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("paprika"),
            keywords: &["capsicum", "chili", "grønsak", "paprika"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b3f}ମଲ\u{b3e} ଲଙ\u{b4d}କ\u{b3e}"),
            keywords: &[
                "ଗୋଲମର\u{b3f}ଚ",
                "ପନ\u{b3f}ପର\u{b3f}ବ\u{b3e}",
                "ସ\u{b3f}ମଲ\u{b3e} ମର\u{b3f}ଚ",
                "ସ\u{b3f}ମଲ\u{b3e} ଲଙ\u{b4d}କ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲਾਲ ਸ\u{a3c}ਿਮਲਾ ਮਿਰਚ"),
            keywords: &[
                "ਮਿਰਚ",
                "ਲਾਲ ਸ\u{a3c}ਿਮਲਾ ਮਿਰਚ",
                "ਸਬਜ\u{a3c}ੀ",
                "ਸ\u{a3c}ਿਮਲਾ ਮਿਰਚ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bẹ\u{301}l Pẹ\u{301}pe"),
            keywords: &[
                "Bẹ\u{301}l Pẹ\u{301}pe",
                "Kápsíkum",
                "Pẹ\u{301}pẹ",
                "Vẹ\u{301}jítébul",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("papryka"),
            keywords: &["papryka", "papryka słodka", "paprykowy", "warzywo"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شمله مرچ"),
            keywords: &["سبزي", "شمله مرچ", "مرچ", "مرچکي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pimentão"),
            keywords: &["capsicum", "pimenta", "pimentão", "vegetal"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("pimento"),
            keywords: &["capsicum", "pimento", "vegetal"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pimiento"),
            keywords: &["pimenton", "pimiento", "vegetal"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ardei gras"),
            keywords: &[
                "ardei",
                "ardei capia",
                "ardei gras",
                "ardei iute",
                "gogoșar",
                "legumă",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-040"),
            keywords: &["E13-040"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("болгарский перец"),
            keywords: &["болгарский перец", "овощ", "перец", "растение", "сладкий"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بيل پيپر"),
            keywords: &["بيل پيپر", "سبزي", "پيپر", "ڪيپسي ڪم"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බෙල\u{dca} පෙපර\u{dca}"),
            keywords: &[
                "එළවළ\u{dd4}",
                "කැප\u{dca}ස\u{dd2}යම\u{dca}",
                "ගම\u{dca}ම\u{dd2}ර\u{dd2}ස\u{dca}",
                "බෙල\u{dca} පෙපර\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kapia"),
            keywords: &["kapia", "paprika", "zelenina"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("paprika"),
            keywords: &["babura", "capsicum", "paprika", "zelenjava"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("basbaas dawan"),
            keywords: &["basbaas dawan", "qudrad"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("patëllxhanë për mbushje"),
            keywords: &[
                "patëllxhanë për mbushje",
                "perime",
                "pjepër",
                "spec",
                "speca për mbushje",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("бабура"),
            keywords: &["бабура", "паприка", "поврће"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("babura"),
            keywords: &["babura", "paprika", "povrće"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("paprika"),
            keywords: &["grönsak", "paprika", "röd paprika"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("pilipili boga"),
            keywords: &["boga", "pilipili"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பெல\u{bcd} பெப\u{bcd}பர\u{bcd}"),
            keywords: &[
                "க\u{bbe}ய\u{bcd}",
                "குடை மிளக\u{bbe}ய\u{bcd}",
                "பெல\u{bcd} பெப\u{bcd}பர\u{bcd}",
                "மிளக\u{bbe}ய\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c4d}య\u{c3e}ప\u{c4d}స\u{c3f}కమ\u{c4d}"),
            keywords: &[
                "క\u{c3e}ప\u{c4d}స\u{c3f}కం",
                "కూరగ\u{c3e}య",
                "క\u{c4d}య\u{c3e}ప\u{c4d}స\u{c3f}కమ\u{c4d}",
                "మ\u{c3f}ర\u{c4d}చ\u{c3f}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("พร\u{e34}กหยวก"),
            keywords: &[
                "ผ\u{e31}ก",
                "พร\u{e34}ก",
                "พร\u{e34}กหยวก",
                "พร\u{e34}กหวาน",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("bolgar burç"),
            keywords: &["bolgar burç", "burç", "gök önüm"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("polo"),
            keywords: &["polo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("dolma biber"),
            keywords: &["biber", "dolma biber", "dolmalık biber", "sebze"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("солодкий перець"),
            keywords: &["овоч", "паприка", "перець", "солодкий перець"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("شملہ مرچ"),
            keywords: &["سبزی", "شملہ مرچ", "مرچ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("bolgar qalampiri"),
            keywords: &["bolgar qalampiri", "kapsikum", "qalampir", "sabzavot"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ớt chuông"),
            keywords: &["rau", "ớt", "ớt chuông"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("燈籠椒"),
            keywords: &["燈籠椒", "胡椒粉", "蔬菜", "辣椒"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("灯笼椒"),
            keywords: &["灯笼椒", "胡椒粉", "蔬菜", "辣椒"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("灯笼椒"),
            keywords: &["灯笼椒", "蔬菜", "辣椒"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("甜椒"),
            keywords: &["甜椒", "蔬菜", "辣椒"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-bell pepper"),
            keywords: &["i-bell pepper", "i-capsicum", "isithelo", "upelepele"],
        },
    ],
};
#[doc = "🥒"]
pub const CUCUMBER: crate::Emoji = crate::Emoji {
    glyph: "🥒",
    codepoint: "1F952",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "cucumber",
    group: "Food & Drink",
    subgroup: "food-vegetable",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("komkommer"),
            keywords: &["groente", "komkommer", "kos"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ዱባ"),
            keywords: &["ምግብ", "አትክልት", "ዱባ", "ፒክል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("خيار"),
            keywords: &["خضروات", "خيار", "طعام", "مخللات"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("তিয\u{9bc}হ"),
            keywords: &[
                "আচ\u{9be}ৰ",
                "খ\u{9be}দ\u{9cd}য",
                "তিয\u{9bc}হ",
                "প\u{9be}চলি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("xiyar"),
            keywords: &["tərəvəz", "xiyar"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("агурок"),
            keywords: &["агурок", "гародніна", "ежа", "саленне"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("краставица"),
            keywords: &["зеленчук", "кисела", "краставица", "храна"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("শস\u{9be}"),
            keywords: &["আচ\u{9be}র", "খ\u{9be}ব\u{9be}র", "শস\u{9be}", "সবজি"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kokombrez"),
            keywords: &["kokombrez", "legumaj"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("krastavac"),
            keywords: &["hrana", "kiseli krastavac", "krastavac", "povrće"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cogombre"),
            keywords: &["cogombre", "cogombret", "hortalissa", "menjar"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄜\u{11127}𑄣\u{11134}"),
            keywords: &["𑄜\u{11127}𑄣\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᎦᎹ"),
            keywords: &["ᎠᎵᏍᏓᏴᏗ", "ᎠᏫᏒᏅ ᎤᏛᏒᎢ", "ᎦᎦᎹ", "ᎦᎦᎹ ᏗᎧᏅᏦᎢᏍᏔᏅ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("okurka"),
            keywords: &[
                "jídlo",
                "kyselá",
                "nakládaná",
                "okurek",
                "okurka",
                "zelenina",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ciwcymber"),
            keywords: &["bwyd", "ciwcymber", "llysieuyn", "piclen"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("agurk"),
            keywords: &["agurk", "grøntsag", "mad", "pickle"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Gurke"),
            keywords: &["Essen", "Gemüse", "Gurke"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αγγούρι"),
            keywords: &["αγγούρι", "λαχανικό", "πίκλα", "τροφή"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("cucumber"),
            keywords: &["cucumber", "food", "pickle", "vegetable"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pepino"),
            keywords: &["comida", "pepinillo", "pepino", "verdura"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["comida", "pepino", "vegetal"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["comida", "pepinillo", "pepino", "vegetal"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kurk"),
            keywords: &["kurk", "köögivili", "toit"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("pepinoa"),
            keywords: &[
                "barazki",
                "janari",
                "ozpinetako pepino",
                "pepino",
                "pepinoa",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("خیار"),
            keywords: &["خیار", "خیارشور", "سبزیجات", "غذا"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kurkku"),
            keywords: &["kurkku", "ruoka", "vihannes"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pipino"),
            keywords: &["gulay", "pagkain", "pipino"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("agurk"),
            keywords: &["agurk", "agurka", "grønmeti"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("concombre"),
            keywords: &["concombre", "légume"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cúcamar"),
            keywords: &["bia", "cúcamar", "gircín", "glasra"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cularan"),
            keywords: &["biadh", "cularan", "glasraich", "piceal", "picil"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cogombro"),
            keywords: &["cogombro", "comida", "vexetal"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કાકડી"),
            keywords: &["અથાણ\u{ac1}\u{a82}", "કાકડી", "ભોજન", "શાકભાજી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kokwamba"),
            keywords: &["abinci", "ganye", "kokwamba", "mai daɗi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מלפפון"),
            keywords: &["ירק", "מלפפון", "סלט"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("खीरा"),
            keywords: &["अचार", "खीरा", "भोजन", "सब\u{94d}जी"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("krastavac"),
            keywords: &["hrana", "kiseli krastavac", "krastavac", "povrće"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("uborka"),
            keywords: &["uborka", "zöldség", "étel"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("վարունգ"),
            keywords: &["բանջարեղեն", "ուտելիք", "վարունգ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("ketimun"),
            keywords: &["acar", "ketimun", "makanan", "sayuran", "timun"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("mkpụrụakwụkwọnri"),
            keywords: &["akwụkwọnri", "mkpụrụakwụkwọnri", "nri", "ofe"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("gúrka"),
            keywords: &["grænmeti", "gúrka", "matur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cetriolo"),
            keywords: &["cetriolino sottaceto", "cetriolo", "cibo", "ortaggio"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("キュウリ"),
            keywords: &["キュウリ", "ピクルス", "漬け物", "野菜"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("timun"),
            keywords: &["acar", "pangan", "sayuran", "timun"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კიტრი"),
            keywords: &["ბოსტნეული", "კიტრი", "მწნილი", "საკვები"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("ilekkel"),
            keywords: &["ilekkel"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қияр"),
            keywords: &["көкөніс", "тағам", "қияр"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("agurk"),
            keywords: &["agurk", "grøntsag", "mad"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ត\u{17d2}រសក\u{17cb}"),
            keywords: &[
                "ជ\u{17d2}រក\u{17cb}ត\u{17d2}រសក\u{17cb}",
                "ត\u{17d2}រសក\u{17cb}",
                "បន\u{17d2}លែ",
                "អាហារ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{ccc}ತ\u{cc6}"),
            keywords: &[
                "ಆಹಾರ",
                "ಉಪ\u{ccd}ಪ\u{cbf}ನಕಾಯ\u{cbf}",
                "ತರಕಾರ\u{cbf}",
                "ಸ\u{ccc}ತ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("오이"),
            keywords: &["식품", "오이", "채소", "피클"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("तवश\u{947}\u{902}"),
            keywords: &[
                "अन\u{94d}न",
                "तवश\u{947}\u{902}",
                "भाजी",
                "लोणच\u{947}\u{902}",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бадыраң"),
            keywords: &["бадыраң", "жашылча", "тамак", "туздалган"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Kornischong"),
            keywords: &["Geméis", "Iessen", "Kornischong"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໝາແຕງ"),
            keywords: &[
                "ຜ\u{eb1}ກ",
                "ອາຫານ",
                "ເຄ\u{eb7}\u{ec8}ອງດອງ",
                "ໝາກແຕງ",
                "ໝາແຕງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("agurkas"),
            keywords: &["agurkas", "daržovė", "maistas", "raugintas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("gurķis"),
            keywords: &["dārzenis", "gurķis", "pārtika", "skābēts"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kūkama"),
            keywords: &["huawhenua", "kai", "kūkama", "pīkara"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("краставица"),
            keywords: &["зеленчук", "краставица", "краставичка", "храна"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വെള\u{d4d}ളരിക\u{d4d}ക"),
            keywords: &[
                "പച\u{d4d}ചക\u{d4d}കറി",
                "ഭക\u{d4d}ഷണം",
                "വെള\u{d4d}ളരിക\u{d4d}ക",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("өргөст хэмх"),
            keywords: &["ногоо", "хүнс", "өргөст хэмх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("काकडी"),
            keywords: &["काकडी", "खाद\u{94d}य", "भाजीपाला", "लोणच\u{947}"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("timun"),
            keywords: &["jeruk", "makanan", "sayur", "timun"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ħjara"),
            keywords: &["ikel", "immarinat", "ħaxix", "ħjara"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("သခ\u{103d}ားသ\u{102e}း"),
            keywords: &[
                "ဆားရည\u{103a}စ\u{102d}မ\u{103a}",
                "သခ\u{103d}ားသ\u{102e}း",
                "အစားအသောက\u{103a}",
                "အသ\u{102e}းအန\u{103e}\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("agurk"),
            keywords: &["agurk", "grønnsak", "mat", "sylteagurk"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("काक\u{94d}रो"),
            keywords: &["अचार", "काक\u{94d}रो", "खाना", "तरकारी"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("komkommer"),
            keywords: &["augurk", "groente", "komkommer", "voedsel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("agurk"),
            keywords: &["agurk", "grønsak", "mat", "sylteagurk"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b3e}କ\u{b41}ଡ\u{b3c}\u{b3f}"),
            keywords: &[
                "କ\u{b3e}କ\u{b41}ଡ\u{b3c}\u{b3f}",
                "ଖ\u{b3e}ଦ\u{b4d}ୟ । ଆଚ\u{b3e}ର । ପର\u{b3f}ପର\u{b3f}ବ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਖੀਰਾ"),
            keywords: &["ਅਚਾਰ", "ਖੀਰਾ", "ਭ\u{a4b}ਜਨ", "ਸਬਜ\u{a3c}ੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کھیرا"),
            keywords: &["اچار", "خوراک", "سبزیاں", "کھیرا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kọkúmba"),
            keywords: &[
                "Fud",
                "Kọkúmba",
                "Kọ\u{301}kúmba",
                "Vẹ\u{301}jítébul",
                "Wọ\u{301}n Vẹ\u{301}jítébul Wé Im Nem Na Píkul",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("ogórek"),
            keywords: &["jedzenie", "korniszon", "ogórek", "pikle", "warzywo"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بادرنګ"),
            keywords: &["بادرنګ", "بادرنګ، خواړه، اچار، سبزي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pepino"),
            keywords: &["comida", "legume", "pepino", "picles"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["legume", "pepino", "pickle", "picles"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pepino"),
            keywords: &["mikhuna", "pepinillos", "pepino", "vegetal"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("castravete"),
            keywords: &["castravete", "legume", "murătură", "mâncare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1070"),
            keywords: &["E10-1070"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("огурец"),
            keywords: &["еда", "овощ", "огурец", "соленье"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("kokombure"),
            keywords: &["ibiribwa", "imboga", "kokombure"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("کهيرو"),
            keywords: &["کهيرو", "کهيرو، آچار، ڀاڄي، کاڌو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd2}ප\u{dd2}ඤ\u{dca}ඤ"),
            keywords: &[
                "අච\u{dca}ච\u{dcf}ර\u{dd4}",
                "කෑම",
                "ප\u{dd2}ප\u{dd2}ඤ\u{dca}ඤ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("uhorka"),
            keywords: &[
                "jedlo",
                "kyslá",
                "nakladaná",
                "uhorka",
                "zaváraná",
                "zelenina",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kumara"),
            keywords: &["hrana", "kumara", "zelenjava"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qajaar"),
            keywords: &["cunto", "khudrad", "qajaar", "qajaar dhanaanin"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kastravec"),
            keywords: &["kastravec", "perime", "turshi", "ushqim"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("краставац"),
            keywords: &["краставац", "поврће", "храна"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("krastavac"),
            keywords: &["hrana", "krastavac", "povrće"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("gurka"),
            keywords: &["grönsak", "gurka", "mat"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("tango"),
            keywords: &["chakula", "mboga", "tango", "tango pepeta"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வெள\u{bcd}ளரி"),
            keywords: &["உணவு", "க\u{bbe}ய\u{bcd}கறி", "வெள\u{bcd}ளரி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c40}ర ద\u{c4b}సక\u{c3e}య"),
            keywords: &[
                "ఆహ\u{c3e}రం",
                "క\u{c40}ర ద\u{c4b}సక\u{c3e}య",
                "కూరగ\u{c3e}య",
                "పచ\u{c4d}చడ\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("бодиринг"),
            keywords: &["бодиринг", "парварда", "сабзавот", "ғизо"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แตงกวา"),
            keywords: &["ผ\u{e31}ก", "อาหาร", "แตง", "แตงกวา"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("hyýar"),
            keywords: &["duzlanan", "gök önüm", "hyýar", "iýmit"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kiukamipa"),
            keywords: &["kiukamipa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("salatalık"),
            keywords: &["salatalık", "sebze", "turşu", "yiyecek"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تەرخەمەك"),
            keywords: &["ئاچچىق تەرخەمەك", "تەرخەمەك", "كۆكتات", "يېمەكلىك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("огірок"),
            keywords: &["корнішон", "овоч", "огірок", "окірок", "їжа"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کھیرا"),
            keywords: &["خوراک", "سبزی", "سلاد", "کھیرا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("bodring"),
            keywords: &["bodring", "sabzavot", "taom", "tuzlama"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("dưa chuột"),
            keywords: &["dưa chua", "dưa chuột", "thức ăn", "thực vật"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("komkombar"),
            keywords: &["komjomlaat", "komkombar", "lekk", "meññeef", "njaxas"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inkonkomire"),
            keywords: &["i-pickle", "imifuno", "inkonkomire", "ukutya"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Kùkúmbà"),
            keywords: &["Kùkúmbà", "kùkúmbà", "píkù", "ónjẹ", "ẹ\u{300}fọ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("青瓜"),
            keywords: &["泡菜", "蔬菜", "青瓜", "食物"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("青瓜"),
            keywords: &["泡菜", "蔬菜", "青瓜", "食物"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("黄瓜"),
            keywords: &["泡菜", "蔬菜", "食物", "黄瓜"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("小黃瓜"),
            keywords: &["小黃瓜", "蔬菜", "食物"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("青瓜"),
            keywords: &["蔬菜", "青瓜", "青瓜切片"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukhukhumba"),
            keywords: &["amaveji", "gqumisa", "ukhukhumba", "ukudla"],
        },
    ],
};
#[doc = "🥬"]
pub const LEAFY_GREEN: crate::Emoji = crate::Emoji {
    glyph: "🥬",
    codepoint: "1F96C",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "leafy green",
    group: "Food & Drink",
    subgroup: "food-vegetable",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("groen blare"),
            keywords: &["blaarslaai", "groen blare", "kool", "krulkool"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሰላጣ"),
            keywords: &["ሰላጣ", "ቅጠላ ቅጠል", "አሜሳ", "የቻይና ሰላጣ", "ጥቅል ጎመን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("خضار ورقي"),
            keywords: &["خس", "خضار ورقي", "خضروات ورقية", "قرنبيط", "كرنب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("সেউজীয\u{9bc}\u{9be} প\u{9be}তৰ প\u{9be}চলি"),
            keywords: &[
                "কবি",
                "বন\u{9cd}ধ\u{9be} কবি",
                "বোক চয\u{9bc}",
                "লেট\u{9c1}ছ",
                "সেউজীয\u{9bc}\u{9be} প\u{9be}তৰ প\u{9be}চলি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kahı"),
            keywords: &["göyərti", "kahı", "kələm", "salat"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("зеляніна"),
            keywords: &["бок-чой", "зеляніна", "кале", "капуста", "латук"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("листен зеленчук"),
            keywords: &["зеле", "кейл", "листен зеленчук", "салата", "спанак"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("সব\u{9c1}জ শ\u{9be}ক প\u{9be}ত\u{9be}"),
            keywords: &[
                "প\u{9be}ত\u{9be} কপি",
                "বক চোই",
                "ব\u{9be}\u{981}ধ\u{9be}কপি",
                "লেট\u{9c1}স",
                "সব\u{9c1}জ শ\u{9be}ক প\u{9be}ত\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("legumaj glas"),
            keywords: &["legumaj", "legumaj glas", "letuz"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("lisnato povrće"),
            keywords: &["kelj", "kupus", "lisnato povrće", "zelena salata"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("fulla verda"),
            keywords: &["bleda xinesa", "col", "enciam", "fulla verda", "kale"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄦𑄬𑄣\u{11134} 𑄛𑄘"),
            keywords: &["𑄦𑄬𑄣\u{11134} 𑄛𑄘"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎢᏤᎢᏳᏍᏗ ᎤᎦᎶᎦ"),
            keywords: &[
                "ᎠᎪᏍᏓᎩᏍᏗ",
                "ᎢᏤᎢᏳᏍᏗ ᎤᎦᎶᎦ",
                "ᎤᏔᎾ ᏧᎦᎶᎦ ᏧᎦᏅᏕᎾ",
                "ᏓᎶᏂᎨᏍᏛ ᏂᏓᏳᎶᏒ ᏧᎦᏅᏕᎾ",
                "ᏧᎦᏅᏕᎾ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("salátové listy"),
            keywords: &[
                "bok čoj",
                "kapusta",
                "pak čoj",
                "salát",
                "salátové listy",
                "zelí",
                "čínské",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("gwyrdd deiliog"),
            keywords: &["bok choy", "cêl", "gwyrdd deiliog", "kale", "letys"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bladgrønt"),
            keywords: &["bladgrønt", "grønkål", "kål", "pak choi", "salat"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Blattgemüse"),
            keywords: &[
                "Blattgemüse",
                "Gemüse",
                "Grünzeug",
                "Kohl",
                "Salat",
                "Spinat",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πράσινο φυλλώδες"),
            keywords: &[
                "λάχανο",
                "λαχανίδα",
                "μαρούλι",
                "μποκ τσόι",
                "πράσινο φυλλώδες",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("leafy green"),
            keywords: &["bok choy", "cabbage", "kale", "leafy green", "lettuce"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &[
                "bok choy",
                "cabbage",
                "kale",
                "leafy green",
                "lettuce",
                "pak choi",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &[
                "bok choy",
                "cabbage",
                "kale",
                "leafy green",
                "lettuce",
                "pak choi",
            ],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("verdura de hoja verde"),
            keywords: &[
                "bok choy",
                "col",
                "kale",
                "lechuga",
                "pak choi",
                "verdura de hoja verde",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("verdura de hoja"),
            keywords: &["col", "kale", "lechuga", "repollo chino", "verdura de hoja"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("lehtköögivili"),
            keywords: &[
                "hiina kapsas",
                "kapsas",
                "lehtkapsas",
                "lehtköögivili",
                "lehtsalat",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("barazki hostodun"),
            keywords: &["aza", "barazki hostodun", "bok choy", "kale", "letxuga"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("برگ\u{200c}سبز"),
            keywords: &["برگ\u{200c}سبز", "کاهو", "کلم", "کلم بروکلی", "کلم برگ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("lehtivihannes"),
            keywords: &[
                "kaali",
                "lehtivihannes",
                "pinaattikiinankaali",
                "salaatinlehti",
                "salaatti",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("madahong gulay"),
            keywords: &[
                "bok choy",
                "gulay",
                "lettuce",
                "madahong gulay",
                "petsay",
                "repolyo",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("salatblað"),
            keywords: &["blað", "grønkál", "grønmeti", "salat", "salatblað"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("légume à feuilles vertes"),
            keywords: &[
                "chou",
                "chou chinois",
                "chou frisé",
                "chou pommé",
                "laitue",
                "légume à feuilles vertes",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "chinois",
                "chou",
                "frisé",
                "laitue",
                "légume à feuilles vertes",
                "pommé",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("glasra duilleach"),
            keywords: &["bok choy", "cabáiste", "cál", "glasra duilleach", "leitís"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("càl"),
            keywords: &["bok choy", "càl", "leatas"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("verdura de folla"),
            keywords: &["acelgas", "espinacas", "leituga", "verdura de folla"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લીલા પા\u{a82}દળાવાળા"),
            keywords: &[
                "ક\u{ac7}લ",
                "કોબી",
                "બૉક ચોય",
                "લીલા પા\u{a82}દળાવાળા",
                "લ\u{ac7}ટિસ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עלים ירוקים"),
            keywords: &["חסה", "כרוב", "עלים ירוקים", "קייל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("हरी पत\u{94d}त\u{947}दार"),
            keywords: &[
                "गोभी",
                "पत\u{94d}ता गोभी",
                "बोक चॉय",
                "सलाद पत\u{94d}ता",
                "हरी पत\u{94d}त\u{947}दार",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lisnato povrće"),
            keywords: &[
                "blitva",
                "kelj",
                "kupus",
                "lisnato povrće",
                "salata",
                "zelena salata",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("leveles zöldség"),
            keywords: &["kel", "káposzta", "kínai kel", "leveles zöldség", "saláta"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մարոլ"),
            keywords: &["կաղամբ", "հազար", "մարոլ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("selada hijau"),
            keywords: &["bokcoy", "kale", "kubis", "selada", "selada hijau"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kál"),
            keywords: &["bok choi", "grænkál", "hvítkál", "kál"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("verdure a foglia"),
            keywords: &[
                "bok choy",
                "cavolo nero",
                "kale",
                "lattuga",
                "verdure a foglia",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("葉野菜"),
            keywords: &["キャベツ", "ケール", "チンゲン菜", "レタス", "葉野菜"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("selada ijo"),
            keywords: &["bok coi", "kol", "kubis", "selada", "selada ijo"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სალათის ფოთოლი"),
            keywords: &["კომბოსტო", "სალათი", "სალათის ფოთოლი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("Tidelt n iferrawen izegzawen"),
            keywords: &["Tidelt n iferrawen izegzawen"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жасыл жапырақ"),
            keywords: &[
                "бок чой",
                "жасыл жапырақ",
                "латук",
                "орамжапырақ",
                "қырыққабат",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បន\u{17d2}លែស\u{17d2}ល\u{17b9}កបៃតង"),
            keywords: &[
                "បន\u{17d2}លែស\u{17d2}ល\u{17b9}កបៃតង",
                "ប\u{17d2}លក\u{17cb}ចយ",
                "សាលាដ",
                "ស\u{17d2}ពៃ",
                "ស\u{17d2}ពៃក\u{17d2}ដោប",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹಸ\u{cbf}ರ\u{cbf}ನ ಎಲ\u{cc6}"),
            keywords: &[
                "ಕಾಲ\u{cc6}",
                "ಕೋಸು",
                "ಬಾಕ\u{ccd} ಚೋ",
                "ಲ\u{cc6}ಟ\u{cc6}ಸ\u{ccd}",
                "ಹಸ\u{cbf}ರ\u{cbf}ನ ಎಲ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("녹색 채소"),
            keywords: &["녹색 채소", "상추", "양배추", "청경채", "케일"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पाल\u{947} भाजी"),
            keywords: &[
                "काल\u{947}",
                "कोबी",
                "पाचवी भाजी",
                "पाल\u{947} भाजी",
                "बॉक छोय",
                "ल\u{947}ट\u{94d}य\u{941}स",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("көк чөптөр"),
            keywords: &["борщ", "капуста", "кытай капустасы", "көк чөптөр", "салат"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໃບໄມ\u{ec9}ຂຽວ"),
            keywords: &[
                "ກາລ\u{ecd}າປ\u{eb5}",
                "ຜ\u{eb1}ກກາດຂາວ",
                "ຜ\u{eb1}ກສະລ\u{eb1}ດຫ\u{ecd}\u{ec8}",
                "ໃບສະລ\u{eb1}ດ",
                "ໃບໄມ\u{ec9}ຂຽວ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("lapinė daržovė"),
            keywords: &["kininis kopūstas", "kopūstas", "lapinė daržovė", "salota"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("lapu dārzenis"),
            keywords: &[
                "kacenkāposts",
                "kāposts",
                "lapu dārzenis",
                "lapu kāposts",
                "Ķīnas kāposts",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("зелени листови"),
            keywords: &[
                "зелена салата",
                "зелени листови",
                "зелка",
                "кинеска зелка",
                "марула",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പച\u{d4d}ചില നിറഞ\u{d4d}ഞ"),
            keywords: &["പച\u{d4d}ചില നിറഞ\u{d4d}ഞ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("навчит ногоо"),
            keywords: &[
                "байцаа",
                "буржгар байцаа",
                "навчит ногоо",
                "ногоон навч",
                "юуцай",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("हिरवी भाजी"),
            keywords: &[
                "एक प\u{94d}रकारची कोबी",
                "कोबी",
                "बॉक चॉय",
                "ल\u{947}ट\u{94d}य\u{942}स",
                "हिरवी भाजी",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("sayuran hijau"),
            keywords: &[
                "kubis",
                "kubis daun",
                "sawi putih",
                "sayuran hijau",
                "selada",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အရ\u{103d}က\u{103a}ဖားဖား သစ\u{103a}ရ\u{103d}က\u{103a}စ\u{102d}မ\u{103a}း"),
            keywords: &[
                "က\u{102d}\u{102f}က\u{103a}လန\u{103a}",
                "ဂေါ\u{103a}ဖ\u{102e}ထ\u{102f}ပ\u{103a}",
                "ဆလတ\u{103a}ရ\u{103d}က\u{103a}",
                "တရ\u{102f}တ\u{103a} ဂေါ\u{103a}ဖ\u{102e}",
                "အရ\u{103d}က\u{103a}ဖားဖား သစ\u{103a}ရ\u{103d}က\u{103a}စ\u{102d}မ\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bladgrønnsaker"),
            keywords: &[
                "bladgrønnsaker",
                "bladsalat",
                "grønnkål",
                "kinakål",
                "kål",
                "pak choy",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पात रङको हरियो"),
            keywords: &[
                "क\u{947}ल",
                "चिनिया\u{901} बन\u{94d}दा",
                "पात रङको हरियो",
                "बन\u{94d}दा",
                "ल\u{947}टिस",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bladgroente"),
            keywords: &["bladgroente", "boerenkool", "kool", "paksoi", "sla"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bladgrønsaker"),
            keywords: &[
                "bladgrønsaker",
                "bladsalat",
                "grønkål",
                "kinakål",
                "kål",
                "pak choy",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସବ\u{b41}ଜ ପତ\u{b4d}ର"),
            keywords: &[
                "କ\u{b3e}ଲେ",
                "ବନ\u{b4d}ଧ\u{b3e} କୋବ\u{b3f}",
                "ବୋକ ଚୋୟ",
                "ଲେଟ\u{b41}ସ\u{b4d}\u{200c}",
                "ସବ\u{b41}ଜ ପତ\u{b4d}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਹਰੀਆ\u{a02} ਪ\u{a71}ਤ\u{a47}ਦਾਰ ਸਬਜ\u{a3c}ੀਆ\u{a02}"),
            keywords: &[
                "ਕ\u{a47}ਲ",
                "ਗ\u{a4b}ਭੀ",
                "ਪਾਲਕ",
                "ਬ\u{a4c}ਕ ਚ\u{a4c}ਏ",
                "ਹਰੀਆ\u{a02} ਪ\u{a71}ਤ\u{a47}ਦਾਰ ਸਬਜ\u{a3c}ੀਆ\u{a02}",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Grín Lif"),
            keywords: &[
                "Chainíz Kábej Wé Im Nem Na Bọ\u{301}k Choi",
                "Grín Lif",
                "Grín Vẹ\u{301}jítébul Wé Gẹ\u{301}t Plẹ\u{301}ntí Lif",
                "Kábej",
                "Lẹ\u{301}tus",
                "Wọ\u{301}n Vẹ\u{301}jítébul Wé Im Nem Na Kel",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zielenina liściasta"),
            keywords: &[
                "bok choy",
                "jarmuż",
                "kapusta",
                "kapusta pekińska",
                "sałata",
                "zielenina liściasta",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سلاد"),
            keywords: &["بکچوي، بند ګوپي، کيل، سلاد، کاهو", "سلاد"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("verdura"),
            keywords: &["alface", "bok choy", "couve", "repolho", "verdura"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("qʼumir laqhikunawan"),
            keywords: &[
                "bok choy",
                "col rizada",
                "lechuga",
                "qʼumir laqhikunawan",
                "repollo",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("verdețuri"),
            keywords: &[
                "lăptucă",
                "salată",
                "varză",
                "varză chinezească",
                "varză kale",
                "verdețuri",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-008"),
            keywords: &["E11-008"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("зеленый салат"),
            keywords: &[
                "ботва",
                "зеленый салат",
                "капуста",
                "латук",
                "листья салата",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پتيدار سائو"),
            keywords: &["بوڪ چوئي", "پتيدار سائو", "ڪيل", "گوبي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හර\u{dd2}ත කොළ"),
            keywords: &[
                "කෙල\u{dca}",
                "ගෝව",
                "බොක\u{dca} චෝය\u{dd2}",
                "ලෙට\u{dd2}ස\u{dca}",
                "හර\u{dd2}ත කොළ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("listová zelenina"),
            keywords: &["kapusta", "kel", "listová zelenina", "šalát"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("listnato zelena"),
            keywords: &[
                "kitajsko zelje",
                "listnato zelena",
                "listni ohrovt",
                "solata",
                "zelje",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("caleenta cagaaran"),
            keywords: &[
                "ansalaata",
                "caggaar",
                "caleen caggaar",
                "caleenta cagaaran",
                "kaabash",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("sallatë"),
            keywords: &["lakër", "marule", "sallatë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лиснато зелено поврће"),
            keywords: &[
                "блитва",
                "зелена салата",
                "кељ",
                "купус",
                "лиснато зелено поврће",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lisnato zeleno povrće"),
            keywords: &[
                "blitva",
                "kelj",
                "kupus",
                "lisnato zeleno povrće",
                "zelena salata",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("sallat"),
            keywords: &["bok choy", "grönkål", "kål", "sallad", "sallat"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("sukumawiki"),
            keywords: &["bok choy", "kabichi", "mchicha", "saladi", "sukumawiki"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பச\u{bcd}சை க\u{bbe}ய\u{bcd}கறி"),
            keywords: &[
                "கேபேஜ\u{bcd}",
                "பச\u{bcd}சை க\u{bbe}ய\u{bcd}கறி",
                "போக\u{bcd} சோய\u{bcd}",
                "முட\u{bcd}டைகோஸ\u{bcd}",
                "லெட\u{bcd}யூஸ\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఆకుకూర"),
            keywords: &[
                "ఆకుకూర",
                "క\u{c47}ల\u{c4d}",
                "క\u{c4d}య\u{c3e}బ\u{c47}జ\u{c40}",
                "చ\u{c48}న\u{c40}స\u{c4d} క\u{c4d}య\u{c3e}బ\u{c47}జ\u{c40}",
                "ల\u{c46}ట\u{c4d}యూస\u{c4d}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ผ\u{e31}กใบเข\u{e35}ยว"),
            keywords: &[
                "กะหล\u{e48}ำปล\u{e35}",
                "บ\u{e47}อคชอย",
                "ผ\u{e31}กกาดหอม",
                "ผ\u{e31}กคะน\u{e49}า",
                "ผ\u{e31}กใบเข\u{e35}ยว",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýaprakly ýaşyl"),
            keywords: &["bokçoý", "kaleý", "kelem", "latuk", "ýaprakly ýaşyl"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("lētisi"),
            keywords: &["lētisi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yeşil yapraklı sebze"),
            keywords: &[
                "karalahana",
                "lahana",
                "marul",
                "yeşil yapraklı sebze",
                "çin lahanası",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("листя салату"),
            keywords: &[
                "бок-чой",
                "зелень",
                "капуста",
                "листок",
                "листя",
                "листя салату",
                "салат",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ہرے پتوں والی سبزی"),
            keywords: &[
                "بند گوبھی",
                "سلاد پتہ",
                "چینی بند گوبھی",
                "ہرے پتوں والی سبزی",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("salat bargi"),
            keywords: &["botva", "karam", "latuk", "salat", "salat bargi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("xanh lá"),
            keywords: &["cải bắp", "cải thìa", "cải xoăn", "rau diếp", "xanh lá"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("菜"),
            keywords: &["捲心菜", "生菜", "白菜", "羽衣甘藍", "菜"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("菜"),
            keywords: &["卷心菜", "生菜", "白菜", "羽衣甘蓝", "菜"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("绿叶蔬菜"),
            keywords: &["圆白菜", "小白菜", "甘蓝", "绿叶蔬菜", "莴苣"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("綠葉蔬菜"),
            keywords: &["小白菜", "甘藍菜", "綠葉蔬菜", "羽衣甘藍", "萵苣"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("綠色蔬菜"),
            keywords: &["小白菜", "甘藍菜", "綠色蔬菜", "羽衣甘藍", "萵苣"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("leafy green"),
            keywords: &["bok choy", "cabbage", "kale", "leafy green", "lettuce"],
        },
    ],
};
#[doc = "🥦"]
pub const BROCCOLI: crate::Emoji = crate::Emoji {
    glyph: "🥦",
    codepoint: "1F966",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "broccoli",
    group: "Food & Drink",
    subgroup: "food-vegetable",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("broccoli"),
            keywords: &["broccoli", "wilde kool"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ብሮኮሊ"),
            keywords: &["ብሮኮሊ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بروكولي"),
            keywords: &["بروكلي", "بروكولي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ব\u{9cd}ৰ’কলি"),
            keywords: &["বনৰীয\u{9bc}\u{9be} বন\u{9cd}ধ\u{9be} কবি", "ব\u{9cd}ৰ’কলি"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("brokkoli"),
            keywords: &["brokkoli", "yabanı kələm"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("брокалі"),
            keywords: &["брокалі", "дзікая капуста"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("броколи"),
            keywords: &["броколи", "диво зеле"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ফ\u{9c1}লকপি"),
            keywords: &[
                "ওয\u{9bc}\u{9be}ইল\u{9cd}ড ক\u{9cd}য\u{9be}বেজ",
                "ফ\u{9c1}লকপি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("brikoli"),
            keywords: &["brikoli", "legumaj"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("brokula"),
            keywords: &["brokula", "divlji kupus"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bròcoli"),
            keywords: &["bròcoli", "bròquil", "col"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄝\u{11133}𑄢\u{11127}\u{1112a}𑄇\u{11134}\u{11127}𑄣\u{11128}"),
            keywords: &["𑄝\u{11133}𑄢\u{11127}\u{1112a}𑄇\u{11134}\u{11127}𑄣\u{11128}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏧᎦᏅᏕᎾ ᎤᏍᏗ"),
            keywords: &["ᏣᎦᏅᏕᎾ ᎢᎾᎨ ᎡᎯ", "ᏧᎦᏅᏕᎾ ᎤᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("brokolice"),
            keywords: &["brokolice", "brukev", "kapusta", "rostlina", "zelenina"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("brocoli"),
            keywords: &["bresych gwyllt", "brocoli"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("broccoli"),
            keywords: &["broccoli", "kål"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Brokkoli"),
            keywords: &["Brokkoli", "Gemüsekohl"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μπρόκολο"),
            keywords: &["άγριο λάχανο", "μπρόκολο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("broccoli"),
            keywords: &["broccoli", "wild cabbage"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("brócoli"),
            keywords: &["brócoli", "col", "repollo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["brócoli", "verdura"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("brokoli"),
            keywords: &["brokoli", "metskapsas"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("brokoli"),
            keywords: &["aza basati", "brokoli"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بروکلی"),
            keywords: &["بروکلی", "کلم"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("parsakaali"),
            keywords: &["broccoli", "parsakaali"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("broccoli"),
            keywords: &["broccoli", "wild cabbage"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("brokkoli"),
            keywords: &["brokkoli", "spergilkál"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("brocoli"),
            keywords: &["brocoli", "chou sauvage", "légume"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("brocoli"),
            keywords: &["brocoli", "chou sauvage"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("brocailí"),
            keywords: &["brocailí", "cabáiste fiáin"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("brocail"),
            keywords: &["brocail", "càl"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("brócoli"),
            keywords: &["brócoli"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બ\u{acd}રોકોલી"),
            keywords: &["બ\u{acd}રોકોલી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("broccoli"),
            keywords: &["broccoli", "kabeji na daji"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ברוקולי"),
            keywords: &["ברוקולי", "כרוב פראי"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ब\u{94d}रोकली"),
            keywords: &["ज\u{902}गली पत\u{94d}ता गोभी", "ब\u{94d}रोकली"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("brokula"),
            keywords: &["biljka", "brokula", "povrće"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("brokkoli"),
            keywords: &["brokkoli", "vadkáposzta"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բրոկկոլի"),
            keywords: &["բրոկկոլի", "վայրի կաղամբ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("brokoli"),
            keywords: &["brokoli", "kubis"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akwụkwọnri bèkee"),
            keywords: &["akwụkwọnri bèkee", "akwụkwọnri kabeji"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("brokkólí"),
            keywords: &["brokkólí", "garðakál"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("broccoli"),
            keywords: &["broccoli", "cavolo nero"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ブロッコリー"),
            keywords: &["ブロッコリー", "野菜"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("brokoli"),
            keywords: &["brokoli", "kubis liar"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბროკოლი"),
            keywords: &["ბროკოლი", "კომბოსტო"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("брокколи"),
            keywords: &["брокколи"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ផ\u{17d2}កាស\u{17d2}ពៃខៀវ"),
            keywords: &[
                "ផ\u{17d2}កាស\u{17d2}ពៃខៀវ",
                "ស\u{17d2}ពៃក\u{17d2}ដោបព\u{17d2}រៃ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{ccd}ರೊಕೋಲ\u{cbf}"),
            keywords: &[
                "ಬ\u{ccd}ರೊಕೋಲ\u{cbf}",
                "ವೈಲ\u{ccd}ಡ\u{ccd} ಕ\u{ccd}ಯಾಬೇಜ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("브로콜리"),
            keywords: &["브로콜리"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ब\u{94d}रोकोली"),
            keywords: &["ब\u{94d}रोकोली", "रानटी कोबी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("брокколи"),
            keywords: &["брокколи", "жапайы капуста"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Brokkoli"),
            keywords: &["Brokkoli", "wëlle Kabes"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ບຣ\u{eb1}ອກໂຄລ\u{eb5}"),
            keywords: &["ກະຫລ\u{ec8}ຳປ\u{eb5}ປ\u{ec8}າ", "ບຣ\u{eb1}ອກໂຄລ\u{eb5}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("brokolis"),
            keywords: &["brokolis", "laukinis kopūstas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("brokoļi"),
            keywords: &["brokoļi", "dārza kāposts"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("porokori"),
            keywords: &["kāpeti kōraha", "porokori"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("брокола"),
            keywords: &["брокола", "дива зелка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ബ\u{d4d}രോക\u{d4d}കോളി"),
            keywords: &["പച\u{d4d}ചക\u{d4d}കറി", "ബ\u{d4d}രോക\u{d4d}കോളി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цэцэгт байцаа"),
            keywords: &["зэрлэг цэцэгт байцаа", "цэцэгт байцаа"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ब\u{94d}रॉकली"),
            keywords: &["ब\u{94d}रॉकली", "रानटी कोबी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("brokoli"),
            keywords: &["brokoli", "kubis liar"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("brokkoli"),
            keywords: &["brokkoli", "kaboċċa selvaġġa"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပန\u{103a}းဂေါ\u{103a}ဖ\u{102e}စ\u{102d}မ\u{103a}း"),
            keywords: &[
                "ဂေါ\u{103a}ဖ\u{102e}ထ\u{102f}ပ\u{103a} အရ\u{102d}\u{102f}င\u{103a}း",
                "ပန\u{103a}းဂေါ\u{103a}ဖ\u{102e}စ\u{102d}မ\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("brokkoli"),
            keywords: &["brokkoli", "grønnsak"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ब\u{94d}रोकाउली"),
            keywords: &["ब\u{94d}रोकाउली", "सम\u{941}द\u{94d}री बन\u{94d}दा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("broccoli"),
            keywords: &["broccoli", "wilde kool"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("brokkoli"),
            keywords: &["brokkoli", "grønsak"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b4d}ରକୋଲ\u{b3f}"),
            keywords: &["ବଣ ବନ\u{b4d}ଧ\u{b3e}କୋବ\u{b3f}", "ବ\u{b4d}ରକୋଲ\u{b3f}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a4d}ਰ\u{a4c}ਕਲੀ"),
            keywords: &["ਬ\u{a4d}ਰ\u{a4c}ਕਲੀ", "ਬ\u{a70}ਦਗ\u{a4b}ਭੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("شاخ گوبھی"),
            keywords: &["جنگلی گوبھی", "شاخ گوبھی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Brọ\u{301}kọ\u{301}li"),
            keywords: &["Brọ\u{301}kọ\u{301}li", "Búsh Kábej"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("brokuł"),
            keywords: &["brokuł"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ګوپې"),
            keywords: &["ګوپې", "ګوپې، ځنګلي بند ګوپي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("brócolis"),
            keywords: &["brócolis"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("brócolos"),
            keywords: &["brócolos", "legume"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("brocoli"),
            keywords: &["brocoli", "repollo salvaje"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("broccoli"),
            keywords: &["broccoli", "conopidă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1090"),
            keywords: &["E10-1090"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("брокколи"),
            keywords: &["брокколи", "капуста"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("udushu"),
            keywords: &["amashu gakondo", "udushu"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("شاخ گوبي"),
            keywords: &["جهنگلي گوبي", "شاخ گوبي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බ\u{dca}රොකොල\u{dd3}"),
            keywords: &["බ\u{dca}රොකොල\u{dd3}", "වල\u{dca} ගෝව\u{dcf}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("brokolica"),
            keywords: &["brokolica", "kapusta"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("brokoli"),
            keywords: &["brokoli"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("barakooli"),
            keywords: &["barakooli", "kaabashka diggaaga"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("brokoli"),
            keywords: &["brokoli", "lakër e egër"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("броколи"),
            keywords: &["броколи", "брокуле", "дивљи купус"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("brokoli"),
            keywords: &["brokoli", "brokule", "divlji kupus"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("broccoli"),
            keywords: &["broccoli", "kål"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("brokoli"),
            keywords: &["brokoli", "kabichi ya msitu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ப\u{bcd}ரொக\u{bcd}கோலி"),
            keywords: &["ப\u{bcd}ரொக\u{bcd}கோலி", "முட\u{bcd}டைகோஸ\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బ\u{c4d}ర\u{c4b}కల\u{c40}"),
            keywords: &[
                "అడవ\u{c3f} క\u{c4d}య\u{c3e}బ\u{c47}జ\u{c40}",
                "బ\u{c4d}ర\u{c4b}కల\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("брокколи"),
            keywords: &["брокколи", "карами ёбоӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("บรอกโคล\u{e35}"),
            keywords: &["บรอกโคล\u{e35}", "บร\u{e47}อกโคล\u{e35}\u{e48}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("brokkoli"),
            keywords: &["brokkoli", "ýabany kelem"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kāpisi"),
            keywords: &["kāpisi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("brokoli"),
            keywords: &["brokoli", "yabani lahana"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يېشىل-چېچەك"),
            keywords: &["ياۋا يېسىۋېلەك", "يېشىل-چېچەك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("броколі"),
            keywords: &["броколі", "кучерява", "цвітна капуста"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("شاخ گوبھی"),
            keywords: &["جنگلی گوبھی", "شاخ گوبھی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("brokkoli"),
            keywords: &["brokkoli", "karam", "yovvoyi karam"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("xúp lơ xanh"),
            keywords: &["cải bắp dại", "xúp lơ xanh"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("brokoli"),
            keywords: &["brokoli", "supame"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-broccoli"),
            keywords: &["i-broccoli", "ikhaphetshu lasendle"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ewé ẹlẹ\u{301}fọ\u{300}ọ\u{301}"),
            keywords: &["ewé ẹlẹ\u{301}fọ\u{300}ọ\u{301}", "kabeji ìbílẹ\u{300}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("西蘭花"),
            keywords: &["西蘭花", "野生白菜"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("西兰花"),
            keywords: &["西兰花", "野生白菜"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("西兰花"),
            keywords: &["甘蓝", "西兰花"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("花椰菜"),
            keywords: &["花椰菜"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("西蘭花"),
            keywords: &["西蘭花"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-bhulokholi"),
            keywords: &["i-bhulokholi", "iklabishi lasendle"],
        },
    ],
};
#[doc = "🧄"]
pub const GARLIC: crate::Emoji = crate::Emoji {
    glyph: "🧄",
    codepoint: "1F9C4",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "garlic",
    group: "Food & Drink",
    subgroup: "food-vegetable",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("knoffel"),
            keywords: &["geurmiddel", "knoffel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ነጭ ሽንኩርት"),
            keywords: &["ማጣፈጫ", "ነጭ ሽንኩርት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ثوم"),
            keywords: &["ثوم", "طعم", "نكهة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("নহৰ\u{9c1}"),
            keywords: &["নহৰ\u{9c1}", "মছল\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sarımsaq"),
            keywords: &["dadlandırma", "sarımsaq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("часнок"),
            keywords: &["прыправа", "часнок"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("чесън"),
            keywords: &["подправка", "чесън"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("রস\u{9c1}ন"),
            keywords: &["রস\u{9c1}ন", "স\u{9cd}ব\u{9be}দ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kignen"),
            keywords: &["kignen", "legumaj", "temz-boued"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("bijeli luk"),
            keywords: &["bijeli luk", "začinjavanje hrane"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("all"),
            keywords: &["all", "aromatitzant"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏃᏳᏟ"),
            keywords: &["ᎠᏑᏴᏗ", "ᏃᏳᏟ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("česnek"),
            keywords: &["koření", "ochucování", "zelenina", "česnek"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("garlleg"),
            keywords: &["cyflas", "garlleg"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("hvidløg"),
            keywords: &["hvidløg", "smag"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Knoblauch"),
            keywords: &["Geschmack", "Knoblauch"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σκόρδο"),
            keywords: &["άρωμα", "γεύση", "σκόρδο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("garlic"),
            keywords: &["flavoring", "garlic"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["flavouring", "garlic"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["flavouring", "garlic"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["flavouring", "garlic"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["flavouring", "garlic"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ajo"),
            keywords: &["ajo", "condimento", "vampiro"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["ajo", "condimento"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("küüslauk"),
            keywords: &["küüslauk", "maitseaine"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("baratxuria"),
            keywords: &["baratxuria", "ongailua"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("سیر"),
            keywords: &["سیر", "چاشنی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("valkosipuli"),
            keywords: &["mauste", "valkosipuli"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bawang"),
            keywords: &["bawang", "pampalasa"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hvítleykur"),
            keywords: &["hvítleykur", "matur", "smakkur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("ail"),
            keywords: &["ail", "assaisonnement", "condiment", "légume"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["ail", "aromatisant", "assaisonnement", "condiment"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("gairleog"),
            keywords: &["blasóir", "gairleog"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("creamh"),
            keywords: &["blas", "blasachadh", "creamh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("allo"),
            keywords: &["allo", "cheiro", "condimento"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લસણ"),
            keywords: &["ખાદ\u{acd}યપદાર\u{acd}થ", "લસણ"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שום"),
            keywords: &["שום", "תבלין"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("लहस\u{941}न"),
            keywords: &["मसाला", "लहस\u{941}न"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("češnjak"),
            keywords: &["povrće", "češnjak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fokhagyma"),
            keywords: &["fokhagyma", "ízesítés"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սխտոր"),
            keywords: &["համեմունք", "սխտոր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bawang putih"),
            keywords: &["bawang putih", "bumbu dapur"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hvítlaukur"),
            keywords: &["bragðbætir", "hvítlaukur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("aglio"),
            keywords: &["aglio", "insaporire", "insaporitore", "spicchio d’aglio"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ニンニク"),
            keywords: &["におい", "ニンニク", "薬味", "野菜", "香り"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bawang putih"),
            keywords: &["bawang putih", "panyedhep rasa"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ნიორი"),
            keywords: &["არომატიზატორი", "ნიორი", "საკმაზი", "სუნელი", "სუნი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сарымсақ"),
            keywords: &["дәмдеуіш", "сарымсақ"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ខ\u{17d2}ទ\u{17b9}មស"),
            keywords: &[
                "ខ\u{17d2}ទ\u{17b9}មស",
                "គ\u{17d2}រឿងបន\u{17d2}ថែមរសជាត\u{17b7}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{cc6}ಳ\u{ccd}ಳುಳ\u{ccd}ಳ\u{cbf}"),
            keywords: &[
                "ಫ\u{ccd}ಲೇವರ\u{cbf}ಂಗ\u{ccd}",
                "ಬ\u{cc6}ಳ\u{ccd}ಳುಳ\u{ccd}ಳ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("마늘"),
            keywords: &["마늘", "조미료"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("लस\u{942}ण"),
            keywords: &["लस\u{942}ण", "स\u{94d}वाद"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("сарымсак"),
            keywords: &["сарымсак", "татымал"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກະ\u{200b}ທ\u{200b}ຽມ"),
            keywords: &[
                "ກະ\u{200b}ທ\u{200b}ຽມ",
                "ເຄ\u{eb7}\u{ec8}\u{200b}ອງ\u{200b}ເທດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("česnakas"),
            keywords: &["prieskonis", "česnakas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ķiploks"),
            keywords: &["garšviela", "ķiploks"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лук"),
            keywords: &["зачинување", "лук"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വെള\u{d41}ത\u{d4d}ത\u{d41}ള\u{d4d}ളി"),
            keywords: &[
                "വെള\u{d41}ത\u{d4d}ത\u{d41}ള\u{d4d}ളി",
                "സ\u{d4d}വ\u{d3e}ദിഷ\u{d4d}\u{200c}ഠമ\u{d3e}ക\u{d4d}കൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("саримс"),
            keywords: &["амтлагч", "саримс"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("लस\u{942}ण"),
            keywords: &["चव आणणार\u{947}", "लस\u{942}ण"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bawang putih"),
            keywords: &["bawang putih", "perisa"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကြက\u{103a}သ\u{103d}န\u{103a}ဖြ\u{1030}"),
            keywords: &[
                "ကြက\u{103a}သ\u{103d}န\u{103a}ဖြ\u{1030}",
                "ဟင\u{103a}းခတ\u{103a}အရသာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hvitløk"),
            keywords: &["hvitløk", "smakstilsetning"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("लस\u{941}न"),
            keywords: &["मसला हाल\u{94d}न\u{947}", "लस\u{941}न"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("knoflook"),
            keywords: &["knoflook", "smaakmaker"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvitlauk"),
            keywords: &["kvitlauk", "smakstilsetjing"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ରସ\u{b41}ଣ"),
            keywords: &["ରସ\u{b41}ଣ", "ସ\u{b41}ସ\u{b4d}ୱ\u{b3e}ଦ\u{b41} ମସଲ\u{b3e}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲਸਣ"),
            keywords: &["ਜ\u{a3c}ਾਇਕ\u{a47}ਦਾਰ", "ਲਸਣ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Gálik"),
            keywords: &["Gálik", "Spaísis"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("czosnek"),
            keywords: &["aromatyczny", "czosnek"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ووږه"),
            keywords: &["خوند", "ووږه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("alho"),
            keywords: &["alho", "tempero"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("ajo"),
            keywords: &["ajo", "mikhusqa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("usturoi"),
            keywords: &["aromă", "condiment", "usturoi"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–043"),
            keywords: &["E12–043"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("чеснок"),
            keywords: &[
                "вкус",
                "головка",
                "запах",
                "приправа",
                "специя",
                "чеснок",
                "чесночный",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٿوم"),
            keywords: &["فليورنگ", "ٿوم"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dd4}ද\u{dd4}ළ\u{dd4}න\u{dd4}"),
            keywords: &["රස ගැන\u{dca}ව\u{dd3}ම", "ස\u{dd4}ද\u{dd4}ළ\u{dd4}න\u{dd4}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("cesnak"),
            keywords: &["cesnak", "dochutenie", "korenie", "ochutenie", "zelenina"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("česen"),
            keywords: &["aromatično", "dišavnica", "začimba", "česen"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("toon"),
            keywords: &["iidaan", "toon"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("hudhër"),
            keywords: &["aromatizues", "erëza", "hudhër", "shije"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("бели лук"),
            keywords: &["бели лук", "зачин"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("бијели лук"),
            keywords: &["бијели лук"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("beli luk"),
            keywords: &["beli luk", "začin"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("bijeli luk"),
            keywords: &["bijeli luk"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("vitlök"),
            keywords: &["smaksättning", "vitlök"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitunguu saumu"),
            keywords: &["kitunguu saumu", "ladha"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பூண\u{bcd}டு"),
            keywords: &["சுவை", "பூண\u{bcd}டு"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వ\u{c46}ల\u{c4d}లుల\u{c4d}ల\u{c3f}"),
            keywords: &["రుచ\u{c3f}", "వ\u{c46}ల\u{c4d}లుల\u{c4d}ల\u{c3f}"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("กระเท\u{e35}ยม"),
            keywords: &["กระเท\u{e35}ยม", "ปร\u{e38}งรส"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("sarymsak"),
            keywords: &["sarymsak", "tagam bermek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kaliki"),
            keywords: &["kaliki"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sarımsak"),
            keywords: &["baharat", "sarımsak"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("часник"),
            keywords: &["приправа", "спеції", "часник", "часниковий"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("لہسن"),
            keywords: &["ذائقہ", "لہسن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("sarimsoq"),
            keywords: &["sarimsoq", "ziravor"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tỏi"),
            keywords: &["gia vị", "tỏi"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("蒜頭"),
            keywords: &["蒜頭", "調味"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("蒜头"),
            keywords: &["蒜头", "调味"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("蒜"),
            keywords: &["佐料", "大蒜", "蒜", "蒜头", "调味"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("大蒜"),
            keywords: &["大蒜", "調味"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("蒜頭"),
            keywords: &["蒜頭", "調味"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("igalikhi"),
            keywords: &["igalikhi", "ukufaka umnambitho"],
        },
    ],
};
#[doc = "🧅"]
pub const ONION: crate::Emoji = crate::Emoji {
    glyph: "🧅",
    codepoint: "1F9C5",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "onion",
    group: "Food & Drink",
    subgroup: "food-vegetable",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("ui"),
            keywords: &["geurmiddel", "ui"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሽንኩርት"),
            keywords: &["ማጣፈጫ", "ሽንኩርት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بصل"),
            keywords: &["بصل", "طعم", "نكهة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("পিয\u{9bc}\u{9be}\u{981}জ"),
            keywords: &[
                "পিয\u{9bc}\u{9be}\u{981}জ",
                "স\u{9c1}স\u{9cd}ব\u{9be}দ\u{9c1} কৰ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("soğan"),
            keywords: &["dadlandırma", "soğan"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("цыбуля"),
            keywords: &["прыправа", "цыбуля"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("лук"),
            keywords: &["лук", "овкусяване", "подправка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("পে\u{981}য\u{9bc}\u{9be}জ"),
            keywords: &["পে\u{981}য\u{9bc}\u{9be}জ", "স\u{9cd}ব\u{9be}দ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("ognon"),
            keywords: &["legumaj", "ognon", "temz-boued"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("luk"),
            keywords: &["luk", "začinjavanje hrane"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("ceba"),
            keywords: &["aromatitzant", "ceba"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏒᎩ"),
            keywords: &["ᎠᏑᏴᏗ", "ᏒᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("cibule"),
            keywords: &["cibule", "koření", "ochucování", "zelenina"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("winwns"),
            keywords: &["cyflas", "winwns"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("løg"),
            keywords: &["give smag", "løg"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Zwiebel"),
            keywords: &["Geschmack", "Zwiebel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κρεμμύδι"),
            keywords: &["άρωμα", "γεύση", "κρεμμύδι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("onion"),
            keywords: &["flavoring", "onion"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["flavouring", "onion"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["flavouring", "onion"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["flavouring", "onion"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["flavouring", "onion"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cebolla"),
            keywords: &["cebolla", "condimento", "llorar"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["cebolla", "condimento"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("sibul"),
            keywords: &["maitseaine", "sibul"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("tipula"),
            keywords: &["gozagarria", "tipula"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پیاز"),
            keywords: &["طعم\u{200c}دهنده", "پیاز"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("sipuli"),
            keywords: &["mauste", "sipuli"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("sibuyas"),
            keywords: &["pampalasa", "sibuyas"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("leykur"),
            keywords: &["leykur", "matur", "smakkur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("oignon"),
            keywords: &["assaisonnement", "condiment", "légume", "oignon"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["aromatisant", "assaisonnement", "condiment", "oignon"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("oiniún"),
            keywords: &["blasóir", "oiniún"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("uinnean"),
            keywords: &["blas", "blasachadh", "uinnean"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cebola"),
            keywords: &["cebola", "chorar", "condimento", "vexetal"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ડ\u{ac1}\u{a82}ગળી"),
            keywords: &["ખાદ\u{acd}યપદાર\u{acd}થ", "ડ\u{ac1}\u{a82}ગળી"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("בצל"),
            keywords: &["בצל", "תבלין"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{94d}याज\u{93c}"),
            keywords: &["प\u{94d}याज\u{93c}", "मसाला"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("luk"),
            keywords: &["luk", "povrće"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("hagyma"),
            keywords: &["hagyma", "ízesítés"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սոխ"),
            keywords: &["համեմունք", "սոխ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bawang bombay"),
            keywords: &["bawang bombay", "bumbu dapur"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("laukur"),
            keywords: &["bragðefni", "laukur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cipolla"),
            keywords: &["cipolla", "insaporire", "insaporitore", "soffritto"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("タマネギ"),
            keywords: &["ねぎ", "タマネギ", "玉ねぎ", "薬味", "野菜"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bawang bombai"),
            keywords: &["bawang bombai", "panyedhep rasa"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ხახვი"),
            keywords: &["მწარე", "საკმაზი", "ტირილი", "ხახვი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("пияз"),
            keywords: &["дәмдеуіш", "пияз"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ខ\u{17d2}ទ\u{17b9}មបារា\u{17c6}ង"),
            keywords: &[
                "ខ\u{17d2}ទ\u{17b9}មបារា\u{17c6}ង",
                "គ\u{17d2}រឿងបន\u{17d2}ថែមរសជាត\u{17b7}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಈರುಳ\u{ccd}ಳ\u{cbf}"),
            keywords: &["ಈರುಳ\u{ccd}ಳ\u{cbf}", "ಫ\u{ccd}ಲೇವರ\u{cbf}ಂಗ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("양파"),
            keywords: &["양념", "양파"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("का\u{902}दो"),
            keywords: &["का\u{902}दो", "स\u{94d}वाद"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("пияз"),
            keywords: &["пияз", "татымал"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some(
                "\u{200b}ຫ\u{ebb}ວ\u{200b}ຜ\u{eb1}ກ\u{200b}ບ\u{ebb}\u{ec8}ວ\u{200b}ໃຫຍ\u{ec8}",
            ),
            keywords: &[
                "ຫ\u{ebb}ວ\u{200b}ຜ\u{eb1}ກ\u{200b}ບ\u{ebb}\u{ec8}ວ",
                "ເຄ\u{eb7}\u{ec8}\u{200b}ອງ\u{200b}ເທດ",
                "\u{200b}ຫ\u{ebb}ວ\u{200b}ຜ\u{eb1}ກ\u{200b}ບ\u{ebb}\u{ec8}ວ\u{200b}ໃຫຍ\u{ec8}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("svogūnas"),
            keywords: &["prieskonis", "svogūnas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sīpols"),
            keywords: &["garšviela", "sīpols"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("кромид"),
            keywords: &["зачинување", "кромид"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഉള\u{d4d}ളി"),
            keywords: &[
                "ഉള\u{d4d}ളി",
                "സ\u{d4d}വ\u{d3e}ദിഷ\u{d4d}\u{200c}ഠമ\u{d3e}ക\u{d4d}കൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("сонгино"),
            keywords: &["амтлагч", "сонгино"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("का\u{902}दा"),
            keywords: &["का\u{902}दा", "चव आणणार\u{947}"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bawang"),
            keywords: &["bawang", "perisa"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကြက\u{103a}သ\u{103d}န\u{103a}န\u{102e}"),
            keywords: &[
                "ကြက\u{103a}သ\u{103d}န\u{103a}န\u{102e}",
                "ဟင\u{103a}းခတ\u{103a}အရသာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("løk"),
            keywords: &["løk", "smakstilsetning"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{94d}याज"),
            keywords: &["प\u{94d}याज", "मसला हाल\u{94d}न\u{947}"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("ui"),
            keywords: &["smaakmaker", "ui"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("lauk"),
            keywords: &["lauk", "smakstilsetjing"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b3f}ଆଜ"),
            keywords: &["ପ\u{b3f}ଆଜ", "ସ\u{b41}ସ\u{b4d}ୱ\u{b3e}ଦ\u{b41} ମସଲ\u{b3e}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪਿਆਜ"),
            keywords: &["ਜ\u{a3c}ਾਇਕ\u{a47}ਦਾਰ", "ਪਿਆਜ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ọ\u{301}niọn"),
            keywords: &["Spaísis", "Ọ\u{301}niọn"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("cebula"),
            keywords: &["aromatyczna", "cebula"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پياز"),
            keywords: &["خوند", "پياز"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cebola"),
            keywords: &["cebola", "tempero"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("cebolla"),
            keywords: &["cebolla", "mikhusqa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ceapă"),
            keywords: &["aromă", "ceapă", "condiment"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–044"),
            keywords: &["E12–044"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("лук"),
            keywords: &[
                "головка",
                "лук",
                "луковица",
                "луковый",
                "плакать",
                "репчатый",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بصر"),
            keywords: &["بصر", "فليورنگ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ල\u{dd6}න\u{dd4}"),
            keywords: &["රස ගැන\u{dca}ව\u{dd3}ම", "ල\u{dd6}න\u{dd4}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("cibuľa"),
            keywords: &["cibuľa", "dochutenie", "korenie", "ochutenie", "zelenina"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("čebula"),
            keywords: &["aromatično", "solzenje", "čebula"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("basal"),
            keywords: &["basal", "dhadhan u yeela"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("qepë"),
            keywords: &["aromatizues", "erëza", "qepë", "shije"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("црни лук"),
            keywords: &["зачин", "црни лук"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("crni luk"),
            keywords: &["crni luk", "začin"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("lök"),
            keywords: &["lök", "smaksättning"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitunguu"),
            keywords: &["kitunguu", "ladha"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வெங\u{bcd}க\u{bbe}யம\u{bcd}"),
            keywords: &["சுவை", "வெங\u{bcd}க\u{bbe}யம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఉల\u{c4d}ల\u{c3f}ప\u{c3e}య"),
            keywords: &["ఉల\u{c4d}ల\u{c3f}ప\u{c3e}య", "రుచ\u{c3f}"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หอมห\u{e31}วใหญ\u{e48}"),
            keywords: &["ปร\u{e38}งรส", "หอมห\u{e31}วใหญ\u{e48}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("sogan"),
            keywords: &["sogan", "tagam bermek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻonioni"),
            keywords: &["ʻonioni"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("soğan"),
            keywords: &["baharat", "soğan"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("цибуля"),
            keywords: &["з цибулі", "приправа", "спеції", "цибулинний", "цибуля"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پیاز"),
            keywords: &["ذائقہ", "پیاز"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("piyoz"),
            keywords: &["bosh", "koʻz yoshi", "piyoz", "yigʻi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hành"),
            keywords: &["gia vị", "hành"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("洋蔥"),
            keywords: &["洋蔥", "調味"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("洋葱"),
            keywords: &["洋葱", "调味"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("洋葱"),
            keywords: &["佐料", "洋葱", "调味"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("洋蔥"),
            keywords: &["洋蔥", "調味"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("u-anyanisi"),
            keywords: &["u-anyanisi", "ukufaka umnambitho"],
        },
    ],
};
#[doc = "🍄"]
pub const MUSHROOM: crate::Emoji = crate::Emoji {
    glyph: "🍄",
    codepoint: "1F344",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "mushroom",
    group: "Food & Drink",
    subgroup: "food-vegetable",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("sampioen"),
            keywords: &["paddastoel", "plant", "sampioen"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("እንጉዳይ"),
            keywords: &["ተክል", "እንጉዳይ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("عيش الغراب"),
            keywords: &["عيش الغراب", "عيش غراب", "فطر", "مشروم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9be}ঠফ\u{9c1}ল\u{9be}"),
            keywords: &["ক\u{9be}ঠফ\u{9c1}ল\u{9be}", "বেংচট\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("göbələk"),
            keywords: &["göbələk", "milçəkqıran"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("грыб"),
            keywords: &["грыб", "мухамор"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("гъба"),
            keywords: &["гъба", "растение"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9be}শর\u{9c1}ম"),
            keywords: &["গ\u{9be}ছ", "ম\u{9be}শর\u{9c1}ম"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kabell-touseg"),
            keywords: &["kabell-touseg", "tog-touseg"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("gljiva"),
            keywords: &["biljka", "gljiva"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bolet"),
            keywords: &["bolet", "planta"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄥𑄟\u{11134}\u{1112e}𑄅𑄣\u{11134}"),
            keywords: &["𑄥𑄟\u{11134}\u{1112e}𑄅𑄣\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏓᏬᎵ"),
            keywords: &["ᏓᏬᎵ", "ᏩᎶᏏ ᏓᏬᎵ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("houba"),
            keywords: &["houba", "muchomůrka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("madarch"),
            keywords: &["madarch", "planhigyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("svamp"),
            keywords: &["plante", "svamp"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Fliegenpilz"),
            keywords: &["Fliegenpilz", "Pilz"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μανιτάρι"),
            keywords: &["μανιτάρι", "φυτό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("mushroom"),
            keywords: &["mushroom", "toadstool"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("champiñón"),
            keywords: &["champiñón", "hongo", "seta"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("seen"),
            keywords: &["mürgiseen", "seen"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("barrengorria"),
            keywords: &["barrengorria", "landare"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قارچ"),
            keywords: &["قارچ", "گیاه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("sieni"),
            keywords: &["rihmasto", "sieni"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kabute"),
            keywords: &["halaman", "kabute", "mushroom"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("soppur"),
            keywords: &["hundaland", "soppur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("champignon"),
            keywords: &["champignon", "plante"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["champignon", "vénéneux"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("beacán"),
            keywords: &["beacán", "beacán bearaigh"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("balgan-buachrach"),
            keywords: &["balgan-buachair", "balgan-buachrach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cogomelo"),
            keywords: &["champiñón", "cogomelo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મશર\u{ac1}મ"),
            keywords: &["ઝાડ", "મશર\u{ac1}મ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("naman kaza"),
            keywords: &["naman kaza", "shuken toadstool"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פטריה"),
            keywords: &["ירק", "פטריה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("मशर\u{942}म"),
            keywords: &["पौधा", "मशर\u{942}म"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("gljiva"),
            keywords: &["biljka", "gljiva"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("gomba"),
            keywords: &["gomba", "növény"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սունկ"),
            keywords: &["բույս", "սունկ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("jamur"),
            keywords: &["jamur", "tanaman"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ero"),
            keywords: &["ero", "ero mkpụmkpụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sveppur"),
            keywords: &["sveppur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("fungo"),
            keywords: &["autunno", "bosco", "fungo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("キノコ"),
            keywords: &["きのこ", "キノコ", "マッシュルーム", "毒", "野菜"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("jamur"),
            keywords: &["jamur", "jamur payung"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სოკო"),
            keywords: &["მცენარე", "სოკო"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("taṛeɣlett"),
            keywords: &["taṛeɣlett"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("саңырауқұлақ"),
            keywords: &["саңырауқұлақ", "өсімдік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("svamp"),
            keywords: &["plante", "svamp"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ផ\u{17d2}ស\u{17b7}ត"),
            keywords: &["ផ\u{17d2}ស\u{17b7}ត", "រ\u{17bb}ក\u{17d2}ខជាត\u{17b7}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಅಣಬ\u{cc6}"),
            keywords: &[
                "ಅಣಬ\u{cc6}",
                "ಟೋಡ\u{ccd}\u{200c}ಸ\u{ccd}ಟ\u{cc2}ಲ\u{ccd}\u{200c}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("버섯"),
            keywords: &["나무", "버섯", "식물"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("अळमी"),
            keywords: &["अळमी", "अळम\u{947}\u{902}", "टोडस\u{94d}ट\u{942}ल"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("козу карын"),
            keywords: &["козу карын", "өсүмдүк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Champignon"),
            keywords: &["Champignon", "Gëftpilz", "Pilz"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຫ\u{eb1}ດ"),
            keywords: &["ພ\u{eb7}ດ", "ເຫ\u{eb1}ດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("grybas"),
            keywords: &["grybas", "šungrybis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sēne"),
            keywords: &["augs", "sēne"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("harore"),
            keywords: &["harore", "tūruporaka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("печурка"),
            keywords: &["печурка", "растение"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d42}ൺ"),
            keywords: &["ക\u{d42}ൺ", "സസ\u{d4d}യം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("мөөг"),
            keywords: &["мөөг", "ургамал"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("आळ\u{902}ब\u{947}"),
            keywords: &["अळ\u{902}बी", "आळ\u{902}ब\u{947}", "मशर\u{942}म"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("cendawan"),
            keywords: &["cendawan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("faqqiegħa"),
            keywords: &["faqqiegħa", "fungu velenuż"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မ\u{103e}\u{102d}\u{102f}"),
            keywords: &["မ\u{103e}\u{102d}\u{102f}", "အပင\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sopp"),
            keywords: &["fluesopp", "sopp"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("च\u{94d}याउ"),
            keywords: &["च\u{94d}याउ", "बिर\u{942}वा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("paddenstoel"),
            keywords: &["paddenstoel", "zwam"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("sopp"),
            keywords: &["flugesopp", "sopp"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଛତ\u{b41}"),
            keywords: &["ଛତ\u{b41}", "ବ\u{b3f}ଷ\u{b3e}କ\u{b4d}ତ ଛତ\u{b41}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਖ\u{a41}\u{a70}ਭ"),
            keywords: &["ਖ\u{a41}\u{a70}ਭ", "ਬ\u{a42}ਟਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کھمبی"),
            keywords: &["فطری نبات", "کھمبی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mọ\u{301}shrum"),
            keywords: &["Mọ\u{301}shrum", "Tódstúl Mọ\u{301}shrum"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("grzyb"),
            keywords: &["grzyb", "muchomor", "trujący"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مرخېړى"),
            keywords: &["مرخېړى", "مرخېړى، ګوڅي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cogumelo"),
            keywords: &["champignon", "cogumelo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["cogumelo", "fungo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("kʼallnpa"),
            keywords: &["kʼallnpa", "miyu k’allampa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ciupercă"),
            keywords: &["ciupercă", "ciupercă otrăvitoare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-265"),
            keywords: &["E10-265"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("гриб"),
            keywords: &[
                "гриб",
                "мухомор",
                "несъедобный",
                "поганка",
                "растение",
                "ядовитый",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igihumyo"),
            keywords: &["ibiyege", "igihumyo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("خمبي"),
            keywords: &["خمبي", "زهريلي خمبي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හත\u{dd4}"),
            keywords: &["පැළය", "හත\u{dd4}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("huba"),
            keywords: &["hríb", "huba"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("goba"),
            keywords: &["goba", "rastlina"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("barkin waraabe"),
            keywords: &["baaraabuq", "barkin waraabe"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kërpudhë"),
            keywords: &["kërpudhë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("печурка"),
            keywords: &["биљкa", "печурка"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("pečurka"),
            keywords: &["biljka", "pečurka"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("svamp"),
            keywords: &["svamp", "växt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uyoga"),
            keywords: &["mmea", "uyoga"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("க\u{bbe}ள\u{bbe}ன\u{bcd}"),
            keywords: &[
                "உணவு",
                "க\u{bbe}ள\u{bbe}ன\u{bcd}",
                "சூப\u{bcd}பர\u{bcd} ம\u{bbe}ரியோ",
                "மஷ\u{bcd}ரூம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("పుట\u{c4d}టగ\u{c4a}డుగు"),
            keywords: &[
                "కుక\u{c4d}క గ\u{c4a}డువు",
                "పుట\u{c4d}టగ\u{c4a}డుగు",
                "మష\u{c4d}రూమ\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("занбӯруғ"),
            keywords: &["занбӯруғ", "маргимагас"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เห\u{e47}ด"),
            keywords: &["พ\u{e37}ช", "เห\u{e47}ด"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kömelek"),
            keywords: &["kömelek", "ýylankömelek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakamalu-ʻa-tēvolo"),
            keywords: &["fakamalu-ʻa-tēvolo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("mantar"),
            keywords: &["bitki", "mantar"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئېشەكمەدىكى"),
            keywords: &["ئېشەكمەدىكى", "يەر مەدىكى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("гриб"),
            keywords: &["гриб", "гриб із шапинкою", "плодове тіло"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کھمبی"),
            keywords: &["پودا", "کھمبی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qo‘ziqorin"),
            keywords: &["o‘simlik", "qo‘ziqorin"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nấm"),
            keywords: &["nấm", "thực vật"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("sampiñoŋ"),
            keywords: &["sampiñoŋ", "sampiñoŋ weneer"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ikhowa"),
            keywords: &["i-toadstool", "ikhowa"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Olu"),
            keywords: &["Olu", "olú pupa"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("蘑菇"),
            keywords: &["毒菌", "蘑菇"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("蘑菇"),
            keywords: &["毒菌", "蘑菇"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("蘑菇"),
            keywords: &["蘑菇"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("蘑菇"),
            keywords: &["蘑菇", "香菇"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["菇類", "蘑菇", "香菇"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ikhowe"),
            keywords: &["ikhowe", "isitshalo"],
        },
    ],
};
#[doc = "🥜"]
pub const PEANUTS: crate::Emoji = crate::Emoji {
    glyph: "🥜",
    codepoint: "1F95C",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "peanuts",
    group: "Food & Drink",
    subgroup: "food-vegetable",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("grondboontjies"),
            keywords: &["grondboontjie", "grondboontjies", "kos", "peule"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ኦቾሎኒ"),
            keywords: &["ምግብ", "ነት", "አትክልት", "ኦቾሎኒ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("فول سوداني"),
            keywords: &["خضروات", "طعام", "فول سوداني", "مكسرات"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চীন\u{9be} ব\u{9be}দ\u{9be}ম"),
            keywords: &[
                "খ\u{9be}দ\u{9cd}য",
                "চীন\u{9be} ব\u{9be}দ\u{9be}ম",
                "প\u{9be}চলি",
                "ব\u{9be}দ\u{9be}ম",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yer fındığı"),
            keywords: &["yer fındığı", "çərəz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("арахіс"),
            keywords: &["арахіс", "арэх", "гародніна", "ежа"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("фъстъци"),
            keywords: &["зеленчук", "фъстък", "фъстъци", "храна", "ядка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চিন\u{9be}ব\u{9be}দ\u{9be}ম"),
            keywords: &[
                "খ\u{9be}ব\u{9be}র",
                "চিন\u{9be}ব\u{9be}দ\u{9be}ম",
                "ব\u{9be}দ\u{9be}ম",
                "সবজি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kakaouetez"),
            keywords: &["boued", "kakaouetez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kikiriki"),
            keywords: &["grickalice", "hrana", "kikiriki", "povrće"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cacauets"),
            keywords: &["cacauet", "cacauets", "fruit", "llegum", "menjar", "sec"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄝𑄘𑄟\u{11134}"),
            keywords: &["𑄝𑄘𑄟\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏂᏅᎯᏓ ᏚᏯ"),
            keywords: &["ᎠᎵᏍᏓᏴᏗ", "ᎠᏂᏅᎯᏓ ᏚᏯ", "ᎠᏫᏒᏅ ᎤᏛᏒᎢ", "ᏐᎯ", "ᏚᏯ ᎠᏂᎳᏗᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("arašídy"),
            keywords: &[
                "arašíd",
                "arašídy",
                "burský",
                "burák",
                "jídlo",
                "lusk",
                "olejná",
                "ořech",
                "podzemnice",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cnai ddaear"),
            keywords: &[
                "bwyd",
                "cnai ddaear",
                "cneuen",
                "cneuen ddaear",
                "llysieuyn",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("jordnødder"),
            keywords: &[
                "jordnød",
                "jordnødder",
                "nød",
                "nødder",
                "peanut",
                "peanuts",
                "snack",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Erdnuss"),
            keywords: &["Erdnuss", "Essen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("φιστίκια"),
            keywords: &["λαχανικό", "ξηρός καρπός", "τροφή", "φιστίκι", "φιστίκια"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("peanuts"),
            keywords: &["food", "nut", "peanut", "peanuts", "vegetable"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["food", "monkey nut", "nut", "nuts", "peanut", "peanuts"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["food", "nut", "peanut", "peanuts", "vegetable"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cacahuetes"),
            keywords: &["cacahuete", "cacahuetes", "comida", "fruto seco", "verdura"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("maní"),
            keywords: &["comida", "fruto seco", "maní", "vegetal"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cacahuate"),
            keywords: &["cacahuate"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cacahuates"),
            keywords: &["cacahuate", "cacahuates", "comida", "maní", "vegetal"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("maapähklid"),
            keywords: &["maapähkel", "maapähklid", "pähkel", "toit"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kakahuetea"),
            keywords: &["barazki", "intxaur", "janari", "kakahuete", "kakahuetea"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بادام زمینی"),
            keywords: &["بادام", "بادام زمینی", "بادم زمینی", "بادوم"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("maapähkinä"),
            keywords: &["maapähkinä", "pähkinä", "ruoka"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mani"),
            keywords: &["gulay", "mani", "pagkain"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("jarðnøtur"),
            keywords: &["jarðnøtur", "matur", "nøt"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cacahuètes"),
            keywords: &["arachide", "cacahuète", "cacahuètes", "noisette"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("arachides"),
            keywords: &["arachide", "arachides", "cacahuète", "noisette"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("pis talún"),
            keywords: &["bia", "cnó", "glasra", "pis talún"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cnòthan-talmhainn"),
            keywords: &[
                "biadh",
                "cnò",
                "cnò-thalmhainn",
                "cnòthan-talmhainn",
                "glasraich",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cacahuete"),
            keywords: &["cacahuete", "comida", "froito", "seco"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મગફળી"),
            keywords: &["અખરોટ", "ભોજન", "મગફળી", "શાકભાજી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("gyada"),
            keywords: &["abinci", "ganye", "gyada"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("בוטנים"),
            keywords: &["בוטן", "בוטנים", "נשנוש", "פיצוחים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("म\u{942}\u{901}गफली"),
            keywords: &["अखरोट", "खाना", "म\u{942}\u{901}गफली", "सब\u{94d}जी"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kikiriki"),
            keywords: &["grickalice", "hrana", "kikiriki", "povrće"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("földimogyoró"),
            keywords: &["földimogyoró", "mogyoró", "étel"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("գետնանուշ"),
            keywords: &["գետնանուշ", "ընդեղեն", "ընկույզ", "ուտելիք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kacang tanah"),
            keywords: &["kacang", "kacang tanah", "makanan", "sayur", "sayuran"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ahụekere"),
            keywords: &["ahụekere", "akwụkwọnri", "akị", "nri"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("jarðhneta"),
            keywords: &["grænmeti", "jarðhneta", "jarðhnetur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("arachidi"),
            keywords: &[
                "arachide",
                "arachidi",
                "cibo",
                "frutta secca",
                "nocciolina",
                "noccioline",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ピーナッツ"),
            keywords: &["ナッツ", "ピーナッツ", "落花生", "野菜"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kacang brol"),
            keywords: &["dhaharan", "kacang", "kacang brol", "sayuran"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მიწის თხილი"),
            keywords: &["არაქისი", "ბოსტნეული", "მიწის თხილი", "საკვები"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("takawkawt"),
            keywords: &["takawkawt"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жержаңғақ"),
            keywords: &["жаңғақ", "жержаңғақ", "көкөніс", "тағам"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("peanuts"),
            keywords: &["mad", "mellemmåltid", "nød", "nødder", "peanuts", "snack"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សណ\u{17d2}តែកដ\u{17b8}"),
            keywords: &[
                "គ\u{17d2}រាប\u{17cb}",
                "បន\u{17d2}លែ",
                "សណ\u{17d2}តែកដ\u{17b8}",
                "អាហារ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಶೇಂಗಾ"),
            keywords: &["ಆಹಾರ", "ತರಕಾರ\u{cbf}", "ಬೀಜ", "ಶೇಂಗಾ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("땅콩"),
            keywords: &["견과류", "넛츠", "땅콩", "식품"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("भिकणा\u{902}"),
            keywords: &["अन\u{94d}न", "बियो", "भाजी", "भिकणा\u{902}"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жер жаңгак"),
            keywords: &["жашылча", "жаңгак", "жер жаңгак", "тамак"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Kakuett"),
            keywords: &["Geméis", "Iessen", "Kakuett", "Noss"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໝາກຖ\u{ebb}\u{ec8}ວ"),
            keywords: &[
                "ຖ\u{ebb}\u{ec8}ວ",
                "ຜ\u{eb1}ກ",
                "ອາຫານ",
                "ໝາກຖ\u{ebb}\u{ec8}ວ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žemės riešutas"),
            keywords: &["maistas", "riešutas", "žemės"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zemesrieksti"),
            keywords: &["dārzenis", "rieksti", "zemesrieksti", "ēdiens"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pīnati"),
            keywords: &["huawhenua", "kai", "nati", "pīnati"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("кикиритки"),
            keywords: &["зеленчук", "кикирика", "кикиритки"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("നിലക\u{d4d}കടല"),
            keywords: &["കടല", "നിലക\u{d4d}കടല", "ഭക\u{d4d}ഷണം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("газрын самар"),
            keywords: &["газрын самар", "самар", "хүнс", "хүнсний ногоо"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("श\u{947}\u{902}गदाणा"),
            keywords: &[
                "खाद\u{94d}य",
                "नट",
                "भाजीपाला",
                "श\u{947}\u{902}गदाणा",
                "श\u{947}\u{902}गदाण\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kacang tanah"),
            keywords: &["kacang tanah", "kekacang", "makanan", "sayur"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("karawett"),
            keywords: &["ikel", "karawett", "lewż", "ħaxix"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မြေပ\u{1032}"),
            keywords: &[
                "မြေပ\u{1032}",
                "အခ\u{103d}\u{1036}မာသ\u{102e}း",
                "အစားအသောက\u{103a}",
                "အသ\u{102e}းအန\u{103e}\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("peanøtter"),
            keywords: &["grønnsak", "mat", "nøtt", "peanøtt", "peanøtter"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बदाम"),
            keywords: &["ओखर", "खाना", "तरकारी", "बदाम"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("pinda’s"),
            keywords: &["groente", "noot", "pinda", "pinda’s", "voedsel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("peanøtter"),
            keywords: &["grønsak", "mat", "nøtt", "peanøtt", "peanøtter"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଚ\u{b3f}ନ\u{b3e}ବ\u{b3e}ଦ\u{b3e}ମ"),
            keywords: &[
                "ଖ\u{b3e}ଦ\u{b4d}ୟ",
                "ଚ\u{b3f}ନ\u{b3e}ବ\u{b3e}ଦ\u{b3e}ମ",
                "ଚ\u{b3f}ନ\u{b3e}ବ\u{b3e}ଦ\u{b3e}ମ । ପନ\u{b3f}ପର\u{b3f}ବ\u{b3e}",
                "ବ\u{b3e}ଦ\u{b3e}ମ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a42}\u{a70}ਗਫਲ\u{a3c}ੀ"),
            keywords: &[
                "ਅਖਰ\u{a4b}ਟ",
                "ਖਾਣਾ",
                "ਮ\u{a42}\u{a70}ਗਫਲ\u{a3c}ੀ",
                "ਸਬਜ\u{a3c}ੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مونگ پھلی"),
            keywords: &["خشک میوہ جات", "خوراک", "سبزیاں", "مونگ پھلی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Granọt"),
            keywords: &[
                "Fud",
                "Granọt",
                "Granọt-dẹm",
                "Nọt",
                "Pínọt",
                "Pínọt-dẹm",
                "Vẹ\u{301}jítébul",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("orzeszki ziemne"),
            keywords: &["fistaszki", "jedzenie", "orzeszki", "orzeszki ziemne"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مونګ پلي"),
            keywords: &["خواړه، نټ، مونګ پلی، مونګ پلي، سبزي", "مونګ پلي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("amendoim"),
            keywords: &["amendoim", "comida"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("amendoins"),
            keywords: &["amendoim", "amendoins", "leguminosa"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("chuqupi"),
            keywords: &["chuqupi", "mikhuna", "nuez", "vegetal"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("arahide"),
            keywords: &["alune", "arahide", "legumă", "mâncare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1080"),
            keywords: &["E10-1080"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("арахис"),
            keywords: &["арахис", "еда", "овощ", "орех"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("urunyobwa"),
            keywords: &[
                "ibiribwa",
                "imboga",
                "ubunyobwa",
                "ubunyobwa bwa coco",
                "urunyobwa",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("کاڄو"),
            keywords: &["کاڄو", "کاڄو، اخروٽ، کاڌو، ڀاڄي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("රටකජ\u{dd4}"),
            keywords: &[
                "අච\u{dca}ච\u{dcf}ර\u{dd4}",
                "කජ\u{dd4}",
                "කෑම",
                "රටකජ\u{dd4}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("arašidy"),
            keywords: &["arašid", "arašidy", "jedlo", "orech", "zelenina"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("arašidi"),
            keywords: &["arašid", "arašidi", "hrana", "oreški", "zelenjava"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("loows"),
            keywords: &["cunto", "khudrad", "loows", "loowska", "mir loows"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kikirik"),
            keywords: &["kikirik", "perime", "ushqim"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кикирики"),
            keywords: &["кикирики", "орашасто", "храна"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kikiriki"),
            keywords: &["hrana", "kikiriki", "orašasto"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("jordnötter"),
            keywords: &["grönsak", "jordnöt", "jordnötter", "mat", "nöt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("njugu"),
            keywords: &["chakula", "njugu", "njugu karanga"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வேர\u{bcd}க\u{bcd}கடலை"),
            keywords: &[
                "உணவு",
                "கடலை",
                "க\u{bbe}ய\u{bcd}கறி",
                "வேர\u{bcd}க\u{bcd}கடலை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వ\u{c47}రుశ\u{c46}నగ"),
            keywords: &[
                "ఆహ\u{c3e}రం",
                "కూరగ\u{c3e}య",
                "గ\u{c3f}ంజ",
                "వ\u{c47}రుశ\u{c46}నగ",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("чормағзи заминӣ"),
            keywords: &["сабзавот", "чормағз", "чормағзи заминӣ", "ғизо"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ถ\u{e31}\u{e48}ว"),
            keywords: &[
                "ถ\u{e31}\u{e48}ว",
                "ธ\u{e31}ญพ\u{e37}ช",
                "ผ\u{e31}ก",
                "อาหาร",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("arahis"),
            keywords: &["arahis", "gök önüm", "hoz", "iýmit"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pīnati"),
            keywords: &["pīnati"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yer fıstığı"),
            keywords: &["fındık", "fıstık", "sebze", "yer fıstığı", "yiyecek"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يەر ياڭىقى"),
            keywords: &["خاسىڭ", "كۆكتات", "يەر ياڭىقى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("арахіс"),
            keywords: &["арахіс", "горіх", "земляний горіх", "їстівний"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مونگ پھلی"),
            keywords: &["خوراک", "سبزی", "مونگ پھلی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yeryong‘oq"),
            keywords: &["sabzavot", "taom", "yeryong‘oq", "yong‘oq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đậu phộng"),
            keywords: &["quả hạch", "rau củ", "thức ăn", "đậu phộng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("gerte"),
            keywords: &["gerte", "lekk", "lujum", "nuwaa"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("amandongomane"),
            keywords: &["amandongomane", "imifuno", "indongomane", "ukutya"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹpa"),
            keywords: &[
                "kóró inú èso",
                "ónjẹ",
                "Ẹpa",
                "ẹ\u{300}fọ\u{301}",
                "ẹ\u{300}pà",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("花生"),
            keywords: &["果仁", "花生", "蔬菜", "食物"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("花生"),
            keywords: &["果仁", "花生", "蔬菜", "食物"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("花生"),
            keywords: &["坚果", "花生", "蔬菜", "食物"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("花生"),
            keywords: &["堅果", "花生", "蔬菜", "食物"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["堅果", "果仁", "花生"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("amakinati"),
            keywords: &["amakinati", "amaveji", "ikinati", "ukudla"],
        },
    ],
};
#[doc = "🌰"]
pub const CHESTNUT: crate::Emoji = crate::Emoji {
    glyph: "🌰",
    codepoint: "1F330",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "chestnut",
    group: "Food & Drink",
    subgroup: "food-vegetable",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kastaiing"),
            keywords: &["kastaiing", "plant"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የለውዝ ፍሬ"),
            keywords: &["ተክል", "የለውዝ ፍሬ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كستناء"),
            keywords: &["أبو فروة", "كستناء", "نبات"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ব\u{9be}দ\u{9be}ম"),
            keywords: &["উদ\u{9cd}ভিদ", "ব\u{9be}দ\u{9be}ম"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("şabalıd"),
            keywords: &["bitki", "şabalıd"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("каштан"),
            keywords: &["каштан", "расліна"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("кестен"),
            keywords: &["кестен", "растение"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("একপ\u{9cd}রক\u{9be}রের ব\u{9be}দ\u{9be}ম"),
            keywords: &["একপ\u{9cd}রক\u{9be}রের ব\u{9be}দ\u{9be}ম", "গ\u{9be}ছ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kistin"),
            keywords: &["boued", "kistin"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kesten"),
            keywords: &["biljka", "kesten"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("castanya"),
            keywords: &["castanya", "planta"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏘᎵ"),
            keywords: &["ᎦᎪᏗ", "ᏘᎵ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kaštan"),
            keywords: &["kaštan", "rostlina"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("castan"),
            keywords: &["castan", "planhigyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kastanje"),
            keywords: &["kastanje", "plante"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Kastanie"),
            keywords: &["Kastanie", "Marone"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κάστανο"),
            keywords: &["κάστανο", "φυτό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("chestnut"),
            keywords: &["chestnut", "plant"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["chestnut", "plant"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["chestnut", "nut", "plant"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("castaña"),
            keywords: &["castaña", "castaño", "fruto seco"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["castaña", "castaña de Indias", "castaño", "fruto seco"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["castaña", "comida", "fruto seco", "planta"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kastan"),
            keywords: &["kastan", "taim"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gaztaina"),
            keywords: &["gaztaina", "landare"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("فندق"),
            keywords: &["فندق", "گیاه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kastanja"),
            keywords: &["kastanja", "kasvi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kastanyas"),
            keywords: &["bunga", "chestnut", "halaman", "kastanyas"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kastanja"),
            keywords: &["kastanja", "matur", "nøt"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("châtaigne"),
            keywords: &["châtaigne", "plante"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cnó capaill"),
            keywords: &["cnó capaill", "planda"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("geanm-chnò"),
            keywords: &["flùr", "geanm-chnò", "lus"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("castaña"),
            keywords: &["castaña", "magosto", "outono"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બદામ જ\u{ac7}વ\u{ac1}\u{a82} એક ફળ"),
            keywords: &["ઝાડ", "બદામ", "બદામ જ\u{ac7}વ\u{ac1}\u{a82} એક ફળ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("chestnut"),
            keywords: &["chestnut", "shuke"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ערמון"),
            keywords: &["ערמון", "ערמונים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("च\u{947}स\u{94d}टनट"),
            keywords: &["च\u{947}स\u{94d}टनट", "शाहबल\u{942}त"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kesten"),
            keywords: &["biljka", "kesten"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("gesztenye"),
            keywords: &["gesztenye", "növény"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("շագանակ"),
            keywords: &["բույս", "շագանակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kastanye"),
            keywords: &["kastanye", "tanaman"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("chestnọt"),
            keywords: &["chestnọt", "osisi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kastanía"),
            keywords: &["hneta", "kastanía"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("castagna"),
            keywords: &["autunno", "bosco", "castagna"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("くり"),
            keywords: &["くり", "野菜"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kenari"),
            keywords: &["kenari", "tetuwuhan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("წაბლი"),
            keywords: &["მცენარე", "წაბლი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("каштан"),
            keywords: &["каштан", "өсімдік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kastanje"),
            keywords: &["kastanje", "plante"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កៅឡាក\u{17cb}"),
            keywords: &["កៅឡាក\u{17cb}", "ធញជាត\u{17b7}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಚ\u{cc6}ಸ\u{ccd}ಟ\u{ccd} ನಟ\u{ccd}"),
            keywords: &["ಚ\u{cc6}ಸ\u{ccd}ಟ\u{ccd} ನಟ\u{ccd}", "ಸಸ\u{ccd}ಯ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("밤"),
            keywords: &["견과류", "나무", "밤", "식물"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("श\u{947}\u{902}गाबियो"),
            keywords: &[
                "रोप",
                "श\u{947}\u{902}गा\u{902}बियो",
                "श\u{947}\u{902}गाबियो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("каштан"),
            keywords: &["каштан", "өсүмдүк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Käscht"),
            keywords: &["Käscht", "Planz"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໝາກກ\u{ecd}\u{ec8}"),
            keywords: &["ພ\u{eb7}ດ", "ໝາກກ\u{ecd}\u{ec8}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("lazdyno riešutas"),
            keywords: &["augalas", "lazdyno riešutas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kastanis"),
            keywords: &["augs", "kastanis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("hetenati"),
            keywords: &["hetenati", "tipu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("костен"),
            keywords: &["костен", "растение"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ചെസ\u{d4d}\u{200c}റ\u{d4d}റ\u{d4d}നട\u{d4d}ട\u{d4d}"),
            keywords: &["ചെസ\u{d4d}\u{200c}റ\u{d4d}റ\u{d4d}നട\u{d4d}ട\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("каштан"),
            keywords: &["каштан", "самар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("च\u{947}स\u{94d}टनट"),
            keywords: &["च\u{947}स\u{94d}टनट", "वनस\u{94d}पती"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("buah berangan"),
            keywords: &["buah berangan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("qastan"),
            keywords: &["pjanta", "qastan"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("သစ\u{103a}အယ\u{103a}သ\u{102e}း"),
            keywords: &["သစ\u{103a}အယ\u{103a}သ\u{102e}း", "အပင\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kastanje"),
            keywords: &["kastanje", "kastanjenøtt", "nøtt"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ओखर"),
            keywords: &["ओखर", "बिर\u{942}वा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kastanje"),
            keywords: &["kastanje", "plant"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kastanje"),
            keywords: &["kastanje", "kastanjenøtt", "nøtt"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଚେଷ\u{b4d}ଟନଟ\u{b4d}\u{200d}"),
            keywords: &["ଉଦ\u{b4d}ଭ\u{b3f}ଦ", "ଚେଷ\u{b4d}ଟନଟ\u{b4d}\u{200d}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚ\u{a48}ਸਟਨਟ"),
            keywords: &["ਚ\u{a48}ਸਟਨਟ", "ਬ\u{a42}ਟਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("شاہ بلوط"),
            keywords: &["بوٹا", "شاہ بلوط"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Chẹ\u{301}stnọt"),
            keywords: &["Chẹ\u{301}stnọt", "Plant"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kasztan"),
            keywords: &["jedzenie", "kasztan", "kasztan jadalny"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("خورماني"),
            keywords: &["خورماني", "خورماني، ونه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("castanha"),
            keywords: &["castanha", "planta"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("chʼumpi"),
            keywords: &["chʼumpi", "mallki"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("castană"),
            keywords: &["castană", "plantă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-245"),
            keywords: &["E10-245"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("каштан"),
            keywords: &["каштан", "растение"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igiti cya shatenye"),
            keywords: &["igiti cya shatenye", "ikimera"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("شاه بلوط"),
            keywords: &["شاه بلوط", "ٻوٽو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("චෙස\u{dca}ට\u{dca}නට\u{dca}"),
            keywords: &["චෙස\u{dca}ට\u{dca}නට\u{dca}", "පැළය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("gaštan"),
            keywords: &["gaštan", "rastlina"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kostanj"),
            keywords: &["kostanj", "rastlina"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("loows duban"),
            keywords: &["dhir", "loows duban"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("lajthi"),
            keywords: &["lajthi", "pemë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кестен"),
            keywords: &["биљкa", "кестен"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kesten"),
            keywords: &["biljka", "kesten"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kastanj"),
            keywords: &["kastanj", "växt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("aina ya njugu"),
            keywords: &["aina ya njugu", "mmea"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("செஸ\u{bcd}ட\u{bcd}நட\u{bcd}"),
            keywords: &[
                "செஸ\u{bcd}ட\u{bcd}நட\u{bcd}",
                "வறுத\u{bcd}த செஸ\u{bcd}ட\u{bcd}நட\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బ\u{c3e}దం వంట\u{c3f} ద\u{c3f}నుసు"),
            keywords: &[
                "గ\u{c4b}ధుమ రంగు క\u{c3e}య",
                "బ\u{c3e}దం",
                "బ\u{c3e}దం వంట\u{c3f} ద\u{c3f}నుసు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("кастона"),
            keywords: &["кастона", "растанӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เกาล\u{e31}ด"),
            keywords: &["พ\u{e37}ช", "เกาล\u{e31}ด"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kaştan"),
            keywords: &["kaştan", "ösümlik"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ifi"),
            keywords: &["ifi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kestane"),
            keywords: &["bitki", "kestane"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كاشتان"),
            keywords: &["ئۆسۈملۈك", "كاشتان"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("каштан"),
            keywords: &["каштан", "рослина"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("شاہ بلوط کا پھل"),
            keywords: &["شاہ بلوط", "شاہ بلوط کا پھل", "پودا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kashtan yong‘oq"),
            keywords: &["kashtan yong‘oq", "o‘simlik"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hạt dẻ"),
            keywords: &["hạt dẻ", "thực vật"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("sateñ"),
            keywords: &["garab", "sateñ"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-chestnut"),
            keywords: &["i-chestnut", "isityalo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Kóró inú èso búránù"),
            keywords: &["Kóró inú èso búránù", "õgbìn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("栗子"),
            keywords: &["栗子", "植物"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("栗子"),
            keywords: &["栗子", "植物"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("栗子"),
            keywords: &["栗子"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("栗子"),
            keywords: &["栗子"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["栗子", "植物"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ichestnut"),
            keywords: &["ichestnut", "isitshalo"],
        },
    ],
};
