#[doc = "🍦"]
pub const SOFT_ICE_CREAM: crate::Emoji = crate::Emoji {
    glyph: "🍦",
    codepoint: "1F366",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "soft ice cream",
    group: "Food & Drink",
    subgroup: "food-sweet",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("sagte roomys"),
            keywords: &["nagereg", "room", "roomys", "sag", "sagte roomys", "ys"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቀላል አይስክሬም"),
            keywords: &["ለስላሳ", "ቀላል አይስክሬም", "በረዶ", "አይስክሬም", "ክሬም", "ጣፋጭ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}آيس كريم مخفف"),
            keywords: &["مطعم", "\u{202b}آيس كريم مخفف"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চ’ফ\u{9cd}ট আইচ ক\u{9cd}ৰীম"),
            keywords: &[
                "আইচ",
                "আইচক\u{9cd}ৰীম",
                "কোমল",
                "ক\u{9cd}ৰীম",
                "চ’ফ\u{9cd}ট আইচ ক\u{9cd}ৰীম",
                "ডেজ\u{9be}ৰ\u{9cd}ট",
                "মিঠ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yumşaq dondurma"),
            keywords: &[
                "buz",
                "desert",
                "dondurma",
                "krem",
                "yumuşaq",
                "yumşaq dondurma",
                "şirin",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мяккае марожанае"),
            keywords: &[
                "дэсерт",
                "марожанае",
                "марозіва",
                "мяккае марожанае",
                "мяккі",
                "пламбір",
                "салодкі",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Крем сладолед"),
            keywords: &["Крем сладолед", "десерт", "крем", "сладолед", "сладък"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("সফ\u{9cd}ট আইস ক\u{9cd}রিম"),
            keywords: &[
                "আইসক\u{9cd}রিম",
                "ক\u{9cd}রিম",
                "ডেজ\u{9be}র\u{9cd}ট",
                "বরফ",
                "মিষ\u{9cd}টি",
                "সফ\u{9cd}ট আইস ক\u{9cd}রিম",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("dienn-skorn mod Italia"),
            keywords: &[
                "dibenn-pred",
                "dienn-skorn",
                "dienn-skorn mod Italia",
                "skorn",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("sladoled na točenje"),
            keywords: &["desert", "krema", "led", "sladoled", "sladoled na točenje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("gelat de màquina"),
            keywords: &["gelat", "gelat de màquina", "màquina"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏁᏍᏓᎵᏗᏍᏓᏅ ᎤᏅᏗ"),
            keywords: &[
                "ᎤᎦᎾᏍᏓ",
                "ᎤᎦᎾᏗᏓ ᎠᎩᏍᏗ",
                "ᎤᎦᏛᏢᏓ",
                "ᎤᏁᏍᏓᎳ",
                "ᎤᏅᏗ ᎦᏁᏍᏓᎳᏗᏍᏔᏅ",
                "ᎦᏁᏍᏓᎵᏗᏍᏓᏅ ᎤᏅᏗ",
                "ᏩᏂᎨ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("točená zmrzlina"),
            keywords: &[
                "cukrovinka",
                "dezert",
                "jemný",
                "kornout",
                "kornoutek",
                "sladkost",
                "sladký",
                "točená zmrzlina",
                "zmrzlina",
                "zákusek",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("hufen iâ meddal"),
            keywords: &["hufen", "iâ", "meddal", "melys", "pwdin"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("softice"),
            keywords: &["is", "softice"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Softeis"),
            keywords: &["Eis", "Softeis"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("παγωτό χωνάκι"),
            keywords: &[
                "γλυκό",
                "επιδόρπιο",
                "κρέμα",
                "μαλακό",
                "παγωμένο",
                "παγωτό",
                "παγωτό χωνάκι",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("soft ice cream"),
            keywords: &["cream", "dessert", "ice", "icecream", "soft", "sweet"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("soft serve"),
            keywords: &["cream", "dessert", "ice cream", "soft serve", "sweet"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["cream", "dessert", "ice", "soft", "sweet"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cucurucho de helado"),
            keywords: &[
                "cucurucho",
                "cucurucho de helado",
                "dulce",
                "helado",
                "helado de cucurucho",
                "restaurante",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("helado en cucurucho"),
            keywords: &[
                "comida",
                "dulce",
                "frío",
                "helado",
                "helado en cucurucho",
                "restaurante",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("helado en barquillo"),
            keywords: &["helado en barquillo"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("nieve en cono"),
            keywords: &["cono", "dulce", "hielo", "nieve", "nieve en cono", "postre"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("pehme jäätis"),
            keywords: &["jäätis", "magus", "magustoit", "pehme"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("izozki krematsua"),
            keywords: &[
                "esne",
                "gozo",
                "izotz",
                "izozki",
                "izozki krematsua",
                "postre",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بستنی قیفی"),
            keywords: &["بستنی", "بستنی قیفی", "خامه", "دسر", "شیرین", "نرم", "یخ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pehmis"),
            keywords: &[
                "jälkiruoka",
                "jää",
                "jäätelö",
                "kerma",
                "makea",
                "pehmeä",
                "pehmis",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("swirl ice cream"),
            keywords: &[
                "dessert",
                "ice cream",
                "matamis",
                "pagkain",
                "panghimagas",
                "swirl ice cream",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kramarhúsísur"),
            keywords: &["kramarhús", "kramarhúsísur", "matur", "ísur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("glace italienne"),
            keywords: &["glace", "glace italienne"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("crème glacée molle"),
            keywords: &[
                "cornet",
                "crème glacée",
                "crème glacée molle",
                "dessert",
                "glace",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("uachtar reoite coipthe"),
            keywords: &[
                "cón uachtair reoite",
                "uachtar reoite",
                "uachtar reoite coipthe",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("reòiteag bhog"),
            keywords: &[
                "bog",
                "milis",
                "milseag",
                "reòiteag",
                "reòiteag bhog",
                "uachdar",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("xeado de máquina"),
            keywords: &["cremoso", "doce", "sobremesa", "xeado", "xeado de máquina"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સોફ\u{acd}ટ આઇસ ક\u{acd}રીમ"),
            keywords: &[
                "આઇસ ક\u{acd}રીમ",
                "ક\u{acd}રીમ",
                "ર\u{ac7}સ\u{acd}ટોરન\u{acd}ટ",
                "સોફ\u{acd}ટ આઇસ ક\u{acd}રીમ",
                "સોફ\u{acd}ટ સર\u{acd}વ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ƙanƙara Mai taushi"),
            keywords: &[
                "kayan zaƙi",
                "mai taushi",
                "mai zaƙi",
                "ƙanƙara",
                "ƙanƙara Mai taushi",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גלידה בגביע"),
            keywords: &["גביע", "גלידה", "גלידה אמריקאית", "גלידה בגביע", "מתוק"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सॉफ\u{93c}\u{94d}ट आइसक\u{94d}रीम"),
            keywords: &[
                "आइसक\u{94d}रीम",
                "क\u{94d}रीम",
                "नरम आइसक\u{94d}रीम",
                "र\u{947}स\u{94d}टोर\u{947}\u{902}ट",
                "सॉफ\u{93c}\u{94d}ट आइसक\u{94d}रीम",
                "सॉफ\u{93c}\u{94d}ट सर\u{94d}व",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("meki sladoled"),
            keywords: &[
                "desert",
                "led",
                "meki sladoled",
                "meko",
                "sladoled",
                "slatko",
                "vrhnje",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("lágyfagylalt"),
            keywords: &[
                "desszert",
                "fagyi",
                "gépi fagylalt",
                "lágyfagylalt",
                "édesség",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("լցնովի պաղպաղակ"),
            keywords: &["աղանդեր", "լցնովի", "կրեմ", "պաղպաղակ", "քաղցր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("es krim lembut"),
            keywords: &["es", "krim", "lembut", "makanan", "manis", "penutup"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihe nracha dị nrọ"),
            keywords: &[
                "dị nro",
                "ihe nracha dị nrọ",
                "ihenracha",
                "nri nracha",
                "àchịcha ụtọ",
                "ụtọ",
                "ụtọ oyi",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("rjómaís"),
            keywords: &["rjómaís", "veitingastaður", "ís", "ís úr vél"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cono gelato"),
            keywords: &["cono gelato", "crema", "gelato", "ristorante"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ソフトクリーム"),
            keywords: &["アイス", "スイーツ", "ソフト", "ソフトクリーム", "デザート"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("es krim salju"),
            keywords: &[
                "alus",
                "es",
                "es krim salju",
                "krim",
                "legi",
                "panganan manis",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("რბილი ნაყინი"),
            keywords: &[
                "დესერტი",
                "ნაღები",
                "ნაყინი",
                "რბილი",
                "ტკბილეული",
                "ტკბილი",
                "ყინული",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жұмсақ балмұздақ"),
            keywords: &["балмұздақ", "десерт", "жұмсақ", "крем", "мұз", "тәтті"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("softice"),
            keywords: &["is", "softice"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ការេមផ\u{17d2}លែឈើ"),
            keywords: &[
                "ការេម",
                "ការេមផ\u{17d2}លែឈើ",
                "ការ\u{17c9}េម",
                "ទន\u{17cb}",
                "ទ\u{17b9}កកក",
                "ផ\u{17d2}អែម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮ\u{cc6}ತ\u{ccd}ತಗ\u{cbf}ನ ಐಸ\u{ccd} ಕ\u{ccd}ರೀಮ\u{ccd}"),
            keywords: &[
                "ಐಸ\u{ccd} ಕ\u{ccd}ರೀಮ\u{ccd}",
                "ಮ\u{cc6}ತ\u{ccd}ತಗ\u{cbf}ನ ಐಸ\u{ccd} ಕ\u{ccd}ರೀಮ\u{ccd}",
                "ಸಾಫ\u{ccd}ಟ\u{ccd} ಐಸ\u{ccd} ಕ\u{ccd}ರೀಮ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("소프트 아이스크림"),
            keywords: &["소프트 아이스크림", "아이스크림 콘", "콘 아이스크림"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("सॉफ\u{94d}ट आयस क\u{94d}रीम"),
            keywords: &[
                "आयस",
                "आयसक\u{94d}रीम",
                "क\u{94d}रीम",
                "गोड",
                "ड\u{947}झर\u{94d}ट",
                "सॉफ\u{94d}ट",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жумшак балмуздак"),
            keywords: &["балмуздак", "десерт", "жумшак", "муз", "таттуу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Softice"),
            keywords: &["Crème", "Dessert", "Glace", "Softice", "séiss", "Äis"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກະແລ\u{ecb}ມນ\u{eb8}\u{ec9}ມ"),
            keywords: &[
                "ກະແລ\u{ecb}ມ",
                "ກະແລ\u{ecb}ມນ\u{eb8}\u{ec9}ມ",
                "ໄອສະຄຣ\u{eb5}ມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("minkšti ledai"),
            keywords: &["desertas", "kremas", "ledai", "minkšti", "saldu"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("saldējums vafeļu glāzītē"),
            keywords: &[
                "deserts",
                "krēms",
                "mīksts",
                "salds",
                "saldējums",
                "saldējums vafeļu glāzītē",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("aihikirīmi ngohengohe"),
            keywords: &[
                "aihikirīmi",
                "huka",
                "kirīmi",
                "ngohengohe",
                "puruni",
                "reka",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("сладолед на точење"),
            keywords: &["десерт", "сладолед на точење", "слатко", "точење"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സോഫ\u{d4d}\u{200c}റ\u{d4d}റ\u{d4d} ഐസ\u{d4d}\u{200c}ക\u{d4d}രീം"),
            keywords: &[
                "ഐസ\u{d4d} ക\u{d4d}രീം",
                "ഐസ\u{d4d}ക\u{d4d}രീം",
                "ഭക\u{d4d}ഷണം",
                "സോഫ\u{d4d}റ\u{d4d}റ\u{d4d} ഐസ\u{d4d} ക\u{d4d}രീം",
                "സോഫ\u{d4d}\u{200c}റ\u{d4d}റ\u{d4d} ഐസ\u{d4d}\u{200c}ക\u{d4d}രീം",
                "ഹോട\u{d4d}ടൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("шинэхэн мөхөөлдөс"),
            keywords: &["амттан", "мөхөөлдөс", "шинэхэн"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मऊ आइसक\u{94d}रीम"),
            keywords: &[
                "आइस\u{94d}क\u{94d}रीम",
                "क\u{94d}रीम",
                "गोड",
                "बर\u{94d}फ",
                "मऊ",
                "मऊ आइसक\u{94d}रीम",
                "मिठाई",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("ais krim lembut"),
            keywords: &["ais", "krim", "lembut", "manis", "pencuci mulut"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ġelat artab"),
            keywords: &["artab", "deżerta", "krema", "silġ", "ġelat", "ħelu"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ရေခ\u{1032}မ\u{102f}န\u{1037}\u{103a} အပျော\u{1037}"),
            keywords: &[
                "မလ\u{102d}\u{102f}င\u{103a}",
                "ရေခ\u{1032}",
                "ရေခ\u{1032}မ\u{102f}န\u{1037}\u{103a}",
                "ရေခ\u{1032}မ\u{102f}န\u{1037}\u{103a} အပျော\u{1037}",
                "အချ\u{102d}\u{102f}",
                "အချ\u{102d}\u{102f}ပ\u{103d}\u{1032}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("soft-is"),
            keywords: &["dessert", "is", "iskrem", "restaurant", "soft-is", "softis"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("सफ\u{94d}ट आइसक\u{94d}रिम"),
            keywords: &[
                "आइसक\u{94d}रिम",
                "आईस",
                "क\u{94d}रिम",
                "मिठाई",
                "मिठो",
                "सफ\u{94d}ट",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("softijs"),
            keywords: &["dessert", "ijs", "roomijs", "softijs", "zacht", "zoet"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("soft-is"),
            keywords: &["dessert", "is", "iskrem", "restaurant", "soft-is", "softis"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ନରମ ଆଇସ\u{b4d}\u{200d} କ\u{b4d}ର\u{b3f}ମ\u{b4d}\u{200d}"),
            keywords: &[
                "ଆଇସକ\u{b4d}ର\u{b3f}ମ\u{b4d}\u{200c}",
                "କ\u{b4d}ର\u{b3f}ମ\u{b4d}\u{200c}",
                "ଡ\u{b3c}େଜର\u{b4d}ଟ",
                "ନରମ",
                "ନରମ ଆଇସ\u{b4d}\u{200d} କ\u{b4d}ର\u{b3f}ମ\u{b4d}\u{200d}",
                "ବରଫ",
                "ମ\u{b3f}ଠ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਨਰਮ ਆਇਸਕ\u{a4d}ਰੀਮ"),
            keywords: &[
                "ਆਇਸ ਕਰੀਮ",
                "ਕ\u{a4d}ਰੀਮ",
                "ਨਰਮ",
                "ਨਰਮ ਆਇਸਕ\u{a4d}ਰੀਮ",
                "ਮਠਿਆਈ",
                "ਮਿ\u{a71}ਠਾ",
                "ਹ\u{a4b}ਟਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("نرم آئس کریم"),
            keywords: &[
                "آئس کریم",
                "برف",
                "میٹھائی",
                "میٹھی شے",
                "نرم",
                "نرم آئس کریم",
                "کریم",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Sọ\u{301}ft Aís Krim"),
            keywords: &[
                "Ais",
                "Aískrim",
                "Dẹzat",
                "Krim",
                "Swit",
                "Swít Fud Wé Dẹm De Chọ\u{301}p Áftá Di Mén Fud",
                "Sọft",
                "Sọ\u{301}ft Aís Krim",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("lody włoskie"),
            keywords: &["lody włoskie", "lody śmietankowe", "w kubku"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("نرم آيس کریم"),
            keywords: &["نرم آيس کریم"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("sorvete italiano"),
            keywords: &[
                "sorvete",
                "sorvete de casquinha",
                "sorvete italiano",
                "sorvete na casquinha",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cone de gelado"),
            keywords: &[
                "cone de gelado",
                "creme",
                "cremoso",
                "doce",
                "gelado",
                "gelo",
                "sobremesa",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("llampʼu helado"),
            keywords: &[
                "chiri",
                "helado",
                "llampʼu helado",
                "llamp’u",
                "miski",
                "postre",
                "tunti q’illu",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("înghețată cremă"),
            keywords: &["cornet", "desert", "înghețată", "înghețată cremă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-299"),
            keywords: &["E10-299"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мороженое в стаканчике"),
            keywords: &[
                "вафельный стаканчик",
                "вафля",
                "мороженое",
                "мороженое в стаканчике",
                "мягкое мороженое",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ayisikirimu yoroheje"),
            keywords: &[
                "ayisikirimu yoroheje",
                "balafu",
                "deseri",
                "iryoshye",
                "ise sikirimu",
                "kereme",
                "yoroshye",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("نرم آئسڪريم"),
            keywords: &["نرم آئسڪريم", "ڪريم، مٺو، برف، آئسڪريم، نرم، مٺائي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මෘද\u{dd4} අය\u{dd2}ස\u{dca} ක\u{dca}\u{200d}ර\u{dd3}ම\u{dca}"),
            keywords: &[
                "අත\u{dd4}ර\u{dd4}පස",
                "අය\u{dd2}ස\u{dca}",
                "ක\u{dca}\u{200d}ර\u{dd3}ම\u{dca}",
                "මෘද\u{dd4} අය\u{dd2}ස\u{dca} ක\u{dca}\u{200d}ර\u{dd3}ම\u{dca}",
                "මෘද\u{dd4}. පැණ\u{dd2} රස",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("točená zmrzlina"),
            keywords: &[
                "dezert",
                "krém",
                "sladkosť",
                "točená zmrzlina",
                "zmrzlina",
                "čapovaná",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("rahel sladoled"),
            keywords: &[
                "krema",
                "led",
                "mehko",
                "posladek",
                "rahel sladoled",
                "sladko",
                "sladoled",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("jallaato jilicsan"),
            keywords: &[
                "baraf",
                "jallaata",
                "jallaato jilicsan",
                "jilicsan",
                "labeen",
                "macaan",
                "macmacaan",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("akullore e butë"),
            keywords: &["akullore", "akullore e butë", "krem", "ëmbëlsirë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("сладолед у корнету"),
            keywords: &[
                "дeсeрт",
                "корнет",
                "крем",
                "лeд",
                "слaдoлeд",
                "слaткo",
                "сладолед у корнету",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("sladoled u kornetu"),
            keywords: &[
                "desert",
                "kornet",
                "krem",
                "led",
                "sladoled",
                "sladoled u kornetu",
                "slatko",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("mjukglass"),
            keywords: &["efterrätt", "glass", "mjukglass"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("aisikrimu laini"),
            keywords: &[
                "aisikrimu",
                "barafu",
                "kitandamlo",
                "krimu",
                "laini",
                "tamu",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கோன\u{bcd} ஐஸ\u{bcd}"),
            keywords: &[
                "உணவகம\u{bcd}",
                "உணவு",
                "ஐஸ\u{bcd}க\u{bcd}ர\u{bc0}ம\u{bcd}",
                "கோன\u{bcd} ஐஸ\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c3e}ఫ\u{c4d}ట\u{c4d} ఐస\u{c4d} క\u{c4d}ర\u{c40}ం"),
            keywords: &[
                "ఐస\u{c4d}\u{200c}క\u{c4d}ర\u{c40}మ\u{c4d}",
                "క\u{c4d}ర\u{c40}మ\u{c4d}",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
                "స\u{c3e}ఫ\u{c4d}ట\u{c4d} ఐస\u{c4d} క\u{c4d}ర\u{c40}ం",
                "స\u{c3e}ఫ\u{c4d}ట\u{c4d} సర\u{c4d}వ\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("яхмоси мулоим"),
            keywords: &[
                "десерт",
                "крем",
                "мулоим",
                "ширин",
                "ях",
                "яхмос",
                "яхмоси мулоим",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ซอฟต\u{e4c}คร\u{e35}ม"),
            keywords: &["ซอฟต\u{e4c}คร\u{e35}ม", "ไอศกร\u{e35}ม"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýumşak buzgaýmak"),
            keywords: &["buz", "buzgaýmak", "desert", "krem", "süýji", "ýumşak"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻaisikilimi molū"),
            keywords: &["ʻaisikilimi molū"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yumuşak dondurma"),
            keywords: &["dondurma", "krema", "restoran", "yumuşak dondurma"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يۇمشاق مۇزقايماق"),
            keywords: &["تاتلىق", "قايماق", "مۇز", "مۇزقايماق", "يۇمشاق", "پىشۇرۇق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("морозиво в ріжку"),
            keywords: &[
                "десерт",
                "морозиво",
                "морозиво в ріжку",
                "м’який",
                "солодкий",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سافٹ آئس کریم"),
            keywords: &["برف", "سافٹ آئس کریم", "میٹھی", "نرم", "کریم"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yumshoq muzqaymoq"),
            keywords: &["krem", "muz", "muzqaymoq", "shirin", "shirinlik", "yumshoq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("kem mềm"),
            keywords: &["cái kem", "kem", "món tráng miệng", "mềm", "ngọt"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kreem galaas bu am suukar"),
            keywords: &[
                "deseer",
                "galaas",
                "kreem",
                "kreem galaas bu am suukar",
                "kreem-galaase",
                "nooy",
                "suukër",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iayiskrim ethambileyo"),
            keywords: &[
                "emnandi",
                "ethambileyo",
                "i-dessert",
                "iayiskrim",
                "ikhrimu",
                "umkhenkce",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Wara Didi Rirọ"),
            keywords: &[
                "Wara Didi Rirọ",
                "fẹ\u{301}lẹ\u{301}",
                "kírímù",
                "yìnyín",
                "yìnyín dídùn",
                "àdídùn",
                "ónjẹ dídùn",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("軟雪糕"),
            keywords: &["冰", "忌廉", "甜", "甜品", "軟", "軟雪糕", "雪糕"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("软雪糕"),
            keywords: &["冰", "忌廉", "甜", "甜品", "软", "软雪糕", "雪糕"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("圆筒冰激凌"),
            keywords: &["圆筒冰淇淋", "圆筒冰激凌"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("霜淇淋"),
            keywords: &["冰品", "霜淇淋"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("軟雪糕"),
            keywords: &["甜筒", "甜筒雪榚", "軟雪糕", "雪榚"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("u-ice cream othambile"),
            keywords: &[
                "okunoshukela",
                "okuthambile",
                "u-ice cream",
                "u-ice cream othambile",
                "ukhilimu",
            ],
        },
    ],
};
#[doc = "🍧"]
pub const SHAVED_ICE: crate::Emoji = crate::Emoji {
    glyph: "🍧",
    codepoint: "1F367",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "shaved ice",
    group: "Food & Drink",
    subgroup: "food-sweet",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("ysskaafsels"),
            keywords: &["kos", "nagereg", "rasper", "skaaf", "soet", "ysskaafsels"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የተሸለተ አይስክሬም"),
            keywords: &["አይስ", "የተሸለተ", "የተሸለተ አይስክሬም", "ጣፋጭ", "ጣፋጭ ምግብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}آيس كريم مجروش"),
            keywords: &["مطعم", "\u{202b}آيس كريم مجروش"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চেভড আইচ"),
            keywords: &["আইচ", "চেভড", "ডেজ\u{9be}ৰ\u{9cd}ট", "মিঠ\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("rəndələnmiş dondurma"),
            keywords: &[
                "buz",
                "desert",
                "rəndələnmiş",
                "rəndələnmiş dondurma",
                "şirin",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("фруктовы лёд"),
            keywords: &["дэсерт", "лёд", "салодкі", "фруктовы"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Леден десерт"),
            keywords: &["Леден десерт", "десерт", "лед", "сладък"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("শেভড আইস"),
            keywords: &[
                "চ\u{9be}\u{981}চ\u{9be}",
                "ডেজ\u{9be}র\u{9cd}ট",
                "বরফ",
                "মিষ\u{9cd}টি",
                "শেভড আইস",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("greunitad"),
            keywords: &["dibenn-pred", "greunitad", "skorn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("havajski sladoled"),
            keywords: &["desert", "havajski sladoled", "led", "sladoled"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("granissat"),
            keywords: &["dolç", "gel", "granissat", "picat", "postres"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏁᏍᏓᎳ ᎠᏍᏙᏰᏓ"),
            keywords: &["ᎠᏍᏙᏰᏓ", "ᎤᎦᎾᏍᏓ", "ᎤᏁᏍᏓᎳ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("ledová tříšť"),
            keywords: &[
                "cukrovinka",
                "dezert",
                "led",
                "ledová tříšť",
                "sladkost",
                "sladký",
                "tříšť",
                "zákusek",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("iâ wedi’i siafio"),
            keywords: &["hufen", "iâ", "iâ wedi’i siafio", "melys", "pwdin"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("isdessert"),
            keywords: &["is", "isdessert", "slush ice", "snow cone"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Wassereis"),
            keywords: &["Eis", "Sorbet", "Wassereis"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γρανίτα"),
            keywords: &["γλυκό", "γρανίτα", "επιδόρπιο", "παγωτό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("shaved ice"),
            keywords: &["dessert", "ice", "shaved", "sweet"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("granita"),
            keywords: &["dessert", "granita", "ice", "sweet"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("granizado hawaiano"),
            keywords: &["granizado hawaiano", "helado", "hielo", "postre", "raspado"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("hielo molido"),
            keywords: &[
                "comida",
                "dulce",
                "frío",
                "helado",
                "hielo",
                "hielo molido",
                "restaurante",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["dulce", "frío", "helado", "hielo", "hielo molido"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("raspado"),
            keywords: &["dulce", "hielo", "postre", "raspa", "raspado"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("mahlajää"),
            keywords: &["jää", "magus", "magustoit", "mahlajää"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("izotz arraspatua"),
            keywords: &["arraspatu", "gozo", "izotz", "izotz arraspatua", "postre"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("یخ در بهشت"),
            keywords: &["دسر", "شیرین", "یخ", "یخ در بهشت"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("jäähilejälkiruoka"),
            keywords: &[
                "herkku",
                "jälkiruoka",
                "jää",
                "jäähile",
                "jäähilejälkiruoka",
                "makea",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("shaved ice"),
            keywords: &[
                "kinaskas na yelo",
                "matamis",
                "panghimagas",
                "shaved ice",
                "yelo",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("ísur í skál"),
            keywords: &["dessert", "matur", "skál", "ísur", "ísur í skál"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("granité"),
            keywords: &["glace", "granité"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("glace pilée"),
            keywords: &["glace", "pilée"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("oighear bearrtha"),
            keywords: &["bearrtha", "milis", "milseog", "oighear"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("deigh bheàrrte"),
            keywords: &[
                "beàrrte",
                "deigh",
                "deigh bheàrrte",
                "milis",
                "milseag",
                "reòiteag",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("sobremesa de xeo picado"),
            keywords: &["picado", "sobremesa", "sobremesa de xeo picado", "xeo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("શ\u{ac7}વ\u{acd}ડ આઇસ ક\u{acd}રીમ"),
            keywords: &[
                "આઇસ",
                "ર\u{ac7}સ\u{acd}ટોરન\u{acd}ટ",
                "શ\u{ac7}વ\u{acd}ડ",
                "શ\u{ac7}વ\u{acd}ડ આઇસ ક\u{acd}રીમ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("rugurgujen ƙanƙara"),
            keywords: &[
                "kayan zaƙi",
                "mai zaƙi",
                "rugurguje",
                "rugurgujen ƙanƙara",
                "ƙanƙara",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קערית ברד"),
            keywords: &["ברד", "ממותק", "קערית ברד", "קרח"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पीसी बर\u{94d}फ\u{93c}"),
            keywords: &[
                "च\u{942}रा",
                "पीसी बर\u{94d}फ\u{93c}",
                "र\u{947}स\u{94d}टोर\u{947}\u{902}ट",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("sladoled s komadićima leda"),
            keywords: &[
                "desert",
                "komadići",
                "led",
                "sladoled s komadićima leda",
                "slatko",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fagylalt öntettel"),
            keywords: &["desszert", "fagyi", "fagylalt öntettel", "édesség", "öntet"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մանրացված սառույց"),
            keywords: &["աղանդեր", "մանրացված", "սառույց", "քաղցր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("es serut"),
            keywords: &["es", "makanan", "manis", "penutup", "serut"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihe aracha na-akpụchara akpụcha"),
            keywords: &[
                "akpụchara akpụcha",
                "ihe aracha na-akpụchara akpụcha",
                "àchịcha ụtọ",
                "ụtọ",
                "ụtọ oyi",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("skafís"),
            keywords: &["skafinn", "skafís", "veitingastaður", "ís"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("granita"),
            keywords: &[
                "Sicilia",
                "estate",
                "ghiaccio",
                "granita",
                "granita siciliana",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("かき氷"),
            keywords: &["かき氷", "アイス", "デザート", "氷"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("es puter"),
            keywords: &["es", "es kokrok", "es puter", "legi", "panganan manis"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ნაყინის ბურთულები"),
            keywords: &[
                "ბურთულა",
                "დესერტი",
                "ნაყინის ბურთულები",
                "ტკბილეული",
                "ტკბილი",
                "ყინული",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("мұзды балмұздақ"),
            keywords: &["десерт", "музды", "мұз", "мұзды балмұздақ", "тәтті"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("snedessert"),
            keywords: &["is", "isdessert", "snedessert"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ទ\u{17b9}កកកឈ\u{17bc}ស"),
            keywords: &[
                "ទ\u{17b9}កកក",
                "ទ\u{17b9}កកកឈ\u{17bc}ស",
                "បង\u{17d2}អែម",
                "ផ\u{17d2}អែម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕತ\u{ccd}ತರ\u{cbf}ಸ\u{cbf}ದ ಐಸ\u{ccd}"),
            keywords: &["ಐಸ\u{ccd}", "ಕತ\u{ccd}ತರ\u{cbf}ಸ\u{cbf}ದ ಐಸ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("샤베트 아이스크림"),
            keywords: &["샤베트", "샤베트 아이스크림"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("श\u{947}व\u{94d}ड आयस"),
            keywords: &["आयस", "गोड", "ड\u{947}झर\u{94d}ट", "श\u{947}व\u{94d}ड"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жылмаланган муз"),
            keywords: &["десерт", "жылмаланган", "муз", "таттуу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Waasserglace"),
            keywords: &["Dessert", "Glace", "Waasser", "Waasserglace", "séiss"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ນ\u{ecd}\u{ec9}າກ\u{ec9}ອນບ\u{ebb}ດ"),
            keywords: &[
                "ຂອງຫວານ",
                "ນ\u{ecd}\u{ec9}າກ\u{ec9}ອນ",
                "ນ\u{ecd}\u{ec9}າກ\u{ec9}ອນບ\u{ebb}ດ",
                "ນ\u{ecd}\u{ec9}າຫວານ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("susmulkintas ledas"),
            keywords: &[
                "desertas",
                "ledas",
                "saldu",
                "smulkintas",
                "susmulkintas ledas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("smalcināts ledus ar sīrupu"),
            keywords: &["deserts", "ledus", "salds", "smalcināts ledus ar sīrupu"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("huka heuheu"),
            keywords: &["heua", "huka", "huka heuheu", "puruni", "reka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("сладолед од мраз"),
            keywords: &["десерт", "мраз", "сладолед од мраз", "слатко"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഷേവ\u{d4d}ഡ\u{d4d} ഐസ\u{d4d}"),
            keywords: &[
                "ഐസ\u{d4d}",
                "ഐസ\u{d4d}\u{200c}ക\u{d4d}രീം",
                "ഭക\u{d4d}ഷണം",
                "ഷേവ\u{d4d}ഡ\u{d4d} ഐസ\u{d4d}",
                "ഹോട\u{d4d}ടൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хөлдөөсөн мөс"),
            keywords: &["амттан", "мөс", "хөлдөөсөн"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("श\u{947}व आइस"),
            keywords: &[
                "किसल\u{947}ला",
                "गोड",
                "बर\u{94d}फ",
                "मिठाई",
                "श\u{947}व आइस",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("air batu campur"),
            keywords: &["air batu campur", "ais", "kisar", "manis", "pencuci mulut"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("silġ imqaxxar"),
            keywords: &["deżerta", "imqaxxar", "silġ", "ħelu"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ရေခ\u{1032}ခြစ\u{103a}မ\u{102f}န\u{1037}\u{103a}"),
            keywords: &[
                "ရေခ\u{1032}",
                "ရေခ\u{1032}ခြစ\u{103a}",
                "ရေခ\u{1032}ခြစ\u{103a}မ\u{102f}န\u{1037}\u{103a}",
                "အချ\u{102d}\u{102f}",
                "အချ\u{102d}\u{102f}ပ\u{103d}\u{1032}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("slush-is"),
            keywords: &["dessert", "is", "restaurant", "shave-ice", "slush-is"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("तयार पारिएको आइस क\u{94d}रिम"),
            keywords: &[
                "आइस",
                "तयार पारिएको आइस क\u{94d}रिम",
                "मिठाई",
                "मिठो",
                "मोडिएको",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("geschaafd ijs"),
            keywords: &["dessert", "geschaafd", "ijs", "zoet"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("slush-is"),
            keywords: &["dessert", "is", "restaurant", "shave-ice", "slush-is"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଚ\u{b41}ସ\u{b4d}\u{200c}କ\u{b3f}"),
            keywords: &[
                "ଚ\u{b41}ସ\u{b4d}\u{200c}କ\u{b3f}",
                "ଡ\u{b3c}େଜର\u{b4d}ଟ",
                "ପରଷ\u{b3f}ବ\u{b3e}",
                "ବରଫ",
                "ମ\u{b3f}ଠ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬਰਫ\u{a3c} ਦਾ ਚ\u{a42}ਸਾ"),
            keywords: &[
                "ਆਇਸ",
                "ਡਿਜ\u{a3c}ਾਈਨਦਾਰ ਆਇਸ",
                "ਬਰਫ\u{a3c} ਦਾ ਚ\u{a42}ਸਾ",
                "ਮਠਿਆਈ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("منڈوی برف"),
            keywords: &["برف", "داڑھی مونڈنا", "منڈوی برف", "میٹھائی", "میٹھی شے"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ais Wé Dẹm Dọ\u{301}n Shev"),
            keywords: &[
                "Ais",
                "Ais Wé Dẹm Dọ\u{301}n Shev",
                "Shev",
                "Swit",
                "Swít Fud Wé Dẹm De Chọ\u{301}p Áftá Di Mén Fud",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("lody hawajskie"),
            keywords: &["deser", "lody", "lody hawajskie", "lody kulki"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پالوده"),
            keywords: &["صحرا، کنګل، پالوده، خوږ", "پالوده"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("raspadinha de gelo"),
            keywords: &["gelo", "raspadinha", "raspadinha de gelo", "sobremesa"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("granizado"),
            keywords: &["doce", "gelo", "granizado", "sobremesa"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("raspadillo"),
            keywords: &["chiri", "miski", "postre", "raspadillo"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("desert din fulgi de gheață"),
            keywords: &[
                "desert",
                "desert din fulgi de gheață",
                "dulce",
                "gheață",
                "înghețată",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-300"),
            keywords: &["E10-300"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мороженое в креманке"),
            keywords: &[
                "десерт",
                "креманка",
                "мороженое",
                "мороженое в креманке",
                "строганый лед",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("urubura rusennye neza"),
            keywords: &[
                "balafue",
                "deseri",
                "iryoshye",
                "itariho urufuro",
                "urubura rusennye neza",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("گنڊو"),
            keywords: &["مٺو، برف، ڳنڊو، مٺائي", "گنڊو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වර\u{dca}ණ ගැන\u{dca}ව\u{dd6} අය\u{dd2}ස\u{dca}"),
            keywords: &[
                "අත\u{dd4}ර\u{dd4}පස",
                "අය\u{dd2}ස\u{dca}",
                "පැණ\u{dd2} රස",
                "වර\u{dca}ණ ගැන\u{dca}ව\u{dd6}",
                "වර\u{dca}ණ ගැන\u{dca}ව\u{dd6} අය\u{dd2}ස\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("mrazená dreň"),
            keywords: &["dezert", "dreň", "mrazená dreň", "sladkosť", "zmrzlina"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("nastrgan led"),
            keywords: &["led", "nastrgan led", "nastrgano", "posladek", "sladko"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("macmacaan baraf la buburiyay"),
            keywords: &[
                "baraf",
                "la burburiyay",
                "macaan",
                "macmacaan",
                "macmacaan baraf la buburiyay",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("akull i grirë"),
            keywords: &["akull", "akull i grirë", "i grirë", "ëmbëlsirë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("сорбе"),
            keywords: &["дeсeрт", "лeд", "слaткo", "сорбе"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("sorbe"),
            keywords: &["desert", "led", "slatko", "sorbe"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kakigōri"),
            keywords: &["dessert", "efterrätt", "is", "kakigōri"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("barafu iliyochongwa"),
            keywords: &[
                "aisikrimu",
                "barafu",
                "barafu iliyochongwa",
                "katwakatwa",
                "kitindamlo",
                "tamu",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சிரப\u{bcd} ஊற\u{bcd}றிய ஐஸ\u{bcd}கிர\u{bc0}ம\u{bcd}"),
            keywords: &[
                "உணவகம\u{bcd}",
                "உணவு",
                "ஐஸ\u{bcd}க\u{bcd}ர\u{bc0}ம\u{bcd}",
                "சிரப\u{bcd} ஊற\u{bcd}றிய ஐஸ\u{bcd}கிர\u{bc0}ம\u{bcd}",
                "ஷேவ\u{bcd}ட\u{bcd} ஐஸ\u{bcd}க\u{bcd}ர\u{bc0}ம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "గుండ\u{c4d}రంగ\u{c3e} చ\u{c46}క\u{c4d}క\u{c3f}నట\u{c4d}లు ఉండ\u{c47} ఐస\u{c4d}",
            ),
            keywords: &[
                "ఐస\u{c4d}",
                "గుండ\u{c4d}రంగ\u{c3e} చ\u{c46}క\u{c4d}క\u{c3f}నట\u{c4d}లు ఉండ\u{c47} ఐస\u{c4d}",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
                "ష\u{c47}వ\u{c4d}డ\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тарошаи ях"),
            keywords: &["десерт", "тарошаи ях", "тарошида", "ширин", "ях"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("น\u{e49}ำแข\u{e47}งไส"),
            keywords: &[
                "ของหวาน",
                "น\u{e49}ำหวาน",
                "น\u{e49}ำแข\u{e47}ง",
                "น\u{e49}ำแข\u{e47}งไส",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("syrylan buz"),
            keywords: &["buz", "desert", "syrylan", "süýji"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻaisitele"),
            keywords: &["ʻaisitele"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("meyveli buz"),
            keywords: &["buz", "meyveli", "restoran"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قىرغان مۇز"),
            keywords: &["تاتلىق", "قىرغان مۇز", "قىرىش", "مۇز", "پىشۇرۇق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("льодова стружка"),
            keywords: &["десерт", "льодова стружка", "лід", "солодкий", "стружка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("تراشیدہ برف"),
            keywords: &["برف", "تراشی ہوئی", "تراشیدہ برف", "میٹھی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qirilgan muz"),
            keywords: &["muz", "qirilgan", "shirin", "shirinlik"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đá bào"),
            keywords: &["bào", "kem", "món tráng miệng", "ngọt", "đá bào"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("galaas guñ dëbb"),
            keywords: &["buñ wat", "deseer", "galaas", "galaas guñ dëbb", "suukër"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umkhenkce osikiweyo"),
            keywords: &[
                "emnandi",
                "esikiweyo",
                "i-dessert",
                "umkhenkce",
                "umkhenkce osikiweyo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Yinyin Gige"),
            keywords: &["Yinyin Gige", "fá", "yìnyín", "àdídùn", "ónjẹ dídùn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("刨冰"),
            keywords: &["冰", "刨", "刨冰", "甜", "甜品"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("刨冰"),
            keywords: &["冰", "刨", "刨冰", "甜", "甜品"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("刨冰"),
            keywords: &["冰", "冰沙", "刨冰", "甜点"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("刨冰"),
            keywords: &["冰品", "刨冰"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["冰", "刨", "刨冰", "甜品"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-shaved ice"),
            keywords: &[
                "i-shaved ice",
                "iqhwa",
                "okunoshukela",
                "shaved",
                "ubumnandi",
            ],
        },
    ],
};
#[doc = "🍨"]
pub const ICE_CREAM: crate::Emoji = crate::Emoji {
    glyph: "🍨",
    codepoint: "1F368",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "ice cream",
    group: "Food & Drink",
    subgroup: "food-sweet",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("roomys"),
            keywords: &["nagereg", "room", "roomys", "soet", "ys"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አይስክሬም"),
            keywords: &["አይስ", "አይስክሬም", "ክሬም", "ጣፋጭ", "ጣፋጭ ምግብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("آيس كريم"),
            keywords: &["آيس كريم", "مطعم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("আইচ ক\u{9cd}ৰীম"),
            keywords: &["আইচ", "ক\u{9cd}ৰীম", "মিঠ\u{9be}", "মিঠ\u{9be}ই"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("dondurma"),
            keywords: &["buz", "desert", "dondurma", "krem", "şirin"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("марожанае"),
            keywords: &["дэсерт", "марожанае", "марозіва", "салодкі"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("сладолед"),
            keywords: &["десерт", "крем", "сладолед", "сладък"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("আইস ক\u{9cd}রিম"),
            keywords: &[
                "আইস ক\u{9cd}রিম",
                "ক\u{9cd}রিম",
                "ডেজ\u{9be}র\u{9cd}ট",
                "বরফ",
                "মিষ\u{9cd}টি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("dienn-skorn"),
            keywords: &["dibenn-pred", "dienn-skorn", "skorn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("sladoled"),
            keywords: &["desert", "krema", "sladoled", "slatko"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("gelat"),
            keywords: &["crema", "dolç", "gel", "gelat", "postres"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄃𑄌\u{11134}𑄇\u{11133}𑄢\u{11128}𑄟\u{11134}"),
            keywords: &["𑄃𑄌\u{11134}𑄇\u{11133}𑄢\u{11128}𑄟\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏅᏗ ᎦᏁᏍᏓᎳᏗᏍᏔᏅ"),
            keywords: &["ᎤᎦᎾᏍᏓ", "ᎤᎦᎾᏍᏓ ᎠᎩᏍᏗ", "ᎤᎦᏓᏢᏓ", "ᎤᏁᏍᏓᎳ", "ᎤᏅᏗ ᎦᏁᏍᏓᎳᏗᏍᏔᏅ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kopečková zmrzlina"),
            keywords: &[
                "cukrovinka",
                "dezert",
                "kopečková zmrzlina",
                "pohár",
                "sladkost",
                "sladký",
                "zmrzlina",
                "zmrzlinový",
                "zákusek",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("hufen iâ"),
            keywords: &["hufen", "iâ", "melys", "pwdin"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("is"),
            keywords: &["is", "isdessert"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Eiscreme"),
            keywords: &["Eis", "Eisbecher", "Eiscreme", "Eisdiele"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("παγωτό"),
            keywords: &["γλυκό", "επιδόρπιο", "κρέμα", "παγωτό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("ice cream"),
            keywords: &["cream", "dessert", "ice", "sweet"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["cream", "dessert", "ice cream", "sweet"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("helado"),
            keywords: &["helado", "postre", "sorbete"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["crema", "dulce", "helada", "helado", "postre"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("jäätis"),
            keywords: &["jäätis", "magus", "magustoit"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("izozkia"),
            keywords: &["esne", "gozo", "izotz", "izozkia", "postre"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بستنی"),
            keywords: &["بستنی", "دسر", "شیرین", "یخ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("jäätelö"),
            keywords: &["jälkiruoka", "jäätelö", "kerma", "makea"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("ice cream"),
            keywords: &["dessert", "ice cream", "matamis", "pagkain", "panghimagas"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("rómaísur í skál"),
            keywords: &["dessert", "matur", "rómaísur í skál", "skál", "ísur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("glace"),
            keywords: &["crème", "dessert", "glace", "sucré"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("crème glacée"),
            keywords: &["crème", "crème glacée", "dessert", "glace", "sucré"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("uachtar reoite"),
            keywords: &["milis", "milseog", "reoite", "uachtar"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("reòiteag"),
            keywords: &["milis", "milseag", "reòiteag", "uachdar"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("copa de xeado"),
            keywords: &["copa", "copa de xeado", "xeado"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("આઇસ ક\u{acd}રીમ"),
            keywords: &["આઇસ", "ક\u{acd}રીમ", "ર\u{ac7}સ\u{acd}ટોરન\u{acd}ટ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ƙanƙara"),
            keywords: &["mai zaƙi", "ƙanƙara", "ƙayan zaƙi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גלידה"),
            keywords: &["גלידה", "מתוק", "קינוח", "קיץ", "קר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("आइसक\u{94d}रीम"),
            keywords: &[
                "आइस",
                "आइसक\u{94d}रीम",
                "क\u{94d}रीम",
                "र\u{947}स\u{94d}टोर\u{947}\u{902}ट",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("sladoled"),
            keywords: &["desert", "led", "sladoled", "slatko", "vrhnje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fagylalt"),
            keywords: &["desszert", "fagyi", "fagylalt", "édesség"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("պաղպաղակ"),
            keywords: &["աղանդեր", "կրեմ", "պաղպաղակ", "քաղցր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("es krim"),
            keywords: &["es", "krim", "makanan", "manis", "penutup"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihe nracha"),
            keywords: &["ihe nracha", "àchịcha ụtọ", "ụtọ", "ụtọ oyi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kúluís"),
            keywords: &["kúluís", "veitingastaður", "ís"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("coppa di gelato"),
            keywords: &["coppa di gelato", "crema", "gelato", "ristorante"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("アイスクリーム"),
            keywords: &["アイス", "アイスクリーム", "スイーツ", "デザート"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("es krim"),
            keywords: &["es", "krim", "legi", "panganan manis"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ნაყინი"),
            keywords: &[
                "დესერტი",
                "ნაღები",
                "ნაყინი",
                "ტკბილეული",
                "ტკბილი",
                "ყინული",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("балмұздақ"),
            keywords: &["балмұздақ", "десерт", "крем", "мұз", "тәтті"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("is"),
            keywords: &["is", "isdessert"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ការេម"),
            keywords: &["ការេម", "ការ\u{17c9}េម", "ទ\u{17b9}កកក", "ផ\u{17d2}អែម"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಐಸ\u{ccd} ಕ\u{ccd}ರೀಮ\u{ccd}"),
            keywords: &["ಐಸ\u{ccd}", "ಐಸ\u{ccd} ಕ\u{ccd}ರೀಮ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("아이스크림"),
            keywords: &["떠먹는 아이스크림", "아이스크림"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("आयस क\u{94d}रीम"),
            keywords: &["आयस", "क\u{94d}रीम", "गोड", "ड\u{947}झर\u{94d}ट"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("балмуздак"),
            keywords: &["балмуздак", "десерт", "муз", "таттуу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Glace"),
            keywords: &["Dessert", "Glace", "séiss", "Äis"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກະແລ\u{ecb}ມ"),
            keywords: &[
                "ກະແລ\u{ecb}ມ",
                "ນ\u{ecd}\u{ec9}າກ\u{ec9}ອນ",
                "ໄອສະຄຣ\u{eb5}ມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("ledai"),
            keywords: &["desertas", "kremas", "ledai", "saldu"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("saldējums"),
            keywords: &["deserts", "krēms", "salds", "saldējums"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("aihikirīmi"),
            keywords: &["aihikirīmi", "huka", "kirīmi", "puruni"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("сладолед"),
            keywords: &["десерт", "сладолед", "слатко"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഐസ\u{d4d}\u{200c}ക\u{d4d}രീം"),
            keywords: &[
                "ഐസ\u{d4d}",
                "ഐസ\u{d4d} ക\u{d4d}രീം",
                "ഐസ\u{d4d}\u{200c}ക\u{d4d}രീം",
                "ഭക\u{d4d}ഷണം",
                "ഹോട\u{d4d}ടൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("мөхөөлдөс"),
            keywords: &["амттан", "крем", "мөс", "мөхөөлдөс", "чихэрлэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("आइसक\u{94d}रीम"),
            keywords: &[
                "आइस क\u{94d}रीम",
                "आइसक\u{94d}रीम",
                "क\u{94d}रीम",
                "गोड",
                "बर\u{94d}फ",
                "मिठाई",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("ais krim"),
            keywords: &["ais", "krim", "manis", "pencuci mulut"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ġelat"),
            keywords: &["deżerta", "krema", "silġ", "ġelat", "ħelu"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ရေခ\u{1032}မ\u{102f}န\u{1037}\u{103a}"),
            keywords: &[
                "မလ\u{102d}\u{102f}င\u{103a}",
                "ရေခ\u{1032}",
                "ရေခ\u{1032}မ\u{102f}န\u{1037}\u{103a}",
                "အချ\u{102d}\u{102f}",
                "အချ\u{102d}\u{102f}ပ\u{103d}\u{1032}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("iskrem"),
            keywords: &["dessert", "is", "iskrem", "restaurant"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("आइस क\u{94d}रिम"),
            keywords: &["आइस", "क\u{94d}रिम", "मिठाई", "मिठो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("ijs"),
            keywords: &["dessert", "ijs", "room", "zoet"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("iskrem"),
            keywords: &["dessert", "is", "iskrem", "restaurant"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଆଇସ\u{b4d}\u{200d} କ\u{b4d}ର\u{b3f}ମ\u{b4d}\u{200d}"),
            keywords: &[
                "ଆଇସ\u{b4d}\u{200d} କ\u{b4d}ର\u{b3f}ମ\u{b4d}\u{200d}",
                "କ\u{b4d}ର\u{b3f}ମ\u{b4d}\u{200c}",
                "ଡ\u{b3c}େଜର\u{b4d}ଟ",
                "ବରଫ",
                "ମ\u{b3f}ଠ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਆਇਸ ਕ\u{a4d}ਰੀਮ"),
            keywords: &["ਆਇਸ", "ਆਇਸਕ\u{a4d}ਰੀਮ", "ਕ\u{a4d}ਰੀਮ", "ਮਠਿਆਈ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("آئس کریم"),
            keywords: &["آئس کریم", "برف", "میٹھائی", "میٹھی شے", "کریم"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Aís Krim"),
            keywords: &[
                "Ais",
                "Aís Krim",
                "Dẹzat",
                "Krim",
                "Swit",
                "Swít Fud Wé Dẹm De Chọ\u{301}p Áftá Di Mén Fud",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("lody"),
            keywords: &["deser", "lody", "lód"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("آیس کریم"),
            keywords: &["آیس کریم", "کريم، صحرا، کنګل، خوږ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("sorvete"),
            keywords: &["sobremesa", "sorvete"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("gelado"),
            keywords: &["creme", "doce", "gelado", "gelo", "sobremesa"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("helado"),
            keywords: &["chiri", "helado", "miski", "postre", "tunti q’illu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("înghețată"),
            keywords: &["cremă", "desert", "dulce", "înghețată"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-301"),
            keywords: &["E10-301"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мороженое"),
            keywords: &["десерт", "мороженое", "сладкое", "холодное"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ayisikirimu"),
            keywords: &["ayisikirimu", "balafu", "deseri", "iryoshye", "kereme"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("آئسڪريم"),
            keywords: &["آئسڪريم", "ڪريم، مٺو، برف، مٺائي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අය\u{dd2}ස\u{dca} ක\u{dca}\u{200d}ර\u{dd3}ම\u{dca}"),
            keywords: &[
                "අත\u{dd4}ර\u{dd4}පස",
                "අය\u{dd2}ස\u{dca}",
                "ක\u{dca}\u{200d}ර\u{dd3}ම\u{dca}",
                "පැණ\u{dd2} රස",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zmrzlina"),
            keywords: &["dezert", "krém", "sladkosť", "zmrzlina"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("sladoled"),
            keywords: &["krema", "led", "posladek", "sladko", "sladoled"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("jallaato"),
            keywords: &["baraf", "jallaato", "labeen", "macaan", "macmacaan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("akullore"),
            keywords: &["akull", "akullore", "e ëmbël", "krem", "ëmbëlsirë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("сладолед"),
            keywords: &["дeсeрт", "крем", "лeд", "слaдoлeд", "слaткo", "сладолед"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("sladoled"),
            keywords: &["desert", "krem", "led", "sladoled", "slatko"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("glass"),
            keywords: &["efterrätt", "glass"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("aisikrimu"),
            keywords: &["aisikrimu", "barafu", "kitindamlo", "krimu", "tamu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஐஸ\u{bcd}கிர\u{bc0}ம\u{bcd}"),
            keywords: &[
                "உணவகம\u{bcd}",
                "உணவு",
                "ஐஸ\u{bcd}கிர\u{bc0}ம\u{bcd}",
                "ஐஸ\u{bcd}க\u{bcd}ர\u{bc0}ம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఐస\u{c4d} క\u{c4d}ర\u{c40}ం"),
            keywords: &[
                "ఐస\u{c4d}",
                "ఐస\u{c4d} క\u{c4d}ర\u{c40}ం",
                "క\u{c4d}ర\u{c40}మ\u{c4d}",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("яхмос"),
            keywords: &["десерт", "крем", "ширин", "ях", "яхмос"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ไอศกร\u{e35}ม"),
            keywords: &[
                "ของหวาน",
                "คร\u{e35}ม",
                "น\u{e49}ำแข\u{e47}ง",
                "ไอศกร\u{e35}ม",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("buzgaýmak"),
            keywords: &["buz", "buzgaýmak", "desert", "krem", "süýji"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻaisikilimi"),
            keywords: &["ʻaisikilimi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("dondurma"),
            keywords: &["buz", "dondurma", "krema", "restoran"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("مۇزقايماق"),
            keywords: &["تاتلىق", "قايماق", "مۇز", "مۇزقايماق", "يانئاش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("морозиво"),
            keywords: &["десерт", "морозиво", "солодкий"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("آئس کریم"),
            keywords: &["آئس کریم", "برف", "میٹھی", "کریم"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("muzqaymoq"),
            keywords: &["krem", "muz", "muzqaymoq", "shirin", "shirinlik"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("kem"),
            keywords: &["kem", "món tráng miệng", "ngọt"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kreem galaase"),
            keywords: &["deseer", "glaas", "kereem", "kreem galaase", "suukër"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iayiskrim"),
            keywords: &["emnandi", "i-dessert", "iayiskrim", "ikhrimu", "ukhenkce"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Wara Didi"),
            keywords: &["Wara Didi", "kírímù", "yìnyín", "àdídùn", "ónjẹ dídùn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("雪糕"),
            keywords: &["冰", "忌廉", "甜", "甜品", "雪糕"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("雪糕"),
            keywords: &["冰", "忌廉", "甜", "甜品", "雪糕"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("冰淇淋"),
            keywords: &["冰", "冰淇淋", "冰激凌", "甜点"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("冰淇淋"),
            keywords: &["冰品", "冰淇淋"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("雪糕"),
            keywords: &["雪糕"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("u-ice cream"),
            keywords: &[
                "iqhwa",
                "okumnandi",
                "okunoshuke",
                "u-ice cream",
                "ukhilimu",
            ],
        },
    ],
};
#[doc = "🍩"]
pub const DOUGHNUT: crate::Emoji = crate::Emoji {
    glyph: "🍩",
    codepoint: "1F369",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "doughnut",
    group: "Food & Drink",
    subgroup: "food-sweet",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("oliebol"),
            keywords: &["kos", "nagereg", "oliebol", "soet"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ዶናት"),
            keywords: &["ዶናት", "ጣፋጭ", "ጣፋጭ ምግብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كعكة محلاة"),
            keywords: &["كعكة محلاة", "مطعم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ড’ন\u{9be}ট"),
            keywords: &["ড’ন\u{9be}ট", "মিঠ\u{9be}", "মিঠ\u{9be}ই"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ponçik"),
            keywords: &["desert", "ponçik", "şirin"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("пончык"),
            keywords: &["дэсерт", "пончык", "салодкі"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("поничка"),
            keywords: &["десерт", "поничка", "сладък"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ডোন\u{9be}ট"),
            keywords: &["ডেজ\u{9be}র\u{9cd}ট", "ডোন\u{9be}ট", "মিষ\u{9cd}টি"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("donut"),
            keywords: &["dibenn-pred", "donut"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("krofna"),
            keywords: &["desert", "doručak", "krofna", "slatko"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dònut"),
            keywords: &["dolç", "dònut", "postres", "rosquilla"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏔᎴᏓ ᎦᏚ"),
            keywords: &["ᎠᏔᎴᏓ ᎦᏚ", "ᎤᎦᎾᏍᏓ", "ᎤᎦᎾᏍᏓ ᎠᎩᏍᏗ", "ᎦᏚ ᎤᎦᎾᏍᏓ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("donut"),
            keywords: &[
                "americká",
                "cukrovinka",
                "dezert",
                "donut",
                "kobliha",
                "sladkost",
                "sladký",
                "zákusek",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("toesen"),
            keywords: &["melys", "pwdin", "toesen"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("donut"),
            keywords: &["donut", "kage"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Donut"),
            keywords: &["Donut", "Doughnut"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ντόνατ"),
            keywords: &["γλυκό", "επιδόρπιο", "ντόνατ"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("doughnut"),
            keywords: &["breakfast", "dessert", "donut", "doughnut", "sweet"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("dónut"),
            keywords: &["berlina", "dónut", "pastel", "rosquilla"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("dona"),
            keywords: &["comida", "dona", "dulce", "postre", "rosquilla"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("sõõrik"),
            keywords: &["magus", "magustoit", "sõõrik"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("donuta"),
            keywords: &["donut", "donuta", "gozo", "postre"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دونات"),
            keywords: &["دسر", "دونات", "شیرین"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("donitsi"),
            keywords: &["donitsi", "jälkiruoka", "makea", "munkkirinkeli"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("doughnut"),
            keywords: &[
                "donut",
                "doughnut",
                "matamis",
                "meryenda",
                "pagkain",
                "panghimagas",
                "tinapay",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("berlinarbolli"),
            keywords: &["berlinarbolli", "donut", "matur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("doughnut"),
            keywords: &["dessert", "doughnut", "sucré"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("beigne"),
            keywords: &["beigne", "beignet", "dessert", "sucré"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("taoschnó"),
            keywords: &["bricfeasta", "milis", "milseog", "taoschnó"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("doughnut"),
            keywords: &["doughnut", "milis", "milseag"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("rosquilla"),
            keywords: &["doce", "donut", "rosquilla"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ડોનટ"),
            keywords: &["ડોનટ", "મીઠાઈ", "ર\u{ac7}સ\u{acd}ટોરન\u{acd}ટ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("donot"),
            keywords: &["donot", "kayan zaƙi", "mai zaƙi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סופגניה"),
            keywords: &["דונט", "מאפה", "מתוק", "סופגניה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("डोनट"),
            keywords: &["डोनट", "र\u{947}स\u{94d}टोर\u{947}\u{902}ट"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("krafna"),
            keywords: &["desert", "krafna", "slatko"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fánk"),
            keywords: &["desszert", "fánk", "édesség"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("դոնաթ"),
            keywords: &["աղանդեր", "դոնաթ", "քաղցր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("donat"),
            keywords: &["donat", "makanan", "manis", "penutup"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("donọt"),
            keywords: &["donọt", "àchịcha ụtọ", "ụtọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kleinuhringur"),
            keywords: &["eftirréttur", "kleinuhringur", "sætindi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("ciambella"),
            keywords: &["ciambella", "donut", "ristorante"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ドーナツ"),
            keywords: &["お菓子", "スイーツ", "デザート", "ドーナツ"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("donat"),
            keywords: &["donat", "legi", "panganan manis"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დონატი"),
            keywords: &["დესერტი", "დონატი", "ტკბილეული", "ტკბილი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бүйрекше бәліш"),
            keywords: &["бүйрекше бәліш", "бәліш", "десерт", "тәтті"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("donut"),
            keywords: &["donut", "kage"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ន\u{17c6}កង"),
            keywords: &["ដ\u{17bc}ណាត\u{17cb}", "ន\u{17c6}កង"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಡೋನಟ\u{ccd}"),
            keywords: &["ಡೋನಟ\u{ccd}", "ಮ\u{cbf}ಠಾಯ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("도넛"),
            keywords: &["도넛", "초코 도넛"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("डोनट"),
            keywords: &["गोड", "ड\u{947}झर\u{94d}ट", "डोनट", "डोवनट"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("пончик"),
            keywords: &["десерт", "пончик", "таттуу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Donut"),
            keywords: &["Dessert", "Donut", "séiss"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໂດນ\u{eb1}ດ"),
            keywords: &["ຂອງຫວານ", "ເຂ\u{ebb}\u{ec9}າໜ\u{ebb}ມ", "ໂດນ\u{eb1}ດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("spurga"),
            keywords: &["desertas", "saldu", "spurga"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("virtulis"),
            keywords: &["deserts", "salds", "virtulis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tōnati"),
            keywords: &["puruni", "reka", "tōnati"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("крофна"),
            keywords: &["десерт", "крофна", "слатко"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഡോനട\u{d4d}ട\u{d4d}"),
            keywords: &[
                "ഡോനട\u{d4d}ട\u{d4d}",
                "ഭക\u{d4d}ഷണം",
                "ലഘ\u{d41}ഭക\u{d4d}ഷണം",
                "സ\u{d4d}\u{200c}ന\u{d3e}ക\u{d4d}\u{200c}സ\u{d4d}",
                "ഹോട\u{d4d}ടൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хайрсан нарийн боов"),
            keywords: &[
                "амттан",
                "донат",
                "хайрсан нарийн боов",
                "хөөмөл хайрсан боов",
                "өглөөний цай",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("डोनट"),
            keywords: &["गोड", "डोनट", "मिठाई"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("donat"),
            keywords: &["donat", "manis", "pencuci mulut"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("doughnut"),
            keywords: &["deżerta", "donut", "doughnut", "ħelu"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဒ\u{102d}\u{102f}းနတ\u{103a}"),
            keywords: &[
                "ဒ\u{102d}\u{102f}းနတ\u{103a}",
                "ဒ\u{102d}\u{102f}းနပ\u{103a}",
                "အချ\u{102d}\u{102f}",
                "အချ\u{102d}\u{102f}ပ\u{103d}\u{1032}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("donut"),
            keywords: &["dessert", "donut", "restaurant", "smultring"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("डोनट"),
            keywords: &["डोनट", "मिठाई", "मिठो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("donut"),
            keywords: &["dessert", "donut", "zoet"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("donut"),
            keywords: &["dessert", "donut", "restaurant", "smultring"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଡୋନଟ\u{b4d}\u{200d}"),
            keywords: &[
                "ଡୋନଟ\u{b4d}\u{200d}",
                "ମ\u{b3f}ଠ\u{b3e}",
                "ରେଷ\u{b4d}ଟ\u{b41}ର\u{b3e}ଣ\u{b4d}ଟ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਡ\u{a4b}ਨਟ"),
            keywords: &["ਡ\u{a4b}ਨਟ", "ਮਠਿਆਈ", "ਮਿ\u{a71}ਠਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ڈونٹ"),
            keywords: &["میٹھائی", "میٹھی شے", "ڈونٹ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Dónọt"),
            keywords: &["Brẹ\u{301}kfast", "Dónọt", "Dẹzat", "Swit"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pączek z dziurką"),
            keywords: &["ciasto", "deser", "pączek", "pączek z dziurką", "z dziurką"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ډونټ"),
            keywords: &["خواږه، ډونټ، خوږ", "ډونټ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("donut"),
            keywords: &["donut", "rosquinha"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("dónute"),
            keywords: &["doce", "dónute", "sobremesa"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("dona"),
            keywords: &["dona", "miski", "paqarin mikhuna", "postre"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("gogoașă americană"),
            keywords: &["desert", "dulce", "glazură", "gogoașă", "gogoașă americană"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-302"),
            keywords: &["E10-302"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("пончик"),
            keywords: &["глазурь", "пирожок", "пончик", "сладкое"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("uruziga"),
            keywords: &["deseri", "irindazi", "iryoshye", "uruziga"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڊونٽ"),
            keywords: &["مٺو، ڊونٽ، مٺائي", "ڊونٽ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඩෝනට\u{dca}"),
            keywords: &["අත\u{dd4}ර\u{dd4}පස", "ඩෝනට\u{dca}", "පැණ\u{dd2} රස"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("šiška"),
            keywords: &["dezert", "sladkosť", "šiška"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("krof"),
            keywords: &["krof", "posladek", "sladko"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("keek macaan loo shiilan cajiin ahaan"),
            keywords: &[
                "burcad",
                "keek macaan loo shiilan cajiin ahaan",
                "macmacaan",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("petull e ëmbël"),
            keywords: &["e ëmbël", "petull", "petull e ëmbël", "ëmbëlsirë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("крофна"),
            keywords: &["дeсeрт", "крофнa", "крофна", "слaткo"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("krofna"),
            keywords: &["desert", "krofna", "slatko"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("munk"),
            keywords: &["donut", "munk"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitumbua"),
            keywords: &["kitindamlo", "kitumbua", "tamu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("டோனட\u{bcd}"),
            keywords: &["இனிப\u{bcd}பு", "உணவகம\u{bcd}", "உணவு", "டோனட\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("డ\u{c4b}నట\u{c4d}"),
            keywords: &[
                "డ\u{c4b}నట\u{c4d}",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("кулча"),
            keywords: &["десерт", "кулча", "ширин"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("โดน\u{e31}ท"),
            keywords: &["ขนม", "ของหวาน", "โดน\u{e31}ท"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ponçik"),
            keywords: &["byzmyk", "desert", "ertirlik", "ponçik", "süýji"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("keke fakapaku"),
            keywords: &["keke fakapaku"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("donut"),
            keywords: &["donat", "donut", "doughnut", "restoran"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ھالقا پىشۇرۇق"),
            keywords: &["تاتلىق", "پىشۇرۇق", "ھالقا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("пончик"),
            keywords: &["десерт", "пончик", "солодкий"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ڈونٹ"),
            keywords: &["میٹھا", "ڈونٹ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ponchik"),
            keywords: &["ponchik", "shirin", "shirinlik", "teshik kulcha"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bánh rán vòng"),
            keywords: &["bánh rán vòng", "món tráng miệng", "ngọt"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("beñe"),
            keywords: &["beñe", "deseer", "suukër"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("idonathi"),
            keywords: &["emnandi", "i-dessert", "idonathi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Dónọ\u{301}ọ\u{300}tì"),
            keywords: &["Dónọ\u{301}ọ\u{300}tì", "dónọtì", "àdídùn", "ónjẹ dídùn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("冬甩"),
            keywords: &["冬甩", "甜", "甜品"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("冬甩"),
            keywords: &["冬甩", "甜", "甜品"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("甜甜圈"),
            keywords: &["甜点", "甜甜圈"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("甜甜圈"),
            keywords: &["甜甜圈", "甜點"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("冬甩"),
            keywords: &["冬甩", "甜甜圈", "甜點"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("idonathi"),
            keywords: &["idonathi", "okunoshukela", "ubumnandi"],
        },
    ],
};
#[doc = "🍪"]
pub const COOKIE: crate::Emoji = crate::Emoji {
    glyph: "🍪",
    codepoint: "1F36A",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "cookie",
    group: "Food & Drink",
    subgroup: "food-sweet",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("koekie"),
            keywords: &["koek", "koekie", "kos", "nagereg", "soet"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ኩኪስ"),
            keywords: &["ኩኪስ", "ጣፋጭ", "ጣፋጭ ምግብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كعكة"),
            keywords: &["كعكة", "مطعم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9c1}\u{981}কি"),
            keywords: &["ক\u{9c1}\u{981}কি", "মিঠ\u{9be}", "মিঠ\u{9be}ই"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("peçenye"),
            keywords: &["desert", "peçenye", "şirin"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("пячэнне"),
            keywords: &["дэсерт", "пячэнне", "салодкі"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("бисквитка"),
            keywords: &["бисквитка", "десерт", "сладък"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9c1}কি"),
            keywords: &["ক\u{9c1}কি", "ডেজ\u{9be}র\u{9cd}ট", "মিষ\u{9cd}টি"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("cookie"),
            keywords: &["cookie", "dibenn-pred"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kolačić"),
            keywords: &["desert", "kolačić", "slatko"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("galeta"),
            keywords: &["dolç", "galeta", "postres"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏚ ᎤᎦᎾᏍᏗ"),
            keywords: &["ᎤᎦᎾᏍᏓ", "ᎤᎦᎾᏍᏓ ᎠᎩᏍᏗ", "ᎦᏚ ᎤᎦᎾᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("koláček"),
            keywords: &[
                "cookie",
                "cukrovinka",
                "dezert",
                "koláček",
                "sladkost",
                "sladký",
                "sušenka",
                "zákusek",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bisgeden"),
            keywords: &["bisgeden", "melys", "pwdin"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("småkage"),
            keywords: &["kage", "småkage"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Keks"),
            keywords: &["Cookie", "Keks"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μπισκότο"),
            keywords: &["γλυκό", "επιδόρπιο", "μπισκότο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("cookie"),
            keywords: &["cookie", "dessert", "sweet"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("biscuit"),
            keywords: &["biscuit", "cookie", "dessert", "sweet"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("cookie"),
            keywords: &["biscuit", "cookie", "dessert", "sweet"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("cookie"),
            keywords: &["cookie", "dessert", "sweet"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("galleta"),
            keywords: &["dulce", "galleta", "pasta", "postre"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["café", "comida", "dulce", "galleta", "postre"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["dulce", "galleta", "postre"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["dulce", "galleta", "postre"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("küpsis"),
            keywords: &["küpsis", "magus", "magustoit"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gaileta"),
            keywords: &["gaileta", "gozo", "postre"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کلوچه"),
            keywords: &["دسر", "شیرین", "کلوچه", "کوکی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("keksi"),
            keywords: &["jälkiruoka", "keksi", "makea"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("cookie"),
            keywords: &[
                "biskwit",
                "cookie",
                "matamis",
                "meryenda",
                "pagkain",
                "panghimagas",
                "tinapay",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("smákaka"),
            keywords: &["matur", "smákaka"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cookie"),
            keywords: &["cookie", "dessert", "sucré"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("biscuit"),
            keywords: &["biscuit", "dessert", "sucré"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("briosca"),
            keywords: &["briosca", "milis", "milseog"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("briosgaid"),
            keywords: &["briosgaid", "milis", "milseag"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("galleta"),
            keywords: &["doce", "galleta"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ક\u{ac1}કી"),
            keywords: &["ક\u{ac1}કી", "ર\u{ac7}સ\u{acd}ટોરન\u{acd}ટ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("biskit"),
            keywords: &["biskit", "kayan zaƙi", "mai zaƙi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עוגיה"),
            keywords: &["מאפה", "מתוק", "עוגיה", "שוקולד צ׳יפס"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("क\u{941}की"),
            keywords: &["क\u{941}की", "र\u{947}स\u{94d}टोर\u{947}\u{902}ट"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("keks"),
            keywords: &["desert", "keks", "slatko"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("sütemény"),
            keywords: &["desszert", "keksz", "sütemény", "süti", "édesség"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("թխվածքաբլիթ"),
            keywords: &["աղանդեր", "թխվածքաբլիթ", "քաղցր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("biskuit"),
            keywords: &["biskuit", "makanan", "manis", "penutup"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("kuki"),
            keywords: &["kuki", "àchịcha ụtọ", "ụtọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("smákaka"),
            keywords: &["smákaka", "súkkulaðibitakaka", "veitingastaður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("biscotto"),
            keywords: &["biscotto", "cookie", "ristorante"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("クッキー"),
            keywords: &["お菓子", "クッキー", "スイーツ", "デザート"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("biskwit"),
            keywords: &["biskwit", "legi", "panganan manis"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ფხვიერი ნამცხვარი"),
            keywords: &["დესერტი", "ტკბილეული", "ტკბილი", "ფხვიერი ნამცხვარი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("печенье"),
            keywords: &["десерт", "печенье", "тәтті"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("cookie"),
            keywords: &["cookie", "kage", "småkage"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ន\u{17c6}ខ\u{17bc}កឃ\u{17b8}"),
            keywords: &[
                "ន\u{17c6}ខ\u{17bc}កឃ\u{17b8}",
                "បង\u{17d2}អែម",
                "ផ\u{17d2}អែម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕುಕೀ"),
            keywords: &[
                "ಕುಕೀ",
                "ಸ\u{cbf}ಹ\u{cbf}",
                "ಸ\u{cbf}ಹ\u{cbf}ತ\u{cbf}ಂಡ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("쿠키"),
            keywords: &["초코 쿠키", "초코칩 쿠키", "쿠키"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("क\u{941}की"),
            keywords: &["क\u{941}की", "गोड", "ड\u{947}झर\u{94d}ट"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("булочка"),
            keywords: &["булочка", "десерт", "таттуу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Kichelchen"),
            keywords: &["Dessert", "Kichelchen", "séiss"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຂ\u{ebb}\u{ec9}າໜ\u{ebb}ມຄ\u{eb8}ກກ\u{eb5}\u{ec9}"),
            keywords: &[
                "ຂອງຫວານ",
                "ຄ\u{eb8}ກກ\u{eb5}\u{ec9}",
                "ເຂ\u{ebb}\u{ec9}າໜ\u{ebb}ມ",
                "ເຂ\u{ebb}\u{ec9}າໜ\u{ebb}ມຄ\u{eb8}ກກ\u{eb5}\u{ec9}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("sausainis"),
            keywords: &["desertas", "saldu", "sausainis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("cepums"),
            keywords: &["cepums", "deserts", "salds"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pihikete"),
            keywords: &["pihikete", "puruni", "reka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("колаче"),
            keywords: &["десерт", "колаче", "слатко"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d41}ക\u{d4d}കി"),
            keywords: &[
                "ക\u{d41}ക\u{d4d}കി",
                "ബിസ\u{d4d}\u{200c}ക\u{d4d}കറ\u{d4d}റ\u{d4d}",
                "ഭക\u{d4d}ഷണം",
                "ഹോട\u{d4d}ടൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("жигнэмэг"),
            keywords: &["амттан", "жигнэмэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("क\u{941}की"),
            keywords: &["क\u{941}की", "ड\u{947}झर\u{94d}ट", "मिठाई"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("biskut"),
            keywords: &["biskut", "manis", "pencuci mulut"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("gallettina"),
            keywords: &["deżerta", "gallettina", "ħelwa"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("က\u{103d}တ\u{103a}က\u{102e}း"),
            keywords: &[
                "က\u{103d}တ\u{103a}က\u{102e}း",
                "အချ\u{102d}\u{102f}",
                "အချ\u{102d}\u{102f}ပ\u{103d}\u{1032}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kjeks"),
            keywords: &["cookie", "dessert", "kjeks", "restaurant"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("क\u{941}की"),
            keywords: &["क\u{941}की", "मिठाई"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("koekje"),
            keywords: &["dessert", "koekje", "zoet"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kjeks"),
            keywords: &["cookie", "dessert", "kjeks", "restaurant"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b41}କୀ"),
            keywords: &[
                "କ\u{b41}କ\u{b3f}",
                "କ\u{b41}କୀ",
                "ମ\u{b3f}ଠ\u{b3e}",
                "ରେଷ\u{b4d}ଟ\u{b41}ର\u{b3e}ଣ\u{b4d}ଟ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬਿਸਕ\u{a41}ਟ"),
            keywords: &[
                "ਕ\u{a41}ਕੀ",
                "ਕ\u{a41}\u{a71}ਕੀ",
                "ਬਿਸਕ\u{a41}ਟ",
                "ਮਠਿਆਈ",
                "ਮਿ\u{a71}ਠਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کوکی"),
            keywords: &["میٹھائی", "میٹھی شے", "کوکی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kúki"),
            keywords: &["Dẹzat", "Kúki", "Swit"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("ciastko"),
            keywords: &["ciastko", "deser", "słodki", "słodkie ciastko"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بسکوټ"),
            keywords: &["بسکوټ", "بسکوټ، خواږه، خوږ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("biscoito"),
            keywords: &["biscoito", "bolacha", "cookie", "doce"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["biscoito", "bolacha", "doce"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("galleta"),
            keywords: &["galleta", "miski", "postre"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("fursec"),
            keywords: &["desert", "dulce", "fursec"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-303"),
            keywords: &["E10-303"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("печенье"),
            keywords: &["выпечка", "печенье", "сладкое"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("biswi"),
            keywords: &["biswi", "deseri", "utwungucenge"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بسڪيٽ"),
            keywords: &["بسڪيٽ", "مٺو، مٺائي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dd4}ක\u{dd3}"),
            keywords: &["අත\u{dd4}ර\u{dd4}පස", "ක\u{dd4}ක\u{dd3}", "පැණ\u{dd2} රස"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("sušienka"),
            keywords: &["dezert", "sladkosť", "sušienka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("piškot"),
            keywords: &["piškot", "posladek", "sladko"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("keeg macaan"),
            keywords: &["buskud macaan", "keeg macaan", "macaan", "macmacaan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("biskotë"),
            keywords: &["biskotë", "e ëmbël", "ëmbëlsirë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("колачић"),
            keywords: &["дeсeрт", "колачић", "слaткo"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kolačić"),
            keywords: &["desert", "kolačić", "slatko"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kaka"),
            keywords: &["desert", "efterrätt", "kaka", "småbröd"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("biskuti"),
            keywords: &["biskuti", "kitindamlo", "peremende"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("குக\u{bcd}க\u{bc0}"),
            keywords: &["உணவகம\u{bcd}", "உணவு", "குக\u{bcd}க\u{bc0}", "ரொட\u{bcd}டி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కుక\u{c40}"),
            keywords: &[
                "కుక\u{c40}",
                "కుక\u{c4d}క\u{c40}",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("кулчақанд"),
            keywords: &["десерт", "кулчақанд", "ширин"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ค\u{e38}กก\u{e35}\u{e49}"),
            keywords: &["ขนม", "ของหวาน", "ค\u{e38}กก\u{e35}\u{e49}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kökejik"),
            keywords: &["desert", "kökejik", "süýji"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pisikete"),
            keywords: &["pisikete"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kurabiye"),
            keywords: &["kurabiye", "restoran"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("پىشۇرۇق"),
            keywords: &["تاتلىق", "پىشۇرۇق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("печиво"),
            keywords: &["десерт", "печиво", "солодкий"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کوکی"),
            keywords: &["میٹھا", "کوکی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("pishiriq"),
            keywords: &["pishiriq", "shirin", "shirinlik"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bánh quy"),
            keywords: &["bánh quy", "món tráng miệng", "ngọt"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("mbiskit"),
            keywords: &["deseer", "mbiskit", "suukër"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqebengwane"),
            keywords: &["emnandi", "i-dessert", "iqebengwane"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Kuki"),
            keywords: &["Kuki", "àdídùn", "ónjẹ dídùn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("曲奇"),
            keywords: &["曲奇", "甜", "甜品"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("曲奇"),
            keywords: &["曲奇", "甜", "甜品"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("饼干"),
            keywords: &["曲奇", "饼干"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("餅乾"),
            keywords: &["甜點", "餅乾"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("曲奇"),
            keywords: &["曲奇", "甜品", "餅乾"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iqebelengwane"),
            keywords: &["iqebelengwane", "okunoshukela", "ubumnandi"],
        },
    ],
};
#[doc = "🎂"]
pub const BIRTHDAY_CAKE: crate::Emoji = crate::Emoji {
    glyph: "🎂",
    codepoint: "1F382",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "birthday cake",
    group: "Food & Drink",
    subgroup: "food-sweet",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("verjaardagkoek"),
            keywords: &[
                "koek",
                "nagereg",
                "verjaardagkoek",
                "verjaarsdag",
                "verjaarsdagkoek",
                "viering",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የልደት ኬክ"),
            keywords: &["ኬክ", "ክብረ በዓል", "የልደት ቀን", "የልደት ኬክ", "ጣፋጭ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كعكة عيد ميلاد"),
            keywords: &["احتفال", "عيد ميلاد", "كعكة", "كعكة عيد ميلاد"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("জন\u{9cd}মদিনৰ কেক"),
            keywords: &[
                "উদয\u{9be}পন",
                "কেক",
                "জন\u{9cd}মদিন",
                "জন\u{9cd}মদিনৰ কেক",
                "ডেজ\u{9be}ৰ\u{9cd}ট",
                "পেষ\u{9cd}ট\u{9cd}ৰী",
                "মিঠ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ad günü tortu"),
            keywords: &[
                "ad günü",
                "ad günü tortu",
                "bayram",
                "desert",
                "tort",
                "xəmir",
                "şirin",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("імянінны торт"),
            keywords: &[
                "дзень нараджэння",
                "дэсерт",
                "салодкі",
                "свята",
                "торт",
                "імянінны торт",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Торта за рожден ден"),
            keywords: &[
                "Торта за рожден ден",
                "десерт",
                "празнуване",
                "рожден ден",
                "сладкиш",
                "торта",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("জন\u{9cd}মদিনের কেক"),
            keywords: &[
                "উদয\u{9be}পন",
                "কেক",
                "জন\u{9cd}মদিন",
                "জন\u{9cd}মদিনের কেক",
                "ডেজ\u{9be}র\u{9cd}ট",
                "প\u{9cd}য\u{9be}স\u{9cd}ট\u{9cd}রি",
                "মিষ\u{9cd}টি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("gwastell deiz-ha-bloaz"),
            keywords: &["deiz-ha-bloaz", "dibenn-pred", "gwastell"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("rođendanska torta"),
            keywords: &[
                "desert",
                "rođendan",
                "rođendanska torta",
                "slavlje",
                "torta",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pastís d’aniversari"),
            keywords: &[
                "aniversari",
                "celebració",
                "dolç",
                "pastís",
                "pastís d’aniversari",
                "postres",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏕᏘᏱᏍᎬᎢ ᎦᏚ ᎤᎦᎾᏍᏓ"),
            keywords: &[
                "ᎠᎾᎵᎮᎵᎬᎢ",
                "ᎤᎦᎾᏍᏓ",
                "ᎤᎦᎾᏍᏓ ᎠᎩᏍᏗ",
                "ᎤᏍᏗ ᎨᎵᏍᎩ",
                "ᎤᏕᏘᏱᏍᎬᎢ",
                "ᎤᏕᏘᏱᏍᎬᎢ ᎦᏚ ᎤᎦᎾᏍᏓ",
                "ᎦᏚ ᎤᎦᎾᏍᏓ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("narozeninový dort"),
            keywords: &[
                "cukrovinka",
                "dezert",
                "dort",
                "narozeninový dort",
                "narozeniny",
                "oslava",
                "sladkost",
                "sladký",
                "zákusek",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cacen pen-blwydd"),
            keywords: &["cacen", "dathliad", "parti", "pen-blwydd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("fødselsdagskage"),
            keywords: &["fødselsdagskage", "kage", "lagkage"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Geburtstagskuchen"),
            keywords: &["Geburtstag", "Geburtstagskuchen", "Torte"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τούρτα γενεθλίων"),
            keywords: &[
                "γενεθλίων",
                "γιορτή",
                "γλυκό",
                "επιδόρπιο",
                "ζύμη",
                "τούρτα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("birthday cake"),
            keywords: &[
                "birthday",
                "cake",
                "celebration",
                "dessert",
                "pastry",
                "sweet",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("tarta de cumpleaños"),
            keywords: &["celebración", "cumpleaños", "tarta", "tarta de cumpleaños"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("torta de cumpleaños"),
            keywords: &[
                "celebración",
                "cumpleaños",
                "fiesta",
                "pastel de cumpleaños",
                "torta",
                "torta de cumpleaños",
                "velas",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("pastel de cumpleaños"),
            keywords: &["pastel de cumpleaños"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("pastel de cumpleaños"),
            keywords: &[
                "celebración",
                "cumpleaños",
                "dulce",
                "panadería",
                "pastel",
                "pastel de cumpleaños",
                "postre",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("sünnipäevatort"),
            keywords: &[
                "küünlad",
                "magustoit",
                "sünnipäev",
                "sünnipäevatort",
                "tort",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("urtebetetze-tarta"),
            keywords: &[
                "ospakizun",
                "pastel",
                "postre",
                "tarta",
                "urtebetetze",
                "urtebetetze-tarta",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کیک تولد"),
            keywords: &["تولد", "جشن", "دسر", "شیرین", "شیرینی", "کیک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("syntymäpäiväkakku"),
            keywords: &[
                "juhla",
                "jälkiruoka",
                "kakku",
                "leivonnainen",
                "makea",
                "syntymäpäivä",
                "syntymäpäiväkakku",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("birthday cake"),
            keywords: &[
                "birthday cake",
                "cake",
                "kaarawan",
                "matamis",
                "panghimagas",
                "pastry",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("føðingardagskaka"),
            keywords: &["føðingardagskaka", "føðingardagur", "kaka", "ljós", "matur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("gâteau d’anniversaire"),
            keywords: &["anniversaire", "gâteau d’anniversaire"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("gâteau de fête"),
            keywords: &[
                "anniversaire",
                "dessert",
                "fête",
                "gâteau",
                "gâteau de fête",
                "pâtisserie",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cáca breithe"),
            keywords: &["breithlá", "cáca breithe", "cóisir", "lá breithe"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cèic co-là-breith"),
            keywords: &[
                "co-là-breith",
                "comharrachadh",
                "cèic",
                "milis",
                "milseag",
                "pastraidh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("torta de aniversario"),
            keywords: &[
                "aniversario",
                "candeas",
                "celebración",
                "festa",
                "torta de aniversario",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("જન\u{acd}મદિવસની ક\u{ac7}ક"),
            keywords: &[
                "ઉજવણી",
                "ક\u{ac7}ક",
                "જન\u{acd}મદિવસ",
                "જન\u{acd}મદિવસની ક\u{ac7}ક",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kek na ranar haihuwa"),
            keywords: &[
                "kayan kek",
                "kayan zaƙi",
                "kek",
                "kek na ranar haihuwa",
                "mai zaƙi",
                "ranar haihuwa",
                "shagali",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עוגת יום הולדת"),
            keywords: &[
                "יום הולדת",
                "מאפה",
                "מזל טוב",
                "מסיבה",
                "עוגה",
                "עוגת יום הולדת",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("जन\u{94d}मदिन का क\u{947}क"),
            keywords: &[
                "क\u{947}क",
                "जन\u{94d}मदिन",
                "जन\u{94d}मदिन का क\u{947}क",
                "समारोह",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("rođendanska torta"),
            keywords: &[
                "desert",
                "rođendan",
                "rođendanska torta",
                "slatko",
                "slavlje",
                "tijesto",
                "torta",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("születésnapi torta"),
            keywords: &[
                "desszert",
                "születésnapi torta",
                "szülinap",
                "sütemény",
                "süti",
                "torta",
                "édesség",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ծննդյան տորթ"),
            keywords: &[
                "աղանդեր",
                "խմորեղեն",
                "ծննդյան տորթ",
                "տարեդարձ",
                "տոն",
                "քաղցր",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kue ulang tahun"),
            keywords: &[
                "hidangan penutup",
                "kue",
                "kue ulang tahun",
                "manis",
                "pastri",
                "perayaan",
                "ulang tahun",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("àchịcha ncheta ọmụmụ"),
            keywords: &[
                "etèrè",
                "ncheta ọmụmụ",
                "àchịcha bèkee",
                "àchịcha ncheta ọmụmụ",
                "àchịcha ụtọ",
                "ènwemụanụrị",
                "ụtọ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("afmæliskaka"),
            keywords: &["afmæli", "afmæliskaka", "kaka", "veisla"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("torta di compleanno"),
            keywords: &["compleanno", "festa", "torta", "torta di compleanno"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("バースデーケーキ"),
            keywords: &["ケーキ", "バースデー", "バースデーケーキ", "誕生日"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("roti ambal taun"),
            keywords: &[
                "ambal taun",
                "kuwih",
                "legi",
                "panganan manis",
                "pastri",
                "pista",
                "roti ambal taun",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დაბადების დღის ტორტი"),
            keywords: &[
                "აღნიშვნა",
                "დაბადების დღე",
                "დაბადების დღის ტორტი",
                "დესერტი",
                "ზეიმი",
                "ნამცხვარი",
                "ტკბილეული",
                "ტკბილი",
                "ტორტი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("туған күнге арналған торт"),
            keywords: &[
                "десерт",
                "кондитер өнімдері",
                "тойлау",
                "торт",
                "туған күн",
                "туған күнге арналған торт",
                "тәтті",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("fødselsdagskage"),
            keywords: &["fødselsdagskage", "kage", "lagkage"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ន\u{17c6}ខ\u{17bd}បក\u{17c6}ណើត"),
            keywords: &[
                "ន\u{17c6}ខ\u{17bd}ប",
                "ន\u{17c6}ខ\u{17bd}បក\u{17c6}ណើត",
                "ន\u{17c6}ខេក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಜನ\u{ccd}ಮದ\u{cbf}ನದ ಕೇಕ\u{ccd}"),
            keywords: &[
                "ಆಚರಣ\u{cc6}",
                "ಕೇಕ\u{ccd}",
                "ಜನ\u{ccd}ಮದ\u{cbf}ನ",
                "ಜನ\u{ccd}ಮದ\u{cbf}ನದ ಕೇಕ\u{ccd}",
                "ಪೇಸ\u{ccd}ಟ\u{ccd}ರ\u{cbf}",
                "ಸ\u{cbf}ಹ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("생일 케이크"),
            keywords: &["생일 케이크", "생일케이크"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("वाडदिसाचो क\u{947}क"),
            keywords: &[
                "क\u{947}क",
                "गोड",
                "ड\u{947}झर\u{94d}ट",
                "प\u{945}स\u{94d}ट\u{94d}री",
                "वाडदिसाचो क\u{947}क",
                "वाडदीस",
                "स\u{941}वाळो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("туулган күн торту"),
            keywords: &[
                "десерт",
                "майрам",
                "таттуу",
                "торт",
                "туулган күн",
                "туулган күн торту",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Gebuertsdagskuch"),
            keywords: &[
                "Dessert",
                "Feier",
                "Gebuertsdag",
                "Gebuertsdagskuch",
                "Gebäck",
                "Kuch",
                "séiss",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຄກວ\u{eb1}ນເກ\u{eb5}ດ"),
            keywords: &[
                "ວ\u{eb1}ນເກ\u{eb5}ດ",
                "ເຄກວ\u{eb1}ນເກ\u{eb5}ດ",
                "ເຄ\u{eb1}ກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("gimtadienio tortas"),
            keywords: &[
                "desertas",
                "gimtadienio tortas",
                "gimtadienis",
                "kepiniai",
                "pyragas",
                "saldu",
                "šventė",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("dzimšanas dienas kūka"),
            keywords: &[
                "deserts",
                "dzimšanas diena",
                "dzimšanas dienas kūka",
                "jubileja",
                "kūka",
                "svinības",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("keke rāwhānau"),
            keywords: &["keke", "puruni", "pōhā", "reka", "rāwhānau", "whakanuinga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("роденденска торта"),
            keywords: &[
                "десерт",
                "печиво",
                "прослава",
                "роденден",
                "роденденска торта",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പിറന\u{d4d}ന\u{d3e}ൾ കേക\u{d4d}ക\u{d4d}"),
            keywords: &[
                "ആഘോഷം",
                "ജന\u{d4d}മദിനം",
                "പിറന\u{d4d}ന\u{d3e}ൾ",
                "പിറന\u{d4d}ന\u{d3e}ൾ കേക\u{d4d}ക\u{d4d}",
                "സ\u{d4d}വീറ\u{d4d}റ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("төрсөн өдрийн бялуу"),
            keywords: &[
                "амттан",
                "баяр",
                "гурилан бүтээгдэхүүн",
                "торт",
                "төрсөн өдрийн бялуу",
                "төрсөн өдөр",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("वाढदिवसाचा क\u{947}क"),
            keywords: &[
                "आन\u{902}दोत\u{94d}सव",
                "क\u{947}क",
                "गोड",
                "प\u{947}स\u{94d}ट\u{94d}री",
                "मिठाई",
                "वाढदिवस",
                "वाढदिवसाचा क\u{947}क",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kek hari jadi"),
            keywords: &[
                "hari jadi",
                "kek",
                "kek hari jadi",
                "manisan",
                "pastri",
                "pemanis mulut",
                "sambutan",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kejk ta’ għeluq is-snin"),
            keywords: &[
                "deżerta",
                "għaġina",
                "għeluq is-snin",
                "kejk",
                "kejk ta’ għeluq is-snin",
                "ċelebarazzjoni",
                "ħelwa",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မ\u{103d}ေးနေ\u{1037} က\u{102d}တ\u{103a}မ\u{102f}န\u{1037}\u{103a}"),
            keywords: &[
                "က\u{102d}တ\u{103a}မ\u{102f}န\u{1037}\u{103a}",
                "မ\u{103d}ေးနေ\u{1037}",
                "အချ\u{102d}\u{102f}",
                "အချ\u{102d}\u{102f}ပ\u{103d}\u{1032}",
                "အောင\u{103a}ပ\u{103d}\u{1032}ခ\u{1036}ခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bursdagskake"),
            keywords: &[
                "bursdag",
                "bursdagskake",
                "dessert",
                "feiring",
                "fødselsdag",
                "kake",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("जन\u{94d}म दिनको क\u{947}क"),
            keywords: &[
                "क\u{947}क",
                "जन\u{94d}म दिन",
                "जन\u{94d}म दिनको क\u{947}क",
                "प\u{947}स\u{94d}ट\u{94d}री",
                "मिठाई",
                "मिठो",
                "समारोह",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("verjaardagstaart"),
            keywords: &[
                "dessert",
                "feest",
                "gebak",
                "taart",
                "verjaardag",
                "verjaardagstaart",
                "zoet",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bursdagskake"),
            keywords: &[
                "bursdag",
                "bursdagskake",
                "dessert",
                "feiring",
                "fødselsdag",
                "kake",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଜନ\u{b4d}ମଦ\u{b3f}ନ କେକ\u{b4d}\u{200d}"),
            keywords: &[
                "ଉତ\u{b4d}ସବ",
                "କେକ\u{b4d}\u{200c}",
                "ଜନ\u{b4d}ମଦ\u{b3f}ନ",
                "ପେଷ\u{b4d}ଟ\u{b4d}ରୀ",
                "ମ\u{b3f}ଠ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜਨਮਦਿਨ ਕ\u{a47}ਕ"),
            keywords: &[
                "ਕ\u{a47}ਕ",
                "ਜਨਮ ਦਿਨ",
                "ਜਨਮ ਦਿਨ ਕ\u{a47}ਕ",
                "ਜਨਮਦਿਨ ਕ\u{a47}ਕ",
                "ਜਸ\u{a3c}ਨ",
                "ਪ\u{a47}ਸਟਰੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سالگرہ دا کیک"),
            keywords: &[
                "سالگرہ",
                "سالگرہ دا کیک",
                "منانا",
                "میٹھائی",
                "میٹھی شے",
                "پیسٹری",
                "کیک",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bátdé Kek"),
            keywords: &[
                "Bátdè",
                "Bátdé Kek",
                "Dẹzat",
                "Kek",
                "Patí",
                "Swit",
                "Swít Fud Wé Dẹm De Chọ\u{301}p Áftá Di Mén Fud",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("tort urodzinowy"),
            keywords: &["tort urodzinowy", "zdmuchnąć", "świeczki"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د زېږېدنې کیک"),
            keywords: &[
                "د زېږېدنې ورځ، کيک، لمانځل، خواږه، پيسټري، خوږ",
                "د زېږېدنې کیک",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bolo de aniversário"),
            keywords: &["aniversário", "bolo", "bolo de aniversário", "comemoração"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("bolo de anos"),
            keywords: &[
                "aniversário",
                "bolo",
                "bolo de anos",
                "celebração",
                "doce",
                "pastelaria",
                "sobremesa",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("wata huntaypaq torta"),
            keywords: &[
                "masa",
                "miski",
                "postre",
                "raymi",
                "torta",
                "wata huntaypaq",
                "wata huntaypaq torta",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("tort aniversar"),
            keywords: &[
                "aluat",
                "aniversare",
                "desert",
                "dulce",
                "sărbătoare",
                "tort",
                "tort aniversar",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-327"),
            keywords: &["E10-327"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("торт ко дню рождения"),
            keywords: &[
                "выпечка",
                "день рождения",
                "пирог",
                "свечки",
                "сладкое",
                "торт",
                "торт ко дню рождения",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("gato y’isabukuru y’amavuko"),
            keywords: &[
                "gato y’isabukuru y’amavuko",
                "ibirori",
                "iryoshye",
                "isabukuru",
                "keke",
                "patiseri",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("جنم ڏينهن جو ڪيڪ"),
            keywords: &[
                "جنم ڏينهن جو ڪيڪ",
                "جنم ڏينهن، ڪيڪ، جشن، مٺو، پيسٽري، مٺائي",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("උපන\u{dca} ද\u{dd2}න කේක\u{dca}"),
            keywords: &[
                "අත\u{dd4}ර\u{dd4}පස",
                "උපන\u{dca} ද\u{dd2}න කේක\u{dca}",
                "උපන\u{dca} ද\u{dd2}නය",
                "කේක\u{dca}",
                "පැණ\u{dd2} රස",
                "පේස\u{dca}ට\u{dca}\u{200d}ර\u{dd2}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("narodeninová torta"),
            keywords: &[
                "dezert",
                "koláč",
                "narodeninová torta",
                "narodeniny",
                "oslava",
                "sladkosť",
                "torta",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("rojstnodnevna torta"),
            keywords: &[
                "pecivo",
                "posladek",
                "rojstni dan",
                "rojstnodnevna torta",
                "sladko",
                "slavje",
                "torta",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("keegga maalinka dhalashada"),
            keywords: &[
                "cajiin",
                "dabbaaldeg",
                "keegga",
                "keegga maalinka dhalashada",
                "maalinka dhalashada",
                "macaan",
                "macmacaan",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("tortë ditëlindjeje"),
            keywords: &["festim", "kek", "tortë", "tortë ditëlindjeje", "ëmbëlsirë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("рођенданска торта"),
            keywords: &[
                "дeсeрт",
                "прослава",
                "рoђeндaн",
                "рођенданска торта",
                "слaткo",
                "тeстo",
                "тoртa",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["рођенданска торта"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("rođendanska torta"),
            keywords: &[
                "desert",
                "proslava",
                "rođendan",
                "rođendanska torta",
                "slatko",
                "testo",
                "torta",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["rođendanska torta"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("födelsedagstårta"),
            keywords: &["fest", "födelsedag", "födelsedagstårta", "tårta"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("keki ya kusherehekea siku ya kuzaliwa"),
            keywords: &[
                "keki",
                "keki ya kusherehekea siku ya kuzaliwa",
                "kitindamlo",
                "kusherehekea",
                "siku ya kuzaliwa",
                "tamu",
                "vitobosha",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பிறந\u{bcd}தந\u{bbe}ள\u{bcd} கேக\u{bcd}"),
            keywords: &[
                "கேக\u{bcd}",
                "கொண\u{bcd}ட\u{bbe}ட\u{bcd}டம\u{bcd}",
                "பிறந\u{bcd}தந\u{bbe}ள\u{bcd}",
                "விருந\u{bcd}து",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("పుట\u{c4d}ట\u{c3f}నర\u{c4b}జు క\u{c47}కు"),
            keywords: &[
                "క\u{c47}కు",
                "పుట\u{c4d}ట\u{c3f}నర\u{c4b}జు",
                "పుట\u{c4d}ట\u{c4d}ట\u{c3f}నర\u{c4b}జు క\u{c47}కు",
                "వ\u{c47}డుక",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("торти зодрӯзӣ"),
            keywords: &[
                "десерт",
                "маҳсулоти қаннодӣ",
                "рӯзи таваллуд",
                "торт",
                "торти зодрӯзӣ",
                "ширин",
                "ҷашн",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เค\u{e49}กว\u{e31}นเก\u{e34}ด"),
            keywords: &[
                "ว\u{e31}นเก\u{e34}ด",
                "เค\u{e49}ก",
                "เค\u{e49}กว\u{e31}นเก\u{e34}ด",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("doglan gün torty"),
            keywords: &[
                "dabara",
                "datly",
                "desert",
                "doglan gün",
                "doglan gün torty",
                "süýji",
                "tort",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("keke ʻaho fāʻeleʻi"),
            keywords: &["keke ʻaho fāʻeleʻi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("doğum günü pastası"),
            keywords: &["doğum günü", "doğum günü pastası", "kutlama", "pasta"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تۇغۇلغان كۈن تورتى"),
            keywords: &[
                "ئۇن",
                "تاتلىق",
                "تورت",
                "تۇغۇلغان كۈن",
                "تۇغۇلغان كۈن تورتى",
                "تەبرىكلەش",
                "پىشۇرۇق",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("торт на день народження"),
            keywords: &[
                "випічка",
                "день",
                "десерт",
                "народження",
                "святкування",
                "солодкий",
                "торт",
                "торт на день народження",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سالگرہ کا کیک"),
            keywords: &["جشن", "سالگرہ کا کیک", "میٹھا", "پیسٹری", "کیک"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tort"),
            keywords: &[
                "nishonlash",
                "qandolat",
                "shirinlik",
                "tort",
                "tugʻilgan kun",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bánh sinh nhật"),
            keywords: &[
                "bánh",
                "bánh sinh nhật",
                "lễ kỷ niệm",
                "món tráng miệng",
                "ngọt",
                "sinh nhật",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("ngato màggal bisu-judd"),
            keywords: &[
                "bisu-judd",
                "deseer",
                "gato",
                "màggal",
                "ngato màggal bisu-judd",
                "paat",
                "suukër",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ikeyiki yomhla wokuzalwa"),
            keywords: &[
                "emnandi",
                "i-dessert",
                "ikeyiki",
                "ikeyiki yomhla wokuzalwa",
                "intlama",
                "umbhiyozo",
                "usuku lokuzalwa",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Àkàrà òyìnbó ọjọ\u{301}ìbí"),
            keywords: &[
                "ayẹyẹ",
                "Àkàrà òyìnbó ọjọ\u{301}ìbí",
                "àdídùn",
                "àkàrà òyìnbó",
                "ónjẹ dídùn",
                "ónjẹ oní fíláwà",
                "ọjọ\u{301}ìbí",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("生日蛋糕"),
            keywords: &["慶祝", "甜", "甜品", "生日蛋糕", "糕點", "蛋糕"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("生日蛋糕"),
            keywords: &["庆祝", "甜", "甜品", "生日蛋糕", "糕点", "蛋糕"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("生日蛋糕"),
            keywords: &["庆祝", "生日", "生日蛋糕", "蛋糕"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("生日蛋糕"),
            keywords: &["生日", "生日快樂", "生日蛋糕", "蛋糕"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["慶祝", "有蠟燭的蛋糕", "生日", "生日蛋糕", "蛋糕"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ikhekhe lokuzalwa"),
            keywords: &[
                "ikhekhe",
                "ikhekhe lokuzalwa",
                "okunoshukela",
                "ubumnandi",
                "ukuzalwa",
                "umbungazo",
            ],
        },
    ],
};
#[doc = "🍰"]
pub const SHORTCAKE: crate::Emoji = crate::Emoji {
    glyph: "🍰",
    codepoint: "1F370",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "shortcake",
    group: "Food & Drink",
    subgroup: "food-sweet",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("broskoek"),
            keywords: &["broskoek", "gebak", "koek", "kos", "nagereg", "sny", "soet"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የልደት ኬክ ቁራሽ"),
            keywords: &["ቁራሽ", "ኬክ", "ኬክና ብስኩት", "የልደት ኬክ ቁራሽ", "ጣፋጭ", "ጣፋጭ ምግብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}قطعة من الكعك"),
            keywords: &["كيكة", "مطعم", "\u{202b}قطعة من الكعك"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চৰ\u{9cd}টকেক"),
            keywords: &[
                "কট\u{9be}",
                "কেক",
                "চৰ\u{9cd}টকেক",
                "ডেজ\u{9be}ৰ\u{9cd}ট",
                "পেষ\u{9cd}ট\u{9cd}ৰী",
                "মিঠ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("bir dilim tort"),
            keywords: &[
                "bir dilim tort",
                "desert",
                "dilim",
                "tort",
                "xəmir",
                "şirin",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("слоены пірог"),
            keywords: &[
                "выпечка",
                "дэсерт",
                "пірог",
                "салодкі",
                "слоены пірог",
                "торт",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("шорткейк"),
            keywords: &["десерт", "парче", "сладкиш", "сладък", "шорткейк"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("শর\u{9cd}ট কেক"),
            keywords: &[
                "কেক",
                "ডেজ\u{9be}র\u{9cd}ট",
                "প\u{9cd}য\u{9be}স\u{9cd}ট\u{9cd}রি",
                "ফ\u{9be}লি",
                "মিষ\u{9cd}টি",
                "শর\u{9cd}ট কেক",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("sablegenn"),
            keywords: &["dibenn-pred", "gwastell", "sablegenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kolač s biskvitom"),
            keywords: &["kolač", "kolač s biskvitom", "komad", "slatko", "torta"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("porció de pastís"),
            keywords: &["pastís", "porció", "porció de pastís"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏚ ᎤᎦᎾᏍᏓ"),
            keywords: &["ᎠᎬᏯᎷᏴᎢ", "ᎤᎦᎾᏍᏓ", "ᎤᎦᎾᏍᏓ ᎠᎩᏍᏗ", "ᎦᏚ ᎤᎦᎾᏍᏓ", "ᎦᏚ ᎤᏂᎦᎾᏍᏓ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("dortový řez"),
            keywords: &[
                "cukrovinka",
                "dezert",
                "dort",
                "dortový řez",
                "kousek",
                "sladkost",
                "sladký",
                "zákusek",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cacen fer"),
            keywords: &["cacen", "cacen fer", "melys", "pwdin"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("lagkage"),
            keywords: &["et stykke kage", "kage", "lagkage"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Torte"),
            keywords: &[
                "Kuchen",
                "Kuchenstück",
                "Stück Torte",
                "Torte",
                "Tortenstück",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κομμάτι τούρτας"),
            keywords: &[
                "γλυκό",
                "επιδόρπιο",
                "ζύμη",
                "κομμάτι",
                "κομμάτι τούρτας",
                "τούρτα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("shortcake"),
            keywords: &["cake", "dessert", "pastry", "shortcake", "slice", "sweet"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("cake"),
            keywords: &["cake", "dessert", "pastry", "slice", "sweet"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("trozo de tarta"),
            keywords: &["pedazo de tarta", "restaurante", "tarta", "trozo de tarta"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("porción de torta"),
            keywords: &[
                "celebración",
                "cumpleaños",
                "dulce",
                "fiesta",
                "porción de torta",
                "rebanada de pastel",
                "torta",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("rebanada de pastel"),
            keywords: &["rebanada de pastel"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("rebanada de pastel"),
            keywords: &[
                "dulce",
                "panadería",
                "pastel",
                "postre",
                "rebanada",
                "rebanada de pastel",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("liivataignakook"),
            keywords: &["kook", "liivataignakook", "lõik", "magus", "magustoit"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("opiltxoa"),
            keywords: &["gozo", "opiltxo", "opiltxoa", "postre", "tarta", "zati"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ش\u{64f}رت\u{200c}کیک"),
            keywords: &[
                "دسر",
                "ش\u{64f}رت\u{200c}کیک",
                "شیرین",
                "شیرینی",
                "قاچ",
                "کیک",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kakkupala"),
            keywords: &[
                "jälkiruoka",
                "kakku",
                "kakkupala",
                "leivonnainen",
                "makea",
                "pala",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("shortcake"),
            keywords: &[
                "cake",
                "hiwa",
                "matamis",
                "pagkain",
                "panghimagas",
                "pastry",
                "shortcake",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kakustykki"),
            keywords: &["dessert", "kaka", "kakustykki", "matur", "stykki"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("gâteau sablé"),
            keywords: &["dessert", "gâteau", "gâteau sablé", "pâtisserie", "sucré"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "dessert",
                "gâteau",
                "gâteau sablé",
                "part",
                "pâtisserie",
                "sucrerie",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("brioscarán"),
            keywords: &["brioscarán", "cáca", "císte", "slisín"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("shortcake"),
            keywords: &[
                "cèic",
                "milis",
                "milseag",
                "pastraidh",
                "shortcake",
                "sliseag",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("porción de torta"),
            keywords: &["doce", "porción de torta", "sobremesa", "torta"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("નાની ક\u{ac7}ક"),
            keywords: &[
                "કાપ\u{ac7}લી ક\u{ac7}ક",
                "ક\u{ac7}ક",
                "નાની ક\u{ac7}ક",
                "ર\u{ac7}સ\u{acd}ટોરન\u{acd}ટ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("shortcake"),
            keywords: &[
                "kayan kek",
                "kayan zaƙi",
                "kek",
                "mai zaƙi",
                "shortcake",
                "yanki",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרוסת עוגה"),
            keywords: &["מאפה", "מתוק", "עוגה", "פרוסה", "פרוסת עוגה", "קינוח"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("शॉर\u{94d}टक\u{947}क"),
            keywords: &[
                "क\u{947}क",
                "क\u{947}क स\u{94d}लाइस",
                "र\u{947}स\u{94d}टोर\u{947}\u{902}ट",
                "शॉर\u{94d}टक\u{947}क",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("komad kolača"),
            keywords: &[
                "desert",
                "kolač",
                "komad kolača",
                "kriška",
                "slatko",
                "tijesto",
                "torta",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("gyümölcstorta"),
            keywords: &[
                "desszert",
                "gyümölcstorta",
                "sütemény",
                "süti",
                "torta",
                "tortaszelet",
                "édesség",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տորթի կտոր"),
            keywords: &["աղանդեր", "խմորեղեն", "կտոր", "տորթ", "տորթի կտոր", "քաղցր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kue"),
            keywords: &["kue", "makanan", "manis", "pastri", "penutup", "potongan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("àchịchaobere"),
            keywords: &[
                "etèrè",
                "mbèwa",
                "àchịcha bèkee",
                "àchịcha ụtọ",
                "àchịchaobere",
                "ụtọ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kökusneið"),
            keywords: &["kaka", "kökusneið", "terta", "veitingastaður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("fetta di torta"),
            keywords: &["fetta", "fetta di torta", "ristorante", "torta"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ショートケーキ"),
            keywords: &["お菓子", "ケーキ", "ショートケーキ", "スイーツ", "デザート"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kuwih lapis"),
            keywords: &[
                "kuwih",
                "kuwih lapis",
                "legi",
                "panganan manis",
                "pastri",
                "sairis",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("შორთქეიქი"),
            keywords: &[
                "დესერტი",
                "ნამცხვარი",
                "ნაჭერი",
                "ტკბილეული",
                "ტკბილი",
                "ტორტი",
                "შორთქეიქი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қатпарлы торт"),
            keywords: &[
                "бөлік",
                "десерт",
                "кондитер өнімдері",
                "торт",
                "тәтті",
                "қатпарлы торт",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("lagkage"),
            keywords: &["et stykke kage", "kage", "lagkage"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ន\u{17c6}ខេកម\u{17bd}យដ\u{17bb}\u{17c6}"),
            keywords: &[
                "ន\u{17c6}",
                "ន\u{17c6}ខេក",
                "ន\u{17c6}ខេកម\u{17bd}យដ\u{17bb}\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಚ\u{cbf}ಕ\u{ccd}ಕ ಕೇಕ\u{ccd}"),
            keywords: &[
                "ಚ\u{cbf}ಕ\u{ccd}ಕ ಕೇಕ\u{ccd}",
                "ಶಾರ\u{ccd}ಟ\u{ccd}\u{200c}ಕೇಕ\u{ccd}",
                "ಸ\u{ccd}ಲೈಸ\u{ccd} ಮಾಡ\u{cbf}ದ ಕೇಕ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("조각 케익"),
            keywords: &["쇼트케이크", "조각 케익", "조각케이크", "케이크"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ल\u{94d}हान क\u{947}क"),
            keywords: &[
                "क\u{941}डको",
                "क\u{947}क",
                "गोड",
                "ड\u{947}झर\u{94d}ट",
                "प\u{945}स\u{94d}ट\u{94d}री",
                "ल\u{94d}हान क\u{947}क",
                "ल\u{94d}हानक\u{947}क",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("каттама торт"),
            keywords: &["десерт", "каттама торт", "кесим", "таттуу", "торт"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Stéck Kuch"),
            keywords: &["Dessert", "Gebäck", "Kuch", "Stéck", "séiss"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຄກຫວານ"),
            keywords: &["ເຄກຫວານ", "ເຄ\u{eb1}ກຫວານ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("trapus pyragas"),
            keywords: &[
                "desertas",
                "gabalėlis",
                "kepiniai",
                "pyragas",
                "saldu",
                "trapus pyragas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kūka"),
            keywords: &["deserts", "kūka", "salds", "torte"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kekepoto"),
            keywords: &["keke", "kekepoto", "poro", "puruni", "pōhā", "reka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("овошна торта"),
            keywords: &["десерт", "овошна торта", "парче", "печиво", "слатко"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മ\u{d41}റിച\u{d4d}ച കേക\u{d4d}ക\u{d4d}"),
            keywords: &[
                "കേക\u{d4d}ക\u{d4d}",
                "കേക\u{d4d}ക\u{d4d} കഷ\u{d4d}\u{200c}ണം",
                "ചെറിയ കേക\u{d4d}ക\u{d4d}",
                "ബേക\u{d4d}കറി",
                "ഭക\u{d4d}ഷണം",
                "മ\u{d41}റിച\u{d4d}ച കേക\u{d4d}ക\u{d4d}",
                "ഹോട\u{d4d}ടൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бялууны зүсэм"),
            keywords: &["амттан", "бялуу", "бялууны зүсэм", "зүсэм"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("लहान क\u{947}क"),
            keywords: &[
                "क\u{947}क",
                "गोड",
                "प\u{947}स\u{94d}ट\u{94d}री",
                "मिठाई",
                "लहान क\u{947}क",
                "स\u{94d}लाइस",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("sepotong kek"),
            keywords: &[
                "hirisan",
                "kek",
                "kek rapuh",
                "manisan",
                "pastri",
                "pemanis mulut",
                "sepotong kek",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("shortcake"),
            keywords: &["deżerta", "għaġina", "kejk", "shortcake", "slajs", "ħelu"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အသ\u{102e}းန\u{103e}င\u{1037}\u{103a}မလ\u{102d}\u{102f}င\u{103a}အ\u{102f}ပ\u{103a} က\u{102d}တ\u{103a}မ\u{102f}န\u{1037}\u{103a}",
            ),
            keywords: &[
                "က\u{102d}တ\u{103a}",
                "အချ\u{102d}\u{102f}ပ\u{103d}\u{1032}",
                "အသ\u{102e}းန\u{103e}င\u{1037}\u{103a}မလ\u{102d}\u{102f}င\u{103a}အ\u{102f}ပ\u{103a} က\u{102d}တ\u{103a}မ\u{102f}န\u{1037}\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kakestykke"),
            keywords: &["dessert", "formkake", "kake", "kakestykke"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कचौडी"),
            keywords: &[
                "कचौडी",
                "क\u{947}क",
                "प\u{947}स\u{94d}ट\u{94d}री",
                "मिठाई",
                "मिठो",
                "स\u{94d}लाइसल",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("cake"),
            keywords: &["cake", "dessert", "gebak", "plak", "taart", "zoet"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kakestykke"),
            keywords: &["dessert", "formkake", "kake", "kakestykke"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସର\u{b4d}ଟକେକ\u{b4d}\u{200d}"),
            keywords: &[
                "କଟ\u{b3e} ଯ\u{b3e}ଇଥ\u{b3f}ବ\u{b3e} କେକ\u{b4d}\u{200c}",
                "କେକ\u{b4d}",
                "ଖଣ\u{b4d}ଡ",
                "ମ\u{b3f}ଠ\u{b3e}",
                "ରେଷ\u{b4d}ଟ\u{b41}ର\u{b3e}ଣ\u{b4d}ଟ\u{b4d}",
                "ସର\u{b4d}ଟକେକ\u{b4d}\u{200d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a47}ਸਟਰੀ"),
            keywords: &[
                "ਕ\u{a47}ਕ",
                "ਕ\u{a71}ਟਿਆ ਕ\u{a47}ਕ",
                "ਛ\u{a4b}ਟਾ ਕ\u{a47}ਕ",
                "ਪ\u{a47}ਸਟਰੀ",
                "ਹ\u{a4b}ਟਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("شارٹ کیک"),
            keywords: &["شارٹ کیک", "قاش", "میٹھائی", "میٹھی شے", "پیسٹری", "کیک"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Shọ\u{301}tkek"),
            keywords: &[
                "Dẹzat",
                "Kek",
                "Péstri",
                "Shọ\u{301}tkek",
                "Slaiz",
                "Swit",
                "Swít Fud Wé Dẹm De Chọ\u{301}p Áftá Di Mén Fud",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("tort"),
            keywords: &["ciasto", "deser", "słodycze", "tort"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لنډ کیک"),
            keywords: &["لنډ کیک", "کيک، خواږه، پاسټري، لنډ کيک، ټکړه، خوږ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pão de ló de morango"),
            keywords: &[
                "bolo",
                "fatia",
                "fatia de bolo",
                "pão de ló",
                "pão de ló de morango",
                "sobremesa",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("fatia de bolo"),
            keywords: &[
                "bolo",
                "doce",
                "fatia",
                "fatia de bolo",
                "pastelaria",
                "sobremesa",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("torta"),
            keywords: &["masa", "miski", "pedazo", "postre", "torta"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("tartă"),
            keywords: &["aluat", "desert", "dulce", "felie", "tartă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-309"),
            keywords: &["E10-309"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("кусочек торта"),
            keywords: &["выпечка", "крем", "кусочек торта", "сладкая", "торт"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("keke nto"),
            keywords: &[
                "deseri", "iryoshye", "keke", "keke nto", "patiseri", "umugati",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ننڍو ڪيڪ"),
            keywords: &["ننڍو ڪيڪ", "ڪيڪ، مٺو، پيسٽري، ٽڪڙو، مٺائي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ෂෝට\u{dca}කේක\u{dca}"),
            keywords: &[
                "අත\u{dd4}ර\u{dd4}පස",
                "කේක\u{dca}",
                "පැණ\u{dd2} රස",
                "පෙත\u{dca}ත",
                "පේස\u{dca}ට\u{dca}\u{200d}ර\u{dd2}",
                "ෂෝට\u{dca}කේක\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kus torty"),
            keywords: &["dezert", "koláč", "kus", "kus torty", "sladkosť", "torta"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("krhek kolač"),
            keywords: &[
                "krhek kolač",
                "pecivo",
                "posladek",
                "rezina",
                "sladko",
                "torta",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("keeg yar"),
            keywords: &["cajiin", "gabal", "keeg", "keeg yar", "macaan", "macmacaan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kek i shkrifët"),
            keywords: &["brumë", "kek i shkrifët", "pastë", "ëmbëlsirë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("парче торте"),
            keywords: &[
                "дeсeрт",
                "кoлaч",
                "парче",
                "парче торте",
                "слaткo",
                "тoртa",
                "тесто",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["парче торте"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("parče torte"),
            keywords: &[
                "desert",
                "kolač",
                "parče",
                "parče torte",
                "slatko",
                "testo",
                "torta",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["parče torte"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tårtbit"),
            keywords: &["kaka", "kakbit", "tårta", "tårtbit"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("keki"),
            keywords: &["keki", "kipande", "kitindamlo", "tamu", "vitobosha"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கேக\u{bcd} துண\u{bcd}டு"),
            keywords: &[
                "உணவகம\u{bcd}",
                "கேக\u{bcd}",
                "கேக\u{bcd} துண\u{bcd}டு",
                "கேக\u{bcd} ப\u{bc0}ஸ\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c47}కు ముక\u{c4d}క"),
            keywords: &[
                "క\u{c47}కు",
                "క\u{c47}కు ముక\u{c4d}క",
                "క\u{c4b}స\u{c3f}న క\u{c47}కు ముక\u{c4d}క",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("кулчақанди регак-регак"),
            keywords: &[
                "десерт",
                "кулчақанди регак-регак",
                "маҳсулоти қаннодӣ",
                "порча",
                "торт",
                "ширин",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เค\u{e49}ก"),
            keywords: &["ช\u{e34}\u{e49}นเค\u{e49}ก", "เค\u{e49}ก"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("tortuň dilimi"),
            keywords: &[
                "desert",
                "dilim",
                "süýji",
                "süýjülik",
                "tort",
                "tortuň dilimi",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("keke"),
            keywords: &["keke"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("pasta dilimi"),
            keywords: &["dilim pasta", "pasta", "pasta dilimi", "restoran"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كىچىك تورت"),
            keywords: &["ئۇن", "تاتلىق", "تورت", "كىچىك تورت", "پارچە", "پىشۇرۇق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("тістечко"),
            keywords: &["випічка", "десерт", "солодкий", "тістечко", "шматок"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کیک کا ٹکڑا"),
            keywords: &["میٹھا", "ٹکڑا", "پیسٹری", "کیک", "کیک کا ٹکڑا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tort bo‘lagi"),
            keywords: &[
                "bo‘lak",
                "qandolat",
                "shirin",
                "shirinlik",
                "tort",
                "tort bo‘lagi",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bánh ngọt"),
            keywords: &["bánh", "miếng", "món tráng miệng", "ngọt"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("gàttal-yoon"),
            keywords: &["deseer", "gato", "gàttal-yoon", "paat", "suukër", "xaaj"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-shortcake"),
            keywords: &[
                "i-dessert",
                "i-shortcake",
                "ikeyiki",
                "ilekese",
                "intlama",
                "isilayi",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Akara kekere"),
            keywords: &[
                "Akara kekere",
                "gígé",
                "àdídùn",
                "àkàrà òyìnbó",
                "ónjẹ dídùn",
                "ónjẹ oní fíláwà",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("件裝蛋糕"),
            keywords: &["件裝蛋糕", "片裝", "甜", "甜品", "糕點", "蛋糕"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("件装蛋糕"),
            keywords: &["件装蛋糕", "片装", "甜", "甜品", "糕点", "蛋糕"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("水果蛋糕"),
            keywords: &["水果蛋糕", "甜点", "蛋糕"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("蛋糕"),
            keywords: &["甜點", "蛋糕"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["一塊蛋糕", "士多啤梨蛋糕", "甜點", "蛋糕", "點心"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ikhekhe elincane"),
            keywords: &[
                "ikhekhe",
                "ikhekhe elincane",
                "okunoshukela",
                "ubumnandi",
                "ucezu",
            ],
        },
    ],
};
#[doc = "🧁"]
pub const CUPCAKE: crate::Emoji = crate::Emoji {
    glyph: "🧁",
    codepoint: "1F9C1",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "cupcake",
    group: "Food & Drink",
    subgroup: "food-sweet",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kolwyntjie"),
            keywords: &["bakkery", "koek", "kolwyntjie", "soet"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የኩባያ ኬክ"),
            keywords: &["መጋገሪያ", "የኩባያ ኬክ", "ጣፋጭ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كعكة صغيرة"),
            keywords: &["حلويات", "كاب كيك", "كعك مكوب", "كعكة صغيرة", "مخبز"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9be}পকেক"),
            keywords: &["ক\u{9be}পকেক", "বেক\u{9be}ৰী", "মিঠ\u{9be}ই"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("keks"),
            keywords: &["keks", "çörəkxana", "şirniyyat"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кекс"),
            keywords: &["выпечка", "кекс", "салодкае"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("къпкейк"),
            keywords: &["кексче с украса", "къпкейк", "сладкарница", "сладкиш"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9be}প কেক"),
            keywords: &["ক\u{9be}প কেক", "বেক\u{9be}রি", "মিষ\u{9cd}টি"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("gwastellig"),
            keywords: &["dibenn-pred", "gwastellig"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("mafin"),
            keywords: &["kolači", "mafin", "slatkiši"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cupcake"),
            keywords: &["cupcake", "dolç", "fleca", "forn", "magdalena"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎵᏍᏈᏗ ᎦᏚ ᎤᎦᎾᏍᏗ"),
            keywords: &["ᎤᎦᎾᏍᏓ", "ᎤᎵᏍᏈᏗ ᎦᏚ ᎤᎦᎾᏍᏗ", "ᏧᏂᏅᏘᏱ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("košíček"),
            keywords: &[
                "cukroví",
                "cupcake",
                "dortík",
                "košíček",
                "muffin",
                "pečivo",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cacen cwpan"),
            keywords: &["becws", "cacen cwpan", "melys"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("cupcake"),
            keywords: &["bagværk", "cupcake", "kager", "muffin"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Cupcake"),
            keywords: &["Cupcake", "Gebäck", "Konditorei", "Muffin", "süß"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: None,
            keywords: &["Cupcake"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κεκάκι"),
            keywords: &["γλυκό", "κεκάκι", "φούρνος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("cupcake"),
            keywords: &["bakery", "cupcake", "sweet"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("magdalena"),
            keywords: &["cupcake", "dulce", "magdalena", "repostería"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("pastelito"),
            keywords: &["cupcake", "madalena", "madgalena", "pastelito"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("pastelito"),
            keywords: &["pastelito"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("muffin"),
            keywords: &["magus", "muffin", "pagaritoode"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("cupcake"),
            keywords: &["cupcake", "gozo", "okindegi"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کیک فنجانی"),
            keywords: &["شیرینی", "نانوایی", "کیک فنجانی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vuokaleivos"),
            keywords: &[
                "kuppikakku",
                "leivonnainen",
                "leivos",
                "makea",
                "vuokaleivos",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("cupcake"),
            keywords: &["bake", "cupcake", "dessert", "matamis", "pagkain", "sweet"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("koppakaka"),
            keywords: &["formakaka", "kaka", "koppakaka", "søtt"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cupcake"),
            keywords: &["cupcake", "pâtisserie", "sucrerie"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("petit gâteau"),
            keywords: &["cupcake", "petit gâteau", "pâtisserie", "sucrerie"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cístín cupa"),
            keywords: &["bácús", "cístín cupa", "milseán"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cèic-chuachaige"),
            keywords: &["bèicearachd", "cèic-chuachaige", "milis"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cupcake"),
            keywords: &["cupcake", "doce", "madalena", "pastelaría"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કપક\u{ac7}ક"),
            keywords: &["કપક\u{ac7}ક", "બ\u{ac7}કરી", "મીઠાઈ"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קפקייק"),
            keywords: &["מאפה", "מאפין", "מתוק", "עוגה", "עוגה אישית", "קפקייק"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("कपक\u{947}क"),
            keywords: &[
                "कपक\u{947}क",
                "ब\u{947}करी",
                "मिठाई",
                "मिष\u{94d}ठान\u{94d}न",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("muffin"),
            keywords: &["muffin", "pekarski proizvod", "slastica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("cupcake"),
            keywords: &["cupcake", "pékáru", "édesség"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կեքս"),
            keywords: &["թխվածք", "կեքս", "քաղցրավենիք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kue mangkuk"),
            keywords: &["kue mangkuk", "manis", "roti"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("bollakaka"),
            keywords: &["bakarí", "bollakaka", "sætindi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cupcake"),
            keywords: &["cupcake", "dolce", "pasticceria"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("カップケーキ"),
            keywords: &["お菓子", "カップケーキ", "ケーキ", "スイーツ", "ベーカリー"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kuwih mangkok"),
            keywords: &["kuwih mangkok", "legi", "roti-rotian"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქაფქეიქი"),
            keywords: &["პატარა კექსი", "საცხობი", "ქაფქეიქი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("кекс"),
            keywords: &["кекс", "кулинария", "тәтті"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ន\u{17c6}ពែង"),
            keywords: &[
                "ន\u{17c6}ផ\u{17d2}អែម",
                "ន\u{17c6}ពែង",
                "ហាងន\u{17c6}ដ\u{17bb}ត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಪ\u{ccd} ಕೇಕ\u{ccd}"),
            keywords: &["ಕಪ\u{ccd} ಕೇಕ\u{ccd}", "ಬೇಕರ\u{cbf}", "ಸ\u{cbf}ಹ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("컵케이크"),
            keywords: &["디저트", "베이커리", "컵케이크"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("कपक\u{947}क"),
            keywords: &["कपक\u{947}क", "गोड", "ब\u{947}करी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("пирожное"),
            keywords: &["кондитер азыктары", "пирожное", "таттуу"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຂະໝ\u{ebb}ມເຄ\u{eb1}ກຈອກ"),
            keywords: &[
                "ຂະໜມຫວານ",
                "ຂະໝ\u{ebb}ມເຄ\u{eb1}ກຈອກ",
                "ອ\u{ebb}ບເຂ\u{ebb}\u{ec9}າຈ\u{eb5}\u{ec8}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("keksiukas"),
            keywords: &["duonos gaminiai", "keksiukas", "saldus"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kēksiņš"),
            keywords: &["kēksiņš", "maiznīca", "salds"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("тортичка"),
            keywords: &["пекарница", "слатки печива", "тортичка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കപ\u{d4d}പ\u{d4d} കേക\u{d4d}ക\u{d4d}"),
            keywords: &["കപ\u{d4d}പ\u{d4d} കേക\u{d4d}ക\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("аяган кекс"),
            keywords: &["амттан", "аяган кекс", "нарийн боовны газар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कपक\u{947}क"),
            keywords: &["कपक\u{947}क", "ब\u{947}करी", "मिठाई"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kek cawan"),
            keywords: &["bakeri", "kek cawan", "manis"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကြက\u{103a}ဥမ\u{102f}န\u{1037}\u{103a}"),
            keywords: &[
                "ကြက\u{103a}ဥမ\u{102f}န\u{1037}\u{103a}",
                "မ\u{102f}န\u{1037}\u{103a}ဖ\u{102f}တ\u{103a}လ\u{102f}ပ\u{103a}ငန\u{103a}း",
                "အချ\u{102d}\u{102f}မ\u{102f}န\u{1037}\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("cupcake"),
            keywords: &["bakst", "cupcake", "søt"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कपक\u{947}क"),
            keywords: &[
                "कपक\u{947}क",
                "गह\u{941}\u{901}को परिकार",
                "ग\u{941}लियो मिठाई",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("cupcake"),
            keywords: &["bakkerij", "cupcake", "zoet"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("cupcake"),
            keywords: &["bakst", "cupcake", "søt"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କପ\u{b4d}\u{200c} କେକ\u{b4d}\u{200c}"),
            keywords: &[
                "କପ\u{b4d}\u{200c} କେକ\u{b4d}\u{200c}",
                "ବେକେର\u{b3f}",
                "ମ\u{b3f}ଠ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a71}ਪਕ\u{a47}ਕ"),
            keywords: &["ਕ\u{a71}ਪਕ\u{a47}ਕ", "ਬ\u{a47}ਕਰੀ", "ਮਿ\u{a71}ਠਾ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kọ\u{301}pkek"),
            keywords: &["Békri", "Kọ\u{301}pkek", "Swit"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("babeczka"),
            keywords: &["babeczka", "cukiernia", "deser"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کپ کيک"),
            keywords: &["بيکري، کپ کيک، خوږ", "کپ کيک"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cupcake"),
            keywords: &["bolo", "confeitaria", "cupcake", "doce", "torta"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["bolo", "cupcake", "doce", "pastelaria", "queque"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("cupcake"),
            keywords: &["cupcake", "miskʼi", "panaderia"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("brioșă"),
            keywords: &["brioșă", "dulce", "patiserie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-047"),
            keywords: &["E11-047"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("капкейк"),
            keywords: &["выпечка", "капкейк", "кекс"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪپ ڪيڪ"),
            keywords: &["بيڪري", "مٺايي", "ڪپ ڪيڪ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කප\u{dca}කේක\u{dca}"),
            keywords: &["කප\u{dca}කේක\u{dca}", "පැණ\u{dd2}රස", "බේකර\u{dd2}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("košíček"),
            keywords: &["košíček", "pečivo", "sladkosť", "zákusok"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kolaček"),
            keywords: &["kolaček", "pekarna", "posladek"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("koob keeg"),
            keywords: &["goob rooti lagu dubo", "koob keeg", "macaan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kek i vogël"),
            keywords: &["furrë", "kek", "kek i vogël", "ëmbëlsirë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("капкејк"),
            keywords: &["капкејк", "слаткиш"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kapkejk"),
            keywords: &["kapkejk", "slatkiš"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("muffin"),
            keywords: &["bakelse", "bakverk", "muffin"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("keki ndogo"),
            keywords: &["keki ndogo", "kuoka", "tamu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கப\u{bcd}கேக\u{bcd}"),
            keywords: &["இனிப\u{bcd}பு", "கப\u{bcd}கேக\u{bcd}", "பேக\u{bcd}கரி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కప\u{c4d}\u{200c}క\u{c47}క\u{c4d}"),
            keywords: &[
                "కప\u{c4d}\u{200c}క\u{c47}క\u{c4d}",
                "బ\u{c47}కర\u{c40}",
                "స\u{c4d}వ\u{c40}ట\u{c4d}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ค\u{e31}พเค\u{e49}ก"),
            keywords: &["ขนมหวาน", "ค\u{e31}พเค\u{e49}ก", "เบเกอร\u{e35}\u{e48}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("käse tort"),
            keywords: &["käse tort", "süýji", "çörekhana"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ipukeke"),
            keywords: &["ipukeke"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("cupcake"),
            keywords: &["cupcake", "fırın", "kapkek", "tatlı", "top kek"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("капкейк"),
            keywords: &["випічка", "капкейк", "кекс", "смаколик", "торт", "тістечко"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کپ کیک"),
            keywords: &["بیکری", "میٹھا", "کپ کیک"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kapkeyk"),
            keywords: &["kapkeyk", "keks", "pishiriq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bánh nướng nhỏ"),
            keywords: &["bánh nướng nhỏ", "ngọt", "tiệm bánh"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("紙杯蛋糕"),
            keywords: &["烘焙", "甜品", "紙杯蛋糕"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("纸杯蛋糕"),
            keywords: &["烘焙", "甜品", "纸杯蛋糕"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("纸杯蛋糕"),
            keywords: &["烘焙食品", "甜点", "纸杯蛋糕"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("杯子蛋糕"),
            keywords: &["杯子蛋糕", "烘焙", "甜點"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("cupcake"),
            keywords: &["bakery", "cupcake", "sweet"],
        },
    ],
};
#[doc = "🥧"]
pub const PIE: crate::Emoji = crate::Emoji {
    glyph: "🥧",
    codepoint: "1F967",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "pie",
    group: "Food & Drink",
    subgroup: "food-sweet",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("pastei"),
            keywords: &["pastei", "tertjie", "vulsel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ፓይ"),
            keywords: &["ፓይ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("فطيرة"),
            keywords: &["فطيرة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9be}ই"),
            keywords: &["প\u{9be}ই", "পেষ\u{9cd}ট\u{9cd}ৰী", "ফিলিং"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("piroq"),
            keywords: &["piroq", "tort"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("торт"),
            keywords: &["выпечка", "начынка", "пірог", "торт"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("пай"),
            keywords: &["пай", "пълнеж", "тестени"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9be}ই"),
            keywords: &["প\u{9be}ই", "পেস\u{9cd}ট\u{9cd}রি", "ফিলিং"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("tartezenn"),
            keywords: &["dibenn-pred", "tartezenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("slatka pita"),
            keywords: &["fil", "kolač", "pecivo", "slatka pita"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("coca"),
            keywords: &["coca", "farcit", "pastís"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎨᎵᏍᎩ"),
            keywords: &["ᎤᏍᏗ ᎨᎵᏍᎩ", "ᎨᎵᏍᎩ", "ᎭᏫᎾᏗᏜ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("koláč"),
            keywords: &["koláč", "náplň", "pečivo", "páj"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("pei"),
            keywords: &["llenwad", "pei", "toes"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("tærte"),
            keywords: &["fyld", "kage", "tærte"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Kuchen"),
            keywords: &["Füllung", "Gebäck", "Kuchen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πίτα"),
            keywords: &["αρτοσκευάσματα", "γέμιση", "πίτα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("pie"),
            keywords: &["filling", "pastry", "pie"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["filling", "pastry", "pie", "slice", "tart"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pastel"),
            keywords: &["masa", "pastel", "relleno"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("pay"),
            keywords: &["pay"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("pay"),
            keywords: &["pay", "relleno", "repostería"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("pirukas"),
            keywords: &["pirukas", "täidis"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("tarta"),
            keywords: &["betegarri", "hostore", "tarta"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پای"),
            keywords: &["خمیر شیرینی", "مواد روی کیک", "پای", "کیک", "کیک شیرینی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("piirakka"),
            keywords: &["leivonnainen", "piirakka", "täyte"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pie"),
            keywords: &["palaman", "pastry", "pie"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("pai"),
            keywords: &["dessert", "kaka", "matur", "pai"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("tarte"),
            keywords: &["décoration", "garniture", "gâteau", "pâtisserie", "tarte"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("pióg"),
            keywords: &["líonadh", "pióg", "taosrán"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("pàidh"),
            keywords: &["lìonadh", "pastraidh", "pigheann", "pàidh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("pastel"),
            keywords: &["pastel", "torta"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પાઇ"),
            keywords: &["પાઇ", "પ\u{ac7}સ\u{acd}ટ\u{acd}રી", "ફિલિ\u{a82}ગ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fai"),
            keywords: &["cika", "fai", "kayan fulawa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פשטידה"),
            keywords: &["מאפה", "פאי", "פשטידה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पाई"),
            keywords: &["पाई", "प\u{947}स\u{94d}ट\u{94d}री"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("pita"),
            keywords: &["pita", "punjenje", "tijesto"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("pite"),
            keywords: &["pite", "sütemény", "töltelék"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կարկանդակ"),
            keywords: &["լցոնած", "խմորեղեն", "կարկանդակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pai"),
            keywords: &["isi", "kue kering", "pai", "pastri"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("achịcha na anụ"),
            keywords: &["achịcha", "achịcha na anụ", "mmeju"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("baka"),
            keywords: &["baka", "bökudeig", "fylling", "sætabrauð"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("torta"),
            keywords: &["apple pie", "torta", "torta di mele", "tortino"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("パイ"),
            keywords: &["お菓子", "タルト", "パイ"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pai"),
            keywords: &["isi", "pai", "pastri"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ნამცხვარი"),
            keywords: &["ნამცხვარი", "ტორტი", "ღვეზელი", "შტრუდელი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бәліш"),
            keywords: &["бәліш"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ន\u{17c6}ដ\u{17bb}ត"),
            keywords: &["ន\u{17c6}ដ\u{17bb}ត", "ស\u{17c6}បក", "ស\u{17d2}ន\u{17bc}ល"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪೈ"),
            keywords: &[
                "ಪೇಸ\u{ccd}ಟ\u{ccd}ರ\u{cbf}",
                "ಪೈ",
                "ಫ\u{cbf}ಲ\u{ccd}ಲ\u{cbf}ಂಗ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("파이"),
            keywords: &["파이", "패스트리"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पाय"),
            keywords: &["पाय", "प\u{945}स\u{94d}ट\u{94d}री", "भरण"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("пирог"),
            keywords: &["кондитер азыктары", "пирог", "фарш"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Taart"),
            keywords: &["Fëllung", "Gebäck", "Taart"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພາຍ"),
            keywords: &["ພາຍ", "ພາສທຣ\u{eb5}", "ຟ\u{eb4}ລລ\u{eb4}ງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("pyragas"),
            keywords: &["pyragas", "tešla", "užpildytas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pīrāgs"),
            keywords: &["mīkla", "pildījums", "pīrāgs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pāi"),
            keywords: &["pāi", "pōhā", "whakakī"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("пита"),
            keywords: &["печиво", "пита", "фил"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പൈ"),
            keywords: &["അട", "പേസ\u{d4d}ട\u{d4d}രി", "പൈ", "ഫില\u{d4d}ലിംഗ\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зүсэм бялуу"),
            keywords: &["зүсэм бялуу", "нарийн боов"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पाय"),
            keywords: &["पाय", "प\u{947}स\u{94d}ट\u{94d}री", "फिलि\u{902}ग"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pai"),
            keywords: &["inti", "pai", "pastri"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("torta"),
            keywords: &["għaġina", "mili", "torta"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပ\u{102d}\u{102f}င\u{103a}မ\u{102f}န\u{1037}\u{103a}"),
            keywords: &[
                "ပ\u{102d}\u{102f}င\u{103a}",
                "ပ\u{102d}\u{102f}င\u{103a}မ\u{102f}န\u{1037}\u{103a}",
                "အစာသ\u{103d}တ\u{103a}မ\u{102f}န\u{1037}\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("pai"),
            keywords: &["butterdeig", "fyll", "pai"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("समोसा"),
            keywords: &["प\u{947}स\u{94d}ट\u{94d}री", "फिलिङ", "समोसा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("taart"),
            keywords: &["gebakje", "taart", "vulling"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("pai"),
            keywords: &["butterdeig", "fyll", "pai"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b3e}ଇ"),
            keywords: &["ପ\u{b3e}ଇ", "ପେଷ\u{b4d}ଟ\u{b4d}ର\u{b3f} । ପ\u{b42}ରଣ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪਾਈ"),
            keywords: &["ਪਾਈ", "ਪ\u{a47}ਸਟਰੀ", "ਭਰਤ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پائی"),
            keywords: &["بھرائی", "پائی", "پیسٹری"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pai"),
            keywords: &["Fílin", "Pai", "Péstri"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("ciasto"),
            keywords: &["ciasto"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پائی"),
            keywords: &["پائی", "ډکول، پاسټري، پاي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("torta"),
            keywords: &["fatia de torta", "torta"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("tarte"),
            keywords: &["recheio", "tarte"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tarta"),
            keywords: &["huntʼa", "masa", "tarta"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("plăcintă"),
            keywords: &["aluat", "plăcintă", "umplutură"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1091"),
            keywords: &["E10-1091"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("пирог"),
            keywords: &["выпечка", "пирог", "сдоба", "торт"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("imbonerahamwe"),
            keywords: &["igisafuriya", "imbonerahamwe", "patiseri"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پائي"),
            keywords: &["پائي", "پيسٽري، ڀريل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පය\u{dd2}"),
            keywords: &[
                "පය\u{dd2}",
                "ප\u{dd2}රව\u{dd3}ම\u{dca}",
                "පේස\u{dca}ට\u{dca}ර\u{dd2}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("koláč"),
            keywords: &["koláč", "pečivo", "plnka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("pita"),
            keywords: &["pita"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("doolsho"),
            keywords: &["buuxinta", "cajiinka", "doolsho"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("byrek"),
            keywords: &["brumë", "byrek", "petë e mbushur"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("пита"),
            keywords: &["пециво", "пита", "фил"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("pita"),
            keywords: &["fil", "pecivo", "pita"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("paj"),
            keywords: &["deg", "fyllnad", "paj"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("pai"),
            keywords: &["pai", "vijazo", "vitobosho"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பை"),
            keywords: &["ஃபில\u{bcd}லிங\u{bcd}", "இனிப\u{bcd}பு", "கேக\u{bcd}", "பை"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c48}"),
            keywords: &[
                "ప\u{c48}",
                "ప\u{c4d}య\u{c3e}స\u{c4d}ట\u{c4d}ర\u{c40}",
                "ఫ\u{c3f}ల\u{c4d}ల\u{c3f}ంగ\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("пирог"),
            keywords: &["адвия", "пирог", "қаннодӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("พาย"),
            keywords: &["ขนมอบ", "พาย"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("tort"),
            keywords: &["içli", "süýjülik", "tort"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pai"),
            keywords: &["pai"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("tart"),
            keywords: &["pasta", "poğaça", "tart"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("پۆرە"),
            keywords: &["خېمىر", "قىيما", "پۆرە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("пиріг"),
            keywords: &["випічка", "начинка", "пиріг"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پائي"),
            keywords: &["بھرنا", "پائي", "پیسری"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("pirog"),
            keywords: &["pirog", "pishiriq", "sut shirinlik", "tort"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bánh nướng"),
            keywords: &["bánh ngọt", "bánh nướng", "bột nhồi"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("tàrt"),
            keywords: &["farinu", "mburu", "tàrt"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ipayi"),
            keywords: &["intlama", "into ehlohliweyo", "ipayi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("róbótó"),
            keywords: &["kíkún", "róbótó", "àkàrà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("批"),
            keywords: &["批", "糕點", "餡料"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("批"),
            keywords: &["批", "糕点", "馅料"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("派"),
            keywords: &["油酥点心", "派", "糕点"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("派"),
            keywords: &["派"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("批"),
            keywords: &["批"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphaya"),
            keywords: &["inhlama", "okwaphakathi", "uphaya"],
        },
    ],
};
#[doc = "🍫"]
pub const CHOCOLATE_BAR: crate::Emoji = crate::Emoji {
    glyph: "🍫",
    codepoint: "1F36B",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "chocolate bar",
    group: "Food & Drink",
    subgroup: "food-sweet",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("sjokoladestaaf"),
            keywords: &[
                "blok",
                "kos",
                "sjokolade",
                "sjokoladestaaf",
                "soet",
                "staaf",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቸኮላታ"),
            keywords: &["ቸኮላታ", "ቸኮላት", "አሞሌ", "ጣፋጭ", "ጣፋጭ ምግብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("لوح شوكولاتة"),
            keywords: &[
                "بار شيكولاتة",
                "لوح شوكولاتة",
                "مطعم",
                "\u{202b}لوح شيكولاتة",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চকলেট ব\u{9be}ৰ"),
            keywords: &["চকলেট", "ব\u{9be}ৰ", "মিঠ\u{9be}", "মিঠ\u{9be}ই"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("şokolad plitkası"),
            keywords: &["desert", "plitka", "şirin", "şokolad", "şokolad plitkası"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("плітка шакаладу"),
            keywords: &["дэсерт", "плітка", "плітка шакаладу", "салодкі", "шакалад"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Шоколадово блокче"),
            keywords: &["Шоколадово блокче", "блокче", "десерт", "сладък", "шоколад"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চকলেট ব\u{9be}র"),
            keywords: &["চকলেট", "ডেজ\u{9be}র\u{9cd}ট", "ব\u{9be}র", "মিষ\u{9cd}টি"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("barrenn chokolad"),
            keywords: &["barrenn chokolad", "dibenn-pred"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("čokolada"),
            keywords: &["desert", "slatko", "čokolada", "čokoladica"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("rajola de xocolata"),
            keywords: &["rajola", "rajola de xocolata", "xocolata"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏬᏗᎨ ᎧᎵᏎᏥ"),
            keywords: &["ᎠᏯᏔᎾᎸ", "ᎤᎦᎾᏍᏗ", "ᎤᎦᎾᏍᏗ ᎠᎩᏍᏗ", "ᎤᏬᏗᎨ ᎧᎵᏎᏥ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("tabulka čokolády"),
            keywords: &[
                "cukrovinka",
                "sladkost",
                "sladký",
                "tabulka",
                "tabulka čokolády",
                "čokoláda",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bar o siocled"),
            keywords: &["bar", "bar o siocled", "melys", "siocled"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("chokolade"),
            keywords: &["chokolade", "et stykke chokolade"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schokoladentafel"),
            keywords: &["Schokolade", "Schokoladentafel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σοκολάτα"),
            keywords: &["γλυκό", "μπάρα", "σοκολάτα", "σοκολάτα επιδόρπιο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("chocolate bar"),
            keywords: &["bar", "chocolate", "dessert", "sweet"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("tableta de chocolate"),
            keywords: &[
                "barra",
                "chocolate",
                "restaurante",
                "tableta",
                "tableta de chocolate",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["chocolate", "dulce", "postre", "tableta de chocolate"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("barra de chocolate"),
            keywords: &[
                "barra",
                "barra de chocolate",
                "chocolate",
                "dulce",
                "postre",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("šokolaaditahvel"),
            keywords: &["magus", "magustoit", "šokolaad", "šokolaaditahvel"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("txokolatina"),
            keywords: &["gozo", "postre", "txokolate", "txokolatina", "zati"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تخته شکلات"),
            keywords: &["تخته شکلات", "تکه", "دسر", "شکلات", "شیرین", "کاکائو"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("suklaapatukka"),
            keywords: &["jälkiruoka", "makea", "patukka", "suklaa", "suklaapatukka"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tsokolate"),
            keywords: &[
                "bar",
                "chocolate",
                "dessert",
                "matamis",
                "pagkain",
                "panghimagas",
                "tsokolate",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sjokulátapláta"),
            keywords: &["matur", "pláta", "sjokuláta", "sjokulátapláta"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("barre chocolatée"),
            keywords: &["barre", "barre chocolatée", "chocolat", "dessert", "sucré"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("tablette de chocolat"),
            keywords: &[
                "barre",
                "chocolat",
                "dessert",
                "sucré",
                "tablette de chocolat",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("seacláid"),
            keywords: &["barra", "barra seacláide", "seacláid"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bàr teòclaid"),
            keywords: &["bàr", "milis", "milseag", "teòclaid"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("chocolate"),
            keywords: &["chocolate", "doce", "libra"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચોકલ\u{ac7}ટ બાર"),
            keywords: &["ચોકલ\u{ac7}ટ", "બાર", "ર\u{ac7}સ\u{acd}ટોરન\u{acd}ટ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("sandar Cakulan"),
            keywords: &[
                "cakulan",
                "kayan zaƙi",
                "mai zaƙi",
                "sanda",
                "sandar Cakulan",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חפיסת שוקולד"),
            keywords: &["חטיף", "חפיסת שוקולד", "מתוק", "שוקולד"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चॉकल\u{947}ट बार"),
            keywords: &["चॉकल\u{947}ट", "बार", "र\u{947}स\u{94d}टोर\u{947}\u{902}ट"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tabla čokolade"),
            keywords: &["desert", "slatko", "tabla", "tabla čokolade", "čokolada"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("csokoládé"),
            keywords: &[
                "csoki",
                "csokoládé",
                "desszert",
                "táblás csokoládé",
                "édesség",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("շոկոլադե սալիկ"),
            keywords: &["աղանդեր", "շոկոլադ", "շոկոլադե սալիկ", "սալիկ", "քաղցր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("sebatang cokelat"),
            keywords: &[
                "batangan",
                "cokelat",
                "makanan",
                "manis",
                "penutup",
                "sebatang cokelat",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ogwe chọkọleti"),
            keywords: &["chọkọleti", "ogwe", "àchịcha ụtọ", "ụtọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("súkkulaði"),
            keywords: &["súkkulaði", "súkkulaðiplata", "veitingastaður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cioccolato"),
            keywords: &[
                "barretta",
                "barretta di cioccolato",
                "cioccolato",
                "ristorante",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("チョコレート"),
            keywords: &["お菓子", "スイーツ", "チョコ", "チョコレート", "デザート"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sapapan soklat"),
            keywords: &[
                "legi",
                "panganan manis",
                "papan",
                "sapapan soklat",
                "soklat",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("შოკოლადის ფილა"),
            keywords: &[
                "ბარი",
                "დესერტი",
                "ტკბილეული",
                "ტკბილი",
                "შოკოლადი",
                "შოკოლადის ფილა",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тақта шоколад"),
            keywords: &["десерт", "тақта", "тәтті", "шоколад"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("chokolade"),
            keywords: &["chokolade", "et stykke chokolade"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បន\u{17d2}ទះស\u{17bc}ក\u{17bc}ឡា"),
            keywords: &[
                "បង\u{17d2}អែម",
                "បន\u{17d2}ទះស\u{17bc}ក\u{17bc}ឡា",
                "ផ\u{17d2}អែម",
                "ស\u{17bc}ក\u{17bc}ឡា",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಚಾಕೊಲೇಟ\u{ccd} ಬಾರ\u{ccd}"),
            keywords: &["ಚಾಕೊಲೇಟ\u{ccd} ಬಾರ\u{ccd}", "ಚಾಕೋಲೇಟ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("초콜렛"),
            keywords: &["초코", "초코바", "초콜렛"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("चॉकल\u{947}ट बार"),
            keywords: &["गोड", "चॉकल\u{947}ट", "ड\u{947}झर\u{94d}ट", "बार"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("шоколад тилкеси"),
            keywords: &["десерт", "таттуу", "тилке", "шоколад", "шоколад тилкеси"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Tablett Schockela"),
            keywords: &[
                "Dessert",
                "Schokela",
                "Tablett",
                "Tablett Schockela",
                "séiss",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແທ\u{ec8}ງຊ\u{eb1}ອກໂກແລ\u{eb1}ດ"),
            keywords: &[
                "ຊ\u{eb1}ອກໂກແລ\u{eb1}ດ",
                "ແທ\u{ec8}ງ",
                "ແທ\u{ec8}ງຊ\u{eb1}ອກໂກແລ\u{eb1}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("šokolado batonėlis"),
            keywords: &[
                "batonėlis",
                "desertas",
                "saldu",
                "šokoladas",
                "šokolado batonėlis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("šokolādes tāfelīte"),
            keywords: &["deserts", "salds", "šokolāde", "šokolādes tāfelīte"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pae tiokorete"),
            keywords: &["pae", "pae tiokorete", "puruni", "reka", "tiokoreti"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("чоколадо"),
            keywords: &["десерт", "слатко", "чоколадо"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ചോക\u{d4d}ലേറ\u{d4d}റ\u{d4d} ബ\u{d3e}ർ"),
            keywords: &[
                "ചോക\u{d4d}കലേറ\u{d4d}റ\u{d4d}",
                "ചോക\u{d4d}ലേറ\u{d4d}റ\u{d4d} ബ\u{d3e}ർ",
                "ബ\u{d3e}ർ",
                "ഭക\u{d4d}ഷണം",
                "ഹോട\u{d4d}ടൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("шоколад"),
            keywords: &["амттан", "чихэр", "шоколад"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चॉकल\u{947}ट बार"),
            keywords: &["गोड", "चॉकल\u{947}ट", "बार", "मिठाई"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("sekeping coklat"),
            keywords: &["bar", "coklat", "manis", "pencuci mulut", "sekeping coklat"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("biċċa ċikkulata"),
            keywords: &["biċċa", "deżerta", "ċikkulata", "ħelwa"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ချောကလက\u{103a} အချောင\u{103a}း"),
            keywords: &[
                "ချောကလက\u{103a}",
                "အချ\u{102d}\u{102f}",
                "အချ\u{102d}\u{102f}ပ\u{103d}\u{1032}",
                "အချောင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sjokoladeplate"),
            keywords: &["sjokoladeplate"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("चकल\u{947}ट बार"),
            keywords: &["चकल\u{947}ट", "बार", "मिठाई", "मिठो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("chocoladereep"),
            keywords: &["chocolade", "chocoladereep", "dessert", "reep", "zoet"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("sjokoladeplate"),
            keywords: &["sjokoladeplate"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଚକଲେଟ\u{b4d}\u{200d} ବ\u{b3e}ର\u{b4d}\u{200d}"),
            keywords: &[
                "ଚକଲେଟ\u{b4d}\u{200c}",
                "ବ\u{b3e}ର\u{b4d}\u{200c}",
                "ମ\u{b3f}ଠ\u{b3e}",
                "ରେଷ\u{b4d}ଟ\u{b41}ର\u{b3e}ଣ\u{b4d}ଟ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚਾਕਲ\u{a47}ਟ ਬਾਰ"),
            keywords: &["ਚਾਕਲ\u{a47}ਟ", "ਬਾਰ", "ਹ\u{a4b}ਟਲ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چاکلیٹ بار"),
            keywords: &["سیخ", "میٹھائی", "میٹھی شے", "چاکلیٹ", "چاکلیٹ بار"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ckọ\u{301}kọ\u{301}lét Stik"),
            keywords: &[
                "Ckọ\u{301}kọ\u{301}let",
                "Ckọ\u{301}kọ\u{301}lét Stik",
                "Dẹzat",
                "Stik",
                "Swít Fud Wé Dẹm De Chọ\u{301}p Áftá Di Mén Fud",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("tabliczka czekolady"),
            keywords: &["deser", "słodycze", "tabliczka czekolady"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د چاکلیټ بار"),
            keywords: &["بار، چاکليټ، خواږه، خوږ", "د چاکلیټ بار"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("chocolate"),
            keywords: &["barra", "barra de chocolate", "chocolate"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("tablete de chocolate"),
            keywords: &[
                "chocolate",
                "doce",
                "sobremesa",
                "tablete",
                "tablete de chocolate",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("chocolate barra"),
            keywords: &["barra", "chocolate", "miski", "postre"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("baton de ciocolată"),
            keywords: &[
                "baton",
                "baton de ciocolată",
                "ciocolată",
                "desert",
                "dulce",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-304"),
            keywords: &["E10-304"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("шоколад"),
            keywords: &["плитка шоколада", "шоколад", "шоколадка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("shokola"),
            keywords: &["akabari", "iryoshye", "shokola", "shokora"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("چاڪليٽ لڙي"),
            keywords: &["لڙي، چاڪليٽ، مٺو، مٺائي", "چاڪليٽ لڙي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("චොකලට\u{dca} ත\u{dd3}ර\u{dd4}ව"),
            keywords: &[
                "අත\u{dd4}ර\u{dd4}පස",
                "චොකලට\u{dca}",
                "ත\u{dd3}ර\u{dd4}ව",
                "පැණ\u{dd2} රස",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("čokoláda"),
            keywords: &["dezert", "sladkosť", "tyčinka", "čokoláda"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("tablica čokolade"),
            keywords: &[
                "posladek",
                "sladko",
                "tablica",
                "tablica čokolade",
                "čokolada",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("shukulaato"),
            keywords: &["gabal", "macaan", "macmacaanka", "shukulaato"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("çokollatë"),
            keywords: &["copë", "e ëmbël", "çokollatë", "ëmbëlsirë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("чоколадица"),
            keywords: &["дeсeрт", "слaткo", "чoкoлaдa", "чоколадица"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("čokoladica"),
            keywords: &["desert", "slatko", "čokolada", "čokoladica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("chokladkaka"),
            keywords: &["choklad", "chokladbit", "chokladkaka", "godis"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("chokoleti"),
            keywords: &["chokoleti", "kitindamlo", "mche", "tamu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ச\u{bbe}க\u{bcd}லேட\u{bcd}"),
            keywords: &[
                "இனிப\u{bcd}பு",
                "உணவகம\u{bcd}",
                "ச\u{bbe}க\u{bcd}லேட\u{bcd}",
                "ச\u{bbe}க\u{bcd}லேட\u{bcd} ப\u{bbe}ர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c3e}క\u{c4a}ల\u{c47}ట\u{c4d} బ\u{c3e}ర\u{c4d}"),
            keywords: &[
                "చ\u{c3e}క\u{c4a}ల\u{c47}ట\u{c4d} బ\u{c3e}ర\u{c4d}",
                "చ\u{c3e}క\u{c4d}ల\u{c47}ట\u{c4d}",
                "బ\u{c3e}ర\u{c4d}",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("як тахтача шоколад"),
            keywords: &[
                "десерт",
                "тахтача",
                "ширин",
                "шоколад",
                "як тахтача шоколад",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ช\u{e47}อกโกแลต"),
            keywords: &["ช\u{e47}อกโกแลต", "ช\u{e47}อกโกแลตแท\u{e48}ง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("şokolad plitasy"),
            keywords: &["desert", "plita", "süýji", "şokolad", "şokolad plitasy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("lole sokaleti"),
            keywords: &["lole sokaleti"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("çikolata"),
            keywords: &["bar", "restoran", "çikolata", "çikolata barı"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قەلەمچە شاكىلات"),
            keywords: &["تاتلىق", "تالچە", "شاكىلات", "قەلەمچە شاكىلات", "پىشۇرۇق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("плитка шоколаду"),
            keywords: &["десерт", "плитка", "плитка шоколаду", "солодкий", "шоколад"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چاکلیٹ بار"),
            keywords: &["بار", "میٹھی", "چاکلیٹ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("shokolad bo‘lagi"),
            keywords: &[
                "shirin",
                "shirinlik",
                "shokolad",
                "shokolad boʻlagi",
                "shokolad bo‘lagi",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("thanh sô cô la"),
            keywords: &[
                "món tráng miệng",
                "ngọt",
                "sô cô la",
                "thanh",
                "thanh sô cô la",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("laatu-sokolaa"),
            keywords: &["deseer", "laal", "laatu-sokolaa", "sokolaa", "suukër"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isixwexwe setshokolethi"),
            keywords: &[
                "i-dessert",
                "ilekese",
                "isixwexwe",
                "isixwexwe setshokolethi",
                "itshokolethi",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ṣokoleti Didi"),
            keywords: &[
                "ilé otí",
                "àdídùn",
                "ónjẹ dídùn",
                "Ṣokoleti Didi",
                "ṣokolétì",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("朱古力條"),
            keywords: &["朱古力", "朱古力條", "條", "甜", "甜品"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("朱古力条"),
            keywords: &["朱古力", "朱古力条", "条", "甜", "甜品"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("巧克力"),
            keywords: &["巧克力", "甜品", "甜点"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("巧克力"),
            keywords: &["巧克力", "巧克力磚"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("朱古力"),
            keywords: &["一排朱古力", "朱古力", "甜品"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ushokoledi"),
            keywords: &["okunoshukela", "ubumnandi", "ushokoledi"],
        },
    ],
};
#[doc = "🍬"]
pub const CANDY: crate::Emoji = crate::Emoji {
    glyph: "🍬",
    codepoint: "1F36C",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "candy",
    group: "Food & Drink",
    subgroup: "food-sweet",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("lekker"),
            keywords: &["lekker", "lekkergoed", "soet"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ከረሜላ"),
            keywords: &["ከረሜላ", "ጣፋጭ", "ጣፋጭ ምግብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("حلوى"),
            keywords: &["حلوى", "مطعم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কেণ\u{9cd}ডী"),
            keywords: &["কেণ\u{9cd}ডী", "মিঠ\u{9be}", "মিঠ\u{9be}ই"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("konfet"),
            keywords: &["desert", "konfet", "şirin"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("цукерка"),
            keywords: &["дэсерт", "салодкі", "цукерка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("бонбон"),
            keywords: &["бонбон", "десерт", "сладък"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9cd}য\u{9be}ন\u{9cd}ডি"),
            keywords: &[
                "ক\u{9cd}য\u{9be}ন\u{9cd}ডি",
                "ডেজ\u{9be}র\u{9cd}ট",
                "মিষ\u{9cd}টি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("madig"),
            keywords: &["dibenn-pred", "madig"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("bombona"),
            keywords: &["bombona", "desert", "slatko"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("caramel"),
            keywords: &["caramel", "dolç", "postres"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎧᎵᏎᏥ"),
            keywords: &["ᎤᎦᎾᏍᏓ", "ᎤᎦᎾᏍᏓ ᎠᎩᏍᏗ", "ᎧᎵᏎᏥ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("bonbon"),
            keywords: &["bonbon", "cukrovinka", "sladkost", "sladký"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("losin"),
            keywords: &["losin", "melys", "pwdin"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bolsje"),
            keywords: &["bolsje", "slik"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Bonbon"),
            keywords: &["Bonbon", "Süßigkeit"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: None,
            keywords: &["Bonbon"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καραμέλα"),
            keywords: &["γλυκό", "επιδόρπιο", "καραμέλα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("candy"),
            keywords: &["candy", "dessert", "sweet"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("sweets"),
            keywords: &["dessert", "sweet", "sweets"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("candy"),
            keywords: &["candy", "dessert", "sweet", "sweets"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("caramelo"),
            keywords: &["caramelo", "chuche", "chuchería", "dulce", "golosina"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["caramelo", "dulce", "postre"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("komm"),
            keywords: &["komm", "magus", "magustoit"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gozokia"),
            keywords: &["gozo", "gozokia", "postre"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("آب\u{200c}نبات\u{200c}"),
            keywords: &["آب\u{200c}نبات\u{200c}", "دسر", "شیرین"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("karkki"),
            keywords: &["jälkiruoka", "karkki", "makea"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kendi"),
            keywords: &["candy", "kendi", "matamis", "pagkain"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("bomm"),
            keywords: &["bomm", "góðgæti", "matur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bonbon"),
            keywords: &["bonbon", "dessert", "sucré"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["bonbon", "dessert", "sucrerie", "sucré"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("milseán"),
            keywords: &["milseán"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("suiteas"),
            keywords: &["milis", "milseag", "suiteas"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("caramelo"),
            keywords: &["caramelo", "doce"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ક\u{ac7}ન\u{acd}ડી"),
            keywords: &["ક\u{ac7}ન\u{acd}ડી", "ર\u{ac7}સ\u{acd}ટોરન\u{acd}ટ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("alawa"),
            keywords: &["alawa", "kayan zaƙi", "mai zaƙi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סוכריה"),
            keywords: &["ממתק", "מתוק", "סוכריה", "קינוח"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("क\u{948}\u{902}डी"),
            keywords: &["क\u{948}\u{902}डी", "र\u{947}स\u{94d}टोर\u{947}\u{902}ट"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("bombon"),
            keywords: &["bombon", "desert", "slatko"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("cukorka"),
            keywords: &["cukorka", "desszert", "édesség"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կոնֆետ"),
            keywords: &["աղանդեր", "կոնֆետ", "քաղցր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("permen"),
            keywords: &["makanan", "manis", "penutup", "permen"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("kandị"),
            keywords: &["kandị", "àchịcha ụtọ", "ụtọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("nammi"),
            keywords: &["eftirréttur", "nammi", "sælgæti"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("caramella"),
            keywords: &["caramella", "dolciume"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("キャンディ"),
            keywords: &["あめ", "お菓子", "キャンディ"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("permen"),
            keywords: &["legi", "panganan manis", "permen"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კანფეტი"),
            keywords: &["დესერტი", "კანფეტი", "ტკბილეული", "ტკბილი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("мұз кәмпит"),
            keywords: &["десерт", "мұз кәмпит", "тәтті"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("bolsje"),
            keywords: &["bolsje", "slik"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}ករគ\u{17d2}រាប\u{17cb}"),
            keywords: &["បង\u{17d2}អែម", "ស\u{17d2}ករគ\u{17d2}រាប\u{17cb}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{ccd}ಯಾಂಡ\u{cbf}"),
            keywords: &[
                "ಕ\u{ccd}ಯಾಂಡ\u{cbf}",
                "ಸ\u{cbf}ಹ\u{cbf}",
                "ಸ\u{cbf}ಹ\u{cbf}ತ\u{cbf}ಂಡ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("사탕"),
            keywords: &["사탕", "캔디"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("क\u{901}डी"),
            keywords: &["क\u{901}डी", "गोड", "ड\u{947}झर\u{94d}ट"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("момпосуй"),
            keywords: &["десерт", "момпосуй", "таттуу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Kamell"),
            keywords: &["Dessert", "Kamell", "séiss"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຂ\u{ebb}\u{ec9}າໜ\u{ebb}ມອ\u{ebb}ມ"),
            keywords: &[
                "ຂອງຫວານດ ເຂ\u{ebb}\u{ec9}າໜ\u{ebb}ມ",
                "ເຂ\u{ebb}\u{ec9}າໜ\u{ebb}ມອ\u{ebb}ມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("saldainis"),
            keywords: &["desertas", "saldainis", "saldu"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("konfekte"),
            keywords: &["konfekte", "salds", "saldumi"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rare"),
            keywords: &["puruni", "rare", "reka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("бонбона"),
            keywords: &["бонбона", "десерт", "слатко"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d3e}ൻഡി"),
            keywords: &[
                "ക\u{d3e}ൻഡി",
                "ബേക\u{d4d}കറി",
                "ഭക\u{d4d}ഷണം",
                "ഹോട\u{d4d}ടൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("чихэр"),
            keywords: &["амттан", "чихэр"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("क\u{901}डी"),
            keywords: &["क\u{901}डी", "गोड", "मिठाई"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("gula-gula"),
            keywords: &["gula-gula", "manis", "pencuci mulut"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ħelu"),
            keywords: &["deżerta", "ħelu", "ħelwa"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("သကြားလ\u{102f}\u{1036}း"),
            keywords: &[
                "သကြားလ\u{102f}\u{1036}း",
                "အချ\u{102d}\u{102f}",
                "အချ\u{102d}\u{102f}ပ\u{103d}\u{1032}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("godteri"),
            keywords: &["godteri", "karamell", "smågodt", "sukkertøy", "søtsaker"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("क\u{94d}याण\u{94d}डी"),
            keywords: &["क\u{94d}याण\u{94d}डी", "मिठाई", "मिठो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("snoep"),
            keywords: &["dessert", "snoep", "zoet"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("godteri"),
            keywords: &["godteri", "karamell", "smågodt", "sukkertøy", "søtsaker"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b4d}ୟ\u{b3e}ଣ\u{b4d}ଡ\u{b3f}"),
            keywords: &[
                "କ\u{b4d}ୟ\u{b3e}ଣ\u{b4d}ଡ\u{b3f}",
                "ଡ\u{b3c}େଜର\u{b4d}ଟ",
                "ମ\u{b3f}ଠ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਟ\u{a4c}ਫੀ"),
            keywords: &["ਟ\u{a4c}ਫੀ", "ਮਿ\u{a71}ਠਾ", "ਸਵੀਟ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کھان آلی میٹھی ٹافی"),
            keywords: &["میٹھائی", "میٹھی شے", "کھان آلی میٹھی ٹافی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kándi"),
            keywords: &["Dẹzat", "Kándi", "Swit"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("cukierek"),
            keywords: &["cukierek", "deser", "słodki", "słodycze"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پتاسه"),
            keywords: &["پتاسه", "کينډي، خواږه، خوږ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bala"),
            keywords: &["bala", "balinha", "doce"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("rebuçado"),
            keywords: &["doce", "rebuçado", "sobremesa"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("miskʼi"),
            keywords: &["miski", "miskʼi", "postre"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bomboană"),
            keywords: &["bomboană", "desert", "dulce"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-305"),
            keywords: &["E10-305"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("конфета"),
            keywords: &["конфета", "обертка", "сладость", "фантик"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("bombo"),
            keywords: &["bombo", "deseri", "utwungucenge"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("کٽمٺو"),
            keywords: &["مٺو، مٺائي", "کٽمٺو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කැන\u{dca}ඩ\u{dd2}"),
            keywords: &["අත\u{dd4}ර\u{dd4}පස", "කැන\u{dca}ඩ\u{dd2}", "පැණ\u{dd2} රස"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("cukrík"),
            keywords: &["cukrík", "dezert", "sladkosť"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("bonbon"),
            keywords: &["bonbon", "posladek", "sladko"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("nacnac"),
            keywords: &["macaan", "macmacaan", "nacnac"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("ëmbëlsirë"),
            keywords: &["e ëmbël", "ëmbëlsirë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("бомбона"),
            keywords: &["бомбона", "дeсeрт", "слaткo"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("bombona"),
            keywords: &["bombona", "desert", "slatko"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("godis"),
            keywords: &["godis", "karamell"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("peremende"),
            keywords: &["kitindamlo", "peremende"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மிட\u{bcd}ட\u{bbe}ய\u{bcd}"),
            keywords: &[
                "இனிப\u{bcd}பு",
                "கேன\u{bcd}டி",
                "மிட\u{bcd}ட\u{bbe}ய\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c4d}య\u{c3e}ండ\u{c40}"),
            keywords: &[
                "క\u{c4d}య\u{c3e}ండ\u{c40}",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("конфет"),
            keywords: &["десерт", "конфет", "ширин"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e39}กอม"),
            keywords: &["ขนม", "ของหวาน", "ล\u{e39}กอม"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kemput"),
            keywords: &["desert", "kemput", "süýji"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("lole"),
            keywords: &["lole"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("şekerleme"),
            keywords: &["restoran", "şekerleme"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كەمپۈت"),
            keywords: &["تاتلىق", "كەمپۈت", "پىشۇرۇق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("цукерка"),
            keywords: &["десерт", "солодкий", "цукерка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کینڈی"),
            keywords: &["میٹھی", "کینڈی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("konfet"),
            keywords: &["konfet", "shirin", "shirinlik"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("kẹo"),
            keywords: &["kẹo", "món tráng miệng", "ngọt"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("tàngal"),
            keywords: &["deseer", "suukër", "tàngal"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ilekese"),
            keywords: &["emnandi", "i-dessert", "ilekese"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Kandi"),
            keywords: &["Kandi", "àdídùn", "ónjẹ dídùn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("糖果"),
            keywords: &["甜", "甜品", "糖果"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("糖果"),
            keywords: &["甜", "甜品", "糖果"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("糖"),
            keywords: &["糖", "糖果"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("糖"),
            keywords: &["糖", "糖果"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["甜品", "糖", "糖果"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uswidi"),
            keywords: &["okunoshukela", "ubumnandi", "uswidi"],
        },
    ],
};
#[doc = "🍭"]
pub const LOLLIPOP: crate::Emoji = crate::Emoji {
    glyph: "🍭",
    codepoint: "1F36D",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "lollipop",
    group: "Food & Drink",
    subgroup: "food-sweet",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("suiglekker"),
            keywords: &["lekkergoed", "soet", "suig", "suiglekker"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሎሊፖፕ ከረሜላ"),
            keywords: &["ሎሊፖፕ ከረሜላ", "ከረሜላ", "ጣፋጭ", "ጣፋጭ ምግብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مصاصة"),
            keywords: &["حلاوة", "مصاصة", "مطعم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ললিপপ"),
            keywords: &["কেণ\u{9cd}ডী", "মিঠ\u{9be}", "মিঠ\u{9be}ই", "ললিপপ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("şüşəli karamel"),
            keywords: &["desert", "konfet", "şirin", "şüşəli karamel"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ледзянец"),
            keywords: &["дэсерт", "ледзянец", "салодкі", "цукерка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("близалка"),
            keywords: &["близалка", "десерт", "сладкиш", "сладък"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ললিপপ"),
            keywords: &[
                "ক\u{9cd}য\u{9be}ন\u{9cd}ডি",
                "ডেজ\u{9be}র\u{9cd}ট",
                "মিষ\u{9cd}টি",
                "ললিপপ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("sunig"),
            keywords: &["dibenn-pred", "sunig"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("lizalo"),
            keywords: &["desert", "lizalo", "slatkiš", "slatko"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("piruleta"),
            keywords: &["caramel", "dolç", "pal", "piruleta", "postres"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎧᎵᏎᏥ ᎦᏅᎯᏓ"),
            keywords: &["ᎤᎦᎾᏍᏓ", "ᎤᎦᎾᏍᏓ ᎠᎩᏍᏗ", "ᎧᎵᏎᏥ", "ᎧᎵᏎᏥ ᎦᏅᎯᏓ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("lízátko"),
            keywords: &["cukrovinka", "lízátko", "sladkost", "sladký", "špejle"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("lolipop"),
            keywords: &["lolipop", "losin", "melys", "pwdin"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("slikkepind"),
            keywords: &["slik", "slikkepind"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Lutscher"),
            keywords: &["Lolli", "Lutscher", "Süßigkeit"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: None,
            keywords: &["Lutscher"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γλειφιτζούρι"),
            keywords: &["γλειφιτζούρι", "γλυκό", "γλύκισμα", "επιδόρπιο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("lollipop"),
            keywords: &["candy", "dessert", "lollipop", "sweet"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["dessert", "lollipop", "lolly", "sweet"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["candy", "dessert", "lollipop", "sweet"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("piruleta"),
            keywords: &["chuche", "chuchería", "dulce", "golosina", "piruleta"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("paleta dulce"),
            keywords: &["chupetín", "dulce", "golosina", "paleta"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("pulgakomm"),
            keywords: &["komm", "magus", "magustoit", "pulgakomm"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("piruleta"),
            keywords: &["gozo", "gozoki", "piruleta", "postre"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("آب\u{200c}نبات\u{200c}چوبی"),
            keywords: &[
                "آب\u{200c}نبات",
                "آب\u{200c}نبات\u{200c}چوبی",
                "خروس\u{200c}قندی",
                "دسر",
                "شیرین",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tikkari"),
            keywords: &["jälkiruoka", "karkki", "makea", "tikkari"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lollipop"),
            keywords: &["candy", "lollipop", "matamis", "pagkain"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sleikisneis"),
            keywords: &["matur", "sleikipinnur", "sleikisneis", "slikkipinnur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("sucette"),
            keywords: &["dessert", "sucette", "sucrerie", "sucré"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("suçon"),
            keywords: &["dessert", "sucrerie", "sucré", "suçon"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("líreacán"),
            keywords: &["líreacán", "milseán"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("lollipop"),
            keywords: &["lollipop", "milis", "milseag", "suiteas"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("piruleta"),
            keywords: &["caramelo", "doce", "piruleta"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લોલિપોપ"),
            keywords: &[
                "ક\u{ac7}ન\u{acd}ડી",
                "ર\u{ac7}સ\u{acd}ટોરન\u{acd}ટ",
                "લોલિપોપ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("alawar Lollipop"),
            keywords: &["alawa", "alawar Lollipop", "kayan zaƙi", "mai zaƙi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סוכריה על מקל"),
            keywords: &["ממתק", "מקל", "מתוק", "סוכריה", "סוכריה על מקל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("लॉलीपॉप"),
            keywords: &[
                "क\u{948}\u{902}डी",
                "र\u{947}स\u{94d}टोर\u{947}\u{902}ट",
                "लॉलीपॉप",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lizalica"),
            keywords: &["bombon", "desert", "lizalica", "slatko"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nyalóka"),
            keywords: &["cukorka", "desszert", "nyalóka", "édesség"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սառնաշաքար"),
            keywords: &["աղանդեր", "կոնֆետ", "սառնաշաքար", "քաղցր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("permen lolipop"),
            keywords: &["makanan", "manis", "penutup", "permen", "permen lolipop"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Lọlịpọpụ"),
            keywords: &["Lọlịpọpụ", "kandị", "àchịcha ụtọ", "ụtọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sleikibrjóstsykur"),
            keywords: &[
                "nammi",
                "sleikibrjóstsykur",
                "sleikjó",
                "sælgæti",
                "veitingastaður",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("lecca lecca"),
            keywords: &["caramella", "lecca lecca", "ristorante"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ぺろぺろキャンディ"),
            keywords: &[
                "あめ",
                "お菓子",
                "ぺろぺろキャンディ",
                "キャンディ",
                "棒付きキャンディ",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("permen loli"),
            keywords: &["legi", "panganan manis", "permen", "permen loli"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კანფეტი ჯოხზე"),
            keywords: &["დესერტი", "კანფეტი", "კანფეტი ჯოხზე", "ტკბილეული", "ტკბილი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("таяқшалы мұз кәмпит"),
            keywords: &["десерт", "таяқшалы мұз кәмпит", "тәтті"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("slikpind"),
            keywords: &["slik", "slikpind"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}ករដោត"),
            keywords: &["ស\u{17d2}ករ", "ស\u{17d2}ករដោត"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಲಾಲ\u{cbf}ಪಾಪ\u{ccd}"),
            keywords: &[
                "ಕ\u{ccd}ಯಾಂಡ\u{cbf}",
                "ಲಾಲ\u{cbf}ಪಾಪ\u{ccd}",
                "ಸ\u{cbf}ಹ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("롤리팝"),
            keywords: &["롤리팝", "막대 사탕", "사탕"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("लॉलिपॉप"),
            keywords: &["क\u{901}डी", "गोड", "ड\u{947}झर\u{94d}ट", "लॉलिपॉप"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чупачупс"),
            keywords: &["десерт", "момпосуй", "таттуу", "чупачупс"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Lutsch"),
            keywords: &["Dessert", "Kamell", "Lutsch", "séiss"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ອ\u{ebb}ມຍ\u{eb4}\u{ec9}ມ"),
            keywords: &[
                "ຂອງຫວານ",
                "ລ\u{eb9}ກອ\u{ebb}ມ",
                "ອ\u{ebb}ມຍ\u{eb4}\u{ec9}ມ",
                "ເຂ\u{ebb}\u{ec9}າໜ\u{ebb}ມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("ledinukas ant pagaliuko"),
            keywords: &["desertas", "ledinukas ant pagaliuko", "saldainis", "saldu"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("konfekte uz kociņa"),
            keywords: &["konfekte", "konfekte uz kociņa", "salds", "saldumi"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rarepapa"),
            keywords: &["puruni", "rare", "rarepapa", "reka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лижалче"),
            keywords: &["бонбона", "десерт", "лижалче", "слатко"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ലോലിപോപ\u{d4d}പ\u{d4d}"),
            keywords: &[
                "ക\u{d3e}ൻഡി",
                "ബേക\u{d4d}കറി",
                "ഭക\u{d4d}ഷണം",
                "ലോലിപോപ\u{d4d}പ\u{d4d}",
                "ഹോട\u{d4d}ടൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("иштэй чихэр"),
            keywords: &["амттан", "иш", "иштэй чихэр", "чихэр"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("लॉलीपॉप"),
            keywords: &["क\u{901}डी", "गोड", "मिठाई", "लॉलीपॉप"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("lolipop"),
            keywords: &["gula-gula", "lolipop", "manis", "pencuci mulut"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("lolipop"),
            keywords: &["deżerta", "lolipop", "ħelu", "ħelwa"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ချ\u{102d}\u{102f}ချဉ\u{103a}ပလ\u{102f}တ\u{103a}တ\u{102f}တ\u{103a}"),
            keywords: &[
                "ချ\u{102d}\u{102f}ချဉ\u{103a}",
                "ချ\u{102d}\u{102f}ချဉ\u{103a}ပလ\u{102f}တ\u{103a}တ\u{102f}တ\u{103a}",
                "အချ\u{102d}\u{102f}",
                "အချ\u{102d}\u{102f}ပ\u{103d}\u{1032}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kjærlighet på pinne"),
            keywords: &["kjærlighet på pinne", "sukkertøy"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("लालिपप"),
            keywords: &["क\u{94d}यान\u{94d}डी", "मिठाई", "मिठो", "लालिपप"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("lolly"),
            keywords: &["dessert", "lolly", "snoep", "zoet"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("slikkepinne"),
            keywords: &["slikkepinne", "sukkertøy"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଲଲ\u{b3f}ପପ\u{b4d}\u{200d}"),
            keywords: &[
                "କ\u{b4d}ୟ\u{b3e}ଣ\u{b4d}ଡ\u{b3f}",
                "ମ\u{b3f}ଠ\u{b3e}",
                "ରେଷ\u{b4d}ଟ\u{b41}ର\u{b3e}ଣ\u{b4d}ଟ\u{b4d}",
                "ଲଲ\u{b3f}ପପ\u{b4d}\u{200d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲ\u{a4b}ਲੀਪ\u{a4b}ਪ"),
            keywords: &["ਟ\u{a4c}ਫੀ", "ਮਿ\u{a71}ਠਾ", "ਲ\u{a4b}ਲੀਪ\u{a4b}ਪ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("لالی پاپ"),
            keywords: &["لالی پاپ", "میٹھائی", "میٹھی شے", "کھان آلی میٹھی ٹافی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Lọ\u{301}lipọp"),
            keywords: &["Dẹzat", "Kándi", "Lọ\u{301}lipọp", "Swit"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("lizak"),
            keywords: &["deser", "lizak", "słodki", "słodycze"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لالیپپ"),
            keywords: &["لالیپپ", "کينډي، خواږه، لاليپپ، خوږ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pirulito"),
            keywords: &["bala", "doce", "pirulito"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("chupa-chupa"),
            keywords: &["chupa-chupa", "doce", "guloseima", "sobremesa"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("chupete"),
            keywords: &["chupete", "miski", "miskʼi", "postre"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("acadea"),
            keywords: &["acadea", "bomboană", "băț", "desert", "dulce"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-306"),
            keywords: &["E10-306"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("леденец"),
            keywords: &[
                "конфета",
                "конфета на палочке",
                "леденец",
                "леденец на палочке",
                "палочка",
                "сладкий",
                "сладость",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("bombo yo ku giti"),
            keywords: &["bombo", "bombo yo ku giti", "deseri", "iryoshye"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("چومپڙي"),
            keywords: &["چومپڙي", "کٽمٺو، مٺو، مٺائي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ලොල\u{dd2}පොප\u{dca}"),
            keywords: &[
                "අත\u{dd4}ර\u{dd4}පස",
                "පැණ\u{dd2} රස",
                "ලොල\u{dd2}පොප\u{dca}",
                "ස\u{dd6}ක\u{dd2}ර\u{dd2}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("lízanka"),
            keywords: &["dezert", "lízanka", "sladkosť"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("lizika"),
            keywords: &["lizika", "posladek", "sladkarija", "sladko"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("nacnac ul ballaaran"),
            keywords: &["macaan", "macmacaan", "nacnac", "nacnac ul ballaaran"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("lëpirëse"),
            keywords: &["e ëmbël", "karamele", "lëpirëse", "ëmbëlsirë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лизалица"),
            keywords: &["бoмбoна", "дeсeрт", "лизалица", "слaткo"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lizalica"),
            keywords: &["bombona", "desert", "lizalica", "slatko"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("klubba"),
            keywords: &["godis", "klubba"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("pipi"),
            keywords: &["kitindamlo", "pipi", "tamu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("குச\u{bcd}சிமிட\u{bcd}ட\u{bbe}ய\u{bcd}"),
            keywords: &[
                "இனிப\u{bcd}பு",
                "குச\u{bcd}சிமிட\u{bcd}ட\u{bbe}ய\u{bcd}",
                "மிட\u{bcd}ட\u{bbe}ய\u{bcd}",
                "ல\u{bbe}லிப\u{bbe}ப\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ల\u{c3e}ల\u{c40}ప\u{c3e}ప\u{c4d}"),
            keywords: &[
                "క\u{c4d}య\u{c3e}ండ\u{c40}",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
                "ల\u{c3e}ల\u{c40}ప\u{c3e}ప\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("оби дандон"),
            keywords: &["десерт", "конфет", "оби дандон", "ширин"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("อมย\u{e34}\u{e49}ม"),
            keywords: &["ขนม", "ของหวาน", "ล\u{e39}กอม", "อมย\u{e34}\u{e49}ม"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("horaz-süýji"),
            keywords: &["desert", "horaz-süýji", "kemput", "süýji"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("lolepopi"),
            keywords: &["lolepopi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("lolipop"),
            keywords: &["lolipop", "restoran", "şekerleme"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ساپاقلىق كەمپۈت"),
            keywords: &["تاتلىق", "ساپاقلىق كەمپۈت", "كەمپۈت", "پىشۇرۇق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("льодяник"),
            keywords: &["десерт", "льодяник", "солодкий", "цукерка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("لالی پاپ"),
            keywords: &["لالی پاپ", "میٹھی", "کینڈی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("obakidandon"),
            keywords: &["konfet", "obakidandon", "shirin", "shirinlik"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("kẹo mút"),
            keywords: &["kẹo", "kẹo mút", "món tráng miệng", "ngọt"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("tàngal bant"),
            keywords: &["deseer", "suukër", "tàngal", "tàngal bant"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-lollipop"),
            keywords: &["i-dessert", "i-lollipop", "ilekese"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Suuti Onigi"),
            keywords: &["Suuti Onigi", "káńdì", "àdídùn", "ónjẹ dídùn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("波板糖"),
            keywords: &["波板糖", "甜", "甜品", "糖果"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("波板糖"),
            keywords: &["波板糖", "甜", "甜品", "糖果"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("棒棒糖"),
            keywords: &["棒棒糖", "糖"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("棒棒糖"),
            keywords: &["棒棒糖", "糖果"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("波板糖"),
            keywords: &["波板糖"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ustikhiswidi"),
            keywords: &["okunoshukela", "ubumnandi", "ustikhiswidi", "uswidi"],
        },
    ],
};
#[doc = "🍮"]
pub const CUSTARD: crate::Emoji = crate::Emoji {
    glyph: "🍮",
    codepoint: "1F36E",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "custard",
    group: "Food & Drink",
    subgroup: "food-sweet",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vla"),
            keywords: &["kos", "nagereg", "poeding", "soet", "vla"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ካስታርድ ኬክ"),
            keywords: &["ካስታርድ ኬክ", "ጣፋጭ", "ጣፋጭ ምግብ", "ፑዲንግ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كريم كراميل"),
            keywords: &["كاسترد", "كريم كراميل", "مطعم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9be}ষ\u{9cd}ট\u{9be}ৰ\u{9cd}ড"),
            keywords: &[
                "ক\u{9be}ষ\u{9cd}ট\u{9be}ৰ\u{9cd}ড",
                "প\u{9c1}ডিং",
                "মিঠ\u{9be}",
                "মিঠ\u{9be}ই",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("bişirilmiş krem"),
            keywords: &["bişirilmiş krem", "desert", "pudinq", "şirin"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("карамельны пудынг"),
            keywords: &["дэсерт", "карамельны пудынг", "пудынг", "салодкі"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Яйчен крем"),
            keywords: &["Яйчен крем", "десерт", "крем", "сладък"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9be}স\u{9cd}ট\u{9be}র\u{9cd}ড"),
            keywords: &[
                "ক\u{9be}স\u{9cd}ট\u{9be}র\u{9cd}ড",
                "ডেজ\u{9be}র\u{9cd}ট",
                "প\u{9c1}ডিং",
                "মিষ\u{9cd}টি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("dienn war e cʼhenoù"),
            keywords: &["dibenn-pred", "dienn war e cʼhenoù", "koaven war e cʼhenoù"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("puding"),
            keywords: &["desert", "krema", "puding", "slatko"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("flam"),
            keywords: &["dolç", "flam", "natilles", "postres", "púding"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎨᎵᏍᏔᏅ"),
            keywords: &["ᎠᏑᏰᎥᎢ", "ᎤᎦᎾᏍᏓ", "ᎤᎦᎾᏍᏓ ᎠᎩᏍᏗ", "ᎨᎵᏍᏔᏅ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("pudink"),
            keywords: &[
                "dezert", "puding", "pudink", "sladkost", "sladký", "zákusek",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cwstard"),
            keywords: &["cwstard", "melys", "pwdin"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("dessert"),
            keywords: &["budding", "dessert"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Pudding"),
            keywords: &[
                "Dessert",
                "Nachspeise",
                "Nachtisch",
                "Pudding",
                "Schokolade",
                "Soße",
            ],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: None,
            keywords: &["Pudding"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κρέμα καραμελέ"),
            keywords: &["γλυκό", "επιδόρπιο", "κρέμα καραμελέ", "πουτίγκα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("custard"),
            keywords: &["custard", "dessert", "pudding", "sweet"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("egg custard"),
            keywords: &[
                "crème caramel",
                "custard",
                "dessert",
                "egg custard",
                "pudding",
                "sweet",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("baked custard"),
            keywords: &["baked custard", "dessert", "pudding", "sweet"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("flan"),
            keywords: &["dulce", "flan", "postre", "pudding"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("vanillipuding"),
            keywords: &["magus", "magustoit", "puding", "vanillipuding"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("natillak"),
            keywords: &["budin", "gozo", "natillak", "postre"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کاستارد"),
            keywords: &["دسر", "شیرین", "پودینگ", "کاستارد"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vanukas"),
            keywords: &["jälkiruoka", "makea", "vanukas"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pudding"),
            keywords: &[
                "custard",
                "dessert",
                "matamis",
                "pagkain",
                "panghimagas",
                "pudding",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("lagkøka"),
            keywords: &["budingur", "dessert", "krem", "lagkøka", "matur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("crème renversée"),
            keywords: &["crème renversée", "dessert", "pudding", "sucré"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("crème caramel"),
            keywords: &["crème caramel", "dessert", "pudding", "sucré"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("custard"),
            keywords: &["custard", "milseog"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ughagan"),
            keywords: &["milis", "milseag", "ughagan"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("flan"),
            keywords: &["doce", "flan", "pudin", "sobremesa"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કસ\u{acd}ટર\u{acd}ડ"),
            keywords: &[
                "કસ\u{acd}ટર\u{acd}ડ",
                "પ\u{ac1}ડિ\u{a82}ગ",
                "ર\u{ac7}સ\u{acd}ટોરન\u{acd}ટ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kwastad"),
            keywords: &["alawa mai zaƙi", "kayan zaƙi", "kwastad", "mai zaƙi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פודינג"),
            keywords: &["מתוק", "פודינג", "קינוח"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("कस\u{94d}टर\u{94d}ड"),
            keywords: &[
                "कस\u{94d}टर\u{94d}ड",
                "प\u{941}डि\u{902}ग",
                "र\u{947}स\u{94d}टोर\u{947}\u{902}ट",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("krema od jaja"),
            keywords: &["desert", "krema od jaja", "puding", "slatko"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("puding"),
            keywords: &["desszert", "puding", "édesség"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("պուդինգ"),
            keywords: &["աղանդեր", "պուդինգ", "քաղցր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("puding susu"),
            keywords: &["makanan", "manis", "penutup", "puding susu"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akamụ bèkee"),
            keywords: &["akamụ bèkee", "ihe nracha ọṅụṅụ", "àchịcha ụtọ", "ụtọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("búðingur"),
            keywords: &["búðingur", "veitingastaður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("budino"),
            keywords: &["budino", "pudding", "ristorante"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("プリン"),
            keywords: &["お菓子", "スイーツ", "デザート", "プリン"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ager-ager hungkwe"),
            keywords: &[
                "ager-ager hungkwe",
                "hungkwe",
                "legi",
                "panganan manis",
                "podeng",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კასტარდი"),
            keywords: &["დესერტი", "კასტარდი", "პუდინგი", "ტკბილეული", "ტკბილი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("кастард"),
            keywords: &["десерт", "кастард", "пудинг", "тәтті"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("dessert"),
            keywords: &["budding", "dessert"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ន\u{17c6}ផ\u{17d2}អែម"),
            keywords: &["ន\u{17c6}ផ\u{17d2}អែម", "បង\u{17d2}អែម", "ផ\u{17d2}អែម"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಸ\u{ccd}ಟರ\u{ccd}ಡ\u{ccd}"),
            keywords: &["ಕಸ\u{ccd}ಟರ\u{ccd}ಡ\u{ccd}", "ಪುಡ\u{ccd}ಡ\u{cbf}ಂಗ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("커스타드 푸딩"),
            keywords: &["디저트", "커스타드", "푸딩"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("कस\u{94d}टर\u{94d}ड"),
            keywords: &[
                "कस\u{94d}टर\u{94d}ड",
                "गोड",
                "ड\u{947}झर\u{94d}ट",
                "प\u{941}डी\u{902}ग",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кастард"),
            keywords: &["десерт", "кастард", "пудинг", "таттуу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Pudding"),
            keywords: &["Dessert", "Pudding", "séiss"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຄ\u{eb1}ສຕາດ"),
            keywords: &[
                "ຂອງຫວານ",
                "ຄ\u{eb1}ສຕາດ",
                "ພ\u{eb8}ດດ\u{eb4}\u{ec9}ງ",
                "ຫວານ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("saldus kremas"),
            keywords: &["desertas", "pudingas", "saldu", "saldus kremas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("olu krēms"),
            keywords: &["deserts", "olu krēms", "salds"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("katete"),
            keywords: &["katete", "puruni", "reka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("пудинг"),
            keywords: &["десерт", "пудинг", "слатко"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കസ\u{d4d}റ\u{d4d}റ\u{d3e}ർഡ\u{d4d}"),
            keywords: &[
                "കസ\u{d4d}റ\u{d4d}റ\u{d3e}ഡ\u{d4d}",
                "കസ\u{d4d}റ\u{d4d}റ\u{d3e}ർഡ\u{d4d}",
                "പ\u{d41}ഡ\u{d4d}ഡിംഗ\u{d4d}",
                "ഭക\u{d4d}ഷണം",
                "ഹോട\u{d4d}ടൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("кастард"),
            keywords: &["амттан", "кастард"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कस\u{94d}टर\u{94d}ड"),
            keywords: &["कस\u{94d}टर\u{94d}ड", "गोड", "प\u{941}डि\u{902}ग", "मिठाई"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kastard"),
            keywords: &["kastard", "manis", "pencuci mulut", "puding"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kastard"),
            keywords: &["deżerta", "kastard", "pudina", "ħelwa"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပ\u{1030}တင\u{103a}း"),
            keywords: &[
                "ပ\u{1030}တင\u{103a}း",
                "အချ\u{102d}\u{102f}",
                "အချ\u{102d}\u{102f}ပ\u{103d}\u{1032}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("pudding"),
            keywords: &["dessert", "karamellpudding", "pudding"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कस\u{94d}टर\u{94d}ड"),
            keywords: &["कस\u{94d}टर\u{94d}ड", "पडिङ\u{94d}", "मिठाई", "मिठो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vla"),
            keywords: &["dessert", "pudding", "vla", "zoet"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("pudding"),
            keywords: &["dessert", "karamellpudding", "pudding"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କଷ\u{b4d}ଟ\u{b3e}ର\u{b4d}ଡ\u{b4d}"),
            keywords: &[
                "କଷ\u{b4d}ଟ\u{b3e}ର\u{b4d}ଡ",
                "କଷ\u{b4d}ଟ\u{b3e}ର\u{b4d}ଡ\u{b4d}",
                "ପ\u{b41}ଡ\u{b3f}ଂ",
                "ରେଷ\u{b4d}ଟ\u{b41}ର\u{b3e}ଣ\u{b4d}ଟ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਸਟਰਡ"),
            keywords: &["ਕਸਟਰਡ", "ਪ\u{a41}ਡਿ\u{a70}ਗ", "ਹ\u{a4b}ਟਲ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کسٹرڈ"),
            keywords: &["بڈنگ", "میٹھائی", "میٹھی شے", "کسٹرڈ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kọ\u{301}stád"),
            keywords: &["Dẹzat", "Kọ\u{301}stád", "Púdin", "Swit"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("deser typu krem angielski"),
            keywords: &["ciastko kremowe", "deser typu krem angielski", "krem"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("فرني"),
            keywords: &["فرني", "فرني، خواږه، شيريرنج، خوږ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pudim"),
            keywords: &["pudim", "pudim de leite", "pudim de ovos"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("pudim"),
            keywords: &["doce", "pudim", "sobremesa"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("raqʼa"),
            keywords: &["miski", "postre", "pudin", "raqʼa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("șarlotă"),
            keywords: &["budincă", "desert", "dulce", "șarlotă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-307"),
            keywords: &["E10-307"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("пудинг"),
            keywords: &["десерт", "пудинг", "сладкий"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("kereme"),
            keywords: &["deseri", "iryoshye", "kereme", "ubwoko bwa deseri"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪسٽرڊ"),
            keywords: &["مٺو، کير، مٺائي", "ڪسٽرڊ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කස\u{dca}ට\u{dcf}ර\u{dca}ඩ\u{dca}"),
            keywords: &[
                "අත\u{dd4}ර\u{dd4}පස",
                "කස\u{dca}ට\u{dcf}ර\u{dca}ඩ\u{dca}",
                "පැණ\u{dd2} රස",
                "ප\u{dd4}ඩ\u{dd2}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("puding"),
            keywords: &["dezert", "puding", "sladkosť"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vanilijev puding"),
            keywords: &["posladek", "puding", "sladko", "vanilijev puding"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("labaniyad"),
            keywords: &["dubista", "labaniyad", "macaan", "macmacaan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("krem-karamel"),
            keywords: &["e ëmbël", "krem-karamel", "puding", "ëmbëlsirë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кремпита"),
            keywords: &["дeсeрт", "кремпита", "пудинг", "слaткo"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("krempita"),
            keywords: &["desert", "krempita", "puding", "slatko"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("brylépudding"),
            keywords: &["brylépudding", "efterrätt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("faluda"),
            keywords: &["faluda", "kitindamlo", "pudini", "tamu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கஸ\u{bcd}டர\u{bcd}டு"),
            keywords: &["இனிப\u{bcd}பு", "உணவகம\u{bcd}", "கஸ\u{bcd}டர\u{bcd}டு"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కస\u{c4d}టర\u{c4d}డ\u{c4d}"),
            keywords: &[
                "కస\u{c4d}టర\u{c4d}డ\u{c4d}",
                "క\u{c4b}డ\u{c3f} గుడ\u{c4d}లు",
                "ప\u{c3e}లు చక\u{c4d}క\u{c46}ర కల\u{c3f}ప\u{c3f} చ\u{c47}స\u{c3f}న మ\u{c3f}ఠ\u{c3e}య\u{c3f}",
                "ప\u{c3f}ండ\u{c3f}వంట",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("крем"),
            keywords: &["десерт", "крем", "пудинг", "ширин"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ค\u{e31}สตาร\u{e4c}ด"),
            keywords: &["ค\u{e31}สตาร\u{e4c}ด", "พ\u{e38}ดด\u{e34}\u{e49}ง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("süýji krem"),
            keywords: &["desert", "puding", "süýji", "süýji krem"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kasitati"),
            keywords: &["kasitati"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("krem karamel"),
            keywords: &["krem karamel", "puding", "restoran"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قايماق ئۇيۇتمىسى"),
            keywords: &["ئۇيۇتما", "تاتلىق", "قايماق ئۇيۇتمىسى", "پىشۇرۇق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("заварний крем"),
            keywords: &["десерт", "заварний крем", "пудинг", "солодкий"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کسٹرڈ"),
            keywords: &["میٹھا", "کسٹرڈ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("krem"),
            keywords: &["krem", "puding", "shirin", "shirinlik"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bánh trứng"),
            keywords: &["bánh", "bánh trứng", "món tráng miệng", "ngọt"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kreem"),
            keywords: &["deseer", "kreem", "pudiŋ", "suukër"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ikhastadi"),
            keywords: &["i-dessert", "i-pudding", "ikhastadi", "ilekese"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Kọ\u{301}sítàdì"),
            keywords: &["Kọ\u{301}sítàdì", "púdínì", "àdídùn", "ónjẹ dídùn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("布甸"),
            keywords: &["布甸", "甜", "甜品"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("布甸"),
            keywords: &["布甸", "甜", "甜品"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("奶黄"),
            keywords: &["奶黄", "蛋奶冻", "蛋奶沙司"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("卡士達"),
            keywords: &["卡士達", "布丁", "甜點"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("吉士"),
            keywords: &[
                "吉士",
                "布甸",
                "焦糖布甸",
                "甜品",
                "甜食",
                "甜點",
                "雞蛋布甸",
            ],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukhastadi"),
            keywords: &["iphudingi", "okunoshukela", "ubumnandi", "ukhastadi"],
        },
    ],
};
#[doc = "🍯"]
pub const HONEY_POT: crate::Emoji = crate::Emoji {
    glyph: "🍯",
    codepoint: "1F36F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "honey pot",
    group: "Food & Drink",
    subgroup: "food-sweet",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("heuningpot"),
            keywords: &["heuning", "heuningpot", "pot", "soet"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የማር ማሰሮ"),
            keywords: &["ማር", "ማሰሮ", "የማር ማሰሮ", "ጣፋጭ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("جرة عسل"),
            keywords: &["جرة", "عسل", "مطعم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মৌ ব\u{9be}তি"),
            keywords: &["ব\u{9be}তি", "মিঠ\u{9be}", "মৌ", "মৌৰ ব\u{9be}তি"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("bal qabı"),
            keywords: &["bal", "bal qabı", "qab", "şirin"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("гаршчок мёду"),
            keywords: &["гаршчок", "гаршчок мёду", "мёд", "салодкі"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Гърне с мед"),
            keywords: &["Гърне с мед", "гърне", "мед", "сладък"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মধ\u{9c1}র প\u{9be}ত\u{9cd}র"),
            keywords: &[
                "প\u{9be}ত\u{9cd}র",
                "মধ\u{9c1}",
                "মধ\u{9c1}র প\u{9be}ত\u{9cd}র",
                "মিষ\u{9cd}টি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("podad mel"),
            keywords: &["mel", "pod", "podad mel"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("tegla meda"),
            keywords: &["med", "slatko", "tegla", "tegla meda"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pot de mel"),
            keywords: &["mel", "pot", "pot de mel"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄟\u{11127}𑄙\u{1112a} 𑄛\u{11127}𑄖\u{11134}"),
            keywords: &["𑄟\u{11127}𑄙\u{1112a} 𑄛\u{11127}𑄖\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏩᏚᎵᏏ ᎠᏟᏍᏙᏗ"),
            keywords: &["ᎠᏟᏍᏙᏗ", "ᎤᎦᎾᏍᏓ", "ᏩᏚᎵᏏ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("sklenice medu"),
            keywords: &["med", "sklenice", "sklenice medu", "sladkost", "sladký"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("pot mêl"),
            keywords: &["melys", "mêl", "pot mêl"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("honning"),
            keywords: &["honning", "honningkrukke", "krukke honning"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Honigtopf"),
            keywords: &["Honig", "Honigtopf"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("βάζο με μέλι"),
            keywords: &["βάζο", "βάζο με μέλι", "γλυκό", "μέλι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("honey pot"),
            keywords: &["honey", "honeypot", "pot", "sweet"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("tarro de miel"),
            keywords: &["dulce", "miel", "tarro", "tarro de miel"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["dulce", "miel", "pote", "tarro", "tarro de miel"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("meepott"),
            keywords: &["magus", "meepott", "mesi"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ezti-potoa"),
            keywords: &["ezti", "ezti-potoa", "gozo", "poto"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ظرف عسل"),
            keywords: &["انگبین", "شیرین", "ظرف", "عسل", "عسلی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hunaja"),
            keywords: &["hunaja", "makea"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pulot-pukyutan"),
            keywords: &["honey", "matamis", "pagkain", "pulot-pukyutan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hunangur"),
            keywords: &["hunangur", "matur", "søtt"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("pot de miel"),
            keywords: &["miel", "pot", "pot de miel", "sucré"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("pota meala"),
            keywords: &["mil", "pota meala", "próca meala"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("poit meala"),
            keywords: &["mil", "milis", "poit", "poit meala"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("tarro de mel"),
            keywords: &["bote", "doce", "mel", "tarro de mel"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મધન\u{ac1}\u{a82} વાસણ"),
            keywords: &[
                "મધ",
                "મધન\u{ac1}\u{a82} વાસણ",
                "ર\u{ac7}સ\u{acd}ટોરન\u{acd}ટ",
                "વાસણ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("tukunyan zuma"),
            keywords: &["mai zaƙi", "tukunya", "tukunyan zuma", "zuma"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("צנצנת דבש"),
            keywords: &["דבש", "כד דבש", "מתוק", "צנצנת דבש"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("शहद पात\u{94d}र"),
            keywords: &[
                "र\u{947}स\u{94d}टोर\u{947}\u{902}ट",
                "शहद",
                "शहद पात\u{94d}र",
                "हनीपॉट",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tegla meda"),
            keywords: &["med", "slatko", "tegla", "tegla meda"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("mézes csupor"),
            keywords: &["bödön", "csupor", "méz", "mézes bödön", "mézes csupor"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մեղրի կճուճ"),
            keywords: &["կճուճ", "մեղր", "մեղրի կճուճ", "քաղցր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("toples madu"),
            keywords: &["kendi", "madu", "manis", "toples madu"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ite mmanụ aṅụ"),
            keywords: &["ite", "ite mmanụ aṅụ", "itemmanụaṅụ", "mmanụaṅụ", "ụtọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hunang"),
            keywords: &["hunang", "hunangskrukka", "veitingastaður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("barattolo di miele"),
            keywords: &[
                "barattolo di miele",
                "miele",
                "ristorante",
                "vaso",
                "vaso di miele",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("はちみつ"),
            keywords: &["はちみつ", "ハニー", "甘い"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("satoples madu"),
            keywords: &["legi", "madu", "satoples madu", "toples"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("თაფლის ქილა"),
            keywords: &["თაფლი", "თაფლის ქილა", "ტკბილეული", "ტკბილი", "ქილა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бал құтысы"),
            keywords: &["бал", "бал құтысы", "тәтті", "құты"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("honning"),
            keywords: &["honning", "honningkrukke", "krukke honning"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ក\u{17d2}រឡទ\u{17b9}កឃ\u{17d2}ម\u{17bb}\u{17c6}"),
            keywords: &[
                "ក\u{17d2}រឡ",
                "ក\u{17d2}រឡទ\u{17b9}កឃ\u{17d2}ម\u{17bb}\u{17c6}",
                "ទ\u{17b9}កឃ\u{17d2}ម\u{17bb}\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಜೇನುತುಪ\u{ccd}ಪದ ಮಡ\u{cbf}ಕ\u{cc6}"),
            keywords: &[
                "ಜೇನುತುಪ\u{ccd}ಪ",
                "ಜೇನುತುಪ\u{ccd}ಪದ ಮಡ\u{cbf}ಕ\u{cc6}",
                "ಹನ\u{cbf}ಪಾಟ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("꿀"),
            keywords: &["꿀", "꿀단지"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("म\u{94d}हो\u{902}वाच\u{947}\u{902} आयदन"),
            keywords: &[
                "आयदन",
                "गोड",
                "म\u{94d}हो\u{902}व",
                "म\u{94d}हो\u{902}वाच\u{947}\u{902} आयदन",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бал челек"),
            keywords: &["бал", "бал челек", "таттуу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Hunneg"),
            keywords: &["Glas", "Hunneg", "Hunnegglas", "séiss"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໂຖນ\u{ecd}\u{ec9}າເຜ\u{eb4}\u{ec9}ງ"),
            keywords: &[
                "ນ\u{ecd}\u{ec9}າເຜ\u{eb5}\u{ec9}ງ",
                "ໂຖນ\u{ecd}\u{ec9}າເຜ\u{eb4}\u{ec9}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("medaus puodynė"),
            keywords: &["medaus puodynė", "medus", "puodas", "saldu"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("medus pods"),
            keywords: &["medus", "pods", "salds"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("paepae honi"),
            keywords: &["honi", "kōhua", "paepae honi", "reka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("грне со мед"),
            keywords: &["грне", "грне со мед", "мед", "слатко"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("തേൻപ\u{d3e}ത\u{d4d}രം"),
            keywords: &[
                "തേൻ",
                "തേൻപ\u{d3e}ത\u{d4d}രം",
                "ഭക\u{d4d}ഷണം",
                "ഹണി",
                "ഹണി പോട\u{d4d}ട\u{d4d}",
                "ഹോട\u{d4d}ടൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зөгийн балны сав"),
            keywords: &["бал", "зөгийн балны сав", "сав", "чихэрлэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मधाच\u{947} भा\u{902}ड\u{947}"),
            keywords: &[
                "गोड",
                "भा\u{902}ड\u{947}",
                "मध",
                "मधाच\u{947} भा\u{902}ड\u{947}",
                "मधाच\u{947}भा\u{902}ड\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("periuk madu"),
            keywords: &["madu", "manis", "periuk"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("vażett għasel"),
            keywords: &["għasel", "vażett", "vażett tal-għasel", "ħelu"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပျားရည\u{103a}အ\u{102d}\u{102f}း"),
            keywords: &[
                "ပျားရည\u{103a}",
                "ပျားရည\u{103a}အ\u{102d}\u{102f}း",
                "အချ\u{102d}\u{102f}",
                "အ\u{102d}\u{102f}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("honningkrukke"),
            keywords: &["honningkrukke", "krukke"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("महको भा\u{901}डो"),
            keywords: &["भा\u{901}डो", "मह", "महको भा\u{901}डो", "मिठो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("honingpot"),
            keywords: &["honing", "honingpot", "pot", "zoet"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("honningkrukke"),
            keywords: &["honningkrukke", "krukke"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମହ\u{b41} ପ\u{b3e}ତ\u{b4d}ର"),
            keywords: &[
                "ପ\u{b3e}ତ\u{b4d}ର",
                "ମହ\u{b41}",
                "ରେଷ\u{b4d}ଟ\u{b41}ର\u{b3e}ଣ\u{b4d}ଟ\u{b4d}",
                "ହନ\u{b3f}ପଟ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a3c}ਹਿਦ ਦਾ ਬਰਤਨ"),
            keywords: &["ਬਰਤਨ", "ਸ\u{a3c}ਹਿਦ", "ਸ\u{a3c}ਹਿਦ ਦਾ ਬਰਤਨ", "ਹ\u{a4b}ਟਲ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("شہد دی ہانڈی"),
            keywords: &["شہد", "شہد دا پانڈا", "شہد دی ہانڈی", "میٹھائی", "ہانڈی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Họ\u{301}ni Pọt"),
            keywords: &["Họ\u{301}ni", "Họ\u{301}nipọt", "Pọt", "Swit"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("garnek miodu"),
            keywords: &["beczka z miodem", "garnek miodu", "słoik miodu"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د شاتو لوښی"),
            keywords: &["د شاتو لوښی", "شات، د شاتو لوښی، لوښی، خوږ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pote de mel"),
            keywords: &["mel", "pote", "pote de mel"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["doce", "mel", "pote", "pote de mel"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("miskʼi manka"),
            keywords: &["manka", "miski", "miskʼi manka", "misk’i"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("borcan cu miere"),
            keywords: &["borcan", "borcan cu miere", "dulce", "miere"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-308"),
            keywords: &["E10-308"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мед"),
            keywords: &["бочонок", "бочонок меда", "горшок", "горшок с медом", "мед"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikibindi cy’ubuki"),
            keywords: &[
                "ikibindi cy’ubuki",
                "inkono",
                "inkono y’ubuki",
                "iryoshye",
                "ubuki",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ماکي جو برتن"),
            keywords: &["ماکي جو برتن", "ماکي، ماکي جو برتن، برتن، مٺائي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හන\u{dd3} පොට\u{dca}"),
            keywords: &[
                "පැණ\u{dd2}",
                "පැණ\u{dd2} රස",
                "පොට\u{dca}",
                "හන\u{dd3} පොට\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("pohár medu"),
            keywords: &["med", "pohár", "pohár medu", "sladkosť"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vrč medu"),
            keywords: &["kozarec za med", "lonček", "med", "sladko", "vrč medu"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("digsi malab"),
            keywords: &["digsi", "macaan", "malab"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("vazo me mjaltë"),
            keywords: &["e ëmbël", "i ëmbël", "kupë", "mjaltë", "vazo me mjaltë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("ћуп са медом"),
            keywords: &["мeд", "слaткo", "ћуп", "ћуп са медом"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ćup sa medom"),
            keywords: &["med", "slatko", "ćup", "ćup sa medom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("honungsburk"),
            keywords: &["burk", "honung", "honungsburk"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("chungu cha asali"),
            keywords: &["asali", "chungu cha asali", "jungu", "tamu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("தேன\u{bcd} ப\u{bbe}னை"),
            keywords: &[
                "இனிப\u{bcd}பு",
                "உணவகம\u{bcd}",
                "தேன\u{bcd} ப\u{bbe}னை",
                "ஹனிப\u{bbe}ட\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("త\u{c47}న\u{c46} కుండ"),
            keywords: &[
                "కుండ",
                "త\u{c47}న\u{c46}",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("кӯзаи асал"),
            keywords: &["асал", "дег", "кӯзаи асал", "ширин"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("โถน\u{e49}ำผ\u{e36}\u{e49}ง"),
            keywords: &["น\u{e49}ำผ\u{e36}\u{e49}ง", "โถน\u{e49}ำผ\u{e36}\u{e49}ง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("bally golça"),
            keywords: &["bal", "bally golça", "golça", "süýji"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kulo hone"),
            keywords: &["kulo hone"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("bal kabı"),
            keywords: &["bal", "bal kabı", "kap", "restoran"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ھەسەل قاچىسى"),
            keywords: &["تاتلىق", "قاچا", "ھەسەل", "ھەسەل قاچىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("горщик із медом"),
            keywords: &["горщик", "горщик із медом", "мед", "солодкий"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("شہد کا برتن"),
            keywords: &["برتن", "شہد", "شہد کا برتن", "میٹھا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("asal idishi"),
            keywords: &["asal", "asal bochkasi", "asal idishi", "bochka", "shirin"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hũ mật ong"),
            keywords: &["hũ", "hũ mật ong", "mật ong", "ngọt"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("potu lem"),
            keywords: &["lem", "pot", "potu lem", "suukër"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("imbiza yobusi"),
            keywords: &["ilekese", "imbiza", "imbiza yobusi", "ubusi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Koko Oyin"),
            keywords: &["Koko Oyin", "oyin", "àdídùn", "ìkòkò"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("蜜糖罐"),
            keywords: &["甜", "罐", "蜜糖", "蜜糖罐"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("蜜糖罐"),
            keywords: &["甜", "罐", "蜜糖", "蜜糖罐"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("蜂蜜"),
            keywords: &["蜂蜜", "蜜罐"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("蜂蜜"),
            keywords: &["甜點", "蜂蜜"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("蜂蜜壺"),
            keywords: &["糖罐", "蜂蜜", "蜂蜜壺", "蜜糖罐"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isitsha soju"),
            keywords: &["isitsha", "isitsha soju", "ubumnandi", "uju"],
        },
    ],
};
