#[doc = "🍞"]
pub const BREAD: crate::Emoji = crate::Emoji {
    glyph: "🍞",
    codepoint: "1F35E",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "bread",
    group: "Food & Drink",
    subgroup: "food-prepared",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("brood"),
            keywords: &["brood", "sny"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ዳቦ"),
            keywords: &["የዳቦ ቁራሽ", "ዳቦ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("خبز"),
            keywords: &["خبز", "رغيف عيش", "مطعم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9be}উৰ\u{9c1}টী"),
            keywords: &["প\u{9be}উৰ\u{9c1}টী", "লোফ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("çörək"),
            keywords: &["bulka", "çörək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("хлеб"),
            keywords: &["бохан", "хлеб"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("хляб"),
            keywords: &["хляб"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9be}উর\u{9c1}টি"),
            keywords: &["প\u{9be}\u{981}র\u{9c1}টি", "প\u{9be}উর\u{9c1}টি"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bara"),
            keywords: &["bara", "choanenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("hljeb"),
            keywords: &["hljeb", "štruca"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pa"),
            keywords: &["llesca", "pa"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄢\u{1112a}𑄖\u{11128}"),
            keywords: &["𑄢\u{1112a}𑄖\u{11128}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏚ"),
            keywords: &["ᎦᏚ", "ᎦᏚᏅ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("chleba"),
            keywords: &["bochník", "chleba", "chléb", "pecen"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bara"),
            keywords: &["bara", "torth"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("brød"),
            keywords: &["bage", "brød"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Brot"),
            keywords: &["Brot", "Brotlaib", "Laib Brot"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ψωμί"),
            keywords: &["φρατζόλα", "ψωμί"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("bread"),
            keywords: &["bread", "loaf"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pan de molde"),
            keywords: &["pan", "pan de molde", "rebanada", "tostada"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("pan"),
            keywords: &["comida", "pan", "rodaja"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["barra de pan", "comida", "pan"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("leib"),
            keywords: &["leib", "päts"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ogi"),
            keywords: &["ogi", "xerra"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نان"),
            keywords: &["تکه", "قرص", "لقمه", "نان"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("leipä"),
            keywords: &["leipä", "pala"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tinapay"),
            keywords: &["pagkain", "tinapay"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("breyð"),
            keywords: &["breyð", "matur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("pain"),
            keywords: &["miche", "pain"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["baguette", "pain"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("arán"),
            keywords: &["arán", "builín aráin"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aran"),
            keywords: &["aran", "buileann", "lofa"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("pan de molde"),
            keywords: &["pan", "pan de molde"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બ\u{acd}ર\u{ac7}ડ"),
            keywords: &[
                "બ\u{acd}ર\u{ac7}ડ",
                "બ\u{acd}ર\u{ac7}ડનો રોટલો",
                "ર\u{ac7}સ\u{acd}ટોરન\u{acd}ટ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("burodi"),
            keywords: &["burodi", "burodi mai yanke-yanke"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחם"),
            keywords: &["כיכר", "לחם"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ब\u{94d}र\u{947}ड"),
            keywords: &[
                "ब\u{94d}र\u{947}ड",
                "ब\u{94d}र\u{947}ड लोफ\u{93c}",
                "र\u{947}स\u{94d}टोर\u{947}\u{902}ट",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kruh"),
            keywords: &["kruh", "štruca"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kenyér"),
            keywords: &["kenyér", "vekni"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("հաց"),
            keywords: &["բոքոն", "հաց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("roti"),
            keywords: &["roti"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("achịcha nkịtị"),
            keywords: &["achịcha", "achịcha nkịtị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("brauð"),
            keywords: &["brauð", "brauðhleifur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pane in cassetta"),
            keywords: &["pancarré", "pane in cassetta"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("食パン"),
            keywords: &["パン", "ベーカリー", "食パン"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("roti"),
            keywords: &["roti", "sebata"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("პური"),
            keywords: &["კვერი", "პური"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("нан"),
            keywords: &["бөлке", "нан"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("brød"),
            keywords: &["bage", "brød"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ន\u{17bb}\u{17c6}ប\u{17c9}\u{17d0}ងប\u{17bd}នជ\u{17d2}រ\u{17bb}ង"),
            keywords: &[
                "ដ\u{17bb}\u{17c6}ន\u{17bb}\u{17c6}",
                "ន\u{17bb}\u{17c6}ប\u{17c9}\u{17d0}ងប\u{17bd}នជ\u{17d2}រ\u{17bb}ង",
                "ន\u{17c6}ប\u{17c9}\u{17d0}ង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{ccd}ರ\u{cc6}ಡ\u{ccd}"),
            keywords: &[
                "ಬ\u{ccd}ರ\u{cc6}ಡ\u{ccd}",
                "ಬ\u{ccd}ರ\u{cc6}ಡ\u{ccd} ತುಂಡುಗಳು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("빵"),
            keywords: &["빵", "식빵"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पाव"),
            keywords: &["पाव", "लोळी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("нан"),
            keywords: &["кесим", "нан"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Brout"),
            keywords: &["Brout"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຂ\u{ebb}\u{ec9}າໜ\u{ebb}ມປ\u{eb1}ງ"),
            keywords: &[
                "ເຂ\u{ebb}\u{ec9}າຈ\u{eb5}\u{ec8}",
                "ເຂ\u{ebb}\u{ec9}າຈ\u{eb5}\u{ec8}ແຜ\u{ec8}ນ",
                "ເຂ\u{ebb}\u{ec9}າໜ\u{ebb}ມປ\u{eb1}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("duona"),
            keywords: &["duona", "kepalas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("maize"),
            keywords: &["kukulis", "maize"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("parāoa"),
            keywords: &["parāoa", "rohi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("леб"),
            keywords: &["векна", "жито", "леб"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ബ\u{d4d}രെഡ\u{d4d}"),
            keywords: &["ബ\u{d4d}രെഡ\u{d4d}", "ഭക\u{d4d}ഷണം", "ഹോട\u{d4d}ടൽ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("талх"),
            keywords: &["талх", "хүнс"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ब\u{94d}र\u{947}ड"),
            keywords: &[
                "ब\u{94d}र\u{947}ड",
                "ब\u{94d}र\u{947}डचा त\u{941}कडा",
                "वडी",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("roti"),
            keywords: &["roti", "sebuku"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ħobż"),
            keywords: &["ħobż", "ħobża"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပေါင\u{103a}မ\u{102f}န\u{1037}\u{103a}"),
            keywords: &[
                "ပေါင\u{103a}မ\u{102f}န\u{1037}\u{103a}",
                "ပေါင\u{103a}မ\u{102f}န\u{1037}\u{103a}တ\u{102f}\u{1036}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("brød"),
            keywords: &["brød", "loff"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("रोटी"),
            keywords: &["रोटी", "रोटीको ट\u{941}क\u{94d}रा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("brood"),
            keywords: &["brood"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("brød"),
            keywords: &["brød", "loff"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b3e}ଉ\u{b01}ର\u{b41}ଟ\u{b3f}"),
            keywords: &[
                "ତ\u{b41}କ\u{b41}ଡ\u{b3c}\u{b3e}",
                "ପ\u{b3e}ଉ\u{b01}ର\u{b41}ଟ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a4d}ਰ\u{a48}\u{a71}ਡ"),
            keywords: &[
                "ਨਾਨ",
                "ਬ\u{a4d}ਰ\u{a48}\u{a71}ਡ",
                "ਰ\u{a4b}ਟੀ",
                "ਹ\u{a4b}ਟਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("روٹی"),
            keywords: &["روٹی", "نان"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Brẹd"),
            keywords: &["Brẹd", "Lof"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("chleb"),
            keywords: &["bochenek", "chleb", "kawałek chleba", "pieczywo"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ډوډۍ"),
            keywords: &["ډوډۍ", "ډوډۍ، ټکړه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pão"),
            keywords: &["pão", "pão de forma"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["pão", "pão de forma"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tʼanta"),
            keywords: &["pan", "tʼanta"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pâine"),
            keywords: &["aliment", "franzelă", "pâine"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-291"),
            keywords: &["E10-291"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("хлеб"),
            keywords: &["батон", "буханка", "хлеб"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugati"),
            keywords: &["igice cy’umugati", "umugati"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("روٽي"),
            keywords: &["روٽي", "ماني"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dcf}න\u{dca}"),
            keywords: &["ප\u{dcf}න\u{dca}", "ර\u{dcf}ත\u{dca}තල"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("chlieb"),
            keywords: &["bochník", "chlieb", "peceň"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kruh"),
            keywords: &["kruh", "štruca"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("rooti"),
            keywords: &["gabal", "rooti"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("bukë"),
            keywords: &["bukë", "copë", "çyrek"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("хлеб"),
            keywords: &["векна", "хлеб"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("хљеб"),
            keywords: &["хљеб"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("hleb"),
            keywords: &["hleb", "vekna"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("hljeb"),
            keywords: &["hljeb"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("bröd"),
            keywords: &["bröd", "limpa"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mkate"),
            keywords: &["mkate"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பிரெட\u{bcd}"),
            keywords: &["உணவகம\u{bcd}", "உணவு", "பிரெட\u{bcd}", "ரொட\u{bcd}டி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బ\u{c4d}ర\u{c46}డ\u{c4d}డు"),
            keywords: &[
                "బ\u{c4d}ర\u{c46}డ\u{c4d}డు",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
                "ర\u{c4a}ట\u{c4d}ట\u{c46} ముక\u{c4d}క",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("нон"),
            keywords: &["буханка", "нон"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ขนมป\u{e31}ง"),
            keywords: &["ก\u{e49}อนขนมป\u{e31}ง", "ขนมป\u{e31}ง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çörek"),
            keywords: &["buhanka", "çörek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mā"),
            keywords: &["mā"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ekmek"),
            keywords: &["ekmek", "ekmek dilimi", "restoran"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("نان"),
            keywords: &["نان", "پارچە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("хліб"),
            keywords: &["паляниця", "хліб", "хлібина"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ڈبل روٹی"),
            keywords: &["بریڈ", "روٹی", "نان", "ڈبل روٹی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("non"),
            keywords: &["bulka non", "non"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bánh mì"),
            keywords: &["bánh mì", "ổ bánh mì"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("mburu"),
            keywords: &["mburu", "peŋ"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isonka"),
            keywords: &["ilofu", "isonka"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Búrẹ\u{301}dì"),
            keywords: &["Búrẹ\u{301}dì", "búrẹ\u{301}dì gígé"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("麵包"),
            keywords: &["麵包"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("面包"),
            keywords: &["面包"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("面包"),
            keywords: &["面包"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("吐司"),
            keywords: &["吐司", "麵包"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("麵包"),
            keywords: &["多士麵包", "麵包"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ulofu"),
            keywords: &["isinkwa", "ulofu"],
        },
    ],
};
#[doc = "🥐"]
pub const CROISSANT: crate::Emoji = crate::Emoji {
    glyph: "🥐",
    codepoint: "1F950",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "croissant",
    group: "Food & Drink",
    subgroup: "food-prepared",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("croissant"),
            keywords: &["brood", "croissant", "frankryk", "kos"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ክሬሰንት"),
            keywords: &["ምግብ", "ክሬሰንት", "ክሬሰንት ሙልሙል", "የፈረንሳይ", "ዳቦ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كرواسون"),
            keywords: &["خبز", "خبز فرنسي", "خبز هلالي الشكل", "كرواسون"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9cd}ৰইচেণ\u{9cd}ট"),
            keywords: &[
                "ক\u{9cd}ৰইচেণ\u{9cd}ট",
                "ক\u{9cd}ৰিচেণ\u{9cd}ট",
                "খ\u{9be}দ\u{9cd}য",
                "প\u{9be}ওৰ\u{9c1}টী",
                "ফ\u{9cd}ৰেন\u{9cd}স",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kruasan"),
            keywords: &["kruasan", "kökə", "qəlyanaltı", "çay"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("круасан"),
            keywords: &["ежа", "круасан", "рагалік", "французскі", "хлеб"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("кроасан"),
            keywords: &["кроасан", "френско", "хляб", "храна"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9cd}রোসিয\u{9bc}\u{9be}ন\u{9cd}ট"),
            keywords: &[
                "ক\u{9cd}রিসেন\u{9cd}ট রোল",
                "ক\u{9cd}রোসিয\u{9bc}\u{9be}ন\u{9cd}ট",
                "ক\u{9cd}রোসেন\u{9cd}ট",
                "প\u{9be}উর\u{9c1}টি",
                "ফর\u{9be}সি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kornegenn"),
            keywords: &["bara", "kornegenn", "viennerezh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kroasan"),
            keywords: &["doručak", "francusko", "hljeb", "hrana", "kifla", "kroasan"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("croissant"),
            keywords: &["brioixeria", "croissant", "menjar"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᎸᏥ ᎦᏚ"),
            keywords: &["ᎠᎵᏍᏓᏴᏗ", "ᎦᎸᏥ", "ᎦᏐᏆᎳ ᎦᏚ", "ᎦᏚ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("croissant"),
            keywords: &[
                "croissant",
                "francouzské",
                "jídlo",
                "loupák",
                "loupáček",
                "pečivo",
                "rohlík",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("croissant"),
            keywords: &[
                "bara",
                "brecwast",
                "bwyd",
                "croissant",
                "ffrengig",
                "rhôl cilgant",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("croissant"),
            keywords: &[
                "brød",
                "croissant",
                "fransk",
                "mad",
                "morgenbrød",
                "morgenmad",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Croissant"),
            keywords: &[
                "Croissant",
                "Frühstück",
                "Frühstückshörnchen",
                "französisch",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κρουασάν"),
            keywords: &["γαλλικός", "κρουασάν", "τροφή", "ψωμί"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("croissant"),
            keywords: &["bread", "breakfast", "croissant", "food", "french", "roll"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["French", "bread", "crescent roll", "croissant", "food"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cruasán"),
            keywords: &["bollo", "comida", "croissant", "cruasán", "francés"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("croissant"),
            keywords: &["comida", "croissant", "francés", "medialuna"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["comida", "croissant", "cuernito", "medialuna", "pan"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cuernito"),
            keywords: &[
                "comida",
                "croissant",
                "cuernito",
                "desayuno",
                "francés",
                "pan",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("sarvesai"),
            keywords: &["croissant", "prantsuse", "sai", "sarvesai", "toit"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("croissanta"),
            keywords: &["Frantzia", "croissant", "croissanta", "janari", "opil"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کرواسان"),
            keywords: &["نان", "نون", "پیراشکی", "کرواسان", "کروسان"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("voisarvi"),
            keywords: &["croissant", "leipä", "ranskalainen", "ruoka", "voisarvi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("croissant"),
            keywords: &["croissant", "french", "pagkain", "tinapay"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("horn"),
            keywords: &["croissant", "franskbreyðshorn", "horn", "matur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("croissant"),
            keywords: &["croissant", "pain", "viennoiserie"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("croissant"),
            keywords: &["Francach", "arán", "bia", "croissant", "rollóg chorránach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("croissant"),
            keywords: &["aran", "biadh", "croissant", "frangach", "rola corranach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("croissant"),
            keywords: &["almorzo", "bolo", "comida", "croissant"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ક\u{acd}રોઇસ\u{ac8}ન"),
            keywords: &[
                "ક\u{acd}રોઇસ\u{ac8}ન",
                "ફ\u{acd}ર\u{ac7}ન\u{acd}ચ",
                "ભોજન",
                "રોટલી",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("croissant"),
            keywords: &[
                "abinci",
                "abincin crescent roll",
                "burodi",
                "croissant",
                "na faransa",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קרואסון"),
            keywords: &["מאפה", "צרפתי", "קרואסון"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("क\u{94d}रोइस\u{948}न"),
            keywords: &[
                "crescent रोल",
                "क\u{94d}रोइस\u{948}न",
                "खाना",
                "फ\u{94d}र\u{947}\u{902}च",
                "रोटी",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kroasan"),
            keywords: &["francuska", "hrana", "kroasan", "kruh"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("croissant"),
            keywords: &["croissant", "francia", "reggeli", "étel"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կրուասան"),
            keywords: &["խմորեղեն", "կրուասան", "հաց", "ուտելիք", "ֆրանսիական"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("croissant"),
            keywords: &["croissant", "roti", "roti prancis"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("achịcha akpụrụ akpụ"),
            keywords: &[
                "achịcha",
                "achịcha akpụrụ akpụ",
                "achịcha akpụrụ akpụ nwere akwụkwọnri",
                "french",
                "nri",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("Croissant"),
            keywords: &["Croissant", "brauð", "franskt", "horn"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("croissant"),
            keywords: &["cibo", "colazione", "cornetto", "croissant", "francese"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("クロワッサン"),
            keywords: &["クロワッサン", "パン", "フランス", "ベーカリー"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kroasang"),
            keywords: &[
                "dhaharan",
                "kroasang",
                "prancis",
                "roti",
                "roti gulung bulan sabit",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კრუასანი"),
            keywords: &[
                "კრუასანი",
                "ნამგალისებური ფუნთუშა",
                "პური",
                "საკვები",
                "ფრანგული",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("круассан"),
            keywords: &["круассан", "нан", "тағам"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("croissant"),
            keywords: &[
                "brød",
                "croissant",
                "fransk",
                "mad",
                "morgenbrød",
                "morgenmad",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ន\u{17c6}រម\u{17bc}ល"),
            keywords: &[
                "croissant",
                "ន\u{17c6}ប\u{17c9}\u{17d0}ង",
                "ន\u{17c6}រម\u{17bc}ល",
                "បារា\u{17c6}ង",
                "ម\u{17bc}រច\u{17c6}ន\u{17b7}តខែ",
                "អាហារ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{ccd}ರ\u{ccd}ವಾಸಾಂತ\u{ccd}"),
            keywords: &[
                "ಆಹಾರ",
                "ಕ\u{ccd}ರ\u{ccd}ಯ\u{cc6}ಸಾಂತ\u{ccd} ರೋಲ\u{ccd}",
                "ಕ\u{ccd}ರ\u{ccd}ವಾಸಾಂತ\u{ccd}",
                "ಫ\u{ccd}ರ\u{cc6}ಂಚ\u{ccd}",
                "ಬ\u{ccd}ರ\u{cc6}ಡ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("크루아상"),
            keywords: &["빵", "식품", "크루아상", "프랑스"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("क\u{94d}रोयसा\u{902}ट"),
            keywords: &[
                "अन\u{94d}न",
                "क\u{94d}रिस\u{947}\u{902}ट रोल",
                "क\u{94d}रोयसा\u{902}ट",
                "पाव",
                "फ\u{94d}र\u{947}\u{902}च",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("круассан"),
            keywords: &["круассан", "нан азыгы", "тамак", "француз"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Croissant"),
            keywords: &["Brout", "Croissant", "Iessen", "franséisch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຄຣ\u{ebb}ວຊອງ"),
            keywords: &[
                "ຄຣ\u{ebb}ວຊອງ",
                "ຝຣ\u{eb1}\u{ec8}ງ",
                "ອາຫານ",
                "ເຂ\u{ebb}\u{ec9}າຈ\u{eb5}\u{ec8}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("raguolis"),
            keywords: &["bandelė", "duona", "maistas", "prancūziškas", "raguolis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kruasāns"),
            keywords: &["franču", "kruasāns", "maize", "ēdiens"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("parāoarīpeka"),
            keywords: &["kai", "parāoa", "parāoarīpeka", "pōkai pewa", "wīwī"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("кроасан"),
            keywords: &["кифла", "кроасан", "француски"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഫ\u{d4d}രെഞ\u{d4d}ച\u{d4d} റോൾ"),
            keywords: &[
                "ഫ\u{d4d}രെഞ\u{d4d}ച\u{d4d}",
                "ബ\u{d4d}രെഡ\u{d4d}",
                "ഭക\u{d4d}ഷണം",
                "റോൾ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ороомог талх"),
            keywords: &["ороомог", "талх", "франц", "хүнс", "өглөөний цай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("क\u{94d}रोस\u{947}\u{902}ट"),
            keywords: &[
                "क\u{94d}र\u{947}स\u{947}\u{902}ट रोल",
                "क\u{94d}रॉइस\u{902}ट",
                "क\u{94d}रोस\u{947}\u{902}ट",
                "खाद\u{94d}य",
                "फ\u{94d}र\u{947}\u{902}च",
                "ब\u{94d}र\u{947}ड",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kroisan"),
            keywords: &["bulan sabit", "kroisan", "makanan", "roti perancis"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("croissant"),
            keywords: &[
                "croissant",
                "franċiż",
                "ikel",
                "panina forma ta’ nofs qamar",
                "ħobż",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လခြမ\u{103a}းက\u{103d}ေးပေါင\u{103a}မ\u{102f}န\u{1037}\u{103a}"),
            keywords: &[
                "ပေါင\u{103a}မ\u{102f}န\u{1037}\u{103a}",
                "ပြင\u{103a}သစ\u{103a}",
                "လခြမ\u{103a}းက\u{103d}ေးပေါင\u{103a}မ\u{102f}န\u{1037}\u{103a}",
                "လခြမ\u{103a}းက\u{103d}ေးပေါင\u{103a}မ\u{102f}န\u{1037}\u{103a}လ\u{102d}ပ\u{103a}",
                "အစားအသောက\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("croissant"),
            keywords: &["brød", "croissant", "fransk", "mat"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("क\u{94d}रोइस\u{94d}सन\u{94d}ट"),
            keywords: &[
                "क\u{94d}र\u{947}स\u{947}न\u{94d}ट रोल",
                "क\u{94d}रोइस\u{94d}सन\u{94d}ट",
                "खाना",
                "फ\u{94d}रान\u{94d}स\u{947}ली",
                "रोटी",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("croissant"),
            keywords: &["brood", "croissant", "frans", "voedsel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("croissant"),
            keywords: &["brød", "croissant", "fransk", "mat"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b4d}ରେଏସନ\u{b4d}"),
            keywords: &[
                "କ\u{b4d}ରୀସେଣ\u{b4d}ଟ\u{b4d} ରୋଲ\u{b4d}",
                "କ\u{b4d}ରେଏସନ\u{b4d}",
                "ଖ\u{b3e}ଦ\u{b4d}ୟ",
                "ପ\u{b3e}ଉ\u{b01}ର\u{b41}ଟ\u{b3f}",
                "ଫ\u{b4d}ରେଞ\u{b4d}ଚ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a4d}ਰ\u{a48}ਸ\u{a48}\u{a02}ਟ"),
            keywords: &[
                "ਕਰ\u{a4b}ਏਸ\u{a48}ਨ",
                "ਕ\u{a4d}ਰ\u{a48}ਸ\u{a48}\u{a02}ਟ",
                "ਕ\u{a4d}ਰ\u{a48}ਸ\u{a48}\u{a02}ਟ ਰ\u{a4b}ਲ",
                "ਖਾਣਾ",
                "ਫਰ\u{a48}\u{a02}ਚ",
                "ਰ\u{a4b}ਟੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("آٹے دی ہلالی شکل دی روٹی"),
            keywords: &[
                "آٹے دی ہلالی شکل دی روٹی",
                "خوراک",
                "روٹی",
                "فرانس",
                "ہلال دی شکل آلی روٹی",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kroásant"),
            keywords: &[
                "Brẹd",
                "Brẹ\u{301}dfast",
                "Frẹnch",
                "Fud",
                "Kroásant",
                "Mọ\u{301}nín Chọp",
                "Smọ\u{301}l Raúnd Brẹd Wé Im Nem na Rol",
                "Swít Brẹd Wé Im Nem na Krọasan",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("rogalik"),
            keywords: &[
                "jedzenie",
                "pieczywo",
                "rogal",
                "rogalik",
                "rogalik francuski",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کلچه"),
            keywords: &["ډوډۍ، د کلچو رول، کلچه، خواړه، فرنچ", "کلچه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("croissant"),
            keywords: &["comida", "croissant", "pão"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["croissant", "folhado", "francês"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("croissant"),
            keywords: &[
                "croissant",
                "frances",
                "mikhuna",
                "paqarin mikhuna",
                "rollo",
                "tʼanta",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("croasant"),
            keywords: &["corn", "croasant", "croissant", "mâncare", "pâine"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1068"),
            keywords: &["E10-1068"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("круассан"),
            keywords: &["еда", "круассан", "рогалик", "французский", "хлеб"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("kuruwasa"),
            keywords: &[
                "ibiribwa",
                "kuruwasa",
                "kuruwasa izinze",
                "umufaransa",
                "umugati",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪروئيسانٽ"),
            keywords: &["ڪروئيسانٽ", "ڪروئيسانٽ، حلال رول، فرانسي، کاڌو، ماني"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dd2}ඹ\u{dd4}ල\u{dcf} බන\u{dd2}ස\u{dca}"),
            keywords: &[
                "කෑම",
                "ක\u{dd2}ඹ\u{dd4}ල\u{dcf} බන\u{dd2}ස\u{dca}",
                "ක\u{dd2}ඹ\u{dd4}ල\u{dcf} බන\u{dd2}ස\u{dca} රෝල\u{dca}",
                "ප\u{dca}\u{200d}රංශ",
                "ප\u{dcf}න\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("croissant"),
            keywords: &["croissant", "francúzske", "jedlo", "pečivo"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("rogljič"),
            keywords: &["francoski", "hrana", "pecivo", "rogljič"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qureec faransiis macaan"),
            keywords: &[
                "cunto",
                "faransiis",
                "qureec faransiis macaan",
                "rooti duuban",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kroasant"),
            keywords: &[
                "briosh",
                "franceze",
                "kroasant",
                "rulon në formë gjysmëhëne",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кроасан"),
            keywords: &["кроасан", "пекара", "пециво", "храна"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kroasan"),
            keywords: &["hrana", "kroasan", "pecivo", "pekara"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("croissant"),
            keywords: &["bröd", "croissant", "fransk", "mat"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mahamri"),
            keywords: &["chakula", "maandazi", "mahamri", "vitumbua"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ம\u{bbe}வுப\u{bcd}பண\u{bcd}டம\u{bcd}"),
            keywords: &[
                "உணவு",
                "ம\u{bbe}வுப\u{bcd} பண\u{bcd}டம\u{bcd}",
                "ம\u{bbe}வுப\u{bcd}பண\u{bcd}டம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("అర\u{c4d}ధచంద\u{c4d}ర\u{c3e}క\u{c3e}ర ర\u{c4b}ల\u{c4d}"),
            keywords: &[
                "అర\u{c4d}ధచంద\u{c4d}ర\u{c3e}కర",
                "అర\u{c4d}ధచంద\u{c4d}ర\u{c3e}కర ర\u{c4b}ల\u{c4d}",
                "అర\u{c4d}ధచంద\u{c4d}ర\u{c3e}క\u{c3e}ర ర\u{c4b}ల\u{c4d}",
                "ఆహ\u{c3e}రం",
                "ఫ\u{c4d}ర\u{c46}ంచ\u{c4d}",
                "బ\u{c4d}ర\u{c46}డ\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("кулчақанди \"Рогалик\""),
            keywords: &[
                "картошка бирён",
                "кулчақанди \"Рогалик\"",
                "кулчақанди рогалик",
                "нон",
                "рогалик",
                "ғизо",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("คร\u{e31}วซอง"),
            keywords: &["ขนม", "ขนมป\u{e31}ง", "คร\u{e31}วซอง", "อาหาร"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kruassan"),
            keywords: &[
                "dolama", "ertirlik", "fransuz", "iýmit", "kruassan", "çörek",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mā kalipa"),
            keywords: &["mā kalipa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kruvasan"),
            keywords: &["ay çöreği", "ekmek", "fransız", "kruvasan", "yiyecek"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("مۈڭگۈز بولكا"),
            keywords: &["بولكا", "فىرانسۇزچە", "مۈڭگۈز", "يۆگەم", "يېمەكلىك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("круасан"),
            keywords: &[
                "булочний виріб",
                "звій півмісяцем",
                "круасан",
                "французький",
                "їжа",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ہلال نما روٹی"),
            keywords: &["خوراک", "روٹی", "فرنچ", "ہلال نما", "ہلال نما روٹی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kruassan"),
            keywords: &["fransuz", "kruassan", "non", "taom"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bánh sừng bò"),
            keywords: &[
                "bánh móng ngựa",
                "bánh mỳ",
                "bánh sừng bò",
                "pháp",
                "thức ăn",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("Kurwaasaŋ"),
            keywords: &[
                "Kurwaasaŋ",
                "briyoos",
                "kurwaasaŋ",
                "lekk",
                "mburu",
                "wu-faraas",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-croissant"),
            keywords: &[
                "-crescent roll",
                "frentshi",
                "i-croissant",
                "isonka",
                "ukutya",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Kurosanti"),
            keywords: &[
                "Kurosanti",
                "búrẹ\u{301}dì",
                "faransé",
                "kurosanti",
                "kírísẹ\u{301}ntì",
                "ónjẹ",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("牛角包"),
            keywords: &["法國", "牛角包", "牛角卷", "食物", "麵包"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("牛角包"),
            keywords: &["法国", "牛角包", "牛角卷", "面包", "食物"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("羊角面包"),
            keywords: &["新月形面包", "法式", "羊角面包", "面包", "食物"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("可頌"),
            keywords: &["可頌", "法式", "牛角麵包", "麵包"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("牛角包"),
            keywords: &["牛角包", "麵包"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhanisi"),
            keywords: &["ibhanisi", "isifrentshi", "isinkwa", "ukudla"],
        },
    ],
};
#[doc = "🥖"]
pub const BAGUETTE_BREAD: crate::Emoji = crate::Emoji {
    glyph: "🥖",
    codepoint: "1F956",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "baguette bread",
    group: "Food & Drink",
    subgroup: "food-prepared",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("baguette"),
            keywords: &["baguette", "brood", "frankryk", "kos"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የፈረንሳይ ዳቦ"),
            keywords: &["ምግብ", "ባክዌት", "የፈረንሳይ ዳቦ", "ዳቦ", "ፈረንሳይ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}الخبز الفرنسي"),
            keywords: &["باجيت", "خبز فرنسي", "طعام", "\u{202b}الخبز الفرنسي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ব\u{9be}গেট প\u{9be}ওৰ\u{9c1}টী"),
            keywords: &[
                "খ\u{9be}দ\u{9cd}য",
                "প\u{9be}ওৰ\u{9c1}টী",
                "ফ\u{9cd}ৰেন\u{9cd}স",
                "ব\u{9be}গেট",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kərpic çörək"),
            keywords: &["kərpic çörək", "tikə", "yemək", "çörək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("багет"),
            keywords: &["багет", "батон", "ежа", "французскі"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("багети"),
            keywords: &["багета", "багети", "френско", "хляб", "храна"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9cd}য\u{9be}গ\u{9cd}য\u{9be}ট"),
            keywords: &[
                "খ\u{9be}ব\u{9be}র",
                "প\u{9be}উর\u{9c1}টি",
                "ফর\u{9be}সি",
                "ব\u{9cd}য\u{9be}গ\u{9be}ট",
                "ব\u{9cd}য\u{9be}গ\u{9cd}য\u{9be}ট",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("baget"),
            keywords: &["baget", "bara"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("francuski hljeb"),
            keywords: &["baget", "francuski", "hljeb", "hrana"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("baguet"),
            keywords: &["baguet", "barra", "menjar", "pa"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏅᎯᏓ ᏌᎨ ᎦᏚ"),
            keywords: &["ᎠᎩᏍᏗ", "ᎦᎸᏥ", "ᎦᏅᎯᏓ ᏌᎨ ᎦᏚ", "ᎦᏚ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("bageta"),
            keywords: &["bageta", "francouzské", "jídlo", "pečivo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ffon fara"),
            keywords: &["bara", "bwyd", "ffon fara", "ffrengig"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("flute"),
            keywords: &["baguette", "brød", "flute", "franskbrød", "mad"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Baguette"),
            keywords: &["Baguette", "Frühstück", "französisch"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μπαγκέτα"),
            keywords: &["γαλλικός", "μπαγκέτα", "τροφή", "ψωμί"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("baguette bread"),
            keywords: &["baguette", "bread", "food", "french"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("baguette"),
            keywords: &["baguette", "bread", "food", "french", "french stick"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("French stick"),
            keywords: &["French stick", "baguette", "bread", "food", "french"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["French", "baguette", "bread", "food"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("baguete"),
            keywords: &["baguete", "baguette", "barra", "comida", "francés", "pan"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("baguette"),
            keywords: &["baguette", "comida", "francés", "pan"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["baguette", "comida", "pan francés"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("baguette"),
            keywords: &["baguette", "pikk", "sai", "toit"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("baguettea"),
            keywords: &["Francia", "baguette", "baguettea", "janari", "ogi"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نان باگت"),
            keywords: &["باگت", "نان", "نون"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("patonki"),
            keywords: &["leipä", "patonki", "ranskalainen", "ruoka"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("baguette"),
            keywords: &["baguette", "french", "pagkain", "tinapay"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("flute"),
            keywords: &["breyð", "flute", "matur", "smábreyð"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("baguette"),
            keywords: &["baguette", "pain"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("baguette"),
            keywords: &["Francach", "arán", "baguette", "bia"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("baguette"),
            keywords: &["aran", "baguette", "biadh", "frangach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("barra de pan"),
            keywords: &["barra", "barra de pan", "comida", "pan", "panadería"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બ\u{ac7}ગ\u{ac7}ટ રોટલી"),
            keywords: &[
                "ફ\u{acd}ર\u{ac7}ન\u{acd}ચ",
                "બ\u{ac7}ગ\u{ac7}ટ",
                "ભોજન",
                "રોટલી",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("burodin baguette"),
            keywords: &[
                "abinci",
                "baguette",
                "burodi",
                "burodin baguette",
                "na faransa",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("באגט"),
            keywords: &["באגט", "לחם", "צרפתי"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बीगट ब\u{94d}र\u{947}ड"),
            keywords: &[
                "फ\u{94d}र\u{947}\u{902}च",
                "बीगट ब\u{94d}र\u{947}ड",
                "भोजन",
                "रोटी",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("baget"),
            keywords: &["baget", "francuska", "hrana", "kruh"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("bagett"),
            keywords: &["bagett", "francia", "kenyér", "étel"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բագետ"),
            keywords: &["բագետ", "հաց", "ուտելիք", "ֆրանսիական"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("roti baguette"),
            keywords: &["baget", "baguette", "roti", "roti panjang", "roti prancis"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("achịcha ogologo"),
            keywords: &["achịcha", "french", "nri", "ogologo"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fransbrauð"),
            keywords: &["brauð", "fransbrauð", "franskt", "matur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("baguette"),
            keywords: &["baguette", "cibo", "filone", "francese"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("バゲット"),
            keywords: &["バゲット", "パン", "フランスパン", "ベーカリー"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("roti baget"),
            keywords: &["baget", "dhaharan", "prancis", "roti"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბაგეტი"),
            keywords: &["ბაგეტი", "პური", "საკვები", "ფრანგული"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("багет"),
            keywords: &["багет", "нан", "тағам"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("flute"),
            keywords: &["brød", "flute", "franskbrød", "mad"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ន\u{17c6}ប\u{17c9}\u{17d0}ងវែង"),
            keywords: &[
                "ន\u{17c6}ប\u{17c9}\u{17d0}ង",
                "ន\u{17c6}ប\u{17c9}\u{17d0}ងវែង",
                "បារា\u{17c6}ង",
                "អាហារ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬಗ\u{cc6}ಟ\u{ccd} ಬ\u{ccd}ರ\u{cc6}ಡ\u{ccd}"),
            keywords: &[
                "ಆಹಾರ",
                "ಫ\u{ccd}ರ\u{cc6}ಂಚ\u{ccd}",
                "ಬಗ\u{cc6}ಟ\u{ccd}",
                "ಬ\u{ccd}ರ\u{cc6}ಡ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("바게트"),
            keywords: &["바게트", "빵", "식품", "프랑스"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बग\u{947}टी पाव"),
            keywords: &[
                "अन\u{94d}न",
                "पाव",
                "फ\u{94d}र\u{947}\u{902}च",
                "बग\u{947}टी",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("багет"),
            keywords: &["багет", "нан азыгы", "тамак", "француз"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Baguette"),
            keywords: &["Baguette", "Brout", "Iessen", "franséisch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຂ\u{ebb}\u{ec9}າຈ\u{eb5}\u{ec8}"),
            keywords: &[
                "ຝຣ\u{eb1}\u{ec8}ງ",
                "ອາຫານ",
                "ເຂ\u{ebb}\u{ec9}າຈ\u{eb5}\u{ec8}",
                "ເຂ\u{ebb}\u{ec9}າໜ\u{ebb}ມປ\u{eb1}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("ilgas batonas"),
            keywords: &["batonas", "ilgas", "maistas", "prancūzų"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("bagete"),
            keywords: &["bagete", "franču", "maize", "ēdiens"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("parāoa pakete"),
            keywords: &["kai", "pakete", "parāoa", "wīwī"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("багет"),
            keywords: &["багет", "леб", "француски"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ബ\u{d3e}ഗെറ\u{d4d}റ\u{d4d} ബ\u{d4d}രെഡ\u{d4d}"),
            keywords: &["ബ\u{d3e}ഗെറ\u{d4d}റ\u{d4d}", "ബ\u{d4d}രെഡ\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("багет франц талх"),
            keywords: &["багет", "талх", "франц", "хүнс"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ब\u{945}ग\u{947}ट ब\u{94d}र\u{947}ड"),
            keywords: &[
                "खाद\u{94d}य",
                "फ\u{94d}र\u{947}\u{902}च",
                "ब\u{945}ग\u{947}ट",
                "ब\u{94d}र\u{947}ड",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("roti baguette"),
            keywords: &["makanan", "roti baguette", "roti perancis"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ħobż baguette"),
            keywords: &["baguette", "franċiż", "ikel", "ħobż"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပြင\u{103a}သစ\u{103a}ပေါင\u{103a}မ\u{102f}န\u{1037}\u{103a}"),
            keywords: &[
                "ပေါင\u{103a}မ\u{102f}န\u{1037}\u{103a}",
                "ပြင\u{103a}သစ\u{103a}",
                "ပြင\u{103a}သစ\u{103a}ပေါင\u{103a}မ\u{102f}န\u{1037}\u{103a}",
                "အစားအသောက\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bagett"),
            keywords: &["bagett", "baguette", "brød", "fransk", "mat"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ब\u{94d}याग\u{947}ट रोटी"),
            keywords: &[
                "खाना",
                "फ\u{94d}रान\u{94d}स\u{947}ली",
                "ब\u{94d}याग\u{947}ट",
                "रोटी",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("stokbrood"),
            keywords: &["brood", "frans", "stokbrood", "voedsel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bagett"),
            keywords: &["bagett", "baguette", "brød", "fransk", "mat"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3e}ଗ\u{b41}ଏଟେ ପ\u{b3e}ଉ\u{b01}ର\u{b41}ଟ\u{b3f}"),
            keywords: &[
                "ଖ\u{b3e}ଦ\u{b4d}ୟ",
                "ଫ\u{b4d}ରେଞ\u{b4d}ଚ\u{b4d}",
                "ବ\u{b3e}ଗ\u{b41}ଏଟେ । ପ\u{b3e}ଉ\u{b01}ର\u{b41}ଟ\u{b3f}",
                "ବ\u{b3e}ଗ\u{b41}ଏଟେ ପ\u{b3e}ଉ\u{b01}ର\u{b41}ଟ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a47}ਗਟ ਬ\u{a4d}ਰ\u{a48}\u{a71}ਡ"),
            keywords: &[
                "ਫਰ\u{a48}\u{a02}ਚ",
                "ਬ\u{a47}ਗਟ ਬ\u{a4d}ਰ\u{a48}\u{a71}ਡ",
                "ਭ\u{a4b}ਜਨ",
                "ਰ\u{a4b}ਟੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کڑی ہوئی روٹی"),
            keywords: &["خوراک", "روٹی", "فرانس", "ڈھلیا ہوئیا", "کڑی ہوئی روٹی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bagẹt Brẹd"),
            keywords: &[
                "Bagẹt Brẹd",
                "Brẹd",
                "Frẹnch",
                "Fud",
                "Lọ\u{301}ng Brẹd Wé Im Nem Na Bagẹt",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("bagietka"),
            keywords: &["bagietka", "bułka", "chleb", "jedzenie", "pieczywo"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بګیټ ډوډۍ"),
            keywords: &["بکيټ، ډوډۍ، خواړه، فرنچ", "بګیټ ډوډۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("baguete"),
            keywords: &["baguete", "bisnaga", "comida", "pão"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["baguete", "cacete", "francês", "pão"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("baguette tʼanta"),
            keywords: &["baguette", "frances", "mikhuna", "tʼanta"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("baghetă de pâine"),
            keywords: &[
                "baghetă",
                "baghetă de pâine",
                "franțuzească",
                "mâncare",
                "pâine",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1074"),
            keywords: &["E10-1074"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("багет"),
            keywords: &["багет", "еда", "французский", "хлеб"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugati wa bagete"),
            keywords: &[
                "ibiribwa",
                "umufaransa",
                "umugati",
                "umugati murermure",
                "umugati wa bagete",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("باگيٽ ماني"),
            keywords: &["باگيٽ ماني", "باگيٽ، ماني، فرانسي، کاڌو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බෑගට\u{dca} ප\u{dcf}න\u{dca}"),
            keywords: &[
                "කෑම",
                "ප\u{dca}\u{200d}රංශ",
                "ප\u{dcf}න\u{dca}",
                "බෑගට\u{dca} ප\u{dcf}න\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("bageta"),
            keywords: &["bageta", "francúzske", "jedlo", "pečivo"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("bageta"),
            keywords: &["bageta", "francoska", "hrana", "kruh"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("rootiga baguette-ka"),
            keywords: &[
                "baguette-ka",
                "cunto",
                "faransiis",
                "rooti",
                "rootiga baguette-ka",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("bagetë"),
            keywords: &["bagetë", "bukë", "franceze", "ushqim"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("багет"),
            keywords: &["багет", "пекара", "пециво", "хлеб", "храна"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("baget"),
            keywords: &["baget", "hleb", "hrana", "pecivo", "pekara"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("baguette"),
            keywords: &["baguette", "bröd", "fransk", "mat"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mkate wa kifaransa"),
            keywords: &["chakula", "mkate", "mkate wa kifaransa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ரொட\u{bcd}டி உணவு"),
            keywords: &["உணவு", "ரொட\u{bcd}டி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బ\u{c4d}య\u{c3e}గ\u{c46}ట\u{c4d} బ\u{c4d}ర\u{c46}డ\u{c4d}"),
            keywords: &[
                "ఆహ\u{c3e}రం",
                "ఫ\u{c4d}ర\u{c46}ంచ\u{c4d}",
                "బ\u{c4d}య\u{c3e}గ\u{c46}ట\u{c4d}",
                "బ\u{c4d}ర\u{c46}డ\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("батон"),
            keywords: &[
                "батон",
                "картошкаи бирён",
                "нон",
                "нони дарози фаронсавӣ",
                "ғизо",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ขนมป\u{e31}งฝร\u{e31}\u{e48}งเศส"),
            keywords: &["ขนมป\u{e31}ง", "ขนมป\u{e31}งฝร\u{e31}\u{e48}งเศส", "อาหาร"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("baget çörek"),
            keywords: &["baget", "fransuz", "iýmit", "çörek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mā lōloa"),
            keywords: &["mā lōloa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("baget ekmek"),
            keywords: &["baget", "ekmek", "fransız", "yiyecek"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("فىرانسۇزچە بولكا"),
            keywords: &["بولكا", "فىرانسۇزچە", "نان", "يېمەكلىك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("багет"),
            keywords: &["багет", "булка", "французький", "хліб", "їжа"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بیگٹ ڈبل روٹی"),
            keywords: &["بریڈ", "بیگٹ", "بیگٹ ڈبل روٹی", "خوراک", "فرنچ", "ڈبل روٹی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("baget"),
            keywords: &["baget", "fransuz", "non", "taom"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bánh mì que"),
            keywords: &["bánh mì que", "bánh mỳ", "pháp", "thức ăn"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("miisu mburu"),
            keywords: &["lekk", "mburu", "miis", "miisu mburu", "wu-faraas"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isonka se-baguette"),
            keywords: &[
                "i-baguette",
                "ifrentshi",
                "isonka",
                "isonka se-baguette",
                "ukutya",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Burẹdi Baguette"),
            keywords: &[
                "Burẹdi Baguette",
                "búrẹ\u{301}dì",
                "búrẹ\u{301}dì gbọọrọ",
                "faransé",
                "ónjẹ",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("法式麵包"),
            keywords: &["法國", "法式", "法式麵包", "食物", "麵包"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("法式面包"),
            keywords: &["法国", "法式", "法式面包", "面包", "食物"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("法式长棍面包"),
            keywords: &["法式", "法式长棍面包", "面包", "食物"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("法國麵包"),
            keywords: &["法國麵包", "法式", "食物", "麵包"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("法棍包"),
            keywords: &["法包", "法國麵包", "法棍包", "麵包"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isinkwa"),
            keywords: &["baguette", "isifrentshi", "isinkwa", "ukudla"],
        },
    ],
};
#[doc = "🫓"]
pub const FLATBREAD: crate::Emoji = crate::Emoji {
    glyph: "🫓",
    codepoint: "1FAD3",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "flatbread",
    group: "Food & Drink",
    subgroup: "food-prepared",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("platbrood"),
            keywords: &["focaccia", "lavash", "pita", "platbrood"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሽልጦ"),
            keywords: &["ሽልጦ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("خبز مفرود"),
            keywords: &["آريبا", "بيتا", "خبز مسطح", "خبز مفرود", "لواش", "نان"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চেপেট\u{9be} ৰ\u{9c1}টী"),
            keywords: &[
                "অৰেপ\u{9be}",
                "চেপেট\u{9be} ৰ\u{9c1}টী",
                "ন\u{9be}ন",
                "পিত\u{9be}",
                "ল\u{9be}ভ\u{9be}চ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yumru çörək"),
            keywords: &["lavaş", "yumru çörək", "çörək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("праснак"),
            keywords: &["арэпа", "лаваш", "наан", "праснак", "піта"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("плосък хляб"),
            keywords: &["арепа", "лаваш", "наан", "пита", "плосък хляб"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ফ\u{9cd}ল\u{9cd}য\u{9be}টব\u{9cd}রেড"),
            keywords: &[
                "আরিপ\u{9be}",
                "ন\u{9be}ন",
                "পিত\u{9be}",
                "ফ\u{9cd}ল\u{9cd}য\u{9be}টব\u{9cd}রেড",
                "ল\u{9be}ভ\u{9be}শ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("galetez"),
            keywords: &["bara", "galetez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("lepinica"),
            keywords: &[
                "hrskave lepinice",
                "lepine",
                "lepinica",
                "lepinice",
                "zemičke",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pa de coca"),
            keywords: &["arepa", "coca", "lavash", "naan", "pa de coca", "pita"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᏓᏅᏅᎢ ᎦᏚ"),
            keywords: &[
                "ᎠᏍᏓᏅᏅᎢ ᎦᏚ",
                "ᎪᎢ ᎠᏍᏓᏅᏅᎢ ᎦᏚ",
                "ᏎᎷ ᎠᏍᏓᏅᏅᎢ ᎦᏚ",
                "ᏓᎶᏂᎨᏍᏛ ᎠᏍᏓᏅᏅᎢ ᎦᏚ",
                "ᏗᎧᎸᎬ ᎠᏰᏟ ᎠᏍᏓᏅᏅᎢ ᎦᏚ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("chlebová placka"),
            keywords: &["arepa", "chlebová placka", "lavaš", "naan", "nán", "pita"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("Bara fflat"),
            keywords: &[
                "Bara fflat",
                "arepa",
                "bara fflat",
                "lavash",
                "naan",
                "pita",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("fladbrød"),
            keywords: &[
                "arepas",
                "fladbrød",
                "lavash",
                "naan",
                "nan",
                "pita",
                "pitabrød",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Fladenbrot"),
            keywords: &["Arepa", "Fladenbrot", "Lavasch", "Naan", "Pita"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πίτα ψωμιού"),
            keywords: &["αρέπα", "λαβάς", "πίτα", "πίτα ψωμιού", "ψωμί νάαν"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("flatbread"),
            keywords: &["arepa", "flatbread", "lavash", "naan", "pita"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["arepa", "lavash", "naan", "nan", "pita", "pitta"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pan sin levadura"),
            keywords: &["arepa", "naan", "pan sin levadura", "pita", "tortilla"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("pan sin levadura"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("pan plano"),
            keywords: &["pan plano"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("lameleib"),
            keywords: &["arepa", "lameleib", "lavašš", "naan", "pita"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ogi zapal"),
            keywords: &["arepa", "lavash", "naan", "ogi zapal", "pita"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نان مسطح"),
            keywords: &["آره\u{200c}پا", "لواش", "نان", "نان مسطح", "پیتا"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("rieska"),
            keywords: &["arepa", "lavash", "naan", "pita", "rieska"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("flatbread"),
            keywords: &["arepa", "flatbread", "lavash", "naan", "pita"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("flatbreyð"),
            keywords: &["breyð", "flatbreyð", "naan", "pitabreyð", "ósúrgað"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("galette"),
            keywords: &["arepa", "galette", "lavash", "naan", "pita"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("pain plat"),
            keywords: &["arepa", "galette", "lavash", "naan", "pain plat", "pita"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("arán leathan"),
            keywords: &["arán leathan", "lavash", "naan", "pita"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aran-rèidh"),
            keywords: &["aran-rèidh", "arepa", "lavash", "naan", "pita"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("pan plano"),
            keywords: &["arepa", "pan de pita", "pan plano"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ફ\u{acd}લ\u{ac7}ટબ\u{acd}ર\u{ac7}ડ"),
            keywords: &[
                "એર\u{ac7}પા",
                "નાન",
                "પિટા",
                "ફ\u{acd}લ\u{ac7}ટબ\u{acd}ર\u{ac7}ડ",
                "લવાશ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פיתה"),
            keywords: &["ארפה", "לאפה", "לוואשי", "נאן", "פיתה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("फ\u{93c}\u{94d}ल\u{948}टब\u{94d}र\u{947}ड"),
            keywords: &[
                "अर\u{947}पा",
                "नान",
                "पीता",
                "फ\u{93c}\u{94d}ल\u{948}टब\u{94d}र\u{947}ड",
                "लवाश",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lepinja"),
            keywords: &["bublica", "lepinja", "naan", "pecivo", "pita"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("laposkenyér"),
            keywords: &["lapos kenyér", "laposkenyér", "naan", "pita"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("լոշիկ"),
            keywords: &["արեպա", "լավաշ", "լոշիկ", "պիտա"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("roti pipih"),
            keywords: &["areva", "lavash", "pita", "roti naan", "roti pipih"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("flakaka"),
            keywords: &[
                "arepa",
                "flakaka",
                "flatbrauð",
                "flatkaka",
                "flatkökur",
                "lavash",
                "nan",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("focaccia"),
            keywords: &["arepa", "focaccia", "lavash", "naan", "pita"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("フラットブレッド"),
            keywords: &[
                "アレパ",
                "ナン",
                "パン",
                "ピタパン",
                "フラットブレッド",
                "ラバシ",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("roti warata"),
            keywords: &[
                "roti arepa",
                "roti lapash",
                "roti naan",
                "roti pita",
                "roti warata",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ლავაში"),
            keywords: &["ლავაში", "მჭადი", "ნაანი", "პიტა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шелпек нан"),
            keywords: &["арепа", "лаваш", "наан", "пита", "шелпек нан"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ន\u{17c6}ប\u{17c9}\u{17d0}ងស\u{17c6}ប\u{17c9}ែត"),
            keywords: &[
                "ណាន",
                "ន\u{17c6}ក\u{17d2}រៀប",
                "ន\u{17c6}ប\u{17c9}\u{17d0}ងស\u{17c6}ប\u{17c9}ែត",
                "ព\u{17b8}តា",
                "ឡាវ\u{17c9}ាស\u{17cb}",
                "អារ\u{17c9}េប\u{17c9}ា",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಫ\u{ccd}ಲಾಟ\u{ccd} ಬ\u{ccd}ರ\u{cc6}ಡ\u{ccd}"),
            keywords: &[
                "ಅರ\u{cc6}ಪಾ",
                "ನಾನ\u{ccd}",
                "ಪ\u{cbf}ಟಾ",
                "ಫ\u{ccd}ಲಾಟ\u{ccd} ಬ\u{ccd}ರ\u{cc6}ಡ\u{ccd}",
                "ಲಾವಾಶ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("플랫브레드"),
            keywords: &["난", "라바쉬", "아레파", "플랫브레드", "피타"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("सपाटपाव"),
            keywords: &["अर\u{947}पा", "नान", "पिटा", "लावाश", "सपाटपाव"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жапма нан"),
            keywords: &["жапма нан"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຂ\u{ebb}\u{ec9}າຂ\u{eb5}\u{ec8}ຍາວ"),
            keywords: &[
                "ນ\u{eb1}ນ",
                "ເຂ\u{ebb}\u{ec9}າຂ\u{eb5}\u{ec8}ຍາວ",
                "ເຂ\u{ebb}\u{ec9}າຈ\u{eb5}\u{ec8}ມ\u{ebb}ນແປ",
                "ເຂ\u{ebb}\u{ec9}າຈ\u{eb5}\u{ec8}ແປ",
                "ໂລຕ\u{eb5}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("paplotis"),
            keywords: &["arepa", "lavašas", "naan", "paplotis", "pita"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("plācenis"),
            keywords: &["arepa", "lavašs", "nāanmaize", "pita", "plācenis"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("гиро-пита"),
            keywords: &["гиро-пита", "дурум", "лаваш"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഫ\u{d4d}ല\u{d3e}റ\u{d4d}റ\u{d4d}ബ\u{d4d}രഡ\u{d4d}"),
            keywords: &[
                "അരീപ",
                "ന\u{d3e}ൻ",
                "പീട",
                "ഫ\u{d4d}ല\u{d3e}റ\u{d4d}റ\u{d4d}ബ\u{d4d}രഡ\u{d4d}",
                "ല\u{d3e}വഷ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гамбир"),
            keywords: &["арепа", "гамбир", "лаваш", "наан", "пита"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("फ\u{94d}ल\u{945}टब\u{94d}र\u{947}ड"),
            keywords: &[
                "अर\u{947}पा",
                "नान",
                "पिटा",
                "फ\u{94d}ल\u{945}टब\u{94d}र\u{947}ड",
                "लवाश",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("roti leper"),
            keywords: &["arepa", "lavash", "naan", "pita", "roti leper"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပေါင\u{103a}မ\u{102f}န\u{1037}\u{103a}ပြား"),
            keywords: &[
                "န\u{1036}ပြား",
                "ပ\u{102e}တာ",
                "ပေါင\u{103a}မ\u{102f}န\u{1037}\u{103a}ပြား",
                "အရ\u{102e}ပါ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("pitabrød"),
            keywords: &["arepa", "brød", "lavash", "nan", "pita", "pitabrød"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("फ\u{94d}ल\u{94d}याटबर\u{94d}ड"),
            keywords: &[
                "एरिपा",
                "नान",
                "पिटा",
                "फ\u{94d}ल\u{94d}याटबर\u{94d}ड",
                "लाभास",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("platbrood"),
            keywords: &["arepa", "lavash", "naan", "pita", "platbrood"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("pitabrød"),
            keywords: &["arepa", "brød", "lavash", "nan", "pita", "pitabrød"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଚେପଟ\u{b3e}ପ\u{b3e}ଉ\u{b01}ର\u{b41}ଟ\u{b3f}"),
            keywords: &[
                "ଅରେପ\u{b3e}",
                "ଚେପଟ\u{b3e}ପ\u{b3e}ଉ\u{b01}ର\u{b41}ଟ\u{b3f}",
                "ନ\u{b3e}ନ",
                "ପ\u{b3f}ଟ\u{b3e}",
                "ଲ\u{b3e}ଭସ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪਰ\u{a4c}\u{a02}ਠਾ"),
            keywords: &[
                "ਕ\u{a41}ਲਚਾ",
                "ਤ\u{a70}ਦ\u{a42}ਰੀ ਰ\u{a4b}ਟੀ",
                "ਨਾਨ",
                "ਪਰ\u{a4c}\u{a02}ਠਾ",
                "ਲ\u{a71}ਛਾ ਪਰ\u{a4c}\u{a02}ਠਾ",
                "ਸ\u{a3c}ੀਰਮਾਲ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Flátbrẹd"),
            keywords: &[
                "Flát Brẹd Wé Im Nem Na Lávash",
                "Flát Brẹd Wé Im Nem Na Píta",
                "Flát Índiá Brẹd Wé Im Nem Na Naan",
                "Flátbrẹd",
                "Kọ\u{301}n Pankek Wé Im Nem Na Arẹ\u{301}pa",
                "Méz Pankek Wé Im Nem Na Arẹ\u{301}pa",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pita"),
            keywords: &["arepa", "lawasz", "naan", "pita", "podpłomyk"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("نرۍ ډوډۍ"),
            keywords: &["اريپا", "نان", "نرۍ ډوډۍ", "پيتا", "ډوډۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pão sírio"),
            keywords: &["arepa", "lavash", "naan", "pita", "pão sírio"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("llaplla t’anta"),
            keywords: &[
                "agave",
                "arepa",
                "lavash",
                "llaplla tʼanta",
                "llaplla t’anta",
                "naa",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pită"),
            keywords: &["lipie", "pită"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-041"),
            keywords: &["E13-041"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("лепешка"),
            keywords: &["лаваш", "лепешка", "наан", "пита"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("نان"),
            keywords: &["اريپا", "فليٽ بريڊ", "لاواش", "نان", "پيٽا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පැතල\u{dd2} ප\u{dcf}න\u{dca}"),
            keywords: &[
                "න\u{dcf}න\u{dca}",
                "පැතල\u{dd2} ප\u{dcf}න\u{dca}",
                "ප\u{dd2}ට\u{dcf}",
                "ලව\u{dcf}ෂ\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("chlebová placka"),
            keywords: &[
                "arabský",
                "chlebová placka",
                "chlieb",
                "lavaš",
                "naan",
                "pita",
                "tortilla",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("indijski kruh"),
            keywords: &["arepa", "indijski kruh", "lavaš", "naan", "pita"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("rooti bafloow"),
            keywords: &[
                "rooti bafloow",
                "rooti carbeed",
                "rooti laatiin",
                "rootiga labada isugu xiran",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("bukë e sheshtë"),
            keywords: &["arepa", "bukë e sheshtë", "lavash", "naan", "pite"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("пљоснат хлеб"),
            keywords: &["лаваш", "нан", "пита хлеб", "пљоснат хлеб"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("пљоснат хљеб"),
            keywords: &["пљоснат хљеб"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("pljosnat hleb"),
            keywords: &["lavaš", "nan", "pita hleb", "pljosnat hleb"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("pljosnat hljeb"),
            keywords: &["pljosnat hljeb"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tunnbröd"),
            keywords: &["naanbröd", "pitabröd", "tunnbröd"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("chapati ya maji"),
            keywords: &["arepa", "chapati ya maji", "naan", "pita"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஃபிள\u{bbe}ட\u{bcd} பிரட\u{bcd}"),
            keywords: &[
                "ஃபிள\u{bbe}ட\u{bcd} பிரட\u{bcd}",
                "அரேப\u{bbe}",
                "ந\u{bbe}ன\u{bcd}",
                "பிட\u{bbe}",
                "ல\u{bbe}வ\u{bbe}ஷ\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఫ\u{c4d}ల\u{c3e}ట\u{c4d}\u{200c}బ\u{c4d}ర\u{c46}డ\u{c4d}"),
            keywords: &[
                "అర\u{c46}ప\u{c3e}",
                "న\u{c3e}న\u{c4d}",
                "ప\u{c3f}ట\u{c3e}",
                "ఫ\u{c4d}ల\u{c3e}ట\u{c4d}\u{200c}బ\u{c4d}ర\u{c46}డ\u{c4d}",
                "లవ\u{c3e}ష\u{c4d}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แฟลตเบรด"),
            keywords: &[
                "ขนมป\u{e31}งกรอบ",
                "นาน",
                "พ\u{e34}ตา",
                "อาร\u{e35}ป\u{e31}ส",
                "แฟลตเบรด",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýasy çörek"),
            keywords: &["arepa", "lawaş", "nan", "pita", "ýasy çörek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mā lafalafa"),
            keywords: &["mā lafalafa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yassı ekmek"),
            keywords: &["bazlama", "lavaş", "naan", "pide", "pita", "yassı ekmek"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("корж"),
            keywords: &["арепа", "корж", "лаваш", "наан", "піта"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چپٹی روٹی"),
            keywords: &["اریپا", "لاوش", "نان", "پیٹا", "چپٹی روٹی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("malda non"),
            keywords: &["arepa", "lavash", "malda non", "naan", "pita"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bánh mỳ cắt lát"),
            keywords: &["arepa", "bánh mỳ cắt", "bánh mỳ cắt lát", "lavash", "pita"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("印度薄餅"),
            keywords: &["印度薄餅", "烤餅", "粟米餅", "薄餅", "餡餅"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("印度薄饼"),
            keywords: &["印度薄饼", "烤饼", "粟米饼", "薄饼", "馅饼"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("扁面包"),
            keywords: &["圆盘状烤饼", "扁面包", "玉米饼", "皮塔饼", "薄脆饼"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("麵餅"),
            keywords: &["印度南餅", "圓麵餅", "玉米麵包", "薄麵包", "麵餅"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isinkwa esibacakile"),
            keywords: &[
                "i-arepa",
                "i-lavash",
                "i-naan",
                "i-pita",
                "isinkwa esibacakile",
            ],
        },
    ],
};
#[doc = "🥨"]
pub const PRETZEL: crate::Emoji = crate::Emoji {
    glyph: "🥨",
    codepoint: "1F968",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "pretzel",
    group: "Food & Drink",
    subgroup: "food-prepared",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("pretzel"),
            keywords: &["gevleg", "pretzel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ደረቅ ብስኩት"),
            keywords: &["ደረቅ ብስኩት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بريتزل"),
            keywords: &["بريتزل"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9cd}ৰিটজেল"),
            keywords: &["পকোৱ\u{9be}", "প\u{9cd}ৰিটজেল"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("pretsel"),
            keywords: &["burulmuş", "pretsel"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("крэндзель"),
            keywords: &["крэндзель", "плеценая булка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("брецел"),
            keywords: &["брецел", "преплетено"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9cd}রেটজেল"),
            keywords: &["প\u{9cd}রেটজেল", "মোড\u{9bc}\u{9be}নো"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bretzel"),
            keywords: &["bara", "bretzel"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("perec"),
            keywords: &["perec", "savijeno"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("brètzel"),
            keywords: &["brioixeria", "brètzel", "cargolat", "menjar"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏍᏓᎦᏴᎯᏓ ᎦᏚ"),
            keywords: &["ᎤᏍᏓᎦᏴᎯᏓ ᎦᏚ", "ᎦᏄᏖᏲᎸᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("preclík"),
            keywords: &["jídlo", "kroucené", "pečivo", "preclík"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("pretsel"),
            keywords: &["pretsel", "troellog"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kringle"),
            keywords: &["kringle", "saltkringle"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Brezel"),
            keywords: &["Brezel", "gedreht"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: None,
            keywords: &["Brezel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πρέτσελ"),
            keywords: &["πρέτσελ", "στριφτό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("pretzel"),
            keywords: &["pretzel", "twisted"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bretzel"),
            keywords: &["bretzel", "galleta salada", "pretzel"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["bretzel", "galleta salada", "pretzel"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("pretzel"),
            keywords: &["pretzel", "trenza"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("soolakringel"),
            keywords: &["keerutatud", "soolakringel"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("pretzel"),
            keywords: &["biribilki", "pretzel"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("چوب\u{200c}شور"),
            keywords: &["نان پیچانده", "چوب\u{200c}شور"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("rinkilä"),
            keywords: &["kierretty", "pretzel", "rinkilä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pretzel"),
            keywords: &["baluktot", "pretzel"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("saltkringla"),
            keywords: &["matur", "saltkringla", "saltstong"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bretzel"),
            keywords: &["bretzel", "torsade"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("preatsal"),
            keywords: &["casta", "preatsal"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("pretzel"),
            keywords: &["pretzel", "toinnte"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("pretzel"),
            keywords: &["bretzel", "pretzel"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{acd}ર\u{ac7}ટ\u{acd}ઝલ"),
            keywords: &["ટ\u{acd}વિસ\u{acd}ટ\u{ac7}ડ", "પ\u{acd}ર\u{ac7}ટ\u{acd}ઝલ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("pretzel"),
            keywords: &["murɗaɗɗe", "pretzel"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("בייגלה"),
            keywords: &["בייגלה", "פרצל", "צורת 8"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{94d}र\u{947}टज\u{93c}\u{947}ल"),
            keywords: &["प\u{94d}र\u{947}टज\u{93c}\u{947}ल"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("perec"),
            keywords: &["ispleteno", "perec"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("perec"),
            keywords: &["csavart", "perec"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ոլորաբլիթ"),
            keywords: &["բոկեղ", "ոլորաբլիթ", "ոլորած", "սիմիթ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pretzel"),
            keywords: &["berkeluk", "pretzel"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("achịcha ekere eke"),
            keywords: &["achịcha ekere eke", "atụgharịrị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("saltkringla"),
            keywords: &["saltkringla", "snúin"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pretzel"),
            keywords: &["pretzel"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("プレッツェル"),
            keywords: &["ねじり", "パン", "プレッツェル"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pretsel"),
            keywords: &["diuntir", "pretsel"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("პრეცელი"),
            keywords: &["ბრეცელი", "კრენდელი", "მარყუჟი", "პრეცელი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тұзды тоқаш"),
            keywords: &["тұзды тоқаш"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ន\u{17c6}ដ\u{17bb}តវេញច\u{17bc}លគ\u{17d2}នា"),
            keywords: &[
                "ដែលវេញច\u{17bc}លគ\u{17d2}នា",
                "ន\u{17c6}ដ\u{17bb}តវេញច\u{17bc}លគ\u{17d2}នា",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪ\u{ccd}ರ\u{cc6}ಟ\u{ccd}ಜ\u{cc6}ಲ\u{ccd}"),
            keywords: &[
                "ತ\u{cbf}ರುಚ\u{cbf}ದ",
                "ಪ\u{ccd}ರ\u{cc6}ಟ\u{ccd}ಜ\u{cc6}ಲ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("프레첼"),
            keywords: &["프레첼"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("प\u{94d}रिट\u{94d}झ\u{947}ल"),
            keywords: &[
                "घ\u{941}स\u{94d}पल\u{94d}ल\u{947}\u{902}",
                "प\u{94d}रिट\u{94d}झ\u{947}ल",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("крендель"),
            keywords: &["крендель", "оролгон"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Bretzel"),
            keywords: &["Bretzel", "gedréit"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເພຣ\u{eb1}ດເຊລ"),
            keywords: &["ທະວ\u{eb4}ສທ\u{ecc}", "ເພຣ\u{eb1}ດເຊລ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("riestainis"),
            keywords: &["riestainis", "susuktas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kliņģeris"),
            keywords: &["kliņģeris", "savīts"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pretzel"),
            keywords: &["pretzel", "whiri"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("перек"),
            keywords: &["вртено", "перек"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d4d}രെറ\u{d4d}റ\u{d4d}\u{200c}സൽ"),
            keywords: &[
                "പ\u{d4d}രെറ\u{d4d}റ\u{d4d}\u{200c}സൽ",
                "ഭക\u{d4d}ഷണം",
                "യ\u{d42}റോപ\u{d4d}പ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("претцел"),
            keywords: &["ороомог", "претцел"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{94d}र\u{947}टझल"),
            keywords: &[
                "पिळल\u{947}ला",
                "प\u{94d}र\u{947}टझल",
                "प\u{94d}र\u{947}ट\u{94d}झल",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pretzel"),
            keywords: &["berpintal", "pretzel"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("pretzel"),
            keywords: &["mibruma", "pretzel"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မ\u{102f}န\u{1037}\u{103a}ကြ\u{102d}\u{102f}းလ\u{102d}မ\u{103a}"),
            keywords: &[
                "မ\u{102f}န\u{1037}\u{103a}ကြ\u{102d}\u{102f}းလ\u{102d}မ\u{103a}",
                "လ\u{102d}မ\u{103a}ထားသော",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("saltkringle"),
            keywords: &["saltkringle", "saltstenger", "snacks"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{94d}र\u{947}त\u{94d}ज\u{947}ल"),
            keywords: &["प\u{94d}र\u{947}त\u{94d}ज\u{947}ल", "बटारिएको"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("pretzel"),
            keywords: &["gedraaid", "pretzel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("saltkringle"),
            keywords: &["saltkringle", "saltstenger", "snacks"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b4d}ରେଟଜେଲ\u{b4d}\u{200d}"),
            keywords: &[
                "କ\u{b41}ଣ\u{b4d}ଡଳ\u{b3e}କ\u{b3e}ର",
                "ପ\u{b4d}ରେଟଜେଲ\u{b4d}\u{200d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a4d}ਰ\u{a47}ਟਜ\u{a3c}ਲ"),
            keywords: &["ਪ\u{a4d}ਰ\u{a47}ਟਜ\u{a3c}ਲ", "ਮਰ\u{a4b}ੜਿਆ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("خستہ ول دار بسکٹ"),
            keywords: &["خستہ ول دار بسکٹ", "مڑیا ہوئیا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Prẹ\u{301}tzẹl"),
            keywords: &[
                "Prẹ\u{301}tzul Brẹd: Brẹd Wé Dẹm Plát Laik Hea",
                "Prẹ\u{301}tzẹl",
                "To Plát Sọ\u{301}mtin Laik Hea",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("precel"),
            keywords: &["precel"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("تروه کلچه"),
            keywords: &["تروه کلچه", "تروه کلچه، تاو شوې"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pretzel"),
            keywords: &["pretzel"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pretzel"),
            keywords: &["k’uyusqa", "pretzel"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("covrig"),
            keywords: &["covrig", "covrigei", "covrigel", "covrigi"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1092"),
            keywords: &["E10-1092"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("крендель"),
            keywords: &["брецель", "закрученный", "крендель"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibisukuti"),
            keywords: &["ibisukuti", "kiberamye"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پريٽزل"),
            keywords: &["مروڙيل", "پريٽزل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dca}\u{200d}රේට\u{dca}සල\u{dca}"),
            keywords: &["ඇඹර\u{dd4}ණ\u{dd4}", "ප\u{dca}\u{200d}රේට\u{dca}සල\u{dca}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("praclík"),
            keywords: &["praclík", "skrútené", "slané"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("presta"),
            keywords: &["presta"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("buskud ulo ah"),
            keywords: &["buskud ulo ah", "marmaroogsan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gjevrek i përdredhur"),
            keywords: &[
                "brumë i përdredhur i pjekur",
                "gjevrek",
                "gjevrek i përdredhur",
                "kulaç i përdredhur",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("переца"),
            keywords: &["переца", "уврнуто"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("pereca"),
            keywords: &["pereca", "uvrnuto"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("pretzel"),
            keywords: &["pretzel", "snurrad"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("pretzel"),
            keywords: &["iliyosokotwa", "pretzel"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ப\u{bcd}ரெஸெல\u{bcd}"),
            keywords: &["ப\u{bcd}ரெஸெல\u{bcd}", "முறுக\u{bcd}கு"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c4d}ర\u{c46}ట\u{c4d}జ\u{c46}ల\u{c4d}"),
            keywords: &[
                "ట\u{c4d}వ\u{c3f}స\u{c4d}ట\u{c46}డ\u{c4d}",
                "ప\u{c4d}ర\u{c46}ట\u{c4d}జ\u{c46}ల\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("кулчаи қоқи ҳалқашакл"),
            keywords: &["каҷ", "кулчаи қоқи ҳалқашакл"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เพรตเซล"),
            keywords: &["เพรตเซล"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("krendel"),
            keywords: &["bükülen", "krendel"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pani mamio"),
            keywords: &["pani mamio"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("pretzel"),
            keywords: &["burgu", "pretzel"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يۈرەكبولكا"),
            keywords: &["تولغانغان", "يۈرەكبولكا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("крендель"),
            keywords: &["кренделик", "крендель", "сплетений"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گانٹھ کی شکل کی بسکٹ"),
            keywords: &["موڑی ہوئی", "گانٹھ کی شکل کی بسکٹ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kulcha"),
            keywords: &["kulcha", "o‘ralgan", "o‘rama"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bánh quy xoắn"),
            keywords: &["bánh quy xoắn", "xoắn"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bretzel"),
            keywords: &["bretzel", "buñ lem"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-pretzel"),
            keywords: &["ejijekileyo", "i-pretzel"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("pretzel"),
            keywords: &["lọ\u{301}pọ\u{300}", "pretzel"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("蝴蝶酥"),
            keywords: &["扭紋", "蝴蝶酥"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("蝴蝶酥"),
            keywords: &["扭纹", "蝴蝶酥"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("椒盐卷饼"),
            keywords: &["扭曲食品", "椒盐卷饼"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("蝴蝶餅"),
            keywords: &["蝴蝶餅"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("蝴蝶圈"),
            keywords: &["蝴蝶圈"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-phulezeli"),
            keywords: &["i-phulezeli", "phendukezelwe"],
        },
    ],
};
#[doc = "🥯"]
pub const BAGEL: crate::Emoji = crate::Emoji {
    glyph: "🥯",
    codepoint: "1F96F",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "bagel",
    group: "Food & Drink",
    subgroup: "food-prepared",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("bagel"),
            keywords: &["bagel", "bakkery", "smeersel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጣፋጭ ዳቦ"),
            keywords: &["መጋገሪያ", "የሚገፋፋ ነገር", "ጣፋጭ ዳቦ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("خبز البيغل"),
            keywords: &["بيجل", "خبز البيجل", "خبز البيغل", "مخبز"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বেগ’ল"),
            keywords: &["চেমিয\u{9bc}\u{9be}ৰ", "বেক\u{9be}ৰী", "বেগ’ল"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("bublik"),
            keywords: &["bublik", "bulki", "çörəkxana"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("пышка"),
            keywords: &["выпечка", "масла", "пышка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("геврек"),
            keywords: &["геврек", "закуска от тесто", "пекарна"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বেগেল"),
            keywords: &["বেক\u{9be}রি", "বেগেল", "স\u{9cd}কিম\u{9be}র"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bagel"),
            keywords: &["bagel", "bara"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("đevrek"),
            keywords: &["doručak", "pecivo", "zemička", "đevrek"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bagel"),
            keywords: &["bagel", "fleca", "forn", "panet"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏣᎴᏍᏗᎤᎦᏔ ᎦᏚ"),
            keywords: &["ᎤᏣᎴᏍᏗᎤᎦᏔ ᎦᏚ", "ᎦᏚ ᎦᏅᎵᏰᏗ", "ᏧᏂᏅᏘᏱ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("bagel"),
            keywords: &["bagel", "bejgl", "pečivo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bagel"),
            keywords: &["bagel", "brecwast", "pâst", "siop fara"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bagel"),
            keywords: &["bagel", "bagværk"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Bagel"),
            keywords: &["Backwaren", "Bagel", "Bäckerei", "Frühstück"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μπέιγκελ"),
            keywords: &["μπέιγκελ", "φούρνος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("bagel"),
            keywords: &["bagel", "bakery", "breakfast", "schmear"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["bagel", "bakery"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bagel"),
            keywords: &["bagel", "bocadillo", "pan", "panadería"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("bagel"),
            keywords: &["bagel", "panadería", "untar"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("bagel"),
            keywords: &["bagel"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("rõngassai"),
            keywords: &["määre", "pagaritoode", "rõngassai"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bagel"),
            keywords: &["bagel", "okindegi", "schmear"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نان بیگل"),
            keywords: &["مالیدن", "نان بیگل", "نانوایی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vesirinkeli"),
            keywords: &["bageli", "leivonnainen", "rinkeli", "vesirinkeli"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bagel"),
            keywords: &["bagel", "bake", "bakery", "bilog", "pagkain", "tinapay"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("bagel"),
            keywords: &["bagel", "breyð", "morgunbreyð"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bagel"),
            keywords: &["bagel", "boulangerie", "petit-déjeuner", "schmear"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("béigeal"),
            keywords: &["bácús", "béigeal", "schmear"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bagel"),
            keywords: &["bagel", "bèicearachd"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("bagel"),
            keywords: &["bagel", "beigel", "panadaría"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બ\u{ac7}ગલ"),
            keywords: &["બ\u{ac7}કરી", "બ\u{ac7}ગલ", "સ\u{acd}કમિયર"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("בייגל"),
            keywords: &["בייגל", "לחם", "מאפה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ब\u{948}गल"),
            keywords: &["ब\u{947}करी", "ब\u{948}गल", "श\u{94d}मियर"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("pecivo"),
            keywords: &["pecivo", "pekarski proizvod", "uštipak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("bagel"),
            keywords: &["bagel", "pékáru", "vajkrém"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բեյգլ"),
            keywords: &["բեյգլ", "բուլկի", "թխվածք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bagel"),
            keywords: &["bagel", "roti", "schmear"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("beygla"),
            keywords: &["bakarí", "beygla", "smurostur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("bagel"),
            keywords: &["bagel", "panetteria", "spalmare formaggio sul bagel"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ベーグル"),
            keywords: &["クリームチーズ", "パン屋", "ベーカリー", "ベーグル"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("roti bagel"),
            keywords: &["pabrik roti", "roti bagel", "roti semir"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბეიგელი"),
            keywords: &["ბეიგელი", "საფუნთუშე", "საცხობი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бейгл"),
            keywords: &["бейгл", "кулинария", "шмеар"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ន\u{17c6}កងបេហ\u{17d2}គើល"),
            keywords: &[
                "ន\u{17c6}កងបេហ\u{17d2}គើល",
                "ស\u{17d2}មៀរ",
                "ហាងន\u{17c6}ដ\u{17bb}ត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬೇಗಲ\u{ccd}"),
            keywords: &["ಬೇಕರ\u{cbf}", "ಬೇಗಲ\u{ccd}", "ಸ\u{ccd}ಕ\u{cc6}ಮರ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("베이글"),
            keywords: &["베이글", "빵", "슈미어"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बाग\u{947}ल"),
            keywords: &["बाग\u{947}ल", "ब\u{947}करी", "स\u{94d}मिअर"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тегерек токоч"),
            keywords: &["жалаа", "нан азыктары", "тегерек токоч"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຂະໝ\u{ebb}ມແປ\u{ec9}ງ ບາເກວ"),
            keywords: &[
                "ຂະໜ\u{ebb}ມແປ\u{ec9}ງ",
                "ຂະໝ\u{ebb}ມແປ\u{ec9}ງ ບາເກວ",
                "ອ\u{ebb}ບແປ\u{ec9}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("apvalus riestainis"),
            keywords: &["apvalus riestainis", "duonos gaminiai", "užtepas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("beigelis"),
            keywords: &["beigelis", "maiznīca", "smērējams"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("ѓеврек"),
            keywords: &["пекарница", "пециво", "ѓеврек"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ബ\u{d3e}ഗെൽ"),
            keywords: &["ബ\u{d3e}ഗെൽ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цагирган талх"),
            keywords: &["нарийн боовны газар", "цагирган талх", "өглөөний цай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ब\u{947}गल"),
            keywords: &["ख\u{94d}म\u{947}र", "ब\u{947}करी", "ब\u{947}गल"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bagel"),
            keywords: &["bagel", "bakeri", "lepa"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပေါင\u{103a}မ\u{102f}န\u{1037}\u{103a}အက\u{103d}င\u{103a}း"),
            keywords: &[
                "ထောပတ\u{103a}",
                "ပေါင\u{103a}မ\u{102f}န\u{1037}\u{103a}အက\u{103d}င\u{103a}း",
                "မ\u{102f}န\u{1037}\u{103a}ဖ\u{102f}တ\u{103a}လ\u{102f}ပ\u{103a}ငန\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bagel"),
            keywords: &["bagel", "bakst", "påsmurt"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("डोनोट"),
            keywords: &["गह\u{901}को परिकार", "डोनोट", "स\u{94d}मियर"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bagel"),
            keywords: &["bagel", "bakkerij", "spread"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bagel"),
            keywords: &["bagel", "bakst", "påsmurt"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବେଜଲ\u{b4d}\u{200c}"),
            keywords: &[
                "ବେକେର\u{b3f}",
                "ବେଜଲ\u{b4d}\u{200c}",
                "ସ\u{b4d}କ\u{b3f}ମର\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਗ\u{a4b}ਲ ਬ\u{a4d}ਰ\u{a48}\u{a71}ਡ"),
            keywords: &[
                "ਗ\u{a4b}ਲ ਬ\u{a4d}ਰ\u{a48}\u{a71}ਡ",
                "ਬ\u{a47}ਕਰੀ",
                "ਸ\u{a3c}ਮੀਅਰ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bégul"),
            keywords: &[
                "Brẹd Wé Im Nem Na Bégul",
                "Brẹ\u{301}kfast",
                "Bégul",
                "Békri",
                "Mọ\u{301}nín Chọp",
                "Rọb",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("bajgiel"),
            keywords: &["bajgiel", "pieczywo", "piekarnia", "posmarować"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("يو ډول کلچه"),
            keywords: &["بيکري", "شميير", "يو ډول کلچه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosca"),
            keywords: &["chimia", "pão", "rosca"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("bagel"),
            keywords: &["argola", "bagel", "pão"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("bagel"),
            keywords: &["bagel", "panaderia", "paqarin mikuna", "schmear"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bagel"),
            keywords: &["bagel", "covrig moale", "patiserie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-011"),
            keywords: &["E11-011"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("бублик"),
            keywords: &["баранка", "бейгель", "бейгл", "бублик"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بيگل"),
            keywords: &["اسڪيميئر", "بيڪري", "بيگل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ම\u{dd4}ද\u{dd4} හැඩැත\u{dd2} ප\u{dcf}න\u{dca}"),
            keywords: &[
                "බේකර\u{dd2}",
                "ම\u{dd4}ද\u{dd4} හැඩැත\u{dd2} ප\u{dcf}න\u{dca}",
                "ෂ\u{dd2}ම\u{dcf}ර\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("bagel"),
            keywords: &["bagel", "pekáreň", "pečivo"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("bagel"),
            keywords: &["bagel", "namaz", "pekarna"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("pagel-ka"),
            keywords: &["bagel-ka", "foornada rootiga", "pagel-ka"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gjevrek"),
            keywords: &["furrë", "gjevrek", "kulaç"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("бејгл"),
            keywords: &["бејгл", "пекара"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("bejgl"),
            keywords: &["bejgl", "pekara"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("bagel"),
            keywords: &["bagel", "bakverk", "bröd"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mkate wa kuoka"),
            keywords: &["kuoka", "mkate wa kuoka", "siagi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பேகல\u{bcd}"),
            keywords: &["பேகல\u{bcd}", "பேக\u{bcd}கரி", "ஸ\u{bcd}மியர\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బ\u{c4d}య\u{c3e}గ\u{c46}ల\u{c4d}"),
            keywords: &[
                "బ\u{c47}కర\u{c40}",
                "బ\u{c4d}య\u{c3e}గ\u{c46}ల\u{c4d}",
                "ష\u{c4d}మ\u{c3f}ర\u{c4d}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เบเก\u{e34}ล"),
            keywords: &["ทาแยม", "ร\u{e49}านขนมป\u{e31}ง", "เบเก\u{e34}ล"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("rogalik"),
            keywords: &["ertirlik", "rogalik", "çalmak", "çörekhana"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pani mama"),
            keywords: &["pani mama"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("simit"),
            keywords: &["bagel", "fırın", "simit", "sürme peynir"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("бейгл"),
            keywords: &[
                "багель",
                "бейгл",
                "бублик",
                "булочка",
                "випічка",
                "пончик",
                "сніданок",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بیگل"),
            keywords: &["بیکری", "بیگل", "شمئیر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("shirmoy teshik kulcha"),
            keywords: &["kulcha", "shirmoy teshik kulcha", "teshik kulcha"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bánh mỳ vòng"),
            keywords: &["bánh mỳ vòng", "bánh vòng", "bữa sáng", "phết", "tiệm bánh"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("比高包"),
            keywords: &["早餐", "比高包", "烘焙", "醬"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("比高包"),
            keywords: &["比高包", "烘焙", "酱"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("面包圈"),
            keywords: &["奶酪酱", "烘烤食品", "面包圈"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("貝果"),
            keywords: &["貝果", "醬", "麵包"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("bagel"),
            keywords: &["bagel", "bakery", "schmear"],
        },
    ],
};
#[doc = "🥞"]
pub const PANCAKES: crate::Emoji = crate::Emoji {
    glyph: "🥞",
    codepoint: "1F95E",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "pancakes",
    group: "Food & Drink",
    subgroup: "food-prepared",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("pannekoeke"),
            keywords: &[
                "kos",
                "pannekoek",
                "pannekoeke",
                "plaatkoekie",
                "plaatkoekies",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ፓንኬክ"),
            keywords: &["ምግብ", "ትኩስ ኬክ", "ክሬፕ", "ፓንኬክ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("فطائر"),
            keywords: &["طعام", "فطائر", "فطيرة", "كريب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("পেনকেক"),
            keywords: &["ক\u{9cd}ৰেপ", "খ\u{9be}দ\u{9cd}য", "পেনকেক", "হটকেক"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("blin"),
            keywords: &["blin", "kökə", "yemək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("бліны"),
            keywords: &["бліны", "ежа"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("палачинки"),
            keywords: &["палачинка", "палачинки", "храна"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9cd}য\u{9be}নকেক"),
            keywords: &[
                "ক\u{9cd}রেপ",
                "খ\u{9be}ব\u{9be}র",
                "প\u{9cd}য\u{9be}নকেক",
                "হটকেক",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("krampouezh"),
            keywords: &["galetez", "krampouezh", "pancake"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("palačinke"),
            keywords: &["crepe", "doručak", "hrana", "palačinke"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("creps americanes"),
            keywords: &["americanes", "crep", "creps", "menjar", "pancake"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄛𑄬𑄚\u{11134}𑄇𑄬𑄇\u{11134}"),
            keywords: &["𑄛𑄬𑄚\u{11134}𑄇𑄬𑄇\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏔᎷᎩᏍᎩ ᎦᏚ"),
            keywords: &["ᎠᎵᏍᏓᏴᏗ", "ᎤᏗᏞᎦ", "ᎦᏚ ᎤᎦᎾᏍᏓ", "ᏌᎨ ᎦᏚ", "ᏔᎷᎩᏍᎩ ᎦᏚ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("palačinky"),
            keywords: &["jídlo", "lívance", "palačinky"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("crempogau"),
            keywords: &["bwyd", "cacennau poeth", "crempog", "crempogau", "crêpe"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("pandekager"),
            keywords: &["crêpe", "mad", "pandekage", "pandekager"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Pfannkuchen"),
            keywords: &["Eierpfannkuchen", "Essen", "Pfannkuchen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τηγανίτες"),
            keywords: &["κέικ", "κρέπα", "τηγανίτα", "τηγανίτες", "τροφή"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("pancakes"),
            keywords: &[
                "breakfast",
                "crêpe",
                "food",
                "hotcake",
                "pancake",
                "pancakes",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("tortitas"),
            keywords: &[
                "comida", "dulce", "pancakes", "postre", "tortita", "tortitas",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("hotcakes"),
            keywords: &["comida", "dulce", "hotcakes", "panqueques"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["comida", "desayuno", "hotcakes", "pancakes", "panqueques"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("pannkoogid"),
            keywords: &["crêpe", "pannkoogid", "pannkook", "toit"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("opil txikiak"),
            keywords: &["janari", "krepe", "opil bero", "opil txiki", "opil txikiak"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پنکیک"),
            keywords: &["پنکیک", "کیک", "کیک تابه\u{200c}ای"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("letut"),
            keywords: &["lettu", "letut", "ohukainen", "pannukakku", "ruoka"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pancakes"),
            keywords: &["crêpe", "hotcake", "pagkain", "pancake", "pancakes"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("pannukaka"),
            keywords: &["eggjakøka", "matur", "pannukaka"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("pancakes"),
            keywords: &["crêpe", "pancake", "pancakes"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("crêpes"),
            keywords: &["crêpe", "crêpes", "pancake"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("pancóga"),
            keywords: &["bia", "crêpe", "císte te", "pancóg", "pancóga"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("breacagan"),
            keywords: &["biadh", "breacag", "breacagan", "crêpe", "foileag"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("chulas"),
            keywords: &["chulas", "comida", "pancakes", "tortas"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{ac5}ન\u{acd}ક\u{ac7}ક"),
            keywords: &["પ\u{ac5}ન\u{acd}ક\u{ac7}ક", "ભોજન", "હૉટક\u{ac7}ક"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fanke"),
            keywords: &["abinci", "crêpe", "fanke", "kek mai zafi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פנקייקס"),
            keywords: &["חביתית", "חם", "פנקייק", "פנקייקס", "קרפ"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{948}नक\u{947}क"),
            keywords: &[
                "क\u{94d}र\u{947}प",
                "प\u{948}नक\u{947}क",
                "भोजन",
                "हॉटक\u{947}क",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("palačinke"),
            keywords: &["crêpe", "hrana", "palačinke"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("palacsinta"),
            keywords: &["palacsinta", "étel"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ձիթաբլիթ"),
            keywords: &["բլիթ", "կրեպ", "ձիթաբլիթ", "ուտելիք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("panekuk"),
            keywords: &["pancake", "panekuk", "serabi"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("achịchanri gasị"),
            keywords: &[
                "achịcha kpụrụ kpụrụ",
                "achịcha na àkwa",
                "achịchanri",
                "achịchanri gasị",
                "nri",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("pönnukökur"),
            keywords: &["eftirréttur", "matur", "pönnukökur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pancake"),
            keywords: &["americano", "cibo", "colazione", "crêpe", "pancake"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("パンケーキ"),
            keywords: &["パンケーキ", "ホットケーキ"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("panekuk"),
            keywords: &["apem", "dhaharan", "krep", "panekuk"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბლინები"),
            keywords: &["ბლინები", "ბლინი", "კრეპი", "მაჭკატი", "საკვები"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("құймақ"),
            keywords: &["сүт", "тағам", "құймақ"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("pandekager"),
            keywords: &["crêpe", "mad", "pandekage", "pandekager"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ន\u{17c6}ចាក\u{17cb}ព\u{17bb}ម\u{17d2}ព"),
            keywords: &[
                "ន\u{17c6}ក\u{17d2}តៅ",
                "ន\u{17c6}ក\u{17d2}រៀប",
                "ន\u{17c6}ចាក\u{17cb}ច\u{17bb}ល",
                "ន\u{17c6}ចាក\u{17cb}ព\u{17bb}ម\u{17d2}ព",
                "អាហារ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪಾನ\u{ccd}\u{200c}ಕೇಕ\u{ccd}\u{200c}ಗಳು"),
            keywords: &[
                "ಆಹಾರ",
                "ಕ\u{ccd}ರ\u{cc6}ಪ\u{cc6}",
                "ಪಾನ\u{ccd}\u{200c}ಕೇಕ\u{ccd}\u{200c}",
                "ಪಾನ\u{ccd}\u{200c}ಕೇಕ\u{ccd}\u{200c}ಗಳು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("팬케이크"),
            keywords: &["식품", "크레페", "팬케이크", "핫케이크"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("प\u{945}नक\u{947}क"),
            keywords: &[
                "अन\u{94d}न",
                "क\u{94d}र\u{947}प\u{947}",
                "प\u{945}नक\u{947}क",
                "प\u{945}नक\u{947}क\u{94d}स",
                "हॉटक\u{947}क",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("куймак"),
            keywords: &["куймак", "тамак"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Paangecher"),
            keywords: &["Crêpe", "Iessen", "Paangech", "Paangecher", "Pancake"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແພນເຄ\u{eb1}ກ"),
            keywords: &["ອາຫານ", "ເຄຣບ", "ເຄ\u{eb1}ກຮ\u{ec9}ອນ", "ແພນເຄ\u{eb1}ກ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("blynai"),
            keywords: &["blynai", "maistas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pankūkas"),
            keywords: &["bliņa", "pankūka", "pankūkas", "ēdiens"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("panekeke"),
            keywords: &["kai", "kekewera", "kerēpe", "panekeke"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("палачинки"),
            keywords: &["десерт", "палачинка", "палачинки"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d3e}ൻ കേക\u{d4d}ക\u{d4d}"),
            keywords: &[
                "കേക\u{d4d}ക\u{d4d}",
                "പ\u{d3e}ൻ കേക\u{d4d}ക\u{d4d}",
                "ഭക\u{d4d}ഷണം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бин"),
            keywords: &["бин", "креп", "хүнс", "шарвин", "өглөөний цай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{945}नक\u{947}क"),
            keywords: &[
                "क\u{94d}र\u{947}प",
                "खाद\u{94d}य",
                "प\u{945}नक\u{947}क",
                "प\u{945}नक\u{947}क\u{94d}स",
                "हॉटक\u{947}क",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("penkek"),
            keywords: &["lempeng", "makanan", "penkek"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("pancakes"),
            keywords: &["crêpe", "hotcake", "ikel", "pancake", "pancakes"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မ\u{102f}န\u{1037}\u{103a}အ\u{102d}\u{102f}းကင\u{103a}းကြော\u{103a}"),
            keywords: &[
                "မ\u{102f}န\u{1037}\u{103a}အ\u{102d}\u{102f}းကင\u{103a}းကြော\u{103a}",
                "အစားအသောက\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("pannekaker"),
            keywords: &["crêpe", "mat", "pannekake", "pannekaker"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{94d}यानक\u{947}क"),
            keywords: &[
                "क\u{94d}र\u{947}प\u{947}",
                "खाना",
                "तातो क\u{947}क",
                "प\u{94d}यानक\u{947}क",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("pannenkoeken"),
            keywords: &["crêpe", "flensjes", "pannenkoek", "pannenkoeken", "voedsel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("pannekaker"),
            keywords: &["crêpe", "mat", "pannekake", "pannekaker"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b3e}ନକେକ\u{b4d}\u{200d}"),
            keywords: &[
                "ପ\u{b3e}ନକେକ\u{b4d}\u{200d}",
                "ହଟକେକ\u{b4d}\u{200d} । କ\u{b4d}ରେପ\u{b3f} । ପ\u{b3e}ନକେକ\u{b4d}\u{200d} । ଖ\u{b3e}ଦ\u{b4d}ୟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a48}ਨਕ\u{a47}ਕ"),
            keywords: &[
                "ਕਰ\u{a48}ਪ",
                "ਪ\u{a48}ਨਕ\u{a47}ਕ",
                "ਭ\u{a4b}ਜਨ",
                "ਹਾ\u{a71}ਟਕ\u{a47}ਕ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پین کیکس"),
            keywords: &["خوراک", "پین کیک", "پین کیکس", "کریپی", "ہاٹ کیک"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pankek"),
            keywords: &[
                "Chọp",
                "Fud",
                "Họ\u{301}tkek",
                "Mọ\u{301}nín Chọp",
                "Pankek",
                "Pankek Wé Nọ\u{301} Dé Tik Sámsám",
                "Pankek-dẹm",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("naleśniki"),
            keywords: &["jedzenie", "naleśniki", "placki"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پینکیکونه"),
            keywords: &["پینکیکونه", "کريپ، خواړه، هاټ کيک، پينکيک، پينکيکونه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("panquecas"),
            keywords: &["comida", "crepes", "panquecas"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["comida", "crepe", "doce", "panqueca", "panquecas"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("panqueques"),
            keywords: &[
                "breakfast",
                "crepe",
                "mikhuna",
                "panqueque",
                "panqueques",
                "pastel caliente",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("clătite"),
            keywords: &["clătite", "clătită", "crepe", "mâncare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1082"),
            keywords: &["E10-1082"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("блины"),
            keywords: &["блинчики", "блины", "еда", "оладьи"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("panikeke"),
            keywords: &[
                "ibiribwa",
                "keke isize ubuki",
                "keke nto isize ubuki",
                "kerepe",
                "panikeke",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پراٺو"),
            keywords: &["پراٺو", "پراٺو، ڪريپ، کاڌو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පැන\u{dca} කේක\u{dca}"),
            keywords: &[
                "උණ\u{dd4}ස\u{dd4}ම\u{dca} කේක\u{dca}",
                "කෑම",
                "පැන\u{dca} කේක\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("lievance"),
            keywords: &["jedlo", "lievance", "lievanec", "palacinka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("palačinke"),
            keywords: &["hrana", "palačinke"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("canjeelo"),
            keywords: &["canjeelo", "canjeelooyin", "cunto", "keeg kulul"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("petulla"),
            keywords: &["krepa", "palapeta", "petulla", "ushqim"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("палачинке"),
            keywords: &["палачинке", "храна"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("palačinke"),
            keywords: &["hrana", "palačinke"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("pannkakor"),
            keywords: &["crêpes", "mat", "pannkaka", "pannkakor"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("chapati"),
            keywords: &["chakula", "chapati"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பேன\u{bcd}கேக\u{bcd}"),
            keywords: &["உணவு", "பேன\u{bcd}கேக\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c4d}య\u{c3e}న\u{c4d}\u{200c}క\u{c47}క\u{c4d}\u{200c}లు"),
            keywords: &[
                "ఆహ\u{c3e}రం",
                "క\u{c4d}ర\u{c47}ప\u{c4d}",
                "ప\u{c4d}య\u{c3e}న\u{c4d}\u{200c}క\u{c47}క\u{c4d}",
                "ప\u{c4d}య\u{c3e}న\u{c4d}\u{200c}క\u{c47}క\u{c4d}\u{200c}లు",
                "హ\u{c3e}ట\u{c4d}\u{200c}క\u{c47}క\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("чалпак"),
            keywords: &["пироги гарм", "чалпак", "чалпаки тунук", "ғизо"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แพนเค\u{e49}ก"),
            keywords: &["ขนมป\u{e31}ง", "อาหาร", "แพนเค\u{e49}ก"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("byzmyk"),
            keywords: &[
                "byzmyk",
                "byzmyklar",
                "ertirlik",
                "gyzgyn gutap",
                "iýmit",
                "krep",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pani"),
            keywords: &["pani"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("krep"),
            keywords: &["gözleme", "krep", "pankek", "yiyecek"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قازان كاكچىسى"),
            keywords: &["تورت", "تۈرمەل", "قازان كاكچىسى", "قىزىق", "يېمەكلىك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("млинці"),
            keywords: &[
                "креп",
                "млинець",
                "млинці",
                "налисник",
                "налисники",
                "сніданок",
                "їжа",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پین کیکس"),
            keywords: &["خوراک", "پین کیک", "پین کیکس"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("blinchik"),
            keywords: &["blinchik", "blinchiklar", "krep", "pirog", "taom"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bánh kếp"),
            keywords: &["bánh kếp", "thức ăn"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("krep"),
            keywords: &["crêpe", "krep", "lekk", "ngato bu tànk"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-pancakes"),
            keywords: &["i-crêpe", "i-hotcake", "i-pancake", "i-pancakes", "ukutya"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Atike Ikunju"),
            keywords: &["Atike Ikunju", "búrẹ\u{301}dì pẹlẹbẹ", "crepe", "ónjẹ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("班戟"),
            keywords: &["熱香餅", "班戟", "薄班戟", "食物"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("班戟"),
            keywords: &["热香饼", "班戟", "薄班戟", "食物"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("烙饼"),
            keywords: &["烙饼", "煎饼", "食物"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("鬆餅"),
            keywords: &["煎餅", "薄餅", "食物", "鬆餅"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("班戟"),
            keywords: &["烙餅", "烤餅", "班戟"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("amakhekhe"),
            keywords: &[
                "amakhekhe",
                "crêpe",
                "ikhekhe elishisayo",
                "isifrentshi",
                "ukudla",
            ],
        },
    ],
};
#[doc = "🧇"]
pub const WAFFLE: crate::Emoji = crate::Emoji {
    glyph: "🧇",
    codepoint: "1F9C7",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "waffle",
    group: "Food & Drink",
    subgroup: "food-prepared",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("wafel"),
            keywords: &["onbeslis", "pan", "wafel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ኬክ"),
            keywords: &["ብረት", "ኬክ", "የማያጠግብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وافل"),
            keywords: &["متردد", "مذبذب", "وافل"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ৱ\u{9be}ফল"),
            keywords: &["অনিৰ\u{9cd}ণীত", "লোহ\u{9be}", "ৱ\u{9be}ফল"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("vafli"),
            keywords: &["dəmir", "qərarsız", "vafli"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("вафля"),
            keywords: &["вафельніца", "вафля", "няпэўнасць"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("гофрета"),
            keywords: &["гофрета", "форма за гофрети"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ওয\u{9bc}\u{9be}ফেল"),
            keywords: &[
                "ওয\u{9bc}\u{9be}ফেল",
                "দ\u{9cd}বিধ\u{9be}ন\u{9cd}বিত",
                "লোহ\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("galfrez"),
            keywords: &["dijuniñ", "galfrez", "pastezerezh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("vafl"),
            keywords: &["blebetanje", "doručak", "neodlučnost", "vafl"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("gofra"),
            keywords: &["gofra", "gofrera"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏅᎩ ᏧᎾᏏᏯ ᎦᏚ"),
            keywords: &["ᏂᏓᎫᎦᏗᏍᎬᎾ", "ᏅᎩ ᏧᎾᏏᏯ ᎦᏚ", "ᏔᎷᎩᏍᎩ ᎤᏗᏞᎦ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("vafle"),
            keywords: &[
                "forma",
                "moučník",
                "mřížka",
                "sendvičovač",
                "vafle",
                "vaflovač",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("woffl"),
            keywords: &["ansicr", "brecwast", "haearn", "waffl", "woffl"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("vaffel"),
            keywords: &["jern", "ubeslutsom", "vaffel"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Waffel"),
            keywords: &["Waffel", "Waffel mit Butter"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("βάφλα"),
            keywords: &["αναποφάσιστος", "βάφλα", "βαφλιέρα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("waffle"),
            keywords: &["breakfast", "indecisive", "iron", "waffle"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["waffle", "waffle with butter"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("gofre"),
            keywords: &["gofre", "waffle"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("waffle"),
            keywords: &["waffle"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("waffle"),
            keywords: &["desayuno", "plancha de metal", "waffle"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("vahvel"),
            keywords: &["kõhklev", "vahvel", "vahvliraud"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gofrea"),
            keywords: &["burdina", "gofrea", "zalantzatia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("وافل"),
            keywords: &["آهن", "مردد", "وافل"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vohveli"),
            keywords: &["päättämätön", "ratkaisematon", "vohveli", "vohvelirauta"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("waffle"),
            keywords: &[
                "hindi makapagdesisyon",
                "hindi makapagpasya",
                "iron",
                "waffle",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("vafla"),
            keywords: &["vafla"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("gaufre"),
            keywords: &[
                "gaufre",
                "gourmandise",
                "moule",
                "petit-déjeuner",
                "pâtisserie",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("vaifeal"),
            keywords: &["bricfeasta", "iarn", "vaifeal"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("waffle"),
            keywords: &[
                "baoth-chòmhradh",
                "bleadraich",
                "iarrann",
                "neo-chinnteach",
                "riachdalach",
                "waffle",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("gofre"),
            keywords: &["doce", "gofre"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વૉફલ"),
            keywords: &["અનિર\u{acd}ણાયક", "આયર\u{acd}ન", "વૉફલ"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("וופל"),
            keywords: &["אפיפית", "וופל", "ופל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("वफ\u{93c}ल"),
            keywords: &["वफ\u{93c}ल"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("vafel"),
            keywords: &["neodlučan", "tost", "vafel"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("gofri"),
            keywords: &["gofri", "határozatlan", "vas"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("վաֆլի"),
            keywords: &["աղանդեր", "նախաճաշ", "վաֆլի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wafel"),
            keywords: &["makanan", "wafel", "waffle"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("vaffla"),
            keywords: &["járn", "vaffla", "vöfflujárn"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("waffle"),
            keywords: &["gaufre", "waffle"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ワッフル"),
            keywords: &["ふんわり", "ワッフル", "焼き菓子"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wafel"),
            keywords: &["mangu-mangu", "wafel", "wesi"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ვაფლი"),
            keywords: &["დესერტი", "ვაფლი", "ვაფლის"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("вафля"),
            keywords: &["бос әңгіме", "вафель қалыбы", "вафля"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ន\u{17c6}ព\u{17bb}ម\u{17d2}ព"),
            keywords: &[
                "ដែក",
                "ន\u{17c6}ព\u{17bb}ម\u{17d2}ព",
                "ម\u{17b7}នច\u{17d2}បាស\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ವ\u{ccd}ಯಾಫಲ\u{ccd}"),
            keywords: &[
                "ಕಬ\u{ccd}ಬ\u{cbf}ಣ",
                "ನ\u{cbf}ರ\u{ccd}ಣಯ\u{cbf}ಸದ",
                "ವ\u{ccd}ಯಾಫಲ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("와플"),
            keywords: &["와플"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("व\u{945}फल"),
            keywords: &["अनिश\u{94d}चीत", "लोख\u{902}ड", "व\u{945}फल"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("вафли"),
            keywords: &["вафли", "темир", "ческинсиз"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some(
                "ເຂ\u{ebb}\u{ec9}າ\u{200b}ໜ\u{ebb}ມ\u{200b}ຮ\u{eb1}ງ\u{200b}ເຜ\u{eb4}\u{ec9}ງ",
            ),
            keywords: &[
                "ວາ\u{200b}ຟ\u{200b}ໂຟ",
                "ອາ\u{200b}ຫານ",
                "ເຂ\u{ebb}\u{ec9}າ\u{200b}ໜ\u{ebb}ມ",
                "ເຂ\u{ebb}\u{ec9}າ\u{200b}ໜ\u{ebb}ມ\u{200b}ຮ\u{eb1}ງ\u{200b}ເຜ\u{eb4}\u{ec9}ງ",
                "ເຄ\u{eb7}\u{ec8}ອງ\u{200b}ໜ\u{eb5}ບ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vaflis"),
            keywords: &["geležinis", "neaiškus", "vaflis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vafele"),
            keywords: &["brokastis", "panna", "pusgatavas", "vafele"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("вафла"),
            keywords: &["вафла", "калап за вафли"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വേഫിൾ"),
            keywords: &[
                "ഇര\u{d41}മ\u{d4d}പ\u{d4d}",
                "ഉറപ\u{d4d}പില\u{d4d}ല\u{d3e}ത\u{d4d}തത\u{d4d}",
                "വേഫിൾ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("вафль"),
            keywords: &["вафль", "ширэм"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("व\u{945}फल"),
            keywords: &["अनिश\u{94d}चित", "लोह", "व\u{945}फल"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("wafel"),
            keywords: &["besi", "tidak tegas", "wafel"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဒေါင\u{103a}းဖန\u{103a}ဝါ မ\u{102f}န\u{1037}\u{103a}"),
            keywords: &[
                "ဒေါင\u{103a}းဖန\u{103a}ဝါ မ\u{102f}န\u{1037}\u{103a}",
                "ဒေါင\u{103a}းဖန\u{103a}ဝါမ\u{102f}န\u{1037}\u{103a} အ\u{102d}\u{102f}းကင\u{103a}း",
                "မပြတ\u{103a}သားသော",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("belgisk vaffel"),
            keywords: &["belgisk vaffel", "jern", "vaffel"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("वाफ\u{94d}फल"),
            keywords: &["अनिर\u{94d}णायक", "आइरन", "वाफ\u{94d}फल"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("wafel"),
            keywords: &["ijzer", "wafel", "weifelend"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("belgisk vaffel"),
            keywords: &["belgisk vaffel", "jern", "vaffel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ୱ\u{b3e}ଫେଲ"),
            keywords: &["ନ\u{b3f}ଷ\u{b4d}ପତ\u{b4d}ତ\u{b3f}ହୀନ", "ଲୌହ", "ୱ\u{b3e}ଫେଲ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਵਫ\u{a3c}ਲ"),
            keywords: &["ਅਸਥਿਰ", "ਲ\u{a4b}ਹਾ", "ਵਫ\u{a3c}ਲ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wáful"),
            keywords: &[
                "Brẹ\u{301}kfast",
                "Flát Pankek Wé Im Nem Na Wáful",
                "Mọ\u{301}nín Chọp",
                "Wáful",
                "Á\u{300}yọn",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("gofr"),
            keywords: &["gofr", "gofrownica"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کولچه"),
            keywords: &["اوسپنه", "بې تصميمه", "کولچه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("waffle"),
            keywords: &["gofre", "waffle", "wafle"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["waffle"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("waffle"),
            keywords: &["desayuno", "plancha", "thuki", "waffle"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("gofră"),
            keywords: &["fier de călcat", "gofră", "nehotărât"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–046"),
            keywords: &["E12–046"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("вафля"),
            keywords: &["вафельный", "вафли", "вафля", "десерт"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ويفل"),
            keywords: &["استري", "انڊيسو", "ويفل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වැෆල\u{dca}"),
            keywords: &[
                "අන\u{dd2}ශ\u{dca}වත",
                "ඉත\u{dcf} ශක\u{dca}ත\u{dd2}මත\u{dca}",
                "වැෆල\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("vafľa"),
            keywords: &[
                "forma",
                "mriežka",
                "múčnik",
                "sendvičovač",
                "vaflovač",
                "vafľa",
                "vafľovač",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vafelj"),
            keywords: &["oblat", "pecivo", "vafelj"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("doolshe"),
            keywords: &["bir", "doolshe", "go’aan darro"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("vafer"),
            keywords: &["brumë i derdhur", "formë për vafer", "vafer"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("вафл"),
            keywords: &["вафл", "гвожђе", "неодлучан"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("vafl"),
            keywords: &["gvožđe", "neodlučan", "vafl"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("våffla"),
            keywords: &["våffeldagen", "våffeljärn", "våffla"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mkate wa sega la nyuki"),
            keywords: &["chuma", "kutoweza kufanya uamuzi", "mkate wa sega la nyuki"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வ\u{bbe}ஃபிள\u{bcd}"),
            keywords: &["இரும\u{bcd}பு", "உறுதியற\u{bcd}றது", "வ\u{bbe}ஃபிள\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వ\u{c47}ఫల\u{c4d}"),
            keywords: &["ఐరన\u{c4d}", "వ\u{c47}ఫల\u{c4d}", "సంద\u{c47}హం"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("วาฟเฟ\u{e34}ล"),
            keywords: &["วาฟเฟ\u{e34}ล", "เคร\u{e37}\u{e48}องทำขนม", "ไม\u{e48}ทราบ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("wafli"),
            keywords: &["demir", "ertirlik", "wafli", "ýaýdanjaň"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pani manifi"),
            keywords: &["pani manifi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("waffle"),
            keywords: &["hamur", "vafıl", "waffle"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("вафля"),
            keywords: &["вафельний", "вафля", "вафлі", "десерт", "сніданок"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ویفل"),
            keywords: &["فولاد", "متذبذب", "ویفل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("vafli"),
            keywords: &["qattiq", "vafli", "yumshoq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bánh quế"),
            keywords: &["bánh quế", "cứng cỏi", "thiếu quyết đoán"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("窩夫"),
            keywords: &["早餐", "窩夫", "軟", "鐵"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("窝夫"),
            keywords: &["窝夫", "软", "铁"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("华夫饼"),
            keywords: &["华夫饼", "格子饼", "点心", "烤", "窝夫饼"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("格子鬆餅"),
            keywords: &["格子鬆餅", "楓糖", "鐵"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("窩夫"),
            keywords: &["楓糖", "窩夫", "鐵"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-waffle"),
            keywords: &["i-ayoni", "i-indecive", "i-waffle"],
        },
    ],
};
#[doc = "🧀"]
pub const CHEESE_WEDGE: crate::Emoji = crate::Emoji {
    glyph: "🧀",
    codepoint: "1F9C0",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "cheese wedge",
    group: "Food & Drink",
    subgroup: "food-prepared",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kaaswiggie"),
            keywords: &["kaas", "kaaswiggie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የቺዝ ቁራጭ"),
            keywords: &["የቺዝ ቁራጭ", "ፒዝ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قطعة جبن"),
            keywords: &["جبن", "قطعة جبن"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চিজ ৱেজ"),
            keywords: &["চিজ", "চিজ ৱেজ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("pendir"),
            keywords: &["pendir"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кавалак сыру"),
            keywords: &["кавалак сыру", "сыр"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("резен сирене"),
            keywords: &["резен сирене", "сирене"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চীজ ওয\u{9bc}েজ"),
            keywords: &["চিজ", "চীজ ওয\u{9bc}েজ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("tamm formaj-laezh"),
            keywords: &["formaj-laezh", "keuz", "tamm formaj-laezh", "tamm keuz"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("komad sira"),
            keywords: &["komad sira", "sir"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("tall de formatge"),
            keywords: &["formatge", "tall", "tall de formatge"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏅᏗ ᎦᏚᏅ ᎠᎦᏯᎷᏴᎢ"),
            keywords: &["ᎤᏅᏗ ᎦᏚᏅ", "ᎤᏅᏗ ᎦᏚᏅ ᎠᎦᏯᎷᏴᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("klínek sýra"),
            keywords: &["klínek sýra", "sýr"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("darn o gaws"),
            keywords: &["caws", "darn o gaws"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("et stykke ost"),
            keywords: &["et stykke ost", "ost"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Käsestück"),
            keywords: &["Käse", "Käsestück"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κομμάτι τυρί"),
            keywords: &["κομμάτι τυρί", "τυρί"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("cheese wedge"),
            keywords: &["cheese", "cheese wedge"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cuña de queso"),
            keywords: &["cuña", "cuña de queso", "queso", "trozo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("queso"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("pedazo de queso"),
            keywords: &["pedazo de queso", "queso", "trozo"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("juustutükk"),
            keywords: &["juust", "juustutükk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gazta zatia"),
            keywords: &["gazta", "gazta zatia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قاچ پنیر"),
            keywords: &["قاچ پنیر", "پنیر"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("juustopala"),
            keywords: &["juusto", "juustopala"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("piraso ng keso"),
            keywords: &["dairy", "keso", "pagkain", "piraso ng keso"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("osta stykki"),
            keywords: &["matur", "osta stykki", "ostur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("part de fromage"),
            keywords: &["fromage", "part de fromage"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("morceau de fromage"),
            keywords: &["fromage", "morceau", "morceau de fromage"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ding cháise"),
            keywords: &["cáis", "ding cháise"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("staoig càise"),
            keywords: &["càise", "staoig càise"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("queixo"),
            keywords: &["queixo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચીઝનો ત\u{acd}રિકોણાકાર ટ\u{ac1}કડો"),
            keywords: &["ચીઝ", "ચીઝનો ત\u{acd}રિકોણાકાર ટ\u{ac1}કડો", "ટ\u{ac1}કડો"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mayankin cuku"),
            keywords: &["cuku", "mayankin cuku"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חריץ גבינה"),
            keywords: &["גבינה", "חריץ גבינה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पनीर का ट\u{941}कड\u{93c}ा"),
            keywords: &["पनीर", "पनीर का ट\u{941}कड\u{93c}ा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("komad sira"),
            keywords: &["komad sira", "sir"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("sajtdarab"),
            keywords: &["lyukas sajt", "sajt", "sajtdarab"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("պանրի կտոր"),
            keywords: &["պանիր", "պանրի կտոր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("irisan keju"),
            keywords: &["irisan keju", "keju"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("achịcha ụtọ ebere ebè"),
            keywords: &["achịcha ụtọ", "achịcha ụtọ ebere ebè"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("götóttur ostur"),
            keywords: &["götóttur ostur", "ostur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("fetta di formaggio"),
            keywords: &["fetta di formaggio", "formaggio"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("チーズ"),
            keywords: &["チーズ"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("keju sairis"),
            keywords: &["keju", "keju sairis"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ყველის ნაჭერი"),
            keywords: &["ყველი", "ყველის ნაჭერი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ірімшік бөлігі"),
            keywords: &["ірімшік", "ірімшік бөлігі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("et stykke ost"),
            keywords: &["et stykke ost", "ost"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ដ\u{17bb}\u{17c6}ឈ\u{17b8}ស"),
            keywords: &[
                "ឈ\u{17b8}ស",
                "ដ\u{17bb}\u{17c6}ឈ\u{17b8}ស",
                "ប\u{17d2}រហ\u{17bb}ក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಚೀಸ\u{ccd} ವ\u{cc6}ಡ\u{ccd}ಜ\u{ccd}"),
            keywords: &["ಚೀಸ\u{ccd}", "ಚೀಸ\u{ccd} ವ\u{cc6}ಡ\u{ccd}ಜ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("치즈 조각"),
            keywords: &["치즈", "치즈 덩어리", "치즈 조각"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("चिज व\u{947}ज"),
            keywords: &["चिज", "चिज व\u{947}ज"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кесилген сыр"),
            keywords: &["кесилген сыр", "сыр"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Stéck Kéis"),
            keywords: &["Kéis", "Stéck Kéis"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກ\u{ec9}ອນຊ\u{eb5}ສ"),
            keywords: &["ກ\u{ec9}ອນຊ\u{eb5}ສ", "ຊ\u{eb5}ດ", "ຊ\u{eb5}ສ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("sūrio gabaliukas"),
            keywords: &["sūrio gabaliukas", "sūris"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("siera šķēle"),
            keywords: &["siera šķēle", "siers"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("matakahi tīhi"),
            keywords: &["matakahi tīhi", "tīhi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("парче сирење"),
            keywords: &["парче сирење", "сирење"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d3e}ൽക\u{d4d}കട\u{d4d}ടി"),
            keywords: &["ചീസ\u{d4d}", "പ\u{d3e}ൽക\u{d4d}കട\u{d4d}ടി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зүсэм бяслаг"),
            keywords: &["бяслаг", "зүсэм", "хүнс"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चीज व\u{947}ज"),
            keywords: &["चीज व\u{947}ज", "चीझ"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("sepotong keju"),
            keywords: &["keju", "sepotong keju"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("biċċa ġobon"),
            keywords: &["biċċa ġobon", "ġobon"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဒ\u{102d}န\u{103a}ခ\u{1032} အတ\u{102f}\u{1036}း"),
            keywords: &[
                "ဒ\u{102d}န\u{103a}ခ\u{1032}",
                "ဒ\u{102d}န\u{103a}ခ\u{1032} အတ\u{102f}\u{1036}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("ostestykke"),
            keywords: &["ost", "ostestykke"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पनिर पिस\u{94d}न\u{947}"),
            keywords: &["पनिर", "पनिर पिस\u{94d}न\u{947}"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("stuk kaas"),
            keywords: &["kaas", "stuk kaas"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("ostestykke"),
            keywords: &["ost", "ostestykke"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଛେନ\u{b3e} ୱେଜ\u{b4d}"),
            keywords: &["ଛେନ\u{b3e}", "ଛେନ\u{b3e} ୱେଜ\u{b4d}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪਨੀਰ ਦਾ ਟ\u{a41}ਕੜਾ"),
            keywords: &["ਪਨੀਰ", "ਪਨੀਰ ਦਾ ਟ\u{a41}ਕੜਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پنیر گاڑنا"),
            keywords: &["پنیر", "پنیر گاڑنا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Chíz Wẹj"),
            keywords: &["Chiz", "Chíz Wẹj"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kawałek sera"),
            keywords: &["kawałek sera", "ser", "szwajcarski", "z dziurami", "żółty"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د پنیر پیښه"),
            keywords: &["د پنیر پیښه", "پنير، د پنير پاڼه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("queijo"),
            keywords: &["queijo", "queijo suíço"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("fatia de queijo"),
            keywords: &["fatia de queijo", "queijo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("kʼallpi masaramanta"),
            keywords: &["kʼallpi masaramanta", "masara"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bucată de brânză"),
            keywords: &["brânză", "bucată de brânză", "cașcaval"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1120"),
            keywords: &["E10-1120"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("сыр"),
            keywords: &["дырки", "желтый", "кусок", "сыр"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igisate cya foromaje"),
            keywords: &["foromaje", "igisate cya foromaje"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پنير پچر"),
            keywords: &["پنير", "پنير پچر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ච\u{dd3}ස\u{dca} පෙත\u{dca}ත"),
            keywords: &["ච\u{dd3}ස\u{dca}", "ච\u{dd3}ස\u{dca} පෙත\u{dca}ත"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kus syra"),
            keywords: &["kus syra", "syr"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kos sira"),
            keywords: &["kos sira", "sir"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gabal burcad"),
            keywords: &["burcad", "gabal burcad", "gabal burcad ah"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("copë djathi"),
            keywords: &["copë djathi", "djathë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кришка сира"),
            keywords: &["кришка сира", "сир"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kriška sira"),
            keywords: &["kriška sira", "sir"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ostbit"),
            keywords: &["ost", "ostbit"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kipande cha jibini"),
            keywords: &["jibini", "kipande cha jibini"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ப\u{bbe}ல\u{bbe}டைக\u{bcd} கட\u{bcd}டி"),
            keywords: &[
                "ச\u{bc0}ஸ\u{bcd}",
                "ப\u{bbe}ல\u{bbe}டை",
                "ப\u{bbe}ல\u{bbe}டைக\u{bcd} கட\u{bcd}டி",
                "ப\u{bbe}லேடு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("జున\u{c4d}నుల\u{c4b} భ\u{c3e}గం"),
            keywords: &["జున\u{c4d}ను", "జున\u{c4d}నుల\u{c4b} భ\u{c3e}గం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("пораи фонашакли панир"),
            keywords: &["панир", "пораи фонашакли панир"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เนยแข\u{e47}ง"),
            keywords: &["ช\u{e35}ส", "เนยแข\u{e47}ง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("peýnir bölegi"),
            keywords: &["peýnir", "peýnir bölegi"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("siisi"),
            keywords: &["siisi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("peynir dilimi"),
            keywords: &["peynir", "peynir dilimi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("پىشلاق پارچىسى"),
            keywords: &["پىشلاق", "پىشلاق پارچىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кусень сиру"),
            keywords: &["кусень сиру", "сир", "шматок сиру"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پنیر کا ٹکڑا"),
            keywords: &["ٹکڑا", "پنیر", "پنیر کا ٹکڑا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("pishloq bo‘lagi"),
            keywords: &["pishloq", "pishloq bo‘lagi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("miếng pho mát"),
            keywords: &["miếng pho mát", "phô mai"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("cëru fromaas"),
            keywords: &["cëru fromaas", "fromaas"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iverhe yetshizi"),
            keywords: &["itshizi", "iverhe yetshizi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Waara Wedge"),
            keywords: &["Waara Wedge", "wàrà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("芝士"),
            keywords: &["芝士"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("芝士"),
            keywords: &["芝士"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("芝士"),
            keywords: &["奶酪", "芝士", "起司"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("起士"),
            keywords: &["乳酪", "起士"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("芝士"),
            keywords: &["芝士"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ucezu lukashizi"),
            keywords: &["ucezu lukashizi", "ushizi"],
        },
    ],
};
#[doc = "🍖"]
pub const MEAT_ON_BONE: crate::Emoji = crate::Emoji {
    glyph: "🍖",
    codepoint: "1F356",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "meat on bone",
    group: "Food & Drink",
    subgroup: "food-prepared",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vleis aan been"),
            keywords: &["been", "vleis", "vleis aan been"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሥጋ ያለው አጥንት"),
            keywords: &["ሥጋ", "ሥጋ የለው አጥንት", "ሥጋ ያለው አጥንት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}لحم بعظم"),
            keywords: &["عظم", "\u{202b}لحم بعظم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হ\u{9be}ড\u{9bc} সহ ম\u{9be}ংস"),
            keywords: &[
                "ম\u{9be}ংস",
                "হ\u{9be}ড\u{9bc}",
                "হ\u{9be}ড\u{9bc} সহ ম\u{9be}ংস",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sümükdə ət"),
            keywords: &["sümük", "sümükdə ət", "ət"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мяса на косці"),
            keywords: &["косць", "мяса", "мяса на косці"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("месо с кост"),
            keywords: &["кост", "месо", "месо с кост"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হ\u{9be}ড\u{9bc}ের উপর ম\u{9be}ংস"),
            keywords: &[
                "ম\u{9be}ংস",
                "হ\u{9be}ড\u{9bc}",
                "হ\u{9be}ড\u{9bc}ের উপর ম\u{9be}ংস",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kig war askorn"),
            keywords: &["askorn", "kig", "kig war askorn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("meso na kostima"),
            keywords: &["kost", "meso", "meso na kostima"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("carn amb os"),
            keywords: &["carn", "carn amb os", "os"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄃𑄢\u{11127}𑄢\u{11127}𑄢\u{11134} 𑄦𑄬𑄢 𑄥𑄌\u{11134}"),
            keywords: &["𑄃𑄢\u{11127}𑄢\u{11127}𑄢\u{11134} 𑄦𑄬𑄢 𑄥𑄌\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎭᏫᏯ ᎦᏁᎦᎸ ᎪᎳ"),
            keywords: &["ᎪᎳ", "ᎭᏫᏯ", "ᎭᏫᏯ ᎦᏁᎦᎸ ᎪᎳ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("maso na kosti"),
            keywords: &["kost", "maso", "maso na kosti"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cig ar yr asgwrn"),
            keywords: &["asgwrn", "cig", "cig ar yr asgwrn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kød"),
            keywords: &["kød", "kødben"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Fleischhachse"),
            keywords: &["Fleisch", "Fleischhachse", "Knochen", "Restaurant"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κότσι"),
            keywords: &["κρέας", "κόκκαλο", "κότσι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("meat on bone"),
            keywords: &["bone", "meat", "meat on bone"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("carne con hueso"),
            keywords: &["carne", "carne con hueso", "hueso", "restaurante"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["carne", "carne con hueso", "comida", "hueso", "restaurante"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["carne", "carne con hueso", "comida", "hueso"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kondiga liha"),
            keywords: &["kondiga liha", "kont", "liha", "luu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("hezurra haragiarekin"),
            keywords: &["haragi", "hezur", "hezurra haragiarekin"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("گوشت با استخوان"),
            keywords: &["استخوان", "گوشت", "گوشت با استخوان"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("lihaa luineen"),
            keywords: &["liha", "lihaa luineen", "luu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("karneng may buto"),
            keywords: &["buto", "karne", "karneng may buto", "pagkain"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kjøt á beini"),
            keywords: &["bein", "kjøt", "kjøt á beini", "matur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("viande sur un os"),
            keywords: &["viande", "viande sur un os"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("viande sur son os"),
            keywords: &["os", "viande", "viande sur son os"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("feoil le cnámh"),
            keywords: &["cnámh", "feoil", "feoil ar an gcnámh", "feoil le cnámh"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("feòil air a’ chnàimh"),
            keywords: &["cnàimh", "feòil", "feòil air a’ chnàimh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("óso con carne"),
            keywords: &["carne", "óso", "óso con carne"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("હાડકા\u{a82} પરન\u{ac1}\u{a82} મા\u{a82}સ"),
            keywords: &[
                "મા\u{a82}સ",
                "ર\u{ac7}સ\u{acd}ટોરન\u{acd}ટ",
                "હાડકા\u{a82} પરન\u{ac1}\u{a82} મા\u{a82}સ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("nama a kan ƙashi"),
            keywords: &["nama", "nama a kan ƙashi", "ƙashi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("בשר על עצם"),
            keywords: &["בשר", "בשר על עצם", "עצם"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("हड\u{94d}डी वाला मा\u{901}स"),
            keywords: &[
                "मा\u{902}स",
                "र\u{947}स\u{94d}टोर\u{947}\u{902}ट",
                "हड\u{94d}डी वाला मा\u{901}स",
                "हड\u{94d}डी वाला मा\u{902}स",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("meso na kosti"),
            keywords: &["kost", "meso", "meso na kosti"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("csontos hús"),
            keywords: &["csont", "csontos hús", "hús"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ոսկորով միս"),
            keywords: &["միս", "ոսկոր", "ոսկորով միս"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("daging pada tulang"),
            keywords: &["daging", "daging pada tulang", "tulang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("anụ n’ọkpụkpụ"),
            keywords: &["anụ", "anụ n’ọkpụkpụ", "ọkpụkpụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kjöt"),
            keywords: &["bein", "kjöt", "veitingastaður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("carne"),
            keywords: &["carne", "carne con osso", "ristorante"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("骨付き肉"),
            keywords: &["もも肉", "肉", "骨付き肉"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("iwak daging sabalunge"),
            keywords: &["balung", "iwak daging", "iwak daging sabalunge"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ხორცი ძვალზე"),
            keywords: &["ძვალი", "ხორცი", "ხორცი ძვალზე"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сүйегі бар ет"),
            keywords: &["ет", "сүйегі бар ет", "сүйек"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kød"),
            keywords: &["kød", "kødben"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សាចជាប\u{17cb}ឆ\u{17d2}អ\u{17b9}ង"),
            keywords: &[
                "ឆ\u{17d2}អ\u{17b9}ង",
                "សាចជាប\u{17cb}ឆ\u{17d2}អ\u{17b9}ង",
                "សាច\u{17cb}ជាប\u{17cb}ឆ\u{17d2}អ\u{17b9}ង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮ\u{cc2}ಳ\u{cc6} ಮೇಲ\u{cbf}ನ ಮಾಂಸ"),
            keywords: &[
                "ಮಾಂಸ",
                "ಮ\u{cc2}ಳ\u{cc6} ಮಾಂಸ",
                "ಮ\u{cc2}ಳ\u{cc6} ಮೇಲ\u{cbf}ನ ಮಾಂಸ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("고기"),
            keywords: &["고기", "고기 덩어리"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("हाडाच\u{947}र मास"),
            keywords: &["मास", "हाड", "हाडाच\u{947}र मास"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жилик эт"),
            keywords: &["жилик эт", "сөөк", "эт"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Fleeschschank"),
            keywords: &["Fleesch", "Fleeschschank", "Schank"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຊ\u{eb5}\u{ec9}ນຕ\u{eb4}ດກະດ\u{eb9}ກ"),
            keywords: &[
                "ກະດ\u{eb9}ກ",
                "ຊ\u{eb5}\u{ec9}ນ",
                "ຊ\u{eb5}\u{ec9}ນຕ\u{eb4}ດກະດ\u{eb9}ກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mėsa ant kaulo"),
            keywords: &["kaulas", "mėsa", "mėsa ant kaulo"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kauls ar gaļu"),
            keywords: &["gaļa", "kauls", "kauls ar gaļu"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("mīti runga kōiwi"),
            keywords: &["kōiwi", "mīti", "mīti runga kōiwi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("месо со коска"),
            keywords: &["коска", "месо", "месо со коска"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മ\u{d3e}ംസം"),
            keywords: &[
                "എല\u{d4d}ലിൽ മ\u{d3e}ംസം",
                "എല\u{d4d}ല\u{d4d}ല\u{d4d}",
                "ഭക\u{d4d}ഷണം",
                "മ\u{d3e}ംസം",
                "ഹോട\u{d4d}ടൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ястай мах"),
            keywords: &["мах", "яс", "ястай мах"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("हाडावरील मा\u{902}स"),
            keywords: &["मटण", "हाड", "हाडावरील मा\u{902}स"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("daging salut tulang"),
            keywords: &["daging", "daging salut tulang", "tulang"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("laħam fuq l-għadma"),
            keywords: &["għadma", "laħam", "laħam fuq l-għadma"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အသားပါ အရ\u{102d}\u{102f}း"),
            keywords: &[
                "အရ\u{102d}\u{102f}းပါ အသြား အရ\u{102d}\u{102f}းပါ အသ\u{103d}ား အရ\u{102d}\u{102f}းပါ အသ\u{103e}ား အရ\u{103e}\u{102d}\u{102f}း အသ\u{103e}ား အသားပါ အရြ\u{102d}\u{102f}း အသားပါ အရ\u{102d}\u{102f}း",
                "အသားပါ အရ\u{102d}\u{102f}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kjøtt med bein"),
            keywords: &["kjøtt med bein", "kjøttbein", "restaurant"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("हड\u{94d}डिको मास\u{941}"),
            keywords: &["मास\u{941}", "हड\u{94d}डिको मास\u{941}", "हड\u{94d}डी"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vlees met bot"),
            keywords: &["bot", "vlees", "vlees met bot"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kjøt med bein"),
            keywords: &["kjøt med bein", "kjøtbein", "restaurant"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ହ\u{b3e}ଡରେ ଥ\u{b3f}ବ\u{b3e} ମ\u{b3e}ଂସ"),
            keywords: &[
                "ହ\u{b3e}ଡ । ମ\u{b3e}ଂସ",
                "ହ\u{b3e}ଡରେ ଥ\u{b3f}ବ\u{b3e} ମ\u{b3e}ଂସ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਹ\u{a71}ਡੀ ‘ਤ\u{a47} ਮੀਟ"),
            keywords: &["ਮੀਟ", "ਹ\u{a4b}ਟਲ", "ਹ\u{a71}ਡੀ ‘ਤ\u{a47} ਮੀਟ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہڈی تے گوشت"),
            keywords: &["گوشت", "ہڈی", "ہڈی تے گوشت"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mit Ọn Tọ\u{301}p Bon"),
            keywords: &["Bon", "Mit", "Mit Ọn Tọ\u{301}p Bon"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mięso z kością"),
            keywords: &["kość", "mięso", "mięso z kością"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د هډوکي غوښه"),
            keywords: &["د هډوکي غوښه", "هډوکي، غوښه، د هډوکي غوښه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("carne"),
            keywords: &["carne", "carne no osso", "osso"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("osso com carne"),
            keywords: &["carne", "osso", "osso com carne"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("aycha tullupi"),
            keywords: &["aycha", "aycha tullupi", "tullu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("os cu carne"),
            keywords: &["carne", "os", "os cu carne"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-283"),
            keywords: &["E10-283"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мясо на косточке"),
            keywords: &["кость", "мясо", "мясо на косточке"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("inyama y’igufwa"),
            keywords: &["igufa", "inyama", "inyama y’igufwa"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("هڏي تي گوشت"),
            keywords: &["هڏي تي گوشت", "هڏي، گوشت"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කට\u{dd4}වෙහ\u{dd2} මස\u{dca}"),
            keywords: &["කට\u{dd4}", "කට\u{dd4}වෙහ\u{dd2} මස\u{dca}", "මස\u{dca}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("mäso s kosťou"),
            keywords: &["kosť", "mäso", "mäso s kosťou"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("meso s kostjo"),
            keywords: &["kost", "meso", "meso s kostjo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("hilibka lafta"),
            keywords: &["hilib", "hilibka lafta", "laf"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("mish me kockë"),
            keywords: &["kockë", "mish", "mish me kockë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("месо са коском"),
            keywords: &["кoст", "мeсo", "месо са коском"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("meso sa koskom"),
            keywords: &["kost", "meso", "meso sa koskom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("köttben"),
            keywords: &["kött", "köttben", "på ben"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nyama kwenye mfupa"),
            keywords: &["mfupa", "nyama", "nyama kwenye mfupa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ம\u{bbe}மிசம\u{bcd}"),
            keywords: &[
                "உணவகம\u{bcd}",
                "எலும\u{bcd}பு",
                "ம\u{bbe}மிசம\u{bcd}",
                "விருந\u{bcd}து",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఎముకప\u{c48} మ\u{c3e}ంసం"),
            keywords: &[
                "ఎముకప\u{c48} మ\u{c3e}ంసం",
                "ఎముకల మ\u{c3e}ంసం",
                "మ\u{c3e}ంసం",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("гушт дар устухон"),
            keywords: &["гушт", "гушт дар устухон", "устухон"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เน\u{e37}\u{e49}อ"),
            keywords: &[
                "เน\u{e37}\u{e49}อ",
                "เน\u{e37}\u{e49}อต\u{e34}ดกระด\u{e39}ก",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("süňkli et"),
            keywords: &["et", "süňk", "süňkli et"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kanomate moe hui"),
            keywords: &["kanomate moe hui"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kemikli et"),
            keywords: &["kemikli et", "restoran"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سۆڭەكلىك گۆش"),
            keywords: &["سۆڭەك", "سۆڭەكلىك گۆش", "گۆش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("м’ясо на кістці"),
            keywords: &["кістка", "м’ясо", "м’ясо на кістці"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ہڈی پر گوشت"),
            keywords: &["اسنیک", "گوشت", "ہڈی", "ہڈی پر گوشت"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("suyakdagi go‘sht"),
            keywords: &["go‘sht", "suyak", "suyakdagi go‘sht"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("thịt bám xương"),
            keywords: &["thịt", "thịt bám xương", "xương"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("yàpp ci yax"),
            keywords: &["yax", "yàpp", "yàpp ci yax"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inyama esethanjeni"),
            keywords: &["inyama", "inyama esethanjeni", "ithambo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹran Ara Egungun"),
            keywords: &["eegun", "Ẹran Ara Egungun", "ẹran"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("肉連⻣"),
            keywords: &["肉", "肉連⻣", "骨"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("肉连⻣"),
            keywords: &["肉", "肉连⻣", "骨"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("排骨"),
            keywords: &["排骨", "肉", "骨"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("排骨"),
            keywords: &["帶骨肉", "排骨"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("肉骨"),
            keywords: &["大塊的肉", "肉骨", "骨的肉"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inyamo ethajeni"),
            keywords: &["inyama", "inyamo ethajeni", "ithambo"],
        },
    ],
};
#[doc = "🍗"]
pub const POULTRY_LEG: crate::Emoji = crate::Emoji {
    glyph: "🍗",
    codepoint: "1F357",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "poultry leg",
    group: "Food & Drink",
    subgroup: "food-prepared",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("pluimveeboudjie"),
            keywords: &["been", "boudjie", "hoender", "pluimvee", "pluimveeboudjie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የዶሮ እግር"),
            keywords: &["ሥጋ የለው አጥንት", "ሴት ዶሮ", "እግር", "የዶሮ እርባታ", "የዶሮ እግር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ساق دجاجة"),
            keywords: &["دجاجة", "ساق دجاجة", "عظم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9c1}ক\u{9c1}ৰ\u{9be} ম\u{9be}ংসৰ ঠেং"),
            keywords: &[
                "ক\u{9c1}ক\u{9c1}ৰ\u{9be}",
                "ক\u{9c1}ক\u{9c1}ৰ\u{9be} ম\u{9be}ংসৰ ঠেং",
                "ঠেং",
                "হ\u{9be}ড\u{9bc}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("toyuq budu"),
            keywords: &["ayaq", "cücə", "ev quşları", "sümük", "toyuq budu"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("курыная ножка"),
            keywords: &["косць", "курыная ножка", "курыца", "мяса птушкі", "нага"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Пилешко бутче"),
            keywords: &["Пилешко бутче", "бутче", "кост", "пиле", "пилешко"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("পোল\u{9cd}ট\u{9cd}রির প\u{9be}"),
            keywords: &[
                "চিকেন",
                "পোল\u{9cd}ট\u{9cd}রি",
                "পোল\u{9cd}ট\u{9cd}রির প\u{9be}",
                "লেগ",
                "হ\u{9be}ড\u{9bc}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("morzhed yar"),
            keywords: &["kig", "kig-yar", "morzhed", "yar"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("batak"),
            keywords: &["batak", "kost", "noga", "perad", "piletina"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cuixa de pollastre"),
            keywords: &["cuixa", "cuixa de pollastre", "pollastre"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄜𑄢\u{11127}𑄟\u{11127} 𑄛\u{1112a}𑄢\u{1112f} 𑄒\u{11133}𑄠\u{11101}"),
            keywords: &["𑄜𑄢\u{11127}𑄟\u{11127} 𑄛\u{1112a}𑄢\u{1112f} 𑄒\u{11133}𑄠\u{11101}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏥᏔᎦ ᎦᎦᎸ"),
            keywords: &["ᎦᏅᏍᎨᎾ", "ᎪᎳ", "ᏣᏔᎦ", "ᏥᏍᏆ ᎭᏫᏯ", "ᏥᏔᎦ ᎦᎦᎸ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kuřecí stehýnko"),
            keywords: &[
                "drůbež",
                "kost",
                "kuře",
                "kuřecí stehýnko",
                "noha",
                "stehno",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("coes o ffowls"),
            keywords: &["asgwrn", "coes", "coes o ffowls", "cyw iâr", "ffowls"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kyllingelår"),
            keywords: &["kylling", "kyllingelår"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Hähnchenschenkel"),
            keywords: &["Geflügel", "Hähnchenschenkel", "Restaurant"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Pouletschenkel"),
            keywords: &["Pouletschenkel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πόδι πουλερικού"),
            keywords: &[
                "κοτόπουλο",
                "κόκκαλο",
                "πουλερικό",
                "πόδι",
                "πόδι πουλερικού",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("poultry leg"),
            keywords: &["bone", "chicken", "drumstick", "leg", "poultry"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("muslo de pollo"),
            keywords: &["muslo", "muslo de pollo", "pollo", "restaurante"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("pata de pollo"),
            keywords: &["comida", "pata", "pata de pollo", "pollo", "restaurante"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["comida", "pata", "pata de pollo", "pollo"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kanakoib"),
            keywords: &["kana", "kanakoib", "koib", "kont", "luu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("izterra"),
            keywords: &["hanka", "hegazti", "hezur", "izter", "izterra", "oilasko"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ران ماکیان"),
            keywords: &["استخوان", "ران", "ماکیان", "مرغ", "پا"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kanankoipi"),
            keywords: &["kana", "kanankoipi", "koipi", "luu", "siipikarja"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("binti ng manok"),
            keywords: &[
                "binti ng manok",
                "buto",
                "drumstick",
                "hita",
                "hita ng manok",
                "manok",
                "pagkain",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("høsnaungalær"),
            keywords: &["bein", "høsnarungi", "høsnaungalær", "kjøt", "lær", "matur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cuisse de poulet"),
            keywords: &["cuisse de poulet", "poulet"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["cuisse", "cuisse de poulet", "os", "poulet", "volaille"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cos sicín"),
            keywords: &["cnámh", "cos", "sicín", "éineoil"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cas circe"),
            keywords: &["cas", "cas circe", "cearc", "cnàmh", "eunlaith"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("zanco de polo"),
            keywords: &["carne", "polo", "zanco de polo", "óso"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચિકન ટ\u{a82}ગડી"),
            keywords: &[
                "ચિકન ટ\u{a82}ગડી",
                "ટ\u{a82}ગડી",
                "પોલ\u{acd}ટ\u{acd}રી",
                "ર\u{ac7}સ\u{acd}ટોરન\u{acd}ટ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ƙafan kaji"),
            keywords: &["kaji", "kaza", "ƙafa", "ƙafan kaji", "ƙashi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שוק"),
            keywords: &["כרעיים", "עוף", "פולקע", "שוק"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चिकन ल\u{947}ग"),
            keywords: &[
                "चिकन ल\u{947}ग",
                "म\u{941}र\u{94d}गी की टा\u{901}ग",
                "म\u{941}र\u{94d}गीपालन",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("batak"),
            keywords: &["batak", "kost", "noga", "perad", "piletina"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("csirkecomb"),
            keywords: &["baromfi", "comb", "csirke", "csirkecomb", "csontos"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("հավի բուդ"),
            keywords: &["բուդ", "թռչնամիս", "հավ", "հավի բուդ", "ոսկոր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kaki ayam"),
            keywords: &["ayam", "kaki ayam", "paha", "tulang", "unggas"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụkwụ ụlọ ọkụkọ"),
            keywords: &["ọkpụkpụ", "ọkụkọ", "ụkwụ", "ụkwụ ụlọ ọkụkọ", "ụlọ ọkụkọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kjúklingaleggur"),
            keywords: &["fuglakjöt", "kjúklingaleggur", "kjúklingur", "leggur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("coscia di pollo"),
            keywords: &["coscia", "coscia di pollo", "pollo", "ristorante"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("鶏もも肉"),
            keywords: &["もも肉", "チキン", "肉", "骨付き肉", "鶏もも肉"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pupu sempol"),
            keywords: &["balung", "iwak ayam", "pupu", "sempol", "unggas"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ფრინველის ფეხი"),
            keywords: &["ფეხი", "ფრინველი", "ფრინველის ფეხი", "ქათამი", "ძვალი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тауықтың аяғы"),
            keywords: &["аяқ", "сүйек", "тауық", "тауықтың аяғы", "тауықтың саны"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kyllingelår"),
            keywords: &["kylling", "kyllingelår"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សាចភ\u{17d2}លៅ"),
            keywords: &[
                "ឆ\u{17d2}អ\u{17b9}ង",
                "ជើង",
                "បក\u{17d2}ស\u{17b8}",
                "ភ\u{17d2}លៅមាន\u{17cb}",
                "មាន\u{17cb}",
                "សាចភ\u{17d2}លៅ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕೋಳ\u{cbf} ಕಾಲು"),
            keywords: &["ಕೋಳ\u{cbf} ಕಾಲು", "ಕೋಳ\u{cbf} ಮಾಂಸ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("닭다리"),
            keywords: &["고기", "닭고기", "닭다리"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("कोमय\u{947}चो पाय"),
            keywords: &[
                "कोमय\u{947}च\u{947}\u{902}",
                "कोमय\u{947}चो पाय",
                "कोमी",
                "पाय",
                "मसगाची सा\u{902}ग",
                "हाड",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("канаттуунун сан эти"),
            keywords: &["канаттуунун сан эти", "сан эт", "сөөк", "тоок"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Pouletssträmpel"),
            keywords: &["Been", "Poulet", "Pouletssträmpel", "Schank", "Stämpel"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຂາໄກ\u{ec8}"),
            keywords: &["ກະດ\u{eb9}ກ", "ຂາ", "ຂາໄກ\u{ec8}", "ໄກ\u{ec8}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("paukščio šlaunelė"),
            keywords: &[
                "kaulas",
                "paukštiena",
                "paukščio šlaunelė",
                "višta",
                "šlaunis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("putna kāja"),
            keywords: &["gaļa", "kauls", "kāja", "putna kāja", "putns"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("waewae manu"),
            keywords: &["heihei", "kōiwi", "manu", "waewae"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("копан"),
            keywords: &["живина", "кокошка", "копан", "коска", "нога"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കോഴിക\u{d4d}ക\u{d3e}ൽ"),
            keywords: &[
                "ആഹ\u{d3e}രം",
                "കോഴിക\u{d4d}ക\u{d3e}ൽ",
                "ചിക\u{d4d}കൻ ക\u{d3e}ൽ",
                "ഭക\u{d4d}ഷണം",
                "ഹോട\u{d4d}ടൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("тахиан шарсан мөч"),
            keywords: &[
                "тахиа",
                "тахиан шарсан мөч",
                "тахианы шарсан мөч",
                "хөл",
                "шувуу",
                "яс",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("को\u{902}बडी, बदक इ पक\u{94d}षा\u{902}च\u{947} पाय"),
            keywords: &[
                "को\u{902}बडी",
                "को\u{902}बडी, बदक",
                "को\u{902}बडी, बदक इ पक\u{94d}षा\u{902}च\u{947} पाय",
                "को\u{902}बडी, बदक या\u{902}च\u{947} पाय",
                "पाय",
                "हाड",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("paha ayam"),
            keywords: &["ayam", "ayam/itik", "kaki", "paha ayam", "tulang"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("sieq ta’ tjur"),
            keywords: &["għadma", "sieq", "sieq ta’ tjur", "tiġieġa", "tjur"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကြက\u{103a}ပေါင\u{103a}"),
            keywords: &[
                "ကြက\u{103a}ခြေထောက\u{103a}",
                "ကြက\u{103a}င\u{103e}က\u{103a}",
                "ကြက\u{103a}ပေါင\u{103a}",
                "ကြက\u{103a}သား",
                "အရ\u{102d}\u{102f}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kyllinglår"),
            keywords: &[
                "fjærfe",
                "fjærkre",
                "kyllingklubbe",
                "kyllinglår",
                "restaurant",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("क\u{941}ख\u{941}राको फिला"),
            keywords: &[
                "क\u{941}ख\u{941}रा",
                "क\u{941}ख\u{941}राको फिला",
                "ख\u{941}ट\u{94d}टा",
                "पोल\u{94d}ट\u{94d}री",
                "हड\u{94d}डी",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kippenpoot"),
            keywords: &["bot", "gevogelte", "kip", "kippenpoot", "poot"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kyllinglår"),
            keywords: &[
                "fjørfe",
                "fjørkre",
                "kyllingklubbe",
                "kyllinglår",
                "restaurant",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b41}କ\u{b41}ଡ\u{b3c}\u{b3e} ଗୋଡ\u{b3c}"),
            keywords: &[
                "କ\u{b41}କ\u{b41}ଡ\u{b3c}\u{b3e} ଗୋଡ\u{b3c}",
                "ଗୋଡ\u{b3c}",
                "ପୋଲଟ\u{b4d}ର\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a41}\u{a71}ਕੜ ਦੀ ਲ\u{a71}ਤ"),
            keywords: &[
                "ਕ\u{a41}\u{a71}ਕੜ ਦੀ ਲ\u{a71}ਤ",
                "ਪ\u{a4b}ਲਟਰੀ",
                "ਮ\u{a41}ਰਗ\u{a47} ਦੀ ਲ\u{a71}ਤ",
                "ਲ\u{a71}ਤ",
                "ਹ\u{a4b}ਟਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ک\u{64f}کڑ دی لت"),
            keywords: &["لت", "مرغی", "پولٹری", "ک\u{64f}کڑ دی لت", "ہڈی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Póltrí Lẹg"),
            keywords: &[
                "Bon",
                "Chíkin",
                "Chíkin Lẹg Mídúl Pat",
                "Mídúl Pát Ọf Chíkin Lẹg",
                "Póltri",
                "Póltrí Lẹg",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("udko kurczaka"),
            keywords: &["nóżka", "udko kurczaka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د چرګانو پښه"),
            keywords: &["د چرګانو پښه", "هډوکی، چرګ، ډرمسټک، پښه، چرګ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("coxa de frango"),
            keywords: &["aves", "coxa", "coxa de frango", "coxinha"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("coxa de ave"),
            keywords: &["coxa", "coxa de ave", "frango", "galinha", "osso"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("chanka pollo"),
            keywords: &[
                "chanka",
                "corral pʼisqu",
                "pata de pollo nisqa",
                "pollo",
                "tullu",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pulpă de pasăre"),
            keywords: &["ciocănel", "pasăre", "pulpă", "pulpă de pasăre"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-284"),
            keywords: &["E10-284"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("куриная ножка"),
            keywords: &[
                "кость",
                "куриная ножка",
                "курица",
                "нога",
                "окорочок",
                "птица",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ukuguru kw’inkoko"),
            keywords: &["igufa", "inkoko", "ukuguru", "ukuguru kw’inkoko", "umushwi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مرغي جي ٽنگ"),
            keywords: &["مرغي جي ٽنگ", "هڏي، مرغي، ٽنگ، مرغي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dd4}ක\u{dd4}ළ\u{dd4} මස\u{dca} කක\u{dd4}ළ"),
            keywords: &[
                "කක\u{dd4}ළ",
                "කට\u{dd4}",
                "ක\u{dd4}ක\u{dd4}ළ\u{dd4} මස\u{dca}",
                "ක\u{dd4}ක\u{dd4}ළ\u{dd4} මස\u{dca} කක\u{dd4}ළ",
                "බ\u{dd2}ත\u{dca}තර",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kuracie stehno"),
            keywords: &["hydina", "kosť", "kuracie stehno", "mäso"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("piščančje bedro"),
            keywords: &["bedro", "kost", "perutnina", "piščanec", "piščančje bedro"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("lug diggaag"),
            keywords: &["diggaag", "diggaagga", "laf", "lug", "lug durbaan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kofshë pule"),
            keywords: &["kockë", "kofshë", "kofshë pule", "këmbë", "pulë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("батак"),
            keywords: &["батак", "живина", "кoст", "пилeтинa"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("batak"),
            keywords: &["batak", "kost", "piletina", "živina"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kycklinglår"),
            keywords: &["kyckling", "kycklinglår", "lår"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("paja la kuku"),
            keywords: &["kuku", "mfupa", "mguu", "ndege wanaofugwa", "paja la kuku"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சிக\u{bcd}கன\u{bcd} லெக\u{bcd}ப\u{bc0}ஸ\u{bcd}"),
            keywords: &[
                "எலும\u{bcd}புத\u{bcd}துண\u{bcd}டு",
                "கோழிக\u{bcd}கறி",
                "சிக\u{bcd}கன\u{bcd}",
                "சிக\u{bcd}கன\u{bcd} லெக\u{bcd}ப\u{bc0}ஸ\u{bcd}",
                "லெக\u{bcd} ப\u{bc0}ஸ\u{bcd}",
                "விருந\u{bcd}து",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c4b}డ\u{c3f} క\u{c3e}లు"),
            keywords: &[
                "క\u{c3e}లు",
                "క\u{c4b}డ\u{c3f}",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("линги мурғ"),
            keywords: &["линги мурғ", "мурғ", "пой", "устухон", "чӯҷа"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("น\u{e48}องไก\u{e48}"),
            keywords: &["น\u{e48}องไก\u{e48}", "ไก\u{e48}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("guş budy"),
            keywords: &[
                "aýak",
                "guş budy",
                "guş eti",
                "guşuň aýagy",
                "süňk",
                "towuk",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("vaʻeʻi-moa"),
            keywords: &["vaʻeʻi-moa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("tavuk butu"),
            keywords: &["but", "restoran", "tavuk", "tavuk butu"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("پۇت گۆش"),
            keywords: &["توخۇ", "سۆڭەك", "پۇت", "گۆش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("ніжка свійської птиці"),
            keywords: &["курка", "кістка", "ніжка", "ніжка свійської птиці", "птиця"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چکن کی ٹانگ"),
            keywords: &["اسنیک", "ٹانگ", "چکن", "چکن کی ٹانگ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("parranda oyog‘i"),
            keywords: &[
                "oyoq",
                "parranda",
                "parranda oyog‘i",
                "pishirilgan tovuq oyogʻi",
                "suyak",
                "tovuq",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đùi gia cầm"),
            keywords: &["chân", "gia cầm", "gà", "xương", "đùi gia cầm"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("tànku ginaar"),
            keywords: &["ginaar", "tànk", "tànku ginaar", "yax"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umlenze wehagu"),
            keywords: &["ihagu", "inkuku", "ithambo", "umlenze", "umlenze wehagu"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹsẹ Adiyẹ"),
            keywords: &["adìye", "eegun", "ilé àdìyé", "Ẹsẹ Adiyẹ", "ẹsẹ\u{300}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("雞肶"),
            keywords: &["家禽", "雞", "雞肶", "骨"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("鸡肶"),
            keywords: &["家禽", "骨", "鸡", "鸡肶"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("家禽的腿"),
            keywords: &["家禽", "家禽的腿", "鸡肉", "鸡腿"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("雞腿"),
            keywords: &["帶骨肉", "雞腿"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("雞髀"),
            keywords: &["雞肉", "雞腿", "雞鎚", "雞髀"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umlenze wenkukhu"),
            keywords: &["inkukhu", "ithambo", "umlenze", "umlenze wenkukhu"],
        },
    ],
};
#[doc = "🥩"]
pub const CUT_OF_MEAT: crate::Emoji = crate::Emoji {
    glyph: "🥩",
    codepoint: "1F969",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "cut of meat",
    group: "Food & Drink",
    subgroup: "food-prepared",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vleissnit"),
            keywords: &["skaaptjop", "steak", "tjop", "varktjop", "vleissnit"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቁራጭ ስጋ"),
            keywords: &["ቁራጭ ስጋ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قطعة لحم"),
            keywords: &["قطعة لحم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কট\u{9be} ম\u{9be}ংস"),
            keywords: &[
                "কট\u{9be} ম\u{9be}ংস",
                "ক\u{9be}টি থোৱ\u{9be}",
                "পৰ\u{9cd}কচপ",
                "লেম\u{9cd}বচপ",
                "ষ\u{9cd}টেক",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ət tikəsi"),
            keywords: &["steyk", "ət tikəsi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кавалак мяса"),
            keywords: &["адбіўная", "кавалак мяса", "свініна", "стэйк", "ягняціна"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("парче месо"),
            keywords: &[
                "агнешки котлет",
                "котлет",
                "парче месо",
                "свински котлет",
                "стек",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9be}ংশের ট\u{9c1}করো"),
            keywords: &[
                "চপ",
                "পর\u{9cd}কচপ",
                "ম\u{9be}ংশের ট\u{9c1}করো",
                "ল\u{9cd}য\u{9be}ম\u{9cd}বচপ",
                "স\u{9cd}টিক",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("tamm kig"),
            keywords: &["kostenn", "kostezenn", "ramskoaz", "tamm kig"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("odrezak mesa"),
            keywords: &[
                "janjeći odrezak",
                "odrezak",
                "odrezak mesa",
                "stejk",
                "svinjski odrezak",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("tall de carn"),
            keywords: &["bistec", "tall de carn", "tall de porc", "tall de xai"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄦𑄬𑄢 𑄘\u{1112e}𑄟"),
            keywords: &["𑄦𑄬𑄢 𑄘\u{1112e}𑄟"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎭᏫᏯ ᎠᎬᎭᎷᏴᎢ"),
            keywords: &["ᎤᏃᏕᎾ ᎭᏫᏯ", "ᎦᎷᏴ", "ᎭᏫᏯ", "ᎭᏫᏯ ᎠᎬᎭᎷᏴᎢ", "ᏏᏆ ᎭᏫᏯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("plátek masa"),
            keywords: &[
                "flákota",
                "hovězí",
                "jehněčí",
                "kotleta",
                "kus masa",
                "maso",
                "plátek masa",
                "steak",
                "vepřové",
                "řízek",
                "žebírko",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("toriad o gig"),
            keywords: &[
                "golwyth",
                "golwyth cig oen",
                "golwyth porc",
                "stecen",
                "toriad o gig",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kødudskæring"),
            keywords: &[
                "bøf",
                "kotelet",
                "kødudskæring",
                "lammekotelet",
                "svinekotelet",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Fleischstück"),
            keywords: &[
                "Fleischstück",
                "Kotelett",
                "Lammkotelett",
                "Schweinekotelett",
                "Steak",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κομμάτι κρέας"),
            keywords: &[
                "αρνίσιο παϊδάκι",
                "κομμάτι κρέας",
                "μπριζόλα",
                "παϊδάκι",
                "χοιρινή μπριζόλα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("cut of meat"),
            keywords: &["chop", "cut of meat", "lambchop", "porkchop", "steak"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("corte de carne"),
            keywords: &["carne", "chuleta", "corte de carne", "filete"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "chuleta",
                "chuleta de cordero",
                "chuleta de puerco",
                "corte de carne",
                "filete",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("lihalõik"),
            keywords: &[
                "karbonaad",
                "lambalihakarbonaad",
                "lihalõik",
                "praelõik",
                "sealihakarbonaad",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("haragi-mozketa"),
            keywords: &[
                "bildots-saiheski",
                "haragi-mozketa",
                "saiheski",
                "txerri-saiheski",
                "xerra",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("برش گوشت"),
            keywords: &[
                "استیک",
                "برش گوشت",
                "کوشت با استخوان دنده",
                "کوشت با استخوان گوسفند",
                "گوشت با استخوان خوک",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("lihanpala"),
            keywords: &[
                "kyljys",
                "lampaankyljys",
                "lihanpala",
                "pihvi",
                "porsaankyljys",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("hiwa ng karne"),
            keywords: &["chop", "hiwa ng karne", "lambchop", "porkchop", "steak"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kotelett"),
            keywords: &["búffur", "kjøt", "kotelett", "matur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("morceau de viande"),
            keywords: &[
                "côtelette",
                "côtelette de porc",
                "côtelette d’agneau",
                "morceau de viande",
                "steak",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("morceau de viande"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("gearradh feola"),
            keywords: &[
                "gearradh feola",
                "gríscín",
                "gríscín muiceola",
                "gríscín uaineola",
                "stéig",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("feòil"),
            keywords: &[
                "feòil",
                "mairtfheoil",
                "muicfheoil",
                "muiltfheoil",
                "sitheann",
                "staoig",
                "uainfheoil",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("costeleta"),
            keywords: &["año", "carne", "chuleta", "chuletón", "costeleta", "porco"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મા\u{a82}સનો ટ\u{ac1}કડો"),
            keywords: &[
                "ચોપ",
                "પોર\u{acd}કચોપ",
                "મા\u{a82}સનો ટ\u{ac1}કડો",
                "લ\u{ac7}મ\u{acd}બચોપ",
                "સ\u{acd}ટ\u{ac7}ક",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("yankan nama"),
            keywords: &[
                "naman shanu",
                "yanka",
                "yankan nama",
                "yankan naman alade",
                "yankan naman ɗan rago",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("נתח בשר"),
            keywords: &["אומצה", "נתח בשר", "סטייק", "סטייק לבן", "צלע כבש"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("गोश\u{94d}त का ट\u{941}कड\u{93c}ा"),
            keywords: &[
                "गोश\u{94d}त का ट\u{941}कड\u{93c}ा",
                "चॉप",
                "पोर\u{94d}कचॉप",
                "ल\u{948}म\u{94d}बचॉप",
                "स\u{94d}टीक",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("odrezak"),
            keywords: &["janjetina", "odrezak", "svinjetina"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("húsdarab"),
            keywords: &[
                "bárányszelet",
                "húsdarab",
                "hússzelet",
                "sertésszelet",
                "steak",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մսի կտոր"),
            keywords: &["կրծքամիս", "մսի կտոր", "ոսկրամիս", "տավար", "փափկամիս"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("potongan daging"),
            keywords: &[
                "babi",
                "daging",
                "domba",
                "irisan",
                "kambing",
                "potongan daging",
                "steak",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("bepụta anụ"),
            keywords: &[
                "anụ amịrị amị",
                "anụ atụrụ",
                "anụ ezi",
                "azụ anụ",
                "bepụta anụ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kjötsneið"),
            keywords: &[
                "kjötsneið",
                "kótiletta",
                "lambakótiletta",
                "steik",
                "svínakótiletta",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("taglio di carne"),
            keywords: &["taglio di carne"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ステーキ肉"),
            keywords: &["ステーキ", "ステーキ肉", "ビーフ", "ポーク", "ラム", "肉"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("daging sairis"),
            keywords: &["bistik", "daging sairis", "iwak daging", "samata"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ხორცის ნაჭერი"),
            keywords: &[
                "ანტრეკოტი",
                "რბილი ხორცი",
                "სტეიკი",
                "სუკი",
                "ხორცის ნაჭერი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ет кесімі"),
            keywords: &["ет кесімі"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សាច\u{17cb}ម\u{17bd}យដ\u{17bb}\u{17c6}"),
            keywords: &[
                "បន\u{17d2}ទះសាច\u{17cb}គោ",
                "បន\u{17d2}ទះសាច\u{17cb}ចៀម",
                "បន\u{17d2}ទះសាច\u{17cb}ជាប\u{17cb}ឆ\u{17d2}អ\u{17b9}ង",
                "បន\u{17d2}ទះសាច\u{17cb}ជ\u{17d2}រ\u{17bc}ក",
                "សាច\u{17cb}ម\u{17bd}យដ\u{17bb}\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಾಂಸದ ತುಂಡು"),
            keywords: &[
                "ಚೋಪ\u{ccd}",
                "ಪೋರ\u{ccd}ಕ\u{ccd}\u{200c}ಚೋಪ\u{ccd}",
                "ಮಾಂಸದ ತುಂಡು",
                "ಲ\u{ccd}ಯಾಂಬ\u{ccd}\u{200c}ಚೋಪ\u{ccd}",
                "ಸ\u{ccd}ಟೀಕ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("고깃덩이"),
            keywords: &["고깃덩이", "스테이크"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मासाचो क\u{941}डको"),
            keywords: &[
                "कातरप",
                "पॉर\u{94d}कचॉप",
                "मासाचो क\u{941}डको",
                "ल\u{901}बचोप",
                "स\u{94d}टिक",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("эттин кесими"),
            keywords: &[
                "козудан отбивной",
                "отбивной",
                "стейк",
                "чочко этинен отбивной",
                "эттин кесими",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Stéck Fleesch"),
            keywords: &[
                "Bifdeck",
                "Hämmelskotlett",
                "Kotlett",
                "Schwéngskotlett",
                "Stéck Fleesch",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຕ\u{ec8}ອນຊ\u{eb5}\u{ec9}ນ"),
            keywords: &[
                "ຊ\u{eb1}ອບ",
                "ຕ\u{ec8}ອນຊ\u{eb5}\u{ec9}ນ",
                "ພ\u{eb1}ອກຊ\u{eb1}ອບ",
                "ສະເຕ\u{eb1}ກ",
                "ແລມຊ\u{eb1}ອບ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mėsos gabalėliai"),
            keywords: &["kepsnys", "mėsos gabalėliai"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("gaļas gabals"),
            keywords: &[
                "cūkgaļas karbonāde",
                "gaļas gabals",
                "jēra karbonāde",
                "karbonāde",
                "steiks",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tapahitanga mīti"),
            keywords: &[
                "rara",
                "rara poaka",
                "rara reme",
                "tapahitanga mīti",
                "tēki",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("парче месо"),
            keywords: &["кременадла", "парче", "парче месо", "стек"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഇറച\u{d4d}ചിത\u{d4d}ത\u{d41}ണ\u{d4d}ടം"),
            keywords: &[
                "ആട\u{d4d}ടിറച\u{d4d}ചി",
                "ഇറച\u{d4d}ചിത\u{d4d}ത\u{d41}ണ\u{d4d}ടം",
                "പന\u{d4d}നിയിറച\u{d4d}ചി",
                "മ\u{d3e}ംസം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зүсэм мах"),
            keywords: &[
                "гахайн хэрчим мах",
                "зүсэм мах",
                "стейк",
                "хонины хэрчим мах",
                "хэрчим мах",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मटणचा त\u{941}कडा"),
            keywords: &[
                "चॉप",
                "पोर\u{94d}कचॉप",
                "मटणचा त\u{941}कडा",
                "ल\u{901}बचॉप",
                "स\u{94d}टीक",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("sepotong daging"),
            keywords: &["chop", "lambchop", "porkchop", "sepotong daging", "stik"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("biċċa laħam"),
            keywords: &[
                "biċċa",
                "biċċa laħam",
                "kustilja tal-majjal",
                "kustilja tal-muntun",
                "steak",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အသားပြား"),
            keywords: &[
                "ကင\u{103a}ရန\u{103a}အမ\u{1032}သား",
                "ဝက\u{103a}သားတ\u{102f}\u{1036}း",
                "သ\u{102d}\u{102f}းသား",
                "အတ\u{102f}\u{1036}း",
                "အသားပြား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kjøttstykke"),
            keywords: &[
                "biff",
                "kjøttstykke",
                "lammekotelett",
                "lammeskank",
                "svinekotelett",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("मास\u{941}को ट\u{941}क\u{94d}रा"),
            keywords: &[
                "बङ\u{94d}ग\u{941}रको मास\u{941}को ट\u{941}क\u{94d}रा",
                "भ\u{947}डाको मास\u{941}को ट\u{941}क\u{94d}रा",
                "मास\u{941}को ट\u{941}क\u{94d}रा",
                "मास\u{941}को स\u{947}क\u{941}वा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vlees"),
            keywords: &["biefstuk", "kotelet", "lamskotelet", "varkenslap", "vlees"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kjøtstykke"),
            keywords: &[
                "biff",
                "kjøtstykke",
                "lammekotelett",
                "lammeskank",
                "svinekotelett",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମ\u{b3e}ଂସ ଖଣ\u{b4d}ଡ"),
            keywords: &[
                "ଚପ\u{b4d}\u{200d}",
                "ପର\u{b4d}କଚପ\u{b4d}\u{200d}",
                "ମ\u{b3e}ଂସ ଖଣ\u{b4d}ଡ",
                "ଲ\u{b4d}ୟ\u{b3e}ମ\u{b4d}ବଚପ\u{b4d}\u{200d}",
                "ଷ\u{b4d}ଟୀକ\u{b4d}\u{200d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮੀਟ ਦਾ ਟ\u{a41}ਕੜਾ"),
            keywords: &[
                "ਕ\u{a71}ਟ",
                "ਮੀਟ ਦਾ ਟ\u{a41}ਕੜਾ",
                "ਲ\u{a47}ਲ\u{a47} ਦਾ ਕ\u{a71}ਟ",
                "ਸਟੀਕ",
                "ਸ\u{a42}ਰ ਦਾ ਕ\u{a71}ਟ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("گوشت دا ٹکڑا"),
            keywords: &[
                "د\u{64f}نبے دی چانپ",
                "سؤر دی چانپ",
                "سٹیک",
                "کاٹنا",
                "گوشت دا ٹکڑا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pís Ọf Mit"),
            keywords: &[
                "Bíg Pís Ọf Kaú Mit",
                "Bíg Pís Ọf Mit Wit Bon",
                "Bíg Pís Ọf Píg Mit Wit Bon",
                "Bíg Pís Ọf Ship-Pikin Mit Wit Bon",
                "Pís Ọf Mit",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kawałek mięsa"),
            keywords: &["kawałek mięsa"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د غوښې ټکړه"),
            keywords: &[
                "د غوښې ټکړه",
                "غوڅول، د غوښې ټکړه، د پيسه غوښه، د سور غوښه، تيکې",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("corte de carne"),
            keywords: &["bife", "corte de carne", "costeleta de porco"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("naco de carne"),
            keywords: &[
                "bife",
                "costeleta",
                "costeleta de cordeiro",
                "costeleta de porco",
                "naco de carne",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("chuleta aychamanta"),
            keywords: &[
                "aycha",
                "chuleta",
                "chuleta aychamanta",
                "chuleta corderomanta",
                "chuleta khuchimanta",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bucată de carne"),
            keywords: &["antricot", "bucată de carne", "cotlet", "friptură"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1093"),
            keywords: &["E10-1093"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("кусок мяса"),
            keywords: &["кусок", "кусок мяса", "мясо", "отбивная", "стейк"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("intongo ’inyama"),
            keywords: &[
                "intongo ’inyama",
                "inyama y’igufa",
                "inyama y’igufa y’ingurube",
                "inyama y’igufa y’intama",
                "siteke",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("گوشت جا وڍ"),
            keywords: &["سوئر جي چانپ، رڍ جي چانپ، چانپ، گوشت", "گوشت جا وڍ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මස\u{dca} කැප\u{dd3}ම\u{dca}"),
            keywords: &[
                "ඌර\u{dd4} මස\u{dca} පෙත\u{dca}ත",
                "බැටළ\u{dd4} මස\u{dca} පෙත\u{dca}ත",
                "මස\u{dca} කැප\u{dd3}ම\u{dca}",
                "මස\u{dca} පෙත\u{dca}ත",
                "ස\u{dca}ට\u{dd3}ක\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("plátok mäsa"),
            keywords: &["bravčové", "jahňacie", "plátok mäsa", "rezeň"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kos mesa"),
            keywords: &["kos mesa"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gooyo hilib"),
            keywords: &[
                "booddada",
                "gooyo hilib",
                "jar-jar",
                "jar-jar doofaar",
                "jar-jar nayl",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("mish tul"),
            keywords: &[
                "biftek",
                "copë mishi",
                "mish derri",
                "mish qengji",
                "mish tul",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("парче меса"),
            keywords: &["одрезак", "парче меса", "стејк", "шницла"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("parče mesa"),
            keywords: &["odrezak", "parče mesa", "stejk", "šnicla"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("styckdel"),
            keywords: &["fläskkotlett", "lammkotlett", "stek", "styckdel"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kipande cha nyama"),
            keywords: &[
                "kipande cha nyama",
                "kipande cha nyama ya kondoo",
                "kipande cha nyama ya nguruwe",
                "nyama",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("இறைச\u{bcd}சி"),
            keywords: &[
                "ஆட\u{bcd}டிறைச\u{bcd}சி",
                "இறைச\u{bcd}சி",
                "இறைச\u{bcd}சித\u{bcd} துண\u{bcd}டு",
                "பன\u{bcd}றி இறைச\u{bcd}சி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c3e}ంసపు ముక\u{c4d}క"),
            keywords: &[
                "గ\u{c4a}ర\u{c4d}ర\u{c46} మ\u{c3e}ంసపు ముక\u{c4d}క",
                "పంద\u{c3f} మ\u{c3e}ంసపు ముక\u{c4d}క",
                "మ\u{c3e}ంసపు ముక\u{c4d}క",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("буридаи гушт"),
            keywords: &[
                "бурида",
                "буридаи гушт",
                "буридаи гушти баррача",
                "буридаи гушти хук",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เน\u{e37}\u{e49}อห\u{e31}\u{e48}นช\u{e34}\u{e49}น"),
            keywords: &[
                "สเต\u{e47}ก",
                "ห\u{e31}\u{e48}น",
                "เน\u{e37}\u{e49}อห\u{e31}\u{e48}นช\u{e34}\u{e49}น",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("et dilimi"),
            keywords: &["doňuz kakmaç", "et dilimi", "guzy kakmaç", "kakmaç", "şara"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kanomate fahi"),
            keywords: &["kanomate fahi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("parça et"),
            keywords: &["biftek", "kuşbaşı", "parça et", "sote", "steak"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("گۆش پارچىسى"),
            keywords: &["توغرام", "قوي گۆشى", "پارچىسى", "چوشقا گۆشى", "گۆش پارچىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("мʼясний філей"),
            keywords: &[
                "бараняча відбивна",
                "котлета",
                "мʼясний філей",
                "свиняча котлета",
                "стейк",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گوشت کا ٹکڑا"),
            keywords: &["سو\u{651}ر کا گوشت", "چاپ", "گوشت کا ٹکڑا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("go‘sht bo‘lagi"),
            keywords: &["go‘sht bo‘lagi", "kesilgan", "lahm", "steyk"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tảng thịt"),
            keywords: &["bít tết", "sườn", "sườn cừu", "sườn lợn", "tảng thịt"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("dogu yàpp"),
            keywords: &[
                "bitik",
                "bitik xar",
                "bitik-mbaam xuux",
                "dogu yàpp",
                "steak",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umsiko wenyama"),
            keywords: &[
                "iqatha",
                "iqatha legusha",
                "iqatha lehagu",
                "isiqa senyama",
                "umsiko wenyama",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ìgé ẹran"),
            keywords: &[
                "ijẹ àgùntàn",
                "ijẹ ẹlẹ\u{301}dẹ\u{300}",
                "steak",
                "ìgé ẹran",
                "ìjẹun",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("肉塊"),
            keywords: &["扒", "牛扒", "羊扒", "肉塊", "豬扒"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("肉块"),
            keywords: &["扒", "牛扒", "猪扒", "羊扒", "肉块"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("肉块"),
            keywords: &["排骨", "牛排", "猪排", "羊排", "肉块"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("肉片"),
            keywords: &["肉片"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("肉塊"),
            keywords: &["牛扒", "羊扒", "肉塊", "豬扒"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ingxenyana yenyama"),
            keywords: &[
                "ingxenyana yenyama",
                "inyama",
                "inyama yemvu",
                "inyama yengulube",
                "isteki",
            ],
        },
    ],
};
#[doc = "🥓"]
pub const BACON: crate::Emoji = crate::Emoji {
    glyph: "🥓",
    codepoint: "1F953",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "bacon",
    group: "Food & Drink",
    subgroup: "food-prepared",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("spek"),
            keywords: &["kos", "spek", "vleis"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቤከን"),
            keywords: &["ምግብ", "ስጋ", "ቤከን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("لحم مقدد"),
            keywords: &["طعام", "لحم", "لحم خنزير مقدد", "لحم مقدد"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বেকন"),
            keywords: &["খ\u{9be}দ\u{9cd}য", "বেকন", "ম\u{9be}ংস"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("bekon"),
            keywords: &["bekon", "ət"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("бекон"),
            keywords: &["бекон", "ежа", "мяса"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("бекон"),
            keywords: &["бекон", "месо", "храна"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বেকন"),
            keywords: &["খ\u{9be}ব\u{9be}র", "বেকন", "ম\u{9be}ংশ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bacon"),
            keywords: &["bacon", "boued", "dijuniñ", "kig", "kig-sall"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("slanina"),
            keywords: &["doručak", "hrana", "meso", "slanina"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bacó"),
            keywords: &["bacó", "cansalada", "carn", "menjar", "porc", "viada"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄝𑄇\u{11127}𑄚\u{11134}"),
            keywords: &["𑄝𑄇\u{11127}𑄚\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎭᏫᏯ ᏗᎦᏒᏍᏔᏅ"),
            keywords: &["ᎠᎵᏍᏓᏴᏗ", "ᎭᏫᏯ", "ᎭᏫᏯ ᏗᎦᏒᏍᏔᏅ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("slanina"),
            keywords: &["jídlo", "maso", "slanina"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bacwn"),
            keywords: &["bacwn", "bwyd", "cig"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bacon"),
            keywords: &["bacon", "gris", "kød", "mad", "svinekød"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Bacon"),
            keywords: &["Bacon", "Essen", "Frühstücksspeck", "Speck"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μπέικον"),
            keywords: &["κρέας", "μπέικον", "τροφή"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("bacon"),
            keywords: &["bacon", "breakfast", "food", "meat"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("beicon"),
            keywords: &["bacon", "beicon", "carne", "comida", "panceta"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("tocino"),
            keywords: &["carne", "comida", "panceta", "tocino"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["carne", "comida", "desayuno", "tocino"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("peekon"),
            keywords: &["liha", "peekon", "toit"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("hirugiharra"),
            keywords: &["haragi", "hirugihar", "hirugiharra", "janari"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بیکن"),
            keywords: &[
                "بیکن",
                "غذا",
                "گوشت",
                "گوشت خوک سوده\u{200c}شده",
                "گوشت سوده\u{200c}شده",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pekoni"),
            keywords: &["liha", "pekoni", "ruoka"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bacon"),
            keywords: &["bacon", "karne", "pagkain"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("flesk"),
            keywords: &["flesk", "kjøt", "matur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("lard"),
            keywords: &["bacon", "lard", "viande"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("bacon"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bagún"),
            keywords: &["bagún", "bia", "feoil"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("beucon"),
            keywords: &["beucon", "biadh", "feòil"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("touciño"),
            keywords: &["carne", "comida", "touciño", "unto"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બ\u{ac7}કન"),
            keywords: &["બ\u{ac7}કન", "ભોજન", "મા\u{a82}સ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("naman alade"),
            keywords: &["abinci", "nama", "naman alade"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("בייקון"),
            keywords: &["בייקון", "חזיר", "לא כשר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ब\u{947}कन"),
            keywords: &["ब\u{947}कन", "भोजन", "मा\u{902}स"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("slanina"),
            keywords: &["hrana", "meso", "slanina"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szalonna"),
            keywords: &["bacon", "hús", "szalonna", "étel"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բեկոն"),
            keywords: &["բեկոն", "միս", "ուտելիք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("babi asap"),
            keywords: &["babi asap", "bacon", "bakon", "daging", "makanan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nri anụ"),
            keywords: &["anụ", "eghere eghe", "nri"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("beikon"),
            keywords: &["beikon", "kjöt", "matur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pancetta"),
            keywords: &["bacon", "carne", "cibo", "pancetta"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ベーコン"),
            keywords: &["ベーコン", "肉"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bakon"),
            keywords: &["bakon", "daging", "pangan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბეკონი"),
            keywords: &["ბეკონი", "ლორი", "საკვები", "ხორცი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сүрсүбе"),
            keywords: &["ет", "сүрсүбе", "тағам"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("bacon"),
            keywords: &["bacon", "gris", "kød", "mad", "svinekød"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សាច\u{17cb}ប\u{17b8}ជាន\u{17cb}"),
            keywords: &["សាច\u{17cb}", "សាច\u{17cb}ប\u{17b8}ជាន\u{17cb}", "អាហារ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{cc6}ಕಾನ\u{ccd}"),
            keywords: &["ಆಹಾರ", "ಬ\u{cc6}ಕಾನ\u{ccd}", "ಮಾಂಸ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("베이컨"),
            keywords: &["고기", "돼지고기", "베이컨", "식품"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ब\u{947}कन"),
            keywords: &["अन\u{94d}न", "ब\u{947}कन", "मास"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бекон"),
            keywords: &["бекон", "тамак", "эт"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Speck"),
            keywords: &["Fleesch", "Iessen", "Speck"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເບຄອນ"),
            keywords: &["ຊ\u{eb5}\u{ec9}ນ", "ອາຫານ", "ເບຄອນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kumpis"),
            keywords: &["kumpis", "maistas", "mėsa"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("bekons"),
            keywords: &["bekons", "gaļa", "ēdiens"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pēkana"),
            keywords: &["kai", "mīti", "pēkana"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("сланина"),
            keywords: &["месо", "сланина", "храна"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഉണക\u{d4d}കിയ പന\u{d4d}നിയിറച\u{d4d}ചി"),
            keywords: &[
                "ഇറച\u{d4d}ചി",
                "ഉണക\u{d4d}കിയ പന\u{d4d}നിയിറച\u{d4d}ചി",
                "പന\u{d4d}നിയിറച\u{d4d}ചി",
                "ഭക\u{d4d}ഷണം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гахайн мах"),
            keywords: &["гахайн мах", "мах", "хүнс", "өглөөний цай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ब\u{947}कन"),
            keywords: &["खाद\u{94d}य", "ब\u{947}कन", "मटण"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bakon"),
            keywords: &["bakon", "daging salai", "makanan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("bejken"),
            keywords: &["bejken", "ikel", "laħam"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဝက\u{103a}ပေါင\u{103a}ခြောက\u{103a}"),
            keywords: &[
                "ဝက\u{103a}ပေါင\u{103a}ခြောက\u{103a}",
                "အစားအသောက\u{103a}",
                "အသား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bacon"),
            keywords: &["bacon", "kjøtt", "mat"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ब\u{947}कन"),
            keywords: &["खाना", "ब\u{947}कन", "मास\u{941}"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bacon"),
            keywords: &["bacon", "vlees", "voedsel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bacon"),
            keywords: &["bacon", "kjøt", "mat"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3e}କନ\u{b4d}\u{200d}"),
            keywords: &[
                "ଖ\u{b3e}ଦ\u{b4d}ୟ",
                "ବ\u{b3e}କନ\u{b4d}\u{200d}",
                "ମ\u{b3e}ଂସ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a47}ਕਨ"),
            keywords: &["ਬ\u{a47}ਕਨ", "ਭ\u{a4b}ਜਨ", "ਮਾਸ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سور دا ل\u{64f}ونا گوشت"),
            keywords: &["خوراک", "سور دا ل\u{64f}ونا گوشت", "گوشت"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Békọn"),
            keywords: &["Brẹ\u{301}kfast", "Békọn", "Fud", "Mit"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("boczek"),
            keywords: &["bekon", "boczek", "jedzenie", "mięso"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د خنځير غوښه"),
            keywords: &["د خنځير غوښه", "د خنځير غوښه، خواړه، غوښه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bacon"),
            keywords: &["bacon", "comida", "toucinho"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("toucinho"),
            keywords: &["bacon", "carne", "comida", "toucinho"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tocino"),
            keywords: &["aycha", "mikhuna", "paqarin mikhuna", "tocino"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bacon"),
            keywords: &["bacon", "carne", "jambon", "mâncare", "șuncă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1071"),
            keywords: &["E10-1071"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("бекон"),
            keywords: &["бекон", "еда", "мясо"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("inyama y’ingurube"),
            keywords: &["ibiribwa", "inyama", "inyama y’ingurube"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سوئر جو نمڪين گوشت"),
            keywords: &["سوئر جو نمڪين گوشت", "سوئر جو گوشت، گوشت، کاڌو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බේකන\u{dca}"),
            keywords: &["කෑම", "බේකන\u{dca}", "මස\u{dca}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("slanina"),
            keywords: &["jedlo", "mäso", "slanina"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("slanina"),
            keywords: &["hrana", "meso", "slanina"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("hilib doofaar"),
            keywords: &["cunto", "hiib", "hilib doofaar"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("pastërma"),
            keywords: &["mish", "pastërma", "proshutë", "ushqim"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("сланина"),
            keywords: &["месо", "сланина", "храна"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("slanina"),
            keywords: &["hrana", "meso", "slanina"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("bacon"),
            keywords: &["bacon", "kött", "mat"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nyama"),
            keywords: &["chakula", "nyama"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பன\u{bcd}றி இறைச\u{bcd}சி"),
            keywords: &["அசைவம\u{bcd}", "இறைச\u{bcd}சி", "உணவு", "பன\u{bcd}றி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("పంద\u{c3f} మ\u{c3e}ంసం"),
            keywords: &["ఆహ\u{c3e}రం", "పంద\u{c3f} మ\u{c3e}ంసం", "మ\u{c3e}ంసం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("гушти хук"),
            keywords: &["гушт", "гушти хук", "ғизо"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เบคอน"),
            keywords: &["อาหาร", "เน\u{e37}\u{e49}อ", "เบคอน"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("bekon"),
            keywords: &["bekon", "ertirlik", "et", "iýmit"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pēkani"),
            keywords: &["pēkani"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("domuz pastırması"),
            keywords: &["domuz pastırması", "et", "yiyecek"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چوشقا كاۋىپى"),
            keywords: &["كاۋاپ", "يېمەكلىك", "چوشقا كاۋىپى", "گۆش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("бекон"),
            keywords: &["бекон", "м’ясо", "їжа"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سور کا نمکین گوشت"),
            keywords: &["خوراک", "سور", "سور کا نمکین گوشت", "نمکین", "گوشت"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("bekon"),
            keywords: &["bekon", "go‘sht", "taom"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("thịt xông khói"),
            keywords: &["thịt", "thịt xông khói", "thức ăn"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bekon"),
            keywords: &["bakon", "bekon", "lekk", "yàpp"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ispeke"),
            keywords: &["inyama", "ispeke", "ukutya"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹran Ẹlẹdẹ"),
            keywords: &["ónjẹ", "Ẹran Ẹlẹdẹ", "ẹran", "ẹran ẹlẹ\u{301}dẹ\u{300}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("煙肉"),
            keywords: &["煙肉", "肉", "食物"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("烟肉"),
            keywords: &["烟肉", "肉", "食物"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("培根"),
            keywords: &["培根", "熏肉", "肉", "食物"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("培根"),
            keywords: &["培根", "肉類", "食物"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("煙肉"),
            keywords: &["煙肉", "煙肉片", "食物"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubhekeni"),
            keywords: &["inyama", "ubhekeni", "ukudla"],
        },
    ],
};
#[doc = "🍔"]
pub const HAMBURGER: crate::Emoji = crate::Emoji {
    glyph: "🍔",
    codepoint: "1F354",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "hamburger",
    group: "Food & Drink",
    subgroup: "food-prepared",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("hamburger"),
            keywords: &["burger", "hamburger"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሃምበርገር"),
            keywords: &["ሃምበርገር", "በርገር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("همبرغر"),
            keywords: &["برغر", "مطعم", "همبرغر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হ\u{9be}মব\u{9be}ৰ\u{9cd}গ\u{9be}ৰ"),
            keywords: &[
                "ব\u{9be}ৰ\u{9cd}গ\u{9be}ৰ",
                "হ\u{9be}মব\u{9be}ৰ\u{9cd}গ\u{9be}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("hamburger"),
            keywords: &["burger", "hamburger"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("гамбургер"),
            keywords: &["бургер", "гамбургер", "фаст-фуд"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("хамбургер"),
            keywords: &["бургер", "сандвич", "хамбургер"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হ\u{9cd}য\u{9be}মব\u{9be}র\u{9cd}গ\u{9be}র"),
            keywords: &[
                "ব\u{9be}র\u{9cd}গ\u{9be}র",
                "হ\u{9cd}য\u{9be}মব\u{9be}র\u{9cd}গ\u{9be}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("hamburger"),
            keywords: &["burger", "hamburger"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("hamburger"),
            keywords: &["burger", "hamburger"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("hamburguesa"),
            keywords: &["hamburguesa"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎭᏫᏯ ᎠᏍᏛᎭᏟ"),
            keywords: &["ᎭᏫᏯ ᎠᏍᏛᎭᏟ", "ᏩᎧ ᎠᏍᏛᎭᏟ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("hamburger"),
            keywords: &["burger", "burgr", "hamburger", "hamburgr"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("hambyrgyr"),
            keywords: &["byrgyr", "hambyrgyr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("hamburger"),
            keywords: &["burger", "hamburger"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Hamburger"),
            keywords: &["Burger", "Hamburger", "Restaurant"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("χάμπουργκερ"),
            keywords: &["χάμπουργκερ"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("hamburger"),
            keywords: &["burger", "hamburger"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("beefburger"),
            keywords: &["beefburger", "burger", "hamburger"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("hamburger"),
            keywords: &["beefburger", "burger", "hamburger"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("hamburger"),
            keywords: &["burger", "hamburger"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("hamburguesa"),
            keywords: &["burger", "hamburguesa"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["comida", "hamburguesa"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("hamburger"),
            keywords: &["burger", "hamburger"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("hanburgesa"),
            keywords: &["hanburgesa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("همبرگر"),
            keywords: &["برگر", "همبرگر", "چیزبرگر"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hampurilainen"),
            keywords: &["hampurilainen", "jauhelihapihvi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("hamburger"),
            keywords: &["burger", "hamburger", "pagkain"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("burgari"),
            keywords: &[
                "burgari",
                "búfftvíflís",
                "búffur",
                "hamborgari",
                "hamburgari",
                "matur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("hamburger"),
            keywords: &["burger", "hamburger"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["burger", "hambourgeois", "hamburger"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("burgar"),
            keywords: &["burgar"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("hamburgair"),
            keywords: &["hamburgair"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("hamburguesa"),
            keywords: &["hamburguesa"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("હ\u{ac7}મબર\u{acd}ગર"),
            keywords: &[
                "બર\u{acd}ગર",
                "ર\u{ac7}સ\u{acd}ટોરન\u{acd}ટ",
                "હ\u{ac7}મબર\u{acd}ગર",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("hamburger"),
            keywords: &["burger", "hamburger"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("המבורגר"),
            keywords: &["בשר", "המבורגר", "לחמניה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ह\u{948}मबर\u{94d}गर"),
            keywords: &[
                "बर\u{94d}गर",
                "र\u{947}स\u{94d}टोर\u{947}\u{902}ट",
                "ह\u{948}मबर\u{94d}गर",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("hamburger"),
            keywords: &["burger", "hamburger"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("hamburger"),
            keywords: &["burger", "hambi", "hamburger"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("համբուրգեր"),
            keywords: &["բուրգեր", "համբուրգեր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("hamburger"),
            keywords: &["burger", "hamburger"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("achịcha nwere akwa"),
            keywords: &["achịcha bọga", "achịcha nwere akwa"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hamborgari"),
            keywords: &["borgari", "hamborgari", "veitingastaður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("hamburger"),
            keywords: &["burger", "hamburger"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ハンバーガー"),
            keywords: &["ハンバーガー", "バーガー"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("burger"),
            keywords: &["burger", "hamburger"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჰამბურგერი"),
            keywords: &["ბურგერი", "ჰამბურგერი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("гамбургер"),
            keywords: &["бургер", "гамбургер"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("hamburger"),
            keywords: &["hamburger"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ន\u{17c6}ហែមប\u{17ca}\u{17ba}ហ\u{17d2}គើ"),
            keywords: &[
                "ន\u{17c6}ប\u{17ca}\u{17ba}ហ\u{17d2}គើ",
                "ន\u{17c6}ហែមប\u{17ca}\u{17ba}ហ\u{17d2}គើ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹ\u{ccd}ಯಾಂಬರ\u{ccd}ಗರ\u{ccd}"),
            keywords: &["ಬರ\u{ccd}ಗರ\u{ccd}", "ಹ\u{ccd}ಯಾಂಬರ\u{ccd}ಗರ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("햄버거"),
            keywords: &["버거", "패스트푸드", "햄버거"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ह\u{945}मबर\u{94d}गर"),
            keywords: &["बर\u{94d}गर", "ह\u{945}मबर\u{94d}गर"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("гамбургер"),
            keywords: &["бургер", "гамбургер"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Hamburger"),
            keywords: &["Burger", "Hamburger"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແຮມເບ\u{eb5}ເກ\u{eb5}"),
            keywords: &["ເບ\u{eb5}ເກ\u{eb5}", "ແຮມເບ\u{eb5}ເກ\u{eb5}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mėsainis"),
            keywords: &["mėsainis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("hamburgers"),
            keywords: &["burgers", "hamburgers"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("hāmipēka"),
            keywords: &["hāmipēka", "pāki"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("хамбургер"),
            keywords: &["плескавица", "сендвич", "хамбургер"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഹ\u{d3e}ംബർഗർ"),
            keywords: &[
                "ആഹ\u{d3e}രം",
                "ബർഗർ",
                "ഭക\u{d4d}ഷണം",
                "ഹ\u{d3e}ംബർഗർ",
                "ഹോട\u{d4d}ടൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гамбургер"),
            keywords: &["бургер", "гамбургер"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("गोमा\u{902}साची वाटोळी तळल\u{947}ली वडी"),
            keywords: &[
                "गोमा\u{902}साची वाटोळी तळल\u{947}ली वडी",
                "बर\u{94d}गर",
                "ह\u{945}म\u{94d}बर\u{94d}गर",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("hamburger"),
            keywords: &["burger", "hamburger"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("hamburger"),
            keywords: &["burger", "hamburger"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဟမ\u{103a}ဘာဂါ"),
            keywords: &["ဘာဂျါ ဟမျဘာဂါ", "ဟမ\u{103a}ဘာဂါ"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hamburger"),
            keywords: &["burger", "hamburger", "restaurant"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ह\u{94d}यामबर\u{94d}गर"),
            keywords: &["बर\u{94d}गर", "ह\u{94d}यामबर\u{94d}गर"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("hamburger"),
            keywords: &["burger", "hamburger"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("hamburgar"),
            keywords: &["burgar", "hamburgar", "restaurant"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ହ\u{b3e}ମବର\u{b4d}ଗର\u{b4d}\u{200d}"),
            keywords: &[
                "ବର\u{b4d}ଗର\u{b4d}",
                "ହ\u{b3e}ମବର\u{b4d}ଗର\u{b4d}\u{200d}",
                "ହ\u{b3e}ମ\u{b4d}\u{200c}ବର\u{b4d}ଗର\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਹ\u{a48}ਮਬਰਗਰ"),
            keywords: &["ਬਰਗਰ", "ਹ\u{a48}ਮਬਰਗਰ", "ਹ\u{a4b}ਟਲ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہیم برگرز"),
            keywords: &["برگر", "ہیم برگرز"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Hámbọ\u{301}ga"),
            keywords: &["Bọ\u{301}ga", "Hámbọ\u{301}ga"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("hamburger"),
            keywords: &["fast food", "hamburger"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("هامبرګر"),
            keywords: &["برګر، هامبرګر", "هامبرګر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("hambúrguer"),
            keywords: &["búrguer", "hambúrguer"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["cheeseburger", "hambúrger", "hambúrguer"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("hamburgesa"),
            keywords: &["burger", "hamburgesa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("hamburger"),
            keywords: &["burger", "carne", "fast food", "hamburger"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-281"),
            keywords: &["E10-281"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("гамбургер"),
            keywords: &["бургер", "бутерброд", "гамбургер", "сэндвич", "фастфуд"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("hambaga"),
            keywords: &["hambaga"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("هيمبرگر"),
            keywords: &["برگر", "هيمبرگر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හැම\u{dca}බර\u{dca}ගර\u{dca}"),
            keywords: &["බර\u{dca}ගර\u{dca}ය", "හැම\u{dca}බර\u{dca}ගර\u{dca}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("hamburger"),
            keywords: &["hamburger"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("hamburger"),
            keywords: &["hamburger"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("hambaagar"),
            keywords: &["baagarka", "hambaagar"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("hamburger"),
            keywords: &["burger", "hamburger"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("хамбургер"),
            keywords: &["пљескавица", "хамбургeр", "хамбургер"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("hamburger"),
            keywords: &["hamburger", "pljeskavica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("hamburgare"),
            keywords: &["burgare", "hamburgare"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("hambaga"),
            keywords: &["baga", "hambaga"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பர\u{bcd}கர\u{bcd}"),
            keywords: &[
                "உணவகம\u{bcd}",
                "உணவு",
                "பர\u{bcd}கர\u{bcd}",
                "ஹம\u{bcd}பர\u{bcd}கர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("హ\u{c3e}ంబర\u{c4d}గర\u{c4d}"),
            keywords: &[
                "బర\u{c4d}గర\u{c4d}",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
                "హ\u{c3e}ంబర\u{c4d}గర\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("гамбургер"),
            keywords: &["бургер", "гамбургер"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แฮมเบอร\u{e4c}เกอร\u{e4c}"),
            keywords: &["เบอร\u{e4c}เกอร\u{e4c}", "แฮมเบอร\u{e4c}เกอร\u{e4c}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gamburger"),
            keywords: &["burger", "gamburger"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("hamipaka"),
            keywords: &["hamipaka"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("hamburger"),
            keywords: &["hamburger", "restoran"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ھامبۇرگ بولكىسى"),
            keywords: &["ياپما بولكا", "ھامبۇرگ بولكىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("гамбургер"),
            keywords: &["бургер", "гамбургер"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ہیم برگر"),
            keywords: &["اسنیک", "برگر", "ہیم برگر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("gamburger"),
            keywords: &["burger", "gamburger"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bánh hamburger"),
            keywords: &["bánh hamburger", "bánh kẹp"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("àmburgë"),
            keywords: &["bërgë", "àmburgë"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-hamburger"),
            keywords: &["i-hamburger", "ibhega"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Hamburger"),
            keywords: &["Hamburger", "bọ\u{301}gà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("漢堡包"),
            keywords: &["漢堡包"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("汉堡包"),
            keywords: &["汉堡包"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("汉堡"),
            keywords: &["汉堡", "汉堡包"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("漢堡"),
            keywords: &["漢堡", "漢堡包"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("漢堡包"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhega"),
            keywords: &["ibhega"],
        },
    ],
};
#[doc = "🍟"]
pub const FRENCH_FRIES: crate::Emoji = crate::Emoji {
    glyph: "🍟",
    codepoint: "1F35F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "french fries",
    group: "Food & Drink",
    subgroup: "food-prepared",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("aartappelskyfies"),
            keywords: &["aartappel", "aartappelskyfies", "skyfies", "tjips"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ፍሬንች ፍራይስ"),
            keywords: &["የፈረንሳይ", "ፍራይስ", "ፍሬንች ፍራይስ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بطاطس مقلية"),
            keywords: &["بطاطس مقلية", "مطعم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ফ\u{9cd}ৰেন\u{9cd}স ফ\u{9cd}ৰ\u{9be}ই"),
            keywords: &["ফ\u{9cd}ৰ\u{9be}ই", "ফ\u{9cd}ৰেন\u{9cd}স"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kartof qızartması"),
            keywords: &["fransız", "kartof qızartması", "qızartma"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("бульба фры"),
            keywords: &["бульба", "фаст-фуд", "фры"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("пържени картофи"),
            keywords: &["картофи", "пържени"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ফ\u{9cd}রেঞ\u{9cd}চ ফ\u{9cd}র\u{9be}ই"),
            keywords: &["ফ\u{9cd}র\u{9be}ই", "ফ\u{9cd}রেঞ\u{9cd}চ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("fritez"),
            keywords: &["fritez", "patatez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("pomfrit"),
            keywords: &["pomfrit"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("patates fregides"),
            keywords: &["fregides", "patates"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄜\u{11133}𑄢𑄬𑄚\u{11134}𑄌\u{11134} 𑄞𑄎"),
            keywords: &["𑄜\u{11133}𑄢𑄬𑄚\u{11134}𑄌\u{11134} 𑄞𑄎"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᎸᏥᏅᎾ ᏗᎬᏣᎳᏅᎯ"),
            keywords: &["ᎦᎸᏥᏅᎾ", "ᏗᎬᏣᎳᏅᎯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("hranolky"),
            keywords: &["bramborové", "brambory", "hranolky", "pomfrity"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sglodion"),
            keywords: &["sglodion"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("pomfritter"),
            keywords: &["pomfrit", "pomfritter", "pommes frites"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Pommes frites"),
            keywords: &["Fritten", "Pommes", "Pommes Frites", "Pommes frites"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τηγανητές πατάτες"),
            keywords: &["πατάτες", "τηγανητές πατάτες", "τηγανιτές"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("french fries"),
            keywords: &["french", "fries"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("chips"),
            keywords: &["chips", "french fries", "fries"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["chips", "fries"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("French fries"),
            keywords: &["French", "fries"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("patatas fritas"),
            keywords: &["papas fritas", "patatas", "patatas fritas", "restaurante"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("papas fritas"),
            keywords: &["comida", "hamburguesa", "papas fritas"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["comida", "papas fritas"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("friikartulid"),
            keywords: &["friikartul", "friikartulid"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("patata frijituak"),
            keywords: &["frijitu", "patata", "patata frijituak"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("سیب\u{200c}زمینی سرخ\u{200c}کرده"),
            keywords: &["سرخ\u{200c}کرده", "سیب\u{200c}زمینی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ranskalaiset"),
            keywords: &["ranskalaiset", "tikkuperunat"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("french fries"),
            keywords: &["french fries", "fries", "pagkain"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kips"),
            keywords: &["kips", "matur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("frites"),
            keywords: &["frites", "potatœs"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["frites", "patate"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("sceallóga"),
            keywords: &["sceallóga"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sliseagan"),
            keywords: &["sliseagan", "tiops"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("patacas fritas"),
            keywords: &["patacas fritas"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ફ\u{acd}ર\u{ac7}ન\u{acd}ચ ફ\u{acd}રાઇસ"),
            keywords: &[
                "ફ\u{acd}રાઇસ",
                "ફ\u{acd}ર\u{ac7}ન\u{acd}ચ ફ\u{acd}રાઇસ",
                "ર\u{ac7}સ\u{acd}ટોરન\u{acd}ટ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("soyayyen dankali"),
            keywords: &["dankali", "soyayye", "soyayyen dankali"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("צ׳יפס"),
            keywords: &["טוגנים", "ציפס", "צ׳יפס"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("फ\u{93c}\u{94d}र\u{947}\u{902}च फ\u{93c}\u{94d}राइस"),
            keywords: &[
                "फ\u{93c}\u{94d}राइस",
                "फ\u{93c}\u{94d}र\u{947}\u{902}च फ\u{93c}\u{94d}राइस",
                "र\u{947}स\u{94d}टोर\u{947}\u{902}ट",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("pomfrit"),
            keywords: &["krumpirić", "pomfrit", "prženo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("sült krumpli"),
            keywords: &["krumpli", "sült krumpli", "sültkrumpli"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տապակած կարտոֆիլ"),
            keywords: &["կարտոֆիլ", "տապակած կարտոֆիլ", "ֆրի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kentang goreng"),
            keywords: &["goreng", "kentang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ènyèrè eye frenchị"),
            keywords: &["frenchị", "ènyèrè eye frenchị", "èyèrè eye"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("franskar"),
            keywords: &["franskar", "franskar kartöflur", "veitingastaður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("patatine"),
            keywords: &["patatine", "patatine fritte", "ristorante"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("フライドポテト"),
            keywords: &["フライドポテト", "フレンチフライ", "ポテト", "ポテトフライ"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("balok kenthang goreng"),
            keywords: &["balok kenthang goreng", "goreng", "kenthang balok"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ფრი"),
            keywords: &["კარტოფილი", "ფრი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("фри"),
            keywords: &["француз", "фри"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("pomfritter"),
            keywords: &["pomfrit", "pomfritter", "pommes frites"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ដ\u{17c6}ឡ\u{17bc}ងចៀនច\u{17c6}ណ\u{17b7}ត"),
            keywords: &[
                "ដ\u{17c6}ឡ\u{17bc}ងចៀន",
                "ដ\u{17c6}ឡ\u{17bc}ងចៀនច\u{17c6}ណ\u{17b7}ត",
                "បារា\u{17c6}ង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಫ\u{ccd}ರ\u{cc6}ಂಚ\u{ccd} ಫ\u{ccd}ರೈ"),
            keywords: &["ಫ\u{ccd}ರ\u{cc6}ಂಚ\u{ccd} ಫ\u{ccd}ರೈ", "ಫ\u{ccd}ರೈಸ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("감자튀김"),
            keywords: &["감자튀김", "패스트푸드", "프렌치 프라이"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("फ\u{94d}र\u{947}\u{902}च फ\u{94d}राय"),
            keywords: &["फ\u{94d}राय", "फ\u{94d}र\u{947}\u{902}च"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("фри"),
            keywords: &["картошка фри", "фри"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Fritten"),
            keywords: &["Fritten"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ທອດມ\u{eb1}ນຝຣ\u{eb1}\u{ec8}ງ"),
            keywords: &[
                "ທອດມ\u{eb1}ນຝຣ\u{eb1}\u{ec8}ງ",
                "ມ\u{eb1}ນຝຣ\u{eb1}\u{ec8}ງທອດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("gruzdintos bulvytės"),
            keywords: &["bulvytės", "gruzdintos"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("frī kartupeļi"),
            keywords: &["frī", "kartupeļi"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ngā parai wīwī"),
            keywords: &["ngā parai wīwī", "parai", "wīwī"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("помфрит"),
            keywords: &["компир", "помфрит", "пржено"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഫ\u{d4d}രെഞ\u{d4d}ച\u{d4d} ഫ\u{d4d}രൈസ\u{d4d}"),
            keywords: &[
                "ഉര\u{d41}ളക\u{d4d}കിഴങ\u{d4d}ങ\u{d4d} ചിപ\u{d4d}\u{200c}സ\u{d4d}",
                "ഫിംഗർ ചിപ\u{d4d}സ\u{d4d}",
                "ഫ\u{d4d}രെഞ\u{d4d}ച\u{d4d} ഫ\u{d4d}രൈസ\u{d4d}",
                "ഭക\u{d4d}ഷണം",
                "ലഘ\u{d41} ഭക\u{d4d}ഷണം",
                "സ\u{d4d}\u{200c}ന\u{d3e}ക\u{d4d}\u{200c}സ\u{d4d}",
                "ഹോട\u{d4d}ടൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("шарсан төмс"),
            keywords: &["шарсан төмс"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("फ\u{94d}र\u{947}\u{902}च फ\u{94d}राइस"),
            keywords: &[
                "फ\u{94d}राइज",
                "फ\u{94d}र\u{947}\u{902}च",
                "फ\u{94d}र\u{947}\u{902}च फ\u{94d}राइस",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kentang goreng"),
            keywords: &["kentang goreng", "perancis"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ċips"),
            keywords: &["ċips"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အာလ\u{1030}းချောင\u{103a}းကြော\u{103a}"),
            keywords: &[
                "အာလ\u{1030}းကြော\u{103a}",
                "အာလ\u{1030}းချောင\u{103a}းကြော\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("pommes frites"),
            keywords: &["chips", "pommes frites", "restaurant", "stekte poteter"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("फ\u{94d}र\u{947}न\u{94d}च फ\u{94d}राइज"),
            keywords: &[
                "फ\u{94d}राइस",
                "फ\u{94d}र\u{947}न\u{94d}च",
                "फ\u{94d}र\u{947}न\u{94d}च फ\u{94d}राइज",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("patat"),
            keywords: &["frans", "frietjes", "patat"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("pommes frites"),
            keywords: &["chips", "pommes frites", "restaurant", "steikte poteter"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଫ\u{b4d}ରେଞ\u{b4d}ଚ\u{b4d} ଫ\u{b3e}ଇଜ\u{b4d}\u{200d}"),
            keywords: &[
                "ଫ\u{b3e}ଇଜ\u{b4d}\u{200d}",
                "ଫ\u{b4d}ରେଞ\u{b4d}ଚ",
                "ଫ\u{b4d}ରେଞ\u{b4d}ଚ\u{b4d} ଫ\u{b3e}ଇଜ\u{b4d}\u{200d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਫਰ\u{a48}\u{a02}ਚ ਫਰਾਈਜ\u{a3c}"),
            keywords: &[
                "ਤੜਕਾ",
                "ਫਰ\u{a48}\u{a02}ਚ ਫਰਾਈਜ\u{a3c}",
                "ਫ\u{a4d}ਰ\u{a48}\u{a02}ਚ ਤੜਕਾ",
                "ਹ\u{a4b}ਟਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چپس"),
            keywords: &["فرانس", "چپس"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Potétó Chips"),
            keywords: &["Frẹnch", "Potétó Chips"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("frytki"),
            keywords: &["frytki"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("چپس"),
            keywords: &["چپس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("batata frita"),
            keywords: &["batata frita", "fritas"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("batatas fritas"),
            keywords: &["batatas", "fritas"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("papas fritas"),
            keywords: &["fritas", "papas"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cartofi prăjiți"),
            keywords: &["cartofi", "cartofi prăjiți", "fast food"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-292"),
            keywords: &["E10-292"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("картофель фри"),
            keywords: &["картофель", "картошка", "фастфуд", "фри"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("amafiriti"),
            keywords: &["amafiriti"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("فرينچ فرائيز"),
            keywords: &["فرينچ فرائيز", "فرينچ، فرائيز"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ෆ\u{dca}\u{200d}රෙන\u{dca}ච\u{dca} ෆ\u{dca}රය\u{dd2}ස\u{dca}"),
            keywords: &[
                "ප\u{dca}\u{200d}රෙන\u{dca}ච\u{dca}",
                "ෆ\u{dca}\u{200d}රෙන\u{dca}ච\u{dca} ෆ\u{dca}රය\u{dd2}ස\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("hranolčeky"),
            keywords: &["hranolčeky", "pomfritky"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("krompirček"),
            keywords: &["krompirček", "ocvrt krompirček", "pomfrit"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("shiilid faransiis"),
            keywords: &["faransiis", "shiilid faransiis", "shiilidda"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("patate të skuqura"),
            keywords: &["patate", "patate të skuqura", "të skuqura"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("помфрит"),
            keywords: &["кромпир", "пoмфрит", "помфрит", "пржeнo"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("pomfrit"),
            keywords: &["krompir", "pomfrit", "prženo"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("pommes frites"),
            keywords: &["pommes", "pommes frites"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("chipsi"),
            keywords: &["chipsi", "vibanzi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஃபிரென\u{bcd}ச\u{bcd} ஃப\u{bcd}ரைஸ\u{bcd}"),
            keywords: &[
                "ஃபிரென\u{bcd}ச\u{bcd} ஃப\u{bcd}ரைஸ\u{bcd}",
                "உணவகம\u{bcd}",
                "உணவு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఫ\u{c4d}ర\u{c46}ంచ\u{c4d} ఫ\u{c4d}ర\u{c48}స\u{c4d}"),
            keywords: &[
                "ఫ\u{c4d}ర\u{c46}ంచ\u{c4d} ప\u{c4d}ర\u{c48}స\u{c4d}",
                "ఫ\u{c4d}ర\u{c46}ంచ\u{c4d} ఫ\u{c4d}ర\u{c48}స\u{c4d}",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
                "వ\u{c47}పుళ\u{c4d}లు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("картошка бирён"),
            keywords: &["бирён", "картошка бирён", "фаронсавӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เฟรนช\u{e4c}ฟราย"),
            keywords: &["ม\u{e31}นฝร\u{e31}\u{e48}งทอด", "เฟรนช\u{e4c}ฟราย"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("fransuz frisi"),
            keywords: &["fransuz", "fransuz frisi", "fri"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pateta fakapaku"),
            keywords: &["pateta fakapaku"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("patates kızartması"),
            keywords: &["kızartma patates", "patates kızartması", "restoran"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("فىرانسۇزچە قىزارتما"),
            keywords: &["فىرانسۇزچە", "قىزارتما"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("картопля фрі"),
            keywords: &["картопля", "фрі"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("فرنچ فرائز"),
            keywords: &["اسنیک", "فرائز", "فرنچ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qovurilgan fri-kartoshka"),
            keywords: &["fransuz", "kartoshka-fri", "qovurilgan fri-kartoshka"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("khoai tây chiên"),
            keywords: &["khoai tây chiên", "kiểu pháp"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("pombiteer buñ saaf"),
            keywords: &["buñ saaf", "pombiteer", "pombiteer buñ saaf"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-french fries"),
            keywords: &["i-french", "i-french fries", "i-fries"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ounjẹ Ipanu Didun"),
            keywords: &["Ounjẹ Ipanu Didun", "didin", "french"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("薯條"),
            keywords: &["法國", "薯條"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("薯条"),
            keywords: &["法国", "薯条"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("薯条"),
            keywords: &["油炸", "薯条"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("薯條"),
            keywords: &["炸薯條", "薯條"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("amafrayizi"),
            keywords: &["amafrayizi", "amashibusi"],
        },
    ],
};
#[doc = "🍕"]
pub const PIZZA: crate::Emoji = crate::Emoji {
    glyph: "🍕",
    codepoint: "1F355",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "pizza",
    group: "Food & Drink",
    subgroup: "food-prepared",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("pizza"),
            keywords: &["kaas", "kos", "pizza", "skyf"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ፒዛ"),
            keywords: &["ቁራሽ", "ቺዝ", "ፒዛ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بيتزا"),
            keywords: &["بيتزا", "مطعم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("পিজ\u{9cd}জ\u{9be}"),
            keywords: &["চীজ", "ট\u{9c1}ক\u{9c1}ৰ\u{9be}", "পিজ\u{9cd}জ\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("pizza"),
            keywords: &["dilim", "pendir", "pizza"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("піца"),
            keywords: &["кавалак", "піца", "сыр", "фаст-фуд"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("пица"),
            keywords: &["парче", "пица", "резен"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("পিজ\u{9be}"),
            keywords: &["চিজ", "পিজ\u{9be}", "ফ\u{9be}লি"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pizza"),
            keywords: &[
                "formaj-laezh",
                "keuz",
                "pizza",
                "tamm formaj-laezh",
                "tamm keuz",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("pizza"),
            keywords: &["komad", "pizza", "sir"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pizza"),
            keywords: &["formatge", "pizza", "porció", "tall"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄛\u{11128}𑄎"),
            keywords: &["𑄛\u{11128}𑄎"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᏓᎲᏢᏅ ᎠᎩᏍᏗ"),
            keywords: &["ᎠᏍᏓᎲᏢᏅ ᎠᎩᏍᏗ", "ᎤᏅᏗ ᎦᏚᏅ", "ᎦᎬᎭᎷᏴ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("pizza"),
            keywords: &[
                "díl",
                "dílek",
                "klínek",
                "kousek",
                "pizza",
                "salám",
                "salámová",
                "sýr",
                "sýrová",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("pitsa"),
            keywords: &["caws", "darn", "pitsa"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("pizza"),
            keywords: &["pizza", "pizzastykke", "stykke pizza"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Pizza"),
            keywords: &["Pizza", "Pizzastück", "Pizzeria"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πίτσα"),
            keywords: &["κομμάτι", "πίτσα", "τυρί"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("pizza"),
            keywords: &["cheese", "pizza", "slice"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pizza"),
            keywords: &["pizza", "porción", "restaurante"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["comida", "pizza", "porción", "restaurante"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["pizza", "queso", "rebanada"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("pitsa"),
            keywords: &["juust", "pitsa", "pizza", "viil"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("pizza"),
            keywords: &["gazta", "pizza", "zati"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پیتزا"),
            keywords: &["قاچ", "پنیر", "پیتزا"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pizza"),
            keywords: &["juusto", "pizza", "siivu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pizza"),
            keywords: &["italian", "keso", "pagkain", "pizza", "slice"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("pitsaflís"),
            keywords: &["flís", "matur", "pitsa", "pitsaflís", "pizza"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("pizza"),
            keywords: &["fromage", "part", "pizza"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("píotsa"),
            keywords: &["Iodálach", "bialann", "pizza", "píotsa", "slisín"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("pizza"),
            keywords: &["càise", "pizza", "slis", "sliseag"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("pizza"),
            keywords: &["pizza", "porción"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પિઝા"),
            keywords: &["પિઝા", "ર\u{ac7}સ\u{acd}ટોરન\u{acd}ટ", "સ\u{acd}લાઇસ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("pizza"),
            keywords: &["cuku", "pizza", "yanki"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פיצה"),
            keywords: &["משולש", "פיצה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पिज\u{93c}\u{94d}ज\u{93c}ा स\u{94d}लाइस"),
            keywords: &[
                "पिज\u{93c}\u{94d}ज\u{93c}ा",
                "र\u{947}स\u{94d}टोर\u{947}\u{902}ट",
                "स\u{94d}लाइस",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("pizza"),
            keywords: &["kriška", "pizza", "sir"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("pizza"),
            keywords: &["pizza", "sajtos", "szelet"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("պիցցա"),
            keywords: &["կտոր", "պանիր", "պիցցա"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pizza"),
            keywords: &["keju", "pizza", "potongan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("pizzà"),
            keywords: &["achịcha ụtọ", "ebèrè èbe", "pizzà"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("pítsusneið"),
            keywords: &["ostur", "pítsa", "pítsusneið", "sneið"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pizza"),
            keywords: &["fetta", "pizza", "ristorante"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ピザ"),
            keywords: &["チーズ", "ピザ", "ピッツァ"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pizza keju"),
            keywords: &["keju", "pizza", "sairis"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("პიცა"),
            keywords: &["ნაჭერი", "პიცა", "ყველი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("пицца"),
            keywords: &["бөлік", "пицца", "ірімшік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("pizza"),
            keywords: &["pizza", "pizzastykke", "stykke pizza"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ភ\u{17b8}ហ\u{17d2}សាម\u{17bd}យច\u{17c6}ន\u{17b7}ត"),
            keywords: &[
                "ភ\u{17b8}ហ\u{17d2}សា",
                "ភ\u{17b8}ហ\u{17d2}សាម\u{17bd}យច\u{17c6}ន\u{17b7}ត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪ\u{cbf}ಜ\u{ccd}ಜಾ"),
            keywords: &[
                "ಪ\u{cbf}ಜ\u{ccd}ಜಾ",
                "ಪ\u{cbf}ಜ\u{ccd}ಜಾ ಸ\u{ccd}ಲೈಸ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("피자"),
            keywords: &["조각 피자", "피자", "피자 한 조각"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पिझ\u{94d}झा"),
            keywords: &["चिज", "पिझ\u{94d}झा", "स\u{94d}लायस"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("пицца"),
            keywords: &["кесинди", "пицца", "сыр"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Pizza"),
            keywords: &["Kéis", "Pizza", "Stéck"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພ\u{eb4}ຊຊ\u{ec8}າ"),
            keywords: &["ພ\u{eb4}ຊຊ\u{ec8}າ", "ພ\u{eb4}ດຊາ", "ພ\u{eb4}ດຊ\u{ec8}າ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("pica"),
            keywords: &["gabalėlis", "pica", "sūris"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pica"),
            keywords: &["pica", "šķēle"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("parehe"),
            keywords: &["parehe", "poro", "tīhi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("пица"),
            keywords: &["парче", "пица", "сирење"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പിസ"),
            keywords: &[
                "ആഹ\u{d3e}രം",
                "പിസ",
                "പിസ സ\u{d4d}ലൈസ\u{d4d}",
                "ഭക\u{d4d}ഷണം",
                "ഹോട\u{d4d}ടൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("пицца"),
            keywords: &["бяслаг", "зүсэм", "пицца"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पिझ\u{94d}झा"),
            keywords: &["चीझ", "पिझ\u{94d}झा", "स\u{94d}लाइस"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("piza"),
            keywords: &["keju", "keping", "piza"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("pizza"),
            keywords: &["pizza", "slajs", "ġobon"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပ\u{102e}ဇာ"),
            keywords: &["ဒ\u{102d}န\u{103a}ခ\u{1032}", "ပ\u{102e}ဇာ", "အချပ\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("pizzastykke"),
            keywords: &["pizza", "pizzabit", "pizzastykke", "restaurant"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पिज\u{94d}जा"),
            keywords: &["पिज\u{94d}जा", "स\u{94d}लाइस"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("pizzapunt"),
            keywords: &["kaas", "pizzapunt", "punt"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("pizzastykke"),
            keywords: &["pizza", "pizzabit", "pizzastykke", "restaurant"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଫ\u{b3f}ଜ\u{b4d}ଜ\u{b3e}"),
            keywords: &[
                "ଖଣ\u{b4d}ଡ",
                "ଛେନ\u{b4d}ନ\u{b3e}",
                "ପ\u{b3f}ଜ\u{b4d}ଜ\u{b3e}",
                "ଫ\u{b3f}ଜ\u{b4d}ଜ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪੀਜ\u{a3c}ਾ"),
            keywords: &["ਟ\u{a41}ਕੜਾ", "ਪੀਜ\u{a3c}ਾ", "ਹ\u{a4b}ਟਲ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پیزا"),
            keywords: &["قاش", "پنیر", "پیزا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Píza"),
            keywords: &["Chiz", "Pis", "Píza"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pizza"),
            keywords: &["kawałek pizzy", "pizza"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پیزا"),
            keywords: &["پنير، پيزا، ټکړه", "پیزا"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pizza"),
            keywords: &["fatia de pizza", "pizza"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("piza"),
            keywords: &["fatia", "piza", "queijo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("piza"),
            keywords: &["masara", "pedazo", "piza"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pizza"),
            keywords: &["fast food", "felie", "pizza"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-282"),
            keywords: &["E10-282"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("пицца"),
            keywords: &["кусок", "кусок пиццы", "пицца", "сыр"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("piza"),
            keywords: &["foromaje", "igisate", "piza"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پيزا"),
            keywords: &["پنير، ٽڪڙا", "پيزا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd3}ස\u{dcf}"),
            keywords: &["ච\u{dd3}ස\u{dca}", "ප\u{dd3}ස\u{dcf}", "පෙත\u{dca}ත"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("pizza"),
            keywords: &["pizza", "syr"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("pica"),
            keywords: &["pica", "rezina", "sir"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("pizza-da"),
            keywords: &["Pizza-da", "burcad", "cad", "pizza-da"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("pica"),
            keywords: &["djathtë", "fetë", "pica"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("пица"),
            keywords: &["парче", "пица", "сир"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("pica"),
            keywords: &["parče", "pica", "sir"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("pizzabit"),
            keywords: &["bit", "pizza", "pizzabit"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("piza"),
            keywords: &["jibini", "kipande", "piza"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ப\u{bc0}ட\u{bcd}ச\u{bbe}"),
            keywords: &[
                "ச\u{bc0}ஸ\u{bcd}",
                "துரித உணவு",
                "ப\u{bc0}ட\u{bcd}ச\u{bbe}",
                "ப\u{bc0}ட\u{bcd}ச\u{bbe} துண\u{bcd}டு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c3f}జ\u{c4d}జ\u{c3e}"),
            keywords: &[
                "ప\u{c3f}జ\u{c4d}జ\u{c3e}",
                "ముక\u{c4d}క",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
                "స\u{c4d}ల\u{c48}స\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("питса"),
            keywords: &["панир", "питса", "порча"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("พ\u{e34}ซซ\u{e48}า 1 ช\u{e34}\u{e49}น"),
            keywords: &[
                "พ\u{e34}ซซ\u{e48}า",
                "พ\u{e34}ซซ\u{e48}า 1 ช\u{e34}\u{e49}น",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("pizza"),
            keywords: &["dilim", "peýnir", "pizza"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pisa"),
            keywords: &["pisa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("pizza dilimi"),
            keywords: &["dilim", "pizza", "pizza dilimi", "restoran"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("پىتسا"),
            keywords: &["پارچە", "پىتسا", "پىشلاق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("піца"),
            keywords: &["піца", "сир", "шматок"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پزا"),
            keywords: &["اسنیک", "ٹکڑا", "پزا", "پنیر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("pitsa"),
            keywords: &["bo‘lak", "pishloq", "pitsa"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bánh pizza"),
            keywords: &["bánh pizza", "lát", "phô mai"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("pizza"),
            keywords: &["dagg", "fromaas", "pizza"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-pizza"),
            keywords: &["i-pizza", "icala", "itshizi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Písà"),
            keywords: &["Písà", "gígé", "wàrà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("薄餅"),
            keywords: &["片", "芝士", "薄餅"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("薄饼"),
            keywords: &["片", "芝士", "薄饼"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("披萨"),
            keywords: &["披萨"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("披薩"),
            keywords: &["披薩", "起士披薩"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("薄餅"),
            keywords: &["一塊薄餅", "一片薄餅", "薄餅"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ipiza"),
            keywords: &["ipiza", "ucezu", "ushizi"],
        },
    ],
};
#[doc = "🌭"]
pub const HOT_DOG: crate::Emoji = crate::Emoji {
    glyph: "🌭",
    codepoint: "1F32D",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "hot dog",
    group: "Food & Drink",
    subgroup: "food-prepared",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("worsbroodjie"),
            keywords: &["brood", "kos", "wors", "worsbroodjie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሃት ዶግ"),
            keywords: &["ሃት ዶግ", "ሃትዶግ", "ቋሊማ", "ፋራንክፉተር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("هوت دوغ"),
            keywords: &["سجق", "نقانق", "هوت دوغ"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হট ডগ"),
            keywords: &[
                "চচেজ",
                "ফ\u{9cd}ৰেংকফ\u{9be}ৰ\u{9cd}ট\u{9be}ৰ",
                "হট ডগ",
                "হটডগ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("hot doq"),
            keywords: &["frankfurter", "hot doq", "hotdoq", "sosiska"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("хот-дог"),
            keywords: &["булка", "сасіска", "фаст-фуд", "хот-дог"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("хотдог"),
            keywords: &["кренвирш", "наденица", "хотдог"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হট ডগ"),
            keywords: &[
                "ফ\u{9cd}র\u{9cd}য\u{9be}ঙ\u{9cd}কফ\u{9be}র\u{9cd}ট\u{9be}র",
                "সসেজ",
                "হট ডগ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("hot-dog"),
            keywords: &["hot-dog", "silzig"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("hot dog"),
            keywords: &["hot dog", "hrenovka", "kobasica"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("frankfurt"),
            keywords: &["frankfurt", "hot dog", "salsitxa"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄦\u{11127}𑄖\u{11134} 𑄓\u{11127}𑄇\u{11134}"),
            keywords: &["𑄦\u{11127}𑄖\u{11134} 𑄓\u{11127}𑄇\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏒᏅᏙᏗ ᎭᏫᏯ"),
            keywords: &["ᎠᏒᏅᏙᏗ ᎭᏫᏯ", "ᎠᏓᏥ", "ᎭᏫᏯ", "ᏏᏆ ᎭᏫᏯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("párek v rohlíku"),
            keywords: &["hot dog", "hotdog", "párek", "párek v rohlíku"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("selsigen mewn bynen"),
            keywords: &["frankfurter", "selsigen", "selsigen mewn bynen"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("hotdog"),
            keywords: &["frankfurter", "hotdog", "pølse"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Hotdog"),
            keywords: &["Frankfurter", "Hot Dog", "Hotdog", "Wurst", "Würstchen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("χοτ ντογκ"),
            keywords: &["λουκάνικο", "φρανκφούρτης", "χοτ ντογκ"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("hot dog"),
            keywords: &["frankfurter", "hot dog", "hotdog", "sausage"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("perrito caliente"),
            keywords: &["perrito", "perrito caliente", "salchicha"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("salchicha"),
            keywords: &["comida", "pan", "pancho", "perrito", "salchicha"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("perro caliente"),
            keywords: &["perro caliente"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("hot dog"),
            keywords: &["frankfurter", "hot dog", "hotdog", "salchicha"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("hot dog"),
            keywords: &["hot dog", "hotdog", "viiner", "vorst"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("hot dog"),
            keywords: &["frankfurt", "hot dog", "hotdog", "saltxitxa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("هات داگ"),
            keywords: &["ساندویچ", "سوسیس", "هات داگ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hodari"),
            keywords: &["hodari", "hot dog", "makkara", "nakki", "sämpylä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("hot dog"),
            keywords: &[
                "frankfurter",
                "hot dog",
                "hotdog",
                "pagkain",
                "sausage",
                "tinapay",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hotdog"),
            keywords: &["hotdog", "matur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("hot dog"),
            keywords: &["hot dog", "saucisse", "saucisse de Francfort"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["Francfort", "chien chaud", "hot dog", "saucisse"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("brocaire te"),
            keywords: &["brocaire", "brocaire te", "francfurtar", "ispín"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("hot dog"),
            keywords: &["frankfurter", "hot dog", "hotdog", "isbean"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("bocadillo de salchicha"),
            keywords: &[
                "bocadillo de salchicha",
                "bolo con salchicha",
                "pan de salchicha",
                "salchicha",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("હોટ ડોગ"),
            keywords: &[
                "ફ\u{acd}ર\u{ac7}\u{a82}કફર\u{acd}ટર",
                "સોસ\u{ac7}જ",
                "હોટ ડોગ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("hot dog"),
            keywords: &["frankfurter", "hot dog", "sausage"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("נקניקייה בלחמניה"),
            keywords: &["לחמניה", "נקניקייה", "נקניקייה בלחמניה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("हॉट डॉग"),
            keywords: &["सासीज", "सॉस", "हॉट डॉग"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("hot dog"),
            keywords: &["hot dog", "hotdog", "hrenovka", "kobasica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("hot dog"),
            keywords: &["hot dog", "hotdog", "kifli", "kolbász", "mustár", "virsli"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("հոթդոգ"),
            keywords: &["հոթդոգ", "նրբերշիկ", "ֆրանկֆուրտեր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("hot dog"),
            keywords: &["hot dog", "hotdog", "sosis"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("achịchanri anụ"),
            keywords: &["achịchanri anụ", "nrianụ", "nrianụ na achịcha"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("pylsa í brauði"),
            keywords: &["pulsa", "pylsa", "pylsa í brauði", "vínarpylsa"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("hot dog"),
            keywords: &["hot dog", "street food"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ホットドッグ"),
            keywords: &["ソーセージ", "フランクフルト", "ホットドッグ"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("roti sosis"),
            keywords: &["frankfurter", "hot dog", "hotdog", "roti sosis", "sosis"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჰოთდოგი"),
            keywords: &["სოსისი", "ჰოთდოგი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("хот-дог"),
            keywords: &["сосиска", "франкфуртер", "хот-дог"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("hotdog"),
            keywords: &["frankfurter", "hotdog", "pølse"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ន\u{17c6}ប\u{17c9}\u{17d0}ងហតដក"),
            keywords: &[
                "ន\u{17c6}ប\u{17c9}\u{17d0}ងដាក\u{17cb}សាច\u{17cb}",
                "ន\u{17c6}ប\u{17c9}\u{17d0}ងហតដក",
                "ហតដក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹಾಟ\u{ccd} ಡಾಗ\u{ccd}"),
            keywords: &[
                "ಫ\u{ccd}ರಾಂಕ\u{ccd}\u{200c}ಫರ\u{ccd}ಟರ\u{ccd}",
                "ಹಾಟ\u{ccd} ಡಾಗ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("핫도그"),
            keywords: &["소세지", "핫도그"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("हॉट डॉग"),
            keywords: &[
                "फ\u{94d}र\u{901}कफर\u{94d}चर",
                "सोस\u{947}ज",
                "हॉट डॉग",
                "हॉटडॉग",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("хот-дог"),
            keywords: &["сосиска", "хот-дог", "хотдог"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Hot Dog"),
            keywords: &["Frankfurter", "Hot Dog", "Hotdog", "Wurscht"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໄສ\u{ec9}ກອກ"),
            keywords: &["ຮ\u{eb1}ອດດ\u{eb1}ອກ", "ໄສ\u{ec9}ກອກ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("dešrainis"),
            keywords: &["dešrainis", "dešrelė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("hotdogs"),
            keywords: &["desiņa", "hotdogs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kurī wera"),
            keywords: &["hōtiti", "hōtiti pakipeta", "kurī wera", "kurīwera"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("хот дог"),
            keywords: &["виршла", "колбас", "хот дог"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഹോട\u{d4d}ട\u{d4d} ഡോഗ\u{d4d}"),
            keywords: &[
                "ഫ\u{d4d}ര\u{d3e}ങ\u{d4d}ക\u{d4d}ഫർട\u{d4d}ടർ",
                "സോസേജ\u{d4d}",
                "ഹോട\u{d4d}ട\u{d4d} ഡോഗ\u{d4d}",
                "ഹോട\u{d4d}ട\u{d4d}ഡോഗ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хот-дог"),
            keywords: &["зайдас", "хот-дог"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("हॉटडॉग"),
            keywords: &[
                "फ\u{94d}र\u{901}कफर\u{94d}टर",
                "सॉस\u{947}ज",
                "हॉट डॉग",
                "हॉटडॉग",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("hot dog"),
            keywords: &["frankfurter", "hot dog", "sosej"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("hot dog"),
            keywords: &["frankfurter", "hot dog", "hotdog", "zalzett"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဟော\u{1037}ဒေါ\u{1037}"),
            keywords: &[
                "န\u{102e}ကြင\u{103a}ကြင\u{103a} ဝက\u{103a}အ\u{1030}ချောင\u{103a}း",
                "ဝက\u{103a}အ\u{1030}ချောင\u{103a}း",
                "ဟော\u{1037}ဒေါ\u{1037}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("pølse med brød"),
            keywords: &["hot dog", "hotdog", "pølse", "pølse med brød"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("हड डग"),
            keywords: &[
                "फ\u{94d}र\u{94d}याङ\u{94d}कफ\u{941}र\u{94d}टर",
                "सस\u{947}स",
                "हड डग",
                "हडडग",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("hotdog"),
            keywords: &["frankfurter", "hotdog", "worst"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("pølse med brød"),
            keywords: &["hot dog", "hotdog", "pølse", "pølse med brød"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ହଟ\u{b4d}\u{200d} ଡଗ\u{b4d}\u{200d}"),
            keywords: &[
                "ଫ\u{b4d}ର\u{b3e}ଙ\u{b4d}କଫର\u{b4d}ଟର\u{b4d}\u{200d}",
                "ସସେଜ\u{b4d}",
                "ହଟଡଗ\u{b4d}\u{200d}",
                "ହଟ\u{b4d}\u{200d} ଡଗ\u{b4d}\u{200d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਹਾਟ-ਡਾਗ"),
            keywords: &["ਜਾਨਵਰਾ\u{a02} ਦਾ ਮੀਟ", "ਮੀਟ", "ਹਾਟ-ਡਾਗ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہاٹ ڈاگ"),
            keywords: &["ساسج", "فرینک فرٹر", "ہاٹ ڈاگ", "ہاٹ ڈوگ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Họ\u{301}t Dọg"),
            keywords: &[
                "Fránkfọ\u{301}ta",
                "Họ\u{301}t Dọg",
                "Sọ\u{301}sej Họ\u{301}tdọg",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("hot dog"),
            keywords: &[
                "bułka",
                "frankfurterka",
                "gorący pies",
                "hot dog",
                "hotdog",
                "parówka",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("هاټ ډاګ"),
            keywords: &["فرينکفرټر، هاټ ډاګ، هاټډاګ، چټني", "هاټ ډاګ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cachorro-quente"),
            keywords: &["cachorro-quente", "hot dog", "pão com salsicha"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cachorro quente"),
            keywords: &["cachorro", "cachorro quente", "salsicha"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("hot dog"),
            keywords: &["hot dog", "hotdog", "salchicha"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("hot dog"),
            keywords: &["cârnat", "fast food", "hot dog", "muștar"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-242"),
            keywords: &["E10-242"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("хот-дог"),
            keywords: &["сосиска", "тесто", "хот-дог"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("hoti dogi"),
            keywords: &["hoti dogi", "sosiso", "umugati urimo sosiso"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("هاٽ ڊاگ"),
            keywords: &["فرينڪ فرٽر، هاٽ ڊاگ، ساسيج", "هاٽ ڊاگ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හොට\u{dca}ඩොග\u{dca}"),
            keywords: &[
                "ල\u{dd2}ංග\u{dd4}ස\u{dca}",
                "සොසේජස\u{dca}",
                "හොට\u{dca}ඩොග\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("párok v rožku"),
            keywords: &["hotdog", "párok", "párok v rožku"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("hot dog"),
            keywords: &["hot dog", "hrenovka"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("eey kulul"),
            keywords: &["duuban", "eey kulul", "hilib duuban"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("hot-dog"),
            keywords: &["hot-dog", "salsiçe"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("хот-дог"),
            keywords: &["виршла", "кoбaсицa", "хoт-дoг", "хот-дог"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("hot-dog"),
            keywords: &["hot-dog", "kobasica", "viršla"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("varmkorv"),
            keywords: &["korv", "mat", "varmkorv"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("soseji katika mkate"),
            keywords: &["frankfurter", "soseji", "soseji katika mkate"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஹ\u{bbe}ட\u{bcd} ட\u{bbe}க\u{bcd}"),
            keywords: &[
                "இறைச\u{bcd}சி உணவு",
                "கொத\u{bcd}துக\u{bcd}கறி உணவு",
                "ஹ\u{bbe}ட\u{bcd} ட\u{bbe}க\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("హ\u{c3e}ట\u{c4d} డ\u{c3e}గ\u{c4d}"),
            keywords: &[
                "ఫ\u{c4d}ర\u{c3e}ంక\u{c4d}\u{200c}ఫర\u{c4d}ట\u{c46}ర\u{c4d}",
                "స\u{c3e}స\u{c47}జ\u{c4d}",
                "హ\u{c3e}ట\u{c4d} డ\u{c3e}గ\u{c4d}",
                "హ\u{c3e}ట\u{c4d}\u{200c}డ\u{c3e}గ\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("хот дог"),
            keywords: &["хот дог", "хотдог", "ҳасиб", "ҳасибча"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ฮอทด\u{e47}อก"),
            keywords: &["ฮอทด\u{e47}อก", "ไส\u{e49}กรอก"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("hotdog"),
            keywords: &["frankfurtly", "hotdog", "sosiska"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sōsisi kulī vela"),
            keywords: &["sōsisi kulī vela"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sosisli sandviç"),
            keywords: &["hot dog", "sosis", "sosisli sandviç"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("خوت دوگ"),
            keywords: &["خوت دوگ", "خوتدوگ", "فىرانكفۇرتېر", "قېزا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("хот-дог"),
            keywords: &["сосиска", "хот-дог"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ہاٹ ڈاگ"),
            keywords: &["اسنیک", "بریڈ", "ہاٹ ڈاگ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("xot-dog"),
            keywords: &["kolbasa", "xot-dog"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bánh mì xúc xích"),
            keywords: &["bánh mì xúc xích", "xúc xích"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("ot-dog"),
            keywords: &["ot-dog", "otdog", "sosis"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-hot dog"),
            keywords: &["i-frankfurter", "i-hot dog", "i-hotdog", "i-sausage"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Hot Dog"),
            keywords: &[
                "Hot Dog",
                "àlọ\u{301}pọ\u{300} ẹran àti ẹran ẹlẹ\u{301}dẹ\u{300}",
                "àlọ\u{301}pọ\u{300} ẹrán",
                "èran ẹlẹ\u{301}dẹ\u{300} papọ\u{300} pẹ\u{300}lú ẹran",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("熱狗"),
            keywords: &["法蘭克福", "熱狗", "香腸"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("热狗"),
            keywords: &["法兰克福", "热狗", "香肠"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("热狗"),
            keywords: &["热狗"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("熱狗"),
            keywords: &["熱狗", "熱狗堡"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["熱狗", "香腸"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ihot dog"),
            keywords: &["ihot dog", "isoseji"],
        },
    ],
};
#[doc = "🥪"]
pub const SANDWICH: crate::Emoji = crate::Emoji {
    glyph: "🥪",
    codepoint: "1F96A",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "sandwich",
    group: "Food & Drink",
    subgroup: "food-prepared",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("toebroodjie"),
            keywords: &["brood", "toebroodjie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሳንድዊች"),
            keywords: &["ሳንድዊች"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ساندوتش"),
            keywords: &["خبز", "ساندوتش"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চেণ\u{9cd}ডৱিচ"),
            keywords: &["চেণ\u{9cd}ডৱিচ", "প\u{9be}ওৰ\u{9c1}টী"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sendviç"),
            keywords: &["sendviç", "çörək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сандвіч"),
            keywords: &["сандвіч", "хлеб"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("сандвич"),
            keywords: &["сандвич", "хляб"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9cd}য\u{9be}ন\u{9cd}ডউইচ"),
            keywords: &["র\u{9c1}টি", "স\u{9cd}য\u{9be}ন\u{9cd}ডউইচ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("sandwich"),
            keywords: &["bara", "sandwich"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("sendvič"),
            keywords: &["hljeb", "sendvič"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("entrepà"),
            keywords: &["entrepà", "pa"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: None,
            keywords: &["𑄢\u{1112a}𑄖\u{11128}", "𑄥\u{11133}𑄠𑄚\u{11134}𑄅𑄄𑄌\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᏛᎭᏟ"),
            keywords: &["ᎠᏍᏛᎭᏟ", "ᎦᏚ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("sendvič"),
            keywords: &["chleba", "sandwich", "sendvič", "toast", "toust"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("brechdan"),
            keywords: &["bara", "brechdan"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sandwich"),
            keywords: &["brød", "sandwich"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Sandwich"),
            keywords: &["Brot", "Sandwich"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σάντουιτς"),
            keywords: &["σάντουιτς", "ψωμί"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("sandwich"),
            keywords: &["bread", "sandwich"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("sándwich"),
            keywords: &["bocadillo", "bocata", "emparedado", "sándwich"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("sándwich"),
            keywords: &["bocadillo", "bocata", "emparedado", "sándwich"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["sándwich"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["bocadillo", "emparedado", "pan", "sándwich"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("võileib"),
            keywords: &["leib", "võileib"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ogitartekoa"),
            keywords: &["ogia", "ogitartekoa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ساندویچ"),
            keywords: &["ساندویچ", "نان"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("voileipä"),
            keywords: &["kerrosleipä", "leipä", "täyte", "voileipä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("sandwich"),
            keywords: &["sandwich", "tinapay"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("tvíflís"),
            keywords: &["breyð", "matur", "tvíflís"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("sandwich"),
            keywords: &["pain", "sandwich"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ceapaire"),
            keywords: &["arán", "ceapaire"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ceapaire"),
            keywords: &["aran", "ceapaire"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("sándwhich"),
            keywords: &["bocadillo", "pan de molde", "sándwhich"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{ac5}ન\u{acd}ડવિચ"),
            keywords: &["બ\u{acd}ર\u{ac7}ડ", "સ\u{ac5}ન\u{acd}ડવિચ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("abincin sandwich"),
            keywords: &["abincin sandwich", "burodi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סנדביץ׳"),
            keywords: &["סנדביץ׳"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{948}\u{902}डविच"),
            keywords: &["ब\u{94d}र\u{947}ड", "स\u{948}\u{902}डविच"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("sendvič"),
            keywords: &["kruh", "sendvič"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szendvics"),
            keywords: &["kenyér", "szendvics"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սենդվիչ"),
            keywords: &["հաց", "սենդվիչ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("roti lapis"),
            keywords: &["roti", "roti lapis"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nri achịcha na anụ"),
            keywords: &["achịcha nkịtị", "nri achịcha na anụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("samloka"),
            keywords: &["brauð", "samloka"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("sandwich"),
            keywords: &["pane", "sandwich"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("サンドイッチ"),
            keywords: &["サンドイッチ", "パン"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sendwich"),
            keywords: &["roti", "sendwich"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სენდვიჩი"),
            keywords: &["პური", "სენდვიჩი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сэндвич"),
            keywords: &["сэндвич"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សា\u{17c6}ងវ\u{17c9}\u{17b7}ច"),
            keywords: &[
                "ន\u{17c6}ប\u{17c9}\u{17d0}ង",
                "សា\u{17c6}ងវ\u{17c9}\u{17b7}ច",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{ccd}ಯಾಂಡ\u{ccd}\u{200c}ವ\u{cbf}ಚ\u{ccd}"),
            keywords: &[
                "ಬ\u{ccd}ರ\u{cc6}ಡ\u{ccd}",
                "ಸ\u{ccd}ಯಾಂಡ\u{ccd}\u{200c}ವ\u{cbf}ಚ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("샌드위치"),
            keywords: &["빵", "샌드위치"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("स\u{901}डविच"),
            keywords: &["पाव", "स\u{901}डविच"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("сэндвич"),
            keywords: &["нан", "сэндвич"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Sandwich"),
            keywords: &["Brout", "Sandwich"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແຊນວ\u{eb4}ດ"),
            keywords: &["ເຂ\u{ebb}\u{ec9}າຈ\u{eb5}\u{ec8}", "ແຊນວ\u{eb4}ດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("sumuštinis"),
            keywords: &["duona", "sumuštinis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sendvičs"),
            keywords: &["maize", "sendvičs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("hanewiti"),
            keywords: &["hanewiti", "parāoa"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("сендвич"),
            keywords: &["леб", "сендвич"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d3e}ൻഡ\u{d4d}\u{200c}വിച\u{d4d}ച\u{d4d}"),
            keywords: &[
                "ബ\u{d4d}രെഡ\u{d4d}",
                "സ\u{d3e}ൻഡ\u{d4d}\u{200c}വിച\u{d4d}ച\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("сэндвич"),
            keywords: &["сэндвич", "талх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{901}डविच"),
            keywords: &["ब\u{94d}र\u{947}ड", "स\u{901}डविच"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("sandwic"),
            keywords: &["roti", "sandwic"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("sandwich"),
            keywords: &["sandwich", "ħobż"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အသားည\u{103e}ပ\u{103a}ပေါင\u{103a}မ\u{102f}န\u{1037}\u{103a}"),
            keywords: &[
                "ပေါင\u{103a}မ\u{102f}န\u{1037}\u{103a}",
                "အသားည\u{103e}ပ\u{103a}ပေါင\u{103a}မ\u{102f}န\u{1037}\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sandwich"),
            keywords: &["brød", "brødskive", "sandwich", "smørbrød"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}यान\u{94d}डविच"),
            keywords: &["पाउरोटी", "स\u{94d}यान\u{94d}डविच"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("boterham"),
            keywords: &["boterham", "brood"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("sandwich"),
            keywords: &["brød", "brødskive", "sandwich", "smørbrød"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b4d}ୟ\u{b3e}ଣ\u{b4d}ଡୱ\u{b3f}ଚ\u{b4d}\u{200d}"),
            keywords: &[
                "ପ\u{b3e}ଉ\u{b01}ର\u{b41}ଟ\u{b3f}",
                "ସ\u{b4d}ୟ\u{b3e}ଣ\u{b4d}ଡୱ\u{b3f}ଚ\u{b4d}\u{200d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a48}\u{a02}ਡਵਿਚ"),
            keywords: &["ਬ\u{a4d}ਰ\u{a48}\u{a71}ਡ", "ਸ\u{a48}\u{a02}ਡਵਿਚ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سینڈوچ"),
            keywords: &["روٹی", "سینڈوچ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Sándwich"),
            keywords: &["Brẹd", "Sándwich"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kanapka"),
            keywords: &["kanapka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سانډویچ"),
            keywords: &["سانډویچ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("sanduíche"),
            keywords: &["sanduíche"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("sandes"),
            keywords: &["pão", "sande", "sandes", "sanduíche"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("sandwich"),
            keywords: &["sandwich", "tʼanta"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("sandvici"),
            keywords: &["fast food", "sandvici", "sandviș"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1094"),
            keywords: &["E10-1094"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("сэндвич"),
            keywords: &["бутерброд", "сэндвич", "хлеб"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("sanduwici"),
            keywords: &["sanduwici", "umugati"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سينڊوچ"),
            keywords: &["روٽي", "سينڊوچ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සැන\u{dca}ඩ\u{dca}ව\u{dd2}ච\u{dca}"),
            keywords: &["ප\u{dcf}න\u{dca}", "සැන\u{dca}ඩ\u{dca}ව\u{dd2}ච\u{dca}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("sendvič"),
            keywords: &["chlieb", "plátky", "sendvič"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("sendvič"),
            keywords: &["sendvič"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("saanbuus"),
            keywords: &["rooti", "saanbuus"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("sandviç"),
            keywords: &["bukë", "sandviç"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("сендвич"),
            keywords: &["сендвич", "хлеб"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["сендвич"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("sendvič"),
            keywords: &["hleb", "sendvič"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["sendvič"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("smörgås"),
            keywords: &["bröd", "macka", "smörgås"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("sandwichi"),
            keywords: &["mkate", "sandwichi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ச\u{bbe}ண\u{bcd}ட\u{bcd}விச\u{bcd}"),
            keywords: &["ச\u{bbe}ண\u{bcd}ட\u{bcd}விச\u{bcd}", "பிரெட\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c3e}ండ\u{c4d}\u{200c}వ\u{c3f}చ\u{c4d}"),
            keywords: &[
                "ర\u{c4a}ట\u{c4d}ట\u{c46}",
                "స\u{c3e}ండ\u{c4d}\u{200c}వ\u{c3f}చ\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("сендвич"),
            keywords: &["нон", "сендвич"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แซนด\u{e4c}ว\u{e34}ช"),
            keywords: &["ขนมป\u{e31}ง", "แซนด\u{e4c}ว\u{e34}ช"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("sendwiç"),
            keywords: &["sendwiç", "çörek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sanuisi"),
            keywords: &["sanuisi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sandviç"),
            keywords: &["ekmek", "sandviç"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ساندۋىچ"),
            keywords: &["ساندۋىچ", "نان"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("сандвіч"),
            keywords: &["сандвіч", "хліб"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سینڈوچ"),
            keywords: &["سینڈوچ", "ڈبل روٹی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("sendvich"),
            keywords: &["buterbrod", "non", "sendvich"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bánh mỳ kẹp"),
            keywords: &["bánh mỳ", "bánh mỳ kẹp"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("sandwich"),
            keywords: &["mburu", "sandwich"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-sandwich"),
            keywords: &["i-sandwich", "isonka"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("búrẹ\u{301}dì alákànpọ\u{300}"),
            keywords: &["Búrẹ\u{301}dì", "búrẹ\u{301}dì alákànpọ\u{300}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("三文治"),
            keywords: &["三文治", "麵包"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("三文治"),
            keywords: &["三文治", "面包"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("三明治"),
            keywords: &["三明治", "面包"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("三明治"),
            keywords: &["三明治"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("三文治"),
            keywords: &["三文治"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isemishi"),
            keywords: &["isemishi", "isinkwa"],
        },
    ],
};
#[doc = "🌮"]
pub const TACO: crate::Emoji = crate::Emoji {
    glyph: "🌮",
    codepoint: "1F32E",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "taco",
    group: "Food & Drink",
    subgroup: "food-prepared",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("taco"),
            keywords: &["kos", "meksikaans", "taco"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ታኮ"),
            keywords: &["ታኮ", "የሜክሲኮ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}تاكو"),
            keywords: &["مكسيكي", "\u{202b}تاكو"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ট\u{9be}কো"),
            keywords: &["ট\u{9be}কো", "মেক\u{9cd}সিক\u{9be}ন"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("tako"),
            keywords: &["meksika", "tako"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("така"),
            keywords: &["мексіканскі", "така"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("тако"),
            keywords: &["мексикански", "тако"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ট\u{9cd}য\u{9be}কো"),
            keywords: &["ট\u{9cd}য\u{9be}কো", "মেক\u{9cd}সিক\u{9be}ন"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("tako"),
            keywords: &["mecʼhikan", "tako"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("tortilja"),
            keywords: &["meksička", "tortilja"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("taco"),
            keywords: &["mexicà", "taco"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄑\u{11133}𑄠𑄇\u{1112e}"),
            keywords: &["𑄑\u{11133}𑄠𑄇\u{1112e}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏎᎷ ᎦᏚ ᎤᏂᏍᏛᎦᏱᏓ"),
            keywords: &["ᎠᏍᏆᏂ", "ᏎᎷ ᎦᏚ ᎤᏂᏍᏛᎦᏱᏓ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("taco"),
            keywords: &["jídlo", "mexické", "taco", "tacos"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("taco"),
            keywords: &["mecsicanaidd", "taco"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("taco"),
            keywords: &["mexicansk", "taco"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Taco"),
            keywords: &["Taco", "mexikanisch"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τάκο"),
            keywords: &["μεξικάνικο", "τάκο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("taco"),
            keywords: &["mexican", "taco"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["Mexican", "taco"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("taco"),
            keywords: &["comida", "mexicano", "taco"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["comida", "mexicana", "taco"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["comida", "comida mexicana", "taco", "tacos", "taquitos"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("tako"),
            keywords: &["mehhiko", "tako"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("takoa"),
            keywords: &["mexiko", "takoa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تاکو"),
            keywords: &["تاکو", "غذا", "مکزیکی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("taco"),
            keywords: &["meksikolainen", "taco"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("taco"),
            keywords: &["mexican", "pagkain", "taco"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("tako"),
            keywords: &["matur", "meksikanskur", "taco", "tako"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("taco"),
            keywords: &["mexicain", "taco"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("taco"),
            keywords: &["meicsiceach", "taco"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("taco"),
            keywords: &["meagsagach", "taco"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("taco"),
            keywords: &["mexicano", "taco"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ટાકો"),
            keywords: &["ટાકો", "મ\u{ac7}ક\u{acd}સિકન", "મ\u{ac7}ક\u{acd}સિકન વાનગી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("taco"),
            keywords: &["na mexico", "taco"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("טאקו"),
            keywords: &["טאקו", "מקסיקני"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ट\u{948}को"),
            keywords: &["ट\u{948}को", "म\u{948}क\u{94d}सिकन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("taco"),
            keywords: &["meksička", "taco"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("taco"),
            keywords: &["mexikói", "taco", "étel"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տակո"),
            keywords: &["մեքսիկական", "տակո"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("taco"),
            keywords: &["meksiko", "taco"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("achịcha anụ"),
            keywords: &["achịcha anụ", "onye mexico"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("takó"),
            keywords: &["mexíkóskt", "takó"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("taco"),
            keywords: &["Messico", "cucina messicana", "taco"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("タコス"),
            keywords: &["タコス", "メキシカン"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tako"),
            keywords: &["pangan meksiko", "tako"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ტაკო"),
            keywords: &["მექსიკური", "ტაკო"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тако"),
            keywords: &["мексикалық", "тако"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("taco"),
            keywords: &["mexicansk", "taco"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ន\u{17c6}ថាក\u{17bc} (ន\u{17c6}ប\u{17d2}រទេសម\u{17c9}\u{17b7}កស\u{17ca}\u{17b8}ក\u{17bc})",
            ),
            keywords: &[
                "ន\u{17c6}",
                "ន\u{17c6}ថាក\u{17bc} (ន\u{17c6}ប\u{17d2}រទេសម\u{17c9}\u{17b7}កស\u{17ca}\u{17b8}ក\u{17bc})",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಟ\u{ccd}ಯಾಕೊ"),
            keywords: &["ಟ\u{ccd}ಯಾಕೊ", "ಮ\u{cc6}ಕ\u{ccd}ಸ\u{cbf}ಕನ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("타코"),
            keywords: &["멕시코 요리", "타코"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("टाको"),
            keywords: &["टाको", "म\u{945}क\u{94d}सिकन"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тако"),
            keywords: &["мексика", "тако"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Taco"),
            keywords: &["Taco", "mexikanesch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ທາໂກ\u{ec9}"),
            keywords: &["ທາໂກ\u{ec9}", "ເມ\u{eb1}ກຊ\u{eb4}ກ\u{eb1}ນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("meksikietiškas paplotėlis"),
            keywords: &["meksikietiškas", "meksikietiškas paplotėlis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("tako"),
            keywords: &["meksikāņu", "tako"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tako"),
            keywords: &["mehikana", "tako"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("тако"),
            keywords: &["мексиканска", "тако", "храна"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ട\u{d3e}കോ"),
            keywords: &[
                "ആഹ\u{d3e}രം",
                "ട\u{d3e}കോ",
                "ഭക\u{d4d}ഷണം",
                "മെക\u{d4d}\u{200c}സിക\u{d4d}കൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("тако"),
            keywords: &["мексик", "тако"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("टाको"),
            keywords: &["टाको", "म\u{947}क\u{94d}सिकन"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tako"),
            keywords: &["mexico", "tako"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("taco"),
            keywords: &["messikan", "taco"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တာက\u{102d}\u{102f}"),
            keywords: &["တာက\u{102d}\u{102f}", "မက\u{103a}ဆ\u{102e}ကန\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("taco"),
            keywords: &["meksikansk", "taco"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("टाको"),
            keywords: &["टाको", "म\u{947}क\u{94d}सिकन"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("taco"),
            keywords: &["mexicaans", "taco"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("taco"),
            keywords: &["meksikansk", "taco"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଟ\u{b3e}କୋ"),
            keywords: &["ଟ\u{b3e}କୋ", "ମେକ\u{b4d}ସ\u{b3f}କ\u{b3e}ନ\u{b4d}\u{200d}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਟਾਕ\u{a4b}"),
            keywords: &["ਟਾਕ\u{a4b}", "ਮ\u{a48}ਕਸੀਕਨ ਖਾਣਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ٹیکو"),
            keywords: &["میکسیکو دا رہن آلا", "ٹیکو"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Táko"),
            keywords: &[
                "Mẹ\u{301}ksíko",
                "Mẹ\u{301}ksíkó Fud Wé Im Nem Na Táko",
                "Táko",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("taco"),
            keywords: &["meksykańskie jedzenie", "taco"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ټکو"),
            keywords: &["ټکو"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("taco"),
            keywords: &["comida mexicana", "taco"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("taco"),
            keywords: &["comida", "mexicana", "taco"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("taco"),
            keywords: &["mexicano", "taco"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("taco"),
            keywords: &["fast food", "lipie", "mexican", "taco"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-243"),
            keywords: &["E10-243"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("тако"),
            keywords: &["кухня", "мексика", "мексиканская кухня", "тако"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("tako"),
            keywords: &["kinyamegisiki", "tako"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٽاڪو"),
            keywords: &["ميڪسيڪن", "ٽاڪو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ටැකෝ"),
            keywords: &["ටැකෝ", "මැක\u{dca}ස\u{dd2}ක\u{dcf}න\u{dd4}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("taco"),
            keywords: &["jedlo", "mexické", "taco"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("taco"),
            keywords: &["mehiški prigrizek", "taco"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("taako"),
            keywords: &["taakada meksikaanka", "taako"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("tako"),
            keywords: &["tako", "ushqim meksikan"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("тако"),
            keywords: &["мeксичкa", "тако"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("tako"),
            keywords: &["meksička", "tako"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("taco"),
            keywords: &["fredagsmys", "mat", "mexikanskt", "taco"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("chapati iliyojazwa vyakula mbalimbali"),
            keywords: &["chapati iliyojazwa vyakula mbalimbali", "meksiko"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ட\u{bbe}கோ"),
            keywords: &["உணவு", "ட\u{bbe}கோ", "மெக\u{bcd}சிகன\u{bcd} உணவு"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ట\u{c3e}క\u{c4b}"),
            keywords: &["ట\u{c3e}క\u{c4b}", "మ\u{c46}క\u{c4d}స\u{c3f}కన\u{c4d}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тако"),
            keywords: &["мехиклӣ", "тако"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ทาโก\u{e49}"),
            keywords: &[
                "ทาโก\u{e49}",
                "เม\u{e47}กซ\u{e34}ก\u{e31}น",
                "เม\u{e47}กซ\u{e34}โก",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("tako"),
            keywords: &["meksikan", "tako"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mā pelupelu"),
            keywords: &["mā pelupelu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("tako"),
            keywords: &["Meksika sandviçi", "tako"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تاكو"),
            keywords: &["تاكو", "مېكسىكىچە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("тако"),
            keywords: &["мексика", "тако", "їжа"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مسالے بھرا پراٹھا"),
            keywords: &["اسنیک", "مسالہ", "مسالے بھرا پراٹھا", "میکسیکن", "پراٹھا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tako"),
            keywords: &["meksika taomi", "tako"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bánh taco"),
            keywords: &["bánh mexico", "bánh taco"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("tako"),
            keywords: &["tako", "wu-meksik"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-taco"),
            keywords: &["i-mexican", "i-taco"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Taco"),
            keywords: &["Taco", "ónjẹ mẹ\u{301}síkò"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("墨西哥餡餅"),
            keywords: &["墨西哥", "墨西哥餡餅"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("墨西哥馅饼"),
            keywords: &["墨西哥", "墨西哥馅饼"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("墨西哥卷饼"),
            keywords: &["卷饼", "墨西哥", "墨西哥卷饼"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("夾餅"),
            keywords: &["墨西哥夾餅", "夾餅"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("墨西哥夾餅"),
            keywords: &[
                "塔可餅",
                "墨西哥塔可餅",
                "墨西哥夾餅",
                "墨西哥玉米餅",
                "玉米餅",
            ],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("itaco"),
            keywords: &["itaco", "okumexican"],
        },
    ],
};
#[doc = "🌯"]
pub const BURRITO: crate::Emoji = crate::Emoji {
    glyph: "🌯",
    codepoint: "1F32F",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "burrito",
    group: "Food & Drink",
    subgroup: "food-prepared",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("burrito"),
            keywords: &["burrito", "kos", "meksikaans"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቡሪቶ"),
            keywords: &["ቡሪቶ", "የሜክሲኮ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بوريتو"),
            keywords: &["بوريتو", "مكسيكي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বৰিটো"),
            keywords: &["বৰিটো", "মেক\u{9cd}সিক\u{9be}ন", "ৰেপ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("buritto"),
            keywords: &["buritto", "meksika"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("бурыта"),
            keywords: &["бурыта", "мексіканскі"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("бурито"),
            keywords: &["бурито", "мексикански"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9c1}রিটো"),
            keywords: &["ব\u{9c1}রিটো", "মেক\u{9cd}সিক\u{9be}ন"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("burrito"),
            keywords: &["burrito", "mecʼhikan"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("burito"),
            keywords: &["burito", "meksička"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("burrito"),
            keywords: &["burrito", "mexicà", "rotlle", "tortilla"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄝\u{1112a}𑄢\u{11128}𑄖\u{1112e}"),
            keywords: &["𑄝\u{1112a}𑄢\u{11128}𑄖\u{1112e}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏇᏅ"),
            keywords: &["ᎠᏍᏆᏂ", "ᎦᏇᏅ", "ᎦᏇᏅᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("burrito"),
            keywords: &[
                "burito", "burrito", "jídlo", "mexická", "mexické", "rolka", "wrap",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("burrito"),
            keywords: &["burrito", "mecsicanaidd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("burrito"),
            keywords: &["burrito", "mexicansk"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Burrito"),
            keywords: &["Burrito", "mexikanisch"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μπουρίτο"),
            keywords: &["μεξικάνικο", "μπουρίτο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("burrito"),
            keywords: &["burrito", "mexican", "wrap"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["Mexican", "burrito", "wrap"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("burrito"),
            keywords: &["burrito", "comida", "mexicano", "tex mex", "wrap"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["burrito", "comida", "mexicana"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["burrito", "comida", "comida mexicana"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("burrito"),
            keywords: &["burrito", "mehhiko"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("burritoa"),
            keywords: &["burritoa", "mexiko"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بوریتو"),
            keywords: &["بوریتو", "غذا", "مکزیکی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("burrito"),
            keywords: &["burrito", "meksikolainen"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("burrito"),
            keywords: &["burrito", "mexican", "pagkain"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("burrito"),
            keywords: &["burrito", "matur", "meksikanskur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("burrito"),
            keywords: &["burrito", "mexicain"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("burrito"),
            keywords: &["burrito", "meicsiceach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("burrito"),
            keywords: &["burrito", "meagsagach", "wrap"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("burrito"),
            keywords: &["burrito", "mexicano"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બરિટો"),
            keywords: &[
                "બરિટો",
                "મ\u{ac7}ક\u{acd}સિકન",
                "મ\u{ac7}ક\u{acd}સિકન વાનગી",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("burrito"),
            keywords: &["burrito", "na mexico", "naɗi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("בוריטו"),
            keywords: &["בוריטו", "מקסיקני"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बरिटो"),
            keywords: &["बरिटो", "म\u{948}क\u{94d}सिकन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("burrito"),
            keywords: &["burrito", "meksička"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("burrito"),
            keywords: &["burrito", "mexikói", "étel"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բուռիտո"),
            keywords: &["բուռիտո", "բրդուճ", "մեքսիկական", "պատառ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("burrito"),
            keywords: &["burrito", "meksiko"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("achịcha nrianụ na akwụkwọnri"),
            keywords: &[
                "achịcha nrianụ na akwụkwọnri",
                "ngwu èkèrèke",
                "onye mexico",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("búrrító"),
            keywords: &["búrrító", "mexíkóskt"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("burrito"),
            keywords: &["Messico", "burrito", "cucina messicana"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ブリトー"),
            keywords: &["ソフトタコス", "ブリトー", "メキシカン"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("burito"),
            keywords: &["burito", "dhaharan meksiko", "sega bungkus roti"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბურიტო"),
            keywords: &["ბურიტო", "მექსიკური"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бурито"),
            keywords: &["бурито", "мексикалық"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("burrito"),
            keywords: &["burrito", "mexicansk"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ន\u{17c6}ប\u{17ca}\u{17ba}រ\u{17b8}ត\u{17bc} (ន\u{17c6}ប\u{17d2}រទេសម\u{17c9}\u{17b7}កស\u{17ca}\u{17b8}ក\u{17bc})",
            ),
            keywords: &[
                "ន\u{17c6}",
                "ន\u{17c6}ប\u{17ca}\u{17ba}រ\u{17b8}ត\u{17bc} (ន\u{17c6}ប\u{17d2}រទេសម\u{17c9}\u{17b7}កស\u{17ca}\u{17b8}ក\u{17bc})",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬುರ\u{cbf}ಟೊ"),
            keywords: &["ಬುರ\u{cbf}ಟೊ", "ಮ\u{cc6}ಕ\u{ccd}ಸ\u{cbf}ಕನ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("부리또"),
            keywords: &["멕시코 요리", "버리토", "부리또", "타코"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ब\u{941}रिटो"),
            keywords: &["ग\u{941}ठली", "ब\u{941}रिटो", "म\u{945}क\u{94d}सिकन"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("буррито"),
            keywords: &["буррито", "мексика"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Burrito"),
            keywords: &["Burrito", "Wrap", "mexikanesch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເບ\u{eb5}ຣ\u{eb4}ໂຕ"),
            keywords: &[
                "ເບ\u{eb5}ຣ\u{eb4}ໂຕ",
                "ເບ\u{eb5}ຣ\u{eb5}ໂຕ",
                "ແມ\u{eb1}ກຊ\u{eb5}ກ\u{eb1}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("buritas"),
            keywords: &["buritas", "meksikietiškas", "suvyniotas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("burito"),
            keywords: &["burito", "meksikāņu"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("purito"),
            keywords: &["mehikana", "purito", "takai"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("бурито"),
            keywords: &["бурито", "мексиканска", "храна"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ബറീറ\u{d4d}റോ"),
            keywords: &[
                "ആഹ\u{d3e}രം",
                "ബറീറ\u{d4d}റോ",
                "ഭക\u{d4d}ഷണം",
                "മെക\u{d4d}\u{200c}സിക\u{d4d}കൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("буррито"),
            keywords: &["буррито", "мексик"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("बरितो"),
            keywords: &["बरितो", "म\u{947}क\u{94d}सिकन", "र\u{945}प"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("burito"),
            keywords: &["burito", "mexico"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("burrito"),
            keywords: &["burrito", "messikan", "wrap"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဘ\u{1030}ရ\u{102e}တ\u{102d}\u{102f}"),
            keywords: &[
                "ဘ\u{1030}ရ\u{102e}တ\u{102d}\u{102f}",
                "မက\u{1039}ကဆ\u{102e}ကန\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("burrito"),
            keywords: &["burrito", "meksikansk", "wrap"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बर\u{94d}रिटो"),
            keywords: &["बर\u{94d}रिटो", "म\u{947}क\u{94d}सिकन"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("burrito"),
            keywords: &["burrito", "mexicaans", "wrap"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("burrito"),
            keywords: &["burrito", "meksikansk", "wrap"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବର\u{b3f}ଟୋ"),
            keywords: &[
                "ବର\u{b3f}ଟୋ",
                "ମେକ\u{b4d}ସ\u{b3f}କ\u{b3e}ନ\u{b4d}\u{200d} । ର\u{b3e}ପ\u{b4d}\u{200d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬਰੀਟ\u{a4b}"),
            keywords: &["ਬਰੀਟ\u{a4b}", "ਮ\u{a48}ਕਸੀਕਨ ਖਾਣਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بوریٹو"),
            keywords: &["بوریٹو", "لپیٹنا", "میکسیکو دا رہن آلا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Buríto"),
            keywords: &["Buríto", "Mẹ\u{301}ksíko", "Rap"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("burrito"),
            keywords: &["burito", "burrito", "meksykańskie jedzenie"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بريټو"),
            keywords: &["بريټو"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("burrito"),
            keywords: &["burrito", "comida mexicana"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["burrito", "comida", "mexicana"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("burrito"),
            keywords: &["burrito", "mayt’uy", "mexicano"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("burrito"),
            keywords: &[
                "burrito",
                "lipie",
                "mexican",
                "sandvici rulat",
                "sandviș rulat",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-244"),
            keywords: &["E10-244"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("буррито"),
            keywords: &[
                "буррито",
                "бурритос",
                "кухня",
                "мексика",
                "мексиканская кухня",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("burito"),
            keywords: &["burito", "cyo muri megizike", "gufunika"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بريٽو"),
            keywords: &["بريٽو", "ميڪسيڪن رول"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බ\u{dd4}ර\u{dd2}ටෝ"),
            keywords: &["බ\u{dd4}ර\u{dd2}ටෝ", "මැක\u{dca}ස\u{dd2}ක\u{dcf}න\u{dd4}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("burrito"),
            keywords: &["burrito", "jedlo", "mexické"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("burito"),
            keywords: &["burito", "mehiški prigrizek"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("toortiilada meksikaanka"),
            keywords: &[
                "duub ah",
                "meksikaan",
                "toortiila",
                "toortiilada meksikaanka",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("burrito"),
            keywords: &["burrito", "ushqim meksikan i mbështjellë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("бурито"),
            keywords: &["бурито", "мeксичкa"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("burito"),
            keywords: &["burito", "meksička"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("burrito"),
            keywords: &["burrito", "fredagsmys", "mat", "mexikanskt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mkate wa kimeksiko uliowekwa nyama au maharage ndani"),
            keywords: &[
                "meksiko",
                "mkate wa kimeksiko uliowekwa nyama au maharage ndani",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("புரிட\u{bcd}டோ"),
            keywords: &["உணவு", "புரிட\u{bcd}டோ", "மெக\u{bcd}சிகன\u{bcd} உணவு"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బర\u{c4d}ర\u{c3f}ట\u{c4d}ట\u{c4b}"),
            keywords: &[
                "బర\u{c4d}ర\u{c3f}ట\u{c4d}ట\u{c4b}",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("буритто"),
            keywords: &["буритто", "мехисоӣ", "печондан"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เบอร\u{e4c}ร\u{e34}โต"),
            keywords: &[
                "เบอร\u{e4c}ร\u{e34}โต",
                "เม\u{e47}กซ\u{e34}ก\u{e31}น",
                "เม\u{e47}กซ\u{e34}โก",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("burrito"),
            keywords: &["burrito", "dolama", "meksikan"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("polito"),
            keywords: &["polito"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("burito"),
            keywords: &["Meksika dürümü", "burito"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قىيما"),
            keywords: &["ئوراق", "قىيما", "مېكسىكا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("буріто"),
            keywords: &["буріто", "мексика", "їжа"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بریٹو"),
            keywords: &["اسنیک", "بریٹو", "مسالہ", "میکسیکن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("burrito"),
            keywords: &["burrito", "meksika taomi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bánh burrito"),
            keywords: &["bánh burrito", "bánh mexico"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("burito"),
            keywords: &["burito", "mbar", "wu-meksik"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-burrito"),
            keywords: &["i-burrito", "i-mexican", "i-wrap"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Burito"),
            keywords: &["Burito", "wépò", "ónjẹ mẹ\u{301}síkò"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("捲餅"),
            keywords: &["墨西哥", "捲餅"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("卷饼"),
            keywords: &["卷饼", "墨西哥"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("墨西哥玉米煎饼"),
            keywords: &["卷饼", "墨西哥", "墨西哥玉米煎饼", "玉米煎饼"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("捲餅"),
            keywords: &["墨西哥捲餅", "捲餅"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("墨西哥捲餅"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("hburrito"),
            keywords: &["hburrito", "okumexican"],
        },
    ],
};
#[doc = "🫔"]
pub const TAMALE: crate::Emoji = crate::Emoji {
    glyph: "🫔",
    codepoint: "1FAD4",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "tamale",
    group: "Food & Drink",
    subgroup: "food-prepared",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("tamale"),
            keywords: &["Meksikaans", "omhulsel", "tamale"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ታማሌ"),
            keywords: &["ታማሌ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("تامال"),
            keywords: &["تامال", "شطيرة", "مكسيك"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("টম\u{9be}লে"),
            keywords: &["টম\u{9be}লে", "মেক\u{9cd}সিক\u{9be}ন", "ৰেপ কৰ\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("tamal"),
            keywords: &["dürüm", "meksika", "tamal"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("тамале"),
            keywords: &["мексіканскі", "тамале"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("тамалес"),
            keywords: &["мексиканска храна", "навити питки", "тамалес"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ত\u{9be}ম\u{9be}লে"),
            keywords: &["ত\u{9be}ম\u{9be}লে", "মেক\u{9cd}সিক\u{9be}ন", "রোল"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("tamal"),
            keywords: &["mecʼhikan", "tamal"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("tamale"),
            keywords: &["meksička kuhinja", "smotuljci", "tamale"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("tamal"),
            keywords: &["enrotllat", "mexicà", "tamal"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏔᎹᎴ"),
            keywords: &["ᎠᏍᏆᏂ", "ᎦᏇᏅᏗ", "ᏔᎹᎴ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("tamale"),
            keywords: &["mexický", "tamale", "tamales", "wrap"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("tamale"),
            keywords: &["mecsicanaidd", "tamale", "wedi ei lapio"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("tamales"),
            keywords: &["mexicansk", "tamales", "wraps"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Tamale"),
            keywords: &["Tamale", "eingewickelt", "mexikanisch"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ταμάλες"),
            keywords: &["μεξικάνικο", "ταμάλες", "τυλιχτό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("tamale"),
            keywords: &["mexican", "tamale", "wrapped"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("tamal"),
            keywords: &["mejicano", "mexicano", "tamal", "wrap"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("tamal"),
            keywords: &["comida", "mexicana", "tamal"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("tamal"),
            keywords: &["tamal"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("tamal"),
            keywords: &["tamal"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("tamale"),
            keywords: &["maisikakk", "mehhiko", "tamale", "täidetud"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("tamal"),
            keywords: &["bilkaria", "kiribilkia", "mexikarra", "tamal"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تامال"),
            keywords: &["تامال", "لقمه", "مکزیکی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tamal"),
            keywords: &["käärö", "meksikolainen", "tamal"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tamale"),
            keywords: &["mexican", "nakabalot", "tamale"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("tamales"),
            keywords: &["Meksiko", "ball", "matur", "tamales"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("tamal"),
            keywords: &["mexicain", "papillote", "tamal"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("tamale"),
            keywords: &["Meicsiceach", "fillteog", "tamale"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("tamale"),
            keywords: &["Meagsagach", "paisgte", "tamale"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("tamal"),
            keywords: &["mexicano", "tamal"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("તમાલ\u{ac7}"),
            keywords: &[
                "તમાલ\u{ac7}",
                "મ\u{ac7}ક\u{acd}સિકન",
                "ર\u{ac5}પમા\u{a82} વી\u{a82}ટાળ\u{ac7}લ\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("טמלה"),
            keywords: &["טמלה", "מקסיקני", "ראפ"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("टमाल\u{947}"),
            keywords: &[
                "टमाल\u{947}",
                "म\u{948}क\u{94d}सिकन",
                "र\u{948}प किया ह\u{941}आ",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tamal"),
            keywords: &["meksičko", "tamal", "umotano"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("tamale"),
            keywords: &["felcsavart", "mexikói", "tamale"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տամալե"),
            keywords: &["բրդուճ", "մեքսիկական", "պատառ", "տամալե"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tamale"),
            keywords: &["makanan meksiko", "tamale", "terbungkus"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("tamale"),
            keywords: &["mexíkóskt", "mexíkóskur matur", "tamale", "vefja"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("tamale"),
            keywords: &["involtino", "messicano", "tamale"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("タマル"),
            keywords: &["ちまき", "タマル", "タマレス", "メキシカン"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tamale"),
            keywords: &["dhaharan meksiko", "kabungkus", "tamale"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ტამალე"),
            keywords: &["მექსიკური", "ტამალე", "შეხვეული"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тамал"),
            keywords: &["мексикалық", "оралған", "тамал"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("តាម\u{17c9}ាឡេ"),
            keywords: &[
                "តាម\u{17c9}ាឡេ",
                "ម\u{17c9}\u{17b7}កស\u{17ca}\u{17b7}ក",
                "រ\u{17bb}\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ತಮಾಲ\u{cc6}"),
            keywords: &[
                "ತಮಾಲ\u{cc6}",
                "ಮ\u{cc6}ಕ\u{ccd}ಸ\u{cbf}ಕನ\u{ccd}",
                "ಸುತ\u{ccd}ತ\u{cbf}ಕೊಂಡ\u{cbf}ರುವ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("타말레"),
            keywords: &["감싼", "멕시칸", "타말레"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("टमाल\u{947}"),
            keywords: &[
                "ग\u{941}ठलायिल\u{94d}ल\u{947}\u{902}",
                "टमाल\u{947}",
                "म\u{945}क\u{94d}सिकन",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тамале"),
            keywords: &["тамале"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພ\u{eb1}ບ"),
            keywords: &[
                "ພ\u{eb1}ບ",
                "ຫ\u{ecd}\u{ec8}",
                "ແມ\u{eb1}ກຊ\u{eb5}ກ\u{eb1}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vyniotinis"),
            keywords: &["meksikietiškas", "susuktas", "vyniotinis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("tamale"),
            keywords: &["meksikāņu", "satīts", "tamale", "vraps"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("тамале"),
            keywords: &["замотана", "мексиканска", "тамале"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ട\u{d3e}മേൽ"),
            keywords: &[
                "ട\u{d3e}മേൽ",
                "മെക\u{d4d}സിക\u{d4d}കൻ",
                "റ\u{d3e}പ\u{d4d}ഡ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("тамале"),
            keywords: &["мексик", "ороосон", "тамале"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("तमाल\u{947}"),
            keywords: &[
                "ग\u{941}\u{902}डाल\u{947}ल\u{947}",
                "तमाल\u{947}",
                "म\u{947}क\u{94d}सिकन",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tamale"),
            keywords: &["berbungkus", "mexico", "tamale"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တာမာလ\u{102e}"),
            keywords: &[
                "တာမာလ\u{102e}",
                "မက\u{103a}ဆ\u{102e}ကန\u{103a}",
                "အလ\u{102d}ပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("tamal"),
            keywords: &["latinamerikansk", "meksikansk", "tamal", "wrap"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("टिमाली"),
            keywords: &["टिमाली", "ब\u{947}र\u{947}को", "म\u{947}क\u{94d}सिकन"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("tamale"),
            keywords: &["Mexicaans", "gevuld", "tamale"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("tamal"),
            keywords: &["latinamerikansk", "meksikansk", "tamal", "wrap"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଟମ\u{b3e}ଲେ"),
            keywords: &[
                "ଟମ\u{b3e}ଲେ",
                "ମେକ\u{b4d}ସ\u{b3f}କ\u{b3e}ନ",
                "ର\u{b3e}ପଡ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਤਮਾਲ"),
            keywords: &["ਤਮਾਲ", "ਮ\u{a48}ਕਸੀਕਨ", "ਰ\u{a4b}ਲ", "ਲਪ\u{a47}ਟਿਆ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tamálẹ"),
            keywords: &["Mẹ\u{301}ksíko", "Rap", "Tamálẹ"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("tamales"),
            keywords: &["meksykańskie", "tamales", "zawijane"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("تمالا"),
            keywords: &["تاو شوې", "تمالا", "ميکسيکي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("tamale"),
            keywords: &["enrolado", "mexicano", "tamale"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["mexicano", "tamale", "wrap"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tamal"),
            keywords: &["mexicano", "tamal", "tapasqa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("tamale"),
            keywords: &["colțunaș", "mâncare mexicană", "tamale"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-042"),
            keywords: &["E13-042"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("тамале"),
            keywords: &["завернутый", "мексиканский", "тамал", "тамале"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٽيميل"),
            keywords: &["ميڪسيڪين", "ويڙهيل", "ٽيميل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("තමලේ"),
            keywords: &["එත\u{dd6}", "තමලේ", "මෙක\u{dca}ස\u{dd2}ක\u{dcf}න\u{dd4}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("tamal"),
            keywords: &["mexické", "tamal"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("tamale"),
            keywords: &["mehiška", "tamale", "zavitek"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("unno maksikaan"),
            keywords: &["cunno maksikaan", "duuban", "maksikaan", "unno maksikaan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("tamale"),
            keywords: &["me pite", "tamale", "ushqim meksikan"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("тамале"),
            keywords: &["завитак", "мексички", "тамале"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("tamale"),
            keywords: &["meksički", "tamale", "zavitak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tamale"),
            keywords: &["mexikanskt", "tamale", "wrap"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("tamale"),
            keywords: &["meksiko", "mkate uliofungwa wa kimeksiko", "tamale"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("தம\u{bbe}லே"),
            keywords: &[
                "சுற\u{bcd}றப\u{bcd}பட\u{bcd}டது",
                "தம\u{bbe}லே",
                "மெக\u{bcd}சிகன\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("తమ\u{c3e}ల\u{c47}"),
            keywords: &[
                "చుట\u{c4d}ట\u{c3f}నద\u{c3f}",
                "తమ\u{c3e}ల\u{c47}",
                "మ\u{c46}క\u{c4d}స\u{c3f}కన\u{c4d}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ทามาเล\u{e48}"),
            keywords: &[
                "ทามาเล\u{e48}",
                "ห\u{e48}อห\u{e38}\u{e49}ม",
                "เม\u{e47}กซ\u{e34}โก",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("tamale"),
            keywords: &["dolanan", "meksikan", "tamale"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mā pulupulu"),
            keywords: &["mā pulupulu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("tamale"),
            keywords: &["Meksika yemeği", "dürüm", "tamale"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("тамале"),
            keywords: &["завиванець", "мексиканська страва", "тамале"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ٹمالے"),
            keywords: &["لپیٹا ہوا", "میکسیکن", "ٹمالے"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tamale"),
            keywords: &["meksika", "meksikancha", "oʻralgan", "oʻrama", "tamale"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bánh tamale"),
            keywords: &["Mexico", "bánh tamale", "cuốn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("墨西哥粽"),
            keywords: &["墨西哥", "墨西哥粽", "手卷"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("墨西哥粽"),
            keywords: &["墨西哥", "墨西哥粽", "手卷"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("墨西哥粽子"),
            keywords: &["墨西哥", "墨西哥粽子", "粽子"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("玉米粉蒸肉"),
            keywords: &["墨西哥", "捲餅", "玉米粉蒸肉"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-tamale"),
            keywords: &["goqiwe", "i-mexican", "i-tamale"],
        },
    ],
};
#[doc = "🥙"]
pub const STUFFED_FLATBREAD: crate::Emoji = crate::Emoji {
    glyph: "🥙",
    codepoint: "1F959",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "stuffed flatbread",
    group: "Food & Drink",
    subgroup: "food-prepared",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("wrap"),
            keywords: &["bunny chow", "kos", "platbrood", "wrap"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("በምግብ የተሞላ ዳቦ"),
            keywords: &["ምግብ", "በምግብ የተሞላ ዳቦ", "ከባብ", "የተሞላ", "ጅይሮ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("خبز مفرود محشو"),
            keywords: &[
                "خبز مفرود",
                "خبز مفرود محشو",
                "طعام",
                "فلافل",
                "كباب",
                "محشو",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ষ\u{9cd}ট\u{9be}ফড ফ\u{9cd}লেটব\u{9cd}ৰেড"),
            keywords: &[
                "কব\u{9be}ব",
                "খ\u{9be}দ\u{9cd}য",
                "গ\u{9be}ইৰো",
                "ফল\u{9be}ফেল",
                "ফ\u{9cd}লেটব\u{9cd}ৰেড",
                "ষ\u{9cd}ট\u{9be}ফড",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qutab"),
            keywords: &["bişirmək", "qutab", "yemək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("піта"),
            keywords: &["златка", "кебаб", "лаваш", "піта", "шаўрма"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("пълнена питка"),
            keywords: &["пълнена питка", "фалафел", "храна"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9c1}র ভর\u{9be} প\u{9be}উর\u{9c1}টি"),
            keywords: &[
                "ক\u{9be}ব\u{9be}ব",
                "খ\u{9be}ব\u{9be}র",
                "গ\u{9be}ইরো",
                "চেপ\u{9cd}ট\u{9be}র\u{9c1}টি",
                "প\u{9c1}র ভর\u{9be} প\u{9be}উর\u{9c1}টি",
                "ফল\u{9be}ফেল",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kebab"),
            keywords: &["boued", "falafel", "kebab", "sandwich"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kebab"),
            keywords: &["falafel", "giros", "hrana", "kebab", "lepinja", "punjeno"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("durum"),
            keywords: &["durum", "falàfel", "farcit", "kebab", "pa"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏆᏅᏓᏅ ᎠᏍᏓᏅᏅᎢ ᎦᏚ"),
            keywords: &[
                "ᎠᎩᏍᏗ",
                "ᎠᏍᏓᏅᏅᎢ ᎦᏚ",
                "ᎦᏆᏅᏓᏅ",
                "ᎦᏆᏅᏓᏅ ᎠᏍᏓᏅᏅᎢ ᎦᏚ",
                "ᎨᏆᏆ",
                "ᏥᎶ",
                "ᏩᎳᏪᎵ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("plněná pita"),
            keywords: &[
                "falafel",
                "gyros",
                "jídlo",
                "kebab",
                "plněná pita",
                "plněný",
                "sendvič",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bara gwastad wedi’i stwffio"),
            keywords: &[
                "bara gwastad",
                "bara gwastad wedi’i stwffio",
                "bwyd",
                "cebab",
                "ffalaffel",
                "gyro",
                "wedi stwffio",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("fyldt pitabrød"),
            keywords: &[
                "falafel",
                "fladbrød",
                "fyld",
                "fyldt",
                "fyldt pitabrød",
                "gyros",
                "kebab",
                "mad",
                "pandekage med fyld",
                "pita",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Döner"),
            keywords: &["Döner", "Döner Kebab", "Falafel", "Wrap"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γεμιστή λαγάνα"),
            keywords: &[
                "γεμιστή λαγάνα",
                "γύρος",
                "κεμπάπ",
                "σάντουιτς",
                "τροφή",
                "φαλάφελ",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("stuffed flatbread"),
            keywords: &["falafel", "flatbread", "food", "gyro", "kebab", "stuffed"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("pita roll"),
            keywords: &[
                "falafel",
                "flatbread",
                "food",
                "gyro",
                "kebab",
                "pita",
                "pita roll",
                "stuffed",
            ],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pan relleno"),
            keywords: &[
                "comida",
                "durum",
                "falafel",
                "kebab",
                "pan de pita",
                "pan relleno",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("fajita"),
            keywords: &["comida", "fajita", "gyro", "kebab", "relleno"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("pita rellena"),
            keywords: &[
                "gyro",
                "kebab",
                "pan árabe",
                "pita",
                "pita rellena",
                "relleno",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("täidetud pita"),
            keywords: &["falafel", "kebab", "toit", "täidetud pita"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ogitarteko betea"),
            keywords: &[
                "falafel",
                "gyro",
                "janari",
                "kebab",
                "ogitarteko bete",
                "ogitarteko betea",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("لقمه"),
            keywords: &[
                "جایرو",
                "غذا",
                "فلافل",
                "لقمه",
                "نان پیتا",
                "کباب",
                "کباب ترکی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("täytetty pita"),
            keywords: &[
                "falafel",
                "kebab",
                "leipä",
                "pita",
                "ruoka",
                "täyte",
                "täytetty pita",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("stuffed flatbread"),
            keywords: &[
                "falafel",
                "flatbread",
                "kebab",
                "pagkain",
                "stuffed flatbread",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("fylt flatbreyð"),
            keywords: &["falafel", "flatbreyð", "fylt", "kebabb", "matur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("kebab"),
            keywords: &["falafel", "kebab"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("pain plat garni"),
            keywords: &[
                "chichekébab",
                "doner",
                "falafel",
                "gyro",
                "kébab",
                "pain plat garni",
                "pita",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("arán leathan stuáilte"),
            keywords: &[
                "arán leathan stuáilte",
                "bia",
                "ceibeab",
                "falafel",
                "fillteog",
                "kebab",
                "tortilla",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aran-rèidh lìonta"),
            keywords: &[
                "aran rèidh lìonta",
                "aran-rèidh",
                "biadh",
                "falafel",
                "gyro",
                "kebab",
                "lìonta",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("kebab"),
            keywords: &["comida", "falafel", "kebab"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ભર\u{ac7}લી ફલ\u{ac7}ટબ\u{acd}ર\u{ac7}ડ"),
            keywords: &[
                "કબાબ",
                "ફલાફલ",
                "ફલ\u{ac7}ટબ\u{acd}ર\u{ac7}ડ",
                "ભર\u{ac7}લી ફલ\u{ac7}ટબ\u{acd}ર\u{ac7}ડ",
                "ભર\u{ac7}લ\u{ac1}\u{a82}",
                "ભોજન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("cikakken burodi"),
            keywords: &[
                "abinci",
                "burodi mai lebur",
                "cikakke",
                "cikakken burodi",
                "falafel",
                "kebab",
                "wuta",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פיתה עם פלאפל"),
            keywords: &[
                "אוכל רחוב",
                "לאפה",
                "פיתה",
                "פיתה עם פלאפל",
                "פלאפל",
                "שווארמה",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("भरा ह\u{941}आ पराठा"),
            keywords: &[
                "कबाब",
                "गायरो",
                "चपाती",
                "फलाफल",
                "भरवा\u{902}",
                "भरा ह\u{941}आ पराठा",
                "भोजन",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kebab"),
            keywords: &["falafel", "giros", "hrana", "kebab", "lepinja"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("pita"),
            keywords: &["falafel", "gírosz", "kebab", "pita", "töltött", "étel"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("լավաշով բրդուճ"),
            keywords: &["բրդուճ", "գիրոս", "լավաշ", "լավաշով բրդուճ", "շաուրմա"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("roti tawar isi"),
            keywords: &["falafel", "kebab", "makanan", "roti isi", "roti tawar isi"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("achịcha akwụkwọnri nwụrụ anwụ"),
            keywords: &[
                "achịcha akwụkwọnri nwụrụ anwụ",
                "achịchanwụrụ anwụ",
                "akpụrụ akpụ achịcha",
                "akwụkwọnri",
                "gyro",
                "nri",
                "nri anụ na achịcha",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kebab"),
            keywords: &["kebab", "kebap", "matur", "rúlla"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pita farcita"),
            keywords: &["falafel", "gyro", "kebab", "pita farcita", "ripieno"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ケバブサンド"),
            keywords: &["ケバブ", "ケバブサンド", "ラップサンド"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("roti pita gulung"),
            keywords: &[
                "dhaharan",
                "falafel",
                "isi",
                "kebab turki",
                "kebab yunani",
                "roti pita",
                "roti pita gulung",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ვრაპი"),
            keywords: &[
                "გატენილი",
                "ვრაპი",
                "ლავაში",
                "საკვები",
                "ფალაფელი",
                "შაურმა",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шаурма"),
            keywords: &["жылдам", "тағам", "шаурма"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("fladbrød med fyld"),
            keywords: &[
                "fladbrød",
                "fladbrød med fyld",
                "fyld",
                "fyldt",
                "gyros",
                "mad",
                "pandekage med fyld",
                "pita",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ន\u{17c6}ប\u{17c9}\u{17d0}ងដាក\u{17cb}សាច\u{17cb}"),
            keywords: &[
                "ដាក\u{17cb}សាច\u{17cb}",
                "ន\u{17c6}កេបាប\u{17cb}",
                "ន\u{17c6}ក\u{17d2}រ\u{17bc}ច",
                "ន\u{17c6}ដ\u{17bb}ត",
                "ន\u{17c6}ប\u{17c9}\u{17d0}ងខ\u{17d2}ចប\u{17cb}សាច\u{17cb}",
                "ន\u{17c6}ប\u{17c9}\u{17d0}ងដាក\u{17cb}សាច\u{17cb}",
                "អាហារ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ತುಂಬ\u{cbf}ದ ಬ\u{ccd}ರ\u{cc6}ಡ\u{ccd}"),
            keywords: &[
                "ಆಹಾರ",
                "ಕಬಾಬ\u{ccd}",
                "ಗೈರೋ",
                "ತುಂಬ\u{cbf}ದ ಬ\u{ccd}ರ\u{cc6}ಡ\u{ccd}",
                "ಫಲಾಫ\u{cc6}ಲ\u{ccd}",
                "ಬ\u{ccd}ರ\u{cc6}ಡ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("밀전병에 싼 요리"),
            keywords: &["밀전병에 싼 요리", "부리또"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("भरिल\u{94d}लो सपाटपाव"),
            keywords: &[
                "अन\u{94d}न",
                "कबाब",
                "गायरो",
                "फालाफ\u{947}ल",
                "भरिल\u{94d}लो",
                "सपाटपाव",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("шаурма"),
            keywords: &["жупка", "кебаб", "тамак", "шаурма"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Kebab"),
            keywords: &[
                "Falafel",
                "Gyros",
                "Iessen",
                "Kebab",
                "flaacht Brout",
                "gefëllt",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຂ\u{ebb}\u{ec9}າຈ\u{eb5}\u{ec8}ແຜ\u{ec8}ນຍ\u{eb1}ດໄສ\u{ec9}"),
            keywords: &[
                "ຊ\u{eb5}\u{ec9}ນສະເຕະ",
                "ຍ\u{eb1}ດໄສ\u{ec9}",
                "ລ\u{eb9}ກຊ\u{eb5}\u{ec9}ນຈ\u{eb7}ນ",
                "ອາຫານ",
                "ເຂ\u{ebb}\u{ec9}າຈ\u{eb5}\u{ec8}ແຜ\u{ec8}ນ",
                "ເຂ\u{ebb}\u{ec9}າຈ\u{eb5}\u{ec8}ແຜ\u{ec8}ນຍ\u{eb1}ດໄສ\u{ec9}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("įdarytas lavašas"),
            keywords: &["lavašas", "maistas", "įdaras", "įdarytas lavašas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pildīts lavašs"),
            keywords: &["giross", "kebabs", "lavašs", "pildīts", "ēdiens"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("parāoapapa whakakī"),
            keywords: &[
                "kai",
                "kepapa",
                "parāoapapa",
                "tōrino",
                "whakakī",
                "wharawhere",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("гиро"),
            keywords: &["гиро", "донер"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "സ\u{d4d}റ\u{d4d}റഫ\u{d4d} ചെയ\u{d4d}ത ഫ\u{d4d}ല\u{d3e}റ\u{d4d}റ\u{d4d}\u{200c}ബ\u{d4d}രെഡ\u{d4d}",
            ),
            keywords: &[
                "കബ\u{d3e}ബ\u{d4d}",
                "ബ\u{d4d}രെഡ\u{d4d}",
                "സ\u{d4d}റ\u{d4d}റഫ\u{d4d} ചെയ\u{d4d}ത ഫ\u{d4d}ല\u{d3e}റ\u{d4d}റ\u{d4d}\u{200c}ബ\u{d4d}രെഡ\u{d4d}",
                "സ\u{d4d}റ\u{d4d}റഫ\u{d4d} ചെയ\u{d4d}തത\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хавчуургатай ороомог"),
            keywords: &[
                "гиро",
                "кебаб",
                "фалафел",
                "хавтгай талх",
                "хавчуургатай",
                "хавчуургатай ороомог",
                "хүнс",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("भरल\u{947}ली फ\u{94d}ल\u{947}टब\u{94d}र\u{947}ड"),
            keywords: &[
                "कबाब",
                "खाद\u{94d}य",
                "गायरो",
                "फलाफल",
                "फ\u{94d}ल\u{945}टब\u{94d}र\u{947}ड",
                "भरल\u{947}ली",
                "भरल\u{947}ली फ\u{94d}ल\u{947}टब\u{94d}र\u{947}ड",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("roti kebab"),
            keywords: &["berinti", "falafel", "kebab", "makanan", "roti kebab"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ħobż ċatt mimli"),
            keywords: &[
                "falafel",
                "gyro",
                "ikel",
                "kebab",
                "mimli",
                "ħobż ċatt",
                "ħobż ċatt mimli",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("န\u{1036}ပြားအစာသ\u{103d}တ\u{103a}"),
            keywords: &[
                "ခဘတ\u{103a}",
                "န\u{1036}ပြား",
                "န\u{1036}ပြားအစာသ\u{103d}တ\u{103a}",
                "ဘယာကြော\u{103a}",
                "အစားအသောက\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("fylt pitabrød"),
            keywords: &["falafel", "fylt pitabrød", "gyro", "kebab", "mat", "pita"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}टफ\u{94d}ड फ\u{94d}ल\u{94d}याटब\u{94d}र\u{947}ड"),
            keywords: &[
                "कबाब",
                "खाना",
                "गाइरो",
                "फलाफ\u{947}इ",
                "फ\u{94d}ल\u{94d}याटब\u{94d}र\u{947}ड",
                "स\u{94d}टफ\u{94d}ड",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gevuld pitabroodje"),
            keywords: &[
                "falafel",
                "gevuld",
                "gevuld pitabroodje",
                "gyro",
                "kebab",
                "pitabrood",
                "voedsel",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("fylt pitabrød"),
            keywords: &["falafel", "fylt pitabrød", "gyro", "kebab", "mat", "pita"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ପ\u{b41}ର ଦ\u{b3f}ଆଯ\u{b3e}ଇଥ\u{b3f}ବ\u{b3e} ଚଟକ\u{b3e} ପ\u{b3e}ଉ\u{b01}ର\u{b41}ଟ\u{b3f}",
            ),
            keywords: &[
                "କବ\u{b3e}ବ\u{b4d}",
                "ଖ\u{b3e}ଦ\u{b4d}ୟ",
                "ଗ\u{b3e}ଇରୋ",
                "ଚଟକ\u{b3e} ପ\u{b3e}ଉ\u{b01}ର\u{b41}ଟ\u{b3f}",
                "ପ\u{b41}ର ଥ\u{b3f}ବ\u{b3e} ଚଟକ\u{b3e} ପ\u{b3e}ଉ\u{b01}ର\u{b41}ଟ\u{b3f}",
                "ପ\u{b41}ର ଦ\u{b3f}ଆଯ\u{b3e}ଇଥ\u{b3f}ବ\u{b3e} ଚଟକ\u{b3e} ପ\u{b3e}ଉ\u{b01}ର\u{b41}ଟ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਭਰਕ\u{a47} ਬਣਾਇਆ ਫਲ\u{a48}ਟਬ\u{a4d}ਰ\u{a48}\u{a71}ਡ"),
            keywords: &[
                "ਕਬਾਬ",
                "ਜਾਇਰ\u{a4b}",
                "ਫਲਾਫਲ",
                "ਭਰਕ\u{a47} ਬਣਾਇਆ ਫਲ\u{a48}ਟਬ\u{a4d}ਰ\u{a48}\u{a71}ਡ",
                "ਭਰਵਾ\u{a02}",
                "ਭ\u{a4b}ਜਨ",
                "ਰ\u{a4b}ਟੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پری ہوئی برابر روٹی"),
            keywords: &[
                "بھریا ہوئیا",
                "خوراک",
                "فلافل",
                "پری ہوئی برابر روٹی",
                "چپاتی",
                "چکر",
                "کباب",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Flátbrẹd wit ọ\u{301}dá fud ínsaid"),
            keywords: &[
                "Flátbrẹd",
                "Flátbrẹd wit ọ\u{301}dá fud ínsaid",
                "Fud",
                "Grík Fud Wé Im Nem Na Jaíro",
                "Kẹbab",
                "Mídúl Íst Fud Wé Im Nem Na Faláful",
                "Súya",
                "To Fúl Fud Wít Ọ\u{301}dá Kaín Fud",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wrap"),
            keywords: &["falafel", "gyros", "jedzenie", "kebab", "tortilla", "wrap"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("خړوب شوي ډک"),
            keywords: &["خړوب شوي ډک"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pão recheado"),
            keywords: &["comida", "kebab", "pão", "pão recheado", "recheio", "wrap"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("pita"),
            keywords: &["falafel", "kebab", "pita", "recheado"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("juntʼachisqa tʼanta moldepi"),
            keywords: &[
                "fatafel",
                "giro",
                "guiso",
                "juntʼachisqa tʼanta moldepi",
                "kebab",
                "llaplla t’anta",
                "mikhuna",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("lipie umplută"),
            keywords: &[
                "falafel",
                "giros",
                "kebab",
                "lipie",
                "lipie umplută",
                "mâncare",
                "șaorma",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1077"),
            keywords: &["E10-1077"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("шаурма"),
            keywords: &[
                "еда",
                "кебаб",
                "лаваш",
                "пита",
                "фалафель",
                "шаверма",
                "шаурма",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugati wapakiwemo ibiryo imbere"),
            keywords: &[
                "boroshete",
                "bulete y’amashaza",
                "capati",
                "ibiribwa",
                "sanduwice irimo inyama",
                "umugati wapakiwemo ibiryo imbere",
                "yapakiwemo",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪوڪي"),
            keywords: &["ڪباب، فلافل، جيورو، ڪوڪي، کاڌو", "ڪوڪي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd2}රව\u{dd6} ප\u{dcf}න\u{dca}"),
            keywords: &[
                "කෑම",
                "කෙබ\u{dcf}බ\u{dca}",
                "ගය\u{dd2}රෝ",
                "ප\u{dd2}රව\u{dd6} ප\u{dcf}න\u{dca}",
                "ෆලෆෙල\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("gyros"),
            keywords: &["falafel", "gyros", "jedlo", "kebab", "plnené"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kebab"),
            keywords: &["falafel", "gyros", "hrana", "kebab", "nadev"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("rooti khudrad laga buuxiyay"),
            keywords: &["cunto", "falafeel", "rooti khudrad laga buuxiyay"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("bukë e sheshtë me mbushje"),
            keywords: &[
                "bukë e mbushur",
                "bukë e sheshtë me mbushje",
                "giro",
                "palapetë e mbushur",
                "ushqim",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("гирос"),
            keywords: &["гирос", "кебаб", "пуњено", "тортиља", "храна"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("giros"),
            keywords: &["giros", "hrana", "kebab", "punjeno", "tortilja"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("pitabröd"),
            keywords: &["falafel", "gyro", "kebab", "mat", "pita", "pitabröd"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("shawarma"),
            keywords: &["chakula", "shawarma"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ரொட\u{bcd}டி வகை உணவு"),
            keywords: &["உணவு", "ரொட\u{bcd}டி", "ரொட\u{bcd}டி வகை உணவு"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c4d}టఫ\u{c4d} చ\u{c47}స\u{c3f}న చదున\u{c48}న బ\u{c4d}ర\u{c46}డ\u{c4d}"),
            keywords: &[
                "ఆహ\u{c3e}రం",
                "కబ\u{c3e}బ\u{c4d}",
                "జ\u{c48}ర\u{c4b}",
                "ఫుల\u{c3e}ఫల\u{c4d}",
                "ఫ\u{c4d}ల\u{c3e}ట\u{c4d}\u{200c}బ\u{c4d}ర\u{c46}డ\u{c4d}",
                "స\u{c4d}టఫ\u{c4d} చ\u{c47}స\u{c3f}న",
                "స\u{c4d}టఫ\u{c4d} చ\u{c47}స\u{c3f}న చదున\u{c48}న బ\u{c4d}ర\u{c46}డ\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("нони қима андохташуда"),
            keywords: &[
                "гирос",
                "кабоб",
                "нони чапотӣ",
                "нони қима андохташуда",
                "фалафел",
                "ғизо",
                "қима андохташуда",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เคบ\u{e31}บ"),
            keywords: &["อาหาร", "เคบ\u{e31}บ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("dykylan çörek"),
            keywords: &[
                "dolma",
                "dykylan çörek",
                "falafel",
                "iýmit",
                "kebap",
                "lawaş",
                "petir",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mā falati"),
            keywords: &["mā falati"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("dürüm"),
            keywords: &[
                "döner", "dürüm", "falafel", "kebap", "pide", "sarma", "yiyecek",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تۈگۈك بولكا"),
            keywords: &[
                "تۈگۈك",
                "تۈگۈك بولكا",
                "جىرو",
                "فالافېل",
                "كاۋاپ",
                "يېمەكلىك",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("піта"),
            keywords: &["кебаб", "лаваш", "начинка", "піта", "фалафель", "їжа"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بھری ہوئی چپاتی"),
            keywords: &["بھری ہوئی", "بھری ہوئی چپاتی", "خوراک", "چپاتی", "کباب"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("shaurma"),
            keywords: &[
                "falafel",
                "giros",
                "kabob",
                "non",
                "qiymalangan",
                "shaurma",
                "taom",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bánh mì kẹp thịt"),
            keywords: &[
                "bánh mì kẹp thịt",
                "bánh mỳ dẹt",
                "bánh mỳ gyro",
                "bánh mỳ kẹp thịt nướng",
                "nhồi",
                "viên bột đậu rán",
                "đồ ăn",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("mburu-farsi"),
            keywords: &[
                "falafel",
                "farse",
                "jiro",
                "kebab",
                "lekk",
                "mburu",
                "mburu-farsi",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isonka esimcaba esihlohliweyo"),
            keywords: &[
                "ehlohliweyo",
                "i-falafel",
                "i-gyro",
                "i-kebab",
                "isonka esimcaba esihlohliweyo",
                "isonke esimcaba",
                "ukutya",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Burẹdi Afunpọ Pẹlẹbẹ"),
            keywords: &[
                "Burẹdi Afunpọ Pẹlẹbẹ",
                "búrẹdì àfúnpọ\u{300} pẹlẹbẹ",
                "falafe",
                "gyro",
                "kebab",
                "stuufe",
                "ónjẹ",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("餡餅"),
            keywords: &["三文治", "沙律三文治", "烤肉串", "食物", "餡餅", "麵包"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("馅饼"),
            keywords: &["三文治", "沙律三文治", "烤肉串", "面包", "食物", "馅饼"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("夹心饼"),
            keywords: &["夹心", "夹心饼", "沙拉三明治", "肉夹馍", "食物"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("薄捲餅"),
            keywords: &["薄捲餅", "食物"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("有餡三文治"),
            keywords: &["口袋餅", "有餡三文治", "皮塔", "皮塔三文治"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isinkwa esishuthekwe ukudla"),
            keywords: &[
                "falafel",
                "gyro",
                "isinkwa",
                "isinkwa esishuthekwe ukudla",
                "kebab",
                "shuthekiwe",
                "ukudla",
            ],
        },
    ],
};
#[doc = "🧆"]
pub const FALAFEL: crate::Emoji = crate::Emoji {
    glyph: "🧆",
    codepoint: "1F9C6",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "falafel",
    group: "Food & Drink",
    subgroup: "food-prepared",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("falafel"),
            keywords: &["falafel", "frikkadel", "keker-ertjie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ብስኩት"),
            keywords: &["ሽምብራ", "ብስኩት", "የስጋ ኳስ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("فلافل"),
            keywords: &["حمص", "طعمية", "فلافل", "كرات لحم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ফল\u{9be}ফেল"),
            keywords: &["ফল\u{9be}ফেল", "ব\u{9c1}ট", "মিটবল"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("falafel"),
            keywords: &["falafel", "küftə", "noxud"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("фалафель"),
            keywords: &["нут", "фалафель", "фрыкадэлька", "шарык"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("фалафел"),
            keywords: &["кюфте", "нахут", "фалафел"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ফল\u{9be}ফেল"),
            keywords: &["ছোল\u{9be}", "ফল\u{9be}ফেল", "মিটবল"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("falafel"),
            keywords: &["falafel", "pouloud"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("falafel"),
            keywords: &["falafel", "leblebije", "okruglice od leblebija"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("falàfel"),
            keywords: &["cigró", "falàfel", "mandonguilla"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏍᏆᏞᏍᏗ ᏚᏳᎾᏍᏗᎢ"),
            keywords: &["ᎭᏫᏯ ᏍᏆᏞᏍᏗ", "ᏍᏆᏞᏍᏗ ᏚᏳᎾᏍᏗᎢ", "ᏚᏳᎾᏍᏗᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("falafel"),
            keywords: &[
                "boby",
                "cizrna",
                "falafel",
                "karbanátky",
                "koule",
                "kuličky",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ffalaffel"),
            keywords: &["ffalaffel", "gwygbysen", "peli cig"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("falafel"),
            keywords: &["falafel", "kikært", "kødbolle"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Falafel"),
            keywords: &["Bällchen", "Falafel", "Kichererbsen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("φαλάφελ"),
            keywords: &["κεφτές", "ρεβίθι", "φαλάφελ"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("falafel"),
            keywords: &["chickpea", "falafel", "meatball"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["chick pea", "chickpea", "falafel", "meatball"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("falafel"),
            keywords: &["albóndiga", "falafel", "garbanzo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["albóndigas", "bolas de garbanzo", "falafel"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("falafel"),
            keywords: &["falafel", "kikerhernes", "lihapall"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("falafela"),
            keywords: &["falafela", "haragi-bola", "txitxirioa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("فلافل"),
            keywords: &["فلافل", "نخود", "کوفته قلقلی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("falafel"),
            keywords: &["falafel", "kasvispyörykkä", "kikherne"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("falafel"),
            keywords: &["chickpea", "falafel", "meatball"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("falafel"),
            keywords: &["falafel", "kjøtfrikadella", "matur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("falafels"),
            keywords: &[
                "boulettes",
                "falafels",
                "pois chiches",
                "seitan",
                "soja",
                "viande",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("falafel"),
            keywords: &["falafel", "millín feola", "sicphiseánach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("falafel"),
            keywords: &["bàla-feòla", "cearc-pheasair", "cic-pheasair", "falafel"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("faláfel"),
            keywords: &["albóndegas", "faláfel", "garavanzo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ફલાફલ"),
            keywords: &["કાબ\u{ac1}લી ચણા", "ફલાફલ", "મીટબૉલ"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פלאפל"),
            keywords: &["אוכל רחוב", "חומוס", "כדורים", "פלאפל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("फ\u{93c}लाफ\u{93c}\u{947}ल"),
            keywords: &["फ\u{93c}लाफ\u{93c}\u{947}ल"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("falafel"),
            keywords: &["falafel", "okruglice", "slanutak", "ćufte"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("falafel"),
            keywords: &["csicseriborsó", "falafel", "húsgolyó"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ֆալաֆել"),
            keywords: &["մսագնդիկ", "սիսեռ", "ֆալաֆել"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("falafel"),
            keywords: &["bebola", "falafel", "kacang arab"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("falafel"),
            keywords: &["falafel", "kjötbollur", "kjúklingabaunir"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("falafel"),
            keywords: &["ceci", "falafel", "polpette di ceci"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ファラフェル"),
            keywords: &["コロッケ", "ヒヨコマメ", "ファラフェル", "肉団子"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bakwan falafel"),
            keywords: &["bakso", "bakwan falafel", "kacang garbanzo"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ფალაფელი"),
            keywords: &["ბარდა", "ბურთები", "მუხუდო", "ფალაფელი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("фалафель"),
            keywords: &["бұршақ ет", "ноқат", "фалафель"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ន\u{17c6}ហ\u{17d2}វាឡាហ\u{17d2}វល\u{17cb}"),
            keywords: &[
                "ន\u{17c6}ហ\u{17d2}វាឡាហ\u{17d2}វល\u{17cb}",
                "ប\u{17d2}រហ\u{17b7}ត",
                "សណ\u{17d2}តែក\u{200b}បារា\u{17c6}ង\u{200b}ពណ\u{17cc}លឿង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಫಲಾಫ\u{cc6}ಲ\u{ccd}"),
            keywords: &[
                "ಚ\u{cbf}ಕ\u{ccd}\u{200c}ಪೀ",
                "ಫಲಾಫ\u{cc6}ಲ\u{ccd}",
                "ಮೀಟ\u{ccd}\u{200c}ಬಾಲ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("팔라펠"),
            keywords: &["미트볼", "병아리콩", "팔라펠"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("फालाफ\u{947}ल"),
            keywords: &["चिकपी", "फालाफ\u{947}ल", "मीटबॉल"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("фалафель"),
            keywords: &["буурчактай", "фалафель", "фрикаделька"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຟາ\u{200b}ລາ\u{200b}ເຟວ"),
            keywords: &[
                "ຖ\u{ebb}\u{ec8}ວ\u{200b}ຊ\u{eb4}ກ\u{200b}ພ\u{eb5}",
                "ຟາ\u{200b}ລາ\u{200b}ເຟວ",
                "ລ\u{eb9}ກ\u{200b}ຊ\u{eb5}\u{ec9}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("falafelis"),
            keywords: &["falafelis", "mėsos kukulis", "vištiena"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("felāfels"),
            keywords: &["aunazirņi / frikadele", "felāfels"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("фалафел"),
            keywords: &["фалафел", "ќофте"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഫല\u{d3e}ഫൽ"),
            keywords: &["കടല", "ഫല\u{d3e}ഫൽ", "മീറ\u{d4d}റ\u{d4d}\u{200c}ബോൾ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("фалафель"),
            keywords: &["бөөрөнхий мах", "бөөрөнцөг", "фалафель", "шош"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("फालाफ\u{947}ल"),
            keywords: &["फालाफ\u{947}ल", "मीटबॉल", "हरभरा"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("falafel"),
            keywords: &["bebola daging", "falafel", "kacang kuda"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဘယာကြော\u{103a}"),
            keywords: &[
                "က\u{102f}လားပ\u{1032}",
                "ဘယာကြော\u{103a}",
                "မ\u{102f}န\u{1037}\u{103a}လ\u{102f}\u{1036}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("falafel"),
            keywords: &["falafel", "kikerter", "kjøttboller"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("फालाफ\u{947}ल"),
            keywords: &["चिकपि", "फालाफ\u{947}ल", "मिटबल"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("falafel"),
            keywords: &["falafel", "gehaktbal", "kikkererwt"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("falafel"),
            keywords: &["falafel", "kikerter", "kjøtbollar"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଫଲ\u{b3e}ଫେଲ"),
            keywords: &[
                "କ\u{b3e}ବ\u{b41}ଲ\u{b3f} ଚଣ\u{b3e}",
                "ଫଲ\u{b3e}ଫେଲ",
                "ମୀଟବଲ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਫਲਾਫ\u{a47}ਲ"),
            keywords: &["ਛ\u{a4b}ਲ\u{a47}", "ਫਲਾਫ\u{a47}ਲ", "ਮੀਟਬਾਲ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Faláfẹl"),
            keywords: &[
                "Faláfẹl",
                "Mídúl Íst Fud Wé Im Nem Na Faláful",
                "Mítbọl: Mít Wé Dẹm Móld Laik Bọl",
                "Smọ\u{301}l Raúnd Sid Wé Im Nem Na Chíkpii",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("falafel"),
            keywords: &["ciecierzyca", "falafel", "kotlecik z ciecierzycy"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("فلافل"),
            keywords: &["غونډاری", "فلافل", "نخود"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("falafel"),
            keywords: &["almôndega", "falafel", "grão de bico"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("faláfel"),
            keywords: &["almôndega", "faláfel", "grão de bico"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("fatafel"),
            keywords: &["albondiga", "fatafel", "garganzo"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("falafel"),
            keywords: &["chifteluță", "falafel", "năut"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–045"),
            keywords: &["E12–045"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("фалафель"),
            keywords: &[
                "бобовый",
                "бобы",
                "горох",
                "гороховый",
                "нут",
                "фалафель",
                "шарик",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("فلافيل"),
            keywords: &["فلافيل", "ميٽ بال", "چڻا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ෆැලෆෙල\u{dca}"),
            keywords: &[
                "කොණ\u{dca}ඩකඩල",
                "ම\u{dd3}ට\u{dca}බෝල\u{dca}",
                "ෆැලෆෙල\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("falafel"),
            keywords: &["bôby", "cícer", "falafel", "fašírka", "gule", "guličky"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("falafel"),
            keywords: &["falafel", "kroglica", "čičerika"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("falafeel"),
            keywords: &["diggaag-digir", "falafeel", "hilibka jarjaran"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("qofte falafel"),
            keywords: &["qofte falafel", "qofte me bishtajore", "qofte me mish"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("фалафел"),
            keywords: &["леблебије", "фалафел", "ћуфте"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("falafel"),
            keywords: &["falafel", "leblebije", "ćufte"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("falafel"),
            keywords: &["falafel", "kikärter", "köttbulle"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("felafeli"),
            keywords: &["felafeli", "kababu", "njegere kubwa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வறுத\u{bcd}த கொண\u{bcd}டைக\u{bcd}கடலை உருண\u{bcd}டை"),
            keywords: &[
                "கறி உருண\u{bcd}டை",
                "கொண\u{bcd}டைக\u{bcd}கடலை",
                "வறுத\u{bcd}த கொண\u{bcd}டைக\u{bcd}கடலை உருண\u{bcd}டை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఫల\u{c3e}ఫ\u{c46}ల\u{c4d}"),
            keywords: &[
                "చ\u{c3f}క\u{c4d}\u{200c}ప\u{c40}",
                "ఫల\u{c3e}ఫ\u{c46}ల\u{c4d}",
                "మ\u{c40}ట\u{c4d}\u{200c}బ\u{c3e}ల\u{c4d}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ฟาลาเฟล"),
            keywords: &[
                "ถ\u{e31}\u{e48}วล\u{e39}กไก\u{e48}",
                "ฟาลาเฟล",
                "ม\u{e35}ตบอล",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("falafel"),
            keywords: &["falafel", "frikadelka", "nohut"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("falafeli"),
            keywords: &["falafeli"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("falafel"),
            keywords: &["falafel", "köfte", "nohut"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("фалафель"),
            keywords: &["кулька з нуту", "нут", "фалафель"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("فلافل"),
            keywords: &["فلافل", "چنا", "کوفتہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("falafel"),
            keywords: &["falafel", "noʻxat", "qiyma", "yumaloq qiyma"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bánh rán nhân gà"),
            keywords: &["bánh rán nhân gà", "thịt viên", "đậu gà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("中東蔬菜球"),
            keywords: &["中東蔬菜球", "肉丸", "鷹嘴豆"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("中东蔬菜球"),
            keywords: &["中东蔬菜球", "肉丸", "鹰嘴豆"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("炸豆丸子"),
            keywords: &["中东蔬菜球", "油炸鹰嘴豆饼", "炸豆丸子", "肉丸", "鹰嘴豆"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("油炸鷹嘴豆餅"),
            keywords: &["油炸鷹嘴豆餅", "肉丸", "鷹嘴豆"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("炸豆餅"),
            keywords: &["炸豆餅", "肉丸", "鷹嘴豆"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-falafel"),
            keywords: &["i-chickpea", "i-falafel", "i-meatball"],
        },
    ],
};
#[doc = "🥚"]
pub const EGG: crate::Emoji = crate::Emoji {
    glyph: "🥚",
    codepoint: "1F95A",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "egg",
    group: "Food & Drink",
    subgroup: "food-prepared",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("eier"),
            keywords: &["eier", "kos"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("እንቁላል"),
            keywords: &["ምግብ", "እንቁላል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بيض"),
            keywords: &["بيض", "طعام"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কণী"),
            keywords: &["কণী", "খ\u{9be}দ\u{9cd}য"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yumurta"),
            keywords: &["yemək", "yumurta"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("яйка"),
            keywords: &["ежа", "яйка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("яйце"),
            keywords: &["храна", "яйце"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ডিম"),
            keywords: &["খ\u{9be}ব\u{9be}র", "ডিম"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("vi"),
            keywords: &["boued", "dijuniñ", "vi"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("jaje"),
            keywords: &["doručak", "hrana", "jaje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("ou"),
            keywords: &["menjar", "ou"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄝\u{1112e}𑄘"),
            keywords: &["𑄝\u{1112e}𑄘"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏪᏥ"),
            keywords: &["ᎠᎵᏍᏓᏴᏗ", "ᎤᏪᏥ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("vejce"),
            keywords: &["jídlo", "vejce"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wy"),
            keywords: &["brecwast", "bwyd", "wy"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("æg"),
            keywords: &["mad", "æg"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Ei"),
            keywords: &["Ei", "Frühstück", "Frühstücksei"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αυγό"),
            keywords: &["αυγό", "τροφή"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("egg"),
            keywords: &["breakfast", "egg", "food"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("huevo"),
            keywords: &["comida", "huevo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("muna"),
            keywords: &["muna", "toit"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("arrautza"),
            keywords: &["arrautza", "janari"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تخم مرغ"),
            keywords: &["آبپز", "تخم مرغ", "غذا"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kananmuna"),
            keywords: &["kananmuna", "ruoka"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("itlog"),
            keywords: &["itlog", "pagkain"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("egg"),
            keywords: &["egg", "matur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("œuf"),
            keywords: &["œuf"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["aliment", "nourriture", "œuf"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ubh"),
            keywords: &["bia", "ubh"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ugh"),
            keywords: &["biadh", "ugh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("ovo"),
            keywords: &["comida", "ovo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઈ\u{a82}ડ\u{ac1}"),
            keywords: &["ઈ\u{a82}ડ\u{ac1}", "ભોજન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ƙwai"),
            keywords: &["abinci", "ƙwai"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ביצה"),
            keywords: &["אוכל", "ביצה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("अ\u{902}डा"),
            keywords: &["अ\u{902}डा", "भोजन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("jaje"),
            keywords: &["doručak", "hrana", "jaje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("tojás"),
            keywords: &["tojás", "étel"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ձու"),
            keywords: &["ձու", "ուտելիք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("telur"),
            keywords: &["makanan", "telur"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("àkwa"),
            keywords: &["nri", "àkwa"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("egg"),
            keywords: &["egg", "matur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("uovo"),
            keywords: &["cibo", "uovo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("卵"),
            keywords: &["卵"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ndhog"),
            keywords: &["dhaharan", "ndhog"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კვერცხი"),
            keywords: &["კვერცხი", "საკვები"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жұмыртқа"),
            keywords: &["жұмыртқа", "тағам"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("æg"),
            keywords: &["mad", "æg"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17ca}\u{17bb}ត ឬពង"),
            keywords: &[
                "ស\u{17ca}\u{17bb}ត",
                "ស\u{17ca}\u{17bb}ត ឬពង",
                "អាហារ",
                "អាហារពេលព\u{17d2}រ\u{17b9}ក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮೊಟ\u{ccd}ಟ\u{cc6}"),
            keywords: &["ಆಹಾರ", "ಮೊಟ\u{ccd}ಟ\u{cc6}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("달걀"),
            keywords: &["계란", "달걀", "식품"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ताती\u{902}"),
            keywords: &["अन\u{94d}न", "ताती\u{902}"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жумуртка"),
            keywords: &["жумуртка", "тамак"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Ee"),
            keywords: &["Ee", "Iessen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໄຂ\u{ec8}"),
            keywords: &["ອາຫານ", "ໄຂ\u{ec8}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kiaušinis"),
            keywords: &["kiaušinis", "maistas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ola"),
            keywords: &["ola", "ēdiens"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("hēki"),
            keywords: &["hēki", "kai"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("јајце"),
            keywords: &["храна", "јајце"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മ\u{d41}ട\u{d4d}ട"),
            keywords: &["ഭക\u{d4d}ഷണം", "മ\u{d41}ട\u{d4d}ട"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("өндөг"),
            keywords: &["хоол", "хүнс", "өндөг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("अ\u{902}ड\u{947}"),
            keywords: &["अ\u{902}ड\u{947}", "खाद\u{94d}य"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("telur"),
            keywords: &["makanan", "telur"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("bajda"),
            keywords: &["bajda", "ikel"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဥ"),
            keywords: &["အစားအသောက\u{103a}", "ဥ"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("egg"),
            keywords: &["egg", "mat"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("अण\u{94d}डा"),
            keywords: &["अण\u{94d}डा", "खाना"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("ei"),
            keywords: &["ei", "voedsel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("egg"),
            keywords: &["egg", "mat"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଅଣ\u{b4d}ଡ\u{b3e}"),
            keywords: &["ଅଣ\u{b4d}ଡ\u{b3e}", "ଅଣ\u{b4d}ଡ\u{b3e} । ଖ\u{b3e}ଦ\u{b4d}ୟ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਆ\u{a02}ਡਾ"),
            keywords: &["ਅ\u{a70}ਡਾ", "ਆ\u{a02}ਡਾ", "ਭ\u{a4b}ਜਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("انڈہ"),
            keywords: &["انڈہ", "خوراک"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ẹg"),
            keywords: &["Brẹ\u{301}kfast", "Fud", "Ẹg"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("jajko"),
            keywords: &["jajko", "jajo", "jedzenie"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("هګۍ"),
            keywords: &["هګۍ", "هګۍ، خواړه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("ovo"),
            keywords: &["comida", "ovo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("runtu"),
            keywords: &["mikhuna", "paqarin mikhuna", "runtu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ou"),
            keywords: &["mâncare", "ou"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1078"),
            keywords: &["E10-1078"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("яйцо"),
            keywords: &["еда", "яйцо"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igi"),
            keywords: &["ibiribwa", "igi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بيضو"),
            keywords: &["بيضو", "بيضو، کاڌو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බ\u{dd2}ත\u{dca}තර"),
            keywords: &["කෑම", "බ\u{dd2}ත\u{dca}තර"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("vajce"),
            keywords: &["jedlo", "vajce"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("jajce"),
            keywords: &["hrana", "jajca", "jajce"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("ukun"),
            keywords: &["cunto", "ukun"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("vezë"),
            keywords: &["ushqim", "vezë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("јаје"),
            keywords: &["храна", "јаје"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("jaje"),
            keywords: &["hrana", "jaje"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ägg"),
            keywords: &["mat", "ägg"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("yai"),
            keywords: &["chakula", "yai"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("முட\u{bcd}டை"),
            keywords: &["உணவு", "முட\u{bcd}டை"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("గ\u{c4d}రుడ\u{c4d}డు"),
            keywords: &["ఆహ\u{c3e}రం", "గ\u{c4d}రుడ\u{c4d}డు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тухм"),
            keywords: &["тухм", "ғизо"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ไข\u{e48}"),
            keywords: &["ศ\u{e39}นย\u{e4c}", "อาหาร", "ไข\u{e48}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýumurtga"),
            keywords: &["ertirlik", "iýmit", "ýumurtga"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fuaʻimoa"),
            keywords: &["fuaʻimoa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yumurta"),
            keywords: &["yiyecek", "yumurta"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تۇخۇم"),
            keywords: &["تۇخۇم", "يېمەكلىك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("яйце"),
            keywords: &["яйце", "їжа"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("انڈا"),
            keywords: &["انڈا", "خوراک"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tuxum"),
            keywords: &["taom", "tuxum"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trứng"),
            keywords: &["thức ăn", "trứng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("nen"),
            keywords: &["lekk", "nen"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqanda"),
            keywords: &["iqanda", "ukutya"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹyin"),
            keywords: &["ónjẹ", "Ẹyin", "ẹyin"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("蛋"),
            keywords: &["蛋", "食物"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("蛋"),
            keywords: &["蛋", "食物"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("蛋"),
            keywords: &["蛋", "食物"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("蛋"),
            keywords: &["蛋", "雞蛋"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["蛋", "食物"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iqanda"),
            keywords: &["iqanda", "ukudla"],
        },
    ],
};
#[doc = "🍳"]
pub const COOKING: crate::Emoji = crate::Emoji {
    glyph: "🍳",
    codepoint: "1F373",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "cooking",
    group: "Food & Drink",
    subgroup: "food-prepared",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gebakte eier in pan"),
            keywords: &["bak", "eier", "gebakte eier in pan", "kook", "pan"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ምግብ ማብሰል"),
            keywords: &["መጥበሻ", "ማብሰል", "ምግብ ማብሰል", "እንቁላል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مقلاة"),
            keywords: &["طهي", "قلاية", "مطعم", "مقلاة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ৰন\u{9cd}ধন"),
            keywords: &["কণী", "পেন", "ফ\u{9cd}ৰ\u{9be}ই কৰ\u{9be}", "ৰন\u{9cd}ধন"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("bişirmək"),
            keywords: &["bişirmək", "qızartmaq", "tava", "yumurta"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("гатаванне"),
            keywords: &["гатаванне", "патэльня", "скаварада", "смажанне", "яйка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("готвене"),
            keywords: &["готвене", "пържене", "тиган", "яйце"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("র\u{9be}ন\u{9cd}ন\u{9be} কর\u{9be}"),
            keywords: &[
                "চ\u{9be}ট\u{9c1}",
                "ডিম",
                "ভ\u{9be}জ\u{9be}",
                "র\u{9be}ন\u{9cd}ন\u{9be} কর\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("vi war ar plad"),
            keywords: &["dijuniñ", "paelon", "plad", "vi", "vi war ar plad"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kuhanje"),
            keywords: &["doručak", "jaje", "kuhanje", "pečenje", "tava"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("ou ferrat"),
            keywords: &["cuina", "ou", "ou ferrat"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄢𑄚𑄚"),
            keywords: &["𑄢𑄚𑄚"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏓᏍᏓᏴᎲᏍᎩ"),
            keywords: &["ᎠᏓᏍᏓᏴᎲᏍᎩ", "ᎠᏓᏍᏙᏗ", "ᎤᏪᏥ", "ᎬᏣᏢᏍᎦ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("vejce na pánvi"),
            keywords: &["pánev", "smažení", "vaření", "vejce", "vejce na pánvi"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("coginio"),
            keywords: &["coginio", "ffrio", "padell", "wy"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("stegepande"),
            keywords: &["madlavning", "spejlæg", "stegepande", "stegepande med æg"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Spiegelei in Bratpfanne"),
            keywords: &["Kochen", "Pfanne", "Spiegelei in Bratpfanne"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μαγείρεμα"),
            keywords: &["αυγό", "μαγείρεμα", "τηγάνι", "τηγανίζω"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("cooking"),
            keywords: &["breakfast", "cooking", "egg", "frying", "pan"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cocinar"),
            keywords: &["cocinar", "freír", "huevo", "sartén"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("sartén"),
            keywords: &["cocina", "huevo", "restaurante", "sartén"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["cocina", "huevo", "sartén"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cocinando"),
            keywords: &["cocinando", "desayuno", "freír", "huevo", "sartén"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("toiduvalmistamine"),
            keywords: &["muna", "pann", "praadimine", "toiduvalmistamine"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("janaria prestatu"),
            keywords: &["arrautz", "frijitu", "janaria prestatu", "zartagin"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("آشپزی"),
            keywords: &["آشپزی", "تابه", "تخم\u{200c}مرغ", "سرخ کردن", "نیمرو"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kokkaus"),
            keywords: &["kokkaus", "paistinpannu", "ruoka"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nagluluto"),
            keywords: &["itlog", "kawali", "nagluluto", "pagkain", "prito"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("matgerð"),
            keywords: &["egg", "matgerð", "matur", "panna", "steikipanna", "steikja"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("œuf au plat"),
            keywords: &["friture", "poêle", "œuf", "œuf au plat"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("cuisine"),
            keywords: &["cuisine", "friture", "poêle", "œuf"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cócaireacht"),
            keywords: &["cócaireacht", "friochadh", "friochtán"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("còcaireachd"),
            keywords: &["adhann", "còcaireachd", "praidhigeadh", "ugh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("tixola"),
            keywords: &["ovo", "ovo frito", "tixola"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("રા\u{a82}ધવ\u{ac1}\u{a82}"),
            keywords: &[
                "કડાઈ",
                "રા\u{a82}ધવ\u{ac1}\u{a82}",
                "ર\u{ac7}સ\u{acd}ટોરન\u{acd}ટ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("girkawa"),
            keywords: &["girkawa", "kwanon tuya", "soyawa", "ƙwai"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("בישול"),
            keywords: &["אוכל", "בישול", "מזון"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("भोजन पकाना"),
            keywords: &[
                "फ\u{93c}\u{94d}राइ\u{902}ग प\u{948}न",
                "भोजन पकाना",
                "र\u{947}स\u{94d}टोर\u{947}\u{902}ट",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kuhanje"),
            keywords: &["jaje", "kuhanje", "pečenje", "tava"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("sütés-főzés"),
            keywords: &["serpenyő", "sütés-főzés", "tojás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("թավայով ձվածեղ"),
            keywords: &["թավա", "թավայով ձվածեղ", "ձու", "տապակել"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("memasak"),
            keywords: &["memasak", "menggoreng", "telur", "wajan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("na-esi nri"),
            keywords: &["ite oghighe", "na-eghe ihe", "na-esi nri", "àkwa"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("steikarpanna"),
            keywords: &["elda", "steikarpanna", "steiking", "veitingastaður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cucinare"),
            keywords: &["cucinare", "ristorante"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("料理"),
            keywords: &["フライパン", "卵", "料理", "目玉焼き"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("masak"),
            keywords: &["masak", "ndhog", "nggoreng", "wajan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("საჭმლის მომზადება"),
            keywords: &["კვერცხი", "საჭმლის მომზადება", "ტაფა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("пісіру"),
            keywords: &["жұмыртқа", "пісіру", "таба", "қуыру"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("stegepande"),
            keywords: &["madlavning", "stegepande", "stegepande med æg"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ក\u{17c6}ព\u{17bb}ងច\u{17c6}អ\u{17b7}នម\u{17d2}ហ\u{17bc}ប"),
            keywords: &[
                "ក\u{17c6}ព\u{17bb}ងច\u{17c6}អ\u{17b7}នម\u{17d2}ហ\u{17bc}ប",
                "ខ\u{17d2}ទះ",
                "ចម\u{17d2}អ\u{17b7}ន",
                "ចៀន",
                "ស\u{17ca}\u{17bb}ត",
                "អាហារពេលព\u{17d2}រ\u{17b9}ក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಅಡುಗ\u{cc6}"),
            keywords: &["ಅಡುಗ\u{cc6}", "ಹುರ\u{cbf}ಯುವ ಪ\u{ccd}ಯಾನ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("프라이팬"),
            keywords: &["계란 프라이", "요리", "프라이팬"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("रा\u{902}दता"),
            keywords: &["तळता", "ताती\u{902}", "प\u{945}न", "रा\u{902}दता"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бышыруу"),
            keywords: &["бышыруу", "жумуртка", "кууруу", "таба"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Pan mat Spigelee"),
            keywords: &["Ee", "Pan", "Pan mat Spigelee", "broden"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແຕ\u{ec8}ງອາຫານ"),
            keywords: &["ແຕ\u{ec8}ງອາຫານ", "ໄຂ\u{ec8}", "ໝ\u{ecd}\u{ec9}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("valgio gaminimas"),
            keywords: &["kepimas", "keptuvė", "kiaušinis", "valgio gaminimas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ēdiena gatavošana"),
            keywords: &["cept", "ola", "panna", "ēdiena gatavošana"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tao ana"),
            keywords: &["hēki", "parai", "pēne", "tao ana"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("готвење"),
            keywords: &["готвење", "пржење", "тавче", "јајце"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d3e}ചകം"),
            keywords: &[
                "ഓംലെറ\u{d4d}റ\u{d4d}",
                "ക\u{d41}ക\u{d4d}കിംഗ\u{d4d}",
                "കോഴിമ\u{d41}ട\u{d4d}ട",
                "പ\u{d3e}ചകം",
                "ഫ\u{d4d}രയിംഗ\u{d4d} പ\u{d3e}ൻ",
                "ഭക\u{d4d}ഷണം",
                "ഹോട\u{d4d}ടൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("өндөг шарах"),
            keywords: &[
                "хайруулын таваг",
                "хоол хийх",
                "шарах",
                "өглөөний цай",
                "өндөг",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("अन\u{94d}न शिजविण\u{947}"),
            keywords: &[
                "अ\u{902}ड\u{947}",
                "अन\u{94d}न शिजवण\u{947}",
                "अन\u{94d}न शिजविण\u{947}",
                "कढई",
                "तळण\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("memasak"),
            keywords: &["kuali", "memasak", "menggoreng", "telur"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("tisjir"),
            keywords: &["bajda", "borma", "qali", "tisjir"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ချက\u{103a}ပြ\u{102f}တ\u{103a}ခြင\u{103a}း"),
            keywords: &[
                "ကြော\u{103a}လ\u{103e}ော\u{103a}ခြင\u{103a}း",
                "ချက\u{103a}ပြ\u{102f}တ\u{103a}ခြင\u{103a}း",
                "ဒယ\u{103a}အ\u{102d}\u{102f}း",
                "ဥ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("matlaging"),
            keywords: &["egg", "matlaging", "steke", "stekepanne"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("खाना बनाउ\u{901}द\u{948}"),
            keywords: &[
                "अण\u{94d}डा",
                "खाना बनाउ\u{901}द\u{948}",
                "प\u{94d}यान",
                "फ\u{94d}राई गर\u{94d}न\u{947}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("koken"),
            keywords: &["bakken", "ei", "koekenpan", "koken", "ontbijt"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("matlaging"),
            keywords: &["egg", "matlaging", "steike", "steikepanne"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ରୋଷେଇ"),
            keywords: &[
                "ଅଣ\u{b4d}ଡ\u{b3e}",
                "ପ\u{b4d}ୟ\u{b3e}ନ\u{b4d}",
                "ଭ\u{b3e}ଜ\u{b3f}ବ\u{b3e}",
                "ରୋଷେଇ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਰਸ\u{a4b}ਈ-ਕਲਾ"),
            keywords: &["ਖਾਣਾ ਪਕਾਉਣਾ", "ਤਲਣ ਲਈ ਬਰਤਨ", "ਰਸ\u{a4b}ਈ-ਕਲਾ", "ਹ\u{a4b}ਟਲ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کھانا-پکانا"),
            keywords: &["انڈہ", "تلنا", "توا", "کھانا-پکانا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kúk"),
            keywords: &[
                "Brẹ\u{301}kfast",
                "Frayín Pan",
                "Kúk",
                "Mọ\u{301}nín Chọp",
                "Pan",
                "To Fraí Sọ\u{301}mtin",
                "To Kúk Fud",
                "Ẹg",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("gotowanie"),
            keywords: &["gotowanie", "jajko", "smażyć"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پخلي"),
            keywords: &["پخلي", "پخلي، هګۍ، وريتول، پان"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("ovo frito"),
            keywords: &["frigideira", "ovo", "ovo estrelado", "ovo frito"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cozinhar"),
            keywords: &["cozinhar", "frigideira", "ovo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("waykʼuchkan"),
            keywords: &[
                "paqarin mikhuna",
                "runtu",
                "sarten",
                "thiqtiy",
                "waykʼuchkan",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("gătit"),
            keywords: &["gătit", "tigaie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-312"),
            keywords: &["E10-312"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("яичница на сковороде"),
            keywords: &[
                "глазунья",
                "желток",
                "сковорода",
                "яичница",
                "яичница на сковороде",
                "яйцо",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("guteka"),
            keywords: &["gukaranga", "guteka", "igi", "ipanu"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("کاڌو پچائڻ"),
            keywords: &["بيضو، ترڻ، پان", "کاڌو پچائڻ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd2}ස\u{dd3}ම"),
            keywords: &[
                "ත\u{dcf}ච\u{dca}ච\u{dd2}ය",
                "ප\u{dd2}ස\u{dd3}ම",
                "බද\u{dd2}න",
                "බ\u{dd2}ත\u{dca}තරය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("varenie"),
            keywords: &["panvica", "vajce", "varenie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kuhanje"),
            keywords: &["cvrtje", "jajce", "kuhanje", "ponev"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("karinta"),
            keywords: &["bir daawo", "karinta", "shiilidda", "ukun"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gatim"),
            keywords: &["gatim", "skuqje", "tigan", "vezë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("јаје у тигању"),
            keywords: &["jaje", "пeчeњe", "тигањ", "јаје у тигању"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("jaje u tiganju"),
            keywords: &["jaje", "jaje u tiganju", "pečenje", "tiganj"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("matlagning"),
            keywords: &["laga mat", "matlagning"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kupika"),
            keywords: &["kukaang’a", "kupika", "sufuria", "yai"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சமையல\u{bcd}"),
            keywords: &[
                "உணவு",
                "க\u{bbe}ஃப\u{bcd} ப\u{bbe}யில\u{bcd}",
                "க\u{bbe}ஃப\u{bcd} ப\u{bbe}யில\u{bcd} முட\u{bcd}டை",
                "சமையல\u{bcd}",
                "முட\u{bcd}டை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వంట"),
            keywords: &[
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
                "వంట",
                "వండటం",
                "వ\u{c47}పుళ\u{c4d}ల మూకుడు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("пухта истодааст"),
            keywords: &["бирён шудаистода", "дег", "пухта истодааст", "тухм"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ทำอาหาร"),
            keywords: &["กระทะ", "ทำอาหาร", "ไข\u{e48}ดาว"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kulinariýa"),
            keywords: &[
                "bişirmek",
                "ertirlik",
                "gowurmak",
                "kulinariýa",
                "skoworodka",
                "ýumurtga",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakapaku"),
            keywords: &["fakapaku"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yemek pişirme"),
            keywords: &["pişirme", "restoran", "yemek pişirme"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("پىشۇرۇش"),
            keywords: &["تۇخۇم", "ساپلىق", "قورۇش", "پىشۇرۇش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("готування їжі"),
            keywords: &["готування їжі", "пательня", "яйце"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پکتا ہوا انڈہ"),
            keywords: &["انڈا", "پکتا ہوا انڈہ", "پین"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("taom tayyorlash"),
            keywords: &["qovurish", "taom tayyorlash", "tova", "tuxum"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nấu ăn"),
            keywords: &["chiên", "cái chảo", "nấu ăn", "trứng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("togg"),
            keywords: &["nen", "pane", "saaf", "togg"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ukupheka"),
            keywords: &["ipani", "iqanda", "ukupheka", "ukuqhotsa"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Dídáná"),
            keywords: &["Dídáná", "dídín", "páànù", "ẹyin"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("煮食"),
            keywords: &["平底鑊", "煎", "煮食", "蛋"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("煮食"),
            keywords: &["平底镬", "煎", "煮食", "蛋"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("煎蛋"),
            keywords: &["平底锅", "煎", "煎蛋", "蛋"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("煎蛋"),
            keywords: &["煎蛋", "荷包蛋"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("煮飯"),
            keywords: &["平底鑊", "煎蛋", "煮飯", "荷包蛋", "鑊", "雞蛋"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukupheka"),
            keywords: &["ipani", "iqanda", "ukupheka", "ukuthosa"],
        },
    ],
};
#[doc = "🥘"]
pub const SHALLOW_PAN_OF_FOOD: crate::Emoji = crate::Emoji {
    glyph: "🥘",
    codepoint: "1F958",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "shallow pan of food",
    group: "Food & Drink",
    subgroup: "food-prepared",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vlak pan met kos"),
            keywords: &["kos", "paella", "pan", "vlak", "vlak pan met kos"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጎድጓዳ ሳህን ለምግብ"),
            keywords: &["ምግብ", "ሳህን", "የምግብ ማቅረቢያ", "ጎድጓዳ", "ጎድጓዳ ሳህን ለምግብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مقلاة مسطحة بها طعام"),
            keywords: &["طعام", "مسطحة", "مقلاة", "مقلاة مسطحة بها طعام"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কেৰ\u{9be}হী"),
            keywords: &[
                "কেছৰোল",
                "কেৰ\u{9be}হী",
                "খ\u{9be}দ\u{9cd}য",
                "প\u{9be}ত\u{9cd}ৰ",
                "পেল\u{9cd}ল\u{9be}",
                "শ\u{9cd}বেল\u{9cd}লো",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("dayaz qazan"),
            keywords: &["dayaz", "qazan", "qida", "yemək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("рагу ў патэльні"),
            keywords: &["ежа", "патэльня", "паэлья", "рагу", "рагу ў патэльні"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("тава с храна"),
            keywords: &[
                "касерол",
                "паеля",
                "плитка",
                "плитка тава с храна",
                "тава",
                "тава с храна",
                "храна",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("কড\u{9bc}\u{9be}ই"),
            keywords: &[
                "কড\u{9bc}\u{9be}",
                "কড\u{9bc}\u{9be}ই",
                "ক\u{9cd}য\u{9be}সরোল",
                "খ\u{9be}ব\u{9be}র",
                "পেন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("meuz mitonet"),
            keywords: &["boued", "kastelodenn", "meuz mitonet", "paelon"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("tava s hranom"),
            keywords: &["hrana", "plitko", "tava", "tava s hranom", "tepsija"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("paella"),
            keywords: &["arròs", "menjar", "paella", "valenciana"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏅᏬᏚ ᎤᏩᏖᏌᏓ Ꮎ ᎠᎵᏍᏓᏴᏗ"),
            keywords: &[
                "ᎠᎩᏍᏗ",
                "ᎤᏩᏖᏌᏓᎾ",
                "ᎧᏌᎶᎵ",
                "ᏅᏬᏗ",
                "ᏅᏬᏚ ᎤᏩᏖᏌᏓ Ꮎ ᎠᎵᏍᏓᏴᏗ",
                "ᏅᏬᏚ ᎤᏩᏖᏌᏓᎾ ᎠᎵᏍᏓᏴᏗ",
                "ᏆᏰᏯ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mělký rendlík s jídlem"),
            keywords: &[
                "jídlo",
                "kastrol",
                "mělký",
                "mělký rendlík s jídlem",
                "paella",
                "pánev",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("padell fas o fwyd"),
            keywords: &[
                "bas",
                "bwyd",
                "casserol",
                "padell",
                "padell fas o fwyd",
                "paella",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("pande med mad"),
            keywords: &[
                "mad",
                "paella",
                "pande",
                "pande med mad",
                "pandestegt",
                "steger",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Pfannengericht"),
            keywords: &["Essen", "Paella", "Pfannengericht", "Reispfanne"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τηγάνι"),
            keywords: &["παέγια", "ρηχός", "τηγάνι", "τροφή", "ψητό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("shallow pan of food"),
            keywords: &[
                "casserole",
                "food",
                "paella",
                "pan",
                "shallow",
                "shallow pan of food",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("paella"),
            keywords: &["arroz", "comida", "paella"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["comida", "paella", "sartén"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("sartén hondo con comida"),
            keywords: &[
                "casserole",
                "comida",
                "hondo",
                "paella",
                "sartén",
                "sartén hondo con comida",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("panniroog"),
            keywords: &["paella", "panniroog", "toit"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("sakonera txikiko zartagina"),
            keywords: &[
                "janari",
                "kazola",
                "paella-ontzi",
                "sakonera txikiko zartagin",
                "sakonera txikiko zartagina",
                "zartagin",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ماهیتابه غذا"),
            keywords: &["دیگ", "غذا", "ماهی\u{200c}تابه", "پلو اسپانیایی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("paellapannu"),
            keywords: &["paella", "paellapannu", "pata", "pataruoka", "ruoka"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("shallow pan ng pagkain"),
            keywords: &[
                "casserole",
                "paella",
                "pagkain",
                "pagkain sa kaserola",
                "shallow pan ng pagkain",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("grýturættur"),
            keywords: &["fat", "grýta", "grýturættur", "matur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("plat mitonné"),
            keywords: &["casserole", "paella", "plat", "plat mitonné", "poêle"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "casserole",
                "nourriture",
                "paella",
                "plat mitonné",
                "poêle",
                "repas",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("panna tanaí le bia"),
            keywords: &[
                "bia",
                "friochtán",
                "paella",
                "panna tanaí le bia",
                "pota",
                "stiobhach",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("adhann le biadh"),
            keywords: &[
                "adhann",
                "adhann le biadh",
                "biadh",
                "casaroil",
                "eu-domhain",
                "paella",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("paella"),
            keywords: &["arroz", "comida", "paella", "paelleira"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("છીછરો તવો"),
            keywords: &["ક\u{ac5}સરોલ", "છીછરો", "તવો", "ભોજન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kwanon mara zurfi na abinci"),
            keywords: &[
                "abinci",
                "kwanon mara zurfi na abinci",
                "kwanon tuya",
                "mara zurfi",
                "miyan casserole",
                "paella",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("תבשיל קדרה"),
            keywords: &["קאסרול", "קדרה", "תבשיל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("हल\u{94d}का तला खाना"),
            keywords: &[
                "खाना",
                "पाएला",
                "प\u{941}लाव",
                "प\u{948}न",
                "हल\u{94d}का",
                "हल\u{94d}का तला खाना",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("posuda s hranom"),
            keywords: &[
                "hrana",
                "lonac",
                "paella",
                "plitko",
                "posuda",
                "posuda s hranom",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("serpenyős étel"),
            keywords: &["serpenyő", "serpenyős étel", "étel"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տապակա"),
            keywords: &["թավա", "ուտելիք", "տապակա", "տապակած", "տափակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajan dangkal"),
            keywords: &["kaserol", "makanan", "seafood", "wajan", "wajan dangkal"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("efere nri dabara n’ime"),
            keywords: &[
                "anụ",
                "efere",
                "efere nri dabara n’ime",
                "nri ayịya",
                "nọ",
                "n’ime",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("pönnuréttur"),
            keywords: &["matur", "panna", "pönnuréttur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("padella con cibo"),
            keywords: &[
                "casseruola",
                "cibo",
                "padella",
                "padella con cibo",
                "paella",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("パエリア"),
            keywords: &["シーフード", "パエリア"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("jangan sawajan cethek"),
            keywords: &[
                "dhaharan",
                "jangan sawajan cethek",
                "kaserol",
                "paela",
                "wajan",
                "wajan cethek",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ტაფამწვარი"),
            keywords: &[
                "თხელი",
                "კასეროლი",
                "პაელა",
                "საკვები",
                "ტაფა",
                "ტაფამწვარი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("табадағы рагу"),
            keywords: &["рагу", "таба", "табадағы рагу"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("pande med mad"),
            keywords: &["mad", "pande", "pande med mad", "pandestegt", "steger"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ខ\u{17d2}ទះឆារាក\u{17cb}"),
            keywords: &[
                "ខ\u{17d2}ទះ",
                "ខ\u{17d2}ទះឆារាក\u{17cb}",
                "ចានគោម",
                "ចានបាយធ\u{17c6}",
                "រាក\u{17cb}",
                "អាហារ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಶಾಲೋ ಪಾನ\u{ccd} ಆಹಾರ"),
            keywords: &[
                "ಆಹಾರ",
                "ಕ\u{ccd}ಯಾಸ\u{ccd}\u{200c}ರೋಲ\u{ccd}",
                "ಪಾನ\u{ccd}",
                "ಪಾಯ\u{cc6}ಲ\u{ccd}ಲಾ",
                "ಶಾಲೋ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("납작한 냄비"),
            keywords: &["납작한 냄비", "빠에야", "음식", "찌개", "캐서롤"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("अन\u{94d}नाचो श\u{945}लो प\u{945}न"),
            keywords: &[
                "अन\u{94d}न",
                "अन\u{94d}नाच\u{947}\u{902} श\u{945}लो प\u{945}न",
                "अन\u{94d}नाचो श\u{945}लो प\u{945}न",
                "क\u{945}सरोल",
                "पायला",
                "प\u{945}न",
                "श\u{945}लो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("көмөч казандагы рагу"),
            keywords: &[
                "көмөч казан",
                "көмөч казандагы рагу",
                "паэлья",
                "рагу",
                "тамак",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Kasseroll mat Iessen"),
            keywords: &[
                "Iessen",
                "Kasseroll",
                "Kasseroll mat Iessen",
                "Paella",
                "Pan",
                "flaach",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຈານອາຫານບາງໆ"),
            keywords: &[
                "casserole",
                "paella",
                "ຈານ",
                "ຈານອາຫານບາງໆ",
                "ບາງໆ",
                "ອາຫານ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("prikaistuvis su maistu"),
            keywords: &["maistas", "prikaistuvis", "prikaistuvis su maistu"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sautējums pannā"),
            keywords: &["paelja", "panna", "sautējums", "sautējums pannā", "ēdiens"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pēne kai pāpaku"),
            keywords: &["kaherora", "kai", "paera", "pāpaku", "pēne"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("тавче со храна"),
            keywords: &["плитка", "тава", "тавче со храна", "тепсија"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പരന\u{d4d}ന പ\u{d3e}ത\u{d4d}രത\u{d4d}തിലെ ഭക\u{d4d}ഷണം"),
            keywords: &[
                "ക\u{d3e}സറോൾ",
                "പരന\u{d4d}ന പ\u{d3e}ത\u{d4d}രത\u{d4d}തിലെ ഭക\u{d4d}ഷണം",
                "പരന\u{d4d}നപ\u{d3e}ത\u{d4d}രം",
                "പ\u{d3e}ൻ",
                "ഭക\u{d4d}ഷണം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("тогоотой хоол"),
            keywords: &["тогоо", "тогоотой хоол", "хайруулын таваг", "хоол"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("अन\u{94d}नाच\u{947} उथळ भा\u{902}ड\u{947}"),
            keywords: &[
                "अन\u{94d}नाच\u{947} उथळ भा\u{902}ड\u{947}",
                "उथळ",
                "क\u{947}स\u{947}रोल",
                "खाद\u{94d}य",
                "प\u{945}न",
                "भा\u{902}ड\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("makanan dalam belanga"),
            keywords: &["belanga", "makanan", "makanan dalam belanga", "periuk"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("taġen baxx tal-Ikel"),
            keywords: &[
                "baxx",
                "ikel",
                "paella",
                "pagna",
                "taġen",
                "taġen baxx tal-Ikel",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဒယ\u{103a}အ\u{102d}\u{102f}းပါးန\u{103e}င\u{1037}\u{103a}စားစရာ"),
            keywords: &[
                "ဒယ\u{103a}အ\u{102d}\u{102f}းပါး",
                "ဒယ\u{103a}အ\u{102d}\u{102f}းပါးန\u{103e}င\u{1037}\u{103a}စားစရာ",
                "ပ\u{102e}ယာလာ",
                "အစားအသောက\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("lav gryte med mat"),
            keywords: &["lav gryte med mat", "mat", "paella", "stekepanne"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("होचो कराईको खाना"),
            keywords: &[
                "कराई",
                "कास\u{94d}स\u{947}रोल",
                "खाना",
                "पायला",
                "होचो",
                "होचो कराईको खाना",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("paellapan"),
            keywords: &["casserole", "paella", "paellapan", "pan", "voedsel", "wok"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("låg gryte med mat"),
            keywords: &["låg gryte med mat", "mat", "paella", "steikepanne"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଅଗଭୀର ଖ\u{b3e}ଦ\u{b4d}ୟ ତ\u{b3e}ୱ\u{b3e}"),
            keywords: &[
                "ଅଗଭୀର ଖ\u{b3e}ଦ\u{b4d}ୟ ତ\u{b3e}ୱ\u{b3e}",
                "ପ\u{b3e}ଏଲ\u{b3e} । କ\u{b4d}ୟ\u{b3e}ସେରୋଲ\u{b4d}\u{200d} । ତ\u{b3e}ୱ\u{b3e} । ଅଗଭୀର । ଖ\u{b3e}ଦ\u{b4d}ୟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਭ\u{a4b}ਜਨ ਦਾ ਘ\u{a71}ਟ ਡ\u{a42}\u{a70}ਘਾ ਭਾ\u{a02}ਡਾ"),
            keywords: &[
                "ਕ\u{a48}ਸਰ\u{a4b}ਲ",
                "ਪ\u{a41}ਲਾਅ",
                "ਪ\u{a48}ਨ",
                "ਭ\u{a4b}ਜਨ",
                "ਭ\u{a4b}ਜਨ ਦਾ ਘ\u{a71}ਟ ਡ\u{a42}\u{a70}ਘਾ ਭਾ\u{a02}ਡਾ",
                "ਹਲਕਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("خوراک لئی گھٹ ڈونگا توا"),
            keywords: &[
                "توا",
                "خوراک",
                "خوراک لئی گھٹ ڈونگا توا",
                "ڈھکن آلی کڑھائی",
                "گھٹ ڈونگا",
                "ہسپانوی پلاؤ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pọt Wé Nọ\u{301} Dip"),
            keywords: &[
                "Frayin Pan",
                "Fud",
                "Fud Wé Dé Insaíd Frayin Pan Wé Nọ\u{301} Dé Dip",
                "Kásérol: Díp Plet Wé Dẹm De Ték Kúk Mit An Ọ\u{301}dá Fud",
                "Nọ\u{301} Dé Dip",
                "Pan",
                "Pọt Wé Nọ\u{301} Dip",
                "Spánísh Fud Wé Im Nem Na Paíẹla",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("danie z patelni"),
            keywords: &["danie z patelni", "jedzenie", "paella", "patelnia", "wok"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د خواړو سطحي هرکاره"),
            keywords: &[
                "د خواړو سطحي هرکاره",
                "کيسيرول، خواړه، پايلا، هرکاره، سطحي، د خواړو سطحي هرکاره",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("caçarola com comida"),
            keywords: &[
                "caçarola",
                "caçarola com comida",
                "comida",
                "paella",
                "panela",
                "rasa",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("caçarola de comida"),
            keywords: &[
                "caçarola",
                "caçarola de comida",
                "comida",
                "paelha",
                "panela",
                "rasa",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pisi llata mikunapaq"),
            keywords: &[
                "caserola",
                "llaplla",
                "mikhuna",
                "paella",
                "pisi llata mikunapaq",
                "sarten",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cratiță cu mâncare"),
            keywords: &[
                "cratiță",
                "cratiță cu mâncare",
                "mâncare",
                "paella",
                "tigaie",
                "tigaie cu mâncare",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1076"),
            keywords: &["E10-1076"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("рагу в сковороде"),
            keywords: &["еда", "паэлья", "рагу", "рагу в сковороде", "сковорода"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("agapanu k’ibiryo"),
            keywords: &[
                "agakarayi",
                "agapanu k’ibiryo",
                "agasahani",
                "ibiribwa",
                "ipanu",
                "isafuriya",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("توو"),
            keywords: &["توو", "پئيلا، ڪيسيرول، پان، کاڌو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("නොගැඹ\u{dd4}ර\u{dd4} තැට\u{dd2}යේ කෑම"),
            keywords: &[
                "කෑම",
                "තම\u{dca}බන තැට\u{dd2}ය",
                "තැට\u{dd2}ය",
                "නොගැඹ\u{dd4}ර\u{dd4}",
                "නොගැඹ\u{dd4}ර\u{dd4} තැට\u{dd2}යේ කෑම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("panvica s jedlom"),
            keywords: &["jedlo", "panvica", "panvica s jedlom"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kozica s hrano"),
            keywords: &["hrana", "kozica", "kozica s hrano", "paella", "ponev"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("bir daawo gun-dhow oo cunno ah"),
            keywords: &[
                "bariis isbaanish",
                "bir daawo",
                "bir daawo gun-dhow oo cunno ah",
                "cuno fuud foornaysan",
                "gun dhow",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("tigan me ushqim"),
            keywords: &["enë", "tavë gjelle", "tigan", "tigan me ushqim", "ushqim"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("тигањ хране"),
            keywords: &["паеља", "плитко", "тава", "тигањ хране", "храна"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("tiganj hrane"),
            keywords: &["hrana", "paelja", "plitko", "tava", "tiganj hrane"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("stekpanna"),
            keywords: &["mat", "paella", "stekpanna"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kikaango"),
            keywords: &["chakula", "chapati", "kikaango", "paella"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கட\u{bbe}ய\u{bcd} உணவு"),
            keywords: &["உணவு", "கட\u{bbe}ய\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఆహ\u{c3e}రంత\u{c4b} ఉన\u{c4d}న బ\u{c3e}ండ\u{c40}"),
            keywords: &[
                "ఆహ\u{c3e}రం",
                "ఆహ\u{c3e}రంత\u{c4b} ఉన\u{c4d}న బ\u{c3e}ండ\u{c40}",
                "క\u{c3e}సుర\u{c4b}ల\u{c4d}",
                "ప\u{c48}యల",
                "ప\u{c4d}య\u{c3e}న\u{c4d}",
                "ష\u{c3e}ల\u{c4b}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дегчаи хурди ғизо"),
            keywords: &[
                "дегча",
                "дегчаи хурди ғизо",
                "паеля",
                "пастоб",
                "тоба",
                "ғизо",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("กระทะ"),
            keywords: &["กระทะ", "กะทะ", "ทำอาหาร", "อาหาร"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýalpak taba"),
            keywords: &["ispan palowy", "iýmit", "kastrýul", "taba", "ýalpak"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakapaku meʻakai"),
            keywords: &["fakapaku meʻakai"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sahanda yemek"),
            keywords: &[
                "güveç",
                "küçük",
                "paella",
                "sahanda yemek",
                "tava",
                "yiyecek",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("لېگەنلىك يېمەكلىك"),
            keywords: &[
                "تېيىز",
                "تەخسە",
                "قازان",
                "لېگەن",
                "لېگەنلىك يېمەكلىك",
                "يېمەكلىك",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("каструля з їжею"),
            keywords: &["каструля", "каструля з їжею", "плов", "рагу", "їжа"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کم گہرے پین میں خوراک"),
            keywords: &["خوراک", "پین", "کم گہرا", "کم گہرے پین میں خوراک"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("bir tova qovurdoq"),
            keywords: &["bir tova qovurdoq", "jarkop", "paelya", "taom", "tova"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("chảo thức ăn nông"),
            keywords: &[
                "chảo",
                "chảo thức ăn nông",
                "nông",
                "nồi đất",
                "paella",
                "thức ăn",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("boolu togg bu xóotul"),
            keywords: &[
                "boolu togg bu xóotul",
                "bu xóotul",
                "kaserol",
                "lekk",
                "pane",
                "paylaa",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ipani elinganzulwanga lokutya"),
            keywords: &[
                "enganzulwanga",
                "i-casserole",
                "i-paella",
                "ipani",
                "ipani elinganzulwanga lokutya",
                "ukutya",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Paanu Ijẹun kekere"),
            keywords: &[
                "Paanu Ijẹun kekere",
                "kásẹrọ\u{300}",
                "pàẹ\u{301}là",
                "páànù ṣálò",
                "ónjẹ",
                "ṣálò",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("一盤食物"),
            keywords: &["一盤食物", "平底鑊", "淺", "砂鍋", "肉菜飯", "食物"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("一盘食物"),
            keywords: &["一盘食物", "平底镬", "浅", "砂锅", "肉菜饭", "食物"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("装有食物的浅底锅"),
            keywords: &["浅底", "煎锅", "装有食物的浅底锅", "食物"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("淺鍋料理"),
            keywords: &["平底鍋", "料理", "淺鍋", "淺鍋料理"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("一鍋食物"),
            keywords: &["一鍋食物", "海鮮飯", "淺鍋", "鍋", "食物"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ipani elinokudla"),
            keywords: &[
                "casserole",
                "ipani",
                "ipani elinokudla",
                "ngajulile",
                "paella",
                "ukudla",
            ],
        },
    ],
};
#[doc = "🍲"]
pub const POT_OF_FOOD: crate::Emoji = crate::Emoji {
    glyph: "🍲",
    codepoint: "1F372",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "pot of food",
    group: "Food & Drink",
    subgroup: "food-prepared",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("‘n pot kos"),
            keywords: &["bredie", "kastrol", "kos", "pot", "‘n pot kos"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የምግብ ሳሕን"),
            keywords: &["ምንቸት", "ቅቅል", "የምግብ ሳሕን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}وعاء طعام"),
            keywords: &["مطعم", "\u{202b}وعاء طعام"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("খ\u{9be}দ\u{9cd}যৰ প\u{9be}ত\u{9cd}ৰ"),
            keywords: &[
                "খ\u{9be}দ\u{9cd}যৰ প\u{9be}ত\u{9cd}ৰ",
                "খ\u{9be}দ\u{9cd}যৰ ব\u{9be}তি",
                "প\u{9be}ত\u{9cd}ৰ",
                "ষ\u{9cd}টিউ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yemək qazanı"),
            keywords: &["qab", "raqu", "yemək qazanı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("гаршчок з ежай"),
            keywords: &["гаршчок", "гаршчок з ежай", "тушэнне"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Гърне с храна"),
            keywords: &["Гърне с храна", "гърне", "яхния"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("খ\u{9be}দ\u{9cd}যের প\u{9be}ত\u{9cd}র"),
            keywords: &[
                "খ\u{9be}দ\u{9cd}যের প\u{9be}ত\u{9cd}র",
                "প\u{9be}ত\u{9cd}র",
                "স\u{9cd}ট\u{9cd}য\u{9c1}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pothouarnad"),
            keywords: &["keusteurenn", "pothouarn", "pothouarnad"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("lonac hrane"),
            keywords: &["lonac", "lonac hrane", "paprikaš"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cassola de menjar"),
            keywords: &[
                "cassola",
                "cassola de menjar",
                "estofat",
                "guisat",
                "menjar",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏧᎳᏍᎩ ᎧᎵ ᎠᎵᏍᏓᏴᏗ"),
            keywords: &["ᎠᏟᏍᏛ", "ᎤᎦᎹ", "ᏧᎳᏍᎩ ᎧᎵ ᎠᎵᏍᏓᏴᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("hrnec jídla"),
            keywords: &["guláš", "hrnec", "hrnec jídla", "polévka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("llestr o fwyd"),
            keywords: &["llestr", "llestr o fwyd", "stiw"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("gryde med mad"),
            keywords: &["gryde", "gryde med mad", "gryderet", "suppe"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Topf mit Essen"),
            keywords: &["Eintopf", "Gericht", "Topf mit Essen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κατσαρόλα με φαγητό"),
            keywords: &["κατσαρόλα", "κατσαρόλα με φαγητό", "μαγειρευτό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("pot of food"),
            keywords: &["pot", "pot of food", "stew"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("olla de comida"),
            keywords: &["comida de olla", "olla de comida", "puchero", "restaurante"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["comida", "olla", "olla de comida", "restaurante"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "comida",
                "estofado",
                "guisado",
                "guiso",
                "olla",
                "olla de comida",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("potitäis toitu"),
            keywords: &["hautis", "potitäis toitu", "pott"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("janari bete eltzea"),
            keywords: &["eltze", "erregosi", "janari bete eltzea"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ظرف غذا"),
            keywords: &["خورش", "ظرف غذا"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ruokakulho"),
            keywords: &["pata", "ruokakulho"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kaserola ng pagkain"),
            keywords: &[
                "kaserola",
                "kaserola ng pagkain",
                "nilaga",
                "pagkain",
                "sabaw",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("djúpur tallerkur við mati"),
            keywords: &["borðiskur", "djúpur", "djúpur tallerkur við mati", "matur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("marmite"),
            keywords: &["marmite", "ragoût"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("bol de nourriture"),
            keywords: &["bol de nourriture", "marmite", "ragoût"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("pota le bia"),
            keywords: &["pota", "pota le bia", "stobhach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("poit le biadh"),
            keywords: &["poit", "poit le biadh", "stiubha"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("pota con comida"),
            keywords: &["comida", "guiso", "pota", "pota con comida", "tarteira"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ભોજનન\u{ac1}\u{a82} વાસણ"),
            keywords: &[
                "ભોજનન\u{ac1}\u{a82} વાસણ",
                "ર\u{ac7}સ\u{acd}ટોરન\u{acd}ટ",
                "વાસણમા\u{a82}નો ખોરાક",
                "સ\u{acd}ટ\u{acd}ય\u{ac2}",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("tukunyar abinci"),
            keywords: &["miya", "tukunya", "tukunyar abinci"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סיר אוכל"),
            keywords: &["אדים", "אוכל", "נזיד", "סיר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{94d}ट\u{94d}य\u{942}, भोजन पात\u{94d}र"),
            keywords: &[
                "भोजन पात\u{94d}र",
                "र\u{947}स\u{94d}टोर\u{947}\u{902}ट",
                "स\u{94d}ट\u{94d}य\u{942}",
                "स\u{94d}ट\u{94d}य\u{942}, भोजन पात\u{94d}र",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lonac s hranom"),
            keywords: &["gulaš", "lonac", "lonac s hranom", "lonac s jelom"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("egy tál étel"),
            keywords: &["egy tál étel", "ennivaló", "tál", "étel"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("թասով ճաշ"),
            keywords: &["թաս", "թասով ճաշ", "ճաշ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("panci makanan"),
            keywords: &["mangkuk", "panci makanan", "rebusan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("itè nri"),
            keywords: &["itè", "itè nri", "ofe"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("pottréttur"),
            keywords: &["kássa", "pottréttur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pentola di cibo"),
            keywords: &["pentola di cibo", "ristorante", "stufato", "zuppa"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("なべ"),
            keywords: &["なべ", "シチュー", "煮物", "煮込み"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("jangan sapanci"),
            keywords: &["jangan sapanci", "panci", "semur"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქვაბი საჭმლით"),
            keywords: &["რაგუ", "ქვაბი", "ქვაბი საჭმლით"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тамақ толы бақыраш"),
            keywords: &["бақыраш", "бұқтырылған ет", "тамақ толы бақыраш"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("gryde med mad"),
            keywords: &["gryde", "gryde med mad", "gryderet", "suppe"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17d2}ហ\u{17bc}បម\u{17bd}យចាន"),
            keywords: &["ម\u{17d2}ហ\u{17bc}ប", "ម\u{17d2}ហ\u{17bc}បម\u{17bd}យចាន"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಡ\u{cbf}ಕ\u{cc6} ಆಹಾರ"),
            keywords: &[
                "ಮಡ\u{cbf}ಕ\u{cc6}",
                "ಮಡ\u{cbf}ಕ\u{cc6} ಆಹಾರ",
                "ಸ\u{ccd}ಟೀವ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("국"),
            keywords: &["국", "찌개", "탕"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("अन\u{94d}नाची कायल"),
            keywords: &["अन\u{94d}नाची कायल", "कायल", "स\u{94d}टिव"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бир табак тамак"),
            keywords: &["бир табак тамак", "табак", "шорпо"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Plat an enger Kasseroll"),
            keywords: &["Eintopf", "Kasseroll", "Plat an enger Kasseroll"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຖ\u{ec9}ວຍອາຫານ"),
            keywords: &["ຖ\u{ec9}ວຍອາຫານ", "ຖ\u{ec9}ອຍອາຫານ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("puodas su maistu"),
            keywords: &["puodas", "puodas su maistu", "troškinys"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ēdiena bļodiņa"),
            keywords: &["bļoda", "ēdiena bļodiņa", "ēdiens"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kōhua kai"),
            keywords: &["kōhua", "kōhua kai", "tiu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лонец со храна"),
            keywords: &["лонец", "лонец со храна", "чорба"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഭക\u{d4d}ഷണ പ\u{d3e}ത\u{d4d}രം"),
            keywords: &[
                "ച\u{d42}ട\u{d41}ള\u{d4d}ള ആഹ\u{d3e}രം",
                "ഭക\u{d4d}ഷണ പ\u{d3e}ത\u{d4d}രം",
                "ഭക\u{d4d}ഷണം",
                "ഹോട\u{d4d}ടൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хоолтой тогоо"),
            keywords: &["тогоо сав", "хоолтой тогоо"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("अन\u{94d}नाच\u{947} भा\u{902}ड\u{947}"),
            keywords: &[
                "अन\u{94d}नाच\u{947} भा\u{902}ड\u{947}",
                "खाद\u{94d}याच\u{947} भा\u{902}ड\u{947}",
                "भा\u{902}ड\u{947}",
                "स\u{94d}ट\u{94d}य\u{942}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("seperiuk makanan"),
            keywords: &["periuk", "seperiuk makanan", "stew"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("borma tal-ikel"),
            keywords: &["borma", "borma tal-ikel", "stuffat"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အစားအစာ အ\u{102d}\u{102f}း"),
            keywords: &[
                "ပြ\u{102f}တ\u{103a}ချက\u{103a}",
                "အစားအစာ အ\u{102d}\u{102f}း",
                "အ\u{102d}\u{102f}း",
                "အ\u{102d}\u{102f}းန\u{103e}င\u{1037}\u{103a} စားစရာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("gryterett"),
            keywords: &["gryte", "gryterett", "middag", "middagsmat", "panne"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("खाना राखिएको भा\u{901}डो"),
            keywords: &["खाना खान\u{947}", "खाना राखिएको भा\u{901}डो", "भा\u{901}डो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("stoofschotel"),
            keywords: &["eenpansgerecht", "stoofschotel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("gryterett"),
            keywords: &["gryte", "gryterett", "middag", "middagsmat", "panne"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଖ\u{b3e}ଦ\u{b4d}ୟରେ ଭର\u{b4d}ତ\u{b4d}ତ\u{b3f} ପ\u{b3e}ତ\u{b4d}ର"),
            keywords: &[
                "ଖ\u{b3e}ଦ\u{b4d}ୟରେ ଭର\u{b4d}ତ\u{b4d}ତ\u{b3f} ପ\u{b3e}ତ\u{b4d}ର",
                "ପ\u{b3e}ତ\u{b4d}ର ଖ\u{b3e}ଦ\u{b4d}ୟ",
                "ସନ\u{b4d}ତ\u{b41}ଳ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਭ\u{a4b}ਜਨ ਦਾ ਭਾ\u{a02}ਡਾ"),
            keywords: &[
                "ਬਰਤਨ ਭ\u{a4b}ਜਨ",
                "ਭ\u{a4b}ਜਨ ਦਾ ਭਾ\u{a02}ਡਾ",
                "ਸਟੀਉ",
                "ਹ\u{a4b}ਟਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("خوراک دی ہانڈی"),
            keywords: &["خوراک دی ہانڈی", "سٹیو", "ہانڈی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pọ\u{301}t Ọf Fud"),
            keywords: &["Pọt", "Pọ\u{301}t Ọf Fud", "Stiu"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("garnek z jedzeniem"),
            keywords: &["garnek z jedzeniem", "jedzenie", "potrawka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د خوړو لوښي"),
            keywords: &["د خوړو لوښي", "لوښي، د خوړو لوښي،"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("panela"),
            keywords: &["ensopado", "panela", "tigela de comida"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("tacho com comida"),
            keywords: &["guisado", "tacho", "tacho com comida"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("llata mikunapaq"),
            keywords: &["llata", "llata mikunapaq", "mikhuna"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("oală cu mâncare"),
            keywords: &["oală", "oală cu mâncare", "tocană"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-311"),
            keywords: &["E10-311"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("кастрюля с горячей едой"),
            keywords: &[
                "горячая еда",
                "горячее",
                "кастрюля",
                "кастрюля с горячей едой",
                "тарелка с горячей едой",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("icyungo cy’ibiryo"),
            keywords: &["icyungo cy’ibiryo", "inkono", "umufa"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("کاڌي جو برتن"),
            keywords: &["برتن، هلائڻ", "کاڌي جو برتن"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ආහ\u{dcf}ර බඳ\u{dd4}න"),
            keywords: &["ආහ\u{dcf}ර බඳ\u{dd4}න", "බඳ\u{dd4}න", "ස\u{dca}ට\u{dd6}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kotlík s jedlom"),
            keywords: &["jedlo", "kastról", "kotlík", "kotlík s jedlom"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("skodelica hrane"),
            keywords: &["obara", "skodelica", "skodelica hrane"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("digsi cunno ah"),
            keywords: &["digsi", "digsi cunno ah", "fuud"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kupë me ushqime"),
            keywords: &["kupë", "kupë me ushqime", "çomlek"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("чинија хране"),
            keywords: &["гулaш", "чинија", "чинија хране"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("činija hrane"),
            keywords: &["gulaš", "činija", "činija hrane"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("gryta"),
            keywords: &["gryta", "mat", "varm gryta"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("chungu cha chakula"),
            keywords: &["chungu", "chungu cha chakula", "mchuzi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ப\u{bbe}த\u{bcd}திரம\u{bcd} நிறைய உணவு"),
            keywords: &[
                "உணவகம\u{bcd}",
                "உணவு",
                "சூட\u{bbe}ன உணவு",
                "ப\u{bbe}த\u{bcd}திரத\u{bcd}தில\u{bcd} உணவு",
                "ப\u{bbe}த\u{bcd}திரம\u{bcd} நிறைய உணவு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కుండల\u{c4b} ఆహ\u{c3e}రం"),
            keywords: &[
                "ఇగురు",
                "కుండ ఆహ\u{c3e}రం",
                "కుండల\u{c4b} ఆహ\u{c3e}రం",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("деги ғизо"),
            keywords: &["дег", "деги ғизо", "пазондан"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("สต\u{e39}ว\u{e4c}"),
            keywords: &["สต\u{e39}ว\u{e4c}", "หม\u{e49}ออาหาร"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("naharly gazan"),
            keywords: &["bişirmek", "gazan", "naharly gazan"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kulo meʻakai"),
            keywords: &["kulo meʻakai"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yemek tenceresi"),
            keywords: &["restoran", "tencere yemeği", "yemek tenceresi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قازاندىكى ئاش"),
            keywords: &["دۈملەش", "قازان", "قازاندىكى ئاش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("горщик з їжею"),
            keywords: &["горщик", "горщик з їжею", "рагу"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("خوراک کا برتن"),
            keywords: &["برتن", "خوراک", "خوراک کا برتن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("bir qozon ovqat"),
            keywords: &["bir qozon ovqat", "go‘sht", "qozon"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nồi thức ăn"),
            keywords: &["hầm", "nồi", "nồi thức ăn"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("potu ñam"),
            keywords: &["potu", "potu ñam", "ragu"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("imbiza yokutya"),
            keywords: &["imbiza", "imbiza yokutya", "isityu"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ikoko Ounjẹ"),
            keywords: &["Ikoko Ounjẹ", "ìkòkò", "ọbẹ\u{300}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("一碗食物"),
            keywords: &["一碗食物", "燉", "鍋"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("一碗食物"),
            keywords: &["一碗食物", "炖", "锅"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("一锅食物"),
            keywords: &["一锅食物", "食物"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("火鍋"),
            keywords: &["火鍋"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("打邊爐"),
            keywords: &["打邊爐"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhdwe lokudla"),
            keywords: &["ibhdwe lokudla", "ibhodwe", "isitshulu"],
        },
    ],
};
#[doc = "🫕"]
pub const FONDUE: crate::Emoji = crate::Emoji {
    glyph: "🫕",
    codepoint: "1FAD5",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "fondue",
    group: "Food & Drink",
    subgroup: "food-prepared",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("fondue"),
            keywords: &[
                "Switsers",
                "diepbraai",
                "fondue",
                "gesmelt",
                "kaas",
                "pot",
                "sjokolade",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ፎንዴ"),
            keywords: &["ፎንዴ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("فوندو"),
            keywords: &["جبن", "ذائب", "سويسرا", "شوكولاتة", "فوندو", "وعاء"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ফনডিউ"),
            keywords: &[
                "গলি যোৱ\u{9be}",
                "চকলেট",
                "চীজ",
                "চ\u{9c1}ইচ",
                "প\u{9be}ত\u{9cd}ৰ",
                "ফনডিউ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("fondyu"),
            keywords: &[
                "fondyu",
                "güvəc",
                "pendir",
                "İsveçrə",
                "şokolad",
                "əridilmiş",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("фандзю"),
            keywords: &[
                "каструля",
                "расплаўлены",
                "сыр",
                "фандзю",
                "шакалад",
                "швейцарскі",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("фондю"),
            keywords: &[
                "разтопяване",
                "сирене",
                "съд",
                "фондю",
                "швейцарско",
                "шоколад",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ফন\u{9cd}ড\u{9c1}"),
            keywords: &[
                "গলিত",
                "চকোলেট",
                "চিজ",
                "প\u{9be}ত\u{9cd}র",
                "ফন\u{9cd}ড\u{9c1}",
                "স\u{9c1}ইস",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("teuzadell"),
            keywords: &["chokolad", "darbod", "formaj-laezh", "keuz", "teuzadell"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("fondue"),
            keywords: &[
                "fondue",
                "istopljeno",
                "lonac",
                "sir",
                "čokolada",
                "švicarska kuhinja",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("fondue"),
            keywords: &[
                "Suïssa", "cassola", "desfet", "fondue", "formatge", "xocolata",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏅᏗ ᎦᏚᏅ ᎬᎾᏬᏍᎦ"),
            keywords: &[
                "ᎤᏅᏗ ᎦᏚᏅ",
                "ᎤᏅᏗ ᎦᏚᏅ ᎬᎾᏬᏍᎦ",
                "ᎧᎵᏎᏥ ᎤᏬᏗᎨ",
                "ᎬᎾᏬᏍᎦ",
                "ᏍᏫᏏ",
                "ᏧᎳᏍᎩ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("fondue"),
            keywords: &["fondue", "sýr", "sýrové", "čokoládové", "švýcarské"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("fondue"),
            keywords: &["Swisaidd", "caws", "fondue", "pot", "siocled", "wedi toddi"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("fondue"),
            keywords: &[
                "chokolade",
                "fondue",
                "gryde",
                "ost",
                "schweizisk",
                "smeltet",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Fondue"),
            keywords: &[
                "Fondue",
                "Käse",
                "Schokolade",
                "Topf",
                "geschmolzen",
                "schweizerisch",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("φοντί"),
            keywords: &[
                "ελβετικό",
                "κατσαρόλα",
                "λιωμένο",
                "σοκολάτα",
                "τυρί",
                "φοντί",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("fondue"),
            keywords: &["Swiss", "cheese", "chocolate", "fondue", "melted", "pot"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("fondue"),
            keywords: &["chocolate", "fondue", "olla", "queso", "suizo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("fondue"),
            keywords: &["chocolate", "fondue", "olla", "queso", "suizo"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("fondue"),
            keywords: &["fondue"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("fondue"),
            keywords: &["fondue"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("fondüü"),
            keywords: &["fondüü", "juust", "nõu", "sulatatud", "šokolaad", "šveitsi"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("fonduea"),
            keywords: &[
                "eltzea",
                "fondue",
                "fonduea",
                "gazta",
                "ontzia",
                "suitzarra",
                "txokolatea",
                "urtua",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("فوندو"),
            keywords: &["آب شده", "سوییس", "شکلات", "فوندو", "قابلمه", "پنیر"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("fondue"),
            keywords: &[
                "fondue",
                "juusto",
                "pata",
                "suklaa",
                "sulatettu",
                "sveitsiläinen",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("fondue"),
            keywords: &["fondue", "keso", "lusaw", "swiss", "tsokolate"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("fondue"),
            keywords: &["Sveis", "fondue", "matur", "sjokuláta", "smelta"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("fondue"),
            keywords: &[
                "Suisse",
                "bourguignonne",
                "chocolat",
                "fondue",
                "fromage",
                "poêlon",
                "savoyarde",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("fondue"),
            keywords: &["chocolat", "fondu", "fondue", "fromage", "plat", "suisse"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("fondú"),
            keywords: &["Eilvéiseach", "cáis", "fondú", "leáite", "pota", "seacláid"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("fondue"),
            keywords: &[
                "Eilbheiseach",
                "càise",
                "fondue",
                "leaghta",
                "leaghte",
                "poit",
                "seoclaid",
                "teòclaid",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("fondue"),
            keywords: &[
                "A Suíza",
                "carne",
                "chocolate",
                "fondue",
                "fundir",
                "queixo",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ફૉન\u{acd}ડ\u{acd}ય\u{ac1}"),
            keywords: &[
                "ચીઝ",
                "ચોકલ\u{ac7}ટ",
                "પીગળ\u{ac7}લી",
                "ફૉન\u{acd}ડ\u{acd}ય\u{ac1}",
                "વાસણ",
                "સ\u{acd}વિસ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פונדו"),
            keywords: &["גבינות", "סיר", "פונדו", "שוקולד"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("फ\u{93c}ॉनड\u{942}"),
            keywords: &[
                "चॉकल\u{947}ट",
                "पनीर",
                "पिघला ह\u{941}आ",
                "फ\u{93c}ॉनड\u{942}",
                "बर\u{94d}तन",
                "स\u{94d}विस",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("fondi"),
            keywords: &[
                "fondi",
                "otopljeno",
                "posuda",
                "sir",
                "čokolada",
                "švicarsko",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fondü"),
            keywords: &[
                "csokoládé",
                "fondü",
                "lábas",
                "olvasztott",
                "sajt",
                "svájci",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ֆոնդյու"),
            keywords: &[
                "կճուճ",
                "հալած",
                "շոկոլադ",
                "շվեյցարական",
                "պանիր",
                "ֆոնդյու",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("fondue"),
            keywords: &["Swiss", "cokelat", "fondue", "keju", "meleleh", "periuk"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fondú"),
            keywords: &["Sviss", "brætt", "fondú", "ostur", "pottur", "súkkulaði"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("fonduta"),
            keywords: &[
                "cioccolato",
                "fonduta",
                "formaggio",
                "fuso",
                "pentola",
                "svizzero",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("フォンデュ"),
            keywords: &["スイス", "チョコ", "チーズ", "フォンデュ", "溶かす", "鍋"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pondue"),
            keywords: &["Swiss", "adah", "keju", "lumer", "pondue", "soklat"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ფონდიუ"),
            keywords: &[
                "გამდნარი",
                "მდნარი",
                "ფონდიუ",
                "ქოთანი",
                "ყველი",
                "შვეიცარიული",
                "შოკოლადი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("фондю"),
            keywords: &[
                "ерітілген",
                "таба",
                "фондю",
                "швейцариялық",
                "шоколад",
                "ірімшік",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ហ\u{17d2}វោនឌ\u{17bc}"),
            keywords: &[
                "ឆ\u{17d2}នា\u{17c6}ង",
                "ឈ\u{17b8}ស",
                "រលាយ",
                "ស\u{17bc}ក\u{17bc}ឡា",
                "ស\u{17d2}វ\u{17ca}\u{17b8}ស",
                "ហ\u{17d2}វោនឌ\u{17bc}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಫಂಡ\u{ccd}ಯು"),
            keywords: &[
                "ಕರಗ\u{cbf}ದ",
                "ಚಾಕೊಲೇಟ\u{ccd}",
                "ಚೀಸ\u{ccd}",
                "ಫಂಡ\u{ccd}ಯು",
                "ಮಡಕ\u{cc6}",
                "ಸ\u{ccd}ವ\u{cbf}ಸ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("퐁듀"),
            keywords: &["냄비", "녹다", "스위스", "초콜릿", "치즈", "퐁듀"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("फा\u{901}ड\u{94d}य\u{941}"),
            keywords: &[
                "कायल",
                "चीज",
                "चॉकल\u{947}ट",
                "फा\u{901}ड\u{94d}य\u{941}",
                "वितळिल\u{94d}ली",
                "स\u{94d}विज",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("фондю"),
            keywords: &["фондью", "фондю"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຟອງດ\u{eb9}"),
            keywords: &[
                "ການຳ\u{ec9}",
                "ຊ\u{eb5}ດສ",
                "ຊ\u{ecb}ອກໂກແລ\u{eb1}ດ",
                "ຟອງດ\u{eb9}",
                "ລະລາຍ",
                "ສະວ\u{eb4}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("fondiu"),
            keywords: &[
                "dubuo",
                "fondiu",
                "ištirpintas",
                "sūris",
                "šokoladas",
                "šveicariškas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("fondī"),
            keywords: &[
                "fondī",
                "kausēts",
                "podiņš",
                "siers",
                "šokolāde",
                "šveiciešu",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("топено сирење"),
            keywords: &[
                "кашкавал",
                "стопено",
                "топено сирење",
                "чоколада",
                "швајцарско",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഫോണ\u{d4d}ട\u{d4d}യ\u{d42}"),
            keywords: &[
                "ചീസ\u{d4d}",
                "ചോക\u{d4d}ലേറ\u{d4d}റ\u{d4d}",
                "പോട\u{d4d}ട\u{d4d}",
                "ഫോണ\u{d4d}ട\u{d4d}യ\u{d42}",
                "മെൽറ\u{d4d}റഡ\u{d4d}",
                "സ\u{d4d}വിസ\u{d4d}സ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("фондю"),
            keywords: &[
                "Швейцар",
                "бяслаг",
                "фондю",
                "хайлсан",
                "хоолны сав",
                "шоколад",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("फॉन\u{94d}ड\u{94d}य\u{942}"),
            keywords: &[
                "चीज",
                "चॉकोल\u{947}ट",
                "फॉन\u{94d}ड\u{94d}य\u{942}",
                "भा\u{902}ड\u{947}",
                "वितळल\u{947}ल\u{947}",
                "स\u{94d}विस",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("fondue"),
            keywords: &["Swiss", "cair", "cokelat", "fondue", "keju", "periuk"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဖောင\u{103a}ဒ\u{1030}"),
            keywords: &[
                "ချ\u{102d}စ\u{103a}",
                "ချောကလက\u{103a}",
                "ဆ\u{103d}စ\u{103a}",
                "ဖောင\u{103a}ဒ\u{1030}",
                "အ\u{102d}\u{102f}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("fondy"),
            keywords: &[
                "fondue",
                "fondy",
                "gryte",
                "ost",
                "sjokolade",
                "smeltet",
                "sveitsisk",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("फन\u{94d}ड\u{941}"),
            keywords: &[
                "चकल\u{947}ट",
                "चीज",
                "पग\u{94d}लिएको",
                "फन\u{94d}ड\u{941}",
                "भा\u{901}डो",
                "स\u{94d}विस",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("fondue"),
            keywords: &["Zwitsers", "chocola", "fondue", "gesmolten", "kaas", "pan"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("fondy"),
            keywords: &[
                "fondue",
                "fondy",
                "gryte",
                "ost",
                "sjokolade",
                "smelta",
                "sveitsisk",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଫଣ\u{b4d}ଡ\u{b4d}ୟ\u{b41}"),
            keywords: &[
                "ଚକଲେଟ\u{b4d}\u{200c}",
                "ଛେନ\u{b3e}",
                "ତରଳ",
                "ପ\u{b3e}ତ\u{b4d}ର",
                "ଫଣ\u{b4d}ଡ\u{b4d}ୟ\u{b41}",
                "ସ\u{b4d}ୱ\u{b3f}ସ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਫ\u{a4b}\u{a02}ਡਜ\u{a42}"),
            keywords: &[
                "ਚਾਕਲ\u{a47}ਟ",
                "ਪਨੀਰ",
                "ਪਿਗਲਿਆ",
                "ਫ\u{a4b}\u{a02}ਡਜ\u{a42}",
                "ਬਰਤਨ",
                "ਸਵਿ\u{a71}ਸ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fọ\u{301}ndu"),
            keywords: &[
                "Chiz",
                "Chọ\u{301}kọ\u{301}lét",
                "Fọ\u{301}ndu",
                "Mẹlt",
                "Pọt",
                "Swis",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("fondue"),
            keywords: &[
                "czekolada",
                "fondue",
                "garnek",
                "roztopione",
                "ser",
                "szwajcarskie",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ارکاره"),
            keywords: &["ارکاره", "سويس", "لوښی", "ويلي شوي", "پنير", "چکليټ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("fondue"),
            keywords: &[
                "chocolate",
                "derretido",
                "fondue",
                "panela",
                "queijo",
                "suíço",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("fondue"),
            keywords: &[
                "Suizo",
                "chaqrusqa",
                "chocolate",
                "fondue",
                "masara",
                "qiru",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("fondue"),
            keywords: &[
                "brânză",
                "ciocolată",
                "fondue",
                "mâncare elvețiană",
                "topită",
                "vas de gătit",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-043"),
            keywords: &["E13-043"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("фондю"),
            keywords: &[
                "какелон",
                "плавленый",
                "сыр",
                "фондю",
                "швейцарский",
                "шоколад",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("فانڊيو"),
            keywords: &["برتن", "سوس", "فانڊيو", "چاڪليٽ", "چيز", "ڳريل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ෆොන\u{dca}ඩ\u{dd2}"),
            keywords: &[
                "උණ\u{dd4} කොට",
                "ච\u{dd3}ස\u{dca}",
                "චොකලට\u{dca}",
                "බඳ\u{dd4}න",
                "ස\u{dca}ව\u{dd2}ට\u{dca}සර\u{dca}ලන\u{dca}තය",
                "ෆොන\u{dca}ඩ\u{dd2}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("fondue"),
            keywords: &["fondue", "rozpustiť", "syr", "čokoláda", "švajčiarské"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("fondi"),
            keywords: &[
                "fondi",
                "lonček",
                "sir",
                "stopljena",
                "čokolada",
                "švicarski",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("digsi cunnno lagu diyaariyay"),
            keywords: &[
                "Swiss",
                "burcad",
                "dhalaalay",
                "digsi cunnno lagu diyaariyay",
                "digsi cunno lagu diyaariyay",
                "shukulaato",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fondue"),
            keywords: &[
                "djathë",
                "fondue",
                "gotë",
                "shkrirë",
                "zviceran",
                "çokollatë",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("фонду"),
            keywords: &[
                "сир",
                "топљено",
                "фонду",
                "чоколада",
                "швајацарски",
                "шерпа",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("fondu"),
            keywords: &[
                "fondu",
                "sir",
                "topljeno",
                "čokolada",
                "šerpa",
                "švajacarski",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("fondue"),
            keywords: &[
                "choklad",
                "fondue",
                "gryta",
                "ost",
                "schweiziskt",
                "smältande",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("jibini iliyoyeyushwa"),
            keywords: &[
                "chokoleti",
                "jibini",
                "jibini iliyoyeyushwa",
                "kuyeyushwa",
                "sufuria",
                "uswisi",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஃப\u{bbe}ண\u{bcd}டூ"),
            keywords: &[
                "ஃப\u{bbe}ண\u{bcd}டூ",
                "உருகியது",
                "குவளை",
                "ச\u{bbe}க\u{bcd}கலேட\u{bcd}",
                "சுவிஸ\u{bcd}",
                "ப\u{bbe}ல\u{bbe}டைக\u{bcd}கட\u{bcd}டி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఫ\u{c3e}ండ\u{c4d}యూ"),
            keywords: &[
                "చ\u{c3e}క\u{c4a}ల\u{c46}ట\u{c4d}",
                "జున\u{c4d}ను",
                "ఫ\u{c3e}ండ\u{c4d}యూ",
                "స\u{c4d}వ\u{c3f}స\u{c4d}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ฟองด\u{e39}ว\u{e4c}"),
            keywords: &[
                "ช\u{e35}ส",
                "ช\u{e47}อกโกแลต",
                "ฟองด\u{e39}ว\u{e4c}",
                "ละลาย",
                "สว\u{e34}ส",
                "หม\u{e49}อ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("fondýu"),
            keywords: &["erän", "fondýu", "peýnir", "piti", "şokolad", "şweýsar"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("siisi māfana"),
            keywords: &["siisi māfana"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("fondü"),
            keywords: &["erimiş", "fondü", "kap", "peynir", "çikolata", "İsviçre"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("фондю"),
            keywords: &[
                "горщичок",
                "сир",
                "топлений",
                "фондю",
                "швейцарська страва",
                "шоколад",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("فانڈی"),
            keywords: &["برتن", "سوئس", "فانڈی", "پنیر", "پگھلا ہوا", "چاکلیٹ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("fondyu"),
            keywords: &[
                "eritilgan",
                "fondyu",
                "pishloq",
                "shokolad",
                "shveytsar",
                "shveytsarcha",
                "tova",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("lẩu pho mai"),
            keywords: &[
                "Thụy Sĩ",
                "lẩu pho mai",
                "nồi",
                "phô mai",
                "sô cô la",
                "tan chảy",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("芝士火鍋"),
            keywords: &["朱古力", "煲", "瑞士", "芝士", "芝士火鍋", "融"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("芝士火锅"),
            keywords: &["朱古力", "煲", "瑞士", "芝士", "芝士火锅", "融"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("奶酪火锅"),
            keywords: &["奶酪", "奶酪火锅", "巧克力", "瑞士", "融化", "锅"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("涮製菜餚"),
            keywords: &["乳酪", "巧克力", "涮製菜餚", "瑞士", "融化", "鍋"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-fondue"),
            keywords: &[
                "i-Swiss",
                "i-fondue",
                "ibhodwe",
                "ncibilikile",
                "ushizi",
                "ushokoledi",
            ],
        },
    ],
};
#[doc = "🥣"]
pub const BOWL_WITH_SPOON: crate::Emoji = crate::Emoji {
    glyph: "🥣",
    codepoint: "1F963",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "bowl with spoon",
    group: "Food & Drink",
    subgroup: "food-prepared",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("bakkie met lepel"),
            keywords: &["bakkie met lepel", "conjee", "ontbyt", "ryswater"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሳህን ሙሉ ማንኪያ"),
            keywords: &["ሳህን ሙሉ ማንኪያ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("طبق وملعقة"),
            keywords: &["طبق وملعقة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চ\u{9be}মোচ সহ ব\u{9be}তি"),
            keywords: &[
                "কঙ\u{9cd}গী",
                "খ\u{9be}দ\u{9cd}য",
                "চ\u{9be}মোচ সহ ব\u{9be}তি",
                "ৰ\u{9be}তিপ\u{9c1}ৱ\u{9be}ৰ আহ\u{9be}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qaşıq ilə kasa"),
            keywords: &["dənəvər", "qaşıq ilə kasa", "səhər yeməyi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("міска з лыжкай"),
            keywords: &["каша", "міска з лыжкай", "сняданак", "шматкі"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("купа с лъжица"),
            keywords: &[
                "азиатска оризова каша",
                "закуска",
                "зърнена закуска",
                "купа с лъжица",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9be}টি আর চ\u{9be}মচ"),
            keywords: &[
                "কর\u{9cd}ণফ\u{9cd}লেক\u{9cd}স",
                "পোরিজ",
                "ব\u{9be}টি আর চ\u{9be}মচ",
                "ব\u{9cd}রেকফ\u{9be}স\u{9cd}ট",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bolennad gant loa"),
            keywords: &[
                "bolenn",
                "bolennad",
                "bolennad gant loa",
                "dijuniñ",
                "edaj",
                "loa",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zdjela s kašikom"),
            keywords: &["doručak", "zdjela s kašikom", "žitarice"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bol amb cullera"),
            keywords: &["bol amb cullera", "cereals", "esmorzar"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏅᏪᏓ ᎾᏍᎩ ᎬᏩᏠᏯᏍᏗ ᎠᏗᏙᏘ"),
            keywords: &["ᎤᏅᏪᏓ ᎾᏍᎩ ᎬᏩᏠᏯᏍᏗ ᎠᏗᏙᏘ", "ᎬᏫᏍᏓ", "ᏑᎾᎴᎢ ᎠᎵᏍᏓᏰᏗ", "ᏓᎵᏆ ᎬᏫᏍᏔᏅ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("miska se lžící"),
            keywords: &[
                "cereálie",
                "cornflakes",
                "kaše",
                "kornflejks",
                "kornflejky",
                "krupičná",
                "kukuřičné",
                "lupínky",
                "miska se lžící",
                "muesli",
                "musli",
                "müsli",
                "ovesná",
                "snídaně",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bowlen â llwy"),
            keywords: &["bowlen â llwy", "brecwast", "congee", "grawnfwyd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ske i skål"),
            keywords: &["havregrød", "morgenmad", "mysli", "ske i skål"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schüssel mit Löffel"),
            keywords: &["Cerealien", "Frühstück", "Reisbrei", "Schüssel mit Löffel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μπολ με κουτάλι"),
            keywords: &["δημητριακά", "μπολ με κουτάλι", "πρωινό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("bowl with spoon"),
            keywords: &["bowl with spoon", "breakfast", "cereal", "congee"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cuenco con cuchara"),
            keywords: &["cereal", "cuenco con cuchara", "desayuno"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("tazón con cuchara"),
            keywords: &["tazón con cuchara"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("tazón con cuchara"),
            keywords: &["cereal", "desayuno", "tazón con cuchara"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("lusikaga kauss"),
            keywords: &[
                "hommikueine",
                "hommikusöögihelbed",
                "lusikaga kauss",
                "riisipuding",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("katilua eta koilara"),
            keywords: &["congee", "gosari", "katilua eta koilara", "zereal"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کاسه و قاشق"),
            keywords: &["آش برنج", "حلیم صبحانه", "شله", "صبحانه", "کاسه و قاشق"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kulho ja lusikka"),
            keywords: &["aamiainen", "kulho ja lusikka", "murot"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mangkok na may kutsara"),
            keywords: &["agahan", "cereal", "lugaw", "mangkok na may kutsara"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("bolli við skeið"),
            keywords: &["bolli við skeið", "kornflykrur", "matur", "morgunmatur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bol avec cuillère"),
            keywords: &["bol avec cuillère", "congee", "céréales", "déjeuner"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("babhla le spúnóg"),
            keywords: &["babhla le spúnóg", "bricfeasta", "gránach", "leite"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bobhla le spàin"),
            keywords: &["bobhla le spàin", "bracaist", "gràinean"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cunca con culler"),
            keywords: &["almorzo", "cereais", "cunca con culler", "potaxe"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}પ\u{ac2}ન સાથ\u{ac7} બોલ"),
            keywords: &[
                "કોન\u{acd}જી",
                "બ\u{acd}ર\u{ac7}કફાસ\u{acd}ટ",
                "સિરીઅલ",
                "સ\u{acd}પ\u{ac2}ન સાથ\u{ac7} બોલ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kwano tare da cokali"),
            keywords: &["abincin safe", "congee", "hatsi", "kwano tare da cokali"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קערה עם כף"),
            keywords: &["ארוחת בוקר", "דגני בוקר", "קערה עם כף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चम\u{94d}मच क\u{947} साथ कटोरी"),
            keywords: &[
                "अनाज",
                "चम\u{94d}मच क\u{947} साथ कटोरी",
                "चावल की दलिया",
                "नाश\u{94d}ता",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zdjelica sa žlicom"),
            keywords: &["doručak", "zdjelica sa žlicom", "žitarice"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("tál kanállal"),
            keywords: &["gabonapehely", "reggeli", "rizskása", "tál kanállal"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("գդալով աման"),
            keywords: &["գդալով աման", "նախաճաշ", "շիլա"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("mangkuk dengan sendok"),
            keywords: &["bubur", "mangkuk dengan sendok", "sarapan", "sereal"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("efere ofe na ngaji"),
            keywords: &[
                "efere ofe na ngaji",
                "nri ụtụtụ",
                "nriọka",
                "òsikapa agwọrọ agwọ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("skál og skeið"),
            keywords: &["morgunkorn", "morgunmatur", "morgunverður", "skál og skeið"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("ciotola con cucchiaio"),
            keywords: &["cereali", "ciotola con cucchiaio", "colazione"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ボウルとスプーン"),
            keywords: &["おかゆ", "シリアル", "ボウルとスプーン", "朝食"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("mangkok karo sendhok"),
            keywords: &["bubur", "mangkok karo sendhok", "sarapan", "sereal"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("თასი კოვზით"),
            keywords: &["გრანოლა", "თასი კოვზით", "მიუსლი", "საუზმე", "ფაფა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қасығы бар ыдыс"),
            keywords: &["қасығы бар ыдыс"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ចានគោមជាម\u{17bd}យស\u{17d2}លាបព\u{17d2}រា"),
            keywords: &[
                "គ\u{17d2}រាប\u{17cb}ធញ\u{17d2}ញជាត\u{17b7}",
                "ចានគោមជាម\u{17bd}យស\u{17d2}លាបព\u{17d2}រា",
                "បបរ",
                "អាហារពេលព\u{17d2}រ\u{17b9}ក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{ccd}ಪ\u{cc2}ನ\u{ccd}\u{200c}ನೊಂದ\u{cbf}ಗ\u{cc6} ಬ\u{ccc}ಲ\u{ccd}"),
            keywords: &[
                "ಉಪಹಾರ",
                "ಗಂಜ\u{cbf}",
                "ಧಾನ\u{ccd}ಯ",
                "ಸ\u{ccd}ಪ\u{cc2}ನ\u{ccd}\u{200c}ನೊಂದ\u{cbf}ಗ\u{cc6} ಬ\u{ccc}ಲ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("스푼과 사발"),
            keywords: &["스푼과 사발", "시리얼", "아침", "콘지"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("क\u{941}ल\u{947}र आनी वाटी"),
            keywords: &[
                "कडधान\u{94d}य",
                "का\u{901}गी",
                "क\u{941}ल\u{947}र आनी वाटी",
                "नाश\u{94d}तो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кашык салынган кесе"),
            keywords: &[
                "ботко",
                "кашык салынган кесе",
                "күрүч боткосу",
                "таңкы тамак",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Boll mat Läffel"),
            keywords: &["Boll mat Läffel", "Frühstück", "Kaffi", "Müsli"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຖ\u{ec9}ວຍກ\u{eb1}ບບ\u{ec8}ວງ"),
            keywords: &[
                "ຊ\u{eb5}ຣຽວ",
                "ຖ\u{ec9}ວຍກ\u{eb1}ບບ\u{ec8}ວງ",
                "ອາຫານເຊ\u{ebb}\u{ec9}າ",
                "ເຂ\u{ebb}\u{ec9}າປຽກເຂ\u{ebb}\u{ec9}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("dubuo su šaukštu"),
            keywords: &["dubuo su šaukštu", "košė", "pusryčiai"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("bļoda ar karoti"),
            keywords: &["brokastis", "bļoda ar karoti", "graudaugi", "rīsu putra"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("paepae me te pūnu"),
            keywords: &["congee", "hereara", "paepae me te pūnu", "parakuihi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("сад со лажица"),
            keywords: &["житарки", "каша со ориз", "појадок", "сад со лажица"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പിഞ\u{d4d}ഞ\u{d3e}ണവ\u{d41}ം സ\u{d4d}പ\u{d42}ണ\u{d41}ം"),
            keywords: &[
                "കഞ\u{d4d}ഞി",
                "പിഞ\u{d4d}ഞ\u{d3e}ണവ\u{d41}ം സ\u{d4d}പ\u{d42}ണ\u{d41}ം",
                "പ\u{d4d}ര\u{d3e}തൽ",
                "ഭക\u{d4d}ഷണം",
                "സ\u{d42}പ\u{d4d}പ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("халбагатай сав"),
            keywords: &["буудай", "халбагатай сав", "өглөөний цай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("वाटी चमचा"),
            keywords: &[
                "का\u{901}गी",
                "चमच\u{94d}यासह बाऊल",
                "नाश\u{94d}ता",
                "वाटी चमचा",
                "स\u{947}र\u{947}ल",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("mangkuk dan sudu"),
            keywords: &["bijirin", "bubur", "mangkuk dan sudu", "sarapan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("skutella b’mgħarfa"),
            keywords: &["congee", "kolazzjon", "skutella b’mgħarfa", "ċereali"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ဇ\u{103d}န\u{103a}းန\u{103e}င\u{1037}\u{103a} ဟင\u{103a}းခ\u{103d}က\u{103a}",
            ),
            keywords: &[
                "ဇ\u{103d}န\u{103a}းန\u{103e}င\u{1037}\u{103a} ဟင\u{103a}းခ\u{103d}က\u{103a}",
                "န\u{1036}နက\u{103a}စာ",
                "အန\u{103e}\u{1036}အစေ\u{1037}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bolle med skje"),
            keywords: &[
                "bolle med skje",
                "congee",
                "frokost",
                "frokostblanding",
                "grøt",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("चम\u{94d}चासहितको बट\u{941}का"),
            keywords: &["चम\u{94d}चासहितको बट\u{941}का", "बिहानको खाजा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kom met lepel"),
            keywords: &["cornflakes", "kom met lepel", "muesli", "ontbijt"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bolle med skei"),
            keywords: &[
                "bolle med skei",
                "congee",
                "frukost",
                "frukostblanding",
                "graut",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଚ\u{b3e}ମ\u{b41}ଚ ସହ\u{b3f}ତ ଗ\u{b3f}ନ\u{b3e}"),
            keywords: &[
                "ଚ\u{b3e}ମ\u{b41}ଚ ସହ\u{b3f}ତ ଗ\u{b3f}ନ\u{b3e}",
                "ପ\u{b4d}ର\u{b3e}ତଃଭୋଜନ । ଖ\u{b3e}ଦ\u{b4d}ୟଶସ\u{b4d}ୟ । କଙ\u{b4d}ଗୀ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚਮਚ ਅਤ\u{a47} ਕ\u{a4c}ਲੀ"),
            keywords: &[
                "ਅਨਾਜ",
                "ਕ\u{a4b}\u{a70}ਗੀ",
                "ਚਮਚ ਅਤ\u{a47} ਕ\u{a4c}ਲੀ",
                "ਸਵ\u{a47}ਰ ਦਾ ਨਾਸ\u{a3c}ਤਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چمچ نال پیالہ"),
            keywords: &["دلیہ", "غلہ", "ناشتہ", "چمچ نال پیالہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Díp-plet Wit Spun"),
            keywords: &[
                "Brẹ\u{301}kfast",
                "Díp Plet Wit Spun",
                "Díp-plet Wit Spun",
                "Fud",
                "Kọ\u{301}nji: Wọ\u{301}n Fud Wé Dẹm Mék Wit Rais",
                "Mọ\u{301}nín Chọp",
                "Síril: Fud Wé Dẹm Mék Wit Gren Laik Kọn, Báli, Wit",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("miska z łyżką"),
            keywords: &["miska z łyżką"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پياله د کاچوغې سره"),
            keywords: &[
                "پياله او کاچوغه، سبانارې، سيريل، کونجي",
                "پياله د کاچوغې سره",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("tigela com colher"),
            keywords: &["café da manhã", "cereal", "tigela com colher"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["cereais", "pequeno-almoço", "tigela com colher"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("cuenco willawan"),
            keywords: &["cereal", "congee", "cuenco willawan", "paqarin mikhuna"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("castron cu lingură"),
            keywords: &["castron cu lingură", "cereale", "mic dejun", "terci"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1087"),
            keywords: &["E10-1087"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("миска с ложкой"),
            keywords: &[
                "гранола",
                "завтрак",
                "миска с ложкой",
                "мюсли",
                "овсяные хлопья",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("imbehe n’ikiyiko"),
            keywords: &[
                "ibinyampeke",
                "ibyo gusamura",
                "imbehe n’ikiyiko",
                "umuceri w’isupu",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("چمچ سان برتن"),
            keywords: &["ناشتو، اناج، دليو", "چمچ سان برتن"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හැන\u{dca}දක\u{dca} සහ\u{dd2}ත බඳ\u{dd4}න"),
            keywords: &[
                "උදෑසන ආහ\u{dcf}රය",
                "කොන\u{dca}ගෙය\u{dd2}",
                "ස\u{dd3}ර\u{dd2}යල\u{dca}",
                "හැන\u{dca}දක\u{dca} සහ\u{dd2}ත බඳ\u{dd4}න",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("misa s\u{a0}lyžicou"),
            keywords: &["kaša", "misa s\u{a0}lyžicou", "puding", "raňajky"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("skodelica z žlico"),
            keywords: &["skodelica z žlico"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("baaquli iyo qaaddo"),
            keywords: &["baaquli iyo qaaddo", "badar", "qureec"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("tas me lugë"),
            keywords: &["drithëra", "tas me lugë", "vakti i mëngjesit"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("чинија са кашиком"),
            keywords: &["доручак", "пахуљице", "чинија са кашиком"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("činija sa kašikom"),
            keywords: &["doručak", "pahuljice", "činija sa kašikom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("skål och sked"),
            keywords: &["flingor", "frukost", "skål och sked"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("bakuli lenye kijiko"),
            keywords: &["bakuli lenye kijiko", "kiamsha kinywa", "nafaka", "uji"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஸ\u{bcd}பூன\u{bcd} உள\u{bcd}ள ப\u{bbe}த\u{bcd}திரம\u{bcd}"),
            keywords: &[
                "க\u{bbe}லை உணவு",
                "ப\u{bcd}ரேக\u{bcd}ஃப\u{bbe}ஸ\u{bcd}ட\u{bcd}",
                "ஸ\u{bcd}பூன\u{bcd} உள\u{bcd}ள ப\u{bbe}த\u{bcd}திரம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c46}ంచ\u{c3e}త\u{c4b} కప\u{c4d}పు"),
            keywords: &[
                "క\u{c3e}ంజ\u{c40}",
                "చ\u{c46}ంచ\u{c3e}త\u{c4b} కప\u{c4d}పు",
                "బ\u{c4d}ర\u{c47}క\u{c4d}\u{200c}ఫ\u{c3e}స\u{c4d}ట\u{c4d}",
                "స\u{c46}రల\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("табақ бо қошуқ"),
            keywords: &["наҳорӣ", "табақ бо қошуқ", "шӯла", "шӯлаи биринҷӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ชามพร\u{e49}อมช\u{e49}อน"),
            keywords: &[
                "ข\u{e49}าวต\u{e49}ม",
                "ชามพร\u{e49}อมช\u{e49}อน",
                "ซ\u{e35}เร\u{e35}ยล",
                "โจ\u{e4a}ก",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çemçe bilen şakäse"),
            keywords: &["ertirlik", "galla", "tüwi hamyry", "çemçe bilen şakäse"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("poulu moe sepuni"),
            keywords: &["poulu moe sepuni"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kaşıklı kase"),
            keywords: &["kahvaltı", "kaşıklı kase", "pirinç lapası", "tahıl gevreği"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قوشۇقلۇق قاچا"),
            keywords: &["ئاش", "ئۇماچ", "قوشۇقلۇق قاچا", "ناشتا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("миска з ложкою"),
            keywords: &["злаки", "миска з ложкою", "рисова каша", "сніданок"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چمچ اور کٹورا"),
            keywords: &["اناج", "دلیہ", "ناشتہ", "چمچ اور کٹورا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kosa bilan qoshiq"),
            keywords: &["atala", "bodroq", "bo‘tqa", "kosa bilan qoshiq", "nonushta"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bát và thìa"),
            keywords: &["bát và thìa", "bữa sáng", "ngũ cốc"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bool ak kuddu"),
            keywords: &["bool ak kuddu", "congee", "dugub", "ndeki"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isitya esinecephe"),
            keywords: &[
                "i-cereal",
                "i-congee",
                "isidlo sakusasa",
                "isitya esinecephe",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("abọ\u{301} pẹ\u{300}lú ṣíbí"),
            keywords: &[
                "abọ\u{301} pẹ\u{300}lú ṣíbí",
                "congee",
                "àgbàdo",
                "ónjẹ àrọ\u{300}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("碗同匙羮"),
            keywords: &["早餐", "燕麥", "碗同匙羮", "粥"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("碗同匙羮"),
            keywords: &["早餐", "燕麦", "碗同匙羮", "粥"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("碗勺"),
            keywords: &["早餐", "碗勺", "粥", "谷物"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("碗和湯匙"),
            keywords: &["碗和湯匙", "餐具"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("匙羮同碗"),
            keywords: &["匙羮", "匙羮同碗", "碗", "粥", "附有湯匙的碗"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("idla ngespuni"),
            keywords: &["i-congee", "ibhulakfesi", "idla ngespuni", "isiriyeli"],
        },
    ],
};
#[doc = "🥗"]
pub const GREEN_SALAD: crate::Emoji = crate::Emoji {
    glyph: "🥗",
    codepoint: "1F957",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "green salad",
    group: "Food & Drink",
    subgroup: "food-prepared",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("groenslaai"),
            keywords: &["blaarslaai", "groenslaai", "kos", "slaai"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አረንጓዴ ሰላጣ"),
            keywords: &["ምግብ", "ሰላጣ", "አረንጓዴ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سلطة خضراء"),
            keywords: &["خضراء", "سلطة", "طعام"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("সেউজীয\u{9bc}\u{9be} চ\u{9be}ল\u{9be}দ"),
            keywords: &[
                "খ\u{9be}দ\u{9cd}য",
                "চ\u{9be}ল\u{9be}দ",
                "সেউজীয\u{9bc}\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("salat"),
            keywords: &["salat", "tərəvəz", "yaşıl"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("салата з зеляніны"),
            keywords: &[
                "гародніна",
                "ежа",
                "зеляніна",
                "салата",
                "салата з зеляніны",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("зелена салата"),
            keywords: &["зелена", "салата", "храна"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("গ\u{9cd}রিন স\u{9cd}য\u{9be}ল\u{9be}দ"),
            keywords: &[
                "খ\u{9be}ব\u{9be}র",
                "গ\u{9cd}রিন",
                "স\u{9cd}য\u{9be}ল\u{9be}দ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("saladenn"),
            keywords: &["boued", "saladenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zelena salata"),
            keywords: &["hrana", "salata", "zelena salata"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("amanida"),
            keywords: &["amanida", "bol", "enciam", "menjar", "verd"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄇𑄎 𑄣𑄘𑄖\u{11134}"),
            keywords: &["𑄇𑄎 𑄣𑄘𑄖\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎢᏤᏳᏍᏗ ᎪᏍᏓ ᎠᎩᏍᏗ"),
            keywords: &["ᎠᎩᏍᏗ", "ᎢᏤ ᎢᏳᏍᏗ", "ᎢᏤᏳᏍᏗ ᎪᏍᏓ ᎠᎩᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("salát"),
            keywords: &["jídlo", "salát", "zelený"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("salad gwyrdd"),
            keywords: &["bwyd", "gwyrdd", "salad"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("grøn salat"),
            keywords: &["grøn", "mad", "salat"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Salat"),
            keywords: &["Essen", "Salat"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πράσινη σαλάτα"),
            keywords: &["πράσινη σαλάτα", "σαλάτα", "τροφή", "χόρτα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("green salad"),
            keywords: &["food", "green", "salad"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("garden salad"),
            keywords: &["food", "garden", "salad"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ensalada"),
            keywords: &["bol", "comida", "ensalada", "verde"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["comida", "ensalada"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("ensalada verde"),
            keywords: &["comida", "ensalada", "verde"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("roheline salat"),
            keywords: &["roheline", "salat", "toit"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("entsalada berdea"),
            keywords: &["berde", "entsalada", "entsalada berdea", "janari"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("سالاد سبزیجات"),
            keywords: &["سالاد", "سبزی", "سبزیجات", "غذا"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vihreä salaatti"),
            keywords: &["ruoka", "salaatti", "vihreä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("salad na gulay"),
            keywords: &["berde", "pagkain", "salad", "salad na gulay"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("salat"),
            keywords: &["grønmeti", "matur", "salat"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("salade verte"),
            keywords: &["salade", "verte"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("sailéad"),
            keywords: &["bia", "glasraí", "sailéad"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sailead uaine"),
            keywords: &["biadh", "sailead", "uaine"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("ensalada"),
            keywords: &["comida", "ensalada", "leituga"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લીલ\u{ac1}\u{a82} સ\u{ac5}લડ"),
            keywords: &["ભોજન", "લીલ\u{ac1}\u{a82}", "સ\u{ac5}લડ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("salak na ganye"),
            keywords: &["abinci", "ganyen", "salak", "salak na ganye"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סלט ירקות"),
            keywords: &["סלט", "סלט בריאות", "סלט ירוק", "סלט ירקות"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("हरा सलाद"),
            keywords: &["भोजन", "सलाद", "हरा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zelena salata"),
            keywords: &["hrana", "salata", "zelena salata", "zeleno"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("zöld saláta"),
            keywords: &["saláta", "zöld", "étel"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("աղցան"),
            keywords: &["աղցան", "բանջարեղեն", "ուտելիք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("salad hijau"),
            keywords: &["makanan", "salad", "salad hijau", "sayuran"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("saladị ndụ ndụ"),
            keywords: &["akwụkwọnri", "ndụ ndụ", "nri", "saladị ndụ ndụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("salat"),
            keywords: &["grænmeti", "matur", "salat"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("insalata verde"),
            keywords: &["cibo", "insalata", "insalata verde"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("グリーンサラダ"),
            keywords: &["グリーン", "グリーンサラダ", "サラダ"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("urap-urap sayur"),
            keywords: &["dhaharan", "ijo-ijo", "urap", "urap-urap sayur"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მწვანე სალათა"),
            keywords: &["მწვანე", "მწვანე სალათა", "საკვები", "სალათი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("көкөніс салаты"),
            keywords: &["жасыл", "көкөніс", "көкөніс салаты", "салат", "тағам"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("grøn salat"),
            keywords: &["grøn", "mad", "salat"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បន\u{17d2}លែបៃតង"),
            keywords: &["បន\u{17d2}លែបៃតង", "បៃតង", "សាលាដ", "អាហារ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ತರಕಾರ\u{cbf} ಸಲಾಡ\u{ccd}"),
            keywords: &["ಆಹಾರ", "ತರಕಾರ\u{cbf}", "ಸಲಾಡ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("야채샐러드"),
            keywords: &["건강", "샐러드", "야채", "야채샐러드", "채소"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पाचवो सलाद"),
            keywords: &["अन\u{94d}न", "पाचवो", "सलाद"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жашылча салаты"),
            keywords: &["жашылча", "жашылча салаты", "салат", "тамак"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("gréng Zalot"),
            keywords: &["Iessen", "Zalot", "gréng"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສະລ\u{eb1}ດຂຽວ"),
            keywords: &["ຂຽວ", "ສະລ\u{eb1}ດ", "ສະລ\u{eb1}ດຂຽວ", "ອາຫານ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žalios salotos"),
            keywords: &["maistas", "salotos", "žalios"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zaļie salāti"),
            keywords: &["salāti", "zaļi", "zaļie salāti", "ēdiens"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("huamata kākāriki"),
            keywords: &["huamata", "kai", "kākāriki"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("зелена салата"),
            keywords: &["зелена", "салата", "храна"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഗ\u{d4d}രീൻ സ\u{d3e}ലഡ\u{d4d}"),
            keywords: &[
                "ഗ\u{d4d}രീൻ സ\u{d3e}ലഡ\u{d4d}",
                "പച\u{d4d}ചക\u{d4d}കറി",
                "ഭക\u{d4d}ഷണം",
                "സ\u{d3e}ലഡ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ногооны салат"),
            keywords: &["ногоон", "ногооны салат", "салад", "хүнс"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("हिरवा सलाद"),
            keywords: &["खाद\u{94d}य", "सलाद", "हिरवा सलाद", "हिरव\u{947}"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("salad hijau"),
            keywords: &["hijau", "makanan", "salad"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("insalata ħadra"),
            keywords: &["ikel", "insalata", "ħadra"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အရ\u{103d}က\u{103a}သ\u{102f}ပ\u{103a}"),
            keywords: &[
                "အစားအသောက\u{103a}",
                "အရ\u{103d}က\u{103a}စ\u{102d}မ\u{103a}း",
                "အရ\u{103d}က\u{103a}သ\u{102f}ပ\u{103a}",
                "အသ\u{102f}ပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("grønn salat"),
            keywords: &["grønn", "mat", "salat"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("हरियो सलाद"),
            keywords: &["खाना", "सलाद", "हरियो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("groene salade"),
            keywords: &["groen", "groene salade", "salade", "voedsel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("grøn salat"),
            keywords: &["grøn", "mat", "salat"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସବ\u{b41}ଜ ସ\u{b3e}ଲ\u{b3e}ଡ\u{b4d}"),
            keywords: &[
                "ସବ\u{b41}ଜ । ସ\u{b3e}ଲ\u{b3e}ଡ । ଖ\u{b3e}ଦ\u{b4d}ୟ",
                "ସବ\u{b41}ଜ ସ\u{b3e}ଲ\u{b3e}ଡ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਹਰਾ ਸਲਾਦ"),
            keywords: &["ਭ\u{a4b}ਜਨ", "ਸਲਾਦ", "ਹਰਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہرا سلاد"),
            keywords: &["خوراک", "سلاد", "ہرا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Grín Salad"),
            keywords: &["Fud", "Grin", "Grín Salad", "Salad"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("sałatka"),
            keywords: &["jedzenie", "sałata", "sałatka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شنه سلاد"),
            keywords: &["شنه سلاد"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("salada verde"),
            keywords: &["comida", "salada", "verde"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("salada"),
            keywords: &["alface", "comida", "salada", "verdura"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("qʼumir ensalada"),
            keywords: &["ensalada", "mikhuna", "qʼumir ensalada", "q’umir"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("salată verde"),
            keywords: &["mâncare", "salată", "verde"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1075"),
            keywords: &["E10-1075"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("овощной салат"),
            keywords: &["еда", "овощи", "овощной салат", "салат"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("salade y’imboga"),
            keywords: &["ibiribwa", "icyatsi", "salade", "salade y’imboga"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سائو سلاد"),
            keywords: &["سائو سلاد", "سائو، سلاد، کاڌو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කොළ සල\u{dcf}දය"),
            keywords: &["කෑම", "කොළ", "සල\u{dcf}දය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("šalát"),
            keywords: &["jedlo", "zelený", "šalát"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zelena solata"),
            keywords: &["hrana", "solata", "zelena"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("anslaata cagaaran"),
            keywords: &["ansalaata", "anslaata cagaaran", "cagaar", "cunto"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("sallatë e gjelbër"),
            keywords: &[
                "e gjelbër",
                "perime",
                "sallatë",
                "sallatë e gjelbër",
                "ushqime",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("зелена салата"),
            keywords: &["здраво", "зелена салата", "зелено", "салата", "храна"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("zelena salata"),
            keywords: &["hrana", "salata", "zdravo", "zelena salata", "zeleno"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("grönsallad"),
            keywords: &["grön", "grönsallad", "mat", "sallad"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kachumbari"),
            keywords: &["chakula", "kachumbari", "saladi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ச\u{bbe}லட\u{bcd}"),
            keywords: &["உணவு", "ச\u{bbe}லட\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("గ\u{c4d}ర\u{c40}న\u{c4d} సల\u{c3e}డ\u{c4d}"),
            keywords: &[
                "ఆహ\u{c3e}రం",
                "గ\u{c4d}ర\u{c40}న\u{c4d}",
                "సల\u{c3e}డ\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("хӯриши сабз"),
            keywords: &["сабз", "хӯриш", "хӯриши сабз", "ғизо"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("สล\u{e31}ด"),
            keywords: &[
                "คล\u{e35}น",
                "ผ\u{e31}ก",
                "สล\u{e31}ด",
                "อาหาร",
                "ไดเอ\u{e47}ท",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýaşyl işdäaçar"),
            keywords: &["iýmit", "işdäaçar", "ýaşyl"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("salati"),
            keywords: &["salati"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yeşil salata"),
            keywords: &["salata", "yeşil", "yiyecek"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يېشىل سالات"),
            keywords: &["سالات", "يېشىل", "يېمەكلىك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("зелений салат"),
            keywords: &["зелений", "салат", "їжа"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سبز سلاد"),
            keywords: &["خوراک", "سبز", "سلاد"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("sabzavotli salat"),
            keywords: &["koʻkat", "sabzavotli salat", "salat", "taom"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("salad rau xanh"),
            keywords: &["salad", "salad rau xanh", "thức ăn", "xanh"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("salaad bu wert"),
            keywords: &["lekk", "salaad bu wert", "salaat", "wert"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isaladi eluhlaza"),
            keywords: &["isaladi", "isaladi eluhlaza", "luhlaza", "ukutya"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Saladi Elewe"),
            keywords: &["Saladi Elewe", "eléwé", "sàláádì", "ónjẹ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("蔬菜沙律"),
            keywords: &["沙律", "蔬菜", "蔬菜沙律", "食物"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("蔬菜沙律"),
            keywords: &["沙律", "蔬菜", "蔬菜沙律", "食物"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("绿色沙拉"),
            keywords: &["沙拉", "绿色沙拉", "食物"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("生菜沙拉"),
            keywords: &["沙拉", "生菜", "生菜沙拉"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("生菜沙律"),
            keywords: &["沙律", "生菜沙律", "蔬菜沙律"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isaladi lasengadini"),
            keywords: &["hlaza", "isaladi", "isaladi lasengadini", "ukudla"],
        },
    ],
};
#[doc = "🍿"]
pub const POPCORN: crate::Emoji = crate::Emoji {
    glyph: "🍿",
    codepoint: "1F37F",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "popcorn",
    group: "Food & Drink",
    subgroup: "food-prepared",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("springmielies"),
            keywords: &["fliek", "springmielies"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ፈንድሻ"),
            keywords: &["ፈንድሻ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("فشار"),
            keywords: &["ذرة", "فشار", "فيشار"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("পপকৰ\u{9cd}ণ"),
            keywords: &["পপকৰ\u{9cd}ণ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("popkorn"),
            keywords: &["popkorn"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("папкорн"),
            keywords: &["папкорн"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("пуканки"),
            keywords: &["пуканки"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("পপকর\u{9cd}ণ"),
            keywords: &["পপকর\u{9cd}ণ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("popcorn"),
            keywords: &["popcorn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kokice"),
            keywords: &["kokice"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("crispetes"),
            keywords: &["blat de moro", "crispetes"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏎᎷ ᎠᏔᏍᎩᏍᎩ"),
            keywords: &["ᏎᎷ ᎠᏔᏍᎩᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("popcorn"),
            keywords: &[
                "popcorn",
                "popkorn",
                "pražená kukuřice",
                "pukance",
                "pukánky",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("popgorn"),
            keywords: &["popgorn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("popcorn"),
            keywords: &["popcorn"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Popcorn"),
            keywords: &["Popcorn", "Snack"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ποπ-κορν"),
            keywords: &["ποπ κορν", "ποπ-κορν"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("popcorn"),
            keywords: &["popcorn"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("palomitas"),
            keywords: &["maíz", "palomitas"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("palomitas de maíz"),
            keywords: &["cine", "maíz", "palomitas", "palomitas de maíz", "pochoclo"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("popkorn"),
            keywords: &["mais", "popkorn"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("krispetak"),
            keywords: &["krispeta", "krispetak"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ذرت بوداده"),
            keywords: &["بوداده", "ذرت", "پاپ کرن"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("popcorn"),
            keywords: &["maissi", "popcorn"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("popcorn"),
            keywords: &["chichirya", "pagkain", "popcorn"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("poppkorn"),
            keywords: &["matur", "poppkorn"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("pop-corn"),
            keywords: &["pop-corn"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("popcorn"),
            keywords: &["pop-corn", "popcorn"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("grán rósta"),
            keywords: &["grán rósta"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("popcorn"),
            keywords: &["popcorn"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("flocos de millo"),
            keywords: &["flocos", "flocos de millo", "millo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પૉપકોર\u{acd}ન"),
            keywords: &["પૉપકોર\u{acd}ન", "મકાઈના શ\u{ac7}ક\u{ac7}લા દાણા"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("gugguru"),
            keywords: &["gugguru"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פופקורן"),
            keywords: &["סרט", "פופקורן", "קולנוע"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पॉपकॉर\u{94d}न"),
            keywords: &["पॉपकॉर\u{94d}न"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kokice"),
            keywords: &["kokice"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("pattogatott kukorica"),
            keywords: &["kukorica", "pattogatott kukorica"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ադիբուդի"),
            keywords: &["ադիբուդի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("popcorn"),
            keywords: &["berondong", "jagung", "popcorn"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọkà"),
            keywords: &["ọkà"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("popp"),
            keywords: &["popp"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("popcorn"),
            keywords: &["cinema", "mais", "popcorn"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ポップコーン"),
            keywords: &["お菓子", "ポップコーン"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("brondong jagung"),
            keywords: &["brondong jagung"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბატი-ბუტი"),
            keywords: &["ბატი-ბუტი", "პოპკორნი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("попкорн"),
            keywords: &["попкорн"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("popcorn"),
            keywords: &["popcorn"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ពោតល\u{17b8}ងម\u{17bd}យប\u{17d2}រអប\u{17cb}"),
            keywords: &[
                "ពោតល\u{17b8}ង",
                "ពោតល\u{17b8}ងម\u{17bd}យប\u{17d2}រអប\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪಾಪ\u{ccd}\u{200c}ಕಾರ\u{ccd}ನ\u{ccd}"),
            keywords: &["ಜೋಳದ ಅರಳು", "ಪಾಪ\u{ccd}\u{200c}ಕಾರ\u{ccd}ನ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("팝콘"),
            keywords: &["영화", "팝콘"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पॉपकॉर\u{94d}न"),
            keywords: &["पॉपकॉर\u{94d}न"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("попкорн"),
            keywords: &["попкорн"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Popcorn"),
            keywords: &["Popcorn"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{eb1}ອບຄອນ"),
            keywords: &["ປ\u{eb1}ອບຄອນ", "ສາລ\u{eb5}ຂ\u{ebb}\u{ec9}ວ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("spragėsiai"),
            keywords: &["spragėsiai"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("popkorns"),
            keywords: &["kukurūza", "popkorns"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kāngapahū"),
            keywords: &["kāngapahū"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("пуканки"),
            keywords: &["пуканки", "пченка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പോപ\u{d4d}\u{200c}കോൺ"),
            keywords: &["പോപ\u{d4d}\u{200c}കോൺ", "ലഘ\u{d41}ഭക\u{d4d}ഷണം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("попкорн"),
            keywords: &["попкорн"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पॉपकॉर\u{94d}न"),
            keywords: &["पॉपकॉर\u{94d}न"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bertih jagung"),
            keywords: &["bertih jagung"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("popcorn"),
            keywords: &["popcorn"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပြောင\u{103a}းဖ\u{1030}းပေါက\u{103a}ပေါက\u{103a}"),
            keywords: &["ပြောင\u{103a}းဖ\u{1030}းပေါက\u{103a}ပေါက\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("popkorn"),
            keywords: &["kino", "popcorn", "popkorn"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पपकर\u{94d}न"),
            keywords: &["पपकर\u{94d}न"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("popcorn"),
            keywords: &["popcorn"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("popkorn"),
            keywords: &["kino", "popcorn", "popkorn"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପପକର\u{b4d}ନ\u{b4d}\u{200c}"),
            keywords: &["ପପକର\u{b4d}ନ\u{b4d}\u{200c}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਖਿ\u{a71}ਲਾ\u{a02}"),
            keywords: &[
                "ਖਿ\u{a71}ਲਾ\u{a02}",
                "ਫ\u{a41}\u{a71}ਲ\u{a47}",
                "ਮ\u{a71}ਕੀ ਦ\u{a47} ਦਾਣ\u{a47}",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پھولے"),
            keywords: &["پھولے"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pọ\u{301}pkọn"),
            keywords: &["Pọ\u{301}pkọn"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("popcorn"),
            keywords: &["popcorn"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د جوارونينې"),
            keywords: &["د جوارونينې"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pipoca"),
            keywords: &["balde de pipoca", "pipoca", "pipoca de cinema"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("pipocas"),
            keywords: &["balde de pipoca", "pipoca de cinema", "pipocas"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("palomitas de maiz"),
            keywords: &["palomitas de maiz"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("floricele de porumb"),
            keywords: &[
                "floricele",
                "floricele de porumb",
                "pop-corn",
                "popcorn",
                "porumb",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-324"),
            keywords: &["E10-324"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("попкорн"),
            keywords: &["кукуруза", "попкорн", "стакан"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("injugu"),
            keywords: &["injugu"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مڪئي جا ڦلا"),
            keywords: &["مڪئي جا ڦلا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පොර\u{dd2}"),
            keywords: &["පොර\u{dd2}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("pukance"),
            keywords: &["popcorn", "pukance"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("pokovka"),
            keywords: &["kokice", "pokovka"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("salool"),
            keywords: &["salool"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kokoshka"),
            keywords: &["kokoshka"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кокице"),
            keywords: &["кокице"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kokice"),
            keywords: &["kokice"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("popcorn"),
            keywords: &["bio", "popcorn", "snacks"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("bisi"),
            keywords: &["bisi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ப\u{bbe}ப\u{bcd} க\u{bbe}ரன\u{bcd}"),
            keywords: &[
                "ப\u{bbe}ப\u{bcd} க\u{bbe}ரன\u{bcd}",
                "பொருட\u{bcd}க\u{bbe}ட\u{bcd}சி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c3e}ప\u{c4d}\u{200c}క\u{c3e}ర\u{c4d}న\u{c4d}"),
            keywords: &[
                "ప\u{c3e}ప\u{c4d}\u{200c}క\u{c3e}ర\u{c4d}న\u{c4d}",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҷуворипақак"),
            keywords: &["ҷуворипақак"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ป\u{e4a}อปคอร\u{e4c}น"),
            keywords: &["ข\u{e49}าวโพดค\u{e31}\u{e48}ว", "ป\u{e4a}อปคอร\u{e4c}น"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("patrak"),
            keywords: &["patrak"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("koane fakapaku"),
            keywords: &["koane fakapaku"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("patlamış mısır"),
            keywords: &["mısır", "patlamış mısır"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئېتىلدۇرما"),
            keywords: &["ئېتىلدۇرما"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("попкорн"),
            keywords: &["попкорн"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پاپ کارن"),
            keywords: &["اسنیک", "پاپ کارن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("popkorn"),
            keywords: &["popkorn"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bỏng ngô"),
            keywords: &["bỏng ngô"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("pop korn"),
            keywords: &["pop korn"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umbona oqhashumbayo"),
            keywords: &["umbona oqhashumbayo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Gúgúrú"),
            keywords: &["Gúgúrú"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("爆谷"),
            keywords: &["爆谷"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("爆谷"),
            keywords: &["爆谷"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("爆米花"),
            keywords: &["爆米花"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("爆米花"),
            keywords: &["爆米花"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("爆谷"),
            keywords: &["爆谷"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphophukhoni"),
            keywords: &["uphophukhoni"],
        },
    ],
};
#[doc = "🧈"]
pub const BUTTER: crate::Emoji = crate::Emoji {
    glyph: "🧈",
    codepoint: "1F9C8",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "butter",
    group: "Food & Drink",
    subgroup: "food-prepared",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("botter"),
            keywords: &["botter", "suiwel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቅቤ"),
            keywords: &["ቅቤ", "የወተት ምርት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("زبد"),
            keywords: &["ألبان", "زبد", "منتجات ألبان"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ম\u{9be}খন"),
            keywords: &["দ\u{9c1}গ\u{9cd}ধজ\u{9be}ত", "ম\u{9be}খন"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kərə yağı"),
            keywords: &["kərə yağı", "süd məhsulu"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("масла"),
            keywords: &["малочны прадукт", "масла"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("масло"),
            keywords: &["масло", "млечни продукти"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9be}খন"),
            keywords: &["ডেয\u{9bc}\u{9be}রি", "ম\u{9be}খন"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("amann"),
            keywords: &["amann", "boued-laezh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("puter"),
            keywords: &["mliječni proizvodi", "puter"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("mantega"),
            keywords: &["mantega", "producte lacti"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎪᏢᎾ"),
            keywords: &["ᎤᏅᏗᎢ", "ᎪᏢᎾ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("máslo"),
            keywords: &["mlékařské", "mlékárenské", "mlékárna", "mléčné", "máslo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("menyn"),
            keywords: &["cynnyrch llaeth", "menyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("smør"),
            keywords: &["mejeriprodukt", "smør"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Butter"),
            keywords: &["Butter", "Milchprodukt"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("βούτυρο"),
            keywords: &["βούτυρο", "γαλακτοκομικά"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("butter"),
            keywords: &["butter", "dairy"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("mantequilla"),
            keywords: &["lácteo", "mantequilla"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("või"),
            keywords: &["piimatoode", "või"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gurina"),
            keywords: &["esnekia", "gurina"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کره"),
            keywords: &["لبنیات", "کره"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("voi"),
            keywords: &["maitotuote", "voi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mantikilya"),
            keywords: &["dairy", "mantikilya", "produktong gawa sa gatas"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("smør"),
            keywords: &["matur", "mjólk", "mjólkarvirki", "rómi", "smør"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("beurre"),
            keywords: &["beurre", "gras", "produit laitier"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["beurre", "produit laitier"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("im"),
            keywords: &["déiríocht", "im"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ìm"),
            keywords: &[
                "bainne",
                "bathar-bainne",
                "biadh-bainne",
                "bà",
                "bò",
                "ìm",
                "ùrachd na bà",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("manteiga"),
            keywords: &["almorzo", "manteiga", "margarina", "torrada"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("માખણ"),
            keywords: &["ડ\u{ac7}રી", "માખણ"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חמאה"),
            keywords: &["חמאה", "מוצרי חלב"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("मक\u{94d}खन"),
            keywords: &["द\u{942}ध स\u{947} बन\u{947} पदार\u{94d}थ", "मक\u{94d}खन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("maslac"),
            keywords: &["maslac", "mliječni", "proizvod"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("vaj"),
            keywords: &["tejtermék", "vaj"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կարագ"),
            keywords: &["կաթնամթերք", "կարագ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("mentega"),
            keywords: &["mentega", "produk susu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("smjör"),
            keywords: &["mjólkurvara", "smjör"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("burro"),
            keywords: &["burro", "latticini", "latticino"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("バター"),
            keywords: &["バター", "乳製品"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("mertega"),
            keywords: &["mertega", "olahan susu"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კარაქი"),
            keywords: &["კარაქი", "რძის ნაწარმი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сары май"),
            keywords: &["майжуаз", "сары май"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17ba}រ"),
            keywords: &[
                "ប\u{17ba}រ",
                "ប\u{17d2}រភេទអាហារដែល\u{200b}ធ\u{17d2}វើព\u{17b8}ទ\u{17b9}កដោះគោ ឬក\u{17d2}រែម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{cc6}ಣ\u{ccd}ಣ\u{cc6}"),
            keywords: &["ಡೈರ\u{cbf}", "ಬ\u{cc6}ಣ\u{ccd}ಣ\u{cc6}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("버터"),
            keywords: &["버터", "유제품"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("लोणी"),
            keywords: &["ड\u{947}अरी", "बटर", "लोणी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("май"),
            keywords: &["май", "сүт азыктары"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເນ\u{eb5}ຍ"),
            keywords: &[
                "ຜະ\u{200b}ລ\u{eb4}ດ\u{200b}ຕະ\u{200b}ພ\u{eb1}ນ\u{200b}ຈາກ\u{200b}ນ\u{ebb}ມ",
                "ເນ\u{eb5}ຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("sviestas"),
            keywords: &["pieno produktas", "sviestas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sviests"),
            keywords: &["piena produkti", "sviests"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("путер"),
            keywords: &["млечен производ", "путер"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ബട\u{d4d}ടർ"),
            keywords: &["പ\u{d3e}ല\u{d41}ൽപ\u{d4d}പന\u{d4d}നം", "ബട\u{d4d}ടർ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цөцгийн тос"),
            keywords: &["цагаан идээ", "цөцгийн тос"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("लोणी"),
            keywords: &["ड\u{947}अरी", "लोणी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("mentega"),
            keywords: &["mentega", "tenusu"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ထောပတ\u{103a}"),
            keywords: &[
                "ထောပတ\u{103a}",
                "န\u{102d}\u{102f}\u{1037}ထ\u{103d}က\u{103a}ပစ\u{1039}စည\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("smør"),
            keywords: &["meieriprodukt", "smør"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बट\u{94d}टर"),
            keywords: &["ड\u{947}री", "बट\u{94d}टर"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("boter"),
            keywords: &["boter", "zuivel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("smør"),
            keywords: &["meieriprodukt", "smør"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଲହ\u{b41}ଣୀ"),
            keywords: &["ଦ\u{b41}ଗ\u{b4d}ଧ", "ଲହ\u{b41}ଣୀ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a71}ਖਣ"),
            keywords: &["ਡ\u{a47}ਅਰੀ", "ਮ\u{a71}ਖਣ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bọ\u{301}ta"),
            keywords: &["Bọ\u{301}ta", "Deari"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("masło"),
            keywords: &["masło", "nabiał"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کوچ"),
            keywords: &["لبنيات", "کوچ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("manteiga"),
            keywords: &["laticínio", "manteiga"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("mantequilla"),
            keywords: &["lecheria", "mantequilla"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("unt"),
            keywords: &["lactate", "unt"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–047"),
            keywords: &["E12–047"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("масло"),
            keywords: &[
                "масленка",
                "масло",
                "масляный",
                "молокопродукты",
                "молочный",
                "сливки",
                "сливочное",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مکڻ"),
            keywords: &["مکڻ", "ڊيري"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බටර\u{dca}"),
            keywords: &["ක\u{dd2}ර\u{dd2}", "බටර\u{dca}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("maslo"),
            keywords: &["maslo", "mliekarenské", "mliekareň", "mliečne"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("maslo"),
            keywords: &["maslo", "mlečni izdelek", "mlečno"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("subag"),
            keywords: &["caano", "subag"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gjalpë"),
            keywords: &["gjalpë", "qumështore"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("путер"),
            keywords: &["млечни производи", "путер"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["путер"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("puter"),
            keywords: &["mlečni proizvodi", "puter"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["puter"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("smör"),
            keywords: &["mjölkprodukt", "smör"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("siagi"),
            keywords: &["bidhaa ya maziwa", "siagi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வெண\u{bcd}ணெய\u{bcd}"),
            keywords: &[
                "ப\u{bbe}ல\u{bcd} பொருட\u{bcd}கள\u{bcd}",
                "வெண\u{bcd}ணெய\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వ\u{c46}న\u{c4d}న"),
            keywords: &["ప\u{c3e}ల ఉత\u{c4d}పత\u{c4d}తులు", "వ\u{c46}న\u{c4d}న"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เนย"),
            keywords: &["ผล\u{e34}ตภ\u{e31}ณฑ\u{e4c}นม", "เนย"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("mesge"),
            keywords: &["mesge", "süýt önümleri"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pata"),
            keywords: &["pata"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("tereyağı"),
            keywords: &["süt ürünü", "tereyağı"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("масло"),
            keywords: &["масло", "молочні продукти"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مکھن"),
            keywords: &["مکھن", "ڈیری"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("sariyogʻ"),
            keywords: &["qaymoq", "sariyogʻ", "sut mahsulotlari", "yogʻ"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bơ"),
            keywords: &["bơ", "bơ sữa"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("牛油"),
            keywords: &["乳製品", "牛油"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("牛油"),
            keywords: &["乳制品", "牛油"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("黄油"),
            keywords: &["乳制品", "牛奶", "黄油"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("奶油"),
            keywords: &["乳製品", "奶油"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("牛油"),
            keywords: &["乳製品", "牛油"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhatha"),
            keywords: &["ibhatha", "okwebisi"],
        },
    ],
};
#[doc = "🧂"]
pub const SALT: crate::Emoji = crate::Emoji {
    glyph: "🧂",
    codepoint: "1F9C2",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "salt",
    group: "Food & Drink",
    subgroup: "food-prepared",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("sout"),
            keywords: &["pot", "sout", "soutpot", "speserye", "speserypot"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጨው"),
            keywords: &["መወዝወዣ", "ቅመም", "ጨው"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ملح"),
            keywords: &["توابل", "رشاشة ملح", "ملح", "مملحة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("নিমখ"),
            keywords: &["আচ\u{9be}ৰ", "নিমখ", "মিশ\u{9cd}ৰপ\u{9be}ত\u{9cd}ৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("duz"),
            keywords: &["duz", "duzqabı", "ədviyyat"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("соль"),
            keywords: &["прыправы", "сальніца", "соль"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("сол"),
            keywords: &["подправка", "сол", "солница"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("লবণ"),
            keywords: &["আচ\u{9be}র", "লবণ", "শেক\u{9be}র"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("holen"),
            keywords: &["holen", "temz-boued"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("so"),
            keywords: &["slanik", "so", "začin"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("sal"),
            keywords: &["condiment", "sal", "saler"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎹ"),
            keywords: &["ᎠᎹ", "ᎠᏖᎸᏗ", "ᏧᏓᎴᏅᏓ ᏗᏆᏲᏙᏓ ᎥᏓᏍᏓᏴᎲᏍᎬᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("sůl"),
            keywords: &["přísada", "slánka", "sůl"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("halen"),
            keywords: &["condiment", "halen", "siglwr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("salt"),
            keywords: &["krydderi", "salt", "saltbøsse"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Salz"),
            keywords: &["Geschmack", "Salz", "Salzstreuer"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αλάτι"),
            keywords: &["αλάτι", "αλατιέρα", "μπαχαρικό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("salt"),
            keywords: &["condiment", "salt", "shaker"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("sal"),
            keywords: &["condimento", "sal", "salero"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("sal"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("sal"),
            keywords: &["sal"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("sool"),
            keywords: &["maitseaine", "sool", "soolatoos"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gatz"),
            keywords: &["gatz", "gatzontzi", "ongailu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نمک"),
            keywords: &["ادویه", "نمک", "نمک\u{200c}پاش", "چاشنی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("suola"),
            keywords: &["mauste", "sirotin", "suola", "suolasirotin"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("asin"),
            keywords: &["asin", "condiment", "shaker"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("salt"),
            keywords: &["krydd", "salt", "saltílat"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("sel"),
            keywords: &["condiment", "salière", "sel"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["condiment", "mélangeur", "sel"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("salann"),
            keywords: &["blastán", "croiteoir", "salann"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("salainn"),
            keywords: &[
                "abhlan",
                "alltann",
                "annlann",
                "anntann",
                "crathadair",
                "salainn",
                "spìos",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("sal"),
            keywords: &["condimento", "sal", "saleiro", "salgar"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મીઠ\u{ac1}\u{a82}"),
            keywords: &["મસાલાની ડબી", "મસાલો", "મીઠ\u{ac1}\u{a82}"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מלח"),
            keywords: &["מלח", "תבלין", "תבלינים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("नमक"),
            keywords: &["नमक", "मसाला", "श\u{947}कर"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("sol"),
            keywords: &["sol", "soljenka", "začin"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("só"),
            keywords: &["fűszer", "só", "sószóró"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("աղ"),
            keywords: &["աղ", "համեմունք", "հավելում"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("garam"),
            keywords: &["bumbu", "garam", "wadah garam"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("salt"),
            keywords: &["krydd", "salt", "saltstaukur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("sale"),
            keywords: &["condimento", "sale", "saliera"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("塩"),
            keywords: &["塩", "振りかけ容器", "薬味", "調味料"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("uyah"),
            keywords: &["ubarampe", "uyah", "wadhah nyawur uyah"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მარილი"),
            keywords: &["მარილი", "სუნელები"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тұз"),
            keywords: &["тұз", "тұздық", "шайқағыш"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("អ\u{17c6}ប\u{17b7}ល"),
            keywords: &[
                "ក\u{17c6}ប\u{17c9}\u{17bb}ងដាក\u{17cb}គ\u{17d2}រឿងទេស",
                "គ\u{17d2}រឿងផ\u{17d2}ស\u{17c6}រសជាត\u{17b7}",
                "អ\u{17c6}ប\u{17b7}ល",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಉಪ\u{ccd}ಪು"),
            keywords: &["ಉಪ\u{ccd}ಪು", "ಕಾಂಡ\u{cbf}ಮ\u{cc6}ಂಟ\u{ccd}", "ಶೇಕರ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("소금"),
            keywords: &["소금", "양념통", "조미료"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मीठ"),
            keywords: &["मसालो", "मीठ", "श\u{947}कर"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("туз"),
            keywords: &["аралаштыргыч", "татымал", "туз"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເກ\u{eb7}ອ"),
            keywords: &[
                "ນ\u{ecd}\u{ec9}າປ\u{eb1}\u{ec8}ນ",
                "ເກ\u{eb7}ອ",
                "ເຄ\u{eb7}\u{ec8}ອງປ\u{eb8}ງອາຫານ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("druska"),
            keywords: &["druska", "druskinė", "prieskonis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sāls"),
            keywords: &["garšviela", "sāls", "trauciņš"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("сол"),
            keywords: &["зачин", "сол", "соларник"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഉപ\u{d4d}പ\u{d4d}"),
            keywords: &["ഉപ\u{d4d}പ\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("давс"),
            keywords: &["давс", "сэгсрэгч", "хоол амтлагч"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मीठ"),
            keywords: &["मसाला", "मिरप\u{942}ड", "मीठ"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("garam"),
            keywords: &["garam", "penggoncang", "perasa"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဆား"),
            keywords: &[
                "ဆား",
                "ဟင\u{103a}းခတ\u{103a}မ\u{103e}\u{102f}န\u{1037}\u{103a}",
                "ဟင\u{103a}းခတ\u{103a}မ\u{103e}\u{102f}န\u{1037}\u{103a} ဘ\u{1030}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("salt"),
            keywords: &["bøsse", "krydder", "salt"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("न\u{941}न"),
            keywords: &["कन\u{94d}डिम\u{947}न\u{94d}ट", "न\u{941}न", "श\u{947}कर"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("zout"),
            keywords: &["tafelzout", "zout", "zoutvaatje"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("salt"),
            keywords: &["bøsse", "krydder", "salt"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଲ\u{b41}ଣ"),
            keywords: &["ମସଲ\u{b3e}", "ଲ\u{b41}ଣ", "ଶେକର\u{b4d}\u{200c}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਨਮਕ"),
            keywords: &["ਨਮਕ", "ਨਮਕਦਾਨ", "ਮਸਾਲਾ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Sọlt"),
            keywords: &[
                "Shéka: Kọnténa Wé Dẹm De Pút Fúd Tins Laik Sọlt ọ Pẹ\u{301}pẹ Ínsaid",
                "Sọlt",
                "Tins Wé Dẹm De Ték Mék Fud Swit",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("sól"),
            keywords: &["przyprawa", "solniczka", "sól"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مالګه"),
            keywords: &["مالګه", "مساله، مالګه، شيکر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("sal"),
            keywords: &["condimento", "sal", "saleiro"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("kachi"),
            keywords: &["condimento", "kachi", "shaker"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("sare"),
            keywords: &["condiment", "sare", "solniță"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-048"),
            keywords: &["E11-048"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("солонка"),
            keywords: &["морская соль", "солонка", "соль"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("لوڻ"),
            keywords: &["شيڪر", "لوڻ", "ڪنڊيمينٽ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ල\u{dd4}ණ\u{dd4}"),
            keywords: &["ත\u{dd4}නපහ", "ල\u{dd4}ණ\u{dd4}", "ෂේකර\u{dca}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("soľ"),
            keywords: &["ochutiť", "soľ", "soľnička"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("sol"),
            keywords: &["sol", "solnica", "začimba"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("cusbo"),
            keywords: &["cusbo", "ruxaha", "walxaha cusbada"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kripë"),
            keywords: &["erëza", "kripë", "përzierje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("со"),
            keywords: &["сланик", "со"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("so"),
            keywords: &["slanik", "so"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("salt"),
            keywords: &["krydda", "salt", "saltkar"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("chumvi"),
            keywords: &["chumvi", "kidau", "pilipili"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("உப\u{bcd}பு"),
            keywords: &["உப\u{bcd}பு", "சுவையூட\u{bcd}டி", "ஷேக\u{bcd}கர\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఉప\u{c4d}పు"),
            keywords: &["ఉప\u{c4d}పు", "మస\u{c3e}ల\u{c3e}", "ష\u{c47}కర\u{c4d}"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เกล\u{e37}อ"),
            keywords: &[
                "ขวดเกล\u{e37}อ",
                "เกล\u{e37}อ",
                "เคร\u{e37}\u{e48}องปร\u{e38}ง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("duz"),
            keywords: &["duz", "goşundy", "şeýker"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("masima"),
            keywords: &["masima"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("tuz"),
            keywords: &["tuz", "tuzluk", "çeşni"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("сіль"),
            keywords: &["приправа", "сольничка", "сіль", "сільниця", "сільничка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("نمک"),
            keywords: &["مصالحہ", "نمک", "نمک دانی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tuzdon"),
            keywords: &["dengiz tuzi", "tuz", "tuzdon", "tuzluq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("muối"),
            keywords: &["bình lắc", "gia vị", "muối"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("鹽"),
            keywords: &["調味料", "鹽", "鹽樽"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("盐"),
            keywords: &["盐", "盐樽", "调味料"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("盐"),
            keywords: &["佐料瓶", "盐", "调味品"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("鹽"),
            keywords: &["調味品", "調味瓶", "鹽"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["調味料", "調味瓶", "鹽"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("salt"),
            keywords: &["condiment", "salt", "shaker"],
        },
    ],
};
#[doc = "🥫"]
pub const CANNED_FOOD: crate::Emoji = crate::Emoji {
    glyph: "🥫",
    codepoint: "1F96B",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "canned food",
    group: "Food & Drink",
    subgroup: "food-prepared",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("geblikte kos"),
            keywords: &["blik", "geblikte kos"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የታሸገ ምግብ"),
            keywords: &["የታሸገ ምግብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("طعام معل\u{651}ب"),
            keywords: &["طعام معل\u{651}ب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কেনত ৰখ\u{9be} খ\u{9be}দ\u{9cd}য"),
            keywords: &["কেন", "কেনত ৰখ\u{9be} খ\u{9be}দ\u{9cd}য"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("konserv qida"),
            keywords: &["konserv", "konserv qida"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кансерваваная ежа"),
            keywords: &["кансерваваная ежа", "кансервы"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("консервирана храна"),
            keywords: &["консерва", "консервирана храна"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9cd}য\u{9be}নজ\u{9be}ত খ\u{9be}দ\u{9cd}য"),
            keywords: &[
                "ক\u{9cd}য\u{9be}ন",
                "ক\u{9cd}য\u{9be}নজ\u{9be}ত খ\u{9be}দ\u{9cd}য",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("boued-mir"),
            keywords: &["boest-mir", "boued-mir"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("konzervirana hrana"),
            keywords: &["konzerva", "konzervirana hrana"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("llauna de conserva"),
            keywords: &["conserva", "llauna", "llauna de conserva", "menjar"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏟᏔᏅᎢ ᎠᎵᏍᏓᏰᏗ"),
            keywords: &["ᎦᏟᏔᏅᎢ ᎠᎵᏍᏓᏰᏗ", "ᏔᎷᎩᏍᎩ ᎦᏟᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("jídlo v plechovce"),
            keywords: &["jídlo v plechovce", "plechovka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bwyd tun"),
            keywords: &["bwyd tun", "tun"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("konserves"),
            keywords: &["dåse", "dåsemad", "konserves"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Konserve"),
            keywords: &["Dose", "Konserve"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κονσέρβα φαγητού"),
            keywords: &["κονσέρβα", "κονσέρβα φαγητού"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("canned food"),
            keywords: &["can", "canned food"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("tinned food"),
            keywords: &["can", "canned food", "tin", "tinned food"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("canned food"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("comida enlatada"),
            keywords: &["comida enlatada", "conserva", "lata"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("toidukonserv"),
            keywords: &["konserv", "toidukonserv"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("janaria latetan"),
            keywords: &["janaria latetan", "lata"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("غذای کنسروشده"),
            keywords: &["غذای کنسروشده", "قوطی", "کنسرو"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("säilyketölkki"),
            keywords: &["purkki", "säilyketölkki"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("de-latang pagkain"),
            keywords: &["de-latang pagkain", "lata"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("dósamatur"),
            keywords: &["dós", "dósamatur", "matur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("aliments en conserve"),
            keywords: &["aliments en conserve", "conserve"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bia stánaithe"),
            keywords: &["bia", "bia stánaithe", "canna"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("biadh ann an cana"),
            keywords: &["biadh ann an cana", "cana"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("lata de comida"),
            keywords: &["comida", "enlatada", "lata", "lata de comida"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ક\u{ac7}ન\u{acd}ડ ફ\u{ac2}ડ"),
            keywords: &["ક\u{ac5}ન", "ક\u{ac7}ન\u{acd}ડ ફ\u{ac2}ડ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("abinci na gwangwani"),
            keywords: &["abinci na gwangwani", "gwangwani"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שימורים"),
            keywords: &["קופסת שימורים", "שימורים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("डिब\u{94d}बा ब\u{902}द खाद\u{94d}य सामग\u{94d}री"),
            keywords: &[
                "क\u{948}न, डिब\u{94d}बा, टिन",
                "डिब\u{94d}बा ब\u{902}द खाद\u{94d}य सामग\u{94d}री",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("konzerva"),
            keywords: &["konzerva", "limenka"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("konzerv"),
            keywords: &["konzerv", "konzervdoboz"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("պահածո"),
            keywords: &["պահածո"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("makanan kaleng"),
            keywords: &["kaleng", "makanan kaleng"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nri etinyere na kanụ\u{300}"),
            keywords: &["anụ nọ na kanụ\u{300}", "nri etinyere na kanụ\u{300}"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("dósamatur"),
            keywords: &["dós", "dósamatur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cibo in scatola"),
            keywords: &["cibo in scatola", "scatoletta"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("缶詰"),
            keywords: &["缶", "缶詰", "非常食"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("dhaharan kalengan"),
            keywords: &["dhaharan kalengan", "kaleng"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კონსერვი"),
            keywords: &["კონსერვი", "კონსერვის ქილა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қалбырдағы тағам"),
            keywords: &["қалбырдағы тағам"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("អាហារក\u{17c6}ប\u{17c9}\u{17bb}ង"),
            keywords: &[
                "ក\u{17c6}ប\u{17c9}\u{17bb}ង",
                "អាហារក\u{17c6}ប\u{17c9}\u{17bb}ង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{ccd}ಯಾನ\u{ccd} ಆಹಾರ"),
            keywords: &["ಕ\u{ccd}ಯಾನ\u{ccd}", "ಕ\u{ccd}ಯಾನ\u{ccd} ಆಹಾರ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("통조림"),
            keywords: &["캔", "통조림"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("क\u{945}नातल\u{947}\u{902} अन\u{94d}न"),
            keywords: &["क\u{945}न", "क\u{945}नातल\u{947}\u{902} अन\u{94d}न"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("консерваланган тамак"),
            keywords: &["консерва", "консерваланган тамак"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Iessen an der Béchs"),
            keywords: &["Béchs", "Iessen an der Béchs"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ອາຫານກະປ\u{ecb}ອງ"),
            keywords: &["ກະປ\u{ecb}ອງ", "ອາຫານກະປ\u{ecb}ອງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("konservai"),
            keywords: &["konservai", "skardinė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("konservi"),
            keywords: &["konservi", "konservs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kai kēne"),
            keywords: &["kai kēne", "kēne"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("конзервирана храна"),
            keywords: &["конзерва", "конзервирана храна"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ടിന\u{d4d}നിലടച\u{d4d}ച ഭക\u{d4d}ഷണം"),
            keywords: &[
                "ക\u{d4d}യ\u{d3e}ൻ",
                "ടിന\u{d4d}നിലടച\u{d4d}ച ഭക\u{d4d}ഷണം",
                "ടിൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("лаазтай хоол"),
            keywords: &["лааз", "лаазтай хоол"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("क\u{945}नमधील अन\u{94d}न"),
            keywords: &[
                "क\u{945}न",
                "क\u{945}नमधील अन\u{94d}न",
                "डबाब\u{902}द अन\u{94d}न",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("makanan tin"),
            keywords: &["makanan tin", "tin"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ikel fil-laned"),
            keywords: &["ikel fil-laned", "landa"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စည\u{103a}သ\u{103d}ပ\u{103a}အစားအစာ"),
            keywords: &["စည\u{103a}သ\u{103d}ပ\u{103a}အစားအစာ", "ဗ\u{1030}း"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hermetikk"),
            keywords: &["boks", "hermetikk", "hermetisk mat"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("टिनको बट\u{94d}टामा राखिएको खाना"),
            keywords: &["टिनको बट\u{94d}टा", "टिनको बट\u{94d}टामा राखिएको खाना"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("blikvoedsel"),
            keywords: &["blik", "blikvoedsel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("hermetikk"),
            keywords: &["boks", "hermetikk", "hermetisk mat"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଡବ\u{b3e} ଖ\u{b3e}ଦ\u{b4d}ୟ"),
            keywords: &["ଡବ\u{b3e}", "ଡବ\u{b3e} ଖ\u{b3e}ଦ\u{b4d}ୟ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਡ\u{a71}ਬਾਬ\u{a70}ਦ ਭ\u{a4b}ਜਨ"),
            keywords: &["ਡ\u{a71}ਬਾ", "ਡ\u{a71}ਬਾਬ\u{a70}ਦ ਭ\u{a4b}ਜਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کین کیتی خوراک"),
            keywords: &["کر سکنا", "کین کیتی خوراک"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kán Fud"),
            keywords: &["Kan", "Kán Fud", "Kọnténa"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("jedzenie w puszce"),
            keywords: &["jedzenie w puszce"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بند کړل شوي خواړه"),
            keywords: &["بند کړل شوي خواړه", "بند، بند کړل شوي خواړه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("comida enlatada"),
            keywords: &["comida enlatada", "lata"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["comida de lata", "comida enlatada", "lata"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("mikhuna latapi"),
            keywords: &["lata", "mikhuna latapi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("mâncare la conservă"),
            keywords: &["conservă", "mâncare la conservă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1095"),
            keywords: &["E10-1095"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("консервы"),
            keywords: &["банка", "жестянка", "консервная банка", "консервы"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibiryo byo mu bikopo"),
            keywords: &["ibiryo byo mu bikopo", "umucyebe"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڏٻي وارو کاڌو"),
            keywords: &["ڏٻو", "ڏٻي وارو کاڌو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ට\u{dd2}න\u{dca} කළ ආහ\u{dcf}ර"),
            keywords: &["ට\u{dd2}න\u{dca}", "ට\u{dd2}න\u{dca} කළ ආහ\u{dcf}ර"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("konzerva"),
            keywords: &["konzerva", "plechovka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("konzervirana hrana"),
            keywords: &["konzervirana hrana"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("cunno qasacadaysan"),
            keywords: &["cunno qasacadaysan", "qasacad"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("ushqim i konservuar"),
            keywords: &["kanaçe", "kuti konserve", "ushqim i konservuar"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("конзервирана храна"),
            keywords: &["конзерва", "конзервирана храна"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("konzervirana hrana"),
            keywords: &["konzerva", "konzervirana hrana"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("konserv"),
            keywords: &["burk", "konserv", "konservburk"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("chakula kilicho koponi"),
            keywords: &["chakula kilicho koponi", "kopo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கேனில\u{bcd} அடைக\u{bcd}கப\u{bcd}பட\u{bcd}ட உணவு"),
            keywords: &[
                "உணவு",
                "கேனில\u{bcd} அடைக\u{bcd}கப\u{bcd}பட\u{bcd}ட உணவு",
                "கேன\u{bcd}",
                "பதப\u{bcd}படுத\u{bcd}திய உணவு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c4d}య\u{c3e}న\u{c4d}\u{200c}ల\u{c4b} లభ\u{c3f}ంచ\u{c47} ఆహ\u{c3e}రం"),
            keywords: &[
                "క\u{c4d}య\u{c3e}న\u{c4d}",
                "క\u{c4d}య\u{c3e}న\u{c4d}\u{200c}ల\u{c4b} లభ\u{c3f}ంచ\u{c47} ఆహ\u{c3e}రం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("маҳсулоти консервагӣ"),
            keywords: &["маҳсулоти консервагӣ", "қуттӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("อาหารกระป\u{e4b}อง"),
            keywords: &["กระป\u{e4b}อง", "อาหารกระป\u{e4b}อง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gaplanan iýmit"),
            keywords: &["gaplanan iýmit", "konserwa"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻakai kapa"),
            keywords: &["meʻakai kapa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("konserve gıda"),
            keywords: &["konserve", "konserve gıda"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قۇتىلىق يېمەكلىك"),
            keywords: &["قۇتا", "قۇتىلىق يېمەكلىك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("консерви"),
            keywords: &["банка", "консерви"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ڈبہ بند کھانا"),
            keywords: &["ڈبہ", "ڈبہ بند کھانا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("konserva"),
            keywords: &["banka", "konserva", "tunuka idish"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("thực phẩm đóng hộp"),
            keywords: &["hộp", "thực phẩm đóng hộp"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("lekk ci kanet"),
            keywords: &["kanet", "lekk ci kanet"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ukutya okusetotini"),
            keywords: &["itoti", "ukutya okusetotini"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ónjẹ inú agolo"),
            keywords: &["agolo", "ónjẹ inú agolo"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("罐頭食物"),
            keywords: &["罐頭", "罐頭食物"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("罐头食物"),
            keywords: &["罐头", "罐头食物"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("罐头食品"),
            keywords: &["罐头", "罐头食品"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("罐頭食品"),
            keywords: &["罐頭", "罐頭食品"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukudla okusekanini"),
            keywords: &["ikani", "ukudla okusekanini"],
        },
    ],
};
