#[doc = "🦀"]
pub const CRAB: crate::Emoji = crate::Emoji {
    glyph: "🦀",
    codepoint: "1F980",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "crab",
    group: "Food & Drink",
    subgroup: "food-marine",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("krap"),
            keywords: &["Kreef", "cancer", "diereriem", "krap"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሸርጣን"),
            keywords: &["ሸርጣን", "ካንሰር", "ዞዲያክ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سرطان"),
            keywords: &["برج", "سرطان"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কেকোৰ\u{9be}"),
            keywords: &["কেকোৰ\u{9be}", "কৰ\u{9cd}কট", "ৰ\u{9be}শি"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qırmızı xərçəng"),
            keywords: &["qırmızı xərçəng", "xərçəng", "zodiak"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("краб"),
            keywords: &["задыяк", "краб", "рак"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("рак"),
            keywords: &["зодиак", "зодиакален знак", "зодия", "рак"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9be}\u{981}কড\u{9bc}\u{9be}"),
            keywords: &[
                "কর\u{9cd}কট",
                "ক\u{9be}\u{981}কড\u{9bc}\u{9be}",
                "র\u{9be}শিচক\u{9cd}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("krank"),
            keywords: &["krank", "loen"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("rak"),
            keywords: &["horoskopski znak", "rak"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cranc"),
            keywords: &["Cranc", "Càncer", "cranc", "zodíac"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄇𑄋𑄢"),
            keywords: &["𑄇𑄋𑄢"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏯᏍᎦᏬᏗ"),
            keywords: &["ᎠᏓᏰᏍᎩ", "ᎤᏯᏍᎦᏬᏗ", "ᏃᏈᏏ ᏓᏟᎶᏍᏗᎲᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("krab"),
            keywords: &["krab", "rak", "zvěrokruh"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cranc"),
            keywords: &["cranc"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("krabbe"),
            keywords: &["krabbe", "krebsen", "stjernetegn"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Krebs"),
            keywords: &["Krebs", "Sternzeichen", "Tierkreis"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κάβουρας"),
            keywords: &["ζώδιο", "κάβουρας", "καρκίνος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("crab"),
            keywords: &["Cancer", "crab", "zodiac"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["crab", "crustacean", "seafood", "shellfish"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cangrejo"),
            keywords: &["animal", "cangrejo", "cáncer", "zodiaco"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["animal", "cangrejo", "crustáceo", "cáncer", "mariscos"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("krabi"),
            keywords: &["krabi", "sodiaak", "vähk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("karramarroa"),
            keywords: &["cancer", "karramarroa", "zodiako"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("خرچنگ"),
            keywords: &["برج فلکی", "خرچنگ", "زودیاک", "سرطان"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("rapu"),
            keywords: &["horoskooppi", "horoskooppimerkki", "rapu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("alimango"),
            keywords: &[
                "alimango",
                "alimasag",
                "cancer",
                "hayop",
                "lamang-dagat",
                "talangka",
                "zodiac",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("krabbi"),
            keywords: &["dýr", "havføði", "krabbi", "sjógæti", "stjørnumerki"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("crabe"),
            keywords: &["animal", "crabe"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["cancer", "crabe", "zodiaque"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("portán"),
            keywords: &["An Portán", "portán", "stoidiaca"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("crùbag"),
            keywords: &["cancer", "crùbag", "grian-chriosach", "partan"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("caranguexo"),
            keywords: &["Cáncer", "cangrexo", "caranguexo", "zodíaco"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કરચલો"),
            keywords: &["કરચલો", "કર\u{acd}ક", "રાશિ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ƙaguwa"),
            keywords: &["Cancer", "zodiac", "ƙaguwa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סרטן"),
            keywords: &["גלגל המזלות", "מזל סרטן", "סרטן"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("कर\u{94d}कट"),
            keywords: &["कर\u{94d}क राशि", "कर\u{94d}कट", "क\u{947}कड\u{93c}ा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("rak"),
            keywords: &["rak", "zodijak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("rák"),
            keywords: &["csillagjegy", "rák", "állatöv"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կրաբ"),
            keywords: &["խեցգետին", "կենդանակերպ", "կրաբ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kepiting"),
            keywords: &["cancer", "kepiting", "zodiak"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nshịkọ"),
            keywords: &["Izi", "nshịkọ", "zodịak"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("krabbi"),
            keywords: &["krabbi", "stjörnumerki"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("granchio"),
            keywords: &["cancro", "granchio", "segno zodiacale"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("カニ"),
            keywords: &["カニ", "動物", "星座"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rajungan"),
            keywords: &["Cancer", "palintangan", "rajungan", "yuyu"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კიბორჩხალა"),
            keywords: &["ზოდიაქო", "კიბორჩხალა", "კირჩხიბი", "ჰოროსკოპი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("теңіз шаяны"),
            keywords: &["зодиак", "теңіз шаяны", "шаян"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("krabbe"),
            keywords: &["krabbe", "krebsen", "stjernetegn"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ក\u{17d2}តាម"),
            keywords: &["ក\u{17d2}ដាម", "ក\u{17d2}តាម", "រាស\u{17b8}ចក\u{17d2}រ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಏಡ\u{cbf}"),
            keywords: &["ಏಡ\u{cbf}", "ಕರ\u{ccd}ಕ", "ರಾಶ\u{cbf}ಚಕ\u{ccd}ರ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("꽃게"),
            keywords: &["게", "꽃게", "크랩"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("क\u{941}ल\u{94d}ली"),
            keywords: &["कर\u{94d}करास", "क\u{941}ल\u{94d}ली", "रास"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бөйөн"),
            keywords: &["бөйөн", "зодиак"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Kriibs"),
            keywords: &["Kriibs", "Stärzeechen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກະປ\u{eb9}"),
            keywords: &["ກະປ\u{eb9}", "ສ\u{eb1}ດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("krabas"),
            keywords: &["krabas", "vėžys", "zodiakas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("krabis"),
            keywords: &["Vēzis", "krabis", "zodiaks"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pāpaka"),
            keywords: &["Cancer", "poutiriao", "pāpaka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("рак"),
            keywords: &["рак", "хороскоп"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഞണ\u{d4d}ട\u{d4d}"),
            keywords: &["ഞണ\u{d4d}ട\u{d4d}", "ര\u{d3e}ശി ചക\u{d4d}രം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хавч"),
            keywords: &["хавч", "хилэнц", "өрнийн зурхай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ख\u{947}कडा"),
            keywords: &["कर\u{94d}क", "ख\u{947}कडा", "राशी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("ketam"),
            keywords: &["cancer", "ketam", "zodiak"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("granċ"),
            keywords: &["Cancer", "granċ", "żodjaku"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကဏန\u{103a}း"),
            keywords: &[
                "ကဏန\u{103a}း",
                "ကရကဋ\u{103a}ရာသ\u{102e}",
                "ဆယ\u{1037}\u{103a}န\u{103e}စ\u{103a}ရာသ\u{102e}ခ\u{103d}င\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("krabbe"),
            keywords: &["dyr", "krabbe", "krepsen", "stjernebilde", "stjernetegn"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ग\u{902}गटा"),
            keywords: &["क\u{94d}यान\u{94d}सर", "ग\u{902}गटा", "राशि"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("krab"),
            keywords: &["krab", "kreeft", "sterrenbeeld"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("krabbe"),
            keywords: &["dyr", "krabbe", "krepsen", "stjernebilete", "stjerneteikn"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କଙ\u{b4d}କଡ\u{b3c}\u{b3e}"),
            keywords: &[
                "କଙ\u{b4d}କଡ\u{b3c}\u{b3e}",
                "କର\u{b4d}କଟ । ର\u{b3e}ଶ\u{b3f}ଚକ\u{b4d}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a47}ਕੜਾ"),
            keywords: &["ਕਰਕ", "ਕ\u{a47}ਕੜਾ", "ਰਾਸ\u{a3c}ੀ ਚ\u{a71}ਕਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("اخبوط"),
            keywords: &["اخبوط", "ب\u{64f}رج", "ب\u{64f}رج سرطان"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Krab"),
            keywords: &["Krab", "Kánsa", "Zódiak"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("krab"),
            keywords: &["krab", "rak", "zodiak"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سرطان"),
            keywords: &["سرطان", "سرطان، چنګاښ، مرغومی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("caranguejo"),
            keywords: &["Câncer", "animal", "caranguejo", "zodíaco"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("caranguejo (animal)"),
            keywords: &["caranguejo", "caranguejo (animal)", "signo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("cangrejo"),
            keywords: &["Cancer", "cangrejo", "zodiaco"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("rac"),
            keywords: &["rac", "zodiac"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1096"),
            keywords: &["E10-1096"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("краб"),
            keywords: &["знак зодиака", "зодиак", "краб", "рак"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("karabu"),
            keywords: &["kanseri", "karabu", "zodiyake"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سرطان"),
            keywords: &["سرطان", "سرطان، برج"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කක\u{dd4}ළ\u{dd4}ව\u{dcf}"),
            keywords: &[
                "කක\u{dd4}ළ\u{dd4}ව\u{dcf}",
                "කටක ර\u{dcf}ශ\u{dd2}ය",
                "ර\u{dcf}ශ\u{dd2} චක\u{dca}\u{200d}රය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("krab"),
            keywords: &["krab", "rak"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("rakovica"),
            keywords: &["rak", "rakovica", "zodiak"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("carsaanyo"),
            keywords: &["carsaanyo", "kansar", "mactab meecaad"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gaforre"),
            keywords: &["gaforre", "zodiak"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("краба"),
            keywords: &["зoдиjaк", "краба", "рaк"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kraba"),
            keywords: &["kraba", "rak", "zodijak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("krabba"),
            keywords: &["krabba", "kräfta", "skaldjur", "stjärntecken"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kaa"),
            keywords: &["kaa", "zodiaki"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("நண\u{bcd}டு"),
            keywords: &["கடக ர\u{bbe}சி", "கடகம\u{bcd}", "நண\u{bcd}டு"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c40}త"),
            keywords: &[
                "ఎండ\u{c4d}రక\u{c3e}య",
                "కర\u{c4d}క\u{c3e}టకం",
                "ప\u{c40}త",
                "ర\u{c3e}శ\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("харчанг"),
            keywords: &["Саратон", "бурҷи дувоздаҳгона", "харчанг"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ป\u{e39}"),
            keywords: &["กรกฎ", "ป\u{e39}", "ราศ\u{e35}", "ส\u{e31}ตว\u{e4c}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("leňňeç"),
            keywords: &["Leňňeç", "leňňeç", "täleýnama"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("paka"),
            keywords: &["paka"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yengeç"),
            keywords: &["burç", "yengeç", "ıstakoz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قىسقۇچپاقا"),
            keywords: &["سەرەتان", "قىسقۇچپاقا", "مۆچەل"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("краб"),
            keywords: &["зодіак", "краб", "рак"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کیکڑا"),
            keywords: &["جانور", "کیکڑا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("dengiz qisqichbaqasi"),
            keywords: &["burj", "dengiz qisqichbaqasi", "qisqichbaqa"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cua"),
            keywords: &["cua", "cung cự giải", "cung hoàng đạo"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("junqoob"),
            keywords: &["Kànseer", "junqoob", "sojak"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("unonkala"),
            keywords: &["I-Cancer", "i-zodiac", "unonkala"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Alákàn"),
            keywords: &["Alákàn", "Cancer", "àmi oṣù ìbí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("蟹"),
            keywords: &["巨蟹座", "星座", "蟹"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("蟹"),
            keywords: &["巨蟹座", "星座", "蟹"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("蟹"),
            keywords: &["巨蟹座", "螃蟹", "蟹", "黄道十二宫"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("螃蟹"),
            keywords: &["紅蟳", "螃蟹", "蟹"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["星座", "螃蟹", "蟹"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inkalankala"),
            keywords: &["cancer", "inkalankala", "inkanyezi"],
        },
    ],
};
#[doc = "🦞"]
pub const LOBSTER: crate::Emoji = crate::Emoji {
    glyph: "🦞",
    codepoint: "1F99E",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "lobster",
    group: "Food & Drink",
    subgroup: "food-marine",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kreef"),
            keywords: &["bisque", "kreef", "seekos", "stert"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሎብስተር"),
            keywords: &["ሎብስተር", "ማጉርጥ", "ቢስክ", "የባህር ምግቦች"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كركند"),
            keywords: &[
                "بيسك",
                "جراد البحر",
                "حساء بيسك",
                "كركند",
                "مأكولات بحرية",
                "مخالب",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মিছ\u{9be}ম\u{9be}ছ"),
            keywords: &[
                "জন\u{9cd}ত\u{9c1}ৰ নখ",
                "বিস\u{9cd}ক",
                "মিছ\u{9be}ম\u{9be}ছ",
                "স\u{9be}গৰীয\u{9bc} খ\u{9be}দ\u{9cd}য",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("lobster"),
            keywords: &["caynaq", "dəniz mətbəxi", "lobster", "xərçəng əti"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("амар"),
            keywords: &["амар", "клюшні", "морапрадукты", "ракавы суп"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("омар"),
            keywords: &["морска храна", "омар", "червен рак", "щипки"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("গলদ\u{9be} চিংড\u{9bc}ি"),
            keywords: &[
                "গলদ\u{9be} চিংড\u{9bc}ি",
                "দ\u{9be}ড\u{9bc}\u{9be}",
                "বিস\u{9cd}ক",
                "সীফ\u{9c1}ড",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("legestr"),
            keywords: &["biskennad", "boued-mor", "legestr", "loen"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("jastog"),
            keywords: &["jastog", "klješta", "morski plodovi"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("llagosta"),
            keywords: &["bisque", "llagosta", "marisc", "pinces", "sopa de marisc"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏔᎾ ᏥᏍᏛᎾ"),
            keywords: &["ᎡᏉᏂ ᎡᎯ ᎠᎩᏍᏗ", "ᎤᎦᎹ", "ᎤᏔᎾ ᏥᏍᏛᎾ", "ᏚᏑᎦᏢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("humr"),
            keywords: &["humr", "klepeta", "langusta", "plody moře"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cimwch"),
            keywords: &["bisg", "bwyd môr", "cimwch", "crafangau"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("hummer"),
            keywords: &["bisque", "hummer", "kløer", "skaldyr"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Hummer"),
            keywords: &["Hummer", "Meeresfrüchte"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αστακός"),
            keywords: &["αστακός", "δαγκάνες", "θαλασσινά", "μπισκ"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("lobster"),
            keywords: &["bisque", "claws", "lobster", "seafood"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["bisque", "claws", "lobster", "seafood", "shellfish"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("langosta"),
            keywords: &["langosta", "marisco", "pinzas"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("langosta"),
            keywords: &["bisque", "langosta", "mariscos", "pinzas"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("langosta"),
            keywords: &["langosta"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("homaar"),
            keywords: &["homaar", "homaarisupp", "mereannid", "sõrad"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("otarrain"),
            keywords: &["itsaski", "itsaski-krema", "matxarda", "otarrain"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("لابستر"),
            keywords: &["انبرک", "سوپ غلیظ", "غذای دریایی", "لابستر"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hummeri"),
            keywords: &[
                "hummeri",
                "merenelävät",
                "sakset",
                "äyriäinen",
                "äyriäiset",
                "äyriäiskeitto",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lobster"),
            keywords: &["claws", "lobster", "pagkain", "seafood"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hummari"),
            keywords: &["dýr", "havføði", "hummari", "sjógæti"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("homard"),
            keywords: &["bisque", "fruits de mer", "homard", "pinces"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("gliomach"),
            keywords: &["bia mara", "bísc", "crúba", "gliomach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("giomach"),
            keywords: &["giomach", "maorach", "spògan", "ìnean"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("lagosta"),
            keywords: &["lagosta", "lumbrigante", "mariscada", "marisco"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લૉબ\u{acd}સ\u{acd}ટર"),
            keywords: &["નહોર", "બિસ\u{acd}ક", "લૉબ\u{acd}સ\u{acd}ટર", "સીફ\u{ac2}ડ"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לובסטר"),
            keywords: &["לובסטר", "מאכלי ים", "מרק סרטנים", "סרטנים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("झी\u{902}गा मछली"),
            keywords: &[
                "झी\u{902}गा मछली",
                "प\u{902}जा",
                "शोरबा",
                "सम\u{941}द\u{94d}री भोजन",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("jastog"),
            keywords: &["jastog", "kliješta", "morski plodovi", "oklop"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("homár"),
            keywords: &["homár", "ollók", "rákleves", "tengeri étel"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("օմար"),
            keywords: &["խեցգետին", "ծովամթերք", "օմար"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("lobster"),
            keywords: &["capit", "hidangan laut", "lobster", "sup"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("humar"),
            keywords: &["bisque", "humar", "klær", "matarmikil súpa", "sjávarfang"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("aragosta"),
            keywords: &["aragosta", "chele", "crostacei", "zuppa"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ザリガニ"),
            keywords: &["はさみ", "ザリガニ", "シーフード", "ビスク", "ロブスター"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("lopster"),
            keywords: &["capit", "iwak laut", "lopster", "sop bisque"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კიბო"),
            keywords: &["ზღვის პროდუქტები", "კიბო", "კირჩხიბი", "ლანგუსტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("лобстер"),
            keywords: &["биск", "лобстер", "теңіз тағамы", "қысқыш"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បង\u{17d2}កង"),
            keywords: &[
                "ក\u{17d2}រញា\u{17c6}",
                "បង\u{17d2}កង",
                "ស\u{17ca}\u{17bb}បខាប\u{17cb}",
                "អាហារសម\u{17bb}ទ\u{17d2}រ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಲೋಬ\u{ccd}\u{200c}ಸ\u{ccd}ಟರ\u{ccd}"),
            keywords: &[
                "ಪಂಜಗಳು",
                "ಬ\u{cbf}ಸ\u{ccd}ಕ\u{ccd}",
                "ಲೋಬ\u{ccd}\u{200c}ಸ\u{ccd}ಟರ\u{ccd}",
                "ಸಮುದ\u{ccd}ರಾಹಾರ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("바닷가재"),
            keywords: &["가재", "바닷가재", "집게발", "해산물"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("सा\u{902}गट"),
            keywords: &[
                "न\u{941}स\u{94d}त\u{947}\u{902}",
                "प\u{902}ज\u{947}",
                "बिस\u{94d}क",
                "सा\u{902}गट",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("омар"),
            keywords: &[
                "деңиз тамак-ашы",
                "кыпчуурлар",
                "омар",
                "омардан жасалган шорпо",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກ\u{eb8}\u{ec9}ງລອບສະເຕ\u{eb5}"),
            keywords: &[
                "ກ\u{eb8}\u{ec9}ງລອບສະເຕ\u{eb5}",
                "ກ\u{ebb}ງເລບ",
                "ຊາມ",
                "ອາຫານທະເລ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("omaras"),
            keywords: &["jūrų gėrybė", "omaras", "žnyplės"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("omārs"),
            keywords: &["bisks", "jūras veltes", "omārs", "spīles"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("јастог"),
            keywords: &["клешти", "морска храна", "рак", "јастог"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കൊഞ\u{d4d}ച\u{d4d}"),
            keywords: &[
                "കടൽവിഭവം",
                "കൊഞ\u{d4d}ച\u{d4d}",
                "ജന\u{d4d}ത\u{d41}ക\u{d4d}കള\u{d41}ടെ നഖം",
                "ബിസ\u{d4d}\u{200c}ക\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("голын хавч"),
            keywords: &["голын хавч", "далайн хоол", "сарвуу", "хавчны зутан шөл"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("लॉबस\u{94d}टर"),
            keywords: &["क\u{94d}लॉ", "बिस\u{94d}क", "लॉबस\u{94d}टर", "सीफ\u{942}ड"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("udang karang"),
            keywords: &["bisk", "makanan laut", "sepit", "udang karang"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကျောက\u{103a}ပ\u{102f}စ\u{103d}န\u{103a}"),
            keywords: &[
                "ကဏန\u{103a}းလက\u{103a}မ",
                "ကျောက\u{103a}ပ\u{102f}စ\u{103d}န\u{103a}",
                "ခ\u{102f}\u{1036}းဟင\u{103a}းရည\u{103a}",
                "ပင\u{103a}လယ\u{103a}စာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hummer"),
            keywords: &["bisque", "hummer", "klør", "sjømat", "skalldyr"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("सम\u{941}द\u{94d}री जीव"),
            keywords: &[
                "नङ\u{94d}ग\u{94d}रा",
                "बिस\u{94d}क",
                "सम\u{941}द\u{94d}री खान\u{947}क\u{941}रा",
                "सम\u{941}द\u{94d}री जीव",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kreeft"),
            keywords: &["bisque", "kreeft", "scharen", "zeevruchten"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("hummar"),
            keywords: &["bisque", "hummar", "klør", "sjømat", "skaldyr"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବଡ\u{b3c} ଚ\u{b3f}ଙ\u{b4d}ଗ\u{b41}ଡ\u{b3f} ମ\u{b3e}ଛ"),
            keywords: &[
                "ପଞ\u{b4d}ଝ\u{b3e}",
                "ବଡ\u{b3c} ଚ\u{b3f}ଙ\u{b4d}ଗ\u{b41}ଡ\u{b3f} ମ\u{b3e}ଛ",
                "ବ\u{b3f}ସକ\u{b4d}ୟ\u{b41}",
                "ସ\u{b3e}ମ\u{b41}ଦ\u{b4d}ର\u{b3f}କଖ\u{b3e}ଦ\u{b4d}ୟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਝੀ\u{a02}ਗਾ ਮ\u{a71}ਛੀ"),
            keywords: &[
                "ਝੀ\u{a02}ਗਾ ਮ\u{a71}ਛੀ",
                "ਪ\u{a70}ਜ\u{a47}",
                "ਬਿਸਕ",
                "ਸਮ\u{a41}\u{a70}ਦਰੀ ਭ\u{a4b}ਜਨ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Lọ\u{301}bsta"),
            keywords: &[
                "Lọ\u{301}bsta",
                "Nel",
                "Sífud",
                "Tík Sup Wé Dẹm De Kọ\u{301}l Bisk",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("homar"),
            keywords: &["homar", "owoce morza", "szczypce"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لوبسټر"),
            keywords: &["بسک، پنجه، لوبسټر، بحري خواړه", "لوبسټر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("lagosta"),
            keywords: &["bisque", "caldo", "fruto do mar", "garras", "lagosta"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["lagosta", "mariscada", "marisco", "pinças"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("langosta"),
            keywords: &[
                "langosta",
                "mamaquchamanta mikhuna",
                "sillukuna",
                "sopa de mariscos nisqa",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("homar"),
            keywords: &["clești", "fructe de mare", "homar"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-028"),
            keywords: &["E11-028"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("омар"),
            keywords: &["клешни", "лангуст", "лобстер", "морепродукты", "омар"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("لوبسٽر"),
            keywords: &["بسڪيو", "سامونڊي کاڌو", "لوبسٽر", "ڪلاز"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පොක\u{dd2}ර\u{dd2}ස\u{dca}ස\u{dcf}"),
            keywords: &[
                "න\u{dd2}යපොත\u{dd4}",
                "පොක\u{dd2}ර\u{dd2}ස\u{dca}සන\u{dca} ස\u{dd4}ප\u{dca}",
                "පොක\u{dd2}ර\u{dd2}ස\u{dca}ස\u{dcf}",
                "ම\u{dd4}හ\u{dd4}ද\u{dd4} ආහ\u{dcf}ර",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("homár"),
            keywords: &["dary mora", "homár", "klepetá"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("jastog"),
            keywords: &["jastog", "klešče", "kremna juha", "morska hrana"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("argoosto"),
            keywords: &[
                "argoosto",
                "ciddiyaha",
                "cunno badeed",
                "maraq dufan ee kalluun",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("karavidhe"),
            keywords: &["karavidhe", "ushqim deti"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("јастог"),
            keywords: &["клешта", "морска храна", "јастог"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["јастог"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("jastog"),
            keywords: &["jastog", "klešta", "morska hrana"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["jastog"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("hummer"),
            keywords: &["fisksoppa", "hummer", "klor", "skaldjur"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kambamti"),
            keywords: &["gando", "kambamti", "supu", "vyakula vya baharini"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கடல\u{bcd} நண\u{bcd}டு"),
            keywords: &[
                "கடல\u{bcd} உணவு",
                "கடல\u{bcd} நண\u{bcd}டு",
                "நகங\u{bcd}கள\u{bcd}",
                "பிஸ\u{bcd}கே",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ల\u{c3e}బ\u{c4d}\u{200c}స\u{c4d}టర\u{c4d}"),
            keywords: &[
                "గ\u{c4b}ళ\u{c4d}లు",
                "బ\u{c3f}స\u{c4d}క\u{c4d}",
                "ల\u{c3e}బ\u{c4d}\u{200c}స\u{c4d}టర\u{c4d}",
                "సముద\u{c4d}రపు ఆహ\u{c3e}రం",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ก\u{e38}\u{e49}งม\u{e31}งกร"),
            keywords: &[
                "ก\u{e38}\u{e49}งม\u{e31}งกร",
                "ก\u{e49}ามก\u{e38}\u{e49}ง",
                "ซ\u{e38}ปน\u{e49}ำข\u{e49}น",
                "อาหารทะเล",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("omar"),
            keywords: &["bisk", "deňiz önümi", "omar", "penjeler"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻuo"),
            keywords: &["ʻuo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ıstakoz"),
            keywords: &["bisque", "deniz ürünü", "kıskaç", "ıstakoz"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("омар"),
            keywords: &[
                "дари моря",
                "клешні",
                "лобстер",
                "морепродукти",
                "омар",
                "рак",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("لوبسٹر"),
            keywords: &["سمندری غذا", "لوبسٹر", "پنجے", "گاڑھا سوپ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("omar"),
            keywords: &[
                "dengiz",
                "dengiz mahsulotlari",
                "dengiz qisqichbaqasi",
                "omar",
                "qisqich",
                "qisqichbaqa",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tôm hùm"),
            keywords: &["càng", "hải sản", "tôm hùm", "xúp tôm cua"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("龍蝦"),
            keywords: &["海鮮", "濃湯", "爪", "龍蝦"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("龙虾"),
            keywords: &["浓汤", "海鲜", "爪", "龙虾"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("龙虾"),
            keywords: &["浓汤", "海鲜", "钳", "龙虾"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("龍蝦"),
            keywords: &["海鮮", "濃湯", "爪", "龍蝦"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("lobster"),
            keywords: &["bisque", "claws", "lobster", "seafood"],
        },
    ],
};
#[doc = "🦐"]
pub const SHRIMP: crate::Emoji = crate::Emoji {
    glyph: "🦐",
    codepoint: "1F990",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "shrimp",
    group: "Food & Drink",
    subgroup: "food-marine",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("garnaal"),
            keywords: &["garnaal", "kos", "skulpvis"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ትንሽ አሣ"),
            keywords: &["ምግብ", "ትንሽ", "ትንሽ አሣ", "ጠንካራ ሽፋን ያለው አሣ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("جمبري"),
            keywords: &["جمبري", "طعام", "محار"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("শিঙি"),
            keywords: &["খ\u{9be}দ\u{9cd}য", "শিঙি", "শ\u{9cd}বেলফিচ", "সৰ\u{9c1}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("krevet"),
            keywords: &["krevet", "su canlısı", "xərçəng"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("крэветка"),
            keywords: &["ежа", "крэветка", "маленькая", "морапрадукты"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("скарида"),
            keywords: &["скарида", "храна", "черупкови"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চিংড\u{9bc}ি"),
            keywords: &[
                "খ\u{9be}ব\u{9be}র",
                "খোল\u{9be}ওয\u{9bc}\u{9be}ল\u{9be} ম\u{9be}ছ",
                "চিংড\u{9bc}ি",
                "ছোট",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("chevr"),
            keywords: &["boued-mor", "chevr", "kresteneg", "loen"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("škamp"),
            keywords: &["hrana", "račić", "škamp", "školjka"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("gamba"),
            keywords: &["crustaci", "gamba", "llagostí", "marisc", "menjar"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄄𑄎\u{11133}𑄠"),
            keywords: &["𑄄𑄎\u{11133}𑄠"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏥᏅᏅ"),
            keywords: &["ᎠᎵᏍᏓᏴᏗ", "ᎤᎾᏯᏍᎦᏟ ᎠᏣᏗ", "ᎤᏍᏗ", "ᏥᏅᏅ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kreveta"),
            keywords: &["garnát", "jídlo", "korýš", "kreveta"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("berdysyn"),
            keywords: &["bach", "berdysyn", "bwyd", "pysgodyn cragen"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("reje"),
            keywords: &["dyr", "havdyr", "mad", "reje", "skaldyr"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Garnele"),
            keywords: &["Garnele", "Gourmet", "Krustentier"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γαρίδα"),
            keywords: &["γαρίδα", "μικρό", "οστρακοειδές", "τροφή"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("shrimp"),
            keywords: &["food", "shellfish", "shrimp", "small"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["food", "prawn", "shellfish", "shrimp", "small"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("prawn"),
            keywords: &["prawn", "seafood", "shellfish", "shrimp"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("gamba"),
            keywords: &["camarón", "comida", "gamba", "langostino", "marisco"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("camarón"),
            keywords: &["camarón", "comida", "langostino", "marisco"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["camarón", "comida", "langostino", "mariscos"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("krevett"),
            keywords: &["koorikloom", "krevett", "toit"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ganba"),
            keywords: &["ganba", "itsaski", "janari", "txiki"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("میگو"),
            keywords: &["جانور دریایی", "ماهی", "میگو"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("katkarapu"),
            keywords: &["katkarapu", "ruoka", "äyriäiset"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("hipon"),
            keywords: &["hipon", "maliit", "pagkain", "shellfish", "sugpo"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("rækja"),
            keywords: &["dýr", "havføði", "matur", "rækja", "sjógæti"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("crevette"),
            keywords: &["crevette", "crustacé"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["crevette", "crustacé", "nourriture"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ribe róibéis"),
            keywords: &["beag", "bia", "ribe róibéis", "sliogiasc"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("carrain"),
            keywords: &["beag", "biadh", "carrain", "maorach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("gamba"),
            keywords: &["animal", "camarón", "gamba", "lagostino", "marisco"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઝી\u{a82}ગ\u{ac1}\u{a82}"),
            keywords: &[
                "કરચલો",
                "ઝી\u{a82}ગ\u{ac1}\u{a82}",
                "નાન\u{ac1}\u{a82}",
                "ભોજન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("jatanlande"),
            keywords: &["abinci", "jatanlande", "kifi mai katantanwa", "ƙarami"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שרימפ"),
            keywords: &["חסילון", "פירות ים", "שרימפ"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("झी\u{902}गा"),
            keywords: &["छोटा", "झी\u{902}गा", "भोजन", "श\u{902}ख"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("škamp"),
            keywords: &["hrana", "rak", "škamp", "školjka"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("garnélarák"),
            keywords: &["garnélarák", "kicsi", "étel"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ծովախեցգետին"),
            keywords: &["ծովախեցգետին", "մանրածովախեցգետին", "ուտելիք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("udang"),
            keywords: &["makanan", "seafood", "udang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ayịya"),
            keywords: &["ayịya", "ejummiri", "nri", "obere"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("rækja"),
            keywords: &["rækja", "sjávardýr", "skelfiskur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("gamberetto"),
            keywords: &["animale", "cibo", "crostaceo", "gamberetto", "gambero"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("エビ"),
            keywords: &["エビ", "シュリンプ", "シーフード", "動物"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("urang"),
            keywords: &["cilik", "dhaharan", "urang", "urang-urangan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კრევეტი"),
            keywords: &["კრევეტი", "მოლუსკი", "პატარა", "საკვები"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("асшаян"),
            keywords: &["асшаян", "тағам", "шаян"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("reje"),
            keywords: &["dyr", "havdyr", "mad", "reje", "skaldyr"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បង\u{17d2}គារ"),
            keywords: &[
                "ត\u{17bc}ច",
                "បង\u{17d2}គារ",
                "ពព\u{17bd}កខ\u{17d2}យង",
                "អាហារ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಶ\u{ccd}ರ\u{cbf}ಂಪ\u{ccd}"),
            keywords: &[
                "ಆಹಾರ",
                "ಚ\u{cbf}ಕ\u{ccd}ಕದು",
                "ಶ\u{cc6}ಲ\u{ccd} ಮೀನು",
                "ಶ\u{ccd}ರ\u{cbf}ಂಪ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("새우"),
            keywords: &["갑각류", "바다생물", "새우", "식품"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("स\u{941}\u{902}गट"),
            keywords: &[
                "अन\u{94d}न",
                "कवच आसपी न\u{941}स\u{94d}त\u{947}\u{902}",
                "ल\u{94d}हान",
                "स\u{941}\u{902}गट",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("креветка"),
            keywords: &["деңиз азыктары", "креветка", "майда", "тамак"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Crevette"),
            keywords: &["Crevette", "Iessen", "Mieresfruucht", "kleng"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກ\u{eb8}\u{ec9}ງ"),
            keywords: &["ກ\u{eb8}\u{ec9}ງ", "ນ\u{ec9}ອຍ", "ຫອຍ", "ອາຫານ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("krevetė"),
            keywords: &["kiaukutinis", "krevetė", "maistas", "mažas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("garnele"),
            keywords: &["garnele", "mazs", "ēdiens"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kōuraura"),
            keywords: &["kai", "kōuraura", "mātaitai", "ririki"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("ракче"),
            keywords: &["ракче", "храна"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ചെമ\u{d4d}മീൻ"),
            keywords: &["കൊഞ\u{d4d}ച\u{d4d}", "ചെമ\u{d4d}മീൻ", "മീൻ", "മൽസ\u{d4d}യം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("сам хорхой"),
            keywords: &["жижиг", "сам хорхой", "усны амьтан", "хавч", "хүнс"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("झि\u{902}गा"),
            keywords: &["खाद\u{94d}य", "ख\u{947}कडा", "झि\u{902}गा", "लहान"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("udang"),
            keywords: &["kecil", "makanan", "udang"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("gamblu"),
            keywords: &["frott tal-baħar", "gamblu", "ikel", "żgħir"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပ\u{102f}စ\u{103d}န\u{103a}"),
            keywords: &[
                "ဂ\u{102f}\u{1036}း",
                "ပ\u{102f}စ\u{103d}န\u{103a}",
                "သေးသေး",
                "အစားအသောက\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("reke"),
            keywords: &["dyr", "liten", "mat", "reke"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("श\u{94d}रिम\u{94d}प"),
            keywords: &["खाना", "श\u{947}लमाछा", "श\u{94d}रिम\u{94d}प", "सानो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("garnaal"),
            keywords: &["garnaal", "klein", "schaaldier", "voedsel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("reke"),
            keywords: &["dyr", "liten", "mat", "reke"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଚ\u{b3f}ଙ\u{b4d}ଗ\u{b41}ଡ\u{b3c}\u{b3f}"),
            keywords: &[
                "ଚ\u{b3f}ଙ\u{b4d}ଗ\u{b41}ଡ\u{b3c}\u{b3f}",
                "ଚ\u{b3f}ଙ\u{b4d}ଗ\u{b41}ଡ\u{b3c}\u{b3f} । ଛୋଟ । ଶେଲଫ\u{b3f}ଶ\u{b4d}\u{200d} । ଖ\u{b3e}ଦ\u{b4d}ୟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਝੀ\u{a02}ਗਾ"),
            keywords: &["ਛ\u{a4b}ਟਾ", "ਝੀ\u{a02}ਗਾ", "ਭ\u{a4b}ਜਨ", "ਸ\u{a70}ਖ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("جھینگا"),
            keywords: &["جھینگا", "خود غرض", "خوراک", "نیکا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Shrimp"),
            keywords: &["Fud", "Shrimp", "Shẹlfish", "Smọl"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("krewetka"),
            keywords: &["jedzenie", "krewetka", "owoce morza"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("چنګاښ"),
            keywords: &["خواړه، شل کب، چنګاښ، کوچنی", "چنګاښ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("camarão"),
            keywords: &["camarão", "comida", "crustáceo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["camarão", "comida", "gamba", "marisco"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("camaron"),
            keywords: &["camaron", "huchuy", "mariscos", "mikhuna"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("crevete"),
            keywords: &["crevete", "fructe de mare", "mic", "mâncare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1112"),
            keywords: &["E10-1112"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("креветка"),
            keywords: &["еда", "креветка", "маленькая", "морепродукты"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("kerevete"),
            keywords: &[
                "gitoya",
                "ibiribwa",
                "igihore cyo mu mazi",
                "igikonoshwa cy’ifi",
                "kerevete",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("جهينگو"),
            keywords: &["جهينگو", "جهينگو، ننڍي، خول مڇي، کاڌو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dd6}න\u{dd2}ස\u{dca}ස\u{dcf}"),
            keywords: &[
                "කෑම",
                "ක\u{dd4}ඩ\u{dcf}",
                "ක\u{dd6}න\u{dd2}ස\u{dca}ස\u{dcf}",
                "ස\u{dd2}ප\u{dca}ප\u{dd2} බෙල\u{dca}ල\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kreveta"),
            keywords: &["jedlo", "kreveta", "mäkkýš"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("morski rakec"),
            keywords: &["hrana", "kozica", "morski rakec", "rak", "škamp"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kalluun qolof la shiilay"),
            keywords: &[
                "cunto",
                "kalluun qolof la shiilay",
                "qolof kalluun",
                "qolof kalluun la shiilay",
                "yar",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("karkalec deti"),
            keywords: &["butak", "i vogël", "karkalec deti", "ushqim"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("рачић"),
            keywords: &["рак", "рачић", "храна"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("račić"),
            keywords: &["hrana", "rak", "račić"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("räka"),
            keywords: &["liten", "mat", "räka", "skaldjur"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uduvi"),
            keywords: &["chakula", "kamba", "uduvi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கூனிற\u{bbe}ல\u{bcd}"),
            keywords: &["உணவு", "கூனிற\u{bbe}ல\u{bcd}", "ம\u{bc0}ன\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ర\u{c4a}య\u{c4d}య"),
            keywords: &[
                "ఆహ\u{c3e}రం",
                "చ\u{c3f}న\u{c4d}న",
                "ర\u{c4a}య\u{c4d}య",
                "ష\u{c46}ల\u{c4d}\u{200c}ఫ\u{c3f}ష\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("гамбусакча"),
            keywords: &["гамбусак", "гамбусакча", "моллюскҳо", "хурд", "ғизо"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ก\u{e38}\u{e49}ง"),
            keywords: &["ก\u{e38}\u{e49}ง", "อาหาร"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("krewetka"),
            keywords: &["iýmit", "kiçi", "krewetka", "mollýuska"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻuosiʻisiʻi"),
            keywords: &["ʻuosiʻisiʻi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("karides"),
            keywords: &["kabuklu deniz hayvanı", "karides", "küçük", "yiyecek"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("راك"),
            keywords: &["راك", "قاسراقلىق بېلىق", "كىچىك", "يېمەكلىك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("креветка"),
            keywords: &["креветка", "морепродукт", "їжа"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جھینگا"),
            keywords: &["جھینگا", "خوراک"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("mayda qisqichbaqa"),
            keywords: &["dengiz mahsulotlari", "mayda", "qisqichbaqa", "taom"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tôm"),
            keywords: &["nhỏ", "thức ăn", "tôm", "tôm cua"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("krëwet"),
            keywords: &["krëwet", "lekk", "meññeefu géej", "ndaw"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inqonci"),
            keywords: &["encinane", "i-shellfish", "inqonci", "ukutya"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ede"),
            keywords: &["Ede", "edé", "kékeré", "ónjẹ", "ẹja inú ìkarahun"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("蝦"),
            keywords: &["小", "甲殼類動物", "蝦", "食物"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("虾"),
            keywords: &["小", "甲壳类动物", "虾", "食物"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("虾"),
            keywords: &["甲壳", "虾", "食物"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("蝦子"),
            keywords: &["甲殼", "蝦", "蝦子", "食物"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("蝦"),
            keywords: &["明蝦", "蝦", "蝦子"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("imfanzi"),
            keywords: &["igobolondo", "imfanzi", "ncane", "ukudla"],
        },
    ],
};
#[doc = "🦑"]
pub const SQUID: crate::Emoji = crate::Emoji {
    glyph: "🦑",
    codepoint: "1F991",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "squid",
    group: "Food & Drink",
    subgroup: "food-marine",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("inkvis"),
            keywords: &["calamari", "inkvis", "kos", "mollusk", "seekat", "tjokka"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ስክዊድ"),
            keywords: &["ምግብ", "ሞሉስክ", "ስክዊድ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("حبار"),
            keywords: &["حبار", "طعام"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("স\u{9cd}ক\u{9c1}ইড"),
            keywords: &["খ\u{9be}দ\u{9cd}য", "মোলস\u{9cd}ক", "স\u{9cd}ক\u{9c1}ইড"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("səkkiz ayaq"),
            keywords: &["su canlısı", "səkkiz ayaq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кальмар"),
            keywords: &["ежа", "кальмар", "малюск"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("калмар"),
            keywords: &["калмар", "мекотело", "храна"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9cd}ক\u{9c1}ইড"),
            keywords: &[
                "খ\u{9be}ব\u{9be}র",
                "শম\u{9cd}ব\u{9c1}ক কোমল\u{9be}ঙ\u{9cd}গ জন\u{9cd}ত\u{9c1}",
                "স\u{9cd}ক\u{9c1}ইড",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("stivell"),
            keywords: &["blotvil", "boued", "stivell"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("lignja"),
            keywords: &["hrana", "lignja", "mekušac"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("calamar"),
            keywords: &["animal", "calamar", "menjar", "molusc"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏍᏈᏗ"),
            keywords: &["ᎠᎵᏍᏓᏴᏗ", "ᎼᎸᏍᎩ", "ᏍᏈᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("oliheň"),
            keywords: &[
                "hlavonožec",
                "jídlo",
                "kalamár",
                "měkkýš",
                "oliheň",
                "sépie",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ystifflog"),
            keywords: &["bwyd", "molwsg", "ystifflog"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sprutte"),
            keywords: &[
                "arme",
                "blæk",
                "blæksprutte",
                "bløddyr",
                "flerarmet",
                "havdyr",
                "mad",
                "multitasking",
                "sprutte",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Tintenfisch"),
            keywords: &["Kalmar", "Tintenfisch"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καλαμάρι"),
            keywords: &["καλαμάρι", "μαλάκιο", "τροφή"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("squid"),
            keywords: &["food", "molusc", "squid"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["food", "mollusc", "squid"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["decapod", "seafood", "squid"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("calamar"),
            keywords: &["calamar", "comida", "molusco"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["calamar", "comida", "mariscos"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kalmaar"),
            keywords: &["kalmaar", "mollusk", "toit"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("txibia"),
            keywords: &["janari", "molusku", "txibia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ماهی مرکب"),
            keywords: &["اختاپوس", "جانور دریایی", "ماهی مرکب", "هشت\u{200c}پا"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kalmari"),
            keywords: &["kalmari", "mustekala", "ruoka"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pusit"),
            keywords: &["pagkain", "pugita", "pusit"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("høgguslokkur"),
            keywords: &[
                "dýr",
                "høgguslokkur",
                "høgguslokkur við tíggju ørmum",
                "matur",
                "tíggjuarmaður",
                "tíggjuermdur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("calamar"),
            keywords: &["calamar", "mollusque"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("scuid"),
            keywords: &["bia", "moileasc", "scuid"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("gibearnach"),
            keywords: &["biadh", "gibearnach", "moileasg"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("lura"),
            keywords: &["animal", "choco", "lura", "molusco"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}ક\u{acd}વિડ"),
            keywords: &["ભોજન", "સ\u{acd}ક\u{acd}વિડ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("jatan lande na turawa"),
            keywords: &["abinci", "jatan lande na turawa", "molusc"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("דיונון"),
            keywords: &["דיונון", "פירות ים", "קלמרי", "תמנון"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{94d}क\u{94d}विड"),
            keywords: &["भोजन", "सीप", "स\u{94d}क\u{94d}विड"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lignja"),
            keywords: &["hrana", "lignja", "mekušac"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("tintahal"),
            keywords: &["tintahal", "étel"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կաղամար"),
            keywords: &["կակղամորթ", "կաղամար", "ուտելիք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("cumi-cumi"),
            keywords: &["cumi", "cumi-cumi", "makanan", "moluska", "seafood"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Azụ sụkwịdị"),
            keywords: &["Azụ sụkwịdị", "azụ sụkwidi", "ejummiri", "nri"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("smokkfiskur"),
            keywords: &["sjávardýr", "smokkfiskur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("calamaro"),
            keywords: &["animale", "calamaro", "cibo", "mollusco", "totano"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("イカ"),
            keywords: &["イカ", "シーフード", "動物"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sotong"),
            keywords: &["cumi-cumi", "pangan", "sotong"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კალმარი"),
            keywords: &["კალმარი", "მოლუსკი", "საკვები"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("кальмар"),
            keywords: &["кальмар", "тағам"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("sprutte"),
            keywords: &[
                "arme",
                "blæk",
                "blæksprutte",
                "bløddyr",
                "dyr",
                "flerarmet",
                "havdyr",
                "mad",
                "multitasking",
                "sprutte",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17b9}កប\u{17c6}ពង\u{17cb}"),
            keywords: &[
                "ម\u{17b9}ក",
                "ម\u{17b9}កប\u{17c6}ពង\u{17cb}",
                "ស\u{17b7}ប\u{17d2}ប\u{17b7}ជាត\u{17b7}",
                "អាហារ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{ccd}ಕ\u{ccd}ವ\u{cbf}ಡ\u{ccd}"),
            keywords: &[
                "ಆಹಾರ",
                "ಮೊಲುಸ\u{ccd}ಕ\u{ccd}",
                "ಸ\u{ccd}ಕ\u{ccd}ವ\u{cbf}ಡ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("오징어"),
            keywords: &["식품", "연체동물", "오징어"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("माणकी"),
            keywords: &["अन\u{94d}न", "माणकी", "माणक\u{94d}यो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кальмар"),
            keywords: &["кальмар", "моллюск", "тамак"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Calamar"),
            keywords: &["Calamar", "Iessen", "Mollusk"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປາໝ\u{eb6}ກ"),
            keywords: &["ປາເໝ\u{eb4}ກ", "ປາໝ\u{eb6}ກ", "ອາຫານ", "ໝ\u{eb6}ກ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kalmaras"),
            keywords: &["kalmaras", "maistas", "moliuskas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kalmārs"),
            keywords: &["kalmārs", "molusks", "ēdiens"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ngū"),
            keywords: &["kai", "kota", "ngū"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лигња"),
            keywords: &["лигња", "храна"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d42}ന\u{d4d}തൾ"),
            keywords: &["കണവ", "ക\u{d42}ന\u{d4d}തൾ", "മൽസ\u{d4d}യം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("кальмар"),
            keywords: &["кальмар", "наймаалж", "усны амьтан"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{94d}क\u{94d}विड"),
            keywords: &["खाद\u{94d}य", "मॉल\u{941}स\u{94d}क", "स\u{94d}क\u{94d}विड"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("sotong"),
            keywords: &["makanan", "moluska", "sotong"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("klamari"),
            keywords: &["ikel", "klamari", "mollusk"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပြည\u{103a}ကြ\u{102e}းငါး"),
            keywords: &[
                "ခရ\u{102f}",
                "ပြည\u{103a}ကြ\u{102e}းငါး",
                "အစားအသောက\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("akkar"),
            keywords: &["akkar", "blekk", "blekksprut", "bløtdyr", "dyr", "sprut"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}क\u{94d}विड"),
            keywords: &["खाना", "मोलस\u{94d}क", "स\u{94d}क\u{94d}विड"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("inktvis"),
            keywords: &["calamaris", "inktvis", "voedsel", "weekdier"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("akkar"),
            keywords: &["akkar", "blautdyr", "blekk", "blekksprut", "dyr", "sprut"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b4d}କ\u{b41}ଇଡ\u{b4d}\u{200d}"),
            keywords: &[
                "ସ\u{b4d}କ\u{b41}ଇଡ\u{b4d}\u{200d}",
                "ସ\u{b4d}କ\u{b41}ଇଡ\u{b4d}\u{200d} । ମୋଲ\u{b41}ସ\u{b4d}କ । ଖ\u{b3e}ଦ\u{b4d}ୟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਕਵਿ\u{a71}ਡ"),
            keywords: &["ਭ\u{a4b}ਜਨ", "ਸਕਵਿ\u{a71}ਡ", "ਸਿ\u{a71}ਪੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("قیر ماہی"),
            keywords: &["خوراک", "قیر ماہی", "پلپلے جانور"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Skwid"),
            keywords: &[
                "Fud",
                "Mọ\u{301}lúsk: Wọ\u{301}n Kríchọ\u{301} Wé Rizẹ\u{301}mbúl Snel",
                "Skwid",
                "Skwid: Wọ\u{301}n Kríchọ\u{301} Wé De Lív Fọ Wọtá",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kałamarnica"),
            keywords: &["jedzenie", "kałamarnica", "mięczak", "ośmiornica"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سکویډ"),
            keywords: &["خواړه، مولسک، سکويډ", "سکویډ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("lula"),
            keywords: &["comida", "lula", "molusco"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("calamar"),
            keywords: &["calamar", "mikhuna", "molusco"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("calmar"),
            keywords: &["calamar", "calmar", "moluscă", "mâncare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1113"),
            keywords: &["E10-1113"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("кальмар"),
            keywords: &["еда", "кальмар", "моллюск"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("sikwidi"),
            keywords: &[
                "ibiribwa",
                "ifi nyamahembe",
                "ikinyamunjonjorerwa",
                "sikwidi",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اسڪواڊ"),
            keywords: &["اسڪواڊ", "جهينگو، سيپي، کاڌو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("දැල\u{dca}ල\u{dcf}"),
            keywords: &[
                "කෑම",
                "දැල\u{dca}ල\u{dcf}",
                "ප\u{dd4}ෂ\u{dca}ට\u{dd2}කයන\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kalmár"),
            keywords: &["jedlo", "kalmár", "mäkkýš"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ligenj"),
            keywords: &["hrana", "ligenj", "mehkužec"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("xayawaan badeed"),
            keywords: &["cunto", "xayawaan badeed"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kallamar"),
            keywords: &["kallamar", "molusk", "ushqim"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("хоботница"),
            keywords: &["лигње", "хоботница", "храна"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("hobotnica"),
            keywords: &["hobotnica", "hrana", "lignje"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("mindre bläckfisk"),
            keywords: &["bläck", "bläckfisk", "mat", "mindre bläckfisk", "skaldjur"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ngisi"),
            keywords: &["chakula", "ngisi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கணவ\u{bbe}ய\u{bcd}"),
            keywords: &["உணவு", "கணவ\u{bbe}ய\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c4d}క\u{c4d}వ\u{c3f}డ\u{c4d}"),
            keywords: &[
                "ఆహ\u{c3e}రం",
                "ష\u{c46}ల\u{c4d}\u{200c}ఫ\u{c3f}ష\u{c4d}",
                "స\u{c4d}క\u{c4d}వ\u{c3f}డ\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("калмар"),
            keywords: &["калмар", "моллюск", "ғизо"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หม\u{e36}ก"),
            keywords: &["ปลา", "หม\u{e36}ก", "อาหาร"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kalmar"),
            keywords: &["iýmit", "kalmar", "mollýuska"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ngūfeke"),
            keywords: &["ngūfeke"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("mürekkep balığı"),
            keywords: &["mürekkep balığı", "yiyecek", "yumuşakçalar sınıfı"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قاراقچىبېلىق"),
            keywords: &["سىياھ", "قاراقچىبېلىق", "يۇمشاق", "يېمەكلىك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кальмар"),
            keywords: &["кальмар", "молюск", "їжа"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("قیر ماہی"),
            keywords: &["خوراک", "قیر ماہی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kalmar"),
            keywords: &["kalmar", "mollyuska", "taom"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mực ống"),
            keywords: &["mực ống", "thân mềm", "thức ăn"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kalamaar"),
            keywords: &["kalamaar", "lekk", "yéet"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-squid"),
            keywords: &["i-molusc", "i-squid", "ukutya"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Sikidi"),
            keywords: &["Sikidi", "mólúsì", "síkídì", "ónjẹ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("魷魚"),
            keywords: &["軟體動物", "食物", "魷魚"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("鱿鱼"),
            keywords: &["软体动物", "食物", "鱿鱼"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("乌贼"),
            keywords: &["乌贼", "墨鱼", "软体动物", "食物", "鱿鱼"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("魷魚"),
            keywords: &["軟體動物", "食物", "魷魚"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["動物", "烏賊", "魷魚"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ingwane"),
            keywords: &["ingwane", "molusc", "ukudla"],
        },
    ],
};
#[doc = "🦪"]
pub const OYSTER: crate::Emoji = crate::Emoji {
    glyph: "🦪",
    codepoint: "1F9AA",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "oyster",
    group: "Food & Drink",
    subgroup: "food-marine",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("oester"),
            keywords: &["duik", "oester", "pêrel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሼል"),
            keywords: &["ሉል", "መጥለቅ", "ሼል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("محار"),
            keywords: &["صدف", "غطس", "لؤلؤ", "محار"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ঐষ\u{9cd}ট\u{9be}ৰ"),
            keywords: &[
                "ঐষ\u{9cd}ট\u{9be}ৰ",
                "ড\u{9be}ইভিং",
                "ম\u{9c1}ক\u{9cd}ত\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("stridiya"),
            keywords: &["mirvari", "stridiya", "suyagirmə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("вустрыца"),
            keywords: &["вустрыца", "жэмчуг", "ныранне"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("стрида"),
            keywords: &["гмуркане", "мида", "перла", "стрида"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ওয\u{9bc}েস\u{9cd}ট\u{9be}র"),
            keywords: &[
                "ওয\u{9bc}েস\u{9cd}ট\u{9be}র",
                "ড\u{9c1}ব\u{9c1}রি",
                "প\u{9be}র\u{9cd}ল",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("istr"),
            keywords: &["istr", "perlez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kamenica"),
            keywords: &["biser", "kamenica", "ronjenje", "školjka"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("ostra"),
            keywords: &["busseig", "ostra", "perla"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏔᎾ ᏓᎬᎾ"),
            keywords: &["ᎠᏕᏛᏍᎦ", "ᎤᏔᎾ ᏓᎬᎾ", "ᏓᎬᎾ ᏅᏯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("ústřice"),
            keywords: &["perla", "potápění", "ústřice"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wystrys"),
            keywords: &["cragen", "perl", "wystrys"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("østers"),
            keywords: &["dykke", "perle", "østers"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Auster"),
            keywords: &["Auster", "Perle", "tauchen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("στρείδι"),
            keywords: &["κατάδυση", "μαργαριτάρι", "στρείδι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("oyster"),
            keywords: &["diving", "oyster", "pearl"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ostra"),
            keywords: &["buceo", "ostra", "perla"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("ostión"),
            keywords: &["ostión"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("auster"),
            keywords: &["auster", "elus", "karp", "pärl"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ostra"),
            keywords: &["ostra", "perla", "urpekaritza"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("صدف خوراکی"),
            keywords: &["شیرجه", "صدف خوراکی", "مروارید"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("osteri"),
            keywords: &["helmi", "osteri", "sukellus"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("talaba"),
            keywords: &["pagsisid", "perlas", "talaba"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("ostra"),
            keywords: &["dýr", "ostra", "perla"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("huître"),
            keywords: &["coquille", "huître", "mollusque", "perle"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("oisre"),
            keywords: &["oisre", "péarla", "tumadóireacth"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("eisir"),
            keywords: &["daibheadh", "daoibhigeadh", "eisir", "neamhnaid"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("ostra"),
            keywords: &["marisco", "molusco", "ostra", "perla"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઑઇસ\u{acd}ટર"),
            keywords: &["ઑઇસ\u{acd}ટર", "ડાઇવિ\u{a82}ગ", "મોતી"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("צדפה"),
            keywords: &["אויסטר", "חלזונות", "צדפה", "צדפות", "שבלולים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सीप"),
            keywords: &["गोताखोरी", "घो\u{902}घा", "मोती", "सीप"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kamenica"),
            keywords: &["biser", "izroniti", "kamenica", "školjka"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("osztriga"),
            keywords: &["búvárkodás", "gyöngy", "osztriga"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ոստրե"),
            keywords: &["խեցի", "մարգարիտ", "ոստրե", "սուզում"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tiram"),
            keywords: &["menyelam", "mutiara", "tiram"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ostra"),
            keywords: &["köfun", "ostra", "perla"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("ostrica"),
            keywords: &["ostrea", "ostrica", "perla"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("牡蠣"),
            keywords: &[
                "オイスター",
                "カキ",
                "シーフード",
                "牡蠣",
                "生ガキ",
                "貝",
                "魚介",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tiram"),
            keywords: &["mutiyara", "nyelam", "tiram"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ხამანწკა"),
            keywords: &["მარგალიტი", "ყვინთვა", "ხამანწკა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("устрица"),
            keywords: &["дайвинг", "маржан", "устрица"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("អ\u{17d0}រស\u{17d2}ទ\u{17d0}រ"),
            keywords: &[
                "ការម\u{17bb}ជទ\u{17b9}ក",
                "គ\u{17bb}ជខ\u{17d2}យង",
                "អ\u{17d0}រស\u{17d2}ទ\u{17d0}រ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{cbf}ಂಪ\u{cbf}"),
            keywords: &["ಡೈವ\u{cbf}ಂಗ\u{ccd}", "ಮುತ\u{ccd}ತು", "ಸ\u{cbf}ಂಪ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("굴"),
            keywords: &["굴", "진주"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("शिनाण\u{947}\u{902}"),
            keywords: &["चकचकीत", "मोती", "शिनाणी\u{902}", "शिनाण\u{947}\u{902}"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("устрица"),
            keywords: &["бермет", "суу астында сүзүү", "устрица"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫອຍ\u{200b}ນາງ\u{200b}ລ\u{ebb}ມ"),
            keywords: &[
                "ນ\u{ec9}ຳ\u{200b}ເລ\u{eb4}ກ",
                "ຫອຍ",
                "ຫອຍ\u{200b}ນາງ\u{200b}ລ\u{ebb}ມ",
                "ໄຂ\u{ec8}\u{200b}ມ\u{eb8}ກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("austrė"),
            keywords: &["austrė", "nardymas", "perlas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("austere"),
            keywords: &["austere", "niršana", "pērle"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("острига"),
            keywords: &["бисер", "нуркање", "острига", "школка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മ\u{d41}ത\u{d4d}ത\u{d41}ച\u{d4d}ചിപ\u{d4d}പി"),
            keywords: &[
                "ഡൈവിംഗ\u{d4d}",
                "മ\u{d41}ത\u{d4d}ത\u{d41}ച\u{d4d}ചിപ\u{d4d}പി",
                "മ\u{d41}ത\u{d4d}ത\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хясаа"),
            keywords: &["сувд", "хясаа"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("शि\u{902}पला"),
            keywords: &["ड\u{941}बकी", "मोती", "शि\u{902}पला"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tiram"),
            keywords: &["menyelam", "mutiara", "tiram"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကမာ"),
            keywords: &[
                "ကမာ",
                "ပ\u{102f}လ\u{1032}",
                "ရေင\u{102f}ပ\u{103a}ခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("østers"),
            keywords: &["dykking", "perle", "østers"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ओइस\u{94d}टर"),
            keywords: &["ओइस\u{94d}टर", "डाइभिङ", "पर\u{94d}ल"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("oester"),
            keywords: &["duiken", "oester", "parel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("østers"),
            keywords: &["dykking", "perle", "østers"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଶ\u{b3e}ମ\u{b41}କ\u{b3e}"),
            keywords: &[
                "ଡ\u{b3e}ଇଭ\u{b3f}ଙ\u{b4d}ଗ",
                "ମ\u{b41}କ\u{b4d}ତ\u{b3e}",
                "ଶ\u{b3e}ମ\u{b41}କ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਿ\u{a71}ਪ"),
            keywords: &["ਗ\u{a4b}ਤਾਖ\u{a4b}ਰੀ", "ਮ\u{a4b}ਤੀ", "ਸਿ\u{a71}ਪ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ọísta"),
            keywords: &["Daívín Ínsaíd Wọtá", "Pẹal", "Ọísta"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("ostryga"),
            keywords: &["małże", "nurkowanie", "ostryga", "perły"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سمندري صدف"),
            keywords: &["سمندري صدف", "غوپه وهل", "مرواري"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("ostra"),
            keywords: &["mergulho", "ostra", "pérola"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("ostra"),
            keywords: &["buceo", "ostra", "perla"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("stridie"),
            keywords: &["perlă", "scufundare", "stridie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–033"),
            keywords: &["E12–033"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("устрица"),
            keywords: &[
                "жемчуг",
                "жемчужина",
                "раковина",
                "ракушка",
                "устрица",
                "устричный",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اوئيسٽر"),
            keywords: &["اوئيسٽر", "پرل", "ڊائيونگ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බෙල\u{dca}ල\u{dcf}"),
            keywords: &[
                "ක\u{dd2}ම\u{dd2}ද\u{dd3}ම",
                "බෙල\u{dca}ල\u{dcf}",
                "ම\u{dd4}ත\u{dd4} ඇටය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ustrica"),
            keywords: &["perla", "potápanie", "ustrica"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ostriga"),
            keywords: &["biser", "ostriga", "potapljanje", "školjka"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("lohod"),
            keywords: &["lohod", "luul", "quusidda"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gocë deti"),
            keywords: &["gjallesë ujore", "gocë deti", "perlë", "zhytje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("острига"),
            keywords: &["бисер", "острига", "роњење"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ostriga"),
            keywords: &["biser", "ostriga", "ronjenje"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ostron"),
            keywords: &["dyka", "ostron", "pärlor"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("chaza"),
            keywords: &["chaza", "kupiga mbizi", "lulu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சிப\u{bcd}பி உணவு வகை"),
            keywords: &[
                "கடல\u{bcd} வ\u{bbe}ழ\u{bcd} உயிரினம\u{bcd}",
                "சிப\u{bcd}பி உணவு வகை",
                "முத\u{bcd}து",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఆయ\u{c46}స\u{c4d}టర\u{c4d}"),
            keywords: &[
                "ఆయ\u{c46}స\u{c4d}టర\u{c4d}",
                "డ\u{c48}వ\u{c3f}ంగ\u{c4d}",
                "ముత\u{c4d}యం",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หอยนางรม"),
            keywords: &["ดำน\u{e49}ำ", "หอยนางรม", "ไข\u{e48}ม\u{e38}ก"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ustrisa"),
            keywords: &["merjen", "ustrisa", "çümmek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tofe"),
            keywords: &["mataʻitofe", "tofe"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("istiridye"),
            keywords: &["dalma", "inci", "istiridye"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("устриця"),
            keywords: &["мушля", "перли", "перлина", "устриця", "устричний"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("صدفہ"),
            keywords: &["صدفہ", "غوطہ خوری", "موتی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("chigʻanoq"),
            keywords: &["chigʻanoq", "dayving", "marvarid", "shoʻngʻish"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hàu"),
            keywords: &["hàu", "lặn", "ngọc trai"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("生蠔"),
            keywords: &["潛水", "珍珠", "生蠔"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("生蚝"),
            keywords: &["潜水", "珍珠", "生蚝"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("牡蛎"),
            keywords: &["海鲜", "牡蛎", "珍珠", "生蚝"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("牡蠣"),
            keywords: &["潛水", "牡蠣", "珍珠"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("蠔"),
            keywords: &["潛水", "珍珠", "蠔"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-oyster"),
            keywords: &["i-oyster", "i-pearl", "ukudayiva"],
        },
    ],
};
