#[doc = "🍱"]
pub const BENTO_BOX: crate::Emoji = crate::Emoji {
    glyph: "🍱",
    codepoint: "1F371",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "bento box",
    group: "Food & Drink",
    subgroup: "food-asian",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("bentoboks"),
            keywords: &["bento", "bentoboks", "boks", "kos"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቤንቶ ቦክስ"),
            keywords: &["ሣጥን", "ቤንቶ", "ቤንቶ ቦክስ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("علبة طعام"),
            keywords: &["بنتو", "علبة طعام", "مطعم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বেণ\u{9cd}ট\u{9c1} বক\u{9cd}স"),
            keywords: &[
                "ব\u{9be}কচ",
                "বেণ\u{9cd}ট\u{9c1} বক\u{9cd}স",
                "বেন\u{9cd}ট\u{9c1}",
                "বেন\u{9cd}ট\u{9c1} বক\u{9cd}স",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("bentu qutusu"),
            keywords: &["bentu", "bentu qutusu", "qutu"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("бэнто"),
            keywords: &["бэнто", "скрыначка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Кутия за бенто"),
            keywords: &["Кутия за бенто", "бенто", "кутия"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বেন\u{9cd}তো ব\u{9be}ক\u{9cd}স"),
            keywords: &[
                "ব\u{9be}ক\u{9cd}স",
                "বেন\u{9cd}টো",
                "বেন\u{9cd}তো ব\u{9be}ক\u{9cd}স",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bento"),
            keywords: &["bento", "boest"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("bento kutija"),
            keywords: &["bento", "kutija"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("caixa de bento"),
            keywords: &["bento", "caixa", "caixa de bento"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏣᏱᏂᏏ ᎤᎵᏍᏓᏰᏗ"),
            keywords: &["ᎤᎵᏍᏓᏰᏗ", "ᏣᏱᏂᏏ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("krabička bentó"),
            keywords: &["bento", "krabička", "krabička bentó"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bocs bento"),
            keywords: &["bento", "bocs"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bento"),
            keywords: &["bento", "bentoboks", "boks"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Bento-Box"),
            keywords: &["Bento", "Bento-Box"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κουτί φαγητού"),
            keywords: &["κουτί", "κουτί φαγητού"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("bento box"),
            keywords: &["bento", "box"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("caja de bento"),
            keywords: &["bento", "caja", "caja de bento", "comida", "restaurante"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["caja de bento", "comida", "japonesa", "restaurante"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["bento", "caja", "caja de bento"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("bento einekarp"),
            keywords: &["bento einekarp", "karp", "toit"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bento kutxa"),
            keywords: &["bento", "kaxa", "kutxa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("جعبه بنتو"),
            keywords: &["بنتو", "جعبه", "غذا", "ژاپنی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("bento-rasia"),
            keywords: &["bento", "bento-rasia", "rasia"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bento box"),
            keywords: &["baon", "bento", "bento box", "pagkain"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("bento matpakki"),
            keywords: &["bento", "matpakki", "matur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("boîte déjeuner"),
            keywords: &["boîte", "déjeuner"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("boîte à bento"),
            keywords: &["bento", "boîte", "boîte à bento"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bosca bento"),
            keywords: &["bento", "bosca", "bosca lóin"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bogsa bento"),
            keywords: &["bento", "bogsa"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("caixa de bento"),
            keywords: &["bento", "caixa de bento", "comida xaponesa", "xaponés"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બ\u{ac7}ન\u{acd}ટો બોક\u{acd}સ"),
            keywords: &[
                "બ\u{ac7}ન\u{acd}ટો",
                "બોક\u{acd}સ",
                "ર\u{ac7}સ\u{acd}ટોરન\u{acd}ટ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("akwatin bento"),
            keywords: &["akwati", "akwatin bento", "bento"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חמגשית עם אוכל"),
            keywords: &["אוכל", "חמגשית", "חמגשית עם אוכל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ब\u{948}\u{902}टो, ब\u{948}\u{902}टो बॉक\u{94d}स"),
            keywords: &[
                "ब\u{948}\u{902}टो",
                "ब\u{948}\u{902}टो, ब\u{948}\u{902}टो बॉक\u{94d}स",
                "बॉक\u{94d}स",
                "र\u{947}स\u{94d}टोर\u{947}\u{902}ट",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("bento kutija"),
            keywords: &["bento", "japan", "kutija"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("japán ételdoboz"),
            keywords: &["bento", "japán ételdoboz", "ételdoboz"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բենտո արկղիկ"),
            keywords: &["արկղիկ", "բենտո"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kotak bento"),
            keywords: &["bento", "kotak"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("efere ntinye nri"),
            keywords: &["efere", "efere ntinye nri", "ntinye nri"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("bento-box"),
            keywords: &["bento-box", "nesti", "nestisbox"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("bento box"),
            keywords: &["bento box", "lunch box", "monoporzione", "ristorante"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("弁当"),
            keywords: &["幕の内", "弁当", "駅弁"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sakothak bento"),
            keywords: &["bento", "kothak", "sakothak bento"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბენტო"),
            keywords: &["ბენტო", "ყუთი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("обенто"),
            keywords: &["жәшік", "обенто"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("bento"),
            keywords: &["bento", "bentoboks", "boks"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17d2}រអប\u{17cb}ដាក\u{17cb}បាយន\u{17b7}ងម\u{17d2}ហ\u{17bc}ប"),
            keywords: &[
                "ប\u{17d2}រអប\u{17cb}",
                "ប\u{17d2}រអប\u{17cb}ដាក\u{17cb}បាយន\u{17b7}ងម\u{17d2}ហ\u{17bc}ប",
                "ប\u{17d2}រអប\u{17cb}បាយជប\u{17c9}\u{17bb}ន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{cc6}ಂಟೊ ಬಾಕ\u{ccd}ಸ\u{ccd}"),
            keywords: &["ಬ\u{cc6}ಂಟೊ", "ಬ\u{cc6}ಂಟೊ ಬಾಕ\u{ccd}ಸ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("도시락"),
            keywords: &["도시락", "밥", "벤또"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ब\u{901}टो बॉक\u{94d}स"),
            keywords: &["ब\u{901}टो", "बॉक\u{94d}स"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бенто кутусу"),
            keywords: &["бенто", "бенто кутусу", "куту"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Bento-Box"),
            keywords: &["Bento", "Bento-Box", "Box", "Këscht"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເບ\u{eb1}ນໂຕະ"),
            keywords: &["ກ\u{ec8}ອງ", "ເບ\u{eb1}ນໂຕະ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("bento dėžutė"),
            keywords: &["bento", "dėžutė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("bento kastīte"),
            keywords: &["bento", "kastīte"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pouaka peneto"),
            keywords: &["pouaka peneto"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("јапонска храна за носење"),
            keywords: &["храна", "јапонска", "јапонска храна за носење"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ബെന\u{d4d}റോ ബോക\u{d4d}\u{200c}സ\u{d4d}"),
            keywords: &[
                "ബെന\u{d4d}റോ",
                "ബെന\u{d4d}റോ ബോക\u{d4d}\u{200c}സ\u{d4d}",
                "ഭക\u{d4d}ഷണം",
                "ഹോട\u{d4d}ടൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("өдрийн хоол"),
            keywords: &["сав", "өдрийн хоол"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ब\u{947}\u{902}टो बॉक\u{94d}स"),
            keywords: &["ब\u{947}\u{902}टो", "बॉक\u{94d}स"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kotak bento"),
            keywords: &["bento", "kotak"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("bento box"),
            keywords: &["bento", "box"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဘင\u{103a}တ\u{102d}\u{102f} ဘ\u{1030}း"),
            keywords: &[
                "ထမင\u{103a}းဘ\u{1030}း",
                "ဘင\u{103a}တ\u{102d}\u{102f} ဘ\u{1030}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bento-boks"),
            keywords: &["bento", "bento-boks", "boks", "matboks"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ब\u{947}न\u{94d}टो बक\u{94d}स"),
            keywords: &["बक\u{94d}स", "ब\u{947}न\u{94d}टो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bentobox"),
            keywords: &["bento", "bentobox", "box"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bento-boks"),
            keywords: &["bento", "bento-boks", "boks", "matboks"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବେଣ\u{b4d}ଟୋ ବକ\u{b4d}ସ"),
            keywords: &["ବକ\u{b4d}ସ", "ବେଣ\u{b4d}ଟୋ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a47}\u{a02}ਟ\u{a4b} ਬਾਕਸ"),
            keywords: &["ਬਾਕਸ", "ਬ\u{a47}\u{a02}ਟ\u{a4b}", "ਹ\u{a4b}ਟਲ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بینٹو دا ڈبہ"),
            keywords: &["بینٹو", "بینٹو دا ڈبہ", "ڈبہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bẹ\u{301}nto Bọks"),
            keywords: &["Bẹ\u{301}nto", "Bọks"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pudełko bento"),
            keywords: &["bento", "pudełko bento"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د بینټو بکس"),
            keywords: &["د بینټو بکس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bentô"),
            keywords: &["bentô", "caixa", "caixa de bentô"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("caixa de refeições"),
            keywords: &["caixa", "caixa de refeições", "refeições"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("bento tawakʼuchu"),
            keywords: &["bento", "tawakʼuchu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("mâncare japoneză la pachet"),
            keywords: &[
                "bento",
                "japonia",
                "mâncare",
                "mâncare japoneză la pachet",
                "pachet",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-310"),
            keywords: &["E10-310"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("бэнто"),
            keywords: &["бенто", "бэнто"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("agakarito k’isahani"),
            keywords: &["agakarito", "k’isahani"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("کاڌي جو ڏٻو"),
            keywords: &["کاڌي جو ڏٻو", "کاڌي جو ڏٻو، ڏٻو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බෙන\u{dca}ටෝ පෙට\u{dca}ට\u{dd2}ය"),
            keywords: &["පෙට\u{dca}ට\u{dd2}ය", "බෙන\u{dca}ටෝ"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("krabička na jedlo"),
            keywords: &["krabička na jedlo", "škatuľka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("posoda za malico bento"),
            keywords: &[
                "bento",
                "japonsko",
                "malica",
                "posoda",
                "posoda za malico bento",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("sanduuq qado"),
            keywords: &["sanduuq qado", "suuq qado"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kuti bento"),
            keywords: &["bento", "kuti"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кутија са ручком"),
            keywords: &["jaпaн", "кутиja", "кутија са ручком", "ручак"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kutija sa ručkom"),
            keywords: &["japan", "kutija", "kutija sa ručkom", "ručak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("bentolåda"),
            keywords: &["bento", "bentolåda", "låda"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("boksi ya kuweka chakula"),
            keywords: &["bento", "boksi", "boksi ya kuweka chakula"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பென\u{bcd}டோ ப\u{bbe}க\u{bcd}ஸ\u{bcd}"),
            keywords: &[
                "உணவகம\u{bcd}",
                "பெட\u{bcd}டி",
                "பென\u{bcd}டோ ப\u{bbe}க\u{bcd}ஸ\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బ\u{c46}ంట\u{c4b} ప\u{c46}ట\u{c4d}ట\u{c46}"),
            keywords: &[
                "జపన\u{c40}స\u{c4d} భ\u{c4b}జన ప\u{c3e}ర\u{c4d}శ\u{c3f}ల\u{c4d} ప\u{c4d}ల\u{c47}టు",
                "బ\u{c46}ంట\u{c4b}",
                "బ\u{c46}ంట\u{c4b} ప\u{c46}ట\u{c4d}ట\u{c46}",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("қуттии бенто"),
            keywords: &["бенто", "қуттии бенто", "қуттӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("กล\u{e48}องเบนโตะ"),
            keywords: &["กล\u{e48}องเบนโตะ", "เบนโตะ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("bento gutusy"),
            keywords: &["bento", "bento gutusy", "guty"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("puha meʻakai fakasiapani"),
            keywords: &["puha meʻakai fakasiapani"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("bento"),
            keywords: &["bento", "bento paketi", "paket", "restoran"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئەپلىك ئاش"),
            keywords: &["ئاش", "ئەپلىك ئاش", "قاچا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("обід у коробці"),
            keywords: &["бенто", "обід у коробці", "упаковка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بنٹو باکس"),
            keywords: &["بنٹو", "بنٹو باکس", "ڈبہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("xonachali taom qutisi"),
            keywords: &["quti", "xonachali", "xonachali taom qutisi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hộp cơm bento"),
            keywords: &["cơm bento", "hộp", "hộp cơm bento"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("boyetu bento"),
            keywords: &["bento", "boyetu"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhokisi ye-bento"),
            keywords: &["i-bento", "ibhokisi", "ibhokisi ye-bento"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Apoti Bento"),
            keywords: &["Apoti", "Bento"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("便當"),
            keywords: &["便當", "盒"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("便当"),
            keywords: &["便当", "盒"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("盒饭"),
            keywords: &["便当", "盒饭"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("便當"),
            keywords: &["便當"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("飯盒"),
            keywords: &["便當", "飯盒"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibento bhoksi"),
            keywords: &["ibento", "ibento bhoksi", "ibhoksi"],
        },
    ],
};
#[doc = "🍘"]
pub const RICE_CRACKER: crate::Emoji = crate::Emoji {
    glyph: "🍘",
    codepoint: "1F358",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "rice cracker",
    group: "Food & Drink",
    subgroup: "food-asian",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("rysbeskuitjie"),
            keywords: &["beskuitjie", "kos", "rys", "rysbeskuitjie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሩዝ ብስኩት"),
            keywords: &["ሩዝ", "ብስኩት", "የሩዝ ብስኩት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مقرمشات أرز"),
            keywords: &["أرز", "قراقيش أرز", "مقرمشات أرز"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চ\u{9be}উল খ\u{9c1}ন\u{9cd}দ\u{9be} খ\u{9c1}ন\u{9cd}দন\u{9be}"),
            keywords: &[
                "খ\u{9c1}ন\u{9cd}দন\u{9be}",
                "চ\u{9be}উল",
                "চ\u{9be}উল খ\u{9c1}ন\u{9cd}দ\u{9be} খ\u{9c1}ন\u{9cd}দন\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("düyü krekeri"),
            keywords: &["düyü", "düyü krekeri", "kreker"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("рысавае пячэнне"),
            keywords: &[
                "печыва",
                "пячэнне",
                "рыс",
                "рысавае печыва",
                "рысавае пячэнне",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Оризов крекер"),
            keywords: &["Оризов крекер", "крекер", "ориз"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চ\u{9be}লের প\u{9be}পড\u{9bc}"),
            keywords: &[
                "ক\u{9cd}র\u{9cd}য\u{9be}ক\u{9be}র",
                "চ\u{9be}ল",
                "চ\u{9be}লের প\u{9be}পড\u{9bc}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("galetez riz"),
            keywords: &["galetez", "riz"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kreker od riže"),
            keywords: &["kreker", "kreker od riže"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("galeta d’arròs"),
            keywords: &["arròs", "galeta", "galeta d’arròs"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏓᎵᏆ ᎦᏚ ᎤᏍᏓᎬᏴᎯᏓ"),
            keywords: &["ᎦᏚ ᎤᏍᏓᎬᏴᎯᏓ", "ᏓᎵᏆ", "ᏓᎵᏆ ᎦᏚ ᎤᏍᏓᎬᏴᎯᏓ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("rýžová sušenka"),
            keywords: &["rýže", "rýžová sušenka", "sušenka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cracer reis"),
            keywords: &["cracer", "reis"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("riskiks"),
            keywords: &["kiks", "riskiks"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Reiscracker"),
            keywords: &["Cracker", "Reiscracker"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κράκερ ρυζιού"),
            keywords: &["κράκερ ρυζιού", "μπισκότο", "ρύζι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("rice cracker"),
            keywords: &["cracker", "rice"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("galleta de arroz"),
            keywords: &["arroz", "galleta", "galleta de arroz"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["arroz", "galleta", "galleta de arroz"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("riisiküpsis"),
            keywords: &["leib", "riis", "riisiküpsis"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("arroz-mokadua"),
            keywords: &["arroz", "arroz-mokadua", "mokadu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تردک برنجی"),
            keywords: &["برنج", "تردک", "تردک برنجی", "کراکر"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("riisikakku"),
            keywords: &["keksi", "riisi", "riisikakku"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("rice cracker"),
            keywords: &["ampao", "ampaw", "kanin", "pagkain", "rice cracker"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("ríssmákaka"),
            keywords: &["kaka", "matur", "rís", "ríssmákaka", "smákaka"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("galette de riz"),
            keywords: &["cracker", "galette de riz", "riz"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("craquelin de riz"),
            keywords: &["craquelin", "craquelin de riz", "riz"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("craicear ríse"),
            keywords: &["craicear", "craicear ríse"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cracair rìs"),
            keywords: &["cracair", "rìs"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("galleta de arroz"),
            keywords: &["arroz", "comida xaponesa", "galleta", "galleta de arroz"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચોખાની કકરી બિસ\u{acd}કીટ"),
            keywords: &[
                "ચોખા",
                "ચોખાની કકરી બિસ\u{acd}કીટ",
                "ચોખાની\u{a0}કકરી બિસ\u{acd}કીટ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("biskit na shinkafa"),
            keywords: &["biskit", "biskit na shinkafa", "shinkafa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פריכית אורז"),
            keywords: &["אורז", "פריכיות", "פריכית אורז"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("राइस क\u{94d}र\u{948}कर"),
            keywords: &["चावल", "राइस क\u{94d}र\u{948}कर"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("keks od riže"),
            keywords: &["keks", "keks od riže", "riža"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("rizskeksz"),
            keywords: &["japán", "keksz", "rizs", "rizskeksz"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բրնձի կրեկեր"),
            keywords: &["բրինձ", "բրնձի կրեկեր", "կրեկեր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kerupuk beras"),
            keywords: &["beras", "biskuit", "kerupuk beras"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("achịcha òsìkapa"),
            keywords: &["achịcha", "òsìkapa"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hrísgrjónakex"),
            keywords: &["hrísgrjón", "hrísgrjónakex", "kex"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("galletta di riso"),
            keywords: &["galletta di riso", "riso"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("せんべい"),
            keywords: &["お菓子", "せんべい"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rengginan"),
            keywords: &["krupuk", "rengginan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბრინჯის ორცხობილა"),
            keywords: &[
                "ბრინჯი",
                "ბრინჯის ორცხობილა",
                "კრეკერი",
                "ნამცხვარი",
                "ორცხობილა",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("күріштен жасалған крекер"),
            keywords: &["крекер", "күріш", "күріштен жасалған крекер"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("riskiks"),
            keywords: &["kiks", "riskiks"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ន\u{17c6}ស\u{17d2}រ\u{17bd}យ"),
            keywords: &["ន\u{17c6}", "ន\u{17c6}ស\u{17d2}រ\u{17bd}យ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಅಕ\u{ccd}ಕ\u{cbf} ಕ\u{ccd}ರ\u{ccd}ಯಾಕರ\u{ccd}"),
            keywords: &[
                "ಅಕ\u{ccd}ಕ\u{cbf}",
                "ಅಕ\u{ccd}ಕ\u{cbf} ಕ\u{ccd}ರ\u{ccd}ಯಾಕರ\u{ccd}",
                "ಒಡ\u{cc6}ದ ಅಕ\u{ccd}ಕ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("주먹밥"),
            keywords: &["밥", "주먹밥"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ता\u{902}दळाचो वडो"),
            keywords: &["ता\u{902}दळ", "ता\u{902}दळाचो वडो", "वडो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("күрүч крекери"),
            keywords: &["крекер", "күрүч", "күрүч крекери"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Räiskichelcher"),
            keywords: &["Kichelchen", "Räis", "Räiskichelcher"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຂ\u{ebb}\u{ec9}າໜ\u{ebb}ມເຂ\u{ebb}\u{ec9}າ"),
            keywords: &[
                "ເຂ\u{ebb}\u{ec9}າ",
                "ເຂ\u{ebb}\u{ec9}າໜ\u{ebb}ມ",
                "ເຂ\u{ebb}\u{ec9}າໜ\u{ebb}ມເຂ\u{ebb}\u{ec9}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("ryžių paplotėlis"),
            keywords: &["paplotėlis", "ryžių"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("rīsu galete"),
            keywords: &["galete", "rīsi", "rīsu galete"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pihikete raihi"),
            keywords: &["pihikete", "raihi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("колачи од ориз"),
            keywords: &["бисквит", "колаче", "колачи од ориз", "ориз"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("റൈസ\u{d4d} ക\u{d4d}ര\u{d3e}ക\u{d4d}കർ"),
            keywords: &[
                "അരി",
                "ആഹ\u{d3e}രം",
                "ഭക\u{d4d}ഷണം",
                "റൈസ\u{d4d} ക\u{d4d}ര\u{d3e}ക\u{d4d}കർ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("будааны жигнэмэг"),
            keywords: &["будаа", "будааны жигнэмэг", "жигнэмэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("राइस क\u{94d}र\u{945}कर"),
            keywords: &["क\u{94d}र\u{945}कर", "भात", "राइस क\u{94d}र\u{945}कर"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("keropok beras"),
            keywords: &["beras", "keropok"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("rice cracker"),
            keywords: &["craker", "rice cracker", "ross"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ထမင\u{103a}းခြောက\u{103a}မ\u{102f}န\u{1037}\u{103a}"),
            keywords: &[
                "ခရက\u{103a}ကာ",
                "ထမင\u{103a}းခြောက\u{103a}မ\u{102f}န\u{1037}\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("riskjeks"),
            keywords: &["kjeks", "ris", "riskjeks"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("राइस क\u{94d}र\u{94d}याकर"),
            keywords: &["क\u{94d}र\u{94d}याकर", "राइस"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("rijstwafel"),
            keywords: &["cracker", "rijst", "rijstwafel"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("riskjeks"),
            keywords: &["kjeks", "ris", "riskjeks"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଚ\u{b3e}ଉଳ ମ\u{b41}ଡ\u{b3c}କ\u{b3f}"),
            keywords: &[
                "ଚ\u{b3e}ଉଳ ମ\u{b41}ଡ\u{b3c}କ\u{b3f}",
                "ଭ\u{b3e}ତ",
                "ମ\u{b41}ଡ\u{b3c}କ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚ\u{a4c}ਲਾ\u{a02} ਤ\u{a4b}\u{a02} ਬਣੀ ਚੀਜ\u{a3c}"),
            keywords: &[
                "ਚ\u{a4c}ਲ",
                "ਚ\u{a4c}ਲਾ\u{a02} ਤ\u{a4b}\u{a02} ਬਣੀ ਚੀਜ\u{a3c}",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("خستہ چولاں آلا بسکٹ"),
            keywords: &["خستہ بسکٹ", "خستہ چولاں آلا بسکٹ", "چول"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Raís Krákas"),
            keywords: &["Krákas", "Rais", "Raís Krákas"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("krakers ryżowy"),
            keywords: &["krakers", "ryż", "ryżowy"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د وريجو کريکر"),
            keywords: &["د وريجو کريکر", "کريکر، وريجې"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("biscoito de arroz"),
            keywords: &["arroz", "biscoito de arroz", "cracker"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("bolacha de arroz"),
            keywords: &["arroz", "bolacha", "bolacha de arroz"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("galleta arrozmanta"),
            keywords: &["arroz", "galleta", "galleta arrozmanta"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("biscuit de orez"),
            keywords: &["biscuit", "biscuit de orez", "orez"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-285"),
            keywords: &["E10-285"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("рисовый крекер"),
            keywords: &["крекер", "рис", "рисовый крекер"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("koroka ikoze mu muceri"),
            keywords: &["koroka ikoze", "koroka ikoze mu muceri", "mu muceri"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("چانور جو بسڪيٽ"),
            keywords: &["چانور جو بسڪيٽ", "چانور جو بسڪيٽ، چانور"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සහල\u{dca} ව\u{dd2}ස\u{dca}කෝත\u{dd4}ව"),
            keywords: &["ව\u{dd2}ස\u{dca}කෝත\u{dd4}ව", "සහල\u{dca}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ryžová sušienka"),
            keywords: &["kreker", "ryža", "ryžová sušienka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("rižev kreker"),
            keywords: &["kreker", "riž", "rižev kreker"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qubka bariis"),
            keywords: &["bariis", "qubka"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("biskotë me oriz"),
            keywords: &["biskotë", "biskotë me oriz", "oriz"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("крекер од пиринча"),
            keywords: &["кeкс", "крекер од пиринча", "пиринач"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("крекер од риже"),
            keywords: &["крекер од риже"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kreker od pirinča"),
            keywords: &["keks", "kreker od pirinča", "pirinač"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("kreker od riže"),
            keywords: &["kreker od riže"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("riskaka"),
            keywords: &["kex", "ris", "riskaka"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("biskuti za mchele"),
            keywords: &[
                "biskuti za mchele",
                "chakula kilichotengenezwa kutoka kwa mchele",
                "mchele",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ரைஸ\u{bcd} கிர\u{bbe}க\u{bcd}கர\u{bcd}"),
            keywords: &["அரிசி", "ரைஸ\u{bcd} கிர\u{bbe}க\u{bcd}கர\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ర\u{c48}స\u{c4d} క\u{c4d}ర\u{c3e}కర\u{c4d}"),
            keywords: &[
                "బ\u{c3f}య\u{c4d}యం",
                "ర\u{c48}స\u{c4d} క\u{c4d}ర\u{c3e}కర\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("брекери биринҷӣ"),
            keywords: &["биринҷ", "брекери биринҷӣ", "крекер"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ข\u{e49}าวอบกรอบ"),
            keywords: &["ข\u{e49}าวอบกรอบ", "แครกเกอร\u{e4c}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("tüwi kreker"),
            keywords: &["kreker", "tüwi"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pisikete laise"),
            keywords: &["pisikete laise"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("pirinç gevreği"),
            keywords: &["pirinç", "pirinç gevreği"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("گۈرۈچ ئېتىلدۇرمىسى"),
            keywords: &["ئېتىلدۇرما", "گۈرۈچ", "گۈرۈچ ئېتىلدۇرمىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("рисовий крекер"),
            keywords: &["крекер", "рис", "рисовий крекер"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چاولوں کے پاپڑ"),
            keywords: &["پاپڑ", "چاول", "چاولوں کے پاپڑ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("guruchli pishiriq"),
            keywords: &["guruch", "guruchli pishiriq", "kreker"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bánh gạo"),
            keywords: &["bánh gạo", "bánh quy giòn", "gạo"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("gato ceeb"),
            keywords: &["ceeb", "gato"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-rice cracker"),
            keywords: &["i-cracker", "i-rice cracker", "irayisi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Biskit Irẹsi"),
            keywords: &["Biskit Irẹsi", "bisikí", "ìrẹ\u{300}sì"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("米餅"),
            keywords: &["米", "米餅", "餅"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("米饼"),
            keywords: &["米", "米饼", "饼"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("米饼"),
            keywords: &["米果", "米饼"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("米果"),
            keywords: &["仙貝", "米果"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("米餅"),
            keywords: &["仙貝", "米果", "米餅"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("irice cracker"),
            keywords: &["icracker", "ilayisi", "irice cracker"],
        },
    ],
};
#[doc = "🍙"]
pub const RICE_BALL: crate::Emoji = crate::Emoji {
    glyph: "🍙",
    codepoint: "1F359",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "rice ball",
    group: "Food & Drink",
    subgroup: "food-asian",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("rysbal"),
            keywords: &["bal", "japannees", "kos", "rys", "rysbal"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሩዝ ኳስ"),
            keywords: &["ሩዝ", "ኳስ", "የሩዝ ኳስ", "የጃፓን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كرة أرز"),
            keywords: &["أرز", "كرة أرز", "مطعم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চ\u{9be}উলৰ বল"),
            keywords: &["চ\u{9be}উল", "চ\u{9be}উলৰ বল", "জ\u{9be}প\u{9be}নিজ", "বল"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("düyü küftəsi"),
            keywords: &["düyü", "düyü küftəsi", "küftə", "yapon"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("рысавы шарык"),
            keywords: &["рыс", "рысавы шарык", "шарык", "японскі"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Топка ориз"),
            keywords: &["Топка ориз", "ориз", "топка", "японски"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ভ\u{9be}তের বল"),
            keywords: &["চ\u{9be}ল", "জ\u{9be}প\u{9be}নি", "বল", "ভ\u{9be}তের বল"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("boulig riz"),
            keywords: &["boulig", "riz"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kugla od riže"),
            keywords: &["japanska", "kugla", "kugla od riže", "riža"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bola d’arròs"),
            keywords: &["arròs", "bola", "bola d’arròs"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄞𑄖\u{11134} 𑄉𑄟𑄣"),
            keywords: &["𑄞𑄖\u{11134} 𑄉𑄟𑄣"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏓᎵᏆ ᏍᏆᏞᏍᏗ"),
            keywords: &["ᏍᏆᏞᏍᏗ", "ᏓᎵᏆ", "ᏣᏱᏂᏏ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("rýžová koule"),
            keywords: &["japonská", "kulička", "onigiri", "rýžová", "rýžová koule"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("pêl reis"),
            keywords: &["Japaneaidd", "pêl", "reis"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("riskugle"),
            keywords: &["onigiri", "ris", "riskugle"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Reisbällchen"),
            keywords: &["Reis", "Reisbällchen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μπάλα ρυζιού"),
            keywords: &["ιαπωνικό", "μπάλα", "μπάλα ρυζιού", "ρύζι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("rice ball"),
            keywords: &["Japanese", "ball", "rice"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bola de arroz"),
            keywords: &[
                "arroz",
                "bola de arroz",
                "japonés",
                "onigiri",
                "restaurante",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "arroz",
                "bola de arroz",
                "comida",
                "japonesa",
                "onigiri",
                "restaurante",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["arroz", "bola", "bola de arroz", "japonesa"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("riisipall"),
            keywords: &["pall", "riis", "riisipall"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("arroz-bola"),
            keywords: &["arroz", "arroz-bola", "bola", "japonia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کوفته برنجی"),
            keywords: &["برنج", "توپ", "ژاپنی", "کوفته", "کوفته برنجی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("riisipallo"),
            keywords: &["japanilainen", "pallo", "riisi", "riisipallo"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("rice ball"),
            keywords: &[
                "japanese",
                "kanin",
                "o-nigiri",
                "onigiri",
                "pagkain",
                "rice ball",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("rísbolli"),
            keywords: &["bolli", "matur", "rís", "rísbolli"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("boulette de riz"),
            keywords: &["boulette de riz", "japonais", "onigiri", "plat", "riz"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["boulette", "boulette de riz", "riz"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("liathróid ríse"),
            keywords: &["liathróid ríse", "rís"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ball rìs"),
            keywords: &["ball", "iapanach", "rìs", "seapanach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("bola de arroz"),
            keywords: &["arroz", "bola de arroz", "comida xaponesa"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ભાતના\u{a82} વડા"),
            keywords: &[
                "ઓનિગિરી",
                "ભાતના\u{a82} વડા",
                "ર\u{ac7}સ\u{acd}ટોરન\u{acd}ટ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("curin shinkafa"),
            keywords: &["Na japan", "curi", "curin shinkafa", "shinkafa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כדור אורז"),
            keywords: &["אורז", "יפני", "כדור"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("राइस बॉल"),
            keywords: &[
                "ओनिगिरी",
                "चावल",
                "राइस बॉल",
                "र\u{947}स\u{94d}टोर\u{947}\u{902}ट",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kuglica od riže"),
            keywords: &["japan", "kuglica", "kuglica od riže", "riža"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("rizsgolyó"),
            keywords: &["golyó", "japán", "rizs", "rizsgolyó"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բրնձի գնդիկ"),
            keywords: &["բրինձ", "բրնձի գնդիկ", "գնդիկ", "ճապոնական"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("nasi kepal"),
            keywords: &["bola", "jepang", "nasi", "nasi kepal"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("òsìkapa àkpụrụakpụ"),
            keywords: &["akpụrụakpụ", "ndị Japan", "òsìkapa", "òsìkapa àkpụrụakpụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hrísgrjónabolla"),
            keywords: &["hrísgrjón", "hrísgrjónabolla", "onigiri"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("onigiri"),
            keywords: &[
                "arancino di riso giapponese",
                "onigiri",
                "polpetta di riso giapponese",
                "ristorante",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("おにぎり"),
            keywords: &["おにぎり", "おむすび", "米"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("themlek sega"),
            keywords: &["Jepang", "sega", "themlek"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბრინჯის ბურთი"),
            keywords: &["ბრინჯი", "ბრინჯის ბურთი", "ბურთი", "იაპონური"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("күріш шаригі"),
            keywords: &["доп", "жапон", "күріш", "күріш шаригі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("riskugle"),
            keywords: &["ris", "riskugle"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បាយព\u{17c6}ន\u{17bc}ត"),
            keywords: &[
                "ជប\u{17c9}\u{17bb}ន",
                "ដ\u{17bb}\u{17c6}បាយ",
                "បាយ",
                "បាយព\u{17c6}ន\u{17bc}ត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಅನ\u{ccd}ನದ ಉಂಡ\u{cc6}"),
            keywords: &[
                "ಅಕ\u{ccd}ಕ\u{cbf}",
                "ಅನ\u{ccd}ನದ ಉಂಡ\u{cc6}",
                "ಜಪಾನೀಸ\u{ccd}",
                "ಬಾಲ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("삼각 김밥"),
            keywords: &["밥", "삼각 김밥"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("शिताची उ\u{902}डी"),
            keywords: &[
                "उ\u{902}डी",
                "जपानी",
                "ता\u{902}द\u{942}ळ",
                "शिताची उ\u{902}डी",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("күрүч тобу"),
            keywords: &["жапончо", "күрүч", "күрүч тобу", "топ"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Räisball"),
            keywords: &["Ball", "Räis", "Räisball", "japanesch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຂ\u{ebb}\u{ec9}າປ\u{eb1}\u{ec9}ນ"),
            keywords: &[
                "ຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນ",
                "ເຂ\u{ebb}\u{ec9}າ",
                "ເຂ\u{ebb}\u{ec9}າປ\u{eb1}\u{ec9}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("ryžių rutuliukas"),
            keywords: &["japonų", "rutuliukas", "ryžiai", "ryžių rutuliukas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("rīsu bumbiņa"),
            keywords: &["bumbiņa", "japāņu", "rīsi", "rīsu bumbiņa"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pōro raihi"),
            keywords: &["Hapanīhi", "pōro", "raihi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("топки од ориз"),
            keywords: &["ориз", "топка", "топки од ориз", "јапонски"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("റൈസ\u{d4d} ബോൾ"),
            keywords: &[
                "അരി",
                "അരിയ\u{d41}ണ\u{d4d}ട",
                "ആഹ\u{d3e}രം",
                "ഭക\u{d4d}ഷണം",
                "റൈസ\u{d4d} ബോൾ",
                "ഹോട\u{d4d}ടൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("будааны ороомог"),
            keywords: &["Японы", "будаа", "будааны ороомог"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("राइस बॉल"),
            keywords: &["जपानी", "ता\u{902}द\u{942}ळ", "बॉल", "राइस बॉल"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bebola nasi"),
            keywords: &["bebola nasi", "beras", "bola", "jepun"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("pulpetta tar-ross"),
            keywords: &["ballun", "pulpetta tar-ross", "ross", "Ġappuniż"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ထမင\u{103a}းလ\u{102f}\u{1036}း"),
            keywords: &[
                "ဂျပန\u{103a}",
                "ထမင\u{103a}း",
                "ထမင\u{103a}းလ\u{102f}\u{1036}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("risball"),
            keywords: &["japansk", "onigiri", "restaurant", "ris", "risball"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("राइस बल"),
            keywords: &["जापानिज", "बल", "राइस"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("rijstballetje"),
            keywords: &["balletje", "japans", "rijst", "rijstballetje"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("risball"),
            keywords: &["japansk", "onigiri", "restaurant", "ris", "risball"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଭ\u{b3e}ତ ବର\u{b3e}"),
            keywords: &["ଜ\u{b3e}ପ\u{b3e}ନୀୟ", "ବର\u{b3e}", "ଭ\u{b3e}ତ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚ\u{a4c}ਲਾ\u{a02}\u{a02} ਦੀ ਪਿ\u{a70}ਨੀ"),
            keywords: &[
                "ਚ\u{a4c}ਲ",
                "ਚ\u{a4c}ਲਾ\u{a02}\u{a02} ਦੀ ਪਿ\u{a70}ਨੀ",
                "ਹ\u{a4b}ਟਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چولاں دیاں گینداں"),
            keywords: &["جاپانی", "چول", "چولاں دیاں گینداں", "گیند"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Raís Bọl"),
            keywords: &["Bọl", "Japan", "Rais", "Raís Bọl"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kulka ryżowa"),
            keywords: &["kulka ryżowa", "onigiri", "ryż"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د وريجو بال"),
            keywords: &["بال، جاپاني، وريجې", "د وريجو بال"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("arroz japonês"),
            keywords: &["arroz", "japonês", "onigiri"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("bola de arroz"),
            keywords: &["arroz", "bola de arroz", "bolinho", "japonês"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("muyu arrozwan"),
            keywords: &["Japones", "arroz", "muyu", "muyu arrozwan"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("chifteluțe de orez"),
            keywords: &[
                "Japonia",
                "chifteluțe",
                "chifteluțe de orez",
                "orez",
                "perișoare",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-286"),
            keywords: &["E10-286"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("онигири"),
            keywords: &["онигири", "рис", "шарик", "япония"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikibumbe cy’umuceri"),
            keywords: &["ikibumbe cy’umuceri", "nyapani", "umuceri", "umupira"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("چانور جو بال"),
            keywords: &["بال، جاپاني، چانور", "چانور جو بال"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("රය\u{dd2}ස\u{dca} බෝල\u{dca}"),
            keywords: &[
                "ජප\u{dcf}න",
                "බෝල",
                "රය\u{dd2}ස\u{dca} බෝල\u{dca}",
                "සහල\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kopček ryže"),
            keywords: &["kopček", "kopček ryže", "ryža"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("riževa kroglica"),
            keywords: &["japonsko", "kroglica", "riž", "riževa kroglica"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("bariis kubbad"),
            keywords: &["bariis", "jabbaanka", "kubbad"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("topth orizi"),
            keywords: &["japonez", "oriz", "top", "topth orizi"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("куглица од пиринча"),
            keywords: &["jaпaнска", "куглицa", "куглица од пиринча", "пиринач"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("куглица од риже"),
            keywords: &["куглица од риже"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kuglica od pirinča"),
            keywords: &["japanska", "kuglica", "kuglica od pirinča", "pirinač"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("kuglica od riže"),
            keywords: &["kuglica od riže"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("risboll"),
            keywords: &["ris", "risboll", "risportion"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mchele uliotengenezwa kwa mtindo wa tufe"),
            keywords: &[
                "kijapani",
                "mchele",
                "mchele uliotengenezwa kwa mtindo wa tufe",
                "mpira",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அரிசி பந\u{bcd}து"),
            keywords: &["அரிசி", "அரிசி பந\u{bcd}து", "உணவகம\u{bcd}", "உணவு"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ర\u{c48}స\u{c4d} బ\u{c3e}ల\u{c4d}"),
            keywords: &[
                "ఆన\u{c3f}గ\u{c3f}ర\u{c3f}",
                "బ\u{c3f}య\u{c4d}యం",
                "బ\u{c3f}య\u{c4d}యపు గ\u{c3f}న\u{c4d}న\u{c46}",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
                "ర\u{c48}స\u{c4d} బ\u{c3e}ల\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("курачаи биринҷӣ"),
            keywords: &["биринҷ", "курачаи биринҷӣ", "тӯб", "ҷопонӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ข\u{e49}าวป\u{e31}\u{e49}น"),
            keywords: &[
                "ก\u{e49}อนข\u{e49}าวป\u{e31}\u{e49}น",
                "ข\u{e49}าวป\u{e31}\u{e49}น",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("tüwi tokgasy"),
            keywords: &["tokga", "tüwi", "tüwi tokgasy", "ýapon"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("puluʻi laise"),
            keywords: &["puluʻi laise"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("pirinç topu"),
            keywords: &["onigiri", "pirinç", "pirinç topu", "restoran"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("گۈرۈچ توپ"),
            keywords: &["توپ", "ياپونچە", "گۈرۈچ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("рисова кулька"),
            keywords: &["кулька", "рис", "рисова кулька", "японський"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چاولوں کے بالز"),
            keywords: &["جاپانی", "چاول", "چاولوں کے بالز", "گیند"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yumaloqlangan guruch"),
            keywords: &["guruch", "shar", "yapon", "yumaloq", "yumaloqlangan guruch"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cơm nắm"),
            keywords: &["cơm", "cơm nắm", "nhật bản"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("balu ceeb"),
            keywords: &["Sapone", "ball", "balu ceeb", "ceeb"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhola yerayisi"),
            keywords: &["i-Japanese", "ibhola", "ibhola yerayisi", "irayisi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Irẹsi Roboto"),
            keywords: &["Irẹsi Roboto", "bọ\u{300}ọ\u{301}lú", "japanese", "ìrẹsì"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("飯團"),
            keywords: &["團", "日本", "飯", "飯團"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("饭团"),
            keywords: &["团", "日本", "饭", "饭团"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("饭团"),
            keywords: &["日本", "饭团"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("飯糰"),
            keywords: &["飯糰"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhala lelayisi"),
            keywords: &["ibhala", "ibhala lelayisi", "ilayisi", "japanese"],
        },
    ],
};
#[doc = "🍚"]
pub const COOKED_RICE: crate::Emoji = crate::Emoji {
    glyph: "🍚",
    codepoint: "1F35A",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "cooked rice",
    group: "Food & Drink",
    subgroup: "food-asian",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gekookte rys"),
            keywords: &["gekookte rys", "kook", "kos", "rys"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የተቀቀለ ሩዝ"),
            keywords: &["ሩዝ", "የበሰለ", "የተቀቀለ ሩዝ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("أرز مطبوخ"),
            keywords: &["أرز", "أرز مطبوخ", "مطعم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ভ\u{9be}ত"),
            keywords: &["চ\u{9be}উল", "ভ\u{9be}ত", "ৰন\u{9cd}ধ\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("bişmiş düyü"),
            keywords: &["bişmiş", "düyü"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("згатаваны рыс"),
            keywords: &["згатаваны", "правараны", "рыс"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Сготвен ориз"),
            keywords: &["Сготвен ориз", "ориз", "сготвен"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("র\u{9be}ন\u{9cd}ন\u{9be} কর\u{9be} ভ\u{9be}ত"),
            keywords: &[
                "চ\u{9be}ল",
                "র\u{9be}ন\u{9cd}ন\u{9be} কর\u{9be}",
                "র\u{9be}ন\u{9cd}ন\u{9be} কর\u{9be} ভ\u{9be}ত",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bolennad riz"),
            keywords: &["bolennad", "riz"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kuhana riža"),
            keywords: &["kuhana", "riža"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("arròs bullit"),
            keywords: &["arròs", "bullit"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄢𑄚\u{11133}𑄠\u{11134} 𑄞𑄖\u{11134}"),
            keywords: &["𑄢𑄚\u{11133}𑄠\u{11134} 𑄞𑄖\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏓᎵᏆ ᎬᏂᏍᏔᏅᎢ"),
            keywords: &["ᎬᏂᏍᏔᏅᎢ", "ᏓᎵᏆ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("vařená rýže"),
            keywords: &["rýže", "vařená rýže", "vařený"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("reis wedi’i goginio"),
            keywords: &["reis", "reis wedi’i goginio"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ris"),
            keywords: &["restaurant", "ris", "skål ris"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Reis in Schüssel"),
            keywords: &["Reis", "Reis in Schüssel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μαγειρεμένο ρύζι"),
            keywords: &["μαγειρεμένο", "ρύζι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("cooked rice"),
            keywords: &["cooked", "rice"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("arroz cocido"),
            keywords: &["arroz", "arroz cocido", "restaurante"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "arroz",
                "arroz cocido",
                "china",
                "comida",
                "japonesa",
                "restaurante",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["arroz", "cocido"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("keedetud riis"),
            keywords: &["keedetud", "riis"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("arroz egosia"),
            keywords: &["arroz", "arroz egosia", "egosi"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("برنج پخته"),
            keywords: &["برنج", "پخته"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("keitetty riisi"),
            keywords: &["keitetty", "riisi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kanin"),
            keywords: &["kanin", "pagkain", "sinaing"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kókarís"),
            keywords: &["kóka", "kókarís", "matur", "rís"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bol de riz"),
            keywords: &["bol de riz", "riz"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["bol", "bol de riz", "riz"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("rís chócaráilte"),
            keywords: &["rís", "rís chócaráilte", "rís cócaráilte"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("rìs bruich"),
            keywords: &["bruich", "rìs"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cunca de arroz"),
            keywords: &[
                "arroz",
                "cocido",
                "comida chinesa",
                "comida xaponesa",
                "cunca de arroz",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ભાત"),
            keywords: &["ચોખા", "ભાત", "ર\u{ac7}સ\u{acd}ટોર\u{ac7}ન\u{acd}ટ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("dafaffen shinkafa"),
            keywords: &["dafaffe", "dafaffen shinkafa", "shinkafa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אורז מבושל"),
            keywords: &["אורז", "מבושל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पक\u{947} ह\u{941}ए चावल"),
            keywords: &[
                "चावल",
                "पक\u{947} ह\u{941}ए चावल",
                "र\u{947}स\u{94d}टोर\u{947}\u{902}ट",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kuhana riža"),
            keywords: &["kuhana", "riža"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("főtt rizs"),
            keywords: &["főtt rizs", "főzött", "rizs"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("եփած բրինձ"),
            keywords: &["բրինձ", "եփած"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("nasi matang"),
            keywords: &["masak", "nasi matang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("òsìkapa esiri èsi"),
            keywords: &["esiri èsi", "òsìkapa", "òsìkapa esiri èsi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("soðin hrísgrjón"),
            keywords: &["hrísgrjón", "soðin"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("riso bollito"),
            keywords: &["riso", "riso bollito", "ristorante"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ごはん"),
            keywords: &["ごはん", "ライス", "米"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sega mateng"),
            keywords: &["mateng", "sega"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მომზადებული ბრინჯი"),
            keywords: &["ბრინჯი", "მომზადებული"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("пісірілген күріш"),
            keywords: &["күріш", "пісірілген"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ris"),
            keywords: &["restaurant", "ris", "skål ris"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បាយឆ\u{17d2}អ\u{17b7}នម\u{17bd}យចាន"),
            keywords: &[
                "ឆ\u{17d2}អ\u{17b7}ន",
                "បាយ",
                "បាយឆ\u{17d2}អ\u{17b7}នម\u{17bd}យចាន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಅನ\u{ccd}ನ"),
            keywords: &["ಅನ\u{ccd}ನ", "ಬೇಯ\u{cbf}ಸ\u{cbf}ದ ಅಕ\u{ccd}ಕ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("밥"),
            keywords: &["밥", "밥공기"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("शीत"),
            keywords: &["ता\u{902}द\u{942}ळ", "शिजयल\u{94d}ल\u{947}", "शीत"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бышкан күрүч"),
            keywords: &["бышкан", "күрүч"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("gekachte Räis"),
            keywords: &["Räis", "gekacht", "gekachte Räis"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຂ\u{ebb}\u{ec9}າສ\u{eb8}ກ"),
            keywords: &["ເຂ\u{ebb}\u{ec9}າ", "ເຂ\u{ebb}\u{ec9}າສ\u{eb8}ກ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("virti ryžiai"),
            keywords: &["ryžiai", "virti"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vārīti rīsi"),
            keywords: &["rīsi", "vārīti rīsi", "vārīts"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("raihi maoa"),
            keywords: &["maoa", "raihi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("варен ориз"),
            keywords: &["варен", "ориз"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ചോറ\u{d4d}"),
            keywords: &["ആഹ\u{d3e}രം", "ചോറ\u{d4d}", "ഭക\u{d4d}ഷണം", "ഹോട\u{d4d}ടൽ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("агшаасан будаа"),
            keywords: &["агшаасан будаа", "будаа"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("शिजवल\u{947}ला भात"),
            keywords: &[
                "ता\u{902}द\u{942}ळ",
                "शिजवल\u{947}ला भात",
                "शिजवल\u{947}ल\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("nasi masak"),
            keywords: &["masak", "nasi"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ross imsajjar"),
            keywords: &["imsajjar", "ross"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ထမင\u{103a}း"),
            keywords: &["ချက\u{103a}ထားသော ထမင\u{103a}း", "ထမင\u{103a}း"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kokt ris"),
            keywords: &["kokt", "restaurant", "ris"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पकाएको खाना"),
            keywords: &["खाना", "पकाएको"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gekookte rijst"),
            keywords: &["gekookt", "gekookte rijst", "rijst"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kokt ris"),
            keywords: &["kokt", "restaurant", "ris"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ରନ\u{b4d}ଧ\u{b3e} ଭ\u{b3e}ତ"),
            keywords: &["ଭ\u{b3e}ତ", "ରନ\u{b4d}ଧ\u{b3e}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a71}ਕ\u{a47} ਹ\u{a4b}ਏ ਚ\u{a4c}ਲ"),
            keywords: &[
                "ਚ\u{a4c}ਲ",
                "ਪ\u{a71}ਕ\u{a47} ਹ\u{a4b}ਏ ਚ\u{a4c}ਲ",
                "ਬਣ\u{a47} ਹ\u{a4b}ਏ ਚ\u{a4c}ਲ",
                "ਹ\u{a4b}ਟਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پکے ہوئے چول"),
            keywords: &["پکیا ہوئیا", "پکے ہوئے چول", "چول"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Rais Wé Dẹm Dọ\u{301}n Kuk"),
            keywords: &[
                "Fud Wé Dẹm Dọ\u{301}n Kuk",
                "Kuk",
                "Rais",
                "Rais Wé Dẹm Dọ\u{301}n Kuk",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("gotowany ryż"),
            keywords: &["gotowany ryż", "ryż"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پخې وريجې"),
            keywords: &["پخې وريجې", "پخې، وريجې"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("arroz cozido"),
            keywords: &["arroz", "arroz cozido"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("tigela de arroz"),
            keywords: &["arroz", "cozido", "tigela de arroz"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("waykʼusqa arroz"),
            keywords: &["arroz", "waykʼusqa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("orez gătit"),
            keywords: &["orez", "orez gătit", "preparare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-287"),
            keywords: &["E10-287"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("рис"),
            keywords: &["вареный", "миска", "плошка", "рис", "тарелка", "чашка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umuceri utetse"),
            keywords: &["umuceri utetse"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پچيل چانور"),
            keywords: &["پچيل چانور", "پچيل، چانور"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd2}ස\u{dd2}න ලද සහල\u{dca}"),
            keywords: &[
                "ප\u{dd2}ස\u{dd2}න ලද",
                "ප\u{dd2}ස\u{dd2}න ලද සහල\u{dca}",
                "සහල\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("uvarená ryža"),
            keywords: &["ryža", "uvarená"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kuhan riž"),
            keywords: &["kuhan riž", "kuhano", "riž"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("bariis karsan"),
            keywords: &["bariis karsan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("oriz i gatuar"),
            keywords: &["i gatuar", "oriz", "oriz i gatuar"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кувани пиринач"),
            keywords: &["кувани", "пиринач"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("кувана рижа"),
            keywords: &["кувана рижа"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kuvani pirinač"),
            keywords: &["kuvani", "pirinač"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("kuvana riža"),
            keywords: &["kuvana riža"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kokt ris"),
            keywords: &["kokt ris", "ris"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("wali"),
            keywords: &["mchele", "uliopikwa", "wali"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சோறு"),
            keywords: &["உணவகம\u{bcd}", "உணவு", "சோறு"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఉడ\u{c3f}క\u{c3f}ంచ\u{c3f}న బ\u{c3f}య\u{c4d}యం"),
            keywords: &[
                "అన\u{c4d}నం",
                "ఉడ\u{c3f}క\u{c3f}ంచ\u{c3f}న బ\u{c3f}య\u{c4d}యం",
                "ఉడ\u{c3f}క\u{c3f}న అన\u{c4d}నం",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("биринҷи пухташуда"),
            keywords: &["биринҷ", "биринҷи пухташуда", "пухташуда"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ข\u{e49}าวสวย"),
            keywords: &["ข\u{e49}าว", "ข\u{e49}าวสวย", "ชามข\u{e49}าว"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("bişirilen tüwi"),
            keywords: &["bişirilen", "tüwi"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("laise moho"),
            keywords: &["laise moho"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("pilav"),
            keywords: &["pilav", "pirinç", "restoran"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("پىشىق گۈرۈچ"),
            keywords: &["پىشىق", "گۈرۈچ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("приготований рис"),
            keywords: &["варений", "приготований рис", "рис"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پکے ہوئے چاول"),
            keywords: &["پکے ہوئے", "پکے ہوئے چاول", "چاول"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("pishirilgan guruch"),
            keywords: &["guruch", "pishirilgan"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cơm"),
            keywords: &["cơm", "gạo", "nấu chín"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("ceeb buñ togg"),
            keywords: &["ceeb", "ceeb buñ togg", "togg"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("irayisi ephekiweyo"),
            keywords: &["ephekiweyo", "irayisi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Irẹsi Sise"),
            keywords: &["Irẹsi", "Sise"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("飯"),
            keywords: &["煮熟", "飯"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("饭"),
            keywords: &["煮熟", "饭"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("米饭"),
            keywords: &["米", "米饭", "饭"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("米飯"),
            keywords: &["米飯", "飯"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("白飯"),
            keywords: &["白飯", "米飯", "飯"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ilayisi eliphekiwe"),
            keywords: &["ilayisi", "ilayisi eliphekiwe", "okuphekiwe"],
        },
    ],
};
#[doc = "🍛"]
pub const CURRY_RICE: crate::Emoji = crate::Emoji {
    glyph: "🍛",
    codepoint: "1F35B",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "curry rice",
    group: "Food & Drink",
    subgroup: "food-asian",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kerrierys"),
            keywords: &["kerrie", "kerrierys", "kos", "rys"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ከሪ ሩዝ"),
            keywords: &["ሩዝ", "ከሪ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("أرز وكاري"),
            keywords: &["أرز", "أرز وكاري", "كاري", "مطعم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("আঞ\u{9cd}জ\u{9be} আৰ\u{9c1} ভ\u{9be}ত"),
            keywords: &[
                "আঞ\u{9cd}জ\u{9be}",
                "আঞ\u{9cd}জ\u{9be} আৰ\u{9c1} ভ\u{9be}ত",
                "চ\u{9be}উল",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("karri düyüsü"),
            keywords: &["düyü", "karri", "karri düyüsü"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("рыс і кары"),
            keywords: &["кары", "рыс", "рыс і кары"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Къри и ориз"),
            keywords: &["Къри и ориз", "къри", "ориз"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ভ\u{9be}ত তরক\u{9be}রি"),
            keywords: &["চ\u{9be}ল", "তরক\u{9be}রি", "ভ\u{9be}ত তরক\u{9be}রি"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("riz dre gari"),
            keywords: &["kari", "riz", "riz dre gari"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kari riža"),
            keywords: &["kari", "riža"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("arròs al curri"),
            keywords: &["arròs", "arròs al curri", "curri"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏓᎵᏆ ᎤᎦᎹ"),
            keywords: &["ᎤᎦᎹ", "ᏓᎵᏆ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kari rýže"),
            keywords: &["curry", "kari rýže", "karí", "rýže"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("reis cyrri"),
            keywords: &["cyrri", "reis"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ris og karry"),
            keywords: &["curry", "ris", "ris og karry"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Reis mit Curry"),
            keywords: &["Curry", "Reis", "Reis mit Curry"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ρύζι με κάρυ"),
            keywords: &["κάρυ", "ρύζι", "ρύζι με κάρυ"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("curry rice"),
            keywords: &["curry", "rice"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("arroz con curry"),
            keywords: &["arroz", "arroz con curry", "curry", "restaurante"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["arroz", "arroz con curry", "comida", "curry", "restaurante"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["arroz", "arroz con curry", "curry"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("karriga riis"),
            keywords: &["karri", "karriga riis", "riis"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("arroza curryarekin"),
            keywords: &["arroz", "arroza curryarekin", "curry"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("برنج با کاری"),
            keywords: &["برنج", "برنج با کاری", "کاری"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("curry-riisi"),
            keywords: &["curry", "curry-riisi", "riisi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("curry rice"),
            keywords: &["curry", "curry rice", "kanin", "pagkain"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("karryrís"),
            keywords: &["karry", "karryrís", "matur", "rís"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("riz au curry"),
            keywords: &["curry", "riz", "riz au curry"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "cari",
                "carry",
                "cary",
                "curry",
                "kari",
                "riz",
                "riz au curry",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("curaí agus rís"),
            keywords: &["curaí", "curaí agus rís", "rís"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("curry is rìs"),
            keywords: &["curry", "curry is rìs", "rìs"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("arroz con curry"),
            keywords: &["arroz", "arroz con curry", "curry"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કઢી અન\u{ac7} ભાત"),
            keywords: &[
                "કઢી",
                "કઢી અન\u{ac7} ભાત",
                "ભાત",
                "ર\u{ac7}સ\u{acd}ટોર\u{ac7}ન\u{acd}ટ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("shinkafa na kori"),
            keywords: &["kori", "shinkafa", "shinkafa na kori"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אורז קארי"),
            keywords: &["אורז", "קארי"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("करी–चावल"),
            keywords: &[
                "कड\u{93c}ी",
                "कड\u{93c}ी–चावल",
                "करी–चावल",
                "चावल",
                "र\u{947}स\u{94d}टोर\u{947}\u{902}ट",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("curry riža"),
            keywords: &["curry", "riža"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("currys rizs"),
            keywords: &["curry", "currys rizs", "rizs"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կարրիով բրինձ"),
            keywords: &["բրինձ", "կարրի", "կարրիով բրինձ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("nasi kari"),
            keywords: &["kari", "nasi"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("òsìkapa nwere ofe"),
            keywords: &["nwere ofe", "òsìkapa", "òsìkapa nwere ofe"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hrísgrjón og karrí"),
            keywords: &["hrísgrjón", "hrísgrjón og karrí", "karrí", "veitingastaður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("riso al curry"),
            keywords: &["curry", "riso", "riso al curry", "ristorante"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("カレーライス"),
            keywords: &["カレー", "カレーライス", "ライス"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sega kare"),
            keywords: &["kare", "sega"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბრინჯი ქარით"),
            keywords: &["ბრინჯი", "ბრინჯი ქარით", "ქარი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("карри қосылған күріш"),
            keywords: &["карри", "карри қосылған күріш", "күріш"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ris og karry"),
            keywords: &["ris", "ris og karry"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បាយស\u{17d2}រ\u{17bc}បការ\u{17b8}"),
            keywords: &["ការ\u{17b8}", "បាយ", "បាយស\u{17d2}រ\u{17bc}បការ\u{17b8}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮೇಲೋಗರ ಅನ\u{ccd}ನ"),
            keywords: &[
                "ಮೇಲೋಗರ",
                "ಮೇಲೋಗರ ಅನ\u{ccd}ನ",
                "ಮೇಲೋಗರ ಮತ\u{ccd}ತು ಅನ\u{ccd}ನ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("카레라이스"),
            keywords: &["카레", "카레라이스", "카레밥"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ह\u{941}मण शीत"),
            keywords: &["शीत", "ह\u{941}मण"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("карри кошулган күрүч"),
            keywords: &["карри", "карри кошулган күрүч", "күрүч"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Curry mat Räis"),
            keywords: &["Curry", "Curry mat Räis", "Räis"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຂ\u{ebb}\u{ec9}າແກງກະຫ\u{ebc}\u{eb5}\u{ec8}"),
            keywords: &[
                "ເຂ\u{ebb}\u{ec9}າ",
                "ເຂ\u{ebb}\u{ec9}າແກງກະຫ\u{ebc}\u{eb5}\u{ec8}",
                "ແກງກະຫ\u{ebc}\u{eb5}\u{ec8}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("ryžiai su kariu"),
            keywords: &["karis", "ryžiai", "ryžiai su kariu"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("rīsu karijs"),
            keywords: &["karijs", "rīsi", "rīsu karijs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("raihi kari"),
            keywords: &["kari", "raihi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("ориз со кари"),
            keywords: &["кари", "ориз", "ориз со кари"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ചോറ\u{d41}ം കറിയ\u{d41}ം"),
            keywords: &[
                "കറി",
                "ചോറ\u{d41}ം കറിയ\u{d41}ം",
                "ചോറ\u{d4d}",
                "ഹോട\u{d4d}ടൽ ഭക\u{d4d}ഷണം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("карритай будаа"),
            keywords: &["будаа", "карри", "карритай будаа"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("आमटी भात"),
            keywords: &["आमटी", "भात"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("nasi kari"),
            keywords: &["kari", "nasi"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ross tal-karì"),
            keywords: &["karì", "ross", "ross tal-karì"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ထမင\u{103a}းဟင\u{103a}း"),
            keywords: &["ထမင\u{103a}း", "ထမင\u{103a}းဟင\u{103a}း", "ဟင\u{103a}း"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("karriris"),
            keywords: &["curry", "karri", "karriris", "restaurant", "ris"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("भात र तरकारी"),
            keywords: &["तरकारी", "भात", "भात र तरकारी"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("curry en rijst"),
            keywords: &["curry", "curry en rijst", "rijst"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("karriris"),
            keywords: &["curry", "karri", "karriris", "restaurant", "ris"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ତରକ\u{b3e}ରୀ ଭ\u{b3e}ତ"),
            keywords: &["ତରକ\u{b3e}ରୀ", "ଭ\u{b3e}ତ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕੜ\u{a4d}ਹੀ ਅਤ\u{a47} ਚ\u{a4c}ਲ"),
            keywords: &[
                "ਕੜ\u{a4d}ਹੀ",
                "ਕੜ\u{a4d}ਹੀ ਅਤ\u{a47} ਚ\u{a4c}ਲ",
                "ਚ\u{a4c}ਲ",
                "ਹ\u{a4b}ਟਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("شورے آلے چول"),
            keywords: &["شورے آلا سالن", "شورے آلے چول", "چول"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kọrí Rais"),
            keywords: &["Kọrí", "Rais"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("ryż curry"),
            keywords: &["curry", "ryż", "sos"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کري وریجی"),
            keywords: &["وریجی", "کري"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("arroz com curry"),
            keywords: &["arroz", "arroz com curry", "curry", "curry e arroz"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("arroz com caril"),
            keywords: &["arroz", "arroz com caril", "caril"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("arroz currywan"),
            keywords: &["arroz", "arroz currywan", "curry"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("orez cu curry"),
            keywords: &["condiment", "curry", "orez", "orez cu curry"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-288"),
            keywords: &["E10-288"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("рис с карри"),
            keywords: &["карри", "рис", "рис с карри"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umuceri n’isosi"),
            keywords: &["umuceri n’isosi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪڙي چانور"),
            keywords: &["ڪڙي چانور", "ڪڙي، چانور"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බත\u{dca} සහ හොද\u{dd2}"),
            keywords: &["බත\u{dca} සහ හොද\u{dd2}", "සහල\u{dca}", "හොද\u{dd2}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ryža s karí"),
            keywords: &["karí", "ryža", "ryža s karí"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("riž s karijem"),
            keywords: &["kari", "riž", "riž s karijem"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("bariis khudrad hilib leh"),
            keywords: &["bariis khudrad hilib leh"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("oriz me mish me erëza"),
            keywords: &["mish me erëza", "oriz", "oriz me mish me erëza"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("пиринач са каријем"),
            keywords: &["кари", "пиринач", "пиринач са каријем"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("рижа са каријем"),
            keywords: &["рижа са каријем"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("pirinač sa karijem"),
            keywords: &["kari", "pirinač", "pirinač sa karijem"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("riža sa karijem"),
            keywords: &["riža sa karijem"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("curry och ris"),
            keywords: &["curry", "curry och ris", "ris"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("wali ulio na mchuzi wa viungo"),
            keywords: &[
                "mchele",
                "mchuzi wa viungo",
                "wali ulio na mchuzi wa viungo",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சோறும\u{bcd} குழம\u{bcd}பும\u{bcd}"),
            keywords: &[
                "உணவகம\u{bcd}",
                "குழம\u{bcd}பு",
                "ச\u{bbe}ப\u{bcd}ப\u{bbe}டு",
                "சோறு",
                "சோறும\u{bcd} குழம\u{bcd}பும\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కూర అన\u{c4d}నం"),
            keywords: &[
                "అన\u{c4d}నం",
                "కూర",
                "కూర మర\u{c3f}యు అన\u{c4d}నం",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("биринҷ бо карри"),
            keywords: &["биринҷ", "биринҷ бо карри", "карри"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ข\u{e49}าวแกงกะหร\u{e35}\u{e48}"),
            keywords: &["ข\u{e49}าวแกงกะหร\u{e35}\u{e48}", "แกงกะหร\u{e35}\u{e48}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("karri tüwi"),
            keywords: &["karri", "tüwi"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("laise kale"),
            keywords: &["laise kale"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("körili pilav"),
            keywords: &["köri", "körili pilav", "pirinç", "restoran"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قورۇغان گۈرۈچ"),
            keywords: &["قورۇغان", "گۈرۈچ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("рис із карі"),
            keywords: &["карі", "рис", "рис із карі"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("شوربے والے چاول"),
            keywords: &["شوربہ", "شوربے والے چاول", "چاول"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("guruchli karri"),
            keywords: &["guruch", "guruchli karri", "karri"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cơm cà ri"),
            keywords: &["cà ri", "cơm", "cơm cà ri"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("ceebu kari"),
            keywords: &["ceebu", "kari"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("irayisi yekheri"),
            keywords: &["ikheri", "irayisi", "irayisi yekheri"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("irẹsi kọri"),
            keywords: &["irẹsi", "kọri"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("咖哩飯"),
            keywords: &["咖哩", "咖哩飯", "飯"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("咖哩饭"),
            keywords: &["咖哩", "咖哩饭", "饭"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("咖喱饭"),
            keywords: &["咖喱", "咖喱饭", "饭"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("咖哩飯"),
            keywords: &["咖哩飯", "飯"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isishebo selayisi"),
            keywords: &["ilayisi", "isishebo", "isishebo selayisi"],
        },
    ],
};
#[doc = "🍜"]
pub const STEAMING_BOWL: crate::Emoji = crate::Emoji {
    glyph: "🍜",
    codepoint: "1F35C",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "steaming bowl",
    group: "Food & Drink",
    subgroup: "food-asian",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("stomende bak"),
            keywords: &["bak", "kos", "noedel", "stomende bak", "stoom"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ማጥለያ ጎድጓዳ ሳሕን"),
            keywords: &["ማጥለል", "ማጥለያ ጎድጓዳ ሳሕን", "ሼፕዊን", "ኑድል", "ጎድጓዳ ሳሕን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}سلطانية البخار"),
            keywords: &["مطعم", "مكرونة", "\u{202b}سلطانية البخار"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ভ\u{9be}পত সিজোৱ\u{9be} ব\u{9be}তি"),
            keywords: &[
                "ন\u{9c1}ডল",
                "ব\u{9be}তি",
                "ভ\u{9be}প ওল\u{9be}ই থক\u{9be}",
                "ভ\u{9be}পত সিজোৱ\u{9be} ব\u{9be}তি",
                "ৰ\u{9be}মেন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("buxarlanan kasa"),
            keywords: &["buxarlanan kasa", "buğlanan", "kasa", "ramen", "əriştə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("міска з гарачай ежай"),
            keywords: &[
                "гарачы",
                "локшына",
                "міска",
                "міска з гарачай ежай",
                "рамэн",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Изпускаща пара купа"),
            keywords: &["Изпускаща пара купа", "купа", "нудълс", "пара"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9cd}টিম কর\u{9be}র ব\u{9be}টি"),
            keywords: &[
                "ন\u{9c1}ডল",
                "ব\u{9be}টি",
                "ভ\u{9be}প\u{9be}নো",
                "র\u{9be}মেন",
                "স\u{9cd}টিম কর\u{9be}র ব\u{9be}টি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bolennad tomm"),
            keywords: &["bolennad", "tomm"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("posuda na paru"),
            keywords: &["knedla", "posuda", "posuda na paru", "rezanci", "činija"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bol fumejant"),
            keywords: &["bol", "bol fumejant", "fideus", "fum", "plat", "ramen"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏥᎳ ᎦᏌᏙᏯᏍᎩ ᏗᏩᎵ"),
            keywords: &["ᎠᏥᎳ ᎦᏌᏙᏯᏍᎩ", "ᎠᏥᎳ ᎦᏌᏙᏯᏍᎩ ᏗᏩᎵ", "ᎴᎹᏂ", "ᏗᎦᎸᏅᎯ", "ᏗᏩᎵ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("miska nudlí"),
            keywords: &["miska", "miska nudlí", "nudle", "pára", "ramen"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bowlen yn stemio"),
            keywords: &["bowl", "bowlen yn stemio", "nwdl", "ramen", "stêm"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("nudler"),
            keywords: &["nudler", "ramen-nudler", "restaurant", "skål nudler"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schüssel und Essstäbchen"),
            keywords: &[
                "Eiernudeln",
                "Nudeln",
                "Schüssel",
                "Schüssel und Essstäbchen",
                "Stäbchen",
                "Suppe",
                "dampfend",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μπολ με αχνιστό φαγητό"),
            keywords: &[
                "αχνιστό",
                "μπολ",
                "μπολ με αχνιστό φαγητό",
                "νουντλ",
                "σούπα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("steaming bowl"),
            keywords: &["bowl", "noodle", "ramen", "steaming"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("tazón de fideos"),
            keywords: &[
                "fideos calientes",
                "fideos chinos",
                "fideos ramen",
                "ramen",
                "tazón de fideos",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "bol de fideos",
                "china",
                "comida",
                "fideos",
                "ramen",
                "tazón de fideos",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("tazón de fideos"),
            keywords: &["tazón de fideos"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["fideos", "hirviendo", "ramen", "tazón", "tazón de fideos"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("aurav kauss"),
            keywords: &["aur", "aurav kauss", "kauss", "nuudel"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kea darion katilua"),
            keywords: &["fideo", "katilu", "kea", "kea darion katilua", "ramen"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کاسه نودل"),
            keywords: &["بخار", "داغ", "رامن", "رشته", "نودل", "کاسه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("höyryävä kulho"),
            keywords: &["höyryävä", "kulho", "kuuma", "nuudeli", "ramen"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mainit na noodles"),
            keywords: &["mainit na noodles", "mangkok", "noodle", "pagkain", "ramen"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("nudlur"),
            keywords: &["matur", "nudlur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bol fumant"),
            keywords: &["bol fumant", "nouilles", "ramen", "vapeur"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ramen"),
            keywords: &["babhla", "babhla núdal", "gal", "núdail", "ramen", "te"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bobhla le ceò às"),
            keywords: &["bobhla", "bobhla le ceò às", "ceò", "nùdail", "ramen"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("fideos chineses"),
            keywords: &[
                "comida chinesa",
                "comida xaponesa",
                "fideos chineses",
                "fumegante",
                "ramen",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વરાળ નીકળતો પ\u{acd}યાલો"),
            keywords: &[
                "ન\u{ac1}ડલ",
                "ન\u{ac1}ડલ\u{acd}સ",
                "ન\u{ac1}ડલ\u{acd}સનો વાટકો",
                "રમ\u{ac7}ન",
                "વરાળ નીકળતા\u{a82}",
                "વરાળ નીકળતો પ\u{acd}યાલો",
                "વરાળ નીકળતો વાટકો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kwano mai dambatawa"),
            keywords: &[
                "dambatawa",
                "kwano",
                "kwano mai dambatawa",
                "ramen",
                "taliya",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קערה מהבילה"),
            keywords: &["אוכל", "אטריות", "נודלס", "סיני", "קערה מהבילה", "תאילנדי"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("भाप वाली बाउल"),
            keywords: &[
                "उबल\u{947} न\u{942}डल",
                "न\u{942}डल",
                "बाउल",
                "भाप",
                "भाप वाली बाउल",
                "र\u{947}स\u{94d}टोर\u{947}\u{902}ट",
                "र\u{948}मन",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kipuća zdjelica"),
            keywords: &["kipuća zdjelica", "para", "ramen", "tjestenina", "zdjelica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("gőzölgő tál"),
            keywords: &["forró", "gőzölgő tál", "gőzölög", "tál", "tészta"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տաք ապուր"),
            keywords: &["թաս", "լապշա", "տաք", "տաք ապուր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("mangkuk mengepul"),
            keywords: &["mangkuk", "mangkuk mengepul", "mie", "ramen", "rebusan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ite na-asụ asụ"),
            keywords: &[
                "ite dabara n’ime",
                "ite na-asụ asụ",
                "na-asụ asụ",
                "nri òsikapa nwere àkwa",
                "òsìkapa azịza",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("núðlur"),
            keywords: &[
                "gufusoðnar",
                "núðlur",
                "núðluskál",
                "skál",
                "veitingastaður",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("ciotola fumante"),
            keywords: &[
                "ciotola di noodle",
                "ciotola fumante",
                "noodle",
                "piatto caldo",
                "ramen",
                "ristorante",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ラーメン"),
            keywords: &["どんぶり", "ラーメン", "熱々"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("mangkok kemepul"),
            keywords: &["bakmi", "kemepul", "mangkok", "ramen"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ფიალა ორთქლით"),
            keywords: &["ატრია", "ორთქლი", "ფიალა", "ფიალა ორთქლით"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("буы шығып тұрған ыдыс"),
            keywords: &[
                "бу шығып тұрған",
                "буы шығып тұрған ыдыс",
                "рамен",
                "таяқша",
                "ыдыс",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("nudler"),
            keywords: &["nudler", "ramen-nudler", "restaurant", "skål nudler"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17d2}ហ\u{17bc}បច\u{17c6}ហ\u{17bb}យ"),
            keywords: &[
                "គ\u{17bb}យទាវ",
                "ចានគោម",
                "ច\u{17c6}ហ\u{17bb}យ",
                "ម\u{17b8}",
                "ម\u{17d2}ហ\u{17bc}បច\u{17c6}ហ\u{17bb}យ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಆವ\u{cbf}ಯಲ\u{ccd}ಲ\u{cbf} ಬೇಯ\u{cbf}ಸುವ ಬಟ\u{ccd}ಟಲು"),
            keywords: &[
                "ಆವ\u{cbf}ಯಲ\u{ccd}ಲ\u{cbf} ಬೇಯ\u{cbf}ಸುವ ಬಟ\u{ccd}ಟಲು",
                "ನ\u{cc2}ಡಲ\u{ccd}ಸ\u{ccd}\u{200c}ನ ಬಟ\u{ccd}ಟಲು",
                "ರಾಮ\u{cc6}ನ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("국수"),
            keywords: &["국수", "라면", "면"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("वाफायिल\u{94d}ल\u{947}\u{902} शीत"),
            keywords: &[
                "राम\u{947}न",
                "वाटो",
                "वाफायिल\u{94d}ल\u{947}\u{902} शीत",
                "वाफायिल\u{94d}लो",
                "श\u{947}वयो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бууланып жаткан чыны"),
            keywords: &["бууланган", "бууланып жаткан чыны", "кесме", "чыны"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Schossel mat Nuddelen"),
            keywords: &[
                "Nuddelen",
                "Ramen",
                "Schossel",
                "Schossel mat Nuddelen",
                "dämpend",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຖ\u{ec9}ວຍທ\u{eb5}\u{ec8}ສ\u{ebb}\u{ec8}ງອາຍ"),
            keywords: &[
                "ຖ\u{ec9}ວຍ",
                "ຖ\u{ec9}ວຍທ\u{eb5}\u{ec8}ສ\u{ebb}\u{ec8}ງອາຍ",
                "ສ\u{ebb}\u{ec8}ງອາຍ",
                "ໝ\u{eb5}\u{ec8}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("makaronų sriubos dubenėlis"),
            keywords: &[
                "dubuo",
                "makaronai",
                "makaronų sriubos dubenėlis",
                "ramen",
                "sriuba",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kūpoša bļodiņa"),
            keywords: &["bļoda", "karsts", "kūpoša bļodiņa", "ēdiens"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("paepae korohū"),
            keywords: &["korohū", "nūru", "paepae", "ramen"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("длабока чинија со жешка храна"),
            keywords: &[
                "длабока чинија",
                "длабока чинија со жешка храна",
                "жешко",
                "пареа",
                "тестенини",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ആവി പറക\u{d4d}ക\u{d41}ന\u{d4d}ന ബ\u{d57}ൾ"),
            keywords: &[
                "ആവി പറക\u{d4d}ക\u{d41}ന\u{d4d}ന ബ\u{d57}ൾ",
                "ആഹ\u{d3e}രം",
                "ന\u{d42}ഡിൽ",
                "ന\u{d42}ഡിൽസ\u{d4d}",
                "ഭക\u{d4d}ഷണം",
                "ര\u{d3e}മെൻ",
                "ഹോട\u{d4d}ടൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("чанасан гоймон"),
            keywords: &["гоймон", "жигнэх", "рамен", "хул аяга", "чанасан гоймон"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ज\u{94d}यामध\u{942}न वाफा य\u{947}तात अस\u{947} भा\u{902}ड\u{947}"),
            keywords: &[
                "ज\u{94d}यामध\u{942}न वाफा य\u{947}तात अस\u{947} भा\u{902}ड\u{947}",
                "न\u{942}डल",
                "भा\u{902}ड\u{947}",
                "र\u{945}म\u{947}न",
                "वाफाळणार\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("mangkuk kukus"),
            keywords: &["berasap", "mangkuk", "mangkuk kukus", "mi", "ramen"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("bieqja tal-fwar"),
            keywords: &["bieqja", "bieqja tal-fwar", "fwar", "noodle", "ramen"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ခေါက\u{103a}ဆ\u{103d}\u{1032}ပြ\u{102f}ပ\u{103a} ပန\u{103a}းကန\u{103a}လ\u{102f}\u{1036}း",
            ),
            keywords: &[
                "ခေါက\u{103a}ဆ\u{103d}\u{1032}",
                "ခေါက\u{103a}ဆ\u{103d}\u{1032}ပြ\u{102f}ပ\u{103a} ပန\u{103a}းကန\u{103a}လ\u{102f}\u{1036}း",
                "ပန\u{103a}းကန\u{103a}လ\u{102f}\u{1036}း",
                "ရမင\u{103a}",
                "အင\u{103d}ေ\u{1037}ပျ\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("matbolle som damper"),
            keywords: &[
                "matbolle",
                "matbolle som damper",
                "nudelbolle",
                "ramen",
                "restaurant",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("तातो खानाको कचौरा"),
            keywords: &[
                "कचौ\u{902}रा",
                "तातो",
                "तातो खानाको कचौरा",
                "थ\u{941}क\u{94d}पा",
                "राम\u{947}न",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("dampende kom"),
            keywords: &["dampend", "dampende kom", "kom", "noedels", "ramen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("matbolle som dampar"),
            keywords: &[
                "matbolle",
                "matbolle som dampar",
                "nudelbolle",
                "restaurant",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ବ\u{b3e}ମ\u{b4d}ଫ ବ\u{b3e}ହ\u{b3e}ର\u{b41}ଥ\u{b3f}ବ\u{b3e} ଗ\u{b3f}ନ\u{b3e}",
            ),
            keywords: &[
                "ଗ\u{b3f}ନ\u{b3e}",
                "ନ\u{b41}ଡ\u{b41}ଲ\u{b4d}\u{200c}",
                "ବ\u{b3e}ମ\u{b4d}ଫ ବ\u{b3e}ହ\u{b3e}ର\u{b41}ଥ\u{b3f}ବ\u{b3e} ଗ\u{b3f}ନ\u{b3e}",
                "ବ\u{b3e}ହ\u{b3e}ର\u{b41}ଥ\u{b3f}ବ\u{b3e} ବ\u{b3e}ଷ\u{b4d}ପ",
                "ର\u{b3e}ମେନ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਵ\u{a71}ਡਾ ਕਟ\u{a4b}ਰਾ"),
            keywords: &[
                "ਨ\u{a42}ਡਲ",
                "ਨ\u{a42}ਡਲਜ\u{a3c}",
                "ਨ\u{a42}ਡਲਜ\u{a3c} ਦਾ ਬਾਟਾ",
                "ਪਕਾਉਣਾ",
                "ਬਾਟਾ",
                "ਵ\u{a71}ਡਾ ਕਟ\u{a4b}ਰਾ",
                "ਹ\u{a4b}ਟਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بھاپ آلی کولی"),
            keywords: &["بھاپ آلی کولی", "بھاپ نکلدی", "ریمن", "نوڈل", "پیالہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Họ\u{301}t Ból Ọf Fúd"),
            keywords: &[
                "Díp Plet",
                "Fud Wé Họ\u{301}t Wẹ\u{301}l Wẹl",
                "Họ\u{301}t Ból Ọf Fúd",
                "Japan",
                "Japán Fud Wé Dẹm De Kọ\u{301}l Rámẹn",
                "Núdul: Fud Laik Spagẹ\u{301}ti",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("miska parującego jedzenia"),
            keywords: &["miska", "miska parującego jedzenia", "parująca miska"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بړاس کوونکې پياله"),
            keywords: &["بړاس کوونکې پياله", "پياله، مينچې، رامين، بخار کوونکې"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("lámen"),
            keywords: &["lámen", "ramen", "tigela"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("tigela com comida quente"),
            keywords: &[
                "massa",
                "noodles",
                "quente",
                "ramen",
                "tigela com comida quente",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("chhapukucha fideoswan"),
            keywords: &[
                "chhapukucha",
                "chhapukucha fideoswan",
                "cuenco",
                "fideos",
                "tallarines",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("castron aburind"),
            keywords: &["castron", "castron aburind", "fierbinte", "tăiței"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-289"),
            keywords: &["E10-289"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("лапша"),
            keywords: &["лапша", "миска", "пар", "чашка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("inkono icumbamo umwotsi"),
            keywords: &[
                "gicumba umwotsi",
                "imbehe",
                "inkono icumbamo umwotsi",
                "nudo",
                "rameni",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("گرم برتن"),
            keywords: &["برتن، نوڊل، ريمين، گرم", "گرم برتن"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("උණ\u{dd4} බඳ\u{dd4}න"),
            keywords: &[
                "උණ\u{dd4}",
                "උණ\u{dd4} බඳ\u{dd4}න",
                "න\u{dd6}ඩ\u{dca}ල\u{dca}ස\u{dca}",
                "බඳ\u{dd4}\u{dd4}න",
                "ර\u{dcf}මන\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("miska s horúcim jedlom"),
            keywords: &[
                "miska",
                "miska s horúcim jedlom",
                "para",
                "ramen",
                "rezance",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("skleda rezancev"),
            keywords: &["ramen", "rezanci", "skleda", "skleda rezancev", "vrelo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("baaquligga uumigga"),
            keywords: &[
                "baaquli",
                "baaquligga uumigga",
                "baasta dheer",
                "baastada ramen",
                "uuminta",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kupë me avull"),
            keywords: &["kupë", "kupë me avull", "makarona", "me avull", "ramen"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("врућа чинија"),
            keywords: &["врућа чинија", "пaрa", "рaмeн", "резанци", "чинија"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("vruća činija"),
            keywords: &["para", "ramen", "rezanci", "vruća činija", "činija"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("skål nudelsoppa"),
            keywords: &["nudlar", "rykande", "skål", "skål nudelsoppa", "soppa"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("bakuli yenye tambi"),
            keywords: &[
                "bakuli",
                "bakuli yenye tambi",
                "kupika kwa mvuke",
                "tambi",
                "tambi za kijapani",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("bakuli lenye tambi"),
            keywords: &[
                "bakuli",
                "bakuli lenye tambi",
                "kupika kwa mvuke",
                "tambi",
                "tambi za kijapani",
            ],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆவி பறக\u{bcd}கும\u{bcd} உணவு"),
            keywords: &[
                "ஆவி பறக\u{bcd}கும\u{bcd} உணவு",
                "உணவகம\u{bcd}",
                "உணவு",
                "சூப\u{bcd}",
                "நூடூல\u{bcd}ஸ\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఆవ\u{c3f}ర\u{c3f} గ\u{c3f}న\u{c4d}న\u{c46}"),
            keywords: &[
                "ఆవ\u{c3f}ర\u{c3f} గ\u{c3f}న\u{c4d}న\u{c46}",
                "ఆవ\u{c3f}ర\u{c3f} ప\u{c46}ట\u{c4d}టడం",
                "గ\u{c3f}న\u{c4d}న\u{c46}",
                "నూడుల\u{c4d}స\u{c4d}",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("зарф барои ҷӯшондан"),
            keywords: &[
                "дар об пӯхтан",
                "зарф барои ҷӯшондан",
                "коса",
                "макарон",
                "рамен",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ราเมน"),
            keywords: &[
                "ชามก\u{e4b}วยเต\u{e35}\u{e4b}ยว",
                "บะหม\u{e35}\u{e48}",
                "ราเมน",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("bugarýan jam"),
            keywords: &["bugarýan", "jam", "spagetti", "unaş"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kulo mao"),
            keywords: &["kulo mao"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("erişte"),
            keywords: &[
                "buharda pişmiş",
                "erişte",
                "noodle",
                "noodle tabağı",
                "restoran",
                "tabak",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ھورلۇق قاچا"),
            keywords: &["ئۈگرە", "قاچا", "لەغمەن", "ھور", "ھورلۇق قاچا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("миска, з якої піднімається пара"),
            keywords: &[
                "локшина",
                "миска",
                "миска, з якої піднімається пара",
                "парувати",
                "рамен",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بھاپ نکالتا پیالہ"),
            keywords: &["بھاپ نکالتا پیالہ", "نوڈل", "پیالہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("issiq lag‘mon"),
            keywords: &["issiq", "kosa", "lag‘mon", "ramyon"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bát mì"),
            keywords: &["bát", "bát mì", "hấp", "mì dẹt", "mì ramen"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("toggee ci wapër"),
            keywords: &[
                "bool",
                "espageti-laxasu",
                "ramen",
                "toggee ci wapër",
                "wapër",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isitya esiqhumayo"),
            keywords: &[
                "eqhumayo",
                "i-noodle",
                "i-ramen",
                "isitya",
                "isitya esiqhumayo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Abọ ibọhun"),
            keywords: &["Abọ ibọhun", "abọ\u{301}", "núdù", "oru", "rámẹ\u{300}n"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("有蒸氣嘅碗"),
            keywords: &["拉麵", "有蒸氣嘅碗", "碗", "蒸氣", "麵"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("有蒸气嘅碗"),
            keywords: &["拉面", "有蒸气嘅碗", "碗", "蒸气", "面"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("面条"),
            keywords: &["拉面", "热气腾腾", "碗", "面条"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("湯麵"),
            keywords: &["湯麵", "麵"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("熱氣騰騰嘅碗"),
            keywords: &["拉麵", "湯麵", "熱氣騰騰嘅碗", "麵碗"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isitsha esishunqayo"),
            keywords: &["isitsha", "isitsha esishunqayo", "noodle", "ukushunqa"],
        },
    ],
};
#[doc = "🍝"]
pub const SPAGHETTI: crate::Emoji = crate::Emoji {
    glyph: "🍝",
    codepoint: "1F35D",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "spaghetti",
    group: "Food & Drink",
    subgroup: "food-asian",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("spaghetti"),
            keywords: &["kos", "pasta", "spaghetti"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ስፓጌቲ"),
            keywords: &["ስፓጌቲ", "ፖስታ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سباغتي"),
            keywords: &["باستا", "سباغتي", "مطعم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("স\u{9cd}প\u{9be}ঘেটি"),
            keywords: &["প\u{9be}ষ\u{9cd}ট\u{9be}", "স\u{9cd}প\u{9be}ঘেটি"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("spagetti"),
            keywords: &["makaron", "spagetti"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("спагеці"),
            keywords: &["макароны", "паста", "спагеці"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("спагети"),
            keywords: &["паста", "спагети"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9cd}প\u{9cd}য\u{9be}গেটি"),
            keywords: &["প\u{9be}স\u{9cd}ত\u{9be}", "স\u{9cd}প\u{9cd}য\u{9be}গেটি"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("spaghetti"),
            keywords: &["spaghetti", "toazennoù"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("špageti"),
            keywords: &["pasta", "špageti"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("espaguetis"),
            keywords: &["espaguetis", "pasta"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏍᏆᎨᏘ"),
            keywords: &["ᎦᎸᏅ", "ᏍᏆᎨᏘ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("špagety"),
            keywords: &["těstoviny", "špagety"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sbageti"),
            keywords: &["pasta", "sbageti"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("spaghetti"),
            keywords: &["pasta", "restaurant", "spaghetti"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Spaghetti"),
            keywords: &["Nudeln mit Tomatensoße", "Pasta", "Spaghetti"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: None,
            keywords: &["Spaghetti"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σπαγκέτι"),
            keywords: &["μακαρόνια", "σπαγκέτι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("spaghetti"),
            keywords: &["pasta", "spaghetti"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("espagueti"),
            keywords: &["espagueti", "pasta", "restaurante"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["comida", "espagueti", "espaguetis", "pastas", "restaurante"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "comida",
                "comida italiana",
                "espagueti",
                "espaguetis",
                "pastas",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["espagueti", "pasta espagueti"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("spagetid"),
            keywords: &["pasta", "spagetid"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("espagetiak"),
            keywords: &["espagetiak", "pasta"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("اسپاگتی"),
            keywords: &["اسپاگتی", "پاستا"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("spagetti"),
            keywords: &["pasta", "spagetti"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("spaghetti"),
            keywords: &["italian", "pagkain", "pasta", "spaghetti"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("spaghetti"),
            keywords: &["matur", "pasta", "spagetti", "spaghetti", "tomatsós"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("spaghetti"),
            keywords: &["pâtes", "spaghetti"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("spaigití"),
            keywords: &["pasta", "spaigití"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("spaghetti"),
            keywords: &["nùdail", "pasta", "spaghetti"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("espaguetes"),
            keywords: &["espaguetes", "pasta", "spaghetti"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}પગ\u{ac7}ટી"),
            keywords: &[
                "પાસ\u{acd}તા",
                "ર\u{ac7}સ\u{acd}ટોરન\u{acd}ટ",
                "સ\u{acd}પગ\u{ac7}ટી",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("taliya"),
            keywords: &["fasta", "taliya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ספגטי"),
            keywords: &["מקרוני", "ספגטי", "פסטה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{94d}प\u{948}ग\u{947}टी"),
            keywords: &[
                "पास\u{94d}ता",
                "र\u{947}स\u{94d}टोर\u{947}\u{902}ट",
                "स\u{941}धिरा",
                "स\u{94d}प\u{948}ग\u{947}टी",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("špageti"),
            keywords: &["tjestenina", "špageti"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("spagetti"),
            keywords: &["spagetti", "tészta"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սպագետի"),
            keywords: &["մակարոնեղեն", "սպագետի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("spageti"),
            keywords: &["pasta", "spageti"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("òsìkapa ogologo"),
            keywords: &["òsikapa gịrịgịrị", "òsìkapa ogologo"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("spagettí"),
            keywords: &["pasta", "spagettí", "veitingastaður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("spaghetti"),
            keywords: &["pasta", "ristorante", "spaghetti"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("スパゲッティ"),
            keywords: &["スパゲッティ", "スパゲッティー", "パスタ"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bakmi sepageti"),
            keywords: &["bakmi sepageti", "pasta", "sepageti"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სპაგეტი"),
            keywords: &["მაკარონი", "პასტა", "სპაგეტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("спагетти"),
            keywords: &["паста", "спагетти"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("spaghetti"),
            keywords: &["pasta", "restaurant", "spaghetti"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ម\u{17b8}ស\u{17d2}ពែហ\u{17d2}គេទ\u{17b8} (ម\u{17b8}អ\u{17ca}\u{17b8}តាល\u{17b8})",
            ),
            keywords: &[
                "ម\u{17b8}ឆា",
                "ម\u{17b8}ស\u{17d2}ពែហ\u{17d2}គេទ\u{17b8} (ម\u{17b8}អ\u{17ca}\u{17b8}តាល\u{17b8})",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{ccd}ಪಾಗ\u{cc6}ಟ\u{ccd}ಟ\u{cbf}"),
            keywords: &["ಪಾಸ\u{ccd}ತಾ", "ಸ\u{ccd}ಪಾಗ\u{cc6}ಟ\u{ccd}ಟ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("스파게티"),
            keywords: &["면", "스파게티", "파스타"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("स\u{94d}पाग\u{947}टी"),
            keywords: &["पास\u{94d}ता", "स\u{94d}पाग\u{947}टी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("спагетти"),
            keywords: &["камыр", "спагетти"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Spagetti"),
            keywords: &["Pasta", "Spagetti"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສະປາເກ\u{eb1}ດຕ\u{eb5}\u{ec9}"),
            keywords: &["ພາສຕ\u{ec9}າ", "ສະປາເກ\u{eb1}ດຕ\u{eb5}\u{ec9}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("spagečiai"),
            keywords: &["pasta", "spagečiai"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("spageti"),
            keywords: &["pasta", "spageti"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pakēti"),
            keywords: &["pakēti", "parāoa rimurapa"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("шпагети"),
            keywords: &["паста", "шпагети"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d4d}പെഗ\u{d3e}ട\u{d4d}ടി"),
            keywords: &[
                "പ\u{d3e}സ\u{d4d}ത",
                "പ\u{d3e}സ\u{d4d}റ\u{d4d}റ",
                "ഭക\u{d4d}ഷണം",
                "സ\u{d4d}പെഗ\u{d3e}ട\u{d4d}ടി",
                "ഹോട\u{d4d}ടൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("шпагетти"),
            keywords: &["паста", "шпагетти"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{94d}प\u{945}ग\u{947}टी"),
            keywords: &["पास\u{94d}ता", "स\u{94d}प\u{945}ग\u{947}टी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("spageti"),
            keywords: &["pasta", "spageti"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("spagetti"),
            keywords: &["għaġin", "spagetti"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အ\u{102e}တလ\u{102e}ခေါက\u{103a}ဆ\u{103d}\u{1032}"),
            keywords: &["ပါစတာ", "အ\u{102e}တလ\u{102e}ခေါက\u{103a}ဆ\u{103d}\u{1032}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("spagetti"),
            keywords: &["pasta", "restaurant", "spagetti"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}पाघ\u{947}ट\u{94d}टी"),
            keywords: &["पास\u{94d}ता", "स\u{94d}पाघ\u{947}ट\u{94d}टी"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("spaghetti"),
            keywords: &["pasta", "spaghetti"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("spagetti"),
            keywords: &["pasta", "restaurant", "spagetti"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b4d}ପ\u{b3e}ଘେଟ\u{b3f}"),
            keywords: &["ପ\u{b3e}ସ\u{b4d}ତ\u{b3e}", "ସ\u{b4d}ପ\u{b3e}ଘେଟ\u{b3f}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਪ\u{a48}ਗ\u{a47}ਟੀ"),
            keywords: &["ਪਾਸਤਾ", "ਸਪ\u{a48}ਗ\u{a47}ਟੀ", "ਹ\u{a4b}ਟਲ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سپیکٹی"),
            keywords: &["خمیر ت\u{64f}وں بغیر گ\u{64f}ندھیا آٹا", "سپیکٹی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Spagẹ\u{301}ti"),
            keywords: &["Spagẹ\u{301}ti", "Ítalián Fud Wé Dẹm De Kọ\u{301}l Pásta"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("spaghetti"),
            keywords: &["kluski", "makaron", "pasta", "spaghetti"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مکروني"),
            keywords: &["مکروني", "پاسته، مکروني"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("espaguete"),
            keywords: &["espaguete", "macarronada", "macarrão"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("esparguete"),
            keywords: &["esparguete", "massa"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("espagueti"),
            keywords: &["espagueti", "pasta"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("spaghete"),
            keywords: &["paste", "spaghete"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-290"),
            keywords: &["E10-290"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("спагетти"),
            keywords: &["вермишель", "макароны", "паста", "спагетти"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("sipageti"),
            keywords: &["makaroni", "sipageti"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اسپگيٽي"),
            keywords: &["اسپگيٽي", "پاسٽا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dca}පැගට\u{dd2}"),
            keywords: &["පැස\u{dca}ට\u{dcf}", "ස\u{dca}පැගට\u{dd2}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("špagety"),
            keywords: &["cestoviny", "špagety"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("špageti"),
            keywords: &["testenine", "špageti"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("isbageeti"),
            keywords: &["baasta", "isbageeti"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("spageti"),
            keywords: &["makarona", "spageti"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("шпагете"),
            keywords: &["тeстeнине", "шпагете"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["шпагете"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("špagete"),
            keywords: &["testenine", "špagete"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["špagete"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("spagetti"),
            keywords: &["mat", "pasta", "spagetti"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("tambi"),
            keywords: &["tambi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஸ\u{bcd}ப\u{bbe}கெட\u{bcd}டி"),
            keywords: &[
                "உணவகம\u{bcd}",
                "உணவு",
                "தக\u{bcd}க\u{bbe}ளி நூடூல\u{bcd}ஸ\u{bcd}",
                "ஸ\u{bcd}ப\u{bbe}கெட\u{bcd}டி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c4d}ప\u{c3e}గ\u{c46}ట\u{c4d}ట\u{c40}"),
            keywords: &[
                "ప\u{c3e}స\u{c4d}త\u{c3e}",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
                "స\u{c4d}పగ\u{c46}ట\u{c4d}ట\u{c40}",
                "స\u{c4d}పఘ\u{c46}ట\u{c4d}ట\u{c40}",
                "స\u{c4d}ప\u{c3e}గ\u{c46}ట\u{c4d}ట\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("спагетти"),
            keywords: &["маҳсулоти макаронӣ", "спагетти"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("สปาเก\u{e47}ตต\u{e35}\u{e49}"),
            keywords: &["พาสต\u{e49}า", "สปาเก\u{e47}ตต\u{e35}\u{e49}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("spagetti"),
            keywords: &["makaron", "spagetti"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sipeketi"),
            keywords: &["sipeketi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("spagetti"),
            keywords: &["makarna", "restoran", "spagetti"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئىتالىيە چۆپى"),
            keywords: &["ئىتالىيە چۆپى", "ئۇن تائام"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("спагеті"),
            keywords: &["паста", "спагеті"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اسپیگٹی"),
            keywords: &["اسپیگٹی", "کھانا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("spagetti"),
            keywords: &["pasta", "spagetti"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("spaghetti"),
            keywords: &["mì ống", "spaghetti"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("espageti"),
            keywords: &["espageti", "paat"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-spaghetti"),
            keywords: &["i-pasta", "i-spaghetti"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Spagẹti"),
            keywords: &["Spagẹti", "pásítà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("意大利粉"),
            keywords: &["意大利粉", "意大利麵條"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("意大利粉"),
            keywords: &["意大利粉", "意大利面条"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("意粉"),
            keywords: &["意大利面", "意粉", "意面"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("義大利麵"),
            keywords: &["義大利麵", "麵"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("意大利粉"),
            keywords: &["意大利粉", "意大利麪", "意大利麵", "意粉"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ispaghetti"),
            keywords: &["i-pasta", "ispaghetti"],
        },
    ],
};
#[doc = "🍠"]
pub const ROASTED_SWEET_POTATO: crate::Emoji = crate::Emoji {
    glyph: "🍠",
    codepoint: "1F360",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "roasted sweet potato",
    group: "Food & Drink",
    subgroup: "food-asian",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gebraaide patat"),
            keywords: &["braai", "gebraaide patat", "kos", "patat"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የተጠበሰ ስኳር ድንች"),
            keywords: &["የተጠበሰ", "የተጠበሰ ስኳር ድንች", "ድንች", "ጣፋጭ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بطاطا حلوة مشوية"),
            keywords: &["بطاطا حلوة مشوية", "بطاطا مشوية", "بطاطا معسلة", "مطعم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("পোৰ\u{9be} মিঠ\u{9be} আল\u{9c1}"),
            keywords: &["আল\u{9c1}", "পোৰ\u{9be}", "মিঠ\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qızardılmış şirin kartof"),
            keywords: &["kartof", "qızardılmış", "şirin"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("запечаная салодкая бульба"),
            keywords: &["бульба", "запечаная салодкая бульба", "запечаны", "салодкі"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Печен сладък картоф"),
            keywords: &["Печен сладък картоф", "картоф", "печен", "сладък"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("রোস\u{9cd}ট কর\u{9be} মিষ\u{9cd}টি আল\u{9c1}"),
            keywords: &[
                "আল\u{9c1}",
                "মিষ\u{9cd}টি",
                "রোস\u{9cd}ট কর\u{9be}",
                "রোস\u{9cd}ট কর\u{9be} মিষ\u{9cd}টি আল\u{9c1}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("patatez dous rostet"),
            keywords: &["dous", "patatez", "rostet"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("slatki pečeni krompir"),
            keywords: &["krompir", "pečeni", "slatki"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("moniato rostit"),
            keywords: &["moniato", "rostit"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏚᏅ ᏄᎾ ᎠᏂᏅᎯᏓ"),
            keywords: &["ᎤᎦᎾᏍᏓ", "ᎦᏚᏅ", "ᎦᏚᏅ ᏄᎾ ᎠᏂᏅᎯᏓ", "ᏄᎾ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("opékaný batát"),
            keywords: &["brambora", "jam", "opékaný", "opékaný batát", "sladký"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("taten felys wedi’i rostio"),
            keywords: &["melys", "rostio", "taten felys wedi’i rostio", "tato"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sød kartoffel"),
            keywords: &["kartoffel", "stegt", "sød"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("geröstete Süßkartoffel"),
            keywords: &["Süßkartoffel", "geröstet", "geröstete Süßkartoffel"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Geröstete Süsskartoffel"),
            keywords: &["Geröstete Süsskartoffel", "Süsskartoffel", "geröstet"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ψητή γλυκοπατάτα"),
            keywords: &["γλυκιά", "πατάτα", "ψητή", "ψητή γλυκοπατάτα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("roasted sweet potato"),
            keywords: &["potato", "roasted", "sweet"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("patata asada"),
            keywords: &["asada", "papa asada", "patata", "restaurante"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("batata asada"),
            keywords: &["asada", "batata", "comida", "restaurante"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["asada", "batata", "comida", "planta", "tubérculo"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("camote asado"),
            keywords: &["asado", "camote"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("röstitud bataat"),
            keywords: &["kartul", "röstitud", "röstitud bataat"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("batata errea"),
            keywords: &["batata", "batata errea", "erre"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("سیب\u{200c}زمینی شیرین کباب\u{200c}شده"),
            keywords: &[
                "سیب زمینی شیرین",
                "سیب\u{200c}زمینی",
                "سیب\u{200c}زمینی شیرین",
                "سیب\u{200c}زمینی شیرین کباب\u{200c}شده",
                "کبابی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("paahdettu bataatti"),
            keywords: &[
                "bataatti",
                "paahdettu",
                "paistettu bataatti",
                "uunipaahdettu",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("inihaw na kamote"),
            keywords: &["inihaw", "inihaw na kamote", "kamote", "pagkain"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("søtt epli"),
            keywords: &["epli", "matur", "søtt"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("patate douce"),
            keywords: &["patate", "patate douce"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("patate douce grillée"),
            keywords: &["douce", "grillée", "patate"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("práta milis"),
            keywords: &["fata", "ionam", "práta", "práta milis", "rósta"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("buntàta milis ròsta"),
            keywords: &["buntàta", "milis", "ròiste", "ròsta"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("pataca doce"),
            keywords: &["doce", "pataca"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("શ\u{ac7}ક\u{ac7}લ\u{ac1}\u{a82} શક\u{acd}કરિય\u{ac1}\u{a82}"),
            keywords: &[
                "ગળ\u{acd}ય\u{ac1}\u{a82}",
                "ર\u{ac7}સ\u{acd}ટોરન\u{acd}ટ",
                "શક\u{acd}કરિય\u{ac1}\u{a82}",
                "શ\u{ac7}ક\u{ac7}લા\u{a82} બટાકા",
                "શ\u{ac7}ક\u{ac7}લ\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("gasasshen dankali"),
            keywords: &["dankali", "gasasshe", "gasasshen dankali", "zaƙi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("בטטה צלויה"),
            keywords: &["בטטה", "צלויה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सिक\u{947} शकरक\u{902}द"),
            keywords: &[
                "मीठा",
                "र\u{947}स\u{94d}टोर\u{947}\u{902}ट",
                "शकरक\u{902}द",
                "सिका ह\u{941}आ",
                "सिक\u{947} आल\u{942}",
                "सिक\u{947} शकरक\u{902}द",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("pečeni batat"),
            keywords: &["batat", "krumpir", "pečeni batat", "pečeno"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("sült édesburgonya"),
            keywords: &["burgonya", "sült édesburgonya", "édesburgonya", "étel"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կարմրացրած քաղցր կարտոֆիլ"),
            keywords: &["կարմրացրած", "կարտոֆիլ", "քաղցր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("ubi panggang"),
            keywords: &["kentang", "manis", "panggang", "ubi panggang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ji bèkee ahụrụ àhụ\u{301}"),
            keywords: &[
                "ahụrụ àhụ",
                "ji bèkee",
                "ji bèkee ahụrụ àhụ\u{301}",
                "ji ụtọ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("steiktar sætar kartöflur"),
            keywords: &["kartafla", "steikt", "steiktar sætar kartöflur", "sæt"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("patata dolce arrosto"),
            keywords: &[
                "arrosto",
                "dolce",
                "patata arrosto",
                "patata dolce",
                "patata dolce arrosto",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("焼き芋"),
            keywords: &["サツマイモ", "焼き芋", "芋"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tela pendhem panggang"),
            keywords: &["panggang", "tela pendhem", "tela pendhem panggang"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("შემწვარი ტკბილი კარტოფილი"),
            keywords: &["კარტოფილი", "ტკბილეული", "ტკბილი", "შემწვარი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қуырылған картофель"),
            keywords: &["картофель", "тәтті", "қуырылған"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("sød kartoffel"),
            keywords: &["kartoffel", "stegt", "sød"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ដ\u{17c6}ឡ\u{17bc}ងជ\u{17d2}វា"),
            keywords: &[
                "ដ\u{17c6}ឡ\u{17bc}ងជ\u{17d2}វា",
                "ដ\u{17c6}ឡ\u{17bc}\u{17bc}ង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹುರ\u{cbf}ದ ಗ\u{cc6}ಣಸು"),
            keywords: &[
                "ಗ\u{cc6}ಣಸು",
                "ಹುರ\u{cbf}ದ ಆಲ\u{cc2}ಗಡ\u{ccd}ಡ\u{cc6}",
                "ಹುರ\u{cbf}ದ ಗ\u{cc6}ಣಸು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("고구마"),
            keywords: &["고구마", "삶은 고구마", "찐 고구마"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("तळिल\u{94d}ल\u{947}\u{902} कण\u{902}ग"),
            keywords: &[
                "गोड",
                "तळिल\u{94d}ल\u{947}\u{902}",
                "तळिल\u{94d}ल\u{947}\u{902} कण\u{902}ग",
                "बटाट",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("куурулган таттуу картошка"),
            keywords: &["картошка", "куурулган", "таттуу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Séissgromper"),
            keywords: &["Gromper", "Séissgromper", "gebroden", "séiss"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ມ\u{eb1}ນຫວານໜ\u{eb6}\u{ec9}ງ"),
            keywords: &[
                "ມ\u{eb1}ນ",
                "ມ\u{eb1}ນຫວານໜ\u{eb6}\u{ec9}ງ",
                "ຫວານ",
                "ອ\u{ebb}ບ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kepta saldžioji bulvė"),
            keywords: &["bulvė", "kepta", "kepta saldžioji bulvė", "saldi"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("cepti saldie kartupeļi"),
            keywords: &["cepti saldie kartupeļi", "cepts", "kartupeļi", "salds"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kūmara tunutunu"),
            keywords: &["kūmara tunutunu", "reka", "rīwai", "tukutuku"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("печен сладок компир"),
            keywords: &["компир", "печен", "сладок"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പൊരിച\u{d4d}ച ഉര\u{d41}ളക\u{d4d}കിഴങ\u{d4d}ങ\u{d4d}"),
            keywords: &[
                "പൊരിച\u{d4d}ച ഉര\u{d41}ളക\u{d4d}കിഴങ\u{d4d}ങ\u{d4d}",
                "പൊരിച\u{d4d}ചത\u{d4d}",
                "ഭക\u{d4d}ഷണം",
                "റോസ\u{d4d}റ\u{d4d}റഡ\u{d4d} സ\u{d4d}വീറ\u{d4d}റ\u{d4d} പൊട\u{d4d}ട\u{d3e}റ\u{d4d}റോ",
                "ഹോട\u{d4d}ടൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("шарсан чихэрлэг төмс"),
            keywords: &["төмс", "чихэрлэг", "шарсан"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("भाजल\u{947}ल\u{947} रताळ\u{947}"),
            keywords: &[
                "गोड",
                "बटाट\u{947}",
                "भाजल\u{947}ल\u{947}",
                "भाजल\u{947}ल\u{947} रताळ\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("ubi keledek bakar"),
            keywords: &["kentang", "manis", "panggang", "ubi keledek bakar"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("patata ħelwa mixwija"),
            keywords: &["mixwija", "patata", "ħelwa"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကင\u{103a}ထားသည\u{1037}\u{103a} ကန\u{103a}စ\u{103d}န\u{103a}းဥ"),
            keywords: &[
                "ကင\u{103a}ထားသည\u{1037}\u{103a} ကန\u{103a}စ\u{103d}န\u{103a}းဥ",
                "ကန\u{103a}စ\u{103d}န\u{103a}းဥ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bakt søtpotet"),
            keywords: &["bakt", "potet", "restaurant", "søtpotet"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("रोस\u{94d}ट गरिएको सखरखण\u{94d}ड"),
            keywords: &[
                "रोस\u{94d}ट गरिएको मीठो आल\u{941}",
                "रोस\u{94d}ट गरिएको सखरखण\u{94d}ड",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gepofte zoete aardappel"),
            keywords: &["aardappel", "gepoft", "gepofte zoete aardappel", "zoet"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bakt søtpotet"),
            keywords: &["bakt", "potet", "restaurant", "søtpotet"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପୋଡ\u{b3c}\u{b3e} କନ\u{b4d}ଦମ\u{b42}ଳ"),
            keywords: &[
                "ଆଳ\u{b41}",
                "ପୋଡ\u{b3c}\u{b3e} କନ\u{b4d}ଦମ\u{b42}ଳ",
                "ମ\u{b3f}ଠ\u{b3e}",
                "ସେକ\u{b3e} ହୋଇଥ\u{b3f}ବ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਭ\u{a41}\u{a70}ਨੀ ਸ\u{a3c}ਕਰਕ\u{a70}ਦੀ"),
            keywords: &[
                "ਆਲ\u{a42}",
                "ਭ\u{a41}\u{a70}ਨਿਆ ਆਲ\u{a42}",
                "ਭ\u{a41}\u{a70}ਨੀ ਸ\u{a3c}ਕਰਕ\u{a70}ਦੀ",
                "ਸ\u{a3c}ਕਰਕ\u{a70}ਦੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("تلے ہوئے میٹھے آلو"),
            keywords: &[
                "آلو",
                "ب\u{64f}ھونیا ہوئیا",
                "تلے ہوئے میٹھے آلو",
                "میٹھائی",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Swít Potéto Wé Dẹm Rost"),
            keywords: &[
                "Potéto",
                "Rost",
                "Róstẹd",
                "Swit",
                "Swít Potéto Wé Dẹm Rost",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pieczony batat"),
            keywords: &["batat", "pieczony batat", "słodki ziemniak"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سور شوی خوږ آلو"),
            keywords: &["آلو، سور شوی، خوږ", "سور شوی خوږ آلو"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("batata assada"),
            keywords: &["assada", "batata", "batata-doce"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("batata-doce assada"),
            keywords: &["assada", "batata", "batata-doce assada", "doce"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("miski waykʼusqa papa"),
            keywords: &["miski", "papa", "waykʼusqa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cartof dulce copt"),
            keywords: &["cartof", "copt", "dulce"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-293"),
            keywords: &["E10-293"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("печеный сладкий картофель"),
            keywords: &[
                "батат",
                "картошка",
                "печеный сладкий картофель",
                "сладкий картофель",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikijumba cyokeje"),
            keywords: &["Ikijumba cyokeje", "ikijumba cyokeje"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڀڳل مٺي گجر"),
            keywords: &["ڀڳل مٺي گجر", "گجر، ڀڳل، مٺي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("රෝස\u{dca}ට\u{dca} කළ බතල"),
            keywords: &[
                "අල",
                "පැණ\u{dd2} රස",
                "රෝස\u{dca}ට\u{dca} කළ",
                "රෝස\u{dca}ට\u{dca} කළ බතල",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("pečený sladký zemiak"),
            keywords: &["pečený", "sladký", "zemiak"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("pečeni sladki krompir"),
            keywords: &["krompir", "pečeni sladki krompir", "pečeno", "sladko"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("bataata la solay"),
            keywords: &["bataata", "bataata la solay", "la solay", "macaan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("patate e ëmbël e pjekur"),
            keywords: &["e pjekur", "e ëmbël", "patate", "patate e ëmbël e pjekur"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("печени слатки кромпир"),
            keywords: &["кромпир", "пeчeнo", "печени слатки кромпир", "слатки"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("pečeni slatki krompir"),
            keywords: &["krompir", "pečeni slatki krompir", "pečeno", "slatki"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("rostad sötpotatis"),
            keywords: &["rostad potatis", "rostad sötpotatis", "sötpotatis"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kiazi kitamu kilichochomwa"),
            keywords: &["kiazi", "kiazi kitamu kilichochomwa", "kuchoma", "tamu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வறுத\u{bcd}த உருளைக\u{bcd}கிழங\u{bcd}கு"),
            keywords: &[
                "உணவு",
                "கிழங\u{bcd}கு",
                "சர\u{bcd}க\u{bcd}கரைவள\u{bcd}ளிக\u{bcd} கிழங\u{bcd}கு",
                "வறுத\u{bcd}த உருளைக\u{bcd}கிழங\u{bcd}கு",
                "வறுத\u{bcd}தது",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c3e}ల\u{c4d}చ\u{c3f}న చ\u{c3f}లకడ దుంప"),
            keywords: &[
                "క\u{c3e}ల\u{c4d}చ\u{c3f}న చ\u{c3f}లకడ దుంప",
                "క\u{c3e}ల\u{c4d}చ\u{c3f}న త\u{c3f}య\u{c4d}యన\u{c3f} బంగ\u{c3e}ళ దుంపలు",
                "క\u{c3e}ల\u{c4d}చ\u{c3f}న బంగ\u{c3e}ళ దుంపలు",
                "క\u{c3e}ల\u{c4d}చ\u{c3f}నవ\u{c3f}",
                "త\u{c3f}య\u{c4d}యన\u{c3f} బంగ\u{c3e}ళ దుంపలు",
                "త\u{c3f}య\u{c4d}యన\u{c3f}వ\u{c3f}",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("картошкаи ширини пухташуда"),
            keywords: &[
                "картошка",
                "картошкаи ширини пухташуда",
                "пухташуда",
                "ширин",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ม\u{e31}นเผา"),
            keywords: &["ม\u{e31}นเทศเผา", "ม\u{e31}นเผา"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gowrulan ýeralma"),
            keywords: &["gowrulan", "süýji", "ýeralma"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kumala tunu"),
            keywords: &["kumala tunu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("fırınlanmış patates"),
            keywords: &[
                "fırınlanmış patates",
                "fırınlanmış tatlı patates",
                "restoran",
                "tatlı",
                "tatlı patates",
                "tırınlanmış",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تاتلىق بەرەڭگە قىزارتمىسى"),
            keywords: &["بەرەڭگە", "تاتلىق", "تاتلىق بەرەڭگە قىزارتمىسى", "قورۇلغان"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("печений батат"),
            keywords: &["батат", "печений батат", "печений топінамбур", "смажити"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ب\u{64f}ھنا ہوا میٹھا آلو"),
            keywords: &[
                "آلو",
                "ب\u{64f}ھنا ہوا",
                "ب\u{64f}ھنا ہوا میٹھا آلو",
                "میٹھا",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("jigarli batat"),
            keywords: &["jigarli batat", "kartoshka", "mazali", "qovurilgan"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("khoai lang nướng"),
            keywords: &["khoai", "khoai lang nướng", "ngọt", "nướng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("pataas buñ roti"),
            keywords: &["pataas buñ roti", "pombiteer", "roti", "suukër"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhatata ekroqiweyo"),
            keywords: &["ekroqiweyo", "emnandi", "ibhatata ekroqiweyo", "iitapile"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Anamọ dindin"),
            keywords: &["Anamọ dindin", "dídùn", "yíyan", "ànàmọ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("燴番薯"),
            keywords: &["燴", "燴番薯", "番薯", "薯仔"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("烩番薯"),
            keywords: &["烩", "烩番薯", "番薯", "薯仔"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("烤红薯"),
            keywords: &["地瓜", "烤地瓜", "烤红薯", "红薯"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("烤地瓜"),
            keywords: &["地瓜", "烤地瓜"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("煨蕃薯"),
            keywords: &["煨蕃薯"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubhatata othosiwe"),
            keywords: &["amazambane", "thosa", "ubhatata othosiwe", "ubumnandi"],
        },
    ],
};
#[doc = "🍢"]
pub const ODEN: crate::Emoji = crate::Emoji {
    glyph: "🍢",
    codepoint: "1F362",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "oden",
    group: "Food & Drink",
    subgroup: "food-asian",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("oden"),
            keywords: &["kebab", "oden", "seekos", "sosatie", "stokkie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ኦዴን"),
            keywords: &["ስቲክ", "ስኬወር", "ኦዴን", "ክባብ", "የባሕር ምግብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("طعام مشكل"),
            keywords: &["أودين", "طعام مشكل", "مطعم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("অ’ডেন"),
            keywords: &[
                "অ’ডেন",
                "অ’ডেন স\u{9be}গৰীয\u{9bc} খ\u{9be}দ\u{9cd}য",
                "ক\u{9be}ব\u{9be}ব",
                "ষ\u{9cd}টিক",
                "স\u{9cd}কিৱ\u{9be}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("oden"),
            keywords: &["dəniz məhsulu", "kabab", "oden", "çubuq", "şiş"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("одэн"),
            keywords: &["кебаб", "марскія прадукты", "одэн", "палка", "шампур"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("оден"),
            keywords: &["морска храна", "оден", "шиш"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ওডেন"),
            keywords: &[
                "ওডেন",
                "ক\u{9be}ঠি",
                "ক\u{9be}ব\u{9be}ব",
                "বিদ\u{9cd}ধ কর\u{9be}",
                "স\u{9be}ম\u{9c1}দ\u{9cd}রিক খ\u{9be}ব\u{9be}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("beriad pesked"),
            keywords: &["beriad", "pesked"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("oden"),
            keywords: &["kebab", "oden", "plodovi mora", "ražnjić"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("broqueta de marisc"),
            keywords: &[
                "broqueta",
                "broqueta de marisc",
                "kebab",
                "marisc",
                "oden",
                "pal",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎣᏗᏂ"),
            keywords: &["ᎠᎹᎺᏉ ᏓᏳᎶᏒ ᎠᎵᏍᏓᏰᏗ", "ᎣᏗᏂ", "ᎦᏅᏍᏓ", "ᎦᏅᏍᏗ", "ᎨᏆᏆ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("oden"),
            keywords: &[
                "kebab",
                "mořské plody",
                "oden",
                "plody moře",
                "tyčka",
                "špejle",
                "špíz",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("oden"),
            keywords: &["bwyd môr", "cebab", "oden", "sgiwer"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mad på spyd"),
            keywords: &[
                "fisk",
                "grillspyd",
                "kebab",
                "mad på spyd",
                "pind",
                "skaldyr",
                "spyd",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Oden"),
            keywords: &["Oden", "Restaurant", "japanisches Gericht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("όντεν"),
            keywords: &["θαλασσινά", "καλαμάκι", "κεμπάπ", "σουβλάκι", "όντεν"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("oden"),
            keywords: &["kebab", "oden", "seafood", "skewer", "stick"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("brocheta"),
            keywords: &["brocheta", "japonés", "marisco", "oden", "pincho"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("brocheta de mariscos"),
            keywords: &[
                "brocheta de mariscos",
                "brochetas",
                "brochettes",
                "comida",
                "japonesa",
                "mariscos",
                "restaurante",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "brocheta de mariscos",
                "brochetas",
                "brochettes",
                "comida",
                "mariscos",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "brocheta",
                "brocheta de mariscos",
                "kebab",
                "mariscos",
                "palo",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("oden"),
            keywords: &["kebab", "mereannid", "oden", "pulk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("oden"),
            keywords: &["broxeta", "itsaski", "kebab", "makil", "oden"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("اودن"),
            keywords: &["اودن", "سیخ", "غذای دریایی", "کباب"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("oden"),
            keywords: &["merenelävät", "oden", "tikku", "varras"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("oden"),
            keywords: &["nakatuhog", "oden", "pagkain", "tuhog"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("matpinnur"),
            keywords: &[
                "grillspjót",
                "kjøtpinnur",
                "matpinnur",
                "matur",
                "pinnur",
                "sprita",
                "teinur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("brochette de poisson"),
            keywords: &["brochette", "brochette de poisson"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("oden"),
            keywords: &["brochette", "fruits de mer", "oden"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bia mara"),
            keywords: &["bia mara", "bia mara ar chipín"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("oden"),
            keywords: &["bior", "feamann", "iasg", "kebab", "maorach", "oden"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("oden"),
            keywords: &["comida xaponesa", "espeto", "marisco", "oden"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઓડ\u{ac7}ન"),
            keywords: &[
                "ઓડ\u{ac7}ન",
                "ર\u{ac7}સ\u{acd}ટોરન\u{acd}ટ",
                "સી ફ\u{ac2}ડ",
                "સ\u{acd}ટીક",
                "સ\u{acd}ટીક પર સી ફ\u{ac2}ડ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("abincin oden"),
            keywords: &["abincin oden", "abincin teku", "kebab", "sanda", "tsinke"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שיפוד"),
            keywords: &["מנגל", "על האש", "קבב", "שיפוד"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ओड\u{947}न"),
            keywords: &[
                "ओड\u{947}न",
                "र\u{947}स\u{94d}टोर\u{947}\u{902}ट",
                "सम\u{941}द\u{94d}री भोजन",
                "सीफ\u{93c}\u{942}ड स\u{94d}टिक",
                "स\u{94d}टिक",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("oden"),
            keywords: &["morski plodovi", "oden", "ražnjić", "štapić"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("oden"),
            keywords: &["japán kebab", "oden", "étel"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("օդեն"),
            keywords: &["ծովամթերք", "շամփուր", "փայտիկ", "քյաբաբ", "օդեն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("oden"),
            keywords: &["kebab", "laut", "makanan", "oden", "tempura", "udang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("efere nri"),
            keywords: &[
                "anụ amịrị amị",
                "efere nri",
                "nri achịcha na naụ",
                "nriazụ",
                "osisi anụ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("oden"),
            keywords: &[
                "oden",
                "sjávarréttir",
                "sjávarréttir á teini",
                "veitingastaður",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("oden giapponese"),
            keywords: &[
                "oden",
                "oden giapponese",
                "pesce",
                "ristorante",
                "spiedino",
                "spiedino di pesce",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("おでん"),
            keywords: &["おでん"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sate oden"),
            keywords: &["iwak laut", "kebab", "oden", "sate", "sunduk"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ოდენი"),
            keywords: &["ზღვის პროდუქტები", "ოდენი", "შამფური", "შაურმა", "ჯოხი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("оден"),
            keywords: &["кебаб", "оден", "таяқша", "теңіз тағамы", "іспара"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("mad på spyd"),
            keywords: &[
                "fisk",
                "grillspyd",
                "kebab",
                "mad på spyd",
                "pind",
                "skaldyr",
                "spyd",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17d2}ហ\u{17bc}បដោតចង\u{17d2}កាក\u{17cb}"),
            keywords: &[
                "ម\u{17d2}ហ\u{17bc}បដោតចង\u{17d2}កាក\u{17cb}",
                "សាច\u{17cb}ចង\u{17d2}កាក\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಓಡನ\u{ccd}"),
            keywords: &["ಓಡನ\u{ccd}", "ಕಡ\u{ccd}ಡ\u{cbf}", "ಸಮುದ\u{ccd}ರಾಹಾರ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("오뎅"),
            keywords: &["어묵", "어묵꼬치", "오뎅", "오뎅꼬치"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ओड\u{947}न"),
            keywords: &[
                "ओड\u{947}न",
                "कबाब",
                "न\u{941}स\u{94d}त\u{94d}य\u{947}\u{902}",
                "स\u{94d}किव\u{947}र",
                "स\u{94d}टिक",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("оден"),
            keywords: &["деңиз тамагы", "кебаб", "оден", "чыбык", "шампур"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Oden"),
            keywords: &["Broschett", "Kebab", "Mieresfriichten", "Oden"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໂອເດ\u{ec9}ງສຽບໄມ\u{ec9}"),
            keywords: &["ໂອເດງສຽບໄມ\u{ec9}", "ໂອເດ\u{ec9}ງສຽບໄມ\u{ec9}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("odenas"),
            keywords: &["iešmas", "jūros gėrybės", "kebabas", "lazdelė", "odenas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ēdiens uz irbulīšiem"),
            keywords: &["irbulīši", "ēdiens", "ēdiens uz irbulīšiem"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("otene"),
            keywords: &["kaimoana", "kepapa", "otene", "rākau", "wero"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("јапонски ражен"),
            keywords: &["морска храна", "ражен", "стап", "јапонски ражен", "ќебап"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഓഡെൻ"),
            keywords: &[
                "ഓഡെൻ",
                "കബ\u{d3e}ബ\u{d4d}",
                "ഭക\u{d4d}ഷണം",
                "സീഫ\u{d41}ഡ\u{d4d}",
                "സ\u{d4d}റ\u{d4d}റിക\u{d4d}ക\u{d4d}",
                "ഹോട\u{d4d}ടൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("удэн"),
            keywords: &["далайн гаралтай хоол", "иш", "кебаб", "удэн", "шорлог"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ओड\u{947}न"),
            keywords: &[
                "ओड\u{947}न",
                "कबाब",
                "सीफ\u{941}ड",
                "स\u{94d}क\u{94d}य\u{942}अर",
                "स\u{94d}टिक",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("oden"),
            keywords: &["kayu", "kebab", "makanan laut", "oden", "sate"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("oden"),
            keywords: &["frott tal-baħar", "kebab", "oden", "skewer", "stikka"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အ\u{102d}\u{102f}ဒင\u{103a}"),
            keywords: &[
                "ခဘတ\u{103a}",
                "ပင\u{103a}လယ\u{103a}စာ",
                "သ\u{102e}တ\u{1036}",
                "အချောင\u{103a}း",
                "အ\u{102d}\u{102f}ဒင\u{103a}",
                "အ\u{102d}\u{102f}ဒင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("oden"),
            keywords: &[
                "oden",
                "restaurant",
                "sjømat",
                "sjømat på pinne",
                "sjømatspyd",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ओड\u{947}न"),
            keywords: &[
                "ओड\u{947}न",
                "कबाब",
                "सम\u{941}द\u{94d}री खाना",
                "स\u{94d}क\u{94d}विर",
                "स\u{94d}टिक",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("oden"),
            keywords: &["kebab", "oden", "spies", "stokje", "zeevruchten"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("oden"),
            keywords: &[
                "oden",
                "restaurant",
                "sjømat",
                "sjømat på pinne",
                "sjømatspyd",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଓଡେନ\u{b4d}\u{200d}"),
            keywords: &[
                "ଓଡେନ\u{b4d}\u{200d}",
                "କ\u{b3e}ଠ\u{b3f}",
                "ରେଷ\u{b4d}ଟ\u{b41}ର\u{b3e}ଣ\u{b4d}ଟ\u{b4d}",
                "ସ\u{b3e}ମ\u{b41}ଦ\u{b4d}ର\u{b3f}କ ଖ\u{b3e}ଦ\u{b4d}ୟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਓਡ\u{a47}ਨ"),
            keywords: &[
                "ਓਡ\u{a47}ਨ",
                "ਡ\u{a70}ਡੀ",
                "ਸਮ\u{a41}\u{a70}ਦਰੀ ਭ\u{a4b}ਜਨ",
                "ਸਮ\u{a41}\u{a70}ਦਰੀ ਭ\u{a4b}ਜਨ ਡ\u{a70}ਡੀ ਤ\u{a47}",
                "ਹ\u{a4b}ਟਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("اوڈن"),
            keywords: &["اوڈن", "سمندری خوراک", "لوہے دی سیخ", "چھڑی", "کباب"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ódẹn"),
            keywords: &[
                "Kẹbab",
                "Stik",
                "Sífúd",
                "Súya",
                "Súya Stik Ódẹn: Wọ\u{301}n Ọf Japán Pípul Dẹm Stiu",
                "Ódẹn",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("oden"),
            keywords: &["oden", "owoce morza", "owoce morza na patyku"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("اوډین"),
            keywords: &["اوډین", "سمندري خواړه", "سټک", "سکیور", "کباب"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("oden"),
            keywords: &[
                "espetinho",
                "frutos do mar",
                "frutos do mar no espetinho",
                "oden",
                "restaurante",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["espetada", "marisco", "oden"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("oden"),
            keywords: &[
                "brocheta",
                "ch’ampa",
                "kebab",
                "mama quchamanta mikhuna",
                "oden",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("frigăruie japoneză"),
            keywords: &["băț", "frigăruie japoneză", "fructe de mare", "oden"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-295"),
            keywords: &["E10-295"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("одэн"),
            keywords: &["закуска", "на палочке", "одэн", "шашлык"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("odeni"),
            keywords: &["boroshete", "ibinyenyanja", "inkoni", "odeni", "umushito"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اوڊن"),
            keywords: &["اوڊن", "ڪباب، سامونڊي کاڌو، شيخ، ڪاٺي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඕඩන\u{dca}"),
            keywords: &[
                "ඕඩන\u{dca}",
                "කෙබෑබ\u{dca}",
                "කෝට\u{dd4}ව",
                "මස\u{dca} ක\u{dd6}ර",
                "ම\u{dd4}හ\u{dd4}ද\u{dd4} ආහ\u{dcf}ර",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("jedlo na špajdli"),
            keywords: &["ihlica", "jedlo na špajdli", "kebab", "ražeň"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("oden"),
            keywords: &["kebab", "morska hrana", "oden", "paličica", "špila"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("cunno hal digsi wax badan ka kooban"),
            keywords: &[
                "cunno badeed",
                "cunno hal digsi wax badan ka kooban",
                "keebaab",
                "ul",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("oden"),
            keywords: &["fruta deti", "hell", "oden", "qebap", "shkop"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("оден"),
            keywords: &["мoрски плoдoви", "оден", "рaжњић", "штaпић"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("oden"),
            keywords: &["morski plodovi", "oden", "ražnjić", "štapić"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("skaldjursspett"),
            keywords: &["skaldjur", "skaldjursspett", "spett"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("odeni"),
            keywords: &[
                "chakula cha majini",
                "kebabu",
                "kibaniko",
                "kijiti",
                "odeni",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஓடேன\u{bcd}"),
            keywords: &[
                "ஓடேன\u{bcd}",
                "கடல\u{bcd} உணவு",
                "கப\u{bbe}ப\u{bcd}",
                "குச\u{bcd}சி",
                "ஸ\u{bcd}கியூவர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఓడ\u{c46}న\u{c4d}"),
            keywords: &[
                "ఓడ\u{c46}న\u{c4d}",
                "పుల\u{c4d}ల",
                "పుల\u{c4d}లత\u{c4b} త\u{c3f}న\u{c3e}ల\u{c4d}స\u{c3f}న సముద\u{c4d}ర\u{c3e}హ\u{c3e}రం",
                "పుల\u{c4d}లత\u{c4b} త\u{c3f}న\u{c3e}ల\u{c4d}స\u{c3f}న స\u{c40}ఫుడ\u{c4d}",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("оден"),
            keywords: &["кабоб", "маҳсулоти баҳрӣ", "оден", "сихкабоб", "чӯб"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("โอเด\u{e49}ง"),
            keywords: &["โอเด\u{e49}ง", "โอเด\u{e49}งเส\u{e35}ยบไม\u{e49}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("oden"),
            keywords: &["deňiz iýmidi", "kebap", "oden", "çişlik", "şampur"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻoteni"),
            keywords: &["ʻoteni"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("oden"),
            keywords: &["oden", "restoran", "çubuk", "çubukta deniz ürünleri"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئودېن"),
            keywords: &["ئودېن", "دېڭىز يېمەكلىكلىرى", "دەستە", "زىق", "كاۋاپ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("оден"),
            keywords: &["кебаб", "морський", "оден", "шампур", "їжа"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اوڈن"),
            keywords: &["اوڈن", "سمندری کھانا", "سٹک", "کباب"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("sixdagi dengiz taomi"),
            keywords: &["dengiz taomi", "kabob", "six", "sixdagi dengiz taomi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("món oden"),
            keywords: &["hải sản", "kẹp", "món oden", "que", "xiên"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("oden"),
            keywords: &["broset", "fruit", "kebab", "meññeefu géej", "oden"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-oden"),
            keywords: &[
                "i-kebab",
                "i-oden",
                "i-skewer",
                "intonga",
                "ukutya kwaselwandle",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oden"),
            keywords: &["Oden", "igi", "keháb", "síkíwà", "ónjẹ omi"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("串燒"),
            keywords: &["串燒", "棒", "海鮮", "烤肉串"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("串烧"),
            keywords: &["串烧", "棒", "海鲜", "烤肉串"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("关东煮"),
            keywords: &["串", "关东煮", "海鲜"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("關東煮"),
            keywords: &["烤肉串", "關東煮"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["海鮮", "烤肉串", "竹籤", "關東煮"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-oden"),
            keywords: &["i-oden", "ikebhabhu", "induku", "ukudla kwasolwandle"],
        },
    ],
};
#[doc = "🍣"]
pub const SUSHI: crate::Emoji = crate::Emoji {
    glyph: "🍣",
    codepoint: "1F363",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "sushi",
    group: "Food & Drink",
    subgroup: "food-asian",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("soesji"),
            keywords: &["kos", "rys", "soesji", "vis"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሱሺ"),
            keywords: &["ሱሺ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سوشي"),
            keywords: &["سوشي", "مطعم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চ\u{9c1}চি"),
            keywords: &["চ\u{9c1}চি"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("suşi"),
            keywords: &["suşi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сушы"),
            keywords: &["сусі", "сушы"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("суши"),
            keywords: &["суши"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9c1}শি"),
            keywords: &["স\u{9c1}শি"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("sushi"),
            keywords: &["pesked", "sushi"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("suši"),
            keywords: &["suši"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("sushi"),
            keywords: &["cru", "peix", "sushi"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏑᏴᎾ ᎠᎩᏍᏗ"),
            keywords: &["ᎠᏑᏴᎾ ᎠᎩᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("suši"),
            keywords: &["sushi", "suši"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("swshi"),
            keywords: &["swshi"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sushi"),
            keywords: &["sushi", "sushi-restaurant"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Sushi"),
            keywords: &["Restaurant", "Sushi", "japanisches Gericht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σούσι"),
            keywords: &["σούσι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("sushi"),
            keywords: &["sushi"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("sushi"),
            keywords: &["restaurante", "sushi"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["comida", "japonesa", "sushi"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("suši"),
            keywords: &["suši"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("sushi"),
            keywords: &["sushi"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("سوشی"),
            keywords: &["خوراک ژاپنی", "سوشی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("sushi"),
            keywords: &["raaka kala", "riisi", "sushi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("sushi"),
            keywords: &["japanese", "kanin", "pagkain", "seafood", "sushi"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sushi"),
            keywords: &["matur", "sushi", "susji"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("sushi"),
            keywords: &["japonais", "poisson", "sushi"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("sushi"),
            keywords: &["sushi"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sushi"),
            keywords: &["sushi"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("suxi"),
            keywords: &["sushi", "suxi"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{ac1}શી"),
            keywords: &["ર\u{ac7}સ\u{acd}ટોરન\u{acd}ટ", "સ\u{ac1}શી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("sushi"),
            keywords: &["sushi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סושי"),
            keywords: &["יפני", "סושי"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{941}शी"),
            keywords: &["र\u{947}स\u{94d}टोर\u{947}\u{902}ट", "स\u{941}शी"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("sushi"),
            keywords: &["sushi"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szusi"),
            keywords: &["szusi", "étel"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սուշի"),
            keywords: &["սուշի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("sushi"),
            keywords: &["sushi"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("àchịcha nwere akwa etere ofe"),
            keywords: &["àchịcha nwere akwa etere ofe"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sushi"),
            keywords: &["sushi", "veitingastaður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("sushi"),
            keywords: &["ristorante", "sushi"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("すし"),
            keywords: &["お寿司", "すし"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("susi"),
            keywords: &["susi"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სუში"),
            keywords: &["სუში"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("суши"),
            keywords: &["суши"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("sushi"),
            keywords: &["sushi", "sushi-restaurant"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17ca}\u{17bc}ស\u{17ca}\u{17b8}"),
            keywords: &[
                "បាយព\u{17c6}ន\u{17bc}ត",
                "ស\u{17ca}\u{17bc}ស\u{17ca}\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಚ\u{cbf}ತ\u{ccd}ರಾನ\u{ccd}ನ"),
            keywords: &["ಚ\u{cbf}ತ\u{ccd}ರಾನ\u{ccd}ನ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("초밥"),
            keywords: &["스시", "일식", "초밥"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("स\u{941}शी"),
            keywords: &["स\u{941}शी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("суши"),
            keywords: &["суши"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Sushi"),
            keywords: &["Sushi"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຊ\u{eb9}ຊ\u{eb4}"),
            keywords: &["ຊ\u{eb9}ຊ\u{eb4}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("sušis"),
            keywords: &["suši", "sušis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("suši"),
            keywords: &["suši", "ēdiens"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("hūhi"),
            keywords: &["hūhi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("суши"),
            keywords: &["суши"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d41}ഷി"),
            keywords: &["ചൈനീസ\u{d4d}", "ഭക\u{d4d}ഷണം", "സ\u{d41}ഷി", "ഹോട\u{d4d}ടൽ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("суши"),
            keywords: &["суши"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{941}शी"),
            keywords: &["स\u{941}शी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("susyi"),
            keywords: &["susyi"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("sushi"),
            keywords: &["sushi"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဆ\u{1030}ရ\u{103e}\u{102e}"),
            keywords: &["ဆ\u{1030}ရ\u{102e}\u{1030}", "ဆ\u{1030}ရ\u{103e}\u{102e}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sushi"),
            keywords: &["restaurant", "sushi"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{941}शी"),
            keywords: &["स\u{941}शी"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("sushi"),
            keywords: &["sushi"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("sushi"),
            keywords: &["restaurant", "sushi"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b41}ଶ\u{b3f}"),
            keywords: &["ସ\u{b41}ଶ\u{b3f}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a41}ਸ\u{a3c}ੀ"),
            keywords: &["ਸ\u{a41}ਸ\u{a3c}ੀ", "ਹ\u{a4b}ਟਲ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سوشی"),
            keywords: &["سوشی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Súshi"),
            keywords: &["Súshi"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("sushi"),
            keywords: &["sushi", "suszi"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سوشي"),
            keywords: &["سوشي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("sushi"),
            keywords: &["comida japonesa", "sushi"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["sushi"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("sushi"),
            keywords: &["sushi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("sushi"),
            keywords: &["sushi"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-296"),
            keywords: &["E10-296"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("суши"),
            keywords: &["кухня", "суши", "япония"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("sushi"),
            keywords: &["sushi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("شوشي"),
            keywords: &["شوشي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dd4}ෂ\u{dd2}"),
            keywords: &["ස\u{dd4}ෂ\u{dd2}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("suši"),
            keywords: &["suši"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("suši"),
            keywords: &["suši"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("cunnada jabbaanka"),
            keywords: &["cunnada jabbaanka"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("sushi"),
            keywords: &["rulon orizi me filetë peshku", "sushi"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("суши"),
            keywords: &["суши"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("suši"),
            keywords: &["suši"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("sushi"),
            keywords: &["sushi"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("sushi"),
            keywords: &["sushi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சுஷி"),
            keywords: &["உணவகம\u{bcd}", "உணவு", "சுஷி", "ம\u{bc0}ன\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("సుష\u{c40}"),
            keywords: &[
                "జపన\u{c40}స\u{c4d} వంటకం",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
                "సుష\u{c3f}",
                "సుష\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("суши"),
            keywords: &["суши"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ซ\u{e39}ช\u{e34}"),
            keywords: &["ซ\u{e39}ช\u{e34}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("suşi"),
            keywords: &["suşi"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("susi"),
            keywords: &["susi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("suşi"),
            keywords: &["restoran", "suşi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سۇشى"),
            keywords: &["سۇشى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("суші"),
            keywords: &["суші"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سوشی"),
            keywords: &["جاپانی", "سوشی", "کھانا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("sushi"),
            keywords: &["sushi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("sushi"),
            keywords: &["sushi"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("sushi"),
            keywords: &["sushi"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-sushi"),
            keywords: &["i-sushi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Sushi"),
            keywords: &["Sushi"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("壽司"),
            keywords: &["壽司"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("寿司"),
            keywords: &["寿司"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("寿司"),
            keywords: &["寿司"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("壽司"),
            keywords: &["壽司"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isushi"),
            keywords: &["isushi"],
        },
    ],
};
#[doc = "🍤"]
pub const FRIED_SHRIMP: crate::Emoji = crate::Emoji {
    glyph: "🍤",
    codepoint: "1F364",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "fried shrimp",
    group: "Food & Drink",
    subgroup: "food-asian",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gebraaide garnaal"),
            keywords: &["braai", "garnaal", "gebraaide garnaal", "kos", "tempoera"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የተጠበሰ ሽሪምፕ ዓሣ"),
            keywords: &["ሽሪምፕ", "ቴምፑራ", "የተጠበሰ", "የተጠበሰ ሽሪምፕ ዓሣ", "ፕራውን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("جمبري مقلي"),
            keywords: &["جمبري", "جمبري مقلي", "مطعم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ভজ\u{9be} মিছ\u{9be}ম\u{9be}ছ"),
            keywords: &[
                "টেম\u{9cd}প\u{9c1}ৰ\u{9be}",
                "ভজ\u{9be}",
                "ভজ\u{9be} ম\u{9be}ছ",
                "মিছ\u{9be}ম\u{9be}ছ",
                "শিঙি ম\u{9be}ছ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qızardılmış krivet"),
            keywords: &["krevet", "qızardılmış", "qızardılmış krivet", "tempura"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("смажаная крэветка"),
            keywords: &["крэветка", "смажаная крэветка", "смажаны", "тэмпура"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Пържена скарида"),
            keywords: &["Пържена скарида", "пържена", "скарида", "темпура"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ভ\u{9be}জ\u{9be} চিংড\u{9bc}ি"),
            keywords: &[
                "গলদ\u{9be} চিংড\u{9bc}ি",
                "টেম\u{9cd}প\u{9c1}র\u{9be}",
                "ব\u{9be}গদ\u{9be} চিংড\u{9bc}ি",
                "ভ\u{9be}জ\u{9be}",
                "ভ\u{9be}জ\u{9be} চিংড\u{9bc}ি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bignez chevr"),
            keywords: &["bignez", "chevr"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("prženi škampi"),
            keywords: &["kozice", "prženi škampi", "prženo", "tempura", "škampi"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("gamba fregida"),
            keywords: &["fregida", "gamba", "tempura"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎬᏣᎳᏅᎢ ᏥᏅᏅ"),
            keywords: &["ᎡᏆ ᏥᏅᏅ", "ᎬᏣᎳᏅᎢ", "ᎬᏨᏝᏅ", "ᏥᏅᏅ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("smažená kreveta"),
            keywords: &["garnát", "kreveta", "smažená kreveta", "smažené", "tempura"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("berdysyn wedi’i ffrio"),
            keywords: &["berdysyn", "berdysyn wedi’i ffrio", "corgimwch"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("dybstegt reje"),
            keywords: &["dybstegt reje", "reje"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("frittierte Garnele"),
            keywords: &["Garnele", "Restaurant", "frittierte Garnele"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τηγανητή γαρίδα"),
            keywords: &["γαρίδα", "τεμπούρα", "τηγανητή γαρίδα", "τηγανιτό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("fried shrimp"),
            keywords: &["fried", "prawn", "shrimp", "tempura"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("fried prawn"),
            keywords: &[""],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("battered prawn"),
            keywords: &["battered", "fried", "prawn", "shrimp", "tempura"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("gamba frita"),
            keywords: &["frito", "gamba", "gamba frita", "restaurante"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("camarones fritos"),
            keywords: &[
                "camarones",
                "camarones fritos",
                "comida",
                "japonesa",
                "restaurante",
                "tempura",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "camarones",
                "camarones fritos",
                "comida",
                "japonesa",
                "tempura",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "camarones",
                "camarones fritos",
                "comida",
                "japonesa",
                "tempura",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("praetud krevett"),
            keywords: &["krevett", "praetud", "tempura"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gabardina-ganba"),
            keywords: &[
                "frijitu",
                "gabardina-ganba",
                "ganba",
                "langostino",
                "tenpura",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("میگو سوخاری"),
            keywords: &[
                "تمپورا",
                "سرخ\u{200c}شده",
                "شاه میگو",
                "میگو",
                "میگو سوخاری",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("paistettu katkarapu"),
            keywords: &["katkarapu", "paistettu", "tempura"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("piniritong hipon"),
            keywords: &["hipon", "pagkain", "piniritong hipon", "prito", "tempura"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("steikt rækja"),
            keywords: &["matur", "rækja", "steikt"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("beignet de crevette"),
            keywords: &["beignet de crevette", "crevette"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("crevette frite"),
            keywords: &["crevette", "crevette frite"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("séacla friochta"),
            keywords: &["séacla", "séacla friochta"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("muasgain-chaola air am fraidhigeadh"),
            keywords: &[
                "fraidhig",
                "fraidhigeadh",
                "muasgain-chaola air am fraidhigeadh",
                "muasgan-caol",
                "praidhig",
                "praidhigeadh",
                "tempura",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("gamba frita"),
            keywords: &["gamba", "gamba frita", "gamba á gabardina"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("તળ\u{ac7}લી ઝી\u{a82}ગા માછલી"),
            keywords: &[
                "ઝી\u{a82}ગા",
                "તળ\u{ac7}લી ઝી\u{a82}ગા માછલી",
                "ર\u{ac7}સ\u{acd}ટોરન\u{acd}ટ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("soyayyen jatan lande"),
            keywords: &[
                "jatan lande",
                "jatan lande turawa",
                "soyayye",
                "soyayyen jatan lande",
                "tempura",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שרימפ מטוגן"),
            keywords: &["מטוגן", "שרימפ מטוגן", "שרימפס"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("तला झी\u{902}गा"),
            keywords: &[
                "झी\u{902}गा",
                "तला झी\u{902}गा",
                "तल\u{947} झी\u{902}ग\u{947}",
                "र\u{947}स\u{94d}टोर\u{947}\u{902}ट",
                "श\u{94d}रि\u{902}प",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("prženi račić"),
            keywords: &["kozica", "prženi račić", "prženo", "račić", "tempura"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("sült garnélarák"),
            keywords: &["rák", "sült", "sült garnélarák", "tenger gyümölcsei"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տապակած ծովախեցգետին"),
            keywords: &["ծովախեցգետին", "տապակած"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("udang goreng"),
            keywords: &["goreng", "tempura", "udang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ayịya eghèrè èghe"),
            keywords: &[
                "ayịya",
                "ayịya eghèrè èghe",
                "eghèrè èghe",
                "okporo",
                "okporo eji flọ yee",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("djúpsteikt rækja"),
            keywords: &["djúpsteikt rækja", "rækja", "veitingastaður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("gambero fritto"),
            keywords: &["gambero", "gambero fritto", "ristorante"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("エビフライ"),
            keywords: &["エビ", "エビフライ", "フライ", "天ぷら"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("urang goreng"),
            keywords: &["ebi", "goreng", "tempura", "urang"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("შემწვარი კრევეტი"),
            keywords: &["კრევეტი", "ტემპურა", "შემწვარი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("темпура"),
            keywords: &["су шаяны", "темпура", "қуырылған"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("dybstegt reje"),
            keywords: &["dybstegt reje", "reje"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បង\u{17d2}គារប\u{17c6}ពង"),
            keywords: &[
                "ក\u{17c6}ព\u{17b9}ស",
                "ចៀន",
                "បង\u{17d2}គា",
                "បង\u{17d2}គារប\u{17c6}ពង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹುರ\u{cbf}ದ ಸೀಗಡ\u{cbf}"),
            keywords: &["ಸೀಗಡ\u{cbf}", "ಹುರ\u{cbf}ದ ಸೀಗಡ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("새우튀김"),
            keywords: &["새우", "새우튀김", "튀김"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("तळिल\u{94d}ल\u{947} स\u{941}\u{902}गट"),
            keywords: &[
                "ट\u{945}म\u{94d}प\u{941}रा",
                "तळिल\u{94d}ल\u{947} स\u{941}\u{902}गट",
                "तळिल\u{94d}ल\u{947}\u{902}",
                "सा\u{902}गट",
                "स\u{941}\u{902}गट",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("куурулган креветка"),
            keywords: &["креветка", "куурулган", "темпура"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Scampi-Tempura"),
            keywords: &[
                "Crevette",
                "Scampi",
                "Scampi-Tempura",
                "Tempura",
                "frittéiert",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກ\u{eb8}\u{ec9}ງທອດ"),
            keywords: &["ກ\u{eb8}\u{ec9}ງ", "ກ\u{eb8}\u{ec9}ງທອດ", "ທອດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kepta krevetė"),
            keywords: &["kepta", "krevetė", "tempura"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("cepta garnele"),
            keywords: &["cepta garnele", "cepts", "garnele", "ēdiens"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kōuraura parai"),
            keywords: &["kōura", "kōuraura", "parai", "temepura"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("пржено ракче"),
            keywords: &["пржено", "ракче"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പൊരിച\u{d4d}ച കൊഞ\u{d4d}ച\u{d4d}"),
            keywords: &[
                "കൊഞ\u{d4d}ച\u{d4d}",
                "ചെമ\u{d4d}മീൻ",
                "പൊരിച\u{d4d}ച കൊഞ\u{d4d}ച\u{d4d}",
                "ഭക\u{d4d}ഷണം",
                "ഹോട\u{d4d}ടൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("шарсан сам хорхой"),
            keywords: &["сам хорхой", "темпура", "шарсан", "шарсан сам хорхой"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("तळल\u{947}ली कोळ\u{902}बी"),
            keywords: &[
                "कोळ\u{902}बी",
                "कोळ\u{902}बी मासा",
                "ट\u{947}म\u{94d}प\u{941}रा",
                "तळल\u{947}ला कोळ\u{902}बी मासा",
                "तळल\u{947}ली कोळ\u{902}बी",
                "तळल\u{947}ल\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("udang goreng"),
            keywords: &["goreng", "tempura", "udang"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("gambli moqli"),
            keywords: &["gambli", "moqli", "tempura"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပ\u{102f}ဇ\u{103d}န\u{103a}ကြော\u{103a}"),
            keywords: &[
                "တမ\u{103a}ပ\u{1030}ရာ",
                "ပ\u{102f}စ\u{103d}န\u{103a}ဆ\u{102d}တ\u{103a}",
                "ပ\u{102f}စ\u{103d}န\u{103a}ထ\u{102f}ပ\u{103a}",
                "ပ\u{102f}ဇ\u{103d}န\u{103a}ကြော\u{103a}",
                "အကြော\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("fritert reke"),
            keywords: &[
                "fritert reke",
                "grillet scampi",
                "kongereke",
                "restaurant",
                "scampi",
                "tempura",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("फ\u{94d}राइ गर\u{947}को स\u{94d}रिम\u{94d}प"),
            keywords: &[
                "ट\u{947}म\u{94d}प\u{941}रा",
                "प\u{94d}राउन",
                "फ\u{94d}राइ गर\u{947}को",
                "फ\u{94d}राइ गर\u{947}को स\u{94d}रिम\u{94d}प",
                "स\u{94d}रिम\u{94d}प",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gefrituurde garnaal"),
            keywords: &["garnaal", "gefrituurd", "gefrituurde garnaal", "tempura"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("fritert reke"),
            keywords: &[
                "fritert reke",
                "grilla scampi",
                "kongereke",
                "restaurant",
                "scampi",
                "tempura",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଭଜ\u{b3e} ଚ\u{b3f}ଙ\u{b4d}ଗ\u{b41}ଡ\u{b3c}\u{b3f}"),
            keywords: &[
                "ଚ\u{b3f}ଙ\u{b4d}ଗ\u{b41}ଡ\u{b3c}\u{b3f}",
                "ଛଣ\u{b3e} ହୋଇଥ\u{b3f}ବ\u{b3e} ଚ\u{b3f}ଙ\u{b4d}ଗ\u{b41}ଡ\u{b3f}",
                "ଭଜ\u{b3e} ଚ\u{b3f}ଙ\u{b4d}ଗ\u{b41}ଡ\u{b3c}\u{b3f}",
                "ରେଷ\u{b4d}ଟ\u{b41}ର\u{b3e}ଣ\u{b4d}ଟ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਤੜਕਿਆ ਸ\u{a3c}ਰਿ\u{a70}ਪ"),
            keywords: &[
                "ਟ\u{a48}ਮਪ\u{a41}ਰਾ",
                "ਤੜਕਿਆ ਸ\u{a3c}ਰਿ\u{a70}ਪ",
                "ਸ\u{a3c}ਰਿ\u{a70}ਪ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("تلیا ہوئیا جھینگا"),
            keywords: &["تلیا ہوئیا", "تلیا ہوئیا جھینگا", "جھینگا", "ٹیمپورا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fraíd Shrimp"),
            keywords: &[
                "Fraíd Shrimp",
                "Fud Wé Dẹm Fari",
                "Japán Fud Wé Im Nem Na Tẹmpúra",
                "Prọn",
                "Shrimp",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("smażona krewetka"),
            keywords: &["smażona krewetka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سور شوی چنګاښ"),
            keywords: &["سور شوی چنګاښ", "سور شوی، چنګاښ، شريمپ، تيمپورا"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("camarão frito"),
            keywords: &["camarão", "camarão frito", "tempura"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["camarão", "frito", "gamba", "tempura"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("thiqtisqa yukra"),
            keywords: &["gamba", "tempura", "thiqtisqa", "yukra"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("crevete prăjit"),
            keywords: &["crevete", "crevete prăjit", "prăjire", "tempura"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-297"),
            keywords: &["E10-297"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("жареная креветка"),
            keywords: &["жареная креветка", "креветки", "темпура"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("inunda zakaranzwe mu mavuta"),
            keywords: &[
                "ikaranze",
                "inunda",
                "inunda zakaranzwe mu mavuta",
                "tempura",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("تريل جهينگا"),
            keywords: &["تريل جهينگا", "تريل، جهينگا، تمپورا، شرمپ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බද\u{dd2}න ලද ඉස\u{dca}ස\u{dcf}"),
            keywords: &[
                "ඉස\u{dca}ස\u{dcf}",
                "ක\u{dd6}න\u{dd2}ස\u{dca}ස\u{dcf}",
                "බද\u{dd2}න ලද",
                "බද\u{dd2}න ලද ඉස\u{dca}ස\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("pražená kreveta"),
            keywords: &["garnát", "kreveta", "pražená kreveta", "smažená"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ocvrt rakec"),
            keywords: &["kozica", "ocvrt rakec", "ocvrto", "rakec", "tempura"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kalluun la shiilay"),
            keywords: &[
                "kalluun",
                "kalluun la shiilay",
                "shiilan",
                "xayawaan badeed qolof ah",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("karkalec i skuqur"),
            keywords: &[
                "i skuqur",
                "karkalec",
                "karkalec deti",
                "karkalec i skuqur",
                "tempura",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("пржени шкампи"),
            keywords: &["пржeнo", "пржени шкампи", "рaчић", "тeмпурa", "шкампи"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("prženi škampi"),
            keywords: &["prženi škampi", "prženo", "račić", "tempura", "škampi"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("friterad räka"),
            keywords: &["friterad", "räka", "tempura"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uduvi iliyokaangwa"),
            keywords: &[
                "karangwa",
                "tempura",
                "uduvi",
                "uduvi iliyokaangwa",
                "ushimba",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வறுத\u{bcd}த இற\u{bbe}ல\u{bcd}"),
            keywords: &[
                "உணவகம\u{bcd}",
                "கடல\u{bcd} உணவு",
                "வறுத\u{bcd}த இற\u{bbe}ல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వ\u{c47}య\u{c3f}ంచ\u{c3f}న ర\u{c4a}య\u{c4d}య"),
            keywords: &[
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
                "ర\u{c4a}య\u{c4d}యల వ\u{c47}పుడు",
                "ర\u{c4a}య\u{c4d}యలు",
                "వ\u{c47}య\u{c3f}ంచ\u{c3f}న ర\u{c4a}య\u{c4d}య",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("креветкаи хурди бирён"),
            keywords: &[
                "бирён",
                "креветка",
                "креветкаи хурди бирён",
                "криветкаи хурд",
                "темпура",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ก\u{e38}\u{e49}งทอด"),
            keywords: &["ก\u{e38}\u{e49}ง", "ก\u{e38}\u{e49}งทอด"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gowrulan krewetka"),
            keywords: &["gowrulan", "krewetka", "krewetkajyk", "tempura"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻuosiʻisiʻi fakapaku"),
            keywords: &["ʻuosiʻisiʻi fakapaku"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kızarmış karides"),
            keywords: &["karides", "kızarmış karides", "restoran"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قورۇلغان راك"),
            keywords: &["تېمپۇرا", "دېڭىز", "راك", "قاقلانغان", "قورۇلغان راك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("смажена креветка"),
            keywords: &["креветка", "смажена креветка", "смажений", "темпура"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("تلا ہوا شرمپ"),
            keywords: &["تلا ہوا", "تلا ہوا شرمپ", "شرمپ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qovurilgan qisqichbaqa"),
            keywords: &["qisqichbaqa", "qovurilgan", "tempura"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tôm chiên"),
            keywords: &["chiên", "món sốt cá cua tôm", "tôm", "tôm hùm"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("sippax buñ saaf"),
            keywords: &["saaf", "sippax", "sippax buñ saaf", "tempura"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inqonci eqhotsiweyo"),
            keywords: &["eqhotsiweyo", "i-prawn", "i-tempura", "inqonci"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ede Dindin"),
            keywords: &["Ede Dindin", "dídín", "tẹ\u{301}mpúrà", "ṣírímpù", "ẹdẹ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("炸蝦"),
            keywords: &["大蝦", "天婦羅", "炸", "炸蝦", "蝦"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("炸虾"),
            keywords: &["大虾", "天妇罗", "炸", "炸虾", "虾"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("天妇罗"),
            keywords: &["天妇罗", "炸虾"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("天婦羅"),
            keywords: &["天婦羅", "炸蝦"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("炸蝦"),
            keywords: &["天婦羅", "炸蝦", "蝦"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ishrimpu ethosiwe"),
            keywords: &["ishrimpu", "ishrimpu ethosiwe", "isikhuphashi", "thosa"],
        },
    ],
};
#[doc = "🍥"]
pub const FISH_CAKE_WITH_SWIRL: crate::Emoji = crate::Emoji {
    glyph: "🍥",
    codepoint: "1F365",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "fish cake with swirl",
    group: "Food & Drink",
    subgroup: "food-asian",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("viskoekie met spiraal"),
            keywords: &["koekie", "kos", "spiraal", "vis", "viskoekie met spiraal"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የዓሣ ኬክ ከተሸረካከፈ ክፈፍ ጋር"),
            keywords: &["ኬክ", "ኬክና ብስኩት", "ዓሣ", "የተሸረካከፈ", "የዓሣ ኬክ ከተሸረካከፈ ክፈፍ ጋር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كعكة سمك بشكل حلزوني"),
            keywords: &["سمك", "كعكة سمك بشكل حلزوني", "كفتة سمك ملفوفة", "مطعم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ঘ\u{9c1}ৰণীয\u{9bc}\u{9be} ডিজ\u{9be}ইনৰ সৈতে ম\u{9be}ছৰ কেক"),
            keywords: &[
                "কেক",
                "ঘ\u{9c1}ৰণীয\u{9bc}\u{9be}",
                "ঘ\u{9c1}ৰণীয\u{9bc}\u{9be} ডিজ\u{9be}ইনৰ সৈতে ম\u{9be}ছৰ কেক",
                "পেষ\u{9cd}ট\u{9cd}ৰী",
                "ম\u{9be}ছ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("spiralşəkilli balıq piroqu"),
            keywords: &[
                "balıq",
                "burulğan",
                "piroq",
                "spiralşəkilli balıq piroqu",
                "xəmir",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("рыбны пірог з завітком"),
            keywords: &[
                "выпечка",
                "завіток",
                "пірог",
                "рыба",
                "рыбны пірог з завітком",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Камабоко със спирален орнамент"),
            keywords: &[
                "Камабоко със спирален орнамент",
                "камабоко",
                "риба",
                "спирала",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ঘ\u{9c2}র\u{9cd}ণিত হওয\u{9bc}\u{9be} ফিশ কেক"),
            keywords: &[
                "কেক",
                "ঘ\u{9c2}র\u{9cd}ণিত হওয\u{9bc}\u{9be} ফিশ কেক",
                "ঘোর\u{9be}নো",
                "প\u{9cd}য\u{9be}স\u{9cd}ট\u{9cd}রি",
                "ম\u{9be}ছ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("krokedenn besked"),
            keywords: &["krokedenn", "krokedenn besked", "pesked"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("riblji rolat"),
            keywords: &["kolač", "riba", "riblji rolat", "smotuljak", "spirala"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pastís de peix amb remolí"),
            keywords: &["pastís", "pastís de peix amb remolí", "peix", "remolí"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏣᏗ ᎦᏚ ᎤᎦᎾᏍᏓ ᎤᏠᏯᏍᏗ ᎠᏗᏆᎸᏕᏲᎯ"),
            keywords: &[
                "ᎠᏗᏆᎸᏕᏲᎯ",
                "ᎠᏣᏗ",
                "ᎠᏣᏗ ᎦᏚ ᎤᎦᎾᏍᏓ ᎤᏠᏯᏍᏗ ᎠᏗᏆᎸᏕᏲᎯ",
                "ᎦᏚ",
                "ᎦᏚ ᎤᏂᎦᎾᏍᏓ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("rybí koláček se spirálkou"),
            keywords: &[
                "dort",
                "koláček",
                "ryba",
                "rybí koláček se spirálkou",
                "spirála",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cacen bysgod gyda chwyrlïad"),
            keywords: &["cacen", "cacen bysgod gyda chwyrlïad", "pysgodyn", "toes"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("fiskekage"),
            keywords: &["fiskekage", "fiskekage med spiral"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Fischfrikadelle"),
            keywords: &["Fisch", "Fischfrikadelle"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καμαμπόκο"),
            keywords: &["ζύμη", "κέικ", "καμαμπόκο", "στρόβιλος", "ψάρι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("fish cake with swirl"),
            keywords: &["cake", "fish", "fish cake with swirl", "pastry", "swirl"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pastel de pescado japonés"),
            keywords: &[
                "comida japonesa",
                "pastel",
                "pastel de pescado japonés",
                "pescado",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("pastel de pescado"),
            keywords: &[
                "comida",
                "croqueta",
                "pastel de pescado",
                "pescado",
                "restaurante",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "japonés",
                "narutomaki",
                "pastel",
                "pastel de pescado",
                "pescado",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("keerdudega kalakotlet"),
            keywords: &["keerdudega kalakotlet", "kook", "spiraal", "tort"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("arrain-pastela zurrunbiloarekin"),
            keywords: &[
                "arrain",
                "arrain-pastela zurrunbiloarekin",
                "gozogintza",
                "pastel",
                "zurrunbilo",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کیک ماهی"),
            keywords: &["شیرینی", "ماهی", "پیچ", "کیک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kalakakku"),
            keywords: &["kakku", "kala", "kalakakku", "leivonnainen"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("fish cake na may swirl"),
            keywords: &["fish cake", "fish cake na may swirl", "pagkain", "swirl"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kamaboko"),
            keywords: &["fiskur", "japansk", "kaka", "kamaboko", "matur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("croquette de poisson"),
            keywords: &["croquette de poisson", "poisson"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("surimi avec décoration"),
            keywords: &[
                "gâteau au poisson",
                "narutomaki",
                "pâté de poisson",
                "surimi",
                "surimi avec décoration",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cáca éisc le guairneán"),
            keywords: &["cáca éisc", "cáca éisc le guairneán", "iasc"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cèic-èisg le cuairteag sa mheadhain"),
            keywords: &[
                "cuairteag",
                "cèic",
                "cèic-èisg le cuairteag sa mheadhain",
                "iasg",
                "pastraidh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("pastel de peixe"),
            keywords: &["espiral", "pastel", "pastel de peixe", "peixe", "remuíño"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ફિશ ક\u{ac7}ક"),
            keywords: &[
                "ફિશ ક\u{ac7}ક",
                "ફીશ ક\u{ac7}ક",
                "માછલી",
                "ર\u{ac7}સ\u{acd}ટોરન\u{acd}ટ",
                "વમળવાળી ફીશ ક\u{ac7}ક",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kek na kifi mai juyawa"),
            keywords: &[
                "kayan kek",
                "kek",
                "kek na kifi mai juyawa",
                "kifi",
                "mai juyawa",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עוגיית אורז עם עיטור"),
            keywords: &["מאפה", "עוגייה", "עוגיית אורז עם עיטור", "עיטור", "קישוט"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चक\u{94d}करदार फ\u{93c}िश क\u{947}क"),
            keywords: &[
                "चक\u{94d}करदार फ\u{93c}िश क\u{947}क",
                "फ\u{93c}िश क\u{947}क",
                "मछली",
                "र\u{947}स\u{94d}टोर\u{947}\u{902}ट",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("riblji kolač s motivom spirale"),
            keywords: &[
                "kolač",
                "riba",
                "riblji kolač s motivom spirale",
                "spirala",
                "tijesto",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("csavart haltorta"),
            keywords: &["csavart", "haltorta", "étel"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ձկնային տորթ պտտանախշով"),
            keywords: &[
                "խմորեղեն",
                "ձկնային տորթ պտտանախշով",
                "ձուկ",
                "պտտանախշ",
                "տորթ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kue ikan dengan desain pusaran"),
            keywords: &[
                "ikan",
                "kue",
                "kue ikan dengan desain pusaran",
                "pastri",
                "pusaran",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("àchịcha azụ nwere nka okirikiri"),
            keywords: &[
                "azụ",
                "etèrè",
                "nka okirikiri",
                "àchịcha",
                "àchịcha azụ nwere nka okirikiri",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fiskkaka"),
            keywords: &["fiskkaka", "fiskur", "veitingastaður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("tortino di pesce a spirale"),
            keywords: &[
                "crocchetta di pesce",
                "pesce",
                "ristorante",
                "rotolo di pesce",
                "tortino di pesce a spirale",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("なると"),
            keywords: &["なると", "渦巻き", "練り物"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bakso iwak Jepang"),
            keywords: &["bakso", "bakso iwak Jepang", "iwak", "pastri"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("თევზის კატლეტი ხვეულათი"),
            keywords: &["თევზი", "თევზის კატლეტი ხვეულათი", "კატლეტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("иірім тәрізді балықтан жасалған котлет"),
            keywords: &[
                "балық",
                "иірім",
                "иірім тәрізді балықтан жасалған котлет",
                "кондитер өнімдері",
                "төрт",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("fiskebolle"),
            keywords: &["fiskebolle", "fiskebolle med spiral"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ន\u{17c6}រាងម\u{17bc}លស\u{17d2}តើងល\u{17d2}មមធ\u{17d2}វើព\u{17b8}ម\u{17d2}សៅសាច\u{17cb}ត\u{17d2}រ\u{17b8} ន\u{17b7}ងមានរ\u{17bc}បដ\u{17bc}ចទ\u{17b9}កក\u{17bd}ចនៅកណ\u{17d2}តាល",
            ),
            keywords: &[
                "ន\u{17c6}ម\u{17d2}សៅ",
                "ន\u{17c6}រាងម\u{17bc}លស\u{17d2}តើងល\u{17d2}មមធ\u{17d2}វើព\u{17b8}ម\u{17d2}សៅសាច\u{17cb}ត\u{17d2}រ\u{17b8} ន\u{17b7}ងមានរ\u{17bc}បដ\u{17bc}ចទ\u{17b9}កក\u{17bd}ចនៅកណ\u{17d2}តាល",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸುಳ\u{cbf}ಯ ಮೀನ\u{cbf}ನ ಕೇಕ\u{ccd}"),
            keywords: &[
                "ಮೀನ\u{cbf}ನ ಕೇಕ\u{ccd}",
                "ಸುಳ\u{cbf}ಯ ಮೀನ\u{cbf}ನ ಕೇಕ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("어묵"),
            keywords: &["꽃모양 어묵", "꽃모양 오뎅", "어묵", "오뎅"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some(
                "मदी\u{902} वर\u{94d}त\u{941}ळाची सजावट आसपी न\u{941}स\u{94d}त\u{94d}याचो क\u{947}क",
            ),
            keywords: &[
                "क\u{947}क",
                "न\u{941}स\u{94d}त\u{94d}य\u{947}\u{902}",
                "मदी\u{902} वर\u{94d}त\u{941}ळाची सजावट आसपी न\u{941}स\u{94d}त\u{94d}याचो क\u{947}क",
                "वर\u{94d}त\u{941}ळ",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("айлантып салынган балык пирогу"),
            keywords: &["айлантып салынган балык пирогу", "балык", "пирог"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("gerullte Fëschkichelchen"),
            keywords: &[
                "Fësch",
                "Kichelchen",
                "Kuch",
                "gerullt",
                "gerullte Fëschkichelchen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{eb9}ກຊ\u{eb5}\u{ec9}ນປາ"),
            keywords: &[
                "ປາ",
                "ລ\u{eb9}ກຊ\u{eb5}\u{ec9}ນ",
                "ລ\u{eb9}ກຊ\u{eb5}\u{ec9}ນປາ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žuvies pyragėlis su išpieštu sūkurio simboliu"),
            keywords: &[
                "kepiniai",
                "pyragėlis",
                "sūkurys",
                "žuvies pyragėlis su išpieštu sūkurio simboliu",
                "žuvis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zivju pīrāgs ar rotājumu"),
            keywords: &["pīrāgs", "rotājums", "zivju pīrāgs ar rotājumu", "zivs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("keke ika whai koru"),
            keywords: &["ika", "keke", "keke ika whai koru", "koru", "pōhā"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("спирално колаче со риба"),
            keywords: &[
                "колаче",
                "печиво",
                "риба",
                "спирала",
                "спирално колаче со риба",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഫിഷ\u{d4d} കേക\u{d4d}ക\u{d4d} ച\u{d41}ര\u{d41}ൾ"),
            keywords: &[
                "കേക\u{d4d}ക\u{d4d}",
                "ഫിഷ\u{d4d} കേക\u{d4d}ക\u{d4d}",
                "ഫിഷ\u{d4d} കേക\u{d4d}ക\u{d4d} ച\u{d41}ര\u{d41}ൾ",
                "ഭക\u{d4d}ഷണം",
                "മീൻ കേക\u{d4d}ക\u{d4d}",
                "ഹോട\u{d4d}ടൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("загасны бялуу"),
            keywords: &["бялуу", "загас", "загасны бялуу"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("गोलाकार माशाचा क\u{947}क"),
            keywords: &[
                "क\u{947}क",
                "गोलाकार",
                "गोलाकार माशाचा क\u{947}क",
                "प\u{947}स\u{94d}ट\u{94d}री",
                "मासा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kek ikan dengan corak pusar"),
            keywords: &[
                "ikan",
                "kek",
                "kek ikan dengan corak pusar",
                "pastri",
                "pusaran",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("pulpetta tal-ħut innokklata"),
            keywords: &[
                "għaġina",
                "innokkla",
                "pulpetta",
                "pulpetta tal-ħut innokklata",
                "ħut",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ငါးဆ\u{102f}ပ\u{103a} အလ\u{102d}ပ\u{103a}"),
            keywords: &[
                "က\u{102d}တ\u{103a}မ\u{102f}န\u{1037}\u{103a}",
                "ဂျ\u{102f}\u{1036}မ\u{102f}န\u{1037}\u{103a}",
                "ငါး",
                "ငါးဆ\u{102f}ပ\u{103a} အလ\u{102d}ပ\u{103a}",
                "အလ\u{102d}ပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("fiskekake med mønster"),
            keywords: &["fisk", "fiskekake med mønster", "restaurant"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}र\u{94d}विल सहितको फिस क\u{947}स"),
            keywords: &[
                "क\u{947}क",
                "प\u{947}स\u{94d}ट\u{94d}री",
                "माछा",
                "स\u{94d}र\u{94d}विल",
                "स\u{94d}र\u{94d}विल सहितको फिस क\u{947}स",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("viskoekje met krul"),
            keywords: &["koekje", "krul", "vis", "viskoekje", "viskoekje met krul"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("fiskekake med mønster"),
            keywords: &["fisk", "fiskekake med mønster", "restaurant"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଭଉ\u{b01}ରୀ ଥ\u{b3f}ବ\u{b3e} ମ\u{b3e}ଛ ପ\u{b3f}ଠ\u{b3e}"),
            keywords: &[
                "ଭଉ\u{b01}ରୀ ଥ\u{b3f}ବ\u{b3e} ମ\u{b3e}ଛ ପ\u{b3f}ଠ\u{b3e}",
                "ମ\u{b3e}ଛ",
                "ମ\u{b3e}ଛ କେକ\u{b4d}",
                "ରେଷ\u{b4d}ଟ\u{b41}ର\u{b3e}ଣ\u{b4d}ଟ\u{b4d}",
                "ସ\u{b4d}ଵ\u{b3f}ର\u{b4d}ଲ\u{b4d} ସହ\u{b3f}ତ ମ\u{b3e}ଛ କେକ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਘ\u{a41}ਮਾਵਦਾਰ ਮ\u{a71}ਛੀ ਕ\u{a47}ਕ"),
            keywords: &[
                "ਗ\u{a4b}ਲ ਮ\u{a71}ਛੀ ਕ\u{a47}ਕ",
                "ਘ\u{a41}ਮਾਵਦਾਰ ਮ\u{a71}ਛੀ ਕ\u{a47}ਕ",
                "ਪ\u{a47}ਸਟਰੀ",
                "ਮ\u{a71}ਛੀ",
                "ਮ\u{a71}ਛੀ ਕ\u{a47}ਕ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بھنور نال مچھی دا کیک"),
            keywords: &["بھنور نال مچھی دا کیک", "مچھی", "پیسٹری", "چکرانا", "کیک"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Físh Kek Wit Sẹ\u{301}kul"),
            keywords: &[
                "Fish",
                "Físh Kek Wit Sẹ\u{301}kul",
                "Kek",
                "Pástri",
                "Sẹ\u{301}kul",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("ciastko rybne"),
            keywords: &["ciastko", "ryba", "rybne", "spirala"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مچھلی کیک"),
            keywords: &["مچھلی کیک"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bolinho de peixe"),
            keywords: &["bolinho de peixe", "croquete de peixe", "peixe"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("pastel de peixe com espiral"),
            keywords: &["espiral", "pastel", "pastel de peixe com espiral", "peixe"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("challwa pastel muyuqwan"),
            keywords: &[
                "callwa",
                "challwa pastel muyuqwan",
                "masa",
                "pastel",
                "phuyunku",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ruladă japoneză cu pește"),
            keywords: &["paste", "pește", "ruladă", "ruladă japoneză cu pește"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-298"),
            keywords: &["E10-298"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("камабоко"),
            keywords: &["камабоко", "начинка", "рыба", "сурими"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("gato iri mu ishusho y’ifi izengurutse"),
            keywords: &[
                "gato iri mu ishusho y’ifi izengurutse",
                "ifi",
                "keke",
                "kwizunguza",
                "patiseri",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("گول مڇي ڪيڪ"),
            keywords: &["ڪيڪ، مڇي، پيسٽري، گول", "گول مڇي ڪيڪ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කරකැවෙ\u{dd4}ණ\u{dd4} ම\u{dcf}ළ\u{dd4} කේක\u{dca}"),
            keywords: &[
                "කරකැවෙ\u{dd4}ණ\u{dd4} ම\u{dcf}ළ\u{dd4} කේක\u{dca}",
                "කේක\u{dca}",
                "පේස\u{dca}ට\u{dca}\u{200d}ර\u{dd2}",
                "ම\u{dcf}ළ\u{dd4}",
                "ස\u{dd4}ළ\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("rybia fašírka"),
            keywords: &["fašírka", "ryba", "rybia fašírka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ribji kolač s spiralo"),
            keywords: &[
                "kolač",
                "pecivo",
                "riba",
                "ribji kolač s spiralo",
                "spirala",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kalluun keeg oo duuban"),
            keywords: &["kalluun", "kalluun keeg oo duuban", "keeg"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kroketë me peshk me spirale"),
            keywords: &[
                "brumë",
                "kroketë",
                "kroketë me peshk me spirale",
                "peshk",
                "spirale",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("рибља пљескавица са спиралом"),
            keywords: &[
                "кoлaч",
                "рибa",
                "рибља пљескавица са спиралом",
                "спирaлa",
                "тeстo",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["рибља пљескавица са спиралом"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("riblja pljeskavica sa spiralom"),
            keywords: &[
                "kolač",
                "riba",
                "riblja pljeskavica sa spiralom",
                "spirala",
                "testo",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["riblja pljeskavica sa spiralom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("fiskkaka"),
            keywords: &["fisk", "fiskkaka", "snurrad fiskkaka"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("keki ya samaki iliyozingwa"),
            keywords: &[
                "keki",
                "keki ya samaki iliyozingwa",
                "samaki",
                "vitobosha",
                "zinga",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சுருள\u{bcd} வடிவ ஃபிஷ\u{bcd} கேக\u{bcd}"),
            keywords: &[
                "ஃபிஷ\u{bcd} கேக\u{bcd}",
                "உணவகம\u{bcd}",
                "கடல\u{bcd} உணவு",
                "சுருள\u{bcd} வடிவ ஃபிஷ\u{bcd} கேக\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "సుడ\u{c3f} త\u{c3f}ర\u{c3f}గ\u{c3f}నట\u{c4d}లుండ\u{c47} చ\u{c47}ప క\u{c47}క\u{c4d}",
            ),
            keywords: &[
                "చ\u{c47}పలత\u{c4b} చ\u{c47}స\u{c3f}న క\u{c47}కు",
                "చ\u{c47}పలు",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
                "సుడ\u{c3f} త\u{c3f}ర\u{c3f}గ\u{c3f}నట\u{c4d}లుండ\u{c47} చ\u{c47}ప క\u{c47}క\u{c4d}",
                "సుడులు త\u{c3f}ర\u{c3f}గ\u{c3f}నట\u{c4d}లుండ\u{c47} చ\u{c47}పల క\u{c47}కు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("торт аз моҳӣ бо гирдоб"),
            keywords: &[
                "гирдоб",
                "маҳсулоти қаннодӣ",
                "моҳӣ",
                "торт",
                "торт аз моҳӣ бо гирдоб",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e39}กช\u{e34}\u{e49}นปลา"),
            keywords: &[
                "ปลา",
                "ล\u{e39}กช\u{e34}\u{e49}น",
                "ล\u{e39}กช\u{e34}\u{e49}นปลา",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("tüweleýli balyk tort"),
            keywords: &[
                "balyk",
                "girdap",
                "süýjülik",
                "tort",
                "tüweleýli balyk tort",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("keke ika"),
            keywords: &["keke ika"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("balık köftesi"),
            keywords: &["balık", "balık köftesi", "restoran", "rulo balık köftesi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يۆگىمەچ بېلىق پىشۇرۇقى"),
            keywords: &["ئۇن", "بېلىق", "تورت", "يۆگىمەچ", "يۆگىمەچ بېلىق پىشۇرۇقى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("рибний рулет зі спіральним візерунком"),
            keywords: &[
                "випічка",
                "рибний",
                "рибний рулет зі спіральним візерунком",
                "рулет",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بگولا بنا مچھلی کا کیک"),
            keywords: &["بگولا بنا مچھلی کا کیک", "مچھلی", "پیسٹری", "کیک"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("girdob ko‘rinishidagi baliqli tort"),
            keywords: &[
                "baliq",
                "girdob",
                "girdob ko‘rinishidagi baliqli tort",
                "qandolat",
                "tort",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bánh cá có hình xoắn"),
            keywords: &["bánh", "bánh cá có hình xoắn", "bánh ngọt", "cá", "xoáy"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("buteeli jën"),
            keywords: &["buteeli jën", "jën", "ngato", "wëndeelu"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-fish cake enokujikeleza"),
            keywords: &[
                "i-cake",
                "i-fish cake enokujikeleza",
                "intlama",
                "intlanzi",
                "jikelezisa",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Eja dindin Pẹlu Swirl"),
            keywords: &[
                "Eja dindin Pẹlu Swirl",
                "swirl",
                "àkàrà òyìnbó",
                "ónjẹ oní fíláwà",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("鳴門卷"),
            keywords: &["漩渦", "糕點", "餅", "魚", "鳴門卷"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("鸣门卷"),
            keywords: &["漩涡", "糕点", "饼", "鱼", "鸣门卷"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("鱼板"),
            keywords: &["鱼板"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("魚板"),
            keywords: &["魚板"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("鳴門卷"),
            keywords: &["日式魚蛋", "魚板", "魚糕", "魚餅", "鳴門卷"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ikhekhe lenhlanzi elinokuzungezayo"),
            keywords: &[
                "ikhekhe",
                "ikhekhe lenhlanzi elinokuzungezayo",
                "inhlanzi",
                "okuzungezayo",
            ],
        },
    ],
};
#[doc = "🥮"]
pub const MOON_CAKE: crate::Emoji = crate::Emoji {
    glyph: "🥮",
    codepoint: "1F96E",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "moon cake",
    group: "Food & Drink",
    subgroup: "food-asian",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("maankoek"),
            keywords: &["fees", "herfs", "maankoek"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የጨረቃ ኬክ"),
            keywords: &["መከር", "በዓል", "የጨረቃ ኬክ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كعكة القمر"),
            keywords: &[
                "حلويات",
                "خريف",
                "صين",
                "كعكة القمر",
                "كيكة",
                "مهرجان منتصف الخريف",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চন\u{9cd}দ\u{9cd}ৰ\u{9be}ক\u{9c3}তিৰ কেক"),
            keywords: &[
                "ইউৱেবিং",
                "উৎসৱ",
                "চন\u{9cd}দ\u{9cd}ৰ\u{9be}ক\u{9c3}তিৰ কেক",
                "শৰৎ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ay piroqu"),
            keywords: &["ay piroqu", "festival", "payız", "yuebin"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("месяцовы пернік"),
            keywords: &["восень", "месяцовы пернік", "фестываль", "юэбін"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("лунен кейк"),
            keywords: &["Фестивал на есента", "китайски сладкиш", "лунен кейк"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9c1}ন কেক"),
            keywords: &["উৎসব", "ম\u{9c1}ন কেক", "য\u{9c1}য\u{9bc}েবিং", "শরৎ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("gwastell-loar"),
            keywords: &["diskaramzer", "gouel", "gwastell-loar"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("mjesečev kolač"),
            keywords: &["festival", "jesen", "mjesečev kolač", "yuebing"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pastisset de lluna"),
            keywords: &["festival", "pastisset de lluna", "tardor", "yuèbǐng"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏓ ᎦᏚ ᎤᎦᎾᏍᏓ"),
            keywords: &[
                "ᎤᎳᎪᎲᏍᎩ",
                "ᎤᏓ ᎦᏚ ᎤᎦᎾᏍᏓ",
                "ᎤᏬᏗ ᎤᏂᏍᏆᎸᎮᎲᎢ",
                "ᏓᎶᏂᎨᏍᏛ ᏂᏓᏳᎶᏒ ᎤᏓ ᎦᏚ ᎤᎦᎾᏍᏓ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("měsíční koláč"),
            keywords: &["měsíční koláč", "podzim", "svátek", "čínský"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cacen lleuad"),
            keywords: &["cacen lleuad", "gŵyl", "hydref", "yuèbǐng"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("månekage"),
            keywords: &["efterår", "festival", "månekage", "yuèbǐng"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Mondkuchen"),
            keywords: &["Festival", "Herbst", "Mondkuchen", "Yuebing"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κέικ φεγγάρι"),
            keywords: &["κέικ φεγγάρι", "φεστιβάλ", "φθινόπωρο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("moon cake"),
            keywords: &["autumn", "festival", "moon cake", "yuèbǐng"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pastel de luna"),
            keywords: &["festival", "luna", "otoño", "pastel de luna", "yuebing"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("pastel de luna"),
            keywords: &["festival", "otoño", "pastel de luna", "yuebing"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("pastel de luna"),
            keywords: &["pastel de luna"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kuukook"),
            keywords: &["festival", "kuukook", "sügis", "yuèbǐng"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ilargi-pastel"),
            keywords: &[
                "ilargi-pastel",
                "ilargi-pastela",
                "jaialdia",
                "udazkena",
                "yuèbǐng",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کیک ماه"),
            keywords: &["جشنواره", "پاییز", "کیک ماه", "یوئه\u{200c}بینگ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kuukakku"),
            keywords: &["juhla", "kuukakku", "syksy", "yuèbĭng"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("moon cake"),
            keywords: &["fall", "festival", "moon cake", "pagkain", "taglagas"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("mánakaka"),
            keywords: &["heyst", "hátíð", "mánakaka", "yuèbǐng"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("gâteau de lune"),
            keywords: &["automne", "festival", "gâteau de lune", "yuèbǐng"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cáca gealaí"),
            keywords: &["cáca gealaí", "féile", "fómhar", "yuèbǐng"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cèic-ghealaich"),
            keywords: &["cèic-ghealaich", "foghar", "fèis", "yuèbǐng"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("pastel de lúa"),
            keywords: &["doce chinés", "festival", "lúa", "outono", "pastel de lúa"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મ\u{ac2}ન ક\u{ac7}ક"),
            keywords: &[
                "તહ\u{ac7}વાર",
                "મ\u{ac2}ન ક\u{ac7}ક",
                "ય\u{ac1}એબિ\u{a82}ગ",
                "શરદઋત\u{ac1}",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עוגת ירח סינית"),
            keywords: &["חג סיני", "סין", "עוגת ירח סינית", "פסטיבל אמצע הסתיו"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("म\u{942}न क\u{947}क"),
            keywords: &[
                "त\u{94d}यौहार",
                "पतझड\u{93c}",
                "म\u{942}न क\u{947}क",
                "म\u{942}नक\u{947}क",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("mjesečev kolač"),
            keywords: &["festival", "jesen", "mjesečev kolač", "slastica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("holdsütemény"),
            keywords: &["fesztivál", "holdsütemény", "yuèbǐng", "ősz"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("չինական թխվածք"),
            keywords: &["աշուն", "չինական թխվածք", "փառատոն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kue bulan"),
            keywords: &["festival", "kue bulan", "musim gugur", "yuèbǐng"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("tunglkaka"),
            keywords: &["haust", "hátíð", "tunglkaka"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("torta della luna"),
            keywords: &[
                "autunno",
                "festival",
                "moon cake",
                "torta della luna",
                "yuèbǐng",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("月餅"),
            keywords: &["お祝い", "中秋節", "中華菓子", "月餅", "秋"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kuwih bulan"),
            keywords: &["festival", "kuwih bulan", "musim gogrok", "yuebing"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მთვარის ორცხობილა"),
            keywords: &["იუებინი", "მთვარის ორცხობილა", "ფესტივალი", "შემოდგომა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қытай пирогы"),
            keywords: &["иебинг", "күз", "фестиваль", "қытай пирогы"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ន\u{17c6}លោកខែ"),
            keywords: &[
                "ន\u{17c6}លោកខែ",
                "ព\u{17b7}ធ\u{17b8}ប\u{17bb}ណ\u{17d2}យ",
                "យេព\u{17b8}ង",
                "សរទរដ\u{17bc}វ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಚಂದ\u{ccd}ರಾಕಾರದ ಕೇಕ\u{ccd}"),
            keywords: &[
                "ಚಂದ\u{ccd}ರಾಕಾರದ ಕೇಕ\u{ccd}",
                "ಯ\u{cbf}ಬ\u{cbf}ಂಗ\u{ccd}",
                "ಶರತ\u{ccd}ಕಾಲ",
                "ಹಬ\u{ccd}ಬ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("월병"),
            keywords: &["가을", "명절", "월병"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("च\u{902}द\u{94d}राकार क\u{947}क"),
            keywords: &[
                "उत\u{94d}सव",
                "च\u{902}द\u{94d}रकार क\u{947}क",
                "च\u{902}द\u{94d}राकार क\u{947}क",
                "य\u{941}बि\u{902}ग",
                "शारदीय",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кытай пирожныйы"),
            keywords: &["кытай пирожныйы", "күз", "майрам", "юбиң"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຂະໜ\u{ebb}ມໄຫວພະຈ\u{eb1}ນ"),
            keywords: &[
                "ຂະໜ\u{ebb}ມໄຫວພະຈ\u{eb1}ນ",
                "ຂະໝ\u{ebb}ມຢຽວເບ\u{eb5}ຍ",
                "ລະດ\u{eb9}ໃບໄມ\u{ec9}ລ\u{ebb}\u{ec8}ນ",
                "ເທດສະການ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mėnulio pyragas"),
            keywords: &["festivalis", "mėnulio pyragas", "ruduo"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("Mēness kūka"),
            keywords: &["Mēness kūka", "festivāls", "rudens"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("месечев колач"),
            keywords: &["есен", "месечев колач", "месечево колаче", "фестивал"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മ\u{d42}ൺ കേക\u{d4d}ക\u{d4d}"),
            keywords: &["മ\u{d42}ൺ കേക\u{d4d}ക\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("саран боов"),
            keywords: &["баяр", "намар", "саран боов"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("म\u{942}न क\u{947}क"),
            keywords: &[
                "म\u{942}न क\u{947}क",
                "य\u{942}बि\u{902}ग",
                "शरद ऋत\u{942}",
                "सण",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kuih bulan"),
            keywords: &["festival", "kuih bulan", "musim luruh", "yuebing"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လမ\u{102f}န\u{1037}\u{103a}"),
            keywords: &[
                "ဆောင\u{103a}းဦးရာသ\u{102e}",
                "တရ\u{102f}တ\u{103a} လမ\u{102f}န\u{1037}\u{103a}",
                "ပ\u{103d}\u{1032}တော\u{103a}",
                "လမ\u{102f}န\u{1037}\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("månekake"),
            keywords: &["festival", "høst", "månekake", "yuebing"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("म\u{941}न क\u{947}क"),
            keywords: &["चा\u{901}ड", "म\u{941}न क\u{947}क", "य\u{941}एबिङ", "शरद"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("maancake"),
            keywords: &["festival", "herfst", "maancake", "yuèbǐng"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("månekake"),
            keywords: &["festival", "haust", "månekake", "yuebing"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମ\u{b41}ନ\u{b4d}\u{200d} କେକ\u{b4d}\u{200c}"),
            keywords: &[
                "ଉତ\u{b4d}ସବ",
                "ଗୀଷମ",
                "ମ\u{b41}ନ\u{b4d}\u{200d} କେକ\u{b4d}\u{200c}",
                "ୟ\u{b41}ବ\u{b3f}ଙ\u{b4d}ଗ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a42}ਨ ਕ\u{a47}ਕ"),
            keywords: &[
                "ਤਿਉਹਾਰ",
                "ਪਤਝੜ",
                "ਮ\u{a42}ਨ ਕ\u{a47}ਕ",
                "ਮ\u{a42}ਨਕ\u{a47}ਕ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mún Kek"),
            keywords: &[
                "Chainíz Kek Wé Dẹm De Kọ\u{301}l Yuibing",
                "Mún Kek",
                "Ọ\u{301}tọm: Sízin Wé Dé Bítwín Họ\u{301}t Sízin An Kóld Sízin",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("ciasteczko księżycowe"),
            keywords: &["ciasteczko księżycowe", "jesień", "yuèbǐng", "święto"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سپوږمۍ کيک"),
            keywords: &["سپوږمۍ کيک", "فستيوال", "منی", "يوبنګ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bolo lunar"),
            keywords: &["bolo lunar", "festival", "outono", "yuèbǐng"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("bolo da lua"),
            keywords: &["bolo da lua", "festival", "outono", "yuèbǐng"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("killa pastel"),
            keywords: &["killa pastel", "otoño", "raymi", "yuèbǐng"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("prăjitura lunii"),
            keywords: &[
                "festival",
                "prăjitura lunii",
                "prăjitură chinezească",
                "toamnă",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-010"),
            keywords: &["E11-010"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("лунный пирог"),
            keywords: &[
                "лунный пирог",
                "лунный пряник",
                "осень",
                "фестиваль",
                "юэбин",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مون ڪيڪ"),
            keywords: &["yuèbǐng", "تهوار", "سر\u{650}ء\u{64e}", "مون ڪيڪ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ම\u{dd4}න\u{dca} කේක\u{dca}"),
            keywords: &[
                "උත\u{dca}සවය",
                "ම\u{dd4}න\u{dca} කේක\u{dca}",
                "සරත\u{dca} ඍත\u{dd4}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("mesačný koláč"),
            keywords: &["jeseň", "jüe-ping", "mesačný koláč", "slávnosť"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("lunina torta"),
            keywords: &["festival", "jesen", "lunina torta", "yuebing"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kalluunka dayaxa"),
            keywords: &["dayrta", "diggaaga qoyan", "kalluunka dayaxa", "xaflad"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kek-hënë"),
            keywords: &["festival", "kek festiv", "kek-hënë", "vjeshtë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("месечев колач"),
            keywords: &["месечев колач", "фестивал", "јесен"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("мјесечев колач"),
            keywords: &["мјесечев колач"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("mesečev kolač"),
            keywords: &["festival", "jesen", "mesečev kolač"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("mjesečev kolač"),
            keywords: &["mjesečev kolač"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("månkaka"),
            keywords: &["festival", "höst", "månfest", "månkaka"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mkate wa sinia"),
            keywords: &["keki", "mapukutiko", "mkate wa sinia", "sherehe", "yuebing"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மூன\u{bcd} கேக\u{bcd}"),
            keywords: &[
                "இலையுதிர\u{bcd}க\u{bbe}லம\u{bcd}",
                "கேக\u{bcd}",
                "திருவிழ\u{bbe}",
                "மூன\u{bcd} கேக\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మూన\u{c4d} క\u{c47}క\u{c4d}"),
            keywords: &[
                "పండుగ",
                "మూన\u{c4d} క\u{c47}క\u{c4d}",
                "యూబ\u{c3f}ంగ\u{c4d}",
                "శరదృతువు",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ขนมไหว\u{e49}พระจ\u{e31}นทร\u{e4c}"),
            keywords: &[
                "ขนมไหว\u{e49}พระจ\u{e31}นทร\u{e4c}",
                "ฤด\u{e39}ใบไม\u{e49}ร\u{e48}วง",
                "ว\u{e31}นไหว\u{e49}พระจ\u{e31}นทร\u{e4c}",
                "เทศกาล",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("aý tort"),
            keywords: &["aý tort", "festiwal", "güýz", "ýuebiň"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("keke māhina"),
            keywords: &["keke māhina"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ay pastası"),
            keywords: &["ay pastası", "festival", "sonbahar", "yuèbǐng"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("мункейк"),
            keywords: &[
                "Азія",
                "мункейк",
                "місячний пиріг",
                "осінь",
                "пиріжок",
                "фестиваль",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چاند نما کیک"),
            keywords: &["تہوار", "خزاں", "چاند نما کیک"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("oyli pirog"),
            keywords: &[
                "bayram",
                "festival",
                "kuz",
                "oyli pirog",
                "oyli pishiriq",
                "yuebin",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bánh trung thu"),
            keywords: &["bánh trung thu", "lễ hội", "mùa thu"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("月餅"),
            keywords: &["月餅", "秋天", "節日"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("月饼"),
            keywords: &["月饼", "秋天", "节日"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("月饼"),
            keywords: &["月饼", "秋天", "节日"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("月餅"),
            keywords: &["中秋", "月餅"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("moon cake"),
            keywords: &["autumn", "festival", "moon cake", "yuèbǐng"],
        },
    ],
};
#[doc = "🍡"]
pub const DANGO: crate::Emoji = crate::Emoji {
    glyph: "🍡",
    codepoint: "1F361",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "dango",
    group: "Food & Drink",
    subgroup: "food-asian",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("dango"),
            keywords: &["dango", "japannees", "kos", "nagereg", "soet", "stokkie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ዳንጎ"),
            keywords: &["ስቲክ", "ስኬወር", "የጃፓን", "ዳንጎ", "ጣፋጭ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}حلوى الدانغو"),
            keywords: &["حلوى", "\u{202b}حلوى الدانغو"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ডেঙ\u{9cd}গো"),
            keywords: &[
                "জ\u{9be}প\u{9be}নিজ",
                "ডেঙ\u{9cd}গো",
                "মিঠ\u{9be}",
                "ষ\u{9cd}টিক",
                "স\u{9cd}কিৱ\u{9be}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("danqo"),
            keywords: &["danqo", "desert", "yapon", "çubuq", "şirin", "şiş"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("данга"),
            keywords: &["данга", "дэсерт", "палачка", "салодкі", "японскі"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("данго"),
            keywords: &["данго", "десерт", "японски"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ড\u{9be}ঙ\u{9cd}গো"),
            keywords: &[
                "ক\u{9be}ঠি",
                "জ\u{9be}প\u{9be}নি",
                "ড\u{9be}ঙ\u{9cd}গো",
                "ডেজ\u{9be}র\u{9cd}ট",
                "মিষ\u{9cd}টি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("beriad madigoù"),
            keywords: &["beriad", "madigoù"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("dango"),
            keywords: &["dango", "desert", "japanski", "slatko", "štapić"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("broqueta dolça japonesa"),
            keywords: &[
                "broqueta",
                "broqueta dolça japonesa",
                "dango",
                "dolç",
                "japonès",
                "postres",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏕᏂᎪ"),
            keywords: &["ᎤᎦᎾᏍᏓ", "ᎤᎦᎾᏍᏓ ᎠᎩᏍᏗ", "ᎦᏅᏍᏓ", "ᏕᏂᎪ", "ᏣᏱᏂᏏ", "ᏴᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("dango"),
            keywords: &[
                "dango",
                "dezert",
                "japonský",
                "knedlíček",
                "sladkost",
                "sladký",
                "tyčka",
                "zákusek",
                "špejle",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dango"),
            keywords: &["Japaneaidd", "dango", "melys", "pwdin", "sgiwer"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("dango"),
            keywords: &["dango", "iskugler"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Dango"),
            keywords: &[
                "Dango",
                "Mochi-Kugeln auf einem Spieß",
                "Restaurant",
                "japanisches Gericht",
            ],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: None,
            keywords: &["Dango"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ντάνγκο"),
            keywords: &[
                "γλυκό",
                "επιδόρπιο",
                "ιαπωνικό",
                "καλαμάκι",
                "ντάνγκο",
                "σουβλάκι",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("dango"),
            keywords: &["Japanese", "dango", "dessert", "skewer", "stick", "sweet"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("dango"),
            keywords: &["dango", "japonés", "pincho", "postre", "restaurante"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("brocheta dulce japonesa"),
            keywords: &[
                "brocheta",
                "comida",
                "dango",
                "dulce",
                "japonesa",
                "restaurante",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["brocheta", "comida", "dango", "dulce", "japonesa"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["brocheta", "comida", "dango", "dulce", "japonesa"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("dango"),
            keywords: &["dango", "magus", "magustoit", "pulk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("dango"),
            keywords: &["dango", "gozo", "japonia", "makila", "postre"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دانگو"),
            keywords: &["دانگو", "دسر", "سیخ", "شیرین", "چوب", "ژاپنی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("dango"),
            keywords: &["dango", "japanilainen", "jälkiruoka", "makea", "tikku"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("dango"),
            keywords: &[
                "dango",
                "dessert",
                "matamis",
                "nakatuhog",
                "pagkain",
                "panghimagas",
                "tuhog",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("dango"),
            keywords: &["dango", "dessert", "japansk", "matur", "pinnur", "søtt"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("brochette de bonbons"),
            keywords: &["bonbons", "brochette de bonbons"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("dango"),
            keywords: &["Brochette", "dango", "dessert", "japonais", "sucré"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("dango"),
            keywords: &[
                "dango",
                "liathróidí mocci",
                "liathróidí mocci ar chipín",
                "mochi",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("dango"),
            keywords: &["bior", "dango", "iapanach", "milis", "milseag", "seapanach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("dango"),
            keywords: &["dango", "doce", "espetada", "sobremesa", "xaponesa"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ડ\u{ac7}ન\u{acd}ગો"),
            keywords: &[
                "ડ\u{ac7}ન\u{acd}ગો",
                "મોચી",
                "મોચી બોલ\u{acd}સ",
                "ર\u{ac7}સ\u{acd}ટોરન\u{acd}ટ",
                "લાકડી પર મોચી બોલ\u{acd}સ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("dango"),
            keywords: &["Na japan", "dango", "kayan zaƙi", "sanda", "tsinke", "zaƙi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שיפוד כופתאות"),
            keywords: &["יפני", "מתוק", "קינוח", "שיפוד", "שיפוד כופתאות"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ड\u{948}\u{902}गो"),
            keywords: &[
                "ड\u{948}\u{902}गो",
                "मोची",
                "मोची बॉल",
                "मोची बॉल स\u{94d}टिक",
                "र\u{947}स\u{94d}टोर\u{947}\u{902}ट",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("dango"),
            keywords: &["dango", "desert", "japan", "ražnjić", "slatko", "štapić"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("dango"),
            keywords: &["dango", "desszert", "pálca", "édesség", "étel"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("դանգո"),
            keywords: &[
                "աղանդեր",
                "դանգո",
                "ճապոնական",
                "շամփուր",
                "փայտիկ",
                "քաղցր",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("dango"),
            keywords: &[
                "dango", "jepang", "makanan", "manis", "penutup", "sate", "stik",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nri dango"),
            keywords: &[
                "anụ amịrị amị",
                "ndị Japan",
                "nri dango",
                "osisi anụ",
                "àchịcha ụtọ",
                "ụtọ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("soðkökur á teini"),
            keywords: &[
                "dango",
                "mochi",
                "soðkökur",
                "soðkökur á teini",
                "veitingastaður",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("dango"),
            keywords: &[
                "dango",
                "dolcetto",
                "palline di mochi",
                "ristorante",
                "spiedino di mochi",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("だんご"),
            keywords: &["お団子", "だんご", "和菓子"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sate dango"),
            keywords: &[
                "Jepang",
                "dango",
                "legi",
                "panganan manis",
                "sate",
                "sunduk",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დანგო"),
            keywords: &[
                "დანგო",
                "დესერტი",
                "იაპონური",
                "ტკბილეული",
                "ტკბილი",
                "შამფური",
                "ჯოხი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("данго"),
            keywords: &["данго", "десерт", "жапон", "таяқша", "тәтті", "іспара"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("iskugler på pind"),
            keywords: &["iskugler", "iskugler på pind"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}ករតា\u{17c6}ងម\u{17c9}ែ"),
            keywords: &["ស\u{17d2}ករ", "ស\u{17d2}ករតា\u{17c6}ងម\u{17c9}ែ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಡ\u{ccd}ಯಾಂಗೊ"),
            keywords: &[
                "ಕಟ\u{ccd}ಟ\u{cbf}ಗ\u{cc6}ಯ ಮೋಚ\u{cbf}",
                "ಡ\u{ccd}ಯಾಂಗೊ",
                "ಮೋಚ\u{cbf}",
                "ಮೋಚ\u{ccd} ಬಾಲ\u{ccd}ಸ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("떡꼬치"),
            keywords: &["꼬치", "당고", "디저트", "떡", "떡꼬치"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("डा\u{902}गो"),
            keywords: &[
                "गोड",
                "जपानी",
                "डा\u{902}गो",
                "ड\u{947}झर\u{94d}ट",
                "स\u{94d}किव\u{947}र",
                "स\u{94d}टिक",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("данго"),
            keywords: &["данго", "десерт", "жапончо", "таттуу", "чыбык", "шампур"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Dango"),
            keywords: &["Brochett", "Dango", "Dessert", "japanesch", "séiss"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ດ\u{eb1}ງໂງະ"),
            keywords: &[
                "ຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນ",
                "ດ\u{eb1}ງໂງະ",
                "ດ\u{eb1}ງໂງາະສຽບໄມ\u{ec9}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("dango"),
            keywords: &["dango", "desertas", "iešmas", "japonų", "lazdelė", "saldu"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("dango"),
            keywords: &["dango", "deserts", "irbulīši", "japāņu", "salds"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tāngoro"),
            keywords: &["Hapanīhi", "puruni", "reka", "rākau", "tāngoro", "wero"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("јапонски слатки кнедли"),
            keywords: &[
                "десерт",
                "ражен",
                "слатко",
                "јапонски слатки кнедли",
                "јапонско",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഡ\u{d3e}ംഗോ"),
            keywords: &[
                "ആഹ\u{d3e}രം",
                "ഡ\u{d3e}ംഗോ",
                "ഫ\u{d3e}സ\u{d4d}റ\u{d4d}റ\u{d4d} ഫ\u{d41}ഡ\u{d4d}",
                "ഭക\u{d4d}ഷണം",
                "മൊച\u{d4d}ചി",
                "ഹോട\u{d4d}ടൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("данго"),
            keywords: &["Японы", "амттан", "данга", "данго"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ड\u{901}गो"),
            keywords: &[
                "गोड",
                "जपानी",
                "ड\u{901}गो",
                "मिठाई",
                "स\u{94d}क\u{94d}य\u{942}अर",
                "स\u{94d}टिक",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("dango"),
            keywords: &["dango", "jepun", "kayu", "manis", "pencuci mulut", "sate"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("dango"),
            keywords: &["dango", "deżerta", "skewer", "stikka", "Ġappuniż", "ħelwa"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဒန\u{103a}ဂ\u{102d}\u{102f}"),
            keywords: &[
                "ဂျပန\u{103a}",
                "ဒန\u{103a}ဂ\u{102d}\u{102f}",
                "သ\u{102e}တ\u{1036}",
                "အချ\u{102d}\u{102f}ပ\u{103d}\u{1032}",
                "အချောင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("dango"),
            keywords: &["dango", "japansk", "restaurant", "riskonfekt"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ड\u{94d}याङ\u{94d}गो"),
            keywords: &[
                "जापानिज",
                "ड\u{94d}याङ\u{94d}गो",
                "मिठाई",
                "मिठो",
                "स\u{94d}क\u{947}व\u{947}यर",
                "स\u{94d}टिक",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("dango"),
            keywords: &["dango", "dessert", "japans", "spies", "stokje", "zoet"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("dango"),
            keywords: &["dango", "japansk", "restaurant", "riskonfekt"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଡ\u{b3e}ଙ\u{b4d}ଗୋ"),
            keywords: &[
                "ଖ\u{b3e}ଦ\u{b4d}ୟ ପରେ ମ\u{b3f}ଠ\u{b3e}",
                "ଜ\u{b3e}ପ\u{b3e}ନୀ",
                "ଡ\u{b3e}ଙ\u{b4d}ଗୋ",
                "ମ\u{b3f}ଠ\u{b3e}",
                "ଷ\u{b4d}ଟ\u{b3f}କ\u{b4d}\u{200c}",
                "ସ\u{b4d}କ\u{b3f}ୱର\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਡਾ\u{a02}ਗ\u{a4b}"),
            keywords: &[
                "ਜਾਪਾਨੀ",
                "ਡਾ\u{a02}ਗ\u{a4b}",
                "ਡ\u{a70}ਡੀ",
                "ਮਠਿਆਈ",
                "ਮਿ\u{a71}ਠਾ",
                "ਸਕ\u{a42}ਅਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ڈینگو"),
            keywords: &[
                "جاپانی",
                "لوہے دی سیخ",
                "میٹھائی",
                "میٹھی شے",
                "چھڑی",
                "ڈینگو",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Dángó"),
            keywords: &[
                "Dángó",
                "Dẹzat",
                "Japan",
                "Japán Fud Wé Dẹm De Kọ\u{301}l Dángọ",
                "Stik",
                "Swit",
                "Swít Fud Wé Dẹm De Chọ\u{301}p Áftá Di Mén Fud",
                "Súyá Stik",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("dango"),
            keywords: &["dango", "kulki mochi"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ډانګو"),
            keywords: &["ډانګو"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("dango"),
            keywords: &[
                "bolinho japonês",
                "dango",
                "japonês",
                "mochi",
                "mochiko",
                "sobremesa",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("dango"),
            keywords: &[
                "dango",
                "doce",
                "espetada",
                "espeto",
                "japonesa",
                "sobremesa",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("dango"),
            keywords: &["Japones", "brocheta", "dango", "k’aspi", "miski", "postre"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("găluște japoneze pe băț"),
            keywords: &[
                "Japonia",
                "băț",
                "desert",
                "dulce",
                "găluște japoneze pe băț",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-294"),
            keywords: &["E10-294"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("данго"),
            keywords: &[
                "данго",
                "десерт",
                "на палочке",
                "сладости",
                "сладость",
                "японский",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("dango"),
            keywords: &[
                "dango",
                "deseri",
                "inkoni",
                "iryoshye",
                "umushito",
                "yo mu buyapani",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڊانگو"),
            keywords: &["مٺو، جاپاني، شيخ، ڪاٺي، مٺائي", "ڊانگو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඩැන\u{dca}ගෝ"),
            keywords: &[
                "අත\u{dd4}ර\u{dd4}පස",
                "කෝට\u{dd4}ව",
                "ජප\u{dcf}න",
                "ඩැන\u{dca}ගෝ",
                "පැණ\u{dd2} රස",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("dango"),
            keywords: &["dango", "dezert", "palička", "sladkosť", "špajľa"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("dango"),
            keywords: &[
                "dango",
                "japonsko",
                "paličica",
                "posladek",
                "sladko",
                "špila",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("daango"),
            keywords: &["daango", "jabbaanka", "macaanl", "macmacaan", "ul"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("dango"),
            keywords: &["dango", "japoneze", "shkop", "ëmbëlsirë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("данго"),
            keywords: &["jaпaн", "дeсeрт", "данго", "рaжњић", "слaткo", "штaпић"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("dango"),
            keywords: &["dango", "desert", "japan", "ražnjić", "slatko", "štapić"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("dango"),
            keywords: &["dango", "efterrätt", "japan"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("dango"),
            keywords: &[
                "dango",
                "ijiti",
                "kibaniko",
                "kijapani",
                "kitindamlo",
                "tamu",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("டேங\u{bcd}கோ"),
            keywords: &[
                "உணவகம\u{bcd}",
                "உணவு",
                "குச\u{bcd}சியில\u{bcd} உருண\u{bcd}டைகள\u{bcd}",
                "ஜப\u{bcd}ப\u{bbe}னிய உணவு",
                "டேங\u{bcd}கோ",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("డ\u{c3e}ంగ\u{c4b}"),
            keywords: &[
                "డ\u{c3e}ంగ\u{c4b}",
                "పుల\u{c4d}లత\u{c4b} త\u{c3f}న\u{c3e}ల\u{c4d}స\u{c3f}న మ\u{c4b}చ\u{c3f} ఉండలు",
                "మ\u{c4b}చ\u{c3f}",
                "మ\u{c4b}చ\u{c3f} ఉండలు",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("данго"),
            keywords: &["данго", "десерт", "сихкабоб", "чӯб", "ширин", "ҷопонӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ด\u{e31}งโงะ"),
            keywords: &[
                "ด\u{e31}งโงะ",
                "ด\u{e31}งโงะเส\u{e35}ยบไม\u{e49}",
                "โมจ\u{e34}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("dango"),
            keywords: &["dango", "desert", "süýji", "çişlik", "ýapon", "şampur"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("faikakai fakasiapani"),
            keywords: &["faikakai fakasiapani"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("pirinç tatlısı"),
            keywords: &[
                "Japon pirinç tatlısı",
                "dango",
                "pirinç tatlısı",
                "pirinç tatlısı topları",
                "restoran",
                "çubukta pirinç tatlısı topları",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("دانگو"),
            keywords: &["تاتلىق", "دانگو", "دەستە", "زىقلىق", "ياپونچە", "پىشۇرۇق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("рисові кульки на шпажці"),
            keywords: &[
                "десерт",
                "рисові кульки на шпажці",
                "солодкий",
                "шампур",
                "японський",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ڈینگو"),
            keywords: &["جاپانی", "سٹک", "میٹھا", "ڈینگو"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("dango"),
            keywords: &["dango", "shirin", "shirinlik", "six", "tayoq", "yapon"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bánh trôi Nhật Bản"),
            keywords: &[
                "bánh trôi Nhật Bản",
                "món kiểu nhật bản",
                "món tráng miệng",
                "ngọt",
                "que",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("dango"),
            keywords: &["broset", "dango", "deseer", "fruit", "sapone", "suukër"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-dango"),
            keywords: &[
                "emnandi",
                "i-Japanese",
                "i-dango",
                "i-dessert",
                "i-skewer",
                "intonga",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Dango"),
            keywords: &["Dango", "igi", "japanese", "skewer", "àdídùn", "ónjé dídùn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("丸子"),
            keywords: &["串", "丸子", "日本", "棒", "甜", "甜品"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("丸子"),
            keywords: &["串", "丸子", "日本", "棒", "甜", "甜品"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("团子"),
            keywords: &["串", "团子", "日本", "甜点"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("糥米丸子"),
            keywords: &["丸子串", "糥米丸子"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("和菓子"),
            keywords: &["串燒三兄弟", "丸子串", "和菓子"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-dango"),
            keywords: &["i-dango", "induku", "japanese", "okunoshukela", "ubumnandi"],
        },
    ],
};
#[doc = "🥟"]
pub const DUMPLING: crate::Emoji = crate::Emoji {
    glyph: "🥟",
    codepoint: "1F95F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "dumpling",
    group: "Food & Drink",
    subgroup: "food-asian",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kluitjie"),
            keywords: &["empanada", "kluitjie", "toevoupasteitjie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ፍራፍሬ"),
            keywords: &["ፍራፍሬ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("زلابية صينية"),
            keywords: &["زلابية صينية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ড\u{9be}ম\u{9cd}পলিং"),
            keywords: &[
                "এম\u{9cd}প\u{9be}ন\u{9be}ড\u{9be}",
                "গিঅ’জ\u{9be}",
                "জিঅ’জি",
                "ড\u{9be}ম\u{9cd}পলিং",
                "পতষ\u{9cd}টিক\u{9be}ৰ",
                "প\u{9be}ইৰ’গী",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("klyotek"),
            keywords: &[
                "empanada",
                "gyoza",
                "jiaozi",
                "klyotek",
                "pierogi",
                "potsticker",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("пельмені"),
            keywords: &["варэнікі", "гёдза", "пельмені", "цяоцзы", "эмпанада"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("пелмен"),
            keywords: &[
                "гьоза",
                "емпанада",
                "китайски тестени топчета",
                "кнедли",
                "пелмен",
                "тестено топче",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মোমো"),
            keywords: &[
                "এমপ\u{9cd}য\u{9be}ন\u{9cd}ড\u{9be}",
                "গয\u{9bc}োজ\u{9be}",
                "জিয\u{9bc}\u{9be}য\u{9bc}োজি",
                "পটস\u{9cd}টিক\u{9be}র",
                "পিয\u{9bc}েরোগি",
                "মোমো",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pouloud"),
            keywords: &["gyōza", "jiaozi", "pierogi", "pouloud"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("knedla"),
            keywords: &["knedla", "okruglica"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cresta xinesa"),
            keywords: &[
                "cresta",
                "cresta japonesa",
                "cresta xinesa",
                "empanada",
                "gyōza",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᎸᏅᎢ"),
            keywords: &["ᎡᎻᏆᎾᏓ", "ᎦᎸᏅᎢ", "ᎩᏲᏌ", "ᏈᎶᎩ", "ᏥᏯᎣᏏ", "ᏧᎳᏍᎩ ᎠᎩᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("piroh"),
            keywords: &[
                "džiaozi",
                "empanada",
                "gjózu",
                "gyoza",
                "jiaozi",
                "knedlík",
                "knedlíček",
                "pelmeně",
                "pelmeň",
                "piroh",
                "pirohy",
                "taštička",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("twmplen"),
            keywords: &[
                "empanada",
                "gyōza",
                "jiaozi",
                "pierogi",
                "potsticker",
                "twmplen",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("dumpling"),
            keywords: &["dumpling", "gyōza", "jiaozi", "pierogi", "potsticker"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Teigtasche"),
            keywords: &[
                "Empanada",
                "Gyōza",
                "Jiaozi",
                "Pierogi",
                "Teigtasche",
                "chinesische Teigtasche",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ντάμπλινγκ"),
            keywords: &[
                "empanada",
                "gyōza",
                "jiaozi",
                "pierogi",
                "potsticker",
                "ντάμπλινγκ",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("dumpling"),
            keywords: &[
                "dumpling",
                "empanada",
                "gyōza",
                "jiaozi",
                "pierogi",
                "potsticker",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["dumpling", "empanada", "gyōza", "pastie", "samosa"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("dumpling"),
            keywords: &["comida", "dumpling", "gyōza", "jiaozi", "masa"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("empanada"),
            keywords: &["empanada"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("empanada"),
            keywords: &["empanada"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("pelmeen"),
            keywords: &["empanada", "gyōza", "jiaozi", "pelmeen", "pierogi"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("dumpling"),
            keywords: &[
                "dumpling",
                "enpanada",
                "gyōza",
                "jiaozi",
                "pierogi",
                "potsticker",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کوفته"),
            keywords: &[
                "امپاندا",
                "جیائوزی",
                "پیروگی",
                "کوفته",
                "کوفته سرخ\u{200c}شده",
                "گیوزا",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("taikinanyytti"),
            keywords: &["myky", "pelmeni", "taikinanyytti"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("dumpling"),
            keywords: &[
                "dumpling",
                "empanada",
                "gyoza",
                "jiaozi",
                "pierogi",
                "potsticker",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hveitibolli"),
            keywords: &[
                "empanada",
                "gyōza",
                "hveitibolli",
                "jiaozi",
                "matur",
                "pierogi",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("boulette de pâte"),
            keywords: &[
                "boulette de pâte",
                "empanada",
                "gyōza",
                "jiaozi",
                "pierogi",
                "potsticker",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("dumpling"),
            keywords: &[
                "dumpling",
                "empanada",
                "gyōza",
                "jiaozi",
                "pierogi",
                "potsticker",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("domplagán"),
            keywords: &[
                "domplagán",
                "empanada",
                "gyōza",
                "jiaozi",
                "pierogi",
                "potsticker",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("dumplag"),
            keywords: &["dumplag", "empanada", "gyōza", "jiaozi", "pierogi"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("dumpling"),
            keywords: &["dumpling", "empanadilla", "pierogi"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ડમ\u{acd}પલિ\u{a82}ગ"),
            keywords: &[
                "એમ\u{acd}પાનાડા",
                "ગીયોઝા",
                "જિયાઓઝી",
                "ડમ\u{acd}પલિ\u{a82}ગ",
                "ડમ\u{acd}પિ\u{a82}ગ",
                "પિરોગી",
                "પોટસ\u{acd}ટિકર",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ƙaramar kwaɓaɓɓiyar fulawa"),
            keywords: &[
                "empanada",
                "gyōza",
                "jiaozi",
                "pierogi",
                "potsticker",
                "ƙaramar kwaɓaɓɓiyar fulawa",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("דים-סאם"),
            keywords: &["גיוזה", "דים-סאם"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("भरावनय\u{941}क\u{94d}त मीठी या नमकीन पकौड\u{93c}िया\u{901}"),
            keywords: &["भरावनय\u{941}क\u{94d}त मीठी या नमकीन पकौड\u{93c}िया\u{901}"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("okruglica"),
            keywords: &[
                "empanada",
                "gyōza",
                "jiaozi",
                "okruglica",
                "pierogi",
                "školjkica",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("gombóc"),
            keywords: &["gombóc", "töltött tészta"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("պելմենի"),
            keywords: &["խինկալի", "մանտի", "պելմենի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("dumpling"),
            keywords: &["dumpling", "empanada", "gyoza", "jiaozi", "pierogi"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nri achịcha"),
            keywords: &[
                "nri achịcha",
                "nri empanada",
                "nri gyōza",
                "nri jiaozi",
                "nri pierogi",
                "nri potsticker",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("soðkaka"),
            keywords: &["dumpling", "empanada", "gyosa", "pierogi", "soðkaka"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("raviolo"),
            keywords: &[
                "empanada", "gyoza", "jiaozi", "pierogi", "ravioli", "raviolo",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("点心"),
            keywords: &["ぎょうざ", "点心", "肉まん"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("siomay kukus"),
            keywords: &[
                "empanada",
                "gyoza",
                "jiaozi",
                "pierogi",
                "siomay",
                "siomay goreng",
                "siomay kukus",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ხინკალი"),
            keywords: &[
                "გიოზა",
                "გურზა",
                "ემპენადა",
                "ვარენიკი",
                "მანტი",
                "პელმენი",
                "რავიოლი",
                "ხინკალი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("үзбе"),
            keywords: &["үзбе"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("គាវ"),
            keywords: &[
                "គាវ",
                "គាវច\u{17b7}ន",
                "គាវជប\u{17c9}\u{17bb}ន",
                "គាវដ\u{17bb}ត",
                "គាវស\u{17d2}អ\u{17b7}ត",
                "គាវអ\u{17ba}រ\u{17c9}\u{17bb}ប",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಡಂಪ\u{ccd}ಲ\u{cbf}ಂಗ\u{ccd}"),
            keywords: &[
                "ಗ\u{ccd}ಯೋಜಾ",
                "ಜ\u{cbf}ಯಾಜ\u{cbf}",
                "ಡಂಪ\u{ccd}ಲ\u{cbf}ಂಗ\u{ccd}",
                "ಪಾಟ\u{ccd}\u{200c}ಸ\u{ccd}ಟ\u{cbf}ಕರ\u{ccd}",
                "ಪ\u{cbf}ರೋಗ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("만두"),
            keywords: &["교자", "덤플링", "만두"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("डम\u{94d}पलि\u{902}ग"),
            keywords: &[
                "एमपानाडा",
                "ग\u{94d}योझा",
                "जिओझी",
                "डम\u{94d}पलि\u{902}ग",
                "पायरोगी",
                "पोटस\u{94d}टिकर",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("пельмен"),
            keywords: &["пельмен", "чүчпара"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Ravioli"),
            keywords: &["Empanada", "Gyoza", "Jiaozi", "Pierogi", "Ravioli"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກ\u{ec9}ອນໝ\u{eb5}\u{ec8}"),
            keywords: &[
                "ກຽວຊາ",
                "ກ\u{ec9}ອນໝ\u{eb5}\u{ec8}",
                "ຈຽວຊ\u{eb5}",
                "ພ\u{eb1}ອດສະຕ\u{eb4}ກເກ\u{eb5}",
                "ເພຍໂຣກ\u{eb5}",
                "ເອ\u{eb1}ມແພນນາດາ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kukulis"),
            keywords: &["kibinas", "kukulis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pelmeņi"),
            keywords: &["gioza", "pelmeņi", "vareņiki"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("parāoa kinikini"),
            keywords: &["empanada", "gyōza", "jiaozi", "parāoa kinikini", "pierogi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("кнедла"),
            keywords: &["емпанада", "кинеска штрудла", "кнедла", "пирошка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഡമ\u{d4d}പ\u{d4d}ലിങ\u{d4d}ങ\u{d4d}"),
            keywords: &[
                "കൊഴ\u{d41}ക\u{d4d}കട\u{d4d}ട",
                "ഡമ\u{d4d}പ\u{d4d}ലിങ\u{d4d}ങ\u{d4d}",
                "പലഹ\u{d3e}രം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бууз"),
            keywords: &["бууз", "жигнэсэн банш", "шарсан банш"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ड\u{902}पलि\u{902}ग"),
            keywords: &[
                "एम\u{94d}पानाडा",
                "ग\u{94d}योझा",
                "जिओझी",
                "ड\u{902}पलि\u{902}ग",
                "पाइरोगी",
                "पॉटस\u{94d}टिकर",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("ladu"),
            keywords: &["gyoza", "jiaozi", "ladu", "pierogi", "potsticker"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("dumpling"),
            keywords: &[
                "dumpling",
                "empanada",
                "gyōza",
                "jiaozi",
                "pierogi",
                "potsticker",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အစာသ\u{103d}တ\u{103a}မ\u{102f}န\u{1037}\u{103a}"),
            keywords: &[
                "ဝက\u{103a}ကောက\u{103a}ည\u{103e}င\u{103a}း",
                "အစာသ\u{103d}တ\u{103a}မ\u{102f}န\u{1037}\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("dumpling"),
            keywords: &["dumpling", "empanada", "gyoza", "jiaozi", "pirog"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some(
                "बाफ वा तातो पानीमा उमाल\u{947}र बनाइएको पीठोको डल\u{94d}लो खान\u{947}क\u{941}रा",
            ),
            keywords: &[
                "एम\u{94d}पानाडा",
                "ग\u{94d}योजा",
                "जियाओजी",
                "पटस\u{94d}टिकर",
                "पिएरोगी",
                "बाफ वा तातो पानीमा उमाल\u{947}र बनाइएको पीठोको डल\u{94d}लो खान\u{947}क\u{941}रा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("knoedel"),
            keywords: &["empanada", "gyoza", "jiaozi", "knoedel", "pirog"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("dumpling"),
            keywords: &["dumpling", "empanada", "gyoza", "jiaozi", "pirog"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଡମ\u{b4d}ପଲ\u{b3f}ଂ"),
            keywords: &[
                "ଏମପ\u{b3e}ନ\u{b3e}ଡ\u{b3e}",
                "ଗ\u{b3f}ୟୋଜ\u{b3e}",
                "ଜ\u{b3f}ଆଓଜ\u{b3f}",
                "ଡମ\u{b4d}ପଲ\u{b3f}ଂ",
                "ପଟଷ\u{b4d}ଟ\u{b3f}କର\u{b4d}\u{200d}",
                "ପ\u{b3f}ଏରୋଗ\u{b3f}",
                "ମୋମୋ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਡ\u{a70}ਪਲਿ\u{a70}ਗ"),
            keywords: &[
                "ਐਮਪਨਾਦਾ",
                "ਗਊਜ\u{a3c}ਾ",
                "ਜਿਆਓਜੀ",
                "ਡ\u{a70}ਪਲਿ\u{a70}ਗ",
                "ਪਿਏਓਗੀ",
                "ਪ\u{a4b}ਟਸਟਿ\u{a71}ਕਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ڈمپلنگ"),
            keywords: &[
                "ایمپانڈا",
                "جائیوزی",
                "پاٹ اسٹیکر",
                "پکوڑی",
                "ڈمپلنگ",
                "گویوزا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Dọ\u{301}mplin"),
            keywords: &[
                "Chainíz Fud Wé Im Nem Na Jiaózi",
                "Dọ\u{301}mplin",
                "Fud Wé Im Nem Na Dọ\u{301}mplin",
                "Fud Wé Im Nem Na Pọ\u{301}tstíka",
                "Fud Wé Im Nem Na Ẹmpanáda",
                "Japán Fud Wé Im Nem Na Gióza",
                "Oyíbó Fud Wé Im Nem Na Piẹrógi",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pieróg"),
            keywords: &["pieróg"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("غونډاری"),
            keywords: &["غونډاری"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bolinho asiático"),
            keywords: &["asiático", "bolinho", "chinês", "dumpling", "empanada"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("ravioli"),
            keywords: &["empanada", "guioza", "pierogi", "ravioli"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("dumpling"),
            keywords: &[
                "dumpling",
                "empanada",
                "gyōza",
                "jiaozi",
                "pierogi",
                "potsticker",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("găluște chinezești"),
            keywords: &[
                "empanada",
                "găluște chinezești",
                "jiaozi",
                "pierogi",
                "potsticker",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1083"),
            keywords: &["E10-1083"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("вареник"),
            keywords: &["вареник", "клецки", "манты", "пельмени", "хинкали"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugati wokeje"),
            keywords: &[
                "bulete z’abashinwa",
                "juyawozi",
                "piyerogi",
                "udupapuro twamamaza",
                "umugati urimo inyama",
                "umugati wokeje",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پڪوڙو"),
            keywords: &["پوٽ اسٽڪر، جيوزي، پيئروگي، سموسو", "پڪوڙو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඩම\u{dca}ප\u{dca}ල\u{dd2}ං"),
            keywords: &[
                "ඉම\u{dca}ප\u{dcf}ප\u{dcf}ඩ\u{dcf}ව",
                "ජව\u{dd4}සර\u{dca}",
                "ඩම\u{dca}ප\u{dca}ල\u{dd2}ං",
                "ප\u{dd2}රෝග\u{dd3}",
                "පොට\u{dd2}ස\u{dca}ක\u{dca}ටර\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("knedlička"),
            keywords: &["haluška", "knedlička", "pirôžok"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("cmok"),
            keywords: &["cmok"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("cajiimid"),
            keywords: &["cajiimid", "cajiimidda iyo ul ku dhajinta"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("top brumi i mbushur"),
            keywords: &["empanada", "pieroxhi", "top brumi i mbushur", "xhajoza"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кнедла"),
            keywords: &["емпанада", "кнедла", "пироге", "ђао зи"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("knedla"),
            keywords: &["empanada", "knedla", "piroge", "đao zi"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("dumpling"),
            keywords: &[
                "degknyte", "dumpling", "empanada", "gyōza", "jiaozi", "pirog",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("pudini ya kinyunya"),
            keywords: &[
                "empanada",
                "gyoza",
                "jiaozi",
                "pierogi",
                "potsticker",
                "pudini",
                "pudini ya kinyunya",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("டம\u{bcd}ப\u{bcd}ளிங\u{bcd}"),
            keywords: &[
                "க\u{bcd}யோஸ\u{bbe}",
                "ஜிய\u{bbe}ஸி",
                "டம\u{bcd}ப\u{bcd}ளிங\u{bcd}",
                "ப\u{bbe}ட\u{bcd}ஸ\u{bcd}டிக\u{bcd}கர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("డంప\u{c4d}ల\u{c3f}ంగ\u{c4d}"),
            keywords: &[
                "ఎంప\u{c3e}ండ\u{c3e}",
                "గ\u{c47}య\u{c4b}జ\u{c3e}",
                "జ\u{c3f}య\u{c3e}జ\u{c40}",
                "డంప\u{c4d}ల\u{c3f}ంగ\u{c4d}",
                "ప\u{c3e}ట\u{c4d}\u{200c}స\u{c4d}ట\u{c3f}క\u{c4d}కర\u{c4d}",
                "ప\u{c3f}యర\u{c4b}జ\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ғелаккабоб"),
            keywords: &[
                "гиёза",
                "пирог",
                "тушбера",
                "чалпаки гуштдор",
                "ғелаккабоб",
                "ҷиёза",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เก\u{e35}\u{e4a}ยว"),
            keywords: &["เก\u{e35}\u{e4a}ยว", "เก\u{e35}\u{e4a}ยวซ\u{e48}า"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("hytaý böregi"),
            keywords: &["empanada", "gyoza", "hytaý böregi", "jiaozi", "pirogi"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tōpai"),
            keywords: &["tōpai"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("mantı"),
            keywords: &[
                "empanada",
                "gyōza",
                "jiaozi",
                "mantı",
                "pierogi",
                "potsticker",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تۈگرە"),
            keywords: &["بەنشىرە", "تۈگرە", "تۈگۈك", "جۇۋاۋا", "قازانلىق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("вареник"),
            keywords: &["вареник", "вушко", "галушка", "пельмень", "пироги"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پکوڑی"),
            keywords: &["پاٹ سٹیکر", "پکوڑی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("chuchvara"),
            keywords: &[
                "chuchvara",
                "gyoza",
                "manti",
                "pilak",
                "qovurma somsa",
                "uzma",
                "xonim",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bánh bao"),
            keywords: &["bánh bao", "sủi cảo"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("buleet"),
            keywords: &[
                "buleet",
                "empanada",
                "gyōza",
                "jiaozi",
                "pierogi",
                "potsticker",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("imbulanga yentlama"),
            keywords: &[
                "i-empanada",
                "i-gyōza",
                "i-jiaozi",
                "i-pierogi",
                "i-potsticker",
                "imbulanga yentlama",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ìgbẹ\u{301}"),
            keywords: &[
                "empanada",
                "gyōza",
                "jiaozi",
                "pierogi",
                "potsticker",
                "ìgbẹ\u{301}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("餃子"),
            keywords: &["日式餃子", "波蘭餃子", "餃子", "餡餅"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("饺子"),
            keywords: &["日式饺子", "波兰饺子", "饺子", "馅饼"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("饺子"),
            keywords: &["水饺", "煎饺", "饺子"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("水餃"),
            keywords: &["水餃"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["水餃", "煎餃", "餃子"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("idombolo"),
            keywords: &[
                "empanada",
                "gyōza",
                "idombolo",
                "jiaozi",
                "pierogi",
                "potsticker",
            ],
        },
    ],
};
#[doc = "🥠"]
pub const FORTUNE_COOKIE: crate::Emoji = crate::Emoji {
    glyph: "🥠",
    codepoint: "1F960",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "fortune cookie",
    group: "Food & Drink",
    subgroup: "food-asian",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("fortuinkoekie"),
            keywords: &["fortuinkoekie", "voorspelling"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ፎርቹን ኩኪ"),
            keywords: &["ፎርቹን ኩኪ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كعكة الحظ"),
            keywords: &["كعكة الحظ"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ফৰ\u{9cd}চ\u{9c1}ন ক\u{9c1}কি"),
            keywords: &["ফৰ\u{9cd}চ\u{9c1}ন ক\u{9c1}কি", "ভৱিষ\u{9cd}যতব\u{9be}ণী"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("bəxt peçenyesi"),
            keywords: &["bəxt peçenyesi", "peyğəmbərlik"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("пячэнне з прадказаннем"),
            keywords: &["прадказанне", "пячэнне з прадказаннем"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("бисквита с късметче"),
            keywords: &["бисквита с късметче", "предсказание"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ফরচ\u{9c1}ন ক\u{9c1}কি"),
            keywords: &["প\u{9cd}রোফেসি", "ফরচ\u{9c1}ন ক\u{9c1}কি"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kolačić sreće"),
            keywords: &["kolačić sreće", "proročanstvo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("galeta de la sort"),
            keywords: &[
                "fortuna",
                "futur",
                "galeta",
                "galeta de la sort",
                "profecia",
                "sort",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏣᏂᏏ ᎦᏚ ᎤᎦᎾᏍᏓ"),
            keywords: &["ᎤᏩᎫᏗᏗᏒ ᎧᏃᎮᏓ", "ᏣᏂᏏ ᎦᏚ ᎤᎦᎾᏍᏓ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("čínský koláček štěstí"),
            keywords: &[
                "budoucnost",
                "proroctví",
                "předpověď",
                "věštba",
                "čínský koláček štěstí",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bisgeden lwcus"),
            keywords: &["bisgeden lwcus", "proffwydoliaeth"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("lykkekage"),
            keywords: &["lykkekage", "spådom"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Glückskeks"),
            keywords: &["Glückskeks", "Prophezeiung"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τυχερό μπισκότο"),
            keywords: &["προφητεία", "τυχερό μπισκότο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("fortune cookie"),
            keywords: &["fortune cookie", "prophecy"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("galleta de la fortuna"),
            keywords: &[
                "adivinación",
                "galleta de la fortuna",
                "profecía",
                "superstición",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("õnneküpsis"),
            keywords: &["ennustus", "õnneküpsis"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("zortearen gaileta"),
            keywords: &["prophecy", "zortearen gaileta"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("شیرینی شانس"),
            keywords: &["شیرینی شانس", "غیب\u{200c}گویی", "پیشگویی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("onnenkeksi"),
            keywords: &["ennustus", "onnenkeksi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("fortune cookie"),
            keywords: &["fortune cookie", "hula"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("eydnukaka"),
            keywords: &["eydnukaka", "lukkukaka", "matur", "spádómur", "spákaka"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("biscuit chinois"),
            keywords: &["biscuit chinois", "prophétie"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("brioscán feasa"),
            keywords: &["brioscán feasa", "tairngreacht"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("briosgaid fortain"),
            keywords: &[
                "briosgaid fortain",
                "fàdh",
                "fàisneachd",
                "fàistinn",
                "fàthach",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("galleta da fortuna"),
            keywords: &["galleta", "galleta da fortuna", "profecía", "sorte"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ફૉર\u{acd}ચ\u{ac1}ન ક\u{ac1}કી"),
            keywords: &["પ\u{acd}રૉફિસી", "ફૉર\u{acd}ચ\u{ac1}ન ક\u{ac1}કી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("biskit na dukiya"),
            keywords: &["biskit na dukiya", "duba"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עוגיית מזל"),
            keywords: &["מזל", "עוגיה", "עוגיית מזל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("फॉर\u{94d}च\u{942}न क\u{941}की"),
            keywords: &["फॉर\u{94d}च\u{942}न क\u{941}की"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kolačić sreće"),
            keywords: &["kolačić sreće", "proročanstvo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szerencsesüti"),
            keywords: &["jóslat", "szerencsesüti"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("գուշակությունով բլիթ"),
            keywords: &["գուշակություն", "գուշակությունով բլիթ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kue keberuntungan"),
            keywords: &["kue keberuntungan", "ramalan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("kuki achịcha"),
            keywords: &["amụma", "kuki achịcha"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("spádómskaka"),
            keywords: &["opinberun", "spádómskaka", "spádómur", "vitrun"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("biscotto della fortuna"),
            keywords: &["biscotto della fortuna", "profezia"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("フォーチュンクッキー"),
            keywords: &["おみくじ", "フォーチュンクッキー"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("roti begja"),
            keywords: &["ramal", "roti begja"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("იღბლიანი ორცხობილა"),
            keywords: &["იღბლიანი ორცხობილა", "წინასწარმეტყველება"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бақыт печеньесі"),
            keywords: &["бақыт печеньесі"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ន\u{17c6}ខ\u{17bc}កឃ\u{17b8}ប\u{17d2}រាប\u{17cb}ជោគវាសនា"),
            keywords: &[
                "ទ\u{17c6}នាយ",
                "ន\u{17c6}ខ\u{17bc}កឃ\u{17b8}ប\u{17d2}រាប\u{17cb}ជោគវាសនា",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಫಾರ\u{ccd}ಚ\u{ccd}ಯ\u{cc2}ನ\u{ccd} ಕುಕೀ"),
            keywords: &[
                "ಪ\u{ccd}ರೊಫ\u{cc6}ಸ\u{cbf}",
                "ಫಾರ\u{ccd}ಚ\u{ccd}ಯ\u{cc2}ನ\u{ccd} ಕುಕೀ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("포츈 쿠키"),
            keywords: &["포춘 쿠키", "포츈 쿠키"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("फॉर\u{94d}च\u{94d}य\u{941}न क\u{941}की"),
            keywords: &[
                "प\u{94d}रोफ\u{947}सी",
                "फॉर\u{94d}च\u{94d}य\u{941}न क\u{941}की",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("келечекти айтуучу печеньелер"),
            keywords: &["келечекти айтуу", "келечекти айтуучу печеньелер"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Gléckskichelchen"),
            keywords: &["Gléckskichelchen", "Prophezeiung"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຄ\u{eb8}ກກ\u{eb5}\u{ec9}ໂຊກດ\u{eb5}"),
            keywords: &[
                "ຄ\u{eb8}ກກ\u{eb5}\u{ec9}ໂຊກດ\u{eb5}",
                "ໂພຣເພ\u{eb1}ດຊ\u{eb5}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("laimės sausainiukas"),
            keywords: &["laimės sausainiukas", "pranašystė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("laimes cepumiņš"),
            keywords: &["laimes cepumiņš", "pravietojums"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pihikete matapae"),
            keywords: &["pihikete matapae", "poropititanga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("колаче на среќата"),
            keywords: &["колаче на среќата", "пророштво"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഫോർച\u{d4d}യ\u{d42}ൺ ക\u{d41}ക\u{d4d}കി"),
            keywords: &[
                "ചൈനീസ\u{d4d} റെസ\u{d4d}റ\u{d4d}റോറന\u{d4d}റ\u{d4d}",
                "പലഹ\u{d3e}രം",
                "പ\u{d4d}രവചനം",
                "ഫോർച\u{d4d}യ\u{d42}ൺ ക\u{d41}ക\u{d4d}കി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("азын жигнэмэг"),
            keywords: &["азын жигнэмэг", "иш"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("फॉर\u{94d}च\u{94d}य\u{941}न क\u{941}की"),
            keywords: &["फॉर\u{94d}च\u{94d}य\u{941}न क\u{941}की", "भाकीत"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("biskut nasib"),
            keywords: &["biskut nasib", "tilikan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("fortune cookie"),
            keywords: &["fortune cookie", "profezija"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တရ\u{102f}တ\u{103a}မ\u{102f}န\u{1037}\u{103a}"),
            keywords: &[
                "တရ\u{102f}တ\u{103a}မ\u{102f}န\u{1037}\u{103a}",
                "ပရောဖေစ\u{102e}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("lykkekake"),
            keywords: &["fortune cookie", "lykkekake", "spådom"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("फर\u{94d}च\u{941}न क\u{941}की"),
            keywords: &["प\u{94d}रोफ\u{947}सी", "फर\u{94d}च\u{941}न क\u{941}की"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gelukskoekje"),
            keywords: &["gelukskoekje", "profetie"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("lykkekake"),
            keywords: &["fortune cookie", "lykkekake", "spådom"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଫର\u{b4d}ଚ\u{b41}ନ\u{b4d}\u{200d} କ\u{b41}କୀ"),
            keywords: &[
                "ଫର\u{b4d}ଚ\u{b41}ନ\u{b4d}\u{200d} କ\u{b41}କୀ",
                "ଭବ\u{b3f}ଷ\u{b4d}ୟତବ\u{b3e}ଣୀ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਫਾਰਚ\u{a42}ਨ ਕ\u{a42}ਕੀ"),
            keywords: &["ਫਾਰਚ\u{a42}ਨ ਕ\u{a42}ਕੀ", "ਭਵਿ\u{a71}ਖਬਾਣੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("فارچیون ک\u{64f}کی"),
            keywords: &["فارچیون ک\u{64f}کی", "پیشن گوئی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fọtiún Kúki"),
            keywords: &["Fọtiún Kúki", "Prófẹ\u{301}si"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("ciastko z wróżbą"),
            keywords: &["ciastko z wróżbą"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د بخت بسکوټ"),
            keywords: &["د بخت بسکوټ", "د بخت بسکوټ، پيش وينا"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("biscoito da sorte"),
            keywords: &["biscoito da sorte", "profecia"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["biscoito da sorte", "bolinho", "sorte"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("galleta samipaq"),
            keywords: &["galleta samipaq", "profecia"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("prăjiturele cu răvaș"),
            keywords: &["profeție", "prăjiturele cu răvaș"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1084"),
            keywords: &["E10-1084"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("печенье с предсказанием"),
            keywords: &[
                "гадание",
                "оракул",
                "печенье",
                "печенье с предсказанием",
                "предсказание",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igisuguti"),
            keywords: &["igisuguti", "ubuhanuzi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("فارچيون ڪوڪي"),
            keywords: &["اڳڪٿي", "فارچيون ڪوڪي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ව\u{dcf}සන\u{dcf}වන\u{dca}ත ක\u{dd4}ක\u{dd3}"),
            keywords: &[
                "අන\u{dcf}වැක\u{dd2}ය",
                "ව\u{dcf}සන\u{dcf}වන\u{dca}ත ක\u{dd4}ක\u{dd3}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("sušienka s\u{a0}predpoveďou"),
            keywords: &["predpoveď", "sušienka s\u{a0}predpoveďou"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("piškotek sreče"),
            keywords: &["piškotek sreče"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("buskud macaan"),
            keywords: &["buskud macaan", "qof xariif ah", "saadaalinta"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("biskotë fati"),
            keywords: &["biskotë fati", "profeci"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("колачић судбине"),
            keywords: &["колачић судбине", "предсказање"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kolačić sudbine"),
            keywords: &["kolačić sudbine", "predskazanje"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("lyckokaka"),
            keywords: &["lyckokaka", "profetia"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("biskuti ya bahati"),
            keywords: &["biskuti ya bahati", "ubashiri"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஃப\u{bbe}ர\u{bcd}ச\u{bcd}சூன\u{bcd} குக\u{bcd}க\u{bc0}"),
            keywords: &[
                "ஃப\u{bbe}ர\u{bcd}ச\u{bcd}சூன\u{bcd} குக\u{bcd}க\u{bc0}",
                "குக\u{bcd}க\u{bc0}",
                "ஜோசியம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఫ\u{c3e}ర\u{c4d}చ\u{c4d}యూన\u{c4d} కుక\u{c4d}క\u{c40}"),
            keywords: &[
                "జ\u{c4b}స\u{c4d}యం",
                "ఫ\u{c3e}ర\u{c4d}చ\u{c4d}యూన\u{c4d} కుక\u{c4d}క\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("кулчаҳои қандини туҳфадор"),
            keywords: &["кулчаҳои қандини туҳфадор", "пешгӯӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ค\u{e38}กก\u{e35}\u{e49}เส\u{e35}\u{e48}ยงทาย"),
            keywords: &[
                "ขนมดวงด\u{e35}",
                "ค\u{e38}กก\u{e35}\u{e49}เส\u{e35}\u{e48}ยงทาย",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("bagt kökesi"),
            keywords: &["bagt kökesi", "bilgiçlik"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pisikete talamonū"),
            keywords: &["pisikete talamonū"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("fal kurabiyesi"),
            keywords: &["fal kurabiyesi", "kehanet"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تەلەي پىشۇرقى"),
            keywords: &["بىشارەت", "تەلەي پىشۇرقى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("печиво з передбаченням"),
            keywords: &["печиво з передбаченням", "пророцтво"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("قسمت والا بسکٹ"),
            keywords: &["قسمت والا بسکٹ", "پروفیسی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("taqdir pechenyesi"),
            keywords: &[
                "bashorat",
                "folbin",
                "kohin",
                "pechenye",
                "taqdir pechenyesi",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bánh quy may mắn"),
            keywords: &["bánh quy may mắn", "tiên tri"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("mbiskitu musuwaar"),
            keywords: &["mbiskitu musuwaar", "yónent"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqebengwane lethamsanqa"),
            keywords: &["iqebengwane lethamsanqa", "isiprofeto"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("kúkì fortune"),
            keywords: &["asọtẹ\u{301}lẹ\u{300}", "kúkì fortune"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("幸運曲奇"),
            keywords: &["幸運曲奇", "預言"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("幸运曲奇"),
            keywords: &["幸运曲奇", "预言"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("幸运饼干"),
            keywords: &["幸运饼干", "预言"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("幸運餅乾"),
            keywords: &["幸運餅乾"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("幸運曲奇"),
            keywords: &["幸運曲奇", "幸運餅乾"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ikhekhe lenhlanhla"),
            keywords: &["ikhekhe lenhlanhla", "isipholofitho"],
        },
    ],
};
#[doc = "🥡"]
pub const TAKEOUT_BOX: crate::Emoji = crate::Emoji {
    glyph: "🥡",
    codepoint: "1F961",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "takeout box",
    group: "Food & Drink",
    subgroup: "food-asian",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("wegneemeteboks"),
            keywords: &["toevouwegneemboks", "wegneemeteboks"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ምግብ መውሰጃ እቃ"),
            keywords: &["ምግብ መውሰጃ እቃ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("علبة طعام للخارج"),
            keywords: &["علبة طعام للخارج"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("টেকআউট বক\u{9cd}স"),
            keywords: &["অইষ\u{9cd}ট\u{9be}ৰ পেইল", "টেকআউট বক\u{9cd}স"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("özünlə aparmaq qutusu"),
            keywords: &["stridiya vedrəsi", "özünlə aparmaq qutusu"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ежа на вынас"),
            keywords: &["ежа на вынас", "каробка для кітайскай ежы"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("кутия за храна за вкъщи"),
            keywords: &["кутия за храна за вкъщи", "хартиена кутия за храна"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("খ\u{9be}ব\u{9be}র নিয\u{9bc}ে য\u{9be}ওয\u{9bc}\u{9be}র বক\u{9cd}স"),
            keywords: &[
                "ওয\u{9bc}েস\u{9cd}ট\u{9be}র পেল",
                "খ\u{9be}ব\u{9be}র নিয\u{9bc}ে য\u{9be}ওয\u{9bc}\u{9be}র বক\u{9cd}স",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kutija s hranom za ponijeti"),
            keywords: &["kutija", "kutija s hranom za ponijeti", "pakovanje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("menjar per emportar"),
            keywords: &[
                "emportar",
                "envàs",
                "menjar per emportar",
                "menjar xinès",
                "paper",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏫᏛᏗ ᎧᏁᏌ"),
            keywords: &["ᎠᏫᏛᏗ ᎧᏁᏌ", "ᎪᎯᏅᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("krabice na jídlo"),
            keywords: &["jídlo", "krabice na jídlo", "krabička"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bocs prydau parod"),
            keywords: &["bocs prydau parod", "bwced wystrys"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kinesisk takeaway"),
            keywords: &["china box", "kinaboks", "kinesisk takeaway", "takeaway"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Takeaway-Schachtel"),
            keywords: &["Takeaway-Box", "Takeaway-Schachtel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("συσκευασία φαγητού σε πακέτο"),
            keywords: &[
                "πακέτο",
                "συσκευασία",
                "συσκευασία φαγητού σε πακέτο",
                "φαγητό",
                "χάρτινο κουτάκι",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("takeout box"),
            keywords: &["oyster pail", "takeout box"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["oyster pail", "takeaway box", "takeout box"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("takeaway container"),
            keywords: &["takeaway container", "takeout"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("takeout box"),
            keywords: &["oyster pail", "takeout box"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["oyster pail", "takeaway box", "takeout box"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("caja para llevar"),
            keywords: &["caja para llevar", "recipiente para llevar", "restaurante"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "caja para llevar",
                "comida para llevar",
                "recipiente para llevar",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kaasamüügikarp"),
            keywords: &["kaasamüügikarp", "kiirtoidukarp"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("eramateko kaxa"),
            keywords: &["eramateko kaxa", "janari txinatarra eramateko ontzi"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("جعبه بردنی"),
            keywords: &[
                "جعبه بردنی",
                "سطل صدف خوراکی",
                "ظرف غذای ژاپنی",
                "ظرف غذای گاغذی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ateriarasia"),
            keywords: &["ateriarasia", "noutoruoka"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("takeout box"),
            keywords: &["oyster pail", "takeout box"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("tak við heim boks"),
            keywords: &["boks", "matur", "tak við heim boks", "takeaway", "takeout"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("boîte à emporter"),
            keywords: &[
                "boîte à emporter",
                "carton",
                "chinois",
                "nourriture à emporter",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bosca beir leat"),
            keywords: &[
                "bosca beir leat",
                "bosca greim gasta",
                "coimeádán bia",
                "oisre",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bogsa takeout"),
            keywords: &["bogsa bidhe", "bogsa takeout", "sìneach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("comida para levar"),
            keywords: &["chinesa", "comida", "comida para levar"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ટ\u{ac7}કઆઉટ બૉક\u{acd}સ"),
            keywords: &["ઑઇસ\u{acd}ટર પ\u{ac8}લ", "ટ\u{ac7}કઆઉટ બૉક\u{acd}સ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("akwatin abinci na fita waje"),
            keywords: &["akwatin abinci na fita waje", "bokitin oyster"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קופסת משלוח"),
            keywords: &["ערימת צדפות", "קופסת משלוח"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ट\u{947}कआउट बॉक\u{94d}स"),
            keywords: &["ट\u{947}कआउट बॉक\u{94d}स"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kutija za dostavu"),
            keywords: &["kutija za dostavu", "kutija za kinesku hranu"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("elviteles doboz"),
            keywords: &["elviteles doboz", "elviteles papírdoboz"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ուտելիքը տուն տանելու տուփ"),
            keywords: &["ոստրեների տուփ", "ուտելիքը տուն տանելու տուփ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kotak makanan"),
            keywords: &["kotak makanan", "wadah makanan Tionghoa"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("igbe were lawa"),
            keywords: &["igbe were lawa", "nri akwa"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("takeaway-box"),
            keywords: &["kínverskur matur", "taka-með", "takeaway-box"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("confezione da asporto"),
            keywords: &["confezione da asporto", "scatola d’asporto"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("テイクアウト弁当"),
            keywords: &["テイクアウト弁当", "中華", "弁当", "持ち帰り"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kothak bungkus"),
            keywords: &["kothak bungkus"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("საჭმლის წამოსაღები ყუთი"),
            keywords: &["საჭმლის წამოსაღები ყუთი", "წასაღებად"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жол тағамы"),
            keywords: &["жол тағамы"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17d2}រអប\u{17cb}ខ\u{17d2}ចប\u{17cb}អាហារ"),
            keywords: &[
                "ប\u{17d2}រអប\u{17cb}ខ\u{17d2}ចប\u{17cb}អាហារ",
                "ប\u{17d2}រអប\u{17cb}ដាក\u{17cb}អាហារ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಟೇಕ\u{ccd}\u{200c}ಔಟ\u{ccd} ಬಾಕ\u{ccd}ಸ\u{ccd}"),
            keywords: &[
                "ಓಯ\u{cc6}ಸ\u{ccd}ಟರ\u{ccd} ಪ\u{cc6}ಯ\u{ccd}ಲ\u{ccd}",
                "ಟೇಕ\u{ccd}\u{200c}ಔಟ\u{ccd} ಬಾಕ\u{ccd}ಸ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("테이크아웃 상자"),
            keywords: &["테이크아웃 상자"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ट\u{947}कआवट बॉक\u{94d}स"),
            keywords: &["ट\u{947}कआवट बॉक\u{94d}स", "शिनाण\u{94d}याची बादली"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тамакты үйгө салып кетүү үчүн кутуча"),
            keywords: &[
                "тамакты үйгө салып кетүү үчүн кутуча",
                "устрица салынуучу куту",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Takeout-Këscht"),
            keywords: &["Austerkëscht", "Takeout-Këscht"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກ\u{ec8}ອງໃສ\u{ec8}ອາຫານ"),
            keywords: &["ກ\u{ec8}ອງໃສ\u{ec8}ອາຫານ", "ອອຍສເຕ\u{eb5} ແພລ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("dėžutė išsinešti"),
            keywords: &["austrių kibirėlis", "dėžutė išsinešti"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kastīte līdzņemšanai"),
            keywords: &[
                "kastīte līdzņemšanai",
                "ķīniešu ēdienu kastīte līdzņemšanai",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pouaka kaweatu"),
            keywords: &["paepae tio", "pouaka kaweatu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("кутија за храна за носење"),
            keywords: &["кинеска кутија за храна", "кутија за храна за носење"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ടേക\u{d4d}ക\u{d4d}ഔട\u{d4d}ട\u{d4d} ബോക\u{d4d}\u{200c}സ\u{d4d}"),
            keywords: &[
                "ഓയ\u{d4d}\u{200c}സ\u{d4d}റ\u{d4d}റർ പെയിൽ",
                "ടേക\u{d4d}ക\u{d4d}ഔട\u{d4d}ട\u{d4d} ബോക\u{d4d}\u{200c}സ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("авч явах"),
            keywords: &["авч явах", "эмгэн хумс"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ट\u{947}कआउट बॉक\u{94d}स"),
            keywords: &["ऑईस\u{94d}टर प\u{947}ल", "ट\u{947}कआउट बॉक\u{94d}स"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kotak bungkus"),
            keywords: &["kotak bungkus", "tong tiram"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kaxxa tat-takeout"),
            keywords: &["kaxxa tat-takeout", "oyster pail"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ထ\u{102f}ပ\u{103a}ယ\u{1030}သ\u{103d}ားန\u{102d}\u{102f}င\u{103a}သည\u{1037}\u{103a} ဘ\u{1030}း",
            ),
            keywords: &[
                "စက\u{1039}က\u{1030}န\u{103e}င\u{1037}\u{103a}လ\u{102f}ပ\u{103a}တ\u{1032}\u{1037} ထည\u{1037}\u{103a}စရာပ\u{102f}\u{1036}း",
                "ထ\u{102f}ပ\u{103a}ယ\u{1030}သ\u{103d}ားန\u{102d}\u{102f}င\u{103a}သည\u{1037}\u{103a} ဘ\u{1030}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("takeaway-eske"),
            keywords: &["takeaway-boks", "takeaway-eske"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बट\u{94d}टाको खान\u{947}क\u{941}रा"),
            keywords: &[
                "ओइस\u{94d}टर प\u{947}ल",
                "बट\u{94d}टाको खान\u{947}क\u{941}रा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("afhaalmaaltijd"),
            keywords: &["afhaalmaaltijd", "oesteremmer"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("takeaway-eske"),
            keywords: &["takeaway-boks", "takeaway-eske"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ନେଇଯ\u{b3f}ବ\u{b3e} ବ\u{b3e}କ\u{b4d}ସ"),
            keywords: &[
                "ଅଏଷ\u{b4d}ଟର\u{b4d} ପେଲ\u{b4d}",
                "ନେଇଯ\u{b3f}ବ\u{b3e} ବ\u{b3e}କ\u{b4d}ସ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਟ\u{a47}ਕਆਊਟ ਬਾਕਸ"),
            keywords: &["ਟ\u{a47}ਕਆਊਟ ਬਾਕਸ", "ਸੀਪ ਦਾ ਤ\u{a4c}ੜਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ٹیک آؤٹ باکس"),
            keywords: &["اویسٹر پیل", "ٹیک آؤٹ باکس"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tékaút Bọks"),
            keywords: &["Tékaút Bọks", "Ọístá Bọks"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pudełko na wynos"),
            keywords: &["pudełko na wynos"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("وباسل بکس"),
            keywords: &["اویسټر پیل", "وباسل بکس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("caixa para viagem"),
            keywords: &["caixa para viagem"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("caixa de takeaway"),
            keywords: &["caixa", "caixa de takeaway", "comida pronta", "takeaway"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tawak’uchu aparikuypaq"),
            keywords: &["k’uchu ostrawan", "tawak’uchu aparikuypaq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("mâncare la pachet"),
            keywords: &["mâncare chinezească la pachet", "mâncare la pachet"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1085"),
            keywords: &["E10-1085"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("коробка для еды на вынос"),
            keywords: &["коробка для еды на вынос", "на вынос", "с собой"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("agakarito batwaramo ibiryo"),
            keywords: &["agakarito batwaramo ibiryo", "agakarito kajyamo ibifwera"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٻاهر وٺي وڃڻ وارو ڏٻو"),
            keywords: &["اوئيسٽر پيل", "ٻاهر وٺي وڃڻ وارو ڏٻو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කෑම ගෙන යන පෙට\u{dca}ට\u{dd2}ය"),
            keywords: &[
                "කෑම ගෙන යන පෙට\u{dca}ට\u{dd2}ය",
                "බෙල\u{dca}ලන\u{dca} ප\u{dd2}යල\u{dd2}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("rýchle občerstvenie"),
            keywords: &["jedlo", "rýchle občerstvenie", "škatuľka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("embalaža za hrano"),
            keywords: &["embalaža za hrano", "kartonska embalaža za hrano"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("sabduuqa lohodka lagu qaato"),
            keywords: &["sabduuqa lohodka lagu qaato"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kuti për ushqim me vete"),
            keywords: &[
                "kuti kartoni për marrje ushqimi me vete",
                "kuti për ushqim me vete",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кутија за храну"),
            keywords: &["кутија за кинеску храну", "кутија за храну"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kutija za hranu"),
            keywords: &["kutija za hranu", "kutija za kinesku hranu"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("hämtmatkartong"),
            keywords: &["hämtmatkartong", "takeout box"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kisanduku cha chakula"),
            keywords: &["katoni ya chakula", "kisanduku cha chakula"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ச\u{bbe}ப\u{bcd}ப\u{bbe}டுப\u{bcd} பெட\u{bcd}டி"),
            keywords: &[
                "கேரியர\u{bcd}",
                "ச\u{bbe}ப\u{bcd}ப\u{bbe}டுப\u{bcd} பெட\u{bcd}டி",
                "டிபன\u{bcd} கேரியர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c3e}ర\u{c4d}శ\u{c3f}ల\u{c4d} ప\u{c46}ట\u{c4d}ట\u{c46}"),
            keywords: &[
                "ఓయ\u{c3f}స\u{c4d}టర\u{c4d} ప\u{c46}య\u{c3f}ల\u{c4d}",
                "ప\u{c3e}ర\u{c4d}శ\u{c3f}ల\u{c4d} ప\u{c46}ట\u{c4d}ట\u{c46}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("қуттии хӯроки бо худ гирифташаванда"),
            keywords: &[
                "зарфи хӯрокхӯрии садафак",
                "қуттии хӯроки бо худ гирифташаванда",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("อาหารกล\u{e48}องซ\u{e37}\u{e49}อกล\u{e31}บบ\u{e49}าน"),
            keywords: &[
                "อาหารกล\u{e48}องซ\u{e37}\u{e49}อกล\u{e31}บบ\u{e49}าน",
                "อาหารส\u{e31}\u{e48}งกล\u{e31}บบ\u{e49}าน",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("iýmit alyp gidilýän guty"),
            keywords: &["balykgulak", "iýmit alyp gidilýän guty"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kato meʻakai"),
            keywords: &["kato meʻakai"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yiyecek paketi"),
            keywords: &["yiyecek paketi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قەغەز قاپ"),
            keywords: &["قۇلۇلە قاپ", "قەغەز قاپ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("коробка з їжею на винос"),
            keywords: &["коробка з китайською їжею", "коробка з їжею на винос"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پارسل کا ڈبہ"),
            keywords: &["صدف کی بالٹی", "پارسل کا ڈبہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("taom olib ketish uchun quti"),
            keywords: &["olib ketish", "taom olib ketish uchun quti"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hộp đựng đồ ăn mang đi"),
            keywords: &["hộp đựng đồ ăn Trung Quốc", "hộp đựng đồ ăn mang đi"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("boyetu yóbbaale"),
            keywords: &["boyetu yóbbaale", "siwo yoxos"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhokisi ye-takeout"),
            keywords: &["ibhokisi ye-takeout", "iemele yembatyisi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àpótí àgbéjáde"),
            keywords: &["péèlìa ọ\u{301}yẹ\u{301}stà", "àpótí àgbéjáde"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("外賣盒"),
            keywords: &["外賣盒", "蠔桶"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("外卖盒"),
            keywords: &["外卖盒", "蚝桶"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("外卖盒"),
            keywords: &["外卖包装", "外卖桶", "外卖盒", "牡蛎桶"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("外帶餐盒"),
            keywords: &["外帶餐盒"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("外賣盒"),
            keywords: &["外賣", "外賣盒"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhokisi lokuthatha ngaphandle"),
            keywords: &["ibhakede lekhwathu", "ibhokisi lokuthatha ngaphandle"],
        },
    ],
};
