#[doc = "🍼"]
pub const BABY_BOTTLE: crate::Emoji = crate::Emoji {
    glyph: "🍼",
    codepoint: "1F37C",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "baby bottle",
    group: "Food & Drink",
    subgroup: "drink",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("bababottel"),
            keywords: &["baba", "bababottel", "bottel", "drink", "melk"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የህጻን ጡጦ"),
            keywords: &["ሕፃን", "ወተት", "የህጻን ጡጦ", "ጠርሙስ", "ጠጣ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("زجاجة الرضاعة"),
            keywords: &["زجاجة الرضاعة", "لبن"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কে\u{981}চ\u{9c1}ৱ\u{9be}ৰ বটল"),
            keywords: &[
                "কে\u{981}চ\u{9c1}ৱ\u{9be}ৰ বটল",
                "গ\u{9be}খীৰ",
                "প\u{9be}নীয\u{9bc}",
                "বটল",
                "শিশ\u{9c1}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("uşaq şüşəsi"),
            keywords: &["içmək", "körpə", "süd", "uşaq şüşəsi", "şüşə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("дзіцячая бутэлечка"),
            keywords: &[
                "бутэлечка",
                "дзіцячая бутэлечка",
                "малако",
                "напой",
                "немаўля",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Бебешка бутилка"),
            keywords: &["Бебешка бутилка", "бебе", "бутилка", "мляко"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("শিশ\u{9c1}দের বোতল"),
            keywords: &[
                "দ\u{9c1}ধ",
                "প\u{9be}ন কর\u{9be}",
                "ব\u{9be}চ\u{9cd}চ\u{9be}",
                "বোতল",
                "শিশ\u{9c1}দের বোতল",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bured"),
            keywords: &["babig", "bured", "evaj", "laezh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("flašica za bebu"),
            keywords: &["beba", "flašica", "flašica za bebu", "mlijeko", "piće"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("biberó"),
            keywords: &["bebè", "beguda", "biberó", "llet", "nadó"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some(
                "𑄇\u{1112a}𑄏\u{11128} 𑄌\u{11128}𑄌\u{11134}\u{11128}𑄇\u{11134}\u{1112e}𑄢\u{11134} 𑄝\u{11127}𑄘\u{11127}𑄣\u{11134}",
            ),
            keywords: &[
                "𑄇\u{1112a}𑄏\u{11128} 𑄌\u{11128}𑄌\u{11134}\u{11128}𑄇\u{11134}\u{1112e}𑄢\u{11134} 𑄝\u{11127}𑄘\u{11127}𑄣\u{11134}",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏍᏗ ᎤᏍᏛᏍᏗ"),
            keywords: &["ᎠᏗᏔᏍᏗ", "ᎤᏅᏗ", "ᎤᏍᏗ", "ᎤᏍᏗ ᎤᏍᏛᏍᏗ", "ᎫᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kojenecká láhev"),
            keywords: &["dítě", "kojenecká láhev", "lahev", "mléko", "nápoj"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("botel babi"),
            keywords: &["babi", "botel", "diod", "llaeth"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sutteflaske"),
            keywords: &["flaske", "mælk", "sutteflaske"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Babyflasche"),
            keywords: &[
                "Baby",
                "Babyflasche",
                "Fläschchen",
                "Kind",
                "Milch",
                "trinken",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μπιμπερό"),
            keywords: &["γάλα", "μπιμπερό", "μπουκάλι", "μωρό", "πίνω"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("baby bottle"),
            keywords: &["baby", "bottle", "drink", "milk"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["baby", "baby’s bottle", "bottle", "drink", "milk"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("biberón"),
            keywords: &["bebé", "bibe", "biberón", "bibi", "botella", "leche"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["bebé", "biberón", "botella", "leche", "mamadera"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["bebida", "bebé", "biberón", "botella", "leche"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("lutipudel"),
            keywords: &["beebi", "lutipudel", "piim", "pudel"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("biberoia"),
            keywords: &["biberoia", "botila", "edan", "esne", "haurtxo"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("شیشه شیر"),
            keywords: &["بطری", "بچه", "شیر", "شیشه شیر", "نوزاد", "نوشیدن"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tuttipullo"),
            keywords: &["juoda", "maito", "pullo", "tuttipullo", "vauva"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("dede"),
            keywords: &["bote", "dede", "gatas", "inumin", "sanggol"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("boppufløska"),
            keywords: &["boppufløska", "drykkur", "fløska", "mjólk"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("biberon"),
            keywords: &["biberon", "boisson", "bébé", "lait"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("buidéal babaí"),
            keywords: &["bainne", "buidéal", "buidéal babaí", "deoch"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("botal leinibh"),
            keywords: &["bainne", "botal", "botal leinibh", "deoch", "leanabh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("biberón"),
            keywords: &["beber", "bebé", "biberón", "leite"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("શિશ\u{ac1}ની બોટલ"),
            keywords: &[
                "દ\u{ac2}ધ",
                "પીણ\u{ac1}\u{a82}",
                "બોટલ",
                "શિશ\u{ac1} બોટલ",
                "શિશ\u{ac1}ની બોટલ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kwalbar jarirai"),
            keywords: &["jariri", "kwalba", "kwalbar jarirai", "madara", "sha"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("בקבוק של תינוק"),
            keywords: &["בקבוק", "בקבוק של תינוק", "חלב", "תינוק"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बच\u{94d}च\u{947} क\u{947} द\u{942}ध की बोतल"),
            keywords: &[
                "द\u{942}ध",
                "प\u{947}य",
                "बच\u{94d}च\u{947} क\u{947} द\u{942}ध की बोतल",
                "ब\u{947}बी बोतल",
                "बोतल",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("bočica za bebe"),
            keywords: &["beba", "bočica", "bočica za bebe", "mlijeko", "piti"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("cumisüveg"),
            keywords: &["baba", "cumi", "cumisüveg", "tej"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մանկական շիշ"),
            keywords: &["խմել", "կաթ", "մանկական", "շիշ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("botol bayi"),
            keywords: &["bayi", "botol", "minuman", "susu"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("karama nwata ọhụrụ"),
            keywords: &[
                "ara ehi",
                "karama",
                "karama nwata ọhụrụ",
                "nwata ọhụrụ",
                "ṅụọ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("peli"),
            keywords: &["drekka", "mjólk", "peli"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("biberon"),
            keywords: &["bere", "biberon", "latte"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ほにゅう瓶"),
            keywords: &["ほにゅう瓶", "ミルク", "赤ちゃん"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("botol kempong"),
            keywords: &["bayi", "botol", "botol kempong", "susu", "unjukan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბავშვის ბოთლი"),
            keywords: &[
                "ბავშვი",
                "ბავშვის ბოთლი",
                "ბოთლი",
                "დალევა",
                "დასალევი",
                "რძე",
                "სასმელი",
                "სმა",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сәби бөтелкесі"),
            keywords: &["бөтелке", "сусын", "сүт", "сәби", "сәби бөтелкесі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("sutteflaske"),
            keywords: &["flaske", "mælk", "sutteflaske"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ដបទ\u{17b9}កដោះគោ"),
            keywords: &[
                "ដប",
                "ដបទ\u{17b9}កដោះគោ",
                "ទារក",
                "ទ\u{17b9}កដោះគោ",
                "ផ\u{17b9}ក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬೇಬ\u{cbf} ಬಾಟಲ\u{ccd}"),
            keywords: &["ಬೇಬ\u{cbf} ಬಾಟಲ\u{ccd}", "ಹಾಲು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("젖병"),
            keywords: &["아기 젖병", "우유", "젖병"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("शिश\u{942}ची बाटली"),
            keywords: &[
                "द\u{942}द",
                "पिण\u{947}\u{902}",
                "बाटली",
                "शिश\u{942}",
                "शिश\u{942}ची बाटली",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("баланын бөтөлкөсү"),
            keywords: &["бала", "баланын бөтөлкөсү", "бөтөлкө", "ич", "сүт"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Biberon"),
            keywords: &["Biberon", "Fläsch", "Mëllech", "Puppelchen", "drénken"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຕ\u{ebb}\u{ec9}ານ\u{ebb}ມເດ\u{eb1}ກ"),
            keywords: &[
                "ຂວດນ\u{ebb}ມ",
                "ນ\u{ebb}ມ",
                "ເຕ\u{ebb}\u{ec9}ານ\u{ebb}ມເດ\u{eb1}ກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kūdikio buteliukas"),
            keywords: &[
                "buteliukas",
                "gerti",
                "kūdikio buteliukas",
                "kūdikis",
                "pienas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("bērna pudelīte"),
            keywords: &[
                "bērna pudelīte",
                "bērns",
                "dzert",
                "piens",
                "pudele",
                "zīdainis",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pātara pēpi"),
            keywords: &["miraka", "pātara", "pēpi", "unu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("шише за бебе"),
            keywords: &["бебе", "млеко", "шише", "шише за бебе"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d3e}ൽക\u{d4d}ക\u{d41}പ\u{d4d}പി"),
            keywords: &[
                "ക\u{d41}പ\u{d4d}പി",
                "പ\u{d3e}ൽ",
                "പ\u{d3e}ൽക\u{d4d}ക\u{d41}പ\u{d4d}പി",
                "ബേബി ബോട\u{d4d}ടിൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хүүхдийн сүүний сав"),
            keywords: &["нялх хүүхэд", "сав", "сүү", "уух", "хүүхдийн сүүний сав"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("लहान म\u{941}लाची द\u{941}धाची बॉटल"),
            keywords: &[
                "द\u{942}ध",
                "प\u{947}य",
                "बाटली",
                "बाळ",
                "बाळाची बाटली",
                "लहान बाटली",
                "लहान म\u{941}लाची द\u{941}धाची बॉटल",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("botol susu"),
            keywords: &["bayi", "botol", "minum", "susu"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("flixkun tat-trabi"),
            keywords: &["flixkun", "flixkun tat-trabi", "tarbija", "xarba", "ħalib"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကလေးန\u{102d}\u{102f}\u{1037}ဗ\u{1030}း"),
            keywords: &[
                "ကလေးငယ\u{103a}",
                "ကလေးန\u{102d}\u{102f}\u{1037}ဗ\u{1030}း",
                "န\u{102d}\u{102f}\u{1037}",
                "န\u{102d}\u{102f}\u{1037}ဘ\u{1030}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("tåteflaske"),
            keywords: &["babyflaske", "drikke", "melk", "tåteflaske"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बच\u{94d}चाको बोतल"),
            keywords: &[
                "द\u{942}ध",
                "पिउन\u{947}",
                "बच\u{94d}चा",
                "बच\u{94d}चाको बोतल",
                "बोतल",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("babyflesje"),
            keywords: &["baby", "babyflesje", "drinken", "flesje", "melk"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("tåteflaske"),
            keywords: &["babyflaske", "drikke", "mjølk", "tåteflaske"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଶ\u{b3f}ଶ\u{b41} ବୋତଲ"),
            keywords: &[
                "ଦ\u{b41}ଗ\u{b4d}ଧ",
                "ପ\u{b3e}ନୀୟ",
                "ବୋତଲ\u{b4d}\u{200c}",
                "ଶ\u{b3f}ଶ\u{b41}",
                "ଶ\u{b3f}ଶ\u{b41} ବୋତଲ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a71}ਚ\u{a47} ਦੀ ਬ\u{a4b}ਤਲ"),
            keywords: &[
                "ਦ\u{a41}\u{a71}ਧ",
                "ਪੀਣਾ",
                "ਬ\u{a4b}ਤਲ",
                "ਬ\u{a71}ਚ\u{a47} ਦੀ ਬ\u{a4b}ਤਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بال دی بوتل"),
            keywords: &["بال", "بال دی بوتل", "بوتل", "دودھ", "شربت"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fidín Bọ\u{301}tul"),
            keywords: &["Bébi", "Bọtul", "Drink", "Fidín Bọ\u{301}tul", "Mílik"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("butelka ze smoczkiem"),
            keywords: &[
                "butelka",
                "butelka ze smoczkiem",
                "dzidziuś",
                "mleko",
                "napój",
                "niemowlęca",
                "ze smoczkiem",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د ماشوم بوتل"),
            keywords: &["د ماشوم بوتل", "ماشوم، بوتل، څښاک، شيدې"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mamadeira"),
            keywords: &["bebê", "leite", "leitinho", "mamadeira", "neném"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("biberão"),
            keywords: &["beber", "bebé", "biberão", "leite"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("biberón"),
            keywords: &["biberon", "biberón", "upyana", "wawa", "wilali"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("biberon"),
            keywords: &["bebeluș", "biberon", "lapte", "sticlă", "suzetă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-321"),
            keywords: &["E10-321"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("бутылочка с соской"),
            keywords: &["бутылка", "бутылочка с соской", "дети", "молоко", "соска"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("bibero"),
            keywords: &["amata", "bibero", "icupa", "kunywa", "umwana"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ننڍن ٻارن جي بوتل"),
            keywords: &["ننڍا ٻار، بوتل، پيئڻ، کير", "ننڍن ٻارن جي بوتل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ළදර\u{dd4} බෝතලය"),
            keywords: &[
                "ක\u{dd2}ර\u{dd3}ම",
                "ප\u{dcf}නය ක\u{dd2}ර\u{dd3}ම",
                "බෝතලය",
                "ළදර\u{dd4} බෝතලය",
                "ළදර\u{dd4}ව\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("detská fľaša"),
            keywords: &["detská", "fľaša", "mlieko", "nápoj"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("steklenička"),
            keywords: &["dojenček", "mleko", "piti", "steklenica", "steklenička"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dhalada ilmaha"),
            keywords: &["caano", "cab", "dhalada ilmaha", "dhalo", "ilma"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shishe për bebe"),
            keywords: &["bebe", "pije", "qumësht", "shishe", "shishe për bebe"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("флашица за бебе"),
            keywords: &["бeбa", "бочицa", "млeкo", "пити", "флашица за бебе"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["флашица за бебе"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("flašica za bebe"),
            keywords: &["beba", "bočica", "flašica za bebe", "mleko", "piti"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["flašica za bebe"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("nappflaska"),
            keywords: &["dryck", "flaska", "mjölk", "nappflaska"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("chupa ya maziwa ya mtoto"),
            keywords: &[
                "chupa",
                "chupa ya maziwa ya mtoto",
                "kinywaji",
                "maziwa",
                "mtoto",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஃப\u{bc0}டிங\u{bcd} ப\u{bbe}ட\u{bcd}டில\u{bcd}"),
            keywords: &[
                "ஃப\u{bc0}டிங\u{bcd} ப\u{bbe}ட\u{bcd}டில\u{bcd}",
                "சிறுபிள\u{bcd}ளைத\u{bcd}தனம\u{bcd}",
                "ப\u{bbe}ட\u{bcd}டில\u{bcd}",
                "ப\u{bbe}னம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c3e}ల డబ\u{c4d}బ\u{c3e}"),
            keywords: &[
                "చ\u{c3f}న\u{c4d}నప\u{c3f}ల\u{c4d}లలకు ప\u{c3e}లు పట\u{c4d}ట\u{c3f}ంచ\u{c47} బ\u{c3e}ట\u{c3f}ల\u{c4d}",
                "ప\u{c3e}న\u{c40}యం",
                "ప\u{c3e}ల డబ\u{c4d}బ\u{c3e}",
                "ప\u{c3e}లు",
                "బ\u{c3e}ట\u{c3f}ల\u{c4d}",
                "బ\u{c47}బ\u{c40} బ\u{c3e}ట\u{c3f}ల\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("шишаи кӯдак"),
            keywords: &["кӯдак", "нӯшидан", "шир", "шиша", "шишаи кӯдак"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ขวดนม"),
            keywords: &["ขวดนม", "นม"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("bäbek çüýşesi"),
            keywords: &["bäbek", "bäbek çüýşesi", "içmek", "süýt", "çüýşe"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("hinahuhu"),
            keywords: &["hinahuhu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("biberon"),
            keywords: &["biberon", "içecek", "süt", "şişe"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئېمىزگۈ قۇتا"),
            keywords: &["ئىچىملىك", "ئېمىزگۈ قۇتا", "بوتۇلكا", "بوۋاق", "سۈت"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("пляшечка для немовляти"),
            keywords: &[
                "молоко",
                "немовля",
                "пити",
                "пляшечка",
                "пляшечка для немовляти",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("فیڈر"),
            keywords: &["بوتل", "بچہ", "دودھ", "فیڈر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("chaqaloqlar idishi"),
            keywords: &[
                "chaqaloq",
                "chaqaloqlar idishi",
                "ichimlik",
                "shisha",
                "sut",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bình sữa trẻ em"),
            keywords: &["bình", "bình sữa trẻ em", "em bé", "sữa", "uống"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("biberoŋ"),
            keywords: &["biberoŋ", "buteel", "liir", "meew", "naan"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhotile yosana"),
            keywords: &["ibhotile", "ibhotile yosana", "isiselo", "ubisi", "usana"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Igo Ikoko"),
            keywords: &["Igo Ikoko", "mílíkì", "ohun mímu", "ìgò", "ìkókó"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("嬰兒奶樽"),
            keywords: &["奶", "嬰兒", "嬰兒奶樽", "樽", "飲品"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("婴儿奶樽"),
            keywords: &["奶", "婴儿", "婴儿奶樽", "樽", "饮品"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("奶瓶"),
            keywords: &["奶", "奶瓶", "婴儿"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("奶瓶"),
            keywords: &["奶瓶", "牛奶"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("奶樽"),
            keywords: &["奶樽", "牛奶", "牛奶樽"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhodlela lengane"),
            keywords: &[
                "ibhodlela",
                "ibhodlela lengane",
                "ingane",
                "isiphuzo",
                "ubisi",
            ],
        },
    ],
};
#[doc = "🥛"]
pub const GLASS_OF_MILK: crate::Emoji = crate::Emoji {
    glyph: "🥛",
    codepoint: "1F95B",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "glass of milk",
    group: "Food & Drink",
    subgroup: "drink",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("glas melk"),
            keywords: &["glas melk", "kos", "melk"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የወተት ብርጭቆ"),
            keywords: &["መጠጣት", "ብርጭቆ", "ወተት", "የወተት ብርጭቆ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كوب حليب"),
            keywords: &["حليب", "شراب", "كوب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("গ\u{9be}খীৰৰ গিল\u{9be}চ"),
            keywords: &[
                "গ\u{9be}খীৰ",
                "গ\u{9be}খীৰৰ গিল\u{9be}চ",
                "গিল\u{9be}চ",
                "প\u{9be}নীয\u{9bc}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("bir stəkan süd"),
            keywords: &["bir stəkan süd", "içki", "stəkan", "süd"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("шклянка малака"),
            keywords: &["малако", "пітво", "шклянка", "шклянка малака"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("чаша мляко"),
            keywords: &["мляко", "напитка", "чаша"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("দ\u{9c1}ধের গ\u{9cd}ল\u{9be}স"),
            keywords: &[
                "গ\u{9cd}ল\u{9be}স",
                "থ\u{9be}ওয\u{9bc}\u{9be}",
                "দ\u{9c1}ধ",
                "দ\u{9c1}ধের গ\u{9cd}ল\u{9be}স",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("gwerennad laezh"),
            keywords: &["evaj", "gwerenn", "gwerennad laezh", "laezh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("mlijeko"),
            keywords: &["mlijeko", "piće", "čaša", "čaša mlijeka"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("got de llet"),
            keywords: &["beguda", "got", "got de llet", "llet"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄘\u{1112a}𑄙\u{1112e} 𑄉\u{11127}𑄣\u{11127}𑄌\u{11134}"),
            keywords: &["𑄘\u{1112a}𑄙\u{1112e} 𑄉\u{11127}𑄣\u{11127}𑄌\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏅᏗ ᎤᎸᏌᏗ ᎠᏟᏍᏛᎢ"),
            keywords: &["ᎠᏗᏔᏍᏗ", "ᎤᎸᏌᏗ", "ᎤᏅᏗ", "ᎤᏅᏗ ᎤᎸᏌᏗ ᎠᏟᏍᏛᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("sklenice mléka"),
            keywords: &["mléko", "nápoj", "sklenice", "sklenice mléka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("gwydraid o laeth"),
            keywords: &["diod", "gwydraid", "gwydraid o laeth", "llaeth"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("glas mælk"),
            keywords: &["drik", "drikke", "glas", "mælk"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Glas Milch"),
            keywords: &["Getränk", "Glas", "Milch"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ποτήρι γάλα"),
            keywords: &["γάλα", "ποτήρι", "ποτό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("glass of milk"),
            keywords: &["drink", "glass", "glass of milk", "milk"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("vaso de leche"),
            keywords: &["bebida", "leche", "vaso", "vaso de leche"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("klaas piima"),
            keywords: &["jook", "klaas", "klaas piima", "piim"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("edalontzi bat esne"),
            keywords: &["edalontzi", "edalontzi bat esne", "edan", "esne"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("لیوان شیر"),
            keywords: &["شیر", "لیوان", "نوشیدن"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("maitolasi"),
            keywords: &["juoma", "lasi", "maito", "maitolasi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("baso ng gatas"),
            keywords: &["baso", "baso ng gatas", "gatas", "inumin"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("glas av mjólk"),
            keywords: &["drykkur", "glas", "glas av mjólk", "mjólk"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("verre de lait"),
            keywords: &["boisson", "lait", "verre", "verre de lait"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("gloine bainne"),
            keywords: &["bainne", "deoch", "gloine bainne", "gloinne"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("glainne de bhainne"),
            keywords: &["bainne", "deoch", "glainne", "glainne de bhainne", "òl"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("vaso de leite"),
            keywords: &["bebida", "leite", "vaso", "vaso de leite"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("દ\u{ac2}ધનો ગ\u{acd}લાસ"),
            keywords: &[
                "ગ\u{acd}લાસ",
                "દ\u{ac2}ધ",
                "દ\u{ac2}ધનો ગ\u{acd}લાસ",
                "પીણ\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("gilashin madara"),
            keywords: &["abinsha", "gilashi", "gilashin madara", "madara"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כוס חלב"),
            keywords: &["חלב", "כוס"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("द\u{942}ध का गिलास"),
            keywords: &[
                "ग\u{94d}लास",
                "द\u{942}ध",
                "द\u{942}ध का गिलास",
                "प\u{947}य",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("čaša mlijeka"),
            keywords: &["mlijeko", "piće", "čaša", "čaša mlijeka"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("egy pohár tej"),
            keywords: &["egy pohár tej", "ital", "pohár", "tej"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մի բաժակ կաթ"),
            keywords: &["բաժակ", "ըմպելիք", "կաթ", "մի բաժակ կաթ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("gelas susu"),
            keywords: &["gelas", "minum susu", "susu"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Iko nkụwa Nke Mmiri ara Ehi"),
            keywords: &["Iko nkụwa Nke Mmiri ara Ehi", "ara ehi", "iko", "mmiri"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("mjólkurglas"),
            keywords: &["drykkur", "glas", "mjólk", "mjólkurglas"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("bicchiere di latte"),
            keywords: &["bevanda", "bicchiere", "bicchiere di latte", "latte"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("牛乳入りのコップ"),
            keywords: &["コップ", "ミルク", "牛乳", "牛乳入りのコップ"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sagelas susu"),
            keywords: &["gelas", "sagelas susu", "susu", "unjukan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჭიქა რძე"),
            keywords: &["რძე", "სასმელი", "ჭიქა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("стақан сүт"),
            keywords: &["стақан", "сусын", "сүт"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("glas mælk"),
            keywords: &["drik", "drikke", "glas", "mælk"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ទ\u{17b9}កដោះគោម\u{17bd}យកែវ"),
            keywords: &[
                "កែវ",
                "ទ\u{17b9}កដោះគោ",
                "ទ\u{17b9}កដោះគោម\u{17bd}យកែវ",
                "ផ\u{17b9}ក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಒಂದು ಲೋಟ ಹಾಲು"),
            keywords: &["ಒಂದು ಲೋಟ ಹಾಲು", "ಕುಡ\u{cbf}", "ಲೋಟ", "ಹಾಲು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("우유 한잔"),
            keywords: &["글라스", "밀크", "우유", "한잔"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("द\u{941}दाचो ग\u{94d}लास"),
            keywords: &[
                "ग\u{94d}लास",
                "द\u{941}दाचो ग\u{94d}लास",
                "द\u{942}द",
                "पिण\u{947}\u{902}",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бир стакан сүт"),
            keywords: &["бир стакан сүт", "стакан", "суусундук", "сүт"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Glas Mëllech"),
            keywords: &["Gedrénks", "Glas", "Mëllech"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຈອກນ\u{ebb}ມ"),
            keywords: &[
                "ຈອກ",
                "ຈອກນ\u{ebb}ມ",
                "ນ\u{ebb}ມ",
                "ເຄ\u{eb7}\u{ec8}ອງດ\u{eb7}\u{ec8}ມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("pieno stiklinė"),
            keywords: &["gėrimas", "pienas", "pieno stiklinė", "sktiklinė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("piena glāze"),
            keywords: &["dzert", "glāze", "piena glāze", "piens"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("karāhe miraka"),
            keywords: &["karāhe", "miraka", "unu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("чаша млеко"),
            keywords: &["млеко", "чаша"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d3e}ൽ ഗ\u{d4d}ല\u{d3e}സ\u{d4d}സ\u{d4d}"),
            keywords: &[
                "ഗ\u{d4d}ല\u{d3e}സ\u{d4d}സ\u{d4d}",
                "പ\u{d3e}നീയം",
                "പ\u{d3e}ൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("аяга сүү"),
            keywords: &["аяга", "сүү", "унд"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("द\u{941}धाचा ग\u{94d}लास"),
            keywords: &[
                "ग\u{94d}लास",
                "द\u{941}धाचा ग\u{94d}लास",
                "द\u{942}ध",
                "प\u{947}य",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("segelas susu"),
            keywords: &["gelas", "minuman", "segelas susu", "susu"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("tazza ħalib"),
            keywords: &["tazza", "xarba", "ħalib"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("န\u{103d}ားန\u{102d}\u{102f}\u{1037}တစ\u{103a}ခ\u{103d}က\u{103a}"),
            keywords: &[
                "န\u{103d}ားန\u{102d}\u{102f}\u{1037}",
                "န\u{103d}ားန\u{102d}\u{102f}\u{1037}တစ\u{103a}ခ\u{103d}က\u{103a}",
                "ဖန\u{103a}ခ\u{103d}က\u{103a}",
                "အသောက\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("melkeglass"),
            keywords: &["drikke", "glass", "melk", "melkeglass"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("द\u{942}धको गिलास"),
            keywords: &["गिलास", "द\u{942}ध", "द\u{942}धको गिलास", "प\u{947}य"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("glas melk"),
            keywords: &["drank", "glas", "melk"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mjølkeglas"),
            keywords: &["drikke", "glas", "mjølk", "mjølkeglas"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b4d}ଷୀର ଗ\u{b4d}ଲ\u{b3e}ସ"),
            keywords: &[
                "କ\u{b4d}ଷୀର ଗ\u{b4d}ଲ\u{b3e}ସ",
                "ଗ\u{b4d}ଲ\u{b3e}ସ । କ\u{b4d}ଷୀର । ପ\u{b3e}ନୀୟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਦ\u{a41}\u{a71}ਧ ਦਾ ਗਲਾਸ"),
            keywords: &[
                "ਗਲਾਸ",
                "ਦ\u{a41}\u{a71}ਧ",
                "ਦ\u{a41}\u{a71}ਧ ਦਾ ਗਲਾਸ",
                "ਪੀਣ-ਪਦਾਰਥ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("دودھ دا گلاس"),
            keywords: &["دودھ", "دودھ دا گلاس", "شربت", "گلاس"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Glás Ọf Mílik"),
            keywords: &["Drink", "Glas", "Glás Ọf Mílik", "Mílik"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("szklanka mleka"),
            keywords: &["mleko", "napój", "szklanka", "szklanka mleka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د شيدو ګيلاس"),
            keywords: &["د شيدو ګيلاس", "څښاک، ګيلاس، د شيدو ګيلاس، شيدې"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("copo de leite"),
            keywords: &["copo", "copo de leite", "leite"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["bebida", "copo", "copo de leite", "leite"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("wilali qirupi"),
            keywords: &["qiru", "upyana", "wilali", "wilali qirupi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pahar cu lapte"),
            keywords: &["băutură", "lapte", "pahar", "pahar cu lapte"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1079"),
            keywords: &["E10-1079"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("стакан молока"),
            keywords: &["молоко", "напиток", "стакан", "стакан молока"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikirahuri cy’amata"),
            keywords: &["amata", "ikirahuri", "ikirahuri cy’amata", "kunywa"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("کير جو گلاس"),
            keywords: &["کير جو گلاس", "گلاس، کير، پيئڻ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dd2}ර\u{dd2} ව\u{dd3}ද\u{dd4}ර\u{dd4}ව"),
            keywords: &["ක\u{dd2}ර\u{dd2}", "බ\u{dd3}ම", "ව\u{dd3}ද\u{dd4}ර\u{dd4}ව"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("pohár mlieka"),
            keywords: &["mlieko", "nápoj", "pohár", "pohár mlieka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kozarec mleka"),
            keywords: &["kozarec", "kozarec mleka", "mleko", "pijača"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("galaas caano ah"),
            keywords: &["caano", "cab", "galaas", "galaas caano ah"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gotë me qumësht"),
            keywords: &["gotë", "gotë me qumësht", "pije", "qumësht"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("чаша млека"),
            keywords: &["млеко", "пиће", "чаша", "чаша млека"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("чаша млијека"),
            keywords: &["чаша млијека"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("čaša mleka"),
            keywords: &["mleko", "piće", "čaša", "čaša mleka"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("čaša mlijeka"),
            keywords: &["čaša mlijeka"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("mjölkglas"),
            keywords: &["dryck", "glas", "mjölk", "mjölkglas"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("glasi yenye maziwa"),
            keywords: &["glasi", "glasi yenye maziwa", "kinywaji", "maziwa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ப\u{bbe}ல\u{bcd}"),
            keywords: &["ப\u{bbe}னம\u{bcd}", "ப\u{bbe}ல\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c3e}ల గ\u{c4d}ల\u{c3e}స\u{c4d}"),
            keywords: &[
                "గ\u{c4d}ల\u{c3e}స\u{c4d}",
                "ప\u{c3e}న\u{c40}యం",
                "ప\u{c3e}ల గ\u{c4d}ల\u{c3e}స\u{c4d}",
                "ప\u{c3e}లు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("стакани шир"),
            keywords: &["нӯшидан", "стакан", "стакани шир", "шир"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แก\u{e49}วนม"),
            keywords: &[
                "นม",
                "เคร\u{e37}\u{e48}องด\u{e37}\u{e48}ม",
                "แก\u{e49}ว",
                "แก\u{e49}วนม",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("bir bulgur süýt"),
            keywords: &["bir bulgur süýt", "bulgur", "içmek", "süýt"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ipu huʻakau"),
            keywords: &["ipu huʻakau"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("süt bardağı"),
            keywords: &["bardak", "içecek", "süt", "süt bardağı"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("بىر قاچا سۈت"),
            keywords: &["ئىستاكان", "ئىچىملىك", "بىر قاچا سۈت", "سۈت"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("склянка молока"),
            keywords: &["молоко", "напій", "склянка", "склянка молока"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("دودھ کا گلاس"),
            keywords: &["دودھ", "دودھ کا گلاس", "مشروب", "گلاس"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("bir stakan sut"),
            keywords: &["bir stakan sut", "ichimlik", "stakan", "sut"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cốc sữa"),
            keywords: &["cốc", "sữa", "đồ uống"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kaasu meew"),
            keywords: &["kaas", "kaasu meew", "meew", "naan"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iglasi yobisi"),
            keywords: &["iglasi", "iglasi yobisi", "isiselo", "ubisi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ife Wara"),
            keywords: &["Ife Wara", "gílásì", "mu", "mílíkì"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("一杯奶"),
            keywords: &["一杯奶", "奶", "杯", "飲品"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("一杯奶"),
            keywords: &["一杯奶", "奶", "杯", "饮品"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("一杯奶"),
            keywords: &["一杯奶", "奶", "杯"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("一杯牛奶"),
            keywords: &["一杯牛奶", "杯", "牛奶", "飲料"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["一杯牛奶", "牛奶"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ingilazi yobisi"),
            keywords: &["ingilazi", "ingilazi yobisi", "phuza", "ubisi"],
        },
    ],
};
#[doc = "☕"]
pub const HOT_BEVERAGE: crate::Emoji = crate::Emoji {
    glyph: "☕",
    codepoint: "2615",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "hot beverage",
    group: "Food & Drink",
    subgroup: "drink",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("warm drankie"),
            keywords: &[
                "drankie", "drink", "koffie", "koppie", "stoom", "tee", "warm",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሚጠጣ ትኩስ ነገር"),
            keywords: &["ማጥለል", "ሻይ", "ቡና", "ትኩስ", "የሚጠጣ ትኩስ ነገር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مشروب ساخن"),
            keywords: &["بخار", "ساخن", "شاي", "شراب", "قهوة", "مشروب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("গৰম প\u{9be}নীয\u{9bc}"),
            keywords: &["কফি", "গৰম", "চ\u{9be}হ", "প\u{9be}নীয\u{9bc}", "ভ\u{9be}প"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("isti içki"),
            keywords: &["buxarlanan", "isti", "içki", "içmək", "kofe", "çay"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("гарачы напой"),
            keywords: &["гарачы", "гарбата", "кава", "напой", "чай"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Топла напитка"),
            keywords: &[
                "Топла напитка",
                "кафе",
                "напитка",
                "топла напитка",
                "топъл",
                "чай",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("গরম প\u{9be}নীয\u{9bc}"),
            keywords: &[
                "কফি",
                "গরম",
                "চ\u{9be}",
                "প\u{9be}ন কর\u{9be}",
                "প\u{9be}নীয\u{9bc}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("evaj tomm"),
            keywords: &["evaj", "kafe", "te", "tomm"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("topli napitak"),
            keywords: &["kafa", "napitak", "para", "topli napitak", "toplo", "čaj"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("beguda calenta"),
            keywords: &["beguda", "cafè", "calenta", "te", "xocolata calenta"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏗᏞᎩ ᎠᏗᏔᏍᏗ"),
            keywords: &["ᎠᏔᎶᎴᎬ", "ᎠᏗᏔᏍᏗ", "ᎤᎦᎶᎦ", "ᎤᏗᏞᎩ", "ᎧᏫ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("teplý nápoj"),
            keywords: &[
                "horký",
                "kouřící",
                "káva",
                "nápoj",
                "pití",
                "pára",
                "teplý nápoj",
                "čaj",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("diod boeth"),
            keywords: &["coffi", "diod", "diod boeth", "te", "twym"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("varm drik"),
            keywords: &["dampende", "drik", "drikkevare", "kaffe", "te", "varm"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Heißgetränk"),
            keywords: &[
                "Getränk",
                "Heißgetränk",
                "Kaffee",
                "Tee",
                "dampfend",
                "heiß",
                "trinken",
            ],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Heissgetränk"),
            keywords: &[
                "Getränk",
                "Heissgetränk",
                "Kaffee",
                "Tee",
                "dampfend",
                "heiss",
                "trinken",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ζεστό ρόφημα"),
            keywords: &["αχνιστό", "ζεστό", "καφές", "πίνω", "ρόφημα", "τσάι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("hot beverage"),
            keywords: &["beverage", "coffee", "drink", "hot", "steaming", "tea"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bebida caliente"),
            keywords: &["bebida", "café", "caliente", "té"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kuum jook"),
            keywords: &["jook", "kohv", "kuum", "tee"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("edari beroa"),
            keywords: &["bero", "edari", "edari beroa", "kafe", "ke", "te"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نوشیدنی گرم"),
            keywords: &[
                "بخار",
                "داغ",
                "قهوه",
                "نوشیدن",
                "نوشیدنی",
                "نوشیدنی گرم",
                "چای",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kuuma juoma"),
            keywords: &["höyryävä", "juoda", "juoma", "kahvi", "kuuma", "tee"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mainit na inumin"),
            keywords: &[
                "inumin",
                "kape",
                "mainit",
                "mainit na inumin",
                "tasa",
                "tsaa",
                "umuusok",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("heitur drykkur"),
            keywords: &["drykkur", "heitur drykkur", "kaffi", "te"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("boisson chaude"),
            keywords: &["boisson", "boisson chaude"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["boisson chaude", "café", "thé"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("deoch the"),
            keywords: &["ag galú", "caife", "deoch", "deoch the", "tae", "te", "ól"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("deoch theth"),
            keywords: &[
                "ceò",
                "cofaidh",
                "deoch",
                "deoch theth",
                "teatha",
                "teth",
                "tì",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("café"),
            keywords: &["bar", "bebida", "café", "quente"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ગરમ પીણ\u{ac1}\u{a82}"),
            keywords: &[
                "ઉકળત\u{ac1}\u{a82}",
                "કૉફી",
                "ગરમ",
                "ગરમ પીણ\u{ac1}\u{a82}",
                "ચા",
                "પ\u{ac7}ય",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("shayi mai zarfi"),
            keywords: &[
                "kofi",
                "mai tururi",
                "sha",
                "shayi",
                "shayi mai zarfi",
                "zafi",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("משקה חם"),
            keywords: &["חם", "משקה", "ספל", "קפה", "תה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("कॉफ\u{93c}ी, भाप वाला गर\u{94d}म प\u{947}य"),
            keywords: &[
                "कॉफ\u{93c}ी",
                "कॉफ\u{93c}ी, भाप वाला गर\u{94d}म प\u{947}य",
                "गर\u{94d}म प\u{947}य",
                "भाप वाला गर\u{94d}म प\u{947}य",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("vrući napitak"),
            keywords: &["kava", "napitak", "vruće", "vrući napitak", "čaj"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("forró ital"),
            keywords: &["forró", "gőzölgő", "ital", "kávé", "tea"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տաք ըմպելիք"),
            keywords: &["ըմպելիք", "թեյ", "խմել", "սուրճ", "տաք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("minuman hangat"),
            keywords: &[
                "kopi",
                "mengepul",
                "minuman",
                "minuman hangat",
                "panas",
                "teh",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihe ọṅụṅụ dị ọkụ"),
            keywords: &[
                "ihe ọṅụṅụ",
                "ihe ọṅụṅụ dị ọkụ",
                "kọfị",
                "na-agbọ agbọ",
                "tii",
                "ṅụọ",
                "ọkụ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("heitur drykkur"),
            keywords: &[
                "drykkur",
                "heitt",
                "heitur drykkur",
                "kaffi",
                "rjúkandi",
                "te",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("bevanda calda"),
            keywords: &["bevanda", "bevanda calda", "caffè", "fumante", "tè caldo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("温かい飲み物"),
            keywords: &[
                "コーヒー",
                "ホットドリンク",
                "温かい飲み物",
                "紅茶",
                "飲み物",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wedang panas"),
            keywords: &["kemepul", "kopi", "panas", "teh", "unjukan", "wedang"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ცხელი სასმელი"),
            keywords: &[
                "დალევა",
                "დასალევი",
                "ორთქლი",
                "სასმელი",
                "სმა",
                "ყავა",
                "ჩაი",
                "ცხელი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ыстық сусын"),
            keywords: &["бу шығып тұр", "кофе", "сусын", "шәй", "ыстық", "ішімдік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("varm drik"),
            keywords: &["dampende", "drik", "drikkevare", "kaffe", "te", "varm"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ភេសជ\u{17d2}ជៈក\u{17d2}តៅ"),
            keywords: &[
                "កាហ\u{17d2}វេ",
                "ក\u{17d2}ដៅ",
                "តែ",
                "ផ\u{17b9}ក",
                "ភេសជ\u{17d2}ជៈ",
                "ភេសជ\u{17d2}ជៈក\u{17d2}តៅ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{cbf}ಸ\u{cbf} ಪಾನೀಯ"),
            keywords: &["ಕಾಫ\u{cbf}", "ಪಾನೀಯ", "ಬ\u{cbf}ಸ\u{cbf} ಪಾನೀಯ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("뜨거운 음료"),
            keywords: &["뜨거운 음료", "음료", "차", "커피"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मादक प\u{947}या\u{902}"),
            keywords: &[
                "उष\u{94d}ण",
                "कॉफी",
                "च\u{94d}या",
                "पिण\u{947}\u{902}",
                "प\u{947}या\u{902}",
                "मादक प\u{947}या\u{902}",
                "वाफाळ",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ысык суусундук"),
            keywords: &["бууланган", "ич", "кофе", "суусундук", "чай", "ысык"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("waarmt Gedrénks"),
            keywords: &[
                "Gedrénks",
                "Kaffi",
                "Téi",
                "drénken",
                "dämpend",
                "waarm",
                "waarmt Gedrénks",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຄ\u{eb7}\u{ec8}ອງດ\u{eb7}\u{ec8}ມຮ\u{ec9}ອນ"),
            keywords: &[
                "ຊາ",
                "ຮ\u{ec9}ອນ",
                "ເຄ\u{eb7}\u{ec8}ອງດ\u{eb7}\u{ec8}ມ",
                "ເຄ\u{eb7}\u{ec8}ອງດ\u{eb7}\u{ec8}ມຮ\u{ec9}ອນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("karštas gėrimas"),
            keywords: &[
                "arbata",
                "garuoja",
                "gerti",
                "gėrimas",
                "karšta",
                "karštas gėrimas",
                "kava",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("karsts dzēriens"),
            keywords: &["dzert", "dzēriens", "kafija", "karsts", "tēja"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("unu wera"),
            keywords: &["mamaoa", "puruni", "reka wera", "tī", "unu wera"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("топол напиток"),
            keywords: &["кафе", "напиток", "пијалак", "топол напиток", "чај"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d3e}പ\u{d4d}പി"),
            keywords: &[
                "ക\u{d3e}പ\u{d4d}പി",
                "ച\u{d3e}യ",
                "ച\u{d42}ട\u{d41}ക\u{d3e}പ\u{d4d}പി",
                "ച\u{d42}ട\u{d41}ച\u{d3e}യ",
                "ച\u{d42}ട\u{d41}ള\u{d4d}ള പ\u{d3e}നീയം",
                "ച\u{d42}ട\u{d4d} പ\u{d3e}നീയം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("халуун уух зүйл"),
            keywords: &["зүйл", "уух", "халуун"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("गरम प\u{947}य"),
            keywords: &["कॉफी", "गरम", "चहा", "प\u{947}य", "वाफाळल\u{947}ला"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("minuman panas"),
            keywords: &["berasap", "kopi", "minum", "minuman", "panas", "teh"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("xarba sħuna"),
            keywords: &["fwar", "kafè", "sħun", "te", "xarba", "xarba sħuna", "xorb"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("သောက\u{103a}စရာ အပ\u{1030}"),
            keywords: &[
                "ကော\u{103a}ဖ\u{102e}",
                "လက\u{103a}ဖက\u{103a}ရည\u{103a}",
                "သောက\u{103a}စရာ",
                "အင\u{103d}ေ\u{1037}ထ\u{103d}က\u{103a}",
                "အပ\u{1030}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("varm drikke"),
            keywords: &["drikke", "kaffe", "rykende", "te", "varm"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("तातो प\u{947}य पदार\u{94d}थ"),
            keywords: &[
                "कफी",
                "चिया",
                "तात\u{947}को",
                "तातो",
                "तातो प\u{947}य पदार\u{94d}थ",
                "ब\u{947}भर\u{947}ज",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("warme drank"),
            keywords: &[
                "drankje",
                "drinken",
                "koffie",
                "stomend",
                "thee",
                "warm",
                "warme drank",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("varm drikke"),
            keywords: &["drikke", "kaffi", "rykande", "te", "varm"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଗରମ ସ\u{b41}ସ\u{b4d}ୱ\u{b3e}ଦ\u{b41} ପ\u{b3e}ନୀୟ"),
            keywords: &[
                "କଫ\u{b3f}",
                "ଗରମ",
                "ଗରମ ସ\u{b41}ସ\u{b4d}ୱ\u{b3e}ଦ\u{b41} ପ\u{b3e}ନୀୟ",
                "ଚ\u{b3e}",
                "ପ\u{b3e}ନୀୟ",
                "ବ\u{b3e}ଷ\u{b4d}ପ",
                "ସ\u{b41}ସ\u{b4d}ୱ\u{b3e}ଦ\u{b41} ପ\u{b3e}ନୀୟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪੀਣ ਵਾਲੀਆ\u{a02} ਗਰਮ ਚੀਜ\u{a3c}ਾ\u{a02}"),
            keywords: &["ਕਾਫੀ", "ਚਾਹ", "ਪੀਣ ਵਾਲੀਆ\u{a02} ਗਰਮ ਚੀਜ\u{a3c}ਾ\u{a02}"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("گرم مشروب"),
            keywords: &[
                "بھاپ نکلدی",
                "تتا",
                "شربت",
                "مشروب",
                "چاء",
                "کافی",
                "گرم مشروب",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Drink Wé Dé Họt"),
            keywords: &[
                "Bẹ\u{301}vẹ\u{301}rij: Éní Kaín Drink Wé Nọ\u{301} Bi Wọtá",
                "Drink",
                "Drink Wé Dé Họt",
                "Họt",
                "Họ\u{301}t Wẹ\u{301}l Wẹl",
                "Kọfí",
                "Tii",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("gorący napój"),
            keywords: &[
                "gorąca",
                "gorący napój",
                "herbata",
                "kawa",
                "napój",
                "parująca",
                "picie",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ګرم څښاک"),
            keywords: &["څښاک، کافي، څکل، تود، جوشېدونکي، چاي", "ګرم څښاک"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("café"),
            keywords: &["cafezinho", "café", "chá"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("bebida quente"),
            keywords: &["beber", "bebida", "café", "chá", "quente", "vapor"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("qʼuñi upyana"),
            keywords: &["cafe", "qʼuñi upyana", "q’uñi", "te", "upyana", "wapsi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("băutură fierbinte"),
            keywords: &["băutură", "cafea", "ceai", "ceașcă", "fierbinte"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-049"),
            keywords: &["E10-049"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("горячий напиток"),
            keywords: &["горячий", "кофе", "напиток", "пар", "чай"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikinyobwa gishyushye"),
            keywords: &[
                "gishyshye cyane",
                "gishyushye",
                "ibinyobwa",
                "icyayi",
                "ikawa",
                "ikinyobwa gishyushye",
                "kunywa",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("گرم مشروب"),
            keywords: &["مشروب، ڪافي، پيئڻ، گرم، ٻاڦ، چانهن", "گرم مشروب"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("උණ\u{dd4}\u{dd4} ප\u{dcf}නය"),
            keywords: &[
                "උණ\u{dd4}",
                "උණ\u{dd4}\u{dd4} ප\u{dcf}නය",
                "කෝප\u{dd2}",
                "තේ",
                "ප\u{dcf}නය ක\u{dd2}ර\u{dd3}ම",
                "බ\u{dd3}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("horúci nápoj"),
            keywords: &[
                "drink",
                "horúce",
                "horúci nápoj",
                "káva",
                "nápoj",
                "para",
                "čaj",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vroč napitek"),
            keywords: &[
                "kava",
                "napitek",
                "piti",
                "vrelo",
                "vroč napitek",
                "vroče",
                "čaj",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("cabitaan kulul"),
            keywords: &[
                "bun",
                "cab",
                "cabbitaan",
                "cabitaan kulul",
                "kulul",
                "shah",
                "uumiyaynta",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("pije e nxehtë"),
            keywords: &["e nxehtë", "kafe", "pije e nxehtë", "çaj"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("топли напитак"),
            keywords: &["врућe", "кaфa", "нaпитaк", "топли напитак", "чaj"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("topli napitak"),
            keywords: &["kafa", "napitak", "topli napitak", "vruće", "čaj"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("varm dryck"),
            keywords: &["dryck", "kaffe", "te", "varm", "ångande"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kinywaji moto"),
            keywords: &["chai", "kahawa", "kinywaji", "moto"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சூட\u{bbe}ன ப\u{bbe}னம\u{bcd}"),
            keywords: &[
                "சூட\u{bbe}ன க\u{bbe}பி",
                "சூட\u{bbe}ன ப\u{bbe}னம\u{bcd}",
                "ட\u{bc0}",
                "ப\u{bbe}னம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వ\u{c47}డ\u{c3f} ప\u{c3e}న\u{c40}యం"),
            keywords: &[
                "క\u{c3e}ఫ\u{c40}",
                "ట\u{c40}",
                "ప\u{c3e}న\u{c40}యం",
                "వ\u{c47}డ\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("нӯшокии гарм"),
            keywords: &[
                "гарм",
                "нӯшидан",
                "нӯшокии гарм",
                "нӯшокӣ",
                "чой",
                "қаҳва",
                "ҷӯшондан",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เคร\u{e37}\u{e48}องด\u{e37}\u{e48}มร\u{e49}อน"),
            keywords: &[
                "กาแฟ",
                "ชา",
                "ร\u{e49}อน",
                "เคร\u{e37}\u{e48}องด\u{e37}\u{e48}ม",
                "เคร\u{e37}\u{e48}องด\u{e37}\u{e48}มร\u{e49}อน",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gyzgyn içgi"),
            keywords: &["bugarýan", "gyzgyn", "içgi", "içmek", "kofe", "çaý"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("inu māfana"),
            keywords: &["inu māfana"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sıcak içecek"),
            keywords: &["dumanı tüten", "içecek", "kahve", "sıcak", "çay"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئىسسىق ئىچىملىك"),
            keywords: &[
                "ئىسسىق ئىچىملىك",
                "ئىچكۈ",
                "ئىچىملىك",
                "قىزىق",
                "قەھۋە",
                "چاي",
                "ھور",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("гарячий напій"),
            keywords: &["гарячий", "кава", "напій", "паруючий", "пити", "чай"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گرم کافی"),
            keywords: &["چائے", "کافی", "گرم"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("issiq ichimlik"),
            keywords: &["bug‘lanib turgan", "choy", "ichimlik", "issiq", "kofe"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đồ uống nóng"),
            keywords: &[
                "chưng",
                "cà phê",
                "nóng",
                "trà",
                "uống",
                "đồ uống",
                "đồ uống nóng",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("naan gu tank"),
            keywords: &["attaaya", "kafe", "naan", "naan gu tank", "tàng", "wapër"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isiselo esishushu"),
            keywords: &[
                "eqhumayo",
                "eshushu",
                "ikofu",
                "isiselo",
                "isiselo esishushu",
                "iti",
                "sela",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Tii Gbigbona"),
            keywords: &[
                "Tii Gbigbona",
                "gbígóná",
                "kọfí",
                "mímu",
                "ohun mímu oní kòkó",
                "tíì",
                "yíyọ oru",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("熱飲"),
            keywords: &["咖啡", "熱", "熱飲", "茶", "蒸氣", "飲", "飲品"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("热饮"),
            keywords: &["咖啡", "热", "热饮", "茶", "蒸气", "饮", "饮品"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("热饮"),
            keywords: &["咖啡", "热饮", "茶", "饮料"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("熱飲"),
            keywords: &["咖啡", "熱飲", "茶"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("熱咖啡"),
            keywords: &["熱咖啡", "熱飲", "茶"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isiphuzo esishisayo"),
            keywords: &[
                "ikhofi",
                "intuthu",
                "isiphuzo",
                "isiphuzo esishisayo",
                "itiye",
                "okuphuzwayo",
                "okushisayo",
            ],
        },
    ],
};
#[doc = "🫖"]
pub const TEAPOT: crate::Emoji = crate::Emoji {
    glyph: "🫖",
    codepoint: "1FAD6",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "teapot",
    group: "Food & Drink",
    subgroup: "drink",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("teepot"),
            keywords: &["drink", "pot", "tee", "teepot"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሻይ ስኒ"),
            keywords: &["የሻይ ስኒ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("إبريق شاي"),
            keywords: &["إبريق", "شاي", "مشروب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চ\u{9be}হৰ প\u{9be}ত\u{9cd}ৰ"),
            keywords: &[
                "চ\u{9be}হ",
                "চ\u{9be}হৰ প\u{9be}ত\u{9cd}ৰ",
                "প\u{9be}ত\u{9cd}ৰ",
                "প\u{9be}নীয\u{9bc}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("çaynik"),
            keywords: &["içmək", "kupə", "çay", "çaynik"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чайнік"),
            keywords: &["піць", "чай", "чайнік", "імбрык", "імбрычак"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("чайник"),
            keywords: &["канче", "пия", "чай", "чайник"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("টিপট"),
            keywords: &["চ\u{9be}", "টিপট", "পট", "প\u{9be}নীয\u{9bc}"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("pod-te"),
            keywords: &["evaj", "pod-te", "te", "tomm"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("čajnik"),
            keywords: &["napitak", "topli napitak", "čaj", "čajnik"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("tetera"),
            keywords: &["beguda", "te", "tetera"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎹ ᎠᎪᏙᏗ"),
            keywords: &["ᎠᎹ ᎠᎪᏙᏗ", "ᎠᏗᏔᏍᏗ", "ᎤᎦᎶᎦ", "ᏧᎳᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("čajová konvice"),
            keywords: &[
                "konvice",
                "nápoj",
                "pití",
                "čaj",
                "čajník",
                "čajová konvice",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("tebot"),
            keywords: &["diod", "pot", "te", "tebot"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("tekande"),
            keywords: &["drik", "kande", "te", "tekande", "tepotte"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Teekanne"),
            keywords: &["Kanne", "Tee", "Teekanne", "trinken"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Teekrug"),
            keywords: &["Teekrug"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τσαγιέρα"),
            keywords: &["πίνω", "τσάι", "τσαγιέρα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("teapot"),
            keywords: &["drink", "pot", "tea", "teapot"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("tetera"),
            keywords: &["bebida", "infusión", "tetera", "té"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("tetera"),
            keywords: &["tetera"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("tetera"),
            keywords: &["tetera"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("teekann"),
            keywords: &["jooma", "kann", "tee", "teekann"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("teontzi"),
            keywords: &["edan", "edaria", "ontzia", "tea", "teontzi", "teontzia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قوری"),
            keywords: &["قوری", "قوری\u{650}\u{200c}چای", "نوشیدن", "چای"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("teepannu"),
            keywords: &["juoda", "pannu", "tee", "teepannu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("teapot"),
            keywords: &["inumin", "teapot", "tsaa"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("tekanna"),
            keywords: &["drykkur", "te", "tekanna"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("théière"),
            keywords: &["boisson", "thé", "théière"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("théière"),
            keywords: &["boisson", "thé", "théière"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("taephota"),
            keywords: &["deoch", "pota", "tae", "taephota"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("poit-tì"),
            keywords: &["poit", "poit-teatha", "poit-tì", "teatha", "tì", "òl"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("teteira"),
            keywords: &["bebida", "infusión", "teteira", "té"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચાની ઝારી"),
            keywords: &["કીટલી", "ચા", "ચાની ઝારી", "ઝારી", "પીવ\u{ac1}\u{a82}"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קנקן תה"),
            keywords: &["משקה חם", "קנקן", "תה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चाय की क\u{947}तली"),
            keywords: &[
                "चाय",
                "चाय की क\u{947}तली",
                "पीन\u{947} की चीज\u{93c}",
                "बर\u{94d}तन",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("čajnik"),
            keywords: &["piće", "posuda", "čaj", "čajnik"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("teáskanna"),
            keywords: &["bögre", "ital", "tea", "teáskanna"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("թեյնիկ"),
            keywords: &["ըմպելիք", "թեյ", "թեյնիկ", "խմիչք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("teko"),
            keywords: &["minum", "poci", "teh", "teko"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("tekanna"),
            keywords: &["drykkur", "kanna", "te", "tekanna"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("teiera"),
            keywords: &["bere", "teiera", "tè"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ティーポット"),
            keywords: &["お茶", "ティーポット", "急須", "茶器", "飲み物"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ceret"),
            keywords: &["adah", "ceret", "teh", "unjukan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჩაიდანი"),
            keywords: &["მადუღარა", "სასმელი", "ჩაი", "ჩაიდანი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шәйнек"),
            keywords: &["шай", "шәйнек", "ішу"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17c9}ាន\u{17cb}តែ"),
            keywords: &[
                "តែ",
                "ទ\u{17b9}កតែ",
                "ប\u{17c9}ាន\u{17cb}",
                "ប\u{17c9}ាន\u{17cb}តែ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಟೀಪಾಟ\u{ccd}"),
            keywords: &["ಚಹಾ", "ಟೀಪಾಟ\u{ccd}", "ಪಾಟ\u{ccd}\u{200c}", "ಪಾನೀಯ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("찻주전자"),
            keywords: &["냄비", "음료", "차", "찻주전자"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("च\u{94d}याच\u{947}\u{902} आयदन"),
            keywords: &[
                "आयदन",
                "च\u{94d}या",
                "च\u{94d}याच\u{947}\u{902} आयदन",
                "पिण\u{947}\u{902}",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чайнек"),
            keywords: &["чайнек"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ການ\u{ec9}ຳຊາ"),
            keywords: &[
                "ກາ",
                "ການ\u{ec9}ຳຊາ",
                "ການ\u{ecd}\u{ec9}າຊາ",
                "ດ\u{eb7}\u{ec8}ມ",
                "ນ\u{ecd}\u{ec9}າຊາ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("arbatinukas"),
            keywords: &["arbata", "arbatinukas", "gėrimas", "puodas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("tējkanna"),
            keywords: &["dzēriens", "kanna", "tēja", "tējkanna"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("чајник"),
            keywords: &["пијалак", "чај", "чајник"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ടീപോട\u{d4d}ട\u{d4d}"),
            keywords: &[
                "ച\u{d3e}യ",
                "ടീപോട\u{d4d}ട\u{d4d}",
                "പ\u{d3e}നീയം",
                "പോട\u{d4d}ട\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цайны гүц"),
            keywords: &["гүц", "уух юм", "цай", "цайны гүц"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चहाच\u{947} भा\u{902}ड\u{947}"),
            keywords: &["चहा", "चहाच\u{947} भा\u{902}ड\u{947}", "भा\u{902}ड\u{947}"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("teko teh"),
            keywords: &["minum", "teh", "teko"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ခရား"),
            keywords: &[
                "ကရား",
                "ခရား",
                "လက\u{103a}ဖက\u{103a}ရည\u{103a} ကရား",
                "သောက\u{103a}",
                "အ\u{102d}\u{102f}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("tekanne"),
            keywords: &["drikke", "kanne", "te", "tekanne"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("चियाको भा\u{901}डो"),
            keywords: &["चिया", "चियाको भा\u{901}डो", "प\u{947}य", "भा\u{901}डो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("theepot"),
            keywords: &["drinken", "pot", "thee", "theepot"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("tekanne"),
            keywords: &["drikke", "kanne", "te", "tekanne"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଚ\u{b3e}’କେଟ\u{b4d}ଲୀ"),
            keywords: &[
                "ଚ\u{b3e}",
                "ଚ\u{b3e}’କେଟ\u{b4d}ଲୀ",
                "ପ\u{b3e}ତ\u{b4d}ର",
                "ପ\u{b3f}\u{200d}ଇବ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a47}ਤਲੀ"),
            keywords: &["ਕ\u{a47}ਤਲੀ", "ਚਾਹ", "ਪੀਣਾ", "ਬਰਤਨ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Típọt"),
            keywords: &["Drink", "Pọt", "Tii", "Típọt"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("czajniczek"),
            keywords: &["czajniczek", "dzbanek na herbatę", "herbata", "imbryk"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د چای لوښی"),
            keywords: &["د چای لوښی", "لوښی", "څښاک", "چای"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bule"),
            keywords: &["bebida", "bule", "chaleira", "chá"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("te qiru"),
            keywords: &["qiru", "te", "upyana"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ceainic"),
            keywords: &["băutură", "ceai", "ceainic"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-044"),
            keywords: &["E13-044"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("чайник"),
            keywords: &["заварка", "заварочный чайник", "напиток", "чай", "чайник"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("چانهه جو برتن"),
            keywords: &[
                "پرتن",
                "پيئڻ واري شئي",
                "چانهه جو برتن",
                "چانهہ",
                "چانهہ وارو برتن",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("තේ පෝච\u{dca}ච\u{dd2}ය"),
            keywords: &["තේ", "තේ පෝච\u{dca}ච\u{dd2}ය", "බඳ\u{dd4}න", "බොන\u{dca}න"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("čajová kanvica"),
            keywords: &["kanvica", "čaj", "čajník", "čajová kanvica"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("čajnik"),
            keywords: &["pijača", "vrč", "čaj", "čajnik"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kirli"),
            keywords: &["cab", "jalmad", "kirli", "shaah"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("çajnik"),
            keywords: &["gotë", "pi", "çaj", "çajnik"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("чајник"),
            keywords: &["пиће", "чај", "чајник"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("čajnik"),
            keywords: &["piće", "čaj", "čajnik"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tekanna"),
            keywords: &["dryck", "kanna", "te", "tekanna"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("birika la chai"),
            keywords: &["birika", "birika la chai", "chai", "kinywaji"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("தேந\u{bc0}ர\u{bcd}க\u{bcd} குவளை"),
            keywords: &[
                "குவளை",
                "தேந\u{bc0}ர\u{bcd}",
                "தேந\u{bc0}ர\u{bcd}க\u{bcd} குவளை",
                "ப\u{bbe}னம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ట\u{c40} ప\u{c3e}ట\u{c4d}"),
            keywords: &["ట\u{c40}", "ప\u{c3e}ట\u{c4d}", "ప\u{c3e}న\u{c40}యం"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("กาน\u{e49}ำชา"),
            keywords: &["กา", "กาน\u{e49}ำชา", "ชา", "ด\u{e37}\u{e48}ม"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çäýnek"),
            keywords: &["içmek", "piti", "çaý", "çäýnek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tīpota"),
            keywords: &["tīpota"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("demlik"),
            keywords: &["demlik", "içecek", "çay", "çaydanlık"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("чайник"),
            keywords: &["заварник", "напій", "чай", "чайник"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چائے کا برتن"),
            keywords: &["برتن", "پینا", "چائے", "چائے کا برتن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("choynak"),
            keywords: &["choy", "choynak", "ichimlik"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ấm trà"),
            keywords: &["nồi", "trà", "uống", "ấm trà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("茶壺"),
            keywords: &["壺", "茶", "茶壺", "飲"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("茶壶"),
            keywords: &["壶", "茶", "茶壶", "饮"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("茶壶"),
            keywords: &["壶", "茶", "茶壶"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("茶壺"),
            keywords: &["壺", "茶", "茶壺", "飲品"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ithibhothi"),
            keywords: &["ibhodwe", "ithibhothi", "itiye", "phuza"],
        },
    ],
};
#[doc = "🍵"]
pub const TEACUP_WITHOUT_HANDLE: crate::Emoji = crate::Emoji {
    glyph: "🍵",
    codepoint: "1F375",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "teacup without handle",
    group: "Food & Drink",
    subgroup: "drink",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("teekoppie sonder handvatsel"),
            keywords: &[
                "drankie",
                "drink",
                "koppie",
                "tee",
                "teekoppie",
                "teekoppie sonder handvatsel",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ማንጠልጠያ የሌለው የሻይ ስኒ"),
            keywords: &["ማንጠልጠያ የሌለው የሻይ ስኒ", "ስኒ", "ሻይ", "የሚጠጣ ነገር", "የሻይ ስኒ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}فنجان شاي بدون مقبض"),
            keywords: &["شاي", "شراب", "\u{202b}فنجان شاي بدون مقبض"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হেণ\u{9cd}ডেল নথক\u{9be} চ\u{9be}হৰ পিয\u{9bc}ল\u{9be}"),
            keywords: &[
                "ক\u{9be}প",
                "চ\u{9be}হ",
                "চ\u{9be}হৰ পিয\u{9bc}ল\u{9be}",
                "প\u{9be}নীয\u{9bc}",
                "হেণ\u{9cd}ডেল নথক\u{9be} চ\u{9be}হৰ পিয\u{9bc}ল\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qulpsuz çay fincanı"),
            keywords: &["fincan", "içki", "içmək", "qulpsuz çay fincanı", "çay"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кубачак чаю без ручкі"),
            keywords: &[
                "гарбата",
                "кубачак",
                "кубачак чаю без ручкі",
                "напой",
                "піяла",
                "чай",
                "шклянка",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Чаена чаша без дръжка"),
            keywords: &["Чаена чаша без дръжка", "напитка", "чай", "чаша"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some(
                "হ\u{9cd}য\u{9be}ন\u{9cd}ডেল ছ\u{9be}ড\u{9bc}\u{9be}ই চ\u{9be}য\u{9bc}ের ক\u{9be}প",
            ),
            keywords: &[
                "ক\u{9be}প",
                "চ\u{9be}",
                "চ\u{9be}য\u{9bc}ের পেয\u{9bc}\u{9be}ল\u{9be}",
                "প\u{9be}ন কর\u{9be}",
                "প\u{9be}নীয\u{9bc}",
                "হ\u{9cd}য\u{9be}ন\u{9cd}ডেল ছ\u{9be}ড\u{9bc}\u{9be}ই চ\u{9be}য\u{9bc}ের ক\u{9be}প",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("tasenn"),
            keywords: &["evaj", "tasenn", "te", "tomm"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("šolja za čaj bez drške"),
            keywords: &[
                "napitak",
                "čaj",
                "šolja",
                "šolja za čaj",
                "šolja za čaj bez drške",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("tassa de te"),
            keywords: &["tassa", "tassa de te", "te"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎵᏍᏈᏘ ᎦᏂᏴᏙᏗ ᏄᏍᏛᎾ"),
            keywords: &["ᎠᏗᏔᏍᎦ", "ᎠᏗᏔᏍᏗ", "ᎤᎦᎶᎦ", "ᎤᎵᏍᏈᏘ", "ᎤᎵᏍᏈᏘ ᎦᏂᏴᏙᏗ ᏄᏍᏛᎾ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("šálek bez ouška"),
            keywords: &["nápoj", "pití", "čaj", "šálek", "šálek bez ouška"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cwpan te heb ddolen"),
            keywords: &["cwpan", "cwpan te heb ddolen", "diod", "te"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("tekrus"),
            keywords: &["kop", "te", "tekrus", "varm te"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Teetasse ohne Henkel"),
            keywords: &["Tee", "Teetasse", "Teetasse ohne Henkel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κούπα τσαγιού χωρίς χερούλι"),
            keywords: &[
                "κούπα",
                "κούπα τσαγιού",
                "κούπα τσαγιού χωρίς χερούλι",
                "πίνω",
                "ρόφημα",
                "τσάι",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("teacup without handle"),
            keywords: &[
                "beverage",
                "cup",
                "drink",
                "tea",
                "teacup",
                "teacup without handle",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("tazón de té"),
            keywords: &["bebida", "taza", "tazón de té", "té"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["bebida", "taza", "taza de té", "tazón de té", "té"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kõrvata teetass"),
            keywords: &["jook", "kõrvata teetass", "tass", "tee"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("giderrik gabeko kikara"),
            keywords: &["edari", "giderrik gabeko kikara", "kikara", "kopa", "te"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("فنجان چای بدون دسته"),
            keywords: &[
                "فنجان چای",
                "فنجان چای بدون دسته",
                "لیوان",
                "نوشیدن",
                "نوشیدنی",
                "چای",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("korvaton teekuppi"),
            keywords: &[
                "juoda",
                "juoma",
                "korvaton teekuppi",
                "kuppi",
                "tee",
                "teekuppi",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tasa ng tsaa na walang hawakan"),
            keywords: &[
                "inumin",
                "tasa",
                "tasa na walang hawakan",
                "tasa ng tsaa na walang hawakan",
                "teacup",
                "tsaa",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("koppur uttan handtak"),
            keywords: &["drykkur", "grønt", "koppur", "koppur uttan handtak", "te"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("tasse"),
            keywords: &["tasse", "thé"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["boisson", "tasse", "thé"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cupán gan chluas"),
            keywords: &["caife", "cupán", "cupán gan chluas", "deoch", "tae"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cupa-tì gun chluas"),
            keywords: &[
                "cupa",
                "cupa-tì gun chluas",
                "cupan",
                "deoch",
                "teatha",
                "tì",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("té"),
            keywords: &["bar", "bebida", "quente", "té"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("દા\u{a82}ડી વગરનો ચાનો કપ"),
            keywords: &[
                "ચા",
                "ચા માટ\u{ac7}નો કપ",
                "ચાનો કપ",
                "દા\u{a82}ડી વગરનો ચાનો કપ",
                "પીણ\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kofin shayi mara mariƙi"),
            keywords: &[
                "kofi",
                "kofin shayi",
                "kofin shayi mara mariƙi",
                "sha",
                "shayi",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ספל תה בלי ידית"),
            keywords: &["חם", "משקה", "ספל", "ספל תה בלי ידית", "תה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चाय का प\u{94d}याला, चाय"),
            keywords: &[
                "चाय",
                "चाय का प\u{94d}याला",
                "चाय का प\u{94d}याला, चाय",
                "प\u{947}य",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("šalica za čaj bez ručke"),
            keywords: &[
                "napitak",
                "piti",
                "čaj",
                "šalica",
                "šalica za čaj bez ručke",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fül nélküli teáscsésze"),
            keywords: &["fül nélküli teáscsésze", "ital", "tea", "teáscsésze"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("թեյի բաժակ առանց բռնակի"),
            keywords: &[
                "բաժակ",
                "ըմպելիք",
                "թեյ",
                "թեյի բաժակ",
                "թեյի բաժակ առանց բռնակի",
                "խմել",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("cangkir teh tanpa gagang"),
            keywords: &["cangkir", "cangkir teh tanpa gagang", "minuman", "teh"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("iko na-enweghị aka"),
            keywords: &[
                "ihe ọṅụṅụ",
                "iko",
                "iko na-enweghị aka",
                "ikotii",
                "tii",
                "ṅụọ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("tebolli"),
            keywords: &["bolli", "drykkur", "te", "tebolli"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("tazza da tè senza manico"),
            keywords: &[
                "bere",
                "tazza",
                "tazza da tè senza manico",
                "tazza di tè",
                "tè",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("湯飲み"),
            keywords: &["お茶", "湯飲み", "緑茶", "飲み物"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("cangkir teh tanpa kuping"),
            keywords: &[
                "cangkir",
                "cangkir teh tanpa kuping",
                "teh",
                "unjukan",
                "wedang",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჩაის ფინჯანი სახელურის გარეშე"),
            keywords: &[
                "დალევა",
                "დასალევი",
                "სასმელი",
                "სმა",
                "ფინჯანი",
                "ჩაი",
                "ჩაის ფინჯანი სახელურის გარეშე",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тұтқасы жоқ шынаяқ"),
            keywords: &[
                "айшанақ",
                "сусын",
                "тұтқасы жоқ шынаяқ",
                "шынаяқ",
                "шәй",
                "ішімдік",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("tekop"),
            keywords: &["kop", "te", "tekop", "varm te"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ពែងតែ"),
            keywords: &["តែ", "ពែង", "ពែងតែ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹ\u{ccd}ಯಾಂಡ\u{ccd}\u{200c}ಲ\u{ccd} ಇಲ\u{ccd}ಲದ ಚಹಾ ಕಪ\u{ccd}"),
            keywords: &[
                "ಚಹಾಕಪ\u{ccd}",
                "ಚಹಾದ ಕಪ\u{ccd}",
                "ಹ\u{ccd}ಯಾಂಡ\u{ccd}\u{200c}ಲ\u{ccd} ಇಲ\u{ccd}ಲದ ಚಹಾ ಕಪ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("차"),
            keywords: &["차", "찻잔", "찻집"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ह\u{901}डल नाशिल\u{94d}ल\u{947}\u{902} च\u{94d}याच\u{947}\u{902} कप"),
            keywords: &[
                "कप",
                "च\u{94d}या",
                "च\u{94d}याच\u{947}\u{902} कप",
                "पिण\u{947}\u{902}",
                "प\u{947}य",
                "ह\u{901}डल नाशिल\u{94d}ल\u{947}\u{902} च\u{94d}याच\u{947}\u{902} कप",
                "ह\u{902}\u{901}डल नाशिल\u{94d}ल\u{947}\u{902}\u{902} च\u{94d}याच\u{947}\u{902} कप",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чай чыны"),
            keywords: &["ич", "суусундук", "чай", "чыны"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Taass ouni Hänk"),
            keywords: &[
                "Gedrénks",
                "Taass",
                "Taass ouni Hänk",
                "Téi",
                "Téitaass",
                "drénken",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຈອກຊາທ\u{eb5}\u{ec8}ບ\u{ecd}\u{ec8}ມ\u{eb5}ງ\u{ec9}ວງຈ\u{eb1}ບ"),
            keywords: &[
                "ຈອກຊາທ\u{eb5}\u{ec8}ບ\u{ecd}\u{ec8}ມ\u{eb5}ງ\u{ec9}ວງຈ\u{eb1}ບ",
                "ຊາ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("arbatos puodelis be rankenos"),
            keywords: &[
                "arbata",
                "arbatos puodelis",
                "arbatos puodelis be rankenos",
                "gerti",
                "gėrimas",
                "puodelis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("tējas tase bez osiņas"),
            keywords: &["dzert", "dzēriens", "tēja", "tējas tase bez osiņas"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tīkapu kore kakau"),
            keywords: &["kapu", "tī", "tīkapu", "tīkapu kore kakau", "unu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("чаша за чај без рачка"),
            keywords: &[
                "напиток",
                "пијалак",
                "топло",
                "чаша за чај без рачка",
                "чај",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "കൈപ\u{d4d}പിടി ഇല\u{d4d}ല\u{d3e}ത\u{d4d}ത ച\u{d3e}യക\u{d4d}കപ\u{d4d}പ\u{d4d}",
            ),
            keywords: &[
                "കപ\u{d4d}പ\u{d4d}",
                "കൈപ\u{d4d}പിടി ഇല\u{d4d}ല\u{d3e}ത\u{d4d}ത ച\u{d3e}യക\u{d4d}കപ\u{d4d}പ\u{d4d}",
                "കൈപ\u{d4d}പിടിയില\u{d4d}ല\u{d3e}ത\u{d4d}ത കപ\u{d4d}പ\u{d4d}",
                "ച\u{d3e}യ",
                "ച\u{d3e}യക\u{d4d}കപ\u{d4d}പ\u{d4d}",
                "ച\u{d42}ട\u{d41}ച\u{d3e}യ",
                "ഹോട\u{d4d}ടൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бариулгүй цайны аяга"),
            keywords: &["аяга", "бариул", "бариулгүй цайны аяга", "уух", "цай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("म\u{942}ठ नसल\u{947}ला चहाचा कप"),
            keywords: &[
                "कप",
                "चहा",
                "चहाचा कप",
                "प\u{947}य",
                "म\u{942}ठ नसल\u{947}ला चहाचा कप",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("cawan teh tanpa tangkai"),
            keywords: &[
                "cawan",
                "cawan teh tanpa tangkai",
                "minum",
                "minuman",
                "teh",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kikkra tat-te mingħajr manku"),
            keywords: &[
                "kikkra",
                "kikkra tat-te mingħajr manku",
                "tazza",
                "te",
                "xarba",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လက\u{103a}ဖက\u{103a}ရည\u{103a} ပန\u{103a}းကန\u{103a}လ\u{102f}\u{1036}း"),
            keywords: &[
                "ပန\u{103a}းကန\u{103a}လ\u{102f}\u{1036}း",
                "လက\u{103a}က\u{102d}\u{102f}င\u{103a}က\u{102d}\u{102f}င\u{103a}းမပါ လက\u{103a}ဖက\u{103a}ရည\u{103a} ပန\u{103a}းကန\u{103a}လ\u{102f}\u{1036}း",
                "လက\u{103a}ဖက\u{103a}ရည\u{103a}",
                "သောက\u{103a}စရာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("tekopp"),
            keywords: &["drikke", "suppe", "te", "tekopp"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("समात\u{94d}न नमिल\u{94d}न\u{947} चियाको कप"),
            keywords: &[
                "कप",
                "चिया",
                "चियाकप",
                "पिउन\u{947}",
                "ब\u{947}भर\u{947}ज",
                "समात\u{94d}न नमिल\u{94d}न\u{947} चियाको कप",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("theekopje zonder oor"),
            keywords: &[
                "drankje",
                "drinken",
                "kop",
                "thee",
                "theekopje",
                "theekopje zonder oor",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("tekopp"),
            keywords: &["drikke", "suppe", "te", "tekopp"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବେଣ\u{b4d}ଟ ନଥ\u{b3f}ବ\u{b3e} ଚ\u{b3e} କପ\u{b4d}\u{200d}"),
            keywords: &[
                "କପେ ଚ\u{b3e}",
                "ଚ\u{b3e}",
                "ଚ\u{b3e} କପ\u{b4d}\u{200c}",
                "ପ\u{b3e}ନୀୟ",
                "ବେଣ\u{b4d}ଟ ନଥ\u{b3f}ବ\u{b3e} ଚ\u{b3e} କପ\u{b4d}\u{200d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬਿਨਾ\u{a02} ਡ\u{a70}ਡੀ ਵਾਲਾ ਚਾਹ ਦਾ ਪਿਆਲਾ"),
            keywords: &[
                "ਚਾਹ",
                "ਚਾਹ ਦਾ ਪਿਆਲਾ",
                "ਚਾਹ ਪਿਆਲਾ",
                "ਪੀਣਾ",
                "ਬਿਨਾ\u{a02} ਡ\u{a70}ਡੀ ਵਾਲਾ ਚਾਹ ਦਾ ਪਿਆਲਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("موٹھ ت\u{64f}وں بغیر چا آلا کپ"),
            keywords: &[
                "شربت",
                "مشروب",
                "موٹھ ت\u{64f}وں بغیر چا آلا کپ",
                "چاء",
                "چاء دا کپ",
                "کپ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tíkọp Wé Nọ\u{301} Gẹ\u{301}t Hand"),
            keywords: &[
                "Bẹ\u{301}vẹ\u{301}rij: Éní Kaín Drink Wé Nọ\u{301} Bi Wọtá",
                "Drink",
                "Kọp",
                "Tii",
                "Tiíkọp",
                "Tiíkọp Wé Nọ\u{301} Gẹ\u{301}t Hand",
                "Tíkọp Wé Nọ\u{301} Gẹ\u{301}t Hand",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("filiżanka bez uszka"),
            keywords: &["filiżanka", "filiżanka bez uszka", "spodek"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بې لاستي پياله"),
            keywords: &[
                "بې لاستي پياله",
                "څښاک، پياله، څکل، چاي، د چاي پياله، بې لاستي پياله",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("xícara de chá sem alça"),
            keywords: &[
                "bebida",
                "chá",
                "xícara",
                "xícara de chá",
                "xícara de chá sem alça",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("chávena de chá sem asa"),
            keywords: &[
                "beber",
                "bebida",
                "chá",
                "chávena",
                "chávena de chá",
                "chávena de chá sem asa",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("chhapukucha tepaq mana ninriwan"),
            keywords: &["chhapukucha tepaq mana ninriwan", "qiru", "te", "upyana"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ceașcă fără mâner"),
            keywords: &["băutură", "ceai", "ceașcă", "ceașcă fără mâner"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-314"),
            keywords: &["E10-314"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("чашка без ручки"),
            keywords: &[
                "зеленый",
                "чай",
                "чашка",
                "чашка без ручки",
                "чашка зеленого чая",
                "чашка чая",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("agakombe k’icyayi kadafite umukondo"),
            keywords: &[
                "agakombe k’icyayi kadafite umukondo",
                "ibinyobwa",
                "icyayi",
                "igikombe",
                "igikoombe cy’icyayi",
                "kunywa",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بغير ڪڙي جي چانهن جو ڪپ"),
            keywords: &[
                "بغير ڪڙي جي چانهن جو ڪپ",
                "مشروب، ڪپ، پيئڻ، چانهن، چانهن جو ڪپ",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අඬ\u{dd4}ව රහ\u{dd2}ත තේ කෝප\u{dca}පය"),
            keywords: &[
                "අඬ\u{dd4}ව රහ\u{dd2}ත තේ කෝප\u{dca}පය",
                "කෝප\u{dca}පය",
                "තේ",
                "තේ පෝච\u{dca}ච\u{dd2}ය",
                "ප\u{dcf}නය ක\u{dd2}ර\u{dd3}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("čajová šálka"),
            keywords: &["drink", "nápoj", "pohár", "čaj", "čajová šálka", "šálka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("čajna skodelica brez ročaja"),
            keywords: &[
                "napitek",
                "piti",
                "skodelica",
                "skodelica čaja",
                "čaj",
                "čajna skodelica brez ročaja",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("koob shah ah oon sidda lahayn"),
            keywords: &[
                "cab",
                "cabbitaan",
                "koob",
                "koob shah ah oon sidda lahayn",
                "shah",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("filxhan çaji pa bisht"),
            keywords: &["filxhan çaji", "filxhan çaji pa bisht", "pije", "çaj"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("шољица без дршке"),
            keywords: &["нaпитaк", "пити", "чaj", "шоља", "шољица без дршке"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("šoljica bez drške"),
            keywords: &["napitak", "piti", "čaj", "šolja", "šoljica bez drške"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tekopp"),
            keywords: &["te", "tekopp", "varm dryck"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kikombe kisicho na kishikio"),
            keywords: &[
                "chai",
                "kikombe",
                "kikombe cha chai",
                "kikombe kisicho na kishikio",
                "kinywaji",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கைப\u{bcd}பிடி இல\u{bcd}ல\u{bbe}த தேன\u{bc0}ர\u{bcd} கோப\u{bcd}பை"),
            keywords: &[
                "கைப\u{bcd}பிடி இல\u{bcd}ல\u{bbe}த தேன\u{bc0}ர\u{bcd} கோப\u{bcd}பை",
                "ட\u{bc0}",
                "தேன\u{bc0}ர\u{bcd}",
                "தேன\u{bc0}ர\u{bcd}க\u{bcd}கோப\u{bcd}பை",
                "ப\u{bbe}னம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("హ\u{c4d}య\u{c3e}ండ\u{c3f}ల\u{c4d} ల\u{c47}న\u{c3f} ట\u{c40} కప\u{c4d}పు"),
            keywords: &[
                "ట\u{c40} ఉన\u{c4d}న కప\u{c4d}పు",
                "ట\u{c40}కప\u{c4d}పు",
                "ప\u{c3e}న\u{c40}యం",
                "హ\u{c4d}య\u{c3e}ండ\u{c3f}ల\u{c4d} ల\u{c47}న\u{c3f} ట\u{c40} కప\u{c4d}పు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("пиёлаи чой бе даста"),
            keywords: &[
                "нӯшидан",
                "нӯшокӣ",
                "пиёла",
                "пиёлаи чой",
                "пиёлаи чой бе даста",
                "чой",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ถ\u{e49}วยชา"),
            keywords: &["ชา", "ถ\u{e49}วยชา"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("käse"),
            keywords: &["içgi", "içmek", "käse", "çaý", "çaşka"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ipu tī"),
            keywords: &["ipu tī"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("çay fincanı"),
            keywords: &["içecek", "çay", "çay fincanı"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("پىيالە"),
            keywords: &["ئىچكۈ", "ئىچىملىك", "پىيالە", "چاي", "چاي پىيالىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("чайна чашка без вушка"),
            keywords: &["напій", "чай", "чайна чашка без вушка", "чашка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ہینڈل کے بغیر چائے کا کپ"),
            keywords: &["ٹی کپ", "چائے", "کپ", "ہینڈل کے بغیر چائے کا کپ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("piyola"),
            keywords: &["choy", "ichimlik", "issiq ichimlik", "piyola"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tách trà không có quai"),
            keywords: &[
                "cốc",
                "trà",
                "tách trà",
                "tách trà không có quai",
                "uống",
                "đồ uống",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kaasu attaayu bu amul jàppukaay"),
            keywords: &[
                "attaaya",
                "kaas",
                "kaasu attaaya",
                "kaasu attaayu bu amul jàppukaay",
                "naan",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ikomityi engenamqheba"),
            keywords: &[
                "ikomityi",
                "ikomityi engenamqheba",
                "ikomityi yeti",
                "isiselo",
                "iti",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ife Tii laini Ọwọ"),
            keywords: &[
                "Ife Tii laini Ọwọ",
                "ife",
                "mímu",
                "o ohun mímu oní kòkó",
                "tíì",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("無柄嘅茶杯"),
            keywords: &["杯", "無柄嘅茶杯", "茶", "茶杯", "飲", "飲品"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("无柄嘅茶杯"),
            keywords: &["无柄嘅茶杯", "杯", "茶", "茶杯", "饮", "饮品"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("热茶"),
            keywords: &["杯", "没有把手的茶杯", "热茶", "茶", "饮料"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("熱茶"),
            keywords: &["熱茶", "茶"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("冇耳嘅茶杯"),
            keywords: &["冇耳嘅茶杯", "抹茶", "熱茶", "綠茶", "茶"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inkomishi yetiye engenasibambo"),
            keywords: &[
                "inkomishi",
                "inkomishi yetiye",
                "inkomishi yetiye engenasibambo",
                "isiphuzo",
                "itiye",
                "okuphuzwayo",
            ],
        },
    ],
};
#[doc = "🍶"]
pub const SAKE: crate::Emoji = crate::Emoji {
    glyph: "🍶",
    codepoint: "1F376",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "sake",
    group: "Food & Drink",
    subgroup: "drink",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("sake"),
            keywords: &["bottel", "drankie", "glas", "kroeg", "rysbier", "sake"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ማሰሮ"),
            keywords: &["ማሰሮ", "ስኒ", "አሞሌ", "የሚጠጣ ነገር", "ጠርሙስ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("زجاجة وفنجان"),
            keywords: &["زجاجة", "زجاجة وفنجان", "شراب", "مطعم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("শ\u{9cd}বেক"),
            keywords: &[
                "ক\u{9be}প",
                "প\u{9be}নীয\u{9bc}",
                "বটল",
                "ব\u{9be}ৰ",
                "শ\u{9cd}বেক",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sake"),
            keywords: &["bar", "fincan", "içki", "içmək", "sake", "şüşə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("саке"),
            keywords: &["алкаголь", "бар", "бутэлька", "кубак", "напой", "саке"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("саке"),
            keywords: &["бар", "бутилка", "напитка", "саке", "чаша"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("সেইক"),
            keywords: &[
                "ক\u{9be}প",
                "প\u{9be}ন কর\u{9be}",
                "প\u{9be}নীয\u{9bc}",
                "ব\u{9be}র",
                "বোতল",
                "শেক",
                "সেইক",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("sake"),
            keywords: &["evaj", "sake"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("sake"),
            keywords: &["boca", "napitak", "piće", "sake", "šolja"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("sake"),
            keywords: &["ampolla", "bar", "beguda", "sake", "tassa"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄟\u{1112a}𑄉\u{1112a}𑄎\u{1112e}"),
            keywords: &["𑄟\u{1112a}𑄉\u{1112a}𑄎\u{1112e}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏗᏔᏍᏗ"),
            keywords: &["ᎠᏗᏔᏍᏗ", "ᎠᏯᏔᎾᎸ", "ᎤᎵᏍᏈᏘ", "ᎫᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("saké"),
            keywords: &["bar", "lahev", "nápoj", "pití", "saké", "šálek"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sake"),
            keywords: &["bar", "botel", "cwpan", "diod", "sake"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sake"),
            keywords: &["flaske sake", "sake", "sakeflaske", "sakekop"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Sake-Flasche und -Tasse"),
            keywords: &[
                "Flasche",
                "Getränk",
                "Sake",
                "Sake-Flasche und -Tasse",
                "Tasse",
                "trinken",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σάκε"),
            keywords: &["κούπα", "μπαρ", "μπουκάλι", "ποτό", "ρόφημα", "σάκε"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("sake"),
            keywords: &["bar", "beverage", "bottle", "cup", "drink", "sake"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["bar", "beverage", "bottle", "cup", "drink", "saké"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["bar", "beverage", "bottle", "cup", "drink", "sake", "saké"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("sake"),
            keywords: &["bar", "bebida", "botella", "restaurante", "sake", "tazón"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["bar", "bebida", "botella", "japonés", "sake", "tazón"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("riisiviin"),
            keywords: &["baar", "jook", "pudel", "riisiviin", "tass"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("sake"),
            keywords: &["botila", "edari", "kopa", "sake", "taberna"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ساکی"),
            keywords: &[
                "بار",
                "بطری",
                "ساکی",
                "لیوان",
                "میخانه",
                "نوشیدن",
                "نوشیدنی الکلی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("sake"),
            keywords: &["baari", "juoma", "kuppi", "pullo", "riisiviini", "sake"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("sake"),
            keywords: &["alak", "bar", "bote", "inumin", "sake", "tasa"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sake"),
            keywords: &["drykkur", "japanskt", "rísbrennivín", "sake"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("saké"),
            keywords: &["bouteille", "saké"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["bar", "boisson", "bouteille", "saké", "tasse"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("sáicí"),
            keywords: &[
                "bialann",
                "buidéal agus cupán sake",
                "buidéal sake",
                "cupán",
                "deoch",
                "sake",
                "sáicí",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sake"),
            keywords: &["botal", "bàr", "cupa", "cupan", "deoch", "sake"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("sake"),
            keywords: &["bebida", "botella", "cunca", "sake", "xaponesa"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{ac7}ક"),
            keywords: &[
                "પીણ\u{ac1}\u{a82}",
                "બાર",
                "બોટલ",
                "ર\u{ac7}સ\u{acd}ટોરન\u{acd}ટ",
                "સ\u{ac7}ક",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("sake"),
            keywords: &["kofi", "kwalba", "mashaya", "sake", "sha", "shayi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סאקה"),
            keywords: &["אלכוהול", "בר", "יפן", "משקה", "סאקה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{947}क, स\u{947}क बोतल और कप"),
            keywords: &[
                "कप",
                "प\u{947}य",
                "बार",
                "बोतल",
                "स\u{947}क",
                "स\u{947}क, स\u{947}क बोतल और कप",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("sake"),
            keywords: &["bar", "boca", "napitak", "piće", "sake", "šalica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szaké"),
            keywords: &["bár", "csésze", "ital", "szaké", "üveg"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սակե"),
            keywords: &["բաժակ", "բար", "ըմպելիք", "խմել", "շիշ", "սակե"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("sake"),
            keywords: &["bar", "botol", "cangkir", "minuman", "sake"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("maghaa"),
            keywords: &["ihe ọṅụṅụ", "iko", "karama", "maghaa", "ogwe", "ṅụọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sake"),
            keywords: &["bar", "bolli", "drykkur", "flaska", "sake"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("sakè"),
            keywords: &[
                "bar",
                "bere",
                "bottiglia",
                "bottiglia e bicchiere di sakè",
                "sakè",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("徳利"),
            keywords: &["徳利", "日本酒", "酒"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sabotol sake"),
            keywords: &[
                "bar",
                "botol",
                "cangkir",
                "sabotol sake",
                "sake",
                "unjukan",
                "wedang",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("საკე"),
            keywords: &[
                "ბარი",
                "ბოთლი",
                "დალევა",
                "დასალევი",
                "საკე",
                "სასმელი",
                "სმა",
                "ჭიქა",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сакэ"),
            keywords: &["бар", "бөтелке", "сакэ", "сусын", "шынаяқ", "ішімдік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("sake"),
            keywords: &["flaske sake", "sake", "sakeflaske", "sakekop"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}រាអង\u{17d2}ករ"),
            keywords: &["ដបស\u{17d2}រា", "ស\u{17d2}រា", "ស\u{17d2}រាអង\u{17d2}ករ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸೇಕ\u{ccd}"),
            keywords: &[
                "ಅಕ\u{ccd}ಕ\u{cbf} ಮಧ\u{ccd}ಯದ ಬಾಟಲ\u{ccd} ಮತ\u{ccd}ತು ಕಪ\u{ccd}",
                "ಜಪಾನೀಯರ ಅಕ\u{ccd}ಕ\u{cbf} ಮಧ\u{ccd}ಯ",
                "ಸೇಕ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("사케"),
            keywords: &["병과 술잔", "사케", "술"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("भरणी"),
            keywords: &[
                "कप",
                "पिण\u{947}\u{902}",
                "प\u{947}या\u{902}",
                "बाटली",
                "बार",
                "भरणी",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("саке"),
            keywords: &["бар", "бөтөлкө", "ич", "саке", "суусундук"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Sake"),
            keywords: &["Bar", "Fläsch", "Gedrénks", "Sake", "Taass", "drénken"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຫ\u{ebc}\u{ebb}\u{ec9}າຊາເກະ"),
            keywords: &[
                "ຊາເກະ",
                "ເຫ\u{ebc}\u{ebb}\u{ec9}າ",
                "ເຫ\u{ebc}\u{ebb}\u{ec9}າຊາເກະ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("sakė"),
            keywords: &["baras", "butelis", "gėrimas", "puodelis", "sakė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sakē"),
            keywords: &["bārs", "dzert", "dzēriens", "pudele", "sakē"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("hake"),
            keywords: &["hake", "kapu", "pae", "pātara", "unu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("саке"),
            keywords: &["алкохол", "ориз", "пијалак", "саке", "јапонски"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സേക\u{d4d}ക\u{d4d}"),
            keywords: &[
                "കപ\u{d4d}പ\u{d4d}",
                "പ\u{d3e}നീയം",
                "ബ\u{d3e}ർ",
                "ബോട\u{d4d}ടിൽ",
                "സേക\u{d4d}ക\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("сакэ"),
            keywords: &["сакэ", "уух", "шил"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{947}क"),
            keywords: &["कप", "प\u{947}य", "बाटली", "बार", "स\u{947}क"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("sake"),
            keywords: &["bar", "botol", "cawan", "minum", "minuman", "sake"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("sake"),
            keywords: &["bar", "flixkun", "sake", "tazza", "xarba", "xorb"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဆာကေ"),
            keywords: &[
                "ခ\u{103d}က\u{103a}",
                "ဆာကေ",
                "ဆာကေး",
                "ပ\u{102f}လင\u{103a}း",
                "ဘား",
                "သောက\u{103a}စရာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sake"),
            keywords: &["drikke", "flaske", "karaffel", "mugge og kopp", "sake"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{947}क"),
            keywords: &[
                "कप",
                "पिउन\u{947}",
                "बार",
                "ब\u{947}भर\u{947}ज",
                "बोतल",
                "स\u{947}क",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("sake"),
            keywords: &["bar", "drankje", "drinken", "fles", "kopje", "sake"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("sake"),
            keywords: &["drikke", "flaske", "karaffel", "mugge og kopp", "sake"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b3e}କେ"),
            keywords: &[
                "କପ\u{b4d}\u{200c}",
                "ପ\u{b3e}ନୀୟ",
                "ବ\u{b3e}ର\u{b4d}",
                "ବୋତଲ",
                "ରେଷ\u{b4d}ଟ\u{b41}ର\u{b3e}ଣ\u{b4d}ଟ\u{b4d}",
                "ସ\u{b3e}କେ",
                "ସ\u{b3e}କେ ବୋତଲ ଏବଂ କପ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a47}ਕ"),
            keywords: &[
                "ਪਿਆਲਾ",
                "ਪੀਣਾ",
                "ਬਾਰ",
                "ਬ\u{a4b}ਤਲ",
                "ਸ\u{a47}ਕ",
                "ਸ\u{a47}ਕ ਬ\u{a4b}ਤਲ ਅਤ\u{a47} ਪਿਆਲਾ",
                "ਹ\u{a4b}ਟਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مقصد"),
            keywords: &["بوتل", "سیخ", "شربت", "مشروب", "مقصد", "کپ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Sáki"),
            keywords: &[
                "Baa",
                "Bẹ\u{301}vẹ\u{301}rij: Éní Kaín Drink Wé Nọ\u{301} Bi Wọtá",
                "Bọtul",
                "Drink",
                "Japán Họ\u{301}t Drink Wé Im Nem Na Sáki",
                "Kọp",
                "Sáki",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("sake"),
            keywords: &["butelka i kubek", "sake"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سیک"),
            keywords: &["بار، څښاک، بوتل، پياله، څکل، سيک", "سیک"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("saquê"),
            keywords: &[
                "bar",
                "bebida",
                "copo",
                "garrafa",
                "garrafa e copo de saquê",
                "saquê",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("saqué"),
            keywords: &["bar", "bebida", "garrafa", "saqué", "saquê", "taça"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("sake"),
            keywords: &["bar", "botella", "copa", "qiru", "sake", "upyana"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("sake"),
            keywords: &["bar", "băutură", "ceașcă", "sake", "sticlă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-315"),
            keywords: &["E10-315"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("бутылка саке"),
            keywords: &["бутылка саке", "водка", "горячее", "саке", "япония"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("seyiki"),
            keywords: &[
                "akabari",
                "ibinyobwa",
                "icupa",
                "igikombe",
                "kunywa",
                "seyiki",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سيڪ"),
            keywords: &["بار، مشروب، بوتل، ڪپ، پيئڻ", "سيڪ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සකෙ"),
            keywords: &[
                "තැබෑර\u{dd4}ම",
                "ප\u{dcf}නය ක\u{dd2}ර\u{dd3}ම",
                "බ\u{dd3}ම",
                "බෝතලය",
                "සකෙ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("saké"),
            keywords: &["bar", "drink", "fľaša", "nápoj", "pohár", "saké"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("sake"),
            keywords: &[
                "bar",
                "napitek",
                "pijača",
                "sake",
                "skodelica",
                "steklenica",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("khamro jabbaan"),
            keywords: &[
                "baar",
                "cab",
                "cabbitaan",
                "dhalo",
                "khamra jabbaan",
                "khamro jabbaan",
                "koob",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("sake"),
            keywords: &["bar", "filxhan", "pije", "sake", "shishe"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("саке"),
            keywords: &["бaр", "бoцa", "нaпитaк", "пићe", "саке", "шоља"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("sake"),
            keywords: &["bar", "boca", "napitak", "piće", "sake", "šolja"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("sake"),
            keywords: &[
                "dryck",
                "flaska",
                "flaska och kopp med saké",
                "kopp",
                "sake",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mvinyo wa kijapani unaotokana na mchele"),
            keywords: &[
                "baa",
                "chupa",
                "kikombe",
                "kinywaji",
                "mvinyo wa kijapani unaotokana na mchele",
                "sake",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மது ப\u{bbe}ட\u{bcd}டிலும\u{bcd} கோப\u{bcd}பையும\u{bcd}"),
            keywords: &[
                "உணவகம\u{bcd}",
                "சேக\u{bcd}",
                "சேக\u{bcd} ப\u{bbe}ட\u{bcd}டிலும\u{bcd} கோப\u{bcd}பையும\u{bcd}",
                "மது ப\u{bbe}ட\u{bcd}டிலும\u{bcd} கோப\u{bcd}பையும\u{bcd}",
                "மதுப\u{bbe}னம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c47}క\u{c4d}"),
            keywords: &[
                "కప\u{c4d}",
                "డ\u{c4d}ర\u{c3f}ంక\u{c4d}",
                "ప\u{c3e}న\u{c40}యం",
                "బ\u{c3e}ర\u{c4d}",
                "స\u{c40}స\u{c3e}",
                "స\u{c47}క\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("саке"),
            keywords: &["бар", "нӯшидан", "нӯшокӣ", "пиёла", "саке", "шиша"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("สาเก"),
            keywords: &["ขวดสาเก", "สาเก", "เหล\u{e49}าสาเก"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("sake"),
            keywords: &["bar", "içgi", "içmek", "pyýala", "sake", "çaşka", "çüýşe"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("uaine-laise"),
            keywords: &["uaine-laise"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sake"),
            keywords: &[
                "bar",
                "fincan",
                "içecek",
                "restoran",
                "sake",
                "sake şişesi ve fincanı",
                "şişe",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ساكەي"),
            keywords: &["ئىچكۈ", "ئىچىملىك", "بوتۇلكا", "ساكەي", "قاچا", "قاۋاق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("саке"),
            keywords: &["бар", "напій", "пити", "пляшка", "саке", "чашка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جاپانی شراب"),
            keywords: &["بار", "بوتل", "جاپانی شراب", "شراب", "پینا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ko‘za va piyola"),
            keywords: &[
                "bar",
                "ichimlik",
                "issiq ichimlik",
                "ko‘za va piyola",
                "piyola",
                "shisha idish",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("rượu sake"),
            keywords: &["chai", "cốc", "quán ba", "rượu sake", "uống", "đồ uống"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("buteel bu yaatu gémmiñ"),
            keywords: &["buteel", "buteel bu yaatu gémmiñ", "kaas", "laal", "naan"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-sake"),
            keywords: &["i-sake", "ibhari", "ibhotile", "ikomityi", "isiselo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Sake"),
            keywords: &[
                "Sake",
                "ife",
                "ilé ọtí",
                "ohun mímu",
                "ohun mímu oní kòkó",
                "ìgò",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("清酒"),
            keywords: &["杯", "樽", "清酒", "酒吧", "飲品", "飲酒"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("清酒"),
            keywords: &["杯", "樽", "清酒", "酒吧", "饮品", "饮酒"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("清酒"),
            keywords: &["清酒", "瓶", "酒杯", "饮料"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("清酒"),
            keywords: &["清酒", "酒"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["杯子", "清酒", "清酒瓶", "米酒", "酒杯", "酒瓶"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isake"),
            keywords: &[
                "ibha",
                "ibhodlela",
                "inkomishi",
                "isake",
                "isiphuzo",
                "okuphuzwayo",
            ],
        },
    ],
};
#[doc = "🍾"]
pub const BOTTLE_WITH_POPPING_CORK: crate::Emoji = crate::Emoji {
    glyph: "🍾",
    codepoint: "1F37E",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "bottle with popping cork",
    group: "Food & Drink",
    subgroup: "drink",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("bottel met prop wat uitskiet"),
            keywords: &[
                "bottel",
                "bottel met prop wat uitskiet",
                "drink",
                "kroeg",
                "kurk",
                "skiet",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጠርሙስ ከነመክፈቻው"),
            keywords: &["አሞሌ", "ኮርኪ", "ጠርሙስ", "ጠርሙስ ከነመክፈቻው", "ጠጣ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}زجاجة بسدادة مفرقعة"),
            keywords: &[
                "بار",
                "زجاجة",
                "سدادة",
                "شمبانيا",
                "مشروب",
                "\u{202b}زجاجة بسدادة مفرقعة",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("পপিং কৰ\u{9cd}কৰ সৈতে বটল"),
            keywords: &[
                "কৰ\u{9cd}ক",
                "পপিং",
                "পপিং কৰ\u{9cd}কৰ সৈতে বটল",
                "পপিং কৰ\u{9cd}কৰে বটল",
                "বটল",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("tıxacı çıxan şüşə"),
            keywords: &[
                "bar",
                "dartmaq",
                "içmək",
                "tıxac",
                "tıxacı çıxan şüşə",
                "şüşə",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("шампанскае адкаркавана"),
            keywords: &[
                "алкаголь",
                "бар",
                "бутэлька",
                "корак",
                "напой",
                "шампанскае адкаркавана",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Бутилка с изхвърчаща тапа"),
            keywords: &[
                "Бутилка с изхвърчаща тапа",
                "бар",
                "бутилка",
                "питие",
                "тапа",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("পপিং কর\u{9cd}কের স\u{9be}থে বোতল"),
            keywords: &[
                "ছিপি",
                "পপিং",
                "পপিং কর\u{9cd}কের স\u{9be}থে বোতল",
                "প\u{9be}ন কর\u{9be}",
                "ব\u{9be}র",
                "বোতল",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("boutailhad champagn"),
            keywords: &[
                "boutailh",
                "boutailhad champagn",
                "champagn",
                "evaj",
                "stouv",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("boca s plutanim čepom koji iskače"),
            keywords: &[
                "boca",
                "boca s plutanim čepom koji iskače",
                "piće",
                "čep",
                "šank",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("ampolla de cava"),
            keywords: &["ampolla", "ampolla de cava", "cava", "suro", "tap"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎫᎩ ᎬᏩᏠᏯᏍᏗ ᎠᏔᏍᎩᏍᎩ"),
            keywords: &[
                "ᎠᏍᏚᏙᏗ",
                "ᎠᏔᏍᎩᏍᎬ",
                "ᎠᏗᏔᏍᏗ",
                "ᎠᏯᏔᎾᎸ",
                "ᎫᎩ",
                "ᎫᎩ ᎬᏩᏠᏯᏍᏗ ᎠᏔᏍᎩᏍᎩ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("láhev sektu"),
            keywords: &[
                "bar",
                "korek",
                "láhev",
                "láhev sektu",
                "nápoj",
                "sekt",
                "zátka",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("potel gyda chorcyn yn popian"),
            keywords: &[
                "bar",
                "botel",
                "corcyn",
                "diod",
                "potel gyda chorcyn yn popian",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("flaske med flyvende prop"),
            keywords: &["bar", "drik", "flaske", "flaske med flyvende prop", "prop"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Flasche mit knallendem Korken"),
            keywords: &[
                "Champagner",
                "Flasche",
                "Flasche mit knallendem Korken",
                "Korken",
                "Sekt",
                "trinken",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μπουκάλι με φελλό που πετάγεται"),
            keywords: &[
                "μπαρ",
                "μπουκάλι",
                "μπουκάλι με φελλό που πετάγεται",
                "πετάγεται",
                "ποτό",
                "φελλός",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("bottle with popping cork"),
            keywords: &[
                "bar",
                "bottle",
                "bottle with popping cork",
                "cork",
                "drink",
                "popping",
            ],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &[
                "bar",
                "bottle",
                "bottle with popping cork",
                "champagne",
                "cork",
                "drink",
                "popping",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("botella descorchada"),
            keywords: &[
                "bar",
                "beber",
                "botella",
                "botella descorchada",
                "cava",
                "corcho",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "bebida",
                "botella",
                "botella descorchada",
                "celebrar",
                "champaña",
                "champán",
                "festejar",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "botella",
                "botella descorchada",
                "celebrar",
                "champaña",
                "champán",
                "festejar",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "botella",
                "botella descorchada",
                "celebrar",
                "champaña",
                "champán",
                "festejar",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("pudeli avamine"),
            keywords: &["baar", "jook", "kork", "pudel", "pudeli avamine"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kortxoa kanpoan duen botila"),
            keywords: &[
                "bar",
                "botila",
                "edari",
                "kortxo",
                "kortxoa kanpoan duen botila",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("شامپاین جوشان"),
            keywords: &[
                "بار",
                "بطری",
                "بطری با چوب\u{200c}پنبه",
                "شامپاین جوشان",
                "نوشیدنی الکلی",
                "پراندن",
                "چوب\u{200c}پنبه",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pullo ja korkin poksautus"),
            keywords: &[
                "baari",
                "juoda",
                "korkki",
                "poksauttaa",
                "pullo",
                "pullo ja korkin poksautus",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("boteng naalis ang takip"),
            keywords: &[
                "bar",
                "bote",
                "boteng naalis ang takip",
                "champagne",
                "cork",
                "wine",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("fløska við tundurproppi"),
            keywords: &[
                "drykkur",
                "fløska",
                "fløska við tundurproppi",
                "tundurproppur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bouteille de champagne"),
            keywords: &[
                "boisson",
                "bouchon",
                "bouteille",
                "bouteille de champagne",
                "pop",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("buidéal le corc ag popáil"),
            keywords: &[
                "ag popáil",
                "beár",
                "buidéal",
                "buidéal le corc ag popáil",
                "corc",
                "deoch",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("botal le àirc a’ leumadh às"),
            keywords: &[
                "botal",
                "botal le àirc a’ leumadh às",
                "brag",
                "bàr",
                "deoch",
                "leumadh",
                "popadh",
                "àirc",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("botella de champaña"),
            keywords: &[
                "botella",
                "botella de champaña",
                "cava",
                "celebración",
                "champaña",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કૉર\u{acd}ક ખ\u{ac1}લતી બાટલી"),
            keywords: &[
                "કૉર\u{acd}ક",
                "ખ\u{ac1}લતી",
                "ડ\u{acd}રિ\u{a82}ક",
                "બાટલી",
                "બાર",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kwalba mai murfi mai fashewa"),
            keywords: &[
                "fashewa",
                "kwalba",
                "kwalba mai murfi mai fashewa",
                "mashaya",
                "murfi",
                "sha",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("בקבוק שמפניה עם פקק עף"),
            keywords: &[
                "אלכוהול",
                "בקבוק",
                "בקבוק שמפניה עם פקק עף",
                "בר",
                "מסיבה",
                "פקק",
                "שמפניה",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("कॉक ख\u{941}लती ह\u{941}ई बोतल"),
            keywords: &[
                "कॉक ख\u{941}लती ह\u{941}ई बोतल",
                "जश\u{94d}न",
                "पार\u{94d}टी",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("boca iz koje izlijeće čep"),
            keywords: &["bar", "boca", "boca iz koje izlijeće čep", "piće", "čep"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("üveg kiugró dugóval"),
            keywords: &["bár", "ital", "kiugrik", "kupak", "üveg kiugró dugóval"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("թռչող խցանով շիշ"),
            keywords: &[
                "բար",
                "դուրս թռչել",
                "թռչող խցանով շիշ",
                "խմել",
                "խցան",
                "շիշ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("botol dengan penyumbat terlepas"),
            keywords: &[
                "bar",
                "botol",
                "botol dengan penyumbat terlepas",
                "gabus",
                "menyembul",
                "minuman",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("karama nwere mkpuchi"),
            keywords: &[
                "akpọli",
                "karama",
                "karama nwere mkpuchi",
                "mkpuchi",
                "ogwe",
                "ṅụọ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("flaska með korktappa"),
            keywords: &["bar", "flaska", "flaska með korktappa", "korkur", "skjóta"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("bottiglia stappata"),
            keywords: &[
                "bar",
                "bere",
                "bottiglia",
                "bottiglia stappata",
                "festeggiare",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("シャンパン"),
            keywords: &[
                "シャンパン",
                "シャンペン",
                "スパークリングワイン",
                "スプマンテ",
                "ボトル",
                "泡",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("botol mencelat subale"),
            keywords: &[
                "bar",
                "botol",
                "botol mencelat subale",
                "mencelat",
                "subal botol",
                "unjukan",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბოთლი ამოვარდნილი საცობით"),
            keywords: &[
                "ბარი",
                "ბოთლი",
                "ბოთლი ამოვარდნილი საცობით",
                "დალევა",
                "დასალევი",
                "სასმელი",
                "საცობი",
                "სმა",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тығыны атылған бөтелке"),
            keywords: &[
                "атылған",
                "бар",
                "бөтелке",
                "тығын",
                "тығыны атылған бөтелке",
                "ішімдік",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("flaske med flyvende prop"),
            keywords: &["bar", "drik", "flaske", "flaske med flyvende prop", "prop"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ដបស\u{17d2}រាដកឆ\u{17d2}ន\u{17bb}ក"),
            keywords: &[
                "ដបស\u{17d2}រា",
                "ដបស\u{17d2}រាដកឆ\u{17d2}ន\u{17bb}ក",
                "ស\u{17d2}រា",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪಾಪ\u{ccd}ಪ\u{cbf}ಂಗ\u{ccd} ಕಾರ\u{ccd}ಕ\u{ccd}\u{200c}ನ ಬಾಟಲ\u{ccd}"),
            keywords: &[
                "ಪಾಪ\u{ccd}ಪ\u{cbf}ಂಗ\u{ccd} ಕಾರ\u{ccd}ಕ\u{ccd}\u{200c}ನ ಬಾಟಲ\u{ccd}",
                "ಬಾಟಲ\u{ccd}",
                "ಬಾರ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("코르크가 튀어나오고 있는 병"),
            keywords: &["와인", "와인병", "코르크", "코르크가 튀어나오고 있는 병"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पोपि\u{902}ग कॉर\u{94d}क आसपी बाटली"),
            keywords: &[
                "कॉर\u{94d}क",
                "पिण\u{947}\u{902}",
                "पोपि\u{902}ग",
                "पोपि\u{902}ग कॉर\u{94d}क आसपी बाटली",
                "बाटली",
                "बार",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("шампан"),
            keywords: &["атылма", "бар", "бөтөлкө", "тыгын", "шампан"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Fläsch mat knallendem Stopp"),
            keywords: &[
                "Bar",
                "Fläsch",
                "Fläsch mat knallendem Stopp",
                "Stopp",
                "drénken",
                "knallend",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແກ\u{ec9}ວເຫ\u{ebc}\u{ebb}\u{ec9}າທ\u{eb5}\u{ec8}ມ\u{eb5}ຝາກະດອນອ\u{eb1}ດ"),
            keywords: &[
                "ຝາກະດອນ",
                "ເຄ\u{eb7}\u{ec8}ອງດ\u{eb7}\u{ec8}ມ",
                "ເຫ\u{ebc}\u{ebb}\u{ec9}າ",
                "ແກ\u{ec9}ວ",
                "ແກ\u{ec9}ວເຫ\u{ebc}\u{ebb}\u{ec9}າທ\u{eb5}\u{ec8}ມ\u{eb5}ຝາກະດອນອ\u{eb1}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("butelis su iššokusiu kamščiu"),
            keywords: &[
                "baras",
                "butelis",
                "butelis su iššokusiu kamščiu",
                "gėrimas",
                "iššauti",
                "kamštis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pudele ar izšautu korķi"),
            keywords: &[
                "bārs",
                "dzert",
                "dzēriens",
                "korķis",
                "pudele",
                "pudele ar izšautu korķi",
                "šampanietis",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pātara puru pahū"),
            keywords: &[
                "pae",
                "pahū ana",
                "puru",
                "pātara",
                "pātara puru pahū",
                "unu",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("шише шампањ"),
            keywords: &["бар", "пијалак", "тапа", "шампањ", "шише"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മദിരോത\u{d4d}സവം"),
            keywords: &[
                "കോർക\u{d4d}ക\u{d4d}",
                "ബ\u{d3e}ർ",
                "മദിരോത\u{d4d}സവം",
                "മദ\u{d4d}യം",
                "ഷ\u{d3e}ംപെയ\u{d4d}\u{200c}ൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("оргилуун дарс"),
            keywords: &["буудах", "дарс", "оргилуун", "уух"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("उडणार\u{94d}\u{200d}या झाकणाची बॉटल"),
            keywords: &[
                "उडणार\u{94d}\u{200d}या झाकणाची बॉटल",
                "उडणाऱ\u{94d}या झाकणाची बाटली",
                "कॉर\u{94d}क",
                "प\u{947}य",
                "पॉपि\u{902}ग",
                "बाटली",
                "बार",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("botol dengan penutup gabus terbuka"),
            keywords: &[
                "bar",
                "botol",
                "botol dengan penutup gabus terbuka",
                "botol gabus terbuka",
                "gabus",
                "minum",
                "pop",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("flixkun b’tapp tas-sufra jinfetaħ"),
            keywords: &[
                "bar",
                "flixkun",
                "flixkun b’tapp tas-sufra jinfetaħ",
                "jinfetaħ",
                "sufra",
                "xarba",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "လ\u{103d}င\u{1037}\u{103a}ထ\u{103d}က\u{103a}ပ\u{103d}င\u{1037}\u{103a}လာမည\u{1037}\u{103a} ဖော\u{1037}ဆ\u{102d}\u{102f}\u{1037}ပါ ပ\u{102f}လင\u{103a}း",
            ),
            keywords: &[
                "ပ\u{102f}လင\u{103a}း",
                "ဖော\u{1037}ဆ\u{102d}\u{102f}\u{1037}",
                "ဖော\u{1037}ဆ\u{102d}\u{102f}\u{1037} လ\u{103d}င\u{1037}\u{103a}ထ\u{103d}က\u{103a}လာနေသည\u{1037}\u{103a} ပ\u{102f}လင\u{103a}းပ\u{102f}\u{1036}",
                "ဘား",
                "လ\u{103d}င\u{1037}\u{103a}ထ\u{103d}က\u{103a}ပ\u{103d}င\u{1037}\u{103a}လာမည\u{1037}\u{103a} ဖော\u{1037}ဆ\u{102d}\u{102f}\u{1037}ပါ ပ\u{102f}လင\u{103a}း",
                "သောက\u{103a}စရာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("flaske med sprettkork"),
            keywords: &[
                "bar",
                "drikke",
                "flaske",
                "flaske med sprettkork",
                "kork",
                "sprette",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पपिङ\u{94d} कर\u{94d}कको साथ बोतल"),
            keywords: &[
                "कर\u{94d}क",
                "पपिङ\u{94d}",
                "पपिङ\u{94d} कर\u{94d}कको साथ बोतल",
                "पिउन\u{947}",
                "बार",
                "बोतल",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("fles met knallende kurk"),
            keywords: &[
                "bar",
                "drinken",
                "fles",
                "fles met knallende kurk",
                "knallend",
                "kurk",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("flaske med sprettkork"),
            keywords: &[
                "bar",
                "drikke",
                "flaske",
                "flaske med sprettkork",
                "kork",
                "sprette",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପପ\u{b3f}ଂ କରକ\u{b4d}\u{200d} ସହ\u{b3f}ତ ବୋତଲ"),
            keywords: &[
                "ପପ\u{b3f}ଂ କରକ\u{b4d}\u{200d} ସହ\u{b3f}ତ ବୋତଲ",
                "ବ\u{b3e}ର\u{b4d}\u{200d} । ବୋତଲ । କରକ\u{b4d}\u{200d} । ପ\u{b3e}ନୀୟ । ପପ\u{b3f}ଂ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਖ\u{a41}\u{a71}ਲ\u{a4d}ਹਦੀ ਹ\u{a4b}ਈ ਬ\u{a4b}ਤਲ"),
            keywords: &[
                "ਖ\u{a41}\u{a71}ਲ\u{a4d}ਹਦੀ ਹ\u{a4b}ਈ ਬ\u{a4b}ਤਲ",
                "ਜਸ\u{a3c}ਨ ‘ਤ\u{a47} ਖ\u{a41}\u{a71}ਲ\u{a4d}ਹਦੀ ਹ\u{a4b}ਈ ਬ\u{a4b}ਤਲ",
                "ਬਾਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کھولدے ڈھکن آلی بوتل"),
            keywords: &[
                "بندوق چلونا",
                "بوتل",
                "سیخ",
                "شاہ بلوط دا درخت",
                "شربت",
                "کھولدے ڈھکن آلی بوتل",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bọ\u{301}tul Wit Kọk"),
            keywords: &[
                "Baa",
                "Bọtul",
                "Bọtul Wé Gẹ\u{301}t Kọk",
                "Bọ\u{301}tul Wit Kọk",
                "Kọk",
                "Pọ\u{301}pín Saund",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("butelka z wystrzelającym korkiem"),
            keywords: &[
                "bar",
                "butelka",
                "butelka z wystrzelającym korkiem",
                "korek",
                "nowy rok",
                "sylwester",
                "toast",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د پوپنګ کارک بوتل"),
            keywords: &[
                "بار، بوتل، د پوپنګ کارک بوتل، کارک، څکل، پوپنګ",
                "د پوپنګ کارک بوتل",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("garrafa de champanhe"),
            keywords: &[
                "bar",
                "champanha",
                "champanhe",
                "espumante",
                "garrafa",
                "garrafa de champanhe",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("garrafa com rolha a saltar"),
            keywords: &[
                "bar",
                "beber",
                "garrafa",
                "garrafa com rolha a saltar",
                "rolha",
                "saltar",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("descorche jumiwa"),
            keywords: &[
                "bar",
                "botella",
                "corcho",
                "dercorche",
                "descorche jumiwa",
                "upyana",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("sticlă căreia îi sare dopul"),
            keywords: &[
                "bar",
                "băutură",
                "dop",
                "sticlă",
                "sticlă căreia îi sare dopul",
                "sărbătoare",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-323"),
            keywords: &["E10-323"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("шампанское"),
            keywords: &["бутылка", "вино", "игристое", "пробка", "шампанское"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("icupa rifite umufuniko uri kuvaho"),
            keywords: &[
                "agapfundikizo",
                "akabari",
                "gutomboka",
                "icupa",
                "icupa rifite umufuniko uri kuvaho",
                "kunywa",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پوپنگ ڪارڪ واري بوتل"),
            keywords: &["بار، بوتل، ڪارڪ، پيئڻ،پوپنگ", "پوپنگ ڪارڪ واري بوتل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ම\u{dd6}ඩ\u{dd2}ය පන\u{dd2}න බෝතලය"),
            keywords: &[
                "තැබෑර\u{dd4}ම",
                "පන\u{dd2}න",
                "ප\u{dcf}නය ක\u{dd2}ර\u{dd3}ම",
                "බෝතලය",
                "ම\u{dd6}ඩ\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("šampanské"),
            keywords: &[
                "bar",
                "drink",
                "fľaša",
                "otváranie zátky",
                "zátka",
                "šampanské",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("odpiranje penine"),
            keywords: &[
                "bar",
                "odleteti",
                "odpiranje penine",
                "pijača",
                "steklenica",
                "zamašek",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dhalo khamri ubrinaysa"),
            keywords: &["baar", "dhalo", "gufka", "khamri", "ubrinaysa"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shishe me tapë që kërcet"),
            keywords: &["pije", "shishe", "shishe me tapë që kërcet", "tapë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("боца из које излеће чеп"),
            keywords: &[
                "бaр",
                "бoцa",
                "боца из које излеће чеп",
                "пићe",
                "чeп",
                "шампањац",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("боца из које излијеће чеп"),
            keywords: &["боца из које излијеће чеп"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("boca iz koje izleće čep"),
            keywords: &[
                "bar",
                "boca",
                "boca iz koje izleće čep",
                "piće",
                "čep",
                "šampanjac",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("boca iz koje izlijeće čep"),
            keywords: &["boca iz koje izlijeće čep"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("champagne"),
            keywords: &["bubbel", "champagne", "fest", "nyår"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("chupa yenye kifuniko kilichofunguliwa"),
            keywords: &[
                "baa",
                "chupa",
                "chupa yenye kifuniko kilichofunguliwa",
                "kifuniko",
                "kinywaji",
                "kufungua",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ப\u{bc0}ச\u{bcd}சடிக\u{bcd}கும\u{bcd} ப\u{bbe}ட\u{bcd}டில\u{bcd}"),
            keywords: &[
                "க\u{bbe}ர\u{bcd}க\u{bcd}",
                "ப\u{bc0}ச\u{bcd}சடிக\u{bcd}கும\u{bcd} ப\u{bbe}ட\u{bcd}டில\u{bcd}",
                "ப\u{bc0}ச\u{bcd}சியடி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c3e}ర\u{c4d}క\u{c4d} ఉండ\u{c47} స\u{c40}స\u{c3e}"),
            keywords: &[
                "క\u{c3e}ర\u{c4d}క\u{c4d}",
                "క\u{c3e}ర\u{c4d}క\u{c4d} ఉండ\u{c47} స\u{c40}స\u{c3e}",
                "ప\u{c3e}న\u{c40}యం",
                "బ\u{c3e}ర\u{c4d}",
                "స\u{c40}స\u{c3e}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("шиша бо пӯкаи он парида рафта истода"),
            keywords: &[
                "бар",
                "нӯшидан",
                "парида рафтан",
                "пӯка",
                "шиша",
                "шиша бо пӯкаи он парида рафта истода",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แชมเปญ"),
            keywords: &[
                "ขวด",
                "จ\u{e38}กไม\u{e49}ก\u{e4a}อก",
                "บาร\u{e4c}",
                "เคร\u{e37}\u{e48}องด\u{e37}\u{e48}ม",
                "แชมเปญ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("dykysy atylýan çüýşe"),
            keywords: &[
                "atylýan",
                "bar",
                "dyky",
                "dykysy atylýan çüýşe",
                "içmek",
                "çüýşe",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("hina moe ʻumosi"),
            keywords: &["hina moe ʻumosi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("patlayan mantarlı şişe"),
            keywords: &["bar", "içki", "mantar", "patlayan mantarlı şişe", "şişe"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ياغاچ تۇۋاقلىق بوتۇلكا"),
            keywords: &[
                "ئىچكۈ",
                "ئېغىز",
                "بوتۇلكا",
                "قاۋاق",
                "ياغاچ",
                "ياغاچ تۇۋاقلىق بوتۇلكا",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("пляшка з корком, що вилітає"),
            keywords: &[
                "бар",
                "корок",
                "пити",
                "пляшка",
                "пляшка з корком під тиском",
                "пляшка з корком, що вилітає",
                "стріляти",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کارک لگی بوتل"),
            keywords: &["بار", "بوتل", "پینا", "کارک", "کارک لگی بوتل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tiqinli shisha idish"),
            keywords: &[
                "bar",
                "ichimlik",
                "otilayotgan",
                "shisha idish",
                "tiqinli shisha idish",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("chai rượu với nút gỗ bật ra"),
            keywords: &[
                "bật ra",
                "chai",
                "chai rượu với nút gỗ bật ra",
                "nút gỗ",
                "quán bar",
                "đồ uống",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("buteel bu saañ biy naaw"),
            keywords: &[
                "buteel",
                "buteel bu saañ biy naaw",
                "laat",
                "naan",
                "naaw",
                "saañ",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhotile enesiciko esitsibayo"),
            keywords: &[
                "esitsibayo",
                "ibhari",
                "ibhotile",
                "ibhotile enesiciko esitsibayo",
                "isiciko",
                "isiselo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Igo Olori Yiyọ"),
            keywords: &[
                "Igo Olori Yiyọ",
                "ilé ọtí",
                "ohun mímu",
                "ìdérí ọtí",
                "ìgò",
                "ìṣí ọtí",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("開酒塞嘅酒樽"),
            keywords: &["樽", "酒吧", "酒塞", "開酒塞", "開酒塞嘅酒樽", "飲酒"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("开酒塞嘅酒樽"),
            keywords: &["开酒塞", "开酒塞嘅酒樽", "樽", "酒吧", "酒塞", "饮酒"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("开香槟"),
            keywords: &["庆祝", "开香槟", "木塞", "瓶子", "香槟"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("洋酒"),
            keywords: &["洋酒", "酒"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("開緊蓋嘅樽"),
            keywords: &["酒樽", "開緊蓋嘅樽", "香檳", "香檳酒樽"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhodlela elinokuputshuka phezulu"),
            keywords: &[
                "ibha",
                "ibhodlela",
                "ibhodlela elinokuputshuka phezulu",
                "icork",
                "isiphuzo",
                "ukuqhuma",
            ],
        },
    ],
};
#[doc = "🍷"]
pub const WINE_GLASS: crate::Emoji = crate::Emoji {
    glyph: "🍷",
    codepoint: "1F377",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "wine glass",
    group: "Food & Drink",
    subgroup: "drink",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("wynglas"),
            keywords: &["drankie", "drink", "glas", "kroeg", "wyn", "wynglas"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የወይን ብርጭቆ"),
            keywords: &["መነጽር", "ወይን", "የሚጠጣ ነገር", "የወይን ብርጭቆ", "ጠጣ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كأس شراب"),
            keywords: &["بار", "خمرة", "شراب", "كأس", "مطعم"],
        },
        #[cfg(feature = "ar_SA")]
        crate::Annotation {
            lang: "ar_SA",
            tts: Some("كأس عصير"),
            keywords: &["كأس عصير"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ৱ\u{9be}ইনৰ গিল\u{9be}চ"),
            keywords: &[
                "গিল\u{9be}চ",
                "প\u{9be}নীয\u{9bc}",
                "ব\u{9be}ৰ",
                "ৱ\u{9be}ইন",
                "ৱ\u{9be}ইনৰ গিল\u{9be}চ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("şərab bakalı"),
            keywords: &["bar", "içki", "içmək", "şüşə", "şərab", "şərab bakalı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("келіх віна"),
            keywords: &["бар", "віно", "келіх", "келіх віна", "напой"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Винена чаша"),
            keywords: &[
                "Винена чаша",
                "винена чаша",
                "вино",
                "напитка",
                "питие",
                "чаша",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মদের গ\u{9cd}ল\u{9be}স"),
            keywords: &[
                "ওয\u{9bc}\u{9be}ইন",
                "গ\u{9cd}ল\u{9be}স",
                "প\u{9be}ন কর\u{9be}",
                "প\u{9be}নীয\u{9bc}",
                "ব\u{9be}র",
                "মদের গ\u{9cd}ল\u{9be}স",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("gwerennad gwin"),
            keywords: &["evaj", "gwerenn", "gwerennad gwin", "gwin"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("čaša vina"),
            keywords: &["piće", "vino", "čaša", "čaša vina", "šank"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("copa de vi"),
            keywords: &["copa", "copa de vi", "vi"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄟\u{11127}𑄘\u{11127} 𑄉\u{11127}𑄣\u{11127}𑄌\u{11134}"),
            keywords: &["𑄟\u{11127}𑄘\u{11127} 𑄉\u{11127}𑄣\u{11127}𑄌\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎩᎦᎨ ᎠᏗᏔᏍᏗ ᎫᎩ"),
            keywords: &["ᎠᏗᏔᏍᏗ", "ᎠᏯᏔᎾᎸ", "ᎤᎸᏌᏗ", "ᎩᎦᎨ ᎠᏗᏔᏍᏗ", "ᎩᎦᎨ ᎠᏗᏔᏍᏗ ᎫᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("sklenička vína"),
            keywords: &[
                "bar",
                "nápoj",
                "pití",
                "sklenice",
                "sklenička vína",
                "sklo",
                "víno",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("gwydr gwin"),
            keywords: &["bar", "diod", "gwin", "gwydr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("vinglas"),
            keywords: &["et glas vin", "hvidvin", "rødvin", "vinglas"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Weinglas"),
            keywords: &["Bar", "Glas", "Wein", "Weinglas"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ποτήρι κρασί"),
            keywords: &["κρασί", "μπαρ", "ποτήρι", "ποτό", "ρόφημα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("wine glass"),
            keywords: &["bar", "beverage", "drink", "glass", "wine"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("copa de vino"),
            keywords: &["bar", "bebida", "copa", "copa de vino", "vaso", "vino"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "bar",
                "bebida",
                "copa",
                "copa de vino",
                "restaurante",
                "vino",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("veiniklaas"),
            keywords: &["baar", "jook", "klaas", "vein", "veiniklaas"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ardo-kopa"),
            keywords: &["ardo", "ardo-kopa", "edari", "kopa", "taberna"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("جام شراب"),
            keywords: &[
                "بار",
                "جام شراب",
                "شراب",
                "میخانه",
                "نوشیدن",
                "نوشیدنی الکلی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("viinilasi"),
            keywords: &["baari", "juoda", "juoma", "lasi", "viini", "viinilasi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("wine glass"),
            keywords: &["alak", "bar", "glass", "inumin", "wine"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("vínglas"),
            keywords: &["drykkur", "glas", "reytt", "vín", "vínglas"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("verre de vin"),
            keywords: &["verre", "verre de vin", "vin"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["bar", "boisson", "verre", "verre de vin", "vin"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("gloine fíona"),
            keywords: &["deoch", "fíon", "gloine", "gloine fíona", "teach tábhairne"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("glainne-fhìona"),
            keywords: &["bàr", "deoch", "fìon", "glainne", "glainne-fhìona", "òl"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("copa de viño"),
            keywords: &["alcohol", "bar", "bebida", "copa de viño", "viño"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વાઇનનો ગ\u{acd}લાસ"),
            keywords: &[
                "ગ\u{acd}લાસ",
                "પીણ\u{ac1}\u{a82}",
                "બાર",
                "ર\u{ac7}સ\u{acd}ટોરન\u{acd}ટ",
                "વાઇન",
                "વાઇન માટ\u{ac7}નો ગ\u{acd}લાસ",
                "વાઇનનો ગ\u{acd}લાસ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("gilashin giya"),
            keywords: &[
                "gilashi",
                "gilashin giya",
                "giya",
                "mashaya",
                "sha",
                "shayi",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כוס יין"),
            keywords: &["אלכוהול", "בר", "יין", "כוס"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("शराब का गिलास"),
            keywords: &["गिलास", "प\u{947}य", "बार", "वाइन", "शराब", "शराब का गिलास"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("čaša za vino"),
            keywords: &["bar", "piće", "vino", "čaša", "čaša za vino"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("borospohár"),
            keywords: &["bor", "borospohár", "bár", "ital", "pohár"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("գինու բաժակ"),
            keywords: &["բաժակ", "բար", "գինի", "գինու բաժակ", "ըմպելիք", "խմել"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("gelas anggur"),
            keywords: &["anggur", "bar", "gelas", "minuman"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("iko nkụwa"),
            keywords: &["ihe ọṅụṅụ", "iko", "iko nkụwa", "mmanya", "ogwe", "ṅụọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("vín"),
            keywords: &["bar", "drekka", "drykkur", "glas", "vín"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("bicchiere di vino"),
            keywords: &[
                "bar",
                "bere",
                "bicchiere",
                "bicchiere di vino",
                "ristorante",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ワイングラス"),
            keywords: &["グラス", "バー", "ワイン", "ワイングラス"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("gelas anggur"),
            keywords: &["anggur", "bar", "gelas", "unjukan", "wedang"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ღვინის ჭიქა"),
            keywords: &[
                "ბარი",
                "დალევა",
                "დასალევი",
                "სასმელი",
                "სმა",
                "ღვინის ჭიქა",
                "ღვინო",
                "შუშა",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шарап бокалы"),
            keywords: &["бар", "стакан", "сусын", "шарап", "шарап бокалы", "ішімдік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("vin"),
            keywords: &["et glas vin", "hvidvin", "rødvin", "vin"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}រាម\u{17bd}យកែវ"),
            keywords: &[
                "កែវ",
                "បារ",
                "ផ\u{17b9}ក",
                "ភេសជ\u{17d2}ជៈ",
                "ស\u{17d2}រា",
                "ស\u{17d2}រាម\u{17bd}យកែវ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ವೈನ\u{ccd} ಗ\u{ccd}ಲಾಸ\u{ccd}"),
            keywords: &[
                "ವೈನ\u{ccd}",
                "ವೈನ\u{ccd} ಗ\u{ccd}ಲಾಸ\u{ccd}",
                "ವೈನ\u{ccd}\u{200c}\u{200c}ನ ಲೋಟ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("와인잔"),
            keywords: &["와인", "와인글라스", "와인바", "와인잔"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("वायनाचो ग\u{94d}लास"),
            keywords: &[
                "ग\u{94d}लास",
                "पिण\u{947}\u{902}",
                "प\u{947}या\u{902}",
                "बार",
                "वायन",
                "वायनाचो ग\u{94d}लास",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("вино бокалы"),
            keywords: &["бар", "бокал", "вино", "вино бокалы", "ичимдик"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Wäiglas"),
            keywords: &["Bar", "Gedrénks", "Glas", "Wäiglas", "Wäin", "drénken"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຈອກແກ\u{ec9}ວເຫ\u{ebc}\u{ebb}\u{ec9}າແວງ"),
            keywords: &[
                "ຈອກ",
                "ຈອກເຫ\u{ebc}\u{ebb}\u{ec9}າ",
                "ຈອກແກ\u{ec9}ວເຫ\u{ebc}\u{ebb}\u{ec9}າແວງ",
                "ເຫ\u{ebc}\u{ebb}\u{ec9}າແວງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vyno taurė"),
            keywords: &["baras", "gerti", "gėrimas", "taurė", "vynas", "vyno taurė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vīna glāze"),
            keywords: &["bārs", "dzert", "dzēriens", "glāze", "vīna glāze", "vīns"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("karāhe waina"),
            keywords: &["karāhe", "pae", "unu", "waina"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("чаша за вино"),
            keywords: &["бар", "вино", "пијалак", "чаша", "чаша за вино"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വൈൻ ഗ\u{d4d}ല\u{d3e}സ\u{d4d}"),
            keywords: &[
                "ഗ\u{d4d}ല\u{d3e}സ\u{d41}കൾ",
                "ഡ\u{d4d}രിങ\u{d4d}ക\u{d4d}",
                "ബ\u{d3e}ർ",
                "വീഞ\u{d4d}ഞ\u{d4d}",
                "വൈൻ",
                "വൈൻ ഗ\u{d4d}ല\u{d3e}സ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("виноны хундага"),
            keywords: &["баар", "виноны хундага", "дарс", "уух", "уух юм", "хундага"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मद\u{94d}याचा ग\u{94d}लास"),
            keywords: &[
                "ग\u{94d}लास",
                "दार\u{942}",
                "दार\u{942}चा ग\u{94d}लास",
                "प\u{947}य",
                "बार",
                "मद\u{94d}याचा ग\u{94d}लास",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("gelas wain"),
            keywords: &["bar", "gelas", "minum", "minuman", "wain"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("tazza nbid"),
            keywords: &["bar", "inbid", "tazza", "tazza nbid", "xarba", "xorb"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဝ\u{102d}\u{102f}င\u{103a}ခ\u{103d}က\u{103a}"),
            keywords: &[
                "ခ\u{103d}က\u{103a}",
                "ဘား",
                "ဝ\u{102d}\u{102f}င\u{103a}",
                "ဝ\u{102d}\u{102f}င\u{103a}ခ\u{103d}က\u{103a}",
                "သောက\u{103a}စရာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("vinglass"),
            keywords: &["drikke", "glass", "rødvin", "vin", "vinglass"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("वाइन गिलास"),
            keywords: &["गिलास", "पिउन\u{947}", "बार", "ब\u{947}भर\u{947}ज", "वाइन"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("wijnglas"),
            keywords: &["bar", "drankje", "drinken", "glas", "wijn", "wijnglas"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("vinglas"),
            keywords: &["drikke", "glas", "raudvin", "vin", "vinglas"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b41}ର\u{b3e} ଗ\u{b4d}ଲ\u{b3e}ସ\u{b4d}\u{200d}"),
            keywords: &[
                "ଗ\u{b4d}ଲ\u{b3e}ସ\u{b4d}\u{200c}",
                "ପ\u{b3e}ନୀୟ",
                "ବ\u{b3e}ର\u{b4d}",
                "ରେଷ\u{b4d}ଟ\u{b41}ର\u{b3e}ଣ\u{b4d}ଟ\u{b4d}",
                "ସ\u{b41}ର\u{b3e}",
                "ୱ\u{b3e}ଇନ\u{b4d} ଗ\u{b4d}ଲ\u{b3e}ସ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਵਾਈਨ ਦਾ ਗਿਲਾਸ"),
            keywords: &[
                "ਗਲਾਸ",
                "ਪੀਣਾ",
                "ਬਾਰ",
                "ਵਾਈਨ",
                "ਵਾਈਨ ਦਾ ਗਲਾਸ",
                "ਵਾਈਨ ਦਾ ਗਿਲਾਸ",
                "ਹ\u{a4b}ਟਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("شراب دا گلاس"),
            keywords: &["سیخ", "شراب", "شراب دا گلاس", "شربت", "مشروب", "گلاس"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Waín Glas"),
            keywords: &[
                "Baa",
                "Bẹ\u{301}vẹ\u{301}rij: Éní Kaín Drink Wé Nọ\u{301} Bi Wọtá",
                "Drink",
                "Glas",
                "Wain",
                "Waín Glas",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kieliszek wina"),
            keywords: &["alkohol", "kieliszek", "kieliszek wina", "wino"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د شرابو ګلاس"),
            keywords: &["بار، څښاک، څکل، ګيلاس، شراب", "د شرابو ګلاس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("vinho"),
            keywords: &["bar", "bebida", "cálice de vinho", "taça de vinho", "vinho"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("copo de vinho"),
            keywords: &["bar", "beber", "bebida", "copo", "copo de vinho", "vinho"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("vino qiru"),
            keywords: &["bar", "copa", "qiru", "upyana", "vino qiru", "wine"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pahar de vin"),
            keywords: &["bar", "băutură", "pahar", "pahar de vin", "vin"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-316"),
            keywords: &["E10-316"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("бокал вина"),
            keywords: &["бокал", "бокал вина", "вино"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikirahure cya divayi"),
            keywords: &[
                "akabari",
                "ibinyobwa",
                "ikirahure cya divayi",
                "ikirahuri",
                "kunywa",
                "wino",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("وائين جو گلاس"),
            keywords: &["بار، مشروب، پيئڻ، گلاس، وائين", "وائين جو گلاس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වය\u{dd2}න\u{dca} ව\u{dd3}ද\u{dd4}ර\u{dd4}ව"),
            keywords: &[
                "තැබෑර\u{dd4}ම",
                "ප\u{dcf}නය ක\u{dd2}ර\u{dd3}ම",
                "බ\u{dd3}ම",
                "වය\u{dd2}න\u{dca}",
                "ව\u{dd3}ද\u{dd4}ර\u{dd4}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("vínový pohár"),
            keywords: &["bar", "drink", "nápoj", "pohár", "víno", "vínový pohár"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vinski kozarec"),
            keywords: &[
                "bar",
                "napitek",
                "pijača",
                "steklenica",
                "vino",
                "vinski kozarec",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("galaas khamri ah"),
            keywords: &[
                "baar",
                "cab",
                "cabbitaan",
                "galaas",
                "galaas khamri ah",
                "khamri",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gotë vere"),
            keywords: &["gotë", "gotë vere", "pije", "verë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("чаша вина"),
            keywords: &["бaр", "винo", "пићe", "чaшa", "чаша вина"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("čaša vina"),
            keywords: &["bar", "piće", "vino", "čaša", "čaša vina"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("vinglas"),
            keywords: &["dryck", "glas", "vin", "vinglas"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("glasi ya divai"),
            keywords: &["baa", "glasi", "glasi ya divai", "kinywaji", "mvinyo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மதுக\u{bcd}கோப\u{bcd}பை"),
            keywords: &[
                "உணவகம\u{bcd}",
                "கோப\u{bcd}பை",
                "ப\u{bbe}னம\u{bcd}",
                "மது",
                "மதுக\u{bcd}கோப\u{bcd}பை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మద\u{c4d}యం గ\u{c4d}ల\u{c3e}స\u{c4d}"),
            keywords: &[
                "గ\u{c4d}ల\u{c3e}సు",
                "ప\u{c3e}న\u{c40}యం",
                "బ\u{c3e}ర\u{c4d}",
                "మద\u{c4d}యం గ\u{c4d}ల\u{c3e}స\u{c4d}",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
                "వ\u{c48}న\u{c4d}",
                "వ\u{c48}న\u{c4d} ఉన\u{c4d}న గ\u{c4d}ల\u{c3e}సు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("стакани май"),
            keywords: &["бар", "май", "нӯшидан", "нӯшокӣ", "стакан", "стакани май"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ไวน\u{e4c}"),
            keywords: &["แก\u{e49}วไวน\u{e4c}", "ไวน\u{e4c}", "ไวน\u{e4c}แดง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çakyr bulgury"),
            keywords: &["bar", "bulgur", "içgi", "içmek", "çakyr bulgury"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ipu sioʻata uaine"),
            keywords: &["ipu sioʻata uaine"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("şarap kadehi"),
            keywords: &[
                "bar",
                "bardak",
                "bardak şarap",
                "içecek",
                "kadeh",
                "şarap bardağı",
                "şarap kadehi",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ھاراق رومكىسى"),
            keywords: &[
                "ئىچكۈ",
                "ئىچىملىك",
                "رومكا",
                "قاۋاق",
                "ھاراق",
                "ھاراق رومكىسى",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("келих для вина"),
            keywords: &["бар", "вино", "келих", "келих для вина", "напій", "пити"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("شراب کا گلاس"),
            keywords: &["بار", "شراب", "شراب کا گلاس", "پینا", "گلاس"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("vino qadahi"),
            keywords: &[
                "bar",
                "ichimlik",
                "issiq ichimlik",
                "stakan",
                "vino",
                "vino qadahi",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ly rượu vang"),
            keywords: &["ly", "ly rượu vang", "quán ba", "rượu", "uống", "đồ uống"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kaasu sàngara"),
            keywords: &["bevemer", "glass", "kaasu sàngara", "laat", "naan", "wine"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iglasi yewayine"),
            keywords: &["ibhari", "iglasi", "iglasi yewayine", "isiselo", "iwayine"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Gilasi Waini"),
            keywords: &[
                "Gilasi Waini",
                "gílásì",
                "ilé ọtí",
                "ohun mímu",
                "ohun mímu oní kòkó",
                "wáìnì",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("紅酒杯"),
            keywords: &["杯", "紅酒杯", "酒", "酒吧", "飲品", "飲酒"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("红酒杯"),
            keywords: &["杯", "红酒杯", "酒", "酒吧", "饮品", "饮酒"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("葡萄酒"),
            keywords: &["葡萄酒", "酒", "酒杯"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("葡萄酒"),
            keywords: &["葡萄酒", "酒", "酒杯"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("紅酒"),
            keywords: &["一杯紅酒", "一杯酒", "紅酒", "酒", "酒杯"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ingilazi yewayini"),
            keywords: &[
                "ibha",
                "ingilazi",
                "ingilazi yewayini",
                "isiphuzo",
                "iwayini",
                "okuphuzwayo",
            ],
        },
    ],
};
#[doc = "🍸"]
pub const COCKTAIL_GLASS: crate::Emoji = crate::Emoji {
    glyph: "🍸",
    codepoint: "1F378",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "cocktail glass",
    group: "Food & Drink",
    subgroup: "drink",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("skemerkelkieglas"),
            keywords: &[
                "drink",
                "glas",
                "kelkie",
                "kroek",
                "skemer",
                "skemerkelkieglas",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የኮክቴል ብርጭቆ"),
            keywords: &["መነጽር", "አሞሌ", "ኮክቴል", "የኮክቴል ብርጭቆ", "ጠጣ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كأس عصير كوكتيل"),
            keywords: &["شراب", "كأس عصير كوكتيل", "كوكتيل", "محل تقديم المشروبات"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ককটেইল গিল\u{9be}চ"),
            keywords: &["ককটেইল", "গিল\u{9be}চ", "প\u{9be}নীয\u{9bc}", "ব\u{9be}ৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kokteyl bakalı"),
            keywords: &["bar", "içmək", "kokteyl", "kokteyl bakalı", "şüşə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("келіх кактэйлю"),
            keywords: &["бар", "кактэйль", "келіх", "келіх кактэйлю", "напой"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Коктейлна чаша"),
            keywords: &["Коктейлна чаша", "бар", "коктейл", "питие", "чаша"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ককটেলের গ\u{9cd}ল\u{9be}স"),
            keywords: &[
                "ককটেল",
                "ককটেলের গ\u{9cd}ল\u{9be}স",
                "গ\u{9cd}ল\u{9be}স",
                "প\u{9be}ন কর\u{9be}",
                "ব\u{9be}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("koktel"),
            keywords: &["evaj", "gwerenn", "koktel"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("koktel"),
            keywords: &["koktel", "piće", "čaša", "šank"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("copa de còctel"),
            keywords: &["bar", "copa", "copa de còctel", "còctel"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏕᏯᏅᎢ ᎠᏗᏔᏍᏗ ᎤᎸᏌᏗ"),
            keywords: &["ᎠᏕᏯᏅᎢ ᎠᏗᏔᏍᏗ ᎤᎸᏌᏗ", "ᎠᏗᏔᏍᏗ", "ᎠᏯᏔᎾᎸ", "ᎤᎸᏌᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("koktejlová sklenička"),
            keywords: &[
                "bar",
                "drink",
                "koktejl",
                "koktejlová sklenička",
                "nápoj",
                "pití",
                "sklenice",
                "sklo",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("gwydr coctel"),
            keywords: &["bar", "coctel", "diod", "gwydr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("cocktailglas"),
            keywords: &["cocktail", "cocktailglas", "martini"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Cocktailglas"),
            keywords: &["Bar", "Cocktail", "Cocktailglas"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κοκτέιλ"),
            keywords: &["κοκτέιλ", "μπαρ", "ποτήρι", "ποτό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("cocktail glass"),
            keywords: &["bar", "cocktail", "drink", "glass"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("copa de cóctel"),
            keywords: &["bar", "copa", "copa de cóctel", "cóctel", "restaurante"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kokteiliklaas"),
            keywords: &["baar", "jook", "klaas", "kokteil", "kokteiliklaas"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("koktel-kopa"),
            keywords: &["edari", "koktel", "koktel-kopa", "kopa", "taberna"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("جام کوکتل"),
            keywords: &["بار", "جام", "میخانه", "نوشیدن", "کوکتل"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("cocktaillasi"),
            keywords: &["baari", "cocktail", "cocktaillasi", "juoda", "lasi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("cocktail glass"),
            keywords: &["alak", "bar", "cocktail", "glass", "inumin"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("vínblandglas"),
            keywords: &[
                "barr",
                "cocktail",
                "drykkur",
                "glas",
                "vínbland",
                "vínblandglas",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cocktail"),
            keywords: &["cocktail", "verre"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("gloine mhanglaim"),
            keywords: &["gloine mhanglaim", "manglam", "teach tábhairne"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("glainne cocktail"),
            keywords: &["bàr", "cocktail", "deoch", "glainne", "òl"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cóctel"),
            keywords: &["bar", "bebida", "copa", "cóctel", "vermú"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કોકટ\u{ac7}ઇલ ગ\u{acd}લાસ"),
            keywords: &[
                "કોકટ\u{ac7}ઇલ",
                "કોકટ\u{ac7}ઇલ ગ\u{acd}લાસ",
                "બાર",
                "ર\u{ac7}સ\u{acd}ટોરન\u{acd}ટ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("gilashin cocktail"),
            keywords: &["cocktail", "gilashi", "gilashin cocktail", "mashaya", "sha"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כוס קוקטייל"),
            keywords: &["אלכוהול", "בר", "כוס קוקטייל", "משקה", "קוקטייל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("कॉकट\u{947}ल गिलास"),
            keywords: &[
                "कॉकट\u{947}ल",
                "कॉकट\u{947}ल गिलास",
                "बार",
                "र\u{947}स\u{94d}टोर\u{947}\u{902}ट",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("čaša za koktel"),
            keywords: &["bar", "koktel", "piće", "čaša", "čaša za koktel"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("koktélos pohár"),
            keywords: &["bár", "ital", "koktél", "koktélos pohár", "pohár"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կոկտեյլի բաժակ"),
            keywords: &["բաժակ", "բար", "խմել", "կոկտեյլ", "կոկտեյլի բաժակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("gelas cocktail"),
            keywords: &["bar", "gelas", "gelas cocktail", "koktail", "minuman"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("iko mmanya ọgbụgbụ"),
            keywords: &["iko", "iko mmanya ọgbụgbụ", "ogwe", "ṅụọ", "ọgbụgbụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kokteill"),
            keywords: &[
                "bar",
                "hanastél",
                "kokteilglas",
                "kokteill",
                "veitingastaður",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cocktail"),
            keywords: &["bar", "bicchiere da cocktail", "cocktail", "ristorante"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("カクテルグラス"),
            keywords: &["カクテル", "カクテルグラス", "グラス", "バー"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("gelas koktail"),
            keywords: &["bar", "gelas", "koktail", "unjukan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კოქტეილის ჭიქა"),
            keywords: &[
                "ბარი",
                "დალევა",
                "დასალევი",
                "კოქტეილი",
                "კოქტეილის ჭიქა",
                "სასმელი",
                "სმა",
                "ჭიქა",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("коктейль бокалы"),
            keywords: &["бар", "коктейль", "коктейль бокалы", "шыны", "ішімдік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("cocktailglas"),
            keywords: &["cocktailglas"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}រាក\u{17d2}រឡ\u{17bb}កម\u{17bd}យកែវ"),
            keywords: &[
                "កែវ",
                "បារ",
                "ផ\u{17b9}ក",
                "ស\u{17d2}រាក\u{17d2}រឡ\u{17bb}ក",
                "ស\u{17d2}រាក\u{17d2}រឡ\u{17bb}កម\u{17bd}យកែវ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಾಕ\u{ccd}\u{200c}ಟೇಲ\u{ccd} ಗ\u{ccd}ಲಾಸ\u{ccd}"),
            keywords: &[
                "ಕಾಕ\u{ccd}\u{200c}ಟೇಲ\u{ccd}",
                "ಕಾಕ\u{ccd}\u{200c}ಟೇಲ\u{ccd} ಗ\u{ccd}ಲಾಸ\u{ccd}",
                "ಕಾಕ\u{ccd}\u{200c}ಟೇಲ\u{ccd} ಲೋಟ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("칵테일"),
            keywords: &["칵테일", "칵테일글라스", "칵테일바", "칵테일잔"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("कॉकट\u{947}ल ग\u{94d}लास"),
            keywords: &["कॉकट\u{947}ल", "ग\u{94d}लास", "पिण\u{947}\u{902}", "बार"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("коктейль бокалы"),
            keywords: &["бар", "бокал", "ич", "коктейль", "коктейль бокалы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Cocktailglas"),
            keywords: &["Bar", "Cocktail", "Cocktailglas", "Gedrénks", "Glas"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຈອກແກ\u{ec9}ວຄ\u{eb1}ອກເທວ"),
            keywords: &["ຈອກຄ\u{eb1}ອກເທວ", "ຈອກແກ\u{ec9}ວຄ\u{eb1}ອກເທວ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kokteilio taurė"),
            keywords: &["baras", "gėrimas", "kokteilio taurė", "kokteilis", "taurė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kokteiļa glāze"),
            keywords: &[
                "bārs",
                "dzert",
                "dzēriens",
                "glāze",
                "kokteilis",
                "kokteiļa glāze",
                "martini",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("karāhe unuranu"),
            keywords: &["karāhe", "pae", "unu", "unuranu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("чаша за коктел"),
            keywords: &["бар", "коктел", "пијалак", "чаша", "чаша за коктел"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കോക\u{d4d}ക\u{d4d}\u{200c}ടെയിൽ ഗ\u{d4d}ല\u{d3e}സ\u{d4d}"),
            keywords: &[
                "കോക\u{d4d}ക\u{d4d} ടെയിൽ",
                "കോക\u{d4d}ക\u{d4d}\u{200c}ടെയിൽ",
                "കോക\u{d4d}ക\u{d4d}\u{200c}ടെയിൽ ഗ\u{d4d}ല\u{d3e}സ\u{d4d}",
                "ബ\u{d3e}ർ",
                "മദ\u{d4d}യം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("коктэйл"),
            keywords: &["баар", "коктэйл", "уух", "хундага"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कॉकट\u{947}ल ग\u{94d}लास"),
            keywords: &["कॉकट\u{947}ल", "ग\u{94d}लास", "प\u{947}य", "बार"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("gelas koktel"),
            keywords: &["bar", "gelas", "koktel", "minum"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("tazza tal-cocktails"),
            keywords: &["bar", "cocktail", "tazza", "tazza tal-cocktails", "xarba"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အရက\u{103a}စ\u{102f}\u{1036}ယမကာခ\u{103d}က\u{103a}"),
            keywords: &[
                "ကောက\u{103a}တေး",
                "ခ\u{103d}က\u{103a}",
                "ဘား",
                "သောက\u{103a}စရာ",
                "အရက\u{103a}စ\u{102f}\u{1036}ယမကာခ\u{103d}က\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("cocktailglass"),
            keywords: &["bar", "cocktaildrink", "cocktailglass", "drink"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ककट\u{947}ल गिलास"),
            keywords: &["ककट\u{947}ल", "गिलास", "पिउन\u{947}", "बार"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("cocktailglas"),
            keywords: &["bar", "cocktail", "cocktailglas", "drinken", "glas"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("cocktailglas"),
            keywords: &["bar", "cocktaildrink", "cocktailglas", "drink"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କକଟେଲ\u{b4d}\u{200d} ଗ\u{b4d}ଲ\u{b3e}ସ\u{b4d}\u{200d}"),
            keywords: &[
                "କକଟେଲ\u{b4d}\u{200c}",
                "କକଟେଲ\u{b4d}\u{200d} ଗ\u{b4d}ଲ\u{b3e}ସ\u{b4d}\u{200d}",
                "ଗ\u{b4d}ଲ\u{b3e}ସ",
                "ପ\u{b3e}ନୀୟ",
                "ବ\u{b3e}ର\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a4b}ਕਟ\u{a47}ਲ ਦਾ ਗਿਲਾਸ"),
            keywords: &[
                "ਕ\u{a4b}ਕਟ\u{a47}ਲ",
                "ਕ\u{a4b}ਕਟ\u{a47}ਲ ਗਲਾਸ",
                "ਕ\u{a4b}ਕਟ\u{a47}ਲ ਦਾ ਗਿਲਾਸ",
                "ਬਾਰ",
                "ਹ\u{a4b}ਟਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کاک ٹیل دا گلاس"),
            keywords: &["سیخ", "شراباں دا آمیزہ", "شربت", "کاک ٹیل دا گلاس", "گلاس"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kọ\u{301}ktél Glas"),
            keywords: &[
                "Baa",
                "Drink",
                "Glas",
                "Kọ\u{301}ktel: Họ\u{301}t Drin Wé Dẹm Míks Wit Frút Juz",
                "Kọ\u{301}ktél Glas",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kieliszek z koktajlem"),
            keywords: &["kieliszek", "kieliszek z koktajlem", "koktajl"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د کاکټیل ګلاس"),
            keywords: &["بار، کاکټيل، څکل، ګيلاس", "د کاکټیل ګلاس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("coquetel"),
            keywords: &["bar", "coquetel", "taça de coquetel"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("copo de cocktail"),
            keywords: &["bar", "beber", "cocktail", "copo", "copo de cocktail"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("cocktail qiru"),
            keywords: &["bar", "cocktail", "qiru", "upyana"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pahar de cocktail"),
            keywords: &["bar", "băutură", "cocktail", "pahar", "pahar de cocktail"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-317"),
            keywords: &["E10-317"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("коктейль"),
            keywords: &["бар", "бокал", "коктейль", "напиток"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikirahure cy’uruvange rw’inzoga"),
            keywords: &[
                "akabari",
                "ikirahure cy’uruvange rw’inzoga",
                "ikirahuri",
                "kunywa",
                "uruvange rw’imbuto",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪاڪٽيل جو گلاس"),
            keywords: &["بار، ڪاڪٽيل، پيئڻ، گلاس", "ڪاڪٽيل جو گلاس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කොක\u{dca}ටේල\u{dca} ව\u{dd3}ද\u{dd4}ර\u{dd4}ව"),
            keywords: &[
                "කොක\u{dca}ටේල\u{dca}",
                "තැබෑර\u{dd4}ම",
                "ප\u{dcf}නය ක\u{dd2}ර\u{dd3}ම",
                "ව\u{dd3}ද\u{dd4}ර\u{dd4}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kokteilový pohár"),
            keywords: &["bar", "drink", "kokteilový pohár", "koktejl", "pohár"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kozarec za koktajl"),
            keywords: &["bar", "koktajl", "kozarec", "kozarec za koktajl", "pijača"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("galaas kooktayl ah"),
            keywords: &["baar", "cab", "galaas", "galaas kooktayl ah", "kooktayl"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gotë kokteji"),
            keywords: &["bar", "gotë", "gotë kokteji", "koktej", "pije"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("коктел"),
            keywords: &["бaр", "кoктeл", "коктел", "пићe", "чaшa"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("koktel"),
            keywords: &["bar", "koktel", "piće", "čaša"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("cocktailglas"),
            keywords: &["cocktail", "cocktailglas", "drink"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("glasi ya kokteli"),
            keywords: &["baa", "glasi", "glasi ya kokteli", "kinywaji", "kokteli"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("க\u{bbe}க\u{bcd}டெயில\u{bcd} கிள\u{bbe}ஸ\u{bcd}"),
            keywords: &[
                "உணவகம\u{bcd}",
                "க\u{bbe}க\u{bcd}டெயில\u{bcd}",
                "க\u{bbe}க\u{bcd}டெயில\u{bcd} கிள\u{bbe}ஸ\u{bcd}",
                "ப\u{bbe}னம\u{bcd}",
                "மதுக\u{bcd}கலவை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c3e}క\u{c4d}\u{200c}ట\u{c46}య\u{c3f}ల\u{c4d} గ\u{c4d}ల\u{c3e}స\u{c4d}"),
            keywords: &[
                "క\u{c3e}క\u{c4d}\u{200c}ట\u{c46}య\u{c3f}ల\u{c4d}",
                "క\u{c3e}క\u{c4d}\u{200c}ట\u{c46}య\u{c3f}ల\u{c4d} గ\u{c4d}ల\u{c3e}సు",
                "క\u{c3e}క\u{c4d}\u{200c}ట\u{c46}య\u{c3f}ల\u{c4d} గ\u{c4d}ల\u{c3e}స\u{c4d}",
                "బ\u{c3e}ర\u{c4d}",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("стакани коктейл"),
            keywords: &["бар", "коктейл", "нӯшидан", "стакан", "стакани коктейл"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ค\u{e47}อกเทล"),
            keywords: &["ค\u{e47}อกเทล", "แก\u{e49}วค\u{e47}อกเทล"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kokteýl bulgury"),
            keywords: &["bar", "bulgur", "içmek", "kokteýl", "kokteýl bulgury"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ipu sioʻata paati"),
            keywords: &["ipu sioʻata paati"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kokteyl kadehi"),
            keywords: &["bar", "kokteyl bardağı", "kokteyl kadehi", "restoran"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كوكتېل رومكىسى"),
            keywords: &["ئىچىملك", "رومكا", "قەلەمچە", "كوكتېل", "كوكتېل رومكىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("бокал для коктейлю"),
            keywords: &["бар", "бокал", "бокал для коктейлю", "коктейль", "пити"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کاک ٹیل گلاس"),
            keywords: &["بار", "پینا", "کاک ٹیل", "کاک ٹیل گلاس", "گلاس"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kokteyl qadahi"),
            keywords: &["bar", "ichimlik", "kokteyl", "kokteyl qadahi", "stakan"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ly cocktail"),
            keywords: &["cocktail", "ly", "quán bar", "đồ uống"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kaasu koktel"),
            keywords: &["kaasu koktel", "koktel", "laat", "naan", "weer"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iglasi ye-cocktail"),
            keywords: &[
                "i-cocktail",
                "ibhari",
                "iglasi",
                "iglasi ye-cocktail",
                "isiselo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Gilasi Ounjẹ Amulumala"),
            keywords: &["Gilasi Ounjẹ Amulumala", "ilé ọtí", "ónjẹ àmúlùmálà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("雞尾酒杯"),
            keywords: &["玻璃杯", "酒吧", "雞尾酒", "雞尾酒杯", "飲酒"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("鸡尾酒杯"),
            keywords: &["玻璃杯", "酒吧", "饮酒", "鸡尾酒", "鸡尾酒杯"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("鸡尾酒"),
            keywords: &["杯", "酒", "鸡尾酒"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("雞尾酒"),
            keywords: &["酒", "雞尾酒"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("雞尾酒杯"),
            keywords: &["調酒", "酒", "雞尾酒", "雞尾酒杯"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ingilazi yecocktail"),
            keywords: &[
                "ibha",
                "icocktail",
                "ingilazi",
                "ingilazi yecocktail",
                "isiphuzo",
            ],
        },
    ],
};
#[doc = "🍹"]
pub const TROPICAL_DRINK: crate::Emoji = crate::Emoji {
    glyph: "🍹",
    codepoint: "1F379",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "tropical drink",
    group: "Food & Drink",
    subgroup: "drink",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("tropiese drankie"),
            keywords: &["drankie", "drink", "kroeg", "tropies", "tropiese drankie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ትሮፒካል መጠጥ"),
            keywords: &["ትሮፒካል", "ትሮፒካል መጠጥ", "አሞሌ", "ጠጣ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مشروب استوائي"),
            keywords: &["محل تقديم المشروبات", "مشروب", "مشروب استوائي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ট\u{9cd}ৰ’পিকেল ড\u{9cd}ৰিংক"),
            keywords: &[
                "ট\u{9cd}ৰ’পিকেল",
                "ট\u{9cd}ৰ’পিকেল ড\u{9cd}ৰিংক",
                "প\u{9be}নীয\u{9bc}",
                "ব\u{9be}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("tropik içki"),
            keywords: &["bar", "içmək", "tropik", "tropik içki"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("трапічны напой"),
            keywords: &["бар", "напой", "трапічны"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Тропическо питие"),
            keywords: &["Тропическо питие", "бар", "питие", "тропическо"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ট\u{9cd}রপিক\u{9cd}য\u{9be}ল ড\u{9cd}রিঙ\u{9cd}ক"),
            keywords: &[
                "ক\u{9cd}র\u{9be}ন\u{9cd}তীয\u{9bc}",
                "ট\u{9cd}রপিক\u{9cd}য\u{9be}ল ড\u{9cd}রিঙ\u{9cd}ক",
                "প\u{9be}ন কর\u{9be}",
                "ব\u{9be}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("koktel trovanel"),
            keywords: &["evaj", "koktel", "trovanel"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("tropsko piće"),
            keywords: &["piće", "tropsko", "šank"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("beguda tropical"),
            keywords: &["bar", "beguda", "tropical"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏧᎦᏃᏩ ᎠᏗᏔᏍᏗ"),
            keywords: &["ᎠᏗᏔᏍᏗ", "ᎠᏯᏔᎾᎸ", "ᎤᏗᏞᎩ", "ᏧᎦᏃᏩ ᎠᏗᏔᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("tropický koktejl"),
            keywords: &["bar", "drink", "koktejl", "nápoj", "pití", "tropický"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("diod drofannol"),
            keywords: &["bar", "diod", "diod drofannol", "trofannol"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("tropisk drink"),
            keywords: &["cocktail", "tropisk drink"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Cocktail"),
            keywords: &["Bar", "Cocktail", "exotisches Getränk"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τροπικό ποτό"),
            keywords: &["μπαρ", "ποτό", "τροπικό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("tropical drink"),
            keywords: &["bar", "drink", "tropical"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bebida tropical"),
            keywords: &["bar", "bebida", "restaurante", "tropical"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "bar",
                "bebida",
                "cóctel",
                "restaurante",
                "trago",
                "tropical",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["bar", "bebida", "cóctel", "trago", "tropical"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["bar", "bebida", "cóctel", "trago", "tropical"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("troopiline jook"),
            keywords: &["baar", "jook", "troopiline"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("edari tropikala"),
            keywords: &["edan", "edari", "edari tropikala", "taberna", "tropikal"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نوشیدنی استوایی"),
            keywords: &["استوایی", "بار", "میخانه", "نوشیدن", "نوشیدنی استوایی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("trooppinen drinkki"),
            keywords: &["baari", "juoda", "lasi", "trooppinen drinkki"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tropical drink"),
            keywords: &["bar", "inumin", "tropical", "tropical drink"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("tropiskurdrykkur"),
            keywords: &["barr", "drykkur", "tropiskur", "tropiskurdrykkur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cocktail tropical"),
            keywords: &["cocktail tropical", "verre"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["cocktail", "tropical", "verre"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("deoch thrópaiceach"),
            keywords: &["deoch", "deoch thrópaiceach", "puins", "teach tábhairne"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("deoch thropaigeach"),
            keywords: &["bàr", "deoch", "deoch thropaigeach", "tropaigeach", "òl"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("bebida tropical"),
            keywords: &["bar", "bebida", "bebida tropical", "copa"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઉષ\u{acd}ણકટિબ\u{a82}ધીય પીણ\u{ac1}\u{a82}"),
            keywords: &[
                "ઉષ\u{acd}ણકટિબ\u{a82}ધીય",
                "પીણ\u{ac1}\u{a82}",
                "બાર",
                "ર\u{ac7}સ\u{acd}ટોરન\u{acd}ટ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("abinsha na wurin zafi"),
            keywords: &["abinsha na wurin zafi", "mashaya", "na wurin zafi", "sha"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קוקטייל טרופי"),
            keywords: &["אלכוהול", "בר", "טרופי", "משקה", "קוקטייל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ट\u{94d}रॉपिकल प\u{947}य"),
            keywords: &[
                "ऊष\u{94d}णकटिब\u{902}धीय",
                "ट\u{94d}रॉपिकल प\u{947}य",
                "प\u{947}य",
                "बार",
                "र\u{947}स\u{94d}टोर\u{947}\u{902}ट",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tropsko piće"),
            keywords: &["bar", "piće", "tropi", "tropsko piće"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("trópusi ital"),
            keywords: &["bár", "ital", "koktél", "trópusi"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("արևադարձային ընպելիք"),
            keywords: &["արևադարձային", "արևադարձային ընպելիք", "բար", "խմել"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("minuman tropis"),
            keywords: &["bar", "minuman", "tropis"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("mmanya ebe okpomọọkụ"),
            keywords: &["ebe okpomọọkụ", "mmanya ebe okpomọọkụ", "ogwe", "ṅụọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("suðrænn kokteill"),
            keywords: &[
                "bar",
                "drykkur",
                "glas",
                "suðrænn kokteill",
                "veitingastaður",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cocktail tropicale"),
            keywords: &[
                "bar",
                "bere",
                "cocktail tropicale",
                "ristorante",
                "tropicale",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("トロピカルドリンク"),
            keywords: &["カクテル", "トロピカル", "トロピカルドリンク", "バー"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("unjukan cara tropis"),
            keywords: &["bar", "tropis", "unjukan", "unjukan cara tropis"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ტროპიკული სასმელი"),
            keywords: &["ბარი", "დალევა", "დასალევი", "სასმელი", "სმა", "ტროპიკული"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тропикалық сусын"),
            keywords: &["бар", "тропикалық", "тропикалық сусын", "ішімдік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("tropisk drink"),
            keywords: &["cocktail", "tropisk drink"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ទ\u{17b9}កផ\u{17d2}លែឈើស\u{17d2}រស\u{17cb}ម\u{17bd}យកែវ"),
            keywords: &[
                "ត\u{17d2}រ\u{17bc}ព\u{17b7}ច",
                "ទ\u{17b9}កផ\u{17d2}លែឈើស\u{17d2}រស\u{17cb}ម\u{17bd}យកែវ",
                "បារ",
                "ផ\u{17b9}ក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಉಷ\u{ccd}ಣವಲಯದ ಪಾನೀಯ"),
            keywords: &["ಉಷ\u{ccd}ಣವಲಯದ ಪಾನೀಯ", "ಪಾನೀಯ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("음료수"),
            keywords: &["바", "음료수"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उष\u{94d}णकटीब\u{902}धीय पिण\u{947}\u{902}"),
            keywords: &["उष\u{94d}णकटीब\u{902}धीय", "पिण\u{947}\u{902}", "बार"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тропикалык суусундук"),
            keywords: &["бар", "ич", "тропикалык", "тропикалык суусундук"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("exotescht Gedrénks"),
            keywords: &["Bar", "Gedrénks", "exotesch", "exotescht Gedrénks"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຄ\u{eb7}\u{ec8}ອງດ\u{eb7}\u{ec8}ມເຂດຮ\u{ec9}ອນ"),
            keywords: &[
                "ເຂດຮ\u{ec9}ອນ",
                "ເຄ\u{eb7}\u{ec8}ອງດ\u{eb7}\u{ec8}ມ",
                "ເຄ\u{eb7}\u{ec8}ອງດ\u{eb7}\u{ec8}ມເຂດຮ\u{ec9}ອນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("tropinis gėrimas"),
            keywords: &["baras", "gėrimas", "tropinis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("tropu kokteilis"),
            keywords: &[
                "bārs",
                "dzert",
                "dzēriens",
                "glāze",
                "kokteilis",
                "tropu kokteilis",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("unu pārūrū"),
            keywords: &["pae", "pārūrū", "unu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("тропски пијалак"),
            keywords: &["бар", "пијалак", "тропски"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ട\u{d4d}രോപ\u{d4d}പിക\u{d4d}കൽ ഡ\u{d4d}രിങ\u{d4d}ക\u{d4d}"),
            keywords: &[
                "ട\u{d4d}രോപ\u{d4d}പിക\u{d4d}കൽ ഡ\u{d4d}രിങ\u{d4d}ക\u{d4d}",
                "ഡ\u{d4d}രിങ\u{d4d}ക\u{d4d}",
                "ബ\u{d3e}ർ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("жимсний ундаа"),
            keywords: &["баар", "жимсний ундаа", "уух юм", "халуун орны"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ट\u{94d}रॉपिकल प\u{947}य"),
            keywords: &["ट\u{94d}रॉपिकल", "प\u{947}य", "बार"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("minuman tropika"),
            keywords: &["bar", "minum", "minuman tropika", "tropika"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("xarba tropikali"),
            keywords: &["bar", "tropikali", "xarba"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အပ\u{1030}ပ\u{102d}\u{102f}င\u{103a}းဒေသ ဖျော\u{103a}ရေ"),
            keywords: &[
                "ဘား",
                "သောက\u{103a}စရာ",
                "အပ\u{1030}ပ\u{102d}\u{102f}င\u{103a}း",
                "အပ\u{1030}ပ\u{102d}\u{102f}င\u{103a}းဒေသ ဖျော\u{103a}ရေ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("tropisk drink"),
            keywords: &["bar", "drink", "juice", "tropisk drink"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("उष\u{94d}णप\u{94d}रद\u{947}शीय प\u{947}य पद\u{94d}दार\u{94d}थ"),
            keywords: &[
                "उष\u{94d}णप\u{94d}रद\u{947}शीय",
                "उष\u{94d}णप\u{94d}रद\u{947}शीय प\u{947}य पद\u{94d}दार\u{94d}थ",
                "पिउन\u{947}",
                "बार",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("tropisch drankje"),
            keywords: &["bar", "drinken", "tropisch", "tropisch drankje"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("tropisk drink"),
            keywords: &["bar", "drink", "jus", "tropisk drink"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଗ\u{b4d}ରୀଷ\u{b4d}ମମଣ\u{b4d}ଡଳୀୟ ପ\u{b3e}ନୀୟ"),
            keywords: &[
                "ଉଷ\u{b4d}ମ ମଣ\u{b4d}ଡଳ",
                "ଗ\u{b4d}ରୀଷ\u{b4d}ମମଣ\u{b4d}ଡଳୀୟ ପ\u{b3e}ନୀୟ",
                "ପ\u{b3e}ନୀୟ",
                "ବ\u{b3e}ର\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਦਾਬਹਾਰ ਡ\u{a4d}ਰਿ\u{a70}ਕ"),
            keywords: &[
                "ਪੀਣਾ",
                "ਬਾਰ",
                "ਸਦਾਬਹਾਰ",
                "ਸਦਾਬਹਾਰ ਡ\u{a4d}ਰਿ\u{a70}ਕ",
                "ਹ\u{a4b}ਟਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("گرمی دے مشروب"),
            keywords: &["سیخ", "شدید گرم", "شربت", "گرمی دے مشروب"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Họ\u{301}t Ríjọn Drink"),
            keywords: &["Baa", "Drink", "Họ\u{301}t Ríjọn", "Họ\u{301}t Ríjọn Drink"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("drink tropikalny"),
            keywords: &["bar", "drink tropikalny", "tropikalny"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ګرمسېر څښاک"),
            keywords: &["بار، څښاک، ګرمسېر", "ګرمسېر څښاک"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bebida tropical"),
            keywords: &["bar", "bebida", "coquetel de frutas", "drink", "tropical"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["bar", "bebida", "tropical"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tropical upyana"),
            keywords: &["bar", "tropical", "upyana"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("băutură tropicală"),
            keywords: &["bar", "băutură", "băutură tropicală", "exotic", "tropical"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-318"),
            keywords: &["E10-318"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("тропический коктейль"),
            keywords: &[
                "зонтик",
                "напиток",
                "прохладительный",
                "соломинка",
                "тропики",
                "тропический коктейль",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikinyobwa kidasindisha"),
            keywords: &["akabari", "gishyushye", "ikinyobwa kidasindisha", "kunywa"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مداريني مشروب"),
            keywords: &["بار، مشروب، مداريني", "مداريني مشروب"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("න\u{dd2}වර\u{dca}තන ප\u{dcf}නය"),
            keywords: &[
                "තැබෑර\u{dd4}ම",
                "න\u{dd2}වර\u{dca}තන",
                "න\u{dd2}වර\u{dca}තන ප\u{dcf}නය",
                "ප\u{dcf}නය ක\u{dd2}ර\u{dd3}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("tropický nápoj"),
            keywords: &["bar", "drink", "tropický", "tropický nápoj"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("tropska pijača"),
            keywords: &["bar", "pijača", "tropska pijača", "tropsko"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("khamriga kulul"),
            keywords: &["baar", "khamri", "khamriga kulul", "kulul"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("pije tropikale"),
            keywords: &["bar", "pi", "pije", "tropikale"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("тропско пиће"),
            keywords: &["бaр", "пићe", "трoпско", "тропско пиће"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("tropsko piće"),
            keywords: &["bar", "piće", "tropsko"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tropisk drink"),
            keywords: &["drink", "tropisk"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kinywaji cha tropiki"),
            keywords: &["baa", "kinywaji", "kinywaji cha tropiki", "tropikali"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பழச\u{bcd}ச\u{bbe}று"),
            keywords: &[
                "உணவகம\u{bcd}",
                "பழச\u{bcd}ச\u{bbe}று",
                "ப\u{bbe}னம\u{bcd}",
                "விருந\u{bcd}து",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఉష\u{c4d}ణమండల ప\u{c3e}న\u{c40}యం"),
            keywords: &[
                "ఉష\u{c4d}ణమండల ప\u{c3e}న\u{c40}యం",
                "ప\u{c3e}న\u{c40}యం",
                "బ\u{c3e}ర\u{c4d}",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
                "వ\u{c47}డ\u{c3f} ప\u{c3e}న\u{c40}యం",
                "వ\u{c47}డ\u{c3f}వ\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("нӯшокии тропикӣ"),
            keywords: &["бар", "нӯшидан", "нӯшокии тропикӣ", "тропикӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เคร\u{e37}\u{e48}องด\u{e37}\u{e48}มผสมน\u{e49}ำผลไม\u{e49}"),
            keywords: &[
                "บาร\u{e4c}",
                "ผลไม\u{e49}",
                "เคร\u{e37}\u{e48}องด\u{e37}\u{e48}ม",
                "เคร\u{e37}\u{e48}องด\u{e37}\u{e48}มผสมน\u{e49}ำผลไม\u{e49}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("tropiki içgi"),
            keywords: &["bar", "içmek", "tropiki", "tropiki içgi"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻotai"),
            keywords: &["ʻotai"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("tropik içecek"),
            keywords: &["bar", "içecek", "restoran", "tropik"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئىسسىق بەلباغ ئىچىملىكى"),
            keywords: &["ئىسسىق", "ئىسسىق بەلباغ ئىچىملىكى", "ئىچىملىك", "قاۋاق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("тропічний напій"),
            keywords: &["бар", "пити", "тропічний", "тропічний напій"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ٹراپکل مشروب"),
            keywords: &["بار", "ٹراپکل", "ٹراپکل مشروب", "پینا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tropik ichimlik"),
            keywords: &["bar", "ichimlik", "tropik"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đồ uống nhiệt đới"),
            keywords: &["nhiệt đới", "quán bar", "đồ uống", "đồ uống nhiệt đới"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("naan tàngoor"),
            keywords: &["laat", "naan", "tàngoor"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isiselo setropiki"),
            keywords: &["ibhari", "isiselo", "isiselo setropiki", "itropiki"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ohun Mimu Akoko Oorun"),
            keywords: &[
                "Ohun Mimu Akoko Oorun",
                "ilé ọtí",
                "ohun mímu",
                "ọlọ\u{301}pẹ",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("夏日飲品"),
            keywords: &["夏日", "夏日飲品", "酒吧", "飲品"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("夏日饮品"),
            keywords: &["夏日", "夏日饮品", "酒吧", "饮品"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("热带水果饮料"),
            keywords: &["热带水果饮料", "饮料"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("熱帶水果飲料"),
            keywords: &["果汁", "熱帶水果飲料"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("熱帶飲品"),
            keywords: &["熱帶飲品", "調酒", "雞尾酒", "飲料"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isiphuzo esipholisayo"),
            keywords: &["ibha", "isiphuzo", "isiphuzo esipholisayo", "okupholile"],
        },
    ],
};
#[doc = "🍺"]
pub const BEER_MUG: crate::Emoji = crate::Emoji {
    glyph: "🍺",
    codepoint: "1F37A",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "beer mug",
    group: "Food & Drink",
    subgroup: "drink",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("bierbeker"),
            keywords: &["beker", "bier", "bierbeker", "drink", "kroeg"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የድራፍት ብርጭቆ"),
            keywords: &["ቢራ", "አሞሌ", "ኩባያ", "የድራፍት ብርጭቆ", "ጠጣ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كأس بيرة"),
            keywords: &["بار", "بيرة", "كأس بيرة", "ماغ بيرة", "مطعم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বীয\u{9bc}েৰৰ মগ"),
            keywords: &[
                "প\u{9be}নীয\u{9bc}",
                "ব\u{9be}ৰ",
                "বীয\u{9bc}েৰ",
                "বীয\u{9bc}েৰৰ মগ",
                "ম\u{9be}গ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("pivə krujkası"),
            keywords: &["bar", "içmək", "krujka", "pivə", "pivə krujkası"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("куфель піва"),
            keywords: &["бар", "куфель", "напой", "піва"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Халба бира"),
            keywords: &["Халба бира", "бар", "бира", "питие", "халба"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বিয\u{9bc}\u{9be}রের মগ"),
            keywords: &[
                "প\u{9be}ন কর\u{9be}",
                "ব\u{9be}র",
                "বিয\u{9bc}\u{9be}র",
                "বিয\u{9bc}\u{9be}রের মগ",
                "মগ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("chopad bier"),
            keywords: &["bier", "chop", "chopad bier", "evaj"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("krigla piva"),
            keywords: &["krigla", "krigla piva", "pivo", "piće", "šank"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("gerra de cervesa"),
            keywords: &["cervesa", "gerra", "gerra de cervesa"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏬᎩᏢᏍᎩ ᎠᏟᏍᏙᏗ"),
            keywords: &["ᎠᏗᏔᏍᏗ", "ᎠᏬᎩᏢᏍᎩ", "ᎠᏬᎩᏢᏍᎩ ᎠᏟᏍᏙᏗ", "ᎠᏯᏔᎾᎸ", "ᎦᏓᎫᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("půllitr piva"),
            keywords: &[
                "bar",
                "nápoj",
                "pití",
                "pivo",
                "půllitr",
                "půllitr piva",
                "sklenice",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("mwg cwrw"),
            keywords: &["bar", "cwrw", "diod", "mwg"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ølkrus"),
            keywords: &["krus", "krus øl", "ølglas", "ølkrus"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Bierkrug"),
            keywords: &["Bar", "Bier", "Bierkrug", "Krug"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ποτήρι μπίρας"),
            keywords: &["μπαρ", "μπύρα", "ποτήρι μπίρας", "ποτήρι μπύρας", "ποτό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("beer mug"),
            keywords: &["bar", "beer", "drink", "mug"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["bar", "beer", "drink", "mug", "stein"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("jarra de cerveza"),
            keywords: &["bar", "cerveza", "jarra", "jarra de cerveza", "restaurante"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("tarro de cerveza"),
            keywords: &[
                "bar",
                "bebida",
                "jarra",
                "jarro",
                "restaurante",
                "tarro de cerveza",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("õllekann"),
            keywords: &["baar", "jook", "kann", "õllekann", "õlu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("garagardo-pitxerra"),
            keywords: &[
                "edari",
                "garagardo",
                "garagardo-pitxer",
                "garagardo-pitxerra",
                "pitxer",
                "taberna",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("لیوان آب\u{200c}جو"),
            keywords: &["آبجو", "بار", "لیوان", "ماگ", "میخانه", "نوشیدن"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("oluttuoppi"),
            keywords: &["baari", "juoda", "olut", "oluttuoppi", "tuoppi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("beer mug"),
            keywords: &["alak", "bar", "beer", "inumin", "mug"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("ølkrúss"),
            keywords: &["barr", "drykkur", "krúss", "øl", "ølkrúss"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("chope"),
            keywords: &["bière", "chope"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("chope de bière"),
            keywords: &["bar", "bière", "boisson", "chope", "chope de bière"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("pionta beorach"),
            keywords: &[
                "beoir",
                "gloine",
                "gloine beorach",
                "gloine bheorach",
                "pionta beorach",
                "teach tábhairne",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("muga beòir"),
            keywords: &["beòir", "bàr", "deoch", "leann", "muga", "òl"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cervexa"),
            keywords: &["bar", "cervexa", "xerra"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બીઅર મગ"),
            keywords: &["બાર", "બીઅર", "મગ", "ર\u{ac7}સ\u{acd}ટોરન\u{acd}ટ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kofin giya"),
            keywords: &["giya", "kofi", "kofin giya", "mashaya", "sha"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כוס בירה"),
            keywords: &["אלכוהול", "בירה", "בר", "כוס", "משקה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बियर, बियर मग"),
            keywords: &[
                "बार",
                "बियर",
                "बियर, बियर मग",
                "मग",
                "र\u{947}स\u{94d}टोर\u{947}\u{902}ट",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("krigla za pivo"),
            keywords: &["bar", "krigla", "krigla za pivo", "pivo", "piće"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("söröskorsó"),
            keywords: &["bár", "ital", "korsó", "sör", "söröskorsó"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("գարեջրի գավաթ"),
            keywords: &["բար", "գավաթ", "գարեջուր", "գարեջրի գավաթ", "խմել"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("mug bir"),
            keywords: &["bar", "bir", "minuman", "mug"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("iko mmanya biya"),
            keywords: &[
                "iko mmanya biya",
                "mmanya biya",
                "nnukwu iko",
                "ogwe",
                "ṅụọ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("bjór"),
            keywords: &["bar", "bjór", "bjórglas", "glas", "veitingastaður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("boccale di birra"),
            keywords: &["bar", "boccale", "boccale di birra", "ristorante"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ビールジョッキ"),
            keywords: &["ジョッキ", "バー", "ビール", "ビールジョッキ", "居酒屋"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("gelas bir"),
            keywords: &["bar", "bir", "gelas bir", "unjukan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ლუდის კათხა"),
            keywords: &[
                "ბარი",
                "დალევა",
                "დასალევი",
                "კათხა",
                "ლუდი",
                "ლუდის კათხა",
                "სასმელი",
                "სმა",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сыра саптыаяғы"),
            keywords: &["бар", "саптыаяқ", "сыра", "сыра саптыаяғы", "ішімдік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ølkrus"),
            keywords: &["krus", "krus øl", "ølglas", "ølkrus"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}រាបៀម\u{17bd}យកែវ"),
            keywords: &[
                "កែវ",
                "បារ",
                "ផ\u{17b9}ក",
                "ស\u{17d2}រាបៀ",
                "ស\u{17d2}រាបៀម\u{17bd}យកែវ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{cbf}ಯರ\u{ccd}\u{200c} ಮಗ\u{ccd}\u{200c}"),
            keywords: &[
                "ಬ\u{cbf}ಯರ\u{ccd}",
                "ಬ\u{cbf}ಯರ\u{ccd}\u{200c} ಮಗ\u{ccd}\u{200c}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("맥주잔"),
            keywords: &["맥주잔", "맥주컵", "술집", "호프"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बीयराच\u{947}\u{902} मग"),
            keywords: &[
                "पिण\u{947}\u{902}",
                "बार",
                "बियर",
                "बीयराच\u{947}\u{902} मग",
                "मग",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("сыра кружкасы"),
            keywords: &["бар", "ич", "кружка", "сыра", "сыра кружкасы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Klensch"),
            keywords: &["Bar", "Béier", "Gedrénks", "Klensch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແກ\u{ec9}ວເບຍ"),
            keywords: &["ຈອກ", "ດ\u{eb7}\u{ec8}ມ", "ບາ", "ເບຍ", "ແກ\u{ec9}ວເບຍ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("alaus bokalas"),
            keywords: &["alaus bokalas", "alus", "baras", "gėrimas", "puodelis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("alus kauss"),
            keywords: &["alus", "bārs", "dzert", "dzēriens", "kauss"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("maka pia"),
            keywords: &["maka", "pae", "pia", "unu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("кригла пиво"),
            keywords: &["бар", "кригла", "пиво", "пијалак"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ബിയർ ബഗ\u{d4d}"),
            keywords: &[
                "ബ\u{d3e}ർ",
                "ബിയർ",
                "ബിയർ ഗ\u{d4d}ല\u{d3e}സ\u{d4d}",
                "ബിയർ ബഗ\u{d4d}",
                "ബീർ",
                "മഗ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("шар айраг"),
            keywords: &["аяга", "баар", "уух", "шар айраг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("बीअरचा मग"),
            keywords: &["प\u{947}य", "बार", "बीअर", "बीअरचा मग", "मग"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kole bir"),
            keywords: &["bar", "bir", "kole", "minum"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("magg birra"),
            keywords: &["bar", "birra", "magg", "xarba"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဘ\u{102e}ယာ မတ\u{103a}ခ\u{103d}က\u{103a}"),
            keywords: &[
                "ဘား",
                "ဘ\u{102e}ယာ",
                "မတ\u{103a}ခ\u{103d}က\u{103a}",
                "သောက\u{103a}စရာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("ølkrus"),
            keywords: &["bar", "halvliter", "pils", "pilsner", "ølglass", "ølkrus"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बियरको मग"),
            keywords: &["पिउन\u{947}", "बार", "बियर", "बियरको मग", "मग"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bierglas"),
            keywords: &["bar", "bier", "bierglas", "drinken", "glas"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("ølkrus"),
            keywords: &["bar", "halvliter", "pils", "pilsner", "ølglas", "ølkrus"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3f}ଅର\u{b4d} ମଗ\u{b4d}"),
            keywords: &[
                "ପ\u{b3e}ନୀୟ",
                "ବ\u{b3e}ର\u{b4d}",
                "ବ\u{b3f}ଅର\u{b4d} ମଗ\u{b4d}",
                "ମଗ\u{b4d}\u{200c}",
                "ମଦ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬੀਅਰ ਦਾ ਪਿਆਲਾ"),
            keywords: &["ਪਿਆਲਾ", "ਬਾਰ", "ਬੀਅਰ", "ਬੀਅਰ ਦਾ ਪਿਆਲਾ", "ਹ\u{a4b}ਟਲ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("شراب دا پیالہ"),
            keywords: &["سیخ", "شراب دا پیالہ", "شربت", "مگ", "ہلکی شراب"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Biá Kọp"),
            keywords: &["Baa", "Bia", "Biá Kọp", "Drink", "Mọg"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kufel piwa"),
            keywords: &["kufel", "kufel piwa", "kufel z piwem"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بير پياله"),
            keywords: &["بار، بير، څکل، پياله", "بير پياله"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cerveja"),
            keywords: &["bar", "caneca", "caneca de cerveja", "cerveja", "chopp"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("caneca de cerveja"),
            keywords: &["bar", "beber", "caneca", "caneca de cerveja", "cerveja"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("cerveza jumiwa"),
            keywords: &["bar", "cerveza", "jumiwa", "upyana"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("halbă de bere"),
            keywords: &["bar", "bere", "băutură", "halbă", "halbă de bere"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-319"),
            keywords: &["E10-319"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("кружка пива"),
            keywords: &[
                "кружка",
                "кружка пива",
                "пена",
                "пенное",
                "пивная кружка",
                "пиво",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikirahure cy’inzoga"),
            keywords: &[
                "akabari",
                "igikombe",
                "ikirahure cy’inzoga",
                "inzoga",
                "kunywa",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بيئر مگ"),
            keywords: &["بار، بيئر، مشروب، مگ", "بيئر مگ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බ\u{dd2}යර\u{dca} ජෝග\u{dca}ග\u{dd4}ව"),
            keywords: &[
                "තැබෑර\u{dd4}ම",
                "බ\u{dd2}යර\u{dca}",
                "බ\u{dd2}යර\u{dca} ජෝග\u{dca}ග\u{dd4}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("pivový pohár"),
            keywords: &["bar", "drink", "pivo", "pivový pohár", "pohár"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vrček za pivo"),
            keywords: &["bar", "pijača", "pivo", "vrček", "vrček za pivo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("koob khamri ah"),
            keywords: &["baar", "cab", "khamri", "koob", "koob khamri ah"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("krikëll birre"),
            keywords: &["bar", "birrë", "krikëll", "krikëll birre", "pije"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кригла пива"),
            keywords: &["бaр", "криглa", "кригла пива", "пивo", "пићe", "чaшa"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("krigla piva"),
            keywords: &["bar", "krigla", "krigla piva", "pivo", "piće", "čaša"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ölstop"),
            keywords: &["glas", "stop", "öl", "ölglas", "ölstop"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kikombe cha bia"),
            keywords: &["baa", "bia", "kikombe cha bia", "kinywaji", "kukombe"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["baa", "bia", "kikombe", "kikombe cha bia", "kinywaji"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ப\u{bc0}ர\u{bcd} குவளை"),
            keywords: &[
                "உணவகம\u{bcd}",
                "குவளை",
                "ப\u{bc0}ர\u{bcd}",
                "விருந\u{bcd}து",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బ\u{c40}ర\u{c4d} మగ\u{c4d}గు"),
            keywords: &[
                "బ\u{c3e}ర\u{c4d}",
                "బ\u{c40}రు",
                "బ\u{c40}ర\u{c4d} మగ\u{c4d}గు",
                "మగ\u{c4d}గు",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дӯлчаи пиво"),
            keywords: &["бар", "дӯлча", "дӯлчаи пиво", "нӯшидан", "пиво"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เบ\u{e35}ยร\u{e4c}"),
            keywords: &[
                "ฉลอง",
                "ด\u{e37}\u{e48}ม",
                "เบ\u{e35}ยร\u{e4c}",
                "เหย\u{e37}อกเบ\u{e35}ยร\u{e4c}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("piwo bokaly"),
            keywords: &["bar", "bokal", "içmek", "piwo", "piwo bokaly"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("moki pia"),
            keywords: &["moki pia"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("bira kupası"),
            keywords: &["bar", "bira kupası", "kupa", "restoran"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("پىۋا رومكىسى"),
            keywords: &["ئىستاكان", "ئىچىملىك", "قاۋاق", "پىۋا", "پىۋا رومكىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кухоль із пивом"),
            keywords: &["бар", "кухоль", "кухоль із пивом", "пиво", "пити"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بیئر کا مگ"),
            keywords: &["بار", "بیئر کا مگ", "شراب", "مگ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("pivo stakani"),
            keywords: &["bar", "ichimlik", "krujka", "pivo", "pivo stakani"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cốc bia"),
            keywords: &["bia", "cốc", "quán bar", "đồ uống"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kaasu biyeer"),
            keywords: &["beer", "kaas", "kaasu biyeer", "laat", "naan"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("imagi yebhiya"),
            keywords: &["ibhari", "ibhiya", "imagi", "imagi yebhiya", "isiselo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Imuti"),
            keywords: &["Imuti", "ilé ọtí", "ohun mímu", "ìmutí", "ọtí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("啤酒杯"),
            keywords: &["啤酒", "啤酒杯", "酒吧", "飲酒"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("啤酒杯"),
            keywords: &["啤酒", "啤酒杯", "酒吧", "饮酒"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("啤酒"),
            keywords: &["啤酒", "杯", "酒"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("啤酒"),
            keywords: &["啤酒", "酒"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["啤酒", "啤酒杯", "酒", "酒吧", "酒杯"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("imagi kabhiya"),
            keywords: &["ibha", "imagi", "imagi kabhiya", "isiphuzo", "ubhiya"],
        },
    ],
};
#[doc = "🍻"]
pub const CLINKING_BEER_MUGS: crate::Emoji = crate::Emoji {
    glyph: "🍻",
    codepoint: "1F37B",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "clinking beer mugs",
    group: "Food & Drink",
    subgroup: "drink",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("klinkende bierbekers"),
            keywords: &[
                "beker",
                "bier",
                "drink",
                "klink",
                "klinkende bierbekers",
                "kroeg",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሚጋጩ የድራፍት ብርጭቆዎች"),
            keywords: &["ቢራ", "አሞሌ", "ኩባያ", "ክሊንክ", "የሚጋጩ የድራፍት ብርጭቆዎች"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كأسا بيرة"),
            keywords: &[
                "بيرة",
                "كأسا بيرة",
                "كوب",
                "كوبان يرتطمان",
                "محل تقديم المشروبات",
                "مشروب",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("উত\u{9cd}তম ধৰণৰ বীয\u{9bc}েৰৰ মগ"),
            keywords: &[
                "উত\u{9cd}তম ধৰণৰ বীয\u{9bc}েৰৰ মগ",
                "ঠ\u{9c1}ং ঠ\u{9c1}ং আৱ\u{9be}জ কৰ\u{9be}",
                "প\u{9be}নীয\u{9bc}",
                "ব\u{9be}ৰ",
                "বিয\u{9bc}েৰ",
                "মগ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("pivə krujkalarını toqquşdurmaq"),
            keywords: &[
                "bar",
                "cingilti",
                "içmək",
                "krujka",
                "pivə",
                "pivə krujkalarını toqquşdurmaq",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чоканне куфляў"),
            keywords: &[
                "бар",
                "куфель",
                "кухаль",
                "напой",
                "піва",
                "чоканне",
                "чоканне куфляў",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Удрящи се халби бира"),
            keywords: &[
                "Удрящи се халби бира",
                "бар",
                "бира",
                "наздраве",
                "удрящи се халби бира",
                "халба",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("উত\u{9cd}তম ধরণের বিয\u{9bc}\u{9be}রের মগ"),
            keywords: &[
                "উত\u{9cd}তম ধরণের বিয\u{9bc}\u{9be}রের মগ",
                "ঠ\u{9c1}ং ঠ\u{9c1}ং আওয\u{9bc}\u{9be}জ কর\u{9be}",
                "প\u{9be}ন কর\u{9be}",
                "ব\u{9be}র",
                "বিয\u{9bc}\u{9be}র",
                "মগ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("chopadoù bier"),
            keywords: &["bier", "chop", "chopadoù bier", "evaj"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("nazdravljanje kriglama piva"),
            keywords: &[
                "krigla",
                "kuckanje",
                "nazdravljanje kriglama piva",
                "pivo",
                "piće",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("brindis amb gerra de cervesa"),
            keywords: &[
                "brindis",
                "brindis amb gerra de cervesa",
                "cervesa",
                "gerra",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏓᏓᏒᏅᏍᏗᎲ ᎠᏬᎩᏢᏍᎩ ᏗᏟᏙᏗ"),
            keywords: &[
                "ᎠᏗᏔᏍᏗ",
                "ᎠᏬᎩᏢᏍᎩ",
                "ᎠᏯᏔᎾᎸ",
                "ᎦᏓᎫᎩ",
                "ᏓᏓᏒᏅᏍᏗᎲ ᎠᏬᎩᏢᏍᎩ ᏗᏟᏙᏗ",
                "ᏓᏓᏒᏍᏗᏍᎬᎢ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("cinkající půllitry piva"),
            keywords: &[
                "bar",
                "cinkající půllitry piva",
                "cinkání",
                "nápoj",
                "pití",
                "pivo",
                "přiťuknutí",
                "přípitek",
                "půllitr",
                "sklenice",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("mygiau cwrw yn clincian"),
            keywords: &["bar", "cwrw", "diod", "mygiau cwrw yn clincian"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("skålende ølkrus"),
            keywords: &[
                "krus",
                "krus øl",
                "skål",
                "skålende ølkrus",
                "ølglas",
                "ølkrus",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Bierkrüge"),
            keywords: &["Bier", "Bierkrüge", "anstoßen"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: None,
            keywords: &["Bierkrüge"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ποτήρια μπίρας που τσουγκρίζουν"),
            keywords: &[
                "μπαρ",
                "μπύρα",
                "ποτήρι μπύρας",
                "ποτήρια μπίρας που τσουγκρίζουν",
                "ποτό",
                "τσουγκρίζω",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("clinking beer mugs"),
            keywords: &["bar", "beer", "clink", "clinking beer mugs", "drink", "mug"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &[
                "bar",
                "beer",
                "clink",
                "clinking beer mugs",
                "drink",
                "mug",
                "steins",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("jarras de cerveza brindando"),
            keywords: &[
                "bar",
                "cerveza",
                "jarra",
                "jarras",
                "jarras de cerveza brindando",
                "restaurante",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("brindis con cerveza"),
            keywords: &[
                "bar",
                "bebida",
                "brindis",
                "brindis con cerveza",
                "celebrar",
                "cerveza",
                "festejar",
                "jarra",
                "jarro",
                "restaurante",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "bebida",
                "brindis",
                "brindis con cerveza",
                "celebrar",
                "cerveza",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "bebida",
                "brindis",
                "brindis con cerveza",
                "celebrar",
                "cerveza",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kõlisevad õllekannud"),
            keywords: &["baar", "jook", "kann", "kõlisevad õllekannud", "õlu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("topa egiten ari diren garagardo-pitxerrak"),
            keywords: &[
                "edari",
                "garagardo",
                "pitxer",
                "taberna",
                "topa",
                "topa egiten ari diren garagardo-pitxerrak",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("لیوان\u{200c}های آبجو را به\u{200c}هم زدن"),
            keywords: &[
                "آبجو",
                "بار",
                "به هم زدن",
                "به\u{200c}هم زدن لیوان\u{200c}های آبجو",
                "لیوان آبجو",
                "لیوان\u{200c}های آبجو را به\u{200c}هم زدن",
                "نوشیدن",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kilisevät oluttuopit"),
            keywords: &[
                "baari",
                "juoda",
                "kilisevät oluttuopit",
                "kippis",
                "olut",
                "tuoppi",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pagtagay sa mga beer mug"),
            keywords: &["alak", "bar", "beer", "pagtagay sa mga beer mug", "tagay"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("ølkrúss sum skála"),
            keywords: &[
                "barr",
                "drykkur",
                "krúss",
                "skál",
                "øl",
                "ølkrúss",
                "ølkrúss sum skála",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("chopes de bière"),
            keywords: &["bière", "chopes de bière", "trinquer"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("chopes de bière qui tintent"),
            keywords: &[
                "bar",
                "bière",
                "boisson",
                "chope",
                "chopes de bière qui tintent",
                "trinquer",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("gloiní beorach"),
            keywords: &["deochanna", "gloiní beorach", "teach tábhairne"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("mugaichean beòir a’ gliongadaich"),
            keywords: &[
                "beòir",
                "bàr",
                "deoch",
                "gliongadaich",
                "leann",
                "muga",
                "mugaichean beòir a’ gliongadaich",
                "òl",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("brinde de cervexas"),
            keywords: &["brinde de cervexas", "celebración", "cervexa", "xerras"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("અડકાતા\u{a82} બીઅર મગ\u{acd}સ"),
            keywords: &[
                "અડકાતા\u{a82} બીઅર મગ\u{acd}સ",
                "બાર",
                "બીઅર",
                "મગ",
                "મગ\u{acd}સ",
                "ર\u{ac7}સ\u{acd}ટોરન\u{acd}ટ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kofofin giya masu yin amo"),
            keywords: &[
                "amo",
                "giya",
                "kofi",
                "kofofin giya masu yin amo",
                "mashaya",
                "sha",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("השקת כוסות בירה"),
            keywords: &[
                "אלכוהול",
                "בירה",
                "בר",
                "השקת כוסות בירה",
                "כוס",
                "לחיים",
                "משקה",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बियर क\u{947} दो मग"),
            keywords: &[
                "दो मग",
                "बार",
                "बियर",
                "बियर क\u{947} दो मग",
                "बियर क\u{947} मग",
                "मग",
                "र\u{947}स\u{94d}टोर\u{947}\u{902}ट",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zdravica kriglama piva"),
            keywords: &[
                "bar",
                "krigla",
                "kucanje",
                "pivo",
                "zdravica",
                "zdravica kriglama piva",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("összekoccanó söröskorsók"),
            keywords: &[
                "bár",
                "ital",
                "koccintás",
                "korsó",
                "sör",
                "összekoccanó söröskorsók",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("զրնգացող գարեջրի գավաթներ"),
            keywords: &[
                "բար",
                "գավաթ",
                "գարեջուր",
                "զրնգալ",
                "զրնգացող գարեջրի գավաթներ",
                "խմել",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("mug bir berdenting"),
            keywords: &[
                "bar",
                "berbenturan",
                "bir",
                "minuman",
                "mug",
                "mug bir berdenting",
                "tos",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("na-akụkọta iko biya"),
            keywords: &[
                "mmanya biya",
                "na-akụkọta iko biya",
                "nkụkọta iko",
                "nnukwu iko",
                "ogwe",
                "ṅụọ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("bjórglös"),
            keywords: &["bar", "bjór", "bjórglös", "bjórkönnur", "drykkur", "skál"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("boccali di birra"),
            keywords: &[
                "bar",
                "birra",
                "boccale",
                "boccali di birra",
                "boccali di birra che brindano",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ビールで乾杯"),
            keywords: &["ジョッキ", "ビール", "ビールで乾杯", "乾杯", "宴会"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("gelas-gelas bir ditutulake"),
            keywords: &[
                "bar",
                "bir",
                "gelas bir",
                "gelas bir ditutulake",
                "gelas-gelas bir ditutulake",
                "mak thing",
                "unjukan",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ლუდის კათხების მიჭახუნება"),
            keywords: &[
                "ბარი",
                "დალევა",
                "დასალევი",
                "კათხა",
                "ლუდი",
                "ლუდის კათხების მიჭახუნება",
                "მიჭახუნება",
                "სასმელი",
                "სმა",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қағыстырылған сыра саптыаяқтары"),
            keywords: &[
                "бар",
                "саптыаяқ",
                "сыра",
                "ішімдік",
                "қағыстыру",
                "қағыстырылған сыра саптыаяқтары",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("skålende ølkrus"),
            keywords: &[
                "krus",
                "krus øl",
                "skål",
                "skålende ølkrus",
                "ølglas",
                "ølkrus",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}រាបៀព\u{17b8}រកែវជល\u{17cb}គ\u{17d2}នា"),
            keywords: &[
                "ជល\u{17cb}កែវ",
                "ស\u{17d2}រាបៀព\u{17b8}រកែវជល\u{17cb}គ\u{17d2}នា",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some(
                "ಖಣಖಣ\u{cbf}ಸುತ\u{ccd}ತ\u{cbf}ರುವ ಬ\u{cbf}ಯರ\u{ccd}\u{200c} ಮಗ\u{ccd}\u{200c}ಗಳು",
            ),
            keywords: &[
                "ಖಣಖಣ\u{cbf}ಸುತ\u{ccd}ತ\u{cbf}ರುವ ಬ\u{cbf}ಯರ\u{ccd}\u{200c} ಮಗ\u{ccd}\u{200c}ಗಳು",
                "ಬ\u{cbf}ಯರ\u{ccd}",
                "ಬ\u{cbf}ಯರ\u{ccd} ಮಗ\u{ccd}\u{200c}ಗಳು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("맥주"),
            keywords: &["맥주", "맥주잔", "짠"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("चियर\u{94d}स करपी बियराची\u{902} मगा\u{902}"),
            keywords: &[
                "चियर\u{94d}स",
                "चियर\u{94d}स करपी बियराची\u{902} मगा\u{902}",
                "पिण\u{947}\u{902}",
                "बार",
                "बियर",
                "मग",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кагышкан сыра кружкалары"),
            keywords: &["бар", "кагыш", "кагышкан сыра кружкалары", "кружка", "сыра"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("prostend Béierklenschen"),
            keywords: &[
                "Bar",
                "Béier",
                "Gedrénks",
                "Klensch",
                "prosten",
                "prostend Béierklenschen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຈອກເບຍຕຳກ\u{eb1}ນ"),
            keywords: &["ຈອກເບຍ", "ຈອກເບຍຕຳກ\u{eb1}ນ", "ຕຳກ\u{eb1}ນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("susidaužiantys alaus bokalai"),
            keywords: &[
                "alus",
                "baras",
                "gėrimas",
                "puodelis",
                "susidaužiantys alaus bokalai",
                "susidaužti",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("saskandināti alus kausi"),
            keywords: &[
                "alus",
                "bārs",
                "dzert",
                "dzēriens",
                "kauss",
                "saskandināti alus kausi",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ngā maka pia tutuki"),
            keywords: &["maka", "ngā maka pia tutuki", "pae", "pia", "tutuki", "unu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("наздравување со кригли пиво"),
            keywords: &[
                "бар",
                "кригли",
                "наздравување",
                "наздравување со кригли пиво",
                "пиво",
                "пијалак",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പരസ\u{d4d}പരം തട\u{d4d}ട\u{d41}ന\u{d4d}ന ബിയർ മഗ\u{d41}കൾ"),
            keywords: &[
                "പരസ\u{d4d}പരം തട\u{d4d}ട\u{d41}ന\u{d4d}ന ബിയർ മഗ\u{d41}കൾ",
                "ബ\u{d3e}ർ",
                "ബിയർ",
                "ബിയർ ഗ\u{d4d}ല\u{d3e}സ\u{d4d}",
                "ബീർ",
                "മഗ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("тулгаж буй шар айрагны хундага"),
            keywords: &[
                "тулгаж буй шар айрагны хундага",
                "тулгах",
                "уух",
                "хундага",
                "шар айраг",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("आवाज करणार\u{947} बीअर मग"),
            keywords: &[
                "आवाज करणार\u{947} बीअर मग",
                "आवाज करणार\u{947} बीअरच\u{947} मग",
                "आवाज करण\u{947}",
                "प\u{947}य",
                "बार",
                "बीअर",
                "मग",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kole bir berdenting"),
            keywords: &["bar", "berdenting", "bir", "kole", "minum"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("maggijiet tal-birra jċekċku"),
            keywords: &[
                "bar",
                "birra",
                "iċekċku",
                "magg",
                "maggijiet tal-birra jċekċku",
                "xarba",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ဘ\u{102e}ယာမတ\u{103a}ခ\u{103d}က\u{103a}များဖြင\u{1037}\u{103a} အသ\u{1036}မြည\u{103a}အောင\u{103a} ထ\u{102d}ပေးခြင\u{103a}း",
            ),
            keywords: &[
                "ချ\u{103d}င\u{103a}ချ\u{103d}င\u{103a}မြည\u{103a}",
                "ဘား",
                "ဘ\u{102e}ယာ",
                "ဘ\u{102e}ယာမတ\u{103a}ခ\u{103d}က\u{103a}များ အသ\u{1036}မြည\u{103a}အောင\u{103a} ထ\u{102d}ခြင\u{103a}း",
                "ဘ\u{102e}ယာမတ\u{103a}ခ\u{103d}က\u{103a}များဖြင\u{1037}\u{103a} အသ\u{1036}မြည\u{103a}အောင\u{103a} ထ\u{102d}ပေးခြင\u{103a}း",
                "မတ\u{103a}ခ\u{103d}က\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("ølkrus som skåler"),
            keywords: &[
                "bar",
                "halvliter",
                "pils",
                "øl",
                "ølglass",
                "ølkrus",
                "ølkrus som skåler",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बज\u{94d}न\u{947} बियरको मगहर\u{942}"),
            keywords: &[
                "बज\u{94d}न\u{947}",
                "बज\u{94d}न\u{947} बियरको मगहर\u{942}",
                "बार",
                "बियर",
                "मग",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("klinkende bierglazen"),
            keywords: &[
                "bar",
                "bier",
                "drinken",
                "glas",
                "klinkende bierglazen",
                "proosten",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("ølkrus som skåler"),
            keywords: &[
                "bar",
                "halvliter",
                "pils",
                "øl",
                "ølglas",
                "ølkrus",
                "ølkrus som skåler",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଟଣ ଟଣ ଶବ\u{b4d}ଦ ହେଉଥ\u{b3f}ବ\u{b3e} ବ\u{b3f}ଅର\u{b4d} ମଗଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
            ),
            keywords: &[
                "ଟଣ ଟଣ ଶବ\u{b4d}ଦ ହେଉଥ\u{b3f}ବ\u{b3e} ବ\u{b3f}ଅର\u{b4d} ମଗଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
                "ବ\u{b3e}ର\u{b4d}",
                "ମଗଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
                "ମଗ\u{b4d}\u{200c}",
                "ମଦ",
                "ମଦ ମଗ\u{b4d}\u{200c}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
                "ରେଷ\u{b4d}ଟ\u{b41}ର\u{b3e}ଣ\u{b4d}ଟ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬੀਅਰ ਦ\u{a47} ਪਿਆਲ\u{a47} ਟਕਰਾਉਣਾ"),
            keywords: &[
                "ਟਕਰਾਉਣਾ",
                "ਪਿਆਲਾ",
                "ਪਿਆਲ\u{a47}",
                "ਬਾਰ",
                "ਬੀਅਰ",
                "ਬੀਅਰ ਦ\u{a47} ਪਿਆਲ\u{a47} ਟਕਰਾਉਣਾ",
                "ਹ\u{a4b}ਟਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("لڑھکدے ہوئے شراب دے پیالے"),
            keywords: &[
                "سیخ",
                "شربت",
                "لڑھکدے ہوئے شراب دے پیالے",
                "مگ",
                "کھڑکنا",
                "ہلکی شراب",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Klínkín Biá Kọp-dẹm"),
            keywords: &[
                "Baa",
                "Bia",
                "Biá Kọp",
                "Drink",
                "Klínk Saund",
                "Klínkín Biá Kọp-dẹm",
                "Mọg",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("stukające się kufle piwa"),
            keywords: &[
                "kufle",
                "kufle z piwem",
                "piwiarnia",
                "stukające się kufle piwa",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د بير شړنګېدونکی غټ ګيلاس"),
            keywords: &[
                "بار، بير، شړنګېدونکي د بير ګيلاسونه، څکل، غټ ګيلاس",
                "د بير شړنګېدونکی غټ ګيلاس",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("canecas de cerveja"),
            keywords: &[
                "bar",
                "caneca",
                "canecas",
                "canecas de cerveja",
                "cerveja",
                "chopp",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("brinde com canecas de cerveja"),
            keywords: &[
                "bar",
                "beber",
                "brindar",
                "brinde com canecas de cerveja",
                "caneca",
                "cerveja",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("cerveza qirukuna anqusachkan"),
            keywords: &[
                "anqusay",
                "bar",
                "cerveza",
                "cerveza qirukuna anqusachkan",
                "jumiwa",
                "upyana",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("halbe de bere ciocnite"),
            keywords: &[
                "bar",
                "bere",
                "băutură",
                "ciocnit",
                "halbe",
                "halbe de bere ciocnite",
                "halbă",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-320"),
            keywords: &["E10-320"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("чокающиеся кружки"),
            keywords: &[
                "кружки пива",
                "пенное",
                "пивные кружки",
                "чокающиеся кружки",
                "чокнуться",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibirahure by’inzoga bikocorana"),
            keywords: &[
                "akabari",
                "gukocorana",
                "ibirahure by’inzoga bikocorana",
                "igikombe",
                "inzoga",
                "kunywa",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٽڪرائيجندڙ بيئر مگ"),
            keywords: &["بار، بيئر، ٽڪرائيجندڙ، مشروب، مگ", "ٽڪرائيجندڙ بيئر مگ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("එක\u{dd2}නෙක ගැටෙන බ\u{dd2}යර\u{dca} ජෝග\u{dd4}"),
            keywords: &[
                "එක\u{dd2}නෙක ගැටෙන බ\u{dd2}යර\u{dca} ජෝග\u{dd4}",
                "එක\u{dd2}නෙක ගැටෙන හඬ",
                "ජෝග\u{dca}ග\u{dd4}ව",
                "ප\u{dcf}නය ක\u{dd2}ර\u{dd3}ම",
                "බ\u{dd2}යර\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("štrngajúce pivové poháre"),
            keywords: &[
                "bar",
                "drink",
                "pivo",
                "pohár",
                "štrngajúce pivové poháre",
                "štrngať",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("nazdravljanje z vrčkoma za pivo"),
            keywords: &[
                "bar",
                "nazdravljanje z vrčkoma za pivo",
                "pijača",
                "pivo",
                "trkanje",
                "vrček",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("isku dhufsashada koobab khamri ah"),
            keywords: &[
                "baar",
                "cab",
                "isku dhufashada koobab khamri",
                "isku dhufsashada koobab khamri ah",
                "khamri",
                "koob",
                "ku dhufo",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kriklla birre që trokiten"),
            keywords: &["birrë", "kriklla birre që trokiten", "krikëll", "pije"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кригле пива које се куцају"),
            keywords: &[
                "бaр",
                "криглa",
                "кригле пива које се куцају",
                "куцaњe",
                "наздрављање",
                "пивo",
                "пићe",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("krigle piva koje se kucaju"),
            keywords: &[
                "bar",
                "krigla",
                "krigle piva koje se kucaju",
                "kucanje",
                "nazdravljanje",
                "pivo",
                "piće",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("skålande ölstop"),
            keywords: &["glas", "skål", "skålande ölglas", "skålande ölstop", "öl"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("vikombe vya bia vilivyogonganishwa"),
            keywords: &[
                "baa",
                "bia",
                "gonganisha",
                "kikombe",
                "kinywaji",
                "vikombe vya bia vilivyogonganishwa",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("vikombe vya bia vinavyogonganishwa"),
            keywords: &[
                "baa",
                "bia",
                "gonganisha",
                "kikombe",
                "kinywaji",
                "vikombe vya bia vinavyogonganishwa",
            ],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ப\u{bc0}ர\u{bcd} குவளைகள\u{bcd}"),
            keywords: &[
                "உணவகம\u{bcd}",
                "குவளைகள\u{bcd}",
                "ப\u{bc0}ர\u{bcd}",
                "விருந\u{bcd}து",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "ఒకద\u{c3e}న\u{c3f}త\u{c4b} ఒకట\u{c3f} త\u{c3e}క\u{c3f}స\u{c4d}తున\u{c4d}న బ\u{c40}ర\u{c4d} మగ\u{c4d}గులు",
            ),
            keywords: &[
                "ఒకద\u{c3e}న\u{c3f}త\u{c4b} ఒకట\u{c3f} త\u{c3e}క\u{c3f}స\u{c4d}తున\u{c4d}న బ\u{c40}ర\u{c4d} మగ\u{c4d}గులు",
                "బ\u{c3e}ర\u{c4d}",
                "బ\u{c40}రు",
                "మగ\u{c4d}గు",
                "మగ\u{c4d}గులు",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҷирингос задани дӯлчаҳои пиво"),
            keywords: &[
                "бар",
                "дӯлча",
                "нӯшидан",
                "пиво",
                "ҷиринго задан",
                "ҷирингос задани дӯлчаҳои пиво",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เหย\u{e37}อกเบ\u{e35}ยร\u{e4c}ชนก\u{e31}น"),
            keywords: &[
                "ฉลอง",
                "ชนแก\u{e49}ว",
                "ด\u{e37}\u{e48}ม",
                "เบ\u{e35}ยร\u{e4c}",
                "เหย\u{e37}อกเบ\u{e35}ยร\u{e4c}ชนก\u{e31}น",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çakyşýan piwo bokallary"),
            keywords: &[
                "bar",
                "bokal",
                "içmek",
                "piwo",
                "çakyşdyrmak",
                "çakyşýan piwo bokallary",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("moki fakapaaki"),
            keywords: &["moki fakapaaki"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("bira kupaları tokuşturma"),
            keywords: &[
                "bar",
                "bira",
                "bira kupaları tokuşturma",
                "kupa",
                "kupalar",
                "restoran",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("پىۋا سوقۇشتۇرۇش"),
            keywords: &["ئىستاكان", "سوقۇش", "قاۋاق", "پىۋا", "پىۋا سوقۇشتۇرۇش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кухлі з пивом, що цокаються"),
            keywords: &[
                "бар",
                "кухлі з пивом, що цокаються",
                "кухоль",
                "пиво",
                "пити",
                "цокати",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ٹکراتے بیئر کے مگ"),
            keywords: &["بار", "شراب", "مگ", "ٹکراتے بیئر کے مگ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("to‘qnashtirilayotgan pivo stakanlari"),
            keywords: &[
                "bar",
                "ichimlik",
                "jaranglash",
                "krujka",
                "pivo",
                "to‘qnashtirilayotgan pivo stakanlari",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("chạm cốc bia"),
            keywords: &[
                "bia",
                "chạm cốc",
                "chạm cốc bia",
                "nước giải khát",
                "quán ba",
                "đồ uống",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("dóorante kaasu biyeer"),
            keywords: &[
                "beer",
                "dóorante kaasu biyeer",
                "kaas",
                "kliŋ",
                "laat",
                "naan",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iimagi zebhiya ezingqubanayo"),
            keywords: &[
                "ibhari",
                "ibhiya",
                "iimagi zebhiya ezingqubanayo",
                "imagi",
                "isiselo",
                "ukungqubana",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Imuti Dídún"),
            keywords: &["Imuti Dídún", "dídún", "ilé ọtí", "ìmutí", "ímu", "ọtí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("踫啤酒杯"),
            keywords: &["啤酒", "啤酒杯", "踫啤酒杯", "踫杯", "酒吧", "飲酒"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("踫啤酒杯"),
            keywords: &["啤酒", "啤酒杯", "踫啤酒杯", "踫杯", "酒吧", "饮酒"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("干杯"),
            keywords: &["啤酒", "干杯", "碰杯", "酒"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("乾杯吧"),
            keywords: &["乾杯吧", "酒"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("乾杯"),
            keywords: &["乾杯"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukushayisana kwamamagi kabhiya"),
            keywords: &[
                "ibha",
                "imagi",
                "okuphuzwayo",
                "ubhiya",
                "ukushayisana",
                "ukushayisana kwamamagi kabhiya",
            ],
        },
    ],
};
#[doc = "🥂"]
pub const CLINKING_GLASSES: crate::Emoji = crate::Emoji {
    glyph: "🥂",
    codepoint: "1F942",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "clinking glasses",
    group: "Food & Drink",
    subgroup: "drink",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gesondheid"),
            keywords: &["drink", "gesondheid", "heildronk", "klink", "vonkelwyn"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የብርጭቆ ማንቃጨል"),
            keywords: &["መጠጣት", "ማንቃጨል", "ማክበር", "ብርጭቆ", "የብርጭቆ ማንቃጨል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كأسان يرتطمان"),
            keywords: &["احتفال", "ارتطام", "شراب", "كأس", "كأسان يرتطمان"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some(
                "চিয\u{9bc}\u{9be}ৰ\u{9cd}চ কৰিবৰ ক\u{9be}ৰণে গিল\u{9be}চত খ\u{9c1}ণ\u{9cd}ডিওৱ\u{9be}",
            ),
            keywords: &[
                "উদয\u{9be}পন",
                "গিল\u{9be}চ",
                "চিয\u{9bc}\u{9be}ৰ\u{9cd}চ কৰিবৰ ক\u{9be}ৰণে গিল\u{9be}চত খ\u{9c1}ণ\u{9cd}ডিওৱ\u{9be}",
                "ঠ\u{9c1}ং ঠ\u{9c1}ং আৱ\u{9be}জ কৰ\u{9be}",
                "প\u{9be}নীয\u{9bc}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("badələri qaldırmaq"),
            keywords: &["badə", "badələri qaldırmaq", "sağlıq demək", "toqquşdurmaq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чоканне келіхаў"),
            keywords: &[
                "дзынкаць",
                "келіх",
                "напітак",
                "свята",
                "чоканне келіхаў",
                "чокацца",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("звънтящи чаши"),
            keywords: &["звън", "звънтящи чаши", "напитка", "празнуване", "стъкло"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চিস\u{9be}র\u{9cd}সের জন\u{9cd}য গ\u{9cd}ল\u{9be}সে ঠোক\u{9be}"),
            keywords: &[
                "উদয\u{9be}পন",
                "খ\u{9be}ওয\u{9bc}\u{9be}",
                "গ\u{9cd}ল\u{9be}স",
                "চিস\u{9be}র\u{9cd}সের জন\u{9cd}য গ\u{9cd}ল\u{9be}সে ঠোক\u{9be}",
                "ঠ\u{9c1}ংঠ\u{9be}ং",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("uzdravlje"),
            keywords: &["kucnuti", "piće", "slavlje", "uzdravlje", "čaša"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("brindis"),
            keywords: &["brindis", "cava", "copes", "xampany", "xin-xin"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏓᏓᏒᏅᏍᏗᎲ ᏧᎸᏌᏗ"),
            keywords: &["ᎠᎵᎮᎵᏍᏗ", "ᎠᏗᏔᏍᏗ", "ᎤᎸᏎᏗ", "ᏓᏓᏒᏅᏍᏗᎲ ᏧᎸᏌᏗ", "ᏧᏓᏒᏅᏍᏔᏅ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("cinkající sklenice"),
            keywords: &[
                "cinkající sklenice",
                "cinkání",
                "nápoj",
                "oslava",
                "pití",
                "přiťuknutí",
                "přípitek",
                "sklenice",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("gwydrau yn tincian"),
            keywords: &["clinc", "dathlu", "diod", "gwydr", "gwydrau yn tincian"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("skål"),
            keywords: &["drikke", "fejring", "glas", "skål", "skåle"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Sektgläser"),
            keywords: &["Getränk", "Sekt", "Sektgläser", "anstoßen", "feiern"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: None,
            keywords: &["Sektgläser"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ποτήρια που τσουγκρίζουν"),
            keywords: &[
                "γιορτή",
                "ποτήρι",
                "ποτήρια που τσουγκρίζουν",
                "ποτό",
                "τσούγκρισμα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("clinking glasses"),
            keywords: &["celebrate", "clink", "clinking glasses", "drink", "glass"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("copas brindando"),
            keywords: &[
                "bebida",
                "brindar",
                "brindis",
                "celebración",
                "copa",
                "copas brindando",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "bebida",
                "brindis",
                "celebración",
                "copas",
                "copas brindando",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kõlisevad klaasid"),
            keywords: &[
                "jooma",
                "klaasid",
                "kõlisevad klaasid",
                "kõlks",
                "tähistama",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kopak topa egiten"),
            keywords: &["edalontzi", "edan", "kopak topa egiten", "ospatu", "topa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("صدای به\u{200c}هم خوردن پیاله\u{200c}ها"),
            keywords: &[
                "به سلامتی",
                "جشن",
                "جلینگ",
                "صدای به\u{200c}هم خوردن پیاله\u{200c}ها",
                "مشروب",
                "نوشیدن",
                "پیاله",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kilisevät lasit"),
            keywords: &["juhlia", "juoda", "kilisevät lasit", "kilistää", "lasi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("toast"),
            keywords: &["baso", "inumin", "mag-celebrate", "toast"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("gløs sum skála"),
            keywords: &[
                "barr",
                "drykkur",
                "glas",
                "gløs",
                "gløs sum skála",
                "hátíðarhald",
                "skál",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("trinquer"),
            keywords: &["célébrer", "fêter", "trinquer", "verre"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("verres qui tintent"),
            keywords: &[
                "boisson",
                "célébrer",
                "trinquer",
                "verre",
                "verres qui tintent",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("gloiní a ghligleáil"),
            keywords: &[
                "champagne",
                "deochanna",
                "gligleáil",
                "gloiní",
                "gloiní a ghligleáil",
                "sláinte",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("glaineachan a’ gliongadaich"),
            keywords: &[
                "comharrachadh",
                "cèilidh",
                "deoch",
                "glaineachan a’ gliongadaich",
                "glainne",
                "gliongadaich",
                "òl",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("brinde"),
            keywords: &["bebida", "brinde", "celebrar", "copas"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ક\u{acd}લિન\u{acd}કી\u{a82}ગ ગ\u{acd}લાસ"),
            keywords: &[
                "ઉજવણી",
                "ક\u{acd}લિ\u{a82}ક",
                "ક\u{acd}લિન\u{acd}કી\u{a82}ગ ગ\u{acd}લાસ",
                "ગ\u{acd}લાસ",
                "પીણ\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("gilasoshi masu yin amo"),
            keywords: &[
                "gilashi",
                "gilasoshi masu yin amo",
                "sha",
                "yi shagali",
                "yin amo",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("השקת כוסות לחיים"),
            keywords: &[
                "השקת כוסות לחיים",
                "חוגגים",
                "יין",
                "כוסות",
                "לחיים",
                "משקה",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("टकरात\u{947} ह\u{941}ए ग\u{94d}लास"),
            keywords: &[
                "ग\u{94d}लास",
                "जश\u{94d}न",
                "टकरात\u{947} ह\u{941}ए ग\u{94d}लास",
                "टकराना",
                "पीना",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zdravica"),
            keywords: &["kucanje", "piće", "proslava", "zdravica", "čaša"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("koccintó poharak"),
            keywords: &[
                "ivás",
                "koccintás",
                "koccintó",
                "koccintó poharak",
                "pohár",
                "ünneplés",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("զնգացող բաժակներ"),
            keywords: &[
                "բաժակ",
                "զնգացող բաժակներ",
                "զնգոց",
                "ծլնգոց",
                "նշել",
                "տոնել",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("mendentingkan gelas"),
            keywords: &[
                "cling",
                "hore",
                "mendentingkan gelas",
                "perayaan",
                "pesta",
                "selamat",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Na-akụkọta iko gasị"),
            keywords: &[
                "Na-akụkọta iko gasị",
                "iku nkụwa",
                "kụkọta",
                "nwèe aṅụrị",
                "ṅụọ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("skál"),
            keywords: &["drykkur", "glas", "glös", "skál"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("brindisi"),
            keywords: &["auguri", "bere", "brindisi", "cin cin", "festeggiare"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("グラスで乾杯"),
            keywords: &[
                "グラスで乾杯",
                "シャンパン",
                "シャンペン",
                "スパークリングワイン",
                "スプマンテ",
                "乾杯",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("gelas-gelas ditutulke"),
            keywords: &[
                "gelas",
                "gelas-gelas ditutulke",
                "mak thing",
                "pista",
                "unjukan",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჭიქების მიჭახუნება"),
            keywords: &[
                "ზეიმი",
                "მიჭახუნება",
                "სასმელი",
                "ჭიქა",
                "ჭიქების მიჭახუნება",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("стақан соғыстыру"),
            keywords: &["соғыстыру", "стақан", "сусын", "тойлау"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("skål"),
            keywords: &[
                "alkohol", "drikke", "drikker", "fejrer", "fejring", "fest", "glas", "skål",
                "skåler",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ជល\u{17cb}កែវ"),
            keywords: &[
                "កែវ",
                "ជល\u{17cb}",
                "ជល\u{17cb}កែវ",
                "ប\u{17d2}រារព\u{17d2}ធ",
                "ផ\u{17b9}ក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಖಣಖಣ\u{cbf}ಸುವ ಗ\u{ccd}ಲಾಸುಗಳು"),
            keywords: &[
                "ಕುಡ\u{cbf}",
                "ಖಣಖಣ\u{cbf}ಸು",
                "ಖಣಖಣ\u{cbf}ಸುವ ಗ\u{ccd}ಲಾಸುಗಳು",
                "ಗ\u{ccd}ಲಾಸು",
                "ಸಂಭ\u{ccd}ರಮ\u{cbf}ಸು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("건배하는 샴페인 잔"),
            keywords: &["건배", "건배하는 샴페인 잔"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("चियर\u{94d}साच\u{947} ग\u{94d}लास"),
            keywords: &[
                "ग\u{94d}लास",
                "चियर\u{94d}स",
                "चियर\u{94d}साच\u{947} ग\u{94d}लास",
                "पिण\u{947}\u{902}",
                "मनयतात",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бокал кагыштыруу"),
            keywords: &["бокал", "бокал кагыштыруу", "ичимдик", "майрам", "шаңгыроо"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("prostend Glieser"),
            keywords: &["Gedrénks", "Glas", "feieren", "prosten", "prostend Glieser"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຕຳຈອກ"),
            keywords: &["ຈອກ", "ຕຳ", "ຕຳຈອກ", "ສະຫ\u{ebc}ອງ", "ແກ\u{ec9}ວ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("sudaužtos taurės"),
            keywords: &[
                "gėrimas",
                "sudaužti",
                "sudaužtos taurės",
                "taurės",
                "šventimas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("glāžu skandināšana"),
            keywords: &[
                "dzert",
                "glāze",
                "glāžu skandināšana",
                "svinēt",
                "šampanietis",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("karāhe tutuki"),
            keywords: &["karāhe", "tutuki", "unu", "whakanui"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("здравица"),
            keywords: &["здравица", "наздравување", "прославување", "чаша"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ഗ\u{d4d}ല\u{d3e}സ\u{d4d}സ\u{d41}കൾ ക\u{d42}ട\u{d4d}ടിമ\u{d41}ട\u{d4d}ടിക\u{d4d}കൽ",
            ),
            keywords: &[
                "ആഘോഷം",
                "ക\u{d42}ട\u{d4d}ടിമ\u{d41}ട\u{d4d}ടിക\u{d4d}കൽ",
                "ഗ\u{d4d}ല\u{d3e}സ\u{d4d}സ\u{d41}കൾ ക\u{d42}ട\u{d4d}ടിമ\u{d41}ട\u{d4d}ടിക\u{d4d}കൽ",
                "ഗ\u{d4d}ല\u{d3e}സ\u{d4d}സ\u{d4d}",
                "പ\u{d3e}നീയം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хундага тулгах"),
            keywords: &["баяр тэмдэглэх", "тулгах", "уух", "хундага"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ग\u{94d}लास क\u{94d}लि\u{902}क करण\u{947}"),
            keywords: &[
                "आवाज करणार\u{947} ग\u{94d}लास",
                "आवाज करण\u{947}",
                "ग\u{94d}लास",
                "ग\u{94d}लास क\u{94d}लि\u{902}क करण\u{947}",
                "प\u{947}य",
                "साजरा करण\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("melaga gelas"),
            keywords: &["gelas", "melaga gelas", "meraikan", "minuman"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("tazzi jċekċku"),
            keywords: &["tazza", "tazzi jċekċku", "tiċċelebra", "xarba", "ċekċek"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဖန\u{103a}ခ\u{103d}က\u{103a}ခြင\u{103a}းထ\u{102d}သည\u{103a}"),
            keywords: &[
                "ဖန\u{103a}ခ\u{103d}က\u{103a}",
                "ဖန\u{103a}ခ\u{103d}က\u{103a}ခြင\u{103a}းထ\u{102d}သည\u{103a}",
                "ဖန\u{103a}ခ\u{103d}က\u{103a}ထ\u{102d}",
                "အသောက\u{103a}",
                "အောင\u{103a}ပ\u{103d}\u{1032}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("glass som skåler"),
            keywords: &["drink", "feiring", "glass", "glass som skåler", "skål"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("क\u{94d}लिङ\u{94d}क भएका गिलासहर\u{942}"),
            keywords: &[
                "उत\u{94d}सव मनाउन\u{947}",
                "क\u{94d}लिङ\u{94d}क",
                "क\u{94d}लिङ\u{94d}क भएका गिलासहर\u{942}",
                "गिलास",
                "प\u{947}य",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("klinkende glazen"),
            keywords: &["drinken", "glas", "klinken", "klinkende glazen", "vieren"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("glas som skåler"),
            keywords: &["drink", "feiring", "glas", "glas som skåler", "skål"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଟଣ ଟଣ ଶବ\u{b4d}ଦ ହେଉଥ\u{b3f}ବ\u{b3e} ଗ\u{b4d}ଲ\u{b3e}ସ\u{b4d}\u{200d}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
            ),
            keywords: &[
                "ଟଣ ଟଣ ଶବ\u{b4d}ଦ ହେଉଥ\u{b3f}ବ\u{b3e} ଗ\u{b4d}ଲ\u{b3e}ସ\u{b4d}\u{200d}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
                "ଟଣ ଟଣ ଶବ\u{b4d}ଦ ହେବ\u{b3e} । ଗ\u{b4d}ଲ\u{b3e}ସ\u{b4d}\u{200d} । ପ\u{b3e}ନୀୟ । ଉତ\u{b4d}ସବ ପ\u{b3e}ଳନ କର\u{b3f}ବ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਖੜਕਦੀਆ\u{a02} ਗਲਾਸੀਆ\u{a02}"),
            keywords: &[
                "ਖੜਕਦੀਆ\u{a02} ਗਲਾਸੀਆ\u{a02}",
                "ਗਲਾਸ",
                "ਜਸ\u{a3c}ਨ",
                "ਟਕਰਾਉਣਾ",
                "ਪੀਣਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("لڑھکدے ہوئے گلاس"),
            keywords: &["شربت", "لڑھکدے ہوئے گلاس", "منانا", "کھڑکنا", "گلاس"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Klínkín Glas-dẹm"),
            keywords: &[
                "Drink",
                "Glas",
                "Klínk Saund",
                "Klínkín Glas-dẹm",
                "Patí",
                "To Jám Drínkín Glás-dẹm Togẹ\u{301}da",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("stukające się kieliszki"),
            keywords: &[
                "kieliszki",
                "na zdrowie",
                "stukające się kieliszki",
                "toast",
                "świętowanie",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شړنګېدونکی غټ ګيلاس"),
            keywords: &[
                "شړنګېدونکی غټ ګيلاس",
                "لمانځل، شړنګېدل، شړنګېدونکي ګيلاسونه، څکل، ګيلاس",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("taças brindando"),
            keywords: &[
                "brinde",
                "champanhe",
                "comemoração",
                "taça",
                "taças brindando",
                "tim-tim",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("brinde"),
            keywords: &["bebida", "brinde", "celebrar", "copo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("qirukuna anqusachkan"),
            keywords: &[
                "qiru",
                "qirukuna anqusachkan",
                "raymi",
                "tintinay",
                "upyana",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pahare ciocnite"),
            keywords: &[
                "băutură",
                "ciocnit",
                "ciocnit de pahare",
                "pahar",
                "pahare ciocnite",
                "sărbătorire",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1058"),
            keywords: &["E10-1058"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("чокающиеся бокалы"),
            keywords: &["бокал", "звон", "напиток", "праздник", "чокающиеся бокалы"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibirahuri bikocorana"),
            keywords: &[
                "ibirahuri bikocorana",
                "ikirahuri",
                "kunywa",
                "kwirangira",
                "kwizihiza",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٽڪرائيجندڙ گلاس"),
            keywords: &["ٽڪرائيجندڙ گلاس", "ٽڪرائيجندڙ، گلاس، مشروب، جشن"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ව\u{dd3}ද\u{dd4}ර\u{dd4} හැප\u{dca}පව\u{dd2}ම"),
            keywords: &[
                "බ\u{dd2}ම",
                "ව\u{dd3}ද\u{dd4}ර\u{dd4}",
                "ව\u{dd3}ද\u{dd4}ර\u{dd4} හැප\u{dca}පව\u{dd2}ම",
                "සමරනව\u{dcf}",
                "හැප\u{dca}ප\u{dd3}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("štrngajúce poháriky"),
            keywords: &[
                "nápoj",
                "oslavovať",
                "pohár",
                "prípitok",
                "štrngajúce poháriky",
                "štrngať",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("nazdravljanje"),
            keywords: &["nazdravljanje", "pijača", "praznovanje", "trkanje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("galaasyo isku dhufashada"),
            keywords: &[
                "cab",
                "dabbaldeg",
                "galaas",
                "galaasyo isku dhufashada",
                "ku dhufo",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("trokitje gotash"),
            keywords: &["festë", "gotë", "pije", "trokitje", "trokitje gotash"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("чаше наздрављају"),
            keywords: &["живели", "пиће", "славље", "чаше", "чаше наздрављају"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["чаше наздрављају"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("čaše nazdravljaju"),
            keywords: &["piće", "slavlje", "čaše", "čaše nazdravljaju", "živeli"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["čaše nazdravljaju"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("skålande glas"),
            keywords: &["dryck", "fira", "glas", "skål", "skålande glas"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kugonga glasi"),
            keywords: &["glasi mbili", "kugonga glasi", "sherehe"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சியர\u{bcd}ஸ\u{bcd}"),
            keywords: &[
                "கொண\u{bcd}ட\u{bbe}ட\u{bcd}டம\u{bcd}",
                "சியர\u{bcd}ஸ\u{bcd}",
                "ப\u{bbe}னம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "ఒకద\u{c3e}న\u{c3f}త\u{c4b} ఒకట\u{c3f} త\u{c3e}క\u{c3f}స\u{c4d}తున\u{c4d}న గ\u{c4d}ల\u{c3e}స\u{c4d}\u{200c}లు",
            ),
            keywords: &[
                "ఒకద\u{c3e}న\u{c3f}త\u{c4b} ఒకట\u{c3f} త\u{c3e}క\u{c3f}స\u{c4d}తున\u{c4d}న గ\u{c4d}ల\u{c3e}స\u{c4d}\u{200c}లు",
                "గ\u{c4d}ల\u{c3e}సు శబ\u{c4d}దం",
                "గ\u{c4d}ల\u{c3e}స\u{c4d}",
                "ప\u{c3e}న\u{c40}యం",
                "వ\u{c47}డుక",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҷирингос задани стаканҳо"),
            keywords: &[
                "нӯшидан",
                "стакан",
                "ҷашн гирифтан",
                "ҷирингос задан",
                "ҷирингос задани стаканҳо",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ชนแก\u{e49}ว"),
            keywords: &["ฉลอง", "ชน", "ชนแก\u{e49}ว", "เย\u{e49}", "แก\u{e49}ว"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çakyşýan bulgurlar"),
            keywords: &[
                "baýramçylyk",
                "bulgur",
                "içmek",
                "jyňňyrdy",
                "çakyşýan bulgurlar",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ipu sioʻata fakapaaki"),
            keywords: &["ipu sioʻata fakapaaki"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kadeh tokuşturma"),
            keywords: &[
                "bardak",
                "içecek",
                "kadeh tokuşturma",
                "kutlama",
                "tokuşturma",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("رومكا سوقۇشتۇرۇش"),
            keywords: &["ئىچىش", "تەبرىكلەش", "رومكا", "سوقۇشتۇرۇش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("дзвін бокалів"),
            keywords: &["бокалів", "будьмо", "дзвін", "напій", "святкування"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("آپس میں ٹکراتے گلاس"),
            keywords: &[
                "آپس میں ٹکراتے گلاس",
                "خوشی منانا",
                "مشروب",
                "ٹکرانا",
                "گلاس",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qadah urishtirish"),
            keywords: &[
                "bayram",
                "ichimlik",
                "jaranglash",
                "qadah",
                "qadah urishtirish",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("chạm cốc"),
            keywords: &["chúc mừng", "chạm cốc", "cốc", "tiếng keng", "đồ uống"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("dóorante kaas"),
            keywords: &["dóorante", "kaas", "màggal", "naan"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iiglasi ezingqubanayo"),
            keywords: &[
                "bhiyoza",
                "iglasi",
                "iiglasi ezingqubanayo",
                "sela",
                "ukungqubana",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Gilasi Didun"),
            keywords: &["Gilasi Didun", "ayẹyẹ", "dún", "gílásì", "ohun mímu"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("踫杯"),
            keywords: &["慶祝", "玻璃杯", "踫杯", "飲酒"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("踫杯"),
            keywords: &["庆祝", "玻璃杯", "踫杯", "饮酒"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("碰杯"),
            keywords: &["喝", "庆祝", "杯", "碰杯"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("乾杯"),
            keywords: &["乾杯", "慶祝", "舉杯"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("舉杯慶祝"),
            keywords: &["喝香檳", "杯", "舉杯慶祝", "酒杯", "香檳酒杯"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukushayanisa izingilazi"),
            keywords: &[
                "bungaza",
                "ingilazi",
                "phuza",
                "ukushayanisa",
                "ukushayanisa izingilazi",
            ],
        },
    ],
};
#[doc = "🥃"]
pub const TUMBLER_GLASS: crate::Emoji = crate::Emoji {
    glyph: "🥃",
    codepoint: "1F943",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "tumbler glass",
    group: "Food & Drink",
    subgroup: "drink",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("whiskeyglas"),
            keywords: &["bolglas", "glas", "hardehout", "whiskey", "whiskeyglas"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የመጠጥ ብርጭቆ"),
            keywords: &["መለኪያ", "መጠጥ", "ብርጭቆ", "አልኮል", "ውስኪ", "የመጠጥ ብርጭቆ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كوب زجاجي"),
            keywords: &["شراب كحول", "كأس", "كوب", "كوب زجاجي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ট\u{9be}ম\u{9cd}বল\u{9be}ৰ গিল\u{9be}চ"),
            keywords: &[
                "গিল\u{9be}চ",
                "ট\u{9be}ম\u{9cd}বল\u{9be}ৰ",
                "প\u{9be}নীয\u{9bc}",
                "শ\u{9cd}বট",
                "হ\u{9c1}ইস\u{9cd}কি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("viski stəkanı"),
            keywords: &["içki", "likör", "spirtli", "viski stəkanı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("шклянка для віна"),
            keywords: &[
                "віно",
                "віскі",
                "кактэйль",
                "лікёр",
                "шклянка",
                "шклянка для віна",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("ниска чаша"),
            keywords: &["алкохол", "ниска", "уиски", "чаша", "шот"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চওড\u{9bc}\u{9be} গ\u{9cd}ল\u{9be}স"),
            keywords: &[
                "গ\u{9cd}ল\u{9be}স",
                "চওড\u{9bc}\u{9be} গ\u{9cd}ল\u{9be}স",
                "প\u{9be}নীয\u{9bc}",
                "শট",
                "হ\u{9c1}ইস\u{9cd}কি",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("čašica za žestoko piće"),
            keywords: &["piće", "viski", "čaša", "čašica za žestoko piće", "žestoko"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("got de licor"),
            keywords: &["beguda", "copeta", "got", "got de licor", "licor", "whisky"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎫᎩ ᎠᏟᏍᏙᏗ"),
            keywords: &["ᎠᏓᏴᏍᏕᏍᏗᏍᎩ", "ᎤᎸᏌᏗ", "ᎫᎩ ᎠᏟᏍᏙᏗ", "ᏍᏚᎩᏍᏗ", "ᏫᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("sklenice whisky"),
            keywords: &[
                "alkohol", "panák", "sklenice", "tumbler", "whiskey", "whisky",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("tymbler"),
            keywords: &["gwirod", "gwydraid", "shot", "tymbler", "whisgi"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("fladbundet glas"),
            keywords: &[
                "fladbundet glas",
                "shotglas",
                "shots",
                "spiritus",
                "sprut",
                "whisky",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Trinkglas"),
            keywords: &["Bar", "Trinkglas", "Whiskey"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ποτήρι ουίσκι"),
            keywords: &["αλκοολούχος", "κυλινδρικός", "ουίσκι", "ποτήρι", "σφηνάκι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("tumbler glass"),
            keywords: &["glass", "liquor", "shot", "tumbler", "whisky"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("vaso de whisky"),
            keywords: &[
                "chupito",
                "copa",
                "licor",
                "vaso",
                "vaso de whisky",
                "whisky",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["licor", "vaso", "vaso de whisky", "vaso pequeño", "whisky"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("joogiklaas"),
            keywords: &["joogiklaas", "napsuklaas", "viskiklaas"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("edalontzi zabala"),
            keywords: &[
                "alkohol",
                "edalontzi",
                "edalontzi zabala",
                "txupito",
                "whiski",
                "zabal",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("لیوان ته\u{200c}گنبدی"),
            keywords: &[
                "بی\u{200c}دسته",
                "جرعه",
                "ق\u{64f}ل\u{64f}پ",
                "لیوان",
                "لیوان ته\u{200c}گنبدی",
                "نوشابه الکلی",
                "ویسکی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("juomalasi"),
            keywords: &["juomalasi", "paukku", "viina", "viski"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tumbler glass"),
            keywords: &[
                "alak",
                "baso",
                "shot",
                "tumbler",
                "tumbler glass",
                "whiskey",
                "whisky",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("whiskyglas"),
            keywords: &[
                "barr",
                "drykkur",
                "glas",
                "sjussur",
                "viski",
                "whisky",
                "whiskyglas",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("verre tumbler"),
            keywords: &["liqueur", "tumbler", "verre", "whisky"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("verre"),
            keywords: &["bourbon", "liqueur", "spiritueux", "verre", "whisky"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("gloine"),
            keywords: &["deoch", "fuisce", "gloine", "uisce beatha"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("tumblair"),
            keywords: &["deoch làidir", "glainne", "tumblair", "uisge-beatha"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("vaso con xeo"),
            keywords: &["bebida", "vaso", "vaso con xeo", "whisky", "xeo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ટમ\u{acd}બ\u{acd}લર ગ\u{acd}લાસ"),
            keywords: &[
                "ગ\u{acd}લાસ",
                "ટમ\u{acd}બ\u{acd}લર",
                "દાર\u{ac2}",
                "વિસ\u{acd}કી",
                "શૉટ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("gilashin tambular"),
            keywords: &[
                "gilashi",
                "gilashin tambular",
                "giya",
                "giyan wiski",
                "tambular",
                "ɗan giya",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כוס ויסקי"),
            keywords: &["ויסקי", "כוס", "משקה חריף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("गिलास"),
            keywords: &[
                "गिलास",
                "ग\u{94d}लास",
                "व\u{94d}हिस\u{94d}की",
                "शराब",
                "शॉट",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("žestoko piće"),
            keywords: &["piće", "viski", "čaša", "žestoko"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("feles pohár"),
            keywords: &["alkohol", "feles", "feles pohár", "tömény", "whisky"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("թեյի բաժակ"),
            keywords: &["բաժակ", "գինի", "թեյի բաժակ", "կոնյակ", "վիսկի", "օղի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("gelas tumbler"),
            keywords: &[
                "alkohol",
                "gelas",
                "gelas tumbler",
                "minum-minum",
                "whisky",
                "wiski",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ikọ nkụwa"),
            keywords: &["iko", "ikọ nkụwa", "mgbanye", "mmanye", "nkụwa", "ọkụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("viskíglas"),
            keywords: &["drykkur", "glas", "viskí", "viskíglas", "áfengi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("bicchiere tumbler"),
            keywords: &["bicchiere", "liquore", "tumbler", "whisky"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("タンブラーグラス"),
            keywords: &[
                "ウィスキー",
                "ウイスキー",
                "グラス",
                "タンブラー",
                "タンブラーグラス",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("gelas sloki"),
            keywords: &["anggur", "gelas", "sloki", "unjukan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბრტყელძირიანი ჭიქა"),
            keywords: &["ბრტყელძირიანი ჭიქა", "გადაკვრა", "ვისკი", "ლიქიორი", "ჭიქა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шарап стақаны"),
            keywords: &["виски", "стақан", "сусын", "шарап", "шарап стақаны"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("fladbundet glas"),
            keywords: &[
                "drikke",
                "drikker",
                "fladbundet",
                "glas",
                "shot",
                "shotglas",
                "spiritus",
                "spiritusglas",
                "sprut",
                "whiskyglas",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កែវថ\u{17d2}ម"),
            keywords: &[
                "កែវ",
                "កែវថ\u{17d2}ម",
                "កែវអត\u{17cb}ដៃ",
                "ខ\u{17d2}ល\u{17b8}",
                "ទ\u{17b9}ក",
                "ស\u{17d2}រា",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಟಂಬ\u{ccd}ಲರ\u{ccd} ಗ\u{ccd}ಲಾಸುಗಳು"),
            keywords: &[
                "ಗ\u{ccd}ಲಾಸು",
                "ಟಂಬ\u{ccd}ಲರ\u{ccd}",
                "ಟಂಬ\u{ccd}ಲರ\u{ccd} ಗ\u{ccd}ಲಾಸುಗಳು",
                "ಪ\u{cc6}ಗ\u{ccd}",
                "ವ\u{cbf}ಸ\u{ccd}ಕ\u{cbf}",
                "ಸರಾಯ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("양주잔"),
            keywords: &["샷", "양주잔", "위스키"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ट\u{902}ब\u{94d}लर ग\u{94d}लास"),
            keywords: &[
                "ग\u{94d}लास",
                "ट\u{902}ब\u{94d}लर",
                "विस\u{94d}की",
                "शॉट",
                "सोरो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("винонун стаканы"),
            keywords: &["бокал", "винонун стаканы", "виски", "коктейль", "ликер"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Whiskyglas"),
            keywords: &["Alkohol", "Glas", "Shot", "Whisky", "Whiskyglas"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແກ\u{ec9}ວເຫ\u{ebc}\u{ebb}\u{ec9}າ"),
            keywords: &[
                "ຊ\u{eb1}ອດ",
                "ວ\u{eb4}ສກ\u{eb5}\u{ec9}",
                "ເຫ\u{ebc}\u{ebb}\u{ec9}າ",
                "ແກ\u{ec9}ວ",
                "ແກ\u{ec9}ວເຫ\u{ebc}\u{ebb}\u{ec9}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("stiklinė"),
            keywords: &["alkoholis", "stiklinė", "viskis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("viskija glāze"),
            keywords: &["glāze", "liķieris", "viskija glāze", "viskijs", "šots"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("karāhe ipurau"),
            keywords: &["ipurau", "karāhe", "pota", "waipiro", "wihike"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("жесток пијалак"),
            keywords: &["алкохол", "виски", "жесток пијалак", "жестоко", "чаша"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ടംബ\u{d4d}ലർ ഗ\u{d4d}ല\u{d3e}സ\u{d4d}"),
            keywords: &[
                "ഗ\u{d4d}ല\u{d3e}സ\u{d4d}സ\u{d4d}",
                "ടംബ\u{d4d}ലർ",
                "ടംബ\u{d4d}ലർ ഗ\u{d4d}ല\u{d3e}സ\u{d4d}",
                "മദ\u{d4d}യം",
                "വിസ\u{d4d}ക\u{d4d}കി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("архины жүнз"),
            keywords: &["архи", "архины жүнз", "виски", "жүнз", "хундага"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("टमर\u{947}ल ग\u{94d}लास"),
            keywords: &[
                "ग\u{94d}लास",
                "टमर\u{947}ल ग\u{94d}लास",
                "टम\u{94d}बलर",
                "दार\u{942}",
                "व\u{94d}हिस\u{94d}की",
                "शॉट",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("gelas pendek"),
            keywords: &["arak", "gelas", "pendek"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("tazza kbira tal-ħġieġ"),
            keywords: &[
                "likur",
                "shot",
                "tazza",
                "tazza kbira",
                "tazza kbira tal-ħġieġ",
                "whisky",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အောက\u{103a}ခြေပြား ဖန\u{103a}ခ\u{103d}က\u{103a}"),
            keywords: &[
                "ဖန\u{103a}ခ\u{103d}က\u{103a}",
                "ဝ\u{102e}စက\u{102e}",
                "အရက\u{103a}ပြင\u{103a}း",
                "အောက\u{103a}ခြေပြား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("whiskyglass"),
            keywords: &[
                "brennevin",
                "glass",
                "shot",
                "sprit",
                "whisky",
                "whiskyglass",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("टम\u{94d}बलर गिलास"),
            keywords: &[
                "गिलास",
                "टम\u{94d}बलर",
                "मदिरा",
                "शट",
                "ह\u{94d}विस\u{94d}की",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("tumblerglas"),
            keywords: &[
                "borrel",
                "drank",
                "glas",
                "tumbler",
                "tumblerglas",
                "whiskey",
                "whisky",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("whiskyglas"),
            keywords: &["brennevin", "glas", "shot", "sprit", "whisky", "whiskyglas"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଟମ\u{b4d}ବଲର\u{b4d}\u{200d} ଗ\u{b4d}ଲ\u{b3e}ସ\u{b4d}\u{200d}"),
            keywords: &[
                "ଗ\u{b4d}ଲ\u{b3e}ସ",
                "ଗ\u{b4d}ଲ\u{b3e}ସ\u{b4d}\u{200c}",
                "ଟମ\u{b4d}ବଲର\u{b4d}\u{200d} ଗ\u{b4d}ଲ\u{b3e}ସ\u{b4d}\u{200d}",
                "ମଦ",
                "ସଟ\u{b4d}\u{200c}",
                "ୱ\u{b3f}ସ\u{b4d}କ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਟ\u{a70}ਬਲਰ ਗਲਾਸ"),
            keywords: &["ਗਲਾਸ", "ਟ\u{a70}ਬਲਰ ਗਲਾਸ", "ਬੀਅਰ", "ਵਿਸਕੀ", "ਸ\u{a3c}ਰਾਬ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("لڑھکدا ہویا گلاس"),
            keywords: &[
                "جوشاندہ",
                "شراب",
                "ق\u{64e}لا باز",
                "لڑھکدا ہویا گلاس",
                "نشانہ",
                "گلاس",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tọ\u{301}mbla"),
            keywords: &["Glas", "Họ\u{301}t Drink", "Shọt", "Tọ\u{301}mbla", "Wiskí"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("szklanka z grubym dnem"),
            keywords: &[
                "alkohol",
                "drink",
                "grube dno",
                "szklanka",
                "szklanka z grubym dnem",
                "whisky",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("جام ګلاس"),
            keywords: &["جام ګلاس", "ګيلاس، شراب، شاټ، جام، ويسکي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("copo"),
            keywords: &["bebida", "copo", "drink", "whisky"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("copo de whisky"),
            keywords: &[
                "baixo",
                "bebida",
                "copo",
                "copo de whisky",
                "shot",
                "whisky",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("qiru vidriomanta"),
            keywords: &[
                "licor",
                "qiru",
                "qiru vidriomanta",
                "qirukuna vidriomanta",
                "shot",
                "whisky",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pahar de whisky"),
            keywords: &["lichior", "pahar", "pahar de whisky", "shot", "whisky"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1059"),
            keywords: &["E10-1059"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("стакан с виски"),
            keywords: &[
                "вино",
                "виски",
                "коктейль",
                "ликер",
                "стакан",
                "стакан с виски",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikirahuri kitagira umukondo"),
            keywords: &[
                "igikombe",
                "ikirahuri",
                "ikirahuri kitagira umukondo",
                "intama",
                "likeri",
                "wisiki",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("لوٽي نما گلاس"),
            keywords: &["لوٽي نما گلاس", "گلاس، لوٽي نما گلاس، وشڪي، شراب، گهونٽ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බොන ව\u{dd3}ද\u{dd4}ර\u{dd4}ව"),
            keywords: &[
                "බ\u{dd2}ම",
                "බොන ව\u{dd3}ද\u{dd4}ර\u{dd4}ව",
                "මත\u{dca}පැන\u{dca}",
                "ව\u{dd2}ස\u{dca}ක\u{dd2}",
                "ව\u{dd3}ද\u{dd4}ර\u{dd4}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("pohár na whisky"),
            keywords: &["alkohol", "pohár", "pohár na whisky", "pohárik", "whisky"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kozarec žgane pijače"),
            keywords: &[
                "kozarec",
                "kozarec žgane pijače",
                "merica",
                "viski",
                "žgane pijače",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("galaas dhalo"),
            keywords: &["gaaban", "galaas", "galaas dhalo", "khamri", "khamri culus"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gotë"),
            keywords: &["gotë", "pije", "uiski", "ujë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("чаша за жестину"),
            keywords: &["виски", "жестина", "пиће", "чаша", "чаша за жестину"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("čaša za žestinu"),
            keywords: &["piće", "viski", "čaša", "čaša za žestinu", "žestina"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("whiskyglas"),
            keywords: &["brännvin", "glas", "shot", "sprit", "whisky", "whiskyglas"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("glasi"),
            keywords: &["glasi", "mvinyo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("விஸ\u{bcd}கி கிள\u{bbe}ஸ\u{bcd}"),
            keywords: &["மது", "விஸ\u{bcd}கி", "விஸ\u{bcd}கி கிள\u{bbe}ஸ\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("టంబ\u{c4d}లర\u{c4d} గ\u{c4d}ల\u{c3e}స\u{c4d}"),
            keywords: &[
                "గ\u{c4d}ల\u{c3e}స\u{c4d}",
                "టంబ\u{c4d}లర\u{c4d}",
                "మద\u{c4d}యం",
                "వ\u{c3f}స\u{c4d}క\u{c40}",
                "ష\u{c3e}ట\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("стакан барои нӯшокиҳои спиртӣ"),
            keywords: &[
                "виски",
                "ликёр",
                "стакан",
                "стакан барои нӯшокиҳои спиртӣ",
                "стакани хурд",
                "тирпаронӣ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แก\u{e49}วเหล\u{e49}า"),
            keywords: &[
                "ด\u{e37}\u{e48}ม",
                "เพ\u{e35}ยว",
                "เหล\u{e49}า",
                "แก\u{e49}ว",
                "แก\u{e49}วเหล\u{e49}า",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("aýna bokal"),
            keywords: &["aýna", "bokal", "likýor", "wiski", "zarba"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ipu sioʻata"),
            keywords: &["ipu sioʻata"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kısa ve geniş bardak"),
            keywords: &[
                "bardak",
                "kısa ve geniş",
                "kısa ve geniş bardak",
                "likör",
                "tek içki",
                "viski",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئەينەك رومكا"),
            keywords: &["ئەينەك", "رومكا", "قەدەھ", "ھاراق", "ۋىسكى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("бокал віскі"),
            keywords: &["алкоголь", "бокал", "віскі", "напій", "спиртне"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("وہسکی والا گلاس"),
            keywords: &["شراب", "وہسکی", "وہسکی والا گلاس", "گلاس"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("vino uchun stakan"),
            keywords: &[
                "kokteyl",
                "liker",
                "stakan",
                "vino",
                "vino uchun stakan",
                "viski",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ly đáy phẳng"),
            keywords: &[
                "cốc",
                "cốc vại",
                "ly đáy phẳng",
                "ngụm",
                "rượu",
                "rượu whisky",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kaasu ndox"),
            keywords: &["kaas", "kaasu ndox", "likër", "ndox", "whisky", "ñam"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iglasi engenamqheba"),
            keywords: &["engenamqheba", "i-shot", "i-whisky", "iglasi", "lutywala"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Gilasi Tọnbila"),
            keywords: &[
                "Gilasi Tọnbila",
                "gílásì",
                "tọ\u{301}mbílà",
                "ṣọ\u{301}ọ\u{300}tí",
                "ọtí",
                "ọtí líle",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("烈酒㷴"),
            keywords: &["分量", "威士忌", "烈酒", "烈酒㷴", "玻璃", "酒"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("烈酒㷴"),
            keywords: &["分量", "威士忌", "烈酒", "烈酒㷴", "玻璃", "酒"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("平底杯"),
            keywords: &["威士忌", "平底杯", "杯", "酒"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("威士忌杯"),
            keywords: &["威士忌", "威士忌杯", "烈酒", "酒杯"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("玻璃杯"),
            keywords: &["威士忌", "威士忌杯", "烈酒", "玻璃杯", "酒杯"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ingilazi yephepha"),
            keywords: &[
                "dubula",
                "ingilazi",
                "ingilazi yephepha",
                "iphepha",
                "utshwala",
                "whisky",
            ],
        },
    ],
};
#[doc = "🥤"]
pub const CUP_WITH_STRAW: crate::Emoji = crate::Emoji {
    glyph: "🥤",
    codepoint: "1F964",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "cup with straw",
    group: "Food & Drink",
    subgroup: "drink",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("beker met strooitjie"),
            keywords: &["beker met strooitjie", "koeldrank", "sap"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ብርጭቆ ከመጠጫ ጋር"),
            keywords: &["ብርጭቆ ከመጠጫ ጋር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كأس وقشة للشرب"),
            keywords: &["كأس وقشة للشرب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ষ\u{9cd}ট\u{9cd}ৰ’ দিয\u{9bc}\u{9be} ক\u{9be}প"),
            keywords: &[
                "ছ’ড\u{9be}",
                "জ\u{9c1}চ",
                "ষ\u{9cd}ট\u{9cd}ৰ’ দিয\u{9bc}\u{9be} ক\u{9be}প",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("borucuqlu stəkan"),
            keywords: &["borucuqlu stəkan", "soda", "şirə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("шклянка з саломінкай"),
            keywords: &["газіроўка", "сок", "шклянка з саломінкай"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("чаша със сламка"),
            keywords: &["сода", "сок", "чаша със сламка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9cd}ট\u{9cd}র দেওয\u{9bc}\u{9be} ক\u{9be}প"),
            keywords: &[
                "জ\u{9c1}স",
                "সোড\u{9be}",
                "স\u{9cd}ট\u{9cd}র দেওয\u{9bc}\u{9be} ক\u{9be}প",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("gobeled gant plouzenn"),
            keywords: &["chug-frouezh", "gobeled gant plouzenn", "soda"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("čaša sa slamkom"),
            keywords: &["sok", "čaša sa slamkom"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("got amb canya"),
            keywords: &["beguda", "canya", "got", "got amb canya", "refresc", "suc"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎵᏍᏈᏘ ᎾᏍᎩ ᎬᏩᏠᏯᏍᏗ ᎠᎹᏗᏙᏗ"),
            keywords: &["ᎠᏗᏔᏍᏗ", "ᎤᎵᏍᏈᏘ ᎾᏍᎩ ᎬᏩᏠᏯᏍᏗ ᎠᎹᏗᏙᏗ", "ᎪᎸᏍᏔᏅ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("pohárek s brčkem"),
            keywords: &[
                "džus",
                "limonáda",
                "nealko",
                "pohárek s brčkem",
                "soda",
                "sodovka",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cwpan â gwellt yfed"),
            keywords: &["cwpan â gwellt yfed", "soda", "sudd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bæger med sugerør"),
            keywords: &["bæger", "bæger med sugerør", "glas med sugerør", "sugerør"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Becher mit Strohhalm"),
            keywords: &["Becher mit Strohhalm", "Saft", "Selters"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ποτήρι με καλαμάκι"),
            keywords: &["αναψυκτικό", "ποτήρι με καλαμάκι", "χυμός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("cup with straw"),
            keywords: &["cup with straw", "juice", "soda"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["cup with straw", "fizzy drink", "juice", "soft drink"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("vaso con pajita"),
            keywords: &["refresco", "vaso con pajita", "zumo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("vaso con popote"),
            keywords: &["jugo", "refresco", "vaso con popote"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kõrrega tops"),
            keywords: &["kõrrega tops", "limonaad", "mahl"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kopa eta lastotxoa"),
            keywords: &["kopa eta lastotxoa", "soda", "zuku"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("فنجان با نی"),
            keywords: &[
                "آب\u{200c}میوه",
                "افشره",
                "سودا",
                "فنجان با نی",
                "لیموناد",
                "نوشابه\u{654} گازدار",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("lasi ja pilli"),
            keywords: &["juoma", "lasi ja pilli", "mehu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("baso na may straw"),
            keywords: &["baso na may straw", "juice", "soda"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("koppur við súgvirøri"),
            keywords: &[
                "djús",
                "drykkur",
                "koppur við súgvirøri",
                "saft",
                "sodavatn",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("gobelet avec paille"),
            keywords: &["gobelet avec paille", "jus de fruits", "soda"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("verre avec paille"),
            keywords: &[
                "jus de fruits",
                "paille",
                "soda",
                "verre",
                "verre avec paille",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cupán le sop"),
            keywords: &["cupán le sop", "deoch shóide", "sú"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cupa le stràbh"),
            keywords: &["cupa le stràbh", "sòda", "sùgh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("vaso con palla"),
            keywords: &["palla", "refresco", "vaso", "vaso con palla", "zume"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}ટ\u{acd}રૉ સાથ\u{ac7} કપ"),
            keywords: &["જ\u{ac2}સ", "સોડા", "સ\u{acd}ટ\u{acd}રૉ સાથ\u{ac7} કપ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kofi tare da tsinke"),
            keywords: &["kofi tare da tsinke", "ruwan zaƙi", "soda"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כוס עם קש"),
            keywords: &["כוס עם קש", "מיץ", "סודה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{94d}ट\u{94d}रॉ क\u{947} साथ कप"),
            keywords: &["ज\u{942}स", "सोडा", "स\u{94d}ट\u{94d}रॉ क\u{947} साथ कप"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("čaša sa slamkom"),
            keywords: &["sok", "čaša sa slamkom"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("pohár szívószállal"),
            keywords: &["dzsúz", "ivólé", "pohár szívószállal", "szóda"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ձողիկով բաժակ"),
            keywords: &["զովացուցիչ", "ըմպելիք", "կոլա", "հյութ", "ձողիկով բաժակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("cangkir dengan sedotan"),
            keywords: &["cangkir dengan sedotan", "jus", "soda"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("iko nwere osisi rọba ọmịmị"),
            keywords: &["iko nwere osisi rọba ọmịmị", "mmanya mkpụrụosisi", "soda"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("glas og rör"),
            keywords: &["glas og rör", "gos", "safi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("bicchiere con cannuccia"),
            keywords: &["bibita", "bicchiere con cannuccia"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ストローカップ"),
            keywords: &["コップ", "ジュース", "ストローカップ"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("gelas mawa sedhotan"),
            keywords: &["gelas mawa sedhotan", "soda", "wedang jus"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჭიქა საწრუპით"),
            keywords: &[
                "გაზიანი სასმელი",
                "შეიკი",
                "წვენი",
                "წყალი",
                "ჭიქა საწრუპით",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("түтікшелі ыдыс"),
            keywords: &["түтікшелі ыдыс"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ពែងជាម\u{17bd}យប\u{17c6}ពង\u{17cb}ប\u{17ba}ត"),
            keywords: &[
                "ទ\u{17b9}កក\u{17d2}រ\u{17bc}ច",
                "ពែងជាម\u{17bd}យប\u{17c6}ពង\u{17cb}ប\u{17ba}ត",
                "ស\u{17bc}ដា",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{ccd}ಟ\u{ccd}ರಾ ಜೊತ\u{cc6}ಗ\u{cc6} ಕಪ\u{ccd}"),
            keywords: &[
                "ಜ\u{cc2}ಸ\u{ccd}",
                "ಸೋಡಾ",
                "ಸ\u{ccd}ಟ\u{ccd}ರಾ ಜೊತ\u{cc6}ಗ\u{cc6} ಕಪ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("빨대와 컵"),
            keywords: &["빨대와 컵", "소다", "주스"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("स\u{94d}ट\u{94d}रॉ आसपी कप"),
            keywords: &["ज\u{94d}य\u{941}स", "सोडा", "स\u{94d}ट\u{94d}रॉ आसपी कप"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("таякча салынган стакан"),
            keywords: &["сода", "таякча салынган стакан", "шире"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Glas mat Stréihallem"),
            keywords: &["Glas mat Stréihallem", "Jus", "Softdrink"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຈອກມ\u{eb5}ຫ\u{ebc}ອດດ\u{eb9}ດ"),
            keywords: &[
                "ຈອກມ\u{eb5}ຫ\u{ebc}ອດດ\u{eb9}ດ",
                "ນ\u{ec9}ຳໝາກໄມ\u{ec9}",
                "ໂຊດາ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("puodelis su šiaudeliu"),
            keywords: &["puodelis su šiaudeliu", "soda", "sultys"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("dzēriens ar salmiņu"),
            keywords: &["dzēriens ar salmiņu", "gāzēts", "limonāda", "sula"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kapu me te ngongo"),
            keywords: &["kapu me te ngongo", "wai huarākau", "wai reka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("чаша со сламка"),
            keywords: &["газиран пијалак", "цеден сок", "чаша со сламка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കപ\u{d4d}പ\u{d41}ം സ\u{d4d}\u{200c}ട\u{d4d}രോയ\u{d41}ം"),
            keywords: &[
                "കപ\u{d4d}പ\u{d41}ം സ\u{d4d}\u{200c}ട\u{d4d}രോയ\u{d41}ം",
                "ജ\u{d4d}യ\u{d42}സ\u{d4d}",
                "സോഡ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("соруултай аяга"),
            keywords: &["жүүс", "сода", "соруултай аяга"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{94d}ट\u{94d}रॉ असल\u{947}ला कप"),
            keywords: &[
                "ज\u{94d}य\u{942}स",
                "सोडा",
                "स\u{94d}ट\u{94d}रॉ असल\u{947}ला कप",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("cawan dan straw"),
            keywords: &["cawan dan straw", "jus", "soda"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("tazza bi stro"),
            keywords: &["luminata", "meraq", "tazza bi stro"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပ\u{102d}\u{102f}က\u{103a}န\u{103e}င\u{1037}\u{103a}ခ\u{103d}က\u{103a}"),
            keywords: &[
                "ဆ\u{102d}\u{102f}ဒါ",
                "ပ\u{102d}\u{102f}က\u{103a}န\u{103e}င\u{1037}\u{103a}ခ\u{103d}က\u{103a}",
                "သစ\u{103a}သ\u{102e}းဖျော\u{103a}ရည\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kopp med sugerør"),
            keywords: &["brus", "juice", "jus", "kopp med sugerør"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कागज वा प\u{94d}लास\u{94d}टिकको पातलो नलीसहितको कप"),
            keywords: &[
                "कागज वा प\u{94d}लास\u{94d}टिकको पातलो नलीसहितको कप",
                "ज\u{941}स",
                "सोडा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("beker met rietje"),
            keywords: &["beker met rietje", "frisdrank", "sap"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kopp med sugerøyr"),
            keywords: &["brus", "juice", "jus", "kopp med sugerøyr"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଷ\u{b4d}ଟ\u{b4d}ର ସହ\u{b3f}ତ କପ\u{b4d}\u{200d}"),
            keywords: &[
                "ଷ\u{b4d}ଟ\u{b4d}ର ସହ\u{b3f}ତ କପ\u{b4d}\u{200d}",
                "ସୋଡ\u{b3c}\u{b3e} । ଜ\u{b41}ସ\u{b4d}\u{200d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪਾਈਪ ਸਮ\u{a47}ਤ ਕ\u{a71}ਪ"),
            keywords: &["ਜ\u{a42}ਸ", "ਪਾਈਪ ਸਮ\u{a47}ਤ ਕ\u{a71}ਪ", "ਸ\u{a4b}ਢਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("نلکی نال کپ"),
            keywords: &["رس", "سوڈا", "نلکی نال کپ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kọp Wit Strọ"),
            keywords: &["Jus", "Kọp Wit Strọ", "Sóda", "Sóda Wọ\u{301}ta"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("szklanka ze słomką"),
            keywords: &["szklanka ze słomką"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پياله د نيچې سره"),
            keywords: &["پياله د نيچې سره", "پياله د نيچې سره، جوس، سوډا"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("copo com canudo"),
            keywords: &["copo com canudo", "suco"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("copo com palhinha"),
            keywords: &["copo com palhinha", "refrigerante", "sumo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("qiru bombillawan"),
            keywords: &["jilli", "qiru bombillawan", "soda"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pahar cu pai"),
            keywords: &["pahar cu pai", "sifon", "suc"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1088"),
            keywords: &["E10-1088"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("стакан с соломинкой"),
            keywords: &[
                "газировка",
                "минеральная вода",
                "стакан с газировкой",
                "стакан с соломинкой",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igikombe n’umuheha"),
            keywords: &["igikombe n’umuheha", "soda", "umutobe"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اسٽرا سان ڪپ"),
            keywords: &["اسٽرا سان ڪپ", "سوڊا، جوس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බටය සමඟ කෝප\u{dca}පයක"),
            keywords: &["බටය සමඟ කෝප\u{dca}පයක", "ය\u{dd4}ෂ", "සෝඩ\u{dcf}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("pohár so slamkou"),
            keywords: &["džús", "limonáda", "pohár so slamkou"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kozarec s slamico"),
            keywords: &["kozarec s slamico"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("koob wata istaroow"),
            keywords: &[
                "casiir",
                "koob iyo istaroow",
                "koob wata istaroow",
                "soodha",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gotë me pipë"),
            keywords: &["gotë me pipë", "lëng", "pije freskuese"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("чаша са сламчицом"),
            keywords: &["газирано", "сок", "чаша са сламчицом"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("čaša sa slamčicom"),
            keywords: &["gazirano", "sok", "čaša sa slamčicom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("mugg med sugrör"),
            keywords: &["juice", "läskedryck", "mugg med sugrör"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kikombe chenye mrija"),
            keywords: &["kikombe chenye mrija", "maji ya machungwa", "soda"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஸ\u{bcd}ட\u{bcd}ர\u{bbe} உள\u{bcd}ள கோப\u{bcd}பை"),
            keywords: &[
                "சோட\u{bbe}",
                "ஜூஸ\u{bcd}",
                "பழச\u{bcd}ச\u{bbe}று",
                "ஸ\u{bcd}ட\u{bcd}ர\u{bbe} உள\u{bcd}ள கோப\u{bcd}பை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c4d}ట\u{c4d}ర\u{c3e}త\u{c4b} కప\u{c4d}"),
            keywords: &[
                "జ\u{c4d}యూస\u{c4d}",
                "స\u{c4b}డ\u{c3e}",
                "స\u{c4d}ట\u{c4d}ర\u{c3e}త\u{c4b} కప\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("пиёла бо чӯбак"),
            keywords: &["оби газдор", "пиёла бо чӯбак", "шарбат"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แก\u{e49}วพร\u{e49}อมหลอด"),
            keywords: &[
                "น\u{e49}ำผลไม\u{e49}",
                "น\u{e49}ำอ\u{e31}ดลม",
                "แก\u{e49}วพร\u{e49}อมหลอด",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("turbajykly stakan"),
            keywords: &["mineral suw", "turbajykly stakan", "şire"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ipu moe vaʻakauinu"),
            keywords: &["ipu moe vaʻakauinu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("pipetli bardak"),
            keywords: &["pipetli bardak"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سۈمۈرگۈچلۈك قاچا"),
            keywords: &["سودا", "سۈمۈرگۈچلۈك قاچا", "شەربەت"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("стакан із трубочкою"),
            keywords: &["содова", "стакан із трубочкою", "сік"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کپ اور اسٹرا"),
            keywords: &["جوس", "سوڈا", "کپ اور اسٹرا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("stakan bilan cho‘p"),
            keywords: &[
                "fanta",
                "gaz suv",
                "kola",
                "mineral suv",
                "pepsi",
                "stakan bilan cho‘p",
                "suv",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cốc và ống hút"),
            keywords: &["cốc và ống hút", "nước ép", "soda"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kaas ak paay"),
            keywords: &["jus", "kaas ak paay", "soda"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ikomityi enestro"),
            keywords: &["ijusi", "ikomityi enestro", "isoda"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ife pẹ\u{300}lú sírọ\u{300}"),
            keywords: &["ife pẹ\u{300}lú sírọ\u{300}", "sódà", "ẹlẹ\u{301}rìndòdò"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("飲管杯"),
            keywords: &["果汁", "梳打", "飲管杯"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("饮管杯"),
            keywords: &["果汁", "梳打", "饮管杯"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("带吸管杯"),
            keywords: &["带吸管杯", "果汁", "苏打"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("杯子和吸管"),
            keywords: &["杯子和吸管"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("有飲管嘅杯"),
            keywords: &["有飲管嘅杯", "果汁", "汽水"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inkomishi enomucu wokumoma"),
            keywords: &["ijusi", "inkomishi enomucu wokumoma", "isoda"],
        },
    ],
};
#[doc = "🧋"]
pub const BUBBLE_TEA: crate::Emoji = crate::Emoji {
    glyph: "🧋",
    codepoint: "1F9CB",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "bubble tea",
    group: "Food & Drink",
    subgroup: "drink",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("borreltee"),
            keywords: &["borrel", "borreltee", "melk", "pêrels", "tee"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የአረፋ ሻይ"),
            keywords: &["የአረፋ ሻይ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شاي الفقاعات"),
            keywords: &["حليب", "شاي", "شاي الفقاعات", "فقاعات"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ব\u{9be}বল চ\u{9be}হ"),
            keywords: &[
                "গ\u{9be}খীৰ",
                "চ\u{9be}হ",
                "প\u{9be}ৰ\u{9cd}ল",
                "ব\u{9be}বল",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("köpüklü çay"),
            keywords: &["köpük", "köpüklü çay", "mirvari", "süd", "çay"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чай з шарыкамі"),
            keywords: &["жамчужны", "малако", "чай", "чай з шарыкамі", "шарыкі"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("перлен чай"),
            keywords: &["балончета", "мляко", "перлен чай", "перли", "чай"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9be}বল টি"),
            keywords: &[
                "চ\u{9be}",
                "দ\u{9c1}ধ",
                "প\u{9be}র\u{9cd}ল",
                "ব\u{9be}বল",
                "ব\u{9be}বল টি",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("boba čaj"),
            keywords: &["boba čaj", "kuglice", "mjehurići", "mlijeko", "čaj"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("te amb bombolles"),
            keywords: &["bombolla", "llet", "perla", "te", "te amb bombolles"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏚᏆᎷᏒ ᎤᎦᎶᎦ"),
            keywords: &["ᎤᎦᎶᎦ", "ᎤᏅᏗ", "ᏓᎬᎾ", "ᏚᏆᎷᏒ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("bublinkový čaj"),
            keywords: &[
                "bubble tea",
                "bublinkový",
                "mléčný",
                "perlivý",
                "perličkový",
                "perličky",
                "čaj",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("te swigod"),
            keywords: &["llaeth", "perl", "swigod", "te"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bubble tea"),
            keywords: &["bobler", "boblete", "bubble tea", "mælk", "perler", "te"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Bubble Tea"),
            keywords: &["Blase", "Bubble Tea", "Milch", "Perle", "Tee"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("bubble tea"),
            keywords: &["bubble", "bubble tea", "γάλα", "πέρλες", "τσάι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("bubble tea"),
            keywords: &["bubble", "milk", "pearl", "tea"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("té de burbujas"),
            keywords: &[
                "boba",
                "bubble tea",
                "burbuja",
                "leche",
                "perla",
                "té",
                "té de burbujas",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("té de burbujas"),
            keywords: &["burbuja", "leche", "perla", "té", "té de burbujas"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("té de burbujas"),
            keywords: &["té de burbujas"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("té de burbujas"),
            keywords: &["té de burbujas"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("pärlitee"),
            keywords: &["mull", "piim", "pärl", "pärlitee", "tee"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("te burbuiladun"),
            keywords: &["burbuila", "esnea", "perla", "te burbuiladun", "tea"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("چای ح\u{64f}بابی"),
            keywords: &["حباب", "شیر", "مروارید", "چای", "چای ح\u{64f}بابی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kuplatee"),
            keywords: &["helmi", "kupla", "kuplatee", "maito", "tee"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bubble tea"),
            keywords: &["bubble", "bubble tea", "gatas", "pearl", "tsaa"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("boba te"),
            keywords: &["Taivan", "boba", "te"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("thé aux perles"),
            keywords: &["bulle", "lait", "perle", "thé aux perles"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("thé aux perles"),
            keywords: &["lait", "perles", "thé", "thé aux perles"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("tae bolgán"),
            keywords: &["tae bolgán"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("tì builgein"),
            keywords: &["bainne", "builgean", "teatha", "tì", "tì builgein"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("té de burbullas"),
            keywords: &["burbullas", "leite", "perlas", "té", "té de burbullas"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બબલ ટી"),
            keywords: &["ટી", "દ\u{ac2}ધ", "પરપોટા", "પર\u{acd}લ", "બબલ"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("באבל טי"),
            keywords: &["באבל טי", "בועות", "חלב", "טאיוואן", "תה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ब\u{941}लब\u{941}ला चाय"),
            keywords: &["चाय", "द\u{942}ध", "ब\u{941}लब\u{941}ला"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("mjehuričasti čaj"),
            keywords: &["kuglica", "mjehurići", "mjehuričasti čaj", "mlijeko", "čaj"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("buborékos tea"),
            keywords: &["buborék", "buborékos tea", "gyöngy", "tea", "tej"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("պղպջակներով թեյ"),
            keywords: &["թեյ", "կաթ", "մարգարիտ", "պղպջակ", "պղպջակներով թեյ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("teh bubble"),
            keywords: &["bubble", "pearl", "susu", "teh"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kúlute"),
            keywords: &["kúlur", "kúlute", "mjólk", "perlur", "te"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("bubble tea"),
            keywords: &["bolla", "bubble tea", "latte", "perla", "sfera", "tè"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("タピオカドリンク"),
            keywords: &[
                "お茶",
                "タピオカ",
                "タピオカドリンク",
                "ドリンク",
                "バブルティー",
                "ミルクティー",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("teh kocok"),
            keywords: &["mutiyara", "plembungan", "susu", "teh", "teh kocok"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბაბლ ჩაი"),
            keywords: &["ბაბლ", "ბობა", "ბუშტები", "ჩაი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("көбікті шай"),
            keywords: &["көбікті шай", "сүт", "түйіршік", "шай", "інжу"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("តែគ\u{17bb}ជ"),
            keywords: &["គ\u{17bb}ជ", "តែ", "តែគ\u{17bb}ជ", "ទ\u{17b9}កដោះគោ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬಬಲ\u{ccd} ಟೀ"),
            keywords: &["ಚಹಾ", "ಬಬಲ\u{ccd}", "ಬಬಲ\u{ccd} ಟೀ", "ಮುತ\u{ccd}ತು", "ಹಾಲು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("버블티"),
            keywords: &["버블", "버블티", "우유", "차", "펄"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("वाफ य\u{947}वपी च\u{94d}या"),
            keywords: &[
                "च\u{94d}या",
                "द\u{942}द",
                "मोती",
                "वाफ",
                "वाफ य\u{947}वपी च\u{94d}या",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("көбүргөн чай"),
            keywords: &["көбүргөн чай"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຊາໄຂ\u{ec8}ມ\u{eb8}ກ"),
            keywords: &[
                "ຊາ",
                "ຊາໄຂ\u{ec8}ມ\u{eb8}ກ",
                "ນ\u{ebb}ມ",
                "ໄຂ\u{ec8}ມ\u{eb8}ກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("burbulinė arbata"),
            keywords: &["arbata", "burbulai", "burbulinė arbata", "pienas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("burbuļtēja"),
            keywords: &["burbulis", "burbuļtēja", "piens", "pērle", "tēja"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("чај со топчиња"),
            keywords: &["бисер", "меурче", "млеко", "чај", "чај со топчиња"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ബബിൾ ടീ"),
            keywords: &["ച\u{d3e}യ", "പവിഴം", "പ\u{d3e}ൽ", "ബബിൾ", "ബബിൾ ടീ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бөмбөлөгтэй цай"),
            keywords: &["бөмбөлөг", "бөмбөлөгтэй цай", "сувд", "сүү", "цай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("बबल टी"),
            keywords: &[
                "चहा",
                "द\u{942}ध",
                "पर\u{94d}ल",
                "बबल टी",
                "ब\u{941}डब\u{941}डा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("teh buih"),
            keywords: &["buih", "mutiara", "susu", "teh"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပ\u{102f}လ\u{1032} လက\u{103a}ဖက\u{103a}ရည\u{103a}"),
            keywords: &[
                "န\u{102d}\u{102f}\u{1037}",
                "ပ\u{102f}လ\u{1032}",
                "လက\u{103a}ဖက\u{103a}ရည\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("boble-te"),
            keywords: &["boble-te", "bobler", "kuler", "melk", "perler", "te"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बबल चिया"),
            keywords: &["चिया", "द\u{942}ध", "बबल", "मोती"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bubbelthee"),
            keywords: &["bubbel", "bubbelthee", "melk", "parel", "thee"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("boble-te"),
            keywords: &["boble-te", "bobler", "kuler", "mjølk", "perler", "te"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b41}ଦ\u{b4d}\u{200c}ବ\u{b41}ଦ\u{b4d}\u{200c} ଚ\u{b3e}"),
            keywords: &[
                "ଚ\u{b3e}",
                "ଦ\u{b41}ଗ\u{b4d}ଧ",
                "ବ\u{b41}ଦ\u{b4d}\u{200c}ବ\u{b41}ଦ\u{b4d}\u{200c}",
                "ମୋତ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬਬਲ ਚਾਹ"),
            keywords: &[
                "ਚਾਹ",
                "ਦ\u{a41}\u{a71}ਧ",
                "ਬਬਲ ਚਾਹ",
                "ਬ\u{a41}ਲਬ\u{a41}ਲ\u{a47}ਦਾਰ",
                "ਮ\u{a4b}ਤੀ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bọ\u{301}búl Tii"),
            keywords: &["Bọ\u{300}bul", "Bọ\u{301}búl Tii", "Mílik", "Pẹal", "Tii"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("napój bubble tea"),
            keywords: &[
                "herbata",
                "kuleczka",
                "kulki tapioki",
                "mleko",
                "napój bubble tea",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ببل چای"),
            keywords: &["الماس", "ببل", "شيدې", "چای"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("chá perolado"),
            keywords: &["bolha", "chá", "chá perolado", "leite", "pérola"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("chá bubble"),
            keywords: &[
                "bolha",
                "chá",
                "chá bubble",
                "chá perolado",
                "leite",
                "pérola",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("phukpu te"),
            keywords: &["perla", "phukpu", "te", "wilali"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ceai cu perle"),
            keywords: &["ceai", "ceai cu perle", "lapte", "perle"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-045"),
            keywords: &["E13-045"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("чай с шариками"),
            keywords: &[
                "баббл",
                "бабл",
                "жемчужина",
                "молоко",
                "чай",
                "чай с шариками",
                "шарик",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ببل چانهن"),
            keywords: &["ببل", "پرل", "چانهن", "کير"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බ\u{dd4}බ\u{dd4}ල\u{dd4} තේ"),
            keywords: &[
                "ක\u{dd2}ර\u{dd2}",
                "තේ",
                "බ\u{dd4}බ\u{dd4}ල",
                "බ\u{dd4}බ\u{dd4}ල\u{dd4} තේ",
                "ම\u{dd4}ත\u{dd4}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("perlivý čaj"),
            keywords: &["bublinky", "mlieko", "perlivý čaj", "čaj"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("čaj s kroglicami"),
            keywords: &["biser", "mleko", "pena", "čaj", "čaj s kroglicami"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("shaah xumbaale"),
            keywords: &["caano", "luul", "shaah", "shaah xumbaale", "xumbo"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("çaj me flluska"),
            keywords: &["flluska", "perlë", "qumësht", "çaj", "çaj me flluska"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("чај са бобицама"),
            keywords: &["бобице", "млеко", "чај", "чај са бобицама"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["чај са бобицама"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("čaj sa bobicama"),
            keywords: &["bobice", "mleko", "čaj", "čaj sa bobicama"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["čaj sa bobicama"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("bubbelte"),
            keywords: &["bubbelte", "milkshake", "pärlor", "te"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("chai ya maziwa ya boba"),
            keywords: &["chai", "chai ya maziwa ya boba", "lulu", "maziwa", "viputo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("குமிழித\u{bcd} தேந\u{bc0}ர\u{bcd}"),
            keywords: &[
                "குமிழி",
                "குமிழித\u{bcd} தேந\u{bc0}ர\u{bcd}",
                "தேந\u{bc0}ர\u{bcd}",
                "ப\u{bbe}ல\u{bcd}",
                "முத\u{bcd}து",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బబుల\u{c4d} ట\u{c40}"),
            keywords: &["ట\u{c40}", "ప\u{c3e}లు", "బబుల\u{c4d}", "ముత\u{c4d}యం"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ชาไข\u{e48}ม\u{e38}ก"),
            keywords: &[
                "ชา",
                "ชานม",
                "ชาไข\u{e48}ม\u{e38}ก",
                "นม",
                "ไข\u{e48}ม\u{e38}ก",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("köpürjikli çaý"),
            keywords: &["köpürjik", "köpürjikli çaý", "merjen", "süýt", "çaý"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tī maʻupu"),
            keywords: &["tī maʻupu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("bubble tea"),
            keywords: &["baloncuk", "bubble tea", "inci", "inci çayı", "süt", "çay"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("бульбашковий чай"),
            keywords: &["бульбашковий", "молочний", "перловий", "чай"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بلبلوں والی چائے"),
            keywords: &["بلبلوں والی چائے", "بلبلہ", "دودھ", "موتی", "چائے"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("koʻpikli choy"),
            keywords: &[
                "choy",
                "koʻpik",
                "koʻpikli choy",
                "marvarid",
                "pufak",
                "sut",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trà sữa"),
            keywords: &["bong bóng", "ngọc trai", "sữa", "trà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("珍珠奶茶"),
            keywords: &["泡", "牛奶", "珍珠", "珍珠奶茶", "茶"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("珍珠奶茶"),
            keywords: &["泡", "牛奶", "珍珠", "珍珠奶茶", "茶"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("珍珠奶茶"),
            keywords: &["泡泡", "牛奶", "珍珠", "珍珠奶茶", "茶"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("珍珠奶茶"),
            keywords: &["手搖", "珍奶", "珍珠", "珍珠奶茶"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("itiye le-bubble"),
            keywords: &["i-bubble", "i-pearl", "itiye", "itiye le-bubble", "ubisi"],
        },
    ],
};
#[doc = "🧃"]
pub const BEVERAGE_BOX: crate::Emoji = crate::Emoji {
    glyph: "🧃",
    codepoint: "1F9C3",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "beverage box",
    group: "Food & Drink",
    subgroup: "drink",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("koeldrankboksie"),
            keywords: &["koeldrankboksie", "sapboksie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የመጠጥ ሳጥን"),
            keywords: &["የመጠጥ ሳጥን", "የጭማቂ ሳጥን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("علبة عصير"),
            keywords: &["عبوة عصير", "عصير", "علبة عصير"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9be}নীয\u{9bc} ব\u{9be}কচ"),
            keywords: &["প\u{9be}নীয\u{9bc} ব\u{9be}কচ", "ফলৰ ৰসৰ ব\u{9be}কচ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("içki qutusu"),
            keywords: &["içki qutusu", "şirə qutusu"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("пачак з напоем"),
            keywords: &["пачак з напоем", "пачак соку"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("кутия за напитки"),
            keywords: &["кутия за напитки", "кутия за сок"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9be}নীয\u{9bc}"),
            keywords: &["জ\u{9c1}স ব\u{9be}ক\u{9cd}স", "প\u{9be}নীয\u{9bc}"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("brikennigad evaj"),
            keywords: &["brikennigad", "chug-frouezh", "evaj"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("sok u tetrapaku"),
            keywords: &[
                "gusti sok u tetrapaku",
                "piće",
                "slamka",
                "slatko",
                "sok u tetrapaku",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bric"),
            keywords: &["bric", "bric de suc"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏗᏔᏍᏗ ᎧᏁᏌᎢ"),
            keywords: &["ᎠᏗᏔᏍᏗ ᎧᏁᏌᎢ", "ᎤᏓᏁᏅᎯ ᎧᏁᏌᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("nápoj v krabičce"),
            keywords: &[
                "krabicový džus",
                "krabičkové pití",
                "nápoj v krabičce",
                "nápojová krabice",
                "pití v krabičce",
                "pitíčko",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("blwch diodydd"),
            keywords: &["blwch diodydd", "blwch sudd ffrwythau"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("brik"),
            keywords: &["brik", "juicebrik"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Trinkpäckchen"),
            keywords: &["Getränk", "Saftpackung", "Trinkpäckchen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κουτί ροφήματος"),
            keywords: &["κουτί ροφήματος", "κουτί χυμού"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("beverage box"),
            keywords: &["beverage", "box", "juice", "straw", "sweet"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("drink carton"),
            keywords: &["drink carton", "juice box", "popper"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("tetrabrik"),
            keywords: &["brick", "cartón", "envase", "tetrabrik", "zumo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("bebida en caja"),
            keywords: &[
                "bebida",
                "bebida en caja",
                "caja",
                "dulce",
                "jugo",
                "popote",
                "tetrapak",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("joogipakk"),
            keywords: &["joogipakk", "mahlapakk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("edari-tetrabrika"),
            keywords: &["edari-tetrabrika", "zuku-tetrabrika"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پاکت نوشیدنی"),
            keywords: &["پاکت آب\u{200c}میوه", "پاکت نوشیدنی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("juomatetra"),
            keywords: &["juomatetra", "pillijuoma"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kahon ng inumin"),
            keywords: &["inumin", "juice", "kahon ng inumin", "kahon ng juice"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sunkist"),
            keywords: &["drykkur", "saft", "sevja", "sunkist", "søtt"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("briquette de jus"),
            keywords: &["briquette de jus", "carton", "jus de fruits"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "boîte à boire",
                "briquette de jus",
                "carton",
                "jus de fruits",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bosca dí"),
            keywords: &["bosca", "bosca dí", "deoch", "milis", "sop", "sú"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("carton dighe"),
            keywords: &["bogsa", "carton", "carton dighe", "deoch", "sùgh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("brik"),
            keywords: &["brik", "cartón", "tetra brik", "zume"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પીણા\u{a82}ન\u{ac1}\u{a82} ખોખ\u{ac1}\u{a82}"),
            keywords: &[
                "જ\u{acd}ય\u{ac2}સ બૉક\u{acd}સ",
                "પીણા\u{a82}ન\u{ac1}\u{a82} ખોખ\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קופסת מיץ"),
            keywords: &["משקאות", "קופסת מיץ", "קופסת משקה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ज\u{942}स का डब\u{94d}बा"),
            keywords: &["ज\u{942}स का डब\u{94d}बा", "ज\u{942}स बॉक\u{94d}स"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("sok u tetrapaku"),
            keywords: &["sok", "sok u tetrapaku", "tetrapak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("italos doboz"),
            keywords: &["gyümölcsleves doboz", "italos doboz"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("խմիչքի տուփ"),
            keywords: &["խմիչքի տուփ", "հյութի տուփ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kotak minuman"),
            keywords: &["kotak jus", "kotak minuman"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ferna"),
            keywords: &["ferna", "safaferna"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("bevanda monodose"),
            keywords: &[
                "bevanda in brick",
                "bevanda monodose",
                "succo di frutta in cartone",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("紙パック飲料"),
            keywords: &["ジュース", "ドリンク", "紙パック飲料", "飲み物"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wedang kothakan"),
            keywords: &["jus kothakan", "wedang kothakan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("წვენი პაკეტში"),
            keywords: &["მუყაო", "პაკეტი", "ჩხირი", "წვენი", "წვენი პაკეტში"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сусын қорабы"),
            keywords: &["сусын қорабы", "шырын қорабы"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ក\u{17c6}ប\u{17c9}\u{17bb}ងភេសជ\u{17d2}ជៈ"),
            keywords: &[
                "ក\u{17c6}ប\u{17c9}\u{17bb}ងទ\u{17b9}កផ\u{17d2}លែឈើ",
                "ក\u{17c6}ប\u{17c9}\u{17bb}ងភេសជ\u{17d2}ជៈ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪಾನೀಯದ ಬಾಕ\u{ccd}ಸ\u{ccd}"),
            keywords: &[
                "ಜ\u{ccd}ಯ\u{cc2}ಸ\u{ccd} ಬಾಕ\u{ccd}ಸ\u{ccd}",
                "ಪಾನೀಯದ ಬಾಕ\u{ccd}ಸ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("음료 팩"),
            keywords: &["음료 팩", "쥬스 팩"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("प\u{947}य बॉक\u{94d}स"),
            keywords: &["ज\u{94d}य\u{941}स बॉक\u{94d}स", "प\u{947}य बॉक\u{94d}स"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("суусундук кутусу"),
            keywords: &["суусундук кутусу", "шире кутусу"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some(
                "ກ\u{ec8}\u{200b}ອງ\u{200b}ໃສ\u{ec8}\u{200b}ເຄ\u{eb7}\u{ec8}ອງ\u{200b}ດ\u{eb7}\u{ec8}ມ",
            ),
            keywords: &[
                "ກ\u{ec8}\u{200b}ອງ\u{200b}ນ\u{ec9}ຳ\u{200b}ໝາກ\u{200b}ໄມ\u{ec9}",
                "ກ\u{ec8}\u{200b}ອງ\u{200b}ໃສ\u{ec8}\u{200b}ເຄ\u{eb7}\u{ec8}ອງ\u{200b}ດ\u{eb7}\u{ec8}ມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("gėrimo pakelis"),
            keywords: &["gėrimo pakelis", "sulčių pakelis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("dzēriena kārba"),
            keywords: &["dzēriena kārba", "sulas kārba", "sulas paka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("сокче во тетрапак"),
            keywords: &["сокче", "сокче во тетрапак"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ബിവറേജ\u{d4d} ബോക\u{d4d}\u{200c}സ\u{d4d}"),
            keywords: &[
                "ജ\u{d4d}യ\u{d42}സ\u{d4d} ബോക\u{d4d}\u{200c}സ\u{d4d}",
                "ബിവറേജ\u{d4d} ബോക\u{d4d}\u{200c}സ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ундааны хайрцаг"),
            keywords: &[
                "соруул",
                "ундааны хайрцаг",
                "уух юм",
                "хайрцаг",
                "чихэрлэг",
                "шүүс",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{947}य बॉक\u{94d}स"),
            keywords: &["ज\u{94d}य\u{942}स बॉक\u{94d}स", "प\u{947}य बॉक\u{94d}स"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("minuman air kotak"),
            keywords: &[
                "jus",
                "kotak",
                "manis",
                "minuman",
                "minuman air kotak",
                "straw",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အဖျော\u{103a}ရေ ဘ\u{1030}း"),
            keywords: &[
                "အဖျော\u{103a}ရေ ဘ\u{1030}း",
                "အသ\u{102e}းဖျော\u{103a}ရေ ဘ\u{1030}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("drikkekartong"),
            keywords: &["drikkekartong", "juicekartong", "juskartong"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{947}य बाकस"),
            keywords: &["ज\u{941}स बाकस", "प\u{947}य बाकस"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("pakje drinken"),
            keywords: &["drankje", "pakje", "pakje drinken", "rietje", "sap", "zoet"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("drikkekartong"),
            keywords: &["drikkekartong", "juicekartong", "juskartong"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପେୟ ଡବ\u{b3e}"),
            keywords: &["ଜ\u{b41}ସ ଡବ\u{b3e}", "ପେୟ ଡବ\u{b3e}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a47}ਅ ਬਾਕਸ"),
            keywords: &["ਜ\u{a42}ਸ ਵਾਲਾ ਬਾਕਸ", "ਪ\u{a47}ਅ ਬਾਕਸ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Drínk Bọks"),
            keywords: &["Bọks", "Drink", "Drínk Bọks", "Jus", "Strọ", "Swit"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("napój w kartoniku"),
            keywords: &["napój w kartoniku", "sok w kartoniku", "słodki", "słomka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د څښاک دبلی"),
            keywords: &["د جوسو دبلی", "د څښاک دبلی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("suco de caixa"),
            keywords: &["caixa de suco", "suco de caixa"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("pacote de sumo"),
            keywords: &["pacote de sumo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("upyana tawakʼuchu"),
            keywords: &["jugo", "miskʼi", "pajilla", "tawakʼuchu", "upyana"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cutie de băutură"),
            keywords: &["cutie de băutură", "cutie de suc"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–042"),
            keywords: &["E12–042"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("пакетик сока"),
            keywords: &[
                "картон",
                "напиток",
                "пакет",
                "пакетик сока",
                "сок",
                "трубочка",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بيوريج باڪس"),
            keywords: &["بيوريج باڪس", "جوس باڪس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බ\u{dd3}ම පෙට\u{dca}ට\u{dd2}ය"),
            keywords: &[
                "බ\u{dd3}ම පෙට\u{dca}ට\u{dd2}ය",
                "ය\u{dd4}ෂ පෙට\u{dca}ට\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("nápoj v krabičke"),
            keywords: &[
                "džús v krabičke",
                "krabicový džús",
                "nápoj v krabičke",
                "nápojová krabička",
                "pitie v krabičke",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("tetrapak s pijačo"),
            keywords: &["tetrapak s pijačo", "tetrapak s sokom"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("sanduuq cabitaan"),
            keywords: &["sanduuq cabitaan", "sanduuq casiir ah"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kuti pijeje"),
            keywords: &["kuti lëngjesh", "kuti pijeje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("пиће у тетрапаку"),
            keywords: &["пиће у тетрапаку", "сок у тетрапаку"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("piće u tetrapaku"),
            keywords: &["piće u tetrapaku", "sok u tetrapaku"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("dryckeskartong"),
            keywords: &["dryckesförpackning", "dryckeskartong"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("chupa ya kinywaji"),
            keywords: &["chupa ya kinywaji", "katoni ya juisi", "katoni ya kinywaji"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("குடிப\u{bbe}னப\u{bcd} பெட\u{bcd}டி"),
            keywords: &[
                "குடிப\u{bbe}னப\u{bcd} பெட\u{bcd}டி",
                "ஜூஸ\u{bcd} டப\u{bcd}ப\u{bbe}",
                "ஜூஸ\u{bcd} ப\u{bbe}க\u{bcd}ஸ\u{bcd}",
                "ஜூஸ\u{bcd} பெட\u{bcd}டி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c3e}న\u{c40}య\u{c3e}ల ప\u{c46}ట\u{c4d}ట\u{c46}"),
            keywords: &[
                "జ\u{c4d}యూస\u{c4d} ప\u{c46}ట\u{c4d}ట\u{c46}",
                "ప\u{c3e}న\u{c40}య\u{c3e}ల ప\u{c46}ట\u{c4d}ట\u{c46}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เคร\u{e37}\u{e48}องด\u{e37}\u{e48}มแบบกล\u{e48}อง"),
            keywords: &[
                "น\u{e49}ำผลไม\u{e49}แบบกล\u{e48}อง",
                "เคร\u{e37}\u{e48}องด\u{e37}\u{e48}มแบบกล\u{e48}อง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("içgi gutusy"),
            keywords: &["guty", "içgi", "içgi gutusy", "saman", "süýji", "şire"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("puha inu"),
            keywords: &["puha inu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("içecek kutusu"),
            keywords: &["içecek kutusu", "kutu meyve suyu"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("пакетик із напоєм"),
            keywords: &[
                "картонний",
                "напій",
                "пакет",
                "пакетик із напоєм",
                "соломинка",
                "сік",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مشروب کا ڈبہ"),
            keywords: &["جوس کا ڈبہ", "مشروب کا ڈبہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ichimlik qutisi"),
            keywords: &["ichimlik qutisi", "sharbat qutisi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hộp đồ uống"),
            keywords: &["hộp nước trái cây", "hộp đồ uống"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("紙包飲品"),
            keywords: &["果汁", "甜", "盒", "紙包飲品", "飲品", "飲筒"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("纸包饮品"),
            keywords: &["果汁盒", "纸包饮品"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("饮料盒"),
            keywords: &["吸管", "果汁盒", "盒装", "饮料盒"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("鋁箔包"),
            keywords: &["果汁", "鋁箔包"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("紙包裝"),
            keywords: &["果汁", "紙包裝"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhokisi leziphuzo"),
            keywords: &["ibhokisi lamajusi", "ibhokisi leziphuzo"],
        },
    ],
};
#[doc = "🧉"]
pub const MATE: crate::Emoji = crate::Emoji {
    glyph: "🧉",
    codepoint: "1F9C9",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "mate",
    group: "Food & Drink",
    subgroup: "drink",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("maté"),
            keywords: &["drankie", "maté"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ግጣም"),
            keywords: &["መጠጥ", "ግጣም"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("متة"),
            keywords: &["شراب", "متة", "مشروب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মে’ট"),
            keywords: &["প\u{9be}নীয\u{9bc}", "মে’ট"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("mate"),
            keywords: &["içki", "mate"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("матэ"),
            keywords: &["матэ", "напой"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("мате"),
            keywords: &["мате", "напитка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মেট"),
            keywords: &["প\u{9be}নীয\u{9bc}", "মেট"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("mate"),
            keywords: &["evaj", "mate"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("mate čaj"),
            keywords: &["mate čaj", "topli napitak"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("mate"),
            keywords: &["beguda", "mate"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎩᎶᎩ ᎠᏗᏔᏍᏗ"),
            keywords: &["ᎠᏗᏔᏍᏗ", "ᎤᎩᎶᎩ ᎠᏗᏔᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("maté"),
            keywords: &["maté", "nápoj"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("maté"),
            keywords: &["diod", "maté"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mate"),
            keywords: &["drik", "mate"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Mate-Tee"),
            keywords: &["Getränk", "Mate-Tee"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μάτε"),
            keywords: &["μάτε", "ρόφημα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("mate"),
            keywords: &["drink", "mate"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("maté"),
            keywords: &["drink", "maté"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("maté"),
            keywords: &["drink", "maté"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("mate"),
            keywords: &["bebida", "infusión", "mate"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("mate"),
            keywords: &["jook", "mate", "tee"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("matea"),
            keywords: &["edaria", "matea"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ماته"),
            keywords: &["ماته", "نوشیدنی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("mate"),
            keywords: &["juoma", "mate"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mate"),
            keywords: &["inumin", "mate"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("mate"),
            keywords: &["drykkur", "mate"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("maté"),
            keywords: &["boisson", "maté"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("maité"),
            keywords: &["deoch", "maité"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("tì mate"),
            keywords: &["deoch", "mate", "teatha", "tì"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("mate"),
            keywords: &["A Arxentina", "bebida", "infusión", "mate"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મ\u{ac5}ટ"),
            keywords: &["પીણ\u{ac1}\u{a82}", "મ\u{ac5}ટ"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מאטה"),
            keywords: &["מאטה", "משקאות", "קפאין"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("म\u{947}ट"),
            keywords: &["प\u{947}य पदार\u{94d}थ", "म\u{947}ट"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("mate"),
            keywords: &["mate", "piće", "čaj"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("maté"),
            keywords: &["ital", "maté"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մատե"),
            keywords: &["ըմպելիք", "խմիչք", "մատե"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("teh mate"),
            keywords: &["minuman", "teh mate"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("mate"),
            keywords: &["drykkur", "mate"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("mate"),
            keywords: &["bevanda", "erba Mate", "mate"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("マテ茶"),
            keywords: &["お茶", "ドリンク", "マテ茶", "飲み物"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("teh mate"),
            keywords: &["teh mate", "unjukan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მატე"),
            keywords: &["მატე", "სასმელი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("мате"),
            keywords: &["мате", "сусын"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17c9}ាតេ"),
            keywords: &["ភេសជ\u{17d2}ជៈ", "ម\u{17c9}ាតេ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮೇಟ\u{ccd}"),
            keywords: &["ಪಾನೀಯ", "ಮೇಟ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("마테차"),
            keywords: &["마테차", "음료", "차"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मातय\u{947}ची हा\u{902}डी"),
            keywords: &["पिण\u{947}\u{902}", "मातय\u{947}ची हा\u{902}डी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("мате"),
            keywords: &["мате", "суусундук"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເມດ"),
            keywords: &["ເຄ\u{eb7}\u{ec8}\u{200b}ອງ\u{200b}ດ\u{eb7}\u{ec8}ມ", "ເມດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("matė"),
            keywords: &["gėrimas", "matė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("mate"),
            keywords: &["dzēriens", "mate"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("мате"),
            keywords: &["мате", "пијалак"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മെയ\u{d4d}\u{200c}റ\u{d4d}റ\u{d4d}"),
            keywords: &["പ\u{d3e}നീയം", "മെയ\u{d4d}\u{200c}റ\u{d4d}റ\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("матэ"),
            keywords: &["матэ", "унд"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("म\u{947}ट"),
            keywords: &["प\u{947}य", "म\u{947}ट"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("mate"),
            keywords: &["mate", "minuman"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ချ\u{102e}မာရအ\u{102d}\u{102f}"),
            keywords: &["ချ\u{102e}မာရအ\u{102d}\u{102f}", "သောက\u{103a}စရာ"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mate"),
            keywords: &["drikke", "mate"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("मित\u{94d}र"),
            keywords: &["प\u{947}य", "मित\u{94d}र"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("maté"),
            keywords: &["drank", "maté"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mate"),
            keywords: &["drikke", "mate"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମେଟ"),
            keywords: &["ପ\u{b3f}\u{200d}ଇବ\u{b3e}", "ମେଟ", "ସଖ\u{b3e}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a47}ਟ"),
            keywords: &["ਪ\u{a47}ਅ ਪਦਾਰਥ", "ਮ\u{a47}ਟ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Matẹẹ"),
            keywords: &["Drink", "Matẹẹ"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("yerba mate"),
            keywords: &["napój", "yerba mate"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("يو ډول څښاک"),
            keywords: &["يو ډول څښاک", "څښاک"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mate"),
            keywords: &["bebida", "mate"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("mate"),
            keywords: &["mate", "upyana"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("mate"),
            keywords: &["băutură", "mate"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–048"),
            keywords: &["E12–048"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мате"),
            keywords: &["мате", "матэ", "напиток", "пить", "трубочка", "чай"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ميٽ"),
            keywords: &["ميٽ", "ڊرنڪ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අත\u{dca} උදව\u{dca}කර\u{dd4}ව\u{dcf}"),
            keywords: &["අත\u{dca} උදව\u{dca}කර\u{dd4}ව\u{dcf}", "ප\u{dcf}නය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("maté"),
            keywords: &["maté", "nápoj", "pitie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("mate čaj"),
            keywords: &["mate čaj", "napitek", "pijača"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("lamaane"),
            keywords: &["cab", "lamaane"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kimarrao"),
            keywords: &["kimarrao", "pije"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мате"),
            keywords: &["мате", "пиће"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("mate"),
            keywords: &["mate", "piće"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("mate-te"),
            keywords: &["dryck", "mate-te"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kinywaji cha mate"),
            keywords: &["kinywaji", "kinywaji cha mate"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மேட\u{bcd}"),
            keywords: &[
                "குளிர\u{bcd}ப\u{bbe}னம\u{bcd}",
                "ஜூஸ\u{bcd}",
                "ப\u{bbe}னம\u{bcd}",
                "மேட\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("జత"),
            keywords: &["జత", "ప\u{c3e}న\u{c40}యం"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ชามาเต"),
            keywords: &["ชามาเต", "เคร\u{e37}\u{e48}องด\u{e37}\u{e48}ม"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("dost"),
            keywords: &["dost", "içmek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kofi fakaʻamelika-tonga"),
            keywords: &["kofi fakaʻamelika-tonga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("mate çayı"),
            keywords: &["içecek", "mate çayı"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("мате"),
            keywords: &["калабас", "мате", "напій", "чай із падуба"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ہم پیالہ"),
            keywords: &["مشروب", "ہم پیالہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("mate"),
            keywords: &["ichimlik", "mate"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trà nhựa ruồi"),
            keywords: &["nước uống", "trà nhựa ruồi", "uống", "đồ uống"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("瑪黛茶"),
            keywords: &["瑪黛茶", "飲品"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("玛黛茶"),
            keywords: &["玛黛茶", "饮品"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("马黛茶"),
            keywords: &["茶", "饮料", "马黛茶"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("瑪黛茶"),
            keywords: &["瑪黛茶", "飲料"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["瑪黛茶", "飲品"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-mate"),
            keywords: &["i-mate", "isiphuzo"],
        },
    ],
};
#[doc = "🧊"]
pub const ICE: crate::Emoji = crate::Emoji {
    glyph: "🧊",
    codepoint: "1F9CA",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "ice",
    group: "Food & Drink",
    subgroup: "drink",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("ysblokkie"),
            keywords: &["koud", "ysberg", "ysblokkie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("በረዶ"),
            keywords: &["ቀዝቃዛ", "በረዶ", "የበረዶ ክምር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مكعب ثلج"),
            keywords: &["برد", "قمة جليد", "مكعب ثلج"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বৰফৰ ট\u{9c1}ক\u{9c1}ৰ\u{9be}"),
            keywords: &[
                "ঠ\u{9be}ণ\u{9cd}ড\u{9be}",
                "প\u{9be}নী-শিল",
                "বৰফ",
                "বৰফৰ ট\u{9c1}ক\u{9c1}ৰ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("buz kubu"),
            keywords: &["aysberq", "buz kubu", "soyuq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кубік лёду"),
            keywords: &["кубік лёду", "ледзяны", "халодны"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("кубче лед"),
            keywords: &["кубче лед", "ледено парче", "студено"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("আইস কিউব"),
            keywords: &[
                "আইস কিউব",
                "আইসব\u{9be}র\u{9cd}গ",
                "ঠ\u{9be}ন\u{9cd}ড\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("skornenn"),
            keywords: &["skorn", "skornenn", "yen"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kocka leda"),
            keywords: &["kocka leda", "ledeno"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("glaçó"),
            keywords: &["fred", "glaçó", "iceberg"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏁᏍᏓᎳ ᏧᎾᏏᏯ ᏅᎩ"),
            keywords: &["ᎤᏁᏍᏓᎳ", "ᎤᏁᏍᏓᎳ ᎡᏆ", "ᎤᏁᏍᏓᎳ ᏧᎾᏏᏯ ᏅᎩ", "ᎤᏴᏜ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kostka ledu"),
            keywords: &[
                "chlad",
                "kostka ledu",
                "led",
                "ledovec",
                "ledová kostka",
                "studený",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ciwb iâ"),
            keywords: &["ciwb iâ", "iâ", "mynydd iâ", "oer"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("isterning"),
            keywords: &["isbjerg", "isterning", "kold"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Eiswürfel"),
            keywords: &["Eisberg", "Eiswürfel", "kalt"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("παγάκι"),
            keywords: &["κρύο", "παγάκι", "παγόβουνο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("ice"),
            keywords: &["cold", "ice", "ice cube", "iceberg"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cubito de hielo"),
            keywords: &["cubito de hielo", "frío", "iceberg"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("hielo"),
            keywords: &["hielo"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("jääkuubik"),
            keywords: &["jää", "jääkuubik", "kuubik", "külm"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("izotz zatia"),
            keywords: &["hotza", "iceberga", "izotz zatia", "izotza"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قالب یخ"),
            keywords: &["سرد", "قالب یخ", "کوه یخی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("jääkuutio"),
            keywords: &["jääkuutio", "kylmä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("ice cube"),
            keywords: &["ice cube", "iceberg", "malamig", "yelo"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("ísterningur"),
            keywords: &["kalt", "terningur", "ísfjall", "ísterningur", "ísur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("glaçon"),
            keywords: &["froid", "glace", "glaçon", "iceberg"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ciúb oighir"),
            keywords: &["ciúb oighir", "cnoc oighir", "fuar"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ciùb deighe"),
            keywords: &[
                "beinn-deighe",
                "beinn-eighe",
                "ciùb deighe",
                "cnoc-deighe",
                "cnoc-eighre",
                "deig",
                "eigh",
                "eigh-bheinn",
                "fuar",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cubo de xeo"),
            keywords: &["cubo de xeo", "frío", "pedra de xeo", "xeo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("આઇસ ક\u{acd}ય\u{ac2}બ"),
            keywords: &[
                "આઇસ ક\u{acd}ય\u{ac2}બ",
                "ઠ\u{a82}ડ\u{ac1}\u{a82}",
                "બરફનો ડ\u{ac1}\u{a82}ગર",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קוביית קרח"),
            keywords: &["קוביית קרח", "קר", "קרח"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("आइस क\u{94d}य\u{942}ब"),
            keywords: &[
                "आइस क\u{94d}य\u{942}ब",
                "आइसबर\u{94d}ग",
                "ठ\u{902}डा",
                "बर\u{94d}फ\u{93c}",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kocka leda"),
            keywords: &["blok leda", "hladno", "kocka leda", "santa leda"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("jégkocka"),
            keywords: &["hideg", "jéghegy", "jégkocka"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սառույցի խորանարդիկ"),
            keywords: &["սառը", "սառույցի խորանարդիկ", "սառցաբեկոր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("es batu"),
            keywords: &["dingin", "es batu", "gunung es"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ísmoli"),
            keywords: &["kuldi", "ísjaki", "ísmoli"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cubetto di ghiaccio"),
            keywords: &[
                "cubetto di ghiaccio",
                "ghiaccio in cubetti",
                "ghiaccio in cubi",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("角氷"),
            keywords: &["冷たい", "氷", "角氷"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("es batu"),
            keywords: &["adhem", "es", "es batu"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ყინულის კუბი"),
            keywords: &["აისბერგი", "სიცივე", "ყინულის კუბი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("мұз текшесі"),
            keywords: &["айсберг", "мұз текшесі", "суық"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ដ\u{17bb}\u{17c6}ទ\u{17b9}កកក"),
            keywords: &[
                "កាត\u{17b7}បទ\u{17b9}កកក",
                "ដ\u{17bb}\u{17c6}ទ\u{17b9}កកក",
                "ត\u{17d2}រជាក\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಐಸ\u{ccd} ಕ\u{ccd}ಯ\u{cc2}ಬ\u{ccd}"),
            keywords: &[
                "ಐಸ\u{ccd}",
                "ಐಸ\u{ccd} ಕ\u{ccd}ಯ\u{cc2}ಬ\u{ccd}",
                "ಮಂಜುಗಡ\u{ccd}ಡ\u{cc6}",
                "ಶೀತ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("얼음"),
            keywords: &["각얼음", "얼음", "차가운"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बर\u{94d}फ"),
            keywords: &[
                "थ\u{902}ड",
                "बर\u{94d}फ",
                "बर\u{94d}फाचो क\u{94d}य\u{941}ब",
                "बर\u{94d}फाचोक\u{941}डको",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("муз куб"),
            keywords: &["айсберг", "муз куб", "муздак"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ນ\u{ec9}ຳ\u{200b}ກ\u{ec9}ອນ"),
            keywords: &["ນ\u{ec9}ຳ\u{200b}ກ\u{ec9}ອນ", "ເຢ\u{eb1}ນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("ledo kubelis"),
            keywords: &["ledas", "ledo kubelis", "šaltas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ledus gabaliņš"),
            keywords: &["aisbergs", "auksts", "ledus gabaliņš"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("коцка мраз"),
            keywords: &["коцка мраз", "ладно", "лед", "мраз"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഐസ\u{d4d} ക\u{d4d}യ\u{d42}ബ\u{d4d}"),
            keywords: &[
                "ഐസ\u{d4d} ക\u{d4d}യ\u{d42}ബ\u{d4d}",
                "തണ\u{d41}ത\u{d4d}തത\u{d4d}",
                "മഞ\u{d4d}ഞ\u{d41}മല",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("мөс"),
            keywords: &["мөс", "мөсөн уул", "хүйтэн"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("आईस क\u{94d}य\u{941}ब"),
            keywords: &["आईस क\u{94d}य\u{941}ब", "थ\u{902}ड", "हिमनग"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kiub ais"),
            keywords: &["ais", "aisberg", "kiub ais", "sejuk"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ရေခ\u{1032}တ\u{102f}\u{1036}း"),
            keywords: &["ရေခ\u{1032}", "ရေခ\u{1032}တ\u{102f}\u{1036}း", "အအေး"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("isterning"),
            keywords: &["isbit", "isterning", "kald"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("आइस क\u{94d}य\u{941}ब"),
            keywords: &["आइस क\u{94d}य\u{941}ब", "चिसो", "हिउ\u{901}को पहाड"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("ijsklontje"),
            keywords: &["ijsberg", "ijsklontje", "koud"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("isterning"),
            keywords: &["isbit", "isterning", "kald"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବରଫ ଟ\u{b41}କ\u{b41}ଡ\u{b3c}\u{b3e}"),
            keywords: &[
                "ଥଣ\u{b4d}ଡ\u{b3e}",
                "ବରଫ ଟ\u{b41}କ\u{b41}ଡ\u{b3c}\u{b3e}",
                "ବରଫଖଣ\u{b4d}ଡ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬਰਫ\u{a3c} ਦਾ ਟ\u{a41}ਕੜਾ"),
            keywords: &["ਆਈਸਬਰਗ", "ਠ\u{a70}ਡਾ", "ਬਰਫ\u{a3c} ਦਾ ਟ\u{a41}ਕੜਾ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ais"),
            keywords: &[
                "Ais",
                "Aís Blọk",
                "Bíg Aís Blọk Wé De Flót Ínsaíd Bíg-Díp-Wọtá",
                "Kold",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kostka lodu"),
            keywords: &["kostka lodu", "lód", "zimny"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کنګل"),
            keywords: &["د کنګل مکعب", "د کنګل يوه لويه ټکړه", "سوړ", "کنګل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cubo de gelo"),
            keywords: &["cubo de gelo", "gelado", "iceberg"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("gelo"),
            keywords: &["cubo de gelo", "frio", "gelo", "icebergue"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("chiri"),
            keywords: &["chhullunka", "chiri", "chiri tawakʼuchu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cub de gheață"),
            keywords: &["aisberg", "cub de gheață", "gheață", "rece"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–049"),
            keywords: &["E12–049"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("кубик льда"),
            keywords: &["кубик", "кубик льда", "лед", "ледяной", "холод", "холодный"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("آئيس ڪيوب"),
            keywords: &["آئيس ڪيوب", "آئيسبرگ", "ٿڌو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අය\u{dd2}ස\u{dca} කැටය"),
            keywords: &[
                "අය\u{dd2}ස\u{dca} කැටය",
                "ස\u{dd3}ත",
                "හ\u{dd2}ම ක\u{dd4}ට\u{dca}ට\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kocka ľadu"),
            keywords: &[
                "chlad",
                "kocka ľadu",
                "studený",
                "ľad",
                "ľadovec",
                "ľadová kocka",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ledena kocka"),
            keywords: &["hladno", "ledena kocka", "ledeno", "ohladitev"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("baraf"),
            keywords: &["baraf", "jabal baraf ah", "qaboow"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kub akulli"),
            keywords: &["ajsberg", "akull", "ftohtë", "kub akulli"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("коцка леда"),
            keywords: &["коцка леда", "ледени брег", "хладно"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["коцка леда"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kocka leda"),
            keywords: &["hladno", "kocka leda", "ledeni breg"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["kocka leda"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("isbit"),
            keywords: &["isberg", "isbit", "kallt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kidonge cha barafu"),
            keywords: &["barafu", "baridi", "kidonge cha barafu", "siwa barafu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஐஸ\u{bcd} கட\u{bcd}டி"),
            keywords: &["ஐஸ\u{bcd}", "ஐஸ\u{bcd} கட\u{bcd}டி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఐస\u{c4d} క\u{c4d}యూబ\u{c4d}"),
            keywords: &[
                "ఐస\u{c4d} క\u{c4d}యూబ\u{c4d}",
                "ఐస\u{c4d}\u{200c}బర\u{c4d}గ\u{c4d}",
                "చల\u{c4d}లన\u{c3f}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ก\u{e49}อนน\u{e49}ำแข\u{e47}ง"),
            keywords: &[
                "ก\u{e49}อนน\u{e49}ำแข\u{e47}ง",
                "ภ\u{e39}เขาน\u{e49}ำแข\u{e47}ง",
                "หนาว",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("buz kuby"),
            keywords: &["aýsberg", "buz kuby", "sowuk"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("puloka ʻaisi"),
            keywords: &["puloka ʻaisi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("buz küpü"),
            keywords: &["aysberg", "buz küpü", "soğuk"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кубик льоду"),
            keywords: &[
                "айсберг",
                "кубик",
                "кубик льоду",
                "охолоджувати",
                "холод",
                "холодний",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("برف کا ٹکڑا"),
            keywords: &["برف کا ٹکڑا", "ٹھنڈا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("muz"),
            keywords: &["aysberg", "muz", "sovuq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("viên đá"),
            keywords: &["băng", "lạnh", "viên đá", "đá"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("冰塊"),
            keywords: &["冰", "冰塊"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("冰块"),
            keywords: &["冰", "冰块"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("冰块"),
            keywords: &["冰块", "冰山", "冷却", "冷饮"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("冰塊"),
            keywords: &["冰塊", "冰山", "冷"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("冰粒"),
            keywords: &["冰山", "冰粒", "冷"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukubanda"),
            keywords: &["i-iceberg", "ukubanda"],
        },
    ],
};
