#[doc = "🥢"]
pub const CHOPSTICKS: crate::Emoji = crate::Emoji {
    glyph: "🥢",
    codepoint: "1F962",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "chopsticks",
    group: "Food & Drink",
    subgroup: "dishware",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("eetstokkies"),
            keywords: &["eetstokkies"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቾፕስቲክ"),
            keywords: &["ቾፕስቲክ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("عيدان للأكل"),
            keywords: &["عيدان للأكل"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চপষ\u{9cd}টিক"),
            keywords: &["চপষ\u{9cd}টিক", "হেচি"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yemək çubuqları"),
            keywords: &["haşi", "yemək çubuqları"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("палачкі"),
            keywords: &["палачкі", "хашы"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("пръчици за хранене"),
            keywords: &["пръчици за хранене", "хаши"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চপস\u{9cd}টিক"),
            keywords: &["চপস\u{9cd}টিক", "হ\u{9be}শি"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bizhier"),
            keywords: &["bizhier"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("štapići"),
            keywords: &["haši", "štapići"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bastonets xinesos"),
            keywords: &["bastonet", "bastonets xinesos", "oriental", "xinès"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᎷᏍᏗᎦᏅᏍᏗ"),
            keywords: &["ᎦᎷᏍᏗᎦᏅᏍᏗ", "ᎮᏏ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("jídelní hůlky"),
            keywords: &["hashi", "haši", "hůlky", "jídelní", "tyčinky"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("gweill bwyta"),
            keywords: &["gweill bwyta"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("spisepinde"),
            keywords: &["asiatisk", "spisepinde"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Essstäbchen"),
            keywords: &["Essstäbchen", "Hashi", "Stäbchen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ξυλάκια"),
            keywords: &["ξυλάκια", "χάσι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("chopsticks"),
            keywords: &["chopsticks", "hashi"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["chopsticks", "pair of chopsticks"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("palillos"),
            keywords: &["cubiertos", "hashi", "palillos"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("palillos chinos"),
            keywords: &["hashi", "palillos chinos"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("söögipulgad"),
            keywords: &["hashi", "söögipulgad"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("zotzak"),
            keywords: &["hashi", "zotzak"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("چاپ\u{200c}استیک"),
            keywords: &["هاشی", "چاپ\u{200c}استیک", "چوب\u{200c}های غذا"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("syömäpuikot"),
            keywords: &["aterimet", "ruokailu", "syömäpuikot"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("chopsticks"),
            keywords: &["chopsticks", "hashi"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("etingarpinnar"),
            keywords: &["etingarpinnar", "pinnar"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("baguettes"),
            keywords: &["baguettes", "hashi"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cipíní itheacháin"),
            keywords: &["Seapáinis", "cipín itheacháin", "cipíní itheacháin"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bioran-ithe"),
            keywords: &["bioran-ithe", "hashi"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("paíños chineses"),
            keywords: &["chinesa", "comida", "paíños", "paíños chineses"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચૉપ\u{acd}સ\u{acd}ટિક\u{acd}સ"),
            keywords: &["ચૉપ\u{acd}સ\u{acd}ટિક\u{acd}સ", "હાશી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("sandunan cin abinci"),
            keywords: &["hashi", "sandunan cin abinci"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מקלות אכילה"),
            keywords: &["מקלות", "מקלות אכילה", "סיני", "צ׳ופסטיק"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चॉपस\u{94d}टिक"),
            keywords: &["चॉपस\u{94d}टिक", "हाशी"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("štapići"),
            keywords: &["kineski štapići", "štapići"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("evőpálcikák"),
            keywords: &["evőpálcikák", "hashi"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("փայտիկներ"),
            keywords: &["հասի", "փայտիկներ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("sumpit"),
            keywords: &["hashi", "sumpit"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("osisi nri"),
            keywords: &["hashi", "osisi nri"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("matprjónar"),
            keywords: &["matprjónar"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("bacchette"),
            keywords: &["bacchette"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("はし"),
            keywords: &["おはし", "はし"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sumpit"),
            keywords: &["hashi", "sumpit"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჩხირები"),
            keywords: &["საჭმელი ჩხირები", "ჩინური ჩხირები", "ჩხირები"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тамақ таяқшалары"),
            keywords: &["тамақ таяқшалары"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ចង\u{17d2}ក\u{17b9}ះ"),
            keywords: &[
                "ចង\u{17d2}ក\u{17b9}ះ",
                "ចង\u{17d2}ក\u{17b9}ះជប\u{17c9}\u{17bb}ន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಚೋಪ\u{ccd}\u{200c}ಸ\u{ccd}ಟ\u{cbf}ಕ\u{ccd}ಸ\u{ccd}"),
            keywords: &[
                "ಚೋಪ\u{ccd}\u{200c}ಸ\u{ccd}ಟ\u{cbf}ಕ\u{ccd}ಸ\u{ccd}",
                "ಹಶ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("젓가락"),
            keywords: &["젓가락"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("चॉपस\u{94d}टिक\u{94d}स"),
            keywords: &["चॉपस\u{94d}टिक\u{94d}स", "हाशी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тамак таякчалары"),
            keywords: &["тамак таякчалары", "хаши"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("asiatesch Béngelen"),
            keywords: &["Hashi", "asiatesch Béngelen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໄມ\u{ec9}ທ\u{eb9}\u{ec8}"),
            keywords: &[
                "ໄມ\u{ec9}ທ\u{eb9}\u{ec8}",
                "ໄມ\u{ec9}ທ\u{eb9}\u{ec8}ຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("lazdelės"),
            keywords: &["haši", "lazdelės"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("irbulīši"),
            keywords: &["haši", "irbulīši"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rākaukai"),
            keywords: &["hashi", "rākaukai"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("стапчиња за јадење"),
            keywords: &["стапчиња за јадење", "хаши"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ചോപ\u{d4d}പ\u{d4d}\u{200c}സ\u{d4d}\u{200c}റ\u{d4d}റിക\u{d4d}\u{200c}സ\u{d4d}",
            ),
            keywords: &[
                "ചൈനീസ\u{d4d}",
                "ചോപ\u{d4d}പ\u{d4d}\u{200c}സ\u{d4d}\u{200c}റ\u{d4d}റിക\u{d4d}\u{200c}സ\u{d4d}",
                "ന\u{d4d}യ\u{d42}ഡിൽസ\u{d4d}",
                "ഹ\u{d3e}ഷി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("савх"),
            keywords: &["савх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चॉपस\u{94d}टिक"),
            keywords: &["चॉपस\u{94d}टिक", "हाशी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("penyepit"),
            keywords: &["hashi", "penyepit"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("chopsticks"),
            keywords: &["chopsticks", "hashi"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စားတ\u{1030}"),
            keywords: &["စားတ\u{1030}", "ဟာရ\u{103e}\u{102e} (စားတ\u{1030})"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("spisepinner"),
            keywords: &["hashi", "spisepinner"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("चपस\u{94d}टिक"),
            keywords: &["चपस\u{94d}टिक", "ह\u{94d}यासी"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("chopsticks"),
            keywords: &["chopsticks", "eetstokjes"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("spisepinnar"),
            keywords: &["hashi", "spisepinnar"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଚପଷ\u{b4d}ଟ\u{b3f}କ\u{b4d}\u{200d}"),
            keywords: &["ଚପଷ\u{b4d}ଟ\u{b3f}କ\u{b4d}\u{200d}", "ହ\u{b3e}ଶ\u{b3f}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚ\u{a4c}ਪਸਟਿ\u{a71}ਕ"),
            keywords: &["ਚ\u{a4c}ਪਸਟਿ\u{a71}ਕ", "ਹਾਸ\u{a3c}ੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چاپ سٹکس"),
            keywords: &["چاپ سٹکس", "ہیشی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Chọpstik-dẹm"),
            keywords: &["Chọpstik-dẹm", "Háshi"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pałeczki"),
            keywords: &["pałeczki"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("چوپسټيکس"),
            keywords: &["چوپسټيکس", "چوپسټيکس، هاشي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("hashi"),
            keywords: &["hashi", "pauzinhos"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("pauzinhos"),
            keywords: &["hashi", "pauzinhos"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("palillos"),
            keywords: &["hashi", "palillos"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bețișoare japoneze"),
            keywords: &["bețișoare de mâncat", "bețișoare japoneze"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1086"),
            keywords: &["E10-1086"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("палочки для еды"),
            keywords: &["палочки", "палочки для еды", "приборы", "столовые"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("uduti barisha"),
            keywords: &["hashi", "uduti barisha"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("کاڌو کائڻ جون ڪاٺيون"),
            keywords: &["هاشي", "کاڌو کائڻ جون ڪاٺيون"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("චොප\u{dca}ස\u{dca}ට\u{dd2}ක\u{dca}ස\u{dca}"),
            keywords: &["චොප\u{dca}ස\u{dca}ට\u{dd2}ක\u{dca}ස\u{dca}", "හැෂ\u{dd2}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("paličky"),
            keywords: &["jedlo", "paličky"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("jedilne paličice"),
            keywords: &["jedilne paličice"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qori wax lagu cuno"),
            keywords: &["qori wax lagu cuno"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shkopinj (për të ngrënë)"),
            keywords: &["gatim", "ngrënie", "shkopinj", "shkopinj (për të ngrënë)"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("штапићи"),
            keywords: &["хаши штапићи", "штапићи"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("štapići"),
            keywords: &["haši štapići", "štapići"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ätpinnar"),
            keywords: &["ätpinnar"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("vijiti vya kutumia kula"),
            keywords: &["hashi", "vijiti vya kutumia kula"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ச\u{bbe}ப\u{bcd}ஸ\u{bcd}டிக\u{bcd}"),
            keywords: &[
                "ச\u{bbe}ப\u{bcd}ஸ\u{bcd}டிக\u{bcd}",
                "ச\u{bc0}ன உணவு",
                "ஜப\u{bcd}ப\u{bbe}னிய உணவு",
                "ஹஷி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c3e}ప\u{c4d}\u{200c}స\u{c4d}ట\u{c3f}క\u{c4d}\u{200c}లు"),
            keywords: &[
                "చ\u{c3e}ప\u{c4d}\u{200c}స\u{c4d}ట\u{c3f}క\u{c4d}\u{200c}లు",
                "హ\u{c3e}ష\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("чӯбҳои хӯрокхӯрӣ"),
            keywords: &["чӯбҳои хӯрокхӯрӣ", "ҳаши"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ตะเก\u{e35}ยบ"),
            keywords: &["ตะเก\u{e35}ยบ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çöp"),
            keywords: &["haşi", "çöp"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("vaʻakau kai"),
            keywords: &["vaʻakau kai"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yemek çubukları"),
            keywords: &["chopsticks", "yemek çubukları"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چوكا"),
            keywords: &["چوكا", "ھاشى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("палички для їжі"),
            keywords: &["палички для їжі", "хаші"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چینی کانٹا"),
            keywords: &["چینی کانٹا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tayoqcha"),
            keywords: &["asboblar", "tayoqcha", "xascho‘p"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đũa"),
            keywords: &["đũa", "đũa Nhật"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("baget"),
            keywords: &["baget", "hashi"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-chopsticks"),
            keywords: &["i-chopsticks", "i-hashi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ìlàrí"),
            keywords: &["áṣì", "ìlàrí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("筷子"),
            keywords: &["hashi", "筷子"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("筷子"),
            keywords: &["hashi", "筷子"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("筷子"),
            keywords: &["筷子", "箸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("筷子"),
            keywords: &["筷子"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("izinti"),
            keywords: &["ihashi", "izinti"],
        },
    ],
};
#[doc = "🍽\u{fe0f}"]
pub const FORK_AND_KNIFE_WITH_PLATE: crate::Emoji = crate::Emoji {
    glyph: "🍽\u{fe0f}",
    codepoint: "1F37D FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "fork and knife with plate",
    group: "Food & Drink",
    subgroup: "dishware",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🍽",
        codepoint: "1F37D",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "fork and knife with plate",
        group: "Food & Drink",
        subgroup: "dishware",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("bord met mes en vurk"),
            keywords: &[
                "bord",
                "bord met mes en vurk",
                "eet",
                "kook",
                "kos",
                "mes",
                "vurk",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ማንኪያ እና ሹካ ከሳሕን ጋር"),
            keywords: &["ማንኪያ እና ሹካ ከሳሕን ጋር", "ምግብ ማብሰል", "ሳሕን", "ሹካ", "ቢላዋ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("طبق وشوكة وسكينة"),
            keywords: &["سكين", "شوكة", "طبق", "طبق وشوكة وسكينة", "طهي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9cd}লেটৰ সৈতে ক\u{9be}ট\u{9be} চ\u{9be}মোচ আৰ\u{9c1} কট\u{9be}ৰী"),
            keywords: &[
                "কট\u{9be}ৰী",
                "ক\u{9be}ট\u{9be} চ\u{9be}মোচ",
                "প\u{9cd}লেট",
                "প\u{9cd}লেটৰ সৈতে ক\u{9be}ট\u{9be} চ\u{9be}মোচ আৰ\u{9c1} কট\u{9be}ৰী",
                "ৰন\u{9cd}ধন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("çəngəl və bıçaq ilə boşqab"),
            keywords: &[
                "bişirmək",
                "boşqab",
                "bıçaq",
                "çəngəl",
                "çəngəl və bıçaq ilə boşqab",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("талерка, відэлец і нож"),
            keywords: &[
                "відэлец",
                "гатаванне",
                "нож",
                "талерка",
                "талерка, відэлец і нож",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Нож и вилица с чиния"),
            keywords: &["Нож и вилица с чиния", "вилица", "готвене", "нож", "чиния"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9cd}লেটের সঙ\u{9cd}গে ক\u{9be}\u{981}ট\u{9be}চ\u{9be}মচ ও ছ\u{9c1}রি"),
            keywords: &[
                "ক\u{9be}\u{981}ট\u{9be}চ\u{9be}মচ",
                "ছ\u{9c1}রি",
                "প\u{9cd}লেট",
                "প\u{9cd}লেটের সঙ\u{9cd}গে ক\u{9be}\u{981}ট\u{9be}চ\u{9be}মচ ও ছ\u{9c1}রি",
                "রন\u{9cd}ধন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kontell ha fourchetez gant asied"),
            keywords: &[
                "asied",
                "fourchetez",
                "kontell",
                "kontell ha fourchetez gant asied",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("viljuška i nož uz tanjir"),
            keywords: &[
                "kuhanje",
                "nož",
                "tanjir",
                "viljuška",
                "viljuška i nož uz tanjir",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("forquilla, ganivet i plat"),
            keywords: &["forquilla", "forquilla, ganivet i plat", "ganivet", "plat"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏴᎩ ᎠᎴ ᎠᏰᎳᏍᏗ ᏖᎵᏙᏃ"),
            keywords: &["ᎠᏓᏍᏓᏴᎲᏍᎩ", "ᎠᏖᎵᏙ", "ᎠᏰᎳᏍᏗ", "ᏴᎩ", "ᏴᎩ ᎠᎴ ᎠᏰᎳᏍᏗ ᏖᎵᏙᏃ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("talíř s vidličkou a nožem"),
            keywords: &[
                "nádobí",
                "nůž",
                "příbor",
                "talíř",
                "talíř s vidličkou a nožem",
                "vaření",
                "vidlička",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("fforc a chyllell gyda phlât"),
            keywords: &[
                "coginio",
                "cyllell",
                "fforc",
                "fforc a chyllell gyda phlât",
                "plât",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kniv og gaffel med tallerken"),
            keywords: &[
                "gaffel",
                "kniv",
                "kniv og gaffel med tallerken",
                "madlavning",
                "tallerken",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Teller mit Messer und Gabel"),
            keywords: &["Gabel", "Messer", "Teller mit Messer und Gabel", "kochen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μαχαιροπίρουνα με πιάτο"),
            keywords: &[
                "μαγείρεμα",
                "μαχαίρι",
                "μαχαιροπίρουνα με πιάτο",
                "πιάτο",
                "πιρούνι",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("fork and knife with plate"),
            keywords: &[
                "cooking",
                "fork",
                "fork and knife with plate",
                "knife",
                "plate",
            ],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("knife and fork with plate"),
            keywords: &[
                "cooking",
                "fork",
                "knife",
                "knife and fork with plate",
                "plate",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cuchillo y tenedor con un plato"),
            keywords: &[
                "cuchillo",
                "cuchillo y tenedor con un plato",
                "plato",
                "restaurante",
                "tenedor",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("plato y cubiertos"),
            keywords: &[
                "cubiertos",
                "cuchillo",
                "plato",
                "plato y cubiertos",
                "restaurante",
                "tenedor",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "cubiertos",
                "cuchillo",
                "plato",
                "plato y cubiertos",
                "restaurante",
                "tenedor",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("tenedor, cuchillo y plato"),
            keywords: &[
                "cocinando",
                "cuchillo",
                "plato",
                "tenedor",
                "tenedor, cuchillo y plato",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kahvel, nuga ja taldrik"),
            keywords: &[
                "kahvel",
                "kahvel, nuga ja taldrik",
                "nuga",
                "taldrik",
                "toit",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("platera, sardeska eta labanarekin"),
            keywords: &[
                "janari",
                "labana",
                "plater",
                "platera, sardeska eta labanarekin",
                "sardeska",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بشقاب و کارد و چنگال"),
            keywords: &["آشپزی", "بشقاب", "بشقاب و کارد و چنگال", "چنگال", "کارد"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("haarukka, veitsi ja lautanen"),
            keywords: &[
                "aterimet",
                "haarukka",
                "haarukka, veitsi ja lautanen",
                "lautanen",
                "ruokailu",
                "veitsi",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tinidor, kutsilyo at pinggan"),
            keywords: &[
                "hapag-kainan",
                "kutsilyo",
                "pinggan",
                "tinidor",
                "tinidor at kutsilyo na may pinggan",
                "tinidor, kutsilyo at pinggan",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("gaffil knívur og talerkur"),
            keywords: &[
                "borðbúnaður",
                "borðiskur",
                "gaffil",
                "gaffil knívur og talerkur",
                "knívur",
                "talerkur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("fourchette et couteau avec assiette"),
            keywords: &[
                "assiette",
                "assiette et couverts",
                "couteau",
                "cuisine",
                "fourchette",
                "fourchette et couteau avec assiette",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "assiette",
                "couteau",
                "couverts",
                "fourchette",
                "fourchette et couteau avec assiette",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("forc agus scian le pláta"),
            keywords: &[
                "ag cócaireacht",
                "forc",
                "forc agus scian le pláta",
                "pláta",
                "scian",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("forc is sgian le truinnsear"),
            keywords: &[
                "còcaireachd",
                "forc",
                "forc is sgian le truinnsear",
                "sgian",
                "truinnsear",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("prato e cubertos"),
            keywords: &["coitelo", "cubertos", "garfo", "prato", "prato e cubertos"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{acd}લ\u{ac7}ટ સાથ\u{ac7} છરી અન\u{ac7} કા\u{a82}ટો"),
            keywords: &[
                "કા\u{a82}ટો",
                "છરી",
                "થાળી",
                "પ\u{acd}લ\u{ac7}ટ",
                "પ\u{acd}લ\u{ac7}ટ સાથ\u{ac7} છરી અન\u{ac7} કા\u{a82}ટો",
                "રસોઈ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("cokali mai yatsu da wuƙa tare da faranti"),
            keywords: &[
                "cokali mai yatsu",
                "cokali mai yatsu da wuƙa tare da faranti",
                "dafuwa",
                "faranti",
                "wuƙa",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סכין ומזלג עם צלחת"),
            keywords: &["אוכל", "מזלג", "סכין", "סכין ומזלג עם צלחת", "צלחת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{94d}ल\u{947}ट क\u{947} साथ का\u{901}टा और छ\u{941}री"),
            keywords: &[
                "का\u{901}टा",
                "खाना बनाना",
                "चाक\u{942}",
                "प\u{94d}ल\u{947}ट",
                "प\u{94d}ल\u{947}ट क\u{947} साथ का\u{901}टा और छ\u{941}री",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("vilica i nož s tanjurom"),
            keywords: &[
                "kuhanje",
                "nož",
                "tanjur",
                "vilica",
                "vilica i nož s tanjurom",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kés és villa tányérral"),
            keywords: &[
                "kés",
                "kés és villa tányérral",
                "tálalás",
                "tányér",
                "villa",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("դանակ և պատառաքաղ ափսեի հետ"),
            keywords: &[
                "ափսե",
                "դանակ",
                "դանակ և պատառաքաղ ափսեի հետ",
                "խոհարարություն",
                "պատառաքաղ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("garpu dan pisau dengan piring"),
            keywords: &[
                "garpu",
                "garpu dan pisau dengan piring",
                "masak",
                "piring",
                "pisau",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ngaji ndụdụ na mma nwere efere"),
            keywords: &[
                "efere",
                "mmà",
                "na-esi nri",
                "ngaji ndụdụ",
                "ngaji ndụdụ na mma nwere efere",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("gaffall og hnífur við disk"),
            keywords: &[
                "diskur",
                "eldamennska",
                "gaffall",
                "gaffall og hnífur við disk",
                "hnífur",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("piatto e posate"),
            keywords: &[
                "apparecchiare",
                "coltello",
                "forchetta",
                "piatto e posate",
                "posate",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ナイフとフォークと皿"),
            keywords: &["お皿", "ナイフ", "ナイフとフォークと皿", "フォーク", "皿"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sendhok garpu sapiringe"),
            keywords: &[
                "garpu",
                "masak",
                "peso",
                "piring",
                "sendhok garpu sapiringe",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჩანგალი და დანა თეფშთან ერთად"),
            keywords: &[
                "დანა",
                "თეფში",
                "საჭმლის მომზადება",
                "ჩანგალი",
                "ჩანგალი და დანა თეფშთან ერთად",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тәрелке, шанышқы және пышақ"),
            keywords: &[
                "пышақ",
                "пісіру",
                "тәрелке",
                "тәрелке, шанышқы және пышақ",
                "шанышқы",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kniv og gaffel med tallerken"),
            keywords: &[
                "gaffel",
                "kniv",
                "kniv og gaffel med tallerken",
                "madlavning",
                "tallerken",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សមន\u{17b7}ងកា\u{17c6}ប\u{17b7}តនៅសងខាងចានបាយ"),
            keywords: &[
                "ចានកា\u{17c6}ប\u{17b7}ទ",
                "សមន\u{17b7}ងកា\u{17c6}ប\u{17b7}តនៅសងខាងចានបាយ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some(
                "ಪ\u{ccd}ಲೇಟ\u{ccd}\u{200c}ನಲ\u{ccd}ಲ\u{cbf} ಫೋರ\u{ccd}ಕ\u{ccd} ಮತ\u{ccd}ತು ಚಾಕು",
            ),
            keywords: &[
                "ಅಡ\u{cbf}ಗ\u{cc6}",
                "ಊಟ",
                "ಪ\u{ccd}ಲೇಟ\u{ccd}\u{200c}ನಲ\u{ccd}ಲ\u{cbf} ಫೋರ\u{ccd}ಕ\u{ccd} ಮತ\u{ccd}ತು ಚಾಕು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("포크와 나이프가 있는 접시"),
            keywords: &["나이프", "접시", "포크", "포크와 나이프가 있는 접시"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बश\u{94d}श\u{947} सयत काटो आनी स\u{941}री"),
            keywords: &[
                "काटो",
                "बशी",
                "बश\u{94d}श\u{947} सयत काटो आनी स\u{941}री",
                "रा\u{902}दप",
                "स\u{941}री",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("вилка, бычак жана табак"),
            keywords: &["бычак", "вилка", "вилка, бычак жана табак", "табак"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Forschett a Messer mat Teller"),
            keywords: &[
                "Forschett",
                "Forschett a Messer mat Teller",
                "Messer",
                "Teller",
                "kachend",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{ec9}ອມ ແລະ ມ\u{eb5}ດ ກ\u{eb1}ບຈານ"),
            keywords: &[
                "ຈານ",
                "ມ\u{eb5}ດ",
                "ສ\u{ec9}ອມ",
                "ສ\u{ec9}ອມ ແລະ ມ\u{eb5}ດ ກ\u{eb1}ບຈານ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("šakutė ir peilis su lėkšte"),
            keywords: &[
                "lėkštė",
                "maisto gaminimas",
                "peilis",
                "šakutė",
                "šakutė ir peilis su lėkšte",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("nazis un dakša ar šķīvi"),
            keywords: &["dakša", "nazis", "nazis un dakša ar šķīvi", "šķīvis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("paoka me naihi me pereti"),
            keywords: &[
                "naihi",
                "paoka",
                "paoka me naihi me pereti",
                "pereti",
                "tao ana",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("виљушка и нож со чинија"),
            keywords: &[
                "виљушка",
                "виљушка и нож со чинија",
                "готвење",
                "нож",
                "чинија",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "കത\u{d4d}തിയ\u{d41}ം മ\u{d41}ള\u{d4d}ള\u{d41}മ\u{d41}ള\u{d4d}ള പ\u{d4d}ലേറ\u{d4d}റ\u{d4d}",
            ),
            keywords: &[
                "കത\u{d4d}തി",
                "കത\u{d4d}തിയ\u{d41}ം മ\u{d41}ള\u{d4d}ള\u{d41}മ\u{d41}ള\u{d4d}ള പ\u{d4d}ലേറ\u{d4d}റ\u{d4d}",
                "ഡൈനിംഗ\u{d4d} ടേബിൾ",
                "പ\u{d4d}ര\u{d3e}ചകം",
                "പ\u{d4d}ലേറ\u{d4d}റ\u{d4d}",
                "ഫോർക\u{d4d}ക\u{d4d}",
                "മ\u{d41}ള\u{d4d}ള\u{d4d}",
                "ഹോട\u{d4d}ടൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("таваг, хутга сэрээ"),
            keywords: &["сэрээ", "таваг", "таваг, хутга сэрээ", "хоол", "хутга"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ताटलीसह काटा आणि स\u{941}री"),
            keywords: &[
                "अन\u{94d}न शिजवण\u{947}",
                "काटा",
                "ताटली",
                "ताटलीसह काटा आणि स\u{941}री",
                "स\u{941}री",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("garpu dan pisau dengan pinggan"),
            keywords: &[
                "garpu",
                "garpu dan pisau dengan pinggan",
                "memasak",
                "pinggan",
                "pisau",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("furketta u sikkina ma’ platt"),
            keywords: &[
                "furketta",
                "furketta u sikkina ma’ platt",
                "platt",
                "sikkina",
                "tisjir",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ဇ\u{103d}န\u{103a}း ခက\u{103a}ရင\u{103a}းန\u{103e}င\u{1037}\u{103a} ပန\u{103a}းကန\u{103a}",
            ),
            keywords: &[
                "ခက\u{103a}ရင\u{103a}း",
                "ခက\u{103a}ရင\u{103a}း ဓားန\u{103e}င\u{1037}\u{103a} ပန\u{103a}းကန\u{103a}",
                "ချက\u{103a}ပြ\u{102f}တ\u{103a}ခြင\u{103a}း",
                "ဇ\u{103d}န\u{103a}း ခက\u{103a}ရင\u{103a}းန\u{103e}င\u{1037}\u{103a} ပန\u{103a}းကန\u{103a}",
                "ဓား",
                "ပန\u{103a}းကန\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("tallerken med kniv og gaffel"),
            keywords: &[
                "gaffel",
                "kniv",
                "matlaging",
                "tallerken",
                "tallerken med kniv og gaffel",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("थालस\u{901}ग चक\u{94d}क\u{941} र का\u{901}टा"),
            keywords: &[
                "का\u{901}टा",
                "खाना बनाउन\u{947}",
                "चक\u{94d}क\u{941}",
                "थालस\u{901}ग चक\u{94d}क\u{941} र का\u{901}टा",
                "प\u{94d}ल\u{947}ट",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("mes en vork met bord"),
            keywords: &["bord", "koken", "mes", "mes en vork met bord", "vork"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("tallerken med kniv og gaffel"),
            keywords: &[
                "gaffel",
                "kniv",
                "matlaging",
                "tallerken",
                "tallerken med kniv og gaffel",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ପ\u{b4d}ଲେଟ\u{b4d}\u{200d} ସହ\u{b3f}ତ କଣ\u{b4d}ଟ\u{b3e} ଚ\u{b3e}ମଚ ଓ ଛ\u{b41}ରୀ",
            ),
            keywords: &[
                "ପ\u{b4d}ଲେଟ\u{b4d}\u{200d} ସହ\u{b3f}ତ କଣ\u{b4d}ଟ\u{b3e} ଚ\u{b3e}ମଚ ଓ ଛ\u{b41}ରୀ",
                "ରୋଷେଇ । କଣ\u{b4d}ଟ\u{b3e} ଚ\u{b3e}ମଚ । ଛ\u{b41}ରୀ । ପ\u{b4d}ଲେଟ\u{b4d}\u{200d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪਲ\u{a47}ਟ ਨਾਲ ਕਾ\u{a02}ਟਾ ਅਤ\u{a47} ਛ\u{a41}ਰੀ"),
            keywords: &[
                "ਕਾ\u{a02}ਟਾ",
                "ਖਾਣਾ",
                "ਖਾਣਾ ਬਣਾਉਣਾ",
                "ਚਾਕ\u{a42}",
                "ਛ\u{a41}ਰੀ",
                "ਪਲ\u{a47}ਟ",
                "ਪਲ\u{a47}ਟ ਨਾਲ ਕਾ\u{a02}ਟਾ ਅਤ\u{a47} ਛ\u{a41}ਰੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چھری اتے کانٹے نال تھالی"),
            keywords: &[
                "تھالی",
                "چھری",
                "چھری اتے کانٹے نال تھالی",
                "کانٹا",
                "کھانا-پکانا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fọk An Naif Wit Plet"),
            keywords: &["Fọk", "Fọk An Naif Wit Plet", "Kuk", "Naif", "Plet"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("talerz z nożem i widelcem"),
            keywords: &[
                "naczynia",
                "nóż",
                "sztućce",
                "talerz",
                "talerz z nożem i widelcem",
                "widelec",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښاخۍ او چاقو د پليټ سره"),
            keywords: &[
                "پخلی، ښاخۍ، ښاخۍ او چاقو د پليټ سره، چاقو، پليټ",
                "ښاخۍ او چاقو د پليټ سره",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("prato com talheres"),
            keywords: &[
                "prato com garfo e faca",
                "prato com talheres",
                "prato com talheres ao lado",
                "restaurante",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("faca e garfo com prato"),
            keywords: &[
                "cozinhar",
                "faca",
                "faca e garfo com prato",
                "garfo",
                "prato",
                "talheres",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tenedor chaymanta khuchuna platowan"),
            keywords: &[
                "khuchuna",
                "plato",
                "tenedor",
                "tenedor chaymanta khuchuna platowan",
                "waykʼuchkan",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("furculiță și cuțit cu farfurie"),
            keywords: &[
                "cuțit",
                "farfurie",
                "furculiță și cuțit cu farfurie",
                "gătit",
                "tacâmuri",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-322"),
            keywords: &["E10-322"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("тарелка с приборами"),
            keywords: &[
                "вилка",
                "нож",
                "прибор",
                "приборы",
                "стол",
                "столовые",
                "тарелка с приборами",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikanya n’icyuma hamwe n’iparato"),
            keywords: &[
                "guteka",
                "icyuma",
                "ikanya",
                "ikanya n’icyuma hamwe n’iparato",
                "iparato",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پليٽ سان ڇري ۽ ڪانٽو"),
            keywords: &["پليٽ سان ڇري ۽ ڪانٽو", "پچائڻ، ڪانٽو، ڇري، پليٽ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some(
                "ප\u{dd2}ඟ\u{dcf}න සමග\u{dd2}න\u{dca} ගෑරප\u{dca}ප\u{dd4}ව සහ ප\u{dd2}හ\u{dd2}ය",
            ),
            keywords: &[
                "ගැරැප\u{dca}ප\u{dd4}ව",
                "ප\u{dd2}ඟ\u{dcf}න",
                "ප\u{dd2}ඟ\u{dcf}න සමග\u{dd2}න\u{dca} ගෑරප\u{dca}ප\u{dd4}ව සහ ප\u{dd2}හ\u{dd2}ය",
                "ප\u{dd2}ස\u{dd3}ම",
                "ප\u{dd2}හ\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("vidlička, nôž a tanier"),
            keywords: &[
                "nôž",
                "tanier",
                "varenie",
                "vidlička",
                "vidlička, nôž a tanier",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vilice, nož in krožnik"),
            keywords: &[
                "krožnik",
                "kuhanje",
                "nož",
                "vilice",
                "vilice, nož in krožnik",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("saxan iyo fargeeta iyo mindi"),
            keywords: &[
                "fargeeta",
                "karinta",
                "mindi",
                "saxan",
                "saxan iyo fargeeta iyo mindi",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("pirun dhe thikë me pjatë"),
            keywords: &[
                "gatim",
                "pirun",
                "pirun dhe thikë me pjatë",
                "pjatë",
                "thikë",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("виљушка и нож са тањиром"),
            keywords: &[
                "виљушка",
                "виљушка и нож са тањиром",
                "кувaњe",
                "нoж",
                "тaњир",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("viljuška i nož sa tanjirom"),
            keywords: &[
                "kuvanje",
                "nož",
                "tanjir",
                "viljuška",
                "viljuška i nož sa tanjirom",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tallrik, kniv och gaffel"),
            keywords: &["bestick", "dukning", "tallrik, kniv och gaffel", "äta"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uma na kisu na sahani"),
            keywords: &["kisu", "kupika", "sahani", "uma", "uma na kisu na sahani"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "தட\u{bcd}டுடன\u{bcd} முள\u{bcd}கரண\u{bcd}டியும\u{bcd} கத\u{bcd}தியும\u{bcd}",
            ),
            keywords: &[
                "உணவு",
                "கத\u{bcd}தி",
                "சமையல\u{bcd}",
                "தட\u{bcd}டு",
                "தட\u{bcd}டுடன\u{bcd} முள\u{bcd}கரண\u{bcd}டியும\u{bcd} கத\u{bcd}தியும\u{bcd}",
                "முள\u{bcd}கரண\u{bcd}டி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "పళ\u{c4d}ల\u{c46}ంత\u{c4b} ఫ\u{c4b}ర\u{c4d}క\u{c4d} మర\u{c3f}యు కత\u{c4d}త\u{c3f}",
            ),
            keywords: &[
                "కత\u{c4d}త\u{c3f}",
                "పళ\u{c4d}ల\u{c46}ం",
                "పళ\u{c4d}ల\u{c46}ంత\u{c4b} ఫ\u{c4b}ర\u{c4d}క\u{c4d} మర\u{c3f}యు కత\u{c4d}త\u{c3f}",
                "ఫ\u{c4b}ర\u{c4d}క\u{c4d}",
                "వంట",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("чангол ва корд бо табақча"),
            keywords: &[
                "корд",
                "пухтан",
                "табақча",
                "чангол",
                "чангол ва корд бо табақча",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("จานพร\u{e49}อมส\u{e49}อมและม\u{e35}ด"),
            keywords: &[
                "จาน",
                "จานพร\u{e49}อมส\u{e49}อมและม\u{e35}ด",
                "ทำอาหาร",
                "ม\u{e35}ด",
                "ส\u{e49}อม",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("tabakly çarşak we pyçak"),
            keywords: &[
                "bişirmek",
                "pyçak",
                "tabak",
                "tabakly çarşak we pyçak",
                "çarşak",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("huhukai moe helekai moe peleti"),
            keywords: &["huhukai moe helekai moe peleti"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("tabakla birlikte çatal ve bıçak"),
            keywords: &[
                "bıçak",
                "tabak",
                "tabakla birlikte çatal ve bıçak",
                "yemek",
                "çatal",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئارا-پىچاق ۋە تەخسە"),
            keywords: &[
                "ئارا",
                "ئارا-پىچاق ۋە تەخسە",
                "تاماق ئېتىش",
                "تەخسە",
                "پىچاق",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("виделка, ніж і тарілка"),
            keywords: &[
                "виделка",
                "виделка, ніж і тарілка",
                "кулінарія",
                "ніж",
                "тарілка",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چھری کانٹے کے ساتھ پلیٹ"),
            keywords: &["پلیٹ", "چھری", "چھری کانٹے کے ساتھ پلیٹ", "کانٹا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("sanchqi, pichoq va likopcha"),
            keywords: &[
                "likopcha",
                "pichoq",
                "sanchqi",
                "sanchqi, pichoq va likopcha",
                "taom",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("dĩa và dao với đĩa"),
            keywords: &["dao", "dĩa và dao với đĩa", "nĩa", "nấu nướng", "đĩa"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("furset and paaka ak asiyet"),
            keywords: &[
                "asiyet",
                "furset",
                "furset and paaka ak asiyet",
                "paaka",
                "togg",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ifolokhwe nemela nepleyiti"),
            keywords: &[
                "ifolokhwe",
                "ifolokhwe nemela nepleyiti",
                "imela",
                "ipleyiti",
                "ukupheka",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("fọ\u{301}ọ\u{300}kì àti ọ\u{300}bẹ pẹ\u{300}lú àwo"),
            keywords: &[
                "fọ\u{301}ọ\u{300}kì",
                "fọ\u{301}ọ\u{300}kì àti ọ\u{300}bẹ pẹ\u{300}lú àwo",
                "àwo",
                "ónjẹ sísè",
                "ọ\u{300}bẹ",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("叉、刀同碟"),
            keywords: &["刀", "叉", "叉、刀同碟", "煮食", "碟"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("叉、刀同碟"),
            keywords: &["刀", "叉", "叉、刀同碟", "煮食", "碟"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("餐具"),
            keywords: &["刀", "叉", "盘", "餐具"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("餐具"),
            keywords: &["刀叉餐盤", "餐具"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("刀叉同碟"),
            keywords: &["刀叉同碟", "刀子", "叉子", "餐具"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("imfoloko nommese nepleti"),
            keywords: &[
                "imfoloko",
                "imfoloko nommese nepleti",
                "ipleti",
                "ukupheka",
                "ummese",
            ],
        },
    ],
};
#[doc = "🍴"]
pub const FORK_AND_KNIFE: crate::Emoji = crate::Emoji {
    glyph: "🍴",
    codepoint: "1F374",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "fork and knife",
    group: "Food & Drink",
    subgroup: "dishware",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("mes en vurk"),
            keywords: &["eet", "kook", "kos", "mes", "mes en vurk", "vurk"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሹካና ቢለዋ"),
            keywords: &["ምግብ ማብሰል/ቢለዋ/ሹካ/ሹካና ቢለዋ/ቢለዋ", "ሹካና ቢለዋ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شوكة وسكينة"),
            keywords: &["سكينة", "شوكة", "شوكة وسكينة", "مطعم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9be}ট\u{9be} চ\u{9be}মোচ আৰ\u{9c1} কট\u{9be}ৰী"),
            keywords: &[
                "কট\u{9be}ৰী",
                "ক\u{9be}ট\u{9be} চ\u{9be}মোচ আৰ\u{9c1} কট\u{9be}ৰী",
                "ক\u{9be}ট\u{9be}চ\u{9be}মোচ",
                "ক\u{9be}ট\u{9be}চ\u{9be}মোচ আৰ\u{9c1} কট\u{9be}ৰী",
                "ৰন\u{9cd}ধন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("çəngəl və bıçaq"),
            keywords: &["bişirmək", "bıçaq", "çəngəl", "çəngəl və bıçaq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("відэлец і нож"),
            keywords: &["відэлец", "відэлец і нож", "гатаванне", "нож"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Нож и вилица"),
            keywords: &["Нож и вилица", "вилица", "готвене", "нож"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9be}\u{981}ট\u{9be}চ\u{9be}মচ ও ছ\u{9c1}রি"),
            keywords: &[
                "ক\u{9be}\u{981}ট\u{9be}চ\u{9be}মচ",
                "ক\u{9be}\u{981}ট\u{9be}চ\u{9be}মচ ও ছ\u{9c1}রি",
                "ছ\u{9c1}রি",
                "রন\u{9cd}ধন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kontell ha fourchetez"),
            keywords: &["kontell ha fourchetez", "preti"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("viljuška i nož"),
            keywords: &["escajg", "kuhanje", "nož", "viljuška", "viljuška i nož"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("forquilla i ganivet"),
            keywords: &["cobert", "forquilla", "forquilla i ganivet", "ganivet"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏳᎩ ᎠᎴ ᎭᏰᎵᏍᏗ"),
            keywords: &["ᎠᏓᏍᏓᏴᎲᏍᎩ", "ᎠᏰᎳᏍᏗ", "ᎭᏰᎵᏍᏗ", "ᏳᎩ ᎠᎴ ᎭᏰᎵᏍᏗ", "ᏴᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("vidlička a nůž"),
            keywords: &[
                "nádobí",
                "nůž",
                "příbor",
                "vaření",
                "vidlička",
                "vidlička a nůž",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("fforc a chyllell"),
            keywords: &["coginio", "cyllell", "fforc", "fforc a chyllell"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kniv og gaffel"),
            keywords: &["bestik", "gaffel", "kniv", "kniv og gaffel"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Gabel und Messer"),
            keywords: &[
                "Besteck",
                "Gabel",
                "Gabel und Messer",
                "Messer",
                "Messer und Gabel",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μαχαιροπίρουνα"),
            keywords: &["μαγείρεμα", "μαχαίρι", "μαχαιροπίρουνα", "πιρούνι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("fork and knife"),
            keywords: &["cooking", "cutlery", "fork", "fork and knife", "knife"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("knife and fork"),
            keywords: &["cooking", "cutlery", "fork", "knife", "knife and fork"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("fork and knife"),
            keywords: &[
                "cooking",
                "cutlery",
                "fork",
                "fork and knife",
                "knife",
                "knife and fork",
            ],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("tenedor y cuchillo"),
            keywords: &["cuchillo", "restaurante", "tenedor", "tenedor y cuchillo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cuchillo y tenedor"),
            keywords: &[
                "cubiertos",
                "cuchillo",
                "cuchillo y tenedor",
                "restaurante",
                "tenedor",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "cocinando",
                "cubiertos",
                "cuchillo",
                "cuchillo y tenedor",
                "tenedor",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kahvel ja nuga"),
            keywords: &["kahvel", "kahvel ja nuga", "nuga", "toit"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("sardeska eta labana"),
            keywords: &[
                "janari",
                "labana",
                "prestatu",
                "sardeska",
                "sardeska eta labana",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کارد و چنگال"),
            keywords: &["آشپزی", "چنگال", "کارد", "کارد و چنگال"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("haarukka ja veitsi"),
            keywords: &[
                "aterimet",
                "haarukka",
                "haarukka ja veitsi",
                "ruokailu",
                "veitsi",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tinidor at kutsilyo"),
            keywords: &["hapag-kainan", "kutsilyo", "tinidor", "tinidor at kutsilyo"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("gaffil og knívur"),
            keywords: &["borðbúnaður", "gaffil", "gaffil og knívur", "knívur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("fourchette et couteau"),
            keywords: &[
                "couteau et fourchette",
                "fourchette et couteau",
                "restaurant",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "couteau",
                "couverts",
                "fourchette",
                "fourchette et couteau",
                "repas",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("scian agus forc"),
            keywords: &["forc", "sceana", "scian", "scian agus forc"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("forc is sgian"),
            keywords: &["còcaireachd", "forc", "forc is sgian", "sgian"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("garfo e coitelo"),
            keywords: &["coitelo", "cubertos", "garfo", "garfo e coitelo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("છરી અન\u{ac7} કા\u{a82}ટો"),
            keywords: &[
                "કા\u{a82}ટો",
                "છરી",
                "છરી અન\u{ac7} કા\u{a82}ટો",
                "ર\u{ac7}સ\u{acd}ટોરન\u{acd}ટ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("cokali mai yatsu da wuƙa"),
            keywords: &[
                "cokali mai yatsu",
                "cokali mai yatsu da wuƙa",
                "girkawa",
                "wuƙa",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סכין ומזלג"),
            keywords: &["אוכל", "מזלג", "סכו״ם", "סכין", "סכין ומזלג"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("फ\u{93c}ोर\u{94d}क और छ\u{941}री–चाक\u{942}"),
            keywords: &[
                "छ\u{941}री–चाक\u{942}",
                "नाइफ\u{93c}",
                "फ\u{93c}ोर\u{94d}क",
                "फ\u{93c}ोर\u{94d}क और छ\u{941}री–चाक\u{942}",
                "र\u{947}स\u{94d}टोर\u{947}\u{902}ट",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("vilica i nož"),
            keywords: &["kuhanje", "nož", "vilica", "vilica i nož"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kés és villa"),
            keywords: &["kés", "kés és villa", "tálalás", "villa"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("դանակ և պատառաքաղ"),
            keywords: &["դանակ", "դանակ և պատառաքաղ", "խոհարարություն", "պատառաքաղ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("garpu dan pisau"),
            keywords: &["garpu", "garpu dan pisau", "masak", "pisau"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ngaji ndụdụ na mma"),
            keywords: &["mmà", "na-esi nri", "ngaji ndụdụ", "ngaji ndụdụ na mma"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hnífur og gaffall"),
            keywords: &["hnífapör", "hnífur og gaffall", "veitingastaður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("forchetta e coltello"),
            keywords: &[
                "coltello",
                "forchetta",
                "forchetta e coltello",
                "ristorante",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ナイフとフォーク"),
            keywords: &[
                "カトラリー",
                "ナイフ",
                "ナイフとフォーク",
                "フォーク",
                "レストラン",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("garpu lan peso"),
            keywords: &["garpu", "garpu lan peso", "masak", "peso", "sendhok garpu"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჩანგალი და დანა"),
            keywords: &["დანა", "საჭმლის მომზადება", "ჩანგალი", "ჩანგალი და დანა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шанышқы мен пышақ"),
            keywords: &["пышақ", "пісіру", "шанышқы", "шанышқы мен пышақ"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kniv og gaffel"),
            keywords: &["bestik", "gaffel", "kniv", "kniv og gaffel"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សមន\u{17b7}ងកា\u{17c6}ប\u{17b7}ត"),
            keywords: &[
                "ការចម\u{17d2}អ\u{17b7}នអាហារ",
                "កា\u{17c6}ប\u{17b7}ត",
                "សម",
                "សម ន\u{17b7}ងកា\u{17c6}ប\u{17b7}ត",
                "សមន\u{17b7}ងកា\u{17c6}ប\u{17b7}ត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಫೋರ\u{ccd}ಕ\u{ccd} ಮತ\u{ccd}ತು ಚಾಕು"),
            keywords: &[
                "ಪೋರ\u{ccd}ಕ\u{ccd} ಮತ\u{ccd}ತು ಚಾಕು",
                "ಫೋರ\u{ccd}ಕ\u{ccd} ಮತ\u{ccd}ತು ಚಾಕು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("포크와 나이프"),
            keywords: &["나이프", "식당", "포크", "포크와 나이프"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("काटो आनी स\u{941}री"),
            keywords: &[
                "कटलरी",
                "काटो",
                "काटो आनी स\u{941}री",
                "रा\u{902}दप",
                "स\u{941}री",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("вилка жана бычак"),
            keywords: &["бычак", "вилка", "вилка жана бычак"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Forschett a Messer"),
            keywords: &["Forschett", "Forschett a Messer", "Messer", "kachend"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{ec9}ອມ ແລະ ມ\u{eb5}ດ"),
            keywords: &[
                "ມ\u{eb5}ດ",
                "ສ\u{ec9}ອມ",
                "ສ\u{ec9}ອມ ແລະ ມ\u{eb5}ດ",
                "ຮ\u{ec9}ານອາຫານ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("šakutė ir peilis"),
            keywords: &["maisto gaminimas", "peilis", "šakutė", "šakutė ir peilis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("nazis un dakša"),
            keywords: &["dakša", "nazis", "nazis un dakša"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("paoka me te naihi"),
            keywords: &["naihi", "paoka", "paoka me te naihi", "tao ana"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("виљушка и нож"),
            keywords: &["виљушка", "виљушка и нож", "готвење", "нож"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കത\u{d4d}തിയ\u{d41}ം മ\u{d41}ള\u{d4d}ള\u{d41}ം"),
            keywords: &[
                "കത\u{d4d}തി",
                "കത\u{d4d}തിയ\u{d41}ം മ\u{d41}ള\u{d4d}ള\u{d41}ം",
                "പ\u{d3e}ചകം",
                "ഫോർക\u{d4d}ക\u{d41}ം നൈഫ\u{d41}ം",
                "ഫോർക\u{d4d}ക\u{d4d}",
                "ഭക\u{d4d}ഷണം",
                "മ\u{d41}ള\u{d4d}ള\u{d4d}",
                "ഹോട\u{d4d}ടൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хутга сэрээ"),
            keywords: &["сэрээ", "хоол", "хутга"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("काटा आणि स\u{941}री"),
            keywords: &[
                "अन\u{94d}न शिजवण\u{947}",
                "काटा",
                "काटा आणि स\u{941}री",
                "स\u{941}री",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("garpu dan pisau"),
            keywords: &["garpu", "garpu dan pisau", "memasak", "pisau"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("furketta u sikkina"),
            keywords: &["furketta", "furketta u sikkina", "sikkina", "tisjir"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ခက\u{103a}ရင\u{103a}းန\u{103e}င\u{1037}\u{103a} ဓား"),
            keywords: &[
                "ခက\u{103a}ရင\u{103a}း",
                "ခက\u{103a}ရင\u{103a}းန\u{103e}င\u{1037}\u{103a} ဓား",
                "ချက\u{103a}ပြ\u{102f}တ\u{103a}ခြင\u{103a}း",
                "ဓား",
                "ပန\u{103a}းကန\u{103a}ခ\u{103d}က\u{103a}ယောက\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kniv og gaffel"),
            keywords: &["gaffel", "kniv", "kniv og gaffel", "matlaging"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("चक\u{94d}क\u{941} र का\u{901}टा"),
            keywords: &[
                "का\u{901}टा",
                "खाना बनाउन\u{947}",
                "चक\u{94d}क\u{941}",
                "चक\u{94d}क\u{941} र का\u{901}टा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("mes en vork"),
            keywords: &["koken", "mes", "mes en vork", "vork"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kniv og gaffel"),
            keywords: &["gaffel", "kniv", "kniv og gaffel", "matlaging"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କଣ\u{b4d}ଟ\u{b3e} ଚ\u{b3e}ମଚ ଏବଂ ଛ\u{b41}ରୀ"),
            keywords: &[
                "କଟଲେରୀ",
                "କଣ\u{b4d}ଟ\u{b3e} ଚ\u{b3e}ମଚ ଏବଂ ଛ\u{b41}ରୀ",
                "କଣ\u{b4d}ଟ\u{b3e}ଚ\u{b3e}ମଚ",
                "କଣ\u{b4d}ଟ\u{b3e}ଚ\u{b3e}ମଚ ଏବଂ ଛ\u{b41}ରୀ",
                "ଛ\u{b41}ରୀ",
                "ରୋଷେଇ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਾ\u{a02}ਟਾ ਅਤ\u{a47} ਛ\u{a41}ਰੀ"),
            keywords: &[
                "ਕਾ\u{a02}ਟਾ",
                "ਕਾ\u{a02}ਟਾ ਅਤ\u{a47} ਚਾਕ\u{a42}",
                "ਕਾ\u{a02}ਟਾ ਅਤ\u{a47} ਛ\u{a41}ਰੀ",
                "ਚਾਕ\u{a42}",
                "ਹ\u{a4b}ਟਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چھری اتے کانٹا"),
            keywords: &["چھری", "چھری اتے کانٹا", "کانٹا", "کھانا-پکانا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fọ\u{301}k An Naif"),
            keywords: &[
                "Fọk",
                "Fọk and Naif",
                "Fọ\u{301}k An Naif",
                "Kọ\u{301}tlẹ\u{301}ri: Tins To Ték Chọp Laik Spun, Naif, Fọk",
                "Naif",
                "To Kuk",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("widelec i nóż"),
            keywords: &["gotowanie", "nóż", "widelec", "widelec i nóż"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښاخۍ او چاقو"),
            keywords: &["پخلی، چوړکۍ، ښاښۍ، ښاښۍ او چاقو، چاقو", "ښاخۍ او چاقو"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("garfo e faca"),
            keywords: &["faca", "garfo", "garfo e faca", "talher"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("faca e garfo"),
            keywords: &["cozinhar", "faca", "faca e garfo", "garfo", "talheres"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tenedor chaymanta khuchuna"),
            keywords: &[
                "cuchilleria",
                "khuchuna",
                "tenedor",
                "tenedor chaymanta khuchuna",
                "waykʼsqa",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("furculiță și cuțit"),
            keywords: &["cuțit", "furculiță", "furculiță și cuțit", "gătit"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-313"),
            keywords: &["E10-313"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("вилка и нож"),
            keywords: &[
                "вилка",
                "вилка и нож",
                "значок ресторана",
                "нож",
                "столовые приборы",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikanya n’icyuma"),
            keywords: &["guteka", "icyuma", "ikanya", "ikanya n’icyuma"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڇري ۽ ڪانٽو"),
            keywords: &["پچائڻ، ڪانٽو، ڇري", "ڇري ۽ ڪانٽو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ගෑරප\u{dca}ප\u{dd4}ව සහ ප\u{dd2}හ\u{dd2}ය"),
            keywords: &[
                "ගැරැප\u{dca}ප\u{dd4}ව",
                "ගෑරප\u{dca}ප\u{dd4}ව සහ ප\u{dd2}හ\u{dd2}ය",
                "ප\u{dd2}ස\u{dd3}ම",
                "ප\u{dd2}හ\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("vidlička a nôž"),
            keywords: &["nôž", "varenie", "vidlička", "vidlička a nôž"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vilice in nož"),
            keywords: &["kuhanje", "nož", "vilice", "vilice in nož"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("fargeeta iyo mindi"),
            keywords: &[
                "fargeeta",
                "fargeeta iyo mindi",
                "karinta",
                "mindi",
                "qalabka mindiyaha",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("pirun dhe thikë"),
            keywords: &["gatim", "pirun", "pirun dhe thikë", "thikë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("виљушка и нож"),
            keywords: &["виљушка", "виљушка и нож", "кувaњe", "нoж"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("viljuška i nož"),
            keywords: &["kuvanje", "nož", "viljuška", "viljuška i nož"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kniv och gaffel"),
            keywords: &[
                "bestick",
                "gaffel",
                "gaffel och kniv",
                "kniv",
                "kniv och gaffel",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uma na kisu"),
            keywords: &["kisu", "kupika", "uma", "uma na kisu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("முள\u{bcd}கரண\u{bcd}டியும\u{bcd} கத\u{bcd}தியும\u{bcd}"),
            keywords: &[
                "உணவகம\u{bcd}",
                "உணவு",
                "உணவு நேரம\u{bcd}",
                "முள\u{bcd}கரண\u{bcd}டியும\u{bcd} கத\u{bcd}தியும\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఫ\u{c4b}ర\u{c4d}క\u{c4d} మర\u{c3f}యు కత\u{c4d}త\u{c3f}"),
            keywords: &[
                "కత\u{c4d}త\u{c3f}",
                "ఫ\u{c4b}ర\u{c4d}క\u{c4d} మర\u{c3f}యు కత\u{c4d}త\u{c3f}",
                "ఫ\u{c4b}ర\u{c4d}క\u{c4d} మర\u{c3f}యు న\u{c48}ఫ\u{c4d}",
                "ముళ\u{c4d}ల గర\u{c3f}ట\u{c46}",
                "ర\u{c46}స\u{c4d}ట\u{c3e}ర\u{c46}ంట\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("чангол ва корд"),
            keywords: &["корд", "пухтан", "чангол", "чангол ва корд"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ส\u{e49}อมและม\u{e35}ด"),
            keywords: &["ร\u{e49}านอาหาร", "ส\u{e49}อมและม\u{e35}ด"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çarşajyk we pyçak"),
            keywords: &[
                "aşhana gurallary",
                "bişirmek",
                "pyçak",
                "çarşajyk we pyçak",
                "çarşak",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("huhukai moe helekai"),
            keywords: &["huhukai moe helekai"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("çatal ve bıçak"),
            keywords: &["bıçak", "restoran", "çatal", "çatal ve bıçak"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئارا ۋە پىچاق"),
            keywords: &["ئارا", "ئارا ۋە پىچاق", "تاماق ئېتىش", "پىچاق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("виделка та ніж"),
            keywords: &["виделка", "виделка та ніж", "кулінарія", "ніж"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کانٹا اور چھری"),
            keywords: &["چھری", "کانٹا", "کانٹا اور چھری"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("sanchqi va pichoq"),
            keywords: &[
                "ovqat pishirish",
                "pichoq",
                "sanchqi",
                "sanchqi va pichoq",
                "taom anjomlari",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("dĩa và dao"),
            keywords: &["dao", "dĩa", "dĩa và dao", "nấu nướng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("furset ak paaka"),
            keywords: &["furset", "furset ak paaka", "paaka", "togg"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("imela nefolokhwe"),
            keywords: &["ifolokhwe", "imela", "imela nefolokhwe", "ukupheka"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Fọki Ati Ọbẹ"),
            keywords: &[
                "Fọki Ati Ọbẹ",
                "fọ\u{301}ọ\u{300}kì",
                "ónjẹ sísè",
                "ọ\u{300}bẹ",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("叉同刀"),
            keywords: &["刀", "叉", "叉同刀", "煮食"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("叉同刀"),
            keywords: &["刀", "叉", "叉同刀", "煮食"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("刀叉"),
            keywords: &["刀", "刀叉", "叉", "餐具"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("刀叉"),
            keywords: &["刀叉"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("imfoloko nommese"),
            keywords: &["imfoloko", "imfoloko nommese", "ukupheka", "ummese"],
        },
    ],
};
#[doc = "🥄"]
pub const SPOON: crate::Emoji = crate::Emoji {
    glyph: "🥄",
    codepoint: "1F944",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "spoon",
    group: "Food & Drink",
    subgroup: "dishware",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("lepel"),
            keywords: &["lepel", "messegoed"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ማንኪያ"),
            keywords: &["ማንኪያ", "የቤት ዕቃዎች"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ملعقة"),
            keywords: &["أدوات مائدة", "ملعقة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চ\u{9be}মোচ"),
            keywords: &["ক\u{9be}ট\u{9be}চ\u{9be}মোচ", "চ\u{9be}মোচ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qaşıq"),
            keywords: &["qaşıq", "süfrə", "yemək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("лыжка"),
            keywords: &["лыжка", "сталовы прыбор"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("лъжица"),
            keywords: &["лъжица", "прибори"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চ\u{9be}মচ"),
            keywords: &["ক\u{9be}\u{981}ট\u{9be} চ\u{9be}মচ", "চ\u{9be}মচ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("loa"),
            keywords: &["loa"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kašika"),
            keywords: &["escajg", "kašika"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cullera"),
            keywords: &["cobert", "cullera"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄌𑄟𑄬𑄌\u{11134}"),
            keywords: &["𑄌𑄟𑄬𑄌\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏗᏙᏗ"),
            keywords: &["ᎠᏗᏙᏗ", "ᎦᏍᎩᎶᎠᏢᏅᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("lžíce"),
            keywords: &["lžíce", "příbor"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("llwy"),
            keywords: &["llestri bwrdd", "llwy"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ske"),
            keywords: &["bestik", "ske"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Löffel"),
            keywords: &["Besteck", "Löffel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κουτάλι"),
            keywords: &["κουτάλι", "μαχαιροπίρουνα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("spoon"),
            keywords: &["spoon", "tableware"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["cutlery", "spoon", "tableware"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cuchara"),
            keywords: &["cubiertos", "cuchara", "cucharilla"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["cubiertos", "cuchara", "cucharita"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("lusikas"),
            keywords: &["lauanõud", "lusikas"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("koilara"),
            keywords: &["koilara", "mahai-tresneria"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قاشق"),
            keywords: &["اسباب سفره", "ظروف میز غذا", "قاشق", "قاشق غذاخوری"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("lusikka"),
            keywords: &["aterimet", "lusikka", "ruokailu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kutsara"),
            keywords: &["kubyertos", "kutsara"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("skeið"),
            keywords: &["borðbúnaður", "skeið"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cuillère"),
            keywords: &["couvert", "cuillère"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("spúnóg"),
            keywords: &["spúnóg", "tae"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("spàin"),
            keywords: &["innealan bùird", "spàin"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("culler"),
            keywords: &["cuberto", "culler"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચમચી"),
            keywords: &["ચમચી", "છરીકા\u{a82}ટા"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("cokali"),
            keywords: &["cokali", "kayan abinci"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כפית"),
            keywords: &["כלי שולחן", "כפית", "סכו״ם"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चम\u{94d}मच"),
            keywords: &["चम\u{94d}मच", "म\u{947}ज क\u{947} बर\u{94d}तन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("žlica"),
            keywords: &["pribor za jelo", "žlica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kanál"),
            keywords: &["evőeszköz", "kanál"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("գդալ"),
            keywords: &["գդալ", "սպասք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("sendok"),
            keywords: &["alat makan", "peralatan makan", "sendok"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ngaji"),
            keywords: &["efere nkụwa", "ngaji"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("skeið"),
            keywords: &["hnífapör", "skeið"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cucchiaio"),
            keywords: &["cucchiaio", "posate"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("スプーン"),
            keywords: &["カトラリー", "スプーン", "食器"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sendhok"),
            keywords: &["pranti dhahar", "sendhok"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კოვზი"),
            keywords: &["კოვზი", "ჭურჭელი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tajɣelt"),
            keywords: &["tajɣelt"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қасық"),
            keywords: &["ыдыс", "қасық"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ske"),
            keywords: &["bestik", "ske"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}លាបព\u{17d2}រា"),
            keywords: &[
                "ប\u{17d2}រដាប\u{17cb}ប\u{17d2}រដាទទ\u{17bd}លអាហារ",
                "ស\u{17d2}លាបព\u{17d2}រា",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಚಮಚ"),
            keywords: &["ಚಮಚ", "ಟೇಬಲ\u{ccd} ಮೇಲ\u{cbf}ರುವುದು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("숟가락"),
            keywords: &["수저", "숟가락", "스푼", "식기", "주방용품", "테이블웨어"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("क\u{941}ल\u{947}र"),
            keywords: &[
                "क\u{941}ल\u{947}र",
                "म\u{947}जावयल\u{94d}यो वस\u{94d}त\u{942}",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кашык"),
            keywords: &["идиш-аяк", "кашык"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Läffel"),
            keywords: &["Geschir", "Läffel"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ບ\u{ec8}ວງ"),
            keywords: &["ບ\u{ec8}ວງ", "ພາຊະນະໂຕະອາຫານ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("šaukštas"),
            keywords: &["įrankis", "šaukštas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("karote"),
            keywords: &["galda piederumi", "karote"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pūnu"),
            keywords: &["pūnu", "taongatēpu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лажица"),
            keywords: &["лажица", "прибор"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d4d}പ\u{d42}ൺ"),
            keywords: &["തവി", "സ\u{d4d}പ\u{d42}ൺ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("халбага"),
            keywords: &["халбага", "ширээний хэрэгсэл"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चमचा"),
            keywords: &["चमचा", "भा\u{902}डी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("sudu"),
            keywords: &["kutleri", "sudu"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("mgħarfa"),
            keywords: &["mgħarfa", "oġġetti tal-mejda"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဇ\u{103d}န\u{103a}း"),
            keywords: &[
                "ဇ\u{103d}န\u{103a}း",
                "ပန\u{103a}းကန\u{103a}ခ\u{103d}က\u{103a}ယောက\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("skje"),
            keywords: &["bestikk", "skje"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("चम\u{94d}चा"),
            keywords: &["चम\u{94d}चा", "ट\u{947}वलव\u{947}यर"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("lepel"),
            keywords: &["bestek", "lepel", "tafelgerei"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("skei"),
            keywords: &["bestikk", "skei"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଚ\u{b3e}ମଚ"),
            keywords: &[
                "ଚ\u{b3e}ମଚ",
                "ଚ\u{b3e}ମଚ । ଟେବ\u{b41}ଲୱେୟ\u{b3e}ର",
                "ଚ\u{b3e}ମ\u{b41}ଚ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚਮਚਾ"),
            keywords: &["ਚਮਚ", "ਚਮਚਾ", "ਮ\u{a47}ਜ\u{a3c} ਦ\u{a47} ਬਰਤਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چمچ"),
            keywords: &["میز کا سامان", "چمچ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Spun"),
            keywords: &[
                "Spun",
                "Tébúlwea: Tins Wé Yu De Ték Chọp Laik Spun, Naif, Fọk, Plet, Kọp",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("łyżka"),
            keywords: &["sztućce", "łyżeczka", "łyżka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کاشوغه"),
            keywords: &["ټیبل ویر", "کاشوغه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("colher"),
            keywords: &["colher", "talher"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["colher", "talheres"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("wislla"),
            keywords: &["vajilla", "wislla"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("lingură"),
            keywords: &["lingură", "tacâmuri"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1060"),
            keywords: &["E10-1060"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("ложка"),
            keywords: &["ложка", "прибор", "приборы", "стол", "столовые"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("akayiko"),
            keywords: &["akayiko", "ibyombo", "ikiyiko"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("چمچ"),
            keywords: &["چمچ", "چمچ، ميز جا برتن"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හැන\u{dca}ද"),
            keywords: &["කෑම මේසයේ උපකරණ", "හැන\u{dca}ද"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("lyžica"),
            keywords: &["lyžica", "príbor"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("žlica"),
            keywords: &["pribor", "žlica"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qaaddo"),
            keywords: &["qaaddo", "saxamada miiska cuntada"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("lugë"),
            keywords: &["artikull kuzhine", "lugë", "takëm"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кашика"),
            keywords: &["есцајг", "кашика", "кашичица"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kašika"),
            keywords: &["escajg", "kašika", "kašičica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("sked"),
            keywords: &["bestick", "sked"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kijiko"),
            keywords: &["kijiko", "vyombo vya kulia"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கரண\u{bcd}டி"),
            keywords: &["கரண\u{bcd}டி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c46}ంచ\u{c3e}"),
            keywords: &[
                "చ\u{c46}ంచ\u{c3e}",
                "ట\u{c47}బుల\u{c4d} స\u{c4d}పూన\u{c4d}",
                "స\u{c4d}పూన\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("қошуқ"),
            keywords: &["зарфҳои хӯрокхӯрӣ", "қошуқ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ช\u{e49}อน"),
            keywords: &["ช\u{e49}อน", "ภาชนะ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çemçe"),
            keywords: &["gap-gaç", "çemçe"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("sēpuni"),
            keywords: &["sēpuni"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kaşık"),
            keywords: &["kaşık", "yemek takımı"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قوشۇق"),
            keywords: &["داستىخان", "قوشۇق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("ложка"),
            keywords: &["ложка", "прибори"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چمچ"),
            keywords: &["چمچ", "کھانے کی میز"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qoshiq"),
            keywords: &["oshxona anjomi", "qoshiq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("thìa"),
            keywords: &["bộ đồ ăn", "thìa"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kuddu"),
            keywords: &["kuddu", "taabal"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("icephe"),
            keywords: &["icephe", "izitya zetafile"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ṣíbí"),
            keywords: &["ǹkan ilé ìdáná", "Ṣíbí", "ṣíbí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("匙羮"),
            keywords: &["匙羮", "餐具"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("匙羮"),
            keywords: &["匙羮", "餐具"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("匙"),
            keywords: &["匙", "匙子", "汤匙", "调羹", "餐具"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("湯匙"),
            keywords: &["湯匙", "餐具"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("匙羹"),
            keywords: &["匙羹", "餐具"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isipunu"),
            keywords: &["isipunu", "okwetafula"],
        },
    ],
};
#[doc = "🔪"]
pub const KITCHEN_KNIFE: crate::Emoji = crate::Emoji {
    glyph: "🔪",
    codepoint: "1F52A",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "kitchen knife",
    group: "Food & Drink",
    subgroup: "dishware",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kombuismes"),
            keywords: &["kombuis", "kombuismes", "kos", "mes", "wapen"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የወጥ ቤት ቢላዋ"),
            keywords: &["ሆቾ", "ምግብ ማብሰል", "ቢላዋ", "የወጥ ቤት ቢላዋ", "ጦር መሣሪያ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سكين طهي"),
            keywords: &["سكين", "سكين طهي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ৰ\u{9be}ন\u{9cd}ধনী ঘৰৰ কট\u{9be}ৰী"),
            keywords: &[
                "অস\u{9cd}ত\u{9cd}ৰ",
                "কট\u{9be}ৰী",
                "স\u{981}জ\u{9c1}লি",
                "হ’চ\u{9cd}চ’",
                "ৰন\u{9cd}ধন",
                "ৰ\u{9be}ন\u{9cd}ধনী ঘৰৰ কট\u{9be}ৰী",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("mətbəx bıçağı"),
            keywords: &[
                "alət",
                "bişirmək",
                "bıçaq",
                "hoço",
                "mətbəx bıçağı",
                "silah",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кухонны нож"),
            keywords: &["гатаванне", "зброя", "кухонны нож", "нож", "інструмент"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Кухненски нож"),
            keywords: &["Кухненски нож", "готвене", "инструмент", "нож", "оръжие"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("র\u{9be}ন\u{9cd}ন\u{9be} ঘরের ছ\u{9c1}রি"),
            keywords: &[
                "অস\u{9cd}ত\u{9cd}র",
                "ছ\u{9c1}রি",
                "রন\u{9cd}ধন",
                "র\u{9be}ন\u{9cd}ন\u{9be} ঘরের ছ\u{9c1}রি",
                "হোকো",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kontell-gegin"),
            keywords: &["arm", "kegin", "kontell", "kontell-gegin"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kuhinjski nož"),
            keywords: &["alat", "kuhanje", "kuhinjski nož", "nož", "oružje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("ganivet de cuina"),
            keywords: &["arma", "cuina", "ganivet", "ganivet de cuina"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄛𑄇\u{11134}𑄊\u{11127}𑄢\u{11127}𑄢\u{11134} 𑄌\u{1112a}𑄢\u{11128}"),
            keywords: &["𑄛𑄇\u{11134}𑄊\u{11127}𑄢\u{11127}𑄢\u{11134} 𑄌\u{1112a}𑄢\u{11128}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏓᏍᏓᏱᏗᎢ ᎠᏰᎳᏍᏗ"),
            keywords: &[
                "ᎠᎵᏍᏕᎸᏙᏗ",
                "ᎠᏓᏍᏓᏱᏗᎢ ᎠᏰᎳᏍᏗ",
                "ᎠᏓᏍᏓᏴᎲᏍᎬᎢ",
                "ᎠᏰᎳᏍᏗ",
                "ᎬᏔᏂᏓᏍᏗ",
                "ᎰᏦ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kuchyňský nůž"),
            keywords: &[
                "kuchyňský nůž",
                "nádobí",
                "nástroj",
                "nůž",
                "vaření",
                "zbraň",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cyllell cegin"),
            keywords: &["cegin", "coginio", "cyllell"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("køkkenkniv"),
            keywords: &["kniv", "køkkenkniv"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Küchenmesser"),
            keywords: &["Küchenmesser", "Messer"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κουζινομάχαιρο"),
            keywords: &["εργαλείο", "κουζινομάχαιρο", "μαγειρική", "μαχαίρι", "όπλο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("kitchen knife"),
            keywords: &[
                "cooking",
                "hocho",
                "kitchen knife",
                "knife",
                "tool",
                "weapon",
            ],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &[
                "cooking",
                "cutlery",
                "hocho",
                "kitchen knife",
                "knife",
                "tool",
                "weapon",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cuchillo de cocina"),
            keywords: &["arma", "cocinar", "cuchillo", "cuchillo de cocina"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["arma", "cocina", "cuchillo", "cuchillo de cocina"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "arma",
                "cocinando",
                "cuchillo",
                "cuchillo de cocina",
                "herramienta",
                "hocho",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kööginuga"),
            keywords: &["kööginuga", "köök", "nuga", "relv", "tööriist"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("sukaldeko labana"),
            keywords: &["arma", "hocho", "janari", "labana", "sukaldeko labana"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("چاقوی آشپزخانه"),
            keywords: &[
                "آشپزی",
                "ابزار",
                "اسلحه",
                "ساطور",
                "هوچو",
                "چاقو",
                "چاقوی آشپزخانه",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("keittiöveitsi"),
            keywords: &[
                "keittiöveitsi",
                "leikkuuveitsi",
                "ruoanlaitto",
                "teräase",
                "työkalu",
                "veitsi",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kutsilyo"),
            keywords: &["armas", "kutsilyo", "pagluluto", "sandata"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("køksknívur"),
            keywords: &["knívur", "køksknívur", "vápn"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("couteau de cuisine"),
            keywords: &["arme", "couteau", "couteau de cuisine", "cuisine", "outil"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("scian"),
            keywords: &["arm", "cócaireacht", "scian", "uirlis"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sgian cidsin"),
            keywords: &[
                "acainn",
                "arm",
                "còcaireachd",
                "hocho",
                "inneal",
                "sgian",
                "sgian cidsin",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("coitelo de cociña"),
            keywords: &["arma", "cociña", "coitelo", "coitelo de cociña"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("રસોડાનો ચાક\u{ac1}"),
            keywords: &["ચાક\u{ac1}", "રસોડાનો ચાક\u{ac1}"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("wuƙar kicin"),
            keywords: &[
                "girkawa",
                "hocho",
                "kayan aiki",
                "makami",
                "wuƙa",
                "wuƙar kicin",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סכין מטבח"),
            keywords: &["בישול", "כלי נשק", "סכין", "סכין מטבח"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("खाना बनान\u{947} का चाक\u{942}"),
            keywords: &["खाना बनान\u{947} का चाक\u{942}", "चाक\u{942}"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kuhinjski nož"),
            keywords: &["alat", "kuhanje", "kuhinjski nož", "nož", "oružje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("konyhakés"),
            keywords: &["eszköz", "felszerelés", "konyha", "konyhakés", "kés"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("խոհանոցային դանակ"),
            keywords: &[
                "գործիք",
                "դանակ",
                "եփել",
                "զենք",
                "խոհանոցային դանակ",
                "խոհարար",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pisau dapur"),
            keywords: &["alat", "hocho", "masak", "pisau", "pisau dapur", "senjata"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("mma usekwu"),
            keywords: &[
                "mma",
                "mma hocho",
                "mma usekwu",
                "na-esi nri",
                "ngwa agha",
                "ngwaọrụ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hnífur"),
            keywords: &["eldhúshnífur", "hnífur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("coltello da cucina"),
            keywords: &["coltello", "coltello da cucina", "cucina"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("包丁"),
            keywords: &["ナイフ", "包丁", "料理"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("peso dhapur"),
            keywords: &["alat", "gaman", "hocho", "masak", "peso", "peso dhapur"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სამზარეულოს დანა"),
            keywords: &[
                "დანა",
                "იარაღი",
                "ინსტრუმენტი",
                "სამზარეულოს დანა",
                "საჭმლის მომზადება",
                "ხელსაწყო",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tafruyt n usaččet"),
            keywords: &["tafruyt n usaččet"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("асхана пышағы"),
            keywords: &["асхана пышағы", "пышақ", "пісіру", "хочо", "қару", "құрал"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("køkkenkniv"),
            keywords: &["kniv", "køkkenkniv"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កា\u{17c6}ប\u{17b7}ទច\u{17b7}តបន\u{17d2}លែ"),
            keywords: &[
                "កា\u{17c6}ប\u{17b7}ទ",
                "កា\u{17c6}ប\u{17b7}ទច\u{17b7}តបន\u{17d2}លែ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಅಡುಗ\u{cc6}ಮನ\u{cc6} ಚಾಕು"),
            keywords: &["ಅಡುಗ\u{cc6} ಚಾಕು", "ಅಡುಗ\u{cc6}ಮನ\u{cc6} ಚಾಕು", "ಚಾಕು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("식칼"),
            keywords: &["식칼", "요리용 칼"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("रा\u{902}दची स\u{941}री"),
            keywords: &[
                "अवजारा\u{902}",
                "रा\u{902}दची स\u{941}री",
                "रा\u{902}दप",
                "रा\u{902}दपाची स\u{941}री",
                "स\u{941}री",
                "हत\u{94d}यार",
                "होचो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ашкана бычагы"),
            keywords: &["ашкана бычагы", "бычак", "бышыруу", "курал"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Kichemesser"),
            keywords: &[
                "Kichemesser",
                "Kichen",
                "Messer",
                "Utensil",
                "Waff",
                "kachen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ມ\u{eb5}ດໃຊ\u{ec9}ໃນເຮ\u{eb7}ອນຄ\u{ebb}ວ"),
            keywords: &[
                "ມ\u{eb5}ດ",
                "ມ\u{eb5}ດໃຊ\u{ec9}ໃນເຮ\u{eb7}ອນຄ\u{ebb}ວ",
                "ເຮ\u{eb7}ອນຄ\u{ebb}ວ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("virtuvinis peilis"),
            keywords: &[
                "ginklas",
                "maisto gaminimas",
                "peilis",
                "virtuvinis peilis",
                "įrankis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("virtuves nazis"),
            keywords: &["ierocis", "nazis", "virtuves nazis", "ēst"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("naihi kīhini"),
            keywords: &[
                "hocho",
                "naihi",
                "naihi kīhini",
                "rākau-riri",
                "tao ana",
                "utauta",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("кујнски нож"),
            keywords: &["готвење", "кујнски нож", "нож"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കത\u{d4d}തി"),
            keywords: &[
                "ആയ\u{d41}ധം",
                "കത\u{d4d}തി",
                "കറിക\u{d4d}കത\u{d4d}തി",
                "പ\u{d3e}ചക കത\u{d4d}തി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гал тогооны хутга"),
            keywords: &["гал тогоо", "гал тогооны хутга", "хутга"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{94d}वय\u{902}पाकघरात वापरला जाणारा चाक\u{942}"),
            keywords: &[
                "अन\u{94d}न शिजवण\u{947}",
                "शस\u{94d}त\u{94d}र",
                "साधन",
                "स\u{941}री",
                "स\u{94d}वय\u{902}पाकघरात वापरला जाणारा चाक\u{942}",
                "स\u{94d}वय\u{902}पाकघरातील स\u{941}री",
                "होचो",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pisau dapur"),
            keywords: &[
                "alat",
                "hocho",
                "memasak",
                "pisau",
                "pisau dapur",
                "senjata",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("sikkina tal-kċina"),
            keywords: &[
                "arma",
                "għodda",
                "hocho",
                "sikkina",
                "sikkina tal-kċina",
                "tisjir",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မ\u{102e}းဖ\u{102d}\u{102f}သ\u{102f}\u{1036}း ဓား"),
            keywords: &[
                "က\u{102d}ရ\u{102d}ယာ",
                "ချက\u{103a}ပြ\u{102f}တ\u{103a}ခြင\u{103a}း",
                "ဓား",
                "မ\u{102e}းဖ\u{102d}\u{102f}သ\u{102f}\u{1036}း ဓား",
                "လက\u{103a}နက\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kokkekniv"),
            keywords: &["kniv", "kokkekniv", "matlaging", "verktøy", "våpen"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("भान\u{94d}स\u{947} चक\u{94d}क\u{941}"),
            keywords: &[
                "उपकरण",
                "चक\u{94d}क\u{941}",
                "पकाउन\u{947} कार\u{94d}य",
                "भान\u{94d}स\u{947} चक\u{94d}क\u{941}",
                "हतियार",
                "होचो",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("keukenmes"),
            keywords: &["keukenmes", "koken", "mes", "wapen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kokkekniv"),
            keywords: &["kniv", "kokkekniv", "matlaging", "verktøy", "våpen"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ରୋଷେଇଶ\u{b3e}ଳ ଛ\u{b41}ରୀ"),
            keywords: &[
                "ଚ\u{b3e}କ\u{b41}",
                "ଛ\u{b41}ରୀ",
                "ରୋଷେଇଶ\u{b3e}ଳ ଛ\u{b41}ରୀ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਰਸ\u{a4b}ਈ ਚਾਕ\u{a42}"),
            keywords: &[
                "ਖਾਣਾ ਪਕਾਉਣ ਚਾਕ\u{a42}",
                "ਚਾਕ\u{a42}",
                "ਰਸ\u{a4b}ਈ ਚਾਕ\u{a42}",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("باورچی خانے دی چھری"),
            keywords: &[
                "اوزار",
                "باورچی خانے دی چھری",
                "چھری",
                "کھانا-پکانا",
                "ہاکو",
                "ہتھیار",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kíchín Naif"),
            keywords: &[
                "Japán Kíchín Naif",
                "Kíchín Naif",
                "Naif",
                "To Kuk",
                "Tul",
                "Wẹ\u{301}pọn",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("nóż kuchenny"),
            keywords: &["broń", "gotowanie", "narzędzie", "nóż", "nóż kuchenny"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د پخلنځی چاقو"),
            keywords: &["د پخلنځی چاقو", "پخلی، هوچو، د پخلنځی چاقو، چاقو، وسله"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("faca de cozinha"),
            keywords: &["faca", "faca de cozinha"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "arma",
                "cortar",
                "cozinhar",
                "faca",
                "faca de cozinha",
                "utensílio",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("khuchuna waykʼuypaq"),
            keywords: &[
                "arma",
                "hocho",
                "khuchuna",
                "khuchuna waykʼuypaq",
                "llamkana",
                "waykʼusqa",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cuțit de bucătărie"),
            keywords: &["armă", "cuțit", "cuțit de bucătărie", "gătit", "instrument"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-742"),
            keywords: &["E10-742"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("нож"),
            keywords: &["кухонный", "нож", "оружие", "холодное"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("icyuma cyo mu gikoni"),
            keywords: &[
                "guteka",
                "hosho",
                "icyuma",
                "icyuma cyo mu gikoni",
                "igikoresho",
                "intwaro",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("رڌڻي جي ڇري"),
            keywords: &["رڌڻي جي ڇري", "پچائڻ، هوچو، ڇري، اوزار، هٿيار"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ම\u{dd4}ළ\u{dd4}තැන\u{dca}ගෙය\u{dd2} ප\u{dd2}හ\u{dd2}ය"),
            keywords: &[
                "ආය\u{dd4}ධය",
                "ආහ\u{dcf}ර ප\u{dd2}ස\u{dd3}ම",
                "ප\u{dd2}හ\u{dd2}ය",
                "ම\u{dd4}ළ\u{dd4}තැන\u{dca}ගෙය\u{dd2} ප\u{dd2}හ\u{dd2}ය",
                "මෙවලම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kuchynský nôž"),
            keywords: &["kuchynský nôž", "nástroj", "nôž", "varenie", "zbraň"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kuhinjski nož"),
            keywords: &[
                "hocho",
                "kuhanje",
                "kuhinjski nož",
                "nož",
                "orodje",
                "orožje",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("mindi kushiin"),
            keywords: &["karinta", "mindi", "mindi kushiin", "qalab"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("thikë kuzhine"),
            keywords: &["armë", "gatim", "thikë", "thikë kuzhine", "vegël"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кухињски нож"),
            keywords: &["aлaт", "oружje", "кувaњe", "кухињски нож", "нoж"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kuhinjski nož"),
            keywords: &["alat", "kuhinjski nož", "kuvanje", "nož", "oružje"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kökskniv"),
            keywords: &["kniv", "kökskniv"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kisu kinachotumika jikoni"),
            keywords: &[
                "hocho",
                "kisu",
                "kisu kinachotumika jikoni",
                "kupika",
                "silaha",
                "zana",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சமையல\u{bcd} கத\u{bcd}தி"),
            keywords: &[
                "கத\u{bcd}தி",
                "க\u{bbe}ய\u{bcd}கறி வெட\u{bcd}டுதல\u{bcd}",
                "சமையல\u{bcd} கத\u{bcd}தி",
                "வெட\u{bcd}டு கத\u{bcd}தி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కూరగ\u{c3e}యలు తర\u{c3f}గ\u{c47} కత\u{c4d}త\u{c3f}"),
            keywords: &[
                "కూరగ\u{c3e}యలు తర\u{c3f}గ\u{c47} కత\u{c4d}త\u{c3f}",
                "చ\u{c3f}న\u{c4d}న కత\u{c4d}త\u{c3f}",
                "వంట గద\u{c3f}ల\u{c4b} ఉపయ\u{c4b}గ\u{c3f}ంచ\u{c47} కత\u{c4d}త\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("корди ошхона"),
            keywords: &["асбоб", "корд", "корди ошхона", "пухтан", "силоҳ", "ҳочо"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ม\u{e35}ดทำคร\u{e31}ว"),
            keywords: &["ม\u{e35}ด", "ม\u{e35}ดทำคร\u{e31}ว"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("aşhana pyçagy"),
            keywords: &["aş", "aşhana pyçagy", "bişirmek", "gural", "pyçak", "ýarag"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("hele paipa"),
            keywords: &["hele paipa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("mutfak bıçağı"),
            keywords: &["bıçak", "mutfak bıçağı"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاشخانا پىچىقى"),
            keywords: &[
                "ئاشخانا پىچىقى",
                "تاماق ئېتىش",
                "جابدۇق",
                "قورال",
                "قىڭراق",
                "پىچاق",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кухонний ніж"),
            keywords: &["зброя", "знаряддя", "кухня", "кухонний ніж", "ніж"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کچن کی چھری"),
            keywords: &["آلہ", "چھری", "ک\u{64f}کنگ", "کچن کی چھری"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("pichoq"),
            keywords: &["asbob", "pichoq", "qurol", "taom"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("dao làm bếp"),
            keywords: &[
                "dao",
                "dao làm bếp",
                "dụng cụ",
                "hocho",
                "nấu nướng",
                "vũ khí",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("paaka waañ"),
            keywords: &[
                "hocho",
                "jumtukaay",
                "ngànnaay",
                "paaka",
                "paaka waañ",
                "togg",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("imela yasekhitshini"),
            keywords: &[
                "i-hocho",
                "imela",
                "imela yasekhitshini",
                "isixhobo",
                "ukupheka",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ọbẹ iyara-idana"),
            keywords: &[
                "hocho",
                "irinṣẹ\u{301}",
                "irinṣẹ\u{301} ìjagun",
                "àsè",
                "ò\u{329}bẹ",
                "ọbẹ iyara-idana",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("廚房刀"),
            keywords: &["hocho", "刀", "工具", "廚房刀", "武器", "煮食"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("厨房刀"),
            keywords: &["hocho", "刀", "厨房刀", "工具", "武器", "煮食"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("菜刀"),
            keywords: &["刀", "武器", "烹饪", "菜刀"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("菜刀"),
            keywords: &["刀", "菜刀"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("刀"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ummese wasekhishini"),
            keywords: &[
                "ihocho",
                "isikhali",
                "ithuluzi",
                "ukupheka",
                "ummese",
                "ummese wasekhishini",
            ],
        },
    ],
};
#[doc = "🏺"]
pub const AMPHORA: crate::Emoji = crate::Emoji {
    glyph: "🏺",
    codepoint: "1F3FA",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "amphora",
    group: "Food & Drink",
    subgroup: "dishware",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("amfoor"),
            keywords: &["amfoor", "aquarius", "diereriem", "drink", "kook", "kruik"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አምፎራ ማሰሮ"),
            keywords: &["መጠጣት", "ማሰሮ", "ምግብ ማብሰል", "አምፎራ ማሰሮ", "አኳይረስ", "ጆግ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("جرة"),
            keywords: &["أداة", "برج", "جرة", "دلو", "سلاح", "شراب", "طهي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("এম\u{9cd}ফোৰ\u{9be}"),
            keywords: &[
                "এম\u{9cd}ফোৰ\u{9be}",
                "ক\u{9c1}ম\u{9cd}ভ ৰ\u{9be}শি",
                "জগ",
                "প\u{9be}নীয\u{9bc}",
                "ৰন\u{9cd}ধন",
                "ৰ\u{9be}শি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("amfora"),
            keywords: &[
                "alət",
                "amfora",
                "bişirmək",
                "dolça",
                "içmək",
                "silah",
                "zodiak",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("амфара"),
            keywords: &["амфара", "вадаліў", "задыяк", "збан", "напой"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("амфора"),
            keywords: &["амфора", "питие", "съд"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("অ\u{9cd}য\u{9be}ম\u{9cd}ফোর\u{9be}"),
            keywords: &[
                "অ\u{9cd}য\u{9be}ম\u{9cd}ফোর\u{9be}",
                "ক\u{9c1}ম\u{9cd}ভর\u{9be}শি",
                "জ\u{9be}গ",
                "প\u{9be}ন কর\u{9be}",
                "রন\u{9cd}ধন",
                "র\u{9be}শিচক\u{9cd}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("añforenn"),
            keywords: &["añforenn", "evaj"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("amfora"),
            keywords: &["amfora", "horoskopski znak", "kuhanje", "piće", "ćup"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("àmfora"),
            keywords: &["aquari", "beguda", "gerra", "zodíac", "àmfora"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎩᎦᎨ ᎠᏗᏔᏍᏗ ᏗᏟᏍᏙᏗ"),
            keywords: &[
                "ᎠᎹ ᎦᏅᏥᏙᎯ",
                "ᎠᏓᏍᏓᏴᎲᏍᎩ",
                "ᎠᏗᏔᏍᏗ",
                "ᎦᏓ ᎫᎩ",
                "ᎩᎦᎨ ᎠᏗᏔᏍᏗ ᏗᏟᏍᏙᏗ",
                "ᏃᏈᏏ ᏓᏟᎶᏍᏗᎲᎢ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("amfora"),
            keywords: &[
                "amfora",
                "nádoba",
                "nádobí",
                "nápoj",
                "vaření",
                "vodnář",
                "váza",
                "zvěrokruh",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("llestri"),
            keywords: &["coginio", "diod", "jwg", "llestri", "sidydd", "y Dyfrwr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("amfora"),
            keywords: &[
                "amfora",
                "drik",
                "kande",
                "krukke",
                "madlavning",
                "stjernetegn",
                "vandmand",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Amphore"),
            keywords: &["Amphore", "Gefäß", "Krug", "Vase", "Wassermann", "kochen"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: None,
            keywords: &["Amphore"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αμφορέας"),
            keywords: &[
                "Υδροχόος",
                "αμφορέας",
                "ζώδιο",
                "κανάτα",
                "μαγειρική",
                "ποτό",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("amphora"),
            keywords: &["Aquarius", "amphora", "cooking", "drink", "jug", "zodiac"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["Aquarius", "amphora", "drink", "jar", "jug", "zodiac"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["Aquarius", "amphora", "drink", "jar", "jug", "zodiac"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ánfora"),
            keywords: &["acuario", "beber", "jarra", "zodiaco", "ánfora"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("vasija"),
            keywords: &["jarra", "vasija"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("ánfora"),
            keywords: &[
                "Acuario",
                "bebida",
                "cocinando",
                "jarra",
                "zodiaco",
                "ánfora",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("amfora"),
            keywords: &["amfora", "jook", "kann", "vaas", "veevalaja"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("anfora"),
            keywords: &["anfora", "aquarius", "edari", "janari", "pitxer"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("سبو"),
            keywords: &["آشپزی", "دلو", "زودیاک", "سبو", "نوشیدنی", "کوزه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("amfora"),
            keywords: &[
                "amfora",
                "horoskooppi",
                "horoskooppimerkki",
                "juoma",
                "kannu",
                "ruoanlaitto",
                "vesimies",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("amphora"),
            keywords: &[
                "Aquarius", "amphora", "banga", "inumin", "langis", "sisidlan", "zodiac",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("amfora"),
            keywords: &["amfora", "krukka", "stjørnumerki"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("amphore"),
            keywords: &["amphore", "cuisine", "vase"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["amphore", "cuisine", "vase", "verseau", "zodiaque"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("amfara"),
            keywords: &["Aquarius ! cócaireacht", "amfara", "crúisín", "deoch"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("amfora"),
            keywords: &[
                "acainn",
                "amfora",
                "aquarius",
                "arm",
                "còcaireachd",
                "deoch",
                "fear-giùlain uisge",
                "grian-chriosach",
                "inneal",
                "siuga",
                "òl",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("ánfora"),
            keywords: &["Acuario", "antigüidade", "zodíaco", "ánfora"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બરણી"),
            keywords: &[
                "ક\u{ac1}\u{a82}ભ",
                "જગ",
                "ડ\u{acd}રિ\u{a82}ક",
                "પીણ\u{ac1}\u{a82}",
                "બરણી",
                "રસોઈ",
                "રાશિ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("amphora"),
            keywords: &[
                "Aquarius",
                "amphora",
                "buta",
                "girkawa",
                "kayan aiki",
                "makami",
                "sha",
                "zodiac",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כד עתיק"),
            keywords: &["יין", "כד", "משקה", "עתיק"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("शराब का क\u{902}ट\u{947}नर, जग"),
            keywords: &[
                "जग",
                "शराब का क\u{902}ट\u{947}नर",
                "शराब का क\u{902}ट\u{947}नर, जग",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("amfora"),
            keywords: &["amfora", "kuhanje", "piće", "vodenjak", "vrč", "zodijak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("amfora"),
            keywords: &["amfora", "edény", "váza", "vízöntő"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սափոր"),
            keywords: &[
                "գործիք",
                "զենք",
                "խմել",
                "խոհարարություն",
                "կենդանակերպ",
                "ջրհոս",
                "սափոր",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("amphora"),
            keywords: &[
                "Aquarius", "amphora", "kendi", "memasak", "minuman", "zodiak",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("iko nwere aka àbụọ"),
            keywords: &[
                "iko nwere aka àbụọ",
                "na-esi nri",
                "ngwaọgụ",
                "ngwaọrụ",
                "nnukwu iko",
                "zodịak",
                "ṅụọ",
                "Ọgba nchekwa azụ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("leirkrukka"),
            keywords: &[
                "drykkur",
                "eldamennska",
                "krukka",
                "leirkrukka",
                "vatnsberi",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("anfora"),
            keywords: &[
                "acquario",
                "anfora",
                "ornamento",
                "reperto",
                "segno zodiacale",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("壺"),
            keywords: &["かめ", "壺", "星座", "水瓶"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("guci kuping loro"),
            keywords: &[
                "Aquarius",
                "amphora",
                "guci kuping loro",
                "masak",
                "palintangan",
                "teko",
                "unjukan",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ამფორა"),
            keywords: &[
                "ამფორა",
                "დალევა",
                "დოქი",
                "ზოდიაქო",
                "მერწყული",
                "სასმელი",
                "ქვევრი",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("abuqal"),
            keywords: &["abuqal"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("амфора"),
            keywords: &[
                "амфора",
                "зодиак",
                "пісіру",
                "суқұйғыш",
                "ішімдік",
                "құмыра",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("amphora"),
            keywords: &[
                "amphora",
                "drik",
                "kande",
                "krukke",
                "madlavning",
                "stjernetegn",
                "våben",
                "værktøj",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ថ\u{17bc}ប\u{17bb}រាណ"),
            keywords: &["ថ\u{17bc}", "ថ\u{17bc}ប\u{17bb}រាណ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಅಂಫೋರಾ"),
            keywords: &["ಅಂಫೋರಾ", "ಆಯುಧ", "ಜಗ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("암포라"),
            keywords: &["단지", "암포라"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("एम\u{94d}फोरा"),
            keywords: &[
                "एम\u{94d}फोरा",
                "क\u{941}\u{902}भ",
                "जग",
                "पिण\u{947}\u{902}",
                "रा\u{902}दप",
                "रास",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("амфора"),
            keywords: &["амфора", "бышыр", "зодиак", "ич", "курал", "суупери"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Amphore"),
            keywords: &[
                "Amphore",
                "Gedrénks",
                "Krou",
                "Stärzeechen",
                "Utensil",
                "Waassermann",
                "Waff",
                "kachend",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໂຖແອມໂພຣາ"),
            keywords: &["ໂຖບ\u{eb9}ຮານ", "ໂຖແອມໂພຣາ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("senovinė vaza"),
            keywords: &["maisto gaminimas", "senovinė vaza", "vandenis", "zodiakas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("amfora"),
            keywords: &["amfora", "dzert", "trauks", "zodiaks", "Ūdensvīrs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("amapora"),
            keywords: &[
                "Aquarius",
                "amapora",
                "poutiriao",
                "rākau",
                "tao ana",
                "tiaka",
                "unu",
                "utauta",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("амфора"),
            keywords: &["амфора", "бокал", "пијалак", "стомна", "ќуп"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ആംഫെറ"),
            keywords: &[
                "ആംഫെറ",
                "ഉപകരണം",
                "ക\u{d41}ംഭര\u{d3e}ശി",
                "ക\u{d41}ടം",
                "ജഗ\u{d4d}",
                "പ\u{d3e}ചകം",
                "ര\u{d3e}ശി ചക\u{d4d}രം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бумба"),
            keywords: &["Хумх", "бумба", "зурхай", "уух юм", "хоол хийх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("दोन कान असल\u{947}ल\u{947} प\u{94d}राचीन भा\u{902}ड\u{947}"),
            keywords: &[
                "अन\u{94d}न शिजवण\u{947}",
                "क\u{941}\u{902}भ रास",
                "जग",
                "दोन कान असल\u{947}ल\u{947} प\u{94d}राचीन भा\u{902}ड\u{947}",
                "प\u{947}य",
                "शस\u{94d}त\u{94d}र",
                "साधन",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("amfora"),
            keywords: &["amfora", "aquarius", "kendi", "memasak", "minum", "zodiak"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("anfora"),
            keywords: &[
                "Aquarius", "anfora", "arma", "buqar", "għodda", "tisjir", "xarba", "żodjaku",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စဥ\u{1037}\u{103a}အ\u{102d}\u{102f}း"),
            keywords: &[
                "ကရား",
                "က\u{102f}\u{1036}ရာသ\u{102e}",
                "ချက\u{103a}ပြ\u{102f}တ\u{103a}ခြင\u{103a}း",
                "ဂရ\u{102d}စဉ\u{1037}\u{103a}အ\u{102d}\u{102f}း",
                "စဥ\u{1037}\u{103a}အ\u{102d}\u{102f}း",
                "ဆယ\u{1037}\u{103a}န\u{103e}စ\u{103a}ရာသ\u{102e}ခ\u{103d}င\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("amfora"),
            keywords: &[
                "amfora",
                "drikke",
                "krukke",
                "matlaging",
                "stjernebilde",
                "stjernetegn",
                "vannmannen",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("आम\u{94d}फोरा"),
            keywords: &[
                "आम\u{94d}फोरा",
                "एक\u{94d}वारिअस",
                "जग",
                "जोडियाक",
                "पकाउन\u{947} कार\u{94d}य",
                "प\u{947}य",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("amfora"),
            keywords: &[
                "amfora",
                "drinken",
                "koken",
                "kruik",
                "sterrenbeeld",
                "waterman",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("amfora"),
            keywords: &[
                "amfora",
                "drikke",
                "krukke",
                "matlaging",
                "stjernebilete",
                "stjerneteikn",
                "vassmannen",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଆମ\u{b4d}ଫୋର\u{b3e}"),
            keywords: &[
                "ଆମ\u{b4d}ଫୋର\u{b3e}",
                "କ\u{b41}ମ\u{b4d}ଭର\u{b3e}ଶ\u{b3f}",
                "ପ\u{b3e}ଣ\u{b3f} ରଖ\u{b3f}ବ\u{b3e} ଜଗ\u{b4d}\u{200c}",
                "ର\u{b3e}ଶ\u{b3f}ଚକ\u{b4d}ର",
                "ରୋଷେଇ କର\u{b3f}ବ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲ\u{a70}ਬੀ ਸ\u{a41}ਰਾਹੀ"),
            keywords: &[
                "ਔਜ\u{a3c}\u{a3c}ਾਰ",
                "ਕ\u{a41}\u{a70}ਭ",
                "ਖਾਣਾ ਬਣਾਉਣਾ",
                "ਜ\u{a71}ਗ",
                "ਪੀਣਾ",
                "ਰਾਸ\u{a3c}ੀ ਚ\u{a71}ਕਰ",
                "ਲ\u{a70}ਬੀ ਸ\u{a41}ਰਾਹੀ",
                "ਸ\u{a41}ਰਾਹੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("دلو"),
            keywords: &[
                "اوزار",
                "برج دلو",
                "ب\u{64f}رج",
                "جگ",
                "دلو",
                "شربت",
                "کھانا-پکانا",
                "ہتھیار",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ámfora"),
            keywords: &[
                "Akweriọs",
                "Amfóra: Óldín Taím Grík Ọ Rómán Jaa Wé Gẹ\u{301}t Tú Hand",
                "Drink",
                "Jọg",
                "To Kuk",
                "Zódiak",
                "Ámfora",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("amfora"),
            keywords: &[
                "amfora", "dzban", "puchar", "stągiew", "waza", "wodnik", "zodiak",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("امفورا"),
            keywords: &["امفورا", "امفورا، ايکويريس، پخلی، څکل، جګ، مرغومی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("ânfora"),
            keywords: &["ornamento chinês", "vaso", "vaso chinês", "ânfora"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("ânfora"),
            keywords: &["beber", "jarro", "líquidos", "utensílio", "ânfora"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("anfora"),
            keywords: &[
                "Acuario",
                "anfora",
                "jarra",
                "upyana",
                "waykʼusqa",
                "zodiaco",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("amforă"),
            keywords: &["Vărsător", "amforă", "băut", "gătit", "ulcior", "zodiac"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-439"),
            keywords: &["E10-439"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("амфора"),
            keywords: &["амфора", "кувшин", "сосуд"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("urwabya"),
            keywords: &[
                "Akwariyusi",
                "guteka",
                "igikoresho",
                "ijage",
                "intwaro",
                "kunywa",
                "urwabya",
                "zodiyake",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("صراحي"),
            keywords: &["دلو، پچائڻ، مشروب، جگ، اوزار، هٿيار، برج", "صراحي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඇම\u{dca}ෆෝර\u{dcf}"),
            keywords: &[
                "ඇම\u{dca}ෆෝර\u{dcf}",
                "ක\u{dd4}ම\u{dca}භ ර\u{dcf}ශ\u{dd2}ය",
                "ජෝග\u{dd4}ව",
                "ප\u{dcf}නය ක\u{dd2}ර\u{dd3}ම",
                "ප\u{dd2}ස\u{dd3}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("amfora"),
            keywords: &["amfora", "krčah", "nádoba", "nápoj", "varenie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("amfora"),
            keywords: &[
                "amfora", "kuhanje", "orodje", "orožje", "pijača", "vodnar", "vrč", "zodiak",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("jeeg dheer labo sidda leh"),
            keywords: &["jeeg", "jeeg dheer labo sidda leh", "karinta", "khamri"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("amforë"),
            keywords: &["amforë", "armë", "ujori", "vegël", "zodiak"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("амфора"),
            keywords: &[
                "aлaтка",
                "амфора",
                "водолија",
                "зoдиjaк",
                "крчаг",
                "кувaњe",
                "пићe",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("amfora"),
            keywords: &[
                "alatka", "amfora", "krčag", "kuvanje", "piće", "vodolija", "zodijak",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("amfora"),
            keywords: &["amfora", "kruka", "krus"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("jungu"),
            keywords: &[
                "birika", "jungu", "kunywa", "kupika", "ndoo", "silaha", "zana", "zodiaki",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கும\u{bcd}பம\u{bcd}"),
            keywords: &[
                "கும\u{bcd}ப ர\u{bbe}சி",
                "கும\u{bcd}பம\u{bcd}",
                "ஜ\u{bbe}டி",
                "ப\u{bbe}னம\u{bcd}",
                "வ\u{bc0}ட\u{bcd}டு அலங\u{bcd}க\u{bbe}ர பொருள\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c40}స\u{c3e}"),
            keywords: &["కుంభం", "ప\u{c3e}న\u{c40}యం", "వంట", "స\u{c40}స\u{c3e}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("амфора"),
            keywords: &[
                "Далв",
                "амфора",
                "асбоб",
                "бурҷи дувоздаҳгона",
                "нӯшидан",
                "пухта истода",
                "силоҳ",
                "қадаҳи дастадор",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("โถโบราณ"),
            keywords: &[
                "จ\u{e31}กรราศ\u{e35}",
                "ราศ\u{e35}ก\u{e38}มภ\u{e4c}",
                "โถ",
                "โถโบราณ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("küýze"),
            keywords: &["Gowa", "bişirmek", "grafin", "içgi", "küýze", "täleýnama"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tukuʻanga uaine"),
            keywords: &["tukuʻanga uaine"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("amfora"),
            keywords: &["alet", "amfora", "antika", "içecek", "kap", "silah"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("لوڭقا"),
            keywords: &[
                "ئىچىملىك",
                "تاماق ئېتىش",
                "سايمان",
                "سوغلا",
                "قاچا",
                "قورال",
                "لوڭقا",
                "مۆچەل",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("амфора"),
            keywords: &["амфора", "водолій", "глек", "зодіак", "кулінарія", "пити"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ایمفورا"),
            keywords: &[
                "اوزار",
                "ایمفورا",
                "ب\u{64f}رج د\u{650}لو",
                "جگ",
                "پانی",
                "ہتھیار",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ko‘za"),
            keywords: &[
                "Qovgʻa",
                "burj",
                "ichimlik",
                "koʻza",
                "ko‘za",
                "ovqat pishirish",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("vò hai quai"),
            keywords: &[
                "Bảo Bình",
                "bình",
                "hoàng đạo",
                "nấu ăn",
                "uống",
                "vò hai quai",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("àmfoor"),
            keywords: &[
                "Aquarius",
                "jug",
                "jumtukaay",
                "naan",
                "ngànnaay",
                "sojak",
                "togg",
                "àmfoor",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-amphora"),
            keywords: &[
                "i-Aquarius",
                "i-amphora",
                "i-zodiac",
                "ijagi",
                "isiselo",
                "isixhobo",
                "ukupheka",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Amphora"),
            keywords: &[
                "Amphora",
                "Aquarius",
                "dídáná",
                "ife omi",
                "irinṣẹ\u{301}",
                "irinṣẹ\u{301} ìjagun",
                "ohun mímu",
                "àmi oṣù ìbí",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("雙耳瓶"),
            keywords: &["星座", "樽", "水瓶座", "雙耳瓶", "飲"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("双耳瓶"),
            keywords: &[
                "双耳瓶",
                "工具",
                "星座",
                "樽",
                "武器",
                "水瓶座",
                "煮食",
                "饮",
            ],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("双耳瓶"),
            keywords: &["双耳瓶", "壶", "罐"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("陶罐"),
            keywords: &["容器", "陶罐"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("雙耳瓶"),
            keywords: &["瓶子", "罐子", "花瓶", "雙耳瓶"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-amfrora"),
            keywords: &[
                "aquarius",
                "i-amfrora",
                "inkanyezi",
                "isikhali",
                "isiphuzo",
                "ithuluzi",
                "ujeke",
                "ukupheka",
            ],
        },
    ],
};
