#[doc = "🏁"]
pub const CHEQUERED_FLAG: crate::Emoji = crate::Emoji {
    glyph: "🏁",
    codepoint: "1F3C1",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "chequered flag",
    group: "Flags",
    subgroup: "flag",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("ruitvlag"),
            keywords: &["geruit", "ruitvlag", "vlag", "wedren"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የዳማ ሰሌዳ መሰል ባንዴራ"),
            keywords: &["እሽቅድድም", "የዳማ ሰሌዳ መሰል ባንዴራ", "ዳማ", "ዳማ ሰሌዳ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("علم مربعات"),
            keywords: &["رياضة", "سباق", "علم", "علم مربعات"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক’ল\u{9be}-বগ\u{9be} পত\u{9be}ক\u{9be}"),
            keywords: &[
                "ক’ল\u{9be}-বগ\u{9be}",
                "ক’ল\u{9be}-বগ\u{9be} পত\u{9be}ক\u{9be}",
                "ৰেচিং",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("damalı bayraq"),
            keywords: &["dama-dama", "damalı", "damalı bayraq", "yarış"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("клятчасты сцяг"),
            keywords: &[
                "Формула адзін",
                "Формула-1",
                "гонкі",
                "клятчасты сцяг",
                "у клетку",
                "фініш",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Кариран флаг"),
            keywords: &["Кариран флаг", "кариран", "състезание"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ছক ক\u{9be}ট\u{9be} পত\u{9be}ক\u{9be}"),
            keywords: &[
                "ছক ক\u{9be}ট\u{9be} পত\u{9be}ক\u{9be}",
                "ছকক\u{9be}ট\u{9be}",
                "রেসিং",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("karirana zastavica"),
            keywords: &["karirana zastavica", "karirano", "utrke", "zastavica"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bandera de quadres"),
            keywords: &[
                "automobilisme",
                "bandera",
                "bandera de quadres",
                "curses",
                "motor",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏧᏅᏣᏘ ᎦᏓᏘ"),
            keywords: &["ᎤᏅᏣᏘ", "ᏓᏙᎩᏯᏍᎬᎢ", "ᏧᏅᏣᏘ", "ᏧᏅᏣᏘ ᎦᏓᏘ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("šachovnicová vlajka"),
            keywords: &[
                "kostkovaná",
                "praporek",
                "signální",
                "vlajka",
                "závod",
                "šachovnicová vlajka",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("baner frith"),
            keywords: &["baner frith", "frith", "rasio", "sgwariog"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ternet flag"),
            keywords: &["motorsport", "ternet", "ternet flag"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Zielflagge"),
            keywords: &["Rennen", "Sport", "Zielflagge", "karierte Flagge"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καρό σημαία"),
            keywords: &[
                "αγώνας",
                "αγώνες",
                "καρό",
                "καρό σημαία",
                "σημαία τερματισμού",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("chequered flag"),
            keywords: &["checkered", "chequered", "chequered flag", "racing"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("checkered flag"),
            keywords: &[
                "checkered",
                "checkered flag",
                "chequered",
                "chequered flag",
                "racing",
            ],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bandera de cuadros"),
            keywords: &[
                "bandera",
                "bandera de cuadros",
                "carreras",
                "cuadros",
                "deporte",
                "motor",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "bandera",
                "bandera de cuadros",
                "bandera de llegada",
                "carrera",
                "deporte",
                "meta",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "bandera",
                "bandera de cuadros",
                "blanco",
                "carrera",
                "deporte",
                "negro",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("ruudulipp"),
            keywords: &["lipp", "ruuduline", "ruudulipp", "võidusõit"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bandera laukiduna"),
            keywords: &[
                "bandera laukiduna",
                "karratu",
                "lasterketa",
                "lauki",
                "laukidun",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پرچم شطرنجی"),
            keywords: &["شطرنجی", "مسابقه", "پرچم شطرنجی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ruutulippu"),
            keywords: &["kilpa-ajot", "ruutukuvio", "ruutulippu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("checkered na bandila"),
            keywords: &["bandila", "checkered", "checkered na bandila", "karera"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("puntut flagg"),
            keywords: &["flagg", "puntut", "rútut"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("drapeau à damier"),
            keywords: &["drapeau", "drapeau à damier"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bratach chríche"),
            keywords: &["bratach", "bratach chríche", "rásaíocht", "spórt"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bratach bhreacte"),
            keywords: &["bratach bhreacte", "breac", "breacte", "rèis", "rèiseadh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("bandeira de cadros"),
            keywords: &[
                "bandeira",
                "bandeira de cadros",
                "carreiras",
                "de cadros",
                "fin",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચોકડીવાળો ધ\u{acd}વજ"),
            keywords: &["ખ\u{ac7}લ ક\u{ac2}દ", "ચોકડીવાળો", "ધ\u{acd}વજ", "હરીફાઈ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("tuta mai alamar murabba’i"),
            keywords: &[
                "mai alamar murabba’a",
                "mai alamar murabba’i tsere",
                "tuta mai alamar murabba’i",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("דגל מירוצים"),
            keywords: &["דגל", "התחלה", "מירוץ", "מירוצים", "סיום"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चौखान\u{947} वाला झ\u{902}डा"),
            keywords: &[
                "चौखाना",
                "चौखान\u{947} वाला झ\u{902}डा",
                "चौखान\u{947} वाला ध\u{94d}वज",
                "र\u{947}सि\u{902}ग",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zastava s crno-bijelom šahovnicom"),
            keywords: &["utrka", "zastava s crno-bijelom šahovnicom", "šahovnica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kockás zászló"),
            keywords: &["autóverseny", "kockás", "kockás zászló", "versenyzés"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("վանդակավոր դրոշ"),
            keywords: &["մրցարշավ", "վանդակավոր", "վանդակավոր դրոշ"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("bandiera a quadros"),
            keywords: &[
                "bandiera",
                "bandiera a quadros",
                "currer",
                "cursa",
                "quadrettos",
                "quadros",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bendera kotak-kotak"),
            keywords: &[
                "balapan",
                "bendera kotak-kotak",
                "kotak-kotak",
                "petak-petak",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọkọlọtọ nwere eserese"),
            keywords: &[
                "ahụ nwere eserese",
                "ihe nwere eserese",
                "na-agba ọsọ",
                "ọkọlọtọ nwere eserese",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("rásflagg"),
            keywords: &["flagg", "kappakstur", "rásflagg", "íþróttir"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("bandiera a scacchi"),
            keywords: &["bandiera a scacchi", "podio"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("チェッカーフラッグ"),
            keywords: &[
                "スポーツ",
                "チェッカーフラッグ",
                "フラグ",
                "フラッグ",
                "レース",
                "旗",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("gendera kothak-kothak"),
            keywords: &[
                "balapan",
                "gendera balapan",
                "gendera kothak-kothak",
                "kothak-kothak",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("უჯრედებიანი დროშა"),
            keywords: &["დროშა", "რბოლა", "უჯრედებიანი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("anay s texxamin"),
            keywords: &["anay s texxamin"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("торлы жалауша"),
            keywords: &["жарыс", "торлы", "торлы жалауша"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ternet flag"),
            keywords: &["flag", "motorsport", "ternet flag"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ទង\u{17cb}សម\u{17d2}រាប\u{17cb}ការប\u{17d2}រណា\u{17c6}ង"),
            keywords: &[
                "ទង\u{17cb}",
                "ទង\u{17cb}សម\u{17d2}រាប\u{17cb}ការប\u{17d2}រណា\u{17c6}ង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಚ\u{ccc}ಕಚ\u{ccc}ಕದ ಧ\u{ccd}ವಜ"),
            keywords: &[
                "ಕ\u{ccd}ರೀಡಾ",
                "ಚ\u{ccc}ಕಚ\u{ccc}ಕದ ಧ\u{ccd}ವಜ",
                "ಧ\u{ccd}ವಜ",
                "ರಂಗುರಂಗ\u{cbf}ನ",
                "ರೇಸ\u{cbf}ಂಗ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("격자 무늬 깃발"),
            keywords: &[
                "격자 무늬",
                "격자 무늬 깃발",
                "결승선 깃발",
                "레이싱",
                "스포츠",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("चौकटी\u{902}चो बावटो"),
            keywords: &[
                "चौकटी\u{902}चो",
                "चौकटी\u{902}चो फ\u{94d}ल\u{945}ग",
                "चौकटी\u{902}चो बावटो",
                "चौकटीचो",
                "स\u{94d}पर\u{94d}धा",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("шахмат түсүндөгү желек"),
            keywords: &["жарыш", "шахмат тартибинде", "шахмат түсүндөгү желек"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("karéierte Fändel"),
            keywords: &["Course", "karéiert", "karéierte Fändel"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ທ\u{eb8}ງລາຍດຳຂາວຕາຕະໂລ\u{ec8}"),
            keywords: &[
                "ຕາຕະໂລ\u{ec8}",
                "ທ\u{eb8}ງ",
                "ທ\u{eb8}ງລາຍດຳຂາວຕາຕະໂລ\u{ec8}",
                "ລາຍດຳຂາວ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vėliava langeliais"),
            keywords: &["langeliai", "lenktynės", "vėliava langeliais"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("finiša karogs"),
            keywords: &["finiša karogs", "melnbalts", "rūtots", "sacīkstes"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kara pātikitiki"),
            keywords: &["kara pātikitiki", "pātikitiki", "tauwhāinga motokā"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("шаховско знаме"),
            keywords: &["знаме", "тркање", "шаховско знаме"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ചത\u{d41}രങ\u{d4d}ങള\u{d41}ള\u{d4d}ള പത\u{d3e}ക"),
            keywords: &[
                "ചത\u{d41}രങ\u{d4d}ങള\u{d41}ള\u{d4d}ള പത\u{d3e}ക",
                "പത\u{d3e}ക",
                "സ\u{d4d}പോർട\u{d4d}സ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("алаг туг"),
            keywords: &["алаг", "туг", "уралдаан"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चोकड\u{94d}\u{200d}याचा ध\u{94d}वज"),
            keywords: &[
                "चोकड\u{94d}याचा",
                "चोकड\u{94d}\u{200d}याचा ध\u{94d}वज",
                "चौकड\u{94d}याचा",
                "र\u{947}सि\u{902}ग",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bendera pelepas"),
            keywords: &["bendera pelepas", "bercorak dam", "berpetak", "lumba"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("bandiera bil-kaxxi"),
            keywords: &["bandiera bil-kaxxi", "bil-kaxxi", "tlielaq"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အက\u{103d}က\u{103a}ဆင\u{103a} အလ\u{1036}"),
            keywords: &[
                "ပြ\u{102d}\u{102f}င\u{103a}ပ\u{103d}\u{1032}",
                "အက\u{103d}က\u{103a}ဆင\u{103a}",
                "အလ\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("rutete flagg"),
            keywords: &[
                "formel 1",
                "motorsport",
                "mål",
                "racingflagg",
                "rutete flagg",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("च\u{947}करवाला झण\u{94d}डा"),
            keywords: &[
                "च\u{947}करवाला",
                "च\u{947}करवाला झण\u{94d}डा",
                "च\u{947}कर\u{94d}ड",
                "दौ\u{902}ड",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("geblokte vlag"),
            keywords: &["geblokt", "geblokte vlag", "racen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("rutete flagg"),
            keywords: &[
                "formel 1",
                "motorsport",
                "mål",
                "racingflagg",
                "rutete flagg",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଛକ\u{b3f}କଟ\u{b3e} ଢ\u{b3e}ଞ\u{b4d}ଚ\u{b3e}ରେ ଅଙ\u{b4d}କ\u{b3f}ତ ପତ\u{b3e}କ\u{b3e}",
            ),
            keywords: &[
                "ଚେକର\u{b4d}\u{200c}ଯ\u{b41}କ\u{b4d}ତ",
                "ଛକ\u{b3f}କଟ\u{b3e} ଢ\u{b3e}ଞ\u{b4d}ଚ\u{b3e}ରେ ଅଙ\u{b4d}କ\u{b3f}ତ",
                "ଛକ\u{b3f}କଟ\u{b3e} ଢ\u{b3e}ଞ\u{b4d}ଚ\u{b3e}ରେ ଅଙ\u{b4d}କ\u{b3f}ତ ପତ\u{b3e}କ\u{b3e}",
                "ରେସ\u{b3f}ଂ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਡ\u{a71}ਬੀਦਾਰ ਝ\u{a70}ਡਾ"),
            keywords: &[
                "ਖ\u{a47}ਡ",
                "ਝ\u{a70}ਡਾ",
                "ਡ\u{a71}ਬੀਦਾਰ",
                "ਰ\u{a47}ਸਿ\u{a70}ਗ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بساطی جھنڈا"),
            keywords: &["بساطی جھنڈا", "دوڑ", "رنگ برنگی زندگی", "شطرنج دا تختہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Flag Wé Dẹm Drọ\u{301} Skwea Skwea Ọn Tọp"),
            keywords: &[
                "Chẹ\u{301}kad",
                "Flag",
                "Flag Wé Dẹm Drọ\u{301} Skwea Skwea Ọn Tọp",
                "Res",
                "Rọn",
                "Skwea Skwea",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("flaga w szachownicę"),
            keywords: &["flaga w kratkę", "flaga w szachownicę", "wyścigi"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("رنګداره بېرغ"),
            keywords: &["داغدار", "رنګدار", "رنګداره بېرغ", "ريسنګ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bandeira quadriculada"),
            keywords: &["bandeira", "corrida", "esporte", "quadriculada"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("bandeira axadrezada"),
            keywords: &["axadrezado", "bandeira axadrezada", "corrida"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("metapaq whipala"),
            keywords: &["carrera", "meta", "metapaq whipala", "tawak’uchuwan"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("steag cu pătrățele"),
            keywords: &["curse", "steag", "steag cu pătrățele", "steag în carouri"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-385"),
            keywords: &["E10-385"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("клетчатый флаг"),
            keywords: &[
                "в клетку",
                "гонка",
                "гонки",
                "клетчатый флаг",
                "формула 1",
                "черно-белый",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibendera rigizwe n’udukaro"),
            keywords: &[
                "cy’amenyo",
                "cy’amenyo nk’ay’urukero",
                "gusiganwa",
                "ibendera rigizwe n’udukaro",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("چيڪر جهنڊو"),
            keywords: &["چيڪر جهنڊو", "چيڪر، ريسنگ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කොට\u{dd4} කොඩ\u{dd2}ය"),
            keywords: &[
                "කොට\u{dd4}",
                "කොට\u{dd4} කොඩ\u{dd2}ය",
                "කොට\u{dd4} සහ\u{dd2}ත",
                "රේස\u{dd2}ං",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kockovaná zástava"),
            keywords: &[
                "kockovaná",
                "kockovaná zástava",
                "preteky",
                "vlajka",
                "šachovnicová",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kockasta zastava"),
            keywords: &["dirkanje", "kockasta zastava", "kockasto", "zastava"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("calanka la saxay"),
            keywords: &["calanka la saxay", "hubin", "la saxay", "tartanka"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("flamur me katrorë"),
            keywords: &["flamur me katrorë", "garim", "garë", "me katrorë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("застава за крај трке"),
            keywords: &[
                "застава за крај трке",
                "кариран",
                "карирана застава",
                "трка",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["застава за крај трке"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("zastava za kraj trke"),
            keywords: &[
                "kariran",
                "karirana zastava",
                "trka",
                "zastava za kraj trke",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["zastava za kraj trke"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("schackrutig flagga"),
            keywords: &["flagga", "racing", "schackrutig"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("bendera yenye mirabaraba"),
            keywords: &[
                "bendera yenye mirabaraba",
                "mashindano ya mbio",
                "mirabamiraba",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பந\u{bcd}தயக\u{bcd} கொடி"),
            keywords: &[
                "பந\u{bcd}தயக\u{bcd} கொடி",
                "ரேஸ\u{bcd}",
                "ரேஸ\u{bcd} கொடி",
                "விளைய\u{bbe}ட\u{bcd}டு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("గళ\u{c4d}ల పత\u{c3e}కం"),
            keywords: &[
                "క\u{c4d}ర\u{c40}డ",
                "గళ\u{c4d}ల పత\u{c3e}కం",
                "జ\u{c46}ండ\u{c3e}",
                "ర\u{c47}సులు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("байрақи чорхона"),
            keywords: &["байрақи чорхона", "катакчадор", "пойга", "чорхона"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ธงตราหมากร\u{e38}ก"),
            keywords: &[
                "ธงตราหมากร\u{e38}ก",
                "ธงหมากร\u{e38}ก",
                "ธงแข\u{e48}งรถ",
                "แข\u{e48}งรถ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ala baýdak"),
            keywords: &["ala", "ala baýdak", "ýaryş"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fuka lova"),
            keywords: &["fuka", "lova"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("damalı bayrak"),
            keywords: &["bayrak", "damalı", "spor", "yarış"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كاتەكچە بايراق"),
            keywords: &["كاتەكچە", "كاتەكچە بايراق", "مۇسابىقە", "چاقماقلىق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("картатий прапор"),
            keywords: &[
                "картатий",
                "картатий прапор",
                "клічастий",
                "прапор для перегонів",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("خانوں والا جھنڈا"),
            keywords: &["جھنڈا", "خانوں والا جھنڈا", "ریسنگ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("katak-katak bayroq"),
            keywords: &["katak-katak", "katak-katak bayroq", "musobaqa", "poyga"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cờ ô vuông"),
            keywords: &["ca rô", "cuộc đua", "cờ ô vuông"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("raaya bu am karo damiye"),
            keywords: &["karo damiye", "kursu", "raaya bu am karo damiye"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iflegi etsheke"),
            keywords: &["etsheke", "iflegi etsheke", "umdyarho"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("asia péńpé onílà"),
            keywords: &["asia péńpé onílà", "eré ìje", "ìsàmìsí aláwọ\u{300} méjì"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("方格旗"),
            keywords: &["方格旗", "格子", "賽跑"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("方格旗"),
            keywords: &["方格旗", "格子", "赛跑"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("终点旗"),
            keywords: &["格子旗", "终点旗"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("終點旗"),
            keywords: &["格子旗", "終點旗"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ifulegi eliyisikotshi"),
            keywords: &["ifulegi eliyisikotshi", "isikotshi", "ukuqhudelana"],
        },
    ],
};
#[doc = "🚩"]
pub const TRIANGULAR_FLAG: crate::Emoji = crate::Emoji {
    glyph: "🚩",
    codepoint: "1F6A9",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "triangular flag",
    group: "Flags",
    subgroup: "flag",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("driehoekige vlag"),
            keywords: &["driehoek", "driehoekige vlag", "rooi", "vlag"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የፖስታ ምልክት ባንዲራ"),
            keywords: &["የፖስታ ምልክት ባንዲራ", "ፖስታ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("علم مثلث"),
            keywords: &[
                "علم",
                "علم مثلث",
                "علم معلومات موقع",
                "علم موقع مثلث",
                "موقع",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ত\u{9cd}ৰিভ\u{9c1}জ\u{9be}ক\u{9be}ৰ পত\u{9be}ক\u{9be}"),
            keywords: &[
                "খ\u{9c1}\u{981}টি",
                "ত\u{9cd}ৰিভ\u{9c1}জ\u{9be}ক\u{9be}ৰ পত\u{9be}ক\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("üçbucaq bayraq"),
            keywords: &["poçt", "üçbucaq bayraq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("трохвугольны сцяг"),
            keywords: &["гольф", "лунка", "поле", "трохвугольны сцяг"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Триъгълно знаме"),
            keywords: &["Триъгълно знаме", "флагщок"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ত\u{9cd}রিভ\u{9c1}জ\u{9be}ক\u{9c3}তি পত\u{9be}ক\u{9be}"),
            keywords: &[
                "ত\u{9cd}রিভ\u{9c1}জ\u{9be}ক\u{9c3}তি পত\u{9be}ক\u{9be}",
                "পোস\u{9cd}ট",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("banniel tricʼhornek"),
            keywords: &["banniel", "banniel tricʼhornek"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("trokutasta zastava"),
            keywords: &["pošta", "trokutasta zastava"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bandera triangular"),
            keywords: &["bandera", "bandera triangular", "banderí"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏦᎢ ᏧᏅᏏᏓ ᎦᏗ"),
            keywords: &["ᏕᎦᏃᏣᎵᏍᎬ", "ᏦᎢ ᏧᏅᏏᏓ ᎦᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("trojúhelníková vlajka"),
            keywords: &["praporek", "sloupek", "trojúhelníková vlajka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("baner drionglog"),
            keywords: &["baner drionglog", "post"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("trekantet flag"),
            keywords: &["post", "trekantet flag"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Wimpel"),
            keywords: &["Dreiecksflagge", "Flagge", "Wimpel", "rot"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τριγωνική σημαία"),
            keywords: &["αλληλογραφία", "τριγωνική σημαία"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("triangular flag"),
            keywords: &["post", "triangular flag"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bandera triangular"),
            keywords: &[
                "bandera",
                "bandera de localización triangular",
                "bandera informativa de localización",
                "bandera triangular",
                "localización",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "bandera",
                "bandera de ubicación",
                "banderín",
                "triangular",
                "ubicación",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("banderín triangular"),
            keywords: &["banderín triangular"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kolmnurkne lipp"),
            keywords: &["kolmnurk", "kolmnurkne lipp", "lipp"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("triangelu-itxurako bandera"),
            keywords: &["posta", "triangelu-itxurako bandera"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پرچم مثلثی"),
            keywords: &["سه\u{200c}گوش", "لچکی", "پرچم", "پرچم مثلثی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kolmiolippu"),
            keywords: &["kolmiolippu", "lippu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tatsulok na bandila"),
            keywords: &[
                "bandila",
                "himpilan",
                "kampo",
                "tatsulok",
                "tatsulok na bandila",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("tríkanta flagg"),
            keywords: &["flagg", "tríkanta"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("drapeau triangulaire"),
            keywords: &["drapeau", "drapeau triangulaire", "fanion"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bratach thriantánach"),
            keywords: &["bratach chuaille", "bratach thriantánach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bratach thriantanach"),
            keywords: &["bratach thriantanach", "post"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("bandeira triangular"),
            keywords: &["bandeira", "bandeirola", "triangular"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ત\u{acd}રિકોણાકાર ધ\u{acd}વજ"),
            keywords: &[
                "ત\u{acd}રિકોણ ધ\u{acd}વજ",
                "ત\u{acd}રિકોણ સ\u{acd}થાન ધ\u{acd}વજ",
                "ત\u{acd}રિકોણાકાર ધ\u{acd}વજ",
                "ધ\u{acd}વજ",
                "સ\u{acd}થાન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("tuta na alwatika"),
            keywords: &["turke", "tuta na alwatika"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("דגל משולש אדום"),
            keywords: &["אדום", "דגל", "משולש"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("तिकोना झ\u{902}डा"),
            keywords: &["झ\u{902}डा", "तिकोना झ\u{902}डा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("trokutasta zastava"),
            keywords: &["pošta", "trokutasta zastava"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("háromszög alakú zászló"),
            keywords: &["háromszög alakú zászló", "zászlórúd"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("եռանկյունի դրոշ"),
            keywords: &["եռանկյունի դրոշ", "փոստ"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("bandiera triangular"),
            keywords: &["bandiera triangular", "palo"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bendera segitiga"),
            keywords: &["bendera segitiga", "tiang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọkọlọtọ nwere akomgbà-atọ"),
            keywords: &["nzipụ", "ọkọlọtọ nwere akomgbà-atọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("flagg"),
            keywords: &["flagg", "fáni", "staðsetningarmerki", "veifa"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("bandierina rossa"),
            keywords: &["bandierina rossa", "bandierina rossa triangolare"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("三角の旗"),
            keywords: &["ゴルフ", "スポーツ", "フラグ", "フラッグ", "三角の旗", "旗"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("gendera segi telu"),
            keywords: &["gendera segi telu", "tenger"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სამკუთხა დროშა"),
            keywords: &["სამკუთხა დროშა", "ფოსტა"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("anay azeggaɣ"),
            keywords: &["anay azeggaɣ"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("үшбұрышты жалау"),
            keywords: &["жіберу", "үшбұрышты жалау"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("flag"),
            keywords: &["flag", "trekantet rødt flag"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ទង\u{17cb}ជាត\u{17b7}រាងត\u{17d2}រ\u{17b8}កោន"),
            keywords: &[
                "ទង\u{17cb}ជាត\u{17b7}",
                "ទង\u{17cb}ជាត\u{17b7}រាងត\u{17d2}រ\u{17b8}កោន",
                "រាងត\u{17d2}រ\u{17b8}កោន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ತ\u{ccd}ರ\u{cbf}ಕೋನ ಧ\u{ccd}ವಜ"),
            keywords: &[
                "ತ\u{ccd}ರ\u{cbf}ಕೋನ ಧ\u{ccd}ವಜ",
                "ತ\u{ccd}ರ\u{cbf}ಕೋನ ಫ\u{ccd}ಲ\u{ccd}ಯಾಗ\u{ccd}",
                "ತ\u{ccd}ರ\u{cbf}ಕೋನ ಸ\u{ccd}ಥಳ ಫ\u{ccd}ಲ\u{ccd}ಯಾಗ\u{ccd}",
                "ಫ\u{ccd}ಲ\u{ccd}ಯಾಗ\u{ccd}",
                "ಸ\u{ccd}ಥಳ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("세모 깃발"),
            keywords: &["깃발", "세모 깃발", "위치 표시", "위치 표시 깃발"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("त\u{94d}रिकोणी बावटो"),
            keywords: &["त\u{94d}रिकोणी बावटो", "पोस\u{94d}ट"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("үч бурчтук желек"),
            keywords: &["пост", "үч бурчтук желек"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("dräieckege Fändel"),
            keywords: &["Post", "dräieckege Fändel"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ທ\u{eb8}ງສາມຫ\u{ebc}\u{ec8}ຽມ"),
            keywords: &[
                "ທ\u{eb8}ງ",
                "ທ\u{eb8}ງສາມຫ\u{ebc}\u{ec8}ຽມ",
                "ສາມຫ\u{ebc}\u{ec8}ຽມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("trikampė vėliava"),
            keywords: &["postas", "trikampė vėliava"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("trīsstūrveida karogs"),
            keywords: &["karogs", "trīsstūrveida karogs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kara tapatoru"),
            keywords: &["kara tapatoru", "pou"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("триаголно знаме"),
            keywords: &["голф", "знаме", "триаголно знаме"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ത\u{d4d}രികോണ പത\u{d3e}ക"),
            keywords: &[
                "ത\u{d4d}രികോണ പത\u{d3e}ക",
                "പത\u{d3e}ക",
                "പോസ\u{d4d}റ\u{d4d}റിൽ ത\u{d4d}രികോണ പത\u{d3e}ക",
                "ലൊക\u{d4d}കേഷൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гурвалжин туг"),
            keywords: &["гурвалжин", "туг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("त\u{94d}रिकोणी ध\u{94d}वज"),
            keywords: &["त\u{94d}रिकोणी ध\u{94d}वज", "स\u{94d}थान"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bendera tiga segi"),
            keywords: &["bendera tiga segi", "tiang"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("bandiera trijangolari"),
            keywords: &["bandiera trijangolari", "posta"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တြ\u{102d}ဂ\u{1036}ပ\u{102f}\u{1036} အလ\u{1036}"),
            keywords: &[
                "စာတ\u{102d}\u{102f}က\u{103a}",
                "တြ\u{102d}ဂ\u{1036}ပ\u{102f}\u{1036} အလ\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("vimpel"),
            keywords: &["golf", "posisjon", "trekantet", "vimpel"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("तीनक\u{941}न\u{947} झण\u{94d}डा"),
            keywords: &["तीनक\u{941}न\u{947} झण\u{94d}डा", "पोस\u{94d}ट"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("driehoekige vlag"),
            keywords: &["driehoekige vlag", "locatie"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("vimpel"),
            keywords: &["golf", "posisjon", "trekanta", "vimpel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ତ\u{b4d}ର\u{b3f}ଭ\u{b41}ଜ\u{b3e}କ\u{b3e}ର ପତ\u{b3e}କ\u{b3e}"),
            keywords: &[
                "ତ\u{b4d}ର\u{b3f}ଭ\u{b41}ଜ\u{b3e}କ\u{b3e}ର ପତ\u{b3e}କ\u{b3e}",
                "ପୋଷ\u{b4d}ଟ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਤਿਕ\u{a4b}\u{a4b}ਣਾ ਝ\u{a70}ਡਾ"),
            keywords: &[
                "ਝ\u{a70}ਡਾ",
                "ਤਿਕ\u{a4b}ਨਾ ਝ\u{a70}ਡਾ",
                "ਤਿਕ\u{a4b}ਨੀ ਸਥਿਤੀ ਝ\u{a70}ਡਾ",
                "ਤਿਕ\u{a4b}\u{a4b}ਣਾ ਝ\u{a70}ਡਾ",
                "ਸਥਿਤੀ",
                "ਸਥਿਤੀ ਜਾਣਕਾਰੀ ਝ\u{a70}ਡਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("تکونی جھنڈا"),
            keywords: &["تکونی جھنڈا", "فوجی چوکی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tráyángul Flag"),
            keywords: &["Post", "Tráyángul Flag"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("flaga trójkątna"),
            keywords: &[
                "chorągiewka",
                "czerwona flaga",
                "flaga",
                "flaga trójkątna",
                "słupek",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("درې کنجه بيراغ"),
            keywords: &["درې کنجه بيراغ", "درې کنجه بېرغ", "ستنه،"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bandeira triangular"),
            keywords: &["bandeira triangular", "poste"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["bandeira triangular", "golfe"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("kimsa kʼuchuwan wiphala"),
            keywords: &["chaski", "kimsa kʼuchuwan wiphala"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("steag triunghiular"),
            keywords: &["roșu", "steag", "steag triunghiular", "triunghi"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-957"),
            keywords: &["E10-957"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("треугольный флаг"),
            keywords: &["красный", "треугольный", "флаг"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibendera rya mpandeshatu"),
            keywords: &["ibendera rya mpandeshatu", "icyatangajwe"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٽڪنڊو جھنڊو"),
            keywords: &["ٽڪنڊو جھنڊو", "پوسٽ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ත\u{dca}\u{200d}ර\u{dd2}කෝණ\u{dcf}ක\u{dcf}ර කොඩ\u{dd2}ය"),
            keywords: &[
                "ත\u{dca}\u{200d}ර\u{dd2}කෝණ\u{dcf}ක\u{dcf}ර කොඩ\u{dd2}ය",
                "සැතප\u{dd4}ම\u{dca} කණ\u{dd4}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("trojuholníková zástava"),
            keywords: &["trojuholník", "trojuholníková zástava", "vlajka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("trikotna zastava"),
            keywords: &["trikotna zastava", "zastavica"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("calanka saddex-geesoodka"),
            keywords: &["boostada", "calanka saddex-geesoodka"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("flamur trekëndësh"),
            keywords: &["flamur trekëndësh", "postë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("троугласта застава"),
            keywords: &["пoштa", "троугласта застава"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("trouglasta zastava"),
            keywords: &["pošta", "trouglasta zastava"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("trekantig flagga"),
            keywords: &["flagga", "trekantig flagga"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("bendera yenye pembe"),
            keywords: &["bendera yenye pembe", "mlingoti"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("முக\u{bcd}கோண கொடி"),
            keywords: &[
                "கம\u{bcd}பத\u{bcd}தில\u{bcd} முக\u{bcd}கோண கொடி",
                "முக\u{bcd}கோண கொடி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("త\u{c4d}ర\u{c3f}భుజ\u{c3e}క\u{c3e}ర జ\u{c46}ండ\u{c3e}"),
            keywords: &[
                "త\u{c4d}ర\u{c3f}భుజ\u{c3e}క\u{c3e}ర జ\u{c46}ండ\u{c3e}",
                "ప\u{c4b}స\u{c4d}ట\u{c4d}\u{200c}ను త\u{c46}ల\u{c3f}యజ\u{c47}స\u{c47} త\u{c4d}ర\u{c3f}భుజ\u{c3e}క\u{c3e}ర జ\u{c46}ండ\u{c3e}",
                "ప\u{c4b}స\u{c4d}ట\u{c4d}\u{200c}ప\u{c48} త\u{c4d}ర\u{c3f}భుజ\u{c3e}క\u{c3e}ర జ\u{c46}ండ\u{c3e}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("байрақи секунҷа"),
            keywords: &["байрақи секунҷа", "сутун"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ธงป\u{e31}กตำแหน\u{e48}ง"),
            keywords: &[
                "ธง",
                "ธงป\u{e31}กตำแหน\u{e48}ง",
                "ธงสามเหล\u{e35}\u{e48}ยม",
                "ธงแดง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("üçburç baýdak"),
            keywords: &["taýajyk", "üçburç baýdak"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fuka tapatolu"),
            keywords: &["fuka", "tapatolu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("üçgen bayrak"),
            keywords: &[
                "işaret",
                "konum",
                "konum bilgisi işareti",
                "üçgen bayrak",
                "üçgen işaret",
                "üçgen konum işareti",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئۈچ بۇرجەك بايراق"),
            keywords: &["ئۈچ بۇرجەك بايراق", "خادا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("трикутний прапор"),
            keywords: &["трикутний прапор", "флагшток"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("تکونی جھنڈا"),
            keywords: &["تکون", "تکونی جھنڈا", "جھنڈا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("uchburchak bayroq"),
            keywords: &["post", "uchburchak bayroq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cờ tam giác"),
            keywords: &["cờ tam giác", "đánh dấu"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("raaya am jëmmu tri-yàngal"),
            keywords: &["post", "raaya am jëmmu tri-yàngal"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iflegi engunxantathu"),
            keywords: &["iflegi engunxantathu", "iposi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("asia onigun mẹta"),
            keywords: &["asia onigun mẹta", "ìfiránṣé\u{329}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("三角旗"),
            keywords: &["三角旗", "崗位"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("三角旗"),
            keywords: &["三角旗", "岗位"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("三角旗"),
            keywords: &[
                "三角旗",
                "升旗",
                "旗",
                "旗杆上的三角旗",
                "旗杆上的旗帜",
                "红色旗帜",
            ],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("三角旗"),
            keywords: &["三角旗"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ifulegi eliwunxantathu"),
            keywords: &["ifulegi eliwunxantathu", "posa"],
        },
    ],
};
#[doc = "🎌"]
pub const CROSSED_FLAGS: crate::Emoji = crate::Emoji {
    glyph: "🎌",
    codepoint: "1F38C",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "crossed flags",
    group: "Flags",
    subgroup: "flag",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gekruiste vlae"),
            keywords: &["gekruiste vlae", "japannees", "kruis", "viering", "vlag"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጥሙር ሰንደቅ ዓላማዎች"),
            keywords: &["መስቀል", "ክብረ በዓል", "የተጣመረ", "የጃፓን", "ጥሙር ሰንደቅ ዓላማዎች"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("علمان متقاطعان"),
            keywords: &[
                "أعلام",
                "أعلام متقاطعة",
                "أعلام متقاطعة لليابان",
                "احتفال",
                "علمان متقاطعان",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কট\u{9be}-কটিকৈ ৰখ\u{9be} দ\u{9c1}খন পত\u{9be}ক\u{9be}"),
            keywords: &[
                "উদয\u{9be}পন",
                "কট\u{9be}-কটি",
                "কট\u{9be}-কটিকৈ ৰখ\u{9be}",
                "কট\u{9be}-কটিকৈ ৰখ\u{9be} দ\u{9c1}খন পত\u{9be}ক\u{9be}",
                "জ\u{9be}প\u{9be}নী",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kəsişən bayraqlar"),
            keywords: &["bayram", "kəsişən", "kəsişən bayraqlar", "xaç", "yapon"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("скрыжаваныя сцягі"),
            keywords: &[
                "свята",
                "скрыжаванне",
                "скрыжаваныя сцягі",
                "сцяг",
                "японскі",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Кръстосани знамена"),
            keywords: &["Кръстосани знамена", "кръстосан", "празнуване", "японски"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some(
                "আড\u{9bc}\u{9be}আড\u{9bc}ি অবস\u{9cd}থ\u{9be}য\u{9bc} থ\u{9be}ক\u{9be} পত\u{9be}ক\u{9be}",
            ),
            keywords: &[
                "আড\u{9bc}\u{9be}আড\u{9bc}ি অবস\u{9cd}থ\u{9be}য\u{9bc} থ\u{9be}ক\u{9be}",
                "আড\u{9bc}\u{9be}আড\u{9bc}ি অবস\u{9cd}থ\u{9be}য\u{9bc} থ\u{9be}ক\u{9be} পত\u{9be}ক\u{9be}",
                "উদয\u{9be}পন",
                "ক\u{9cd}রস",
                "জ\u{9be}প\u{9be}নি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bannieloù kroaziet"),
            keywords: &["banniel", "bannieloù kroaziet"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ukrštene zastave"),
            keywords: &["japansko", "slavlje", "ukrštene zastave", "ukršteno"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("banderes creuades"),
            keywords: &["banderes", "banderes creuades", "celebració", "japó"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄝𑄃𑄟\u{1112a}𑄌\u{11133}𑄠\u{11134} 𑄝𑄝\u{11127}𑄘"),
            keywords: &["𑄝𑄃𑄟\u{1112a}𑄌\u{11133}𑄠\u{11134} 𑄝𑄝\u{11127}𑄘"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏧᏓᎿᏫᏓ ᏗᎦᏓᏗ"),
            keywords: &["ᎠᎾᎵᎮᎵᏍᏗᏍᎬᎢ", "ᏓᏓᎿᏫᏍᏛ", "ᏣᏩᏂᏏ", "ᏧᏓᎿᏫᏓ", "ᏧᏓᎿᏫᏓ ᏗᎦᏓᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zkřížené vlajky"),
            keywords: &["japonský", "kříž", "oslava", "zkřížené", "zkřížené vlajky"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("baneri wedi croesi"),
            keywords: &[
                "Japaneaidd",
                "baneri wedi croesi",
                "croes",
                "dathliad",
                "wedi croesi",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("to krydsede flag"),
            keywords: &["fejring", "japanske flag", "kryds", "to krydsede flag"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("überkreuzte Flaggen"),
            keywords: &["Japan", "japanische Flaggen", "überkreuzte Flaggen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σταυρωτές σημαίες"),
            keywords: &[
                "γιορτή",
                "ιαπωνικό",
                "σταυρωτές",
                "σταυρωτές σημαίες",
                "σταυρός",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("crossed flags"),
            keywords: &[
                "Japanese",
                "celebration",
                "cross",
                "crossed",
                "crossed flags",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("banderas cruzadas"),
            keywords: &["banderas", "banderas cruzadas", "celebración", "japón"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("ristatud lipud"),
            keywords: &["lipp", "pidu", "ristatud lipud", "risti"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bandera gurutzatuak"),
            keywords: &[
                "bandera gurutzatuak",
                "gurutzatuta",
                "gurutze",
                "japoniar",
                "ospakizuna",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پرچم\u{200c}های ضرب\u{200c}دری"),
            keywords: &[
                "جشن",
                "صلیب",
                "متقاطع",
                "پرچم\u{200c}های ضرب\u{200c}دری",
                "ژاپنی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("liput ristissä"),
            keywords: &["Japani", "juhla", "liput ristissä", "ristityt"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("magkakrus na bandila"),
            keywords: &["Hapon", "bandila", "magkakrus", "magkakrus na bandila"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("krossa fløgg"),
            keywords: &["fløgg", "japan", "krossa fløgg"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("drapeaux croisés"),
            keywords: &["drapeaux", "drapeaux croisés"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bratacha trasnaithe"),
            keywords: &["bratacha", "bratacha na Seapáine", "bratacha trasnaithe"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("brataichean tarsainn a chèile"),
            keywords: &[
                "brataichean tarsainn a chèile",
                "comharrachadh",
                "iapanach",
                "seapanach",
                "tarsainn",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("bandeiras cruzadas"),
            keywords: &["Xapón", "bandeiras", "cruzadas"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચોકડીવાળા ધ\u{acd}વજ"),
            keywords: &[
                "ઉજવણી",
                "ક\u{acd}રૉસ",
                "ક\u{acd}રૉસ કર\u{ac7}લો । ક\u{acd}રૉસ કર\u{ac7}લો ધ\u{acd}વજ",
                "ચોકડીવાળા ધ\u{acd}વજ",
                "જાપાનીઝ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("haɗaɗɗun tutoci"),
            keywords: &["Na Japan", "haɗaɗɗe", "haɗaɗɗun tutoci", "kuros", "shagali"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("דגלים מוצלבים"),
            keywords: &["דגלים", "יפן", "מוצלבים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("क\u{94d}रॉस झ\u{902}ड\u{947}"),
            keywords: &[
                "क\u{94d}रॉस झ\u{902}ड\u{947}",
                "जापान क\u{947} क\u{94d}रॉस झ\u{902}ड\u{947}",
                "ध\u{94d}वज",
                "समारोह",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("prekrižene zastave"),
            keywords: &["japan", "prekrižene zastave", "prekriženo", "slavlje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("keresztbe tett zászlók"),
            keywords: &[
                "japán",
                "keresztbe tett",
                "keresztbe tett zászlók",
                "zászlók",
                "ünnep",
                "ünnepi hangulat",
                "ünneplés",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("խաչված դրոշակներ"),
            keywords: &["խաչ", "խաչված", "խաչված դրոշակներ", "ճապոնական", "տոն"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("bandieras cruciate"),
            keywords: &[
                "bandieras cruciate",
                "celebration",
                "cruce",
                "cruciate",
                "japonese",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bendera menyilang"),
            keywords: &[
                "Jepang",
                "bendera menyilang",
                "menyilang",
                "perayaan",
                "silang",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọkọlọtọ nwere nkachi"),
            keywords: &[
                "Ndị Japan",
                "akachiri",
                "enwemụaṅụrị",
                "nkachị",
                "ọkọlọtọ nwere nkachi",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("japanskir fánar í kross"),
            keywords: &["fánar", "fánar í kross", "hátíð", "japanskir fánar í kross"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("bandiere del Giappone incrociate"),
            keywords: &["bandiere del Giappone incrociate"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("祝日の旗"),
            keywords: &["フラグ", "フラッグ", "旗", "日の丸", "祝日", "祝日の旗"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("gendera loro ditempuk"),
            keywords: &[
                "Jepang",
                "ditempukake",
                "gendera",
                "gendera loro ditempuk",
                "pista",
                "tempuk",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გადაკვეთილი დროშები"),
            keywords: &[
                "აღნიშვნა",
                "გადაკვეთილი",
                "გადაკვეთილი დროშები",
                "ზეიმი",
                "იაპონური",
                "ჯვარი",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("anayen ijapuniyen"),
            keywords: &["anayen ijapuniyen"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("айқастырылған жалаушалар"),
            keywords: &[
                "айқас",
                "айқастырылған",
                "айқастырылған жалаушалар",
                "жапон",
                "тойлау",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("to flag"),
            keywords: &["japanske flag", "to flag"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ទង\u{17cb}ជាត\u{17b7}ជប\u{17c9}\u{17bb}នខ\u{17d2}វែងគ\u{17d2}នា"),
            keywords: &[
                "ខ\u{17d2}វែង",
                "ទង\u{17cb}ជាត\u{17b7}",
                "ទង\u{17cb}ជាត\u{17b7}ជប\u{17c9}\u{17bb}នខ\u{17d2}វែងគ\u{17d2}នា",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಅಡ\u{ccd}ಡ\u{200c}ಅಡ\u{ccd}ಡವಾಗ\u{cbf}ರುವ ಧ\u{ccd}ವಜಗಳು"),
            keywords: &[
                "ಅಡ\u{ccd}ಡ\u{200c}ಅಡ\u{ccd}ಡವಾಗ\u{cbf}ರುವ ಧ\u{ccd}ವಜಗಳು",
                "ಆಚರಣ\u{cc6}",
                "ಕ\u{ccd}ರಾಸ\u{ccd}ಡ\u{ccd}",
                "ಜಪಾನ\u{cbf}ನ ಕ\u{ccd}ರಾಸ\u{ccd}ಡ\u{ccd} ಫ\u{ccd}ಲ\u{ccd}ಯಾಗ\u{ccd}\u{200c}ಗಳು",
                "ಫ\u{ccd}ಲ\u{ccd}ಯಾಗ\u{ccd}\u{200c}ಗಳು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("엇갈린 일본 국기"),
            keywords: &["국가 행사", "국기", "엇갈린 일본 국기"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("क\u{94d}रॉस बावटो"),
            keywords: &[
                "क\u{94d}रॉस",
                "क\u{94d}रॉस क\u{947}ल\u{94d}ल\u{947} बावट\u{947}",
                "क\u{94d}रॉस क\u{947}ल\u{94d}ल\u{947}\u{902}",
                "क\u{94d}रॉस बावटो",
                "जपानी",
                "स\u{941}वाळो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кайчылаш желектер"),
            keywords: &["жапончо", "кайчылаш", "кайчылаш желектер", "майрам"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("gekräizt Fändelen"),
            keywords: &[
                "Feier",
                "Kräiz",
                "gekräizt",
                "gekräizt Fändelen",
                "japanesch",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ທ\u{eb8}ງໄຂວ\u{ec8}ກ\u{eb1}ນ"),
            keywords: &[
                "ຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນ",
                "ທ\u{eb8}ງໄຂວ\u{ec8}ກ\u{eb1}ນ",
                "ສະເຫ\u{ebc}\u{eb5}ມສະຫ\u{ebc}ອງ",
                "ໄຂວ\u{ec8}ກ\u{eb1}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("sukryžiuotos vėliavos"),
            keywords: &["japonų", "kryžius", "sukryžiuotos vėliavos", "šventė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sakrustoti karogi"),
            keywords: &[
                "japāņu",
                "karogs",
                "sakrustot",
                "sakrustoti karogi",
                "svētki",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kara whakawhiri"),
            keywords: &[
                "Hapanīhi",
                "kara whakawhiri",
                "whakanuinga",
                "whakawhiri",
                "whiri",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("вкрстени знамиња"),
            keywords: &["вкрстени знамиња", "знаме", "прослава", "јапонска"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d41}റ\u{d41}കെയ\u{d41}ള\u{d4d}ള പത\u{d3e}കകൾ"),
            keywords: &[
                "ആഘോഷം",
                "ക\u{d41}റ\u{d41}കെയ\u{d41}ള\u{d4d}ള പത\u{d3e}കകൾ",
                "പത\u{d3e}ക",
                "പരസ\u{d4d}പരം വിച\u{d4d}ഛേദിക\u{d4d}ക\u{d41}ന\u{d4d}ന പത\u{d3e}കകൾ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("солбисон туг"),
            keywords: &["солбисон туг", "солбих", "туг", "тэмдэглэлт өдөр", "япон"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some(
                "एकम\u{947}का\u{902}विर\u{942}द\u{94d}ध ठ\u{947}वल\u{947}ल\u{947} झ\u{947}\u{902}ड\u{947}",
            ),
            keywords: &[
                "उत\u{94d}सव",
                "एकम\u{947}का\u{902}विर\u{942}द\u{94d}ध",
                "एकम\u{947}का\u{902}विर\u{942}द\u{94d}ध ठ\u{947}वल\u{947}ल\u{947}",
                "एकम\u{947}का\u{902}विर\u{942}द\u{94d}ध ठ\u{947}वल\u{947}ल\u{947} झ\u{947}\u{902}ड\u{947}",
                "एकम\u{947}का\u{902}विर\u{942}द\u{94d}ध ठ\u{947}वल\u{947}ल\u{947} ध\u{94d}वज",
                "जपानी",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bendera bersilang"),
            keywords: &[
                "Jepun",
                "bendera bersilang",
                "bersilang",
                "perayaan",
                "silang",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("bnadar inkroċjati"),
            keywords: &[
                "bnadar inkroċjati",
                "inkroċja",
                "inkroċjati",
                "ċelebrazzjoni",
                "Ġappuniż",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကြက\u{103a}ခြေခတ\u{103a} အလ\u{1036}များ"),
            keywords: &[
                "ကြက\u{103a}ခြေခတ\u{103a}",
                "ကြက\u{103a}ခြေခတ\u{103a} အလ\u{1036}များ",
                "ဂျပန\u{103a}",
                "ပ\u{103d}\u{1032}တော\u{103a}",
                "လက\u{103a}ဝါးကပ\u{103a}တ\u{102d}\u{102f}င\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kryssede flagg"),
            keywords: &[
                "feiring",
                "flagg",
                "kryssede flagg",
                "kryssede japanske flagg",
                "krysset",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("क\u{94d}रस गरिएको झण\u{94d}डाहर\u{942}"),
            keywords: &[
                "क\u{94d}रस",
                "क\u{94d}रस गरिएको",
                "क\u{94d}रस गरिएको झण\u{94d}डाहर\u{942}",
                "झण\u{94d}डाहर\u{942}",
                "समारोह",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gekruiste vlaggen"),
            keywords: &["feest", "gekruist", "gekruiste vlaggen", "japans", "kruis"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kryssa flagg"),
            keywords: &["feiring", "flagg", "kryssa", "kryssa japanske flagg"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଛକ\u{b3f}ଯ\u{b41}କ\u{b4d}ତ ପତ\u{b3e}କ\u{b3e}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ"),
            keywords: &[
                "ଉତ\u{b4d}ସବ ପ\u{b3e}ଳନ",
                "ଛକ\u{b3f} ଚ\u{b3f}ହ\u{b4d}ନ",
                "ଛକ\u{b3f}ଯ\u{b41}କ\u{b4d}ତ",
                "ଛକ\u{b3f}ଯ\u{b41}କ\u{b4d}ତ ପତ\u{b3e}କ\u{b3e}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
                "ଜ\u{b3e}ପ\u{b3e}ନୀୟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a4d}ਰਾਸ ਕੀਤ\u{a47} ਝ\u{a70}ਡ\u{a47}"),
            keywords: &[
                "ਕ\u{a4d}ਰਾਸ ਕੀਤ\u{a47} ਝ\u{a70}ਡ\u{a47}",
                "ਜਸ\u{a3c}ਨ",
                "ਜਾਪਾਨ ਦ\u{a47} ਪਾਰ ਝ\u{a70}ਡ\u{a47}",
                "ਝ\u{a70}ਡ\u{a47}",
                "ਪਾਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("آرپار جھنڈے"),
            keywords: &["آرپار جھنڈے", "جاپانی", "منانا", "پار کرنا", "پار کیتا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Flag-dẹm Wé Krọ\u{301}s Ích Ọ\u{301}da"),
            keywords: &[
                "Bin Krọs",
                "Flag-dẹm Wé Krọ\u{301}s Ích Ọ\u{301}da",
                "Japán Pípol",
                "Krọs",
                "Krọ\u{301}s Flag-dẹm",
                "Sẹlibréshọn",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("skrzyżowane flagi"),
            keywords: &[
                "japońskie",
                "skrzyżowane",
                "skrzyżowane flagi",
                "uroczystość",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کراسډ بېرغې"),
            keywords: &[
                "جاپاني",
                "لمانځنه",
                "کراس",
                "کراسډ",
                "کراسډ بېرغي",
                "کراسډ بېرغې",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bandeiras cruzadas"),
            keywords: &[
                "bandeiras",
                "bandeiras cruzadas do Japão",
                "comemoração",
                "cruzadas",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("bandeiras do Japão cruzadas"),
            keywords: &[
                "bandeiras do Japão cruzadas",
                "celebração",
                "cruz",
                "cruzado",
                "japonês",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("chakatasqa wiphalakuna"),
            keywords: &[
                "Japones",
                "chakatasqa",
                "chakatasqa wiphalakuna",
                "rank’usqa",
                "raymi",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("steaguri încrucișate"),
            keywords: &[
                "Japonia",
                "steaguri încrucișate",
                "sărbătorire",
                "încrucișare",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-337"),
            keywords: &["E10-337"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("скрещенные флаги"),
            keywords: &["белый", "два", "скрещенные флаги", "флаг", "япония"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("amadarapo anyuranamo"),
            keywords: &[
                "Ikiyapani",
                "amadarapo anyuranamo",
                "cyaciwemo umurongo",
                "inbirori",
                "umusaraba",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪرسڊ جهنڊا"),
            keywords: &["جاپاني", "جشن", "ڪراس", "ڪراسڊ", "ڪرسڊ جهنڊا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හරහට දැම\u{dd6} කොඩ\u{dd2}"),
            keywords: &[
                "ජපන\u{dca}",
                "සැමර\u{dd4}ම",
                "හරහට දැම\u{dd3}ම",
                "හරහට දැම\u{dd6}",
                "හරහට දැම\u{dd6} කොඩ\u{dd2}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("skrížené zástavy"),
            keywords: &[
                "oslava",
                "prekrížené",
                "skrížené",
                "skrížené zástavy",
                "vlajky",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("prekrižani zastavi"),
            keywords: &[
                "japonsko",
                "križ",
                "prekrižani zastavi",
                "prekrižano",
                "slavje",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("calanka ka gudba"),
            keywords: &[
                "Japanese",
                "calanka ka gudba",
                "dabaal dag",
                "gudub",
                "ka gudbay",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("flamuj të kryqëzuar"),
            keywords: &[
                "festë",
                "flamuj të kryqëzuar",
                "i kryqëzuar",
                "japonez",
                "kryq",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("укрштене заставе"),
            keywords: &[
                "крст",
                "прослава",
                "укрштен",
                "укрштене заставе",
                "јапански",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["укрштене заставе"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ukrštene zastave"),
            keywords: &[
                "japanski",
                "krst",
                "proslava",
                "ukršten",
                "ukrštene zastave",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["ukrštene zastave"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("korsade flaggor"),
            keywords: &["fest", "flaggor", "japanska", "korsade"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("bendera mbili zilizopishana"),
            keywords: &[
                "bendera mbili zilizopishana",
                "iliyopishanishwa",
                "kijapani",
                "kusherehekea",
                "pishanisha",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("குறுக\u{bcd}கே கட\u{bcd}டப\u{bcd}பட\u{bcd}ட கொடிகள\u{bcd}"),
            keywords: &[
                "குறுக\u{bcd}கே கட\u{bcd}டப\u{bcd}பட\u{bcd}ட கொடிகள\u{bcd}",
                "கொடிகள\u{bcd}",
                "கொண\u{bcd}ட\u{bbe}ட\u{bcd}டம\u{bcd}",
                "ஜப\u{bcd}ப\u{bbe}ன\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "వ\u{c3f}రుద\u{c4d}ధ ద\u{c3f}శల\u{c4d}ల\u{c4b} న\u{c3f}లబ\u{c46}ట\u{c4d}ట\u{c3f}న ర\u{c46}ండు జ\u{c46}ండ\u{c3e}లు",
            ),
            keywords: &[
                "జ\u{c46}ండ\u{c3e}లు",
                "వ\u{c3f}రుద\u{c4d}ధ ద\u{c3f}శల\u{c4d}ల\u{c4b} న\u{c3f}లబ\u{c46}ట\u{c4d}ట\u{c3f}న ర\u{c46}ండు జప\u{c3e}న\u{c4d} జ\u{c46}ండ\u{c3e}లు",
                "వ\u{c3f}రుద\u{c4d}ధ ద\u{c3f}శల\u{c4d}ల\u{c4b} న\u{c3f}లబ\u{c46}ట\u{c4d}ట\u{c3f}న ర\u{c46}ండు జ\u{c46}ండ\u{c3e}లు",
                "వ\u{c47}డుక",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("байрақҳои чиллик гузошташуда"),
            keywords: &[
                "байрақҳои чиллик гузошташуда",
                "салиб",
                "чиллик гузошташуда",
                "ҷашн",
                "ҷопонӣ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ธงไขว\u{e49}"),
            keywords: &[
                "การฉลอง",
                "ญ\u{e35}\u{e48}ป\u{e38}\u{e48}น",
                "ธง",
                "ธงไขว\u{e49}",
                "ไขว\u{e49}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("atanak baýdaklar"),
            keywords: &[
                "atanak",
                "atanak baýdaklar",
                "atanak çekilen",
                "baýramçylyk",
                "ýapon",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fuka fehauaki"),
            keywords: &["fehauaki", "fuka", "siapani"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("çapraz bayraklar"),
            keywords: &["bayraklar", "kutlama", "çapraz", "çapraz Japon bayrakları"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قايچىلانما بايراقلار"),
            keywords: &["تەبرىكلەش", "قايچىلانما", "قايچىلانما بايراقلار", "ياپونچە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("схрещені прапори"),
            keywords: &[
                "навхрест",
                "прапори навхрест",
                "схрещені прапори",
                "урочистість",
                "японські",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کراس کی شکل میں جھنڈے"),
            keywords: &["جاپانی", "جشن", "کراس", "کراس کی شکل میں جھنڈے"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("bir-birini kesib o‘tgan bayroqlar"),
            keywords: &[
                "bayram",
                "bir-birini kesib o‘tgan bayroqlar",
                "kesishgan",
                "nishonlash",
                "yapon",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cờ bắt chéo"),
            keywords: &[
                "bắt chéo",
                "cờ bắt chéo",
                "gạch chéo",
                "kiểu nhật bản",
                "lễ kỷ niệm",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("raaya yu féewaloo"),
            keywords: &[
                "Sapone",
                "bu am kruwaa",
                "kruwaa",
                "màggal",
                "raaya yu féewaloo",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iiflegi ezinqamlezeneyo"),
            keywords: &[
                "enqamlezileyo",
                "iiflegi ezinqamlezeneyo",
                "umbhiyozo",
                "umnqamlezo",
                "yaseJapan",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Awọn Asia Onidabu"),
            keywords: &[
                "Awọn Asia Onidabu",
                "Japanese",
                "ayẹyẹ",
                "rekoja",
                "àgbélébù",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("交叉旗"),
            keywords: &["交叉", "交叉旗", "慶祝", "日本"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("交叉旗"),
            keywords: &["交叉", "交叉旗", "庆祝", "日本"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("交叉旗"),
            keywords: &["交叉旗", "对叉", "旗帜", "日本"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("紀念日"),
            keywords: &["旗", "日本", "紀念日"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("交叉嘅旗"),
            keywords: &["交叉嘅旗", "旗", "日本"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("amafulegi aphambanayo"),
            keywords: &[
                "amafulegi aphambanayo",
                "okwaseJapan",
                "ukubungaza",
                "ukuphambanisa",
            ],
        },
    ],
};
#[doc = "🏴"]
pub const BLACK_FLAG: crate::Emoji = crate::Emoji {
    glyph: "🏴",
    codepoint: "1F3F4",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "black flag",
    group: "Flags",
    subgroup: "flag",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("wapperende swart vlag"),
            keywords: &["swart", "vlag", "wapper", "wapperende swart vlag"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጥቁር ባንዴራ ማውለብለብ"),
            keywords: &["ማውለብለብ", "ጥቁር ባንዴራ ማውለብለብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("علم أسود يرفرف"),
            keywords: &["علم أسود يرفرف", "يرفرف"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক’ল\u{9be} পত\u{9be}ক\u{9be}"),
            keywords: &["ক’ল\u{9be} পত\u{9be}ক\u{9be}", "ঢৌখেল\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("dalğalanan qara bayraq"),
            keywords: &["dalğalanan", "dalğalanan qara bayraq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чорны сцяг развяваецца"),
            keywords: &["лунанне", "сцяг", "чорны", "чорны сцяг развяваецца"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Веещо се черно знаме"),
            keywords: &["Веещо се черно знаме", "развяващ се"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9be}লো পত\u{9be}ক\u{9be} ওড\u{9bc}\u{9be}নো"),
            keywords: &[
                "ক\u{9be}লো পত\u{9be}ক\u{9be} ওড\u{9bc}\u{9be}নো",
                "তরঙ\u{9cd}গ\u{9be}য\u{9bc}িত",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("banniel du"),
            keywords: &["banniel", "banniel du"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("crna zastava"),
            keywords: &["crna zastava", "mahanje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bandera negra"),
            keywords: &["bandera", "bandera negra", "oneig"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄇𑄣 𑄝𑄝\u{11127}𑄘"),
            keywords: &["𑄇𑄣 𑄝𑄝\u{11127}𑄘"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎬᎿᎨ ᎦᏓᏘ"),
            keywords: &["ᎠᎵᏐᏰᏍᎬ", "ᎬᎿᎨ ᎦᏓᏘ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("černá vlajka"),
            keywords: &["prapor", "praporek", "vlající", "černá vlajka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("chwifio baner ddu"),
            keywords: &["chwifio", "chwifio baner ddu"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sort flag"),
            keywords: &["blafrende", "sort flag"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("schwarze Flagge"),
            keywords: &["Fahne", "schwarze Fahne", "schwarze Flagge", "wehen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μαύρη σημαία"),
            keywords: &["κυματίζει", "μαύρη σημαία"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("black flag"),
            keywords: &["black flag", "waving"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bandera negra"),
            keywords: &["bandera", "negra", "ondear"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("must lipp"),
            keywords: &["lehvimine", "lipp", "must lipp"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("dantzatzen ari den bandera beltza"),
            keywords: &["dantzan", "dantzatzen ari den bandera beltza"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پرچم سیاه"),
            keywords: &["اهتزاز", "دراهتزاز", "سیاه", "مشکی", "پرچم"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("musta lippu"),
            keywords: &["liehuva", "lippu", "musta"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("itim na bandila"),
            keywords: &["bandila", "itim", "itim na bandila", "iwinawagayway"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("svart flagg"),
            keywords: &["flagg", "svart flagg"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("drapeau noir"),
            keywords: &["drapeau", "drapeau noir"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bratach dhubh"),
            keywords: &["ar foluain", "bratach dhubh"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bratach dhubh"),
            keywords: &["bratach dhubh", "crathadh", "snàmh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("bandeira negra ondeando"),
            keywords: &["bandeira", "bandeira negra ondeando", "negra", "ondear"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લહ\u{ac7}રતો કાળો ઝ\u{a82}ડો"),
            keywords: &["લહ\u{ac7}રતો કાળો ઝ\u{a82}ડો", "લહ\u{ac7}રવ\u{ac1}\u{a82}"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("baƙar tuta"),
            keywords: &["baƙar tuta", "kaɗawa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("דגל שחור"),
            keywords: &["דגל", "מתנפנף", "שחור"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("काला झ\u{902}डा"),
            keywords: &["काला झ\u{902}डा", "लहराता काला झ\u{902}डा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("crna zastava"),
            keywords: &["crna zastava", "vijorenje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("lengő fekete zászló"),
            keywords: &["lengő", "lengő fekete zászló"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ծածանվող սև դրոշ"),
            keywords: &["ծածանվող", "ծածանվող սեւ դրոշ", "ծածանվող սև դրոշ"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("bandiera nigre"),
            keywords: &["agitante", "bandiera nigre", "flottante", "undulante"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bendera hitam"),
            keywords: &["bendera hitam", "berkibar"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọkọlọtọ ojii"),
            keywords: &["na-efe", "ọkọlọtọ ojii"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("svartur fáni"),
            keywords: &["blaktandi", "blaktandi svartur fáni", "svartur fáni"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("bandiera nera"),
            keywords: &["bandiera che sventola", "bandiera nera"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("黒旗"),
            keywords: &["フラグ", "フラッグ", "旗", "黒", "黒旗"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("gendera ireng"),
            keywords: &["gendera ireng", "ngawe-awe"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გაშლილი შავი დროშა"),
            keywords: &["გაშლილი", "გაშლილი შავი დროშა", "შავი დროშა"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("anay aberkan"),
            keywords: &["anay aberkan"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қара жалау"),
            keywords: &["желбіреу", "қара жалау"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("sort flag"),
            keywords: &["blafrende", "sort flag"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ទង\u{17cb}ជាត\u{17b7}ពណ\u{17cc}ខ\u{17d2}មៅ"),
            keywords: &[
                "ទង\u{17cb}",
                "ទង\u{17cb}ជាត\u{17b7}",
                "ទង\u{17cb}ជាត\u{17b7}ពណ\u{17cc}ខ\u{17d2}មៅ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಪ\u{ccd}ಪು ಧ\u{ccd}ವಜ"),
            keywords: &["ಕಪ\u{ccd}ಪು ಧ\u{ccd}ವಜ", "ಬೀಸುವ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("펄럭이는 검은색 깃발"),
            keywords: &["깃발", "펄럭이는 검은색 깃발", "플래그"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("काळो बावटो"),
            keywords: &["काळो बावटो", "हालयता"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("желбиреген кара желек"),
            keywords: &["желбиреген", "желбиреген кара желек"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("schwaarze Fändel"),
            keywords: &["schwaarze Fändel", "wénkend"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ທ\u{eb8}ງດຳທ\u{eb5}\u{ec8}ປ\u{eb4}ວສະບ\u{eb1}ດ"),
            keywords: &[
                "ທ\u{eb8}ງດຳ",
                "ທ\u{eb8}ງດຳທ\u{eb5}\u{ec8}ປ\u{eb4}ວສະບ\u{eb1}ດ",
                "ປ\u{eb4}ວສະບ\u{eb1}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("juoda vėliava"),
            keywords: &["juoda vėliava", "mojavimas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("melns karogs"),
            keywords: &["karogs", "melns karogs", "plīvot"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kara pango"),
            keywords: &["kara pango", "piupiu ana"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("црно знаме"),
            keywords: &["знаме", "црно"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "പ\u{d3e}റിപ\u{d4d}പറക\u{d4d}ക\u{d41}ന\u{d4d}ന കറ\u{d41}ത\u{d4d}ത പത\u{d3e}ക",
            ),
            keywords: &[
                "കറ\u{d41}പ\u{d4d}പ\u{d4d}",
                "പത\u{d3e}ക",
                "പ\u{d3e}റിപ\u{d4d}പറക\u{d4d}ക\u{d41}ന\u{d4d}ന കറ\u{d41}ത\u{d4d}ത പത\u{d3e}ക",
                "വീശ\u{d41}ക",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хар туг"),
            keywords: &["даллах", "туг", "хар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("फडकणारा काळा ध\u{94d}वज"),
            keywords: &["तर\u{902}गणारा", "फडकणारा काळा ध\u{94d}वज"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bendera hitam"),
            keywords: &["bendera hitam", "berkibar"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("bandiera sewda"),
            keywords: &["bandiera sewda", "ixejjer"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဝ\u{103e}ေ\u{1037}ယမ\u{103a}းနေသည\u{1037}\u{103a} အလ\u{1036}မည\u{103a}း"),
            keywords: &[
                "ဝ\u{103e}ေ\u{1037}ယမ\u{103a}းနေ",
                "ဝ\u{103e}ေ\u{1037}ယမ\u{103a}းနေသည\u{1037}\u{103a} အလ\u{1036}မည\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("svart flagg"),
            keywords: &["flagg", "flagring", "svart"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("हल\u{94d}लिरह\u{947}को कालो झण\u{94d}डा"),
            keywords: &[
                "हल\u{94d}लिरह\u{947}को",
                "हल\u{94d}लिरह\u{947}को कालो झण\u{94d}डा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("zwarte vlag"),
            keywords: &["vlag", "zwart", "zwarte vlag"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("svart flagg"),
            keywords: &["flagg", "flagring", "svart"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କଳ\u{b3e} ପତ\u{b3e}କ\u{b3e}"),
            keywords: &["କଳ\u{b3e} ପତ\u{b3e}କ\u{b3e}", "ଦୋଳ\u{b3e}ୟମ\u{b3e}ନ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲਹਿਰਾਉ\u{a02}ਦਾ ਕਾਲਾ ਝ\u{a70}ਡਾ"),
            keywords: &[
                "ਕਾਲਾ ਝ\u{a70}ਡਾ",
                "ਝ\u{a70}ਡਾ ਲਹਿਰਾਉਣਾ",
                "ਲਹਿਰਾਉ\u{a02}ਦਾ ਕਾਲਾ ਝ\u{a70}ਡਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کالا جھنڈا"),
            keywords: &["لہراندا", "کالا جھنڈا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Blák Flag"),
            keywords: &["Blák Flag", "Wev"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("czarna flaga"),
            keywords: &["czarna flaga", "flaga", "na wietrze", "żałoba"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("تور بیراغ"),
            keywords: &["تور بیراغ", "تور بېرغ", "خوځېدونکې"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bandeira preta"),
            keywords: &["bandeira preta", "tremulando"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["abanar", "bandeira preta", "bandeira preta a abanar"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("yana whipala"),
            keywords: &["qinquykachay", "yana whipala"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("steag negru"),
            keywords: &["fluturând", "steag negru"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-434"),
            keywords: &["E10-434"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("черный флаг"),
            keywords: &["реет", "флаг", "черный"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibendera ry’umukara"),
            keywords: &["gupepera", "ibendera ry’umukara"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪارو جهنڊو"),
            keywords: &["لڏندڙ", "ڪارو جهنڊو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වැනෙන කළ\u{dd4} කොඩ\u{dd2}ය"),
            keywords: &["වැන\u{dd3}ම", "වැනෙන කළ\u{dd4} කොඩ\u{dd2}ය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("čierna zástava"),
            keywords: &["vlajka", "čierna zástava"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("črna zastava"),
            keywords: &["plapolanje", "črna zastava"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("calanka madoow"),
            keywords: &["calanka madoow", "luxanaaya"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("flamur i zi"),
            keywords: &["flamur i zi", "valëvitës"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("црна застава"),
            keywords: &["вијорење", "црна застава"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["црна застава"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("crna zastava"),
            keywords: &["crna zastava", "vijorenje"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["crna zastava"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("svart flagga"),
            keywords: &["flagga", "svart flagga"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kupeperusha bendera nyeusi"),
            keywords: &["kupeperusha", "kupeperusha bendera nyeusi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அசைக\u{bcd}கும\u{bcd} கருப\u{bcd}புக\u{bcd} கொடி"),
            keywords: &[
                "அசைக\u{bcd}கும\u{bcd} கருப\u{bcd}புக\u{bcd} கொடி",
                "கருப\u{bcd}புக\u{bcd} கொடி",
                "கொடி",
                "துக\u{bcd}கம\u{bcd}",
                "பறக\u{bcd}கும\u{bcd} கொடி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఎగురుతున\u{c4d}న నలుపు జ\u{c46}ండ\u{c3e}"),
            keywords: &[
                "ఎగరడం",
                "ఎగురుతున\u{c4d}న నలుపు జ\u{c46}ండ\u{c3e}",
                "జ\u{c46}ండ\u{c3e}",
                "నలుపు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("байрақи сиёҳ"),
            keywords: &["байрақи сиёҳ", "мавҷ задан"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ธงดำ"),
            keywords: &["ธง", "ธงดำ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gara baýdak"),
            keywords: &["galgatmak", "gara baýdak"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fuka ʻuliʻuli"),
            keywords: &["fuka", "ʻuliʻuli"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("siyah bayrak"),
            keywords: &["bayrak", "siyah bayrak"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قارا بايراق"),
            keywords: &["قارا بايراق", "چۆرۈش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("чорний прапор"),
            keywords: &["майорить", "чорний прапор"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("لہراتا کالا جھنڈا"),
            keywords: &["جھنڈا", "لہراتا", "کالا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("hilpiragan qora bayroq"),
            keywords: &["hilpirab turgan", "hilpiragan qora bayroq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cờ đen"),
            keywords: &["cờ đen", "vẫy"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("raaya bu ñuul"),
            keywords: &["buñ tàllal", "raaya bu ñuul"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iflegi emnyama"),
            keywords: &["iflegi emnyama", "ukuwangawangisa"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("asia dudu"),
            keywords: &["asia dudu", "iṣàn omi"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("黑色旗"),
            keywords: &["波浪", "黑色旗"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("黑色旗"),
            keywords: &["波浪", "黑色旗"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("举黑旗"),
            keywords: &["举黑旗", "黑旗", "黑色旗", "黑色旗子", "黑色旗帜"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("黑旗"),
            keywords: &["黑旗"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukundizisa ifulegi elimnyama"),
            keywords: &["ukundizisa", "ukundizisa ifulegi elimnyama"],
        },
    ],
};
#[doc = "🏳\u{fe0f}"]
pub const WHITE_FLAG: crate::Emoji = crate::Emoji {
    glyph: "🏳\u{fe0f}",
    codepoint: "1F3F3 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "white flag",
    group: "Flags",
    subgroup: "flag",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🏳",
        codepoint: "1F3F3",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "white flag",
        group: "Flags",
        subgroup: "flag",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("wapperende wit vlag"),
            keywords: &["vlag", "vrede", "wapper", "wapperende wit vlag", "wit"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ነጭ ባንዴራ ማውለብለብ"),
            keywords: &["ማውለብለብ", "ነጭ ባንዴራ ማውለብለብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("علم أبيض يرفرف"),
            keywords: &["رفرفة", "علم أبيض يرفرف"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বগ\u{9be} পত\u{9be}ক\u{9be}"),
            keywords: &["ঢৌখেল\u{9be}", "বগ\u{9be} পত\u{9be}ক\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("dalğalanan ağ bayraq"),
            keywords: &["dalğalanan", "dalğalanan ağ bayraq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("белы сцяг развяваецца"),
            keywords: &["белы", "белы сцяг развяваецца", "лунанне", "сцяг"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Веещо се бяло знаме"),
            keywords: &["Веещо се бяло знаме", "развяващ се"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9be}দ\u{9be} পত\u{9be}ক\u{9be} ওড\u{9bc}\u{9be}নো"),
            keywords: &[
                "তরঙ\u{9cd}গ\u{9be}য\u{9bc}িত",
                "স\u{9be}দ\u{9be} পত\u{9be}ক\u{9be} ওড\u{9bc}\u{9be}নো",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("banniel gwenn"),
            keywords: &["banniel", "banniel gwenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("bijela zastava"),
            keywords: &["bijela zastava", "mahanje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bandera blanca"),
            keywords: &["bandera", "bandera blanca", "oneig"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄙\u{1112a}𑄛\u{11134} 𑄝𑄝\u{11127}𑄘"),
            keywords: &["𑄙\u{1112a}𑄛\u{11134} 𑄝𑄝\u{11127}𑄘"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏁᎦ ᎦᏓᏘ"),
            keywords: &["ᎠᎵᏐᏰᏍᎬ", "ᎤᏁᎦ ᎦᏓᏘ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("bílá vlajka"),
            keywords: &["bílá vlajka", "prapor", "praporek", "vlající"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("chwifio baner wen"),
            keywords: &["chwifio", "chwifio baner wen"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("hvidt flag"),
            keywords: &["blafrende", "hvidt flag"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("weiße Flagge"),
            keywords: &["Fahne", "wehen", "weiße Fahne", "weiße Flagge"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Wehende weisse Fahne"),
            keywords: &["Fahne", "Wehende weisse Fahne", "wehen", "weisse Fahne"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("λευκή σημαία"),
            keywords: &["κυματίζει", "λευκή σημαία"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("white flag"),
            keywords: &["waving", "white flag"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bandera blanca"),
            keywords: &["bandera", "blanca", "ondear"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["bandera", "blanca", "paz"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["bandera", "blanca", "ondear"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("valge lipp"),
            keywords: &["lehvimine", "lipp", "valge lipp"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("dantzatzen ari den bandera zuria"),
            keywords: &["dantzan", "dantzatzen ari den bandera zuria"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پرچم سفید"),
            keywords: &["اهتزاز", "دراهتزاز", "سفید", "پرچم"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("valkoinen lippu"),
            keywords: &["liehuva", "lippu", "valkoinen"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("puting bandila"),
            keywords: &[
                "bandila",
                "iwinawagayway",
                "karera",
                "puti",
                "puting bandila",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hvítt flagg"),
            keywords: &["flagg", "hvítt flagg"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("drapeau blanc"),
            keywords: &["drapeau", "drapeau blanc"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bratach bhán"),
            keywords: &["ar foluain", "bratach bhán"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bratach gheal"),
            keywords: &["bratach gheal", "crathadh", "snàmh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("bandeira branca ondeando"),
            keywords: &["bandeira", "bandeira branca ondeando", "branca", "ondear"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લહ\u{ac7}રતો સફ\u{ac7}દ ઝ\u{a82}ડો"),
            keywords: &[
                "લહ\u{ac7}રતો સફ\u{ac7}દ ઝ\u{a82}ડો",
                "લહ\u{ac7}રવ\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("farar tuta"),
            keywords: &["farar tuta", "kaɗawa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("דגל לבן"),
            keywords: &["דגל", "לבן", "מתנפנף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सफ\u{947}द झ\u{902}डा"),
            keywords: &[
                "लहराता सफ\u{93c}\u{947}द झ\u{902}डा",
                "सफ\u{93c}\u{947}द झ\u{902}डा",
                "सफ\u{947}द झ\u{902}डा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("bijela zastava"),
            keywords: &["bijela zastava", "vijorenje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("lengő fehér zászló"),
            keywords: &["lengő", "lengő fehér zászló"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ծածանվող սպիտակ դրոշ"),
            keywords: &["ծածանվող", "ծածանվող սպիտակ դրոշ", "սպիտակ դրոշ"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("bandiera blanc"),
            keywords: &["agitante", "bandiera blanc", "flottante", "undulante"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bendera putih"),
            keywords: &["bendera putih", "berkibar"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọkọlọtọ ọcha"),
            keywords: &["na-efe", "ọkọlọtọ ọcha"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hvítur fáni"),
            keywords: &["blaktandi", "blaktandi hvítur fáni", "hvítur fáni"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("bandiera bianca"),
            keywords: &[
                "arrendersi",
                "bandiera bianca",
                "bandiera che sventola",
                "sventolare bandiera bianca",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("白旗"),
            keywords: &["フラグ", "フラッグ", "旗", "白", "白旗"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("gendera putih"),
            keywords: &["gendera putih", "ngawe-awe"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გაშლილი თეთრი დროშა"),
            keywords: &["გაშლილი", "გაშლილი თეთრი დროშა", "თეთრი დროშა"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("anay amellal"),
            keywords: &["anay amellal"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ақ жалау"),
            keywords: &["ақ жалау", "желбіреу"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("hvidt flag"),
            keywords: &["blafrende", "hvidt flag"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ទង\u{17cb}ជាត\u{17b7}ពណ\u{17cc}ស"),
            keywords: &[
                "ទង\u{17cb}",
                "ទង\u{17cb}ជាត\u{17b7}",
                "ទង\u{17cb}ជាត\u{17b7}ពណ\u{17cc}ស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಶ\u{ccd}ವೇತ ಧ\u{ccd}ವಜ"),
            keywords: &["ಬೀಸುವ", "ಶ\u{ccd}ವೇತ ಧ\u{ccd}ವಜ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("펄럭이는 흰색 깃발"),
            keywords: &["깃발", "펄럭이는 흰색 깃발", "플래그", "항복"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("धवो बावटो"),
            keywords: &["धवो बावटो", "हालयलो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("желбиреген ак желек"),
            keywords: &["желбиреген", "желбиреген ак желек"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("wäisse Fändel"),
            keywords: &["wäisse Fändel", "wénkend"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ທ\u{eb8}ງຂາວທ\u{eb5}\u{ec8}ປ\u{eb4}ວສະບ\u{eb1}ດ"),
            keywords: &[
                "ທ\u{eb8}ງຂາວ",
                "ທ\u{eb8}ງຂາວທ\u{eb5}\u{ec8}ປ\u{eb4}ວສະບ\u{eb1}ດ",
                "ປ\u{eb4}ວສະບ\u{eb1}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("balta vėliava"),
            keywords: &["balta vėliava", "mojavimas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("balts karogs"),
            keywords: &["balts karogs", "karogs", "plīvot"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kara mā"),
            keywords: &["kara mā", "piupiu ana"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("бело знаме"),
            keywords: &["бело", "знаме"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "പ\u{d3e}റിപ\u{d4d}പറക\u{d4d}ക\u{d41}ന\u{d4d}ന വെള\u{d41}ത\u{d4d}ത പത\u{d3e}ക",
            ),
            keywords: &[
                "പത\u{d3e}ക",
                "പ\u{d3e}റിപ\u{d4d}പറക\u{d4d}ക\u{d41}ന\u{d4d}ന വെള\u{d41}ത\u{d4d}ത പത\u{d3e}ക",
                "വീശ\u{d41}ക",
                "വെള\u{d41}ത\u{d4d}ത",
                "സമ\u{d3e}ധ\u{d3e}നം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цагаан туг"),
            keywords: &["туг", "цагаан"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("फडकणारा पा\u{902}ढरा ध\u{94d}वज"),
            keywords: &["तर\u{902}गणारा", "फडकणारा पा\u{902}ढरा ध\u{94d}वज"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bendera putih"),
            keywords: &["bendera putih", "berkibar"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("bandiera bajda"),
            keywords: &["bandiera bajda", "ixejjer"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဝ\u{103e}ေ\u{1037}ယမ\u{103a}းနေသည\u{1037}\u{103a} အလ\u{1036}ဖြ\u{1030}"),
            keywords: &[
                "ဝ\u{103e}ေ\u{1037}ယမ\u{103a}းနေ",
                "ဝ\u{103e}ေ\u{1037}ယမ\u{103a}းနေသည\u{1037}\u{103a} အလ\u{1036}ဖြ\u{1030}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hvitt flagg"),
            keywords: &["flagg", "flagring", "hvitt"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("हल\u{94d}लिरह\u{947}को स\u{947}तो झण\u{94d}डा"),
            keywords: &[
                "हल\u{94d}लिरह\u{947}को",
                "हल\u{94d}लिरह\u{947}को स\u{947}तो झण\u{94d}डा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("witte vlag"),
            keywords: &["vlag", "wit", "witte vlag"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvitt flagg"),
            keywords: &["flagg", "flagring", "kvitt"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଧଳ\u{b3e} ପତ\u{b3e}କ\u{b3e}"),
            keywords: &["ଦୋଳ\u{b3e}ୟମ\u{b3e}ନ", "ଧଳ\u{b3e} ପତ\u{b3e}କ\u{b3e}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲਹਿਰਾਉ\u{a02}ਦਾ ਸਫ\u{a47}ਦ ਝ\u{a70}ਡਾ"),
            keywords: &[
                "ਝ\u{a70}ਡਾ ਲਹਿਰਾਉਣਾ",
                "ਲਹਿਰਾਉ\u{a02}ਦਾ ਸਫ\u{a47}ਦ ਝ\u{a70}ਡਾ",
                "ਸਫ\u{a47}ਦ ਝ\u{a70}ਡਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چ\u{650}یٹا جھنڈا"),
            keywords: &["لہراندا", "چ\u{650}یٹا جھنڈا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Waít Flag"),
            keywords: &["Waít Flag", "Wev"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("biała flaga"),
            keywords: &[
                "biała flaga",
                "flaga",
                "kapitulacja",
                "na wietrze",
                "poddaję się",
                "powiewająca biała flaga",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سپین بیراغ"),
            keywords: &["خوځېدونکې", "سپين بېرغ", "سپین بیراغ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bandeira branca"),
            keywords: &["bandeira branca", "tremulando"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["abanar", "bandeira branca", "bandeira branca a abanar"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("yuraq whipala"),
            keywords: &["qinquykachay", "yuraq whipala"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("steag alb"),
            keywords: &["fluturând", "steag alb"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-433"),
            keywords: &["E10-433"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("белый флаг"),
            keywords: &["белый", "капитуляция", "реет", "сдавайся", "флаг"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibendera ryera"),
            keywords: &["gupepera", "ibendera ryera"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اڇو جهنڊو"),
            keywords: &["اڇو جهنڊو", "لڏندڙ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වැනෙන කොඩ\u{dd2}ය"),
            keywords: &["වැන\u{dd3}ම", "වැනෙන කොඩ\u{dd2}ය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("biela zástava"),
            keywords: &["biela zástava", "vlajka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("plapolajoča bela zastava"),
            keywords: &["plapolajoča bela zastava", "plapolanje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("calanka cad"),
            keywords: &["calanka cad", "luxanaaya"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("flamur i bardhë"),
            keywords: &["flamur i bardhë", "valëvitës"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("бела застава"),
            keywords: &["бела застава", "вијорење"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("бијела застава"),
            keywords: &["бијела застава"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("bela zastava"),
            keywords: &["bela zastava", "vijorenje"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("bijela zastava"),
            keywords: &["bijela zastava"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("vit flagga"),
            keywords: &["flagga", "vit flagga"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kupeperusha bendera nyeupe"),
            keywords: &["kupeperusha", "kupeperusha bendera nyeupe"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அசைக\u{bcd}கும\u{bcd} வெள\u{bcd}ளைக\u{bcd} கொடி"),
            keywords: &[
                "அசைக\u{bcd}கும\u{bcd} வெள\u{bcd}ளைக\u{bcd} கொடி",
                "கொடி",
                "சம\u{bbe}த\u{bbe}னம\u{bcd}",
                "பறக\u{bcd}கும\u{bcd} கொடி",
                "வெள\u{bcd}ளைக\u{bcd} கொடி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఎగురుతున\u{c4d}న త\u{c46}లుపు జ\u{c46}ండ\u{c3e}"),
            keywords: &[
                "ఎగరడం",
                "ఎగురుతున\u{c4d}న త\u{c46}లుపు జ\u{c46}ండ\u{c3e}",
                "జ\u{c46}ండ\u{c3e}",
                "త\u{c46}లుపు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("байрақи сафед"),
            keywords: &["байрақи сафед", "мавҷ задан"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ธงขาว"),
            keywords: &["ธง", "ธงขาว"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ak baýdak"),
            keywords: &["ak baýdak", "galgatmak"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fuka hinehina"),
            keywords: &["fuka", "hinehina"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("beyaz bayrak"),
            keywords: &["bayrak", "beyaz bayrak"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاق بايراق"),
            keywords: &["ئاق بايراق", "چۆرۈش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("білий прапор"),
            keywords: &["білий прапор", "майорить"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("لہراتا سفید جھنڈا"),
            keywords: &["جھنڈا", "سفید", "لہراتا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("hilpiragan oq bayroq"),
            keywords: &["hilpirab turgan", "hilpiragan oq bayroq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cờ trắng"),
            keywords: &["cờ trắng", "vẫy"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("raaya bu weex"),
            keywords: &["buñ tàllal", "raaya bu weex"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iflegi emhlophe"),
            keywords: &["iflegi emhlophe", "ukuwangawangisa"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àsíá funfun"),
            keywords: &["iṣàn omi", "àsíá funfun"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("白色旗"),
            keywords: &["波浪", "白色旗"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("白色旗"),
            keywords: &["波浪", "白色旗"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("举白旗"),
            keywords: &["举白旗", "白旗", "白色旗子", "白色旗帜"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("白旗"),
            keywords: &["白旗"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukundizisa ifulegi elimhlophe"),
            keywords: &["ukundizisa", "ukundizisa ifulegi elimhlophe"],
        },
    ],
};
#[doc = "🏳\u{fe0f}\u{200d}🌈"]
pub const RAINBOW_FLAG: crate::Emoji = crate::Emoji {
    glyph: "🏳\u{fe0f}\u{200d}🌈",
    codepoint: "1F3F3 FE0F 200D 1F308",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "rainbow flag",
    group: "Flags",
    subgroup: "flag",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🏳\u{200d}🌈",
        codepoint: "1F3F3 200D 1F308",
        status: crate::Status::Unqualified,
        introduction_version: 4f32,
        name: "rainbow flag",
        group: "Flags",
        subgroup: "flag",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("reënboogvlag"),
            keywords: &["reënboog", "reënboogvlag"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የቀስተ ደመና ባንዲራ"),
            keywords: &["ቀስተ ደመና", "ባንዲራ", "የቀስተ ደመና ባንዲራ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("علم ألوان طيف"),
            keywords: &["ألوان طيف", "علم", "علم ألوان طيف"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ৰ\u{9be}মধেন\u{9c1} পত\u{9be}ক\u{9be}"),
            keywords: &[
                "ৰ\u{9be}মধেন\u{9c1}",
                "ৰ\u{9be}মধেন\u{9c1} পত\u{9be}ক\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("göy qurşağı bayrağı"),
            keywords: &["bayraq", "göy qurşağı", "göy qurşağı bayrağı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("вясёлкавы сцяг"),
            keywords: &["вясёлка", "вясёлкавы сцяг", "сцяг"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("флагът на дъгата"),
            keywords: &["дъга", "знаме", "флагът на дъгата"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("র\u{9be}মধন\u{9c1} পত\u{9be}ক\u{9be}"),
            keywords: &[
                "প\u{9be}ত\u{9be}ক",
                "র\u{9be}মধন\u{9c1}",
                "র\u{9be}মধন\u{9c1} পত\u{9be}ক\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("banniel kanevedenn"),
            keywords: &["banniel", "banniel kanevedenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zastava duginih boja"),
            keywords: &["duga", "zastava", "zastava duginih boja"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bandera de l’arc de Sant Martí"),
            keywords: &[
                "arc de Sant Martí",
                "bandera",
                "bandera de l’arc de Sant Martí",
            ],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄢𑄚\u{11134}𑄎\u{1112a}𑄚\u{11128} 𑄝𑄝\u{11127}𑄘"),
            keywords: &["𑄢𑄚\u{11134}𑄎\u{1112a}𑄚\u{11128} 𑄝𑄝\u{11127}𑄘"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏅᎪᎳᏛ ᎦᏓᏘ"),
            keywords: &["ᎤᏅᎪᎳᏛ", "ᎤᏅᎪᎳᏛ ᎦᏓᏘ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("duhová vlajka"),
            keywords: &["duha", "duhová vlajka", "prapor", "praporek", "vlajka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("baner enfys"),
            keywords: &["baner", "enfys", "pride"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("regnbueflag"),
            keywords: &["regnbue", "regnbueflag"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Regenbogenflagge"),
            keywords: &["Fahne", "Regenbogen", "Regenbogenflagge", "bunt"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σημαία ουράνιου τόξου"),
            keywords: &["ουράνιο τόξο", "σημαία ουράνιου τόξου"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("rainbow flag"),
            keywords: &["pride", "rainbow", "rainbow flag"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["pride", "rainbow", "rainbow flag"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["pride", "rainbow", "rainbow flag"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bandera del arcoíris"),
            keywords: &["arcoíris", "bandera", "bandera del arcoíris"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["arcoíris", "bandera", "bandera del arcoíris", "orgullo"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["arcoíris", "bandera", "bandera del arcoíris", "bandera gay"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("vikerkaarelipp"),
            keywords: &["lipp", "vikerkaar", "vikerkaarelipp"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ortzadarraren bandera"),
            keywords: &["harrotasuna", "ortzadarra", "ortzadarraren bandera"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پرچم رنگین\u{200c}کمان"),
            keywords: &["پرچم دگرباشان", "پرچم رنگین\u{200c}کمان"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("sateenkaarilippu"),
            keywords: &["liehuva", "lippu", "sateenkaari", "sateenkaarilippu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bahagharing bandila"),
            keywords: &[
                "bahaghari",
                "bahagharing bandila",
                "bandera",
                "bandila",
                "watawat",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("ælaboga flagg"),
            keywords: &["flagg", "ælaboga flagg", "ælabogi"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("drapeau arc-en-ciel"),
            keywords: &["arc-en-ciel", "drapeau"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bratach ildaite"),
            keywords: &["bratach", "ildaite"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bratach bogha-froise"),
            keywords: &["bogha-froise", "bratach bogha-froise"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("bandeira do arco da vella"),
            keywords: &[
                "LGTB",
                "arco da vella",
                "bandeira do arco da vella",
                "bisexual",
                "gai",
                "homosexual",
                "lesbiana",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સપ\u{acd}તર\u{a82}ગી ઝ\u{a82}ડો"),
            keywords: &["ઝ\u{a82}ડો", "સપ\u{acd}તર\u{a82}ગી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("tutar baƙangizo"),
            keywords: &["baƙangizo", "tutar baƙangizo"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("דגל בצבעי הקשת"),
            keywords: &["גאווה", "דגל", "דגל בצבעי הקשת", "קשת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("इ\u{902}द\u{94d}रधन\u{941}षी झ\u{902}डा"),
            keywords: &[
                "इ\u{902}द\u{94d}रधन\u{941}ष",
                "इ\u{902}द\u{94d}रधन\u{941}षी झ\u{902}डा",
                "झ\u{902}डा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zastava duginih boja"),
            keywords: &["duga", "zastava", "zastava duginih boja"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szivárványszínű zászló"),
            keywords: &["szivárvány", "szivárványszínű", "zászló"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ծիածանով դրոշ"),
            keywords: &["դրոշ", "ծիածան", "ծիածանով դրոշ"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("bandiera iride"),
            keywords: &[
                "arco del celo",
                "bandiera iride",
                "bandiera iris",
                "iride",
                "iris",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bendera pelangi"),
            keywords: &["bendera pelangi", "pelangi"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọkọlọtọ egwurugwu"),
            keywords: &["egwurugwu", "ọkọlọtọ egwurugwu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("regnbogafáni"),
            keywords: &[
                "fáni",
                "gay pride",
                "gleðiganga",
                "regnbogafáni",
                "regnbogi",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("bandiera arcobaleno"),
            keywords: &["Pride", "bandiera arcobaleno"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("レインボーフラッグ"),
            keywords: &[
                "LGBT",
                "フラグ",
                "フラッグ",
                "レインボーフラッグ",
                "旗",
                "虹色の旗",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("gendera plangi"),
            keywords: &["gendera plangi", "plangi"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ცისარტყელას დროშა"),
            keywords: &["ცისარტყელა", "ცისარტყელას დროშა"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("anay n teslit n unẓar"),
            keywords: &["anay n teslit n unẓar"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("кемпірқосақ түсті ту"),
            keywords: &["кемпірқосақ", "кемпірқосақ түсті ту", "ту"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("regnbueflag"),
            keywords: &["flag", "regnbue", "regnbueflag"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ទង\u{17cb}ឥន\u{17d2}ទធន\u{17bc}"),
            keywords: &[
                "ទង\u{17cb}ឥន\u{17d2}ទធន\u{17bc}",
                "មោទនភាព \u{200b}",
                "ឥន\u{17d2}ទធន\u{17bc}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಾಮನಬ\u{cbf}ಲ\u{ccd}ಲ\u{cbf}ನ ಧ\u{ccd}ವಜ"),
            keywords: &[
                "ಕಾಮನಬ\u{cbf}ಲ\u{ccd}ಲ\u{cbf}ನ ಧ\u{ccd}ವಜ",
                "ಕಾಮನಬ\u{cbf}ಲ\u{ccd}ಲು",
                "ಧ\u{ccd}ವಜ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("무지개 깃발"),
            keywords: &["깃발", "무지개"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("इ\u{902}द\u{94d}रधोण\u{942} बावटो"),
            keywords: &[
                "इ\u{902}द\u{94d}रधोण\u{942}",
                "इ\u{902}द\u{94d}रधोण\u{942} बावटो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("асан-үсөн желеги"),
            keywords: &["асан-үсөн желеги", "көк желе"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Reeboufändel"),
            keywords: &["Reebou", "Reeboufändel"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ທ\u{eb8}ງສາຍຮ\u{eb8}\u{ec9}ງ"),
            keywords: &[
                "ທ\u{eb8}ງ",
                "ທ\u{eb8}ງສາຍຮ\u{eb8}\u{ec9}ງ",
                "ສາຍຮ\u{eb8}\u{ec9}ງ",
                "ຮ\u{eb8}\u{ec9}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vaivorykštinė vėliava"),
            keywords: &["vaivorykštinė vėliava", "vaivorykštė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("varavīksnes karogs"),
            keywords: &["karogs", "varavīksne", "varavīksnes karogs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kara kahukura"),
            keywords: &["kahukura", "kara kahukura"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("знаме на виножитото"),
            keywords: &["виножито", "знаме", "знаме на виножитото"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മഴവിൽ പത\u{d3e}ക"),
            keywords: &["പത\u{d3e}ക", "മഴവിൽ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("солонгон туг"),
            keywords: &["солонго", "солонгон туг", "туг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("इ\u{902}द\u{94d}रधन\u{941}ष\u{94d}य ध\u{94d}वज"),
            keywords: &[
                "इ\u{902}द\u{94d}रधन\u{941}ष\u{94d}य",
                "इ\u{902}द\u{94d}रधन\u{941}ष\u{94d}य ध\u{94d}वज",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bendera pelangi"),
            keywords: &["bendera", "pelangi"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("bandiera tal-qawsalla"),
            keywords: &["bandiera tal-qawsalla", "qawsalla"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("သက\u{103a}တ\u{1036}ရောင\u{103a} အလ\u{1036}"),
            keywords: &[
                "သက\u{103a}တ\u{1036}",
                "သက\u{103a}တ\u{1036}ရောင\u{103a} အလ\u{1036}",
                "သက\u{103a}တ\u{1036}ရောင\u{103a}အလ\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("regnbueflagg"),
            keywords: &["flagg", "regnbue", "regnbueflagg"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("इन\u{94d}द\u{94d}र\u{947}णी झण\u{94d}डा"),
            keywords: &["इन\u{94d}द\u{94d}र\u{947}णी", "झण\u{94d}डा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("regenboogvlag"),
            keywords: &["regenboog", "regenboogvlag", "vlag"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("regnbogeflagg"),
            keywords: &["flagg", "regnboge", "regnbogeflagg"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଇନ\u{b4d}ଦ\u{b4d}ରଧନ\u{b41} ପତ\u{b3e}କ\u{b3e}"),
            keywords: &[
                "ଇନ\u{b4d}ଦ\u{b4d}ରଧନ\u{b41}",
                "ଇନ\u{b4d}ଦ\u{b4d}ରଧନ\u{b41} ପତ\u{b3e}କ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਤਰ\u{a70}ਗੀ ਪੀ\u{a02}ਘ ਝ\u{a70}ਡਾ"),
            keywords: &[
                "ਝ\u{a70}ਡਾ",
                "ਸਤਰ\u{a70}ਗੀ ਪੀ\u{a02}ਘ",
                "ਸਤਰ\u{a70}ਗੀ ਪੀ\u{a02}ਘ ਝ\u{a70}ਡਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("قوس\u{650} قزح آلا جھنڈا"),
            keywords: &["قوس قزح", "قوس\u{650} قزح آلا جھنڈا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Rénbo Flag"),
            keywords: &["Rénbo", "Rénbo Flag", "Wev"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("tęczowa flaga"),
            keywords: &["flaga", "tęcza", "tęczowa flaga"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د بوډۍ ټال بېرغ"),
            keywords: &["د بوډۍ تال بېرغ", "د بوډۍ ټال", "د بوډۍ ټال بېرغ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bandeira do arco-íris"),
            keywords: &["arco-íris", "bandeira", "bandeira do arco-íris"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("bandeira arco-íris"),
            keywords: &["arco-íris", "bandeira"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("k’uychi whipala"),
            keywords: &["k’uychi whipala"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("steag curcubeu"),
            keywords: &["curcubeu", "steag curcubeu"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1156"),
            keywords: &["E10-1156"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("радужный флаг"),
            keywords: &["радуга", "радужный флаг", "флаг"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibendera ry’amabara y’umukororombya"),
            keywords: &["ibendera ry’amabara y’umukororombya", "umukororombya"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("انڊلٺي جھنڊو"),
            keywords: &["انڊلٺ", "انڊلٺي جھنڊو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("දේද\u{dd4}න\u{dd4} කොඩ\u{dd2}ය"),
            keywords: &[
                "කොඩ\u{dd2}ය",
                "දේද\u{dd4}න\u{dca}න",
                "දේද\u{dd4}න\u{dd4} කොඩ\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("dúhová zástava"),
            keywords: &["dúha", "dúhová zástava", "vlajka", "zástava"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("mavrična zastava"),
            keywords: &["mavrica", "mavrična zastava", "zastava"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("calanka qaanso roobeed"),
            keywords: &["calanka qaanso roobeed", "qaanso roobeed"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("flamur i ylbertë"),
            keywords: &["flamur i ylbertë", "ylber"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("дугина застава"),
            keywords: &["вијори", "дуга", "дугина застава", "застава"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["дугина застава"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("dugina zastava"),
            keywords: &["duga", "dugina zastava", "vijori", "zastava"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["dugina zastava"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("regnbågsflagga"),
            keywords: &["flagga", "regnbåge", "regnbågsflagga"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("bendera ya upinde wa mvua"),
            keywords: &["bendera ya upinde wa mvua", "upinde wa mvua"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வ\u{bbe}னவில\u{bcd} கொடி"),
            keywords: &["கொடி", "வ\u{bbe}னவில\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఇంధ\u{c4d}రధనుస\u{c4d}సు పత\u{c3e}కం"),
            keywords: &["ఇంధ\u{c4d}రధనుస\u{c4d}సు", "పత\u{c3e}కం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("байрақи тирукамон"),
            keywords: &["байрақи тирукамон", "тирукамон"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ธงส\u{e35}ร\u{e38}\u{e49}ง"),
            keywords: &["ธง", "ธงส\u{e35}ร\u{e38}\u{e49}ง", "สายร\u{e38}\u{e49}ง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("älemgoşar baýdak"),
            keywords: &["älemgoşar", "älemgoşar baýdak"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fuka ʻūmata"),
            keywords: &["fuka", "ʻūmata"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("gökkuşağı bayrağı"),
            keywords: &["bayrak", "gökkuşağı", "gökkuşağı bayrağı"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ھەسەن-ھۈسەن بايراق"),
            keywords: &["ھەسەن-ھۈسەن", "ھەسەن-ھۈسەن بايراق"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("веселковий прапор"),
            keywords: &[
                "веселка",
                "веселковий",
                "веселковий прапор",
                "райдуга",
                "райдужний прапор",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("قوس قزح پرچم"),
            keywords: &["رینبو", "قوس قزح", "قوس قزح پرچم", "پرچم"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kamalak bayroq"),
            keywords: &["bayroq", "kamalak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cờ cầu vồng"),
            keywords: &["cầu vồng", "cờ cầu vồng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("raaya xon"),
            keywords: &["raaya xon", "xon"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iflegi yomnyama"),
            keywords: &["iflegi yomnyama", "umnyama"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àsíá olóṣùmarè"),
            keywords: &["àsíá olóṣùmarè", "òṣùmarè"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("彩虹旗"),
            keywords: &["彩虹", "彩虹旗", "自豪"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("彩虹旗"),
            keywords: &["彩虹", "彩虹旗"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("彩虹旗"),
            keywords: &["同性", "多色", "彩虹旗", "旗帜"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("彩虹旗"),
            keywords: &["彩虹旗"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("Ifulegi elimibalabala"),
            keywords: &["Ifulegi elimibalabala", "ifulegi", "okumbalabala"],
        },
    ],
};
#[doc = "🏳\u{fe0f}\u{200d}⚧\u{fe0f}"]
pub const TRANSGENDER_FLAG: crate::Emoji = crate::Emoji {
    glyph: "🏳\u{fe0f}\u{200d}⚧\u{fe0f}",
    codepoint: "1F3F3 FE0F 200D 26A7 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "transgender flag",
    group: "Flags",
    subgroup: "flag",
    is_variant: false,
    variants: &[
        crate::Emoji {
            glyph: "🏳\u{200d}⚧\u{fe0f}",
            codepoint: "1F3F3 200D 26A7 FE0F",
            status: crate::Status::Unqualified,
            introduction_version: 13f32,
            name: "transgender flag",
            group: "Flags",
            subgroup: "flag",
            is_variant: true,
            variants: &[],
            annotations: &[],
        },
        crate::Emoji {
            glyph: "🏳\u{fe0f}\u{200d}⚧",
            codepoint: "1F3F3 FE0F 200D 26A7",
            status: crate::Status::Unqualified,
            introduction_version: 13f32,
            name: "transgender flag",
            group: "Flags",
            subgroup: "flag",
            is_variant: true,
            variants: &[],
            annotations: &[],
        },
        crate::Emoji {
            glyph: "🏳\u{200d}⚧",
            codepoint: "1F3F3 200D 26A7",
            status: crate::Status::Unqualified,
            introduction_version: 13f32,
            name: "transgender flag",
            group: "Flags",
            subgroup: "flag",
            is_variant: true,
            variants: &[],
            annotations: &[],
        },
    ],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("transgendervlag"),
            keywords: &[
                "ligblou",
                "pienk",
                "transgender",
                "transgendervlag",
                "vlag",
                "wit",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሰማያዊ ፤ ሓምራዊ እና ነጭ ሰንደቅ"),
            keywords: &["ሰማያዊ ፤ ሓምራዊ እና ነጭ ሰንደቅ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("علم المتحولين جنسي\u{64b}ا"),
            keywords: &[
                "أبيض",
                "أزرق",
                "أزرق خفيف",
                "المتحولون جنسي\u{64b}ا",
                "المتحولين جنسي\u{64b}ا",
                "زهري",
                "علم",
                "علم المتحولين جنسي\u{64b}ا",
                "وردي",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কিন\u{9cd}নৰৰ পত\u{9be}ক\u{9be}"),
            keywords: &[
                "কিন\u{9cd}নৰ",
                "কিন\u{9cd}নৰৰ পত\u{9be}ক\u{9be}",
                "গোলপীয\u{9bc}\u{9be}",
                "পত\u{9be}ক\u{9be}",
                "প\u{9be}তল নীল\u{9be}",
                "বগ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("göy, çəhrayı və ağ bayraq"),
            keywords: &["bayraq", "göy, çəhrayı və ağ bayraq", "transgender"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("трансгендарны сцяг"),
            keywords: &[
                "белы",
                "блакітны",
                "ружовы",
                "сцяг",
                "трансгендар",
                "трансгендарны сцяг",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("знаме в синьо, розово и бяло"),
            keywords: &[
                "бяло",
                "знаме",
                "знаме в синьо, розово и бяло",
                "розово",
                "светлосиньо",
                "транссексуален",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ট\u{9cd}র\u{9be}ন\u{9cd}সজেন\u{9cd}ড\u{9be}র ফ\u{9cd}ল\u{9cd}য\u{9be}গ"),
            keywords: &[
                "গোল\u{9be}পী",
                "ট\u{9cd}র\u{9be}ন\u{9cd}সজেন\u{9cd}ড\u{9be}র",
                "ট\u{9cd}র\u{9be}ন\u{9cd}সজেন\u{9cd}ড\u{9be}র ফ\u{9cd}ল\u{9cd}য\u{9be}গ",
                "পত\u{9be}ক\u{9be}",
                "স\u{9be}দ\u{9be}",
                "হ\u{9be}লক\u{9be} নীল",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("banniel treuzjener"),
            keywords: &["banniel", "banniel treuzjener"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zastava pokreta transrodnih osoba"),
            keywords: &[
                "bijela",
                "roze",
                "svijetloplava",
                "transrodnost",
                "zastava pokreta transrodnih osoba",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bandera transgènere"),
            keywords: &[
                "bandera",
                "blanc",
                "blau cel",
                "rosa",
                "trans",
                "transgènere",
            ],
        },
        #[cfg(feature = "ceb")]
        crate::Annotation {
            lang: "ceb",
            tts: Some("flag sa transgender"),
            keywords: &[
                "flag",
                "flag sa transgender",
                "hanap nga asul",
                "pink",
                "puti",
                "transgender",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏌᎪᏂᎨ, ᎩᎦᎨ ᎤᏍᎪᎸ, ᎠᎴ ᎤᏁᎦ ᎦᏓᏘ"),
            keywords: &["ᎦᏓᏘ", "ᏄᏬᎵᏍᏛᎾ", "ᏌᎪᏂᎨ, ᎩᎦᎨ ᎤᏍᎪᎸ, ᎠᎴ ᎤᏁᎦ ᎦᏓᏘ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("vlajka trans hrdosti"),
            keywords: &[
                "bílá",
                "růžová",
                "světle modrá",
                "transgender",
                "vlajka",
                "vlajka trans hrdosti",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("baner las, pinc a gwyn"),
            keywords: &["baner", "baner las, pinc a gwyn", "trawsryweddol"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("transkønnet flag"),
            keywords: &["flag", "transkønnet"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Transgender-Flagge"),
            keywords: &["Flagge", "Transgender", "Transgender-Flagge"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Transgenderflagge"),
            keywords: &[
                "Flagge",
                "Transgender",
                "Transgenderflagge",
                "hellblau",
                "pink",
                "weiss",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σημαία των διεμφυλικών"),
            keywords: &[
                "γαλάζιο",
                "διεμφυλικός",
                "λευκό",
                "ροζ",
                "σημαία",
                "σημαία των διεμφυλικών",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("transgender flag"),
            keywords: &["flag", "light blue", "pink", "transgender", "white"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &[
                "flag",
                "light blue",
                "pink",
                "trans",
                "transgender",
                "white",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &[
                "flag",
                "light blue",
                "pink",
                "trans",
                "transgender",
                "white",
            ],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bandera transgénero"),
            keywords: &["LGTB", "azul", "bandera", "blanco", "rosa", "transgénero"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "LGTB",
                "bandera",
                "blanco",
                "celeste",
                "rosa",
                "transgénero",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("transsoolisuse lipp"),
            keywords: &[
                "helesinine",
                "lipp",
                "roosa",
                "transsoolisus",
                "transsoolisuse lipp",
                "valge",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bandera transgeneroa"),
            keywords: &["bandera", "transgeneroa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پرچم تراجنسیتی"),
            keywords: &["آبی روشن", "تراجنسیتی", "سفید", "صورتی", "پرچم"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("translippu"),
            keywords: &["lippu", "trans", "translippu", "transsukupuolinen"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bandila ng transgender"),
            keywords: &[
                "asul",
                "bandila",
                "bandila ng transgender",
                "pink",
                "puti",
                "transgender",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("tvørkynd flagg"),
            keywords: &[
                "blátt, ljósareytt og hvítt flagg",
                "flagg",
                "tvørkyn",
                "tvørkynd",
                "tvørkyndur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("drapeau transgenre"),
            keywords: &[
                "blanc",
                "bleu clair",
                "drapeau transgenre",
                "rose",
                "transgenre",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("drapeau transgenre"),
            keywords: &["blanc", "bleu pâle", "drapeau", "rose", "transgenre"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bratach ghorm, bhándearg agus bhán"),
            keywords: &["bratach ghorm, bhándearg agus bhán"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bratach ghorm, phinc is gheal"),
            keywords: &[
                "bratach",
                "bratach ghorm, phinc is gheal",
                "geal",
                "gorm",
                "pinc",
                "tar-ghnèitheach",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("bandeira transxénero"),
            keywords: &[
                "azul",
                "bandeira transxénero",
                "branco",
                "rosa",
                "transexual",
                "transxénero",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ટ\u{acd}રાન\u{acd}સજ\u{ac7}ન\u{acd}ડર ધ\u{acd}વજ"),
            keywords: &[
                "ગ\u{ac1}લાબી",
                "ટ\u{acd}રાન\u{acd}સજ\u{ac7}ન\u{acd}ડર",
                "ધ\u{acd}વજ",
                "બ\u{acd}લ\u{acd}ય\u{ac2}",
                "સફ\u{ac7}દ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("דגל טרנסג׳נדר"),
            keywords: &["דגל", "טרנסג׳נדר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ट\u{94d}रा\u{902}सज\u{947}\u{902}डर झ\u{902}डा"),
            keywords: &["झ\u{902}डा", "ट\u{94d}रा\u{902}सज\u{947}\u{902}डर"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zastava pokreta transrodnih osoba"),
            keywords: &[
                "bijela",
                "ružičasta",
                "svjetloplava",
                "transrodne osobe",
                "zastava",
                "zastava pokreta transrodnih osoba",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("transznemű zászló"),
            keywords: &["transznemű", "zászló"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տրանսգենդերի դրոշ"),
            keywords: &[
                "բաց կապույտ",
                "դրոշ",
                "սպիտակ",
                "վարդագույն",
                "տրանսգենդեր",
                "տրանսգենդերի դրոշ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bendera transgender"),
            keywords: &["bendera", "biru muda", "merah muda", "putih", "transgender"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("transfáni"),
            keywords: &[
                "bleikur",
                "fáni",
                "hvítur",
                "ljósblár",
                "trans",
                "transfáni",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("bandiera transgender"),
            keywords: &["azzurro", "bandiera", "bianco", "rosa", "transgender"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("トランスジェンダーフラッグ"),
            keywords: &[
                "LGBT",
                "TG",
                "トランスジェンダー",
                "トランスジェンダーフラッグ",
                "フラグ",
                "フラッグ",
                "旗",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("gendera wariya"),
            keywords: &["abang enom", "biru enom", "gendera", "putih", "wariya"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ტრანსგენდერი დროშა"),
            keywords: &["დროშა", "ვარდისფერი", "თეთრი", "ტრანსგენდერი", "ცისფერი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("көк, қызғылт және ақ жалау"),
            keywords: &["жалау", "көк, қызғылт және ақ жалау", "трансгендер"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ទង\u{17cb}ជ\u{17d0}យភេទទ\u{17b8}ប\u{17b8}"),
            keywords: &[
                "ខៀវស\u{17d2}រាល",
                "ទង\u{17cb}ជ\u{17d0}យ",
                "ទង\u{17cb}ជ\u{17d0}យភេទទ\u{17b8}ប\u{17b8}",
                "ផ\u{17d2}កាឈ\u{17bc}ក",
                "ភេទទ\u{17b8}ប\u{17b8}",
                "ស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಟ\u{ccd}ರಾನ\u{ccd}ಸ\u{ccd}ಜ\u{cc6}ಂಡರ\u{ccd} ಧ\u{ccd}ವಜ"),
            keywords: &["ಟ\u{ccd}ರಾನ\u{ccd}ಸ\u{ccd}ಜ\u{cc6}ಂಡರ\u{ccd} ಧ\u{ccd}ವಜ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("트랜스젠더 깃발"),
            keywords: &["깃발", "분홍색", "트랜스젠더", "하늘색", "하얀색"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("निळो, ग\u{941}लाबी आनी धवो बावटो"),
            keywords: &[
                "ग\u{941}लाबी",
                "ट\u{94d}रान\u{94d}सज\u{947}न\u{94d}डर",
                "त\u{943}तियप\u{902}थी",
                "धवो",
                "निळो",
                "निळो, ग\u{941}लाबी आनी धवो बावटो",
                "बावटो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("трансгендер желеги"),
            keywords: &["трансгендер желеги"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb5}ຟ\u{ec9}າ, ສ\u{eb5}ບ\u{ebb}ວ, ແລະ ທ\u{eb8}ງຂາວ"),
            keywords: &[
                "ຄ\u{ebb}ນຂ\u{ec9}າມເພດ",
                "ທ\u{eb8}ງ",
                "ສ\u{eb5}ຂາວ",
                "ສ\u{eb5}ບ\u{ebb}ວ",
                "ສ\u{eb5}ບ\u{ebb}ວອ\u{ec8}ອນ",
                "ສ\u{eb5}ຟ\u{ec9}າ, ສ\u{eb5}ບ\u{ebb}ວ, ແລະ ທ\u{eb8}ງຂາວ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žydra, rožinė ir balta vėliava"),
            keywords: &["translytis", "vėliava", "žydra, rožinė ir balta vėliava"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zils, rozā un balts karogs"),
            keywords: &[
                "balts",
                "gaiši zils",
                "karogs",
                "rozā",
                "transpersonu",
                "zils, rozā un balts karogs",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("сино-розово-бело знаме"),
            keywords: &["знаме", "сино-розово-бело знаме", "трансродови"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("നീല, പിങ\u{d4d}ക\u{d4d}, വെള\u{d4d}ള പത\u{d3e}ക"),
            keywords: &[
                "ഇളം നീല",
                "നീല, പിങ\u{d4d}ക\u{d4d}, വെള\u{d4d}ള പത\u{d3e}ക",
                "പത\u{d3e}ക",
                "പിങ\u{d4d}ക\u{d4d}",
                "ഭിന\u{d4d}നലിംഗം",
                "വെള\u{d4d}ള",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("трансжендер туг"),
            keywords: &["трансжендер", "туг", "цагаан", "цайвар цэнхэр", "ягаан"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ट\u{94d}रान\u{94d}सज\u{947}\u{902}डर ध\u{94d}वज"),
            keywords: &[
                "ग\u{941}लाबी",
                "ट\u{94d}रान\u{94d}सज\u{947}\u{902}डर",
                "ध\u{94d}वज",
                "निळा",
                "पा\u{902}ढरा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bendera biru,merah jambu, dan putih"),
            keywords: &[
                "bendera",
                "bendera biru,merah jambu, dan putih",
                "biru muda",
                "merah jambu",
                "putih",
                "transgender",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "လ\u{102d}င\u{103a}ပြောင\u{103a}းသ\u{1030}က\u{102d}\u{102f}ယ\u{103a}စားပြ\u{102f} အလ\u{1036}",
            ),
            keywords: &[
                "ပန\u{103a}းရောင\u{103a}",
                "လ\u{102d}င\u{103a}ပြောင\u{103a}းထားသ\u{1030}",
                "လ\u{102d}င\u{103a}ပြောင\u{103a}းသ\u{1030}က\u{102d}\u{102f}ယ\u{103a}စားပြ\u{102f} အလ\u{1036}",
                "အပြာဖျော\u{1037}ရောင\u{103a}",
                "အဖြ\u{1030}ရောင\u{103a}",
                "အလ\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("transpersonflagg"),
            keywords: &[
                "flagg",
                "hvit",
                "lyseblå",
                "rosa",
                "transperson",
                "transpersonflagg",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ट\u{94d}रान\u{94d}सज\u{947}न\u{94d}डर झण\u{94d}डा"),
            keywords: &[
                "ग\u{941}लाबी",
                "झण\u{94d}डा",
                "ट\u{94d}रान\u{94d}सज\u{947}न\u{94d}डर",
                "स\u{947}तो",
                "हल\u{94d}\u{200d}का निलो",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("transgendervlag"),
            keywords: &[
                "lichtblauw",
                "roze",
                "transgender",
                "transgendervlag",
                "vlag",
                "wit",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("transpersonflagg"),
            keywords: &[
                "flagg",
                "kit",
                "lyseblå",
                "rosa",
                "transperson",
                "transpersonflagg",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b4d}ଲୀବଲ\u{b3f}ଙ\u{b4d}ଗ ପତ\u{b3e}କ\u{b3e}"),
            keywords: &["କ\u{b4d}ଲୀବଲ\u{b3f}ଙ\u{b4d}ଗ ପତ\u{b3e}କ\u{b3e}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਟਰਾ\u{a02}ਸਜ\u{a48}\u{a02}ਡਰ ਝ\u{a70}ਡਾ"),
            keywords: &[
                "ਗ\u{a41}ਲਾਬੀ",
                "ਝ\u{a70}ਡਾ",
                "ਟਰਾ\u{a02}ਸਜ\u{a48}\u{a02}ਡਰ",
                "ਸਫ\u{a3c}\u{a48}ਦ",
                "ਹਲਕਾ ਨੀਲਾ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Transjẹ\u{301}nda Flag"),
            keywords: &["Flag", "Laít Blu", "Pink", "Transjẹ\u{301}nda", "Wait"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("flaga osób transpłciowych"),
            keywords: &["flaga", "flaga osób transpłciowych", "transpłciowość"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("آسماني رنګ، ګلابي، او سپينه بېرغ"),
            keywords: &["آسماني رنګ، ګلابي، او سپينه بېرغ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bandeira transgênero"),
            keywords: &["azul claro", "bandeira", "branco", "rosa", "transgênero"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("bandeira transgénero"),
            keywords: &["azul clara", "bandeira", "branca", "rosa", "transgénero"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("steag transgender"),
            keywords: &["alb", "albastru deschis", "roz", "steag", "transgender"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-076"),
            keywords: &["E13-076"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("флаг трансгендерного сообщества"),
            keywords: &[
                "белый",
                "розовый",
                "светло-голубой",
                "трансгендер",
                "флаг",
                "флаг трансгендерного сообщества",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("نيرو، گلابي، ۽ اڇي جهنڊي"),
            keywords: &[
                "اڇو",
                "جهنڊو",
                "نيرو، گلابي، ۽ اڇي جهنڊي",
                "هلڪو نيرو",
                "وچ جنس",
                "گلابي",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සංක\u{dca}\u{200d}ර\u{dcf}න\u{dca}ත\u{dd2} ල\u{dd2}ංග\u{dd2}ක කොඩ\u{dd2}ය"),
            keywords: &[
                "කොඩ\u{dd2}ය",
                "රෝස",
                "ල\u{dcf} න\u{dd2}ල\u{dca}",
                "සංක\u{dca}\u{200d}ර\u{dcf}න\u{dca}ත\u{dd2} ල\u{dd2}ංග\u{dd2}ක",
                "සංක\u{dca}\u{200d}ර\u{dcf}න\u{dca}ත\u{dd2} ල\u{dd2}ංග\u{dd2}ක කොඩ\u{dd2}ය",
                "ස\u{dd4}ද\u{dd4}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("transgenderová zástava"),
            keywords: &[
                "biela",
                "ružová",
                "svetlomodrá",
                "transgender",
                "transgenderová zástava",
                "vlajka",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("transspolna zastava"),
            keywords: &[
                "bela",
                "rožnata",
                "svetlo modra",
                "transspolna zastava",
                "transspolnost",
                "zastava",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("calanka laba dhidiga"),
            keywords: &[
                "baluug qafiif ah",
                "binki",
                "cadaan",
                "calan",
                "calanka laba dhidiga",
                "laba dhadig",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("flamur blu, rozë dhe i bardhë"),
            keywords: &[
                "blu i hapur",
                "flamur",
                "flamur blu, rozë dhe i bardhë",
                "i bardhë",
                "rozë",
                "transgjinor",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("трансродна зазстава"),
            keywords: &[
                "бела",
                "застава",
                "пинк",
                "светлоплава",
                "трансродна зазстава",
                "трансродно",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("трансродна застава"),
            keywords: &["трансродна застава"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("transrodna zazstava"),
            keywords: &[
                "bela",
                "pink",
                "svetloplava",
                "transrodna zazstava",
                "transrodno",
                "zastava",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("transrodna zastava"),
            keywords: &["transrodna zastava"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("transflagga"),
            keywords: &["flagga", "transflagga", "transgender"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("bendera ya wageuza jinsia"),
            keywords: &[
                "bendera",
                "bendera ya wageuza jinsia",
                "buluu isiyokolea",
                "nyeupe",
                "wageuza jinsia",
                "waridi",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("திருநங\u{bcd}கைக\u{bcd} கொடி"),
            keywords: &[
                "இளஞ\u{bcd}சிவப\u{bcd}பு",
                "கொடி",
                "திருநங\u{bcd}கை",
                "திருநங\u{bcd}கைக\u{bcd} கொடி",
                "வெளிர\u{bcd} ந\u{bc0}லம\u{bcd}",
                "வெள\u{bcd}ளை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ల\u{c3f}ంగమ\u{c3e}ర\u{c4d}ప\u{c3f}డ\u{c3f} జ\u{c46}ండ\u{c3e}"),
            keywords: &[
                "జ\u{c46}ండ\u{c3e}",
                "త\u{c46}లుపు",
                "ప\u{c3f}ంక\u{c4d}",
                "ల\u{c3f}ంగమ\u{c3e}ర\u{c4d}ప\u{c3f}డ\u{c3f}",
                "ల\u{c47}త న\u{c40}లం రంగు",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ธงคนข\u{e49}ามเพศ"),
            keywords: &[
                "คนข\u{e49}ามเพศ",
                "ธง",
                "ธงคนข\u{e49}ามเพศ",
                "ส\u{e35}ขาว",
                "ส\u{e35}ชมพ\u{e39}",
                "ส\u{e35}ฟ\u{e49}า",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("transseksual baýdagy"),
            keywords: &[
                "ak",
                "baýdak",
                "gülgüne",
                "solak gök",
                "transseksual",
                "transseksual baýdagy",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fuka pulū-pingikē-hinehina"),
            keywords: &["fuka", "pulū-pingikē-hinehina"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("transgender bayrağı"),
            keywords: &[
                "açık mavi",
                "bayrak",
                "beyaz",
                "pembe",
                "transgender",
                "transgender bayrağı",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("прапор трансгендерів"),
            keywords: &[
                "блакитний",
                "білий",
                "прапор",
                "прапор трансгендерів",
                "рожевий",
                "трансгендер",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ٹرانزینڈر پرچم"),
            keywords: &["سفید", "نیلی روشنی", "ٹرانزینڈر", "پرچم", "گلابی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("moviy, pushti va oq bayroq"),
            keywords: &[
                "bayroq",
                "moviy, pushti va oq bayroq",
                "transgender",
                "transseksual",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cờ màu xanh, hồng và trắng"),
            keywords: &["cờ", "cờ màu xanh, hồng và trắng", "người chuyển giới"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("藍色、粉紅色同白色嘅旗"),
            keywords: &["旗", "藍色、粉紅色同白色嘅旗", "跨性別人士"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("蓝色、粉红色同白色嘅旗"),
            keywords: &["旗", "蓝色、粉红色同白色嘅旗", "跨性别人士"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("跨性别旗"),
            keywords: &["旗帜", "跨性别", "跨性别旗"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("跨性別旗"),
            keywords: &["旗子", "變性", "跨性別旗"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ifulegi eli-blue, pink nokumhlophe"),
            keywords: &[
                "i-transgender",
                "ifulegi",
                "ifulegi eli-blue, pink nokumhlophe",
            ],
        },
    ],
};
#[doc = "🏴\u{200d}☠\u{fe0f}"]
pub const PIRATE_FLAG: crate::Emoji = crate::Emoji {
    glyph: "🏴\u{200d}☠\u{fe0f}",
    codepoint: "1F3F4 200D 2620 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "pirate flag",
    group: "Flags",
    subgroup: "flag",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🏴\u{200d}☠",
        codepoint: "1F3F4 200D 2620",
        status: crate::Status::MinimallyQualified,
        introduction_version: 11f32,
        name: "pirate flag",
        group: "Flags",
        subgroup: "flag",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("seerowervlag"),
            keywords: &["Jolly Roger", "plunder", "seerower", "seerowervlag", "skat"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የባሕር ወንበዴ ሰንደቅ"),
            keywords: &["ማዕድን", "ምርኮ", "የባሕር ወንበዴ", "የባሕር ወንበዴ ሰንደቅ", "ጆሊ ሮጀር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("علم قراصنة"),
            keywords: &["جولي روجر", "علم قراصنة", "قراصنة", "قرصنة", "كنز", "كنوز"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("জলদস\u{9cd}য\u{9c1}ৰ পত\u{9be}ক\u{9be}"),
            keywords: &[
                "গ\u{9c1}প\u{9cd}তধনৰ ভ\u{981}ৰ\u{9be}ল",
                "জলদস\u{9cd}য\u{9c1}",
                "জলদস\u{9cd}য\u{9c1}ৰ পত\u{9be}ক\u{9be}",
                "জ’লী ৰ’জ\u{9be}ৰ",
                "ল\u{9c1}টপ\u{9be}ট",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("quldur bayrağı"),
            keywords: &[
                "cəvahirat",
                "pirat",
                "quldur",
                "quldur bayrağı",
                "Şən Roger",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("пірацкі сцяг"),
            keywords: &["Вясёлы Роджар", "пірат", "пірацкі сцяг", "разбой", "скарбы"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("пиратски флаг"),
            keywords: &[
                "Веселия Роджър",
                "грабежи",
                "пират",
                "пиратски флаг",
                "съкровище",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("জলদস\u{9cd}য\u{9c1} পত\u{9be}ক\u{9be}"),
            keywords: &[
                "জলদস\u{9cd}য\u{9c1}",
                "জলদস\u{9cd}য\u{9c1} পত\u{9be}ক\u{9be}",
                "জলি রজ\u{9be}র",
                "ধন",
                "ল\u{9c1}ণ\u{9cd}ঠন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("banniel ar vorlaeron"),
            keywords: &["banniel", "banniel ar vorlaeron"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("piratska zastava"),
            keywords: &[
                "blago",
                "jolly roger",
                "pirati",
                "piratska zastava",
                "pljačka",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bandera pirata"),
            keywords: &["Jolly Roger", "bandera pirata", "botí", "pirata", "tresor"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏥᏳᎡᏙᎯ ᎠᏓᏌᎲᏍᎩ ᎦᏓᏗ"),
            keywords: &[
                "ᎠᏓᎩᎡᏗ",
                "ᎤᎵᎦᎵᏍᏗ ᎳᏥ",
                "ᏥᏳᎡᏙᎯ ᎠᏓᏌᎲᏍᎩ",
                "ᏥᏳᎡᏙᎯ ᎠᏓᏌᎲᏍᎩ ᎦᏓᏗ",
                "ᏧᎬᏩᎶᏗ ᎠᏍᏆᏂᎪᏛ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("pirátská vlajka"),
            keywords: &["hnáty", "lebka", "pirát", "pirátská vlajka", "poklad"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("baner môr-leidr"),
            keywords: &[
                "Jolly Roger",
                "baner môr-leidr",
                "môr-leidr",
                "trysor",
                "ysbeilio",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("piratflag"),
            keywords: &[
                "pirat",
                "piratflag",
                "plyndre",
                "skat",
                "sørøver",
                "sørøverflag",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Piratenflagge"),
            keywords: &[
                "Jolly Roger",
                "Pirat",
                "Piratenfahne",
                "Piratenflagge",
                "Schatz",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πειρατική σημαία"),
            keywords: &[
                "Τζόλι Ρότζερ",
                "θησαυρός",
                "λάφυρα",
                "πειρατής",
                "πειρατική σημαία",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("pirate flag"),
            keywords: &[
                "Jolly Roger",
                "pirate",
                "pirate flag",
                "plunder",
                "treasure",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bandera pirata"),
            keywords: &["Jolly Roger", "bandera pirata", "botín", "pirata", "tesoro"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("bandera pirata"),
            keywords: &[
                "Jolly Roger",
                "bandera pirata",
                "botín",
                "calavera",
                "pirata",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("bandera pirata"),
            keywords: &["bandera pirata"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("piraadilipp"),
            keywords: &["piraadilipp", "piraat", "röövimine", "varandus"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("piraten bandera"),
            keywords: &[
                "Jolly Roger",
                "altxor",
                "arpilatze",
                "pirata",
                "piraten bandera",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پرچم دزدان دریایی"),
            keywords: &[
                "جولی راجر",
                "دزدان دریایی",
                "غارت",
                "پرچم دزدان دریایی",
                "چپاول",
                "گنج",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("merirosvolippu"),
            keywords: &[
                "aarre",
                "lippu",
                "merirosvolippu",
                "pääkallolippu",
                "rosvous",
                "ryöstö",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bandila ng pirata"),
            keywords: &[
                "Jolly Roger",
                "bandila ng pirata",
                "kayamanan",
                "magnanakaw",
                "pirata",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sjórænaraflagg"),
            keywords: &[
                "Jolly Roger",
                "rán",
                "sjórán",
                "sjórænaraflagg",
                "sjórænari",
                "skattur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("drapeau de pirate"),
            keywords: &["drapeau de pirate", "pillage", "piller", "pirate", "trésor"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bratach foghlaithe"),
            keywords: &[
                "Jolly Roger",
                "argain",
                "bratach foghlaithe",
                "foghlaí",
                "seoid",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bratach spùinneadair"),
            keywords: &[
                "Jolly Roger",
                "bratach spùinneadair",
                "creach",
                "spùinn",
                "spùinneadair",
                "ulaidh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("bandeira pirata"),
            keywords: &["bandeira pirata", "pillaxe", "pirata", "saqueo", "tesouro"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પાઇર\u{ac7}ટ ધ\u{acd}વજ"),
            keywords: &[
                "ખજાનો",
                "ચા\u{a82}ચિયો",
                "જોલી રોજર",
                "પાઇર\u{ac7}ટ ધ\u{acd}વજ",
                "લ\u{ac2}\u{a82}ટ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("דגל פירטים"),
            keywords: &["דגל פירטים", "מטמון", "פיראטים", "שודדי ים", "תיבת אוצר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सम\u{941}द\u{94d}री दस\u{94d}य\u{941} का झ\u{902}डा"),
            keywords: &[
                "खजाना",
                "जॉली रोजर",
                "ल\u{942}ट",
                "सम\u{941}द\u{94d}री डाक\u{942}",
                "सम\u{941}द\u{94d}री दस\u{94d}य\u{941} का झ\u{902}डा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("gusarska zastava"),
            keywords: &["Jolly Roger", "blago", "gusar", "gusarska zastava"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kalózzászló"),
            keywords: &["Jolly Roger", "fosztogató", "kalóz", "kalózzászló", "kincs"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ծովահենների դրոշ"),
            keywords: &[
                "Ուրախ Ռոջեր",
                "գանձ",
                "ծովահեն",
                "ծովահենների դրոշ",
                "կողոպուտ",
            ],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("bandiera de pirata"),
            keywords: &[
                "bandiera de pirata",
                "cranio",
                "ossos",
                "piliage",
                "pirata",
                "tresor",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bendera bajak laut"),
            keywords: &[
                "Jolly Roger",
                "bajak",
                "bajak laut",
                "bendera bajak laut",
                "harta karun",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sjóræningjafáni"),
            keywords: &[
                "fjársjóður",
                "hausk´úpuflagg",
                "ræna og rupla",
                "sjóræningi",
                "sjóræningjafáni",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("bandiera dei pirati"),
            keywords: &[
                "bandiera dei pirati",
                "corsari",
                "corsaro",
                "pirata",
                "pirati",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("海賊旗"),
            keywords: &["ジョリー・ロジャー", "宝物", "海賊", "海賊旗", "略奪"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("gendera begal segara"),
            keywords: &[
                "Jolly Roger",
                "bandhane karun",
                "begal segara",
                "gendera begal segara",
                "jarah",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მეკობრეთა დროშა"),
            keywords: &[
                "განძი",
                "მეკობრე",
                "მეკობრეთა დროშა",
                "მხიარული როჯერი",
                "ჩონჩხი და თავის ქალა",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қарақшы жалауы"),
            keywords: &[
                "тонау",
                "Қара қарақшы жалауы",
                "қазына",
                "қарақшы",
                "қарақшы жалауы",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ទង\u{17cb}ចោរសម\u{17bb}ទ\u{17d2}រ"),
            keywords: &[
                "Jolly Roger",
                "ការល\u{17bd}ចប\u{17d2}លន\u{17cb}",
                "ក\u{17c6}ណប\u{17cb}",
                "ចោរសម\u{17bb}ទ\u{17d2}រ",
                "ទង\u{17cb}ចោរសម\u{17bb}ទ\u{17d2}រ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ದರೋಡ\u{cc6}ಕೋರರ ಧ\u{ccd}ವಜ"),
            keywords: &[
                "ಜಾಲ\u{cbf} ರೋಜರ\u{ccd}",
                "ದರೋಡ\u{cc6}ಕೋರ",
                "ದರೋಡ\u{cc6}ಕೋರರ ಧ\u{ccd}ವಜ",
                "ನ\u{cbf}ಧ\u{cbf}",
                "ಲ\u{cc2}ಟ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("해적 깃발"),
            keywords: &["보물섬", "약탈자", "해골 깃발", "해적", "해적 깃발"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("चाच\u{94d}य\u{947} बावटो"),
            keywords: &[
                "चाच\u{94d}य\u{947} बावटो",
                "च\u{94d}याच\u{947}",
                "च\u{94d}याच\u{94d}या\u{902}चो बावटो",
                "जॉली रोजर",
                "तिजोरी",
                "प\u{94d}ल\u{902}डर",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("каракчылардын желеги"),
            keywords: &["каракчы", "каракчылардын желеги", "кенч", "пират", "тоноо"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ທ\u{eb8}ງໂຈນສະລ\u{eb1}ດ"),
            keywords: &[
                "ຂ\u{eb8}ມຊ\u{eb1}ບ",
                "ທ\u{eb8}ງໂຈນສະລ\u{eb1}ດ",
                "ປ\u{eb9}\u{ec9}ນ",
                "ໂຈນສະລ\u{eb1}ດ",
                "ໂລໂກຫ\u{ebb}ວກະໂຫ\u{ebc}ກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("piratų vėliava"),
            keywords: &[
                "Linksmasis Rodžeris",
                "lobis",
                "piratas",
                "piratų vėliava",
                "plėšikauti",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pirātu karogs"),
            keywords: &["bagātības", "laupījums", "pirāts", "pirātu karogs"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("пиратско знаме"),
            keywords: &["богатство", "грабеж", "пират", "пиратско знаме"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പൈറേറ\u{d4d}റ\u{d4d} പത\u{d3e}ക"),
            keywords: &[
                "കടൽക\u{d4d}കൊള\u{d4d}ളക\u{d4d}ക\u{d3e}രൻ",
                "കൊള\u{d4d}ളയടി",
                "ജോളി റോജർ",
                "നിധി",
                "പൈറേറ\u{d4d}റ\u{d4d} പത\u{d3e}ക",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("далайн дээрэмчний туг"),
            keywords: &[
                "Жолли Рожер",
                "далайн дээрэмчин",
                "далайн дээрэмчний туг",
                "тонох",
                "үнэт эрдэнэс",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पायर\u{947}ट फ\u{94d}ल\u{945}ग"),
            keywords: &[
                "जॉली रॉजर",
                "ट\u{94d}र\u{947}झर",
                "पायर\u{947}ट",
                "पायर\u{947}ट फ\u{94d}ल\u{945}ग",
                "प\u{94d}ल\u{902}डर",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bendera lanun"),
            keywords: &[
                "Jolly Roger",
                "bendera lanun",
                "harta karun",
                "lanun",
                "rampasan",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပင\u{103a}လယ\u{103a}ဓားပြ အလ\u{1036}"),
            keywords: &[
                "ဂျ\u{102d}\u{102f}လ\u{102e}ရော\u{103a}ဂျာ",
                "ပင\u{103a}လယ\u{103a}ဓားပြ",
                "ပင\u{103a}လယ\u{103a}ဓားပြ အလ\u{1036}",
                "ရတနာ",
                "လ\u{102f}ယက\u{103a}ပစ\u{1039}စည\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sjørøverflagg"),
            keywords: &[
                "Kaptein Sabeltann",
                "pirat",
                "plyndre",
                "sjørøverflagg",
                "skatt",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("डा\u{901}काको झन\u{94d}डा"),
            keywords: &[
                "खजाना",
                "जोली रोजर",
                "डा\u{901}का",
                "डा\u{901}काको झन\u{94d}डा",
                "प\u{94d}लन\u{94d}डर",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("piratenvlag"),
            keywords: &["Jolly Roger", "piraat", "piratenvlag", "plunderen", "schat"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("sjørøvarflagg"),
            keywords: &[
                "Kaptein Sabeltann",
                "pirat",
                "plyndre",
                "sjørøvarflagg",
                "skatt",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଜଳ ଦସ\u{b4d}ୟ\u{b41} ଙ\u{b4d}କ ପତ\u{b3e}କ\u{b3e}"),
            keywords: &[
                "କୋଷ\u{b3e}ଧ\u{b4d}ୟକ\u{b4d}ଷ",
                "ଜଳ ଦସ\u{b4d}ୟ\u{b41} ଙ\u{b4d}କ ପତ\u{b3e}କ\u{b3e}",
                "ଜଳଦସ\u{b4d}ୟ\u{b41}",
                "ଜୋଲୀ ରୋଜର",
                "ଲ\u{b41}ଟ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲ\u{a41}ਟ\u{a47}ਰਿਆ\u{a02} ਦਾ ਝ\u{a70}ਡਾ"),
            keywords: &[
                "ਖਜਾਨਾ",
                "ਜ\u{a4b}ਲੀ ਰ\u{a4b}ਜ\u{a3c}ਰ",
                "ਲ\u{a41}ਟ\u{a47}ਰਿਆ\u{a02} ਦਾ ਝ\u{a70}ਡਾ",
                "ਲ\u{a41}\u{a71}ਟ",
                "ਸਮ\u{a41}\u{a70}ਦਰੀ ਡਾਕ\u{a42}",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Paíret Flag"),
            keywords: &[
                "Jọlí Rója",
                "Paíret",
                "Paíret Flag",
                "Trẹ\u{301}zhọ",
                "Ám-Rọ\u{301}biri",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("piracka flaga"),
            keywords: &[
                "Jolly Roger",
                "czaszka i kości",
                "piraci",
                "piracka flaga",
                "pirat",
                "skarb",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د بحري ډاکوانو بېرغ"),
            keywords: &[
                "بحري ډاکو",
                "جولي راجر",
                "خزانه",
                "د بحري ډاکوانو بېرغ",
                "لوټ کول",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bandeira de pirata"),
            keywords: &[
                "bandeira de pirata",
                "caveira e osso",
                "pirata",
                "saque",
                "tesouro",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("bandeira pirata"),
            keywords: &["bandeira pirata", "perna-de-pau", "pirata", "tesouro"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("steagul piraților"),
            keywords: &[
                "comoară",
                "pirați",
                "pradă",
                "steag cu cap de mort",
                "steagul piraților",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-003"),
            keywords: &["E11-003"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("пиратский флаг"),
            keywords: &[
                "веселый роджер",
                "кости",
                "пиратский флаг",
                "пираты",
                "флаг",
                "череп",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پائريٽ نشان"),
            keywords: &["جولي روجر", "خزانو", "پائريٽ", "پائريٽ نشان", "پلونڊر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ම\u{dd4}හ\u{dd4}ද\u{dd4} කොල\u{dca}ලක\u{dcf}ර කොඩ\u{dd2}ය"),
            keywords: &[
                "කොල\u{dca}ලකෑම",
                "ජොල\u{dd2} රොජර\u{dca}",
                "න\u{dd2}ධ\u{dcf}නය",
                "ම\u{dd4}හ\u{dd4}ද\u{dd4} කොල\u{dca}ලක\u{dcf}ර කොඩ\u{dd2}ය",
                "ම\u{dd4}හ\u{dd4}ද\u{dd4} කොල\u{dca}ල\u{dcf}කර\u{dd4}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("pirátska zástava"),
            keywords: &["korisť", "pirát", "pirátska zástava", "poklad"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("piratska zastava"),
            keywords: &[
                "gusarska zastava",
                "pirat",
                "piratska zastava",
                "plenjenje",
                "zaklad",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("calanka burcad badeedda"),
            keywords: &[
                "Jolly Roger",
                "burcad badeed",
                "calanka burcad badeedda",
                "dhaca",
                "khasnadda",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("flamur piratësh"),
            keywords: &[
                "Jolly Roger",
                "flamur piratësh",
                "pirat",
                "plaçkitje",
                "thesar",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("пиратска застава"),
            keywords: &[
                "Весели Роџер",
                "благо",
                "пират",
                "пиратска застава",
                "пљачка",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("piratska zastava"),
            keywords: &[
                "Veseli Rodžer",
                "blago",
                "pirat",
                "piratska zastava",
                "pljačka",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("sjörövarflagga"),
            keywords: &["pirater", "plundra", "sjörövarflagga", "skatter"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("bendera ya maharamia"),
            keywords: &[
                "Jolly Roger",
                "bendera ya maharamia",
                "hazina",
                "maharamia",
                "pora",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கடற\u{bcd}கொள\u{bcd}ளையர\u{bcd} கொடி"),
            keywords: &[
                "கடற\u{bcd}கொள\u{bcd}ளையர\u{bcd}",
                "கடற\u{bcd}கொள\u{bcd}ளையர\u{bcd} கொடி",
                "கொள\u{bcd}ளை புதையல\u{bcd}",
                "ஜ\u{bbe}லி ரோஜர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("సముద\u{c4d}రపుద\u{c4a}ంగల జ\u{c46}ండ\u{c3e}"),
            keywords: &[
                "జ\u{c3e}ల\u{c40} ర\u{c4b}జర\u{c4d}",
                "ద\u{c4b}ప\u{c3f}డ\u{c40}",
                "న\u{c3f}ధ\u{c3f}",
                "ప\u{c48}ర\u{c47}ట\u{c4d}",
                "సముద\u{c4d}రపుద\u{c4a}ంగల జ\u{c46}ండ\u{c3e}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ธงโจรสล\u{e31}ด"),
            keywords: &[
                "ข\u{e38}มทร\u{e31}พย\u{e4c}",
                "จอลล\u{e35}โรเจอร\u{e4c}",
                "ธงโจรสล\u{e31}ด",
                "ปล\u{e49}น",
                "โจรสล\u{e31}ด",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("garakçy baýdagy"),
            keywords: &[
                "garakçy",
                "garakçy baýdagy",
                "hazyna",
                "talaň",
                "şadyýan Rojer",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fuka kaihaʻatahi"),
            keywords: &["fuka", "kaihaʻatahi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("korsan bayrağı"),
            keywords: &[
                "Jolly Roger",
                "hazine",
                "korsan",
                "korsan bayrağı",
                "yağmacı",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("піратський прапор"),
            keywords: &[
                "Веселий Роджер",
                "корсар",
                "піратський",
                "піратський прапор",
                "скарб",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("قزاقوں کا جھنڈا"),
            keywords: &["جولی راجر", "خزانہ", "غارت گری", "قزاق", "قزاقوں کا جھنڈا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("dengiz qaroqchilari bayrog‘i"),
            keywords: &[
                "bayroq",
                "bosh suyagi",
                "dengiz qaroqchilari bayrog‘i",
                "qaroqchi",
                "quvnoq rojer",
                "skelet",
                "suyak",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cờ cướp biển"),
            keywords: &[
                "Jolly Roger",
                "cướp biển",
                "cướp bóc",
                "cờ cướp biển",
                "hải tặc",
                "kho báu",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("海盜旗"),
            keywords: &["寶藏", "搶", "海盜", "海盜旗"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("海盗旗"),
            keywords: &["宝藏", "抢", "海盗", "海盗旗"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("海盗旗"),
            keywords: &["掠夺", "海上", "海盗旗", "财宝", "骷髅"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("海盜旗"),
            keywords: &["寶藏", "掠奪", "海盜", "海盜旗", "骷髏旗"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["寶藏", "掠奪", "海盜", "海盜旗", "骷髏頭"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("pirate flag"),
            keywords: &[
                "Jolly Roger",
                "pirate",
                "pirate flag",
                "plunder",
                "treasure",
            ],
        },
    ],
};
