#[doc = "🏻"]
pub const LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🏻",
    codepoint: "1F3FB",
    status: crate::Status::Component,
    introduction_version: 1f32,
    name: "light skin tone",
    group: "Component",
    subgroup: "skin-tone",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("ligte velkleur"),
            keywords: &["kleur", "ligte velkleur", "vel", "velkleur", "veltipe 1–2"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የቆዳ ዓይነት-1-2"),
            keywords: &["ሜት ገላጭ አሻሻይ", "ቆዳ", "የቆዳ ዓይነት-1-2", "ድምፀት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بشرة بلون فاتح"),
            keywords: &[
                "بشرة بلون فاتح",
                "تعديل",
                "جلد",
                "رمز",
                "لون",
                "نوع جلد 1–2",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9be}তল ছ\u{9be}লৰ ৰং"),
            keywords: &[
                "ছ\u{9be}লৰ ৰং",
                "প\u{9be}তল ছ\u{9be}লৰ ৰং",
                "প\u{9cd}ৰক\u{9be}ৰ ১–২",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("açıq dəri tonu"),
            keywords: &["açıq dəri tonu", "emoji modifikatoru", "növ 1–2"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("светлы тон скуры"),
            keywords: &["колер скуры", "светлы тон скуры", "тып 1–2"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("светла кожа"),
            keywords: &["кожа от тип 1 – 2", "светла кожа", "цвят на кожата"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হ\u{9be}লক\u{9be} ত\u{9cd}বকের রঙ"),
            keywords: &[
                "টোন",
                "ত\u{9cd}বক",
                "ত\u{9cd}বকের ধরন 1–2",
                "হ\u{9be}লক\u{9be} ত\u{9cd}বকের রঙ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("svijetla boja kože"),
            keywords: &["boja kože", "svijetla boja kože", "tip 1–2"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pell molt clara"),
            keywords: &["clara", "molt clara", "pell", "pell molt clara"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏗᏴᎳᏘ ᎤᏁᎦᎵ ᏄᏍᏛᎢ"),
            keywords: &["ᎢᏳᏍᏗ 1–2", "ᎣᏁᎦᎸ ᏄᏍᏛᎢ", "ᎤᏗᏴᎳᏘ ᎤᏁᎦᎵ ᏄᏍᏛᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("světlý odstín pleti"),
            keywords: &["barva", "kůže", "pleť", "světlý odstín pleti", "typ 1–2"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("arlliw croen golau"),
            keywords: &["arlliw croen golau", "lliw croen", "math 1–2"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("lys teint"),
            keywords: &["hudfarve", "lys teint", "type 1–2"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("helle Hautfarbe"),
            keywords: &["Hautfarbe", "Hauttyp 1–2", "helle Hautfarbe"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ανοιχτόχρωμος τόνος δέρματος"),
            keywords: &[
                "fitzpatrick",
                "ανοιχτόχρωμος τόνος δέρματος",
                "τόνος δέρματος",
                "τύπου 1–2",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("light skin tone"),
            keywords: &["light skin tone", "skin tone", "type 1–2"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("tono de piel claro"),
            keywords: &[
                "piel",
                "tipo 1",
                "tipo 2",
                "tono",
                "tono de piel",
                "tono de piel claro",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("hele nahatoon"),
            keywords: &["hele nahatoon", "nahatoon", "nahk", "tüüp 1–2"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("1–2. mota"),
            keywords: &["1–2. mota", "azalaren tonua"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پوست سفید"),
            keywords: &[
                "اصلاح\u{200c}گر شکلک",
                "تن رنگ",
                "رنگ پوست",
                "نوع ۱ و ۲",
                "پوست",
                "پوست سفید",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vaalea iho"),
            keywords: &[
                "emojin muokkaus",
                "fitzpatrick",
                "iho",
                "sävy",
                "vaalea iho",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("light na kulay ng balat"),
            keywords: &["kulay ng balat", "light na kulay ng balat", "type 1–2"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("ljósur húðarlitur"),
            keywords: &["húðlitur", "ljós", "ljósur húðarlitur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("peau claire"),
            keywords: &["peau", "peau claire"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("peau claire"),
            keywords: &["peau", "peau claire", "type 1–2"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ton cnis geal"),
            keywords: &["cineál 1–2", "ton cnis", "ton cnis geal"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("tòna soilleir a’ chraicinn"),
            keywords: &[
                "seòrsa 1–2",
                "tòna a’ chraicinn",
                "tòna soilleir a’ chraicinn",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("ton de pel moi claro"),
            keywords: &["tipo 1–2", "ton de pel", "ton de pel moi claro"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચામડીનો આછો ર\u{a82}ગ"),
            keywords: &[
                "આછો ત\u{acd}વચાનો ર\u{a82}ગ",
                "ચામડીનો આછો ર\u{a82}ગ",
                "ત\u{acd}વચાનો પ\u{acd}રકાર-1-2",
                "ત\u{acd}વચાનો ર\u{a82}ગ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("launin fata mai haske"),
            keywords: &["launin fata", "launin fata mai haske", "nau’in 1–2"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גוון עור בהיר"),
            keywords: &["גוון עור", "גוון עור בהיר", "סוג 1–2"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("गोरी त\u{94d}वचा"),
            keywords: &["गोरी त\u{94d}वचा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("svijetla boja kože"),
            keywords: &[
                "boja",
                "emoji modifikator",
                "fitzpatrick",
                "koža",
                "svijetla boja kože",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("világos bőrtónus"),
            keywords: &["1–2-es típus", "bőrtónus", "világos bőrtónus"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բաց գույնի մաշկ"),
            keywords: &["բաց գույնի մաշկ", "մաշկի գույն", "տիպ 1–2"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("tono de pelle clar"),
            keywords: &["tono de pelle", "tono de pelle clar", "typo 1–2"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("warna kulit cerah"),
            keywords: &["tipe 1–2", "warna kulit", "warna kulit cerah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọtanjele ahụ maka ọcha"),
            keywords: &["ọtanjele ahụ", "ọtanjele ahụ maka ọcha", "ụdị 1–2"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ljós húðlitur"),
            keywords: &["húðlitur", "ljós húðlitur", "tegund 1–2"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("carnagione chiara"),
            keywords: &[
                "carnagione chiara",
                "colore della pelle",
                "fototipo",
                "pelle chiara",
                "tonalità",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("薄い肌色"),
            keywords: &["肌の色", "肌色1–2", "薄い肌色"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kulit putih"),
            keywords: &["kulit putih", "praupan kulit", "tipe 1 - 2"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კანის ღია ტონალობა"),
            keywords: &[
                "ემოჯი მოდიფიკატორი",
                "კანი",
                "კანის ღია ტონალობა",
                "ტონი",
                "ფიცპატრიკი",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("taglimt taceɛlalt"),
            keywords: &["taglimt taceɛlalt"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("1–2 тері түсі"),
            keywords: &[
                "1–2 тері түсі",
                "Фицпатрик",
                "тері",
                "түсі",
                "эмодзи өзгертуші",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សម\u{17d2}ប\u{17bb}រស"),
            keywords: &[
                "ប\u{17d2}រភេទទ\u{17b8} 1–2",
                "សម\u{17d2}ប\u{17bb}រ",
                "សម\u{17d2}ប\u{17bb}រស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ತ\u{cbf}ಳ\u{cbf} ಬಣ\u{ccd}ಣದ ಚರ\u{ccd}ಮ"),
            keywords: &[
                "ಚರ\u{ccd}ಮದ ಬಣ\u{ccd}ಣ ತ\u{cbf}ಳ\u{cbf}",
                "ತ\u{cbf}ಳ\u{cbf} ಬಣ\u{ccd}ಣದ ಚರ\u{ccd}ಮ",
                "ವ\u{cbf}ಧ 1–2",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("하얀 피부"),
            keywords: &["타입 일 다시 이", "피부톤", "하얀 피부"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उजळ कातीचो र\u{902}ग"),
            keywords: &[
                "उजळ कातीचो र\u{902}ग",
                "कातीचो र\u{902}ग",
                "प\u{94d}रकार 1–2",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("акжуумал"),
            keywords: &["1–2 түрү", "акжуумал", "теринин өңү"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("hell Hautfaarf"),
            keywords: &["Hautfaarf", "Typ 1–2", "hell Hautfaarf"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb5}ສ\u{eb1}ນປະເພດ-1-2"),
            keywords: &[
                "ປະເພດ",
                "ສ\u{eb5}ສ\u{eb1}ນ",
                "ສ\u{eb5}ສ\u{eb1}ນປະເພດ-1-2",
                "ໂທນສ\u{eb5}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("šviesios odos"),
            keywords: &["odos atspalvis", "šviesios odos"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("gaišs ādas tonis"),
            keywords: &["1.–2. tips", "gaišs ādas tonis", "ādas tonis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kiri āhua māmā"),
            keywords: &["kiri āhua", "kiri āhua māmā", "momo 1–2"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("тип на кожа 1–2"),
            keywords: &[
                "боја",
                "кожа",
                "модификатор на емотикона",
                "тип на кожа 1–2",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("തെളിഞ\u{d4d}ഞ ചർമ\u{d4d}മ നിറം"),
            keywords: &[
                "ചർമ\u{d4d}മ നിറം",
                "ചർമ\u{d4d}മത\u{d4d}തിന\u{d4d}റെ നിറം-1-2",
                "തരം 1–2",
                "തെളിഞ\u{d4d}ഞ ചർമ\u{d4d}മ നിറം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цайвар"),
            keywords: &["арьсны өнгө", "төрөл 1–2", "цайвар", "цайвар арьсны өнгө"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("उजळ त\u{94d}वचा"),
            keywords: &[
                "उजळ त\u{94d}वचा",
                "त\u{94d}वच\u{947}चा प\u{94d}रकार",
                "प\u{94d}रकार 1–2",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("ton kulit cerah"),
            keywords: &["jenis 1–2", "ton kulit", "ton kulit cerah"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ton ċar tal-ġilda"),
            keywords: &["tip 1–2", "ton tal-ġilda", "ton ċar tal-ġilda"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အသားဖြ\u{1030}ရောင\u{103a}"),
            keywords: &[
                "အမျ\u{102d}\u{102f}းအစား ၁–၂",
                "အသားဖြ\u{1030}ရောင\u{103a}",
                "အသားအရေ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hudtype 1–2"),
            keywords: &[
                "emojimodifikator",
                "fitzpatrick",
                "hud",
                "hudfarge",
                "hudtype 1–2",
                "type 1–2",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("छालाको प\u{94d}रकार-१-२"),
            keywords: &[
                "इमोजी परिमार\u{94d}जक",
                "छाला",
                "छालाको प\u{94d}रकार-१-२",
                "टोन",
                "फिटपाट\u{94d}रिक",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("lichte huidskleur"),
            keywords: &["huidskleur", "lichte huidskleur", "type 1–2"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("hudtype 1–2"),
            keywords: &[
                "emojimodifikator",
                "fitzpatrick",
                "hud",
                "hudfarge",
                "hudtype 1–2",
                "type 1–2",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ହ\u{b3e}ଲକ\u{b3e} ଚର\u{b4d}ମ ରଙ\u{b4d}ଗ"),
            keywords: &[
                "ଚର\u{b4d}ମ ରଙ\u{b4d}ଗ",
                "ପ\u{b4d}ରକ\u{b3e}ର 1–2",
                "ହ\u{b3e}ଲକ\u{b3e} ଚର\u{b4d}ମ ରଙ\u{b4d}ଗ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਗ\u{a4b}ਰਾ ਰ\u{a70}ਗ"),
            keywords: &[
                "ਇਮ\u{a4b}ਜੀ ਸ\u{a4b}ਧਕ",
                "ਗ\u{a4b}ਰਾ ਰ\u{a70}ਗ",
                "ਚਮੜੀ ਦਾ ਰ\u{a70}ਗ",
                "ਟ\u{a4b}ਨ",
                "ਫਿਟਜਪ\u{a48}ਟਰਿਕ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہلکی رنگت آلی جلد"),
            keywords: &["جلد دی رنگت", "قسم 1–2", "ہلکی رنگت آلی جلد"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Laít Skín Ton"),
            keywords: &["Laít Skín Ton", "Skín Ton", "Taip 1–2"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("karnacja jasna"),
            keywords: &["karnacja", "karnacja jasna", "odcień skóry", "typ 1–2"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د روڼ پوستکي ټون"),
            keywords: &["د روڼ پوستکي ټون", "روښانه پوستکۍ", "پوستکۍ", "ډول ۲–۱"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pele clara"),
            keywords: &["pele clara", "tipo 1–2", "tom de pele"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("tipo de pele 1–2"),
            keywords: &[
                "cor de pele",
                "cor de pele clara",
                "tez clara",
                "tipo de pele 1–2",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("chuya qara niraq"),
            keywords: &["1–2 kaq", "chuya qara niraq", "qara niraq"],
        },
        #[cfg(feature = "rm")]
        crate::Annotation {
            lang: "rm",
            tts: Some("pel clera"),
            keywords: &["colur da pel", "pel clera", "tip 1–2"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ton deschis al pielii"),
            keywords: &["nuanță", "piele", "tipul 1–2", "ton deschis al pielii"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-440"),
            keywords: &["E10-440"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("очень светлый тон кожи"),
            keywords: &[
                "кожа",
                "оттенок",
                "очень светлый тон кожи",
                "светлый",
                "тело",
                "цвет",
                "цвет кожи",
                "цвет кожи 1–2",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibara ry’uruhu rwera"),
            keywords: &["ibara ry’uruhu", "ibara ry’uruhu rwera", "ubwoko 1–2"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("گوري رنگت"),
            keywords: &["رنگ", "قسم 1–2", "گوري رنگت"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සමෙහ\u{dd2} වර\u{dca}ගය-1-2"),
            keywords: &[
                "ඉමෝජ\u{dd2} ව\u{dd2}කරණක\u{dcf}රකය",
                "වර\u{dca}ණය",
                "සම",
                "සමෙහ\u{dd2} වර\u{dca}ගය-1-2",
                "ෆ\u{dca}ට\u{dca}ස\u{dca}පැට\u{dca}\u{200d}ර\u{dd2}ක\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("svetlý tón pleti"),
            keywords: &[
                "koža",
                "odtieň",
                "pleť",
                "svetlá",
                "svetlý tón pleti",
                "tón",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("svetel ten kože"),
            keywords: &["svetel ten kože", "ten", "vrsti 1 in 2"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("jidh fudud"),
            keywords: &["jidh", "jidh fudud", "nooc 1–2"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("nuancë lëkure e çelët"),
            keywords: &["nuancë lëkure", "nuancë lëkure e çelët", "tipi I-II"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("светла кожа"),
            keywords: &["бoja коже", "светла кожа", "тип коже 1–2"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("свијетла кожа"),
            keywords: &["свијетла кожа"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("svetla koža"),
            keywords: &["boja kože", "svetla koža", "tip kože 1–2"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("svijetla koža"),
            keywords: &["svijetla koža"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ljus hy"),
            keywords: &["hud", "hudfärg", "hudton 1–2", "ljus hy"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ngozi nyeupe"),
            keywords: &["kibadilisha emoji", "ngozi nyeupe", "nyeupe", "sura"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வகை 1–2"),
            keywords: &["தோலின\u{bcd} நிறம\u{bcd}", "வகை 1–2"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ల\u{c47}త చర\u{c4d}మపు రంగు"),
            keywords: &[
                "చర\u{c4d}మం",
                "చర\u{c4d}మం ట\u{c4b}న\u{c4d} - 1-2",
                "ట\u{c4b}న\u{c4d}",
                "ల\u{c47}త చర\u{c4d}మపు రంగు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ранги равшани пӯст"),
            keywords: &["навъи 1–2", "ранги пӯст", "ранги равшани пӯст"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("โทนผ\u{e34}วส\u{e35}ขาว"),
            keywords: &[
                "ผ\u{e34}วโทน 1–2",
                "โทนผ\u{e34}วส\u{e35}ขาว",
                "โทนส\u{e35}ผ\u{e34}ว",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("açyk deri reňki"),
            keywords: &["açyk deri reňki", "deri reňki", "görnüş 1–2"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kili hinehina"),
            keywords: &["faʻahinga 1–2", "hinehina", "kili"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("açık cilt tonu"),
            keywords: &["açık cilt tonu", "cilt tonu", "tip 1–2"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاچ تېرە رەڭ"),
            keywords: &["ئاچ تېرە رەڭ", "تۈر 1–2", "تېرە رەڭگى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("світлий тон шкіри"),
            keywords: &["світлий тон шкіри", "тон", "фіцпатрік", "шкіра"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جلد کی ہلکی رنگت"),
            keywords: &["اسکن", "ایموجی", "تبدیل کار", "جلد کی ہلکی رنگت", "ٹون"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("1–2-teri turi"),
            keywords: &["1–2-teri turi", "emojini o‘zgartirish", "teri", "tus"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("màu da sáng"),
            keywords: &["loại 1–2", "màu da", "màu da sáng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xeesaayu der bu woyof"),
            keywords: &["xeesaayu der", "xeesaayu der bu woyof", "xeet 1–2"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ithoni yesikhumba esikhanyayo"),
            keywords: &[
                "ithoni yesikhumba",
                "ithoni yesikhumba esikhanyayo",
                "uhlobo 1–2",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("amọ\u{301}lára"),
            keywords: &["amọ\u{301}lára", "amọ\u{301}láwọ\u{300}", "irú 1–2"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("淺膚色"),
            keywords: &["淺膚色", "膚色", "類型 1–2"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("浅肤色"),
            keywords: &["浅肤色", "类型 1–2", "肤色"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("较浅肤色"),
            keywords: &["肤色", "较浅肤色"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("白皮膚"),
            keywords: &["白皮膚", "膚色"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uhlobo-1-2"),
            keywords: &["uhlobo 1–2", "uhlobo lwesikhumba", "uhlobo-1-2"],
        },
    ],
};
#[doc = "🏼"]
pub const MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🏼",
    codepoint: "1F3FC",
    status: crate::Status::Component,
    introduction_version: 1f32,
    name: "medium-light skin tone",
    group: "Component",
    subgroup: "skin-tone",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("medium-ligte velkleur"),
            keywords: &[
                "kleur",
                "medium-ligte velkleur",
                "vel",
                "velkleur",
                "veltipe 3",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መሃከለኛ ቀላ ያለ የቆዳ ቀለም"),
            keywords: &["መሃከለኛ ቀላ ያለ የቆዳ ቀለም", "ስሜት ገላጭ አሻሻይ", "ቆዳ", "ድምፀት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بشرة بلون فاتح ومعتدل"),
            keywords: &[
                "بشرة بلون فاتح ومعتدل",
                "تعديل",
                "جلد",
                "رمز",
                "لون",
                "نوع جلد 3",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মধ\u{9cd}যমীয\u{9bc}\u{9be}-প\u{9be}তল ছ\u{9be}লৰ ৰং"),
            keywords: &[
                "ছ\u{9be}লৰ ৰং",
                "প\u{9cd}ৰক\u{9be}ৰ ৩",
                "মধ\u{9cd}যমীয\u{9bc}\u{9be}-প\u{9be}তল ছ\u{9be}লৰ ৰং",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("orta-açıq dəri tonu"),
            keywords: &["emoji modifikatoru", "növ 3", "orta-açıq dəri tonu"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сярэднясветлы тон скуры"),
            keywords: &["колер скуры", "сярэднясветлы тон скуры", "тып 3"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("средно светла кожа"),
            keywords: &["кожа от тип 3", "средно светла кожа", "цвят на кожата"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9be}ঝ\u{9be}রি-হ\u{9be}লক\u{9be} ত\u{9cd}বকের রঙ"),
            keywords: &[
                "ত\u{9cd}বকের রঙ",
                "ধরন 3",
                "ম\u{9be}ঝ\u{9be}রি-হ\u{9be}লক\u{9be} ত\u{9cd}বকের রঙ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("umjereno svijetla boja kože"),
            keywords: &["boja kože", "tip 3", "umjereno svijetla boja kože"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pell bastant clara"),
            keywords: &["bastant clara", "pell", "pell bastant clara"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏲᏟᎨ-ᎤᏗᏴᎳᏘ ᎤᏁᎦᎸ ᏄᎿᏍᏛᎢ"),
            keywords: &["ᎠᏲᏟᎨ-ᎤᏗᏴᎳᏘ ᎤᏁᎦᎸ ᏄᎿᏍᏛᎢ", "ᎢᏳᏍᏗ 3", "ᎣᏁᎦᎸ ᏄᏍᏛᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("středně světlý odstín pleti"),
            keywords: &[
                "barva",
                "kůže",
                "pleť",
                "středně světlý odstín pleti",
                "typ 3",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("arlliw croen canolig-golau"),
            keywords: &["arlliw croen canolig-golau", "lliw croen", "math 3"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("medium til lys teint"),
            keywords: &["hudfarve", "medium til lys teint", "type 3"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("mittelhelle Hautfarbe"),
            keywords: &["Hautfarbe", "Hauttyp 3", "mittelhelle Hautfarbe"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μεσαίος-ανοιχτόχρωμος τόνος δέρματος"),
            keywords: &[
                "fitzpatrick",
                "μεσαίος-ανοιχτόχρωμος τόνος δέρματος",
                "τόνος δέρματος",
                "τύπου 3",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("medium-light skin tone"),
            keywords: &["medium-light skin tone", "skin tone", "type 3"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("tono de piel claro medio"),
            keywords: &[
                "piel",
                "tipo 3",
                "tono",
                "tono de piel",
                "tono de piel claro medio",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("keskmiselt hele nahatoon"),
            keywords: &["keskmiselt hele nahatoon", "nahatoon", "nahk", "tüüp 3"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("3. mota"),
            keywords: &["3. mota", "azalaren tonua"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پوست روشن"),
            keywords: &[
                "اصلاح\u{200c}گر شکلک",
                "تن پوست",
                "رنگ پوست",
                "نوع ۳",
                "پوست",
                "پوست روشن",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("keskivaalea iho"),
            keywords: &[
                "emojin muokkaus",
                "fitzpatrick",
                "iho",
                "keskivaalea iho",
                "sävy",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("katamtamang light na kulay ng balat"),
            keywords: &[
                "katamtamang light na kulay ng balat",
                "kulay ng balat",
                "type 3",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("miðalljósur húðarlitur"),
            keywords: &["húðlitur", "miðalljós", "miðalljósur húðarlitur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("peau moyennement claire"),
            keywords: &["peau", "peau moyennement claire"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("peau modérément claire"),
            keywords: &["peau", "peau modérément claire", "type 3"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ton cnis mheánach-gheal"),
            keywords: &[
                "cineál 3",
                "ton cnis",
                "ton cnis meángheal",
                "ton cnis mheánach-gheal",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("tòna meadhanach soilleir a’ chraicinn"),
            keywords: &[
                "seòrsa 3",
                "tòna a’ chraicinn",
                "tòna meadhanach soilleir a’ chraicinn",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("ton de pel claro"),
            keywords: &["tipo 3", "ton de pel", "ton de pel claro"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચામડીનો મધ\u{acd}યમ આછો ર\u{a82}ગ"),
            keywords: &[
                "ચામડીનો મધ\u{acd}યમ આછો ર\u{a82}ગ",
                "ત\u{acd}વચાનો પ\u{acd}રકાર-3",
                "ત\u{acd}વચાનો ર\u{a82}ગ",
                "મધ\u{acd}યમ આછો ત\u{acd}વચાનો ર\u{a82}ગ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("launin fata mai madaidaicin haske"),
            keywords: &[
                "launin fata",
                "launin fata mai madaidaicin haske",
                "nau’in 3",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גוון עור בהיר בינוני"),
            keywords: &["גוון עור", "גוון עור בהיר בינוני", "סוג 3"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("हल\u{94d}की गोरी त\u{94d}वचा"),
            keywords: &["हल\u{94d}की गोरी त\u{94d}वचा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("svijetlo maslinasta boja kože"),
            keywords: &[
                "boja",
                "emoji modifikator",
                "fitzpatrick",
                "koža",
                "svijetlo maslinasta boja kože",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("közepesen világos bőrtónus"),
            keywords: &["3-as típus", "bőrtónus", "közepesen világos bőrtónus"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("միջին բաց գույնի մաշկ"),
            keywords: &["մաշկի գույն", "միջին բաց գույնի մաշկ", "տիպ 3"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("tono de pelle medio clar"),
            keywords: &["tono de pelle", "tono de pelle medio clar", "typo 3"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("warna kulit cerah-sedang"),
            keywords: &["tipe 3", "warna kulit", "warna kulit cerah-sedang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọtanjele ahụ maka ọcha-ndịna etiti"),
            keywords: &[
                "ọtanjele ahụ",
                "ọtanjele ahụ maka ọcha-ndịna etiti",
                "ụdị 3",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("meðalljós húðlitur"),
            keywords: &["húðlitur", "meðalljós húðlitur", "tegund 3"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("carnagione abbastanza chiara"),
            keywords: &[
                "carnagione abbastanza chiara",
                "colore della pelle",
                "fototipo",
                "pelle abbastanza chiara",
                "tonalità",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("やや薄い肌色"),
            keywords: &["やや薄い肌色", "肌の色", "肌色3", "薄い～中間の肌色"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kulit putih langsep"),
            keywords: &["kulit putih langsep", "praupan kulit", "tipe 3"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ღიადან საშუალომდე კანის ტონალობა"),
            keywords: &[
                "ემოჯი მოდიფიკატორი",
                "კანი",
                "ტონი",
                "ფიცპატრიკი",
                "ღიადან საშუალომდე კანის ტონალობა",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tagwlimt taceɛlalt talemmast"),
            keywords: &["tagwlimt taceɛlalt talemmast"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("3-тері түрі"),
            keywords: &[
                "3-тері түрі",
                "Фицпатрик",
                "тері",
                "түсі",
                "эмодзи өзгертуші",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សម\u{17d2}ប\u{17bb}រសល\u{17d2}មម"),
            keywords: &[
                "ប\u{17d2}រភេទទ\u{17b8} 3",
                "សម\u{17d2}ប\u{17bb}រ",
                "សម\u{17d2}ប\u{17bb}រសល\u{17d2}មម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಧ\u{ccd}ಯಮ-ತ\u{cbf}ಳ\u{cbf} ಬಣ\u{ccd}ಣದ ಚರ\u{ccd}ಮ"),
            keywords: &[
                "ಚರ\u{ccd}ಮದ ಬಣ\u{ccd}ಣ ಮಧ\u{ccd}ಯಮ",
                "ಮಧ\u{ccd}ಯಮ-ತ\u{cbf}ಳ\u{cbf} ಬಣ\u{ccd}ಣದ ಚರ\u{ccd}ಮ",
                "ವ\u{cbf}ಧ 3",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("연한 갈색 피부"),
            keywords: &["연한 갈색 피부", "타입 삼", "피부톤"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मध\u{94d}यम-उजळ कातीचो र\u{902}ग"),
            keywords: &[
                "कातीचो र\u{902}ग",
                "प\u{94d}रकार 3",
                "मध\u{94d}यम-उजळ कातीचो र\u{902}ग",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("буудай жүздүү"),
            keywords: &["3-түр", "буудай жүздүү", "теринин өңү"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("mëttelhell Hautfaarf"),
            keywords: &["Hautfaarf", "Typ 3", "mëttelhell Hautfaarf"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb5}ສ\u{eb1}ນປະເພດ-3"),
            keywords: &[
                "ປະເພດ",
                "ສ\u{eb5}ສ\u{eb1}ນ",
                "ສ\u{eb5}ສ\u{eb1}ນປະເພດ-3",
                "ໂທນສ\u{eb5}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vidutinio gymio"),
            keywords: &["odos atspalvis", "vidutinio gymio"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vidēji gaišs ādas tonis"),
            keywords: &["3. tips", "vidēji gaišs ādas tonis", "ādas tonis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kiri āhua māmā-waenga"),
            keywords: &["kiri āhua", "kiri āhua māmā-waenga", "momo 3"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("тип на кожа 3"),
            keywords: &["боја", "кожа", "модификатор на емотикона", "тип на кожа 3"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഇടത\u{d4d}തരം തെളിഞ\u{d4d}ഞ ചർമ\u{d4d}മ നിറം"),
            keywords: &[
                "ഇടത\u{d4d}തരം തെളിഞ\u{d4d}ഞ ചർമ\u{d4d}മ നിറം",
                "ഇര\u{d41}ണ\u{d4d}ട തെളിഞ\u{d4d}ഞ ചർമ\u{d4d}മ നിറം",
                "ചർമ\u{d4d}മ നിറം",
                "ചർമ\u{d4d}മത\u{d4d}തിന\u{d4d}റെ നിറം-3",
                "തരം 3",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бага зэргийн цайвар"),
            keywords: &["арьсны өнгө", "бага зэргийн цайвар", "төрөл 3"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मध\u{94d}यम उजळ त\u{94d}वचा"),
            keywords: &[
                "त\u{94d}वच\u{947}चा प\u{94d}रकार",
                "प\u{94d}रकार 3",
                "मध\u{94d}यम उजळ त\u{94d}वचा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("ton kulit sederhana cerah"),
            keywords: &["jenis 3", "ton kulit", "ton kulit sederhana cerah"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ton medju-ċar tal-ġilda"),
            keywords: &["tip 3", "ton medju-ċar tal-ġilda", "ton tal-ġilda"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အသားန\u{102f}ရောင\u{103a}"),
            keywords: &[
                "အမျ\u{102d}\u{102f}းအစား ၃",
                "အသားန\u{102f}ရောင\u{103a}",
                "အသားလတ\u{103a}ရောင\u{103a}",
                "အသားအရေ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hudtype 3"),
            keywords: &[
                "emojimodifikator",
                "fitzpatrick",
                "hud",
                "hudfarge",
                "hudtype 3",
                "type 3",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("छालाको प\u{94d}रकार-३"),
            keywords: &[
                "इमोजी परिमार\u{94d}जक",
                "छाला",
                "छालाको प\u{94d}रकार-३",
                "टोन",
                "फिटपाट\u{94d}रिक",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("lichtgetinte huidskleur"),
            keywords: &["huidskleur", "lichtgetinte huidskleur", "type 3"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("hudtype 3"),
            keywords: &[
                "emojimodifikator",
                "fitzpatrick",
                "hud",
                "hudfarge",
                "hudtype 3",
                "type 3",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମଧ\u{b4d}ୟମ-ହ\u{b3e}ଲକ\u{b3e} ଚର\u{b4d}ମ ରଙ\u{b4d}ଗ"),
            keywords: &[
                "ଚର\u{b4d}ମ ରଙ\u{b4d}ଗ",
                "ପ\u{b4d}ରକ\u{b3e}ର 3",
                "ମଧ\u{b4d}ୟମ-ହ\u{b3e}ଲକ\u{b3e} ଚର\u{b4d}ମ ରଙ\u{b4d}ଗ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਹਲਕਾ ਕਣਕਵ\u{a70}ਨਾ ਰ\u{a70}ਗ"),
            keywords: &[
                "ਇਮ\u{a4b}ਜੀ ਸ\u{a4b}ਧਕ",
                "ਚਮੜੀ ਦਾ ਰ\u{a70}ਗ",
                "ਟ\u{a4b}ਨ",
                "ਫਿਟਜਪ\u{a48}ਟਰਿਕ",
                "ਹਲਕਾ ਕਣਕਵ\u{a70}ਨਾ ਰ\u{a70}ਗ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہلکی درمیانی رنگت آلی جلد"),
            keywords: &["جلد دی رنگت", "قسم 3", "ہلکی درمیانی رنگت آلی جلد"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mídíọ\u{301}m-Laít Skín Ton"),
            keywords: &["Mídíọ\u{301}m-Laít Skín Ton", "Skín Ton", "Taip 3"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("karnacja średnio jasna"),
            keywords: &[
                "karnacja",
                "karnacja średnio jasna",
                "odcień skóry",
                "typ 3",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("غنمی-روښانه پوستکۍ"),
            keywords: &["غنمی-روښانه پوستکۍ", "پوستکۍ", "ډول ۳"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pele morena clara"),
            keywords: &["pele morena clara", "tipo 3", "tom de pele"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("tipo de pele 3"),
            keywords: &[
                "cor de pele",
                "cor de pele clara (média)",
                "tez clara (média)",
                "tipo de pele 3",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tunpa chuya qara niraq"),
            keywords: &["3 kaq", "qara niraq", "tunpa chuya qara niraq"],
        },
        #[cfg(feature = "rm")]
        crate::Annotation {
            lang: "rm",
            tts: Some("pel mez clera"),
            keywords: &["colur da pel", "pel mez clera", "tip 3"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ton semi‑deschis al pielii"),
            keywords: &["nuanță", "piele", "tipul 3", "ton semi‑deschis al pielii"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-441"),
            keywords: &["E10-441"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("светлый тон кожи"),
            keywords: &[
                "кожа",
                "оттенок",
                "светлый",
                "светлый тон кожи",
                "тело",
                "цвет",
                "цвет кожи",
                "цвет кожи 3",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibara ry’uruhu rwera gahoro"),
            keywords: &[
                "ibara ry’uruhu rwera gahoro",
                "imiterere y’uruhu",
                "ubwoko 3",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("وچولي گوري رنگت"),
            keywords: &["رنگ", "قسم 3", "وچولي گوري رنگت"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සමෙහ\u{dd2} වර\u{dca}ගය-3"),
            keywords: &[
                "ඉමෝජ\u{dd2} ව\u{dd2}කරණක\u{dcf}රකය",
                "වර\u{dca}ණය",
                "සම",
                "සමෙහ\u{dd2} වර\u{dca}ගය-3",
                "ෆ\u{dca}ට\u{dca}ස\u{dca}පැට\u{dca}\u{200d}ර\u{dd2}ක\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("stredne svetlý tón pleti"),
            keywords: &[
                "koža",
                "odtieň",
                "pleť",
                "stredne svetlá",
                "stredne svetlý tón pleti",
                "tón",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("srednje svetel ten kože"),
            keywords: &["srednje svetel ten kože", "ten", "vrsta 3"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("jidh fudud oo dhexe"),
            keywords: &["jidh", "jidh fudud oo dhexe", "nooc 3"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("nuancë lëkure gjysmë e çelët"),
            keywords: &["nuancë lëkure", "nuancë lëkure gjysmë e çelët", "tipi III"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("средње светла кожа"),
            keywords: &["бoja коже", "средње светла кожа", "тип коже 3"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("средње свијетла кожа"),
            keywords: &["средње свијетла кожа"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("srednje svetla koža"),
            keywords: &["boja kože", "srednje svetla koža", "tip kože 3"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("srednje svijetla koža"),
            keywords: &["srednje svijetla koža"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("mellanljus hy"),
            keywords: &["hud", "hudfärg", "hudton 3", "mellanljus hy"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ngozi nyeupe kiasi"),
            keywords: &[
                "kibadilisha emoji",
                "ngozi",
                "ngozi nyeupe kiasi",
                "nyeupe",
                "sura",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வகை 3"),
            keywords: &["தோலின\u{bcd} நிறம\u{bcd}", "வகை 3"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మధ\u{c4d}యస\u{c4d}థంగ\u{c3e} ల\u{c47}త చర\u{c4d}మపు రంగు"),
            keywords: &[
                "చర\u{c4d}మం",
                "చర\u{c4d}మం ట\u{c4b}న\u{c4d} -3",
                "ట\u{c4b}న\u{c4d}",
                "మధ\u{c4d}యస\u{c4d}థంగ\u{c3e} ల\u{c47}త చర\u{c4d}మపు రంగు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ранги равшании миёнаи пӯст"),
            keywords: &["навъи 3", "ранги пӯст", "ранги равшании миёнаи пӯст"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("โทนผ\u{e34}วส\u{e35}ขาวเหล\u{e37}อง"),
            keywords: &[
                "ผ\u{e34}วโทน 3",
                "โทนผ\u{e34}วส\u{e35}ขาวเหล\u{e37}อง",
                "โทนส\u{e35}ผ\u{e34}ว",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("orta açyk deri reňki"),
            keywords: &["deri reňki", "görnüş 3", "orta açyk deri reňki"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kili kelokelo"),
            keywords: &["faʻahinga 3", "kelokelo", "kili"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("orta açık cilt tonu"),
            keywords: &["cilt tonu", "orta açık cilt tonu", "tip 3"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئارا ئاچ تېرە رەڭگى"),
            keywords: &["ئارا ئاچ تېرە رەڭگى", "تۈر 3", "تېرە رەڭگى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("помірно світлий тон шкіри"),
            keywords: &["помірно світлий тон шкіри", "тон", "фіцпатрік", "шкіра"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جلد کی درمیانی -ہلکی رنگت"),
            keywords: &[
                "اسکن",
                "ایموجی",
                "تبدیل کار",
                "جلد کی درمیانی -ہلکی رنگت",
                "ٹون",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("3-teri turi"),
            keywords: &["3-teri turi", "emojini o‘zgartirish", "teri", "tus"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("màu da sáng trung bình"),
            keywords: &["loại 3", "màu da", "màu da sáng trung bình"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xeesaayu der bu xeereer"),
            keywords: &["xeesaayu der", "xeesaayu der bu xeereer", "xeet 3"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ithoni yesikhumba esikhanyayo phakathi"),
            keywords: &[
                "ithoni yesikhumba",
                "ithoni yesikhumba esikhanyayo phakathi",
                "uhlobo 3",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("amọ\u{301}lára díẹ\u{300}"),
            keywords: &[
                "amọ\u{301}lára díẹ\u{300}",
                "amọ\u{301}láwọ\u{300}",
                "irú 3",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("中淺膚色"),
            keywords: &["中淺膚色", "膚色", "類型 3"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("中浅肤色"),
            keywords: &["中浅肤色", "类型 3", "肤色"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("中等-浅肤色"),
            keywords: &["中等-浅肤色", "肤色"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("黃皮膚"),
            keywords: &["膚色", "黃皮膚"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uhlobo-3"),
            keywords: &["uhlobo 3", "uhlobo lwesikhumba", "uhlobo-3"],
        },
    ],
};
#[doc = "🏽"]
pub const MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🏽",
    codepoint: "1F3FD",
    status: crate::Status::Component,
    introduction_version: 1f32,
    name: "medium skin tone",
    group: "Component",
    subgroup: "skin-tone",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("medium velkleur"),
            keywords: &["kleur", "medium velkleur", "vel", "velkleur", "veltipe 4"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የቆዳ ዓይነት-4"),
            keywords: &["ስሜት ገላጭ አሻሻይ", "ቆዳ", "የቆዳ ዓይነት-4", "ድምፀት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بشرة بلون معتدل"),
            keywords: &["بشرة بلون معتدل", "تعديل", "جلد", "رمز", "لون", "نوع جلد 4"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মধ\u{9cd}যমীয\u{9bc}\u{9be} ছ\u{9be}লৰ ৰং"),
            keywords: &[
                "ছ\u{9be}লৰ ৰং",
                "প\u{9cd}ৰক\u{9be}ৰ ৪",
                "মধ\u{9cd}যমীয\u{9bc}\u{9be} ছ\u{9be}লৰ ৰং",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("orta dəri tonu"),
            keywords: &["emoji modifikatoru", "növ 4", "orta dəri tonu"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сярэдні тон скуры"),
            keywords: &["колер скуры", "сярэдні тон скуры", "тып 4"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("средна на цвят кожа"),
            keywords: &["кожа от тип 4", "средна на цвят кожа", "цвят на кожата"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9be}ঝ\u{9be}রি ত\u{9cd}বকের রঙ"),
            keywords: &[
                "ত\u{9cd}বকের রঙ",
                "ধরন 4",
                "ম\u{9be}ঝ\u{9be}রি ত\u{9cd}বকের রঙ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("umjerena boja kože"),
            keywords: &["boja kože", "tip 4", "umjerena boja kože"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pell morena"),
            keywords: &["morena", "pell"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏲᏟᎨ ᎣᏁᎦᎸ ᏄᏍᏛᎢ"),
            keywords: &["ᎠᏲᏟᎨ ᎣᏁᎦᎸ ᏄᏍᏛᎢ", "ᎢᏳᏍᏗ 4", "ᎣᏁᎦᎸ ᏄᏍᏛᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("střední odstín pleti"),
            keywords: &["barva", "kůže", "pleť", "střední odstín pleti", "typ 4"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("arlliw croen canolog"),
            keywords: &["arlliw croen canolog", "lliw croen", "math 4"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("medium teint"),
            keywords: &["hudfarve", "medium teint", "type 4"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("mittlere Hautfarbe"),
            keywords: &["Hautfarbe", "Hauttyp 4", "mittlere Hautfarbe"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μεσαίος τόνος δέρματος"),
            keywords: &[
                "fitzpatrick",
                "μεσαίος τόνος δέρματος",
                "τόνος δέρματος",
                "τύπου 4",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("medium skin tone"),
            keywords: &["medium skin tone", "skin tone", "type 4"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("tono de piel medio"),
            keywords: &[
                "piel",
                "tipo 4",
                "tono",
                "tono de piel",
                "tono de piel medio",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("keskmine nahatoon"),
            keywords: &["keskmine nahatoon", "nahatoon", "nahk", "tüüp 4"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bitarteko azal-tonua"),
            keywords: &["azalaren tonua", "bitarteko azal-tonua"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پوست طلایی"),
            keywords: &[
                "اصلاح\u{200c}گر شکلک",
                "تن پوست",
                "رنگ پوست",
                "نوع ۴",
                "پوست",
                "پوست برنزه",
                "پوست طلایی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tummanvaalea iho"),
            keywords: &[
                "emojin muokkaus",
                "fitzpatrick",
                "iho",
                "keskisävyinen iho",
                "sävy",
                "tummanvaalea iho",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("katamtamang kulay ng balat"),
            keywords: &["katamtamang kulay ng balat", "kulay ng balat", "type 4"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("miðal húðarlitur"),
            keywords: &["húðlitur", "miðal", "miðal húðarlitur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("peau légèrement mate"),
            keywords: &["peau", "peau légèrement mate"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("peau légèrement mate"),
            keywords: &["peau", "peau légèrement mate", "type 4"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ton cnis meánach"),
            keywords: &["cineál 4", "ton cnis", "ton cnis meánach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("tòna meadhanach a’ chraicinn"),
            keywords: &[
                "seòrsa 4",
                "tòna a’ chraicinn",
                "tòna meadhanach a’ chraicinn",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("ton de pel medio"),
            keywords: &["tipo 4", "ton de pel", "ton de pel medio"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મધ\u{acd}યમ ચામડીનો ર\u{a82}ગ"),
            keywords: &[
                "ત\u{acd}વચાનો પ\u{acd}રકાર-4",
                "ત\u{acd}વચાનો ર\u{a82}ગ",
                "મધ\u{acd}યમ ચામડીનો ર\u{a82}ગ",
                "મધ\u{acd}યમ ત\u{acd}વચાનો ર\u{a82}ગ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("madaidaicin launin fata"),
            keywords: &["launin fata", "madaidaicin launin fata", "nau’in 4"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גוון עור בינוני"),
            keywords: &["גוון עור", "גוון עור בינוני", "סוג 4"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ग\u{947}ह\u{941}\u{901}आ त\u{94d}वचा"),
            keywords: &[
                "ग\u{947}ह\u{941}\u{901}आ त\u{94d}वचा",
                "ग\u{947}ह\u{941}\u{901}ए र\u{902}ग की त\u{94d}वचा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("maslinasta boja kože"),
            keywords: &[
                "boja",
                "emoji modifikator",
                "fitzpatrick",
                "koža",
                "maslinasta boja kože",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("közepes bőrtónus"),
            keywords: &["4-es típus", "bőrtónus", "közepes bőrtónus"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("միջին գույնի մաշկ"),
            keywords: &["մաշկի գույն", "միջին գույնի մաշկ", "տիպ 4"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("tono de pelle medie"),
            keywords: &["tono de pelle", "tono de pelle medie", "typo 4"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("warna kulit sedang"),
            keywords: &["tipe 4", "warna kulit", "warna kulit sedang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọtanjele ahụ ndịna etiti"),
            keywords: &["ọtanjele ahụ", "ọtanjele ahụ ndịna etiti", "ụdị 4"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("millihúðlitur"),
            keywords: &["húðlitur", "millihúðlitur", "tegund 4"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("carnagione olivastra"),
            keywords: &[
                "carnagione olivastra",
                "colore della pelle",
                "fototipo",
                "pelle olivastra",
                "tonalità",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("中間の肌色"),
            keywords: &["中間の肌色", "肌の色", "肌色4"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kulit kuning"),
            keywords: &["kulit kuning", "praupan kulit", "tipe 4"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კანის საშუალო ტონალობა"),
            keywords: &[
                "ემოჯი მოდიფიკატორი",
                "კანი",
                "კანის საშუალო ტონალობა",
                "ტონი",
                "ფიცპატრიკი",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("taglimt talemmast"),
            keywords: &["taglimt talemmast"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("4-тері түсі"),
            keywords: &[
                "4-тері түсі",
                "Фицпатрик",
                "тері",
                "түсі",
                "эмодзи өзгертуші",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សម\u{17d2}ប\u{17bb}រស\u{17d2}រអែម"),
            keywords: &[
                "ប\u{17d2}រភេទទ\u{17b8} 4",
                "សម\u{17d2}ប\u{17bb}រ",
                "សម\u{17d2}ប\u{17bb}រស\u{17d2}រអែម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಧ\u{ccd}ಯಮ ಬಣ\u{ccd}ಣದ ಚರ\u{ccd}ಮ"),
            keywords: &[
                "ಚರ\u{ccd}ಮದ ಬಣ\u{ccd}ಣ ಮಧ\u{ccd}ಯಮ",
                "ಮಧ\u{ccd}ಯಮ ಬಣ\u{ccd}ಣದ ಚರ\u{ccd}ಮ",
                "ವ\u{cbf}ಧ 4",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("갈색 피부"),
            keywords: &["갈색 피부", "타입 사", "피부톤"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मध\u{94d}यम कातीचो र\u{902}ग"),
            keywords: &[
                "कातीचो र\u{902}ग",
                "प\u{94d}रकार 4",
                "मध\u{94d}यम कातीचो र\u{902}ग",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("орточо"),
            keywords: &["4-түр", "орточо", "теринин өңү"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("mëttel Hautfaarf"),
            keywords: &["Hautfaarf", "Typ 4", "mëttel Hautfaarf"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb5}ສ\u{eb1}ນປະເພດ-4"),
            keywords: &[
                "ປະເພດ",
                "ສ\u{eb5}ສ\u{eb1}ນ",
                "ສ\u{eb5}ສ\u{eb1}ນປະເພດ-4",
                "ໂທນສ\u{eb5}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("rusvos odos"),
            keywords: &["odos atspalvis", "rusvos odos"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vidējs ādas tonis"),
            keywords: &["4. tips", "vidējs ādas tonis", "ādas tonis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kiri āhua waenga"),
            keywords: &["kiri āhua", "kiri āhua waenga", "momo 4"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("тип на кожа 4"),
            keywords: &["боја", "кожа", "модификатор на емотикона", "тип на кожа 4"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ചർമ\u{d4d}മത\u{d4d}തിന\u{d4d}റെ നിറം-4"),
            keywords: &[
                "ഇടത\u{d4d}തരം ചർമ\u{d4d}മ നിറം",
                "ചർമ\u{d4d}മ നിറം",
                "ചർമ\u{d4d}മത\u{d4d}തിന\u{d4d}റെ നിറം-4",
                "തരം 4",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дунд зэргийн"),
            keywords: &["арьсны өнгө", "дунд зэргийн", "төрөл 4"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मध\u{94d}यम त\u{94d}वचा"),
            keywords: &[
                "त\u{94d}वच\u{947}चा प\u{94d}रकार",
                "त\u{94d}वच\u{947}चा प\u{94d}रकार-4",
                "प\u{94d}रकार 4",
                "मध\u{94d}यम त\u{94d}वचा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("ton kulit sederhana"),
            keywords: &["jenis 4", "ton kulit", "ton kulit sederhana"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ton medju tal-ġilda"),
            keywords: &["tip 4", "ton medju tal-ġilda", "ton tal-ġilda"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အသားလတ\u{103a}ရောင\u{103a}"),
            keywords: &[
                "အမျ\u{102d}\u{102f}းအစား ၄",
                "အသားလတ\u{103a}ရောင\u{103a}",
                "အသားအရေ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hudtype 4"),
            keywords: &[
                "emojimodifikator",
                "fitzpatrick",
                "hud",
                "hudfarge",
                "hudtype 4",
                "type 4",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("छालाको प\u{94d}रकार-४"),
            keywords: &[
                "इमोजी परिमार\u{94d}जक",
                "छाला",
                "छालाको प\u{94d}रकार-४",
                "टोन",
                "फिटपाट\u{94d}रिक",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("getinte huidskleur"),
            keywords: &["getinte huidskleur", "huidskleur", "type 4"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("hudtype 4"),
            keywords: &[
                "emojimodifikator",
                "fitzpatrick",
                "hud",
                "hudfarge",
                "hudtype 4",
                "type 4",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମଧ\u{b4d}ୟମ ଚର\u{b4d}ମ ରଙ\u{b4d}ଗ"),
            keywords: &[
                "ଚର\u{b4d}ମ ରଙ\u{b4d}ଗ",
                "ପ\u{b4d}ରକ\u{b3e}ର 4",
                "ମଧ\u{b4d}ୟମ ଚର\u{b4d}ମ ରଙ\u{b4d}ଗ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਣਕਵ\u{a70}ਨਾ ਰ\u{a70}ਗ"),
            keywords: &[
                "ਇਮ\u{a4b}ਜੀ ਸ\u{a4b}ਧਕ",
                "ਕਣਕਵ\u{a70}ਨਾ ਰ\u{a70}ਗ",
                "ਚਮੜੀ ਦਾ ਰ\u{a70}ਗ",
                "ਟ\u{a4b}ਨ",
                "ਫਿਟਜਪ\u{a48}ਟਰਿਕ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("درمیانی رنگت آلی جلد"),
            keywords: &["جلد دی رنگت", "درمیانی رنگت آلی جلد", "قسم 4"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mídíọ\u{301}m Skín Ton"),
            keywords: &["Mídíọ\u{301}m Skín Ton", "Skín Ton", "Taip 4"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("karnacja średnia"),
            keywords: &["karnacja", "karnacja średnia", "odcień skóry", "typ 4"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("غنم رنګه"),
            keywords: &["غنم رنګه", "غنم رنګه پوستکۍ", "پوستکۍ", "ډول ۴"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pele morena"),
            keywords: &["pele morena", "tipo 4", "tom de pele"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("tipo de pele 4"),
            keywords: &[
                "cor de pele",
                "cor de pele média",
                "tez média",
                "tipo de pele 4",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tunpa qara niraq"),
            keywords: &["4 kaq", "qara niraq", "tunpa qara niraq"],
        },
        #[cfg(feature = "rm")]
        crate::Annotation {
            lang: "rm",
            tts: Some("pel media"),
            keywords: &["colur da pel", "pel media", "tip 4"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ton mediu al pielii"),
            keywords: &["nuanță", "piele", "tipul 4", "ton mediu al pielii"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-442"),
            keywords: &["E10-442"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("средний тон кожи"),
            keywords: &[
                "кожа",
                "оттенок",
                "смуглый",
                "средний тон кожи",
                "тело",
                "цвет",
                "цвет кожи",
                "цвет кожи 4",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibara ry’uruhu rw’inzobe"),
            keywords: &["ibara ry’uruhu", "ibara ry’uruhu rw’inzobe", "ubwoko 4"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پڪو رنگ"),
            keywords: &["رنگ", "قسم 4", "پڪو رنگ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සමෙහ\u{dd2} වර\u{dca}ගය-4"),
            keywords: &[
                "ඉමෝජ\u{dd2} ව\u{dd2}කරණක\u{dcf}රකය",
                "වර\u{dca}ණය",
                "සම",
                "සමෙහ\u{dd2} වර\u{dca}ගය-4",
                "ෆ\u{dca}ට\u{dca}ස\u{dca}පැට\u{dca}\u{200d}ර\u{dd2}ක\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("stredný tón pleti"),
            keywords: &[
                "koža",
                "odtieň",
                "pleť",
                "stredná",
                "stredný tón pleti",
                "tón",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("srednji ten kože"),
            keywords: &["srednji ten kože", "ten", "vrsta 4"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("jidh nooc dhexe"),
            keywords: &["jidh", "jidh nooc dhexe", "nooc 4"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("nuancë lëkure zeshkane"),
            keywords: &["nuancë lëkure", "nuancë lëkure zeshkane", "tipi IV"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("ни светла ни тамна кожа"),
            keywords: &["бoja коже", "ни светла ни тамна кожа", "тип коже 4"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("ни свијетла ни тамна кожа"),
            keywords: &["ни свијетла ни тамна кожа"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ni svetla ni tamna koža"),
            keywords: &["boja kože", "ni svetla ni tamna koža", "tip kože 4"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("ni svijetla ni tamna koža"),
            keywords: &["ni svijetla ni tamna koža"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("mellanfärgad hy"),
            keywords: &["hud", "hudfärg", "hudton 4", "mellanfärgad hy"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ngozi ya kahawia"),
            keywords: &["kahawia", "ngozi ya kahawia", "rangi ya ngozi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வகை 4"),
            keywords: &["தோலின\u{bcd} நிறம\u{bcd}", "வகை 4"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మధ\u{c4d}యస\u{c4d}థ చర\u{c4d}మపు రంగు"),
            keywords: &[
                "చర\u{c4d}మం",
                "చర\u{c4d}మం ట\u{c4b}న\u{c4d} - 4",
                "ట\u{c4b}న\u{c4d}",
                "మధ\u{c4d}యస\u{c4d}థ చర\u{c4d}మపు రంగు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ранги миёнаи пӯст"),
            keywords: &["навъи 4", "ранги миёнаи пӯст", "ранги пӯст"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("โทนผ\u{e34}วส\u{e35}เหล\u{e37}อง"),
            keywords: &[
                "ผ\u{e34}วโทน 4",
                "โทนผ\u{e34}วส\u{e35}เหล\u{e37}อง",
                "โทนส\u{e35}ผ\u{e34}ว",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("orta deri reňki"),
            keywords: &["deri reňki", "görnüş 4", "orta deri reňki"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kili melomelo"),
            keywords: &["faʻahinga 4", "kili", "melomelo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("orta cilt tonu"),
            keywords: &["cilt tonu", "orta cilt tonu", "tip 4"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئارا تېرە رەڭگى"),
            keywords: &["ئارا تېرە رەڭگى", "تۈر 4", "تېرە رەڭگى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("помірний тон шкіри"),
            keywords: &[
                "помірний тон шкіри",
                "середній тон шкіри",
                "тон",
                "фіцпатрік",
                "шкіра",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جلد کی درمیانی رنگت"),
            keywords: &["اسکن", "ایموجی", "تبدیل کار", "جلد کی درمیانی رنگت", "ٹون"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("4-teri turi"),
            keywords: &["4-teri turi", "emojini o‘zgartirish", "teri", "tus"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("màu da trung bình"),
            keywords: &["loại 4", "màu da", "màu da trung bình"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xeesaayu der bu yam"),
            keywords: &["xeesaayu der", "xeesaayu der bu yam", "xeet 4"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ithoni yesikhumba esiphakathi"),
            keywords: &[
                "ithoni yesikhumba",
                "ithoni yesikhumba esiphakathi",
                "uhlobo 4",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("amọ\u{301}láwọ\u{300} díẹ\u{300}"),
            keywords: &[
                "amọ\u{301}láwọ\u{300}",
                "amọ\u{301}láwọ\u{300} díẹ\u{300}",
                "irú 4",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("中膚色"),
            keywords: &["中膚色", "膚色", "類型 4"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("中肤色"),
            keywords: &["中肤色", "类型 4", "肤色"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("中等肤色"),
            keywords: &["中等肤色", "肤色"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("淺褐皮膚"),
            keywords: &["淺褐皮膚", "膚色"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("中等皮膚"),
            keywords: &["中等皮膚", "膚色"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uhlobo-4"),
            keywords: &["uhlobo 4", "uhlobo lwesikhumba", "uhlobo-4"],
        },
    ],
};
#[doc = "🏾"]
pub const MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🏾",
    codepoint: "1F3FE",
    status: crate::Status::Component,
    introduction_version: 1f32,
    name: "medium-dark skin tone",
    group: "Component",
    subgroup: "skin-tone",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("medium-donker velkleur"),
            keywords: &[
                "kleur",
                "medium-donker velkleur",
                "vel",
                "velkleur",
                "veltipe 5",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የቆዳ ዓይነት-5"),
            keywords: &["ስሜት ገላጭ አሻሻይ", "ቆዳ", "የቆዳ ዓይነት-5", "ድምፀት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بشرة بلون معتدل مائل للغامق"),
            keywords: &[
                "بشرة بلون معتدل مائل للغامق",
                "تعديل",
                "جلد",
                "رمز",
                "لون",
                "نوع جلد 5",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মধ\u{9cd}যমীয\u{9bc}\u{9be}-ক’ল\u{9be} ছ\u{9be}লৰ ৰং"),
            keywords: &[
                "ছ\u{9be}লৰ ৰং",
                "প\u{9cd}ৰক\u{9be}ৰ ৫",
                "মধ\u{9cd}যমীয\u{9bc}\u{9be}-ক’ল\u{9be} ছ\u{9be}লৰ ৰং",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("orta-tünd dəri tonu"),
            keywords: &["emoji modifikatoru", "növ 5", "orta-tünd dəri tonu"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сярэдняцёмны тон скуры"),
            keywords: &["колер скуры", "сярэдняцёмны тон скуры", "тып 5"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("средно тъмна кожа"),
            keywords: &["кожа от тип 5", "средно тъмна кожа", "цвят на кожата"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9be}ঝ\u{9be}রি-ক\u{9be}লো ত\u{9cd}বকের রঙ"),
            keywords: &[
                "ত\u{9cd}বকের ধরন-5",
                "ত\u{9cd}বকের রঙ",
                "ধরন 5",
                "ম\u{9be}ঝ\u{9be}রি-ক\u{9be}লো ত\u{9cd}বক",
                "ম\u{9be}ঝ\u{9be}রি-ক\u{9be}লো ত\u{9cd}বকের রঙ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("umjereno tamna boja kože"),
            keywords: &["boja kože", "tip 5", "umjereno tamna boja kože"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pell fosca"),
            keywords: &["fosca", "pell"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏲᏟᎨ-ᎤᎵᏏᎩ ᎣᏁᎦᎸ ᏄᏍᏛᎢ"),
            keywords: &["ᎠᏲᏟᎨ-ᎤᎵᏏᎩ ᎣᏁᎦᎸ ᏄᏍᏛᎢ", "ᎢᏳᏍᏗ 5", "ᎣᏁᎦᎸ ᏄᏍᏛᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("středně tmavý odstín pleti"),
            keywords: &[
                "barva",
                "kůže",
                "pleť",
                "středně tmavý odstín pleti",
                "typ 5",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("arlliw croen canolig-tywyll"),
            keywords: &["arlliw croen canolig-tywyll", "lliw croen", "math 5"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("medium til mørk teint"),
            keywords: &["hudfarve", "medium til mørk teint", "type 5"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("mitteldunkle Hautfarbe"),
            keywords: &["Hautfarbe", "Hauttyp 5", "mitteldunkle Hautfarbe"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μεσαίος-σκούρος τόνος δέρματος"),
            keywords: &[
                "fitzpatrick",
                "μεσαίος-σκούρος τόνος δέρματος",
                "τόνος δέρματος",
                "τύπου 5",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("medium-dark skin tone"),
            keywords: &["medium-dark skin tone", "skin tone", "type 5"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("tono de piel oscuro medio"),
            keywords: &[
                "piel",
                "tipo 5",
                "tono",
                "tono de piel",
                "tono de piel oscuro medio",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("keskmiselt tume nahatoon"),
            keywords: &["keskmiselt tume nahatoon", "nahatoon", "nahk", "tüüp 5"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("5. mota"),
            keywords: &["5. mota", "azalaren tonua"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پوست گندمی"),
            keywords: &[
                "اصلاح\u{200c}گر شکلک",
                "تن پوست",
                "رنگ پوست",
                "نوع ۵",
                "پوست",
                "پوست تیره",
                "پوست گندمی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("keskitumma iho"),
            keywords: &[
                "emojin muokkaus",
                "fitzpatrick",
                "iho",
                "keskitumma iho",
                "sävy",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("katamtamang dark na kulay ng balat"),
            keywords: &[
                "katamtamang dark na kulay ng balat",
                "kulay ng balat",
                "type 5",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("miðalmyrkur húðarlitur"),
            keywords: &["húðlitur", "miðalmyrk", "miðalmyrkur húðarlitur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("peau mate"),
            keywords: &["peau", "peau mate"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("peau modérément foncée"),
            keywords: &["peau", "peau modérément foncée", "type 5"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ton cnis meándorcha"),
            keywords: &["cineál 5", "ton cnis", "ton cnis meándorcha"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("tòna meadhanach doilleir a’ chraicinn"),
            keywords: &[
                "seòrsa 5",
                "tòna a’ chraicinn",
                "tòna meadhanach doilleir a’ chraicinn",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("ton de pel escuro"),
            keywords: &["tipo 5", "ton de pel", "ton de pel escuro"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મધ\u{acd}યમ ઘ\u{ac7}રો ચામડીનો ર\u{a82}ગ"),
            keywords: &[
                "ત\u{acd}વચાનો પ\u{acd}રકાર-5",
                "ત\u{acd}વચાનો ર\u{a82}ગ",
                "મધ\u{acd}યમ ઘ\u{ac7}રો ચામડીનો ર\u{a82}ગ",
                "મધ\u{acd}યમ ઘ\u{ac7}રો ત\u{acd}વચાનો ર\u{a82}ગ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("launin fata mai madaidaicin duhu"),
            keywords: &[
                "launin fata",
                "launin fata mai madaidaicin duhu",
                "nau’in 5",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גוון עור כהה בינוני"),
            keywords: &["גוון עור", "גוון עור כהה בינוני", "סוג 5"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("हल\u{94d}की सा\u{901}वली त\u{94d}वचा"),
            keywords: &[
                "भ\u{942}री त\u{94d}वचा",
                "हल\u{94d}की सा\u{901}वली त\u{94d}वचा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("smeđa boja kože"),
            keywords: &[
                "boja",
                "emoji modifikator",
                "fitzpatrick",
                "koža",
                "smeđa boja kože",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("közepesen sötét bőrtónus"),
            keywords: &["5-ös típus", "bőrtónus", "közepesen sötét bőrtónus"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("միջին մուգ գույնի մաշկ"),
            keywords: &["մաշկի գույն", "միջին մուգ գույնի մաշկ", "տիպ 5"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("tono de pelle medio-obscur"),
            keywords: &[
                "tono de pelle",
                "tono de pelle medio obscur",
                "tono de pelle medio-obscur",
                "typo 5",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("warna kulit gelap-sedang"),
            keywords: &["tipe 5", "wana kulit", "warna kulit gelap-sedang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọtanjele ahụ maka òji-ndịna etiti"),
            keywords: &["ọtanjele ahụ", "ọtanjele ahụ maka òji-ndịna etiti", "ụdị 5"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("meðaldökkur húðlitur"),
            keywords: &["húðlitur", "meðaldökkur húðlitur", "tegund 5"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("carnagione abbastanza scura"),
            keywords: &[
                "carnagione abbastanza scura",
                "colore della pelle",
                "fototipo",
                "pelle abbastanza scura",
                "tonalità",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("やや濃い肌色"),
            keywords: &["やや濃い肌色", "中間～濃い肌色", "肌の色", "肌色5"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kulit sawo mateng"),
            keywords: &["kulit sawo mateng", "praupan kulit", "tipe 5"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("საშუალოდან მუქამდე კანის ტონალობა"),
            keywords: &[
                "ემოჯი მოდიფიკატორი",
                "კანი",
                "საშუალოდან მუქამდე კანის ტონალობა",
                "ტონი",
                "ფიცპატრიკი",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tagwlimt tubrikt talemmast"),
            keywords: &["tagwlimt tubrikt talemmast"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("5-тері түсі"),
            keywords: &[
                "5-тері түсі",
                "Фицпатрик",
                "тері",
                "түсі",
                "эмодзи өзгертуші",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សម\u{17d2}ប\u{17bb}រខ\u{17d2}មៅល\u{17d2}មម"),
            keywords: &[
                "ប\u{17d2}រភេទទ\u{17b8} 5",
                "សម\u{17d2}ប\u{17bb}រ",
                "សម\u{17d2}ប\u{17bb}រខ\u{17d2}មៅល\u{17d2}មម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಧ\u{ccd}ಯಮ-ಗಾಢ ಬಣ\u{ccd}ಣದ ಚರ\u{ccd}ಮ"),
            keywords: &[
                "ಚರ\u{ccd}ಮದ ಬಣ\u{ccd}ಣ ಗಾಢ",
                "ಮಧ\u{ccd}ಯಮ-ಗಾಢ ಬಣ\u{ccd}ಣದ ಚರ\u{ccd}ಮ",
                "ವ\u{cbf}ಧ 5",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("진한 갈색 피부"),
            keywords: &["진한 갈색 피부", "타입 오", "피부톤"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मध\u{94d}यम-गाढ कातीचो र\u{902}ग"),
            keywords: &[
                "कातीचो र\u{902}ग",
                "प\u{94d}रकार 5",
                "मध\u{94d}यम-गाढ कातीचो र\u{902}ग",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кара тору"),
            keywords: &["5-түр", "кара тору", "теринин өңү"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("mëtteldäischter Hautfaarf"),
            keywords: &["Hautfaarf", "Typ 5", "mëtteldäischter Hautfaarf"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb5}ສ\u{eb1}ນປະເພດ-5"),
            keywords: &[
                "ປະເພດ",
                "ສ\u{eb5}ສ\u{eb1}ນ",
                "ສ\u{eb5}ສ\u{eb1}ນປະເພດ-5",
                "ໂທນສ\u{eb5}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("tamsios odos"),
            keywords: &["odos atspalvis", "tamsios odos"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vidēji tumšs ādas tonis"),
            keywords: &["5. tips", "vidēji tumšs ādas tonis", "ādas tonis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kiri āhua waenga-parauri"),
            keywords: &["kiri āhua", "kiri āhua waenga-parauri", "momo 5"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("тип на кожа 5"),
            keywords: &["боја", "кожа", "модификатор на емотикона", "тип на кожа 5"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഇടത\u{d4d}തരം ഇര\u{d41}ണ\u{d4d}ട ചർമ\u{d4d}മ നിറം"),
            keywords: &[
                "ഇടത\u{d4d}തരം ഇര\u{d41}ണ\u{d4d}ട ചർമ\u{d4d}മ നിറം",
                "ചർമ\u{d4d}മ നിറം",
                "ചർമ\u{d4d}മത\u{d4d}തിന\u{d4d}റെ നിറം-5",
                "തരം 5",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бордуу"),
            keywords: &["арьсны өнгө", "бордуу", "төрөл 5"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मध\u{94d}यम काळसर त\u{94d}वचा"),
            keywords: &[
                "त\u{94d}वच\u{947}चा प\u{94d}रकार",
                "त\u{94d}वच\u{947}चा प\u{94d}रकार-5",
                "प\u{94d}रकार 5",
                "मध\u{94d}यम काळसर त\u{94d}वचा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("ton kulit sederhana gelap"),
            keywords: &["jenis 5", "ton kulit", "ton kulit sederhana gelap"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ton medju-skur tal-ġilda"),
            keywords: &["tip 5", "ton medju-skur tal-ġilda", "ton tal-ġilda"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အသားည\u{102d}\u{102f}ရောင\u{103a}"),
            keywords: &[
                "အမျ\u{102d}\u{102f}းအစား ၅",
                "အသားည\u{102d}\u{102f}ရောင\u{103a}",
                "အသားလတ\u{103a}ရောင\u{103a}",
                "အသားအရေ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hudtype 5"),
            keywords: &[
                "emojimodifikator",
                "fitzpatrick",
                "hud",
                "hudfarge",
                "hudtype 5",
                "type 5",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("छालाको प\u{94d}रकार-५"),
            keywords: &[
                "इमोजी परिमार\u{94d}जक",
                "छाला",
                "छालाको प\u{94d}रकार-५",
                "टोन",
                "फिटपाट\u{94d}रिक",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("donkergetinte huidskleur"),
            keywords: &["donkergetinte huidskleur", "huidskleur", "type 5"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("hudtype 5"),
            keywords: &[
                "emojimodifikator",
                "fitzpatrick",
                "hud",
                "hudfarge",
                "hudtype 5",
                "type 5",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମଧ\u{b4d}ୟମ-ଗ\u{b3e}ଢ\u{b3c} ଚର\u{b4d}ମ ରଙ\u{b4d}ଗ"),
            keywords: &[
                "ଚର\u{b4d}ମ ରଙ\u{b4d}ଗ",
                "ପ\u{b4d}ରକ\u{b3e}ର 5",
                "ମଧ\u{b4d}ୟମ-ଗ\u{b3e}ଢ\u{b3c} ଚର\u{b4d}ମ ରଙ\u{b4d}ଗ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਦਰਮਿਆਨਾ ਕਾਲਾ ਰ\u{a70}ਗ"),
            keywords: &[
                "ਇਮ\u{a4b}ਜੀ ਸ\u{a4b}ਧਕ",
                "ਚਮੜੀ ਦਾ ਰ\u{a70}ਗ",
                "ਟ\u{a4b}ਨ",
                "ਦਰਮਿਆਨਾ ਕਾਲਾ ਰ\u{a70}ਗ",
                "ਫਿਟਜਪ\u{a48}ਟਰਿਕ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("درمیانی کالی رنگت آلی جلد"),
            keywords: &["جلد دی رنگت", "درمیانی کالی رنگت آلی جلد", "قسم 5"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mídíọ\u{301}m Dák Skín Ton"),
            keywords: &["Mídíọ\u{301}m Dák Skín Ton", "Skín Ton", "Taip 5"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("karnacja średnio ciemna"),
            keywords: &[
                "karnacja",
                "karnacja średnio ciemna",
                "odcień skóry",
                "typ 5",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("غنمی-تورنګه پوستکۍ"),
            keywords: &[
                "غنمی-تورنګه پوستکۍ",
                "منځنۍ-تور غنمی پوستکۍ",
                "پوستکۍ",
                "ډول ۵",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pele morena escura"),
            keywords: &["pele morena escura", "tipo 5", "tom de pele"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("tipo de pele 5"),
            keywords: &[
                "cor de pele",
                "cor de pele escura (média)",
                "tez escura (média)",
                "tipo de pele 5",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tunpa yana qara niraq"),
            keywords: &["5 kaq", "qara niraq", "tunpa yana qara niraq"],
        },
        #[cfg(feature = "rm")]
        crate::Annotation {
            lang: "rm",
            tts: Some("pel mez stgira"),
            keywords: &["colur da pel", "pel mez stgira", "tip 5"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ton semi‑închis al pielii"),
            keywords: &["nuanță", "piele", "tipul 5", "ton semi‑închis al pielii"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-443"),
            keywords: &["E10-443"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("темный тон кожи"),
            keywords: &[
                "кожа",
                "оттенок",
                "тело",
                "темный",
                "темный тон кожи",
                "цвет",
                "цвет кожи",
                "цвет кожи 5",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibara ry’uruhu rw’inzobe yirabura"),
            keywords: &[
                "ibara ry’uruhu",
                "ibara ry’uruhu rw’inzobe yirabura",
                "ubwoko 5",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("وچولو ڪارو رنگ"),
            keywords: &["رنگ", "قسم 5", "وچولو ڪارو رنگ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සමෙහ\u{dd2} වර\u{dca}ගය-5"),
            keywords: &[
                "ඉමෝජ\u{dd2} ව\u{dd2}කරණක\u{dcf}රකය",
                "වර\u{dca}ණය",
                "සම",
                "සමෙහ\u{dd2} වර\u{dca}ගය-5",
                "ෆ\u{dca}ට\u{dca}ස\u{dca}පැට\u{dca}\u{200d}ර\u{dd2}ක\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("stredne tmavý tón pleti"),
            keywords: &[
                "koža",
                "odtieň",
                "pleť",
                "stredne tmavá",
                "stredne tmavý tón pleti",
                "tón",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("srednje temen ten kože"),
            keywords: &["srednje temen ten kože", "ten", "vrsta 5"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("jidh nooc madaw oo dhexe"),
            keywords: &["jidh", "jidh nooc madaw oo dhexe", "nooc 5"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("nuancë lëkure gjysmë e errët"),
            keywords: &["nuancë lëkure", "nuancë lëkure gjysmë e errët", "tipi V"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("средње тамна кожа"),
            keywords: &["бoja коже", "средње тамна кожа", "тип коже 5"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("srednje tamna koža"),
            keywords: &["boja kože", "srednje tamna koža", "tip kože 5"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("mellanmörk hy"),
            keywords: &["hud", "hudfärg", "hudton 5", "mellanmörk hy"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ngozi nyeusi kiasi"),
            keywords: &[
                "kibadilisha emoji",
                "ngozi",
                "ngozi nyeusi kiasi",
                "nyeusi",
                "sura",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வகை 5"),
            keywords: &["தோலின\u{bcd} நிறம\u{bcd}", "வகை 5"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మధ\u{c4d}యస\u{c4d}థంగ\u{c3e} ముదురు చర\u{c4d}మపు రంగు"),
            keywords: &[
                "చర\u{c4d}మం",
                "చర\u{c4d}మం ట\u{c4b}న\u{c4d}- 5",
                "ట\u{c4b}న\u{c4d}",
                "మధ\u{c4d}యస\u{c4d}థంగ\u{c3e} ముదురు చర\u{c4d}మపు రంగు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ранги торики миёнаи пӯст"),
            keywords: &["навъи 5", "ранги пӯст", "ранги торики миёнаи пӯст"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("โทนผ\u{e34}วส\u{e35}แทน"),
            keywords: &[
                "ผ\u{e34}วโทน 5",
                "โทนผ\u{e34}วส\u{e35}แทน",
                "โทนส\u{e35}ผ\u{e34}ว",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("orta goýy deri reňki"),
            keywords: &["deri reňki", "görnüş 5", "orta goýy deri reňki"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kili melomelo-ʻuliʻuli"),
            keywords: &[
                "faʻahinga 5",
                "kili",
                "kili melomelo-ʻuliʻuli",
                "melomelo",
                "ʻuliʻuli",
            ],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("orta koyu cilt tonu"),
            keywords: &["cilt tonu", "orta koyu cilt tonu", "tip 5"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئارا توق تېرە رەڭگى"),
            keywords: &["ئارا توق تېرە رەڭگى", "تۈر 5", "تېرە رەڭگى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("помірно темний тон шкіри"),
            keywords: &["помірно темний тон шкіри", "тон", "фіцпатрік", "шкіра"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جلد کی درمیانی سیاہ رنگت"),
            keywords: &[
                "اسکن",
                "ایموجی",
                "تبدیل کار",
                "جلد کی درمیانی سیاہ رنگت",
                "ٹون",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("5-teri turi"),
            keywords: &["5-teri turi", "emojini o‘zgartirish", "teri", "tus"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("màu da tối trung bình"),
            keywords: &["loại 5", "màu da", "màu da tối trung bình"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xeesaayu der bu xawa ñuul"),
            keywords: &["xeesaayu der", "xeesaayu der bu xawa ñuul", "xeet 5"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ithoni yesikhumba esiphakathi mnyama"),
            keywords: &[
                "ithoni yesikhumba",
                "ithoni yesikhumba esiphakathi mnyama",
                "uhlobo 5",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("adúláwọ\u{300} díẹ\u{300}"),
            keywords: &[
                "adúláwọ\u{300} díẹ\u{300}",
                "amọ\u{301}láwọ\u{300}",
                "irú 5",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("中深膚色"),
            keywords: &["中深膚色", "膚色", "類型 5"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("中深肤色"),
            keywords: &["中深肤色", "类型 5", "肤色"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("中等-深肤色"),
            keywords: &["中等-深肤色", "肤色"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("褐皮膚"),
            keywords: &["膚色", "褐皮膚"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("中深皮膚"),
            keywords: &["中深皮膚", "膚色"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uhlobo-5"),
            keywords: &["uhlobo 5", "uhlobo lwesikhumba", "uhlobo-5"],
        },
    ],
};
#[doc = "🏿"]
pub const DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🏿",
    codepoint: "1F3FF",
    status: crate::Status::Component,
    introduction_version: 1f32,
    name: "dark skin tone",
    group: "Component",
    subgroup: "skin-tone",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("donker velkleur"),
            keywords: &["donker velkleur", "kleur", "vel", "velkleur", "veltipe 6"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የቆዳ ዓይነት-6"),
            keywords: &["ስሜት ገላጭ አሻሻይ", "ቆዳ", "የቆዳ ዓይነት-6", "ድምፀት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بشرة بلون غامق"),
            keywords: &["بشرة بلون غامق", "تعديل", "جلد", "رمز", "لون", "نوع جلد 6"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক’ল\u{9be} ছ\u{9be}লৰ ৰং"),
            keywords: &[
                "ক’ল\u{9be} ছ\u{9be}লৰ ৰং",
                "ছ\u{9be}লৰ ৰং",
                "প\u{9cd}ৰক\u{9be}ৰ ৬",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("tünd dəri tonu"),
            keywords: &["emoji modifikatoru", "növ 6", "tünd dəri tonu"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("цёмны тон скуры"),
            keywords: &["колер скуры", "тып 6", "цёмны тон скуры"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("тъмна кожа"),
            keywords: &["кожа от тип 6", "тъмна кожа", "цвят на кожата"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9be}লো ত\u{9cd}বকের রঙ"),
            keywords: &[
                "ক\u{9be}লো ত\u{9cd}বকের রঙ",
                "ত\u{9cd}বকের টোন",
                "ত\u{9cd}বকের ধরন-6",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("tamna boja kože"),
            keywords: &["boja kože", "tamna boja kože", "tip 6"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pell molt fosca"),
            keywords: &["fosca", "pell", "pell molt fosca"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎵᏏᎩ ᎣᏁᎦᎸ ᏄᏍᏛᎢ"),
            keywords: &["ᎢᏳᏍᏗ 6", "ᎣᏁᎦᎸ ᏄᏍᏛᎢ", "ᎤᎵᏏᎩ ᎣᏁᎦᎸ ᏄᏍᏛᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("tmavý odstín pleti"),
            keywords: &["barva", "kůže", "pleť", "tmavý odstín pleti", "typ 6"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("arlliw croen tywyll"),
            keywords: &["arlliw croen tywyll", "lliw croen", "math 6"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mørk teint"),
            keywords: &["hudfarve", "mørk teint", "type 6"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("dunkle Hautfarbe"),
            keywords: &["Hautfarbe", "Hauttyp 6", "dunkle Hautfarbe"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σκούρος τόνος δέρματος"),
            keywords: &[
                "fitzpatrick",
                "σκούρος τόνος δέρματος",
                "τόνος δέρματος",
                "τύπου 6",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("dark skin tone"),
            keywords: &["dark skin tone", "skin tone", "type 6"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("tono de piel oscuro"),
            keywords: &[
                "piel",
                "tipo 6",
                "tono",
                "tono de piel",
                "tono de piel oscuro",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("tume nahatoon"),
            keywords: &["nahatoon", "nahk", "tume nahatoon", "tüüp 6"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("6. mota"),
            keywords: &["6. mota", "azalaren tonua"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پوست آبنوسی"),
            keywords: &[
                "اصلاح\u{200c}گر شکلک",
                "تن پوست",
                "رنگ پوست",
                "نوع ۶",
                "پوست",
                "پوست آبنوسی",
                "پوست تیره",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tumma iho"),
            keywords: &["emojin muokkaus", "fitzpatrick", "iho", "sävy", "tumma iho"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("dark na kulay ng balat"),
            keywords: &["dark na kulay ng balat", "kulay ng balat", "type 6"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("myrkur húðarlitur"),
            keywords: &["húðlitur", "myrk", "myrkur húðarlitur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("peau foncée"),
            keywords: &["peau", "peau foncée", "peau mate"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("peau foncée"),
            keywords: &["peau", "peau foncée", "type 6"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ton cnis dorcha"),
            keywords: &["cineál 6", "ton cnis", "ton cnis dorcha"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("tòna doilleir a’ chraicinn"),
            keywords: &[
                "seòrsa 6",
                "tòna a’ chraicinn",
                "tòna doilleir a’ chraicinn",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("ton de pel moi escuro"),
            keywords: &["tipo 6", "ton de pel", "ton de pel moi escuro"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઘ\u{ac7}રો ચામડીનો ર\u{a82}ગ"),
            keywords: &[
                "ઘ\u{ac7}રો ચામડીનો ર\u{a82}ગ",
                "ઘ\u{ac7}રો ત\u{acd}વચાનો ર\u{a82}ગ",
                "ત\u{acd}વચાનો પ\u{acd}રકાર-6",
                "ત\u{acd}વચાનો ર\u{a82}ગ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("launin fata mai duhu"),
            keywords: &["launin fata", "launin fata mai duhu", "nau’in 6"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גוון עור כהה"),
            keywords: &["גוון עור", "גוון עור כהה", "סוג 6"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सा\u{901}वली त\u{94d}वचा"),
            keywords: &[
                "गहरी सा\u{901}वली त\u{94d}वचा",
                "त\u{94d}वचा का र\u{902}ग",
                "सा\u{901}वली त\u{94d}वचा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tamno smeđa boja kože"),
            keywords: &[
                "boja",
                "emoji modifikator",
                "fitzpatrick",
                "koža",
                "tamno smeđa boja kože",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("sötét bőrtónus"),
            keywords: &["6-os típus", "bőrtónus", "sötét bőrtónus"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մուգ գույնի մաշկ"),
            keywords: &["մաշկի գույն", "մուգ գույնի մաշկ", "տիպ 6"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("tono de pelle obscur"),
            keywords: &["tono de pelle", "tono de pelle obscur", "typo 6"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("warna kulit gelap"),
            keywords: &["tipe 6", "warna kulit", "warna kulit gelap"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọtanjele ahụ maka òji"),
            keywords: &["ọtanjele ahụ", "ọtanjele ahụ maka òji", "ụdị 6"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("dökkur húðlitur"),
            keywords: &["dökkur húðlitur", "húðlitur", "tegund 6"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("carnagione scura"),
            keywords: &[
                "carnagione scura",
                "colore della pelle",
                "fototipo",
                "pelle scura",
                "tonalità",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("濃い肌色"),
            keywords: &["濃い肌色", "肌の色", "肌色6"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kulit ireng"),
            keywords: &["kulit ireng", "praupan kulit", "tipe 6"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კანის მუქი ტონალობა"),
            keywords: &[
                "ემოჯი მოდიფიკატორი",
                "კანი",
                "კანის მუქი ტონალობა",
                "ტონი",
                "ფიცპატრიკი",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tagwlimt tubrikt"),
            keywords: &["tagwlimt tubrikt"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("6-тері түсі"),
            keywords: &[
                "6-тері түсі",
                "Фицпатрик",
                "тері",
                "түсі",
                "эмодзи өзгертуші",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សម\u{17d2}ប\u{17bb}រខ\u{17d2}មៅ"),
            keywords: &[
                "ប\u{17d2}រភេទទ\u{17b8} 6",
                "សម\u{17d2}ប\u{17bb}រ",
                "សម\u{17d2}ប\u{17bb}រខ\u{17d2}មៅ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಗಾಢ ಬಣ\u{ccd}ಣದ ಚರ\u{ccd}ಮ"),
            keywords: &[
                "ಗಾಢ ಬಣ\u{ccd}ಣದ ಚರ\u{ccd}ಮ",
                "ಚರ\u{ccd}ಮದ ಬಣ\u{ccd}ಣ ಅತ\u{ccd}ಯಂತ ಗಾಢ",
                "ವ\u{cbf}ಧ 6",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("검은색 피부"),
            keywords: &["검은색 피부", "타입 육", "피부톤"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("गाढ कातीचो र\u{902}ग"),
            keywords: &["कातीचो र\u{902}ग", "गाढ कातीचो र\u{902}ग", "प\u{94d}रकार 6"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кара"),
            keywords: &["6-түр", "кара", "теринин өңү"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("däischter Hautfaarf"),
            keywords: &["Hautfaarf", "Typ 6", "däischter Hautfaarf"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb5}ສ\u{eb1}ນປະເພດ-6"),
            keywords: &[
                "ປະເພດ",
                "ສ\u{eb5}ສ\u{eb1}ນ",
                "ສ\u{eb5}ສ\u{eb1}ນປະເພດ-6",
                "ໂທນສ\u{eb5}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("itin tamsios odos"),
            keywords: &["itin tamsios odos", "odos atspalvis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("tumšs ādas tonis"),
            keywords: &["6. tips", "tumšs ādas tonis", "ādas tonis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kiri āhua parauri"),
            keywords: &["kiri āhua", "kiri āhua parauri", "momo 6"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("тип на кожа 6"),
            keywords: &["боја", "кожа", "модификатор на емотикона", "тип на кожа 6"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഇര\u{d41}ണ\u{d4d}ട ചർമ\u{d4d}മ നിറം"),
            keywords: &[
                "ഇര\u{d41}ണ\u{d4d}ട ചർമ\u{d4d}മ നിറം",
                "ചർമ\u{d4d}മ നിറം",
                "ചർമ\u{d4d}മത\u{d4d}തിന\u{d4d}റെ നിറം-6",
                "തരം 6",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бор"),
            keywords: &["арьсны өнгө", "бор", "төрөл 6"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("काळसर त\u{94d}वचा"),
            keywords: &[
                "काळसर त\u{94d}वचा",
                "त\u{94d}वच\u{947}चा प\u{94d}रकार",
                "त\u{94d}वच\u{947}चा प\u{94d}रकार-6",
                "प\u{94d}रकार 6",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("ton kulit gelap"),
            keywords: &["jenis 6", "ton kulit", "ton kulit gelap"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ton skur tal-ġilda"),
            keywords: &["tip 6", "ton skur tal-ġilda", "ton tal-ġilda"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အသားမ\u{1032}ရောင\u{103a}"),
            keywords: &[
                "အမျ\u{102d}\u{102f}းအစား ၆",
                "အသားမည\u{103a}းရောင\u{103a}",
                "အသားမ\u{1032}ရောင\u{103a}",
                "အသားအရေ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hudtype 6"),
            keywords: &[
                "emojimodifikator",
                "fitzpatrick",
                "hud",
                "hudfarge",
                "hudtype 6",
                "type 6",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("छालाको प\u{94d}रकार-६"),
            keywords: &[
                "इमोजी परिमार\u{94d}जक",
                "छाला",
                "छालाको प\u{94d}रकार-६",
                "टोन",
                "फिटपाट\u{94d}रिक",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("donkere huidskleur"),
            keywords: &["donkere huidskleur", "huidskleur", "type 6"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("hudtype 6"),
            keywords: &[
                "emojimodifikator",
                "fitzpatrick",
                "hud",
                "hudfarge",
                "hudtype 6",
                "type 6",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଗ\u{b3e}ଢ\u{b3c} ଚର\u{b4d}ମ ରଙ\u{b4d}ଗ"),
            keywords: &[
                "ଗ\u{b3e}ଢ\u{b3c} ଚର\u{b4d}ମ ରଙ\u{b4d}ଗ",
                "ଚର\u{b4d}ମ ରଙ\u{b4d}ଗ",
                "ପ\u{b4d}ରକ\u{b3e}ର 6",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਾਲਾ ਰ\u{a70}ਗ"),
            keywords: &[
                "ਇਮ\u{a4b}ਜੀ ਸ\u{a4b}ਧਕ",
                "ਕਾਲਾ ਰ\u{a70}ਗ",
                "ਚਮੜੀ ਦਾ ਰ\u{a70}ਗ",
                "ਟ\u{a4b}ਨ",
                "ਫਿਟਜਪ\u{a48}ਟਰਿਕ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کالی رنگت آلی جلد"),
            keywords: &["جلد دی رنگت", "قسم 6", "کالی رنگت آلی جلد"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Dák Skín Ton"),
            keywords: &["Dák Skín Ton", "Skín Ton", "Taip 6"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("karnacja ciemna"),
            keywords: &["karnacja", "karnacja ciemna", "odcień skóry", "typ 6"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("تور پوستکۍ"),
            keywords: &["تور پوستکۍ", "پوستکۍ", "ډول ۶"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pele escura"),
            keywords: &["pele escura", "tipo 6", "tom de pele"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("tipo de pele 6"),
            keywords: &[
                "cor de pele",
                "cor de pele escura",
                "tez escura",
                "tipo de pele 6",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("yana qara niraq"),
            keywords: &["6 kaq", "qara niraq", "yana qara niraq"],
        },
        #[cfg(feature = "rm")]
        crate::Annotation {
            lang: "rm",
            tts: Some("pel stgira"),
            keywords: &["colur da pel", "pel stgira", "tip 6"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ton închis al pielii"),
            keywords: &["nuanță", "piele", "tipul 6", "ton închis al pielii"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-444"),
            keywords: &["E10-444"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("очень темный тон кожи"),
            keywords: &[
                "кожа",
                "оттенок",
                "очень темный тон кожи",
                "тело",
                "темный",
                "цвет",
                "цвет кожи",
                "цвет кожи 6",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibara ry’uruhu rwirabura"),
            keywords: &["ibara ry’uruhu", "ibara ry’uruhu rwirabura", "ubwoko 6"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪارو رنگ"),
            keywords: &["رنگ", "قسم 6", "ڪارو رنگ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සමෙහ\u{dd2} වර\u{dca}ගය-6"),
            keywords: &[
                "ඉමෝජ\u{dd2} ව\u{dd2}කරණක\u{dcf}රකය",
                "වර\u{dca}ණය",
                "සම",
                "සමෙහ\u{dd2} වර\u{dca}ගය-6",
                "ෆ\u{dca}ට\u{dca}ස\u{dca}පැට\u{dca}\u{200d}ර\u{dd2}ක\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("tmavý tón pleti"),
            keywords: &["koža", "odtieň", "pleť", "tmavá", "tmavý tón pleti", "tón"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("temen ten kože"),
            keywords: &["temen ten kože", "ten", "vrsta 6"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("jidh madaw"),
            keywords: &["jidh", "jidh madaw", "nooc 6"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("nuancë lëkure e errët"),
            keywords: &["nuancë lëkure", "nuancë lëkure e errët", "tipi VI"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("тамна кожа"),
            keywords: &["бoja коже", "тамна кожа", "тип коже 6"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("tamna koža"),
            keywords: &["boja kože", "tamna koža", "tip kože 6"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("mörk hy"),
            keywords: &["hud", "hudfärg", "hudton 6", "mörk hy"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ngozi nyeusi"),
            keywords: &["kibadilisha emoji", "ngozi nyeusi", "nyeusi", "sura"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வகை 6"),
            keywords: &["தோலின\u{bcd} நிறம\u{bcd}", "வகை 6"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ముదురు చర\u{c4d}మపు రంగు"),
            keywords: &[
                "చర\u{c4d}మం",
                "చర\u{c4d}మం ట\u{c4b}న\u{c4d} - 6",
                "ట\u{c4b}న\u{c4d}",
                "ముదురు చర\u{c4d}మపు రంగు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ранги торики пӯст"),
            keywords: &["навъи 6", "ранги пӯст", "ранги торики пӯст"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("โทนผ\u{e34}วส\u{e35}เข\u{e49}ม"),
            keywords: &[
                "ผ\u{e34}วโทน 6",
                "โทนผ\u{e34}วส\u{e35}เข\u{e49}ม",
                "โทนส\u{e35}ผ\u{e34}ว",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("goýy deri reňki"),
            keywords: &["deri reňki", "goýy deri reňki", "görnüş 6"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kili ʻuliʻuli"),
            keywords: &["faʻahinga 6", "kili", "ʻuliʻuli"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("koyu cilt tonu"),
            keywords: &["cilt tonu", "koyu cilt tonu", "tip 6"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("توق تېرە رەڭ"),
            keywords: &["توق تېرە رەڭ", "تۈر 6", "تېرە رەڭگى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("темний тон шкіри"),
            keywords: &["темний тон шкіри", "тон", "фіцпатрік", "шкіра"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جلد کی سیاہ رنگت"),
            keywords: &["اسکن", "ایموجی", "تبدیل کار", "جلد کی سیاہ رنگت", "ٹون"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("6-teri turi"),
            keywords: &["6-teri turi", "emojini o‘zgartirish", "teri", "tus"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("màu da tối"),
            keywords: &["loại 6", "màu da", "màu da tối"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xeesaayu der bu ñuul"),
            keywords: &["xeesaayu der", "xeesaayu der bu ñuul", "xeet 6"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ithoni yesikhumba emnyama"),
            keywords: &["ithoni yesikhumba", "ithoni yesikhumba emnyama", "uhlobo 6"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("adúláwọ\u{300}"),
            keywords: &["adúláwọ\u{300}", "amọ\u{301}láwọ\u{300}", "irú 6"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("深膚色"),
            keywords: &["深膚色", "膚色", "類型 6"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("深肤色"),
            keywords: &["深肤色", "类型 6", "肤色"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("较深肤色"),
            keywords: &["肤色", "较深肤色"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("黑皮膚"),
            keywords: &["膚色", "黑皮膚"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uhlobo-6"),
            keywords: &["uhlobo 6", "uhlobo lwesikhumba", "uhlobo-6"],
        },
    ],
};
