#[doc = "🦰"]
pub const RED_HAIR: crate::Emoji = crate::Emoji {
    glyph: "🦰",
    codepoint: "1F9B0",
    status: crate::Status::Component,
    introduction_version: 11f32,
    name: "red hair",
    group: "Component",
    subgroup: "hair-style",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("rooi hare"),
            keywords: &["gemmer", "rooi hare", "rooikop"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቀይ ጸጉር"),
            keywords: &["ቀይ ጸጉር", "ጂንጀር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شعر أحمر"),
            keywords: &["أصهب", "رأس حمراء", "شعر أحمر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ৰঙ\u{9be} চ\u{9c1}লি"),
            keywords: &[
                "ৰঙচ\u{9c1}ৱ\u{9be} চ\u{9c1}লি",
                "ৰঙ\u{9be} চ\u{9c1}লি",
                "ৰঙ\u{9be} চ\u{9c1}লিৰ লোক",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qırmızı saç"),
            keywords: &["kürən", "qırmızı saç"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("рыжыя валасы"),
            keywords: &["руды", "рыжыя валасы"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("рижа коса"),
            keywords: &["риж човек", "рижа коса", "червенокос човек"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ল\u{9be}ল চ\u{9c1}ল"),
            keywords: &[
                "ল\u{9be}ল চ\u{9c1}ত\u{9cd}তয\u{9bc}\u{9be}ল\u{9be}",
                "ল\u{9be}ল চ\u{9c1}ল",
                "ল\u{9be}লচে হল\u{9c1}দ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("blev ruz"),
            keywords: &["blev", "blev ruz"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("crvena kosa"),
            keywords: &["crvena kosa", "crvenokos", "crvenokosa", "riđa", "riđast"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cabells vermells"),
            keywords: &["cabells vermells", "pèl-roig", "pèl-roja"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎩᎦᎨ ᎤᏍᏘᎦ"),
            keywords: &["ᎩᎦᎨ ᎠᏍᎪᎵ", "ᎩᎦᎨ ᎤᏍᏘᎦ", "ᎩᎦᎨ ᎤᏍᏘᏰᏅᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zrzavé vlasy"),
            keywords: &[
                "ryšavé vlasy, rusé vlasy, rudé vlasy, zrzek, zrzka",
                "zrzavé vlasy",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("gwallt coch"),
            keywords: &["gwallt coch", "melyngoch", "pen coch"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("rødt hår"),
            keywords: &["rødhåret", "rødt hår"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("rotes Haar"),
            keywords: &["Rotschopf", "rote Haare", "rotes Haar", "rothaarig"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κόκκινα μαλλιά"),
            keywords: &["κοκκινομάλλης", "κόκκινα μαλλιά", "πυρρόξανθος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("red hair"),
            keywords: &["ginger", "red hair", "redhead"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pelo pelirrojo"),
            keywords: &["pelirrojo", "pelo", "rojizo", "rojo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("pelirrojo"),
            keywords: &["pelirrojo"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("punased juuksed"),
            keywords: &["punajuus", "punapea", "punased juuksed"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ilegorri"),
            keywords: &["ilegorri", "kaskagorri"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("موقرمز"),
            keywords: &[
                "سرخ\u{200c}مو",
                "سرخ\u{200c}موی",
                "موسرخ",
                "موقرمز",
                "موی قرمز",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("punatukkainen"),
            keywords: &["punainen tukka", "punapää", "punatukkainen"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pulang buhok"),
            keywords: &["ginger", "pulang buhok", "pulang ulo"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("reytt hár"),
            keywords: &["hár", "reytt hár", "reyðhærdur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cheveux roux"),
            keywords: &["cheveux roux", "rouquin", "rouquine"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("gruaig rua"),
            keywords: &["duine le gruaig rua", "gruaig rua", "rua"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("falt ruadh"),
            keywords: &["falt", "ruadh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("pelo roxo"),
            keywords: &["cabelo", "pelo roxo", "roibo", "roxo", "rubio"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લાલ વાળ"),
            keywords: &["આછો ક\u{ac7}સરી", "લાલ વાળ", "લાલમાથ\u{ac1}\u{a82}"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שיער ג׳ינג׳י"),
            keywords: &["אדמוני", "ג׳ינג׳י", "שיער ג׳ינג׳י"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("लाल बाल"),
            keywords: &["लाल बाल", "लाल बालो\u{902} वाला"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("crvena kosa"),
            keywords: &["crvena kosa", "crvenokos", "riđokos"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("vörös haj"),
            keywords: &["vörös haj", "vöröshajú"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("շիկահեր"),
            keywords: &["հրագույն", "շիկահեր", "շիկամազ"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("capillos rosse"),
            keywords: &[
                "capillos rosse",
                "rossa",
                "rossastre",
                "rubee",
                "rubie",
                "rubre",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("rambut merah"),
            keywords: &["cokelat kemerahan", "rambut merah"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("rautt hár"),
            keywords: &["rautt hár", "rauðleitt hár"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("capelli rossi"),
            keywords: &["capelli rossi", "pel di carota", "rosso"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("赤毛"),
            keywords: &["赤毛", "赤毛の人", "赤茶"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rambut abang"),
            keywords: &["jae", "rambut abang", "rambute abang"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("წითელი თმა"),
            keywords: &["ჟღალი თმა", "წითელი თმა", "წითური"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("acekkuḥ azeggaɣ"),
            keywords: &["acekkuḥ azeggaɣ"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жирен шаш"),
            keywords: &["жирен", "жирен шаш", "қызыл бас"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សក\u{17cb}ក\u{17d2}រហម"),
            keywords: &[
                "ខ\u{17d2}ញ\u{17b8}",
                "មន\u{17bb}ស\u{17d2}សសក\u{17cb}ក\u{17d2}រហម",
                "សក\u{17cb}ក\u{17d2}រហម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{cc6}ಂಪು ಕ\u{cc2}ದಲು"),
            keywords: &[
                "ಕ\u{cc6}ಂಪು ಕ\u{cc2}ದಲು",
                "ಕ\u{cc6}ಂಪು ತಲ\u{cc6}",
                "ಶುಂಠ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("빨간 머리"),
            keywords: &["빨간 머리", "적갈색"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ता\u{902}बश\u{947}\u{902} क\u{947}\u{902}स"),
            keywords: &[
                "ता\u{902}बश\u{947}\u{902}",
                "ता\u{902}बश\u{947}\u{902} क\u{947}\u{902}स",
                "ता\u{902}बश\u{947}\u{902} क\u{947}\u{902}स आशिल\u{94d}ल\u{947}",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кызыл чач"),
            keywords: &["кызгылтым сары", "кызгылтым сары чачтуу", "кызыл чач"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{ebb}ມແດງ"),
            keywords: &["ຜ\u{ebb}ມແດງ", "ສ\u{eb5}ຂ\u{eb5}ງດອງ", "ຫ\u{ebb}ວແດງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("raudoni plaukai"),
            keywords: &["raudoni plaukai", "raudonplaukis", "rausvas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sarkani mati"),
            keywords: &["rudi mati", "sarkani mati"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("црвена коса"),
            keywords: &["црвена коса", "црвено-жолтеникава"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ച\u{d41}വന\u{d4d}ന മ\u{d41}ടി"),
            keywords: &[
                "ച\u{d41}വന\u{d4d}ന മ\u{d41}ടി",
                "ച\u{d41}വന\u{d4d}നതല",
                "ജിഞ\u{d4d}ചർ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("улаан үс"),
            keywords: &["улаан шаргал", "улаан үс", "улаан үстэй толгой"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("लाल क\u{947}स"),
            keywords: &["आल\u{947}", "लाल क\u{947}स", "लालडोक\u{947}"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("rambut merah"),
            keywords: &["berambut merah", "perang", "rambut merah"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဆ\u{1036}ပင\u{103a}န\u{102e}"),
            keywords: &[
                "ချင\u{103a}းတက\u{103a}န\u{102e}ရောင\u{103a}",
                "ဆ\u{1036}ပင\u{103a}န\u{102e}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("rødt hår"),
            keywords: &["rødhåring", "rødt hår"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("रातो कपाल"),
            keywords: &["अद\u{941}\u{901}वा", "रातो कपाल", "रातो टाउको"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("rood haar"),
            keywords: &["rood haar", "rooie", "rossig"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("raudt hår"),
            keywords: &["raudhåring", "raudt hår"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ନ\u{b3e}ଲ\u{b3f} କେଶ"),
            keywords: &[
                "ଅଦ\u{b3e}",
                "ନ\u{b3e}ଲ\u{b3f} କେଶ",
                "ନ\u{b3e}ଲ\u{b3f} ମ\u{b41}ଣ\u{b4d}ଡ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲਾਲ ਰ\u{a70}ਗ ਦ\u{a47} ਵਾਲ"),
            keywords: &[
                "ਲਾਲ ਰ\u{a70}ਗ ਦ\u{a47} ਵਾਲ",
                "ਲਾਲ ਵਾਲ",
                "ਲਾਲੀ ਮਾਰਦਾ ਪੀਲਾ ਰ\u{a70}ਗ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Rẹ\u{301}d Hea"),
            keywords: &["Jínja", "Rẹ\u{301}d Hea", "Rẹ\u{301}dhẹd"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("rude włosy"),
            keywords: &["ruda", "rude", "rude włosy", "rudy"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سره ويښتان"),
            keywords: &["جينګر", "سره ويښتان", "سور سر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cabelo vermelho"),
            keywords: &["cabelo vermelho", "ruivo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cabelo ruivo"),
            keywords: &["cabelo ruivo", "ruiva", "ruivo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("puka chukcha"),
            keywords: &["puka chukcha", "pukachukcha", "qillu niqcha"],
        },
        #[cfg(feature = "rm")]
        crate::Annotation {
            lang: "rm",
            tts: Some("chavels cotschens"),
            keywords: &["chavels cotschens"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("păr roșcat"),
            keywords: &["păr roșcat", "roșcat", "roșcată"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-033"),
            keywords: &["E11-033"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("рыжие волосы"),
            keywords: &["красный", "медный", "рыжая", "рыжие волосы", "рыжий"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڳاڙها وار"),
            keywords: &["ادرڪ", "ڳاڙها وار", "ڳاڙهو مٿو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("රත\u{dd4} කොණ\u{dca}ඩය"),
            keywords: &[
                "ඉඟ\u{dd4}ර\u{dd4}",
                "රත\u{dd4} කොණ\u{dca}ඩය",
                "රත\u{dd4} පැහැත\u{dd2}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ryšavé vlasy"),
            keywords: &["hrdzavý", "ryšavé vlasy", "červený"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("rdeči lasje"),
            keywords: &["rdečelasec", "rdeči lasje", "redečelas"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("timo cas"),
            keywords: &["madax cas", "sinjibiil", "timo cas"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("flokë të kuqe"),
            keywords: &["flokë të kuqe", "flokë të kuqërremtë", "kokëkuq", "kuqo"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("црвена коса"),
            keywords: &["црвена", "црвена коса", "црвенокос"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["црвена коса"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("crvena kosa"),
            keywords: &["crvena", "crvena kosa", "crvenokos"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["crvena kosa"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("rödhårig"),
            keywords: &["rödhårig", "röllig", "rött hår"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nywele nyekundu"),
            keywords: &["nyekundu", "nywele nyekundu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சிவப\u{bcd}பு முடி"),
            keywords: &[
                "சிவப\u{bcd}பு தலை",
                "சிவப\u{bcd}பு முடி",
                "ஜிஞ\u{bcd}சர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఎర\u{c4d}రట\u{c3f} జుట\u{c4d}టు"),
            keywords: &[
                "అల\u{c4d}లంరంగు",
                "ఎర\u{c4d}రజుట\u{c4d}టు ఉన\u{c4d}న తల",
                "ఎర\u{c4d}రట\u{c3f} జుట\u{c4d}టు",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ผมแดง"),
            keywords: &["ผมแดง", "ห\u{e31}วแดง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gyzyl saç"),
            keywords: &["gyzyl saç", "gyzylsaç", "zenjebil"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻulu kulokula"),
            keywords: &["kulokula", "ʻulu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kızıl saç"),
            keywords: &["kırmızı", "kızıl", "kızıl saç"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("руде волосся"),
            keywords: &["рижий", "руде волосся", "рудий", "рудоволосий"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سرخ بال"),
            keywords: &["ادرک", "سرخ بال", "سرخ سر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("malla soch"),
            keywords: &["malla", "qizil", "soch"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tóc đỏ"),
            keywords: &["tóc màu cam đỏ", "tóc màu đỏ", "tóc đỏ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("紅色頭髮"),
            keywords: &["生薑", "紅色嘅頭", "紅色頭髮"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("红色头发"),
            keywords: &["生姜", "红色嘅头", "红色头发"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("红发"),
            keywords: &["姜黄色", "红发"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("紅髮"),
            keywords: &["紅髮", "薑黃"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("izinwele ezibomvu"),
            keywords: &["ginger", "izinwele ezibomvu", "redhead"],
        },
    ],
};
#[doc = "🦱"]
pub const CURLY_HAIR: crate::Emoji = crate::Emoji {
    glyph: "🦱",
    codepoint: "1F9B1",
    status: crate::Status::Component,
    introduction_version: 11f32,
    name: "curly hair",
    group: "Component",
    subgroup: "hair-style",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("krulhare"),
            keywords: &["afro", "krul", "krulhare", "krulletjie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የተጠቀለለ ጸጉር"),
            keywords: &["አፍሮ", "የተጠቀለለ", "የተጠቀለለ ጸጉር", "ጉንጉን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شعر مجعد"),
            keywords: &["أفريقي", "جدائل", "شعر مجعد", "مجعد"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কে\u{981}কোৰ\u{9be} চ\u{9c1}লি"),
            keywords: &[
                "আফ\u{9cd}ৰ’",
                "কে\u{981}কোৰ\u{9be}",
                "কে\u{981}কোৰ\u{9be} চ\u{9c1}লি",
                "জ\u{981}ট লগ\u{9be} চ\u{9c1}লি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("buruq saç"),
            keywords: &["afro", "buruq", "buruq saç", "zülf"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("курчавыя валасы"),
            keywords: &["афра", "завіткі", "курчавыя валасы", "кучары"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("къдрава коса"),
            keywords: &["афро", "букли", "къдрава коса", "къдрици"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("কো\u{981}কড\u{9bc}\u{9be} চ\u{9c1}ল"),
            keywords: &[
                "আফ\u{9cd}রো",
                "ক\u{9c1}ঞ\u{9cd}চিত",
                "কো\u{981}কড\u{9bc}\u{9be}",
                "কো\u{981}কড\u{9bc}\u{9be} চ\u{9c1}ল",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("blev rodellek"),
            keywords: &["blev", "blev rodellek"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kovrdžava kosa"),
            keywords: &[
                "afro",
                "kovrdžav",
                "kovrdžava",
                "kovrdžava kosa",
                "kovrdže",
                "uvojci",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cabells arrissats"),
            keywords: &["afro", "cabells arrissats", "rínxols"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎵᏥᏍᏆᏁᏓ ᎤᏍᏘᎦ"),
            keywords: &["ᎤᎵᏥᏍᏆᏁᏓ", "ᎤᎵᏥᏍᏆᏁᏓ ᎤᏍᏘᎦ", "ᏙᏳ ᎤᎵᏥᏍᎪᏁᏓ", "ᏧᏃᏓᏊᏒᎵᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kudrnaté vlasy"),
            keywords: &[
                "afro",
                "kudrnaté vlasy",
                "kudrny",
                "prstýnky",
                "vlnité vlasy",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("gwallt cyrliog"),
            keywords: &["afro", "cudynnau", "cyrliog", "gwallt cyrliog"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("krøllet hår"),
            keywords: &["afro", "krøller", "krøllet hår"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("lockiges Haar"),
            keywords: &["Afro", "Lockenkopf", "lockig", "lockiges Haar"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σγουρά μαλλιά"),
            keywords: &["άφρο", "μπούκλες", "σγουρά", "σγουρά μαλλιά"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("curly hair"),
            keywords: &["afro", "curly", "curly hair", "ringlets"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pelo rizado"),
            keywords: &[
                "afro",
                "bucle",
                "pelo rizado",
                "rizado",
                "rizo",
                "tirabuzón",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("lokkis juuksed"),
            keywords: &["afrojuuksed", "krussis juuksed", "lokid", "lokkis juuksed"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ile kizkur"),
            keywords: &["afro", "ile kizkur", "kiribil", "kizkur"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("موفرفری"),
            keywords: &[
                "تابدار",
                "فرفری",
                "مجعد",
                "موفرفری",
                "موی فرفری",
                "موی مجعد",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kiharatukkainen"),
            keywords: &["afrotukka", "kihara tukka", "kiharatukkainen"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kulot na buhok"),
            keywords: &["afro", "kulot", "kulot na buhok", "ringlets"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("purlut hár"),
            keywords: &["afro", "hár", "krúllut", "purlut"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cheveux bouclés"),
            keywords: &["afro", "boucles", "bouclés", "cheveux bouclés"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("gruaig chatach"),
            keywords: &["afró", "catach", "gruaig chatach", "lúba"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("falt dualach"),
            keywords: &["Afraganach", "bachlach", "dualach", "falt"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("pelo rizado"),
            keywords: &["bucles", "cabelo", "pelo afro", "pelo rizado", "rizo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વા\u{a82}કડિયા વાળ"),
            keywords: &[
                "આફ\u{acd}રિકન વાળ",
                "વા\u{a82}કડિયા",
                "વા\u{a82}કડિયા વાળ",
                "વા\u{a82}કડિયાવાળની લટ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שיער מתולתל"),
            keywords: &["אפרו", "מתולתל", "שיער מתולתל", "תלתלים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("घ\u{941}\u{901}घराल\u{947} बाल"),
            keywords: &[
                "अफ\u{93c}\u{94d}रीकी",
                "घ\u{941}\u{901}घराला",
                "घ\u{941}\u{901}घराल\u{947} बाल",
                "बालो\u{902} की लट",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kovrčava kosa"),
            keywords: &["afro", "kovrčava", "kovrčava kosa", "lokne"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("göndör haj"),
            keywords: &["afro", "göndör", "göndör haj", "loknis"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("գանգրահեր"),
            keywords: &["աֆրո", "գանգուր", "գանգրահեր", "գանգրամազ", "խոպոպներ"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("capillos crispe"),
            keywords: &["afro", "buclate", "buclettas", "capillos", "crispe"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("rambut keriting"),
            keywords: &["afro", "ikal", "keriting", "rambut keriting"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("krullur"),
            keywords: &["afró", "krullað hár", "krullur", "lokkar"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("capelli ricci"),
            keywords: &["afro", "boccoli", "capelli ricci", "ricci"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("巻き毛"),
            keywords: &["くせ毛", "アフロ", "カール", "パンチパーマ", "巻き毛"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rambut brintik"),
            keywords: &["afro", "brintik", "prenthel-prenthel", "rambut brintik"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ხვეული თმა"),
            keywords: &["კულულები", "ხვეული თმა"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("acekkuḥ\u{a0}imdewweṛ"),
            keywords: &["acekkuḥ\u{a0}imdewweṛ"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бұйра шаш"),
            keywords: &["афро", "бұйра", "бұйра шаш", "бұйраланған"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សក\u{17cb}ក\u{17d2}រញាញ\u{17cb}"),
            keywords: &[
                "សក\u{17cb}ក\u{17d2}រញាញ\u{17cb}",
                "សក\u{17cb}ក\u{17d2}រញាញ\u{17cb}ទម\u{17d2}លាក\u{17cb}ច\u{17bb}ះក\u{17d2}រោម",
                "សក\u{17cb}ប\u{17c9}ោងក\u{17d2}រញាញ\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಗುಂಗುರು ಕ\u{cc2}ದಲು"),
            keywords: &[
                "ಆಫ\u{ccd}ರೋ",
                "ಕರ\u{ccd}ಲ\u{cbf}",
                "ಗುಂಗುರು ಕ\u{cc2}ದಲು",
                "ರ\u{cbf}ಂಗ\u{ccd}ಲ\u{cc6}\u{200c}ಟ\u{ccd}\u{200c}ಗಳು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("곱슬머리"),
            keywords: &["고수머리", "곱슬머리", "아프로"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("क\u{941}रळ\u{947} म\u{941}दयाळ\u{947}\u{902} क\u{947}\u{902}स"),
            keywords: &[
                "आफ\u{94d}रो",
                "क\u{941}रळ\u{947}",
                "क\u{941}रळ\u{947} क\u{947}\u{902}स",
                "क\u{941}रळ\u{947} म\u{941}दयाळ\u{947}\u{902} क\u{947}\u{902}स",
                "म\u{941}दयाळ\u{947}\u{902}",
                "रि\u{902}गल\u{947}ट\u{94d}स",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тармал чач"),
            keywords: &["афро", "тармал", "тармал чач", "тармалдашкан"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{ebb}ມກ\u{eb9}ດ"),
            keywords: &[
                "ຜ\u{ebb}ມກ\u{eb9}ດ",
                "ຜ\u{ebb}ມອາຟ\u{eb4}ກ",
                "ເປ\u{eb1}ນກ\u{ec9}ວນເປ\u{eb1}ນລອນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("garbanoti plaukai"),
            keywords: &["afro", "garbanos", "garbanotas", "garbanoti plaukai"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sprogaini mati"),
            keywords: &["afrikāņu", "sprogaini", "sprogaini mati", "sprogas"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("кадрава коса"),
            keywords: &["афро", "кадрава", "кадрава коса", "локни"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ച\u{d41}ര\u{d41}ണ\u{d4d}ട മ\u{d41}ടി"),
            keywords: &[
                "ആഫ\u{d4d}രോ",
                "ച\u{d41}ര\u{d41}ണ\u{d4d}ട മ\u{d41}ടി",
                "ച\u{d41}ര\u{d41}ണ\u{d4d}ടത\u{d4d}",
                "റിംഗ\u{d4d}\u{200c}ലെറ\u{d4d}റ\u{d41}കൾ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("буржгар үс"),
            keywords: &["афро", "буржгар", "буржгар үс", "ороосон үс"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("क\u{941}रळ\u{947} क\u{947}स"),
            keywords: &[
                "अ\u{945}फ\u{94d}रो",
                "क\u{941}रळ\u{947}",
                "क\u{941}रळ\u{947} क\u{947}स",
                "रि\u{902}गल\u{947}ट\u{94d}स",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("rambut kerinting"),
            keywords: &["afro", "bergelung", "kerinting", "rambut kerinting"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဆ\u{1036}ပင\u{103a}ကောက\u{103a}"),
            keywords: &[
                "ဆ\u{1036}န\u{103d}ယ\u{103a}ခ\u{103d}ေ",
                "ဆ\u{1036}ပင\u{103a}ကောက\u{103a}",
                "လ\u{1030}မည\u{103a}းဆ\u{1036}ပင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kruset hår"),
            keywords: &["afrikansk", "afro", "kruset hår", "krøllet"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("घ\u{941}म\u{94d}र\u{947}को कपाल"),
            keywords: &[
                "एफ\u{94d}रो",
                "घ\u{941}म\u{94d}र\u{947}को",
                "घ\u{941}म\u{94d}र\u{947}को कपाल",
                "रिङल\u{947}ट\u{94d}स",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("krullend haar"),
            keywords: &["afro", "krulhaar", "krullen", "krullend haar"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("krusete hår"),
            keywords: &["afrikansk", "afro", "krusete hår", "krøllete"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b41}ଞ\u{b4d}ଚ\u{b3f}ତ କେଶ"),
            keywords: &[
                "ଆଫ\u{b4d}ରୋ",
                "କ\u{b41}ଞ\u{b4d}ଚ\u{b3f}ତ",
                "କ\u{b41}ଞ\u{b4d}ଚ\u{b3f}ତ କେଶ",
                "ର\u{b3f}ଙ\u{b4d}ଗଲେଟସ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਘ\u{a41}\u{a70}ਗਰਾਲ\u{a47} ਵਾਲ"),
            keywords: &[
                "ਐਫ\u{a4d}ਰ\u{a4b}",
                "ਘ\u{a41}\u{a70}ਗਰਾਲ\u{a47}",
                "ਘ\u{a41}\u{a70}ਗਰਾਲ\u{a47} ਵਾਲ",
                "ਵਾਲਾ\u{a02} ਦ\u{a47} ਕ\u{a41}\u{a70}ਡਲ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kọ\u{301}lí Hea"),
            keywords: &[
                "Kọ\u{301}li",
                "Kọ\u{301}lí Hea",
                "Lọ\u{301}ng Kọ\u{301}lí Hea",
                "Rínglẹts",
                "Áfró",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kręcone włosy"),
            keywords: &[
                "afro",
                "kręcone",
                "kręcone włosy",
                "kędzierzawe",
                "kędzierzawy",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لوپه ويښتان"),
            keywords: &["افرو", "لوپه", "لوپه ويښتان", "کجک"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cabelo cacheado"),
            keywords: &["afro", "cabelo cacheado", "cacheado", "encaracolado"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cabelo encaracolado"),
            keywords: &["afro", "cabelo encaracolado", "caracóis", "encaracolado"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("qaspa chukcha"),
            keywords: &["afro", "qaspa", "qaspa chukcha", "qiwicha"],
        },
        #[cfg(feature = "rm")]
        crate::Annotation {
            lang: "rm",
            tts: Some("chavels ritschads"),
            keywords: &["chavels ritschads"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("păr creț"),
            keywords: &["afro", "bucle", "creț", "cârlionți", "păr creț"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-034"),
            keywords: &["E11-034"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("кудрявые волосы"),
            keywords: &[
                "афро",
                "кудри",
                "кудрявые волосы",
                "кудрявый",
                "химическая завивка",
                "химия",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("گهنگرالو وار"),
            keywords: &[
                "ايفرو",
                "رنگليٽس",
                "گهنگرالو وار",
                "گهنگهرالو",
                "گهنگهرالو وار",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("රොද සහ\u{dd2}ත කොණ\u{dca}ඩය"),
            keywords: &[
                "අප\u{dca}\u{200d}ර\u{dd2}ක\u{dcf}න\u{dd4}",
                "ක\u{dd4}ඩ\u{dcf} ම\u{dd4}ද\u{dd4}",
                "රොද සහ\u{dd2}ත",
                "රොද සහ\u{dd2}ත කොණ\u{dca}ඩය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kučeravé vlasy"),
            keywords: &["afro", "kučeravé vlasy", "vlnistý"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kodrasti lasje"),
            keywords: &["afro", "koder", "kodrast", "kodrasti lasje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("timo walaaqan"),
            keywords: &["timo adag", "timo laalaada", "timo walaaqan", "walaaqan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("flokë kaçurrele"),
            keywords: &["afro", "flokë kaçurrele", "kaçurrele", "rrica"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("коврџава коса"),
            keywords: &["афро", "коврџава коса", "коврџе"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kovrdžava kosa"),
            keywords: &["afro", "kovrdžava kosa", "kovrdže"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("lockigt hår"),
            keywords: &["afrohår", "korkskruvar", "lockar", "lockigt hår"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nywele yenye mawimbi"),
            keywords: &["afro", "mawimbi", "nywele yenye mawimbi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சுருட\u{bcd}டை முடி"),
            keywords: &[
                "ஆஃப\u{bcd}ரோ",
                "சுருட\u{bcd}டை",
                "சுருட\u{bcd}டை முடி",
                "சுருள\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఉంగర\u{c3e}ల జుట\u{c4d}టు"),
            keywords: &[
                "ఆఫ\u{c4d}ర\u{c4b}",
                "ఉంగర\u{c3e}ల జుట\u{c4d}టు",
                "ఉంగర\u{c3e}లు",
                "ర\u{c3f}ంగుల జుట\u{c4d}టు",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ผมหย\u{e34}ก"),
            keywords: &["ผมลอน", "ผมหย\u{e34}ก", "หย\u{e34}ก", "แอฟโฟร"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("buýra saç"),
            keywords: &["afro", "buýra", "buýra saç", "halkajyklar"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻulu mingimingi"),
            keywords: &["mingimingi", "ʻulu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kıvırcık saç"),
            keywords: &["afro", "kıvırcık", "kıvırcık saç", "lüle"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кучеряве волосся"),
            keywords: &[
                "афро",
                "волосся",
                "кудрі",
                "кучеряве волосся",
                "кучерявий",
                "кучері",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گھنگھریالے بال"),
            keywords: &["افریقی", "گھنگھریالے", "گھنگھریالے بال", "گیسو"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("jingalak soch"),
            keywords: &[
                "jingalak",
                "jingalak soch",
                "jingalak sochli",
                "kimyoviy",
                "kimyoviy ishlov berish",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tóc xoăn"),
            keywords: &["quăn", "tóc xoăn", "xoăn", "xù"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("曲髮"),
            keywords: &["捲曲", "捲髮", "曲髮", "非洲"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("曲发"),
            keywords: &["卷发", "卷曲", "曲发", "非洲"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("卷发"),
            keywords: &["卷发", "蓬松发", "鬈发"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("卷髮"),
            keywords: &["卷髮", "圓蓬", "捲髮", "長捲髮"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("曲髮"),
            keywords: &["曲髮", "爆炸頭", "長曲髮"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("curly hair"),
            keywords: &["afro", "curly", "curly hair", "ringlets"],
        },
    ],
};
#[doc = "🦳"]
pub const WHITE_HAIR: crate::Emoji = crate::Emoji {
    glyph: "🦳",
    codepoint: "1F9B3",
    status: crate::Status::Component,
    introduction_version: 11f32,
    name: "white hair",
    group: "Component",
    subgroup: "hair-style",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("wit hare"),
            keywords: &["grys", "hare", "oud", "wit"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ነጭ ጸጉር"),
            keywords: &["ነጭ", "አሮጌ", "ገብስማ", "ጸጉር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شعر أبيض"),
            keywords: &["أبيض", "رمادي", "شعر", "قديم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বগ\u{9be} চ\u{9c1}লি"),
            keywords: &[
                "চ\u{9c1}লি",
                "পক\u{9be} চ\u{9c1}লি",
                "বগ\u{9be}",
                "বয\u{9bc}স\u{9cd}ক",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ağ saç"),
            keywords: &["ağ", "boz", "qoca", "saç"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сівыя валасы"),
            keywords: &["белы", "валасы", "стары", "сівы", "сівыя валасы"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("побеляла коса"),
            keywords: &["бяла", "коса", "побеляла коса", "сива", "старост"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9be}দ\u{9be} চ\u{9c1}ল"),
            keywords: &[
                "চ\u{9c1}ল",
                "ধ\u{9c2}সর",
                "প\u{9cd}রবীণ",
                "স\u{9be}দ\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("blev gwenn"),
            keywords: &["blev", "blev gwenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("sijeda kosa"),
            keywords: &["sijed", "sijeda", "sijeda kosa", "sivo", "star", "stara"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cabells blancs"),
            keywords: &["ancià", "blanc", "cabells", "cabells blancs", "gris"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏁᎦ ᎤᏍᏘᎦ"),
            keywords: &["ᎠᎦᏴᎵ", "ᎠᏍᏘᏰᏅ", "ᎤᏁᎦ", "ᎤᏁᎦ ᎤᏍᏘᎦ", "ᎤᏍᎪᎸ ᏌᎪᏂᎨ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("bílé vlasy"),
            keywords: &["bílé vlasy", "stáří", "šediny", "šedé vlasy"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("gwallt gwyn"),
            keywords: &["gwallt", "gwyn", "hen", "llwyd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("hvidt hår"),
            keywords: &["gammel", "grå", "hvid", "hvidt hår", "hår"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("weißes Haar"),
            keywords: &[
                "grau",
                "graues Haar",
                "grauhaarig",
                "weißes Haar",
                "weißhaarig",
            ],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("weisses Haar"),
            keywords: &["weisses Haar"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άσπρα μαλλιά"),
            keywords: &["άσπρα", "γκρίζα", "ηλικιωμένος", "λευκά", "μαλλιά"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("white hair"),
            keywords: &["gray", "hair", "old", "white"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["grey", "hair", "old", "white"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["grey", "hair", "old", "white"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["gray", "grey", "hair", "old", "white"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["grey", "hair", "old", "white"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pelo blanco"),
            keywords: &["blanco", "cana", "gris", "pelo", "viejo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("pelo canoso"),
            keywords: &["pelo canoso"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("heledad juuksed"),
            keywords: &["hallid", "heledad juuksed", "juuksed", "valged", "vana"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ilezuri"),
            keywords: &["gris", "ile", "ilezuri", "zahar", "zuri"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("موسفید"),
            keywords: &[
                "خاکستری",
                "سفید",
                "موسفید",
                "موی خاکستری",
                "موی سفید",
                "پیر",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("valkotukkainen"),
            keywords: &["harmaa", "hiukset", "valkoinen", "valkotukkainen", "vanha"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("puting buhok"),
            keywords: &["buhok", "kulay abo", "matanda", "puti", "puting buhok"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hvítt hár"),
            keywords: &["gamal", "gomul", "hvítt", "hár"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cheveux blancs"),
            keywords: &["blancs", "cheveux", "gris", "vieux"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("gruaig bhán"),
            keywords: &["bán", "gruaig", "gruaig bhán", "liath", "sean"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("falt bàn"),
            keywords: &["bàn", "falt", "liath", "sean"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("pelo cano"),
            keywords: &["branco", "canas", "canoso", "gris", "pelo cano"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સફ\u{ac7}દ વાળ"),
            keywords: &["ગ\u{acd}ર\u{ac7}", "ઘરડા\u{a82}", "વાળ", "સફ\u{ac7}દ"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שיער לבן"),
            keywords: &["אפור", "זקן", "לבן", "שיער"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सफ\u{93c}\u{947}द बाल"),
            keywords: &[
                "बाल",
                "भ\u{942}रा",
                "व\u{943}द\u{94d}ध",
                "सफ\u{93c}\u{947}द",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("sijeda kosa"),
            keywords: &["bijela", "kosa", "sijeda", "star"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("ősz haj"),
            keywords: &["haj", "idős", "szürke", "ősz"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սպիտակահեր"),
            keywords: &["ալեհեր", "ծեր", "մազեր", "սպիտակ", "սպիտակահեր"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("capillos blanc"),
            keywords: &["blanc", "capillos", "gris", "vetere", "vetule"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("rambut putih"),
            keywords: &["abu-abu", "putih", "rambut", "tua"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hvítt hár"),
            keywords: &["gamalt", "grátt hár", "hvítt", "hár"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("capelli bianchi"),
            keywords: &["anziani", "bianchi", "capelli", "grigi"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("白髪"),
            keywords: &["グレー", "年配", "白髪", "老人", "高齢者"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rambut putih"),
            keywords: &["putih", "rambut", "tuwa", "uwan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("თეთრი თმა"),
            keywords: &["თეთრი", "თმა", "მოხუცი", "ჭაღარა"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("acekkuḥ\u{a0}amellal"),
            keywords: &["acekkuḥ\u{a0}amellal"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ақ шаш"),
            keywords: &["ақ", "сұр", "шаш", "қарт"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សក\u{17cb}ស"),
            keywords: &[
                "ចាស\u{17cb}",
                "ស",
                "សក\u{17cb}",
                "សក\u{17cb}ស",
                "ស\u{17d2}ក\u{17bc}វ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{cbf}ಳ\u{cbf} ಕ\u{cc2}ದಲು"),
            keywords: &[
                "ಕ\u{cc2}ದಲು",
                "ಬ\u{cbf}ಳ\u{cbf}",
                "ಬ\u{cc2}ದು",
                "ಹಳ\u{cc6}ಯ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("백발"),
            keywords: &["머리", "백발", "은발", "장년"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("धव\u{947} क\u{947}\u{902}स"),
            keywords: &[
                "क\u{947}\u{902}स",
                "जाण\u{94d}ट\u{947}\u{902}",
                "धव\u{947} क\u{947}\u{902}स",
                "धव\u{947}\u{902}",
                "पिक\u{947} क\u{947}\u{902}स",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ак чач"),
            keywords: &["ак", "буурул", "кары", "чач"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{ebb}ມຫອກ"),
            keywords: &[
                "ຂາວ",
                "ຜ\u{ebb}ມຫອກ",
                "ສ\u{eb5}ເທ\u{ebb}າ",
                "ເສ\u{eb1}\u{ec9}ນຜ\u{ebb}ມ",
                "ແກ\u{ec8}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žili plaukai"),
            keywords: &["baltas", "pilkas", "plaukai", "senas", "žili plaukai"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sirmi mati"),
            keywords: &["mati", "pelēki", "sirmi", "vecs"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("бела коса"),
            keywords: &["бела", "коса", "седа", "стар"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വെള\u{d4d}ള മ\u{d41}ടി"),
            keywords: &[
                "ഗ\u{d4d}രേ",
                "മ\u{d41}ടി",
                "വയസ\u{d4d}സ\u{d3e}യത\u{d4d}",
                "വെള\u{d4d}ള",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цагаан үс"),
            keywords: &["настай", "саарал", "цагаан", "үс"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पा\u{902}ढर\u{947} क\u{947}स"),
            keywords: &[
                "करड\u{947}",
                "क\u{947}स",
                "पा\u{902}ढर\u{947}",
                "पिकल\u{947}ल\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("rambut putih"),
            keywords: &["beruban", "putih", "rambut", "tua"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဆ\u{1036}ပင\u{103a}ဖြ\u{1030}"),
            keywords: &[
                "ဆ\u{1036}ပင\u{103a}",
                "ဆ\u{1036}ပင\u{103a}ဖြ\u{1030}",
                "သက\u{103a}ကြ\u{102e}း",
                "အဖြ\u{1030}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("grått hår"),
            keywords: &["gammel", "grå", "grått hår", "hvit", "hår"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{947}तो कपाल"),
            keywords: &["कपाल", "ख\u{948}रो", "प\u{941}रानो", "स\u{947}तो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("wit haar"),
            keywords: &["grijs", "haar", "oud", "wit"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("grått hår"),
            keywords: &["gamal", "grå", "grått hår", "hår", "kvit"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଧଳ\u{b3e} କେଶ"),
            keywords: &["କେଶ", "ଗ\u{b4d}ରେ", "ଧଳ\u{b3e}", "ପ\u{b41}ର\u{b41}ଣ\u{b3e}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚਿ\u{a71}ਟ\u{a47} ਵਾਲ"),
            keywords: &["ਗ\u{a4d}ਰ\u{a47}", "ਚਿ\u{a71}ਟ\u{a47}", "ਵਧਦੀ ਉਮਰ", "ਵਾਲ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Waít Hea"),
            keywords: &["Gre", "Hea", "Old", "Wait", "Waít Hea"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("białe włosy"),
            keywords: &["białe", "siwe", "starsza", "starszy", "włosy"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سپين ويښتان"),
            keywords: &["بوډا", "خړ", "سپين", "ويښتان"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cabelo branco"),
            keywords: &["branco", "cabelo", "grisalho", "velho"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cabelo branco"),
            keywords: &["brancas", "branco", "cabelho grisalho", "cabelo", "velho"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("yuraq chukcha"),
            keywords: &["chukcha", "machu", "uqi", "yuraq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("păr alb"),
            keywords: &["alb", "bătrân", "grizonat", "păr"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-036"),
            keywords: &["E11-036"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("седые волосы"),
            keywords: &[
                "волосы",
                "пожилой",
                "седина",
                "седой",
                "седые волосы",
                "старый",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اڇا وار"),
            keywords: &["اڇا وار", "اڇو", "وار", "پراڻا", "ڀورا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dd4}ද\u{dd4} කොන\u{dca}ඩය"),
            keywords: &[
                "අළ\u{dd4}",
                "කොණ\u{dca}ඩය",
                "වයස",
                "ස\u{dd4}ද\u{dd4}",
                "ස\u{dd4}ද\u{dd4} කොන\u{dca}ඩය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("sivé vlasy"),
            keywords: &["biely", "sivé vlasy", "starý"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("sivi lasje"),
            keywords: &["bel", "lasje", "siv", "sivi lasje", "star"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("caddaan"),
            keywords: &["caddaan", "gaboobay", "sibidhi", "timo", "timo cad"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("flokë të bardha"),
            keywords: &[
                "flokë",
                "flokë të bardha",
                "gri",
                "i moshuar",
                "thinja",
                "të bardha",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("седа коса"),
            keywords: &["бела", "коса", "седа", "старо"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("сиједа коса"),
            keywords: &["сиједа коса"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("seda kosa"),
            keywords: &["bela", "kosa", "seda", "staro"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("sijeda kosa"),
            keywords: &["sijeda kosa"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("vithårig"),
            keywords: &["gammal", "grått hår", "vithårig", "vitt hår"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nywele nyeupe"),
            keywords: &["kijivu", "mzee", "nyeupe", "nywele"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வெள\u{bcd}ளை முடி"),
            keywords: &["நரை", "பழுப\u{bcd}பு", "முடி", "வெள\u{bcd}ளை"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("త\u{c46}ల\u{c4d}లజుట\u{c4d}టు"),
            keywords: &[
                "జుట\u{c4d}టు",
                "త\u{c46}లుపు",
                "త\u{c46}ల\u{c4d}లజుట\u{c4d}టు",
                "న\u{c46}ర\u{c3f}స\u{c3f}ప\u{c4b}వడం",
                "ముసల\u{c3f}తనం",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ผมขาว"),
            keywords: &["ขาว", "ผม", "ผมขาว", "หงอก", "แก\u{e48}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ak saç"),
            keywords: &["ak", "garry", "saç", "çal"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻulu hinā"),
            keywords: &["hinā", "ʻulu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("beyaz saç"),
            keywords: &["beyaz", "gri", "saç", "yaşlı"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("сиве волосся"),
            keywords: &["білий", "волосся", "сиве волосся", "сивина", "старий"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سفید بال"),
            keywords: &["بال", "بوڑھا", "خاکستری", "سفید"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("oqargan soch"),
            keywords: &["oq", "oqargan", "qari", "soch"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tóc trắng"),
            keywords: &["bạc", "trắng", "tóc", "xám"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("白色頭髮"),
            keywords: &["灰色", "白色", "白色頭髮", "老", "頭髮"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("白色头发"),
            keywords: &["头发", "灰色", "白色", "白色头发", "老"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("白发"),
            keywords: &["头发", "年老", "灰色", "白发", "白色"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("白髮"),
            keywords: &["灰色", "白色", "白髮", "老", "頭髮"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("白頭髮"),
            keywords: &["灰色", "白色", "白頭髮", "老", "頭髮"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("izinwele ezimpunga"),
            keywords: &[
                "gray",
                "hair",
                "izinwele ezimhlophe",
                "izinwele ezimpunga",
                "old",
                "white",
            ],
        },
    ],
};
#[doc = "🦲"]
pub const BALD: crate::Emoji = crate::Emoji {
    glyph: "🦲",
    codepoint: "1F9B2",
    status: crate::Status::Component,
    introduction_version: 11f32,
    name: "bald",
    group: "Component",
    subgroup: "hair-style",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("bles"),
            keywords: &[
                "bles",
                "chemoterapie",
                "haarloos",
                "kaalgeskeerde kop",
                "kaalkop",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መላጣ"),
            keywords: &["መላጣ", "ኬሞቴራፒ", "የተላጨ", "ጸጉር የሌለው"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("أصلع"),
            keywords: &[
                "أصلع",
                "العلاج الكيميائي",
                "بدون شعر",
                "بلا شعر",
                "شعر محلوق",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("টপ\u{9be} ম\u{9c2}ৰীয\u{9bc}\u{9be}"),
            keywords: &[
                "কেম’থেৰ\u{9be}পী",
                "চ\u{9c1}লি নোহোৱ\u{9be}",
                "চ\u{9c1}লিবিহীন",
                "টপ\u{9be} ম\u{9c2}ৰীয\u{9bc}\u{9be}",
                "ম\u{9c1}ণ\u{9cd}ডন কৰ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("keçəl"),
            keywords: &["keçəl", "kimya terapiyası", "qırxılmış", "saçsız"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("лысы"),
            keywords: &["без валасоў", "голены", "лысы", "хіміятэрапія"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("плешив човек"),
            keywords: &[
                "без коса",
                "без коса от лъчетерапия",
                "избръснат",
                "няма коса",
                "плешив човек",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("নেড\u{9bc}\u{9be}"),
            keywords: &[
                "ক\u{9be}ম\u{9be}নো",
                "কেমোথের\u{9be}পি",
                "চ\u{9c1}ল নেই",
                "চ\u{9c1}ল হীন",
                "নেড\u{9bc}\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("moal"),
            keywords: &["blev", "moal"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ćelavo"),
            keywords: &[
                "bez kose",
                "hemoterapija",
                "obrijan",
                "obrijana",
                "obrijano",
                "ćelavo",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("calvície"),
            keywords: &[
                "calb",
                "calba",
                "calvície",
                "cap afaitat",
                "quimioteràpia",
                "sense cabells",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎨᏬᏗ"),
            keywords: &["ᎠᏓᏰᏍᎩ ᏳᎾᎵᏍᏓᏁᎯ ᎨᏥᏅᏬᏙᏗ", "ᎤᎨᏬᏗ", "ᎤᎵᏍᏙᏰᏓ", "ᏄᏍᏘᎬᎾ", "Ꮭ ᏳᏍᏘᎦ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("bez vlasů"),
            keywords: &[
                "bez vlasů",
                "chemoterapie",
                "pleš",
                "skin",
                "skinhead",
                "vyholená hlava",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("moel"),
            keywords: &["cemotherapi", "dim gwallt", "moel", "wedi eillio"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("skaldet"),
            keywords: &[
                "barberet",
                "ingen hår",
                "kemoterapi",
                "kronraget",
                "skaldet",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Glatze"),
            keywords: &["Chemo", "Glatze", "haarlos", "kein Haar", "rasiert"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καραφλός"),
            keywords: &["καραφλός", "ξυρισμένος", "χημειοθεραπεία", "χωρίς μαλλιά"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("bald"),
            keywords: &["bald", "chemotherapy", "hairless", "no hair", "shaven"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("sin pelo"),
            keywords: &[
                "afeitado",
                "bola de billar",
                "calvo",
                "quimioterapia",
                "sin pelo",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "calvo",
                "quimioterapia",
                "rapado",
                "sin cabello",
                "sin pelo",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("calvo"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kiilaspea"),
            keywords: &[
                "juukseid pole",
                "juusteta",
                "keemiaravi",
                "kiilaspea",
                "raseeritud",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("burusoil"),
            keywords: &[
                "burusoil",
                "ilegabe",
                "ilerik gabe",
                "kimioterapia",
                "soildu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تاس"),
            keywords: &[
                "بدون مو",
                "بی\u{200c}مو",
                "تاس",
                "تراشیده",
                "شیمی\u{200c}درمانی",
                "طاس",
                "کچل",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kalju"),
            keywords: &["ajeltu", "ei tukkaa", "kalju", "kemoterapia"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kalbo"),
            keywords: &["kalbo", "kimoterapya", "kinalbo", "walang buhok"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("skallutur"),
            keywords: &["einki hár", "hár", "kemoterapi", "skallut", "skallutur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("chauve"),
            keywords: &[
                "chauve",
                "chimiothérapie",
                "imberbe",
                "rasé",
                "sans cheveux",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("maol"),
            keywords: &[
                "bearrtha",
                "blagaid",
                "ceimiteiripe",
                "gan ghruaig",
                "gruaig ar bith",
                "maol",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("maoilean"),
            keywords: &[
                "aillse",
                "bearradh",
                "bearrte",
                "ceimeo-theiripe",
                "gun fhalt",
                "lom",
                "maoilean",
                "maol",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("sen pelo"),
            keywords: &["calva", "quimioterapia", "rapado", "sen pelo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ટાલ"),
            keywords: &[
                "કીમોથ\u{ac7}રાપી",
                "ટકો",
                "ટાલ",
                "વાળ નહી\u{a82}",
                "વાળ વગર",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קירח"),
            keywords: &["בלי שיער", "כימותרפיה", "ללא שיער", "מגולח", "קירח"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ग\u{902}जा"),
            keywords: &[
                "कीमोथ\u{948}र\u{947}पी",
                "ग\u{902}जा",
                "बाल नही\u{902}",
                "बिना बालो\u{902} क\u{947}",
                "म\u{941}\u{901}डा ह\u{941}आ",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("bez kose"),
            keywords: &["bez kose", "kemoterapija", "obrijano", "ćelav"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kopasz"),
            keywords: &["borotvált", "haj nélkül", "kemoterápia", "kopasz", "tar"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ճաղատ"),
            keywords: &["անմազ", "ճաղատ", "սափրված", "քաչալ"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("calve"),
            keywords: &["calve", "chemotherapia", "glabre", "rasate", "sin capillos"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("gundul"),
            keywords: &["botak", "gundul", "kemoterapi", "tak berambut"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("skalli"),
            keywords: &[
                "hárleysi",
                "hárlos",
                "lyfjameðferð",
                "rakað höfuð",
                "skalli",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("calvo"),
            keywords: &["calvizie", "calvo", "chemioterapia", "pelato", "rasato"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("はげ頭"),
            keywords: &["はげ頭", "スキンヘッド", "化学療法", "坊主", "毛がない"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("buthak"),
            keywords: &[
                "buthak",
                "gundhul",
                "kemoterapi",
                "ora duwe rambut",
                "plenthas",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მელოტი"),
            keywords: &["მელოტი", "ქიმიოთერაპია"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("aferḍas"),
            keywords: &["aferḍas"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тақырбас"),
            keywords: &[
                "тақырбас",
                "химиотерапия",
                "шаш жоқ",
                "шашсыз",
                "қырып тастаған",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ទ\u{17c6}ពែក"),
            keywords: &[
                "ការព\u{17d2}យាបាលតាមបែបគ\u{17b8}ម\u{17b8}",
                "គ\u{17d2}មានសក\u{17cb}",
                "ទ\u{17c6}ពែក",
                "បានកោរ",
                "អត\u{17cb}សក\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬಕ\u{ccd}ಕ ತಲ\u{cc6}"),
            keywords: &[
                "ಕೀಮೋಥ\u{cc6}ರಪ\u{cbf}",
                "ಕ\u{cc2}ದಲು ಇಲ\u{ccd}ಲ",
                "ಕ\u{cc2}ದಲುರಹ\u{cbf}ತ",
                "ಕ\u{ccd}ಷ\u{ccc}ರ ಮಾಡ\u{cbf}ರುವುದು",
                "ಬಕ\u{ccd}ಕ ತಲ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("대머리"),
            keywords: &["대머리", "맨머리", "민머리", "벗겨진 머리"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("तकलो"),
            keywords: &[
                "क\u{945}मोथ\u{945}र\u{945}पी",
                "क\u{947}\u{902}स ना",
                "क\u{947}\u{902}सनाशिल\u{94d}लो",
                "तकलो",
                "त\u{941}ळत\u{941}ळीत",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тас"),
            keywords: &["кырылган", "тас", "химия терапия", "чач жок", "чачсыз"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{ebb}ວລ\u{ec9}ານ"),
            keywords: &[
                "ການຮ\u{eb1}ກສາດ\u{ec9}ວຍ ກ\u{eb5}ໂມ",
                "ບ\u{ecd}\u{ec8}ມ\u{eb5}ຜ\u{ebb}ມ",
                "ຜ\u{ebb}ມລ\u{ebb}\u{ec8}ນ",
                "ຫ\u{ebb}ວລ\u{ec9}ານ",
                "ແຖມຜ\u{ebb}ມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("plikas"),
            keywords: &["beplaukis", "chemoterapija", "plikas", "skustas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("bez matiem"),
            keywords: &["bez matiem", "nav matu", "skūts", "ķīmijterapija"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("ќелав"),
            keywords: &[
                "без влакна",
                "без коса",
                "избричено",
                "хемотерапија",
                "ќелав",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കഷണ\u{d4d}ടി"),
            keywords: &[
                "കഷണ\u{d4d}ടി",
                "കഷണ\u{d4d}ടിയ\u{d3e}യ",
                "കീമോതെറ\u{d3e}പ\u{d4d}പി",
                "മ\u{d41}ടിയില\u{d4d}ല",
                "മൊട\u{d4d}ടയടിച\u{d4d}ച",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("халзан"),
            keywords: &[
                "халзан",
                "химийн эмчилгээ",
                "үс байхгүй",
                "үсгүй",
                "үсээ хусуулсан",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("टक\u{94d}कल"),
            keywords: &[
                "क\u{947}मोथ\u{947}रपी",
                "क\u{947}स नसल\u{947}ल\u{947}",
                "क\u{947}स नाही",
                "टक\u{94d}कल",
                "दाढी क\u{947}ल\u{947}ल\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("botak"),
            keywords: &[
                "bercukur",
                "botak",
                "kemoterapi",
                "tiada rambut",
                "tidak berambut",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ထ\u{102d}ပ\u{103a}ပြောင\u{103a}"),
            keywords: &[
                "က\u{102e}မ\u{102d}\u{102f}",
                "ဆ\u{1036}ပင\u{103a}မရ\u{103e}\u{102d}",
                "ထ\u{102d}ပ\u{103a}ပြောင\u{103a}",
                "ရ\u{102d}တ\u{103a}ထားသည\u{103a}",
                "အမ\u{103d}ေးမရ\u{103e}\u{102d}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("skallet"),
            keywords: &["barbert", "hårløs", "kjemoterapi", "skallet", "uten hår"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ताल\u{941} ख\u{941}इल\u{947}"),
            keywords: &[
                "कपाल नभएको",
                "क\u{947}मोथ\u{947}रापी",
                "ख\u{941}र\u{94d}क\u{947}को",
                "टक\u{94d}ल\u{941}",
                "ताल\u{941} ख\u{941}इल\u{947}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kaal"),
            keywords: &[
                "chemotherapie",
                "geen haar",
                "geschoren",
                "haarloos",
                "kaal",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("skalla"),
            keywords: &["barbert", "hårlaus", "kjemoterapi", "skalla", "utan hår"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଚନ\u{b4d}ଦ\u{b3e}"),
            keywords: &[
                "କ\u{b3f}ମୋଥେର\u{b3e}ପ\u{b3f}",
                "କୌଣସ\u{b3f} କେଶ ନ\u{b3e}ହ\u{b3f}\u{b01}",
                "ଖ\u{b3f}ଅର ହେବ\u{b3e}",
                "ଚନ\u{b4d}ଦ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਗ\u{a70}ਜਾ ਸਿਰ"),
            keywords: &[
                "ਕੀਮ\u{a4b}ਥ\u{a48}ਰ\u{a47}ਪੀ",
                "ਕ\u{a4b}ਈ ਵਾਲ ਨਹੀ\u{a02}",
                "ਗ\u{a70}ਜਾ ਸਿਰ",
                "ਮ\u{a41}\u{a70}ਨਿਆ ਸਿਰ",
                "ਵਾਲ-ਹੀਣ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bọld"),
            keywords: &[
                "Bọld",
                "Kimótẹ\u{301}rápi",
                "Nó Hea",
                "Shév Ọ\u{301}l Hea Kọmọ\u{301}t Fọ Hẹd",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("łysy"),
            keywords: &[
                "bez włosów",
                "bezwłosa",
                "bezwłosy",
                "chemioterapia",
                "ogolona",
                "łysy",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ګنجى"),
            keywords: &["بې ويښانو", "بې ويښتو", "خرېدلې", "کيموتراپي", "ګنجى"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("careca"),
            keywords: &[
                "careca",
                "nenhum cabelo",
                "quimioterapia",
                "raspado",
                "sem cabelo",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("careca"),
            keywords: &[
                "careca",
                "nenhum cabelo",
                "quimioterapia",
                "rapado",
                "raspado",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("paqla"),
            keywords: &[
                "hairless",
                "mana chukchayuq",
                "paqla",
                "quimioterapia",
                "rutusqa",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("chelie"),
            keywords: &["chelie", "chimioterapie", "fără păr", "ras"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-035"),
            keywords: &["E11-035"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("без волос"),
            keywords: &["без волос", "бритый", "лысый", "химиотерапия"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("گنجو"),
            keywords: &["بنا وار", "ڪو به وار نه", "ڪوڙيل", "ڪيمو ٿيراپي", "گنجو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("තට\u{dca}ට"),
            keywords: &[
                "කොණ\u{dca}ඩය නැත\u{dd2}",
                "තට\u{dca}ට",
                "ම\u{dd4}ඩ",
                "රස\u{dcf}යන\u{dd2}ක ච\u{dd2}ක\u{dd2}ත\u{dca}ස\u{dcf}ව",
                "හ\u{dd2}සකෙස\u{dca} නැත\u{dd2}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("holá hlava"),
            keywords: &[
                "bezvlasý",
                "holá hlava",
                "lysý",
                "plešatý",
                "plešivý",
                "vyholený",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("plešast"),
            keywords: &["brez las", "kamoterapija", "obrit", "plešast"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("bidaar"),
            keywords: &["bidaar", "bilaa timo", "kimiko ku dawayn", "xiiran"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("qeros"),
            keywords: &["kimo-terapi", "kokërruar", "pa flokë", "qeros"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("ћелав"),
            keywords: &["без косе", "обријан", "хемотерапија", "ћелав"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ćelav"),
            keywords: &["bez kose", "hemoterapija", "obrijan", "ćelav"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("skallig"),
            keywords: &["kemoterapi", "skallig", "skinhead", "utan hår"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("upara"),
            keywords: &[
                "bila nywele",
                "kichwa kilichonyolewa",
                "tibakemikali",
                "upara",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வழுக\u{bcd}கை"),
            keywords: &[
                "க\u{bc0}மோதெரபி",
                "சவரம\u{bcd}",
                "முடியில\u{bcd}லை",
                "மொட\u{bcd}டை",
                "வழுக\u{bcd}கை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బట\u{c4d}టతల"),
            keywords: &[
                "క\u{c40}మ\u{c4b}థ\u{c46}రప\u{c40}",
                "జుట\u{c4d}టు ర\u{c3e}ల\u{c3f}ప\u{c4b}వడం",
                "జుట\u{c4d}టు ల\u{c47}దు",
                "బట\u{c4d}టతల",
                "బ\u{c4b}డ\u{c3f} చ\u{c47}స\u{c3e}రు",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ห\u{e31}วล\u{e49}าน"),
            keywords: &[
                "ค\u{e35}โม",
                "สก\u{e34}นเฮด",
                "ห\u{e31}วล\u{e49}าน",
                "โกนห\u{e31}ว",
                "ไม\u{e48}ม\u{e35}ผม",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kel"),
            keywords: &["himioterapiýa", "kel", "saç ýok", "saçsyz", "syrylan"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻulu tula"),
            keywords: &["kosi", "tula", "ʻulu", "ʻulupoko"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kel"),
            keywords: &["kel", "kemoterapi", "saç yok", "saçsız", "tıraşlı"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("лиса голова"),
            keywords: &[
                "без волосся",
                "виголений",
                "лиса голова",
                "немає волосся",
                "хіміотерапія",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گنجا"),
            keywords: &["شیو کیا ہوا", "کوئی بال نہیں", "کیمیائی علاج", "گنجا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kal"),
            keywords: &["kal", "kallik", "siyqa", "sochi yo‘q", "toz", "ustara"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hói"),
            keywords: &["cạo nhẵn", "hóa trị", "hói", "không có tóc", "trụi tóc"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("光頭"),
            keywords: &["光頭", "剃頭", "化療", "無頭髮"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("光头"),
            keywords: &["光头", "剃头", "化疗", "无头发"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("秃顶"),
            keywords: &["光头", "化疗", "秃顶"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("禿頭"),
            keywords: &["光頭", "剃頭", "化療", "沒頭髮", "禿頭"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("imbungculu"),
            keywords: &[
                "chemotherapy",
                "hairless",
                "imbungculu",
                "no hair",
                "shaven",
            ],
        },
    ],
};
